# How to make a movie

By pressing `y` in `play` you can export the current display into an image file.
Moreover, if you have a recorded trajectory generated by 'sim', you can generate
multiple images automatically either 'on-screen' or 'off-screen'. These images
can be assembled into a movie using freely available tools, particularly `ImageJ` or `ffmpeg`.

The format of the images generated by `play`, which may be PNG or PPM, depends on the libraries with
which 'play' was linked during compilation. It can be queried by 'play info'.


# Generating the images

Play has a menu 'Export' which can be used to save images.
The keyboard shortcut is 'y' for one image and 'Y' for all images in the file.

Play may also be able to generate images 'off-screen' without opening a window,
but this is not supported on all platforms. In this case, 'play' needs to be
invoked from the command line, in one of this mode:

 
Command                          |   Result                                   |
---------------------------------|---------------------------------------------
`play image frame=3`             | one image representing the specified frame
`play image frame=0,5,10,15`     | images representing the specified frames
`play movie`                     | an image for each frame in the trajectory file
`play movie period=10`           | images for frames 0, 10, 20, ...


Cytosim can usually generate <a href="http://en.wikipedia.org/wiki/Netpbm_format">PPM images</a>, readible by <a href="http://rsbweb.nih.gov/ij/">ImageJ</a> (of FIJI).
In addition, Cytosim may be able to generate images in the PNG formats,
if the required library was linked during compilation.


# Assembling the images

## ImageJ

Multiple images can be combined into a movie file by using [ImageJ](http://rsbweb.nih.gov/ij/) or [Fiji](https://imagej.net/Fiji):  

Put all the images into a specific folder. Drag this folder onto the ImageJ window. ImageJ should open a dialog asking if you would like to assemble them into a stack. Accept, and the resulting stack can then be exported as a movie in several formats.

## FFmpeg 

Alternatively, [FFmpeg](http://ffmpeg.org) is a versatile command line tool that can assemble images into a movie file.
Please check their manual for the different options. We often use this command to assemble _images*.png_:
 
	ffmpeg -r 10 -i image%04d.png -pix_fmt yuv420p -c:v libx264 -crf 23 movie.mp4
 
 The quality is specified with the `-crf` factor between 0 (better) and 51 (worse).   

### FFmpeg options

To create a Quicktime-friendly MP4:

	ffmpeg -i input.mp4 -pix_fmt yuv420p -c:v libx264 -crf 32  output.mp4
 
To crop a movie:

	ffmpeg -i input.mp4 -filter:v crop=w:h:x:y output.mp4

To resize a movie:
	
	ffmpeg -i input.mp4 -filter:v scale=2048:768 output.mp4

To drop every other frame:

	ffmpeg -i input.mp4 -filter:v select="mod(n\,2)" output.mp4

Combine multiple filters:

	ffmpeg -i input.mp4 -filter:v scale=2048:768,select="mod(n\,2)" output.mp4

# Optional libraries

The PNG library is necessary to export PNG images. It can be installed on MacOS via <a href="http://brew.sh">Homebrew</a>:

	brew install libpng
	brew tap homebrew/dupes

The `makefile.inc` needs to be edited, and `play` needs to be recompiled.
