# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class BaseProfileSearchParameters(Model):
    """Provides possible values for base profile filtering. For example it tells
    what os languages are available.

    All required parameters must be populated in order to send to Azure.

    :param device_types: Required. List of possible device types. Possible
     values are 'desktop', 'mobile'.
    :type device_types: list[str]
    :param os_families: Required. List of possible os families. Possible
     values are 'windows', 'macos', 'linux', 'android', 'ios'.
    :type os_families: list[str]
    :param browser_products: Required. List of possible browser products.
     Possible values are 'chrome', 'firefox', 'edge', 'safari'.
    :type browser_products: list[str]
    :param languages: Required. List of possible os languages. It using the
     ISO 639-1 language code format.
    :type languages: list[str]
    """

    _validation = {
        'device_types': {'required': True},
        'os_families': {'required': True},
        'browser_products': {'required': True},
        'languages': {'required': True},
    }

    _attribute_map = {
        'device_types': {'key': 'deviceTypes', 'type': '[str]'},
        'os_families': {'key': 'osFamilies', 'type': '[str]'},
        'browser_products': {'key': 'browserProducts', 'type': '[str]'},
        'languages': {'key': 'languages', 'type': '[str]'},
    }

    def __init__(self, *, device_types, os_families, browser_products, languages, **kwargs) -> None:
        super(BaseProfileSearchParameters, self).__init__(**kwargs)
        self.device_types = device_types
        self.os_families = os_families
        self.browser_products = browser_products
        self.languages = languages
