# Generated by Django 4.0.2 on 2022-02-09 05:38

from django.db import migrations, models
import django.db.models.deletion
import django.db.models.manager
import django.utils.timezone
import paper_uploads.models.fields.base
import paper_uploads.models.fields.image
import paper_uploads.models.mixins


class Migration(migrations.Migration):

    replaces = [('paper_uploads', '0001_initial'), ('paper_uploads', '0002_auto_20210407_0627'), ('paper_uploads', '0003_auto_20210906_1505'), ('paper_uploads', '0004_auto_20211106_1004'), ('paper_uploads', '0005_alter_collectionitembase_index_together'), ('paper_uploads', '0006_auto_20211116_0748'), ('paper_uploads', '0007_alter_collection_options'), ('paper_uploads', '0008_rename_item_type_collectionitembase_type'), ('paper_uploads', '0009_alter_collectionitembase_polymorphic_ctype_and_more')]

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='Permissions',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
            options={
                'permissions': (('upload', 'Can upload files'), ('change', 'Can change files'), ('delete', 'Can delete files')),
                'managed': False,
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='CollectionItemBase',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('collection_id', models.IntegerField()),
                ('type', models.CharField(db_index=True, editable=False, max_length=32, verbose_name='type')),
                ('order', models.IntegerField(default=0, editable=False, verbose_name='order')),
                ('collection_content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.contenttype')),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_%(app_label)s.%(class)s_set+', to='contenttypes.contenttype')),
            ],
            options={
                'verbose_name': 'item',
                'verbose_name_plural': 'items',
                'default_permissions': (),
                'index_together': {('collection_id', 'collection_content_type')},
            },
        ),
        migrations.CreateModel(
            name='Collection',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('owner_app_label', models.CharField(editable=False, max_length=100)),
                ('owner_model_name', models.CharField(editable=False, max_length=100)),
                ('owner_fieldname', models.CharField(editable=False, max_length=255)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='created at')),
                ('collection_content_type', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.SET_NULL, to='contenttypes.contenttype')),
            ],
            options={
                'proxy': False,
                'default_permissions': (),
            },
            managers=[
                ('default_mgr', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='ImageCollection',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
                'default_permissions': (),
            },
            bases=('paper_uploads.collection',),
            managers=[
                ('default_mgr', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='UploadedImage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('owner_app_label', models.CharField(editable=False, max_length=100)),
                ('owner_model_name', models.CharField(editable=False, max_length=100)),
                ('owner_fieldname', models.CharField(editable=False, max_length=255)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='created at')),
                ('modified_at', models.DateTimeField(auto_now=True, verbose_name='changed at')),
                ('basename', models.CharField(editable=False, help_text='Human-readable resource name', max_length=255, verbose_name='basename')),
                ('extension', models.CharField(editable=False, help_text='Lowercase, without leading dot', max_length=32, verbose_name='extension')),
                ('size', models.PositiveIntegerField(default=0, editable=False, verbose_name='size')),
                ('checksum', models.CharField(editable=False, max_length=64, verbose_name='checksum')),
                ('uploaded_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='uploaded at')),
                ('title', models.CharField(blank=True, help_text='The title is being used as a tooltip when the user hovers the mouse over the image', max_length=255, verbose_name='title')),
                ('description', models.TextField(blank=True, help_text='This text will be used by screen readers, search engines, or when the image cannot be loaded', verbose_name='description')),
                ('width', models.PositiveSmallIntegerField(default=0, editable=False, verbose_name='width')),
                ('height', models.PositiveSmallIntegerField(default=0, editable=False, verbose_name='height')),
                ('cropregion', models.CharField(blank=True, editable=False, max_length=24, verbose_name='crop region')),
                ('file', paper_uploads.models.fields.image.VariationalFileField(verbose_name='file')),
            ],
            options={
                'verbose_name': 'image',
                'verbose_name_plural': 'images',
                'abstract': False,
                'default_permissions': (),
            },
            bases=(paper_uploads.models.mixins.FileFieldProxyMixin, paper_uploads.models.mixins.FileProxyMixin, models.Model),
        ),
        migrations.CreateModel(
            name='ImageItem',
            fields=[
                ('collectionitembase_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='paper_uploads.collectionitembase')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='created at')),
                ('modified_at', models.DateTimeField(auto_now=True, verbose_name='changed at')),
                ('basename', models.CharField(editable=False, help_text='Human-readable resource name', max_length=255, verbose_name='basename')),
                ('extension', models.CharField(editable=False, help_text='Lowercase, without leading dot', max_length=32, verbose_name='extension')),
                ('size', models.PositiveIntegerField(default=0, editable=False, verbose_name='size')),
                ('checksum', models.CharField(editable=False, max_length=64, verbose_name='checksum')),
                ('uploaded_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='uploaded at')),
                ('title', models.CharField(blank=True, help_text='The title is being used as a tooltip when the user hovers the mouse over the image', max_length=255, verbose_name='title')),
                ('description', models.TextField(blank=True, help_text='This text will be used by screen readers, search engines, or when the image cannot be loaded', verbose_name='description')),
                ('width', models.PositiveSmallIntegerField(default=0, editable=False, verbose_name='width')),
                ('height', models.PositiveSmallIntegerField(default=0, editable=False, verbose_name='height')),
                ('cropregion', models.CharField(blank=True, editable=False, max_length=24, verbose_name='crop region')),
                ('file', paper_uploads.models.fields.image.VariationalFileField(verbose_name='file')),
            ],
            options={
                'abstract': False,
                'default_permissions': (),
            },
            bases=('paper_uploads.collectionitembase', paper_uploads.models.mixins.FileFieldProxyMixin, paper_uploads.models.mixins.FileProxyMixin, models.Model),
        ),
        migrations.CreateModel(
            name='FileItem',
            fields=[
                ('collectionitembase_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='paper_uploads.collectionitembase')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='created at')),
                ('modified_at', models.DateTimeField(auto_now=True, verbose_name='changed at')),
                ('basename', models.CharField(editable=False, help_text='Human-readable resource name', max_length=255, verbose_name='basename')),
                ('extension', models.CharField(editable=False, help_text='Lowercase, without leading dot', max_length=32, verbose_name='extension')),
                ('size', models.PositiveIntegerField(default=0, editable=False, verbose_name='size')),
                ('checksum', models.CharField(editable=False, max_length=64, verbose_name='checksum')),
                ('uploaded_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='uploaded at')),
                ('file', paper_uploads.models.fields.base.DynamicStorageFileField(verbose_name='file')),
                ('display_name', models.CharField(blank=True, max_length=255, verbose_name='display name')),
            ],
            options={
                'abstract': False,
                'default_permissions': (),
            },
            bases=('paper_uploads.collectionitembase', paper_uploads.models.mixins.FileFieldProxyMixin, paper_uploads.models.mixins.FileProxyMixin, models.Model),
        ),
        migrations.CreateModel(
            name='SVGItem',
            fields=[
                ('collectionitembase_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='paper_uploads.collectionitembase')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='created at')),
                ('modified_at', models.DateTimeField(auto_now=True, verbose_name='changed at')),
                ('basename', models.CharField(editable=False, help_text='Human-readable resource name', max_length=255, verbose_name='basename')),
                ('extension', models.CharField(editable=False, help_text='Lowercase, without leading dot', max_length=32, verbose_name='extension')),
                ('size', models.PositiveIntegerField(default=0, editable=False, verbose_name='size')),
                ('checksum', models.CharField(editable=False, max_length=64, verbose_name='checksum')),
                ('uploaded_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='uploaded at')),
                ('file', paper_uploads.models.fields.base.DynamicStorageFileField(verbose_name='file')),
                ('display_name', models.CharField(blank=True, max_length=255, verbose_name='display name')),
            ],
            options={
                'abstract': False,
                'default_permissions': (),
            },
            bases=('paper_uploads.collectionitembase', paper_uploads.models.mixins.FileFieldProxyMixin, paper_uploads.models.mixins.FileProxyMixin, models.Model),
        ),
        migrations.CreateModel(
            name='UploadedFile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('owner_app_label', models.CharField(editable=False, max_length=100)),
                ('owner_model_name', models.CharField(editable=False, max_length=100)),
                ('owner_fieldname', models.CharField(editable=False, max_length=255)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='created at')),
                ('modified_at', models.DateTimeField(auto_now=True, verbose_name='changed at')),
                ('basename', models.CharField(editable=False, help_text='Human-readable resource name', max_length=255, verbose_name='basename')),
                ('extension', models.CharField(editable=False, help_text='Lowercase, without leading dot', max_length=32, verbose_name='extension')),
                ('size', models.PositiveIntegerField(default=0, editable=False, verbose_name='size')),
                ('checksum', models.CharField(editable=False, max_length=64, verbose_name='checksum')),
                ('uploaded_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='uploaded at')),
                ('file', paper_uploads.models.fields.base.DynamicStorageFileField(verbose_name='file')),
                ('display_name', models.CharField(blank=True, max_length=255, verbose_name='display name')),
            ],
            options={
                'verbose_name': 'file',
                'verbose_name_plural': 'files',
                'abstract': False,
                'default_permissions': (),
            },
            bases=(paper_uploads.models.mixins.FileFieldProxyMixin, paper_uploads.models.mixins.FileProxyMixin, models.Model),
        ),
    ]
