"""
Django settings for test_project project.

Generated by 'django-admin startproject' using Django 2.1.7.

For more information on this file, see
https://docs.djangoproject.com/en/2.1/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/2.1/ref/settings/
"""

import os

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
from collections import OrderedDict

BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/2.1/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = "dummy"

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = []


# Application definition

INSTALLED_APPS = [
    "django.contrib.admin",
    "django.contrib.auth",
    "django.contrib.contenttypes",
    "django.contrib.sessions",
    "django.contrib.messages",
    "django.contrib.staticfiles",
    "django_migration_linter",
    "tests.test_project.app_add_manytomany_field",
    "tests.test_project.app_add_not_null_column",
    "tests.test_project.app_add_not_null_column_followed_by_default",
    "tests.test_project.app_alter_column",
    "tests.test_project.app_alter_column_drop_not_null",
    "tests.test_project.app_correct",
    "tests.test_project.app_create_table_with_not_null_column",
    "tests.test_project.app_drop_column",
    "tests.test_project.app_drop_table",
    "tests.test_project.app_ignore_migration",
    "tests.test_project.app_rename_column",
    "tests.test_project.app_rename_table",
    "tests.test_project.app_unique_together",
    "tests.test_project.app_data_migrations",
]

MIDDLEWARE = [
    "django.middleware.security.SecurityMiddleware",
    "django.contrib.sessions.middleware.SessionMiddleware",
    "django.middleware.common.CommonMiddleware",
    "django.middleware.csrf.CsrfViewMiddleware",
    "django.contrib.auth.middleware.AuthenticationMiddleware",
    "django.contrib.messages.middleware.MessageMiddleware",
    "django.middleware.clickjacking.XFrameOptionsMiddleware",
]

ROOT_URLCONF = "tests.test_project.urls"

TEMPLATES = [
    {
        "BACKEND": "django.template.backends.django.DjangoTemplates",
        "DIRS": [],
        "APP_DIRS": True,
        "OPTIONS": {
            "context_processors": [
                "django.template.context_processors.debug",
                "django.template.context_processors.request",
                "django.contrib.auth.context_processors.auth",
                "django.contrib.messages.context_processors.messages",
            ]
        },
    }
]

WSGI_APPLICATION = "tests.test_project.wsgi.application"


DATABASES = {
    "default": {
        "ENGINE": "django.db.backends.sqlite3",
        "NAME": os.path.join(BASE_DIR, "db.sqlite3"),
        "TEST": {"DEPENDENCIES": []},
    },
    "sqlite": {
        "ENGINE": "django.db.backends.sqlite3",
        "NAME": "sqlite3",
        "TEST": {"DEPENDENCIES": []},
    },
    "postgresql": {
        "ENGINE": "django.db.backends.postgresql",
        "NAME": "django_migration_linter_test_project",
        "USER": "postgres",
        "TEST": {"DEPENDENCIES": []},
    },
    "mysql": {
        "ENGINE": "django.db.backends.mysql",
        "NAME": "django_migration_linter_test_project",
        "USER": "travis",
        "PASSWORD": "",
        "HOST": "127.0.0.1",
        "TEST": {"DEPENDENCIES": []},
    },
}


# Password validation

AUTH_PASSWORD_VALIDATORS = [
    {
        "NAME": "django.contrib.auth.password_validation.UserAttributeSimilarityValidator"
    },
    {"NAME": "django.contrib.auth.password_validation.MinimumLengthValidator"},
    {"NAME": "django.contrib.auth.password_validation.CommonPasswordValidator"},
    {"NAME": "django.contrib.auth.password_validation.NumericPasswordValidator"},
]


# Internationalization
# https://docs.djangoproject.com/en/2.1/topics/i18n/

LANGUAGE_CODE = "en-us"

TIME_ZONE = "UTC"

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/2.1/howto/static-files/

STATIC_URL = "/static/"
