# Copyright 2021 The NetKet Authors - All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import pytest

import netket as nk

from .. import common

pytestmark = common.skipif_mpi


def test_deprecated_name():
    with pytest.warns(FutureWarning):
        nk.optim.sr

    with pytest.raises(AttributeError):
        nk.optim.accabalubba

    assert dir(nk.optim) == dir(nk.optimizer)


def test_deprecated_sr():
    with pytest.warns(FutureWarning):
        nk.optimizer.sr.SRLazyCG()

    with pytest.warns(FutureWarning):
        nk.optimizer.sr.SRLazyGMRES()
