import { ResourceAutoNaming, ResourceDefaultNaming, ResourceNamingType as RDSDatabaseRunningScheduleStackResourceNamingType } from '@gammarers/aws-resource-naming';
import { Duration, Stack, StackProps } from 'aws-cdk-lib';
import { Construct } from 'constructs';
export { RDSDatabaseRunningScheduleStackResourceNamingType };
export interface ResourceCustomNaming {
    readonly type: RDSDatabaseRunningScheduleStackResourceNamingType.CUSTOM;
    readonly notificationTopicName: string;
    readonly notificationTopicDisplayName: string;
    readonly stateMachineName: string;
    readonly stateMachineRoleName: string;
    readonly schedulerRoleName: string;
    readonly startScheduleName: string;
    readonly stopScheduleName: string;
}
export type ResourceNamingOption = ResourceDefaultNaming | ResourceAutoNaming | ResourceCustomNaming;
export interface Schedule {
    readonly timezone: string;
    readonly minute?: string;
    readonly hour?: string;
    readonly week?: string;
}
export interface TargetResource {
    readonly tagKey: string;
    readonly tagValues: string[];
}
export interface Slack {
    readonly webhookSecretName: string;
}
export interface Notifications {
    readonly emails?: string[];
    readonly slack?: Slack;
}
export interface TimeoutOption {
    readonly stateMachineTimeout?: Duration;
}
export interface RDSDatabaseRunningScheduleStackProps extends StackProps {
    readonly targetResource: TargetResource;
    readonly enableScheduling?: boolean;
    readonly stopSchedule?: Schedule;
    readonly startSchedule?: Schedule;
    readonly notifications?: Notifications;
    readonly resourceNamingOption?: ResourceNamingOption;
    readonly timeoutOption?: TimeoutOption;
}
export declare class RDSDatabaseRunningScheduleStack extends Stack {
    constructor(scope: Construct, id: string, props: RDSDatabaseRunningScheduleStackProps);
}
