#!/usr/bin/env python

__all__ = ["KEYS", "ACTIONS"]

KEYS = {
    "ctrl-a": "\x01",
    "ctrl-b": "\x02",
    "ctrl-c": "\x03",
    "ctrl-d": "\x04",
    "ctrl-e": "\x05",
    "ctrl-f": "\x06",
    "ctrl-g": "\x07",
    "ctrl-h": "\x08",
    "ctrl-i": "\x09",
    "ctrl-j": "\x0a",
    "ctrl-k": "\x0b",
    "ctrl-l": "\x0c",
    "ctrl-m": "\x0d",
    "ctrl-n": "\x0e",
    "ctrl-o": "\x0f",
    "ctrl-p": "\x10",
    "ctrl-q": "\x11",
    "ctrl-r": "\x12",
    "ctrl-s": "\x13",
    "ctrl-t": "\x14",
    "ctrl-u": "\x15",
    "ctrl-v": "\x16",
    "ctrl-w": "\x17",
    "ctrl-x": "\x18",
    "ctrl-y": "\x19",
    "ctrl-z": "\x1a",
    "pgup": "pgup",
    "page-up": "pgup",
    "pgdn": "pgdn",
    "page-down": "pgdn",
    "insert": "insert",
    "del": "del",
    "space": " ",
    "null": "\0",
    "up": "up",
    "down": "down",
    "right": "right",
    "left": "left",
    "nl": "\n",
    "enter": "\r",
    "tab": "\t",
    "bspace": "\x7f",
    "esc": "\x1b",
}

ACTIONS = {
    "abort": ["ctrl-c", "ctrl-g", "ctrl-q", "esc"],
    "accept": ["enter"],
    "backward-delete-char": ["ctrl-h", "bspace"],
    "down": ["ctrl-j", "ctrl-n", "down"],
    "up": ["ctrl-k", "ctrl-p", "up"],
    "ignore": ["null", "left", "right", "insert", "del"],
    "page-up": ["page-up", "pgup"],
    "page-down": ["page-down", "pgdn"],
}
