from .inference import *
import consul
import cachetools
import os
from grpclib.client import Channel
from typing import Optional,List
from syncer import sync

# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: grpc_service.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import List
import logging
logging.basicConfig(level=logging.INFO)

class InferenceChannel(Channel):
    def __init__(self, host: Optional[str] = None, port: Optional[int] = None):
        super(InferenceChannel, self).__init__(host=host,port=port)
    def __del__(self):
        try:
            logging.info("channel close: {0}:{1}".format(self.__getattribute__("_host"),self.__getattribute__("_port")))
            self.close()
        except Exception:
            pass

class InferenceStub:
    def __init__(self, ip: str = "127.0.0.1", port: int =8500):
        self.consul_c=consul.Consul(host=ip,port=port)
        ### get cache time
        interval_res = self.consul_c.kv.get("settings/interval")
        if interval_res[1] is None:
            self.interval_time=30
        else:
            self.interval_time=(int)(interval_res[1]["Value"])
        self.cache = cachetools.TTLCache(maxsize=10,ttl=self.interval_time)
        self.channel_cache = cachetools.Cache(maxsize=10)

    def __get_stub(self,model_name: str="",model_version: str="",backend: str=""):
        model_key = os.path.join(model_name, model_version, backend)
        model_key = model_key.replace("\\","/")
        stub = self.cache.get(model_key)
        if stub is None:  ### get it from consul
            keys = self.consul_c.kv.get(key=model_key, keys=True, recurse=True)
            if keys[1] is None or len(keys[1]) == 0:
                return None
            model_full_key = keys[1][0]
            server_info = os.path.split(model_full_key)[-1]
            server_host, port = (server_info.split("_")[-1]).split(":")
            cached_channel=self.channel_cache.get(server_info)
            if cached_channel is None:
                port = int(port)
                cached_channel = InferenceChannel(host=server_host, port=port)
                self.channel_cache[server_info] = cached_channel

            self.cache.expire()
            stub = GRPCInferenceServiceStub(channel=cached_channel)
            self.cache[model_key] = stub

        logging.info("running at {0}:{1}".format(stub.channel.__getattribute__("_host"),stub.channel.__getattribute__("_port")))
        return stub

    def __get_service(self,backend: str=""):
        model_key=backend
        stub = self.cache.get(model_key)
        if stub is None:  ### get it from consul
            services = self.consul_c.agent.services()
            for k,v in services.items():
                tags = v['Tags']
                if model_key not in tags:
                    continue
                service_host=v['Address']
                service_port=v['Port']
                channel = InferenceChannel(host=service_host, port=service_port)
                self.cache.expire()
                stub = GRPCInferenceServiceStub(channel=channel)
                self.cache[model_key] = stub
                break

        logging.info("running at {0}:{1}".format(stub.channel.__getattribute__("_host"),
                                                 stub.channel.__getattribute__("_port")))
        return stub

    @sync
    async def model_infer(self,model_name: str = "",
        model_version: str = "",
        backend: str = "",
        inputs: List["InferRequestInferInputTensor"] = [],
        return_raw_tensor: bool = False,
        request_id: str = "",
        use_device_image_process: bool = False,
    ) -> InferResponse:
        ### get from cache
        try:
            stub = self.__get_stub(model_name,model_version,backend)
        except Exception:
            stub = None
        if stub is None: ### get it from consul
            return InferResponse(model_name=model_name,model_version=model_version,backend=backend,
                                                   request_id=request_id,status_code="E_MODEL_NOF_FOUND",status_msg="model not found")

        return await stub.model_infer(model_name=model_name,model_version=model_version,backend=backend,inputs=inputs,return_raw_tensor=return_raw_tensor,
                                request_id=request_id,use_device_image_process=use_device_image_process)

    def model_infer_sync(self, model_name: str = "",
                          model_version: str = "",
                          backend: str = "",
                          inputs: List["InferRequestInferInputTensor"] = [],
                          return_raw_tensor: bool = False,
                          request_id: str = "",
                          use_device_image_process: bool = False,
                          ) -> InferResponse:
        return self.model_infer(model_name=model_name,model_version=model_version,backend=backend,inputs=inputs,
                                return_raw_tensor=return_raw_tensor,request_id=request_id,use_device_image_process=use_device_image_process)

    @sync
    async def model_speed_test(
        self,
        model_name: str = "",
        model_version: str = "",
        backend: str = "",
        request_id: str = "",
        run_times: int = 1,
        batch: int = 1,
    ) -> ModelSpeedTestResponse:

        stub = self.__get_stub(model_name, model_version, backend)
        if stub is None:  ### get it from consul
            return ModelSpeedTestResponse(model_name=model_name, model_version=model_version, backend=backend,
                                           request_id=request_id, status_code="E_MODEL_NOF_FOUND",
                                           status_msg="model not found")

        request = ModelSpeedTestRequest()
        request.model_name = model_name
        request.model_version = model_version
        request.backend = backend
        request.request_id = request_id
        request.run_times = run_times
        request.batch = batch
        return await stub.model_speed_test(model_name=model_name,model_version=model_version,backend=backend,request_id=request_id,
                                           run_times=run_times,batch=batch)
    def model_speed_test_sync(
        self,
        model_name: str = "",
        model_version: str = "",
        backend: str = "",
        request_id: str = "",
        run_times: int = 1,
        batch: int = 1,
    ) -> ModelSpeedTestResponse:

        return self.model_speed_test(model_name=model_name,model_version=model_version,backend=backend,request_id=request_id,
                                           run_times=run_times,batch=batch)

    @sync
    async def model_control(self, model_name: str = "",
        model_version: str = "",
        backend: str = "",
        request_id: str = "",
        model_action: "ModelAction" = 0,
                          ) -> ModelControlResponse:
        ### get from cache
        try:
            stub = self.__get_service(backend)
        except Exception:
            stub = None
        if stub is None:  ### get it from consul
            return ModelControlResponse(model_name=model_name, model_version=model_version, backend=backend,
                                 request_id=request_id, status_code="ERROR", status_msg="CANNOT find backend service")

        return await stub.model_control(model_name=model_name, model_version=model_version, backend=backend,
                                      request_id=request_id, model_action=model_action)

    def model_control_sync(self, model_name: str = "",
                      model_version: str = "",
                      backend: str = "",
                      request_id: str = "",
                      model_action: "ModelAction" = 0,
                      ) -> ModelControlResponse:
        ### get from cache
       return self.model_control(model_name,model_version,backend,request_id,model_action)