# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: grpc_service.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import List

import betterproto
import grpclib


class ModelAction(betterproto.Enum):
    LOAD = 0
    UNLOAD = 1


class DataType(betterproto.Enum):
    INT8 = 0
    INT32 = 1
    FP32 = 2


class DataFormat(betterproto.Enum):
    RGB = 0
    BGR = 1
    GRAY = 2
    NCHW = 3
    RAW = 4


class OutputResultType(betterproto.Enum):
    TENSOR = 0
    VECTOR = 1
    BOX = 2


@dataclass
class InferTensorData(betterproto.Message):
    byte_data: bytes = betterproto.bytes_field(1)
    int32_data: List[int] = betterproto.int32_field(2)
    fp32_data: List[float] = betterproto.float_field(3)


@dataclass
class Box(betterproto.Message):
    x1: float = betterproto.float_field(1)
    x2: float = betterproto.float_field(2)
    y1: float = betterproto.float_field(3)
    y2: float = betterproto.float_field(4)
    score: float = betterproto.float_field(5)
    type: int = betterproto.int32_field(6)


@dataclass
class VecVals(betterproto.Message):
    vals: List[float] = betterproto.float_field(1)


@dataclass
class InferRequest(betterproto.Message):
    model_name: str = betterproto.string_field(1)
    model_version: str = betterproto.string_field(2)
    backend: str = betterproto.string_field(3)
    inputs: List["InferRequestInferInputTensor"] = betterproto.message_field(4)
    return_raw_tensor: bool = betterproto.bool_field(5)
    request_id: str = betterproto.string_field(6)
    use_device_image_process: bool = betterproto.bool_field(7)


@dataclass
class InferRequestInferInputTensor(betterproto.Message):
    # / tensor name
    name: str = betterproto.string_field(1)
    data_type: "DataType" = betterproto.enum_field(2)
    data_format: "DataFormat" = betterproto.enum_field(3)
    shape: List[int] = betterproto.int64_field(4)
    box: "Box" = betterproto.message_field(5)
    landmarks: "VecVals" = betterproto.message_field(6)
    tensor_data: "InferTensorData" = betterproto.message_field(7)


@dataclass
class InferResponse(betterproto.Message):
    model_name: str = betterproto.string_field(1)
    model_version: str = betterproto.string_field(2)
    backend: str = betterproto.string_field(3)
    request_id: str = betterproto.string_field(4)
    output_tensors: List["InferResponseInferOutputTensor"] = betterproto.message_field(
        5
    )
    output_results: List["InferResponseInferOutputResult"] = betterproto.message_field(
        6
    )
    status_code: str = betterproto.string_field(7)
    status_msg: str = betterproto.string_field(8)


@dataclass
class InferResponseInferOutputTensor(betterproto.Message):
    name: str = betterproto.string_field(1)
    data_type: "DataType" = betterproto.enum_field(2)
    shape: List[int] = betterproto.int64_field(3)
    tensor_data: "InferTensorData" = betterproto.message_field(4)


@dataclass
class InferResponseInferOutputResult(betterproto.Message):
    tensors: List["InferResponseInferOutputTensor"] = betterproto.message_field(1)
    boxes: List["Box"] = betterproto.message_field(2)
    vals: List["VecVals"] = betterproto.message_field(3)
    result_type: "OutputResultType" = betterproto.enum_field(4)
    name: List[str] = betterproto.string_field(5)


@dataclass
class ModelInfoRequest(betterproto.Message):
    model_name: str = betterproto.string_field(1)
    model_version: str = betterproto.string_field(2)
    backend: str = betterproto.string_field(3)
    request_id: str = betterproto.string_field(4)


@dataclass
class ModelInfoResponse(betterproto.Message):
    model_name: str = betterproto.string_field(1)
    model_version: str = betterproto.string_field(2)
    backend: str = betterproto.string_field(3)
    request_id: str = betterproto.string_field(4)
    model_config: str = betterproto.string_field(5)
    status_code: str = betterproto.string_field(6)
    status_msg: str = betterproto.string_field(7)


@dataclass
class ModelSpeedTestRequest(betterproto.Message):
    model_name: str = betterproto.string_field(1)
    model_version: str = betterproto.string_field(2)
    backend: str = betterproto.string_field(3)
    request_id: str = betterproto.string_field(4)
    run_times: int = betterproto.uint32_field(5)
    batch: int = betterproto.uint32_field(6)


@dataclass
class ModelSpeedTestResponse(betterproto.Message):
    model_name: str = betterproto.string_field(1)
    model_version: str = betterproto.string_field(2)
    backend: str = betterproto.string_field(3)
    request_id: str = betterproto.string_field(4)
    min_time: int = betterproto.uint32_field(5)
    avg_time: int = betterproto.uint32_field(6)
    max_time: int = betterproto.uint32_field(7)
    status_code: str = betterproto.string_field(8)
    status_msg: str = betterproto.string_field(9)


@dataclass
class ModelControlRequest(betterproto.Message):
    model_name: str = betterproto.string_field(1)
    model_version: str = betterproto.string_field(2)
    backend: str = betterproto.string_field(3)
    request_id: str = betterproto.string_field(4)
    model_action: "ModelAction" = betterproto.enum_field(5)


@dataclass
class ModelControlResponse(betterproto.Message):
    model_name: str = betterproto.string_field(1)
    model_version: str = betterproto.string_field(2)
    backend: str = betterproto.string_field(3)
    request_id: str = betterproto.string_field(4)
    status_code: str = betterproto.string_field(6)
    status_msg: str = betterproto.string_field(7)


class GRPCInferenceServiceStub(betterproto.ServiceStub):
    async def model_infer(
        self,
        *,
        model_name: str = "",
        model_version: str = "",
        backend: str = "",
        inputs: List["InferRequestInferInputTensor"] = [],
        return_raw_tensor: bool = False,
        request_id: str = "",
        use_device_image_process: bool = False,
    ) -> InferResponse:
        request = InferRequest()
        request.model_name = model_name
        request.model_version = model_version
        request.backend = backend
        if inputs is not None:
            request.inputs = inputs
        request.return_raw_tensor = return_raw_tensor
        request.request_id = request_id
        request.use_device_image_process = use_device_image_process

        return await self._unary_unary(
            "/inference.GRPCInferenceService/ModelInfer",
            request,
            InferResponse,
        )

    async def model_info(
        self,
        *,
        model_name: str = "",
        model_version: str = "",
        backend: str = "",
        request_id: str = "",
    ) -> ModelInfoResponse:
        request = ModelInfoRequest()
        request.model_name = model_name
        request.model_version = model_version
        request.backend = backend
        request.request_id = request_id

        return await self._unary_unary(
            "/inference.GRPCInferenceService/ModelInfo",
            request,
            ModelInfoResponse,
        )

    async def model_speed_test(
        self,
        *,
        model_name: str = "",
        model_version: str = "",
        backend: str = "",
        request_id: str = "",
        run_times: int = 0,
        batch: int = 0,
    ) -> ModelSpeedTestResponse:
        request = ModelSpeedTestRequest()
        request.model_name = model_name
        request.model_version = model_version
        request.backend = backend
        request.request_id = request_id
        request.run_times = run_times
        request.batch = batch

        return await self._unary_unary(
            "/inference.GRPCInferenceService/ModelSpeedTest",
            request,
            ModelSpeedTestResponse,
        )

    async def model_control(
        self,
        *,
        model_name: str = "",
        model_version: str = "",
        backend: str = "",
        request_id: str = "",
        model_action: "ModelAction" = 0,
    ) -> ModelControlResponse:
        request = ModelControlRequest()
        request.model_name = model_name
        request.model_version = model_version
        request.backend = backend
        request.request_id = request_id
        request.model_action = model_action

        return await self._unary_unary(
            "/inference.GRPCInferenceService/ModelControl",
            request,
            ModelControlResponse,
        )
