from __future__ import annotations

from cptk.core.chef import BakingError
from cptk.core.chef import NoTestConfigurationError
from cptk.core.config import ConfigFileError
from cptk.core.config import ConfigFileNotFound
from cptk.core.config import ConfigFileParsingError
from cptk.core.config import ConfigFileValueError
from cptk.core.fetcher import InvalidClone
from cptk.core.fetcher import UnknownWebsite
from cptk.core.preprocessor import PreprocessError
from cptk.core.preprocessor import PreprocessFileError
from cptk.core.preprocessor import PreprocessNameError
from cptk.core.preprocessor import PreprocessStringError
from cptk.core.system import SystemRunError
from cptk.local.problem import NoRecipesFound
from cptk.local.problem import RecipeNameNotFound
from cptk.local.problem import RecipeNotFoundError
from cptk.local.project import InvalidMoveDest
from cptk.local.project import InvalidMovePath
from cptk.local.project import InvalidMoveSource
from cptk.local.project import ProjectNotFound
from cptk.utils import cptkException

__all__ = [
    # cptk.core.chef
    'BakingError',
    'NoTestConfigurationError',

    # cptk.core.config
    'ConfigFileError',
    'ConfigFileNotFound',
    'ConfigFileParsingError',
    'ConfigFileValueError',

    # cptk.core.integrator
    'InvalidClone',
    'UnknownWebsite',

    # cptk.core.preprocessor
    'PreprocessError',
    'PreprocessFileError',
    'PreprocessNameError',
    'PreprocessStringError',

    # cptk.core.system
    'SystemRunError',

    # cptk.local.problem
    'NoRecipesFound',
    'RecipeNameNotFound',
    'RecipeNotFoundError',

    # cptk.local.project
    'InvalidMoveDest',
    'InvalidMovePath',
    'InvalidMoveSource',
    'ProjectNotFound',

    # cptk.utils
    'cptkException',
]
