# Competitive Programming Tool Kit

[![cptk](https://img.shields.io/static/v1?label=using&message=cptk&color=ffbb00)](https://github.com/RealA10N/cptk)
[![PyPI](https://img.shields.io/pypi/v/cptk?logo=python&logoColor=white)](https://pypi.org/project/cptk)
[![pre-commit.ci status](https://results.pre-commit.ci/badge/github/RealA10N/cptk/main.svg)](https://results.pre-commit.ci/latest/github/RealA10N/cptk/main)
[![GitHub Workflow](https://img.shields.io/github/workflow/status/reala10n/cptk/CI/main?logo=github&logoColor=white)](https://github.com/RealA10N/cptk/actions/workflows/ci.yaml?query=branch%3Amain)
[![codecov](https://img.shields.io/codecov/c/github/reala10n/cptk?logo=codecov&logoColor=white)](https://codecov.io/gh/RealA10N/cptk)

**The Competitive Programming Tool Kit** (_cptk_ for short), is a command-line interface (CLI) that aims to be your personal assistant for everything competitive-programming-related. Some of the main features of cptk are:

- Supports all large competitive programming websites, including [codeforces.com](https://codeforces.com/), [cses.fi](https://cses.fi/) and [kattis.com](https://open.kattis.com/)
- Automatically download and run example test cases
- Manage and catalog the solutions in your competitive programming folder
- Full git integration: commits and pushes solutions after you submit them
- And much more!

**Are you using cptk?** Show us love and display the [![cptk](https://img.shields.io/static/v1?label=using&message=cptk&color=ffbb00)](https://github.com/RealA10N/cptk) badge in your repository!

## Getting started

### Installation

The Competitive Programming Tool Kit is implemented fully in Python and is
distributed using the Python Package Index (PyPI).

To use cptk make sure you have **CPython>=3.7** installed.
Then, install cptk using `pip`:

```shell
pip install cptk
```

You can check that the installation went successfully by running:

```shell
cptk --help
```

If you are experiencing problems while installing cptk, check out the more
detailed [Installation Guide](https://github.com/RealA10N/cptk/wiki/Installation).
