# studio_wrapper.py

from enum import Enum
from typing import Any
import nanosurf.lib.spm.studio.wrapper as wrap

g_cmd_tree_hash = '361ad5c39094d8ef878211b0224924fa'
g_compiler_version = '1.0'

class RootTestTabel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.test.tabel'


class RootTest(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.test'
        self.tabel = RootTestTabel(self._context)

    @property
    def bool(self) -> bool:
        return bool(self._context.get('root.test.bool'))

    @bool.setter
    def bool(self, new_val:bool):
        self._context.set('root.test.bool', bool(new_val))

    @property
    def num_f(self) -> float:
        return float(self._context.get('root.test.num_f'))

    @num_f.setter
    def num_f(self, new_val:float):
        self._context.set('root.test.num_f', float(new_val))

    @property
    def str(self) -> str:
        return str(self._context.get('root.test.str'))

    @str.setter
    def str(self, new_val:str):
        self._context.set('root.test.str', str(new_val))

    def func(self, *args) -> Any:
        return self._context.call('root.test.func', *args)

    @property
    def num_i(self) -> int:
        return int(self._context.get('root.test.num_i'))

    @num_i.setter
    def num_i(self, new_val:int):
        self._context.set('root.test.num_i', int(new_val))


class RootSeqRbanaAnalyzerOneAmplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.amplitude'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.amplitude.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.amplitude.regaddr', int(new_val))


class RootSeqRbanaAnalyzerOneDeltafoffs_hi(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.deltafoffs_hi'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.deltafoffs_hi.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.deltafoffs_hi.regaddr', int(new_val))


class RootSeqRbanaAnalyzerOneControl1Distdeltaf(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.control1.distdeltaf'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.control1.distdeltaf.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.control1.distdeltaf.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.control1.distdeltaf.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.control1.distdeltaf.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.control1.distdeltaf.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.control1.distdeltaf.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneControl1Outputsourceid(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.control1.outputsourceid'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.control1.outputsourceid.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.control1.outputsourceid.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.control1.outputsourceid.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.control1.outputsourceid.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.control1.outputsourceid.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.control1.outputsourceid.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneControl1Fltr_vld(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.control1.fltr_vld'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.control1.fltr_vld.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.control1.fltr_vld.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.control1.fltr_vld.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.control1.fltr_vld.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.control1.fltr_vld.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.control1.fltr_vld.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneControl1Clearflag(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.control1.clearflag'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.control1.clearflag.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.control1.clearflag.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.control1.clearflag.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.control1.clearflag.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.control1.clearflag.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.control1.clearflag.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneControl1Filtaddr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.control1.filtaddr'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.control1.filtaddr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.control1.filtaddr.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.control1.filtaddr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.control1.filtaddr.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.control1.filtaddr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.control1.filtaddr.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneControl1Enabledcblock(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.control1.enabledcblock'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.control1.enabledcblock.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.control1.enabledcblock.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.control1.enabledcblock.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.control1.enabledcblock.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.control1.enabledcblock.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.control1.enabledcblock.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneControl1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.control1'
        self.enabledcblock = RootSeqRbanaAnalyzerOneControl1Enabledcblock(self._context)
        self.filtaddr = RootSeqRbanaAnalyzerOneControl1Filtaddr(self._context)
        self.clearflag = RootSeqRbanaAnalyzerOneControl1Clearflag(self._context)
        self.fltr_vld = RootSeqRbanaAnalyzerOneControl1Fltr_vld(self._context)
        self.outputsourceid = RootSeqRbanaAnalyzerOneControl1Outputsourceid(self._context)
        self.distdeltaf = RootSeqRbanaAnalyzerOneControl1Distdeltaf(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.control1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.control1.regaddr', int(new_val))


class RootSeqRbanaAnalyzerOneCtrlbitsAmpclearaccu(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.ctrlbits.ampclearaccu'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.ctrlbits.ampclearaccu.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.ctrlbits.ampclearaccu.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.ctrlbits.ampclearaccu.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.ctrlbits.ampclearaccu.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.ctrlbits.ampclearaccu.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.ctrlbits.ampclearaccu.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneCtrlbitsAmpmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.ctrlbits.ampmodulation'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.ctrlbits.ampmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.ctrlbits.ampmodulation.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.ctrlbits.ampmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.ctrlbits.ampmodulation.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.ctrlbits.ampmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.ctrlbits.ampmodulation.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneCtrlbitsPhasectrl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.ctrlbits.phasectrl'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.ctrlbits.phasectrl.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.ctrlbits.phasectrl.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.ctrlbits.phasectrl.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.ctrlbits.phasectrl.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.ctrlbits.phasectrl.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.ctrlbits.phasectrl.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneCtrlbitsAmpctrlmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.ctrlbits.ampctrlmode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.ctrlbits.ampctrlmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.ctrlbits.ampctrlmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.ctrlbits.ampctrlmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.ctrlbits.ampctrlmode.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.ctrlbits.ampctrlmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.ctrlbits.ampctrlmode.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneCtrlbitsPhaseclearaccu(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.ctrlbits.phaseclearaccu'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.ctrlbits.phaseclearaccu.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.ctrlbits.phaseclearaccu.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.ctrlbits.phaseclearaccu.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.ctrlbits.phaseclearaccu.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.ctrlbits.phaseclearaccu.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.ctrlbits.phaseclearaccu.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneCtrlbitsAmpctrlpositiveaccu(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.ctrlbits.ampctrlpositiveaccu'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.ctrlbits.ampctrlpositiveaccu.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.ctrlbits.ampctrlpositiveaccu.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.ctrlbits.ampctrlpositiveaccu.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.ctrlbits.ampctrlpositiveaccu.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.ctrlbits.ampctrlpositiveaccu.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.ctrlbits.ampctrlpositiveaccu.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneCtrlbits(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.ctrlbits'
        self.ampctrlpositiveaccu = RootSeqRbanaAnalyzerOneCtrlbitsAmpctrlpositiveaccu(self._context)
        self.phaseclearaccu = RootSeqRbanaAnalyzerOneCtrlbitsPhaseclearaccu(self._context)
        self.ampctrlmode = RootSeqRbanaAnalyzerOneCtrlbitsAmpctrlmode(self._context)
        self.phasectrl = RootSeqRbanaAnalyzerOneCtrlbitsPhasectrl(self._context)
        self.ampmodulation = RootSeqRbanaAnalyzerOneCtrlbitsAmpmodulation(self._context)
        self.ampclearaccu = RootSeqRbanaAnalyzerOneCtrlbitsAmpclearaccu(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.ctrlbits.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.ctrlbits.regaddr', int(new_val))


class RootSeqRbanaAnalyzerOneDelaycomp(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.delaycomp'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.delaycomp.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.delaycomp.regaddr', int(new_val))


class RootSeqRbanaAnalyzerOneModampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.modampkel'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.modampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.modampkel.regaddr', int(new_val))


class RootSeqRbanaAnalyzerOneKiampkelShift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.kiampkel.shift'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kiampkel.shift.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kiampkel.shift.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kiampkel.shift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kiampkel.shift.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kiampkel.shift.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kiampkel.shift.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneKiampkelShiftdirection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.kiampkel.shiftdirection'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kiampkel.shiftdirection.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kiampkel.shiftdirection.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kiampkel.shiftdirection.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kiampkel.shiftdirection.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kiampkel.shiftdirection.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kiampkel.shiftdirection.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneKiampkelFactor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.kiampkel.factor'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kiampkel.factor.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kiampkel.factor.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kiampkel.factor.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kiampkel.factor.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kiampkel.factor.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kiampkel.factor.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneKiampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.kiampkel'
        self.factor = RootSeqRbanaAnalyzerOneKiampkelFactor(self._context)
        self.shiftdirection = RootSeqRbanaAnalyzerOneKiampkelShiftdirection(self._context)
        self.shift = RootSeqRbanaAnalyzerOneKiampkelShift(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kiampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kiampkel.regaddr', int(new_val))


class RootSeqRbanaAnalyzerOneFlag(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.flag'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.flag.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.flag.regaddr', int(new_val))


class RootSeqRbanaAnalyzerOneKpampkelShift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.kpampkel.shift'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kpampkel.shift.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kpampkel.shift.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kpampkel.shift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kpampkel.shift.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kpampkel.shift.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kpampkel.shift.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneKpampkelShiftdirection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.kpampkel.shiftdirection'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kpampkel.shiftdirection.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kpampkel.shiftdirection.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kpampkel.shiftdirection.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kpampkel.shiftdirection.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kpampkel.shiftdirection.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kpampkel.shiftdirection.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneKpampkelFactor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.kpampkel.factor'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kpampkel.factor.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kpampkel.factor.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kpampkel.factor.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kpampkel.factor.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kpampkel.factor.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kpampkel.factor.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneKpampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.kpampkel'
        self.factor = RootSeqRbanaAnalyzerOneKpampkelFactor(self._context)
        self.shiftdirection = RootSeqRbanaAnalyzerOneKpampkelShiftdirection(self._context)
        self.shift = RootSeqRbanaAnalyzerOneKpampkelShift(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kpampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kpampkel.regaddr', int(new_val))


class RootSeqRbanaAnalyzerOneThreshold(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.threshold'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.threshold.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.threshold.regaddr', int(new_val))


class RootSeqRbanaAnalyzerOneKpphaseShift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.kpphase.shift'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kpphase.shift.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kpphase.shift.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kpphase.shift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kpphase.shift.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kpphase.shift.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kpphase.shift.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneKpphaseShiftdirection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.kpphase.shiftdirection'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kpphase.shiftdirection.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kpphase.shiftdirection.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kpphase.shiftdirection.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kpphase.shiftdirection.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kpphase.shiftdirection.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kpphase.shiftdirection.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneKpphaseFactor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.kpphase.factor'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kpphase.factor.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kpphase.factor.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kpphase.factor.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kpphase.factor.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kpphase.factor.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kpphase.factor.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneKpphase(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.kpphase'
        self.factor = RootSeqRbanaAnalyzerOneKpphaseFactor(self._context)
        self.shiftdirection = RootSeqRbanaAnalyzerOneKpphaseShiftdirection(self._context)
        self.shift = RootSeqRbanaAnalyzerOneKpphaseShift(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kpphase.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kpphase.regaddr', int(new_val))


class RootSeqRbanaAnalyzerOneModeAnalyzerinput(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.mode.analyzerinput'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.mode.analyzerinput.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.mode.analyzerinput.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.mode.analyzerinput.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.mode.analyzerinput.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.mode.analyzerinput.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.mode.analyzerinput.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneModeInput(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.mode.input'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.mode.input.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.mode.input.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.mode.input.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.mode.input.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.mode.input.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.mode.input.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneModePhasedetref(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.mode.phasedetref'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.mode.phasedetref.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.mode.phasedetref.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.mode.phasedetref.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.mode.phasedetref.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.mode.phasedetref.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.mode.phasedetref.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneModeOpmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.mode.opmode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.mode.opmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.mode.opmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.mode.opmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.mode.opmode.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.mode.opmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.mode.opmode.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.mode'
        self.opmode = RootSeqRbanaAnalyzerOneModeOpmode(self._context)
        self.phasedetref = RootSeqRbanaAnalyzerOneModePhasedetref(self._context)
        self.input = RootSeqRbanaAnalyzerOneModeInput(self._context)
        self.analyzerinput = RootSeqRbanaAnalyzerOneModeAnalyzerinput(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.mode.regaddr', int(new_val))


class RootSeqRbanaAnalyzerOnePhase(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.phase'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.phase.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.phase.regaddr', int(new_val))


class RootSeqRbanaAnalyzerOneSafetipSafetip(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.safetip.safetip'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.safetip.safetip.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.safetip.safetip.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.safetip.safetip.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.safetip.safetip.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.safetip.safetip.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.safetip.safetip.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneSafetipSyncorsafetip(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.safetip.syncorsafetip'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.safetip.syncorsafetip.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.safetip.syncorsafetip.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.safetip.syncorsafetip.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.safetip.syncorsafetip.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.safetip.syncorsafetip.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.safetip.syncorsafetip.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneSafetipSafetipmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.safetip.safetipmode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.safetip.safetipmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.safetip.safetipmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.safetip.safetipmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.safetip.safetipmode.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.safetip.safetipmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.safetip.safetipmode.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneSafetipThresholdmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.safetip.thresholdmode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.safetip.thresholdmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.safetip.thresholdmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.safetip.thresholdmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.safetip.thresholdmode.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.safetip.thresholdmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.safetip.thresholdmode.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneSafetip(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.safetip'
        self.thresholdmode = RootSeqRbanaAnalyzerOneSafetipThresholdmode(self._context)
        self.safetipmode = RootSeqRbanaAnalyzerOneSafetipSafetipmode(self._context)
        self.syncorsafetip = RootSeqRbanaAnalyzerOneSafetipSyncorsafetip(self._context)
        self.safetip = RootSeqRbanaAnalyzerOneSafetipSafetip(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.safetip.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.safetip.regaddr', int(new_val))


class RootSeqRbanaAnalyzerOneFltrcoeff(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.fltrcoeff'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.fltrcoeff.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.fltrcoeff.regaddr', int(new_val))


class RootSeqRbanaAnalyzerOneLockrangeshift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.lockrangeshift'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.lockrangeshift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.lockrangeshift.regaddr', int(new_val))


class RootSeqRbanaAnalyzerOneSetvalampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.setvalampkel'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.setvalampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.setvalampkel.regaddr', int(new_val))


class RootSeqRbanaAnalyzerOneDeltaf(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.deltaf'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.deltaf.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.deltaf.regaddr', int(new_val))


class RootSeqRbanaAnalyzerOneY(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.y'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.y.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.y.regaddr', int(new_val))


class RootSeqRbanaAnalyzerOneX(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.x'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.x.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.x.regaddr', int(new_val))


class RootSeqRbanaAnalyzerOneDisscp(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.disscp'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.disscp.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.disscp.regaddr', int(new_val))


class RootSeqRbanaAnalyzerOnePhaseshift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.phaseshift'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.phaseshift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.phaseshift.regaddr', int(new_val))


class RootSeqRbanaAnalyzerOneDeltafoffs_lo(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.deltafoffs_lo'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.deltafoffs_lo.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.deltafoffs_lo.regaddr', int(new_val))


class RootSeqRbanaAnalyzerOneCenterfreq_hi(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.centerfreq_hi'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.centerfreq_hi.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.centerfreq_hi.regaddr', int(new_val))


class RootSeqRbanaAnalyzerOneKiphaseShift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.kiphase.shift'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kiphase.shift.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kiphase.shift.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kiphase.shift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kiphase.shift.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kiphase.shift.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kiphase.shift.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneKiphaseShiftdirection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.kiphase.shiftdirection'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kiphase.shiftdirection.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kiphase.shiftdirection.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kiphase.shiftdirection.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kiphase.shiftdirection.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kiphase.shiftdirection.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kiphase.shiftdirection.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneKiphaseFactor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.kiphase.factor'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kiphase.factor.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kiphase.factor.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kiphase.factor.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kiphase.factor.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kiphase.factor.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kiphase.factor.lsb', int(new_val))


class RootSeqRbanaAnalyzerOneKiphase(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.kiphase'
        self.factor = RootSeqRbanaAnalyzerOneKiphaseFactor(self._context)
        self.shiftdirection = RootSeqRbanaAnalyzerOneKiphaseShiftdirection(self._context)
        self.shift = RootSeqRbanaAnalyzerOneKiphaseShift(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.kiphase.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.kiphase.regaddr', int(new_val))


class RootSeqRbanaAnalyzerOneSetptampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.setptampkel'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.setptampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.setptampkel.regaddr', int(new_val))


class RootSeqRbanaAnalyzerOneCenterfreq_lo(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one.centerfreq_lo'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.one.centerfreq_lo.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.one.centerfreq_lo.regaddr', int(new_val))


class RootSeqRbanaAnalyzerOne(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.one'
        self.centerfreq_lo = RootSeqRbanaAnalyzerOneCenterfreq_lo(self._context)
        self.setptampkel = RootSeqRbanaAnalyzerOneSetptampkel(self._context)
        self.kiphase = RootSeqRbanaAnalyzerOneKiphase(self._context)
        self.centerfreq_hi = RootSeqRbanaAnalyzerOneCenterfreq_hi(self._context)
        self.deltafoffs_lo = RootSeqRbanaAnalyzerOneDeltafoffs_lo(self._context)
        self.phaseshift = RootSeqRbanaAnalyzerOnePhaseshift(self._context)
        self.disscp = RootSeqRbanaAnalyzerOneDisscp(self._context)
        self.x = RootSeqRbanaAnalyzerOneX(self._context)
        self.y = RootSeqRbanaAnalyzerOneY(self._context)
        self.deltaf = RootSeqRbanaAnalyzerOneDeltaf(self._context)
        self.setvalampkel = RootSeqRbanaAnalyzerOneSetvalampkel(self._context)
        self.lockrangeshift = RootSeqRbanaAnalyzerOneLockrangeshift(self._context)
        self.fltrcoeff = RootSeqRbanaAnalyzerOneFltrcoeff(self._context)
        self.safetip = RootSeqRbanaAnalyzerOneSafetip(self._context)
        self.phase = RootSeqRbanaAnalyzerOnePhase(self._context)
        self.mode = RootSeqRbanaAnalyzerOneMode(self._context)
        self.kpphase = RootSeqRbanaAnalyzerOneKpphase(self._context)
        self.threshold = RootSeqRbanaAnalyzerOneThreshold(self._context)
        self.kpampkel = RootSeqRbanaAnalyzerOneKpampkel(self._context)
        self.flag = RootSeqRbanaAnalyzerOneFlag(self._context)
        self.kiampkel = RootSeqRbanaAnalyzerOneKiampkel(self._context)
        self.modampkel = RootSeqRbanaAnalyzerOneModampkel(self._context)
        self.delaycomp = RootSeqRbanaAnalyzerOneDelaycomp(self._context)
        self.ctrlbits = RootSeqRbanaAnalyzerOneCtrlbits(self._context)
        self.control1 = RootSeqRbanaAnalyzerOneControl1(self._context)
        self.deltafoffs_hi = RootSeqRbanaAnalyzerOneDeltafoffs_hi(self._context)
        self.amplitude = RootSeqRbanaAnalyzerOneAmplitude(self._context)


class RootSeqRbanaAnalyzerTwoAmplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.amplitude'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.amplitude.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.amplitude.regaddr', int(new_val))


class RootSeqRbanaAnalyzerTwoDeltafoffs_hi(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.deltafoffs_hi'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.deltafoffs_hi.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.deltafoffs_hi.regaddr', int(new_val))


class RootSeqRbanaAnalyzerTwoControl1Distdeltaf(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.control1.distdeltaf'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.control1.distdeltaf.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.control1.distdeltaf.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.control1.distdeltaf.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.control1.distdeltaf.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.control1.distdeltaf.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.control1.distdeltaf.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoControl1Outputsourceid(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.control1.outputsourceid'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.control1.outputsourceid.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.control1.outputsourceid.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.control1.outputsourceid.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.control1.outputsourceid.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.control1.outputsourceid.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.control1.outputsourceid.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoControl1Fltr_vld(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.control1.fltr_vld'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.control1.fltr_vld.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.control1.fltr_vld.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.control1.fltr_vld.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.control1.fltr_vld.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.control1.fltr_vld.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.control1.fltr_vld.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoControl1Clearflag(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.control1.clearflag'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.control1.clearflag.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.control1.clearflag.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.control1.clearflag.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.control1.clearflag.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.control1.clearflag.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.control1.clearflag.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoControl1Filtaddr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.control1.filtaddr'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.control1.filtaddr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.control1.filtaddr.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.control1.filtaddr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.control1.filtaddr.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.control1.filtaddr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.control1.filtaddr.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoControl1Enabledcblock(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.control1.enabledcblock'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.control1.enabledcblock.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.control1.enabledcblock.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.control1.enabledcblock.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.control1.enabledcblock.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.control1.enabledcblock.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.control1.enabledcblock.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoControl1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.control1'
        self.enabledcblock = RootSeqRbanaAnalyzerTwoControl1Enabledcblock(self._context)
        self.filtaddr = RootSeqRbanaAnalyzerTwoControl1Filtaddr(self._context)
        self.clearflag = RootSeqRbanaAnalyzerTwoControl1Clearflag(self._context)
        self.fltr_vld = RootSeqRbanaAnalyzerTwoControl1Fltr_vld(self._context)
        self.outputsourceid = RootSeqRbanaAnalyzerTwoControl1Outputsourceid(self._context)
        self.distdeltaf = RootSeqRbanaAnalyzerTwoControl1Distdeltaf(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.control1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.control1.regaddr', int(new_val))


class RootSeqRbanaAnalyzerTwoCtrlbitsAmpclearaccu(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.ctrlbits.ampclearaccu'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.ctrlbits.ampclearaccu.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.ctrlbits.ampclearaccu.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.ctrlbits.ampclearaccu.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.ctrlbits.ampclearaccu.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.ctrlbits.ampclearaccu.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.ctrlbits.ampclearaccu.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoCtrlbitsAmpmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.ctrlbits.ampmodulation'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.ctrlbits.ampmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.ctrlbits.ampmodulation.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.ctrlbits.ampmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.ctrlbits.ampmodulation.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.ctrlbits.ampmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.ctrlbits.ampmodulation.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoCtrlbitsPhasectrl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.ctrlbits.phasectrl'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.ctrlbits.phasectrl.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.ctrlbits.phasectrl.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.ctrlbits.phasectrl.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.ctrlbits.phasectrl.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.ctrlbits.phasectrl.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.ctrlbits.phasectrl.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoCtrlbitsAmpctrlmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.ctrlbits.ampctrlmode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.ctrlbits.ampctrlmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.ctrlbits.ampctrlmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.ctrlbits.ampctrlmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.ctrlbits.ampctrlmode.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.ctrlbits.ampctrlmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.ctrlbits.ampctrlmode.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoCtrlbitsPhaseclearaccu(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.ctrlbits.phaseclearaccu'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.ctrlbits.phaseclearaccu.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.ctrlbits.phaseclearaccu.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.ctrlbits.phaseclearaccu.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.ctrlbits.phaseclearaccu.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.ctrlbits.phaseclearaccu.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.ctrlbits.phaseclearaccu.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoCtrlbitsAmpctrlpositiveaccu(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.ctrlbits.ampctrlpositiveaccu'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.ctrlbits.ampctrlpositiveaccu.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.ctrlbits.ampctrlpositiveaccu.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.ctrlbits.ampctrlpositiveaccu.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.ctrlbits.ampctrlpositiveaccu.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.ctrlbits.ampctrlpositiveaccu.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.ctrlbits.ampctrlpositiveaccu.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoCtrlbits(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.ctrlbits'
        self.ampctrlpositiveaccu = RootSeqRbanaAnalyzerTwoCtrlbitsAmpctrlpositiveaccu(self._context)
        self.phaseclearaccu = RootSeqRbanaAnalyzerTwoCtrlbitsPhaseclearaccu(self._context)
        self.ampctrlmode = RootSeqRbanaAnalyzerTwoCtrlbitsAmpctrlmode(self._context)
        self.phasectrl = RootSeqRbanaAnalyzerTwoCtrlbitsPhasectrl(self._context)
        self.ampmodulation = RootSeqRbanaAnalyzerTwoCtrlbitsAmpmodulation(self._context)
        self.ampclearaccu = RootSeqRbanaAnalyzerTwoCtrlbitsAmpclearaccu(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.ctrlbits.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.ctrlbits.regaddr', int(new_val))


class RootSeqRbanaAnalyzerTwoDelaycomp(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.delaycomp'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.delaycomp.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.delaycomp.regaddr', int(new_val))


class RootSeqRbanaAnalyzerTwoModampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.modampkel'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.modampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.modampkel.regaddr', int(new_val))


class RootSeqRbanaAnalyzerTwoKiampkelShift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.kiampkel.shift'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kiampkel.shift.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kiampkel.shift.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kiampkel.shift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kiampkel.shift.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kiampkel.shift.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kiampkel.shift.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoKiampkelShiftdirection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.kiampkel.shiftdirection'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kiampkel.shiftdirection.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kiampkel.shiftdirection.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kiampkel.shiftdirection.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kiampkel.shiftdirection.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kiampkel.shiftdirection.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kiampkel.shiftdirection.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoKiampkelFactor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.kiampkel.factor'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kiampkel.factor.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kiampkel.factor.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kiampkel.factor.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kiampkel.factor.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kiampkel.factor.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kiampkel.factor.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoKiampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.kiampkel'
        self.factor = RootSeqRbanaAnalyzerTwoKiampkelFactor(self._context)
        self.shiftdirection = RootSeqRbanaAnalyzerTwoKiampkelShiftdirection(self._context)
        self.shift = RootSeqRbanaAnalyzerTwoKiampkelShift(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kiampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kiampkel.regaddr', int(new_val))


class RootSeqRbanaAnalyzerTwoFlag(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.flag'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.flag.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.flag.regaddr', int(new_val))


class RootSeqRbanaAnalyzerTwoKpampkelShift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.kpampkel.shift'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kpampkel.shift.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kpampkel.shift.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kpampkel.shift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kpampkel.shift.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kpampkel.shift.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kpampkel.shift.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoKpampkelShiftdirection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.kpampkel.shiftdirection'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kpampkel.shiftdirection.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kpampkel.shiftdirection.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kpampkel.shiftdirection.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kpampkel.shiftdirection.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kpampkel.shiftdirection.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kpampkel.shiftdirection.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoKpampkelFactor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.kpampkel.factor'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kpampkel.factor.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kpampkel.factor.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kpampkel.factor.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kpampkel.factor.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kpampkel.factor.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kpampkel.factor.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoKpampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.kpampkel'
        self.factor = RootSeqRbanaAnalyzerTwoKpampkelFactor(self._context)
        self.shiftdirection = RootSeqRbanaAnalyzerTwoKpampkelShiftdirection(self._context)
        self.shift = RootSeqRbanaAnalyzerTwoKpampkelShift(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kpampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kpampkel.regaddr', int(new_val))


class RootSeqRbanaAnalyzerTwoThreshold(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.threshold'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.threshold.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.threshold.regaddr', int(new_val))


class RootSeqRbanaAnalyzerTwoKpphaseShift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.kpphase.shift'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kpphase.shift.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kpphase.shift.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kpphase.shift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kpphase.shift.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kpphase.shift.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kpphase.shift.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoKpphaseShiftdirection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.kpphase.shiftdirection'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kpphase.shiftdirection.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kpphase.shiftdirection.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kpphase.shiftdirection.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kpphase.shiftdirection.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kpphase.shiftdirection.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kpphase.shiftdirection.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoKpphaseFactor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.kpphase.factor'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kpphase.factor.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kpphase.factor.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kpphase.factor.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kpphase.factor.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kpphase.factor.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kpphase.factor.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoKpphase(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.kpphase'
        self.factor = RootSeqRbanaAnalyzerTwoKpphaseFactor(self._context)
        self.shiftdirection = RootSeqRbanaAnalyzerTwoKpphaseShiftdirection(self._context)
        self.shift = RootSeqRbanaAnalyzerTwoKpphaseShift(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kpphase.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kpphase.regaddr', int(new_val))


class RootSeqRbanaAnalyzerTwoModeAnalyzerinput(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.mode.analyzerinput'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.mode.analyzerinput.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.mode.analyzerinput.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.mode.analyzerinput.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.mode.analyzerinput.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.mode.analyzerinput.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.mode.analyzerinput.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoModeInput(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.mode.input'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.mode.input.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.mode.input.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.mode.input.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.mode.input.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.mode.input.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.mode.input.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoModePhasedetref(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.mode.phasedetref'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.mode.phasedetref.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.mode.phasedetref.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.mode.phasedetref.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.mode.phasedetref.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.mode.phasedetref.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.mode.phasedetref.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoModeOpmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.mode.opmode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.mode.opmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.mode.opmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.mode.opmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.mode.opmode.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.mode.opmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.mode.opmode.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.mode'
        self.opmode = RootSeqRbanaAnalyzerTwoModeOpmode(self._context)
        self.phasedetref = RootSeqRbanaAnalyzerTwoModePhasedetref(self._context)
        self.input = RootSeqRbanaAnalyzerTwoModeInput(self._context)
        self.analyzerinput = RootSeqRbanaAnalyzerTwoModeAnalyzerinput(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.mode.regaddr', int(new_val))


class RootSeqRbanaAnalyzerTwoPhase(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.phase'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.phase.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.phase.regaddr', int(new_val))


class RootSeqRbanaAnalyzerTwoSafetipSafetip(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.safetip.safetip'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.safetip.safetip.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.safetip.safetip.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.safetip.safetip.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.safetip.safetip.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.safetip.safetip.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.safetip.safetip.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoSafetipSyncorsafetip(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.safetip.syncorsafetip'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.safetip.syncorsafetip.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.safetip.syncorsafetip.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.safetip.syncorsafetip.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.safetip.syncorsafetip.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.safetip.syncorsafetip.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.safetip.syncorsafetip.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoSafetipSafetipmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.safetip.safetipmode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.safetip.safetipmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.safetip.safetipmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.safetip.safetipmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.safetip.safetipmode.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.safetip.safetipmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.safetip.safetipmode.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoSafetipThresholdmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.safetip.thresholdmode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.safetip.thresholdmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.safetip.thresholdmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.safetip.thresholdmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.safetip.thresholdmode.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.safetip.thresholdmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.safetip.thresholdmode.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoSafetip(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.safetip'
        self.thresholdmode = RootSeqRbanaAnalyzerTwoSafetipThresholdmode(self._context)
        self.safetipmode = RootSeqRbanaAnalyzerTwoSafetipSafetipmode(self._context)
        self.syncorsafetip = RootSeqRbanaAnalyzerTwoSafetipSyncorsafetip(self._context)
        self.safetip = RootSeqRbanaAnalyzerTwoSafetipSafetip(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.safetip.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.safetip.regaddr', int(new_val))


class RootSeqRbanaAnalyzerTwoFltrcoeff(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.fltrcoeff'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.fltrcoeff.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.fltrcoeff.regaddr', int(new_val))


class RootSeqRbanaAnalyzerTwoLockrangeshift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.lockrangeshift'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.lockrangeshift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.lockrangeshift.regaddr', int(new_val))


class RootSeqRbanaAnalyzerTwoSetvalampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.setvalampkel'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.setvalampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.setvalampkel.regaddr', int(new_val))


class RootSeqRbanaAnalyzerTwoDeltaf(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.deltaf'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.deltaf.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.deltaf.regaddr', int(new_val))


class RootSeqRbanaAnalyzerTwoY(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.y'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.y.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.y.regaddr', int(new_val))


class RootSeqRbanaAnalyzerTwoX(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.x'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.x.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.x.regaddr', int(new_val))


class RootSeqRbanaAnalyzerTwoDisscp(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.disscp'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.disscp.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.disscp.regaddr', int(new_val))


class RootSeqRbanaAnalyzerTwoPhaseshift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.phaseshift'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.phaseshift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.phaseshift.regaddr', int(new_val))


class RootSeqRbanaAnalyzerTwoDeltafoffs_lo(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.deltafoffs_lo'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.deltafoffs_lo.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.deltafoffs_lo.regaddr', int(new_val))


class RootSeqRbanaAnalyzerTwoCenterfreq_hi(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.centerfreq_hi'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.centerfreq_hi.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.centerfreq_hi.regaddr', int(new_val))


class RootSeqRbanaAnalyzerTwoKiphaseShift(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.kiphase.shift'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kiphase.shift.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kiphase.shift.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kiphase.shift.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kiphase.shift.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kiphase.shift.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kiphase.shift.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoKiphaseShiftdirection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.kiphase.shiftdirection'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kiphase.shiftdirection.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kiphase.shiftdirection.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kiphase.shiftdirection.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kiphase.shiftdirection.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kiphase.shiftdirection.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kiphase.shiftdirection.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoKiphaseFactor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.kiphase.factor'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kiphase.factor.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kiphase.factor.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kiphase.factor.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kiphase.factor.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kiphase.factor.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kiphase.factor.lsb', int(new_val))


class RootSeqRbanaAnalyzerTwoKiphase(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.kiphase'
        self.factor = RootSeqRbanaAnalyzerTwoKiphaseFactor(self._context)
        self.shiftdirection = RootSeqRbanaAnalyzerTwoKiphaseShiftdirection(self._context)
        self.shift = RootSeqRbanaAnalyzerTwoKiphaseShift(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.kiphase.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.kiphase.regaddr', int(new_val))


class RootSeqRbanaAnalyzerTwoSetptampkel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.setptampkel'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.setptampkel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.setptampkel.regaddr', int(new_val))


class RootSeqRbanaAnalyzerTwoCenterfreq_lo(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two.centerfreq_lo'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzer.two.centerfreq_lo.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzer.two.centerfreq_lo.regaddr', int(new_val))


class RootSeqRbanaAnalyzerTwo(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer.two'
        self.centerfreq_lo = RootSeqRbanaAnalyzerTwoCenterfreq_lo(self._context)
        self.setptampkel = RootSeqRbanaAnalyzerTwoSetptampkel(self._context)
        self.kiphase = RootSeqRbanaAnalyzerTwoKiphase(self._context)
        self.centerfreq_hi = RootSeqRbanaAnalyzerTwoCenterfreq_hi(self._context)
        self.deltafoffs_lo = RootSeqRbanaAnalyzerTwoDeltafoffs_lo(self._context)
        self.phaseshift = RootSeqRbanaAnalyzerTwoPhaseshift(self._context)
        self.disscp = RootSeqRbanaAnalyzerTwoDisscp(self._context)
        self.x = RootSeqRbanaAnalyzerTwoX(self._context)
        self.y = RootSeqRbanaAnalyzerTwoY(self._context)
        self.deltaf = RootSeqRbanaAnalyzerTwoDeltaf(self._context)
        self.setvalampkel = RootSeqRbanaAnalyzerTwoSetvalampkel(self._context)
        self.lockrangeshift = RootSeqRbanaAnalyzerTwoLockrangeshift(self._context)
        self.fltrcoeff = RootSeqRbanaAnalyzerTwoFltrcoeff(self._context)
        self.safetip = RootSeqRbanaAnalyzerTwoSafetip(self._context)
        self.phase = RootSeqRbanaAnalyzerTwoPhase(self._context)
        self.mode = RootSeqRbanaAnalyzerTwoMode(self._context)
        self.kpphase = RootSeqRbanaAnalyzerTwoKpphase(self._context)
        self.threshold = RootSeqRbanaAnalyzerTwoThreshold(self._context)
        self.kpampkel = RootSeqRbanaAnalyzerTwoKpampkel(self._context)
        self.flag = RootSeqRbanaAnalyzerTwoFlag(self._context)
        self.kiampkel = RootSeqRbanaAnalyzerTwoKiampkel(self._context)
        self.modampkel = RootSeqRbanaAnalyzerTwoModampkel(self._context)
        self.delaycomp = RootSeqRbanaAnalyzerTwoDelaycomp(self._context)
        self.ctrlbits = RootSeqRbanaAnalyzerTwoCtrlbits(self._context)
        self.control1 = RootSeqRbanaAnalyzerTwoControl1(self._context)
        self.deltafoffs_hi = RootSeqRbanaAnalyzerTwoDeltafoffs_hi(self._context)
        self.amplitude = RootSeqRbanaAnalyzerTwoAmplitude(self._context)


class RootSeqRbanaAnalyzer(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzer'
        self.two = RootSeqRbanaAnalyzerTwo(self._context)
        self.one = RootSeqRbanaAnalyzerOne(self._context)


class RootSeqRbanaAnalyzercommonSgleControlHarmoncinput(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzercommon.sgle.control.harmoncinput'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzercommon.sgle.control.harmoncinput.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzercommon.sgle.control.harmoncinput.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzercommon.sgle.control.harmoncinput.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzercommon.sgle.control.harmoncinput.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzercommon.sgle.control.harmoncinput.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.analyzercommon.sgle.control.harmoncinput.lsb', int(new_val))


class RootSeqRbanaAnalyzercommonSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzercommon.sgle.control'
        self.harmoncinput = RootSeqRbanaAnalyzercommonSgleControlHarmoncinput(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.analyzercommon.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.analyzercommon.sgle.control.regaddr', int(new_val))


class RootSeqRbanaAnalyzercommonSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzercommon.sgle'
        self.control = RootSeqRbanaAnalyzercommonSgleControl(self._context)


class RootSeqRbanaAnalyzercommon(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.analyzercommon'
        self.sgle = RootSeqRbanaAnalyzercommonSgle(self._context)


class RootSeqRbanaGpiSgleIrqenaRampgenuser4done(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.gpi.sgle.irqena.rampgenuser4done'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqena.rampgenuser4done.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqena.rampgenuser4done.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqena.rampgenuser4done.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqena.rampgenuser4done.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqena.rampgenuser4done.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqena.rampgenuser4done.lsb', int(new_val))


class RootSeqRbanaGpiSgleIrqenaEventmgrdone(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.gpi.sgle.irqena.eventmgrdone'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqena.eventmgrdone.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqena.eventmgrdone.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqena.eventmgrdone.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqena.eventmgrdone.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqena.eventmgrdone.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqena.eventmgrdone.lsb', int(new_val))


class RootSeqRbanaGpiSgleIrqenaUserdigi1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.gpi.sgle.irqena.userdigi1'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqena.userdigi1.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqena.userdigi1.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqena.userdigi1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqena.userdigi1.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqena.userdigi1.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqena.userdigi1.lsb', int(new_val))


class RootSeqRbanaGpiSgleIrqenaUserdigi2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.gpi.sgle.irqena.userdigi2'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqena.userdigi2.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqena.userdigi2.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqena.userdigi2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqena.userdigi2.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqena.userdigi2.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqena.userdigi2.lsb', int(new_val))


class RootSeqRbanaGpiSgleIrqenaRampgentestdone(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.gpi.sgle.irqena.rampgentestdone'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqena.rampgentestdone.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqena.rampgentestdone.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqena.rampgentestdone.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqena.rampgentestdone.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqena.rampgentestdone.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqena.rampgentestdone.lsb', int(new_val))


class RootSeqRbanaGpiSgleIrqenaEventmgrstop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.gpi.sgle.irqena.eventmgrstop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqena.eventmgrstop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqena.eventmgrstop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqena.eventmgrstop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqena.eventmgrstop.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqena.eventmgrstop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqena.eventmgrstop.lsb', int(new_val))


class RootSeqRbanaGpiSgleIrqenaEventmgrabort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.gpi.sgle.irqena.eventmgrabort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqena.eventmgrabort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqena.eventmgrabort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqena.eventmgrabort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqena.eventmgrabort.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqena.eventmgrabort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqena.eventmgrabort.lsb', int(new_val))


class RootSeqRbanaGpiSgleIrqena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.gpi.sgle.irqena'
        self.eventmgrabort = RootSeqRbanaGpiSgleIrqenaEventmgrabort(self._context)
        self.eventmgrstop = RootSeqRbanaGpiSgleIrqenaEventmgrstop(self._context)
        self.rampgentestdone = RootSeqRbanaGpiSgleIrqenaRampgentestdone(self._context)
        self.userdigi2 = RootSeqRbanaGpiSgleIrqenaUserdigi2(self._context)
        self.userdigi1 = RootSeqRbanaGpiSgleIrqenaUserdigi1(self._context)
        self.eventmgrdone = RootSeqRbanaGpiSgleIrqenaEventmgrdone(self._context)
        self.rampgenuser4done = RootSeqRbanaGpiSgleIrqenaRampgenuser4done(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqena.regaddr', int(new_val))


class RootSeqRbanaGpiSgleIrqvecRampgenuser4done(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.gpi.sgle.irqvec.rampgenuser4done'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqvec.rampgenuser4done.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqvec.rampgenuser4done.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqvec.rampgenuser4done.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqvec.rampgenuser4done.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqvec.rampgenuser4done.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqvec.rampgenuser4done.lsb', int(new_val))


class RootSeqRbanaGpiSgleIrqvecEventmgrdone(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.gpi.sgle.irqvec.eventmgrdone'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqvec.eventmgrdone.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqvec.eventmgrdone.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqvec.eventmgrdone.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqvec.eventmgrdone.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqvec.eventmgrdone.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqvec.eventmgrdone.lsb', int(new_val))


class RootSeqRbanaGpiSgleIrqvecUserdigi1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.gpi.sgle.irqvec.userdigi1'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqvec.userdigi1.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqvec.userdigi1.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqvec.userdigi1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqvec.userdigi1.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqvec.userdigi1.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqvec.userdigi1.lsb', int(new_val))


class RootSeqRbanaGpiSgleIrqvecUserdigi2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.gpi.sgle.irqvec.userdigi2'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqvec.userdigi2.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqvec.userdigi2.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqvec.userdigi2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqvec.userdigi2.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqvec.userdigi2.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqvec.userdigi2.lsb', int(new_val))


class RootSeqRbanaGpiSgleIrqvecRampgentestdone(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.gpi.sgle.irqvec.rampgentestdone'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqvec.rampgentestdone.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqvec.rampgentestdone.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqvec.rampgentestdone.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqvec.rampgentestdone.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqvec.rampgentestdone.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqvec.rampgentestdone.lsb', int(new_val))


class RootSeqRbanaGpiSgleIrqvecEventmgrstop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.gpi.sgle.irqvec.eventmgrstop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqvec.eventmgrstop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqvec.eventmgrstop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqvec.eventmgrstop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqvec.eventmgrstop.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqvec.eventmgrstop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqvec.eventmgrstop.lsb', int(new_val))


class RootSeqRbanaGpiSgleIrqvecEventmgrabort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.gpi.sgle.irqvec.eventmgrabort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqvec.eventmgrabort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqvec.eventmgrabort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqvec.eventmgrabort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqvec.eventmgrabort.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqvec.eventmgrabort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqvec.eventmgrabort.lsb', int(new_val))


class RootSeqRbanaGpiSgleIrqvec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.gpi.sgle.irqvec'
        self.eventmgrabort = RootSeqRbanaGpiSgleIrqvecEventmgrabort(self._context)
        self.eventmgrstop = RootSeqRbanaGpiSgleIrqvecEventmgrstop(self._context)
        self.rampgentestdone = RootSeqRbanaGpiSgleIrqvecRampgentestdone(self._context)
        self.userdigi2 = RootSeqRbanaGpiSgleIrqvecUserdigi2(self._context)
        self.userdigi1 = RootSeqRbanaGpiSgleIrqvecUserdigi1(self._context)
        self.eventmgrdone = RootSeqRbanaGpiSgleIrqvecEventmgrdone(self._context)
        self.rampgenuser4done = RootSeqRbanaGpiSgleIrqvecRampgenuser4done(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.irqvec.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.irqvec.regaddr', int(new_val))


class RootSeqRbanaGpiSgleOdata(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.gpi.sgle.odata'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.odata.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.odata.regaddr', int(new_val))


class RootSeqRbanaGpiSgleIdataRampgenuser4done(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.gpi.sgle.idata.rampgenuser4done'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.idata.rampgenuser4done.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.idata.rampgenuser4done.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.idata.rampgenuser4done.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.idata.rampgenuser4done.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.idata.rampgenuser4done.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.idata.rampgenuser4done.lsb', int(new_val))


class RootSeqRbanaGpiSgleIdataEventmgrdone(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.gpi.sgle.idata.eventmgrdone'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.idata.eventmgrdone.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.idata.eventmgrdone.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.idata.eventmgrdone.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.idata.eventmgrdone.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.idata.eventmgrdone.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.idata.eventmgrdone.lsb', int(new_val))


class RootSeqRbanaGpiSgleIdataUserdigi1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.gpi.sgle.idata.userdigi1'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.idata.userdigi1.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.idata.userdigi1.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.idata.userdigi1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.idata.userdigi1.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.idata.userdigi1.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.idata.userdigi1.lsb', int(new_val))


class RootSeqRbanaGpiSgleIdataUserdigi2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.gpi.sgle.idata.userdigi2'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.idata.userdigi2.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.idata.userdigi2.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.idata.userdigi2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.idata.userdigi2.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.idata.userdigi2.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.idata.userdigi2.lsb', int(new_val))


class RootSeqRbanaGpiSgleIdataRampgentestdone(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.gpi.sgle.idata.rampgentestdone'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.idata.rampgentestdone.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.idata.rampgentestdone.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.idata.rampgentestdone.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.idata.rampgentestdone.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.idata.rampgentestdone.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.idata.rampgentestdone.lsb', int(new_val))


class RootSeqRbanaGpiSgleIdataEventmgrstop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.gpi.sgle.idata.eventmgrstop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.idata.eventmgrstop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.idata.eventmgrstop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.idata.eventmgrstop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.idata.eventmgrstop.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.idata.eventmgrstop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.idata.eventmgrstop.lsb', int(new_val))


class RootSeqRbanaGpiSgleIdataEventmgrabort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.gpi.sgle.idata.eventmgrabort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.idata.eventmgrabort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.idata.eventmgrabort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.idata.eventmgrabort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.idata.eventmgrabort.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.idata.eventmgrabort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.idata.eventmgrabort.lsb', int(new_val))


class RootSeqRbanaGpiSgleIdata(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.gpi.sgle.idata'
        self.eventmgrabort = RootSeqRbanaGpiSgleIdataEventmgrabort(self._context)
        self.eventmgrstop = RootSeqRbanaGpiSgleIdataEventmgrstop(self._context)
        self.rampgentestdone = RootSeqRbanaGpiSgleIdataRampgentestdone(self._context)
        self.userdigi2 = RootSeqRbanaGpiSgleIdataUserdigi2(self._context)
        self.userdigi1 = RootSeqRbanaGpiSgleIdataUserdigi1(self._context)
        self.eventmgrdone = RootSeqRbanaGpiSgleIdataEventmgrdone(self._context)
        self.rampgenuser4done = RootSeqRbanaGpiSgleIdataRampgenuser4done(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.gpi.sgle.idata.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.gpi.sgle.idata.regaddr', int(new_val))


class RootSeqRbanaGpiSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.gpi.sgle'
        self.idata = RootSeqRbanaGpiSgleIdata(self._context)
        self.odata = RootSeqRbanaGpiSgleOdata(self._context)
        self.irqvec = RootSeqRbanaGpiSgleIrqvec(self._context)
        self.irqena = RootSeqRbanaGpiSgleIrqena(self._context)


class RootSeqRbanaGpi(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.gpi'
        self.sgle = RootSeqRbanaGpiSgle(self._context)


class RootSeqRbanaPidPidyMinvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidy.minvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.minvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.minvalue.regaddr', int(new_val))


class RootSeqRbanaPidPidyErrorlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidy.errorlimit'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.errorlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.errorlimit.regaddr', int(new_val))


class RootSeqRbanaPidPidyMaxvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidy.maxvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.maxvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.maxvalue.regaddr', int(new_val))


class RootSeqRbanaPidPidyGain_d(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidy.gain_d'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.gain_d.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.gain_d.regaddr', int(new_val))


class RootSeqRbanaPidPidyGain_i(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidy.gain_i'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.gain_i.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.gain_i.regaddr', int(new_val))


class RootSeqRbanaPidPidyControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidy.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.mode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.mode.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.mode.lsb', int(new_val))


class RootSeqRbanaPidPidyControlPidinputactual(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidy.control.pidinputactual'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.pidinputactual.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.pidinputactual.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.pidinputactual.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.pidinputactual.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.pidinputactual.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.pidinputactual.lsb', int(new_val))


class RootSeqRbanaPidPidyControlOutsel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidy.control.outsel'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.outsel.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.outsel.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.outsel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.outsel.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.outsel.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.outsel.lsb', int(new_val))


class RootSeqRbanaPidPidyControlPidinputsetpoint(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidy.control.pidinputsetpoint'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.pidinputsetpoint.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.pidinputsetpoint.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.pidinputsetpoint.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.pidinputsetpoint.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.pidinputsetpoint.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.pidinputsetpoint.lsb', int(new_val))


class RootSeqRbanaPidPidyControlPolpidin(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidy.control.polpidin'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.polpidin.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.polpidin.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.polpidin.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.polpidin.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.polpidin.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.polpidin.lsb', int(new_val))


class RootSeqRbanaPidPidyControlMedianfilterena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidy.control.medianfilterena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.medianfilterena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.medianfilterena.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.medianfilterena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.medianfilterena.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.medianfilterena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.medianfilterena.lsb', int(new_val))


class RootSeqRbanaPidPidyControlLoadinterna(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidy.control.loadinterna'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.loadinterna.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.loadinterna.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.loadinterna.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.loadinterna.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.loadinterna.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.loadinterna.lsb', int(new_val))


class RootSeqRbanaPidPidyControlPolcomperrlim(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidy.control.polcomperrlim'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.polcomperrlim.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.polcomperrlim.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.polcomperrlim.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.polcomperrlim.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.polcomperrlim.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.polcomperrlim.lsb', int(new_val))


class RootSeqRbanaPidPidyControlMemorygendriveena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidy.control.memorygendriveena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.memorygendriveena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.memorygendriveena.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.memorygendriveena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.memorygendriveena.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.memorygendriveena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.memorygendriveena.lsb', int(new_val))


class RootSeqRbanaPidPidyControlMemorygenpositionena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidy.control.memorygenpositionena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.memorygenpositionena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.memorygenpositionena.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.memorygenpositionena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.memorygenpositionena.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.memorygenpositionena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.memorygenpositionena.lsb', int(new_val))


class RootSeqRbanaPidPidyControlModena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidy.control.modena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.modena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.modena.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.modena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.modena.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.modena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.modena.lsb', int(new_val))


class RootSeqRbanaPidPidyControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidy.control'
        self.modena = RootSeqRbanaPidPidyControlModena(self._context)
        self.memorygenpositionena = RootSeqRbanaPidPidyControlMemorygenpositionena(self._context)
        self.memorygendriveena = RootSeqRbanaPidPidyControlMemorygendriveena(self._context)
        self.polcomperrlim = RootSeqRbanaPidPidyControlPolcomperrlim(self._context)
        self.loadinterna = RootSeqRbanaPidPidyControlLoadinterna(self._context)
        self.medianfilterena = RootSeqRbanaPidPidyControlMedianfilterena(self._context)
        self.polpidin = RootSeqRbanaPidPidyControlPolpidin(self._context)
        self.pidinputsetpoint = RootSeqRbanaPidPidyControlPidinputsetpoint(self._context)
        self.outsel = RootSeqRbanaPidPidyControlOutsel(self._context)
        self.pidinputactual = RootSeqRbanaPidPidyControlPidinputactual(self._context)
        self.mode = RootSeqRbanaPidPidyControlMode(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.control.regaddr', int(new_val))


class RootSeqRbanaPidPidyGain_p(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidy.gain_p'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.gain_p.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.gain_p.regaddr', int(new_val))


class RootSeqRbanaPidPidyOffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidy.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.offset.regaddr', int(new_val))


class RootSeqRbanaPidPidyConversion(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidy.conversion'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.conversion.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.conversion.regaddr', int(new_val))


class RootSeqRbanaPidPidyStatusReachedmin(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidy.status.reachedmin'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.status.reachedmin.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.status.reachedmin.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.status.reachedmin.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.status.reachedmin.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.status.reachedmin.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.status.reachedmin.lsb', int(new_val))


class RootSeqRbanaPidPidyStatusReachederrlim(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidy.status.reachederrlim'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.status.reachederrlim.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.status.reachederrlim.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.status.reachederrlim.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.status.reachederrlim.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.status.reachederrlim.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.status.reachederrlim.lsb', int(new_val))


class RootSeqRbanaPidPidyStatusReachedmax(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidy.status.reachedmax'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.status.reachedmax.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.status.reachedmax.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.status.reachedmax.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.status.reachedmax.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.status.reachedmax.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.status.reachedmax.lsb', int(new_val))


class RootSeqRbanaPidPidyStatusInternaloaded(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidy.status.internaloaded'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.status.internaloaded.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.status.internaloaded.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.status.internaloaded.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.status.internaloaded.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.status.internaloaded.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.status.internaloaded.lsb', int(new_val))


class RootSeqRbanaPidPidyStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidy.status'
        self.internaloaded = RootSeqRbanaPidPidyStatusInternaloaded(self._context)
        self.reachedmax = RootSeqRbanaPidPidyStatusReachedmax(self._context)
        self.reachederrlim = RootSeqRbanaPidPidyStatusReachederrlim(self._context)
        self.reachedmin = RootSeqRbanaPidPidyStatusReachedmin(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.status.regaddr', int(new_val))


class RootSeqRbanaPidPidySlope(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidy.slope'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.slope.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.slope.regaddr', int(new_val))


class RootSeqRbanaPidPidyPreloadvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidy.preloadvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidy.preloadvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidy.preloadvalue.regaddr', int(new_val))


class RootSeqRbanaPidPidy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidy'
        self.preloadvalue = RootSeqRbanaPidPidyPreloadvalue(self._context)
        self.slope = RootSeqRbanaPidPidySlope(self._context)
        self.status = RootSeqRbanaPidPidyStatus(self._context)
        self.conversion = RootSeqRbanaPidPidyConversion(self._context)
        self.offset = RootSeqRbanaPidPidyOffset(self._context)
        self.gain_p = RootSeqRbanaPidPidyGain_p(self._context)
        self.control = RootSeqRbanaPidPidyControl(self._context)
        self.gain_i = RootSeqRbanaPidPidyGain_i(self._context)
        self.gain_d = RootSeqRbanaPidPidyGain_d(self._context)
        self.maxvalue = RootSeqRbanaPidPidyMaxvalue(self._context)
        self.errorlimit = RootSeqRbanaPidPidyErrorlimit(self._context)
        self.minvalue = RootSeqRbanaPidPidyMinvalue(self._context)


class RootSeqRbanaPidPidwMinvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidw.minvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.minvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.minvalue.regaddr', int(new_val))


class RootSeqRbanaPidPidwErrorlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidw.errorlimit'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.errorlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.errorlimit.regaddr', int(new_val))


class RootSeqRbanaPidPidwMaxvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidw.maxvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.maxvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.maxvalue.regaddr', int(new_val))


class RootSeqRbanaPidPidwGain_d(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidw.gain_d'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.gain_d.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.gain_d.regaddr', int(new_val))


class RootSeqRbanaPidPidwGain_i(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidw.gain_i'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.gain_i.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.gain_i.regaddr', int(new_val))


class RootSeqRbanaPidPidwControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidw.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.mode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.mode.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.mode.lsb', int(new_val))


class RootSeqRbanaPidPidwControlPidinputactual(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidw.control.pidinputactual'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.pidinputactual.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.pidinputactual.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.pidinputactual.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.pidinputactual.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.pidinputactual.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.pidinputactual.lsb', int(new_val))


class RootSeqRbanaPidPidwControlOutsel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidw.control.outsel'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.outsel.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.outsel.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.outsel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.outsel.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.outsel.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.outsel.lsb', int(new_val))


class RootSeqRbanaPidPidwControlPidinputsetpoint(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidw.control.pidinputsetpoint'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.pidinputsetpoint.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.pidinputsetpoint.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.pidinputsetpoint.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.pidinputsetpoint.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.pidinputsetpoint.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.pidinputsetpoint.lsb', int(new_val))


class RootSeqRbanaPidPidwControlPolpidin(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidw.control.polpidin'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.polpidin.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.polpidin.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.polpidin.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.polpidin.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.polpidin.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.polpidin.lsb', int(new_val))


class RootSeqRbanaPidPidwControlMedianfilterena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidw.control.medianfilterena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.medianfilterena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.medianfilterena.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.medianfilterena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.medianfilterena.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.medianfilterena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.medianfilterena.lsb', int(new_val))


class RootSeqRbanaPidPidwControlLoadinterna(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidw.control.loadinterna'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.loadinterna.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.loadinterna.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.loadinterna.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.loadinterna.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.loadinterna.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.loadinterna.lsb', int(new_val))


class RootSeqRbanaPidPidwControlPolcomperrlim(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidw.control.polcomperrlim'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.polcomperrlim.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.polcomperrlim.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.polcomperrlim.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.polcomperrlim.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.polcomperrlim.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.polcomperrlim.lsb', int(new_val))


class RootSeqRbanaPidPidwControlMemorygendriveena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidw.control.memorygendriveena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.memorygendriveena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.memorygendriveena.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.memorygendriveena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.memorygendriveena.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.memorygendriveena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.memorygendriveena.lsb', int(new_val))


class RootSeqRbanaPidPidwControlMemorygenpositionena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidw.control.memorygenpositionena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.memorygenpositionena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.memorygenpositionena.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.memorygenpositionena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.memorygenpositionena.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.memorygenpositionena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.memorygenpositionena.lsb', int(new_val))


class RootSeqRbanaPidPidwControlModena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidw.control.modena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.modena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.modena.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.modena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.modena.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.modena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.modena.lsb', int(new_val))


class RootSeqRbanaPidPidwControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidw.control'
        self.modena = RootSeqRbanaPidPidwControlModena(self._context)
        self.memorygenpositionena = RootSeqRbanaPidPidwControlMemorygenpositionena(self._context)
        self.memorygendriveena = RootSeqRbanaPidPidwControlMemorygendriveena(self._context)
        self.polcomperrlim = RootSeqRbanaPidPidwControlPolcomperrlim(self._context)
        self.loadinterna = RootSeqRbanaPidPidwControlLoadinterna(self._context)
        self.medianfilterena = RootSeqRbanaPidPidwControlMedianfilterena(self._context)
        self.polpidin = RootSeqRbanaPidPidwControlPolpidin(self._context)
        self.pidinputsetpoint = RootSeqRbanaPidPidwControlPidinputsetpoint(self._context)
        self.outsel = RootSeqRbanaPidPidwControlOutsel(self._context)
        self.pidinputactual = RootSeqRbanaPidPidwControlPidinputactual(self._context)
        self.mode = RootSeqRbanaPidPidwControlMode(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.control.regaddr', int(new_val))


class RootSeqRbanaPidPidwGain_p(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidw.gain_p'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.gain_p.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.gain_p.regaddr', int(new_val))


class RootSeqRbanaPidPidwOffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidw.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.offset.regaddr', int(new_val))


class RootSeqRbanaPidPidwConversion(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidw.conversion'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.conversion.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.conversion.regaddr', int(new_val))


class RootSeqRbanaPidPidwStatusReachedmin(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidw.status.reachedmin'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.status.reachedmin.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.status.reachedmin.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.status.reachedmin.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.status.reachedmin.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.status.reachedmin.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.status.reachedmin.lsb', int(new_val))


class RootSeqRbanaPidPidwStatusReachederrlim(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidw.status.reachederrlim'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.status.reachederrlim.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.status.reachederrlim.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.status.reachederrlim.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.status.reachederrlim.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.status.reachederrlim.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.status.reachederrlim.lsb', int(new_val))


class RootSeqRbanaPidPidwStatusReachedmax(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidw.status.reachedmax'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.status.reachedmax.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.status.reachedmax.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.status.reachedmax.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.status.reachedmax.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.status.reachedmax.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.status.reachedmax.lsb', int(new_val))


class RootSeqRbanaPidPidwStatusInternaloaded(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidw.status.internaloaded'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.status.internaloaded.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.status.internaloaded.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.status.internaloaded.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.status.internaloaded.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.status.internaloaded.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.status.internaloaded.lsb', int(new_val))


class RootSeqRbanaPidPidwStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidw.status'
        self.internaloaded = RootSeqRbanaPidPidwStatusInternaloaded(self._context)
        self.reachedmax = RootSeqRbanaPidPidwStatusReachedmax(self._context)
        self.reachederrlim = RootSeqRbanaPidPidwStatusReachederrlim(self._context)
        self.reachedmin = RootSeqRbanaPidPidwStatusReachedmin(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.status.regaddr', int(new_val))


class RootSeqRbanaPidPidwSlope(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidw.slope'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.slope.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.slope.regaddr', int(new_val))


class RootSeqRbanaPidPidwPreloadvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidw.preloadvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidw.preloadvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidw.preloadvalue.regaddr', int(new_val))


class RootSeqRbanaPidPidw(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidw'
        self.preloadvalue = RootSeqRbanaPidPidwPreloadvalue(self._context)
        self.slope = RootSeqRbanaPidPidwSlope(self._context)
        self.status = RootSeqRbanaPidPidwStatus(self._context)
        self.conversion = RootSeqRbanaPidPidwConversion(self._context)
        self.offset = RootSeqRbanaPidPidwOffset(self._context)
        self.gain_p = RootSeqRbanaPidPidwGain_p(self._context)
        self.control = RootSeqRbanaPidPidwControl(self._context)
        self.gain_i = RootSeqRbanaPidPidwGain_i(self._context)
        self.gain_d = RootSeqRbanaPidPidwGain_d(self._context)
        self.maxvalue = RootSeqRbanaPidPidwMaxvalue(self._context)
        self.errorlimit = RootSeqRbanaPidPidwErrorlimit(self._context)
        self.minvalue = RootSeqRbanaPidPidwMinvalue(self._context)


class RootSeqRbanaPidPiduser2Minvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser2.minvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.minvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.minvalue.regaddr', int(new_val))


class RootSeqRbanaPidPiduser2Errorlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser2.errorlimit'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.errorlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.errorlimit.regaddr', int(new_val))


class RootSeqRbanaPidPiduser2Maxvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser2.maxvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.maxvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.maxvalue.regaddr', int(new_val))


class RootSeqRbanaPidPiduser2Gain_d(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser2.gain_d'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.gain_d.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.gain_d.regaddr', int(new_val))


class RootSeqRbanaPidPiduser2Gain_i(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser2.gain_i'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.gain_i.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.gain_i.regaddr', int(new_val))


class RootSeqRbanaPidPiduser2ControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser2.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.mode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.mode.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.mode.lsb', int(new_val))


class RootSeqRbanaPidPiduser2ControlPidinputactual(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser2.control.pidinputactual'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.pidinputactual.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.pidinputactual.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.pidinputactual.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.pidinputactual.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.pidinputactual.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.pidinputactual.lsb', int(new_val))


class RootSeqRbanaPidPiduser2ControlOutsel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser2.control.outsel'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.outsel.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.outsel.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.outsel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.outsel.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.outsel.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.outsel.lsb', int(new_val))


class RootSeqRbanaPidPiduser2ControlPidinputsetpoint(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser2.control.pidinputsetpoint'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.pidinputsetpoint.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.pidinputsetpoint.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.pidinputsetpoint.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.pidinputsetpoint.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.pidinputsetpoint.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.pidinputsetpoint.lsb', int(new_val))


class RootSeqRbanaPidPiduser2ControlPolpidin(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser2.control.polpidin'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.polpidin.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.polpidin.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.polpidin.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.polpidin.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.polpidin.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.polpidin.lsb', int(new_val))


class RootSeqRbanaPidPiduser2ControlMedianfilterena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser2.control.medianfilterena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.medianfilterena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.medianfilterena.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.medianfilterena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.medianfilterena.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.medianfilterena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.medianfilterena.lsb', int(new_val))


class RootSeqRbanaPidPiduser2ControlLoadinterna(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser2.control.loadinterna'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.loadinterna.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.loadinterna.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.loadinterna.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.loadinterna.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.loadinterna.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.loadinterna.lsb', int(new_val))


class RootSeqRbanaPidPiduser2ControlPolcomperrlim(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser2.control.polcomperrlim'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.polcomperrlim.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.polcomperrlim.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.polcomperrlim.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.polcomperrlim.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.polcomperrlim.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.polcomperrlim.lsb', int(new_val))


class RootSeqRbanaPidPiduser2ControlMemorygendriveena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser2.control.memorygendriveena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.memorygendriveena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.memorygendriveena.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.memorygendriveena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.memorygendriveena.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.memorygendriveena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.memorygendriveena.lsb', int(new_val))


class RootSeqRbanaPidPiduser2ControlMemorygenpositionena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser2.control.memorygenpositionena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.memorygenpositionena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.memorygenpositionena.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.memorygenpositionena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.memorygenpositionena.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.memorygenpositionena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.memorygenpositionena.lsb', int(new_val))


class RootSeqRbanaPidPiduser2ControlModena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser2.control.modena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.modena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.modena.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.modena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.modena.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.modena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.modena.lsb', int(new_val))


class RootSeqRbanaPidPiduser2Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser2.control'
        self.modena = RootSeqRbanaPidPiduser2ControlModena(self._context)
        self.memorygenpositionena = RootSeqRbanaPidPiduser2ControlMemorygenpositionena(self._context)
        self.memorygendriveena = RootSeqRbanaPidPiduser2ControlMemorygendriveena(self._context)
        self.polcomperrlim = RootSeqRbanaPidPiduser2ControlPolcomperrlim(self._context)
        self.loadinterna = RootSeqRbanaPidPiduser2ControlLoadinterna(self._context)
        self.medianfilterena = RootSeqRbanaPidPiduser2ControlMedianfilterena(self._context)
        self.polpidin = RootSeqRbanaPidPiduser2ControlPolpidin(self._context)
        self.pidinputsetpoint = RootSeqRbanaPidPiduser2ControlPidinputsetpoint(self._context)
        self.outsel = RootSeqRbanaPidPiduser2ControlOutsel(self._context)
        self.pidinputactual = RootSeqRbanaPidPiduser2ControlPidinputactual(self._context)
        self.mode = RootSeqRbanaPidPiduser2ControlMode(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.control.regaddr', int(new_val))


class RootSeqRbanaPidPiduser2Gain_p(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser2.gain_p'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.gain_p.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.gain_p.regaddr', int(new_val))


class RootSeqRbanaPidPiduser2Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser2.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.offset.regaddr', int(new_val))


class RootSeqRbanaPidPiduser2Conversion(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser2.conversion'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.conversion.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.conversion.regaddr', int(new_val))


class RootSeqRbanaPidPiduser2StatusReachedmin(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser2.status.reachedmin'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.status.reachedmin.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.status.reachedmin.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.status.reachedmin.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.status.reachedmin.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.status.reachedmin.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.status.reachedmin.lsb', int(new_val))


class RootSeqRbanaPidPiduser2StatusReachederrlim(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser2.status.reachederrlim'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.status.reachederrlim.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.status.reachederrlim.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.status.reachederrlim.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.status.reachederrlim.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.status.reachederrlim.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.status.reachederrlim.lsb', int(new_val))


class RootSeqRbanaPidPiduser2StatusReachedmax(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser2.status.reachedmax'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.status.reachedmax.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.status.reachedmax.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.status.reachedmax.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.status.reachedmax.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.status.reachedmax.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.status.reachedmax.lsb', int(new_val))


class RootSeqRbanaPidPiduser2StatusInternaloaded(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser2.status.internaloaded'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.status.internaloaded.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.status.internaloaded.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.status.internaloaded.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.status.internaloaded.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.status.internaloaded.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.status.internaloaded.lsb', int(new_val))


class RootSeqRbanaPidPiduser2Status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser2.status'
        self.internaloaded = RootSeqRbanaPidPiduser2StatusInternaloaded(self._context)
        self.reachedmax = RootSeqRbanaPidPiduser2StatusReachedmax(self._context)
        self.reachederrlim = RootSeqRbanaPidPiduser2StatusReachederrlim(self._context)
        self.reachedmin = RootSeqRbanaPidPiduser2StatusReachedmin(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.status.regaddr', int(new_val))


class RootSeqRbanaPidPiduser2Slope(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser2.slope'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.slope.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.slope.regaddr', int(new_val))


class RootSeqRbanaPidPiduser2Preloadvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser2.preloadvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser2.preloadvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser2.preloadvalue.regaddr', int(new_val))


class RootSeqRbanaPidPiduser2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser2'
        self.preloadvalue = RootSeqRbanaPidPiduser2Preloadvalue(self._context)
        self.slope = RootSeqRbanaPidPiduser2Slope(self._context)
        self.status = RootSeqRbanaPidPiduser2Status(self._context)
        self.conversion = RootSeqRbanaPidPiduser2Conversion(self._context)
        self.offset = RootSeqRbanaPidPiduser2Offset(self._context)
        self.gain_p = RootSeqRbanaPidPiduser2Gain_p(self._context)
        self.control = RootSeqRbanaPidPiduser2Control(self._context)
        self.gain_i = RootSeqRbanaPidPiduser2Gain_i(self._context)
        self.gain_d = RootSeqRbanaPidPiduser2Gain_d(self._context)
        self.maxvalue = RootSeqRbanaPidPiduser2Maxvalue(self._context)
        self.errorlimit = RootSeqRbanaPidPiduser2Errorlimit(self._context)
        self.minvalue = RootSeqRbanaPidPiduser2Minvalue(self._context)


class RootSeqRbanaPidPidxMinvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidx.minvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.minvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.minvalue.regaddr', int(new_val))


class RootSeqRbanaPidPidxErrorlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidx.errorlimit'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.errorlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.errorlimit.regaddr', int(new_val))


class RootSeqRbanaPidPidxMaxvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidx.maxvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.maxvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.maxvalue.regaddr', int(new_val))


class RootSeqRbanaPidPidxGain_d(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidx.gain_d'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.gain_d.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.gain_d.regaddr', int(new_val))


class RootSeqRbanaPidPidxGain_i(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidx.gain_i'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.gain_i.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.gain_i.regaddr', int(new_val))


class RootSeqRbanaPidPidxControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidx.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.mode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.mode.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.mode.lsb', int(new_val))


class RootSeqRbanaPidPidxControlPidinputactual(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidx.control.pidinputactual'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.pidinputactual.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.pidinputactual.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.pidinputactual.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.pidinputactual.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.pidinputactual.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.pidinputactual.lsb', int(new_val))


class RootSeqRbanaPidPidxControlOutsel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidx.control.outsel'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.outsel.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.outsel.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.outsel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.outsel.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.outsel.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.outsel.lsb', int(new_val))


class RootSeqRbanaPidPidxControlPidinputsetpoint(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidx.control.pidinputsetpoint'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.pidinputsetpoint.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.pidinputsetpoint.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.pidinputsetpoint.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.pidinputsetpoint.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.pidinputsetpoint.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.pidinputsetpoint.lsb', int(new_val))


class RootSeqRbanaPidPidxControlPolpidin(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidx.control.polpidin'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.polpidin.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.polpidin.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.polpidin.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.polpidin.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.polpidin.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.polpidin.lsb', int(new_val))


class RootSeqRbanaPidPidxControlMedianfilterena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidx.control.medianfilterena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.medianfilterena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.medianfilterena.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.medianfilterena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.medianfilterena.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.medianfilterena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.medianfilterena.lsb', int(new_val))


class RootSeqRbanaPidPidxControlLoadinterna(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidx.control.loadinterna'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.loadinterna.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.loadinterna.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.loadinterna.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.loadinterna.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.loadinterna.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.loadinterna.lsb', int(new_val))


class RootSeqRbanaPidPidxControlPolcomperrlim(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidx.control.polcomperrlim'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.polcomperrlim.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.polcomperrlim.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.polcomperrlim.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.polcomperrlim.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.polcomperrlim.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.polcomperrlim.lsb', int(new_val))


class RootSeqRbanaPidPidxControlMemorygendriveena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidx.control.memorygendriveena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.memorygendriveena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.memorygendriveena.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.memorygendriveena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.memorygendriveena.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.memorygendriveena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.memorygendriveena.lsb', int(new_val))


class RootSeqRbanaPidPidxControlMemorygenpositionena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidx.control.memorygenpositionena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.memorygenpositionena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.memorygenpositionena.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.memorygenpositionena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.memorygenpositionena.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.memorygenpositionena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.memorygenpositionena.lsb', int(new_val))


class RootSeqRbanaPidPidxControlModena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidx.control.modena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.modena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.modena.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.modena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.modena.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.modena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.modena.lsb', int(new_val))


class RootSeqRbanaPidPidxControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidx.control'
        self.modena = RootSeqRbanaPidPidxControlModena(self._context)
        self.memorygenpositionena = RootSeqRbanaPidPidxControlMemorygenpositionena(self._context)
        self.memorygendriveena = RootSeqRbanaPidPidxControlMemorygendriveena(self._context)
        self.polcomperrlim = RootSeqRbanaPidPidxControlPolcomperrlim(self._context)
        self.loadinterna = RootSeqRbanaPidPidxControlLoadinterna(self._context)
        self.medianfilterena = RootSeqRbanaPidPidxControlMedianfilterena(self._context)
        self.polpidin = RootSeqRbanaPidPidxControlPolpidin(self._context)
        self.pidinputsetpoint = RootSeqRbanaPidPidxControlPidinputsetpoint(self._context)
        self.outsel = RootSeqRbanaPidPidxControlOutsel(self._context)
        self.pidinputactual = RootSeqRbanaPidPidxControlPidinputactual(self._context)
        self.mode = RootSeqRbanaPidPidxControlMode(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.control.regaddr', int(new_val))


class RootSeqRbanaPidPidxGain_p(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidx.gain_p'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.gain_p.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.gain_p.regaddr', int(new_val))


class RootSeqRbanaPidPidxOffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidx.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.offset.regaddr', int(new_val))


class RootSeqRbanaPidPidxConversion(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidx.conversion'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.conversion.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.conversion.regaddr', int(new_val))


class RootSeqRbanaPidPidxStatusReachedmin(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidx.status.reachedmin'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.status.reachedmin.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.status.reachedmin.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.status.reachedmin.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.status.reachedmin.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.status.reachedmin.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.status.reachedmin.lsb', int(new_val))


class RootSeqRbanaPidPidxStatusReachederrlim(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidx.status.reachederrlim'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.status.reachederrlim.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.status.reachederrlim.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.status.reachederrlim.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.status.reachederrlim.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.status.reachederrlim.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.status.reachederrlim.lsb', int(new_val))


class RootSeqRbanaPidPidxStatusReachedmax(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidx.status.reachedmax'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.status.reachedmax.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.status.reachedmax.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.status.reachedmax.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.status.reachedmax.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.status.reachedmax.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.status.reachedmax.lsb', int(new_val))


class RootSeqRbanaPidPidxStatusInternaloaded(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidx.status.internaloaded'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.status.internaloaded.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.status.internaloaded.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.status.internaloaded.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.status.internaloaded.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.status.internaloaded.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.status.internaloaded.lsb', int(new_val))


class RootSeqRbanaPidPidxStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidx.status'
        self.internaloaded = RootSeqRbanaPidPidxStatusInternaloaded(self._context)
        self.reachedmax = RootSeqRbanaPidPidxStatusReachedmax(self._context)
        self.reachederrlim = RootSeqRbanaPidPidxStatusReachederrlim(self._context)
        self.reachedmin = RootSeqRbanaPidPidxStatusReachedmin(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.status.regaddr', int(new_val))


class RootSeqRbanaPidPidxSlope(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidx.slope'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.slope.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.slope.regaddr', int(new_val))


class RootSeqRbanaPidPidxPreloadvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidx.preloadvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.pidx.preloadvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.pidx.preloadvalue.regaddr', int(new_val))


class RootSeqRbanaPidPidx(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.pidx'
        self.preloadvalue = RootSeqRbanaPidPidxPreloadvalue(self._context)
        self.slope = RootSeqRbanaPidPidxSlope(self._context)
        self.status = RootSeqRbanaPidPidxStatus(self._context)
        self.conversion = RootSeqRbanaPidPidxConversion(self._context)
        self.offset = RootSeqRbanaPidPidxOffset(self._context)
        self.gain_p = RootSeqRbanaPidPidxGain_p(self._context)
        self.control = RootSeqRbanaPidPidxControl(self._context)
        self.gain_i = RootSeqRbanaPidPidxGain_i(self._context)
        self.gain_d = RootSeqRbanaPidPidxGain_d(self._context)
        self.maxvalue = RootSeqRbanaPidPidxMaxvalue(self._context)
        self.errorlimit = RootSeqRbanaPidPidxErrorlimit(self._context)
        self.minvalue = RootSeqRbanaPidPidxMinvalue(self._context)


class RootSeqRbanaPidPiduser1Minvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser1.minvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.minvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.minvalue.regaddr', int(new_val))


class RootSeqRbanaPidPiduser1Errorlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser1.errorlimit'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.errorlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.errorlimit.regaddr', int(new_val))


class RootSeqRbanaPidPiduser1Maxvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser1.maxvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.maxvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.maxvalue.regaddr', int(new_val))


class RootSeqRbanaPidPiduser1Gain_d(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser1.gain_d'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.gain_d.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.gain_d.regaddr', int(new_val))


class RootSeqRbanaPidPiduser1Gain_i(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser1.gain_i'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.gain_i.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.gain_i.regaddr', int(new_val))


class RootSeqRbanaPidPiduser1ControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser1.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.mode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.mode.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.mode.lsb', int(new_val))


class RootSeqRbanaPidPiduser1ControlPidinputactual(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser1.control.pidinputactual'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.pidinputactual.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.pidinputactual.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.pidinputactual.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.pidinputactual.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.pidinputactual.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.pidinputactual.lsb', int(new_val))


class RootSeqRbanaPidPiduser1ControlOutsel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser1.control.outsel'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.outsel.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.outsel.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.outsel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.outsel.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.outsel.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.outsel.lsb', int(new_val))


class RootSeqRbanaPidPiduser1ControlPidinputsetpoint(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser1.control.pidinputsetpoint'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.pidinputsetpoint.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.pidinputsetpoint.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.pidinputsetpoint.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.pidinputsetpoint.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.pidinputsetpoint.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.pidinputsetpoint.lsb', int(new_val))


class RootSeqRbanaPidPiduser1ControlPolpidin(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser1.control.polpidin'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.polpidin.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.polpidin.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.polpidin.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.polpidin.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.polpidin.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.polpidin.lsb', int(new_val))


class RootSeqRbanaPidPiduser1ControlMedianfilterena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser1.control.medianfilterena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.medianfilterena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.medianfilterena.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.medianfilterena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.medianfilterena.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.medianfilterena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.medianfilterena.lsb', int(new_val))


class RootSeqRbanaPidPiduser1ControlLoadinterna(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser1.control.loadinterna'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.loadinterna.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.loadinterna.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.loadinterna.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.loadinterna.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.loadinterna.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.loadinterna.lsb', int(new_val))


class RootSeqRbanaPidPiduser1ControlPolcomperrlim(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser1.control.polcomperrlim'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.polcomperrlim.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.polcomperrlim.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.polcomperrlim.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.polcomperrlim.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.polcomperrlim.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.polcomperrlim.lsb', int(new_val))


class RootSeqRbanaPidPiduser1ControlMemorygendriveena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser1.control.memorygendriveena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.memorygendriveena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.memorygendriveena.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.memorygendriveena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.memorygendriveena.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.memorygendriveena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.memorygendriveena.lsb', int(new_val))


class RootSeqRbanaPidPiduser1ControlMemorygenpositionena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser1.control.memorygenpositionena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.memorygenpositionena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.memorygenpositionena.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.memorygenpositionena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.memorygenpositionena.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.memorygenpositionena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.memorygenpositionena.lsb', int(new_val))


class RootSeqRbanaPidPiduser1ControlModena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser1.control.modena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.modena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.modena.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.modena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.modena.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.modena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.modena.lsb', int(new_val))


class RootSeqRbanaPidPiduser1Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser1.control'
        self.modena = RootSeqRbanaPidPiduser1ControlModena(self._context)
        self.memorygenpositionena = RootSeqRbanaPidPiduser1ControlMemorygenpositionena(self._context)
        self.memorygendriveena = RootSeqRbanaPidPiduser1ControlMemorygendriveena(self._context)
        self.polcomperrlim = RootSeqRbanaPidPiduser1ControlPolcomperrlim(self._context)
        self.loadinterna = RootSeqRbanaPidPiduser1ControlLoadinterna(self._context)
        self.medianfilterena = RootSeqRbanaPidPiduser1ControlMedianfilterena(self._context)
        self.polpidin = RootSeqRbanaPidPiduser1ControlPolpidin(self._context)
        self.pidinputsetpoint = RootSeqRbanaPidPiduser1ControlPidinputsetpoint(self._context)
        self.outsel = RootSeqRbanaPidPiduser1ControlOutsel(self._context)
        self.pidinputactual = RootSeqRbanaPidPiduser1ControlPidinputactual(self._context)
        self.mode = RootSeqRbanaPidPiduser1ControlMode(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.control.regaddr', int(new_val))


class RootSeqRbanaPidPiduser1Gain_p(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser1.gain_p'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.gain_p.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.gain_p.regaddr', int(new_val))


class RootSeqRbanaPidPiduser1Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser1.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.offset.regaddr', int(new_val))


class RootSeqRbanaPidPiduser1Conversion(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser1.conversion'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.conversion.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.conversion.regaddr', int(new_val))


class RootSeqRbanaPidPiduser1StatusReachedmin(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser1.status.reachedmin'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.status.reachedmin.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.status.reachedmin.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.status.reachedmin.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.status.reachedmin.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.status.reachedmin.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.status.reachedmin.lsb', int(new_val))


class RootSeqRbanaPidPiduser1StatusReachederrlim(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser1.status.reachederrlim'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.status.reachederrlim.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.status.reachederrlim.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.status.reachederrlim.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.status.reachederrlim.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.status.reachederrlim.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.status.reachederrlim.lsb', int(new_val))


class RootSeqRbanaPidPiduser1StatusReachedmax(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser1.status.reachedmax'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.status.reachedmax.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.status.reachedmax.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.status.reachedmax.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.status.reachedmax.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.status.reachedmax.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.status.reachedmax.lsb', int(new_val))


class RootSeqRbanaPidPiduser1StatusInternaloaded(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser1.status.internaloaded'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.status.internaloaded.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.status.internaloaded.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.status.internaloaded.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.status.internaloaded.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.status.internaloaded.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.status.internaloaded.lsb', int(new_val))


class RootSeqRbanaPidPiduser1Status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser1.status'
        self.internaloaded = RootSeqRbanaPidPiduser1StatusInternaloaded(self._context)
        self.reachedmax = RootSeqRbanaPidPiduser1StatusReachedmax(self._context)
        self.reachederrlim = RootSeqRbanaPidPiduser1StatusReachederrlim(self._context)
        self.reachedmin = RootSeqRbanaPidPiduser1StatusReachedmin(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.status.regaddr', int(new_val))


class RootSeqRbanaPidPiduser1Slope(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser1.slope'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.slope.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.slope.regaddr', int(new_val))


class RootSeqRbanaPidPiduser1Preloadvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser1.preloadvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.pid.piduser1.preloadvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.pid.piduser1.preloadvalue.regaddr', int(new_val))


class RootSeqRbanaPidPiduser1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid.piduser1'
        self.preloadvalue = RootSeqRbanaPidPiduser1Preloadvalue(self._context)
        self.slope = RootSeqRbanaPidPiduser1Slope(self._context)
        self.status = RootSeqRbanaPidPiduser1Status(self._context)
        self.conversion = RootSeqRbanaPidPiduser1Conversion(self._context)
        self.offset = RootSeqRbanaPidPiduser1Offset(self._context)
        self.gain_p = RootSeqRbanaPidPiduser1Gain_p(self._context)
        self.control = RootSeqRbanaPidPiduser1Control(self._context)
        self.gain_i = RootSeqRbanaPidPiduser1Gain_i(self._context)
        self.gain_d = RootSeqRbanaPidPiduser1Gain_d(self._context)
        self.maxvalue = RootSeqRbanaPidPiduser1Maxvalue(self._context)
        self.errorlimit = RootSeqRbanaPidPiduser1Errorlimit(self._context)
        self.minvalue = RootSeqRbanaPidPiduser1Minvalue(self._context)


class RootSeqRbanaPid(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.pid'
        self.piduser1 = RootSeqRbanaPidPiduser1(self._context)
        self.pidx = RootSeqRbanaPidPidx(self._context)
        self.piduser2 = RootSeqRbanaPidPiduser2(self._context)
        self.pidw = RootSeqRbanaPidPidw(self._context)
        self.pidy = RootSeqRbanaPidPidy(self._context)


class RootSeqRbanaInfastCh2Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch2.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch2.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch2.cccoefz0.regaddr', int(new_val))


class RootSeqRbanaInfastCh2Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch2.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch2.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch2.cccoefy0.regaddr', int(new_val))


class RootSeqRbanaInfastCh2Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch2.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch2.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch2.cccoefz2.regaddr', int(new_val))


class RootSeqRbanaInfastCh2Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch2.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch2.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch2.offset.regaddr', int(new_val))


class RootSeqRbanaInfastCh2Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch2.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch2.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch2.gain.regaddr', int(new_val))


class RootSeqRbanaInfastCh2Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch2.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch2.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch2.cccoefx1.regaddr', int(new_val))


class RootSeqRbanaInfastCh2Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch2.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch2.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch2.cccoefy1.regaddr', int(new_val))


class RootSeqRbanaInfastCh2Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch2.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch2.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch2.cccoefy2.regaddr', int(new_val))


class RootSeqRbanaInfastCh2Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch2.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch2.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch2.cccoefx0.regaddr', int(new_val))


class RootSeqRbanaInfastCh2Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch2.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch2.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch2.cccoefx2.regaddr', int(new_val))


class RootSeqRbanaInfastCh2Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch2.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch2.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch2.currentinval.regaddr', int(new_val))


class RootSeqRbanaInfastCh2Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch2.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch2.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch2.cccoefz1.regaddr', int(new_val))


class RootSeqRbanaInfastCh2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch2'
        self.cccoefz1 = RootSeqRbanaInfastCh2Cccoefz1(self._context)
        self.currentinval = RootSeqRbanaInfastCh2Currentinval(self._context)
        self.cccoefx2 = RootSeqRbanaInfastCh2Cccoefx2(self._context)
        self.cccoefx0 = RootSeqRbanaInfastCh2Cccoefx0(self._context)
        self.cccoefy2 = RootSeqRbanaInfastCh2Cccoefy2(self._context)
        self.cccoefy1 = RootSeqRbanaInfastCh2Cccoefy1(self._context)
        self.cccoefx1 = RootSeqRbanaInfastCh2Cccoefx1(self._context)
        self.gain = RootSeqRbanaInfastCh2Gain(self._context)
        self.offset = RootSeqRbanaInfastCh2Offset(self._context)
        self.cccoefz2 = RootSeqRbanaInfastCh2Cccoefz2(self._context)
        self.cccoefy0 = RootSeqRbanaInfastCh2Cccoefy0(self._context)
        self.cccoefz0 = RootSeqRbanaInfastCh2Cccoefz0(self._context)


class RootSeqRbanaInfastCh3Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch3.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch3.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch3.cccoefz0.regaddr', int(new_val))


class RootSeqRbanaInfastCh3Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch3.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch3.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch3.cccoefy0.regaddr', int(new_val))


class RootSeqRbanaInfastCh3Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch3.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch3.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch3.cccoefz2.regaddr', int(new_val))


class RootSeqRbanaInfastCh3Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch3.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch3.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch3.offset.regaddr', int(new_val))


class RootSeqRbanaInfastCh3Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch3.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch3.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch3.gain.regaddr', int(new_val))


class RootSeqRbanaInfastCh3Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch3.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch3.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch3.cccoefx1.regaddr', int(new_val))


class RootSeqRbanaInfastCh3Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch3.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch3.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch3.cccoefy1.regaddr', int(new_val))


class RootSeqRbanaInfastCh3Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch3.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch3.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch3.cccoefy2.regaddr', int(new_val))


class RootSeqRbanaInfastCh3Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch3.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch3.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch3.cccoefx0.regaddr', int(new_val))


class RootSeqRbanaInfastCh3Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch3.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch3.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch3.cccoefx2.regaddr', int(new_val))


class RootSeqRbanaInfastCh3Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch3.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch3.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch3.currentinval.regaddr', int(new_val))


class RootSeqRbanaInfastCh3Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch3.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch3.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch3.cccoefz1.regaddr', int(new_val))


class RootSeqRbanaInfastCh3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch3'
        self.cccoefz1 = RootSeqRbanaInfastCh3Cccoefz1(self._context)
        self.currentinval = RootSeqRbanaInfastCh3Currentinval(self._context)
        self.cccoefx2 = RootSeqRbanaInfastCh3Cccoefx2(self._context)
        self.cccoefx0 = RootSeqRbanaInfastCh3Cccoefx0(self._context)
        self.cccoefy2 = RootSeqRbanaInfastCh3Cccoefy2(self._context)
        self.cccoefy1 = RootSeqRbanaInfastCh3Cccoefy1(self._context)
        self.cccoefx1 = RootSeqRbanaInfastCh3Cccoefx1(self._context)
        self.gain = RootSeqRbanaInfastCh3Gain(self._context)
        self.offset = RootSeqRbanaInfastCh3Offset(self._context)
        self.cccoefz2 = RootSeqRbanaInfastCh3Cccoefz2(self._context)
        self.cccoefy0 = RootSeqRbanaInfastCh3Cccoefy0(self._context)
        self.cccoefz0 = RootSeqRbanaInfastCh3Cccoefz0(self._context)


class RootSeqRbanaInfastCh1Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch1.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch1.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch1.cccoefz0.regaddr', int(new_val))


class RootSeqRbanaInfastCh1Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch1.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch1.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch1.cccoefy0.regaddr', int(new_val))


class RootSeqRbanaInfastCh1Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch1.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch1.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch1.cccoefz2.regaddr', int(new_val))


class RootSeqRbanaInfastCh1Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch1.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch1.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch1.offset.regaddr', int(new_val))


class RootSeqRbanaInfastCh1Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch1.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch1.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch1.gain.regaddr', int(new_val))


class RootSeqRbanaInfastCh1Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch1.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch1.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch1.cccoefx1.regaddr', int(new_val))


class RootSeqRbanaInfastCh1Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch1.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch1.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch1.cccoefy1.regaddr', int(new_val))


class RootSeqRbanaInfastCh1Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch1.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch1.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch1.cccoefy2.regaddr', int(new_val))


class RootSeqRbanaInfastCh1Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch1.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch1.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch1.cccoefx0.regaddr', int(new_val))


class RootSeqRbanaInfastCh1Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch1.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch1.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch1.cccoefx2.regaddr', int(new_val))


class RootSeqRbanaInfastCh1Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch1.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch1.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch1.currentinval.regaddr', int(new_val))


class RootSeqRbanaInfastCh1Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch1.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.infast.ch1.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.infast.ch1.cccoefz1.regaddr', int(new_val))


class RootSeqRbanaInfastCh1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast.ch1'
        self.cccoefz1 = RootSeqRbanaInfastCh1Cccoefz1(self._context)
        self.currentinval = RootSeqRbanaInfastCh1Currentinval(self._context)
        self.cccoefx2 = RootSeqRbanaInfastCh1Cccoefx2(self._context)
        self.cccoefx0 = RootSeqRbanaInfastCh1Cccoefx0(self._context)
        self.cccoefy2 = RootSeqRbanaInfastCh1Cccoefy2(self._context)
        self.cccoefy1 = RootSeqRbanaInfastCh1Cccoefy1(self._context)
        self.cccoefx1 = RootSeqRbanaInfastCh1Cccoefx1(self._context)
        self.gain = RootSeqRbanaInfastCh1Gain(self._context)
        self.offset = RootSeqRbanaInfastCh1Offset(self._context)
        self.cccoefz2 = RootSeqRbanaInfastCh1Cccoefz2(self._context)
        self.cccoefy0 = RootSeqRbanaInfastCh1Cccoefy0(self._context)
        self.cccoefz0 = RootSeqRbanaInfastCh1Cccoefz0(self._context)


class RootSeqRbanaInfast(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infast'
        self.ch1 = RootSeqRbanaInfastCh1(self._context)
        self.ch3 = RootSeqRbanaInfastCh3(self._context)
        self.ch2 = RootSeqRbanaInfastCh2(self._context)


class RootSeqRbanaOrtSgleBaselineamplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.ort.sgle.baselineamplitude'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.baselineamplitude.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.baselineamplitude.regaddr', int(new_val))


class RootSeqRbanaOrtSgleStatusAveraging(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.ort.sgle.status.averaging'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.status.averaging.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.status.averaging.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.status.averaging.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.status.averaging.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.status.averaging.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.status.averaging.lsb', int(new_val))


class RootSeqRbanaOrtSgleStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.ort.sgle.status'
        self.averaging = RootSeqRbanaOrtSgleStatusAveraging(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.status.regaddr', int(new_val))


class RootSeqRbanaOrtSgleBaselinewindowendsample(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.ort.sgle.baselinewindowendsample'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.baselinewindowendsample.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.baselinewindowendsample.regaddr', int(new_val))


class RootSeqRbanaOrtSgleMinvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.ort.sgle.minvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.minvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.minvalue.regaddr', int(new_val))


class RootSeqRbanaOrtSgleBaselinewindowbeginsample(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.ort.sgle.baselinewindowbeginsample'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.baselinewindowbeginsample.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.baselinewindowbeginsample.regaddr', int(new_val))


class RootSeqRbanaOrtSgleControlFreewaveoutputenable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.ort.sgle.control.freewaveoutputenable'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.control.freewaveoutputenable.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.control.freewaveoutputenable.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.control.freewaveoutputenable.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.control.freewaveoutputenable.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.control.freewaveoutputenable.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.control.freewaveoutputenable.lsb', int(new_val))


class RootSeqRbanaOrtSgleControlAveragestart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.ort.sgle.control.averagestart'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.control.averagestart.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.control.averagestart.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.control.averagestart.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.control.averagestart.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.control.averagestart.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.control.averagestart.lsb', int(new_val))


class RootSeqRbanaOrtSgleControlUpdatesamplevalues(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.ort.sgle.control.updatesamplevalues'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.control.updatesamplevalues.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.control.updatesamplevalues.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.control.updatesamplevalues.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.control.updatesamplevalues.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.control.updatesamplevalues.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.control.updatesamplevalues.lsb', int(new_val))


class RootSeqRbanaOrtSgleControlEnablebaselinecontroller(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.ort.sgle.control.enablebaselinecontroller'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.control.enablebaselinecontroller.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.control.enablebaselinecontroller.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.control.enablebaselinecontroller.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.control.enablebaselinecontroller.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.control.enablebaselinecontroller.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.control.enablebaselinecontroller.lsb', int(new_val))


class RootSeqRbanaOrtSgleControlAveragestop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.ort.sgle.control.averagestop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.control.averagestop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.control.averagestop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.control.averagestop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.control.averagestop.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.control.averagestop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.control.averagestop.lsb', int(new_val))


class RootSeqRbanaOrtSgleControlInputselect(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.ort.sgle.control.inputselect'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.control.inputselect.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.control.inputselect.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.control.inputselect.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.control.inputselect.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.control.inputselect.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.control.inputselect.lsb', int(new_val))


class RootSeqRbanaOrtSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.ort.sgle.control'
        self.inputselect = RootSeqRbanaOrtSgleControlInputselect(self._context)
        self.averagestop = RootSeqRbanaOrtSgleControlAveragestop(self._context)
        self.enablebaselinecontroller = RootSeqRbanaOrtSgleControlEnablebaselinecontroller(self._context)
        self.updatesamplevalues = RootSeqRbanaOrtSgleControlUpdatesamplevalues(self._context)
        self.averagestart = RootSeqRbanaOrtSgleControlAveragestart(self._context)
        self.freewaveoutputenable = RootSeqRbanaOrtSgleControlFreewaveoutputenable(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.control.regaddr', int(new_val))


class RootSeqRbanaOrtSgleMinposition(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.ort.sgle.minposition'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.minposition.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.minposition.regaddr', int(new_val))


class RootSeqRbanaOrtSgleAmplitudereduction(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.ort.sgle.amplitudereduction'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.amplitudereduction.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.amplitudereduction.regaddr', int(new_val))


class RootSeqRbanaOrtSgleSamplesperperiodSamplesperperiod(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.ort.sgle.samplesperperiod.samplesperperiod'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.samplesperperiod.samplesperperiod.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.samplesperperiod.samplesperperiod.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.samplesperperiod.samplesperperiod.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.samplesperperiod.samplesperperiod.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.samplesperperiod.samplesperperiod.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.samplesperperiod.samplesperperiod.lsb', int(new_val))


class RootSeqRbanaOrtSgleSamplesperperiod(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.ort.sgle.samplesperperiod'
        self.samplesperperiod = RootSeqRbanaOrtSgleSamplesperperiodSamplesperperiod(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.samplesperperiod.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.samplesperperiod.regaddr', int(new_val))


class RootSeqRbanaOrtSgleFreewavebeginsample(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.ort.sgle.freewavebeginsample'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.freewavebeginsample.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.freewavebeginsample.regaddr', int(new_val))


class RootSeqRbanaOrtSgleBaselinemultiplier(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.ort.sgle.baselinemultiplier'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.baselinemultiplier.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.baselinemultiplier.regaddr', int(new_val))


class RootSeqRbanaOrtSgleExcitationamplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.ort.sgle.excitationamplitude'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.excitationamplitude.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.excitationamplitude.regaddr', int(new_val))


class RootSeqRbanaOrtSgleAmplitudesample(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.ort.sgle.amplitudesample'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.amplitudesample.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.amplitudesample.regaddr', int(new_val))


class RootSeqRbanaOrtSgleCantileversamplesperperiodSamplesperperiod(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.ort.sgle.cantileversamplesperperiod.samplesperperiod'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.cantileversamplesperperiod.samplesperperiod.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.cantileversamplesperperiod.samplesperperiod.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.cantileversamplesperperiod.samplesperperiod.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.cantileversamplesperperiod.samplesperperiod.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.cantileversamplesperperiod.samplesperperiod.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.cantileversamplesperperiod.samplesperperiod.lsb', int(new_val))


class RootSeqRbanaOrtSgleCantileversamplesperperiod(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.ort.sgle.cantileversamplesperperiod'
        self.samplesperperiod = RootSeqRbanaOrtSgleCantileversamplesperperiodSamplesperperiod(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.cantileversamplesperperiod.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.cantileversamplesperperiod.regaddr', int(new_val))


class RootSeqRbanaOrtSgleAverageperiodsAverageperiod(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.ort.sgle.averageperiods.averageperiod'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.averageperiods.averageperiod.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.averageperiods.averageperiod.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.averageperiods.averageperiod.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.averageperiods.averageperiod.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.averageperiods.averageperiod.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.averageperiods.averageperiod.lsb', int(new_val))


class RootSeqRbanaOrtSgleAverageperiods(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.ort.sgle.averageperiods'
        self.averageperiod = RootSeqRbanaOrtSgleAverageperiodsAverageperiod(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.ort.sgle.averageperiods.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.ort.sgle.averageperiods.regaddr', int(new_val))


class RootSeqRbanaOrtSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.ort.sgle'
        self.averageperiods = RootSeqRbanaOrtSgleAverageperiods(self._context)
        self.cantileversamplesperperiod = RootSeqRbanaOrtSgleCantileversamplesperperiod(self._context)
        self.amplitudesample = RootSeqRbanaOrtSgleAmplitudesample(self._context)
        self.excitationamplitude = RootSeqRbanaOrtSgleExcitationamplitude(self._context)
        self.baselinemultiplier = RootSeqRbanaOrtSgleBaselinemultiplier(self._context)
        self.freewavebeginsample = RootSeqRbanaOrtSgleFreewavebeginsample(self._context)
        self.samplesperperiod = RootSeqRbanaOrtSgleSamplesperperiod(self._context)
        self.amplitudereduction = RootSeqRbanaOrtSgleAmplitudereduction(self._context)
        self.minposition = RootSeqRbanaOrtSgleMinposition(self._context)
        self.control = RootSeqRbanaOrtSgleControl(self._context)
        self.baselinewindowbeginsample = RootSeqRbanaOrtSgleBaselinewindowbeginsample(self._context)
        self.minvalue = RootSeqRbanaOrtSgleMinvalue(self._context)
        self.baselinewindowendsample = RootSeqRbanaOrtSgleBaselinewindowendsample(self._context)
        self.status = RootSeqRbanaOrtSgleStatus(self._context)
        self.baselineamplitude = RootSeqRbanaOrtSgleBaselineamplitude(self._context)


class RootSeqRbanaOrt(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.ort'
        self.sgle = RootSeqRbanaOrtSgle(self._context)


class RootSeqRbanaUserioSgleDigitalin(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.userio.sgle.digitalin'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.digitalin.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.digitalin.regaddr', int(new_val))


class RootSeqRbanaUserioSgleControlOut2enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.userio.sgle.control.out2enable'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out2enable.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out2enable.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out2enable.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out2enable.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out2enable.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out2enable.lsb', int(new_val))


class RootSeqRbanaUserioSgleControlOut1src(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.userio.sgle.control.out1src'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out1src.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out1src.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out1src.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out1src.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out1src.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out1src.lsb', int(new_val))


class RootSeqRbanaUserioSgleControlOut2pulse(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.userio.sgle.control.out2pulse'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out2pulse.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out2pulse.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out2pulse.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out2pulse.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out2pulse.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out2pulse.lsb', int(new_val))


class RootSeqRbanaUserioSgleControlOut2level(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.userio.sgle.control.out2level'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out2level.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out2level.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out2level.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out2level.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out2level.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out2level.lsb', int(new_val))


class RootSeqRbanaUserioSgleControlOut2src(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.userio.sgle.control.out2src'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out2src.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out2src.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out2src.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out2src.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out2src.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out2src.lsb', int(new_val))


class RootSeqRbanaUserioSgleControlOut2type(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.userio.sgle.control.out2type'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out2type.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out2type.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out2type.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out2type.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out2type.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out2type.lsb', int(new_val))


class RootSeqRbanaUserioSgleControlIn1enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.userio.sgle.control.in1enable'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.in1enable.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.in1enable.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.in1enable.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.in1enable.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.in1enable.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.in1enable.lsb', int(new_val))


class RootSeqRbanaUserioSgleControlOut1level(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.userio.sgle.control.out1level'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out1level.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out1level.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out1level.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out1level.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out1level.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out1level.lsb', int(new_val))


class RootSeqRbanaUserioSgleControlOut1pulse(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.userio.sgle.control.out1pulse'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out1pulse.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out1pulse.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out1pulse.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out1pulse.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out1pulse.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out1pulse.lsb', int(new_val))


class RootSeqRbanaUserioSgleControlOut1type(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.userio.sgle.control.out1type'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out1type.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out1type.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out1type.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out1type.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out1type.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out1type.lsb', int(new_val))


class RootSeqRbanaUserioSgleControlIn2enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.userio.sgle.control.in2enable'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.in2enable.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.in2enable.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.in2enable.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.in2enable.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.in2enable.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.in2enable.lsb', int(new_val))


class RootSeqRbanaUserioSgleControlOut1enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.userio.sgle.control.out1enable'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out1enable.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out1enable.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out1enable.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out1enable.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.out1enable.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.out1enable.lsb', int(new_val))


class RootSeqRbanaUserioSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.userio.sgle.control'
        self.out1enable = RootSeqRbanaUserioSgleControlOut1enable(self._context)
        self.in2enable = RootSeqRbanaUserioSgleControlIn2enable(self._context)
        self.out1type = RootSeqRbanaUserioSgleControlOut1type(self._context)
        self.out1pulse = RootSeqRbanaUserioSgleControlOut1pulse(self._context)
        self.out1level = RootSeqRbanaUserioSgleControlOut1level(self._context)
        self.in1enable = RootSeqRbanaUserioSgleControlIn1enable(self._context)
        self.out2type = RootSeqRbanaUserioSgleControlOut2type(self._context)
        self.out2src = RootSeqRbanaUserioSgleControlOut2src(self._context)
        self.out2level = RootSeqRbanaUserioSgleControlOut2level(self._context)
        self.out2pulse = RootSeqRbanaUserioSgleControlOut2pulse(self._context)
        self.out1src = RootSeqRbanaUserioSgleControlOut1src(self._context)
        self.out2enable = RootSeqRbanaUserioSgleControlOut2enable(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.userio.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.userio.sgle.control.regaddr', int(new_val))


class RootSeqRbanaUserioSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.userio.sgle'
        self.control = RootSeqRbanaUserioSgleControl(self._context)
        self.digitalin = RootSeqRbanaUserioSgleDigitalin(self._context)


class RootSeqRbanaUserio(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.userio'
        self.sgle = RootSeqRbanaUserioSgle(self._context)


class RootSeqRbanaInchannelsdigiSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inchannelsdigi.sgle.control'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inchannelsdigi.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inchannelsdigi.sgle.control.regaddr', int(new_val))


class RootSeqRbanaInchannelsdigiSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inchannelsdigi.sgle'
        self.control = RootSeqRbanaInchannelsdigiSgleControl(self._context)


class RootSeqRbanaInchannelsdigi(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inchannelsdigi'
        self.sgle = RootSeqRbanaInchannelsdigiSgle(self._context)


class RootSeqRbanaInternaSgleControlRst8chconverters(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.interna.sgle.control.rst8chconverters'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.interna.sgle.control.rst8chconverters.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.interna.sgle.control.rst8chconverters.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.interna.sgle.control.rst8chconverters.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.interna.sgle.control.rst8chconverters.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.interna.sgle.control.rst8chconverters.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.interna.sgle.control.rst8chconverters.lsb', int(new_val))


class RootSeqRbanaInternaSgleControlStatusled(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.interna.sgle.control.statusled'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.interna.sgle.control.statusled.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.interna.sgle.control.statusled.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.interna.sgle.control.statusled.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.interna.sgle.control.statusled.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.interna.sgle.control.statusled.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.interna.sgle.control.statusled.lsb', int(new_val))


class RootSeqRbanaInternaSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.interna.sgle.control'
        self.statusled = RootSeqRbanaInternaSgleControlStatusled(self._context)
        self.rst8chconverters = RootSeqRbanaInternaSgleControlRst8chconverters(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.interna.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.interna.sgle.control.regaddr', int(new_val))


class RootSeqRbanaInternaSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.interna.sgle'
        self.control = RootSeqRbanaInternaSgleControl(self._context)


class RootSeqRbanaInterna(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.interna'
        self.sgle = RootSeqRbanaInternaSgle(self._context)


class RootSeqRbanaSeqSgleBit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.seq.sgle.bit'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.seq.sgle.bit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.seq.sgle.bit.regaddr', int(new_val))


class RootSeqRbanaSeqSgleStatusReaderror(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.seq.sgle.status.readerror'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.seq.sgle.status.readerror.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.seq.sgle.status.readerror.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.seq.sgle.status.readerror.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.seq.sgle.status.readerror.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.seq.sgle.status.readerror.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.seq.sgle.status.readerror.lsb', int(new_val))


class RootSeqRbanaSeqSgleStatusRunning(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.seq.sgle.status.running'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.seq.sgle.status.running.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.seq.sgle.status.running.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.seq.sgle.status.running.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.seq.sgle.status.running.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.seq.sgle.status.running.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.seq.sgle.status.running.lsb', int(new_val))


class RootSeqRbanaSeqSgleStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.seq.sgle.status'
        self.running = RootSeqRbanaSeqSgleStatusRunning(self._context)
        self.readerror = RootSeqRbanaSeqSgleStatusReaderror(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.seq.sgle.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.seq.sgle.status.regaddr', int(new_val))


class RootSeqRbanaSeqSgleData(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.seq.sgle.data'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.seq.sgle.data.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.seq.sgle.data.regaddr', int(new_val))


class RootSeqRbanaSeqSgleSum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.seq.sgle.sum'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.seq.sgle.sum.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.seq.sgle.sum.regaddr', int(new_val))


class RootSeqRbanaSeqSgleControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.seq.sgle.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.seq.sgle.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.seq.sgle.control.start.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.seq.sgle.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.seq.sgle.control.start.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.seq.sgle.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.seq.sgle.control.start.lsb', int(new_val))


class RootSeqRbanaSeqSgleControlStep(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.seq.sgle.control.step'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.seq.sgle.control.step.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.seq.sgle.control.step.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.seq.sgle.control.step.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.seq.sgle.control.step.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.seq.sgle.control.step.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.seq.sgle.control.step.lsb', int(new_val))


class RootSeqRbanaSeqSgleControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.seq.sgle.control.stop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.seq.sgle.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.seq.sgle.control.stop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.seq.sgle.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.seq.sgle.control.stop.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.seq.sgle.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.seq.sgle.control.stop.lsb', int(new_val))


class RootSeqRbanaSeqSgleControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.seq.sgle.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.seq.sgle.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.seq.sgle.control.abort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.seq.sgle.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.seq.sgle.control.abort.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.seq.sgle.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.seq.sgle.control.abort.lsb', int(new_val))


class RootSeqRbanaSeqSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.seq.sgle.control'
        self.abort = RootSeqRbanaSeqSgleControlAbort(self._context)
        self.stop = RootSeqRbanaSeqSgleControlStop(self._context)
        self.step = RootSeqRbanaSeqSgleControlStep(self._context)
        self.start = RootSeqRbanaSeqSgleControlStart(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.seq.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.seq.sgle.control.regaddr', int(new_val))


class RootSeqRbanaSeqSgleInstrptr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.seq.sgle.instrptr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.seq.sgle.instrptr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.seq.sgle.instrptr.regaddr', int(new_val))


class RootSeqRbanaSeqSgleB(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.seq.sgle.b'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.seq.sgle.b.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.seq.sgle.b.regaddr', int(new_val))


class RootSeqRbanaSeqSgleA(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.seq.sgle.a'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.seq.sgle.a.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.seq.sgle.a.regaddr', int(new_val))


class RootSeqRbanaSeqSgleAddr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.seq.sgle.addr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.seq.sgle.addr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.seq.sgle.addr.regaddr', int(new_val))


class RootSeqRbanaSeqSgleM(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.seq.sgle.m'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.seq.sgle.m.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.seq.sgle.m.regaddr', int(new_val))


class RootSeqRbanaSeqSgleSeqreg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.seq.sgle.seqreg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.seq.sgle.seqreg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.seq.sgle.seqreg.regaddr', int(new_val))


class RootSeqRbanaSeqSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.seq.sgle'
        self.seqreg = RootSeqRbanaSeqSgleSeqreg(self._context)
        self.m = RootSeqRbanaSeqSgleM(self._context)
        self.addr = RootSeqRbanaSeqSgleAddr(self._context)
        self.a = RootSeqRbanaSeqSgleA(self._context)
        self.b = RootSeqRbanaSeqSgleB(self._context)
        self.instrptr = RootSeqRbanaSeqSgleInstrptr(self._context)
        self.control = RootSeqRbanaSeqSgleControl(self._context)
        self.sum = RootSeqRbanaSeqSgleSum(self._context)
        self.data = RootSeqRbanaSeqSgleData(self._context)
        self.status = RootSeqRbanaSeqSgleStatus(self._context)
        self.bit = RootSeqRbanaSeqSgleBit(self._context)


class RootSeqRbanaSeq(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.seq'
        self.sgle = RootSeqRbanaSeqSgle(self._context)


class RootSeqRbanaOuthiresCh8Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch8.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch8.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch8.glitchcorr.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh8Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch8.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch8.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch8.testvalue.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh8Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch8.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch8.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch8.lowordgaincorr.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh8Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch8.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch8.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch8.offset.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh8Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch8.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch8.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch8.gain.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh8ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch8.control.selectout'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch8.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch8.control.selectout.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch8.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch8.control.selectout.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch8.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch8.control.selectout.lsb', int(new_val))


class RootSeqRbanaOuthiresCh8ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch8.control.bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch8.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch8.control.bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch8.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch8.control.bypassfilter.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch8.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch8.control.bypassfilter.lsb', int(new_val))


class RootSeqRbanaOuthiresCh8ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch8.control.adddigitalmodulation'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch8.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch8.control.adddigitalmodulation.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch8.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch8.control.adddigitalmodulation.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch8.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch8.control.adddigitalmodulation.lsb', int(new_val))


class RootSeqRbanaOuthiresCh8ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch8.control.glitchcorr'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch8.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch8.control.glitchcorr.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch8.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch8.control.glitchcorr.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch8.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch8.control.glitchcorr.lsb', int(new_val))


class RootSeqRbanaOuthiresCh8Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch8.control'
        self.glitchcorr = RootSeqRbanaOuthiresCh8ControlGlitchcorr(self._context)
        self.adddigitalmodulation = RootSeqRbanaOuthiresCh8ControlAdddigitalmodulation(self._context)
        self.bypassfilter = RootSeqRbanaOuthiresCh8ControlBypassfilter(self._context)
        self.selectout = RootSeqRbanaOuthiresCh8ControlSelectout(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch8.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch8.control.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh8Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch8.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch8.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch8.currentoutval.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh8Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch8.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch8.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch8.slewrate.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh8Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch8.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch8.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch8.filterval.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh8(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch8'
        self.filterval = RootSeqRbanaOuthiresCh8Filterval(self._context)
        self.slewrate = RootSeqRbanaOuthiresCh8Slewrate(self._context)
        self.currentoutval = RootSeqRbanaOuthiresCh8Currentoutval(self._context)
        self.control = RootSeqRbanaOuthiresCh8Control(self._context)
        self.gain = RootSeqRbanaOuthiresCh8Gain(self._context)
        self.offset = RootSeqRbanaOuthiresCh8Offset(self._context)
        self.lowordgaincorr = RootSeqRbanaOuthiresCh8Lowordgaincorr(self._context)
        self.testvalue = RootSeqRbanaOuthiresCh8Testvalue(self._context)
        self.glitchcorr = RootSeqRbanaOuthiresCh8Glitchcorr(self._context)


class RootSeqRbanaOuthiresCh10Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch10.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch10.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch10.glitchcorr.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh10Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch10.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch10.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch10.testvalue.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh10Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch10.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch10.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch10.lowordgaincorr.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh10Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch10.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch10.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch10.offset.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh10Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch10.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch10.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch10.gain.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh10ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch10.control.selectout'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch10.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch10.control.selectout.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch10.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch10.control.selectout.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch10.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch10.control.selectout.lsb', int(new_val))


class RootSeqRbanaOuthiresCh10ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch10.control.bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch10.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch10.control.bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch10.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch10.control.bypassfilter.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch10.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch10.control.bypassfilter.lsb', int(new_val))


class RootSeqRbanaOuthiresCh10ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch10.control.adddigitalmodulation'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch10.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch10.control.adddigitalmodulation.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch10.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch10.control.adddigitalmodulation.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch10.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch10.control.adddigitalmodulation.lsb', int(new_val))


class RootSeqRbanaOuthiresCh10ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch10.control.glitchcorr'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch10.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch10.control.glitchcorr.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch10.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch10.control.glitchcorr.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch10.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch10.control.glitchcorr.lsb', int(new_val))


class RootSeqRbanaOuthiresCh10Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch10.control'
        self.glitchcorr = RootSeqRbanaOuthiresCh10ControlGlitchcorr(self._context)
        self.adddigitalmodulation = RootSeqRbanaOuthiresCh10ControlAdddigitalmodulation(self._context)
        self.bypassfilter = RootSeqRbanaOuthiresCh10ControlBypassfilter(self._context)
        self.selectout = RootSeqRbanaOuthiresCh10ControlSelectout(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch10.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch10.control.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh10Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch10.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch10.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch10.currentoutval.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh10Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch10.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch10.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch10.slewrate.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh10Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch10.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch10.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch10.filterval.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh10(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch10'
        self.filterval = RootSeqRbanaOuthiresCh10Filterval(self._context)
        self.slewrate = RootSeqRbanaOuthiresCh10Slewrate(self._context)
        self.currentoutval = RootSeqRbanaOuthiresCh10Currentoutval(self._context)
        self.control = RootSeqRbanaOuthiresCh10Control(self._context)
        self.gain = RootSeqRbanaOuthiresCh10Gain(self._context)
        self.offset = RootSeqRbanaOuthiresCh10Offset(self._context)
        self.lowordgaincorr = RootSeqRbanaOuthiresCh10Lowordgaincorr(self._context)
        self.testvalue = RootSeqRbanaOuthiresCh10Testvalue(self._context)
        self.glitchcorr = RootSeqRbanaOuthiresCh10Glitchcorr(self._context)


class RootSeqRbanaOuthiresCh9Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch9.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch9.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch9.glitchcorr.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh9Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch9.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch9.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch9.testvalue.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh9Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch9.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch9.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch9.lowordgaincorr.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh9Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch9.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch9.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch9.offset.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh9Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch9.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch9.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch9.gain.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh9ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch9.control.selectout'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch9.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch9.control.selectout.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch9.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch9.control.selectout.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch9.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch9.control.selectout.lsb', int(new_val))


class RootSeqRbanaOuthiresCh9ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch9.control.bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch9.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch9.control.bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch9.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch9.control.bypassfilter.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch9.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch9.control.bypassfilter.lsb', int(new_val))


class RootSeqRbanaOuthiresCh9ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch9.control.adddigitalmodulation'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch9.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch9.control.adddigitalmodulation.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch9.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch9.control.adddigitalmodulation.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch9.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch9.control.adddigitalmodulation.lsb', int(new_val))


class RootSeqRbanaOuthiresCh9ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch9.control.glitchcorr'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch9.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch9.control.glitchcorr.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch9.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch9.control.glitchcorr.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch9.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch9.control.glitchcorr.lsb', int(new_val))


class RootSeqRbanaOuthiresCh9Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch9.control'
        self.glitchcorr = RootSeqRbanaOuthiresCh9ControlGlitchcorr(self._context)
        self.adddigitalmodulation = RootSeqRbanaOuthiresCh9ControlAdddigitalmodulation(self._context)
        self.bypassfilter = RootSeqRbanaOuthiresCh9ControlBypassfilter(self._context)
        self.selectout = RootSeqRbanaOuthiresCh9ControlSelectout(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch9.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch9.control.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh9Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch9.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch9.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch9.currentoutval.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh9Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch9.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch9.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch9.slewrate.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh9Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch9.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch9.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch9.filterval.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh9(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch9'
        self.filterval = RootSeqRbanaOuthiresCh9Filterval(self._context)
        self.slewrate = RootSeqRbanaOuthiresCh9Slewrate(self._context)
        self.currentoutval = RootSeqRbanaOuthiresCh9Currentoutval(self._context)
        self.control = RootSeqRbanaOuthiresCh9Control(self._context)
        self.gain = RootSeqRbanaOuthiresCh9Gain(self._context)
        self.offset = RootSeqRbanaOuthiresCh9Offset(self._context)
        self.lowordgaincorr = RootSeqRbanaOuthiresCh9Lowordgaincorr(self._context)
        self.testvalue = RootSeqRbanaOuthiresCh9Testvalue(self._context)
        self.glitchcorr = RootSeqRbanaOuthiresCh9Glitchcorr(self._context)


class RootSeqRbanaOuthiresCh11Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch11.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch11.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch11.glitchcorr.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh11Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch11.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch11.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch11.testvalue.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh11Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch11.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch11.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch11.lowordgaincorr.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh11Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch11.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch11.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch11.offset.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh11Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch11.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch11.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch11.gain.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh11ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch11.control.selectout'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch11.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch11.control.selectout.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch11.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch11.control.selectout.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch11.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch11.control.selectout.lsb', int(new_val))


class RootSeqRbanaOuthiresCh11ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch11.control.bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch11.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch11.control.bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch11.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch11.control.bypassfilter.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch11.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch11.control.bypassfilter.lsb', int(new_val))


class RootSeqRbanaOuthiresCh11ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch11.control.adddigitalmodulation'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch11.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch11.control.adddigitalmodulation.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch11.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch11.control.adddigitalmodulation.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch11.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch11.control.adddigitalmodulation.lsb', int(new_val))


class RootSeqRbanaOuthiresCh11ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch11.control.glitchcorr'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch11.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch11.control.glitchcorr.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch11.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch11.control.glitchcorr.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch11.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch11.control.glitchcorr.lsb', int(new_val))


class RootSeqRbanaOuthiresCh11Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch11.control'
        self.glitchcorr = RootSeqRbanaOuthiresCh11ControlGlitchcorr(self._context)
        self.adddigitalmodulation = RootSeqRbanaOuthiresCh11ControlAdddigitalmodulation(self._context)
        self.bypassfilter = RootSeqRbanaOuthiresCh11ControlBypassfilter(self._context)
        self.selectout = RootSeqRbanaOuthiresCh11ControlSelectout(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch11.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch11.control.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh11Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch11.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch11.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch11.currentoutval.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh11Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch11.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch11.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch11.slewrate.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh11Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch11.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch11.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch11.filterval.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh11(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch11'
        self.filterval = RootSeqRbanaOuthiresCh11Filterval(self._context)
        self.slewrate = RootSeqRbanaOuthiresCh11Slewrate(self._context)
        self.currentoutval = RootSeqRbanaOuthiresCh11Currentoutval(self._context)
        self.control = RootSeqRbanaOuthiresCh11Control(self._context)
        self.gain = RootSeqRbanaOuthiresCh11Gain(self._context)
        self.offset = RootSeqRbanaOuthiresCh11Offset(self._context)
        self.lowordgaincorr = RootSeqRbanaOuthiresCh11Lowordgaincorr(self._context)
        self.testvalue = RootSeqRbanaOuthiresCh11Testvalue(self._context)
        self.glitchcorr = RootSeqRbanaOuthiresCh11Glitchcorr(self._context)


class RootSeqRbanaOuthiresCh4Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch4.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch4.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch4.glitchcorr.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh4Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch4.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch4.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch4.testvalue.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh4Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch4.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch4.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch4.lowordgaincorr.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh4Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch4.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch4.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch4.offset.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh4Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch4.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch4.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch4.gain.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh4ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch4.control.selectout'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch4.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch4.control.selectout.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch4.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch4.control.selectout.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch4.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch4.control.selectout.lsb', int(new_val))


class RootSeqRbanaOuthiresCh4ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch4.control.bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch4.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch4.control.bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch4.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch4.control.bypassfilter.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch4.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch4.control.bypassfilter.lsb', int(new_val))


class RootSeqRbanaOuthiresCh4ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch4.control.adddigitalmodulation'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch4.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch4.control.adddigitalmodulation.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch4.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch4.control.adddigitalmodulation.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch4.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch4.control.adddigitalmodulation.lsb', int(new_val))


class RootSeqRbanaOuthiresCh4ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch4.control.glitchcorr'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch4.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch4.control.glitchcorr.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch4.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch4.control.glitchcorr.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch4.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch4.control.glitchcorr.lsb', int(new_val))


class RootSeqRbanaOuthiresCh4Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch4.control'
        self.glitchcorr = RootSeqRbanaOuthiresCh4ControlGlitchcorr(self._context)
        self.adddigitalmodulation = RootSeqRbanaOuthiresCh4ControlAdddigitalmodulation(self._context)
        self.bypassfilter = RootSeqRbanaOuthiresCh4ControlBypassfilter(self._context)
        self.selectout = RootSeqRbanaOuthiresCh4ControlSelectout(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch4.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch4.control.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh4Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch4.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch4.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch4.currentoutval.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh4Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch4.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch4.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch4.slewrate.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh4Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch4.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch4.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch4.filterval.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch4'
        self.filterval = RootSeqRbanaOuthiresCh4Filterval(self._context)
        self.slewrate = RootSeqRbanaOuthiresCh4Slewrate(self._context)
        self.currentoutval = RootSeqRbanaOuthiresCh4Currentoutval(self._context)
        self.control = RootSeqRbanaOuthiresCh4Control(self._context)
        self.gain = RootSeqRbanaOuthiresCh4Gain(self._context)
        self.offset = RootSeqRbanaOuthiresCh4Offset(self._context)
        self.lowordgaincorr = RootSeqRbanaOuthiresCh4Lowordgaincorr(self._context)
        self.testvalue = RootSeqRbanaOuthiresCh4Testvalue(self._context)
        self.glitchcorr = RootSeqRbanaOuthiresCh4Glitchcorr(self._context)


class RootSeqRbanaOuthiresCh3Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch3.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch3.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch3.glitchcorr.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh3Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch3.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch3.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch3.testvalue.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh3Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch3.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch3.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch3.lowordgaincorr.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh3Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch3.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch3.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch3.offset.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh3Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch3.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch3.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch3.gain.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh3ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch3.control.selectout'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch3.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch3.control.selectout.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch3.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch3.control.selectout.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch3.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch3.control.selectout.lsb', int(new_val))


class RootSeqRbanaOuthiresCh3ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch3.control.bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch3.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch3.control.bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch3.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch3.control.bypassfilter.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch3.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch3.control.bypassfilter.lsb', int(new_val))


class RootSeqRbanaOuthiresCh3ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch3.control.adddigitalmodulation'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch3.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch3.control.adddigitalmodulation.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch3.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch3.control.adddigitalmodulation.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch3.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch3.control.adddigitalmodulation.lsb', int(new_val))


class RootSeqRbanaOuthiresCh3ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch3.control.glitchcorr'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch3.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch3.control.glitchcorr.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch3.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch3.control.glitchcorr.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch3.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch3.control.glitchcorr.lsb', int(new_val))


class RootSeqRbanaOuthiresCh3Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch3.control'
        self.glitchcorr = RootSeqRbanaOuthiresCh3ControlGlitchcorr(self._context)
        self.adddigitalmodulation = RootSeqRbanaOuthiresCh3ControlAdddigitalmodulation(self._context)
        self.bypassfilter = RootSeqRbanaOuthiresCh3ControlBypassfilter(self._context)
        self.selectout = RootSeqRbanaOuthiresCh3ControlSelectout(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch3.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch3.control.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh3Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch3.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch3.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch3.currentoutval.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh3Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch3.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch3.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch3.slewrate.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh3Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch3.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch3.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch3.filterval.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch3'
        self.filterval = RootSeqRbanaOuthiresCh3Filterval(self._context)
        self.slewrate = RootSeqRbanaOuthiresCh3Slewrate(self._context)
        self.currentoutval = RootSeqRbanaOuthiresCh3Currentoutval(self._context)
        self.control = RootSeqRbanaOuthiresCh3Control(self._context)
        self.gain = RootSeqRbanaOuthiresCh3Gain(self._context)
        self.offset = RootSeqRbanaOuthiresCh3Offset(self._context)
        self.lowordgaincorr = RootSeqRbanaOuthiresCh3Lowordgaincorr(self._context)
        self.testvalue = RootSeqRbanaOuthiresCh3Testvalue(self._context)
        self.glitchcorr = RootSeqRbanaOuthiresCh3Glitchcorr(self._context)


class RootSeqRbanaOuthiresCh6Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch6.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch6.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch6.glitchcorr.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh6Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch6.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch6.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch6.testvalue.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh6Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch6.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch6.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch6.lowordgaincorr.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh6Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch6.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch6.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch6.offset.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh6Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch6.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch6.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch6.gain.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh6ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch6.control.selectout'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch6.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch6.control.selectout.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch6.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch6.control.selectout.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch6.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch6.control.selectout.lsb', int(new_val))


class RootSeqRbanaOuthiresCh6ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch6.control.bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch6.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch6.control.bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch6.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch6.control.bypassfilter.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch6.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch6.control.bypassfilter.lsb', int(new_val))


class RootSeqRbanaOuthiresCh6ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch6.control.adddigitalmodulation'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch6.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch6.control.adddigitalmodulation.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch6.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch6.control.adddigitalmodulation.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch6.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch6.control.adddigitalmodulation.lsb', int(new_val))


class RootSeqRbanaOuthiresCh6ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch6.control.glitchcorr'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch6.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch6.control.glitchcorr.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch6.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch6.control.glitchcorr.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch6.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch6.control.glitchcorr.lsb', int(new_val))


class RootSeqRbanaOuthiresCh6Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch6.control'
        self.glitchcorr = RootSeqRbanaOuthiresCh6ControlGlitchcorr(self._context)
        self.adddigitalmodulation = RootSeqRbanaOuthiresCh6ControlAdddigitalmodulation(self._context)
        self.bypassfilter = RootSeqRbanaOuthiresCh6ControlBypassfilter(self._context)
        self.selectout = RootSeqRbanaOuthiresCh6ControlSelectout(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch6.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch6.control.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh6Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch6.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch6.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch6.currentoutval.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh6Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch6.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch6.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch6.slewrate.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh6Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch6.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch6.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch6.filterval.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh6(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch6'
        self.filterval = RootSeqRbanaOuthiresCh6Filterval(self._context)
        self.slewrate = RootSeqRbanaOuthiresCh6Slewrate(self._context)
        self.currentoutval = RootSeqRbanaOuthiresCh6Currentoutval(self._context)
        self.control = RootSeqRbanaOuthiresCh6Control(self._context)
        self.gain = RootSeqRbanaOuthiresCh6Gain(self._context)
        self.offset = RootSeqRbanaOuthiresCh6Offset(self._context)
        self.lowordgaincorr = RootSeqRbanaOuthiresCh6Lowordgaincorr(self._context)
        self.testvalue = RootSeqRbanaOuthiresCh6Testvalue(self._context)
        self.glitchcorr = RootSeqRbanaOuthiresCh6Glitchcorr(self._context)


class RootSeqRbanaOuthiresCh1Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch1.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch1.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch1.glitchcorr.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh1Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch1.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch1.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch1.testvalue.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh1Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch1.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch1.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch1.lowordgaincorr.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh1Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch1.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch1.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch1.offset.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh1Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch1.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch1.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch1.gain.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh1ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch1.control.selectout'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch1.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch1.control.selectout.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch1.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch1.control.selectout.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch1.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch1.control.selectout.lsb', int(new_val))


class RootSeqRbanaOuthiresCh1ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch1.control.bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch1.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch1.control.bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch1.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch1.control.bypassfilter.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch1.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch1.control.bypassfilter.lsb', int(new_val))


class RootSeqRbanaOuthiresCh1ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch1.control.adddigitalmodulation'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch1.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch1.control.adddigitalmodulation.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch1.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch1.control.adddigitalmodulation.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch1.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch1.control.adddigitalmodulation.lsb', int(new_val))


class RootSeqRbanaOuthiresCh1ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch1.control.glitchcorr'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch1.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch1.control.glitchcorr.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch1.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch1.control.glitchcorr.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch1.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch1.control.glitchcorr.lsb', int(new_val))


class RootSeqRbanaOuthiresCh1Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch1.control'
        self.glitchcorr = RootSeqRbanaOuthiresCh1ControlGlitchcorr(self._context)
        self.adddigitalmodulation = RootSeqRbanaOuthiresCh1ControlAdddigitalmodulation(self._context)
        self.bypassfilter = RootSeqRbanaOuthiresCh1ControlBypassfilter(self._context)
        self.selectout = RootSeqRbanaOuthiresCh1ControlSelectout(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch1.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch1.control.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh1Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch1.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch1.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch1.currentoutval.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh1Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch1.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch1.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch1.slewrate.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh1Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch1.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch1.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch1.filterval.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch1'
        self.filterval = RootSeqRbanaOuthiresCh1Filterval(self._context)
        self.slewrate = RootSeqRbanaOuthiresCh1Slewrate(self._context)
        self.currentoutval = RootSeqRbanaOuthiresCh1Currentoutval(self._context)
        self.control = RootSeqRbanaOuthiresCh1Control(self._context)
        self.gain = RootSeqRbanaOuthiresCh1Gain(self._context)
        self.offset = RootSeqRbanaOuthiresCh1Offset(self._context)
        self.lowordgaincorr = RootSeqRbanaOuthiresCh1Lowordgaincorr(self._context)
        self.testvalue = RootSeqRbanaOuthiresCh1Testvalue(self._context)
        self.glitchcorr = RootSeqRbanaOuthiresCh1Glitchcorr(self._context)


class RootSeqRbanaOuthiresCh12Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch12.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch12.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch12.glitchcorr.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh12Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch12.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch12.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch12.testvalue.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh12Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch12.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch12.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch12.lowordgaincorr.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh12Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch12.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch12.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch12.offset.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh12Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch12.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch12.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch12.gain.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh12ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch12.control.selectout'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch12.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch12.control.selectout.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch12.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch12.control.selectout.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch12.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch12.control.selectout.lsb', int(new_val))


class RootSeqRbanaOuthiresCh12ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch12.control.bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch12.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch12.control.bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch12.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch12.control.bypassfilter.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch12.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch12.control.bypassfilter.lsb', int(new_val))


class RootSeqRbanaOuthiresCh12ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch12.control.adddigitalmodulation'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch12.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch12.control.adddigitalmodulation.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch12.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch12.control.adddigitalmodulation.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch12.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch12.control.adddigitalmodulation.lsb', int(new_val))


class RootSeqRbanaOuthiresCh12ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch12.control.glitchcorr'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch12.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch12.control.glitchcorr.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch12.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch12.control.glitchcorr.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch12.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch12.control.glitchcorr.lsb', int(new_val))


class RootSeqRbanaOuthiresCh12Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch12.control'
        self.glitchcorr = RootSeqRbanaOuthiresCh12ControlGlitchcorr(self._context)
        self.adddigitalmodulation = RootSeqRbanaOuthiresCh12ControlAdddigitalmodulation(self._context)
        self.bypassfilter = RootSeqRbanaOuthiresCh12ControlBypassfilter(self._context)
        self.selectout = RootSeqRbanaOuthiresCh12ControlSelectout(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch12.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch12.control.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh12Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch12.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch12.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch12.currentoutval.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh12Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch12.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch12.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch12.slewrate.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh12Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch12.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch12.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch12.filterval.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh12(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch12'
        self.filterval = RootSeqRbanaOuthiresCh12Filterval(self._context)
        self.slewrate = RootSeqRbanaOuthiresCh12Slewrate(self._context)
        self.currentoutval = RootSeqRbanaOuthiresCh12Currentoutval(self._context)
        self.control = RootSeqRbanaOuthiresCh12Control(self._context)
        self.gain = RootSeqRbanaOuthiresCh12Gain(self._context)
        self.offset = RootSeqRbanaOuthiresCh12Offset(self._context)
        self.lowordgaincorr = RootSeqRbanaOuthiresCh12Lowordgaincorr(self._context)
        self.testvalue = RootSeqRbanaOuthiresCh12Testvalue(self._context)
        self.glitchcorr = RootSeqRbanaOuthiresCh12Glitchcorr(self._context)


class RootSeqRbanaOuthiresCh2Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch2.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch2.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch2.glitchcorr.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh2Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch2.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch2.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch2.testvalue.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh2Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch2.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch2.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch2.lowordgaincorr.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh2Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch2.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch2.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch2.offset.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh2Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch2.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch2.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch2.gain.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh2ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch2.control.selectout'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch2.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch2.control.selectout.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch2.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch2.control.selectout.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch2.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch2.control.selectout.lsb', int(new_val))


class RootSeqRbanaOuthiresCh2ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch2.control.bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch2.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch2.control.bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch2.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch2.control.bypassfilter.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch2.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch2.control.bypassfilter.lsb', int(new_val))


class RootSeqRbanaOuthiresCh2ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch2.control.adddigitalmodulation'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch2.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch2.control.adddigitalmodulation.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch2.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch2.control.adddigitalmodulation.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch2.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch2.control.adddigitalmodulation.lsb', int(new_val))


class RootSeqRbanaOuthiresCh2ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch2.control.glitchcorr'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch2.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch2.control.glitchcorr.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch2.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch2.control.glitchcorr.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch2.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch2.control.glitchcorr.lsb', int(new_val))


class RootSeqRbanaOuthiresCh2Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch2.control'
        self.glitchcorr = RootSeqRbanaOuthiresCh2ControlGlitchcorr(self._context)
        self.adddigitalmodulation = RootSeqRbanaOuthiresCh2ControlAdddigitalmodulation(self._context)
        self.bypassfilter = RootSeqRbanaOuthiresCh2ControlBypassfilter(self._context)
        self.selectout = RootSeqRbanaOuthiresCh2ControlSelectout(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch2.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch2.control.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh2Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch2.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch2.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch2.currentoutval.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh2Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch2.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch2.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch2.slewrate.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh2Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch2.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch2.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch2.filterval.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch2'
        self.filterval = RootSeqRbanaOuthiresCh2Filterval(self._context)
        self.slewrate = RootSeqRbanaOuthiresCh2Slewrate(self._context)
        self.currentoutval = RootSeqRbanaOuthiresCh2Currentoutval(self._context)
        self.control = RootSeqRbanaOuthiresCh2Control(self._context)
        self.gain = RootSeqRbanaOuthiresCh2Gain(self._context)
        self.offset = RootSeqRbanaOuthiresCh2Offset(self._context)
        self.lowordgaincorr = RootSeqRbanaOuthiresCh2Lowordgaincorr(self._context)
        self.testvalue = RootSeqRbanaOuthiresCh2Testvalue(self._context)
        self.glitchcorr = RootSeqRbanaOuthiresCh2Glitchcorr(self._context)


class RootSeqRbanaOuthiresCh5Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch5.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch5.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch5.glitchcorr.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh5Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch5.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch5.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch5.testvalue.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh5Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch5.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch5.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch5.lowordgaincorr.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh5Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch5.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch5.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch5.offset.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh5Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch5.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch5.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch5.gain.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh5ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch5.control.selectout'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch5.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch5.control.selectout.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch5.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch5.control.selectout.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch5.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch5.control.selectout.lsb', int(new_val))


class RootSeqRbanaOuthiresCh5ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch5.control.bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch5.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch5.control.bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch5.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch5.control.bypassfilter.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch5.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch5.control.bypassfilter.lsb', int(new_val))


class RootSeqRbanaOuthiresCh5ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch5.control.adddigitalmodulation'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch5.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch5.control.adddigitalmodulation.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch5.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch5.control.adddigitalmodulation.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch5.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch5.control.adddigitalmodulation.lsb', int(new_val))


class RootSeqRbanaOuthiresCh5ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch5.control.glitchcorr'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch5.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch5.control.glitchcorr.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch5.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch5.control.glitchcorr.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch5.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch5.control.glitchcorr.lsb', int(new_val))


class RootSeqRbanaOuthiresCh5Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch5.control'
        self.glitchcorr = RootSeqRbanaOuthiresCh5ControlGlitchcorr(self._context)
        self.adddigitalmodulation = RootSeqRbanaOuthiresCh5ControlAdddigitalmodulation(self._context)
        self.bypassfilter = RootSeqRbanaOuthiresCh5ControlBypassfilter(self._context)
        self.selectout = RootSeqRbanaOuthiresCh5ControlSelectout(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch5.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch5.control.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh5Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch5.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch5.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch5.currentoutval.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh5Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch5.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch5.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch5.slewrate.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh5Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch5.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch5.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch5.filterval.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh5(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch5'
        self.filterval = RootSeqRbanaOuthiresCh5Filterval(self._context)
        self.slewrate = RootSeqRbanaOuthiresCh5Slewrate(self._context)
        self.currentoutval = RootSeqRbanaOuthiresCh5Currentoutval(self._context)
        self.control = RootSeqRbanaOuthiresCh5Control(self._context)
        self.gain = RootSeqRbanaOuthiresCh5Gain(self._context)
        self.offset = RootSeqRbanaOuthiresCh5Offset(self._context)
        self.lowordgaincorr = RootSeqRbanaOuthiresCh5Lowordgaincorr(self._context)
        self.testvalue = RootSeqRbanaOuthiresCh5Testvalue(self._context)
        self.glitchcorr = RootSeqRbanaOuthiresCh5Glitchcorr(self._context)


class RootSeqRbanaOuthiresCh7Glitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch7.glitchcorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch7.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch7.glitchcorr.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh7Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch7.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch7.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch7.testvalue.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh7Lowordgaincorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch7.lowordgaincorr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch7.lowordgaincorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch7.lowordgaincorr.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh7Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch7.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch7.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch7.offset.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh7Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch7.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch7.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch7.gain.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh7ControlSelectout(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch7.control.selectout'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch7.control.selectout.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch7.control.selectout.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch7.control.selectout.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch7.control.selectout.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch7.control.selectout.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch7.control.selectout.lsb', int(new_val))


class RootSeqRbanaOuthiresCh7ControlBypassfilter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch7.control.bypassfilter'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch7.control.bypassfilter.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch7.control.bypassfilter.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch7.control.bypassfilter.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch7.control.bypassfilter.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch7.control.bypassfilter.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch7.control.bypassfilter.lsb', int(new_val))


class RootSeqRbanaOuthiresCh7ControlAdddigitalmodulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch7.control.adddigitalmodulation'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch7.control.adddigitalmodulation.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch7.control.adddigitalmodulation.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch7.control.adddigitalmodulation.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch7.control.adddigitalmodulation.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch7.control.adddigitalmodulation.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch7.control.adddigitalmodulation.lsb', int(new_val))


class RootSeqRbanaOuthiresCh7ControlGlitchcorr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch7.control.glitchcorr'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch7.control.glitchcorr.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch7.control.glitchcorr.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch7.control.glitchcorr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch7.control.glitchcorr.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch7.control.glitchcorr.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch7.control.glitchcorr.lsb', int(new_val))


class RootSeqRbanaOuthiresCh7Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch7.control'
        self.glitchcorr = RootSeqRbanaOuthiresCh7ControlGlitchcorr(self._context)
        self.adddigitalmodulation = RootSeqRbanaOuthiresCh7ControlAdddigitalmodulation(self._context)
        self.bypassfilter = RootSeqRbanaOuthiresCh7ControlBypassfilter(self._context)
        self.selectout = RootSeqRbanaOuthiresCh7ControlSelectout(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch7.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch7.control.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh7Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch7.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch7.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch7.currentoutval.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh7Slewrate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch7.slewrate'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch7.slewrate.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch7.slewrate.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh7Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch7.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhires.ch7.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhires.ch7.filterval.regaddr', int(new_val))


class RootSeqRbanaOuthiresCh7(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires.ch7'
        self.filterval = RootSeqRbanaOuthiresCh7Filterval(self._context)
        self.slewrate = RootSeqRbanaOuthiresCh7Slewrate(self._context)
        self.currentoutval = RootSeqRbanaOuthiresCh7Currentoutval(self._context)
        self.control = RootSeqRbanaOuthiresCh7Control(self._context)
        self.gain = RootSeqRbanaOuthiresCh7Gain(self._context)
        self.offset = RootSeqRbanaOuthiresCh7Offset(self._context)
        self.lowordgaincorr = RootSeqRbanaOuthiresCh7Lowordgaincorr(self._context)
        self.testvalue = RootSeqRbanaOuthiresCh7Testvalue(self._context)
        self.glitchcorr = RootSeqRbanaOuthiresCh7Glitchcorr(self._context)


class RootSeqRbanaOuthires(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhires'
        self.ch7 = RootSeqRbanaOuthiresCh7(self._context)
        self.ch5 = RootSeqRbanaOuthiresCh5(self._context)
        self.ch2 = RootSeqRbanaOuthiresCh2(self._context)
        self.ch12 = RootSeqRbanaOuthiresCh12(self._context)
        self.ch1 = RootSeqRbanaOuthiresCh1(self._context)
        self.ch6 = RootSeqRbanaOuthiresCh6(self._context)
        self.ch3 = RootSeqRbanaOuthiresCh3(self._context)
        self.ch4 = RootSeqRbanaOuthiresCh4(self._context)
        self.ch11 = RootSeqRbanaOuthiresCh11(self._context)
        self.ch9 = RootSeqRbanaOuthiresCh9(self._context)
        self.ch10 = RootSeqRbanaOuthiresCh10(self._context)
        self.ch8 = RootSeqRbanaOuthiresCh8(self._context)


class RootSeqRbanaDpointfltrSgleChanin8Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin8.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin8.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin8.srcchan.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin8.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin8.srcchan.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin8.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin8.srcchan.lsb', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin8(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin8'
        self.srcchan = RootSeqRbanaDpointfltrSgleChanin8Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin8.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin8.regaddr', int(new_val))


class RootSeqRbanaDpointfltrSgleStatusFifofullflag(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.status.fifofullflag'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.status.fifofullflag.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.status.fifofullflag.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.status.fifofullflag.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.status.fifofullflag.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.status.fifofullflag.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.status.fifofullflag.lsb', int(new_val))


class RootSeqRbanaDpointfltrSgleStatusAcqdone(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.status.acqdone'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.status.acqdone.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.status.acqdone.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.status.acqdone.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.status.acqdone.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.status.acqdone.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.status.acqdone.lsb', int(new_val))


class RootSeqRbanaDpointfltrSgleStatusAcqinprogress(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.status.acqinprogress'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.status.acqinprogress.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.status.acqinprogress.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.status.acqinprogress.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.status.acqinprogress.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.status.acqinprogress.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.status.acqinprogress.lsb', int(new_val))


class RootSeqRbanaDpointfltrSgleStatusFifolevel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.status.fifolevel'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.status.fifolevel.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.status.fifolevel.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.status.fifolevel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.status.fifolevel.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.status.fifolevel.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.status.fifolevel.lsb', int(new_val))


class RootSeqRbanaDpointfltrSgleStatusFifoemptyflag(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.status.fifoemptyflag'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.status.fifoemptyflag.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.status.fifoemptyflag.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.status.fifoemptyflag.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.status.fifoemptyflag.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.status.fifoemptyflag.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.status.fifoemptyflag.lsb', int(new_val))


class RootSeqRbanaDpointfltrSgleStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.status'
        self.fifoemptyflag = RootSeqRbanaDpointfltrSgleStatusFifoemptyflag(self._context)
        self.fifolevel = RootSeqRbanaDpointfltrSgleStatusFifolevel(self._context)
        self.acqinprogress = RootSeqRbanaDpointfltrSgleStatusAcqinprogress(self._context)
        self.acqdone = RootSeqRbanaDpointfltrSgleStatusAcqdone(self._context)
        self.fifofullflag = RootSeqRbanaDpointfltrSgleStatusFifofullflag(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.status.regaddr', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin10Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin10.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin10.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin10.srcchan.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin10.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin10.srcchan.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin10.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin10.srcchan.lsb', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin10(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin10'
        self.srcchan = RootSeqRbanaDpointfltrSgleChanin10Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin10.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin10.regaddr', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin14Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin14.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin14.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin14.srcchan.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin14.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin14.srcchan.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin14.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin14.srcchan.lsb', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin14(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin14'
        self.srcchan = RootSeqRbanaDpointfltrSgleChanin14Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin14.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin14.regaddr', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin15Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin15.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin15.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin15.srcchan.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin15.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin15.srcchan.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin15.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin15.srcchan.lsb', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin15(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin15'
        self.srcchan = RootSeqRbanaDpointfltrSgleChanin15Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin15.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin15.regaddr', int(new_val))


class RootSeqRbanaDpointfltrSgleControlSamplemask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.control.samplemask'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.control.samplemask.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.control.samplemask.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.control.samplemask.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.control.samplemask.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.control.samplemask.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.control.samplemask.lsb', int(new_val))


class RootSeqRbanaDpointfltrSgleControlFilterstage(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.control.filterstage'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.control.filterstage.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.control.filterstage.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.control.filterstage.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.control.filterstage.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.control.filterstage.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.control.filterstage.lsb', int(new_val))


class RootSeqRbanaDpointfltrSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.control'
        self.filterstage = RootSeqRbanaDpointfltrSgleControlFilterstage(self._context)
        self.samplemask = RootSeqRbanaDpointfltrSgleControlSamplemask(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.control.regaddr', int(new_val))


class RootSeqRbanaDpointfltrSgleFircoeffs(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.fircoeffs'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.fircoeffs.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.fircoeffs.regaddr', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin13Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin13.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin13.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin13.srcchan.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin13.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin13.srcchan.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin13.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin13.srcchan.lsb', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin13(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin13'
        self.srcchan = RootSeqRbanaDpointfltrSgleChanin13Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin13.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin13.regaddr', int(new_val))


class RootSeqRbanaDpointfltrSgleData(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.data'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.data.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.data.regaddr', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin9Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin9.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin9.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin9.srcchan.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin9.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin9.srcchan.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin9.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin9.srcchan.lsb', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin9(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin9'
        self.srcchan = RootSeqRbanaDpointfltrSgleChanin9Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin9.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin9.regaddr', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin4Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin4.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin4.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin4.srcchan.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin4.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin4.srcchan.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin4.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin4.srcchan.lsb', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin4'
        self.srcchan = RootSeqRbanaDpointfltrSgleChanin4Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin4.regaddr', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin0Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin0.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin0.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin0.srcchan.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin0.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin0.srcchan.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin0.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin0.srcchan.lsb', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin0'
        self.srcchan = RootSeqRbanaDpointfltrSgleChanin0Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin0.regaddr', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin6Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin6.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin6.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin6.srcchan.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin6.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin6.srcchan.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin6.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin6.srcchan.lsb', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin6(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin6'
        self.srcchan = RootSeqRbanaDpointfltrSgleChanin6Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin6.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin6.regaddr', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin2Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin2.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin2.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin2.srcchan.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin2.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin2.srcchan.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin2.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin2.srcchan.lsb', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin2'
        self.srcchan = RootSeqRbanaDpointfltrSgleChanin2Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin2.regaddr', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin1Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin1.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin1.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin1.srcchan.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin1.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin1.srcchan.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin1.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin1.srcchan.lsb', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin1'
        self.srcchan = RootSeqRbanaDpointfltrSgleChanin1Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin1.regaddr', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin7Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin7.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin7.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin7.srcchan.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin7.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin7.srcchan.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin7.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin7.srcchan.lsb', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin7(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin7'
        self.srcchan = RootSeqRbanaDpointfltrSgleChanin7Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin7.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin7.regaddr', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin11Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin11.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin11.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin11.srcchan.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin11.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin11.srcchan.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin11.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin11.srcchan.lsb', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin11(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin11'
        self.srcchan = RootSeqRbanaDpointfltrSgleChanin11Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin11.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin11.regaddr', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin12Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin12.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin12.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin12.srcchan.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin12.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin12.srcchan.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin12.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin12.srcchan.lsb', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin12(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin12'
        self.srcchan = RootSeqRbanaDpointfltrSgleChanin12Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin12.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin12.regaddr', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin3Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin3.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin3.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin3.srcchan.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin3.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin3.srcchan.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin3.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin3.srcchan.lsb', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin3'
        self.srcchan = RootSeqRbanaDpointfltrSgleChanin3Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin3.regaddr', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin5Srcchan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin5.srcchan'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin5.srcchan.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin5.srcchan.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin5.srcchan.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin5.srcchan.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin5.srcchan.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin5.srcchan.lsb', int(new_val))


class RootSeqRbanaDpointfltrSgleChanin5(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle.chanin5'
        self.srcchan = RootSeqRbanaDpointfltrSgleChanin5Srcchan(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.dpointfltr.sgle.chanin5.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.dpointfltr.sgle.chanin5.regaddr', int(new_val))


class RootSeqRbanaDpointfltrSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr.sgle'
        self.chanin5 = RootSeqRbanaDpointfltrSgleChanin5(self._context)
        self.chanin3 = RootSeqRbanaDpointfltrSgleChanin3(self._context)
        self.chanin12 = RootSeqRbanaDpointfltrSgleChanin12(self._context)
        self.chanin11 = RootSeqRbanaDpointfltrSgleChanin11(self._context)
        self.chanin7 = RootSeqRbanaDpointfltrSgleChanin7(self._context)
        self.chanin1 = RootSeqRbanaDpointfltrSgleChanin1(self._context)
        self.chanin2 = RootSeqRbanaDpointfltrSgleChanin2(self._context)
        self.chanin6 = RootSeqRbanaDpointfltrSgleChanin6(self._context)
        self.chanin0 = RootSeqRbanaDpointfltrSgleChanin0(self._context)
        self.chanin4 = RootSeqRbanaDpointfltrSgleChanin4(self._context)
        self.chanin9 = RootSeqRbanaDpointfltrSgleChanin9(self._context)
        self.data = RootSeqRbanaDpointfltrSgleData(self._context)
        self.chanin13 = RootSeqRbanaDpointfltrSgleChanin13(self._context)
        self.fircoeffs = RootSeqRbanaDpointfltrSgleFircoeffs(self._context)
        self.control = RootSeqRbanaDpointfltrSgleControl(self._context)
        self.chanin15 = RootSeqRbanaDpointfltrSgleChanin15(self._context)
        self.chanin14 = RootSeqRbanaDpointfltrSgleChanin14(self._context)
        self.chanin10 = RootSeqRbanaDpointfltrSgleChanin10(self._context)
        self.status = RootSeqRbanaDpointfltrSgleStatus(self._context)
        self.chanin8 = RootSeqRbanaDpointfltrSgleChanin8(self._context)


class RootSeqRbanaDpointfltr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.dpointfltr'
        self.sgle = RootSeqRbanaDpointfltrSgle(self._context)


class RootSeqRbanaRegaddr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.regaddr'


class RootSeqRbanaOutfastcommonSgleDampinggain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfastcommon.sgle.dampinggain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.dampinggain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.dampinggain.regaddr', int(new_val))


class RootSeqRbanaOutfastcommonSgleControlAdddigitalmodulation2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfastcommon.sgle.control.adddigitalmodulation2'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddigitalmodulation2.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddigitalmodulation2.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddigitalmodulation2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddigitalmodulation2.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddigitalmodulation2.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddigitalmodulation2.lsb', int(new_val))


class RootSeqRbanaOutfastcommonSgleControlAdddigitalhiresmodulation2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation2'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation2.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation2.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation2.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation2.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation2.lsb', int(new_val))


class RootSeqRbanaOutfastcommonSgleControlAdddigitalhiresmodulation4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation4'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation4.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation4.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation4.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation4.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation4.lsb', int(new_val))


class RootSeqRbanaOutfastcommonSgleControlAdddigitalmodulation4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfastcommon.sgle.control.adddigitalmodulation4'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddigitalmodulation4.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddigitalmodulation4.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddigitalmodulation4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddigitalmodulation4.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddigitalmodulation4.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddigitalmodulation4.lsb', int(new_val))


class RootSeqRbanaOutfastcommonSgleControlAdddigitalhiresmodulation1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation1'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation1.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation1.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation1.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation1.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation1.lsb', int(new_val))


class RootSeqRbanaOutfastcommonSgleControlSelectout1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfastcommon.sgle.control.selectout1'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.selectout1.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.selectout1.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.selectout1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.selectout1.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.selectout1.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.selectout1.lsb', int(new_val))


class RootSeqRbanaOutfastcommonSgleControlAdddamping4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfastcommon.sgle.control.adddamping4'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddamping4.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddamping4.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddamping4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddamping4.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddamping4.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddamping4.lsb', int(new_val))


class RootSeqRbanaOutfastcommonSgleControlSelectout3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfastcommon.sgle.control.selectout3'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.selectout3.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.selectout3.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.selectout3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.selectout3.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.selectout3.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.selectout3.lsb', int(new_val))


class RootSeqRbanaOutfastcommonSgleControlAdddigitalhiresmodulation3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation3'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation3.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation3.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation3.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation3.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddigitalhiresmodulation3.lsb', int(new_val))


class RootSeqRbanaOutfastcommonSgleControlAdddigitalmodulation3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfastcommon.sgle.control.adddigitalmodulation3'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddigitalmodulation3.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddigitalmodulation3.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddigitalmodulation3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddigitalmodulation3.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddigitalmodulation3.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddigitalmodulation3.lsb', int(new_val))


class RootSeqRbanaOutfastcommonSgleControlAdddamping1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfastcommon.sgle.control.adddamping1'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddamping1.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddamping1.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddamping1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddamping1.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddamping1.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddamping1.lsb', int(new_val))


class RootSeqRbanaOutfastcommonSgleControlSelectout2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfastcommon.sgle.control.selectout2'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.selectout2.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.selectout2.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.selectout2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.selectout2.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.selectout2.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.selectout2.lsb', int(new_val))


class RootSeqRbanaOutfastcommonSgleControlSelectout4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfastcommon.sgle.control.selectout4'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.selectout4.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.selectout4.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.selectout4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.selectout4.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.selectout4.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.selectout4.lsb', int(new_val))


class RootSeqRbanaOutfastcommonSgleControlAdddigitalmodulation1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfastcommon.sgle.control.adddigitalmodulation1'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddigitalmodulation1.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddigitalmodulation1.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddigitalmodulation1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddigitalmodulation1.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddigitalmodulation1.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddigitalmodulation1.lsb', int(new_val))


class RootSeqRbanaOutfastcommonSgleControlAdddamping2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfastcommon.sgle.control.adddamping2'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddamping2.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddamping2.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddamping2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddamping2.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddamping2.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddamping2.lsb', int(new_val))


class RootSeqRbanaOutfastcommonSgleControlAdddamping3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfastcommon.sgle.control.adddamping3'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddamping3.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddamping3.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddamping3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddamping3.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.adddamping3.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.adddamping3.lsb', int(new_val))


class RootSeqRbanaOutfastcommonSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfastcommon.sgle.control'
        self.adddamping3 = RootSeqRbanaOutfastcommonSgleControlAdddamping3(self._context)
        self.adddamping2 = RootSeqRbanaOutfastcommonSgleControlAdddamping2(self._context)
        self.adddigitalmodulation1 = RootSeqRbanaOutfastcommonSgleControlAdddigitalmodulation1(self._context)
        self.selectout4 = RootSeqRbanaOutfastcommonSgleControlSelectout4(self._context)
        self.selectout2 = RootSeqRbanaOutfastcommonSgleControlSelectout2(self._context)
        self.adddamping1 = RootSeqRbanaOutfastcommonSgleControlAdddamping1(self._context)
        self.adddigitalmodulation3 = RootSeqRbanaOutfastcommonSgleControlAdddigitalmodulation3(self._context)
        self.adddigitalhiresmodulation3 = RootSeqRbanaOutfastcommonSgleControlAdddigitalhiresmodulation3(self._context)
        self.selectout3 = RootSeqRbanaOutfastcommonSgleControlSelectout3(self._context)
        self.adddamping4 = RootSeqRbanaOutfastcommonSgleControlAdddamping4(self._context)
        self.selectout1 = RootSeqRbanaOutfastcommonSgleControlSelectout1(self._context)
        self.adddigitalhiresmodulation1 = RootSeqRbanaOutfastcommonSgleControlAdddigitalhiresmodulation1(self._context)
        self.adddigitalmodulation4 = RootSeqRbanaOutfastcommonSgleControlAdddigitalmodulation4(self._context)
        self.adddigitalhiresmodulation4 = RootSeqRbanaOutfastcommonSgleControlAdddigitalhiresmodulation4(self._context)
        self.adddigitalhiresmodulation2 = RootSeqRbanaOutfastcommonSgleControlAdddigitalhiresmodulation2(self._context)
        self.adddigitalmodulation2 = RootSeqRbanaOutfastcommonSgleControlAdddigitalmodulation2(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfastcommon.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfastcommon.sgle.control.regaddr', int(new_val))


class RootSeqRbanaOutfastcommonSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfastcommon.sgle'
        self.control = RootSeqRbanaOutfastcommonSgleControl(self._context)
        self.dampinggain = RootSeqRbanaOutfastcommonSgleDampinggain(self._context)


class RootSeqRbanaOutfastcommon(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfastcommon'
        self.sgle = RootSeqRbanaOutfastcommonSgle(self._context)


class RootSeqRbanaOuthirescommonSgleGpfiltrcoef(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhirescommon.sgle.gpfiltrcoef'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhirescommon.sgle.gpfiltrcoef.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhirescommon.sgle.gpfiltrcoef.regaddr', int(new_val))


class RootSeqRbanaOuthirescommonSgleControlGpflt_vld(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhirescommon.sgle.control.gpflt_vld'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhirescommon.sgle.control.gpflt_vld.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhirescommon.sgle.control.gpflt_vld.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhirescommon.sgle.control.gpflt_vld.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhirescommon.sgle.control.gpflt_vld.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhirescommon.sgle.control.gpflt_vld.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhirescommon.sgle.control.gpflt_vld.lsb', int(new_val))


class RootSeqRbanaOuthirescommonSgleControlSelectmod(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhirescommon.sgle.control.selectmod'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhirescommon.sgle.control.selectmod.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhirescommon.sgle.control.selectmod.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhirescommon.sgle.control.selectmod.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhirescommon.sgle.control.selectmod.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhirescommon.sgle.control.selectmod.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhirescommon.sgle.control.selectmod.lsb', int(new_val))


class RootSeqRbanaOuthirescommonSgleControlOuthires_dac8delay(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhirescommon.sgle.control.outhires_dac8delay'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhirescommon.sgle.control.outhires_dac8delay.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.outhirescommon.sgle.control.outhires_dac8delay.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhirescommon.sgle.control.outhires_dac8delay.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhirescommon.sgle.control.outhires_dac8delay.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.outhirescommon.sgle.control.outhires_dac8delay.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.outhirescommon.sgle.control.outhires_dac8delay.lsb', int(new_val))


class RootSeqRbanaOuthirescommonSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhirescommon.sgle.control'
        self.outhires_dac8delay = RootSeqRbanaOuthirescommonSgleControlOuthires_dac8delay(self._context)
        self.selectmod = RootSeqRbanaOuthirescommonSgleControlSelectmod(self._context)
        self.gpflt_vld = RootSeqRbanaOuthirescommonSgleControlGpflt_vld(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhirescommon.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhirescommon.sgle.control.regaddr', int(new_val))


class RootSeqRbanaOuthirescommonSgleGpfiltraddr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhirescommon.sgle.gpfiltraddr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outhirescommon.sgle.gpfiltraddr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outhirescommon.sgle.gpfiltraddr.regaddr', int(new_val))


class RootSeqRbanaOuthirescommonSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhirescommon.sgle'
        self.gpfiltraddr = RootSeqRbanaOuthirescommonSgleGpfiltraddr(self._context)
        self.control = RootSeqRbanaOuthirescommonSgleControl(self._context)
        self.gpfiltrcoef = RootSeqRbanaOuthirescommonSgleGpfiltrcoef(self._context)


class RootSeqRbanaOuthirescommon(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outhirescommon'
        self.sgle = RootSeqRbanaOuthirescommonSgle(self._context)


class RootSeqRbanaTimerProc0StatusEventcount(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.timer.proc0.status.eventcount'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.proc0.status.eventcount.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.timer.proc0.status.eventcount.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.proc0.status.eventcount.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.timer.proc0.status.eventcount.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.proc0.status.eventcount.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.timer.proc0.status.eventcount.lsb', int(new_val))


class RootSeqRbanaTimerProc0StatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.timer.proc0.status.busy'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.proc0.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.timer.proc0.status.busy.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.proc0.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.timer.proc0.status.busy.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.proc0.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.timer.proc0.status.busy.lsb', int(new_val))


class RootSeqRbanaTimerProc0Status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.timer.proc0.status'
        self.busy = RootSeqRbanaTimerProc0StatusBusy(self._context)
        self.eventcount = RootSeqRbanaTimerProc0StatusEventcount(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.proc0.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.timer.proc0.status.regaddr', int(new_val))


class RootSeqRbanaTimerProc0ControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.timer.proc0.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.proc0.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.timer.proc0.control.mode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.proc0.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.timer.proc0.control.mode.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.proc0.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.timer.proc0.control.mode.lsb', int(new_val))


class RootSeqRbanaTimerProc0ControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.timer.proc0.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.proc0.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.timer.proc0.control.start.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.proc0.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.timer.proc0.control.start.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.proc0.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.timer.proc0.control.start.lsb', int(new_val))


class RootSeqRbanaTimerProc0ControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.timer.proc0.control.stop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.proc0.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.timer.proc0.control.stop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.proc0.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.timer.proc0.control.stop.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.proc0.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.timer.proc0.control.stop.lsb', int(new_val))


class RootSeqRbanaTimerProc0ControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.timer.proc0.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.proc0.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.timer.proc0.control.abort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.proc0.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.timer.proc0.control.abort.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.proc0.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.timer.proc0.control.abort.lsb', int(new_val))


class RootSeqRbanaTimerProc0Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.timer.proc0.control'
        self.abort = RootSeqRbanaTimerProc0ControlAbort(self._context)
        self.stop = RootSeqRbanaTimerProc0ControlStop(self._context)
        self.start = RootSeqRbanaTimerProc0ControlStart(self._context)
        self.mode = RootSeqRbanaTimerProc0ControlMode(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.proc0.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.timer.proc0.control.regaddr', int(new_val))


class RootSeqRbanaTimerProc0Value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.timer.proc0.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.proc0.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.timer.proc0.value.regaddr', int(new_val))


class RootSeqRbanaTimerProc0Events(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.timer.proc0.events'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.proc0.events.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.timer.proc0.events.regaddr', int(new_val))


class RootSeqRbanaTimerProc0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.timer.proc0'
        self.events = RootSeqRbanaTimerProc0Events(self._context)
        self.value = RootSeqRbanaTimerProc0Value(self._context)
        self.control = RootSeqRbanaTimerProc0Control(self._context)
        self.status = RootSeqRbanaTimerProc0Status(self._context)


class RootSeqRbanaTimerDbg1StatusEventcount(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.timer.dbg1.status.eventcount'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.dbg1.status.eventcount.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.timer.dbg1.status.eventcount.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.dbg1.status.eventcount.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.timer.dbg1.status.eventcount.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.dbg1.status.eventcount.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.timer.dbg1.status.eventcount.lsb', int(new_val))


class RootSeqRbanaTimerDbg1StatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.timer.dbg1.status.busy'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.dbg1.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.timer.dbg1.status.busy.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.dbg1.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.timer.dbg1.status.busy.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.dbg1.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.timer.dbg1.status.busy.lsb', int(new_val))


class RootSeqRbanaTimerDbg1Status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.timer.dbg1.status'
        self.busy = RootSeqRbanaTimerDbg1StatusBusy(self._context)
        self.eventcount = RootSeqRbanaTimerDbg1StatusEventcount(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.dbg1.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.timer.dbg1.status.regaddr', int(new_val))


class RootSeqRbanaTimerDbg1ControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.timer.dbg1.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.dbg1.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.timer.dbg1.control.mode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.dbg1.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.timer.dbg1.control.mode.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.dbg1.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.timer.dbg1.control.mode.lsb', int(new_val))


class RootSeqRbanaTimerDbg1ControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.timer.dbg1.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.dbg1.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.timer.dbg1.control.start.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.dbg1.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.timer.dbg1.control.start.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.dbg1.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.timer.dbg1.control.start.lsb', int(new_val))


class RootSeqRbanaTimerDbg1ControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.timer.dbg1.control.stop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.dbg1.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.timer.dbg1.control.stop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.dbg1.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.timer.dbg1.control.stop.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.dbg1.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.timer.dbg1.control.stop.lsb', int(new_val))


class RootSeqRbanaTimerDbg1ControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.timer.dbg1.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.dbg1.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.timer.dbg1.control.abort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.dbg1.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.timer.dbg1.control.abort.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.dbg1.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.timer.dbg1.control.abort.lsb', int(new_val))


class RootSeqRbanaTimerDbg1Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.timer.dbg1.control'
        self.abort = RootSeqRbanaTimerDbg1ControlAbort(self._context)
        self.stop = RootSeqRbanaTimerDbg1ControlStop(self._context)
        self.start = RootSeqRbanaTimerDbg1ControlStart(self._context)
        self.mode = RootSeqRbanaTimerDbg1ControlMode(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.dbg1.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.timer.dbg1.control.regaddr', int(new_val))


class RootSeqRbanaTimerDbg1Value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.timer.dbg1.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.dbg1.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.timer.dbg1.value.regaddr', int(new_val))


class RootSeqRbanaTimerDbg1Events(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.timer.dbg1.events'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.timer.dbg1.events.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.timer.dbg1.events.regaddr', int(new_val))


class RootSeqRbanaTimerDbg1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.timer.dbg1'
        self.events = RootSeqRbanaTimerDbg1Events(self._context)
        self.value = RootSeqRbanaTimerDbg1Value(self._context)
        self.control = RootSeqRbanaTimerDbg1Control(self._context)
        self.status = RootSeqRbanaTimerDbg1Status(self._context)


class RootSeqRbanaTimer(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.timer'
        self.dbg1 = RootSeqRbanaTimerDbg1(self._context)
        self.proc0 = RootSeqRbanaTimerProc0(self._context)


class RootSeqRbanaComparatorComparator2Level(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.comparator.comparator2.level'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator2.level.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator2.level.regaddr', int(new_val))


class RootSeqRbanaComparatorComparator2ControlPolcomparator(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.comparator.comparator2.control.polcomparator'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator2.control.polcomparator.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator2.control.polcomparator.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator2.control.polcomparator.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator2.control.polcomparator.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator2.control.polcomparator.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator2.control.polcomparator.lsb', int(new_val))


class RootSeqRbanaComparatorComparator2ControlInputiir_vld(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.comparator.comparator2.control.inputiir_vld'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator2.control.inputiir_vld.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator2.control.inputiir_vld.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator2.control.inputiir_vld.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator2.control.inputiir_vld.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator2.control.inputiir_vld.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator2.control.inputiir_vld.lsb', int(new_val))


class RootSeqRbanaComparatorComparator2ControlFilterena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.comparator.comparator2.control.filterena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator2.control.filterena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator2.control.filterena.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator2.control.filterena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator2.control.filterena.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator2.control.filterena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator2.control.filterena.lsb', int(new_val))


class RootSeqRbanaComparatorComparator2ControlComparatorinput(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.comparator.comparator2.control.comparatorinput'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator2.control.comparatorinput.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator2.control.comparatorinput.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator2.control.comparatorinput.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator2.control.comparatorinput.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator2.control.comparatorinput.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator2.control.comparatorinput.lsb', int(new_val))


class RootSeqRbanaComparatorComparator2Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.comparator.comparator2.control'
        self.comparatorinput = RootSeqRbanaComparatorComparator2ControlComparatorinput(self._context)
        self.filterena = RootSeqRbanaComparatorComparator2ControlFilterena(self._context)
        self.inputiir_vld = RootSeqRbanaComparatorComparator2ControlInputiir_vld(self._context)
        self.polcomparator = RootSeqRbanaComparatorComparator2ControlPolcomparator(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator2.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator2.control.regaddr', int(new_val))


class RootSeqRbanaComparatorComparator2Iircoef(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.comparator.comparator2.iircoef'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator2.iircoef.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator2.iircoef.regaddr', int(new_val))


class RootSeqRbanaComparatorComparator2Iiraddr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.comparator.comparator2.iiraddr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator2.iiraddr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator2.iiraddr.regaddr', int(new_val))


class RootSeqRbanaComparatorComparator2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.comparator.comparator2'
        self.iiraddr = RootSeqRbanaComparatorComparator2Iiraddr(self._context)
        self.iircoef = RootSeqRbanaComparatorComparator2Iircoef(self._context)
        self.control = RootSeqRbanaComparatorComparator2Control(self._context)
        self.level = RootSeqRbanaComparatorComparator2Level(self._context)


class RootSeqRbanaComparatorComparator1Level(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.comparator.comparator1.level'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator1.level.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator1.level.regaddr', int(new_val))


class RootSeqRbanaComparatorComparator1ControlPolcomparator(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.comparator.comparator1.control.polcomparator'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator1.control.polcomparator.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator1.control.polcomparator.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator1.control.polcomparator.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator1.control.polcomparator.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator1.control.polcomparator.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator1.control.polcomparator.lsb', int(new_val))


class RootSeqRbanaComparatorComparator1ControlInputiir_vld(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.comparator.comparator1.control.inputiir_vld'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator1.control.inputiir_vld.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator1.control.inputiir_vld.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator1.control.inputiir_vld.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator1.control.inputiir_vld.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator1.control.inputiir_vld.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator1.control.inputiir_vld.lsb', int(new_val))


class RootSeqRbanaComparatorComparator1ControlFilterena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.comparator.comparator1.control.filterena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator1.control.filterena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator1.control.filterena.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator1.control.filterena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator1.control.filterena.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator1.control.filterena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator1.control.filterena.lsb', int(new_val))


class RootSeqRbanaComparatorComparator1ControlComparatorinput(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.comparator.comparator1.control.comparatorinput'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator1.control.comparatorinput.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator1.control.comparatorinput.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator1.control.comparatorinput.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator1.control.comparatorinput.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator1.control.comparatorinput.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator1.control.comparatorinput.lsb', int(new_val))


class RootSeqRbanaComparatorComparator1Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.comparator.comparator1.control'
        self.comparatorinput = RootSeqRbanaComparatorComparator1ControlComparatorinput(self._context)
        self.filterena = RootSeqRbanaComparatorComparator1ControlFilterena(self._context)
        self.inputiir_vld = RootSeqRbanaComparatorComparator1ControlInputiir_vld(self._context)
        self.polcomparator = RootSeqRbanaComparatorComparator1ControlPolcomparator(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator1.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator1.control.regaddr', int(new_val))


class RootSeqRbanaComparatorComparator1Iircoef(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.comparator.comparator1.iircoef'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator1.iircoef.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator1.iircoef.regaddr', int(new_val))


class RootSeqRbanaComparatorComparator1Iiraddr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.comparator.comparator1.iiraddr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator1.iiraddr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator1.iiraddr.regaddr', int(new_val))


class RootSeqRbanaComparatorComparator1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.comparator.comparator1'
        self.iiraddr = RootSeqRbanaComparatorComparator1Iiraddr(self._context)
        self.iircoef = RootSeqRbanaComparatorComparator1Iircoef(self._context)
        self.control = RootSeqRbanaComparatorComparator1Control(self._context)
        self.level = RootSeqRbanaComparatorComparator1Level(self._context)


class RootSeqRbanaComparatorComparator3Level(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.comparator.comparator3.level'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator3.level.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator3.level.regaddr', int(new_val))


class RootSeqRbanaComparatorComparator3ControlPolcomparator(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.comparator.comparator3.control.polcomparator'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator3.control.polcomparator.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator3.control.polcomparator.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator3.control.polcomparator.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator3.control.polcomparator.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator3.control.polcomparator.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator3.control.polcomparator.lsb', int(new_val))


class RootSeqRbanaComparatorComparator3ControlInputiir_vld(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.comparator.comparator3.control.inputiir_vld'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator3.control.inputiir_vld.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator3.control.inputiir_vld.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator3.control.inputiir_vld.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator3.control.inputiir_vld.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator3.control.inputiir_vld.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator3.control.inputiir_vld.lsb', int(new_val))


class RootSeqRbanaComparatorComparator3ControlFilterena(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.comparator.comparator3.control.filterena'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator3.control.filterena.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator3.control.filterena.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator3.control.filterena.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator3.control.filterena.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator3.control.filterena.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator3.control.filterena.lsb', int(new_val))


class RootSeqRbanaComparatorComparator3ControlComparatorinput(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.comparator.comparator3.control.comparatorinput'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator3.control.comparatorinput.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator3.control.comparatorinput.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator3.control.comparatorinput.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator3.control.comparatorinput.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator3.control.comparatorinput.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator3.control.comparatorinput.lsb', int(new_val))


class RootSeqRbanaComparatorComparator3Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.comparator.comparator3.control'
        self.comparatorinput = RootSeqRbanaComparatorComparator3ControlComparatorinput(self._context)
        self.filterena = RootSeqRbanaComparatorComparator3ControlFilterena(self._context)
        self.inputiir_vld = RootSeqRbanaComparatorComparator3ControlInputiir_vld(self._context)
        self.polcomparator = RootSeqRbanaComparatorComparator3ControlPolcomparator(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator3.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator3.control.regaddr', int(new_val))


class RootSeqRbanaComparatorComparator3Iircoef(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.comparator.comparator3.iircoef'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator3.iircoef.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator3.iircoef.regaddr', int(new_val))


class RootSeqRbanaComparatorComparator3Iiraddr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.comparator.comparator3.iiraddr'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.comparator.comparator3.iiraddr.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.comparator.comparator3.iiraddr.regaddr', int(new_val))


class RootSeqRbanaComparatorComparator3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.comparator.comparator3'
        self.iiraddr = RootSeqRbanaComparatorComparator3Iiraddr(self._context)
        self.iircoef = RootSeqRbanaComparatorComparator3Iircoef(self._context)
        self.control = RootSeqRbanaComparatorComparator3Control(self._context)
        self.level = RootSeqRbanaComparatorComparator3Level(self._context)


class RootSeqRbanaComparator(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.comparator'
        self.comparator3 = RootSeqRbanaComparatorComparator3(self._context)
        self.comparator1 = RootSeqRbanaComparatorComparator1(self._context)
        self.comparator2 = RootSeqRbanaComparatorComparator2(self._context)


class RootSeqRbanaInfastcommon(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.infastcommon'


class RootSeqRbanaOutfastCh2Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfast.ch2.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfast.ch2.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfast.ch2.gain.regaddr', int(new_val))


class RootSeqRbanaOutfastCh2Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfast.ch2.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfast.ch2.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfast.ch2.currentoutval.regaddr', int(new_val))


class RootSeqRbanaOutfastCh2Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfast.ch2.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfast.ch2.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfast.ch2.testvalue.regaddr', int(new_val))


class RootSeqRbanaOutfastCh2Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfast.ch2.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfast.ch2.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfast.ch2.offset.regaddr', int(new_val))


class RootSeqRbanaOutfastCh2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfast.ch2'
        self.offset = RootSeqRbanaOutfastCh2Offset(self._context)
        self.testvalue = RootSeqRbanaOutfastCh2Testvalue(self._context)
        self.currentoutval = RootSeqRbanaOutfastCh2Currentoutval(self._context)
        self.gain = RootSeqRbanaOutfastCh2Gain(self._context)


class RootSeqRbanaOutfastCh3Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfast.ch3.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfast.ch3.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfast.ch3.gain.regaddr', int(new_val))


class RootSeqRbanaOutfastCh3Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfast.ch3.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfast.ch3.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfast.ch3.currentoutval.regaddr', int(new_val))


class RootSeqRbanaOutfastCh3Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfast.ch3.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfast.ch3.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfast.ch3.testvalue.regaddr', int(new_val))


class RootSeqRbanaOutfastCh3Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfast.ch3.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfast.ch3.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfast.ch3.offset.regaddr', int(new_val))


class RootSeqRbanaOutfastCh3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfast.ch3'
        self.offset = RootSeqRbanaOutfastCh3Offset(self._context)
        self.testvalue = RootSeqRbanaOutfastCh3Testvalue(self._context)
        self.currentoutval = RootSeqRbanaOutfastCh3Currentoutval(self._context)
        self.gain = RootSeqRbanaOutfastCh3Gain(self._context)


class RootSeqRbanaOutfastCh4Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfast.ch4.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfast.ch4.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfast.ch4.gain.regaddr', int(new_val))


class RootSeqRbanaOutfastCh4Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfast.ch4.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfast.ch4.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfast.ch4.currentoutval.regaddr', int(new_val))


class RootSeqRbanaOutfastCh4Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfast.ch4.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfast.ch4.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfast.ch4.testvalue.regaddr', int(new_val))


class RootSeqRbanaOutfastCh4Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfast.ch4.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfast.ch4.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfast.ch4.offset.regaddr', int(new_val))


class RootSeqRbanaOutfastCh4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfast.ch4'
        self.offset = RootSeqRbanaOutfastCh4Offset(self._context)
        self.testvalue = RootSeqRbanaOutfastCh4Testvalue(self._context)
        self.currentoutval = RootSeqRbanaOutfastCh4Currentoutval(self._context)
        self.gain = RootSeqRbanaOutfastCh4Gain(self._context)


class RootSeqRbanaOutfastCh1Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfast.ch1.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfast.ch1.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfast.ch1.gain.regaddr', int(new_val))


class RootSeqRbanaOutfastCh1Currentoutval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfast.ch1.currentoutval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfast.ch1.currentoutval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfast.ch1.currentoutval.regaddr', int(new_val))


class RootSeqRbanaOutfastCh1Testvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfast.ch1.testvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfast.ch1.testvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfast.ch1.testvalue.regaddr', int(new_val))


class RootSeqRbanaOutfastCh1Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfast.ch1.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.outfast.ch1.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.outfast.ch1.offset.regaddr', int(new_val))


class RootSeqRbanaOutfastCh1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfast.ch1'
        self.offset = RootSeqRbanaOutfastCh1Offset(self._context)
        self.testvalue = RootSeqRbanaOutfastCh1Testvalue(self._context)
        self.currentoutval = RootSeqRbanaOutfastCh1Currentoutval(self._context)
        self.gain = RootSeqRbanaOutfastCh1Gain(self._context)


class RootSeqRbanaOutfast(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.outfast'
        self.ch1 = RootSeqRbanaOutfastCh1(self._context)
        self.ch4 = RootSeqRbanaOutfastCh4(self._context)
        self.ch3 = RootSeqRbanaOutfastCh3(self._context)
        self.ch2 = RootSeqRbanaOutfastCh2(self._context)


class RootSeqRbanaEventmgrSgleEventsnapshot(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.eventmgr.sgle.eventsnapshot'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.eventsnapshot.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.eventsnapshot.regaddr', int(new_val))


class RootSeqRbanaEventmgrSgleStatusAbortevent(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.eventmgr.sgle.status.abortevent'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.status.abortevent.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.status.abortevent.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.status.abortevent.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.status.abortevent.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.status.abortevent.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.status.abortevent.lsb', int(new_val))


class RootSeqRbanaEventmgrSgleStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.eventmgr.sgle.status.busy'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.status.busy.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.status.busy.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.status.busy.lsb', int(new_val))


class RootSeqRbanaEventmgrSgleStatusStopevent(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.eventmgr.sgle.status.stopevent'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.status.stopevent.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.status.stopevent.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.status.stopevent.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.status.stopevent.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.status.stopevent.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.status.stopevent.lsb', int(new_val))


class RootSeqRbanaEventmgrSgleStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.eventmgr.sgle.status'
        self.stopevent = RootSeqRbanaEventmgrSgleStatusStopevent(self._context)
        self.busy = RootSeqRbanaEventmgrSgleStatusBusy(self._context)
        self.abortevent = RootSeqRbanaEventmgrSgleStatusAbortevent(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.status.regaddr', int(new_val))


class RootSeqRbanaEventmgrSgleStopmask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.eventmgr.sgle.stopmask'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.stopmask.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.stopmask.regaddr', int(new_val))


class RootSeqRbanaEventmgrSgleControlSoftevent1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.eventmgr.sgle.control.softevent1'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.control.softevent1.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.control.softevent1.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.control.softevent1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.control.softevent1.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.control.softevent1.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.control.softevent1.lsb', int(new_val))


class RootSeqRbanaEventmgrSgleControlSoftevent3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.eventmgr.sgle.control.softevent3'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.control.softevent3.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.control.softevent3.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.control.softevent3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.control.softevent3.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.control.softevent3.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.control.softevent3.lsb', int(new_val))


class RootSeqRbanaEventmgrSgleControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.eventmgr.sgle.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.control.start.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.control.start.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.control.start.lsb', int(new_val))


class RootSeqRbanaEventmgrSgleControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.eventmgr.sgle.control.stop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.control.stop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.control.stop.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.control.stop.lsb', int(new_val))


class RootSeqRbanaEventmgrSgleControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.eventmgr.sgle.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.control.abort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.control.abort.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.control.abort.lsb', int(new_val))


class RootSeqRbanaEventmgrSgleControlSoftevent2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.eventmgr.sgle.control.softevent2'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.control.softevent2.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.control.softevent2.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.control.softevent2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.control.softevent2.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.control.softevent2.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.control.softevent2.lsb', int(new_val))


class RootSeqRbanaEventmgrSgleControlSoftevent0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.eventmgr.sgle.control.softevent0'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.control.softevent0.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.control.softevent0.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.control.softevent0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.control.softevent0.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.control.softevent0.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.control.softevent0.lsb', int(new_val))


class RootSeqRbanaEventmgrSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.eventmgr.sgle.control'
        self.softevent0 = RootSeqRbanaEventmgrSgleControlSoftevent0(self._context)
        self.softevent2 = RootSeqRbanaEventmgrSgleControlSoftevent2(self._context)
        self.abort = RootSeqRbanaEventmgrSgleControlAbort(self._context)
        self.stop = RootSeqRbanaEventmgrSgleControlStop(self._context)
        self.start = RootSeqRbanaEventmgrSgleControlStart(self._context)
        self.softevent3 = RootSeqRbanaEventmgrSgleControlSoftevent3(self._context)
        self.softevent1 = RootSeqRbanaEventmgrSgleControlSoftevent1(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.control.regaddr', int(new_val))


class RootSeqRbanaEventmgrSgleStopeventmask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.eventmgr.sgle.stopeventmask'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.stopeventmask.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.stopeventmask.regaddr', int(new_val))


class RootSeqRbanaEventmgrSgleEventvector(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.eventmgr.sgle.eventvector'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.eventvector.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.eventvector.regaddr', int(new_val))


class RootSeqRbanaEventmgrSgleAndmask0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.eventmgr.sgle.andmask0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.andmask0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.andmask0.regaddr', int(new_val))


class RootSeqRbanaEventmgrSgleStartmask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.eventmgr.sgle.startmask'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.startmask.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.startmask.regaddr', int(new_val))


class RootSeqRbanaEventmgrSgleAborteventmask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.eventmgr.sgle.aborteventmask'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.eventmgr.sgle.aborteventmask.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.eventmgr.sgle.aborteventmask.regaddr', int(new_val))


class RootSeqRbanaEventmgrSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.eventmgr.sgle'
        self.aborteventmask = RootSeqRbanaEventmgrSgleAborteventmask(self._context)
        self.startmask = RootSeqRbanaEventmgrSgleStartmask(self._context)
        self.andmask0 = RootSeqRbanaEventmgrSgleAndmask0(self._context)
        self.eventvector = RootSeqRbanaEventmgrSgleEventvector(self._context)
        self.stopeventmask = RootSeqRbanaEventmgrSgleStopeventmask(self._context)
        self.control = RootSeqRbanaEventmgrSgleControl(self._context)
        self.stopmask = RootSeqRbanaEventmgrSgleStopmask(self._context)
        self.status = RootSeqRbanaEventmgrSgleStatus(self._context)
        self.eventsnapshot = RootSeqRbanaEventmgrSgleEventsnapshot(self._context)


class RootSeqRbanaEventmgr(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.eventmgr'
        self.sgle = RootSeqRbanaEventmgrSgle(self._context)


class RootSeqRbanaRampgenTestOut(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.test.out'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.out.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.out.regaddr', int(new_val))


class RootSeqRbanaRampgenTestStatusReachedlowerlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.test.status.reachedlowerlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.status.reachedlowerlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.status.reachedlowerlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.status.reachedlowerlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.status.reachedlowerlimit.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.status.reachedlowerlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.status.reachedlowerlimit.lsb', int(new_val))


class RootSeqRbanaRampgenTestStatusReachedregularend(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.test.status.reachedregularend'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.status.reachedregularend.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.status.reachedregularend.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.status.reachedregularend.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.status.reachedregularend.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.status.reachedregularend.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.status.reachedregularend.lsb', int(new_val))


class RootSeqRbanaRampgenTestStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.test.status.busy'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.status.busy.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.status.busy.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.status.busy.lsb', int(new_val))


class RootSeqRbanaRampgenTestStatusReachedupperlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.test.status.reachedupperlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.status.reachedupperlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.status.reachedupperlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.status.reachedupperlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.status.reachedupperlimit.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.status.reachedupperlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.status.reachedupperlimit.lsb', int(new_val))


class RootSeqRbanaRampgenTestStatusCountup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.test.status.countup'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.status.countup.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.status.countup.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.status.countup.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.status.countup.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.status.countup.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.status.countup.lsb', int(new_val))


class RootSeqRbanaRampgenTestStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.test.status'
        self.countup = RootSeqRbanaRampgenTestStatusCountup(self._context)
        self.reachedupperlimit = RootSeqRbanaRampgenTestStatusReachedupperlimit(self._context)
        self.busy = RootSeqRbanaRampgenTestStatusBusy(self._context)
        self.reachedregularend = RootSeqRbanaRampgenTestStatusReachedregularend(self._context)
        self.reachedlowerlimit = RootSeqRbanaRampgenTestStatusReachedlowerlimit(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.status.regaddr', int(new_val))


class RootSeqRbanaRampgenTestValue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.test.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.value.regaddr', int(new_val))


class RootSeqRbanaRampgenTestLimit_neg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.test.limit_neg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.limit_neg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.limit_neg.regaddr', int(new_val))


class RootSeqRbanaRampgenTestControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.test.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.control.mode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.control.mode.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.control.mode.lsb', int(new_val))


class RootSeqRbanaRampgenTestControlInit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.test.control.init'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.control.init.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.control.init.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.control.init.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.control.init.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.control.init.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.control.init.lsb', int(new_val))


class RootSeqRbanaRampgenTestControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.test.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.control.start.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.control.start.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.control.start.lsb', int(new_val))


class RootSeqRbanaRampgenTestControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.test.control.stop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.control.stop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.control.stop.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.control.stop.lsb', int(new_val))


class RootSeqRbanaRampgenTestControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.test.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.control.abort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.control.abort.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.control.abort.lsb', int(new_val))


class RootSeqRbanaRampgenTestControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.test.control'
        self.abort = RootSeqRbanaRampgenTestControlAbort(self._context)
        self.stop = RootSeqRbanaRampgenTestControlStop(self._context)
        self.start = RootSeqRbanaRampgenTestControlStart(self._context)
        self.init = RootSeqRbanaRampgenTestControlInit(self._context)
        self.mode = RootSeqRbanaRampgenTestControlMode(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.control.regaddr', int(new_val))


class RootSeqRbanaRampgenTestIncrement(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.test.increment'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.increment.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.increment.regaddr', int(new_val))


class RootSeqRbanaRampgenTestLimit_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.test.limit_pos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.test.limit_pos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.test.limit_pos.regaddr', int(new_val))


class RootSeqRbanaRampgenTest(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.test'
        self.limit_pos = RootSeqRbanaRampgenTestLimit_pos(self._context)
        self.increment = RootSeqRbanaRampgenTestIncrement(self._context)
        self.control = RootSeqRbanaRampgenTestControl(self._context)
        self.limit_neg = RootSeqRbanaRampgenTestLimit_neg(self._context)
        self.value = RootSeqRbanaRampgenTestValue(self._context)
        self.status = RootSeqRbanaRampgenTestStatus(self._context)
        self.out = RootSeqRbanaRampgenTestOut(self._context)


class RootSeqRbanaRampgenApproachOut(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.approach.out'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.out.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.out.regaddr', int(new_val))


class RootSeqRbanaRampgenApproachStatusReachedlowerlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.approach.status.reachedlowerlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.status.reachedlowerlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.status.reachedlowerlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.status.reachedlowerlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.status.reachedlowerlimit.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.status.reachedlowerlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.status.reachedlowerlimit.lsb', int(new_val))


class RootSeqRbanaRampgenApproachStatusReachedregularend(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.approach.status.reachedregularend'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.status.reachedregularend.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.status.reachedregularend.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.status.reachedregularend.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.status.reachedregularend.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.status.reachedregularend.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.status.reachedregularend.lsb', int(new_val))


class RootSeqRbanaRampgenApproachStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.approach.status.busy'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.status.busy.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.status.busy.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.status.busy.lsb', int(new_val))


class RootSeqRbanaRampgenApproachStatusReachedupperlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.approach.status.reachedupperlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.status.reachedupperlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.status.reachedupperlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.status.reachedupperlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.status.reachedupperlimit.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.status.reachedupperlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.status.reachedupperlimit.lsb', int(new_val))


class RootSeqRbanaRampgenApproachStatusCountup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.approach.status.countup'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.status.countup.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.status.countup.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.status.countup.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.status.countup.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.status.countup.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.status.countup.lsb', int(new_val))


class RootSeqRbanaRampgenApproachStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.approach.status'
        self.countup = RootSeqRbanaRampgenApproachStatusCountup(self._context)
        self.reachedupperlimit = RootSeqRbanaRampgenApproachStatusReachedupperlimit(self._context)
        self.busy = RootSeqRbanaRampgenApproachStatusBusy(self._context)
        self.reachedregularend = RootSeqRbanaRampgenApproachStatusReachedregularend(self._context)
        self.reachedlowerlimit = RootSeqRbanaRampgenApproachStatusReachedlowerlimit(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.status.regaddr', int(new_val))


class RootSeqRbanaRampgenApproachValue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.approach.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.value.regaddr', int(new_val))


class RootSeqRbanaRampgenApproachLimit_neg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.approach.limit_neg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.limit_neg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.limit_neg.regaddr', int(new_val))


class RootSeqRbanaRampgenApproachControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.approach.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.control.mode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.control.mode.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.control.mode.lsb', int(new_val))


class RootSeqRbanaRampgenApproachControlInit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.approach.control.init'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.control.init.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.control.init.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.control.init.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.control.init.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.control.init.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.control.init.lsb', int(new_val))


class RootSeqRbanaRampgenApproachControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.approach.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.control.start.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.control.start.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.control.start.lsb', int(new_val))


class RootSeqRbanaRampgenApproachControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.approach.control.stop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.control.stop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.control.stop.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.control.stop.lsb', int(new_val))


class RootSeqRbanaRampgenApproachControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.approach.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.control.abort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.control.abort.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.control.abort.lsb', int(new_val))


class RootSeqRbanaRampgenApproachControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.approach.control'
        self.abort = RootSeqRbanaRampgenApproachControlAbort(self._context)
        self.stop = RootSeqRbanaRampgenApproachControlStop(self._context)
        self.start = RootSeqRbanaRampgenApproachControlStart(self._context)
        self.init = RootSeqRbanaRampgenApproachControlInit(self._context)
        self.mode = RootSeqRbanaRampgenApproachControlMode(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.control.regaddr', int(new_val))


class RootSeqRbanaRampgenApproachIncrement(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.approach.increment'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.increment.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.increment.regaddr', int(new_val))


class RootSeqRbanaRampgenApproachLimit_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.approach.limit_pos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.approach.limit_pos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.approach.limit_pos.regaddr', int(new_val))


class RootSeqRbanaRampgenApproach(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.approach'
        self.limit_pos = RootSeqRbanaRampgenApproachLimit_pos(self._context)
        self.increment = RootSeqRbanaRampgenApproachIncrement(self._context)
        self.control = RootSeqRbanaRampgenApproachControl(self._context)
        self.limit_neg = RootSeqRbanaRampgenApproachLimit_neg(self._context)
        self.value = RootSeqRbanaRampgenApproachValue(self._context)
        self.status = RootSeqRbanaRampgenApproachStatus(self._context)
        self.out = RootSeqRbanaRampgenApproachOut(self._context)


class RootSeqRbanaRampgenTipvoltageOut(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.tipvoltage.out'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.out.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.out.regaddr', int(new_val))


class RootSeqRbanaRampgenTipvoltageStatusReachedlowerlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.tipvoltage.status.reachedlowerlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.status.reachedlowerlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.status.reachedlowerlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.status.reachedlowerlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.status.reachedlowerlimit.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.status.reachedlowerlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.status.reachedlowerlimit.lsb', int(new_val))


class RootSeqRbanaRampgenTipvoltageStatusReachedregularend(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.tipvoltage.status.reachedregularend'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.status.reachedregularend.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.status.reachedregularend.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.status.reachedregularend.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.status.reachedregularend.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.status.reachedregularend.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.status.reachedregularend.lsb', int(new_val))


class RootSeqRbanaRampgenTipvoltageStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.tipvoltage.status.busy'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.status.busy.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.status.busy.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.status.busy.lsb', int(new_val))


class RootSeqRbanaRampgenTipvoltageStatusReachedupperlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.tipvoltage.status.reachedupperlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.status.reachedupperlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.status.reachedupperlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.status.reachedupperlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.status.reachedupperlimit.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.status.reachedupperlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.status.reachedupperlimit.lsb', int(new_val))


class RootSeqRbanaRampgenTipvoltageStatusCountup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.tipvoltage.status.countup'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.status.countup.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.status.countup.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.status.countup.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.status.countup.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.status.countup.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.status.countup.lsb', int(new_val))


class RootSeqRbanaRampgenTipvoltageStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.tipvoltage.status'
        self.countup = RootSeqRbanaRampgenTipvoltageStatusCountup(self._context)
        self.reachedupperlimit = RootSeqRbanaRampgenTipvoltageStatusReachedupperlimit(self._context)
        self.busy = RootSeqRbanaRampgenTipvoltageStatusBusy(self._context)
        self.reachedregularend = RootSeqRbanaRampgenTipvoltageStatusReachedregularend(self._context)
        self.reachedlowerlimit = RootSeqRbanaRampgenTipvoltageStatusReachedlowerlimit(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.status.regaddr', int(new_val))


class RootSeqRbanaRampgenTipvoltageValue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.tipvoltage.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.value.regaddr', int(new_val))


class RootSeqRbanaRampgenTipvoltageLimit_neg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.tipvoltage.limit_neg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.limit_neg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.limit_neg.regaddr', int(new_val))


class RootSeqRbanaRampgenTipvoltageControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.tipvoltage.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.control.mode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.control.mode.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.control.mode.lsb', int(new_val))


class RootSeqRbanaRampgenTipvoltageControlInit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.tipvoltage.control.init'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.control.init.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.control.init.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.control.init.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.control.init.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.control.init.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.control.init.lsb', int(new_val))


class RootSeqRbanaRampgenTipvoltageControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.tipvoltage.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.control.start.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.control.start.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.control.start.lsb', int(new_val))


class RootSeqRbanaRampgenTipvoltageControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.tipvoltage.control.stop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.control.stop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.control.stop.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.control.stop.lsb', int(new_val))


class RootSeqRbanaRampgenTipvoltageControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.tipvoltage.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.control.abort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.control.abort.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.control.abort.lsb', int(new_val))


class RootSeqRbanaRampgenTipvoltageControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.tipvoltage.control'
        self.abort = RootSeqRbanaRampgenTipvoltageControlAbort(self._context)
        self.stop = RootSeqRbanaRampgenTipvoltageControlStop(self._context)
        self.start = RootSeqRbanaRampgenTipvoltageControlStart(self._context)
        self.init = RootSeqRbanaRampgenTipvoltageControlInit(self._context)
        self.mode = RootSeqRbanaRampgenTipvoltageControlMode(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.control.regaddr', int(new_val))


class RootSeqRbanaRampgenTipvoltageIncrement(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.tipvoltage.increment'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.increment.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.increment.regaddr', int(new_val))


class RootSeqRbanaRampgenTipvoltageLimit_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.tipvoltage.limit_pos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.tipvoltage.limit_pos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.tipvoltage.limit_pos.regaddr', int(new_val))


class RootSeqRbanaRampgenTipvoltage(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.tipvoltage'
        self.limit_pos = RootSeqRbanaRampgenTipvoltageLimit_pos(self._context)
        self.increment = RootSeqRbanaRampgenTipvoltageIncrement(self._context)
        self.control = RootSeqRbanaRampgenTipvoltageControl(self._context)
        self.limit_neg = RootSeqRbanaRampgenTipvoltageLimit_neg(self._context)
        self.value = RootSeqRbanaRampgenTipvoltageValue(self._context)
        self.status = RootSeqRbanaRampgenTipvoltageStatus(self._context)
        self.out = RootSeqRbanaRampgenTipvoltageOut(self._context)


class RootSeqRbanaRampgenUser4Out(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.user4.out'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.out.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.out.regaddr', int(new_val))


class RootSeqRbanaRampgenUser4StatusReachedlowerlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.user4.status.reachedlowerlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.status.reachedlowerlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.status.reachedlowerlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.status.reachedlowerlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.status.reachedlowerlimit.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.status.reachedlowerlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.status.reachedlowerlimit.lsb', int(new_val))


class RootSeqRbanaRampgenUser4StatusReachedregularend(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.user4.status.reachedregularend'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.status.reachedregularend.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.status.reachedregularend.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.status.reachedregularend.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.status.reachedregularend.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.status.reachedregularend.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.status.reachedregularend.lsb', int(new_val))


class RootSeqRbanaRampgenUser4StatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.user4.status.busy'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.status.busy.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.status.busy.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.status.busy.lsb', int(new_val))


class RootSeqRbanaRampgenUser4StatusReachedupperlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.user4.status.reachedupperlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.status.reachedupperlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.status.reachedupperlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.status.reachedupperlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.status.reachedupperlimit.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.status.reachedupperlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.status.reachedupperlimit.lsb', int(new_val))


class RootSeqRbanaRampgenUser4StatusCountup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.user4.status.countup'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.status.countup.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.status.countup.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.status.countup.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.status.countup.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.status.countup.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.status.countup.lsb', int(new_val))


class RootSeqRbanaRampgenUser4Status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.user4.status'
        self.countup = RootSeqRbanaRampgenUser4StatusCountup(self._context)
        self.reachedupperlimit = RootSeqRbanaRampgenUser4StatusReachedupperlimit(self._context)
        self.busy = RootSeqRbanaRampgenUser4StatusBusy(self._context)
        self.reachedregularend = RootSeqRbanaRampgenUser4StatusReachedregularend(self._context)
        self.reachedlowerlimit = RootSeqRbanaRampgenUser4StatusReachedlowerlimit(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.status.regaddr', int(new_val))


class RootSeqRbanaRampgenUser4Value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.user4.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.value.regaddr', int(new_val))


class RootSeqRbanaRampgenUser4Limit_neg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.user4.limit_neg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.limit_neg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.limit_neg.regaddr', int(new_val))


class RootSeqRbanaRampgenUser4ControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.user4.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.control.mode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.control.mode.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.control.mode.lsb', int(new_val))


class RootSeqRbanaRampgenUser4ControlInit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.user4.control.init'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.control.init.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.control.init.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.control.init.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.control.init.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.control.init.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.control.init.lsb', int(new_val))


class RootSeqRbanaRampgenUser4ControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.user4.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.control.start.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.control.start.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.control.start.lsb', int(new_val))


class RootSeqRbanaRampgenUser4ControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.user4.control.stop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.control.stop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.control.stop.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.control.stop.lsb', int(new_val))


class RootSeqRbanaRampgenUser4ControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.user4.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.control.abort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.control.abort.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.control.abort.lsb', int(new_val))


class RootSeqRbanaRampgenUser4Control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.user4.control'
        self.abort = RootSeqRbanaRampgenUser4ControlAbort(self._context)
        self.stop = RootSeqRbanaRampgenUser4ControlStop(self._context)
        self.start = RootSeqRbanaRampgenUser4ControlStart(self._context)
        self.init = RootSeqRbanaRampgenUser4ControlInit(self._context)
        self.mode = RootSeqRbanaRampgenUser4ControlMode(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.control.regaddr', int(new_val))


class RootSeqRbanaRampgenUser4Increment(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.user4.increment'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.increment.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.increment.regaddr', int(new_val))


class RootSeqRbanaRampgenUser4Limit_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.user4.limit_pos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.user4.limit_pos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.user4.limit_pos.regaddr', int(new_val))


class RootSeqRbanaRampgenUser4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.user4'
        self.limit_pos = RootSeqRbanaRampgenUser4Limit_pos(self._context)
        self.increment = RootSeqRbanaRampgenUser4Increment(self._context)
        self.control = RootSeqRbanaRampgenUser4Control(self._context)
        self.limit_neg = RootSeqRbanaRampgenUser4Limit_neg(self._context)
        self.value = RootSeqRbanaRampgenUser4Value(self._context)
        self.status = RootSeqRbanaRampgenUser4Status(self._context)
        self.out = RootSeqRbanaRampgenUser4Out(self._context)


class RootSeqRbanaRampgenPositionxOut(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positionx.out'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.out.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.out.regaddr', int(new_val))


class RootSeqRbanaRampgenPositionxStatusReachedlowerlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positionx.status.reachedlowerlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.status.reachedlowerlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.status.reachedlowerlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.status.reachedlowerlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.status.reachedlowerlimit.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.status.reachedlowerlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.status.reachedlowerlimit.lsb', int(new_val))


class RootSeqRbanaRampgenPositionxStatusReachedregularend(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positionx.status.reachedregularend'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.status.reachedregularend.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.status.reachedregularend.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.status.reachedregularend.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.status.reachedregularend.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.status.reachedregularend.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.status.reachedregularend.lsb', int(new_val))


class RootSeqRbanaRampgenPositionxStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positionx.status.busy'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.status.busy.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.status.busy.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.status.busy.lsb', int(new_val))


class RootSeqRbanaRampgenPositionxStatusReachedupperlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positionx.status.reachedupperlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.status.reachedupperlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.status.reachedupperlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.status.reachedupperlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.status.reachedupperlimit.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.status.reachedupperlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.status.reachedupperlimit.lsb', int(new_val))


class RootSeqRbanaRampgenPositionxStatusCountup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positionx.status.countup'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.status.countup.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.status.countup.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.status.countup.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.status.countup.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.status.countup.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.status.countup.lsb', int(new_val))


class RootSeqRbanaRampgenPositionxStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positionx.status'
        self.countup = RootSeqRbanaRampgenPositionxStatusCountup(self._context)
        self.reachedupperlimit = RootSeqRbanaRampgenPositionxStatusReachedupperlimit(self._context)
        self.busy = RootSeqRbanaRampgenPositionxStatusBusy(self._context)
        self.reachedregularend = RootSeqRbanaRampgenPositionxStatusReachedregularend(self._context)
        self.reachedlowerlimit = RootSeqRbanaRampgenPositionxStatusReachedlowerlimit(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.status.regaddr', int(new_val))


class RootSeqRbanaRampgenPositionxValue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positionx.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.value.regaddr', int(new_val))


class RootSeqRbanaRampgenPositionxLimit_neg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positionx.limit_neg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.limit_neg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.limit_neg.regaddr', int(new_val))


class RootSeqRbanaRampgenPositionxControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positionx.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.control.mode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.control.mode.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.control.mode.lsb', int(new_val))


class RootSeqRbanaRampgenPositionxControlInit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positionx.control.init'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.control.init.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.control.init.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.control.init.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.control.init.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.control.init.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.control.init.lsb', int(new_val))


class RootSeqRbanaRampgenPositionxControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positionx.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.control.start.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.control.start.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.control.start.lsb', int(new_val))


class RootSeqRbanaRampgenPositionxControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positionx.control.stop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.control.stop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.control.stop.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.control.stop.lsb', int(new_val))


class RootSeqRbanaRampgenPositionxControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positionx.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.control.abort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.control.abort.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.control.abort.lsb', int(new_val))


class RootSeqRbanaRampgenPositionxControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positionx.control'
        self.abort = RootSeqRbanaRampgenPositionxControlAbort(self._context)
        self.stop = RootSeqRbanaRampgenPositionxControlStop(self._context)
        self.start = RootSeqRbanaRampgenPositionxControlStart(self._context)
        self.init = RootSeqRbanaRampgenPositionxControlInit(self._context)
        self.mode = RootSeqRbanaRampgenPositionxControlMode(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.control.regaddr', int(new_val))


class RootSeqRbanaRampgenPositionxIncrement(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positionx.increment'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.increment.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.increment.regaddr', int(new_val))


class RootSeqRbanaRampgenPositionxLimit_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positionx.limit_pos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positionx.limit_pos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positionx.limit_pos.regaddr', int(new_val))


class RootSeqRbanaRampgenPositionx(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positionx'
        self.limit_pos = RootSeqRbanaRampgenPositionxLimit_pos(self._context)
        self.increment = RootSeqRbanaRampgenPositionxIncrement(self._context)
        self.control = RootSeqRbanaRampgenPositionxControl(self._context)
        self.limit_neg = RootSeqRbanaRampgenPositionxLimit_neg(self._context)
        self.value = RootSeqRbanaRampgenPositionxValue(self._context)
        self.status = RootSeqRbanaRampgenPositionxStatus(self._context)
        self.out = RootSeqRbanaRampgenPositionxOut(self._context)


class RootSeqRbanaRampgenAlternatezOut(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.alternatez.out'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.out.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.out.regaddr', int(new_val))


class RootSeqRbanaRampgenAlternatezStatusReachedlowerlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.alternatez.status.reachedlowerlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.status.reachedlowerlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.status.reachedlowerlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.status.reachedlowerlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.status.reachedlowerlimit.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.status.reachedlowerlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.status.reachedlowerlimit.lsb', int(new_val))


class RootSeqRbanaRampgenAlternatezStatusReachedregularend(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.alternatez.status.reachedregularend'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.status.reachedregularend.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.status.reachedregularend.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.status.reachedregularend.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.status.reachedregularend.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.status.reachedregularend.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.status.reachedregularend.lsb', int(new_val))


class RootSeqRbanaRampgenAlternatezStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.alternatez.status.busy'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.status.busy.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.status.busy.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.status.busy.lsb', int(new_val))


class RootSeqRbanaRampgenAlternatezStatusReachedupperlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.alternatez.status.reachedupperlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.status.reachedupperlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.status.reachedupperlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.status.reachedupperlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.status.reachedupperlimit.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.status.reachedupperlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.status.reachedupperlimit.lsb', int(new_val))


class RootSeqRbanaRampgenAlternatezStatusCountup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.alternatez.status.countup'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.status.countup.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.status.countup.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.status.countup.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.status.countup.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.status.countup.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.status.countup.lsb', int(new_val))


class RootSeqRbanaRampgenAlternatezStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.alternatez.status'
        self.countup = RootSeqRbanaRampgenAlternatezStatusCountup(self._context)
        self.reachedupperlimit = RootSeqRbanaRampgenAlternatezStatusReachedupperlimit(self._context)
        self.busy = RootSeqRbanaRampgenAlternatezStatusBusy(self._context)
        self.reachedregularend = RootSeqRbanaRampgenAlternatezStatusReachedregularend(self._context)
        self.reachedlowerlimit = RootSeqRbanaRampgenAlternatezStatusReachedlowerlimit(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.status.regaddr', int(new_val))


class RootSeqRbanaRampgenAlternatezValue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.alternatez.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.value.regaddr', int(new_val))


class RootSeqRbanaRampgenAlternatezLimit_neg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.alternatez.limit_neg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.limit_neg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.limit_neg.regaddr', int(new_val))


class RootSeqRbanaRampgenAlternatezControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.alternatez.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.control.mode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.control.mode.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.control.mode.lsb', int(new_val))


class RootSeqRbanaRampgenAlternatezControlInit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.alternatez.control.init'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.control.init.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.control.init.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.control.init.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.control.init.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.control.init.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.control.init.lsb', int(new_val))


class RootSeqRbanaRampgenAlternatezControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.alternatez.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.control.start.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.control.start.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.control.start.lsb', int(new_val))


class RootSeqRbanaRampgenAlternatezControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.alternatez.control.stop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.control.stop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.control.stop.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.control.stop.lsb', int(new_val))


class RootSeqRbanaRampgenAlternatezControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.alternatez.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.control.abort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.control.abort.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.control.abort.lsb', int(new_val))


class RootSeqRbanaRampgenAlternatezControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.alternatez.control'
        self.abort = RootSeqRbanaRampgenAlternatezControlAbort(self._context)
        self.stop = RootSeqRbanaRampgenAlternatezControlStop(self._context)
        self.start = RootSeqRbanaRampgenAlternatezControlStart(self._context)
        self.init = RootSeqRbanaRampgenAlternatezControlInit(self._context)
        self.mode = RootSeqRbanaRampgenAlternatezControlMode(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.control.regaddr', int(new_val))


class RootSeqRbanaRampgenAlternatezIncrement(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.alternatez.increment'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.increment.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.increment.regaddr', int(new_val))


class RootSeqRbanaRampgenAlternatezLimit_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.alternatez.limit_pos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.alternatez.limit_pos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.alternatez.limit_pos.regaddr', int(new_val))


class RootSeqRbanaRampgenAlternatez(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.alternatez'
        self.limit_pos = RootSeqRbanaRampgenAlternatezLimit_pos(self._context)
        self.increment = RootSeqRbanaRampgenAlternatezIncrement(self._context)
        self.control = RootSeqRbanaRampgenAlternatezControl(self._context)
        self.limit_neg = RootSeqRbanaRampgenAlternatezLimit_neg(self._context)
        self.value = RootSeqRbanaRampgenAlternatezValue(self._context)
        self.status = RootSeqRbanaRampgenAlternatezStatus(self._context)
        self.out = RootSeqRbanaRampgenAlternatezOut(self._context)


class RootSeqRbanaRampgenPositionyOut(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positiony.out'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.out.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.out.regaddr', int(new_val))


class RootSeqRbanaRampgenPositionyStatusReachedlowerlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positiony.status.reachedlowerlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.status.reachedlowerlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.status.reachedlowerlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.status.reachedlowerlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.status.reachedlowerlimit.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.status.reachedlowerlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.status.reachedlowerlimit.lsb', int(new_val))


class RootSeqRbanaRampgenPositionyStatusReachedregularend(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positiony.status.reachedregularend'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.status.reachedregularend.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.status.reachedregularend.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.status.reachedregularend.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.status.reachedregularend.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.status.reachedregularend.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.status.reachedregularend.lsb', int(new_val))


class RootSeqRbanaRampgenPositionyStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positiony.status.busy'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.status.busy.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.status.busy.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.status.busy.lsb', int(new_val))


class RootSeqRbanaRampgenPositionyStatusReachedupperlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positiony.status.reachedupperlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.status.reachedupperlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.status.reachedupperlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.status.reachedupperlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.status.reachedupperlimit.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.status.reachedupperlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.status.reachedupperlimit.lsb', int(new_val))


class RootSeqRbanaRampgenPositionyStatusCountup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positiony.status.countup'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.status.countup.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.status.countup.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.status.countup.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.status.countup.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.status.countup.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.status.countup.lsb', int(new_val))


class RootSeqRbanaRampgenPositionyStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positiony.status'
        self.countup = RootSeqRbanaRampgenPositionyStatusCountup(self._context)
        self.reachedupperlimit = RootSeqRbanaRampgenPositionyStatusReachedupperlimit(self._context)
        self.busy = RootSeqRbanaRampgenPositionyStatusBusy(self._context)
        self.reachedregularend = RootSeqRbanaRampgenPositionyStatusReachedregularend(self._context)
        self.reachedlowerlimit = RootSeqRbanaRampgenPositionyStatusReachedlowerlimit(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.status.regaddr', int(new_val))


class RootSeqRbanaRampgenPositionyValue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positiony.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.value.regaddr', int(new_val))


class RootSeqRbanaRampgenPositionyLimit_neg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positiony.limit_neg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.limit_neg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.limit_neg.regaddr', int(new_val))


class RootSeqRbanaRampgenPositionyControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positiony.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.control.mode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.control.mode.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.control.mode.lsb', int(new_val))


class RootSeqRbanaRampgenPositionyControlInit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positiony.control.init'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.control.init.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.control.init.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.control.init.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.control.init.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.control.init.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.control.init.lsb', int(new_val))


class RootSeqRbanaRampgenPositionyControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positiony.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.control.start.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.control.start.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.control.start.lsb', int(new_val))


class RootSeqRbanaRampgenPositionyControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positiony.control.stop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.control.stop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.control.stop.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.control.stop.lsb', int(new_val))


class RootSeqRbanaRampgenPositionyControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positiony.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.control.abort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.control.abort.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.control.abort.lsb', int(new_val))


class RootSeqRbanaRampgenPositionyControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positiony.control'
        self.abort = RootSeqRbanaRampgenPositionyControlAbort(self._context)
        self.stop = RootSeqRbanaRampgenPositionyControlStop(self._context)
        self.start = RootSeqRbanaRampgenPositionyControlStart(self._context)
        self.init = RootSeqRbanaRampgenPositionyControlInit(self._context)
        self.mode = RootSeqRbanaRampgenPositionyControlMode(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.control.regaddr', int(new_val))


class RootSeqRbanaRampgenPositionyIncrement(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positiony.increment'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.increment.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.increment.regaddr', int(new_val))


class RootSeqRbanaRampgenPositionyLimit_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positiony.limit_pos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.positiony.limit_pos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.positiony.limit_pos.regaddr', int(new_val))


class RootSeqRbanaRampgenPositiony(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.positiony'
        self.limit_pos = RootSeqRbanaRampgenPositionyLimit_pos(self._context)
        self.increment = RootSeqRbanaRampgenPositionyIncrement(self._context)
        self.control = RootSeqRbanaRampgenPositionyControl(self._context)
        self.limit_neg = RootSeqRbanaRampgenPositionyLimit_neg(self._context)
        self.value = RootSeqRbanaRampgenPositionyValue(self._context)
        self.status = RootSeqRbanaRampgenPositionyStatus(self._context)
        self.out = RootSeqRbanaRampgenPositionyOut(self._context)


class RootSeqRbanaRampgenPlanezOut(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.planez.out'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.out.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.out.regaddr', int(new_val))


class RootSeqRbanaRampgenPlanezStatusReachedlowerlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.planez.status.reachedlowerlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.status.reachedlowerlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.status.reachedlowerlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.status.reachedlowerlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.status.reachedlowerlimit.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.status.reachedlowerlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.status.reachedlowerlimit.lsb', int(new_val))


class RootSeqRbanaRampgenPlanezStatusReachedregularend(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.planez.status.reachedregularend'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.status.reachedregularend.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.status.reachedregularend.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.status.reachedregularend.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.status.reachedregularend.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.status.reachedregularend.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.status.reachedregularend.lsb', int(new_val))


class RootSeqRbanaRampgenPlanezStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.planez.status.busy'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.status.busy.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.status.busy.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.status.busy.lsb', int(new_val))


class RootSeqRbanaRampgenPlanezStatusReachedupperlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.planez.status.reachedupperlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.status.reachedupperlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.status.reachedupperlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.status.reachedupperlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.status.reachedupperlimit.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.status.reachedupperlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.status.reachedupperlimit.lsb', int(new_val))


class RootSeqRbanaRampgenPlanezStatusCountup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.planez.status.countup'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.status.countup.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.status.countup.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.status.countup.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.status.countup.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.status.countup.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.status.countup.lsb', int(new_val))


class RootSeqRbanaRampgenPlanezStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.planez.status'
        self.countup = RootSeqRbanaRampgenPlanezStatusCountup(self._context)
        self.reachedupperlimit = RootSeqRbanaRampgenPlanezStatusReachedupperlimit(self._context)
        self.busy = RootSeqRbanaRampgenPlanezStatusBusy(self._context)
        self.reachedregularend = RootSeqRbanaRampgenPlanezStatusReachedregularend(self._context)
        self.reachedlowerlimit = RootSeqRbanaRampgenPlanezStatusReachedlowerlimit(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.status.regaddr', int(new_val))


class RootSeqRbanaRampgenPlanezValue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.planez.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.value.regaddr', int(new_val))


class RootSeqRbanaRampgenPlanezLimit_neg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.planez.limit_neg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.limit_neg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.limit_neg.regaddr', int(new_val))


class RootSeqRbanaRampgenPlanezControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.planez.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.control.mode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.control.mode.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.control.mode.lsb', int(new_val))


class RootSeqRbanaRampgenPlanezControlInit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.planez.control.init'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.control.init.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.control.init.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.control.init.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.control.init.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.control.init.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.control.init.lsb', int(new_val))


class RootSeqRbanaRampgenPlanezControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.planez.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.control.start.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.control.start.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.control.start.lsb', int(new_val))


class RootSeqRbanaRampgenPlanezControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.planez.control.stop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.control.stop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.control.stop.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.control.stop.lsb', int(new_val))


class RootSeqRbanaRampgenPlanezControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.planez.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.control.abort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.control.abort.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.control.abort.lsb', int(new_val))


class RootSeqRbanaRampgenPlanezControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.planez.control'
        self.abort = RootSeqRbanaRampgenPlanezControlAbort(self._context)
        self.stop = RootSeqRbanaRampgenPlanezControlStop(self._context)
        self.start = RootSeqRbanaRampgenPlanezControlStart(self._context)
        self.init = RootSeqRbanaRampgenPlanezControlInit(self._context)
        self.mode = RootSeqRbanaRampgenPlanezControlMode(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.control.regaddr', int(new_val))


class RootSeqRbanaRampgenPlanezIncrement(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.planez.increment'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.increment.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.increment.regaddr', int(new_val))


class RootSeqRbanaRampgenPlanezLimit_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.planez.limit_pos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.planez.limit_pos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.planez.limit_pos.regaddr', int(new_val))


class RootSeqRbanaRampgenPlanez(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.planez'
        self.limit_pos = RootSeqRbanaRampgenPlanezLimit_pos(self._context)
        self.increment = RootSeqRbanaRampgenPlanezIncrement(self._context)
        self.control = RootSeqRbanaRampgenPlanezControl(self._context)
        self.limit_neg = RootSeqRbanaRampgenPlanezLimit_neg(self._context)
        self.value = RootSeqRbanaRampgenPlanezValue(self._context)
        self.status = RootSeqRbanaRampgenPlanezStatus(self._context)
        self.out = RootSeqRbanaRampgenPlanezOut(self._context)


class RootSeqRbanaRampgenMaxzOut(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.maxz.out'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.out.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.out.regaddr', int(new_val))


class RootSeqRbanaRampgenMaxzStatusReachedlowerlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.maxz.status.reachedlowerlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.status.reachedlowerlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.status.reachedlowerlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.status.reachedlowerlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.status.reachedlowerlimit.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.status.reachedlowerlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.status.reachedlowerlimit.lsb', int(new_val))


class RootSeqRbanaRampgenMaxzStatusReachedregularend(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.maxz.status.reachedregularend'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.status.reachedregularend.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.status.reachedregularend.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.status.reachedregularend.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.status.reachedregularend.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.status.reachedregularend.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.status.reachedregularend.lsb', int(new_val))


class RootSeqRbanaRampgenMaxzStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.maxz.status.busy'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.status.busy.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.status.busy.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.status.busy.lsb', int(new_val))


class RootSeqRbanaRampgenMaxzStatusReachedupperlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.maxz.status.reachedupperlimit'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.status.reachedupperlimit.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.status.reachedupperlimit.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.status.reachedupperlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.status.reachedupperlimit.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.status.reachedupperlimit.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.status.reachedupperlimit.lsb', int(new_val))


class RootSeqRbanaRampgenMaxzStatusCountup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.maxz.status.countup'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.status.countup.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.status.countup.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.status.countup.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.status.countup.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.status.countup.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.status.countup.lsb', int(new_val))


class RootSeqRbanaRampgenMaxzStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.maxz.status'
        self.countup = RootSeqRbanaRampgenMaxzStatusCountup(self._context)
        self.reachedupperlimit = RootSeqRbanaRampgenMaxzStatusReachedupperlimit(self._context)
        self.busy = RootSeqRbanaRampgenMaxzStatusBusy(self._context)
        self.reachedregularend = RootSeqRbanaRampgenMaxzStatusReachedregularend(self._context)
        self.reachedlowerlimit = RootSeqRbanaRampgenMaxzStatusReachedlowerlimit(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.status.regaddr', int(new_val))


class RootSeqRbanaRampgenMaxzValue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.maxz.value'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.value.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.value.regaddr', int(new_val))


class RootSeqRbanaRampgenMaxzLimit_neg(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.maxz.limit_neg'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.limit_neg.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.limit_neg.regaddr', int(new_val))


class RootSeqRbanaRampgenMaxzControlMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.maxz.control.mode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.control.mode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.control.mode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.control.mode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.control.mode.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.control.mode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.control.mode.lsb', int(new_val))


class RootSeqRbanaRampgenMaxzControlInit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.maxz.control.init'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.control.init.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.control.init.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.control.init.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.control.init.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.control.init.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.control.init.lsb', int(new_val))


class RootSeqRbanaRampgenMaxzControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.maxz.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.control.start.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.control.start.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.control.start.lsb', int(new_val))


class RootSeqRbanaRampgenMaxzControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.maxz.control.stop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.control.stop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.control.stop.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.control.stop.lsb', int(new_val))


class RootSeqRbanaRampgenMaxzControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.maxz.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.control.abort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.control.abort.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.control.abort.lsb', int(new_val))


class RootSeqRbanaRampgenMaxzControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.maxz.control'
        self.abort = RootSeqRbanaRampgenMaxzControlAbort(self._context)
        self.stop = RootSeqRbanaRampgenMaxzControlStop(self._context)
        self.start = RootSeqRbanaRampgenMaxzControlStart(self._context)
        self.init = RootSeqRbanaRampgenMaxzControlInit(self._context)
        self.mode = RootSeqRbanaRampgenMaxzControlMode(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.control.regaddr', int(new_val))


class RootSeqRbanaRampgenMaxzIncrement(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.maxz.increment'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.increment.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.increment.regaddr', int(new_val))


class RootSeqRbanaRampgenMaxzLimit_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.maxz.limit_pos'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.rampgen.maxz.limit_pos.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.rampgen.maxz.limit_pos.regaddr', int(new_val))


class RootSeqRbanaRampgenMaxz(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen.maxz'
        self.limit_pos = RootSeqRbanaRampgenMaxzLimit_pos(self._context)
        self.increment = RootSeqRbanaRampgenMaxzIncrement(self._context)
        self.control = RootSeqRbanaRampgenMaxzControl(self._context)
        self.limit_neg = RootSeqRbanaRampgenMaxzLimit_neg(self._context)
        self.value = RootSeqRbanaRampgenMaxzValue(self._context)
        self.status = RootSeqRbanaRampgenMaxzStatus(self._context)
        self.out = RootSeqRbanaRampgenMaxzOut(self._context)


class RootSeqRbanaRampgen(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.rampgen'
        self.maxz = RootSeqRbanaRampgenMaxz(self._context)
        self.planez = RootSeqRbanaRampgenPlanez(self._context)
        self.positiony = RootSeqRbanaRampgenPositiony(self._context)
        self.alternatez = RootSeqRbanaRampgenAlternatez(self._context)
        self.positionx = RootSeqRbanaRampgenPositionx(self._context)
        self.user4 = RootSeqRbanaRampgenUser4(self._context)
        self.tipvoltage = RootSeqRbanaRampgenTipvoltage(self._context)
        self.approach = RootSeqRbanaRampgenApproach(self._context)
        self.test = RootSeqRbanaRampgenTest(self._context)


class RootSeqRbanaMemorysignalgenSgleOut(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.memorysignalgen.sgle.out'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.out.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.out.regaddr', int(new_val))


class RootSeqRbanaMemorysignalgenSgleSamplecnt(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.memorysignalgen.sgle.samplecnt'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.samplecnt.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.samplecnt.regaddr', int(new_val))


class RootSeqRbanaMemorysignalgenSgleSampleno(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.memorysignalgen.sgle.sampleno'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.sampleno.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.sampleno.regaddr', int(new_val))


class RootSeqRbanaMemorysignalgenSgleStatusUnderrun(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.memorysignalgen.sgle.status.underrun'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.status.underrun.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.status.underrun.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.status.underrun.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.status.underrun.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.status.underrun.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.status.underrun.lsb', int(new_val))


class RootSeqRbanaMemorysignalgenSgleStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.memorysignalgen.sgle.status.busy'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.status.busy.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.status.busy.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.status.busy.lsb', int(new_val))


class RootSeqRbanaMemorysignalgenSgleStatusEndreached(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.memorysignalgen.sgle.status.endreached'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.status.endreached.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.status.endreached.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.status.endreached.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.status.endreached.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.status.endreached.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.status.endreached.lsb', int(new_val))


class RootSeqRbanaMemorysignalgenSgleStatusFifolevel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.memorysignalgen.sgle.status.fifolevel'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.status.fifolevel.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.status.fifolevel.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.status.fifolevel.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.status.fifolevel.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.status.fifolevel.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.status.fifolevel.lsb', int(new_val))


class RootSeqRbanaMemorysignalgenSgleStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.memorysignalgen.sgle.status'
        self.fifolevel = RootSeqRbanaMemorysignalgenSgleStatusFifolevel(self._context)
        self.endreached = RootSeqRbanaMemorysignalgenSgleStatusEndreached(self._context)
        self.busy = RootSeqRbanaMemorysignalgenSgleStatusBusy(self._context)
        self.underrun = RootSeqRbanaMemorysignalgenSgleStatusUnderrun(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.status.regaddr', int(new_val))


class RootSeqRbanaMemorysignalgenSgleRvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.memorysignalgen.sgle.rvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.rvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.rvalue.regaddr', int(new_val))


class RootSeqRbanaMemorysignalgenSgleControlOutaddress(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.memorysignalgen.sgle.control.outaddress'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.control.outaddress.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.control.outaddress.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.control.outaddress.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.control.outaddress.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.control.outaddress.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.control.outaddress.lsb', int(new_val))


class RootSeqRbanaMemorysignalgenSgleControlClear(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.memorysignalgen.sgle.control.clear'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.control.clear.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.control.clear.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.control.clear.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.control.clear.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.control.clear.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.control.clear.lsb', int(new_val))


class RootSeqRbanaMemorysignalgenSgleControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.memorysignalgen.sgle.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.control.start.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.control.start.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.control.start.lsb', int(new_val))


class RootSeqRbanaMemorysignalgenSgleControlEnable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.memorysignalgen.sgle.control.enable'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.control.enable.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.control.enable.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.control.enable.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.control.enable.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.control.enable.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.control.enable.lsb', int(new_val))


class RootSeqRbanaMemorysignalgenSgleControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.memorysignalgen.sgle.control.stop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.control.stop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.control.stop.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.control.stop.lsb', int(new_val))


class RootSeqRbanaMemorysignalgenSgleControlLinear(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.memorysignalgen.sgle.control.linear'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.control.linear.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.control.linear.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.control.linear.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.control.linear.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.control.linear.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.control.linear.lsb', int(new_val))


class RootSeqRbanaMemorysignalgenSgleControlJoin(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.memorysignalgen.sgle.control.join'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.control.join.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.control.join.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.control.join.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.control.join.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.control.join.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.control.join.lsb', int(new_val))


class RootSeqRbanaMemorysignalgenSgleControlAddress(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.memorysignalgen.sgle.control.address'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.control.address.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.control.address.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.control.address.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.control.address.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.control.address.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.control.address.lsb', int(new_val))


class RootSeqRbanaMemorysignalgenSgleControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.memorysignalgen.sgle.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.control.abort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.control.abort.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.control.abort.lsb', int(new_val))


class RootSeqRbanaMemorysignalgenSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.memorysignalgen.sgle.control'
        self.abort = RootSeqRbanaMemorysignalgenSgleControlAbort(self._context)
        self.address = RootSeqRbanaMemorysignalgenSgleControlAddress(self._context)
        self.join = RootSeqRbanaMemorysignalgenSgleControlJoin(self._context)
        self.linear = RootSeqRbanaMemorysignalgenSgleControlLinear(self._context)
        self.stop = RootSeqRbanaMemorysignalgenSgleControlStop(self._context)
        self.enable = RootSeqRbanaMemorysignalgenSgleControlEnable(self._context)
        self.start = RootSeqRbanaMemorysignalgenSgleControlStart(self._context)
        self.clear = RootSeqRbanaMemorysignalgenSgleControlClear(self._context)
        self.outaddress = RootSeqRbanaMemorysignalgenSgleControlOutaddress(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.control.regaddr', int(new_val))


class RootSeqRbanaMemorysignalgenSgleIncrement(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.memorysignalgen.sgle.increment'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.increment.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.increment.regaddr', int(new_val))


class RootSeqRbanaMemorysignalgenSgleWvalue(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.memorysignalgen.sgle.wvalue'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.memorysignalgen.sgle.wvalue.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.memorysignalgen.sgle.wvalue.regaddr', int(new_val))


class RootSeqRbanaMemorysignalgenSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.memorysignalgen.sgle'
        self.wvalue = RootSeqRbanaMemorysignalgenSgleWvalue(self._context)
        self.increment = RootSeqRbanaMemorysignalgenSgleIncrement(self._context)
        self.control = RootSeqRbanaMemorysignalgenSgleControl(self._context)
        self.rvalue = RootSeqRbanaMemorysignalgenSgleRvalue(self._context)
        self.status = RootSeqRbanaMemorysignalgenSgleStatus(self._context)
        self.sampleno = RootSeqRbanaMemorysignalgenSgleSampleno(self._context)
        self.samplecnt = RootSeqRbanaMemorysignalgenSgleSamplecnt(self._context)
        self.out = RootSeqRbanaMemorysignalgenSgleOut(self._context)


class RootSeqRbanaMemorysignalgen(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.memorysignalgen'
        self.sgle = RootSeqRbanaMemorysignalgenSgle(self._context)


class RootSeqRbanaInhiresCh8Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch8.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch8.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch8.cccoefy4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh8Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch8.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch8.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch8.cccoefy0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh8Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch8.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch8.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch8.cccoefs0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh8Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch8.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch8.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch8.cccoefx3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh8Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch8.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch8.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch8.cccoefx4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh8Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch8.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch8.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch8.cccoefs4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh8Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch8.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch8.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch8.cccoefz3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh8Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch8.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch8.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch8.cccoefz4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh8Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch8.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch8.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch8.filterval.regaddr', int(new_val))


class RootSeqRbanaInhiresCh8Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch8.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch8.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch8.cccoefx0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh8Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch8.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch8.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch8.gain.regaddr', int(new_val))


class RootSeqRbanaInhiresCh8Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch8.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch8.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch8.inputoffset.regaddr', int(new_val))


class RootSeqRbanaInhiresCh8Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch8.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch8.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch8.cccoefs1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh8Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch8.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch8.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch8.cccoefz0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh8Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch8.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch8.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch8.offset.regaddr', int(new_val))


class RootSeqRbanaInhiresCh8Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch8.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch8.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch8.cccoefx1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh8Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch8.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch8.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch8.cccoefy1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh8Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch8.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch8.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch8.cccoefy2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh8Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch8.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch8.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch8.cccoefz2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh8Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch8.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch8.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch8.cccoefx2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh8Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch8.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch8.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch8.cccoefy3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh8Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch8.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch8.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch8.currentinval.regaddr', int(new_val))


class RootSeqRbanaInhiresCh8Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch8.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch8.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch8.cccoefs3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh8Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch8.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch8.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch8.cccoefz1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh8Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch8.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch8.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch8.cccoefs2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh8(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch8'
        self.cccoefs2 = RootSeqRbanaInhiresCh8Cccoefs2(self._context)
        self.cccoefz1 = RootSeqRbanaInhiresCh8Cccoefz1(self._context)
        self.cccoefs3 = RootSeqRbanaInhiresCh8Cccoefs3(self._context)
        self.currentinval = RootSeqRbanaInhiresCh8Currentinval(self._context)
        self.cccoefy3 = RootSeqRbanaInhiresCh8Cccoefy3(self._context)
        self.cccoefx2 = RootSeqRbanaInhiresCh8Cccoefx2(self._context)
        self.cccoefz2 = RootSeqRbanaInhiresCh8Cccoefz2(self._context)
        self.cccoefy2 = RootSeqRbanaInhiresCh8Cccoefy2(self._context)
        self.cccoefy1 = RootSeqRbanaInhiresCh8Cccoefy1(self._context)
        self.cccoefx1 = RootSeqRbanaInhiresCh8Cccoefx1(self._context)
        self.offset = RootSeqRbanaInhiresCh8Offset(self._context)
        self.cccoefz0 = RootSeqRbanaInhiresCh8Cccoefz0(self._context)
        self.cccoefs1 = RootSeqRbanaInhiresCh8Cccoefs1(self._context)
        self.inputoffset = RootSeqRbanaInhiresCh8Inputoffset(self._context)
        self.gain = RootSeqRbanaInhiresCh8Gain(self._context)
        self.cccoefx0 = RootSeqRbanaInhiresCh8Cccoefx0(self._context)
        self.filterval = RootSeqRbanaInhiresCh8Filterval(self._context)
        self.cccoefz4 = RootSeqRbanaInhiresCh8Cccoefz4(self._context)
        self.cccoefz3 = RootSeqRbanaInhiresCh8Cccoefz3(self._context)
        self.cccoefs4 = RootSeqRbanaInhiresCh8Cccoefs4(self._context)
        self.cccoefx4 = RootSeqRbanaInhiresCh8Cccoefx4(self._context)
        self.cccoefx3 = RootSeqRbanaInhiresCh8Cccoefx3(self._context)
        self.cccoefs0 = RootSeqRbanaInhiresCh8Cccoefs0(self._context)
        self.cccoefy0 = RootSeqRbanaInhiresCh8Cccoefy0(self._context)
        self.cccoefy4 = RootSeqRbanaInhiresCh8Cccoefy4(self._context)


class RootSeqRbanaInhiresCh10Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch10.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch10.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch10.cccoefy4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh10Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch10.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch10.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch10.cccoefy0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh10Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch10.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch10.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch10.cccoefs0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh10Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch10.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch10.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch10.cccoefx3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh10Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch10.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch10.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch10.cccoefx4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh10Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch10.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch10.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch10.cccoefs4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh10Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch10.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch10.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch10.cccoefz3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh10Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch10.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch10.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch10.cccoefz4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh10Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch10.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch10.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch10.filterval.regaddr', int(new_val))


class RootSeqRbanaInhiresCh10Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch10.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch10.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch10.cccoefx0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh10Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch10.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch10.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch10.gain.regaddr', int(new_val))


class RootSeqRbanaInhiresCh10Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch10.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch10.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch10.inputoffset.regaddr', int(new_val))


class RootSeqRbanaInhiresCh10Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch10.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch10.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch10.cccoefs1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh10Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch10.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch10.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch10.cccoefz0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh10Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch10.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch10.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch10.offset.regaddr', int(new_val))


class RootSeqRbanaInhiresCh10Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch10.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch10.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch10.cccoefx1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh10Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch10.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch10.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch10.cccoefy1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh10Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch10.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch10.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch10.cccoefy2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh10Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch10.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch10.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch10.cccoefz2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh10Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch10.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch10.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch10.cccoefx2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh10Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch10.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch10.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch10.cccoefy3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh10Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch10.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch10.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch10.currentinval.regaddr', int(new_val))


class RootSeqRbanaInhiresCh10Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch10.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch10.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch10.cccoefs3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh10Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch10.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch10.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch10.cccoefz1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh10Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch10.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch10.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch10.cccoefs2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh10(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch10'
        self.cccoefs2 = RootSeqRbanaInhiresCh10Cccoefs2(self._context)
        self.cccoefz1 = RootSeqRbanaInhiresCh10Cccoefz1(self._context)
        self.cccoefs3 = RootSeqRbanaInhiresCh10Cccoefs3(self._context)
        self.currentinval = RootSeqRbanaInhiresCh10Currentinval(self._context)
        self.cccoefy3 = RootSeqRbanaInhiresCh10Cccoefy3(self._context)
        self.cccoefx2 = RootSeqRbanaInhiresCh10Cccoefx2(self._context)
        self.cccoefz2 = RootSeqRbanaInhiresCh10Cccoefz2(self._context)
        self.cccoefy2 = RootSeqRbanaInhiresCh10Cccoefy2(self._context)
        self.cccoefy1 = RootSeqRbanaInhiresCh10Cccoefy1(self._context)
        self.cccoefx1 = RootSeqRbanaInhiresCh10Cccoefx1(self._context)
        self.offset = RootSeqRbanaInhiresCh10Offset(self._context)
        self.cccoefz0 = RootSeqRbanaInhiresCh10Cccoefz0(self._context)
        self.cccoefs1 = RootSeqRbanaInhiresCh10Cccoefs1(self._context)
        self.inputoffset = RootSeqRbanaInhiresCh10Inputoffset(self._context)
        self.gain = RootSeqRbanaInhiresCh10Gain(self._context)
        self.cccoefx0 = RootSeqRbanaInhiresCh10Cccoefx0(self._context)
        self.filterval = RootSeqRbanaInhiresCh10Filterval(self._context)
        self.cccoefz4 = RootSeqRbanaInhiresCh10Cccoefz4(self._context)
        self.cccoefz3 = RootSeqRbanaInhiresCh10Cccoefz3(self._context)
        self.cccoefs4 = RootSeqRbanaInhiresCh10Cccoefs4(self._context)
        self.cccoefx4 = RootSeqRbanaInhiresCh10Cccoefx4(self._context)
        self.cccoefx3 = RootSeqRbanaInhiresCh10Cccoefx3(self._context)
        self.cccoefs0 = RootSeqRbanaInhiresCh10Cccoefs0(self._context)
        self.cccoefy0 = RootSeqRbanaInhiresCh10Cccoefy0(self._context)
        self.cccoefy4 = RootSeqRbanaInhiresCh10Cccoefy4(self._context)


class RootSeqRbanaInhiresCh9Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch9.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch9.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch9.cccoefy4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh9Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch9.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch9.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch9.cccoefy0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh9Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch9.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch9.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch9.cccoefs0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh9Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch9.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch9.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch9.cccoefx3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh9Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch9.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch9.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch9.cccoefx4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh9Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch9.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch9.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch9.cccoefs4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh9Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch9.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch9.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch9.cccoefz3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh9Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch9.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch9.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch9.cccoefz4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh9Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch9.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch9.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch9.filterval.regaddr', int(new_val))


class RootSeqRbanaInhiresCh9Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch9.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch9.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch9.cccoefx0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh9Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch9.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch9.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch9.gain.regaddr', int(new_val))


class RootSeqRbanaInhiresCh9Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch9.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch9.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch9.inputoffset.regaddr', int(new_val))


class RootSeqRbanaInhiresCh9Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch9.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch9.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch9.cccoefs1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh9Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch9.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch9.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch9.cccoefz0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh9Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch9.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch9.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch9.offset.regaddr', int(new_val))


class RootSeqRbanaInhiresCh9Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch9.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch9.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch9.cccoefx1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh9Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch9.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch9.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch9.cccoefy1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh9Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch9.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch9.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch9.cccoefy2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh9Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch9.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch9.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch9.cccoefz2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh9Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch9.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch9.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch9.cccoefx2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh9Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch9.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch9.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch9.cccoefy3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh9Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch9.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch9.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch9.currentinval.regaddr', int(new_val))


class RootSeqRbanaInhiresCh9Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch9.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch9.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch9.cccoefs3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh9Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch9.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch9.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch9.cccoefz1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh9Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch9.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch9.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch9.cccoefs2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh9(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch9'
        self.cccoefs2 = RootSeqRbanaInhiresCh9Cccoefs2(self._context)
        self.cccoefz1 = RootSeqRbanaInhiresCh9Cccoefz1(self._context)
        self.cccoefs3 = RootSeqRbanaInhiresCh9Cccoefs3(self._context)
        self.currentinval = RootSeqRbanaInhiresCh9Currentinval(self._context)
        self.cccoefy3 = RootSeqRbanaInhiresCh9Cccoefy3(self._context)
        self.cccoefx2 = RootSeqRbanaInhiresCh9Cccoefx2(self._context)
        self.cccoefz2 = RootSeqRbanaInhiresCh9Cccoefz2(self._context)
        self.cccoefy2 = RootSeqRbanaInhiresCh9Cccoefy2(self._context)
        self.cccoefy1 = RootSeqRbanaInhiresCh9Cccoefy1(self._context)
        self.cccoefx1 = RootSeqRbanaInhiresCh9Cccoefx1(self._context)
        self.offset = RootSeqRbanaInhiresCh9Offset(self._context)
        self.cccoefz0 = RootSeqRbanaInhiresCh9Cccoefz0(self._context)
        self.cccoefs1 = RootSeqRbanaInhiresCh9Cccoefs1(self._context)
        self.inputoffset = RootSeqRbanaInhiresCh9Inputoffset(self._context)
        self.gain = RootSeqRbanaInhiresCh9Gain(self._context)
        self.cccoefx0 = RootSeqRbanaInhiresCh9Cccoefx0(self._context)
        self.filterval = RootSeqRbanaInhiresCh9Filterval(self._context)
        self.cccoefz4 = RootSeqRbanaInhiresCh9Cccoefz4(self._context)
        self.cccoefz3 = RootSeqRbanaInhiresCh9Cccoefz3(self._context)
        self.cccoefs4 = RootSeqRbanaInhiresCh9Cccoefs4(self._context)
        self.cccoefx4 = RootSeqRbanaInhiresCh9Cccoefx4(self._context)
        self.cccoefx3 = RootSeqRbanaInhiresCh9Cccoefx3(self._context)
        self.cccoefs0 = RootSeqRbanaInhiresCh9Cccoefs0(self._context)
        self.cccoefy0 = RootSeqRbanaInhiresCh9Cccoefy0(self._context)
        self.cccoefy4 = RootSeqRbanaInhiresCh9Cccoefy4(self._context)


class RootSeqRbanaInhiresCh11Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch11.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch11.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch11.cccoefy4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh11Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch11.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch11.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch11.cccoefy0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh11Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch11.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch11.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch11.cccoefs0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh11Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch11.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch11.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch11.cccoefx3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh11Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch11.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch11.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch11.cccoefx4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh11Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch11.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch11.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch11.cccoefs4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh11Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch11.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch11.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch11.cccoefz3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh11Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch11.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch11.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch11.cccoefz4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh11Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch11.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch11.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch11.filterval.regaddr', int(new_val))


class RootSeqRbanaInhiresCh11Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch11.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch11.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch11.cccoefx0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh11Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch11.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch11.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch11.gain.regaddr', int(new_val))


class RootSeqRbanaInhiresCh11Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch11.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch11.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch11.inputoffset.regaddr', int(new_val))


class RootSeqRbanaInhiresCh11Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch11.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch11.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch11.cccoefs1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh11Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch11.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch11.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch11.cccoefz0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh11Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch11.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch11.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch11.offset.regaddr', int(new_val))


class RootSeqRbanaInhiresCh11Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch11.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch11.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch11.cccoefx1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh11Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch11.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch11.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch11.cccoefy1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh11Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch11.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch11.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch11.cccoefy2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh11Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch11.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch11.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch11.cccoefz2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh11Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch11.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch11.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch11.cccoefx2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh11Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch11.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch11.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch11.cccoefy3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh11Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch11.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch11.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch11.currentinval.regaddr', int(new_val))


class RootSeqRbanaInhiresCh11Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch11.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch11.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch11.cccoefs3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh11Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch11.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch11.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch11.cccoefz1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh11Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch11.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch11.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch11.cccoefs2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh11(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch11'
        self.cccoefs2 = RootSeqRbanaInhiresCh11Cccoefs2(self._context)
        self.cccoefz1 = RootSeqRbanaInhiresCh11Cccoefz1(self._context)
        self.cccoefs3 = RootSeqRbanaInhiresCh11Cccoefs3(self._context)
        self.currentinval = RootSeqRbanaInhiresCh11Currentinval(self._context)
        self.cccoefy3 = RootSeqRbanaInhiresCh11Cccoefy3(self._context)
        self.cccoefx2 = RootSeqRbanaInhiresCh11Cccoefx2(self._context)
        self.cccoefz2 = RootSeqRbanaInhiresCh11Cccoefz2(self._context)
        self.cccoefy2 = RootSeqRbanaInhiresCh11Cccoefy2(self._context)
        self.cccoefy1 = RootSeqRbanaInhiresCh11Cccoefy1(self._context)
        self.cccoefx1 = RootSeqRbanaInhiresCh11Cccoefx1(self._context)
        self.offset = RootSeqRbanaInhiresCh11Offset(self._context)
        self.cccoefz0 = RootSeqRbanaInhiresCh11Cccoefz0(self._context)
        self.cccoefs1 = RootSeqRbanaInhiresCh11Cccoefs1(self._context)
        self.inputoffset = RootSeqRbanaInhiresCh11Inputoffset(self._context)
        self.gain = RootSeqRbanaInhiresCh11Gain(self._context)
        self.cccoefx0 = RootSeqRbanaInhiresCh11Cccoefx0(self._context)
        self.filterval = RootSeqRbanaInhiresCh11Filterval(self._context)
        self.cccoefz4 = RootSeqRbanaInhiresCh11Cccoefz4(self._context)
        self.cccoefz3 = RootSeqRbanaInhiresCh11Cccoefz3(self._context)
        self.cccoefs4 = RootSeqRbanaInhiresCh11Cccoefs4(self._context)
        self.cccoefx4 = RootSeqRbanaInhiresCh11Cccoefx4(self._context)
        self.cccoefx3 = RootSeqRbanaInhiresCh11Cccoefx3(self._context)
        self.cccoefs0 = RootSeqRbanaInhiresCh11Cccoefs0(self._context)
        self.cccoefy0 = RootSeqRbanaInhiresCh11Cccoefy0(self._context)
        self.cccoefy4 = RootSeqRbanaInhiresCh11Cccoefy4(self._context)


class RootSeqRbanaInhiresCh4Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch4.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch4.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch4.cccoefy4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh4Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch4.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch4.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch4.cccoefy0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh4Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch4.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch4.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch4.cccoefs0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh4Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch4.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch4.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch4.cccoefx3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh4Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch4.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch4.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch4.cccoefx4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh4Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch4.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch4.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch4.cccoefs4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh4Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch4.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch4.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch4.cccoefz3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh4Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch4.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch4.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch4.cccoefz4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh4Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch4.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch4.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch4.filterval.regaddr', int(new_val))


class RootSeqRbanaInhiresCh4Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch4.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch4.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch4.cccoefx0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh4Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch4.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch4.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch4.gain.regaddr', int(new_val))


class RootSeqRbanaInhiresCh4Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch4.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch4.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch4.inputoffset.regaddr', int(new_val))


class RootSeqRbanaInhiresCh4Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch4.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch4.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch4.cccoefs1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh4Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch4.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch4.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch4.cccoefz0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh4Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch4.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch4.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch4.offset.regaddr', int(new_val))


class RootSeqRbanaInhiresCh4Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch4.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch4.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch4.cccoefx1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh4Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch4.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch4.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch4.cccoefy1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh4Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch4.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch4.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch4.cccoefy2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh4Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch4.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch4.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch4.cccoefz2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh4Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch4.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch4.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch4.cccoefx2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh4Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch4.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch4.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch4.cccoefy3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh4Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch4.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch4.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch4.currentinval.regaddr', int(new_val))


class RootSeqRbanaInhiresCh4Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch4.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch4.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch4.cccoefs3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh4Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch4.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch4.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch4.cccoefz1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh4Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch4.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch4.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch4.cccoefs2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch4'
        self.cccoefs2 = RootSeqRbanaInhiresCh4Cccoefs2(self._context)
        self.cccoefz1 = RootSeqRbanaInhiresCh4Cccoefz1(self._context)
        self.cccoefs3 = RootSeqRbanaInhiresCh4Cccoefs3(self._context)
        self.currentinval = RootSeqRbanaInhiresCh4Currentinval(self._context)
        self.cccoefy3 = RootSeqRbanaInhiresCh4Cccoefy3(self._context)
        self.cccoefx2 = RootSeqRbanaInhiresCh4Cccoefx2(self._context)
        self.cccoefz2 = RootSeqRbanaInhiresCh4Cccoefz2(self._context)
        self.cccoefy2 = RootSeqRbanaInhiresCh4Cccoefy2(self._context)
        self.cccoefy1 = RootSeqRbanaInhiresCh4Cccoefy1(self._context)
        self.cccoefx1 = RootSeqRbanaInhiresCh4Cccoefx1(self._context)
        self.offset = RootSeqRbanaInhiresCh4Offset(self._context)
        self.cccoefz0 = RootSeqRbanaInhiresCh4Cccoefz0(self._context)
        self.cccoefs1 = RootSeqRbanaInhiresCh4Cccoefs1(self._context)
        self.inputoffset = RootSeqRbanaInhiresCh4Inputoffset(self._context)
        self.gain = RootSeqRbanaInhiresCh4Gain(self._context)
        self.cccoefx0 = RootSeqRbanaInhiresCh4Cccoefx0(self._context)
        self.filterval = RootSeqRbanaInhiresCh4Filterval(self._context)
        self.cccoefz4 = RootSeqRbanaInhiresCh4Cccoefz4(self._context)
        self.cccoefz3 = RootSeqRbanaInhiresCh4Cccoefz3(self._context)
        self.cccoefs4 = RootSeqRbanaInhiresCh4Cccoefs4(self._context)
        self.cccoefx4 = RootSeqRbanaInhiresCh4Cccoefx4(self._context)
        self.cccoefx3 = RootSeqRbanaInhiresCh4Cccoefx3(self._context)
        self.cccoefs0 = RootSeqRbanaInhiresCh4Cccoefs0(self._context)
        self.cccoefy0 = RootSeqRbanaInhiresCh4Cccoefy0(self._context)
        self.cccoefy4 = RootSeqRbanaInhiresCh4Cccoefy4(self._context)


class RootSeqRbanaInhiresCh3Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch3.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch3.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch3.cccoefy4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh3Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch3.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch3.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch3.cccoefy0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh3Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch3.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch3.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch3.cccoefs0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh3Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch3.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch3.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch3.cccoefx3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh3Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch3.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch3.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch3.cccoefx4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh3Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch3.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch3.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch3.cccoefs4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh3Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch3.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch3.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch3.cccoefz3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh3Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch3.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch3.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch3.cccoefz4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh3Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch3.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch3.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch3.filterval.regaddr', int(new_val))


class RootSeqRbanaInhiresCh3Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch3.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch3.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch3.cccoefx0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh3Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch3.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch3.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch3.gain.regaddr', int(new_val))


class RootSeqRbanaInhiresCh3Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch3.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch3.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch3.inputoffset.regaddr', int(new_val))


class RootSeqRbanaInhiresCh3Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch3.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch3.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch3.cccoefs1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh3Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch3.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch3.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch3.cccoefz0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh3Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch3.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch3.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch3.offset.regaddr', int(new_val))


class RootSeqRbanaInhiresCh3Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch3.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch3.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch3.cccoefx1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh3Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch3.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch3.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch3.cccoefy1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh3Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch3.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch3.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch3.cccoefy2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh3Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch3.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch3.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch3.cccoefz2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh3Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch3.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch3.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch3.cccoefx2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh3Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch3.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch3.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch3.cccoefy3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh3Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch3.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch3.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch3.currentinval.regaddr', int(new_val))


class RootSeqRbanaInhiresCh3Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch3.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch3.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch3.cccoefs3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh3Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch3.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch3.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch3.cccoefz1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh3Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch3.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch3.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch3.cccoefs2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch3'
        self.cccoefs2 = RootSeqRbanaInhiresCh3Cccoefs2(self._context)
        self.cccoefz1 = RootSeqRbanaInhiresCh3Cccoefz1(self._context)
        self.cccoefs3 = RootSeqRbanaInhiresCh3Cccoefs3(self._context)
        self.currentinval = RootSeqRbanaInhiresCh3Currentinval(self._context)
        self.cccoefy3 = RootSeqRbanaInhiresCh3Cccoefy3(self._context)
        self.cccoefx2 = RootSeqRbanaInhiresCh3Cccoefx2(self._context)
        self.cccoefz2 = RootSeqRbanaInhiresCh3Cccoefz2(self._context)
        self.cccoefy2 = RootSeqRbanaInhiresCh3Cccoefy2(self._context)
        self.cccoefy1 = RootSeqRbanaInhiresCh3Cccoefy1(self._context)
        self.cccoefx1 = RootSeqRbanaInhiresCh3Cccoefx1(self._context)
        self.offset = RootSeqRbanaInhiresCh3Offset(self._context)
        self.cccoefz0 = RootSeqRbanaInhiresCh3Cccoefz0(self._context)
        self.cccoefs1 = RootSeqRbanaInhiresCh3Cccoefs1(self._context)
        self.inputoffset = RootSeqRbanaInhiresCh3Inputoffset(self._context)
        self.gain = RootSeqRbanaInhiresCh3Gain(self._context)
        self.cccoefx0 = RootSeqRbanaInhiresCh3Cccoefx0(self._context)
        self.filterval = RootSeqRbanaInhiresCh3Filterval(self._context)
        self.cccoefz4 = RootSeqRbanaInhiresCh3Cccoefz4(self._context)
        self.cccoefz3 = RootSeqRbanaInhiresCh3Cccoefz3(self._context)
        self.cccoefs4 = RootSeqRbanaInhiresCh3Cccoefs4(self._context)
        self.cccoefx4 = RootSeqRbanaInhiresCh3Cccoefx4(self._context)
        self.cccoefx3 = RootSeqRbanaInhiresCh3Cccoefx3(self._context)
        self.cccoefs0 = RootSeqRbanaInhiresCh3Cccoefs0(self._context)
        self.cccoefy0 = RootSeqRbanaInhiresCh3Cccoefy0(self._context)
        self.cccoefy4 = RootSeqRbanaInhiresCh3Cccoefy4(self._context)


class RootSeqRbanaInhiresCh6Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch6.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch6.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch6.cccoefy4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh6Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch6.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch6.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch6.cccoefy0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh6Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch6.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch6.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch6.cccoefs0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh6Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch6.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch6.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch6.cccoefx3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh6Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch6.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch6.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch6.cccoefx4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh6Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch6.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch6.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch6.cccoefs4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh6Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch6.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch6.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch6.cccoefz3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh6Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch6.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch6.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch6.cccoefz4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh6Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch6.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch6.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch6.filterval.regaddr', int(new_val))


class RootSeqRbanaInhiresCh6Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch6.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch6.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch6.cccoefx0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh6Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch6.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch6.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch6.gain.regaddr', int(new_val))


class RootSeqRbanaInhiresCh6Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch6.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch6.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch6.inputoffset.regaddr', int(new_val))


class RootSeqRbanaInhiresCh6Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch6.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch6.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch6.cccoefs1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh6Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch6.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch6.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch6.cccoefz0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh6Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch6.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch6.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch6.offset.regaddr', int(new_val))


class RootSeqRbanaInhiresCh6Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch6.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch6.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch6.cccoefx1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh6Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch6.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch6.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch6.cccoefy1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh6Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch6.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch6.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch6.cccoefy2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh6Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch6.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch6.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch6.cccoefz2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh6Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch6.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch6.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch6.cccoefx2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh6Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch6.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch6.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch6.cccoefy3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh6Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch6.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch6.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch6.currentinval.regaddr', int(new_val))


class RootSeqRbanaInhiresCh6Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch6.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch6.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch6.cccoefs3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh6Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch6.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch6.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch6.cccoefz1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh6Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch6.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch6.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch6.cccoefs2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh6(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch6'
        self.cccoefs2 = RootSeqRbanaInhiresCh6Cccoefs2(self._context)
        self.cccoefz1 = RootSeqRbanaInhiresCh6Cccoefz1(self._context)
        self.cccoefs3 = RootSeqRbanaInhiresCh6Cccoefs3(self._context)
        self.currentinval = RootSeqRbanaInhiresCh6Currentinval(self._context)
        self.cccoefy3 = RootSeqRbanaInhiresCh6Cccoefy3(self._context)
        self.cccoefx2 = RootSeqRbanaInhiresCh6Cccoefx2(self._context)
        self.cccoefz2 = RootSeqRbanaInhiresCh6Cccoefz2(self._context)
        self.cccoefy2 = RootSeqRbanaInhiresCh6Cccoefy2(self._context)
        self.cccoefy1 = RootSeqRbanaInhiresCh6Cccoefy1(self._context)
        self.cccoefx1 = RootSeqRbanaInhiresCh6Cccoefx1(self._context)
        self.offset = RootSeqRbanaInhiresCh6Offset(self._context)
        self.cccoefz0 = RootSeqRbanaInhiresCh6Cccoefz0(self._context)
        self.cccoefs1 = RootSeqRbanaInhiresCh6Cccoefs1(self._context)
        self.inputoffset = RootSeqRbanaInhiresCh6Inputoffset(self._context)
        self.gain = RootSeqRbanaInhiresCh6Gain(self._context)
        self.cccoefx0 = RootSeqRbanaInhiresCh6Cccoefx0(self._context)
        self.filterval = RootSeqRbanaInhiresCh6Filterval(self._context)
        self.cccoefz4 = RootSeqRbanaInhiresCh6Cccoefz4(self._context)
        self.cccoefz3 = RootSeqRbanaInhiresCh6Cccoefz3(self._context)
        self.cccoefs4 = RootSeqRbanaInhiresCh6Cccoefs4(self._context)
        self.cccoefx4 = RootSeqRbanaInhiresCh6Cccoefx4(self._context)
        self.cccoefx3 = RootSeqRbanaInhiresCh6Cccoefx3(self._context)
        self.cccoefs0 = RootSeqRbanaInhiresCh6Cccoefs0(self._context)
        self.cccoefy0 = RootSeqRbanaInhiresCh6Cccoefy0(self._context)
        self.cccoefy4 = RootSeqRbanaInhiresCh6Cccoefy4(self._context)


class RootSeqRbanaInhiresCh1Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch1.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch1.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch1.cccoefy4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh1Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch1.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch1.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch1.cccoefy0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh1Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch1.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch1.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch1.cccoefs0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh1Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch1.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch1.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch1.cccoefx3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh1Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch1.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch1.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch1.cccoefx4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh1Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch1.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch1.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch1.cccoefs4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh1Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch1.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch1.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch1.cccoefz3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh1Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch1.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch1.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch1.cccoefz4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh1Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch1.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch1.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch1.filterval.regaddr', int(new_val))


class RootSeqRbanaInhiresCh1Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch1.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch1.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch1.cccoefx0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh1Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch1.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch1.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch1.gain.regaddr', int(new_val))


class RootSeqRbanaInhiresCh1Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch1.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch1.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch1.inputoffset.regaddr', int(new_val))


class RootSeqRbanaInhiresCh1Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch1.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch1.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch1.cccoefs1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh1Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch1.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch1.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch1.cccoefz0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh1Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch1.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch1.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch1.offset.regaddr', int(new_val))


class RootSeqRbanaInhiresCh1Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch1.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch1.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch1.cccoefx1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh1Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch1.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch1.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch1.cccoefy1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh1Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch1.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch1.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch1.cccoefy2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh1Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch1.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch1.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch1.cccoefz2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh1Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch1.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch1.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch1.cccoefx2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh1Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch1.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch1.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch1.cccoefy3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh1Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch1.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch1.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch1.currentinval.regaddr', int(new_val))


class RootSeqRbanaInhiresCh1Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch1.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch1.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch1.cccoefs3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh1Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch1.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch1.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch1.cccoefz1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh1Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch1.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch1.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch1.cccoefs2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch1'
        self.cccoefs2 = RootSeqRbanaInhiresCh1Cccoefs2(self._context)
        self.cccoefz1 = RootSeqRbanaInhiresCh1Cccoefz1(self._context)
        self.cccoefs3 = RootSeqRbanaInhiresCh1Cccoefs3(self._context)
        self.currentinval = RootSeqRbanaInhiresCh1Currentinval(self._context)
        self.cccoefy3 = RootSeqRbanaInhiresCh1Cccoefy3(self._context)
        self.cccoefx2 = RootSeqRbanaInhiresCh1Cccoefx2(self._context)
        self.cccoefz2 = RootSeqRbanaInhiresCh1Cccoefz2(self._context)
        self.cccoefy2 = RootSeqRbanaInhiresCh1Cccoefy2(self._context)
        self.cccoefy1 = RootSeqRbanaInhiresCh1Cccoefy1(self._context)
        self.cccoefx1 = RootSeqRbanaInhiresCh1Cccoefx1(self._context)
        self.offset = RootSeqRbanaInhiresCh1Offset(self._context)
        self.cccoefz0 = RootSeqRbanaInhiresCh1Cccoefz0(self._context)
        self.cccoefs1 = RootSeqRbanaInhiresCh1Cccoefs1(self._context)
        self.inputoffset = RootSeqRbanaInhiresCh1Inputoffset(self._context)
        self.gain = RootSeqRbanaInhiresCh1Gain(self._context)
        self.cccoefx0 = RootSeqRbanaInhiresCh1Cccoefx0(self._context)
        self.filterval = RootSeqRbanaInhiresCh1Filterval(self._context)
        self.cccoefz4 = RootSeqRbanaInhiresCh1Cccoefz4(self._context)
        self.cccoefz3 = RootSeqRbanaInhiresCh1Cccoefz3(self._context)
        self.cccoefs4 = RootSeqRbanaInhiresCh1Cccoefs4(self._context)
        self.cccoefx4 = RootSeqRbanaInhiresCh1Cccoefx4(self._context)
        self.cccoefx3 = RootSeqRbanaInhiresCh1Cccoefx3(self._context)
        self.cccoefs0 = RootSeqRbanaInhiresCh1Cccoefs0(self._context)
        self.cccoefy0 = RootSeqRbanaInhiresCh1Cccoefy0(self._context)
        self.cccoefy4 = RootSeqRbanaInhiresCh1Cccoefy4(self._context)


class RootSeqRbanaInhiresCh12Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch12.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch12.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch12.cccoefy4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh12Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch12.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch12.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch12.cccoefy0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh12Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch12.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch12.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch12.cccoefs0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh12Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch12.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch12.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch12.cccoefx3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh12Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch12.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch12.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch12.cccoefx4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh12Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch12.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch12.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch12.cccoefs4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh12Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch12.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch12.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch12.cccoefz3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh12Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch12.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch12.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch12.cccoefz4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh12Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch12.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch12.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch12.filterval.regaddr', int(new_val))


class RootSeqRbanaInhiresCh12Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch12.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch12.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch12.cccoefx0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh12Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch12.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch12.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch12.gain.regaddr', int(new_val))


class RootSeqRbanaInhiresCh12Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch12.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch12.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch12.inputoffset.regaddr', int(new_val))


class RootSeqRbanaInhiresCh12Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch12.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch12.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch12.cccoefs1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh12Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch12.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch12.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch12.cccoefz0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh12Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch12.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch12.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch12.offset.regaddr', int(new_val))


class RootSeqRbanaInhiresCh12Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch12.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch12.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch12.cccoefx1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh12Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch12.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch12.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch12.cccoefy1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh12Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch12.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch12.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch12.cccoefy2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh12Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch12.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch12.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch12.cccoefz2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh12Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch12.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch12.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch12.cccoefx2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh12Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch12.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch12.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch12.cccoefy3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh12Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch12.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch12.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch12.currentinval.regaddr', int(new_val))


class RootSeqRbanaInhiresCh12Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch12.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch12.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch12.cccoefs3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh12Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch12.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch12.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch12.cccoefz1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh12Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch12.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch12.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch12.cccoefs2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh12(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch12'
        self.cccoefs2 = RootSeqRbanaInhiresCh12Cccoefs2(self._context)
        self.cccoefz1 = RootSeqRbanaInhiresCh12Cccoefz1(self._context)
        self.cccoefs3 = RootSeqRbanaInhiresCh12Cccoefs3(self._context)
        self.currentinval = RootSeqRbanaInhiresCh12Currentinval(self._context)
        self.cccoefy3 = RootSeqRbanaInhiresCh12Cccoefy3(self._context)
        self.cccoefx2 = RootSeqRbanaInhiresCh12Cccoefx2(self._context)
        self.cccoefz2 = RootSeqRbanaInhiresCh12Cccoefz2(self._context)
        self.cccoefy2 = RootSeqRbanaInhiresCh12Cccoefy2(self._context)
        self.cccoefy1 = RootSeqRbanaInhiresCh12Cccoefy1(self._context)
        self.cccoefx1 = RootSeqRbanaInhiresCh12Cccoefx1(self._context)
        self.offset = RootSeqRbanaInhiresCh12Offset(self._context)
        self.cccoefz0 = RootSeqRbanaInhiresCh12Cccoefz0(self._context)
        self.cccoefs1 = RootSeqRbanaInhiresCh12Cccoefs1(self._context)
        self.inputoffset = RootSeqRbanaInhiresCh12Inputoffset(self._context)
        self.gain = RootSeqRbanaInhiresCh12Gain(self._context)
        self.cccoefx0 = RootSeqRbanaInhiresCh12Cccoefx0(self._context)
        self.filterval = RootSeqRbanaInhiresCh12Filterval(self._context)
        self.cccoefz4 = RootSeqRbanaInhiresCh12Cccoefz4(self._context)
        self.cccoefz3 = RootSeqRbanaInhiresCh12Cccoefz3(self._context)
        self.cccoefs4 = RootSeqRbanaInhiresCh12Cccoefs4(self._context)
        self.cccoefx4 = RootSeqRbanaInhiresCh12Cccoefx4(self._context)
        self.cccoefx3 = RootSeqRbanaInhiresCh12Cccoefx3(self._context)
        self.cccoefs0 = RootSeqRbanaInhiresCh12Cccoefs0(self._context)
        self.cccoefy0 = RootSeqRbanaInhiresCh12Cccoefy0(self._context)
        self.cccoefy4 = RootSeqRbanaInhiresCh12Cccoefy4(self._context)


class RootSeqRbanaInhiresCh2Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch2.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch2.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch2.cccoefy4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh2Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch2.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch2.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch2.cccoefy0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh2Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch2.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch2.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch2.cccoefs0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh2Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch2.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch2.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch2.cccoefx3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh2Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch2.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch2.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch2.cccoefx4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh2Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch2.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch2.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch2.cccoefs4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh2Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch2.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch2.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch2.cccoefz3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh2Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch2.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch2.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch2.cccoefz4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh2Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch2.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch2.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch2.filterval.regaddr', int(new_val))


class RootSeqRbanaInhiresCh2Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch2.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch2.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch2.cccoefx0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh2Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch2.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch2.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch2.gain.regaddr', int(new_val))


class RootSeqRbanaInhiresCh2Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch2.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch2.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch2.inputoffset.regaddr', int(new_val))


class RootSeqRbanaInhiresCh2Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch2.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch2.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch2.cccoefs1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh2Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch2.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch2.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch2.cccoefz0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh2Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch2.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch2.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch2.offset.regaddr', int(new_val))


class RootSeqRbanaInhiresCh2Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch2.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch2.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch2.cccoefx1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh2Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch2.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch2.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch2.cccoefy1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh2Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch2.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch2.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch2.cccoefy2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh2Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch2.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch2.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch2.cccoefz2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh2Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch2.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch2.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch2.cccoefx2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh2Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch2.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch2.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch2.cccoefy3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh2Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch2.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch2.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch2.currentinval.regaddr', int(new_val))


class RootSeqRbanaInhiresCh2Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch2.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch2.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch2.cccoefs3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh2Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch2.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch2.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch2.cccoefz1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh2Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch2.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch2.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch2.cccoefs2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch2'
        self.cccoefs2 = RootSeqRbanaInhiresCh2Cccoefs2(self._context)
        self.cccoefz1 = RootSeqRbanaInhiresCh2Cccoefz1(self._context)
        self.cccoefs3 = RootSeqRbanaInhiresCh2Cccoefs3(self._context)
        self.currentinval = RootSeqRbanaInhiresCh2Currentinval(self._context)
        self.cccoefy3 = RootSeqRbanaInhiresCh2Cccoefy3(self._context)
        self.cccoefx2 = RootSeqRbanaInhiresCh2Cccoefx2(self._context)
        self.cccoefz2 = RootSeqRbanaInhiresCh2Cccoefz2(self._context)
        self.cccoefy2 = RootSeqRbanaInhiresCh2Cccoefy2(self._context)
        self.cccoefy1 = RootSeqRbanaInhiresCh2Cccoefy1(self._context)
        self.cccoefx1 = RootSeqRbanaInhiresCh2Cccoefx1(self._context)
        self.offset = RootSeqRbanaInhiresCh2Offset(self._context)
        self.cccoefz0 = RootSeqRbanaInhiresCh2Cccoefz0(self._context)
        self.cccoefs1 = RootSeqRbanaInhiresCh2Cccoefs1(self._context)
        self.inputoffset = RootSeqRbanaInhiresCh2Inputoffset(self._context)
        self.gain = RootSeqRbanaInhiresCh2Gain(self._context)
        self.cccoefx0 = RootSeqRbanaInhiresCh2Cccoefx0(self._context)
        self.filterval = RootSeqRbanaInhiresCh2Filterval(self._context)
        self.cccoefz4 = RootSeqRbanaInhiresCh2Cccoefz4(self._context)
        self.cccoefz3 = RootSeqRbanaInhiresCh2Cccoefz3(self._context)
        self.cccoefs4 = RootSeqRbanaInhiresCh2Cccoefs4(self._context)
        self.cccoefx4 = RootSeqRbanaInhiresCh2Cccoefx4(self._context)
        self.cccoefx3 = RootSeqRbanaInhiresCh2Cccoefx3(self._context)
        self.cccoefs0 = RootSeqRbanaInhiresCh2Cccoefs0(self._context)
        self.cccoefy0 = RootSeqRbanaInhiresCh2Cccoefy0(self._context)
        self.cccoefy4 = RootSeqRbanaInhiresCh2Cccoefy4(self._context)


class RootSeqRbanaInhiresCh5Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch5.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch5.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch5.cccoefy4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh5Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch5.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch5.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch5.cccoefy0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh5Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch5.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch5.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch5.cccoefs0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh5Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch5.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch5.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch5.cccoefx3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh5Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch5.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch5.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch5.cccoefx4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh5Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch5.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch5.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch5.cccoefs4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh5Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch5.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch5.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch5.cccoefz3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh5Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch5.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch5.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch5.cccoefz4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh5Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch5.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch5.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch5.filterval.regaddr', int(new_val))


class RootSeqRbanaInhiresCh5Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch5.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch5.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch5.cccoefx0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh5Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch5.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch5.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch5.gain.regaddr', int(new_val))


class RootSeqRbanaInhiresCh5Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch5.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch5.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch5.inputoffset.regaddr', int(new_val))


class RootSeqRbanaInhiresCh5Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch5.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch5.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch5.cccoefs1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh5Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch5.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch5.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch5.cccoefz0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh5Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch5.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch5.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch5.offset.regaddr', int(new_val))


class RootSeqRbanaInhiresCh5Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch5.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch5.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch5.cccoefx1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh5Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch5.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch5.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch5.cccoefy1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh5Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch5.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch5.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch5.cccoefy2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh5Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch5.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch5.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch5.cccoefz2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh5Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch5.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch5.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch5.cccoefx2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh5Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch5.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch5.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch5.cccoefy3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh5Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch5.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch5.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch5.currentinval.regaddr', int(new_val))


class RootSeqRbanaInhiresCh5Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch5.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch5.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch5.cccoefs3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh5Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch5.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch5.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch5.cccoefz1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh5Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch5.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch5.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch5.cccoefs2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh5(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch5'
        self.cccoefs2 = RootSeqRbanaInhiresCh5Cccoefs2(self._context)
        self.cccoefz1 = RootSeqRbanaInhiresCh5Cccoefz1(self._context)
        self.cccoefs3 = RootSeqRbanaInhiresCh5Cccoefs3(self._context)
        self.currentinval = RootSeqRbanaInhiresCh5Currentinval(self._context)
        self.cccoefy3 = RootSeqRbanaInhiresCh5Cccoefy3(self._context)
        self.cccoefx2 = RootSeqRbanaInhiresCh5Cccoefx2(self._context)
        self.cccoefz2 = RootSeqRbanaInhiresCh5Cccoefz2(self._context)
        self.cccoefy2 = RootSeqRbanaInhiresCh5Cccoefy2(self._context)
        self.cccoefy1 = RootSeqRbanaInhiresCh5Cccoefy1(self._context)
        self.cccoefx1 = RootSeqRbanaInhiresCh5Cccoefx1(self._context)
        self.offset = RootSeqRbanaInhiresCh5Offset(self._context)
        self.cccoefz0 = RootSeqRbanaInhiresCh5Cccoefz0(self._context)
        self.cccoefs1 = RootSeqRbanaInhiresCh5Cccoefs1(self._context)
        self.inputoffset = RootSeqRbanaInhiresCh5Inputoffset(self._context)
        self.gain = RootSeqRbanaInhiresCh5Gain(self._context)
        self.cccoefx0 = RootSeqRbanaInhiresCh5Cccoefx0(self._context)
        self.filterval = RootSeqRbanaInhiresCh5Filterval(self._context)
        self.cccoefz4 = RootSeqRbanaInhiresCh5Cccoefz4(self._context)
        self.cccoefz3 = RootSeqRbanaInhiresCh5Cccoefz3(self._context)
        self.cccoefs4 = RootSeqRbanaInhiresCh5Cccoefs4(self._context)
        self.cccoefx4 = RootSeqRbanaInhiresCh5Cccoefx4(self._context)
        self.cccoefx3 = RootSeqRbanaInhiresCh5Cccoefx3(self._context)
        self.cccoefs0 = RootSeqRbanaInhiresCh5Cccoefs0(self._context)
        self.cccoefy0 = RootSeqRbanaInhiresCh5Cccoefy0(self._context)
        self.cccoefy4 = RootSeqRbanaInhiresCh5Cccoefy4(self._context)


class RootSeqRbanaInhiresCh7Cccoefy4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch7.cccoefy4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch7.cccoefy4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch7.cccoefy4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh7Cccoefy0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch7.cccoefy0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch7.cccoefy0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch7.cccoefy0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh7Cccoefs0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch7.cccoefs0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch7.cccoefs0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch7.cccoefs0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh7Cccoefx3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch7.cccoefx3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch7.cccoefx3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch7.cccoefx3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh7Cccoefx4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch7.cccoefx4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch7.cccoefx4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch7.cccoefx4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh7Cccoefs4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch7.cccoefs4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch7.cccoefs4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch7.cccoefs4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh7Cccoefz3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch7.cccoefz3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch7.cccoefz3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch7.cccoefz3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh7Cccoefz4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch7.cccoefz4'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch7.cccoefz4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch7.cccoefz4.regaddr', int(new_val))


class RootSeqRbanaInhiresCh7Filterval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch7.filterval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch7.filterval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch7.filterval.regaddr', int(new_val))


class RootSeqRbanaInhiresCh7Cccoefx0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch7.cccoefx0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch7.cccoefx0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch7.cccoefx0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh7Gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch7.gain'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch7.gain.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch7.gain.regaddr', int(new_val))


class RootSeqRbanaInhiresCh7Inputoffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch7.inputoffset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch7.inputoffset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch7.inputoffset.regaddr', int(new_val))


class RootSeqRbanaInhiresCh7Cccoefs1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch7.cccoefs1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch7.cccoefs1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch7.cccoefs1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh7Cccoefz0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch7.cccoefz0'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch7.cccoefz0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch7.cccoefz0.regaddr', int(new_val))


class RootSeqRbanaInhiresCh7Offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch7.offset'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch7.offset.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch7.offset.regaddr', int(new_val))


class RootSeqRbanaInhiresCh7Cccoefx1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch7.cccoefx1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch7.cccoefx1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch7.cccoefx1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh7Cccoefy1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch7.cccoefy1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch7.cccoefy1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch7.cccoefy1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh7Cccoefy2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch7.cccoefy2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch7.cccoefy2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch7.cccoefy2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh7Cccoefz2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch7.cccoefz2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch7.cccoefz2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch7.cccoefz2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh7Cccoefx2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch7.cccoefx2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch7.cccoefx2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch7.cccoefx2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh7Cccoefy3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch7.cccoefy3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch7.cccoefy3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch7.cccoefy3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh7Currentinval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch7.currentinval'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch7.currentinval.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch7.currentinval.regaddr', int(new_val))


class RootSeqRbanaInhiresCh7Cccoefs3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch7.cccoefs3'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch7.cccoefs3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch7.cccoefs3.regaddr', int(new_val))


class RootSeqRbanaInhiresCh7Cccoefz1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch7.cccoefz1'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch7.cccoefz1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch7.cccoefz1.regaddr', int(new_val))


class RootSeqRbanaInhiresCh7Cccoefs2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch7.cccoefs2'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.inhires.ch7.cccoefs2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.inhires.ch7.cccoefs2.regaddr', int(new_val))


class RootSeqRbanaInhiresCh7(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires.ch7'
        self.cccoefs2 = RootSeqRbanaInhiresCh7Cccoefs2(self._context)
        self.cccoefz1 = RootSeqRbanaInhiresCh7Cccoefz1(self._context)
        self.cccoefs3 = RootSeqRbanaInhiresCh7Cccoefs3(self._context)
        self.currentinval = RootSeqRbanaInhiresCh7Currentinval(self._context)
        self.cccoefy3 = RootSeqRbanaInhiresCh7Cccoefy3(self._context)
        self.cccoefx2 = RootSeqRbanaInhiresCh7Cccoefx2(self._context)
        self.cccoefz2 = RootSeqRbanaInhiresCh7Cccoefz2(self._context)
        self.cccoefy2 = RootSeqRbanaInhiresCh7Cccoefy2(self._context)
        self.cccoefy1 = RootSeqRbanaInhiresCh7Cccoefy1(self._context)
        self.cccoefx1 = RootSeqRbanaInhiresCh7Cccoefx1(self._context)
        self.offset = RootSeqRbanaInhiresCh7Offset(self._context)
        self.cccoefz0 = RootSeqRbanaInhiresCh7Cccoefz0(self._context)
        self.cccoefs1 = RootSeqRbanaInhiresCh7Cccoefs1(self._context)
        self.inputoffset = RootSeqRbanaInhiresCh7Inputoffset(self._context)
        self.gain = RootSeqRbanaInhiresCh7Gain(self._context)
        self.cccoefx0 = RootSeqRbanaInhiresCh7Cccoefx0(self._context)
        self.filterval = RootSeqRbanaInhiresCh7Filterval(self._context)
        self.cccoefz4 = RootSeqRbanaInhiresCh7Cccoefz4(self._context)
        self.cccoefz3 = RootSeqRbanaInhiresCh7Cccoefz3(self._context)
        self.cccoefs4 = RootSeqRbanaInhiresCh7Cccoefs4(self._context)
        self.cccoefx4 = RootSeqRbanaInhiresCh7Cccoefx4(self._context)
        self.cccoefx3 = RootSeqRbanaInhiresCh7Cccoefx3(self._context)
        self.cccoefs0 = RootSeqRbanaInhiresCh7Cccoefs0(self._context)
        self.cccoefy0 = RootSeqRbanaInhiresCh7Cccoefy0(self._context)
        self.cccoefy4 = RootSeqRbanaInhiresCh7Cccoefy4(self._context)


class RootSeqRbanaInhires(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.inhires'
        self.ch7 = RootSeqRbanaInhiresCh7(self._context)
        self.ch5 = RootSeqRbanaInhiresCh5(self._context)
        self.ch2 = RootSeqRbanaInhiresCh2(self._context)
        self.ch12 = RootSeqRbanaInhiresCh12(self._context)
        self.ch1 = RootSeqRbanaInhiresCh1(self._context)
        self.ch6 = RootSeqRbanaInhiresCh6(self._context)
        self.ch3 = RootSeqRbanaInhiresCh3(self._context)
        self.ch4 = RootSeqRbanaInhiresCh4(self._context)
        self.ch11 = RootSeqRbanaInhiresCh11(self._context)
        self.ch9 = RootSeqRbanaInhiresCh9(self._context)
        self.ch10 = RootSeqRbanaInhiresCh10(self._context)
        self.ch8 = RootSeqRbanaInhiresCh8(self._context)


class RootSeqRbanaDatacaptureSgleSelecthires1Selectin7(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.datacapture.sgle.selecthires1.selectin7'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.selecthires1.selectin7.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.selecthires1.selectin7.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.selecthires1.selectin7.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.selecthires1.selectin7.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.selecthires1.selectin7.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.selecthires1.selectin7.lsb', int(new_val))


class RootSeqRbanaDatacaptureSgleSelecthires1Selectin5(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.datacapture.sgle.selecthires1.selectin5'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.selecthires1.selectin5.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.selecthires1.selectin5.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.selecthires1.selectin5.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.selecthires1.selectin5.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.selecthires1.selectin5.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.selecthires1.selectin5.lsb', int(new_val))


class RootSeqRbanaDatacaptureSgleSelecthires1Selectin6(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.datacapture.sgle.selecthires1.selectin6'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.selecthires1.selectin6.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.selecthires1.selectin6.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.selecthires1.selectin6.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.selecthires1.selectin6.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.selecthires1.selectin6.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.selecthires1.selectin6.lsb', int(new_val))


class RootSeqRbanaDatacaptureSgleSelecthires1Selectin4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.datacapture.sgle.selecthires1.selectin4'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.selecthires1.selectin4.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.selecthires1.selectin4.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.selecthires1.selectin4.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.selecthires1.selectin4.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.selecthires1.selectin4.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.selecthires1.selectin4.lsb', int(new_val))


class RootSeqRbanaDatacaptureSgleSelecthires1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.datacapture.sgle.selecthires1'
        self.selectin4 = RootSeqRbanaDatacaptureSgleSelecthires1Selectin4(self._context)
        self.selectin6 = RootSeqRbanaDatacaptureSgleSelecthires1Selectin6(self._context)
        self.selectin5 = RootSeqRbanaDatacaptureSgleSelecthires1Selectin5(self._context)
        self.selectin7 = RootSeqRbanaDatacaptureSgleSelecthires1Selectin7(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.selecthires1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.selecthires1.regaddr', int(new_val))


class RootSeqRbanaDatacaptureSgleStatusBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.datacapture.sgle.status.busy'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.status.busy.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.status.busy.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.status.busy.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.status.busy.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.status.busy.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.status.busy.lsb', int(new_val))


class RootSeqRbanaDatacaptureSgleStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.datacapture.sgle.status'
        self.busy = RootSeqRbanaDatacaptureSgleStatusBusy(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.status.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.status.regaddr', int(new_val))


class RootSeqRbanaDatacaptureSgleTimestampfirstmsb(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.datacapture.sgle.timestampfirstmsb'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.timestampfirstmsb.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.timestampfirstmsb.regaddr', int(new_val))


class RootSeqRbanaDatacaptureSgleSelecthires0Selectin2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.datacapture.sgle.selecthires0.selectin2'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.selecthires0.selectin2.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.selecthires0.selectin2.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.selecthires0.selectin2.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.selecthires0.selectin2.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.selecthires0.selectin2.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.selecthires0.selectin2.lsb', int(new_val))


class RootSeqRbanaDatacaptureSgleSelecthires0Selectin1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.datacapture.sgle.selecthires0.selectin1'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.selecthires0.selectin1.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.selecthires0.selectin1.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.selecthires0.selectin1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.selecthires0.selectin1.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.selecthires0.selectin1.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.selecthires0.selectin1.lsb', int(new_val))


class RootSeqRbanaDatacaptureSgleSelecthires0Selectin3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.datacapture.sgle.selecthires0.selectin3'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.selecthires0.selectin3.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.selecthires0.selectin3.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.selecthires0.selectin3.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.selecthires0.selectin3.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.selecthires0.selectin3.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.selecthires0.selectin3.lsb', int(new_val))


class RootSeqRbanaDatacaptureSgleSelecthires0Selectin0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.datacapture.sgle.selecthires0.selectin0'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.selecthires0.selectin0.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.selecthires0.selectin0.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.selecthires0.selectin0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.selecthires0.selectin0.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.selecthires0.selectin0.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.selecthires0.selectin0.lsb', int(new_val))


class RootSeqRbanaDatacaptureSgleSelecthires0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.datacapture.sgle.selecthires0'
        self.selectin0 = RootSeqRbanaDatacaptureSgleSelecthires0Selectin0(self._context)
        self.selectin3 = RootSeqRbanaDatacaptureSgleSelecthires0Selectin3(self._context)
        self.selectin1 = RootSeqRbanaDatacaptureSgleSelecthires0Selectin1(self._context)
        self.selectin2 = RootSeqRbanaDatacaptureSgleSelecthires0Selectin2(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.selecthires0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.selecthires0.regaddr', int(new_val))


class RootSeqRbanaDatacaptureSgleTimestampfirstlsb(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.datacapture.sgle.timestampfirstlsb'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.timestampfirstlsb.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.timestampfirstlsb.regaddr', int(new_val))


class RootSeqRbanaDatacaptureSgleControlSelectfastin1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.datacapture.sgle.control.selectfastin1'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.selectfastin1.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.selectfastin1.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.selectfastin1.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.selectfastin1.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.selectfastin1.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.selectfastin1.lsb', int(new_val))


class RootSeqRbanaDatacaptureSgleControlStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.datacapture.sgle.control.start'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.start.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.start.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.start.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.start.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.start.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.start.lsb', int(new_val))


class RootSeqRbanaDatacaptureSgleControlChanmaskhires(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.datacapture.sgle.control.chanmaskhires'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.chanmaskhires.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.chanmaskhires.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.chanmaskhires.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.chanmaskhires.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.chanmaskhires.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.chanmaskhires.lsb', int(new_val))


class RootSeqRbanaDatacaptureSgleControlFastdivider(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.datacapture.sgle.control.fastdivider'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.fastdivider.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.fastdivider.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.fastdivider.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.fastdivider.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.fastdivider.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.fastdivider.lsb', int(new_val))


class RootSeqRbanaDatacaptureSgleControlChanmaskfast(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.datacapture.sgle.control.chanmaskfast'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.chanmaskfast.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.chanmaskfast.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.chanmaskfast.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.chanmaskfast.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.chanmaskfast.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.chanmaskfast.lsb', int(new_val))


class RootSeqRbanaDatacaptureSgleControlEnablehirescapture(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.datacapture.sgle.control.enablehirescapture'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.enablehirescapture.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.enablehirescapture.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.enablehirescapture.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.enablehirescapture.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.enablehirescapture.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.enablehirescapture.lsb', int(new_val))


class RootSeqRbanaDatacaptureSgleControlSelectfastin0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.datacapture.sgle.control.selectfastin0'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.selectfastin0.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.selectfastin0.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.selectfastin0.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.selectfastin0.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.selectfastin0.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.selectfastin0.lsb', int(new_val))


class RootSeqRbanaDatacaptureSgleControlEnablefastcapture(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.datacapture.sgle.control.enablefastcapture'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.enablefastcapture.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.enablefastcapture.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.enablefastcapture.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.enablefastcapture.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.enablefastcapture.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.enablefastcapture.lsb', int(new_val))


class RootSeqRbanaDatacaptureSgleControlStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.datacapture.sgle.control.stop'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.stop.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.stop.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.stop.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.stop.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.stop.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.stop.lsb', int(new_val))


class RootSeqRbanaDatacaptureSgleControlAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.datacapture.sgle.control.abort'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.abort.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.abort.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.abort.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.abort.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.abort.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.abort.lsb', int(new_val))


class RootSeqRbanaDatacaptureSgleControl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.datacapture.sgle.control'
        self.abort = RootSeqRbanaDatacaptureSgleControlAbort(self._context)
        self.stop = RootSeqRbanaDatacaptureSgleControlStop(self._context)
        self.enablefastcapture = RootSeqRbanaDatacaptureSgleControlEnablefastcapture(self._context)
        self.selectfastin0 = RootSeqRbanaDatacaptureSgleControlSelectfastin0(self._context)
        self.enablehirescapture = RootSeqRbanaDatacaptureSgleControlEnablehirescapture(self._context)
        self.chanmaskfast = RootSeqRbanaDatacaptureSgleControlChanmaskfast(self._context)
        self.fastdivider = RootSeqRbanaDatacaptureSgleControlFastdivider(self._context)
        self.chanmaskhires = RootSeqRbanaDatacaptureSgleControlChanmaskhires(self._context)
        self.start = RootSeqRbanaDatacaptureSgleControlStart(self._context)
        self.selectfastin1 = RootSeqRbanaDatacaptureSgleControlSelectfastin1(self._context)

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.datacapture.sgle.control.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.datacapture.sgle.control.regaddr', int(new_val))


class RootSeqRbanaDatacaptureSgle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.datacapture.sgle'
        self.control = RootSeqRbanaDatacaptureSgleControl(self._context)
        self.timestampfirstlsb = RootSeqRbanaDatacaptureSgleTimestampfirstlsb(self._context)
        self.selecthires0 = RootSeqRbanaDatacaptureSgleSelecthires0(self._context)
        self.timestampfirstmsb = RootSeqRbanaDatacaptureSgleTimestampfirstmsb(self._context)
        self.status = RootSeqRbanaDatacaptureSgleStatus(self._context)
        self.selecthires1 = RootSeqRbanaDatacaptureSgleSelecthires1(self._context)


class RootSeqRbanaDatacapture(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.datacapture'
        self.sgle = RootSeqRbanaDatacaptureSgle(self._context)


class RootSeqRbanaZctrlexSgleClp_pid_gain_d(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.zctrlex.sgle.clp_pid_gain_d'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.zctrlex.sgle.clp_pid_gain_d.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.zctrlex.sgle.clp_pid_gain_d.regaddr', int(new_val))


class RootSeqRbanaZctrlexSgleErrorlimit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.zctrlex.sgle.errorlimit'

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.zctrlex.sgle.errorlimit.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.zctrlex.sgle.errorlimit.regaddr', int(new_val))


class RootSeqRbanaZctrlexSgleControl1P1movestopbyvalueactive(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.zctrlex.sgle.control1.p1movestopbyvalueactive'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.zctrlex.sgle.control1.p1movestopbyvalueactive.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.zctrlex.sgle.control1.p1movestopbyvalueactive.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.zctrlex.sgle.control1.p1movestopbyvalueactive.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.zctrlex.sgle.control1.p1movestopbyvalueactive.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.zctrlex.sgle.control1.p1movestopbyvalueactive.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.zctrlex.sgle.control1.p1movestopbyvalueactive.lsb', int(new_val))


class RootSeqRbanaZctrlexSgleControl1P2movestopbyvalueactive(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.zctrlex.sgle.control1.p2movestopbyvalueactive'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.zctrlex.sgle.control1.p2movestopbyvalueactive.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.zctrlex.sgle.control1.p2movestopbyvalueactive.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.zctrlex.sgle.control1.p2movestopbyvalueactive.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.zctrlex.sgle.control1.p2movestopbyvalueactive.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.zctrlex.sgle.control1.p2movestopbyvalueactive.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.zctrlex.sgle.control1.p2movestopbyvalueactive.lsb', int(new_val))


class RootSeqRbanaZctrlexSgleControl1P2workmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.zctrlex.sgle.control1.p2workmode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.zctrlex.sgle.control1.p2workmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.zctrlex.sgle.control1.p2workmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.zctrlex.sgle.control1.p2workmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.zctrlex.sgle.control1.p2workmode.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.zctrlex.sgle.control1.p2workmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.zctrlex.sgle.control1.p2workmode.lsb', int(new_val))


class RootSeqRbanaZctrlexSgleControl1P0movestopbyvalueactive(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.zctrlex.sgle.control1.p0movestopbyvalueactive'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.zctrlex.sgle.control1.p0movestopbyvalueactive.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.zctrlex.sgle.control1.p0movestopbyvalueactive.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.zctrlex.sgle.control1.p0movestopbyvalueactive.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.zctrlex.sgle.control1.p0movestopbyvalueactive.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.zctrlex.sgle.control1.p0movestopbyvalueactive.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.zctrlex.sgle.control1.p0movestopbyvalueactive.lsb', int(new_val))


class RootSeqRbanaZctrlexSgleControl1P1moveendmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.zctrlex.sgle.control1.p1moveendmode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.zctrlex.sgle.control1.p1moveendmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.zctrlex.sgle.control1.p1moveendmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.zctrlex.sgle.control1.p1moveendmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.zctrlex.sgle.control1.p1moveendmode.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.zctrlex.sgle.control1.p1moveendmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.zctrlex.sgle.control1.p1moveendmode.lsb', int(new_val))


class RootSeqRbanaZctrlexSgleControl1P0moveendmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.zctrlex.sgle.control1.p0moveendmode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.zctrlex.sgle.control1.p0moveendmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.zctrlex.sgle.control1.p0moveendmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.zctrlex.sgle.control1.p0moveendmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.zctrlex.sgle.control1.p0moveendmode.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.zctrlex.sgle.control1.p0moveendmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.zctrlex.sgle.control1.p0moveendmode.lsb', int(new_val))


class RootSeqRbanaZctrlexSgleControl1P1workmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.zctrlex.sgle.control1.p1workmode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.zctrlex.sgle.control1.p1workmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.zctrlex.sgle.control1.p1workmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.zctrlex.sgle.control1.p1workmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.zctrlex.sgle.control1.p1workmode.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.zctrlex.sgle.control1.p1workmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.zctrlex.sgle.control1.p1workmode.lsb', int(new_val))


class RootSeqRbanaZctrlexSgleControl1P0workmode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.zctrlex.sgle.control1.p0workmode'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.zctrlex.sgle.control1.p0workmode.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.zctrlex.sgle.control1.p0workmode.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.zctrlex.sgle.control1.p0workmode.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.zctrlex.sgle.control1.p0workmode.regaddr', int(new_val))

    @property
    def lsb(self) -> int:
        return int(self._context.get('root.seq.rbana.zctrlex.sgle.control1.p0workmode.lsb'))

    @lsb.setter
    def lsb(self, new_val:int):
        self._context.set('root.seq.rbana.zctrlex.sgle.control1.p0workmode.lsb', int(new_val))


class RootSeqRbanaZctrlexSgleControl1P3movestopbyvalueactive(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.seq.rbana.zctrlex.sgle.control1.p3movestopbyvalueactive'

    @property
    def msb(self) -> int:
        return int(self._context.get('root.seq.rbana.zctrlex.sgle.control1.p3movestopbyvalueactive.msb'))

    @msb.setter
    def msb(self, new_val:int):
        self._context.set('root.seq.rbana.zctrlex.sgle.control1.p3movestopbyvalueactive.msb', int(new_val))

    @property
    def regaddr(self) -> int:
        return int(self._context.get('root.seq.rbana.zctrlex.sgle.control1.p3movestopbyvalueactive.regaddr'))

    @regaddr.setter
    def regaddr(self, new_val:int):
        self._context.set('root.seq.rbana.zctrlex.sgle.control1.p3movestop