# template
This is a template generated by farzad in order to be used as a standard in Adler software development.
this readme file is written in MarkDown in a github friendly way.


## Installation and setup

just use the following code for generating a wheel file.
```bash
python setup.py bdist_wheel
```
and for installing and using the created wheel file locally run the following.
```bash
pip install -e .
pip install -e .[dev]
```
for installing it on another environment use this:
```bash
pip install /path/wheel.whl
```

>> use pytest to make sure package is working properly. it is a powerfull tool to investigate the modules and everything automatically.
```bash
pytest
```
also [twine](https://twine.readthedocs.io/en/stable/) has a good testing mechanism.

Any doubts about installation and setuptools refere to [setuptools](https://pythonhosted.org/an_example_pypi_project/setuptools.html) or watch this [video](https://www.youtube.com/watch?v=GIF3LaRqgXo).

**important to know: in the next version the setup.py must send the wheel file to the database!** 


[Python Packaging User Guide](https://packaging.python.org/en/latest/)

## Source distribution

For sending the source code to another distination use:
```bash
python setup.py sdist
```
then check for all the needed files. if they were not their use maifest using:
```bash
pip install check-manifest
check-manifest --create
git add MANIFEST.in
```
then compress it and publish it (internally of course!).
```bash
tar tzf dist/template-0.0.1.tar.gz
```
## Importing

import the package name and then call for the functions and objects.

```python
from template import template
template.say_hello()
```

## Test

- [ ] Everything must have a unit test and api test files.
- [ ] Please check everything before you request a code review or merge.
- [ ] The correctness of your code is your responsibility.
- [ ] Check the speed of your code and if possible report the code complexity indexes.
- [ ] use pytest for general syntax check.
- [ ] use tox for testing on different versions of python.
```python
# tox.ini
[tox]
envlist = py36,py37

[testenv]
deps=pytest
commands=pytest
```
```bash
pip install tox
tox
```

## Test and Deploy

Only those packages that are indipendent are going to be deployed others will be imported and recieve an authorization from the guardian sentinel.
Deployment will be done using DpckerFile.
Our system is linux ubuntu focal forsa, so all the codes must be compatible with this disto of operating system.


## Other stuff

you can use pip freeze to extract all the installed packages and their versions.
```bash
pip freeze > requirements.txt
```

## **Warnings**
- [ ] Do not push into master, main, or dev!
- [ ] You only and only push into your own branches!

***
Farzad Ziaie Nezhad | ZLION