from zodipy._labels import Label
import astropy.units as u

K98 = {
    Label.CLOUD: dict(
        x_0=0.011887800744346281 * u.AU,
        y_0=0.0054765064662263777 * u.AU,
        z_0=-0.0021530908020710744 * u.AU,
        i=2.0335188072390769 * u.deg,
        Omega=77.657955554097114 * u.deg,
        n_0=1.1344373881427960e-07 / u.au,
        alpha=1.3370696705930281,
        beta=4.1415004157586637,
        gamma=0.94206179393358036,
        mu=0.18873176489090190,
    ),
    Label.BAND1: dict(
        x_0=0.0 * u.AU,
        y_0=0.0 * u.AU,
        z_0=0.0 * u.AU,
        i=0.56438265154389733 * u.deg,
        Omega=80.0 * u.deg,
        n_0=5.5890290403228370e-10 / u.au,
        delta_zeta=8.7850534408713035 * u.deg,
        v=0.10000000149011612,
        p=4.0,
        delta_r=1.5 * u.AU,
    ),
    Label.BAND2: dict(
        x_0=0.0 * u.AU,
        y_0=0.0 * u.AU,
        z_0=0.0 * u.AU,
        i=1.2000000476837158 * u.deg,
        Omega=30.347475578624532 * u.deg,
        n_0=1.9877609422590801e-09 / u.au,
        delta_zeta=1.9917032425777641 * u.deg,
        v=0.89999997615814209,
        p=4.0,
        delta_r=0.94121881201651147 * u.AU,
    ),
    Label.BAND3: dict(
        x_0=0.0 * u.AU,
        y_0=0.0 * u.AU,
        z_0=0.0 * u.AU,
        i=0.80000001192092896 * u.deg,
        Omega=80.0 * u.deg,
        n_0=1.4369827283512384e-10 / u.au,
        delta_zeta=15 * u.deg,
        v=0.050000000745058060,
        p=4.0,
        delta_r=1.5 * u.AU,
    ),
    Label.RING: dict(
        x_0=0.0 * u.AU,
        y_0=0.0 * u.AU,
        z_0=0.0 * u.AU,
        i=0.48707166006819241 * u.deg,
        Omega=22.278979678854448 * u.deg,
        n_0=1.8260527826501675e-08 / u.au,
        R=1.0281924326308751 * u.AU,
        sigma_r=0.025000000372529030 * u.AU,
        sigma_z=0.054068037356978099 * u.AU,
    ),
    Label.FEATURE: dict(
        x_0=0.0 * u.AU,
        y_0=0.0 * u.AU,
        z_0=0.0 * u.AU,
        i=0.48707166006819241 * u.deg,
        Omega=22.278979678854448 * u.deg,
        n_0=2.0094267183590947e-08 / u.au,
        R=1.0579182694524214 * u.AU,
        sigma_r=0.10287314662396611 * u.AU,
        sigma_z=0.091442963768716023 * u.AU,
        theta=-10.0 * u.deg,
        sigma_theta=12.115210933938741 * u.deg,
    ),
}
