import json
import urllib.parse

from django import template
from django.urls import reverse
from django.utils.safestring import mark_safe
from django.utils.translation import gettext as _

from smart_admin.utils import as_bool

register = template.Library()


@register.filter()
def section(model_to_section, opts):
    return model_to_section[f"{opts.app_label}.{opts.object_name}"]


@register.simple_tag(takes_context=True)
def smart_toggler(context):
    request = context['request']
    page = urllib.parse.quote(request.path)
    if as_bool(request.COOKIES.get('smart', "0")):
        label = _("Standard Index")
        t = "on"
    else:
        label = _("Smart Index")
        t = "off"

    toggler = reverse("admin:smart_toggle", args=[t])
    return mark_safe(f'<a href="{toggler}?from={page}">{label}</a>')


@register.simple_tag()
def get_changed(message, entry):
    try:
        change_message = json.loads(message)
        # if isinstance(change_message, (list, tuple)) and change_message:
        #     if 'changed' in change_message[0] and 'permissions' in change_message[0]['changed']:
        return change_message[0]['changed'][entry]
    except (json.JSONDecodeError, KeyError, IndexError):
        pass
    return ""
