(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["DashboardPage"],{

/***/ "./src/common/hooks/apiResources/apiResources.ts":
/*!*******************************************************!*\
  !*** ./src/common/hooks/apiResources/apiResources.ts ***!
  \*******************************************************/
/*! exports provided: ResourceStatus, useApiResourceFullBody, useTransformedResource, useApiV1Resource */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* WEBPACK VAR INJECTION */(function(module) {/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"ResourceStatus\", function() { return ResourceStatus; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"useApiResourceFullBody\", function() { return useApiResourceFullBody; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"useTransformedResource\", function() { return useTransformedResource; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"useApiV1Resource\", function() { return useApiV1Resource; });\n/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ \"./node_modules/core-js/modules/web.dom-collections.iterator.js\");\n/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @superset-ui/core */ \"./node_modules/@superset-ui/core/esm/query/api/v1/makeApi.js\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ \"./node_modules/react/index.js\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);\n(function () {var enterModule = typeof reactHotLoaderGlobal !== 'undefined' ? reactHotLoaderGlobal.enterModule : undefined;enterModule && enterModule(module);})();var __signature__ = typeof reactHotLoaderGlobal !== 'undefined' ? reactHotLoaderGlobal.default.signature : function (a) {return a;}; /**\n * Licensed to the Apache Software Foundation (ASF) under one\n * or more contributor license agreements.  See the NOTICE file\n * distributed with this work for additional information\n * regarding copyright ownership.  The ASF licenses this file\n * to you under the Apache License, Version 2.0 (the\n * \"License\"); you may not use this file except in compliance\n * with the License.  You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing,\n * software distributed under the License is distributed on an\n * \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n * KIND, either express or implied.  See the License for the\n * specific language governing permissions and limitations\n * under the License.\n */\n\n\nvar ResourceStatus;\n(function (ResourceStatus) {\n  ResourceStatus[\"LOADING\"] = \"loading\";\n  ResourceStatus[\"COMPLETE\"] = \"complete\";\n  ResourceStatus[\"ERROR\"] = \"error\";\n})(ResourceStatus || (ResourceStatus = {}));\nconst initialState = {\n  status: ResourceStatus.LOADING,\n  result: null,\n  error: null };\n\n/**\n * A general-purpose hook to fetch the response from an endpoint.\n * Returns the full response body from the API, including metadata.\n *\n * Note: You likely want {useApiV1Resource} instead of this!\n *\n * TODO Store the state in redux or something, share state between hook instances.\n *\n * TODO Include a function in the returned resource object to refresh the data.\n *\n * A core design decision here is composition > configuration,\n * and every hook should only have one job.\n * Please address new needs with new hooks if possible,\n * rather than adding config options to this hook.\n *\n * @param endpoint The url where the resource is located.\n */\nfunction useApiResourceFullBody(endpoint) {\n  const [resource, setResource] = Object(react__WEBPACK_IMPORTED_MODULE_2__[\"useState\"])(initialState);\n  const cancelRef = Object(react__WEBPACK_IMPORTED_MODULE_2__[\"useRef\"])(() => {});\n  Object(react__WEBPACK_IMPORTED_MODULE_2__[\"useEffect\"])(() => {\n    // If refresh is implemented, this will need to change.\n    // The previous values should stay during refresh.\n    setResource(initialState);\n    // when this effect runs, the endpoint has changed.\n    // cancel any current calls so that state doesn't get messed up.\n    cancelRef.current();\n    let cancelled = false;\n    cancelRef.current = () => {\n      cancelled = true;\n    };\n    const fetchResource = Object(_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__[\"default\"])({\n      method: 'GET',\n      endpoint });\n\n    fetchResource({}).\n    then((result) => {\n      if (!cancelled) {\n        setResource({\n          status: ResourceStatus.COMPLETE,\n          result,\n          error: null });\n\n      }\n    }).\n    catch((error) => {\n      if (!cancelled) {\n        setResource({\n          status: ResourceStatus.ERROR,\n          result: null,\n          error });\n\n      }\n    });\n    // Cancel the request when the component un-mounts\n    return () => {\n      cancelled = true;\n    };\n  }, [endpoint]);\n  return resource;\n}\n/**\n * For when you want to transform the result of an api resource hook before using it.\n *\n * @param resource the Resource object returned from useApiV1Resource\n * @param transformFn a callback that transforms the result object into the shape you want.\n * Make sure to use a persistent function for this so it doesn't constantly recalculate!\n */__signature__(useApiResourceFullBody, \"useState{[resource, setResource](initialState)}\\nuseRef{cancelRef}\\nuseEffect{}\");\nfunction useTransformedResource(resource, transformFn) {\n  return Object(react__WEBPACK_IMPORTED_MODULE_2__[\"useMemo\"])(() => {\n    if (resource.status !== ResourceStatus.COMPLETE) {\n      // While incomplete, there is no result - no need to transform.\n      return resource;\n    }\n    return {\n      ...resource,\n      result: transformFn(resource.result) };\n\n  }, [resource, transformFn]);\n}\n// returns the \"result\" field from a fetched API v1 endpoint\n__signature__(useTransformedResource, \"useMemo{}\");const extractInnerResult = (responseBody) => responseBody.result;\n/**\n * A general-purpose hook to fetch a Superset resource from a v1 API endpoint.\n * Handles request lifecycle and async logic so you don't have to.\n *\n * This returns the data under the \"result\" field in the API response body.\n * If you need the full response body, use {useFullApiResource} instead.\n *\n * @param endpoint The url where the resource is located.\n */\nfunction useApiV1Resource(endpoint) {\n  return useTransformedResource(useApiResourceFullBody(endpoint), extractInnerResult);\n}__signature__(useApiV1Resource, \"useTransformedResource{}\\nuseApiResourceFullBody{}\", () => [useTransformedResource, useApiResourceFullBody]);;(function () {var reactHotLoader = typeof reactHotLoaderGlobal !== 'undefined' ? reactHotLoaderGlobal.default : undefined;if (!reactHotLoader) {return;}reactHotLoader.register(ResourceStatus, \"ResourceStatus\", \"/Users/admin/Git/Public/spotrix/spotrix-frontend/src/common/hooks/apiResources/apiResources.ts\");reactHotLoader.register(initialState, \"initialState\", \"/Users/admin/Git/Public/spotrix/spotrix-frontend/src/common/hooks/apiResources/apiResources.ts\");reactHotLoader.register(useApiResourceFullBody, \"useApiResourceFullBody\", \"/Users/admin/Git/Public/spotrix/spotrix-frontend/src/common/hooks/apiResources/apiResources.ts\");reactHotLoader.register(useTransformedResource, \"useTransformedResource\", \"/Users/admin/Git/Public/spotrix/spotrix-frontend/src/common/hooks/apiResources/apiResources.ts\");reactHotLoader.register(extractInnerResult, \"extractInnerResult\", \"/Users/admin/Git/Public/spotrix/spotrix-frontend/src/common/hooks/apiResources/apiResources.ts\");reactHotLoader.register(useApiV1Resource, \"useApiV1Resource\", \"/Users/admin/Git/Public/spotrix/spotrix-frontend/src/common/hooks/apiResources/apiResources.ts\");})();;(function () {var leaveModule = typeof reactHotLoaderGlobal !== 'undefined' ? reactHotLoaderGlobal.leaveModule : undefined;leaveModule && leaveModule(module);})();\n/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! ./../../../../node_modules/webpack/buildin/harmony-module.js */ \"./node_modules/webpack/buildin/harmony-module.js\")(module)))//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/common/hooks/apiResources/apiResources.ts\n");

/***/ }),

/***/ "./src/common/hooks/apiResources/charts.ts":
/*!*************************************************!*\
  !*** ./src/common/hooks/apiResources/charts.ts ***!
  \*************************************************/
/*! exports provided: useChartOwnerNames */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* WEBPACK VAR INJECTION */(function(module) {/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"useChartOwnerNames\", function() { return useChartOwnerNames; });\n/* harmony import */ var _babel_runtime_corejs3_core_js_stable_instance_map__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime-corejs3/core-js-stable/instance/map */ \"./node_modules/@babel/runtime-corejs3/core-js-stable/instance/map.js\");\n/* harmony import */ var _babel_runtime_corejs3_core_js_stable_instance_map__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_corejs3_core_js_stable_instance_map__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var rison__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! rison */ \"./node_modules/rison/js/rison.js\");\n/* harmony import */ var rison__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(rison__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _apiResources__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./apiResources */ \"./src/common/hooks/apiResources/apiResources.ts\");\n(function () {var enterModule = typeof reactHotLoaderGlobal !== 'undefined' ? reactHotLoaderGlobal.enterModule : undefined;enterModule && enterModule(module);})();var __signature__ = typeof reactHotLoaderGlobal !== 'undefined' ? reactHotLoaderGlobal.default.signature : function (a) {return a;}; /**\n * Licensed to the Apache Software Foundation (ASF) under one\n * or more contributor license agreements.  See the NOTICE file\n * distributed with this work for additional information\n * regarding copyright ownership.  The ASF licenses this file\n * to you under the Apache License, Version 2.0 (the\n * \"License\"); you may not use this file except in compliance\n * with the License.  You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing,\n * software distributed under the License is distributed on an\n * \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n * KIND, either express or implied.  See the License for the\n * specific language governing permissions and limitations\n * under the License.\n */\n\n\nfunction extractOwnerNames({ owners }) {\n  if (!owners)\n  return null;\n  return _babel_runtime_corejs3_core_js_stable_instance_map__WEBPACK_IMPORTED_MODULE_0___default()(owners).call(owners, (owner) => `${owner.first_name} ${owner.last_name}`);\n}\nconst ownerNamesQuery = rison__WEBPACK_IMPORTED_MODULE_1___default.a.encode({\n  columns: ['owners.first_name', 'owners.last_name'],\n  keys: ['none'] });\n\nfunction useChartOwnerNames(chartId) {\n  return Object(_apiResources__WEBPACK_IMPORTED_MODULE_2__[\"useTransformedResource\"])(Object(_apiResources__WEBPACK_IMPORTED_MODULE_2__[\"useApiV1Resource\"])(`/api/v1/chart/${chartId}?q=${ownerNamesQuery}`), extractOwnerNames);\n}__signature__(useChartOwnerNames, \"useTransformedResource{}\\nuseApiV1Resource{}\", () => [_apiResources__WEBPACK_IMPORTED_MODULE_2__[\"useTransformedResource\"], _apiResources__WEBPACK_IMPORTED_MODULE_2__[\"useApiV1Resource\"]]);;(function () {var reactHotLoader = typeof reactHotLoaderGlobal !== 'undefined' ? reactHotLoaderGlobal.default : undefined;if (!reactHotLoader) {return;}reactHotLoader.register(extractOwnerNames, \"extractOwnerNames\", \"/Users/admin/Git/Public/spotrix/spotrix-frontend/src/common/hooks/apiResources/charts.ts\");reactHotLoader.register(ownerNamesQuery, \"ownerNamesQuery\", \"/Users/admin/Git/Public/spotrix/spotrix-frontend/src/common/hooks/apiResources/charts.ts\");reactHotLoader.register(useChartOwnerNames, \"useChartOwnerNames\", \"/Users/admin/Git/Public/spotrix/spotrix-frontend/src/common/hooks/apiResources/charts.ts\");})();;(function () {var leaveModule = typeof reactHotLoaderGlobal !== 'undefined' ? reactHotLoaderGlobal.leaveModule : undefined;leaveModule && leaveModule(module);})();\n/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! ./../../../../node_modules/webpack/buildin/harmony-module.js */ \"./node_modules/webpack/buildin/harmony-module.js\")(module)))//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/common/hooks/apiResources/charts.ts\n");

/***/ }),

/***/ "./src/common/hooks/apiResources/dashboards.ts":
/*!*****************************************************!*\
  !*** ./src/common/hooks/apiResources/dashboards.ts ***!
  \*****************************************************/
/*! exports provided: useDashboard, useDashboardCharts, useDashboardDatasets */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* WEBPACK VAR INJECTION */(function(module) {/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"useDashboard\", function() { return useDashboard; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"useDashboardCharts\", function() { return useDashboardCharts; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"useDashboardDatasets\", function() { return useDashboardDatasets; });\n/* harmony import */ var _apiResources__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./apiResources */ \"./src/common/hooks/apiResources/apiResources.ts\");\n(function () {var enterModule = typeof reactHotLoaderGlobal !== 'undefined' ? reactHotLoaderGlobal.enterModule : undefined;enterModule && enterModule(module);})();var __signature__ = typeof reactHotLoaderGlobal !== 'undefined' ? reactHotLoaderGlobal.default.signature : function (a) {return a;}; /**\n * Licensed to the Apache Software Foundation (ASF) under one\n * or more contributor license agreements.  See the NOTICE file\n * distributed with this work for additional information\n * regarding copyright ownership.  The ASF licenses this file\n * to you under the Apache License, Version 2.0 (the\n * \"License\"); you may not use this file except in compliance\n * with the License.  You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing,\n * software distributed under the License is distributed on an\n * \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n * KIND, either express or implied.  See the License for the\n * specific language governing permissions and limitations\n * under the License.\n */\n\nconst useDashboard = (idOrSlug) => Object(_apiResources__WEBPACK_IMPORTED_MODULE_0__[\"useTransformedResource\"])(Object(_apiResources__WEBPACK_IMPORTED_MODULE_0__[\"useApiV1Resource\"])(`/api/v1/dashboard/${idOrSlug}`), (dashboard) => ({\n  ...dashboard,\n  metadata: dashboard.json_metadata && JSON.parse(dashboard.json_metadata),\n  position_data: dashboard.position_json && JSON.parse(dashboard.position_json) }));\n\n// gets the chart definitions for a dashboard\n__signature__(useDashboard, \"useTransformedResource{}\\nuseApiV1Resource{}\", () => [_apiResources__WEBPACK_IMPORTED_MODULE_0__[\"useTransformedResource\"], _apiResources__WEBPACK_IMPORTED_MODULE_0__[\"useApiV1Resource\"]]);const useDashboardCharts = (idOrSlug) => Object(_apiResources__WEBPACK_IMPORTED_MODULE_0__[\"useApiV1Resource\"])(`/api/v1/dashboard/${idOrSlug}/charts`);\n// gets the datasets for a dashboard\n// important: this endpoint only returns the fields in the dataset\n// that are necessary for rendering the given dashboard\n__signature__(useDashboardCharts, \"useApiV1Resource{}\", () => [_apiResources__WEBPACK_IMPORTED_MODULE_0__[\"useApiV1Resource\"]]);const useDashboardDatasets = (idOrSlug) => Object(_apiResources__WEBPACK_IMPORTED_MODULE_0__[\"useApiV1Resource\"])(`/api/v1/dashboard/${idOrSlug}/datasets`);__signature__(useDashboardDatasets, \"useApiV1Resource{}\", () => [_apiResources__WEBPACK_IMPORTED_MODULE_0__[\"useApiV1Resource\"]]);;(function () {var reactHotLoader = typeof reactHotLoaderGlobal !== 'undefined' ? reactHotLoaderGlobal.default : undefined;if (!reactHotLoader) {return;}reactHotLoader.register(useDashboard, \"useDashboard\", \"/Users/admin/Git/Public/spotrix/spotrix-frontend/src/common/hooks/apiResources/dashboards.ts\");reactHotLoader.register(useDashboardCharts, \"useDashboardCharts\", \"/Users/admin/Git/Public/spotrix/spotrix-frontend/src/common/hooks/apiResources/dashboards.ts\");reactHotLoader.register(useDashboardDatasets, \"useDashboardDatasets\", \"/Users/admin/Git/Public/spotrix/spotrix-frontend/src/common/hooks/apiResources/dashboards.ts\");})();;(function () {var leaveModule = typeof reactHotLoaderGlobal !== 'undefined' ? reactHotLoaderGlobal.leaveModule : undefined;leaveModule && leaveModule(module);})();\n/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! ./../../../../node_modules/webpack/buildin/harmony-module.js */ \"./node_modules/webpack/buildin/harmony-module.js\")(module)))//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9zcmMvY29tbW9uL2hvb2tzL2FwaVJlc291cmNlcy9kYXNoYm9hcmRzLnRzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vc3JjL2NvbW1vbi9ob29rcy9hcGlSZXNvdXJjZXMvZGFzaGJvYXJkcy50cz84MTFlIl0sInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogTGljZW5zZWQgdG8gdGhlIEFwYWNoZSBTb2Z0d2FyZSBGb3VuZGF0aW9uIChBU0YpIHVuZGVyIG9uZVxuICogb3IgbW9yZSBjb250cmlidXRvciBsaWNlbnNlIGFncmVlbWVudHMuICBTZWUgdGhlIE5PVElDRSBmaWxlXG4gKiBkaXN0cmlidXRlZCB3aXRoIHRoaXMgd29yayBmb3IgYWRkaXRpb25hbCBpbmZvcm1hdGlvblxuICogcmVnYXJkaW5nIGNvcHlyaWdodCBvd25lcnNoaXAuICBUaGUgQVNGIGxpY2Vuc2VzIHRoaXMgZmlsZVxuICogdG8geW91IHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSwgVmVyc2lvbiAyLjAgKHRoZVxuICogXCJMaWNlbnNlXCIpOyB5b3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlXG4gKiB3aXRoIHRoZSBMaWNlbnNlLiAgWW91IG1heSBvYnRhaW4gYSBjb3B5IG9mIHRoZSBMaWNlbnNlIGF0XG4gKlxuICogICBodHRwOi8vd3d3LmFwYWNoZS5vcmcvbGljZW5zZXMvTElDRU5TRS0yLjBcbiAqXG4gKiBVbmxlc3MgcmVxdWlyZWQgYnkgYXBwbGljYWJsZSBsYXcgb3IgYWdyZWVkIHRvIGluIHdyaXRpbmcsXG4gKiBzb2Z0d2FyZSBkaXN0cmlidXRlZCB1bmRlciB0aGUgTGljZW5zZSBpcyBkaXN0cmlidXRlZCBvbiBhblxuICogXCJBUyBJU1wiIEJBU0lTLCBXSVRIT1VUIFdBUlJBTlRJRVMgT1IgQ09ORElUSU9OUyBPRiBBTllcbiAqIEtJTkQsIGVpdGhlciBleHByZXNzIG9yIGltcGxpZWQuICBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZVxuICogc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zIGFuZCBsaW1pdGF0aW9uc1xuICogdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cblxuaW1wb3J0IHsgRGFzaGJvYXJkLCBEYXRhc291cmNlIH0gZnJvbSAnc3JjL2Rhc2hib2FyZC90eXBlcyc7XG5pbXBvcnQgeyBDaGFydCB9IGZyb20gJ3NyYy90eXBlcy9DaGFydCc7XG5pbXBvcnQgeyB1c2VBcGlWMVJlc291cmNlLCB1c2VUcmFuc2Zvcm1lZFJlc291cmNlIH0gZnJvbSAnLi9hcGlSZXNvdXJjZXMnO1xuXG5leHBvcnQgY29uc3QgdXNlRGFzaGJvYXJkID0gKGlkT3JTbHVnOiBzdHJpbmcgfCBudW1iZXIpID0+XG4gIHVzZVRyYW5zZm9ybWVkUmVzb3VyY2UoXG4gICAgdXNlQXBpVjFSZXNvdXJjZTxEYXNoYm9hcmQ+KGAvYXBpL3YxL2Rhc2hib2FyZC8ke2lkT3JTbHVnfWApLFxuICAgIGRhc2hib2FyZCA9PiAoe1xuICAgICAgLi4uZGFzaGJvYXJkLFxuICAgICAgbWV0YWRhdGE6IGRhc2hib2FyZC5qc29uX21ldGFkYXRhICYmIEpTT04ucGFyc2UoZGFzaGJvYXJkLmpzb25fbWV0YWRhdGEpLFxuICAgICAgcG9zaXRpb25fZGF0YTpcbiAgICAgICAgZGFzaGJvYXJkLnBvc2l0aW9uX2pzb24gJiYgSlNPTi5wYXJzZShkYXNoYm9hcmQucG9zaXRpb25fanNvbiksXG4gICAgfSksXG4gICk7XG5cbi8vIGdldHMgdGhlIGNoYXJ0IGRlZmluaXRpb25zIGZvciBhIGRhc2hib2FyZFxuZXhwb3J0IGNvbnN0IHVzZURhc2hib2FyZENoYXJ0cyA9IChpZE9yU2x1Zzogc3RyaW5nIHwgbnVtYmVyKSA9PlxuICB1c2VBcGlWMVJlc291cmNlPENoYXJ0W10+KGAvYXBpL3YxL2Rhc2hib2FyZC8ke2lkT3JTbHVnfS9jaGFydHNgKTtcblxuLy8gZ2V0cyB0aGUgZGF0YXNldHMgZm9yIGEgZGFzaGJvYXJkXG4vLyBpbXBvcnRhbnQ6IHRoaXMgZW5kcG9pbnQgb25seSByZXR1cm5zIHRoZSBmaWVsZHMgaW4gdGhlIGRhdGFzZXRcbi8vIHRoYXQgYXJlIG5lY2Vzc2FyeSBmb3IgcmVuZGVyaW5nIHRoZSBnaXZlbiBkYXNoYm9hcmRcbmV4cG9ydCBjb25zdCB1c2VEYXNoYm9hcmREYXRhc2V0cyA9IChpZE9yU2x1Zzogc3RyaW5nIHwgbnVtYmVyKSA9PlxuICB1c2VBcGlWMVJlc291cmNlPERhdGFzb3VyY2VbXT4oYC9hcGkvdjEvZGFzaGJvYXJkLyR7aWRPclNsdWd9L2RhdGFzZXRzYCk7XG4iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFpQkE7QUFJQTtBQUVBO0FBSUE7QUFDQTtBQUNBO0FBQ0E7QUFJQTtBQVhBO0FBZUE7QUFDQTtBQUNBO0FBTEE7QSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./src/common/hooks/apiResources/dashboards.ts\n");

/***/ }),

/***/ "./src/common/hooks/apiResources/index.ts":
/*!************************************************!*\
  !*** ./src/common/hooks/apiResources/index.ts ***!
  \************************************************/
/*! exports provided: useApiResourceFullBody, useApiV1Resource, useTransformedResource, useChartOwnerNames, useDashboard, useDashboardCharts, useDashboardDatasets */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _apiResources__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./apiResources */ \"./src/common/hooks/apiResources/apiResources.ts\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"useApiResourceFullBody\", function() { return _apiResources__WEBPACK_IMPORTED_MODULE_0__[\"useApiResourceFullBody\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"useApiV1Resource\", function() { return _apiResources__WEBPACK_IMPORTED_MODULE_0__[\"useApiV1Resource\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"useTransformedResource\", function() { return _apiResources__WEBPACK_IMPORTED_MODULE_0__[\"useTransformedResource\"]; });\n\n/* harmony import */ var _charts__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./charts */ \"./src/common/hooks/apiResources/charts.ts\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"useChartOwnerNames\", function() { return _charts__WEBPACK_IMPORTED_MODULE_1__[\"useChartOwnerNames\"]; });\n\n/* harmony import */ var _dashboards__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./dashboards */ \"./src/common/hooks/apiResources/dashboards.ts\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"useDashboard\", function() { return _dashboards__WEBPACK_IMPORTED_MODULE_2__[\"useDashboard\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"useDashboardCharts\", function() { return _dashboards__WEBPACK_IMPORTED_MODULE_2__[\"useDashboardCharts\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"useDashboardDatasets\", function() { return _dashboards__WEBPACK_IMPORTED_MODULE_2__[\"useDashboardDatasets\"]; });\n\nvar __signature__ = typeof reactHotLoaderGlobal !== 'undefined' ? reactHotLoaderGlobal.default.signature : function (a) {return a;}; /**\n * Licensed to the Apache Software Foundation (ASF) under one\n * or more contributor license agreements.  See the NOTICE file\n * distributed with this work for additional information\n * regarding copyright ownership.  The ASF licenses this file\n * to you under the Apache License, Version 2.0 (the\n * \"License\"); you may not use this file except in compliance\n * with the License.  You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing,\n * software distributed under the License is distributed on an\n * \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n * KIND, either express or implied.  See the License for the\n * specific language governing permissions and limitations\n * under the License.\n */\n\n// A central catalog of API Resource hooks.\n// Add new API hooks here, organized under\n// different files for different resource types.\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9zcmMvY29tbW9uL2hvb2tzL2FwaVJlc291cmNlcy9pbmRleC50cy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL3NyYy9jb21tb24vaG9va3MvYXBpUmVzb3VyY2VzL2luZGV4LnRzPzgzNDYiXSwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBMaWNlbnNlZCB0byB0aGUgQXBhY2hlIFNvZnR3YXJlIEZvdW5kYXRpb24gKEFTRikgdW5kZXIgb25lXG4gKiBvciBtb3JlIGNvbnRyaWJ1dG9yIGxpY2Vuc2UgYWdyZWVtZW50cy4gIFNlZSB0aGUgTk9USUNFIGZpbGVcbiAqIGRpc3RyaWJ1dGVkIHdpdGggdGhpcyB3b3JrIGZvciBhZGRpdGlvbmFsIGluZm9ybWF0aW9uXG4gKiByZWdhcmRpbmcgY29weXJpZ2h0IG93bmVyc2hpcC4gIFRoZSBBU0YgbGljZW5zZXMgdGhpcyBmaWxlXG4gKiB0byB5b3UgdW5kZXIgdGhlIEFwYWNoZSBMaWNlbnNlLCBWZXJzaW9uIDIuMCAodGhlXG4gKiBcIkxpY2Vuc2VcIik7IHlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2VcbiAqIHdpdGggdGhlIExpY2Vuc2UuICBZb3UgbWF5IG9idGFpbiBhIGNvcHkgb2YgdGhlIExpY2Vuc2UgYXRcbiAqXG4gKiAgIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuICpcbiAqIFVubGVzcyByZXF1aXJlZCBieSBhcHBsaWNhYmxlIGxhdyBvciBhZ3JlZWQgdG8gaW4gd3JpdGluZyxcbiAqIHNvZnR3YXJlIGRpc3RyaWJ1dGVkIHVuZGVyIHRoZSBMaWNlbnNlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuXG4gKiBcIkFTIElTXCIgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFUyBPUiBDT05ESVRJT05TIE9GIEFOWVxuICogS0lORCwgZWl0aGVyIGV4cHJlc3Mgb3IgaW1wbGllZC4gIFNlZSB0aGUgTGljZW5zZSBmb3IgdGhlXG4gKiBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnMgYW5kIGxpbWl0YXRpb25zXG4gKiB1bmRlciB0aGUgTGljZW5zZS5cbiAqL1xuXG5leHBvcnQge1xuICB1c2VBcGlSZXNvdXJjZUZ1bGxCb2R5LFxuICB1c2VBcGlWMVJlc291cmNlLFxuICB1c2VUcmFuc2Zvcm1lZFJlc291cmNlLFxufSBmcm9tICcuL2FwaVJlc291cmNlcyc7XG5cbi8vIEEgY2VudHJhbCBjYXRhbG9nIG9mIEFQSSBSZXNvdXJjZSBob29rcy5cbi8vIEFkZCBuZXcgQVBJIGhvb2tzIGhlcmUsIG9yZ2FuaXplZCB1bmRlclxuLy8gZGlmZmVyZW50IGZpbGVzIGZvciBkaWZmZXJlbnQgcmVzb3VyY2UgdHlwZXMuXG5leHBvcnQgKiBmcm9tICcuL2NoYXJ0cyc7XG5leHBvcnQgKiBmcm9tICcuL2Rhc2hib2FyZHMnO1xuIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFpQkE7QUFFQTtBQU1BO0FBQ0E7QUFDQTtBQUNBOyIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./src/common/hooks/apiResources/index.ts\n");

/***/ }),

/***/ "./src/dashboard/containers/DashboardPage.tsx":
/*!****************************************************!*\
  !*** ./src/dashboard/containers/DashboardPage.tsx ***!
  \****************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* WEBPACK VAR INJECTION */(function(module) {/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"./node_modules/react/index.js\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @superset-ui/core */ \"./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js\");\n/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-redux */ \"./node_modules/react-redux/es/index.js\");\n/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-router-dom */ \"./node_modules/react-router/esm/react-router.js\");\n/* harmony import */ var src_messageToasts_enhancers_withToasts__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/messageToasts/enhancers/withToasts */ \"./src/messageToasts/enhancers/withToasts.tsx\");\n/* harmony import */ var src_components_Loading__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! src/components/Loading */ \"./src/components/Loading/index.tsx\");\n/* harmony import */ var src_common_hooks_apiResources__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! src/common/hooks/apiResources */ \"./src/common/hooks/apiResources/index.ts\");\n/* harmony import */ var src_dashboard_actions_hydrate__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! src/dashboard/actions/hydrate */ \"./src/dashboard/actions/hydrate.js\");\n/* harmony import */ var src_dashboard_actions_datasources__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! src/dashboard/actions/datasources */ \"./src/dashboard/actions/datasources.ts\");\n/* harmony import */ var src_dashboard_util_injectCustomCss__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! src/dashboard/util/injectCustomCss */ \"./src/dashboard/util/injectCustomCss.ts\");\n/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @emotion/react */ \"./node_modules/@emotion/react/dist/emotion-react.browser.esm.js\");\n(function () {var enterModule = typeof reactHotLoaderGlobal !== 'undefined' ? reactHotLoaderGlobal.enterModule : undefined;enterModule && enterModule(module);})();var __signature__ = typeof reactHotLoaderGlobal !== 'undefined' ? reactHotLoaderGlobal.default.signature : function (a) {return a;}; /**\n * Licensed to the Apache Software Foundation (ASF) under one\n * or more contributor license agreements.  See the NOTICE file\n * distributed with this work for additional information\n * regarding copyright ownership.  The ASF licenses this file\n * to you under the Apache License, Version 2.0 (the\n * \"License\"); you may not use this file except in compliance\n * with the License.  You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing,\n * software distributed under the License is distributed on an\n * \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n * KIND, either express or implied.  See the License for the\n * specific language governing permissions and limitations\n * under the License.\n */\n\n\n\n\n\n\n\n\n\n\nconst DashboardContainer = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.lazy(() => Promise.all(/*! import() | DashboardContainer */[__webpack_require__.e(\"vendors\"), __webpack_require__.e(\"DashboardContainer\")]).then(__webpack_require__.bind(null, /*! src/dashboard/containers/Dashboard */ \"./src/dashboard/containers/Dashboard.ts\")));\nconst DashboardPage = () => {\n  const dispatch = Object(react_redux__WEBPACK_IMPORTED_MODULE_2__[\"useDispatch\"])();\n  const { addDangerToast } = Object(src_messageToasts_enhancers_withToasts__WEBPACK_IMPORTED_MODULE_4__[\"useToasts\"])();\n  const { idOrSlug } = Object(react_router_dom__WEBPACK_IMPORTED_MODULE_3__[\"useParams\"])();\n  const { result: dashboard, error: dashboardApiError } = Object(src_common_hooks_apiResources__WEBPACK_IMPORTED_MODULE_6__[\"useDashboard\"])(idOrSlug);\n  const { result: charts, error: chartsApiError } = Object(src_common_hooks_apiResources__WEBPACK_IMPORTED_MODULE_6__[\"useDashboardCharts\"])(idOrSlug);\n  const { result: datasets, error: datasetsApiError } = Object(src_common_hooks_apiResources__WEBPACK_IMPORTED_MODULE_6__[\"useDashboardDatasets\"])(idOrSlug);\n  const error = dashboardApiError || chartsApiError;\n  const readyToRender = Boolean(dashboard && charts);\n  const { dashboard_title, css } = dashboard || {};\n  Object(react__WEBPACK_IMPORTED_MODULE_0__[\"useEffect\"])(() => {\n    if (readyToRender) {\n      dispatch(Object(src_dashboard_actions_hydrate__WEBPACK_IMPORTED_MODULE_7__[\"hydrateDashboard\"])(dashboard, charts));\n    }\n    // eslint-disable-next-line react-hooks/exhaustive-deps\n  }, [readyToRender]);\n  Object(react__WEBPACK_IMPORTED_MODULE_0__[\"useEffect\"])(() => {\n    if (dashboard_title) {\n      document.title = dashboard_title;\n    }\n  }, [dashboard_title]);\n  Object(react__WEBPACK_IMPORTED_MODULE_0__[\"useEffect\"])(() => {\n    if (css) {\n      // returning will clean up custom css\n      // when dashboard unmounts or changes\n      return Object(src_dashboard_util_injectCustomCss__WEBPACK_IMPORTED_MODULE_9__[\"default\"])(css);\n    }\n    return () => {};\n  }, [css]);\n  Object(react__WEBPACK_IMPORTED_MODULE_0__[\"useEffect\"])(() => {\n    if (datasetsApiError) {\n      addDangerToast(Object(_superset_ui_core__WEBPACK_IMPORTED_MODULE_1__[\"t\"])('Error loading chart datasources. Filters may not work correctly.'));\n    } else\n    {\n      dispatch(Object(src_dashboard_actions_datasources__WEBPACK_IMPORTED_MODULE_8__[\"setDatasources\"])(datasets));\n    }\n  }, [addDangerToast, datasets, datasetsApiError, dispatch]);\n  if (error)\n  throw error; // caught in error boundary\n  if (!readyToRender)\n  return Object(_emotion_react__WEBPACK_IMPORTED_MODULE_10__[\"jsx\"])(src_components_Loading__WEBPACK_IMPORTED_MODULE_5__[\"default\"], null);\n  return Object(_emotion_react__WEBPACK_IMPORTED_MODULE_10__[\"jsx\"])(DashboardContainer, null);\n};__signature__(DashboardPage, \"useDispatch{dispatch}\\nuseToasts{{ addDangerToast }}\\nuseParams{{ idOrSlug }}\\nuseDashboard{{ result: dashboard, error: dashboardApiError }}\\nuseDashboardCharts{{ result: charts, error: chartsApiError }}\\nuseDashboardDatasets{{ result: datasets, error: datasetsApiError }}\\nuseEffect{}\\nuseEffect{}\\nuseEffect{}\\nuseEffect{}\", () => [react_redux__WEBPACK_IMPORTED_MODULE_2__[\"useDispatch\"], src_messageToasts_enhancers_withToasts__WEBPACK_IMPORTED_MODULE_4__[\"useToasts\"], react_router_dom__WEBPACK_IMPORTED_MODULE_3__[\"useParams\"], src_common_hooks_apiResources__WEBPACK_IMPORTED_MODULE_6__[\"useDashboard\"], src_common_hooks_apiResources__WEBPACK_IMPORTED_MODULE_6__[\"useDashboardCharts\"], src_common_hooks_apiResources__WEBPACK_IMPORTED_MODULE_6__[\"useDashboardDatasets\"]]);const _default =\nDashboardPage;/* harmony default export */ __webpack_exports__[\"default\"] = (_default);;(function () {var reactHotLoader = typeof reactHotLoaderGlobal !== 'undefined' ? reactHotLoaderGlobal.default : undefined;if (!reactHotLoader) {return;}reactHotLoader.register(DashboardContainer, \"DashboardContainer\", \"/Users/admin/Git/Public/spotrix/spotrix-frontend/src/dashboard/containers/DashboardPage.tsx\");reactHotLoader.register(DashboardPage, \"DashboardPage\", \"/Users/admin/Git/Public/spotrix/spotrix-frontend/src/dashboard/containers/DashboardPage.tsx\");reactHotLoader.register(_default, \"default\", \"/Users/admin/Git/Public/spotrix/spotrix-frontend/src/dashboard/containers/DashboardPage.tsx\");})();;(function () {var leaveModule = typeof reactHotLoaderGlobal !== 'undefined' ? reactHotLoaderGlobal.leaveModule : undefined;leaveModule && leaveModule(module);})();\n/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! ./../../../node_modules/webpack/buildin/harmony-module.js */ \"./node_modules/webpack/buildin/harmony-module.js\")(module)))//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/dashboard/containers/DashboardPage.tsx\n");

/***/ }),

/***/ "./src/dashboard/util/injectCustomCss.ts":
/*!***********************************************!*\
  !*** ./src/dashboard/util/injectCustomCss.ts ***!
  \***********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* WEBPACK VAR INJECTION */(function(module) {/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return injectCustomCss; });\n(function () {var enterModule = typeof reactHotLoaderGlobal !== 'undefined' ? reactHotLoaderGlobal.enterModule : undefined;enterModule && enterModule(module);})();var __signature__ = typeof reactHotLoaderGlobal !== 'undefined' ? reactHotLoaderGlobal.default.signature : function (a) {return a;}; /**\n * Licensed to the Apache Software Foundation (ASF) under one\n * or more contributor license agreements.  See the NOTICE file\n * distributed with this work for additional information\n * regarding copyright ownership.  The ASF licenses this file\n * to you under the Apache License, Version 2.0 (the\n * \"License\"); you may not use this file except in compliance\n * with the License.  You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing,\n * software distributed under the License is distributed on an\n * \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n * KIND, either express or implied.  See the License for the\n * specific language governing permissions and limitations\n * under the License.\n */\nfunction createStyleElement(className) {\n  const style = document.createElement('style');\n  style.className = className;\n  style.type = 'text/css';\n  return style;\n}\nfunction injectCustomCss(css) {\n  const className = 'CssEditor-css';\n  const head = document.head || document.getElementsByTagName('head')[0];\n  const style = document.querySelector(`.${className}`) || createStyleElement(className);\n  if ('styleSheet' in style) {\n    style.styleSheet.cssText = css;\n  } else\n  {\n    style.innerHTML = css;\n  }\n  /**\n   * Ensures that the style applied is always the last.\n   *\n   * from: https://developer.mozilla.org/en-US/docs/Web/API/Node/appendChild\n   * The Node.appendChild() method adds a node to the end of the list of children\n   * of a specified parent node. If the given child is a reference to an existing\n   * node in the document, appendChild() moves it from its current position to the\n   * new position (there is no requirement to remove the node from its parent node\n   * before appending it to some other node).\n   */\n  head.appendChild(style);\n  return function removeCustomCSS() {\n    style.remove();\n  };\n};(function () {var reactHotLoader = typeof reactHotLoaderGlobal !== 'undefined' ? reactHotLoaderGlobal.default : undefined;if (!reactHotLoader) {return;}reactHotLoader.register(createStyleElement, \"createStyleElement\", \"/Users/admin/Git/Public/spotrix/spotrix-frontend/src/dashboard/util/injectCustomCss.ts\");reactHotLoader.register(injectCustomCss, \"injectCustomCss\", \"/Users/admin/Git/Public/spotrix/spotrix-frontend/src/dashboard/util/injectCustomCss.ts\");})();;(function () {var leaveModule = typeof reactHotLoaderGlobal !== 'undefined' ? reactHotLoaderGlobal.leaveModule : undefined;leaveModule && leaveModule(module);})();\n/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! ./../../../node_modules/webpack/buildin/harmony-module.js */ \"./node_modules/webpack/buildin/harmony-module.js\")(module)))//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/dashboard/util/injectCustomCss.ts\n");

/***/ })

}]);