(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[37],{

/***/ "./node_modules/@superset-ui/legacy-plugin-chart-map-box/esm/transformProps.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@superset-ui/legacy-plugin-chart-map-box/esm/transformProps.js ***!
  \*************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return transformProps; });\n/* harmony import */ var supercluster__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! supercluster */ \"./node_modules/supercluster/index.js\");\n/* harmony import */ var _MapBox__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./MapBox */ \"./node_modules/@superset-ui/legacy-plugin-chart-map-box/esm/MapBox.js\");\n/**\n * Licensed to the Apache Software Foundation (ASF) under one\n * or more contributor license agreements.  See the NOTICE file\n * distributed with this work for additional information\n * regarding copyright ownership.  The ASF licenses this file\n * to you under the Apache License, Version 2.0 (the\n * \"License\"); you may not use this file except in compliance\n * with the License.  You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing,\n * software distributed under the License is distributed on an\n * \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n * KIND, either express or implied.  See the License for the\n * specific language governing permissions and limitations\n * under the License.\n */\n\n\n\nconst NOOP = () => {};\n\nfunction transformProps(chartProps) {\n  const {\n    width,\n    height,\n    formData,\n    hooks,\n    queriesData\n  } = chartProps;\n  const {\n    onError = NOOP,\n    setControlValue = NOOP\n  } = hooks;\n  const {\n    bounds,\n    geoJSON,\n    hasCustomMetric,\n    mapboxApiKey\n  } = queriesData[0].data;\n  const {\n    clusteringRadius,\n    globalOpacity,\n    mapboxColor,\n    mapboxStyle,\n    pandasAggfunc,\n    pointRadius,\n    pointRadiusUnit,\n    renderWhileDragging\n  } = formData; // Validate mapbox color\n\n  const rgb = /^rgb\\((\\d{1,3}),\\s*(\\d{1,3}),\\s*(\\d{1,3})\\)$/.exec(mapboxColor);\n\n  if (rgb === null) {\n    onError(\"Color field must be of form 'rgb(%d, %d, %d)'\");\n    return {};\n  }\n\n  const opts = {\n    maxZoom: _MapBox__WEBPACK_IMPORTED_MODULE_1__[\"DEFAULT_MAX_ZOOM\"],\n    radius: clusteringRadius\n  };\n\n  if (hasCustomMetric) {\n    opts.initial = () => ({\n      sum: 0,\n      squaredSum: 0,\n      min: Infinity,\n      max: -Infinity\n    });\n\n    opts.map = prop => ({\n      sum: prop.metric,\n      squaredSum: prop.metric ** 2,\n      min: prop.metric,\n      max: prop.metric\n    });\n\n    opts.reduce = (accu, prop) => {\n      // Temporarily disable param-reassignment linting to work with supercluster's api\n\n      /* eslint-disable no-param-reassign */\n      accu.sum += prop.sum;\n      accu.squaredSum += prop.squaredSum;\n      accu.min = Math.min(accu.min, prop.min);\n      accu.max = Math.max(accu.max, prop.max);\n      /* eslint-enable no-param-reassign */\n    };\n  }\n\n  const clusterer = Object(supercluster__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(opts);\n  clusterer.load(geoJSON.features);\n  return {\n    width,\n    height,\n    aggregatorName: pandasAggfunc,\n    bounds,\n    clusterer,\n    globalOpacity,\n    hasCustomMetric,\n    mapboxApiKey,\n    mapStyle: mapboxStyle,\n\n    onViewportChange({\n      latitude,\n      longitude,\n      zoom\n    }) {\n      setControlValue('viewport_longitude', longitude);\n      setControlValue('viewport_latitude', latitude);\n      setControlValue('viewport_zoom', zoom);\n    },\n\n    pointRadius: pointRadius === 'Auto' ? _MapBox__WEBPACK_IMPORTED_MODULE_1__[\"DEFAULT_POINT_RADIUS\"] : pointRadius,\n    pointRadiusUnit,\n    renderWhileDragging,\n    rgb\n  };\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@superset-ui/legacy-plugin-chart-map-box/esm/transformProps.js\n");

/***/ }),

/***/ "./node_modules/supercluster/index.js":
/*!********************************************!*\
  !*** ./node_modules/supercluster/index.js ***!
  \********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return supercluster; });\n/* harmony import */ var kdbush__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! kdbush */ \"./node_modules/supercluster/node_modules/kdbush/src/index.js\");\n\n\n\nfunction supercluster(options) {\n    return new SuperCluster(options);\n}\n\nfunction SuperCluster(options) {\n    this.options = extend(Object.create(this.options), options);\n    this.trees = new Array(this.options.maxZoom + 1);\n}\n\nSuperCluster.prototype = {\n    options: {\n        minZoom: 0,   // min zoom to generate clusters on\n        maxZoom: 16,  // max zoom level to cluster the points on\n        radius: 40,   // cluster radius in pixels\n        extent: 512,  // tile extent (radius is calculated relative to it)\n        nodeSize: 64, // size of the KD-tree leaf node, affects performance\n        log: false,   // whether to log timing info\n\n        // a reduce function for calculating custom cluster properties\n        reduce: null, // function (accumulated, props) { accumulated.sum += props.sum; }\n\n        // initial properties of a cluster (before running the reducer)\n        initial: function () { return {}; }, // function () { return {sum: 0}; },\n\n        // properties to use for individual points when running the reducer\n        map: function (props) { return props; } // function (props) { return {sum: props.my_value}; },\n    },\n\n    load: function (points) {\n        var log = this.options.log;\n\n        if (log) console.time('total time');\n\n        var timerId = 'prepare ' + points.length + ' points';\n        if (log) console.time(timerId);\n\n        this.points = points;\n\n        // generate a cluster object for each point and index input points into a KD-tree\n        var clusters = [];\n        for (var i = 0; i < points.length; i++) {\n            if (!points[i].geometry) {\n                continue;\n            }\n            clusters.push(createPointCluster(points[i], i));\n        }\n        this.trees[this.options.maxZoom + 1] = Object(kdbush__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(clusters, getX, getY, this.options.nodeSize, Float32Array);\n\n        if (log) console.timeEnd(timerId);\n\n        // cluster points on max zoom, then cluster the results on previous zoom, etc.;\n        // results in a cluster hierarchy across zoom levels\n        for (var z = this.options.maxZoom; z >= this.options.minZoom; z--) {\n            var now = +Date.now();\n\n            // create a new set of clusters for the zoom and index them with a KD-tree\n            clusters = this._cluster(clusters, z);\n            this.trees[z] = Object(kdbush__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(clusters, getX, getY, this.options.nodeSize, Float32Array);\n\n            if (log) console.log('z%d: %d clusters in %dms', z, clusters.length, +Date.now() - now);\n        }\n\n        if (log) console.timeEnd('total time');\n\n        return this;\n    },\n\n    getClusters: function (bbox, zoom) {\n        var minLng = ((bbox[0] + 180) % 360 + 360) % 360 - 180;\n        var minLat = Math.max(-90, Math.min(90, bbox[1]));\n        var maxLng = bbox[2] === 180 ? 180 : ((bbox[2] + 180) % 360 + 360) % 360 - 180;\n        var maxLat = Math.max(-90, Math.min(90, bbox[3]));\n\n        if (bbox[2] - bbox[0] >= 360) {\n            minLng = -180;\n            maxLng = 180;\n        } else if (minLng > maxLng) {\n            var easternHem = this.getClusters([minLng, minLat, 180, maxLat], zoom);\n            var westernHem = this.getClusters([-180, minLat, maxLng, maxLat], zoom);\n            return easternHem.concat(westernHem);\n        }\n\n        var tree = this.trees[this._limitZoom(zoom)];\n        var ids = tree.range(lngX(minLng), latY(maxLat), lngX(maxLng), latY(minLat));\n        var clusters = [];\n        for (var i = 0; i < ids.length; i++) {\n            var c = tree.points[ids[i]];\n            clusters.push(c.numPoints ? getClusterJSON(c) : this.points[c.index]);\n        }\n        return clusters;\n    },\n\n    getChildren: function (clusterId) {\n        var originId = clusterId >> 5;\n        var originZoom = clusterId % 32;\n        var errorMsg = 'No cluster with the specified id.';\n\n        var index = this.trees[originZoom];\n        if (!index) throw new Error(errorMsg);\n\n        var origin = index.points[originId];\n        if (!origin) throw new Error(errorMsg);\n\n        var r = this.options.radius / (this.options.extent * Math.pow(2, originZoom - 1));\n        var ids = index.within(origin.x, origin.y, r);\n        var children = [];\n        for (var i = 0; i < ids.length; i++) {\n            var c = index.points[ids[i]];\n            if (c.parentId === clusterId) {\n                children.push(c.numPoints ? getClusterJSON(c) : this.points[c.index]);\n            }\n        }\n\n        if (children.length === 0) throw new Error(errorMsg);\n\n        return children;\n    },\n\n    getLeaves: function (clusterId, limit, offset) {\n        limit = limit || 10;\n        offset = offset || 0;\n\n        var leaves = [];\n        this._appendLeaves(leaves, clusterId, limit, offset, 0);\n\n        return leaves;\n    },\n\n    getTile: function (z, x, y) {\n        var tree = this.trees[this._limitZoom(z)];\n        var z2 = Math.pow(2, z);\n        var extent = this.options.extent;\n        var r = this.options.radius;\n        var p = r / extent;\n        var top = (y - p) / z2;\n        var bottom = (y + 1 + p) / z2;\n\n        var tile = {\n            features: []\n        };\n\n        this._addTileFeatures(\n            tree.range((x - p) / z2, top, (x + 1 + p) / z2, bottom),\n            tree.points, x, y, z2, tile);\n\n        if (x === 0) {\n            this._addTileFeatures(\n                tree.range(1 - p / z2, top, 1, bottom),\n                tree.points, z2, y, z2, tile);\n        }\n        if (x === z2 - 1) {\n            this._addTileFeatures(\n                tree.range(0, top, p / z2, bottom),\n                tree.points, -1, y, z2, tile);\n        }\n\n        return tile.features.length ? tile : null;\n    },\n\n    getClusterExpansionZoom: function (clusterId) {\n        var clusterZoom = (clusterId % 32) - 1;\n        while (clusterZoom < this.options.maxZoom) {\n            var children = this.getChildren(clusterId);\n            clusterZoom++;\n            if (children.length !== 1) break;\n            clusterId = children[0].properties.cluster_id;\n        }\n        return clusterZoom;\n    },\n\n    _appendLeaves: function (result, clusterId, limit, offset, skipped) {\n        var children = this.getChildren(clusterId);\n\n        for (var i = 0; i < children.length; i++) {\n            var props = children[i].properties;\n\n            if (props && props.cluster) {\n                if (skipped + props.point_count <= offset) {\n                    // skip the whole cluster\n                    skipped += props.point_count;\n                } else {\n                    // enter the cluster\n                    skipped = this._appendLeaves(result, props.cluster_id, limit, offset, skipped);\n                    // exit the cluster\n                }\n            } else if (skipped < offset) {\n                // skip a single point\n                skipped++;\n            } else {\n                // add a single point\n                result.push(children[i]);\n            }\n            if (result.length === limit) break;\n        }\n\n        return skipped;\n    },\n\n    _addTileFeatures: function (ids, points, x, y, z2, tile) {\n        for (var i = 0; i < ids.length; i++) {\n            var c = points[ids[i]];\n            var f = {\n                type: 1,\n                geometry: [[\n                    Math.round(this.options.extent * (c.x * z2 - x)),\n                    Math.round(this.options.extent * (c.y * z2 - y))\n                ]],\n                tags: c.numPoints ? getClusterProperties(c) : this.points[c.index].properties\n            };\n            var id = c.numPoints ? c.id : this.points[c.index].id;\n            if (id !== undefined) {\n                f.id = id;\n            }\n            tile.features.push(f);\n        }\n    },\n\n    _limitZoom: function (z) {\n        return Math.max(this.options.minZoom, Math.min(z, this.options.maxZoom + 1));\n    },\n\n    _cluster: function (points, zoom) {\n        var clusters = [];\n        var r = this.options.radius / (this.options.extent * Math.pow(2, zoom));\n\n        // loop through each point\n        for (var i = 0; i < points.length; i++) {\n            var p = points[i];\n            // if we've already visited the point at this zoom level, skip it\n            if (p.zoom <= zoom) continue;\n            p.zoom = zoom;\n\n            // find all nearby points\n            var tree = this.trees[zoom + 1];\n            var neighborIds = tree.within(p.x, p.y, r);\n\n            var numPoints = p.numPoints || 1;\n            var wx = p.x * numPoints;\n            var wy = p.y * numPoints;\n\n            var clusterProperties = null;\n\n            if (this.options.reduce) {\n                clusterProperties = this.options.initial();\n                this._accumulate(clusterProperties, p);\n            }\n\n            // encode both zoom and point index on which the cluster originated\n            var id = (i << 5) + (zoom + 1);\n\n            for (var j = 0; j < neighborIds.length; j++) {\n                var b = tree.points[neighborIds[j]];\n                // filter out neighbors that are already processed\n                if (b.zoom <= zoom) continue;\n                b.zoom = zoom; // save the zoom (so it doesn't get processed twice)\n\n                var numPoints2 = b.numPoints || 1;\n                wx += b.x * numPoints2; // accumulate coordinates for calculating weighted center\n                wy += b.y * numPoints2;\n\n                numPoints += numPoints2;\n                b.parentId = id;\n\n                if (this.options.reduce) {\n                    this._accumulate(clusterProperties, b);\n                }\n            }\n\n            if (numPoints === 1) {\n                clusters.push(p);\n            } else {\n                p.parentId = id;\n                clusters.push(createCluster(wx / numPoints, wy / numPoints, id, numPoints, clusterProperties));\n            }\n        }\n\n        return clusters;\n    },\n\n    _accumulate: function (clusterProperties, point) {\n        var properties = point.numPoints ?\n            point.properties :\n            this.options.map(this.points[point.index].properties);\n\n        this.options.reduce(clusterProperties, properties);\n    }\n};\n\nfunction createCluster(x, y, id, numPoints, properties) {\n    return {\n        x: x, // weighted cluster center\n        y: y,\n        zoom: Infinity, // the last zoom the cluster was processed at\n        id: id, // encodes index of the first child of the cluster and its zoom level\n        parentId: -1, // parent cluster id\n        numPoints: numPoints,\n        properties: properties\n    };\n}\n\nfunction createPointCluster(p, id) {\n    var coords = p.geometry.coordinates;\n    return {\n        x: lngX(coords[0]), // projected point coordinates\n        y: latY(coords[1]),\n        zoom: Infinity, // the last zoom the point was processed at\n        index: id, // index of the source feature in the original input array,\n        parentId: -1 // parent cluster id\n    };\n}\n\nfunction getClusterJSON(cluster) {\n    return {\n        type: 'Feature',\n        id: cluster.id,\n        properties: getClusterProperties(cluster),\n        geometry: {\n            type: 'Point',\n            coordinates: [xLng(cluster.x), yLat(cluster.y)]\n        }\n    };\n}\n\nfunction getClusterProperties(cluster) {\n    var count = cluster.numPoints;\n    var abbrev =\n        count >= 10000 ? Math.round(count / 1000) + 'k' :\n        count >= 1000 ? (Math.round(count / 100) / 10) + 'k' : count;\n    return extend(extend({}, cluster.properties), {\n        cluster: true,\n        cluster_id: cluster.id,\n        point_count: count,\n        point_count_abbreviated: abbrev\n    });\n}\n\n// longitude/latitude to spherical mercator in [0..1] range\nfunction lngX(lng) {\n    return lng / 360 + 0.5;\n}\nfunction latY(lat) {\n    var sin = Math.sin(lat * Math.PI / 180),\n        y = (0.5 - 0.25 * Math.log((1 + sin) / (1 - sin)) / Math.PI);\n    return y < 0 ? 0 : y > 1 ? 1 : y;\n}\n\n// spherical mercator to longitude/latitude\nfunction xLng(x) {\n    return (x - 0.5) * 360;\n}\nfunction yLat(y) {\n    var y2 = (180 - y * 360) * Math.PI / 180;\n    return 360 * Math.atan(Math.exp(y2)) / Math.PI - 90;\n}\n\nfunction extend(dest, src) {\n    for (var id in src) dest[id] = src[id];\n    return dest;\n}\n\nfunction getX(p) {\n    return p.x;\n}\nfunction getY(p) {\n    return p.y;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvc3VwZXJjbHVzdGVyL2luZGV4LmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL3N1cGVyY2x1c3Rlci9pbmRleC5qcz82ZmY2Il0sInNvdXJjZXNDb250ZW50IjpbIlxuaW1wb3J0IGtkYnVzaCBmcm9tICdrZGJ1c2gnO1xuXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiBzdXBlcmNsdXN0ZXIob3B0aW9ucykge1xuICAgIHJldHVybiBuZXcgU3VwZXJDbHVzdGVyKG9wdGlvbnMpO1xufVxuXG5mdW5jdGlvbiBTdXBlckNsdXN0ZXIob3B0aW9ucykge1xuICAgIHRoaXMub3B0aW9ucyA9IGV4dGVuZChPYmplY3QuY3JlYXRlKHRoaXMub3B0aW9ucyksIG9wdGlvbnMpO1xuICAgIHRoaXMudHJlZXMgPSBuZXcgQXJyYXkodGhpcy5vcHRpb25zLm1heFpvb20gKyAxKTtcbn1cblxuU3VwZXJDbHVzdGVyLnByb3RvdHlwZSA9IHtcbiAgICBvcHRpb25zOiB7XG4gICAgICAgIG1pblpvb206IDAsICAgLy8gbWluIHpvb20gdG8gZ2VuZXJhdGUgY2x1c3RlcnMgb25cbiAgICAgICAgbWF4Wm9vbTogMTYsICAvLyBtYXggem9vbSBsZXZlbCB0byBjbHVzdGVyIHRoZSBwb2ludHMgb25cbiAgICAgICAgcmFkaXVzOiA0MCwgICAvLyBjbHVzdGVyIHJhZGl1cyBpbiBwaXhlbHNcbiAgICAgICAgZXh0ZW50OiA1MTIsICAvLyB0aWxlIGV4dGVudCAocmFkaXVzIGlzIGNhbGN1bGF0ZWQgcmVsYXRpdmUgdG8gaXQpXG4gICAgICAgIG5vZGVTaXplOiA2NCwgLy8gc2l6ZSBvZiB0aGUgS0QtdHJlZSBsZWFmIG5vZGUsIGFmZmVjdHMgcGVyZm9ybWFuY2VcbiAgICAgICAgbG9nOiBmYWxzZSwgICAvLyB3aGV0aGVyIHRvIGxvZyB0aW1pbmcgaW5mb1xuXG4gICAgICAgIC8vIGEgcmVkdWNlIGZ1bmN0aW9uIGZvciBjYWxjdWxhdGluZyBjdXN0b20gY2x1c3RlciBwcm9wZXJ0aWVzXG4gICAgICAgIHJlZHVjZTogbnVsbCwgLy8gZnVuY3Rpb24gKGFjY3VtdWxhdGVkLCBwcm9wcykgeyBhY2N1bXVsYXRlZC5zdW0gKz0gcHJvcHMuc3VtOyB9XG5cbiAgICAgICAgLy8gaW5pdGlhbCBwcm9wZXJ0aWVzIG9mIGEgY2x1c3RlciAoYmVmb3JlIHJ1bm5pbmcgdGhlIHJlZHVjZXIpXG4gICAgICAgIGluaXRpYWw6IGZ1bmN0aW9uICgpIHsgcmV0dXJuIHt9OyB9LCAvLyBmdW5jdGlvbiAoKSB7IHJldHVybiB7c3VtOiAwfTsgfSxcblxuICAgICAgICAvLyBwcm9wZXJ0aWVzIHRvIHVzZSBmb3IgaW5kaXZpZHVhbCBwb2ludHMgd2hlbiBydW5uaW5nIHRoZSByZWR1Y2VyXG4gICAgICAgIG1hcDogZnVuY3Rpb24gKHByb3BzKSB7IHJldHVybiBwcm9wczsgfSAvLyBmdW5jdGlvbiAocHJvcHMpIHsgcmV0dXJuIHtzdW06IHByb3BzLm15X3ZhbHVlfTsgfSxcbiAgICB9LFxuXG4gICAgbG9hZDogZnVuY3Rpb24gKHBvaW50cykge1xuICAgICAgICB2YXIgbG9nID0gdGhpcy5vcHRpb25zLmxvZztcblxuICAgICAgICBpZiAobG9nKSBjb25zb2xlLnRpbWUoJ3RvdGFsIHRpbWUnKTtcblxuICAgICAgICB2YXIgdGltZXJJZCA9ICdwcmVwYXJlICcgKyBwb2ludHMubGVuZ3RoICsgJyBwb2ludHMnO1xuICAgICAgICBpZiAobG9nKSBjb25zb2xlLnRpbWUodGltZXJJZCk7XG5cbiAgICAgICAgdGhpcy5wb2ludHMgPSBwb2ludHM7XG5cbiAgICAgICAgLy8gZ2VuZXJhdGUgYSBjbHVzdGVyIG9iamVjdCBmb3IgZWFjaCBwb2ludCBhbmQgaW5kZXggaW5wdXQgcG9pbnRzIGludG8gYSBLRC10cmVlXG4gICAgICAgIHZhciBjbHVzdGVycyA9IFtdO1xuICAgICAgICBmb3IgKHZhciBpID0gMDsgaSA8IHBvaW50cy5sZW5ndGg7IGkrKykge1xuICAgICAgICAgICAgaWYgKCFwb2ludHNbaV0uZ2VvbWV0cnkpIHtcbiAgICAgICAgICAgICAgICBjb250aW51ZTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGNsdXN0ZXJzLnB1c2goY3JlYXRlUG9pbnRDbHVzdGVyKHBvaW50c1tpXSwgaSkpO1xuICAgICAgICB9XG4gICAgICAgIHRoaXMudHJlZXNbdGhpcy5vcHRpb25zLm1heFpvb20gKyAxXSA9IGtkYnVzaChjbHVzdGVycywgZ2V0WCwgZ2V0WSwgdGhpcy5vcHRpb25zLm5vZGVTaXplLCBGbG9hdDMyQXJyYXkpO1xuXG4gICAgICAgIGlmIChsb2cpIGNvbnNvbGUudGltZUVuZCh0aW1lcklkKTtcblxuICAgICAgICAvLyBjbHVzdGVyIHBvaW50cyBvbiBtYXggem9vbSwgdGhlbiBjbHVzdGVyIHRoZSByZXN1bHRzIG9uIHByZXZpb3VzIHpvb20sIGV0Yy47XG4gICAgICAgIC8vIHJlc3VsdHMgaW4gYSBjbHVzdGVyIGhpZXJhcmNoeSBhY3Jvc3Mgem9vbSBsZXZlbHNcbiAgICAgICAgZm9yICh2YXIgeiA9IHRoaXMub3B0aW9ucy5tYXhab29tOyB6ID49IHRoaXMub3B0aW9ucy5taW5ab29tOyB6LS0pIHtcbiAgICAgICAgICAgIHZhciBub3cgPSArRGF0ZS5ub3coKTtcblxuICAgICAgICAgICAgLy8gY3JlYXRlIGEgbmV3IHNldCBvZiBjbHVzdGVycyBmb3IgdGhlIHpvb20gYW5kIGluZGV4IHRoZW0gd2l0aCBhIEtELXRyZWVcbiAgICAgICAgICAgIGNsdXN0ZXJzID0gdGhpcy5fY2x1c3RlcihjbHVzdGVycywgeik7XG4gICAgICAgICAgICB0aGlzLnRyZWVzW3pdID0ga2RidXNoKGNsdXN0ZXJzLCBnZXRYLCBnZXRZLCB0aGlzLm9wdGlvbnMubm9kZVNpemUsIEZsb2F0MzJBcnJheSk7XG5cbiAgICAgICAgICAgIGlmIChsb2cpIGNvbnNvbGUubG9nKCd6JWQ6ICVkIGNsdXN0ZXJzIGluICVkbXMnLCB6LCBjbHVzdGVycy5sZW5ndGgsICtEYXRlLm5vdygpIC0gbm93KTtcbiAgICAgICAgfVxuXG4gICAgICAgIGlmIChsb2cpIGNvbnNvbGUudGltZUVuZCgndG90YWwgdGltZScpO1xuXG4gICAgICAgIHJldHVybiB0aGlzO1xuICAgIH0sXG5cbiAgICBnZXRDbHVzdGVyczogZnVuY3Rpb24gKGJib3gsIHpvb20pIHtcbiAgICAgICAgdmFyIG1pbkxuZyA9ICgoYmJveFswXSArIDE4MCkgJSAzNjAgKyAzNjApICUgMzYwIC0gMTgwO1xuICAgICAgICB2YXIgbWluTGF0ID0gTWF0aC5tYXgoLTkwLCBNYXRoLm1pbig5MCwgYmJveFsxXSkpO1xuICAgICAgICB2YXIgbWF4TG5nID0gYmJveFsyXSA9PT0gMTgwID8gMTgwIDogKChiYm94WzJdICsgMTgwKSAlIDM2MCArIDM2MCkgJSAzNjAgLSAxODA7XG4gICAgICAgIHZhciBtYXhMYXQgPSBNYXRoLm1heCgtOTAsIE1hdGgubWluKDkwLCBiYm94WzNdKSk7XG5cbiAgICAgICAgaWYgKGJib3hbMl0gLSBiYm94WzBdID49IDM2MCkge1xuICAgICAgICAgICAgbWluTG5nID0gLTE4MDtcbiAgICAgICAgICAgIG1heExuZyA9IDE4MDtcbiAgICAgICAgfSBlbHNlIGlmIChtaW5MbmcgPiBtYXhMbmcpIHtcbiAgICAgICAgICAgIHZhciBlYXN0ZXJuSGVtID0gdGhpcy5nZXRDbHVzdGVycyhbbWluTG5nLCBtaW5MYXQsIDE4MCwgbWF4TGF0XSwgem9vbSk7XG4gICAgICAgICAgICB2YXIgd2VzdGVybkhlbSA9IHRoaXMuZ2V0Q2x1c3RlcnMoWy0xODAsIG1pbkxhdCwgbWF4TG5nLCBtYXhMYXRdLCB6b29tKTtcbiAgICAgICAgICAgIHJldHVybiBlYXN0ZXJuSGVtLmNvbmNhdCh3ZXN0ZXJuSGVtKTtcbiAgICAgICAgfVxuXG4gICAgICAgIHZhciB0cmVlID0gdGhpcy50cmVlc1t0aGlzLl9saW1pdFpvb20oem9vbSldO1xuICAgICAgICB2YXIgaWRzID0gdHJlZS5yYW5nZShsbmdYKG1pbkxuZyksIGxhdFkobWF4TGF0KSwgbG5nWChtYXhMbmcpLCBsYXRZKG1pbkxhdCkpO1xuICAgICAgICB2YXIgY2x1c3RlcnMgPSBbXTtcbiAgICAgICAgZm9yICh2YXIgaSA9IDA7IGkgPCBpZHMubGVuZ3RoOyBpKyspIHtcbiAgICAgICAgICAgIHZhciBjID0gdHJlZS5wb2ludHNbaWRzW2ldXTtcbiAgICAgICAgICAgIGNsdXN0ZXJzLnB1c2goYy5udW1Qb2ludHMgPyBnZXRDbHVzdGVySlNPTihjKSA6IHRoaXMucG9pbnRzW2MuaW5kZXhdKTtcbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gY2x1c3RlcnM7XG4gICAgfSxcblxuICAgIGdldENoaWxkcmVuOiBmdW5jdGlvbiAoY2x1c3RlcklkKSB7XG4gICAgICAgIHZhciBvcmlnaW5JZCA9IGNsdXN0ZXJJZCA+PiA1O1xuICAgICAgICB2YXIgb3JpZ2luWm9vbSA9IGNsdXN0ZXJJZCAlIDMyO1xuICAgICAgICB2YXIgZXJyb3JNc2cgPSAnTm8gY2x1c3RlciB3aXRoIHRoZSBzcGVjaWZpZWQgaWQuJztcblxuICAgICAgICB2YXIgaW5kZXggPSB0aGlzLnRyZWVzW29yaWdpblpvb21dO1xuICAgICAgICBpZiAoIWluZGV4KSB0aHJvdyBuZXcgRXJyb3IoZXJyb3JNc2cpO1xuXG4gICAgICAgIHZhciBvcmlnaW4gPSBpbmRleC5wb2ludHNbb3JpZ2luSWRdO1xuICAgICAgICBpZiAoIW9yaWdpbikgdGhyb3cgbmV3IEVycm9yKGVycm9yTXNnKTtcblxuICAgICAgICB2YXIgciA9IHRoaXMub3B0aW9ucy5yYWRpdXMgLyAodGhpcy5vcHRpb25zLmV4dGVudCAqIE1hdGgucG93KDIsIG9yaWdpblpvb20gLSAxKSk7XG4gICAgICAgIHZhciBpZHMgPSBpbmRleC53aXRoaW4ob3JpZ2luLngsIG9yaWdpbi55LCByKTtcbiAgICAgICAgdmFyIGNoaWxkcmVuID0gW107XG4gICAgICAgIGZvciAodmFyIGkgPSAwOyBpIDwgaWRzLmxlbmd0aDsgaSsrKSB7XG4gICAgICAgICAgICB2YXIgYyA9IGluZGV4LnBvaW50c1tpZHNbaV1dO1xuICAgICAgICAgICAgaWYgKGMucGFyZW50SWQgPT09IGNsdXN0ZXJJZCkge1xuICAgICAgICAgICAgICAgIGNoaWxkcmVuLnB1c2goYy5udW1Qb2ludHMgPyBnZXRDbHVzdGVySlNPTihjKSA6IHRoaXMucG9pbnRzW2MuaW5kZXhdKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuXG4gICAgICAgIGlmIChjaGlsZHJlbi5sZW5ndGggPT09IDApIHRocm93IG5ldyBFcnJvcihlcnJvck1zZyk7XG5cbiAgICAgICAgcmV0dXJuIGNoaWxkcmVuO1xuICAgIH0sXG5cbiAgICBnZXRMZWF2ZXM6IGZ1bmN0aW9uIChjbHVzdGVySWQsIGxpbWl0LCBvZmZzZXQpIHtcbiAgICAgICAgbGltaXQgPSBsaW1pdCB8fCAxMDtcbiAgICAgICAgb2Zmc2V0ID0gb2Zmc2V0IHx8IDA7XG5cbiAgICAgICAgdmFyIGxlYXZlcyA9IFtdO1xuICAgICAgICB0aGlzLl9hcHBlbmRMZWF2ZXMobGVhdmVzLCBjbHVzdGVySWQsIGxpbWl0LCBvZmZzZXQsIDApO1xuXG4gICAgICAgIHJldHVybiBsZWF2ZXM7XG4gICAgfSxcblxuICAgIGdldFRpbGU6IGZ1bmN0aW9uICh6LCB4LCB5KSB7XG4gICAgICAgIHZhciB0cmVlID0gdGhpcy50cmVlc1t0aGlzLl9saW1pdFpvb20oeildO1xuICAgICAgICB2YXIgejIgPSBNYXRoLnBvdygyLCB6KTtcbiAgICAgICAgdmFyIGV4dGVudCA9IHRoaXMub3B0aW9ucy5leHRlbnQ7XG4gICAgICAgIHZhciByID0gdGhpcy5vcHRpb25zLnJhZGl1cztcbiAgICAgICAgdmFyIHAgPSByIC8gZXh0ZW50O1xuICAgICAgICB2YXIgdG9wID0gKHkgLSBwKSAvIHoyO1xuICAgICAgICB2YXIgYm90dG9tID0gKHkgKyAxICsgcCkgLyB6MjtcblxuICAgICAgICB2YXIgdGlsZSA9IHtcbiAgICAgICAgICAgIGZlYXR1cmVzOiBbXVxuICAgICAgICB9O1xuXG4gICAgICAgIHRoaXMuX2FkZFRpbGVGZWF0dXJlcyhcbiAgICAgICAgICAgIHRyZWUucmFuZ2UoKHggLSBwKSAvIHoyLCB0b3AsICh4ICsgMSArIHApIC8gejIsIGJvdHRvbSksXG4gICAgICAgICAgICB0cmVlLnBvaW50cywgeCwgeSwgejIsIHRpbGUpO1xuXG4gICAgICAgIGlmICh4ID09PSAwKSB7XG4gICAgICAgICAgICB0aGlzLl9hZGRUaWxlRmVhdHVyZXMoXG4gICAgICAgICAgICAgICAgdHJlZS5yYW5nZSgxIC0gcCAvIHoyLCB0b3AsIDEsIGJvdHRvbSksXG4gICAgICAgICAgICAgICAgdHJlZS5wb2ludHMsIHoyLCB5LCB6MiwgdGlsZSk7XG4gICAgICAgIH1cbiAgICAgICAgaWYgKHggPT09IHoyIC0gMSkge1xuICAgICAgICAgICAgdGhpcy5fYWRkVGlsZUZlYXR1cmVzKFxuICAgICAgICAgICAgICAgIHRyZWUucmFuZ2UoMCwgdG9wLCBwIC8gejIsIGJvdHRvbSksXG4gICAgICAgICAgICAgICAgdHJlZS5wb2ludHMsIC0xLCB5LCB6MiwgdGlsZSk7XG4gICAgICAgIH1cblxuICAgICAgICByZXR1cm4gdGlsZS5mZWF0dXJlcy5sZW5ndGggPyB0aWxlIDogbnVsbDtcbiAgICB9LFxuXG4gICAgZ2V0Q2x1c3RlckV4cGFuc2lvblpvb206IGZ1bmN0aW9uIChjbHVzdGVySWQpIHtcbiAgICAgICAgdmFyIGNsdXN0ZXJab29tID0gKGNsdXN0ZXJJZCAlIDMyKSAtIDE7XG4gICAgICAgIHdoaWxlIChjbHVzdGVyWm9vbSA8IHRoaXMub3B0aW9ucy5tYXhab29tKSB7XG4gICAgICAgICAgICB2YXIgY2hpbGRyZW4gPSB0aGlzLmdldENoaWxkcmVuKGNsdXN0ZXJJZCk7XG4gICAgICAgICAgICBjbHVzdGVyWm9vbSsrO1xuICAgICAgICAgICAgaWYgKGNoaWxkcmVuLmxlbmd0aCAhPT0gMSkgYnJlYWs7XG4gICAgICAgICAgICBjbHVzdGVySWQgPSBjaGlsZHJlblswXS5wcm9wZXJ0aWVzLmNsdXN0ZXJfaWQ7XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIGNsdXN0ZXJab29tO1xuICAgIH0sXG5cbiAgICBfYXBwZW5kTGVhdmVzOiBmdW5jdGlvbiAocmVzdWx0LCBjbHVzdGVySWQsIGxpbWl0LCBvZmZzZXQsIHNraXBwZWQpIHtcbiAgICAgICAgdmFyIGNoaWxkcmVuID0gdGhpcy5nZXRDaGlsZHJlbihjbHVzdGVySWQpO1xuXG4gICAgICAgIGZvciAodmFyIGkgPSAwOyBpIDwgY2hpbGRyZW4ubGVuZ3RoOyBpKyspIHtcbiAgICAgICAgICAgIHZhciBwcm9wcyA9IGNoaWxkcmVuW2ldLnByb3BlcnRpZXM7XG5cbiAgICAgICAgICAgIGlmIChwcm9wcyAmJiBwcm9wcy5jbHVzdGVyKSB7XG4gICAgICAgICAgICAgICAgaWYgKHNraXBwZWQgKyBwcm9wcy5wb2ludF9jb3VudCA8PSBvZmZzZXQpIHtcbiAgICAgICAgICAgICAgICAgICAgLy8gc2tpcCB0aGUgd2hvbGUgY2x1c3RlclxuICAgICAgICAgICAgICAgICAgICBza2lwcGVkICs9IHByb3BzLnBvaW50X2NvdW50O1xuICAgICAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgIC8vIGVudGVyIHRoZSBjbHVzdGVyXG4gICAgICAgICAgICAgICAgICAgIHNraXBwZWQgPSB0aGlzLl9hcHBlbmRMZWF2ZXMocmVzdWx0LCBwcm9wcy5jbHVzdGVyX2lkLCBsaW1pdCwgb2Zmc2V0LCBza2lwcGVkKTtcbiAgICAgICAgICAgICAgICAgICAgLy8gZXhpdCB0aGUgY2x1c3RlclxuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH0gZWxzZSBpZiAoc2tpcHBlZCA8IG9mZnNldCkge1xuICAgICAgICAgICAgICAgIC8vIHNraXAgYSBzaW5nbGUgcG9pbnRcbiAgICAgICAgICAgICAgICBza2lwcGVkKys7XG4gICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgIC8vIGFkZCBhIHNpbmdsZSBwb2ludFxuICAgICAgICAgICAgICAgIHJlc3VsdC5wdXNoKGNoaWxkcmVuW2ldKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGlmIChyZXN1bHQubGVuZ3RoID09PSBsaW1pdCkgYnJlYWs7XG4gICAgICAgIH1cblxuICAgICAgICByZXR1cm4gc2tpcHBlZDtcbiAgICB9LFxuXG4gICAgX2FkZFRpbGVGZWF0dXJlczogZnVuY3Rpb24gKGlkcywgcG9pbnRzLCB4LCB5LCB6MiwgdGlsZSkge1xuICAgICAgICBmb3IgKHZhciBpID0gMDsgaSA8IGlkcy5sZW5ndGg7IGkrKykge1xuICAgICAgICAgICAgdmFyIGMgPSBwb2ludHNbaWRzW2ldXTtcbiAgICAgICAgICAgIHZhciBmID0ge1xuICAgICAgICAgICAgICAgIHR5cGU6IDEsXG4gICAgICAgICAgICAgICAgZ2VvbWV0cnk6IFtbXG4gICAgICAgICAgICAgICAgICAgIE1hdGgucm91bmQodGhpcy5vcHRpb25zLmV4dGVudCAqIChjLnggKiB6MiAtIHgpKSxcbiAgICAgICAgICAgICAgICAgICAgTWF0aC5yb3VuZCh0aGlzLm9wdGlvbnMuZXh0ZW50ICogKGMueSAqIHoyIC0geSkpXG4gICAgICAgICAgICAgICAgXV0sXG4gICAgICAgICAgICAgICAgdGFnczogYy5udW1Qb2ludHMgPyBnZXRDbHVzdGVyUHJvcGVydGllcyhjKSA6IHRoaXMucG9pbnRzW2MuaW5kZXhdLnByb3BlcnRpZXNcbiAgICAgICAgICAgIH07XG4gICAgICAgICAgICB2YXIgaWQgPSBjLm51bVBvaW50cyA/IGMuaWQgOiB0aGlzLnBvaW50c1tjLmluZGV4XS5pZDtcbiAgICAgICAgICAgIGlmIChpZCAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICAgICAgICAgICAgZi5pZCA9IGlkO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgdGlsZS5mZWF0dXJlcy5wdXNoKGYpO1xuICAgICAgICB9XG4gICAgfSxcblxuICAgIF9saW1pdFpvb206IGZ1bmN0aW9uICh6KSB7XG4gICAgICAgIHJldHVybiBNYXRoLm1heCh0aGlzLm9wdGlvbnMubWluWm9vbSwgTWF0aC5taW4oeiwgdGhpcy5vcHRpb25zLm1heFpvb20gKyAxKSk7XG4gICAgfSxcblxuICAgIF9jbHVzdGVyOiBmdW5jdGlvbiAocG9pbnRzLCB6b29tKSB7XG4gICAgICAgIHZhciBjbHVzdGVycyA9IFtdO1xuICAgICAgICB2YXIgciA9IHRoaXMub3B0aW9ucy5yYWRpdXMgLyAodGhpcy5vcHRpb25zLmV4dGVudCAqIE1hdGgucG93KDIsIHpvb20pKTtcblxuICAgICAgICAvLyBsb29wIHRocm91Z2ggZWFjaCBwb2ludFxuICAgICAgICBmb3IgKHZhciBpID0gMDsgaSA8IHBvaW50cy5sZW5ndGg7IGkrKykge1xuICAgICAgICAgICAgdmFyIHAgPSBwb2ludHNbaV07XG4gICAgICAgICAgICAvLyBpZiB3ZSd2ZSBhbHJlYWR5IHZpc2l0ZWQgdGhlIHBvaW50IGF0IHRoaXMgem9vbSBsZXZlbCwgc2tpcCBpdFxuICAgICAgICAgICAgaWYgKHAuem9vbSA8PSB6b29tKSBjb250aW51ZTtcbiAgICAgICAgICAgIHAuem9vbSA9IHpvb207XG5cbiAgICAgICAgICAgIC8vIGZpbmQgYWxsIG5lYXJieSBwb2ludHNcbiAgICAgICAgICAgIHZhciB0cmVlID0gdGhpcy50cmVlc1t6b29tICsgMV07XG4gICAgICAgICAgICB2YXIgbmVpZ2hib3JJZHMgPSB0cmVlLndpdGhpbihwLngsIHAueSwgcik7XG5cbiAgICAgICAgICAgIHZhciBudW1Qb2ludHMgPSBwLm51bVBvaW50cyB8fCAxO1xuICAgICAgICAgICAgdmFyIHd4ID0gcC54ICogbnVtUG9pbnRzO1xuICAgICAgICAgICAgdmFyIHd5ID0gcC55ICogbnVtUG9pbnRzO1xuXG4gICAgICAgICAgICB2YXIgY2x1c3RlclByb3BlcnRpZXMgPSBudWxsO1xuXG4gICAgICAgICAgICBpZiAodGhpcy5vcHRpb25zLnJlZHVjZSkge1xuICAgICAgICAgICAgICAgIGNsdXN0ZXJQcm9wZXJ0aWVzID0gdGhpcy5vcHRpb25zLmluaXRpYWwoKTtcbiAgICAgICAgICAgICAgICB0aGlzLl9hY2N1bXVsYXRlKGNsdXN0ZXJQcm9wZXJ0aWVzLCBwKTtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgLy8gZW5jb2RlIGJvdGggem9vbSBhbmQgcG9pbnQgaW5kZXggb24gd2hpY2ggdGhlIGNsdXN0ZXIgb3JpZ2luYXRlZFxuICAgICAgICAgICAgdmFyIGlkID0gKGkgPDwgNSkgKyAoem9vbSArIDEpO1xuXG4gICAgICAgICAgICBmb3IgKHZhciBqID0gMDsgaiA8IG5laWdoYm9ySWRzLmxlbmd0aDsgaisrKSB7XG4gICAgICAgICAgICAgICAgdmFyIGIgPSB0cmVlLnBvaW50c1tuZWlnaGJvcklkc1tqXV07XG4gICAgICAgICAgICAgICAgLy8gZmlsdGVyIG91dCBuZWlnaGJvcnMgdGhhdCBhcmUgYWxyZWFkeSBwcm9jZXNzZWRcbiAgICAgICAgICAgICAgICBpZiAoYi56b29tIDw9IHpvb20pIGNvbnRpbnVlO1xuICAgICAgICAgICAgICAgIGIuem9vbSA9IHpvb207IC8vIHNhdmUgdGhlIHpvb20gKHNvIGl0IGRvZXNuJ3QgZ2V0IHByb2Nlc3NlZCB0d2ljZSlcblxuICAgICAgICAgICAgICAgIHZhciBudW1Qb2ludHMyID0gYi5udW1Qb2ludHMgfHwgMTtcbiAgICAgICAgICAgICAgICB3eCArPSBiLnggKiBudW1Qb2ludHMyOyAvLyBhY2N1bXVsYXRlIGNvb3JkaW5hdGVzIGZvciBjYWxjdWxhdGluZyB3ZWlnaHRlZCBjZW50ZXJcbiAgICAgICAgICAgICAgICB3eSArPSBiLnkgKiBudW1Qb2ludHMyO1xuXG4gICAgICAgICAgICAgICAgbnVtUG9pbnRzICs9IG51bVBvaW50czI7XG4gICAgICAgICAgICAgICAgYi5wYXJlbnRJZCA9IGlkO1xuXG4gICAgICAgICAgICAgICAgaWYgKHRoaXMub3B0aW9ucy5yZWR1Y2UpIHtcbiAgICAgICAgICAgICAgICAgICAgdGhpcy5fYWNjdW11bGF0ZShjbHVzdGVyUHJvcGVydGllcywgYik7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICBpZiAobnVtUG9pbnRzID09PSAxKSB7XG4gICAgICAgICAgICAgICAgY2x1c3RlcnMucHVzaChwKTtcbiAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgcC5wYXJlbnRJZCA9IGlkO1xuICAgICAgICAgICAgICAgIGNsdXN0ZXJzLnB1c2goY3JlYXRlQ2x1c3Rlcih3eCAvIG51bVBvaW50cywgd3kgLyBudW1Qb2ludHMsIGlkLCBudW1Qb2ludHMsIGNsdXN0ZXJQcm9wZXJ0aWVzKSk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cblxuICAgICAgICByZXR1cm4gY2x1c3RlcnM7XG4gICAgfSxcblxuICAgIF9hY2N1bXVsYXRlOiBmdW5jdGlvbiAoY2x1c3RlclByb3BlcnRpZXMsIHBvaW50KSB7XG4gICAgICAgIHZhciBwcm9wZXJ0aWVzID0gcG9pbnQubnVtUG9pbnRzID9cbiAgICAgICAgICAgIHBvaW50LnByb3BlcnRpZXMgOlxuICAgICAgICAgICAgdGhpcy5vcHRpb25zLm1hcCh0aGlzLnBvaW50c1twb2ludC5pbmRleF0ucHJvcGVydGllcyk7XG5cbiAgICAgICAgdGhpcy5vcHRpb25zLnJlZHVjZShjbHVzdGVyUHJvcGVydGllcywgcHJvcGVydGllcyk7XG4gICAgfVxufTtcblxuZnVuY3Rpb24gY3JlYXRlQ2x1c3Rlcih4LCB5LCBpZCwgbnVtUG9pbnRzLCBwcm9wZXJ0aWVzKSB7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgeDogeCwgLy8gd2VpZ2h0ZWQgY2x1c3RlciBjZW50ZXJcbiAgICAgICAgeTogeSxcbiAgICAgICAgem9vbTogSW5maW5pdHksIC8vIHRoZSBsYXN0IHpvb20gdGhlIGNsdXN0ZXIgd2FzIHByb2Nlc3NlZCBhdFxuICAgICAgICBpZDogaWQsIC8vIGVuY29kZXMgaW5kZXggb2YgdGhlIGZpcnN0IGNoaWxkIG9mIHRoZSBjbHVzdGVyIGFuZCBpdHMgem9vbSBsZXZlbFxuICAgICAgICBwYXJlbnRJZDogLTEsIC8vIHBhcmVudCBjbHVzdGVyIGlkXG4gICAgICAgIG51bVBvaW50czogbnVtUG9pbnRzLFxuICAgICAgICBwcm9wZXJ0aWVzOiBwcm9wZXJ0aWVzXG4gICAgfTtcbn1cblxuZnVuY3Rpb24gY3JlYXRlUG9pbnRDbHVzdGVyKHAsIGlkKSB7XG4gICAgdmFyIGNvb3JkcyA9IHAuZ2VvbWV0cnkuY29vcmRpbmF0ZXM7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgeDogbG5nWChjb29yZHNbMF0pLCAvLyBwcm9qZWN0ZWQgcG9pbnQgY29vcmRpbmF0ZXNcbiAgICAgICAgeTogbGF0WShjb29yZHNbMV0pLFxuICAgICAgICB6b29tOiBJbmZpbml0eSwgLy8gdGhlIGxhc3Qgem9vbSB0aGUgcG9pbnQgd2FzIHByb2Nlc3NlZCBhdFxuICAgICAgICBpbmRleDogaWQsIC8vIGluZGV4IG9mIHRoZSBzb3VyY2UgZmVhdHVyZSBpbiB0aGUgb3JpZ2luYWwgaW5wdXQgYXJyYXksXG4gICAgICAgIHBhcmVudElkOiAtMSAvLyBwYXJlbnQgY2x1c3RlciBpZFxuICAgIH07XG59XG5cbmZ1bmN0aW9uIGdldENsdXN0ZXJKU09OKGNsdXN0ZXIpIHtcbiAgICByZXR1cm4ge1xuICAgICAgICB0eXBlOiAnRmVhdHVyZScsXG4gICAgICAgIGlkOiBjbHVzdGVyLmlkLFxuICAgICAgICBwcm9wZXJ0aWVzOiBnZXRDbHVzdGVyUHJvcGVydGllcyhjbHVzdGVyKSxcbiAgICAgICAgZ2VvbWV0cnk6IHtcbiAgICAgICAgICAgIHR5cGU6ICdQb2ludCcsXG4gICAgICAgICAgICBjb29yZGluYXRlczogW3hMbmcoY2x1c3Rlci54KSwgeUxhdChjbHVzdGVyLnkpXVxuICAgICAgICB9XG4gICAgfTtcbn1cblxuZnVuY3Rpb24gZ2V0Q2x1c3RlclByb3BlcnRpZXMoY2x1c3Rlcikge1xuICAgIHZhciBjb3VudCA9IGNsdXN0ZXIubnVtUG9pbnRzO1xuICAgIHZhciBhYmJyZXYgPVxuICAgICAgICBjb3VudCA+PSAxMDAwMCA/IE1hdGgucm91bmQoY291bnQgLyAxMDAwKSArICdrJyA6XG4gICAgICAgIGNvdW50ID49IDEwMDAgPyAoTWF0aC5yb3VuZChjb3VudCAvIDEwMCkgLyAxMCkgKyAnaycgOiBjb3VudDtcbiAgICByZXR1cm4gZXh0ZW5kKGV4dGVuZCh7fSwgY2x1c3Rlci5wcm9wZXJ0aWVzKSwge1xuICAgICAgICBjbHVzdGVyOiB0cnVlLFxuICAgICAgICBjbHVzdGVyX2lkOiBjbHVzdGVyLmlkLFxuICAgICAgICBwb2ludF9jb3VudDogY291bnQsXG4gICAgICAgIHBvaW50X2NvdW50X2FiYnJldmlhdGVkOiBhYmJyZXZcbiAgICB9KTtcbn1cblxuLy8gbG9uZ2l0dWRlL2xhdGl0dWRlIHRvIHNwaGVyaWNhbCBtZXJjYXRvciBpbiBbMC4uMV0gcmFuZ2VcbmZ1bmN0aW9uIGxuZ1gobG5nKSB7XG4gICAgcmV0dXJuIGxuZyAvIDM2MCArIDAuNTtcbn1cbmZ1bmN0aW9uIGxhdFkobGF0KSB7XG4gICAgdmFyIHNpbiA9IE1hdGguc2luKGxhdCAqIE1hdGguUEkgLyAxODApLFxuICAgICAgICB5ID0gKDAuNSAtIDAuMjUgKiBNYXRoLmxvZygoMSArIHNpbikgLyAoMSAtIHNpbikpIC8gTWF0aC5QSSk7XG4gICAgcmV0dXJuIHkgPCAwID8gMCA6IHkgPiAxID8gMSA6IHk7XG59XG5cbi8vIHNwaGVyaWNhbCBtZXJjYXRvciB0byBsb25naXR1ZGUvbGF0aXR1ZGVcbmZ1bmN0aW9uIHhMbmcoeCkge1xuICAgIHJldHVybiAoeCAtIDAuNSkgKiAzNjA7XG59XG5mdW5jdGlvbiB5TGF0KHkpIHtcbiAgICB2YXIgeTIgPSAoMTgwIC0geSAqIDM2MCkgKiBNYXRoLlBJIC8gMTgwO1xuICAgIHJldHVybiAzNjAgKiBNYXRoLmF0YW4oTWF0aC5leHAoeTIpKSAvIE1hdGguUEkgLSA5MDtcbn1cblxuZnVuY3Rpb24gZXh0ZW5kKGRlc3QsIHNyYykge1xuICAgIGZvciAodmFyIGlkIGluIHNyYykgZGVzdFtpZF0gPSBzcmNbaWRdO1xuICAgIHJldHVybiBkZXN0O1xufVxuXG5mdW5jdGlvbiBnZXRYKHApIHtcbiAgICByZXR1cm4gcC54O1xufVxuZnVuY3Rpb24gZ2V0WShwKSB7XG4gICAgcmV0dXJuIHAueTtcbn1cbiJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOyIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/supercluster/index.js\n");

/***/ }),

/***/ "./node_modules/supercluster/node_modules/kdbush/src/index.js":
/*!********************************************************************!*\
  !*** ./node_modules/supercluster/node_modules/kdbush/src/index.js ***!
  \********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return kdbush; });\n/* harmony import */ var _sort__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./sort */ \"./node_modules/supercluster/node_modules/kdbush/src/sort.js\");\n/* harmony import */ var _range__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./range */ \"./node_modules/supercluster/node_modules/kdbush/src/range.js\");\n/* harmony import */ var _within__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./within */ \"./node_modules/supercluster/node_modules/kdbush/src/within.js\");\n\n\n\n\n\nfunction kdbush(points, getX, getY, nodeSize, ArrayType) {\n    return new KDBush(points, getX, getY, nodeSize, ArrayType);\n}\n\nfunction KDBush(points, getX, getY, nodeSize, ArrayType) {\n    getX = getX || defaultGetX;\n    getY = getY || defaultGetY;\n    ArrayType = ArrayType || Array;\n\n    this.nodeSize = nodeSize || 64;\n    this.points = points;\n\n    this.ids = new ArrayType(points.length);\n    this.coords = new ArrayType(points.length * 2);\n\n    for (var i = 0; i < points.length; i++) {\n        this.ids[i] = i;\n        this.coords[2 * i] = getX(points[i]);\n        this.coords[2 * i + 1] = getY(points[i]);\n    }\n\n    Object(_sort__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(this.ids, this.coords, this.nodeSize, 0, this.ids.length - 1, 0);\n}\n\nKDBush.prototype = {\n    range: function (minX, minY, maxX, maxY) {\n        return Object(_range__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(this.ids, this.coords, minX, minY, maxX, maxY, this.nodeSize);\n    },\n\n    within: function (x, y, r) {\n        return Object(_within__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(this.ids, this.coords, x, y, r, this.nodeSize);\n    }\n};\n\nfunction defaultGetX(p) { return p[0]; }\nfunction defaultGetY(p) { return p[1]; }\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/supercluster/node_modules/kdbush/src/index.js\n");

/***/ }),

/***/ "./node_modules/supercluster/node_modules/kdbush/src/range.js":
/*!********************************************************************!*\
  !*** ./node_modules/supercluster/node_modules/kdbush/src/range.js ***!
  \********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return range; });\n\nfunction range(ids, coords, minX, minY, maxX, maxY, nodeSize) {\n    var stack = [0, ids.length - 1, 0];\n    var result = [];\n    var x, y;\n\n    while (stack.length) {\n        var axis = stack.pop();\n        var right = stack.pop();\n        var left = stack.pop();\n\n        if (right - left <= nodeSize) {\n            for (var i = left; i <= right; i++) {\n                x = coords[2 * i];\n                y = coords[2 * i + 1];\n                if (x >= minX && x <= maxX && y >= minY && y <= maxY) result.push(ids[i]);\n            }\n            continue;\n        }\n\n        var m = Math.floor((left + right) / 2);\n\n        x = coords[2 * m];\n        y = coords[2 * m + 1];\n\n        if (x >= minX && x <= maxX && y >= minY && y <= maxY) result.push(ids[m]);\n\n        var nextAxis = (axis + 1) % 2;\n\n        if (axis === 0 ? minX <= x : minY <= y) {\n            stack.push(left);\n            stack.push(m - 1);\n            stack.push(nextAxis);\n        }\n        if (axis === 0 ? maxX >= x : maxY >= y) {\n            stack.push(m + 1);\n            stack.push(right);\n            stack.push(nextAxis);\n        }\n    }\n\n    return result;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/supercluster/node_modules/kdbush/src/range.js\n");

/***/ }),

/***/ "./node_modules/supercluster/node_modules/kdbush/src/sort.js":
/*!*******************************************************************!*\
  !*** ./node_modules/supercluster/node_modules/kdbush/src/sort.js ***!
  \*******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return sortKD; });\n\nfunction sortKD(ids, coords, nodeSize, left, right, depth) {\n    if (right - left <= nodeSize) return;\n\n    var m = Math.floor((left + right) / 2);\n\n    select(ids, coords, m, left, right, depth % 2);\n\n    sortKD(ids, coords, nodeSize, left, m - 1, depth + 1);\n    sortKD(ids, coords, nodeSize, m + 1, right, depth + 1);\n}\n\nfunction select(ids, coords, k, left, right, inc) {\n\n    while (right > left) {\n        if (right - left > 600) {\n            var n = right - left + 1;\n            var m = k - left + 1;\n            var z = Math.log(n);\n            var s = 0.5 * Math.exp(2 * z / 3);\n            var sd = 0.5 * Math.sqrt(z * s * (n - s) / n) * (m - n / 2 < 0 ? -1 : 1);\n            var newLeft = Math.max(left, Math.floor(k - m * s / n + sd));\n            var newRight = Math.min(right, Math.floor(k + (n - m) * s / n + sd));\n            select(ids, coords, k, newLeft, newRight, inc);\n        }\n\n        var t = coords[2 * k + inc];\n        var i = left;\n        var j = right;\n\n        swapItem(ids, coords, left, k);\n        if (coords[2 * right + inc] > t) swapItem(ids, coords, left, right);\n\n        while (i < j) {\n            swapItem(ids, coords, i, j);\n            i++;\n            j--;\n            while (coords[2 * i + inc] < t) i++;\n            while (coords[2 * j + inc] > t) j--;\n        }\n\n        if (coords[2 * left + inc] === t) swapItem(ids, coords, left, j);\n        else {\n            j++;\n            swapItem(ids, coords, j, right);\n        }\n\n        if (j <= k) left = j + 1;\n        if (k <= j) right = j - 1;\n    }\n}\n\nfunction swapItem(ids, coords, i, j) {\n    swap(ids, i, j);\n    swap(coords, 2 * i, 2 * j);\n    swap(coords, 2 * i + 1, 2 * j + 1);\n}\n\nfunction swap(arr, i, j) {\n    var tmp = arr[i];\n    arr[i] = arr[j];\n    arr[j] = tmp;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/supercluster/node_modules/kdbush/src/sort.js\n");

/***/ }),

/***/ "./node_modules/supercluster/node_modules/kdbush/src/within.js":
/*!*********************************************************************!*\
  !*** ./node_modules/supercluster/node_modules/kdbush/src/within.js ***!
  \*********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return within; });\n\nfunction within(ids, coords, qx, qy, r, nodeSize) {\n    var stack = [0, ids.length - 1, 0];\n    var result = [];\n    var r2 = r * r;\n\n    while (stack.length) {\n        var axis = stack.pop();\n        var right = stack.pop();\n        var left = stack.pop();\n\n        if (right - left <= nodeSize) {\n            for (var i = left; i <= right; i++) {\n                if (sqDist(coords[2 * i], coords[2 * i + 1], qx, qy) <= r2) result.push(ids[i]);\n            }\n            continue;\n        }\n\n        var m = Math.floor((left + right) / 2);\n\n        var x = coords[2 * m];\n        var y = coords[2 * m + 1];\n\n        if (sqDist(x, y, qx, qy) <= r2) result.push(ids[m]);\n\n        var nextAxis = (axis + 1) % 2;\n\n        if (axis === 0 ? qx - r <= x : qy - r <= y) {\n            stack.push(left);\n            stack.push(m - 1);\n            stack.push(nextAxis);\n        }\n        if (axis === 0 ? qx + r >= x : qy + r >= y) {\n            stack.push(m + 1);\n            stack.push(right);\n            stack.push(nextAxis);\n        }\n    }\n\n    return result;\n}\n\nfunction sqDist(ax, ay, bx, by) {\n    var dx = ax - bx;\n    var dy = ay - by;\n    return dx * dx + dy * dy;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/supercluster/node_modules/kdbush/src/within.js\n");

/***/ })

}]);