(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[197],{

/***/ "./node_modules/brace/ext/language_tools.js":
/*!**************************************************!*\
  !*** ./node_modules/brace/ext/language_tools.js ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

eval("ace.define(\"ace/snippets\",[\"require\",\"exports\",\"module\",\"ace/lib/oop\",\"ace/lib/event_emitter\",\"ace/lib/lang\",\"ace/range\",\"ace/anchor\",\"ace/keyboard/hash_handler\",\"ace/tokenizer\",\"ace/lib/dom\",\"ace/editor\"], function(acequire, exports, module) {\n\"use strict\";\nvar oop = acequire(\"./lib/oop\");\nvar EventEmitter = acequire(\"./lib/event_emitter\").EventEmitter;\nvar lang = acequire(\"./lib/lang\");\nvar Range = acequire(\"./range\").Range;\nvar Anchor = acequire(\"./anchor\").Anchor;\nvar HashHandler = acequire(\"./keyboard/hash_handler\").HashHandler;\nvar Tokenizer = acequire(\"./tokenizer\").Tokenizer;\nvar comparePoints = Range.comparePoints;\n\nvar SnippetManager = function() {\n    this.snippetMap = {};\n    this.snippetNameMap = {};\n};\n\n(function() {\n    oop.implement(this, EventEmitter);\n    \n    this.getTokenizer = function() {\n        function TabstopToken(str, _, stack) {\n            str = str.substr(1);\n            if (/^\\d+$/.test(str) && !stack.inFormatString)\n                return [{tabstopId: parseInt(str, 10)}];\n            return [{text: str}];\n        }\n        function escape(ch) {\n            return \"(?:[^\\\\\\\\\" + ch + \"]|\\\\\\\\.)\";\n        }\n        SnippetManager.$tokenizer = new Tokenizer({\n            start: [\n                {regex: /:/, onMatch: function(val, state, stack) {\n                    if (stack.length && stack[0].expectIf) {\n                        stack[0].expectIf = false;\n                        stack[0].elseBranch = stack[0];\n                        return [stack[0]];\n                    }\n                    return \":\";\n                }},\n                {regex: /\\\\./, onMatch: function(val, state, stack) {\n                    var ch = val[1];\n                    if (ch == \"}\" && stack.length) {\n                        val = ch;\n                    }else if (\"`$\\\\\".indexOf(ch) != -1) {\n                        val = ch;\n                    } else if (stack.inFormatString) {\n                        if (ch == \"n\")\n                            val = \"\\n\";\n                        else if (ch == \"t\")\n                            val = \"\\n\";\n                        else if (\"ulULE\".indexOf(ch) != -1) {\n                            val = {changeCase: ch, local: ch > \"a\"};\n                        }\n                    }\n\n                    return [val];\n                }},\n                {regex: /}/, onMatch: function(val, state, stack) {\n                    return [stack.length ? stack.shift() : val];\n                }},\n                {regex: /\\$(?:\\d+|\\w+)/, onMatch: TabstopToken},\n                {regex: /\\$\\{[\\dA-Z_a-z]+/, onMatch: function(str, state, stack) {\n                    var t = TabstopToken(str.substr(1), state, stack);\n                    stack.unshift(t[0]);\n                    return t;\n                }, next: \"snippetVar\"},\n                {regex: /\\n/, token: \"newline\", merge: false}\n            ],\n            snippetVar: [\n                {regex: \"\\\\|\" + escape(\"\\\\|\") + \"*\\\\|\", onMatch: function(val, state, stack) {\n                    stack[0].choices = val.slice(1, -1).split(\",\");\n                }, next: \"start\"},\n                {regex: \"/(\" + escape(\"/\") + \"+)/(?:(\" + escape(\"/\") + \"*)/)(\\\\w*):?\",\n                 onMatch: function(val, state, stack) {\n                    var ts = stack[0];\n                    ts.fmtString = val;\n\n                    val = this.splitRegex.exec(val);\n                    ts.guard = val[1];\n                    ts.fmt = val[2];\n                    ts.flag = val[3];\n                    return \"\";\n                }, next: \"start\"},\n                {regex: \"`\" + escape(\"`\") + \"*`\", onMatch: function(val, state, stack) {\n                    stack[0].code = val.splice(1, -1);\n                    return \"\";\n                }, next: \"start\"},\n                {regex: \"\\\\?\", onMatch: function(val, state, stack) {\n                    if (stack[0])\n                        stack[0].expectIf = true;\n                }, next: \"start\"},\n                {regex: \"([^:}\\\\\\\\]|\\\\\\\\.)*:?\", token: \"\", next: \"start\"}\n            ],\n            formatString: [\n                {regex: \"/(\" + escape(\"/\") + \"+)/\", token: \"regex\"},\n                {regex: \"\", onMatch: function(val, state, stack) {\n                    stack.inFormatString = true;\n                }, next: \"start\"}\n            ]\n        });\n        SnippetManager.prototype.getTokenizer = function() {\n            return SnippetManager.$tokenizer;\n        };\n        return SnippetManager.$tokenizer;\n    };\n\n    this.tokenizeTmSnippet = function(str, startState) {\n        return this.getTokenizer().getLineTokens(str, startState).tokens.map(function(x) {\n            return x.value || x;\n        });\n    };\n\n    this.$getDefaultValue = function(editor, name) {\n        if (/^[A-Z]\\d+$/.test(name)) {\n            var i = name.substr(1);\n            return (this.variables[name[0] + \"__\"] || {})[i];\n        }\n        if (/^\\d+$/.test(name)) {\n            return (this.variables.__ || {})[name];\n        }\n        name = name.replace(/^TM_/, \"\");\n\n        if (!editor)\n            return;\n        var s = editor.session;\n        switch(name) {\n            case \"CURRENT_WORD\":\n                var r = s.getWordRange();\n            case \"SELECTION\":\n            case \"SELECTED_TEXT\":\n                return s.getTextRange(r);\n            case \"CURRENT_LINE\":\n                return s.getLine(editor.getCursorPosition().row);\n            case \"PREV_LINE\": // not possible in textmate\n                return s.getLine(editor.getCursorPosition().row - 1);\n            case \"LINE_INDEX\":\n                return editor.getCursorPosition().column;\n            case \"LINE_NUMBER\":\n                return editor.getCursorPosition().row + 1;\n            case \"SOFT_TABS\":\n                return s.getUseSoftTabs() ? \"YES\" : \"NO\";\n            case \"TAB_SIZE\":\n                return s.getTabSize();\n            case \"FILENAME\":\n            case \"FILEPATH\":\n                return \"\";\n            case \"FULLNAME\":\n                return \"Ace\";\n        }\n    };\n    this.variables = {};\n    this.getVariableValue = function(editor, varName) {\n        if (this.variables.hasOwnProperty(varName))\n            return this.variables[varName](editor, varName) || \"\";\n        return this.$getDefaultValue(editor, varName) || \"\";\n    };\n    this.tmStrFormat = function(str, ch, editor) {\n        var flag = ch.flag || \"\";\n        var re = ch.guard;\n        re = new RegExp(re, flag.replace(/[^gi]/, \"\"));\n        var fmtTokens = this.tokenizeTmSnippet(ch.fmt, \"formatString\");\n        var _self = this;\n        var formatted = str.replace(re, function() {\n            _self.variables.__ = arguments;\n            var fmtParts = _self.resolveVariables(fmtTokens, editor);\n            var gChangeCase = \"E\";\n            for (var i  = 0; i < fmtParts.length; i++) {\n                var ch = fmtParts[i];\n                if (typeof ch == \"object\") {\n                    fmtParts[i] = \"\";\n                    if (ch.changeCase && ch.local) {\n                        var next = fmtParts[i + 1];\n                        if (next && typeof next == \"string\") {\n                            if (ch.changeCase == \"u\")\n                                fmtParts[i] = next[0].toUpperCase();\n                            else\n                                fmtParts[i] = next[0].toLowerCase();\n                            fmtParts[i + 1] = next.substr(1);\n                        }\n                    } else if (ch.changeCase) {\n                        gChangeCase = ch.changeCase;\n                    }\n                } else if (gChangeCase == \"U\") {\n                    fmtParts[i] = ch.toUpperCase();\n                } else if (gChangeCase == \"L\") {\n                    fmtParts[i] = ch.toLowerCase();\n                }\n            }\n            return fmtParts.join(\"\");\n        });\n        this.variables.__ = null;\n        return formatted;\n    };\n\n    this.resolveVariables = function(snippet, editor) {\n        var result = [];\n        for (var i = 0; i < snippet.length; i++) {\n            var ch = snippet[i];\n            if (typeof ch == \"string\") {\n                result.push(ch);\n            } else if (typeof ch != \"object\") {\n                continue;\n            } else if (ch.skip) {\n                gotoNext(ch);\n            } else if (ch.processed < i) {\n                continue;\n            } else if (ch.text) {\n                var value = this.getVariableValue(editor, ch.text);\n                if (value && ch.fmtString)\n                    value = this.tmStrFormat(value, ch);\n                ch.processed = i;\n                if (ch.expectIf == null) {\n                    if (value) {\n                        result.push(value);\n                        gotoNext(ch);\n                    }\n                } else {\n                    if (value) {\n                        ch.skip = ch.elseBranch;\n                    } else\n                        gotoNext(ch);\n                }\n            } else if (ch.tabstopId != null) {\n                result.push(ch);\n            } else if (ch.changeCase != null) {\n                result.push(ch);\n            }\n        }\n        function gotoNext(ch) {\n            var i1 = snippet.indexOf(ch, i + 1);\n            if (i1 != -1)\n                i = i1;\n        }\n        return result;\n    };\n\n    this.insertSnippetForSelection = function(editor, snippetText) {\n        var cursor = editor.getCursorPosition();\n        var line = editor.session.getLine(cursor.row);\n        var tabString = editor.session.getTabString();\n        var indentString = line.match(/^\\s*/)[0];\n        \n        if (cursor.column < indentString.length)\n            indentString = indentString.slice(0, cursor.column);\n\n        snippetText = snippetText.replace(/\\r/g, \"\");\n        var tokens = this.tokenizeTmSnippet(snippetText);\n        tokens = this.resolveVariables(tokens, editor);\n        tokens = tokens.map(function(x) {\n            if (x == \"\\n\")\n                return x + indentString;\n            if (typeof x == \"string\")\n                return x.replace(/\\t/g, tabString);\n            return x;\n        });\n        var tabstops = [];\n        tokens.forEach(function(p, i) {\n            if (typeof p != \"object\")\n                return;\n            var id = p.tabstopId;\n            var ts = tabstops[id];\n            if (!ts) {\n                ts = tabstops[id] = [];\n                ts.index = id;\n                ts.value = \"\";\n            }\n            if (ts.indexOf(p) !== -1)\n                return;\n            ts.push(p);\n            var i1 = tokens.indexOf(p, i + 1);\n            if (i1 === -1)\n                return;\n\n            var value = tokens.slice(i + 1, i1);\n            var isNested = value.some(function(t) {return typeof t === \"object\";});\n            if (isNested && !ts.value) {\n                ts.value = value;\n            } else if (value.length && (!ts.value || typeof ts.value !== \"string\")) {\n                ts.value = value.join(\"\");\n            }\n        });\n        tabstops.forEach(function(ts) {ts.length = 0;});\n        var expanding = {};\n        function copyValue(val) {\n            var copy = [];\n            for (var i = 0; i < val.length; i++) {\n                var p = val[i];\n                if (typeof p == \"object\") {\n                    if (expanding[p.tabstopId])\n                        continue;\n                    var j = val.lastIndexOf(p, i - 1);\n                    p = copy[j] || {tabstopId: p.tabstopId};\n                }\n                copy[i] = p;\n            }\n            return copy;\n        }\n        for (var i = 0; i < tokens.length; i++) {\n            var p = tokens[i];\n            if (typeof p != \"object\")\n                continue;\n            var id = p.tabstopId;\n            var i1 = tokens.indexOf(p, i + 1);\n            if (expanding[id]) {\n                if (expanding[id] === p)\n                    expanding[id] = null;\n                continue;\n            }\n            \n            var ts = tabstops[id];\n            var arg = typeof ts.value == \"string\" ? [ts.value] : copyValue(ts.value);\n            arg.unshift(i + 1, Math.max(0, i1 - i));\n            arg.push(p);\n            expanding[id] = p;\n            tokens.splice.apply(tokens, arg);\n\n            if (ts.indexOf(p) === -1)\n                ts.push(p);\n        }\n        var row = 0, column = 0;\n        var text = \"\";\n        tokens.forEach(function(t) {\n            if (typeof t === \"string\") {\n                var lines = t.split(\"\\n\");\n                if (lines.length > 1){\n                    column = lines[lines.length - 1].length;\n                    row += lines.length - 1;\n                } else\n                    column += t.length;\n                text += t;\n            } else {\n                if (!t.start)\n                    t.start = {row: row, column: column};\n                else\n                    t.end = {row: row, column: column};\n            }\n        });\n        var range = editor.getSelectionRange();\n        var end = editor.session.replace(range, text);\n\n        var tabstopManager = new TabstopManager(editor);\n        var selectionId = editor.inVirtualSelectionMode && editor.selection.index;\n        tabstopManager.addTabstops(tabstops, range.start, end, selectionId);\n    };\n    \n    this.insertSnippet = function(editor, snippetText) {\n        var self = this;\n        if (editor.inVirtualSelectionMode)\n            return self.insertSnippetForSelection(editor, snippetText);\n        \n        editor.forEachSelection(function() {\n            self.insertSnippetForSelection(editor, snippetText);\n        }, null, {keepOrder: true});\n        \n        if (editor.tabstopManager)\n            editor.tabstopManager.tabNext();\n    };\n\n    this.$getScope = function(editor) {\n        var scope = editor.session.$mode.$id || \"\";\n        scope = scope.split(\"/\").pop();\n        if (scope === \"html\" || scope === \"php\") {\n            if (scope === \"php\" && !editor.session.$mode.inlinePhp) \n                scope = \"html\";\n            var c = editor.getCursorPosition();\n            var state = editor.session.getState(c.row);\n            if (typeof state === \"object\") {\n                state = state[0];\n            }\n            if (state.substring) {\n                if (state.substring(0, 3) == \"js-\")\n                    scope = \"javascript\";\n                else if (state.substring(0, 4) == \"css-\")\n                    scope = \"css\";\n                else if (state.substring(0, 4) == \"php-\")\n                    scope = \"php\";\n            }\n        }\n        \n        return scope;\n    };\n\n    this.getActiveScopes = function(editor) {\n        var scope = this.$getScope(editor);\n        var scopes = [scope];\n        var snippetMap = this.snippetMap;\n        if (snippetMap[scope] && snippetMap[scope].includeScopes) {\n            scopes.push.apply(scopes, snippetMap[scope].includeScopes);\n        }\n        scopes.push(\"_\");\n        return scopes;\n    };\n\n    this.expandWithTab = function(editor, options) {\n        var self = this;\n        var result = editor.forEachSelection(function() {\n            return self.expandSnippetForSelection(editor, options);\n        }, null, {keepOrder: true});\n        if (result && editor.tabstopManager)\n            editor.tabstopManager.tabNext();\n        return result;\n    };\n    \n    this.expandSnippetForSelection = function(editor, options) {\n        var cursor = editor.getCursorPosition();\n        var line = editor.session.getLine(cursor.row);\n        var before = line.substring(0, cursor.column);\n        var after = line.substr(cursor.column);\n\n        var snippetMap = this.snippetMap;\n        var snippet;\n        this.getActiveScopes(editor).some(function(scope) {\n            var snippets = snippetMap[scope];\n            if (snippets)\n                snippet = this.findMatchingSnippet(snippets, before, after);\n            return !!snippet;\n        }, this);\n        if (!snippet)\n            return false;\n        if (options && options.dryRun)\n            return true;\n        editor.session.doc.removeInLine(cursor.row,\n            cursor.column - snippet.replaceBefore.length,\n            cursor.column + snippet.replaceAfter.length\n        );\n\n        this.variables.M__ = snippet.matchBefore;\n        this.variables.T__ = snippet.matchAfter;\n        this.insertSnippetForSelection(editor, snippet.content);\n\n        this.variables.M__ = this.variables.T__ = null;\n        return true;\n    };\n\n    this.findMatchingSnippet = function(snippetList, before, after) {\n        for (var i = snippetList.length; i--;) {\n            var s = snippetList[i];\n            if (s.startRe && !s.startRe.test(before))\n                continue;\n            if (s.endRe && !s.endRe.test(after))\n                continue;\n            if (!s.startRe && !s.endRe)\n                continue;\n\n            s.matchBefore = s.startRe ? s.startRe.exec(before) : [\"\"];\n            s.matchAfter = s.endRe ? s.endRe.exec(after) : [\"\"];\n            s.replaceBefore = s.triggerRe ? s.triggerRe.exec(before)[0] : \"\";\n            s.replaceAfter = s.endTriggerRe ? s.endTriggerRe.exec(after)[0] : \"\";\n            return s;\n        }\n    };\n\n    this.snippetMap = {};\n    this.snippetNameMap = {};\n    this.register = function(snippets, scope) {\n        var snippetMap = this.snippetMap;\n        var snippetNameMap = this.snippetNameMap;\n        var self = this;\n        \n        if (!snippets) \n            snippets = [];\n        \n        function wrapRegexp(src) {\n            if (src && !/^\\^?\\(.*\\)\\$?$|^\\\\b$/.test(src))\n                src = \"(?:\" + src + \")\";\n\n            return src || \"\";\n        }\n        function guardedRegexp(re, guard, opening) {\n            re = wrapRegexp(re);\n            guard = wrapRegexp(guard);\n            if (opening) {\n                re = guard + re;\n                if (re && re[re.length - 1] != \"$\")\n                    re = re + \"$\";\n            } else {\n                re = re + guard;\n                if (re && re[0] != \"^\")\n                    re = \"^\" + re;\n            }\n            return new RegExp(re);\n        }\n\n        function addSnippet(s) {\n            if (!s.scope)\n                s.scope = scope || \"_\";\n            scope = s.scope;\n            if (!snippetMap[scope]) {\n                snippetMap[scope] = [];\n                snippetNameMap[scope] = {};\n            }\n\n            var map = snippetNameMap[scope];\n            if (s.name) {\n                var old = map[s.name];\n                if (old)\n                    self.unregister(old);\n                map[s.name] = s;\n            }\n            snippetMap[scope].push(s);\n\n            if (s.tabTrigger && !s.trigger) {\n                if (!s.guard && /^\\w/.test(s.tabTrigger))\n                    s.guard = \"\\\\b\";\n                s.trigger = lang.escapeRegExp(s.tabTrigger);\n            }\n            \n            if (!s.trigger && !s.guard && !s.endTrigger && !s.endGuard)\n                return;\n            \n            s.startRe = guardedRegexp(s.trigger, s.guard, true);\n            s.triggerRe = new RegExp(s.trigger, \"\", true);\n\n            s.endRe = guardedRegexp(s.endTrigger, s.endGuard, true);\n            s.endTriggerRe = new RegExp(s.endTrigger, \"\", true);\n        }\n\n        if (snippets && snippets.content)\n            addSnippet(snippets);\n        else if (Array.isArray(snippets))\n            snippets.forEach(addSnippet);\n        \n        this._signal(\"registerSnippets\", {scope: scope});\n    };\n    this.unregister = function(snippets, scope) {\n        var snippetMap = this.snippetMap;\n        var snippetNameMap = this.snippetNameMap;\n\n        function removeSnippet(s) {\n            var nameMap = snippetNameMap[s.scope||scope];\n            if (nameMap && nameMap[s.name]) {\n                delete nameMap[s.name];\n                var map = snippetMap[s.scope||scope];\n                var i = map && map.indexOf(s);\n                if (i >= 0)\n                    map.splice(i, 1);\n            }\n        }\n        if (snippets.content)\n            removeSnippet(snippets);\n        else if (Array.isArray(snippets))\n            snippets.forEach(removeSnippet);\n    };\n    this.parseSnippetFile = function(str) {\n        str = str.replace(/\\r/g, \"\");\n        var list = [], snippet = {};\n        var re = /^#.*|^({[\\s\\S]*})\\s*$|^(\\S+) (.*)$|^((?:\\n*\\t.*)+)/gm;\n        var m;\n        while (m = re.exec(str)) {\n            if (m[1]) {\n                try {\n                    snippet = JSON.parse(m[1]);\n                    list.push(snippet);\n                } catch (e) {}\n            } if (m[4]) {\n                snippet.content = m[4].replace(/^\\t/gm, \"\");\n                list.push(snippet);\n                snippet = {};\n            } else {\n                var key = m[2], val = m[3];\n                if (key == \"regex\") {\n                    var guardRe = /\\/((?:[^\\/\\\\]|\\\\.)*)|$/g;\n                    snippet.guard = guardRe.exec(val)[1];\n                    snippet.trigger = guardRe.exec(val)[1];\n                    snippet.endTrigger = guardRe.exec(val)[1];\n                    snippet.endGuard = guardRe.exec(val)[1];\n                } else if (key == \"snippet\") {\n                    snippet.tabTrigger = val.match(/^\\S*/)[0];\n                    if (!snippet.name)\n                        snippet.name = val;\n                } else {\n                    snippet[key] = val;\n                }\n            }\n        }\n        return list;\n    };\n    this.getSnippetByName = function(name, editor) {\n        var snippetMap = this.snippetNameMap;\n        var snippet;\n        this.getActiveScopes(editor).some(function(scope) {\n            var snippets = snippetMap[scope];\n            if (snippets)\n                snippet = snippets[name];\n            return !!snippet;\n        }, this);\n        return snippet;\n    };\n\n}).call(SnippetManager.prototype);\n\n\nvar TabstopManager = function(editor) {\n    if (editor.tabstopManager)\n        return editor.tabstopManager;\n    editor.tabstopManager = this;\n    this.$onChange = this.onChange.bind(this);\n    this.$onChangeSelection = lang.delayedCall(this.onChangeSelection.bind(this)).schedule;\n    this.$onChangeSession = this.onChangeSession.bind(this);\n    this.$onAfterExec = this.onAfterExec.bind(this);\n    this.attach(editor);\n};\n(function() {\n    this.attach = function(editor) {\n        this.index = 0;\n        this.ranges = [];\n        this.tabstops = [];\n        this.$openTabstops = null;\n        this.selectedTabstop = null;\n\n        this.editor = editor;\n        this.editor.on(\"change\", this.$onChange);\n        this.editor.on(\"changeSelection\", this.$onChangeSelection);\n        this.editor.on(\"changeSession\", this.$onChangeSession);\n        this.editor.commands.on(\"afterExec\", this.$onAfterExec);\n        this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler);\n    };\n    this.detach = function() {\n        this.tabstops.forEach(this.removeTabstopMarkers, this);\n        this.ranges = null;\n        this.tabstops = null;\n        this.selectedTabstop = null;\n        this.editor.removeListener(\"change\", this.$onChange);\n        this.editor.removeListener(\"changeSelection\", this.$onChangeSelection);\n        this.editor.removeListener(\"changeSession\", this.$onChangeSession);\n        this.editor.commands.removeListener(\"afterExec\", this.$onAfterExec);\n        this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler);\n        this.editor.tabstopManager = null;\n        this.editor = null;\n    };\n\n    this.onChange = function(delta) {\n        var changeRange = delta;\n        var isRemove = delta.action[0] == \"r\";\n        var start = delta.start;\n        var end = delta.end;\n        var startRow = start.row;\n        var endRow = end.row;\n        var lineDif = endRow - startRow;\n        var colDiff = end.column - start.column;\n\n        if (isRemove) {\n            lineDif = -lineDif;\n            colDiff = -colDiff;\n        }\n        if (!this.$inChange && isRemove) {\n            var ts = this.selectedTabstop;\n            var changedOutside = ts && !ts.some(function(r) {\n                return comparePoints(r.start, start) <= 0 && comparePoints(r.end, end) >= 0;\n            });\n            if (changedOutside)\n                return this.detach();\n        }\n        var ranges = this.ranges;\n        for (var i = 0; i < ranges.length; i++) {\n            var r = ranges[i];\n            if (r.end.row < start.row)\n                continue;\n\n            if (isRemove && comparePoints(start, r.start) < 0 && comparePoints(end, r.end) > 0) {\n                this.removeRange(r);\n                i--;\n                continue;\n            }\n\n            if (r.start.row == startRow && r.start.column > start.column)\n                r.start.column += colDiff;\n            if (r.end.row == startRow && r.end.column >= start.column)\n                r.end.column += colDiff;\n            if (r.start.row >= startRow)\n                r.start.row += lineDif;\n            if (r.end.row >= startRow)\n                r.end.row += lineDif;\n\n            if (comparePoints(r.start, r.end) > 0)\n                this.removeRange(r);\n        }\n        if (!ranges.length)\n            this.detach();\n    };\n    this.updateLinkedFields = function() {\n        var ts = this.selectedTabstop;\n        if (!ts || !ts.hasLinkedRanges)\n            return;\n        this.$inChange = true;\n        var session = this.editor.session;\n        var text = session.getTextRange(ts.firstNonLinked);\n        for (var i = ts.length; i--;) {\n            var range = ts[i];\n            if (!range.linked)\n                continue;\n            var fmt = exports.snippetManager.tmStrFormat(text, range.original);\n            session.replace(range, fmt);\n        }\n        this.$inChange = false;\n    };\n    this.onAfterExec = function(e) {\n        if (e.command && !e.command.readOnly)\n            this.updateLinkedFields();\n    };\n    this.onChangeSelection = function() {\n        if (!this.editor)\n            return;\n        var lead = this.editor.selection.lead;\n        var anchor = this.editor.selection.anchor;\n        var isEmpty = this.editor.selection.isEmpty();\n        for (var i = this.ranges.length; i--;) {\n            if (this.ranges[i].linked)\n                continue;\n            var containsLead = this.ranges[i].contains(lead.row, lead.column);\n            var containsAnchor = isEmpty || this.ranges[i].contains(anchor.row, anchor.column);\n            if (containsLead && containsAnchor)\n                return;\n        }\n        this.detach();\n    };\n    this.onChangeSession = function() {\n        this.detach();\n    };\n    this.tabNext = function(dir) {\n        var max = this.tabstops.length;\n        var index = this.index + (dir || 1);\n        index = Math.min(Math.max(index, 1), max);\n        if (index == max)\n            index = 0;\n        this.selectTabstop(index);\n        if (index === 0)\n            this.detach();\n    };\n    this.selectTabstop = function(index) {\n        this.$openTabstops = null;\n        var ts = this.tabstops[this.index];\n        if (ts)\n            this.addTabstopMarkers(ts);\n        this.index = index;\n        ts = this.tabstops[this.index];\n        if (!ts || !ts.length)\n            return;\n        \n        this.selectedTabstop = ts;\n        if (!this.editor.inVirtualSelectionMode) {        \n            var sel = this.editor.multiSelect;\n            sel.toSingleRange(ts.firstNonLinked.clone());\n            for (var i = ts.length; i--;) {\n                if (ts.hasLinkedRanges && ts[i].linked)\n                    continue;\n                sel.addRange(ts[i].clone(), true);\n            }\n            if (sel.ranges[0])\n                sel.addRange(sel.ranges[0].clone());\n        } else {\n            this.editor.selection.setRange(ts.firstNonLinked);\n        }\n        \n        this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler);\n    };\n    this.addTabstops = function(tabstops, start, end) {\n        if (!this.$openTabstops)\n            this.$openTabstops = [];\n        if (!tabstops[0]) {\n            var p = Range.fromPoints(end, end);\n            moveRelative(p.start, start);\n            moveRelative(p.end, start);\n            tabstops[0] = [p];\n            tabstops[0].index = 0;\n        }\n\n        var i = this.index;\n        var arg = [i + 1, 0];\n        var ranges = this.ranges;\n        tabstops.forEach(function(ts, index) {\n            var dest = this.$openTabstops[index] || ts;\n                \n            for (var i = ts.length; i--;) {\n                var p = ts[i];\n                var range = Range.fromPoints(p.start, p.end || p.start);\n                movePoint(range.start, start);\n                movePoint(range.end, start);\n                range.original = p;\n                range.tabstop = dest;\n                ranges.push(range);\n                if (dest != ts)\n                    dest.unshift(range);\n                else\n                    dest[i] = range;\n                if (p.fmtString) {\n                    range.linked = true;\n                    dest.hasLinkedRanges = true;\n                } else if (!dest.firstNonLinked)\n                    dest.firstNonLinked = range;\n            }\n            if (!dest.firstNonLinked)\n                dest.hasLinkedRanges = false;\n            if (dest === ts) {\n                arg.push(dest);\n                this.$openTabstops[index] = dest;\n            }\n            this.addTabstopMarkers(dest);\n        }, this);\n        \n        if (arg.length > 2) {\n            if (this.tabstops.length)\n                arg.push(arg.splice(2, 1)[0]);\n            this.tabstops.splice.apply(this.tabstops, arg);\n        }\n    };\n\n    this.addTabstopMarkers = function(ts) {\n        var session = this.editor.session;\n        ts.forEach(function(range) {\n            if  (!range.markerId)\n                range.markerId = session.addMarker(range, \"ace_snippet-marker\", \"text\");\n        });\n    };\n    this.removeTabstopMarkers = function(ts) {\n        var session = this.editor.session;\n        ts.forEach(function(range) {\n            session.removeMarker(range.markerId);\n            range.markerId = null;\n        });\n    };\n    this.removeRange = function(range) {\n        var i = range.tabstop.indexOf(range);\n        range.tabstop.splice(i, 1);\n        i = this.ranges.indexOf(range);\n        this.ranges.splice(i, 1);\n        this.editor.session.removeMarker(range.markerId);\n        if (!range.tabstop.length) {\n            i = this.tabstops.indexOf(range.tabstop);\n            if (i != -1)\n                this.tabstops.splice(i, 1);\n            if (!this.tabstops.length)\n                this.detach();\n        }\n    };\n\n    this.keyboardHandler = new HashHandler();\n    this.keyboardHandler.bindKeys({\n        \"Tab\": function(ed) {\n            if (exports.snippetManager && exports.snippetManager.expandWithTab(ed)) {\n                return;\n            }\n\n            ed.tabstopManager.tabNext(1);\n        },\n        \"Shift-Tab\": function(ed) {\n            ed.tabstopManager.tabNext(-1);\n        },\n        \"Esc\": function(ed) {\n            ed.tabstopManager.detach();\n        },\n        \"Return\": function(ed) {\n            return false;\n        }\n    });\n}).call(TabstopManager.prototype);\n\n\n\nvar changeTracker = {};\nchangeTracker.onChange = Anchor.prototype.onChange;\nchangeTracker.setPosition = function(row, column) {\n    this.pos.row = row;\n    this.pos.column = column;\n};\nchangeTracker.update = function(pos, delta, $insertRight) {\n    this.$insertRight = $insertRight;\n    this.pos = pos; \n    this.onChange(delta);\n};\n\nvar movePoint = function(point, diff) {\n    if (point.row == 0)\n        point.column += diff.column;\n    point.row += diff.row;\n};\n\nvar moveRelative = function(point, start) {\n    if (point.row == start.row)\n        point.column -= start.column;\n    point.row -= start.row;\n};\n\n\nacequire(\"./lib/dom\").importCssString(\"\\\n.ace_snippet-marker {\\\n    -moz-box-sizing: border-box;\\\n    box-sizing: border-box;\\\n    background: rgba(194, 193, 208, 0.09);\\\n    border: 1px dotted rgba(211, 208, 235, 0.62);\\\n    position: absolute;\\\n}\");\n\nexports.snippetManager = new SnippetManager();\n\n\nvar Editor = acequire(\"./editor\").Editor;\n(function() {\n    this.insertSnippet = function(content, options) {\n        return exports.snippetManager.insertSnippet(this, content, options);\n    };\n    this.expandSnippet = function(options) {\n        return exports.snippetManager.expandWithTab(this, options);\n    };\n}).call(Editor.prototype);\n\n});\n\nace.define(\"ace/autocomplete/popup\",[\"require\",\"exports\",\"module\",\"ace/virtual_renderer\",\"ace/editor\",\"ace/range\",\"ace/lib/event\",\"ace/lib/lang\",\"ace/lib/dom\"], function(acequire, exports, module) {\n\"use strict\";\n\nvar Renderer = acequire(\"../virtual_renderer\").VirtualRenderer;\nvar Editor = acequire(\"../editor\").Editor;\nvar Range = acequire(\"../range\").Range;\nvar event = acequire(\"../lib/event\");\nvar lang = acequire(\"../lib/lang\");\nvar dom = acequire(\"../lib/dom\");\n\nvar $singleLineEditor = function(el) {\n    var renderer = new Renderer(el);\n\n    renderer.$maxLines = 4;\n\n    var editor = new Editor(renderer);\n\n    editor.setHighlightActiveLine(false);\n    editor.setShowPrintMargin(false);\n    editor.renderer.setShowGutter(false);\n    editor.renderer.setHighlightGutterLine(false);\n\n    editor.$mouseHandler.$focusWaitTimout = 0;\n    editor.$highlightTagPending = true;\n\n    return editor;\n};\n\nvar AcePopup = function(parentNode) {\n    var el = dom.createElement(\"div\");\n    var popup = new $singleLineEditor(el);\n\n    if (parentNode)\n        parentNode.appendChild(el);\n    el.style.display = \"none\";\n    popup.renderer.content.style.cursor = \"default\";\n    popup.renderer.setStyle(\"ace_autocomplete\");\n\n    popup.setOption(\"displayIndentGuides\", false);\n    popup.setOption(\"dragDelay\", 150);\n\n    var noop = function(){};\n\n    popup.focus = noop;\n    popup.$isFocused = true;\n\n    popup.renderer.$cursorLayer.restartTimer = noop;\n    popup.renderer.$cursorLayer.element.style.opacity = 0;\n\n    popup.renderer.$maxLines = 8;\n    popup.renderer.$keepTextAreaAtCursor = false;\n\n    popup.setHighlightActiveLine(false);\n    popup.session.highlight(\"\");\n    popup.session.$searchHighlight.clazz = \"ace_highlight-marker\";\n\n    popup.on(\"mousedown\", function(e) {\n        var pos = e.getDocumentPosition();\n        popup.selection.moveToPosition(pos);\n        selectionMarker.start.row = selectionMarker.end.row = pos.row;\n        e.stop();\n    });\n\n    var lastMouseEvent;\n    var hoverMarker = new Range(-1,0,-1,Infinity);\n    var selectionMarker = new Range(-1,0,-1,Infinity);\n    selectionMarker.id = popup.session.addMarker(selectionMarker, \"ace_active-line\", \"fullLine\");\n    popup.setSelectOnHover = function(val) {\n        if (!val) {\n            hoverMarker.id = popup.session.addMarker(hoverMarker, \"ace_line-hover\", \"fullLine\");\n        } else if (hoverMarker.id) {\n            popup.session.removeMarker(hoverMarker.id);\n            hoverMarker.id = null;\n        }\n    };\n    popup.setSelectOnHover(false);\n    popup.on(\"mousemove\", function(e) {\n        if (!lastMouseEvent) {\n            lastMouseEvent = e;\n            return;\n        }\n        if (lastMouseEvent.x == e.x && lastMouseEvent.y == e.y) {\n            return;\n        }\n        lastMouseEvent = e;\n        lastMouseEvent.scrollTop = popup.renderer.scrollTop;\n        var row = lastMouseEvent.getDocumentPosition().row;\n        if (hoverMarker.start.row != row) {\n            if (!hoverMarker.id)\n                popup.setRow(row);\n            setHoverMarker(row);\n        }\n    });\n    popup.renderer.on(\"beforeRender\", function() {\n        if (lastMouseEvent && hoverMarker.start.row != -1) {\n            lastMouseEvent.$pos = null;\n            var row = lastMouseEvent.getDocumentPosition().row;\n            if (!hoverMarker.id)\n                popup.setRow(row);\n            setHoverMarker(row, true);\n        }\n    });\n    popup.renderer.on(\"afterRender\", function() {\n        var row = popup.getRow();\n        var t = popup.renderer.$textLayer;\n        var selected = t.element.childNodes[row - t.config.firstRow];\n        if (selected == t.selectedNode)\n            return;\n        if (t.selectedNode)\n            dom.removeCssClass(t.selectedNode, \"ace_selected\");\n        t.selectedNode = selected;\n        if (selected)\n            dom.addCssClass(selected, \"ace_selected\");\n    });\n    var hideHoverMarker = function() { setHoverMarker(-1); };\n    var setHoverMarker = function(row, suppressRedraw) {\n        if (row !== hoverMarker.start.row) {\n            hoverMarker.start.row = hoverMarker.end.row = row;\n            if (!suppressRedraw)\n                popup.session._emit(\"changeBackMarker\");\n            popup._emit(\"changeHoverMarker\");\n        }\n    };\n    popup.getHoveredRow = function() {\n        return hoverMarker.start.row;\n    };\n\n    event.addListener(popup.container, \"mouseout\", hideHoverMarker);\n    popup.on(\"hide\", hideHoverMarker);\n    popup.on(\"changeSelection\", hideHoverMarker);\n\n    popup.session.doc.getLength = function() {\n        return popup.data.length;\n    };\n    popup.session.doc.getLine = function(i) {\n        var data = popup.data[i];\n        if (typeof data == \"string\")\n            return data;\n        return (data && data.value) || \"\";\n    };\n\n    var bgTokenizer = popup.session.bgTokenizer;\n    bgTokenizer.$tokenizeRow = function(row) {\n        var data = popup.data[row];\n        var tokens = [];\n        if (!data)\n            return tokens;\n        if (typeof data == \"string\")\n            data = {value: data};\n        if (!data.caption)\n            data.caption = data.value || data.name;\n\n        var last = -1;\n        var flag, c;\n        for (var i = 0; i < data.caption.length; i++) {\n            c = data.caption[i];\n            flag = data.matchMask & (1 << i) ? 1 : 0;\n            if (last !== flag) {\n                tokens.push({type: data.className || \"\" + ( flag ? \"completion-highlight\" : \"\"), value: c});\n                last = flag;\n            } else {\n                tokens[tokens.length - 1].value += c;\n            }\n        }\n\n        if (data.meta) {\n            var maxW = popup.renderer.$size.scrollerWidth / popup.renderer.layerConfig.characterWidth;\n            var metaData = data.meta;\n            if (metaData.length + data.caption.length > maxW - 2) {\n                metaData = metaData.substr(0, maxW - data.caption.length - 3) + \"\\u2026\";\n            }\n            tokens.push({type: \"rightAlignedText\", value: metaData});\n        }\n        return tokens;\n    };\n    bgTokenizer.$updateOnChange = noop;\n    bgTokenizer.start = noop;\n\n    popup.session.$computeWidth = function() {\n        return this.screenWidth = 0;\n    };\n\n    popup.$blockScrolling = Infinity;\n    popup.isOpen = false;\n    popup.isTopdown = false;\n    popup.autoSelect = true;\n\n    popup.data = [];\n    popup.setData = function(list) {\n        popup.setValue(lang.stringRepeat(\"\\n\", list.length), -1);\n        popup.data = list || [];\n        popup.setRow(0);\n    };\n    popup.getData = function(row) {\n        return popup.data[row];\n    };\n\n    popup.getRow = function() {\n        return selectionMarker.start.row;\n    };\n    popup.setRow = function(line) {\n        line = Math.max(this.autoSelect ? 0 : -1, Math.min(this.data.length, line));\n        if (selectionMarker.start.row != line) {\n            popup.selection.clearSelection();\n            selectionMarker.start.row = selectionMarker.end.row = line || 0;\n            popup.session._emit(\"changeBackMarker\");\n            popup.moveCursorTo(line || 0, 0);\n            if (popup.isOpen)\n                popup._signal(\"select\");\n        }\n    };\n\n    popup.on(\"changeSelection\", function() {\n        if (popup.isOpen)\n            popup.setRow(popup.selection.lead.row);\n        popup.renderer.scrollCursorIntoView();\n    });\n\n    popup.hide = function() {\n        this.container.style.display = \"none\";\n        this._signal(\"hide\");\n        popup.isOpen = false;\n    };\n    popup.show = function(pos, lineHeight, topdownOnly) {\n        var el = this.container;\n        var screenHeight = window.innerHeight;\n        var screenWidth = window.innerWidth;\n        var renderer = this.renderer;\n        var maxH = renderer.$maxLines * lineHeight * 1.4;\n        var top = pos.top + this.$borderSize;\n        var allowTopdown = top > screenHeight / 2 && !topdownOnly;\n        if (allowTopdown && top + lineHeight + maxH > screenHeight) {\n            renderer.$maxPixelHeight = top - 2 * this.$borderSize;\n            el.style.top = \"\";\n            el.style.bottom = screenHeight - top + \"px\";\n            popup.isTopdown = false;\n        } else {\n            top += lineHeight;\n            renderer.$maxPixelHeight = screenHeight - top - 0.2 * lineHeight;\n            el.style.top = top + \"px\";\n            el.style.bottom = \"\";\n            popup.isTopdown = true;\n        }\n\n        el.style.display = \"\";\n        this.renderer.$textLayer.checkForSizeChanges();\n\n        var left = pos.left;\n        if (left + el.offsetWidth > screenWidth)\n            left = screenWidth - el.offsetWidth;\n\n        el.style.left = left + \"px\";\n\n        this._signal(\"show\");\n        lastMouseEvent = null;\n        popup.isOpen = true;\n    };\n\n    popup.getTextLeftOffset = function() {\n        return this.$borderSize + this.renderer.$padding + this.$imageSize;\n    };\n\n    popup.$imageSize = 0;\n    popup.$borderSize = 1;\n\n    return popup;\n};\n\ndom.importCssString(\"\\\n.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {\\\n    background-color: #CAD6FA;\\\n    z-index: 1;\\\n}\\\n.ace_editor.ace_autocomplete .ace_line-hover {\\\n    border: 1px solid #abbffe;\\\n    margin-top: -1px;\\\n    background: rgba(233,233,253,0.4);\\\n}\\\n.ace_editor.ace_autocomplete .ace_line-hover {\\\n    position: absolute;\\\n    z-index: 2;\\\n}\\\n.ace_editor.ace_autocomplete .ace_scroller {\\\n   background: none;\\\n   border: none;\\\n   box-shadow: none;\\\n}\\\n.ace_rightAlignedText {\\\n    color: gray;\\\n    display: inline-block;\\\n    position: absolute;\\\n    right: 4px;\\\n    text-align: right;\\\n    z-index: -1;\\\n}\\\n.ace_editor.ace_autocomplete .ace_completion-highlight{\\\n    color: #000;\\\n    text-shadow: 0 0 0.01em;\\\n}\\\n.ace_editor.ace_autocomplete {\\\n    width: 280px;\\\n    z-index: 200000;\\\n    background: #fbfbfb;\\\n    color: #444;\\\n    border: 1px lightgray solid;\\\n    position: fixed;\\\n    box-shadow: 2px 3px 5px rgba(0,0,0,.2);\\\n    line-height: 1.4;\\\n}\");\n\nexports.AcePopup = AcePopup;\n\n});\n\nace.define(\"ace/autocomplete/util\",[\"require\",\"exports\",\"module\"], function(acequire, exports, module) {\n\"use strict\";\n\nexports.parForEach = function(array, fn, callback) {\n    var completed = 0;\n    var arLength = array.length;\n    if (arLength === 0)\n        callback();\n    for (var i = 0; i < arLength; i++) {\n        fn(array[i], function(result, err) {\n            completed++;\n            if (completed === arLength)\n                callback(result, err);\n        });\n    }\n};\n\nvar ID_REGEX = /[a-zA-Z_0-9\\$\\-\\u00A2-\\uFFFF]/;\n\nexports.retrievePrecedingIdentifier = function(text, pos, regex) {\n    regex = regex || ID_REGEX;\n    var buf = [];\n    for (var i = pos-1; i >= 0; i--) {\n        if (regex.test(text[i]))\n            buf.push(text[i]);\n        else\n            break;\n    }\n    return buf.reverse().join(\"\");\n};\n\nexports.retrieveFollowingIdentifier = function(text, pos, regex) {\n    regex = regex || ID_REGEX;\n    var buf = [];\n    for (var i = pos; i < text.length; i++) {\n        if (regex.test(text[i]))\n            buf.push(text[i]);\n        else\n            break;\n    }\n    return buf;\n};\n\nexports.getCompletionPrefix = function (editor) {\n    var pos = editor.getCursorPosition();\n    var line = editor.session.getLine(pos.row);\n    var prefix;\n    editor.completers.forEach(function(completer) {\n        if (completer.identifierRegexps) {\n            completer.identifierRegexps.forEach(function(identifierRegex) {\n                if (!prefix && identifierRegex)\n                    prefix = this.retrievePrecedingIdentifier(line, pos.column, identifierRegex);\n            }.bind(this));\n        }\n    }.bind(this));\n    return prefix || this.retrievePrecedingIdentifier(line, pos.column);\n};\n\n});\n\nace.define(\"ace/autocomplete\",[\"require\",\"exports\",\"module\",\"ace/keyboard/hash_handler\",\"ace/autocomplete/popup\",\"ace/autocomplete/util\",\"ace/lib/event\",\"ace/lib/lang\",\"ace/lib/dom\",\"ace/snippets\"], function(acequire, exports, module) {\n\"use strict\";\n\nvar HashHandler = acequire(\"./keyboard/hash_handler\").HashHandler;\nvar AcePopup = acequire(\"./autocomplete/popup\").AcePopup;\nvar util = acequire(\"./autocomplete/util\");\nvar event = acequire(\"./lib/event\");\nvar lang = acequire(\"./lib/lang\");\nvar dom = acequire(\"./lib/dom\");\nvar snippetManager = acequire(\"./snippets\").snippetManager;\n\nvar Autocomplete = function() {\n    this.autoInsert = false;\n    this.autoSelect = true;\n    this.exactMatch = false;\n    this.gatherCompletionsId = 0;\n    this.keyboardHandler = new HashHandler();\n    this.keyboardHandler.bindKeys(this.commands);\n\n    this.blurListener = this.blurListener.bind(this);\n    this.changeListener = this.changeListener.bind(this);\n    this.mousedownListener = this.mousedownListener.bind(this);\n    this.mousewheelListener = this.mousewheelListener.bind(this);\n\n    this.changeTimer = lang.delayedCall(function() {\n        this.updateCompletions(true);\n    }.bind(this));\n\n    this.tooltipTimer = lang.delayedCall(this.updateDocTooltip.bind(this), 50);\n};\n\n(function() {\n\n    this.$init = function() {\n        this.popup = new AcePopup(document.body || document.documentElement);\n        this.popup.on(\"click\", function(e) {\n            this.insertMatch();\n            e.stop();\n        }.bind(this));\n        this.popup.focus = this.editor.focus.bind(this.editor);\n        this.popup.on(\"show\", this.tooltipTimer.bind(null, null));\n        this.popup.on(\"select\", this.tooltipTimer.bind(null, null));\n        this.popup.on(\"changeHoverMarker\", this.tooltipTimer.bind(null, null));\n        return this.popup;\n    };\n\n    this.getPopup = function() {\n        return this.popup || this.$init();\n    };\n\n    this.openPopup = function(editor, prefix, keepPopupPosition) {\n        if (!this.popup)\n            this.$init();\n\n\tthis.popup.autoSelect = this.autoSelect;\n\n        this.popup.setData(this.completions.filtered);\n\n        editor.keyBinding.addKeyboardHandler(this.keyboardHandler);\n        \n        var renderer = editor.renderer;\n        this.popup.setRow(this.autoSelect ? 0 : -1);\n        if (!keepPopupPosition) {\n            this.popup.setTheme(editor.getTheme());\n            this.popup.setFontSize(editor.getFontSize());\n\n            var lineHeight = renderer.layerConfig.lineHeight;\n\n            var pos = renderer.$cursorLayer.getPixelPosition(this.base, true);\n            pos.left -= this.popup.getTextLeftOffset();\n\n            var rect = editor.container.getBoundingClientRect();\n            pos.top += rect.top - renderer.layerConfig.offset;\n            pos.left += rect.left - editor.renderer.scrollLeft;\n            pos.left += renderer.gutterWidth;\n\n            this.popup.show(pos, lineHeight);\n        } else if (keepPopupPosition && !prefix) {\n            this.detach();\n        }\n    };\n\n    this.detach = function() {\n        this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler);\n        this.editor.off(\"changeSelection\", this.changeListener);\n        this.editor.off(\"blur\", this.blurListener);\n        this.editor.off(\"mousedown\", this.mousedownListener);\n        this.editor.off(\"mousewheel\", this.mousewheelListener);\n        this.changeTimer.cancel();\n        this.hideDocTooltip();\n\n        this.gatherCompletionsId += 1;\n        if (this.popup && this.popup.isOpen)\n            this.popup.hide();\n\n        if (this.base)\n            this.base.detach();\n        this.activated = false;\n        this.completions = this.base = null;\n    };\n\n    this.changeListener = function(e) {\n        var cursor = this.editor.selection.lead;\n        if (cursor.row != this.base.row || cursor.column < this.base.column) {\n            this.detach();\n        }\n        if (this.activated)\n            this.changeTimer.schedule();\n        else\n            this.detach();\n    };\n\n    this.blurListener = function(e) {\n        var el = document.activeElement;\n        var text = this.editor.textInput.getElement();\n        var fromTooltip = e.relatedTarget && this.tooltipNode && this.tooltipNode.contains(e.relatedTarget);\n        var container = this.popup && this.popup.container;\n        if (el != text && el.parentNode != container && !fromTooltip\n            && el != this.tooltipNode && e.relatedTarget != text\n        ) {\n            this.detach();\n        }\n    };\n\n    this.mousedownListener = function(e) {\n        this.detach();\n    };\n\n    this.mousewheelListener = function(e) {\n        this.detach();\n    };\n\n    this.goTo = function(where) {\n        var row = this.popup.getRow();\n        var max = this.popup.session.getLength() - 1;\n\n        switch(where) {\n            case \"up\": row = row <= 0 ? max : row - 1; break;\n            case \"down\": row = row >= max ? -1 : row + 1; break;\n            case \"start\": row = 0; break;\n            case \"end\": row = max; break;\n        }\n\n        this.popup.setRow(row);\n    };\n\n    this.insertMatch = function(data, options) {\n        if (!data)\n            data = this.popup.getData(this.popup.getRow());\n        if (!data)\n            return false;\n\n        if (data.completer && data.completer.insertMatch) {\n            data.completer.insertMatch(this.editor, data);\n        } else {\n            if (this.completions.filterText) {\n                var ranges = this.editor.selection.getAllRanges();\n                for (var i = 0, range; range = ranges[i]; i++) {\n                    range.start.column -= this.completions.filterText.length;\n                    this.editor.session.remove(range);\n                }\n            }\n            if (data.snippet)\n                snippetManager.insertSnippet(this.editor, data.snippet);\n            else\n                this.editor.execCommand(\"insertstring\", data.value || data);\n        }\n        this.detach();\n    };\n\n\n    this.commands = {\n        \"Up\": function(editor) { editor.completer.goTo(\"up\"); },\n        \"Down\": function(editor) { editor.completer.goTo(\"down\"); },\n        \"Ctrl-Up|Ctrl-Home\": function(editor) { editor.completer.goTo(\"start\"); },\n        \"Ctrl-Down|Ctrl-End\": function(editor) { editor.completer.goTo(\"end\"); },\n\n        \"Esc\": function(editor) { editor.completer.detach(); },\n        \"Return\": function(editor) { return editor.completer.insertMatch(); },\n        \"Shift-Return\": function(editor) { editor.completer.insertMatch(null, {deleteSuffix: true}); },\n        \"Tab\": function(editor) {\n            var result = editor.completer.insertMatch();\n            if (!result && !editor.tabstopManager)\n                editor.completer.goTo(\"down\");\n            else\n                return result;\n        },\n\n        \"PageUp\": function(editor) { editor.completer.popup.gotoPageUp(); },\n        \"PageDown\": function(editor) { editor.completer.popup.gotoPageDown(); }\n    };\n\n    this.gatherCompletions = function(editor, callback) {\n        var session = editor.getSession();\n        var pos = editor.getCursorPosition();\n\n        var prefix = util.getCompletionPrefix(editor);\n\n        this.base = session.doc.createAnchor(pos.row, pos.column - prefix.length);\n        this.base.$insertRight = true;\n\n        var matches = [];\n        var total = editor.completers.length;\n        editor.completers.forEach(function(completer, i) {\n            completer.getCompletions(editor, session, pos, prefix, function(err, results) {\n                if (!err && results)\n                    matches = matches.concat(results);\n                callback(null, {\n                    prefix: util.getCompletionPrefix(editor),\n                    matches: matches,\n                    finished: (--total === 0)\n                });\n            });\n        });\n        return true;\n    };\n\n    this.showPopup = function(editor) {\n        if (this.editor)\n            this.detach();\n\n        this.activated = true;\n\n        this.editor = editor;\n        if (editor.completer != this) {\n            if (editor.completer)\n                editor.completer.detach();\n            editor.completer = this;\n        }\n\n        editor.on(\"changeSelection\", this.changeListener);\n        editor.on(\"blur\", this.blurListener);\n        editor.on(\"mousedown\", this.mousedownListener);\n        editor.on(\"mousewheel\", this.mousewheelListener);\n\n        this.updateCompletions();\n    };\n\n    this.updateCompletions = function(keepPopupPosition) {\n        if (keepPopupPosition && this.base && this.completions) {\n            var pos = this.editor.getCursorPosition();\n            var prefix = this.editor.session.getTextRange({start: this.base, end: pos});\n            if (prefix == this.completions.filterText)\n                return;\n            this.completions.setFilter(prefix);\n            if (!this.completions.filtered.length)\n                return this.detach();\n            if (this.completions.filtered.length == 1\n            && this.completions.filtered[0].value == prefix\n            && !this.completions.filtered[0].snippet)\n                return this.detach();\n            this.openPopup(this.editor, prefix, keepPopupPosition);\n            return;\n        }\n        var _id = this.gatherCompletionsId;\n        this.gatherCompletions(this.editor, function(err, results) {\n            var detachIfFinished = function() {\n                if (!results.finished) return;\n                return this.detach();\n            }.bind(this);\n\n            var prefix = results.prefix;\n            var matches = results && results.matches;\n\n            if (!matches || !matches.length)\n                return detachIfFinished();\n            if (prefix.indexOf(results.prefix) !== 0 || _id != this.gatherCompletionsId)\n                return;\n\n            this.completions = new FilteredList(matches);\n\n            if (this.exactMatch)\n                this.completions.exactMatch = true;\n\n            this.completions.setFilter(prefix);\n            var filtered = this.completions.filtered;\n            if (!filtered.length)\n                return detachIfFinished();\n            if (filtered.length == 1 && filtered[0].value == prefix && !filtered[0].snippet)\n                return detachIfFinished();\n            if (this.autoInsert && filtered.length == 1 && results.finished)\n                return this.insertMatch(filtered[0]);\n\n            this.openPopup(this.editor, prefix, keepPopupPosition);\n        }.bind(this));\n    };\n\n    this.cancelContextMenu = function() {\n        this.editor.$mouseHandler.cancelContextMenu();\n    };\n\n    this.updateDocTooltip = function() {\n        var popup = this.popup;\n        var all = popup.data;\n        var selected = all && (all[popup.getHoveredRow()] || all[popup.getRow()]);\n        var doc = null;\n        if (!selected || !this.editor || !this.popup.isOpen)\n            return this.hideDocTooltip();\n        this.editor.completers.some(function(completer) {\n            if (completer.getDocTooltip)\n                doc = completer.getDocTooltip(selected);\n            return doc;\n        });\n        if (!doc)\n            doc = selected;\n\n        if (typeof doc == \"string\")\n            doc = {docText: doc};\n        if (!doc || !(doc.docHTML || doc.docText))\n            return this.hideDocTooltip();\n        this.showDocTooltip(doc);\n    };\n\n    this.showDocTooltip = function(item) {\n        if (!this.tooltipNode) {\n            this.tooltipNode = dom.createElement(\"div\");\n            this.tooltipNode.className = \"ace_tooltip ace_doc-tooltip\";\n            this.tooltipNode.style.margin = 0;\n            this.tooltipNode.style.pointerEvents = \"auto\";\n            this.tooltipNode.tabIndex = -1;\n            this.tooltipNode.onblur = this.blurListener.bind(this);\n            this.tooltipNode.onclick = this.onTooltipClick.bind(this);\n        }\n\n        var tooltipNode = this.tooltipNode;\n        if (item.docHTML) {\n            tooltipNode.innerHTML = item.docHTML;\n        } else if (item.docText) {\n            tooltipNode.textContent = item.docText;\n        }\n\n        if (!tooltipNode.parentNode)\n            document.body.appendChild(tooltipNode);\n        var popup = this.popup;\n        var rect = popup.container.getBoundingClientRect();\n        tooltipNode.style.top = popup.container.style.top;\n        tooltipNode.style.bottom = popup.container.style.bottom;\n\n        if (window.innerWidth - rect.right < 320) {\n            tooltipNode.style.right = window.innerWidth - rect.left + \"px\";\n            tooltipNode.style.left = \"\";\n        } else {\n            tooltipNode.style.left = (rect.right + 1) + \"px\";\n            tooltipNode.style.right = \"\";\n        }\n        tooltipNode.style.display = \"block\";\n    };\n\n    this.hideDocTooltip = function() {\n        this.tooltipTimer.cancel();\n        if (!this.tooltipNode) return;\n        var el = this.tooltipNode;\n        if (!this.editor.isFocused() && document.activeElement == el)\n            this.editor.focus();\n        this.tooltipNode = null;\n        if (el.parentNode)\n            el.parentNode.removeChild(el);\n    };\n\n    this.onTooltipClick = function(e) {\n        var a = e.target;\n        while (a && a != this.tooltipNode) {\n            if (a.nodeName == \"A\" && a.href) {\n                a.rel = \"noreferrer\";\n                a.target = \"_blank\";\n                break;\n            }\n            a = a.parentNode;\n        }\n    };\n\n}).call(Autocomplete.prototype);\n\nAutocomplete.startCommand = {\n    name: \"startAutocomplete\",\n    exec: function(editor) {\n        if (!editor.completer)\n            editor.completer = new Autocomplete();\n        editor.completer.autoInsert = false;\n        editor.completer.autoSelect = true;\n        editor.completer.showPopup(editor);\n        editor.completer.cancelContextMenu();\n    },\n    bindKey: \"Ctrl-Space|Ctrl-Shift-Space|Alt-Space\"\n};\n\nvar FilteredList = function(array, filterText) {\n    this.all = array;\n    this.filtered = array;\n    this.filterText = filterText || \"\";\n    this.exactMatch = false;\n};\n(function(){\n    this.setFilter = function(str) {\n        if (str.length > this.filterText && str.lastIndexOf(this.filterText, 0) === 0)\n            var matches = this.filtered;\n        else\n            var matches = this.all;\n\n        this.filterText = str;\n        matches = this.filterCompletions(matches, this.filterText);\n        matches = matches.sort(function(a, b) {\n            return b.exactMatch - a.exactMatch || b.score - a.score;\n        });\n        var prev = null;\n        matches = matches.filter(function(item){\n            var caption = item.snippet || item.caption || item.value;\n            if (caption === prev) return false;\n            prev = caption;\n            return true;\n        });\n\n        this.filtered = matches;\n    };\n    this.filterCompletions = function(items, needle) {\n        var results = [];\n        var upper = needle.toUpperCase();\n        var lower = needle.toLowerCase();\n        loop: for (var i = 0, item; item = items[i]; i++) {\n            var caption = item.value || item.caption || item.snippet;\n            if (!caption) continue;\n            var lastIndex = -1;\n            var matchMask = 0;\n            var penalty = 0;\n            var index, distance;\n\n            if (this.exactMatch) {\n                if (needle !== caption.substr(0, needle.length))\n                    continue loop;\n            }else{\n                for (var j = 0; j < needle.length; j++) {\n                    var i1 = caption.indexOf(lower[j], lastIndex + 1);\n                    var i2 = caption.indexOf(upper[j], lastIndex + 1);\n                    index = (i1 >= 0) ? ((i2 < 0 || i1 < i2) ? i1 : i2) : i2;\n                    if (index < 0)\n                        continue loop;\n                    distance = index - lastIndex - 1;\n                    if (distance > 0) {\n                        if (lastIndex === -1)\n                            penalty += 10;\n                        penalty += distance;\n                    }\n                    matchMask = matchMask | (1 << index);\n                    lastIndex = index;\n                }\n            }\n            item.matchMask = matchMask;\n            item.exactMatch = penalty ? 0 : 1;\n            item.score = (item.score || 0) - penalty;\n            results.push(item);\n        }\n        return results;\n    };\n}).call(FilteredList.prototype);\n\nexports.Autocomplete = Autocomplete;\nexports.FilteredList = FilteredList;\n\n});\n\nace.define(\"ace/autocomplete/text_completer\",[\"require\",\"exports\",\"module\",\"ace/range\"], function(acequire, exports, module) {\n    var Range = acequire(\"../range\").Range;\n    \n    var splitRegex = /[^a-zA-Z_0-9\\$\\-\\u00C0-\\u1FFF\\u2C00-\\uD7FF\\w]+/;\n\n    function getWordIndex(doc, pos) {\n        var textBefore = doc.getTextRange(Range.fromPoints({row: 0, column:0}, pos));\n        return textBefore.split(splitRegex).length - 1;\n    }\n    function wordDistance(doc, pos) {\n        var prefixPos = getWordIndex(doc, pos);\n        var words = doc.getValue().split(splitRegex);\n        var wordScores = Object.create(null);\n        \n        var currentWord = words[prefixPos];\n\n        words.forEach(function(word, idx) {\n            if (!word || word === currentWord) return;\n\n            var distance = Math.abs(prefixPos - idx);\n            var score = words.length - distance;\n            if (wordScores[word]) {\n                wordScores[word] = Math.max(score, wordScores[word]);\n            } else {\n                wordScores[word] = score;\n            }\n        });\n        return wordScores;\n    }\n\n    exports.getCompletions = function(editor, session, pos, prefix, callback) {\n        var wordScore = wordDistance(session, pos, prefix);\n        var wordList = Object.keys(wordScore);\n        callback(null, wordList.map(function(word) {\n            return {\n                caption: word,\n                value: word,\n                score: wordScore[word],\n                meta: \"local\"\n            };\n        }));\n    };\n});\n\nace.define(\"ace/ext/language_tools\",[\"require\",\"exports\",\"module\",\"ace/snippets\",\"ace/autocomplete\",\"ace/config\",\"ace/lib/lang\",\"ace/autocomplete/util\",\"ace/autocomplete/text_completer\",\"ace/editor\",\"ace/config\"], function(acequire, exports, module) {\n\"use strict\";\n\nvar snippetManager = acequire(\"../snippets\").snippetManager;\nvar Autocomplete = acequire(\"../autocomplete\").Autocomplete;\nvar config = acequire(\"../config\");\nvar lang = acequire(\"../lib/lang\");\nvar util = acequire(\"../autocomplete/util\");\n\nvar textCompleter = acequire(\"../autocomplete/text_completer\");\nvar keyWordCompleter = {\n    getCompletions: function(editor, session, pos, prefix, callback) {\n        if (session.$mode.completer) {\n            return session.$mode.completer.getCompletions(editor, session, pos, prefix, callback);\n        }\n        var state = editor.session.getState(pos.row);\n        var completions = session.$mode.getCompletions(state, session, pos, prefix);\n        callback(null, completions);\n    }\n};\n\nvar snippetCompleter = {\n    getCompletions: function(editor, session, pos, prefix, callback) {\n        var snippetMap = snippetManager.snippetMap;\n        var completions = [];\n        snippetManager.getActiveScopes(editor).forEach(function(scope) {\n            var snippets = snippetMap[scope] || [];\n            for (var i = snippets.length; i--;) {\n                var s = snippets[i];\n                var caption = s.name || s.tabTrigger;\n                if (!caption)\n                    continue;\n                completions.push({\n                    caption: caption,\n                    snippet: s.content,\n                    meta: s.tabTrigger && !s.name ? s.tabTrigger + \"\\u21E5 \" : \"snippet\",\n                    type: \"snippet\"\n                });\n            }\n        }, this);\n        callback(null, completions);\n    },\n    getDocTooltip: function(item) {\n        if (item.type == \"snippet\" && !item.docHTML) {\n            item.docHTML = [\n                \"<b>\", lang.escapeHTML(item.caption), \"</b>\", \"<hr></hr>\",\n                lang.escapeHTML(item.snippet)\n            ].join(\"\");\n        }\n    }\n};\n\nvar completers = [snippetCompleter, textCompleter, keyWordCompleter];\nexports.setCompleters = function(val) {\n    completers.length = 0;\n    if (val) completers.push.apply(completers, val);\n};\nexports.addCompleter = function(completer) {\n    completers.push(completer);\n};\nexports.textCompleter = textCompleter;\nexports.keyWordCompleter = keyWordCompleter;\nexports.snippetCompleter = snippetCompleter;\n\nvar expandSnippet = {\n    name: \"expandSnippet\",\n    exec: function(editor) {\n        return snippetManager.expandWithTab(editor);\n    },\n    bindKey: \"Tab\"\n};\n\nvar onChangeMode = function(e, editor) {\n    loadSnippetsForMode(editor.session.$mode);\n};\n\nvar loadSnippetsForMode = function(mode) {\n    var id = mode.$id;\n    if (!snippetManager.files)\n        snippetManager.files = {};\n    loadSnippetFile(id);\n    if (mode.modes)\n        mode.modes.forEach(loadSnippetsForMode);\n};\n\nvar loadSnippetFile = function(id) {\n    if (!id || snippetManager.files[id])\n        return;\n    var snippetFilePath = id.replace(\"mode\", \"snippets\");\n    snippetManager.files[id] = {};\n    config.loadModule(snippetFilePath, function(m) {\n        if (m) {\n            snippetManager.files[id] = m;\n            if (!m.snippets && m.snippetText)\n                m.snippets = snippetManager.parseSnippetFile(m.snippetText);\n            snippetManager.register(m.snippets || [], m.scope);\n            if (m.includeScopes) {\n                snippetManager.snippetMap[m.scope].includeScopes = m.includeScopes;\n                m.includeScopes.forEach(function(x) {\n                    loadSnippetFile(\"ace/mode/\" + x);\n                });\n            }\n        }\n    });\n};\n\nvar doLiveAutocomplete = function(e) {\n    var editor = e.editor;\n    var hasCompleter = editor.completer && editor.completer.activated;\n    if (e.command.name === \"backspace\") {\n        if (hasCompleter && !util.getCompletionPrefix(editor))\n            editor.completer.detach();\n    }\n    else if (e.command.name === \"insertstring\") {\n        var prefix = util.getCompletionPrefix(editor);\n        if (prefix && !hasCompleter) {\n            if (!editor.completer) {\n                editor.completer = new Autocomplete();\n            }\n            editor.completer.autoInsert = false;\n            editor.completer.showPopup(editor);\n        }\n    }\n};\n\nvar Editor = acequire(\"../editor\").Editor;\nacequire(\"../config\").defineOptions(Editor.prototype, \"editor\", {\n    enableBasicAutocompletion: {\n        set: function(val) {\n            if (val) {\n                if (!this.completers)\n                    this.completers = Array.isArray(val)? val: completers;\n                this.commands.addCommand(Autocomplete.startCommand);\n            } else {\n                this.commands.removeCommand(Autocomplete.startCommand);\n            }\n        },\n        value: false\n    },\n    enableLiveAutocompletion: {\n        set: function(val) {\n            if (val) {\n                if (!this.completers)\n                    this.completers = Array.isArray(val)? val: completers;\n                this.commands.on('afterExec', doLiveAutocomplete);\n            } else {\n                this.commands.removeListener('afterExec', doLiveAutocomplete);\n            }\n        },\n        value: false\n    },\n    enableSnippets: {\n        set: function(val) {\n            if (val) {\n                this.commands.addCommand(expandSnippet);\n                this.on(\"changeMode\", onChangeMode);\n                onChangeMode(null, this);\n            } else {\n                this.commands.removeCommand(expandSnippet);\n                this.off(\"changeMode\", onChangeMode);\n            }\n        },\n        value: false\n    }\n});\n});\n                (function() {\n                    ace.acequire([\"ace/ext/language_tools\"], function() {});\n                })();\n            //# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/brace/ext/language_tools.js\n");

/***/ })

}]);