(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[16],{

/***/ "./node_modules/@deck.gl/aggregation-layers/dist/esm/aggregation-layer.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@deck.gl/aggregation-layers/dist/esm/aggregation-layer.js ***!
  \********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return AggregationLayer; });\n/* harmony import */ var _deck_gl_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @deck.gl/core */ \"./node_modules/@deck.gl/core/dist/esm/lib/composite-layer.js\");\n/* harmony import */ var _deck_gl_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @deck.gl/core */ \"./node_modules/@deck.gl/core/dist/esm/lifecycle/props.js\");\n/* harmony import */ var _deck_gl_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @deck.gl/core */ \"./node_modules/@deck.gl/core/dist/esm/lib/attribute/attribute-manager.js\");\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/gltools/dist/esm/index.js\");\n/* harmony import */ var _utils_prop_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./utils/prop-utils */ \"./node_modules/@deck.gl/aggregation-layers/dist/esm/utils/prop-utils.js\");\n\n\n\nclass AggregationLayer extends _deck_gl_core__WEBPACK_IMPORTED_MODULE_0__[\"default\"] {\n  initializeState(dimensions) {\n    super.initializeState();\n    this.setState({\n      ignoreProps: Object(_utils_prop_utils__WEBPACK_IMPORTED_MODULE_4__[\"filterProps\"])(this.constructor._propTypes, dimensions.data.props),\n      dimensions\n    });\n  }\n\n  updateState(opts) {\n    super.updateState(opts);\n    const {\n      changeFlags\n    } = opts;\n\n    if (changeFlags.extensionsChanged) {\n      const shaders = this.getShaders({});\n\n      if (shaders && shaders.defines) {\n        shaders.defines.NON_INSTANCED_MODEL = 1;\n      }\n\n      this.updateShaders(shaders);\n    }\n\n    this._updateAttributes(opts.props);\n  }\n\n  updateAttributes(changedAttributes) {\n    this.setState({\n      changedAttributes\n    });\n  }\n\n  getAttributes() {\n    return this.getAttributeManager().getShaderAttributes();\n  }\n\n  getModuleSettings() {\n    const {\n      viewport,\n      mousePosition,\n      gl\n    } = this.context;\n    const moduleSettings = Object.assign(Object.create(this.props), {\n      viewport,\n      mousePosition,\n      pickingActive: 0,\n      devicePixelRatio: Object(_luma_gl_core__WEBPACK_IMPORTED_MODULE_3__[\"cssToDeviceRatio\"])(gl)\n    });\n    return moduleSettings;\n  }\n\n  updateShaders(shaders) {}\n\n  isAggregationDirty(updateOpts, params = {}) {\n    const {\n      props,\n      oldProps,\n      changeFlags\n    } = updateOpts;\n    const {\n      compareAll = false,\n      dimension\n    } = params;\n    const {\n      ignoreProps\n    } = this.state;\n    const {\n      props: dataProps,\n      accessors = []\n    } = dimension;\n    const {\n      updateTriggersChanged\n    } = changeFlags;\n\n    if (changeFlags.dataChanged) {\n      return true;\n    }\n\n    if (updateTriggersChanged) {\n      if (updateTriggersChanged.all) {\n        return true;\n      }\n\n      for (const accessor of accessors) {\n        if (updateTriggersChanged[accessor]) {\n          return true;\n        }\n      }\n    }\n\n    if (compareAll) {\n      if (changeFlags.extensionsChanged) {\n        return true;\n      }\n\n      return Object(_deck_gl_core__WEBPACK_IMPORTED_MODULE_1__[\"compareProps\"])({\n        oldProps,\n        newProps: props,\n        ignoreProps,\n        propTypes: this.constructor._propTypes\n      });\n    }\n\n    for (const name of dataProps) {\n      if (props[name] !== oldProps[name]) {\n        return true;\n      }\n    }\n\n    return false;\n  }\n\n  isAttributeChanged(name) {\n    const {\n      changedAttributes\n    } = this.state;\n\n    if (!name) {\n      return !isObjectEmpty(changedAttributes);\n    }\n\n    return changedAttributes && changedAttributes[name] !== undefined;\n  }\n\n  _getAttributeManager() {\n    return new _deck_gl_core__WEBPACK_IMPORTED_MODULE_2__[\"default\"](this.context.gl, {\n      id: this.props.id,\n      stats: this.context.stats\n    });\n  }\n\n}\n\nfunction isObjectEmpty(obj) {\n  let isEmpty = true;\n\n  for (const key in obj) {\n    isEmpty = false;\n    break;\n  }\n\n  return isEmpty;\n}\n\nAggregationLayer.layerName = 'AggregationLayer';\n//# sourceMappingURL=aggregation-layer.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/aggregation-layers/dist/esm/aggregation-layer.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/aggregation-layers/dist/esm/hexagon-layer/hexagon-aggregator.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@deck.gl/aggregation-layers/dist/esm/hexagon-layer/hexagon-aggregator.js ***!
  \***********************************************************************************************/
/*! exports provided: pointToHexbin, getPointsCenter, getRadiusInCommon */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"pointToHexbin\", function() { return pointToHexbin; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getPointsCenter\", function() { return getPointsCenter; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getRadiusInCommon\", function() { return getRadiusInCommon; });\n/* harmony import */ var d3_hexbin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-hexbin */ \"./node_modules/d3-hexbin/index.js\");\n/* harmony import */ var _deck_gl_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @deck.gl/core */ \"./node_modules/@deck.gl/core/dist/esm/utils/iterable-utils.js\");\n/* harmony import */ var _deck_gl_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @deck.gl/core */ \"./node_modules/@deck.gl/core/dist/esm/utils/log.js\");\n\n\nfunction pointToHexbin(props, aggregationParams) {\n  const {\n    data,\n    radius\n  } = props;\n  const {\n    viewport,\n    attributes\n  } = aggregationParams;\n  const centerLngLat = data.length ? getPointsCenter(data, aggregationParams) : null;\n  const radiusCommon = getRadiusInCommon(radius, viewport, centerLngLat);\n  const screenPoints = [];\n  const {\n    iterable,\n    objectInfo\n  } = Object(_deck_gl_core__WEBPACK_IMPORTED_MODULE_1__[\"createIterable\"])(data);\n  const positions = attributes.positions.value;\n  const {\n    size\n  } = attributes.positions.getAccessor();\n\n  for (const object of iterable) {\n    objectInfo.index++;\n    const posIndex = objectInfo.index * size;\n    const position = [positions[posIndex], positions[posIndex + 1]];\n    const arrayIsFinite = Number.isFinite(position[0]) && Number.isFinite(position[1]);\n\n    if (arrayIsFinite) {\n      screenPoints.push({\n        screenCoord: viewport.projectFlat(position),\n        source: object,\n        index: objectInfo.index\n      });\n    } else {\n      _deck_gl_core__WEBPACK_IMPORTED_MODULE_2__[\"default\"].warn('HexagonLayer: invalid position')();\n    }\n  }\n\n  const newHexbin = Object(d3_hexbin__WEBPACK_IMPORTED_MODULE_0__[\"hexbin\"])().radius(radiusCommon).x(d => d.screenCoord[0]).y(d => d.screenCoord[1]);\n  const hexagonBins = newHexbin(screenPoints);\n  return {\n    hexagons: hexagonBins.map((hex, index) => ({\n      position: viewport.unprojectFlat([hex.x, hex.y]),\n      points: hex,\n      index\n    })),\n    radiusCommon\n  };\n}\nfunction getPointsCenter(data, aggregationParams) {\n  const {\n    attributes\n  } = aggregationParams;\n  const positions = attributes.positions.value;\n  const {\n    size\n  } = attributes.positions.getAccessor();\n  let minX = Infinity;\n  let minY = Infinity;\n  let maxX = -Infinity;\n  let maxY = -Infinity;\n  let i;\n\n  for (i = 0; i < size * data.length; i += size) {\n    const x = positions[i];\n    const y = positions[i + 1];\n    const arrayIsFinite = Number.isFinite(x) && Number.isFinite(y);\n\n    if (arrayIsFinite) {\n      minX = Math.min(x, minX);\n      maxX = Math.max(x, maxX);\n      minY = Math.min(y, minY);\n      maxY = Math.max(y, maxY);\n    }\n  }\n\n  return [minX, minY, maxX, maxY].every(Number.isFinite) ? [(minX + maxX) / 2, (minY + maxY) / 2] : null;\n}\nfunction getRadiusInCommon(radius, viewport, center) {\n  const {\n    unitsPerMeter\n  } = viewport.getDistanceScales(center);\n  return radius * unitsPerMeter[0];\n}\n//# sourceMappingURL=hexagon-aggregator.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/aggregation-layers/dist/esm/hexagon-layer/hexagon-aggregator.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/aggregation-layers/dist/esm/hexagon-layer/hexagon-layer.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@deck.gl/aggregation-layers/dist/esm/hexagon-layer/hexagon-layer.js ***!
  \******************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return HexagonLayer; });\n/* harmony import */ var _deck_gl_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @deck.gl/core */ \"./node_modules/@deck.gl/core/dist/esm/utils/log.js\");\n/* harmony import */ var _deck_gl_layers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @deck.gl/layers */ \"./node_modules/@deck.gl/layers/dist/esm/column-layer/column-layer.js\");\n/* harmony import */ var _utils_color_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/color-utils */ \"./node_modules/@deck.gl/aggregation-layers/dist/esm/utils/color-utils.js\");\n/* harmony import */ var _hexagon_aggregator__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./hexagon-aggregator */ \"./node_modules/@deck.gl/aggregation-layers/dist/esm/hexagon-layer/hexagon-aggregator.js\");\n/* harmony import */ var _utils_cpu_aggregator__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/cpu-aggregator */ \"./node_modules/@deck.gl/aggregation-layers/dist/esm/utils/cpu-aggregator.js\");\n/* harmony import */ var _aggregation_layer__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../aggregation-layer */ \"./node_modules/@deck.gl/aggregation-layers/dist/esm/aggregation-layer.js\");\n\n\n\n\n\n\n\nfunction nop() {}\n\nconst defaultProps = {\n  colorDomain: null,\n  colorRange: _utils_color_utils__WEBPACK_IMPORTED_MODULE_2__[\"defaultColorRange\"],\n  getColorValue: {\n    type: 'accessor',\n    value: null\n  },\n  getColorWeight: {\n    type: 'accessor',\n    value: 1\n  },\n  colorAggregation: 'SUM',\n  lowerPercentile: {\n    type: 'number',\n    value: 0,\n    min: 0,\n    max: 100\n  },\n  upperPercentile: {\n    type: 'number',\n    value: 100,\n    min: 0,\n    max: 100\n  },\n  colorScaleType: 'quantize',\n  onSetColorDomain: nop,\n  elevationDomain: null,\n  elevationRange: [0, 1000],\n  getElevationValue: {\n    type: 'accessor',\n    value: null\n  },\n  getElevationWeight: {\n    type: 'accessor',\n    value: 1\n  },\n  elevationAggregation: 'SUM',\n  elevationLowerPercentile: {\n    type: 'number',\n    value: 0,\n    min: 0,\n    max: 100\n  },\n  elevationUpperPercentile: {\n    type: 'number',\n    value: 100,\n    min: 0,\n    max: 100\n  },\n  elevationScale: {\n    type: 'number',\n    min: 0,\n    value: 1\n  },\n  elevationScaleType: 'linear',\n  onSetElevationDomain: nop,\n  radius: {\n    type: 'number',\n    value: 1000,\n    min: 1\n  },\n  coverage: {\n    type: 'number',\n    min: 0,\n    max: 1,\n    value: 1\n  },\n  extruded: false,\n  hexagonAggregator: _hexagon_aggregator__WEBPACK_IMPORTED_MODULE_3__[\"pointToHexbin\"],\n  getPosition: {\n    type: 'accessor',\n    value: x => x.position\n  },\n  material: true,\n  _filterData: {\n    type: 'function',\n    value: null,\n    optional: true\n  }\n};\nclass HexagonLayer extends _aggregation_layer__WEBPACK_IMPORTED_MODULE_5__[\"default\"] {\n  shouldUpdateState({\n    changeFlags\n  }) {\n    return changeFlags.somethingChanged;\n  }\n\n  initializeState() {\n    const cpuAggregator = new _utils_cpu_aggregator__WEBPACK_IMPORTED_MODULE_4__[\"default\"]({\n      getAggregator: props => props.hexagonAggregator,\n      getCellSize: props => props.radius\n    });\n    this.state = {\n      cpuAggregator,\n      aggregatorState: cpuAggregator.state,\n      hexagonVertices: null\n    };\n    const attributeManager = this.getAttributeManager();\n    attributeManager.add({\n      positions: {\n        size: 3,\n        accessor: 'getPosition'\n      }\n    });\n  }\n\n  updateState(opts) {\n    super.updateState(opts);\n    const {\n      cpuAggregator,\n      hexagonVertices: oldVertices\n    } = this.state;\n\n    if (opts.changeFlags.propsOrDataChanged) {\n      this.setState({\n        aggregatorState: cpuAggregator.updateState(opts, {\n          viewport: this.context.viewport,\n          attributes: this.getAttributes()\n        })\n      });\n    }\n\n    const {\n      hexagonVertices\n    } = cpuAggregator.state.layerData || {};\n\n    if (hexagonVertices && oldVertices !== hexagonVertices) {\n      const vertices = this.convertLatLngToMeterOffset(hexagonVertices);\n\n      if (vertices) {\n        this.setState({\n          hexagonVertices,\n          vertices\n        });\n      }\n    } else {\n      this.updateRadiusAngle();\n    }\n  }\n\n  updateRadiusAngle(vertices) {\n    const {\n      viewport\n    } = this.context;\n    const {\n      unitsPerMeter\n    } = viewport.getDistanceScales();\n    const {\n      cpuAggregator\n    } = this.state;\n\n    if (cpuAggregator.state.layerData && cpuAggregator.state.layerData.radiusCommon) {\n      const {\n        radiusCommon\n      } = cpuAggregator.state.layerData;\n      const radius = radiusCommon / unitsPerMeter[0];\n      this.setState({\n        angle: 90,\n        radius\n      });\n    }\n  }\n\n  convertLatLngToMeterOffset(hexagonVertices) {\n    const {\n      viewport\n    } = this.context;\n\n    if (Array.isArray(hexagonVertices) && hexagonVertices.length === 6) {\n      const vertex0 = hexagonVertices[0];\n      const vertex3 = hexagonVertices[3];\n      const centroid = [(vertex0[0] + vertex3[0]) / 2, (vertex0[1] + vertex3[1]) / 2];\n      const centroidFlat = viewport.projectFlat(centroid);\n      const {\n        metersPerUnit\n      } = viewport.getDistanceScales(centroid);\n      const vertices = hexagonVertices.map(vt => {\n        const vtFlat = viewport.projectFlat(vt);\n        return [(vtFlat[0] - centroidFlat[0]) * metersPerUnit[0], (vtFlat[1] - centroidFlat[1]) * metersPerUnit[1]];\n      });\n      return vertices;\n    }\n\n    _deck_gl_core__WEBPACK_IMPORTED_MODULE_0__[\"default\"].error('HexagonLayer: hexagonVertices needs to be an array of 6 points')();\n    return null;\n  }\n\n  getPickingInfo({\n    info\n  }) {\n    return this.state.cpuAggregator.getPickingInfo({\n      info\n    });\n  }\n\n  _onGetSublayerColor(cell) {\n    return this.state.cpuAggregator.getAccessor('fillColor')(cell);\n  }\n\n  _onGetSublayerElevation(cell) {\n    return this.state.cpuAggregator.getAccessor('elevation')(cell);\n  }\n\n  _getSublayerUpdateTriggers() {\n    return this.state.cpuAggregator.getUpdateTriggers(this.props);\n  }\n\n  renderLayers() {\n    const {\n      elevationScale,\n      extruded,\n      coverage,\n      material,\n      transitions\n    } = this.props;\n    const {\n      angle,\n      radius,\n      cpuAggregator,\n      vertices\n    } = this.state;\n    const SubLayerClass = this.getSubLayerClass('hexagon-cell', _deck_gl_layers__WEBPACK_IMPORTED_MODULE_1__[\"default\"]);\n\n    const updateTriggers = this._getSublayerUpdateTriggers();\n\n    const geometry = vertices && vertices.length ? {\n      vertices,\n      radius: 1\n    } : {\n      radius,\n      angle\n    };\n    return new SubLayerClass({ ...geometry,\n      diskResolution: 6,\n      elevationScale,\n      extruded,\n      coverage,\n      material,\n      getFillColor: this._onGetSublayerColor.bind(this),\n      getElevation: this._onGetSublayerElevation.bind(this),\n      transitions: transitions && {\n        getFillColor: transitions.getColorValue || transitions.getColorWeight,\n        getElevation: transitions.getElevationValue || transitions.getElevationWeight\n      }\n    }, this.getSubLayerProps({\n      id: 'hexagon-cell',\n      updateTriggers\n    }), {\n      data: cpuAggregator.state.layerData.data\n    });\n  }\n\n}\nHexagonLayer.layerName = 'HexagonLayer';\nHexagonLayer.defaultProps = defaultProps;\n//# sourceMappingURL=hexagon-layer.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/aggregation-layers/dist/esm/hexagon-layer/hexagon-layer.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/aggregation-layers/dist/esm/utils/aggregation-operation-utils.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@deck.gl/aggregation-layers/dist/esm/utils/aggregation-operation-utils.js ***!
  \************************************************************************************************/
/*! exports provided: AGGREGATION_OPERATION, getMean, getSum, getMax, getMin, getValueFunc, wrapGetValueFunc */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"AGGREGATION_OPERATION\", function() { return AGGREGATION_OPERATION; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getMean\", function() { return getMean; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getSum\", function() { return getSum; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getMax\", function() { return getMax; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getMin\", function() { return getMin; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getValueFunc\", function() { return getValueFunc; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"wrapGetValueFunc\", function() { return wrapGetValueFunc; });\nconst AGGREGATION_OPERATION = {\n  SUM: 1,\n  MEAN: 2,\n  MIN: 3,\n  MAX: 4\n};\n\nfunction sumReducer(accu, cur) {\n  return accu + cur;\n}\n\nfunction maxReducer(accu, cur) {\n  return cur > accu ? cur : accu;\n}\n\nfunction minReducer(accu, cur) {\n  return cur < accu ? cur : accu;\n}\n\nfunction getMean(pts, accessor) {\n  if (Number.isFinite(accessor)) {\n    return pts.length ? accessor : null;\n  }\n\n  const filtered = pts.map(accessor).filter(Number.isFinite);\n  return filtered.length ? filtered.reduce(sumReducer, 0) / filtered.length : null;\n}\nfunction getSum(pts, accessor) {\n  if (Number.isFinite(accessor)) {\n    return pts.length ? pts.length * accessor : null;\n  }\n\n  const filtered = pts.map(accessor).filter(Number.isFinite);\n  return filtered.length ? filtered.reduce(sumReducer, 0) : null;\n}\nfunction getMax(pts, accessor) {\n  if (Number.isFinite(accessor)) {\n    return pts.length ? accessor : null;\n  }\n\n  const filtered = pts.map(accessor).filter(Number.isFinite);\n  return filtered.length ? filtered.reduce(maxReducer, -Infinity) : null;\n}\nfunction getMin(pts, accessor) {\n  if (Number.isFinite(accessor)) {\n    return pts.length ? accessor : null;\n  }\n\n  const filtered = pts.map(accessor).filter(Number.isFinite);\n  return filtered.length ? filtered.reduce(minReducer, Infinity) : null;\n}\nfunction getValueFunc(aggregation, accessor, context) {\n  const op = AGGREGATION_OPERATION[aggregation] || AGGREGATION_OPERATION.SUM;\n  accessor = wrapAccessor(accessor, context);\n\n  switch (op) {\n    case AGGREGATION_OPERATION.MIN:\n      return pts => getMin(pts, accessor);\n\n    case AGGREGATION_OPERATION.SUM:\n      return pts => getSum(pts, accessor);\n\n    case AGGREGATION_OPERATION.MEAN:\n      return pts => getMean(pts, accessor);\n\n    case AGGREGATION_OPERATION.MAX:\n      return pts => getMax(pts, accessor);\n\n    default:\n      return null;\n  }\n}\n\nfunction wrapAccessor(accessor, context = {}) {\n  if (Number.isFinite(accessor)) {\n    return accessor;\n  }\n\n  return pt => {\n    context.index = pt.index;\n    return accessor(pt.source, context);\n  };\n}\n\nfunction wrapGetValueFunc(getValue, context = {}) {\n  return pts => {\n    context.indices = pts.map(pt => pt.index);\n    return getValue(pts.map(pt => pt.source), context);\n  };\n}\n//# sourceMappingURL=aggregation-operation-utils.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/aggregation-layers/dist/esm/utils/aggregation-operation-utils.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/aggregation-layers/dist/esm/utils/bin-sorter.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@deck.gl/aggregation-layers/dist/esm/utils/bin-sorter.js ***!
  \*******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return BinSorter; });\n/* harmony import */ var _scale_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./scale-utils */ \"./node_modules/@deck.gl/aggregation-layers/dist/esm/utils/scale-utils.js\");\nconst defaultGetValue = points => points.length;\n\n\nconst MAX_32_BIT_FLOAT = 3.402823466e38;\n\nconst defaultGetPoints = bin => bin.points;\n\nconst defaultGetIndex = bin => bin.index;\n\nconst ascending = (a, b) => a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;\n\nconst defaultProps = {\n  getValue: defaultGetValue,\n  getPoints: defaultGetPoints,\n  getIndex: defaultGetIndex,\n  filterData: null\n};\nclass BinSorter {\n  constructor(bins = [], props = defaultProps) {\n    this.aggregatedBins = this.getAggregatedBins(bins, props);\n\n    this._updateMinMaxValues();\n\n    this.binMap = this.getBinMap();\n  }\n\n  getAggregatedBins(bins, props) {\n    const {\n      getValue = defaultGetValue,\n      getPoints = defaultGetPoints,\n      getIndex = defaultGetIndex,\n      filterData\n    } = props;\n    const hasFilter = typeof filterData === 'function';\n    const binCount = bins.length;\n    const aggregatedBins = [];\n    let index = 0;\n\n    for (let binIndex = 0; binIndex < binCount; binIndex++) {\n      const bin = bins[binIndex];\n      const points = getPoints(bin);\n      const i = getIndex(bin);\n      const filteredPoints = hasFilter ? points.filter(filterData) : points;\n      bin.filteredPoints = hasFilter ? filteredPoints : null;\n      const value = filteredPoints.length ? getValue(filteredPoints) : null;\n\n      if (value !== null && value !== undefined) {\n        aggregatedBins[index] = {\n          i: Number.isFinite(i) ? i : binIndex,\n          value,\n          counts: filteredPoints.length\n        };\n        index++;\n      }\n    }\n\n    return aggregatedBins;\n  }\n\n  _percentileToIndex(percentileRange) {\n    const len = this.sortedBins.length;\n\n    if (len < 2) {\n      return [0, 0];\n    }\n\n    const [lower, upper] = percentileRange.map(n => Object(_scale_utils__WEBPACK_IMPORTED_MODULE_0__[\"clamp\"])(n, 0, 100));\n    const lowerIdx = Math.ceil(lower / 100 * (len - 1));\n    const upperIdx = Math.floor(upper / 100 * (len - 1));\n    return [lowerIdx, upperIdx];\n  }\n\n  getBinMap() {\n    const binMap = {};\n\n    for (const bin of this.aggregatedBins) {\n      binMap[bin.i] = bin;\n    }\n\n    return binMap;\n  }\n\n  _updateMinMaxValues() {\n    let maxCount = 0;\n    let maxValue = 0;\n    let minValue = MAX_32_BIT_FLOAT;\n    let totalCount = 0;\n\n    for (const x of this.aggregatedBins) {\n      maxCount = maxCount > x.counts ? maxCount : x.counts;\n      maxValue = maxValue > x.value ? maxValue : x.value;\n      minValue = minValue < x.value ? minValue : x.value;\n      totalCount += x.counts;\n    }\n\n    this.maxCount = maxCount;\n    this.maxValue = maxValue;\n    this.minValue = minValue;\n    this.totalCount = totalCount;\n  }\n\n  getValueRange(percentileRange) {\n    if (!this.sortedBins) {\n      this.sortedBins = this.aggregatedBins.sort((a, b) => ascending(a.value, b.value));\n    }\n\n    if (!this.sortedBins.length) {\n      return [];\n    }\n\n    let lowerIdx = 0;\n    let upperIdx = this.sortedBins.length - 1;\n\n    if (Array.isArray(percentileRange)) {\n      const idxRange = this._percentileToIndex(percentileRange);\n\n      lowerIdx = idxRange[0];\n      upperIdx = idxRange[1];\n    }\n\n    return [this.sortedBins[lowerIdx].value, this.sortedBins[upperIdx].value];\n  }\n\n  getValueDomainByScale(scale, [lower = 0, upper = 100] = []) {\n    if (!this.sortedBins) {\n      this.sortedBins = this.aggregatedBins.sort((a, b) => ascending(a.value, b.value));\n    }\n\n    if (!this.sortedBins.length) {\n      return [];\n    }\n\n    const indexEdge = this._percentileToIndex([lower, upper]);\n\n    return this._getScaleDomain(scale, indexEdge);\n  }\n\n  _getScaleDomain(scaleType, [lowerIdx, upperIdx]) {\n    const bins = this.sortedBins;\n\n    switch (scaleType) {\n      case 'quantize':\n      case 'linear':\n        return [bins[lowerIdx].value, bins[upperIdx].value];\n\n      case 'quantile':\n        return Object(_scale_utils__WEBPACK_IMPORTED_MODULE_0__[\"getQuantileDomain\"])(bins.slice(lowerIdx, upperIdx + 1), d => d.value);\n\n      case 'ordinal':\n        return Object(_scale_utils__WEBPACK_IMPORTED_MODULE_0__[\"getOrdinalDomain\"])(bins, d => d.value);\n\n      default:\n        return [bins[lowerIdx].value, bins[upperIdx].value];\n    }\n  }\n\n}\n//# sourceMappingURL=bin-sorter.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/aggregation-layers/dist/esm/utils/bin-sorter.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/aggregation-layers/dist/esm/utils/color-utils.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@deck.gl/aggregation-layers/dist/esm/utils/color-utils.js ***!
  \********************************************************************************/
/*! exports provided: defaultColorRange, colorRangeToFlatArray */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"defaultColorRange\", function() { return defaultColorRange; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"colorRangeToFlatArray\", function() { return colorRangeToFlatArray; });\nconst defaultColorRange = [[255, 255, 178], [254, 217, 118], [254, 178, 76], [253, 141, 60], [240, 59, 32], [189, 0, 38]];\nfunction colorRangeToFlatArray(colorRange, normalize = false, ArrayType = Float32Array) {\n  let flatArray;\n\n  if (Number.isFinite(colorRange[0])) {\n    flatArray = new ArrayType(colorRange);\n  } else {\n    flatArray = new ArrayType(colorRange.length * 4);\n    let index = 0;\n\n    for (let i = 0; i < colorRange.length; i++) {\n      const color = colorRange[i];\n      flatArray[index++] = color[0];\n      flatArray[index++] = color[1];\n      flatArray[index++] = color[2];\n      flatArray[index++] = Number.isFinite(color[3]) ? color[3] : 255;\n    }\n  }\n\n  if (normalize) {\n    for (let i = 0; i < flatArray.length; i++) {\n      flatArray[i] /= 255;\n    }\n  }\n\n  return flatArray;\n}\n//# sourceMappingURL=color-utils.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvYWdncmVnYXRpb24tbGF5ZXJzL2Rpc3QvZXNtL3V0aWxzL2NvbG9yLXV0aWxzLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0BkZWNrLmdsL2FnZ3JlZ2F0aW9uLWxheWVycy9kaXN0L2VzbS91dGlscy9jb2xvci11dGlscy5qcz8yMmQwIl0sInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCBjb25zdCBkZWZhdWx0Q29sb3JSYW5nZSA9IFtbMjU1LCAyNTUsIDE3OF0sIFsyNTQsIDIxNywgMTE4XSwgWzI1NCwgMTc4LCA3Nl0sIFsyNTMsIDE0MSwgNjBdLCBbMjQwLCA1OSwgMzJdLCBbMTg5LCAwLCAzOF1dO1xuZXhwb3J0IGZ1bmN0aW9uIGNvbG9yUmFuZ2VUb0ZsYXRBcnJheShjb2xvclJhbmdlLCBub3JtYWxpemUgPSBmYWxzZSwgQXJyYXlUeXBlID0gRmxvYXQzMkFycmF5KSB7XG4gIGxldCBmbGF0QXJyYXk7XG5cbiAgaWYgKE51bWJlci5pc0Zpbml0ZShjb2xvclJhbmdlWzBdKSkge1xuICAgIGZsYXRBcnJheSA9IG5ldyBBcnJheVR5cGUoY29sb3JSYW5nZSk7XG4gIH0gZWxzZSB7XG4gICAgZmxhdEFycmF5ID0gbmV3IEFycmF5VHlwZShjb2xvclJhbmdlLmxlbmd0aCAqIDQpO1xuICAgIGxldCBpbmRleCA9IDA7XG5cbiAgICBmb3IgKGxldCBpID0gMDsgaSA8IGNvbG9yUmFuZ2UubGVuZ3RoOyBpKyspIHtcbiAgICAgIGNvbnN0IGNvbG9yID0gY29sb3JSYW5nZVtpXTtcbiAgICAgIGZsYXRBcnJheVtpbmRleCsrXSA9IGNvbG9yWzBdO1xuICAgICAgZmxhdEFycmF5W2luZGV4KytdID0gY29sb3JbMV07XG4gICAgICBmbGF0QXJyYXlbaW5kZXgrK10gPSBjb2xvclsyXTtcbiAgICAgIGZsYXRBcnJheVtpbmRleCsrXSA9IE51bWJlci5pc0Zpbml0ZShjb2xvclszXSkgPyBjb2xvclszXSA6IDI1NTtcbiAgICB9XG4gIH1cblxuICBpZiAobm9ybWFsaXplKSB7XG4gICAgZm9yIChsZXQgaSA9IDA7IGkgPCBmbGF0QXJyYXkubGVuZ3RoOyBpKyspIHtcbiAgICAgIGZsYXRBcnJheVtpXSAvPSAyNTU7XG4gICAgfVxuICB9XG5cbiAgcmV0dXJuIGZsYXRBcnJheTtcbn1cbi8vIyBzb3VyY2VNYXBwaW5nVVJMPWNvbG9yLXV0aWxzLmpzLm1hcCJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/aggregation-layers/dist/esm/utils/color-utils.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/aggregation-layers/dist/esm/utils/cpu-aggregator.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@deck.gl/aggregation-layers/dist/esm/utils/cpu-aggregator.js ***!
  \***********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return CPUAggregator; });\n/* harmony import */ var _bin_sorter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./bin-sorter */ \"./node_modules/@deck.gl/aggregation-layers/dist/esm/utils/bin-sorter.js\");\n/* harmony import */ var _scale_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./scale-utils */ \"./node_modules/@deck.gl/aggregation-layers/dist/esm/utils/scale-utils.js\");\n/* harmony import */ var _aggregation_operation_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./aggregation-operation-utils */ \"./node_modules/@deck.gl/aggregation-layers/dist/esm/utils/aggregation-operation-utils.js\");\n\n\n\n\nfunction nop() {}\n\nconst dimensionSteps = ['getBins', 'getDomain', 'getScaleFunc'];\nconst defaultDimensions = [{\n  key: 'fillColor',\n  accessor: 'getFillColor',\n  pickingInfo: 'colorValue',\n  getBins: {\n    triggers: {\n      value: {\n        prop: 'getColorValue',\n        updateTrigger: 'getColorValue'\n      },\n      weight: {\n        prop: 'getColorWeight',\n        updateTrigger: 'getColorWeight'\n      },\n      aggregation: {\n        prop: 'colorAggregation'\n      },\n      filterData: {\n        prop: '_filterData',\n        updateTrigger: '_filterData'\n      }\n    }\n  },\n  getDomain: {\n    triggers: {\n      lowerPercentile: {\n        prop: 'lowerPercentile'\n      },\n      upperPercentile: {\n        prop: 'upperPercentile'\n      },\n      scaleType: {\n        prop: 'colorScaleType'\n      }\n    }\n  },\n  getScaleFunc: {\n    triggers: {\n      domain: {\n        prop: 'colorDomain'\n      },\n      range: {\n        prop: 'colorRange'\n      }\n    },\n    onSet: {\n      props: 'onSetColorDomain'\n    }\n  },\n  nullValue: [0, 0, 0, 0]\n}, {\n  key: 'elevation',\n  accessor: 'getElevation',\n  pickingInfo: 'elevationValue',\n  getBins: {\n    triggers: {\n      value: {\n        prop: 'getElevationValue',\n        updateTrigger: 'getElevationValue'\n      },\n      weight: {\n        prop: 'getElevationWeight',\n        updateTrigger: 'getElevationWeight'\n      },\n      aggregation: {\n        prop: 'elevationAggregation'\n      },\n      filterData: {\n        prop: '_filterData',\n        updateTrigger: '_filterData'\n      }\n    }\n  },\n  getDomain: {\n    triggers: {\n      lowerPercentile: {\n        prop: 'elevationLowerPercentile'\n      },\n      upperPercentile: {\n        prop: 'elevationUpperPercentile'\n      },\n      scaleType: {\n        prop: 'elevationScaleType'\n      }\n    }\n  },\n  getScaleFunc: {\n    triggers: {\n      domain: {\n        prop: 'elevationDomain'\n      },\n      range: {\n        prop: 'elevationRange'\n      }\n    },\n    onSet: {\n      props: 'onSetElevationDomain'\n    }\n  },\n  nullValue: -1\n}];\n\nconst defaultGetCellSize = props => props.cellSize;\n\nclass CPUAggregator {\n  constructor(opts) {\n    this.state = {\n      layerData: {},\n      dimensions: {}\n    };\n    this.changeFlags = {};\n    this.dimensionUpdaters = {};\n    this._getCellSize = opts.getCellSize || defaultGetCellSize;\n    this._getAggregator = opts.getAggregator;\n\n    this._addDimension(opts.dimensions || defaultDimensions);\n  }\n\n  static defaultDimensions() {\n    return defaultDimensions;\n  }\n\n  updateState(opts, aggregationParams) {\n    const {\n      oldProps,\n      props,\n      changeFlags\n    } = opts;\n    this.updateGetValueFuncs(oldProps, props, changeFlags);\n    const reprojectNeeded = this.needsReProjectPoints(oldProps, props, changeFlags);\n    let aggregationDirty = false;\n\n    if (changeFlags.dataChanged || reprojectNeeded) {\n      this.getAggregatedData(props, aggregationParams);\n      aggregationDirty = true;\n    } else {\n      const dimensionChanges = this.getDimensionChanges(oldProps, props, changeFlags) || [];\n      dimensionChanges.forEach(f => typeof f === 'function' && f());\n      aggregationDirty = true;\n    }\n\n    this.setState({\n      aggregationDirty\n    });\n    return this.state;\n  }\n\n  setState(updateObject) {\n    this.state = { ...this.state,\n      ...updateObject\n    };\n  }\n\n  setDimensionState(key, updateObject) {\n    this.setState({\n      dimensions: { ...this.state.dimensions,\n        [key]: { ...this.state.dimensions[key],\n          ...updateObject\n        }\n      }\n    });\n  }\n\n  normalizeResult(result = {}) {\n    if (result.hexagons) {\n      return {\n        data: result.hexagons,\n        ...result\n      };\n    } else if (result.layerData) {\n      return {\n        data: result.layerData,\n        ...result\n      };\n    }\n\n    return result;\n  }\n\n  getAggregatedData(props, aggregationParams) {\n    const aggregator = this._getAggregator(props);\n\n    const result = aggregator(props, aggregationParams);\n    this.setState({\n      layerData: this.normalizeResult(result)\n    });\n    this.changeFlags = {\n      layerData: true\n    };\n    this.getSortedBins(props);\n  }\n\n  updateGetValueFuncs(oldProps, props, changeFlags) {\n    for (const key in this.dimensionUpdaters) {\n      const {\n        value,\n        weight,\n        aggregation\n      } = this.dimensionUpdaters[key].getBins.triggers;\n      let getValue = props[value.prop];\n      const getValueChanged = this.needUpdateDimensionStep(this.dimensionUpdaters[key].getBins, oldProps, props, changeFlags);\n\n      if (getValueChanged) {\n        if (getValue) {\n          getValue = Object(_aggregation_operation_utils__WEBPACK_IMPORTED_MODULE_2__[\"wrapGetValueFunc\"])(getValue, {\n            data: props.data\n          });\n        } else {\n          getValue = Object(_aggregation_operation_utils__WEBPACK_IMPORTED_MODULE_2__[\"getValueFunc\"])(props[aggregation.prop], props[weight.prop], {\n            data: props.data\n          });\n        }\n      }\n\n      if (getValue) {\n        this.setDimensionState(key, {\n          getValue\n        });\n      }\n    }\n  }\n\n  needsReProjectPoints(oldProps, props, changeFlags) {\n    return this._getCellSize(oldProps) !== this._getCellSize(props) || this._getAggregator(oldProps) !== this._getAggregator(props) || changeFlags.updateTriggersChanged && (changeFlags.updateTriggersChanged.all || changeFlags.updateTriggersChanged.getPosition);\n  }\n\n  addDimension(dimensions) {\n    this._addDimension(dimensions);\n  }\n\n  _addDimension(dimensions = []) {\n    dimensions.forEach(dimension => {\n      const {\n        key\n      } = dimension;\n      this.dimensionUpdaters[key] = this.getDimensionUpdaters(dimension);\n      this.state.dimensions[key] = {\n        getValue: null,\n        domain: null,\n        sortedBins: null,\n        scaleFunc: nop\n      };\n    });\n  }\n\n  getDimensionUpdaters({\n    key,\n    accessor,\n    pickingInfo,\n    getBins,\n    getDomain,\n    getScaleFunc,\n    nullValue\n  }) {\n    return {\n      key,\n      accessor,\n      pickingInfo,\n      getBins: {\n        updater: this.getDimensionSortedBins,\n        ...getBins\n      },\n      getDomain: {\n        updater: this.getDimensionValueDomain,\n        ...getDomain\n      },\n      getScaleFunc: {\n        updater: this.getDimensionScale,\n        ...getScaleFunc\n      },\n      attributeAccessor: this.getSubLayerDimensionAttribute(key, nullValue)\n    };\n  }\n\n  needUpdateDimensionStep(dimensionStep, oldProps, props, changeFlags) {\n    return Object.values(dimensionStep.triggers).some(item => {\n      if (item.updateTrigger) {\n        return changeFlags.dataChanged || changeFlags.updateTriggersChanged && (changeFlags.updateTriggersChanged.all || changeFlags.updateTriggersChanged[item.updateTrigger]);\n      }\n\n      return oldProps[item.prop] !== props[item.prop];\n    });\n  }\n\n  getDimensionChanges(oldProps, props, changeFlags) {\n    const updaters = [];\n\n    for (const key in this.dimensionUpdaters) {\n      const needUpdate = dimensionSteps.find(step => this.needUpdateDimensionStep(this.dimensionUpdaters[key][step], oldProps, props, changeFlags));\n\n      if (needUpdate) {\n        updaters.push(this.dimensionUpdaters[key][needUpdate].updater.bind(this, props, this.dimensionUpdaters[key]));\n      }\n    }\n\n    return updaters.length ? updaters : null;\n  }\n\n  getUpdateTriggers(props) {\n    const _updateTriggers = props.updateTriggers || {};\n\n    const updateTriggers = {};\n\n    for (const key in this.dimensionUpdaters) {\n      const {\n        accessor\n      } = this.dimensionUpdaters[key];\n      updateTriggers[accessor] = {};\n      dimensionSteps.forEach(step => {\n        Object.values(this.dimensionUpdaters[key][step].triggers).forEach(({\n          prop,\n          updateTrigger\n        }) => {\n          if (updateTrigger) {\n            const fromProp = _updateTriggers[updateTrigger];\n\n            if (typeof fromProp === 'object' && !Array.isArray(fromProp)) {\n              Object.assign(updateTriggers[accessor], fromProp);\n            } else if (fromProp !== undefined) {\n              updateTriggers[accessor][prop] = fromProp;\n            }\n          } else {\n            updateTriggers[accessor][prop] = props[prop];\n          }\n        });\n      });\n    }\n\n    return updateTriggers;\n  }\n\n  getSortedBins(props) {\n    for (const key in this.dimensionUpdaters) {\n      this.getDimensionSortedBins(props, this.dimensionUpdaters[key]);\n    }\n  }\n\n  getDimensionSortedBins(props, dimensionUpdater) {\n    const {\n      key\n    } = dimensionUpdater;\n    const {\n      getValue\n    } = this.state.dimensions[key];\n    const sortedBins = new _bin_sorter__WEBPACK_IMPORTED_MODULE_0__[\"default\"](this.state.layerData.data || [], {\n      getValue,\n      filterData: props._filterData\n    });\n    this.setDimensionState(key, {\n      sortedBins\n    });\n    this.getDimensionValueDomain(props, dimensionUpdater);\n  }\n\n  getDimensionValueDomain(props, dimensionUpdater) {\n    const {\n      getDomain,\n      key\n    } = dimensionUpdater;\n    const {\n      triggers: {\n        lowerPercentile,\n        upperPercentile,\n        scaleType\n      }\n    } = getDomain;\n    const valueDomain = this.state.dimensions[key].sortedBins.getValueDomainByScale(props[scaleType.prop], [props[lowerPercentile.prop], props[upperPercentile.prop]]);\n    this.setDimensionState(key, {\n      valueDomain\n    });\n    this.getDimensionScale(props, dimensionUpdater);\n  }\n\n  getDimensionScale(props, dimensionUpdater) {\n    const {\n      key,\n      getScaleFunc,\n      getDomain\n    } = dimensionUpdater;\n    const {\n      domain,\n      range\n    } = getScaleFunc.triggers;\n    const {\n      scaleType\n    } = getDomain.triggers;\n    const {\n      onSet\n    } = getScaleFunc;\n    const dimensionRange = props[range.prop];\n    const dimensionDomain = props[domain.prop] || this.state.dimensions[key].valueDomain;\n    const getScaleFunction = Object(_scale_utils__WEBPACK_IMPORTED_MODULE_1__[\"getScaleFunctionByScaleType\"])(scaleType && props[scaleType.prop]);\n    const scaleFunc = getScaleFunction(dimensionDomain, dimensionRange);\n\n    if (typeof onSet === 'object' && typeof props[onSet.props] === 'function') {\n      props[onSet.props](scaleFunc.domain());\n    }\n\n    this.setDimensionState(key, {\n      scaleFunc\n    });\n  }\n\n  getSubLayerDimensionAttribute(key, nullValue) {\n    return cell => {\n      const {\n        sortedBins,\n        scaleFunc\n      } = this.state.dimensions[key];\n      const bin = sortedBins.binMap[cell.index];\n\n      if (bin && bin.counts === 0) {\n        return nullValue;\n      }\n\n      const cv = bin && bin.value;\n      const domain = scaleFunc.domain();\n      const isValueInDomain = cv >= domain[0] && cv <= domain[domain.length - 1];\n      return isValueInDomain ? scaleFunc(cv) : nullValue;\n    };\n  }\n\n  getSubLayerAccessors(props) {\n    const accessors = {};\n\n    for (const key in this.dimensionUpdaters) {\n      const {\n        accessor\n      } = this.dimensionUpdaters[key];\n      accessors[accessor] = this.getSubLayerDimensionAttribute(props, key);\n    }\n\n    return accessors;\n  }\n\n  getPickingInfo({\n    info\n  }) {\n    const isPicked = info.picked && info.index > -1;\n    let object = null;\n\n    if (isPicked) {\n      const cell = this.state.layerData.data[info.index];\n      const binInfo = {};\n\n      for (const key in this.dimensionUpdaters) {\n        const {\n          pickingInfo\n        } = this.dimensionUpdaters[key];\n        const {\n          sortedBins\n        } = this.state.dimensions[key];\n        const value = sortedBins.binMap[cell.index] && sortedBins.binMap[cell.index].value;\n        binInfo[pickingInfo] = value;\n      }\n\n      object = Object.assign(binInfo, cell, {\n        points: cell.filteredPoints || cell.points\n      });\n    }\n\n    info.picked = Boolean(object);\n    info.object = object;\n    return info;\n  }\n\n  getAccessor(dimensionKey) {\n    if (!this.dimensionUpdaters.hasOwnProperty(dimensionKey)) {\n      return nop;\n    }\n\n    return this.dimensionUpdaters[dimensionKey].attributeAccessor;\n  }\n\n}\n//# sourceMappingURL=cpu-aggregator.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/aggregation-layers/dist/esm/utils/cpu-aggregator.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/aggregation-layers/dist/esm/utils/prop-utils.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@deck.gl/aggregation-layers/dist/esm/utils/prop-utils.js ***!
  \*******************************************************************************/
/*! exports provided: filterProps */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"filterProps\", function() { return filterProps; });\nfunction filterProps(props, filterKeys) {\n  const filteredProps = {};\n\n  for (const key in props) {\n    if (!filterKeys.includes(key)) {\n      filteredProps[key] = props[key];\n    }\n  }\n\n  return filteredProps;\n}\n//# sourceMappingURL=prop-utils.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvYWdncmVnYXRpb24tbGF5ZXJzL2Rpc3QvZXNtL3V0aWxzL3Byb3AtdXRpbHMuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvYWdncmVnYXRpb24tbGF5ZXJzL2Rpc3QvZXNtL3V0aWxzL3Byb3AtdXRpbHMuanM/ZmIzNSJdLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgZnVuY3Rpb24gZmlsdGVyUHJvcHMocHJvcHMsIGZpbHRlcktleXMpIHtcbiAgY29uc3QgZmlsdGVyZWRQcm9wcyA9IHt9O1xuXG4gIGZvciAoY29uc3Qga2V5IGluIHByb3BzKSB7XG4gICAgaWYgKCFmaWx0ZXJLZXlzLmluY2x1ZGVzKGtleSkpIHtcbiAgICAgIGZpbHRlcmVkUHJvcHNba2V5XSA9IHByb3BzW2tleV07XG4gICAgfVxuICB9XG5cbiAgcmV0dXJuIGZpbHRlcmVkUHJvcHM7XG59XG4vLyMgc291cmNlTWFwcGluZ1VSTD1wcm9wLXV0aWxzLmpzLm1hcCJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/aggregation-layers/dist/esm/utils/prop-utils.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/aggregation-layers/dist/esm/utils/scale-utils.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@deck.gl/aggregation-layers/dist/esm/utils/scale-utils.js ***!
  \********************************************************************************/
/*! exports provided: getScale, getQuantizeScale, getLinearScale, getQuantileScale, getOrdinalScale, quantizeScale, linearScale, unique, getLinearDomain, getQuantileDomain, getOrdinalDomain, getScaleDomain, clamp, getScaleFunctionByScaleType */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getScale\", function() { return getScale; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getQuantizeScale\", function() { return getQuantizeScale; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getLinearScale\", function() { return getLinearScale; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getQuantileScale\", function() { return getQuantileScale; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getOrdinalScale\", function() { return getOrdinalScale; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"quantizeScale\", function() { return quantizeScale; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"linearScale\", function() { return linearScale; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"unique\", function() { return unique; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getLinearDomain\", function() { return getLinearDomain; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getQuantileDomain\", function() { return getQuantileDomain; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getOrdinalDomain\", function() { return getOrdinalDomain; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getScaleDomain\", function() { return getScaleDomain; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"clamp\", function() { return clamp; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getScaleFunctionByScaleType\", function() { return getScaleFunctionByScaleType; });\n/* harmony import */ var _deck_gl_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @deck.gl/core */ \"./node_modules/@deck.gl/core/dist/esm/utils/log.js\");\n\nfunction getScale(domain, range, scaleFunction) {\n  const scale = scaleFunction;\n\n  scale.domain = () => domain;\n\n  scale.range = () => range;\n\n  return scale;\n}\nfunction getQuantizeScale(domain, range) {\n  const scaleFunction = value => quantizeScale(domain, range, value);\n\n  return getScale(domain, range, scaleFunction);\n}\nfunction getLinearScale(domain, range) {\n  const scaleFunction = value => linearScale(domain, range, value);\n\n  return getScale(domain, range, scaleFunction);\n}\nfunction getQuantileScale(domain, range) {\n  const sortedDomain = domain.sort(ascending);\n  let i = 0;\n  const n = Math.max(1, range.length);\n  const thresholds = new Array(n - 1);\n\n  while (++i < n) {\n    thresholds[i - 1] = threshold(sortedDomain, i / n);\n  }\n\n  const scaleFunction = value => thresholdsScale(thresholds, range, value);\n\n  scaleFunction.thresholds = () => thresholds;\n\n  return getScale(domain, range, scaleFunction);\n}\n\nfunction ascending(a, b) {\n  return a - b;\n}\n\nfunction threshold(domain, fraction) {\n  const domainLength = domain.length;\n\n  if (fraction <= 0 || domainLength < 2) {\n    return domain[0];\n  }\n\n  if (fraction >= 1) {\n    return domain[domainLength - 1];\n  }\n\n  const domainFraction = (domainLength - 1) * fraction;\n  const lowIndex = Math.floor(domainFraction);\n  const low = domain[lowIndex];\n  const high = domain[lowIndex + 1];\n  return low + (high - low) * (domainFraction - lowIndex);\n}\n\nfunction bisectRight(a, x) {\n  let lo = 0;\n  let hi = a.length;\n\n  while (lo < hi) {\n    const mid = lo + hi >>> 1;\n\n    if (ascending(a[mid], x) > 0) {\n      hi = mid;\n    } else {\n      lo = mid + 1;\n    }\n  }\n\n  return lo;\n}\n\nfunction thresholdsScale(thresholds, range, value) {\n  return range[bisectRight(thresholds, value)];\n}\n\nfunction ordinalScale(domain, domainMap, range, value) {\n  const key = \"\".concat(value);\n  let d = domainMap.get(key);\n\n  if (d === undefined) {\n    d = domain.push(value);\n    domainMap.set(key, d);\n  }\n\n  return range[(d - 1) % range.length];\n}\n\nfunction getOrdinalScale(domain, range) {\n  const domainMap = new Map();\n  const uniqueDomain = [];\n\n  for (const d of domain) {\n    const key = \"\".concat(d);\n\n    if (!domainMap.has(key)) {\n      domainMap.set(key, uniqueDomain.push(d));\n    }\n  }\n\n  const scaleFunction = value => ordinalScale(uniqueDomain, domainMap, range, value);\n\n  return getScale(domain, range, scaleFunction);\n}\nfunction quantizeScale(domain, range, value) {\n  const domainRange = domain[1] - domain[0];\n\n  if (domainRange <= 0) {\n    _deck_gl_core__WEBPACK_IMPORTED_MODULE_0__[\"default\"].warn('quantizeScale: invalid domain, returning range[0]')();\n    return range[0];\n  }\n\n  const step = domainRange / range.length;\n  const idx = Math.floor((value - domain[0]) / step);\n  const clampIdx = Math.max(Math.min(idx, range.length - 1), 0);\n  return range[clampIdx];\n}\nfunction linearScale(domain, range, value) {\n  return (value - domain[0]) / (domain[1] - domain[0]) * (range[1] - range[0]) + range[0];\n}\n\nfunction notNullOrUndefined(d) {\n  return d !== undefined && d !== null;\n}\n\nfunction unique(values) {\n  const results = [];\n  values.forEach(v => {\n    if (!results.includes(v) && notNullOrUndefined(v)) {\n      results.push(v);\n    }\n  });\n  return results;\n}\n\nfunction getTruthyValues(data, valueAccessor) {\n  const values = typeof valueAccessor === 'function' ? data.map(valueAccessor) : data;\n  return values.filter(notNullOrUndefined);\n}\n\nfunction getLinearDomain(data, valueAccessor) {\n  const sorted = getTruthyValues(data, valueAccessor).sort();\n  return sorted.length ? [sorted[0], sorted[sorted.length - 1]] : [0, 0];\n}\nfunction getQuantileDomain(data, valueAccessor) {\n  return getTruthyValues(data, valueAccessor);\n}\nfunction getOrdinalDomain(data, valueAccessor) {\n  return unique(getTruthyValues(data, valueAccessor));\n}\nfunction getScaleDomain(scaleType, data, valueAccessor) {\n  switch (scaleType) {\n    case 'quantize':\n    case 'linear':\n      return getLinearDomain(data, valueAccessor);\n\n    case 'quantile':\n      return getQuantileDomain(data, valueAccessor);\n\n    case 'ordinal':\n      return getOrdinalDomain(data, valueAccessor);\n\n    default:\n      return getLinearDomain(data, valueAccessor);\n  }\n}\nfunction clamp(value, min, max) {\n  return Math.max(min, Math.min(max, value));\n}\nfunction getScaleFunctionByScaleType(scaleType) {\n  switch (scaleType) {\n    case 'quantize':\n      return getQuantizeScale;\n\n    case 'linear':\n      return getLinearScale;\n\n    case 'quantile':\n      return getQuantileScale;\n\n    case 'ordinal':\n      return getOrdinalScale;\n\n    default:\n      return getQuantizeScale;\n  }\n}\n//# sourceMappingURL=scale-utils.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/aggregation-layers/dist/esm/utils/scale-utils.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lib/composite-layer.js":
/*!********************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lib/composite-layer.js ***!
  \********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return CompositeLayer; });\n/* harmony import */ var _layer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./layer */ \"./node_modules/@deck.gl/core/dist/esm/lib/layer.js\");\n/* harmony import */ var _debug__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../debug */ \"./node_modules/@deck.gl/core/dist/esm/debug/index.js\");\n/* harmony import */ var _utils_flatten__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/flatten */ \"./node_modules/@deck.gl/core/dist/esm/utils/flatten.js\");\n\n\n\nconst TRACE_RENDER_LAYERS = 'compositeLayer.renderLayers';\nclass CompositeLayer extends _layer__WEBPACK_IMPORTED_MODULE_0__[\"default\"] {\n  get isComposite() {\n    return true;\n  }\n\n  get isLoaded() {\n    return super.isLoaded && this.getSubLayers().every(layer => layer.isLoaded);\n  }\n\n  getSubLayers() {\n    return this.internalState && this.internalState.subLayers || [];\n  }\n\n  initializeState() {}\n\n  setState(updateObject) {\n    super.setState(updateObject);\n    this.setNeedsUpdate();\n  }\n\n  getPickingInfo({\n    info\n  }) {\n    const {\n      object\n    } = info;\n    const isDataWrapped = object && object.__source && object.__source.parent && object.__source.parent.id === this.id;\n\n    if (!isDataWrapped) {\n      return info;\n    }\n\n    info.object = object.__source.object;\n    info.index = object.__source.index;\n    return info;\n  }\n\n  renderLayers() {\n    return null;\n  }\n\n  filterSubLayer(context) {\n    return true;\n  }\n\n  shouldRenderSubLayer(id, data) {\n    const {\n      _subLayerProps: overridingProps\n    } = this.props;\n    return data && data.length || overridingProps && overridingProps[id];\n  }\n\n  getSubLayerClass(id, DefaultLayerClass) {\n    const {\n      _subLayerProps: overridingProps\n    } = this.props;\n    return overridingProps && overridingProps[id] && overridingProps[id].type || DefaultLayerClass;\n  }\n\n  getSubLayerRow(row, sourceObject, sourceObjectIndex) {\n    row.__source = {\n      parent: this,\n      object: sourceObject,\n      index: sourceObjectIndex\n    };\n    return row;\n  }\n\n  getSubLayerAccessor(accessor) {\n    if (typeof accessor === 'function') {\n      const objectInfo = {\n        data: this.props.data,\n        target: []\n      };\n      return (x, i) => {\n        if (x && x.__source) {\n          objectInfo.index = x.__source.index;\n          return accessor(x.__source.object, objectInfo);\n        }\n\n        return accessor(x, i);\n      };\n    }\n\n    return accessor;\n  }\n\n  getSubLayerProps(sublayerProps = {}) {\n    const {\n      opacity,\n      pickable,\n      visible,\n      parameters,\n      getPolygonOffset,\n      highlightedObjectIndex,\n      autoHighlight,\n      highlightColor,\n      coordinateSystem,\n      coordinateOrigin,\n      wrapLongitude,\n      positionFormat,\n      modelMatrix,\n      extensions,\n      fetch,\n      _subLayerProps: overridingProps\n    } = this.props;\n    const newProps = {\n      opacity,\n      pickable,\n      visible,\n      parameters,\n      getPolygonOffset,\n      highlightedObjectIndex,\n      autoHighlight,\n      highlightColor,\n      coordinateSystem,\n      coordinateOrigin,\n      wrapLongitude,\n      positionFormat,\n      modelMatrix,\n      extensions,\n      fetch\n    };\n    const overridingSublayerProps = overridingProps && overridingProps[sublayerProps.id];\n    const overridingSublayerTriggers = overridingSublayerProps && overridingSublayerProps.updateTriggers;\n    const sublayerId = sublayerProps.id || 'sublayer';\n\n    if (overridingSublayerProps) {\n      const propTypes = this.constructor._propTypes;\n      const subLayerPropTypes = sublayerProps.type ? sublayerProps.type._propTypes : {};\n\n      for (const key in overridingSublayerProps) {\n        const propType = subLayerPropTypes[key] || propTypes[key];\n\n        if (propType && propType.type === 'accessor') {\n          overridingSublayerProps[key] = this.getSubLayerAccessor(overridingSublayerProps[key]);\n        }\n      }\n    }\n\n    Object.assign(newProps, sublayerProps, overridingSublayerProps);\n    newProps.id = \"\".concat(this.props.id, \"-\").concat(sublayerId);\n    newProps.updateTriggers = {\n      all: this.props.updateTriggers.all,\n      ...sublayerProps.updateTriggers,\n      ...overridingSublayerTriggers\n    };\n\n    for (const extension of extensions) {\n      const passThroughProps = extension.getSubLayerProps.call(this, extension);\n\n      if (passThroughProps) {\n        Object.assign(newProps, passThroughProps, {\n          updateTriggers: Object.assign(newProps.updateTriggers, passThroughProps.updateTriggers)\n        });\n      }\n    }\n\n    return newProps;\n  }\n\n  _updateAutoHighlight(info) {\n    for (const layer of this.getSubLayers()) {\n      layer.updateAutoHighlight(info);\n    }\n  }\n\n  _getAttributeManager() {\n    return null;\n  }\n\n  _renderLayers() {\n    let {\n      subLayers\n    } = this.internalState;\n    const shouldUpdate = !subLayers || this.needsUpdate();\n\n    if (shouldUpdate) {\n      subLayers = this.renderLayers();\n      subLayers = Object(_utils_flatten__WEBPACK_IMPORTED_MODULE_2__[\"flatten\"])(subLayers, Boolean);\n      this.internalState.subLayers = subLayers;\n    }\n\n    Object(_debug__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(TRACE_RENDER_LAYERS, this, shouldUpdate, subLayers);\n\n    for (const layer of subLayers) {\n      layer.parent = this;\n    }\n  }\n\n}\nCompositeLayer.layerName = 'CompositeLayer';\n//# sourceMappingURL=composite-layer.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS9saWIvY29tcG9zaXRlLWxheWVyLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0BkZWNrLmdsL2NvcmUvZGlzdC9lc20vbGliL2NvbXBvc2l0ZS1sYXllci5qcz9lNjU1Il0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBMYXllciBmcm9tICcuL2xheWVyJztcbmltcG9ydCBkZWJ1ZyBmcm9tICcuLi9kZWJ1Zyc7XG5pbXBvcnQgeyBmbGF0dGVuIH0gZnJvbSAnLi4vdXRpbHMvZmxhdHRlbic7XG5jb25zdCBUUkFDRV9SRU5ERVJfTEFZRVJTID0gJ2NvbXBvc2l0ZUxheWVyLnJlbmRlckxheWVycyc7XG5leHBvcnQgZGVmYXVsdCBjbGFzcyBDb21wb3NpdGVMYXllciBleHRlbmRzIExheWVyIHtcbiAgZ2V0IGlzQ29tcG9zaXRlKCkge1xuICAgIHJldHVybiB0cnVlO1xuICB9XG5cbiAgZ2V0IGlzTG9hZGVkKCkge1xuICAgIHJldHVybiBzdXBlci5pc0xvYWRlZCAmJiB0aGlzLmdldFN1YkxheWVycygpLmV2ZXJ5KGxheWVyID0+IGxheWVyLmlzTG9hZGVkKTtcbiAgfVxuXG4gIGdldFN1YkxheWVycygpIHtcbiAgICByZXR1cm4gdGhpcy5pbnRlcm5hbFN0YXRlICYmIHRoaXMuaW50ZXJuYWxTdGF0ZS5zdWJMYXllcnMgfHwgW107XG4gIH1cblxuICBpbml0aWFsaXplU3RhdGUoKSB7fVxuXG4gIHNldFN0YXRlKHVwZGF0ZU9iamVjdCkge1xuICAgIHN1cGVyLnNldFN0YXRlKHVwZGF0ZU9iamVjdCk7XG4gICAgdGhpcy5zZXROZWVkc1VwZGF0ZSgpO1xuICB9XG5cbiAgZ2V0UGlja2luZ0luZm8oe1xuICAgIGluZm9cbiAgfSkge1xuICAgIGNvbnN0IHtcbiAgICAgIG9iamVjdFxuICAgIH0gPSBpbmZvO1xuICAgIGNvbnN0IGlzRGF0YVdyYXBwZWQgPSBvYmplY3QgJiYgb2JqZWN0Ll9fc291cmNlICYmIG9iamVjdC5fX3NvdXJjZS5wYXJlbnQgJiYgb2JqZWN0Ll9fc291cmNlLnBhcmVudC5pZCA9PT0gdGhpcy5pZDtcblxuICAgIGlmICghaXNEYXRhV3JhcHBlZCkge1xuICAgICAgcmV0dXJuIGluZm87XG4gICAgfVxuXG4gICAgaW5mby5vYmplY3QgPSBvYmplY3QuX19zb3VyY2Uub2JqZWN0O1xuICAgIGluZm8uaW5kZXggPSBvYmplY3QuX19zb3VyY2UuaW5kZXg7XG4gICAgcmV0dXJuIGluZm87XG4gIH1cblxuICByZW5kZXJMYXllcnMoKSB7XG4gICAgcmV0dXJuIG51bGw7XG4gIH1cblxuICBmaWx0ZXJTdWJMYXllcihjb250ZXh0KSB7XG4gICAgcmV0dXJuIHRydWU7XG4gIH1cblxuICBzaG91bGRSZW5kZXJTdWJMYXllcihpZCwgZGF0YSkge1xuICAgIGNvbnN0IHtcbiAgICAgIF9zdWJMYXllclByb3BzOiBvdmVycmlkaW5nUHJvcHNcbiAgICB9ID0gdGhpcy5wcm9wcztcbiAgICByZXR1cm4gZGF0YSAmJiBkYXRhLmxlbmd0aCB8fCBvdmVycmlkaW5nUHJvcHMgJiYgb3ZlcnJpZGluZ1Byb3BzW2lkXTtcbiAgfVxuXG4gIGdldFN1YkxheWVyQ2xhc3MoaWQsIERlZmF1bHRMYXllckNsYXNzKSB7XG4gICAgY29uc3Qge1xuICAgICAgX3N1YkxheWVyUHJvcHM6IG92ZXJyaWRpbmdQcm9wc1xuICAgIH0gPSB0aGlzLnByb3BzO1xuICAgIHJldHVybiBvdmVycmlkaW5nUHJvcHMgJiYgb3ZlcnJpZGluZ1Byb3BzW2lkXSAmJiBvdmVycmlkaW5nUHJvcHNbaWRdLnR5cGUgfHwgRGVmYXVsdExheWVyQ2xhc3M7XG4gIH1cblxuICBnZXRTdWJMYXllclJvdyhyb3csIHNvdXJjZU9iamVjdCwgc291cmNlT2JqZWN0SW5kZXgpIHtcbiAgICByb3cuX19zb3VyY2UgPSB7XG4gICAgICBwYXJlbnQ6IHRoaXMsXG4gICAgICBvYmplY3Q6IHNvdXJjZU9iamVjdCxcbiAgICAgIGluZGV4OiBzb3VyY2VPYmplY3RJbmRleFxuICAgIH07XG4gICAgcmV0dXJuIHJvdztcbiAgfVxuXG4gIGdldFN1YkxheWVyQWNjZXNzb3IoYWNjZXNzb3IpIHtcbiAgICBpZiAodHlwZW9mIGFjY2Vzc29yID09PSAnZnVuY3Rpb24nKSB7XG4gICAgICBjb25zdCBvYmplY3RJbmZvID0ge1xuICAgICAgICBkYXRhOiB0aGlzLnByb3BzLmRhdGEsXG4gICAgICAgIHRhcmdldDogW11cbiAgICAgIH07XG4gICAgICByZXR1cm4gKHgsIGkpID0+IHtcbiAgICAgICAgaWYgKHggJiYgeC5fX3NvdXJjZSkge1xuICAgICAgICAgIG9iamVjdEluZm8uaW5kZXggPSB4Ll9fc291cmNlLmluZGV4O1xuICAgICAgICAgIHJldHVybiBhY2Nlc3Nvcih4Ll9fc291cmNlLm9iamVjdCwgb2JqZWN0SW5mbyk7XG4gICAgICAgIH1cblxuICAgICAgICByZXR1cm4gYWNjZXNzb3IoeCwgaSk7XG4gICAgICB9O1xuICAgIH1cblxuICAgIHJldHVybiBhY2Nlc3NvcjtcbiAgfVxuXG4gIGdldFN1YkxheWVyUHJvcHMoc3VibGF5ZXJQcm9wcyA9IHt9KSB7XG4gICAgY29uc3Qge1xuICAgICAgb3BhY2l0eSxcbiAgICAgIHBpY2thYmxlLFxuICAgICAgdmlzaWJsZSxcbiAgICAgIHBhcmFtZXRlcnMsXG4gICAgICBnZXRQb2x5Z29uT2Zmc2V0LFxuICAgICAgaGlnaGxpZ2h0ZWRPYmplY3RJbmRleCxcbiAgICAgIGF1dG9IaWdobGlnaHQsXG4gICAgICBoaWdobGlnaHRDb2xvcixcbiAgICAgIGNvb3JkaW5hdGVTeXN0ZW0sXG4gICAgICBjb29yZGluYXRlT3JpZ2luLFxuICAgICAgd3JhcExvbmdpdHVkZSxcbiAgICAgIHBvc2l0aW9uRm9ybWF0LFxuICAgICAgbW9kZWxNYXRyaXgsXG4gICAgICBleHRlbnNpb25zLFxuICAgICAgZmV0Y2gsXG4gICAgICBfc3ViTGF5ZXJQcm9wczogb3ZlcnJpZGluZ1Byb3BzXG4gICAgfSA9IHRoaXMucHJvcHM7XG4gICAgY29uc3QgbmV3UHJvcHMgPSB7XG4gICAgICBvcGFjaXR5LFxuICAgICAgcGlja2FibGUsXG4gICAgICB2aXNpYmxlLFxuICAgICAgcGFyYW1ldGVycyxcbiAgICAgIGdldFBvbHlnb25PZmZzZXQsXG4gICAgICBoaWdobGlnaHRlZE9iamVjdEluZGV4LFxuICAgICAgYXV0b0hpZ2hsaWdodCxcbiAgICAgIGhpZ2hsaWdodENvbG9yLFxuICAgICAgY29vcmRpbmF0ZVN5c3RlbSxcbiAgICAgIGNvb3JkaW5hdGVPcmlnaW4sXG4gICAgICB3cmFwTG9uZ2l0dWRlLFxuICAgICAgcG9zaXRpb25Gb3JtYXQsXG4gICAgICBtb2RlbE1hdHJpeCxcbiAgICAgIGV4dGVuc2lvbnMsXG4gICAgICBmZXRjaFxuICAgIH07XG4gICAgY29uc3Qgb3ZlcnJpZGluZ1N1YmxheWVyUHJvcHMgPSBvdmVycmlkaW5nUHJvcHMgJiYgb3ZlcnJpZGluZ1Byb3BzW3N1YmxheWVyUHJvcHMuaWRdO1xuICAgIGNvbnN0IG92ZXJyaWRpbmdTdWJsYXllclRyaWdnZXJzID0gb3ZlcnJpZGluZ1N1YmxheWVyUHJvcHMgJiYgb3ZlcnJpZGluZ1N1YmxheWVyUHJvcHMudXBkYXRlVHJpZ2dlcnM7XG4gICAgY29uc3Qgc3VibGF5ZXJJZCA9IHN1YmxheWVyUHJvcHMuaWQgfHwgJ3N1YmxheWVyJztcblxuICAgIGlmIChvdmVycmlkaW5nU3VibGF5ZXJQcm9wcykge1xuICAgICAgY29uc3QgcHJvcFR5cGVzID0gdGhpcy5jb25zdHJ1Y3Rvci5fcHJvcFR5cGVzO1xuICAgICAgY29uc3Qgc3ViTGF5ZXJQcm9wVHlwZXMgPSBzdWJsYXllclByb3BzLnR5cGUgPyBzdWJsYXllclByb3BzLnR5cGUuX3Byb3BUeXBlcyA6IHt9O1xuXG4gICAgICBmb3IgKGNvbnN0IGtleSBpbiBvdmVycmlkaW5nU3VibGF5ZXJQcm9wcykge1xuICAgICAgICBjb25zdCBwcm9wVHlwZSA9IHN1YkxheWVyUHJvcFR5cGVzW2tleV0gfHwgcHJvcFR5cGVzW2tleV07XG5cbiAgICAgICAgaWYgKHByb3BUeXBlICYmIHByb3BUeXBlLnR5cGUgPT09ICdhY2Nlc3NvcicpIHtcbiAgICAgICAgICBvdmVycmlkaW5nU3VibGF5ZXJQcm9wc1trZXldID0gdGhpcy5nZXRTdWJMYXllckFjY2Vzc29yKG92ZXJyaWRpbmdTdWJsYXllclByb3BzW2tleV0pO1xuICAgICAgICB9XG4gICAgICB9XG4gICAgfVxuXG4gICAgT2JqZWN0LmFzc2lnbihuZXdQcm9wcywgc3VibGF5ZXJQcm9wcywgb3ZlcnJpZGluZ1N1YmxheWVyUHJvcHMpO1xuICAgIG5ld1Byb3BzLmlkID0gXCJcIi5jb25jYXQodGhpcy5wcm9wcy5pZCwgXCItXCIpLmNvbmNhdChzdWJsYXllcklkKTtcbiAgICBuZXdQcm9wcy51cGRhdGVUcmlnZ2VycyA9IHtcbiAgICAgIGFsbDogdGhpcy5wcm9wcy51cGRhdGVUcmlnZ2Vycy5hbGwsXG4gICAgICAuLi5zdWJsYXllclByb3BzLnVwZGF0ZVRyaWdnZXJzLFxuICAgICAgLi4ub3ZlcnJpZGluZ1N1YmxheWVyVHJpZ2dlcnNcbiAgICB9O1xuXG4gICAgZm9yIChjb25zdCBleHRlbnNpb24gb2YgZXh0ZW5zaW9ucykge1xuICAgICAgY29uc3QgcGFzc1Rocm91Z2hQcm9wcyA9IGV4dGVuc2lvbi5nZXRTdWJMYXllclByb3BzLmNhbGwodGhpcywgZXh0ZW5zaW9uKTtcblxuICAgICAgaWYgKHBhc3NUaHJvdWdoUHJvcHMpIHtcbiAgICAgICAgT2JqZWN0LmFzc2lnbihuZXdQcm9wcywgcGFzc1Rocm91Z2hQcm9wcywge1xuICAgICAgICAgIHVwZGF0ZVRyaWdnZXJzOiBPYmplY3QuYXNzaWduKG5ld1Byb3BzLnVwZGF0ZVRyaWdnZXJzLCBwYXNzVGhyb3VnaFByb3BzLnVwZGF0ZVRyaWdnZXJzKVxuICAgICAgICB9KTtcbiAgICAgIH1cbiAgICB9XG5cbiAgICByZXR1cm4gbmV3UHJvcHM7XG4gIH1cblxuICBfdXBkYXRlQXV0b0hpZ2hsaWdodChpbmZvKSB7XG4gICAgZm9yIChjb25zdCBsYXllciBvZiB0aGlzLmdldFN1YkxheWVycygpKSB7XG4gICAgICBsYXllci51cGRhdGVBdXRvSGlnaGxpZ2h0KGluZm8pO1xuICAgIH1cbiAgfVxuXG4gIF9nZXRBdHRyaWJ1dGVNYW5hZ2VyKCkge1xuICAgIHJldHVybiBudWxsO1xuICB9XG5cbiAgX3JlbmRlckxheWVycygpIHtcbiAgICBsZXQge1xuICAgICAgc3ViTGF5ZXJzXG4gICAgfSA9IHRoaXMuaW50ZXJuYWxTdGF0ZTtcbiAgICBjb25zdCBzaG91bGRVcGRhdGUgPSAhc3ViTGF5ZXJzIHx8IHRoaXMubmVlZHNVcGRhdGUoKTtcblxuICAgIGlmIChzaG91bGRVcGRhdGUpIHtcbiAgICAgIHN1YkxheWVycyA9IHRoaXMucmVuZGVyTGF5ZXJzKCk7XG4gICAgICBzdWJMYXllcnMgPSBmbGF0dGVuKHN1YkxheWVycywgQm9vbGVhbik7XG4gICAgICB0aGlzLmludGVybmFsU3RhdGUuc3ViTGF5ZXJzID0gc3ViTGF5ZXJzO1xuICAgIH1cblxuICAgIGRlYnVnKFRSQUNFX1JFTkRFUl9MQVlFUlMsIHRoaXMsIHNob3VsZFVwZGF0ZSwgc3ViTGF5ZXJzKTtcblxuICAgIGZvciAoY29uc3QgbGF5ZXIgb2Ygc3ViTGF5ZXJzKSB7XG4gICAgICBsYXllci5wYXJlbnQgPSB0aGlzO1xuICAgIH1cbiAgfVxuXG59XG5Db21wb3NpdGVMYXllci5sYXllck5hbWUgPSAnQ29tcG9zaXRlTGF5ZXInO1xuLy8jIHNvdXJjZU1hcHBpbmdVUkw9Y29tcG9zaXRlLWxheWVyLmpzLm1hcCJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lib/composite-layer.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/layers/dist/esm/column-layer/column-geometry.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@deck.gl/layers/dist/esm/column-layer/column-geometry.js ***!
  \*******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return ColumnGeometry; });\n/* harmony import */ var _deck_gl_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @deck.gl/core */ \"./node_modules/@deck.gl/core/dist/esm/utils/log.js\");\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/engine/dist/esm/geometry/geometry.js\");\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/webgl/dist/esm/utils/utils.js\");\n/* harmony import */ var _math_gl_polygon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @math.gl/polygon */ \"./node_modules/@math.gl/polygon/dist/esm/index.js\");\n\n\n\nclass ColumnGeometry extends _luma_gl_core__WEBPACK_IMPORTED_MODULE_1__[\"default\"] {\n  constructor(props = {}) {\n    const {\n      id = Object(_luma_gl_core__WEBPACK_IMPORTED_MODULE_2__[\"uid\"])('column-geometry')\n    } = props;\n    const {\n      indices,\n      attributes\n    } = tesselateColumn(props);\n    super({ ...props,\n      id,\n      indices,\n      attributes\n    });\n  }\n\n}\n\nfunction tesselateColumn(props) {\n  const {\n    radius,\n    height = 1,\n    nradial = 10\n  } = props;\n  let {\n    vertices\n  } = props;\n\n  if (vertices) {\n    _deck_gl_core__WEBPACK_IMPORTED_MODULE_0__[\"default\"].assert(vertices.length >= nradial);\n    vertices = vertices.flatMap(v => [v[0], v[1]]);\n    Object(_math_gl_polygon__WEBPACK_IMPORTED_MODULE_3__[\"modifyPolygonWindingDirection\"])(vertices, _math_gl_polygon__WEBPACK_IMPORTED_MODULE_3__[\"WINDING\"].COUNTER_CLOCKWISE);\n  }\n\n  const isExtruded = height > 0;\n  const vertsAroundEdge = nradial + 1;\n  const numVertices = isExtruded ? vertsAroundEdge * 3 + 1 : nradial;\n  const stepAngle = Math.PI * 2 / nradial;\n  const indices = new Uint16Array(isExtruded ? nradial * 3 * 2 : 0);\n  const positions = new Float32Array(numVertices * 3);\n  const normals = new Float32Array(numVertices * 3);\n  let i = 0;\n\n  if (isExtruded) {\n    for (let j = 0; j < vertsAroundEdge; j++) {\n      const a = j * stepAngle;\n      const vertexIndex = j % nradial;\n      const sin = Math.sin(a);\n      const cos = Math.cos(a);\n\n      for (let k = 0; k < 2; k++) {\n        positions[i + 0] = vertices ? vertices[vertexIndex * 2] : cos * radius;\n        positions[i + 1] = vertices ? vertices[vertexIndex * 2 + 1] : sin * radius;\n        positions[i + 2] = (1 / 2 - k) * height;\n        normals[i + 0] = vertices ? vertices[vertexIndex * 2] : cos;\n        normals[i + 1] = vertices ? vertices[vertexIndex * 2 + 1] : sin;\n        i += 3;\n      }\n    }\n\n    positions[i + 0] = positions[i - 3];\n    positions[i + 1] = positions[i - 2];\n    positions[i + 2] = positions[i - 1];\n    i += 3;\n  }\n\n  for (let j = isExtruded ? 0 : 1; j < vertsAroundEdge; j++) {\n    const v = Math.floor(j / 2) * Math.sign(0.5 - j % 2);\n    const a = v * stepAngle;\n    const vertexIndex = (v + nradial) % nradial;\n    const sin = Math.sin(a);\n    const cos = Math.cos(a);\n    positions[i + 0] = vertices ? vertices[vertexIndex * 2] : cos * radius;\n    positions[i + 1] = vertices ? vertices[vertexIndex * 2 + 1] : sin * radius;\n    positions[i + 2] = height / 2;\n    normals[i + 2] = 1;\n    i += 3;\n  }\n\n  if (isExtruded) {\n    let index = 0;\n\n    for (let j = 0; j < nradial; j++) {\n      indices[index++] = j * 2 + 0;\n      indices[index++] = j * 2 + 2;\n      indices[index++] = j * 2 + 0;\n      indices[index++] = j * 2 + 1;\n      indices[index++] = j * 2 + 1;\n      indices[index++] = j * 2 + 3;\n    }\n  }\n\n  return {\n    indices,\n    attributes: {\n      POSITION: {\n        size: 3,\n        value: positions\n      },\n      NORMAL: {\n        size: 3,\n        value: normals\n      }\n    }\n  };\n}\n//# sourceMappingURL=column-geometry.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/layers/dist/esm/column-layer/column-geometry.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/layers/dist/esm/column-layer/column-layer-fragment.glsl.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@deck.gl/layers/dist/esm/column-layer/column-layer-fragment.glsl.js ***!
  \******************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (\"#define SHADER_NAME column-layer-fragment-shader\\n\\nprecision highp float;\\n\\nvarying vec4 vColor;\\n\\nvoid main(void) {\\n  gl_FragColor = vColor;\\n  DECKGL_FILTER_COLOR(gl_FragColor, geometry);\\n}\\n\");\n//# sourceMappingURL=column-layer-fragment.glsl.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvbGF5ZXJzL2Rpc3QvZXNtL2NvbHVtbi1sYXllci9jb2x1bW4tbGF5ZXItZnJhZ21lbnQuZ2xzbC5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9AZGVjay5nbC9sYXllcnMvZGlzdC9lc20vY29sdW1uLWxheWVyL2NvbHVtbi1sYXllci1mcmFnbWVudC5nbHNsLmpzPzE2ODQiXSwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IGRlZmF1bHQgXCIjZGVmaW5lIFNIQURFUl9OQU1FIGNvbHVtbi1sYXllci1mcmFnbWVudC1zaGFkZXJcXG5cXG5wcmVjaXNpb24gaGlnaHAgZmxvYXQ7XFxuXFxudmFyeWluZyB2ZWM0IHZDb2xvcjtcXG5cXG52b2lkIG1haW4odm9pZCkge1xcbiAgZ2xfRnJhZ0NvbG9yID0gdkNvbG9yO1xcbiAgREVDS0dMX0ZJTFRFUl9DT0xPUihnbF9GcmFnQ29sb3IsIGdlb21ldHJ5KTtcXG59XFxuXCI7XG4vLyMgc291cmNlTWFwcGluZ1VSTD1jb2x1bW4tbGF5ZXItZnJhZ21lbnQuZ2xzbC5qcy5tYXAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/layers/dist/esm/column-layer/column-layer-fragment.glsl.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/layers/dist/esm/column-layer/column-layer-vertex.glsl.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@deck.gl/layers/dist/esm/column-layer/column-layer-vertex.glsl.js ***!
  \****************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (\"\\n#define SHADER_NAME column-layer-vertex-shader\\n\\nattribute vec3 positions;\\nattribute vec3 normals;\\n\\nattribute vec3 instancePositions;\\nattribute float instanceElevations;\\nattribute vec3 instancePositions64Low;\\nattribute vec4 instanceFillColors;\\nattribute vec4 instanceLineColors;\\nattribute float instanceStrokeWidths;\\n\\nattribute vec3 instancePickingColors;\\nuniform float opacity;\\nuniform float radius;\\nuniform float angle;\\nuniform vec2 offset;\\nuniform bool extruded;\\nuniform bool isStroke;\\nuniform float coverage;\\nuniform float elevationScale;\\nuniform float edgeDistance;\\nuniform float widthScale;\\nuniform float widthMinPixels;\\nuniform float widthMaxPixels;\\nvarying vec4 vColor;\\n\\nvoid main(void) {\\n  geometry.worldPosition = instancePositions;\\n\\n  vec4 color = isStroke ? instanceLineColors : instanceFillColors;\\n  mat2 rotationMatrix = mat2(cos(angle), sin(angle), -sin(angle), cos(angle));\\n  float elevation = 0.0;\\n  float strokeOffsetRatio = 1.0;\\n\\n  if (extruded) {\\n    elevation = instanceElevations * (positions.z + 1.0) / 2.0 * elevationScale;\\n  } else if (isStroke) {\\n    float widthPixels = clamp(project_size_to_pixel(instanceStrokeWidths * widthScale),\\n      widthMinPixels, widthMaxPixels) / 2.0;\\n    strokeOffsetRatio -= sign(positions.z) * project_pixel_size(widthPixels) / project_size(edgeDistance * coverage * radius);\\n  }\\n  float shouldRender = float(color.a > 0.0 && instanceElevations >= 0.0);\\n  float dotRadius = radius * coverage * shouldRender;\\n\\n  geometry.normal = project_normal(vec3(rotationMatrix * normals.xy, normals.z));\\n  geometry.pickingColor = instancePickingColors;\\n  vec3 centroidPosition = vec3(instancePositions.xy, instancePositions.z + elevation);\\n  vec3 centroidPosition64Low = instancePositions64Low;\\n  vec3 pos = vec3(project_size(rotationMatrix * positions.xy * strokeOffsetRatio + offset) * dotRadius, 0.);\\n  DECKGL_FILTER_SIZE(pos, geometry);\\n\\n  gl_Position = project_position_to_clipspace(centroidPosition, centroidPosition64Low, pos, geometry.position);\\n  DECKGL_FILTER_GL_POSITION(gl_Position, geometry);\\n  if (extruded && !isStroke) {\\n    vec3 lightColor = lighting_getLightColor(color.rgb, project_uCameraPosition, geometry.position.xyz, geometry.normal);\\n    vColor = vec4(lightColor, color.a * opacity);\\n  } else {\\n    vColor = vec4(color.rgb, color.a * opacity);\\n  }\\n  DECKGL_FILTER_COLOR(vColor, geometry);\\n}\\n\");\n//# sourceMappingURL=column-layer-vertex.glsl.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/layers/dist/esm/column-layer/column-layer-vertex.glsl.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/layers/dist/esm/column-layer/column-layer.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@deck.gl/layers/dist/esm/column-layer/column-layer.js ***!
  \****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return ColumnLayer; });\n/* harmony import */ var _deck_gl_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @deck.gl/core */ \"./node_modules/@deck.gl/core/dist/esm/lib/layer.js\");\n/* harmony import */ var _deck_gl_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @deck.gl/core */ \"./node_modules/@deck.gl/core/dist/esm/shaderlib/project32/project32.js\");\n/* harmony import */ var _deck_gl_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @deck.gl/core */ \"./node_modules/@luma.gl/shadertools/dist/esm/modules/phong-lighting/phong-lighting.js\");\n/* harmony import */ var _deck_gl_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @deck.gl/core */ \"./node_modules/@deck.gl/core/dist/esm/shaderlib/picking/picking.js\");\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/engine/dist/esm/lib/model.js\");\n/* harmony import */ var _column_geometry__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./column-geometry */ \"./node_modules/@deck.gl/layers/dist/esm/column-layer/column-geometry.js\");\n/* harmony import */ var _column_layer_vertex_glsl__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./column-layer-vertex.glsl */ \"./node_modules/@deck.gl/layers/dist/esm/column-layer/column-layer-vertex.glsl.js\");\n/* harmony import */ var _column_layer_fragment_glsl__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./column-layer-fragment.glsl */ \"./node_modules/@deck.gl/layers/dist/esm/column-layer/column-layer-fragment.glsl.js\");\n\n\n\n\n\nconst DEFAULT_COLOR = [0, 0, 0, 255];\nconst defaultProps = {\n  diskResolution: {\n    type: 'number',\n    min: 4,\n    value: 20\n  },\n  vertices: null,\n  radius: {\n    type: 'number',\n    min: 0,\n    value: 1000\n  },\n  angle: {\n    type: 'number',\n    value: 0\n  },\n  offset: {\n    type: 'array',\n    value: [0, 0]\n  },\n  coverage: {\n    type: 'number',\n    min: 0,\n    max: 1,\n    value: 1\n  },\n  elevationScale: {\n    type: 'number',\n    min: 0,\n    value: 1\n  },\n  lineWidthUnits: 'meters',\n  lineWidthScale: 1,\n  lineWidthMinPixels: 0,\n  lineWidthMaxPixels: Number.MAX_SAFE_INTEGER,\n  extruded: true,\n  wireframe: false,\n  filled: true,\n  stroked: false,\n  getPosition: {\n    type: 'accessor',\n    value: x => x.position\n  },\n  getFillColor: {\n    type: 'accessor',\n    value: DEFAULT_COLOR\n  },\n  getLineColor: {\n    type: 'accessor',\n    value: DEFAULT_COLOR\n  },\n  getLineWidth: {\n    type: 'accessor',\n    value: 1\n  },\n  getElevation: {\n    type: 'accessor',\n    value: 1000\n  },\n  material: true,\n  getColor: {\n    deprecatedFor: ['getFillColor', 'getLineColor']\n  }\n};\nclass ColumnLayer extends _deck_gl_core__WEBPACK_IMPORTED_MODULE_0__[\"default\"] {\n  getShaders() {\n    return super.getShaders({\n      vs: _column_layer_vertex_glsl__WEBPACK_IMPORTED_MODULE_6__[\"default\"],\n      fs: _column_layer_fragment_glsl__WEBPACK_IMPORTED_MODULE_7__[\"default\"],\n      modules: [_deck_gl_core__WEBPACK_IMPORTED_MODULE_1__[\"default\"], _deck_gl_core__WEBPACK_IMPORTED_MODULE_2__[\"gouraudLighting\"], _deck_gl_core__WEBPACK_IMPORTED_MODULE_3__[\"default\"]]\n    });\n  }\n\n  initializeState() {\n    const attributeManager = this.getAttributeManager();\n    attributeManager.addInstanced({\n      instancePositions: {\n        size: 3,\n        type: 5130,\n        fp64: this.use64bitPositions(),\n        transition: true,\n        accessor: 'getPosition'\n      },\n      instanceElevations: {\n        size: 1,\n        transition: true,\n        accessor: 'getElevation'\n      },\n      instanceFillColors: {\n        size: this.props.colorFormat.length,\n        type: 5121,\n        normalized: true,\n        transition: true,\n        accessor: 'getFillColor',\n        defaultValue: DEFAULT_COLOR\n      },\n      instanceLineColors: {\n        size: this.props.colorFormat.length,\n        type: 5121,\n        normalized: true,\n        transition: true,\n        accessor: 'getLineColor',\n        defaultValue: DEFAULT_COLOR\n      },\n      instanceStrokeWidths: {\n        size: 1,\n        accessor: 'getLineWidth',\n        transition: true\n      }\n    });\n  }\n\n  updateState({\n    props,\n    oldProps,\n    changeFlags\n  }) {\n    super.updateState({\n      props,\n      oldProps,\n      changeFlags\n    });\n    const regenerateModels = changeFlags.extensionsChanged;\n\n    if (regenerateModels) {\n      var _this$state$model;\n\n      const {\n        gl\n      } = this.context;\n      (_this$state$model = this.state.model) === null || _this$state$model === void 0 ? void 0 : _this$state$model.delete();\n      this.state.model = this._getModel(gl);\n      this.getAttributeManager().invalidateAll();\n    }\n\n    if (regenerateModels || props.diskResolution !== oldProps.diskResolution || props.vertices !== oldProps.vertices || (props.extruded || props.stroked) !== (oldProps.extruded || oldProps.stroked)) {\n      this._updateGeometry(props);\n    }\n  }\n\n  getGeometry(diskResolution, vertices, hasThinkness) {\n    const geometry = new _column_geometry__WEBPACK_IMPORTED_MODULE_5__[\"default\"]({\n      radius: 1,\n      height: hasThinkness ? 2 : 0,\n      vertices,\n      nradial: diskResolution\n    });\n    let meanVertexDistance = 0;\n\n    if (vertices) {\n      for (let i = 0; i < diskResolution; i++) {\n        const p = vertices[i];\n        const d = Math.sqrt(p[0] * p[0] + p[1] * p[1]);\n        meanVertexDistance += d / diskResolution;\n      }\n    } else {\n      meanVertexDistance = 1;\n    }\n\n    this.setState({\n      edgeDistance: Math.cos(Math.PI / diskResolution) * meanVertexDistance\n    });\n    return geometry;\n  }\n\n  _getModel(gl) {\n    return new _luma_gl_core__WEBPACK_IMPORTED_MODULE_4__[\"default\"](gl, { ...this.getShaders(),\n      id: this.props.id,\n      isInstanced: true\n    });\n  }\n\n  _updateGeometry({\n    diskResolution,\n    vertices,\n    extruded,\n    stroked\n  }) {\n    const geometry = this.getGeometry(diskResolution, vertices, extruded || stroked);\n    this.setState({\n      fillVertexCount: geometry.attributes.POSITION.value.length / 3,\n      wireframeVertexCount: geometry.indices.value.length\n    });\n    this.state.model.setProps({\n      geometry\n    });\n  }\n\n  draw({\n    uniforms\n  }) {\n    const {\n      viewport\n    } = this.context;\n    const {\n      lineWidthUnits,\n      lineWidthScale,\n      lineWidthMinPixels,\n      lineWidthMaxPixels,\n      elevationScale,\n      extruded,\n      filled,\n      stroked,\n      wireframe,\n      offset,\n      coverage,\n      radius,\n      angle\n    } = this.props;\n    const {\n      model,\n      fillVertexCount,\n      wireframeVertexCount,\n      edgeDistance\n    } = this.state;\n    const widthMultiplier = lineWidthUnits === 'pixels' ? viewport.metersPerPixel : 1;\n    model.setUniforms(uniforms).setUniforms({\n      radius,\n      angle: angle / 180 * Math.PI,\n      offset,\n      extruded,\n      coverage,\n      elevationScale,\n      edgeDistance,\n      widthScale: lineWidthScale * widthMultiplier,\n      widthMinPixels: lineWidthMinPixels,\n      widthMaxPixels: lineWidthMaxPixels\n    });\n\n    if (extruded && wireframe) {\n      model.setProps({\n        isIndexed: true\n      });\n      model.setVertexCount(wireframeVertexCount).setDrawMode(1).setUniforms({\n        isStroke: true\n      }).draw();\n    }\n\n    if (filled) {\n      model.setProps({\n        isIndexed: false\n      });\n      model.setVertexCount(fillVertexCount).setDrawMode(5).setUniforms({\n        isStroke: false\n      }).draw();\n    }\n\n    if (!extruded && stroked) {\n      model.setProps({\n        isIndexed: false\n      });\n      model.setVertexCount(fillVertexCount * 2 / 3).setDrawMode(5).setUniforms({\n        isStroke: true\n      }).draw();\n    }\n  }\n\n}\nColumnLayer.layerName = 'ColumnLayer';\nColumnLayer.defaultProps = defaultProps;\n//# sourceMappingURL=column-layer.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/layers/dist/esm/column-layer/column-layer.js\n");

/***/ }),

/***/ "./node_modules/@math.gl/polygon/dist/esm/cut-by-grid.js":
/*!***************************************************************!*\
  !*** ./node_modules/@math.gl/polygon/dist/esm/cut-by-grid.js ***!
  \***************************************************************/
/*! exports provided: cutPolylineByGrid, cutPolygonByGrid */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"cutPolylineByGrid\", function() { return cutPolylineByGrid; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"cutPolygonByGrid\", function() { return cutPolygonByGrid; });\n/* harmony import */ var _lineclip__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./lineclip */ \"./node_modules/@math.gl/polygon/dist/esm/lineclip.js\");\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils */ \"./node_modules/@math.gl/polygon/dist/esm/utils.js\");\n\n\nfunction cutPolylineByGrid(positions, options = {}) {\n  const {\n    size = 2,\n    broken = false,\n    gridResolution = 10,\n    gridOffset = [0, 0],\n    startIndex = 0,\n    endIndex = positions.length\n  } = options;\n  const numPoints = (endIndex - startIndex) / size;\n  let part = [];\n  const result = [part];\n  const a = Object(_utils__WEBPACK_IMPORTED_MODULE_1__[\"getPointAtIndex\"])(positions, 0, size, startIndex);\n  let b;\n  let codeB;\n  const cell = getGridCell(a, gridResolution, gridOffset, []);\n  const scratchPoint = [];\n  Object(_utils__WEBPACK_IMPORTED_MODULE_1__[\"push\"])(part, a);\n\n  for (let i = 1; i < numPoints; i++) {\n    b = Object(_utils__WEBPACK_IMPORTED_MODULE_1__[\"getPointAtIndex\"])(positions, i, size, startIndex, b);\n    codeB = Object(_lineclip__WEBPACK_IMPORTED_MODULE_0__[\"bitCode\"])(b, cell);\n\n    while (codeB) {\n      Object(_lineclip__WEBPACK_IMPORTED_MODULE_0__[\"intersect\"])(a, b, codeB, cell, scratchPoint);\n      const codeAlt = Object(_lineclip__WEBPACK_IMPORTED_MODULE_0__[\"bitCode\"])(scratchPoint, cell);\n\n      if (codeAlt) {\n        Object(_lineclip__WEBPACK_IMPORTED_MODULE_0__[\"intersect\"])(a, scratchPoint, codeAlt, cell, scratchPoint);\n        codeB = codeAlt;\n      }\n\n      Object(_utils__WEBPACK_IMPORTED_MODULE_1__[\"push\"])(part, scratchPoint);\n      Object(_utils__WEBPACK_IMPORTED_MODULE_1__[\"copy\"])(a, scratchPoint);\n      moveToNeighborCell(cell, gridResolution, codeB);\n\n      if (broken && part.length > size) {\n        part = [];\n        result.push(part);\n        Object(_utils__WEBPACK_IMPORTED_MODULE_1__[\"push\"])(part, a);\n      }\n\n      codeB = Object(_lineclip__WEBPACK_IMPORTED_MODULE_0__[\"bitCode\"])(b, cell);\n    }\n\n    Object(_utils__WEBPACK_IMPORTED_MODULE_1__[\"push\"])(part, b);\n    Object(_utils__WEBPACK_IMPORTED_MODULE_1__[\"copy\"])(a, b);\n  }\n\n  return broken ? result : result[0];\n}\nconst TYPE_INSIDE = 0;\nconst TYPE_BORDER = 1;\n\nfunction concatInPlace(arr1, arr2) {\n  for (let i = 0; i < arr2.length; i++) {\n    arr1.push(arr2[i]);\n  }\n\n  return arr1;\n}\n\nfunction cutPolygonByGrid(positions, holeIndices, options = {}) {\n  if (!positions.length) {\n    return [];\n  }\n\n  const {\n    size = 2,\n    gridResolution = 10,\n    gridOffset = [0, 0],\n    edgeTypes = false\n  } = options;\n  const result = [];\n  const queue = [{\n    pos: positions,\n    types: edgeTypes && new Array(positions.length / size).fill(TYPE_BORDER),\n    holes: holeIndices || []\n  }];\n  const bbox = [[], []];\n  let cell = [];\n\n  while (queue.length) {\n    const {\n      pos,\n      types,\n      holes\n    } = queue.shift();\n    getBoundingBox(pos, size, holes[0] || pos.length, bbox);\n    cell = getGridCell(bbox[0], gridResolution, gridOffset, cell);\n    const code = Object(_lineclip__WEBPACK_IMPORTED_MODULE_0__[\"bitCode\"])(bbox[1], cell);\n\n    if (code) {\n      let parts = bisectPolygon(pos, types, size, 0, holes[0] || pos.length, cell, code);\n      const polygonLow = {\n        pos: parts[0].pos,\n        types: parts[0].types,\n        holes: []\n      };\n      const polygonHigh = {\n        pos: parts[1].pos,\n        types: parts[1].types,\n        holes: []\n      };\n      queue.push(polygonLow, polygonHigh);\n\n      for (let i = 0; i < holes.length; i++) {\n        parts = bisectPolygon(pos, types, size, holes[i], holes[i + 1] || pos.length, cell, code);\n\n        if (parts[0]) {\n          polygonLow.holes.push(polygonLow.pos.length);\n          polygonLow.pos = concatInPlace(polygonLow.pos, parts[0].pos);\n\n          if (edgeTypes) {\n            polygonLow.types = concatInPlace(polygonLow.types, parts[0].types);\n          }\n        }\n\n        if (parts[1]) {\n          polygonHigh.holes.push(polygonHigh.pos.length);\n          polygonHigh.pos = concatInPlace(polygonHigh.pos, parts[1].pos);\n\n          if (edgeTypes) {\n            polygonHigh.types = concatInPlace(polygonHigh.types, parts[1].types);\n          }\n        }\n      }\n    } else {\n      const polygon = {\n        positions: pos\n      };\n\n      if (edgeTypes) {\n        polygon.edgeTypes = types;\n      }\n\n      if (holes.length) {\n        polygon.holeIndices = holes;\n      }\n\n      result.push(polygon);\n    }\n  }\n\n  return result;\n}\n\nfunction bisectPolygon(positions, edgeTypes, size, startIndex, endIndex, bbox, edge) {\n  const numPoints = (endIndex - startIndex) / size;\n  const resultLow = [];\n  const resultHigh = [];\n  const typesLow = [];\n  const typesHigh = [];\n  const scratchPoint = [];\n  let p;\n  let side;\n  let type;\n  const prev = Object(_utils__WEBPACK_IMPORTED_MODULE_1__[\"getPointAtIndex\"])(positions, numPoints - 1, size, startIndex);\n  let prevSide = Math.sign(edge & 8 ? prev[1] - bbox[3] : prev[0] - bbox[2]);\n  let prevType = edgeTypes && edgeTypes[numPoints - 1];\n  let lowPointCount = 0;\n  let highPointCount = 0;\n\n  for (let i = 0; i < numPoints; i++) {\n    p = Object(_utils__WEBPACK_IMPORTED_MODULE_1__[\"getPointAtIndex\"])(positions, i, size, startIndex, p);\n    side = Math.sign(edge & 8 ? p[1] - bbox[3] : p[0] - bbox[2]);\n    type = edgeTypes && edgeTypes[startIndex / size + i];\n\n    if (side && prevSide && prevSide !== side) {\n      Object(_lineclip__WEBPACK_IMPORTED_MODULE_0__[\"intersect\"])(prev, p, edge, bbox, scratchPoint);\n      Object(_utils__WEBPACK_IMPORTED_MODULE_1__[\"push\"])(resultLow, scratchPoint) && typesLow.push(prevType);\n      Object(_utils__WEBPACK_IMPORTED_MODULE_1__[\"push\"])(resultHigh, scratchPoint) && typesHigh.push(prevType);\n    }\n\n    if (side <= 0) {\n      Object(_utils__WEBPACK_IMPORTED_MODULE_1__[\"push\"])(resultLow, p) && typesLow.push(type);\n      lowPointCount -= side;\n    } else if (typesLow.length) {\n      typesLow[typesLow.length - 1] = TYPE_INSIDE;\n    }\n\n    if (side >= 0) {\n      Object(_utils__WEBPACK_IMPORTED_MODULE_1__[\"push\"])(resultHigh, p) && typesHigh.push(type);\n      highPointCount += side;\n    } else if (typesHigh.length) {\n      typesHigh[typesHigh.length - 1] = TYPE_INSIDE;\n    }\n\n    Object(_utils__WEBPACK_IMPORTED_MODULE_1__[\"copy\"])(prev, p);\n    prevSide = side;\n    prevType = type;\n  }\n\n  return [lowPointCount ? {\n    pos: resultLow,\n    types: edgeTypes && typesLow\n  } : null, highPointCount ? {\n    pos: resultHigh,\n    types: edgeTypes && typesHigh\n  } : null];\n}\n\nfunction getGridCell(p, gridResolution, gridOffset, out) {\n  const left = Math.floor((p[0] - gridOffset[0]) / gridResolution) * gridResolution + gridOffset[0];\n  const bottom = Math.floor((p[1] - gridOffset[1]) / gridResolution) * gridResolution + gridOffset[1];\n  out[0] = left;\n  out[1] = bottom;\n  out[2] = left + gridResolution;\n  out[3] = bottom + gridResolution;\n  return out;\n}\n\nfunction moveToNeighborCell(cell, gridResolution, edge) {\n  if (edge & 8) {\n    cell[1] += gridResolution;\n    cell[3] += gridResolution;\n  } else if (edge & 4) {\n    cell[1] -= gridResolution;\n    cell[3] -= gridResolution;\n  } else if (edge & 2) {\n    cell[0] += gridResolution;\n    cell[2] += gridResolution;\n  } else if (edge & 1) {\n    cell[0] -= gridResolution;\n    cell[2] -= gridResolution;\n  }\n}\n\nfunction getBoundingBox(positions, size, endIndex, out) {\n  let minX = Infinity;\n  let maxX = -Infinity;\n  let minY = Infinity;\n  let maxY = -Infinity;\n\n  for (let i = 0; i < endIndex; i += size) {\n    const x = positions[i];\n    const y = positions[i + 1];\n    minX = x < minX ? x : minX;\n    maxX = x > maxX ? x : maxX;\n    minY = y < minY ? y : minY;\n    maxY = y > maxY ? y : maxY;\n  }\n\n  out[0][0] = minX;\n  out[0][1] = minY;\n  out[1][0] = maxX;\n  out[1][1] = maxY;\n  return out;\n}\n//# sourceMappingURL=cut-by-grid.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@math.gl/polygon/dist/esm/cut-by-grid.js\n");

/***/ }),

/***/ "./node_modules/@math.gl/polygon/dist/esm/cut-by-mercator-bounds.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@math.gl/polygon/dist/esm/cut-by-mercator-bounds.js ***!
  \**************************************************************************/
/*! exports provided: cutPolylineByMercatorBounds, cutPolygonByMercatorBounds */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"cutPolylineByMercatorBounds\", function() { return cutPolylineByMercatorBounds; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"cutPolygonByMercatorBounds\", function() { return cutPolygonByMercatorBounds; });\n/* harmony import */ var _cut_by_grid__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./cut-by-grid */ \"./node_modules/@math.gl/polygon/dist/esm/cut-by-grid.js\");\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils */ \"./node_modules/@math.gl/polygon/dist/esm/utils.js\");\n\n\nconst DEFAULT_MAX_LATITUDE = 85.051129;\nfunction cutPolylineByMercatorBounds(positions, options = {}) {\n  const {\n    size = 2,\n    startIndex = 0,\n    endIndex = positions.length,\n    normalize = true\n  } = options;\n  const newPositions = positions.slice(startIndex, endIndex);\n  wrapLongitudesForShortestPath(newPositions, size, 0, endIndex - startIndex);\n  const parts = Object(_cut_by_grid__WEBPACK_IMPORTED_MODULE_0__[\"cutPolylineByGrid\"])(newPositions, {\n    size,\n    broken: true,\n    gridResolution: 360,\n    gridOffset: [-180, -180]\n  });\n\n  if (normalize) {\n    for (const part of parts) {\n      shiftLongitudesIntoRange(part, size);\n    }\n  }\n\n  return parts;\n}\nfunction cutPolygonByMercatorBounds(positions, holeIndices, options = {}) {\n  const {\n    size = 2,\n    normalize = true,\n    edgeTypes = false\n  } = options;\n  holeIndices = holeIndices || [];\n  const newPositions = [];\n  const newHoleIndices = [];\n  let srcStartIndex = 0;\n  let targetIndex = 0;\n\n  for (let ringIndex = 0; ringIndex <= holeIndices.length; ringIndex++) {\n    const srcEndIndex = holeIndices[ringIndex] || positions.length;\n    const targetStartIndex = targetIndex;\n    const splitIndex = findSplitIndex(positions, size, srcStartIndex, srcEndIndex);\n\n    for (let i = splitIndex; i < srcEndIndex; i++) {\n      newPositions[targetIndex++] = positions[i];\n    }\n\n    for (let i = srcStartIndex; i < splitIndex; i++) {\n      newPositions[targetIndex++] = positions[i];\n    }\n\n    wrapLongitudesForShortestPath(newPositions, size, targetStartIndex, targetIndex);\n    insertPoleVertices(newPositions, size, targetStartIndex, targetIndex, options.maxLatitude);\n    srcStartIndex = srcEndIndex;\n    newHoleIndices[ringIndex] = targetIndex;\n  }\n\n  newHoleIndices.pop();\n  const parts = Object(_cut_by_grid__WEBPACK_IMPORTED_MODULE_0__[\"cutPolygonByGrid\"])(newPositions, newHoleIndices, {\n    size,\n    gridResolution: 360,\n    gridOffset: [-180, -180],\n    edgeTypes\n  });\n\n  if (normalize) {\n    for (const part of parts) {\n      shiftLongitudesIntoRange(part.positions, size);\n    }\n  }\n\n  return parts;\n}\n\nfunction findSplitIndex(positions, size, startIndex, endIndex) {\n  let maxLat = -1;\n  let pointIndex = -1;\n\n  for (let i = startIndex + 1; i < endIndex; i += size) {\n    const lat = Math.abs(positions[i]);\n\n    if (lat > maxLat) {\n      maxLat = lat;\n      pointIndex = i - 1;\n    }\n  }\n\n  return pointIndex;\n}\n\nfunction insertPoleVertices(positions, size, startIndex, endIndex, maxLatitude = DEFAULT_MAX_LATITUDE) {\n  const firstLng = positions[startIndex];\n  const lastLng = positions[endIndex - size];\n\n  if (Math.abs(firstLng - lastLng) > 180) {\n    const p = Object(_utils__WEBPACK_IMPORTED_MODULE_1__[\"getPointAtIndex\"])(positions, 0, size, startIndex);\n    p[0] += Math.round((lastLng - firstLng) / 360) * 360;\n    Object(_utils__WEBPACK_IMPORTED_MODULE_1__[\"push\"])(positions, p);\n    p[1] = Math.sign(p[1]) * maxLatitude;\n    Object(_utils__WEBPACK_IMPORTED_MODULE_1__[\"push\"])(positions, p);\n    p[0] = firstLng;\n    Object(_utils__WEBPACK_IMPORTED_MODULE_1__[\"push\"])(positions, p);\n  }\n}\n\nfunction wrapLongitudesForShortestPath(positions, size, startIndex, endIndex) {\n  let prevLng = positions[0];\n  let lng;\n\n  for (let i = startIndex; i < endIndex; i += size) {\n    lng = positions[i];\n    const delta = lng - prevLng;\n\n    if (delta > 180 || delta < -180) {\n      lng -= Math.round(delta / 360) * 360;\n    }\n\n    positions[i] = prevLng = lng;\n  }\n}\n\nfunction shiftLongitudesIntoRange(positions, size) {\n  let refLng;\n  const pointCount = positions.length / size;\n\n  for (let i = 0; i < pointCount; i++) {\n    refLng = positions[i * size];\n\n    if ((refLng + 180) % 360 !== 0) {\n      break;\n    }\n  }\n\n  const delta = -Math.round(refLng / 360) * 360;\n\n  if (delta === 0) {\n    return;\n  }\n\n  for (let i = 0; i < pointCount; i++) {\n    positions[i * size] += delta;\n  }\n}\n//# sourceMappingURL=cut-by-mercator-bounds.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@math.gl/polygon/dist/esm/cut-by-mercator-bounds.js\n");

/***/ }),

/***/ "./node_modules/@math.gl/polygon/dist/esm/earcut.js":
/*!**********************************************************!*\
  !*** ./node_modules/@math.gl/polygon/dist/esm/earcut.js ***!
  \**********************************************************/
/*! exports provided: earcut */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"earcut\", function() { return earcut; });\n/* harmony import */ var _polygon_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./polygon-utils */ \"./node_modules/@math.gl/polygon/dist/esm/polygon-utils.js\");\n\nfunction earcut(data, holeIndices, dim, areas) {\n  dim = dim || 2;\n  const hasHoles = holeIndices && holeIndices.length;\n  const outerLen = hasHoles ? holeIndices[0] * dim : data.length;\n  let outerNode = linkedList(data, 0, outerLen, dim, true, areas && areas[0]);\n  const triangles = [];\n  if (!outerNode || outerNode.next === outerNode.prev) return triangles;\n  let invSize;\n  let maxX;\n  let maxY;\n  let minX;\n  let minY;\n  let x;\n  let y;\n  if (hasHoles) outerNode = eliminateHoles(data, holeIndices, outerNode, dim, areas);\n\n  if (data.length > 80 * dim) {\n    minX = maxX = data[0];\n    minY = maxY = data[1];\n\n    for (let i = dim; i < outerLen; i += dim) {\n      x = data[i];\n      y = data[i + 1];\n      if (x < minX) minX = x;\n      if (y < minY) minY = y;\n      if (x > maxX) maxX = x;\n      if (y > maxY) maxY = y;\n    }\n\n    invSize = Math.max(maxX - minX, maxY - minY);\n    invSize = invSize !== 0 ? 1 / invSize : 0;\n  }\n\n  earcutLinked(outerNode, triangles, dim, minX, minY, invSize);\n  return triangles;\n}\n\nfunction linkedList(data, start, end, dim, clockwise, area) {\n  let i;\n  let last;\n\n  if (area === undefined) {\n    area = Object(_polygon_utils__WEBPACK_IMPORTED_MODULE_0__[\"getPolygonSignedArea\"])(data, {\n      start,\n      end,\n      size: dim\n    });\n  }\n\n  if (clockwise === area < 0) {\n    for (i = start; i < end; i += dim) last = insertNode(i, data[i], data[i + 1], last);\n  } else {\n    for (i = end - dim; i >= start; i -= dim) last = insertNode(i, data[i], data[i + 1], last);\n  }\n\n  if (last && equals(last, last.next)) {\n    removeNode(last);\n    last = last.next;\n  }\n\n  return last;\n}\n\nfunction filterPoints(start, end) {\n  if (!start) return start;\n  if (!end) end = start;\n  let p = start;\n  let again;\n\n  do {\n    again = false;\n\n    if (!p.steiner && (equals(p, p.next) || area(p.prev, p, p.next) === 0)) {\n      removeNode(p);\n      p = end = p.prev;\n      if (p === p.next) break;\n      again = true;\n    } else {\n      p = p.next;\n    }\n  } while (again || p !== end);\n\n  return end;\n}\n\nfunction earcutLinked(ear, triangles, dim, minX, minY, invSize, pass) {\n  if (!ear) return;\n  if (!pass && invSize) indexCurve(ear, minX, minY, invSize);\n  let stop = ear;\n  let prev;\n  let next;\n\n  while (ear.prev !== ear.next) {\n    prev = ear.prev;\n    next = ear.next;\n\n    if (invSize ? isEarHashed(ear, minX, minY, invSize) : isEar(ear)) {\n      triangles.push(prev.i / dim);\n      triangles.push(ear.i / dim);\n      triangles.push(next.i / dim);\n      removeNode(ear);\n      ear = next.next;\n      stop = next.next;\n      continue;\n    }\n\n    ear = next;\n\n    if (ear === stop) {\n      if (!pass) {\n        earcutLinked(filterPoints(ear), triangles, dim, minX, minY, invSize, 1);\n      } else if (pass === 1) {\n        ear = cureLocalIntersections(filterPoints(ear), triangles, dim);\n        earcutLinked(ear, triangles, dim, minX, minY, invSize, 2);\n      } else if (pass === 2) {\n        splitEarcut(ear, triangles, dim, minX, minY, invSize);\n      }\n\n      break;\n    }\n  }\n}\n\nfunction isEar(ear) {\n  const a = ear.prev;\n  const b = ear;\n  const c = ear.next;\n  if (area(a, b, c) >= 0) return false;\n  let p = ear.next.next;\n\n  while (p !== ear.prev) {\n    if (pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, p.x, p.y) && area(p.prev, p, p.next) >= 0) return false;\n    p = p.next;\n  }\n\n  return true;\n}\n\nfunction isEarHashed(ear, minX, minY, invSize) {\n  const a = ear.prev;\n  const b = ear;\n  const c = ear.next;\n  if (area(a, b, c) >= 0) return false;\n  const minTX = a.x < b.x ? a.x < c.x ? a.x : c.x : b.x < c.x ? b.x : c.x;\n  const minTY = a.y < b.y ? a.y < c.y ? a.y : c.y : b.y < c.y ? b.y : c.y;\n  const maxTX = a.x > b.x ? a.x > c.x ? a.x : c.x : b.x > c.x ? b.x : c.x;\n  const maxTY = a.y > b.y ? a.y > c.y ? a.y : c.y : b.y > c.y ? b.y : c.y;\n  const minZ = zOrder(minTX, minTY, minX, minY, invSize);\n  const maxZ = zOrder(maxTX, maxTY, minX, minY, invSize);\n  let p = ear.prevZ;\n  let n = ear.nextZ;\n\n  while (p && p.z >= minZ && n && n.z <= maxZ) {\n    if (p !== ear.prev && p !== ear.next && pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, p.x, p.y) && area(p.prev, p, p.next) >= 0) return false;\n    p = p.prevZ;\n    if (n !== ear.prev && n !== ear.next && pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, n.x, n.y) && area(n.prev, n, n.next) >= 0) return false;\n    n = n.nextZ;\n  }\n\n  while (p && p.z >= minZ) {\n    if (p !== ear.prev && p !== ear.next && pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, p.x, p.y) && area(p.prev, p, p.next) >= 0) return false;\n    p = p.prevZ;\n  }\n\n  while (n && n.z <= maxZ) {\n    if (n !== ear.prev && n !== ear.next && pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, n.x, n.y) && area(n.prev, n, n.next) >= 0) return false;\n    n = n.nextZ;\n  }\n\n  return true;\n}\n\nfunction cureLocalIntersections(start, triangles, dim) {\n  let p = start;\n\n  do {\n    const a = p.prev;\n    const b = p.next.next;\n\n    if (!equals(a, b) && intersects(a, p, p.next, b) && locallyInside(a, b) && locallyInside(b, a)) {\n      triangles.push(a.i / dim);\n      triangles.push(p.i / dim);\n      triangles.push(b.i / dim);\n      removeNode(p);\n      removeNode(p.next);\n      p = start = b;\n    }\n\n    p = p.next;\n  } while (p !== start);\n\n  return filterPoints(p);\n}\n\nfunction splitEarcut(start, triangles, dim, minX, minY, invSize) {\n  let a = start;\n\n  do {\n    let b = a.next.next;\n\n    while (b !== a.prev) {\n      if (a.i !== b.i && isValidDiagonal(a, b)) {\n        let c = splitPolygon(a, b);\n        a = filterPoints(a, a.next);\n        c = filterPoints(c, c.next);\n        earcutLinked(a, triangles, dim, minX, minY, invSize);\n        earcutLinked(c, triangles, dim, minX, minY, invSize);\n        return;\n      }\n\n      b = b.next;\n    }\n\n    a = a.next;\n  } while (a !== start);\n}\n\nfunction eliminateHoles(data, holeIndices, outerNode, dim, areas) {\n  const queue = [];\n  let i;\n  let len;\n  let start;\n  let end;\n  let list;\n\n  for (i = 0, len = holeIndices.length; i < len; i++) {\n    start = holeIndices[i] * dim;\n    end = i < len - 1 ? holeIndices[i + 1] * dim : data.length;\n    list = linkedList(data, start, end, dim, false, areas && areas[i + 1]);\n    if (list === list.next) list.steiner = true;\n    queue.push(getLeftmost(list));\n  }\n\n  queue.sort(compareX);\n\n  for (i = 0; i < queue.length; i++) {\n    eliminateHole(queue[i], outerNode);\n    outerNode = filterPoints(outerNode, outerNode.next);\n  }\n\n  return outerNode;\n}\n\nfunction compareX(a, b) {\n  return a.x - b.x;\n}\n\nfunction eliminateHole(hole, outerNode) {\n  outerNode = findHoleBridge(hole, outerNode);\n\n  if (outerNode) {\n    const b = splitPolygon(outerNode, hole);\n    filterPoints(outerNode, outerNode.next);\n    filterPoints(b, b.next);\n  }\n}\n\nfunction findHoleBridge(hole, outerNode) {\n  let p = outerNode;\n  const hx = hole.x;\n  const hy = hole.y;\n  let qx = -Infinity;\n  let m;\n\n  do {\n    if (hy <= p.y && hy >= p.next.y && p.next.y !== p.y) {\n      const x = p.x + (hy - p.y) * (p.next.x - p.x) / (p.next.y - p.y);\n\n      if (x <= hx && x > qx) {\n        qx = x;\n\n        if (x === hx) {\n          if (hy === p.y) return p;\n          if (hy === p.next.y) return p.next;\n        }\n\n        m = p.x < p.next.x ? p : p.next;\n      }\n    }\n\n    p = p.next;\n  } while (p !== outerNode);\n\n  if (!m) return null;\n  if (hx === qx) return m;\n  const stop = m;\n  const mx = m.x;\n  const my = m.y;\n  let tanMin = Infinity;\n  let tan;\n  p = m;\n\n  do {\n    if (hx >= p.x && p.x >= mx && hx !== p.x && pointInTriangle(hy < my ? hx : qx, hy, mx, my, hy < my ? qx : hx, hy, p.x, p.y)) {\n      tan = Math.abs(hy - p.y) / (hx - p.x);\n\n      if (locallyInside(p, hole) && (tan < tanMin || tan === tanMin && (p.x > m.x || p.x === m.x && sectorContainsSector(m, p)))) {\n        m = p;\n        tanMin = tan;\n      }\n    }\n\n    p = p.next;\n  } while (p !== stop);\n\n  return m;\n}\n\nfunction sectorContainsSector(m, p) {\n  return area(m.prev, m, p.prev) < 0 && area(p.next, m, m.next) < 0;\n}\n\nfunction indexCurve(start, minX, minY, invSize) {\n  let p = start;\n\n  do {\n    if (p.z === null) p.z = zOrder(p.x, p.y, minX, minY, invSize);\n    p.prevZ = p.prev;\n    p.nextZ = p.next;\n    p = p.next;\n  } while (p !== start);\n\n  p.prevZ.nextZ = null;\n  p.prevZ = null;\n  sortLinked(p);\n}\n\nfunction sortLinked(list) {\n  let e;\n  let i;\n  let inSize = 1;\n  let numMerges;\n  let p;\n  let pSize;\n  let q;\n  let qSize;\n  let tail;\n\n  do {\n    p = list;\n    list = null;\n    tail = null;\n    numMerges = 0;\n\n    while (p) {\n      numMerges++;\n      q = p;\n      pSize = 0;\n\n      for (i = 0; i < inSize; i++) {\n        pSize++;\n        q = q.nextZ;\n        if (!q) break;\n      }\n\n      qSize = inSize;\n\n      while (pSize > 0 || qSize > 0 && q) {\n        if (pSize !== 0 && (qSize === 0 || !q || p.z <= q.z)) {\n          e = p;\n          p = p.nextZ;\n          pSize--;\n        } else {\n          e = q;\n          q = q.nextZ;\n          qSize--;\n        }\n\n        if (tail) tail.nextZ = e;else list = e;\n        e.prevZ = tail;\n        tail = e;\n      }\n\n      p = q;\n    }\n\n    tail.nextZ = null;\n    inSize *= 2;\n  } while (numMerges > 1);\n\n  return list;\n}\n\nfunction zOrder(x, y, minX, minY, invSize) {\n  x = 32767 * (x - minX) * invSize;\n  y = 32767 * (y - minY) * invSize;\n  x = (x | x << 8) & 0x00ff00ff;\n  x = (x | x << 4) & 0x0f0f0f0f;\n  x = (x | x << 2) & 0x33333333;\n  x = (x | x << 1) & 0x55555555;\n  y = (y | y << 8) & 0x00ff00ff;\n  y = (y | y << 4) & 0x0f0f0f0f;\n  y = (y | y << 2) & 0x33333333;\n  y = (y | y << 1) & 0x55555555;\n  return x | y << 1;\n}\n\nfunction getLeftmost(start) {\n  let p = start;\n  let leftmost = start;\n\n  do {\n    if (p.x < leftmost.x || p.x === leftmost.x && p.y < leftmost.y) leftmost = p;\n    p = p.next;\n  } while (p !== start);\n\n  return leftmost;\n}\n\nfunction pointInTriangle(ax, ay, bx, by, cx, cy, px, py) {\n  return (cx - px) * (ay - py) - (ax - px) * (cy - py) >= 0 && (ax - px) * (by - py) - (bx - px) * (ay - py) >= 0 && (bx - px) * (cy - py) - (cx - px) * (by - py) >= 0;\n}\n\nfunction isValidDiagonal(a, b) {\n  return a.next.i !== b.i && a.prev.i !== b.i && !intersectsPolygon(a, b) && (locallyInside(a, b) && locallyInside(b, a) && middleInside(a, b) && (area(a.prev, a, b.prev) || area(a, b.prev, b)) || equals(a, b) && area(a.prev, a, a.next) > 0 && area(b.prev, b, b.next) > 0);\n}\n\nfunction area(p, q, r) {\n  return (q.y - p.y) * (r.x - q.x) - (q.x - p.x) * (r.y - q.y);\n}\n\nfunction equals(p1, p2) {\n  return p1.x === p2.x && p1.y === p2.y;\n}\n\nfunction intersects(p1, q1, p2, q2) {\n  const o1 = sign(area(p1, q1, p2));\n  const o2 = sign(area(p1, q1, q2));\n  const o3 = sign(area(p2, q2, p1));\n  const o4 = sign(area(p2, q2, q1));\n  if (o1 !== o2 && o3 !== o4) return true;\n  if (o1 === 0 && onSegment(p1, p2, q1)) return true;\n  if (o2 === 0 && onSegment(p1, q2, q1)) return true;\n  if (o3 === 0 && onSegment(p2, p1, q2)) return true;\n  if (o4 === 0 && onSegment(p2, q1, q2)) return true;\n  return false;\n}\n\nfunction onSegment(p, q, r) {\n  return q.x <= Math.max(p.x, r.x) && q.x >= Math.min(p.x, r.x) && q.y <= Math.max(p.y, r.y) && q.y >= Math.min(p.y, r.y);\n}\n\nfunction sign(num) {\n  return num > 0 ? 1 : num < 0 ? -1 : 0;\n}\n\nfunction intersectsPolygon(a, b) {\n  let p = a;\n\n  do {\n    if (p.i !== a.i && p.next.i !== a.i && p.i !== b.i && p.next.i !== b.i && intersects(p, p.next, a, b)) return true;\n    p = p.next;\n  } while (p !== a);\n\n  return false;\n}\n\nfunction locallyInside(a, b) {\n  return area(a.prev, a, a.next) < 0 ? area(a, b, a.next) >= 0 && area(a, a.prev, b) >= 0 : area(a, b, a.prev) < 0 || area(a, a.next, b) < 0;\n}\n\nfunction middleInside(a, b) {\n  let p = a;\n  let inside = false;\n  const px = (a.x + b.x) / 2;\n  const py = (a.y + b.y) / 2;\n\n  do {\n    if (p.y > py !== p.next.y > py && p.next.y !== p.y && px < (p.next.x - p.x) * (py - p.y) / (p.next.y - p.y) + p.x) inside = !inside;\n    p = p.next;\n  } while (p !== a);\n\n  return inside;\n}\n\nfunction splitPolygon(a, b) {\n  const a2 = new Node(a.i, a.x, a.y);\n  const b2 = new Node(b.i, b.x, b.y);\n  const an = a.next;\n  const bp = b.prev;\n  a.next = b;\n  b.prev = a;\n  a2.next = an;\n  an.prev = a2;\n  b2.next = a2;\n  a2.prev = b2;\n  bp.next = b2;\n  b2.prev = bp;\n  return b2;\n}\n\nfunction insertNode(i, x, y, last) {\n  const p = new Node(i, x, y);\n\n  if (!last) {\n    p.prev = p;\n    p.next = p;\n  } else {\n    p.next = last.next;\n    p.prev = last;\n    last.next.prev = p;\n    last.next = p;\n  }\n\n  return p;\n}\n\nfunction removeNode(p) {\n  p.next.prev = p.prev;\n  p.prev.next = p.next;\n  if (p.prevZ) p.prevZ.nextZ = p.nextZ;\n  if (p.nextZ) p.nextZ.prevZ = p.prevZ;\n}\n\nfunction Node(i, x, y) {\n  this.i = i;\n  this.x = x;\n  this.y = y;\n  this.prev = null;\n  this.next = null;\n  this.z = null;\n  this.prevZ = null;\n  this.nextZ = null;\n  this.steiner = false;\n}\n//# sourceMappingURL=earcut.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@math.gl/polygon/dist/esm/earcut.js\n");

/***/ }),

/***/ "./node_modules/@math.gl/polygon/dist/esm/index.js":
/*!*********************************************************!*\
  !*** ./node_modules/@math.gl/polygon/dist/esm/index.js ***!
  \*********************************************************/
/*! exports provided: Polygon, getPolygonSignedArea, getPolygonWindingDirection, forEachSegmentInPolygon, modifyPolygonWindingDirection, WINDING, earcut, clipPolygon, clipPolyline, cutPolygonByGrid, cutPolylineByGrid, cutPolylineByMercatorBounds, cutPolygonByMercatorBounds, _Polygon */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _polygon__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./polygon */ \"./node_modules/@math.gl/polygon/dist/esm/polygon.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"Polygon\", function() { return _polygon__WEBPACK_IMPORTED_MODULE_0__[\"default\"]; });\n\n/* harmony import */ var _polygon_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./polygon-utils */ \"./node_modules/@math.gl/polygon/dist/esm/polygon-utils.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"getPolygonSignedArea\", function() { return _polygon_utils__WEBPACK_IMPORTED_MODULE_1__[\"getPolygonSignedArea\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"getPolygonWindingDirection\", function() { return _polygon_utils__WEBPACK_IMPORTED_MODULE_1__[\"getPolygonWindingDirection\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"forEachSegmentInPolygon\", function() { return _polygon_utils__WEBPACK_IMPORTED_MODULE_1__[\"forEachSegmentInPolygon\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"modifyPolygonWindingDirection\", function() { return _polygon_utils__WEBPACK_IMPORTED_MODULE_1__[\"modifyPolygonWindingDirection\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"WINDING\", function() { return _polygon_utils__WEBPACK_IMPORTED_MODULE_1__[\"WINDING\"]; });\n\n/* harmony import */ var _earcut__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./earcut */ \"./node_modules/@math.gl/polygon/dist/esm/earcut.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"earcut\", function() { return _earcut__WEBPACK_IMPORTED_MODULE_2__[\"earcut\"]; });\n\n/* harmony import */ var _lineclip__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./lineclip */ \"./node_modules/@math.gl/polygon/dist/esm/lineclip.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"clipPolygon\", function() { return _lineclip__WEBPACK_IMPORTED_MODULE_3__[\"clipPolygon\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"clipPolyline\", function() { return _lineclip__WEBPACK_IMPORTED_MODULE_3__[\"clipPolyline\"]; });\n\n/* harmony import */ var _cut_by_grid__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./cut-by-grid */ \"./node_modules/@math.gl/polygon/dist/esm/cut-by-grid.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"cutPolygonByGrid\", function() { return _cut_by_grid__WEBPACK_IMPORTED_MODULE_4__[\"cutPolygonByGrid\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"cutPolylineByGrid\", function() { return _cut_by_grid__WEBPACK_IMPORTED_MODULE_4__[\"cutPolylineByGrid\"]; });\n\n/* harmony import */ var _cut_by_mercator_bounds__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./cut-by-mercator-bounds */ \"./node_modules/@math.gl/polygon/dist/esm/cut-by-mercator-bounds.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"cutPolylineByMercatorBounds\", function() { return _cut_by_mercator_bounds__WEBPACK_IMPORTED_MODULE_5__[\"cutPolylineByMercatorBounds\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"cutPolygonByMercatorBounds\", function() { return _cut_by_mercator_bounds__WEBPACK_IMPORTED_MODULE_5__[\"cutPolygonByMercatorBounds\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"_Polygon\", function() { return _polygon__WEBPACK_IMPORTED_MODULE_0__[\"default\"]; });\n\n\n\n\n\n\n\n\n//# sourceMappingURL=index.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQG1hdGguZ2wvcG9seWdvbi9kaXN0L2VzbS9pbmRleC5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9AbWF0aC5nbC9wb2x5Z29uL2Rpc3QvZXNtL2luZGV4LmpzPzcyOWIiXSwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IHsgZGVmYXVsdCBhcyBQb2x5Z29uIH0gZnJvbSAnLi9wb2x5Z29uJztcbmV4cG9ydCB7IGdldFBvbHlnb25TaWduZWRBcmVhLCBnZXRQb2x5Z29uV2luZGluZ0RpcmVjdGlvbiwgZm9yRWFjaFNlZ21lbnRJblBvbHlnb24sIG1vZGlmeVBvbHlnb25XaW5kaW5nRGlyZWN0aW9uLCBXSU5ESU5HIH0gZnJvbSAnLi9wb2x5Z29uLXV0aWxzJztcbmV4cG9ydCB7IGVhcmN1dCB9IGZyb20gJy4vZWFyY3V0JztcbmV4cG9ydCB7IGNsaXBQb2x5Z29uLCBjbGlwUG9seWxpbmUgfSBmcm9tICcuL2xpbmVjbGlwJztcbmV4cG9ydCB7IGN1dFBvbHlnb25CeUdyaWQsIGN1dFBvbHlsaW5lQnlHcmlkIH0gZnJvbSAnLi9jdXQtYnktZ3JpZCc7XG5leHBvcnQgeyBjdXRQb2x5bGluZUJ5TWVyY2F0b3JCb3VuZHMsIGN1dFBvbHlnb25CeU1lcmNhdG9yQm91bmRzIH0gZnJvbSAnLi9jdXQtYnktbWVyY2F0b3ItYm91bmRzJztcbmV4cG9ydCB7IGRlZmF1bHQgYXMgX1BvbHlnb24gfSBmcm9tICcuL3BvbHlnb24nO1xuLy8jIHNvdXJjZU1hcHBpbmdVUkw9aW5kZXguanMubWFwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/@math.gl/polygon/dist/esm/index.js\n");

/***/ }),

/***/ "./node_modules/@math.gl/polygon/dist/esm/lineclip.js":
/*!************************************************************!*\
  !*** ./node_modules/@math.gl/polygon/dist/esm/lineclip.js ***!
  \************************************************************/
/*! exports provided: clipPolyline, clipPolygon, intersect, bitCode */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"clipPolyline\", function() { return clipPolyline; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"clipPolygon\", function() { return clipPolygon; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"intersect\", function() { return intersect; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"bitCode\", function() { return bitCode; });\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils */ \"./node_modules/@math.gl/polygon/dist/esm/utils.js\");\n\nfunction clipPolyline(positions, bbox, options = {}) {\n  const {\n    size = 2,\n    startIndex = 0,\n    endIndex = positions.length\n  } = options;\n  const numPoints = (endIndex - startIndex) / size;\n  const result = [];\n  let part = [];\n  let a;\n  let b;\n  let codeA = -1;\n  let codeB;\n  let lastCode;\n\n  for (let i = 1; i < numPoints; i++) {\n    a = Object(_utils__WEBPACK_IMPORTED_MODULE_0__[\"getPointAtIndex\"])(positions, i - 1, size, startIndex, a);\n    b = Object(_utils__WEBPACK_IMPORTED_MODULE_0__[\"getPointAtIndex\"])(positions, i, size, startIndex, b);\n\n    if (codeA < 0) {\n      codeA = bitCode(a, bbox);\n    }\n\n    codeB = lastCode = bitCode(b, bbox);\n\n    while (true) {\n      if (!(codeA | codeB)) {\n        Object(_utils__WEBPACK_IMPORTED_MODULE_0__[\"push\"])(part, a);\n\n        if (codeB !== lastCode) {\n          Object(_utils__WEBPACK_IMPORTED_MODULE_0__[\"push\"])(part, b);\n\n          if (i < numPoints - 1) {\n            result.push(part);\n            part = [];\n          }\n        } else if (i === numPoints - 1) {\n          Object(_utils__WEBPACK_IMPORTED_MODULE_0__[\"push\"])(part, b);\n        }\n\n        break;\n      } else if (codeA & codeB) {\n        break;\n      } else if (codeA) {\n        intersect(a, b, codeA, bbox, a);\n        codeA = bitCode(a, bbox);\n      } else {\n        intersect(a, b, codeB, bbox, b);\n        codeB = bitCode(b, bbox);\n      }\n    }\n\n    codeA = lastCode;\n  }\n\n  if (part.length) result.push(part);\n  return result;\n}\nfunction clipPolygon(positions, bbox, options = {}) {\n  const {\n    size = 2,\n    endIndex = positions.length\n  } = options;\n  let {\n    startIndex = 0\n  } = options;\n  let numPoints = (endIndex - startIndex) / size;\n  let result;\n  let p;\n  let prev;\n  let inside;\n  let prevInside;\n\n  for (let edge = 1; edge <= 8; edge *= 2) {\n    result = [];\n    prev = Object(_utils__WEBPACK_IMPORTED_MODULE_0__[\"getPointAtIndex\"])(positions, numPoints - 1, size, startIndex, prev);\n    prevInside = !(bitCode(prev, bbox) & edge);\n\n    for (let i = 0; i < numPoints; i++) {\n      p = Object(_utils__WEBPACK_IMPORTED_MODULE_0__[\"getPointAtIndex\"])(positions, i, size, startIndex, p);\n      inside = !(bitCode(p, bbox) & edge);\n      if (inside !== prevInside) Object(_utils__WEBPACK_IMPORTED_MODULE_0__[\"push\"])(result, intersect(prev, p, edge, bbox));\n      if (inside) Object(_utils__WEBPACK_IMPORTED_MODULE_0__[\"push\"])(result, p);\n      Object(_utils__WEBPACK_IMPORTED_MODULE_0__[\"copy\"])(prev, p);\n      prevInside = inside;\n    }\n\n    positions = result;\n    startIndex = 0;\n    numPoints = result.length / size;\n    if (!numPoints) break;\n  }\n\n  return result;\n}\nfunction intersect(a, b, edge, bbox, out = []) {\n  let t;\n  let snap;\n\n  if (edge & 8) {\n    t = (bbox[3] - a[1]) / (b[1] - a[1]);\n    snap = 3;\n  } else if (edge & 4) {\n    t = (bbox[1] - a[1]) / (b[1] - a[1]);\n    snap = 1;\n  } else if (edge & 2) {\n    t = (bbox[2] - a[0]) / (b[0] - a[0]);\n    snap = 2;\n  } else if (edge & 1) {\n    t = (bbox[0] - a[0]) / (b[0] - a[0]);\n    snap = 0;\n  } else {\n    return null;\n  }\n\n  for (let i = 0; i < a.length; i++) {\n    out[i] = (snap & 1) === i ? bbox[snap] : t * (b[i] - a[i]) + a[i];\n  }\n\n  return out;\n}\nfunction bitCode(p, bbox) {\n  let code = 0;\n  if (p[0] < bbox[0]) code |= 1;else if (p[0] > bbox[2]) code |= 2;\n  if (p[1] < bbox[1]) code |= 4;else if (p[1] > bbox[3]) code |= 8;\n  return code;\n}\n//# sourceMappingURL=lineclip.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@math.gl/polygon/dist/esm/lineclip.js\n");

/***/ }),

/***/ "./node_modules/@math.gl/polygon/dist/esm/polygon-utils.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@math.gl/polygon/dist/esm/polygon-utils.js ***!
  \*****************************************************************/
/*! exports provided: WINDING, modifyPolygonWindingDirection, getPolygonWindingDirection, getPolygonSignedArea, forEachSegmentInPolygon, modifyPolygonWindingDirectionPoints, getPolygonWindingDirectionPoints, getPolygonSignedAreaPoints, forEachSegmentInPolygonPoints */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"WINDING\", function() { return WINDING; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"modifyPolygonWindingDirection\", function() { return modifyPolygonWindingDirection; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getPolygonWindingDirection\", function() { return getPolygonWindingDirection; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getPolygonSignedArea\", function() { return getPolygonSignedArea; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"forEachSegmentInPolygon\", function() { return forEachSegmentInPolygon; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"modifyPolygonWindingDirectionPoints\", function() { return modifyPolygonWindingDirectionPoints; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getPolygonWindingDirectionPoints\", function() { return getPolygonWindingDirectionPoints; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getPolygonSignedAreaPoints\", function() { return getPolygonSignedAreaPoints; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"forEachSegmentInPolygonPoints\", function() { return forEachSegmentInPolygonPoints; });\n/* harmony import */ var _math_gl_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @math.gl/core */ \"./node_modules/@math.gl/core/dist/esm/lib/common.js\");\n\nconst WINDING = {\n  CLOCKWISE: 1,\n  COUNTER_CLOCKWISE: -1\n};\nfunction modifyPolygonWindingDirection(points, direction, options = {}) {\n  const windingDirection = getPolygonWindingDirection(points, options);\n\n  if (windingDirection !== direction) {\n    reversePolygon(points, options);\n    return true;\n  }\n\n  return false;\n}\nfunction getPolygonWindingDirection(points, options = {}) {\n  return Math.sign(getPolygonSignedArea(points, options));\n}\nfunction getPolygonSignedArea(points, options = {}) {\n  const {\n    start = 0,\n    end = points.length\n  } = options;\n  const dim = options.size || 2;\n  let area = 0;\n\n  for (let i = start, j = end - dim; i < end; i += dim) {\n    area += (points[i] - points[j]) * (points[i + 1] + points[j + 1]);\n    j = i;\n  }\n\n  return area / 2;\n}\nfunction forEachSegmentInPolygon(points, visitor, options = {}) {\n  const {\n    start = 0,\n    end = points.length,\n    size = 2,\n    isClosed\n  } = options;\n  const numPoints = (end - start) / size;\n\n  for (let i = 0; i < numPoints - 1; ++i) {\n    visitor(points[start + i * size], points[start + i * size + 1], points[start + (i + 1) * size], points[start + (i + 1) * size + 1], i, i + 1);\n  }\n\n  const endPointIndex = start + (numPoints - 1) * size;\n  const isClosedEx = isClosed || Object(_math_gl_core__WEBPACK_IMPORTED_MODULE_0__[\"equals\"])(points[start], points[endPointIndex]) && Object(_math_gl_core__WEBPACK_IMPORTED_MODULE_0__[\"equals\"])(points[start + 1], points[endPointIndex + 1]);\n\n  if (!isClosedEx) {\n    visitor(points[endPointIndex], points[endPointIndex + 1], points[start], points[start + 1], numPoints - 1, 0);\n  }\n}\n\nfunction reversePolygon(points, options) {\n  const {\n    start = 0,\n    end = points.length,\n    size = 2\n  } = options;\n  const numPoints = (end - start) / size;\n  const numSwaps = Math.floor(numPoints / 2);\n\n  for (let i = 0; i < numSwaps; ++i) {\n    const b1 = start + i * size;\n    const b2 = start + (numPoints - 1 - i) * size;\n\n    for (let j = 0; j < size; ++j) {\n      const tmp = points[b1 + j];\n      points[b1 + j] = points[b2 + j];\n      points[b2 + j] = tmp;\n    }\n  }\n}\n\nfunction modifyPolygonWindingDirectionPoints(points, direction, options = {}) {\n  const currentDirection = getPolygonWindingDirectionPoints(points, options);\n\n  if (currentDirection !== direction) {\n    points.reverse();\n    return true;\n  }\n\n  return false;\n}\nfunction getPolygonWindingDirectionPoints(points, options = {}) {\n  return Math.sign(getPolygonSignedAreaPoints(points, options));\n}\nfunction getPolygonSignedAreaPoints(points, options = {}) {\n  const {\n    start = 0,\n    end = points.length\n  } = options;\n  let area = 0;\n\n  for (let i = start, j = end - 1; i < end; ++i) {\n    area += (points[i][0] - points[j][0]) * (points[i][1] + points[j][1]);\n    j = i;\n  }\n\n  return area / 2;\n}\nfunction forEachSegmentInPolygonPoints(points, visitor, options = {}) {\n  const {\n    start = 0,\n    end = points.length,\n    isClosed\n  } = options;\n\n  for (let i = start; i < end - 1; ++i) {\n    visitor(points[i], points[i + 1], i, i + 1);\n  }\n\n  const isClosedEx = isClosed || Object(_math_gl_core__WEBPACK_IMPORTED_MODULE_0__[\"equals\"])(points[end - 1], points[0]);\n\n  if (!isClosedEx) {\n    visitor(points[end - 1], points[0], end - 1, 0);\n  }\n}\n//# sourceMappingURL=polygon-utils.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@math.gl/polygon/dist/esm/polygon-utils.js\n");

/***/ }),

/***/ "./node_modules/@math.gl/polygon/dist/esm/polygon.js":
/*!***********************************************************!*\
  !*** ./node_modules/@math.gl/polygon/dist/esm/polygon.js ***!
  \***********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return Polygon; });\n/* harmony import */ var _math_gl_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @math.gl/core */ \"./node_modules/@math.gl/core/dist/esm/lib/common.js\");\n/* harmony import */ var _polygon_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./polygon-utils */ \"./node_modules/@math.gl/polygon/dist/esm/polygon-utils.js\");\n\n\nclass Polygon {\n  constructor(points, options = {}) {\n    this.points = points;\n    this.isFlatArray = !Object(_math_gl_core__WEBPACK_IMPORTED_MODULE_0__[\"isArray\"])(points[0]);\n    this.options = {\n      start: options.start || 0,\n      end: options.end || points.length,\n      size: options.size || 2,\n      isClosed: options.isClosed\n    };\n    Object.freeze(this);\n  }\n\n  getSignedArea() {\n    if (this.isFlatArray) return Object(_polygon_utils__WEBPACK_IMPORTED_MODULE_1__[\"getPolygonSignedArea\"])(this.points, this.options);\n    return Object(_polygon_utils__WEBPACK_IMPORTED_MODULE_1__[\"getPolygonSignedAreaPoints\"])(this.points, this.options);\n  }\n\n  getArea() {\n    return Math.abs(this.getSignedArea());\n  }\n\n  getWindingDirection() {\n    return Math.sign(this.getSignedArea());\n  }\n\n  forEachSegment(visitor) {\n    if (this.isFlatArray) {\n      Object(_polygon_utils__WEBPACK_IMPORTED_MODULE_1__[\"forEachSegmentInPolygon\"])(this.points, (x1, y1, x2, y2, i1, i2) => {\n        visitor([x1, y1], [x2, y2], i1, i2);\n      }, this.options);\n    } else {\n      Object(_polygon_utils__WEBPACK_IMPORTED_MODULE_1__[\"forEachSegmentInPolygonPoints\"])(this.points, visitor, this.options);\n    }\n  }\n\n  modifyWindingDirection(direction) {\n    if (this.isFlatArray) {\n      return Object(_polygon_utils__WEBPACK_IMPORTED_MODULE_1__[\"modifyPolygonWindingDirection\"])(this.points, direction, this.options);\n    }\n\n    return Object(_polygon_utils__WEBPACK_IMPORTED_MODULE_1__[\"modifyPolygonWindingDirectionPoints\"])(this.points, direction, this.options);\n  }\n\n}\n//# sourceMappingURL=polygon.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQG1hdGguZ2wvcG9seWdvbi9kaXN0L2VzbS9wb2x5Z29uLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0BtYXRoLmdsL3BvbHlnb24vZGlzdC9lc20vcG9seWdvbi5qcz85MGJiIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGlzQXJyYXkgfSBmcm9tICdAbWF0aC5nbC9jb3JlJztcbmltcG9ydCB7IGdldFBvbHlnb25TaWduZWRBcmVhLCBmb3JFYWNoU2VnbWVudEluUG9seWdvbiwgbW9kaWZ5UG9seWdvbldpbmRpbmdEaXJlY3Rpb24sIGdldFBvbHlnb25TaWduZWRBcmVhUG9pbnRzLCBmb3JFYWNoU2VnbWVudEluUG9seWdvblBvaW50cywgbW9kaWZ5UG9seWdvbldpbmRpbmdEaXJlY3Rpb25Qb2ludHMgfSBmcm9tICcuL3BvbHlnb24tdXRpbHMnO1xuZXhwb3J0IGRlZmF1bHQgY2xhc3MgUG9seWdvbiB7XG4gIGNvbnN0cnVjdG9yKHBvaW50cywgb3B0aW9ucyA9IHt9KSB7XG4gICAgdGhpcy5wb2ludHMgPSBwb2ludHM7XG4gICAgdGhpcy5pc0ZsYXRBcnJheSA9ICFpc0FycmF5KHBvaW50c1swXSk7XG4gICAgdGhpcy5vcHRpb25zID0ge1xuICAgICAgc3RhcnQ6IG9wdGlvbnMuc3RhcnQgfHwgMCxcbiAgICAgIGVuZDogb3B0aW9ucy5lbmQgfHwgcG9pbnRzLmxlbmd0aCxcbiAgICAgIHNpemU6IG9wdGlvbnMuc2l6ZSB8fCAyLFxuICAgICAgaXNDbG9zZWQ6IG9wdGlvbnMuaXNDbG9zZWRcbiAgICB9O1xuICAgIE9iamVjdC5mcmVlemUodGhpcyk7XG4gIH1cblxuICBnZXRTaWduZWRBcmVhKCkge1xuICAgIGlmICh0aGlzLmlzRmxhdEFycmF5KSByZXR1cm4gZ2V0UG9seWdvblNpZ25lZEFyZWEodGhpcy5wb2ludHMsIHRoaXMub3B0aW9ucyk7XG4gICAgcmV0dXJuIGdldFBvbHlnb25TaWduZWRBcmVhUG9pbnRzKHRoaXMucG9pbnRzLCB0aGlzLm9wdGlvbnMpO1xuICB9XG5cbiAgZ2V0QXJlYSgpIHtcbiAgICByZXR1cm4gTWF0aC5hYnModGhpcy5nZXRTaWduZWRBcmVhKCkpO1xuICB9XG5cbiAgZ2V0V2luZGluZ0RpcmVjdGlvbigpIHtcbiAgICByZXR1cm4gTWF0aC5zaWduKHRoaXMuZ2V0U2lnbmVkQXJlYSgpKTtcbiAgfVxuXG4gIGZvckVhY2hTZWdtZW50KHZpc2l0b3IpIHtcbiAgICBpZiAodGhpcy5pc0ZsYXRBcnJheSkge1xuICAgICAgZm9yRWFjaFNlZ21lbnRJblBvbHlnb24odGhpcy5wb2ludHMsICh4MSwgeTEsIHgyLCB5MiwgaTEsIGkyKSA9PiB7XG4gICAgICAgIHZpc2l0b3IoW3gxLCB5MV0sIFt4MiwgeTJdLCBpMSwgaTIpO1xuICAgICAgfSwgdGhpcy5vcHRpb25zKTtcbiAgICB9IGVsc2Uge1xuICAgICAgZm9yRWFjaFNlZ21lbnRJblBvbHlnb25Qb2ludHModGhpcy5wb2ludHMsIHZpc2l0b3IsIHRoaXMub3B0aW9ucyk7XG4gICAgfVxuICB9XG5cbiAgbW9kaWZ5V2luZGluZ0RpcmVjdGlvbihkaXJlY3Rpb24pIHtcbiAgICBpZiAodGhpcy5pc0ZsYXRBcnJheSkge1xuICAgICAgcmV0dXJuIG1vZGlmeVBvbHlnb25XaW5kaW5nRGlyZWN0aW9uKHRoaXMucG9pbnRzLCBkaXJlY3Rpb24sIHRoaXMub3B0aW9ucyk7XG4gICAgfVxuXG4gICAgcmV0dXJuIG1vZGlmeVBvbHlnb25XaW5kaW5nRGlyZWN0aW9uUG9pbnRzKHRoaXMucG9pbnRzLCBkaXJlY3Rpb24sIHRoaXMub3B0aW9ucyk7XG4gIH1cblxufVxuLy8jIHNvdXJjZU1hcHBpbmdVUkw9cG9seWdvbi5qcy5tYXAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/@math.gl/polygon/dist/esm/polygon.js\n");

/***/ }),

/***/ "./node_modules/@math.gl/polygon/dist/esm/utils.js":
/*!*********************************************************!*\
  !*** ./node_modules/@math.gl/polygon/dist/esm/utils.js ***!
  \*********************************************************/
/*! exports provided: push, copy, getPointAtIndex */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"push\", function() { return push; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"copy\", function() { return copy; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getPointAtIndex\", function() { return getPointAtIndex; });\nfunction push(target, source) {\n  const size = source.length;\n  const startIndex = target.length;\n\n  if (startIndex > 0) {\n    let isDuplicate = true;\n\n    for (let i = 0; i < size; i++) {\n      if (target[startIndex - size + i] !== source[i]) {\n        isDuplicate = false;\n        break;\n      }\n    }\n\n    if (isDuplicate) {\n      return false;\n    }\n  }\n\n  for (let i = 0; i < size; i++) {\n    target[startIndex + i] = source[i];\n  }\n\n  return true;\n}\nfunction copy(target, source) {\n  const size = source.length;\n\n  for (let i = 0; i < size; i++) {\n    target[i] = source[i];\n  }\n}\nfunction getPointAtIndex(positions, index, size, offset, out = []) {\n  const startI = offset + index * size;\n\n  for (let i = 0; i < size; i++) {\n    out[i] = positions[startI + i];\n  }\n\n  return out;\n}\n//# sourceMappingURL=utils.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQG1hdGguZ2wvcG9seWdvbi9kaXN0L2VzbS91dGlscy5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9AbWF0aC5nbC9wb2x5Z29uL2Rpc3QvZXNtL3V0aWxzLmpzP2I5ZmIiXSwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IGZ1bmN0aW9uIHB1c2godGFyZ2V0LCBzb3VyY2UpIHtcbiAgY29uc3Qgc2l6ZSA9IHNvdXJjZS5sZW5ndGg7XG4gIGNvbnN0IHN0YXJ0SW5kZXggPSB0YXJnZXQubGVuZ3RoO1xuXG4gIGlmIChzdGFydEluZGV4ID4gMCkge1xuICAgIGxldCBpc0R1cGxpY2F0ZSA9IHRydWU7XG5cbiAgICBmb3IgKGxldCBpID0gMDsgaSA8IHNpemU7IGkrKykge1xuICAgICAgaWYgKHRhcmdldFtzdGFydEluZGV4IC0gc2l6ZSArIGldICE9PSBzb3VyY2VbaV0pIHtcbiAgICAgICAgaXNEdXBsaWNhdGUgPSBmYWxzZTtcbiAgICAgICAgYnJlYWs7XG4gICAgICB9XG4gICAgfVxuXG4gICAgaWYgKGlzRHVwbGljYXRlKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICB9XG5cbiAgZm9yIChsZXQgaSA9IDA7IGkgPCBzaXplOyBpKyspIHtcbiAgICB0YXJnZXRbc3RhcnRJbmRleCArIGldID0gc291cmNlW2ldO1xuICB9XG5cbiAgcmV0dXJuIHRydWU7XG59XG5leHBvcnQgZnVuY3Rpb24gY29weSh0YXJnZXQsIHNvdXJjZSkge1xuICBjb25zdCBzaXplID0gc291cmNlLmxlbmd0aDtcblxuICBmb3IgKGxldCBpID0gMDsgaSA8IHNpemU7IGkrKykge1xuICAgIHRhcmdldFtpXSA9IHNvdXJjZVtpXTtcbiAgfVxufVxuZXhwb3J0IGZ1bmN0aW9uIGdldFBvaW50QXRJbmRleChwb3NpdGlvbnMsIGluZGV4LCBzaXplLCBvZmZzZXQsIG91dCA9IFtdKSB7XG4gIGNvbnN0IHN0YXJ0SSA9IG9mZnNldCArIGluZGV4ICogc2l6ZTtcblxuICBmb3IgKGxldCBpID0gMDsgaSA8IHNpemU7IGkrKykge1xuICAgIG91dFtpXSA9IHBvc2l0aW9uc1tzdGFydEkgKyBpXTtcbiAgfVxuXG4gIHJldHVybiBvdXQ7XG59XG4vLyMgc291cmNlTWFwcGluZ1VSTD11dGlscy5qcy5tYXAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/@math.gl/polygon/dist/esm/utils.js\n");

/***/ }),

/***/ "./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/AnimatableDeckGLContainer.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/AnimatableDeckGLContainer.js ***!
  \***********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return AnimatableDeckGLContainer; });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"./node_modules/react/index.js\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ \"./node_modules/prop-types/index.js\");\n/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _DeckGLContainer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./DeckGLContainer */ \"./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/DeckGLContainer.js\");\n/* harmony import */ var _components_PlaySlider__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./components/PlaySlider */ \"./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/PlaySlider.js\");\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\n/* eslint-disable react/jsx-sort-default-props */\n\n/* eslint-disable react/sort-prop-types */\n\n/* eslint-disable react/forbid-prop-types */\n\n/* eslint-disable react/require-default-props */\n\n/**\n * Licensed to the Apache Software Foundation (ASF) under one\n * or more contributor license agreements.  See the NOTICE file\n * distributed with this work for additional information\n * regarding copyright ownership.  The ASF licenses this file\n * to you under the Apache License, Version 2.0 (the\n * \"License\"); you may not use this file except in compliance\n * with the License.  You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing,\n * software distributed under the License is distributed on an\n * \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n * KIND, either express or implied.  See the License for the\n * specific language governing permissions and limitations\n * under the License.\n */\n\n\n\n\nconst PLAYSLIDER_HEIGHT = 20; // px\n\nconst propTypes = {\n  getLayers: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.func.isRequired,\n  start: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.number.isRequired,\n  end: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.number.isRequired,\n  getStep: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.func,\n  values: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.array.isRequired,\n  aggregation: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.bool,\n  disabled: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.bool,\n  viewport: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.object.isRequired,\n  children: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.node,\n  mapStyle: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.string,\n  mapboxApiAccessToken: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.string.isRequired,\n  setControlValue: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.func,\n  onValuesChange: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.func,\n  width: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.number.isRequired,\n  height: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.number.isRequired\n};\nconst defaultProps = {\n  aggregation: false,\n  disabled: false,\n  mapStyle: 'light',\n  setControlValue: () => {},\n  onValuesChange: () => {}\n};\nclass AnimatableDeckGLContainer extends react__WEBPACK_IMPORTED_MODULE_0___default.a.PureComponent {\n  constructor() {\n    super(...arguments);\n\n    _defineProperty(this, \"containerRef\", react__WEBPACK_IMPORTED_MODULE_0___default.a.createRef());\n\n    _defineProperty(this, \"setTooltip\", tooltip => {\n      const {\n        current\n      } = this.containerRef;\n\n      if (current) {\n        current.setTooltip(tooltip);\n      }\n    });\n  }\n\n  render() {\n    const {\n      start,\n      end,\n      getStep,\n      disabled,\n      aggregation,\n      children,\n      getLayers,\n      values,\n      onValuesChange,\n      viewport,\n      setControlValue,\n      mapStyle,\n      mapboxApiAccessToken,\n      height,\n      width\n    } = this.props;\n    const layers = getLayers(values);\n    return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(\"div\", null, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_DeckGLContainer__WEBPACK_IMPORTED_MODULE_2__[\"default\"], {\n      ref: this.containerRef,\n      viewport: viewport,\n      layers: layers,\n      setControlValue: setControlValue,\n      mapStyle: mapStyle,\n      mapboxApiAccessToken: mapboxApiAccessToken,\n      bottomMargin: disabled ? 0 : PLAYSLIDER_HEIGHT,\n      width: width,\n      height: height\n    }), !disabled && react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_components_PlaySlider__WEBPACK_IMPORTED_MODULE_3__[\"default\"], {\n      start: start,\n      end: end,\n      step: getStep(start),\n      values: values,\n      range: !aggregation,\n      onChange: onValuesChange\n    }), children);\n  }\n\n}\nAnimatableDeckGLContainer.propTypes = propTypes;\nAnimatableDeckGLContainer.defaultProps = defaultProps;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/AnimatableDeckGLContainer.js\n");

/***/ }),

/***/ "./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/CategoricalDeckGLContainer.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/CategoricalDeckGLContainer.js ***!
  \************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return CategoricalDeckGLContainer; });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"./node_modules/react/index.js\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ \"./node_modules/prop-types/index.js\");\n/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @superset-ui/core */ \"./node_modules/@superset-ui/core/esm/color/index.js\");\n/* harmony import */ var _AnimatableDeckGLContainer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./AnimatableDeckGLContainer */ \"./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/AnimatableDeckGLContainer.js\");\n/* harmony import */ var _components_Legend__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./components/Legend */ \"./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/Legend.js\");\n/* harmony import */ var _utils_colors__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./utils/colors */ \"./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/utils/colors.js\");\n/* harmony import */ var _utils_time__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./utils/time */ \"./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/utils/time.js\");\n/* harmony import */ var _utils_sandbox__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./utils/sandbox */ \"./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/utils/sandbox.js\");\n/* harmony import */ var _utils_fitViewport__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./utils/fitViewport */ \"./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/utils/fitViewport.js\");\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\n/* eslint-disable react/sort-prop-types */\n\n/* eslint-disable react/require-default-props */\n\n/* eslint-disable react/no-unused-prop-types */\n\n/* eslint-disable react/no-access-state-in-setstate */\n\n/* eslint-disable camelcase */\n\n/* eslint-disable no-prototype-builtins */\n\n/**\n * Licensed to the Apache Software Foundation (ASF) under one\n * or more contributor license agreements.  See the NOTICE file\n * distributed with this work for additional information\n * regarding copyright ownership.  The ASF licenses this file\n * to you under the Apache License, Version 2.0 (the\n * \"License\"); you may not use this file except in compliance\n * with the License.  You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing,\n * software distributed under the License is distributed on an\n * \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n * KIND, either express or implied.  See the License for the\n * specific language governing permissions and limitations\n * under the License.\n */\n\n/* eslint no-underscore-dangle: [\"error\", { \"allow\": [\"\", \"__timestamp\"] }] */\n\n\n\n\n\n\n\n // eslint-disable-next-line import/extensions\n\n\nconst {\n  getScale\n} = _superset_ui_core__WEBPACK_IMPORTED_MODULE_2__[\"CategoricalColorNamespace\"];\n\nfunction getCategories(fd, data) {\n  const c = fd.color_picker || {\n    r: 0,\n    g: 0,\n    b: 0,\n    a: 1\n  };\n  const fixedColor = [c.r, c.g, c.b, 255 * c.a];\n  const colorFn = getScale(fd.color_scheme);\n  const categories = {};\n  data.forEach(d => {\n    if (d.cat_color != null && !categories.hasOwnProperty(d.cat_color)) {\n      let color;\n\n      if (fd.dimension) {\n        color = Object(_utils_colors__WEBPACK_IMPORTED_MODULE_5__[\"hexToRGB\"])(colorFn(d.cat_color), c.a * 255);\n      } else {\n        color = fixedColor;\n      }\n\n      categories[d.cat_color] = {\n        color,\n        enabled: true\n      };\n    }\n  });\n  return categories;\n}\n\nconst propTypes = {\n  formData: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.object.isRequired,\n  mapboxApiKey: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.string.isRequired,\n  setControlValue: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.func.isRequired,\n  viewport: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.object.isRequired,\n  getLayer: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.func.isRequired,\n  getPoints: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.func.isRequired,\n  payload: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.object.isRequired,\n  onAddFilter: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.func,\n  width: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.number.isRequired,\n  height: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.number.isRequired\n};\nclass CategoricalDeckGLContainer extends react__WEBPACK_IMPORTED_MODULE_0___default.a.PureComponent {\n  /*\n   * A Deck.gl container that handles categories.\n   *\n   * The container will have an interactive legend, populated from the\n   * categories present in the data.\n   */\n  constructor(props) {\n    super(props);\n\n    _defineProperty(this, \"containerRef\", react__WEBPACK_IMPORTED_MODULE_0___default.a.createRef());\n\n    _defineProperty(this, \"setTooltip\", tooltip => {\n      const {\n        current\n      } = this.containerRef;\n\n      if (current) {\n        current.setTooltip(tooltip);\n      }\n    });\n\n    this.state = this.getStateFromProps(props);\n    this.getLayers = this.getLayers.bind(this);\n    this.onValuesChange = this.onValuesChange.bind(this);\n    this.toggleCategory = this.toggleCategory.bind(this);\n    this.showSingleCategory = this.showSingleCategory.bind(this);\n  }\n\n  UNSAFE_componentWillReceiveProps(nextProps) {\n    if (nextProps.payload.form_data !== this.state.formData) {\n      this.setState(_extends({}, this.getStateFromProps(nextProps)));\n    }\n  }\n\n  onValuesChange(values) {\n    this.setState({\n      values: Array.isArray(values) ? values : [values, values + this.state.getStep(values)]\n    });\n  } // eslint-disable-next-line class-methods-use-this\n\n\n  getStateFromProps(props, state) {\n    const features = props.payload.data.features || [];\n    const timestamps = features.map(f => f.__timestamp);\n    const categories = getCategories(props.formData, features); // the state is computed only from the payload; if it hasn't changed, do\n    // not recompute state since this would reset selections and/or the play\n    // slider position due to changes in form controls\n\n    if (state && props.payload.form_data === state.formData) {\n      return _extends({}, state, {\n        categories\n      });\n    } // the granularity has to be read from the payload form_data, not the\n    // props formData which comes from the instantaneous controls state\n\n\n    const granularity = props.payload.form_data.time_grain_sqla || props.payload.form_data.granularity || 'P1D';\n    const {\n      start,\n      end,\n      getStep,\n      values,\n      disabled\n    } = Object(_utils_time__WEBPACK_IMPORTED_MODULE_6__[\"getPlaySliderParams\"])(timestamps, granularity);\n    const {\n      width,\n      height,\n      formData\n    } = props;\n    let {\n      viewport\n    } = props;\n\n    if (formData.autozoom) {\n      viewport = Object(_utils_fitViewport__WEBPACK_IMPORTED_MODULE_8__[\"default\"])(viewport, {\n        width,\n        height,\n        points: props.getPoints(features)\n      });\n    }\n\n    if (viewport.zoom < 0) {\n      viewport.zoom = 0;\n    }\n\n    return {\n      start,\n      end,\n      getStep,\n      values,\n      disabled,\n      viewport,\n      selected: [],\n      lastClick: 0,\n      formData: props.payload.form_data,\n      categories\n    };\n  }\n\n  getLayers(values) {\n    const {\n      getLayer,\n      payload,\n      formData: fd,\n      onAddFilter\n    } = this.props;\n    let features = payload.data.features ? [...payload.data.features] : []; // Add colors from categories or fixed color\n\n    features = this.addColor(features, fd); // Apply user defined data mutator if defined\n\n    if (fd.js_data_mutator) {\n      const jsFnMutator = Object(_utils_sandbox__WEBPACK_IMPORTED_MODULE_7__[\"default\"])(fd.js_data_mutator);\n      features = jsFnMutator(features);\n    } // Filter by time\n\n\n    if (values[0] === values[1] || values[1] === this.end) {\n      features = features.filter(d => d.__timestamp >= values[0] && d.__timestamp <= values[1]);\n    } else {\n      features = features.filter(d => d.__timestamp >= values[0] && d.__timestamp < values[1]);\n    } // Show only categories selected in the legend\n\n\n    const cats = this.state.categories;\n\n    if (fd.dimension) {\n      features = features.filter(d => cats[d.cat_color] && cats[d.cat_color].enabled);\n    }\n\n    const filteredPayload = _extends({}, payload, {\n      data: _extends({}, payload.data, {\n        features\n      })\n    });\n\n    return [getLayer(fd, filteredPayload, onAddFilter, this.setTooltip)];\n  } // eslint-disable-next-line class-methods-use-this\n\n\n  addColor(data, fd) {\n    const c = fd.color_picker || {\n      r: 0,\n      g: 0,\n      b: 0,\n      a: 1\n    };\n    const colorFn = getScale(fd.color_scheme);\n    return data.map(d => {\n      let color;\n\n      if (fd.dimension) {\n        color = Object(_utils_colors__WEBPACK_IMPORTED_MODULE_5__[\"hexToRGB\"])(colorFn(d.cat_color), c.a * 255);\n        return _extends({}, d, {\n          color\n        });\n      }\n\n      return d;\n    });\n  }\n\n  toggleCategory(category) {\n    const categoryState = this.state.categories[category];\n\n    const categories = _extends({}, this.state.categories, {\n      [category]: _extends({}, categoryState, {\n        enabled: !categoryState.enabled\n      })\n    }); // if all categories are disabled, enable all -- similar to nvd3\n\n\n    if (Object.values(categories).every(v => !v.enabled)) {\n      /* eslint-disable no-param-reassign */\n      Object.values(categories).forEach(v => {\n        v.enabled = true;\n      });\n    }\n\n    this.setState({\n      categories\n    });\n  }\n\n  showSingleCategory(category) {\n    const categories = _extends({}, this.state.categories);\n    /* eslint-disable no-param-reassign */\n\n\n    Object.values(categories).forEach(v => {\n      v.enabled = false;\n    });\n    categories[category].enabled = true;\n    this.setState({\n      categories\n    });\n  }\n\n  render() {\n    return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(\"div\", {\n      style: {\n        position: 'relative'\n      }\n    }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_AnimatableDeckGLContainer__WEBPACK_IMPORTED_MODULE_3__[\"default\"], {\n      ref: this.containerRef,\n      getLayers: this.getLayers,\n      start: this.state.start,\n      end: this.state.end,\n      getStep: this.state.getStep,\n      values: this.state.values,\n      disabled: this.state.disabled,\n      viewport: this.state.viewport,\n      mapboxApiAccessToken: this.props.mapboxApiKey,\n      mapStyle: this.props.formData.mapbox_style,\n      setControlValue: this.props.setControlValue,\n      width: this.props.width,\n      height: this.props.height\n    }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_components_Legend__WEBPACK_IMPORTED_MODULE_4__[\"default\"], {\n      categories: this.state.categories,\n      toggleCategory: this.toggleCategory,\n      showSingleCategory: this.showSingleCategory,\n      position: this.props.formData.legend_position,\n      format: this.props.formData.legend_format\n    })));\n  }\n\n}\nCategoricalDeckGLContainer.propTypes = propTypes;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/CategoricalDeckGLContainer.js\n");

/***/ }),

/***/ "./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/BootstrapSliderWrapper.css":
/*!********************************************************************************************************!*\
  !*** ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/BootstrapSliderWrapper.css ***!
  \********************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("var content = __webpack_require__(/*! !../../../../css-loader??ref--7-1!./BootstrapSliderWrapper.css */ \"./node_modules/css-loader/index.js?!./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/BootstrapSliderWrapper.css\");\n\nif (typeof content === 'string') {\n  content = [[module.i, content, '']];\n}\n\nvar options = {}\n\noptions.insert = \"head\";\noptions.singleton = false;\n\nvar update = __webpack_require__(/*! ../../../../style-loader/dist/runtime/injectStylesIntoStyleTag.js */ \"./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js\")(content, options);\n\nif (content.locals) {\n  module.exports = content.locals;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQHN1cGVyc2V0LXVpL2xlZ2FjeS1wcmVzZXQtY2hhcnQtZGVja2dsL2VzbS9jb21wb25lbnRzL0Jvb3RzdHJhcFNsaWRlcldyYXBwZXIuY3NzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0BzdXBlcnNldC11aS9sZWdhY3ktcHJlc2V0LWNoYXJ0LWRlY2tnbC9lc20vY29tcG9uZW50cy9Cb290c3RyYXBTbGlkZXJXcmFwcGVyLmNzcz8wNjg1Il0sInNvdXJjZXNDb250ZW50IjpbInZhciBjb250ZW50ID0gcmVxdWlyZShcIiEhLi4vLi4vLi4vLi4vY3NzLWxvYWRlci9pbmRleC5qcz8/cmVmLS03LTEhLi9Cb290c3RyYXBTbGlkZXJXcmFwcGVyLmNzc1wiKTtcblxuaWYgKHR5cGVvZiBjb250ZW50ID09PSAnc3RyaW5nJykge1xuICBjb250ZW50ID0gW1ttb2R1bGUuaWQsIGNvbnRlbnQsICcnXV07XG59XG5cbnZhciBvcHRpb25zID0ge31cblxub3B0aW9ucy5pbnNlcnQgPSBcImhlYWRcIjtcbm9wdGlvbnMuc2luZ2xldG9uID0gZmFsc2U7XG5cbnZhciB1cGRhdGUgPSByZXF1aXJlKFwiIS4uLy4uLy4uLy4uL3N0eWxlLWxvYWRlci9kaXN0L3J1bnRpbWUvaW5qZWN0U3R5bGVzSW50b1N0eWxlVGFnLmpzXCIpKGNvbnRlbnQsIG9wdGlvbnMpO1xuXG5pZiAoY29udGVudC5sb2NhbHMpIHtcbiAgbW9kdWxlLmV4cG9ydHMgPSBjb250ZW50LmxvY2Fscztcbn1cbiJdLCJtYXBwaW5ncyI6IkFBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Iiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/BootstrapSliderWrapper.css\n");

/***/ }),

/***/ "./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/BootstrapSliderWrapper.js":
/*!*******************************************************************************************************!*\
  !*** ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/BootstrapSliderWrapper.js ***!
  \*******************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return BootstrapSliderWrapper; });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"./node_modules/react/index.js\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var react_bootstrap_slider__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-bootstrap-slider */ \"./node_modules/react-bootstrap-slider/dist/react-bootstrap-slider.js\");\n/* harmony import */ var react_bootstrap_slider__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap_slider__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var bootstrap_slider_dist_css_bootstrap_slider_min_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! bootstrap-slider/dist/css/bootstrap-slider.min.css */ \"./node_modules/bootstrap-slider/dist/css/bootstrap-slider.min.css\");\n/* harmony import */ var bootstrap_slider_dist_css_bootstrap_slider_min_css__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(bootstrap_slider_dist_css_bootstrap_slider_min_css__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _BootstrapSliderWrapper_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./BootstrapSliderWrapper.css */ \"./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/BootstrapSliderWrapper.css\");\n/* harmony import */ var _BootstrapSliderWrapper_css__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_BootstrapSliderWrapper_css__WEBPACK_IMPORTED_MODULE_3__);\n/**\n * Licensed to the Apache Software Foundation (ASF) under one\n * or more contributor license agreements.  See the NOTICE file\n * distributed with this work for additional information\n * regarding copyright ownership.  The ASF licenses this file\n * to you under the Apache License, Version 2.0 (the\n * \"License\"); you may not use this file except in compliance\n * with the License.  You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing,\n * software distributed under the License is distributed on an\n * \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n * KIND, either express or implied.  See the License for the\n * specific language governing permissions and limitations\n * under the License.\n */\n\n\n\n\nfunction BootstrapSliderWrapper(props) {\n  return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(\"span\", {\n    className: \"BootstrapSliderWrapper\"\n  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react_bootstrap_slider__WEBPACK_IMPORTED_MODULE_1___default.a, props));\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/BootstrapSliderWrapper.js\n");

/***/ }),

/***/ "./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/Legend.css":
/*!****************************************************************************************!*\
  !*** ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/Legend.css ***!
  \****************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("var content = __webpack_require__(/*! !../../../../css-loader??ref--7-1!./Legend.css */ \"./node_modules/css-loader/index.js?!./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/Legend.css\");\n\nif (typeof content === 'string') {\n  content = [[module.i, content, '']];\n}\n\nvar options = {}\n\noptions.insert = \"head\";\noptions.singleton = false;\n\nvar update = __webpack_require__(/*! ../../../../style-loader/dist/runtime/injectStylesIntoStyleTag.js */ \"./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js\")(content, options);\n\nif (content.locals) {\n  module.exports = content.locals;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQHN1cGVyc2V0LXVpL2xlZ2FjeS1wcmVzZXQtY2hhcnQtZGVja2dsL2VzbS9jb21wb25lbnRzL0xlZ2VuZC5jc3MuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvQHN1cGVyc2V0LXVpL2xlZ2FjeS1wcmVzZXQtY2hhcnQtZGVja2dsL2VzbS9jb21wb25lbnRzL0xlZ2VuZC5jc3M/YWNlNyJdLCJzb3VyY2VzQ29udGVudCI6WyJ2YXIgY29udGVudCA9IHJlcXVpcmUoXCIhIS4uLy4uLy4uLy4uL2Nzcy1sb2FkZXIvaW5kZXguanM/P3JlZi0tNy0xIS4vTGVnZW5kLmNzc1wiKTtcblxuaWYgKHR5cGVvZiBjb250ZW50ID09PSAnc3RyaW5nJykge1xuICBjb250ZW50ID0gW1ttb2R1bGUuaWQsIGNvbnRlbnQsICcnXV07XG59XG5cbnZhciBvcHRpb25zID0ge31cblxub3B0aW9ucy5pbnNlcnQgPSBcImhlYWRcIjtcbm9wdGlvbnMuc2luZ2xldG9uID0gZmFsc2U7XG5cbnZhciB1cGRhdGUgPSByZXF1aXJlKFwiIS4uLy4uLy4uLy4uL3N0eWxlLWxvYWRlci9kaXN0L3J1bnRpbWUvaW5qZWN0U3R5bGVzSW50b1N0eWxlVGFnLmpzXCIpKGNvbnRlbnQsIG9wdGlvbnMpO1xuXG5pZiAoY29udGVudC5sb2NhbHMpIHtcbiAgbW9kdWxlLmV4cG9ydHMgPSBjb250ZW50LmxvY2Fscztcbn1cbiJdLCJtYXBwaW5ncyI6IkFBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Iiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/Legend.css\n");

/***/ }),

/***/ "./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/Legend.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/Legend.js ***!
  \***************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return Legend; });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"./node_modules/react/index.js\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ \"./node_modules/prop-types/index.js\");\n/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @superset-ui/core */ \"./node_modules/@superset-ui/core/esm/number-format/NumberFormatterRegistrySingleton.js\");\n/* harmony import */ var _Legend_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Legend.css */ \"./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/Legend.css\");\n/* harmony import */ var _Legend_css__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_Legend_css__WEBPACK_IMPORTED_MODULE_3__);\n/* eslint-disable react/jsx-sort-default-props */\n\n/* eslint-disable react/sort-prop-types */\n\n/* eslint-disable jsx-a11y/anchor-is-valid */\n\n/**\n * Licensed to the Apache Software Foundation (ASF) under one\n * or more contributor license agreements.  See the NOTICE file\n * distributed with this work for additional information\n * regarding copyright ownership.  The ASF licenses this file\n * to you under the Apache License, Version 2.0 (the\n * \"License\"); you may not use this file except in compliance\n * with the License.  You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing,\n * software distributed under the License is distributed on an\n * \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n * KIND, either express or implied.  See the License for the\n * specific language governing permissions and limitations\n * under the License.\n */\n\n\n\n\nconst categoryDelimiter = ' - ';\nconst propTypes = {\n  categories: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.object,\n  toggleCategory: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.func,\n  showSingleCategory: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.func,\n  format: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.string,\n  position: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.oneOf([null, 'tl', 'tr', 'bl', 'br'])\n};\nconst defaultProps = {\n  categories: {},\n  toggleCategory: () => {},\n  showSingleCategory: () => {},\n  format: null,\n  position: 'tr'\n};\nclass Legend extends react__WEBPACK_IMPORTED_MODULE_0___default.a.PureComponent {\n  format(value) {\n    if (!this.props.format) {\n      return value;\n    }\n\n    const numValue = parseFloat(value);\n    return Object(_superset_ui_core__WEBPACK_IMPORTED_MODULE_2__[\"formatNumber\"])(this.props.format, numValue);\n  }\n\n  formatCategoryLabel(k) {\n    if (!this.props.format) {\n      return k;\n    }\n\n    if (k.includes(categoryDelimiter)) {\n      const values = k.split(categoryDelimiter);\n      return this.format(values[0]) + categoryDelimiter + this.format(values[1]);\n    }\n\n    return this.format(k);\n  }\n\n  render() {\n    if (Object.keys(this.props.categories).length === 0 || this.props.position === null) {\n      return null;\n    }\n\n    const categories = Object.entries(this.props.categories).map((_ref) => {\n      let [k, v] = _ref;\n      const style = {\n        color: \"rgba(\" + v.color.join(', ') + \")\"\n      };\n      const icon = v.enabled ? '\\u25FC' : '\\u25FB';\n      return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(\"li\", {\n        key: k\n      }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(\"a\", {\n        href: \"#\",\n        onClick: () => this.props.toggleCategory(k),\n        onDoubleClick: () => this.props.showSingleCategory(k)\n      }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(\"span\", {\n        style: style\n      }, icon), \" \", this.formatCategoryLabel(k)));\n    });\n    const vertical = this.props.position.charAt(0) === 't' ? 'top' : 'bottom';\n    const horizontal = this.props.position.charAt(1) === 'r' ? 'right' : 'left';\n    const style = {\n      position: 'absolute',\n      [vertical]: '0px',\n      [horizontal]: '10px'\n    };\n    return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(\"div\", {\n      className: \"legend\",\n      style: style\n    }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(\"ul\", {\n      className: \"categories\"\n    }, categories));\n  }\n\n}\nLegend.propTypes = propTypes;\nLegend.defaultProps = defaultProps;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/Legend.js\n");

/***/ }),

/***/ "./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/PlaySlider.css":
/*!********************************************************************************************!*\
  !*** ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/PlaySlider.css ***!
  \********************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("var content = __webpack_require__(/*! !../../../../css-loader??ref--7-1!./PlaySlider.css */ \"./node_modules/css-loader/index.js?!./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/PlaySlider.css\");\n\nif (typeof content === 'string') {\n  content = [[module.i, content, '']];\n}\n\nvar options = {}\n\noptions.insert = \"head\";\noptions.singleton = false;\n\nvar update = __webpack_require__(/*! ../../../../style-loader/dist/runtime/injectStylesIntoStyleTag.js */ \"./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js\")(content, options);\n\nif (content.locals) {\n  module.exports = content.locals;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQHN1cGVyc2V0LXVpL2xlZ2FjeS1wcmVzZXQtY2hhcnQtZGVja2dsL2VzbS9jb21wb25lbnRzL1BsYXlTbGlkZXIuY3NzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0BzdXBlcnNldC11aS9sZWdhY3ktcHJlc2V0LWNoYXJ0LWRlY2tnbC9lc20vY29tcG9uZW50cy9QbGF5U2xpZGVyLmNzcz9mOTZiIl0sInNvdXJjZXNDb250ZW50IjpbInZhciBjb250ZW50ID0gcmVxdWlyZShcIiEhLi4vLi4vLi4vLi4vY3NzLWxvYWRlci9pbmRleC5qcz8/cmVmLS03LTEhLi9QbGF5U2xpZGVyLmNzc1wiKTtcblxuaWYgKHR5cGVvZiBjb250ZW50ID09PSAnc3RyaW5nJykge1xuICBjb250ZW50ID0gW1ttb2R1bGUuaWQsIGNvbnRlbnQsICcnXV07XG59XG5cbnZhciBvcHRpb25zID0ge31cblxub3B0aW9ucy5pbnNlcnQgPSBcImhlYWRcIjtcbm9wdGlvbnMuc2luZ2xldG9uID0gZmFsc2U7XG5cbnZhciB1cGRhdGUgPSByZXF1aXJlKFwiIS4uLy4uLy4uLy4uL3N0eWxlLWxvYWRlci9kaXN0L3J1bnRpbWUvaW5qZWN0U3R5bGVzSW50b1N0eWxlVGFnLmpzXCIpKGNvbnRlbnQsIG9wdGlvbnMpO1xuXG5pZiAoY29udGVudC5sb2NhbHMpIHtcbiAgbW9kdWxlLmV4cG9ydHMgPSBjb250ZW50LmxvY2Fscztcbn1cbiJdLCJtYXBwaW5ncyI6IkFBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Iiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/PlaySlider.css\n");

/***/ }),

/***/ "./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/PlaySlider.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/PlaySlider.js ***!
  \*******************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return PlaySlider; });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"./node_modules/react/index.js\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ \"./node_modules/prop-types/index.js\");\n/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var mousetrap__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! mousetrap */ \"./node_modules/mousetrap/mousetrap.js\");\n/* harmony import */ var mousetrap__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(mousetrap__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @superset-ui/core */ \"./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js\");\n/* harmony import */ var _BootstrapSliderWrapper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./BootstrapSliderWrapper */ \"./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/BootstrapSliderWrapper.js\");\n/* harmony import */ var _PlaySlider_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./PlaySlider.css */ \"./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/PlaySlider.css\");\n/* harmony import */ var _PlaySlider_css__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_PlaySlider_css__WEBPACK_IMPORTED_MODULE_5__);\n/* eslint-disable react/jsx-sort-default-props */\n\n/* eslint-disable react/sort-prop-types */\n\n/* eslint-disable react/jsx-handler-names */\n\n/* eslint-disable jsx-a11y/click-events-have-key-events */\n\n/* eslint-disable jsx-a11y/no-static-element-interactions */\n\n/* eslint-disable no-negated-condition */\n\n/* eslint-disable react/forbid-prop-types */\n\n/**\n * Licensed to the Apache Software Foundation (ASF) under one\n * or more contributor license agreements.  See the NOTICE file\n * distributed with this work for additional information\n * regarding copyright ownership.  The ASF licenses this file\n * to you under the Apache License, Version 2.0 (the\n * \"License\"); you may not use this file except in compliance\n * with the License.  You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing,\n * software distributed under the License is distributed on an\n * \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n * KIND, either express or implied.  See the License for the\n * specific language governing permissions and limitations\n * under the License.\n */\n\n\n\n\n\n\nconst propTypes = {\n  start: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.number.isRequired,\n  step: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.number.isRequired,\n  end: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.number.isRequired,\n  values: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.array.isRequired,\n  onChange: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.func,\n  loopDuration: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.number,\n  maxFrames: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.number,\n  orientation: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.oneOf(['horizontal', 'vertical']),\n  reversed: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.bool,\n  disabled: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.bool,\n  range: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.bool\n};\nconst defaultProps = {\n  onChange: () => {},\n  loopDuration: 15000,\n  maxFrames: 100,\n  orientation: 'horizontal',\n  reversed: false,\n  disabled: false,\n  range: true\n};\nclass PlaySlider extends react__WEBPACK_IMPORTED_MODULE_0___default.a.PureComponent {\n  constructor(props) {\n    super(props);\n    this.state = {\n      intervalId: null\n    };\n    const range = props.end - props.start;\n    const frames = Math.min(props.maxFrames, range / props.step);\n    const width = range / frames;\n    this.intervalMilliseconds = props.loopDuration / frames;\n    this.increment = width < props.step ? props.step : width - width % props.step;\n    this.onChange = this.onChange.bind(this);\n    this.play = this.play.bind(this);\n    this.pause = this.pause.bind(this);\n    this.stepBackward = this.stepBackward.bind(this);\n    this.stepForward = this.stepForward.bind(this);\n    this.getPlayClass = this.getPlayClass.bind(this);\n    this.formatter = this.formatter.bind(this);\n  }\n\n  componentDidMount() {\n    mousetrap__WEBPACK_IMPORTED_MODULE_2___default.a.bind(['space'], this.play);\n  }\n\n  componentWillUnmount() {\n    mousetrap__WEBPACK_IMPORTED_MODULE_2___default.a.unbind(['space']);\n  }\n\n  onChange(event) {\n    this.props.onChange(event.target.value);\n\n    if (this.state.intervalId != null) {\n      this.pause();\n    }\n  }\n\n  getPlayClass() {\n    if (this.state.intervalId == null) {\n      return 'fa fa-play fa-lg slider-button';\n    }\n\n    return 'fa fa-pause fa-lg slider-button';\n  }\n\n  play() {\n    if (this.props.disabled) {\n      return;\n    }\n\n    if (this.state.intervalId != null) {\n      this.pause();\n    } else {\n      const id = setInterval(this.stepForward, this.intervalMilliseconds);\n      this.setState({\n        intervalId: id\n      });\n    }\n  }\n\n  pause() {\n    clearInterval(this.state.intervalId);\n    this.setState({\n      intervalId: null\n    });\n  }\n\n  stepForward() {\n    const {\n      start,\n      end,\n      step,\n      values,\n      disabled\n    } = this.props;\n\n    if (disabled) {\n      return;\n    }\n\n    const currentValues = Array.isArray(values) ? values : [values, values + step];\n    const nextValues = currentValues.map(value => value + this.increment);\n    const carriageReturn = nextValues[1] > end ? nextValues[0] - start : 0;\n    this.props.onChange(nextValues.map(value => value - carriageReturn));\n  }\n\n  stepBackward() {\n    const {\n      start,\n      end,\n      step,\n      values,\n      disabled\n    } = this.props;\n\n    if (disabled) {\n      return;\n    }\n\n    const currentValues = Array.isArray(values) ? values : [values, values + step];\n    const nextValues = currentValues.map(value => value - this.increment);\n    const carriageReturn = nextValues[0] < start ? end - nextValues[1] : 0;\n    this.props.onChange(nextValues.map(value => value + carriageReturn));\n  }\n\n  formatter(values) {\n    if (this.props.disabled) {\n      return Object(_superset_ui_core__WEBPACK_IMPORTED_MODULE_3__[\"t\"])('Data has no time steps');\n    }\n\n    let parts = values;\n\n    if (!Array.isArray(values)) {\n      parts = [values];\n    } else if (values[0] === values[1]) {\n      parts = [values[0]];\n    }\n\n    return parts.map(value => new Date(value).toUTCString()).join(' : ');\n  }\n\n  render() {\n    const {\n      start,\n      end,\n      step,\n      orientation,\n      reversed,\n      disabled,\n      range,\n      values\n    } = this.props;\n    return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(\"div\", {\n      className: \"play-slider\"\n    }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(\"div\", {\n      className: \"play-slider-controls padded\"\n    }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(\"i\", {\n      className: \"fa fa-step-backward fa-lg slider-button \",\n      onClick: this.stepBackward\n    }), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(\"i\", {\n      className: this.getPlayClass(),\n      onClick: this.play\n    }), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(\"i\", {\n      className: \"fa fa-step-forward fa-lg slider-button \",\n      onClick: this.stepForward\n    })), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(\"div\", {\n      className: \"play-slider-scrobbler padded\"\n    }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_BootstrapSliderWrapper__WEBPACK_IMPORTED_MODULE_4__[\"default\"], {\n      value: range ? values : values[0],\n      range: range,\n      formatter: this.formatter,\n      change: this.onChange,\n      min: start,\n      max: end,\n      step: step,\n      orientation: orientation,\n      reversed: reversed,\n      disabled: disabled ? 'disabled' : 'enabled'\n    })));\n  }\n\n}\nPlaySlider.propTypes = propTypes;\nPlaySlider.defaultProps = defaultProps;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/PlaySlider.js\n");

/***/ }),

/***/ "./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/factory.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/factory.js ***!
  \*****************************************************************************/
/*! exports provided: createDeckGLComponent, createCategoricalDeckGLComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"createDeckGLComponent\", function() { return createDeckGLComponent; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"createCategoricalDeckGLComponent\", function() { return createCategoricalDeckGLComponent; });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"./node_modules/react/index.js\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ \"./node_modules/prop-types/index.js\");\n/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash */ \"./node_modules/lodash/lodash.js\");\n/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _DeckGLContainer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./DeckGLContainer */ \"./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/DeckGLContainer.js\");\n/* harmony import */ var _CategoricalDeckGLContainer__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./CategoricalDeckGLContainer */ \"./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/CategoricalDeckGLContainer.js\");\n/* harmony import */ var _utils_fitViewport__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./utils/fitViewport */ \"./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/utils/fitViewport.js\");\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\n/* eslint-disable react/sort-prop-types */\n\n/* eslint-disable react/jsx-handler-names */\n\n/* eslint-disable camelcase */\n\n/* eslint-disable react/no-unused-prop-types */\n\n/**\n * Licensed to the Apache Software Foundation (ASF) under one\n * or more contributor license agreements.  See the NOTICE file\n * distributed with this work for additional information\n * regarding copyright ownership.  The ASF licenses this file\n * to you under the Apache License, Version 2.0 (the\n * \"License\"); you may not use this file except in compliance\n * with the License.  You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing,\n * software distributed under the License is distributed on an\n * \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n * KIND, either express or implied.  See the License for the\n * specific language governing permissions and limitations\n * under the License.\n */\n\n\n\n\n // eslint-disable-next-line import/extensions\n\n\nconst propTypes = {\n  formData: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.object.isRequired,\n  payload: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.object.isRequired,\n  setControlValue: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.func.isRequired,\n  viewport: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.object.isRequired,\n  onAddFilter: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.func,\n  width: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.number.isRequired,\n  height: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.number.isRequired\n};\nconst defaultProps = {\n  onAddFilter() {}\n\n};\nfunction createDeckGLComponent(getLayer, getPoints) {\n  // Higher order component\n  class Component extends react__WEBPACK_IMPORTED_MODULE_0___default.a.PureComponent {\n    constructor(props) {\n      super(props);\n\n      _defineProperty(this, \"containerRef\", react__WEBPACK_IMPORTED_MODULE_0___default.a.createRef());\n\n      _defineProperty(this, \"setTooltip\", tooltip => {\n        const {\n          current\n        } = this.containerRef;\n\n        if (current) {\n          current.setTooltip(tooltip);\n        }\n      });\n\n      const {\n        width,\n        height,\n        formData\n      } = props;\n      let {\n        viewport\n      } = props;\n\n      if (formData.autozoom) {\n        viewport = Object(_utils_fitViewport__WEBPACK_IMPORTED_MODULE_5__[\"default\"])(viewport, {\n          width,\n          height,\n          points: getPoints(props.payload.data.features)\n        });\n      }\n\n      this.state = {\n        viewport,\n        layer: this.computeLayer(props)\n      };\n      this.onViewportChange = this.onViewportChange.bind(this);\n    }\n\n    UNSAFE_componentWillReceiveProps(nextProps) {\n      // Only recompute the layer if anything BUT the viewport has changed\n      const nextFdNoVP = _extends({}, nextProps.formData, {\n        viewport: null\n      });\n\n      const currFdNoVP = _extends({}, this.props.formData, {\n        viewport: null\n      });\n\n      if (!Object(lodash__WEBPACK_IMPORTED_MODULE_2__[\"isEqual\"])(nextFdNoVP, currFdNoVP) || nextProps.payload !== this.props.payload) {\n        this.setState({\n          layer: this.computeLayer(nextProps)\n        });\n      }\n    }\n\n    onViewportChange(viewport) {\n      this.setState({\n        viewport\n      });\n    }\n\n    computeLayer(props) {\n      const {\n        formData,\n        payload,\n        onAddFilter\n      } = props;\n      return getLayer(formData, payload, onAddFilter, this.setTooltip);\n    }\n\n    render() {\n      const {\n        formData,\n        payload,\n        setControlValue,\n        height,\n        width\n      } = this.props;\n      const {\n        layer,\n        viewport\n      } = this.state;\n      return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_DeckGLContainer__WEBPACK_IMPORTED_MODULE_3__[\"default\"], {\n        ref: this.containerRef,\n        mapboxApiAccessToken: payload.data.mapboxApiKey,\n        viewport: viewport,\n        layers: [layer],\n        mapStyle: formData.mapbox_style,\n        setControlValue: setControlValue,\n        width: width,\n        height: height,\n        onViewportChange: this.onViewportChange\n      });\n    }\n\n  }\n\n  Component.propTypes = propTypes;\n  Component.defaultProps = defaultProps;\n  return Component;\n}\nfunction createCategoricalDeckGLComponent(getLayer, getPoints) {\n  function Component(props) {\n    const {\n      formData,\n      payload,\n      setControlValue,\n      viewport,\n      width,\n      height\n    } = props;\n    return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_CategoricalDeckGLContainer__WEBPACK_IMPORTED_MODULE_4__[\"default\"], {\n      formData: formData,\n      mapboxApiKey: payload.data.mapboxApiKey,\n      setControlValue: setControlValue,\n      viewport: viewport,\n      getLayer: getLayer,\n      payload: payload,\n      getPoints: getPoints,\n      width: width,\n      height: height\n    });\n  }\n\n  Component.propTypes = propTypes;\n  Component.defaultProps = defaultProps;\n  return Component;\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/factory.js\n");

/***/ }),

/***/ "./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/layers/Hex/Hex.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/layers/Hex/Hex.js ***!
  \************************************************************************************/
/*! exports provided: getLayer, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getLayer\", function() { return getLayer; });\n/* harmony import */ var deck_gl__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! deck.gl */ \"./node_modules/@deck.gl/aggregation-layers/dist/esm/hexagon-layer/hexagon-layer.js\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ \"./node_modules/react/index.js\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @superset-ui/core */ \"./node_modules/@superset-ui/core/esm/translation/TranslatorSingleton.js\");\n/* harmony import */ var _common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../common */ \"./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/layers/common.js\");\n/* harmony import */ var _utils_sandbox__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/sandbox */ \"./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/utils/sandbox.js\");\n/* harmony import */ var _factory__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../factory */ \"./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/factory.js\");\n/* harmony import */ var _TooltipRow__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../TooltipRow */ \"./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/TooltipRow.js\");\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\n/**\n * Licensed to the Apache Software Foundation (ASF) under one\n * or more contributor license agreements.  See the NOTICE file\n * distributed with this work for additional information\n * regarding copyright ownership.  The ASF licenses this file\n * to you under the Apache License, Version 2.0 (the\n * \"License\"); you may not use this file except in compliance\n * with the License.  You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing,\n * software distributed under the License is distributed on an\n * \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n * KIND, either express or implied.  See the License for the\n * specific language governing permissions and limitations\n * under the License.\n */\n\n\n\n\n\n\n\n\nfunction setTooltipContent(o) {\n  return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(\"div\", {\n    className: \"deckgl-tooltip\"\n  }, react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_TooltipRow__WEBPACK_IMPORTED_MODULE_6__[\"default\"], {\n    label: Object(_superset_ui_core__WEBPACK_IMPORTED_MODULE_2__[\"t\"])('Centroid (Longitude and Latitude)') + \": \",\n    value: \"(\" + o.coordinate[0] + \", \" + o.coordinate[1] + \")\"\n  }), react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_TooltipRow__WEBPACK_IMPORTED_MODULE_6__[\"default\"], {\n    label: Object(_superset_ui_core__WEBPACK_IMPORTED_MODULE_2__[\"t\"])('Height') + \": \",\n    value: \"\" + o.object.elevationValue\n  }));\n}\n\nfunction getLayer(formData, payload, onAddFilter, setTooltip) {\n  const fd = formData;\n  const c = fd.color_picker;\n  let data = payload.data.features.map(d => _extends({}, d, {\n    color: [c.r, c.g, c.b, 255 * c.a]\n  }));\n\n  if (fd.js_data_mutator) {\n    // Applying user defined data mutator if defined\n    const jsFnMutator = Object(_utils_sandbox__WEBPACK_IMPORTED_MODULE_4__[\"default\"])(fd.js_data_mutator);\n    data = jsFnMutator(data);\n  }\n\n  const aggFunc = Object(_common__WEBPACK_IMPORTED_MODULE_3__[\"getAggFunc\"])(fd.js_agg_function, p => p.weight);\n  return new deck_gl__WEBPACK_IMPORTED_MODULE_0__[\"default\"](_extends({\n    id: \"hex-layer-\" + fd.slice_id,\n    data,\n    pickable: true,\n    radius: fd.grid_size,\n    minColor: [0, 0, 0, 0],\n    extruded: fd.extruded,\n    maxColor: [c.r, c.g, c.b, 255 * c.a],\n    outline: false,\n    getElevationValue: aggFunc,\n    getColorValue: aggFunc\n  }, Object(_common__WEBPACK_IMPORTED_MODULE_3__[\"commonLayerProps\"])(fd, setTooltip, setTooltipContent)));\n}\n\nfunction getPoints(data) {\n  return data.map(d => d.position);\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Object(_factory__WEBPACK_IMPORTED_MODULE_5__[\"createDeckGLComponent\"])(getLayer, getPoints));//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/layers/Hex/Hex.js\n");

/***/ }),

/***/ "./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/utils/computeBoundsFromPoints.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/utils/computeBoundsFromPoints.js ***!
  \***************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return computeBoundsFromPoints; });\n/* harmony import */ var d3_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-array */ \"./node_modules/d3-array/src/index.js\");\n\nconst LAT_LIMIT = [-90, 90];\nconst LNG_LIMIT = [-180, 180];\n/**\n * Expand a coordinate range by `padding` and within limits, if needed\n */\n\nfunction expandIfNeeded(_ref, _ref2, padding) {\n  let [curMin, curMax] = _ref;\n  let [minBound, maxBound] = _ref2;\n\n  if (padding === void 0) {\n    padding = 0.25;\n  }\n\n  return curMin < curMax ? [curMin, curMax] : [Math.max(minBound, curMin - padding), Math.min(maxBound, curMax + padding)];\n}\n\nfunction computeBoundsFromPoints(points) {\n  const latBounds = expandIfNeeded(Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"extent\"])(points, x => x[1]), LAT_LIMIT);\n  const lngBounds = expandIfNeeded(Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"extent\"])(points, x => x[0]), LNG_LIMIT);\n  return [[lngBounds[0], latBounds[0]], [lngBounds[1], latBounds[1]]];\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQHN1cGVyc2V0LXVpL2xlZ2FjeS1wcmVzZXQtY2hhcnQtZGVja2dsL2VzbS91dGlscy9jb21wdXRlQm91bmRzRnJvbVBvaW50cy5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9Ac3VwZXJzZXQtdWkvbGVnYWN5LXByZXNldC1jaGFydC1kZWNrZ2wvZXNtL3V0aWxzL2NvbXB1dGVCb3VuZHNGcm9tUG9pbnRzLmpzPzkwZjciXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgZXh0ZW50IGFzIGQzRXh0ZW50IH0gZnJvbSAnZDMtYXJyYXknO1xuY29uc3QgTEFUX0xJTUlUID0gWy05MCwgOTBdO1xuY29uc3QgTE5HX0xJTUlUID0gWy0xODAsIDE4MF07XG4vKipcbiAqIEV4cGFuZCBhIGNvb3JkaW5hdGUgcmFuZ2UgYnkgYHBhZGRpbmdgIGFuZCB3aXRoaW4gbGltaXRzLCBpZiBuZWVkZWRcbiAqL1xuXG5mdW5jdGlvbiBleHBhbmRJZk5lZWRlZChfcmVmLCBfcmVmMiwgcGFkZGluZykge1xuICBsZXQgW2N1ck1pbiwgY3VyTWF4XSA9IF9yZWY7XG4gIGxldCBbbWluQm91bmQsIG1heEJvdW5kXSA9IF9yZWYyO1xuXG4gIGlmIChwYWRkaW5nID09PSB2b2lkIDApIHtcbiAgICBwYWRkaW5nID0gMC4yNTtcbiAgfVxuXG4gIHJldHVybiBjdXJNaW4gPCBjdXJNYXggPyBbY3VyTWluLCBjdXJNYXhdIDogW01hdGgubWF4KG1pbkJvdW5kLCBjdXJNaW4gLSBwYWRkaW5nKSwgTWF0aC5taW4obWF4Qm91bmQsIGN1ck1heCArIHBhZGRpbmcpXTtcbn1cblxuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gY29tcHV0ZUJvdW5kc0Zyb21Qb2ludHMocG9pbnRzKSB7XG4gIGNvbnN0IGxhdEJvdW5kcyA9IGV4cGFuZElmTmVlZGVkKGQzRXh0ZW50KHBvaW50cywgeCA9PiB4WzFdKSwgTEFUX0xJTUlUKTtcbiAgY29uc3QgbG5nQm91bmRzID0gZXhwYW5kSWZOZWVkZWQoZDNFeHRlbnQocG9pbnRzLCB4ID0+IHhbMF0pLCBMTkdfTElNSVQpO1xuICByZXR1cm4gW1tsbmdCb3VuZHNbMF0sIGxhdEJvdW5kc1swXV0sIFtsbmdCb3VuZHNbMV0sIGxhdEJvdW5kc1sxXV1dO1xufSJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/utils/computeBoundsFromPoints.js\n");

/***/ }),

/***/ "./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/utils/fitViewport.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/utils/fitViewport.js ***!
  \***************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return fitViewport; });\n/* harmony import */ var _math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @math.gl/web-mercator */ \"./node_modules/@math.gl/web-mercator/dist/esm/index.js\");\n/* harmony import */ var _computeBoundsFromPoints__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./computeBoundsFromPoints */ \"./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/utils/computeBoundsFromPoints.js\");\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\n\n\nfunction fitViewport(originalViewPort, _ref) {\n  let {\n    points,\n    width,\n    height,\n    minExtent,\n    maxZoom,\n    offset,\n    padding = 20\n  } = _ref;\n  const {\n    bearing,\n    pitch\n  } = originalViewPort;\n  const bounds = Object(_computeBoundsFromPoints__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(points);\n\n  try {\n    return _extends({}, Object(_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_0__[\"fitBounds\"])({\n      bounds,\n      width,\n      height,\n      minExtent,\n      maxZoom,\n      offset,\n      padding\n    }), {\n      bearing,\n      pitch\n    });\n  } catch (error) {\n    // eslint-disable-next-line no-console\n    console.error('Could not fit viewport', error);\n  }\n\n  return originalViewPort;\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/utils/fitViewport.js\n");

/***/ }),

/***/ "./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/utils/time.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/utils/time.js ***!
  \********************************************************************************/
/*! exports provided: truncate, getPlaySliderParams */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"truncate\", function() { return truncate; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getPlaySliderParams\", function() { return getPlaySliderParams; });\n/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! moment */ \"./node_modules/moment/moment.js\");\n/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_0__);\n/* eslint-disable no-negated-condition */\n\n/**\n * Licensed to the Apache Software Foundation (ASF) under one\n * or more contributor license agreements.  See the NOTICE file\n * distributed with this work for additional information\n * regarding copyright ownership.  The ASF licenses this file\n * to you under the Apache License, Version 2.0 (the\n * \"License\"); you may not use this file except in compliance\n * with the License.  You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing,\n * software distributed under the License is distributed on an\n * \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n * KIND, either express or implied.  See the License for the\n * specific language governing permissions and limitations\n * under the License.\n */\n // array with the minimum values of each part of a timestamp -- note that\n// months are zero-indexed in Javascript\n\nconst truncatePartTo = [1, // year\n0, // month\n1, // day\n0, // hour\n0, // minute\n0, // second\n0 // millisecond\n];\nfunction truncate(timestamp, step) {\n  /*\n   * Truncate timestamp down to duration resolution.\n   */\n  const lowerBound = moment__WEBPACK_IMPORTED_MODULE_0___default()(timestamp).subtract(step);\n  const explodedTimestamp = timestamp.toArray();\n  const explodedLowerBound = lowerBound.toArray();\n  const firstDiffIndex = explodedTimestamp.map((part, i) => explodedLowerBound[i] !== part).indexOf(true);\n  const dateParts = explodedTimestamp.map((part, i) => {\n    if (i === firstDiffIndex) {\n      // truncate down to closest `truncatePartTo[i] + n * step`\n      const difference = part - explodedLowerBound[i];\n      return part - (part - truncatePartTo[i]) % difference;\n    }\n\n    if (i < firstDiffIndex || firstDiffIndex === -1) {\n      return part;\n    }\n\n    return truncatePartTo[i];\n  });\n  return moment__WEBPACK_IMPORTED_MODULE_0___default()(dateParts);\n}\n\nfunction getStepSeconds(step, start) {\n  /* Return number of seconds in a step.\n   *\n   * The step might be ambigous, eg, \"1 month\" has a variable number of\n   * seconds, which is why we need to know the start time.\n   */\n  const startMillliseconds = parseInt(moment__WEBPACK_IMPORTED_MODULE_0___default()(start).format('x'), 10);\n  const endMilliseconds = parseInt(moment__WEBPACK_IMPORTED_MODULE_0___default()(start).add(step).format('x'), 10);\n  return endMilliseconds - startMillliseconds;\n}\n\nfunction getPlaySliderParams(timestamps, timeGrain) {\n  const minTimestamp = moment__WEBPACK_IMPORTED_MODULE_0___default()(Number(timestamps.reduce((a, b) => a < b ? a : b)));\n  const maxTimestamp = moment__WEBPACK_IMPORTED_MODULE_0___default()(Number(timestamps.reduce((a, b) => a > b ? a : b)));\n  let step;\n  let reference;\n\n  if (timeGrain.includes('/')) {\n    // Here, time grain is a time interval instead of a simple duration, either\n    // `reference/duration` or `duration/reference`. We need to parse the\n    // duration and make sure that start and end are in the right places. For\n    // example, if `reference` is a Saturday and `duration` is 1 week (P1W)\n    // then both start and end should be Saturdays.\n    const parts = timeGrain.split('/', 2);\n\n    if (parts[0].endsWith('Z')) {\n      // ISO string\n      reference = moment__WEBPACK_IMPORTED_MODULE_0___default()(parts[0]);\n      step = moment__WEBPACK_IMPORTED_MODULE_0___default.a.duration(parts[1]);\n    } else {\n      reference = moment__WEBPACK_IMPORTED_MODULE_0___default()(parts[1]);\n      step = moment__WEBPACK_IMPORTED_MODULE_0___default.a.duration(parts[0]);\n    }\n  } else {\n    step = moment__WEBPACK_IMPORTED_MODULE_0___default.a.duration(timeGrain);\n    reference = truncate(minTimestamp, step);\n  } // find the largest `reference + n * step` smaller than the minimum timestamp\n\n\n  let start;\n  const minValue = minTimestamp.valueOf();\n\n  for (start = reference.clone(); start.valueOf() < minValue;) {\n    start.add(step);\n  }\n\n  for (; start.valueOf() > minValue;) {\n    start.subtract(step);\n  } // find the smallest `reference + n * step` larger than the maximum timestamp\n\n\n  let end;\n  const maxValue = maxTimestamp.valueOf();\n\n  for (end = reference.clone(); end.valueOf() > maxValue;) {\n    end.subtract(step);\n  }\n\n  for (; end.valueOf() < maxValue;) {\n    end.add(step);\n  }\n\n  const values = timeGrain != null ? [start, start.clone().add(step)] : [start, end];\n  const disabled = timestamps.every(timestamp => timestamp === null);\n  return {\n    start: parseInt(start.format('x'), 10),\n    end: parseInt(end.format('x'), 10),\n    getStep: getStepSeconds.bind(this, step),\n    values: values.map(v => parseInt(v.format('x'), 10)),\n    disabled\n  };\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/utils/time.js\n");

/***/ }),

/***/ "./node_modules/bootstrap-slider/dist/css/bootstrap-slider.min.css":
/*!*************************************************************************!*\
  !*** ./node_modules/bootstrap-slider/dist/css/bootstrap-slider.min.css ***!
  \*************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("var content = __webpack_require__(/*! !../../../css-loader??ref--7-1!./bootstrap-slider.min.css */ \"./node_modules/css-loader/index.js?!./node_modules/bootstrap-slider/dist/css/bootstrap-slider.min.css\");\n\nif (typeof content === 'string') {\n  content = [[module.i, content, '']];\n}\n\nvar options = {}\n\noptions.insert = \"head\";\noptions.singleton = false;\n\nvar update = __webpack_require__(/*! ../../../style-loader/dist/runtime/injectStylesIntoStyleTag.js */ \"./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js\")(content, options);\n\nif (content.locals) {\n  module.exports = content.locals;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvYm9vdHN0cmFwLXNsaWRlci9kaXN0L2Nzcy9ib290c3RyYXAtc2xpZGVyLm1pbi5jc3MuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvYm9vdHN0cmFwLXNsaWRlci9kaXN0L2Nzcy9ib290c3RyYXAtc2xpZGVyLm1pbi5jc3M/MTNiNSJdLCJzb3VyY2VzQ29udGVudCI6WyJ2YXIgY29udGVudCA9IHJlcXVpcmUoXCIhIS4uLy4uLy4uL2Nzcy1sb2FkZXIvaW5kZXguanM/P3JlZi0tNy0xIS4vYm9vdHN0cmFwLXNsaWRlci5taW4uY3NzXCIpO1xuXG5pZiAodHlwZW9mIGNvbnRlbnQgPT09ICdzdHJpbmcnKSB7XG4gIGNvbnRlbnQgPSBbW21vZHVsZS5pZCwgY29udGVudCwgJyddXTtcbn1cblxudmFyIG9wdGlvbnMgPSB7fVxuXG5vcHRpb25zLmluc2VydCA9IFwiaGVhZFwiO1xub3B0aW9ucy5zaW5nbGV0b24gPSBmYWxzZTtcblxudmFyIHVwZGF0ZSA9IHJlcXVpcmUoXCIhLi4vLi4vLi4vc3R5bGUtbG9hZGVyL2Rpc3QvcnVudGltZS9pbmplY3RTdHlsZXNJbnRvU3R5bGVUYWcuanNcIikoY29udGVudCwgb3B0aW9ucyk7XG5cbmlmIChjb250ZW50LmxvY2Fscykge1xuICBtb2R1bGUuZXhwb3J0cyA9IGNvbnRlbnQubG9jYWxzO1xufVxuIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTsiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/bootstrap-slider/dist/css/bootstrap-slider.min.css\n");

/***/ }),

/***/ "./node_modules/css-loader/index.js?!./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/BootstrapSliderWrapper.css":
/*!********************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader??ref--7-1!./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/BootstrapSliderWrapper.css ***!
  \********************************************************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("exports = module.exports = __webpack_require__(/*! ../../../../css-loader/lib/css-base.js */ \"./node_modules/css-loader/lib/css-base.js\")(true);\n// imports\n\n\n// module\nexports.push([module.i, \"/**\\n * Licensed to the Apache Software Foundation (ASF) under one\\n * or more contributor license agreements.  See the NOTICE file\\n * distributed with this work for additional information\\n * regarding copyright ownership.  The ASF licenses this file\\n * to you under the Apache License, Version 2.0 (the\\n * \\\"License\\\"); you may not use this file except in compliance\\n * with the License.  You may obtain a copy of the License at\\n *\\n *   http://www.apache.org/licenses/LICENSE-2.0\\n *\\n * Unless required by applicable law or agreed to in writing,\\n * software distributed under the License is distributed on an\\n * \\\"AS IS\\\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\\n * KIND, either express or implied.  See the License for the\\n * specific language governing permissions and limitations\\n * under the License.\\n */\\n.BootstrapSliderWrapper .slider-selection {\\n  background: #efefef;\\n}\\n\\n.BootstrapSliderWrapper .slider-handle {\\n  background: #b3b3b3;\\n}\\n\", \"\", {\"version\":3,\"sources\":[\"/Users/admin/Git/Public/spotrix/spotrix-frontend/node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/BootstrapSliderWrapper.css\"],\"names\":[],\"mappings\":\"AAAA;;;;;;;;;;;;;;;;;GAiBG;AACH;EACE,oBAAoB;CACrB;;AAED;EACE,oBAAoB;CACrB\",\"file\":\"BootstrapSliderWrapper.css\",\"sourcesContent\":[\"/**\\n * Licensed to the Apache Software Foundation (ASF) under one\\n * or more contributor license agreements.  See the NOTICE file\\n * distributed with this work for additional information\\n * regarding copyright ownership.  The ASF licenses this file\\n * to you under the Apache License, Version 2.0 (the\\n * \\\"License\\\"); you may not use this file except in compliance\\n * with the License.  You may obtain a copy of the License at\\n *\\n *   http://www.apache.org/licenses/LICENSE-2.0\\n *\\n * Unless required by applicable law or agreed to in writing,\\n * software distributed under the License is distributed on an\\n * \\\"AS IS\\\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\\n * KIND, either express or implied.  See the License for the\\n * specific language governing permissions and limitations\\n * under the License.\\n */\\n.BootstrapSliderWrapper .slider-selection {\\n  background: #efefef;\\n}\\n\\n.BootstrapSliderWrapper .slider-handle {\\n  background: #b3b3b3;\\n}\\n\"],\"sourceRoot\":\"\"}]);\n\n// exports\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/css-loader/index.js?!./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/BootstrapSliderWrapper.css\n");

/***/ }),

/***/ "./node_modules/css-loader/index.js?!./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/Legend.css":
/*!****************************************************************************************************************************!*\
  !*** ./node_modules/css-loader??ref--7-1!./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/Legend.css ***!
  \****************************************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("exports = module.exports = __webpack_require__(/*! ../../../../css-loader/lib/css-base.js */ \"./node_modules/css-loader/lib/css-base.js\")(true);\n// imports\n\n\n// module\nexports.push([module.i, \"/**\\n * Licensed to the Apache Software Foundation (ASF) under one\\n * or more contributor license agreements.  See the NOTICE file\\n * distributed with this work for additional information\\n * regarding copyright ownership.  The ASF licenses this file\\n * to you under the Apache License, Version 2.0 (the\\n * \\\"License\\\"); you may not use this file except in compliance\\n * with the License.  You may obtain a copy of the License at\\n *\\n *   http://www.apache.org/licenses/LICENSE-2.0\\n *\\n * Unless required by applicable law or agreed to in writing,\\n * software distributed under the License is distributed on an\\n * \\\"AS IS\\\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\\n * KIND, either express or implied.  See the License for the\\n * specific language governing permissions and limitations\\n * under the License.\\n */\\ndiv.legend {\\n  font-size: 90%;\\n  position: absolute;\\n  background: #fff;\\n  box-shadow: 0 0 4px rgba(0, 0, 0, 0.15);\\n  margin: 24px;\\n  padding: 12px 20px;\\n  outline: none;\\n  overflow-y: scroll;\\n  max-height: 200px;\\n}\\n\\nul.categories {\\n  list-style: none;\\n  padding-left: 0;\\n  margin: 0;\\n}\\n\\nul.categories li a {\\n  color: rgb(51, 51, 51);\\n  text-decoration: none;\\n}\\n\\nul.categories li a span {\\n  margin-right: 10px;\\n}\\n\", \"\", {\"version\":3,\"sources\":[\"/Users/admin/Git/Public/spotrix/spotrix-frontend/node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/Legend.css\"],\"names\":[],\"mappings\":\"AAAA;;;;;;;;;;;;;;;;;GAiBG;AACH;EACE,eAAe;EACf,mBAAmB;EACnB,iBAAiB;EACjB,wCAAwC;EACxC,aAAa;EACb,mBAAmB;EACnB,cAAc;EACd,mBAAmB;EACnB,kBAAkB;CACnB;;AAED;EACE,iBAAiB;EACjB,gBAAgB;EAChB,UAAU;CACX;;AAED;EACE,uBAAuB;EACvB,sBAAsB;CACvB;;AAED;EACE,mBAAmB;CACpB\",\"file\":\"Legend.css\",\"sourcesContent\":[\"/**\\n * Licensed to the Apache Software Foundation (ASF) under one\\n * or more contributor license agreements.  See the NOTICE file\\n * distributed with this work for additional information\\n * regarding copyright ownership.  The ASF licenses this file\\n * to you under the Apache License, Version 2.0 (the\\n * \\\"License\\\"); you may not use this file except in compliance\\n * with the License.  You may obtain a copy of the License at\\n *\\n *   http://www.apache.org/licenses/LICENSE-2.0\\n *\\n * Unless required by applicable law or agreed to in writing,\\n * software distributed under the License is distributed on an\\n * \\\"AS IS\\\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\\n * KIND, either express or implied.  See the License for the\\n * specific language governing permissions and limitations\\n * under the License.\\n */\\ndiv.legend {\\n  font-size: 90%;\\n  position: absolute;\\n  background: #fff;\\n  box-shadow: 0 0 4px rgba(0, 0, 0, 0.15);\\n  margin: 24px;\\n  padding: 12px 20px;\\n  outline: none;\\n  overflow-y: scroll;\\n  max-height: 200px;\\n}\\n\\nul.categories {\\n  list-style: none;\\n  padding-left: 0;\\n  margin: 0;\\n}\\n\\nul.categories li a {\\n  color: rgb(51, 51, 51);\\n  text-decoration: none;\\n}\\n\\nul.categories li a span {\\n  margin-right: 10px;\\n}\\n\"],\"sourceRoot\":\"\"}]);\n\n// exports\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/css-loader/index.js?!./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/Legend.css\n");

/***/ }),

/***/ "./node_modules/css-loader/index.js?!./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/PlaySlider.css":
/*!********************************************************************************************************************************!*\
  !*** ./node_modules/css-loader??ref--7-1!./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/PlaySlider.css ***!
  \********************************************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("exports = module.exports = __webpack_require__(/*! ../../../../css-loader/lib/css-base.js */ \"./node_modules/css-loader/lib/css-base.js\")(true);\n// imports\n\n\n// module\nexports.push([module.i, \"/**\\n * Licensed to the Apache Software Foundation (ASF) under one\\n * or more contributor license agreements.  See the NOTICE file\\n * distributed with this work for additional information\\n * regarding copyright ownership.  The ASF licenses this file\\n * to you under the Apache License, Version 2.0 (the\\n * \\\"License\\\"); you may not use this file except in compliance\\n * with the License.  You may obtain a copy of the License at\\n *\\n *   http://www.apache.org/licenses/LICENSE-2.0\\n *\\n * Unless required by applicable law or agreed to in writing,\\n * software distributed under the License is distributed on an\\n * \\\"AS IS\\\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\\n * KIND, either express or implied.  See the License for the\\n * specific language governing permissions and limitations\\n * under the License.\\n */\\n.play-slider {\\n  display: flex;\\n  height: 40px;\\n  width: 100%;\\n  margin: 0;\\n}\\n\\n.play-slider-controls {\\n  flex: 0 0 80px;\\n  text-align: middle;\\n}\\n\\n.play-slider-scrobbler {\\n  flex: 1;\\n}\\n\\n.slider.slider-horizontal {\\n  width: 100% !important;\\n}\\n\\n.slider-button {\\n  color: #b3b3b3;\\n  margin-right: 5px;\\n}\\n\\ndiv.slider > div.tooltip.tooltip-main.top.in {\\n  margin-left: 0 !important;\\n}\\n\", \"\", {\"version\":3,\"sources\":[\"/Users/admin/Git/Public/spotrix/spotrix-frontend/node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/PlaySlider.css\"],\"names\":[],\"mappings\":\"AAAA;;;;;;;;;;;;;;;;;GAiBG;AACH;EACE,cAAc;EACd,aAAa;EACb,YAAY;EACZ,UAAU;CACX;;AAED;EACE,eAAe;EACf,mBAAmB;CACpB;;AAED;EACE,QAAQ;CACT;;AAED;EACE,uBAAuB;CACxB;;AAED;EACE,eAAe;EACf,kBAAkB;CACnB;;AAED;EACE,0BAA0B;CAC3B\",\"file\":\"PlaySlider.css\",\"sourcesContent\":[\"/**\\n * Licensed to the Apache Software Foundation (ASF) under one\\n * or more contributor license agreements.  See the NOTICE file\\n * distributed with this work for additional information\\n * regarding copyright ownership.  The ASF licenses this file\\n * to you under the Apache License, Version 2.0 (the\\n * \\\"License\\\"); you may not use this file except in compliance\\n * with the License.  You may obtain a copy of the License at\\n *\\n *   http://www.apache.org/licenses/LICENSE-2.0\\n *\\n * Unless required by applicable law or agreed to in writing,\\n * software distributed under the License is distributed on an\\n * \\\"AS IS\\\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\\n * KIND, either express or implied.  See the License for the\\n * specific language governing permissions and limitations\\n * under the License.\\n */\\n.play-slider {\\n  display: flex;\\n  height: 40px;\\n  width: 100%;\\n  margin: 0;\\n}\\n\\n.play-slider-controls {\\n  flex: 0 0 80px;\\n  text-align: middle;\\n}\\n\\n.play-slider-scrobbler {\\n  flex: 1;\\n}\\n\\n.slider.slider-horizontal {\\n  width: 100% !important;\\n}\\n\\n.slider-button {\\n  color: #b3b3b3;\\n  margin-right: 5px;\\n}\\n\\ndiv.slider > div.tooltip.tooltip-main.top.in {\\n  margin-left: 0 !important;\\n}\\n\"],\"sourceRoot\":\"\"}]);\n\n// exports\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/css-loader/index.js?!./node_modules/@superset-ui/legacy-preset-chart-deckgl/esm/components/PlaySlider.css\n");

/***/ }),

/***/ "./node_modules/css-loader/index.js?!./node_modules/bootstrap-slider/dist/css/bootstrap-slider.min.css":
/*!*************************************************************************************************************!*\
  !*** ./node_modules/css-loader??ref--7-1!./node_modules/bootstrap-slider/dist/css/bootstrap-slider.min.css ***!
  \*************************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("exports = module.exports = __webpack_require__(/*! ../../../css-loader/lib/css-base.js */ \"./node_modules/css-loader/lib/css-base.js\")(true);\n// imports\n\n\n// module\nexports.push([module.i, \"/*! =======================================================\\n                      VERSION  10.4.0              \\n========================================================= */\\n/*! =========================================================\\n * bootstrap-slider.js\\n *\\n * Maintainers:\\n *\\t\\tKyle Kemp\\n *\\t\\t\\t- Twitter: @seiyria\\n *\\t\\t\\t- Github:  seiyria\\n *\\t\\tRohit Kalkur\\n *\\t\\t\\t- Twitter: @Rovolutionary\\n *\\t\\t\\t- Github:  rovolution\\n *\\n * =========================================================\\n  *\\n * bootstrap-slider is released under the MIT License\\n * Copyright (c) 2017 Kyle Kemp, Rohit Kalkur, and contributors\\n * \\n * Permission is hereby granted, free of charge, to any person\\n * obtaining a copy of this software and associated documentation\\n * files (the \\\"Software\\\"), to deal in the Software without\\n * restriction, including without limitation the rights to use,\\n * copy, modify, merge, publish, distribute, sublicense, and/or sell\\n * copies of the Software, and to permit persons to whom the\\n * Software is furnished to do so, subject to the following\\n * conditions:\\n * \\n * The above copyright notice and this permission notice shall be\\n * included in all copies or substantial portions of the Software.\\n * \\n * THE SOFTWARE IS PROVIDED \\\"AS IS\\\", WITHOUT WARRANTY OF ANY KIND,\\n * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES\\n * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND\\n * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT\\n * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,\\n * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR\\n * OTHER DEALINGS IN THE SOFTWARE.\\n *\\n * ========================================================= */.slider{display:inline-block;vertical-align:middle;position:relative}.slider.slider-horizontal{width:210px;height:20px}.slider.slider-horizontal .slider-track{height:10px;width:100%;margin-top:-5px;top:50%;left:0}.slider.slider-horizontal .slider-selection,.slider.slider-horizontal .slider-track-low,.slider.slider-horizontal .slider-track-high{height:100%;top:0;bottom:0}.slider.slider-horizontal .slider-tick,.slider.slider-horizontal .slider-handle{margin-left:-10px}.slider.slider-horizontal .slider-tick.triangle,.slider.slider-horizontal .slider-handle.triangle{position:relative;top:50%;-ms-transform:translateY(-50%);transform:translateY(-50%);border-width:0 10px 10px 10px;width:0;height:0;border-bottom-color:#2e6da4;margin-top:0}.slider.slider-horizontal .slider-tick-container{white-space:nowrap;position:absolute;top:0;left:0;width:100%}.slider.slider-horizontal .slider-tick-label-container{white-space:nowrap;margin-top:20px}.slider.slider-horizontal .slider-tick-label-container .slider-tick-label{padding-top:4px;display:inline-block;text-align:center}.slider.slider-horizontal .tooltip{-ms-transform:translateX(-50%);transform:translateX(-50%)}.slider.slider-horizontal.slider-rtl .slider-track{left:initial;right:0}.slider.slider-horizontal.slider-rtl .slider-tick,.slider.slider-horizontal.slider-rtl .slider-handle{margin-left:initial;margin-right:-10px}.slider.slider-horizontal.slider-rtl .slider-tick-container{left:initial;right:0}.slider.slider-horizontal.slider-rtl .tooltip{-ms-transform:translateX(50%);transform:translateX(50%)}.slider.slider-vertical{height:210px;width:20px}.slider.slider-vertical .slider-track{width:10px;height:100%;left:25%;top:0}.slider.slider-vertical .slider-selection{width:100%;left:0;top:0;bottom:0}.slider.slider-vertical .slider-track-low,.slider.slider-vertical .slider-track-high{width:100%;left:0;right:0}.slider.slider-vertical .slider-tick,.slider.slider-vertical .slider-handle{margin-top:-10px}.slider.slider-vertical .slider-tick.triangle,.slider.slider-vertical .slider-handle.triangle{border-width:10px 0 10px 10px;width:1px;height:1px;border-left-color:#2e6da4;border-right-color:#2e6da4;margin-left:0;margin-right:0}.slider.slider-vertical .slider-tick-label-container{white-space:nowrap}.slider.slider-vertical .slider-tick-label-container .slider-tick-label{padding-left:4px}.slider.slider-vertical .tooltip{-ms-transform:translateY(-50%);transform:translateY(-50%)}.slider.slider-vertical.slider-rtl .slider-track{left:initial;right:25%}.slider.slider-vertical.slider-rtl .slider-selection{left:initial;right:0}.slider.slider-vertical.slider-rtl .slider-tick.triangle,.slider.slider-vertical.slider-rtl .slider-handle.triangle{border-width:10px 10px 10px 0}.slider.slider-vertical.slider-rtl .slider-tick-label-container .slider-tick-label{padding-left:initial;padding-right:4px}.slider.slider-disabled .slider-handle{background-image:-webkit-linear-gradient(top,#dfdfdf 0,#bebebe 100%);background-image:-o-linear-gradient(top,#dfdfdf 0,#bebebe 100%);background-image:linear-gradient(to bottom,#dfdfdf 0,#bebebe 100%);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#ffdfdfdf',endColorstr='#ffbebebe',GradientType=0)}.slider.slider-disabled .slider-track{background-image:-webkit-linear-gradient(top,#e5e5e5 0,#e9e9e9 100%);background-image:-o-linear-gradient(top,#e5e5e5 0,#e9e9e9 100%);background-image:linear-gradient(to bottom,#e5e5e5 0,#e9e9e9 100%);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#ffe5e5e5',endColorstr='#ffe9e9e9',GradientType=0);cursor:not-allowed}.slider input{display:none}.slider .tooltip{pointer-events:none}.slider .tooltip.top{margin-top:-36px}.slider .tooltip-inner{white-space:nowrap;max-width:none}.slider .hide{display:none}.slider-track{position:absolute;cursor:pointer;background-image:-webkit-linear-gradient(top,#f5f5f5 0,#f9f9f9 100%);background-image:-o-linear-gradient(top,#f5f5f5 0,#f9f9f9 100%);background-image:linear-gradient(to bottom,#f5f5f5 0,#f9f9f9 100%);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#fff5f5f5',endColorstr='#fff9f9f9',GradientType=0);-webkit-box-shadow:inset 0 1px 2px rgba(0,0,0,0.1);box-shadow:inset 0 1px 2px rgba(0,0,0,0.1);border-radius:4px}.slider-selection{position:absolute;background-image:-webkit-linear-gradient(top,#f9f9f9 0,#f5f5f5 100%);background-image:-o-linear-gradient(top,#f9f9f9 0,#f5f5f5 100%);background-image:linear-gradient(to bottom,#f9f9f9 0,#f5f5f5 100%);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#fff9f9f9',endColorstr='#fff5f5f5',GradientType=0);-webkit-box-shadow:inset 0 -1px 0 rgba(0,0,0,0.15);box-shadow:inset 0 -1px 0 rgba(0,0,0,0.15);-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;border-radius:4px}.slider-selection.tick-slider-selection{background-image:-webkit-linear-gradient(top,#8ac1ef 0,#82b3de 100%);background-image:-o-linear-gradient(top,#8ac1ef 0,#82b3de 100%);background-image:linear-gradient(to bottom,#8ac1ef 0,#82b3de 100%);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#ff8ac1ef',endColorstr='#ff82b3de',GradientType=0)}.slider-track-low,.slider-track-high{position:absolute;background:transparent;-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;border-radius:4px}.slider-handle{position:absolute;top:0;width:20px;height:20px;background-color:#337ab7;background-image:-webkit-linear-gradient(top,#337ab7 0,#2e6da4 100%);background-image:-o-linear-gradient(top,#337ab7 0,#2e6da4 100%);background-image:linear-gradient(to bottom,#337ab7 0,#2e6da4 100%);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#ff337ab7',endColorstr='#ff2e6da4',GradientType=0);filter:none;-webkit-box-shadow:inset 0 1px 0 rgba(255,255,255,.2),0 1px 2px rgba(0,0,0,.05);box-shadow:inset 0 1px 0 rgba(255,255,255,.2),0 1px 2px rgba(0,0,0,.05);border:0 solid transparent}.slider-handle:hover{cursor:pointer}.slider-handle.round{border-radius:50%}.slider-handle.triangle{background:transparent none}.slider-handle.custom{background:transparent none}.slider-handle.custom::before{line-height:20px;font-size:20px;content:'\\\\2605';color:#726204}.slider-tick{position:absolute;cursor:pointer;width:20px;height:20px;background-image:-webkit-linear-gradient(top,#f9f9f9 0,#f5f5f5 100%);background-image:-o-linear-gradient(top,#f9f9f9 0,#f5f5f5 100%);background-image:linear-gradient(to bottom,#f9f9f9 0,#f5f5f5 100%);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#fff9f9f9',endColorstr='#fff5f5f5',GradientType=0);-webkit-box-shadow:inset 0 -1px 0 rgba(0,0,0,0.15);box-shadow:inset 0 -1px 0 rgba(0,0,0,0.15);-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;filter:none;opacity:.8;border:0 solid transparent}.slider-tick.round{border-radius:50%}.slider-tick.triangle{background:transparent none}.slider-tick.custom{background:transparent none}.slider-tick.custom::before{line-height:20px;font-size:20px;content:'\\\\2605';color:#726204}.slider-tick.in-selection{background-image:-webkit-linear-gradient(top,#8ac1ef 0,#82b3de 100%);background-image:-o-linear-gradient(top,#8ac1ef 0,#82b3de 100%);background-image:linear-gradient(to bottom,#8ac1ef 0,#82b3de 100%);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#ff8ac1ef',endColorstr='#ff82b3de',GradientType=0);opacity:1}\", \"\", {\"version\":3,\"sources\":[\"/Users/admin/Git/Public/spotrix/spotrix-frontend/node_modules/bootstrap-slider/dist/css/bootstrap-slider.min.css\"],\"names\":[],\"mappings\":\"AAAA;;4DAE4D;AAC5D;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;+DAqC+D,QAAQ,qBAAqB,sBAAsB,iBAAiB,CAAC,0BAA0B,YAAY,WAAW,CAAC,wCAAwC,YAAY,WAAW,gBAAgB,QAAQ,MAAM,CAAC,qIAAqI,YAAY,MAAM,QAAQ,CAAC,gFAAgF,iBAAiB,CAAC,kGAAkG,kBAAkB,QAAQ,+BAA+B,2BAA2B,8BAA8B,QAAQ,SAAS,4BAA4B,YAAY,CAAC,iDAAiD,mBAAmB,kBAAkB,MAAM,OAAO,UAAU,CAAC,uDAAuD,mBAAmB,eAAe,CAAC,0EAA0E,gBAAgB,qBAAqB,iBAAiB,CAAC,mCAAmC,+BAA+B,0BAA0B,CAAC,mDAAmD,aAAa,OAAO,CAAC,sGAAsG,oBAAoB,kBAAkB,CAAC,4DAA4D,aAAa,OAAO,CAAC,8CAA8C,8BAA8B,yBAAyB,CAAC,wBAAwB,aAAa,UAAU,CAAC,sCAAsC,WAAW,YAAY,SAAS,KAAK,CAAC,0CAA0C,WAAW,OAAO,MAAM,QAAQ,CAAC,qFAAqF,WAAW,OAAO,OAAO,CAAC,4EAA4E,gBAAgB,CAAC,8FAA8F,8BAA8B,UAAU,WAAW,0BAA0B,2BAA2B,cAAc,cAAc,CAAC,qDAAqD,kBAAkB,CAAC,wEAAwE,gBAAgB,CAAC,iCAAiC,+BAA+B,0BAA0B,CAAC,iDAAiD,aAAa,SAAS,CAAC,qDAAqD,aAAa,OAAO,CAAC,oHAAoH,6BAA6B,CAAC,mFAAmF,qBAAqB,iBAAiB,CAAC,uCAAuC,qEAAqE,gEAAgE,mEAAmE,2BAA2B,mHAAmH,CAAC,sCAAsC,qEAAqE,gEAAgE,mEAAmE,2BAA2B,oHAAoH,kBAAkB,CAAC,cAAc,YAAY,CAAC,iBAAiB,mBAAmB,CAAC,qBAAqB,gBAAgB,CAAC,uBAAuB,mBAAmB,cAAc,CAAC,cAAc,YAAY,CAAC,cAAc,kBAAkB,eAAe,qEAAqE,gEAAgE,mEAAmE,2BAA2B,oHAAoH,mDAAmD,2CAA2C,iBAAiB,CAAC,kBAAkB,kBAAkB,qEAAqE,gEAAgE,mEAAmE,2BAA2B,oHAAoH,mDAAmD,2CAA2C,8BAA8B,2BAA2B,sBAAsB,iBAAiB,CAAC,wCAAwC,qEAAqE,gEAAgE,mEAAmE,2BAA2B,mHAAmH,CAAC,qCAAqC,kBAAkB,uBAAuB,8BAA8B,2BAA2B,sBAAsB,iBAAiB,CAAC,eAAe,kBAAkB,MAAM,WAAW,YAAY,yBAAyB,qEAAqE,gEAAgE,mEAAmE,2BAA2B,oHAAoH,YAAY,gFAAgF,wEAAwE,0BAA0B,CAAC,qBAAqB,cAAc,CAAC,qBAAqB,iBAAiB,CAAC,wBAAwB,2BAA2B,CAAC,sBAAsB,2BAA2B,CAAC,8BAA8B,iBAAiB,eAAe,gBAAgB,aAAa,CAAC,aAAa,kBAAkB,eAAe,WAAW,YAAY,qEAAqE,gEAAgE,mEAAmE,2BAA2B,oHAAoH,mDAAmD,2CAA2C,8BAA8B,2BAA2B,sBAAsB,YAAY,WAAW,0BAA0B,CAAC,mBAAmB,iBAAiB,CAAC,sBAAsB,2BAA2B,CAAC,oBAAoB,2BAA2B,CAAC,4BAA4B,iBAAiB,eAAe,gBAAgB,aAAa,CAAC,0BAA0B,qEAAqE,gEAAgE,mEAAmE,2BAA2B,oHAAoH,SAAS,CAAC\",\"file\":\"bootstrap-slider.min.css\",\"sourcesContent\":[\"/*! =======================================================\\n                      VERSION  10.4.0              \\n========================================================= */\\n/*! =========================================================\\n * bootstrap-slider.js\\n *\\n * Maintainers:\\n *\\t\\tKyle Kemp\\n *\\t\\t\\t- Twitter: @seiyria\\n *\\t\\t\\t- Github:  seiyria\\n *\\t\\tRohit Kalkur\\n *\\t\\t\\t- Twitter: @Rovolutionary\\n *\\t\\t\\t- Github:  rovolution\\n *\\n * =========================================================\\n  *\\n * bootstrap-slider is released under the MIT License\\n * Copyright (c) 2017 Kyle Kemp, Rohit Kalkur, and contributors\\n * \\n * Permission is hereby granted, free of charge, to any person\\n * obtaining a copy of this software and associated documentation\\n * files (the \\\"Software\\\"), to deal in the Software without\\n * restriction, including without limitation the rights to use,\\n * copy, modify, merge, publish, distribute, sublicense, and/or sell\\n * copies of the Software, and to permit persons to whom the\\n * Software is furnished to do so, subject to the following\\n * conditions:\\n * \\n * The above copyright notice and this permission notice shall be\\n * included in all copies or substantial portions of the Software.\\n * \\n * THE SOFTWARE IS PROVIDED \\\"AS IS\\\", WITHOUT WARRANTY OF ANY KIND,\\n * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES\\n * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND\\n * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT\\n * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,\\n * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR\\n * OTHER DEALINGS IN THE SOFTWARE.\\n *\\n * ========================================================= */.slider{display:inline-block;vertical-align:middle;position:relative}.slider.slider-horizontal{width:210px;height:20px}.slider.slider-horizontal .slider-track{height:10px;width:100%;margin-top:-5px;top:50%;left:0}.slider.slider-horizontal .slider-selection,.slider.slider-horizontal .slider-track-low,.slider.slider-horizontal .slider-track-high{height:100%;top:0;bottom:0}.slider.slider-horizontal .slider-tick,.slider.slider-horizontal .slider-handle{margin-left:-10px}.slider.slider-horizontal .slider-tick.triangle,.slider.slider-horizontal .slider-handle.triangle{position:relative;top:50%;-ms-transform:translateY(-50%);transform:translateY(-50%);border-width:0 10px 10px 10px;width:0;height:0;border-bottom-color:#2e6da4;margin-top:0}.slider.slider-horizontal .slider-tick-container{white-space:nowrap;position:absolute;top:0;left:0;width:100%}.slider.slider-horizontal .slider-tick-label-container{white-space:nowrap;margin-top:20px}.slider.slider-horizontal .slider-tick-label-container .slider-tick-label{padding-top:4px;display:inline-block;text-align:center}.slider.slider-horizontal .tooltip{-ms-transform:translateX(-50%);transform:translateX(-50%)}.slider.slider-horizontal.slider-rtl .slider-track{left:initial;right:0}.slider.slider-horizontal.slider-rtl .slider-tick,.slider.slider-horizontal.slider-rtl .slider-handle{margin-left:initial;margin-right:-10px}.slider.slider-horizontal.slider-rtl .slider-tick-container{left:initial;right:0}.slider.slider-horizontal.slider-rtl .tooltip{-ms-transform:translateX(50%);transform:translateX(50%)}.slider.slider-vertical{height:210px;width:20px}.slider.slider-vertical .slider-track{width:10px;height:100%;left:25%;top:0}.slider.slider-vertical .slider-selection{width:100%;left:0;top:0;bottom:0}.slider.slider-vertical .slider-track-low,.slider.slider-vertical .slider-track-high{width:100%;left:0;right:0}.slider.slider-vertical .slider-tick,.slider.slider-vertical .slider-handle{margin-top:-10px}.slider.slider-vertical .slider-tick.triangle,.slider.slider-vertical .slider-handle.triangle{border-width:10px 0 10px 10px;width:1px;height:1px;border-left-color:#2e6da4;border-right-color:#2e6da4;margin-left:0;margin-right:0}.slider.slider-vertical .slider-tick-label-container{white-space:nowrap}.slider.slider-vertical .slider-tick-label-container .slider-tick-label{padding-left:4px}.slider.slider-vertical .tooltip{-ms-transform:translateY(-50%);transform:translateY(-50%)}.slider.slider-vertical.slider-rtl .slider-track{left:initial;right:25%}.slider.slider-vertical.slider-rtl .slider-selection{left:initial;right:0}.slider.slider-vertical.slider-rtl .slider-tick.triangle,.slider.slider-vertical.slider-rtl .slider-handle.triangle{border-width:10px 10px 10px 0}.slider.slider-vertical.slider-rtl .slider-tick-label-container .slider-tick-label{padding-left:initial;padding-right:4px}.slider.slider-disabled .slider-handle{background-image:-webkit-linear-gradient(top,#dfdfdf 0,#bebebe 100%);background-image:-o-linear-gradient(top,#dfdfdf 0,#bebebe 100%);background-image:linear-gradient(to bottom,#dfdfdf 0,#bebebe 100%);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#ffdfdfdf',endColorstr='#ffbebebe',GradientType=0)}.slider.slider-disabled .slider-track{background-image:-webkit-linear-gradient(top,#e5e5e5 0,#e9e9e9 100%);background-image:-o-linear-gradient(top,#e5e5e5 0,#e9e9e9 100%);background-image:linear-gradient(to bottom,#e5e5e5 0,#e9e9e9 100%);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#ffe5e5e5',endColorstr='#ffe9e9e9',GradientType=0);cursor:not-allowed}.slider input{display:none}.slider .tooltip{pointer-events:none}.slider .tooltip.top{margin-top:-36px}.slider .tooltip-inner{white-space:nowrap;max-width:none}.slider .hide{display:none}.slider-track{position:absolute;cursor:pointer;background-image:-webkit-linear-gradient(top,#f5f5f5 0,#f9f9f9 100%);background-image:-o-linear-gradient(top,#f5f5f5 0,#f9f9f9 100%);background-image:linear-gradient(to bottom,#f5f5f5 0,#f9f9f9 100%);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#fff5f5f5',endColorstr='#fff9f9f9',GradientType=0);-webkit-box-shadow:inset 0 1px 2px rgba(0,0,0,0.1);box-shadow:inset 0 1px 2px rgba(0,0,0,0.1);border-radius:4px}.slider-selection{position:absolute;background-image:-webkit-linear-gradient(top,#f9f9f9 0,#f5f5f5 100%);background-image:-o-linear-gradient(top,#f9f9f9 0,#f5f5f5 100%);background-image:linear-gradient(to bottom,#f9f9f9 0,#f5f5f5 100%);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#fff9f9f9',endColorstr='#fff5f5f5',GradientType=0);-webkit-box-shadow:inset 0 -1px 0 rgba(0,0,0,0.15);box-shadow:inset 0 -1px 0 rgba(0,0,0,0.15);-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;border-radius:4px}.slider-selection.tick-slider-selection{background-image:-webkit-linear-gradient(top,#8ac1ef 0,#82b3de 100%);background-image:-o-linear-gradient(top,#8ac1ef 0,#82b3de 100%);background-image:linear-gradient(to bottom,#8ac1ef 0,#82b3de 100%);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#ff8ac1ef',endColorstr='#ff82b3de',GradientType=0)}.slider-track-low,.slider-track-high{position:absolute;background:transparent;-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;border-radius:4px}.slider-handle{position:absolute;top:0;width:20px;height:20px;background-color:#337ab7;background-image:-webkit-linear-gradient(top,#337ab7 0,#2e6da4 100%);background-image:-o-linear-gradient(top,#337ab7 0,#2e6da4 100%);background-image:linear-gradient(to bottom,#337ab7 0,#2e6da4 100%);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#ff337ab7',endColorstr='#ff2e6da4',GradientType=0);filter:none;-webkit-box-shadow:inset 0 1px 0 rgba(255,255,255,.2),0 1px 2px rgba(0,0,0,.05);box-shadow:inset 0 1px 0 rgba(255,255,255,.2),0 1px 2px rgba(0,0,0,.05);border:0 solid transparent}.slider-handle:hover{cursor:pointer}.slider-handle.round{border-radius:50%}.slider-handle.triangle{background:transparent none}.slider-handle.custom{background:transparent none}.slider-handle.custom::before{line-height:20px;font-size:20px;content:'\\\\2605';color:#726204}.slider-tick{position:absolute;cursor:pointer;width:20px;height:20px;background-image:-webkit-linear-gradient(top,#f9f9f9 0,#f5f5f5 100%);background-image:-o-linear-gradient(top,#f9f9f9 0,#f5f5f5 100%);background-image:linear-gradient(to bottom,#f9f9f9 0,#f5f5f5 100%);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#fff9f9f9',endColorstr='#fff5f5f5',GradientType=0);-webkit-box-shadow:inset 0 -1px 0 rgba(0,0,0,0.15);box-shadow:inset 0 -1px 0 rgba(0,0,0,0.15);-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;filter:none;opacity:.8;border:0 solid transparent}.slider-tick.round{border-radius:50%}.slider-tick.triangle{background:transparent none}.slider-tick.custom{background:transparent none}.slider-tick.custom::before{line-height:20px;font-size:20px;content:'\\\\2605';color:#726204}.slider-tick.in-selection{background-image:-webkit-linear-gradient(top,#8ac1ef 0,#82b3de 100%);background-image:-o-linear-gradient(top,#8ac1ef 0,#82b3de 100%);background-image:linear-gradient(to bottom,#8ac1ef 0,#82b3de 100%);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#ff8ac1ef',endColorstr='#ff82b3de',GradientType=0);opacity:1}\"],\"sourceRoot\":\"\"}]);\n\n// exports\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/css-loader/index.js?!./node_modules/bootstrap-slider/dist/css/bootstrap-slider.min.css\n");

/***/ }),

/***/ "./node_modules/d3-hexbin/index.js":
/*!*****************************************!*\
  !*** ./node_modules/d3-hexbin/index.js ***!
  \*****************************************/
/*! exports provided: hexbin */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _src_hexbin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./src/hexbin */ \"./node_modules/d3-hexbin/src/hexbin.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"hexbin\", function() { return _src_hexbin__WEBPACK_IMPORTED_MODULE_0__[\"default\"]; });\n\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZDMtaGV4YmluL2luZGV4LmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2QzLWhleGJpbi9pbmRleC5qcz8zNzIzIl0sInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCB7ZGVmYXVsdCBhcyBoZXhiaW59IGZyb20gXCIuL3NyYy9oZXhiaW5cIjtcbiJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTsiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/d3-hexbin/index.js\n");

/***/ }),

/***/ "./node_modules/d3-hexbin/src/hexbin.js":
/*!**********************************************!*\
  !*** ./node_modules/d3-hexbin/src/hexbin.js ***!
  \**********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nvar thirdPi = Math.PI / 3,\n    angles = [0, thirdPi, 2 * thirdPi, 3 * thirdPi, 4 * thirdPi, 5 * thirdPi];\n\nfunction pointX(d) {\n  return d[0];\n}\n\nfunction pointY(d) {\n  return d[1];\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function() {\n  var x0 = 0,\n      y0 = 0,\n      x1 = 1,\n      y1 = 1,\n      x = pointX,\n      y = pointY,\n      r,\n      dx,\n      dy;\n\n  function hexbin(points) {\n    var binsById = {}, bins = [], i, n = points.length;\n\n    for (i = 0; i < n; ++i) {\n      if (isNaN(px = +x.call(null, point = points[i], i, points))\n          || isNaN(py = +y.call(null, point, i, points))) continue;\n\n      var point,\n          px,\n          py,\n          pj = Math.round(py = py / dy),\n          pi = Math.round(px = px / dx - (pj & 1) / 2),\n          py1 = py - pj;\n\n      if (Math.abs(py1) * 3 > 1) {\n        var px1 = px - pi,\n            pi2 = pi + (px < pi ? -1 : 1) / 2,\n            pj2 = pj + (py < pj ? -1 : 1),\n            px2 = px - pi2,\n            py2 = py - pj2;\n        if (px1 * px1 + py1 * py1 > px2 * px2 + py2 * py2) pi = pi2 + (pj & 1 ? 1 : -1) / 2, pj = pj2;\n      }\n\n      var id = pi + \"-\" + pj, bin = binsById[id];\n      if (bin) bin.push(point);\n      else {\n        bins.push(bin = binsById[id] = [point]);\n        bin.x = (pi + (pj & 1) / 2) * dx;\n        bin.y = pj * dy;\n      }\n    }\n\n    return bins;\n  }\n\n  function hexagon(radius) {\n    var x0 = 0, y0 = 0;\n    return angles.map(function(angle) {\n      var x1 = Math.sin(angle) * radius,\n          y1 = -Math.cos(angle) * radius,\n          dx = x1 - x0,\n          dy = y1 - y0;\n      x0 = x1, y0 = y1;\n      return [dx, dy];\n    });\n  }\n\n  hexbin.hexagon = function(radius) {\n    return \"m\" + hexagon(radius == null ? r : +radius).join(\"l\") + \"z\";\n  };\n\n  hexbin.centers = function() {\n    var centers = [],\n        j = Math.round(y0 / dy),\n        i = Math.round(x0 / dx);\n    for (var y = j * dy; y < y1 + r; y += dy, ++j) {\n      for (var x = i * dx + (j & 1) * dx / 2; x < x1 + dx / 2; x += dx) {\n        centers.push([x, y]);\n      }\n    }\n    return centers;\n  };\n\n  hexbin.mesh = function() {\n    var fragment = hexagon(r).slice(0, 4).join(\"l\");\n    return hexbin.centers().map(function(p) { return \"M\" + p + \"m\" + fragment; }).join(\"\");\n  };\n\n  hexbin.x = function(_) {\n    return arguments.length ? (x = _, hexbin) : x;\n  };\n\n  hexbin.y = function(_) {\n    return arguments.length ? (y = _, hexbin) : y;\n  };\n\n  hexbin.radius = function(_) {\n    return arguments.length ? (r = +_, dx = r * 2 * Math.sin(thirdPi), dy = r * 1.5, hexbin) : r;\n  };\n\n  hexbin.size = function(_) {\n    return arguments.length ? (x0 = y0 = 0, x1 = +_[0], y1 = +_[1], hexbin) : [x1 - x0, y1 - y0];\n  };\n\n  hexbin.extent = function(_) {\n    return arguments.length ? (x0 = +_[0][0], y0 = +_[0][1], x1 = +_[1][0], y1 = +_[1][1], hexbin) : [[x0, y0], [x1, y1]];\n  };\n\n  return hexbin.radius(1);\n});\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/d3-hexbin/src/hexbin.js\n");

/***/ }),

/***/ "./node_modules/mousetrap/mousetrap.js":
/*!*********************************************!*\
  !*** ./node_modules/mousetrap/mousetrap.js ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("var __WEBPACK_AMD_DEFINE_RESULT__;/*global define:false */\n/**\n * Copyright 2012-2017 Craig Campbell\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * Mousetrap is a simple keyboard shortcut library for Javascript with\n * no external dependencies\n *\n * @version 1.6.2\n * @url craig.is/killing/mice\n */\n(function(window, document, undefined) {\n\n    // Check if mousetrap is used inside browser, if not, return\n    if (!window) {\n        return;\n    }\n\n    /**\n     * mapping of special keycodes to their corresponding keys\n     *\n     * everything in this dictionary cannot use keypress events\n     * so it has to be here to map to the correct keycodes for\n     * keyup/keydown events\n     *\n     * @type {Object}\n     */\n    var _MAP = {\n        8: 'backspace',\n        9: 'tab',\n        13: 'enter',\n        16: 'shift',\n        17: 'ctrl',\n        18: 'alt',\n        20: 'capslock',\n        27: 'esc',\n        32: 'space',\n        33: 'pageup',\n        34: 'pagedown',\n        35: 'end',\n        36: 'home',\n        37: 'left',\n        38: 'up',\n        39: 'right',\n        40: 'down',\n        45: 'ins',\n        46: 'del',\n        91: 'meta',\n        93: 'meta',\n        224: 'meta'\n    };\n\n    /**\n     * mapping for special characters so they can support\n     *\n     * this dictionary is only used incase you want to bind a\n     * keyup or keydown event to one of these keys\n     *\n     * @type {Object}\n     */\n    var _KEYCODE_MAP = {\n        106: '*',\n        107: '+',\n        109: '-',\n        110: '.',\n        111 : '/',\n        186: ';',\n        187: '=',\n        188: ',',\n        189: '-',\n        190: '.',\n        191: '/',\n        192: '`',\n        219: '[',\n        220: '\\\\',\n        221: ']',\n        222: '\\''\n    };\n\n    /**\n     * this is a mapping of keys that require shift on a US keypad\n     * back to the non shift equivelents\n     *\n     * this is so you can use keyup events with these keys\n     *\n     * note that this will only work reliably on US keyboards\n     *\n     * @type {Object}\n     */\n    var _SHIFT_MAP = {\n        '~': '`',\n        '!': '1',\n        '@': '2',\n        '#': '3',\n        '$': '4',\n        '%': '5',\n        '^': '6',\n        '&': '7',\n        '*': '8',\n        '(': '9',\n        ')': '0',\n        '_': '-',\n        '+': '=',\n        ':': ';',\n        '\\\"': '\\'',\n        '<': ',',\n        '>': '.',\n        '?': '/',\n        '|': '\\\\'\n    };\n\n    /**\n     * this is a list of special strings you can use to map\n     * to modifier keys when you specify your keyboard shortcuts\n     *\n     * @type {Object}\n     */\n    var _SPECIAL_ALIASES = {\n        'option': 'alt',\n        'command': 'meta',\n        'return': 'enter',\n        'escape': 'esc',\n        'plus': '+',\n        'mod': /Mac|iPod|iPhone|iPad/.test(navigator.platform) ? 'meta' : 'ctrl'\n    };\n\n    /**\n     * variable to store the flipped version of _MAP from above\n     * needed to check if we should use keypress or not when no action\n     * is specified\n     *\n     * @type {Object|undefined}\n     */\n    var _REVERSE_MAP;\n\n    /**\n     * loop through the f keys, f1 to f19 and add them to the map\n     * programatically\n     */\n    for (var i = 1; i < 20; ++i) {\n        _MAP[111 + i] = 'f' + i;\n    }\n\n    /**\n     * loop through to map numbers on the numeric keypad\n     */\n    for (i = 0; i <= 9; ++i) {\n\n        // This needs to use a string cause otherwise since 0 is falsey\n        // mousetrap will never fire for numpad 0 pressed as part of a keydown\n        // event.\n        //\n        // @see https://github.com/ccampbell/mousetrap/pull/258\n        _MAP[i + 96] = i.toString();\n    }\n\n    /**\n     * cross browser add event method\n     *\n     * @param {Element|HTMLDocument} object\n     * @param {string} type\n     * @param {Function} callback\n     * @returns void\n     */\n    function _addEvent(object, type, callback) {\n        if (object.addEventListener) {\n            object.addEventListener(type, callback, false);\n            return;\n        }\n\n        object.attachEvent('on' + type, callback);\n    }\n\n    /**\n     * takes the event and returns the key character\n     *\n     * @param {Event} e\n     * @return {string}\n     */\n    function _characterFromEvent(e) {\n\n        // for keypress events we should return the character as is\n        if (e.type == 'keypress') {\n            var character = String.fromCharCode(e.which);\n\n            // if the shift key is not pressed then it is safe to assume\n            // that we want the character to be lowercase.  this means if\n            // you accidentally have caps lock on then your key bindings\n            // will continue to work\n            //\n            // the only side effect that might not be desired is if you\n            // bind something like 'A' cause you want to trigger an\n            // event when capital A is pressed caps lock will no longer\n            // trigger the event.  shift+a will though.\n            if (!e.shiftKey) {\n                character = character.toLowerCase();\n            }\n\n            return character;\n        }\n\n        // for non keypress events the special maps are needed\n        if (_MAP[e.which]) {\n            return _MAP[e.which];\n        }\n\n        if (_KEYCODE_MAP[e.which]) {\n            return _KEYCODE_MAP[e.which];\n        }\n\n        // if it is not in the special map\n\n        // with keydown and keyup events the character seems to always\n        // come in as an uppercase character whether you are pressing shift\n        // or not.  we should make sure it is always lowercase for comparisons\n        return String.fromCharCode(e.which).toLowerCase();\n    }\n\n    /**\n     * checks if two arrays are equal\n     *\n     * @param {Array} modifiers1\n     * @param {Array} modifiers2\n     * @returns {boolean}\n     */\n    function _modifiersMatch(modifiers1, modifiers2) {\n        return modifiers1.sort().join(',') === modifiers2.sort().join(',');\n    }\n\n    /**\n     * takes a key event and figures out what the modifiers are\n     *\n     * @param {Event} e\n     * @returns {Array}\n     */\n    function _eventModifiers(e) {\n        var modifiers = [];\n\n        if (e.shiftKey) {\n            modifiers.push('shift');\n        }\n\n        if (e.altKey) {\n            modifiers.push('alt');\n        }\n\n        if (e.ctrlKey) {\n            modifiers.push('ctrl');\n        }\n\n        if (e.metaKey) {\n            modifiers.push('meta');\n        }\n\n        return modifiers;\n    }\n\n    /**\n     * prevents default for this event\n     *\n     * @param {Event} e\n     * @returns void\n     */\n    function _preventDefault(e) {\n        if (e.preventDefault) {\n            e.preventDefault();\n            return;\n        }\n\n        e.returnValue = false;\n    }\n\n    /**\n     * stops propogation for this event\n     *\n     * @param {Event} e\n     * @returns void\n     */\n    function _stopPropagation(e) {\n        if (e.stopPropagation) {\n            e.stopPropagation();\n            return;\n        }\n\n        e.cancelBubble = true;\n    }\n\n    /**\n     * determines if the keycode specified is a modifier key or not\n     *\n     * @param {string} key\n     * @returns {boolean}\n     */\n    function _isModifier(key) {\n        return key == 'shift' || key == 'ctrl' || key == 'alt' || key == 'meta';\n    }\n\n    /**\n     * reverses the map lookup so that we can look for specific keys\n     * to see what can and can't use keypress\n     *\n     * @return {Object}\n     */\n    function _getReverseMap() {\n        if (!_REVERSE_MAP) {\n            _REVERSE_MAP = {};\n            for (var key in _MAP) {\n\n                // pull out the numeric keypad from here cause keypress should\n                // be able to detect the keys from the character\n                if (key > 95 && key < 112) {\n                    continue;\n                }\n\n                if (_MAP.hasOwnProperty(key)) {\n                    _REVERSE_MAP[_MAP[key]] = key;\n                }\n            }\n        }\n        return _REVERSE_MAP;\n    }\n\n    /**\n     * picks the best action based on the key combination\n     *\n     * @param {string} key - character for key\n     * @param {Array} modifiers\n     * @param {string=} action passed in\n     */\n    function _pickBestAction(key, modifiers, action) {\n\n        // if no action was picked in we should try to pick the one\n        // that we think would work best for this key\n        if (!action) {\n            action = _getReverseMap()[key] ? 'keydown' : 'keypress';\n        }\n\n        // modifier keys don't work as expected with keypress,\n        // switch to keydown\n        if (action == 'keypress' && modifiers.length) {\n            action = 'keydown';\n        }\n\n        return action;\n    }\n\n    /**\n     * Converts from a string key combination to an array\n     *\n     * @param  {string} combination like \"command+shift+l\"\n     * @return {Array}\n     */\n    function _keysFromString(combination) {\n        if (combination === '+') {\n            return ['+'];\n        }\n\n        combination = combination.replace(/\\+{2}/g, '+plus');\n        return combination.split('+');\n    }\n\n    /**\n     * Gets info for a specific key combination\n     *\n     * @param  {string} combination key combination (\"command+s\" or \"a\" or \"*\")\n     * @param  {string=} action\n     * @returns {Object}\n     */\n    function _getKeyInfo(combination, action) {\n        var keys;\n        var key;\n        var i;\n        var modifiers = [];\n\n        // take the keys from this pattern and figure out what the actual\n        // pattern is all about\n        keys = _keysFromString(combination);\n\n        for (i = 0; i < keys.length; ++i) {\n            key = keys[i];\n\n            // normalize key names\n            if (_SPECIAL_ALIASES[key]) {\n                key = _SPECIAL_ALIASES[key];\n            }\n\n            // if this is not a keypress event then we should\n            // be smart about using shift keys\n            // this will only work for US keyboards however\n            if (action && action != 'keypress' && _SHIFT_MAP[key]) {\n                key = _SHIFT_MAP[key];\n                modifiers.push('shift');\n            }\n\n            // if this key is a modifier then add it to the list of modifiers\n            if (_isModifier(key)) {\n                modifiers.push(key);\n            }\n        }\n\n        // depending on what the key combination is\n        // we will try to pick the best event for it\n        action = _pickBestAction(key, modifiers, action);\n\n        return {\n            key: key,\n            modifiers: modifiers,\n            action: action\n        };\n    }\n\n    function _belongsTo(element, ancestor) {\n        if (element === null || element === document) {\n            return false;\n        }\n\n        if (element === ancestor) {\n            return true;\n        }\n\n        return _belongsTo(element.parentNode, ancestor);\n    }\n\n    function Mousetrap(targetElement) {\n        var self = this;\n\n        targetElement = targetElement || document;\n\n        if (!(self instanceof Mousetrap)) {\n            return new Mousetrap(targetElement);\n        }\n\n        /**\n         * element to attach key events to\n         *\n         * @type {Element}\n         */\n        self.target = targetElement;\n\n        /**\n         * a list of all the callbacks setup via Mousetrap.bind()\n         *\n         * @type {Object}\n         */\n        self._callbacks = {};\n\n        /**\n         * direct map of string combinations to callbacks used for trigger()\n         *\n         * @type {Object}\n         */\n        self._directMap = {};\n\n        /**\n         * keeps track of what level each sequence is at since multiple\n         * sequences can start out with the same sequence\n         *\n         * @type {Object}\n         */\n        var _sequenceLevels = {};\n\n        /**\n         * variable to store the setTimeout call\n         *\n         * @type {null|number}\n         */\n        var _resetTimer;\n\n        /**\n         * temporary state where we will ignore the next keyup\n         *\n         * @type {boolean|string}\n         */\n        var _ignoreNextKeyup = false;\n\n        /**\n         * temporary state where we will ignore the next keypress\n         *\n         * @type {boolean}\n         */\n        var _ignoreNextKeypress = false;\n\n        /**\n         * are we currently inside of a sequence?\n         * type of action (\"keyup\" or \"keydown\" or \"keypress\") or false\n         *\n         * @type {boolean|string}\n         */\n        var _nextExpectedAction = false;\n\n        /**\n         * resets all sequence counters except for the ones passed in\n         *\n         * @param {Object} doNotReset\n         * @returns void\n         */\n        function _resetSequences(doNotReset) {\n            doNotReset = doNotReset || {};\n\n            var activeSequences = false,\n                key;\n\n            for (key in _sequenceLevels) {\n                if (doNotReset[key]) {\n                    activeSequences = true;\n                    continue;\n                }\n                _sequenceLevels[key] = 0;\n            }\n\n            if (!activeSequences) {\n                _nextExpectedAction = false;\n            }\n        }\n\n        /**\n         * finds all callbacks that match based on the keycode, modifiers,\n         * and action\n         *\n         * @param {string} character\n         * @param {Array} modifiers\n         * @param {Event|Object} e\n         * @param {string=} sequenceName - name of the sequence we are looking for\n         * @param {string=} combination\n         * @param {number=} level\n         * @returns {Array}\n         */\n        function _getMatches(character, modifiers, e, sequenceName, combination, level) {\n            var i;\n            var callback;\n            var matches = [];\n            var action = e.type;\n\n            // if there are no events related to this keycode\n            if (!self._callbacks[character]) {\n                return [];\n            }\n\n            // if a modifier key is coming up on its own we should allow it\n            if (action == 'keyup' && _isModifier(character)) {\n                modifiers = [character];\n            }\n\n            // loop through all callbacks for the key that was pressed\n            // and see if any of them match\n            for (i = 0; i < self._callbacks[character].length; ++i) {\n                callback = self._callbacks[character][i];\n\n                // if a sequence name is not specified, but this is a sequence at\n                // the wrong level then move onto the next match\n                if (!sequenceName && callback.seq && _sequenceLevels[callback.seq] != callback.level) {\n                    continue;\n                }\n\n                // if the action we are looking for doesn't match the action we got\n                // then we should keep going\n                if (action != callback.action) {\n                    continue;\n                }\n\n                // if this is a keypress event and the meta key and control key\n                // are not pressed that means that we need to only look at the\n                // character, otherwise check the modifiers as well\n                //\n                // chrome will not fire a keypress if meta or control is down\n                // safari will fire a keypress if meta or meta+shift is down\n                // firefox will fire a keypress if meta or control is down\n                if ((action == 'keypress' && !e.metaKey && !e.ctrlKey) || _modifiersMatch(modifiers, callback.modifiers)) {\n\n                    // when you bind a combination or sequence a second time it\n                    // should overwrite the first one.  if a sequenceName or\n                    // combination is specified in this call it does just that\n                    //\n                    // @todo make deleting its own method?\n                    var deleteCombo = !sequenceName && callback.combo == combination;\n                    var deleteSequence = sequenceName && callback.seq == sequenceName && callback.level == level;\n                    if (deleteCombo || deleteSequence) {\n                        self._callbacks[character].splice(i, 1);\n                    }\n\n                    matches.push(callback);\n                }\n            }\n\n            return matches;\n        }\n\n        /**\n         * actually calls the callback function\n         *\n         * if your callback function returns false this will use the jquery\n         * convention - prevent default and stop propogation on the event\n         *\n         * @param {Function} callback\n         * @param {Event} e\n         * @returns void\n         */\n        function _fireCallback(callback, e, combo, sequence) {\n\n            // if this event should not happen stop here\n            if (self.stopCallback(e, e.target || e.srcElement, combo, sequence)) {\n                return;\n            }\n\n            if (callback(e, combo) === false) {\n                _preventDefault(e);\n                _stopPropagation(e);\n            }\n        }\n\n        /**\n         * handles a character key event\n         *\n         * @param {string} character\n         * @param {Array} modifiers\n         * @param {Event} e\n         * @returns void\n         */\n        self._handleKey = function(character, modifiers, e) {\n            var callbacks = _getMatches(character, modifiers, e);\n            var i;\n            var doNotReset = {};\n            var maxLevel = 0;\n            var processedSequenceCallback = false;\n\n            // Calculate the maxLevel for sequences so we can only execute the longest callback sequence\n            for (i = 0; i < callbacks.length; ++i) {\n                if (callbacks[i].seq) {\n                    maxLevel = Math.max(maxLevel, callbacks[i].level);\n                }\n            }\n\n            // loop through matching callbacks for this key event\n            for (i = 0; i < callbacks.length; ++i) {\n\n                // fire for all sequence callbacks\n                // this is because if for example you have multiple sequences\n                // bound such as \"g i\" and \"g t\" they both need to fire the\n                // callback for matching g cause otherwise you can only ever\n                // match the first one\n                if (callbacks[i].seq) {\n\n                    // only fire callbacks for the maxLevel to prevent\n                    // subsequences from also firing\n                    //\n                    // for example 'a option b' should not cause 'option b' to fire\n                    // even though 'option b' is part of the other sequence\n                    //\n                    // any sequences that do not match here will be discarded\n                    // below by the _resetSequences call\n                    if (callbacks[i].level != maxLevel) {\n                        continue;\n                    }\n\n                    processedSequenceCallback = true;\n\n                    // keep a list of which sequences were matches for later\n                    doNotReset[callbacks[i].seq] = 1;\n                    _fireCallback(callbacks[i].callback, e, callbacks[i].combo, callbacks[i].seq);\n                    continue;\n                }\n\n                // if there were no sequence matches but we are still here\n                // that means this is a regular match so we should fire that\n                if (!processedSequenceCallback) {\n                    _fireCallback(callbacks[i].callback, e, callbacks[i].combo);\n                }\n            }\n\n            // if the key you pressed matches the type of sequence without\n            // being a modifier (ie \"keyup\" or \"keypress\") then we should\n            // reset all sequences that were not matched by this event\n            //\n            // this is so, for example, if you have the sequence \"h a t\" and you\n            // type \"h e a r t\" it does not match.  in this case the \"e\" will\n            // cause the sequence to reset\n            //\n            // modifier keys are ignored because you can have a sequence\n            // that contains modifiers such as \"enter ctrl+space\" and in most\n            // cases the modifier key will be pressed before the next key\n            //\n            // also if you have a sequence such as \"ctrl+b a\" then pressing the\n            // \"b\" key will trigger a \"keypress\" and a \"keydown\"\n            //\n            // the \"keydown\" is expected when there is a modifier, but the\n            // \"keypress\" ends up matching the _nextExpectedAction since it occurs\n            // after and that causes the sequence to reset\n            //\n            // we ignore keypresses in a sequence that directly follow a keydown\n            // for the same character\n            var ignoreThisKeypress = e.type == 'keypress' && _ignoreNextKeypress;\n            if (e.type == _nextExpectedAction && !_isModifier(character) && !ignoreThisKeypress) {\n                _resetSequences(doNotReset);\n            }\n\n            _ignoreNextKeypress = processedSequenceCallback && e.type == 'keydown';\n        };\n\n        /**\n         * handles a keydown event\n         *\n         * @param {Event} e\n         * @returns void\n         */\n        function _handleKeyEvent(e) {\n\n            // normalize e.which for key events\n            // @see http://stackoverflow.com/questions/4285627/javascript-keycode-vs-charcode-utter-confusion\n            if (typeof e.which !== 'number') {\n                e.which = e.keyCode;\n            }\n\n            var character = _characterFromEvent(e);\n\n            // no character found then stop\n            if (!character) {\n                return;\n            }\n\n            // need to use === for the character check because the character can be 0\n            if (e.type == 'keyup' && _ignoreNextKeyup === character) {\n                _ignoreNextKeyup = false;\n                return;\n            }\n\n            self.handleKey(character, _eventModifiers(e), e);\n        }\n\n        /**\n         * called to set a 1 second timeout on the specified sequence\n         *\n         * this is so after each key press in the sequence you have 1 second\n         * to press the next key before you have to start over\n         *\n         * @returns void\n         */\n        function _resetSequenceTimer() {\n            clearTimeout(_resetTimer);\n            _resetTimer = setTimeout(_resetSequences, 1000);\n        }\n\n        /**\n         * binds a key sequence to an event\n         *\n         * @param {string} combo - combo specified in bind call\n         * @param {Array} keys\n         * @param {Function} callback\n         * @param {string=} action\n         * @returns void\n         */\n        function _bindSequence(combo, keys, callback, action) {\n\n            // start off by adding a sequence level record for this combination\n            // and setting the level to 0\n            _sequenceLevels[combo] = 0;\n\n            /**\n             * callback to increase the sequence level for this sequence and reset\n             * all other sequences that were active\n             *\n             * @param {string} nextAction\n             * @returns {Function}\n             */\n            function _increaseSequence(nextAction) {\n                return function() {\n                    _nextExpectedAction = nextAction;\n                    ++_sequenceLevels[combo];\n                    _resetSequenceTimer();\n                };\n            }\n\n            /**\n             * wraps the specified callback inside of another function in order\n             * to reset all sequence counters as soon as this sequence is done\n             *\n             * @param {Event} e\n             * @returns void\n             */\n            function _callbackAndReset(e) {\n                _fireCallback(callback, e, combo);\n\n                // we should ignore the next key up if the action is key down\n                // or keypress.  this is so if you finish a sequence and\n                // release the key the final key will not trigger a keyup\n                if (action !== 'keyup') {\n                    _ignoreNextKeyup = _characterFromEvent(e);\n                }\n\n                // weird race condition if a sequence ends with the key\n                // another sequence begins with\n                setTimeout(_resetSequences, 10);\n            }\n\n            // loop through keys one at a time and bind the appropriate callback\n            // function.  for any key leading up to the final one it should\n            // increase the sequence. after the final, it should reset all sequences\n            //\n            // if an action is specified in the original bind call then that will\n            // be used throughout.  otherwise we will pass the action that the\n            // next key in the sequence should match.  this allows a sequence\n            // to mix and match keypress and keydown events depending on which\n            // ones are better suited to the key provided\n            for (var i = 0; i < keys.length; ++i) {\n                var isFinal = i + 1 === keys.length;\n                var wrappedCallback = isFinal ? _callbackAndReset : _increaseSequence(action || _getKeyInfo(keys[i + 1]).action);\n                _bindSingle(keys[i], wrappedCallback, action, combo, i);\n            }\n        }\n\n        /**\n         * binds a single keyboard combination\n         *\n         * @param {string} combination\n         * @param {Function} callback\n         * @param {string=} action\n         * @param {string=} sequenceName - name of sequence if part of sequence\n         * @param {number=} level - what part of the sequence the command is\n         * @returns void\n         */\n        function _bindSingle(combination, callback, action, sequenceName, level) {\n\n            // store a direct mapped reference for use with Mousetrap.trigger\n            self._directMap[combination + ':' + action] = callback;\n\n            // make sure multiple spaces in a row become a single space\n            combination = combination.replace(/\\s+/g, ' ');\n\n            var sequence = combination.split(' ');\n            var info;\n\n            // if this pattern is a sequence of keys then run through this method\n            // to reprocess each pattern one key at a time\n            if (sequence.length > 1) {\n                _bindSequence(combination, sequence, callback, action);\n                return;\n            }\n\n            info = _getKeyInfo(combination, action);\n\n            // make sure to initialize array if this is the first time\n            // a callback is added for this key\n            self._callbacks[info.key] = self._callbacks[info.key] || [];\n\n            // remove an existing match if there is one\n            _getMatches(info.key, info.modifiers, {type: info.action}, sequenceName, combination, level);\n\n            // add this call back to the array\n            // if it is a sequence put it at the beginning\n            // if not put it at the end\n            //\n            // this is important because the way these are processed expects\n            // the sequence ones to come first\n            self._callbacks[info.key][sequenceName ? 'unshift' : 'push']({\n                callback: callback,\n                modifiers: info.modifiers,\n                action: info.action,\n                seq: sequenceName,\n                level: level,\n                combo: combination\n            });\n        }\n\n        /**\n         * binds multiple combinations to the same callback\n         *\n         * @param {Array} combinations\n         * @param {Function} callback\n         * @param {string|undefined} action\n         * @returns void\n         */\n        self._bindMultiple = function(combinations, callback, action) {\n            for (var i = 0; i < combinations.length; ++i) {\n                _bindSingle(combinations[i], callback, action);\n            }\n        };\n\n        // start!\n        _addEvent(targetElement, 'keypress', _handleKeyEvent);\n        _addEvent(targetElement, 'keydown', _handleKeyEvent);\n        _addEvent(targetElement, 'keyup', _handleKeyEvent);\n    }\n\n    /**\n     * binds an event to mousetrap\n     *\n     * can be a single key, a combination of keys separated with +,\n     * an array of keys, or a sequence of keys separated by spaces\n     *\n     * be sure to list the modifier keys first to make sure that the\n     * correct key ends up getting bound (the last key in the pattern)\n     *\n     * @param {string|Array} keys\n     * @param {Function} callback\n     * @param {string=} action - 'keypress', 'keydown', or 'keyup'\n     * @returns void\n     */\n    Mousetrap.prototype.bind = function(keys, callback, action) {\n        var self = this;\n        keys = keys instanceof Array ? keys : [keys];\n        self._bindMultiple.call(self, keys, callback, action);\n        return self;\n    };\n\n    /**\n     * unbinds an event to mousetrap\n     *\n     * the unbinding sets the callback function of the specified key combo\n     * to an empty function and deletes the corresponding key in the\n     * _directMap dict.\n     *\n     * TODO: actually remove this from the _callbacks dictionary instead\n     * of binding an empty function\n     *\n     * the keycombo+action has to be exactly the same as\n     * it was defined in the bind method\n     *\n     * @param {string|Array} keys\n     * @param {string} action\n     * @returns void\n     */\n    Mousetrap.prototype.unbind = function(keys, action) {\n        var self = this;\n        return self.bind.call(self, keys, function() {}, action);\n    };\n\n    /**\n     * triggers an event that has already been bound\n     *\n     * @param {string} keys\n     * @param {string=} action\n     * @returns void\n     */\n    Mousetrap.prototype.trigger = function(keys, action) {\n        var self = this;\n        if (self._directMap[keys + ':' + action]) {\n            self._directMap[keys + ':' + action]({}, keys);\n        }\n        return self;\n    };\n\n    /**\n     * resets the library back to its initial state.  this is useful\n     * if you want to clear out the current keyboard shortcuts and bind\n     * new ones - for example if you switch to another page\n     *\n     * @returns void\n     */\n    Mousetrap.prototype.reset = function() {\n        var self = this;\n        self._callbacks = {};\n        self._directMap = {};\n        return self;\n    };\n\n    /**\n     * should we stop this event before firing off callbacks\n     *\n     * @param {Event} e\n     * @param {Element} element\n     * @return {boolean}\n     */\n    Mousetrap.prototype.stopCallback = function(e, element) {\n        var self = this;\n\n        // if the element has the class \"mousetrap\" then no need to stop\n        if ((' ' + element.className + ' ').indexOf(' mousetrap ') > -1) {\n            return false;\n        }\n\n        if (_belongsTo(element, self.target)) {\n            return false;\n        }\n\n        // stop for input, select, and textarea\n        return element.tagName == 'INPUT' || element.tagName == 'SELECT' || element.tagName == 'TEXTAREA' || element.isContentEditable;\n    };\n\n    /**\n     * exposes _handleKey publicly so it can be overwritten by extensions\n     */\n    Mousetrap.prototype.handleKey = function() {\n        var self = this;\n        return self._handleKey.apply(self, arguments);\n    };\n\n    /**\n     * allow custom key mappings\n     */\n    Mousetrap.addKeycodes = function(object) {\n        for (var key in object) {\n            if (object.hasOwnProperty(key)) {\n                _MAP[key] = object[key];\n            }\n        }\n        _REVERSE_MAP = null;\n    };\n\n    /**\n     * Init the global mousetrap functions\n     *\n     * This method is needed to allow the global mousetrap functions to work\n     * now that mousetrap is a constructor function.\n     */\n    Mousetrap.init = function() {\n        var documentMousetrap = Mousetrap(document);\n        for (var method in documentMousetrap) {\n            if (method.charAt(0) !== '_') {\n                Mousetrap[method] = (function(method) {\n                    return function() {\n                        return documentMousetrap[method].apply(documentMousetrap, arguments);\n                    };\n                } (method));\n            }\n        }\n    };\n\n    Mousetrap.init();\n\n    // expose mousetrap to the global object\n    window.Mousetrap = Mousetrap;\n\n    // expose as a common js module\n    if ( true && module.exports) {\n        module.exports = Mousetrap;\n    }\n\n    // expose mousetrap as an AMD module\n    if (true) {\n        !(__WEBPACK_AMD_DEFINE_RESULT__ = (function() {\n            return Mousetrap;\n        }).call(exports, __webpack_require__, exports, module),\n\t\t\t\t__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));\n    }\n}) (typeof window !== 'undefined' ? window : null, typeof  window !== 'undefined' ? document : null);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/mousetrap/mousetrap.js\n");

/***/ }),

/***/ "./node_modules/react-bootstrap-slider/dist/react-bootstrap-slider.js":
/*!****************************************************************************!*\
  !*** ./node_modules/react-bootstrap-slider/dist/react-bootstrap-slider.js ***!
  \****************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {\n  if (true) {\n    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [exports, __webpack_require__(/*! babel-runtime/helpers/extends */ \"./node_modules/babel-runtime/helpers/extends.js\"), __webpack_require__(/*! babel-runtime/helpers/classCallCheck */ \"./node_modules/babel-runtime/helpers/classCallCheck.js\"), __webpack_require__(/*! babel-runtime/helpers/createClass */ \"./node_modules/babel-runtime/helpers/createClass.js\"), __webpack_require__(/*! babel-runtime/helpers/possibleConstructorReturn */ \"./node_modules/babel-runtime/helpers/possibleConstructorReturn.js\"), __webpack_require__(/*! babel-runtime/helpers/inherits */ \"./node_modules/babel-runtime/helpers/inherits.js\"), __webpack_require__(/*! react */ \"./node_modules/react/index.js\"), __webpack_require__(/*! prop-types */ \"./node_modules/prop-types/index.js\"), __webpack_require__(/*! bootstrap-slider */ \"./node_modules/react-bootstrap-slider/node_modules/bootstrap-slider/dist/bootstrap-slider.js\")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),\n\t\t\t\t__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?\n\t\t\t\t(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),\n\t\t\t\t__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));\n  } else { var mod; }\n})(this, function (exports, _extends2, _classCallCheck2, _createClass2, _possibleConstructorReturn2, _inherits2, _react, _propTypes, _bootstrapSlider) {\n  \"use strict\";\n\n  Object.defineProperty(exports, \"__esModule\", {\n    value: true\n  });\n  exports.ReactBootstrapSlider = undefined;\n\n  var _extends3 = _interopRequireDefault(_extends2);\n\n  var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);\n\n  var _createClass3 = _interopRequireDefault(_createClass2);\n\n  var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);\n\n  var _inherits3 = _interopRequireDefault(_inherits2);\n\n  var _react2 = _interopRequireDefault(_react);\n\n  var _propTypes2 = _interopRequireDefault(_propTypes);\n\n  var _bootstrapSlider2 = _interopRequireDefault(_bootstrapSlider);\n\n  function _interopRequireDefault(obj) {\n    return obj && obj.__esModule ? obj : {\n      default: obj\n    };\n  }\n\n  var ReactBootstrapSlider = exports.ReactBootstrapSlider = function (_React$Component) {\n    (0, _inherits3.default)(ReactBootstrapSlider, _React$Component);\n\n    function ReactBootstrapSlider() {\n      var _ref;\n\n      var _temp, _this, _ret;\n\n      (0, _classCallCheck3.default)(this, ReactBootstrapSlider);\n\n      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n      }\n\n      return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = ReactBootstrapSlider.__proto__ || Object.getPrototypeOf(ReactBootstrapSlider)).call.apply(_ref, [this].concat(args))), _this), _this.checkAndDoDisabled = function () {\n        var sliderEnable = _this.props.disabled !== \"disabled\";\n        var currentlyEnabled = _this.mySlider.isEnabled();\n        if (sliderEnable) {\n          if (!currentlyEnabled) {\n            _this.mySlider.enable();\n          }\n        } else {\n          if (currentlyEnabled) {\n            _this.mySlider.disable();\n          }\n        }\n      }, _this.updateSliderValues = function () {\n        if (typeof _this.props.min !== \"undefined\" && (typeof _this.mySlider.min !== \"undefined\" || typeof _this.mySlider.options.min !== \"undefined\")) {\n          _this.mySlider.setAttribute(\"min\", _this.props.min);\n        }\n        if (typeof _this.props.max !== \"undefined\" && (typeof _this.mySlider.max !== \"undefined\" || typeof _this.mySlider.options.max !== \"undefined\")) {\n          _this.mySlider.setAttribute(\"max\", _this.props.max);\n        }\n        if (typeof _this.props.step !== \"undefined\" && (typeof _this.mySlider.step !== \"undefined\" || typeof _this.mySlider.options.step !== \"undefined\")) {\n          _this.mySlider.setAttribute(\"step\", _this.props.step);\n        }\n\n        _this.mySlider.setValue(_this.props.value);\n        _this.checkAndDoDisabled();\n      }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);\n    }\n    // constructor(props) {\n    //   super(props);\n    //   // this.updateSliderValues = this.updateSliderValues.bind(this);\n    //   // this.checkAndDoDisabled = this.checkAndDoDisabled.bind(this);\n    // }\n\n    (0, _createClass3.default)(ReactBootstrapSlider, [{\n      key: \"componentDidMount\",\n      value: function componentDidMount() {\n        var that = this;\n        var sliderAttributes = (0, _extends3.default)({}, this.props, {\n          tooltip: this.props.tooltip || \"show\"\n        });\n        // console.log(\"sliderAttributes = \" + JSON.stringify(sliderAttributes, null, 4));\n\n        this.mySlider = new _bootstrapSlider2.default(this.node, sliderAttributes);\n\n        //     this.updateSliderValues();\n        if (this.props.change || this.props.handleChange) {\n          var changeEvent = this.props.change || this.props.handleChange;\n          this.mySlider.on(\"change\", function (e) {\n            var fakeEvent = {\n              target: {}\n            };\n            fakeEvent.target.value = e.newValue;\n            changeEvent(fakeEvent);\n          });\n        }\n\n        if (this.props.slideStop) {\n          this.mySlider.on(\"slideStop\", function (e) {\n            var fakeEvent = {\n              target: {}\n            };\n            fakeEvent.target.value = e;\n            that.props.slideStop(fakeEvent);\n          });\n        }\n        this.checkAndDoDisabled();\n      }\n    }, {\n      key: \"componentDidUpdate\",\n      value: function componentDidUpdate() {\n        this.updateSliderValues();\n      }\n    }, {\n      key: \"componentWillUnmount\",\n      value: function componentWillUnmount() {\n        this.mySlider.destroy();\n      }\n    }, {\n      key: \"render\",\n      value: function render() {\n        var _this2 = this;\n\n        // The slider\"s an input.  That\"s all we need.  We\"ll do the rest in\n        // the componentDidMount() method.\n        return _react2.default.createElement(\"div\", { ref: function ref(node) {\n            return _this2.node = node;\n          } });\n      }\n    }]);\n    return ReactBootstrapSlider;\n  }(_react2.default.Component);\n\n  ReactBootstrapSlider.propTypes = {\n    min: _propTypes2.default.number,\n    max: _propTypes2.default.number,\n    step: _propTypes2.default.number,\n    value: _propTypes2.default.oneOfType([_propTypes2.default.number, _propTypes2.default.arrayOf(_propTypes2.default.number.isRequired).isRequired]).isRequired,\n    disabled: _propTypes2.default.string,\n    tooltip: _propTypes2.default.string,\n    change: _propTypes2.default.func,\n    handleChange: _propTypes2.default.func,\n    slideStop: _propTypes2.default.func,\n    labelledby: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.arrayOf(_propTypes2.default.string)])\n  };\n\n  exports.default = ReactBootstrapSlider;\n});\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvcmVhY3QtYm9vdHN0cmFwLXNsaWRlci9kaXN0L3JlYWN0LWJvb3RzdHJhcC1zbGlkZXIuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvcmVhY3QtYm9vdHN0cmFwLXNsaWRlci9kaXN0L3JlYWN0LWJvb3RzdHJhcC1zbGlkZXIuanM/OTkyNSJdLCJzb3VyY2VzQ29udGVudCI6WyIoZnVuY3Rpb24gKGdsb2JhbCwgZmFjdG9yeSkge1xuICBpZiAodHlwZW9mIGRlZmluZSA9PT0gXCJmdW5jdGlvblwiICYmIGRlZmluZS5hbWQpIHtcbiAgICBkZWZpbmUoW1wiZXhwb3J0c1wiLCBcImJhYmVsLXJ1bnRpbWUvaGVscGVycy9leHRlbmRzXCIsIFwiYmFiZWwtcnVudGltZS9oZWxwZXJzL2NsYXNzQ2FsbENoZWNrXCIsIFwiYmFiZWwtcnVudGltZS9oZWxwZXJzL2NyZWF0ZUNsYXNzXCIsIFwiYmFiZWwtcnVudGltZS9oZWxwZXJzL3Bvc3NpYmxlQ29uc3RydWN0b3JSZXR1cm5cIiwgXCJiYWJlbC1ydW50aW1lL2hlbHBlcnMvaW5oZXJpdHNcIiwgXCJyZWFjdFwiLCBcInByb3AtdHlwZXNcIiwgXCJib290c3RyYXAtc2xpZGVyXCJdLCBmYWN0b3J5KTtcbiAgfSBlbHNlIGlmICh0eXBlb2YgZXhwb3J0cyAhPT0gXCJ1bmRlZmluZWRcIikge1xuICAgIGZhY3RvcnkoZXhwb3J0cywgcmVxdWlyZShcImJhYmVsLXJ1bnRpbWUvaGVscGVycy9leHRlbmRzXCIpLCByZXF1aXJlKFwiYmFiZWwtcnVudGltZS9oZWxwZXJzL2NsYXNzQ2FsbENoZWNrXCIpLCByZXF1aXJlKFwiYmFiZWwtcnVudGltZS9oZWxwZXJzL2NyZWF0ZUNsYXNzXCIpLCByZXF1aXJlKFwiYmFiZWwtcnVudGltZS9oZWxwZXJzL3Bvc3NpYmxlQ29uc3RydWN0b3JSZXR1cm5cIiksIHJlcXVpcmUoXCJiYWJlbC1ydW50aW1lL2hlbHBlcnMvaW5oZXJpdHNcIiksIHJlcXVpcmUoXCJyZWFjdFwiKSwgcmVxdWlyZShcInByb3AtdHlwZXNcIiksIHJlcXVpcmUoXCJib290c3RyYXAtc2xpZGVyXCIpKTtcbiAgfSBlbHNlIHtcbiAgICB2YXIgbW9kID0ge1xuICAgICAgZXhwb3J0czoge31cbiAgICB9O1xuICAgIGZhY3RvcnkobW9kLmV4cG9ydHMsIGdsb2JhbC5fZXh0ZW5kcywgZ2xvYmFsLmNsYXNzQ2FsbENoZWNrLCBnbG9iYWwuY3JlYXRlQ2xhc3MsIGdsb2JhbC5wb3NzaWJsZUNvbnN0cnVjdG9yUmV0dXJuLCBnbG9iYWwuaW5oZXJpdHMsIGdsb2JhbC5yZWFjdCwgZ2xvYmFsLnByb3BUeXBlcywgZ2xvYmFsLmJvb3RzdHJhcFNsaWRlcik7XG4gICAgZ2xvYmFsLnJlYWN0Qm9vdHN0cmFwU2xpZGVyID0gbW9kLmV4cG9ydHM7XG4gIH1cbn0pKHRoaXMsIGZ1bmN0aW9uIChleHBvcnRzLCBfZXh0ZW5kczIsIF9jbGFzc0NhbGxDaGVjazIsIF9jcmVhdGVDbGFzczIsIF9wb3NzaWJsZUNvbnN0cnVjdG9yUmV0dXJuMiwgX2luaGVyaXRzMiwgX3JlYWN0LCBfcHJvcFR5cGVzLCBfYm9vdHN0cmFwU2xpZGVyKSB7XG4gIFwidXNlIHN0cmljdFwiO1xuXG4gIE9iamVjdC5kZWZpbmVQcm9wZXJ0eShleHBvcnRzLCBcIl9fZXNNb2R1bGVcIiwge1xuICAgIHZhbHVlOiB0cnVlXG4gIH0pO1xuICBleHBvcnRzLlJlYWN0Qm9vdHN0cmFwU2xpZGVyID0gdW5kZWZpbmVkO1xuXG4gIHZhciBfZXh0ZW5kczMgPSBfaW50ZXJvcFJlcXVpcmVEZWZhdWx0KF9leHRlbmRzMik7XG5cbiAgdmFyIF9jbGFzc0NhbGxDaGVjazMgPSBfaW50ZXJvcFJlcXVpcmVEZWZhdWx0KF9jbGFzc0NhbGxDaGVjazIpO1xuXG4gIHZhciBfY3JlYXRlQ2xhc3MzID0gX2ludGVyb3BSZXF1aXJlRGVmYXVsdChfY3JlYXRlQ2xhc3MyKTtcblxuICB2YXIgX3Bvc3NpYmxlQ29uc3RydWN0b3JSZXR1cm4zID0gX2ludGVyb3BSZXF1aXJlRGVmYXVsdChfcG9zc2libGVDb25zdHJ1Y3RvclJldHVybjIpO1xuXG4gIHZhciBfaW5oZXJpdHMzID0gX2ludGVyb3BSZXF1aXJlRGVmYXVsdChfaW5oZXJpdHMyKTtcblxuICB2YXIgX3JlYWN0MiA9IF9pbnRlcm9wUmVxdWlyZURlZmF1bHQoX3JlYWN0KTtcblxuICB2YXIgX3Byb3BUeXBlczIgPSBfaW50ZXJvcFJlcXVpcmVEZWZhdWx0KF9wcm9wVHlwZXMpO1xuXG4gIHZhciBfYm9vdHN0cmFwU2xpZGVyMiA9IF9pbnRlcm9wUmVxdWlyZURlZmF1bHQoX2Jvb3RzdHJhcFNsaWRlcik7XG5cbiAgZnVuY3Rpb24gX2ludGVyb3BSZXF1aXJlRGVmYXVsdChvYmopIHtcbiAgICByZXR1cm4gb2JqICYmIG9iai5fX2VzTW9kdWxlID8gb2JqIDoge1xuICAgICAgZGVmYXVsdDogb2JqXG4gICAgfTtcbiAgfVxuXG4gIHZhciBSZWFjdEJvb3RzdHJhcFNsaWRlciA9IGV4cG9ydHMuUmVhY3RCb290c3RyYXBTbGlkZXIgPSBmdW5jdGlvbiAoX1JlYWN0JENvbXBvbmVudCkge1xuICAgICgwLCBfaW5oZXJpdHMzLmRlZmF1bHQpKFJlYWN0Qm9vdHN0cmFwU2xpZGVyLCBfUmVhY3QkQ29tcG9uZW50KTtcblxuICAgIGZ1bmN0aW9uIFJlYWN0Qm9vdHN0cmFwU2xpZGVyKCkge1xuICAgICAgdmFyIF9yZWY7XG5cbiAgICAgIHZhciBfdGVtcCwgX3RoaXMsIF9yZXQ7XG5cbiAgICAgICgwLCBfY2xhc3NDYWxsQ2hlY2szLmRlZmF1bHQpKHRoaXMsIFJlYWN0Qm9vdHN0cmFwU2xpZGVyKTtcblxuICAgICAgZm9yICh2YXIgX2xlbiA9IGFyZ3VtZW50cy5sZW5ndGgsIGFyZ3MgPSBBcnJheShfbGVuKSwgX2tleSA9IDA7IF9rZXkgPCBfbGVuOyBfa2V5KyspIHtcbiAgICAgICAgYXJnc1tfa2V5XSA9IGFyZ3VtZW50c1tfa2V5XTtcbiAgICAgIH1cblxuICAgICAgcmV0dXJuIF9yZXQgPSAoX3RlbXAgPSAoX3RoaXMgPSAoMCwgX3Bvc3NpYmxlQ29uc3RydWN0b3JSZXR1cm4zLmRlZmF1bHQpKHRoaXMsIChfcmVmID0gUmVhY3RCb290c3RyYXBTbGlkZXIuX19wcm90b19fIHx8IE9iamVjdC5nZXRQcm90b3R5cGVPZihSZWFjdEJvb3RzdHJhcFNsaWRlcikpLmNhbGwuYXBwbHkoX3JlZiwgW3RoaXNdLmNvbmNhdChhcmdzKSkpLCBfdGhpcyksIF90aGlzLmNoZWNrQW5kRG9EaXNhYmxlZCA9IGZ1bmN0aW9uICgpIHtcbiAgICAgICAgdmFyIHNsaWRlckVuYWJsZSA9IF90aGlzLnByb3BzLmRpc2FibGVkICE9PSBcImRpc2FibGVkXCI7XG4gICAgICAgIHZhciBjdXJyZW50bHlFbmFibGVkID0gX3RoaXMubXlTbGlkZXIuaXNFbmFibGVkKCk7XG4gICAgICAgIGlmIChzbGlkZXJFbmFibGUpIHtcbiAgICAgICAgICBpZiAoIWN1cnJlbnRseUVuYWJsZWQpIHtcbiAgICAgICAgICAgIF90aGlzLm15U2xpZGVyLmVuYWJsZSgpO1xuICAgICAgICAgIH1cbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICBpZiAoY3VycmVudGx5RW5hYmxlZCkge1xuICAgICAgICAgICAgX3RoaXMubXlTbGlkZXIuZGlzYWJsZSgpO1xuICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgfSwgX3RoaXMudXBkYXRlU2xpZGVyVmFsdWVzID0gZnVuY3Rpb24gKCkge1xuICAgICAgICBpZiAodHlwZW9mIF90aGlzLnByb3BzLm1pbiAhPT0gXCJ1bmRlZmluZWRcIiAmJiAodHlwZW9mIF90aGlzLm15U2xpZGVyLm1pbiAhPT0gXCJ1bmRlZmluZWRcIiB8fCB0eXBlb2YgX3RoaXMubXlTbGlkZXIub3B0aW9ucy5taW4gIT09IFwidW5kZWZpbmVkXCIpKSB7XG4gICAgICAgICAgX3RoaXMubXlTbGlkZXIuc2V0QXR0cmlidXRlKFwibWluXCIsIF90aGlzLnByb3BzLm1pbik7XG4gICAgICAgIH1cbiAgICAgICAgaWYgKHR5cGVvZiBfdGhpcy5wcm9wcy5tYXggIT09IFwidW5kZWZpbmVkXCIgJiYgKHR5cGVvZiBfdGhpcy5teVNsaWRlci5tYXggIT09IFwidW5kZWZpbmVkXCIgfHwgdHlwZW9mIF90aGlzLm15U2xpZGVyLm9wdGlvbnMubWF4ICE9PSBcInVuZGVmaW5lZFwiKSkge1xuICAgICAgICAgIF90aGlzLm15U2xpZGVyLnNldEF0dHJpYnV0ZShcIm1heFwiLCBfdGhpcy5wcm9wcy5tYXgpO1xuICAgICAgICB9XG4gICAgICAgIGlmICh0eXBlb2YgX3RoaXMucHJvcHMuc3RlcCAhPT0gXCJ1bmRlZmluZWRcIiAmJiAodHlwZW9mIF90aGlzLm15U2xpZGVyLnN0ZXAgIT09IFwidW5kZWZpbmVkXCIgfHwgdHlwZW9mIF90aGlzLm15U2xpZGVyLm9wdGlvbnMuc3RlcCAhPT0gXCJ1bmRlZmluZWRcIikpIHtcbiAgICAgICAgICBfdGhpcy5teVNsaWRlci5zZXRBdHRyaWJ1dGUoXCJzdGVwXCIsIF90aGlzLnByb3BzLnN0ZXApO1xuICAgICAgICB9XG5cbiAgICAgICAgX3RoaXMubXlTbGlkZXIuc2V0VmFsdWUoX3RoaXMucHJvcHMudmFsdWUpO1xuICAgICAgICBfdGhpcy5jaGVja0FuZERvRGlzYWJsZWQoKTtcbiAgICAgIH0sIF90ZW1wKSwgKDAsIF9wb3NzaWJsZUNvbnN0cnVjdG9yUmV0dXJuMy5kZWZhdWx0KShfdGhpcywgX3JldCk7XG4gICAgfVxuICAgIC8vIGNvbnN0cnVjdG9yKHByb3BzKSB7XG4gICAgLy8gICBzdXBlcihwcm9wcyk7XG4gICAgLy8gICAvLyB0aGlzLnVwZGF0ZVNsaWRlclZhbHVlcyA9IHRoaXMudXBkYXRlU2xpZGVyVmFsdWVzLmJpbmQodGhpcyk7XG4gICAgLy8gICAvLyB0aGlzLmNoZWNrQW5kRG9EaXNhYmxlZCA9IHRoaXMuY2hlY2tBbmREb0Rpc2FibGVkLmJpbmQodGhpcyk7XG4gICAgLy8gfVxuXG4gICAgKDAsIF9jcmVhdGVDbGFzczMuZGVmYXVsdCkoUmVhY3RCb290c3RyYXBTbGlkZXIsIFt7XG4gICAgICBrZXk6IFwiY29tcG9uZW50RGlkTW91bnRcIixcbiAgICAgIHZhbHVlOiBmdW5jdGlvbiBjb21wb25lbnREaWRNb3VudCgpIHtcbiAgICAgICAgdmFyIHRoYXQgPSB0aGlzO1xuICAgICAgICB2YXIgc2xpZGVyQXR0cmlidXRlcyA9ICgwLCBfZXh0ZW5kczMuZGVmYXVsdCkoe30sIHRoaXMucHJvcHMsIHtcbiAgICAgICAgICB0b29sdGlwOiB0aGlzLnByb3BzLnRvb2x0aXAgfHwgXCJzaG93XCJcbiAgICAgICAgfSk7XG4gICAgICAgIC8vIGNvbnNvbGUubG9nKFwic2xpZGVyQXR0cmlidXRlcyA9IFwiICsgSlNPTi5zdHJpbmdpZnkoc2xpZGVyQXR0cmlidXRlcywgbnVsbCwgNCkpO1xuXG4gICAgICAgIHRoaXMubXlTbGlkZXIgPSBuZXcgX2Jvb3RzdHJhcFNsaWRlcjIuZGVmYXVsdCh0aGlzLm5vZGUsIHNsaWRlckF0dHJpYnV0ZXMpO1xuXG4gICAgICAgIC8vICAgICB0aGlzLnVwZGF0ZVNsaWRlclZhbHVlcygpO1xuICAgICAgICBpZiAodGhpcy5wcm9wcy5jaGFuZ2UgfHwgdGhpcy5wcm9wcy5oYW5kbGVDaGFuZ2UpIHtcbiAgICAgICAgICB2YXIgY2hhbmdlRXZlbnQgPSB0aGlzLnByb3BzLmNoYW5nZSB8fCB0aGlzLnByb3BzLmhhbmRsZUNoYW5nZTtcbiAgICAgICAgICB0aGlzLm15U2xpZGVyLm9uKFwiY2hhbmdlXCIsIGZ1bmN0aW9uIChlKSB7XG4gICAgICAgICAgICB2YXIgZmFrZUV2ZW50ID0ge1xuICAgICAgICAgICAgICB0YXJnZXQ6IHt9XG4gICAgICAgICAgICB9O1xuICAgICAgICAgICAgZmFrZUV2ZW50LnRhcmdldC52YWx1ZSA9IGUubmV3VmFsdWU7XG4gICAgICAgICAgICBjaGFuZ2VFdmVudChmYWtlRXZlbnQpO1xuICAgICAgICAgIH0pO1xuICAgICAgICB9XG5cbiAgICAgICAgaWYgKHRoaXMucHJvcHMuc2xpZGVTdG9wKSB7XG4gICAgICAgICAgdGhpcy5teVNsaWRlci5vbihcInNsaWRlU3RvcFwiLCBmdW5jdGlvbiAoZSkge1xuICAgICAgICAgICAgdmFyIGZha2VFdmVudCA9IHtcbiAgICAgICAgICAgICAgdGFyZ2V0OiB7fVxuICAgICAgICAgICAgfTtcbiAgICAgICAgICAgIGZha2VFdmVudC50YXJnZXQudmFsdWUgPSBlO1xuICAgICAgICAgICAgdGhhdC5wcm9wcy5zbGlkZVN0b3AoZmFrZUV2ZW50KTtcbiAgICAgICAgICB9KTtcbiAgICAgICAgfVxuICAgICAgICB0aGlzLmNoZWNrQW5kRG9EaXNhYmxlZCgpO1xuICAgICAgfVxuICAgIH0sIHtcbiAgICAgIGtleTogXCJjb21wb25lbnREaWRVcGRhdGVcIixcbiAgICAgIHZhbHVlOiBmdW5jdGlvbiBjb21wb25lbnREaWRVcGRhdGUoKSB7XG4gICAgICAgIHRoaXMudXBkYXRlU2xpZGVyVmFsdWVzKCk7XG4gICAgICB9XG4gICAgfSwge1xuICAgICAga2V5OiBcImNvbXBvbmVudFdpbGxVbm1vdW50XCIsXG4gICAgICB2YWx1ZTogZnVuY3Rpb24gY29tcG9uZW50V2lsbFVubW91bnQoKSB7XG4gICAgICAgIHRoaXMubXlTbGlkZXIuZGVzdHJveSgpO1xuICAgICAgfVxuICAgIH0sIHtcbiAgICAgIGtleTogXCJyZW5kZXJcIixcbiAgICAgIHZhbHVlOiBmdW5jdGlvbiByZW5kZXIoKSB7XG4gICAgICAgIHZhciBfdGhpczIgPSB0aGlzO1xuXG4gICAgICAgIC8vIFRoZSBzbGlkZXJcInMgYW4gaW5wdXQuICBUaGF0XCJzIGFsbCB3ZSBuZWVkLiAgV2VcImxsIGRvIHRoZSByZXN0IGluXG4gICAgICAgIC8vIHRoZSBjb21wb25lbnREaWRNb3VudCgpIG1ldGhvZC5cbiAgICAgICAgcmV0dXJuIF9yZWFjdDIuZGVmYXVsdC5jcmVhdGVFbGVtZW50KFwiZGl2XCIsIHsgcmVmOiBmdW5jdGlvbiByZWYobm9kZSkge1xuICAgICAgICAgICAgcmV0dXJuIF90aGlzMi5ub2RlID0gbm9kZTtcbiAgICAgICAgICB9IH0pO1xuICAgICAgfVxuICAgIH1dKTtcbiAgICByZXR1cm4gUmVhY3RCb290c3RyYXBTbGlkZXI7XG4gIH0oX3JlYWN0Mi5kZWZhdWx0LkNvbXBvbmVudCk7XG5cbiAgUmVhY3RCb290c3RyYXBTbGlkZXIucHJvcFR5cGVzID0ge1xuICAgIG1pbjogX3Byb3BUeXBlczIuZGVmYXVsdC5udW1iZXIsXG4gICAgbWF4OiBfcHJvcFR5cGVzMi5kZWZhdWx0Lm51bWJlcixcbiAgICBzdGVwOiBfcHJvcFR5cGVzMi5kZWZhdWx0Lm51bWJlcixcbiAgICB2YWx1ZTogX3Byb3BUeXBlczIuZGVmYXVsdC5vbmVPZlR5cGUoW19wcm9wVHlwZXMyLmRlZmF1bHQubnVtYmVyLCBfcHJvcFR5cGVzMi5kZWZhdWx0LmFycmF5T2YoX3Byb3BUeXBlczIuZGVmYXVsdC5udW1iZXIuaXNSZXF1aXJlZCkuaXNSZXF1aXJlZF0pLmlzUmVxdWlyZWQsXG4gICAgZGlzYWJsZWQ6IF9wcm9wVHlwZXMyLmRlZmF1bHQuc3RyaW5nLFxuICAgIHRvb2x0aXA6IF9wcm9wVHlwZXMyLmRlZmF1bHQuc3RyaW5nLFxuICAgIGNoYW5nZTogX3Byb3BUeXBlczIuZGVmYXVsdC5mdW5jLFxuICAgIGhhbmRsZUNoYW5nZTogX3Byb3BUeXBlczIuZGVmYXVsdC5mdW5jLFxuICAgIHNsaWRlU3RvcDogX3Byb3BUeXBlczIuZGVmYXVsdC5mdW5jLFxuICAgIGxhYmVsbGVkYnk6IF9wcm9wVHlwZXMyLmRlZmF1bHQub25lT2ZUeXBlKFtfcHJvcFR5cGVzMi5kZWZhdWx0LnN0cmluZywgX3Byb3BUeXBlczIuZGVmYXVsdC5hcnJheU9mKF9wcm9wVHlwZXMyLmRlZmF1bHQuc3RyaW5nKV0pXG4gIH07XG5cbiAgZXhwb3J0cy5kZWZhdWx0ID0gUmVhY3RCb290c3RyYXBTbGlkZXI7XG59KTtcbiJdLCJtYXBwaW5ncyI6IkFBQUE7QUFDQTtBQUNBO0FBQUE7QUFBQTtBQUFBO0FBQ0EscUJBUUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTsiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/react-bootstrap-slider/dist/react-bootstrap-slider.js\n");

/***/ }),

/***/ "./node_modules/react-bootstrap-slider/node_modules/bootstrap-slider/dist/bootstrap-slider.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/react-bootstrap-slider/node_modules/bootstrap-slider/dist/bootstrap-slider.js ***!
  \****************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*! =======================================================\n                      VERSION  9.9.0              \n========================================================= */\n\n\nvar _typeof = typeof Symbol === \"function\" && typeof Symbol.iterator === \"symbol\" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === \"function\" && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; };\n\n/*! =========================================================\n * bootstrap-slider.js\n *\n * Maintainers:\n *\t\tKyle Kemp\n *\t\t\t- Twitter: @seiyria\n *\t\t\t- Github:  seiyria\n *\t\tRohit Kalkur\n *\t\t\t- Twitter: @Rovolutionary\n *\t\t\t- Github:  rovolution\n *\n * =========================================================\n *\n * bootstrap-slider is released under the MIT License\n * Copyright (c) 2017 Kyle Kemp, Rohit Kalkur, and contributors\n *\n * Permission is hereby granted, free of charge, to any person\n * obtaining a copy of this software and associated documentation\n * files (the \"Software\"), to deal in the Software without\n * restriction, including without limitation the rights to use,\n * copy, modify, merge, publish, distribute, sublicense, and/or sell\n * copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following\n * conditions:\n *\n * The above copyright notice and this permission notice shall be\n * included in all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND,\n * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES\n * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND\n * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT\n * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,\n * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR\n * OTHER DEALINGS IN THE SOFTWARE.\n *\n * ========================================================= */\n\n/**\n * Bridget makes jQuery widgets\n * v1.0.1\n * MIT license\n */\nvar windowIsDefined = (typeof window === \"undefined\" ? \"undefined\" : _typeof(window)) === \"object\";\n\n(function (factory) {\n\tif (true) {\n\t\t!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! jquery */ \"./node_modules/jquery/dist/jquery.js\")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),\n\t\t\t\t__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?\n\t\t\t\t(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),\n\t\t\t\t__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));\n\t} else { var jQuery; }\n})(function ($) {\n\t// Constants\n\tvar NAMESPACE_MAIN = 'slider';\n\tvar NAMESPACE_ALTERNATE = 'bootstrapSlider';\n\n\t// Polyfill console methods\n\tif (windowIsDefined && !window.console) {\n\t\twindow.console = {};\n\t}\n\tif (windowIsDefined && !window.console.log) {\n\t\twindow.console.log = function () {};\n\t}\n\tif (windowIsDefined && !window.console.warn) {\n\t\twindow.console.warn = function () {};\n\t}\n\n\t// Reference to Slider constructor\n\tvar Slider;\n\n\t(function ($) {\n\n\t\t'use strict';\n\n\t\t// -------------------------- utils -------------------------- //\n\n\t\tvar slice = Array.prototype.slice;\n\n\t\tfunction noop() {}\n\n\t\t// -------------------------- definition -------------------------- //\n\n\t\tfunction defineBridget($) {\n\n\t\t\t// bail if no jQuery\n\t\t\tif (!$) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// -------------------------- addOptionMethod -------------------------- //\n\n\t\t\t/**\n    * adds option method -> $().plugin('option', {...})\n    * @param {Function} PluginClass - constructor class\n    */\n\t\t\tfunction addOptionMethod(PluginClass) {\n\t\t\t\t// don't overwrite original option method\n\t\t\t\tif (PluginClass.prototype.option) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t// option setter\n\t\t\t\tPluginClass.prototype.option = function (opts) {\n\t\t\t\t\t// bail out if not an object\n\t\t\t\t\tif (!$.isPlainObject(opts)) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t\tthis.options = $.extend(true, this.options, opts);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\t// -------------------------- plugin bridge -------------------------- //\n\n\t\t\t// helper function for logging errors\n\t\t\t// $.error breaks jQuery chaining\n\t\t\tvar logError = typeof console === 'undefined' ? noop : function (message) {\n\t\t\t\tconsole.error(message);\n\t\t\t};\n\n\t\t\t/**\n    * jQuery plugin bridge, access methods like $elem.plugin('method')\n    * @param {String} namespace - plugin name\n    * @param {Function} PluginClass - constructor class\n    */\n\t\t\tfunction bridge(namespace, PluginClass) {\n\t\t\t\t// add to jQuery fn namespace\n\t\t\t\t$.fn[namespace] = function (options) {\n\t\t\t\t\tif (typeof options === 'string') {\n\t\t\t\t\t\t// call plugin method when first argument is a string\n\t\t\t\t\t\t// get arguments for method\n\t\t\t\t\t\tvar args = slice.call(arguments, 1);\n\n\t\t\t\t\t\tfor (var i = 0, len = this.length; i < len; i++) {\n\t\t\t\t\t\t\tvar elem = this[i];\n\t\t\t\t\t\t\tvar instance = $.data(elem, namespace);\n\t\t\t\t\t\t\tif (!instance) {\n\t\t\t\t\t\t\t\tlogError(\"cannot call methods on \" + namespace + \" prior to initialization; \" + \"attempted to call '\" + options + \"'\");\n\t\t\t\t\t\t\t\tcontinue;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif (!$.isFunction(instance[options]) || options.charAt(0) === '_') {\n\t\t\t\t\t\t\t\tlogError(\"no such method '\" + options + \"' for \" + namespace + \" instance\");\n\t\t\t\t\t\t\t\tcontinue;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// trigger method with arguments\n\t\t\t\t\t\t\tvar returnValue = instance[options].apply(instance, args);\n\n\t\t\t\t\t\t\t// break look and return first value if provided\n\t\t\t\t\t\t\tif (returnValue !== undefined && returnValue !== instance) {\n\t\t\t\t\t\t\t\treturn returnValue;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\t// return this if no return value\n\t\t\t\t\t\treturn this;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tvar objects = this.map(function () {\n\t\t\t\t\t\t\tvar instance = $.data(this, namespace);\n\t\t\t\t\t\t\tif (instance) {\n\t\t\t\t\t\t\t\t// apply options & init\n\t\t\t\t\t\t\t\tinstance.option(options);\n\t\t\t\t\t\t\t\tinstance._init();\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t// initialize new instance\n\t\t\t\t\t\t\t\tinstance = new PluginClass(this, options);\n\t\t\t\t\t\t\t\t$.data(this, namespace, instance);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\treturn $(this);\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\tif (!objects || objects.length > 1) {\n\t\t\t\t\t\t\treturn objects;\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\treturn objects[0];\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t}\n\n\t\t\t// -------------------------- bridget -------------------------- //\n\n\t\t\t/**\n    * converts a Prototypical class into a proper jQuery plugin\n    *   the class must have a ._init method\n    * @param {String} namespace - plugin name, used in $().pluginName\n    * @param {Function} PluginClass - constructor class\n    */\n\t\t\t$.bridget = function (namespace, PluginClass) {\n\t\t\t\taddOptionMethod(PluginClass);\n\t\t\t\tbridge(namespace, PluginClass);\n\t\t\t};\n\n\t\t\treturn $.bridget;\n\t\t}\n\n\t\t// get jquery from browser global\n\t\tdefineBridget($);\n\t})($);\n\n\t/*************************************************\n \t\t\tBOOTSTRAP-SLIDER SOURCE CODE\n \t**************************************************/\n\n\t(function ($) {\n\n\t\tvar ErrorMsgs = {\n\t\t\tformatInvalidInputErrorMsg: function formatInvalidInputErrorMsg(input) {\n\t\t\t\treturn \"Invalid input value '\" + input + \"' passed in\";\n\t\t\t},\n\t\t\tcallingContextNotSliderInstance: \"Calling context element does not have instance of Slider bound to it. Check your code to make sure the JQuery object returned from the call to the slider() initializer is calling the method\"\n\t\t};\n\n\t\tvar SliderScale = {\n\t\t\tlinear: {\n\t\t\t\ttoValue: function toValue(percentage) {\n\t\t\t\t\tvar rawValue = percentage / 100 * (this.options.max - this.options.min);\n\t\t\t\t\tvar shouldAdjustWithBase = true;\n\t\t\t\t\tif (this.options.ticks_positions.length > 0) {\n\t\t\t\t\t\tvar minv,\n\t\t\t\t\t\t    maxv,\n\t\t\t\t\t\t    minp,\n\t\t\t\t\t\t    maxp = 0;\n\t\t\t\t\t\tfor (var i = 1; i < this.options.ticks_positions.length; i++) {\n\t\t\t\t\t\t\tif (percentage <= this.options.ticks_positions[i]) {\n\t\t\t\t\t\t\t\tminv = this.options.ticks[i - 1];\n\t\t\t\t\t\t\t\tminp = this.options.ticks_positions[i - 1];\n\t\t\t\t\t\t\t\tmaxv = this.options.ticks[i];\n\t\t\t\t\t\t\t\tmaxp = this.options.ticks_positions[i];\n\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\tvar partialPercentage = (percentage - minp) / (maxp - minp);\n\t\t\t\t\t\trawValue = minv + partialPercentage * (maxv - minv);\n\t\t\t\t\t\tshouldAdjustWithBase = false;\n\t\t\t\t\t}\n\n\t\t\t\t\tvar adjustment = shouldAdjustWithBase ? this.options.min : 0;\n\t\t\t\t\tvar value = adjustment + Math.round(rawValue / this.options.step) * this.options.step;\n\t\t\t\t\tif (value < this.options.min) {\n\t\t\t\t\t\treturn this.options.min;\n\t\t\t\t\t} else if (value > this.options.max) {\n\t\t\t\t\t\treturn this.options.max;\n\t\t\t\t\t} else {\n\t\t\t\t\t\treturn value;\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\ttoPercentage: function toPercentage(value) {\n\t\t\t\t\tif (this.options.max === this.options.min) {\n\t\t\t\t\t\treturn 0;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (this.options.ticks_positions.length > 0) {\n\t\t\t\t\t\tvar minv,\n\t\t\t\t\t\t    maxv,\n\t\t\t\t\t\t    minp,\n\t\t\t\t\t\t    maxp = 0;\n\t\t\t\t\t\tfor (var i = 0; i < this.options.ticks.length; i++) {\n\t\t\t\t\t\t\tif (value <= this.options.ticks[i]) {\n\t\t\t\t\t\t\t\tminv = i > 0 ? this.options.ticks[i - 1] : 0;\n\t\t\t\t\t\t\t\tminp = i > 0 ? this.options.ticks_positions[i - 1] : 0;\n\t\t\t\t\t\t\t\tmaxv = this.options.ticks[i];\n\t\t\t\t\t\t\t\tmaxp = this.options.ticks_positions[i];\n\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif (i > 0) {\n\t\t\t\t\t\t\tvar partialPercentage = (value - minv) / (maxv - minv);\n\t\t\t\t\t\t\treturn minp + partialPercentage * (maxp - minp);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\treturn 100 * (value - this.options.min) / (this.options.max - this.options.min);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tlogarithmic: {\n\t\t\t\t/* Based on http://stackoverflow.com/questions/846221/logarithmic-slider */\n\t\t\t\ttoValue: function toValue(percentage) {\n\t\t\t\t\tvar min = this.options.min === 0 ? 0 : Math.log(this.options.min);\n\t\t\t\t\tvar max = Math.log(this.options.max);\n\t\t\t\t\tvar value = Math.exp(min + (max - min) * percentage / 100);\n\t\t\t\t\tif (Math.round(value) === this.options.max) {\n\t\t\t\t\t\treturn this.options.max;\n\t\t\t\t\t}\n\t\t\t\t\tvalue = this.options.min + Math.round((value - this.options.min) / this.options.step) * this.options.step;\n\t\t\t\t\t/* Rounding to the nearest step could exceed the min or\n      * max, so clip to those values. */\n\t\t\t\t\tif (value < this.options.min) {\n\t\t\t\t\t\treturn this.options.min;\n\t\t\t\t\t} else if (value > this.options.max) {\n\t\t\t\t\t\treturn this.options.max;\n\t\t\t\t\t} else {\n\t\t\t\t\t\treturn value;\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\ttoPercentage: function toPercentage(value) {\n\t\t\t\t\tif (this.options.max === this.options.min) {\n\t\t\t\t\t\treturn 0;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tvar max = Math.log(this.options.max);\n\t\t\t\t\t\tvar min = this.options.min === 0 ? 0 : Math.log(this.options.min);\n\t\t\t\t\t\tvar v = value === 0 ? 0 : Math.log(value);\n\t\t\t\t\t\treturn 100 * (v - min) / (max - min);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\t/*************************************************\n  \t\t\t\t\t\tCONSTRUCTOR\n  \t**************************************************/\n\t\tSlider = function Slider(element, options) {\n\t\t\tcreateNewSlider.call(this, element, options);\n\t\t\treturn this;\n\t\t};\n\n\t\tfunction createNewSlider(element, options) {\n\n\t\t\t/*\n   \tThe internal state object is used to store data about the current 'state' of slider.\n   \tThis includes values such as the `value`, `enabled`, etc...\n   */\n\t\t\tthis._state = {\n\t\t\t\tvalue: null,\n\t\t\t\tenabled: null,\n\t\t\t\toffset: null,\n\t\t\t\tsize: null,\n\t\t\t\tpercentage: null,\n\t\t\t\tinDrag: false,\n\t\t\t\tover: false\n\t\t\t};\n\n\t\t\t// The objects used to store the reference to the tick methods if ticks_tooltip is on\n\t\t\tthis.ticksCallbackMap = {};\n\t\t\tthis.handleCallbackMap = {};\n\n\t\t\tif (typeof element === \"string\") {\n\t\t\t\tthis.element = document.querySelector(element);\n\t\t\t} else if (element instanceof HTMLElement) {\n\t\t\t\tthis.element = element;\n\t\t\t}\n\n\t\t\t/*************************************************\n   \t\t\t\t\tProcess Options\n   \t**************************************************/\n\t\t\toptions = options ? options : {};\n\t\t\tvar optionTypes = Object.keys(this.defaultOptions);\n\n\t\t\tfor (var i = 0; i < optionTypes.length; i++) {\n\t\t\t\tvar optName = optionTypes[i];\n\n\t\t\t\t// First check if an option was passed in via the constructor\n\t\t\t\tvar val = options[optName];\n\t\t\t\t// If no data attrib, then check data atrributes\n\t\t\t\tval = typeof val !== 'undefined' ? val : getDataAttrib(this.element, optName);\n\t\t\t\t// Finally, if nothing was specified, use the defaults\n\t\t\t\tval = val !== null ? val : this.defaultOptions[optName];\n\n\t\t\t\t// Set all options on the instance of the Slider\n\t\t\t\tif (!this.options) {\n\t\t\t\t\tthis.options = {};\n\t\t\t\t}\n\t\t\t\tthis.options[optName] = val;\n\t\t\t}\n\n\t\t\t// Check options.rtl\n\t\t\tif (this.options.rtl === 'auto') {\n\t\t\t\tthis.options.rtl = window.getComputedStyle(this.element).direction === 'rtl';\n\t\t\t}\n\n\t\t\t/*\n   \tValidate `tooltip_position` against 'orientation`\n   \t- if `tooltip_position` is incompatible with orientation, swith it to a default compatible with specified `orientation`\n   \t\t-- default for \"vertical\" -> \"right\", \"left\" if rtl\n   \t\t-- default for \"horizontal\" -> \"top\"\n   */\n\t\t\tif (this.options.orientation === \"vertical\" && (this.options.tooltip_position === \"top\" || this.options.tooltip_position === \"bottom\")) {\n\t\t\t\tif (this.options.rtl) {\n\t\t\t\t\tthis.options.tooltip_position = \"left\";\n\t\t\t\t} else {\n\t\t\t\t\tthis.options.tooltip_position = \"right\";\n\t\t\t\t}\n\t\t\t} else if (this.options.orientation === \"horizontal\" && (this.options.tooltip_position === \"left\" || this.options.tooltip_position === \"right\")) {\n\n\t\t\t\tthis.options.tooltip_position = \"top\";\n\t\t\t}\n\n\t\t\tfunction getDataAttrib(element, optName) {\n\t\t\t\tvar dataName = \"data-slider-\" + optName.replace(/_/g, '-');\n\t\t\t\tvar dataValString = element.getAttribute(dataName);\n\n\t\t\t\ttry {\n\t\t\t\t\treturn JSON.parse(dataValString);\n\t\t\t\t} catch (err) {\n\t\t\t\t\treturn dataValString;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t/*************************************************\n   \t\t\t\t\tCreate Markup\n   \t**************************************************/\n\n\t\t\tvar origWidth = this.element.style.width;\n\t\t\tvar updateSlider = false;\n\t\t\tvar parent = this.element.parentNode;\n\t\t\tvar sliderTrackSelection;\n\t\t\tvar sliderTrackLow, sliderTrackHigh;\n\t\t\tvar sliderMinHandle;\n\t\t\tvar sliderMaxHandle;\n\n\t\t\tif (this.sliderElem) {\n\t\t\t\tupdateSlider = true;\n\t\t\t} else {\n\t\t\t\t/* Create elements needed for slider */\n\t\t\t\tthis.sliderElem = document.createElement(\"div\");\n\t\t\t\tthis.sliderElem.className = \"slider\";\n\n\t\t\t\t/* Create slider track elements */\n\t\t\t\tvar sliderTrack = document.createElement(\"div\");\n\t\t\t\tsliderTrack.className = \"slider-track\";\n\n\t\t\t\tsliderTrackLow = document.createElement(\"div\");\n\t\t\t\tsliderTrackLow.className = \"slider-track-low\";\n\n\t\t\t\tsliderTrackSelection = document.createElement(\"div\");\n\t\t\t\tsliderTrackSelection.className = \"slider-selection\";\n\n\t\t\t\tsliderTrackHigh = document.createElement(\"div\");\n\t\t\t\tsliderTrackHigh.className = \"slider-track-high\";\n\n\t\t\t\tsliderMinHandle = document.createElement(\"div\");\n\t\t\t\tsliderMinHandle.className = \"slider-handle min-slider-handle\";\n\t\t\t\tsliderMinHandle.setAttribute('role', 'slider');\n\t\t\t\tsliderMinHandle.setAttribute('aria-valuemin', this.options.min);\n\t\t\t\tsliderMinHandle.setAttribute('aria-valuemax', this.options.max);\n\n\t\t\t\tsliderMaxHandle = document.createElement(\"div\");\n\t\t\t\tsliderMaxHandle.className = \"slider-handle max-slider-handle\";\n\t\t\t\tsliderMaxHandle.setAttribute('role', 'slider');\n\t\t\t\tsliderMaxHandle.setAttribute('aria-valuemin', this.options.min);\n\t\t\t\tsliderMaxHandle.setAttribute('aria-valuemax', this.options.max);\n\n\t\t\t\tsliderTrack.appendChild(sliderTrackLow);\n\t\t\t\tsliderTrack.appendChild(sliderTrackSelection);\n\t\t\t\tsliderTrack.appendChild(sliderTrackHigh);\n\n\t\t\t\t/* Create highlight range elements */\n\t\t\t\tthis.rangeHighlightElements = [];\n\t\t\t\tvar rangeHighlightsOpts = this.options.rangeHighlights;\n\t\t\t\tif (Array.isArray(rangeHighlightsOpts) && rangeHighlightsOpts.length > 0) {\n\t\t\t\t\tfor (var j = 0; j < rangeHighlightsOpts.length; j++) {\n\t\t\t\t\t\tvar rangeHighlightElement = document.createElement(\"div\");\n\t\t\t\t\t\tvar customClassString = rangeHighlightsOpts[j].class || \"\";\n\t\t\t\t\t\trangeHighlightElement.className = \"slider-rangeHighlight slider-selection \" + customClassString;\n\t\t\t\t\t\tthis.rangeHighlightElements.push(rangeHighlightElement);\n\t\t\t\t\t\tsliderTrack.appendChild(rangeHighlightElement);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t/* Add aria-labelledby to handle's */\n\t\t\t\tvar isLabelledbyArray = Array.isArray(this.options.labelledby);\n\t\t\t\tif (isLabelledbyArray && this.options.labelledby[0]) {\n\t\t\t\t\tsliderMinHandle.setAttribute('aria-labelledby', this.options.labelledby[0]);\n\t\t\t\t}\n\t\t\t\tif (isLabelledbyArray && this.options.labelledby[1]) {\n\t\t\t\t\tsliderMaxHandle.setAttribute('aria-labelledby', this.options.labelledby[1]);\n\t\t\t\t}\n\t\t\t\tif (!isLabelledbyArray && this.options.labelledby) {\n\t\t\t\t\tsliderMinHandle.setAttribute('aria-labelledby', this.options.labelledby);\n\t\t\t\t\tsliderMaxHandle.setAttribute('aria-labelledby', this.options.labelledby);\n\t\t\t\t}\n\n\t\t\t\t/* Create ticks */\n\t\t\t\tthis.ticks = [];\n\t\t\t\tif (Array.isArray(this.options.ticks) && this.options.ticks.length > 0) {\n\t\t\t\t\tthis.ticksContainer = document.createElement('div');\n\t\t\t\t\tthis.ticksContainer.className = 'slider-tick-container';\n\n\t\t\t\t\tfor (i = 0; i < this.options.ticks.length; i++) {\n\t\t\t\t\t\tvar tick = document.createElement('div');\n\t\t\t\t\t\ttick.className = 'slider-tick';\n\t\t\t\t\t\tif (this.options.ticks_tooltip) {\n\t\t\t\t\t\t\tvar tickListenerReference = this._addTickListener();\n\t\t\t\t\t\t\tvar enterCallback = tickListenerReference.addMouseEnter(this, tick, i);\n\t\t\t\t\t\t\tvar leaveCallback = tickListenerReference.addMouseLeave(this, tick);\n\n\t\t\t\t\t\t\tthis.ticksCallbackMap[i] = {\n\t\t\t\t\t\t\t\tmouseEnter: enterCallback,\n\t\t\t\t\t\t\t\tmouseLeave: leaveCallback\n\t\t\t\t\t\t\t};\n\t\t\t\t\t\t}\n\t\t\t\t\t\tthis.ticks.push(tick);\n\t\t\t\t\t\tthis.ticksContainer.appendChild(tick);\n\t\t\t\t\t}\n\n\t\t\t\t\tsliderTrackSelection.className += \" tick-slider-selection\";\n\t\t\t\t}\n\n\t\t\t\tthis.tickLabels = [];\n\t\t\t\tif (Array.isArray(this.options.ticks_labels) && this.options.ticks_labels.length > 0) {\n\t\t\t\t\tthis.tickLabelContainer = document.createElement('div');\n\t\t\t\t\tthis.tickLabelContainer.className = 'slider-tick-label-container';\n\n\t\t\t\t\tfor (i = 0; i < this.options.ticks_labels.length; i++) {\n\t\t\t\t\t\tvar label = document.createElement('div');\n\t\t\t\t\t\tvar noTickPositionsSpecified = this.options.ticks_positions.length === 0;\n\t\t\t\t\t\tvar tickLabelsIndex = this.options.reversed && noTickPositionsSpecified ? this.options.ticks_labels.length - (i + 1) : i;\n\t\t\t\t\t\tlabel.className = 'slider-tick-label';\n\t\t\t\t\t\tlabel.innerHTML = this.options.ticks_labels[tickLabelsIndex];\n\n\t\t\t\t\t\tthis.tickLabels.push(label);\n\t\t\t\t\t\tthis.tickLabelContainer.appendChild(label);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tvar createAndAppendTooltipSubElements = function createAndAppendTooltipSubElements(tooltipElem) {\n\t\t\t\t\tvar arrow = document.createElement(\"div\");\n\t\t\t\t\tarrow.className = \"tooltip-arrow\";\n\n\t\t\t\t\tvar inner = document.createElement(\"div\");\n\t\t\t\t\tinner.className = \"tooltip-inner\";\n\n\t\t\t\t\ttooltipElem.appendChild(arrow);\n\t\t\t\t\ttooltipElem.appendChild(inner);\n\t\t\t\t};\n\n\t\t\t\t/* Create tooltip elements */\n\t\t\t\tvar sliderTooltip = document.createElement(\"div\");\n\t\t\t\tsliderTooltip.className = \"tooltip tooltip-main\";\n\t\t\t\tsliderTooltip.setAttribute('role', 'presentation');\n\t\t\t\tcreateAndAppendTooltipSubElements(sliderTooltip);\n\n\t\t\t\tvar sliderTooltipMin = document.createElement(\"div\");\n\t\t\t\tsliderTooltipMin.className = \"tooltip tooltip-min\";\n\t\t\t\tsliderTooltipMin.setAttribute('role', 'presentation');\n\t\t\t\tcreateAndAppendTooltipSubElements(sliderTooltipMin);\n\n\t\t\t\tvar sliderTooltipMax = document.createElement(\"div\");\n\t\t\t\tsliderTooltipMax.className = \"tooltip tooltip-max\";\n\t\t\t\tsliderTooltipMax.setAttribute('role', 'presentation');\n\t\t\t\tcreateAndAppendTooltipSubElements(sliderTooltipMax);\n\n\t\t\t\t/* Append components to sliderElem */\n\t\t\t\tthis.sliderElem.appendChild(sliderTrack);\n\t\t\t\tthis.sliderElem.appendChild(sliderTooltip);\n\t\t\t\tthis.sliderElem.appendChild(sliderTooltipMin);\n\t\t\t\tthis.sliderElem.appendChild(sliderTooltipMax);\n\n\t\t\t\tif (this.tickLabelContainer) {\n\t\t\t\t\tthis.sliderElem.appendChild(this.tickLabelContainer);\n\t\t\t\t}\n\t\t\t\tif (this.ticksContainer) {\n\t\t\t\t\tthis.sliderElem.appendChild(this.ticksContainer);\n\t\t\t\t}\n\n\t\t\t\tthis.sliderElem.appendChild(sliderMinHandle);\n\t\t\t\tthis.sliderElem.appendChild(sliderMaxHandle);\n\n\t\t\t\t/* Append slider element to parent container, right before the original <input> element */\n\t\t\t\tparent.insertBefore(this.sliderElem, this.element);\n\n\t\t\t\t/* Hide original <input> element */\n\t\t\t\tthis.element.style.display = \"none\";\n\t\t\t}\n\t\t\t/* If JQuery exists, cache JQ references */\n\t\t\tif ($) {\n\t\t\t\tthis.$element = $(this.element);\n\t\t\t\tthis.$sliderElem = $(this.sliderElem);\n\t\t\t}\n\n\t\t\t/*************************************************\n   \t\t\t\t\t\tSetup\n   \t**************************************************/\n\t\t\tthis.eventToCallbackMap = {};\n\t\t\tthis.sliderElem.id = this.options.id;\n\n\t\t\tthis.touchCapable = 'ontouchstart' in window || window.DocumentTouch && document instanceof window.DocumentTouch;\n\n\t\t\tthis.touchX = 0;\n\t\t\tthis.touchY = 0;\n\n\t\t\tthis.tooltip = this.sliderElem.querySelector('.tooltip-main');\n\t\t\tthis.tooltipInner = this.tooltip.querySelector('.tooltip-inner');\n\n\t\t\tthis.tooltip_min = this.sliderElem.querySelector('.tooltip-min');\n\t\t\tthis.tooltipInner_min = this.tooltip_min.querySelector('.tooltip-inner');\n\n\t\t\tthis.tooltip_max = this.sliderElem.querySelector('.tooltip-max');\n\t\t\tthis.tooltipInner_max = this.tooltip_max.querySelector('.tooltip-inner');\n\n\t\t\tif (SliderScale[this.options.scale]) {\n\t\t\t\tthis.options.scale = SliderScale[this.options.scale];\n\t\t\t}\n\n\t\t\tif (updateSlider === true) {\n\t\t\t\t// Reset classes\n\t\t\t\tthis._removeClass(this.sliderElem, 'slider-horizontal');\n\t\t\t\tthis._removeClass(this.sliderElem, 'slider-vertical');\n\t\t\t\tthis._removeClass(this.sliderElem, 'slider-rtl');\n\t\t\t\tthis._removeClass(this.tooltip, 'hide');\n\t\t\t\tthis._removeClass(this.tooltip_min, 'hide');\n\t\t\t\tthis._removeClass(this.tooltip_max, 'hide');\n\n\t\t\t\t// Undo existing inline styles for track\n\t\t\t\t[\"left\", \"right\", \"top\", \"width\", \"height\"].forEach(function (prop) {\n\t\t\t\t\tthis._removeProperty(this.trackLow, prop);\n\t\t\t\t\tthis._removeProperty(this.trackSelection, prop);\n\t\t\t\t\tthis._removeProperty(this.trackHigh, prop);\n\t\t\t\t}, this);\n\n\t\t\t\t// Undo inline styles on handles\n\t\t\t\t[this.handle1, this.handle2].forEach(function (handle) {\n\t\t\t\t\tthis._removeProperty(handle, 'left');\n\t\t\t\t\tthis._removeProperty(handle, 'right');\n\t\t\t\t\tthis._removeProperty(handle, 'top');\n\t\t\t\t}, this);\n\n\t\t\t\t// Undo inline styles and classes on tooltips\n\t\t\t\t[this.tooltip, this.tooltip_min, this.tooltip_max].forEach(function (tooltip) {\n\t\t\t\t\tthis._removeProperty(tooltip, 'left');\n\t\t\t\t\tthis._removeProperty(tooltip, 'right');\n\t\t\t\t\tthis._removeProperty(tooltip, 'top');\n\t\t\t\t\tthis._removeProperty(tooltip, 'margin-left');\n\t\t\t\t\tthis._removeProperty(tooltip, 'margin-right');\n\t\t\t\t\tthis._removeProperty(tooltip, 'margin-top');\n\n\t\t\t\t\tthis._removeClass(tooltip, 'right');\n\t\t\t\t\tthis._removeClass(tooltip, 'left');\n\t\t\t\t\tthis._removeClass(tooltip, 'top');\n\t\t\t\t}, this);\n\t\t\t}\n\n\t\t\tif (this.options.orientation === 'vertical') {\n\t\t\t\tthis._addClass(this.sliderElem, 'slider-vertical');\n\t\t\t\tthis.stylePos = 'top';\n\t\t\t\tthis.mousePos = 'pageY';\n\t\t\t\tthis.sizePos = 'offsetHeight';\n\t\t\t} else {\n\t\t\t\tthis._addClass(this.sliderElem, 'slider-horizontal');\n\t\t\t\tthis.sliderElem.style.width = origWidth;\n\t\t\t\tthis.options.orientation = 'horizontal';\n\t\t\t\tif (this.options.rtl) {\n\t\t\t\t\tthis.stylePos = 'right';\n\t\t\t\t} else {\n\t\t\t\t\tthis.stylePos = 'left';\n\t\t\t\t}\n\t\t\t\tthis.mousePos = 'pageX';\n\t\t\t\tthis.sizePos = 'offsetWidth';\n\t\t\t}\n\t\t\t// specific rtl class\n\t\t\tif (this.options.rtl) {\n\t\t\t\tthis._addClass(this.sliderElem, 'slider-rtl');\n\t\t\t}\n\t\t\tthis._setTooltipPosition();\n\t\t\t/* In case ticks are specified, overwrite the min and max bounds */\n\t\t\tif (Array.isArray(this.options.ticks) && this.options.ticks.length > 0) {\n\t\t\t\tthis.options.max = Math.max.apply(Math, this.options.ticks);\n\t\t\t\tthis.options.min = Math.min.apply(Math, this.options.ticks);\n\t\t\t}\n\n\t\t\tif (Array.isArray(this.options.value)) {\n\t\t\t\tthis.options.range = true;\n\t\t\t\tthis._state.value = this.options.value;\n\t\t\t} else if (this.options.range) {\n\t\t\t\t// User wants a range, but value is not an array\n\t\t\t\tthis._state.value = [this.options.value, this.options.max];\n\t\t\t} else {\n\t\t\t\tthis._state.value = this.options.value;\n\t\t\t}\n\n\t\t\tthis.trackLow = sliderTrackLow || this.trackLow;\n\t\t\tthis.trackSelection = sliderTrackSelection || this.trackSelection;\n\t\t\tthis.trackHigh = sliderTrackHigh || this.trackHigh;\n\n\t\t\tif (this.options.selection === 'none') {\n\t\t\t\tthis._addClass(this.trackLow, 'hide');\n\t\t\t\tthis._addClass(this.trackSelection, 'hide');\n\t\t\t\tthis._addClass(this.trackHigh, 'hide');\n\t\t\t} else if (this.options.selection === 'after' || this.options.selection === 'before') {\n\t\t\t\tthis._removeClass(this.trackLow, 'hide');\n\t\t\t\tthis._removeClass(this.trackSelection, 'hide');\n\t\t\t\tthis._removeClass(this.trackHigh, 'hide');\n\t\t\t}\n\n\t\t\tthis.handle1 = sliderMinHandle || this.handle1;\n\t\t\tthis.handle2 = sliderMaxHandle || this.handle2;\n\n\t\t\tif (updateSlider === true) {\n\t\t\t\t// Reset classes\n\t\t\t\tthis._removeClass(this.handle1, 'round triangle');\n\t\t\t\tthis._removeClass(this.handle2, 'round triangle hide');\n\n\t\t\t\tfor (i = 0; i < this.ticks.length; i++) {\n\t\t\t\t\tthis._removeClass(this.ticks[i], 'round triangle hide');\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tvar availableHandleModifiers = ['round', 'triangle', 'custom'];\n\t\t\tvar isValidHandleType = availableHandleModifiers.indexOf(this.options.handle) !== -1;\n\t\t\tif (isValidHandleType) {\n\t\t\t\tthis._addClass(this.handle1, this.options.handle);\n\t\t\t\tthis._addClass(this.handle2, this.options.handle);\n\n\t\t\t\tfor (i = 0; i < this.ticks.length; i++) {\n\t\t\t\t\tthis._addClass(this.ticks[i], this.options.handle);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tthis._state.offset = this._offset(this.sliderElem);\n\t\t\tthis._state.size = this.sliderElem[this.sizePos];\n\t\t\tthis.setValue(this._state.value);\n\n\t\t\t/******************************************\n   \t\t\t\tBind Event Listeners\n   \t******************************************/\n\n\t\t\t// Bind keyboard handlers\n\t\t\tthis.handle1Keydown = this._keydown.bind(this, 0);\n\t\t\tthis.handle1.addEventListener(\"keydown\", this.handle1Keydown, false);\n\n\t\t\tthis.handle2Keydown = this._keydown.bind(this, 1);\n\t\t\tthis.handle2.addEventListener(\"keydown\", this.handle2Keydown, false);\n\n\t\t\tthis.mousedown = this._mousedown.bind(this);\n\t\t\tthis.touchstart = this._touchstart.bind(this);\n\t\t\tthis.touchmove = this._touchmove.bind(this);\n\n\t\t\tif (this.touchCapable) {\n\t\t\t\t// Test for passive event support\n\t\t\t\tvar supportsPassive = false;\n\t\t\t\ttry {\n\t\t\t\t\tvar opts = Object.defineProperty({}, 'passive', {\n\t\t\t\t\t\tget: function get() {\n\t\t\t\t\t\t\tsupportsPassive = true;\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t\twindow.addEventListener(\"test\", null, opts);\n\t\t\t\t} catch (e) {}\n\t\t\t\t// Use our detect's results. passive applied if supported, capture will be false either way.\n\t\t\t\tvar eventOptions = supportsPassive ? { passive: true } : false;\n\t\t\t\t// Bind touch handlers\n\t\t\t\tthis.sliderElem.addEventListener(\"touchstart\", this.touchstart, eventOptions);\n\t\t\t\tthis.sliderElem.addEventListener(\"touchmove\", this.touchmove, eventOptions);\n\t\t\t}\n\t\t\tthis.sliderElem.addEventListener(\"mousedown\", this.mousedown, false);\n\n\t\t\t// Bind window handlers\n\t\t\tthis.resize = this._resize.bind(this);\n\t\t\twindow.addEventListener(\"resize\", this.resize, false);\n\n\t\t\t// Bind tooltip-related handlers\n\t\t\tif (this.options.tooltip === 'hide') {\n\t\t\t\tthis._addClass(this.tooltip, 'hide');\n\t\t\t\tthis._addClass(this.tooltip_min, 'hide');\n\t\t\t\tthis._addClass(this.tooltip_max, 'hide');\n\t\t\t} else if (this.options.tooltip === 'always') {\n\t\t\t\tthis._showTooltip();\n\t\t\t\tthis._alwaysShowTooltip = true;\n\t\t\t} else {\n\t\t\t\tthis.showTooltip = this._showTooltip.bind(this);\n\t\t\t\tthis.hideTooltip = this._hideTooltip.bind(this);\n\n\t\t\t\tif (this.options.ticks_tooltip) {\n\t\t\t\t\tvar callbackHandle = this._addTickListener();\n\t\t\t\t\t//create handle1 listeners and store references in map\n\t\t\t\t\tvar mouseEnter = callbackHandle.addMouseEnter(this, this.handle1);\n\t\t\t\t\tvar mouseLeave = callbackHandle.addMouseLeave(this, this.handle1);\n\t\t\t\t\tthis.handleCallbackMap.handle1 = {\n\t\t\t\t\t\tmouseEnter: mouseEnter,\n\t\t\t\t\t\tmouseLeave: mouseLeave\n\t\t\t\t\t};\n\t\t\t\t\t//create handle2 listeners and store references in map\n\t\t\t\t\tmouseEnter = callbackHandle.addMouseEnter(this, this.handle2);\n\t\t\t\t\tmouseLeave = callbackHandle.addMouseLeave(this, this.handle2);\n\t\t\t\t\tthis.handleCallbackMap.handle2 = {\n\t\t\t\t\t\tmouseEnter: mouseEnter,\n\t\t\t\t\t\tmouseLeave: mouseLeave\n\t\t\t\t\t};\n\t\t\t\t} else {\n\t\t\t\t\tthis.sliderElem.addEventListener(\"mouseenter\", this.showTooltip, false);\n\t\t\t\t\tthis.sliderElem.addEventListener(\"mouseleave\", this.hideTooltip, false);\n\t\t\t\t}\n\n\t\t\t\tthis.handle1.addEventListener(\"focus\", this.showTooltip, false);\n\t\t\t\tthis.handle1.addEventListener(\"blur\", this.hideTooltip, false);\n\n\t\t\t\tthis.handle2.addEventListener(\"focus\", this.showTooltip, false);\n\t\t\t\tthis.handle2.addEventListener(\"blur\", this.hideTooltip, false);\n\t\t\t}\n\n\t\t\tif (this.options.enabled) {\n\t\t\t\tthis.enable();\n\t\t\t} else {\n\t\t\t\tthis.disable();\n\t\t\t}\n\t\t}\n\n\t\t/*************************************************\n  \t\t\t\tINSTANCE PROPERTIES/METHODS\n  \t- Any methods bound to the prototype are considered\n  part of the plugin's `public` interface\n  \t**************************************************/\n\t\tSlider.prototype = {\n\t\t\t_init: function _init() {}, // NOTE: Must exist to support bridget\n\n\t\t\tconstructor: Slider,\n\n\t\t\tdefaultOptions: {\n\t\t\t\tid: \"\",\n\t\t\t\tmin: 0,\n\t\t\t\tmax: 10,\n\t\t\t\tstep: 1,\n\t\t\t\tprecision: 0,\n\t\t\t\torientation: 'horizontal',\n\t\t\t\tvalue: 5,\n\t\t\t\trange: false,\n\t\t\t\tselection: 'before',\n\t\t\t\ttooltip: 'show',\n\t\t\t\ttooltip_split: false,\n\t\t\t\thandle: 'round',\n\t\t\t\treversed: false,\n\t\t\t\trtl: 'auto',\n\t\t\t\tenabled: true,\n\t\t\t\tformatter: function formatter(val) {\n\t\t\t\t\tif (Array.isArray(val)) {\n\t\t\t\t\t\treturn val[0] + \" : \" + val[1];\n\t\t\t\t\t} else {\n\t\t\t\t\t\treturn val;\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\tnatural_arrow_keys: false,\n\t\t\t\tticks: [],\n\t\t\t\tticks_positions: [],\n\t\t\t\tticks_labels: [],\n\t\t\t\tticks_snap_bounds: 0,\n\t\t\t\tticks_tooltip: false,\n\t\t\t\tscale: 'linear',\n\t\t\t\tfocus: false,\n\t\t\t\ttooltip_position: null,\n\t\t\t\tlabelledby: null,\n\t\t\t\trangeHighlights: []\n\t\t\t},\n\n\t\t\tgetElement: function getElement() {\n\t\t\t\treturn this.sliderElem;\n\t\t\t},\n\n\t\t\tgetValue: function getValue() {\n\t\t\t\tif (this.options.range) {\n\t\t\t\t\treturn this._state.value;\n\t\t\t\t} else {\n\t\t\t\t\treturn this._state.value[0];\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tsetValue: function setValue(val, triggerSlideEvent, triggerChangeEvent) {\n\t\t\t\tif (!val) {\n\t\t\t\t\tval = 0;\n\t\t\t\t}\n\t\t\t\tvar oldValue = this.getValue();\n\t\t\t\tthis._state.value = this._validateInputValue(val);\n\t\t\t\tvar applyPrecision = this._applyPrecision.bind(this);\n\n\t\t\t\tif (this.options.range) {\n\t\t\t\t\tthis._state.value[0] = applyPrecision(this._state.value[0]);\n\t\t\t\t\tthis._state.value[1] = applyPrecision(this._state.value[1]);\n\n\t\t\t\t\tthis._state.value[0] = Math.max(this.options.min, Math.min(this.options.max, this._state.value[0]));\n\t\t\t\t\tthis._state.value[1] = Math.max(this.options.min, Math.min(this.options.max, this._state.value[1]));\n\t\t\t\t} else {\n\t\t\t\t\tthis._state.value = applyPrecision(this._state.value);\n\t\t\t\t\tthis._state.value = [Math.max(this.options.min, Math.min(this.options.max, this._state.value))];\n\t\t\t\t\tthis._addClass(this.handle2, 'hide');\n\t\t\t\t\tif (this.options.selection === 'after') {\n\t\t\t\t\t\tthis._state.value[1] = this.options.max;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tthis._state.value[1] = this.options.min;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif (this.options.max > this.options.min) {\n\t\t\t\t\tthis._state.percentage = [this._toPercentage(this._state.value[0]), this._toPercentage(this._state.value[1]), this.options.step * 100 / (this.options.max - this.options.min)];\n\t\t\t\t} else {\n\t\t\t\t\tthis._state.percentage = [0, 0, 100];\n\t\t\t\t}\n\n\t\t\t\tthis._layout();\n\t\t\t\tvar newValue = this.options.range ? this._state.value : this._state.value[0];\n\n\t\t\t\tthis._setDataVal(newValue);\n\t\t\t\tif (triggerSlideEvent === true) {\n\t\t\t\t\tthis._trigger('slide', newValue);\n\t\t\t\t}\n\t\t\t\tif (oldValue !== newValue && triggerChangeEvent === true) {\n\t\t\t\t\tthis._trigger('change', {\n\t\t\t\t\t\toldValue: oldValue,\n\t\t\t\t\t\tnewValue: newValue\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\treturn this;\n\t\t\t},\n\n\t\t\tdestroy: function destroy() {\n\t\t\t\t// Remove event handlers on slider elements\n\t\t\t\tthis._removeSliderEventHandlers();\n\n\t\t\t\t// Remove the slider from the DOM\n\t\t\t\tthis.sliderElem.parentNode.removeChild(this.sliderElem);\n\t\t\t\t/* Show original <input> element */\n\t\t\t\tthis.element.style.display = \"\";\n\n\t\t\t\t// Clear out custom event bindings\n\t\t\t\tthis._cleanUpEventCallbacksMap();\n\n\t\t\t\t// Remove data values\n\t\t\t\tthis.element.removeAttribute(\"data\");\n\n\t\t\t\t// Remove JQuery handlers/data\n\t\t\t\tif ($) {\n\t\t\t\t\tthis._unbindJQueryEventHandlers();\n\t\t\t\t\tthis.$element.removeData('slider');\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tdisable: function disable() {\n\t\t\t\tthis._state.enabled = false;\n\t\t\t\tthis.handle1.removeAttribute(\"tabindex\");\n\t\t\t\tthis.handle2.removeAttribute(\"tabindex\");\n\t\t\t\tthis._addClass(this.sliderElem, 'slider-disabled');\n\t\t\t\tthis._trigger('slideDisabled');\n\n\t\t\t\treturn this;\n\t\t\t},\n\n\t\t\tenable: function enable() {\n\t\t\t\tthis._state.enabled = true;\n\t\t\t\tthis.handle1.setAttribute(\"tabindex\", 0);\n\t\t\t\tthis.handle2.setAttribute(\"tabindex\", 0);\n\t\t\t\tthis._removeClass(this.sliderElem, 'slider-disabled');\n\t\t\t\tthis._trigger('slideEnabled');\n\n\t\t\t\treturn this;\n\t\t\t},\n\n\t\t\ttoggle: function toggle() {\n\t\t\t\tif (this._state.enabled) {\n\t\t\t\t\tthis.disable();\n\t\t\t\t} else {\n\t\t\t\t\tthis.enable();\n\t\t\t\t}\n\t\t\t\treturn this;\n\t\t\t},\n\n\t\t\tisEnabled: function isEnabled() {\n\t\t\t\treturn this._state.enabled;\n\t\t\t},\n\n\t\t\ton: function on(evt, callback) {\n\t\t\t\tthis._bindNonQueryEventHandler(evt, callback);\n\t\t\t\treturn this;\n\t\t\t},\n\n\t\t\toff: function off(evt, callback) {\n\t\t\t\tif ($) {\n\t\t\t\t\tthis.$element.off(evt, callback);\n\t\t\t\t\tthis.$sliderElem.off(evt, callback);\n\t\t\t\t} else {\n\t\t\t\t\tthis._unbindNonQueryEventHandler(evt, callback);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tgetAttribute: function getAttribute(attribute) {\n\t\t\t\tif (attribute) {\n\t\t\t\t\treturn this.options[attribute];\n\t\t\t\t} else {\n\t\t\t\t\treturn this.options;\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tsetAttribute: function setAttribute(attribute, value) {\n\t\t\t\tthis.options[attribute] = value;\n\t\t\t\treturn this;\n\t\t\t},\n\n\t\t\trefresh: function refresh() {\n\t\t\t\tthis._removeSliderEventHandlers();\n\t\t\t\tcreateNewSlider.call(this, this.element, this.options);\n\t\t\t\tif ($) {\n\t\t\t\t\t// Bind new instance of slider to the element\n\t\t\t\t\t$.data(this.element, 'slider', this);\n\t\t\t\t}\n\t\t\t\treturn this;\n\t\t\t},\n\n\t\t\trelayout: function relayout() {\n\t\t\t\tthis._resize();\n\t\t\t\tthis._layout();\n\t\t\t\treturn this;\n\t\t\t},\n\n\t\t\t/******************************+\n   \t\t\t\tHELPERS\n   \t- Any method that is not part of the public interface.\n   - Place it underneath this comment block and write its signature like so:\n   \t\t_fnName : function() {...}\n   \t********************************/\n\t\t\t_removeSliderEventHandlers: function _removeSliderEventHandlers() {\n\t\t\t\t// Remove keydown event listeners\n\t\t\t\tthis.handle1.removeEventListener(\"keydown\", this.handle1Keydown, false);\n\t\t\t\tthis.handle2.removeEventListener(\"keydown\", this.handle2Keydown, false);\n\n\t\t\t\t//remove the listeners from the ticks and handles if they had their own listeners\n\t\t\t\tif (this.options.ticks_tooltip) {\n\t\t\t\t\tvar ticks = this.ticksContainer.getElementsByClassName('slider-tick');\n\t\t\t\t\tfor (var i = 0; i < ticks.length; i++) {\n\t\t\t\t\t\tticks[i].removeEventListener('mouseenter', this.ticksCallbackMap[i].mouseEnter, false);\n\t\t\t\t\t\tticks[i].removeEventListener('mouseleave', this.ticksCallbackMap[i].mouseLeave, false);\n\t\t\t\t\t}\n\t\t\t\t\tthis.handle1.removeEventListener('mouseenter', this.handleCallbackMap.handle1.mouseEnter, false);\n\t\t\t\t\tthis.handle2.removeEventListener('mouseenter', this.handleCallbackMap.handle2.mouseEnter, false);\n\t\t\t\t\tthis.handle1.removeEventListener('mouseleave', this.handleCallbackMap.handle1.mouseLeave, false);\n\t\t\t\t\tthis.handle2.removeEventListener('mouseleave', this.handleCallbackMap.handle2.mouseLeave, false);\n\t\t\t\t}\n\n\t\t\t\tthis.handleCallbackMap = null;\n\t\t\t\tthis.ticksCallbackMap = null;\n\n\t\t\t\tif (this.showTooltip) {\n\t\t\t\t\tthis.handle1.removeEventListener(\"focus\", this.showTooltip, false);\n\t\t\t\t\tthis.handle2.removeEventListener(\"focus\", this.showTooltip, false);\n\t\t\t\t}\n\t\t\t\tif (this.hideTooltip) {\n\t\t\t\t\tthis.handle1.removeEventListener(\"blur\", this.hideTooltip, false);\n\t\t\t\t\tthis.handle2.removeEventListener(\"blur\", this.hideTooltip, false);\n\t\t\t\t}\n\n\t\t\t\t// Remove event listeners from sliderElem\n\t\t\t\tif (this.showTooltip) {\n\t\t\t\t\tthis.sliderElem.removeEventListener(\"mouseenter\", this.showTooltip, false);\n\t\t\t\t}\n\t\t\t\tif (this.hideTooltip) {\n\t\t\t\t\tthis.sliderElem.removeEventListener(\"mouseleave\", this.hideTooltip, false);\n\t\t\t\t}\n\t\t\t\tthis.sliderElem.removeEventListener(\"touchstart\", this.touchstart, false);\n\t\t\t\tthis.sliderElem.removeEventListener(\"touchmove\", this.touchmove, false);\n\t\t\t\tthis.sliderElem.removeEventListener(\"mousedown\", this.mousedown, false);\n\n\t\t\t\t// Remove window event listener\n\t\t\t\twindow.removeEventListener(\"resize\", this.resize, false);\n\t\t\t},\n\t\t\t_bindNonQueryEventHandler: function _bindNonQueryEventHandler(evt, callback) {\n\t\t\t\tif (this.eventToCallbackMap[evt] === undefined) {\n\t\t\t\t\tthis.eventToCallbackMap[evt] = [];\n\t\t\t\t}\n\t\t\t\tthis.eventToCallbackMap[evt].push(callback);\n\t\t\t},\n\t\t\t_unbindNonQueryEventHandler: function _unbindNonQueryEventHandler(evt, callback) {\n\t\t\t\tvar callbacks = this.eventToCallbackMap[evt];\n\t\t\t\tif (callbacks !== undefined) {\n\t\t\t\t\tfor (var i = 0; i < callbacks.length; i++) {\n\t\t\t\t\t\tif (callbacks[i] === callback) {\n\t\t\t\t\t\t\tcallbacks.splice(i, 1);\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\t\t\t_cleanUpEventCallbacksMap: function _cleanUpEventCallbacksMap() {\n\t\t\t\tvar eventNames = Object.keys(this.eventToCallbackMap);\n\t\t\t\tfor (var i = 0; i < eventNames.length; i++) {\n\t\t\t\t\tvar eventName = eventNames[i];\n\t\t\t\t\tdelete this.eventToCallbackMap[eventName];\n\t\t\t\t}\n\t\t\t},\n\t\t\t_showTooltip: function _showTooltip() {\n\t\t\t\tif (this.options.tooltip_split === false) {\n\t\t\t\t\tthis._addClass(this.tooltip, 'in');\n\t\t\t\t\tthis.tooltip_min.style.display = 'none';\n\t\t\t\t\tthis.tooltip_max.style.display = 'none';\n\t\t\t\t} else {\n\t\t\t\t\tthis._addClass(this.tooltip_min, 'in');\n\t\t\t\t\tthis._addClass(this.tooltip_max, 'in');\n\t\t\t\t\tthis.tooltip.style.display = 'none';\n\t\t\t\t}\n\t\t\t\tthis._state.over = true;\n\t\t\t},\n\t\t\t_hideTooltip: function _hideTooltip() {\n\t\t\t\tif (this._state.inDrag === false && this.alwaysShowTooltip !== true) {\n\t\t\t\t\tthis._removeClass(this.tooltip, 'in');\n\t\t\t\t\tthis._removeClass(this.tooltip_min, 'in');\n\t\t\t\t\tthis._removeClass(this.tooltip_max, 'in');\n\t\t\t\t}\n\t\t\t\tthis._state.over = false;\n\t\t\t},\n\t\t\t_setToolTipOnMouseOver: function _setToolTipOnMouseOver(tempState) {\n\t\t\t\tvar formattedTooltipVal = this.options.formatter(!tempState ? this._state.value[0] : tempState.value[0]);\n\t\t\t\tvar positionPercentages = !tempState ? getPositionPercentages(this._state, this.options.reversed) : getPositionPercentages(tempState, this.options.reversed);\n\t\t\t\tthis._setText(this.tooltipInner, formattedTooltipVal);\n\n\t\t\t\tthis.tooltip.style[this.stylePos] = positionPercentages[0] + \"%\";\n\t\t\t\tif (this.options.orientation === 'vertical') {\n\t\t\t\t\tthis._css(this.tooltip, \"margin-\" + this.stylePos, -this.tooltip.offsetHeight / 2 + \"px\");\n\t\t\t\t} else {\n\t\t\t\t\tthis._css(this.tooltip, \"margin-\" + this.stylePos, -this.tooltip.offsetWidth / 2 + \"px\");\n\t\t\t\t}\n\n\t\t\t\tfunction getPositionPercentages(state, reversed) {\n\t\t\t\t\tif (reversed) {\n\t\t\t\t\t\treturn [100 - state.percentage[0], this.options.range ? 100 - state.percentage[1] : state.percentage[1]];\n\t\t\t\t\t}\n\t\t\t\t\treturn [state.percentage[0], state.percentage[1]];\n\t\t\t\t}\n\t\t\t},\n\t\t\t_addTickListener: function _addTickListener() {\n\t\t\t\treturn {\n\t\t\t\t\taddMouseEnter: function addMouseEnter(reference, tick, index) {\n\t\t\t\t\t\tvar enter = function enter() {\n\t\t\t\t\t\t\tvar tempState = reference._state;\n\t\t\t\t\t\t\tvar idString = index >= 0 ? index : this.attributes['aria-valuenow'].value;\n\t\t\t\t\t\t\tvar hoverIndex = parseInt(idString, 10);\n\t\t\t\t\t\t\ttempState.value[0] = hoverIndex;\n\t\t\t\t\t\t\ttempState.percentage[0] = reference.options.ticks_positions[hoverIndex];\n\t\t\t\t\t\t\treference._setToolTipOnMouseOver(tempState);\n\t\t\t\t\t\t\treference._showTooltip();\n\t\t\t\t\t\t};\n\t\t\t\t\t\ttick.addEventListener(\"mouseenter\", enter, false);\n\t\t\t\t\t\treturn enter;\n\t\t\t\t\t},\n\t\t\t\t\taddMouseLeave: function addMouseLeave(reference, tick) {\n\t\t\t\t\t\tvar leave = function leave() {\n\t\t\t\t\t\t\treference._hideTooltip();\n\t\t\t\t\t\t};\n\t\t\t\t\t\ttick.addEventListener(\"mouseleave\", leave, false);\n\t\t\t\t\t\treturn leave;\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t},\n\t\t\t_layout: function _layout() {\n\t\t\t\tvar positionPercentages;\n\n\t\t\t\tif (this.options.reversed) {\n\t\t\t\t\tpositionPercentages = [100 - this._state.percentage[0], this.options.range ? 100 - this._state.percentage[1] : this._state.percentage[1]];\n\t\t\t\t} else {\n\t\t\t\t\tpositionPercentages = [this._state.percentage[0], this._state.percentage[1]];\n\t\t\t\t}\n\n\t\t\t\tthis.handle1.style[this.stylePos] = positionPercentages[0] + \"%\";\n\t\t\t\tthis.handle1.setAttribute('aria-valuenow', this._state.value[0]);\n\t\t\t\tif (isNaN(this.options.formatter(this._state.value[0]))) {\n\t\t\t\t\tthis.handle1.setAttribute('aria-valuetext', this.options.formatter(this._state.value[0]));\n\t\t\t\t}\n\n\t\t\t\tthis.handle2.style[this.stylePos] = positionPercentages[1] + \"%\";\n\t\t\t\tthis.handle2.setAttribute('aria-valuenow', this._state.value[1]);\n\t\t\t\tif (isNaN(this.options.formatter(this._state.value[1]))) {\n\t\t\t\t\tthis.handle2.setAttribute('aria-valuetext', this.options.formatter(this._state.value[1]));\n\t\t\t\t}\n\n\t\t\t\t/* Position highlight range elements */\n\t\t\t\tif (this.rangeHighlightElements.length > 0 && Array.isArray(this.options.rangeHighlights) && this.options.rangeHighlights.length > 0) {\n\t\t\t\t\tfor (var _i = 0; _i < this.options.rangeHighlights.length; _i++) {\n\t\t\t\t\t\tvar startPercent = this._toPercentage(this.options.rangeHighlights[_i].start);\n\t\t\t\t\t\tvar endPercent = this._toPercentage(this.options.rangeHighlights[_i].end);\n\n\t\t\t\t\t\tif (this.options.reversed) {\n\t\t\t\t\t\t\tvar sp = 100 - endPercent;\n\t\t\t\t\t\t\tendPercent = 100 - startPercent;\n\t\t\t\t\t\t\tstartPercent = sp;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tvar currentRange = this._createHighlightRange(startPercent, endPercent);\n\n\t\t\t\t\t\tif (currentRange) {\n\t\t\t\t\t\t\tif (this.options.orientation === 'vertical') {\n\t\t\t\t\t\t\t\tthis.rangeHighlightElements[_i].style.top = currentRange.start + \"%\";\n\t\t\t\t\t\t\t\tthis.rangeHighlightElements[_i].style.height = currentRange.size + \"%\";\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tif (this.options.rtl) {\n\t\t\t\t\t\t\t\t\tthis.rangeHighlightElements[_i].style.right = currentRange.start + \"%\";\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tthis.rangeHighlightElements[_i].style.left = currentRange.start + \"%\";\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tthis.rangeHighlightElements[_i].style.width = currentRange.size + \"%\";\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tthis.rangeHighlightElements[_i].style.display = \"none\";\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t/* Position ticks and labels */\n\t\t\t\tif (Array.isArray(this.options.ticks) && this.options.ticks.length > 0) {\n\n\t\t\t\t\tvar styleSize = this.options.orientation === 'vertical' ? 'height' : 'width';\n\t\t\t\t\tvar styleMargin;\n\t\t\t\t\tif (this.options.orientation === 'vertical') {\n\t\t\t\t\t\tstyleMargin = 'marginTop';\n\t\t\t\t\t} else {\n\t\t\t\t\t\tif (this.options.rtl) {\n\t\t\t\t\t\t\tstyleMargin = 'marginRight';\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tstyleMargin = 'marginLeft';\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tvar labelSize = this._state.size / (this.options.ticks.length - 1);\n\n\t\t\t\t\tif (this.tickLabelContainer) {\n\t\t\t\t\t\tvar extraMargin = 0;\n\t\t\t\t\t\tif (this.options.ticks_positions.length === 0) {\n\t\t\t\t\t\t\tif (this.options.orientation !== 'vertical') {\n\t\t\t\t\t\t\t\tthis.tickLabelContainer.style[styleMargin] = -labelSize / 2 + \"px\";\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\textraMargin = this.tickLabelContainer.offsetHeight;\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t/* Chidren are position absolute, calculate height by finding the max offsetHeight of a child */\n\t\t\t\t\t\t\tfor (i = 0; i < this.tickLabelContainer.childNodes.length; i++) {\n\t\t\t\t\t\t\t\tif (this.tickLabelContainer.childNodes[i].offsetHeight > extraMargin) {\n\t\t\t\t\t\t\t\t\textraMargin = this.tickLabelContainer.childNodes[i].offsetHeight;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif (this.options.orientation === 'horizontal') {\n\t\t\t\t\t\t\tthis.sliderElem.style.marginBottom = extraMargin + \"px\";\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tfor (var i = 0; i < this.options.ticks.length; i++) {\n\n\t\t\t\t\t\tvar percentage = this.options.ticks_positions[i] || this._toPercentage(this.options.ticks[i]);\n\n\t\t\t\t\t\tif (this.options.reversed) {\n\t\t\t\t\t\t\tpercentage = 100 - percentage;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tthis.ticks[i].style[this.stylePos] = percentage + \"%\";\n\n\t\t\t\t\t\t/* Set class labels to denote whether ticks are in the selection */\n\t\t\t\t\t\tthis._removeClass(this.ticks[i], 'in-selection');\n\t\t\t\t\t\tif (!this.options.range) {\n\t\t\t\t\t\t\tif (this.options.selection === 'after' && percentage >= positionPercentages[0]) {\n\t\t\t\t\t\t\t\tthis._addClass(this.ticks[i], 'in-selection');\n\t\t\t\t\t\t\t} else if (this.options.selection === 'before' && percentage <= positionPercentages[0]) {\n\t\t\t\t\t\t\t\tthis._addClass(this.ticks[i], 'in-selection');\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t} else if (percentage >= positionPercentages[0] && percentage <= positionPercentages[1]) {\n\t\t\t\t\t\t\tthis._addClass(this.ticks[i], 'in-selection');\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (this.tickLabels[i]) {\n\t\t\t\t\t\t\tthis.tickLabels[i].style[styleSize] = labelSize + \"px\";\n\n\t\t\t\t\t\t\tif (this.options.orientation !== 'vertical' && this.options.ticks_positions[i] !== undefined) {\n\t\t\t\t\t\t\t\tthis.tickLabels[i].style.position = 'absolute';\n\t\t\t\t\t\t\t\tthis.tickLabels[i].style[this.stylePos] = percentage + \"%\";\n\t\t\t\t\t\t\t\tthis.tickLabels[i].style[styleMargin] = -labelSize / 2 + 'px';\n\t\t\t\t\t\t\t} else if (this.options.orientation === 'vertical') {\n\t\t\t\t\t\t\t\tif (this.options.rtl) {\n\t\t\t\t\t\t\t\t\tthis.tickLabels[i].style['marginRight'] = this.sliderElem.offsetWidth + \"px\";\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tthis.tickLabels[i].style['marginLeft'] = this.sliderElem.offsetWidth + \"px\";\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tthis.tickLabelContainer.style[styleMargin] = this.sliderElem.offsetWidth / 2 * -1 + 'px';\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tvar formattedTooltipVal;\n\n\t\t\t\tif (this.options.range) {\n\t\t\t\t\tformattedTooltipVal = this.options.formatter(this._state.value);\n\t\t\t\t\tthis._setText(this.tooltipInner, formattedTooltipVal);\n\t\t\t\t\tthis.tooltip.style[this.stylePos] = (positionPercentages[1] + positionPercentages[0]) / 2 + \"%\";\n\n\t\t\t\t\tif (this.options.orientation === 'vertical') {\n\t\t\t\t\t\tthis._css(this.tooltip, \"margin-\" + this.stylePos, -this.tooltip.offsetHeight / 2 + \"px\");\n\t\t\t\t\t} else {\n\t\t\t\t\t\tthis._css(this.tooltip, \"margin-\" + this.stylePos, -this.tooltip.offsetWidth / 2 + \"px\");\n\t\t\t\t\t}\n\n\t\t\t\t\tvar innerTooltipMinText = this.options.formatter(this._state.value[0]);\n\t\t\t\t\tthis._setText(this.tooltipInner_min, innerTooltipMinText);\n\n\t\t\t\t\tvar innerTooltipMaxText = this.options.formatter(this._state.value[1]);\n\t\t\t\t\tthis._setText(this.tooltipInner_max, innerTooltipMaxText);\n\n\t\t\t\t\tthis.tooltip_min.style[this.stylePos] = positionPercentages[0] + \"%\";\n\n\t\t\t\t\tif (this.options.orientation === 'vertical') {\n\t\t\t\t\t\tthis._css(this.tooltip_min, \"margin-\" + this.stylePos, -this.tooltip_min.offsetHeight / 2 + \"px\");\n\t\t\t\t\t} else {\n\t\t\t\t\t\tthis._css(this.tooltip_min, \"margin-\" + this.stylePos, -this.tooltip_min.offsetWidth / 2 + \"px\");\n\t\t\t\t\t}\n\n\t\t\t\t\tthis.tooltip_max.style[this.stylePos] = positionPercentages[1] + \"%\";\n\n\t\t\t\t\tif (this.options.orientation === 'vertical') {\n\t\t\t\t\t\tthis._css(this.tooltip_max, \"margin-\" + this.stylePos, -this.tooltip_max.offsetHeight / 2 + \"px\");\n\t\t\t\t\t} else {\n\t\t\t\t\t\tthis._css(this.tooltip_max, \"margin-\" + this.stylePos, -this.tooltip_max.offsetWidth / 2 + \"px\");\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\tformattedTooltipVal = this.options.formatter(this._state.value[0]);\n\t\t\t\t\tthis._setText(this.tooltipInner, formattedTooltipVal);\n\n\t\t\t\t\tthis.tooltip.style[this.stylePos] = positionPercentages[0] + \"%\";\n\t\t\t\t\tif (this.options.orientation === 'vertical') {\n\t\t\t\t\t\tthis._css(this.tooltip, \"margin-\" + this.stylePos, -this.tooltip.offsetHeight / 2 + \"px\");\n\t\t\t\t\t} else {\n\t\t\t\t\t\tthis._css(this.tooltip, \"margin-\" + this.stylePos, -this.tooltip.offsetWidth / 2 + \"px\");\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif (this.options.orientation === 'vertical') {\n\t\t\t\t\tthis.trackLow.style.top = '0';\n\t\t\t\t\tthis.trackLow.style.height = Math.min(positionPercentages[0], positionPercentages[1]) + '%';\n\n\t\t\t\t\tthis.trackSelection.style.top = Math.min(positionPercentages[0], positionPercentages[1]) + '%';\n\t\t\t\t\tthis.trackSelection.style.height = Math.abs(positionPercentages[0] - positionPercentages[1]) + '%';\n\n\t\t\t\t\tthis.trackHigh.style.bottom = '0';\n\t\t\t\t\tthis.trackHigh.style.height = 100 - Math.min(positionPercentages[0], positionPercentages[1]) - Math.abs(positionPercentages[0] - positionPercentages[1]) + '%';\n\t\t\t\t} else {\n\t\t\t\t\tif (this.stylePos === 'right') {\n\t\t\t\t\t\tthis.trackLow.style.right = '0';\n\t\t\t\t\t} else {\n\t\t\t\t\t\tthis.trackLow.style.left = '0';\n\t\t\t\t\t}\n\t\t\t\t\tthis.trackLow.style.width = Math.min(positionPercentages[0], positionPercentages[1]) + '%';\n\n\t\t\t\t\tif (this.stylePos === 'right') {\n\t\t\t\t\t\tthis.trackSelection.style.right = Math.min(positionPercentages[0], positionPercentages[1]) + '%';\n\t\t\t\t\t} else {\n\t\t\t\t\t\tthis.trackSelection.style.left = Math.min(positionPercentages[0], positionPercentages[1]) + '%';\n\t\t\t\t\t}\n\t\t\t\t\tthis.trackSelection.style.width = Math.abs(positionPercentages[0] - positionPercentages[1]) + '%';\n\n\t\t\t\t\tif (this.stylePos === 'right') {\n\t\t\t\t\t\tthis.trackHigh.style.left = '0';\n\t\t\t\t\t} else {\n\t\t\t\t\t\tthis.trackHigh.style.right = '0';\n\t\t\t\t\t}\n\t\t\t\t\tthis.trackHigh.style.width = 100 - Math.min(positionPercentages[0], positionPercentages[1]) - Math.abs(positionPercentages[0] - positionPercentages[1]) + '%';\n\n\t\t\t\t\tvar offset_min = this.tooltip_min.getBoundingClientRect();\n\t\t\t\t\tvar offset_max = this.tooltip_max.getBoundingClientRect();\n\n\t\t\t\t\tif (this.options.tooltip_position === 'bottom') {\n\t\t\t\t\t\tif (offset_min.right > offset_max.left) {\n\t\t\t\t\t\t\tthis._removeClass(this.tooltip_max, 'bottom');\n\t\t\t\t\t\t\tthis._addClass(this.tooltip_max, 'top');\n\t\t\t\t\t\t\tthis.tooltip_max.style.top = '';\n\t\t\t\t\t\t\tthis.tooltip_max.style.bottom = 22 + 'px';\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tthis._removeClass(this.tooltip_max, 'top');\n\t\t\t\t\t\t\tthis._addClass(this.tooltip_max, 'bottom');\n\t\t\t\t\t\t\tthis.tooltip_max.style.top = this.tooltip_min.style.top;\n\t\t\t\t\t\t\tthis.tooltip_max.style.bottom = '';\n\t\t\t\t\t\t}\n\t\t\t\t\t} else {\n\t\t\t\t\t\tif (offset_min.right > offset_max.left) {\n\t\t\t\t\t\t\tthis._removeClass(this.tooltip_max, 'top');\n\t\t\t\t\t\t\tthis._addClass(this.tooltip_max, 'bottom');\n\t\t\t\t\t\t\tthis.tooltip_max.style.top = 18 + 'px';\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tthis._removeClass(this.tooltip_max, 'bottom');\n\t\t\t\t\t\t\tthis._addClass(this.tooltip_max, 'top');\n\t\t\t\t\t\t\tthis.tooltip_max.style.top = this.tooltip_min.style.top;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\t\t\t_createHighlightRange: function _createHighlightRange(start, end) {\n\t\t\t\tif (this._isHighlightRange(start, end)) {\n\t\t\t\t\tif (start > end) {\n\t\t\t\t\t\treturn { 'start': end, 'size': start - end };\n\t\t\t\t\t}\n\t\t\t\t\treturn { 'start': start, 'size': end - start };\n\t\t\t\t}\n\t\t\t\treturn null;\n\t\t\t},\n\t\t\t_isHighlightRange: function _isHighlightRange(start, end) {\n\t\t\t\tif (0 <= start && start <= 100 && 0 <= end && end <= 100) {\n\t\t\t\t\treturn true;\n\t\t\t\t} else {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t},\n\t\t\t_resize: function _resize(ev) {\n\t\t\t\t/*jshint unused:false*/\n\t\t\t\tthis._state.offset = this._offset(this.sliderElem);\n\t\t\t\tthis._state.size = this.sliderElem[this.sizePos];\n\t\t\t\tthis._layout();\n\t\t\t},\n\t\t\t_removeProperty: function _removeProperty(element, prop) {\n\t\t\t\tif (element.style.removeProperty) {\n\t\t\t\t\telement.style.removeProperty(prop);\n\t\t\t\t} else {\n\t\t\t\t\telement.style.removeAttribute(prop);\n\t\t\t\t}\n\t\t\t},\n\t\t\t_mousedown: function _mousedown(ev) {\n\t\t\t\tif (!this._state.enabled) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\tthis._state.offset = this._offset(this.sliderElem);\n\t\t\t\tthis._state.size = this.sliderElem[this.sizePos];\n\n\t\t\t\tvar percentage = this._getPercentage(ev);\n\n\t\t\t\tif (this.options.range) {\n\t\t\t\t\tvar diff1 = Math.abs(this._state.percentage[0] - percentage);\n\t\t\t\t\tvar diff2 = Math.abs(this._state.percentage[1] - percentage);\n\t\t\t\t\tthis._state.dragged = diff1 < diff2 ? 0 : 1;\n\t\t\t\t\tthis._adjustPercentageForRangeSliders(percentage);\n\t\t\t\t} else {\n\t\t\t\t\tthis._state.dragged = 0;\n\t\t\t\t}\n\n\t\t\t\tthis._state.percentage[this._state.dragged] = percentage;\n\t\t\t\tthis._layout();\n\n\t\t\t\tif (this.touchCapable) {\n\t\t\t\t\tdocument.removeEventListener(\"touchmove\", this.mousemove, false);\n\t\t\t\t\tdocument.removeEventListener(\"touchend\", this.mouseup, false);\n\t\t\t\t}\n\n\t\t\t\tif (this.mousemove) {\n\t\t\t\t\tdocument.removeEventListener(\"mousemove\", this.mousemove, false);\n\t\t\t\t}\n\t\t\t\tif (this.mouseup) {\n\t\t\t\t\tdocument.removeEventListener(\"mouseup\", this.mouseup, false);\n\t\t\t\t}\n\n\t\t\t\tthis.mousemove = this._mousemove.bind(this);\n\t\t\t\tthis.mouseup = this._mouseup.bind(this);\n\n\t\t\t\tif (this.touchCapable) {\n\t\t\t\t\t// Touch: Bind touch events:\n\t\t\t\t\tdocument.addEventListener(\"touchmove\", this.mousemove, false);\n\t\t\t\t\tdocument.addEventListener(\"touchend\", this.mouseup, false);\n\t\t\t\t}\n\t\t\t\t// Bind mouse events:\n\t\t\t\tdocument.addEventListener(\"mousemove\", this.mousemove, false);\n\t\t\t\tdocument.addEventListener(\"mouseup\", this.mouseup, false);\n\n\t\t\t\tthis._state.inDrag = true;\n\t\t\t\tvar newValue = this._calculateValue();\n\n\t\t\t\tthis._trigger('slideStart', newValue);\n\n\t\t\t\tthis._setDataVal(newValue);\n\t\t\t\tthis.setValue(newValue, false, true);\n\n\t\t\t\tev.returnValue = false;\n\n\t\t\t\tif (this.options.focus) {\n\t\t\t\t\tthis._triggerFocusOnHandle(this._state.dragged);\n\t\t\t\t}\n\n\t\t\t\treturn true;\n\t\t\t},\n\t\t\t_touchstart: function _touchstart(ev) {\n\t\t\t\tif (ev.changedTouches === undefined) {\n\t\t\t\t\tthis._mousedown(ev);\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tvar touch = ev.changedTouches[0];\n\t\t\t\tthis.touchX = touch.pageX;\n\t\t\t\tthis.touchY = touch.pageY;\n\t\t\t},\n\t\t\t_triggerFocusOnHandle: function _triggerFocusOnHandle(handleIdx) {\n\t\t\t\tif (handleIdx === 0) {\n\t\t\t\t\tthis.handle1.focus();\n\t\t\t\t}\n\t\t\t\tif (handleIdx === 1) {\n\t\t\t\t\tthis.handle2.focus();\n\t\t\t\t}\n\t\t\t},\n\t\t\t_keydown: function _keydown(handleIdx, ev) {\n\t\t\t\tif (!this._state.enabled) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\tvar dir;\n\t\t\t\tswitch (ev.keyCode) {\n\t\t\t\t\tcase 37: // left\n\t\t\t\t\tcase 40:\n\t\t\t\t\t\t// down\n\t\t\t\t\t\tdir = -1;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase 39: // right\n\t\t\t\t\tcase 38:\n\t\t\t\t\t\t// up\n\t\t\t\t\t\tdir = 1;\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t\tif (!dir) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t// use natural arrow keys instead of from min to max\n\t\t\t\tif (this.options.natural_arrow_keys) {\n\t\t\t\t\tvar ifVerticalAndNotReversed = this.options.orientation === 'vertical' && !this.options.reversed;\n\t\t\t\t\tvar ifHorizontalAndReversed = this.options.orientation === 'horizontal' && this.options.reversed; // @todo control with rtl\n\n\t\t\t\t\tif (ifVerticalAndNotReversed || ifHorizontalAndReversed) {\n\t\t\t\t\t\tdir = -dir;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tvar val = this._state.value[handleIdx] + dir * this.options.step;\n\t\t\t\tvar percentage = val / this.options.max * 100;\n\t\t\t\tthis._state.keyCtrl = handleIdx;\n\t\t\t\tif (this.options.range) {\n\t\t\t\t\tthis._adjustPercentageForRangeSliders(percentage);\n\t\t\t\t\tvar val1 = !this._state.keyCtrl ? val : this._state.value[0];\n\t\t\t\t\tvar val2 = this._state.keyCtrl ? val : this._state.value[1];\n\t\t\t\t\tval = [val1, val2];\n\t\t\t\t}\n\n\t\t\t\tthis._trigger('slideStart', val);\n\t\t\t\tthis._setDataVal(val);\n\t\t\t\tthis.setValue(val, true, true);\n\n\t\t\t\tthis._setDataVal(val);\n\t\t\t\tthis._trigger('slideStop', val);\n\t\t\t\tthis._layout();\n\n\t\t\t\tthis._pauseEvent(ev);\n\t\t\t\tdelete this._state.keyCtrl;\n\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t_pauseEvent: function _pauseEvent(ev) {\n\t\t\t\tif (ev.stopPropagation) {\n\t\t\t\t\tev.stopPropagation();\n\t\t\t\t}\n\t\t\t\tif (ev.preventDefault) {\n\t\t\t\t\tev.preventDefault();\n\t\t\t\t}\n\t\t\t\tev.cancelBubble = true;\n\t\t\t\tev.returnValue = false;\n\t\t\t},\n\t\t\t_mousemove: function _mousemove(ev) {\n\t\t\t\tif (!this._state.enabled) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\tvar percentage = this._getPercentage(ev);\n\t\t\t\tthis._adjustPercentageForRangeSliders(percentage);\n\t\t\t\tthis._state.percentage[this._state.dragged] = percentage;\n\t\t\t\tthis._layout();\n\n\t\t\t\tvar val = this._calculateValue(true);\n\t\t\t\tthis.setValue(val, true, true);\n\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t_touchmove: function _touchmove(ev) {\n\t\t\t\tif (ev.changedTouches === undefined) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tvar touch = ev.changedTouches[0];\n\n\t\t\t\tvar xDiff = touch.pageX - this.touchX;\n\t\t\t\tvar yDiff = touch.pageY - this.touchY;\n\n\t\t\t\tif (!this._state.inDrag) {\n\t\t\t\t\t// Vertical Slider\n\t\t\t\t\tif (this.options.orientation === 'vertical' && xDiff <= 5 && xDiff >= -5 && (yDiff >= 15 || yDiff <= -15)) {\n\t\t\t\t\t\tthis._mousedown(ev);\n\t\t\t\t\t}\n\t\t\t\t\t// Horizontal slider.\n\t\t\t\t\telse if (yDiff <= 5 && yDiff >= -5 && (xDiff >= 15 || xDiff <= -15)) {\n\t\t\t\t\t\t\tthis._mousedown(ev);\n\t\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\t\t\t_adjustPercentageForRangeSliders: function _adjustPercentageForRangeSliders(percentage) {\n\t\t\t\tif (this.options.range) {\n\t\t\t\t\tvar precision = this._getNumDigitsAfterDecimalPlace(percentage);\n\t\t\t\t\tprecision = precision ? precision - 1 : 0;\n\t\t\t\t\tvar percentageWithAdjustedPrecision = this._applyToFixedAndParseFloat(percentage, precision);\n\t\t\t\t\tif (this._state.dragged === 0 && this._applyToFixedAndParseFloat(this._state.percentage[1], precision) < percentageWithAdjustedPrecision) {\n\t\t\t\t\t\tthis._state.percentage[0] = this._state.percentage[1];\n\t\t\t\t\t\tthis._state.dragged = 1;\n\t\t\t\t\t} else if (this._state.dragged === 1 && this._applyToFixedAndParseFloat(this._state.percentage[0], precision) > percentageWithAdjustedPrecision) {\n\t\t\t\t\t\tthis._state.percentage[1] = this._state.percentage[0];\n\t\t\t\t\t\tthis._state.dragged = 0;\n\t\t\t\t\t} else if (this._state.keyCtrl === 0 && this._state.value[1] / this.options.max * 100 < percentage) {\n\t\t\t\t\t\tthis._state.percentage[0] = this._state.percentage[1];\n\t\t\t\t\t\tthis._state.keyCtrl = 1;\n\t\t\t\t\t\tthis.handle2.focus();\n\t\t\t\t\t} else if (this._state.keyCtrl === 1 && this._state.value[0] / this.options.max * 100 > percentage) {\n\t\t\t\t\t\tthis._state.percentage[1] = this._state.percentage[0];\n\t\t\t\t\t\tthis._state.keyCtrl = 0;\n\t\t\t\t\t\tthis.handle1.focus();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\t\t\t_mouseup: function _mouseup() {\n\t\t\t\tif (!this._state.enabled) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tif (this.touchCapable) {\n\t\t\t\t\t// Touch: Unbind touch event handlers:\n\t\t\t\t\tdocument.removeEventListener(\"touchmove\", this.mousemove, false);\n\t\t\t\t\tdocument.removeEventListener(\"touchend\", this.mouseup, false);\n\t\t\t\t}\n\t\t\t\t// Unbind mouse event handlers:\n\t\t\t\tdocument.removeEventListener(\"mousemove\", this.mousemove, false);\n\t\t\t\tdocument.removeEventListener(\"mouseup\", this.mouseup, false);\n\n\t\t\t\tthis._state.inDrag = false;\n\t\t\t\tif (this._state.over === false) {\n\t\t\t\t\tthis._hideTooltip();\n\t\t\t\t}\n\t\t\t\tvar val = this._calculateValue(true);\n\n\t\t\t\tthis._layout();\n\t\t\t\tthis._setDataVal(val);\n\t\t\t\tthis._trigger('slideStop', val);\n\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t_calculateValue: function _calculateValue(snapToClosestTick) {\n\t\t\t\tvar val;\n\t\t\t\tif (this.options.range) {\n\t\t\t\t\tval = [this.options.min, this.options.max];\n\t\t\t\t\tif (this._state.percentage[0] !== 0) {\n\t\t\t\t\t\tval[0] = this._toValue(this._state.percentage[0]);\n\t\t\t\t\t\tval[0] = this._applyPrecision(val[0]);\n\t\t\t\t\t}\n\t\t\t\t\tif (this._state.percentage[1] !== 100) {\n\t\t\t\t\t\tval[1] = this._toValue(this._state.percentage[1]);\n\t\t\t\t\t\tval[1] = this._applyPrecision(val[1]);\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\tval = this._toValue(this._state.percentage[0]);\n\t\t\t\t\tval = parseFloat(val);\n\t\t\t\t\tval = this._applyPrecision(val);\n\t\t\t\t}\n\n\t\t\t\tif (snapToClosestTick) {\n\t\t\t\t\tvar min = [val, Infinity];\n\t\t\t\t\tfor (var i = 0; i < this.options.ticks.length; i++) {\n\t\t\t\t\t\tvar diff = Math.abs(this.options.ticks[i] - val);\n\t\t\t\t\t\tif (diff <= min[1]) {\n\t\t\t\t\t\t\tmin = [this.options.ticks[i], diff];\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tif (min[1] <= this.options.ticks_snap_bounds) {\n\t\t\t\t\t\treturn min[0];\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn val;\n\t\t\t},\n\t\t\t_applyPrecision: function _applyPrecision(val) {\n\t\t\t\tvar precision = this.options.precision || this._getNumDigitsAfterDecimalPlace(this.options.step);\n\t\t\t\treturn this._applyToFixedAndParseFloat(val, precision);\n\t\t\t},\n\t\t\t_getNumDigitsAfterDecimalPlace: function _getNumDigitsAfterDecimalPlace(num) {\n\t\t\t\tvar match = ('' + num).match(/(?:\\.(\\d+))?(?:[eE]([+-]?\\d+))?$/);\n\t\t\t\tif (!match) {\n\t\t\t\t\treturn 0;\n\t\t\t\t}\n\t\t\t\treturn Math.max(0, (match[1] ? match[1].length : 0) - (match[2] ? +match[2] : 0));\n\t\t\t},\n\t\t\t_applyToFixedAndParseFloat: function _applyToFixedAndParseFloat(num, toFixedInput) {\n\t\t\t\tvar truncatedNum = num.toFixed(toFixedInput);\n\t\t\t\treturn parseFloat(truncatedNum);\n\t\t\t},\n\t\t\t/*\n   \tCredits to Mike Samuel for the following method!\n   \tSource: http://stackoverflow.com/questions/10454518/javascript-how-to-retrieve-the-number-of-decimals-of-a-string-number\n   */\n\t\t\t_getPercentage: function _getPercentage(ev) {\n\t\t\t\tif (this.touchCapable && (ev.type === 'touchstart' || ev.type === 'touchmove')) {\n\t\t\t\t\tev = ev.touches[0];\n\t\t\t\t}\n\n\t\t\t\tvar eventPosition = ev[this.mousePos];\n\t\t\t\tvar sliderOffset = this._state.offset[this.stylePos];\n\t\t\t\tvar distanceToSlide = eventPosition - sliderOffset;\n\t\t\t\tif (this.stylePos === 'right') {\n\t\t\t\t\tdistanceToSlide = -distanceToSlide;\n\t\t\t\t}\n\t\t\t\t// Calculate what percent of the length the slider handle has slid\n\t\t\t\tvar percentage = distanceToSlide / this._state.size * 100;\n\t\t\t\tpercentage = Math.round(percentage / this._state.percentage[2]) * this._state.percentage[2];\n\t\t\t\tif (this.options.reversed) {\n\t\t\t\t\tpercentage = 100 - percentage;\n\t\t\t\t}\n\n\t\t\t\t// Make sure the percent is within the bounds of the slider.\n\t\t\t\t// 0% corresponds to the 'min' value of the slide\n\t\t\t\t// 100% corresponds to the 'max' value of the slide\n\t\t\t\treturn Math.max(0, Math.min(100, percentage));\n\t\t\t},\n\t\t\t_validateInputValue: function _validateInputValue(val) {\n\t\t\t\tif (!isNaN(+val)) {\n\t\t\t\t\treturn +val;\n\t\t\t\t} else if (Array.isArray(val)) {\n\t\t\t\t\tthis._validateArray(val);\n\t\t\t\t\treturn val;\n\t\t\t\t} else {\n\t\t\t\t\tthrow new Error(ErrorMsgs.formatInvalidInputErrorMsg(val));\n\t\t\t\t}\n\t\t\t},\n\t\t\t_validateArray: function _validateArray(val) {\n\t\t\t\tfor (var i = 0; i < val.length; i++) {\n\t\t\t\t\tvar input = val[i];\n\t\t\t\t\tif (typeof input !== 'number') {\n\t\t\t\t\t\tthrow new Error(ErrorMsgs.formatInvalidInputErrorMsg(input));\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\t\t\t_setDataVal: function _setDataVal(val) {\n\t\t\t\tthis.element.setAttribute('data-value', val);\n\t\t\t\tthis.element.setAttribute('value', val);\n\t\t\t\tthis.element.value = val;\n\t\t\t},\n\t\t\t_trigger: function _trigger(evt, val) {\n\t\t\t\tval = val || val === 0 ? val : undefined;\n\n\t\t\t\tvar callbackFnArray = this.eventToCallbackMap[evt];\n\t\t\t\tif (callbackFnArray && callbackFnArray.length) {\n\t\t\t\t\tfor (var i = 0; i < callbackFnArray.length; i++) {\n\t\t\t\t\t\tvar callbackFn = callbackFnArray[i];\n\t\t\t\t\t\tcallbackFn(val);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t/* If JQuery exists, trigger JQuery events */\n\t\t\t\tif ($) {\n\t\t\t\t\tthis._triggerJQueryEvent(evt, val);\n\t\t\t\t}\n\t\t\t},\n\t\t\t_triggerJQueryEvent: function _triggerJQueryEvent(evt, val) {\n\t\t\t\tvar eventData = {\n\t\t\t\t\ttype: evt,\n\t\t\t\t\tvalue: val\n\t\t\t\t};\n\t\t\t\tthis.$element.trigger(eventData);\n\t\t\t\tthis.$sliderElem.trigger(eventData);\n\t\t\t},\n\t\t\t_unbindJQueryEventHandlers: function _unbindJQueryEventHandlers() {\n\t\t\t\tthis.$element.off();\n\t\t\t\tthis.$sliderElem.off();\n\t\t\t},\n\t\t\t_setText: function _setText(element, text) {\n\t\t\t\tif (typeof element.textContent !== \"undefined\") {\n\t\t\t\t\telement.textContent = text;\n\t\t\t\t} else if (typeof element.innerText !== \"undefined\") {\n\t\t\t\t\telement.innerText = text;\n\t\t\t\t}\n\t\t\t},\n\t\t\t_removeClass: function _removeClass(element, classString) {\n\t\t\t\tvar classes = classString.split(\" \");\n\t\t\t\tvar newClasses = element.className;\n\n\t\t\t\tfor (var i = 0; i < classes.length; i++) {\n\t\t\t\t\tvar classTag = classes[i];\n\t\t\t\t\tvar regex = new RegExp(\"(?:\\\\s|^)\" + classTag + \"(?:\\\\s|$)\");\n\t\t\t\t\tnewClasses = newClasses.replace(regex, \" \");\n\t\t\t\t}\n\n\t\t\t\telement.className = newClasses.trim();\n\t\t\t},\n\t\t\t_addClass: function _addClass(element, classString) {\n\t\t\t\tvar classes = classString.split(\" \");\n\t\t\t\tvar newClasses = element.className;\n\n\t\t\t\tfor (var i = 0; i < classes.length; i++) {\n\t\t\t\t\tvar classTag = classes[i];\n\t\t\t\t\tvar regex = new RegExp(\"(?:\\\\s|^)\" + classTag + \"(?:\\\\s|$)\");\n\t\t\t\t\tvar ifClassExists = regex.test(newClasses);\n\n\t\t\t\t\tif (!ifClassExists) {\n\t\t\t\t\t\tnewClasses += \" \" + classTag;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\telement.className = newClasses.trim();\n\t\t\t},\n\t\t\t_offsetLeft: function _offsetLeft(obj) {\n\t\t\t\treturn obj.getBoundingClientRect().left;\n\t\t\t},\n\t\t\t_offsetRight: function _offsetRight(obj) {\n\t\t\t\treturn obj.getBoundingClientRect().right;\n\t\t\t},\n\t\t\t_offsetTop: function _offsetTop(obj) {\n\t\t\t\tvar offsetTop = obj.offsetTop;\n\t\t\t\twhile ((obj = obj.offsetParent) && !isNaN(obj.offsetTop)) {\n\t\t\t\t\toffsetTop += obj.offsetTop;\n\t\t\t\t\tif (obj.tagName !== 'BODY') {\n\t\t\t\t\t\toffsetTop -= obj.scrollTop;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\treturn offsetTop;\n\t\t\t},\n\t\t\t_offset: function _offset(obj) {\n\t\t\t\treturn {\n\t\t\t\t\tleft: this._offsetLeft(obj),\n\t\t\t\t\tright: this._offsetRight(obj),\n\t\t\t\t\ttop: this._offsetTop(obj)\n\t\t\t\t};\n\t\t\t},\n\t\t\t_css: function _css(elementRef, styleName, value) {\n\t\t\t\tif ($) {\n\t\t\t\t\t$.style(elementRef, styleName, value);\n\t\t\t\t} else {\n\t\t\t\t\tvar style = styleName.replace(/^-ms-/, \"ms-\").replace(/-([\\da-z])/gi, function (all, letter) {\n\t\t\t\t\t\treturn letter.toUpperCase();\n\t\t\t\t\t});\n\t\t\t\t\telementRef.style[style] = value;\n\t\t\t\t}\n\t\t\t},\n\t\t\t_toValue: function _toValue(percentage) {\n\t\t\t\treturn this.options.scale.toValue.apply(this, [percentage]);\n\t\t\t},\n\t\t\t_toPercentage: function _toPercentage(value) {\n\t\t\t\treturn this.options.scale.toPercentage.apply(this, [value]);\n\t\t\t},\n\t\t\t_setTooltipPosition: function _setTooltipPosition() {\n\t\t\t\tvar tooltips = [this.tooltip, this.tooltip_min, this.tooltip_max];\n\t\t\t\tif (this.options.orientation === 'vertical') {\n\t\t\t\t\tvar tooltipPos;\n\t\t\t\t\tif (this.options.tooltip_position) {\n\t\t\t\t\t\ttooltipPos = this.options.tooltip_position;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tif (this.options.rtl) {\n\t\t\t\t\t\t\ttooltipPos = 'left';\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\ttooltipPos = 'right';\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tvar oppositeSide = tooltipPos === 'left' ? 'right' : 'left';\n\t\t\t\t\ttooltips.forEach(function (tooltip) {\n\t\t\t\t\t\tthis._addClass(tooltip, tooltipPos);\n\t\t\t\t\t\ttooltip.style[oppositeSide] = '100%';\n\t\t\t\t\t}.bind(this));\n\t\t\t\t} else if (this.options.tooltip_position === 'bottom') {\n\t\t\t\t\ttooltips.forEach(function (tooltip) {\n\t\t\t\t\t\tthis._addClass(tooltip, 'bottom');\n\t\t\t\t\t\ttooltip.style.top = 22 + 'px';\n\t\t\t\t\t}.bind(this));\n\t\t\t\t} else {\n\t\t\t\t\ttooltips.forEach(function (tooltip) {\n\t\t\t\t\t\tthis._addClass(tooltip, 'top');\n\t\t\t\t\t\ttooltip.style.top = -this.tooltip.outerHeight - 14 + 'px';\n\t\t\t\t\t}.bind(this));\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\t/*********************************\n  \t\tAttach to global namespace\n  \t*********************************/\n\t\tif ($ && $.fn) {\n\t\t\tvar autoRegisterNamespace = void 0;\n\n\t\t\tif (!$.fn.slider) {\n\t\t\t\t$.bridget(NAMESPACE_MAIN, Slider);\n\t\t\t\tautoRegisterNamespace = NAMESPACE_MAIN;\n\t\t\t} else {\n\t\t\t\tif (windowIsDefined) {\n\t\t\t\t\twindow.console.warn(\"bootstrap-slider.js - WARNING: $.fn.slider namespace is already bound. Use the $.fn.bootstrapSlider namespace instead.\");\n\t\t\t\t}\n\t\t\t\tautoRegisterNamespace = NAMESPACE_ALTERNATE;\n\t\t\t}\n\t\t\t$.bridget(NAMESPACE_ALTERNATE, Slider);\n\n\t\t\t// Auto-Register data-provide=\"slider\" Elements\n\t\t\t$(function () {\n\t\t\t\t$(\"input[data-provide=slider]\")[autoRegisterNamespace]();\n\t\t\t});\n\t\t}\n\t})($);\n\n\treturn Slider;\n});\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/react-bootstrap-slider/node_modules/bootstrap-slider/dist/bootstrap-slider.js\n");

/***/ })

}]);