(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[11],{

/***/ "./node_modules/@superset-ui/plugin-chart-word-cloud/esm/chart/WordCloud.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@superset-ui/plugin-chart-word-cloud/esm/chart/WordCloud.js ***!
  \**********************************************************************************/
/*! exports provided: ROTATION, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"ROTATION\", function() { return ROTATION; });\n/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! prop-types */ \"./node_modules/prop-types/index.js\");\n/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ \"./node_modules/react/index.js\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var d3_cloud__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! d3-cloud */ \"./node_modules/d3-cloud/index.js\");\n/* harmony import */ var d3_cloud__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(d3_cloud__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var encodable__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! encodable */ \"./node_modules/encodable/esm/encoders/createEncoderFactory.js\");\n/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @superset-ui/core */ \"./node_modules/@superset-ui/core/esm/utils/random.js\");\n/* harmony import */ var _superset_ui_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @superset-ui/core */ \"./node_modules/@emotion/react/dist/emotion-element-4fbd89c5.browser.esm.js\");\n/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @emotion/react */ \"./node_modules/@emotion/react/dist/emotion-react.browser.esm.js\");\n\n\n\n\n\n\nconst ROTATION = {\n  flat: () => 0,\n  // this calculates a random rotation between -90 and 90 degrees.\n  random: () => Math.floor(Object(_superset_ui_core__WEBPACK_IMPORTED_MODULE_4__[\"seedRandom\"])() * 6 - 3) * 30,\n  square: () => Math.floor(Object(_superset_ui_core__WEBPACK_IMPORTED_MODULE_4__[\"seedRandom\"])() * 2) * 90\n};\nconst defaultProps = {\n  encoding: {},\n  rotation: 'flat'\n};\nconst SCALE_FACTOR_STEP = 0.5;\nconst MAX_SCALE_FACTOR = 3; // Percentage of top results that will always be displayed.\n// Needed to avoid clutter when shrinking a chart with many records.\n\nconst TOP_RESULTS_PERCENTAGE = 0.1;\n\nclass WordCloud extends react__WEBPACK_IMPORTED_MODULE_1___default.a.PureComponent {\n  // Cannot name it isMounted because of conflict\n  // with React's component function name\n  constructor(props) {\n    super(props);\n    this.isComponentMounted = false;\n    this.wordCloudEncoderFactory = Object(encodable__WEBPACK_IMPORTED_MODULE_3__[\"default\"])({\n      channelTypes: {\n        color: 'Color',\n        fontFamily: 'Category',\n        fontSize: 'Numeric',\n        fontWeight: 'Category',\n        text: 'Text'\n      },\n      defaultEncoding: {\n        color: {\n          value: 'black'\n        },\n        fontFamily: {\n          value: this.props.theme.typography.families.sansSerif\n        },\n        fontSize: {\n          value: 20\n        },\n        fontWeight: {\n          value: 'bold'\n        },\n        text: {\n          value: ''\n        }\n      }\n    });\n    this.createEncoder = this.wordCloudEncoderFactory.createSelector();\n    this.state = {\n      words: [],\n      scaleFactor: 1\n    };\n    this.setWords = this.setWords.bind(this);\n  }\n\n  componentDidMount() {\n    this.isComponentMounted = true;\n    this.update();\n  }\n\n  componentDidUpdate(prevProps) {\n    const {\n      data,\n      encoding,\n      width,\n      height,\n      rotation\n    } = this.props;\n\n    if (prevProps.data !== data || prevProps.encoding !== encoding || prevProps.width !== width || prevProps.height !== height || prevProps.rotation !== rotation) {\n      this.update();\n    }\n  }\n\n  componentWillUnmount() {\n    this.isComponentMounted = false;\n  }\n\n  setWords(words) {\n    if (this.isComponentMounted) {\n      this.setState({\n        words\n      });\n    }\n  }\n\n  update() {\n    const {\n      data,\n      encoding\n    } = this.props;\n    const encoder = this.createEncoder(encoding);\n    encoder.setDomainFromDataset(data);\n    const sortedData = [...data].sort((a, b) => encoder.channels.fontSize.encodeDatum(b, 0) - encoder.channels.fontSize.encodeDatum(a, 0));\n    const topResultsCount = Math.max(sortedData.length * TOP_RESULTS_PERCENTAGE, 10);\n    const topResults = sortedData.slice(0, topResultsCount); // Ensure top results are always included in the final word cloud by scaling chart down if needed\n\n    this.generateCloud(encoder, 1, words => topResults.every(d => words.find(({\n      text\n    }) => encoder.channels.text.getValueFromDatum(d) === text)));\n  }\n\n  generateCloud(encoder, scaleFactor, isValid) {\n    const {\n      data,\n      width,\n      height,\n      rotation\n    } = this.props;\n    d3_cloud__WEBPACK_IMPORTED_MODULE_2___default()().size([width * scaleFactor, height * scaleFactor]) // clone the data because cloudLayout mutates input\n    .words(data.map(d => ({ ...d\n    }))).padding(5).rotate(ROTATION[rotation] || ROTATION.flat).text(d => encoder.channels.text.getValueFromDatum(d)).font(d => encoder.channels.fontFamily.encodeDatum(d, this.props.theme.typography.families.sansSerif)).fontWeight(d => encoder.channels.fontWeight.encodeDatum(d, 'normal')).fontSize(d => encoder.channels.fontSize.encodeDatum(d, 0)).on('end', words => {\n      if (isValid(words) || scaleFactor > MAX_SCALE_FACTOR) {\n        if (this.isComponentMounted) {\n          this.setState({\n            words,\n            scaleFactor\n          });\n        }\n      } else {\n        this.generateCloud(encoder, scaleFactor + SCALE_FACTOR_STEP, isValid);\n      }\n    }).start();\n  }\n\n  render() {\n    const {\n      scaleFactor\n    } = this.state;\n    const {\n      width,\n      height,\n      encoding\n    } = this.props;\n    const {\n      words\n    } = this.state;\n    const encoder = this.createEncoder(encoding);\n    encoder.channels.color.setDomainFromDataset(words);\n    const viewBoxWidth = width * scaleFactor;\n    const viewBoxHeight = height * scaleFactor;\n    return Object(_emotion_react__WEBPACK_IMPORTED_MODULE_6__[\"jsx\"])(\"svg\", {\n      width: width,\n      height: height,\n      viewBox: `-${viewBoxWidth / 2} -${viewBoxHeight / 2} ${viewBoxWidth} ${viewBoxHeight}`\n    }, Object(_emotion_react__WEBPACK_IMPORTED_MODULE_6__[\"jsx\"])(\"g\", null, words.map(w => Object(_emotion_react__WEBPACK_IMPORTED_MODULE_6__[\"jsx\"])(\"text\", {\n      key: w.text,\n      fontSize: `${w.size}px`,\n      fontWeight: w.weight,\n      fontFamily: w.font,\n      fill: encoder.channels.color.encodeDatum(w, ''),\n      textAnchor: \"middle\",\n      transform: `translate(${w.x}, ${w.y}) rotate(${w.rotate})`\n    }, w.text))));\n  }\n\n}\n\nWordCloud.propTypes = {\n  rotation: prop_types__WEBPACK_IMPORTED_MODULE_0___default.a.any,\n  data: prop_types__WEBPACK_IMPORTED_MODULE_0___default.a.array.isRequired,\n  height: prop_types__WEBPACK_IMPORTED_MODULE_0___default.a.number.isRequired,\n  width: prop_types__WEBPACK_IMPORTED_MODULE_0___default.a.number.isRequired\n};\nWordCloud.defaultProps = defaultProps;\n/* harmony default export */ __webpack_exports__[\"default\"] = (Object(_superset_ui_core__WEBPACK_IMPORTED_MODULE_5__[\"b\"])(WordCloud));//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@superset-ui/plugin-chart-word-cloud/esm/chart/WordCloud.js\n");

/***/ }),

/***/ "./node_modules/d3-cloud/index.js":
/*!****************************************!*\
  !*** ./node_modules/d3-cloud/index.js ***!
  \****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("// Word cloud layout by Jason Davies, https://www.jasondavies.com/wordcloud/\n// Algorithm due to Jonathan Feinberg, http://static.mrfeinberg.com/bv_ch03.pdf\n\nvar dispatch = __webpack_require__(/*! d3-dispatch */ \"./node_modules/d3-dispatch/src/index.js\").dispatch;\n\nvar cloudRadians = Math.PI / 180,\n    cw = 1 << 11 >> 5,\n    ch = 1 << 11;\n\nmodule.exports = function() {\n  var size = [256, 256],\n      text = cloudText,\n      font = cloudFont,\n      fontSize = cloudFontSize,\n      fontStyle = cloudFontNormal,\n      fontWeight = cloudFontNormal,\n      rotate = cloudRotate,\n      padding = cloudPadding,\n      spiral = archimedeanSpiral,\n      words = [],\n      timeInterval = Infinity,\n      event = dispatch(\"word\", \"end\"),\n      timer = null,\n      random = Math.random,\n      cloud = {},\n      canvas = cloudCanvas;\n\n  cloud.canvas = function(_) {\n    return arguments.length ? (canvas = functor(_), cloud) : canvas;\n  };\n\n  cloud.start = function() {\n    var contextAndRatio = getContext(canvas()),\n        board = zeroArray((size[0] >> 5) * size[1]),\n        bounds = null,\n        n = words.length,\n        i = -1,\n        tags = [],\n        data = words.map(function(d, i) {\n          d.text = text.call(this, d, i);\n          d.font = font.call(this, d, i);\n          d.style = fontStyle.call(this, d, i);\n          d.weight = fontWeight.call(this, d, i);\n          d.rotate = rotate.call(this, d, i);\n          d.size = ~~fontSize.call(this, d, i);\n          d.padding = padding.call(this, d, i);\n          return d;\n        }).sort(function(a, b) { return b.size - a.size; });\n\n    if (timer) clearInterval(timer);\n    timer = setInterval(step, 0);\n    step();\n\n    return cloud;\n\n    function step() {\n      var start = Date.now();\n      while (Date.now() - start < timeInterval && ++i < n && timer) {\n        var d = data[i];\n        d.x = (size[0] * (random() + .5)) >> 1;\n        d.y = (size[1] * (random() + .5)) >> 1;\n        cloudSprite(contextAndRatio, d, data, i);\n        if (d.hasText && place(board, d, bounds)) {\n          tags.push(d);\n          event.call(\"word\", cloud, d);\n          if (bounds) cloudBounds(bounds, d);\n          else bounds = [{x: d.x + d.x0, y: d.y + d.y0}, {x: d.x + d.x1, y: d.y + d.y1}];\n          // Temporary hack\n          d.x -= size[0] >> 1;\n          d.y -= size[1] >> 1;\n        }\n      }\n      if (i >= n) {\n        cloud.stop();\n        event.call(\"end\", cloud, tags, bounds);\n      }\n    }\n  }\n\n  cloud.stop = function() {\n    if (timer) {\n      clearInterval(timer);\n      timer = null;\n    }\n    return cloud;\n  };\n\n  function getContext(canvas) {\n    canvas.width = canvas.height = 1;\n    var ratio = Math.sqrt(canvas.getContext(\"2d\").getImageData(0, 0, 1, 1).data.length >> 2);\n    canvas.width = (cw << 5) / ratio;\n    canvas.height = ch / ratio;\n\n    var context = canvas.getContext(\"2d\");\n    context.fillStyle = context.strokeStyle = \"red\";\n    context.textAlign = \"center\";\n\n    return {context: context, ratio: ratio};\n  }\n\n  function place(board, tag, bounds) {\n    var perimeter = [{x: 0, y: 0}, {x: size[0], y: size[1]}],\n        startX = tag.x,\n        startY = tag.y,\n        maxDelta = Math.sqrt(size[0] * size[0] + size[1] * size[1]),\n        s = spiral(size),\n        dt = random() < .5 ? 1 : -1,\n        t = -dt,\n        dxdy,\n        dx,\n        dy;\n\n    while (dxdy = s(t += dt)) {\n      dx = ~~dxdy[0];\n      dy = ~~dxdy[1];\n\n      if (Math.min(Math.abs(dx), Math.abs(dy)) >= maxDelta) break;\n\n      tag.x = startX + dx;\n      tag.y = startY + dy;\n\n      if (tag.x + tag.x0 < 0 || tag.y + tag.y0 < 0 ||\n          tag.x + tag.x1 > size[0] || tag.y + tag.y1 > size[1]) continue;\n      // TODO only check for collisions within current bounds.\n      if (!bounds || !cloudCollide(tag, board, size[0])) {\n        if (!bounds || collideRects(tag, bounds)) {\n          var sprite = tag.sprite,\n              w = tag.width >> 5,\n              sw = size[0] >> 5,\n              lx = tag.x - (w << 4),\n              sx = lx & 0x7f,\n              msx = 32 - sx,\n              h = tag.y1 - tag.y0,\n              x = (tag.y + tag.y0) * sw + (lx >> 5),\n              last;\n          for (var j = 0; j < h; j++) {\n            last = 0;\n            for (var i = 0; i <= w; i++) {\n              board[x + i] |= (last << msx) | (i < w ? (last = sprite[j * w + i]) >>> sx : 0);\n            }\n            x += sw;\n          }\n          delete tag.sprite;\n          return true;\n        }\n      }\n    }\n    return false;\n  }\n\n  cloud.timeInterval = function(_) {\n    return arguments.length ? (timeInterval = _ == null ? Infinity : _, cloud) : timeInterval;\n  };\n\n  cloud.words = function(_) {\n    return arguments.length ? (words = _, cloud) : words;\n  };\n\n  cloud.size = function(_) {\n    return arguments.length ? (size = [+_[0], +_[1]], cloud) : size;\n  };\n\n  cloud.font = function(_) {\n    return arguments.length ? (font = functor(_), cloud) : font;\n  };\n\n  cloud.fontStyle = function(_) {\n    return arguments.length ? (fontStyle = functor(_), cloud) : fontStyle;\n  };\n\n  cloud.fontWeight = function(_) {\n    return arguments.length ? (fontWeight = functor(_), cloud) : fontWeight;\n  };\n\n  cloud.rotate = function(_) {\n    return arguments.length ? (rotate = functor(_), cloud) : rotate;\n  };\n\n  cloud.text = function(_) {\n    return arguments.length ? (text = functor(_), cloud) : text;\n  };\n\n  cloud.spiral = function(_) {\n    return arguments.length ? (spiral = spirals[_] || _, cloud) : spiral;\n  };\n\n  cloud.fontSize = function(_) {\n    return arguments.length ? (fontSize = functor(_), cloud) : fontSize;\n  };\n\n  cloud.padding = function(_) {\n    return arguments.length ? (padding = functor(_), cloud) : padding;\n  };\n\n  cloud.random = function(_) {\n    return arguments.length ? (random = _, cloud) : random;\n  };\n\n  cloud.on = function() {\n    var value = event.on.apply(event, arguments);\n    return value === event ? cloud : value;\n  };\n\n  return cloud;\n};\n\nfunction cloudText(d) {\n  return d.text;\n}\n\nfunction cloudFont() {\n  return \"serif\";\n}\n\nfunction cloudFontNormal() {\n  return \"normal\";\n}\n\nfunction cloudFontSize(d) {\n  return Math.sqrt(d.value);\n}\n\nfunction cloudRotate() {\n  return (~~(Math.random() * 6) - 3) * 30;\n}\n\nfunction cloudPadding() {\n  return 1;\n}\n\n// Fetches a monochrome sprite bitmap for the specified text.\n// Load in batches for speed.\nfunction cloudSprite(contextAndRatio, d, data, di) {\n  if (d.sprite) return;\n  var c = contextAndRatio.context,\n      ratio = contextAndRatio.ratio;\n\n  c.clearRect(0, 0, (cw << 5) / ratio, ch / ratio);\n  var x = 0,\n      y = 0,\n      maxh = 0,\n      n = data.length;\n  --di;\n  while (++di < n) {\n    d = data[di];\n    c.save();\n    c.font = d.style + \" \" + d.weight + \" \" + ~~((d.size + 1) / ratio) + \"px \" + d.font;\n    var w = c.measureText(d.text + \"m\").width * ratio,\n        h = d.size << 1;\n    if (d.rotate) {\n      var sr = Math.sin(d.rotate * cloudRadians),\n          cr = Math.cos(d.rotate * cloudRadians),\n          wcr = w * cr,\n          wsr = w * sr,\n          hcr = h * cr,\n          hsr = h * sr;\n      w = (Math.max(Math.abs(wcr + hsr), Math.abs(wcr - hsr)) + 0x1f) >> 5 << 5;\n      h = ~~Math.max(Math.abs(wsr + hcr), Math.abs(wsr - hcr));\n    } else {\n      w = (w + 0x1f) >> 5 << 5;\n    }\n    if (h > maxh) maxh = h;\n    if (x + w >= (cw << 5)) {\n      x = 0;\n      y += maxh;\n      maxh = 0;\n    }\n    if (y + h >= ch) break;\n    c.translate((x + (w >> 1)) / ratio, (y + (h >> 1)) / ratio);\n    if (d.rotate) c.rotate(d.rotate * cloudRadians);\n    c.fillText(d.text, 0, 0);\n    if (d.padding) c.lineWidth = 2 * d.padding, c.strokeText(d.text, 0, 0);\n    c.restore();\n    d.width = w;\n    d.height = h;\n    d.xoff = x;\n    d.yoff = y;\n    d.x1 = w >> 1;\n    d.y1 = h >> 1;\n    d.x0 = -d.x1;\n    d.y0 = -d.y1;\n    d.hasText = true;\n    x += w;\n  }\n  var pixels = c.getImageData(0, 0, (cw << 5) / ratio, ch / ratio).data,\n      sprite = [];\n  while (--di >= 0) {\n    d = data[di];\n    if (!d.hasText) continue;\n    var w = d.width,\n        w32 = w >> 5,\n        h = d.y1 - d.y0;\n    // Zero the buffer\n    for (var i = 0; i < h * w32; i++) sprite[i] = 0;\n    x = d.xoff;\n    if (x == null) return;\n    y = d.yoff;\n    var seen = 0,\n        seenRow = -1;\n    for (var j = 0; j < h; j++) {\n      for (var i = 0; i < w; i++) {\n        var k = w32 * j + (i >> 5),\n            m = pixels[((y + j) * (cw << 5) + (x + i)) << 2] ? 1 << (31 - (i % 32)) : 0;\n        sprite[k] |= m;\n        seen |= m;\n      }\n      if (seen) seenRow = j;\n      else {\n        d.y0++;\n        h--;\n        j--;\n        y++;\n      }\n    }\n    d.y1 = d.y0 + seenRow;\n    d.sprite = sprite.slice(0, (d.y1 - d.y0) * w32);\n  }\n}\n\n// Use mask-based collision detection.\nfunction cloudCollide(tag, board, sw) {\n  sw >>= 5;\n  var sprite = tag.sprite,\n      w = tag.width >> 5,\n      lx = tag.x - (w << 4),\n      sx = lx & 0x7f,\n      msx = 32 - sx,\n      h = tag.y1 - tag.y0,\n      x = (tag.y + tag.y0) * sw + (lx >> 5),\n      last;\n  for (var j = 0; j < h; j++) {\n    last = 0;\n    for (var i = 0; i <= w; i++) {\n      if (((last << msx) | (i < w ? (last = sprite[j * w + i]) >>> sx : 0))\n          & board[x + i]) return true;\n    }\n    x += sw;\n  }\n  return false;\n}\n\nfunction cloudBounds(bounds, d) {\n  var b0 = bounds[0],\n      b1 = bounds[1];\n  if (d.x + d.x0 < b0.x) b0.x = d.x + d.x0;\n  if (d.y + d.y0 < b0.y) b0.y = d.y + d.y0;\n  if (d.x + d.x1 > b1.x) b1.x = d.x + d.x1;\n  if (d.y + d.y1 > b1.y) b1.y = d.y + d.y1;\n}\n\nfunction collideRects(a, b) {\n  return a.x + a.x1 > b[0].x && a.x + a.x0 < b[1].x && a.y + a.y1 > b[0].y && a.y + a.y0 < b[1].y;\n}\n\nfunction archimedeanSpiral(size) {\n  var e = size[0] / size[1];\n  return function(t) {\n    return [e * (t *= .1) * Math.cos(t), t * Math.sin(t)];\n  };\n}\n\nfunction rectangularSpiral(size) {\n  var dy = 4,\n      dx = dy * size[0] / size[1],\n      x = 0,\n      y = 0;\n  return function(t) {\n    var sign = t < 0 ? -1 : 1;\n    // See triangular numbers: T_n = n * (n + 1) / 2.\n    switch ((Math.sqrt(1 + 4 * sign * t) - sign) & 3) {\n      case 0:  x += dx; break;\n      case 1:  y += dy; break;\n      case 2:  x -= dx; break;\n      default: y -= dy; break;\n    }\n    return [x, y];\n  };\n}\n\n// TODO reuse arrays?\nfunction zeroArray(n) {\n  var a = [],\n      i = -1;\n  while (++i < n) a[i] = 0;\n  return a;\n}\n\nfunction cloudCanvas() {\n  return document.createElement(\"canvas\");\n}\n\nfunction functor(d) {\n  return typeof d === \"function\" ? d : function() { return d; };\n}\n\nvar spirals = {\n  archimedean: archimedeanSpiral,\n  rectangular: rectangularSpiral\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/d3-cloud/index.js\n");

/***/ }),

/***/ "./node_modules/d3-dispatch/src/dispatch.js":
/*!**************************************************!*\
  !*** ./node_modules/d3-dispatch/src/dispatch.js ***!
  \**************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nvar noop = {value: function() {}};\n\nfunction dispatch() {\n  for (var i = 0, n = arguments.length, _ = {}, t; i < n; ++i) {\n    if (!(t = arguments[i] + \"\") || (t in _) || /[\\s.]/.test(t)) throw new Error(\"illegal type: \" + t);\n    _[t] = [];\n  }\n  return new Dispatch(_);\n}\n\nfunction Dispatch(_) {\n  this._ = _;\n}\n\nfunction parseTypenames(typenames, types) {\n  return typenames.trim().split(/^|\\s+/).map(function(t) {\n    var name = \"\", i = t.indexOf(\".\");\n    if (i >= 0) name = t.slice(i + 1), t = t.slice(0, i);\n    if (t && !types.hasOwnProperty(t)) throw new Error(\"unknown type: \" + t);\n    return {type: t, name: name};\n  });\n}\n\nDispatch.prototype = dispatch.prototype = {\n  constructor: Dispatch,\n  on: function(typename, callback) {\n    var _ = this._,\n        T = parseTypenames(typename + \"\", _),\n        t,\n        i = -1,\n        n = T.length;\n\n    // If no callback was specified, return the callback of the given type and name.\n    if (arguments.length < 2) {\n      while (++i < n) if ((t = (typename = T[i]).type) && (t = get(_[t], typename.name))) return t;\n      return;\n    }\n\n    // If a type was specified, set the callback for the given type and name.\n    // Otherwise, if a null callback was specified, remove callbacks of the given name.\n    if (callback != null && typeof callback !== \"function\") throw new Error(\"invalid callback: \" + callback);\n    while (++i < n) {\n      if (t = (typename = T[i]).type) _[t] = set(_[t], typename.name, callback);\n      else if (callback == null) for (t in _) _[t] = set(_[t], typename.name, null);\n    }\n\n    return this;\n  },\n  copy: function() {\n    var copy = {}, _ = this._;\n    for (var t in _) copy[t] = _[t].slice();\n    return new Dispatch(copy);\n  },\n  call: function(type, that) {\n    if ((n = arguments.length - 2) > 0) for (var args = new Array(n), i = 0, n, t; i < n; ++i) args[i] = arguments[i + 2];\n    if (!this._.hasOwnProperty(type)) throw new Error(\"unknown type: \" + type);\n    for (t = this._[type], i = 0, n = t.length; i < n; ++i) t[i].value.apply(that, args);\n  },\n  apply: function(type, that, args) {\n    if (!this._.hasOwnProperty(type)) throw new Error(\"unknown type: \" + type);\n    for (var t = this._[type], i = 0, n = t.length; i < n; ++i) t[i].value.apply(that, args);\n  }\n};\n\nfunction get(type, name) {\n  for (var i = 0, n = type.length, c; i < n; ++i) {\n    if ((c = type[i]).name === name) {\n      return c.value;\n    }\n  }\n}\n\nfunction set(type, name, callback) {\n  for (var i = 0, n = type.length; i < n; ++i) {\n    if (type[i].name === name) {\n      type[i] = noop, type = type.slice(0, i).concat(type.slice(i + 1));\n      break;\n    }\n  }\n  if (callback != null) type.push({name: name, value: callback});\n  return type;\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (dispatch);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/d3-dispatch/src/dispatch.js\n");

/***/ }),

/***/ "./node_modules/d3-dispatch/src/index.js":
/*!***********************************************!*\
  !*** ./node_modules/d3-dispatch/src/index.js ***!
  \***********************************************/
/*! exports provided: dispatch */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _dispatch_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./dispatch.js */ \"./node_modules/d3-dispatch/src/dispatch.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"dispatch\", function() { return _dispatch_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"]; });\n\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZDMtZGlzcGF0Y2gvc3JjL2luZGV4LmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2QzLWRpc3BhdGNoL3NyYy9pbmRleC5qcz9kZjQ1Il0sInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCB7ZGVmYXVsdCBhcyBkaXNwYXRjaH0gZnJvbSBcIi4vZGlzcGF0Y2guanNcIjtcbiJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTsiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/d3-dispatch/src/index.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/encoders/ChannelEncoder.js":
/*!***************************************************************!*\
  !*** ./node_modules/encodable/esm/encoders/ChannelEncoder.js ***!
  \***************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return ChannelEncoder; });\n/* harmony import */ var d3_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-array */ \"./node_modules/encodable/node_modules/d3-array/src/extent.js\");\n/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../types */ \"./node_modules/encodable/esm/types/scale/ScaleType.js\");\n/* harmony import */ var _typeGuards_ChannelDef__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../typeGuards/ChannelDef */ \"./node_modules/encodable/esm/typeGuards/ChannelDef.js\");\n/* harmony import */ var _typeGuards_Channel__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../typeGuards/Channel */ \"./node_modules/encodable/esm/typeGuards/Channel.js\");\n/* harmony import */ var _ChannelEncoderAxis__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ChannelEncoderAxis */ \"./node_modules/encodable/esm/encoders/ChannelEncoderAxis.js\");\n/* harmony import */ var _parsers_createGetterFromChannelDef__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../parsers/createGetterFromChannelDef */ \"./node_modules/encodable/esm/parsers/createGetterFromChannelDef.js\");\n/* harmony import */ var _fillers_completeChannelDef__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../fillers/completeChannelDef */ \"./node_modules/encodable/esm/fillers/completeChannelDef.js\");\n/* harmony import */ var _parsers_scale_createScale__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../parsers/scale/createScale */ \"./node_modules/encodable/esm/parsers/scale/createScale.js\");\n/* harmony import */ var _utils_identity__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils/identity */ \"./node_modules/encodable/esm/utils/identity.js\");\n/* harmony import */ var _parsers_scale_applyDomain__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../parsers/scale/applyDomain */ \"./node_modules/encodable/esm/parsers/scale/applyDomain.js\");\n/* harmony import */ var _parsers_scale_applyRange__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../parsers/scale/applyRange */ \"./node_modules/encodable/esm/parsers/scale/applyRange.js\");\n/* harmony import */ var _parsers_scale_applyZero__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../parsers/scale/applyZero */ \"./node_modules/encodable/esm/parsers/scale/applyZero.js\");\n/* harmony import */ var _parsers_scale_applyNice__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../parsers/scale/applyNice */ \"./node_modules/encodable/esm/parsers/scale/applyNice.js\");\n/* harmony import */ var _typeGuards_CompleteChannelDef__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../typeGuards/CompleteChannelDef */ \"./node_modules/encodable/esm/typeGuards/CompleteChannelDef.js\");\n/* harmony import */ var _parsers_format_fallbackFormatter__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../parsers/format/fallbackFormatter */ \"./node_modules/encodable/esm/parsers/format/fallbackFormatter.js\");\n/* harmony import */ var _parsers_format_createFormatter__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../parsers/format/createFormatter */ \"./node_modules/encodable/esm/parsers/format/createFormatter.js\");\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nclass ChannelEncoder {\n  constructor({\n    name,\n    channelType,\n    definition: originalDefinition\n  }) {\n    _defineProperty(this, \"name\", void 0);\n\n    _defineProperty(this, \"channelType\", void 0);\n\n    _defineProperty(this, \"originalDefinition\", void 0);\n\n    _defineProperty(this, \"definition\", void 0);\n\n    _defineProperty(this, \"scale\", void 0);\n\n    _defineProperty(this, \"axis\", void 0);\n\n    _defineProperty(this, \"getValue\", void 0);\n\n    _defineProperty(this, \"encodeFunc\", void 0);\n\n    _defineProperty(this, \"formatValue\", void 0);\n\n    _defineProperty(this, \"encodeValue\", (value, otherwise) => {\n      if (typeof otherwise !== 'undefined' && (value === null || typeof value === 'undefined')) {\n        return otherwise;\n      } // eslint-disable-next-line @typescript-eslint/no-explicit-any\n\n\n      return this.encodeFunc(value);\n    });\n\n    _defineProperty(this, \"encodeDatum\", (datum, otherwise) => typeof otherwise === 'undefined' ? this.encodeValue(this.getValueFromDatum(datum)) : this.encodeValue(this.getValueFromDatum(datum), otherwise));\n\n    _defineProperty(this, \"formatDatum\", datum => this.formatValue(this.getValueFromDatum(datum)));\n\n    _defineProperty(this, \"getValueFromDatum\", (datum, otherwise) => {\n      const value = this.getValue(datum);\n      return otherwise !== undefined && (value === null || value === undefined) ? otherwise : value;\n    });\n\n    _defineProperty(this, \"getDomainFromDataset\", data => {\n      if (Object(_typeGuards_ChannelDef__WEBPACK_IMPORTED_MODULE_2__[\"isValueDef\"])(this.definition)) {\n        const {\n          value\n        } = this.definition;\n        return [value];\n      }\n\n      const {\n        type\n      } = this.definition;\n\n      if (type === 'nominal' || type === 'ordinal') {\n        return Array.from(new Set(data.map(d => this.getValueFromDatum(d))));\n      }\n\n      if (type === 'quantitative') {\n        // Quantile scale needs all items\n        // because it treats domain as a discrete set of sample values\n        // for computing the quantiles\n        if (this.definition.scale && this.definition.scale.type === 'quantile') {\n          return data.map(d => this.getValueFromDatum(d));\n        }\n\n        const extent = Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(data, d => this.getValueFromDatum(d));\n        return typeof extent[0] === 'undefined' ? [0, 1] : extent;\n      }\n\n      if (type === 'temporal') {\n        const extent = Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(data, d => this.getValueFromDatum(d));\n        return typeof extent[0] === 'undefined' ? [0, 1] : extent;\n      }\n\n      return [];\n    });\n\n    this.name = name;\n    this.channelType = channelType;\n    this.originalDefinition = originalDefinition;\n    this.definition = Object(_fillers_completeChannelDef__WEBPACK_IMPORTED_MODULE_6__[\"default\"])(this.channelType, originalDefinition);\n    this.getValue = Object(_parsers_createGetterFromChannelDef__WEBPACK_IMPORTED_MODULE_5__[\"default\"])(this.definition);\n    this.formatValue = Object(_typeGuards_ChannelDef__WEBPACK_IMPORTED_MODULE_2__[\"isFieldDef\"])(this.definition) ? Object(_parsers_format_createFormatter__WEBPACK_IMPORTED_MODULE_15__[\"default\"])(this.definition) : _parsers_format_fallbackFormatter__WEBPACK_IMPORTED_MODULE_14__[\"default\"];\n\n    if (this.definition.scale) {\n      const scale = Object(_parsers_scale_createScale__WEBPACK_IMPORTED_MODULE_7__[\"default\"])(this.definition.scale); // eslint-disable-next-line @typescript-eslint/no-explicit-any\n\n      this.encodeFunc = value => scale(value);\n\n      this.scale = scale;\n    } else {\n      const {\n        definition\n      } = this;\n      this.encodeFunc = Object(_typeGuards_CompleteChannelDef__WEBPACK_IMPORTED_MODULE_13__[\"isCompleteValueDef\"])(definition) ? () => definition.value : _utils_identity__WEBPACK_IMPORTED_MODULE_8__[\"default\"];\n    }\n\n    if (this.definition.axis) {\n      this.axis = new _ChannelEncoderAxis__WEBPACK_IMPORTED_MODULE_4__[\"default\"](this);\n    }\n  }\n\n  getDomain() {\n    if (this.scale && 'domain' in this.scale) {\n      return this.scale.domain();\n    }\n\n    return [];\n  }\n\n  setDomain(domain) {\n    if (this.definition.scale !== false && this.scale && !this.hasCategoricalColorScale() && 'domain' in this.scale) {\n      const config = this.definition.scale;\n      Object(_parsers_scale_applyDomain__WEBPACK_IMPORTED_MODULE_9__[\"default\"])(config, this.scale, domain);\n      Object(_parsers_scale_applyRange__WEBPACK_IMPORTED_MODULE_10__[\"default\"])(config, this.scale);\n      Object(_parsers_scale_applyZero__WEBPACK_IMPORTED_MODULE_11__[\"default\"])(config, this.scale);\n      Object(_parsers_scale_applyNice__WEBPACK_IMPORTED_MODULE_12__[\"default\"])(config, this.scale);\n    }\n\n    return this;\n  }\n\n  setDomainFromDataset(data) {\n    return this.scale && 'domain' in this.scale ? this.setDomain(this.getDomainFromDataset(data)) : this;\n  }\n\n  getTitle() {\n    return this.definition.title;\n  }\n\n  isGroupBy() {\n    if (Object(_typeGuards_ChannelDef__WEBPACK_IMPORTED_MODULE_2__[\"isTypedFieldDef\"])(this.definition)) {\n      const {\n        type\n      } = this.definition;\n      return this.channelType === 'Category' || this.channelType === 'Text' || this.channelType === 'Color' && (type === 'nominal' || type === 'ordinal') || Object(_typeGuards_Channel__WEBPACK_IMPORTED_MODULE_3__[\"isXOrY\"])(this.channelType) && (type === 'nominal' || type === 'ordinal');\n    }\n\n    return false;\n  }\n\n  isX() {\n    return Object(_typeGuards_Channel__WEBPACK_IMPORTED_MODULE_3__[\"isX\"])(this.channelType);\n  }\n\n  isXOrY() {\n    return Object(_typeGuards_Channel__WEBPACK_IMPORTED_MODULE_3__[\"isXOrY\"])(this.channelType);\n  }\n\n  isY() {\n    return Object(_typeGuards_Channel__WEBPACK_IMPORTED_MODULE_3__[\"isY\"])(this.channelType);\n  }\n\n  hasCategoricalColorScale() {\n    const config = this.definition.scale; // Scale type is ordinal with not given range\n    // (may have optional scheme)\n    // will become a categorical scale\n    // of named color scheme.\n    // A color scale from named color scheme may be shared among multiple components\n    // in the same namespace by default, so changing its domain affect all components.\n    // (Sounds like a bad idea.)\n    // This function is currently only being used to check\n    // whether to apply domain from dataset or not.\n    // An ordinal scale with user-specified color scheme as range array\n    // will return false from this function and be excluded from it.\n\n    return this.scale && config && config.type === _types__WEBPACK_IMPORTED_MODULE_1__[\"ScaleType\"].ORDINAL && typeof config.range === 'undefined';\n  }\n\n  hasLegend() {\n    return this.definition.legend !== false;\n  }\n\n  hasValueDefinition() {\n    return Object(_typeGuards_CompleteChannelDef__WEBPACK_IMPORTED_MODULE_13__[\"isCompleteValueDef\"])(this.definition);\n  }\n\n  hasFieldDefinition() {\n    return Object(_typeGuards_CompleteChannelDef__WEBPACK_IMPORTED_MODULE_13__[\"isCompleteFieldDef\"])(this.definition);\n  }\n\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/encoders/ChannelEncoder.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/encoders/ChannelEncoderAxis.js":
/*!*******************************************************************!*\
  !*** ./node_modules/encodable/esm/encoders/ChannelEncoderAxis.js ***!
  \*******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return ChannelEncoderAxis; });\n/* harmony import */ var _parsers_parseDateTime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../parsers/parseDateTime */ \"./node_modules/encodable/esm/parsers/parseDateTime.js\");\n/* harmony import */ var _utils_inferElementTypeFromUnionOfArrayTypes__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/inferElementTypeFromUnionOfArrayTypes */ \"./node_modules/encodable/esm/utils/inferElementTypeFromUnionOfArrayTypes.js\");\n/* harmony import */ var _typeGuards_DateTime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../typeGuards/DateTime */ \"./node_modules/encodable/esm/typeGuards/DateTime.js\");\n/* harmony import */ var _parsers_format_createFormatter__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../parsers/format/createFormatter */ \"./node_modules/encodable/esm/parsers/format/createFormatter.js\");\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\n\n\n\n\nclass ChannelEncoderAxis {\n  constructor(channelEncoder) {\n    _defineProperty(this, \"channelEncoder\", void 0);\n\n    _defineProperty(this, \"config\", void 0);\n\n    _defineProperty(this, \"formatValue\", void 0);\n\n    this.channelEncoder = channelEncoder;\n    this.config = channelEncoder.definition.axis;\n    this.formatValue = Object(_parsers_format_createFormatter__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(this.config);\n  }\n\n  getTitle() {\n    return this.config.title;\n  }\n\n  hasTitle() {\n    const {\n      title\n    } = this.config;\n    return title !== null && typeof title !== 'undefined' && title !== '';\n  }\n\n  getTickLabels() {\n    const {\n      tickCount,\n      values\n    } = this.config;\n\n    if (typeof values !== 'undefined') {\n      return Object(_utils_inferElementTypeFromUnionOfArrayTypes__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(values).map(v => this.formatValue(Object(_typeGuards_DateTime__WEBPACK_IMPORTED_MODULE_2__[\"isDateTime\"])(v) ? Object(_parsers_parseDateTime__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(v) : v));\n    }\n\n    const {\n      scale\n    } = this.channelEncoder;\n\n    if (scale && 'domain' in scale) {\n      const ticks = 'ticks' in scale ? scale.ticks(tickCount) : scale.domain();\n      return ticks.map(this.formatValue);\n    }\n\n    return [];\n  }\n\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/encoders/ChannelEncoderAxis.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/encoders/Encoder.js":
/*!********************************************************!*\
  !*** ./node_modules/encodable/esm/encoders/Encoder.js ***!
  \********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return Encoder; });\n/* harmony import */ var _typeGuards_ChannelDef__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../typeGuards/ChannelDef */ \"./node_modules/encodable/esm/typeGuards/ChannelDef.js\");\n/* harmony import */ var _typeGuards_Base__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../typeGuards/Base */ \"./node_modules/encodable/esm/typeGuards/Base.js\");\n/* harmony import */ var _ChannelEncoder__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ChannelEncoder */ \"./node_modules/encodable/esm/encoders/ChannelEncoder.js\");\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\n\n\n\nclass Encoder {\n  constructor({\n    channelTypes,\n    encoding\n  }) {\n    _defineProperty(this, \"encoding\", void 0);\n\n    _defineProperty(this, \"channelTypes\", void 0);\n\n    _defineProperty(this, \"channels\", void 0);\n\n    _defineProperty(this, \"legends\", void 0);\n\n    this.channelTypes = channelTypes;\n    this.encoding = encoding;\n    const channelNames = this.getChannelNames(); // Create channel encoders\n\n    const channels = {};\n    channelNames.forEach(name => {\n      const channelEncoding = encoding[name];\n\n      if (Array.isArray(channelEncoding)) {\n        const definitions = channelEncoding;\n        channels[name] = definitions.map((definition, i) => new _ChannelEncoder__WEBPACK_IMPORTED_MODULE_2__[\"default\"]({\n          channelType: channelTypes[name],\n          definition,\n          name: name + \"[\" + i + \"]\"\n        }));\n      } else {\n        const definition = channelEncoding;\n        channels[name] = new _ChannelEncoder__WEBPACK_IMPORTED_MODULE_2__[\"default\"]({\n          channelType: channelTypes[name],\n          definition,\n          name: name\n        });\n      }\n    });\n    this.channels = channels; // Group the channels that use the same field together\n    // so they can share the same legend.\n\n    this.legends = {};\n    channelNames.map(name => this.channels[name]).forEach(c => {\n      if (Object(_typeGuards_Base__WEBPACK_IMPORTED_MODULE_1__[\"isNotArray\"])(c) && c.hasLegend() && Object(_typeGuards_ChannelDef__WEBPACK_IMPORTED_MODULE_0__[\"isTypedFieldDef\"])(c.definition)) {\n        const {\n          field\n        } = c.definition;\n        const channelEncoder = c;\n\n        if (this.legends[field]) {\n          this.legends[field].push(channelEncoder);\n        } else {\n          this.legends[field] = [channelEncoder];\n        }\n      }\n    });\n  }\n\n  getChannelNames() {\n    return Object.keys(this.channelTypes);\n  }\n\n  getChannelEncoders() {\n    return this.getChannelNames().flatMap(name => this.channels[name]);\n  }\n\n  getGroupBys() {\n    const fields = this.getChannelEncoders().filter(c => c.isGroupBy()).map(c => c.definition.field);\n    return Array.from(new Set(fields));\n  }\n\n  createLegendItemsFactory(field) {\n    const channelEncoders = this.getChannelEncoders().filter(e => Object(_typeGuards_Base__WEBPACK_IMPORTED_MODULE_1__[\"isNotArray\"])(e) && Object(_typeGuards_ChannelDef__WEBPACK_IMPORTED_MODULE_0__[\"isValueDef\"])(e.definition)).flat().concat(this.legends[field]);\n    return domain => domain.map(input => ({\n      input,\n      output: channelEncoders.reduce((prev, curr) => {\n        const map = prev;\n        map[curr.name] = curr.encodeValue(input);\n        return map;\n      }, {})\n    }));\n  }\n\n  getLegendInformation(data = []) {\n    return Object.keys(this.legends) // for each field that was encoded\n    .map(field => {\n      // get all the channels that use this field\n      const channelEncoders = this.legends[field];\n      const firstEncoder = channelEncoders[0];\n      const definition = firstEncoder.definition;\n      const createLegendItems = this.createLegendItemsFactory(field);\n\n      if (definition.type === 'nominal') {\n        return {\n          channelEncoders,\n          createLegendItems,\n          field,\n          items: createLegendItems(firstEncoder.getDomainFromDataset(data)),\n          type: definition.type\n        };\n      }\n\n      return {\n        channelEncoders,\n        createLegendItems,\n        field,\n        type: definition.type\n      };\n    });\n  }\n\n  setDomainFromDataset(data) {\n    this.getChannelEncoders().forEach(channelEncoder => {\n      channelEncoder.setDomainFromDataset(data);\n    });\n    return this;\n  }\n\n  hasLegend() {\n    return Object.keys(this.legends).length > 0;\n  }\n\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/encoders/Encoder.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/encoders/createEncoderFactory.js":
/*!*********************************************************************!*\
  !*** ./node_modules/encodable/esm/encoders/createEncoderFactory.js ***!
  \*********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return createEncoderFactory; });\n/* harmony import */ var reselect__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! reselect */ \"./node_modules/reselect/es/index.js\");\n/* harmony import */ var _Encoder__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Encoder */ \"./node_modules/encodable/esm/encoders/Encoder.js\");\n/* harmony import */ var _utils_mergeEncoding__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/mergeEncoding */ \"./node_modules/encodable/esm/utils/mergeEncoding.js\");\n\n\n\nfunction createEncoderFactory(params) {\n  const {\n    channelTypes\n  } = params;\n  const completeEncoding = 'defaultEncoding' in params ? encoding => Object(_utils_mergeEncoding__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(params.defaultEncoding, encoding) : params.completeEncoding;\n\n  const create = (encoding = {}) => new _Encoder__WEBPACK_IMPORTED_MODULE_1__[\"default\"]({\n    channelTypes,\n    encoding: completeEncoding(encoding)\n  });\n\n  return {\n    channelTypes,\n    create,\n    createSelector: () => Object(reselect__WEBPACK_IMPORTED_MODULE_0__[\"createSelector\"])(encoding => encoding, create),\n    DEFAULT_ENCODING: completeEncoding({})\n  };\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9lbmNvZGVycy9jcmVhdGVFbmNvZGVyRmFjdG9yeS5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9lbmNvZGFibGUvZXNtL2VuY29kZXJzL2NyZWF0ZUVuY29kZXJGYWN0b3J5LmpzPzU0NWEiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgY3JlYXRlU2VsZWN0b3IgfSBmcm9tICdyZXNlbGVjdCc7XG5pbXBvcnQgRW5jb2RlciBmcm9tICcuL0VuY29kZXInO1xuaW1wb3J0IG1lcmdlRW5jb2RpbmcgZnJvbSAnLi4vdXRpbHMvbWVyZ2VFbmNvZGluZyc7XG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiBjcmVhdGVFbmNvZGVyRmFjdG9yeShwYXJhbXMpIHtcbiAgY29uc3Qge1xuICAgIGNoYW5uZWxUeXBlc1xuICB9ID0gcGFyYW1zO1xuICBjb25zdCBjb21wbGV0ZUVuY29kaW5nID0gJ2RlZmF1bHRFbmNvZGluZycgaW4gcGFyYW1zID8gZW5jb2RpbmcgPT4gbWVyZ2VFbmNvZGluZyhwYXJhbXMuZGVmYXVsdEVuY29kaW5nLCBlbmNvZGluZykgOiBwYXJhbXMuY29tcGxldGVFbmNvZGluZztcblxuICBjb25zdCBjcmVhdGUgPSAoZW5jb2RpbmcgPSB7fSkgPT4gbmV3IEVuY29kZXIoe1xuICAgIGNoYW5uZWxUeXBlcyxcbiAgICBlbmNvZGluZzogY29tcGxldGVFbmNvZGluZyhlbmNvZGluZylcbiAgfSk7XG5cbiAgcmV0dXJuIHtcbiAgICBjaGFubmVsVHlwZXMsXG4gICAgY3JlYXRlLFxuICAgIGNyZWF0ZVNlbGVjdG9yOiAoKSA9PiBjcmVhdGVTZWxlY3RvcihlbmNvZGluZyA9PiBlbmNvZGluZywgY3JlYXRlKSxcbiAgICBERUZBVUxUX0VOQ09ESU5HOiBjb21wbGV0ZUVuY29kaW5nKHt9KVxuICB9O1xufSJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/encoders/createEncoderFactory.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/fillers/completeAxisConfig.js":
/*!******************************************************************!*\
  !*** ./node_modules/encodable/esm/fillers/completeAxisConfig.js ***!
  \******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return completeAxisConfig; });\n/* harmony import */ var _utils_isEnabled__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/isEnabled */ \"./node_modules/encodable/esm/utils/isEnabled.js\");\n/* harmony import */ var _typeGuards_Channel__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../typeGuards/Channel */ \"./node_modules/encodable/esm/typeGuards/Channel.js\");\n/* harmony import */ var _typeGuards_ChannelDef__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../typeGuards/ChannelDef */ \"./node_modules/encodable/esm/typeGuards/ChannelDef.js\");\n/* harmony import */ var _expandLabelOverlapStrategy__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./expandLabelOverlapStrategy */ \"./node_modules/encodable/esm/fillers/expandLabelOverlapStrategy.js\");\n/* harmony import */ var _parsers_scale_scaleCategories__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../parsers/scale/scaleCategories */ \"./node_modules/encodable/esm/parsers/scale/scaleCategories.js\");\n\n\n\n\n\n\nfunction isChannelDefWithAxisSupport(channelType, channelDef) {\n  return Object(_typeGuards_ChannelDef__WEBPACK_IMPORTED_MODULE_2__[\"isTypedFieldDef\"])(channelDef) && Object(_typeGuards_Channel__WEBPACK_IMPORTED_MODULE_1__[\"isXOrY\"])(channelType);\n}\n\nfunction completeAxisConfig(channelType, channelDef) {\n  if (isChannelDefWithAxisSupport(channelType, channelDef) && Object(_utils_isEnabled__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(channelDef.axis)) {\n    const axis = channelDef.axis === true || typeof channelDef.axis === 'undefined' ? {} : channelDef.axis;\n    const isXChannel = Object(_typeGuards_Channel__WEBPACK_IMPORTED_MODULE_1__[\"isX\"])(channelType);\n    const {\n      format = channelDef.format,\n      formatType = channelDef.formatType,\n      formatInLocalTime = channelDef.formatInLocalTime,\n      labelAngle = 0,\n      labelFlush,\n      labelOverlap,\n      labelPadding = 4,\n      orient = isXChannel ? 'bottom' : 'left',\n      tickCount = 5,\n      ticks = true,\n      title = channelDef.title,\n      titlePadding = 4\n    } = axis;\n    const output = { ...axis,\n      format,\n      formatType,\n      labelAngle,\n      labelFlush: typeof labelFlush === 'undefined' ? channelDef.scale && typeof channelDef.scale.type !== 'undefined' && _parsers_scale_scaleCategories__WEBPACK_IMPORTED_MODULE_4__[\"continuousToContinuousScaleTypesSet\"].has(channelDef.scale.type) : labelFlush,\n      labelOverlap: Object(_expandLabelOverlapStrategy__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(channelType, labelOverlap),\n      labelPadding,\n      orient,\n      tickCount,\n      ticks,\n      title,\n      titlePadding\n    };\n\n    if (typeof formatInLocalTime !== 'undefined') {\n      output.formatInLocalTime = formatInLocalTime;\n    }\n\n    return output;\n  }\n\n  return false;\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/fillers/completeAxisConfig.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/fillers/completeChannelDef.js":
/*!******************************************************************!*\
  !*** ./node_modules/encodable/esm/fillers/completeChannelDef.js ***!
  \******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return completeChannelDef; });\n/* harmony import */ var _typeGuards_ChannelDef__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../typeGuards/ChannelDef */ \"./node_modules/encodable/esm/typeGuards/ChannelDef.js\");\n/* harmony import */ var _completeAxisConfig__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./completeAxisConfig */ \"./node_modules/encodable/esm/fillers/completeAxisConfig.js\");\n/* harmony import */ var _completeFormatConfig__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./completeFormatConfig */ \"./node_modules/encodable/esm/fillers/completeFormatConfig.js\");\n/* harmony import */ var _completeLegendConfig__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./completeLegendConfig */ \"./node_modules/encodable/esm/fillers/completeLegendConfig.js\");\n/* harmony import */ var _completeScaleConfig__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./completeScaleConfig */ \"./node_modules/encodable/esm/fillers/completeScaleConfig.js\");\n/* harmony import */ var _inferFieldType__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./inferFieldType */ \"./node_modules/encodable/esm/fillers/inferFieldType.js\");\n\n\n\n\n\n\nfunction completeChannelDef(channelType, channelDef) {\n  var _channelDef$title;\n\n  if (Object(_typeGuards_ChannelDef__WEBPACK_IMPORTED_MODULE_0__[\"isValueDef\"])(channelDef)) {\n    return { ...channelDef,\n      axis: false,\n      legend: false,\n      scale: false,\n      title: ''\n    };\n  } // Fill top-level properties\n\n\n  const copy = { ...channelDef,\n    title: Object(_typeGuards_ChannelDef__WEBPACK_IMPORTED_MODULE_0__[\"isFieldDef\"])(channelDef) ? (_channelDef$title = channelDef.title) != null ? _channelDef$title : channelDef.field : '',\n    type: Object(_typeGuards_ChannelDef__WEBPACK_IMPORTED_MODULE_0__[\"isTypedFieldDef\"])(channelDef) ? channelDef.type : Object(_inferFieldType__WEBPACK_IMPORTED_MODULE_5__[\"default\"])(channelType, channelDef.field)\n  }; // Scale needs the top-level properties to be filled.\n\n  const scale = Object(_completeScaleConfig__WEBPACK_IMPORTED_MODULE_4__[\"default\"])(channelType, copy); // Format needs scale.\n\n  const format = Object(_completeFormatConfig__WEBPACK_IMPORTED_MODULE_2__[\"default\"])({ ...channelDef,\n    scaleType: scale ? scale.type : undefined\n  });\n  const copy2 = { ...copy,\n    ...format,\n    scale\n  }; // These need scale and format\n\n  const axis = Object(_completeAxisConfig__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(channelType, copy2);\n  const legend = Object(_completeLegendConfig__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(channelType, copy2);\n  return { ...copy2,\n    axis,\n    legend\n  };\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/fillers/completeChannelDef.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/fillers/completeFormatConfig.js":
/*!********************************************************************!*\
  !*** ./node_modules/encodable/esm/fillers/completeFormatConfig.js ***!
  \********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return completeFormatConfig; });\nfunction completeFormatConfig(config) {\n  const {\n    formatType,\n    formatInLocalTime,\n    format,\n    type,\n    scaleType\n  } = config;\n  let resolvedFormatType;\n\n  if (typeof formatType !== 'undefined') {\n    resolvedFormatType = formatType;\n  } else if (type === 'quantitative') {\n    resolvedFormatType = 'number';\n  } else if (type === 'temporal' || scaleType === 'time' || scaleType === 'utc') {\n    resolvedFormatType = 'time';\n  } else if (typeof format !== 'undefined' && format.length > 0) {\n    resolvedFormatType = 'number';\n  }\n\n  if (resolvedFormatType === 'time') {\n    return {\n      formatType: 'time',\n      formatInLocalTime: formatInLocalTime || typeof formatInLocalTime === 'undefined' && scaleType === 'time',\n      format\n    };\n  }\n\n  return {\n    formatType: resolvedFormatType,\n    format\n  };\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9maWxsZXJzL2NvbXBsZXRlRm9ybWF0Q29uZmlnLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9lc20vZmlsbGVycy9jb21wbGV0ZUZvcm1hdENvbmZpZy5qcz80ZDI2Il0sInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIGNvbXBsZXRlRm9ybWF0Q29uZmlnKGNvbmZpZykge1xuICBjb25zdCB7XG4gICAgZm9ybWF0VHlwZSxcbiAgICBmb3JtYXRJbkxvY2FsVGltZSxcbiAgICBmb3JtYXQsXG4gICAgdHlwZSxcbiAgICBzY2FsZVR5cGVcbiAgfSA9IGNvbmZpZztcbiAgbGV0IHJlc29sdmVkRm9ybWF0VHlwZTtcblxuICBpZiAodHlwZW9mIGZvcm1hdFR5cGUgIT09ICd1bmRlZmluZWQnKSB7XG4gICAgcmVzb2x2ZWRGb3JtYXRUeXBlID0gZm9ybWF0VHlwZTtcbiAgfSBlbHNlIGlmICh0eXBlID09PSAncXVhbnRpdGF0aXZlJykge1xuICAgIHJlc29sdmVkRm9ybWF0VHlwZSA9ICdudW1iZXInO1xuICB9IGVsc2UgaWYgKHR5cGUgPT09ICd0ZW1wb3JhbCcgfHwgc2NhbGVUeXBlID09PSAndGltZScgfHwgc2NhbGVUeXBlID09PSAndXRjJykge1xuICAgIHJlc29sdmVkRm9ybWF0VHlwZSA9ICd0aW1lJztcbiAgfSBlbHNlIGlmICh0eXBlb2YgZm9ybWF0ICE9PSAndW5kZWZpbmVkJyAmJiBmb3JtYXQubGVuZ3RoID4gMCkge1xuICAgIHJlc29sdmVkRm9ybWF0VHlwZSA9ICdudW1iZXInO1xuICB9XG5cbiAgaWYgKHJlc29sdmVkRm9ybWF0VHlwZSA9PT0gJ3RpbWUnKSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGZvcm1hdFR5cGU6ICd0aW1lJyxcbiAgICAgIGZvcm1hdEluTG9jYWxUaW1lOiBmb3JtYXRJbkxvY2FsVGltZSB8fCB0eXBlb2YgZm9ybWF0SW5Mb2NhbFRpbWUgPT09ICd1bmRlZmluZWQnICYmIHNjYWxlVHlwZSA9PT0gJ3RpbWUnLFxuICAgICAgZm9ybWF0XG4gICAgfTtcbiAgfVxuXG4gIHJldHVybiB7XG4gICAgZm9ybWF0VHlwZTogcmVzb2x2ZWRGb3JtYXRUeXBlLFxuICAgIGZvcm1hdFxuICB9O1xufSJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/fillers/completeFormatConfig.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/fillers/completeLegendConfig.js":
/*!********************************************************************!*\
  !*** ./node_modules/encodable/esm/fillers/completeLegendConfig.js ***!
  \********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return completeLegendConfig; });\n/* harmony import */ var _typeGuards_Channel__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../typeGuards/Channel */ \"./node_modules/encodable/esm/typeGuards/Channel.js\");\n\nfunction completeLegendConfig(channelType, channelDef) {\n  if ('legend' in channelDef && channelDef.legend !== undefined) {\n    return channelDef.legend;\n  }\n\n  return Object(_typeGuards_Channel__WEBPACK_IMPORTED_MODULE_0__[\"isXOrY\"])(channelType) || channelType === 'Text' ? false : {};\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9maWxsZXJzL2NvbXBsZXRlTGVnZW5kQ29uZmlnLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9lc20vZmlsbGVycy9jb21wbGV0ZUxlZ2VuZENvbmZpZy5qcz9iNWUxIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGlzWE9yWSB9IGZyb20gJy4uL3R5cGVHdWFyZHMvQ2hhbm5lbCc7XG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiBjb21wbGV0ZUxlZ2VuZENvbmZpZyhjaGFubmVsVHlwZSwgY2hhbm5lbERlZikge1xuICBpZiAoJ2xlZ2VuZCcgaW4gY2hhbm5lbERlZiAmJiBjaGFubmVsRGVmLmxlZ2VuZCAhPT0gdW5kZWZpbmVkKSB7XG4gICAgcmV0dXJuIGNoYW5uZWxEZWYubGVnZW5kO1xuICB9XG5cbiAgcmV0dXJuIGlzWE9yWShjaGFubmVsVHlwZSkgfHwgY2hhbm5lbFR5cGUgPT09ICdUZXh0JyA/IGZhbHNlIDoge307XG59Il0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/fillers/completeLegendConfig.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/fillers/completeScaleConfig.js":
/*!*******************************************************************!*\
  !*** ./node_modules/encodable/esm/fillers/completeScaleConfig.js ***!
  \*******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return completeScaleConfig; });\n/* harmony import */ var _inferScaleType__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./inferScaleType */ \"./node_modules/encodable/esm/fillers/inferScaleType.js\");\n/* harmony import */ var _typeGuards_ChannelDef__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../typeGuards/ChannelDef */ \"./node_modules/encodable/esm/typeGuards/ChannelDef.js\");\n/* harmony import */ var _typeGuards_ScaleConfig__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../typeGuards/ScaleConfig */ \"./node_modules/encodable/esm/typeGuards/ScaleConfig.js\");\n/* harmony import */ var _utils_isEnabled__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/isEnabled */ \"./node_modules/encodable/esm/utils/isEnabled.js\");\n/* harmony import */ var _parsers_scale_scaleCategories__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../parsers/scale/scaleCategories */ \"./node_modules/encodable/esm/parsers/scale/scaleCategories.js\");\n\n\n\n\n\nfunction completeScaleConfig(channelType, channelDef) {\n  if (Object(_typeGuards_ChannelDef__WEBPACK_IMPORTED_MODULE_1__[\"isTypedFieldDef\"])(channelDef) && Object(_utils_isEnabled__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(channelDef.scale)) {\n    const {\n      scale = {},\n      type,\n      bin\n    } = channelDef;\n    const {\n      type: scaleType = Object(_inferScaleType__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(channelType, type, bin)\n    } = scale;\n\n    if (typeof scaleType === 'undefined') {\n      return false;\n    } // eslint-disable-next-line @typescript-eslint/consistent-type-assertions\n\n\n    const filledScale = { ...scale,\n      type: scaleType\n    };\n\n    if (Object(_typeGuards_ScaleConfig__WEBPACK_IMPORTED_MODULE_2__[\"isContinuousScaleConfig\"])(filledScale)) {\n      if (typeof filledScale.nice === 'undefined') {\n        filledScale.nice = !_parsers_scale_scaleCategories__WEBPACK_IMPORTED_MODULE_4__[\"timeScaleTypesSet\"].has(scaleType);\n      }\n\n      if (typeof filledScale.clamp === 'undefined') {\n        filledScale.clamp = true;\n      }\n    }\n\n    if (Object(_typeGuards_ScaleConfig__WEBPACK_IMPORTED_MODULE_2__[\"isScaleConfigWithZero\"])(filledScale) && typeof filledScale.zero === 'undefined') {\n      filledScale.zero = true;\n    }\n\n    return filledScale;\n  }\n\n  return false;\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/fillers/completeScaleConfig.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/fillers/expandLabelOverlapStrategy.js":
/*!**************************************************************************!*\
  !*** ./node_modules/encodable/esm/fillers/expandLabelOverlapStrategy.js ***!
  \**************************************************************************/
/*! exports provided: STRATEGY_FLAT, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"STRATEGY_FLAT\", function() { return STRATEGY_FLAT; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return expandLabelOverlapStrategy; });\n/* harmony import */ var _typeGuards_Channel__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../typeGuards/Channel */ \"./node_modules/encodable/esm/typeGuards/Channel.js\");\n\nconst STRATEGY_FLAT = {\n  strategy: 'flat'\n};\nconst STRATEGY_ROTATE = {\n  labelAngle: 40,\n  strategy: 'rotate'\n};\nfunction expandLabelOverlapStrategy(channelType, labelOverlap = 'auto') {\n  let output;\n\n  switch (labelOverlap) {\n    case 'flat':\n      output = STRATEGY_FLAT;\n      break;\n\n    case 'rotate':\n      output = STRATEGY_ROTATE;\n      break;\n\n    case 'auto':\n      output = Object(_typeGuards_Channel__WEBPACK_IMPORTED_MODULE_0__[\"isX\"])(channelType) ? STRATEGY_ROTATE : STRATEGY_FLAT;\n      break;\n\n    default:\n      output = labelOverlap;\n      break;\n  }\n\n  return { ...output\n  };\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9maWxsZXJzL2V4cGFuZExhYmVsT3ZlcmxhcFN0cmF0ZWd5LmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9lc20vZmlsbGVycy9leHBhbmRMYWJlbE92ZXJsYXBTdHJhdGVneS5qcz83MDdkIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGlzWCB9IGZyb20gJy4uL3R5cGVHdWFyZHMvQ2hhbm5lbCc7XG5leHBvcnQgY29uc3QgU1RSQVRFR1lfRkxBVCA9IHtcbiAgc3RyYXRlZ3k6ICdmbGF0J1xufTtcbmNvbnN0IFNUUkFURUdZX1JPVEFURSA9IHtcbiAgbGFiZWxBbmdsZTogNDAsXG4gIHN0cmF0ZWd5OiAncm90YXRlJ1xufTtcbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIGV4cGFuZExhYmVsT3ZlcmxhcFN0cmF0ZWd5KGNoYW5uZWxUeXBlLCBsYWJlbE92ZXJsYXAgPSAnYXV0bycpIHtcbiAgbGV0IG91dHB1dDtcblxuICBzd2l0Y2ggKGxhYmVsT3ZlcmxhcCkge1xuICAgIGNhc2UgJ2ZsYXQnOlxuICAgICAgb3V0cHV0ID0gU1RSQVRFR1lfRkxBVDtcbiAgICAgIGJyZWFrO1xuXG4gICAgY2FzZSAncm90YXRlJzpcbiAgICAgIG91dHB1dCA9IFNUUkFURUdZX1JPVEFURTtcbiAgICAgIGJyZWFrO1xuXG4gICAgY2FzZSAnYXV0byc6XG4gICAgICBvdXRwdXQgPSBpc1goY2hhbm5lbFR5cGUpID8gU1RSQVRFR1lfUk9UQVRFIDogU1RSQVRFR1lfRkxBVDtcbiAgICAgIGJyZWFrO1xuXG4gICAgZGVmYXVsdDpcbiAgICAgIG91dHB1dCA9IGxhYmVsT3ZlcmxhcDtcbiAgICAgIGJyZWFrO1xuICB9XG5cbiAgcmV0dXJuIHsgLi4ub3V0cHV0XG4gIH07XG59Il0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/fillers/expandLabelOverlapStrategy.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/fillers/inferFieldType.js":
/*!**************************************************************!*\
  !*** ./node_modules/encodable/esm/fillers/inferFieldType.js ***!
  \**************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return inferFieldType; });\n/* harmony import */ var _typeGuards_Channel__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../typeGuards/Channel */ \"./node_modules/encodable/esm/typeGuards/Channel.js\");\n\nconst temporalFieldNames = new Set(['time', 'date', 'datetime', 'timestamp']);\nfunction inferFieldType(channelType, field = '') {\n  if (Object(_typeGuards_Channel__WEBPACK_IMPORTED_MODULE_0__[\"isXOrY\"])(channelType) || channelType === 'Numeric') {\n    return temporalFieldNames.has(field.toLowerCase()) ? 'temporal' : 'quantitative';\n  }\n\n  return 'nominal';\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9maWxsZXJzL2luZmVyRmllbGRUeXBlLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9lc20vZmlsbGVycy9pbmZlckZpZWxkVHlwZS5qcz8zMTI3Il0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGlzWE9yWSB9IGZyb20gJy4uL3R5cGVHdWFyZHMvQ2hhbm5lbCc7XG5jb25zdCB0ZW1wb3JhbEZpZWxkTmFtZXMgPSBuZXcgU2V0KFsndGltZScsICdkYXRlJywgJ2RhdGV0aW1lJywgJ3RpbWVzdGFtcCddKTtcbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIGluZmVyRmllbGRUeXBlKGNoYW5uZWxUeXBlLCBmaWVsZCA9ICcnKSB7XG4gIGlmIChpc1hPclkoY2hhbm5lbFR5cGUpIHx8IGNoYW5uZWxUeXBlID09PSAnTnVtZXJpYycpIHtcbiAgICByZXR1cm4gdGVtcG9yYWxGaWVsZE5hbWVzLmhhcyhmaWVsZC50b0xvd2VyQ2FzZSgpKSA/ICd0ZW1wb3JhbCcgOiAncXVhbnRpdGF0aXZlJztcbiAgfVxuXG4gIHJldHVybiAnbm9taW5hbCc7XG59Il0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/fillers/inferFieldType.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/fillers/inferScaleType.js":
/*!**************************************************************!*\
  !*** ./node_modules/encodable/esm/fillers/inferScaleType.js ***!
  \**************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return inferScaleType; });\n/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../types */ \"./node_modules/encodable/esm/types/scale/ScaleType.js\");\n\n/**\n * Sometimes scale type is not specified but can be inferred\n * from other fields.\n * See https://vega.github.io/vega-lite/docs/scale.html\n * @param channelType type of the channel\n * @param fieldType type of the field\n * @param bin is value binned\n */\n\nfunction inferScaleType(channelType, fieldType, bin = false) {\n  if (fieldType === 'nominal' || fieldType === 'ordinal') {\n    switch (channelType) {\n      // For positional (x and y) ordinal and ordinal fields,\n      // \"point\" is the default scale type for all marks\n      // except bar and rect marks, which use \"band\" scales.\n      // https://vega.github.io/vega-lite/docs/scale.html\n      case 'XBand':\n      case 'YBand':\n        return _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].BAND;\n\n      case 'X':\n      case 'Y':\n      case 'Numeric':\n        return _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].POINT;\n\n      case 'Color':\n      case 'Category':\n        return _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].ORDINAL;\n\n      default:\n    }\n  } else if (fieldType === 'quantitative') {\n    switch (channelType) {\n      case 'XBand':\n      case 'YBand':\n      case 'X':\n      case 'Y':\n      case 'Numeric':\n        return _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].LINEAR;\n\n      case 'Color':\n        return bin ? _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].BIN_ORDINAL : _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].LINEAR;\n\n      default:\n    }\n  } else if (fieldType === 'temporal') {\n    switch (channelType) {\n      case 'XBand':\n      case 'YBand':\n      case 'X':\n      case 'Y':\n      case 'Numeric':\n        return _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].UTC;\n\n      case 'Color':\n        return _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].LINEAR;\n\n      default:\n    }\n  }\n\n  return undefined;\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/fillers/inferScaleType.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/parsers/createGetterFromChannelDef.js":
/*!**************************************************************************!*\
  !*** ./node_modules/encodable/esm/parsers/createGetterFromChannelDef.js ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return createGetterFromChannelDef; });\n/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash.get */ \"./node_modules/lodash.get/index.js\");\n/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _typeGuards_ChannelDef__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../typeGuards/ChannelDef */ \"./node_modules/encodable/esm/typeGuards/ChannelDef.js\");\n\n\nfunction createGetterFromChannelDef(definition) {\n  if (Object(_typeGuards_ChannelDef__WEBPACK_IMPORTED_MODULE_1__[\"isValueDef\"])(definition)) {\n    return () => definition.value;\n  }\n\n  if (typeof definition.field !== 'undefined') {\n    return x => lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(x, definition.field);\n  }\n\n  return () => undefined;\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9wYXJzZXJzL2NyZWF0ZUdldHRlckZyb21DaGFubmVsRGVmLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9lc20vcGFyc2Vycy9jcmVhdGVHZXR0ZXJGcm9tQ2hhbm5lbERlZi5qcz9lMzk0Il0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBnZXQgZnJvbSAnbG9kYXNoLmdldCc7XG5pbXBvcnQgeyBpc1ZhbHVlRGVmIH0gZnJvbSAnLi4vdHlwZUd1YXJkcy9DaGFubmVsRGVmJztcbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIGNyZWF0ZUdldHRlckZyb21DaGFubmVsRGVmKGRlZmluaXRpb24pIHtcbiAgaWYgKGlzVmFsdWVEZWYoZGVmaW5pdGlvbikpIHtcbiAgICByZXR1cm4gKCkgPT4gZGVmaW5pdGlvbi52YWx1ZTtcbiAgfVxuXG4gIGlmICh0eXBlb2YgZGVmaW5pdGlvbi5maWVsZCAhPT0gJ3VuZGVmaW5lZCcpIHtcbiAgICByZXR1cm4geCA9PiBnZXQoeCwgZGVmaW5pdGlvbi5maWVsZCk7XG4gIH1cblxuICByZXR1cm4gKCkgPT4gdW5kZWZpbmVkO1xufSJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/parsers/createGetterFromChannelDef.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/parsers/dateTimeToTimestamp.js":
/*!*******************************************************************!*\
  !*** ./node_modules/encodable/esm/parsers/dateTimeToTimestamp.js ***!
  \*******************************************************************/
/*! exports provided: normalizeQuarter, normalizeMonth, normalizeDay, dateTimeParts, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"normalizeQuarter\", function() { return normalizeQuarter; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"normalizeMonth\", function() { return normalizeMonth; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"normalizeDay\", function() { return normalizeDay; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"dateTimeParts\", function() { return dateTimeParts; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return dateTimeToTimestamp; });\n/* harmony import */ var _utils_keys__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/keys */ \"./node_modules/encodable/esm/utils/keys.js\");\n// Modified from vega-lite version\n// and remove unnecessary dependency\n\n/* eslint-disable no-param-reassign */\n\n/* eslint-disable no-negated-condition */\n\n/**\n * Internal Object for defining datetime expressions.\n * This is an expression version of DateTime.\n * If both month and quarter are provided, month has higher precedence.\n * `day` cannot be combined with other date.\n */\n\nfunction invalidTimeUnit(unitName, value) {\n  return \"Invalid \" + unitName + \": \" + String(value) + \".\";\n}\n/*\n * A designated year that starts on Sunday.\n */\n\n\nconst SUNDAY_YEAR = 2006;\nconst MONTHS = ['january', 'february', 'march', 'april', 'may', 'june', 'july', 'august', 'september', 'october', 'november', 'december'];\nconst SHORT_MONTHS = MONTHS.map(m => m.slice(0, 3));\nconst DAYS = ['sunday', 'monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday'];\nconst SHORT_DAYS = DAYS.map(d => d.slice(0, 3));\n\nfunction isNumber(x) {\n  return typeof x === 'number';\n}\n/**\n * Returns whether the passed in value is a valid number.\n */\n\n\nfunction isNumeric(value) {\n  if (isNumber(value)) {\n    return true;\n  } // eslint-disable-next-line @typescript-eslint/no-explicit-any\n\n\n  return !isNaN(value) && !isNaN(parseFloat(value));\n}\n\nfunction normalizeQuarter(q) {\n  if (isNumeric(q)) {\n    q = Number(q);\n  }\n\n  if (isNumber(q)) {\n    if (q > 4) {\n      // eslint-disable-next-line no-console\n      console.warn(invalidTimeUnit('quarter', q));\n    } // We accept 1-based quarter, so need to readjust to 0-based quarter\n\n\n    return q - 1;\n  } // Invalid quarter\n\n\n  throw new Error(invalidTimeUnit('quarter', q));\n}\nfunction normalizeMonth(m) {\n  if (isNumeric(m)) {\n    m = Number(m);\n  }\n\n  if (isNumber(m)) {\n    // We accept 1-based month, so need to readjust to 0-based month\n    return m - 1;\n  }\n\n  const lowerM = m.toLowerCase();\n  const monthIndex = MONTHS.indexOf(lowerM);\n\n  if (monthIndex !== -1) {\n    return monthIndex; // 0 for january, ...\n  }\n\n  const shortM = lowerM.slice(0, 3);\n  const shortMonthIndex = SHORT_MONTHS.indexOf(shortM);\n\n  if (shortMonthIndex !== -1) {\n    return shortMonthIndex;\n  } // Invalid month\n\n\n  throw new Error(invalidTimeUnit('month', m));\n}\nfunction normalizeDay(d) {\n  if (isNumeric(d)) {\n    d = Number(d);\n  }\n\n  if (isNumber(d)) {\n    // mod so that this can be both 0-based where 0 = sunday\n    // and 1-based where 7=sunday\n    return d % 7;\n  }\n\n  const lowerD = d.toLowerCase();\n  const dayIndex = DAYS.indexOf(lowerD);\n\n  if (dayIndex !== -1) {\n    return dayIndex; // 0 for january, ...\n  }\n\n  const shortD = lowerD.slice(0, 3);\n  const shortDayIndex = SHORT_DAYS.indexOf(shortD);\n\n  if (shortDayIndex !== -1) {\n    return shortDayIndex;\n  } // Invalid day\n\n\n  throw new Error(invalidTimeUnit('day', d));\n}\n/**\n * @param d the date.\n * @param normalize whether to normalize quarter, month, day. This should probably be true if d is a DateTime.\n * @returns array of date time parts [year, month, day, hours, minutes, seconds, milliseconds]\n */\n\nfunction dateTimeParts(d, normalize) {\n  const parts = [];\n\n  if (normalize && d.day !== undefined) {\n    if (Object(_utils_keys__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(d).length > 1) {\n      d = { ...d\n      };\n      delete d.day;\n    }\n  }\n\n  if (d.year !== undefined) {\n    parts.push(d.year);\n  } else if (d.day !== undefined) {\n    // Set year to 2006 for working with day since January 1 2006 is a Sunday\n    parts.push(SUNDAY_YEAR);\n  } else {\n    parts.push(0);\n  }\n\n  if (d.month !== undefined) {\n    const month = normalize ? normalizeMonth(d.month) : d.month;\n    parts.push(month);\n  } else if (d.quarter !== undefined) {\n    const quarter = normalize ? normalizeQuarter(d.quarter) : d.quarter;\n    parts.push(isNumber(quarter) ? quarter * 3 : quarter + \"*3\");\n  } else {\n    parts.push(0); // months start at zero in JS\n  }\n\n  if (d.date !== undefined) {\n    parts.push(d.date);\n  } else if (d.day !== undefined) {\n    // HACK: Day only works as a standalone unit\n    // This is only correct because we always set year to 2006 for day\n    const day = normalize ? normalizeDay(d.day) : d.day;\n    parts.push(isNumber(day) ? day + 1 : day + \"+1\");\n  } else {\n    parts.push(1); // Date starts at 1 in JS\n  }\n\n  ['hours', 'minutes', 'seconds', 'milliseconds'].forEach(timeUnit => {\n    const unit = d[timeUnit];\n    parts.push(typeof unit === 'undefined' ? 0 : unit);\n  });\n  return parts;\n}\n/**\n * @param d the date time.\n * @returns the timestamp.\n */\n\nfunction dateTimeToTimestamp(d) {\n  const parts = dateTimeParts(d, true);\n\n  if (d.utc) {\n    // eslint-disable-next-line @typescript-eslint/no-explicit-any\n    return Number(new Date(Date.UTC(...parts)));\n  } // eslint-disable-next-line @typescript-eslint/no-explicit-any\n\n\n  return Number(new Date(...parts));\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/parsers/dateTimeToTimestamp.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/parsers/domain/parseContinuousDomain.js":
/*!****************************************************************************!*\
  !*** ./node_modules/encodable/esm/parsers/domain/parseContinuousDomain.js ***!
  \****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return parseContinuousDomain; });\n/* harmony import */ var _scale_scaleCategories__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../scale/scaleCategories */ \"./node_modules/encodable/esm/parsers/scale/scaleCategories.js\");\n\n/**\n * Convert each element in the array into\n * - Date (for time scales)\n * - number (for other continuous scales)\n * @param domain\n * @param scaleType\n */\n\nfunction parseContinuousDomain(domain, scaleType) {\n  if (_scale_scaleCategories__WEBPACK_IMPORTED_MODULE_0__[\"timeScaleTypesSet\"].has(scaleType)) {\n    return domain.filter(d => typeof d !== 'boolean').map(d => typeof d === 'string' || typeof d === 'number' ? new Date(d) : d);\n  }\n\n  return domain.map(d => typeof d === 'string' || typeof d === 'boolean' ? Number(d) : d);\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9wYXJzZXJzL2RvbWFpbi9wYXJzZUNvbnRpbnVvdXNEb21haW4uanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9wYXJzZXJzL2RvbWFpbi9wYXJzZUNvbnRpbnVvdXNEb21haW4uanM/ZTQ3ZSJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyB0aW1lU2NhbGVUeXBlc1NldCB9IGZyb20gJy4uL3NjYWxlL3NjYWxlQ2F0ZWdvcmllcyc7XG4vKipcbiAqIENvbnZlcnQgZWFjaCBlbGVtZW50IGluIHRoZSBhcnJheSBpbnRvXG4gKiAtIERhdGUgKGZvciB0aW1lIHNjYWxlcylcbiAqIC0gbnVtYmVyIChmb3Igb3RoZXIgY29udGludW91cyBzY2FsZXMpXG4gKiBAcGFyYW0gZG9tYWluXG4gKiBAcGFyYW0gc2NhbGVUeXBlXG4gKi9cblxuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gcGFyc2VDb250aW51b3VzRG9tYWluKGRvbWFpbiwgc2NhbGVUeXBlKSB7XG4gIGlmICh0aW1lU2NhbGVUeXBlc1NldC5oYXMoc2NhbGVUeXBlKSkge1xuICAgIHJldHVybiBkb21haW4uZmlsdGVyKGQgPT4gdHlwZW9mIGQgIT09ICdib29sZWFuJykubWFwKGQgPT4gdHlwZW9mIGQgPT09ICdzdHJpbmcnIHx8IHR5cGVvZiBkID09PSAnbnVtYmVyJyA/IG5ldyBEYXRlKGQpIDogZCk7XG4gIH1cblxuICByZXR1cm4gZG9tYWluLm1hcChkID0+IHR5cGVvZiBkID09PSAnc3RyaW5nJyB8fCB0eXBlb2YgZCA9PT0gJ2Jvb2xlYW4nID8gTnVtYmVyKGQpIDogZCk7XG59Il0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/parsers/domain/parseContinuousDomain.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/parsers/domain/parseDiscreteDomain.js":
/*!**************************************************************************!*\
  !*** ./node_modules/encodable/esm/parsers/domain/parseDiscreteDomain.js ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return parseDiscreteDomain; });\n/**\n * Discrete domains are converted into string[]\n * when using D3 scales\n * @param domain\n */\nfunction parseDiscreteDomain(domain) {\n  return domain.map(d => \"\" + d);\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9wYXJzZXJzL2RvbWFpbi9wYXJzZURpc2NyZXRlRG9tYWluLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9lc20vcGFyc2Vycy9kb21haW4vcGFyc2VEaXNjcmV0ZURvbWFpbi5qcz82NGRkIl0sInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogRGlzY3JldGUgZG9tYWlucyBhcmUgY29udmVydGVkIGludG8gc3RyaW5nW11cbiAqIHdoZW4gdXNpbmcgRDMgc2NhbGVzXG4gKiBAcGFyYW0gZG9tYWluXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIHBhcnNlRGlzY3JldGVEb21haW4oZG9tYWluKSB7XG4gIHJldHVybiBkb21haW4ubWFwKGQgPT4gXCJcIiArIGQpO1xufSJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/parsers/domain/parseDiscreteDomain.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/parsers/format/createFormatter.js":
/*!**********************************************************************!*\
  !*** ./node_modules/encodable/esm/parsers/format/createFormatter.js ***!
  \**********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return createFormatter; });\n/* harmony import */ var _fallbackFormatter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./fallbackFormatter */ \"./node_modules/encodable/esm/parsers/format/fallbackFormatter.js\");\n/* harmony import */ var _options_Encodable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../options/Encodable */ \"./node_modules/encodable/esm/options/Encodable.js\");\n\n\nfunction createFormatter({\n  formatType,\n  format,\n  formatInLocalTime\n}) {\n  if (formatType === 'time') {\n    const formatter = _options_Encodable__WEBPACK_IMPORTED_MODULE_1__[\"default\"].resolveTimeFormat({\n      format,\n      formatInLocalTime\n    });\n    return value => formatter(value);\n  }\n\n  if (formatType === 'number' || typeof format !== 'undefined' && format.length > 0) {\n    const formatter = _options_Encodable__WEBPACK_IMPORTED_MODULE_1__[\"default\"].resolveNumberFormat(format);\n    return value => formatter(value);\n  }\n\n  return _fallbackFormatter__WEBPACK_IMPORTED_MODULE_0__[\"default\"];\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9wYXJzZXJzL2Zvcm1hdC9jcmVhdGVGb3JtYXR0ZXIuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9wYXJzZXJzL2Zvcm1hdC9jcmVhdGVGb3JtYXR0ZXIuanM/MmZjNyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgZmFsbGJhY2tGb3JtYXR0ZXIgZnJvbSAnLi9mYWxsYmFja0Zvcm1hdHRlcic7XG5pbXBvcnQgRW5jb2RhYmxlIGZyb20gJy4uLy4uL29wdGlvbnMvRW5jb2RhYmxlJztcbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIGNyZWF0ZUZvcm1hdHRlcih7XG4gIGZvcm1hdFR5cGUsXG4gIGZvcm1hdCxcbiAgZm9ybWF0SW5Mb2NhbFRpbWVcbn0pIHtcbiAgaWYgKGZvcm1hdFR5cGUgPT09ICd0aW1lJykge1xuICAgIGNvbnN0IGZvcm1hdHRlciA9IEVuY29kYWJsZS5yZXNvbHZlVGltZUZvcm1hdCh7XG4gICAgICBmb3JtYXQsXG4gICAgICBmb3JtYXRJbkxvY2FsVGltZVxuICAgIH0pO1xuICAgIHJldHVybiB2YWx1ZSA9PiBmb3JtYXR0ZXIodmFsdWUpO1xuICB9XG5cbiAgaWYgKGZvcm1hdFR5cGUgPT09ICdudW1iZXInIHx8IHR5cGVvZiBmb3JtYXQgIT09ICd1bmRlZmluZWQnICYmIGZvcm1hdC5sZW5ndGggPiAwKSB7XG4gICAgY29uc3QgZm9ybWF0dGVyID0gRW5jb2RhYmxlLnJlc29sdmVOdW1iZXJGb3JtYXQoZm9ybWF0KTtcbiAgICByZXR1cm4gdmFsdWUgPT4gZm9ybWF0dGVyKHZhbHVlKTtcbiAgfVxuXG4gIHJldHVybiBmYWxsYmFja0Zvcm1hdHRlcjtcbn0iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/parsers/format/createFormatter.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/parsers/format/fallbackFormatter.js":
/*!************************************************************************!*\
  !*** ./node_modules/encodable/esm/parsers/format/fallbackFormatter.js ***!
  \************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return fallbackFormatter; });\nfunction fallbackFormatter(v) {\n  return \"\" + v;\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9wYXJzZXJzL2Zvcm1hdC9mYWxsYmFja0Zvcm1hdHRlci5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9lbmNvZGFibGUvZXNtL3BhcnNlcnMvZm9ybWF0L2ZhbGxiYWNrRm9ybWF0dGVyLmpzPzVhZTAiXSwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gZmFsbGJhY2tGb3JtYXR0ZXIodikge1xuICByZXR1cm4gXCJcIiArIHY7XG59Il0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/parsers/format/fallbackFormatter.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/parsers/parseDateTime.js":
/*!*************************************************************!*\
  !*** ./node_modules/encodable/esm/parsers/parseDateTime.js ***!
  \*************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return parseDateTime; });\n/* harmony import */ var _dateTimeToTimestamp__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./dateTimeToTimestamp */ \"./node_modules/encodable/esm/parsers/dateTimeToTimestamp.js\");\n\nfunction parseDateTime(dateTime) {\n  if (typeof dateTime === 'number' || typeof dateTime === 'string') {\n    return new Date(dateTime);\n  }\n\n  return new Date(Object(_dateTimeToTimestamp__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(dateTime));\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9wYXJzZXJzL3BhcnNlRGF0ZVRpbWUuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9wYXJzZXJzL3BhcnNlRGF0ZVRpbWUuanM/YTgyOCJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgZGF0ZVRpbWVUb1RpbWVzdGFtcCBmcm9tICcuL2RhdGVUaW1lVG9UaW1lc3RhbXAnO1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gcGFyc2VEYXRlVGltZShkYXRlVGltZSkge1xuICBpZiAodHlwZW9mIGRhdGVUaW1lID09PSAnbnVtYmVyJyB8fCB0eXBlb2YgZGF0ZVRpbWUgPT09ICdzdHJpbmcnKSB7XG4gICAgcmV0dXJuIG5ldyBEYXRlKGRhdGVUaW1lKTtcbiAgfVxuXG4gIHJldHVybiBuZXcgRGF0ZShkYXRlVGltZVRvVGltZXN0YW1wKGRhdGVUaW1lKSk7XG59Il0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/parsers/parseDateTime.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/parsers/parseDateTimeIn.js":
/*!***************************************************************!*\
  !*** ./node_modules/encodable/esm/parsers/parseDateTimeIn.js ***!
  \***************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return parseDateTimeIn; });\n/* harmony import */ var _typeGuards_DateTime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../typeGuards/DateTime */ \"./node_modules/encodable/esm/typeGuards/DateTime.js\");\n/* harmony import */ var _parseDateTime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parseDateTime */ \"./node_modules/encodable/esm/parsers/parseDateTime.js\");\n\n\n/**\n * Only parse elements that are DateTime to Date.\n * Leave the rest alone.\n * @param array\n */\n\nfunction parseDateTimeIn(array) {\n  return array.map(d => !(d instanceof Date) && Object(_typeGuards_DateTime__WEBPACK_IMPORTED_MODULE_0__[\"isDateTime\"])(d) ? Object(_parseDateTime__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(d) : d);\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9wYXJzZXJzL3BhcnNlRGF0ZVRpbWVJbi5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9lbmNvZGFibGUvZXNtL3BhcnNlcnMvcGFyc2VEYXRlVGltZUluLmpzPzU3OGYiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgaXNEYXRlVGltZSB9IGZyb20gJy4uL3R5cGVHdWFyZHMvRGF0ZVRpbWUnO1xuaW1wb3J0IHBhcnNlRGF0ZVRpbWUgZnJvbSAnLi9wYXJzZURhdGVUaW1lJztcbi8qKlxuICogT25seSBwYXJzZSBlbGVtZW50cyB0aGF0IGFyZSBEYXRlVGltZSB0byBEYXRlLlxuICogTGVhdmUgdGhlIHJlc3QgYWxvbmUuXG4gKiBAcGFyYW0gYXJyYXlcbiAqL1xuXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiBwYXJzZURhdGVUaW1lSW4oYXJyYXkpIHtcbiAgcmV0dXJuIGFycmF5Lm1hcChkID0+ICEoZCBpbnN0YW5jZW9mIERhdGUpICYmIGlzRGF0ZVRpbWUoZCkgPyBwYXJzZURhdGVUaW1lKGQpIDogZCk7XG59Il0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/parsers/parseDateTimeIn.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/parsers/scale/applyAlign.js":
/*!****************************************************************!*\
  !*** ./node_modules/encodable/esm/parsers/scale/applyAlign.js ***!
  \****************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return applyAlign; });\nfunction applyAlign(config, scale) {\n  if ('align' in config && typeof config.align !== 'undefined' && 'align' in scale) {\n    scale.align(config.align);\n  }\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9wYXJzZXJzL3NjYWxlL2FwcGx5QWxpZ24uanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9wYXJzZXJzL3NjYWxlL2FwcGx5QWxpZ24uanM/ZTI5NyJdLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgZGVmYXVsdCBmdW5jdGlvbiBhcHBseUFsaWduKGNvbmZpZywgc2NhbGUpIHtcbiAgaWYgKCdhbGlnbicgaW4gY29uZmlnICYmIHR5cGVvZiBjb25maWcuYWxpZ24gIT09ICd1bmRlZmluZWQnICYmICdhbGlnbicgaW4gc2NhbGUpIHtcbiAgICBzY2FsZS5hbGlnbihjb25maWcuYWxpZ24pO1xuICB9XG59Il0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/parsers/scale/applyAlign.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/parsers/scale/applyBase.js":
/*!***************************************************************!*\
  !*** ./node_modules/encodable/esm/parsers/scale/applyBase.js ***!
  \***************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return applyBase; });\nfunction applyBase(config, scale) {\n  if ('base' in config && typeof config.base !== 'undefined' && 'base' in scale) {\n    scale.base(config.base);\n  }\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9wYXJzZXJzL3NjYWxlL2FwcGx5QmFzZS5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9lbmNvZGFibGUvZXNtL3BhcnNlcnMvc2NhbGUvYXBwbHlCYXNlLmpzPzUxNzkiXSwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gYXBwbHlCYXNlKGNvbmZpZywgc2NhbGUpIHtcbiAgaWYgKCdiYXNlJyBpbiBjb25maWcgJiYgdHlwZW9mIGNvbmZpZy5iYXNlICE9PSAndW5kZWZpbmVkJyAmJiAnYmFzZScgaW4gc2NhbGUpIHtcbiAgICBzY2FsZS5iYXNlKGNvbmZpZy5iYXNlKTtcbiAgfVxufSJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/parsers/scale/applyBase.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/parsers/scale/applyClamp.js":
/*!****************************************************************!*\
  !*** ./node_modules/encodable/esm/parsers/scale/applyClamp.js ***!
  \****************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return applyClamp; });\nfunction applyClamp(config, scale) {\n  if ('clamp' in config && config.clamp === true && 'clamp' in scale) {\n    scale.clamp(config.clamp);\n  }\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9wYXJzZXJzL3NjYWxlL2FwcGx5Q2xhbXAuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9wYXJzZXJzL3NjYWxlL2FwcGx5Q2xhbXAuanM/YTRhNiJdLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgZGVmYXVsdCBmdW5jdGlvbiBhcHBseUNsYW1wKGNvbmZpZywgc2NhbGUpIHtcbiAgaWYgKCdjbGFtcCcgaW4gY29uZmlnICYmIGNvbmZpZy5jbGFtcCA9PT0gdHJ1ZSAmJiAnY2xhbXAnIGluIHNjYWxlKSB7XG4gICAgc2NhbGUuY2xhbXAoY29uZmlnLmNsYW1wKTtcbiAgfVxufSJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/parsers/scale/applyClamp.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/parsers/scale/applyDomain.js":
/*!*****************************************************************!*\
  !*** ./node_modules/encodable/esm/parsers/scale/applyDomain.js ***!
  \*****************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return applyDomain; });\n/* harmony import */ var _typeGuards_Scale__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../typeGuards/Scale */ \"./node_modules/encodable/esm/typeGuards/Scale.js\");\n/* harmony import */ var _typeGuards_ScaleConfig__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../typeGuards/ScaleConfig */ \"./node_modules/encodable/esm/typeGuards/ScaleConfig.js\");\n/* harmony import */ var _domain_parseContinuousDomain__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../domain/parseContinuousDomain */ \"./node_modules/encodable/esm/parsers/domain/parseContinuousDomain.js\");\n/* harmony import */ var _domain_parseDiscreteDomain__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../domain/parseDiscreteDomain */ \"./node_modules/encodable/esm/parsers/domain/parseDiscreteDomain.js\");\n/* harmony import */ var _utils_combineCategories__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/combineCategories */ \"./node_modules/encodable/esm/utils/combineCategories.js\");\n/* harmony import */ var _utils_combineContinuousDomains__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/combineContinuousDomains */ \"./node_modules/encodable/esm/utils/combineContinuousDomains.js\");\n/* harmony import */ var _utils_removeUndefinedAndNull__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/removeUndefinedAndNull */ \"./node_modules/encodable/esm/utils/removeUndefinedAndNull.js\");\n/* harmony import */ var _parseDateTimeIn__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../parseDateTimeIn */ \"./node_modules/encodable/esm/parsers/parseDateTimeIn.js\");\n\n\n\n\n\n\n\n\n\nfunction createOrderFunction(reverse) {\n  return reverse ? array => array.concat().reverse() : array => array;\n}\n\nfunction isCompleteDomain(domain) {\n  return domain.length !== 2 || domain[0] != null && domain[1] != null;\n}\n\nfunction applyDomain(config, scale,\n/** domain from dataset */\ndataDomain) {\n  const {\n    reverse,\n    type\n  } = config;\n  const order = createOrderFunction(reverse);\n\n  if (Object(_typeGuards_Scale__WEBPACK_IMPORTED_MODULE_0__[\"isContinuousScale\"])(scale, type) && Object(_typeGuards_ScaleConfig__WEBPACK_IMPORTED_MODULE_1__[\"isContinuousScaleConfig\"])(config) || Object(_typeGuards_Scale__WEBPACK_IMPORTED_MODULE_0__[\"isDiscretizingScale\"])(scale, type) && Object(_typeGuards_ScaleConfig__WEBPACK_IMPORTED_MODULE_1__[\"isDiscretizingScaleConfig\"])(config)) {\n    // For continuous and discretizing scales\n    if (config.domain) {\n      // If config.domain is specified\n      if (isCompleteDomain(config.domain)) {\n        // If the config.domain is completed\n        // ignores the dataDomain\n        scale.domain(order(Object(_parseDateTimeIn__WEBPACK_IMPORTED_MODULE_7__[\"default\"])(config.domain)));\n      } else if (dataDomain) {\n        // If it is incompleted, then try to combine\n        // with the dataDomain\n        scale.domain(order(Object(_utils_combineContinuousDomains__WEBPACK_IMPORTED_MODULE_5__[\"default\"])(Object(_domain_parseContinuousDomain__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(Object(_parseDateTimeIn__WEBPACK_IMPORTED_MODULE_7__[\"default\"])(config.domain), type), Object(_domain_parseContinuousDomain__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(Object(_utils_removeUndefinedAndNull__WEBPACK_IMPORTED_MODULE_6__[\"default\"])(dataDomain), type))));\n      }\n    } else if (dataDomain) {\n      // If no config.domain then just use the dataDomain if any\n      scale.domain(order(Object(_domain_parseContinuousDomain__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(Object(_utils_removeUndefinedAndNull__WEBPACK_IMPORTED_MODULE_6__[\"default\"])(dataDomain), type)));\n    }\n  } else if (Object(_typeGuards_Scale__WEBPACK_IMPORTED_MODULE_0__[\"isDiscreteScale\"])(scale, type) && Object(_typeGuards_ScaleConfig__WEBPACK_IMPORTED_MODULE_1__[\"isDiscreteScaleConfig\"])(config)) {\n    // For discrete scales\n    if (config.domain) {\n      const fixedDomain = Object(_domain_parseDiscreteDomain__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(Object(_parseDateTimeIn__WEBPACK_IMPORTED_MODULE_7__[\"default\"])(config.domain));\n      scale.domain(order(dataDomain ? Object(_utils_combineCategories__WEBPACK_IMPORTED_MODULE_4__[\"default\"])(fixedDomain, Object(_domain_parseDiscreteDomain__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(dataDomain)) : fixedDomain));\n    } else if (dataDomain) {\n      // If no config.domain then just use the dataDomain if any\n      scale.domain(order(Object(_domain_parseDiscreteDomain__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(dataDomain)));\n    }\n  }\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/parsers/scale/applyDomain.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/parsers/scale/applyExponent.js":
/*!*******************************************************************!*\
  !*** ./node_modules/encodable/esm/parsers/scale/applyExponent.js ***!
  \*******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return applyExponent; });\nfunction applyExponent(config, scale) {\n  if ('exponent' in config && typeof config.exponent !== 'undefined' && 'exponent' in scale) {\n    scale.exponent(config.exponent);\n  }\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9wYXJzZXJzL3NjYWxlL2FwcGx5RXhwb25lbnQuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9wYXJzZXJzL3NjYWxlL2FwcGx5RXhwb25lbnQuanM/MzY2ZiJdLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgZGVmYXVsdCBmdW5jdGlvbiBhcHBseUV4cG9uZW50KGNvbmZpZywgc2NhbGUpIHtcbiAgaWYgKCdleHBvbmVudCcgaW4gY29uZmlnICYmIHR5cGVvZiBjb25maWcuZXhwb25lbnQgIT09ICd1bmRlZmluZWQnICYmICdleHBvbmVudCcgaW4gc2NhbGUpIHtcbiAgICBzY2FsZS5leHBvbmVudChjb25maWcuZXhwb25lbnQpO1xuICB9XG59Il0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/parsers/scale/applyExponent.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/parsers/scale/applyInterpolate.js":
/*!**********************************************************************!*\
  !*** ./node_modules/encodable/esm/parsers/scale/applyInterpolate.js ***!
  \**********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return applyInterpolate; });\n/* harmony import */ var _createColorInterpolator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createColorInterpolator */ \"./node_modules/encodable/esm/parsers/scale/createColorInterpolator.js\");\n\nfunction applyInterpolate(config, scale) {\n  if ('interpolate' in config && typeof config.interpolate !== 'undefined' && 'interpolate' in scale) {\n    scale.interpolate(Object(_createColorInterpolator__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(config.interpolate));\n  }\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9wYXJzZXJzL3NjYWxlL2FwcGx5SW50ZXJwb2xhdGUuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9wYXJzZXJzL3NjYWxlL2FwcGx5SW50ZXJwb2xhdGUuanM/MzdhOCJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgY3JlYXRlQ29sb3JJbnRlcnBvbGF0b3IgZnJvbSAnLi9jcmVhdGVDb2xvckludGVycG9sYXRvcic7XG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiBhcHBseUludGVycG9sYXRlKGNvbmZpZywgc2NhbGUpIHtcbiAgaWYgKCdpbnRlcnBvbGF0ZScgaW4gY29uZmlnICYmIHR5cGVvZiBjb25maWcuaW50ZXJwb2xhdGUgIT09ICd1bmRlZmluZWQnICYmICdpbnRlcnBvbGF0ZScgaW4gc2NhbGUpIHtcbiAgICBzY2FsZS5pbnRlcnBvbGF0ZShjcmVhdGVDb2xvckludGVycG9sYXRvcihjb25maWcuaW50ZXJwb2xhdGUpKTtcbiAgfVxufSJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/parsers/scale/applyInterpolate.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/parsers/scale/applyNice.js":
/*!***************************************************************!*\
  !*** ./node_modules/encodable/esm/parsers/scale/applyNice.js ***!
  \***************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return applyNice; });\n/* harmony import */ var d3_time__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-time */ \"./node_modules/encodable/node_modules/d3-time/src/day.js\");\n/* harmony import */ var d3_time__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! d3-time */ \"./node_modules/encodable/node_modules/d3-time/src/hour.js\");\n/* harmony import */ var d3_time__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! d3-time */ \"./node_modules/encodable/node_modules/d3-time/src/minute.js\");\n/* harmony import */ var d3_time__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! d3-time */ \"./node_modules/encodable/node_modules/d3-time/src/month.js\");\n/* harmony import */ var d3_time__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! d3-time */ \"./node_modules/encodable/node_modules/d3-time/src/second.js\");\n/* harmony import */ var d3_time__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! d3-time */ \"./node_modules/encodable/node_modules/d3-time/src/week.js\");\n/* harmony import */ var d3_time__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! d3-time */ \"./node_modules/encodable/node_modules/d3-time/src/year.js\");\n/* harmony import */ var d3_time__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! d3-time */ \"./node_modules/encodable/node_modules/d3-time/src/utcDay.js\");\n/* harmony import */ var d3_time__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! d3-time */ \"./node_modules/encodable/node_modules/d3-time/src/utcHour.js\");\n/* harmony import */ var d3_time__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! d3-time */ \"./node_modules/encodable/node_modules/d3-time/src/utcMinute.js\");\n/* harmony import */ var d3_time__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! d3-time */ \"./node_modules/encodable/node_modules/d3-time/src/utcMonth.js\");\n/* harmony import */ var d3_time__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! d3-time */ \"./node_modules/encodable/node_modules/d3-time/src/utcWeek.js\");\n/* harmony import */ var d3_time__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! d3-time */ \"./node_modules/encodable/node_modules/d3-time/src/utcYear.js\");\n/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../types */ \"./node_modules/encodable/esm/types/scale/ScaleType.js\");\n\n\nconst localTimeIntervals = {\n  day: d3_time__WEBPACK_IMPORTED_MODULE_0__[\"default\"],\n  hour: d3_time__WEBPACK_IMPORTED_MODULE_1__[\"default\"],\n  minute: d3_time__WEBPACK_IMPORTED_MODULE_2__[\"default\"],\n  month: d3_time__WEBPACK_IMPORTED_MODULE_3__[\"default\"],\n  second: d3_time__WEBPACK_IMPORTED_MODULE_4__[\"default\"],\n  week: d3_time__WEBPACK_IMPORTED_MODULE_5__[\"sunday\"],\n  year: d3_time__WEBPACK_IMPORTED_MODULE_6__[\"default\"]\n};\nconst utcIntervals = {\n  day: d3_time__WEBPACK_IMPORTED_MODULE_7__[\"default\"],\n  hour: d3_time__WEBPACK_IMPORTED_MODULE_8__[\"default\"],\n  minute: d3_time__WEBPACK_IMPORTED_MODULE_9__[\"default\"],\n  month: d3_time__WEBPACK_IMPORTED_MODULE_10__[\"default\"],\n  second: d3_time__WEBPACK_IMPORTED_MODULE_4__[\"default\"],\n  week: d3_time__WEBPACK_IMPORTED_MODULE_11__[\"utcSunday\"],\n  year: d3_time__WEBPACK_IMPORTED_MODULE_12__[\"default\"]\n};\nfunction applyNice(config, scale) {\n  if ('nice' in config && typeof config.nice !== 'undefined' && 'nice' in scale) {\n    const {\n      nice\n    } = config;\n\n    if (typeof nice === 'boolean') {\n      if (nice) {\n        scale.nice();\n      }\n    } else if (typeof nice === 'number') {\n      scale.nice(nice);\n    } else {\n      const timeScale = scale;\n      const {\n        type\n      } = config;\n\n      if (typeof nice === 'string') {\n        timeScale.nice(type === _types__WEBPACK_IMPORTED_MODULE_13__[\"ScaleType\"].UTC ? utcIntervals[nice] : localTimeIntervals[nice]);\n      } else {\n        const {\n          interval,\n          step\n        } = nice;\n        const parsedInterval = (type === _types__WEBPACK_IMPORTED_MODULE_13__[\"ScaleType\"].UTC ? utcIntervals[interval] : localTimeIntervals[interval]).every(step);\n\n        if (parsedInterval !== null) {\n          timeScale.nice(parsedInterval);\n        }\n      }\n    }\n  }\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9wYXJzZXJzL3NjYWxlL2FwcGx5TmljZS5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9lbmNvZGFibGUvZXNtL3BhcnNlcnMvc2NhbGUvYXBwbHlOaWNlLmpzP2IxNTkiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgdGltZVNlY29uZCwgdGltZU1pbnV0ZSwgdGltZUhvdXIsIHRpbWVEYXksIHRpbWVZZWFyLCB0aW1lTW9udGgsIHRpbWVXZWVrLCB1dGNTZWNvbmQsIHV0Y01pbnV0ZSwgdXRjSG91ciwgdXRjRGF5LCB1dGNXZWVrLCB1dGNNb250aCwgdXRjWWVhciB9IGZyb20gJ2QzLXRpbWUnO1xuaW1wb3J0IHsgU2NhbGVUeXBlIH0gZnJvbSAnLi4vLi4vdHlwZXMnO1xuY29uc3QgbG9jYWxUaW1lSW50ZXJ2YWxzID0ge1xuICBkYXk6IHRpbWVEYXksXG4gIGhvdXI6IHRpbWVIb3VyLFxuICBtaW51dGU6IHRpbWVNaW51dGUsXG4gIG1vbnRoOiB0aW1lTW9udGgsXG4gIHNlY29uZDogdGltZVNlY29uZCxcbiAgd2VlazogdGltZVdlZWssXG4gIHllYXI6IHRpbWVZZWFyXG59O1xuY29uc3QgdXRjSW50ZXJ2YWxzID0ge1xuICBkYXk6IHV0Y0RheSxcbiAgaG91cjogdXRjSG91cixcbiAgbWludXRlOiB1dGNNaW51dGUsXG4gIG1vbnRoOiB1dGNNb250aCxcbiAgc2Vjb25kOiB1dGNTZWNvbmQsXG4gIHdlZWs6IHV0Y1dlZWssXG4gIHllYXI6IHV0Y1llYXJcbn07XG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiBhcHBseU5pY2UoY29uZmlnLCBzY2FsZSkge1xuICBpZiAoJ25pY2UnIGluIGNvbmZpZyAmJiB0eXBlb2YgY29uZmlnLm5pY2UgIT09ICd1bmRlZmluZWQnICYmICduaWNlJyBpbiBzY2FsZSkge1xuICAgIGNvbnN0IHtcbiAgICAgIG5pY2VcbiAgICB9ID0gY29uZmlnO1xuXG4gICAgaWYgKHR5cGVvZiBuaWNlID09PSAnYm9vbGVhbicpIHtcbiAgICAgIGlmIChuaWNlKSB7XG4gICAgICAgIHNjYWxlLm5pY2UoKTtcbiAgICAgIH1cbiAgICB9IGVsc2UgaWYgKHR5cGVvZiBuaWNlID09PSAnbnVtYmVyJykge1xuICAgICAgc2NhbGUubmljZShuaWNlKTtcbiAgICB9IGVsc2Uge1xuICAgICAgY29uc3QgdGltZVNjYWxlID0gc2NhbGU7XG4gICAgICBjb25zdCB7XG4gICAgICAgIHR5cGVcbiAgICAgIH0gPSBjb25maWc7XG5cbiAgICAgIGlmICh0eXBlb2YgbmljZSA9PT0gJ3N0cmluZycpIHtcbiAgICAgICAgdGltZVNjYWxlLm5pY2UodHlwZSA9PT0gU2NhbGVUeXBlLlVUQyA/IHV0Y0ludGVydmFsc1tuaWNlXSA6IGxvY2FsVGltZUludGVydmFsc1tuaWNlXSk7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICBjb25zdCB7XG4gICAgICAgICAgaW50ZXJ2YWwsXG4gICAgICAgICAgc3RlcFxuICAgICAgICB9ID0gbmljZTtcbiAgICAgICAgY29uc3QgcGFyc2VkSW50ZXJ2YWwgPSAodHlwZSA9PT0gU2NhbGVUeXBlLlVUQyA/IHV0Y0ludGVydmFsc1tpbnRlcnZhbF0gOiBsb2NhbFRpbWVJbnRlcnZhbHNbaW50ZXJ2YWxdKS5ldmVyeShzdGVwKTtcblxuICAgICAgICBpZiAocGFyc2VkSW50ZXJ2YWwgIT09IG51bGwpIHtcbiAgICAgICAgICB0aW1lU2NhbGUubmljZShwYXJzZWRJbnRlcnZhbCk7XG4gICAgICAgIH1cbiAgICAgIH1cbiAgICB9XG4gIH1cbn0iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/parsers/scale/applyNice.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/parsers/scale/applyPadding.js":
/*!******************************************************************!*\
  !*** ./node_modules/encodable/esm/parsers/scale/applyPadding.js ***!
  \******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return applyPadding; });\nfunction applyPadding(config, scale) {\n  if ('padding' in config && typeof config.padding !== 'undefined' && 'padding' in scale) {\n    scale.padding(config.padding);\n  }\n\n  if ('paddingInner' in config && typeof config.paddingInner !== 'undefined' && 'paddingInner' in scale) {\n    scale.paddingInner(config.paddingInner);\n  }\n\n  if ('paddingOuter' in config && typeof config.paddingOuter !== 'undefined' && 'paddingOuter' in scale) {\n    scale.paddingOuter(config.paddingOuter);\n  }\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9wYXJzZXJzL3NjYWxlL2FwcGx5UGFkZGluZy5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9lbmNvZGFibGUvZXNtL3BhcnNlcnMvc2NhbGUvYXBwbHlQYWRkaW5nLmpzP2Y1ZWQiXSwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gYXBwbHlQYWRkaW5nKGNvbmZpZywgc2NhbGUpIHtcbiAgaWYgKCdwYWRkaW5nJyBpbiBjb25maWcgJiYgdHlwZW9mIGNvbmZpZy5wYWRkaW5nICE9PSAndW5kZWZpbmVkJyAmJiAncGFkZGluZycgaW4gc2NhbGUpIHtcbiAgICBzY2FsZS5wYWRkaW5nKGNvbmZpZy5wYWRkaW5nKTtcbiAgfVxuXG4gIGlmICgncGFkZGluZ0lubmVyJyBpbiBjb25maWcgJiYgdHlwZW9mIGNvbmZpZy5wYWRkaW5nSW5uZXIgIT09ICd1bmRlZmluZWQnICYmICdwYWRkaW5nSW5uZXInIGluIHNjYWxlKSB7XG4gICAgc2NhbGUucGFkZGluZ0lubmVyKGNvbmZpZy5wYWRkaW5nSW5uZXIpO1xuICB9XG5cbiAgaWYgKCdwYWRkaW5nT3V0ZXInIGluIGNvbmZpZyAmJiB0eXBlb2YgY29uZmlnLnBhZGRpbmdPdXRlciAhPT0gJ3VuZGVmaW5lZCcgJiYgJ3BhZGRpbmdPdXRlcicgaW4gc2NhbGUpIHtcbiAgICBzY2FsZS5wYWRkaW5nT3V0ZXIoY29uZmlnLnBhZGRpbmdPdXRlcik7XG4gIH1cbn0iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/parsers/scale/applyPadding.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/parsers/scale/applyRange.js":
/*!****************************************************************!*\
  !*** ./node_modules/encodable/esm/parsers/scale/applyRange.js ***!
  \****************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return applyRange; });\n/* harmony import */ var _encodable_color__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @encodable/color */ \"./node_modules/@encodable/color/esm/scheme/wrappers/wrapColorScheme.js\");\n/* harmony import */ var _options_Encodable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../options/Encodable */ \"./node_modules/encodable/esm/options/Encodable.js\");\n/* harmony import */ var _typeGuards_ScaleConfig__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../typeGuards/ScaleConfig */ \"./node_modules/encodable/esm/typeGuards/ScaleConfig.js\");\n/* harmony import */ var _typeGuards_SchemeParams__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../typeGuards/SchemeParams */ \"./node_modules/encodable/esm/typeGuards/SchemeParams.js\");\n\n\n\n\nfunction applyRange(config, scale) {\n  const {\n    range,\n    domain\n  } = config;\n\n  if (typeof range === 'undefined') {\n    if ('scheme' in config && typeof config.scheme !== 'undefined') {\n      const {\n        scheme\n      } = config;\n      let name;\n      let count;\n\n      if (Object(_typeGuards_ScaleConfig__WEBPACK_IMPORTED_MODULE_2__[\"isContinuousScaleConfig\"])(config) && domain) {\n        count = domain.length;\n      }\n\n      let extent;\n\n      if (Object(_typeGuards_SchemeParams__WEBPACK_IMPORTED_MODULE_3__[\"isSchemeParams\"])(scheme)) {\n        name = scheme.name;\n\n        if (scheme.count) {\n          count = scheme.count;\n        }\n\n        extent = scheme.extent;\n      } else {\n        name = scheme;\n      }\n\n      const schemeObject = _options_Encodable__WEBPACK_IMPORTED_MODULE_1__[\"default\"].resolveColorScheme({\n        name,\n        type: 'sequential'\n      });\n\n      if (typeof schemeObject !== 'undefined' && schemeObject.type === 'sequential') {\n        const wrappedScheme = Object(_encodable_color__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(schemeObject);\n        scale.range(wrappedScheme.getColors(count, extent));\n      }\n    }\n  } else {\n    // TODO: add type guard should fix this problem\n    // @ts-ignore\n    scale.range(range);\n  }\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/parsers/scale/applyRange.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/parsers/scale/applyRound.js":
/*!****************************************************************!*\
  !*** ./node_modules/encodable/esm/parsers/scale/applyRound.js ***!
  \****************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return applyRound; });\n/* harmony import */ var d3_interpolate__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-interpolate */ \"./node_modules/encodable/node_modules/d3-interpolate/src/round.js\");\n\nfunction applyRound(config, scale) {\n  if ('round' in config && config.round === true) {\n    const roundableScale = scale;\n\n    if ('round' in roundableScale) {\n      roundableScale.round(config.round);\n    } else {\n      roundableScale.interpolate(d3_interpolate__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n    }\n  }\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9wYXJzZXJzL3NjYWxlL2FwcGx5Um91bmQuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9wYXJzZXJzL3NjYWxlL2FwcGx5Um91bmQuanM/ZmNlZCJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBpbnRlcnBvbGF0ZVJvdW5kIH0gZnJvbSAnZDMtaW50ZXJwb2xhdGUnO1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gYXBwbHlSb3VuZChjb25maWcsIHNjYWxlKSB7XG4gIGlmICgncm91bmQnIGluIGNvbmZpZyAmJiBjb25maWcucm91bmQgPT09IHRydWUpIHtcbiAgICBjb25zdCByb3VuZGFibGVTY2FsZSA9IHNjYWxlO1xuXG4gICAgaWYgKCdyb3VuZCcgaW4gcm91bmRhYmxlU2NhbGUpIHtcbiAgICAgIHJvdW5kYWJsZVNjYWxlLnJvdW5kKGNvbmZpZy5yb3VuZCk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHJvdW5kYWJsZVNjYWxlLmludGVycG9sYXRlKGludGVycG9sYXRlUm91bmQpO1xuICAgIH1cbiAgfVxufSJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/parsers/scale/applyRound.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/parsers/scale/applyZero.js":
/*!***************************************************************!*\
  !*** ./node_modules/encodable/esm/parsers/scale/applyZero.js ***!
  \***************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return applyZero; });\n/* harmony import */ var _typeGuards_Scale__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../typeGuards/Scale */ \"./node_modules/encodable/esm/typeGuards/Scale.js\");\n\nfunction applyZero(config, scale) {\n  if ('zero' in config && config.zero === true && Object(_typeGuards_Scale__WEBPACK_IMPORTED_MODULE_0__[\"isContinuousScale\"])(scale, config.type)) {\n    const domain = scale.domain();\n    const [a, b] = domain;\n    const isDescending = b < a;\n    const [min, max] = isDescending ? [b, a] : [a, b];\n    const domainWithZero = [Math.min(0, min), Math.max(0, max)];\n    scale.domain(isDescending ? domainWithZero.reverse() : domainWithZero);\n  }\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9wYXJzZXJzL3NjYWxlL2FwcGx5WmVyby5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9lbmNvZGFibGUvZXNtL3BhcnNlcnMvc2NhbGUvYXBwbHlaZXJvLmpzP2ZmNTEiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgaXNDb250aW51b3VzU2NhbGUgfSBmcm9tICcuLi8uLi90eXBlR3VhcmRzL1NjYWxlJztcbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIGFwcGx5WmVybyhjb25maWcsIHNjYWxlKSB7XG4gIGlmICgnemVybycgaW4gY29uZmlnICYmIGNvbmZpZy56ZXJvID09PSB0cnVlICYmIGlzQ29udGludW91c1NjYWxlKHNjYWxlLCBjb25maWcudHlwZSkpIHtcbiAgICBjb25zdCBkb21haW4gPSBzY2FsZS5kb21haW4oKTtcbiAgICBjb25zdCBbYSwgYl0gPSBkb21haW47XG4gICAgY29uc3QgaXNEZXNjZW5kaW5nID0gYiA8IGE7XG4gICAgY29uc3QgW21pbiwgbWF4XSA9IGlzRGVzY2VuZGluZyA/IFtiLCBhXSA6IFthLCBiXTtcbiAgICBjb25zdCBkb21haW5XaXRoWmVybyA9IFtNYXRoLm1pbigwLCBtaW4pLCBNYXRoLm1heCgwLCBtYXgpXTtcbiAgICBzY2FsZS5kb21haW4oaXNEZXNjZW5kaW5nID8gZG9tYWluV2l0aFplcm8ucmV2ZXJzZSgpIDogZG9tYWluV2l0aFplcm8pO1xuICB9XG59Il0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/parsers/scale/applyZero.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/parsers/scale/createColorInterpolator.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/encodable/esm/parsers/scale/createColorInterpolator.js ***!
  \*****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return createColorInterpolator; });\n/* harmony import */ var d3_interpolate__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-interpolate */ \"./node_modules/encodable/node_modules/d3-interpolate/src/lab.js\");\n/* harmony import */ var d3_interpolate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! d3-interpolate */ \"./node_modules/encodable/node_modules/d3-interpolate/src/hcl.js\");\n/* harmony import */ var d3_interpolate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! d3-interpolate */ \"./node_modules/encodable/node_modules/d3-interpolate/src/hsl.js\");\n/* harmony import */ var d3_interpolate__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! d3-interpolate */ \"./node_modules/encodable/node_modules/d3-interpolate/src/cubehelix.js\");\n/* harmony import */ var d3_interpolate__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! d3-interpolate */ \"./node_modules/encodable/node_modules/d3-interpolate/src/rgb.js\");\n\nconst interpolatorMap = {\n  lab: d3_interpolate__WEBPACK_IMPORTED_MODULE_0__[\"default\"],\n  hcl: d3_interpolate__WEBPACK_IMPORTED_MODULE_1__[\"default\"],\n  'hcl-long': d3_interpolate__WEBPACK_IMPORTED_MODULE_1__[\"hclLong\"],\n  hsl: d3_interpolate__WEBPACK_IMPORTED_MODULE_2__[\"default\"],\n  'hsl-long': d3_interpolate__WEBPACK_IMPORTED_MODULE_2__[\"hslLong\"],\n  cubehelix: d3_interpolate__WEBPACK_IMPORTED_MODULE_3__[\"default\"],\n  'cubehelix-long': d3_interpolate__WEBPACK_IMPORTED_MODULE_3__[\"cubehelixLong\"],\n  rgb: d3_interpolate__WEBPACK_IMPORTED_MODULE_4__[\"default\"]\n};\nfunction createColorInterpolator(interpolate) {\n  switch (interpolate) {\n    case 'lab':\n    case 'hcl':\n    case 'hcl-long':\n    case 'hsl':\n    case 'hsl-long':\n    case 'cubehelix':\n    case 'cubehelix-long':\n    case 'rgb':\n      return interpolatorMap[interpolate];\n\n    default:\n  }\n\n  const {\n    type,\n    gamma\n  } = interpolate;\n  const interpolator = interpolatorMap[type];\n  return typeof gamma === 'undefined' ? interpolator : interpolator.gamma(gamma);\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9wYXJzZXJzL3NjYWxlL2NyZWF0ZUNvbG9ySW50ZXJwb2xhdG9yLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9lc20vcGFyc2Vycy9zY2FsZS9jcmVhdGVDb2xvckludGVycG9sYXRvci5qcz8zNWJmIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGludGVycG9sYXRlUmdiLCBpbnRlcnBvbGF0ZUxhYiwgaW50ZXJwb2xhdGVIY2wsIGludGVycG9sYXRlSGNsTG9uZywgaW50ZXJwb2xhdGVIc2wsIGludGVycG9sYXRlSHNsTG9uZywgaW50ZXJwb2xhdGVDdWJlaGVsaXgsIGludGVycG9sYXRlQ3ViZWhlbGl4TG9uZyB9IGZyb20gJ2QzLWludGVycG9sYXRlJztcbmNvbnN0IGludGVycG9sYXRvck1hcCA9IHtcbiAgbGFiOiBpbnRlcnBvbGF0ZUxhYixcbiAgaGNsOiBpbnRlcnBvbGF0ZUhjbCxcbiAgJ2hjbC1sb25nJzogaW50ZXJwb2xhdGVIY2xMb25nLFxuICBoc2w6IGludGVycG9sYXRlSHNsLFxuICAnaHNsLWxvbmcnOiBpbnRlcnBvbGF0ZUhzbExvbmcsXG4gIGN1YmVoZWxpeDogaW50ZXJwb2xhdGVDdWJlaGVsaXgsXG4gICdjdWJlaGVsaXgtbG9uZyc6IGludGVycG9sYXRlQ3ViZWhlbGl4TG9uZyxcbiAgcmdiOiBpbnRlcnBvbGF0ZVJnYlxufTtcbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIGNyZWF0ZUNvbG9ySW50ZXJwb2xhdG9yKGludGVycG9sYXRlKSB7XG4gIHN3aXRjaCAoaW50ZXJwb2xhdGUpIHtcbiAgICBjYXNlICdsYWInOlxuICAgIGNhc2UgJ2hjbCc6XG4gICAgY2FzZSAnaGNsLWxvbmcnOlxuICAgIGNhc2UgJ2hzbCc6XG4gICAgY2FzZSAnaHNsLWxvbmcnOlxuICAgIGNhc2UgJ2N1YmVoZWxpeCc6XG4gICAgY2FzZSAnY3ViZWhlbGl4LWxvbmcnOlxuICAgIGNhc2UgJ3JnYic6XG4gICAgICByZXR1cm4gaW50ZXJwb2xhdG9yTWFwW2ludGVycG9sYXRlXTtcblxuICAgIGRlZmF1bHQ6XG4gIH1cblxuICBjb25zdCB7XG4gICAgdHlwZSxcbiAgICBnYW1tYVxuICB9ID0gaW50ZXJwb2xhdGU7XG4gIGNvbnN0IGludGVycG9sYXRvciA9IGludGVycG9sYXRvck1hcFt0eXBlXTtcbiAgcmV0dXJuIHR5cGVvZiBnYW1tYSA9PT0gJ3VuZGVmaW5lZCcgPyBpbnRlcnBvbGF0b3IgOiBpbnRlcnBvbGF0b3IuZ2FtbWEoZ2FtbWEpO1xufSJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/parsers/scale/createColorInterpolator.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/parsers/scale/createScale.js":
/*!*****************************************************************!*\
  !*** ./node_modules/encodable/esm/parsers/scale/createScale.js ***!
  \*****************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../types */ \"./node_modules/encodable/esm/types/scale/ScaleType.js\");\n/* harmony import */ var _createScaleFromScaleType__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./createScaleFromScaleType */ \"./node_modules/encodable/esm/parsers/scale/createScaleFromScaleType.js\");\n/* harmony import */ var _updateScale__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./updateScale */ \"./node_modules/encodable/esm/parsers/scale/updateScale.js\");\n/* harmony import */ var _options_Encodable__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../options/Encodable */ \"./node_modules/encodable/esm/options/Encodable.js\");\n/* harmony import */ var _typeGuards_SchemeParams__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../typeGuards/SchemeParams */ \"./node_modules/encodable/esm/typeGuards/SchemeParams.js\");\n/* harmony import */ var _applyDomain__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./applyDomain */ \"./node_modules/encodable/esm/parsers/scale/applyDomain.js\");\n\n\n\n\n\n\n\nfunction createScale(config) {\n  const {\n    range\n  } = config; // Handle categorical color scales\n  // An ordinal scale without specified range\n  // is assumed to be a color scale.\n\n  if (config.type === _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].ORDINAL && typeof range === 'undefined') {\n    const scheme = 'scheme' in config ? config.scheme : undefined;\n    const resolve = _options_Encodable__WEBPACK_IMPORTED_MODULE_3__[\"default\"].getCategoricalColorScaleResolver();\n    let colorScale;\n\n    if (typeof scheme === 'undefined') {\n      colorScale = resolve({});\n    } else if (Object(_typeGuards_SchemeParams__WEBPACK_IMPORTED_MODULE_4__[\"isSchemeParams\"])(scheme)) {\n      colorScale = resolve(scheme);\n    } else {\n      colorScale = resolve({\n        name: scheme\n      });\n    }\n\n    const castedColorScale = colorScale;\n    Object(_applyDomain__WEBPACK_IMPORTED_MODULE_5__[\"default\"])(config, castedColorScale);\n    return castedColorScale;\n  }\n\n  const scale = Object(_createScaleFromScaleType__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(config.type);\n  return Object(_updateScale__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(scale, config);\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (createScale);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/parsers/scale/createScale.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/parsers/scale/createScaleFromScaleType.js":
/*!******************************************************************************!*\
  !*** ./node_modules/encodable/esm/parsers/scale/createScaleFromScaleType.js ***!
  \******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return createScaleFromScaleType; });\n/* harmony import */ var d3_scale__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-scale */ \"./node_modules/encodable/node_modules/d3-scale/src/linear.js\");\n/* harmony import */ var d3_scale__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! d3-scale */ \"./node_modules/encodable/node_modules/d3-scale/src/log.js\");\n/* harmony import */ var d3_scale__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! d3-scale */ \"./node_modules/encodable/node_modules/d3-scale/src/pow.js\");\n/* harmony import */ var d3_scale__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! d3-scale */ \"./node_modules/encodable/node_modules/d3-scale/src/time.js\");\n/* harmony import */ var d3_scale__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! d3-scale */ \"./node_modules/encodable/node_modules/d3-scale/src/utcTime.js\");\n/* harmony import */ var d3_scale__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! d3-scale */ \"./node_modules/encodable/node_modules/d3-scale/src/quantile.js\");\n/* harmony import */ var d3_scale__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! d3-scale */ \"./node_modules/encodable/node_modules/d3-scale/src/quantize.js\");\n/* harmony import */ var d3_scale__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! d3-scale */ \"./node_modules/encodable/node_modules/d3-scale/src/threshold.js\");\n/* harmony import */ var d3_scale__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! d3-scale */ \"./node_modules/encodable/node_modules/d3-scale/src/ordinal.js\");\n/* harmony import */ var d3_scale__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! d3-scale */ \"./node_modules/encodable/node_modules/d3-scale/src/band.js\");\n/* harmony import */ var d3_scale__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! d3-scale */ \"./node_modules/encodable/node_modules/d3-scale/src/symlog.js\");\n/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../types */ \"./node_modules/encodable/esm/types/scale/ScaleType.js\");\n\n\nfunction createScaleFromScaleType(type) {\n  switch (type) {\n    case _types__WEBPACK_IMPORTED_MODULE_11__[\"ScaleType\"].LINEAR:\n      return Object(d3_scale__WEBPACK_IMPORTED_MODULE_0__[\"default\"])();\n\n    case _types__WEBPACK_IMPORTED_MODULE_11__[\"ScaleType\"].LOG:\n      return Object(d3_scale__WEBPACK_IMPORTED_MODULE_1__[\"default\"])();\n\n    case _types__WEBPACK_IMPORTED_MODULE_11__[\"ScaleType\"].POW:\n      return Object(d3_scale__WEBPACK_IMPORTED_MODULE_2__[\"default\"])();\n\n    case _types__WEBPACK_IMPORTED_MODULE_11__[\"ScaleType\"].SQRT:\n      return Object(d3_scale__WEBPACK_IMPORTED_MODULE_2__[\"sqrt\"])();\n\n    case _types__WEBPACK_IMPORTED_MODULE_11__[\"ScaleType\"].TIME:\n      return Object(d3_scale__WEBPACK_IMPORTED_MODULE_3__[\"default\"])();\n\n    case _types__WEBPACK_IMPORTED_MODULE_11__[\"ScaleType\"].UTC:\n      return Object(d3_scale__WEBPACK_IMPORTED_MODULE_4__[\"default\"])();\n\n    case _types__WEBPACK_IMPORTED_MODULE_11__[\"ScaleType\"].QUANTILE:\n      return Object(d3_scale__WEBPACK_IMPORTED_MODULE_5__[\"default\"])();\n\n    case _types__WEBPACK_IMPORTED_MODULE_11__[\"ScaleType\"].QUANTIZE:\n      return Object(d3_scale__WEBPACK_IMPORTED_MODULE_6__[\"default\"])();\n\n    case _types__WEBPACK_IMPORTED_MODULE_11__[\"ScaleType\"].THRESHOLD:\n      return Object(d3_scale__WEBPACK_IMPORTED_MODULE_7__[\"default\"])();\n\n    case _types__WEBPACK_IMPORTED_MODULE_11__[\"ScaleType\"].ORDINAL:\n      return Object(d3_scale__WEBPACK_IMPORTED_MODULE_8__[\"default\"])();\n\n    case _types__WEBPACK_IMPORTED_MODULE_11__[\"ScaleType\"].POINT:\n      return Object(d3_scale__WEBPACK_IMPORTED_MODULE_9__[\"point\"])();\n\n    case _types__WEBPACK_IMPORTED_MODULE_11__[\"ScaleType\"].BAND:\n      return Object(d3_scale__WEBPACK_IMPORTED_MODULE_9__[\"default\"])();\n\n    case _types__WEBPACK_IMPORTED_MODULE_11__[\"ScaleType\"].SYMLOG:\n      return Object(d3_scale__WEBPACK_IMPORTED_MODULE_10__[\"default\"])();\n\n    case _types__WEBPACK_IMPORTED_MODULE_11__[\"ScaleType\"].BIN_ORDINAL:\n      // TODO: Pending scale.bins implementation\n      throw new Error(\"\\\"type = \" + type + \"\\\" is not supported yet.\");\n\n    default:\n      return Object(d3_scale__WEBPACK_IMPORTED_MODULE_0__[\"default\"])();\n  }\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/parsers/scale/createScaleFromScaleType.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/parsers/scale/isPropertySupportedByScaleType.js":
/*!************************************************************************************!*\
  !*** ./node_modules/encodable/esm/parsers/scale/isPropertySupportedByScaleType.js ***!
  \************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return isPropertySupportedByScaleType; });\n/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../types */ \"./node_modules/encodable/esm/types/scale/ScaleType.js\");\n/* harmony import */ var _scaleCategories__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./scaleCategories */ \"./node_modules/encodable/esm/parsers/scale/scaleCategories.js\");\n\n\nconst pointOrBand = [_types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].POINT, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].BAND];\nconst pointOrBandSet = new Set(pointOrBand);\nconst exceptPointOrBand = _scaleCategories__WEBPACK_IMPORTED_MODULE_1__[\"allScaleTypes\"].filter(type => !pointOrBandSet.has(type));\nconst exceptPointOrBandSet = new Set(exceptPointOrBand);\nconst continuousOrPointOrBandSet = new Set(_scaleCategories__WEBPACK_IMPORTED_MODULE_1__[\"continuousScaleTypes\"].concat(pointOrBand));\nconst zeroSet = new Set(_scaleCategories__WEBPACK_IMPORTED_MODULE_1__[\"continuousDomainScaleTypes\"]); // log scale cannot have zero value\n\nzeroSet.delete(_types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].LOG); // zero is not meaningful for time\n\nzeroSet.delete(_types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].TIME);\nzeroSet.delete(_types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].UTC); // threshold requires custom domain so zero does not matter\n\nzeroSet.delete(_types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].THRESHOLD); // quantile depends on distribution so zero does not matter\n\nzeroSet.delete(_types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].QUANTILE);\nconst supportedScaleTypes = {\n  align: pointOrBandSet,\n  base: new Set([_types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].LOG]),\n  clamp: _scaleCategories__WEBPACK_IMPORTED_MODULE_1__[\"continuousScaleTypesSet\"],\n  constant: new Set([_types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].SYMLOG]),\n  domain: _scaleCategories__WEBPACK_IMPORTED_MODULE_1__[\"allScaleTypesSet\"],\n  exponent: new Set([_types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].POW]),\n  interpolate: exceptPointOrBandSet,\n  nice: new Set(_scaleCategories__WEBPACK_IMPORTED_MODULE_1__[\"continuousScaleTypes\"].concat([_types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].QUANTIZE, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].THRESHOLD])),\n  padding: continuousOrPointOrBandSet,\n  paddingInner: new Set([_types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].BAND]),\n  paddingOuter: pointOrBandSet,\n  range: _scaleCategories__WEBPACK_IMPORTED_MODULE_1__[\"allScaleTypesSet\"],\n  reverse: _scaleCategories__WEBPACK_IMPORTED_MODULE_1__[\"allScaleTypesSet\"],\n  round: continuousOrPointOrBandSet,\n  scheme: exceptPointOrBandSet,\n  type: _scaleCategories__WEBPACK_IMPORTED_MODULE_1__[\"allScaleTypesSet\"],\n  unknown: new Set([_types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].ORDINAL]),\n  zero: zeroSet\n};\nfunction isPropertySupportedByScaleType(property, scaleType) {\n  return supportedScaleTypes[property].has(scaleType);\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/parsers/scale/isPropertySupportedByScaleType.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/parsers/scale/scaleCategories.js":
/*!*********************************************************************!*\
  !*** ./node_modules/encodable/esm/parsers/scale/scaleCategories.js ***!
  \*********************************************************************/
/*! exports provided: continuousToContinuousScaleTypes, continuousToContinuousScaleTypesSet, continuousToDiscreteScaleTypes, continuousToDiscreteScaleTypesSet, continuousDomainScaleTypes, continuousDomainScaleTypesSet, discreteDomainScaleTypes, discreteDomainScaleTypesSet, continuousScaleTypes, continuousScaleTypesSet, discreteScaleTypes, discreteScaleTypesSet, discretizingScaleTypes, discretizingScaleTypesSet, timeScaleTypes, timeScaleTypesSet, allScaleTypes, allScaleTypesSet */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"continuousToContinuousScaleTypes\", function() { return continuousToContinuousScaleTypes; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"continuousToContinuousScaleTypesSet\", function() { return continuousToContinuousScaleTypesSet; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"continuousToDiscreteScaleTypes\", function() { return continuousToDiscreteScaleTypes; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"continuousToDiscreteScaleTypesSet\", function() { return continuousToDiscreteScaleTypesSet; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"continuousDomainScaleTypes\", function() { return continuousDomainScaleTypes; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"continuousDomainScaleTypesSet\", function() { return continuousDomainScaleTypesSet; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"discreteDomainScaleTypes\", function() { return discreteDomainScaleTypes; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"discreteDomainScaleTypesSet\", function() { return discreteDomainScaleTypesSet; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"continuousScaleTypes\", function() { return continuousScaleTypes; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"continuousScaleTypesSet\", function() { return continuousScaleTypesSet; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"discreteScaleTypes\", function() { return discreteScaleTypes; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"discreteScaleTypesSet\", function() { return discreteScaleTypesSet; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"discretizingScaleTypes\", function() { return discretizingScaleTypes; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"discretizingScaleTypesSet\", function() { return discretizingScaleTypesSet; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"timeScaleTypes\", function() { return timeScaleTypes; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"timeScaleTypesSet\", function() { return timeScaleTypesSet; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"allScaleTypes\", function() { return allScaleTypes; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"allScaleTypesSet\", function() { return allScaleTypesSet; });\n/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../types */ \"./node_modules/encodable/esm/types/scale/ScaleType.js\");\n // Grouped by domain and range\n\nconst continuousToContinuousScaleTypes = [_types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].LINEAR, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].POW, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].SQRT, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].SYMLOG, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].LOG, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].TIME, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].UTC];\nconst continuousToContinuousScaleTypesSet = new Set(continuousToContinuousScaleTypes);\nconst continuousToDiscreteScaleTypes = [_types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].QUANTILE, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].QUANTIZE, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].THRESHOLD];\nconst continuousToDiscreteScaleTypesSet = new Set(continuousToDiscreteScaleTypes); // Grouped by Domain\n\nconst continuousDomainScaleTypes = continuousToContinuousScaleTypes.concat(continuousToDiscreteScaleTypes);\nconst continuousDomainScaleTypesSet = new Set(continuousDomainScaleTypes);\nconst discreteDomainScaleTypes = [_types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].ORDINAL, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].BIN_ORDINAL, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].POINT, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].BAND];\nconst discreteDomainScaleTypesSet = new Set(discreteDomainScaleTypes); // Three broad categories\n\nconst continuousScaleTypes = continuousToContinuousScaleTypes;\nconst continuousScaleTypesSet = continuousToContinuousScaleTypesSet;\nconst discreteScaleTypes = [_types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].BAND, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].POINT, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].ORDINAL];\nconst discreteScaleTypesSet = new Set(discreteScaleTypes);\nconst discretizingScaleTypes = [_types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].BIN_ORDINAL, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].QUANTILE, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].QUANTIZE, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].THRESHOLD];\nconst discretizingScaleTypesSet = new Set(discretizingScaleTypes); // Others\n\nconst timeScaleTypes = [_types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].TIME, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].UTC];\nconst timeScaleTypesSet = new Set(timeScaleTypes);\nconst allScaleTypes = [_types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].LINEAR, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].LOG, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].POW, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].SQRT, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].SYMLOG, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].TIME, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].UTC, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].QUANTILE, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].QUANTIZE, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].THRESHOLD, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].BIN_ORDINAL, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].ORDINAL, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].POINT, _types__WEBPACK_IMPORTED_MODULE_0__[\"ScaleType\"].BAND];\nconst allScaleTypesSet = new Set(allScaleTypes);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/parsers/scale/scaleCategories.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/parsers/scale/updateScale.js":
/*!*****************************************************************!*\
  !*** ./node_modules/encodable/esm/parsers/scale/updateScale.js ***!
  \*****************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return updateScale; });\n/* harmony import */ var _applyAlign__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./applyAlign */ \"./node_modules/encodable/esm/parsers/scale/applyAlign.js\");\n/* harmony import */ var _applyBase__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./applyBase */ \"./node_modules/encodable/esm/parsers/scale/applyBase.js\");\n/* harmony import */ var _applyClamp__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./applyClamp */ \"./node_modules/encodable/esm/parsers/scale/applyClamp.js\");\n/* harmony import */ var _applyExponent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./applyExponent */ \"./node_modules/encodable/esm/parsers/scale/applyExponent.js\");\n/* harmony import */ var _applyNice__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./applyNice */ \"./node_modules/encodable/esm/parsers/scale/applyNice.js\");\n/* harmony import */ var _applyZero__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./applyZero */ \"./node_modules/encodable/esm/parsers/scale/applyZero.js\");\n/* harmony import */ var _applyInterpolate__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./applyInterpolate */ \"./node_modules/encodable/esm/parsers/scale/applyInterpolate.js\");\n/* harmony import */ var _applyRound__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./applyRound */ \"./node_modules/encodable/esm/parsers/scale/applyRound.js\");\n/* harmony import */ var _applyDomain__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./applyDomain */ \"./node_modules/encodable/esm/parsers/scale/applyDomain.js\");\n/* harmony import */ var _applyRange__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./applyRange */ \"./node_modules/encodable/esm/parsers/scale/applyRange.js\");\n/* harmony import */ var _applyPadding__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./applyPadding */ \"./node_modules/encodable/esm/parsers/scale/applyPadding.js\");\n\n\n\n\n\n\n\n\n\n\n\nfunction updateScale(scale, config) {\n  // domain and range apply to all scales\n  Object(_applyDomain__WEBPACK_IMPORTED_MODULE_8__[\"default\"])(config, scale);\n  Object(_applyRange__WEBPACK_IMPORTED_MODULE_9__[\"default\"])(config, scale); // Sort other properties alphabetically.\n\n  Object(_applyAlign__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(config, scale);\n  Object(_applyBase__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(config, scale);\n  Object(_applyClamp__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(config, scale);\n  Object(_applyExponent__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(config, scale);\n  Object(_applyInterpolate__WEBPACK_IMPORTED_MODULE_6__[\"default\"])(config, scale); // Nice depends on domain.\n\n  Object(_applyNice__WEBPACK_IMPORTED_MODULE_4__[\"default\"])(config, scale);\n  Object(_applyPadding__WEBPACK_IMPORTED_MODULE_10__[\"default\"])(config, scale);\n  Object(_applyRound__WEBPACK_IMPORTED_MODULE_7__[\"default\"])(config, scale); // Zero depends on domain and nice.\n\n  Object(_applyZero__WEBPACK_IMPORTED_MODULE_5__[\"default\"])(config, scale);\n  return scale;\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS9wYXJzZXJzL3NjYWxlL3VwZGF0ZVNjYWxlLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9lc20vcGFyc2Vycy9zY2FsZS91cGRhdGVTY2FsZS5qcz9jZGQ4Il0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBhcHBseUFsaWduIGZyb20gJy4vYXBwbHlBbGlnbic7XG5pbXBvcnQgYXBwbHlCYXNlIGZyb20gJy4vYXBwbHlCYXNlJztcbmltcG9ydCBhcHBseUNsYW1wIGZyb20gJy4vYXBwbHlDbGFtcCc7XG5pbXBvcnQgYXBwbHlFeHBvbmVudCBmcm9tICcuL2FwcGx5RXhwb25lbnQnO1xuaW1wb3J0IGFwcGx5TmljZSBmcm9tICcuL2FwcGx5TmljZSc7XG5pbXBvcnQgYXBwbHlaZXJvIGZyb20gJy4vYXBwbHlaZXJvJztcbmltcG9ydCBhcHBseUludGVycG9sYXRlIGZyb20gJy4vYXBwbHlJbnRlcnBvbGF0ZSc7XG5pbXBvcnQgYXBwbHlSb3VuZCBmcm9tICcuL2FwcGx5Um91bmQnO1xuaW1wb3J0IGFwcGx5RG9tYWluIGZyb20gJy4vYXBwbHlEb21haW4nO1xuaW1wb3J0IGFwcGx5UmFuZ2UgZnJvbSAnLi9hcHBseVJhbmdlJztcbmltcG9ydCBhcHBseVBhZGRpbmcgZnJvbSAnLi9hcHBseVBhZGRpbmcnO1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gdXBkYXRlU2NhbGUoc2NhbGUsIGNvbmZpZykge1xuICAvLyBkb21haW4gYW5kIHJhbmdlIGFwcGx5IHRvIGFsbCBzY2FsZXNcbiAgYXBwbHlEb21haW4oY29uZmlnLCBzY2FsZSk7XG4gIGFwcGx5UmFuZ2UoY29uZmlnLCBzY2FsZSk7IC8vIFNvcnQgb3RoZXIgcHJvcGVydGllcyBhbHBoYWJldGljYWxseS5cblxuICBhcHBseUFsaWduKGNvbmZpZywgc2NhbGUpO1xuICBhcHBseUJhc2UoY29uZmlnLCBzY2FsZSk7XG4gIGFwcGx5Q2xhbXAoY29uZmlnLCBzY2FsZSk7XG4gIGFwcGx5RXhwb25lbnQoY29uZmlnLCBzY2FsZSk7XG4gIGFwcGx5SW50ZXJwb2xhdGUoY29uZmlnLCBzY2FsZSk7IC8vIE5pY2UgZGVwZW5kcyBvbiBkb21haW4uXG5cbiAgYXBwbHlOaWNlKGNvbmZpZywgc2NhbGUpO1xuICBhcHBseVBhZGRpbmcoY29uZmlnLCBzY2FsZSk7XG4gIGFwcGx5Um91bmQoY29uZmlnLCBzY2FsZSk7IC8vIFplcm8gZGVwZW5kcyBvbiBkb21haW4gYW5kIG5pY2UuXG5cbiAgYXBwbHlaZXJvKGNvbmZpZywgc2NhbGUpO1xuICByZXR1cm4gc2NhbGU7XG59Il0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/parsers/scale/updateScale.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/typeGuards/Base.js":
/*!*******************************************************!*\
  !*** ./node_modules/encodable/esm/typeGuards/Base.js ***!
  \*******************************************************/
/*! exports provided: isArray, isNotArray, isDefined, isEveryElementDefined */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isArray\", function() { return isArray; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isNotArray\", function() { return isNotArray; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isDefined\", function() { return isDefined; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isEveryElementDefined\", function() { return isEveryElementDefined; });\nfunction isArray(maybeArray) {\n  return Array.isArray(maybeArray);\n}\nfunction isNotArray(maybeArray) {\n  return !Array.isArray(maybeArray);\n}\nfunction isDefined(value) {\n  return typeof value !== 'undefined' && value !== null;\n}\nfunction isEveryElementDefined(array) {\n  return array.every(isDefined);\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS90eXBlR3VhcmRzL0Jhc2UuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS90eXBlR3VhcmRzL0Jhc2UuanM/MDI0ZiJdLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgZnVuY3Rpb24gaXNBcnJheShtYXliZUFycmF5KSB7XG4gIHJldHVybiBBcnJheS5pc0FycmF5KG1heWJlQXJyYXkpO1xufVxuZXhwb3J0IGZ1bmN0aW9uIGlzTm90QXJyYXkobWF5YmVBcnJheSkge1xuICByZXR1cm4gIUFycmF5LmlzQXJyYXkobWF5YmVBcnJheSk7XG59XG5leHBvcnQgZnVuY3Rpb24gaXNEZWZpbmVkKHZhbHVlKSB7XG4gIHJldHVybiB0eXBlb2YgdmFsdWUgIT09ICd1bmRlZmluZWQnICYmIHZhbHVlICE9PSBudWxsO1xufVxuZXhwb3J0IGZ1bmN0aW9uIGlzRXZlcnlFbGVtZW50RGVmaW5lZChhcnJheSkge1xuICByZXR1cm4gYXJyYXkuZXZlcnkoaXNEZWZpbmVkKTtcbn0iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/typeGuards/Base.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/typeGuards/Channel.js":
/*!**********************************************************!*\
  !*** ./node_modules/encodable/esm/typeGuards/Channel.js ***!
  \**********************************************************/
/*! exports provided: isX, isY, isXOrY */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isX\", function() { return isX; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isY\", function() { return isY; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isXOrY\", function() { return isXOrY; });\nfunction isX(channelType) {\n  return channelType === 'X' || channelType === 'XBand';\n}\nfunction isY(channelType) {\n  return channelType === 'Y' || channelType === 'YBand';\n}\nfunction isXOrY(channelType) {\n  return isX(channelType) || isY(channelType);\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS90eXBlR3VhcmRzL0NoYW5uZWwuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS90eXBlR3VhcmRzL0NoYW5uZWwuanM/YjM4ZiJdLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgZnVuY3Rpb24gaXNYKGNoYW5uZWxUeXBlKSB7XG4gIHJldHVybiBjaGFubmVsVHlwZSA9PT0gJ1gnIHx8IGNoYW5uZWxUeXBlID09PSAnWEJhbmQnO1xufVxuZXhwb3J0IGZ1bmN0aW9uIGlzWShjaGFubmVsVHlwZSkge1xuICByZXR1cm4gY2hhbm5lbFR5cGUgPT09ICdZJyB8fCBjaGFubmVsVHlwZSA9PT0gJ1lCYW5kJztcbn1cbmV4cG9ydCBmdW5jdGlvbiBpc1hPclkoY2hhbm5lbFR5cGUpIHtcbiAgcmV0dXJuIGlzWChjaGFubmVsVHlwZSkgfHwgaXNZKGNoYW5uZWxUeXBlKTtcbn0iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/typeGuards/Channel.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/typeGuards/ChannelDef.js":
/*!*************************************************************!*\
  !*** ./node_modules/encodable/esm/typeGuards/ChannelDef.js ***!
  \*************************************************************/
/*! exports provided: isValueDef, isNonValueDef, isFieldDef, isTypedFieldDef, isScaleFieldDef, isPositionFieldDef */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isValueDef\", function() { return isValueDef; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isNonValueDef\", function() { return isNonValueDef; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isFieldDef\", function() { return isFieldDef; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isTypedFieldDef\", function() { return isTypedFieldDef; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isScaleFieldDef\", function() { return isScaleFieldDef; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isPositionFieldDef\", function() { return isPositionFieldDef; });\nfunction isValueDef(channelDef) {\n  return channelDef && 'value' in channelDef;\n}\nfunction isNonValueDef(channelDef) {\n  return channelDef && !('value' in channelDef);\n}\nfunction isFieldDef(channelDef) {\n  return channelDef && 'field' in channelDef && !!channelDef.field;\n}\nfunction isTypedFieldDef(channelDef) {\n  return isFieldDef(channelDef) && 'type' in channelDef && !!channelDef.type;\n}\nfunction isScaleFieldDef(channelDef) {\n  return isTypedFieldDef(channelDef) && 'scale' in channelDef;\n}\nfunction isPositionFieldDef(channelDef) {\n  return isTypedFieldDef(channelDef) && 'axis' in channelDef;\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS90eXBlR3VhcmRzL0NoYW5uZWxEZWYuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS90eXBlR3VhcmRzL0NoYW5uZWxEZWYuanM/ZDg4YSJdLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgZnVuY3Rpb24gaXNWYWx1ZURlZihjaGFubmVsRGVmKSB7XG4gIHJldHVybiBjaGFubmVsRGVmICYmICd2YWx1ZScgaW4gY2hhbm5lbERlZjtcbn1cbmV4cG9ydCBmdW5jdGlvbiBpc05vblZhbHVlRGVmKGNoYW5uZWxEZWYpIHtcbiAgcmV0dXJuIGNoYW5uZWxEZWYgJiYgISgndmFsdWUnIGluIGNoYW5uZWxEZWYpO1xufVxuZXhwb3J0IGZ1bmN0aW9uIGlzRmllbGREZWYoY2hhbm5lbERlZikge1xuICByZXR1cm4gY2hhbm5lbERlZiAmJiAnZmllbGQnIGluIGNoYW5uZWxEZWYgJiYgISFjaGFubmVsRGVmLmZpZWxkO1xufVxuZXhwb3J0IGZ1bmN0aW9uIGlzVHlwZWRGaWVsZERlZihjaGFubmVsRGVmKSB7XG4gIHJldHVybiBpc0ZpZWxkRGVmKGNoYW5uZWxEZWYpICYmICd0eXBlJyBpbiBjaGFubmVsRGVmICYmICEhY2hhbm5lbERlZi50eXBlO1xufVxuZXhwb3J0IGZ1bmN0aW9uIGlzU2NhbGVGaWVsZERlZihjaGFubmVsRGVmKSB7XG4gIHJldHVybiBpc1R5cGVkRmllbGREZWYoY2hhbm5lbERlZikgJiYgJ3NjYWxlJyBpbiBjaGFubmVsRGVmO1xufVxuZXhwb3J0IGZ1bmN0aW9uIGlzUG9zaXRpb25GaWVsZERlZihjaGFubmVsRGVmKSB7XG4gIHJldHVybiBpc1R5cGVkRmllbGREZWYoY2hhbm5lbERlZikgJiYgJ2F4aXMnIGluIGNoYW5uZWxEZWY7XG59Il0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/typeGuards/ChannelDef.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/typeGuards/CompleteChannelDef.js":
/*!*********************************************************************!*\
  !*** ./node_modules/encodable/esm/typeGuards/CompleteChannelDef.js ***!
  \*********************************************************************/
/*! exports provided: isCompleteValueDef, isCompleteFieldDef */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isCompleteValueDef\", function() { return isCompleteValueDef; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isCompleteFieldDef\", function() { return isCompleteFieldDef; });\nfunction isCompleteValueDef(def) {\n  return 'value' in def;\n}\nfunction isCompleteFieldDef(def) {\n  return 'field' in def;\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS90eXBlR3VhcmRzL0NvbXBsZXRlQ2hhbm5lbERlZi5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9lbmNvZGFibGUvZXNtL3R5cGVHdWFyZHMvQ29tcGxldGVDaGFubmVsRGVmLmpzP2JmZjciXSwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IGZ1bmN0aW9uIGlzQ29tcGxldGVWYWx1ZURlZihkZWYpIHtcbiAgcmV0dXJuICd2YWx1ZScgaW4gZGVmO1xufVxuZXhwb3J0IGZ1bmN0aW9uIGlzQ29tcGxldGVGaWVsZERlZihkZWYpIHtcbiAgcmV0dXJuICdmaWVsZCcgaW4gZGVmO1xufSJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/typeGuards/CompleteChannelDef.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/typeGuards/DateTime.js":
/*!***********************************************************!*\
  !*** ./node_modules/encodable/esm/typeGuards/DateTime.js ***!
  \***********************************************************/
/*! exports provided: isDateTime */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isDateTime\", function() { return isDateTime; });\n// eslint-disable-next-line import/prefer-default-export\nfunction isDateTime(o) {\n  return !!o && !(o instanceof Date) && typeof o !== 'string' && typeof o !== 'boolean' && typeof o !== 'number' && ('year' in o && o.year != null || 'quarter' in o && o.quarter != null || 'month' in o && o.month != null || 'date' in o && o.date != null || 'day' in o && o.day != null || 'hours' in o && o.hours != null || 'minutes' in o && o.minutes != null || 'seconds' in o && o.seconds != null || 'milliseconds' in o && o.milliseconds != null);\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS90eXBlR3VhcmRzL0RhdGVUaW1lLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9lc20vdHlwZUd1YXJkcy9EYXRlVGltZS5qcz9iNzRlIl0sInNvdXJjZXNDb250ZW50IjpbIi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBpbXBvcnQvcHJlZmVyLWRlZmF1bHQtZXhwb3J0XG5leHBvcnQgZnVuY3Rpb24gaXNEYXRlVGltZShvKSB7XG4gIHJldHVybiAhIW8gJiYgIShvIGluc3RhbmNlb2YgRGF0ZSkgJiYgdHlwZW9mIG8gIT09ICdzdHJpbmcnICYmIHR5cGVvZiBvICE9PSAnYm9vbGVhbicgJiYgdHlwZW9mIG8gIT09ICdudW1iZXInICYmICgneWVhcicgaW4gbyAmJiBvLnllYXIgIT0gbnVsbCB8fCAncXVhcnRlcicgaW4gbyAmJiBvLnF1YXJ0ZXIgIT0gbnVsbCB8fCAnbW9udGgnIGluIG8gJiYgby5tb250aCAhPSBudWxsIHx8ICdkYXRlJyBpbiBvICYmIG8uZGF0ZSAhPSBudWxsIHx8ICdkYXknIGluIG8gJiYgby5kYXkgIT0gbnVsbCB8fCAnaG91cnMnIGluIG8gJiYgby5ob3VycyAhPSBudWxsIHx8ICdtaW51dGVzJyBpbiBvICYmIG8ubWludXRlcyAhPSBudWxsIHx8ICdzZWNvbmRzJyBpbiBvICYmIG8uc2Vjb25kcyAhPSBudWxsIHx8ICdtaWxsaXNlY29uZHMnIGluIG8gJiYgby5taWxsaXNlY29uZHMgIT0gbnVsbCk7XG59Il0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/typeGuards/DateTime.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/typeGuards/Scale.js":
/*!********************************************************!*\
  !*** ./node_modules/encodable/esm/typeGuards/Scale.js ***!
  \********************************************************/
/*! exports provided: isContinuousScale, isDiscretizingScale, isDiscreteScale, isTimeScale */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isContinuousScale\", function() { return isContinuousScale; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isDiscretizingScale\", function() { return isDiscretizingScale; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isDiscreteScale\", function() { return isDiscreteScale; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isTimeScale\", function() { return isTimeScale; });\n/* harmony import */ var _parsers_scale_scaleCategories__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../parsers/scale/scaleCategories */ \"./node_modules/encodable/esm/parsers/scale/scaleCategories.js\");\n\nfunction isContinuousScale(scale, scaleType) {\n  return scale && _parsers_scale_scaleCategories__WEBPACK_IMPORTED_MODULE_0__[\"continuousScaleTypesSet\"].has(scaleType);\n}\nfunction isDiscretizingScale(scale, scaleType) {\n  return scale && _parsers_scale_scaleCategories__WEBPACK_IMPORTED_MODULE_0__[\"discretizingScaleTypesSet\"].has(scaleType);\n}\nfunction isDiscreteScale(scale, scaleType) {\n  return scale && _parsers_scale_scaleCategories__WEBPACK_IMPORTED_MODULE_0__[\"discreteScaleTypesSet\"].has(scaleType);\n}\nfunction isTimeScale(scale, scaleType) {\n  return scale && _parsers_scale_scaleCategories__WEBPACK_IMPORTED_MODULE_0__[\"timeScaleTypesSet\"].has(scaleType);\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS90eXBlR3VhcmRzL1NjYWxlLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9lc20vdHlwZUd1YXJkcy9TY2FsZS5qcz9iYzkzIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IHRpbWVTY2FsZVR5cGVzU2V0LCBjb250aW51b3VzU2NhbGVUeXBlc1NldCwgZGlzY3JldGl6aW5nU2NhbGVUeXBlc1NldCwgZGlzY3JldGVTY2FsZVR5cGVzU2V0IH0gZnJvbSAnLi4vcGFyc2Vycy9zY2FsZS9zY2FsZUNhdGVnb3JpZXMnO1xuZXhwb3J0IGZ1bmN0aW9uIGlzQ29udGludW91c1NjYWxlKHNjYWxlLCBzY2FsZVR5cGUpIHtcbiAgcmV0dXJuIHNjYWxlICYmIGNvbnRpbnVvdXNTY2FsZVR5cGVzU2V0LmhhcyhzY2FsZVR5cGUpO1xufVxuZXhwb3J0IGZ1bmN0aW9uIGlzRGlzY3JldGl6aW5nU2NhbGUoc2NhbGUsIHNjYWxlVHlwZSkge1xuICByZXR1cm4gc2NhbGUgJiYgZGlzY3JldGl6aW5nU2NhbGVUeXBlc1NldC5oYXMoc2NhbGVUeXBlKTtcbn1cbmV4cG9ydCBmdW5jdGlvbiBpc0Rpc2NyZXRlU2NhbGUoc2NhbGUsIHNjYWxlVHlwZSkge1xuICByZXR1cm4gc2NhbGUgJiYgZGlzY3JldGVTY2FsZVR5cGVzU2V0LmhhcyhzY2FsZVR5cGUpO1xufVxuZXhwb3J0IGZ1bmN0aW9uIGlzVGltZVNjYWxlKHNjYWxlLCBzY2FsZVR5cGUpIHtcbiAgcmV0dXJuIHNjYWxlICYmIHRpbWVTY2FsZVR5cGVzU2V0LmhhcyhzY2FsZVR5cGUpO1xufSJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/typeGuards/Scale.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/typeGuards/ScaleConfig.js":
/*!**************************************************************!*\
  !*** ./node_modules/encodable/esm/typeGuards/ScaleConfig.js ***!
  \**************************************************************/
/*! exports provided: isContinuousScaleConfig, isDiscretizingScaleConfig, isDiscreteScaleConfig, isScaleConfigWithZero */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isContinuousScaleConfig\", function() { return isContinuousScaleConfig; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isDiscretizingScaleConfig\", function() { return isDiscretizingScaleConfig; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isDiscreteScaleConfig\", function() { return isDiscreteScaleConfig; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isScaleConfigWithZero\", function() { return isScaleConfigWithZero; });\n/* harmony import */ var _parsers_scale_isPropertySupportedByScaleType__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../parsers/scale/isPropertySupportedByScaleType */ \"./node_modules/encodable/esm/parsers/scale/isPropertySupportedByScaleType.js\");\n/* harmony import */ var _parsers_scale_scaleCategories__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../parsers/scale/scaleCategories */ \"./node_modules/encodable/esm/parsers/scale/scaleCategories.js\");\n\n\nfunction isContinuousScaleConfig(config) {\n  return _parsers_scale_scaleCategories__WEBPACK_IMPORTED_MODULE_1__[\"continuousScaleTypesSet\"].has(config.type);\n}\nfunction isDiscretizingScaleConfig(config) {\n  return _parsers_scale_scaleCategories__WEBPACK_IMPORTED_MODULE_1__[\"discretizingScaleTypesSet\"].has(config.type);\n}\nfunction isDiscreteScaleConfig(config) {\n  return _parsers_scale_scaleCategories__WEBPACK_IMPORTED_MODULE_1__[\"discreteScaleTypesSet\"].has(config.type);\n}\nfunction isScaleConfigWithZero(config) {\n  return Object(_parsers_scale_isPropertySupportedByScaleType__WEBPACK_IMPORTED_MODULE_0__[\"default\"])('zero', config.type);\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS90eXBlR3VhcmRzL1NjYWxlQ29uZmlnLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9lc20vdHlwZUd1YXJkcy9TY2FsZUNvbmZpZy5qcz9lMDQ4Il0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBpc1Byb3BlcnR5U3VwcG9ydGVkQnlTY2FsZVR5cGUgZnJvbSAnLi4vcGFyc2Vycy9zY2FsZS9pc1Byb3BlcnR5U3VwcG9ydGVkQnlTY2FsZVR5cGUnO1xuaW1wb3J0IHsgY29udGludW91c1NjYWxlVHlwZXNTZXQsIGRpc2NyZXRpemluZ1NjYWxlVHlwZXNTZXQsIGRpc2NyZXRlU2NhbGVUeXBlc1NldCB9IGZyb20gJy4uL3BhcnNlcnMvc2NhbGUvc2NhbGVDYXRlZ29yaWVzJztcbmV4cG9ydCBmdW5jdGlvbiBpc0NvbnRpbnVvdXNTY2FsZUNvbmZpZyhjb25maWcpIHtcbiAgcmV0dXJuIGNvbnRpbnVvdXNTY2FsZVR5cGVzU2V0Lmhhcyhjb25maWcudHlwZSk7XG59XG5leHBvcnQgZnVuY3Rpb24gaXNEaXNjcmV0aXppbmdTY2FsZUNvbmZpZyhjb25maWcpIHtcbiAgcmV0dXJuIGRpc2NyZXRpemluZ1NjYWxlVHlwZXNTZXQuaGFzKGNvbmZpZy50eXBlKTtcbn1cbmV4cG9ydCBmdW5jdGlvbiBpc0Rpc2NyZXRlU2NhbGVDb25maWcoY29uZmlnKSB7XG4gIHJldHVybiBkaXNjcmV0ZVNjYWxlVHlwZXNTZXQuaGFzKGNvbmZpZy50eXBlKTtcbn1cbmV4cG9ydCBmdW5jdGlvbiBpc1NjYWxlQ29uZmlnV2l0aFplcm8oY29uZmlnKSB7XG4gIHJldHVybiBpc1Byb3BlcnR5U3VwcG9ydGVkQnlTY2FsZVR5cGUoJ3plcm8nLCBjb25maWcudHlwZSk7XG59Il0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/typeGuards/ScaleConfig.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/typeGuards/SchemeParams.js":
/*!***************************************************************!*\
  !*** ./node_modules/encodable/esm/typeGuards/SchemeParams.js ***!
  \***************************************************************/
/*! exports provided: isSchemeParams */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isSchemeParams\", function() { return isSchemeParams; });\n// eslint-disable-next-line import/prefer-default-export\nfunction isSchemeParams(scheme) {\n  return Object.prototype.toString.call(scheme) !== '[object String]';\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS90eXBlR3VhcmRzL1NjaGVtZVBhcmFtcy5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9lbmNvZGFibGUvZXNtL3R5cGVHdWFyZHMvU2NoZW1lUGFyYW1zLmpzPzcwNzIiXSwic291cmNlc0NvbnRlbnQiOlsiLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIGltcG9ydC9wcmVmZXItZGVmYXVsdC1leHBvcnRcbmV4cG9ydCBmdW5jdGlvbiBpc1NjaGVtZVBhcmFtcyhzY2hlbWUpIHtcbiAgcmV0dXJuIE9iamVjdC5wcm90b3R5cGUudG9TdHJpbmcuY2FsbChzY2hlbWUpICE9PSAnW29iamVjdCBTdHJpbmddJztcbn0iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/typeGuards/SchemeParams.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/types/scale/ScaleType.js":
/*!*************************************************************!*\
  !*** ./node_modules/encodable/esm/types/scale/ScaleType.js ***!
  \*************************************************************/
/*! exports provided: ScaleType */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"ScaleType\", function() { return ScaleType; });\n// Modified from vega-lite\n// because vega-lite uses namespace which has issues with babel and typescript\nconst ScaleType = {\n  // Continuous - Quantitative\n  LINEAR: 'linear',\n  LOG: 'log',\n  POW: 'pow',\n  SQRT: 'sqrt',\n  SYMLOG: 'symlog',\n  // Continuous - Time\n  TIME: 'time',\n  UTC: 'utc',\n  // Discretizing scales\n  QUANTILE: 'quantile',\n  QUANTIZE: 'quantize',\n  THRESHOLD: 'threshold',\n  BIN_ORDINAL: 'bin-ordinal',\n  // Discrete scales\n  ORDINAL: 'ordinal',\n  POINT: 'point',\n  BAND: 'band'\n};//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS90eXBlcy9zY2FsZS9TY2FsZVR5cGUuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS90eXBlcy9zY2FsZS9TY2FsZVR5cGUuanM/ODU0OSJdLCJzb3VyY2VzQ29udGVudCI6WyIvLyBNb2RpZmllZCBmcm9tIHZlZ2EtbGl0ZVxuLy8gYmVjYXVzZSB2ZWdhLWxpdGUgdXNlcyBuYW1lc3BhY2Ugd2hpY2ggaGFzIGlzc3VlcyB3aXRoIGJhYmVsIGFuZCB0eXBlc2NyaXB0XG5leHBvcnQgY29uc3QgU2NhbGVUeXBlID0ge1xuICAvLyBDb250aW51b3VzIC0gUXVhbnRpdGF0aXZlXG4gIExJTkVBUjogJ2xpbmVhcicsXG4gIExPRzogJ2xvZycsXG4gIFBPVzogJ3BvdycsXG4gIFNRUlQ6ICdzcXJ0JyxcbiAgU1lNTE9HOiAnc3ltbG9nJyxcbiAgLy8gQ29udGludW91cyAtIFRpbWVcbiAgVElNRTogJ3RpbWUnLFxuICBVVEM6ICd1dGMnLFxuICAvLyBEaXNjcmV0aXppbmcgc2NhbGVzXG4gIFFVQU5USUxFOiAncXVhbnRpbGUnLFxuICBRVUFOVElaRTogJ3F1YW50aXplJyxcbiAgVEhSRVNIT0xEOiAndGhyZXNob2xkJyxcbiAgQklOX09SRElOQUw6ICdiaW4tb3JkaW5hbCcsXG4gIC8vIERpc2NyZXRlIHNjYWxlc1xuICBPUkRJTkFMOiAnb3JkaW5hbCcsXG4gIFBPSU5UOiAncG9pbnQnLFxuICBCQU5EOiAnYmFuZCdcbn07Il0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/types/scale/ScaleType.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/utils/combineCategories.js":
/*!***************************************************************!*\
  !*** ./node_modules/encodable/esm/utils/combineCategories.js ***!
  \***************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return combineCategories; });\n/**\n * Combine two arrays into a unique list\n * by keeping the order the fixedCategories\n * and append new categories at the end.\n * @param fixedCategories\n * @param inputCategories\n */\nfunction combineCategories(fixedCategories, inputCategories = []) {\n  if (fixedCategories.length === 0) {\n    return inputCategories;\n  }\n\n  const fixedSet = new Set(fixedCategories);\n  return fixedCategories.concat(inputCategories.filter(d => !fixedSet.has(d)));\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS91dGlscy9jb21iaW5lQ2F0ZWdvcmllcy5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9lbmNvZGFibGUvZXNtL3V0aWxzL2NvbWJpbmVDYXRlZ29yaWVzLmpzPzNjMWIiXSwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBDb21iaW5lIHR3byBhcnJheXMgaW50byBhIHVuaXF1ZSBsaXN0XG4gKiBieSBrZWVwaW5nIHRoZSBvcmRlciB0aGUgZml4ZWRDYXRlZ29yaWVzXG4gKiBhbmQgYXBwZW5kIG5ldyBjYXRlZ29yaWVzIGF0IHRoZSBlbmQuXG4gKiBAcGFyYW0gZml4ZWRDYXRlZ29yaWVzXG4gKiBAcGFyYW0gaW5wdXRDYXRlZ29yaWVzXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIGNvbWJpbmVDYXRlZ29yaWVzKGZpeGVkQ2F0ZWdvcmllcywgaW5wdXRDYXRlZ29yaWVzID0gW10pIHtcbiAgaWYgKGZpeGVkQ2F0ZWdvcmllcy5sZW5ndGggPT09IDApIHtcbiAgICByZXR1cm4gaW5wdXRDYXRlZ29yaWVzO1xuICB9XG5cbiAgY29uc3QgZml4ZWRTZXQgPSBuZXcgU2V0KGZpeGVkQ2F0ZWdvcmllcyk7XG4gIHJldHVybiBmaXhlZENhdGVnb3JpZXMuY29uY2F0KGlucHV0Q2F0ZWdvcmllcy5maWx0ZXIoZCA9PiAhZml4ZWRTZXQuaGFzKGQpKSk7XG59Il0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/utils/combineCategories.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/utils/combineContinuousDomains.js":
/*!**********************************************************************!*\
  !*** ./node_modules/encodable/esm/utils/combineContinuousDomains.js ***!
  \**********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return combineContinuousDomains; });\n/* harmony import */ var _typeGuards_Base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../typeGuards/Base */ \"./node_modules/encodable/esm/typeGuards/Base.js\");\n\n/**\n * Combine two continuous domain and ensure that the output\n * does not go beyond fixedDomain\n * @param bounds\n * @param dataDomain\n */\n\nfunction combineContinuousDomains(bounds, dataDomain) {\n  if (bounds.length > 0 && Object(_typeGuards_Base__WEBPACK_IMPORTED_MODULE_0__[\"isEveryElementDefined\"])(bounds)) {\n    return bounds;\n  }\n\n  if (bounds.length === 2 && dataDomain.length === 2 && bounds.filter(_typeGuards_Base__WEBPACK_IMPORTED_MODULE_0__[\"isDefined\"]).length > 0) {\n    const [boundMin, boundMax] = bounds;\n    const [dataMin, dataMax] = dataDomain;\n    let min = dataMin;\n\n    if (Object(_typeGuards_Base__WEBPACK_IMPORTED_MODULE_0__[\"isDefined\"])(boundMin)) {\n      min = boundMin.valueOf() > dataMin.valueOf() ? boundMin : dataMin;\n    }\n\n    let max = dataMax;\n\n    if (Object(_typeGuards_Base__WEBPACK_IMPORTED_MODULE_0__[\"isDefined\"])(boundMax)) {\n      max = boundMax.valueOf() < dataMax.valueOf() ? boundMax : dataMax;\n    }\n\n    return [min, max];\n  }\n\n  return dataDomain;\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS91dGlscy9jb21iaW5lQ29udGludW91c0RvbWFpbnMuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS91dGlscy9jb21iaW5lQ29udGludW91c0RvbWFpbnMuanM/NDk3MyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBpc0V2ZXJ5RWxlbWVudERlZmluZWQsIGlzRGVmaW5lZCB9IGZyb20gJy4uL3R5cGVHdWFyZHMvQmFzZSc7XG4vKipcbiAqIENvbWJpbmUgdHdvIGNvbnRpbnVvdXMgZG9tYWluIGFuZCBlbnN1cmUgdGhhdCB0aGUgb3V0cHV0XG4gKiBkb2VzIG5vdCBnbyBiZXlvbmQgZml4ZWREb21haW5cbiAqIEBwYXJhbSBib3VuZHNcbiAqIEBwYXJhbSBkYXRhRG9tYWluXG4gKi9cblxuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gY29tYmluZUNvbnRpbnVvdXNEb21haW5zKGJvdW5kcywgZGF0YURvbWFpbikge1xuICBpZiAoYm91bmRzLmxlbmd0aCA+IDAgJiYgaXNFdmVyeUVsZW1lbnREZWZpbmVkKGJvdW5kcykpIHtcbiAgICByZXR1cm4gYm91bmRzO1xuICB9XG5cbiAgaWYgKGJvdW5kcy5sZW5ndGggPT09IDIgJiYgZGF0YURvbWFpbi5sZW5ndGggPT09IDIgJiYgYm91bmRzLmZpbHRlcihpc0RlZmluZWQpLmxlbmd0aCA+IDApIHtcbiAgICBjb25zdCBbYm91bmRNaW4sIGJvdW5kTWF4XSA9IGJvdW5kcztcbiAgICBjb25zdCBbZGF0YU1pbiwgZGF0YU1heF0gPSBkYXRhRG9tYWluO1xuICAgIGxldCBtaW4gPSBkYXRhTWluO1xuXG4gICAgaWYgKGlzRGVmaW5lZChib3VuZE1pbikpIHtcbiAgICAgIG1pbiA9IGJvdW5kTWluLnZhbHVlT2YoKSA+IGRhdGFNaW4udmFsdWVPZigpID8gYm91bmRNaW4gOiBkYXRhTWluO1xuICAgIH1cblxuICAgIGxldCBtYXggPSBkYXRhTWF4O1xuXG4gICAgaWYgKGlzRGVmaW5lZChib3VuZE1heCkpIHtcbiAgICAgIG1heCA9IGJvdW5kTWF4LnZhbHVlT2YoKSA8IGRhdGFNYXgudmFsdWVPZigpID8gYm91bmRNYXggOiBkYXRhTWF4O1xuICAgIH1cblxuICAgIHJldHVybiBbbWluLCBtYXhdO1xuICB9XG5cbiAgcmV0dXJuIGRhdGFEb21haW47XG59Il0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/utils/combineContinuousDomains.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/utils/identity.js":
/*!******************************************************!*\
  !*** ./node_modules/encodable/esm/utils/identity.js ***!
  \******************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return identity; });\nfunction identity(x) {\n  return x;\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS91dGlscy9pZGVudGl0eS5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9lbmNvZGFibGUvZXNtL3V0aWxzL2lkZW50aXR5LmpzPzI4MTIiXSwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gaWRlbnRpdHkoeCkge1xuICByZXR1cm4geDtcbn0iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/utils/identity.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/utils/inferElementTypeFromUnionOfArrayTypes.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/encodable/esm/utils/inferElementTypeFromUnionOfArrayTypes.js ***!
  \***********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return inferElementTypeFromUnionOfArrayTypes; });\n/**\n * Type workaround for https://github.com/Microsoft/TypeScript/issues/7294#issuecomment-465794460\n * to avoid error \"Cannot invoke an expression whose type lacks a call signature\"\n * when using array.map\n */\nfunction inferElementTypeFromUnionOfArrayTypes(array) {\n  // eslint-disable-next-line @typescript-eslint/no-explicit-any\n  return array;\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS91dGlscy9pbmZlckVsZW1lbnRUeXBlRnJvbVVuaW9uT2ZBcnJheVR5cGVzLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9lc20vdXRpbHMvaW5mZXJFbGVtZW50VHlwZUZyb21Vbmlvbk9mQXJyYXlUeXBlcy5qcz9mMGU4Il0sInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogVHlwZSB3b3JrYXJvdW5kIGZvciBodHRwczovL2dpdGh1Yi5jb20vTWljcm9zb2Z0L1R5cGVTY3JpcHQvaXNzdWVzLzcyOTQjaXNzdWVjb21tZW50LTQ2NTc5NDQ2MFxuICogdG8gYXZvaWQgZXJyb3IgXCJDYW5ub3QgaW52b2tlIGFuIGV4cHJlc3Npb24gd2hvc2UgdHlwZSBsYWNrcyBhIGNhbGwgc2lnbmF0dXJlXCJcbiAqIHdoZW4gdXNpbmcgYXJyYXkubWFwXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIGluZmVyRWxlbWVudFR5cGVGcm9tVW5pb25PZkFycmF5VHlwZXMoYXJyYXkpIHtcbiAgLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIEB0eXBlc2NyaXB0LWVzbGludC9uby1leHBsaWNpdC1hbnlcbiAgcmV0dXJuIGFycmF5O1xufSJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/utils/inferElementTypeFromUnionOfArrayTypes.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/utils/isDisabled.js":
/*!********************************************************!*\
  !*** ./node_modules/encodable/esm/utils/isDisabled.js ***!
  \********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return isDisabled; });\nfunction isDisabled(config) {\n  return config === false || config === null;\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS91dGlscy9pc0Rpc2FibGVkLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9lc20vdXRpbHMvaXNEaXNhYmxlZC5qcz8zNzg0Il0sInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIGlzRGlzYWJsZWQoY29uZmlnKSB7XG4gIHJldHVybiBjb25maWcgPT09IGZhbHNlIHx8IGNvbmZpZyA9PT0gbnVsbDtcbn0iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/utils/isDisabled.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/utils/isEnabled.js":
/*!*******************************************************!*\
  !*** ./node_modules/encodable/esm/utils/isEnabled.js ***!
  \*******************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return isEnabled; });\n/* harmony import */ var _isDisabled__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isDisabled */ \"./node_modules/encodable/esm/utils/isDisabled.js\");\n\nfunction isEnabled(config) {\n  return !Object(_isDisabled__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(config);\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS91dGlscy9pc0VuYWJsZWQuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS91dGlscy9pc0VuYWJsZWQuanM/ZDk1ZiJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgaXNEaXNhYmxlZCBmcm9tICcuL2lzRGlzYWJsZWQnO1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gaXNFbmFibGVkKGNvbmZpZykge1xuICByZXR1cm4gIWlzRGlzYWJsZWQoY29uZmlnKTtcbn0iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/utils/isEnabled.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/utils/keys.js":
/*!**************************************************!*\
  !*** ./node_modules/encodable/esm/utils/keys.js ***!
  \**************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/**\n * This is a stricter version of Object.keys but with better types.\n * See https://github.com/Microsoft/TypeScript/pull/12253#issuecomment-263132208\n */\nconst keys = Object.keys;\n/* harmony default export */ __webpack_exports__[\"default\"] = (keys);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS91dGlscy9rZXlzLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9lc20vdXRpbHMva2V5cy5qcz8zN2I3Il0sInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogVGhpcyBpcyBhIHN0cmljdGVyIHZlcnNpb24gb2YgT2JqZWN0LmtleXMgYnV0IHdpdGggYmV0dGVyIHR5cGVzLlxuICogU2VlIGh0dHBzOi8vZ2l0aHViLmNvbS9NaWNyb3NvZnQvVHlwZVNjcmlwdC9wdWxsLzEyMjUzI2lzc3VlY29tbWVudC0yNjMxMzIyMDhcbiAqL1xuY29uc3Qga2V5cyA9IE9iamVjdC5rZXlzO1xuZXhwb3J0IGRlZmF1bHQga2V5czsiXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/utils/keys.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/utils/mergeEncoding.js":
/*!***********************************************************!*\
  !*** ./node_modules/encodable/esm/utils/mergeEncoding.js ***!
  \***********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return mergeEncoding; });\nfunction mergeEncoding(defaultEncoding, encoding) {\n  return { ...defaultEncoding,\n    ...encoding\n  };\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS91dGlscy9tZXJnZUVuY29kaW5nLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9lc20vdXRpbHMvbWVyZ2VFbmNvZGluZy5qcz8xOGMwIl0sInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIG1lcmdlRW5jb2RpbmcoZGVmYXVsdEVuY29kaW5nLCBlbmNvZGluZykge1xuICByZXR1cm4geyAuLi5kZWZhdWx0RW5jb2RpbmcsXG4gICAgLi4uZW5jb2RpbmdcbiAgfTtcbn0iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/utils/mergeEncoding.js\n");

/***/ }),

/***/ "./node_modules/encodable/esm/utils/removeUndefinedAndNull.js":
/*!********************************************************************!*\
  !*** ./node_modules/encodable/esm/utils/removeUndefinedAndNull.js ***!
  \********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return removeUndefinedAndNull; });\nfunction removeUndefinedAndNull(array) {\n  return array.filter(x => typeof x !== 'undefined' && x !== null);\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL2VzbS91dGlscy9yZW1vdmVVbmRlZmluZWRBbmROdWxsLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9lc20vdXRpbHMvcmVtb3ZlVW5kZWZpbmVkQW5kTnVsbC5qcz9hZTZkIl0sInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIHJlbW92ZVVuZGVmaW5lZEFuZE51bGwoYXJyYXkpIHtcbiAgcmV0dXJuIGFycmF5LmZpbHRlcih4ID0+IHR5cGVvZiB4ICE9PSAndW5kZWZpbmVkJyAmJiB4ICE9PSBudWxsKTtcbn0iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/esm/utils/removeUndefinedAndNull.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-array/src/ascending.js":
/*!***********************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-array/src/ascending.js ***!
  \***********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(a, b) {\n  return a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;\n});\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1hcnJheS9zcmMvYXNjZW5kaW5nLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9ub2RlX21vZHVsZXMvZDMtYXJyYXkvc3JjL2FzY2VuZGluZy5qcz82NjQwIl0sInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uKGEsIGIpIHtcbiAgcmV0dXJuIGEgPCBiID8gLTEgOiBhID4gYiA/IDEgOiBhID49IGIgPyAwIDogTmFOO1xufVxuIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQ0E7QUFDQTsiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-array/src/ascending.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-array/src/bisect.js":
/*!********************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-array/src/bisect.js ***!
  \********************************************************************/
/*! exports provided: bisectRight, bisectLeft, bisectCenter, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"bisectRight\", function() { return bisectRight; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"bisectLeft\", function() { return bisectLeft; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"bisectCenter\", function() { return bisectCenter; });\n/* harmony import */ var _ascending_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ascending.js */ \"./node_modules/encodable/node_modules/d3-array/src/ascending.js\");\n/* harmony import */ var _bisector_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./bisector.js */ \"./node_modules/encodable/node_modules/d3-array/src/bisector.js\");\n/* harmony import */ var _number_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./number.js */ \"./node_modules/encodable/node_modules/d3-array/src/number.js\");\n\n\n\n\nconst ascendingBisect = Object(_bisector_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(_ascending_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\nconst bisectRight = ascendingBisect.right;\nconst bisectLeft = ascendingBisect.left;\nconst bisectCenter = Object(_bisector_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(_number_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"]).center;\n/* harmony default export */ __webpack_exports__[\"default\"] = (bisectRight);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1hcnJheS9zcmMvYmlzZWN0LmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9ub2RlX21vZHVsZXMvZDMtYXJyYXkvc3JjL2Jpc2VjdC5qcz85ZTE5Il0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBhc2NlbmRpbmcgZnJvbSBcIi4vYXNjZW5kaW5nLmpzXCI7XG5pbXBvcnQgYmlzZWN0b3IgZnJvbSBcIi4vYmlzZWN0b3IuanNcIjtcbmltcG9ydCBudW1iZXIgZnJvbSBcIi4vbnVtYmVyLmpzXCI7XG5cbmNvbnN0IGFzY2VuZGluZ0Jpc2VjdCA9IGJpc2VjdG9yKGFzY2VuZGluZyk7XG5leHBvcnQgY29uc3QgYmlzZWN0UmlnaHQgPSBhc2NlbmRpbmdCaXNlY3QucmlnaHQ7XG5leHBvcnQgY29uc3QgYmlzZWN0TGVmdCA9IGFzY2VuZGluZ0Jpc2VjdC5sZWZ0O1xuZXhwb3J0IGNvbnN0IGJpc2VjdENlbnRlciA9IGJpc2VjdG9yKG51bWJlcikuY2VudGVyO1xuZXhwb3J0IGRlZmF1bHQgYmlzZWN0UmlnaHQ7XG4iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOyIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-array/src/bisect.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-array/src/bisector.js":
/*!**********************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-array/src/bisector.js ***!
  \**********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _ascending_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ascending.js */ \"./node_modules/encodable/node_modules/d3-array/src/ascending.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(f) {\n  let delta = f;\n  let compare = f;\n\n  if (f.length === 1) {\n    delta = (d, x) => f(d) - x;\n    compare = ascendingComparator(f);\n  }\n\n  function left(a, x, lo, hi) {\n    if (lo == null) lo = 0;\n    if (hi == null) hi = a.length;\n    while (lo < hi) {\n      const mid = (lo + hi) >>> 1;\n      if (compare(a[mid], x) < 0) lo = mid + 1;\n      else hi = mid;\n    }\n    return lo;\n  }\n\n  function right(a, x, lo, hi) {\n    if (lo == null) lo = 0;\n    if (hi == null) hi = a.length;\n    while (lo < hi) {\n      const mid = (lo + hi) >>> 1;\n      if (compare(a[mid], x) > 0) hi = mid;\n      else lo = mid + 1;\n    }\n    return lo;\n  }\n\n  function center(a, x, lo, hi) {\n    if (lo == null) lo = 0;\n    if (hi == null) hi = a.length;\n    const i = left(a, x, lo, hi - 1);\n    return i > lo && delta(a[i - 1], x) > -delta(a[i], x) ? i - 1 : i;\n  }\n\n  return {left, center, right};\n});\n\nfunction ascendingComparator(f) {\n  return (d, x) => Object(_ascending_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(f(d), x);\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-array/src/bisector.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-array/src/extent.js":
/*!********************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-array/src/extent.js ***!
  \********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(values, valueof) {\n  let min;\n  let max;\n  if (valueof === undefined) {\n    for (const value of values) {\n      if (value != null) {\n        if (min === undefined) {\n          if (value >= value) min = max = value;\n        } else {\n          if (min > value) min = value;\n          if (max < value) max = value;\n        }\n      }\n    }\n  } else {\n    let index = -1;\n    for (let value of values) {\n      if ((value = valueof(value, ++index, values)) != null) {\n        if (min === undefined) {\n          if (value >= value) min = max = value;\n        } else {\n          if (min > value) min = value;\n          if (max < value) max = value;\n        }\n      }\n    }\n  }\n  return [min, max];\n});\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1hcnJheS9zcmMvZXh0ZW50LmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9ub2RlX21vZHVsZXMvZDMtYXJyYXkvc3JjL2V4dGVudC5qcz9kYzRhIl0sInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uKHZhbHVlcywgdmFsdWVvZikge1xuICBsZXQgbWluO1xuICBsZXQgbWF4O1xuICBpZiAodmFsdWVvZiA9PT0gdW5kZWZpbmVkKSB7XG4gICAgZm9yIChjb25zdCB2YWx1ZSBvZiB2YWx1ZXMpIHtcbiAgICAgIGlmICh2YWx1ZSAhPSBudWxsKSB7XG4gICAgICAgIGlmIChtaW4gPT09IHVuZGVmaW5lZCkge1xuICAgICAgICAgIGlmICh2YWx1ZSA+PSB2YWx1ZSkgbWluID0gbWF4ID0gdmFsdWU7XG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgaWYgKG1pbiA+IHZhbHVlKSBtaW4gPSB2YWx1ZTtcbiAgICAgICAgICBpZiAobWF4IDwgdmFsdWUpIG1heCA9IHZhbHVlO1xuICAgICAgICB9XG4gICAgICB9XG4gICAgfVxuICB9IGVsc2Uge1xuICAgIGxldCBpbmRleCA9IC0xO1xuICAgIGZvciAobGV0IHZhbHVlIG9mIHZhbHVlcykge1xuICAgICAgaWYgKCh2YWx1ZSA9IHZhbHVlb2YodmFsdWUsICsraW5kZXgsIHZhbHVlcykpICE9IG51bGwpIHtcbiAgICAgICAgaWYgKG1pbiA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICAgICAgaWYgKHZhbHVlID49IHZhbHVlKSBtaW4gPSBtYXggPSB2YWx1ZTtcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICBpZiAobWluID4gdmFsdWUpIG1pbiA9IHZhbHVlO1xuICAgICAgICAgIGlmIChtYXggPCB2YWx1ZSkgbWF4ID0gdmFsdWU7XG4gICAgICAgIH1cbiAgICAgIH1cbiAgICB9XG4gIH1cbiAgcmV0dXJuIFttaW4sIG1heF07XG59XG4iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTsiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-array/src/extent.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-array/src/max.js":
/*!*****************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-array/src/max.js ***!
  \*****************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return max; });\nfunction max(values, valueof) {\n  let max;\n  if (valueof === undefined) {\n    for (const value of values) {\n      if (value != null\n          && (max < value || (max === undefined && value >= value))) {\n        max = value;\n      }\n    }\n  } else {\n    let index = -1;\n    for (let value of values) {\n      if ((value = valueof(value, ++index, values)) != null\n          && (max < value || (max === undefined && value >= value))) {\n        max = value;\n      }\n    }\n  }\n  return max;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1hcnJheS9zcmMvbWF4LmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9ub2RlX21vZHVsZXMvZDMtYXJyYXkvc3JjL21heC5qcz9kOTA2Il0sInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIG1heCh2YWx1ZXMsIHZhbHVlb2YpIHtcbiAgbGV0IG1heDtcbiAgaWYgKHZhbHVlb2YgPT09IHVuZGVmaW5lZCkge1xuICAgIGZvciAoY29uc3QgdmFsdWUgb2YgdmFsdWVzKSB7XG4gICAgICBpZiAodmFsdWUgIT0gbnVsbFxuICAgICAgICAgICYmIChtYXggPCB2YWx1ZSB8fCAobWF4ID09PSB1bmRlZmluZWQgJiYgdmFsdWUgPj0gdmFsdWUpKSkge1xuICAgICAgICBtYXggPSB2YWx1ZTtcbiAgICAgIH1cbiAgICB9XG4gIH0gZWxzZSB7XG4gICAgbGV0IGluZGV4ID0gLTE7XG4gICAgZm9yIChsZXQgdmFsdWUgb2YgdmFsdWVzKSB7XG4gICAgICBpZiAoKHZhbHVlID0gdmFsdWVvZih2YWx1ZSwgKytpbmRleCwgdmFsdWVzKSkgIT0gbnVsbFxuICAgICAgICAgICYmIChtYXggPCB2YWx1ZSB8fCAobWF4ID09PSB1bmRlZmluZWQgJiYgdmFsdWUgPj0gdmFsdWUpKSkge1xuICAgICAgICBtYXggPSB2YWx1ZTtcbiAgICAgIH1cbiAgICB9XG4gIH1cbiAgcmV0dXJuIG1heDtcbn1cbiJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Iiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-array/src/max.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-array/src/min.js":
/*!*****************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-array/src/min.js ***!
  \*****************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return min; });\nfunction min(values, valueof) {\n  let min;\n  if (valueof === undefined) {\n    for (const value of values) {\n      if (value != null\n          && (min > value || (min === undefined && value >= value))) {\n        min = value;\n      }\n    }\n  } else {\n    let index = -1;\n    for (let value of values) {\n      if ((value = valueof(value, ++index, values)) != null\n          && (min > value || (min === undefined && value >= value))) {\n        min = value;\n      }\n    }\n  }\n  return min;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1hcnJheS9zcmMvbWluLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9ub2RlX21vZHVsZXMvZDMtYXJyYXkvc3JjL21pbi5qcz9mZDMyIl0sInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIG1pbih2YWx1ZXMsIHZhbHVlb2YpIHtcbiAgbGV0IG1pbjtcbiAgaWYgKHZhbHVlb2YgPT09IHVuZGVmaW5lZCkge1xuICAgIGZvciAoY29uc3QgdmFsdWUgb2YgdmFsdWVzKSB7XG4gICAgICBpZiAodmFsdWUgIT0gbnVsbFxuICAgICAgICAgICYmIChtaW4gPiB2YWx1ZSB8fCAobWluID09PSB1bmRlZmluZWQgJiYgdmFsdWUgPj0gdmFsdWUpKSkge1xuICAgICAgICBtaW4gPSB2YWx1ZTtcbiAgICAgIH1cbiAgICB9XG4gIH0gZWxzZSB7XG4gICAgbGV0IGluZGV4ID0gLTE7XG4gICAgZm9yIChsZXQgdmFsdWUgb2YgdmFsdWVzKSB7XG4gICAgICBpZiAoKHZhbHVlID0gdmFsdWVvZih2YWx1ZSwgKytpbmRleCwgdmFsdWVzKSkgIT0gbnVsbFxuICAgICAgICAgICYmIChtaW4gPiB2YWx1ZSB8fCAobWluID09PSB1bmRlZmluZWQgJiYgdmFsdWUgPj0gdmFsdWUpKSkge1xuICAgICAgICBtaW4gPSB2YWx1ZTtcbiAgICAgIH1cbiAgICB9XG4gIH1cbiAgcmV0dXJuIG1pbjtcbn1cbiJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Iiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-array/src/min.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-array/src/number.js":
/*!********************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-array/src/number.js ***!
  \********************************************************************/
/*! exports provided: default, numbers */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"numbers\", function() { return numbers; });\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(x) {\n  return x === null ? NaN : +x;\n});\n\nfunction* numbers(values, valueof) {\n  if (valueof === undefined) {\n    for (let value of values) {\n      if (value != null && (value = +value) >= value) {\n        yield value;\n      }\n    }\n  } else {\n    let index = -1;\n    for (let value of values) {\n      if ((value = valueof(value, ++index, values)) != null && (value = +value) >= value) {\n        yield value;\n      }\n    }\n  }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1hcnJheS9zcmMvbnVtYmVyLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9ub2RlX21vZHVsZXMvZDMtYXJyYXkvc3JjL251bWJlci5qcz9iZmI2Il0sInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uKHgpIHtcbiAgcmV0dXJuIHggPT09IG51bGwgPyBOYU4gOiAreDtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uKiBudW1iZXJzKHZhbHVlcywgdmFsdWVvZikge1xuICBpZiAodmFsdWVvZiA9PT0gdW5kZWZpbmVkKSB7XG4gICAgZm9yIChsZXQgdmFsdWUgb2YgdmFsdWVzKSB7XG4gICAgICBpZiAodmFsdWUgIT0gbnVsbCAmJiAodmFsdWUgPSArdmFsdWUpID49IHZhbHVlKSB7XG4gICAgICAgIHlpZWxkIHZhbHVlO1xuICAgICAgfVxuICAgIH1cbiAgfSBlbHNlIHtcbiAgICBsZXQgaW5kZXggPSAtMTtcbiAgICBmb3IgKGxldCB2YWx1ZSBvZiB2YWx1ZXMpIHtcbiAgICAgIGlmICgodmFsdWUgPSB2YWx1ZW9mKHZhbHVlLCArK2luZGV4LCB2YWx1ZXMpKSAhPSBudWxsICYmICh2YWx1ZSA9ICt2YWx1ZSkgPj0gdmFsdWUpIHtcbiAgICAgICAgeWllbGQgdmFsdWU7XG4gICAgICB9XG4gICAgfVxuICB9XG59XG4iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOyIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-array/src/number.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-array/src/quantile.js":
/*!**********************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-array/src/quantile.js ***!
  \**********************************************************************/
/*! exports provided: default, quantileSorted */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return quantile; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"quantileSorted\", function() { return quantileSorted; });\n/* harmony import */ var _max_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./max.js */ \"./node_modules/encodable/node_modules/d3-array/src/max.js\");\n/* harmony import */ var _min_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./min.js */ \"./node_modules/encodable/node_modules/d3-array/src/min.js\");\n/* harmony import */ var _quickselect_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./quickselect.js */ \"./node_modules/encodable/node_modules/d3-array/src/quickselect.js\");\n/* harmony import */ var _number_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./number.js */ \"./node_modules/encodable/node_modules/d3-array/src/number.js\");\n\n\n\n\n\nfunction quantile(values, p, valueof) {\n  values = Float64Array.from(Object(_number_js__WEBPACK_IMPORTED_MODULE_3__[\"numbers\"])(values, valueof));\n  if (!(n = values.length)) return;\n  if ((p = +p) <= 0 || n < 2) return Object(_min_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(values);\n  if (p >= 1) return Object(_max_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(values);\n  var n,\n      i = (n - 1) * p,\n      i0 = Math.floor(i),\n      value0 = Object(_max_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(Object(_quickselect_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(values, i0).subarray(0, i0 + 1)),\n      value1 = Object(_min_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(values.subarray(i0 + 1));\n  return value0 + (value1 - value0) * (i - i0);\n}\n\nfunction quantileSorted(values, p, valueof = _number_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"]) {\n  if (!(n = values.length)) return;\n  if ((p = +p) <= 0 || n < 2) return +valueof(values[0], 0, values);\n  if (p >= 1) return +valueof(values[n - 1], n - 1, values);\n  var n,\n      i = (n - 1) * p,\n      i0 = Math.floor(i),\n      value0 = +valueof(values[i0], i0, values),\n      value1 = +valueof(values[i0 + 1], i0 + 1, values);\n  return value0 + (value1 - value0) * (i - i0);\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1hcnJheS9zcmMvcXVhbnRpbGUuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1hcnJheS9zcmMvcXVhbnRpbGUuanM/MTFhZiJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgbWF4IGZyb20gXCIuL21heC5qc1wiO1xuaW1wb3J0IG1pbiBmcm9tIFwiLi9taW4uanNcIjtcbmltcG9ydCBxdWlja3NlbGVjdCBmcm9tIFwiLi9xdWlja3NlbGVjdC5qc1wiO1xuaW1wb3J0IG51bWJlciwge251bWJlcnN9IGZyb20gXCIuL251bWJlci5qc1wiO1xuXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiBxdWFudGlsZSh2YWx1ZXMsIHAsIHZhbHVlb2YpIHtcbiAgdmFsdWVzID0gRmxvYXQ2NEFycmF5LmZyb20obnVtYmVycyh2YWx1ZXMsIHZhbHVlb2YpKTtcbiAgaWYgKCEobiA9IHZhbHVlcy5sZW5ndGgpKSByZXR1cm47XG4gIGlmICgocCA9ICtwKSA8PSAwIHx8IG4gPCAyKSByZXR1cm4gbWluKHZhbHVlcyk7XG4gIGlmIChwID49IDEpIHJldHVybiBtYXgodmFsdWVzKTtcbiAgdmFyIG4sXG4gICAgICBpID0gKG4gLSAxKSAqIHAsXG4gICAgICBpMCA9IE1hdGguZmxvb3IoaSksXG4gICAgICB2YWx1ZTAgPSBtYXgocXVpY2tzZWxlY3QodmFsdWVzLCBpMCkuc3ViYXJyYXkoMCwgaTAgKyAxKSksXG4gICAgICB2YWx1ZTEgPSBtaW4odmFsdWVzLnN1YmFycmF5KGkwICsgMSkpO1xuICByZXR1cm4gdmFsdWUwICsgKHZhbHVlMSAtIHZhbHVlMCkgKiAoaSAtIGkwKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHF1YW50aWxlU29ydGVkKHZhbHVlcywgcCwgdmFsdWVvZiA9IG51bWJlcikge1xuICBpZiAoIShuID0gdmFsdWVzLmxlbmd0aCkpIHJldHVybjtcbiAgaWYgKChwID0gK3ApIDw9IDAgfHwgbiA8IDIpIHJldHVybiArdmFsdWVvZih2YWx1ZXNbMF0sIDAsIHZhbHVlcyk7XG4gIGlmIChwID49IDEpIHJldHVybiArdmFsdWVvZih2YWx1ZXNbbiAtIDFdLCBuIC0gMSwgdmFsdWVzKTtcbiAgdmFyIG4sXG4gICAgICBpID0gKG4gLSAxKSAqIHAsXG4gICAgICBpMCA9IE1hdGguZmxvb3IoaSksXG4gICAgICB2YWx1ZTAgPSArdmFsdWVvZih2YWx1ZXNbaTBdLCBpMCwgdmFsdWVzKSxcbiAgICAgIHZhbHVlMSA9ICt2YWx1ZW9mKHZhbHVlc1tpMCArIDFdLCBpMCArIDEsIHZhbHVlcyk7XG4gIHJldHVybiB2YWx1ZTAgKyAodmFsdWUxIC0gdmFsdWUwKSAqIChpIC0gaTApO1xufVxuIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Iiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-array/src/quantile.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-array/src/quickselect.js":
/*!*************************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-array/src/quickselect.js ***!
  \*************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return quickselect; });\n/* harmony import */ var _ascending_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ascending.js */ \"./node_modules/encodable/node_modules/d3-array/src/ascending.js\");\n\n\n// Based on https://github.com/mourner/quickselect\n// ISC license, Copyright 2018 Vladimir Agafonkin.\nfunction quickselect(array, k, left = 0, right = array.length - 1, compare = _ascending_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"]) {\n  while (right > left) {\n    if (right - left > 600) {\n      const n = right - left + 1;\n      const m = k - left + 1;\n      const z = Math.log(n);\n      const s = 0.5 * Math.exp(2 * z / 3);\n      const sd = 0.5 * Math.sqrt(z * s * (n - s) / n) * (m - n / 2 < 0 ? -1 : 1);\n      const newLeft = Math.max(left, Math.floor(k - m * s / n + sd));\n      const newRight = Math.min(right, Math.floor(k + (n - m) * s / n + sd));\n      quickselect(array, k, newLeft, newRight, compare);\n    }\n\n    const t = array[k];\n    let i = left;\n    let j = right;\n\n    swap(array, left, k);\n    if (compare(array[right], t) > 0) swap(array, left, right);\n\n    while (i < j) {\n      swap(array, i, j), ++i, --j;\n      while (compare(array[i], t) < 0) ++i;\n      while (compare(array[j], t) > 0) --j;\n    }\n\n    if (compare(array[left], t) === 0) swap(array, left, j);\n    else ++j, swap(array, j, right);\n\n    if (j <= k) left = j + 1;\n    if (k <= j) right = j - 1;\n  }\n  return array;\n}\n\nfunction swap(array, i, j) {\n  const t = array[i];\n  array[i] = array[j];\n  array[j] = t;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-array/src/quickselect.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-array/src/range.js":
/*!*******************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-array/src/range.js ***!
  \*******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(start, stop, step) {\n  start = +start, stop = +stop, step = (n = arguments.length) < 2 ? (stop = start, start = 0, 1) : n < 3 ? 1 : +step;\n\n  var i = -1,\n      n = Math.max(0, Math.ceil((stop - start) / step)) | 0,\n      range = new Array(n);\n\n  while (++i < n) {\n    range[i] = start + i * step;\n  }\n\n  return range;\n});\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1hcnJheS9zcmMvcmFuZ2UuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1hcnJheS9zcmMvcmFuZ2UuanM/YWE1ZSJdLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgZGVmYXVsdCBmdW5jdGlvbihzdGFydCwgc3RvcCwgc3RlcCkge1xuICBzdGFydCA9ICtzdGFydCwgc3RvcCA9ICtzdG9wLCBzdGVwID0gKG4gPSBhcmd1bWVudHMubGVuZ3RoKSA8IDIgPyAoc3RvcCA9IHN0YXJ0LCBzdGFydCA9IDAsIDEpIDogbiA8IDMgPyAxIDogK3N0ZXA7XG5cbiAgdmFyIGkgPSAtMSxcbiAgICAgIG4gPSBNYXRoLm1heCgwLCBNYXRoLmNlaWwoKHN0b3AgLSBzdGFydCkgLyBzdGVwKSkgfCAwLFxuICAgICAgcmFuZ2UgPSBuZXcgQXJyYXkobik7XG5cbiAgd2hpbGUgKCsraSA8IG4pIHtcbiAgICByYW5nZVtpXSA9IHN0YXJ0ICsgaSAqIHN0ZXA7XG4gIH1cblxuICByZXR1cm4gcmFuZ2U7XG59XG4iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Iiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-array/src/range.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-array/src/ticks.js":
/*!*******************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-array/src/ticks.js ***!
  \*******************************************************************/
/*! exports provided: default, tickIncrement, tickStep */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"tickIncrement\", function() { return tickIncrement; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"tickStep\", function() { return tickStep; });\nvar e10 = Math.sqrt(50),\n    e5 = Math.sqrt(10),\n    e2 = Math.sqrt(2);\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(start, stop, count) {\n  var reverse,\n      i = -1,\n      n,\n      ticks,\n      step;\n\n  stop = +stop, start = +start, count = +count;\n  if (start === stop && count > 0) return [start];\n  if (reverse = stop < start) n = start, start = stop, stop = n;\n  if ((step = tickIncrement(start, stop, count)) === 0 || !isFinite(step)) return [];\n\n  if (step > 0) {\n    let r0 = Math.round(start / step), r1 = Math.round(stop / step);\n    if (r0 * step < start) ++r0;\n    if (r1 * step > stop) --r1;\n    ticks = new Array(n = r1 - r0 + 1);\n    while (++i < n) ticks[i] = (r0 + i) * step;\n  } else {\n    step = -step;\n    let r0 = Math.round(start * step), r1 = Math.round(stop * step);\n    if (r0 / step < start) ++r0;\n    if (r1 / step > stop) --r1;\n    ticks = new Array(n = r1 - r0 + 1);\n    while (++i < n) ticks[i] = (r0 + i) / step;\n  }\n\n  if (reverse) ticks.reverse();\n\n  return ticks;\n});\n\nfunction tickIncrement(start, stop, count) {\n  var step = (stop - start) / Math.max(0, count),\n      power = Math.floor(Math.log(step) / Math.LN10),\n      error = step / Math.pow(10, power);\n  return power >= 0\n      ? (error >= e10 ? 10 : error >= e5 ? 5 : error >= e2 ? 2 : 1) * Math.pow(10, power)\n      : -Math.pow(10, -power) / (error >= e10 ? 10 : error >= e5 ? 5 : error >= e2 ? 2 : 1);\n}\n\nfunction tickStep(start, stop, count) {\n  var step0 = Math.abs(stop - start) / Math.max(0, count),\n      step1 = Math.pow(10, Math.floor(Math.log(step0) / Math.LN10)),\n      error = step0 / step1;\n  if (error >= e10) step1 *= 10;\n  else if (error >= e5) step1 *= 5;\n  else if (error >= e2) step1 *= 2;\n  return stop < start ? -step1 : step1;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-array/src/ticks.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-interpolate/src/array.js":
/*!*************************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-interpolate/src/array.js ***!
  \*************************************************************************/
/*! exports provided: default, genericArray */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"genericArray\", function() { return genericArray; });\n/* harmony import */ var _value_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./value.js */ \"./node_modules/encodable/node_modules/d3-interpolate/src/value.js\");\n/* harmony import */ var _numberArray_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./numberArray.js */ \"./node_modules/encodable/node_modules/d3-interpolate/src/numberArray.js\");\n\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(a, b) {\n  return (Object(_numberArray_js__WEBPACK_IMPORTED_MODULE_1__[\"isNumberArray\"])(b) ? _numberArray_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"] : genericArray)(a, b);\n});\n\nfunction genericArray(a, b) {\n  var nb = b ? b.length : 0,\n      na = a ? Math.min(nb, a.length) : 0,\n      x = new Array(na),\n      c = new Array(nb),\n      i;\n\n  for (i = 0; i < na; ++i) x[i] = Object(_value_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(a[i], b[i]);\n  for (; i < nb; ++i) c[i] = b[i];\n\n  return function(t) {\n    for (i = 0; i < na; ++i) c[i] = x[i](t);\n    return c;\n  };\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1pbnRlcnBvbGF0ZS9zcmMvYXJyYXkuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1pbnRlcnBvbGF0ZS9zcmMvYXJyYXkuanM/ODk1MSJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgdmFsdWUgZnJvbSBcIi4vdmFsdWUuanNcIjtcbmltcG9ydCBudW1iZXJBcnJheSwge2lzTnVtYmVyQXJyYXl9IGZyb20gXCIuL251bWJlckFycmF5LmpzXCI7XG5cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uKGEsIGIpIHtcbiAgcmV0dXJuIChpc051bWJlckFycmF5KGIpID8gbnVtYmVyQXJyYXkgOiBnZW5lcmljQXJyYXkpKGEsIGIpO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gZ2VuZXJpY0FycmF5KGEsIGIpIHtcbiAgdmFyIG5iID0gYiA/IGIubGVuZ3RoIDogMCxcbiAgICAgIG5hID0gYSA/IE1hdGgubWluKG5iLCBhLmxlbmd0aCkgOiAwLFxuICAgICAgeCA9IG5ldyBBcnJheShuYSksXG4gICAgICBjID0gbmV3IEFycmF5KG5iKSxcbiAgICAgIGk7XG5cbiAgZm9yIChpID0gMDsgaSA8IG5hOyArK2kpIHhbaV0gPSB2YWx1ZShhW2ldLCBiW2ldKTtcbiAgZm9yICg7IGkgPCBuYjsgKytpKSBjW2ldID0gYltpXTtcblxuICByZXR1cm4gZnVuY3Rpb24odCkge1xuICAgIGZvciAoaSA9IDA7IGkgPCBuYTsgKytpKSBjW2ldID0geFtpXSh0KTtcbiAgICByZXR1cm4gYztcbiAgfTtcbn1cbiJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTsiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-interpolate/src/array.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-interpolate/src/basis.js":
/*!*************************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-interpolate/src/basis.js ***!
  \*************************************************************************/
/*! exports provided: basis, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"basis\", function() { return basis; });\nfunction basis(t1, v0, v1, v2, v3) {\n  var t2 = t1 * t1, t3 = t2 * t1;\n  return ((1 - 3 * t1 + 3 * t2 - t3) * v0\n      + (4 - 6 * t2 + 3 * t3) * v1\n      + (1 + 3 * t1 + 3 * t2 - 3 * t3) * v2\n      + t3 * v3) / 6;\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(values) {\n  var n = values.length - 1;\n  return function(t) {\n    var i = t <= 0 ? (t = 0) : t >= 1 ? (t = 1, n - 1) : Math.floor(t * n),\n        v1 = values[i],\n        v2 = values[i + 1],\n        v0 = i > 0 ? values[i - 1] : 2 * v1 - v2,\n        v3 = i < n - 1 ? values[i + 2] : 2 * v2 - v1;\n    return basis((t - i / n) * n, v0, v1, v2, v3);\n  };\n});\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1pbnRlcnBvbGF0ZS9zcmMvYmFzaXMuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1pbnRlcnBvbGF0ZS9zcmMvYmFzaXMuanM/ZWRiNCJdLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgZnVuY3Rpb24gYmFzaXModDEsIHYwLCB2MSwgdjIsIHYzKSB7XG4gIHZhciB0MiA9IHQxICogdDEsIHQzID0gdDIgKiB0MTtcbiAgcmV0dXJuICgoMSAtIDMgKiB0MSArIDMgKiB0MiAtIHQzKSAqIHYwXG4gICAgICArICg0IC0gNiAqIHQyICsgMyAqIHQzKSAqIHYxXG4gICAgICArICgxICsgMyAqIHQxICsgMyAqIHQyIC0gMyAqIHQzKSAqIHYyXG4gICAgICArIHQzICogdjMpIC8gNjtcbn1cblxuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24odmFsdWVzKSB7XG4gIHZhciBuID0gdmFsdWVzLmxlbmd0aCAtIDE7XG4gIHJldHVybiBmdW5jdGlvbih0KSB7XG4gICAgdmFyIGkgPSB0IDw9IDAgPyAodCA9IDApIDogdCA+PSAxID8gKHQgPSAxLCBuIC0gMSkgOiBNYXRoLmZsb29yKHQgKiBuKSxcbiAgICAgICAgdjEgPSB2YWx1ZXNbaV0sXG4gICAgICAgIHYyID0gdmFsdWVzW2kgKyAxXSxcbiAgICAgICAgdjAgPSBpID4gMCA/IHZhbHVlc1tpIC0gMV0gOiAyICogdjEgLSB2MixcbiAgICAgICAgdjMgPSBpIDwgbiAtIDEgPyB2YWx1ZXNbaSArIDJdIDogMiAqIHYyIC0gdjE7XG4gICAgcmV0dXJuIGJhc2lzKCh0IC0gaSAvIG4pICogbiwgdjAsIHYxLCB2MiwgdjMpO1xuICB9O1xufVxuIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Iiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-interpolate/src/basis.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-interpolate/src/basisClosed.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-interpolate/src/basisClosed.js ***!
  \*******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _basis_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./basis.js */ \"./node_modules/encodable/node_modules/d3-interpolate/src/basis.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(values) {\n  var n = values.length;\n  return function(t) {\n    var i = Math.floor(((t %= 1) < 0 ? ++t : t) * n),\n        v0 = values[(i + n - 1) % n],\n        v1 = values[i % n],\n        v2 = values[(i + 1) % n],\n        v3 = values[(i + 2) % n];\n    return Object(_basis_js__WEBPACK_IMPORTED_MODULE_0__[\"basis\"])((t - i / n) * n, v0, v1, v2, v3);\n  };\n});\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1pbnRlcnBvbGF0ZS9zcmMvYmFzaXNDbG9zZWQuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1pbnRlcnBvbGF0ZS9zcmMvYmFzaXNDbG9zZWQuanM/MDU4MyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge2Jhc2lzfSBmcm9tIFwiLi9iYXNpcy5qc1wiO1xuXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbih2YWx1ZXMpIHtcbiAgdmFyIG4gPSB2YWx1ZXMubGVuZ3RoO1xuICByZXR1cm4gZnVuY3Rpb24odCkge1xuICAgIHZhciBpID0gTWF0aC5mbG9vcigoKHQgJT0gMSkgPCAwID8gKyt0IDogdCkgKiBuKSxcbiAgICAgICAgdjAgPSB2YWx1ZXNbKGkgKyBuIC0gMSkgJSBuXSxcbiAgICAgICAgdjEgPSB2YWx1ZXNbaSAlIG5dLFxuICAgICAgICB2MiA9IHZhbHVlc1soaSArIDEpICUgbl0sXG4gICAgICAgIHYzID0gdmFsdWVzWyhpICsgMikgJSBuXTtcbiAgICByZXR1cm4gYmFzaXMoKHQgLSBpIC8gbikgKiBuLCB2MCwgdjEsIHYyLCB2Myk7XG4gIH07XG59XG4iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTsiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-interpolate/src/basisClosed.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-interpolate/src/color.js":
/*!*************************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-interpolate/src/color.js ***!
  \*************************************************************************/
/*! exports provided: hue, gamma, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"hue\", function() { return hue; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"gamma\", function() { return gamma; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return nogamma; });\n/* harmony import */ var _constant_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constant.js */ \"./node_modules/encodable/node_modules/d3-interpolate/src/constant.js\");\n\n\nfunction linear(a, d) {\n  return function(t) {\n    return a + t * d;\n  };\n}\n\nfunction exponential(a, b, y) {\n  return a = Math.pow(a, y), b = Math.pow(b, y) - a, y = 1 / y, function(t) {\n    return Math.pow(a + t * b, y);\n  };\n}\n\nfunction hue(a, b) {\n  var d = b - a;\n  return d ? linear(a, d > 180 || d < -180 ? d - 360 * Math.round(d / 360) : d) : Object(_constant_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(isNaN(a) ? b : a);\n}\n\nfunction gamma(y) {\n  return (y = +y) === 1 ? nogamma : function(a, b) {\n    return b - a ? exponential(a, b, y) : Object(_constant_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(isNaN(a) ? b : a);\n  };\n}\n\nfunction nogamma(a, b) {\n  var d = b - a;\n  return d ? linear(a, d) : Object(_constant_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(isNaN(a) ? b : a);\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1pbnRlcnBvbGF0ZS9zcmMvY29sb3IuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1pbnRlcnBvbGF0ZS9zcmMvY29sb3IuanM/NGMxYiJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgY29uc3RhbnQgZnJvbSBcIi4vY29uc3RhbnQuanNcIjtcblxuZnVuY3Rpb24gbGluZWFyKGEsIGQpIHtcbiAgcmV0dXJuIGZ1bmN0aW9uKHQpIHtcbiAgICByZXR1cm4gYSArIHQgKiBkO1xuICB9O1xufVxuXG5mdW5jdGlvbiBleHBvbmVudGlhbChhLCBiLCB5KSB7XG4gIHJldHVybiBhID0gTWF0aC5wb3coYSwgeSksIGIgPSBNYXRoLnBvdyhiLCB5KSAtIGEsIHkgPSAxIC8geSwgZnVuY3Rpb24odCkge1xuICAgIHJldHVybiBNYXRoLnBvdyhhICsgdCAqIGIsIHkpO1xuICB9O1xufVxuXG5leHBvcnQgZnVuY3Rpb24gaHVlKGEsIGIpIHtcbiAgdmFyIGQgPSBiIC0gYTtcbiAgcmV0dXJuIGQgPyBsaW5lYXIoYSwgZCA+IDE4MCB8fCBkIDwgLTE4MCA/IGQgLSAzNjAgKiBNYXRoLnJvdW5kKGQgLyAzNjApIDogZCkgOiBjb25zdGFudChpc05hTihhKSA/IGIgOiBhKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGdhbW1hKHkpIHtcbiAgcmV0dXJuICh5ID0gK3kpID09PSAxID8gbm9nYW1tYSA6IGZ1bmN0aW9uKGEsIGIpIHtcbiAgICByZXR1cm4gYiAtIGEgPyBleHBvbmVudGlhbChhLCBiLCB5KSA6IGNvbnN0YW50KGlzTmFOKGEpID8gYiA6IGEpO1xuICB9O1xufVxuXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiBub2dhbW1hKGEsIGIpIHtcbiAgdmFyIGQgPSBiIC0gYTtcbiAgcmV0dXJuIGQgPyBsaW5lYXIoYSwgZCkgOiBjb25zdGFudChpc05hTihhKSA/IGIgOiBhKTtcbn1cbiJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Iiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-interpolate/src/color.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-interpolate/src/constant.js":
/*!****************************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-interpolate/src/constant.js ***!
  \****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (x => () => x);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1pbnRlcnBvbGF0ZS9zcmMvY29uc3RhbnQuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1pbnRlcnBvbGF0ZS9zcmMvY29uc3RhbnQuanM/YTYyYyJdLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgZGVmYXVsdCB4ID0+ICgpID0+IHg7XG4iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7Iiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-interpolate/src/constant.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-interpolate/src/cubehelix.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-interpolate/src/cubehelix.js ***!
  \*****************************************************************************/
/*! exports provided: default, cubehelixLong */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"cubehelixLong\", function() { return cubehelixLong; });\n/* harmony import */ var d3_color__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-color */ \"./node_modules/d3-color/src/cubehelix.js\");\n/* harmony import */ var _color_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./color.js */ \"./node_modules/encodable/node_modules/d3-interpolate/src/color.js\");\n\n\n\nfunction cubehelix(hue) {\n  return (function cubehelixGamma(y) {\n    y = +y;\n\n    function cubehelix(start, end) {\n      var h = hue((start = Object(d3_color__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(start)).h, (end = Object(d3_color__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(end)).h),\n          s = Object(_color_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(start.s, end.s),\n          l = Object(_color_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(start.l, end.l),\n          opacity = Object(_color_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(start.opacity, end.opacity);\n      return function(t) {\n        start.h = h(t);\n        start.s = s(t);\n        start.l = l(Math.pow(t, y));\n        start.opacity = opacity(t);\n        return start + \"\";\n      };\n    }\n\n    cubehelix.gamma = cubehelixGamma;\n\n    return cubehelix;\n  })(1);\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (cubehelix(_color_js__WEBPACK_IMPORTED_MODULE_1__[\"hue\"]));\nvar cubehelixLong = cubehelix(_color_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"]);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1pbnRlcnBvbGF0ZS9zcmMvY3ViZWhlbGl4LmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9ub2RlX21vZHVsZXMvZDMtaW50ZXJwb2xhdGUvc3JjL2N1YmVoZWxpeC5qcz82ZTgxIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7Y3ViZWhlbGl4IGFzIGNvbG9yQ3ViZWhlbGl4fSBmcm9tIFwiZDMtY29sb3JcIjtcbmltcG9ydCBjb2xvciwge2h1ZX0gZnJvbSBcIi4vY29sb3IuanNcIjtcblxuZnVuY3Rpb24gY3ViZWhlbGl4KGh1ZSkge1xuICByZXR1cm4gKGZ1bmN0aW9uIGN1YmVoZWxpeEdhbW1hKHkpIHtcbiAgICB5ID0gK3k7XG5cbiAgICBmdW5jdGlvbiBjdWJlaGVsaXgoc3RhcnQsIGVuZCkge1xuICAgICAgdmFyIGggPSBodWUoKHN0YXJ0ID0gY29sb3JDdWJlaGVsaXgoc3RhcnQpKS5oLCAoZW5kID0gY29sb3JDdWJlaGVsaXgoZW5kKSkuaCksXG4gICAgICAgICAgcyA9IGNvbG9yKHN0YXJ0LnMsIGVuZC5zKSxcbiAgICAgICAgICBsID0gY29sb3Ioc3RhcnQubCwgZW5kLmwpLFxuICAgICAgICAgIG9wYWNpdHkgPSBjb2xvcihzdGFydC5vcGFjaXR5LCBlbmQub3BhY2l0eSk7XG4gICAgICByZXR1cm4gZnVuY3Rpb24odCkge1xuICAgICAgICBzdGFydC5oID0gaCh0KTtcbiAgICAgICAgc3RhcnQucyA9IHModCk7XG4gICAgICAgIHN0YXJ0LmwgPSBsKE1hdGgucG93KHQsIHkpKTtcbiAgICAgICAgc3RhcnQub3BhY2l0eSA9IG9wYWNpdHkodCk7XG4gICAgICAgIHJldHVybiBzdGFydCArIFwiXCI7XG4gICAgICB9O1xuICAgIH1cblxuICAgIGN1YmVoZWxpeC5nYW1tYSA9IGN1YmVoZWxpeEdhbW1hO1xuXG4gICAgcmV0dXJuIGN1YmVoZWxpeDtcbiAgfSkoMSk7XG59XG5cbmV4cG9ydCBkZWZhdWx0IGN1YmVoZWxpeChodWUpO1xuZXhwb3J0IHZhciBjdWJlaGVsaXhMb25nID0gY3ViZWhlbGl4KGNvbG9yKTtcbiJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOyIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-interpolate/src/cubehelix.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-interpolate/src/date.js":
/*!************************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-interpolate/src/date.js ***!
  \************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(a, b) {\n  var d = new Date;\n  return a = +a, b = +b, function(t) {\n    return d.setTime(a * (1 - t) + b * t), d;\n  };\n});\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1pbnRlcnBvbGF0ZS9zcmMvZGF0ZS5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9lbmNvZGFibGUvbm9kZV9tb2R1bGVzL2QzLWludGVycG9sYXRlL3NyYy9kYXRlLmpzPzRkYzciXSwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24oYSwgYikge1xuICB2YXIgZCA9IG5ldyBEYXRlO1xuICByZXR1cm4gYSA9ICthLCBiID0gK2IsIGZ1bmN0aW9uKHQpIHtcbiAgICByZXR1cm4gZC5zZXRUaW1lKGEgKiAoMSAtIHQpICsgYiAqIHQpLCBkO1xuICB9O1xufVxuIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTsiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-interpolate/src/date.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-interpolate/src/hcl.js":
/*!***********************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-interpolate/src/hcl.js ***!
  \***********************************************************************/
/*! exports provided: default, hclLong */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"hclLong\", function() { return hclLong; });\n/* harmony import */ var d3_color__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-color */ \"./node_modules/d3-color/src/lab.js\");\n/* harmony import */ var _color_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./color.js */ \"./node_modules/encodable/node_modules/d3-interpolate/src/color.js\");\n\n\n\nfunction hcl(hue) {\n  return function(start, end) {\n    var h = hue((start = Object(d3_color__WEBPACK_IMPORTED_MODULE_0__[\"hcl\"])(start)).h, (end = Object(d3_color__WEBPACK_IMPORTED_MODULE_0__[\"hcl\"])(end)).h),\n        c = Object(_color_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(start.c, end.c),\n        l = Object(_color_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(start.l, end.l),\n        opacity = Object(_color_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(start.opacity, end.opacity);\n    return function(t) {\n      start.h = h(t);\n      start.c = c(t);\n      start.l = l(t);\n      start.opacity = opacity(t);\n      return start + \"\";\n    };\n  }\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (hcl(_color_js__WEBPACK_IMPORTED_MODULE_1__[\"hue\"]));\nvar hclLong = hcl(_color_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"]);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1pbnRlcnBvbGF0ZS9zcmMvaGNsLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9ub2RlX21vZHVsZXMvZDMtaW50ZXJwb2xhdGUvc3JjL2hjbC5qcz8zNWMxIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7aGNsIGFzIGNvbG9ySGNsfSBmcm9tIFwiZDMtY29sb3JcIjtcbmltcG9ydCBjb2xvciwge2h1ZX0gZnJvbSBcIi4vY29sb3IuanNcIjtcblxuZnVuY3Rpb24gaGNsKGh1ZSkge1xuICByZXR1cm4gZnVuY3Rpb24oc3RhcnQsIGVuZCkge1xuICAgIHZhciBoID0gaHVlKChzdGFydCA9IGNvbG9ySGNsKHN0YXJ0KSkuaCwgKGVuZCA9IGNvbG9ySGNsKGVuZCkpLmgpLFxuICAgICAgICBjID0gY29sb3Ioc3RhcnQuYywgZW5kLmMpLFxuICAgICAgICBsID0gY29sb3Ioc3RhcnQubCwgZW5kLmwpLFxuICAgICAgICBvcGFjaXR5ID0gY29sb3Ioc3RhcnQub3BhY2l0eSwgZW5kLm9wYWNpdHkpO1xuICAgIHJldHVybiBmdW5jdGlvbih0KSB7XG4gICAgICBzdGFydC5oID0gaCh0KTtcbiAgICAgIHN0YXJ0LmMgPSBjKHQpO1xuICAgICAgc3RhcnQubCA9IGwodCk7XG4gICAgICBzdGFydC5vcGFjaXR5ID0gb3BhY2l0eSh0KTtcbiAgICAgIHJldHVybiBzdGFydCArIFwiXCI7XG4gICAgfTtcbiAgfVxufVxuXG5leHBvcnQgZGVmYXVsdCBoY2woaHVlKTtcbmV4cG9ydCB2YXIgaGNsTG9uZyA9IGhjbChjb2xvcik7XG4iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOyIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-interpolate/src/hcl.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-interpolate/src/hsl.js":
/*!***********************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-interpolate/src/hsl.js ***!
  \***********************************************************************/
/*! exports provided: default, hslLong */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"hslLong\", function() { return hslLong; });\n/* harmony import */ var d3_color__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-color */ \"./node_modules/d3-color/src/color.js\");\n/* harmony import */ var _color_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./color.js */ \"./node_modules/encodable/node_modules/d3-interpolate/src/color.js\");\n\n\n\nfunction hsl(hue) {\n  return function(start, end) {\n    var h = hue((start = Object(d3_color__WEBPACK_IMPORTED_MODULE_0__[\"hsl\"])(start)).h, (end = Object(d3_color__WEBPACK_IMPORTED_MODULE_0__[\"hsl\"])(end)).h),\n        s = Object(_color_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(start.s, end.s),\n        l = Object(_color_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(start.l, end.l),\n        opacity = Object(_color_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(start.opacity, end.opacity);\n    return function(t) {\n      start.h = h(t);\n      start.s = s(t);\n      start.l = l(t);\n      start.opacity = opacity(t);\n      return start + \"\";\n    };\n  }\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (hsl(_color_js__WEBPACK_IMPORTED_MODULE_1__[\"hue\"]));\nvar hslLong = hsl(_color_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"]);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1pbnRlcnBvbGF0ZS9zcmMvaHNsLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9ub2RlX21vZHVsZXMvZDMtaW50ZXJwb2xhdGUvc3JjL2hzbC5qcz9lNTNmIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7aHNsIGFzIGNvbG9ySHNsfSBmcm9tIFwiZDMtY29sb3JcIjtcbmltcG9ydCBjb2xvciwge2h1ZX0gZnJvbSBcIi4vY29sb3IuanNcIjtcblxuZnVuY3Rpb24gaHNsKGh1ZSkge1xuICByZXR1cm4gZnVuY3Rpb24oc3RhcnQsIGVuZCkge1xuICAgIHZhciBoID0gaHVlKChzdGFydCA9IGNvbG9ySHNsKHN0YXJ0KSkuaCwgKGVuZCA9IGNvbG9ySHNsKGVuZCkpLmgpLFxuICAgICAgICBzID0gY29sb3Ioc3RhcnQucywgZW5kLnMpLFxuICAgICAgICBsID0gY29sb3Ioc3RhcnQubCwgZW5kLmwpLFxuICAgICAgICBvcGFjaXR5ID0gY29sb3Ioc3RhcnQub3BhY2l0eSwgZW5kLm9wYWNpdHkpO1xuICAgIHJldHVybiBmdW5jdGlvbih0KSB7XG4gICAgICBzdGFydC5oID0gaCh0KTtcbiAgICAgIHN0YXJ0LnMgPSBzKHQpO1xuICAgICAgc3RhcnQubCA9IGwodCk7XG4gICAgICBzdGFydC5vcGFjaXR5ID0gb3BhY2l0eSh0KTtcbiAgICAgIHJldHVybiBzdGFydCArIFwiXCI7XG4gICAgfTtcbiAgfVxufVxuXG5leHBvcnQgZGVmYXVsdCBoc2woaHVlKTtcbmV4cG9ydCB2YXIgaHNsTG9uZyA9IGhzbChjb2xvcik7XG4iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOyIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-interpolate/src/hsl.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-interpolate/src/lab.js":
/*!***********************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-interpolate/src/lab.js ***!
  \***********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return lab; });\n/* harmony import */ var d3_color__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-color */ \"./node_modules/d3-color/src/lab.js\");\n/* harmony import */ var _color_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./color.js */ \"./node_modules/encodable/node_modules/d3-interpolate/src/color.js\");\n\n\n\nfunction lab(start, end) {\n  var l = Object(_color_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])((start = Object(d3_color__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(start)).l, (end = Object(d3_color__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(end)).l),\n      a = Object(_color_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(start.a, end.a),\n      b = Object(_color_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(start.b, end.b),\n      opacity = Object(_color_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(start.opacity, end.opacity);\n  return function(t) {\n    start.l = l(t);\n    start.a = a(t);\n    start.b = b(t);\n    start.opacity = opacity(t);\n    return start + \"\";\n  };\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1pbnRlcnBvbGF0ZS9zcmMvbGFiLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9ub2RlX21vZHVsZXMvZDMtaW50ZXJwb2xhdGUvc3JjL2xhYi5qcz85MTU1Il0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7bGFiIGFzIGNvbG9yTGFifSBmcm9tIFwiZDMtY29sb3JcIjtcbmltcG9ydCBjb2xvciBmcm9tIFwiLi9jb2xvci5qc1wiO1xuXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiBsYWIoc3RhcnQsIGVuZCkge1xuICB2YXIgbCA9IGNvbG9yKChzdGFydCA9IGNvbG9yTGFiKHN0YXJ0KSkubCwgKGVuZCA9IGNvbG9yTGFiKGVuZCkpLmwpLFxuICAgICAgYSA9IGNvbG9yKHN0YXJ0LmEsIGVuZC5hKSxcbiAgICAgIGIgPSBjb2xvcihzdGFydC5iLCBlbmQuYiksXG4gICAgICBvcGFjaXR5ID0gY29sb3Ioc3RhcnQub3BhY2l0eSwgZW5kLm9wYWNpdHkpO1xuICByZXR1cm4gZnVuY3Rpb24odCkge1xuICAgIHN0YXJ0LmwgPSBsKHQpO1xuICAgIHN0YXJ0LmEgPSBhKHQpO1xuICAgIHN0YXJ0LmIgPSBiKHQpO1xuICAgIHN0YXJ0Lm9wYWNpdHkgPSBvcGFjaXR5KHQpO1xuICAgIHJldHVybiBzdGFydCArIFwiXCI7XG4gIH07XG59XG4iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Iiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-interpolate/src/lab.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-interpolate/src/number.js":
/*!**************************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-interpolate/src/number.js ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(a, b) {\n  return a = +a, b = +b, function(t) {\n    return a * (1 - t) + b * t;\n  };\n});\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1pbnRlcnBvbGF0ZS9zcmMvbnVtYmVyLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9ub2RlX21vZHVsZXMvZDMtaW50ZXJwb2xhdGUvc3JjL251bWJlci5qcz82OWE2Il0sInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uKGEsIGIpIHtcbiAgcmV0dXJuIGEgPSArYSwgYiA9ICtiLCBmdW5jdGlvbih0KSB7XG4gICAgcmV0dXJuIGEgKiAoMSAtIHQpICsgYiAqIHQ7XG4gIH07XG59XG4iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTsiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-interpolate/src/number.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-interpolate/src/numberArray.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-interpolate/src/numberArray.js ***!
  \*******************************************************************************/
/*! exports provided: default, isNumberArray */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isNumberArray\", function() { return isNumberArray; });\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(a, b) {\n  if (!b) b = [];\n  var n = a ? Math.min(b.length, a.length) : 0,\n      c = b.slice(),\n      i;\n  return function(t) {\n    for (i = 0; i < n; ++i) c[i] = a[i] * (1 - t) + b[i] * t;\n    return c;\n  };\n});\n\nfunction isNumberArray(x) {\n  return ArrayBuffer.isView(x) && !(x instanceof DataView);\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1pbnRlcnBvbGF0ZS9zcmMvbnVtYmVyQXJyYXkuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1pbnRlcnBvbGF0ZS9zcmMvbnVtYmVyQXJyYXkuanM/MmM2MiJdLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgZGVmYXVsdCBmdW5jdGlvbihhLCBiKSB7XG4gIGlmICghYikgYiA9IFtdO1xuICB2YXIgbiA9IGEgPyBNYXRoLm1pbihiLmxlbmd0aCwgYS5sZW5ndGgpIDogMCxcbiAgICAgIGMgPSBiLnNsaWNlKCksXG4gICAgICBpO1xuICByZXR1cm4gZnVuY3Rpb24odCkge1xuICAgIGZvciAoaSA9IDA7IGkgPCBuOyArK2kpIGNbaV0gPSBhW2ldICogKDEgLSB0KSArIGJbaV0gKiB0O1xuICAgIHJldHVybiBjO1xuICB9O1xufVxuXG5leHBvcnQgZnVuY3Rpb24gaXNOdW1iZXJBcnJheSh4KSB7XG4gIHJldHVybiBBcnJheUJ1ZmZlci5pc1ZpZXcoeCkgJiYgISh4IGluc3RhbmNlb2YgRGF0YVZpZXcpO1xufVxuIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTsiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-interpolate/src/numberArray.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-interpolate/src/object.js":
/*!**************************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-interpolate/src/object.js ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _value_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./value.js */ \"./node_modules/encodable/node_modules/d3-interpolate/src/value.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(a, b) {\n  var i = {},\n      c = {},\n      k;\n\n  if (a === null || typeof a !== \"object\") a = {};\n  if (b === null || typeof b !== \"object\") b = {};\n\n  for (k in b) {\n    if (k in a) {\n      i[k] = Object(_value_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(a[k], b[k]);\n    } else {\n      c[k] = b[k];\n    }\n  }\n\n  return function(t) {\n    for (k in i) c[k] = i[k](t);\n    return c;\n  };\n});\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1pbnRlcnBvbGF0ZS9zcmMvb2JqZWN0LmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9ub2RlX21vZHVsZXMvZDMtaW50ZXJwb2xhdGUvc3JjL29iamVjdC5qcz8wOGYzIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB2YWx1ZSBmcm9tIFwiLi92YWx1ZS5qc1wiO1xuXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbihhLCBiKSB7XG4gIHZhciBpID0ge30sXG4gICAgICBjID0ge30sXG4gICAgICBrO1xuXG4gIGlmIChhID09PSBudWxsIHx8IHR5cGVvZiBhICE9PSBcIm9iamVjdFwiKSBhID0ge307XG4gIGlmIChiID09PSBudWxsIHx8IHR5cGVvZiBiICE9PSBcIm9iamVjdFwiKSBiID0ge307XG5cbiAgZm9yIChrIGluIGIpIHtcbiAgICBpZiAoayBpbiBhKSB7XG4gICAgICBpW2tdID0gdmFsdWUoYVtrXSwgYltrXSk7XG4gICAgfSBlbHNlIHtcbiAgICAgIGNba10gPSBiW2tdO1xuICAgIH1cbiAgfVxuXG4gIHJldHVybiBmdW5jdGlvbih0KSB7XG4gICAgZm9yIChrIGluIGkpIGNba10gPSBpW2tdKHQpO1xuICAgIHJldHVybiBjO1xuICB9O1xufVxuIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTsiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-interpolate/src/object.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-interpolate/src/rgb.js":
/*!***********************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-interpolate/src/rgb.js ***!
  \***********************************************************************/
/*! exports provided: default, rgbBasis, rgbBasisClosed */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"rgbBasis\", function() { return rgbBasis; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"rgbBasisClosed\", function() { return rgbBasisClosed; });\n/* harmony import */ var d3_color__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-color */ \"./node_modules/d3-color/src/color.js\");\n/* harmony import */ var _basis_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./basis.js */ \"./node_modules/encodable/node_modules/d3-interpolate/src/basis.js\");\n/* harmony import */ var _basisClosed_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./basisClosed.js */ \"./node_modules/encodable/node_modules/d3-interpolate/src/basisClosed.js\");\n/* harmony import */ var _color_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./color.js */ \"./node_modules/encodable/node_modules/d3-interpolate/src/color.js\");\n\n\n\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ((function rgbGamma(y) {\n  var color = Object(_color_js__WEBPACK_IMPORTED_MODULE_3__[\"gamma\"])(y);\n\n  function rgb(start, end) {\n    var r = color((start = Object(d3_color__WEBPACK_IMPORTED_MODULE_0__[\"rgb\"])(start)).r, (end = Object(d3_color__WEBPACK_IMPORTED_MODULE_0__[\"rgb\"])(end)).r),\n        g = color(start.g, end.g),\n        b = color(start.b, end.b),\n        opacity = Object(_color_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(start.opacity, end.opacity);\n    return function(t) {\n      start.r = r(t);\n      start.g = g(t);\n      start.b = b(t);\n      start.opacity = opacity(t);\n      return start + \"\";\n    };\n  }\n\n  rgb.gamma = rgbGamma;\n\n  return rgb;\n})(1));\n\nfunction rgbSpline(spline) {\n  return function(colors) {\n    var n = colors.length,\n        r = new Array(n),\n        g = new Array(n),\n        b = new Array(n),\n        i, color;\n    for (i = 0; i < n; ++i) {\n      color = Object(d3_color__WEBPACK_IMPORTED_MODULE_0__[\"rgb\"])(colors[i]);\n      r[i] = color.r || 0;\n      g[i] = color.g || 0;\n      b[i] = color.b || 0;\n    }\n    r = spline(r);\n    g = spline(g);\n    b = spline(b);\n    color.opacity = 1;\n    return function(t) {\n      color.r = r(t);\n      color.g = g(t);\n      color.b = b(t);\n      return color + \"\";\n    };\n  };\n}\n\nvar rgbBasis = rgbSpline(_basis_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"]);\nvar rgbBasisClosed = rgbSpline(_basisClosed_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"]);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-interpolate/src/rgb.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-interpolate/src/round.js":
/*!*************************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-interpolate/src/round.js ***!
  \*************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(a, b) {\n  return a = +a, b = +b, function(t) {\n    return Math.round(a * (1 - t) + b * t);\n  };\n});\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1pbnRlcnBvbGF0ZS9zcmMvcm91bmQuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1pbnRlcnBvbGF0ZS9zcmMvcm91bmQuanM/YTExNiJdLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgZGVmYXVsdCBmdW5jdGlvbihhLCBiKSB7XG4gIHJldHVybiBhID0gK2EsIGIgPSArYiwgZnVuY3Rpb24odCkge1xuICAgIHJldHVybiBNYXRoLnJvdW5kKGEgKiAoMSAtIHQpICsgYiAqIHQpO1xuICB9O1xufVxuIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Iiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-interpolate/src/round.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-interpolate/src/string.js":
/*!**************************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-interpolate/src/string.js ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _number_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./number.js */ \"./node_modules/encodable/node_modules/d3-interpolate/src/number.js\");\n\n\nvar reA = /[-+]?(?:\\d+\\.?\\d*|\\.?\\d+)(?:[eE][-+]?\\d+)?/g,\n    reB = new RegExp(reA.source, \"g\");\n\nfunction zero(b) {\n  return function() {\n    return b;\n  };\n}\n\nfunction one(b) {\n  return function(t) {\n    return b(t) + \"\";\n  };\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(a, b) {\n  var bi = reA.lastIndex = reB.lastIndex = 0, // scan index for next number in b\n      am, // current match in a\n      bm, // current match in b\n      bs, // string preceding current number in b, if any\n      i = -1, // index in s\n      s = [], // string constants and placeholders\n      q = []; // number interpolators\n\n  // Coerce inputs to strings.\n  a = a + \"\", b = b + \"\";\n\n  // Interpolate pairs of numbers in a & b.\n  while ((am = reA.exec(a))\n      && (bm = reB.exec(b))) {\n    if ((bs = bm.index) > bi) { // a string precedes the next number in b\n      bs = b.slice(bi, bs);\n      if (s[i]) s[i] += bs; // coalesce with previous string\n      else s[++i] = bs;\n    }\n    if ((am = am[0]) === (bm = bm[0])) { // numbers in a & b match\n      if (s[i]) s[i] += bm; // coalesce with previous string\n      else s[++i] = bm;\n    } else { // interpolate non-matching numbers\n      s[++i] = null;\n      q.push({i: i, x: Object(_number_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(am, bm)});\n    }\n    bi = reB.lastIndex;\n  }\n\n  // Add remains of b.\n  if (bi < b.length) {\n    bs = b.slice(bi);\n    if (s[i]) s[i] += bs; // coalesce with previous string\n    else s[++i] = bs;\n  }\n\n  // Special optimization for only a single match.\n  // Otherwise, interpolate each of the numbers and rejoin the string.\n  return s.length < 2 ? (q[0]\n      ? one(q[0].x)\n      : zero(b))\n      : (b = q.length, function(t) {\n          for (var i = 0, o; i < b; ++i) s[(o = q[i]).i] = o.x(t);\n          return s.join(\"\");\n        });\n});\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-interpolate/src/string.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-interpolate/src/value.js":
/*!*************************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-interpolate/src/value.js ***!
  \*************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var d3_color__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-color */ \"./node_modules/d3-color/src/color.js\");\n/* harmony import */ var _rgb_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./rgb.js */ \"./node_modules/encodable/node_modules/d3-interpolate/src/rgb.js\");\n/* harmony import */ var _array_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./array.js */ \"./node_modules/encodable/node_modules/d3-interpolate/src/array.js\");\n/* harmony import */ var _date_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./date.js */ \"./node_modules/encodable/node_modules/d3-interpolate/src/date.js\");\n/* harmony import */ var _number_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./number.js */ \"./node_modules/encodable/node_modules/d3-interpolate/src/number.js\");\n/* harmony import */ var _object_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./object.js */ \"./node_modules/encodable/node_modules/d3-interpolate/src/object.js\");\n/* harmony import */ var _string_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./string.js */ \"./node_modules/encodable/node_modules/d3-interpolate/src/string.js\");\n/* harmony import */ var _constant_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./constant.js */ \"./node_modules/encodable/node_modules/d3-interpolate/src/constant.js\");\n/* harmony import */ var _numberArray_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./numberArray.js */ \"./node_modules/encodable/node_modules/d3-interpolate/src/numberArray.js\");\n\n\n\n\n\n\n\n\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(a, b) {\n  var t = typeof b, c;\n  return b == null || t === \"boolean\" ? Object(_constant_js__WEBPACK_IMPORTED_MODULE_7__[\"default\"])(b)\n      : (t === \"number\" ? _number_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"]\n      : t === \"string\" ? ((c = Object(d3_color__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(b)) ? (b = c, _rgb_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"]) : _string_js__WEBPACK_IMPORTED_MODULE_6__[\"default\"])\n      : b instanceof d3_color__WEBPACK_IMPORTED_MODULE_0__[\"default\"] ? _rgb_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"]\n      : b instanceof Date ? _date_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"]\n      : Object(_numberArray_js__WEBPACK_IMPORTED_MODULE_8__[\"isNumberArray\"])(b) ? _numberArray_js__WEBPACK_IMPORTED_MODULE_8__[\"default\"]\n      : Array.isArray(b) ? _array_js__WEBPACK_IMPORTED_MODULE_2__[\"genericArray\"]\n      : typeof b.valueOf !== \"function\" && typeof b.toString !== \"function\" || isNaN(b) ? _object_js__WEBPACK_IMPORTED_MODULE_5__[\"default\"]\n      : _number_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"])(a, b);\n});\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1pbnRlcnBvbGF0ZS9zcmMvdmFsdWUuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1pbnRlcnBvbGF0ZS9zcmMvdmFsdWUuanM/NmU3NSJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge2NvbG9yfSBmcm9tIFwiZDMtY29sb3JcIjtcbmltcG9ydCByZ2IgZnJvbSBcIi4vcmdiLmpzXCI7XG5pbXBvcnQge2dlbmVyaWNBcnJheX0gZnJvbSBcIi4vYXJyYXkuanNcIjtcbmltcG9ydCBkYXRlIGZyb20gXCIuL2RhdGUuanNcIjtcbmltcG9ydCBudW1iZXIgZnJvbSBcIi4vbnVtYmVyLmpzXCI7XG5pbXBvcnQgb2JqZWN0IGZyb20gXCIuL29iamVjdC5qc1wiO1xuaW1wb3J0IHN0cmluZyBmcm9tIFwiLi9zdHJpbmcuanNcIjtcbmltcG9ydCBjb25zdGFudCBmcm9tIFwiLi9jb25zdGFudC5qc1wiO1xuaW1wb3J0IG51bWJlckFycmF5LCB7aXNOdW1iZXJBcnJheX0gZnJvbSBcIi4vbnVtYmVyQXJyYXkuanNcIjtcblxuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24oYSwgYikge1xuICB2YXIgdCA9IHR5cGVvZiBiLCBjO1xuICByZXR1cm4gYiA9PSBudWxsIHx8IHQgPT09IFwiYm9vbGVhblwiID8gY29uc3RhbnQoYilcbiAgICAgIDogKHQgPT09IFwibnVtYmVyXCIgPyBudW1iZXJcbiAgICAgIDogdCA9PT0gXCJzdHJpbmdcIiA/ICgoYyA9IGNvbG9yKGIpKSA/IChiID0gYywgcmdiKSA6IHN0cmluZylcbiAgICAgIDogYiBpbnN0YW5jZW9mIGNvbG9yID8gcmdiXG4gICAgICA6IGIgaW5zdGFuY2VvZiBEYXRlID8gZGF0ZVxuICAgICAgOiBpc051bWJlckFycmF5KGIpID8gbnVtYmVyQXJyYXlcbiAgICAgIDogQXJyYXkuaXNBcnJheShiKSA/IGdlbmVyaWNBcnJheVxuICAgICAgOiB0eXBlb2YgYi52YWx1ZU9mICE9PSBcImZ1bmN0aW9uXCIgJiYgdHlwZW9mIGIudG9TdHJpbmcgIT09IFwiZnVuY3Rpb25cIiB8fCBpc05hTihiKSA/IG9iamVjdFxuICAgICAgOiBudW1iZXIpKGEsIGIpO1xufVxuIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOyIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-interpolate/src/value.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-scale/src/band.js":
/*!******************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-scale/src/band.js ***!
  \******************************************************************/
/*! exports provided: default, point */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return band; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"point\", function() { return point; });\n/* harmony import */ var d3_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-array */ \"./node_modules/encodable/node_modules/d3-array/src/range.js\");\n/* harmony import */ var _init_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./init.js */ \"./node_modules/encodable/node_modules/d3-scale/src/init.js\");\n/* harmony import */ var _ordinal_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ordinal.js */ \"./node_modules/encodable/node_modules/d3-scale/src/ordinal.js\");\n\n\n\n\nfunction band() {\n  var scale = Object(_ordinal_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"])().unknown(undefined),\n      domain = scale.domain,\n      ordinalRange = scale.range,\n      r0 = 0,\n      r1 = 1,\n      step,\n      bandwidth,\n      round = false,\n      paddingInner = 0,\n      paddingOuter = 0,\n      align = 0.5;\n\n  delete scale.unknown;\n\n  function rescale() {\n    var n = domain().length,\n        reverse = r1 < r0,\n        start = reverse ? r1 : r0,\n        stop = reverse ? r0 : r1;\n    step = (stop - start) / Math.max(1, n - paddingInner + paddingOuter * 2);\n    if (round) step = Math.floor(step);\n    start += (stop - start - step * (n - paddingInner)) * align;\n    bandwidth = step * (1 - paddingInner);\n    if (round) start = Math.round(start), bandwidth = Math.round(bandwidth);\n    var values = Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(n).map(function(i) { return start + step * i; });\n    return ordinalRange(reverse ? values.reverse() : values);\n  }\n\n  scale.domain = function(_) {\n    return arguments.length ? (domain(_), rescale()) : domain();\n  };\n\n  scale.range = function(_) {\n    return arguments.length ? ([r0, r1] = _, r0 = +r0, r1 = +r1, rescale()) : [r0, r1];\n  };\n\n  scale.rangeRound = function(_) {\n    return [r0, r1] = _, r0 = +r0, r1 = +r1, round = true, rescale();\n  };\n\n  scale.bandwidth = function() {\n    return bandwidth;\n  };\n\n  scale.step = function() {\n    return step;\n  };\n\n  scale.round = function(_) {\n    return arguments.length ? (round = !!_, rescale()) : round;\n  };\n\n  scale.padding = function(_) {\n    return arguments.length ? (paddingInner = Math.min(1, paddingOuter = +_), rescale()) : paddingInner;\n  };\n\n  scale.paddingInner = function(_) {\n    return arguments.length ? (paddingInner = Math.min(1, _), rescale()) : paddingInner;\n  };\n\n  scale.paddingOuter = function(_) {\n    return arguments.length ? (paddingOuter = +_, rescale()) : paddingOuter;\n  };\n\n  scale.align = function(_) {\n    return arguments.length ? (align = Math.max(0, Math.min(1, _)), rescale()) : align;\n  };\n\n  scale.copy = function() {\n    return band(domain(), [r0, r1])\n        .round(round)\n        .paddingInner(paddingInner)\n        .paddingOuter(paddingOuter)\n        .align(align);\n  };\n\n  return _init_js__WEBPACK_IMPORTED_MODULE_1__[\"initRange\"].apply(rescale(), arguments);\n}\n\nfunction pointish(scale) {\n  var copy = scale.copy;\n\n  scale.padding = scale.paddingOuter;\n  delete scale.paddingInner;\n  delete scale.paddingOuter;\n\n  scale.copy = function() {\n    return pointish(copy());\n  };\n\n  return scale;\n}\n\nfunction point() {\n  return pointish(band.apply(null, arguments).paddingInner(1));\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-scale/src/band.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-scale/src/constant.js":
/*!**********************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-scale/src/constant.js ***!
  \**********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return constants; });\nfunction constants(x) {\n  return function() {\n    return x;\n  };\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1zY2FsZS9zcmMvY29uc3RhbnQuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1zY2FsZS9zcmMvY29uc3RhbnQuanM/MTgwMiJdLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgZGVmYXVsdCBmdW5jdGlvbiBjb25zdGFudHMoeCkge1xuICByZXR1cm4gZnVuY3Rpb24oKSB7XG4gICAgcmV0dXJuIHg7XG4gIH07XG59XG4iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOyIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-scale/src/constant.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-scale/src/continuous.js":
/*!************************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-scale/src/continuous.js ***!
  \************************************************************************/
/*! exports provided: identity, copy, transformer, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"identity\", function() { return identity; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"copy\", function() { return copy; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"transformer\", function() { return transformer; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return continuous; });\n/* harmony import */ var d3_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-array */ \"./node_modules/encodable/node_modules/d3-array/src/bisect.js\");\n/* harmony import */ var d3_interpolate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! d3-interpolate */ \"./node_modules/encodable/node_modules/d3-interpolate/src/value.js\");\n/* harmony import */ var d3_interpolate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! d3-interpolate */ \"./node_modules/encodable/node_modules/d3-interpolate/src/number.js\");\n/* harmony import */ var d3_interpolate__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! d3-interpolate */ \"./node_modules/encodable/node_modules/d3-interpolate/src/round.js\");\n/* harmony import */ var _constant_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constant.js */ \"./node_modules/encodable/node_modules/d3-scale/src/constant.js\");\n/* harmony import */ var _number_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./number.js */ \"./node_modules/encodable/node_modules/d3-scale/src/number.js\");\n\n\n\n\n\nvar unit = [0, 1];\n\nfunction identity(x) {\n  return x;\n}\n\nfunction normalize(a, b) {\n  return (b -= (a = +a))\n      ? function(x) { return (x - a) / b; }\n      : Object(_constant_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"])(isNaN(b) ? NaN : 0.5);\n}\n\nfunction clamper(a, b) {\n  var t;\n  if (a > b) t = a, a = b, b = t;\n  return function(x) { return Math.max(a, Math.min(b, x)); };\n}\n\n// normalize(a, b)(x) takes a domain value x in [a,b] and returns the corresponding parameter t in [0,1].\n// interpolate(a, b)(t) takes a parameter t in [0,1] and returns the corresponding range value x in [a,b].\nfunction bimap(domain, range, interpolate) {\n  var d0 = domain[0], d1 = domain[1], r0 = range[0], r1 = range[1];\n  if (d1 < d0) d0 = normalize(d1, d0), r0 = interpolate(r1, r0);\n  else d0 = normalize(d0, d1), r0 = interpolate(r0, r1);\n  return function(x) { return r0(d0(x)); };\n}\n\nfunction polymap(domain, range, interpolate) {\n  var j = Math.min(domain.length, range.length) - 1,\n      d = new Array(j),\n      r = new Array(j),\n      i = -1;\n\n  // Reverse descending domains.\n  if (domain[j] < domain[0]) {\n    domain = domain.slice().reverse();\n    range = range.slice().reverse();\n  }\n\n  while (++i < j) {\n    d[i] = normalize(domain[i], domain[i + 1]);\n    r[i] = interpolate(range[i], range[i + 1]);\n  }\n\n  return function(x) {\n    var i = Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(domain, x, 1, j) - 1;\n    return r[i](d[i](x));\n  };\n}\n\nfunction copy(source, target) {\n  return target\n      .domain(source.domain())\n      .range(source.range())\n      .interpolate(source.interpolate())\n      .clamp(source.clamp())\n      .unknown(source.unknown());\n}\n\nfunction transformer() {\n  var domain = unit,\n      range = unit,\n      interpolate = d3_interpolate__WEBPACK_IMPORTED_MODULE_1__[\"default\"],\n      transform,\n      untransform,\n      unknown,\n      clamp = identity,\n      piecewise,\n      output,\n      input;\n\n  function rescale() {\n    var n = Math.min(domain.length, range.length);\n    if (clamp !== identity) clamp = clamper(domain[0], domain[n - 1]);\n    piecewise = n > 2 ? polymap : bimap;\n    output = input = null;\n    return scale;\n  }\n\n  function scale(x) {\n    return isNaN(x = +x) ? unknown : (output || (output = piecewise(domain.map(transform), range, interpolate)))(transform(clamp(x)));\n  }\n\n  scale.invert = function(y) {\n    return clamp(untransform((input || (input = piecewise(range, domain.map(transform), d3_interpolate__WEBPACK_IMPORTED_MODULE_2__[\"default\"])))(y)));\n  };\n\n  scale.domain = function(_) {\n    return arguments.length ? (domain = Array.from(_, _number_js__WEBPACK_IMPORTED_MODULE_5__[\"default\"]), rescale()) : domain.slice();\n  };\n\n  scale.range = function(_) {\n    return arguments.length ? (range = Array.from(_), rescale()) : range.slice();\n  };\n\n  scale.rangeRound = function(_) {\n    return range = Array.from(_), interpolate = d3_interpolate__WEBPACK_IMPORTED_MODULE_3__[\"default\"], rescale();\n  };\n\n  scale.clamp = function(_) {\n    return arguments.length ? (clamp = _ ? true : identity, rescale()) : clamp !== identity;\n  };\n\n  scale.interpolate = function(_) {\n    return arguments.length ? (interpolate = _, rescale()) : interpolate;\n  };\n\n  scale.unknown = function(_) {\n    return arguments.length ? (unknown = _, scale) : unknown;\n  };\n\n  return function(t, u) {\n    transform = t, untransform = u;\n    return rescale();\n  };\n}\n\nfunction continuous() {\n  return transformer()(identity, identity);\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-scale/src/continuous.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-scale/src/init.js":
/*!******************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-scale/src/init.js ***!
  \******************************************************************/
/*! exports provided: initRange, initInterpolator */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"initRange\", function() { return initRange; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"initInterpolator\", function() { return initInterpolator; });\nfunction initRange(domain, range) {\n  switch (arguments.length) {\n    case 0: break;\n    case 1: this.range(domain); break;\n    default: this.range(range).domain(domain); break;\n  }\n  return this;\n}\n\nfunction initInterpolator(domain, interpolator) {\n  switch (arguments.length) {\n    case 0: break;\n    case 1: {\n      if (typeof domain === \"function\") this.interpolator(domain);\n      else this.range(domain);\n      break;\n    }\n    default: {\n      this.domain(domain);\n      if (typeof interpolator === \"function\") this.interpolator(interpolator);\n      else this.range(interpolator);\n      break;\n    }\n  }\n  return this;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1zY2FsZS9zcmMvaW5pdC5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9lbmNvZGFibGUvbm9kZV9tb2R1bGVzL2QzLXNjYWxlL3NyYy9pbml0LmpzPzJjMjQiXSwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IGZ1bmN0aW9uIGluaXRSYW5nZShkb21haW4sIHJhbmdlKSB7XG4gIHN3aXRjaCAoYXJndW1lbnRzLmxlbmd0aCkge1xuICAgIGNhc2UgMDogYnJlYWs7XG4gICAgY2FzZSAxOiB0aGlzLnJhbmdlKGRvbWFpbik7IGJyZWFrO1xuICAgIGRlZmF1bHQ6IHRoaXMucmFuZ2UocmFuZ2UpLmRvbWFpbihkb21haW4pOyBicmVhaztcbiAgfVxuICByZXR1cm4gdGhpcztcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGluaXRJbnRlcnBvbGF0b3IoZG9tYWluLCBpbnRlcnBvbGF0b3IpIHtcbiAgc3dpdGNoIChhcmd1bWVudHMubGVuZ3RoKSB7XG4gICAgY2FzZSAwOiBicmVhaztcbiAgICBjYXNlIDE6IHtcbiAgICAgIGlmICh0eXBlb2YgZG9tYWluID09PSBcImZ1bmN0aW9uXCIpIHRoaXMuaW50ZXJwb2xhdG9yKGRvbWFpbik7XG4gICAgICBlbHNlIHRoaXMucmFuZ2UoZG9tYWluKTtcbiAgICAgIGJyZWFrO1xuICAgIH1cbiAgICBkZWZhdWx0OiB7XG4gICAgICB0aGlzLmRvbWFpbihkb21haW4pO1xuICAgICAgaWYgKHR5cGVvZiBpbnRlcnBvbGF0b3IgPT09IFwiZnVuY3Rpb25cIikgdGhpcy5pbnRlcnBvbGF0b3IoaW50ZXJwb2xhdG9yKTtcbiAgICAgIGVsc2UgdGhpcy5yYW5nZShpbnRlcnBvbGF0b3IpO1xuICAgICAgYnJlYWs7XG4gICAgfVxuICB9XG4gIHJldHVybiB0aGlzO1xufVxuIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOyIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-scale/src/init.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-scale/src/linear.js":
/*!********************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-scale/src/linear.js ***!
  \********************************************************************/
/*! exports provided: linearish, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"linearish\", function() { return linearish; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return linear; });\n/* harmony import */ var d3_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-array */ \"./node_modules/encodable/node_modules/d3-array/src/ticks.js\");\n/* harmony import */ var _continuous_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./continuous.js */ \"./node_modules/encodable/node_modules/d3-scale/src/continuous.js\");\n/* harmony import */ var _init_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./init.js */ \"./node_modules/encodable/node_modules/d3-scale/src/init.js\");\n/* harmony import */ var _tickFormat_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./tickFormat.js */ \"./node_modules/encodable/node_modules/d3-scale/src/tickFormat.js\");\n\n\n\n\n\nfunction linearish(scale) {\n  var domain = scale.domain;\n\n  scale.ticks = function(count) {\n    var d = domain();\n    return Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(d[0], d[d.length - 1], count == null ? 10 : count);\n  };\n\n  scale.tickFormat = function(count, specifier) {\n    var d = domain();\n    return Object(_tickFormat_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(d[0], d[d.length - 1], count == null ? 10 : count, specifier);\n  };\n\n  scale.nice = function(count) {\n    if (count == null) count = 10;\n\n    var d = domain();\n    var i0 = 0;\n    var i1 = d.length - 1;\n    var start = d[i0];\n    var stop = d[i1];\n    var prestep;\n    var step;\n    var maxIter = 10;\n\n    if (stop < start) {\n      step = start, start = stop, stop = step;\n      step = i0, i0 = i1, i1 = step;\n    }\n    \n    while (maxIter-- > 0) {\n      step = Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"tickIncrement\"])(start, stop, count);\n      if (step === prestep) {\n        d[i0] = start\n        d[i1] = stop\n        return domain(d);\n      } else if (step > 0) {\n        start = Math.floor(start / step) * step;\n        stop = Math.ceil(stop / step) * step;\n      } else if (step < 0) {\n        start = Math.ceil(start * step) / step;\n        stop = Math.floor(stop * step) / step;\n      } else {\n        break;\n      }\n      prestep = step;\n    }\n\n    return scale;\n  };\n\n  return scale;\n}\n\nfunction linear() {\n  var scale = Object(_continuous_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])();\n\n  scale.copy = function() {\n    return Object(_continuous_js__WEBPACK_IMPORTED_MODULE_1__[\"copy\"])(scale, linear());\n  };\n\n  _init_js__WEBPACK_IMPORTED_MODULE_2__[\"initRange\"].apply(scale, arguments);\n\n  return linearish(scale);\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-scale/src/linear.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-scale/src/log.js":
/*!*****************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-scale/src/log.js ***!
  \*****************************************************************/
/*! exports provided: loggish, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"loggish\", function() { return loggish; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return log; });\n/* harmony import */ var d3_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-array */ \"./node_modules/encodable/node_modules/d3-array/src/ticks.js\");\n/* harmony import */ var d3_format__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! d3-format */ \"./node_modules/d3-format/src/index.js\");\n/* harmony import */ var _nice_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./nice.js */ \"./node_modules/encodable/node_modules/d3-scale/src/nice.js\");\n/* harmony import */ var _continuous_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./continuous.js */ \"./node_modules/encodable/node_modules/d3-scale/src/continuous.js\");\n/* harmony import */ var _init_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./init.js */ \"./node_modules/encodable/node_modules/d3-scale/src/init.js\");\n\n\n\n\n\n\nfunction transformLog(x) {\n  return Math.log(x);\n}\n\nfunction transformExp(x) {\n  return Math.exp(x);\n}\n\nfunction transformLogn(x) {\n  return -Math.log(-x);\n}\n\nfunction transformExpn(x) {\n  return -Math.exp(-x);\n}\n\nfunction pow10(x) {\n  return isFinite(x) ? +(\"1e\" + x) : x < 0 ? 0 : x;\n}\n\nfunction powp(base) {\n  return base === 10 ? pow10\n      : base === Math.E ? Math.exp\n      : function(x) { return Math.pow(base, x); };\n}\n\nfunction logp(base) {\n  return base === Math.E ? Math.log\n      : base === 10 && Math.log10\n      || base === 2 && Math.log2\n      || (base = Math.log(base), function(x) { return Math.log(x) / base; });\n}\n\nfunction reflect(f) {\n  return function(x) {\n    return -f(-x);\n  };\n}\n\nfunction loggish(transform) {\n  var scale = transform(transformLog, transformExp),\n      domain = scale.domain,\n      base = 10,\n      logs,\n      pows;\n\n  function rescale() {\n    logs = logp(base), pows = powp(base);\n    if (domain()[0] < 0) {\n      logs = reflect(logs), pows = reflect(pows);\n      transform(transformLogn, transformExpn);\n    } else {\n      transform(transformLog, transformExp);\n    }\n    return scale;\n  }\n\n  scale.base = function(_) {\n    return arguments.length ? (base = +_, rescale()) : base;\n  };\n\n  scale.domain = function(_) {\n    return arguments.length ? (domain(_), rescale()) : domain();\n  };\n\n  scale.ticks = function(count) {\n    var d = domain(),\n        u = d[0],\n        v = d[d.length - 1],\n        r;\n\n    if (r = v < u) i = u, u = v, v = i;\n\n    var i = logs(u),\n        j = logs(v),\n        p,\n        k,\n        t,\n        n = count == null ? 10 : +count,\n        z = [];\n\n    if (!(base % 1) && j - i < n) {\n      i = Math.floor(i), j = Math.ceil(j);\n      if (u > 0) for (; i <= j; ++i) {\n        for (k = 1, p = pows(i); k < base; ++k) {\n          t = p * k;\n          if (t < u) continue;\n          if (t > v) break;\n          z.push(t);\n        }\n      } else for (; i <= j; ++i) {\n        for (k = base - 1, p = pows(i); k >= 1; --k) {\n          t = p * k;\n          if (t < u) continue;\n          if (t > v) break;\n          z.push(t);\n        }\n      }\n      if (z.length * 2 < n) z = Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(u, v, n);\n    } else {\n      z = Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(i, j, Math.min(j - i, n)).map(pows);\n    }\n\n    return r ? z.reverse() : z;\n  };\n\n  scale.tickFormat = function(count, specifier) {\n    if (specifier == null) specifier = base === 10 ? \".0e\" : \",\";\n    if (typeof specifier !== \"function\") specifier = Object(d3_format__WEBPACK_IMPORTED_MODULE_1__[\"format\"])(specifier);\n    if (count === Infinity) return specifier;\n    if (count == null) count = 10;\n    var k = Math.max(1, base * count / scale.ticks().length); // TODO fast estimate?\n    return function(d) {\n      var i = d / pows(Math.round(logs(d)));\n      if (i * base < base - 0.5) i *= base;\n      return i <= k ? specifier(d) : \"\";\n    };\n  };\n\n  scale.nice = function() {\n    return domain(Object(_nice_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(domain(), {\n      floor: function(x) { return pows(Math.floor(logs(x))); },\n      ceil: function(x) { return pows(Math.ceil(logs(x))); }\n    }));\n  };\n\n  return scale;\n}\n\nfunction log() {\n  var scale = loggish(Object(_continuous_js__WEBPACK_IMPORTED_MODULE_3__[\"transformer\"])()).domain([1, 10]);\n\n  scale.copy = function() {\n    return Object(_continuous_js__WEBPACK_IMPORTED_MODULE_3__[\"copy\"])(scale, log()).base(scale.base());\n  };\n\n  _init_js__WEBPACK_IMPORTED_MODULE_4__[\"initRange\"].apply(scale, arguments);\n\n  return scale;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-scale/src/log.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-scale/src/nice.js":
/*!******************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-scale/src/nice.js ***!
  \******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return nice; });\nfunction nice(domain, interval) {\n  domain = domain.slice();\n\n  var i0 = 0,\n      i1 = domain.length - 1,\n      x0 = domain[i0],\n      x1 = domain[i1],\n      t;\n\n  if (x1 < x0) {\n    t = i0, i0 = i1, i1 = t;\n    t = x0, x0 = x1, x1 = t;\n  }\n\n  domain[i0] = interval.floor(x0);\n  domain[i1] = interval.ceil(x1);\n  return domain;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1zY2FsZS9zcmMvbmljZS5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9lbmNvZGFibGUvbm9kZV9tb2R1bGVzL2QzLXNjYWxlL3NyYy9uaWNlLmpzP2RmNTMiXSwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gbmljZShkb21haW4sIGludGVydmFsKSB7XG4gIGRvbWFpbiA9IGRvbWFpbi5zbGljZSgpO1xuXG4gIHZhciBpMCA9IDAsXG4gICAgICBpMSA9IGRvbWFpbi5sZW5ndGggLSAxLFxuICAgICAgeDAgPSBkb21haW5baTBdLFxuICAgICAgeDEgPSBkb21haW5baTFdLFxuICAgICAgdDtcblxuICBpZiAoeDEgPCB4MCkge1xuICAgIHQgPSBpMCwgaTAgPSBpMSwgaTEgPSB0O1xuICAgIHQgPSB4MCwgeDAgPSB4MSwgeDEgPSB0O1xuICB9XG5cbiAgZG9tYWluW2kwXSA9IGludGVydmFsLmZsb29yKHgwKTtcbiAgZG9tYWluW2kxXSA9IGludGVydmFsLmNlaWwoeDEpO1xuICByZXR1cm4gZG9tYWluO1xufVxuIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOyIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-scale/src/nice.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-scale/src/number.js":
/*!********************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-scale/src/number.js ***!
  \********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return number; });\nfunction number(x) {\n  return +x;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1zY2FsZS9zcmMvbnVtYmVyLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9ub2RlX21vZHVsZXMvZDMtc2NhbGUvc3JjL251bWJlci5qcz9mZWQ3Il0sInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIG51bWJlcih4KSB7XG4gIHJldHVybiAreDtcbn1cbiJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTsiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-scale/src/number.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-scale/src/ordinal.js":
/*!*********************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-scale/src/ordinal.js ***!
  \*********************************************************************/
/*! exports provided: implicit, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"implicit\", function() { return implicit; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return ordinal; });\n/* harmony import */ var _init_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./init.js */ \"./node_modules/encodable/node_modules/d3-scale/src/init.js\");\n\n\nconst implicit = Symbol(\"implicit\");\n\nfunction ordinal() {\n  var index = new Map(),\n      domain = [],\n      range = [],\n      unknown = implicit;\n\n  function scale(d) {\n    var key = d + \"\", i = index.get(key);\n    if (!i) {\n      if (unknown !== implicit) return unknown;\n      index.set(key, i = domain.push(d));\n    }\n    return range[(i - 1) % range.length];\n  }\n\n  scale.domain = function(_) {\n    if (!arguments.length) return domain.slice();\n    domain = [], index = new Map();\n    for (const value of _) {\n      const key = value + \"\";\n      if (index.has(key)) continue;\n      index.set(key, domain.push(value));\n    }\n    return scale;\n  };\n\n  scale.range = function(_) {\n    return arguments.length ? (range = Array.from(_), scale) : range.slice();\n  };\n\n  scale.unknown = function(_) {\n    return arguments.length ? (unknown = _, scale) : unknown;\n  };\n\n  scale.copy = function() {\n    return ordinal(domain, range).unknown(unknown);\n  };\n\n  _init_js__WEBPACK_IMPORTED_MODULE_0__[\"initRange\"].apply(scale, arguments);\n\n  return scale;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-scale/src/ordinal.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-scale/src/pow.js":
/*!*****************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-scale/src/pow.js ***!
  \*****************************************************************/
/*! exports provided: powish, default, sqrt */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"powish\", function() { return powish; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return pow; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"sqrt\", function() { return sqrt; });\n/* harmony import */ var _linear_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./linear.js */ \"./node_modules/encodable/node_modules/d3-scale/src/linear.js\");\n/* harmony import */ var _continuous_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./continuous.js */ \"./node_modules/encodable/node_modules/d3-scale/src/continuous.js\");\n/* harmony import */ var _init_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./init.js */ \"./node_modules/encodable/node_modules/d3-scale/src/init.js\");\n\n\n\n\nfunction transformPow(exponent) {\n  return function(x) {\n    return x < 0 ? -Math.pow(-x, exponent) : Math.pow(x, exponent);\n  };\n}\n\nfunction transformSqrt(x) {\n  return x < 0 ? -Math.sqrt(-x) : Math.sqrt(x);\n}\n\nfunction transformSquare(x) {\n  return x < 0 ? -x * x : x * x;\n}\n\nfunction powish(transform) {\n  var scale = transform(_continuous_js__WEBPACK_IMPORTED_MODULE_1__[\"identity\"], _continuous_js__WEBPACK_IMPORTED_MODULE_1__[\"identity\"]),\n      exponent = 1;\n\n  function rescale() {\n    return exponent === 1 ? transform(_continuous_js__WEBPACK_IMPORTED_MODULE_1__[\"identity\"], _continuous_js__WEBPACK_IMPORTED_MODULE_1__[\"identity\"])\n        : exponent === 0.5 ? transform(transformSqrt, transformSquare)\n        : transform(transformPow(exponent), transformPow(1 / exponent));\n  }\n\n  scale.exponent = function(_) {\n    return arguments.length ? (exponent = +_, rescale()) : exponent;\n  };\n\n  return Object(_linear_js__WEBPACK_IMPORTED_MODULE_0__[\"linearish\"])(scale);\n}\n\nfunction pow() {\n  var scale = powish(Object(_continuous_js__WEBPACK_IMPORTED_MODULE_1__[\"transformer\"])());\n\n  scale.copy = function() {\n    return Object(_continuous_js__WEBPACK_IMPORTED_MODULE_1__[\"copy\"])(scale, pow()).exponent(scale.exponent());\n  };\n\n  _init_js__WEBPACK_IMPORTED_MODULE_2__[\"initRange\"].apply(scale, arguments);\n\n  return scale;\n}\n\nfunction sqrt() {\n  return pow.apply(null, arguments).exponent(0.5);\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-scale/src/pow.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-scale/src/quantile.js":
/*!**********************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-scale/src/quantile.js ***!
  \**********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return quantile; });\n/* harmony import */ var d3_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-array */ \"./node_modules/encodable/node_modules/d3-array/src/quantile.js\");\n/* harmony import */ var d3_array__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! d3-array */ \"./node_modules/encodable/node_modules/d3-array/src/bisect.js\");\n/* harmony import */ var d3_array__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! d3-array */ \"./node_modules/encodable/node_modules/d3-array/src/ascending.js\");\n/* harmony import */ var _init_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./init.js */ \"./node_modules/encodable/node_modules/d3-scale/src/init.js\");\n\n\n\nfunction quantile() {\n  var domain = [],\n      range = [],\n      thresholds = [],\n      unknown;\n\n  function rescale() {\n    var i = 0, n = Math.max(1, range.length);\n    thresholds = new Array(n - 1);\n    while (++i < n) thresholds[i - 1] = Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"quantileSorted\"])(domain, i / n);\n    return scale;\n  }\n\n  function scale(x) {\n    return isNaN(x = +x) ? unknown : range[Object(d3_array__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(thresholds, x)];\n  }\n\n  scale.invertExtent = function(y) {\n    var i = range.indexOf(y);\n    return i < 0 ? [NaN, NaN] : [\n      i > 0 ? thresholds[i - 1] : domain[0],\n      i < thresholds.length ? thresholds[i] : domain[domain.length - 1]\n    ];\n  };\n\n  scale.domain = function(_) {\n    if (!arguments.length) return domain.slice();\n    domain = [];\n    for (let d of _) if (d != null && !isNaN(d = +d)) domain.push(d);\n    domain.sort(d3_array__WEBPACK_IMPORTED_MODULE_2__[\"default\"]);\n    return rescale();\n  };\n\n  scale.range = function(_) {\n    return arguments.length ? (range = Array.from(_), rescale()) : range.slice();\n  };\n\n  scale.unknown = function(_) {\n    return arguments.length ? (unknown = _, scale) : unknown;\n  };\n\n  scale.quantiles = function() {\n    return thresholds.slice();\n  };\n\n  scale.copy = function() {\n    return quantile()\n        .domain(domain)\n        .range(range)\n        .unknown(unknown);\n  };\n\n  return _init_js__WEBPACK_IMPORTED_MODULE_3__[\"initRange\"].apply(scale, arguments);\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1zY2FsZS9zcmMvcXVhbnRpbGUuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1zY2FsZS9zcmMvcXVhbnRpbGUuanM/MGVhZSJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge2FzY2VuZGluZywgYmlzZWN0LCBxdWFudGlsZVNvcnRlZCBhcyB0aHJlc2hvbGR9IGZyb20gXCJkMy1hcnJheVwiO1xuaW1wb3J0IHtpbml0UmFuZ2V9IGZyb20gXCIuL2luaXQuanNcIjtcblxuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gcXVhbnRpbGUoKSB7XG4gIHZhciBkb21haW4gPSBbXSxcbiAgICAgIHJhbmdlID0gW10sXG4gICAgICB0aHJlc2hvbGRzID0gW10sXG4gICAgICB1bmtub3duO1xuXG4gIGZ1bmN0aW9uIHJlc2NhbGUoKSB7XG4gICAgdmFyIGkgPSAwLCBuID0gTWF0aC5tYXgoMSwgcmFuZ2UubGVuZ3RoKTtcbiAgICB0aHJlc2hvbGRzID0gbmV3IEFycmF5KG4gLSAxKTtcbiAgICB3aGlsZSAoKytpIDwgbikgdGhyZXNob2xkc1tpIC0gMV0gPSB0aHJlc2hvbGQoZG9tYWluLCBpIC8gbik7XG4gICAgcmV0dXJuIHNjYWxlO1xuICB9XG5cbiAgZnVuY3Rpb24gc2NhbGUoeCkge1xuICAgIHJldHVybiBpc05hTih4ID0gK3gpID8gdW5rbm93biA6IHJhbmdlW2Jpc2VjdCh0aHJlc2hvbGRzLCB4KV07XG4gIH1cblxuICBzY2FsZS5pbnZlcnRFeHRlbnQgPSBmdW5jdGlvbih5KSB7XG4gICAgdmFyIGkgPSByYW5nZS5pbmRleE9mKHkpO1xuICAgIHJldHVybiBpIDwgMCA/IFtOYU4sIE5hTl0gOiBbXG4gICAgICBpID4gMCA/IHRocmVzaG9sZHNbaSAtIDFdIDogZG9tYWluWzBdLFxuICAgICAgaSA8IHRocmVzaG9sZHMubGVuZ3RoID8gdGhyZXNob2xkc1tpXSA6IGRvbWFpbltkb21haW4ubGVuZ3RoIC0gMV1cbiAgICBdO1xuICB9O1xuXG4gIHNjYWxlLmRvbWFpbiA9IGZ1bmN0aW9uKF8pIHtcbiAgICBpZiAoIWFyZ3VtZW50cy5sZW5ndGgpIHJldHVybiBkb21haW4uc2xpY2UoKTtcbiAgICBkb21haW4gPSBbXTtcbiAgICBmb3IgKGxldCBkIG9mIF8pIGlmIChkICE9IG51bGwgJiYgIWlzTmFOKGQgPSArZCkpIGRvbWFpbi5wdXNoKGQpO1xuICAgIGRvbWFpbi5zb3J0KGFzY2VuZGluZyk7XG4gICAgcmV0dXJuIHJlc2NhbGUoKTtcbiAgfTtcblxuICBzY2FsZS5yYW5nZSA9IGZ1bmN0aW9uKF8pIHtcbiAgICByZXR1cm4gYXJndW1lbnRzLmxlbmd0aCA/IChyYW5nZSA9IEFycmF5LmZyb20oXyksIHJlc2NhbGUoKSkgOiByYW5nZS5zbGljZSgpO1xuICB9O1xuXG4gIHNjYWxlLnVua25vd24gPSBmdW5jdGlvbihfKSB7XG4gICAgcmV0dXJuIGFyZ3VtZW50cy5sZW5ndGggPyAodW5rbm93biA9IF8sIHNjYWxlKSA6IHVua25vd247XG4gIH07XG5cbiAgc2NhbGUucXVhbnRpbGVzID0gZnVuY3Rpb24oKSB7XG4gICAgcmV0dXJuIHRocmVzaG9sZHMuc2xpY2UoKTtcbiAgfTtcblxuICBzY2FsZS5jb3B5ID0gZnVuY3Rpb24oKSB7XG4gICAgcmV0dXJuIHF1YW50aWxlKClcbiAgICAgICAgLmRvbWFpbihkb21haW4pXG4gICAgICAgIC5yYW5nZShyYW5nZSlcbiAgICAgICAgLnVua25vd24odW5rbm93bik7XG4gIH07XG5cbiAgcmV0dXJuIGluaXRSYW5nZS5hcHBseShzY2FsZSwgYXJndW1lbnRzKTtcbn1cbiJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOyIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-scale/src/quantile.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-scale/src/quantize.js":
/*!**********************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-scale/src/quantize.js ***!
  \**********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return quantize; });\n/* harmony import */ var d3_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-array */ \"./node_modules/encodable/node_modules/d3-array/src/bisect.js\");\n/* harmony import */ var _linear_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./linear.js */ \"./node_modules/encodable/node_modules/d3-scale/src/linear.js\");\n/* harmony import */ var _init_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./init.js */ \"./node_modules/encodable/node_modules/d3-scale/src/init.js\");\n\n\n\n\nfunction quantize() {\n  var x0 = 0,\n      x1 = 1,\n      n = 1,\n      domain = [0.5],\n      range = [0, 1],\n      unknown;\n\n  function scale(x) {\n    return x <= x ? range[Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(domain, x, 0, n)] : unknown;\n  }\n\n  function rescale() {\n    var i = -1;\n    domain = new Array(n);\n    while (++i < n) domain[i] = ((i + 1) * x1 - (i - n) * x0) / (n + 1);\n    return scale;\n  }\n\n  scale.domain = function(_) {\n    return arguments.length ? ([x0, x1] = _, x0 = +x0, x1 = +x1, rescale()) : [x0, x1];\n  };\n\n  scale.range = function(_) {\n    return arguments.length ? (n = (range = Array.from(_)).length - 1, rescale()) : range.slice();\n  };\n\n  scale.invertExtent = function(y) {\n    var i = range.indexOf(y);\n    return i < 0 ? [NaN, NaN]\n        : i < 1 ? [x0, domain[0]]\n        : i >= n ? [domain[n - 1], x1]\n        : [domain[i - 1], domain[i]];\n  };\n\n  scale.unknown = function(_) {\n    return arguments.length ? (unknown = _, scale) : scale;\n  };\n\n  scale.thresholds = function() {\n    return domain.slice();\n  };\n\n  scale.copy = function() {\n    return quantize()\n        .domain([x0, x1])\n        .range(range)\n        .unknown(unknown);\n  };\n\n  return _init_js__WEBPACK_IMPORTED_MODULE_2__[\"initRange\"].apply(Object(_linear_js__WEBPACK_IMPORTED_MODULE_1__[\"linearish\"])(scale), arguments);\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1zY2FsZS9zcmMvcXVhbnRpemUuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1zY2FsZS9zcmMvcXVhbnRpemUuanM/ZmI1MSJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge2Jpc2VjdH0gZnJvbSBcImQzLWFycmF5XCI7XG5pbXBvcnQge2xpbmVhcmlzaH0gZnJvbSBcIi4vbGluZWFyLmpzXCI7XG5pbXBvcnQge2luaXRSYW5nZX0gZnJvbSBcIi4vaW5pdC5qc1wiO1xuXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiBxdWFudGl6ZSgpIHtcbiAgdmFyIHgwID0gMCxcbiAgICAgIHgxID0gMSxcbiAgICAgIG4gPSAxLFxuICAgICAgZG9tYWluID0gWzAuNV0sXG4gICAgICByYW5nZSA9IFswLCAxXSxcbiAgICAgIHVua25vd247XG5cbiAgZnVuY3Rpb24gc2NhbGUoeCkge1xuICAgIHJldHVybiB4IDw9IHggPyByYW5nZVtiaXNlY3QoZG9tYWluLCB4LCAwLCBuKV0gOiB1bmtub3duO1xuICB9XG5cbiAgZnVuY3Rpb24gcmVzY2FsZSgpIHtcbiAgICB2YXIgaSA9IC0xO1xuICAgIGRvbWFpbiA9IG5ldyBBcnJheShuKTtcbiAgICB3aGlsZSAoKytpIDwgbikgZG9tYWluW2ldID0gKChpICsgMSkgKiB4MSAtIChpIC0gbikgKiB4MCkgLyAobiArIDEpO1xuICAgIHJldHVybiBzY2FsZTtcbiAgfVxuXG4gIHNjYWxlLmRvbWFpbiA9IGZ1bmN0aW9uKF8pIHtcbiAgICByZXR1cm4gYXJndW1lbnRzLmxlbmd0aCA/IChbeDAsIHgxXSA9IF8sIHgwID0gK3gwLCB4MSA9ICt4MSwgcmVzY2FsZSgpKSA6IFt4MCwgeDFdO1xuICB9O1xuXG4gIHNjYWxlLnJhbmdlID0gZnVuY3Rpb24oXykge1xuICAgIHJldHVybiBhcmd1bWVudHMubGVuZ3RoID8gKG4gPSAocmFuZ2UgPSBBcnJheS5mcm9tKF8pKS5sZW5ndGggLSAxLCByZXNjYWxlKCkpIDogcmFuZ2Uuc2xpY2UoKTtcbiAgfTtcblxuICBzY2FsZS5pbnZlcnRFeHRlbnQgPSBmdW5jdGlvbih5KSB7XG4gICAgdmFyIGkgPSByYW5nZS5pbmRleE9mKHkpO1xuICAgIHJldHVybiBpIDwgMCA/IFtOYU4sIE5hTl1cbiAgICAgICAgOiBpIDwgMSA/IFt4MCwgZG9tYWluWzBdXVxuICAgICAgICA6IGkgPj0gbiA/IFtkb21haW5bbiAtIDFdLCB4MV1cbiAgICAgICAgOiBbZG9tYWluW2kgLSAxXSwgZG9tYWluW2ldXTtcbiAgfTtcblxuICBzY2FsZS51bmtub3duID0gZnVuY3Rpb24oXykge1xuICAgIHJldHVybiBhcmd1bWVudHMubGVuZ3RoID8gKHVua25vd24gPSBfLCBzY2FsZSkgOiBzY2FsZTtcbiAgfTtcblxuICBzY2FsZS50aHJlc2hvbGRzID0gZnVuY3Rpb24oKSB7XG4gICAgcmV0dXJuIGRvbWFpbi5zbGljZSgpO1xuICB9O1xuXG4gIHNjYWxlLmNvcHkgPSBmdW5jdGlvbigpIHtcbiAgICByZXR1cm4gcXVhbnRpemUoKVxuICAgICAgICAuZG9tYWluKFt4MCwgeDFdKVxuICAgICAgICAucmFuZ2UocmFuZ2UpXG4gICAgICAgIC51bmtub3duKHVua25vd24pO1xuICB9O1xuXG4gIHJldHVybiBpbml0UmFuZ2UuYXBwbHkobGluZWFyaXNoKHNjYWxlKSwgYXJndW1lbnRzKTtcbn1cbiJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Iiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-scale/src/quantize.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-scale/src/symlog.js":
/*!********************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-scale/src/symlog.js ***!
  \********************************************************************/
/*! exports provided: symlogish, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"symlogish\", function() { return symlogish; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return symlog; });\n/* harmony import */ var _linear_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./linear.js */ \"./node_modules/encodable/node_modules/d3-scale/src/linear.js\");\n/* harmony import */ var _continuous_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./continuous.js */ \"./node_modules/encodable/node_modules/d3-scale/src/continuous.js\");\n/* harmony import */ var _init_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./init.js */ \"./node_modules/encodable/node_modules/d3-scale/src/init.js\");\n\n\n\n\nfunction transformSymlog(c) {\n  return function(x) {\n    return Math.sign(x) * Math.log1p(Math.abs(x / c));\n  };\n}\n\nfunction transformSymexp(c) {\n  return function(x) {\n    return Math.sign(x) * Math.expm1(Math.abs(x)) * c;\n  };\n}\n\nfunction symlogish(transform) {\n  var c = 1, scale = transform(transformSymlog(c), transformSymexp(c));\n\n  scale.constant = function(_) {\n    return arguments.length ? transform(transformSymlog(c = +_), transformSymexp(c)) : c;\n  };\n\n  return Object(_linear_js__WEBPACK_IMPORTED_MODULE_0__[\"linearish\"])(scale);\n}\n\nfunction symlog() {\n  var scale = symlogish(Object(_continuous_js__WEBPACK_IMPORTED_MODULE_1__[\"transformer\"])());\n\n  scale.copy = function() {\n    return Object(_continuous_js__WEBPACK_IMPORTED_MODULE_1__[\"copy\"])(scale, symlog()).constant(scale.constant());\n  };\n\n  return _init_js__WEBPACK_IMPORTED_MODULE_2__[\"initRange\"].apply(scale, arguments);\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1zY2FsZS9zcmMvc3ltbG9nLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9ub2RlX21vZHVsZXMvZDMtc2NhbGUvc3JjL3N5bWxvZy5qcz8zZTA5Il0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7bGluZWFyaXNofSBmcm9tIFwiLi9saW5lYXIuanNcIjtcbmltcG9ydCB7Y29weSwgdHJhbnNmb3JtZXJ9IGZyb20gXCIuL2NvbnRpbnVvdXMuanNcIjtcbmltcG9ydCB7aW5pdFJhbmdlfSBmcm9tIFwiLi9pbml0LmpzXCI7XG5cbmZ1bmN0aW9uIHRyYW5zZm9ybVN5bWxvZyhjKSB7XG4gIHJldHVybiBmdW5jdGlvbih4KSB7XG4gICAgcmV0dXJuIE1hdGguc2lnbih4KSAqIE1hdGgubG9nMXAoTWF0aC5hYnMoeCAvIGMpKTtcbiAgfTtcbn1cblxuZnVuY3Rpb24gdHJhbnNmb3JtU3ltZXhwKGMpIHtcbiAgcmV0dXJuIGZ1bmN0aW9uKHgpIHtcbiAgICByZXR1cm4gTWF0aC5zaWduKHgpICogTWF0aC5leHBtMShNYXRoLmFicyh4KSkgKiBjO1xuICB9O1xufVxuXG5leHBvcnQgZnVuY3Rpb24gc3ltbG9naXNoKHRyYW5zZm9ybSkge1xuICB2YXIgYyA9IDEsIHNjYWxlID0gdHJhbnNmb3JtKHRyYW5zZm9ybVN5bWxvZyhjKSwgdHJhbnNmb3JtU3ltZXhwKGMpKTtcblxuICBzY2FsZS5jb25zdGFudCA9IGZ1bmN0aW9uKF8pIHtcbiAgICByZXR1cm4gYXJndW1lbnRzLmxlbmd0aCA/IHRyYW5zZm9ybSh0cmFuc2Zvcm1TeW1sb2coYyA9ICtfKSwgdHJhbnNmb3JtU3ltZXhwKGMpKSA6IGM7XG4gIH07XG5cbiAgcmV0dXJuIGxpbmVhcmlzaChzY2FsZSk7XG59XG5cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIHN5bWxvZygpIHtcbiAgdmFyIHNjYWxlID0gc3ltbG9naXNoKHRyYW5zZm9ybWVyKCkpO1xuXG4gIHNjYWxlLmNvcHkgPSBmdW5jdGlvbigpIHtcbiAgICByZXR1cm4gY29weShzY2FsZSwgc3ltbG9nKCkpLmNvbnN0YW50KHNjYWxlLmNvbnN0YW50KCkpO1xuICB9O1xuXG4gIHJldHVybiBpbml0UmFuZ2UuYXBwbHkoc2NhbGUsIGFyZ3VtZW50cyk7XG59XG4iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Iiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-scale/src/symlog.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-scale/src/threshold.js":
/*!***********************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-scale/src/threshold.js ***!
  \***********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return threshold; });\n/* harmony import */ var d3_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-array */ \"./node_modules/encodable/node_modules/d3-array/src/bisect.js\");\n/* harmony import */ var _init_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./init.js */ \"./node_modules/encodable/node_modules/d3-scale/src/init.js\");\n\n\n\nfunction threshold() {\n  var domain = [0.5],\n      range = [0, 1],\n      unknown,\n      n = 1;\n\n  function scale(x) {\n    return x <= x ? range[Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(domain, x, 0, n)] : unknown;\n  }\n\n  scale.domain = function(_) {\n    return arguments.length ? (domain = Array.from(_), n = Math.min(domain.length, range.length - 1), scale) : domain.slice();\n  };\n\n  scale.range = function(_) {\n    return arguments.length ? (range = Array.from(_), n = Math.min(domain.length, range.length - 1), scale) : range.slice();\n  };\n\n  scale.invertExtent = function(y) {\n    var i = range.indexOf(y);\n    return [domain[i - 1], domain[i]];\n  };\n\n  scale.unknown = function(_) {\n    return arguments.length ? (unknown = _, scale) : unknown;\n  };\n\n  scale.copy = function() {\n    return threshold()\n        .domain(domain)\n        .range(range)\n        .unknown(unknown);\n  };\n\n  return _init_js__WEBPACK_IMPORTED_MODULE_1__[\"initRange\"].apply(scale, arguments);\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1zY2FsZS9zcmMvdGhyZXNob2xkLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9ub2RlX21vZHVsZXMvZDMtc2NhbGUvc3JjL3RocmVzaG9sZC5qcz84MjdlIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7YmlzZWN0fSBmcm9tIFwiZDMtYXJyYXlcIjtcbmltcG9ydCB7aW5pdFJhbmdlfSBmcm9tIFwiLi9pbml0LmpzXCI7XG5cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIHRocmVzaG9sZCgpIHtcbiAgdmFyIGRvbWFpbiA9IFswLjVdLFxuICAgICAgcmFuZ2UgPSBbMCwgMV0sXG4gICAgICB1bmtub3duLFxuICAgICAgbiA9IDE7XG5cbiAgZnVuY3Rpb24gc2NhbGUoeCkge1xuICAgIHJldHVybiB4IDw9IHggPyByYW5nZVtiaXNlY3QoZG9tYWluLCB4LCAwLCBuKV0gOiB1bmtub3duO1xuICB9XG5cbiAgc2NhbGUuZG9tYWluID0gZnVuY3Rpb24oXykge1xuICAgIHJldHVybiBhcmd1bWVudHMubGVuZ3RoID8gKGRvbWFpbiA9IEFycmF5LmZyb20oXyksIG4gPSBNYXRoLm1pbihkb21haW4ubGVuZ3RoLCByYW5nZS5sZW5ndGggLSAxKSwgc2NhbGUpIDogZG9tYWluLnNsaWNlKCk7XG4gIH07XG5cbiAgc2NhbGUucmFuZ2UgPSBmdW5jdGlvbihfKSB7XG4gICAgcmV0dXJuIGFyZ3VtZW50cy5sZW5ndGggPyAocmFuZ2UgPSBBcnJheS5mcm9tKF8pLCBuID0gTWF0aC5taW4oZG9tYWluLmxlbmd0aCwgcmFuZ2UubGVuZ3RoIC0gMSksIHNjYWxlKSA6IHJhbmdlLnNsaWNlKCk7XG4gIH07XG5cbiAgc2NhbGUuaW52ZXJ0RXh0ZW50ID0gZnVuY3Rpb24oeSkge1xuICAgIHZhciBpID0gcmFuZ2UuaW5kZXhPZih5KTtcbiAgICByZXR1cm4gW2RvbWFpbltpIC0gMV0sIGRvbWFpbltpXV07XG4gIH07XG5cbiAgc2NhbGUudW5rbm93biA9IGZ1bmN0aW9uKF8pIHtcbiAgICByZXR1cm4gYXJndW1lbnRzLmxlbmd0aCA/ICh1bmtub3duID0gXywgc2NhbGUpIDogdW5rbm93bjtcbiAgfTtcblxuICBzY2FsZS5jb3B5ID0gZnVuY3Rpb24oKSB7XG4gICAgcmV0dXJuIHRocmVzaG9sZCgpXG4gICAgICAgIC5kb21haW4oZG9tYWluKVxuICAgICAgICAucmFuZ2UocmFuZ2UpXG4gICAgICAgIC51bmtub3duKHVua25vd24pO1xuICB9O1xuXG4gIHJldHVybiBpbml0UmFuZ2UuYXBwbHkoc2NhbGUsIGFyZ3VtZW50cyk7XG59XG4iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOyIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-scale/src/threshold.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-scale/src/tickFormat.js":
/*!************************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-scale/src/tickFormat.js ***!
  \************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return tickFormat; });\n/* harmony import */ var d3_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-array */ \"./node_modules/encodable/node_modules/d3-array/src/ticks.js\");\n/* harmony import */ var d3_format__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! d3-format */ \"./node_modules/d3-format/src/index.js\");\n\n\n\nfunction tickFormat(start, stop, count, specifier) {\n  var step = Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"tickStep\"])(start, stop, count),\n      precision;\n  specifier = Object(d3_format__WEBPACK_IMPORTED_MODULE_1__[\"formatSpecifier\"])(specifier == null ? \",f\" : specifier);\n  switch (specifier.type) {\n    case \"s\": {\n      var value = Math.max(Math.abs(start), Math.abs(stop));\n      if (specifier.precision == null && !isNaN(precision = Object(d3_format__WEBPACK_IMPORTED_MODULE_1__[\"precisionPrefix\"])(step, value))) specifier.precision = precision;\n      return Object(d3_format__WEBPACK_IMPORTED_MODULE_1__[\"formatPrefix\"])(specifier, value);\n    }\n    case \"\":\n    case \"e\":\n    case \"g\":\n    case \"p\":\n    case \"r\": {\n      if (specifier.precision == null && !isNaN(precision = Object(d3_format__WEBPACK_IMPORTED_MODULE_1__[\"precisionRound\"])(step, Math.max(Math.abs(start), Math.abs(stop))))) specifier.precision = precision - (specifier.type === \"e\");\n      break;\n    }\n    case \"f\":\n    case \"%\": {\n      if (specifier.precision == null && !isNaN(precision = Object(d3_format__WEBPACK_IMPORTED_MODULE_1__[\"precisionFixed\"])(step))) specifier.precision = precision - (specifier.type === \"%\") * 2;\n      break;\n    }\n  }\n  return Object(d3_format__WEBPACK_IMPORTED_MODULE_1__[\"format\"])(specifier);\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-scale/src/tickFormat.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-scale/src/time.js":
/*!******************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-scale/src/time.js ***!
  \******************************************************************/
/*! exports provided: calendar, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"calendar\", function() { return calendar; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return time; });\n/* harmony import */ var d3_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-array */ \"./node_modules/encodable/node_modules/d3-array/src/bisector.js\");\n/* harmony import */ var d3_array__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! d3-array */ \"./node_modules/encodable/node_modules/d3-array/src/ticks.js\");\n/* harmony import */ var d3_time__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! d3-time */ \"./node_modules/encodable/node_modules/d3-time/src/year.js\");\n/* harmony import */ var d3_time__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! d3-time */ \"./node_modules/encodable/node_modules/d3-time/src/month.js\");\n/* harmony import */ var d3_time__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! d3-time */ \"./node_modules/encodable/node_modules/d3-time/src/week.js\");\n/* harmony import */ var d3_time__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! d3-time */ \"./node_modules/encodable/node_modules/d3-time/src/day.js\");\n/* harmony import */ var d3_time__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! d3-time */ \"./node_modules/encodable/node_modules/d3-time/src/hour.js\");\n/* harmony import */ var d3_time__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! d3-time */ \"./node_modules/encodable/node_modules/d3-time/src/minute.js\");\n/* harmony import */ var d3_time__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! d3-time */ \"./node_modules/encodable/node_modules/d3-time/src/second.js\");\n/* harmony import */ var d3_time__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! d3-time */ \"./node_modules/encodable/node_modules/d3-time/src/millisecond.js\");\n/* harmony import */ var d3_time_format__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! d3-time-format */ \"./node_modules/d3-time-format/src/defaultLocale.js\");\n/* harmony import */ var _continuous_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./continuous.js */ \"./node_modules/encodable/node_modules/d3-scale/src/continuous.js\");\n/* harmony import */ var _init_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./init.js */ \"./node_modules/encodable/node_modules/d3-scale/src/init.js\");\n/* harmony import */ var _nice_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./nice.js */ \"./node_modules/encodable/node_modules/d3-scale/src/nice.js\");\n\n\n\n\n\n\n\nvar durationSecond = 1000,\n    durationMinute = durationSecond * 60,\n    durationHour = durationMinute * 60,\n    durationDay = durationHour * 24,\n    durationWeek = durationDay * 7,\n    durationMonth = durationDay * 30,\n    durationYear = durationDay * 365;\n\nfunction date(t) {\n  return new Date(t);\n}\n\nfunction number(t) {\n  return t instanceof Date ? +t : +new Date(+t);\n}\n\nfunction calendar(year, month, week, day, hour, minute, second, millisecond, format) {\n  var scale = Object(_continuous_js__WEBPACK_IMPORTED_MODULE_11__[\"default\"])(),\n      invert = scale.invert,\n      domain = scale.domain;\n\n  var formatMillisecond = format(\".%L\"),\n      formatSecond = format(\":%S\"),\n      formatMinute = format(\"%I:%M\"),\n      formatHour = format(\"%I %p\"),\n      formatDay = format(\"%a %d\"),\n      formatWeek = format(\"%b %d\"),\n      formatMonth = format(\"%B\"),\n      formatYear = format(\"%Y\");\n\n  var tickIntervals = [\n    [second,  1,      durationSecond],\n    [second,  5,  5 * durationSecond],\n    [second, 15, 15 * durationSecond],\n    [second, 30, 30 * durationSecond],\n    [minute,  1,      durationMinute],\n    [minute,  5,  5 * durationMinute],\n    [minute, 15, 15 * durationMinute],\n    [minute, 30, 30 * durationMinute],\n    [  hour,  1,      durationHour  ],\n    [  hour,  3,  3 * durationHour  ],\n    [  hour,  6,  6 * durationHour  ],\n    [  hour, 12, 12 * durationHour  ],\n    [   day,  1,      durationDay   ],\n    [   day,  2,  2 * durationDay   ],\n    [  week,  1,      durationWeek  ],\n    [ month,  1,      durationMonth ],\n    [ month,  3,  3 * durationMonth ],\n    [  year,  1,      durationYear  ]\n  ];\n\n  function tickFormat(date) {\n    return (second(date) < date ? formatMillisecond\n        : minute(date) < date ? formatSecond\n        : hour(date) < date ? formatMinute\n        : day(date) < date ? formatHour\n        : month(date) < date ? (week(date) < date ? formatDay : formatWeek)\n        : year(date) < date ? formatMonth\n        : formatYear)(date);\n  }\n\n  function tickInterval(interval, start, stop) {\n    if (interval == null) interval = 10;\n\n    // If a desired tick count is specified, pick a reasonable tick interval\n    // based on the extent of the domain and a rough estimate of tick size.\n    // Otherwise, assume interval is already a time interval and use it.\n    if (typeof interval === \"number\") {\n      var target = Math.abs(stop - start) / interval,\n          i = Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(function(i) { return i[2]; }).right(tickIntervals, target),\n          step;\n      if (i === tickIntervals.length) {\n        step = Object(d3_array__WEBPACK_IMPORTED_MODULE_1__[\"tickStep\"])(start / durationYear, stop / durationYear, interval);\n        interval = year;\n      } else if (i) {\n        i = tickIntervals[target / tickIntervals[i - 1][2] < tickIntervals[i][2] / target ? i - 1 : i];\n        step = i[1];\n        interval = i[0];\n      } else {\n        step = Math.max(Object(d3_array__WEBPACK_IMPORTED_MODULE_1__[\"tickStep\"])(start, stop, interval), 1);\n        interval = millisecond;\n      }\n      return interval.every(step);\n    }\n\n    return interval;\n  }\n\n  scale.invert = function(y) {\n    return new Date(invert(y));\n  };\n\n  scale.domain = function(_) {\n    return arguments.length ? domain(Array.from(_, number)) : domain().map(date);\n  };\n\n  scale.ticks = function(interval) {\n    var d = domain(),\n        t0 = d[0],\n        t1 = d[d.length - 1],\n        r = t1 < t0,\n        t;\n    if (r) t = t0, t0 = t1, t1 = t;\n    t = tickInterval(interval, t0, t1);\n    t = t ? t.range(t0, t1 + 1) : []; // inclusive stop\n    return r ? t.reverse() : t;\n  };\n\n  scale.tickFormat = function(count, specifier) {\n    return specifier == null ? tickFormat : format(specifier);\n  };\n\n  scale.nice = function(interval) {\n    var d = domain();\n    return (interval = tickInterval(interval, d[0], d[d.length - 1]))\n        ? domain(Object(_nice_js__WEBPACK_IMPORTED_MODULE_13__[\"default\"])(d, interval))\n        : scale;\n  };\n\n  scale.copy = function() {\n    return Object(_continuous_js__WEBPACK_IMPORTED_MODULE_11__[\"copy\"])(scale, calendar(year, month, week, day, hour, minute, second, millisecond, format));\n  };\n\n  return scale;\n}\n\nfunction time() {\n  return _init_js__WEBPACK_IMPORTED_MODULE_12__[\"initRange\"].apply(calendar(d3_time__WEBPACK_IMPORTED_MODULE_2__[\"default\"], d3_time__WEBPACK_IMPORTED_MODULE_3__[\"default\"], d3_time__WEBPACK_IMPORTED_MODULE_4__[\"sunday\"], d3_time__WEBPACK_IMPORTED_MODULE_5__[\"default\"], d3_time__WEBPACK_IMPORTED_MODULE_6__[\"default\"], d3_time__WEBPACK_IMPORTED_MODULE_7__[\"default\"], d3_time__WEBPACK_IMPORTED_MODULE_8__[\"default\"], d3_time__WEBPACK_IMPORTED_MODULE_9__[\"default\"], d3_time_format__WEBPACK_IMPORTED_MODULE_10__[\"timeFormat\"]).domain([new Date(2000, 0, 1), new Date(2000, 0, 2)]), arguments);\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-scale/src/time.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-scale/src/utcTime.js":
/*!*********************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-scale/src/utcTime.js ***!
  \*********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return utcTime; });\n/* harmony import */ var _time_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./time.js */ \"./node_modules/encodable/node_modules/d3-scale/src/time.js\");\n/* harmony import */ var d3_time_format__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! d3-time-format */ \"./node_modules/d3-time-format/src/defaultLocale.js\");\n/* harmony import */ var d3_time__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! d3-time */ \"./node_modules/encodable/node_modules/d3-time/src/utcYear.js\");\n/* harmony import */ var d3_time__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! d3-time */ \"./node_modules/encodable/node_modules/d3-time/src/utcMonth.js\");\n/* harmony import */ var d3_time__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! d3-time */ \"./node_modules/encodable/node_modules/d3-time/src/utcWeek.js\");\n/* harmony import */ var d3_time__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! d3-time */ \"./node_modules/encodable/node_modules/d3-time/src/utcDay.js\");\n/* harmony import */ var d3_time__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! d3-time */ \"./node_modules/encodable/node_modules/d3-time/src/utcHour.js\");\n/* harmony import */ var d3_time__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! d3-time */ \"./node_modules/encodable/node_modules/d3-time/src/utcMinute.js\");\n/* harmony import */ var d3_time__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! d3-time */ \"./node_modules/encodable/node_modules/d3-time/src/second.js\");\n/* harmony import */ var d3_time__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! d3-time */ \"./node_modules/encodable/node_modules/d3-time/src/millisecond.js\");\n/* harmony import */ var _init_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./init.js */ \"./node_modules/encodable/node_modules/d3-scale/src/init.js\");\n\n\n\n\n\nfunction utcTime() {\n  return _init_js__WEBPACK_IMPORTED_MODULE_10__[\"initRange\"].apply(Object(_time_js__WEBPACK_IMPORTED_MODULE_0__[\"calendar\"])(d3_time__WEBPACK_IMPORTED_MODULE_2__[\"default\"], d3_time__WEBPACK_IMPORTED_MODULE_3__[\"default\"], d3_time__WEBPACK_IMPORTED_MODULE_4__[\"utcSunday\"], d3_time__WEBPACK_IMPORTED_MODULE_5__[\"default\"], d3_time__WEBPACK_IMPORTED_MODULE_6__[\"default\"], d3_time__WEBPACK_IMPORTED_MODULE_7__[\"default\"], d3_time__WEBPACK_IMPORTED_MODULE_8__[\"default\"], d3_time__WEBPACK_IMPORTED_MODULE_9__[\"default\"], d3_time_format__WEBPACK_IMPORTED_MODULE_1__[\"utcFormat\"]).domain([Date.UTC(2000, 0, 1), Date.UTC(2000, 0, 2)]), arguments);\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy1zY2FsZS9zcmMvdXRjVGltZS5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9lbmNvZGFibGUvbm9kZV9tb2R1bGVzL2QzLXNjYWxlL3NyYy91dGNUaW1lLmpzPzI2M2IiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHtjYWxlbmRhcn0gZnJvbSBcIi4vdGltZS5qc1wiO1xuaW1wb3J0IHt1dGNGb3JtYXR9IGZyb20gXCJkMy10aW1lLWZvcm1hdFwiO1xuaW1wb3J0IHt1dGNZZWFyLCB1dGNNb250aCwgdXRjV2VlaywgdXRjRGF5LCB1dGNIb3VyLCB1dGNNaW51dGUsIHV0Y1NlY29uZCwgdXRjTWlsbGlzZWNvbmR9IGZyb20gXCJkMy10aW1lXCI7XG5pbXBvcnQge2luaXRSYW5nZX0gZnJvbSBcIi4vaW5pdC5qc1wiO1xuXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiB1dGNUaW1lKCkge1xuICByZXR1cm4gaW5pdFJhbmdlLmFwcGx5KGNhbGVuZGFyKHV0Y1llYXIsIHV0Y01vbnRoLCB1dGNXZWVrLCB1dGNEYXksIHV0Y0hvdXIsIHV0Y01pbnV0ZSwgdXRjU2Vjb25kLCB1dGNNaWxsaXNlY29uZCwgdXRjRm9ybWF0KS5kb21haW4oW0RhdGUuVVRDKDIwMDAsIDAsIDEpLCBEYXRlLlVUQygyMDAwLCAwLCAyKV0pLCBhcmd1bWVudHMpO1xufVxuIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Iiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-scale/src/utcTime.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-time/src/day.js":
/*!****************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-time/src/day.js ***!
  \****************************************************************/
/*! exports provided: default, days */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"days\", function() { return days; });\n/* harmony import */ var _interval_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./interval.js */ \"./node_modules/encodable/node_modules/d3-time/src/interval.js\");\n/* harmony import */ var _duration_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./duration.js */ \"./node_modules/encodable/node_modules/d3-time/src/duration.js\");\n\n\n\nvar day = Object(_interval_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(\n  date => date.setHours(0, 0, 0, 0),\n  (date, step) => date.setDate(date.getDate() + step),\n  (start, end) => (end - start - (end.getTimezoneOffset() - start.getTimezoneOffset()) * _duration_js__WEBPACK_IMPORTED_MODULE_1__[\"durationMinute\"]) / _duration_js__WEBPACK_IMPORTED_MODULE_1__[\"durationDay\"],\n  date => date.getDate() - 1\n);\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (day);\nvar days = day.range;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy10aW1lL3NyYy9kYXkuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy10aW1lL3NyYy9kYXkuanM/M2JlMyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgaW50ZXJ2YWwgZnJvbSBcIi4vaW50ZXJ2YWwuanNcIjtcbmltcG9ydCB7ZHVyYXRpb25EYXksIGR1cmF0aW9uTWludXRlfSBmcm9tIFwiLi9kdXJhdGlvbi5qc1wiO1xuXG52YXIgZGF5ID0gaW50ZXJ2YWwoXG4gIGRhdGUgPT4gZGF0ZS5zZXRIb3VycygwLCAwLCAwLCAwKSxcbiAgKGRhdGUsIHN0ZXApID0+IGRhdGUuc2V0RGF0ZShkYXRlLmdldERhdGUoKSArIHN0ZXApLFxuICAoc3RhcnQsIGVuZCkgPT4gKGVuZCAtIHN0YXJ0IC0gKGVuZC5nZXRUaW1lem9uZU9mZnNldCgpIC0gc3RhcnQuZ2V0VGltZXpvbmVPZmZzZXQoKSkgKiBkdXJhdGlvbk1pbnV0ZSkgLyBkdXJhdGlvbkRheSxcbiAgZGF0ZSA9PiBkYXRlLmdldERhdGUoKSAtIDFcbik7XG5cbmV4cG9ydCBkZWZhdWx0IGRheTtcbmV4cG9ydCB2YXIgZGF5cyA9IGRheS5yYW5nZTtcbiJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Iiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-time/src/day.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-time/src/duration.js":
/*!*********************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-time/src/duration.js ***!
  \*********************************************************************/
/*! exports provided: durationSecond, durationMinute, durationHour, durationDay, durationWeek */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"durationSecond\", function() { return durationSecond; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"durationMinute\", function() { return durationMinute; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"durationHour\", function() { return durationHour; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"durationDay\", function() { return durationDay; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"durationWeek\", function() { return durationWeek; });\nvar durationSecond = 1e3;\nvar durationMinute = 6e4;\nvar durationHour = 36e5;\nvar durationDay = 864e5;\nvar durationWeek = 6048e5;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy10aW1lL3NyYy9kdXJhdGlvbi5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9lbmNvZGFibGUvbm9kZV9tb2R1bGVzL2QzLXRpbWUvc3JjL2R1cmF0aW9uLmpzPzZhNmQiXSwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IHZhciBkdXJhdGlvblNlY29uZCA9IDFlMztcbmV4cG9ydCB2YXIgZHVyYXRpb25NaW51dGUgPSA2ZTQ7XG5leHBvcnQgdmFyIGR1cmF0aW9uSG91ciA9IDM2ZTU7XG5leHBvcnQgdmFyIGR1cmF0aW9uRGF5ID0gODY0ZTU7XG5leHBvcnQgdmFyIGR1cmF0aW9uV2VlayA9IDYwNDhlNTtcbiJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTsiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-time/src/duration.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-time/src/hour.js":
/*!*****************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-time/src/hour.js ***!
  \*****************************************************************/
/*! exports provided: default, hours */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"hours\", function() { return hours; });\n/* harmony import */ var _interval_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./interval.js */ \"./node_modules/encodable/node_modules/d3-time/src/interval.js\");\n/* harmony import */ var _duration_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./duration.js */ \"./node_modules/encodable/node_modules/d3-time/src/duration.js\");\n\n\n\nvar hour = Object(_interval_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(function(date) {\n  date.setTime(date - date.getMilliseconds() - date.getSeconds() * _duration_js__WEBPACK_IMPORTED_MODULE_1__[\"durationSecond\"] - date.getMinutes() * _duration_js__WEBPACK_IMPORTED_MODULE_1__[\"durationMinute\"]);\n}, function(date, step) {\n  date.setTime(+date + step * _duration_js__WEBPACK_IMPORTED_MODULE_1__[\"durationHour\"]);\n}, function(start, end) {\n  return (end - start) / _duration_js__WEBPACK_IMPORTED_MODULE_1__[\"durationHour\"];\n}, function(date) {\n  return date.getHours();\n});\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (hour);\nvar hours = hour.range;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy10aW1lL3NyYy9ob3VyLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9ub2RlX21vZHVsZXMvZDMtdGltZS9zcmMvaG91ci5qcz8yZDc5Il0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBpbnRlcnZhbCBmcm9tIFwiLi9pbnRlcnZhbC5qc1wiO1xuaW1wb3J0IHtkdXJhdGlvbkhvdXIsIGR1cmF0aW9uTWludXRlLCBkdXJhdGlvblNlY29uZH0gZnJvbSBcIi4vZHVyYXRpb24uanNcIjtcblxudmFyIGhvdXIgPSBpbnRlcnZhbChmdW5jdGlvbihkYXRlKSB7XG4gIGRhdGUuc2V0VGltZShkYXRlIC0gZGF0ZS5nZXRNaWxsaXNlY29uZHMoKSAtIGRhdGUuZ2V0U2Vjb25kcygpICogZHVyYXRpb25TZWNvbmQgLSBkYXRlLmdldE1pbnV0ZXMoKSAqIGR1cmF0aW9uTWludXRlKTtcbn0sIGZ1bmN0aW9uKGRhdGUsIHN0ZXApIHtcbiAgZGF0ZS5zZXRUaW1lKCtkYXRlICsgc3RlcCAqIGR1cmF0aW9uSG91cik7XG59LCBmdW5jdGlvbihzdGFydCwgZW5kKSB7XG4gIHJldHVybiAoZW5kIC0gc3RhcnQpIC8gZHVyYXRpb25Ib3VyO1xufSwgZnVuY3Rpb24oZGF0ZSkge1xuICByZXR1cm4gZGF0ZS5nZXRIb3VycygpO1xufSk7XG5cbmV4cG9ydCBkZWZhdWx0IGhvdXI7XG5leHBvcnQgdmFyIGhvdXJzID0gaG91ci5yYW5nZTtcbiJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Iiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-time/src/hour.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-time/src/interval.js":
/*!*********************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-time/src/interval.js ***!
  \*********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return newInterval; });\nvar t0 = new Date,\n    t1 = new Date;\n\nfunction newInterval(floori, offseti, count, field) {\n\n  function interval(date) {\n    return floori(date = arguments.length === 0 ? new Date : new Date(+date)), date;\n  }\n\n  interval.floor = function(date) {\n    return floori(date = new Date(+date)), date;\n  };\n\n  interval.ceil = function(date) {\n    return floori(date = new Date(date - 1)), offseti(date, 1), floori(date), date;\n  };\n\n  interval.round = function(date) {\n    var d0 = interval(date),\n        d1 = interval.ceil(date);\n    return date - d0 < d1 - date ? d0 : d1;\n  };\n\n  interval.offset = function(date, step) {\n    return offseti(date = new Date(+date), step == null ? 1 : Math.floor(step)), date;\n  };\n\n  interval.range = function(start, stop, step) {\n    var range = [], previous;\n    start = interval.ceil(start);\n    step = step == null ? 1 : Math.floor(step);\n    if (!(start < stop) || !(step > 0)) return range; // also handles Invalid Date\n    do range.push(previous = new Date(+start)), offseti(start, step), floori(start);\n    while (previous < start && start < stop);\n    return range;\n  };\n\n  interval.filter = function(test) {\n    return newInterval(function(date) {\n      if (date >= date) while (floori(date), !test(date)) date.setTime(date - 1);\n    }, function(date, step) {\n      if (date >= date) {\n        if (step < 0) while (++step <= 0) {\n          while (offseti(date, -1), !test(date)) {} // eslint-disable-line no-empty\n        } else while (--step >= 0) {\n          while (offseti(date, +1), !test(date)) {} // eslint-disable-line no-empty\n        }\n      }\n    });\n  };\n\n  if (count) {\n    interval.count = function(start, end) {\n      t0.setTime(+start), t1.setTime(+end);\n      floori(t0), floori(t1);\n      return Math.floor(count(t0, t1));\n    };\n\n    interval.every = function(step) {\n      step = Math.floor(step);\n      return !isFinite(step) || !(step > 0) ? null\n          : !(step > 1) ? interval\n          : interval.filter(field\n              ? function(d) { return field(d) % step === 0; }\n              : function(d) { return interval.count(0, d) % step === 0; });\n    };\n  }\n\n  return interval;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-time/src/interval.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-time/src/millisecond.js":
/*!************************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-time/src/millisecond.js ***!
  \************************************************************************/
/*! exports provided: default, milliseconds */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"milliseconds\", function() { return milliseconds; });\n/* harmony import */ var _interval_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./interval.js */ \"./node_modules/encodable/node_modules/d3-time/src/interval.js\");\n\n\nvar millisecond = Object(_interval_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(function() {\n  // noop\n}, function(date, step) {\n  date.setTime(+date + step);\n}, function(start, end) {\n  return end - start;\n});\n\n// An optimized implementation for this simple case.\nmillisecond.every = function(k) {\n  k = Math.floor(k);\n  if (!isFinite(k) || !(k > 0)) return null;\n  if (!(k > 1)) return millisecond;\n  return Object(_interval_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(function(date) {\n    date.setTime(Math.floor(date / k) * k);\n  }, function(date, step) {\n    date.setTime(+date + step * k);\n  }, function(start, end) {\n    return (end - start) / k;\n  });\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (millisecond);\nvar milliseconds = millisecond.range;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy10aW1lL3NyYy9taWxsaXNlY29uZC5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9lbmNvZGFibGUvbm9kZV9tb2R1bGVzL2QzLXRpbWUvc3JjL21pbGxpc2Vjb25kLmpzPzJkN2MiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IGludGVydmFsIGZyb20gXCIuL2ludGVydmFsLmpzXCI7XG5cbnZhciBtaWxsaXNlY29uZCA9IGludGVydmFsKGZ1bmN0aW9uKCkge1xuICAvLyBub29wXG59LCBmdW5jdGlvbihkYXRlLCBzdGVwKSB7XG4gIGRhdGUuc2V0VGltZSgrZGF0ZSArIHN0ZXApO1xufSwgZnVuY3Rpb24oc3RhcnQsIGVuZCkge1xuICByZXR1cm4gZW5kIC0gc3RhcnQ7XG59KTtcblxuLy8gQW4gb3B0aW1pemVkIGltcGxlbWVudGF0aW9uIGZvciB0aGlzIHNpbXBsZSBjYXNlLlxubWlsbGlzZWNvbmQuZXZlcnkgPSBmdW5jdGlvbihrKSB7XG4gIGsgPSBNYXRoLmZsb29yKGspO1xuICBpZiAoIWlzRmluaXRlKGspIHx8ICEoayA+IDApKSByZXR1cm4gbnVsbDtcbiAgaWYgKCEoayA+IDEpKSByZXR1cm4gbWlsbGlzZWNvbmQ7XG4gIHJldHVybiBpbnRlcnZhbChmdW5jdGlvbihkYXRlKSB7XG4gICAgZGF0ZS5zZXRUaW1lKE1hdGguZmxvb3IoZGF0ZSAvIGspICogayk7XG4gIH0sIGZ1bmN0aW9uKGRhdGUsIHN0ZXApIHtcbiAgICBkYXRlLnNldFRpbWUoK2RhdGUgKyBzdGVwICogayk7XG4gIH0sIGZ1bmN0aW9uKHN0YXJ0LCBlbmQpIHtcbiAgICByZXR1cm4gKGVuZCAtIHN0YXJ0KSAvIGs7XG4gIH0pO1xufTtcblxuZXhwb3J0IGRlZmF1bHQgbWlsbGlzZWNvbmQ7XG5leHBvcnQgdmFyIG1pbGxpc2Vjb25kcyA9IG1pbGxpc2Vjb25kLnJhbmdlO1xuIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOyIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-time/src/millisecond.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-time/src/minute.js":
/*!*******************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-time/src/minute.js ***!
  \*******************************************************************/
/*! exports provided: default, minutes */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"minutes\", function() { return minutes; });\n/* harmony import */ var _interval_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./interval.js */ \"./node_modules/encodable/node_modules/d3-time/src/interval.js\");\n/* harmony import */ var _duration_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./duration.js */ \"./node_modules/encodable/node_modules/d3-time/src/duration.js\");\n\n\n\nvar minute = Object(_interval_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(function(date) {\n  date.setTime(date - date.getMilliseconds() - date.getSeconds() * _duration_js__WEBPACK_IMPORTED_MODULE_1__[\"durationSecond\"]);\n}, function(date, step) {\n  date.setTime(+date + step * _duration_js__WEBPACK_IMPORTED_MODULE_1__[\"durationMinute\"]);\n}, function(start, end) {\n  return (end - start) / _duration_js__WEBPACK_IMPORTED_MODULE_1__[\"durationMinute\"];\n}, function(date) {\n  return date.getMinutes();\n});\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (minute);\nvar minutes = minute.range;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy10aW1lL3NyYy9taW51dGUuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy10aW1lL3NyYy9taW51dGUuanM/ODdjNyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgaW50ZXJ2YWwgZnJvbSBcIi4vaW50ZXJ2YWwuanNcIjtcbmltcG9ydCB7ZHVyYXRpb25NaW51dGUsIGR1cmF0aW9uU2Vjb25kfSBmcm9tIFwiLi9kdXJhdGlvbi5qc1wiO1xuXG52YXIgbWludXRlID0gaW50ZXJ2YWwoZnVuY3Rpb24oZGF0ZSkge1xuICBkYXRlLnNldFRpbWUoZGF0ZSAtIGRhdGUuZ2V0TWlsbGlzZWNvbmRzKCkgLSBkYXRlLmdldFNlY29uZHMoKSAqIGR1cmF0aW9uU2Vjb25kKTtcbn0sIGZ1bmN0aW9uKGRhdGUsIHN0ZXApIHtcbiAgZGF0ZS5zZXRUaW1lKCtkYXRlICsgc3RlcCAqIGR1cmF0aW9uTWludXRlKTtcbn0sIGZ1bmN0aW9uKHN0YXJ0LCBlbmQpIHtcbiAgcmV0dXJuIChlbmQgLSBzdGFydCkgLyBkdXJhdGlvbk1pbnV0ZTtcbn0sIGZ1bmN0aW9uKGRhdGUpIHtcbiAgcmV0dXJuIGRhdGUuZ2V0TWludXRlcygpO1xufSk7XG5cbmV4cG9ydCBkZWZhdWx0IG1pbnV0ZTtcbmV4cG9ydCB2YXIgbWludXRlcyA9IG1pbnV0ZS5yYW5nZTtcbiJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Iiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-time/src/minute.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-time/src/month.js":
/*!******************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-time/src/month.js ***!
  \******************************************************************/
/*! exports provided: default, months */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"months\", function() { return months; });\n/* harmony import */ var _interval_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./interval.js */ \"./node_modules/encodable/node_modules/d3-time/src/interval.js\");\n\n\nvar month = Object(_interval_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(function(date) {\n  date.setDate(1);\n  date.setHours(0, 0, 0, 0);\n}, function(date, step) {\n  date.setMonth(date.getMonth() + step);\n}, function(start, end) {\n  return end.getMonth() - start.getMonth() + (end.getFullYear() - start.getFullYear()) * 12;\n}, function(date) {\n  return date.getMonth();\n});\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (month);\nvar months = month.range;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy10aW1lL3NyYy9tb250aC5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9lbmNvZGFibGUvbm9kZV9tb2R1bGVzL2QzLXRpbWUvc3JjL21vbnRoLmpzPzNkMGYiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IGludGVydmFsIGZyb20gXCIuL2ludGVydmFsLmpzXCI7XG5cbnZhciBtb250aCA9IGludGVydmFsKGZ1bmN0aW9uKGRhdGUpIHtcbiAgZGF0ZS5zZXREYXRlKDEpO1xuICBkYXRlLnNldEhvdXJzKDAsIDAsIDAsIDApO1xufSwgZnVuY3Rpb24oZGF0ZSwgc3RlcCkge1xuICBkYXRlLnNldE1vbnRoKGRhdGUuZ2V0TW9udGgoKSArIHN0ZXApO1xufSwgZnVuY3Rpb24oc3RhcnQsIGVuZCkge1xuICByZXR1cm4gZW5kLmdldE1vbnRoKCkgLSBzdGFydC5nZXRNb250aCgpICsgKGVuZC5nZXRGdWxsWWVhcigpIC0gc3RhcnQuZ2V0RnVsbFllYXIoKSkgKiAxMjtcbn0sIGZ1bmN0aW9uKGRhdGUpIHtcbiAgcmV0dXJuIGRhdGUuZ2V0TW9udGgoKTtcbn0pO1xuXG5leHBvcnQgZGVmYXVsdCBtb250aDtcbmV4cG9ydCB2YXIgbW9udGhzID0gbW9udGgucmFuZ2U7XG4iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTsiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-time/src/month.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-time/src/second.js":
/*!*******************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-time/src/second.js ***!
  \*******************************************************************/
/*! exports provided: default, seconds */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"seconds\", function() { return seconds; });\n/* harmony import */ var _interval_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./interval.js */ \"./node_modules/encodable/node_modules/d3-time/src/interval.js\");\n/* harmony import */ var _duration_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./duration.js */ \"./node_modules/encodable/node_modules/d3-time/src/duration.js\");\n\n\n\nvar second = Object(_interval_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(function(date) {\n  date.setTime(date - date.getMilliseconds());\n}, function(date, step) {\n  date.setTime(+date + step * _duration_js__WEBPACK_IMPORTED_MODULE_1__[\"durationSecond\"]);\n}, function(start, end) {\n  return (end - start) / _duration_js__WEBPACK_IMPORTED_MODULE_1__[\"durationSecond\"];\n}, function(date) {\n  return date.getUTCSeconds();\n});\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (second);\nvar seconds = second.range;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy10aW1lL3NyYy9zZWNvbmQuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy10aW1lL3NyYy9zZWNvbmQuanM/NjMzOCJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgaW50ZXJ2YWwgZnJvbSBcIi4vaW50ZXJ2YWwuanNcIjtcbmltcG9ydCB7ZHVyYXRpb25TZWNvbmR9IGZyb20gXCIuL2R1cmF0aW9uLmpzXCI7XG5cbnZhciBzZWNvbmQgPSBpbnRlcnZhbChmdW5jdGlvbihkYXRlKSB7XG4gIGRhdGUuc2V0VGltZShkYXRlIC0gZGF0ZS5nZXRNaWxsaXNlY29uZHMoKSk7XG59LCBmdW5jdGlvbihkYXRlLCBzdGVwKSB7XG4gIGRhdGUuc2V0VGltZSgrZGF0ZSArIHN0ZXAgKiBkdXJhdGlvblNlY29uZCk7XG59LCBmdW5jdGlvbihzdGFydCwgZW5kKSB7XG4gIHJldHVybiAoZW5kIC0gc3RhcnQpIC8gZHVyYXRpb25TZWNvbmQ7XG59LCBmdW5jdGlvbihkYXRlKSB7XG4gIHJldHVybiBkYXRlLmdldFVUQ1NlY29uZHMoKTtcbn0pO1xuXG5leHBvcnQgZGVmYXVsdCBzZWNvbmQ7XG5leHBvcnQgdmFyIHNlY29uZHMgPSBzZWNvbmQucmFuZ2U7XG4iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOyIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-time/src/second.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-time/src/utcDay.js":
/*!*******************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-time/src/utcDay.js ***!
  \*******************************************************************/
/*! exports provided: default, utcDays */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"utcDays\", function() { return utcDays; });\n/* harmony import */ var _interval_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./interval.js */ \"./node_modules/encodable/node_modules/d3-time/src/interval.js\");\n/* harmony import */ var _duration_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./duration.js */ \"./node_modules/encodable/node_modules/d3-time/src/duration.js\");\n\n\n\nvar utcDay = Object(_interval_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(function(date) {\n  date.setUTCHours(0, 0, 0, 0);\n}, function(date, step) {\n  date.setUTCDate(date.getUTCDate() + step);\n}, function(start, end) {\n  return (end - start) / _duration_js__WEBPACK_IMPORTED_MODULE_1__[\"durationDay\"];\n}, function(date) {\n  return date.getUTCDate() - 1;\n});\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (utcDay);\nvar utcDays = utcDay.range;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy10aW1lL3NyYy91dGNEYXkuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy10aW1lL3NyYy91dGNEYXkuanM/YjY0ZiJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgaW50ZXJ2YWwgZnJvbSBcIi4vaW50ZXJ2YWwuanNcIjtcbmltcG9ydCB7ZHVyYXRpb25EYXl9IGZyb20gXCIuL2R1cmF0aW9uLmpzXCI7XG5cbnZhciB1dGNEYXkgPSBpbnRlcnZhbChmdW5jdGlvbihkYXRlKSB7XG4gIGRhdGUuc2V0VVRDSG91cnMoMCwgMCwgMCwgMCk7XG59LCBmdW5jdGlvbihkYXRlLCBzdGVwKSB7XG4gIGRhdGUuc2V0VVRDRGF0ZShkYXRlLmdldFVUQ0RhdGUoKSArIHN0ZXApO1xufSwgZnVuY3Rpb24oc3RhcnQsIGVuZCkge1xuICByZXR1cm4gKGVuZCAtIHN0YXJ0KSAvIGR1cmF0aW9uRGF5O1xufSwgZnVuY3Rpb24oZGF0ZSkge1xuICByZXR1cm4gZGF0ZS5nZXRVVENEYXRlKCkgLSAxO1xufSk7XG5cbmV4cG9ydCBkZWZhdWx0IHV0Y0RheTtcbmV4cG9ydCB2YXIgdXRjRGF5cyA9IHV0Y0RheS5yYW5nZTtcbiJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Iiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-time/src/utcDay.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-time/src/utcHour.js":
/*!********************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-time/src/utcHour.js ***!
  \********************************************************************/
/*! exports provided: default, utcHours */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"utcHours\", function() { return utcHours; });\n/* harmony import */ var _interval_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./interval.js */ \"./node_modules/encodable/node_modules/d3-time/src/interval.js\");\n/* harmony import */ var _duration_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./duration.js */ \"./node_modules/encodable/node_modules/d3-time/src/duration.js\");\n\n\n\nvar utcHour = Object(_interval_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(function(date) {\n  date.setUTCMinutes(0, 0, 0);\n}, function(date, step) {\n  date.setTime(+date + step * _duration_js__WEBPACK_IMPORTED_MODULE_1__[\"durationHour\"]);\n}, function(start, end) {\n  return (end - start) / _duration_js__WEBPACK_IMPORTED_MODULE_1__[\"durationHour\"];\n}, function(date) {\n  return date.getUTCHours();\n});\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (utcHour);\nvar utcHours = utcHour.range;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy10aW1lL3NyYy91dGNIb3VyLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9ub2RlX21vZHVsZXMvZDMtdGltZS9zcmMvdXRjSG91ci5qcz8wNDIwIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBpbnRlcnZhbCBmcm9tIFwiLi9pbnRlcnZhbC5qc1wiO1xuaW1wb3J0IHtkdXJhdGlvbkhvdXJ9IGZyb20gXCIuL2R1cmF0aW9uLmpzXCI7XG5cbnZhciB1dGNIb3VyID0gaW50ZXJ2YWwoZnVuY3Rpb24oZGF0ZSkge1xuICBkYXRlLnNldFVUQ01pbnV0ZXMoMCwgMCwgMCk7XG59LCBmdW5jdGlvbihkYXRlLCBzdGVwKSB7XG4gIGRhdGUuc2V0VGltZSgrZGF0ZSArIHN0ZXAgKiBkdXJhdGlvbkhvdXIpO1xufSwgZnVuY3Rpb24oc3RhcnQsIGVuZCkge1xuICByZXR1cm4gKGVuZCAtIHN0YXJ0KSAvIGR1cmF0aW9uSG91cjtcbn0sIGZ1bmN0aW9uKGRhdGUpIHtcbiAgcmV0dXJuIGRhdGUuZ2V0VVRDSG91cnMoKTtcbn0pO1xuXG5leHBvcnQgZGVmYXVsdCB1dGNIb3VyO1xuZXhwb3J0IHZhciB1dGNIb3VycyA9IHV0Y0hvdXIucmFuZ2U7XG4iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOyIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-time/src/utcHour.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-time/src/utcMinute.js":
/*!**********************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-time/src/utcMinute.js ***!
  \**********************************************************************/
/*! exports provided: default, utcMinutes */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"utcMinutes\", function() { return utcMinutes; });\n/* harmony import */ var _interval_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./interval.js */ \"./node_modules/encodable/node_modules/d3-time/src/interval.js\");\n/* harmony import */ var _duration_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./duration.js */ \"./node_modules/encodable/node_modules/d3-time/src/duration.js\");\n\n\n\nvar utcMinute = Object(_interval_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(function(date) {\n  date.setUTCSeconds(0, 0);\n}, function(date, step) {\n  date.setTime(+date + step * _duration_js__WEBPACK_IMPORTED_MODULE_1__[\"durationMinute\"]);\n}, function(start, end) {\n  return (end - start) / _duration_js__WEBPACK_IMPORTED_MODULE_1__[\"durationMinute\"];\n}, function(date) {\n  return date.getUTCMinutes();\n});\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (utcMinute);\nvar utcMinutes = utcMinute.range;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy10aW1lL3NyYy91dGNNaW51dGUuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy10aW1lL3NyYy91dGNNaW51dGUuanM/ZDQyMyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgaW50ZXJ2YWwgZnJvbSBcIi4vaW50ZXJ2YWwuanNcIjtcbmltcG9ydCB7ZHVyYXRpb25NaW51dGV9IGZyb20gXCIuL2R1cmF0aW9uLmpzXCI7XG5cbnZhciB1dGNNaW51dGUgPSBpbnRlcnZhbChmdW5jdGlvbihkYXRlKSB7XG4gIGRhdGUuc2V0VVRDU2Vjb25kcygwLCAwKTtcbn0sIGZ1bmN0aW9uKGRhdGUsIHN0ZXApIHtcbiAgZGF0ZS5zZXRUaW1lKCtkYXRlICsgc3RlcCAqIGR1cmF0aW9uTWludXRlKTtcbn0sIGZ1bmN0aW9uKHN0YXJ0LCBlbmQpIHtcbiAgcmV0dXJuIChlbmQgLSBzdGFydCkgLyBkdXJhdGlvbk1pbnV0ZTtcbn0sIGZ1bmN0aW9uKGRhdGUpIHtcbiAgcmV0dXJuIGRhdGUuZ2V0VVRDTWludXRlcygpO1xufSk7XG5cbmV4cG9ydCBkZWZhdWx0IHV0Y01pbnV0ZTtcbmV4cG9ydCB2YXIgdXRjTWludXRlcyA9IHV0Y01pbnV0ZS5yYW5nZTtcbiJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Iiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-time/src/utcMinute.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-time/src/utcMonth.js":
/*!*********************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-time/src/utcMonth.js ***!
  \*********************************************************************/
/*! exports provided: default, utcMonths */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"utcMonths\", function() { return utcMonths; });\n/* harmony import */ var _interval_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./interval.js */ \"./node_modules/encodable/node_modules/d3-time/src/interval.js\");\n\n\nvar utcMonth = Object(_interval_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(function(date) {\n  date.setUTCDate(1);\n  date.setUTCHours(0, 0, 0, 0);\n}, function(date, step) {\n  date.setUTCMonth(date.getUTCMonth() + step);\n}, function(start, end) {\n  return end.getUTCMonth() - start.getUTCMonth() + (end.getUTCFullYear() - start.getUTCFullYear()) * 12;\n}, function(date) {\n  return date.getUTCMonth();\n});\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (utcMonth);\nvar utcMonths = utcMonth.range;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy10aW1lL3NyYy91dGNNb250aC5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9lbmNvZGFibGUvbm9kZV9tb2R1bGVzL2QzLXRpbWUvc3JjL3V0Y01vbnRoLmpzP2M5NTYiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IGludGVydmFsIGZyb20gXCIuL2ludGVydmFsLmpzXCI7XG5cbnZhciB1dGNNb250aCA9IGludGVydmFsKGZ1bmN0aW9uKGRhdGUpIHtcbiAgZGF0ZS5zZXRVVENEYXRlKDEpO1xuICBkYXRlLnNldFVUQ0hvdXJzKDAsIDAsIDAsIDApO1xufSwgZnVuY3Rpb24oZGF0ZSwgc3RlcCkge1xuICBkYXRlLnNldFVUQ01vbnRoKGRhdGUuZ2V0VVRDTW9udGgoKSArIHN0ZXApO1xufSwgZnVuY3Rpb24oc3RhcnQsIGVuZCkge1xuICByZXR1cm4gZW5kLmdldFVUQ01vbnRoKCkgLSBzdGFydC5nZXRVVENNb250aCgpICsgKGVuZC5nZXRVVENGdWxsWWVhcigpIC0gc3RhcnQuZ2V0VVRDRnVsbFllYXIoKSkgKiAxMjtcbn0sIGZ1bmN0aW9uKGRhdGUpIHtcbiAgcmV0dXJuIGRhdGUuZ2V0VVRDTW9udGgoKTtcbn0pO1xuXG5leHBvcnQgZGVmYXVsdCB1dGNNb250aDtcbmV4cG9ydCB2YXIgdXRjTW9udGhzID0gdXRjTW9udGgucmFuZ2U7XG4iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTsiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-time/src/utcMonth.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-time/src/utcWeek.js":
/*!********************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-time/src/utcWeek.js ***!
  \********************************************************************/
/*! exports provided: utcSunday, utcMonday, utcTuesday, utcWednesday, utcThursday, utcFriday, utcSaturday, utcSundays, utcMondays, utcTuesdays, utcWednesdays, utcThursdays, utcFridays, utcSaturdays */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"utcSunday\", function() { return utcSunday; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"utcMonday\", function() { return utcMonday; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"utcTuesday\", function() { return utcTuesday; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"utcWednesday\", function() { return utcWednesday; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"utcThursday\", function() { return utcThursday; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"utcFriday\", function() { return utcFriday; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"utcSaturday\", function() { return utcSaturday; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"utcSundays\", function() { return utcSundays; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"utcMondays\", function() { return utcMondays; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"utcTuesdays\", function() { return utcTuesdays; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"utcWednesdays\", function() { return utcWednesdays; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"utcThursdays\", function() { return utcThursdays; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"utcFridays\", function() { return utcFridays; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"utcSaturdays\", function() { return utcSaturdays; });\n/* harmony import */ var _interval_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./interval.js */ \"./node_modules/encodable/node_modules/d3-time/src/interval.js\");\n/* harmony import */ var _duration_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./duration.js */ \"./node_modules/encodable/node_modules/d3-time/src/duration.js\");\n\n\n\nfunction utcWeekday(i) {\n  return Object(_interval_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(function(date) {\n    date.setUTCDate(date.getUTCDate() - (date.getUTCDay() + 7 - i) % 7);\n    date.setUTCHours(0, 0, 0, 0);\n  }, function(date, step) {\n    date.setUTCDate(date.getUTCDate() + step * 7);\n  }, function(start, end) {\n    return (end - start) / _duration_js__WEBPACK_IMPORTED_MODULE_1__[\"durationWeek\"];\n  });\n}\n\nvar utcSunday = utcWeekday(0);\nvar utcMonday = utcWeekday(1);\nvar utcTuesday = utcWeekday(2);\nvar utcWednesday = utcWeekday(3);\nvar utcThursday = utcWeekday(4);\nvar utcFriday = utcWeekday(5);\nvar utcSaturday = utcWeekday(6);\n\nvar utcSundays = utcSunday.range;\nvar utcMondays = utcMonday.range;\nvar utcTuesdays = utcTuesday.range;\nvar utcWednesdays = utcWednesday.range;\nvar utcThursdays = utcThursday.range;\nvar utcFridays = utcFriday.range;\nvar utcSaturdays = utcSaturday.range;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy10aW1lL3NyYy91dGNXZWVrLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9ub2RlX21vZHVsZXMvZDMtdGltZS9zcmMvdXRjV2Vlay5qcz80YjcxIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBpbnRlcnZhbCBmcm9tIFwiLi9pbnRlcnZhbC5qc1wiO1xuaW1wb3J0IHtkdXJhdGlvbldlZWt9IGZyb20gXCIuL2R1cmF0aW9uLmpzXCI7XG5cbmZ1bmN0aW9uIHV0Y1dlZWtkYXkoaSkge1xuICByZXR1cm4gaW50ZXJ2YWwoZnVuY3Rpb24oZGF0ZSkge1xuICAgIGRhdGUuc2V0VVRDRGF0ZShkYXRlLmdldFVUQ0RhdGUoKSAtIChkYXRlLmdldFVUQ0RheSgpICsgNyAtIGkpICUgNyk7XG4gICAgZGF0ZS5zZXRVVENIb3VycygwLCAwLCAwLCAwKTtcbiAgfSwgZnVuY3Rpb24oZGF0ZSwgc3RlcCkge1xuICAgIGRhdGUuc2V0VVRDRGF0ZShkYXRlLmdldFVUQ0RhdGUoKSArIHN0ZXAgKiA3KTtcbiAgfSwgZnVuY3Rpb24oc3RhcnQsIGVuZCkge1xuICAgIHJldHVybiAoZW5kIC0gc3RhcnQpIC8gZHVyYXRpb25XZWVrO1xuICB9KTtcbn1cblxuZXhwb3J0IHZhciB1dGNTdW5kYXkgPSB1dGNXZWVrZGF5KDApO1xuZXhwb3J0IHZhciB1dGNNb25kYXkgPSB1dGNXZWVrZGF5KDEpO1xuZXhwb3J0IHZhciB1dGNUdWVzZGF5ID0gdXRjV2Vla2RheSgyKTtcbmV4cG9ydCB2YXIgdXRjV2VkbmVzZGF5ID0gdXRjV2Vla2RheSgzKTtcbmV4cG9ydCB2YXIgdXRjVGh1cnNkYXkgPSB1dGNXZWVrZGF5KDQpO1xuZXhwb3J0IHZhciB1dGNGcmlkYXkgPSB1dGNXZWVrZGF5KDUpO1xuZXhwb3J0IHZhciB1dGNTYXR1cmRheSA9IHV0Y1dlZWtkYXkoNik7XG5cbmV4cG9ydCB2YXIgdXRjU3VuZGF5cyA9IHV0Y1N1bmRheS5yYW5nZTtcbmV4cG9ydCB2YXIgdXRjTW9uZGF5cyA9IHV0Y01vbmRheS5yYW5nZTtcbmV4cG9ydCB2YXIgdXRjVHVlc2RheXMgPSB1dGNUdWVzZGF5LnJhbmdlO1xuZXhwb3J0IHZhciB1dGNXZWRuZXNkYXlzID0gdXRjV2VkbmVzZGF5LnJhbmdlO1xuZXhwb3J0IHZhciB1dGNUaHVyc2RheXMgPSB1dGNUaHVyc2RheS5yYW5nZTtcbmV4cG9ydCB2YXIgdXRjRnJpZGF5cyA9IHV0Y0ZyaWRheS5yYW5nZTtcbmV4cG9ydCB2YXIgdXRjU2F0dXJkYXlzID0gdXRjU2F0dXJkYXkucmFuZ2U7XG4iXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOyIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-time/src/utcWeek.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-time/src/utcYear.js":
/*!********************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-time/src/utcYear.js ***!
  \********************************************************************/
/*! exports provided: default, utcYears */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"utcYears\", function() { return utcYears; });\n/* harmony import */ var _interval_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./interval.js */ \"./node_modules/encodable/node_modules/d3-time/src/interval.js\");\n\n\nvar utcYear = Object(_interval_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(function(date) {\n  date.setUTCMonth(0, 1);\n  date.setUTCHours(0, 0, 0, 0);\n}, function(date, step) {\n  date.setUTCFullYear(date.getUTCFullYear() + step);\n}, function(start, end) {\n  return end.getUTCFullYear() - start.getUTCFullYear();\n}, function(date) {\n  return date.getUTCFullYear();\n});\n\n// An optimized implementation for this simple case.\nutcYear.every = function(k) {\n  return !isFinite(k = Math.floor(k)) || !(k > 0) ? null : Object(_interval_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(function(date) {\n    date.setUTCFullYear(Math.floor(date.getUTCFullYear() / k) * k);\n    date.setUTCMonth(0, 1);\n    date.setUTCHours(0, 0, 0, 0);\n  }, function(date, step) {\n    date.setUTCFullYear(date.getUTCFullYear() + step * k);\n  });\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (utcYear);\nvar utcYears = utcYear.range;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy10aW1lL3NyYy91dGNZZWFyLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9ub2RlX21vZHVsZXMvZDMtdGltZS9zcmMvdXRjWWVhci5qcz8zNzMyIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBpbnRlcnZhbCBmcm9tIFwiLi9pbnRlcnZhbC5qc1wiO1xuXG52YXIgdXRjWWVhciA9IGludGVydmFsKGZ1bmN0aW9uKGRhdGUpIHtcbiAgZGF0ZS5zZXRVVENNb250aCgwLCAxKTtcbiAgZGF0ZS5zZXRVVENIb3VycygwLCAwLCAwLCAwKTtcbn0sIGZ1bmN0aW9uKGRhdGUsIHN0ZXApIHtcbiAgZGF0ZS5zZXRVVENGdWxsWWVhcihkYXRlLmdldFVUQ0Z1bGxZZWFyKCkgKyBzdGVwKTtcbn0sIGZ1bmN0aW9uKHN0YXJ0LCBlbmQpIHtcbiAgcmV0dXJuIGVuZC5nZXRVVENGdWxsWWVhcigpIC0gc3RhcnQuZ2V0VVRDRnVsbFllYXIoKTtcbn0sIGZ1bmN0aW9uKGRhdGUpIHtcbiAgcmV0dXJuIGRhdGUuZ2V0VVRDRnVsbFllYXIoKTtcbn0pO1xuXG4vLyBBbiBvcHRpbWl6ZWQgaW1wbGVtZW50YXRpb24gZm9yIHRoaXMgc2ltcGxlIGNhc2UuXG51dGNZZWFyLmV2ZXJ5ID0gZnVuY3Rpb24oaykge1xuICByZXR1cm4gIWlzRmluaXRlKGsgPSBNYXRoLmZsb29yKGspKSB8fCAhKGsgPiAwKSA/IG51bGwgOiBpbnRlcnZhbChmdW5jdGlvbihkYXRlKSB7XG4gICAgZGF0ZS5zZXRVVENGdWxsWWVhcihNYXRoLmZsb29yKGRhdGUuZ2V0VVRDRnVsbFllYXIoKSAvIGspICogayk7XG4gICAgZGF0ZS5zZXRVVENNb250aCgwLCAxKTtcbiAgICBkYXRlLnNldFVUQ0hvdXJzKDAsIDAsIDAsIDApO1xuICB9LCBmdW5jdGlvbihkYXRlLCBzdGVwKSB7XG4gICAgZGF0ZS5zZXRVVENGdWxsWWVhcihkYXRlLmdldFVUQ0Z1bGxZZWFyKCkgKyBzdGVwICogayk7XG4gIH0pO1xufTtcblxuZXhwb3J0IGRlZmF1bHQgdXRjWWVhcjtcbmV4cG9ydCB2YXIgdXRjWWVhcnMgPSB1dGNZZWFyLnJhbmdlO1xuIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOyIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-time/src/utcYear.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-time/src/week.js":
/*!*****************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-time/src/week.js ***!
  \*****************************************************************/
/*! exports provided: sunday, monday, tuesday, wednesday, thursday, friday, saturday, sundays, mondays, tuesdays, wednesdays, thursdays, fridays, saturdays */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"sunday\", function() { return sunday; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"monday\", function() { return monday; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"tuesday\", function() { return tuesday; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"wednesday\", function() { return wednesday; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"thursday\", function() { return thursday; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"friday\", function() { return friday; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"saturday\", function() { return saturday; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"sundays\", function() { return sundays; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"mondays\", function() { return mondays; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"tuesdays\", function() { return tuesdays; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"wednesdays\", function() { return wednesdays; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"thursdays\", function() { return thursdays; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"fridays\", function() { return fridays; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"saturdays\", function() { return saturdays; });\n/* harmony import */ var _interval_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./interval.js */ \"./node_modules/encodable/node_modules/d3-time/src/interval.js\");\n/* harmony import */ var _duration_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./duration.js */ \"./node_modules/encodable/node_modules/d3-time/src/duration.js\");\n\n\n\nfunction weekday(i) {\n  return Object(_interval_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(function(date) {\n    date.setDate(date.getDate() - (date.getDay() + 7 - i) % 7);\n    date.setHours(0, 0, 0, 0);\n  }, function(date, step) {\n    date.setDate(date.getDate() + step * 7);\n  }, function(start, end) {\n    return (end - start - (end.getTimezoneOffset() - start.getTimezoneOffset()) * _duration_js__WEBPACK_IMPORTED_MODULE_1__[\"durationMinute\"]) / _duration_js__WEBPACK_IMPORTED_MODULE_1__[\"durationWeek\"];\n  });\n}\n\nvar sunday = weekday(0);\nvar monday = weekday(1);\nvar tuesday = weekday(2);\nvar wednesday = weekday(3);\nvar thursday = weekday(4);\nvar friday = weekday(5);\nvar saturday = weekday(6);\n\nvar sundays = sunday.range;\nvar mondays = monday.range;\nvar tuesdays = tuesday.range;\nvar wednesdays = wednesday.range;\nvar thursdays = thursday.range;\nvar fridays = friday.range;\nvar saturdays = saturday.range;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy10aW1lL3NyYy93ZWVrLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9ub2RlX21vZHVsZXMvZDMtdGltZS9zcmMvd2Vlay5qcz85NjQ1Il0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBpbnRlcnZhbCBmcm9tIFwiLi9pbnRlcnZhbC5qc1wiO1xuaW1wb3J0IHtkdXJhdGlvbk1pbnV0ZSwgZHVyYXRpb25XZWVrfSBmcm9tIFwiLi9kdXJhdGlvbi5qc1wiO1xuXG5mdW5jdGlvbiB3ZWVrZGF5KGkpIHtcbiAgcmV0dXJuIGludGVydmFsKGZ1bmN0aW9uKGRhdGUpIHtcbiAgICBkYXRlLnNldERhdGUoZGF0ZS5nZXREYXRlKCkgLSAoZGF0ZS5nZXREYXkoKSArIDcgLSBpKSAlIDcpO1xuICAgIGRhdGUuc2V0SG91cnMoMCwgMCwgMCwgMCk7XG4gIH0sIGZ1bmN0aW9uKGRhdGUsIHN0ZXApIHtcbiAgICBkYXRlLnNldERhdGUoZGF0ZS5nZXREYXRlKCkgKyBzdGVwICogNyk7XG4gIH0sIGZ1bmN0aW9uKHN0YXJ0LCBlbmQpIHtcbiAgICByZXR1cm4gKGVuZCAtIHN0YXJ0IC0gKGVuZC5nZXRUaW1lem9uZU9mZnNldCgpIC0gc3RhcnQuZ2V0VGltZXpvbmVPZmZzZXQoKSkgKiBkdXJhdGlvbk1pbnV0ZSkgLyBkdXJhdGlvbldlZWs7XG4gIH0pO1xufVxuXG5leHBvcnQgdmFyIHN1bmRheSA9IHdlZWtkYXkoMCk7XG5leHBvcnQgdmFyIG1vbmRheSA9IHdlZWtkYXkoMSk7XG5leHBvcnQgdmFyIHR1ZXNkYXkgPSB3ZWVrZGF5KDIpO1xuZXhwb3J0IHZhciB3ZWRuZXNkYXkgPSB3ZWVrZGF5KDMpO1xuZXhwb3J0IHZhciB0aHVyc2RheSA9IHdlZWtkYXkoNCk7XG5leHBvcnQgdmFyIGZyaWRheSA9IHdlZWtkYXkoNSk7XG5leHBvcnQgdmFyIHNhdHVyZGF5ID0gd2Vla2RheSg2KTtcblxuZXhwb3J0IHZhciBzdW5kYXlzID0gc3VuZGF5LnJhbmdlO1xuZXhwb3J0IHZhciBtb25kYXlzID0gbW9uZGF5LnJhbmdlO1xuZXhwb3J0IHZhciB0dWVzZGF5cyA9IHR1ZXNkYXkucmFuZ2U7XG5leHBvcnQgdmFyIHdlZG5lc2RheXMgPSB3ZWRuZXNkYXkucmFuZ2U7XG5leHBvcnQgdmFyIHRodXJzZGF5cyA9IHRodXJzZGF5LnJhbmdlO1xuZXhwb3J0IHZhciBmcmlkYXlzID0gZnJpZGF5LnJhbmdlO1xuZXhwb3J0IHZhciBzYXR1cmRheXMgPSBzYXR1cmRheS5yYW5nZTtcbiJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Iiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-time/src/week.js\n");

/***/ }),

/***/ "./node_modules/encodable/node_modules/d3-time/src/year.js":
/*!*****************************************************************!*\
  !*** ./node_modules/encodable/node_modules/d3-time/src/year.js ***!
  \*****************************************************************/
/*! exports provided: default, years */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"years\", function() { return years; });\n/* harmony import */ var _interval_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./interval.js */ \"./node_modules/encodable/node_modules/d3-time/src/interval.js\");\n\n\nvar year = Object(_interval_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(function(date) {\n  date.setMonth(0, 1);\n  date.setHours(0, 0, 0, 0);\n}, function(date, step) {\n  date.setFullYear(date.getFullYear() + step);\n}, function(start, end) {\n  return end.getFullYear() - start.getFullYear();\n}, function(date) {\n  return date.getFullYear();\n});\n\n// An optimized implementation for this simple case.\nyear.every = function(k) {\n  return !isFinite(k = Math.floor(k)) || !(k > 0) ? null : Object(_interval_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(function(date) {\n    date.setFullYear(Math.floor(date.getFullYear() / k) * k);\n    date.setMonth(0, 1);\n    date.setHours(0, 0, 0, 0);\n  }, function(date, step) {\n    date.setFullYear(date.getFullYear() + step * k);\n  });\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (year);\nvar years = year.range;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZW5jb2RhYmxlL25vZGVfbW9kdWxlcy9kMy10aW1lL3NyYy95ZWFyLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2VuY29kYWJsZS9ub2RlX21vZHVsZXMvZDMtdGltZS9zcmMveWVhci5qcz9mOWQwIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBpbnRlcnZhbCBmcm9tIFwiLi9pbnRlcnZhbC5qc1wiO1xuXG52YXIgeWVhciA9IGludGVydmFsKGZ1bmN0aW9uKGRhdGUpIHtcbiAgZGF0ZS5zZXRNb250aCgwLCAxKTtcbiAgZGF0ZS5zZXRIb3VycygwLCAwLCAwLCAwKTtcbn0sIGZ1bmN0aW9uKGRhdGUsIHN0ZXApIHtcbiAgZGF0ZS5zZXRGdWxsWWVhcihkYXRlLmdldEZ1bGxZZWFyKCkgKyBzdGVwKTtcbn0sIGZ1bmN0aW9uKHN0YXJ0LCBlbmQpIHtcbiAgcmV0dXJuIGVuZC5nZXRGdWxsWWVhcigpIC0gc3RhcnQuZ2V0RnVsbFllYXIoKTtcbn0sIGZ1bmN0aW9uKGRhdGUpIHtcbiAgcmV0dXJuIGRhdGUuZ2V0RnVsbFllYXIoKTtcbn0pO1xuXG4vLyBBbiBvcHRpbWl6ZWQgaW1wbGVtZW50YXRpb24gZm9yIHRoaXMgc2ltcGxlIGNhc2UuXG55ZWFyLmV2ZXJ5ID0gZnVuY3Rpb24oaykge1xuICByZXR1cm4gIWlzRmluaXRlKGsgPSBNYXRoLmZsb29yKGspKSB8fCAhKGsgPiAwKSA/IG51bGwgOiBpbnRlcnZhbChmdW5jdGlvbihkYXRlKSB7XG4gICAgZGF0ZS5zZXRGdWxsWWVhcihNYXRoLmZsb29yKGRhdGUuZ2V0RnVsbFllYXIoKSAvIGspICogayk7XG4gICAgZGF0ZS5zZXRNb250aCgwLCAxKTtcbiAgICBkYXRlLnNldEhvdXJzKDAsIDAsIDAsIDApO1xuICB9LCBmdW5jdGlvbihkYXRlLCBzdGVwKSB7XG4gICAgZGF0ZS5zZXRGdWxsWWVhcihkYXRlLmdldEZ1bGxZZWFyKCkgKyBzdGVwICogayk7XG4gIH0pO1xufTtcblxuZXhwb3J0IGRlZmF1bHQgeWVhcjtcbmV4cG9ydCB2YXIgeWVhcnMgPSB5ZWFyLnJhbmdlO1xuIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOyIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/encodable/node_modules/d3-time/src/year.js\n");

/***/ })

}]);