(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[1],{

/***/ "./node_modules/@deck.gl/core/dist/esm/controllers/controller.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/controllers/controller.js ***!
  \***********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return Controller; });\n/* harmony import */ var _transition_manager__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./transition-manager */ \"./node_modules/@deck.gl/core/dist/esm/controllers/transition-manager.js\");\n/* harmony import */ var _transitions_linear_interpolator__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../transitions/linear-interpolator */ \"./node_modules/@deck.gl/core/dist/esm/transitions/linear-interpolator.js\");\n\n\nconst NO_TRANSITION_PROPS = {\n  transitionDuration: 0\n};\nconst LINEAR_TRANSITION_PROPS = {\n  transitionDuration: 300,\n  transitionEasing: t => t,\n  transitionInterruption: _transition_manager__WEBPACK_IMPORTED_MODULE_0__[\"TRANSITION_EVENTS\"].BREAK\n};\nconst DEFAULT_INERTIA = 300;\n\nconst INERTIA_EASING = t => 1 - (1 - t) * (1 - t);\n\nconst EVENT_TYPES = {\n  WHEEL: ['wheel'],\n  PAN: ['panstart', 'panmove', 'panend'],\n  PINCH: ['pinchstart', 'pinchmove', 'pinchend'],\n  TRIPLE_PAN: ['tripanstart', 'tripanmove', 'tripanend'],\n  DOUBLE_TAP: ['doubletap'],\n  KEYBOARD: ['keydown']\n};\nclass Controller {\n  constructor(ControllerState, options = {}) {\n    this.ControllerState = ControllerState;\n    this.controllerState = null;\n    this.controllerStateProps = null;\n    this.eventManager = null;\n    this.transitionManager = new _transition_manager__WEBPACK_IMPORTED_MODULE_0__[\"default\"](ControllerState, { ...options,\n      onViewStateChange: this._onTransition.bind(this),\n      onStateChange: this._setInteractionState.bind(this)\n    });\n    const linearTransitionProps = this.linearTransitionProps;\n    this._transition = linearTransitionProps && { ...LINEAR_TRANSITION_PROPS,\n      transitionInterpolator: new _transitions_linear_interpolator__WEBPACK_IMPORTED_MODULE_1__[\"default\"]({\n        transitionProps: linearTransitionProps\n      })\n    };\n    this._events = null;\n    this._interactionState = {\n      isDragging: false\n    };\n    this._customEvents = [];\n    this.onViewStateChange = null;\n    this.onStateChange = null;\n    this.handleEvent = this.handleEvent.bind(this);\n    this.setProps(options);\n  }\n\n  get linearTransitionProps() {\n    return null;\n  }\n\n  set events(customEvents) {\n    this.toggleEvents(this._customEvents, false);\n    this.toggleEvents(customEvents, true);\n    this._customEvents = customEvents;\n    this.setProps(this.controllerStateProps);\n  }\n\n  finalize() {\n    for (const eventName in this._events) {\n      if (this._events[eventName]) {\n        this.eventManager.off(eventName, this.handleEvent);\n      }\n    }\n\n    this.transitionManager.finalize();\n  }\n\n  handleEvent(event) {\n    const {\n      ControllerState\n    } = this;\n    this.controllerState = new ControllerState({\n      makeViewport: this.makeViewport,\n      ...this.controllerStateProps,\n      ...this._state\n    });\n    const eventStartBlocked = this._eventStartBlocked;\n\n    switch (event.type) {\n      case 'panstart':\n        return eventStartBlocked ? false : this._onPanStart(event);\n\n      case 'panmove':\n        return this._onPan(event);\n\n      case 'panend':\n        return this._onPanEnd(event);\n\n      case 'pinchstart':\n        return eventStartBlocked ? false : this._onPinchStart(event);\n\n      case 'pinchmove':\n        return this._onPinch(event);\n\n      case 'pinchend':\n        return this._onPinchEnd(event);\n\n      case 'tripanstart':\n        return eventStartBlocked ? false : this._onTriplePanStart(event);\n\n      case 'tripanmove':\n        return this._onTriplePan(event);\n\n      case 'tripanend':\n        return this._onTriplePanEnd(event);\n\n      case 'doubletap':\n        return this._onDoubleTap(event);\n\n      case 'wheel':\n        return this._onWheel(event);\n\n      case 'keydown':\n        return this._onKeyDown(event);\n\n      default:\n        return false;\n    }\n  }\n\n  getCenter(event) {\n    const {\n      x,\n      y\n    } = this.controllerStateProps;\n    const {\n      offsetCenter\n    } = event;\n    return [offsetCenter.x - x, offsetCenter.y - y];\n  }\n\n  isPointInBounds(pos, event) {\n    const {\n      width,\n      height\n    } = this.controllerStateProps;\n\n    if (event && event.handled) {\n      return false;\n    }\n\n    const inside = pos[0] >= 0 && pos[0] <= width && pos[1] >= 0 && pos[1] <= height;\n\n    if (inside && event) {\n      event.stopPropagation();\n    }\n\n    return inside;\n  }\n\n  isFunctionKeyPressed(event) {\n    const {\n      srcEvent\n    } = event;\n    return Boolean(srcEvent.metaKey || srcEvent.altKey || srcEvent.ctrlKey || srcEvent.shiftKey);\n  }\n\n  isDragging() {\n    return this._interactionState.isDragging;\n  }\n\n  blockEvents(timeout) {\n    const timer = setTimeout(() => {\n      if (this._eventStartBlocked === timer) {\n        this._eventStartBlocked = null;\n      }\n    }, timeout);\n    this._eventStartBlocked = timer;\n  }\n\n  setProps(props) {\n    if ('onViewStateChange' in props) {\n      this.onViewStateChange = props.onViewStateChange;\n    }\n\n    if ('onStateChange' in props) {\n      this.onStateChange = props.onStateChange;\n    }\n\n    if ('makeViewport' in props) {\n      this.makeViewport = props.makeViewport;\n    }\n\n    if ('dragMode' in props) {\n      this.dragMode = props.dragMode;\n    }\n\n    this.controllerStateProps = props;\n\n    if ('eventManager' in props && this.eventManager !== props.eventManager) {\n      this.eventManager = props.eventManager;\n      this._events = {};\n      this.toggleEvents(this._customEvents, true);\n    }\n\n    if (!('transitionInterpolator' in props)) {\n      props.transitionInterpolator = this._getTransitionProps().transitionInterpolator;\n    }\n\n    this.transitionManager.processViewStateChange(props);\n    let {\n      inertia\n    } = props;\n\n    if (inertia === true) {\n      inertia = DEFAULT_INERTIA;\n    }\n\n    this.inertia = inertia;\n    const {\n      scrollZoom = true,\n      dragPan = true,\n      dragRotate = true,\n      doubleClickZoom = true,\n      touchZoom = true,\n      touchRotate = false,\n      keyboard = true\n    } = props;\n    const isInteractive = Boolean(this.onViewStateChange);\n    this.toggleEvents(EVENT_TYPES.WHEEL, isInteractive && scrollZoom);\n    this.toggleEvents(EVENT_TYPES.PAN, isInteractive && (dragPan || dragRotate));\n    this.toggleEvents(EVENT_TYPES.PINCH, isInteractive && (touchZoom || touchRotate));\n    this.toggleEvents(EVENT_TYPES.TRIPLE_PAN, isInteractive && touchRotate);\n    this.toggleEvents(EVENT_TYPES.DOUBLE_TAP, isInteractive && doubleClickZoom);\n    this.toggleEvents(EVENT_TYPES.KEYBOARD, isInteractive && keyboard);\n    this.scrollZoom = scrollZoom;\n    this.dragPan = dragPan;\n    this.dragRotate = dragRotate;\n    this.doubleClickZoom = doubleClickZoom;\n    this.touchZoom = touchZoom;\n    this.touchRotate = touchRotate;\n    this.keyboard = keyboard;\n  }\n\n  updateTransition() {\n    this.transitionManager.updateTransition();\n  }\n\n  toggleEvents(eventNames, enabled) {\n    if (this.eventManager) {\n      eventNames.forEach(eventName => {\n        if (this._events[eventName] !== enabled) {\n          this._events[eventName] = enabled;\n\n          if (enabled) {\n            this.eventManager.on(eventName, this.handleEvent);\n          } else {\n            this.eventManager.off(eventName, this.handleEvent);\n          }\n        }\n      });\n    }\n  }\n\n  updateViewport(newControllerState, extraProps = {}, interactionState = {}) {\n    const viewState = { ...newControllerState.getViewportProps(),\n      ...extraProps\n    };\n    const changed = this.controllerState !== newControllerState;\n    this._state = newControllerState.getState();\n\n    this._setInteractionState(interactionState);\n\n    if (changed) {\n      const oldViewState = this.controllerState ? this.controllerState.getViewportProps() : null;\n\n      if (this.onViewStateChange) {\n        this.onViewStateChange({\n          viewState,\n          interactionState: this._interactionState,\n          oldViewState\n        });\n      }\n    }\n  }\n\n  _onTransition(params) {\n    if (this.onViewStateChange) {\n      params.interactionState = this._interactionState;\n      this.onViewStateChange(params);\n    }\n  }\n\n  _setInteractionState(newStates) {\n    Object.assign(this._interactionState, newStates);\n\n    if (this.onStateChange) {\n      this.onStateChange(this._interactionState);\n    }\n  }\n\n  _onPanStart(event) {\n    const pos = this.getCenter(event);\n\n    if (!this.isPointInBounds(pos, event)) {\n      return false;\n    }\n\n    let alternateMode = this.isFunctionKeyPressed(event) || event.rightButton;\n\n    if (this.invertPan || this.dragMode === 'pan') {\n      alternateMode = !alternateMode;\n    }\n\n    const newControllerState = this.controllerState[alternateMode ? 'panStart' : 'rotateStart']({\n      pos\n    });\n    this._panMove = alternateMode;\n    this.updateViewport(newControllerState, NO_TRANSITION_PROPS, {\n      isDragging: true\n    });\n    return true;\n  }\n\n  _onPan(event) {\n    if (!this.isDragging()) {\n      return false;\n    }\n\n    return this._panMove ? this._onPanMove(event) : this._onPanRotate(event);\n  }\n\n  _onPanEnd(event) {\n    if (!this.isDragging()) {\n      return false;\n    }\n\n    return this._panMove ? this._onPanMoveEnd(event) : this._onPanRotateEnd(event);\n  }\n\n  _onPanMove(event) {\n    if (!this.dragPan) {\n      return false;\n    }\n\n    const pos = this.getCenter(event);\n    const newControllerState = this.controllerState.pan({\n      pos\n    });\n    this.updateViewport(newControllerState, NO_TRANSITION_PROPS, {\n      isDragging: true,\n      isPanning: true\n    });\n    return true;\n  }\n\n  _onPanMoveEnd(event) {\n    const {\n      inertia\n    } = this;\n\n    if (this.dragPan && inertia && event.velocity) {\n      const pos = this.getCenter(event);\n      const endPos = [pos[0] + event.velocityX * inertia / 2, pos[1] + event.velocityY * inertia / 2];\n      const newControllerState = this.controllerState.pan({\n        pos: endPos\n      }).panEnd();\n      this.updateViewport(newControllerState, { ...this._getTransitionProps(),\n        transitionDuration: inertia,\n        transitionEasing: INERTIA_EASING\n      }, {\n        isDragging: false,\n        isPanning: true\n      });\n    } else {\n      const newControllerState = this.controllerState.panEnd();\n      this.updateViewport(newControllerState, null, {\n        isDragging: false,\n        isPanning: false\n      });\n    }\n\n    return true;\n  }\n\n  _onPanRotate(event) {\n    if (!this.dragRotate) {\n      return false;\n    }\n\n    const pos = this.getCenter(event);\n    const newControllerState = this.controllerState.rotate({\n      pos\n    });\n    this.updateViewport(newControllerState, NO_TRANSITION_PROPS, {\n      isDragging: true,\n      isRotating: true\n    });\n    return true;\n  }\n\n  _onPanRotateEnd(event) {\n    const {\n      inertia\n    } = this;\n\n    if (this.dragRotate && inertia && event.velocity) {\n      const pos = this.getCenter(event);\n      const endPos = [pos[0] + event.velocityX * inertia / 2, pos[1] + event.velocityY * inertia / 2];\n      const newControllerState = this.controllerState.rotate({\n        pos: endPos\n      }).rotateEnd();\n      this.updateViewport(newControllerState, { ...this._getTransitionProps(),\n        transitionDuration: inertia,\n        transitionEasing: INERTIA_EASING\n      }, {\n        isDragging: false,\n        isRotating: true\n      });\n    } else {\n      const newControllerState = this.controllerState.rotateEnd();\n      this.updateViewport(newControllerState, null, {\n        isDragging: false,\n        isRotating: false\n      });\n    }\n\n    return true;\n  }\n\n  _onWheel(event) {\n    if (!this.scrollZoom) {\n      return false;\n    }\n\n    event.preventDefault();\n    const pos = this.getCenter(event);\n\n    if (!this.isPointInBounds(pos, event)) {\n      return false;\n    }\n\n    const {\n      speed = 0.01,\n      smooth = false\n    } = this.scrollZoom;\n    const {\n      delta\n    } = event;\n    let scale = 2 / (1 + Math.exp(-Math.abs(delta * speed)));\n\n    if (delta < 0 && scale !== 0) {\n      scale = 1 / scale;\n    }\n\n    const newControllerState = this.controllerState.zoom({\n      pos,\n      scale\n    });\n    this.updateViewport(newControllerState, { ...this._getTransitionProps({\n        around: pos\n      }),\n      transitionDuration: smooth ? 250 : 1\n    }, {\n      isZooming: true,\n      isPanning: true\n    });\n    return true;\n  }\n\n  _onTriplePanStart(event) {\n    const pos = this.getCenter(event);\n\n    if (!this.isPointInBounds(pos, event)) {\n      return false;\n    }\n\n    const newControllerState = this.controllerState.rotateStart({\n      pos\n    });\n    this.updateViewport(newControllerState, NO_TRANSITION_PROPS, {\n      isDragging: true\n    });\n    return true;\n  }\n\n  _onTriplePan(event) {\n    if (!this.touchRotate) {\n      return false;\n    }\n\n    if (!this.isDragging()) {\n      return false;\n    }\n\n    const pos = this.getCenter(event);\n    pos[0] -= event.deltaX;\n    const newControllerState = this.controllerState.rotate({\n      pos\n    });\n    this.updateViewport(newControllerState, NO_TRANSITION_PROPS, {\n      isDragging: true,\n      isRotating: true\n    });\n    return true;\n  }\n\n  _onTriplePanEnd(event) {\n    if (!this.isDragging()) {\n      return false;\n    }\n\n    const {\n      inertia\n    } = this;\n\n    if (this.touchRotate && inertia && event.velocityY) {\n      const pos = this.getCenter(event);\n      const endPos = [pos[0], pos[1] += event.velocityY * inertia / 2];\n      const newControllerState = this.controllerState.rotate({\n        pos: endPos\n      });\n      this.updateViewport(newControllerState, { ...this._getTransitionProps(),\n        transitionDuration: inertia,\n        transitionEasing: INERTIA_EASING\n      }, {\n        isDragging: false,\n        isRotating: true\n      });\n      this.blockEvents(inertia);\n    } else {\n      const newControllerState = this.controllerState.rotateEnd();\n      this.updateViewport(newControllerState, null, {\n        isDragging: false,\n        isRotating: false\n      });\n    }\n\n    return true;\n  }\n\n  _onPinchStart(event) {\n    const pos = this.getCenter(event);\n\n    if (!this.isPointInBounds(pos, event)) {\n      return false;\n    }\n\n    const newControllerState = this.controllerState.zoomStart({\n      pos\n    }).rotateStart({\n      pos\n    });\n    this._startPinchRotation = event.rotation;\n    this._lastPinchEvent = event;\n    this.updateViewport(newControllerState, NO_TRANSITION_PROPS, {\n      isDragging: true\n    });\n    return true;\n  }\n\n  _onPinch(event) {\n    if (!this.touchZoom && !this.touchRotate) {\n      return false;\n    }\n\n    if (!this.isDragging()) {\n      return false;\n    }\n\n    let newControllerState = this.controllerState;\n\n    if (this.touchZoom) {\n      const {\n        scale\n      } = event;\n      const pos = this.getCenter(event);\n      newControllerState = newControllerState.zoom({\n        pos,\n        scale\n      });\n    }\n\n    if (this.touchRotate) {\n      const {\n        rotation\n      } = event;\n      newControllerState = newControllerState.rotate({\n        deltaAngleX: this._startPinchRotation - rotation\n      });\n    }\n\n    this.updateViewport(newControllerState, NO_TRANSITION_PROPS, {\n      isDragging: true,\n      isPanning: this.touchZoom,\n      isZooming: this.touchZoom,\n      isRotating: this.touchRotate\n    });\n    this._lastPinchEvent = event;\n    return true;\n  }\n\n  _onPinchEnd(event) {\n    if (!this.isDragging()) {\n      return false;\n    }\n\n    const {\n      inertia,\n      _lastPinchEvent\n    } = this;\n\n    if (this.touchZoom && inertia && _lastPinchEvent && event.scale !== _lastPinchEvent.scale) {\n      const pos = this.getCenter(event);\n      let newControllerState = this.controllerState.rotateEnd();\n      const z = Math.log2(event.scale);\n\n      const velocityZ = (z - Math.log2(_lastPinchEvent.scale)) / (event.deltaTime - _lastPinchEvent.deltaTime);\n\n      const endScale = Math.pow(2, z + velocityZ * inertia / 2);\n      newControllerState = newControllerState.zoom({\n        pos,\n        scale: endScale\n      }).zoomEnd();\n      this.updateViewport(newControllerState, { ...this._getTransitionProps({\n          around: pos\n        }),\n        transitionDuration: inertia,\n        transitionEasing: INERTIA_EASING\n      }, {\n        isDragging: false,\n        isPanning: this.touchZoom,\n        isZooming: this.touchZoom,\n        isRotating: false\n      });\n      this.blockEvents(inertia);\n    } else {\n      const newControllerState = this.controllerState.zoomEnd().rotateEnd();\n      this.updateViewport(newControllerState, null, {\n        isDragging: false,\n        isPanning: false,\n        isZooming: false,\n        isRotating: false\n      });\n    }\n\n    this._startPinchRotation = null;\n    this._lastPinchEvent = null;\n    return true;\n  }\n\n  _onDoubleTap(event) {\n    if (!this.doubleClickZoom) {\n      return false;\n    }\n\n    const pos = this.getCenter(event);\n\n    if (!this.isPointInBounds(pos, event)) {\n      return false;\n    }\n\n    const isZoomOut = this.isFunctionKeyPressed(event);\n    const newControllerState = this.controllerState.zoom({\n      pos,\n      scale: isZoomOut ? 0.5 : 2\n    });\n    this.updateViewport(newControllerState, this._getTransitionProps({\n      around: pos\n    }), {\n      isZooming: true,\n      isPanning: true\n    });\n    this.blockEvents(100);\n    return true;\n  }\n\n  _onKeyDown(event) {\n    if (!this.keyboard) {\n      return false;\n    }\n\n    const funcKey = this.isFunctionKeyPressed(event);\n    const {\n      zoomSpeed,\n      moveSpeed,\n      rotateSpeedX,\n      rotateSpeedY\n    } = this.keyboard;\n    const {\n      controllerState\n    } = this;\n    let newControllerState;\n    const interactionState = {};\n\n    switch (event.srcEvent.code) {\n      case 'Minus':\n        newControllerState = funcKey ? controllerState.zoomOut(zoomSpeed).zoomOut(zoomSpeed) : controllerState.zoomOut(zoomSpeed);\n        interactionState.isZooming = true;\n        break;\n\n      case 'Equal':\n        newControllerState = funcKey ? controllerState.zoomIn(zoomSpeed).zoomIn(zoomSpeed) : controllerState.zoomIn(zoomSpeed);\n        interactionState.isZooming = true;\n        break;\n\n      case 'ArrowLeft':\n        if (funcKey) {\n          newControllerState = controllerState.rotateLeft(rotateSpeedX);\n          interactionState.isRotating = true;\n        } else {\n          newControllerState = controllerState.moveLeft(moveSpeed);\n          interactionState.isPanning = true;\n        }\n\n        break;\n\n      case 'ArrowRight':\n        if (funcKey) {\n          newControllerState = controllerState.rotateRight(rotateSpeedX);\n          interactionState.isRotating = true;\n        } else {\n          newControllerState = controllerState.moveRight(moveSpeed);\n          interactionState.isPanning = true;\n        }\n\n        break;\n\n      case 'ArrowUp':\n        if (funcKey) {\n          newControllerState = controllerState.rotateUp(rotateSpeedY);\n          interactionState.isRotating = true;\n        } else {\n          newControllerState = controllerState.moveUp(moveSpeed);\n          interactionState.isPanning = true;\n        }\n\n        break;\n\n      case 'ArrowDown':\n        if (funcKey) {\n          newControllerState = controllerState.rotateDown(rotateSpeedY);\n          interactionState.isRotating = true;\n        } else {\n          newControllerState = controllerState.moveDown(moveSpeed);\n          interactionState.isPanning = true;\n        }\n\n        break;\n\n      default:\n        return false;\n    }\n\n    this.updateViewport(newControllerState, this._getTransitionProps(), interactionState);\n    return true;\n  }\n\n  _getTransitionProps(opts) {\n    const {\n      _transition\n    } = this;\n\n    if (!_transition) {\n      return NO_TRANSITION_PROPS;\n    }\n\n    return opts ? { ..._transition,\n      transitionInterpolator: new _transitions_linear_interpolator__WEBPACK_IMPORTED_MODULE_1__[\"default\"]({ ...opts,\n        transitionProps: this.linearTransitionProps,\n        makeViewport: this.controllerState.makeViewport\n      })\n    } : _transition;\n  }\n\n}\n//# sourceMappingURL=controller.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/controllers/controller.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/controllers/map-controller.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/controllers/map-controller.js ***!
  \***************************************************************************/
/*! exports provided: MapState, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"MapState\", function() { return MapState; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return MapController; });\n/* harmony import */ var math_gl__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! math.gl */ \"./node_modules/math.gl/dist/esm/index.js\");\n/* harmony import */ var _controller__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./controller */ \"./node_modules/@deck.gl/core/dist/esm/controllers/controller.js\");\n/* harmony import */ var _view_state__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./view-state */ \"./node_modules/@deck.gl/core/dist/esm/controllers/view-state.js\");\n/* harmony import */ var _math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @math.gl/web-mercator */ \"./node_modules/@math.gl/web-mercator/dist/esm/index.js\");\n/* harmony import */ var _utils_assert__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/assert */ \"./node_modules/@deck.gl/core/dist/esm/utils/assert.js\");\n\n\n\n\n\nconst PITCH_MOUSE_THRESHOLD = 5;\nconst PITCH_ACCEL = 1.2;\nconst DEFAULT_STATE = {\n  pitch: 0,\n  bearing: 0,\n  altitude: 1.5,\n  minZoom: 0,\n  maxZoom: 20,\n  minPitch: 0,\n  maxPitch: 60\n};\nclass MapState extends _view_state__WEBPACK_IMPORTED_MODULE_2__[\"default\"] {\n  constructor({\n    makeViewport,\n    width,\n    height,\n    latitude,\n    longitude,\n    zoom,\n    bearing = DEFAULT_STATE.bearing,\n    pitch = DEFAULT_STATE.pitch,\n    altitude = DEFAULT_STATE.altitude,\n    maxZoom = DEFAULT_STATE.maxZoom,\n    minZoom = DEFAULT_STATE.minZoom,\n    maxPitch = DEFAULT_STATE.maxPitch,\n    minPitch = DEFAULT_STATE.minPitch,\n    startPanLngLat,\n    startZoomLngLat,\n    startRotatePos,\n    startBearing,\n    startPitch,\n    startZoom,\n    normalize\n  } = {}) {\n    Object(_utils_assert__WEBPACK_IMPORTED_MODULE_4__[\"default\"])(Number.isFinite(longitude));\n    Object(_utils_assert__WEBPACK_IMPORTED_MODULE_4__[\"default\"])(Number.isFinite(latitude));\n    Object(_utils_assert__WEBPACK_IMPORTED_MODULE_4__[\"default\"])(Number.isFinite(zoom));\n    super({\n      width,\n      height,\n      latitude,\n      longitude,\n      zoom,\n      bearing,\n      pitch,\n      altitude,\n      maxZoom,\n      minZoom,\n      maxPitch,\n      minPitch,\n      normalize\n    });\n    this._state = {\n      startPanLngLat,\n      startZoomLngLat,\n      startRotatePos,\n      startBearing,\n      startPitch,\n      startZoom\n    };\n    this.makeViewport = makeViewport;\n  }\n\n  panStart({\n    pos\n  }) {\n    return this._getUpdatedState({\n      startPanLngLat: this._unproject(pos)\n    });\n  }\n\n  pan({\n    pos,\n    startPos\n  }) {\n    const startPanLngLat = this._state.startPanLngLat || this._unproject(startPos);\n\n    if (!startPanLngLat) {\n      return this;\n    }\n\n    const viewport = this.makeViewport(this._viewportProps);\n    const newProps = viewport.panByPosition(startPanLngLat, pos);\n    return this._getUpdatedState(newProps);\n  }\n\n  panEnd() {\n    return this._getUpdatedState({\n      startPanLngLat: null\n    });\n  }\n\n  rotateStart({\n    pos\n  }) {\n    return this._getUpdatedState({\n      startRotatePos: pos,\n      startBearing: this._viewportProps.bearing,\n      startPitch: this._viewportProps.pitch\n    });\n  }\n\n  rotate({\n    pos,\n    deltaAngleX = 0,\n    deltaAngleY = 0\n  }) {\n    const {\n      startRotatePos,\n      startBearing,\n      startPitch\n    } = this._state;\n\n    if (!startRotatePos || !Number.isFinite(startBearing) || !Number.isFinite(startPitch)) {\n      return this;\n    }\n\n    let newRotation;\n\n    if (pos) {\n      newRotation = this._calculateNewPitchAndBearing({ ...this._getRotationParams(pos, startRotatePos),\n        startBearing,\n        startPitch\n      });\n    } else {\n      newRotation = {\n        bearing: startBearing + deltaAngleX,\n        pitch: startPitch + deltaAngleY\n      };\n    }\n\n    return this._getUpdatedState(newRotation);\n  }\n\n  rotateEnd() {\n    return this._getUpdatedState({\n      startBearing: null,\n      startPitch: null\n    });\n  }\n\n  zoomStart({\n    pos\n  }) {\n    return this._getUpdatedState({\n      startZoomLngLat: this._unproject(pos),\n      startZoom: this._viewportProps.zoom\n    });\n  }\n\n  zoom({\n    pos,\n    startPos,\n    scale\n  }) {\n    let {\n      startZoom,\n      startZoomLngLat\n    } = this._state;\n\n    if (!Number.isFinite(startZoom)) {\n      startZoom = this._viewportProps.zoom;\n      startZoomLngLat = this._unproject(startPos) || this._unproject(pos);\n    }\n\n    const zoom = this._calculateNewZoom({\n      scale,\n      startZoom\n    });\n\n    const zoomedViewport = this.makeViewport({ ...this._viewportProps,\n      zoom\n    });\n    return this._getUpdatedState({\n      zoom,\n      ...zoomedViewport.panByPosition(startZoomLngLat, pos)\n    });\n  }\n\n  zoomEnd() {\n    return this._getUpdatedState({\n      startZoomLngLat: null,\n      startZoom: null\n    });\n  }\n\n  zoomIn(speed = 2) {\n    return this._zoomFromCenter(speed);\n  }\n\n  zoomOut(speed = 2) {\n    return this._zoomFromCenter(1 / speed);\n  }\n\n  moveLeft(speed = 100) {\n    return this._panFromCenter([speed, 0]);\n  }\n\n  moveRight(speed = 100) {\n    return this._panFromCenter([-speed, 0]);\n  }\n\n  moveUp(speed = 100) {\n    return this._panFromCenter([0, speed]);\n  }\n\n  moveDown(speed = 100) {\n    return this._panFromCenter([0, -speed]);\n  }\n\n  rotateLeft(speed = 15) {\n    return this._getUpdatedState({\n      bearing: this._viewportProps.bearing - speed\n    });\n  }\n\n  rotateRight(speed = 15) {\n    return this._getUpdatedState({\n      bearing: this._viewportProps.bearing + speed\n    });\n  }\n\n  rotateUp(speed = 10) {\n    return this._getUpdatedState({\n      pitch: this._viewportProps.pitch + speed\n    });\n  }\n\n  rotateDown(speed = 10) {\n    return this._getUpdatedState({\n      pitch: this._viewportProps.pitch - speed\n    });\n  }\n\n  shortestPathFrom(viewState) {\n    const fromProps = viewState.getViewportProps();\n    const props = { ...this._viewportProps\n    };\n    const {\n      bearing,\n      longitude\n    } = props;\n\n    if (Math.abs(bearing - fromProps.bearing) > 180) {\n      props.bearing = bearing < 0 ? bearing + 360 : bearing - 360;\n    }\n\n    if (Math.abs(longitude - fromProps.longitude) > 180) {\n      props.longitude = longitude < 0 ? longitude + 360 : longitude - 360;\n    }\n\n    return props;\n  }\n\n  _zoomFromCenter(scale) {\n    const {\n      width,\n      height\n    } = this._viewportProps;\n    return this.zoom({\n      pos: [width / 2, height / 2],\n      scale\n    });\n  }\n\n  _panFromCenter(offset) {\n    const {\n      width,\n      height\n    } = this._viewportProps;\n    return this.pan({\n      startPos: [width / 2, height / 2],\n      pos: [width / 2 + offset[0], height / 2 + offset[1]]\n    });\n  }\n\n  _getUpdatedState(newProps) {\n    return new this.constructor({\n      makeViewport: this.makeViewport,\n      ...this._viewportProps,\n      ...this._state,\n      ...newProps\n    });\n  }\n\n  _applyConstraints(props) {\n    const {\n      maxZoom,\n      minZoom,\n      zoom\n    } = props;\n    props.zoom = Object(math_gl__WEBPACK_IMPORTED_MODULE_0__[\"clamp\"])(zoom, minZoom, maxZoom);\n    const {\n      maxPitch,\n      minPitch,\n      pitch\n    } = props;\n    props.pitch = Object(math_gl__WEBPACK_IMPORTED_MODULE_0__[\"clamp\"])(pitch, minPitch, maxPitch);\n    const {\n      normalize = true\n    } = props;\n\n    if (normalize) {\n      Object.assign(props, Object(_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_3__[\"normalizeViewportProps\"])(props));\n    }\n\n    return props;\n  }\n\n  _unproject(pos) {\n    const viewport = this.makeViewport(this._viewportProps);\n    return pos && viewport.unproject(pos);\n  }\n\n  _calculateNewZoom({\n    scale,\n    startZoom\n  }) {\n    const {\n      maxZoom,\n      minZoom\n    } = this._viewportProps;\n    const zoom = startZoom + Math.log2(scale);\n    return Object(math_gl__WEBPACK_IMPORTED_MODULE_0__[\"clamp\"])(zoom, minZoom, maxZoom);\n  }\n\n  _calculateNewPitchAndBearing({\n    deltaScaleX,\n    deltaScaleY,\n    startBearing,\n    startPitch\n  }) {\n    deltaScaleY = Object(math_gl__WEBPACK_IMPORTED_MODULE_0__[\"clamp\"])(deltaScaleY, -1, 1);\n    const {\n      minPitch,\n      maxPitch\n    } = this._viewportProps;\n    const bearing = startBearing + 180 * deltaScaleX;\n    let pitch = startPitch;\n\n    if (deltaScaleY > 0) {\n      pitch = startPitch + deltaScaleY * (maxPitch - startPitch);\n    } else if (deltaScaleY < 0) {\n      pitch = startPitch - deltaScaleY * (minPitch - startPitch);\n    }\n\n    return {\n      pitch,\n      bearing\n    };\n  }\n\n  _getRotationParams(pos, startPos) {\n    const deltaX = pos[0] - startPos[0];\n    const deltaY = pos[1] - startPos[1];\n    const centerY = pos[1];\n    const startY = startPos[1];\n    const {\n      width,\n      height\n    } = this._viewportProps;\n    const deltaScaleX = deltaX / width;\n    let deltaScaleY = 0;\n\n    if (deltaY > 0) {\n      if (Math.abs(height - startY) > PITCH_MOUSE_THRESHOLD) {\n        deltaScaleY = deltaY / (startY - height) * PITCH_ACCEL;\n      }\n    } else if (deltaY < 0) {\n      if (startY > PITCH_MOUSE_THRESHOLD) {\n        deltaScaleY = 1 - centerY / startY;\n      }\n    }\n\n    deltaScaleY = Math.min(1, Math.max(-1, deltaScaleY));\n    return {\n      deltaScaleX,\n      deltaScaleY\n    };\n  }\n\n}\nclass MapController extends _controller__WEBPACK_IMPORTED_MODULE_1__[\"default\"] {\n  constructor(props) {\n    props.dragMode = props.dragMode || 'pan';\n    super(MapState, props);\n  }\n\n  setProps(props) {\n    const oldProps = this.controllerStateProps;\n    super.setProps(props);\n    const dimensionChanged = !oldProps || oldProps.height !== props.height;\n\n    if (dimensionChanged) {\n      this.updateViewport(new this.ControllerState({\n        makeViewport: this.makeViewport,\n        ...this.controllerStateProps,\n        ...this._state\n      }));\n    }\n  }\n\n  get linearTransitionProps() {\n    return ['longitude', 'latitude', 'zoom', 'bearing', 'pitch'];\n  }\n\n}\n//# sourceMappingURL=map-controller.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/controllers/map-controller.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/controllers/transition-manager.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/controllers/transition-manager.js ***!
  \*******************************************************************************/
/*! exports provided: TRANSITION_EVENTS, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"TRANSITION_EVENTS\", function() { return TRANSITION_EVENTS; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return TransitionManager; });\n/* harmony import */ var _transitions_transition__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../transitions/transition */ \"./node_modules/@deck.gl/core/dist/esm/transitions/transition.js\");\n\n\nconst noop = () => {};\n\nconst TRANSITION_EVENTS = {\n  BREAK: 1,\n  SNAP_TO_END: 2,\n  IGNORE: 3\n};\nconst DEFAULT_PROPS = {\n  transitionEasing: t => t,\n  transitionInterruption: TRANSITION_EVENTS.BREAK,\n  onTransitionStart: noop,\n  onTransitionInterrupt: noop,\n  onTransitionEnd: noop\n};\nclass TransitionManager {\n  constructor(ControllerState, props = {}) {\n    this.ControllerState = ControllerState;\n    this.props = { ...DEFAULT_PROPS,\n      ...props\n    };\n    this.propsInTransition = null;\n    this.transition = new _transitions_transition__WEBPACK_IMPORTED_MODULE_0__[\"default\"](props.timeline);\n    this.onViewStateChange = props.onViewStateChange || noop;\n    this.onStateChange = props.onStateChange || noop;\n    this._onTransitionUpdate = this._onTransitionUpdate.bind(this);\n  }\n\n  finalize() {\n    this.transition.cancel();\n  }\n\n  getViewportInTransition() {\n    return this.propsInTransition;\n  }\n\n  processViewStateChange(nextProps) {\n    let transitionTriggered = false;\n    const currentProps = this.props;\n    nextProps = { ...DEFAULT_PROPS,\n      ...nextProps\n    };\n    this.props = nextProps;\n\n    if (this._shouldIgnoreViewportChange(currentProps, nextProps)) {\n      return transitionTriggered;\n    }\n\n    if (this._isTransitionEnabled(nextProps)) {\n      const {\n        interruption,\n        endProps\n      } = this.transition.settings;\n      const startProps = { ...currentProps,\n        ...(interruption === TRANSITION_EVENTS.SNAP_TO_END ? endProps : this.propsInTransition || currentProps)\n      };\n\n      this._triggerTransition(startProps, nextProps);\n\n      transitionTriggered = true;\n    } else {\n      this.transition.cancel();\n    }\n\n    return transitionTriggered;\n  }\n\n  updateTransition() {\n    this.transition.update();\n  }\n\n  _isTransitionEnabled(props) {\n    const {\n      transitionDuration,\n      transitionInterpolator\n    } = props;\n    return (transitionDuration > 0 || transitionDuration === 'auto') && Boolean(transitionInterpolator);\n  }\n\n  _isUpdateDueToCurrentTransition(props) {\n    if (this.transition.inProgress) {\n      return this.transition.settings.interpolator.arePropsEqual(props, this.propsInTransition);\n    }\n\n    return false;\n  }\n\n  _shouldIgnoreViewportChange(currentProps, nextProps) {\n    if (this.transition.inProgress) {\n      return this.transition.settings.interruption === TRANSITION_EVENTS.IGNORE || this._isUpdateDueToCurrentTransition(nextProps);\n    } else if (this._isTransitionEnabled(nextProps)) {\n      return nextProps.transitionInterpolator.arePropsEqual(currentProps, nextProps);\n    }\n\n    return true;\n  }\n\n  _triggerTransition(startProps, endProps) {\n    const startViewstate = new this.ControllerState(startProps);\n    const endViewStateProps = new this.ControllerState(endProps).shortestPathFrom(startViewstate);\n    const {\n      transitionInterpolator\n    } = endProps;\n    const duration = transitionInterpolator.getDuration ? transitionInterpolator.getDuration(startProps, endProps) : endProps.transitionDuration;\n\n    if (duration === 0) {\n      return;\n    }\n\n    const initialProps = endProps.transitionInterpolator.initializeProps(startProps, endViewStateProps);\n    this.propsInTransition = {};\n    this.duration = duration;\n    this.transition.start({\n      duration,\n      easing: endProps.transitionEasing,\n      interpolator: endProps.transitionInterpolator,\n      interruption: endProps.transitionInterruption,\n      startProps: initialProps.start,\n      endProps: initialProps.end,\n      onStart: endProps.onTransitionStart,\n      onUpdate: this._onTransitionUpdate,\n      onInterrupt: this._onTransitionEnd(endProps.onTransitionInterrupt),\n      onEnd: this._onTransitionEnd(endProps.onTransitionEnd)\n    });\n    this.onStateChange({\n      inTransition: true\n    });\n    this.updateTransition();\n  }\n\n  _onTransitionEnd(callback) {\n    return transition => {\n      this.propsInTransition = null;\n      this.onStateChange({\n        inTransition: false,\n        isZooming: false,\n        isPanning: false,\n        isRotating: false\n      });\n      callback(transition);\n    };\n  }\n\n  _onTransitionUpdate(transition) {\n    const {\n      time,\n      settings: {\n        interpolator,\n        startProps,\n        endProps,\n        duration,\n        easing\n      }\n    } = transition;\n    const t = easing(time / duration);\n    const viewport = interpolator.interpolateProps(startProps, endProps, t);\n    this.propsInTransition = new this.ControllerState({ ...this.props,\n      ...viewport\n    }).getViewportProps();\n    this.onViewStateChange({\n      viewState: this.propsInTransition,\n      oldViewState: this.props\n    });\n  }\n\n}\n//# sourceMappingURL=transition-manager.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/controllers/transition-manager.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/controllers/view-state.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/controllers/view-state.js ***!
  \***********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return ViewState; });\nclass ViewState {\n  constructor(opts) {\n    this._viewportProps = this._applyConstraints(opts);\n  }\n\n  getViewportProps() {\n    return this._viewportProps;\n  }\n\n  getState() {\n    return this._state;\n  }\n\n  shortestPathFrom(viewState) {\n    return this._viewportProps;\n  }\n\n  _applyConstraints(props) {\n    return props;\n  }\n\n}\n//# sourceMappingURL=view-state.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS9jb250cm9sbGVycy92aWV3LXN0YXRlLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0BkZWNrLmdsL2NvcmUvZGlzdC9lc20vY29udHJvbGxlcnMvdmlldy1zdGF0ZS5qcz9hZDI3Il0sInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCBkZWZhdWx0IGNsYXNzIFZpZXdTdGF0ZSB7XG4gIGNvbnN0cnVjdG9yKG9wdHMpIHtcbiAgICB0aGlzLl92aWV3cG9ydFByb3BzID0gdGhpcy5fYXBwbHlDb25zdHJhaW50cyhvcHRzKTtcbiAgfVxuXG4gIGdldFZpZXdwb3J0UHJvcHMoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3ZpZXdwb3J0UHJvcHM7XG4gIH1cblxuICBnZXRTdGF0ZSgpIHtcbiAgICByZXR1cm4gdGhpcy5fc3RhdGU7XG4gIH1cblxuICBzaG9ydGVzdFBhdGhGcm9tKHZpZXdTdGF0ZSkge1xuICAgIHJldHVybiB0aGlzLl92aWV3cG9ydFByb3BzO1xuICB9XG5cbiAgX2FwcGx5Q29uc3RyYWludHMocHJvcHMpIHtcbiAgICByZXR1cm4gcHJvcHM7XG4gIH1cblxufVxuLy8jIHNvdXJjZU1hcHBpbmdVUkw9dmlldy1zdGF0ZS5qcy5tYXAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/controllers/view-state.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/debug/index.js":
/*!************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/debug/index.js ***!
  \************************************************************/
/*! exports provided: register, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"register\", function() { return register; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return debug; });\n/* harmony import */ var _utils_log__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/log */ \"./node_modules/@deck.gl/core/dist/esm/utils/log.js\");\n/* harmony import */ var _loggers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./loggers */ \"./node_modules/@deck.gl/core/dist/esm/debug/loggers.js\");\n\n\nlet loggers = {};\n\nif (true) {\n  loggers = Object(_loggers__WEBPACK_IMPORTED_MODULE_1__[\"getLoggers\"])(_utils_log__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n}\n\nfunction register(handlers) {\n  loggers = handlers;\n}\nfunction debug(eventType) {\n  if (_utils_log__WEBPACK_IMPORTED_MODULE_0__[\"default\"].level > 0 && loggers[eventType]) {\n    loggers[eventType].call(...arguments);\n  }\n}\n//# sourceMappingURL=index.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS9kZWJ1Zy9pbmRleC5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9AZGVjay5nbC9jb3JlL2Rpc3QvZXNtL2RlYnVnL2luZGV4LmpzPzg1OTYiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IGRlY2tMb2cgZnJvbSAnLi4vdXRpbHMvbG9nJztcbmltcG9ydCB7IGdldExvZ2dlcnMgfSBmcm9tICcuL2xvZ2dlcnMnO1xubGV0IGxvZ2dlcnMgPSB7fTtcblxuaWYgKHByb2Nlc3MuZW52Lk5PREVfRU5WICE9PSAncHJvZHVjdGlvbicpIHtcbiAgbG9nZ2VycyA9IGdldExvZ2dlcnMoZGVja0xvZyk7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiByZWdpc3RlcihoYW5kbGVycykge1xuICBsb2dnZXJzID0gaGFuZGxlcnM7XG59XG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiBkZWJ1ZyhldmVudFR5cGUpIHtcbiAgaWYgKGRlY2tMb2cubGV2ZWwgPiAwICYmIGxvZ2dlcnNbZXZlbnRUeXBlXSkge1xuICAgIGxvZ2dlcnNbZXZlbnRUeXBlXS5jYWxsKC4uLmFyZ3VtZW50cyk7XG4gIH1cbn1cbi8vIyBzb3VyY2VNYXBwaW5nVVJMPWluZGV4LmpzLm1hcCJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/debug/index.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/debug/loggers.js":
/*!**************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/debug/loggers.js ***!
  \**************************************************************/
/*! exports provided: getLoggers */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getLoggers\", function() { return getLoggers; });\nconst logState = {\n  attributeUpdateMessages: []\n};\nconst LOG_LEVEL_MAJOR_UPDATE = 1;\nconst LOG_LEVEL_MINOR_UPDATE = 2;\nconst LOG_LEVEL_UPDATE_DETAIL = 3;\nconst LOG_LEVEL_INFO = 4;\nconst LOG_LEVEL_DRAW = 2;\nconst getLoggers = log => ({\n  'layer.changeFlag': (layer, key, flags) => {\n    log.log(LOG_LEVEL_UPDATE_DETAIL, \"\".concat(layer.id, \" \").concat(key, \": \"), flags[key])();\n  },\n  'layer.initialize': layer => {\n    log.log(LOG_LEVEL_MAJOR_UPDATE, \"Initializing \".concat(layer))();\n  },\n  'layer.update': (layer, needsUpdate) => {\n    if (needsUpdate) {\n      const flags = layer.getChangeFlags();\n      log.log(LOG_LEVEL_MINOR_UPDATE, \"Updating \".concat(layer, \" because: \").concat(Object.keys(flags).filter(key => flags[key]).join(', ')))();\n    } else {\n      log.log(LOG_LEVEL_INFO, \"\".concat(layer, \" does not need update\"))();\n    }\n  },\n  'layer.matched': (layer, changed) => {\n    if (changed) {\n      log.log(LOG_LEVEL_INFO, \"Matched \".concat(layer, \", state transfered\"))();\n    }\n  },\n  'layer.finalize': layer => {\n    log.log(LOG_LEVEL_MAJOR_UPDATE, \"Finalizing \".concat(layer))();\n  },\n  'compositeLayer.renderLayers': (layer, updated, subLayers) => {\n    if (updated) {\n      log.log(LOG_LEVEL_MINOR_UPDATE, \"Composite layer rendered new subLayers \".concat(layer), subLayers)();\n    } else {\n      log.log(LOG_LEVEL_INFO, \"Composite layer reused subLayers \".concat(layer), subLayers)();\n    }\n  },\n  'layerManager.setLayers': (layerManager, updated, layers) => {\n    if (updated) {\n      log.log(LOG_LEVEL_MINOR_UPDATE, \"Updating \".concat(layers.length, \" deck layers\"))();\n    }\n  },\n  'layerManager.activateViewport': (layerManager, viewport) => {\n    log.log(LOG_LEVEL_UPDATE_DETAIL, 'Viewport changed', viewport)();\n  },\n  'attributeManager.invalidate': (attributeManager, trigger, attributeNames) => {\n    log.log(LOG_LEVEL_MAJOR_UPDATE, attributeNames ? \"invalidated attributes \".concat(attributeNames, \" (\").concat(trigger, \") for \").concat(attributeManager.id) : \"invalidated all attributes for \".concat(attributeManager.id))();\n  },\n  'attributeManager.updateStart': attributeManager => {\n    logState.attributeUpdateMessages.length = 0;\n    logState.attributeManagerUpdateStart = Date.now();\n  },\n  'attributeManager.updateEnd': (attributeManager, numInstances) => {\n    const timeMs = Math.round(Date.now() - logState.attributeManagerUpdateStart);\n    log.groupCollapsed(LOG_LEVEL_MINOR_UPDATE, \"Updated attributes for \".concat(numInstances, \" instances in \").concat(attributeManager.id, \" in \").concat(timeMs, \"ms\"))();\n\n    for (const updateMessage of logState.attributeUpdateMessages) {\n      log.log(LOG_LEVEL_UPDATE_DETAIL, updateMessage)();\n    }\n\n    log.groupEnd(LOG_LEVEL_MINOR_UPDATE)();\n  },\n  'attribute.updateStart': attribute => {\n    logState.attributeUpdateStart = Date.now();\n  },\n  'attribute.allocate': (attribute, numInstances) => {\n    const message = \"\".concat(attribute.id, \" allocated \").concat(numInstances);\n    logState.attributeUpdateMessages.push(message);\n  },\n  'attribute.updateEnd': (attribute, numInstances) => {\n    const timeMs = Math.round(Date.now() - logState.attributeUpdateStart);\n    const message = \"\".concat(attribute.id, \" updated \").concat(numInstances, \" in \").concat(timeMs, \"ms\");\n    logState.attributeUpdateMessages.push(message);\n  },\n  'deckRenderer.renderLayers': (deckRenderer, renderStats, opts) => {\n    const {\n      pass,\n      redrawReason,\n      stats\n    } = opts;\n\n    for (const status of renderStats) {\n      const {\n        totalCount,\n        visibleCount,\n        compositeCount,\n        pickableCount\n      } = status;\n      const primitiveCount = totalCount - compositeCount;\n      const hiddenCount = primitiveCount - visibleCount;\n      log.log(LOG_LEVEL_DRAW, \"RENDER #\".concat(deckRenderer.renderCount, \"   \").concat(visibleCount, \" (of \").concat(totalCount, \" layers) to \").concat(pass, \" because \").concat(redrawReason, \"   (\").concat(hiddenCount, \" hidden, \").concat(compositeCount, \" composite \").concat(pickableCount, \" pickable)\"))();\n\n      if (stats) {\n        stats.get('Redraw Layers').add(visibleCount);\n      }\n    }\n  }\n});\n//# sourceMappingURL=loggers.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/debug/loggers.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/effects/lighting/ambient-light.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/effects/lighting/ambient-light.js ***!
  \*******************************************************************************/
/*! exports provided: AmbientLight */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"AmbientLight\", function() { return AmbientLight; });\nconst DEFAULT_LIGHT_COLOR = [255, 255, 255];\nconst DEFAULT_LIGHT_INTENSITY = 1.0;\nlet idCount = 0;\nclass AmbientLight {\n  constructor(props = {}) {\n    const {\n      color = DEFAULT_LIGHT_COLOR\n    } = props;\n    const {\n      intensity = DEFAULT_LIGHT_INTENSITY\n    } = props;\n    this.id = props.id || \"ambient-\".concat(idCount++);\n    this.color = color;\n    this.intensity = intensity;\n    this.type = 'ambient';\n  }\n\n}\n//# sourceMappingURL=ambient-light.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS9lZmZlY3RzL2xpZ2h0aW5nL2FtYmllbnQtbGlnaHQuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS9lZmZlY3RzL2xpZ2h0aW5nL2FtYmllbnQtbGlnaHQuanM/ZWUwNiJdLCJzb3VyY2VzQ29udGVudCI6WyJjb25zdCBERUZBVUxUX0xJR0hUX0NPTE9SID0gWzI1NSwgMjU1LCAyNTVdO1xuY29uc3QgREVGQVVMVF9MSUdIVF9JTlRFTlNJVFkgPSAxLjA7XG5sZXQgaWRDb3VudCA9IDA7XG5leHBvcnQgY2xhc3MgQW1iaWVudExpZ2h0IHtcbiAgY29uc3RydWN0b3IocHJvcHMgPSB7fSkge1xuICAgIGNvbnN0IHtcbiAgICAgIGNvbG9yID0gREVGQVVMVF9MSUdIVF9DT0xPUlxuICAgIH0gPSBwcm9wcztcbiAgICBjb25zdCB7XG4gICAgICBpbnRlbnNpdHkgPSBERUZBVUxUX0xJR0hUX0lOVEVOU0lUWVxuICAgIH0gPSBwcm9wcztcbiAgICB0aGlzLmlkID0gcHJvcHMuaWQgfHwgXCJhbWJpZW50LVwiLmNvbmNhdChpZENvdW50KyspO1xuICAgIHRoaXMuY29sb3IgPSBjb2xvcjtcbiAgICB0aGlzLmludGVuc2l0eSA9IGludGVuc2l0eTtcbiAgICB0aGlzLnR5cGUgPSAnYW1iaWVudCc7XG4gIH1cblxufVxuLy8jIHNvdXJjZU1hcHBpbmdVUkw9YW1iaWVudC1saWdodC5qcy5tYXAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/effects/lighting/ambient-light.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/effects/lighting/directional-light.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/effects/lighting/directional-light.js ***!
  \***********************************************************************************/
/*! exports provided: DirectionalLight */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"DirectionalLight\", function() { return DirectionalLight; });\n/* harmony import */ var math_gl__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! math.gl */ \"./node_modules/math.gl/dist/esm/index.js\");\n\nconst DEFAULT_LIGHT_COLOR = [255, 255, 255];\nconst DEFAULT_LIGHT_INTENSITY = 1.0;\nconst DEFAULT_LIGHT_DIRECTION = [0.0, 0.0, -1.0];\nlet idCount = 0;\nclass DirectionalLight {\n  constructor(props = {}) {\n    const {\n      color = DEFAULT_LIGHT_COLOR\n    } = props;\n    const {\n      intensity = DEFAULT_LIGHT_INTENSITY\n    } = props;\n    const {\n      direction = DEFAULT_LIGHT_DIRECTION\n    } = props;\n    const {\n      _shadow = false\n    } = props;\n    this.id = props.id || \"directional-\".concat(idCount++);\n    this.color = color;\n    this.intensity = intensity;\n    this.type = 'directional';\n    this.direction = new math_gl__WEBPACK_IMPORTED_MODULE_0__[\"Vector3\"](direction).normalize().toArray();\n    this.shadow = _shadow;\n  }\n\n  getProjectedLight() {\n    return this;\n  }\n\n}\n//# sourceMappingURL=directional-light.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS9lZmZlY3RzL2xpZ2h0aW5nL2RpcmVjdGlvbmFsLWxpZ2h0LmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0BkZWNrLmdsL2NvcmUvZGlzdC9lc20vZWZmZWN0cy9saWdodGluZy9kaXJlY3Rpb25hbC1saWdodC5qcz81NDE0Il0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFZlY3RvcjMgfSBmcm9tICdtYXRoLmdsJztcbmNvbnN0IERFRkFVTFRfTElHSFRfQ09MT1IgPSBbMjU1LCAyNTUsIDI1NV07XG5jb25zdCBERUZBVUxUX0xJR0hUX0lOVEVOU0lUWSA9IDEuMDtcbmNvbnN0IERFRkFVTFRfTElHSFRfRElSRUNUSU9OID0gWzAuMCwgMC4wLCAtMS4wXTtcbmxldCBpZENvdW50ID0gMDtcbmV4cG9ydCBjbGFzcyBEaXJlY3Rpb25hbExpZ2h0IHtcbiAgY29uc3RydWN0b3IocHJvcHMgPSB7fSkge1xuICAgIGNvbnN0IHtcbiAgICAgIGNvbG9yID0gREVGQVVMVF9MSUdIVF9DT0xPUlxuICAgIH0gPSBwcm9wcztcbiAgICBjb25zdCB7XG4gICAgICBpbnRlbnNpdHkgPSBERUZBVUxUX0xJR0hUX0lOVEVOU0lUWVxuICAgIH0gPSBwcm9wcztcbiAgICBjb25zdCB7XG4gICAgICBkaXJlY3Rpb24gPSBERUZBVUxUX0xJR0hUX0RJUkVDVElPTlxuICAgIH0gPSBwcm9wcztcbiAgICBjb25zdCB7XG4gICAgICBfc2hhZG93ID0gZmFsc2VcbiAgICB9ID0gcHJvcHM7XG4gICAgdGhpcy5pZCA9IHByb3BzLmlkIHx8IFwiZGlyZWN0aW9uYWwtXCIuY29uY2F0KGlkQ291bnQrKyk7XG4gICAgdGhpcy5jb2xvciA9IGNvbG9yO1xuICAgIHRoaXMuaW50ZW5zaXR5ID0gaW50ZW5zaXR5O1xuICAgIHRoaXMudHlwZSA9ICdkaXJlY3Rpb25hbCc7XG4gICAgdGhpcy5kaXJlY3Rpb24gPSBuZXcgVmVjdG9yMyhkaXJlY3Rpb24pLm5vcm1hbGl6ZSgpLnRvQXJyYXkoKTtcbiAgICB0aGlzLnNoYWRvdyA9IF9zaGFkb3c7XG4gIH1cblxuICBnZXRQcm9qZWN0ZWRMaWdodCgpIHtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG59XG4vLyMgc291cmNlTWFwcGluZ1VSTD1kaXJlY3Rpb25hbC1saWdodC5qcy5tYXAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/effects/lighting/directional-light.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/effects/lighting/lighting-effect.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/effects/lighting/lighting-effect.js ***!
  \*********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return LightingEffect; });\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/engine/dist/esm/lib/program-manager.js\");\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/webgl/dist/esm/classes/texture-2d.js\");\n/* harmony import */ var _ambient_light__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ambient-light */ \"./node_modules/@deck.gl/core/dist/esm/effects/lighting/ambient-light.js\");\n/* harmony import */ var _directional_light__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./directional-light */ \"./node_modules/@deck.gl/core/dist/esm/effects/lighting/directional-light.js\");\n/* harmony import */ var _lib_effect__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../lib/effect */ \"./node_modules/@deck.gl/core/dist/esm/lib/effect.js\");\n/* harmony import */ var math_gl__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! math.gl */ \"./node_modules/math.gl/dist/esm/index.js\");\n/* harmony import */ var _passes_shadow_pass__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../passes/shadow-pass */ \"./node_modules/@deck.gl/core/dist/esm/passes/shadow-pass.js\");\n/* harmony import */ var _shaderlib_shadow_shadow__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../shaderlib/shadow/shadow */ \"./node_modules/@deck.gl/core/dist/esm/shaderlib/shadow/shadow.js\");\n\n\n\n\n\n\n\nconst DEFAULT_AMBIENT_LIGHT_PROPS = {\n  color: [255, 255, 255],\n  intensity: 1.0\n};\nconst DEFAULT_DIRECTIONAL_LIGHT_PROPS = [{\n  color: [255, 255, 255],\n  intensity: 1.0,\n  direction: [-1, 3, -1]\n}, {\n  color: [255, 255, 255],\n  intensity: 0.9,\n  direction: [1, -8, -2.5]\n}];\nconst DEFAULT_SHADOW_COLOR = [0, 0, 0, 200 / 255];\nclass LightingEffect extends _lib_effect__WEBPACK_IMPORTED_MODULE_4__[\"default\"] {\n  constructor(props) {\n    super(props);\n    this.ambientLight = null;\n    this.directionalLights = [];\n    this.pointLights = [];\n    this.shadowColor = DEFAULT_SHADOW_COLOR;\n    this.shadowPasses = [];\n    this.shadowMaps = [];\n    this.dummyShadowMap = null;\n    this.shadow = false;\n    this.programManager = null;\n\n    for (const key in props) {\n      const lightSource = props[key];\n\n      switch (lightSource.type) {\n        case 'ambient':\n          this.ambientLight = lightSource;\n          break;\n\n        case 'directional':\n          this.directionalLights.push(lightSource);\n          break;\n\n        case 'point':\n          this.pointLights.push(lightSource);\n          break;\n\n        default:\n      }\n    }\n\n    this._applyDefaultLights();\n\n    this.shadow = this.directionalLights.some(light => light.shadow);\n  }\n\n  preRender(gl, {\n    layers,\n    layerFilter,\n    viewports,\n    onViewportActive,\n    views\n  }) {\n    if (!this.shadow) return;\n    this.shadowMatrices = this._createLightMatrix();\n\n    if (this.shadowPasses.length === 0) {\n      this._createShadowPasses(gl);\n    }\n\n    if (!this.programManager) {\n      this.programManager = _luma_gl_core__WEBPACK_IMPORTED_MODULE_0__[\"default\"].getDefaultProgramManager(gl);\n\n      if (_shaderlib_shadow_shadow__WEBPACK_IMPORTED_MODULE_7__[\"default\"]) {\n        this.programManager.addDefaultModule(_shaderlib_shadow_shadow__WEBPACK_IMPORTED_MODULE_7__[\"default\"]);\n      }\n    }\n\n    if (!this.dummyShadowMap) {\n      this.dummyShadowMap = new _luma_gl_core__WEBPACK_IMPORTED_MODULE_1__[\"default\"](gl, {\n        width: 1,\n        height: 1\n      });\n    }\n\n    for (let i = 0; i < this.shadowPasses.length; i++) {\n      const shadowPass = this.shadowPasses[i];\n      shadowPass.render({\n        layers,\n        layerFilter,\n        viewports,\n        onViewportActive,\n        views,\n        moduleParameters: {\n          shadowLightId: i,\n          dummyShadowMap: this.dummyShadowMap,\n          shadowMatrices: this.shadowMatrices\n        }\n      });\n    }\n  }\n\n  getModuleParameters(layer) {\n    const parameters = this.shadow ? {\n      shadowMaps: this.shadowMaps,\n      dummyShadowMap: this.dummyShadowMap,\n      shadowColor: this.shadowColor,\n      shadowMatrices: this.shadowMatrices\n    } : {};\n    parameters.lightSources = {\n      ambientLight: this.ambientLight,\n      directionalLights: this.directionalLights.map(directionalLight => directionalLight.getProjectedLight({\n        layer\n      })),\n      pointLights: this.pointLights.map(pointLight => pointLight.getProjectedLight({\n        layer\n      }))\n    };\n    return parameters;\n  }\n\n  cleanup() {\n    for (const shadowPass of this.shadowPasses) {\n      shadowPass.delete();\n    }\n\n    this.shadowPasses.length = 0;\n    this.shadowMaps.length = 0;\n\n    if (this.dummyShadowMap) {\n      this.dummyShadowMap.delete();\n      this.dummyShadowMap = null;\n    }\n\n    if (this.shadow && this.programManager) {\n      this.programManager.removeDefaultModule(_shaderlib_shadow_shadow__WEBPACK_IMPORTED_MODULE_7__[\"default\"]);\n      this.programManager = null;\n    }\n  }\n\n  _createLightMatrix() {\n    const lightMatrices = [];\n\n    for (const light of this.directionalLights) {\n      const viewMatrix = new math_gl__WEBPACK_IMPORTED_MODULE_5__[\"Matrix4\"]().lookAt({\n        eye: new math_gl__WEBPACK_IMPORTED_MODULE_5__[\"Vector3\"](light.direction).negate()\n      });\n      lightMatrices.push(viewMatrix);\n    }\n\n    return lightMatrices;\n  }\n\n  _createShadowPasses(gl) {\n    for (let i = 0; i < this.directionalLights.length; i++) {\n      const shadowPass = new _passes_shadow_pass__WEBPACK_IMPORTED_MODULE_6__[\"default\"](gl);\n      this.shadowPasses[i] = shadowPass;\n      this.shadowMaps[i] = shadowPass.shadowMap;\n    }\n  }\n\n  _applyDefaultLights() {\n    const {\n      ambientLight,\n      pointLights,\n      directionalLights\n    } = this;\n\n    if (!ambientLight && pointLights.length === 0 && directionalLights.length === 0) {\n      this.ambientLight = new _ambient_light__WEBPACK_IMPORTED_MODULE_2__[\"AmbientLight\"](DEFAULT_AMBIENT_LIGHT_PROPS);\n      this.directionalLights.push(new _directional_light__WEBPACK_IMPORTED_MODULE_3__[\"DirectionalLight\"](DEFAULT_DIRECTIONAL_LIGHT_PROPS[0]), new _directional_light__WEBPACK_IMPORTED_MODULE_3__[\"DirectionalLight\"](DEFAULT_DIRECTIONAL_LIGHT_PROPS[1]));\n    }\n  }\n\n}\n//# sourceMappingURL=lighting-effect.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/effects/lighting/lighting-effect.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lib/attribute/attribute-manager.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lib/attribute/attribute-manager.js ***!
  \********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return AttributeManager; });\n/* harmony import */ var _attribute__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./attribute */ \"./node_modules/@deck.gl/core/dist/esm/lib/attribute/attribute.js\");\n/* harmony import */ var _utils_log__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/log */ \"./node_modules/@deck.gl/core/dist/esm/utils/log.js\");\n/* harmony import */ var _debug__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../debug */ \"./node_modules/@deck.gl/core/dist/esm/debug/index.js\");\n/* harmony import */ var _attribute_transition_manager__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./attribute-transition-manager */ \"./node_modules/@deck.gl/core/dist/esm/lib/attribute/attribute-transition-manager.js\");\n\n\n\n\nconst TRACE_INVALIDATE = 'attributeManager.invalidate';\nconst TRACE_UPDATE_START = 'attributeManager.updateStart';\nconst TRACE_UPDATE_END = 'attributeManager.updateEnd';\nconst TRACE_ATTRIBUTE_UPDATE_START = 'attribute.updateStart';\nconst TRACE_ATTRIBUTE_ALLOCATE = 'attribute.allocate';\nconst TRACE_ATTRIBUTE_UPDATE_END = 'attribute.updateEnd';\nclass AttributeManager {\n  constructor(gl, {\n    id = 'attribute-manager',\n    stats,\n    timeline\n  } = {}) {\n    this.id = id;\n    this.gl = gl;\n    this.attributes = {};\n    this.updateTriggers = {};\n    this.accessors = {};\n    this.needsRedraw = true;\n    this.userData = {};\n    this.stats = stats;\n    this.attributeTransitionManager = new _attribute_transition_manager__WEBPACK_IMPORTED_MODULE_3__[\"default\"](gl, {\n      id: \"\".concat(id, \"-transitions\"),\n      timeline\n    });\n    Object.seal(this);\n  }\n\n  finalize() {\n    for (const attributeName in this.attributes) {\n      this.attributes[attributeName].delete();\n    }\n\n    this.attributeTransitionManager.finalize();\n  }\n\n  getNeedsRedraw(opts = {\n    clearRedrawFlags: false\n  }) {\n    const redraw = this.needsRedraw;\n    this.needsRedraw = this.needsRedraw && !opts.clearRedrawFlags;\n    return redraw && this.id;\n  }\n\n  setNeedsRedraw(redraw = true) {\n    this.needsRedraw = true;\n    return this;\n  }\n\n  add(attributes, updaters) {\n    this._add(attributes, updaters);\n  }\n\n  addInstanced(attributes, updaters) {\n    this._add(attributes, updaters, {\n      instanced: 1\n    });\n  }\n\n  remove(attributeNameArray) {\n    for (let i = 0; i < attributeNameArray.length; i++) {\n      const name = attributeNameArray[i];\n\n      if (this.attributes[name] !== undefined) {\n        this.attributes[name].delete();\n        delete this.attributes[name];\n      }\n    }\n  }\n\n  invalidate(triggerName, dataRange) {\n    const invalidatedAttributes = this._invalidateTrigger(triggerName, dataRange);\n\n    Object(_debug__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(TRACE_INVALIDATE, this, triggerName, invalidatedAttributes);\n  }\n\n  invalidateAll(dataRange) {\n    for (const attributeName in this.attributes) {\n      this.attributes[attributeName].setNeedsUpdate(attributeName, dataRange);\n    }\n\n    Object(_debug__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(TRACE_INVALIDATE, this, 'all');\n  }\n\n  update({\n    data,\n    numInstances,\n    startIndices = null,\n    transitions,\n    props = {},\n    buffers = {},\n    context = {}\n  } = {}) {\n    let updated = false;\n    Object(_debug__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(TRACE_UPDATE_START, this);\n\n    if (this.stats) {\n      this.stats.get('Update Attributes').timeStart();\n    }\n\n    for (const attributeName in this.attributes) {\n      const attribute = this.attributes[attributeName];\n      const accessorName = attribute.settings.accessor;\n      attribute.startIndices = startIndices;\n\n      if (props[attributeName]) {\n        _utils_log__WEBPACK_IMPORTED_MODULE_1__[\"default\"].removed(\"props.\".concat(attributeName), \"data.attributes.\".concat(attributeName))();\n      }\n\n      if (attribute.setExternalBuffer(buffers[attributeName])) {} else if (attribute.setBinaryValue(buffers[accessorName], data.startIndices)) {} else if (!buffers[accessorName] && attribute.setConstantValue(props[accessorName])) {} else if (attribute.needsUpdate()) {\n        updated = true;\n\n        this._updateAttribute({\n          attribute,\n          numInstances,\n          data,\n          props,\n          context\n        });\n      }\n\n      this.needsRedraw |= attribute.needsRedraw();\n    }\n\n    if (updated) {\n      Object(_debug__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(TRACE_UPDATE_END, this, numInstances);\n    }\n\n    if (this.stats) {\n      this.stats.get('Update Attributes').timeEnd();\n    }\n\n    this.attributeTransitionManager.update({\n      attributes: this.attributes,\n      numInstances,\n      transitions\n    });\n  }\n\n  updateTransition() {\n    const {\n      attributeTransitionManager\n    } = this;\n    const transitionUpdated = attributeTransitionManager.run();\n    this.needsRedraw = this.needsRedraw || transitionUpdated;\n    return transitionUpdated;\n  }\n\n  getAttributes() {\n    return this.attributes;\n  }\n\n  getChangedAttributes(opts = {\n    clearChangedFlags: false\n  }) {\n    const {\n      attributes,\n      attributeTransitionManager\n    } = this;\n    const changedAttributes = { ...attributeTransitionManager.getAttributes()\n    };\n\n    for (const attributeName in attributes) {\n      const attribute = attributes[attributeName];\n\n      if (attribute.needsRedraw(opts) && !attributeTransitionManager.hasAttribute(attributeName)) {\n        changedAttributes[attributeName] = attribute;\n      }\n    }\n\n    return changedAttributes;\n  }\n\n  getShaderAttributes(attributes, excludeAttributes = {}) {\n    if (!attributes) {\n      attributes = this.getAttributes();\n    }\n\n    const shaderAttributes = {};\n\n    for (const attributeName in attributes) {\n      if (!excludeAttributes[attributeName]) {\n        Object.assign(shaderAttributes, attributes[attributeName].getShaderAttributes());\n      }\n    }\n\n    return shaderAttributes;\n  }\n\n  getAccessors() {\n    return this.updateTriggers;\n  }\n\n  _add(attributes, updaters, extraProps = {}) {\n    if (updaters) {\n      _utils_log__WEBPACK_IMPORTED_MODULE_1__[\"default\"].warn('AttributeManager.add({updaters}) - updater map no longer supported')();\n    }\n\n    for (const attributeName in attributes) {\n      const attribute = attributes[attributeName];\n      this.attributes[attributeName] = this._createAttribute(attributeName, attribute, extraProps);\n    }\n\n    this._mapUpdateTriggersToAttributes();\n  }\n\n  _createAttribute(name, attribute, extraProps) {\n    const props = { ...attribute,\n      id: name,\n      constant: attribute.constant || false,\n      isIndexed: attribute.isIndexed || attribute.elements,\n      size: attribute.elements && 1 || attribute.size,\n      value: attribute.value || null,\n      divisor: attribute.instanced || extraProps.instanced ? 1 : attribute.divisor\n    };\n    return new _attribute__WEBPACK_IMPORTED_MODULE_0__[\"default\"](this.gl, props);\n  }\n\n  _mapUpdateTriggersToAttributes() {\n    const triggers = {};\n\n    for (const attributeName in this.attributes) {\n      const attribute = this.attributes[attributeName];\n      attribute.getUpdateTriggers().forEach(triggerName => {\n        if (!triggers[triggerName]) {\n          triggers[triggerName] = [];\n        }\n\n        triggers[triggerName].push(attributeName);\n      });\n    }\n\n    this.updateTriggers = triggers;\n  }\n\n  _invalidateTrigger(triggerName, dataRange) {\n    const {\n      attributes,\n      updateTriggers\n    } = this;\n    const invalidatedAttributes = updateTriggers[triggerName];\n\n    if (invalidatedAttributes) {\n      invalidatedAttributes.forEach(name => {\n        const attribute = attributes[name];\n\n        if (attribute) {\n          attribute.setNeedsUpdate(attribute.id, dataRange);\n        }\n      });\n    }\n\n    return invalidatedAttributes;\n  }\n\n  _updateAttribute(opts) {\n    const {\n      attribute,\n      numInstances\n    } = opts;\n    Object(_debug__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(TRACE_ATTRIBUTE_UPDATE_START, attribute);\n\n    if (attribute.allocate(numInstances)) {\n      Object(_debug__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(TRACE_ATTRIBUTE_ALLOCATE, attribute, numInstances);\n    }\n\n    const updated = attribute.updateBuffer(opts);\n\n    if (updated) {\n      this.needsRedraw = true;\n      Object(_debug__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(TRACE_ATTRIBUTE_UPDATE_END, attribute, numInstances);\n    }\n  }\n\n}\n//# sourceMappingURL=attribute-manager.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lib/attribute/attribute-manager.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lib/attribute/attribute-transition-manager.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lib/attribute/attribute-transition-manager.js ***!
  \*******************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return AttributeTransitionManager; });\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/engine/dist/esm/transform/transform.js\");\n/* harmony import */ var _transitions_gpu_interpolation_transition__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../transitions/gpu-interpolation-transition */ \"./node_modules/@deck.gl/core/dist/esm/transitions/gpu-interpolation-transition.js\");\n/* harmony import */ var _transitions_gpu_spring_transition__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../transitions/gpu-spring-transition */ \"./node_modules/@deck.gl/core/dist/esm/transitions/gpu-spring-transition.js\");\n/* harmony import */ var _utils_log__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/log */ \"./node_modules/@deck.gl/core/dist/esm/utils/log.js\");\n\n\n\n\nconst TRANSITION_TYPES = {\n  interpolation: _transitions_gpu_interpolation_transition__WEBPACK_IMPORTED_MODULE_1__[\"default\"],\n  spring: _transitions_gpu_spring_transition__WEBPACK_IMPORTED_MODULE_2__[\"default\"]\n};\nclass AttributeTransitionManager {\n  constructor(gl, {\n    id,\n    timeline\n  }) {\n    this.id = id;\n    this.gl = gl;\n    this.timeline = timeline;\n    this.transitions = {};\n    this.needsRedraw = false;\n    this.numInstances = 1;\n    this.isSupported = _luma_gl_core__WEBPACK_IMPORTED_MODULE_0__[\"default\"].isSupported(gl);\n  }\n\n  finalize() {\n    for (const attributeName in this.transitions) {\n      this._removeTransition(attributeName);\n    }\n  }\n\n  update({\n    attributes,\n    transitions,\n    numInstances\n  }) {\n    this.numInstances = numInstances || 1;\n\n    for (const attributeName in attributes) {\n      const attribute = attributes[attributeName];\n      const settings = attribute.getTransitionSetting(transitions);\n      if (!settings) continue;\n\n      this._updateAttribute(attributeName, attribute, settings);\n    }\n\n    for (const attributeName in this.transitions) {\n      const attribute = attributes[attributeName];\n\n      if (!attribute || !attribute.getTransitionSetting(transitions)) {\n        this._removeTransition(attributeName);\n      }\n    }\n  }\n\n  hasAttribute(attributeName) {\n    const transition = this.transitions[attributeName];\n    return transition && transition.inProgress;\n  }\n\n  getAttributes() {\n    const animatedAttributes = {};\n\n    for (const attributeName in this.transitions) {\n      const transition = this.transitions[attributeName];\n\n      if (transition.inProgress) {\n        animatedAttributes[attributeName] = transition.attributeInTransition;\n      }\n    }\n\n    return animatedAttributes;\n  }\n\n  run() {\n    if (!this.isSupported || this.numInstances === 0) {\n      return false;\n    }\n\n    for (const attributeName in this.transitions) {\n      const updated = this.transitions[attributeName].update();\n\n      if (updated) {\n        this.needsRedraw = true;\n      }\n    }\n\n    const needsRedraw = this.needsRedraw;\n    this.needsRedraw = false;\n    return needsRedraw;\n  }\n\n  _removeTransition(attributeName) {\n    this.transitions[attributeName].cancel();\n    delete this.transitions[attributeName];\n  }\n\n  _updateAttribute(attributeName, attribute, settings) {\n    const transition = this.transitions[attributeName];\n    let isNew = !transition || transition.type !== settings.type;\n\n    if (isNew) {\n      if (!this.isSupported) {\n        _utils_log__WEBPACK_IMPORTED_MODULE_3__[\"default\"].warn(\"WebGL2 not supported by this browser. Transition for \".concat(attributeName, \" is disabled.\"))();\n        return;\n      }\n\n      if (transition) {\n        this._removeTransition(attributeName);\n      }\n\n      const TransitionType = TRANSITION_TYPES[settings.type];\n\n      if (TransitionType) {\n        this.transitions[attributeName] = new TransitionType({\n          attribute,\n          timeline: this.timeline,\n          gl: this.gl\n        });\n      } else {\n        _utils_log__WEBPACK_IMPORTED_MODULE_3__[\"default\"].error(\"unsupported transition type '\".concat(settings.type, \"'\"))();\n        isNew = false;\n      }\n    }\n\n    if (isNew || attribute.needsRedraw()) {\n      this.needsRedraw = true;\n      this.transitions[attributeName].start(settings, this.numInstances);\n    }\n  }\n\n}\n//# sourceMappingURL=attribute-transition-manager.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lib/attribute/attribute-transition-manager.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lib/attribute/attribute-transition-utils.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lib/attribute/attribute-transition-utils.js ***!
  \*****************************************************************************************/
/*! exports provided: normalizeTransitionSettings, getSourceBufferAttribute, getAttributeTypeFromSize, cycleBuffers, getAttributeBufferLength, padBuffer */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"normalizeTransitionSettings\", function() { return normalizeTransitionSettings; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getSourceBufferAttribute\", function() { return getSourceBufferAttribute; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getAttributeTypeFromSize\", function() { return getAttributeTypeFromSize; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"cycleBuffers\", function() { return cycleBuffers; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getAttributeBufferLength\", function() { return getAttributeBufferLength; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"padBuffer\", function() { return padBuffer; });\n/* harmony import */ var _utils_array_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/array-utils */ \"./node_modules/@deck.gl/core/dist/esm/utils/array-utils.js\");\n\nconst DEFAULT_TRANSITION_SETTINGS = {\n  interpolation: {\n    duration: 0,\n    easing: t => t\n  },\n  spring: {\n    stiffness: 0.05,\n    damping: 0.5\n  }\n};\nfunction normalizeTransitionSettings(userSettings, layerSettings) {\n  if (!userSettings) {\n    return null;\n  }\n\n  if (Number.isFinite(userSettings)) {\n    userSettings = {\n      duration: userSettings\n    };\n  }\n\n  userSettings.type = userSettings.type || 'interpolation';\n  return { ...DEFAULT_TRANSITION_SETTINGS[userSettings.type],\n    ...layerSettings,\n    ...userSettings\n  };\n}\nfunction getSourceBufferAttribute(gl, attribute) {\n  const buffer = attribute.getBuffer();\n\n  if (buffer) {\n    return [attribute.getBuffer(), {\n      divisor: 0,\n      size: attribute.size,\n      normalized: attribute.settings.normalized\n    }];\n  }\n\n  return attribute.value;\n}\nfunction getAttributeTypeFromSize(size) {\n  switch (size) {\n    case 1:\n      return 'float';\n\n    case 2:\n      return 'vec2';\n\n    case 3:\n      return 'vec3';\n\n    case 4:\n      return 'vec4';\n\n    default:\n      throw new Error(\"No defined attribute type for size \\\"\".concat(size, \"\\\"\"));\n  }\n}\nfunction cycleBuffers(buffers) {\n  buffers.push(buffers.shift());\n}\nfunction getAttributeBufferLength(attribute, numInstances) {\n  const {\n    doublePrecision,\n    settings,\n    value,\n    size\n  } = attribute;\n  const multiplier = doublePrecision && value instanceof Float64Array ? 2 : 1;\n  return (settings.noAlloc ? value.length : numInstances * size) * multiplier;\n}\nfunction padBuffer({\n  buffer,\n  numInstances,\n  attribute,\n  fromLength,\n  fromStartIndices,\n  getData = x => x\n}) {\n  const precisionMultiplier = attribute.doublePrecision && attribute.value instanceof Float64Array ? 2 : 1;\n  const size = attribute.size * precisionMultiplier;\n  const byteOffset = attribute.byteOffset;\n  const toStartIndices = attribute.startIndices;\n  const hasStartIndices = fromStartIndices && toStartIndices;\n  const toLength = getAttributeBufferLength(attribute, numInstances);\n  const isConstant = attribute.state.constant;\n\n  if (!hasStartIndices && fromLength >= toLength) {\n    return;\n  }\n\n  const toData = isConstant ? attribute.value : attribute.getBuffer().getData({\n    srcByteOffset: byteOffset\n  });\n\n  if (attribute.settings.normalized && !isConstant) {\n    const getter = getData;\n\n    getData = (value, chunk) => attribute._normalizeConstant(getter(value, chunk));\n  }\n\n  const getMissingData = isConstant ? (i, chunk) => getData(toData, chunk) : (i, chunk) => getData(toData.subarray(i, i + size), chunk);\n  const source = buffer.getData({\n    length: fromLength\n  });\n  const data = new Float32Array(toLength);\n  Object(_utils_array_utils__WEBPACK_IMPORTED_MODULE_0__[\"padArray\"])({\n    source,\n    target: data,\n    sourceStartIndices: fromStartIndices,\n    targetStartIndices: toStartIndices,\n    size,\n    getData: getMissingData\n  });\n\n  if (buffer.byteLength < data.byteLength + byteOffset) {\n    buffer.reallocate(data.byteLength + byteOffset);\n  }\n\n  buffer.subData({\n    data,\n    offset: byteOffset\n  });\n}\n//# sourceMappingURL=attribute-transition-utils.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS9saWIvYXR0cmlidXRlL2F0dHJpYnV0ZS10cmFuc2l0aW9uLXV0aWxzLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0BkZWNrLmdsL2NvcmUvZGlzdC9lc20vbGliL2F0dHJpYnV0ZS9hdHRyaWJ1dGUtdHJhbnNpdGlvbi11dGlscy5qcz8wZjdmIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IHBhZEFycmF5IH0gZnJvbSAnLi4vLi4vdXRpbHMvYXJyYXktdXRpbHMnO1xuY29uc3QgREVGQVVMVF9UUkFOU0lUSU9OX1NFVFRJTkdTID0ge1xuICBpbnRlcnBvbGF0aW9uOiB7XG4gICAgZHVyYXRpb246IDAsXG4gICAgZWFzaW5nOiB0ID0+IHRcbiAgfSxcbiAgc3ByaW5nOiB7XG4gICAgc3RpZmZuZXNzOiAwLjA1LFxuICAgIGRhbXBpbmc6IDAuNVxuICB9XG59O1xuZXhwb3J0IGZ1bmN0aW9uIG5vcm1hbGl6ZVRyYW5zaXRpb25TZXR0aW5ncyh1c2VyU2V0dGluZ3MsIGxheWVyU2V0dGluZ3MpIHtcbiAgaWYgKCF1c2VyU2V0dGluZ3MpIHtcbiAgICByZXR1cm4gbnVsbDtcbiAgfVxuXG4gIGlmIChOdW1iZXIuaXNGaW5pdGUodXNlclNldHRpbmdzKSkge1xuICAgIHVzZXJTZXR0aW5ncyA9IHtcbiAgICAgIGR1cmF0aW9uOiB1c2VyU2V0dGluZ3NcbiAgICB9O1xuICB9XG5cbiAgdXNlclNldHRpbmdzLnR5cGUgPSB1c2VyU2V0dGluZ3MudHlwZSB8fCAnaW50ZXJwb2xhdGlvbic7XG4gIHJldHVybiB7IC4uLkRFRkFVTFRfVFJBTlNJVElPTl9TRVRUSU5HU1t1c2VyU2V0dGluZ3MudHlwZV0sXG4gICAgLi4ubGF5ZXJTZXR0aW5ncyxcbiAgICAuLi51c2VyU2V0dGluZ3NcbiAgfTtcbn1cbmV4cG9ydCBmdW5jdGlvbiBnZXRTb3VyY2VCdWZmZXJBdHRyaWJ1dGUoZ2wsIGF0dHJpYnV0ZSkge1xuICBjb25zdCBidWZmZXIgPSBhdHRyaWJ1dGUuZ2V0QnVmZmVyKCk7XG5cbiAgaWYgKGJ1ZmZlcikge1xuICAgIHJldHVybiBbYXR0cmlidXRlLmdldEJ1ZmZlcigpLCB7XG4gICAgICBkaXZpc29yOiAwLFxuICAgICAgc2l6ZTogYXR0cmlidXRlLnNpemUsXG4gICAgICBub3JtYWxpemVkOiBhdHRyaWJ1dGUuc2V0dGluZ3Mubm9ybWFsaXplZFxuICAgIH1dO1xuICB9XG5cbiAgcmV0dXJuIGF0dHJpYnV0ZS52YWx1ZTtcbn1cbmV4cG9ydCBmdW5jdGlvbiBnZXRBdHRyaWJ1dGVUeXBlRnJvbVNpemUoc2l6ZSkge1xuICBzd2l0Y2ggKHNpemUpIHtcbiAgICBjYXNlIDE6XG4gICAgICByZXR1cm4gJ2Zsb2F0JztcblxuICAgIGNhc2UgMjpcbiAgICAgIHJldHVybiAndmVjMic7XG5cbiAgICBjYXNlIDM6XG4gICAgICByZXR1cm4gJ3ZlYzMnO1xuXG4gICAgY2FzZSA0OlxuICAgICAgcmV0dXJuICd2ZWM0JztcblxuICAgIGRlZmF1bHQ6XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoXCJObyBkZWZpbmVkIGF0dHJpYnV0ZSB0eXBlIGZvciBzaXplIFxcXCJcIi5jb25jYXQoc2l6ZSwgXCJcXFwiXCIpKTtcbiAgfVxufVxuZXhwb3J0IGZ1bmN0aW9uIGN5Y2xlQnVmZmVycyhidWZmZXJzKSB7XG4gIGJ1ZmZlcnMucHVzaChidWZmZXJzLnNoaWZ0KCkpO1xufVxuZXhwb3J0IGZ1bmN0aW9uIGdldEF0dHJpYnV0ZUJ1ZmZlckxlbmd0aChhdHRyaWJ1dGUsIG51bUluc3RhbmNlcykge1xuICBjb25zdCB7XG4gICAgZG91YmxlUHJlY2lzaW9uLFxuICAgIHNldHRpbmdzLFxuICAgIHZhbHVlLFxuICAgIHNpemVcbiAgfSA9IGF0dHJpYnV0ZTtcbiAgY29uc3QgbXVsdGlwbGllciA9IGRvdWJsZVByZWNpc2lvbiAmJiB2YWx1ZSBpbnN0YW5jZW9mIEZsb2F0NjRBcnJheSA/IDIgOiAxO1xuICByZXR1cm4gKHNldHRpbmdzLm5vQWxsb2MgPyB2YWx1ZS5sZW5ndGggOiBudW1JbnN0YW5jZXMgKiBzaXplKSAqIG11bHRpcGxpZXI7XG59XG5leHBvcnQgZnVuY3Rpb24gcGFkQnVmZmVyKHtcbiAgYnVmZmVyLFxuICBudW1JbnN0YW5jZXMsXG4gIGF0dHJpYnV0ZSxcbiAgZnJvbUxlbmd0aCxcbiAgZnJvbVN0YXJ0SW5kaWNlcyxcbiAgZ2V0RGF0YSA9IHggPT4geFxufSkge1xuICBjb25zdCBwcmVjaXNpb25NdWx0aXBsaWVyID0gYXR0cmlidXRlLmRvdWJsZVByZWNpc2lvbiAmJiBhdHRyaWJ1dGUudmFsdWUgaW5zdGFuY2VvZiBGbG9hdDY0QXJyYXkgPyAyIDogMTtcbiAgY29uc3Qgc2l6ZSA9IGF0dHJpYnV0ZS5zaXplICogcHJlY2lzaW9uTXVsdGlwbGllcjtcbiAgY29uc3QgYnl0ZU9mZnNldCA9IGF0dHJpYnV0ZS5ieXRlT2Zmc2V0O1xuICBjb25zdCB0b1N0YXJ0SW5kaWNlcyA9IGF0dHJpYnV0ZS5zdGFydEluZGljZXM7XG4gIGNvbnN0IGhhc1N0YXJ0SW5kaWNlcyA9IGZyb21TdGFydEluZGljZXMgJiYgdG9TdGFydEluZGljZXM7XG4gIGNvbnN0IHRvTGVuZ3RoID0gZ2V0QXR0cmlidXRlQnVmZmVyTGVuZ3RoKGF0dHJpYnV0ZSwgbnVtSW5zdGFuY2VzKTtcbiAgY29uc3QgaXNDb25zdGFudCA9IGF0dHJpYnV0ZS5zdGF0ZS5jb25zdGFudDtcblxuICBpZiAoIWhhc1N0YXJ0SW5kaWNlcyAmJiBmcm9tTGVuZ3RoID49IHRvTGVuZ3RoKSB7XG4gICAgcmV0dXJuO1xuICB9XG5cbiAgY29uc3QgdG9EYXRhID0gaXNDb25zdGFudCA/IGF0dHJpYnV0ZS52YWx1ZSA6IGF0dHJpYnV0ZS5nZXRCdWZmZXIoKS5nZXREYXRhKHtcbiAgICBzcmNCeXRlT2Zmc2V0OiBieXRlT2Zmc2V0XG4gIH0pO1xuXG4gIGlmIChhdHRyaWJ1dGUuc2V0dGluZ3Mubm9ybWFsaXplZCAmJiAhaXNDb25zdGFudCkge1xuICAgIGNvbnN0IGdldHRlciA9IGdldERhdGE7XG5cbiAgICBnZXREYXRhID0gKHZhbHVlLCBjaHVuaykgPT4gYXR0cmlidXRlLl9ub3JtYWxpemVDb25zdGFudChnZXR0ZXIodmFsdWUsIGNodW5rKSk7XG4gIH1cblxuICBjb25zdCBnZXRNaXNzaW5nRGF0YSA9IGlzQ29uc3RhbnQgPyAoaSwgY2h1bmspID0+IGdldERhdGEodG9EYXRhLCBjaHVuaykgOiAoaSwgY2h1bmspID0+IGdldERhdGEodG9EYXRhLnN1YmFycmF5KGksIGkgKyBzaXplKSwgY2h1bmspO1xuICBjb25zdCBzb3VyY2UgPSBidWZmZXIuZ2V0RGF0YSh7XG4gICAgbGVuZ3RoOiBmcm9tTGVuZ3RoXG4gIH0pO1xuICBjb25zdCBkYXRhID0gbmV3IEZsb2F0MzJBcnJheSh0b0xlbmd0aCk7XG4gIHBhZEFycmF5KHtcbiAgICBzb3VyY2UsXG4gICAgdGFyZ2V0OiBkYXRhLFxuICAgIHNvdXJjZVN0YXJ0SW5kaWNlczogZnJvbVN0YXJ0SW5kaWNlcyxcbiAgICB0YXJnZXRTdGFydEluZGljZXM6IHRvU3RhcnRJbmRpY2VzLFxuICAgIHNpemUsXG4gICAgZ2V0RGF0YTogZ2V0TWlzc2luZ0RhdGFcbiAgfSk7XG5cbiAgaWYgKGJ1ZmZlci5ieXRlTGVuZ3RoIDwgZGF0YS5ieXRlTGVuZ3RoICsgYnl0ZU9mZnNldCkge1xuICAgIGJ1ZmZlci5yZWFsbG9jYXRlKGRhdGEuYnl0ZUxlbmd0aCArIGJ5dGVPZmZzZXQpO1xuICB9XG5cbiAgYnVmZmVyLnN1YkRhdGEoe1xuICAgIGRhdGEsXG4gICAgb2Zmc2V0OiBieXRlT2Zmc2V0XG4gIH0pO1xufVxuLy8jIHNvdXJjZU1hcHBpbmdVUkw9YXR0cmlidXRlLXRyYW5zaXRpb24tdXRpbHMuanMubWFwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lib/attribute/attribute-transition-utils.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lib/attribute/attribute.js":
/*!************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lib/attribute/attribute.js ***!
  \************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return Attribute; });\n/* harmony import */ var _data_column__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./data-column */ \"./node_modules/@deck.gl/core/dist/esm/lib/attribute/data-column.js\");\n/* harmony import */ var _utils_assert__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/assert */ \"./node_modules/@deck.gl/core/dist/esm/utils/assert.js\");\n/* harmony import */ var _utils_iterable_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/iterable-utils */ \"./node_modules/@deck.gl/core/dist/esm/utils/iterable-utils.js\");\n/* harmony import */ var _utils_flatten__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/flatten */ \"./node_modules/@deck.gl/core/dist/esm/utils/flatten.js\");\n/* harmony import */ var _utils_range__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/range */ \"./node_modules/@deck.gl/core/dist/esm/utils/range.js\");\n/* harmony import */ var _attribute_transition_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./attribute-transition-utils */ \"./node_modules/@deck.gl/core/dist/esm/lib/attribute/attribute-transition-utils.js\");\n\n\n\n\n\n\nclass Attribute extends _data_column__WEBPACK_IMPORTED_MODULE_0__[\"default\"] {\n  constructor(gl, opts = {}) {\n    super(gl, opts);\n    const {\n      transition = false,\n      noAlloc = false,\n      update = null,\n      accessor = null,\n      transform = null,\n      startIndices = null\n    } = opts;\n    Object.assign(this.settings, {\n      transition,\n      noAlloc,\n      update: update || accessor && this._autoUpdater,\n      accessor,\n      transform\n    });\n    Object.assign(this.state, {\n      lastExternalBuffer: null,\n      binaryValue: null,\n      binaryAccessor: null,\n      needsUpdate: true,\n      needsRedraw: false,\n      updateRanges: _utils_range__WEBPACK_IMPORTED_MODULE_4__[\"FULL\"],\n      startIndices\n    });\n    Object.seal(this.settings);\n    Object.seal(this.state);\n\n    this._validateAttributeUpdaters();\n  }\n\n  get startIndices() {\n    return this.state.startIndices;\n  }\n\n  set startIndices(layout) {\n    this.state.startIndices = layout;\n  }\n\n  needsUpdate() {\n    return this.state.needsUpdate;\n  }\n\n  needsRedraw({\n    clearChangedFlags = false\n  } = {}) {\n    const needsRedraw = this.state.needsRedraw;\n    this.state.needsRedraw = needsRedraw && !clearChangedFlags;\n    return needsRedraw;\n  }\n\n  getUpdateTriggers() {\n    const {\n      accessor\n    } = this.settings;\n    return [this.id].concat(typeof accessor !== 'function' && accessor || []);\n  }\n\n  supportsTransition() {\n    return Boolean(this.settings.transition);\n  }\n\n  getTransitionSetting(opts) {\n    if (!opts || !this.supportsTransition()) {\n      return null;\n    }\n\n    const {\n      accessor\n    } = this.settings;\n    const layerSettings = this.settings.transition;\n    const userSettings = Array.isArray(accessor) ? opts[accessor.find(a => opts[a])] : opts[accessor];\n    return Object(_attribute_transition_utils__WEBPACK_IMPORTED_MODULE_5__[\"normalizeTransitionSettings\"])(userSettings, layerSettings);\n  }\n\n  setNeedsUpdate(reason = this.id, dataRange) {\n    this.state.needsUpdate = this.state.needsUpdate || reason;\n    this.setNeedsRedraw(reason);\n\n    if (dataRange) {\n      const {\n        startRow = 0,\n        endRow = Infinity\n      } = dataRange;\n      this.state.updateRanges = _utils_range__WEBPACK_IMPORTED_MODULE_4__[\"add\"](this.state.updateRanges, [startRow, endRow]);\n    } else {\n      this.state.updateRanges = _utils_range__WEBPACK_IMPORTED_MODULE_4__[\"FULL\"];\n    }\n  }\n\n  clearNeedsUpdate() {\n    this.state.needsUpdate = false;\n    this.state.updateRanges = _utils_range__WEBPACK_IMPORTED_MODULE_4__[\"EMPTY\"];\n  }\n\n  setNeedsRedraw(reason = this.id) {\n    this.state.needsRedraw = this.state.needsRedraw || reason;\n  }\n\n  update(opts) {\n    this.setData(opts);\n  }\n\n  allocate(numInstances) {\n    const {\n      state,\n      settings\n    } = this;\n\n    if (settings.noAlloc) {\n      return false;\n    }\n\n    if (settings.update) {\n      super.allocate({\n        numInstances,\n        copy: state.updateRanges !== _utils_range__WEBPACK_IMPORTED_MODULE_4__[\"FULL\"]\n      });\n      return true;\n    }\n\n    return false;\n  }\n\n  updateBuffer({\n    numInstances,\n    data,\n    props,\n    context\n  }) {\n    if (!this.needsUpdate()) {\n      return false;\n    }\n\n    const {\n      state: {\n        updateRanges\n      },\n      settings: {\n        update,\n        noAlloc\n      }\n    } = this;\n    let updated = true;\n\n    if (update) {\n      for (const [startRow, endRow] of updateRanges) {\n        update.call(context, this, {\n          data,\n          startRow,\n          endRow,\n          props,\n          numInstances\n        });\n      }\n\n      if (!this.value) {} else if (this.constant || this.buffer.byteLength < this.value.byteLength + this.byteOffset) {\n        this.setData({\n          value: this.value,\n          constant: this.constant\n        });\n      } else {\n        for (const [startRow, endRow] of updateRanges) {\n          const startOffset = Number.isFinite(startRow) ? this.getVertexOffset(startRow) : 0;\n          const endOffset = Number.isFinite(endRow) ? this.getVertexOffset(endRow) : noAlloc || !Number.isFinite(numInstances) ? this.value.length : numInstances * this.size;\n          super.updateSubBuffer({\n            startOffset,\n            endOffset\n          });\n        }\n      }\n\n      this._checkAttributeArray();\n    } else {\n      updated = false;\n    }\n\n    this.clearNeedsUpdate();\n    this.setNeedsRedraw();\n    return updated;\n  }\n\n  setConstantValue(value) {\n    if (value === undefined || typeof value === 'function') {\n      return false;\n    }\n\n    const hasChanged = this.setData({\n      constant: true,\n      value\n    });\n\n    if (hasChanged) {\n      this.setNeedsRedraw();\n    }\n\n    this.clearNeedsUpdate();\n    return true;\n  }\n\n  setExternalBuffer(buffer) {\n    const {\n      state\n    } = this;\n\n    if (!buffer) {\n      state.lastExternalBuffer = null;\n      return false;\n    }\n\n    this.clearNeedsUpdate();\n\n    if (state.lastExternalBuffer === buffer) {\n      return true;\n    }\n\n    state.lastExternalBuffer = buffer;\n    this.setNeedsRedraw();\n    this.setData(buffer);\n    return true;\n  }\n\n  setBinaryValue(buffer, startIndices = null) {\n    const {\n      state,\n      settings\n    } = this;\n\n    if (!buffer) {\n      state.binaryValue = null;\n      state.binaryAccessor = null;\n      return false;\n    }\n\n    if (settings.noAlloc) {\n      return false;\n    }\n\n    if (state.binaryValue === buffer) {\n      this.clearNeedsUpdate();\n      return true;\n    }\n\n    state.binaryValue = buffer;\n    this.setNeedsRedraw();\n\n    if (ArrayBuffer.isView(buffer)) {\n      buffer = {\n        value: buffer\n      };\n    }\n\n    const needsUpdate = settings.transform || startIndices !== this.startIndices;\n\n    if (needsUpdate) {\n      Object(_utils_assert__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(ArrayBuffer.isView(buffer.value), \"invalid \".concat(settings.accessor));\n      const needsNormalize = buffer.size && buffer.size !== this.size;\n      state.binaryAccessor = Object(_utils_iterable_utils__WEBPACK_IMPORTED_MODULE_2__[\"getAccessorFromBuffer\"])(buffer.value, {\n        size: buffer.size || this.size,\n        stride: buffer.stride,\n        offset: buffer.offset,\n        startIndices,\n        nested: needsNormalize\n      });\n      return false;\n    }\n\n    this.clearNeedsUpdate();\n    this.setData(buffer);\n    return true;\n  }\n\n  getVertexOffset(row) {\n    const {\n      startIndices\n    } = this;\n    const vertexIndex = startIndices ? startIndices[row] : row;\n    return vertexIndex * this.size;\n  }\n\n  getShaderAttributes() {\n    const shaderAttributeDefs = this.settings.shaderAttributes || {\n      [this.id]: null\n    };\n    const shaderAttributes = {};\n\n    for (const shaderAttributeName in shaderAttributeDefs) {\n      Object.assign(shaderAttributes, super.getShaderAttributes(shaderAttributeName, shaderAttributeDefs[shaderAttributeName]));\n    }\n\n    return shaderAttributes;\n  }\n\n  _autoUpdater(attribute, {\n    data,\n    startRow,\n    endRow,\n    props,\n    numInstances\n  }) {\n    if (attribute.constant) {\n      return;\n    }\n\n    const {\n      settings,\n      state,\n      value,\n      size,\n      startIndices\n    } = attribute;\n    const {\n      accessor,\n      transform\n    } = settings;\n    const accessorFunc = state.binaryAccessor || (typeof accessor === 'function' ? accessor : props[accessor]);\n    Object(_utils_assert__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(typeof accessorFunc === 'function', \"accessor \\\"\".concat(accessor, \"\\\" is not a function\"));\n    let i = attribute.getVertexOffset(startRow);\n    const {\n      iterable,\n      objectInfo\n    } = Object(_utils_iterable_utils__WEBPACK_IMPORTED_MODULE_2__[\"createIterable\"])(data, startRow, endRow);\n\n    for (const object of iterable) {\n      objectInfo.index++;\n      let objectValue = accessorFunc(object, objectInfo);\n\n      if (transform) {\n        objectValue = transform.call(this, objectValue);\n      }\n\n      if (startIndices) {\n        const numVertices = (objectInfo.index < startIndices.length - 1 ? startIndices[objectInfo.index + 1] : numInstances) - startIndices[objectInfo.index];\n\n        if (objectValue && Array.isArray(objectValue[0])) {\n          let startIndex = i;\n\n          for (const item of objectValue) {\n            attribute._normalizeValue(item, value, startIndex);\n\n            startIndex += size;\n          }\n        } else if (objectValue && objectValue.length > size) {\n          value.set(objectValue, i);\n        } else {\n          attribute._normalizeValue(objectValue, objectInfo.target, 0);\n\n          Object(_utils_flatten__WEBPACK_IMPORTED_MODULE_3__[\"fillArray\"])({\n            target: value,\n            source: objectInfo.target,\n            start: i,\n            count: numVertices\n          });\n        }\n\n        i += numVertices * size;\n      } else {\n        attribute._normalizeValue(objectValue, value, i);\n\n        i += size;\n      }\n    }\n  }\n\n  _validateAttributeUpdaters() {\n    const {\n      settings\n    } = this;\n    const hasUpdater = settings.noAlloc || typeof settings.update === 'function';\n\n    if (!hasUpdater) {\n      throw new Error(\"Attribute \".concat(this.id, \" missing update or accessor\"));\n    }\n  }\n\n  _checkAttributeArray() {\n    const {\n      value\n    } = this;\n    const limit = Math.min(4, this.size);\n\n    if (value && value.length >= limit) {\n      let valid = true;\n\n      switch (limit) {\n        case 4:\n          valid = valid && Number.isFinite(value[3]);\n\n        case 3:\n          valid = valid && Number.isFinite(value[2]);\n\n        case 2:\n          valid = valid && Number.isFinite(value[1]);\n\n        case 1:\n          valid = valid && Number.isFinite(value[0]);\n          break;\n\n        default:\n          valid = false;\n      }\n\n      if (!valid) {\n        throw new Error(\"Illegal attribute generated for \".concat(this.id));\n      }\n    }\n  }\n\n}\n//# sourceMappingURL=attribute.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lib/attribute/attribute.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lib/attribute/data-column.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lib/attribute/data-column.js ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return DataColumn; });\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/webgl/dist/esm/features/features.js\");\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/webgl/dist/esm/features/webgl-features-table.js\");\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/webgl/dist/esm/classes/buffer.js\");\n/* harmony import */ var _shader_attribute__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./shader-attribute */ \"./node_modules/@deck.gl/core/dist/esm/lib/attribute/shader-attribute.js\");\n/* harmony import */ var _gl_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./gl-utils */ \"./node_modules/@deck.gl/core/dist/esm/lib/attribute/gl-utils.js\");\n/* harmony import */ var _utils_typed_array_manager__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/typed-array-manager */ \"./node_modules/@deck.gl/core/dist/esm/utils/typed-array-manager.js\");\n/* harmony import */ var _utils_math_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/math-utils */ \"./node_modules/@deck.gl/core/dist/esm/utils/math-utils.js\");\n/* harmony import */ var _utils_log__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../utils/log */ \"./node_modules/@deck.gl/core/dist/esm/utils/log.js\");\n\n\n\n\n\n\n\nfunction getStride(accessor) {\n  return accessor.stride || accessor.size * accessor.bytesPerElement;\n}\n\nfunction resolveShaderAttribute(baseAccessor, shaderAttributeOptions) {\n  if (shaderAttributeOptions.offset) {\n    _utils_log__WEBPACK_IMPORTED_MODULE_7__[\"default\"].removed('shaderAttribute.offset', 'vertexOffset, elementOffset')();\n  }\n\n  const stride = getStride(baseAccessor);\n  const vertexOffset = 'vertexOffset' in shaderAttributeOptions ? shaderAttributeOptions.vertexOffset : baseAccessor.vertexOffset || 0;\n  const elementOffset = shaderAttributeOptions.elementOffset || 0;\n  const offset = vertexOffset * stride + elementOffset * baseAccessor.bytesPerElement + (baseAccessor.offset || 0);\n  return { ...shaderAttributeOptions,\n    offset,\n    stride\n  };\n}\n\nfunction resolveDoublePrecisionShaderAttributes(baseAccessor, shaderAttributeOptions) {\n  const resolvedOptions = resolveShaderAttribute(baseAccessor, shaderAttributeOptions);\n  return {\n    high: resolvedOptions,\n    low: { ...resolvedOptions,\n      offset: resolvedOptions.offset + baseAccessor.size * 4\n    }\n  };\n}\n\nclass DataColumn {\n  constructor(gl, opts) {\n    this.gl = gl;\n    this.id = opts.id;\n    this.size = opts.size;\n    const logicalType = opts.logicalType || opts.type;\n    const doublePrecision = logicalType === 5130;\n    let {\n      defaultValue\n    } = opts;\n    defaultValue = Number.isFinite(defaultValue) ? [defaultValue] : defaultValue || new Array(this.size).fill(0);\n    opts.defaultValue = defaultValue;\n    let bufferType = logicalType;\n\n    if (doublePrecision) {\n      bufferType = 5126;\n    } else if (!bufferType && opts.isIndexed) {\n      bufferType = gl && Object(_luma_gl_core__WEBPACK_IMPORTED_MODULE_0__[\"hasFeature\"])(gl, _luma_gl_core__WEBPACK_IMPORTED_MODULE_1__[\"FEATURES\"].ELEMENT_INDEX_UINT32) ? 5125 : 5123;\n    } else if (!bufferType) {\n      bufferType = 5126;\n    }\n\n    opts.logicalType = logicalType;\n    opts.type = bufferType;\n    let defaultType = Object(_gl_utils__WEBPACK_IMPORTED_MODULE_4__[\"glArrayFromType\"])(logicalType || bufferType || 5126);\n    this.shaderAttributes = {};\n    this.doublePrecision = doublePrecision;\n\n    if (doublePrecision && opts.fp64 === false) {\n      defaultType = Float32Array;\n    }\n\n    opts.bytesPerElement = defaultType.BYTES_PER_ELEMENT;\n    this.defaultType = defaultType;\n    this.value = null;\n    this.settings = opts;\n    this.state = {\n      externalBuffer: null,\n      bufferAccessor: opts,\n      allocatedValue: null,\n      constant: false\n    };\n    this._buffer = null;\n    this.setData(opts);\n  }\n\n  get buffer() {\n    if (!this._buffer) {\n      const {\n        isIndexed,\n        type\n      } = this.settings;\n      this._buffer = new _luma_gl_core__WEBPACK_IMPORTED_MODULE_2__[\"default\"](this.gl, {\n        id: this.id,\n        target: isIndexed ? 34963 : 34962,\n        accessor: {\n          type\n        }\n      });\n    }\n\n    return this._buffer;\n  }\n\n  get byteOffset() {\n    const accessor = this.getAccessor();\n\n    if (accessor.vertexOffset) {\n      return accessor.vertexOffset * getStride(accessor);\n    }\n\n    return 0;\n  }\n\n  delete() {\n    if (this._buffer) {\n      this._buffer.delete();\n\n      this._buffer = null;\n    }\n\n    _utils_typed_array_manager__WEBPACK_IMPORTED_MODULE_5__[\"default\"].release(this.state.allocatedValue);\n  }\n\n  getShaderAttributes(id, options) {\n    if (this.doublePrecision) {\n      const shaderAttributes = {};\n      const isBuffer64Bit = this.value instanceof Float64Array;\n      const doubleShaderAttributeDefs = resolveDoublePrecisionShaderAttributes(this.getAccessor(), options || {});\n      shaderAttributes[id] = new _shader_attribute__WEBPACK_IMPORTED_MODULE_3__[\"default\"](this, doubleShaderAttributeDefs.high);\n      shaderAttributes[\"\".concat(id, \"64Low\")] = isBuffer64Bit ? new _shader_attribute__WEBPACK_IMPORTED_MODULE_3__[\"default\"](this, doubleShaderAttributeDefs.low) : new Float32Array(this.size);\n      return shaderAttributes;\n    }\n\n    if (options) {\n      const shaderAttributeDef = resolveShaderAttribute(this.getAccessor(), options);\n      return {\n        [id]: new _shader_attribute__WEBPACK_IMPORTED_MODULE_3__[\"default\"](this, shaderAttributeDef)\n      };\n    }\n\n    return {\n      [id]: this\n    };\n  }\n\n  getBuffer() {\n    if (this.state.constant) {\n      return null;\n    }\n\n    return this.state.externalBuffer || this._buffer;\n  }\n\n  getValue() {\n    if (this.state.constant) {\n      return this.value;\n    }\n\n    return [this.getBuffer(), this.getAccessor()];\n  }\n\n  getAccessor() {\n    return this.state.bufferAccessor;\n  }\n\n  setData(opts) {\n    const {\n      state\n    } = this;\n\n    if (ArrayBuffer.isView(opts)) {\n      opts = {\n        value: opts\n      };\n    } else if (opts instanceof _luma_gl_core__WEBPACK_IMPORTED_MODULE_2__[\"default\"]) {\n      opts = {\n        buffer: opts\n      };\n    }\n\n    const accessor = { ...this.settings,\n      ...opts\n    };\n    state.bufferAccessor = accessor;\n\n    if (opts.constant) {\n      let value = opts.value;\n      value = this._normalizeValue(value, [], 0);\n\n      if (this.settings.normalized) {\n        value = this._normalizeConstant(value);\n      }\n\n      const hasChanged = !state.constant || !this._areValuesEqual(value, this.value);\n\n      if (!hasChanged) {\n        return false;\n      }\n\n      state.externalBuffer = null;\n      state.constant = true;\n      this.value = value;\n    } else if (opts.buffer) {\n      const buffer = opts.buffer;\n      state.externalBuffer = buffer;\n      state.constant = false;\n      this.value = opts.value;\n      const isBuffer64Bit = opts.value instanceof Float64Array;\n      accessor.type = opts.type || buffer.accessor.type;\n      accessor.bytesPerElement = buffer.accessor.BYTES_PER_ELEMENT * (isBuffer64Bit ? 2 : 1);\n      accessor.stride = getStride(accessor);\n    } else if (opts.value) {\n      this._checkExternalBuffer(opts);\n\n      let value = opts.value;\n      state.externalBuffer = null;\n      state.constant = false;\n      this.value = value;\n      accessor.bytesPerElement = value.BYTES_PER_ELEMENT;\n      accessor.stride = getStride(accessor);\n      const {\n        buffer,\n        byteOffset\n      } = this;\n\n      if (this.doublePrecision && value instanceof Float64Array) {\n        value = Object(_utils_math_utils__WEBPACK_IMPORTED_MODULE_6__[\"toDoublePrecisionArray\"])(value, accessor);\n      }\n\n      const requiredBufferSize = value.byteLength + byteOffset + accessor.stride * 2;\n\n      if (buffer.byteLength < requiredBufferSize) {\n        buffer.reallocate(requiredBufferSize);\n      }\n\n      buffer.setAccessor(null);\n      buffer.subData({\n        data: value,\n        offset: byteOffset\n      });\n      accessor.type = opts.type || buffer.accessor.type;\n    }\n\n    return true;\n  }\n\n  updateSubBuffer(opts = {}) {\n    const {\n      value\n    } = this;\n    const {\n      startOffset = 0,\n      endOffset\n    } = opts;\n    this.buffer.subData({\n      data: this.doublePrecision && value instanceof Float64Array ? Object(_utils_math_utils__WEBPACK_IMPORTED_MODULE_6__[\"toDoublePrecisionArray\"])(value, {\n        size: this.size,\n        startIndex: startOffset,\n        endIndex: endOffset\n      }) : value.subarray(startOffset, endOffset),\n      offset: startOffset * value.BYTES_PER_ELEMENT + this.byteOffset\n    });\n  }\n\n  allocate({\n    numInstances,\n    copy = false\n  }) {\n    const {\n      state\n    } = this;\n    const oldValue = state.allocatedValue;\n    const value = _utils_typed_array_manager__WEBPACK_IMPORTED_MODULE_5__[\"default\"].allocate(oldValue, numInstances + 1, {\n      size: this.size,\n      type: this.defaultType,\n      copy\n    });\n    this.value = value;\n    const {\n      buffer,\n      byteOffset\n    } = this;\n\n    if (buffer.byteLength < value.byteLength + byteOffset) {\n      buffer.reallocate(value.byteLength + byteOffset);\n\n      if (copy && oldValue) {\n        buffer.subData({\n          data: oldValue instanceof Float64Array ? Object(_utils_math_utils__WEBPACK_IMPORTED_MODULE_6__[\"toDoublePrecisionArray\"])(oldValue, this) : oldValue,\n          offset: byteOffset\n        });\n      }\n    }\n\n    state.allocatedValue = value;\n    state.constant = false;\n    state.externalBuffer = null;\n    state.bufferAccessor = this.settings;\n    return true;\n  }\n\n  _checkExternalBuffer(opts) {\n    const {\n      value\n    } = opts;\n\n    if (!opts.constant && value) {\n      const ArrayType = this.defaultType;\n      let illegalArrayType = false;\n\n      if (this.doublePrecision) {\n        illegalArrayType = value.BYTES_PER_ELEMENT < 4;\n      }\n\n      if (illegalArrayType) {\n        throw new Error(\"Attribute \".concat(this.id, \" does not support \").concat(value.constructor.name));\n      }\n\n      if (!(value instanceof ArrayType) && this.settings.normalized && !('normalized' in opts)) {\n        _utils_log__WEBPACK_IMPORTED_MODULE_7__[\"default\"].warn(\"Attribute \".concat(this.id, \" is normalized\"))();\n      }\n    }\n  }\n\n  _normalizeConstant(value) {\n    switch (this.settings.type) {\n      case 5120:\n        return new Float32Array(value).map(x => (x + 128) / 255 * 2 - 1);\n\n      case 5122:\n        return new Float32Array(value).map(x => (x + 32768) / 65535 * 2 - 1);\n\n      case 5121:\n        return new Float32Array(value).map(x => x / 255);\n\n      case 5123:\n        return new Float32Array(value).map(x => x / 65535);\n\n      default:\n        return value;\n    }\n  }\n\n  _normalizeValue(value, out, start) {\n    const {\n      defaultValue,\n      size\n    } = this.settings;\n\n    if (Number.isFinite(value)) {\n      out[start] = value;\n      return out;\n    }\n\n    if (!value) {\n      out[start] = defaultValue[0];\n      return out;\n    }\n\n    switch (size) {\n      case 4:\n        out[start + 3] = Number.isFinite(value[3]) ? value[3] : defaultValue[3];\n\n      case 3:\n        out[start + 2] = Number.isFinite(value[2]) ? value[2] : defaultValue[2];\n\n      case 2:\n        out[start + 1] = Number.isFinite(value[1]) ? value[1] : defaultValue[1];\n\n      case 1:\n        out[start + 0] = Number.isFinite(value[0]) ? value[0] : defaultValue[0];\n        break;\n\n      default:\n        let i = size;\n\n        while (--i >= 0) {\n          out[start + i] = Number.isFinite(value[i]) ? value[i] : defaultValue[i];\n        }\n\n    }\n\n    return out;\n  }\n\n  _areValuesEqual(value1, value2) {\n    if (!value1 || !value2) {\n      return false;\n    }\n\n    const {\n      size\n    } = this;\n\n    for (let i = 0; i < size; i++) {\n      if (value1[i] !== value2[i]) {\n        return false;\n      }\n    }\n\n    return true;\n  }\n\n}\n//# sourceMappingURL=data-column.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lib/attribute/data-column.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lib/attribute/gl-utils.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lib/attribute/gl-utils.js ***!
  \***********************************************************************/
/*! exports provided: glArrayFromType */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"glArrayFromType\", function() { return glArrayFromType; });\nfunction glArrayFromType(glType) {\n  switch (glType) {\n    case 5126:\n      return Float32Array;\n\n    case 5130:\n      return Float64Array;\n\n    case 5123:\n    case 33635:\n    case 32819:\n    case 32820:\n      return Uint16Array;\n\n    case 5125:\n      return Uint32Array;\n\n    case 5121:\n      return Uint8ClampedArray;\n\n    case 5120:\n      return Int8Array;\n\n    case 5122:\n      return Int16Array;\n\n    case 5124:\n      return Int32Array;\n\n    default:\n      throw new Error('Unknown GL type');\n  }\n}\n//# sourceMappingURL=gl-utils.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS9saWIvYXR0cmlidXRlL2dsLXV0aWxzLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0BkZWNrLmdsL2NvcmUvZGlzdC9lc20vbGliL2F0dHJpYnV0ZS9nbC11dGlscy5qcz85MjdlIl0sInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCBmdW5jdGlvbiBnbEFycmF5RnJvbVR5cGUoZ2xUeXBlKSB7XG4gIHN3aXRjaCAoZ2xUeXBlKSB7XG4gICAgY2FzZSA1MTI2OlxuICAgICAgcmV0dXJuIEZsb2F0MzJBcnJheTtcblxuICAgIGNhc2UgNTEzMDpcbiAgICAgIHJldHVybiBGbG9hdDY0QXJyYXk7XG5cbiAgICBjYXNlIDUxMjM6XG4gICAgY2FzZSAzMzYzNTpcbiAgICBjYXNlIDMyODE5OlxuICAgIGNhc2UgMzI4MjA6XG4gICAgICByZXR1cm4gVWludDE2QXJyYXk7XG5cbiAgICBjYXNlIDUxMjU6XG4gICAgICByZXR1cm4gVWludDMyQXJyYXk7XG5cbiAgICBjYXNlIDUxMjE6XG4gICAgICByZXR1cm4gVWludDhDbGFtcGVkQXJyYXk7XG5cbiAgICBjYXNlIDUxMjA6XG4gICAgICByZXR1cm4gSW50OEFycmF5O1xuXG4gICAgY2FzZSA1MTIyOlxuICAgICAgcmV0dXJuIEludDE2QXJyYXk7XG5cbiAgICBjYXNlIDUxMjQ6XG4gICAgICByZXR1cm4gSW50MzJBcnJheTtcblxuICAgIGRlZmF1bHQ6XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ1Vua25vd24gR0wgdHlwZScpO1xuICB9XG59XG4vLyMgc291cmNlTWFwcGluZ1VSTD1nbC11dGlscy5qcy5tYXAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lib/attribute/gl-utils.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lib/attribute/shader-attribute.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lib/attribute/shader-attribute.js ***!
  \*******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return ShaderAttribute; });\nclass ShaderAttribute {\n  constructor(dataColumn, opts) {\n    this.opts = opts;\n    this.source = dataColumn;\n  }\n\n  get value() {\n    return this.source.value;\n  }\n\n  getValue() {\n    const buffer = this.source.getBuffer();\n    const accessor = this.getAccessor();\n\n    if (buffer) {\n      return [buffer, accessor];\n    }\n\n    const {\n      value\n    } = this.source;\n    const {\n      size\n    } = accessor;\n    let constantValue = value;\n\n    if (value && value.length !== size) {\n      constantValue = new Float32Array(size);\n      const index = accessor.elementOffset || 0;\n\n      for (let i = 0; i < size; ++i) {\n        constantValue[i] = value[index + i];\n      }\n    }\n\n    return constantValue;\n  }\n\n  getAccessor() {\n    return { ...this.source.getAccessor(),\n      ...this.opts\n    };\n  }\n\n}\n//# sourceMappingURL=shader-attribute.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS9saWIvYXR0cmlidXRlL3NoYWRlci1hdHRyaWJ1dGUuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS9saWIvYXR0cmlidXRlL3NoYWRlci1hdHRyaWJ1dGUuanM/MDkzOSJdLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgZGVmYXVsdCBjbGFzcyBTaGFkZXJBdHRyaWJ1dGUge1xuICBjb25zdHJ1Y3RvcihkYXRhQ29sdW1uLCBvcHRzKSB7XG4gICAgdGhpcy5vcHRzID0gb3B0cztcbiAgICB0aGlzLnNvdXJjZSA9IGRhdGFDb2x1bW47XG4gIH1cblxuICBnZXQgdmFsdWUoKSB7XG4gICAgcmV0dXJuIHRoaXMuc291cmNlLnZhbHVlO1xuICB9XG5cbiAgZ2V0VmFsdWUoKSB7XG4gICAgY29uc3QgYnVmZmVyID0gdGhpcy5zb3VyY2UuZ2V0QnVmZmVyKCk7XG4gICAgY29uc3QgYWNjZXNzb3IgPSB0aGlzLmdldEFjY2Vzc29yKCk7XG5cbiAgICBpZiAoYnVmZmVyKSB7XG4gICAgICByZXR1cm4gW2J1ZmZlciwgYWNjZXNzb3JdO1xuICAgIH1cblxuICAgIGNvbnN0IHtcbiAgICAgIHZhbHVlXG4gICAgfSA9IHRoaXMuc291cmNlO1xuICAgIGNvbnN0IHtcbiAgICAgIHNpemVcbiAgICB9ID0gYWNjZXNzb3I7XG4gICAgbGV0IGNvbnN0YW50VmFsdWUgPSB2YWx1ZTtcblxuICAgIGlmICh2YWx1ZSAmJiB2YWx1ZS5sZW5ndGggIT09IHNpemUpIHtcbiAgICAgIGNvbnN0YW50VmFsdWUgPSBuZXcgRmxvYXQzMkFycmF5KHNpemUpO1xuICAgICAgY29uc3QgaW5kZXggPSBhY2Nlc3Nvci5lbGVtZW50T2Zmc2V0IHx8IDA7XG5cbiAgICAgIGZvciAobGV0IGkgPSAwOyBpIDwgc2l6ZTsgKytpKSB7XG4gICAgICAgIGNvbnN0YW50VmFsdWVbaV0gPSB2YWx1ZVtpbmRleCArIGldO1xuICAgICAgfVxuICAgIH1cblxuICAgIHJldHVybiBjb25zdGFudFZhbHVlO1xuICB9XG5cbiAgZ2V0QWNjZXNzb3IoKSB7XG4gICAgcmV0dXJuIHsgLi4udGhpcy5zb3VyY2UuZ2V0QWNjZXNzb3IoKSxcbiAgICAgIC4uLnRoaXMub3B0c1xuICAgIH07XG4gIH1cblxufVxuLy8jIHNvdXJjZU1hcHBpbmdVUkw9c2hhZGVyLWF0dHJpYnV0ZS5qcy5tYXAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lib/attribute/shader-attribute.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lib/constants.js":
/*!**************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lib/constants.js ***!
  \**************************************************************/
/*! exports provided: COORDINATE_SYSTEM, PROJECTION_MODE, EVENTS */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"COORDINATE_SYSTEM\", function() { return COORDINATE_SYSTEM; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"PROJECTION_MODE\", function() { return PROJECTION_MODE; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"EVENTS\", function() { return EVENTS; });\n/* harmony import */ var _utils_log__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/log */ \"./node_modules/@deck.gl/core/dist/esm/utils/log.js\");\n\nconst COORDINATE_SYSTEM = {\n  DEFAULT: -1,\n  LNGLAT: 1,\n  METER_OFFSETS: 2,\n  LNGLAT_OFFSETS: 3,\n  CARTESIAN: 0\n};\nObject.defineProperty(COORDINATE_SYSTEM, 'IDENTITY', {\n  get: () => _utils_log__WEBPACK_IMPORTED_MODULE_0__[\"default\"].deprecated('COORDINATE_SYSTEM.IDENTITY', 'COORDINATE_SYSTEM.CARTESIAN')() || 0\n});\nconst PROJECTION_MODE = {\n  WEB_MERCATOR: 1,\n  GLOBE: 2,\n  WEB_MERCATOR_AUTO_OFFSET: 4,\n  IDENTITY: 0\n};\nconst EVENTS = {\n  click: {\n    handler: 'onClick'\n  },\n  panstart: {\n    handler: 'onDragStart'\n  },\n  panmove: {\n    handler: 'onDrag'\n  },\n  panend: {\n    handler: 'onDragEnd'\n  }\n};\n//# sourceMappingURL=constants.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS9saWIvY29uc3RhbnRzLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0BkZWNrLmdsL2NvcmUvZGlzdC9lc20vbGliL2NvbnN0YW50cy5qcz81Nzc3Il0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBsb2cgZnJvbSAnLi4vdXRpbHMvbG9nJztcbmV4cG9ydCBjb25zdCBDT09SRElOQVRFX1NZU1RFTSA9IHtcbiAgREVGQVVMVDogLTEsXG4gIExOR0xBVDogMSxcbiAgTUVURVJfT0ZGU0VUUzogMixcbiAgTE5HTEFUX09GRlNFVFM6IDMsXG4gIENBUlRFU0lBTjogMFxufTtcbk9iamVjdC5kZWZpbmVQcm9wZXJ0eShDT09SRElOQVRFX1NZU1RFTSwgJ0lERU5USVRZJywge1xuICBnZXQ6ICgpID0+IGxvZy5kZXByZWNhdGVkKCdDT09SRElOQVRFX1NZU1RFTS5JREVOVElUWScsICdDT09SRElOQVRFX1NZU1RFTS5DQVJURVNJQU4nKSgpIHx8IDBcbn0pO1xuZXhwb3J0IGNvbnN0IFBST0pFQ1RJT05fTU9ERSA9IHtcbiAgV0VCX01FUkNBVE9SOiAxLFxuICBHTE9CRTogMixcbiAgV0VCX01FUkNBVE9SX0FVVE9fT0ZGU0VUOiA0LFxuICBJREVOVElUWTogMFxufTtcbmV4cG9ydCBjb25zdCBFVkVOVFMgPSB7XG4gIGNsaWNrOiB7XG4gICAgaGFuZGxlcjogJ29uQ2xpY2snXG4gIH0sXG4gIHBhbnN0YXJ0OiB7XG4gICAgaGFuZGxlcjogJ29uRHJhZ1N0YXJ0J1xuICB9LFxuICBwYW5tb3ZlOiB7XG4gICAgaGFuZGxlcjogJ29uRHJhZydcbiAgfSxcbiAgcGFuZW5kOiB7XG4gICAgaGFuZGxlcjogJ29uRHJhZ0VuZCdcbiAgfVxufTtcbi8vIyBzb3VyY2VNYXBwaW5nVVJMPWNvbnN0YW50cy5qcy5tYXAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lib/constants.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lib/deck-picker.js":
/*!****************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lib/deck-picker.js ***!
  \****************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return DeckPicker; });\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/webgl/dist/esm/classes/framebuffer.js\");\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/webgl/dist/esm/classes/texture-2d.js\");\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/gltools/dist/esm/index.js\");\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/webgl/dist/esm/classes/copy-and-blit.js\");\n/* harmony import */ var _utils_log__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/log */ \"./node_modules/@deck.gl/core/dist/esm/utils/log.js\");\n/* harmony import */ var _passes_pick_layers_pass__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../passes/pick-layers-pass */ \"./node_modules/@deck.gl/core/dist/esm/passes/pick-layers-pass.js\");\n/* harmony import */ var _picking_query_object__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./picking/query-object */ \"./node_modules/@deck.gl/core/dist/esm/lib/picking/query-object.js\");\n/* harmony import */ var _picking_pick_info__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./picking/pick-info */ \"./node_modules/@deck.gl/core/dist/esm/lib/picking/pick-info.js\");\n\n\n\n\n\nclass DeckPicker {\n  constructor(gl) {\n    this.gl = gl;\n    this.pickingFBO = null;\n    this.pickLayersPass = new _passes_pick_layers_pass__WEBPACK_IMPORTED_MODULE_5__[\"default\"](gl);\n    this.layerFilter = null;\n    this.lastPickedInfo = {\n      index: -1,\n      layerId: null,\n      info: null\n    };\n  }\n\n  setProps(props) {\n    if ('layerFilter' in props) {\n      this.layerFilter = props.layerFilter;\n    }\n\n    if ('_pickable' in props) {\n      this._pickable = props._pickable;\n    }\n  }\n\n  finalize() {\n    if (this.pickingFBO) {\n      this.pickingFBO.delete();\n    }\n\n    if (this.depthFBO) {\n      this.depthFBO.color.delete();\n      this.depthFBO.delete();\n    }\n  }\n\n  pickObject(opts) {\n    return this._pickClosestObject(opts);\n  }\n\n  pickObjects(opts) {\n    return this._pickVisibleObjects(opts);\n  }\n\n  getLastPickedObject({\n    x,\n    y,\n    layers,\n    viewports\n  }, lastPickedInfo = this.lastPickedInfo.info) {\n    const lastPickedLayerId = lastPickedInfo && lastPickedInfo.layer && lastPickedInfo.layer.id;\n    const lastPickedViewportId = lastPickedInfo && lastPickedInfo.viewport && lastPickedInfo.viewport.id;\n    const layer = lastPickedLayerId ? layers.find(l => l.id === lastPickedLayerId) : null;\n    const viewport = lastPickedViewportId && viewports.find(v => v.id === lastPickedViewportId) || viewports[0];\n    const coordinate = viewport && viewport.unproject([x - viewport.x, y - viewport.y]);\n    const info = {\n      x,\n      y,\n      viewport,\n      coordinate,\n      layer\n    };\n\n    if (layer) {\n      return { ...lastPickedInfo,\n        ...info\n      };\n    }\n\n    return Object.assign(info, {\n      color: null,\n      object: null,\n      index: -1\n    });\n  }\n\n  _resizeBuffer() {\n    const {\n      gl\n    } = this;\n\n    if (!this.pickingFBO) {\n      this.pickingFBO = new _luma_gl_core__WEBPACK_IMPORTED_MODULE_0__[\"default\"](gl);\n\n      if (_luma_gl_core__WEBPACK_IMPORTED_MODULE_0__[\"default\"].isSupported(gl, {\n        colorBufferFloat: true\n      })) {\n        this.depthFBO = new _luma_gl_core__WEBPACK_IMPORTED_MODULE_0__[\"default\"](gl);\n        this.depthFBO.attach({\n          [36064]: new _luma_gl_core__WEBPACK_IMPORTED_MODULE_1__[\"default\"](gl, {\n            format: Object(_luma_gl_core__WEBPACK_IMPORTED_MODULE_2__[\"isWebGL2\"])(gl) ? 34836 : 6408,\n            type: 5126\n          })\n        });\n      }\n    }\n\n    this.pickingFBO.resize({\n      width: gl.canvas.width,\n      height: gl.canvas.height\n    });\n\n    if (this.depthFBO) {\n      this.depthFBO.resize({\n        width: gl.canvas.width,\n        height: gl.canvas.height\n      });\n    }\n\n    return this.pickingFBO;\n  }\n\n  _getPickable(layers) {\n    if (this._pickable === false) {\n      return null;\n    }\n\n    const pickableLayers = layers.filter(layer => layer.isPickable() && !layer.isComposite);\n\n    if (pickableLayers.length > 255) {\n      _utils_log__WEBPACK_IMPORTED_MODULE_4__[\"default\"].warn('Too many pickable layers, only picking the first 255')();\n      return pickableLayers.slice(0, 255);\n    }\n\n    return pickableLayers.length ? pickableLayers : null;\n  }\n\n  _pickClosestObject({\n    layers,\n    views,\n    viewports,\n    x,\n    y,\n    radius = 0,\n    depth = 1,\n    mode = 'query',\n    unproject3D,\n    onViewportActive\n  }) {\n    layers = this._getPickable(layers);\n\n    if (!layers) {\n      return {\n        result: [],\n        emptyInfo: Object(_picking_pick_info__WEBPACK_IMPORTED_MODULE_7__[\"getEmptyPickingInfo\"])({\n          viewports,\n          x,\n          y\n        })\n      };\n    }\n\n    this._resizeBuffer();\n\n    const pixelRatio = Object(_luma_gl_core__WEBPACK_IMPORTED_MODULE_2__[\"cssToDeviceRatio\"])(this.gl);\n    const devicePixelRange = Object(_luma_gl_core__WEBPACK_IMPORTED_MODULE_2__[\"cssToDevicePixels\"])(this.gl, [x, y], true);\n    const devicePixel = [devicePixelRange.x + Math.floor(devicePixelRange.width / 2), devicePixelRange.y + Math.floor(devicePixelRange.height / 2)];\n    const deviceRadius = Math.round(radius * pixelRatio);\n    const {\n      width,\n      height\n    } = this.pickingFBO;\n\n    const deviceRect = this._getPickingRect({\n      deviceX: devicePixel[0],\n      deviceY: devicePixel[1],\n      deviceRadius,\n      deviceWidth: width,\n      deviceHeight: height\n    });\n\n    let infos;\n    const result = [];\n    const affectedLayers = {};\n\n    for (let i = 0; i < depth; i++) {\n      const pickedColors = deviceRect && this._drawAndSample({\n        layers,\n        views,\n        viewports,\n        onViewportActive,\n        deviceRect,\n        pass: \"picking:\".concat(mode),\n        redrawReason: mode\n      });\n\n      const pickInfo = Object(_picking_query_object__WEBPACK_IMPORTED_MODULE_6__[\"getClosestObject\"])({\n        pickedColors,\n        layers,\n        deviceX: devicePixel[0],\n        deviceY: devicePixel[1],\n        deviceRadius,\n        deviceRect\n      });\n      let z;\n\n      if (pickInfo.pickedLayer && unproject3D && this.depthFBO) {\n        const zValues = this._drawAndSample({\n          layers: [pickInfo.pickedLayer],\n          views,\n          viewports,\n          onViewportActive,\n          deviceRect: {\n            x: pickInfo.pickedX,\n            y: pickInfo.pickedY,\n            width: 1,\n            height: 1\n          },\n          pass: \"picking:\".concat(mode),\n          redrawReason: 'pick-z',\n          pickZ: true\n        });\n\n        z = zValues[0] * viewports[0].distanceScales.metersPerUnit[2] + viewports[0].position[2];\n      }\n\n      if (pickInfo.pickedColor && i + 1 < depth) {\n        const layerId = pickInfo.pickedColor[3] - 1;\n        affectedLayers[layerId] = true;\n        layers[layerId].disablePickingIndex(pickInfo.pickedObjectIndex);\n      }\n\n      infos = Object(_picking_pick_info__WEBPACK_IMPORTED_MODULE_7__[\"processPickInfo\"])({\n        pickInfo,\n        lastPickedInfo: this.lastPickedInfo,\n        mode,\n        layers,\n        layerFilter: this.layerFilter,\n        viewports,\n        x,\n        y,\n        z,\n        pixelRatio\n      });\n\n      for (const info of infos.values()) {\n        if (info.layer) {\n          result.push(info);\n        }\n      }\n\n      if (!pickInfo.pickedColor) {\n        break;\n      }\n    }\n\n    for (const layerId in affectedLayers) {\n      layers[layerId].restorePickingColors();\n    }\n\n    return {\n      result,\n      emptyInfo: infos && infos.get(null)\n    };\n  }\n\n  _pickVisibleObjects({\n    layers,\n    views,\n    viewports,\n    x,\n    y,\n    width = 1,\n    height = 1,\n    mode = 'query',\n    maxObjects = null,\n    onViewportActive\n  }) {\n    layers = this._getPickable(layers);\n\n    if (!layers) {\n      return [];\n    }\n\n    this._resizeBuffer();\n\n    const pixelRatio = Object(_luma_gl_core__WEBPACK_IMPORTED_MODULE_2__[\"cssToDeviceRatio\"])(this.gl);\n    const leftTop = Object(_luma_gl_core__WEBPACK_IMPORTED_MODULE_2__[\"cssToDevicePixels\"])(this.gl, [x, y], true);\n    const deviceLeft = leftTop.x;\n    const deviceTop = leftTop.y + leftTop.height;\n    const rightBottom = Object(_luma_gl_core__WEBPACK_IMPORTED_MODULE_2__[\"cssToDevicePixels\"])(this.gl, [x + width, y + height], true);\n    const deviceRight = rightBottom.x + rightBottom.width;\n    const deviceBottom = rightBottom.y;\n    const deviceRect = {\n      x: deviceLeft,\n      y: deviceBottom,\n      width: deviceRight - deviceLeft,\n      height: deviceTop - deviceBottom\n    };\n\n    const pickedColors = this._drawAndSample({\n      layers,\n      views,\n      viewports,\n      onViewportActive,\n      deviceRect,\n      pass: \"picking:\".concat(mode),\n      redrawReason: mode\n    });\n\n    const pickInfos = Object(_picking_query_object__WEBPACK_IMPORTED_MODULE_6__[\"getUniqueObjects\"])({\n      pickedColors,\n      layers\n    });\n    const uniqueInfos = new Map();\n    const isMaxObjects = Number.isFinite(maxObjects);\n\n    for (let i = 0; i < pickInfos.length; i++) {\n      if (isMaxObjects && uniqueInfos.size >= maxObjects) {\n        break;\n      }\n\n      const pickInfo = pickInfos[i];\n      let info = {\n        color: pickInfo.pickedColor,\n        layer: null,\n        index: pickInfo.pickedObjectIndex,\n        picked: true,\n        x,\n        y,\n        width,\n        height,\n        pixelRatio\n      };\n      info = Object(_picking_pick_info__WEBPACK_IMPORTED_MODULE_7__[\"getLayerPickingInfo\"])({\n        layer: pickInfo.pickedLayer,\n        info,\n        mode\n      });\n\n      if (!uniqueInfos.has(info.object)) {\n        uniqueInfos.set(info.object, info);\n      }\n    }\n\n    return Array.from(uniqueInfos.values());\n  }\n\n  _drawAndSample({\n    layers,\n    views,\n    viewports,\n    onViewportActive,\n    deviceRect,\n    pass,\n    redrawReason,\n    pickZ\n  }) {\n    if (layers.length < 1) {\n      return null;\n    }\n\n    const pickingFBO = pickZ ? this.depthFBO : this.pickingFBO;\n    this.pickLayersPass.render({\n      layers,\n      layerFilter: this.layerFilter,\n      views,\n      viewports,\n      onViewportActive,\n      pickingFBO,\n      deviceRect,\n      pass,\n      redrawReason,\n      pickZ\n    });\n    const {\n      x,\n      y,\n      width,\n      height\n    } = deviceRect;\n    const pickedColors = new (pickZ ? Float32Array : Uint8Array)(width * height * 4);\n    Object(_luma_gl_core__WEBPACK_IMPORTED_MODULE_3__[\"readPixelsToArray\"])(pickingFBO, {\n      sourceX: x,\n      sourceY: y,\n      sourceWidth: width,\n      sourceHeight: height,\n      target: pickedColors\n    });\n    return pickedColors;\n  }\n\n  _getPickingRect({\n    deviceX,\n    deviceY,\n    deviceRadius,\n    deviceWidth,\n    deviceHeight\n  }) {\n    const x = Math.max(0, deviceX - deviceRadius);\n    const y = Math.max(0, deviceY - deviceRadius);\n    const width = Math.min(deviceWidth, deviceX + deviceRadius + 1) - x;\n    const height = Math.min(deviceHeight, deviceY + deviceRadius + 1) - y;\n\n    if (width <= 0 || height <= 0) {\n      return null;\n    }\n\n    return {\n      x,\n      y,\n      width,\n      height\n    };\n  }\n\n}\n//# sourceMappingURL=deck-picker.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lib/deck-picker.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lib/deck-renderer.js":
/*!******************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lib/deck-renderer.js ***!
  \******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return DeckRenderer; });\n/* harmony import */ var _debug__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../debug */ \"./node_modules/@deck.gl/core/dist/esm/debug/index.js\");\n/* harmony import */ var _passes_draw_layers_pass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../passes/draw-layers-pass */ \"./node_modules/@deck.gl/core/dist/esm/passes/draw-layers-pass.js\");\n/* harmony import */ var _passes_pick_layers_pass__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../passes/pick-layers-pass */ \"./node_modules/@deck.gl/core/dist/esm/passes/pick-layers-pass.js\");\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/webgl/dist/esm/classes/framebuffer.js\");\n\n\n\n\nconst TRACE_RENDER_LAYERS = 'deckRenderer.renderLayers';\nclass DeckRenderer {\n  constructor(gl) {\n    this.gl = gl;\n    this.layerFilter = null;\n    this.drawPickingColors = false;\n    this.drawLayersPass = new _passes_draw_layers_pass__WEBPACK_IMPORTED_MODULE_1__[\"default\"](gl);\n    this.pickLayersPass = new _passes_pick_layers_pass__WEBPACK_IMPORTED_MODULE_2__[\"default\"](gl);\n    this.renderCount = 0;\n    this._needsRedraw = 'Initial render';\n    this.renderBuffers = [];\n    this.lastPostProcessEffect = null;\n  }\n\n  setProps(props) {\n    if ('layerFilter' in props && this.layerFilter !== props.layerFilter) {\n      this.layerFilter = props.layerFilter;\n      this._needsRedraw = 'layerFilter changed';\n    }\n\n    if ('drawPickingColors' in props && this.drawPickingColors !== props.drawPickingColors) {\n      this.drawPickingColors = props.drawPickingColors;\n      this._needsRedraw = 'drawPickingColors changed';\n    }\n  }\n\n  renderLayers(opts) {\n    const layerPass = this.drawPickingColors ? this.pickLayersPass : this.drawLayersPass;\n    opts.layerFilter = this.layerFilter;\n    opts.effects = opts.effects || [];\n    opts.target = opts.target || _luma_gl_core__WEBPACK_IMPORTED_MODULE_3__[\"default\"].getDefaultFramebuffer(this.gl);\n\n    this._preRender(opts.effects, opts);\n\n    const outputBuffer = this.lastPostProcessEffect ? this.renderBuffers[0] : opts.target;\n    const renderStats = layerPass.render({ ...opts,\n      target: outputBuffer\n    });\n\n    this._postRender(opts.effects, opts);\n\n    this.renderCount++;\n    Object(_debug__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(TRACE_RENDER_LAYERS, this, renderStats, opts);\n  }\n\n  needsRedraw(opts = {\n    clearRedrawFlags: false\n  }) {\n    const redraw = this._needsRedraw;\n\n    if (opts.clearRedrawFlags) {\n      this._needsRedraw = false;\n    }\n\n    return redraw;\n  }\n\n  finalize() {\n    const {\n      renderBuffers\n    } = this;\n\n    for (const buffer of renderBuffers) {\n      buffer.delete();\n    }\n\n    renderBuffers.length = 0;\n  }\n\n  _preRender(effects, opts) {\n    let lastPostProcessEffect = null;\n\n    for (const effect of effects) {\n      effect.preRender(this.gl, opts);\n\n      if (effect.postRender) {\n        lastPostProcessEffect = effect;\n      }\n    }\n\n    if (lastPostProcessEffect) {\n      this._resizeRenderBuffers();\n    }\n\n    this.lastPostProcessEffect = lastPostProcessEffect;\n  }\n\n  _resizeRenderBuffers() {\n    const {\n      renderBuffers\n    } = this;\n\n    if (renderBuffers.length === 0) {\n      renderBuffers.push(new _luma_gl_core__WEBPACK_IMPORTED_MODULE_3__[\"default\"](this.gl), new _luma_gl_core__WEBPACK_IMPORTED_MODULE_3__[\"default\"](this.gl));\n    }\n\n    for (const buffer of renderBuffers) {\n      buffer.resize();\n    }\n  }\n\n  _postRender(effects, opts) {\n    const {\n      renderBuffers\n    } = this;\n    const params = {\n      inputBuffer: renderBuffers[0],\n      swapBuffer: renderBuffers[1],\n      target: null\n    };\n\n    for (const effect of effects) {\n      if (effect.postRender) {\n        if (effect === this.lastPostProcessEffect) {\n          params.target = opts.target;\n          effect.postRender(this.gl, params);\n          break;\n        }\n\n        const buffer = effect.postRender(this.gl, params);\n        params.inputBuffer = buffer;\n        params.swapBuffer = buffer === renderBuffers[0] ? renderBuffers[1] : renderBuffers[0];\n      }\n    }\n  }\n\n}\n//# sourceMappingURL=deck-renderer.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lib/deck-renderer.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lib/deck.js":
/*!*********************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lib/deck.js ***!
  \*********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return Deck; });\n/* harmony import */ var _layer_manager__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./layer-manager */ \"./node_modules/@deck.gl/core/dist/esm/lib/layer-manager.js\");\n/* harmony import */ var _view_manager__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./view-manager */ \"./node_modules/@deck.gl/core/dist/esm/lib/view-manager.js\");\n/* harmony import */ var _views_map_view__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../views/map-view */ \"./node_modules/@deck.gl/core/dist/esm/views/map-view.js\");\n/* harmony import */ var _effect_manager__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./effect-manager */ \"./node_modules/@deck.gl/core/dist/esm/lib/effect-manager.js\");\n/* harmony import */ var _effect__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./effect */ \"./node_modules/@deck.gl/core/dist/esm/lib/effect.js\");\n/* harmony import */ var _deck_renderer__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./deck-renderer */ \"./node_modules/@deck.gl/core/dist/esm/lib/deck-renderer.js\");\n/* harmony import */ var _deck_picker__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./deck-picker */ \"./node_modules/@deck.gl/core/dist/esm/lib/deck-picker.js\");\n/* harmony import */ var _tooltip__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./tooltip */ \"./node_modules/@deck.gl/core/dist/esm/lib/tooltip.js\");\n/* harmony import */ var _utils_log__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils/log */ \"./node_modules/@deck.gl/core/dist/esm/utils/log.js\");\n/* harmony import */ var _utils_deep_equal__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../utils/deep-equal */ \"./node_modules/@deck.gl/core/dist/esm/utils/deep-equal.js\");\n/* harmony import */ var _utils_typed_array_manager__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../utils/typed-array-manager */ \"./node_modules/@deck.gl/core/dist/esm/utils/typed-array-manager.js\");\n/* harmony import */ var _init__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./init */ \"./node_modules/@deck.gl/core/dist/esm/lib/init.js\");\n/* harmony import */ var probe_gl_env__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! probe.gl/env */ \"./node_modules/probe.gl/env.js\");\n/* harmony import */ var probe_gl_env__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(probe_gl_env__WEBPACK_IMPORTED_MODULE_12__);\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/engine/dist/esm/lib/animation-loop.js\");\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/gltools/dist/esm/index.js\");\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/engine/dist/esm/animation/timeline.js\");\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/webgl/dist/esm/init.js\");\n/* harmony import */ var probe_gl__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! probe.gl */ \"./node_modules/@probe.gl/stats/dist/esm/index.js\");\n/* harmony import */ var mjolnir_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! mjolnir.js */ \"./node_modules/mjolnir.js/dist/esm/index.js\");\n/* harmony import */ var _utils_assert__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../utils/assert */ \"./node_modules/@deck.gl/core/dist/esm/utils/assert.js\");\n/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./constants */ \"./node_modules/@deck.gl/core/dist/esm/lib/constants.js\");\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nfunction noop() {}\n\nconst getCursor = ({\n  isDragging\n}) => isDragging ? 'grabbing' : 'grab';\n\nfunction getPropTypes(PropTypes) {\n  return {\n    id: PropTypes.string,\n    width: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),\n    height: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),\n    layers: PropTypes.oneOfType([PropTypes.object, PropTypes.array]),\n    layerFilter: PropTypes.func,\n    views: PropTypes.oneOfType([PropTypes.object, PropTypes.array]),\n    viewState: PropTypes.object,\n    effects: PropTypes.arrayOf(PropTypes.instanceOf(_effect__WEBPACK_IMPORTED_MODULE_4__[\"default\"])),\n    controller: PropTypes.oneOfType([PropTypes.func, PropTypes.bool, PropTypes.object]),\n    gl: PropTypes.object,\n    glOptions: PropTypes.object,\n    parameters: PropTypes.object,\n    pickingRadius: PropTypes.number,\n    useDevicePixels: PropTypes.oneOfType([PropTypes.bool, PropTypes.number]),\n    touchAction: PropTypes.string,\n    eventRecognizerOptions: PropTypes.object,\n    onWebGLInitialized: PropTypes.func,\n    onResize: PropTypes.func,\n    onViewStateChange: PropTypes.func,\n    onInteractionStateChange: PropTypes.func,\n    onBeforeRender: PropTypes.func,\n    onAfterRender: PropTypes.func,\n    onLoad: PropTypes.func,\n    onError: PropTypes.func,\n    debug: PropTypes.bool,\n    drawPickingColors: PropTypes.bool,\n    _framebuffer: PropTypes.object,\n    _animate: PropTypes.bool,\n    _pickable: PropTypes.bool,\n    _typedArrayManagerProps: PropTypes.object\n  };\n}\n\nconst defaultProps = {\n  id: '',\n  width: '100%',\n  height: '100%',\n  pickingRadius: 0,\n  layerFilter: null,\n  glOptions: {},\n  gl: null,\n  layers: [],\n  effects: [],\n  views: null,\n  controller: null,\n  useDevicePixels: true,\n  touchAction: 'none',\n  eventRecognizerOptions: {},\n  _framebuffer: null,\n  _animate: false,\n  _pickable: true,\n  _typedArrayManagerProps: {},\n  onWebGLInitialized: noop,\n  onResize: noop,\n  onViewStateChange: noop,\n  onInteractionStateChange: noop,\n  onBeforeRender: noop,\n  onAfterRender: noop,\n  onLoad: noop,\n  onError: (error, layer) => _utils_log__WEBPACK_IMPORTED_MODULE_8__[\"default\"].error(error)(),\n  _onMetrics: null,\n  getCursor,\n  debug: false,\n  drawPickingColors: false\n};\nclass Deck {\n  constructor(props) {\n    props = { ...defaultProps,\n      ...props\n    };\n    this.props = {};\n    this.width = 0;\n    this.height = 0;\n    this.viewManager = null;\n    this.layerManager = null;\n    this.effectManager = null;\n    this.deckRenderer = null;\n    this.deckPicker = null;\n    this._needsRedraw = true;\n    this._pickRequest = {};\n    this._lastPointerDownInfo = null;\n    this.viewState = null;\n    this.interactiveState = {\n      isHovering: false,\n      isDragging: false\n    };\n    this._onEvent = this._onEvent.bind(this);\n    this._onPointerDown = this._onPointerDown.bind(this);\n    this._onPointerMove = this._onPointerMove.bind(this);\n\n    if (props.viewState && props.initialViewState) {\n      _utils_log__WEBPACK_IMPORTED_MODULE_8__[\"default\"].warn('View state tracking is disabled. Use either `initialViewState` for auto update or `viewState` for manual update.')();\n    }\n\n    if (Object(probe_gl_env__WEBPACK_IMPORTED_MODULE_12__[\"getBrowser\"])() === 'IE') {\n      _utils_log__WEBPACK_IMPORTED_MODULE_8__[\"default\"].warn('IE 11 support will be deprecated in v8.0')();\n    }\n\n    if (!props.gl) {\n      if (typeof document !== 'undefined') {\n        this.canvas = this._createCanvas(props);\n      }\n    }\n\n    this.animationLoop = this._createAnimationLoop(props);\n    this.stats = new probe_gl__WEBPACK_IMPORTED_MODULE_17__[\"Stats\"]({\n      id: 'deck.gl'\n    });\n    this.metrics = {\n      fps: 0,\n      setPropsTime: 0,\n      updateAttributesTime: 0,\n      framesRedrawn: 0,\n      pickTime: 0,\n      pickCount: 0,\n      gpuTime: 0,\n      gpuTimePerFrame: 0,\n      cpuTime: 0,\n      cpuTimePerFrame: 0,\n      bufferMemory: 0,\n      textureMemory: 0,\n      renderbufferMemory: 0,\n      gpuMemory: 0\n    };\n    this._metricsCounter = 0;\n    this.setProps(props);\n\n    if (props._typedArrayManagerProps) {\n      _utils_typed_array_manager__WEBPACK_IMPORTED_MODULE_10__[\"default\"].setProps(props._typedArrayManagerProps);\n    }\n\n    this.animationLoop.start();\n  }\n\n  finalize() {\n    this.animationLoop.stop();\n    this.animationLoop = null;\n    this._lastPointerDownInfo = null;\n\n    if (this.layerManager) {\n      this.layerManager.finalize();\n      this.layerManager = null;\n      this.viewManager.finalize();\n      this.viewManager = null;\n      this.effectManager.finalize();\n      this.effectManager = null;\n      this.deckRenderer.finalize();\n      this.deckRenderer = null;\n      this.deckPicker.finalize();\n      this.deckPicker = null;\n      this.eventManager.destroy();\n      this.eventManager = null;\n      this.tooltip.remove();\n      this.tooltip = null;\n    }\n\n    if (!this.props.canvas && !this.props.gl && this.canvas) {\n      this.canvas.parentElement.removeChild(this.canvas);\n      this.canvas = null;\n    }\n  }\n\n  setProps(props) {\n    this.stats.get('setProps Time').timeStart();\n\n    if ('onLayerHover' in props) {\n      _utils_log__WEBPACK_IMPORTED_MODULE_8__[\"default\"].removed('onLayerHover', 'onHover')();\n    }\n\n    if ('onLayerClick' in props) {\n      _utils_log__WEBPACK_IMPORTED_MODULE_8__[\"default\"].removed('onLayerClick', 'onClick')();\n    }\n\n    if (props.initialViewState && !Object(_utils_deep_equal__WEBPACK_IMPORTED_MODULE_9__[\"deepEqual\"])(this.props.initialViewState, props.initialViewState)) {\n      this.viewState = props.initialViewState;\n    }\n\n    Object.assign(this.props, props);\n\n    this._setCanvasSize(this.props);\n\n    const resolvedProps = Object.create(this.props);\n    Object.assign(resolvedProps, {\n      views: this._getViews(),\n      width: this.width,\n      height: this.height,\n      viewState: this._getViewState()\n    });\n    this.animationLoop.setProps(resolvedProps);\n\n    if (this.layerManager) {\n      this.viewManager.setProps(resolvedProps);\n      this.layerManager.activateViewport(this.getViewports()[0]);\n      this.layerManager.setProps(resolvedProps);\n      this.effectManager.setProps(resolvedProps);\n      this.deckRenderer.setProps(resolvedProps);\n      this.deckPicker.setProps(resolvedProps);\n    }\n\n    this.stats.get('setProps Time').timeEnd();\n  }\n\n  needsRedraw(opts = {\n    clearRedrawFlags: false\n  }) {\n    if (this.props._animate) {\n      return 'Deck._animate';\n    }\n\n    let redraw = this._needsRedraw;\n\n    if (opts.clearRedrawFlags) {\n      this._needsRedraw = false;\n    }\n\n    const viewManagerNeedsRedraw = this.viewManager.needsRedraw(opts);\n    const layerManagerNeedsRedraw = this.layerManager.needsRedraw(opts);\n    const effectManagerNeedsRedraw = this.effectManager.needsRedraw(opts);\n    const deckRendererNeedsRedraw = this.deckRenderer.needsRedraw(opts);\n    redraw = redraw || viewManagerNeedsRedraw || layerManagerNeedsRedraw || effectManagerNeedsRedraw || deckRendererNeedsRedraw;\n    return redraw;\n  }\n\n  redraw(force) {\n    if (!this.layerManager) {\n      return;\n    }\n\n    const redrawReason = force || this.needsRedraw({\n      clearRedrawFlags: true\n    });\n\n    if (!redrawReason) {\n      return;\n    }\n\n    this.stats.get('Redraw Count').incrementCount();\n\n    if (this.props._customRender) {\n      this.props._customRender(redrawReason);\n    } else {\n      this._drawLayers(redrawReason);\n    }\n  }\n\n  getViews() {\n    return this.viewManager.views;\n  }\n\n  getViewports(rect) {\n    return this.viewManager.getViewports(rect);\n  }\n\n  pickObject(opts) {\n    const infos = this._pick('pickObject', 'pickObject Time', opts).result;\n\n    return infos.length ? infos[0] : null;\n  }\n\n  pickMultipleObjects(opts) {\n    opts.depth = opts.depth || 10;\n    return this._pick('pickObject', 'pickMultipleObjects Time', opts).result;\n  }\n\n  pickObjects(opts) {\n    return this._pick('pickObjects', 'pickObjects Time', opts);\n  }\n\n  _addResources(resources, forceUpdate = false) {\n    for (const id in resources) {\n      this.layerManager.resourceManager.add({\n        resourceId: id,\n        data: resources[id],\n        forceUpdate\n      });\n    }\n  }\n\n  _removeResources(resourceIds) {\n    for (const id of resourceIds) {\n      this.layerManager.resourceManager.remove(id);\n    }\n  }\n\n  _pick(method, statKey, opts) {\n    const {\n      stats\n    } = this;\n    stats.get('Pick Count').incrementCount();\n    stats.get(statKey).timeStart();\n    const infos = this.deckPicker[method]({\n      layers: this.layerManager.getLayers(opts),\n      views: this.viewManager.getViews(),\n      viewports: this.getViewports(opts),\n      onViewportActive: this.layerManager.activateViewport,\n      ...opts\n    });\n    stats.get(statKey).timeEnd();\n    return infos;\n  }\n\n  _createCanvas(props) {\n    let canvas = props.canvas;\n\n    if (typeof canvas === 'string') {\n      canvas = document.getElementById(canvas);\n      Object(_utils_assert__WEBPACK_IMPORTED_MODULE_19__[\"default\"])(canvas);\n    }\n\n    if (!canvas) {\n      canvas = document.createElement('canvas');\n      canvas.id = props.id || 'deckgl-overlay';\n      const parent = props.parent || document.body;\n      parent.appendChild(canvas);\n    }\n\n    Object.assign(canvas.style, props.style);\n    return canvas;\n  }\n\n  _setCanvasSize(props) {\n    if (!this.canvas) {\n      return;\n    }\n\n    let {\n      width,\n      height\n    } = props;\n\n    if (width || width === 0) {\n      width = Number.isFinite(width) ? \"\".concat(width, \"px\") : width;\n      this.canvas.style.width = width;\n    }\n\n    if (height || height === 0) {\n      height = Number.isFinite(height) ? \"\".concat(height, \"px\") : height;\n      this.canvas.style.position = 'absolute';\n      this.canvas.style.height = height;\n    }\n  }\n\n  _updateCanvasSize() {\n    if (this._checkForCanvasSizeChange()) {\n      const {\n        width,\n        height\n      } = this;\n      this.viewManager.setProps({\n        width,\n        height\n      });\n      this.props.onResize({\n        width: this.width,\n        height: this.height\n      });\n    }\n  }\n\n  _checkForCanvasSizeChange() {\n    const {\n      canvas\n    } = this;\n\n    if (!canvas) {\n      return false;\n    }\n\n    const newWidth = canvas.clientWidth || canvas.width;\n    const newHeight = canvas.clientHeight || canvas.height;\n\n    if (newWidth !== this.width || newHeight !== this.height) {\n      this.width = newWidth;\n      this.height = newHeight;\n      return true;\n    }\n\n    return false;\n  }\n\n  _createAnimationLoop(props) {\n    const {\n      width,\n      height,\n      gl,\n      glOptions,\n      debug,\n      onError,\n      onBeforeRender,\n      onAfterRender,\n      useDevicePixels,\n      autoResizeDrawingBuffer\n    } = props;\n    return new _luma_gl_core__WEBPACK_IMPORTED_MODULE_13__[\"default\"]({\n      width,\n      height,\n      useDevicePixels,\n      autoResizeDrawingBuffer,\n      autoResizeViewport: false,\n      gl,\n      onCreateContext: opts => Object(_luma_gl_core__WEBPACK_IMPORTED_MODULE_14__[\"createGLContext\"])({ ...glOptions,\n        ...opts,\n        canvas: this.canvas,\n        debug,\n        onContextLost: () => this._onContextLost()\n      }),\n      onInitialize: context => this._setGLContext(context.gl),\n      onRender: this._onRenderFrame.bind(this),\n      onBeforeRender,\n      onAfterRender,\n      onError\n    });\n  }\n\n  _getViewState() {\n    return this.props.viewState || this.viewState;\n  }\n\n  _getViews() {\n    let views = this.props.views || [new _views_map_view__WEBPACK_IMPORTED_MODULE_2__[\"default\"]({\n      id: 'default-view'\n    })];\n    views = Array.isArray(views) ? views : [views];\n\n    if (views.length && this.props.controller) {\n      views[0].props.controller = this.props.controller;\n    }\n\n    return views;\n  }\n\n  _onContextLost() {\n    const {\n      onError\n    } = this.props;\n\n    if (this.animationLoop && onError) {\n      onError(new Error(\"WebGL context is lost\"));\n    }\n  }\n\n  _onPointerMove(event) {\n    const {\n      _pickRequest\n    } = this;\n\n    if (event.type === 'pointerleave') {\n      _pickRequest.x = -1;\n      _pickRequest.y = -1;\n      _pickRequest.radius = 0;\n    } else if (event.leftButton || event.rightButton) {\n      return;\n    } else {\n      const pos = event.offsetCenter;\n\n      if (!pos) {\n        return;\n      }\n\n      _pickRequest.x = pos.x;\n      _pickRequest.y = pos.y;\n      _pickRequest.radius = this.props.pickingRadius;\n    }\n\n    if (this.layerManager) {\n      this.layerManager.context.mousePosition = {\n        x: _pickRequest.x,\n        y: _pickRequest.y\n      };\n    }\n\n    _pickRequest.event = event;\n    _pickRequest.mode = 'hover';\n  }\n\n  _pickAndCallback() {\n    const {\n      _pickRequest\n    } = this;\n\n    if (_pickRequest.event) {\n      const {\n        result,\n        emptyInfo\n      } = this._pick('pickObject', 'pickObject Time', _pickRequest);\n\n      this.interactiveState.isHovering = result.length > 0;\n      let pickedInfo = emptyInfo;\n      let handled = false;\n\n      for (const info of result) {\n        pickedInfo = info;\n        handled = info.layer.onHover(info, _pickRequest.event);\n      }\n\n      if (!handled && this.props.onHover) {\n        this.props.onHover(pickedInfo, _pickRequest.event);\n      }\n\n      if (this.props.getTooltip) {\n        const displayInfo = this.props.getTooltip(pickedInfo);\n        this.tooltip.setTooltip(displayInfo, pickedInfo.x, pickedInfo.y);\n      }\n\n      _pickRequest.event = null;\n    }\n  }\n\n  _updateCursor() {\n    const container = this.props.parent || this.canvas;\n\n    if (container) {\n      container.style.cursor = this.props.getCursor(this.interactiveState);\n    }\n  }\n\n  _setGLContext(gl) {\n    if (this.layerManager) {\n      return;\n    }\n\n    if (!this.canvas) {\n      this.canvas = gl.canvas;\n      Object(_luma_gl_core__WEBPACK_IMPORTED_MODULE_14__[\"instrumentGLContext\"])(gl, {\n        enable: true,\n        copyState: true\n      });\n    }\n\n    this.tooltip = new _tooltip__WEBPACK_IMPORTED_MODULE_7__[\"default\"](this.canvas);\n    Object(_luma_gl_core__WEBPACK_IMPORTED_MODULE_14__[\"setParameters\"])(gl, {\n      blend: true,\n      blendFunc: [770, 771, 1, 771],\n      polygonOffsetFill: true,\n      depthTest: true,\n      depthFunc: 515\n    });\n    this.props.onWebGLInitialized(gl);\n    const timeline = new _luma_gl_core__WEBPACK_IMPORTED_MODULE_15__[\"Timeline\"]();\n    timeline.play();\n    this.animationLoop.attachTimeline(timeline);\n    this.eventManager = new mjolnir_js__WEBPACK_IMPORTED_MODULE_18__[\"EventManager\"](this.props.parent || gl.canvas, {\n      touchAction: this.props.touchAction,\n      recognizerOptions: this.props.eventRecognizerOptions,\n      events: {\n        pointerdown: this._onPointerDown,\n        pointermove: this._onPointerMove,\n        pointerleave: this._onPointerMove\n      }\n    });\n\n    for (const eventType in _constants__WEBPACK_IMPORTED_MODULE_20__[\"EVENTS\"]) {\n      this.eventManager.on(eventType, this._onEvent);\n    }\n\n    this.viewManager = new _view_manager__WEBPACK_IMPORTED_MODULE_1__[\"default\"]({\n      timeline,\n      eventManager: this.eventManager,\n      onViewStateChange: this._onViewStateChange.bind(this),\n      onInteractionStateChange: this._onInteractionStateChange.bind(this),\n      views: this._getViews(),\n      viewState: this._getViewState(),\n      width: this.width,\n      height: this.height\n    });\n    const viewport = this.viewManager.getViewports()[0];\n    this.layerManager = new _layer_manager__WEBPACK_IMPORTED_MODULE_0__[\"default\"](gl, {\n      deck: this,\n      stats: this.stats,\n      viewport,\n      timeline\n    });\n    this.effectManager = new _effect_manager__WEBPACK_IMPORTED_MODULE_3__[\"default\"]();\n    this.deckRenderer = new _deck_renderer__WEBPACK_IMPORTED_MODULE_5__[\"default\"](gl);\n    this.deckPicker = new _deck_picker__WEBPACK_IMPORTED_MODULE_6__[\"default\"](gl);\n    this.setProps(this.props);\n\n    this._updateCanvasSize();\n\n    this.props.onLoad();\n  }\n\n  _drawLayers(redrawReason, renderOptions) {\n    const {\n      gl\n    } = this.layerManager.context;\n    Object(_luma_gl_core__WEBPACK_IMPORTED_MODULE_14__[\"setParameters\"])(gl, this.props.parameters);\n    this.props.onBeforeRender({\n      gl\n    });\n    this.deckRenderer.renderLayers({\n      target: this.props._framebuffer,\n      layers: this.layerManager.getLayers(),\n      viewports: this.viewManager.getViewports(),\n      onViewportActive: this.layerManager.activateViewport,\n      views: this.viewManager.getViews(),\n      pass: 'screen',\n      redrawReason,\n      effects: this.effectManager.getEffects(),\n      ...renderOptions\n    });\n    this.props.onAfterRender({\n      gl\n    });\n  }\n\n  _onRenderFrame(animationProps) {\n    this._getFrameStats();\n\n    if (this._metricsCounter++ % 60 === 0) {\n      this._getMetrics();\n\n      this.stats.reset();\n      _utils_log__WEBPACK_IMPORTED_MODULE_8__[\"default\"].table(4, this.metrics)();\n\n      if (this.props._onMetrics) {\n        this.props._onMetrics(this.metrics);\n      }\n    }\n\n    this._updateCanvasSize();\n\n    this._updateCursor();\n\n    if (this.tooltip.isVisible && this.viewManager.needsRedraw()) {\n      this.tooltip.setTooltip(null);\n    }\n\n    this.layerManager.updateLayers();\n\n    this._pickAndCallback();\n\n    this.redraw(false);\n\n    if (this.viewManager) {\n      this.viewManager.updateViewStates();\n    }\n  }\n\n  _onViewStateChange(params) {\n    const viewState = this.props.onViewStateChange(params) || params.viewState;\n\n    if (this.viewState) {\n      this.viewState = { ...this.viewState,\n        [params.viewId]: viewState\n      };\n\n      if (!this.props.viewState) {\n        if (this.viewManager) {\n          this.viewManager.setProps({\n            viewState: this.viewState\n          });\n        }\n      }\n    }\n  }\n\n  _onInteractionStateChange(interactionState) {\n    this.interactiveState.isDragging = interactionState.isDragging;\n    this.props.onInteractionStateChange(interactionState);\n  }\n\n  _onEvent(event) {\n    const eventOptions = _constants__WEBPACK_IMPORTED_MODULE_20__[\"EVENTS\"][event.type];\n    const pos = event.offsetCenter;\n\n    if (!eventOptions || !pos) {\n      return;\n    }\n\n    const layers = this.layerManager.getLayers();\n    const info = this.deckPicker.getLastPickedObject({\n      x: pos.x,\n      y: pos.y,\n      layers,\n      viewports: this.getViewports(pos)\n    }, this._lastPointerDownInfo);\n    const {\n      layer\n    } = info;\n    const layerHandler = layer && (layer[eventOptions.handler] || layer.props[eventOptions.handler]);\n    const rootHandler = this.props[eventOptions.handler];\n    let handled = false;\n\n    if (layerHandler) {\n      handled = layerHandler.call(layer, info, event);\n    }\n\n    if (!handled && rootHandler) {\n      rootHandler(info, event);\n    }\n  }\n\n  _onPointerDown(event) {\n    const pos = event.offsetCenter;\n    this._lastPointerDownInfo = this.pickObject({\n      x: pos.x,\n      y: pos.y,\n      radius: this.props.pickingRadius\n    });\n  }\n\n  _getFrameStats() {\n    const {\n      stats\n    } = this;\n    stats.get('frameRate').timeEnd();\n    stats.get('frameRate').timeStart();\n    const animationLoopStats = this.animationLoop.stats;\n    stats.get('GPU Time').addTime(animationLoopStats.get('GPU Time').lastTiming);\n    stats.get('CPU Time').addTime(animationLoopStats.get('CPU Time').lastTiming);\n  }\n\n  _getMetrics() {\n    const {\n      metrics,\n      stats\n    } = this;\n    metrics.fps = stats.get('frameRate').getHz();\n    metrics.setPropsTime = stats.get('setProps Time').time;\n    metrics.updateAttributesTime = stats.get('Update Attributes').time;\n    metrics.framesRedrawn = stats.get('Redraw Count').count;\n    metrics.pickTime = stats.get('pickObject Time').time + stats.get('pickMultipleObjects Time').time + stats.get('pickObjects Time').time;\n    metrics.pickCount = stats.get('Pick Count').count;\n    metrics.gpuTime = stats.get('GPU Time').time;\n    metrics.cpuTime = stats.get('CPU Time').time;\n    metrics.gpuTimePerFrame = stats.get('GPU Time').getAverageTime();\n    metrics.cpuTimePerFrame = stats.get('CPU Time').getAverageTime();\n    const memoryStats = _luma_gl_core__WEBPACK_IMPORTED_MODULE_16__[\"lumaStats\"].get('Memory Usage');\n    metrics.bufferMemory = memoryStats.get('Buffer Memory').count;\n    metrics.textureMemory = memoryStats.get('Texture Memory').count;\n    metrics.renderbufferMemory = memoryStats.get('Renderbuffer Memory').count;\n    metrics.gpuMemory = memoryStats.get('GPU Memory').count;\n  }\n\n}\nDeck.getPropTypes = getPropTypes;\nDeck.defaultProps = defaultProps;\nDeck.VERSION = _init__WEBPACK_IMPORTED_MODULE_11__[\"default\"].VERSION;\n//# sourceMappingURL=deck.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lib/deck.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lib/effect-manager.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lib/effect-manager.js ***!
  \*******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return EffectManager; });\n/* harmony import */ var _utils_deep_equal__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/deep-equal */ \"./node_modules/@deck.gl/core/dist/esm/utils/deep-equal.js\");\n/* harmony import */ var _effects_lighting_lighting_effect__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../effects/lighting/lighting-effect */ \"./node_modules/@deck.gl/core/dist/esm/effects/lighting/lighting-effect.js\");\n\n\nconst DEFAULT_LIGHTING_EFFECT = new _effects_lighting_lighting_effect__WEBPACK_IMPORTED_MODULE_1__[\"default\"]();\nclass EffectManager {\n  constructor() {\n    this.effects = [];\n    this._internalEffects = [];\n    this._needsRedraw = 'Initial render';\n    this.setEffects();\n  }\n\n  setProps(props) {\n    if ('effects' in props) {\n      if (props.effects.length !== this.effects.length || !Object(_utils_deep_equal__WEBPACK_IMPORTED_MODULE_0__[\"deepEqual\"])(props.effects, this.effects)) {\n        this.setEffects(props.effects);\n        this._needsRedraw = 'effects changed';\n      }\n    }\n  }\n\n  needsRedraw(opts = {\n    clearRedrawFlags: false\n  }) {\n    const redraw = this._needsRedraw;\n\n    if (opts.clearRedrawFlags) {\n      this._needsRedraw = false;\n    }\n\n    return redraw;\n  }\n\n  getEffects() {\n    return this._internalEffects;\n  }\n\n  finalize() {\n    this.cleanup();\n  }\n\n  setEffects(effects = []) {\n    this.cleanup();\n    this.effects = effects;\n\n    this._createInternalEffects();\n  }\n\n  cleanup() {\n    for (const effect of this.effects) {\n      effect.cleanup();\n    }\n\n    for (const effect of this._internalEffects) {\n      effect.cleanup();\n    }\n\n    this.effects.length = 0;\n    this._internalEffects.length = 0;\n  }\n\n  _createInternalEffects() {\n    this._internalEffects = this.effects.slice();\n\n    if (!this.effects.some(effect => effect instanceof _effects_lighting_lighting_effect__WEBPACK_IMPORTED_MODULE_1__[\"default\"])) {\n      this._internalEffects.push(DEFAULT_LIGHTING_EFFECT);\n    }\n  }\n\n}\n//# sourceMappingURL=effect-manager.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lib/effect-manager.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lib/effect.js":
/*!***********************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lib/effect.js ***!
  \***********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return Effect; });\nclass Effect {\n  constructor(props = {}) {\n    const {\n      id = 'effect'\n    } = props;\n    this.id = id;\n    this.props = { ...props\n    };\n  }\n\n  preRender() {}\n\n  getModuleParameters() {}\n\n  cleanup() {}\n\n}\n//# sourceMappingURL=effect.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS9saWIvZWZmZWN0LmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0BkZWNrLmdsL2NvcmUvZGlzdC9lc20vbGliL2VmZmVjdC5qcz9iODIxIl0sInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCBkZWZhdWx0IGNsYXNzIEVmZmVjdCB7XG4gIGNvbnN0cnVjdG9yKHByb3BzID0ge30pIHtcbiAgICBjb25zdCB7XG4gICAgICBpZCA9ICdlZmZlY3QnXG4gICAgfSA9IHByb3BzO1xuICAgIHRoaXMuaWQgPSBpZDtcbiAgICB0aGlzLnByb3BzID0geyAuLi5wcm9wc1xuICAgIH07XG4gIH1cblxuICBwcmVSZW5kZXIoKSB7fVxuXG4gIGdldE1vZHVsZVBhcmFtZXRlcnMoKSB7fVxuXG4gIGNsZWFudXAoKSB7fVxuXG59XG4vLyMgc291cmNlTWFwcGluZ1VSTD1lZmZlY3QuanMubWFwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lib/effect.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lib/init.js":
/*!*********************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lib/init.js ***!
  \*********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _loaders_gl_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @loaders.gl/core */ \"./node_modules/@loaders.gl/core/dist/esm/lib/api/register-loaders.js\");\n/* harmony import */ var _loaders_gl_images__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @loaders.gl/images */ \"./node_modules/@loaders.gl/images/dist/esm/image-loader.js\");\n/* harmony import */ var probe_gl_env__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! probe.gl/env */ \"./node_modules/probe.gl/env.js\");\n/* harmony import */ var probe_gl_env__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(probe_gl_env__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _utils_log__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/log */ \"./node_modules/@deck.gl/core/dist/esm/utils/log.js\");\n/* harmony import */ var _debug__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../debug */ \"./node_modules/@deck.gl/core/dist/esm/debug/index.js\");\n/* harmony import */ var _utils_json_loader__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/json-loader */ \"./node_modules/@deck.gl/core/dist/esm/utils/json-loader.js\");\n\n\n\n\n\n\nconst version =  true ? \"8.5.2\" : undefined;\nconst existingVersion = probe_gl_env__WEBPACK_IMPORTED_MODULE_2__[\"global\"].deck && probe_gl_env__WEBPACK_IMPORTED_MODULE_2__[\"global\"].deck.VERSION;\n\nif (existingVersion && existingVersion !== version) {\n  throw new Error(\"deck.gl - multiple versions detected: \".concat(existingVersion, \" vs \").concat(version));\n}\n\nif (!existingVersion) {\n  _utils_log__WEBPACK_IMPORTED_MODULE_3__[\"default\"].log(1, \"deck.gl \".concat(version))();\n  probe_gl_env__WEBPACK_IMPORTED_MODULE_2__[\"global\"].deck = Object.assign(probe_gl_env__WEBPACK_IMPORTED_MODULE_2__[\"global\"].deck || {}, {\n    VERSION: version,\n    version,\n    log: _utils_log__WEBPACK_IMPORTED_MODULE_3__[\"default\"],\n    _registerLoggers: _debug__WEBPACK_IMPORTED_MODULE_4__[\"register\"]\n  });\n  Object(_loaders_gl_core__WEBPACK_IMPORTED_MODULE_0__[\"registerLoaders\"])([_utils_json_loader__WEBPACK_IMPORTED_MODULE_5__[\"default\"], [_loaders_gl_images__WEBPACK_IMPORTED_MODULE_1__[\"ImageLoader\"], {\n    imagebitmap: {\n      premultiplyAlpha: 'none'\n    }\n  }]]);\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (probe_gl_env__WEBPACK_IMPORTED_MODULE_2__[\"global\"].deck);\n//# sourceMappingURL=init.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS9saWIvaW5pdC5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9AZGVjay5nbC9jb3JlL2Rpc3QvZXNtL2xpYi9pbml0LmpzP2IzMDkiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgcmVnaXN0ZXJMb2FkZXJzIH0gZnJvbSAnQGxvYWRlcnMuZ2wvY29yZSc7XG5pbXBvcnQgeyBJbWFnZUxvYWRlciB9IGZyb20gJ0Bsb2FkZXJzLmdsL2ltYWdlcyc7XG5pbXBvcnQgeyBnbG9iYWwgfSBmcm9tICdwcm9iZS5nbC9lbnYnO1xuaW1wb3J0IGxvZyBmcm9tICcuLi91dGlscy9sb2cnO1xuaW1wb3J0IHsgcmVnaXN0ZXIgfSBmcm9tICcuLi9kZWJ1Zyc7XG5pbXBvcnQganNvbkxvYWRlciBmcm9tICcuLi91dGlscy9qc29uLWxvYWRlcic7XG5jb25zdCB2ZXJzaW9uID0gdHlwZW9mIFwiOC41LjJcIiAhPT0gJ3VuZGVmaW5lZCcgPyBcIjguNS4yXCIgOiBnbG9iYWwuREVDS19WRVJTSU9OIHx8ICd1bnRyYW5zcGlsZWQgc291cmNlJztcbmNvbnN0IGV4aXN0aW5nVmVyc2lvbiA9IGdsb2JhbC5kZWNrICYmIGdsb2JhbC5kZWNrLlZFUlNJT047XG5cbmlmIChleGlzdGluZ1ZlcnNpb24gJiYgZXhpc3RpbmdWZXJzaW9uICE9PSB2ZXJzaW9uKSB7XG4gIHRocm93IG5ldyBFcnJvcihcImRlY2suZ2wgLSBtdWx0aXBsZSB2ZXJzaW9ucyBkZXRlY3RlZDogXCIuY29uY2F0KGV4aXN0aW5nVmVyc2lvbiwgXCIgdnMgXCIpLmNvbmNhdCh2ZXJzaW9uKSk7XG59XG5cbmlmICghZXhpc3RpbmdWZXJzaW9uKSB7XG4gIGxvZy5sb2coMSwgXCJkZWNrLmdsIFwiLmNvbmNhdCh2ZXJzaW9uKSkoKTtcbiAgZ2xvYmFsLmRlY2sgPSBPYmplY3QuYXNzaWduKGdsb2JhbC5kZWNrIHx8IHt9LCB7XG4gICAgVkVSU0lPTjogdmVyc2lvbixcbiAgICB2ZXJzaW9uLFxuICAgIGxvZyxcbiAgICBfcmVnaXN0ZXJMb2dnZXJzOiByZWdpc3RlclxuICB9KTtcbiAgcmVnaXN0ZXJMb2FkZXJzKFtqc29uTG9hZGVyLCBbSW1hZ2VMb2FkZXIsIHtcbiAgICBpbWFnZWJpdG1hcDoge1xuICAgICAgcHJlbXVsdGlwbHlBbHBoYTogJ25vbmUnXG4gICAgfVxuICB9XV0pO1xufVxuXG5leHBvcnQgZGVmYXVsdCBnbG9iYWwuZGVjaztcbi8vIyBzb3VyY2VNYXBwaW5nVVJMPWluaXQuanMubWFwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lib/init.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lib/layer-manager.js":
/*!******************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lib/layer-manager.js ***!
  \******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return LayerManager; });\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/engine/dist/esm/animation/timeline.js\");\n/* harmony import */ var _lifecycle_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../lifecycle/constants */ \"./node_modules/@deck.gl/core/dist/esm/lifecycle/constants.js\");\n/* harmony import */ var _utils_log__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/log */ \"./node_modules/@deck.gl/core/dist/esm/utils/log.js\");\n/* harmony import */ var _debug__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../debug */ \"./node_modules/@deck.gl/core/dist/esm/debug/index.js\");\n/* harmony import */ var _utils_flatten__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/flatten */ \"./node_modules/@deck.gl/core/dist/esm/utils/flatten.js\");\n/* harmony import */ var probe_gl__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! probe.gl */ \"./node_modules/@probe.gl/stats/dist/esm/index.js\");\n/* harmony import */ var _resource_resource_manager__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./resource/resource-manager */ \"./node_modules/@deck.gl/core/dist/esm/lib/resource/resource-manager.js\");\n/* harmony import */ var _viewports_viewport__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../viewports/viewport */ \"./node_modules/@deck.gl/core/dist/esm/viewports/viewport.js\");\n/* harmony import */ var _shaderlib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../shaderlib */ \"./node_modules/@deck.gl/core/dist/esm/shaderlib/index.js\");\n\n\n\n\n\n\n\n\n\nconst TRACE_SET_LAYERS = 'layerManager.setLayers';\nconst TRACE_ACTIVATE_VIEWPORT = 'layerManager.activateViewport';\nconst INITIAL_CONTEXT = Object.seal({\n  layerManager: null,\n  resourceManager: null,\n  deck: null,\n  gl: null,\n  stats: null,\n  shaderCache: null,\n  pickingFBO: null,\n  mousePosition: null,\n  userData: {}\n});\nclass LayerManager {\n  constructor(gl, {\n    deck,\n    stats,\n    viewport,\n    timeline\n  } = {}) {\n    this.lastRenderedLayers = [];\n    this.layers = [];\n    this.resourceManager = new _resource_resource_manager__WEBPACK_IMPORTED_MODULE_6__[\"default\"]({\n      gl,\n      protocol: 'deck://'\n    });\n    this.context = { ...INITIAL_CONTEXT,\n      layerManager: this,\n      gl,\n      deck,\n      programManager: gl && Object(_shaderlib__WEBPACK_IMPORTED_MODULE_8__[\"createProgramManager\"])(gl),\n      stats: stats || new probe_gl__WEBPACK_IMPORTED_MODULE_5__[\"Stats\"]({\n        id: 'deck.gl'\n      }),\n      viewport: viewport || new _viewports_viewport__WEBPACK_IMPORTED_MODULE_7__[\"default\"]({\n        id: 'DEFAULT-INITIAL-VIEWPORT'\n      }),\n      timeline: timeline || new _luma_gl_core__WEBPACK_IMPORTED_MODULE_0__[\"Timeline\"](),\n      resourceManager: this.resourceManager\n    };\n    this._nextLayers = null;\n    this._needsRedraw = 'Initial render';\n    this._needsUpdate = false;\n    this._debug = false;\n    this.activateViewport = this.activateViewport.bind(this);\n    Object.seal(this);\n  }\n\n  finalize() {\n    this.resourceManager.finalize();\n\n    for (const layer of this.layers) {\n      this._finalizeLayer(layer);\n    }\n  }\n\n  needsRedraw(opts = {\n    clearRedrawFlags: false\n  }) {\n    let redraw = this._needsRedraw;\n\n    if (opts.clearRedrawFlags) {\n      this._needsRedraw = false;\n    }\n\n    for (const layer of this.layers) {\n      const layerNeedsRedraw = layer.getNeedsRedraw(opts);\n      redraw = redraw || layerNeedsRedraw;\n    }\n\n    return redraw;\n  }\n\n  needsUpdate() {\n    if (this._nextLayers && this._nextLayers !== this.lastRenderedLayers) {\n      return 'layers changed';\n    }\n\n    return this._needsUpdate;\n  }\n\n  setNeedsRedraw(reason) {\n    this._needsRedraw = this._needsRedraw || reason;\n  }\n\n  setNeedsUpdate(reason) {\n    this._needsUpdate = this._needsUpdate || reason;\n  }\n\n  getLayers({\n    layerIds = null\n  } = {}) {\n    return layerIds ? this.layers.filter(layer => layerIds.find(layerId => layer.id.indexOf(layerId) === 0)) : this.layers;\n  }\n\n  setProps(props) {\n    if ('debug' in props) {\n      this._debug = props.debug;\n    }\n\n    if ('userData' in props) {\n      this.context.userData = props.userData;\n    }\n\n    if ('layers' in props) {\n      this._nextLayers = props.layers;\n    }\n\n    if ('onError' in props) {\n      this.context.onError = props.onError;\n    }\n  }\n\n  setLayers(newLayers, reason) {\n    Object(_debug__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(TRACE_SET_LAYERS, this, reason, newLayers);\n    this.lastRenderedLayers = newLayers;\n    newLayers = Object(_utils_flatten__WEBPACK_IMPORTED_MODULE_4__[\"flatten\"])(newLayers, Boolean);\n\n    for (const layer of newLayers) {\n      layer.context = this.context;\n    }\n\n    this._updateLayers(this.layers, newLayers);\n\n    return this;\n  }\n\n  updateLayers() {\n    const reason = this.needsUpdate();\n\n    if (reason) {\n      this.setNeedsRedraw(\"updating layers: \".concat(reason));\n      this.setLayers(this._nextLayers || this.lastRenderedLayers, reason);\n    }\n\n    this._nextLayers = null;\n  }\n\n  activateViewport(viewport) {\n    Object(_debug__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(TRACE_ACTIVATE_VIEWPORT, this, viewport);\n\n    if (viewport) {\n      this.context.viewport = viewport;\n    }\n\n    return this;\n  }\n\n  _handleError(stage, error, layer) {\n    layer.raiseError(error, \"\".concat(stage, \" of \").concat(layer));\n  }\n\n  _updateLayers(oldLayers, newLayers) {\n    const oldLayerMap = {};\n\n    for (const oldLayer of oldLayers) {\n      if (oldLayerMap[oldLayer.id]) {\n        _utils_log__WEBPACK_IMPORTED_MODULE_2__[\"default\"].warn(\"Multiple old layers with same id \".concat(oldLayer.id))();\n      } else {\n        oldLayerMap[oldLayer.id] = oldLayer;\n      }\n    }\n\n    const generatedLayers = [];\n\n    this._updateSublayersRecursively(newLayers, oldLayerMap, generatedLayers);\n\n    this._finalizeOldLayers(oldLayerMap);\n\n    let needsUpdate = false;\n\n    for (const layer of generatedLayers) {\n      if (layer.hasUniformTransition()) {\n        needsUpdate = true;\n        break;\n      }\n    }\n\n    this._needsUpdate = needsUpdate;\n    this.layers = generatedLayers;\n  }\n\n  _updateSublayersRecursively(newLayers, oldLayerMap, generatedLayers) {\n    for (const newLayer of newLayers) {\n      newLayer.context = this.context;\n      const oldLayer = oldLayerMap[newLayer.id];\n\n      if (oldLayer === null) {\n        _utils_log__WEBPACK_IMPORTED_MODULE_2__[\"default\"].warn(\"Multiple new layers with same id \".concat(newLayer.id))();\n      }\n\n      oldLayerMap[newLayer.id] = null;\n      let sublayers = null;\n\n      try {\n        if (this._debug && oldLayer !== newLayer) {\n          newLayer.validateProps();\n        }\n\n        if (!oldLayer) {\n          this._initializeLayer(newLayer);\n        } else {\n          this._transferLayerState(oldLayer, newLayer);\n\n          this._updateLayer(newLayer);\n        }\n\n        generatedLayers.push(newLayer);\n        sublayers = newLayer.isComposite && newLayer.getSubLayers();\n      } catch (err) {\n        this._handleError('matching', err, newLayer);\n      }\n\n      if (sublayers) {\n        this._updateSublayersRecursively(sublayers, oldLayerMap, generatedLayers);\n      }\n    }\n  }\n\n  _finalizeOldLayers(oldLayerMap) {\n    for (const layerId in oldLayerMap) {\n      const layer = oldLayerMap[layerId];\n\n      if (layer) {\n        this._finalizeLayer(layer);\n      }\n    }\n  }\n\n  _initializeLayer(layer) {\n    try {\n      layer._initialize();\n\n      layer.lifecycle = _lifecycle_constants__WEBPACK_IMPORTED_MODULE_1__[\"LIFECYCLE\"].INITIALIZED;\n    } catch (err) {\n      this._handleError('initialization', err, layer);\n    }\n  }\n\n  _transferLayerState(oldLayer, newLayer) {\n    newLayer._transferState(oldLayer);\n\n    newLayer.lifecycle = _lifecycle_constants__WEBPACK_IMPORTED_MODULE_1__[\"LIFECYCLE\"].MATCHED;\n\n    if (newLayer !== oldLayer) {\n      oldLayer.lifecycle = _lifecycle_constants__WEBPACK_IMPORTED_MODULE_1__[\"LIFECYCLE\"].AWAITING_GC;\n    }\n  }\n\n  _updateLayer(layer) {\n    try {\n      layer._update();\n    } catch (err) {\n      this._handleError('update', err, layer);\n    }\n  }\n\n  _finalizeLayer(layer) {\n    this._needsRedraw = this._needsRedraw || \"finalized \".concat(layer);\n    layer.lifecycle = _lifecycle_constants__WEBPACK_IMPORTED_MODULE_1__[\"LIFECYCLE\"].AWAITING_FINALIZATION;\n\n    try {\n      layer._finalize();\n\n      layer.lifecycle = _lifecycle_constants__WEBPACK_IMPORTED_MODULE_1__[\"LIFECYCLE\"].FINALIZED;\n    } catch (err) {\n      this._handleError('finalization', err, layer);\n    }\n  }\n\n}\n//# sourceMappingURL=layer-manager.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lib/layer-manager.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lib/layer-state.js":
/*!****************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lib/layer-state.js ***!
  \****************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return LayerState; });\n/* harmony import */ var _lifecycle_component_state__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../lifecycle/component-state */ \"./node_modules/@deck.gl/core/dist/esm/lifecycle/component-state.js\");\n\nclass LayerState extends _lifecycle_component_state__WEBPACK_IMPORTED_MODULE_0__[\"default\"] {\n  constructor({\n    attributeManager,\n    layer\n  }) {\n    super(layer);\n    this.attributeManager = attributeManager;\n    this.model = null;\n    this.needsRedraw = true;\n    this.subLayers = null;\n    this.usesPickingColorCache = false;\n  }\n\n  get layer() {\n    return this.component;\n  }\n\n  set layer(layer) {\n    this.component = layer;\n  }\n\n}\n//# sourceMappingURL=layer-state.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS9saWIvbGF5ZXItc3RhdGUuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS9saWIvbGF5ZXItc3RhdGUuanM/ZWY5MSJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgQ29tcG9uZW50U3RhdGUgZnJvbSAnLi4vbGlmZWN5Y2xlL2NvbXBvbmVudC1zdGF0ZSc7XG5leHBvcnQgZGVmYXVsdCBjbGFzcyBMYXllclN0YXRlIGV4dGVuZHMgQ29tcG9uZW50U3RhdGUge1xuICBjb25zdHJ1Y3Rvcih7XG4gICAgYXR0cmlidXRlTWFuYWdlcixcbiAgICBsYXllclxuICB9KSB7XG4gICAgc3VwZXIobGF5ZXIpO1xuICAgIHRoaXMuYXR0cmlidXRlTWFuYWdlciA9IGF0dHJpYnV0ZU1hbmFnZXI7XG4gICAgdGhpcy5tb2RlbCA9IG51bGw7XG4gICAgdGhpcy5uZWVkc1JlZHJhdyA9IHRydWU7XG4gICAgdGhpcy5zdWJMYXllcnMgPSBudWxsO1xuICAgIHRoaXMudXNlc1BpY2tpbmdDb2xvckNhY2hlID0gZmFsc2U7XG4gIH1cblxuICBnZXQgbGF5ZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMuY29tcG9uZW50O1xuICB9XG5cbiAgc2V0IGxheWVyKGxheWVyKSB7XG4gICAgdGhpcy5jb21wb25lbnQgPSBsYXllcjtcbiAgfVxuXG59XG4vLyMgc291cmNlTWFwcGluZ1VSTD1sYXllci1zdGF0ZS5qcy5tYXAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lib/layer-state.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lib/layer.js":
/*!**********************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lib/layer.js ***!
  \**********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return Layer; });\n/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ \"./node_modules/@deck.gl/core/dist/esm/lib/constants.js\");\n/* harmony import */ var _attribute_attribute_manager__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./attribute/attribute-manager */ \"./node_modules/@deck.gl/core/dist/esm/lib/attribute/attribute-manager.js\");\n/* harmony import */ var _uniform_transition_manager__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./uniform-transition-manager */ \"./node_modules/@deck.gl/core/dist/esm/lib/uniform-transition-manager.js\");\n/* harmony import */ var _lifecycle_props__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../lifecycle/props */ \"./node_modules/@deck.gl/core/dist/esm/lifecycle/props.js\");\n/* harmony import */ var _utils_count__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/count */ \"./node_modules/@deck.gl/core/dist/esm/utils/count.js\");\n/* harmony import */ var _utils_log__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/log */ \"./node_modules/@deck.gl/core/dist/esm/utils/log.js\");\n/* harmony import */ var _debug__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../debug */ \"./node_modules/@deck.gl/core/dist/esm/debug/index.js\");\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/gltools/dist/esm/index.js\");\n/* harmony import */ var _utils_assert__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils/assert */ \"./node_modules/@deck.gl/core/dist/esm/utils/assert.js\");\n/* harmony import */ var _utils_memoize__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../utils/memoize */ \"./node_modules/@deck.gl/core/dist/esm/utils/memoize.js\");\n/* harmony import */ var _utils_shader__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../utils/shader */ \"./node_modules/@deck.gl/core/dist/esm/utils/shader.js\");\n/* harmony import */ var _shaderlib_project_project_functions__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../shaderlib/project/project-functions */ \"./node_modules/@deck.gl/core/dist/esm/shaderlib/project/project-functions.js\");\n/* harmony import */ var _utils_typed_array_manager__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../utils/typed-array-manager */ \"./node_modules/@deck.gl/core/dist/esm/utils/typed-array-manager.js\");\n/* harmony import */ var _lifecycle_component__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../lifecycle/component */ \"./node_modules/@deck.gl/core/dist/esm/lifecycle/component.js\");\n/* harmony import */ var _layer_state__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./layer-state */ \"./node_modules/@deck.gl/core/dist/esm/lib/layer-state.js\");\n/* harmony import */ var _math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @math.gl/web-mercator */ \"./node_modules/@math.gl/web-mercator/dist/esm/index.js\");\n/* harmony import */ var _loaders_gl_core__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @loaders.gl/core */ \"./node_modules/@loaders.gl/core/dist/esm/lib/api/load.js\");\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nconst TRACE_CHANGE_FLAG = 'layer.changeFlag';\nconst TRACE_INITIALIZE = 'layer.initialize';\nconst TRACE_UPDATE = 'layer.update';\nconst TRACE_FINALIZE = 'layer.finalize';\nconst TRACE_MATCHED = 'layer.matched';\nconst MAX_PICKING_COLOR_CACHE_SIZE = 2 ** 24 - 1;\nconst EMPTY_ARRAY = Object.freeze([]);\nconst areViewportsEqual = Object(_utils_memoize__WEBPACK_IMPORTED_MODULE_9__[\"default\"])(({\n  oldViewport,\n  viewport\n}) => {\n  return oldViewport.equals(viewport);\n});\nlet pickingColorCache = new Uint8ClampedArray(0);\nconst defaultProps = {\n  data: {\n    type: 'data',\n    value: EMPTY_ARRAY,\n    async: true\n  },\n  dataComparator: null,\n  _dataDiff: {\n    type: 'function',\n    value: data => data && data.__diff,\n    compare: false,\n    optional: true\n  },\n  dataTransform: {\n    type: 'function',\n    value: null,\n    compare: false,\n    optional: true\n  },\n  onDataLoad: {\n    type: 'function',\n    value: null,\n    compare: false,\n    optional: true\n  },\n  onError: {\n    type: 'function',\n    value: null,\n    compare: false,\n    optional: true\n  },\n  fetch: {\n    type: 'function',\n    value: (url, {\n      propName,\n      layer,\n      loaders,\n      loadOptions,\n      signal\n    }) => {\n      const {\n        resourceManager\n      } = layer.context;\n      loadOptions = loadOptions || layer.getLoadOptions();\n      loaders = loaders || layer.props.loaders;\n\n      if (signal) {\n        var _loadOptions;\n\n        loadOptions = { ...loadOptions,\n          fetch: { ...((_loadOptions = loadOptions) === null || _loadOptions === void 0 ? void 0 : _loadOptions.fetch),\n            signal\n          }\n        };\n      }\n\n      let inResourceManager = resourceManager.contains(url);\n\n      if (!inResourceManager && !loadOptions) {\n        resourceManager.add({\n          resourceId: url,\n          data: Object(_loaders_gl_core__WEBPACK_IMPORTED_MODULE_16__[\"load\"])(url, loaders),\n          persistent: false\n        });\n        inResourceManager = true;\n      }\n\n      if (inResourceManager) {\n        return resourceManager.subscribe({\n          resourceId: url,\n          onChange: data => layer.internalState.reloadAsyncProp(propName, data),\n          consumerId: layer.id,\n          requestId: propName\n        });\n      }\n\n      return Object(_loaders_gl_core__WEBPACK_IMPORTED_MODULE_16__[\"load\"])(url, loaders, loadOptions);\n    },\n    compare: false\n  },\n  updateTriggers: {},\n  visible: true,\n  pickable: false,\n  opacity: {\n    type: 'number',\n    min: 0,\n    max: 1,\n    value: 1\n  },\n  onHover: {\n    type: 'function',\n    value: null,\n    compare: false,\n    optional: true\n  },\n  onClick: {\n    type: 'function',\n    value: null,\n    compare: false,\n    optional: true\n  },\n  onDragStart: {\n    type: 'function',\n    value: null,\n    compare: false,\n    optional: true\n  },\n  onDrag: {\n    type: 'function',\n    value: null,\n    compare: false,\n    optional: true\n  },\n  onDragEnd: {\n    type: 'function',\n    value: null,\n    compare: false,\n    optional: true\n  },\n  coordinateSystem: _constants__WEBPACK_IMPORTED_MODULE_0__[\"COORDINATE_SYSTEM\"].DEFAULT,\n  coordinateOrigin: {\n    type: 'array',\n    value: [0, 0, 0],\n    compare: true\n  },\n  modelMatrix: {\n    type: 'array',\n    value: null,\n    compare: true,\n    optional: true\n  },\n  wrapLongitude: false,\n  positionFormat: 'XYZ',\n  colorFormat: 'RGBA',\n  parameters: {},\n  transitions: null,\n  extensions: [],\n  loaders: {\n    type: 'array',\n    value: [],\n    optional: true,\n    compare: true\n  },\n  getPolygonOffset: {\n    type: 'function',\n    value: ({\n      layerIndex\n    }) => [0, -layerIndex * 100],\n    compare: false\n  },\n  highlightedObjectIndex: -1,\n  autoHighlight: false,\n  highlightColor: {\n    type: 'accessor',\n    value: [0, 0, 128, 128]\n  }\n};\nclass Layer extends _lifecycle_component__WEBPACK_IMPORTED_MODULE_13__[\"default\"] {\n  toString() {\n    const className = this.constructor.layerName || this.constructor.name;\n    return \"\".concat(className, \"({id: '\").concat(this.props.id, \"'})\");\n  }\n\n  raiseError(error, message) {\n    var _this$props$onError, _this$props;\n\n    if (message) {\n      error.message = \"\".concat(message, \": \").concat(error.message);\n    }\n\n    if (!((_this$props$onError = (_this$props = this.props).onError) === null || _this$props$onError === void 0 ? void 0 : _this$props$onError.call(_this$props, error))) {\n      var _this$context, _this$context$onError;\n\n      (_this$context = this.context) === null || _this$context === void 0 ? void 0 : (_this$context$onError = _this$context.onError) === null || _this$context$onError === void 0 ? void 0 : _this$context$onError.call(_this$context, error, this);\n    }\n  }\n\n  setState(updateObject) {\n    this.setChangeFlags({\n      stateChanged: true\n    });\n    Object.assign(this.state, updateObject);\n    this.setNeedsRedraw();\n  }\n\n  setNeedsRedraw(redraw = true) {\n    if (this.internalState) {\n      this.internalState.needsRedraw = redraw;\n    }\n  }\n\n  setNeedsUpdate() {\n    this.context.layerManager.setNeedsUpdate(String(this));\n    this.internalState.needsUpdate = true;\n  }\n\n  getNeedsRedraw(opts = {\n    clearRedrawFlags: false\n  }) {\n    return this._getNeedsRedraw(opts);\n  }\n\n  needsUpdate() {\n    return this.internalState.needsUpdate || this.hasUniformTransition() || this.shouldUpdateState(this._getUpdateParams());\n  }\n\n  hasUniformTransition() {\n    return this.internalState.uniformTransitions.active;\n  }\n\n  get isLoaded() {\n    return this.internalState && !this.internalState.isAsyncPropLoading();\n  }\n\n  get wrapLongitude() {\n    return this.props.wrapLongitude;\n  }\n\n  isPickable() {\n    return this.props.pickable && this.props.visible;\n  }\n\n  getModels() {\n    return this.state && (this.state.models || (this.state.model ? [this.state.model] : []));\n  }\n\n  getAttributeManager() {\n    return this.internalState && this.internalState.attributeManager;\n  }\n\n  getCurrentLayer() {\n    return this.internalState && this.internalState.layer;\n  }\n\n  getLoadOptions() {\n    return this.props.loadOptions;\n  }\n\n  project(xyz) {\n    const {\n      viewport\n    } = this.context;\n    const worldPosition = Object(_shaderlib_project_project_functions__WEBPACK_IMPORTED_MODULE_11__[\"getWorldPosition\"])(xyz, {\n      viewport,\n      modelMatrix: this.props.modelMatrix,\n      coordinateOrigin: this.props.coordinateOrigin,\n      coordinateSystem: this.props.coordinateSystem\n    });\n    const [x, y, z] = Object(_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_15__[\"worldToPixels\"])(worldPosition, viewport.pixelProjectionMatrix);\n    return xyz.length === 2 ? [x, y] : [x, y, z];\n  }\n\n  unproject(xy) {\n    const {\n      viewport\n    } = this.context;\n    return viewport.unproject(xy);\n  }\n\n  projectPosition(xyz) {\n    return Object(_shaderlib_project_project_functions__WEBPACK_IMPORTED_MODULE_11__[\"projectPosition\"])(xyz, {\n      viewport: this.context.viewport,\n      modelMatrix: this.props.modelMatrix,\n      coordinateOrigin: this.props.coordinateOrigin,\n      coordinateSystem: this.props.coordinateSystem\n    });\n  }\n\n  use64bitPositions() {\n    const {\n      coordinateSystem\n    } = this.props;\n    return coordinateSystem === _constants__WEBPACK_IMPORTED_MODULE_0__[\"COORDINATE_SYSTEM\"].DEFAULT || coordinateSystem === _constants__WEBPACK_IMPORTED_MODULE_0__[\"COORDINATE_SYSTEM\"].LNGLAT || coordinateSystem === _constants__WEBPACK_IMPORTED_MODULE_0__[\"COORDINATE_SYSTEM\"].CARTESIAN;\n  }\n\n  onHover(info, pickingEvent) {\n    if (this.props.onHover) {\n      return this.props.onHover(info, pickingEvent);\n    }\n\n    return false;\n  }\n\n  onClick(info, pickingEvent) {\n    if (this.props.onClick) {\n      return this.props.onClick(info, pickingEvent);\n    }\n\n    return false;\n  }\n\n  nullPickingColor() {\n    return [0, 0, 0];\n  }\n\n  encodePickingColor(i, target = []) {\n    target[0] = i + 1 & 255;\n    target[1] = i + 1 >> 8 & 255;\n    target[2] = i + 1 >> 8 >> 8 & 255;\n    return target;\n  }\n\n  decodePickingColor(color) {\n    Object(_utils_assert__WEBPACK_IMPORTED_MODULE_8__[\"default\"])(color instanceof Uint8Array);\n    const [i1, i2, i3] = color;\n    const index = i1 + i2 * 256 + i3 * 65536 - 1;\n    return index;\n  }\n\n  initializeState() {\n    throw new Error(\"Layer \".concat(this, \" has not defined initializeState\"));\n  }\n\n  getShaders(shaders) {\n    for (const extension of this.props.extensions) {\n      shaders = Object(_utils_shader__WEBPACK_IMPORTED_MODULE_10__[\"mergeShaders\"])(shaders, extension.getShaders.call(this, extension));\n    }\n\n    return shaders;\n  }\n\n  shouldUpdateState({\n    oldProps,\n    props,\n    context,\n    changeFlags\n  }) {\n    return changeFlags.propsOrDataChanged;\n  }\n\n  updateState({\n    oldProps,\n    props,\n    context,\n    changeFlags\n  }) {\n    const attributeManager = this.getAttributeManager();\n\n    if (changeFlags.dataChanged && attributeManager) {\n      const {\n        dataChanged\n      } = changeFlags;\n\n      if (Array.isArray(dataChanged)) {\n        for (const dataRange of dataChanged) {\n          attributeManager.invalidateAll(dataRange);\n        }\n      } else {\n        attributeManager.invalidateAll();\n      }\n    }\n\n    const neededPickingBuffer = oldProps.highlightedObjectIndex >= 0 || oldProps.pickable;\n    const needPickingBuffer = props.highlightedObjectIndex >= 0 || props.pickable;\n\n    if (neededPickingBuffer !== needPickingBuffer && attributeManager) {\n      const {\n        pickingColors,\n        instancePickingColors\n      } = attributeManager.attributes;\n      const pickingColorsAttribute = pickingColors || instancePickingColors;\n\n      if (pickingColorsAttribute) {\n        if (needPickingBuffer && pickingColorsAttribute.constant) {\n          pickingColorsAttribute.constant = false;\n          attributeManager.invalidate(pickingColorsAttribute.id);\n        }\n\n        if (!pickingColorsAttribute.value && !needPickingBuffer) {\n          pickingColorsAttribute.constant = true;\n          pickingColorsAttribute.value = [0, 0, 0];\n        }\n      }\n    }\n  }\n\n  finalizeState() {\n    for (const model of this.getModels()) {\n      model.delete();\n    }\n\n    const attributeManager = this.getAttributeManager();\n\n    if (attributeManager) {\n      attributeManager.finalize();\n    }\n\n    this.context.resourceManager.unsubscribe({\n      consumerId: this.id\n    });\n    this.internalState.uniformTransitions.clear();\n    this.internalState.finalize();\n  }\n\n  draw(opts) {\n    for (const model of this.getModels()) {\n      model.draw(opts);\n    }\n  }\n\n  getPickingInfo({\n    info,\n    mode\n  }) {\n    const {\n      index\n    } = info;\n\n    if (index >= 0) {\n      if (Array.isArray(this.props.data)) {\n        info.object = this.props.data[index];\n      }\n    }\n\n    return info;\n  }\n\n  activateViewport(viewport) {\n    const oldViewport = this.internalState.viewport;\n    this.internalState.viewport = viewport;\n\n    if (!oldViewport || !areViewportsEqual({\n      oldViewport,\n      viewport\n    })) {\n      this.setChangeFlags({\n        viewportChanged: true\n      });\n\n      if (this.isComposite) {\n        if (this.needsUpdate()) {\n          this.setNeedsUpdate();\n        }\n      } else {\n        this._update();\n      }\n    }\n  }\n\n  invalidateAttribute(name = 'all', diffReason = '') {\n    const attributeManager = this.getAttributeManager();\n\n    if (!attributeManager) {\n      return;\n    }\n\n    if (name === 'all') {\n      attributeManager.invalidateAll();\n    } else {\n      attributeManager.invalidate(name);\n    }\n  }\n\n  updateAttributes(changedAttributes) {\n    for (const model of this.getModels()) {\n      this._setModelAttributes(model, changedAttributes);\n    }\n  }\n\n  _updateAttributes(props) {\n    const attributeManager = this.getAttributeManager();\n\n    if (!attributeManager) {\n      return;\n    }\n\n    const numInstances = this.getNumInstances(props);\n    const startIndices = this.getStartIndices(props);\n    attributeManager.update({\n      data: props.data,\n      numInstances,\n      startIndices,\n      props,\n      transitions: props.transitions,\n      buffers: props.data.attributes,\n      context: this,\n      ignoreUnknownAttributes: true\n    });\n    const changedAttributes = attributeManager.getChangedAttributes({\n      clearChangedFlags: true\n    });\n    this.updateAttributes(changedAttributes);\n  }\n\n  _updateAttributeTransition() {\n    const attributeManager = this.getAttributeManager();\n\n    if (attributeManager) {\n      attributeManager.updateTransition();\n    }\n  }\n\n  _updateUniformTransition() {\n    const {\n      uniformTransitions\n    } = this.internalState;\n\n    if (uniformTransitions.active) {\n      const propsInTransition = uniformTransitions.update();\n      const props = Object.create(this.props);\n\n      for (const key in propsInTransition) {\n        Object.defineProperty(props, key, {\n          value: propsInTransition[key]\n        });\n      }\n\n      return props;\n    }\n\n    return this.props;\n  }\n\n  calculateInstancePickingColors(attribute, {\n    numInstances\n  }) {\n    if (attribute.constant) {\n      return;\n    }\n\n    const cacheSize = Math.floor(pickingColorCache.length / 3);\n    this.internalState.usesPickingColorCache = true;\n\n    if (cacheSize < numInstances) {\n      if (numInstances > MAX_PICKING_COLOR_CACHE_SIZE) {\n        _utils_log__WEBPACK_IMPORTED_MODULE_5__[\"default\"].warn('Layer has too many data objects. Picking might not be able to distinguish all objects.')();\n      }\n\n      pickingColorCache = _utils_typed_array_manager__WEBPACK_IMPORTED_MODULE_12__[\"default\"].allocate(pickingColorCache, numInstances, {\n        size: 3,\n        copy: true,\n        maxCount: Math.max(numInstances, MAX_PICKING_COLOR_CACHE_SIZE)\n      });\n      const newCacheSize = Math.floor(pickingColorCache.length / 3);\n      const pickingColor = [];\n\n      for (let i = cacheSize; i < newCacheSize; i++) {\n        this.encodePickingColor(i, pickingColor);\n        pickingColorCache[i * 3 + 0] = pickingColor[0];\n        pickingColorCache[i * 3 + 1] = pickingColor[1];\n        pickingColorCache[i * 3 + 2] = pickingColor[2];\n      }\n    }\n\n    attribute.value = pickingColorCache.subarray(0, numInstances * 3);\n  }\n\n  _setModelAttributes(model, changedAttributes) {\n    const attributeManager = this.getAttributeManager();\n    const excludeAttributes = model.userData.excludeAttributes || {};\n    const shaderAttributes = attributeManager.getShaderAttributes(changedAttributes, excludeAttributes);\n    model.setAttributes(shaderAttributes);\n  }\n\n  disablePickingIndex(objectIndex) {\n    this._disablePickingIndex(objectIndex);\n  }\n\n  _disablePickingIndex(objectIndex) {\n    const {\n      pickingColors,\n      instancePickingColors\n    } = this.getAttributeManager().attributes;\n    const colors = pickingColors || instancePickingColors;\n    const start = colors.getVertexOffset(objectIndex);\n    const end = colors.getVertexOffset(objectIndex + 1);\n    colors.buffer.subData({\n      data: new Uint8Array(end - start),\n      offset: start\n    });\n  }\n\n  restorePickingColors() {\n    const {\n      pickingColors,\n      instancePickingColors\n    } = this.getAttributeManager().attributes;\n    const colors = pickingColors || instancePickingColors;\n\n    if (this.internalState.usesPickingColorCache && colors.value.buffer !== pickingColorCache.buffer) {\n      colors.value = pickingColorCache.subarray(0, colors.value.length);\n    }\n\n    colors.updateSubBuffer({\n      startOffset: 0\n    });\n  }\n\n  getNumInstances(props) {\n    props = props || this.props;\n\n    if (props.numInstances !== undefined) {\n      return props.numInstances;\n    }\n\n    if (this.state && this.state.numInstances !== undefined) {\n      return this.state.numInstances;\n    }\n\n    return Object(_utils_count__WEBPACK_IMPORTED_MODULE_4__[\"count\"])(props.data);\n  }\n\n  getStartIndices(props) {\n    props = props || this.props;\n\n    if (props.startIndices !== undefined) {\n      return props.startIndices;\n    }\n\n    if (this.state && this.state.startIndices) {\n      return this.state.startIndices;\n    }\n\n    return null;\n  }\n\n  _initialize() {\n    Object(_debug__WEBPACK_IMPORTED_MODULE_6__[\"default\"])(TRACE_INITIALIZE, this);\n\n    this._initState();\n\n    this.initializeState(this.context);\n\n    for (const extension of this.props.extensions) {\n      extension.initializeState.call(this, this.context, extension);\n    }\n\n    this.setChangeFlags({\n      dataChanged: true,\n      propsChanged: true,\n      viewportChanged: true,\n      extensionsChanged: true\n    });\n\n    this._updateState();\n  }\n\n  _update() {\n    const stateNeedsUpdate = this.needsUpdate();\n    Object(_debug__WEBPACK_IMPORTED_MODULE_6__[\"default\"])(TRACE_UPDATE, this, stateNeedsUpdate);\n\n    if (stateNeedsUpdate) {\n      this._updateState();\n    }\n  }\n\n  _updateState() {\n    const currentProps = this.props;\n    const currentViewport = this.context.viewport;\n\n    const propsInTransition = this._updateUniformTransition();\n\n    this.internalState.propsInTransition = propsInTransition;\n    this.context.viewport = this.internalState.viewport || currentViewport;\n    this.props = propsInTransition;\n\n    try {\n      const updateParams = this._getUpdateParams();\n\n      const oldModels = this.getModels();\n\n      if (this.context.gl) {\n        this.updateState(updateParams);\n      } else {\n        try {\n          this.updateState(updateParams);\n        } catch (error) {}\n      }\n\n      for (const extension of this.props.extensions) {\n        extension.updateState.call(this, updateParams, extension);\n      }\n\n      const modelChanged = this.getModels()[0] !== oldModels[0];\n\n      this._updateModules(updateParams, modelChanged);\n\n      if (this.isComposite) {\n        this._renderLayers(updateParams);\n      } else {\n        this.setNeedsRedraw();\n\n        this._updateAttributes(this.props);\n\n        if (this.state.model) {\n          this.state.model.setInstanceCount(this.getNumInstances());\n        }\n      }\n    } finally {\n      this.context.viewport = currentViewport;\n      this.props = currentProps;\n      this.clearChangeFlags();\n      this.internalState.needsUpdate = false;\n      this.internalState.resetOldProps();\n    }\n  }\n\n  _finalize() {\n    Object(_debug__WEBPACK_IMPORTED_MODULE_6__[\"default\"])(TRACE_FINALIZE, this);\n    this.finalizeState(this.context);\n\n    for (const extension of this.props.extensions) {\n      extension.finalizeState.call(this, extension);\n    }\n  }\n\n  drawLayer({\n    moduleParameters = null,\n    uniforms = {},\n    parameters = {}\n  }) {\n    this._updateAttributeTransition();\n\n    const currentProps = this.props;\n    this.props = this.internalState.propsInTransition || currentProps;\n    const {\n      opacity\n    } = this.props;\n    uniforms.opacity = Math.pow(opacity, 1 / 2.2);\n\n    try {\n      if (moduleParameters) {\n        this.setModuleParameters(moduleParameters);\n      }\n\n      const {\n        getPolygonOffset\n      } = this.props;\n      const offsets = getPolygonOffset && getPolygonOffset(uniforms) || [0, 0];\n      Object(_luma_gl_core__WEBPACK_IMPORTED_MODULE_7__[\"setParameters\"])(this.context.gl, {\n        polygonOffset: offsets\n      });\n      Object(_luma_gl_core__WEBPACK_IMPORTED_MODULE_7__[\"withParameters\"])(this.context.gl, parameters, () => {\n        const opts = {\n          moduleParameters,\n          uniforms,\n          parameters,\n          context: this.context\n        };\n\n        for (const extension of this.props.extensions) {\n          extension.draw.call(this, opts, extension);\n        }\n\n        this.draw(opts);\n      });\n    } finally {\n      this.props = currentProps;\n    }\n  }\n\n  getChangeFlags() {\n    return this.internalState.changeFlags;\n  }\n\n  setChangeFlags(flags) {\n    const {\n      changeFlags\n    } = this.internalState;\n\n    for (const key in flags) {\n      if (flags[key]) {\n        let flagChanged = false;\n\n        switch (key) {\n          case 'dataChanged':\n            if (Array.isArray(changeFlags[key])) {\n              changeFlags[key] = Array.isArray(flags[key]) ? changeFlags[key].concat(flags[key]) : flags[key];\n              flagChanged = true;\n            }\n\n          default:\n            if (!changeFlags[key]) {\n              changeFlags[key] = flags[key];\n              flagChanged = true;\n            }\n\n        }\n\n        if (flagChanged) {\n          Object(_debug__WEBPACK_IMPORTED_MODULE_6__[\"default\"])(TRACE_CHANGE_FLAG, this, key, flags);\n        }\n      }\n    }\n\n    const propsOrDataChanged = changeFlags.dataChanged || changeFlags.updateTriggersChanged || changeFlags.propsChanged || changeFlags.extensionsChanged;\n    changeFlags.propsOrDataChanged = propsOrDataChanged;\n    changeFlags.somethingChanged = propsOrDataChanged || flags.viewportChanged || flags.stateChanged;\n  }\n\n  clearChangeFlags() {\n    this.internalState.changeFlags = {\n      dataChanged: false,\n      propsChanged: false,\n      updateTriggersChanged: false,\n      viewportChanged: false,\n      stateChanged: false,\n      extensionsChanged: false,\n      propsOrDataChanged: false,\n      somethingChanged: false\n    };\n  }\n\n  diffProps(newProps, oldProps) {\n    const changeFlags = Object(_lifecycle_props__WEBPACK_IMPORTED_MODULE_3__[\"diffProps\"])(newProps, oldProps);\n\n    if (changeFlags.updateTriggersChanged) {\n      for (const key in changeFlags.updateTriggersChanged) {\n        if (changeFlags.updateTriggersChanged[key]) {\n          this.invalidateAttribute(key);\n        }\n      }\n    }\n\n    if (changeFlags.transitionsChanged) {\n      for (const key in changeFlags.transitionsChanged) {\n        this.internalState.uniformTransitions.add(key, oldProps[key], newProps[key], newProps.transitions[key]);\n      }\n    }\n\n    return this.setChangeFlags(changeFlags);\n  }\n\n  validateProps() {\n    Object(_lifecycle_props__WEBPACK_IMPORTED_MODULE_3__[\"validateProps\"])(this.props);\n  }\n\n  setModuleParameters(moduleParameters) {\n    for (const model of this.getModels()) {\n      model.updateModuleSettings(moduleParameters);\n    }\n  }\n\n  updateAutoHighlight(info) {\n    if (this.props.autoHighlight) {\n      this._updateAutoHighlight(info);\n    }\n  }\n\n  _updateAutoHighlight(info) {\n    const pickingModuleParameters = {\n      pickingSelectedColor: info.picked ? info.color : null\n    };\n    const {\n      highlightColor\n    } = this.props;\n\n    if (info.picked && typeof highlightColor === 'function') {\n      pickingModuleParameters.pickingHighlightColor = highlightColor(info);\n    }\n\n    this.setModuleParameters(pickingModuleParameters);\n    this.setNeedsRedraw();\n  }\n\n  _updateModules({\n    props,\n    oldProps\n  }, forceUpdate) {\n    const {\n      autoHighlight,\n      highlightedObjectIndex,\n      highlightColor\n    } = props;\n\n    if (forceUpdate || oldProps.autoHighlight !== autoHighlight || oldProps.highlightedObjectIndex !== highlightedObjectIndex || oldProps.highlightColor !== highlightColor) {\n      const parameters = {};\n\n      if (!autoHighlight) {\n        parameters.pickingSelectedColor = null;\n      }\n\n      if (Array.isArray(highlightColor)) {\n        parameters.pickingHighlightColor = highlightColor;\n      }\n\n      if (Number.isInteger(highlightedObjectIndex)) {\n        parameters.pickingSelectedColor = highlightedObjectIndex >= 0 ? this.encodePickingColor(highlightedObjectIndex) : null;\n      }\n\n      this.setModuleParameters(parameters);\n    }\n  }\n\n  _getUpdateParams() {\n    return {\n      props: this.props,\n      oldProps: this.internalState.getOldProps(),\n      context: this.context,\n      changeFlags: this.internalState.changeFlags\n    };\n  }\n\n  _getNeedsRedraw(opts) {\n    if (!this.internalState) {\n      return false;\n    }\n\n    let redraw = false;\n    redraw = redraw || this.internalState.needsRedraw && this.id;\n    this.internalState.needsRedraw = this.internalState.needsRedraw && !opts.clearRedrawFlags;\n    const attributeManager = this.getAttributeManager();\n    const attributeManagerNeedsRedraw = attributeManager && attributeManager.getNeedsRedraw(opts);\n    redraw = redraw || attributeManagerNeedsRedraw;\n    return redraw;\n  }\n\n  _getAttributeManager() {\n    return new _attribute_attribute_manager__WEBPACK_IMPORTED_MODULE_1__[\"default\"](this.context.gl, {\n      id: this.props.id,\n      stats: this.context.stats,\n      timeline: this.context.timeline\n    });\n  }\n\n  _initState() {\n    Object(_utils_assert__WEBPACK_IMPORTED_MODULE_8__[\"default\"])(!this.internalState && !this.state);\n    Object(_utils_assert__WEBPACK_IMPORTED_MODULE_8__[\"default\"])(isFinite(this.props.coordinateSystem));\n\n    const attributeManager = this._getAttributeManager();\n\n    if (attributeManager) {\n      attributeManager.addInstanced({\n        instancePickingColors: {\n          type: 5121,\n          size: 3,\n          noAlloc: true,\n          update: this.calculateInstancePickingColors\n        }\n      });\n    }\n\n    this.internalState = new _layer_state__WEBPACK_IMPORTED_MODULE_14__[\"default\"]({\n      attributeManager,\n      layer: this\n    });\n    this.clearChangeFlags();\n    this.state = {};\n    Object.defineProperty(this.state, 'attributeManager', {\n      get: () => {\n        _utils_log__WEBPACK_IMPORTED_MODULE_5__[\"default\"].deprecated('layer.state.attributeManager', 'layer.getAttributeManager()');\n        return attributeManager;\n      }\n    });\n    this.internalState.layer = this;\n    this.internalState.uniformTransitions = new _uniform_transition_manager__WEBPACK_IMPORTED_MODULE_2__[\"default\"](this.context.timeline);\n    this.internalState.onAsyncPropUpdated = this._onAsyncPropUpdated.bind(this);\n    this.internalState.setAsyncProps(this.props);\n  }\n\n  _transferState(oldLayer) {\n    Object(_debug__WEBPACK_IMPORTED_MODULE_6__[\"default\"])(TRACE_MATCHED, this, this === oldLayer);\n    const {\n      state,\n      internalState\n    } = oldLayer;\n\n    if (this === oldLayer) {\n      return;\n    }\n\n    this.internalState = internalState;\n    this.internalState.layer = this;\n    this.state = state;\n    this.internalState.setAsyncProps(this.props);\n    this.diffProps(this.props, this.internalState.getOldProps());\n  }\n\n  _onAsyncPropUpdated() {\n    this.diffProps(this.props, this.internalState.getOldProps());\n    this.setNeedsUpdate();\n  }\n\n}\nLayer.layerName = 'Layer';\nLayer.defaultProps = defaultProps;\n//# sourceMappingURL=layer.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lib/layer.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lib/picking/pick-info.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lib/picking/pick-info.js ***!
  \**********************************************************************/
/*! exports provided: getEmptyPickingInfo, processPickInfo, getLayerPickingInfo */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getEmptyPickingInfo\", function() { return getEmptyPickingInfo; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"processPickInfo\", function() { return processPickInfo; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getLayerPickingInfo\", function() { return getLayerPickingInfo; });\nfunction getEmptyPickingInfo({\n  pickInfo,\n  mode,\n  viewports,\n  layerFilter,\n  pixelRatio,\n  x,\n  y,\n  z\n}) {\n  const layer = pickInfo && pickInfo.pickedLayer;\n\n  const viewportFilter = layerFilter && layer && (v => layerFilter({\n    layer,\n    viewport: v,\n    isPicking: true,\n    renderPass: \"picking:\".concat(mode)\n  }));\n\n  const viewport = getViewportFromCoordinates(viewports, {\n    x,\n    y\n  }, viewportFilter);\n  const coordinate = viewport && viewport.unproject([x - viewport.x, y - viewport.y], {\n    targetZ: z\n  });\n  return {\n    color: null,\n    layer: null,\n    viewport,\n    index: -1,\n    picked: false,\n    x,\n    y,\n    pixel: [x, y],\n    coordinate,\n    devicePixel: pickInfo && [pickInfo.pickedX, pickInfo.pickedY],\n    pixelRatio\n  };\n}\nfunction processPickInfo(opts) {\n  const {\n    pickInfo,\n    lastPickedInfo,\n    mode,\n    layers\n  } = opts;\n  const {\n    pickedColor,\n    pickedLayer,\n    pickedObjectIndex\n  } = pickInfo;\n  const affectedLayers = pickedLayer ? [pickedLayer] : [];\n\n  if (mode === 'hover') {\n    const lastPickedObjectIndex = lastPickedInfo.index;\n    const lastPickedLayerId = lastPickedInfo.layerId;\n    const pickedLayerId = pickedLayer && pickedLayer.props.id;\n\n    if (pickedLayerId !== lastPickedLayerId || pickedObjectIndex !== lastPickedObjectIndex) {\n      if (pickedLayerId !== lastPickedLayerId) {\n        const lastPickedLayer = layers.find(layer => layer.props.id === lastPickedLayerId);\n\n        if (lastPickedLayer) {\n          affectedLayers.unshift(lastPickedLayer);\n        }\n      }\n\n      lastPickedInfo.layerId = pickedLayerId;\n      lastPickedInfo.index = pickedObjectIndex;\n      lastPickedInfo.info = null;\n    }\n  }\n\n  const baseInfo = getEmptyPickingInfo(opts);\n  const infos = new Map();\n  infos.set(null, baseInfo);\n  affectedLayers.forEach(layer => {\n    let info = { ...baseInfo\n    };\n\n    if (layer === pickedLayer) {\n      info.color = pickedColor;\n      info.index = pickedObjectIndex;\n      info.picked = true;\n    }\n\n    info = getLayerPickingInfo({\n      layer,\n      info,\n      mode\n    });\n\n    if (layer === pickedLayer && mode === 'hover') {\n      lastPickedInfo.info = info;\n    }\n\n    infos.set(info.layer.id, info);\n\n    if (mode === 'hover') {\n      info.layer.updateAutoHighlight(info);\n    }\n  });\n  return infos;\n}\nfunction getLayerPickingInfo({\n  layer,\n  info,\n  mode\n}) {\n  while (layer && info) {\n    const sourceLayer = info.layer || null;\n    info.sourceLayer = sourceLayer;\n    info.layer = layer;\n    info = layer.getPickingInfo({\n      info,\n      mode,\n      sourceLayer\n    });\n    layer = layer.parent;\n  }\n\n  return info;\n}\n\nfunction getViewportFromCoordinates(viewports, pixel, filter) {\n  for (let i = viewports.length - 1; i >= 0; i--) {\n    const viewport = viewports[i];\n\n    if (viewport.containsPixel(pixel) && (!filter || filter(viewport))) {\n      return viewport;\n    }\n  }\n\n  return viewports[0];\n}\n//# sourceMappingURL=pick-info.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lib/picking/pick-info.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lib/picking/query-object.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lib/picking/query-object.js ***!
  \*************************************************************************/
/*! exports provided: getClosestObject, getUniqueObjects */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getClosestObject\", function() { return getClosestObject; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getUniqueObjects\", function() { return getUniqueObjects; });\n/* harmony import */ var _utils_log__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/log */ \"./node_modules/@deck.gl/core/dist/esm/utils/log.js\");\n\nconst NO_PICKED_OBJECT = {\n  pickedColor: null,\n  pickedLayer: null,\n  pickedObjectIndex: -1\n};\nfunction getClosestObject({\n  pickedColors,\n  layers,\n  deviceX,\n  deviceY,\n  deviceRadius,\n  deviceRect\n}) {\n  if (pickedColors) {\n    const {\n      x,\n      y,\n      width,\n      height\n    } = deviceRect;\n    let minSquareDistanceToCenter = deviceRadius * deviceRadius;\n    let closestPixelIndex = -1;\n    let i = 0;\n\n    for (let row = 0; row < height; row++) {\n      const dy = row + y - deviceY;\n      const dy2 = dy * dy;\n\n      if (dy2 > minSquareDistanceToCenter) {\n        i += 4 * width;\n      } else {\n        for (let col = 0; col < width; col++) {\n          const pickedLayerIndex = pickedColors[i + 3] - 1;\n\n          if (pickedLayerIndex >= 0) {\n            const dx = col + x - deviceX;\n            const d2 = dx * dx + dy2;\n\n            if (d2 <= minSquareDistanceToCenter) {\n              minSquareDistanceToCenter = d2;\n              closestPixelIndex = i;\n            }\n          }\n\n          i += 4;\n        }\n      }\n    }\n\n    if (closestPixelIndex >= 0) {\n      const pickedLayerIndex = pickedColors[closestPixelIndex + 3] - 1;\n      const pickedColor = pickedColors.slice(closestPixelIndex, closestPixelIndex + 4);\n      const pickedLayer = layers[pickedLayerIndex];\n\n      if (pickedLayer) {\n        const pickedObjectIndex = pickedLayer.decodePickingColor(pickedColor);\n        const dy = Math.floor(closestPixelIndex / 4 / width);\n        const dx = closestPixelIndex / 4 - dy * width;\n        return {\n          pickedColor,\n          pickedLayer,\n          pickedObjectIndex,\n          pickedX: x + dx,\n          pickedY: y + dy\n        };\n      }\n\n      _utils_log__WEBPACK_IMPORTED_MODULE_0__[\"default\"].error('Picked non-existent layer. Is picking buffer corrupt?')();\n    }\n  }\n\n  return NO_PICKED_OBJECT;\n}\nfunction getUniqueObjects({\n  pickedColors,\n  layers\n}) {\n  const uniqueColors = new Map();\n\n  if (pickedColors) {\n    for (let i = 0; i < pickedColors.length; i += 4) {\n      const pickedLayerIndex = pickedColors[i + 3] - 1;\n\n      if (pickedLayerIndex >= 0) {\n        const pickedColor = pickedColors.slice(i, i + 4);\n        const colorKey = pickedColor.join(',');\n\n        if (!uniqueColors.has(colorKey)) {\n          const pickedLayer = layers[pickedLayerIndex];\n\n          if (pickedLayer) {\n            uniqueColors.set(colorKey, {\n              pickedColor,\n              pickedLayer,\n              pickedObjectIndex: pickedLayer.decodePickingColor(pickedColor)\n            });\n          } else {\n            _utils_log__WEBPACK_IMPORTED_MODULE_0__[\"default\"].error('Picked non-existent layer. Is picking buffer corrupt?')();\n          }\n        }\n      }\n    }\n  }\n\n  return Array.from(uniqueColors.values());\n}\n//# sourceMappingURL=query-object.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS9saWIvcGlja2luZy9xdWVyeS1vYmplY3QuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS9saWIvcGlja2luZy9xdWVyeS1vYmplY3QuanM/YTAxMyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgbG9nIGZyb20gJy4uLy4uL3V0aWxzL2xvZyc7XG5jb25zdCBOT19QSUNLRURfT0JKRUNUID0ge1xuICBwaWNrZWRDb2xvcjogbnVsbCxcbiAgcGlja2VkTGF5ZXI6IG51bGwsXG4gIHBpY2tlZE9iamVjdEluZGV4OiAtMVxufTtcbmV4cG9ydCBmdW5jdGlvbiBnZXRDbG9zZXN0T2JqZWN0KHtcbiAgcGlja2VkQ29sb3JzLFxuICBsYXllcnMsXG4gIGRldmljZVgsXG4gIGRldmljZVksXG4gIGRldmljZVJhZGl1cyxcbiAgZGV2aWNlUmVjdFxufSkge1xuICBpZiAocGlja2VkQ29sb3JzKSB7XG4gICAgY29uc3Qge1xuICAgICAgeCxcbiAgICAgIHksXG4gICAgICB3aWR0aCxcbiAgICAgIGhlaWdodFxuICAgIH0gPSBkZXZpY2VSZWN0O1xuICAgIGxldCBtaW5TcXVhcmVEaXN0YW5jZVRvQ2VudGVyID0gZGV2aWNlUmFkaXVzICogZGV2aWNlUmFkaXVzO1xuICAgIGxldCBjbG9zZXN0UGl4ZWxJbmRleCA9IC0xO1xuICAgIGxldCBpID0gMDtcblxuICAgIGZvciAobGV0IHJvdyA9IDA7IHJvdyA8IGhlaWdodDsgcm93KyspIHtcbiAgICAgIGNvbnN0IGR5ID0gcm93ICsgeSAtIGRldmljZVk7XG4gICAgICBjb25zdCBkeTIgPSBkeSAqIGR5O1xuXG4gICAgICBpZiAoZHkyID4gbWluU3F1YXJlRGlzdGFuY2VUb0NlbnRlcikge1xuICAgICAgICBpICs9IDQgKiB3aWR0aDtcbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIGZvciAobGV0IGNvbCA9IDA7IGNvbCA8IHdpZHRoOyBjb2wrKykge1xuICAgICAgICAgIGNvbnN0IHBpY2tlZExheWVySW5kZXggPSBwaWNrZWRDb2xvcnNbaSArIDNdIC0gMTtcblxuICAgICAgICAgIGlmIChwaWNrZWRMYXllckluZGV4ID49IDApIHtcbiAgICAgICAgICAgIGNvbnN0IGR4ID0gY29sICsgeCAtIGRldmljZVg7XG4gICAgICAgICAgICBjb25zdCBkMiA9IGR4ICogZHggKyBkeTI7XG5cbiAgICAgICAgICAgIGlmIChkMiA8PSBtaW5TcXVhcmVEaXN0YW5jZVRvQ2VudGVyKSB7XG4gICAgICAgICAgICAgIG1pblNxdWFyZURpc3RhbmNlVG9DZW50ZXIgPSBkMjtcbiAgICAgICAgICAgICAgY2xvc2VzdFBpeGVsSW5kZXggPSBpO1xuICAgICAgICAgICAgfVxuICAgICAgICAgIH1cblxuICAgICAgICAgIGkgKz0gNDtcbiAgICAgICAgfVxuICAgICAgfVxuICAgIH1cblxuICAgIGlmIChjbG9zZXN0UGl4ZWxJbmRleCA+PSAwKSB7XG4gICAgICBjb25zdCBwaWNrZWRMYXllckluZGV4ID0gcGlja2VkQ29sb3JzW2Nsb3Nlc3RQaXhlbEluZGV4ICsgM10gLSAxO1xuICAgICAgY29uc3QgcGlja2VkQ29sb3IgPSBwaWNrZWRDb2xvcnMuc2xpY2UoY2xvc2VzdFBpeGVsSW5kZXgsIGNsb3Nlc3RQaXhlbEluZGV4ICsgNCk7XG4gICAgICBjb25zdCBwaWNrZWRMYXllciA9IGxheWVyc1twaWNrZWRMYXllckluZGV4XTtcblxuICAgICAgaWYgKHBpY2tlZExheWVyKSB7XG4gICAgICAgIGNvbnN0IHBpY2tlZE9iamVjdEluZGV4ID0gcGlja2VkTGF5ZXIuZGVjb2RlUGlja2luZ0NvbG9yKHBpY2tlZENvbG9yKTtcbiAgICAgICAgY29uc3QgZHkgPSBNYXRoLmZsb29yKGNsb3Nlc3RQaXhlbEluZGV4IC8gNCAvIHdpZHRoKTtcbiAgICAgICAgY29uc3QgZHggPSBjbG9zZXN0UGl4ZWxJbmRleCAvIDQgLSBkeSAqIHdpZHRoO1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgIHBpY2tlZENvbG9yLFxuICAgICAgICAgIHBpY2tlZExheWVyLFxuICAgICAgICAgIHBpY2tlZE9iamVjdEluZGV4LFxuICAgICAgICAgIHBpY2tlZFg6IHggKyBkeCxcbiAgICAgICAgICBwaWNrZWRZOiB5ICsgZHlcbiAgICAgICAgfTtcbiAgICAgIH1cblxuICAgICAgbG9nLmVycm9yKCdQaWNrZWQgbm9uLWV4aXN0ZW50IGxheWVyLiBJcyBwaWNraW5nIGJ1ZmZlciBjb3JydXB0PycpKCk7XG4gICAgfVxuICB9XG5cbiAgcmV0dXJuIE5PX1BJQ0tFRF9PQkpFQ1Q7XG59XG5leHBvcnQgZnVuY3Rpb24gZ2V0VW5pcXVlT2JqZWN0cyh7XG4gIHBpY2tlZENvbG9ycyxcbiAgbGF5ZXJzXG59KSB7XG4gIGNvbnN0IHVuaXF1ZUNvbG9ycyA9IG5ldyBNYXAoKTtcblxuICBpZiAocGlja2VkQ29sb3JzKSB7XG4gICAgZm9yIChsZXQgaSA9IDA7IGkgPCBwaWNrZWRDb2xvcnMubGVuZ3RoOyBpICs9IDQpIHtcbiAgICAgIGNvbnN0IHBpY2tlZExheWVySW5kZXggPSBwaWNrZWRDb2xvcnNbaSArIDNdIC0gMTtcblxuICAgICAgaWYgKHBpY2tlZExheWVySW5kZXggPj0gMCkge1xuICAgICAgICBjb25zdCBwaWNrZWRDb2xvciA9IHBpY2tlZENvbG9ycy5zbGljZShpLCBpICsgNCk7XG4gICAgICAgIGNvbnN0IGNvbG9yS2V5ID0gcGlja2VkQ29sb3Iuam9pbignLCcpO1xuXG4gICAgICAgIGlmICghdW5pcXVlQ29sb3JzLmhhcyhjb2xvcktleSkpIHtcbiAgICAgICAgICBjb25zdCBwaWNrZWRMYXllciA9IGxheWVyc1twaWNrZWRMYXllckluZGV4XTtcblxuICAgICAgICAgIGlmIChwaWNrZWRMYXllcikge1xuICAgICAgICAgICAgdW5pcXVlQ29sb3JzLnNldChjb2xvcktleSwge1xuICAgICAgICAgICAgICBwaWNrZWRDb2xvcixcbiAgICAgICAgICAgICAgcGlja2VkTGF5ZXIsXG4gICAgICAgICAgICAgIHBpY2tlZE9iamVjdEluZGV4OiBwaWNrZWRMYXllci5kZWNvZGVQaWNraW5nQ29sb3IocGlja2VkQ29sb3IpXG4gICAgICAgICAgICB9KTtcbiAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgbG9nLmVycm9yKCdQaWNrZWQgbm9uLWV4aXN0ZW50IGxheWVyLiBJcyBwaWNraW5nIGJ1ZmZlciBjb3JydXB0PycpKCk7XG4gICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICB9XG4gICAgfVxuICB9XG5cbiAgcmV0dXJuIEFycmF5LmZyb20odW5pcXVlQ29sb3JzLnZhbHVlcygpKTtcbn1cbi8vIyBzb3VyY2VNYXBwaW5nVVJMPXF1ZXJ5LW9iamVjdC5qcy5tYXAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lib/picking/query-object.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lib/resource/resource-manager.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lib/resource/resource-manager.js ***!
  \******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return ResourceManager; });\n/* harmony import */ var _resource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./resource */ \"./node_modules/@deck.gl/core/dist/esm/lib/resource/resource.js\");\n\nclass ResourceManager {\n  constructor({\n    gl,\n    protocol\n  }) {\n    this.protocol = protocol || 'resource://';\n    this._context = {\n      gl,\n      resourceManager: this\n    };\n    this._resources = {};\n    this._consumers = {};\n    this._pruneRequest = null;\n  }\n\n  contains(resourceId) {\n    if (resourceId.startsWith(this.protocol)) {\n      return true;\n    }\n\n    return resourceId in this._resources;\n  }\n\n  add({\n    resourceId,\n    data,\n    forceUpdate = false,\n    persistent = true\n  }) {\n    let res = this._resources[resourceId];\n\n    if (res) {\n      res.setData(data, forceUpdate);\n    } else {\n      res = new _resource__WEBPACK_IMPORTED_MODULE_0__[\"default\"](resourceId, data, this._context);\n      this._resources[resourceId] = res;\n    }\n\n    res.persistent = persistent;\n  }\n\n  remove(resourceId) {\n    const res = this._resources[resourceId];\n\n    if (res) {\n      res.delete();\n      delete this._resources[resourceId];\n    }\n  }\n\n  unsubscribe({\n    consumerId\n  }) {\n    const consumer = this._consumers[consumerId];\n\n    if (consumer) {\n      for (const requestId in consumer) {\n        const request = consumer[requestId];\n\n        if (request.resource) {\n          request.resource.unsubscribe(request);\n        }\n      }\n\n      delete this._consumers[consumerId];\n      this.prune();\n    }\n  }\n\n  subscribe({\n    resourceId,\n    onChange,\n    consumerId,\n    requestId = 'default'\n  }) {\n    const {\n      _resources: resources,\n      protocol\n    } = this;\n\n    if (resourceId.startsWith(protocol)) {\n      resourceId = resourceId.replace(protocol, '');\n\n      if (!resources[resourceId]) {\n        this.add({\n          resourceId,\n          data: null,\n          persistent: false\n        });\n      }\n    }\n\n    const res = resources[resourceId];\n\n    this._track(consumerId, requestId, res, onChange);\n\n    if (res) {\n      return res.getData();\n    }\n\n    return undefined;\n  }\n\n  prune() {\n    if (!this._pruneRequest) {\n      this._pruneRequest = setTimeout(() => this._prune(), 0);\n    }\n  }\n\n  finalize() {\n    for (const key in this._resources) {\n      this._resources[key].delete();\n    }\n  }\n\n  _track(consumerId, requestId, resource, onChange) {\n    const consumers = this._consumers;\n    const consumer = consumers[consumerId] = consumers[consumerId] || {};\n    const request = consumer[requestId] || {};\n\n    if (request.resource) {\n      request.resource.unsubscribe(request);\n      request.resource = null;\n      this.prune();\n    }\n\n    if (resource) {\n      consumer[requestId] = request;\n      request.onChange = onChange;\n      request.resource = resource;\n      resource.subscribe(request);\n    }\n  }\n\n  _prune() {\n    this._pruneRequest = null;\n\n    for (const key of Object.keys(this._resources)) {\n      const res = this._resources[key];\n\n      if (!res.persistent && !res.inUse()) {\n        res.delete();\n        delete this._resources[key];\n      }\n    }\n  }\n\n}\n//# sourceMappingURL=resource-manager.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS9saWIvcmVzb3VyY2UvcmVzb3VyY2UtbWFuYWdlci5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9AZGVjay5nbC9jb3JlL2Rpc3QvZXNtL2xpYi9yZXNvdXJjZS9yZXNvdXJjZS1tYW5hZ2VyLmpzP2I4ZmMiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlc291cmNlIGZyb20gJy4vcmVzb3VyY2UnO1xuZXhwb3J0IGRlZmF1bHQgY2xhc3MgUmVzb3VyY2VNYW5hZ2VyIHtcbiAgY29uc3RydWN0b3Ioe1xuICAgIGdsLFxuICAgIHByb3RvY29sXG4gIH0pIHtcbiAgICB0aGlzLnByb3RvY29sID0gcHJvdG9jb2wgfHwgJ3Jlc291cmNlOi8vJztcbiAgICB0aGlzLl9jb250ZXh0ID0ge1xuICAgICAgZ2wsXG4gICAgICByZXNvdXJjZU1hbmFnZXI6IHRoaXNcbiAgICB9O1xuICAgIHRoaXMuX3Jlc291cmNlcyA9IHt9O1xuICAgIHRoaXMuX2NvbnN1bWVycyA9IHt9O1xuICAgIHRoaXMuX3BydW5lUmVxdWVzdCA9IG51bGw7XG4gIH1cblxuICBjb250YWlucyhyZXNvdXJjZUlkKSB7XG4gICAgaWYgKHJlc291cmNlSWQuc3RhcnRzV2l0aCh0aGlzLnByb3RvY29sKSkge1xuICAgICAgcmV0dXJuIHRydWU7XG4gICAgfVxuXG4gICAgcmV0dXJuIHJlc291cmNlSWQgaW4gdGhpcy5fcmVzb3VyY2VzO1xuICB9XG5cbiAgYWRkKHtcbiAgICByZXNvdXJjZUlkLFxuICAgIGRhdGEsXG4gICAgZm9yY2VVcGRhdGUgPSBmYWxzZSxcbiAgICBwZXJzaXN0ZW50ID0gdHJ1ZVxuICB9KSB7XG4gICAgbGV0IHJlcyA9IHRoaXMuX3Jlc291cmNlc1tyZXNvdXJjZUlkXTtcblxuICAgIGlmIChyZXMpIHtcbiAgICAgIHJlcy5zZXREYXRhKGRhdGEsIGZvcmNlVXBkYXRlKTtcbiAgICB9IGVsc2Uge1xuICAgICAgcmVzID0gbmV3IFJlc291cmNlKHJlc291cmNlSWQsIGRhdGEsIHRoaXMuX2NvbnRleHQpO1xuICAgICAgdGhpcy5fcmVzb3VyY2VzW3Jlc291cmNlSWRdID0gcmVzO1xuICAgIH1cblxuICAgIHJlcy5wZXJzaXN0ZW50ID0gcGVyc2lzdGVudDtcbiAgfVxuXG4gIHJlbW92ZShyZXNvdXJjZUlkKSB7XG4gICAgY29uc3QgcmVzID0gdGhpcy5fcmVzb3VyY2VzW3Jlc291cmNlSWRdO1xuXG4gICAgaWYgKHJlcykge1xuICAgICAgcmVzLmRlbGV0ZSgpO1xuICAgICAgZGVsZXRlIHRoaXMuX3Jlc291cmNlc1tyZXNvdXJjZUlkXTtcbiAgICB9XG4gIH1cblxuICB1bnN1YnNjcmliZSh7XG4gICAgY29uc3VtZXJJZFxuICB9KSB7XG4gICAgY29uc3QgY29uc3VtZXIgPSB0aGlzLl9jb25zdW1lcnNbY29uc3VtZXJJZF07XG5cbiAgICBpZiAoY29uc3VtZXIpIHtcbiAgICAgIGZvciAoY29uc3QgcmVxdWVzdElkIGluIGNvbnN1bWVyKSB7XG4gICAgICAgIGNvbnN0IHJlcXVlc3QgPSBjb25zdW1lcltyZXF1ZXN0SWRdO1xuXG4gICAgICAgIGlmIChyZXF1ZXN0LnJlc291cmNlKSB7XG4gICAgICAgICAgcmVxdWVzdC5yZXNvdXJjZS51bnN1YnNjcmliZShyZXF1ZXN0KTtcbiAgICAgICAgfVxuICAgICAgfVxuXG4gICAgICBkZWxldGUgdGhpcy5fY29uc3VtZXJzW2NvbnN1bWVySWRdO1xuICAgICAgdGhpcy5wcnVuZSgpO1xuICAgIH1cbiAgfVxuXG4gIHN1YnNjcmliZSh7XG4gICAgcmVzb3VyY2VJZCxcbiAgICBvbkNoYW5nZSxcbiAgICBjb25zdW1lcklkLFxuICAgIHJlcXVlc3RJZCA9ICdkZWZhdWx0J1xuICB9KSB7XG4gICAgY29uc3Qge1xuICAgICAgX3Jlc291cmNlczogcmVzb3VyY2VzLFxuICAgICAgcHJvdG9jb2xcbiAgICB9ID0gdGhpcztcblxuICAgIGlmIChyZXNvdXJjZUlkLnN0YXJ0c1dpdGgocHJvdG9jb2wpKSB7XG4gICAgICByZXNvdXJjZUlkID0gcmVzb3VyY2VJZC5yZXBsYWNlKHByb3RvY29sLCAnJyk7XG5cbiAgICAgIGlmICghcmVzb3VyY2VzW3Jlc291cmNlSWRdKSB7XG4gICAgICAgIHRoaXMuYWRkKHtcbiAgICAgICAgICByZXNvdXJjZUlkLFxuICAgICAgICAgIGRhdGE6IG51bGwsXG4gICAgICAgICAgcGVyc2lzdGVudDogZmFsc2VcbiAgICAgICAgfSk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgY29uc3QgcmVzID0gcmVzb3VyY2VzW3Jlc291cmNlSWRdO1xuXG4gICAgdGhpcy5fdHJhY2soY29uc3VtZXJJZCwgcmVxdWVzdElkLCByZXMsIG9uQ2hhbmdlKTtcblxuICAgIGlmIChyZXMpIHtcbiAgICAgIHJldHVybiByZXMuZ2V0RGF0YSgpO1xuICAgIH1cblxuICAgIHJldHVybiB1bmRlZmluZWQ7XG4gIH1cblxuICBwcnVuZSgpIHtcbiAgICBpZiAoIXRoaXMuX3BydW5lUmVxdWVzdCkge1xuICAgICAgdGhpcy5fcHJ1bmVSZXF1ZXN0ID0gc2V0VGltZW91dCgoKSA9PiB0aGlzLl9wcnVuZSgpLCAwKTtcbiAgICB9XG4gIH1cblxuICBmaW5hbGl6ZSgpIHtcbiAgICBmb3IgKGNvbnN0IGtleSBpbiB0aGlzLl9yZXNvdXJjZXMpIHtcbiAgICAgIHRoaXMuX3Jlc291cmNlc1trZXldLmRlbGV0ZSgpO1xuICAgIH1cbiAgfVxuXG4gIF90cmFjayhjb25zdW1lcklkLCByZXF1ZXN0SWQsIHJlc291cmNlLCBvbkNoYW5nZSkge1xuICAgIGNvbnN0IGNvbnN1bWVycyA9IHRoaXMuX2NvbnN1bWVycztcbiAgICBjb25zdCBjb25zdW1lciA9IGNvbnN1bWVyc1tjb25zdW1lcklkXSA9IGNvbnN1bWVyc1tjb25zdW1lcklkXSB8fCB7fTtcbiAgICBjb25zdCByZXF1ZXN0ID0gY29uc3VtZXJbcmVxdWVzdElkXSB8fCB7fTtcblxuICAgIGlmIChyZXF1ZXN0LnJlc291cmNlKSB7XG4gICAgICByZXF1ZXN0LnJlc291cmNlLnVuc3Vic2NyaWJlKHJlcXVlc3QpO1xuICAgICAgcmVxdWVzdC5yZXNvdXJjZSA9IG51bGw7XG4gICAgICB0aGlzLnBydW5lKCk7XG4gICAgfVxuXG4gICAgaWYgKHJlc291cmNlKSB7XG4gICAgICBjb25zdW1lcltyZXF1ZXN0SWRdID0gcmVxdWVzdDtcbiAgICAgIHJlcXVlc3Qub25DaGFuZ2UgPSBvbkNoYW5nZTtcbiAgICAgIHJlcXVlc3QucmVzb3VyY2UgPSByZXNvdXJjZTtcbiAgICAgIHJlc291cmNlLnN1YnNjcmliZShyZXF1ZXN0KTtcbiAgICB9XG4gIH1cblxuICBfcHJ1bmUoKSB7XG4gICAgdGhpcy5fcHJ1bmVSZXF1ZXN0ID0gbnVsbDtcblxuICAgIGZvciAoY29uc3Qga2V5IG9mIE9iamVjdC5rZXlzKHRoaXMuX3Jlc291cmNlcykpIHtcbiAgICAgIGNvbnN0IHJlcyA9IHRoaXMuX3Jlc291cmNlc1trZXldO1xuXG4gICAgICBpZiAoIXJlcy5wZXJzaXN0ZW50ICYmICFyZXMuaW5Vc2UoKSkge1xuICAgICAgICByZXMuZGVsZXRlKCk7XG4gICAgICAgIGRlbGV0ZSB0aGlzLl9yZXNvdXJjZXNba2V5XTtcbiAgICAgIH1cbiAgICB9XG4gIH1cblxufVxuLy8jIHNvdXJjZU1hcHBpbmdVUkw9cmVzb3VyY2UtbWFuYWdlci5qcy5tYXAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lib/resource/resource-manager.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lib/resource/resource.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lib/resource/resource.js ***!
  \**********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return Resource; });\n/* harmony import */ var _loaders_gl_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @loaders.gl/core */ \"./node_modules/@loaders.gl/core/dist/esm/lib/api/load.js\");\n\nclass Resource {\n  constructor(id, data, context) {\n    this.id = id;\n    this.context = context;\n    this._loadCount = 0;\n    this._subscribers = new Set();\n    this.setData(data);\n  }\n\n  subscribe(consumer) {\n    this._subscribers.add(consumer);\n  }\n\n  unsubscribe(consumer) {\n    this._subscribers.delete(consumer);\n  }\n\n  inUse() {\n    return this._subscribers.size > 0;\n  }\n\n  delete() {}\n\n  getData() {\n    return this.isLoaded ? this._error ? Promise.reject(this._error) : this._content : this._loader.then(() => this.getData());\n  }\n\n  setData(data, forceUpdate) {\n    if (data === this._data && !forceUpdate) {\n      return;\n    }\n\n    this._data = data;\n    const loadCount = ++this._loadCount;\n    let loader = data;\n\n    if (typeof data === 'string') {\n      loader = Object(_loaders_gl_core__WEBPACK_IMPORTED_MODULE_0__[\"load\"])(data);\n    }\n\n    if (loader instanceof Promise) {\n      this.isLoaded = false;\n      this._loader = loader.then(result => {\n        if (this._loadCount === loadCount) {\n          this.isLoaded = true;\n          this._error = null;\n          this._content = result;\n        }\n      }).catch(error => {\n        if (this._loadCount === loadCount) {\n          this.isLoaded = true;\n          this._error = error || true;\n        }\n      });\n    } else {\n      this.isLoaded = true;\n      this._error = null;\n      this._content = data;\n    }\n\n    for (const subscriber of this._subscribers) {\n      subscriber.onChange(this.getData());\n    }\n  }\n\n}\n//# sourceMappingURL=resource.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lib/resource/resource.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lib/tooltip.js":
/*!************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lib/tooltip.js ***!
  \************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return Tooltip; });\nconst defaultStyle = {\n  zIndex: 1,\n  position: 'absolute',\n  pointerEvents: 'none',\n  color: '#a0a7b4',\n  backgroundColor: '#29323c',\n  padding: '10px',\n  top: 0,\n  left: 0,\n  display: 'none'\n};\nclass Tooltip {\n  constructor(canvas) {\n    const canvasParent = canvas.parentElement;\n\n    if (canvasParent) {\n      this.el = document.createElement('div');\n      this.el.className = 'deck-tooltip';\n      Object.assign(this.el.style, defaultStyle);\n      canvasParent.appendChild(this.el);\n    }\n\n    this.isVisible = false;\n  }\n\n  setTooltip(displayInfo, x, y) {\n    const el = this.el;\n\n    if (typeof displayInfo === 'string') {\n      el.innerText = displayInfo;\n    } else if (!displayInfo) {\n      this.isVisible = false;\n      el.style.display = 'none';\n      return;\n    } else {\n      if ('text' in displayInfo) {\n        el.innerText = displayInfo.text;\n      }\n\n      if ('html' in displayInfo) {\n        el.innerHTML = displayInfo.html;\n      }\n\n      if ('className' in displayInfo) {\n        el.className = displayInfo.className;\n      }\n\n      Object.assign(el.style, displayInfo.style);\n    }\n\n    this.isVisible = true;\n    el.style.display = 'block';\n    el.style.transform = \"translate(\".concat(x, \"px, \").concat(y, \"px)\");\n  }\n\n  remove() {\n    if (this.el) {\n      this.el.remove();\n    }\n  }\n\n}\n//# sourceMappingURL=tooltip.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lib/tooltip.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lib/uniform-transition-manager.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lib/uniform-transition-manager.js ***!
  \*******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return UniformTransitionManager; });\n/* harmony import */ var _attribute_attribute_transition_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./attribute/attribute-transition-utils */ \"./node_modules/@deck.gl/core/dist/esm/lib/attribute/attribute-transition-utils.js\");\n/* harmony import */ var _transitions_cpu_interpolation_transition__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../transitions/cpu-interpolation-transition */ \"./node_modules/@deck.gl/core/dist/esm/transitions/cpu-interpolation-transition.js\");\n/* harmony import */ var _transitions_cpu_spring_transition__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../transitions/cpu-spring-transition */ \"./node_modules/@deck.gl/core/dist/esm/transitions/cpu-spring-transition.js\");\n/* harmony import */ var _utils_log__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/log */ \"./node_modules/@deck.gl/core/dist/esm/utils/log.js\");\n\n\n\n\nconst TRANSITION_TYPES = {\n  interpolation: _transitions_cpu_interpolation_transition__WEBPACK_IMPORTED_MODULE_1__[\"default\"],\n  spring: _transitions_cpu_spring_transition__WEBPACK_IMPORTED_MODULE_2__[\"default\"]\n};\nclass UniformTransitionManager {\n  constructor(timeline) {\n    this.transitions = new Map();\n    this.timeline = timeline;\n  }\n\n  get active() {\n    return this.transitions.size > 0;\n  }\n\n  add(key, fromValue, toValue, settings) {\n    const {\n      transitions\n    } = this;\n\n    if (transitions.has(key)) {\n      const transition = transitions.get(key);\n      const {\n        value = transition.settings.fromValue\n      } = transition;\n      fromValue = value;\n      this.remove(key);\n    }\n\n    settings = Object(_attribute_attribute_transition_utils__WEBPACK_IMPORTED_MODULE_0__[\"normalizeTransitionSettings\"])(settings);\n\n    if (!settings) {\n      return;\n    }\n\n    const TransitionType = TRANSITION_TYPES[settings.type];\n\n    if (!TransitionType) {\n      _utils_log__WEBPACK_IMPORTED_MODULE_3__[\"default\"].error(\"unsupported transition type '\".concat(settings.type, \"'\"))();\n      return;\n    }\n\n    const transition = new TransitionType(this.timeline);\n    transition.start({ ...settings,\n      fromValue,\n      toValue\n    });\n    transitions.set(key, transition);\n  }\n\n  remove(key) {\n    const {\n      transitions\n    } = this;\n\n    if (transitions.has(key)) {\n      transitions.get(key).cancel();\n      transitions.delete(key);\n    }\n  }\n\n  update() {\n    const propsInTransition = {};\n\n    for (const [key, transition] of this.transitions) {\n      transition.update();\n      propsInTransition[key] = transition.value;\n\n      if (!transition.inProgress) {\n        this.remove(key);\n      }\n    }\n\n    return propsInTransition;\n  }\n\n  clear() {\n    for (const key of this.transitions.keys()) {\n      this.remove(key);\n    }\n  }\n\n}\n//# sourceMappingURL=uniform-transition-manager.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS9saWIvdW5pZm9ybS10cmFuc2l0aW9uLW1hbmFnZXIuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS9saWIvdW5pZm9ybS10cmFuc2l0aW9uLW1hbmFnZXIuanM/MzI4MiJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBub3JtYWxpemVUcmFuc2l0aW9uU2V0dGluZ3MgfSBmcm9tICcuL2F0dHJpYnV0ZS9hdHRyaWJ1dGUtdHJhbnNpdGlvbi11dGlscyc7XG5pbXBvcnQgQ1BVSW50ZXJwb2xhdGlvblRyYW5zaXRpb24gZnJvbSAnLi4vdHJhbnNpdGlvbnMvY3B1LWludGVycG9sYXRpb24tdHJhbnNpdGlvbic7XG5pbXBvcnQgQ1BVU3ByaW5nVHJhbnNpdGlvbiBmcm9tICcuLi90cmFuc2l0aW9ucy9jcHUtc3ByaW5nLXRyYW5zaXRpb24nO1xuaW1wb3J0IGxvZyBmcm9tICcuLi91dGlscy9sb2cnO1xuY29uc3QgVFJBTlNJVElPTl9UWVBFUyA9IHtcbiAgaW50ZXJwb2xhdGlvbjogQ1BVSW50ZXJwb2xhdGlvblRyYW5zaXRpb24sXG4gIHNwcmluZzogQ1BVU3ByaW5nVHJhbnNpdGlvblxufTtcbmV4cG9ydCBkZWZhdWx0IGNsYXNzIFVuaWZvcm1UcmFuc2l0aW9uTWFuYWdlciB7XG4gIGNvbnN0cnVjdG9yKHRpbWVsaW5lKSB7XG4gICAgdGhpcy50cmFuc2l0aW9ucyA9IG5ldyBNYXAoKTtcbiAgICB0aGlzLnRpbWVsaW5lID0gdGltZWxpbmU7XG4gIH1cblxuICBnZXQgYWN0aXZlKCkge1xuICAgIHJldHVybiB0aGlzLnRyYW5zaXRpb25zLnNpemUgPiAwO1xuICB9XG5cbiAgYWRkKGtleSwgZnJvbVZhbHVlLCB0b1ZhbHVlLCBzZXR0aW5ncykge1xuICAgIGNvbnN0IHtcbiAgICAgIHRyYW5zaXRpb25zXG4gICAgfSA9IHRoaXM7XG5cbiAgICBpZiAodHJhbnNpdGlvbnMuaGFzKGtleSkpIHtcbiAgICAgIGNvbnN0IHRyYW5zaXRpb24gPSB0cmFuc2l0aW9ucy5nZXQoa2V5KTtcbiAgICAgIGNvbnN0IHtcbiAgICAgICAgdmFsdWUgPSB0cmFuc2l0aW9uLnNldHRpbmdzLmZyb21WYWx1ZVxuICAgICAgfSA9IHRyYW5zaXRpb247XG4gICAgICBmcm9tVmFsdWUgPSB2YWx1ZTtcbiAgICAgIHRoaXMucmVtb3ZlKGtleSk7XG4gICAgfVxuXG4gICAgc2V0dGluZ3MgPSBub3JtYWxpemVUcmFuc2l0aW9uU2V0dGluZ3Moc2V0dGluZ3MpO1xuXG4gICAgaWYgKCFzZXR0aW5ncykge1xuICAgICAgcmV0dXJuO1xuICAgIH1cblxuICAgIGNvbnN0IFRyYW5zaXRpb25UeXBlID0gVFJBTlNJVElPTl9UWVBFU1tzZXR0aW5ncy50eXBlXTtcblxuICAgIGlmICghVHJhbnNpdGlvblR5cGUpIHtcbiAgICAgIGxvZy5lcnJvcihcInVuc3VwcG9ydGVkIHRyYW5zaXRpb24gdHlwZSAnXCIuY29uY2F0KHNldHRpbmdzLnR5cGUsIFwiJ1wiKSkoKTtcbiAgICAgIHJldHVybjtcbiAgICB9XG5cbiAgICBjb25zdCB0cmFuc2l0aW9uID0gbmV3IFRyYW5zaXRpb25UeXBlKHRoaXMudGltZWxpbmUpO1xuICAgIHRyYW5zaXRpb24uc3RhcnQoeyAuLi5zZXR0aW5ncyxcbiAgICAgIGZyb21WYWx1ZSxcbiAgICAgIHRvVmFsdWVcbiAgICB9KTtcbiAgICB0cmFuc2l0aW9ucy5zZXQoa2V5LCB0cmFuc2l0aW9uKTtcbiAgfVxuXG4gIHJlbW92ZShrZXkpIHtcbiAgICBjb25zdCB7XG4gICAgICB0cmFuc2l0aW9uc1xuICAgIH0gPSB0aGlzO1xuXG4gICAgaWYgKHRyYW5zaXRpb25zLmhhcyhrZXkpKSB7XG4gICAgICB0cmFuc2l0aW9ucy5nZXQoa2V5KS5jYW5jZWwoKTtcbiAgICAgIHRyYW5zaXRpb25zLmRlbGV0ZShrZXkpO1xuICAgIH1cbiAgfVxuXG4gIHVwZGF0ZSgpIHtcbiAgICBjb25zdCBwcm9wc0luVHJhbnNpdGlvbiA9IHt9O1xuXG4gICAgZm9yIChjb25zdCBba2V5LCB0cmFuc2l0aW9uXSBvZiB0aGlzLnRyYW5zaXRpb25zKSB7XG4gICAgICB0cmFuc2l0aW9uLnVwZGF0ZSgpO1xuICAgICAgcHJvcHNJblRyYW5zaXRpb25ba2V5XSA9IHRyYW5zaXRpb24udmFsdWU7XG5cbiAgICAgIGlmICghdHJhbnNpdGlvbi5pblByb2dyZXNzKSB7XG4gICAgICAgIHRoaXMucmVtb3ZlKGtleSk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgcmV0dXJuIHByb3BzSW5UcmFuc2l0aW9uO1xuICB9XG5cbiAgY2xlYXIoKSB7XG4gICAgZm9yIChjb25zdCBrZXkgb2YgdGhpcy50cmFuc2l0aW9ucy5rZXlzKCkpIHtcbiAgICAgIHRoaXMucmVtb3ZlKGtleSk7XG4gICAgfVxuICB9XG5cbn1cbi8vIyBzb3VyY2VNYXBwaW5nVVJMPXVuaWZvcm0tdHJhbnNpdGlvbi1tYW5hZ2VyLmpzLm1hcCJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lib/uniform-transition-manager.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lib/view-manager.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lib/view-manager.js ***!
  \*****************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return ViewManager; });\n/* harmony import */ var _utils_deep_equal__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/deep-equal */ \"./node_modules/@deck.gl/core/dist/esm/utils/deep-equal.js\");\n/* harmony import */ var _utils_log__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/log */ \"./node_modules/@deck.gl/core/dist/esm/utils/log.js\");\n/* harmony import */ var _utils_flatten__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/flatten */ \"./node_modules/@deck.gl/core/dist/esm/utils/flatten.js\");\n\n\n\nclass ViewManager {\n  constructor(props = {}) {\n    this.views = [];\n    this.width = 100;\n    this.height = 100;\n    this.viewState = {};\n    this.controllers = {};\n    this.timeline = props.timeline;\n    this._viewports = [];\n    this._viewportMap = {};\n    this._isUpdating = false;\n    this._needsRedraw = 'Initial render';\n    this._needsUpdate = true;\n    this._eventManager = props.eventManager;\n    this._eventCallbacks = {\n      onViewStateChange: props.onViewStateChange,\n      onInteractionStateChange: props.onInteractionStateChange\n    };\n    Object.seal(this);\n    this.setProps(props);\n  }\n\n  finalize() {\n    for (const key in this.controllers) {\n      if (this.controllers[key]) {\n        this.controllers[key].finalize();\n      }\n    }\n\n    this.controllers = {};\n  }\n\n  needsRedraw(opts = {\n    clearRedrawFlags: false\n  }) {\n    const redraw = this._needsRedraw;\n\n    if (opts.clearRedrawFlags) {\n      this._needsRedraw = false;\n    }\n\n    return redraw;\n  }\n\n  setNeedsUpdate(reason) {\n    this._needsUpdate = this._needsUpdate || reason;\n    this._needsRedraw = this._needsRedraw || reason;\n  }\n\n  updateViewStates() {\n    for (const viewId in this.controllers) {\n      const controller = this.controllers[viewId];\n\n      if (controller) {\n        controller.updateTransition();\n      }\n    }\n  }\n\n  getViewports(rect) {\n    if (rect) {\n      return this._viewports.filter(viewport => viewport.containsPixel(rect));\n    }\n\n    return this._viewports;\n  }\n\n  getViews() {\n    const viewMap = {};\n    this.views.forEach(view => {\n      viewMap[view.id] = view;\n    });\n    return viewMap;\n  }\n\n  getView(viewOrViewId) {\n    return typeof viewOrViewId === 'string' ? this.views.find(view => view.id === viewOrViewId) : viewOrViewId;\n  }\n\n  getViewState(viewId) {\n    const view = this.getView(viewId);\n    const viewState = view && this.viewState[view.getViewStateId()] || this.viewState;\n    return view ? view.filterViewState(viewState) : viewState;\n  }\n\n  getViewport(viewId) {\n    return this._viewportMap[viewId];\n  }\n\n  unproject(xyz, opts) {\n    const viewports = this.getViewports();\n    const pixel = {\n      x: xyz[0],\n      y: xyz[1]\n    };\n\n    for (let i = viewports.length - 1; i >= 0; --i) {\n      const viewport = viewports[i];\n\n      if (viewport.containsPixel(pixel)) {\n        const p = xyz.slice();\n        p[0] -= viewport.x;\n        p[1] -= viewport.y;\n        return viewport.unproject(p, opts);\n      }\n    }\n\n    return null;\n  }\n\n  setProps(props) {\n    if ('views' in props) {\n      this._setViews(props.views);\n    }\n\n    if ('viewState' in props) {\n      this._setViewState(props.viewState);\n    }\n\n    if ('width' in props || 'height' in props) {\n      this._setSize(props.width, props.height);\n    }\n\n    if (!this._isUpdating) {\n      this._update();\n    }\n  }\n\n  _update() {\n    this._isUpdating = true;\n\n    if (this._needsUpdate) {\n      this._needsUpdate = false;\n\n      this._rebuildViewports();\n    }\n\n    if (this._needsUpdate) {\n      this._needsUpdate = false;\n\n      this._rebuildViewports();\n    }\n\n    this._isUpdating = false;\n  }\n\n  _setSize(width, height) {\n    if (width !== this.width || height !== this.height) {\n      this.width = width;\n      this.height = height;\n      this.setNeedsUpdate('Size changed');\n    }\n  }\n\n  _setViews(views) {\n    views = Object(_utils_flatten__WEBPACK_IMPORTED_MODULE_2__[\"flatten\"])(views, Boolean);\n\n    const viewsChanged = this._diffViews(views, this.views);\n\n    if (viewsChanged) {\n      this.setNeedsUpdate('views changed');\n    }\n\n    this.views = views;\n  }\n\n  _setViewState(viewState) {\n    if (viewState) {\n      const viewStateChanged = !Object(_utils_deep_equal__WEBPACK_IMPORTED_MODULE_0__[\"deepEqual\"])(viewState, this.viewState);\n\n      if (viewStateChanged) {\n        this.setNeedsUpdate('viewState changed');\n      }\n\n      this.viewState = viewState;\n    } else {\n      _utils_log__WEBPACK_IMPORTED_MODULE_1__[\"default\"].warn('missing `viewState` or `initialViewState`')();\n    }\n  }\n\n  _onViewStateChange(viewId, event) {\n    event.viewId = viewId;\n\n    if (this._eventCallbacks.onViewStateChange) {\n      this._eventCallbacks.onViewStateChange(event);\n    }\n  }\n\n  _createController(view, props) {\n    const Controller = props.type;\n    const controller = new Controller({\n      timeline: this.timeline,\n      eventManager: this._eventManager,\n      onViewStateChange: this._onViewStateChange.bind(this, props.id),\n      onStateChange: this._eventCallbacks.onInteractionStateChange,\n      makeViewport: viewState => view._getViewport(viewState, {\n        width: viewState.width,\n        height: viewState.height\n      }),\n      ...props\n    });\n    return controller;\n  }\n\n  _updateController(view, viewState, viewport, controller) {\n    let controllerProps = view.controller;\n\n    if (controllerProps) {\n      controllerProps = { ...viewState,\n        ...view.props,\n        ...controllerProps,\n        id: view.id,\n        x: viewport.x,\n        y: viewport.y,\n        width: viewport.width,\n        height: viewport.height\n      };\n\n      if (controller) {\n        controller.setProps(controllerProps);\n      } else {\n        controller = this._createController(view, controllerProps);\n      }\n\n      return controller;\n    }\n\n    return null;\n  }\n\n  _rebuildViewports() {\n    const {\n      width,\n      height,\n      views\n    } = this;\n    const oldControllers = this.controllers;\n    this._viewports = [];\n    this.controllers = {};\n    let invalidateControllers = false;\n\n    for (let i = views.length; i--;) {\n      const view = views[i];\n      const viewState = this.getViewState(view);\n      const viewport = view.makeViewport({\n        width,\n        height,\n        viewState\n      });\n      let oldController = oldControllers[view.id];\n\n      if (view.controller && !oldController) {\n        invalidateControllers = true;\n      }\n\n      if ((invalidateControllers || !view.controller) && oldController) {\n        oldController.finalize();\n        oldController = null;\n      }\n\n      this.controllers[view.id] = this._updateController(view, viewState, viewport, oldController);\n\n      this._viewports.unshift(viewport);\n    }\n\n    for (const id in oldControllers) {\n      if (oldControllers[id] && !this.controllers[id]) {\n        oldControllers[id].finalize();\n      }\n    }\n\n    this._buildViewportMap();\n  }\n\n  _buildViewportMap() {\n    this._viewportMap = {};\n\n    this._viewports.forEach(viewport => {\n      if (viewport.id) {\n        this._viewportMap[viewport.id] = this._viewportMap[viewport.id] || viewport;\n      }\n    });\n  }\n\n  _diffViews(newViews, oldViews) {\n    if (newViews.length !== oldViews.length) {\n      return true;\n    }\n\n    return newViews.some((_, i) => !newViews[i].equals(oldViews[i]));\n  }\n\n}\n//# sourceMappingURL=view-manager.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS9saWIvdmlldy1tYW5hZ2VyLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0BkZWNrLmdsL2NvcmUvZGlzdC9lc20vbGliL3ZpZXctbWFuYWdlci5qcz82ZDVlIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGRlZXBFcXVhbCB9IGZyb20gJy4uL3V0aWxzL2RlZXAtZXF1YWwnO1xuaW1wb3J0IGxvZyBmcm9tICcuLi91dGlscy9sb2cnO1xuaW1wb3J0IHsgZmxhdHRlbiB9IGZyb20gJy4uL3V0aWxzL2ZsYXR0ZW4nO1xuZXhwb3J0IGRlZmF1bHQgY2xhc3MgVmlld01hbmFnZXIge1xuICBjb25zdHJ1Y3Rvcihwcm9wcyA9IHt9KSB7XG4gICAgdGhpcy52aWV3cyA9IFtdO1xuICAgIHRoaXMud2lkdGggPSAxMDA7XG4gICAgdGhpcy5oZWlnaHQgPSAxMDA7XG4gICAgdGhpcy52aWV3U3RhdGUgPSB7fTtcbiAgICB0aGlzLmNvbnRyb2xsZXJzID0ge307XG4gICAgdGhpcy50aW1lbGluZSA9IHByb3BzLnRpbWVsaW5lO1xuICAgIHRoaXMuX3ZpZXdwb3J0cyA9IFtdO1xuICAgIHRoaXMuX3ZpZXdwb3J0TWFwID0ge307XG4gICAgdGhpcy5faXNVcGRhdGluZyA9IGZhbHNlO1xuICAgIHRoaXMuX25lZWRzUmVkcmF3ID0gJ0luaXRpYWwgcmVuZGVyJztcbiAgICB0aGlzLl9uZWVkc1VwZGF0ZSA9IHRydWU7XG4gICAgdGhpcy5fZXZlbnRNYW5hZ2VyID0gcHJvcHMuZXZlbnRNYW5hZ2VyO1xuICAgIHRoaXMuX2V2ZW50Q2FsbGJhY2tzID0ge1xuICAgICAgb25WaWV3U3RhdGVDaGFuZ2U6IHByb3BzLm9uVmlld1N0YXRlQ2hhbmdlLFxuICAgICAgb25JbnRlcmFjdGlvblN0YXRlQ2hhbmdlOiBwcm9wcy5vbkludGVyYWN0aW9uU3RhdGVDaGFuZ2VcbiAgICB9O1xuICAgIE9iamVjdC5zZWFsKHRoaXMpO1xuICAgIHRoaXMuc2V0UHJvcHMocHJvcHMpO1xuICB9XG5cbiAgZmluYWxpemUoKSB7XG4gICAgZm9yIChjb25zdCBrZXkgaW4gdGhpcy5jb250cm9sbGVycykge1xuICAgICAgaWYgKHRoaXMuY29udHJvbGxlcnNba2V5XSkge1xuICAgICAgICB0aGlzLmNvbnRyb2xsZXJzW2tleV0uZmluYWxpemUoKTtcbiAgICAgIH1cbiAgICB9XG5cbiAgICB0aGlzLmNvbnRyb2xsZXJzID0ge307XG4gIH1cblxuICBuZWVkc1JlZHJhdyhvcHRzID0ge1xuICAgIGNsZWFyUmVkcmF3RmxhZ3M6IGZhbHNlXG4gIH0pIHtcbiAgICBjb25zdCByZWRyYXcgPSB0aGlzLl9uZWVkc1JlZHJhdztcblxuICAgIGlmIChvcHRzLmNsZWFyUmVkcmF3RmxhZ3MpIHtcbiAgICAgIHRoaXMuX25lZWRzUmVkcmF3ID0gZmFsc2U7XG4gICAgfVxuXG4gICAgcmV0dXJuIHJlZHJhdztcbiAgfVxuXG4gIHNldE5lZWRzVXBkYXRlKHJlYXNvbikge1xuICAgIHRoaXMuX25lZWRzVXBkYXRlID0gdGhpcy5fbmVlZHNVcGRhdGUgfHwgcmVhc29uO1xuICAgIHRoaXMuX25lZWRzUmVkcmF3ID0gdGhpcy5fbmVlZHNSZWRyYXcgfHwgcmVhc29uO1xuICB9XG5cbiAgdXBkYXRlVmlld1N0YXRlcygpIHtcbiAgICBmb3IgKGNvbnN0IHZpZXdJZCBpbiB0aGlzLmNvbnRyb2xsZXJzKSB7XG4gICAgICBjb25zdCBjb250cm9sbGVyID0gdGhpcy5jb250cm9sbGVyc1t2aWV3SWRdO1xuXG4gICAgICBpZiAoY29udHJvbGxlcikge1xuICAgICAgICBjb250cm9sbGVyLnVwZGF0ZVRyYW5zaXRpb24oKTtcbiAgICAgIH1cbiAgICB9XG4gIH1cblxuICBnZXRWaWV3cG9ydHMocmVjdCkge1xuICAgIGlmIChyZWN0KSB7XG4gICAgICByZXR1cm4gdGhpcy5fdmlld3BvcnRzLmZpbHRlcih2aWV3cG9ydCA9PiB2aWV3cG9ydC5jb250YWluc1BpeGVsKHJlY3QpKTtcbiAgICB9XG5cbiAgICByZXR1cm4gdGhpcy5fdmlld3BvcnRzO1xuICB9XG5cbiAgZ2V0Vmlld3MoKSB7XG4gICAgY29uc3Qgdmlld01hcCA9IHt9O1xuICAgIHRoaXMudmlld3MuZm9yRWFjaCh2aWV3ID0+IHtcbiAgICAgIHZpZXdNYXBbdmlldy5pZF0gPSB2aWV3O1xuICAgIH0pO1xuICAgIHJldHVybiB2aWV3TWFwO1xuICB9XG5cbiAgZ2V0Vmlldyh2aWV3T3JWaWV3SWQpIHtcbiAgICByZXR1cm4gdHlwZW9mIHZpZXdPclZpZXdJZCA9PT0gJ3N0cmluZycgPyB0aGlzLnZpZXdzLmZpbmQodmlldyA9PiB2aWV3LmlkID09PSB2aWV3T3JWaWV3SWQpIDogdmlld09yVmlld0lkO1xuICB9XG5cbiAgZ2V0Vmlld1N0YXRlKHZpZXdJZCkge1xuICAgIGNvbnN0IHZpZXcgPSB0aGlzLmdldFZpZXcodmlld0lkKTtcbiAgICBjb25zdCB2aWV3U3RhdGUgPSB2aWV3ICYmIHRoaXMudmlld1N0YXRlW3ZpZXcuZ2V0Vmlld1N0YXRlSWQoKV0gfHwgdGhpcy52aWV3U3RhdGU7XG4gICAgcmV0dXJuIHZpZXcgPyB2aWV3LmZpbHRlclZpZXdTdGF0ZSh2aWV3U3RhdGUpIDogdmlld1N0YXRlO1xuICB9XG5cbiAgZ2V0Vmlld3BvcnQodmlld0lkKSB7XG4gICAgcmV0dXJuIHRoaXMuX3ZpZXdwb3J0TWFwW3ZpZXdJZF07XG4gIH1cblxuICB1bnByb2plY3QoeHl6LCBvcHRzKSB7XG4gICAgY29uc3Qgdmlld3BvcnRzID0gdGhpcy5nZXRWaWV3cG9ydHMoKTtcbiAgICBjb25zdCBwaXhlbCA9IHtcbiAgICAgIHg6IHh5elswXSxcbiAgICAgIHk6IHh5elsxXVxuICAgIH07XG5cbiAgICBmb3IgKGxldCBpID0gdmlld3BvcnRzLmxlbmd0aCAtIDE7IGkgPj0gMDsgLS1pKSB7XG4gICAgICBjb25zdCB2aWV3cG9ydCA9IHZpZXdwb3J0c1tpXTtcblxuICAgICAgaWYgKHZpZXdwb3J0LmNvbnRhaW5zUGl4ZWwocGl4ZWwpKSB7XG4gICAgICAgIGNvbnN0IHAgPSB4eXouc2xpY2UoKTtcbiAgICAgICAgcFswXSAtPSB2aWV3cG9ydC54O1xuICAgICAgICBwWzFdIC09IHZpZXdwb3J0Lnk7XG4gICAgICAgIHJldHVybiB2aWV3cG9ydC51bnByb2plY3QocCwgb3B0cyk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgcmV0dXJuIG51bGw7XG4gIH1cblxuICBzZXRQcm9wcyhwcm9wcykge1xuICAgIGlmICgndmlld3MnIGluIHByb3BzKSB7XG4gICAgICB0aGlzLl9zZXRWaWV3cyhwcm9wcy52aWV3cyk7XG4gICAgfVxuXG4gICAgaWYgKCd2aWV3U3RhdGUnIGluIHByb3BzKSB7XG4gICAgICB0aGlzLl9zZXRWaWV3U3RhdGUocHJvcHMudmlld1N0YXRlKTtcbiAgICB9XG5cbiAgICBpZiAoJ3dpZHRoJyBpbiBwcm9wcyB8fCAnaGVpZ2h0JyBpbiBwcm9wcykge1xuICAgICAgdGhpcy5fc2V0U2l6ZShwcm9wcy53aWR0aCwgcHJvcHMuaGVpZ2h0KTtcbiAgICB9XG5cbiAgICBpZiAoIXRoaXMuX2lzVXBkYXRpbmcpIHtcbiAgICAgIHRoaXMuX3VwZGF0ZSgpO1xuICAgIH1cbiAgfVxuXG4gIF91cGRhdGUoKSB7XG4gICAgdGhpcy5faXNVcGRhdGluZyA9IHRydWU7XG5cbiAgICBpZiAodGhpcy5fbmVlZHNVcGRhdGUpIHtcbiAgICAgIHRoaXMuX25lZWRzVXBkYXRlID0gZmFsc2U7XG5cbiAgICAgIHRoaXMuX3JlYnVpbGRWaWV3cG9ydHMoKTtcbiAgICB9XG5cbiAgICBpZiAodGhpcy5fbmVlZHNVcGRhdGUpIHtcbiAgICAgIHRoaXMuX25lZWRzVXBkYXRlID0gZmFsc2U7XG5cbiAgICAgIHRoaXMuX3JlYnVpbGRWaWV3cG9ydHMoKTtcbiAgICB9XG5cbiAgICB0aGlzLl9pc1VwZGF0aW5nID0gZmFsc2U7XG4gIH1cblxuICBfc2V0U2l6ZSh3aWR0aCwgaGVpZ2h0KSB7XG4gICAgaWYgKHdpZHRoICE9PSB0aGlzLndpZHRoIHx8IGhlaWdodCAhPT0gdGhpcy5oZWlnaHQpIHtcbiAgICAgIHRoaXMud2lkdGggPSB3aWR0aDtcbiAgICAgIHRoaXMuaGVpZ2h0ID0gaGVpZ2h0O1xuICAgICAgdGhpcy5zZXROZWVkc1VwZGF0ZSgnU2l6ZSBjaGFuZ2VkJyk7XG4gICAgfVxuICB9XG5cbiAgX3NldFZpZXdzKHZpZXdzKSB7XG4gICAgdmlld3MgPSBmbGF0dGVuKHZpZXdzLCBCb29sZWFuKTtcblxuICAgIGNvbnN0IHZpZXdzQ2hhbmdlZCA9IHRoaXMuX2RpZmZWaWV3cyh2aWV3cywgdGhpcy52aWV3cyk7XG5cbiAgICBpZiAodmlld3NDaGFuZ2VkKSB7XG4gICAgICB0aGlzLnNldE5lZWRzVXBkYXRlKCd2aWV3cyBjaGFuZ2VkJyk7XG4gICAgfVxuXG4gICAgdGhpcy52aWV3cyA9IHZpZXdzO1xuICB9XG5cbiAgX3NldFZpZXdTdGF0ZSh2aWV3U3RhdGUpIHtcbiAgICBpZiAodmlld1N0YXRlKSB7XG4gICAgICBjb25zdCB2aWV3U3RhdGVDaGFuZ2VkID0gIWRlZXBFcXVhbCh2aWV3U3RhdGUsIHRoaXMudmlld1N0YXRlKTtcblxuICAgICAgaWYgKHZpZXdTdGF0ZUNoYW5nZWQpIHtcbiAgICAgICAgdGhpcy5zZXROZWVkc1VwZGF0ZSgndmlld1N0YXRlIGNoYW5nZWQnKTtcbiAgICAgIH1cblxuICAgICAgdGhpcy52aWV3U3RhdGUgPSB2aWV3U3RhdGU7XG4gICAgfSBlbHNlIHtcbiAgICAgIGxvZy53YXJuKCdtaXNzaW5nIGB2aWV3U3RhdGVgIG9yIGBpbml0aWFsVmlld1N0YXRlYCcpKCk7XG4gICAgfVxuICB9XG5cbiAgX29uVmlld1N0YXRlQ2hhbmdlKHZpZXdJZCwgZXZlbnQpIHtcbiAgICBldmVudC52aWV3SWQgPSB2aWV3SWQ7XG5cbiAgICBpZiAodGhpcy5fZXZlbnRDYWxsYmFja3Mub25WaWV3U3RhdGVDaGFuZ2UpIHtcbiAgICAgIHRoaXMuX2V2ZW50Q2FsbGJhY2tzLm9uVmlld1N0YXRlQ2hhbmdlKGV2ZW50KTtcbiAgICB9XG4gIH1cblxuICBfY3JlYXRlQ29udHJvbGxlcih2aWV3LCBwcm9wcykge1xuICAgIGNvbnN0IENvbnRyb2xsZXIgPSBwcm9wcy50eXBlO1xuICAgIGNvbnN0IGNvbnRyb2xsZXIgPSBuZXcgQ29udHJvbGxlcih7XG4gICAgICB0aW1lbGluZTogdGhpcy50aW1lbGluZSxcbiAgICAgIGV2ZW50TWFuYWdlcjogdGhpcy5fZXZlbnRNYW5hZ2VyLFxuICAgICAgb25WaWV3U3RhdGVDaGFuZ2U6IHRoaXMuX29uVmlld1N0YXRlQ2hhbmdlLmJpbmQodGhpcywgcHJvcHMuaWQpLFxuICAgICAgb25TdGF0ZUNoYW5nZTogdGhpcy5fZXZlbnRDYWxsYmFja3Mub25JbnRlcmFjdGlvblN0YXRlQ2hhbmdlLFxuICAgICAgbWFrZVZpZXdwb3J0OiB2aWV3U3RhdGUgPT4gdmlldy5fZ2V0Vmlld3BvcnQodmlld1N0YXRlLCB7XG4gICAgICAgIHdpZHRoOiB2aWV3U3RhdGUud2lkdGgsXG4gICAgICAgIGhlaWdodDogdmlld1N0YXRlLmhlaWdodFxuICAgICAgfSksXG4gICAgICAuLi5wcm9wc1xuICAgIH0pO1xuICAgIHJldHVybiBjb250cm9sbGVyO1xuICB9XG5cbiAgX3VwZGF0ZUNvbnRyb2xsZXIodmlldywgdmlld1N0YXRlLCB2aWV3cG9ydCwgY29udHJvbGxlcikge1xuICAgIGxldCBjb250cm9sbGVyUHJvcHMgPSB2aWV3LmNvbnRyb2xsZXI7XG5cbiAgICBpZiAoY29udHJvbGxlclByb3BzKSB7XG4gICAgICBjb250cm9sbGVyUHJvcHMgPSB7IC4uLnZpZXdTdGF0ZSxcbiAgICAgICAgLi4udmlldy5wcm9wcyxcbiAgICAgICAgLi4uY29udHJvbGxlclByb3BzLFxuICAgICAgICBpZDogdmlldy5pZCxcbiAgICAgICAgeDogdmlld3BvcnQueCxcbiAgICAgICAgeTogdmlld3BvcnQueSxcbiAgICAgICAgd2lkdGg6IHZpZXdwb3J0LndpZHRoLFxuICAgICAgICBoZWlnaHQ6IHZpZXdwb3J0LmhlaWdodFxuICAgICAgfTtcblxuICAgICAgaWYgKGNvbnRyb2xsZXIpIHtcbiAgICAgICAgY29udHJvbGxlci5zZXRQcm9wcyhjb250cm9sbGVyUHJvcHMpO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgY29udHJvbGxlciA9IHRoaXMuX2NyZWF0ZUNvbnRyb2xsZXIodmlldywgY29udHJvbGxlclByb3BzKTtcbiAgICAgIH1cblxuICAgICAgcmV0dXJuIGNvbnRyb2xsZXI7XG4gICAgfVxuXG4gICAgcmV0dXJuIG51bGw7XG4gIH1cblxuICBfcmVidWlsZFZpZXdwb3J0cygpIHtcbiAgICBjb25zdCB7XG4gICAgICB3aWR0aCxcbiAgICAgIGhlaWdodCxcbiAgICAgIHZpZXdzXG4gICAgfSA9IHRoaXM7XG4gICAgY29uc3Qgb2xkQ29udHJvbGxlcnMgPSB0aGlzLmNvbnRyb2xsZXJzO1xuICAgIHRoaXMuX3ZpZXdwb3J0cyA9IFtdO1xuICAgIHRoaXMuY29udHJvbGxlcnMgPSB7fTtcbiAgICBsZXQgaW52YWxpZGF0ZUNvbnRyb2xsZXJzID0gZmFsc2U7XG5cbiAgICBmb3IgKGxldCBpID0gdmlld3MubGVuZ3RoOyBpLS07KSB7XG4gICAgICBjb25zdCB2aWV3ID0gdmlld3NbaV07XG4gICAgICBjb25zdCB2aWV3U3RhdGUgPSB0aGlzLmdldFZpZXdTdGF0ZSh2aWV3KTtcbiAgICAgIGNvbnN0IHZpZXdwb3J0ID0gdmlldy5tYWtlVmlld3BvcnQoe1xuICAgICAgICB3aWR0aCxcbiAgICAgICAgaGVpZ2h0LFxuICAgICAgICB2aWV3U3RhdGVcbiAgICAgIH0pO1xuICAgICAgbGV0IG9sZENvbnRyb2xsZXIgPSBvbGRDb250cm9sbGVyc1t2aWV3LmlkXTtcblxuICAgICAgaWYgKHZpZXcuY29udHJvbGxlciAmJiAhb2xkQ29udHJvbGxlcikge1xuICAgICAgICBpbnZhbGlkYXRlQ29udHJvbGxlcnMgPSB0cnVlO1xuICAgICAgfVxuXG4gICAgICBpZiAoKGludmFsaWRhdGVDb250cm9sbGVycyB8fCAhdmlldy5jb250cm9sbGVyKSAmJiBvbGRDb250cm9sbGVyKSB7XG4gICAgICAgIG9sZENvbnRyb2xsZXIuZmluYWxpemUoKTtcbiAgICAgICAgb2xkQ29udHJvbGxlciA9IG51bGw7XG4gICAgICB9XG5cbiAgICAgIHRoaXMuY29udHJvbGxlcnNbdmlldy5pZF0gPSB0aGlzLl91cGRhdGVDb250cm9sbGVyKHZpZXcsIHZpZXdTdGF0ZSwgdmlld3BvcnQsIG9sZENvbnRyb2xsZXIpO1xuXG4gICAgICB0aGlzLl92aWV3cG9ydHMudW5zaGlmdCh2aWV3cG9ydCk7XG4gICAgfVxuXG4gICAgZm9yIChjb25zdCBpZCBpbiBvbGRDb250cm9sbGVycykge1xuICAgICAgaWYgKG9sZENvbnRyb2xsZXJzW2lkXSAmJiAhdGhpcy5jb250cm9sbGVyc1tpZF0pIHtcbiAgICAgICAgb2xkQ29udHJvbGxlcnNbaWRdLmZpbmFsaXplKCk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgdGhpcy5fYnVpbGRWaWV3cG9ydE1hcCgpO1xuICB9XG5cbiAgX2J1aWxkVmlld3BvcnRNYXAoKSB7XG4gICAgdGhpcy5fdmlld3BvcnRNYXAgPSB7fTtcblxuICAgIHRoaXMuX3ZpZXdwb3J0cy5mb3JFYWNoKHZpZXdwb3J0ID0+IHtcbiAgICAgIGlmICh2aWV3cG9ydC5pZCkge1xuICAgICAgICB0aGlzLl92aWV3cG9ydE1hcFt2aWV3cG9ydC5pZF0gPSB0aGlzLl92aWV3cG9ydE1hcFt2aWV3cG9ydC5pZF0gfHwgdmlld3BvcnQ7XG4gICAgICB9XG4gICAgfSk7XG4gIH1cblxuICBfZGlmZlZpZXdzKG5ld1ZpZXdzLCBvbGRWaWV3cykge1xuICAgIGlmIChuZXdWaWV3cy5sZW5ndGggIT09IG9sZFZpZXdzLmxlbmd0aCkge1xuICAgICAgcmV0dXJuIHRydWU7XG4gICAgfVxuXG4gICAgcmV0dXJuIG5ld1ZpZXdzLnNvbWUoKF8sIGkpID0+ICFuZXdWaWV3c1tpXS5lcXVhbHMob2xkVmlld3NbaV0pKTtcbiAgfVxuXG59XG4vLyMgc291cmNlTWFwcGluZ1VSTD12aWV3LW1hbmFnZXIuanMubWFwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lib/view-manager.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lifecycle/component-state.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lifecycle/component-state.js ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return ComponentState; });\n/* harmony import */ var _utils_iterable_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/iterable-utils */ \"./node_modules/@deck.gl/core/dist/esm/utils/iterable-utils.js\");\n/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ \"./node_modules/@deck.gl/core/dist/esm/lifecycle/constants.js\");\n\n\nconst {\n  ASYNC_ORIGINAL,\n  ASYNC_RESOLVED,\n  ASYNC_DEFAULTS\n} = _constants__WEBPACK_IMPORTED_MODULE_1__[\"PROP_SYMBOLS\"];\nconst EMPTY_PROPS = Object.freeze({});\nclass ComponentState {\n  constructor(component = null) {\n    this.component = component;\n    this.asyncProps = {};\n\n    this.onAsyncPropUpdated = () => {};\n\n    this.oldProps = EMPTY_PROPS;\n    this.oldAsyncProps = null;\n  }\n\n  finalize() {\n    for (const propName in this.asyncProps) {\n      const asyncProp = this.asyncProps[propName];\n\n      if (asyncProp.type && asyncProp.type.release) {\n        asyncProp.type.release(asyncProp.resolvedValue, asyncProp.type, this.component);\n      }\n    }\n  }\n\n  getOldProps() {\n    return this.oldAsyncProps || this.oldProps;\n  }\n\n  resetOldProps() {\n    this.oldAsyncProps = null;\n    this.oldProps = this.component.props;\n  }\n\n  freezeAsyncOldProps() {\n    if (!this.oldAsyncProps) {\n      this.oldProps = this.oldProps || this.component.props;\n      this.oldAsyncProps = Object.create(this.oldProps);\n\n      for (const propName in this.asyncProps) {\n        Object.defineProperty(this.oldAsyncProps, propName, {\n          enumerable: true,\n          value: this.oldProps[propName]\n        });\n      }\n    }\n  }\n\n  hasAsyncProp(propName) {\n    return propName in this.asyncProps;\n  }\n\n  getAsyncProp(propName) {\n    const asyncProp = this.asyncProps[propName];\n    return asyncProp && asyncProp.resolvedValue;\n  }\n\n  isAsyncPropLoading(propName) {\n    if (propName) {\n      const asyncProp = this.asyncProps[propName];\n      return Boolean(asyncProp && asyncProp.pendingLoadCount > 0 && asyncProp.pendingLoadCount !== asyncProp.resolvedLoadCount);\n    }\n\n    for (const key in this.asyncProps) {\n      if (this.isAsyncPropLoading(key)) {\n        return true;\n      }\n    }\n\n    return false;\n  }\n\n  reloadAsyncProp(propName, value) {\n    this._watchPromise(propName, Promise.resolve(value));\n  }\n\n  setAsyncProps(props) {\n    const resolvedValues = props[ASYNC_RESOLVED] || {};\n    const originalValues = props[ASYNC_ORIGINAL] || props;\n    const defaultValues = props[ASYNC_DEFAULTS] || {};\n\n    for (const propName in resolvedValues) {\n      const value = resolvedValues[propName];\n\n      this._createAsyncPropData(propName, defaultValues[propName]);\n\n      this._updateAsyncProp(propName, value);\n\n      resolvedValues[propName] = this.getAsyncProp(propName);\n    }\n\n    for (const propName in originalValues) {\n      const value = originalValues[propName];\n\n      this._createAsyncPropData(propName, defaultValues[propName]);\n\n      this._updateAsyncProp(propName, value);\n    }\n  }\n\n  _updateAsyncProp(propName, value) {\n    if (!this._didAsyncInputValueChange(propName, value)) {\n      return;\n    }\n\n    if (typeof value === 'string') {\n      var _this$layer;\n\n      const fetch = (_this$layer = this.layer) === null || _this$layer === void 0 ? void 0 : _this$layer.props.fetch;\n      const url = value;\n\n      if (fetch) {\n        value = fetch(url, {\n          propName,\n          layer: this.layer\n        });\n      }\n    }\n\n    if (value instanceof Promise) {\n      this._watchPromise(propName, value);\n\n      return;\n    }\n\n    if (Object(_utils_iterable_utils__WEBPACK_IMPORTED_MODULE_0__[\"isAsyncIterable\"])(value)) {\n      this._resolveAsyncIterable(propName, value);\n\n      return;\n    }\n\n    this._setPropValue(propName, value);\n  }\n\n  _didAsyncInputValueChange(propName, value) {\n    const asyncProp = this.asyncProps[propName];\n\n    if (value === asyncProp.resolvedValue || value === asyncProp.lastValue) {\n      return false;\n    }\n\n    asyncProp.lastValue = value;\n    return true;\n  }\n\n  _setPropValue(propName, value) {\n    const asyncProp = this.asyncProps[propName];\n    value = this._postProcessValue(asyncProp, value);\n    asyncProp.resolvedValue = value;\n    asyncProp.pendingLoadCount++;\n    asyncProp.resolvedLoadCount = asyncProp.pendingLoadCount;\n  }\n\n  _setAsyncPropValue(propName, value, loadCount) {\n    const asyncProp = this.asyncProps[propName];\n\n    if (asyncProp && loadCount >= asyncProp.resolvedLoadCount && value !== undefined) {\n      this.freezeAsyncOldProps();\n      asyncProp.resolvedValue = value;\n      asyncProp.resolvedLoadCount = loadCount;\n      this.onAsyncPropUpdated(propName, value);\n    }\n  }\n\n  _watchPromise(propName, promise) {\n    const asyncProp = this.asyncProps[propName];\n    asyncProp.pendingLoadCount++;\n    const loadCount = asyncProp.pendingLoadCount;\n    promise.then(data => {\n      var _this$layer2;\n\n      data = this._postProcessValue(asyncProp, data);\n\n      this._setAsyncPropValue(propName, data, loadCount);\n\n      const onDataLoad = (_this$layer2 = this.layer) === null || _this$layer2 === void 0 ? void 0 : _this$layer2.props.onDataLoad;\n\n      if (propName === 'data' && onDataLoad) {\n        onDataLoad(data, {\n          propName,\n          layer: this.layer\n        });\n      }\n    }).catch(error => {\n      var _this$layer3;\n\n      (_this$layer3 = this.layer) === null || _this$layer3 === void 0 ? void 0 : _this$layer3.raiseError(error, \"loading \".concat(propName, \" of \").concat(this.layer));\n    });\n  }\n\n  async _resolveAsyncIterable(propName, iterable) {\n    var _this$layer4;\n\n    if (propName !== 'data') {\n      this._setPropValue(propName, iterable);\n    }\n\n    const asyncProp = this.asyncProps[propName];\n    asyncProp.pendingLoadCount++;\n    const loadCount = asyncProp.pendingLoadCount;\n    let data = [];\n    let count = 0;\n\n    for await (const chunk of iterable) {\n      const {\n        dataTransform\n      } = this.component ? this.component.props : {};\n\n      if (dataTransform) {\n        data = dataTransform(chunk, data);\n      } else {\n        data = data.concat(chunk);\n      }\n\n      Object.defineProperty(data, '__diff', {\n        enumerable: false,\n        value: [{\n          startRow: count,\n          endRow: data.length\n        }]\n      });\n      count = data.length;\n\n      this._setAsyncPropValue(propName, data, loadCount);\n    }\n\n    const onDataLoad = (_this$layer4 = this.layer) === null || _this$layer4 === void 0 ? void 0 : _this$layer4.props.onDataLoad;\n\n    if (onDataLoad) {\n      onDataLoad(data, {\n        propName,\n        layer: this.layer\n      });\n    }\n  }\n\n  _postProcessValue(asyncProp, value) {\n    const propType = asyncProp.type;\n\n    if (propType) {\n      if (propType.release) {\n        propType.release(asyncProp.resolvedValue, propType, this.component);\n      }\n\n      if (propType.transform) {\n        return propType.transform(value, propType, this.component);\n      }\n    }\n\n    return value;\n  }\n\n  _createAsyncPropData(propName, defaultValue) {\n    const asyncProp = this.asyncProps[propName];\n\n    if (!asyncProp) {\n      const propTypes = this.component && this.component.constructor._propTypes;\n      this.asyncProps[propName] = {\n        type: propTypes && propTypes[propName],\n        lastValue: null,\n        resolvedValue: defaultValue,\n        pendingLoadCount: 0,\n        resolvedLoadCount: 0\n      };\n    }\n  }\n\n}\n//# sourceMappingURL=component-state.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lifecycle/component-state.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lifecycle/component.js":
/*!********************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lifecycle/component.js ***!
  \********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return Component; });\n/* harmony import */ var _lifecycle_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../lifecycle/constants */ \"./node_modules/@deck.gl/core/dist/esm/lifecycle/constants.js\");\n/* harmony import */ var _create_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./create-props */ \"./node_modules/@deck.gl/core/dist/esm/lifecycle/create-props.js\");\n/* harmony import */ var _component_state__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./component-state */ \"./node_modules/@deck.gl/core/dist/esm/lifecycle/component-state.js\");\n\n\n\nconst {\n  ASYNC_ORIGINAL,\n  ASYNC_RESOLVED,\n  ASYNC_DEFAULTS\n} = _lifecycle_constants__WEBPACK_IMPORTED_MODULE_0__[\"PROP_SYMBOLS\"];\n\nconst defaultProps = {};\nlet counter = 0;\nclass Component {\n  constructor() {\n    this.props = _create_props__WEBPACK_IMPORTED_MODULE_1__[\"createProps\"].apply(this, arguments);\n    this.id = this.props.id;\n    this.count = counter++;\n    this.lifecycle = _lifecycle_constants__WEBPACK_IMPORTED_MODULE_0__[\"LIFECYCLE\"].NO_STATE;\n    this.parent = null;\n    this.context = null;\n    this.state = null;\n    this.internalState = null;\n    Object.seal(this);\n  }\n\n  clone(newProps) {\n    const {\n      props\n    } = this;\n    const asyncProps = {};\n\n    for (const key in props[ASYNC_DEFAULTS]) {\n      if (key in props[ASYNC_RESOLVED]) {\n        asyncProps[key] = props[ASYNC_RESOLVED][key];\n      } else if (key in props[ASYNC_ORIGINAL]) {\n        asyncProps[key] = props[ASYNC_ORIGINAL][key];\n      }\n    }\n\n    return new this.constructor({ ...props,\n      ...asyncProps,\n      ...newProps\n    });\n  }\n\n  get stats() {\n    return this.internalState.stats;\n  }\n\n  _initState() {\n    this.internalState = new _component_state__WEBPACK_IMPORTED_MODULE_2__[\"default\"]({});\n  }\n\n}\nComponent.componentName = 'Component';\nComponent.defaultProps = defaultProps;\n//# sourceMappingURL=component.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lifecycle/component.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lifecycle/constants.js":
/*!********************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lifecycle/constants.js ***!
  \********************************************************************/
/*! exports provided: LIFECYCLE, PROP_SYMBOLS */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"LIFECYCLE\", function() { return LIFECYCLE; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"PROP_SYMBOLS\", function() { return PROP_SYMBOLS; });\nconst LIFECYCLE = {\n  NO_STATE: 'Awaiting state',\n  MATCHED: 'Matched. State transferred from previous layer',\n  INITIALIZED: 'Initialized',\n  AWAITING_GC: 'Discarded. Awaiting garbage collection',\n  AWAITING_FINALIZATION: 'No longer matched. Awaiting garbage collection',\n  FINALIZED: 'Finalized! Awaiting garbage collection'\n};\nconst PROP_SYMBOLS = {\n  COMPONENT: Symbol.for('component'),\n  ASYNC_DEFAULTS: Symbol.for('asyncPropDefaults'),\n  ASYNC_ORIGINAL: Symbol.for('asyncPropOriginal'),\n  ASYNC_RESOLVED: Symbol.for('asyncPropResolved')\n};\n//# sourceMappingURL=constants.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS9saWZlY3ljbGUvY29uc3RhbnRzLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0BkZWNrLmdsL2NvcmUvZGlzdC9lc20vbGlmZWN5Y2xlL2NvbnN0YW50cy5qcz8yMzc5Il0sInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCBjb25zdCBMSUZFQ1lDTEUgPSB7XG4gIE5PX1NUQVRFOiAnQXdhaXRpbmcgc3RhdGUnLFxuICBNQVRDSEVEOiAnTWF0Y2hlZC4gU3RhdGUgdHJhbnNmZXJyZWQgZnJvbSBwcmV2aW91cyBsYXllcicsXG4gIElOSVRJQUxJWkVEOiAnSW5pdGlhbGl6ZWQnLFxuICBBV0FJVElOR19HQzogJ0Rpc2NhcmRlZC4gQXdhaXRpbmcgZ2FyYmFnZSBjb2xsZWN0aW9uJyxcbiAgQVdBSVRJTkdfRklOQUxJWkFUSU9OOiAnTm8gbG9uZ2VyIG1hdGNoZWQuIEF3YWl0aW5nIGdhcmJhZ2UgY29sbGVjdGlvbicsXG4gIEZJTkFMSVpFRDogJ0ZpbmFsaXplZCEgQXdhaXRpbmcgZ2FyYmFnZSBjb2xsZWN0aW9uJ1xufTtcbmV4cG9ydCBjb25zdCBQUk9QX1NZTUJPTFMgPSB7XG4gIENPTVBPTkVOVDogU3ltYm9sLmZvcignY29tcG9uZW50JyksXG4gIEFTWU5DX0RFRkFVTFRTOiBTeW1ib2wuZm9yKCdhc3luY1Byb3BEZWZhdWx0cycpLFxuICBBU1lOQ19PUklHSU5BTDogU3ltYm9sLmZvcignYXN5bmNQcm9wT3JpZ2luYWwnKSxcbiAgQVNZTkNfUkVTT0xWRUQ6IFN5bWJvbC5mb3IoJ2FzeW5jUHJvcFJlc29sdmVkJylcbn07XG4vLyMgc291cmNlTWFwcGluZ1VSTD1jb25zdGFudHMuanMubWFwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lifecycle/constants.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lifecycle/create-props.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lifecycle/create-props.js ***!
  \***********************************************************************/
/*! exports provided: createProps */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"createProps\", function() { return createProps; });\n/* harmony import */ var _utils_log__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/log */ \"./node_modules/@deck.gl/core/dist/esm/utils/log.js\");\n/* harmony import */ var _utils_iterable_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/iterable-utils */ \"./node_modules/@deck.gl/core/dist/esm/utils/iterable-utils.js\");\n/* harmony import */ var _prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./prop-types */ \"./node_modules/@deck.gl/core/dist/esm/lifecycle/prop-types.js\");\n/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ \"./node_modules/@deck.gl/core/dist/esm/lifecycle/constants.js\");\n\n\n\n\nconst {\n  COMPONENT,\n  ASYNC_ORIGINAL,\n  ASYNC_RESOLVED,\n  ASYNC_DEFAULTS\n} = _constants__WEBPACK_IMPORTED_MODULE_3__[\"PROP_SYMBOLS\"];\nfunction createProps() {\n  const component = this;\n  const propsPrototype = getPropsPrototype(component.constructor);\n  const propsInstance = Object.create(propsPrototype);\n  propsInstance[COMPONENT] = component;\n  propsInstance[ASYNC_ORIGINAL] = {};\n  propsInstance[ASYNC_RESOLVED] = {};\n\n  for (let i = 0; i < arguments.length; ++i) {\n    const props = arguments[i];\n\n    for (const key in props) {\n      propsInstance[key] = props[key];\n    }\n  }\n\n  Object.freeze(propsInstance);\n  return propsInstance;\n}\n\nfunction getPropsPrototype(componentClass) {\n  const defaultProps = getOwnProperty(componentClass, '_mergedDefaultProps');\n\n  if (!defaultProps) {\n    createPropsPrototypeAndTypes(componentClass);\n    return componentClass._mergedDefaultProps;\n  }\n\n  return defaultProps;\n}\n\nfunction createPropsPrototypeAndTypes(componentClass) {\n  const parent = componentClass.prototype;\n\n  if (!parent) {\n    return;\n  }\n\n  const parentClass = Object.getPrototypeOf(componentClass);\n  const parentDefaultProps = getPropsPrototype(parentClass);\n  const componentDefaultProps = getOwnProperty(componentClass, 'defaultProps') || {};\n  const componentPropDefs = Object(_prop_types__WEBPACK_IMPORTED_MODULE_2__[\"parsePropTypes\"])(componentDefaultProps);\n  const defaultProps = createPropsPrototype(componentPropDefs.defaultProps, parentDefaultProps, componentClass);\n  const propTypes = { ...parentClass._propTypes,\n    ...componentPropDefs.propTypes\n  };\n  addAsyncPropsToPropPrototype(defaultProps, propTypes);\n  const deprecatedProps = { ...parentClass._deprecatedProps,\n    ...componentPropDefs.deprecatedProps\n  };\n  addDeprecatedPropsToPropPrototype(defaultProps, deprecatedProps);\n  componentClass._mergedDefaultProps = defaultProps;\n  componentClass._propTypes = propTypes;\n  componentClass._deprecatedProps = deprecatedProps;\n}\n\nfunction createPropsPrototype(props, parentProps, componentClass) {\n  const defaultProps = Object.create(null);\n  Object.assign(defaultProps, parentProps, props);\n  const id = getComponentName(componentClass);\n  delete props.id;\n  Object.defineProperties(defaultProps, {\n    id: {\n      writable: true,\n      value: id\n    }\n  });\n  return defaultProps;\n}\n\nfunction addDeprecatedPropsToPropPrototype(defaultProps, deprecatedProps) {\n  for (const propName in deprecatedProps) {\n    Object.defineProperty(defaultProps, propName, {\n      enumerable: false,\n\n      set(newValue) {\n        const nameStr = \"\".concat(this.id, \": \").concat(propName);\n\n        for (const newPropName of deprecatedProps[propName]) {\n          if (!hasOwnProperty(this, newPropName)) {\n            this[newPropName] = newValue;\n          }\n        }\n\n        _utils_log__WEBPACK_IMPORTED_MODULE_0__[\"default\"].deprecated(nameStr, deprecatedProps[propName].join('/'))();\n      }\n\n    });\n  }\n}\n\nfunction addAsyncPropsToPropPrototype(defaultProps, propTypes) {\n  const defaultValues = {};\n  const descriptors = {};\n\n  for (const propName in propTypes) {\n    const propType = propTypes[propName];\n    const {\n      name,\n      value\n    } = propType;\n\n    if (propType.async) {\n      defaultValues[name] = value;\n      descriptors[name] = getDescriptorForAsyncProp(name, value);\n    }\n  }\n\n  defaultProps[ASYNC_DEFAULTS] = defaultValues;\n  defaultProps[ASYNC_ORIGINAL] = {};\n  Object.defineProperties(defaultProps, descriptors);\n}\n\nfunction getDescriptorForAsyncProp(name) {\n  return {\n    enumerable: true,\n\n    set(newValue) {\n      if (typeof newValue === 'string' || newValue instanceof Promise || Object(_utils_iterable_utils__WEBPACK_IMPORTED_MODULE_1__[\"isAsyncIterable\"])(newValue)) {\n        this[ASYNC_ORIGINAL][name] = newValue;\n      } else {\n        this[ASYNC_RESOLVED][name] = newValue;\n      }\n    },\n\n    get() {\n      if (this[ASYNC_RESOLVED]) {\n        if (name in this[ASYNC_RESOLVED]) {\n          const value = this[ASYNC_RESOLVED][name];\n          return value || this[ASYNC_DEFAULTS][name];\n        }\n\n        if (name in this[ASYNC_ORIGINAL]) {\n          const state = this[COMPONENT] && this[COMPONENT].internalState;\n\n          if (state && state.hasAsyncProp(name)) {\n            return state.getAsyncProp(name) || this[ASYNC_DEFAULTS][name];\n          }\n        }\n      }\n\n      return this[ASYNC_DEFAULTS][name];\n    }\n\n  };\n}\n\nfunction hasOwnProperty(object, prop) {\n  return Object.prototype.hasOwnProperty.call(object, prop);\n}\n\nfunction getOwnProperty(object, prop) {\n  return hasOwnProperty(object, prop) && object[prop];\n}\n\nfunction getComponentName(componentClass) {\n  const componentName = getOwnProperty(componentClass, 'layerName') || getOwnProperty(componentClass, 'componentName');\n\n  if (!componentName) {\n    _utils_log__WEBPACK_IMPORTED_MODULE_0__[\"default\"].once(0, \"\".concat(componentClass.name, \".componentName not specified\"))();\n  }\n\n  return componentName || componentClass.name;\n}\n//# sourceMappingURL=create-props.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lifecycle/create-props.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lifecycle/prop-types.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lifecycle/prop-types.js ***!
  \*********************************************************************/
/*! exports provided: parsePropTypes */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"parsePropTypes\", function() { return parsePropTypes; });\n/* harmony import */ var _utils_texture__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/texture */ \"./node_modules/@deck.gl/core/dist/esm/utils/texture.js\");\n\nconst TYPE_DEFINITIONS = {\n  boolean: {\n    validate(value, propType) {\n      return true;\n    },\n\n    equal(value1, value2, propType) {\n      return Boolean(value1) === Boolean(value2);\n    }\n\n  },\n  number: {\n    validate(value, propType) {\n      return Number.isFinite(value) && (!('max' in propType) || value <= propType.max) && (!('min' in propType) || value >= propType.min);\n    }\n\n  },\n  color: {\n    validate(value, propType) {\n      return propType.optional && !value || isArray(value) && (value.length === 3 || value.length === 4);\n    },\n\n    equal(value1, value2, propType) {\n      return arrayEqual(value1, value2);\n    }\n\n  },\n  accessor: {\n    validate(value, propType) {\n      const valueType = getTypeOf(value);\n      return valueType === 'function' || valueType === getTypeOf(propType.value);\n    },\n\n    equal(value1, value2, propType) {\n      if (typeof value2 === 'function') {\n        return true;\n      }\n\n      return arrayEqual(value1, value2);\n    }\n\n  },\n  array: {\n    validate(value, propType) {\n      return propType.optional && !value || isArray(value);\n    },\n\n    equal(value1, value2, propType) {\n      return propType.compare ? arrayEqual(value1, value2) : value1 === value2;\n    }\n\n  },\n  function: {\n    validate(value, propType) {\n      return propType.optional && !value || typeof value === 'function';\n    },\n\n    equal(value1, value2, propType) {\n      return !propType.compare || value1 === value2;\n    }\n\n  },\n  data: {\n    transform: (value, propType, component) => {\n      const {\n        dataTransform\n      } = component ? component.props : {};\n      return dataTransform && value ? dataTransform(value) : value;\n    }\n  },\n  image: {\n    transform: (value, propType, component) => {\n      return Object(_utils_texture__WEBPACK_IMPORTED_MODULE_0__[\"createTexture\"])(component, value);\n    },\n    release: value => {\n      Object(_utils_texture__WEBPACK_IMPORTED_MODULE_0__[\"destroyTexture\"])(value);\n    }\n  }\n};\n\nfunction arrayEqual(array1, array2) {\n  if (array1 === array2) {\n    return true;\n  }\n\n  if (!isArray(array1) || !isArray(array2)) {\n    return false;\n  }\n\n  const len = array1.length;\n\n  if (len !== array2.length) {\n    return false;\n  }\n\n  for (let i = 0; i < len; i++) {\n    if (array1[i] !== array2[i]) {\n      return false;\n    }\n  }\n\n  return true;\n}\n\nfunction parsePropTypes(propDefs) {\n  const propTypes = {};\n  const defaultProps = {};\n  const deprecatedProps = {};\n\n  for (const [propName, propDef] of Object.entries(propDefs)) {\n    if (propDef && propDef.deprecatedFor) {\n      deprecatedProps[propName] = Array.isArray(propDef.deprecatedFor) ? propDef.deprecatedFor : [propDef.deprecatedFor];\n    } else {\n      const propType = parsePropType(propName, propDef);\n      propTypes[propName] = propType;\n      defaultProps[propName] = propType.value;\n    }\n  }\n\n  return {\n    propTypes,\n    defaultProps,\n    deprecatedProps\n  };\n}\n\nfunction parsePropType(name, propDef) {\n  switch (getTypeOf(propDef)) {\n    case 'object':\n      return normalizePropDefinition(name, propDef);\n\n    case 'array':\n      return normalizePropDefinition(name, {\n        type: 'array',\n        value: propDef,\n        compare: false\n      });\n\n    case 'boolean':\n      return normalizePropDefinition(name, {\n        type: 'boolean',\n        value: propDef\n      });\n\n    case 'number':\n      return normalizePropDefinition(name, {\n        type: 'number',\n        value: propDef\n      });\n\n    case 'function':\n      return normalizePropDefinition(name, {\n        type: 'function',\n        value: propDef,\n        compare: true\n      });\n\n    default:\n      return {\n        name,\n        type: 'unknown',\n        value: propDef\n      };\n  }\n}\n\nfunction normalizePropDefinition(name, propDef) {\n  if (!('type' in propDef)) {\n    if (!('value' in propDef)) {\n      return {\n        name,\n        type: 'object',\n        value: propDef\n      };\n    }\n\n    return {\n      name,\n      type: getTypeOf(propDef.value),\n      ...propDef\n    };\n  }\n\n  return {\n    name,\n    ...TYPE_DEFINITIONS[propDef.type],\n    ...propDef\n  };\n}\n\nfunction isArray(value) {\n  return Array.isArray(value) || ArrayBuffer.isView(value);\n}\n\nfunction getTypeOf(value) {\n  if (isArray(value)) {\n    return 'array';\n  }\n\n  if (value === null) {\n    return 'null';\n  }\n\n  return typeof value;\n}\n//# sourceMappingURL=prop-types.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lifecycle/prop-types.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/lifecycle/props.js":
/*!****************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/lifecycle/props.js ***!
  \****************************************************************/
/*! exports provided: validateProps, diffProps, compareProps */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"validateProps\", function() { return validateProps; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"diffProps\", function() { return diffProps; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"compareProps\", function() { return compareProps; });\n/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ \"./node_modules/@deck.gl/core/dist/esm/lifecycle/constants.js\");\n\nconst {\n  COMPONENT\n} = _constants__WEBPACK_IMPORTED_MODULE_0__[\"PROP_SYMBOLS\"];\nfunction validateProps(props) {\n  const propTypes = getPropTypes(props);\n\n  for (const propName in propTypes) {\n    const propType = propTypes[propName];\n    const {\n      validate\n    } = propType;\n\n    if (validate && !validate(props[propName], propType)) {\n      throw new Error(\"Invalid prop \".concat(propName, \": \").concat(props[propName]));\n    }\n  }\n}\nfunction diffProps(props, oldProps) {\n  const propsChangedReason = compareProps({\n    newProps: props,\n    oldProps,\n    propTypes: getPropTypes(props),\n    ignoreProps: {\n      data: null,\n      updateTriggers: null,\n      extensions: null,\n      transitions: null\n    }\n  });\n  const dataChangedReason = diffDataProps(props, oldProps);\n  let updateTriggersChangedReason = false;\n\n  if (!dataChangedReason) {\n    updateTriggersChangedReason = diffUpdateTriggers(props, oldProps);\n  }\n\n  return {\n    dataChanged: dataChangedReason,\n    propsChanged: propsChangedReason,\n    updateTriggersChanged: updateTriggersChangedReason,\n    extensionsChanged: diffExtensions(props, oldProps),\n    transitionsChanged: diffTransitions(props, oldProps)\n  };\n}\n\nfunction diffTransitions(props, oldProps) {\n  if (!props.transitions) {\n    return null;\n  }\n\n  const result = {};\n  const propTypes = getPropTypes(props);\n\n  for (const key in props.transitions) {\n    const propType = propTypes[key];\n    const type = propType && propType.type;\n    const isTransitionable = type === 'number' || type === 'color' || type === 'array';\n\n    if (isTransitionable && comparePropValues(props[key], oldProps[key], propType)) {\n      result[key] = true;\n    }\n  }\n\n  return result;\n}\n\nfunction compareProps({\n  newProps,\n  oldProps,\n  ignoreProps = {},\n  propTypes = {},\n  triggerName = 'props'\n} = {}) {\n  if (oldProps === newProps) {\n    return null;\n  }\n\n  if (typeof newProps !== 'object' || newProps === null) {\n    return \"\".concat(triggerName, \" changed shallowly\");\n  }\n\n  if (typeof oldProps !== 'object' || oldProps === null) {\n    return \"\".concat(triggerName, \" changed shallowly\");\n  }\n\n  for (const key of Object.keys(newProps)) {\n    if (!(key in ignoreProps)) {\n      if (!(key in oldProps)) {\n        return \"\".concat(triggerName, \".\").concat(key, \" added\");\n      }\n\n      const changed = comparePropValues(newProps[key], oldProps[key], propTypes[key]);\n\n      if (changed) {\n        return \"\".concat(triggerName, \".\").concat(key, \" \").concat(changed);\n      }\n    }\n  }\n\n  for (const key of Object.keys(oldProps)) {\n    if (!(key in ignoreProps)) {\n      if (!(key in newProps)) {\n        return \"\".concat(triggerName, \".\").concat(key, \" dropped\");\n      }\n\n      if (!Object.hasOwnProperty.call(newProps, key)) {\n        const changed = comparePropValues(newProps[key], oldProps[key], propTypes[key]);\n\n        if (changed) {\n          return \"\".concat(triggerName, \".\").concat(key, \" \").concat(changed);\n        }\n      }\n    }\n  }\n\n  return null;\n}\n\nfunction comparePropValues(newProp, oldProp, propType) {\n  let equal = propType && propType.equal;\n\n  if (equal && !equal(newProp, oldProp, propType)) {\n    return 'changed deeply';\n  }\n\n  if (!equal) {\n    equal = newProp && oldProp && newProp.equals;\n\n    if (equal && !equal.call(newProp, oldProp)) {\n      return 'changed deeply';\n    }\n  }\n\n  if (!equal && oldProp !== newProp) {\n    return 'changed shallowly';\n  }\n\n  return null;\n}\n\nfunction diffDataProps(props, oldProps) {\n  if (oldProps === null) {\n    return 'oldProps is null, initial diff';\n  }\n\n  let dataChanged = null;\n  const {\n    dataComparator,\n    _dataDiff\n  } = props;\n\n  if (dataComparator) {\n    if (!dataComparator(props.data, oldProps.data)) {\n      dataChanged = 'Data comparator detected a change';\n    }\n  } else if (props.data !== oldProps.data) {\n    dataChanged = 'A new data container was supplied';\n  }\n\n  if (dataChanged && _dataDiff) {\n    dataChanged = _dataDiff(props.data, oldProps.data) || dataChanged;\n  }\n\n  return dataChanged;\n}\n\nfunction diffUpdateTriggers(props, oldProps) {\n  if (oldProps === null) {\n    return 'oldProps is null, initial diff';\n  }\n\n  if ('all' in props.updateTriggers) {\n    const diffReason = diffUpdateTrigger(props, oldProps, 'all');\n\n    if (diffReason) {\n      return {\n        all: true\n      };\n    }\n  }\n\n  const triggerChanged = {};\n  let reason = false;\n\n  for (const triggerName in props.updateTriggers) {\n    if (triggerName !== 'all') {\n      const diffReason = diffUpdateTrigger(props, oldProps, triggerName);\n\n      if (diffReason) {\n        triggerChanged[triggerName] = true;\n        reason = triggerChanged;\n      }\n    }\n  }\n\n  return reason;\n}\n\nfunction diffExtensions(props, oldProps) {\n  if (oldProps === null) {\n    return 'oldProps is null, initial diff';\n  }\n\n  const oldExtensions = oldProps.extensions;\n  const {\n    extensions\n  } = props;\n\n  if (extensions === oldExtensions) {\n    return false;\n  }\n\n  if (extensions.length !== oldExtensions.length) {\n    return true;\n  }\n\n  for (let i = 0; i < extensions.length; i++) {\n    if (!extensions[i].equals(oldExtensions[i])) {\n      return true;\n    }\n  }\n\n  return false;\n}\n\nfunction diffUpdateTrigger(props, oldProps, triggerName) {\n  let newTriggers = props.updateTriggers[triggerName];\n  newTriggers = newTriggers === undefined || newTriggers === null ? {} : newTriggers;\n  let oldTriggers = oldProps.updateTriggers[triggerName];\n  oldTriggers = oldTriggers === undefined || oldTriggers === null ? {} : oldTriggers;\n  const diffReason = compareProps({\n    oldProps: oldTriggers,\n    newProps: newTriggers,\n    triggerName\n  });\n  return diffReason;\n}\n\nfunction getPropTypes(props) {\n  const layer = props[COMPONENT];\n  const LayerType = layer && layer.constructor;\n  return LayerType ? LayerType._propTypes : {};\n}\n//# sourceMappingURL=props.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/lifecycle/props.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/passes/draw-layers-pass.js":
/*!************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/passes/draw-layers-pass.js ***!
  \************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return DrawLayersPass; });\n/* harmony import */ var _layers_pass__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./layers-pass */ \"./node_modules/@deck.gl/core/dist/esm/passes/layers-pass.js\");\n\nclass DrawLayersPass extends _layers_pass__WEBPACK_IMPORTED_MODULE_0__[\"default\"] {}\n//# sourceMappingURL=draw-layers-pass.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS9wYXNzZXMvZHJhdy1sYXllcnMtcGFzcy5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9AZGVjay5nbC9jb3JlL2Rpc3QvZXNtL3Bhc3Nlcy9kcmF3LWxheWVycy1wYXNzLmpzP2M2YTgiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IExheWVyc1Bhc3MgZnJvbSAnLi9sYXllcnMtcGFzcyc7XG5leHBvcnQgZGVmYXVsdCBjbGFzcyBEcmF3TGF5ZXJzUGFzcyBleHRlbmRzIExheWVyc1Bhc3Mge31cbi8vIyBzb3VyY2VNYXBwaW5nVVJMPWRyYXctbGF5ZXJzLXBhc3MuanMubWFwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/passes/draw-layers-pass.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/passes/layers-pass.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/passes/layers-pass.js ***!
  \*******************************************************************/
/*! exports provided: default, layerIndexResolver */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return LayersPass; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"layerIndexResolver\", function() { return layerIndexResolver; });\n/* harmony import */ var _pass__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./pass */ \"./node_modules/@deck.gl/core/dist/esm/passes/pass.js\");\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/gltools/dist/esm/index.js\");\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/webgl/dist/esm/classes/clear.js\");\n\n\nclass LayersPass extends _pass__WEBPACK_IMPORTED_MODULE_0__[\"default\"] {\n  render(props) {\n    const gl = this.gl;\n    Object(_luma_gl_core__WEBPACK_IMPORTED_MODULE_1__[\"setParameters\"])(gl, {\n      framebuffer: props.target\n    });\n    return this._drawLayers(props);\n  }\n\n  _drawLayers(props) {\n    const {\n      viewports,\n      views,\n      onViewportActive,\n      clearCanvas = true\n    } = props;\n    props.pass = props.pass || 'unknown';\n    const gl = this.gl;\n\n    if (clearCanvas) {\n      clearGLCanvas(gl);\n    }\n\n    const renderStats = [];\n\n    for (const viewportOrDescriptor of viewports) {\n      const viewport = viewportOrDescriptor.viewport || viewportOrDescriptor;\n      const view = views && views[viewport.id];\n      onViewportActive(viewport);\n\n      const drawLayerParams = this._getDrawLayerParams(viewport, props);\n\n      props.view = view;\n      const subViewports = viewport.subViewports || [viewport];\n\n      for (const subViewport of subViewports) {\n        props.viewport = subViewport;\n\n        const stats = this._drawLayersInViewport(gl, props, drawLayerParams);\n\n        renderStats.push(stats);\n      }\n    }\n\n    return renderStats;\n  }\n\n  _getDrawLayerParams(viewport, {\n    layers,\n    pass,\n    layerFilter,\n    effects,\n    moduleParameters\n  }) {\n    const drawLayerParams = [];\n    const indexResolver = layerIndexResolver();\n    const drawContext = {\n      viewport,\n      isPicking: pass.startsWith('picking'),\n      renderPass: pass\n    };\n\n    for (let layerIndex = 0; layerIndex < layers.length; layerIndex++) {\n      const layer = layers[layerIndex];\n\n      const shouldDrawLayer = this._shouldDrawLayer(layer, drawContext, layerFilter);\n\n      const layerRenderIndex = indexResolver(layer, shouldDrawLayer);\n      const layerParam = {\n        shouldDrawLayer,\n        layerRenderIndex\n      };\n\n      if (shouldDrawLayer) {\n        layerParam.moduleParameters = this._getModuleParameters(layer, effects, pass, moduleParameters);\n        layerParam.layerParameters = this.getLayerParameters(layer, layerIndex);\n      }\n\n      drawLayerParams[layerIndex] = layerParam;\n    }\n\n    return drawLayerParams;\n  }\n\n  _drawLayersInViewport(gl, {\n    layers,\n    pass,\n    viewport,\n    view\n  }, drawLayerParams) {\n    const glViewport = getGLViewport(gl, {\n      viewport\n    });\n\n    if (view && view.props.clear) {\n      const clearOpts = view.props.clear === true ? {\n        color: true,\n        depth: true\n      } : view.props.clear;\n      Object(_luma_gl_core__WEBPACK_IMPORTED_MODULE_1__[\"withParameters\"])(gl, {\n        scissorTest: true,\n        scissor: glViewport\n      }, () => Object(_luma_gl_core__WEBPACK_IMPORTED_MODULE_2__[\"clear\"])(gl, clearOpts));\n    }\n\n    const renderStatus = {\n      totalCount: layers.length,\n      visibleCount: 0,\n      compositeCount: 0,\n      pickableCount: 0\n    };\n    Object(_luma_gl_core__WEBPACK_IMPORTED_MODULE_1__[\"setParameters\"])(gl, {\n      viewport: glViewport\n    });\n\n    for (let layerIndex = 0; layerIndex < layers.length; layerIndex++) {\n      const layer = layers[layerIndex];\n      const {\n        shouldDrawLayer,\n        layerRenderIndex,\n        moduleParameters,\n        layerParameters\n      } = drawLayerParams[layerIndex];\n\n      if (shouldDrawLayer && layer.props.pickable) {\n        renderStatus.pickableCount++;\n      }\n\n      if (layer.isComposite) {\n        renderStatus.compositeCount++;\n      } else if (shouldDrawLayer) {\n        renderStatus.visibleCount++;\n        moduleParameters.viewport = viewport;\n\n        try {\n          layer.drawLayer({\n            moduleParameters,\n            uniforms: {\n              layerIndex: layerRenderIndex\n            },\n            parameters: layerParameters\n          });\n        } catch (err) {\n          layer.raiseError(err, \"drawing \".concat(layer, \" to \").concat(pass));\n        }\n      }\n    }\n\n    return renderStatus;\n  }\n\n  shouldDrawLayer(layer) {\n    return true;\n  }\n\n  getModuleParameters(layer, effects) {\n    return null;\n  }\n\n  getLayerParameters(layer, layerIndex) {\n    return layer.props.parameters;\n  }\n\n  _shouldDrawLayer(layer, drawContext, layerFilter) {\n    const shouldDrawLayer = this.shouldDrawLayer(layer) && layer.props.visible;\n\n    if (!shouldDrawLayer) {\n      return false;\n    }\n\n    drawContext.layer = layer;\n\n    if (layerFilter && !layerFilter(drawContext)) {\n      return false;\n    }\n\n    let parent = layer.parent;\n\n    while (parent) {\n      if (!parent.filterSubLayer(drawContext)) {\n        return false;\n      }\n\n      drawContext.layer = parent;\n      parent = parent.parent;\n    }\n\n    layer.activateViewport(drawContext.viewport);\n    return true;\n  }\n\n  _getModuleParameters(layer, effects, pass, overrides) {\n    const moduleParameters = Object.assign(Object.create(layer.props), {\n      autoWrapLongitude: layer.wrapLongitude,\n      viewport: layer.context.viewport,\n      mousePosition: layer.context.mousePosition,\n      pickingActive: 0,\n      devicePixelRatio: Object(_luma_gl_core__WEBPACK_IMPORTED_MODULE_1__[\"cssToDeviceRatio\"])(this.gl)\n    });\n\n    if (effects) {\n      for (const effect of effects) {\n        Object.assign(moduleParameters, effect.getModuleParameters(layer));\n      }\n    }\n\n    return Object.assign(moduleParameters, this.getModuleParameters(layer, effects), overrides);\n  }\n\n}\nfunction layerIndexResolver(startIndex = 0, layerIndices = {}) {\n  const resolvers = {};\n\n  const resolveLayerIndex = (layer, isDrawn) => {\n    const indexOverride = layer.props._offset;\n    const layerId = layer.id;\n    const parentId = layer.parent && layer.parent.id;\n    let index;\n\n    if (parentId && !(parentId in layerIndices)) {\n      resolveLayerIndex(layer.parent, false);\n    }\n\n    if (parentId in resolvers) {\n      const resolver = resolvers[parentId] = resolvers[parentId] || layerIndexResolver(layerIndices[parentId], layerIndices);\n      index = resolver(layer, isDrawn);\n      resolvers[layerId] = resolver;\n    } else if (Number.isFinite(indexOverride)) {\n      index = indexOverride + (layerIndices[parentId] || 0);\n      resolvers[layerId] = null;\n    } else {\n      index = startIndex;\n    }\n\n    if (isDrawn && index >= startIndex) {\n      startIndex = index + 1;\n    }\n\n    layerIndices[layerId] = index;\n    return index;\n  };\n\n  return resolveLayerIndex;\n}\n\nfunction getGLViewport(gl, {\n  viewport\n}) {\n  const height = gl.canvas ? gl.canvas.clientHeight || gl.canvas.height : 100;\n  const dimensions = viewport;\n  const pixelRatio = Object(_luma_gl_core__WEBPACK_IMPORTED_MODULE_1__[\"cssToDeviceRatio\"])(gl);\n  return [dimensions.x * pixelRatio, (height - dimensions.y - dimensions.height) * pixelRatio, dimensions.width * pixelRatio, dimensions.height * pixelRatio];\n}\n\nfunction clearGLCanvas(gl) {\n  const width = gl.drawingBufferWidth;\n  const height = gl.drawingBufferHeight;\n  Object(_luma_gl_core__WEBPACK_IMPORTED_MODULE_1__[\"setParameters\"])(gl, {\n    viewport: [0, 0, width, height]\n  });\n  gl.clear(16384 | 256);\n}\n//# sourceMappingURL=layers-pass.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/passes/layers-pass.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/passes/pass.js":
/*!************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/passes/pass.js ***!
  \************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return Pass; });\nclass Pass {\n  constructor(gl, props = {}) {\n    const {\n      id = 'pass'\n    } = props;\n    this.id = id;\n    this.gl = gl;\n    this.props = { ...props\n    };\n  }\n\n  setProps(props) {\n    Object.assign(this.props, props);\n  }\n\n  render() {}\n\n  cleanup() {}\n\n}\n//# sourceMappingURL=pass.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS9wYXNzZXMvcGFzcy5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9AZGVjay5nbC9jb3JlL2Rpc3QvZXNtL3Bhc3Nlcy9wYXNzLmpzPzk4MmYiXSwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IGRlZmF1bHQgY2xhc3MgUGFzcyB7XG4gIGNvbnN0cnVjdG9yKGdsLCBwcm9wcyA9IHt9KSB7XG4gICAgY29uc3Qge1xuICAgICAgaWQgPSAncGFzcydcbiAgICB9ID0gcHJvcHM7XG4gICAgdGhpcy5pZCA9IGlkO1xuICAgIHRoaXMuZ2wgPSBnbDtcbiAgICB0aGlzLnByb3BzID0geyAuLi5wcm9wc1xuICAgIH07XG4gIH1cblxuICBzZXRQcm9wcyhwcm9wcykge1xuICAgIE9iamVjdC5hc3NpZ24odGhpcy5wcm9wcywgcHJvcHMpO1xuICB9XG5cbiAgcmVuZGVyKCkge31cblxuICBjbGVhbnVwKCkge31cblxufVxuLy8jIHNvdXJjZU1hcHBpbmdVUkw9cGFzcy5qcy5tYXAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/passes/pass.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/passes/pick-layers-pass.js":
/*!************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/passes/pick-layers-pass.js ***!
  \************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return PickLayersPass; });\n/* harmony import */ var _layers_pass__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./layers-pass */ \"./node_modules/@deck.gl/core/dist/esm/passes/layers-pass.js\");\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/gltools/dist/esm/index.js\");\n\n\nconst PICKING_PARAMETERS = {\n  blendFunc: [1, 0, 32771, 0],\n  blendEquation: 32774\n};\nclass PickLayersPass extends _layers_pass__WEBPACK_IMPORTED_MODULE_0__[\"default\"] {\n  render(props) {\n    if (props.pickingFBO) {\n      this.useAlpha = true;\n\n      this._drawPickingBuffer(props);\n    } else {\n      this.useAlpha = false;\n      super.render(props);\n    }\n  }\n\n  _drawPickingBuffer({\n    layers,\n    layerFilter,\n    views,\n    viewports,\n    onViewportActive,\n    pickingFBO,\n    deviceRect: {\n      x,\n      y,\n      width,\n      height\n    },\n    pass = 'picking',\n    redrawReason,\n    pickZ\n  }) {\n    const gl = this.gl;\n    this.pickZ = pickZ;\n    return Object(_luma_gl_core__WEBPACK_IMPORTED_MODULE_1__[\"withParameters\"])(gl, {\n      scissorTest: true,\n      scissor: [x, y, width, height],\n      clearColor: [0, 0, 0, 0],\n      depthMask: true,\n      depthTest: true,\n      depthRange: [0, 1],\n      colorMask: [true, true, true, true],\n      ...PICKING_PARAMETERS,\n      blend: !pickZ\n    }, () => {\n      super.render({\n        target: pickingFBO,\n        layers,\n        layerFilter,\n        views,\n        viewports,\n        onViewportActive,\n        pass,\n        redrawReason\n      });\n    });\n  }\n\n  shouldDrawLayer(layer) {\n    return layer.props.pickable;\n  }\n\n  getModuleParameters() {\n    return {\n      pickingActive: 1,\n      pickingAttribute: this.pickZ,\n      lightSources: {}\n    };\n  }\n\n  getLayerParameters(layer, layerIndex) {\n    const pickParameters = this.pickZ ? {\n      blend: false\n    } : { ...PICKING_PARAMETERS,\n      blend: true,\n      blendColor: [0, 0, 0, this.useAlpha ? (layerIndex + 1) / 255 : 1]\n    };\n    return { ...layer.props.parameters,\n      ...pickParameters\n    };\n  }\n\n}\n//# sourceMappingURL=pick-layers-pass.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS9wYXNzZXMvcGljay1sYXllcnMtcGFzcy5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9AZGVjay5nbC9jb3JlL2Rpc3QvZXNtL3Bhc3Nlcy9waWNrLWxheWVycy1wYXNzLmpzPzhiMDIiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IExheWVyc1Bhc3MgZnJvbSAnLi9sYXllcnMtcGFzcyc7XG5pbXBvcnQgeyB3aXRoUGFyYW1ldGVycyB9IGZyb20gJ0BsdW1hLmdsL2NvcmUnO1xuY29uc3QgUElDS0lOR19QQVJBTUVURVJTID0ge1xuICBibGVuZEZ1bmM6IFsxLCAwLCAzMjc3MSwgMF0sXG4gIGJsZW5kRXF1YXRpb246IDMyNzc0XG59O1xuZXhwb3J0IGRlZmF1bHQgY2xhc3MgUGlja0xheWVyc1Bhc3MgZXh0ZW5kcyBMYXllcnNQYXNzIHtcbiAgcmVuZGVyKHByb3BzKSB7XG4gICAgaWYgKHByb3BzLnBpY2tpbmdGQk8pIHtcbiAgICAgIHRoaXMudXNlQWxwaGEgPSB0cnVlO1xuXG4gICAgICB0aGlzLl9kcmF3UGlja2luZ0J1ZmZlcihwcm9wcyk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHRoaXMudXNlQWxwaGEgPSBmYWxzZTtcbiAgICAgIHN1cGVyLnJlbmRlcihwcm9wcyk7XG4gICAgfVxuICB9XG5cbiAgX2RyYXdQaWNraW5nQnVmZmVyKHtcbiAgICBsYXllcnMsXG4gICAgbGF5ZXJGaWx0ZXIsXG4gICAgdmlld3MsXG4gICAgdmlld3BvcnRzLFxuICAgIG9uVmlld3BvcnRBY3RpdmUsXG4gICAgcGlja2luZ0ZCTyxcbiAgICBkZXZpY2VSZWN0OiB7XG4gICAgICB4LFxuICAgICAgeSxcbiAgICAgIHdpZHRoLFxuICAgICAgaGVpZ2h0XG4gICAgfSxcbiAgICBwYXNzID0gJ3BpY2tpbmcnLFxuICAgIHJlZHJhd1JlYXNvbixcbiAgICBwaWNrWlxuICB9KSB7XG4gICAgY29uc3QgZ2wgPSB0aGlzLmdsO1xuICAgIHRoaXMucGlja1ogPSBwaWNrWjtcbiAgICByZXR1cm4gd2l0aFBhcmFtZXRlcnMoZ2wsIHtcbiAgICAgIHNjaXNzb3JUZXN0OiB0cnVlLFxuICAgICAgc2Npc3NvcjogW3gsIHksIHdpZHRoLCBoZWlnaHRdLFxuICAgICAgY2xlYXJDb2xvcjogWzAsIDAsIDAsIDBdLFxuICAgICAgZGVwdGhNYXNrOiB0cnVlLFxuICAgICAgZGVwdGhUZXN0OiB0cnVlLFxuICAgICAgZGVwdGhSYW5nZTogWzAsIDFdLFxuICAgICAgY29sb3JNYXNrOiBbdHJ1ZSwgdHJ1ZSwgdHJ1ZSwgdHJ1ZV0sXG4gICAgICAuLi5QSUNLSU5HX1BBUkFNRVRFUlMsXG4gICAgICBibGVuZDogIXBpY2taXG4gICAgfSwgKCkgPT4ge1xuICAgICAgc3VwZXIucmVuZGVyKHtcbiAgICAgICAgdGFyZ2V0OiBwaWNraW5nRkJPLFxuICAgICAgICBsYXllcnMsXG4gICAgICAgIGxheWVyRmlsdGVyLFxuICAgICAgICB2aWV3cyxcbiAgICAgICAgdmlld3BvcnRzLFxuICAgICAgICBvblZpZXdwb3J0QWN0aXZlLFxuICAgICAgICBwYXNzLFxuICAgICAgICByZWRyYXdSZWFzb25cbiAgICAgIH0pO1xuICAgIH0pO1xuICB9XG5cbiAgc2hvdWxkRHJhd0xheWVyKGxheWVyKSB7XG4gICAgcmV0dXJuIGxheWVyLnByb3BzLnBpY2thYmxlO1xuICB9XG5cbiAgZ2V0TW9kdWxlUGFyYW1ldGVycygpIHtcbiAgICByZXR1cm4ge1xuICAgICAgcGlja2luZ0FjdGl2ZTogMSxcbiAgICAgIHBpY2tpbmdBdHRyaWJ1dGU6IHRoaXMucGlja1osXG4gICAgICBsaWdodFNvdXJjZXM6IHt9XG4gICAgfTtcbiAgfVxuXG4gIGdldExheWVyUGFyYW1ldGVycyhsYXllciwgbGF5ZXJJbmRleCkge1xuICAgIGNvbnN0IHBpY2tQYXJhbWV0ZXJzID0gdGhpcy5waWNrWiA/IHtcbiAgICAgIGJsZW5kOiBmYWxzZVxuICAgIH0gOiB7IC4uLlBJQ0tJTkdfUEFSQU1FVEVSUyxcbiAgICAgIGJsZW5kOiB0cnVlLFxuICAgICAgYmxlbmRDb2xvcjogWzAsIDAsIDAsIHRoaXMudXNlQWxwaGEgPyAobGF5ZXJJbmRleCArIDEpIC8gMjU1IDogMV1cbiAgICB9O1xuICAgIHJldHVybiB7IC4uLmxheWVyLnByb3BzLnBhcmFtZXRlcnMsXG4gICAgICAuLi5waWNrUGFyYW1ldGVyc1xuICAgIH07XG4gIH1cblxufVxuLy8jIHNvdXJjZU1hcHBpbmdVUkw9cGljay1sYXllcnMtcGFzcy5qcy5tYXAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/passes/pick-layers-pass.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/passes/shadow-pass.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/passes/shadow-pass.js ***!
  \*******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return ShadowPass; });\n/* harmony import */ var _layers_pass__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./layers-pass */ \"./node_modules/@deck.gl/core/dist/esm/passes/layers-pass.js\");\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/webgl/dist/esm/classes/texture-2d.js\");\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/webgl/dist/esm/classes/renderbuffer.js\");\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/webgl/dist/esm/classes/framebuffer.js\");\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/gltools/dist/esm/index.js\");\n\n\nclass ShadowPass extends _layers_pass__WEBPACK_IMPORTED_MODULE_0__[\"default\"] {\n  constructor(gl, props) {\n    super(gl, props);\n    this.shadowMap = new _luma_gl_core__WEBPACK_IMPORTED_MODULE_1__[\"default\"](gl, {\n      width: 1,\n      height: 1,\n      parameters: {\n        [10241]: 9729,\n        [10240]: 9729,\n        [10242]: 33071,\n        [10243]: 33071\n      }\n    });\n    this.depthBuffer = new _luma_gl_core__WEBPACK_IMPORTED_MODULE_2__[\"default\"](gl, {\n      format: 33189,\n      width: 1,\n      height: 1\n    });\n    this.fbo = new _luma_gl_core__WEBPACK_IMPORTED_MODULE_3__[\"default\"](gl, {\n      id: 'shadowmap',\n      width: 1,\n      height: 1,\n      attachments: {\n        [36064]: this.shadowMap,\n        [36096]: this.depthBuffer\n      }\n    });\n  }\n\n  render(params) {\n    const target = this.fbo;\n    Object(_luma_gl_core__WEBPACK_IMPORTED_MODULE_4__[\"withParameters\"])(this.gl, {\n      depthRange: [0, 1],\n      depthTest: true,\n      blend: false,\n      clearColor: [1, 1, 1, 1]\n    }, () => {\n      const viewport = params.viewports[0];\n      const pixelRatio = Object(_luma_gl_core__WEBPACK_IMPORTED_MODULE_4__[\"cssToDeviceRatio\"])(this.gl);\n      const width = viewport.width * pixelRatio;\n      const height = viewport.height * pixelRatio;\n\n      if (width !== target.width || height !== target.height) {\n        target.resize({\n          width,\n          height\n        });\n      }\n\n      super.render({ ...params,\n        target,\n        pass: 'shadow'\n      });\n    });\n  }\n\n  shouldDrawLayer(layer) {\n    return layer.props.shadowEnabled !== false;\n  }\n\n  getModuleParameters() {\n    return {\n      drawToShadowMap: true\n    };\n  }\n\n  delete() {\n    if (this.fbo) {\n      this.fbo.delete();\n      this.fbo = null;\n    }\n\n    if (this.shadowMap) {\n      this.shadowMap.delete();\n      this.shadowMap = null;\n    }\n\n    if (this.depthBuffer) {\n      this.depthBuffer.delete();\n      this.depthBuffer = null;\n    }\n  }\n\n}\n//# sourceMappingURL=shadow-pass.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/passes/shadow-pass.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/shaderlib/index.js":
/*!****************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/shaderlib/index.js ***!
  \****************************************************************/
/*! exports provided: createProgramManager, picking, project, project32, gouraudLighting, phongLighting, shadow */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"createProgramManager\", function() { return createProgramManager; });\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/engine/dist/esm/lib/program-manager.js\");\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/shadertools/dist/esm/modules/phong-lighting/phong-lighting.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"gouraudLighting\", function() { return _luma_gl_core__WEBPACK_IMPORTED_MODULE_1__[\"gouraudLighting\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"phongLighting\", function() { return _luma_gl_core__WEBPACK_IMPORTED_MODULE_1__[\"phongLighting\"]; });\n\n/* harmony import */ var _misc_geometry__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./misc/geometry */ \"./node_modules/@deck.gl/core/dist/esm/shaderlib/misc/geometry.js\");\n/* harmony import */ var _project_project__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./project/project */ \"./node_modules/@deck.gl/core/dist/esm/shaderlib/project/project.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"project\", function() { return _project_project__WEBPACK_IMPORTED_MODULE_3__[\"default\"]; });\n\n/* harmony import */ var _project32_project32__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./project32/project32 */ \"./node_modules/@deck.gl/core/dist/esm/shaderlib/project32/project32.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"project32\", function() { return _project32_project32__WEBPACK_IMPORTED_MODULE_4__[\"default\"]; });\n\n/* harmony import */ var _shadow_shadow__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./shadow/shadow */ \"./node_modules/@deck.gl/core/dist/esm/shaderlib/shadow/shadow.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"shadow\", function() { return _shadow_shadow__WEBPACK_IMPORTED_MODULE_5__[\"default\"]; });\n\n/* harmony import */ var _picking_picking__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./picking/picking */ \"./node_modules/@deck.gl/core/dist/esm/shaderlib/picking/picking.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"picking\", function() { return _picking_picking__WEBPACK_IMPORTED_MODULE_6__[\"default\"]; });\n\n\n\n\n\n\n\n\nconst DEFAULT_MODULES = [_misc_geometry__WEBPACK_IMPORTED_MODULE_2__[\"default\"], _project_project__WEBPACK_IMPORTED_MODULE_3__[\"default\"]];\nconst SHADER_HOOKS = ['vs:DECKGL_FILTER_SIZE(inout vec3 size, VertexGeometry geometry)', 'vs:DECKGL_FILTER_GL_POSITION(inout vec4 position, VertexGeometry geometry)', 'vs:DECKGL_FILTER_COLOR(inout vec4 color, VertexGeometry geometry)', 'fs:DECKGL_FILTER_COLOR(inout vec4 color, FragmentGeometry geometry)'];\nfunction createProgramManager(gl) {\n  const programManager = _luma_gl_core__WEBPACK_IMPORTED_MODULE_0__[\"default\"].getDefaultProgramManager(gl);\n\n  for (const shaderModule of DEFAULT_MODULES) {\n    programManager.addDefaultModule(shaderModule);\n  }\n\n  for (const shaderHook of SHADER_HOOKS) {\n    programManager.addShaderHook(shaderHook);\n  }\n\n  return programManager;\n}\n\n//# sourceMappingURL=index.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/shaderlib/index.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/shaderlib/misc/geometry.js":
/*!************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/shaderlib/misc/geometry.js ***!
  \************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nconst vs = \"\\nstruct VertexGeometry {\\n  vec4 position;\\n  vec3 worldPosition;\\n  vec3 worldPositionAlt;\\n  vec3 normal;\\n  vec2 uv;\\n  vec3 pickingColor;\\n} geometry;\\n\";\nconst fs = \"\\n#define SMOOTH_EDGE_RADIUS 0.5\\n\\nstruct FragmentGeometry {\\n  vec2 uv;\\n} geometry;\\n\\nfloat smoothedge(float edge, float x) {\\n  return smoothstep(edge - SMOOTH_EDGE_RADIUS, edge + SMOOTH_EDGE_RADIUS, x);\\n}\\n\";\n/* harmony default export */ __webpack_exports__[\"default\"] = ({\n  name: 'geometry',\n  vs,\n  fs\n});\n//# sourceMappingURL=geometry.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS9zaGFkZXJsaWIvbWlzYy9nZW9tZXRyeS5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9AZGVjay5nbC9jb3JlL2Rpc3QvZXNtL3NoYWRlcmxpYi9taXNjL2dlb21ldHJ5LmpzPzI0NjgiXSwic291cmNlc0NvbnRlbnQiOlsiY29uc3QgdnMgPSBcIlxcbnN0cnVjdCBWZXJ0ZXhHZW9tZXRyeSB7XFxuICB2ZWM0IHBvc2l0aW9uO1xcbiAgdmVjMyB3b3JsZFBvc2l0aW9uO1xcbiAgdmVjMyB3b3JsZFBvc2l0aW9uQWx0O1xcbiAgdmVjMyBub3JtYWw7XFxuICB2ZWMyIHV2O1xcbiAgdmVjMyBwaWNraW5nQ29sb3I7XFxufSBnZW9tZXRyeTtcXG5cIjtcbmNvbnN0IGZzID0gXCJcXG4jZGVmaW5lIFNNT09USF9FREdFX1JBRElVUyAwLjVcXG5cXG5zdHJ1Y3QgRnJhZ21lbnRHZW9tZXRyeSB7XFxuICB2ZWMyIHV2O1xcbn0gZ2VvbWV0cnk7XFxuXFxuZmxvYXQgc21vb3RoZWRnZShmbG9hdCBlZGdlLCBmbG9hdCB4KSB7XFxuICByZXR1cm4gc21vb3Roc3RlcChlZGdlIC0gU01PT1RIX0VER0VfUkFESVVTLCBlZGdlICsgU01PT1RIX0VER0VfUkFESVVTLCB4KTtcXG59XFxuXCI7XG5leHBvcnQgZGVmYXVsdCB7XG4gIG5hbWU6ICdnZW9tZXRyeScsXG4gIHZzLFxuICBmc1xufTtcbi8vIyBzb3VyY2VNYXBwaW5nVVJMPWdlb21ldHJ5LmpzLm1hcCJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/shaderlib/misc/geometry.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/shaderlib/picking/picking.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/shaderlib/picking/picking.js ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/shadertools/dist/esm/modules/picking/picking.js\");\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ({\n  inject: {\n    'vs:DECKGL_FILTER_COLOR': \"\\n  picking_setPickingColor(geometry.pickingColor);\\n  // for picking depth values\\n  picking_setPickingAttribute(geometry.position.z);\\n  \",\n    'fs:DECKGL_FILTER_COLOR': {\n      order: 99,\n      injection: \"\\n  // use highlight color if this fragment belongs to the selected object.\\n  color = picking_filterHighlightColor(color);\\n\\n  // use picking color if rendering to picking FBO.\\n  color = picking_filterPickingColor(color);\\n    \"\n    }\n  },\n  ..._luma_gl_core__WEBPACK_IMPORTED_MODULE_0__[\"picking\"]\n});\n//# sourceMappingURL=picking.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS9zaGFkZXJsaWIvcGlja2luZy9waWNraW5nLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0BkZWNrLmdsL2NvcmUvZGlzdC9lc20vc2hhZGVybGliL3BpY2tpbmcvcGlja2luZy5qcz8wNTBmIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IHBpY2tpbmcgfSBmcm9tICdAbHVtYS5nbC9jb3JlJztcbmV4cG9ydCBkZWZhdWx0IHtcbiAgaW5qZWN0OiB7XG4gICAgJ3ZzOkRFQ0tHTF9GSUxURVJfQ09MT1InOiBcIlxcbiAgcGlja2luZ19zZXRQaWNraW5nQ29sb3IoZ2VvbWV0cnkucGlja2luZ0NvbG9yKTtcXG4gIC8vIGZvciBwaWNraW5nIGRlcHRoIHZhbHVlc1xcbiAgcGlja2luZ19zZXRQaWNraW5nQXR0cmlidXRlKGdlb21ldHJ5LnBvc2l0aW9uLnopO1xcbiAgXCIsXG4gICAgJ2ZzOkRFQ0tHTF9GSUxURVJfQ09MT1InOiB7XG4gICAgICBvcmRlcjogOTksXG4gICAgICBpbmplY3Rpb246IFwiXFxuICAvLyB1c2UgaGlnaGxpZ2h0IGNvbG9yIGlmIHRoaXMgZnJhZ21lbnQgYmVsb25ncyB0byB0aGUgc2VsZWN0ZWQgb2JqZWN0LlxcbiAgY29sb3IgPSBwaWNraW5nX2ZpbHRlckhpZ2hsaWdodENvbG9yKGNvbG9yKTtcXG5cXG4gIC8vIHVzZSBwaWNraW5nIGNvbG9yIGlmIHJlbmRlcmluZyB0byBwaWNraW5nIEZCTy5cXG4gIGNvbG9yID0gcGlja2luZ19maWx0ZXJQaWNraW5nQ29sb3IoY29sb3IpO1xcbiAgICBcIlxuICAgIH1cbiAgfSxcbiAgLi4ucGlja2luZ1xufTtcbi8vIyBzb3VyY2VNYXBwaW5nVVJMPXBpY2tpbmcuanMubWFwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/shaderlib/picking/picking.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/shaderlib/project/project-functions.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/shaderlib/project/project-functions.js ***!
  \************************************************************************************/
/*! exports provided: getWorldPosition, projectPosition */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getWorldPosition\", function() { return getWorldPosition; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"projectPosition\", function() { return projectPosition; });\n/* harmony import */ var _lib_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../lib/constants */ \"./node_modules/@deck.gl/core/dist/esm/lib/constants.js\");\n/* harmony import */ var _viewport_uniforms__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./viewport-uniforms */ \"./node_modules/@deck.gl/core/dist/esm/shaderlib/project/viewport-uniforms.js\");\n/* harmony import */ var _viewports_web_mercator_viewport__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../viewports/web-mercator-viewport */ \"./node_modules/@deck.gl/core/dist/esm/viewports/web-mercator-viewport.js\");\n/* harmony import */ var gl_matrix_vec4__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! gl-matrix/vec4 */ \"./node_modules/gl-matrix/esm/vec4.js\");\n/* harmony import */ var gl_matrix_vec3__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! gl-matrix/vec3 */ \"./node_modules/gl-matrix/esm/vec3.js\");\n/* harmony import */ var _math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @math.gl/web-mercator */ \"./node_modules/@math.gl/web-mercator/dist/esm/index.js\");\n\n\n\n\n\n\n\nfunction lngLatZToWorldPosition(lngLatZ, viewport, offsetMode = false) {\n  const p = viewport.projectPosition(lngLatZ);\n\n  if (offsetMode && viewport instanceof _viewports_web_mercator_viewport__WEBPACK_IMPORTED_MODULE_2__[\"default\"]) {\n    const [longitude, latitude, z = 0] = lngLatZ;\n    const distanceScales = viewport.getDistanceScales([longitude, latitude]);\n    p[2] = z * distanceScales.unitsPerMeter[2];\n  }\n\n  return p;\n}\n\nfunction normalizeParameters(opts) {\n  const normalizedParams = { ...opts\n  };\n  let {\n    coordinateSystem\n  } = opts;\n  const {\n    viewport,\n    coordinateOrigin,\n    fromCoordinateSystem,\n    fromCoordinateOrigin\n  } = opts;\n\n  if (coordinateSystem === _lib_constants__WEBPACK_IMPORTED_MODULE_0__[\"COORDINATE_SYSTEM\"].DEFAULT) {\n    coordinateSystem = viewport.isGeospatial ? _lib_constants__WEBPACK_IMPORTED_MODULE_0__[\"COORDINATE_SYSTEM\"].LNGLAT : _lib_constants__WEBPACK_IMPORTED_MODULE_0__[\"COORDINATE_SYSTEM\"].CARTESIAN;\n  }\n\n  if (fromCoordinateSystem === undefined) {\n    normalizedParams.fromCoordinateSystem = coordinateSystem;\n  }\n\n  if (fromCoordinateOrigin === undefined) {\n    normalizedParams.fromCoordinateOrigin = coordinateOrigin;\n  }\n\n  normalizedParams.coordinateSystem = coordinateSystem;\n  return normalizedParams;\n}\n\nfunction getWorldPosition(position, {\n  viewport,\n  modelMatrix,\n  coordinateSystem,\n  coordinateOrigin,\n  offsetMode\n}) {\n  let [x, y, z = 0] = position;\n\n  if (modelMatrix) {\n    [x, y, z] = gl_matrix_vec4__WEBPACK_IMPORTED_MODULE_3__[\"transformMat4\"]([], [x, y, z, 1.0], modelMatrix);\n  }\n\n  switch (coordinateSystem) {\n    case _lib_constants__WEBPACK_IMPORTED_MODULE_0__[\"COORDINATE_SYSTEM\"].LNGLAT:\n      return lngLatZToWorldPosition([x, y, z], viewport, offsetMode);\n\n    case _lib_constants__WEBPACK_IMPORTED_MODULE_0__[\"COORDINATE_SYSTEM\"].LNGLAT_OFFSETS:\n      return lngLatZToWorldPosition([x + coordinateOrigin[0], y + coordinateOrigin[1], z + (coordinateOrigin[2] || 0)], viewport, offsetMode);\n\n    case _lib_constants__WEBPACK_IMPORTED_MODULE_0__[\"COORDINATE_SYSTEM\"].METER_OFFSETS:\n      return lngLatZToWorldPosition(Object(_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_5__[\"addMetersToLngLat\"])(coordinateOrigin, [x, y, z]), viewport, offsetMode);\n\n    case _lib_constants__WEBPACK_IMPORTED_MODULE_0__[\"COORDINATE_SYSTEM\"].CARTESIAN:\n    default:\n      return viewport.isGeospatial ? [x + coordinateOrigin[0], y + coordinateOrigin[1], z + coordinateOrigin[2]] : viewport.projectPosition([x, y, z]);\n  }\n}\nfunction projectPosition(position, params) {\n  const {\n    viewport,\n    coordinateSystem,\n    coordinateOrigin,\n    modelMatrix,\n    fromCoordinateSystem,\n    fromCoordinateOrigin\n  } = normalizeParameters(params);\n  const {\n    geospatialOrigin,\n    shaderCoordinateOrigin,\n    offsetMode\n  } = Object(_viewport_uniforms__WEBPACK_IMPORTED_MODULE_1__[\"getOffsetOrigin\"])(viewport, coordinateSystem, coordinateOrigin);\n  const worldPosition = getWorldPosition(position, {\n    viewport,\n    modelMatrix,\n    coordinateSystem: fromCoordinateSystem,\n    coordinateOrigin: fromCoordinateOrigin,\n    offsetMode\n  });\n\n  if (offsetMode) {\n    const positionCommonSpace = viewport.projectPosition(geospatialOrigin || shaderCoordinateOrigin);\n    gl_matrix_vec3__WEBPACK_IMPORTED_MODULE_4__[\"sub\"](worldPosition, worldPosition, positionCommonSpace);\n  }\n\n  return worldPosition;\n}\n//# sourceMappingURL=project-functions.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/shaderlib/project/project-functions.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/shaderlib/project/project.glsl.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/shaderlib/project/project.glsl.js ***!
  \*******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _lib_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../lib/constants */ \"./node_modules/@deck.gl/core/dist/esm/lib/constants.js\");\n\nconst COORDINATE_SYSTEM_GLSL_CONSTANTS = Object.keys(_lib_constants__WEBPACK_IMPORTED_MODULE_0__[\"COORDINATE_SYSTEM\"]).map(key => \"const int COORDINATE_SYSTEM_\".concat(key, \" = \").concat(_lib_constants__WEBPACK_IMPORTED_MODULE_0__[\"COORDINATE_SYSTEM\"][key], \";\")).join('');\nconst PROJECTION_MODE_GLSL_CONSTANTS = Object.keys(_lib_constants__WEBPACK_IMPORTED_MODULE_0__[\"PROJECTION_MODE\"]).map(key => \"const int PROJECTION_MODE_\".concat(key, \" = \").concat(_lib_constants__WEBPACK_IMPORTED_MODULE_0__[\"PROJECTION_MODE\"][key], \";\")).join('');\n/* harmony default export */ __webpack_exports__[\"default\"] = (\"\".concat(COORDINATE_SYSTEM_GLSL_CONSTANTS, \"\\n\").concat(PROJECTION_MODE_GLSL_CONSTANTS, \"\\n\\nuniform int project_uCoordinateSystem;\\nuniform int project_uProjectionMode;\\nuniform float project_uScale;\\nuniform bool project_uWrapLongitude;\\nuniform vec3 project_uCommonUnitsPerMeter;\\nuniform vec3 project_uCommonUnitsPerWorldUnit;\\nuniform vec3 project_uCommonUnitsPerWorldUnit2;\\nuniform vec4 project_uCenter;\\nuniform mat4 project_uModelMatrix;\\nuniform mat4 project_uViewProjectionMatrix;\\nuniform vec2 project_uViewportSize;\\nuniform float project_uDevicePixelRatio;\\nuniform float project_uFocalDistance;\\nuniform vec3 project_uCameraPosition;\\nuniform vec3 project_uCoordinateOrigin;\\n\\nconst float TILE_SIZE = 512.0;\\nconst float PI = 3.1415926536;\\nconst float WORLD_SCALE = TILE_SIZE / (PI * 2.0);\\nconst vec3 ZERO_64_LOW = vec3(0.0);\\nconst float EARTH_RADIUS = 6370972.0;\\nconst float GLOBE_RADIUS = 256.0;\\nfloat project_size(float meters) {\\n  return meters * project_uCommonUnitsPerMeter.z;\\n}\\n\\nvec2 project_size(vec2 meters) {\\n  return meters * project_uCommonUnitsPerMeter.xy;\\n}\\n\\nvec3 project_size(vec3 meters) {\\n  return meters * project_uCommonUnitsPerMeter;\\n}\\n\\nvec4 project_size(vec4 meters) {\\n  return vec4(meters.xyz * project_uCommonUnitsPerMeter, meters.w);\\n}\\nvec3 project_normal(vec3 vector) {\\n  vec4 normal_modelspace = project_uModelMatrix * vec4(vector, 0.0);\\n  return normalize(normal_modelspace.xyz * project_uCommonUnitsPerMeter);\\n}\\n\\nvec4 project_offset_(vec4 offset) {\\n  float dy = offset.y;\\n  if (project_uCoordinateSystem == COORDINATE_SYSTEM_LNGLAT) {\\n    dy = clamp(dy, -1., 1.);\\n  }\\n  vec3 commonUnitsPerWorldUnit = project_uCommonUnitsPerWorldUnit + project_uCommonUnitsPerWorldUnit2 * dy;\\n  return vec4(offset.xyz * commonUnitsPerWorldUnit, offset.w);\\n}\\nvec2 project_mercator_(vec2 lnglat) {\\n  float x = lnglat.x;\\n  if (project_uWrapLongitude) {\\n    x = mod(x + 180., 360.0) - 180.;\\n  }\\n  float y = clamp(lnglat.y, -89.9, 89.9);\\n  return vec2(\\n    radians(x) + PI,\\n    PI + log(tan_fp32(PI * 0.25 + radians(y) * 0.5))\\n  );\\n}\\n\\nvec3 project_globe_(vec3 lnglatz) {\\n  float lambda = radians(lnglatz.x);\\n  float phi = radians(lnglatz.y);\\n  float cosPhi = cos(phi);\\n  float D = (lnglatz.z / EARTH_RADIUS + 1.0) * GLOBE_RADIUS;\\n\\n  return vec3(\\n    sin(lambda) * cosPhi,\\n    -cos(lambda) * cosPhi,\\n    sin(phi)\\n  ) * D;\\n}\\nvec4 project_position(vec4 position, vec3 position64Low) {\\n  vec4 position_world = project_uModelMatrix * position;\\n  if (project_uProjectionMode == PROJECTION_MODE_WEB_MERCATOR) {\\n    if (project_uCoordinateSystem == COORDINATE_SYSTEM_LNGLAT) {\\n      return vec4(\\n        project_mercator_(position_world.xy) * WORLD_SCALE,\\n        project_size(position_world.z),\\n        position_world.w\\n      );\\n    }\\n    if (project_uCoordinateSystem == COORDINATE_SYSTEM_CARTESIAN) {\\n      position_world.xyz += project_uCoordinateOrigin;\\n    }\\n  }\\n  if (project_uProjectionMode == PROJECTION_MODE_GLOBE) {\\n    if (project_uCoordinateSystem == COORDINATE_SYSTEM_LNGLAT) {\\n      return vec4(\\n        project_globe_(position_world.xyz),\\n        position_world.w\\n      );\\n    }\\n  }\\n  if (project_uProjectionMode == PROJECTION_MODE_IDENTITY ||\\n    (project_uProjectionMode == PROJECTION_MODE_WEB_MERCATOR_AUTO_OFFSET &&\\n    (project_uCoordinateSystem == COORDINATE_SYSTEM_LNGLAT ||\\n     project_uCoordinateSystem == COORDINATE_SYSTEM_CARTESIAN))) {\\n    position_world.xyz -= project_uCoordinateOrigin;\\n  }\\n  return project_offset_(position_world + project_uModelMatrix * vec4(position64Low, 0.0));\\n}\\n\\nvec4 project_position(vec4 position) {\\n  return project_position(position, ZERO_64_LOW);\\n}\\n\\nvec3 project_position(vec3 position, vec3 position64Low) {\\n  vec4 projected_position = project_position(vec4(position, 1.0), position64Low);\\n  return projected_position.xyz;\\n}\\n\\nvec3 project_position(vec3 position) {\\n  vec4 projected_position = project_position(vec4(position, 1.0), ZERO_64_LOW);\\n  return projected_position.xyz;\\n}\\n\\nvec2 project_position(vec2 position) {\\n  vec4 projected_position = project_position(vec4(position, 0.0, 1.0), ZERO_64_LOW);\\n  return projected_position.xy;\\n}\\n\\nvec4 project_common_position_to_clipspace(vec4 position, mat4 viewProjectionMatrix, vec4 center) {\\n  return viewProjectionMatrix * position + center;\\n}\\nvec4 project_common_position_to_clipspace(vec4 position) {\\n  return project_common_position_to_clipspace(position, project_uViewProjectionMatrix, project_uCenter);\\n}\\nvec2 project_pixel_size_to_clipspace(vec2 pixels) {\\n  vec2 offset = pixels / project_uViewportSize * project_uDevicePixelRatio * 2.0;\\n  return offset * project_uFocalDistance;\\n}\\n\\nfloat project_size_to_pixel(float meters) {\\n  return project_size(meters) * project_uScale;\\n}\\nfloat project_pixel_size(float pixels) {\\n  return pixels / project_uScale;\\n}\\nvec2 project_pixel_size(vec2 pixels) {\\n  return pixels / project_uScale;\\n}\\nmat3 project_get_orientation_matrix(vec3 up) {\\n  vec3 uz = normalize(up);\\n  vec3 ux = abs(uz.z) == 1.0 ? vec3(1.0, 0.0, 0.0) : normalize(vec3(uz.y, -uz.x, 0));\\n  vec3 uy = cross(uz, ux);\\n  return mat3(ux, uy, uz);\\n}\\n\\nbool project_needs_rotation(vec3 commonPosition, out mat3 transform) {\\n  if (project_uProjectionMode == PROJECTION_MODE_GLOBE) {\\n    transform = project_get_orientation_matrix(commonPosition);\\n    return true;\\n  }\\n  return false;\\n}\\n\"));\n//# sourceMappingURL=project.glsl.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/shaderlib/project/project.glsl.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/shaderlib/project/project.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/shaderlib/project/project.js ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/shadertools/dist/esm/modules/fp32/fp32.js\");\n/* harmony import */ var _project_glsl__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./project.glsl */ \"./node_modules/@deck.gl/core/dist/esm/shaderlib/project/project.glsl.js\");\n/* harmony import */ var _viewport_uniforms__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./viewport-uniforms */ \"./node_modules/@deck.gl/core/dist/esm/shaderlib/project/viewport-uniforms.js\");\n\n\n\nconst INITIAL_MODULE_OPTIONS = {};\n\nfunction getUniforms(opts = INITIAL_MODULE_OPTIONS) {\n  if (opts.viewport) {\n    return Object(_viewport_uniforms__WEBPACK_IMPORTED_MODULE_2__[\"getUniformsFromViewport\"])(opts);\n  }\n\n  return {};\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ({\n  name: 'project',\n  dependencies: [_luma_gl_core__WEBPACK_IMPORTED_MODULE_0__[\"fp32\"]],\n  vs: _project_glsl__WEBPACK_IMPORTED_MODULE_1__[\"default\"],\n  getUniforms\n});\n//# sourceMappingURL=project.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS9zaGFkZXJsaWIvcHJvamVjdC9wcm9qZWN0LmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0BkZWNrLmdsL2NvcmUvZGlzdC9lc20vc2hhZGVybGliL3Byb2plY3QvcHJvamVjdC5qcz84NDk5Il0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGZwMzIgfSBmcm9tICdAbHVtYS5nbC9jb3JlJztcbmltcG9ydCBwcm9qZWN0U2hhZGVyIGZyb20gJy4vcHJvamVjdC5nbHNsJztcbmltcG9ydCB7IGdldFVuaWZvcm1zRnJvbVZpZXdwb3J0IH0gZnJvbSAnLi92aWV3cG9ydC11bmlmb3Jtcyc7XG5jb25zdCBJTklUSUFMX01PRFVMRV9PUFRJT05TID0ge307XG5cbmZ1bmN0aW9uIGdldFVuaWZvcm1zKG9wdHMgPSBJTklUSUFMX01PRFVMRV9PUFRJT05TKSB7XG4gIGlmIChvcHRzLnZpZXdwb3J0KSB7XG4gICAgcmV0dXJuIGdldFVuaWZvcm1zRnJvbVZpZXdwb3J0KG9wdHMpO1xuICB9XG5cbiAgcmV0dXJuIHt9O1xufVxuXG5leHBvcnQgZGVmYXVsdCB7XG4gIG5hbWU6ICdwcm9qZWN0JyxcbiAgZGVwZW5kZW5jaWVzOiBbZnAzMl0sXG4gIHZzOiBwcm9qZWN0U2hhZGVyLFxuICBnZXRVbmlmb3Jtc1xufTtcbi8vIyBzb3VyY2VNYXBwaW5nVVJMPXByb2plY3QuanMubWFwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/shaderlib/project/project.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/shaderlib/project/viewport-uniforms.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/shaderlib/project/viewport-uniforms.js ***!
  \************************************************************************************/
/*! exports provided: getOffsetOrigin, getUniformsFromViewport */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getOffsetOrigin\", function() { return getOffsetOrigin; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getUniformsFromViewport\", function() { return getUniformsFromViewport; });\n/* harmony import */ var gl_matrix_mat4__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! gl-matrix/mat4 */ \"./node_modules/gl-matrix/esm/mat4.js\");\n/* harmony import */ var gl_matrix_vec4__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! gl-matrix/vec4 */ \"./node_modules/gl-matrix/esm/vec4.js\");\n/* harmony import */ var _lib_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../lib/constants */ \"./node_modules/@deck.gl/core/dist/esm/lib/constants.js\");\n/* harmony import */ var _utils_memoize__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/memoize */ \"./node_modules/@deck.gl/core/dist/esm/utils/memoize.js\");\n\n\n\n\nconst ZERO_VECTOR = [0, 0, 0, 0];\nconst VECTOR_TO_POINT_MATRIX = [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0];\nconst IDENTITY_MATRIX = [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1];\nconst DEFAULT_PIXELS_PER_UNIT2 = [0, 0, 0];\nconst DEFAULT_COORDINATE_ORIGIN = [0, 0, 0];\nconst getMemoizedViewportUniforms = Object(_utils_memoize__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(calculateViewportUniforms);\nfunction getOffsetOrigin(viewport, coordinateSystem, coordinateOrigin = DEFAULT_COORDINATE_ORIGIN) {\n  let shaderCoordinateOrigin = coordinateOrigin;\n  let geospatialOrigin;\n  let offsetMode = true;\n\n  if (coordinateSystem === _lib_constants__WEBPACK_IMPORTED_MODULE_2__[\"COORDINATE_SYSTEM\"].LNGLAT_OFFSETS || coordinateSystem === _lib_constants__WEBPACK_IMPORTED_MODULE_2__[\"COORDINATE_SYSTEM\"].METER_OFFSETS) {\n    geospatialOrigin = coordinateOrigin;\n  } else {\n    geospatialOrigin = viewport.isGeospatial ? [Math.fround(viewport.longitude), Math.fround(viewport.latitude), 0] : null;\n  }\n\n  switch (viewport.projectionMode) {\n    case _lib_constants__WEBPACK_IMPORTED_MODULE_2__[\"PROJECTION_MODE\"].WEB_MERCATOR:\n      if (coordinateSystem === _lib_constants__WEBPACK_IMPORTED_MODULE_2__[\"COORDINATE_SYSTEM\"].LNGLAT || coordinateSystem === _lib_constants__WEBPACK_IMPORTED_MODULE_2__[\"COORDINATE_SYSTEM\"].CARTESIAN) {\n        offsetMode = false;\n      }\n\n      break;\n\n    case _lib_constants__WEBPACK_IMPORTED_MODULE_2__[\"PROJECTION_MODE\"].WEB_MERCATOR_AUTO_OFFSET:\n      if (coordinateSystem === _lib_constants__WEBPACK_IMPORTED_MODULE_2__[\"COORDINATE_SYSTEM\"].LNGLAT) {\n        shaderCoordinateOrigin = geospatialOrigin;\n      } else if (coordinateSystem === _lib_constants__WEBPACK_IMPORTED_MODULE_2__[\"COORDINATE_SYSTEM\"].CARTESIAN) {\n        shaderCoordinateOrigin = [Math.fround(viewport.center[0]), Math.fround(viewport.center[1]), 0];\n        geospatialOrigin = viewport.unprojectPosition(shaderCoordinateOrigin);\n        shaderCoordinateOrigin[0] -= coordinateOrigin[0];\n        shaderCoordinateOrigin[1] -= coordinateOrigin[1];\n        shaderCoordinateOrigin[2] -= coordinateOrigin[2];\n      }\n\n      break;\n\n    case _lib_constants__WEBPACK_IMPORTED_MODULE_2__[\"PROJECTION_MODE\"].IDENTITY:\n      shaderCoordinateOrigin = viewport.position.map(Math.fround);\n      break;\n\n    case _lib_constants__WEBPACK_IMPORTED_MODULE_2__[\"PROJECTION_MODE\"].GLOBE:\n      offsetMode = false;\n      geospatialOrigin = null;\n      break;\n\n    default:\n      offsetMode = false;\n  }\n\n  shaderCoordinateOrigin[2] = shaderCoordinateOrigin[2] || 0;\n  return {\n    geospatialOrigin,\n    shaderCoordinateOrigin,\n    offsetMode\n  };\n}\n\nfunction calculateMatrixAndOffset(viewport, coordinateSystem, coordinateOrigin) {\n  const {\n    viewMatrixUncentered,\n    projectionMatrix\n  } = viewport;\n  let {\n    viewMatrix,\n    viewProjectionMatrix\n  } = viewport;\n  let projectionCenter = ZERO_VECTOR;\n  let cameraPosCommon = viewport.cameraPosition;\n  const {\n    geospatialOrigin,\n    shaderCoordinateOrigin,\n    offsetMode\n  } = getOffsetOrigin(viewport, coordinateSystem, coordinateOrigin);\n\n  if (offsetMode) {\n    const positionCommonSpace = viewport.projectPosition(geospatialOrigin || shaderCoordinateOrigin);\n    cameraPosCommon = [cameraPosCommon[0] - positionCommonSpace[0], cameraPosCommon[1] - positionCommonSpace[1], cameraPosCommon[2] - positionCommonSpace[2]];\n    positionCommonSpace[3] = 1;\n    projectionCenter = gl_matrix_vec4__WEBPACK_IMPORTED_MODULE_1__[\"transformMat4\"]([], positionCommonSpace, viewProjectionMatrix);\n    viewMatrix = viewMatrixUncentered || viewMatrix;\n    viewProjectionMatrix = gl_matrix_mat4__WEBPACK_IMPORTED_MODULE_0__[\"multiply\"]([], projectionMatrix, viewMatrix);\n    viewProjectionMatrix = gl_matrix_mat4__WEBPACK_IMPORTED_MODULE_0__[\"multiply\"]([], viewProjectionMatrix, VECTOR_TO_POINT_MATRIX);\n  }\n\n  return {\n    viewMatrix,\n    viewProjectionMatrix,\n    projectionCenter,\n    cameraPosCommon,\n    shaderCoordinateOrigin,\n    geospatialOrigin\n  };\n}\n\nfunction getUniformsFromViewport({\n  viewport,\n  devicePixelRatio = 1,\n  modelMatrix = null,\n  coordinateSystem = _lib_constants__WEBPACK_IMPORTED_MODULE_2__[\"COORDINATE_SYSTEM\"].DEFAULT,\n  coordinateOrigin,\n  autoWrapLongitude = false\n} = {}) {\n  if (coordinateSystem === _lib_constants__WEBPACK_IMPORTED_MODULE_2__[\"COORDINATE_SYSTEM\"].DEFAULT) {\n    coordinateSystem = viewport.isGeospatial ? _lib_constants__WEBPACK_IMPORTED_MODULE_2__[\"COORDINATE_SYSTEM\"].LNGLAT : _lib_constants__WEBPACK_IMPORTED_MODULE_2__[\"COORDINATE_SYSTEM\"].CARTESIAN;\n  }\n\n  const uniforms = getMemoizedViewportUniforms({\n    viewport,\n    devicePixelRatio,\n    coordinateSystem,\n    coordinateOrigin\n  });\n  uniforms.project_uWrapLongitude = autoWrapLongitude;\n  uniforms.project_uModelMatrix = modelMatrix || IDENTITY_MATRIX;\n  return uniforms;\n}\n\nfunction calculateViewportUniforms({\n  viewport,\n  devicePixelRatio,\n  coordinateSystem,\n  coordinateOrigin\n}) {\n  const {\n    projectionCenter,\n    viewProjectionMatrix,\n    cameraPosCommon,\n    shaderCoordinateOrigin,\n    geospatialOrigin\n  } = calculateMatrixAndOffset(viewport, coordinateSystem, coordinateOrigin);\n  const distanceScales = viewport.getDistanceScales();\n  const viewportSize = [viewport.width * devicePixelRatio, viewport.height * devicePixelRatio];\n  const focalDistance = viewport.projectionMatrix.transform([0, 0, -viewport.focalDistance, 1])[3] || 1;\n  const uniforms = {\n    project_uCoordinateSystem: coordinateSystem,\n    project_uProjectionMode: viewport.projectionMode,\n    project_uCoordinateOrigin: shaderCoordinateOrigin,\n    project_uCenter: projectionCenter,\n    project_uViewportSize: viewportSize,\n    project_uDevicePixelRatio: devicePixelRatio,\n    project_uFocalDistance: focalDistance,\n    project_uCommonUnitsPerMeter: distanceScales.unitsPerMeter,\n    project_uCommonUnitsPerWorldUnit: distanceScales.unitsPerMeter,\n    project_uCommonUnitsPerWorldUnit2: DEFAULT_PIXELS_PER_UNIT2,\n    project_uScale: viewport.scale,\n    project_uViewProjectionMatrix: viewProjectionMatrix,\n    project_uCameraPosition: cameraPosCommon\n  };\n\n  if (geospatialOrigin) {\n    const distanceScalesAtOrigin = viewport.getDistanceScales(geospatialOrigin);\n\n    switch (coordinateSystem) {\n      case _lib_constants__WEBPACK_IMPORTED_MODULE_2__[\"COORDINATE_SYSTEM\"].METER_OFFSETS:\n        uniforms.project_uCommonUnitsPerWorldUnit = distanceScalesAtOrigin.unitsPerMeter;\n        uniforms.project_uCommonUnitsPerWorldUnit2 = distanceScalesAtOrigin.unitsPerMeter2;\n        break;\n\n      case _lib_constants__WEBPACK_IMPORTED_MODULE_2__[\"COORDINATE_SYSTEM\"].LNGLAT:\n      case _lib_constants__WEBPACK_IMPORTED_MODULE_2__[\"COORDINATE_SYSTEM\"].LNGLAT_OFFSETS:\n        uniforms.project_uCommonUnitsPerWorldUnit = distanceScalesAtOrigin.unitsPerDegree;\n        uniforms.project_uCommonUnitsPerWorldUnit2 = distanceScalesAtOrigin.unitsPerDegree2;\n        break;\n\n      case _lib_constants__WEBPACK_IMPORTED_MODULE_2__[\"COORDINATE_SYSTEM\"].CARTESIAN:\n        uniforms.project_uCommonUnitsPerWorldUnit = [1, 1, distanceScalesAtOrigin.unitsPerMeter[2]];\n        uniforms.project_uCommonUnitsPerWorldUnit2 = [0, 0, distanceScalesAtOrigin.unitsPerMeter2[2]];\n        break;\n\n      default:\n        break;\n    }\n  }\n\n  return uniforms;\n}\n//# sourceMappingURL=viewport-uniforms.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/shaderlib/project/viewport-uniforms.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/shaderlib/project32/project32.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/shaderlib/project32/project32.js ***!
  \******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _project_project__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../project/project */ \"./node_modules/@deck.gl/core/dist/esm/shaderlib/project/project.js\");\n\nconst vs = \"\\nvec4 project_position_to_clipspace(\\n  vec3 position, vec3 position64Low, vec3 offset, out vec4 commonPosition\\n) {\\n  vec3 projectedPosition = project_position(position, position64Low);\\n  if (project_uProjectionMode == PROJECTION_MODE_GLOBE) {\\n    // offset is specified as ENU\\n    // when in globe projection, rotate offset so that the ground alighs with the surface of the globe\\n    mat3 rotation = project_get_orientation_matrix(projectedPosition);\\n    offset = rotation * offset;\\n  }\\n  commonPosition = vec4(projectedPosition + offset, 1.0);\\n  return project_common_position_to_clipspace(commonPosition);\\n}\\n\\nvec4 project_position_to_clipspace(\\n  vec3 position, vec3 position64Low, vec3 offset\\n) {\\n  vec4 commonPosition;\\n  return project_position_to_clipspace(position, position64Low, offset, commonPosition);\\n}\\n\";\n/* harmony default export */ __webpack_exports__[\"default\"] = ({\n  name: 'project32',\n  dependencies: [_project_project__WEBPACK_IMPORTED_MODULE_0__[\"default\"]],\n  vs\n});\n//# sourceMappingURL=project32.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS9zaGFkZXJsaWIvcHJvamVjdDMyL3Byb2plY3QzMi5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9AZGVjay5nbC9jb3JlL2Rpc3QvZXNtL3NoYWRlcmxpYi9wcm9qZWN0MzIvcHJvamVjdDMyLmpzPzJiODgiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHByb2plY3QgZnJvbSAnLi4vcHJvamVjdC9wcm9qZWN0JztcbmNvbnN0IHZzID0gXCJcXG52ZWM0IHByb2plY3RfcG9zaXRpb25fdG9fY2xpcHNwYWNlKFxcbiAgdmVjMyBwb3NpdGlvbiwgdmVjMyBwb3NpdGlvbjY0TG93LCB2ZWMzIG9mZnNldCwgb3V0IHZlYzQgY29tbW9uUG9zaXRpb25cXG4pIHtcXG4gIHZlYzMgcHJvamVjdGVkUG9zaXRpb24gPSBwcm9qZWN0X3Bvc2l0aW9uKHBvc2l0aW9uLCBwb3NpdGlvbjY0TG93KTtcXG4gIGlmIChwcm9qZWN0X3VQcm9qZWN0aW9uTW9kZSA9PSBQUk9KRUNUSU9OX01PREVfR0xPQkUpIHtcXG4gICAgLy8gb2Zmc2V0IGlzIHNwZWNpZmllZCBhcyBFTlVcXG4gICAgLy8gd2hlbiBpbiBnbG9iZSBwcm9qZWN0aW9uLCByb3RhdGUgb2Zmc2V0IHNvIHRoYXQgdGhlIGdyb3VuZCBhbGlnaHMgd2l0aCB0aGUgc3VyZmFjZSBvZiB0aGUgZ2xvYmVcXG4gICAgbWF0MyByb3RhdGlvbiA9IHByb2plY3RfZ2V0X29yaWVudGF0aW9uX21hdHJpeChwcm9qZWN0ZWRQb3NpdGlvbik7XFxuICAgIG9mZnNldCA9IHJvdGF0aW9uICogb2Zmc2V0O1xcbiAgfVxcbiAgY29tbW9uUG9zaXRpb24gPSB2ZWM0KHByb2plY3RlZFBvc2l0aW9uICsgb2Zmc2V0LCAxLjApO1xcbiAgcmV0dXJuIHByb2plY3RfY29tbW9uX3Bvc2l0aW9uX3RvX2NsaXBzcGFjZShjb21tb25Qb3NpdGlvbik7XFxufVxcblxcbnZlYzQgcHJvamVjdF9wb3NpdGlvbl90b19jbGlwc3BhY2UoXFxuICB2ZWMzIHBvc2l0aW9uLCB2ZWMzIHBvc2l0aW9uNjRMb3csIHZlYzMgb2Zmc2V0XFxuKSB7XFxuICB2ZWM0IGNvbW1vblBvc2l0aW9uO1xcbiAgcmV0dXJuIHByb2plY3RfcG9zaXRpb25fdG9fY2xpcHNwYWNlKHBvc2l0aW9uLCBwb3NpdGlvbjY0TG93LCBvZmZzZXQsIGNvbW1vblBvc2l0aW9uKTtcXG59XFxuXCI7XG5leHBvcnQgZGVmYXVsdCB7XG4gIG5hbWU6ICdwcm9qZWN0MzInLFxuICBkZXBlbmRlbmNpZXM6IFtwcm9qZWN0XSxcbiAgdnNcbn07XG4vLyMgc291cmNlTWFwcGluZ1VSTD1wcm9qZWN0MzIuanMubWFwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/shaderlib/project32/project32.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/shaderlib/shadow/shadow.js":
/*!************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/shaderlib/shadow/shadow.js ***!
  \************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _lib_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../lib/constants */ \"./node_modules/@deck.gl/core/dist/esm/lib/constants.js\");\n/* harmony import */ var _project_project__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../project/project */ \"./node_modules/@deck.gl/core/dist/esm/shaderlib/project/project.js\");\n/* harmony import */ var math_gl__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! math.gl */ \"./node_modules/math.gl/dist/esm/index.js\");\n/* harmony import */ var _utils_memoize__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/memoize */ \"./node_modules/@deck.gl/core/dist/esm/utils/memoize.js\");\n/* harmony import */ var _math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @math.gl/web-mercator */ \"./node_modules/@math.gl/web-mercator/dist/esm/index.js\");\n\n\n\n\n\nconst vs = \"\\nconst int max_lights = 2;\\nuniform mat4 shadow_uViewProjectionMatrices[max_lights];\\nuniform vec4 shadow_uProjectCenters[max_lights];\\nuniform bool shadow_uDrawShadowMap;\\nuniform bool shadow_uUseShadowMap;\\nuniform int shadow_uLightId;\\nuniform float shadow_uLightCount;\\n\\nvarying vec3 shadow_vPosition[max_lights];\\n\\nvec4 shadow_setVertexPosition(vec4 position_commonspace) {\\n  if (shadow_uDrawShadowMap) {\\n    return project_common_position_to_clipspace(position_commonspace, shadow_uViewProjectionMatrices[shadow_uLightId], shadow_uProjectCenters[shadow_uLightId]);\\n  }\\n  if (shadow_uUseShadowMap) {\\n    for (int i = 0; i < max_lights; i++) {\\n      if(i < int(shadow_uLightCount)) {\\n        vec4 shadowMap_position = project_common_position_to_clipspace(position_commonspace, shadow_uViewProjectionMatrices[i], shadow_uProjectCenters[i]);\\n        shadow_vPosition[i] = (shadowMap_position.xyz / shadowMap_position.w + 1.0) / 2.0;\\n      }\\n    }\\n  }\\n  return gl_Position;\\n}\\n\";\nconst fs = \"\\nconst int max_lights = 2;\\nuniform bool shadow_uDrawShadowMap;\\nuniform bool shadow_uUseShadowMap;\\nuniform sampler2D shadow_uShadowMap0;\\nuniform sampler2D shadow_uShadowMap1;\\nuniform vec4 shadow_uColor;\\nuniform float shadow_uLightCount;\\n\\nvarying vec3 shadow_vPosition[max_lights];\\n\\nconst vec4 bitPackShift = vec4(1.0, 255.0, 65025.0, 16581375.0);\\nconst vec4 bitUnpackShift = 1.0 / bitPackShift;\\nconst vec4 bitMask = vec4(1.0 / 255.0, 1.0 / 255.0, 1.0 / 255.0,  0.0);\\n\\nfloat shadow_getShadowWeight(vec3 position, sampler2D shadowMap) {\\n  vec4 rgbaDepth = texture2D(shadowMap, position.xy);\\n\\n  float z = dot(rgbaDepth, bitUnpackShift);\\n  return smoothstep(0.001, 0.01, position.z - z);\\n}\\n\\nvec4 shadow_filterShadowColor(vec4 color) {\\n  if (shadow_uDrawShadowMap) {\\n    vec4 rgbaDepth = fract(gl_FragCoord.z * bitPackShift);\\n    rgbaDepth -= rgbaDepth.gbaa * bitMask;\\n    return rgbaDepth;\\n  }\\n  if (shadow_uUseShadowMap) {\\n    float shadowAlpha = 0.0;\\n    shadowAlpha += shadow_getShadowWeight(shadow_vPosition[0], shadow_uShadowMap0);\\n    if(shadow_uLightCount > 1.0) {\\n      shadowAlpha += shadow_getShadowWeight(shadow_vPosition[1], shadow_uShadowMap1);\\n    }\\n    shadowAlpha *= shadow_uColor.a / shadow_uLightCount;\\n    float blendedAlpha = shadowAlpha + color.a * (1.0 - shadowAlpha);\\n\\n    return vec4(\\n      mix(color.rgb, shadow_uColor.rgb, shadowAlpha / blendedAlpha),\\n      blendedAlpha\\n    );\\n  }\\n  return color;\\n}\\n\";\nconst getMemoizedViewportCenterPosition = Object(_utils_memoize__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(getViewportCenterPosition);\nconst getMemoizedViewProjectionMatrices = Object(_utils_memoize__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(getViewProjectionMatrices);\nconst DEFAULT_SHADOW_COLOR = [0, 0, 0, 1.0];\nconst VECTOR_TO_POINT_MATRIX = [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0];\n\nfunction screenToCommonSpace(xyz, pixelUnprojectionMatrix) {\n  const [x, y, z] = xyz;\n  const coord = Object(_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_4__[\"pixelsToWorld\"])([x, y, z], pixelUnprojectionMatrix);\n\n  if (Number.isFinite(z)) {\n    return coord;\n  }\n\n  return [coord[0], coord[1], 0];\n}\n\nfunction getViewportCenterPosition({\n  viewport,\n  center\n}) {\n  return new math_gl__WEBPACK_IMPORTED_MODULE_2__[\"Matrix4\"](viewport.viewProjectionMatrix).invert().transform(center);\n}\n\nfunction getViewProjectionMatrices({\n  viewport,\n  shadowMatrices\n}) {\n  const projectionMatrices = [];\n  const pixelUnprojectionMatrix = viewport.pixelUnprojectionMatrix;\n  const farZ = viewport.isGeospatial ? undefined : 1;\n  const corners = [[0, 0, farZ], [viewport.width, 0, farZ], [0, viewport.height, farZ], [viewport.width, viewport.height, farZ], [0, 0, -1], [viewport.width, 0, -1], [0, viewport.height, -1], [viewport.width, viewport.height, -1]].map(pixel => screenToCommonSpace(pixel, pixelUnprojectionMatrix));\n\n  for (const shadowMatrix of shadowMatrices) {\n    const viewMatrix = shadowMatrix.clone().translate(new math_gl__WEBPACK_IMPORTED_MODULE_2__[\"Vector3\"](viewport.center).negate());\n    const positions = corners.map(corner => viewMatrix.transform(corner));\n    const projectionMatrix = new math_gl__WEBPACK_IMPORTED_MODULE_2__[\"Matrix4\"]().ortho({\n      left: Math.min(...positions.map(position => position[0])),\n      right: Math.max(...positions.map(position => position[0])),\n      bottom: Math.min(...positions.map(position => position[1])),\n      top: Math.max(...positions.map(position => position[1])),\n      near: Math.min(...positions.map(position => -position[2])),\n      far: Math.max(...positions.map(position => -position[2]))\n    });\n    projectionMatrices.push(projectionMatrix.multiplyRight(shadowMatrix));\n  }\n\n  return projectionMatrices;\n}\n\nfunction createShadowUniforms(opts = {}, context = {}) {\n  const uniforms = {\n    shadow_uDrawShadowMap: Boolean(opts.drawToShadowMap),\n    shadow_uUseShadowMap: opts.shadowMaps ? opts.shadowMaps.length > 0 : false,\n    shadow_uColor: opts.shadowColor || DEFAULT_SHADOW_COLOR,\n    shadow_uLightId: opts.shadowLightId || 0,\n    shadow_uLightCount: opts.shadowMatrices.length\n  };\n  const center = getMemoizedViewportCenterPosition({\n    viewport: opts.viewport,\n    center: context.project_uCenter\n  });\n  const projectCenters = [];\n  const viewProjectionMatrices = getMemoizedViewProjectionMatrices({\n    shadowMatrices: opts.shadowMatrices,\n    viewport: opts.viewport\n  }).slice();\n\n  for (let i = 0; i < opts.shadowMatrices.length; i++) {\n    const viewProjectionMatrix = viewProjectionMatrices[i];\n    const viewProjectionMatrixCentered = viewProjectionMatrix.clone().translate(new math_gl__WEBPACK_IMPORTED_MODULE_2__[\"Vector3\"](opts.viewport.center).negate());\n\n    if (context.project_uCoordinateSystem === _lib_constants__WEBPACK_IMPORTED_MODULE_0__[\"COORDINATE_SYSTEM\"].LNGLAT && context.project_uProjectionMode === _lib_constants__WEBPACK_IMPORTED_MODULE_0__[\"PROJECTION_MODE\"].WEB_MERCATOR) {\n      viewProjectionMatrices[i] = viewProjectionMatrixCentered;\n      projectCenters[i] = center;\n    } else {\n      viewProjectionMatrices[i] = viewProjectionMatrix.clone().multiplyRight(VECTOR_TO_POINT_MATRIX);\n      projectCenters[i] = viewProjectionMatrixCentered.transform(center);\n    }\n  }\n\n  for (let i = 0; i < viewProjectionMatrices.length; i++) {\n    uniforms[\"shadow_uViewProjectionMatrices[\".concat(i, \"]\")] = viewProjectionMatrices[i];\n    uniforms[\"shadow_uProjectCenters[\".concat(i, \"]\")] = projectCenters[i];\n\n    if (opts.shadowMaps && opts.shadowMaps.length > 0) {\n      uniforms[\"shadow_uShadowMap\".concat(i)] = opts.shadowMaps[i];\n    } else {\n      uniforms[\"shadow_uShadowMap\".concat(i)] = opts.dummyShadowMap;\n    }\n  }\n\n  return uniforms;\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ({\n  name: 'shadow',\n  dependencies: [_project_project__WEBPACK_IMPORTED_MODULE_1__[\"default\"]],\n  vs,\n  fs,\n  inject: {\n    'vs:DECKGL_FILTER_GL_POSITION': \"\\n    position = shadow_setVertexPosition(geometry.position);\\n    \",\n    'fs:DECKGL_FILTER_COLOR': \"\\n    color = shadow_filterShadowColor(color);\\n    \"\n  },\n  getUniforms: (opts = {}, context = {}) => {\n    if (opts.drawToShadowMap || opts.shadowMaps && opts.shadowMaps.length > 0) {\n      const {\n        shadowEnabled = true\n      } = opts;\n      return shadowEnabled && opts.shadowMatrices && opts.shadowMatrices.length > 0 ? createShadowUniforms(opts, context) : {\n        shadow_uDrawShadowMap: false,\n        shadow_uUseShadowMap: false\n      };\n    }\n\n    return {};\n  }\n});\n//# sourceMappingURL=shadow.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/shaderlib/shadow/shadow.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/transitions/cpu-interpolation-transition.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/transitions/cpu-interpolation-transition.js ***!
  \*****************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return CPUInterpolationTransition; });\n/* harmony import */ var math_gl__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! math.gl */ \"./node_modules/math.gl/dist/esm/index.js\");\n/* harmony import */ var _transition__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./transition */ \"./node_modules/@deck.gl/core/dist/esm/transitions/transition.js\");\n\n\nclass CPUInterpolationTransition extends _transition__WEBPACK_IMPORTED_MODULE_1__[\"default\"] {\n  get value() {\n    return this._value;\n  }\n\n  _onUpdate() {\n    const {\n      time,\n      settings: {\n        fromValue,\n        toValue,\n        duration,\n        easing\n      }\n    } = this;\n    const t = easing(time / duration);\n    this._value = Object(math_gl__WEBPACK_IMPORTED_MODULE_0__[\"lerp\"])(fromValue, toValue, t);\n  }\n\n}\n//# sourceMappingURL=cpu-interpolation-transition.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS90cmFuc2l0aW9ucy9jcHUtaW50ZXJwb2xhdGlvbi10cmFuc2l0aW9uLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0BkZWNrLmdsL2NvcmUvZGlzdC9lc20vdHJhbnNpdGlvbnMvY3B1LWludGVycG9sYXRpb24tdHJhbnNpdGlvbi5qcz80NTY5Il0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGxlcnAgfSBmcm9tICdtYXRoLmdsJztcbmltcG9ydCBUcmFuc2l0aW9uIGZyb20gJy4vdHJhbnNpdGlvbic7XG5leHBvcnQgZGVmYXVsdCBjbGFzcyBDUFVJbnRlcnBvbGF0aW9uVHJhbnNpdGlvbiBleHRlbmRzIFRyYW5zaXRpb24ge1xuICBnZXQgdmFsdWUoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3ZhbHVlO1xuICB9XG5cbiAgX29uVXBkYXRlKCkge1xuICAgIGNvbnN0IHtcbiAgICAgIHRpbWUsXG4gICAgICBzZXR0aW5nczoge1xuICAgICAgICBmcm9tVmFsdWUsXG4gICAgICAgIHRvVmFsdWUsXG4gICAgICAgIGR1cmF0aW9uLFxuICAgICAgICBlYXNpbmdcbiAgICAgIH1cbiAgICB9ID0gdGhpcztcbiAgICBjb25zdCB0ID0gZWFzaW5nKHRpbWUgLyBkdXJhdGlvbik7XG4gICAgdGhpcy5fdmFsdWUgPSBsZXJwKGZyb21WYWx1ZSwgdG9WYWx1ZSwgdCk7XG4gIH1cblxufVxuLy8jIHNvdXJjZU1hcHBpbmdVUkw9Y3B1LWludGVycG9sYXRpb24tdHJhbnNpdGlvbi5qcy5tYXAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/transitions/cpu-interpolation-transition.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/transitions/cpu-spring-transition.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/transitions/cpu-spring-transition.js ***!
  \**********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return CPUSpringTransition; });\n/* harmony import */ var _transition__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./transition */ \"./node_modules/@deck.gl/core/dist/esm/transitions/transition.js\");\n\nconst EPSILON = 1e-5;\n\nfunction updateSpringElement(prev, cur, dest, damping, stiffness) {\n  const velocity = cur - prev;\n  const delta = dest - cur;\n  const spring = delta * stiffness;\n  const damper = -velocity * damping;\n  return spring + damper + velocity + cur;\n}\n\nfunction updateSpring(prev, cur, dest, damping, stiffness) {\n  if (Array.isArray(dest)) {\n    const next = [];\n\n    for (let i = 0; i < dest.length; i++) {\n      next[i] = updateSpringElement(prev[i], cur[i], dest[i], damping, stiffness);\n    }\n\n    return next;\n  }\n\n  return updateSpringElement(prev, cur, dest, damping, stiffness);\n}\n\nfunction distance(value1, value2) {\n  if (Array.isArray(value1)) {\n    let distanceSquare = 0;\n\n    for (let i = 0; i < value1.length; i++) {\n      const d = value1[i] - value2[i];\n      distanceSquare += d * d;\n    }\n\n    return Math.sqrt(distanceSquare);\n  }\n\n  return Math.abs(value1 - value2);\n}\n\nclass CPUSpringTransition extends _transition__WEBPACK_IMPORTED_MODULE_0__[\"default\"] {\n  get value() {\n    return this._currValue;\n  }\n\n  _onUpdate() {\n    const {\n      fromValue,\n      toValue,\n      damping,\n      stiffness\n    } = this.settings;\n    const {\n      _prevValue = fromValue,\n      _currValue = fromValue\n    } = this;\n    let nextValue = updateSpring(_prevValue, _currValue, toValue, damping, stiffness);\n    const delta = distance(nextValue, toValue);\n    const velocity = distance(nextValue, _currValue);\n\n    if (delta < EPSILON && velocity < EPSILON) {\n      nextValue = toValue;\n      this.end();\n    }\n\n    this._prevValue = _currValue;\n    this._currValue = nextValue;\n  }\n\n}\n//# sourceMappingURL=cpu-spring-transition.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/transitions/cpu-spring-transition.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/transitions/gpu-interpolation-transition.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/transitions/gpu-interpolation-transition.js ***!
  \*****************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return GPUInterpolationTransition; });\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/webgl/dist/esm/classes/buffer.js\");\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/engine/dist/esm/transform/transform.js\");\n/* harmony import */ var _lib_attribute_attribute__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../lib/attribute/attribute */ \"./node_modules/@deck.gl/core/dist/esm/lib/attribute/attribute.js\");\n/* harmony import */ var _lib_attribute_attribute_transition_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../lib/attribute/attribute-transition-utils */ \"./node_modules/@deck.gl/core/dist/esm/lib/attribute/attribute-transition-utils.js\");\n/* harmony import */ var _transition__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./transition */ \"./node_modules/@deck.gl/core/dist/esm/transitions/transition.js\");\n\n\n\n\nclass GPUInterpolationTransition {\n  constructor({\n    gl,\n    attribute,\n    timeline\n  }) {\n    this.gl = gl;\n    this.type = 'interpolation';\n    this.transition = new _transition__WEBPACK_IMPORTED_MODULE_4__[\"default\"](timeline);\n    this.attribute = attribute;\n    this.attributeInTransition = new _lib_attribute_attribute__WEBPACK_IMPORTED_MODULE_2__[\"default\"](gl, attribute.settings);\n    this.currentStartIndices = attribute.startIndices;\n    this.currentLength = 0;\n    this.transform = getTransform(gl, attribute);\n    const bufferOpts = {\n      byteLength: 0,\n      usage: 35050\n    };\n    this.buffers = [new _luma_gl_core__WEBPACK_IMPORTED_MODULE_0__[\"default\"](gl, bufferOpts), new _luma_gl_core__WEBPACK_IMPORTED_MODULE_0__[\"default\"](gl, bufferOpts)];\n  }\n\n  get inProgress() {\n    return this.transition.inProgress;\n  }\n\n  start(transitionSettings, numInstances) {\n    if (transitionSettings.duration <= 0) {\n      this.transition.cancel();\n      return;\n    }\n\n    const {\n      gl,\n      buffers,\n      attribute\n    } = this;\n    Object(_lib_attribute_attribute_transition_utils__WEBPACK_IMPORTED_MODULE_3__[\"cycleBuffers\"])(buffers);\n    const padBufferOpts = {\n      numInstances,\n      attribute,\n      fromLength: this.currentLength,\n      fromStartIndices: this.currentStartIndices,\n      getData: transitionSettings.enter\n    };\n\n    for (const buffer of buffers) {\n      Object(_lib_attribute_attribute_transition_utils__WEBPACK_IMPORTED_MODULE_3__[\"padBuffer\"])({\n        buffer,\n        ...padBufferOpts\n      });\n    }\n\n    this.currentStartIndices = attribute.startIndices;\n    this.currentLength = Object(_lib_attribute_attribute_transition_utils__WEBPACK_IMPORTED_MODULE_3__[\"getAttributeBufferLength\"])(attribute, numInstances);\n    this.attributeInTransition.update({\n      buffer: buffers[1],\n      value: attribute.value\n    });\n    this.transition.start(transitionSettings);\n    this.transform.update({\n      elementCount: Math.floor(this.currentLength / attribute.size),\n      sourceBuffers: {\n        aFrom: buffers[0],\n        aTo: Object(_lib_attribute_attribute_transition_utils__WEBPACK_IMPORTED_MODULE_3__[\"getSourceBufferAttribute\"])(gl, attribute)\n      },\n      feedbackBuffers: {\n        vCurrent: buffers[1]\n      }\n    });\n  }\n\n  update() {\n    const updated = this.transition.update();\n\n    if (updated) {\n      const {\n        time,\n        settings: {\n          duration,\n          easing\n        }\n      } = this.transition;\n      const t = easing(time / duration);\n      this.transform.run({\n        uniforms: {\n          time: t\n        }\n      });\n    }\n\n    return updated;\n  }\n\n  cancel() {\n    this.transition.cancel();\n    this.transform.delete();\n\n    while (this.buffers.length) {\n      this.buffers.pop().delete();\n    }\n  }\n\n}\nconst vs = \"\\n#define SHADER_NAME interpolation-transition-vertex-shader\\n\\nuniform float time;\\nattribute ATTRIBUTE_TYPE aFrom;\\nattribute ATTRIBUTE_TYPE aTo;\\nvarying ATTRIBUTE_TYPE vCurrent;\\n\\nvoid main(void) {\\n  vCurrent = mix(aFrom, aTo, time);\\n  gl_Position = vec4(0.0);\\n}\\n\";\n\nfunction getTransform(gl, attribute) {\n  const attributeType = Object(_lib_attribute_attribute_transition_utils__WEBPACK_IMPORTED_MODULE_3__[\"getAttributeTypeFromSize\"])(attribute.size);\n  return new _luma_gl_core__WEBPACK_IMPORTED_MODULE_1__[\"default\"](gl, {\n    vs,\n    defines: {\n      ATTRIBUTE_TYPE: attributeType\n    },\n    varyings: ['vCurrent']\n  });\n}\n//# sourceMappingURL=gpu-interpolation-transition.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS90cmFuc2l0aW9ucy9ncHUtaW50ZXJwb2xhdGlvbi10cmFuc2l0aW9uLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0BkZWNrLmdsL2NvcmUvZGlzdC9lc20vdHJhbnNpdGlvbnMvZ3B1LWludGVycG9sYXRpb24tdHJhbnNpdGlvbi5qcz9mM2M5Il0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEJ1ZmZlciwgVHJhbnNmb3JtIH0gZnJvbSAnQGx1bWEuZ2wvY29yZSc7XG5pbXBvcnQgQXR0cmlidXRlIGZyb20gJy4uL2xpYi9hdHRyaWJ1dGUvYXR0cmlidXRlJztcbmltcG9ydCB7IHBhZEJ1ZmZlciwgZ2V0QXR0cmlidXRlVHlwZUZyb21TaXplLCBnZXRTb3VyY2VCdWZmZXJBdHRyaWJ1dGUsIGdldEF0dHJpYnV0ZUJ1ZmZlckxlbmd0aCwgY3ljbGVCdWZmZXJzIH0gZnJvbSAnLi4vbGliL2F0dHJpYnV0ZS9hdHRyaWJ1dGUtdHJhbnNpdGlvbi11dGlscyc7XG5pbXBvcnQgVHJhbnNpdGlvbiBmcm9tICcuL3RyYW5zaXRpb24nO1xuZXhwb3J0IGRlZmF1bHQgY2xhc3MgR1BVSW50ZXJwb2xhdGlvblRyYW5zaXRpb24ge1xuICBjb25zdHJ1Y3Rvcih7XG4gICAgZ2wsXG4gICAgYXR0cmlidXRlLFxuICAgIHRpbWVsaW5lXG4gIH0pIHtcbiAgICB0aGlzLmdsID0gZ2w7XG4gICAgdGhpcy50eXBlID0gJ2ludGVycG9sYXRpb24nO1xuICAgIHRoaXMudHJhbnNpdGlvbiA9IG5ldyBUcmFuc2l0aW9uKHRpbWVsaW5lKTtcbiAgICB0aGlzLmF0dHJpYnV0ZSA9IGF0dHJpYnV0ZTtcbiAgICB0aGlzLmF0dHJpYnV0ZUluVHJhbnNpdGlvbiA9IG5ldyBBdHRyaWJ1dGUoZ2wsIGF0dHJpYnV0ZS5zZXR0aW5ncyk7XG4gICAgdGhpcy5jdXJyZW50U3RhcnRJbmRpY2VzID0gYXR0cmlidXRlLnN0YXJ0SW5kaWNlcztcbiAgICB0aGlzLmN1cnJlbnRMZW5ndGggPSAwO1xuICAgIHRoaXMudHJhbnNmb3JtID0gZ2V0VHJhbnNmb3JtKGdsLCBhdHRyaWJ1dGUpO1xuICAgIGNvbnN0IGJ1ZmZlck9wdHMgPSB7XG4gICAgICBieXRlTGVuZ3RoOiAwLFxuICAgICAgdXNhZ2U6IDM1MDUwXG4gICAgfTtcbiAgICB0aGlzLmJ1ZmZlcnMgPSBbbmV3IEJ1ZmZlcihnbCwgYnVmZmVyT3B0cyksIG5ldyBCdWZmZXIoZ2wsIGJ1ZmZlck9wdHMpXTtcbiAgfVxuXG4gIGdldCBpblByb2dyZXNzKCkge1xuICAgIHJldHVybiB0aGlzLnRyYW5zaXRpb24uaW5Qcm9ncmVzcztcbiAgfVxuXG4gIHN0YXJ0KHRyYW5zaXRpb25TZXR0aW5ncywgbnVtSW5zdGFuY2VzKSB7XG4gICAgaWYgKHRyYW5zaXRpb25TZXR0aW5ncy5kdXJhdGlvbiA8PSAwKSB7XG4gICAgICB0aGlzLnRyYW5zaXRpb24uY2FuY2VsKCk7XG4gICAgICByZXR1cm47XG4gICAgfVxuXG4gICAgY29uc3Qge1xuICAgICAgZ2wsXG4gICAgICBidWZmZXJzLFxuICAgICAgYXR0cmlidXRlXG4gICAgfSA9IHRoaXM7XG4gICAgY3ljbGVCdWZmZXJzKGJ1ZmZlcnMpO1xuICAgIGNvbnN0IHBhZEJ1ZmZlck9wdHMgPSB7XG4gICAgICBudW1JbnN0YW5jZXMsXG4gICAgICBhdHRyaWJ1dGUsXG4gICAgICBmcm9tTGVuZ3RoOiB0aGlzLmN1cnJlbnRMZW5ndGgsXG4gICAgICBmcm9tU3RhcnRJbmRpY2VzOiB0aGlzLmN1cnJlbnRTdGFydEluZGljZXMsXG4gICAgICBnZXREYXRhOiB0cmFuc2l0aW9uU2V0dGluZ3MuZW50ZXJcbiAgICB9O1xuXG4gICAgZm9yIChjb25zdCBidWZmZXIgb2YgYnVmZmVycykge1xuICAgICAgcGFkQnVmZmVyKHtcbiAgICAgICAgYnVmZmVyLFxuICAgICAgICAuLi5wYWRCdWZmZXJPcHRzXG4gICAgICB9KTtcbiAgICB9XG5cbiAgICB0aGlzLmN1cnJlbnRTdGFydEluZGljZXMgPSBhdHRyaWJ1dGUuc3RhcnRJbmRpY2VzO1xuICAgIHRoaXMuY3VycmVudExlbmd0aCA9IGdldEF0dHJpYnV0ZUJ1ZmZlckxlbmd0aChhdHRyaWJ1dGUsIG51bUluc3RhbmNlcyk7XG4gICAgdGhpcy5hdHRyaWJ1dGVJblRyYW5zaXRpb24udXBkYXRlKHtcbiAgICAgIGJ1ZmZlcjogYnVmZmVyc1sxXSxcbiAgICAgIHZhbHVlOiBhdHRyaWJ1dGUudmFsdWVcbiAgICB9KTtcbiAgICB0aGlzLnRyYW5zaXRpb24uc3RhcnQodHJhbnNpdGlvblNldHRpbmdzKTtcbiAgICB0aGlzLnRyYW5zZm9ybS51cGRhdGUoe1xuICAgICAgZWxlbWVudENvdW50OiBNYXRoLmZsb29yKHRoaXMuY3VycmVudExlbmd0aCAvIGF0dHJpYnV0ZS5zaXplKSxcbiAgICAgIHNvdXJjZUJ1ZmZlcnM6IHtcbiAgICAgICAgYUZyb206IGJ1ZmZlcnNbMF0sXG4gICAgICAgIGFUbzogZ2V0U291cmNlQnVmZmVyQXR0cmlidXRlKGdsLCBhdHRyaWJ1dGUpXG4gICAgICB9LFxuICAgICAgZmVlZGJhY2tCdWZmZXJzOiB7XG4gICAgICAgIHZDdXJyZW50OiBidWZmZXJzWzFdXG4gICAgICB9XG4gICAgfSk7XG4gIH1cblxuICB1cGRhdGUoKSB7XG4gICAgY29uc3QgdXBkYXRlZCA9IHRoaXMudHJhbnNpdGlvbi51cGRhdGUoKTtcblxuICAgIGlmICh1cGRhdGVkKSB7XG4gICAgICBjb25zdCB7XG4gICAgICAgIHRpbWUsXG4gICAgICAgIHNldHRpbmdzOiB7XG4gICAgICAgICAgZHVyYXRpb24sXG4gICAgICAgICAgZWFzaW5nXG4gICAgICAgIH1cbiAgICAgIH0gPSB0aGlzLnRyYW5zaXRpb247XG4gICAgICBjb25zdCB0ID0gZWFzaW5nKHRpbWUgLyBkdXJhdGlvbik7XG4gICAgICB0aGlzLnRyYW5zZm9ybS5ydW4oe1xuICAgICAgICB1bmlmb3Jtczoge1xuICAgICAgICAgIHRpbWU6IHRcbiAgICAgICAgfVxuICAgICAgfSk7XG4gICAgfVxuXG4gICAgcmV0dXJuIHVwZGF0ZWQ7XG4gIH1cblxuICBjYW5jZWwoKSB7XG4gICAgdGhpcy50cmFuc2l0aW9uLmNhbmNlbCgpO1xuICAgIHRoaXMudHJhbnNmb3JtLmRlbGV0ZSgpO1xuXG4gICAgd2hpbGUgKHRoaXMuYnVmZmVycy5sZW5ndGgpIHtcbiAgICAgIHRoaXMuYnVmZmVycy5wb3AoKS5kZWxldGUoKTtcbiAgICB9XG4gIH1cblxufVxuY29uc3QgdnMgPSBcIlxcbiNkZWZpbmUgU0hBREVSX05BTUUgaW50ZXJwb2xhdGlvbi10cmFuc2l0aW9uLXZlcnRleC1zaGFkZXJcXG5cXG51bmlmb3JtIGZsb2F0IHRpbWU7XFxuYXR0cmlidXRlIEFUVFJJQlVURV9UWVBFIGFGcm9tO1xcbmF0dHJpYnV0ZSBBVFRSSUJVVEVfVFlQRSBhVG87XFxudmFyeWluZyBBVFRSSUJVVEVfVFlQRSB2Q3VycmVudDtcXG5cXG52b2lkIG1haW4odm9pZCkge1xcbiAgdkN1cnJlbnQgPSBtaXgoYUZyb20sIGFUbywgdGltZSk7XFxuICBnbF9Qb3NpdGlvbiA9IHZlYzQoMC4wKTtcXG59XFxuXCI7XG5cbmZ1bmN0aW9uIGdldFRyYW5zZm9ybShnbCwgYXR0cmlidXRlKSB7XG4gIGNvbnN0IGF0dHJpYnV0ZVR5cGUgPSBnZXRBdHRyaWJ1dGVUeXBlRnJvbVNpemUoYXR0cmlidXRlLnNpemUpO1xuICByZXR1cm4gbmV3IFRyYW5zZm9ybShnbCwge1xuICAgIHZzLFxuICAgIGRlZmluZXM6IHtcbiAgICAgIEFUVFJJQlVURV9UWVBFOiBhdHRyaWJ1dGVUeXBlXG4gICAgfSxcbiAgICB2YXJ5aW5nczogWyd2Q3VycmVudCddXG4gIH0pO1xufVxuLy8jIHNvdXJjZU1hcHBpbmdVUkw9Z3B1LWludGVycG9sYXRpb24tdHJhbnNpdGlvbi5qcy5tYXAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/transitions/gpu-interpolation-transition.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/transitions/gpu-spring-transition.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/transitions/gpu-spring-transition.js ***!
  \**********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return GPUSpringTransition; });\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/webgl/dist/esm/classes/buffer.js\");\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/webgl/dist/esm/classes/copy-and-blit.js\");\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/engine/dist/esm/transform/transform.js\");\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/webgl/dist/esm/classes/texture-2d.js\");\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/webgl/dist/esm/classes/framebuffer.js\");\n/* harmony import */ var _lib_attribute_attribute_transition_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../lib/attribute/attribute-transition-utils */ \"./node_modules/@deck.gl/core/dist/esm/lib/attribute/attribute-transition-utils.js\");\n/* harmony import */ var _lib_attribute_attribute__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../lib/attribute/attribute */ \"./node_modules/@deck.gl/core/dist/esm/lib/attribute/attribute.js\");\n/* harmony import */ var _transition__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./transition */ \"./node_modules/@deck.gl/core/dist/esm/transitions/transition.js\");\n\n\n\n\nclass GPUSpringTransition {\n  constructor({\n    gl,\n    attribute,\n    timeline\n  }) {\n    this.gl = gl;\n    this.type = 'spring';\n    this.transition = new _transition__WEBPACK_IMPORTED_MODULE_7__[\"default\"](timeline);\n    this.attribute = attribute;\n    this.attributeInTransition = new _lib_attribute_attribute__WEBPACK_IMPORTED_MODULE_6__[\"default\"](gl, { ...attribute.settings,\n      normalized: false\n    });\n    this.currentStartIndices = attribute.startIndices;\n    this.currentLength = 0;\n    this.texture = getTexture(gl);\n    this.framebuffer = getFramebuffer(gl, this.texture);\n    this.transform = getTransform(gl, attribute, this.framebuffer);\n    const bufferOpts = {\n      byteLength: 0,\n      usage: 35050\n    };\n    this.buffers = [new _luma_gl_core__WEBPACK_IMPORTED_MODULE_0__[\"default\"](gl, bufferOpts), new _luma_gl_core__WEBPACK_IMPORTED_MODULE_0__[\"default\"](gl, bufferOpts), new _luma_gl_core__WEBPACK_IMPORTED_MODULE_0__[\"default\"](gl, bufferOpts)];\n  }\n\n  get inProgress() {\n    return this.transition.inProgress;\n  }\n\n  start(transitionSettings, numInstances) {\n    const {\n      gl,\n      buffers,\n      attribute\n    } = this;\n    const padBufferOpts = {\n      numInstances,\n      attribute,\n      fromLength: this.currentLength,\n      fromStartIndices: this.currentStartIndices,\n      getData: transitionSettings.enter\n    };\n\n    for (const buffer of buffers) {\n      Object(_lib_attribute_attribute_transition_utils__WEBPACK_IMPORTED_MODULE_5__[\"padBuffer\"])({\n        buffer,\n        ...padBufferOpts\n      });\n    }\n\n    this.currentStartIndices = attribute.startIndices;\n    this.currentLength = Object(_lib_attribute_attribute_transition_utils__WEBPACK_IMPORTED_MODULE_5__[\"getAttributeBufferLength\"])(attribute, numInstances);\n    this.attributeInTransition.update({\n      buffer: buffers[1],\n      value: attribute.value\n    });\n    this.transition.start(transitionSettings);\n    this.transform.update({\n      elementCount: Math.floor(this.currentLength / attribute.size),\n      sourceBuffers: {\n        aTo: Object(_lib_attribute_attribute_transition_utils__WEBPACK_IMPORTED_MODULE_5__[\"getSourceBufferAttribute\"])(gl, attribute)\n      }\n    });\n  }\n\n  update() {\n    const {\n      buffers,\n      transform,\n      framebuffer,\n      transition\n    } = this;\n    const updated = transition.update();\n\n    if (!updated) {\n      return false;\n    }\n\n    transform.update({\n      sourceBuffers: {\n        aPrev: buffers[0],\n        aCur: buffers[1]\n      },\n      feedbackBuffers: {\n        vNext: buffers[2]\n      }\n    });\n    transform.run({\n      framebuffer,\n      discard: false,\n      clearRenderTarget: true,\n      uniforms: {\n        stiffness: transition.settings.stiffness,\n        damping: transition.settings.damping\n      },\n      parameters: {\n        depthTest: false,\n        blend: true,\n        viewport: [0, 0, 1, 1],\n        blendFunc: [1, 1],\n        blendEquation: [32776, 32776]\n      }\n    });\n    Object(_lib_attribute_attribute_transition_utils__WEBPACK_IMPORTED_MODULE_5__[\"cycleBuffers\"])(buffers);\n    this.attributeInTransition.update({\n      buffer: buffers[1],\n      value: this.attribute.value\n    });\n    const isTransitioning = Object(_luma_gl_core__WEBPACK_IMPORTED_MODULE_1__[\"readPixelsToArray\"])(framebuffer)[0] > 0;\n\n    if (!isTransitioning) {\n      transition.end();\n    }\n\n    return true;\n  }\n\n  cancel() {\n    this.transition.cancel();\n    this.transform.delete();\n\n    while (this.buffers.length) {\n      this.buffers.pop().delete();\n    }\n\n    this.texture.delete();\n    this.texture = null;\n    this.framebuffer.delete();\n    this.framebuffer = null;\n  }\n\n}\n\nfunction getTransform(gl, attribute, framebuffer) {\n  const attributeType = Object(_lib_attribute_attribute_transition_utils__WEBPACK_IMPORTED_MODULE_5__[\"getAttributeTypeFromSize\"])(attribute.size);\n  return new _luma_gl_core__WEBPACK_IMPORTED_MODULE_2__[\"default\"](gl, {\n    framebuffer,\n    vs: \"\\n#define SHADER_NAME spring-transition-vertex-shader\\n\\n#define EPSILON 0.00001\\n\\nuniform float stiffness;\\nuniform float damping;\\nattribute ATTRIBUTE_TYPE aPrev;\\nattribute ATTRIBUTE_TYPE aCur;\\nattribute ATTRIBUTE_TYPE aTo;\\nvarying ATTRIBUTE_TYPE vNext;\\nvarying float vIsTransitioningFlag;\\n\\nATTRIBUTE_TYPE getNextValue(ATTRIBUTE_TYPE cur, ATTRIBUTE_TYPE prev, ATTRIBUTE_TYPE dest) {\\n  ATTRIBUTE_TYPE velocity = cur - prev;\\n  ATTRIBUTE_TYPE delta = dest - cur;\\n  ATTRIBUTE_TYPE spring = delta * stiffness;\\n  ATTRIBUTE_TYPE damper = velocity * -1.0 * damping;\\n  return spring + damper + velocity + cur;\\n}\\n\\nvoid main(void) {\\n  bool isTransitioning = length(aCur - aPrev) > EPSILON || length(aTo - aCur) > EPSILON;\\n  vIsTransitioningFlag = isTransitioning ? 1.0 : 0.0;\\n\\n  vNext = getNextValue(aCur, aPrev, aTo);\\n  gl_Position = vec4(0, 0, 0, 1);\\n  gl_PointSize = 100.0;\\n}\\n\",\n    fs: \"\\n#define SHADER_NAME spring-transition-is-transitioning-fragment-shader\\n\\nvarying float vIsTransitioningFlag;\\n\\nvoid main(void) {\\n  if (vIsTransitioningFlag == 0.0) {\\n    discard;\\n  }\\n  gl_FragColor = vec4(1.0);\\n}\",\n    defines: {\n      ATTRIBUTE_TYPE: attributeType\n    },\n    varyings: ['vNext']\n  });\n}\n\nfunction getTexture(gl) {\n  return new _luma_gl_core__WEBPACK_IMPORTED_MODULE_3__[\"default\"](gl, {\n    data: new Uint8Array(4),\n    format: 6408,\n    type: 5121,\n    border: 0,\n    mipmaps: false,\n    dataFormat: 6408,\n    width: 1,\n    height: 1\n  });\n}\n\nfunction getFramebuffer(gl, texture) {\n  return new _luma_gl_core__WEBPACK_IMPORTED_MODULE_4__[\"default\"](gl, {\n    id: 'spring-transition-is-transitioning-framebuffer',\n    width: 1,\n    height: 1,\n    attachments: {\n      [36064]: texture\n    }\n  });\n}\n//# sourceMappingURL=gpu-spring-transition.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/transitions/gpu-spring-transition.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/transitions/linear-interpolator.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/transitions/linear-interpolator.js ***!
  \********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return LinearInterpolator; });\n/* harmony import */ var _transition_interpolator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./transition-interpolator */ \"./node_modules/@deck.gl/core/dist/esm/transitions/transition-interpolator.js\");\n/* harmony import */ var math_gl__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! math.gl */ \"./node_modules/math.gl/dist/esm/index.js\");\n\n\nconst DEFAULT_PROPS = ['longitude', 'latitude', 'zoom', 'bearing', 'pitch'];\nconst DEFAULT_REQUIRED_PROPS = ['longitude', 'latitude', 'zoom'];\nclass LinearInterpolator extends _transition_interpolator__WEBPACK_IMPORTED_MODULE_0__[\"default\"] {\n  constructor(opts = {}) {\n    const transitionProps = Array.isArray(opts) ? opts : opts.transitionProps;\n    super(transitionProps || {\n      compare: DEFAULT_PROPS,\n      extract: DEFAULT_PROPS,\n      required: DEFAULT_REQUIRED_PROPS\n    });\n    this.opts = opts;\n  }\n\n  initializeProps(startProps, endProps) {\n    const result = super.initializeProps(startProps, endProps);\n    const {\n      makeViewport,\n      around\n    } = this.opts;\n\n    if (makeViewport && around) {\n      const startViewport = makeViewport(startProps);\n      const endViewport = makeViewport(endProps);\n      const aroundPosition = startViewport.unproject(around);\n      result.start.around = around;\n      Object.assign(result.end, {\n        around: endViewport.project(aroundPosition),\n        aroundPosition,\n        width: endProps.width,\n        height: endProps.height\n      });\n    }\n\n    return result;\n  }\n\n  interpolateProps(startProps, endProps, t) {\n    const propsInTransition = {};\n\n    for (const key of this._propsToExtract) {\n      propsInTransition[key] = Object(math_gl__WEBPACK_IMPORTED_MODULE_1__[\"lerp\"])(startProps[key] || 0, endProps[key] || 0, t);\n    }\n\n    if (endProps.aroundPosition) {\n      const viewport = this.opts.makeViewport({ ...endProps,\n        ...propsInTransition\n      });\n      Object.assign(propsInTransition, viewport.panByPosition(endProps.aroundPosition, Object(math_gl__WEBPACK_IMPORTED_MODULE_1__[\"lerp\"])(startProps.around, endProps.around, t)));\n    }\n\n    return propsInTransition;\n  }\n\n}\n//# sourceMappingURL=linear-interpolator.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/transitions/linear-interpolator.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/transitions/transition-interpolator.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/transitions/transition-interpolator.js ***!
  \************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return TransitionInterpolator; });\n/* harmony import */ var math_gl__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! math.gl */ \"./node_modules/math.gl/dist/esm/index.js\");\n/* harmony import */ var _utils_assert__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/assert */ \"./node_modules/@deck.gl/core/dist/esm/utils/assert.js\");\n\n\nclass TransitionInterpolator {\n  constructor(opts = {}) {\n    if (Array.isArray(opts)) {\n      opts = {\n        compare: opts,\n        extract: opts,\n        required: opts\n      };\n    }\n\n    const {\n      compare,\n      extract,\n      required\n    } = opts;\n    this._propsToCompare = compare;\n    this._propsToExtract = extract;\n    this._requiredProps = required;\n  }\n\n  arePropsEqual(currentProps, nextProps) {\n    for (const key of this._propsToCompare || Object.keys(nextProps)) {\n      if (!(key in currentProps) || !(key in nextProps) || !Object(math_gl__WEBPACK_IMPORTED_MODULE_0__[\"equals\"])(currentProps[key], nextProps[key])) {\n        return false;\n      }\n    }\n\n    return true;\n  }\n\n  initializeProps(startProps, endProps) {\n    let result;\n\n    if (this._propsToExtract) {\n      const startViewStateProps = {};\n      const endViewStateProps = {};\n\n      for (const key of this._propsToExtract) {\n        startViewStateProps[key] = startProps[key];\n        endViewStateProps[key] = endProps[key];\n      }\n\n      result = {\n        start: startViewStateProps,\n        end: endViewStateProps\n      };\n    } else {\n      result = {\n        start: startProps,\n        end: endProps\n      };\n    }\n\n    this._checkRequiredProps(result.start);\n\n    this._checkRequiredProps(result.end);\n\n    return result;\n  }\n\n  interpolateProps(startProps, endProps, t) {\n    return endProps;\n  }\n\n  getDuration(startProps, endProps) {\n    return endProps.transitionDuration;\n  }\n\n  _checkRequiredProps(props) {\n    if (!this._requiredProps) {\n      return;\n    }\n\n    this._requiredProps.forEach(propName => {\n      const value = props[propName];\n      Object(_utils_assert__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(Number.isFinite(value) || Array.isArray(value), \"\".concat(propName, \" is required for transition\"));\n    });\n  }\n\n}\n//# sourceMappingURL=transition-interpolator.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/transitions/transition-interpolator.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/transitions/transition.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/transitions/transition.js ***!
  \***********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return Transition; });\nfunction noop() {}\n\nconst DEFAULT_SETTINGS = {\n  onStart: noop,\n  onUpdate: noop,\n  onInterrupt: noop,\n  onEnd: noop\n};\nclass Transition {\n  constructor(timeline) {\n    this._inProgress = false;\n    this._handle = null;\n    this.timeline = timeline;\n    this.settings = {};\n  }\n\n  get inProgress() {\n    return this._inProgress;\n  }\n\n  start(props) {\n    this.cancel();\n    this.settings = { ...DEFAULT_SETTINGS,\n      ...props\n    };\n    this._inProgress = true;\n    this.settings.onStart(this);\n  }\n\n  end() {\n    if (this._inProgress) {\n      this.timeline.removeChannel(this._handle);\n      this._handle = null;\n      this._inProgress = false;\n      this.settings.onEnd(this);\n    }\n  }\n\n  cancel() {\n    if (this._inProgress) {\n      this.settings.onInterrupt(this);\n      this.timeline.removeChannel(this._handle);\n      this._handle = null;\n      this._inProgress = false;\n    }\n  }\n\n  update() {\n    if (!this._inProgress) {\n      return false;\n    }\n\n    if (this._handle === null) {\n      const {\n        timeline,\n        settings\n      } = this;\n      this._handle = timeline.addChannel({\n        delay: timeline.getTime(),\n        duration: settings.duration\n      });\n    }\n\n    this.time = this.timeline.getTime(this._handle);\n\n    this._onUpdate();\n\n    this.settings.onUpdate(this);\n\n    if (this.timeline.isFinished(this._handle)) {\n      this.end();\n    }\n\n    return true;\n  }\n\n  _onUpdate() {}\n\n}\n//# sourceMappingURL=transition.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/transitions/transition.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/utils/array-utils.js":
/*!******************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/utils/array-utils.js ***!
  \******************************************************************/
/*! exports provided: padArray */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"padArray\", function() { return padArray; });\nfunction padArrayChunk({\n  source,\n  target,\n  start = 0,\n  end,\n  size,\n  getData\n}) {\n  end = end || target.length;\n  const sourceLength = source.length;\n  const targetLength = end - start;\n\n  if (sourceLength > targetLength) {\n    target.set(source.subarray(0, targetLength), start);\n    return;\n  }\n\n  target.set(source, start);\n\n  if (!getData) {\n    return;\n  }\n\n  let i = sourceLength;\n\n  while (i < targetLength) {\n    const datum = getData(i, source);\n\n    for (let j = 0; j < size; j++) {\n      target[start + i] = datum[j] || 0;\n      i++;\n    }\n  }\n}\n\nfunction padArray({\n  source,\n  target,\n  size,\n  getData,\n  sourceStartIndices,\n  targetStartIndices\n}) {\n  if (!Array.isArray(targetStartIndices)) {\n    padArrayChunk({\n      source,\n      target,\n      size,\n      getData\n    });\n    return target;\n  }\n\n  let sourceIndex = 0;\n  let targetIndex = 0;\n\n  const getChunkData = getData && ((i, chunk) => getData(i + targetIndex, chunk));\n\n  const n = Math.min(sourceStartIndices.length, targetStartIndices.length);\n\n  for (let i = 1; i < n; i++) {\n    const nextSourceIndex = sourceStartIndices[i] * size;\n    const nextTargetIndex = targetStartIndices[i] * size;\n    padArrayChunk({\n      source: source.subarray(sourceIndex, nextSourceIndex),\n      target,\n      start: targetIndex,\n      end: nextTargetIndex,\n      size,\n      getData: getChunkData\n    });\n    sourceIndex = nextSourceIndex;\n    targetIndex = nextTargetIndex;\n  }\n\n  if (targetIndex < target.length) {\n    padArrayChunk({\n      source: [],\n      target,\n      start: targetIndex,\n      size,\n      getData: getChunkData\n    });\n  }\n\n  return target;\n}\n//# sourceMappingURL=array-utils.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/utils/array-utils.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/utils/assert.js":
/*!*************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/utils/assert.js ***!
  \*************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return assert; });\nfunction assert(condition, message) {\n  if (!condition) {\n    throw new Error(message || 'deck.gl: assertion failed.');\n  }\n}\n//# sourceMappingURL=assert.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS91dGlscy9hc3NlcnQuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS91dGlscy9hc3NlcnQuanM/NTRjMCJdLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgZGVmYXVsdCBmdW5jdGlvbiBhc3NlcnQoY29uZGl0aW9uLCBtZXNzYWdlKSB7XG4gIGlmICghY29uZGl0aW9uKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKG1lc3NhZ2UgfHwgJ2RlY2suZ2w6IGFzc2VydGlvbiBmYWlsZWQuJyk7XG4gIH1cbn1cbi8vIyBzb3VyY2VNYXBwaW5nVVJMPWFzc2VydC5qcy5tYXAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/utils/assert.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/utils/count.js":
/*!************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/utils/count.js ***!
  \************************************************************/
/*! exports provided: count */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"count\", function() { return count; });\nconst ERR_NOT_OBJECT = 'count(): argument not an object';\nconst ERR_NOT_CONTAINER = 'count(): argument not a container';\nfunction count(container) {\n  if (!isObject(container)) {\n    throw new Error(ERR_NOT_OBJECT);\n  }\n\n  if (typeof container.count === 'function') {\n    return container.count();\n  }\n\n  if (Number.isFinite(container.size)) {\n    return container.size;\n  }\n\n  if (Number.isFinite(container.length)) {\n    return container.length;\n  }\n\n  if (isPlainObject(container)) {\n    return Object.keys(container).length;\n  }\n\n  throw new Error(ERR_NOT_CONTAINER);\n}\n\nfunction isPlainObject(value) {\n  return value !== null && typeof value === 'object' && value.constructor === Object;\n}\n\nfunction isObject(value) {\n  return value !== null && typeof value === 'object';\n}\n//# sourceMappingURL=count.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS91dGlscy9jb3VudC5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9AZGVjay5nbC9jb3JlL2Rpc3QvZXNtL3V0aWxzL2NvdW50LmpzPzE5ODIiXSwic291cmNlc0NvbnRlbnQiOlsiY29uc3QgRVJSX05PVF9PQkpFQ1QgPSAnY291bnQoKTogYXJndW1lbnQgbm90IGFuIG9iamVjdCc7XG5jb25zdCBFUlJfTk9UX0NPTlRBSU5FUiA9ICdjb3VudCgpOiBhcmd1bWVudCBub3QgYSBjb250YWluZXInO1xuZXhwb3J0IGZ1bmN0aW9uIGNvdW50KGNvbnRhaW5lcikge1xuICBpZiAoIWlzT2JqZWN0KGNvbnRhaW5lcikpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoRVJSX05PVF9PQkpFQ1QpO1xuICB9XG5cbiAgaWYgKHR5cGVvZiBjb250YWluZXIuY291bnQgPT09ICdmdW5jdGlvbicpIHtcbiAgICByZXR1cm4gY29udGFpbmVyLmNvdW50KCk7XG4gIH1cblxuICBpZiAoTnVtYmVyLmlzRmluaXRlKGNvbnRhaW5lci5zaXplKSkge1xuICAgIHJldHVybiBjb250YWluZXIuc2l6ZTtcbiAgfVxuXG4gIGlmIChOdW1iZXIuaXNGaW5pdGUoY29udGFpbmVyLmxlbmd0aCkpIHtcbiAgICByZXR1cm4gY29udGFpbmVyLmxlbmd0aDtcbiAgfVxuXG4gIGlmIChpc1BsYWluT2JqZWN0KGNvbnRhaW5lcikpIHtcbiAgICByZXR1cm4gT2JqZWN0LmtleXMoY29udGFpbmVyKS5sZW5ndGg7XG4gIH1cblxuICB0aHJvdyBuZXcgRXJyb3IoRVJSX05PVF9DT05UQUlORVIpO1xufVxuXG5mdW5jdGlvbiBpc1BsYWluT2JqZWN0KHZhbHVlKSB7XG4gIHJldHVybiB2YWx1ZSAhPT0gbnVsbCAmJiB0eXBlb2YgdmFsdWUgPT09ICdvYmplY3QnICYmIHZhbHVlLmNvbnN0cnVjdG9yID09PSBPYmplY3Q7XG59XG5cbmZ1bmN0aW9uIGlzT2JqZWN0KHZhbHVlKSB7XG4gIHJldHVybiB2YWx1ZSAhPT0gbnVsbCAmJiB0eXBlb2YgdmFsdWUgPT09ICdvYmplY3QnO1xufVxuLy8jIHNvdXJjZU1hcHBpbmdVUkw9Y291bnQuanMubWFwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/utils/count.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/utils/deep-equal.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/utils/deep-equal.js ***!
  \*****************************************************************/
/*! exports provided: deepEqual */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"deepEqual\", function() { return deepEqual; });\nfunction deepEqual(a, b) {\n  if (a === b) {\n    return true;\n  }\n\n  if (!a || !b) {\n    return false;\n  }\n\n  for (const key in a) {\n    const aValue = a[key];\n    const bValue = b[key];\n    const equals = aValue === bValue || Array.isArray(aValue) && Array.isArray(bValue) && deepEqual(aValue, bValue);\n\n    if (!equals) {\n      return false;\n    }\n  }\n\n  return true;\n}\n//# sourceMappingURL=deep-equal.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS91dGlscy9kZWVwLWVxdWFsLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0BkZWNrLmdsL2NvcmUvZGlzdC9lc20vdXRpbHMvZGVlcC1lcXVhbC5qcz8yYzM1Il0sInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCBmdW5jdGlvbiBkZWVwRXF1YWwoYSwgYikge1xuICBpZiAoYSA9PT0gYikge1xuICAgIHJldHVybiB0cnVlO1xuICB9XG5cbiAgaWYgKCFhIHx8ICFiKSB7XG4gICAgcmV0dXJuIGZhbHNlO1xuICB9XG5cbiAgZm9yIChjb25zdCBrZXkgaW4gYSkge1xuICAgIGNvbnN0IGFWYWx1ZSA9IGFba2V5XTtcbiAgICBjb25zdCBiVmFsdWUgPSBiW2tleV07XG4gICAgY29uc3QgZXF1YWxzID0gYVZhbHVlID09PSBiVmFsdWUgfHwgQXJyYXkuaXNBcnJheShhVmFsdWUpICYmIEFycmF5LmlzQXJyYXkoYlZhbHVlKSAmJiBkZWVwRXF1YWwoYVZhbHVlLCBiVmFsdWUpO1xuXG4gICAgaWYgKCFlcXVhbHMpIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gIH1cblxuICByZXR1cm4gdHJ1ZTtcbn1cbi8vIyBzb3VyY2VNYXBwaW5nVVJMPWRlZXAtZXF1YWwuanMubWFwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/utils/deep-equal.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/utils/flatten.js":
/*!**************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/utils/flatten.js ***!
  \**************************************************************/
/*! exports provided: flatten, fillArray */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"flatten\", function() { return flatten; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"fillArray\", function() { return fillArray; });\nfunction flatten(array, filter = () => true) {\n  if (!Array.isArray(array)) {\n    return filter(array) ? [array] : [];\n  }\n\n  return flattenArray(array, filter, []);\n}\n\nfunction flattenArray(array, filter, result) {\n  let index = -1;\n\n  while (++index < array.length) {\n    const value = array[index];\n\n    if (Array.isArray(value)) {\n      flattenArray(value, filter, result);\n    } else if (filter(value)) {\n      result.push(value);\n    }\n  }\n\n  return result;\n}\n\nfunction fillArray({\n  target,\n  source,\n  start = 0,\n  count = 1\n}) {\n  const length = source.length;\n  const total = count * length;\n  let copied = 0;\n\n  for (let i = start; copied < length; copied++) {\n    target[i++] = source[copied];\n  }\n\n  while (copied < total) {\n    if (copied < total - copied) {\n      target.copyWithin(start + copied, start, start + copied);\n      copied *= 2;\n    } else {\n      target.copyWithin(start + copied, start, start + total - copied);\n      copied = total;\n    }\n  }\n\n  return target;\n}\n//# sourceMappingURL=flatten.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/utils/flatten.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/utils/iterable-utils.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/utils/iterable-utils.js ***!
  \*********************************************************************/
/*! exports provided: createIterable, isAsyncIterable, getAccessorFromBuffer */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"createIterable\", function() { return createIterable; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isAsyncIterable\", function() { return isAsyncIterable; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getAccessorFromBuffer\", function() { return getAccessorFromBuffer; });\nconst EMPTY_ARRAY = [];\nconst placeholderArray = [];\nfunction createIterable(data, startRow = 0, endRow = Infinity) {\n  let iterable = EMPTY_ARRAY;\n  const objectInfo = {\n    index: -1,\n    data,\n    target: []\n  };\n\n  if (!data) {\n    iterable = EMPTY_ARRAY;\n  } else if (typeof data[Symbol.iterator] === 'function') {\n    iterable = data;\n  } else if (data.length > 0) {\n    placeholderArray.length = data.length;\n    iterable = placeholderArray;\n  }\n\n  if (startRow > 0 || Number.isFinite(endRow)) {\n    iterable = (Array.isArray(iterable) ? iterable : Array.from(iterable)).slice(startRow, endRow);\n    objectInfo.index = startRow - 1;\n  }\n\n  return {\n    iterable,\n    objectInfo\n  };\n}\nfunction isAsyncIterable(data) {\n  return data && data[Symbol.asyncIterator];\n}\nfunction getAccessorFromBuffer(typedArray, {\n  size,\n  stride,\n  offset,\n  startIndices,\n  nested\n}) {\n  const bytesPerElement = typedArray.BYTES_PER_ELEMENT;\n  const elementStride = stride ? stride / bytesPerElement : size;\n  const elementOffset = offset ? offset / bytesPerElement : 0;\n  const vertexCount = Math.floor((typedArray.length - elementOffset) / elementStride);\n  return (_, {\n    index,\n    target\n  }) => {\n    if (!startIndices) {\n      const sourceIndex = index * elementStride + elementOffset;\n\n      for (let j = 0; j < size; j++) {\n        target[j] = typedArray[sourceIndex + j];\n      }\n\n      return target;\n    }\n\n    const startIndex = startIndices[index];\n    const endIndex = startIndices[index + 1] || vertexCount;\n    let result;\n\n    if (nested) {\n      result = new Array(endIndex - startIndex);\n\n      for (let i = startIndex; i < endIndex; i++) {\n        const sourceIndex = i * elementStride + elementOffset;\n        target = new Array(size);\n\n        for (let j = 0; j < size; j++) {\n          target[j] = typedArray[sourceIndex + j];\n        }\n\n        result[i - startIndex] = target;\n      }\n    } else if (elementStride === size) {\n      result = typedArray.subarray(startIndex * size + elementOffset, endIndex * size + elementOffset);\n    } else {\n      result = new typedArray.constructor((endIndex - startIndex) * size);\n      let targetIndex = 0;\n\n      for (let i = startIndex; i < endIndex; i++) {\n        const sourceIndex = i * elementStride + elementOffset;\n\n        for (let j = 0; j < size; j++) {\n          result[targetIndex++] = typedArray[sourceIndex + j];\n        }\n      }\n    }\n\n    return result;\n  };\n}\n//# sourceMappingURL=iterable-utils.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/utils/iterable-utils.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/utils/json-loader.js":
/*!******************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/utils/json-loader.js ***!
  \******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nfunction isJSON(text) {\n  const firstChar = text[0];\n  const lastChar = text[text.length - 1];\n  return firstChar === '{' && lastChar === '}' || firstChar === '[' && lastChar === ']';\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ({\n  name: 'JSON',\n  extensions: ['json', 'geojson'],\n  mimeTypes: ['application/json', 'application/geo+json'],\n  testText: isJSON,\n  parseTextSync: JSON.parse\n});\n//# sourceMappingURL=json-loader.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS91dGlscy9qc29uLWxvYWRlci5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9AZGVjay5nbC9jb3JlL2Rpc3QvZXNtL3V0aWxzL2pzb24tbG9hZGVyLmpzPzFhMjkiXSwic291cmNlc0NvbnRlbnQiOlsiZnVuY3Rpb24gaXNKU09OKHRleHQpIHtcbiAgY29uc3QgZmlyc3RDaGFyID0gdGV4dFswXTtcbiAgY29uc3QgbGFzdENoYXIgPSB0ZXh0W3RleHQubGVuZ3RoIC0gMV07XG4gIHJldHVybiBmaXJzdENoYXIgPT09ICd7JyAmJiBsYXN0Q2hhciA9PT0gJ30nIHx8IGZpcnN0Q2hhciA9PT0gJ1snICYmIGxhc3RDaGFyID09PSAnXSc7XG59XG5cbmV4cG9ydCBkZWZhdWx0IHtcbiAgbmFtZTogJ0pTT04nLFxuICBleHRlbnNpb25zOiBbJ2pzb24nLCAnZ2VvanNvbiddLFxuICBtaW1lVHlwZXM6IFsnYXBwbGljYXRpb24vanNvbicsICdhcHBsaWNhdGlvbi9nZW8ranNvbiddLFxuICB0ZXN0VGV4dDogaXNKU09OLFxuICBwYXJzZVRleHRTeW5jOiBKU09OLnBhcnNlXG59O1xuLy8jIHNvdXJjZU1hcHBpbmdVUkw9anNvbi1sb2FkZXIuanMubWFwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/utils/json-loader.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/utils/log.js":
/*!**********************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/utils/log.js ***!
  \**********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var probe_gl__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! probe.gl */ \"./node_modules/probe.gl/dist/esm/lib/log.js\");\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (new probe_gl__WEBPACK_IMPORTED_MODULE_0__[\"default\"]({\n  id: 'deck'\n}));\n//# sourceMappingURL=log.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS91dGlscy9sb2cuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS91dGlscy9sb2cuanM/MjYxZiJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBMb2cgfSBmcm9tICdwcm9iZS5nbCc7XG5leHBvcnQgZGVmYXVsdCBuZXcgTG9nKHtcbiAgaWQ6ICdkZWNrJ1xufSk7XG4vLyMgc291cmNlTWFwcGluZ1VSTD1sb2cuanMubWFwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/utils/log.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/utils/math-utils.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/utils/math-utils.js ***!
  \*****************************************************************/
/*! exports provided: createMat4, mod, getCameraPosition, getFrustumPlanes, fp64LowPart, toDoublePrecisionArray */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"createMat4\", function() { return createMat4; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"mod\", function() { return mod; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getCameraPosition\", function() { return getCameraPosition; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getFrustumPlanes\", function() { return getFrustumPlanes; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"fp64LowPart\", function() { return fp64LowPart; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"toDoublePrecisionArray\", function() { return toDoublePrecisionArray; });\n/* harmony import */ var _typed_array_manager__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./typed-array-manager */ \"./node_modules/@deck.gl/core/dist/esm/utils/typed-array-manager.js\");\n/* harmony import */ var math_gl__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! math.gl */ \"./node_modules/math.gl/dist/esm/index.js\");\n\n\nfunction createMat4() {\n  return [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1];\n}\nfunction mod(value, divisor) {\n  const modulus = value % divisor;\n  return modulus < 0 ? divisor + modulus : modulus;\n}\nfunction getCameraPosition(viewMatrixInverse) {\n  return [viewMatrixInverse[12], viewMatrixInverse[13], viewMatrixInverse[14]];\n}\nfunction getFrustumPlanes(viewProjectionMatrix) {\n  const planes = {};\n  planes.left = getFrustumPlane(viewProjectionMatrix[3] + viewProjectionMatrix[0], viewProjectionMatrix[7] + viewProjectionMatrix[4], viewProjectionMatrix[11] + viewProjectionMatrix[8], viewProjectionMatrix[15] + viewProjectionMatrix[12]);\n  planes.right = getFrustumPlane(viewProjectionMatrix[3] - viewProjectionMatrix[0], viewProjectionMatrix[7] - viewProjectionMatrix[4], viewProjectionMatrix[11] - viewProjectionMatrix[8], viewProjectionMatrix[15] - viewProjectionMatrix[12]);\n  planes.bottom = getFrustumPlane(viewProjectionMatrix[3] + viewProjectionMatrix[1], viewProjectionMatrix[7] + viewProjectionMatrix[5], viewProjectionMatrix[11] + viewProjectionMatrix[9], viewProjectionMatrix[15] + viewProjectionMatrix[13]);\n  planes.top = getFrustumPlane(viewProjectionMatrix[3] - viewProjectionMatrix[1], viewProjectionMatrix[7] - viewProjectionMatrix[5], viewProjectionMatrix[11] - viewProjectionMatrix[9], viewProjectionMatrix[15] - viewProjectionMatrix[13]);\n  planes.near = getFrustumPlane(viewProjectionMatrix[3] + viewProjectionMatrix[2], viewProjectionMatrix[7] + viewProjectionMatrix[6], viewProjectionMatrix[11] + viewProjectionMatrix[10], viewProjectionMatrix[15] + viewProjectionMatrix[14]);\n  planes.far = getFrustumPlane(viewProjectionMatrix[3] - viewProjectionMatrix[2], viewProjectionMatrix[7] - viewProjectionMatrix[6], viewProjectionMatrix[11] - viewProjectionMatrix[10], viewProjectionMatrix[15] - viewProjectionMatrix[14]);\n  return planes;\n}\nconst scratchVector = new math_gl__WEBPACK_IMPORTED_MODULE_1__[\"Vector3\"]();\n\nfunction getFrustumPlane(a, b, c, d) {\n  scratchVector.set(a, b, c);\n  const L = scratchVector.len();\n  return {\n    distance: d / L,\n    normal: new math_gl__WEBPACK_IMPORTED_MODULE_1__[\"Vector3\"](-a / L, -b / L, -c / L)\n  };\n}\n\nfunction fp64LowPart(x) {\n  return x - Math.fround(x);\n}\nlet scratchArray;\nfunction toDoublePrecisionArray(typedArray, {\n  size = 1,\n  startIndex = 0,\n  endIndex\n}) {\n  if (!Number.isFinite(endIndex)) {\n    endIndex = typedArray.length;\n  }\n\n  const count = (endIndex - startIndex) / size;\n  scratchArray = _typed_array_manager__WEBPACK_IMPORTED_MODULE_0__[\"default\"].allocate(scratchArray, count, {\n    type: Float32Array,\n    size: size * 2\n  });\n  let sourceIndex = startIndex;\n  let targetIndex = 0;\n\n  while (sourceIndex < endIndex) {\n    for (let j = 0; j < size; j++) {\n      const value = typedArray[sourceIndex++];\n      scratchArray[targetIndex + j] = value;\n      scratchArray[targetIndex + j + size] = fp64LowPart(value);\n    }\n\n    targetIndex += size * 2;\n  }\n\n  return scratchArray.subarray(0, count * size * 2);\n}\n//# sourceMappingURL=math-utils.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS91dGlscy9tYXRoLXV0aWxzLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0BkZWNrLmdsL2NvcmUvZGlzdC9lc20vdXRpbHMvbWF0aC11dGlscy5qcz8xN2M2Il0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB0eXBlZEFycmF5TWFuYWdlciBmcm9tICcuL3R5cGVkLWFycmF5LW1hbmFnZXInO1xuaW1wb3J0IHsgVmVjdG9yMyB9IGZyb20gJ21hdGguZ2wnO1xuZXhwb3J0IGZ1bmN0aW9uIGNyZWF0ZU1hdDQoKSB7XG4gIHJldHVybiBbMSwgMCwgMCwgMCwgMCwgMSwgMCwgMCwgMCwgMCwgMSwgMCwgMCwgMCwgMCwgMV07XG59XG5leHBvcnQgZnVuY3Rpb24gbW9kKHZhbHVlLCBkaXZpc29yKSB7XG4gIGNvbnN0IG1vZHVsdXMgPSB2YWx1ZSAlIGRpdmlzb3I7XG4gIHJldHVybiBtb2R1bHVzIDwgMCA/IGRpdmlzb3IgKyBtb2R1bHVzIDogbW9kdWx1cztcbn1cbmV4cG9ydCBmdW5jdGlvbiBnZXRDYW1lcmFQb3NpdGlvbih2aWV3TWF0cml4SW52ZXJzZSkge1xuICByZXR1cm4gW3ZpZXdNYXRyaXhJbnZlcnNlWzEyXSwgdmlld01hdHJpeEludmVyc2VbMTNdLCB2aWV3TWF0cml4SW52ZXJzZVsxNF1dO1xufVxuZXhwb3J0IGZ1bmN0aW9uIGdldEZydXN0dW1QbGFuZXModmlld1Byb2plY3Rpb25NYXRyaXgpIHtcbiAgY29uc3QgcGxhbmVzID0ge307XG4gIHBsYW5lcy5sZWZ0ID0gZ2V0RnJ1c3R1bVBsYW5lKHZpZXdQcm9qZWN0aW9uTWF0cml4WzNdICsgdmlld1Byb2plY3Rpb25NYXRyaXhbMF0sIHZpZXdQcm9qZWN0aW9uTWF0cml4WzddICsgdmlld1Byb2plY3Rpb25NYXRyaXhbNF0sIHZpZXdQcm9qZWN0aW9uTWF0cml4WzExXSArIHZpZXdQcm9qZWN0aW9uTWF0cml4WzhdLCB2aWV3UHJvamVjdGlvbk1hdHJpeFsxNV0gKyB2aWV3UHJvamVjdGlvbk1hdHJpeFsxMl0pO1xuICBwbGFuZXMucmlnaHQgPSBnZXRGcnVzdHVtUGxhbmUodmlld1Byb2plY3Rpb25NYXRyaXhbM10gLSB2aWV3UHJvamVjdGlvbk1hdHJpeFswXSwgdmlld1Byb2plY3Rpb25NYXRyaXhbN10gLSB2aWV3UHJvamVjdGlvbk1hdHJpeFs0XSwgdmlld1Byb2plY3Rpb25NYXRyaXhbMTFdIC0gdmlld1Byb2plY3Rpb25NYXRyaXhbOF0sIHZpZXdQcm9qZWN0aW9uTWF0cml4WzE1XSAtIHZpZXdQcm9qZWN0aW9uTWF0cml4WzEyXSk7XG4gIHBsYW5lcy5ib3R0b20gPSBnZXRGcnVzdHVtUGxhbmUodmlld1Byb2plY3Rpb25NYXRyaXhbM10gKyB2aWV3UHJvamVjdGlvbk1hdHJpeFsxXSwgdmlld1Byb2plY3Rpb25NYXRyaXhbN10gKyB2aWV3UHJvamVjdGlvbk1hdHJpeFs1XSwgdmlld1Byb2plY3Rpb25NYXRyaXhbMTFdICsgdmlld1Byb2plY3Rpb25NYXRyaXhbOV0sIHZpZXdQcm9qZWN0aW9uTWF0cml4WzE1XSArIHZpZXdQcm9qZWN0aW9uTWF0cml4WzEzXSk7XG4gIHBsYW5lcy50b3AgPSBnZXRGcnVzdHVtUGxhbmUodmlld1Byb2plY3Rpb25NYXRyaXhbM10gLSB2aWV3UHJvamVjdGlvbk1hdHJpeFsxXSwgdmlld1Byb2plY3Rpb25NYXRyaXhbN10gLSB2aWV3UHJvamVjdGlvbk1hdHJpeFs1XSwgdmlld1Byb2plY3Rpb25NYXRyaXhbMTFdIC0gdmlld1Byb2plY3Rpb25NYXRyaXhbOV0sIHZpZXdQcm9qZWN0aW9uTWF0cml4WzE1XSAtIHZpZXdQcm9qZWN0aW9uTWF0cml4WzEzXSk7XG4gIHBsYW5lcy5uZWFyID0gZ2V0RnJ1c3R1bVBsYW5lKHZpZXdQcm9qZWN0aW9uTWF0cml4WzNdICsgdmlld1Byb2plY3Rpb25NYXRyaXhbMl0sIHZpZXdQcm9qZWN0aW9uTWF0cml4WzddICsgdmlld1Byb2plY3Rpb25NYXRyaXhbNl0sIHZpZXdQcm9qZWN0aW9uTWF0cml4WzExXSArIHZpZXdQcm9qZWN0aW9uTWF0cml4WzEwXSwgdmlld1Byb2plY3Rpb25NYXRyaXhbMTVdICsgdmlld1Byb2plY3Rpb25NYXRyaXhbMTRdKTtcbiAgcGxhbmVzLmZhciA9IGdldEZydXN0dW1QbGFuZSh2aWV3UHJvamVjdGlvbk1hdHJpeFszXSAtIHZpZXdQcm9qZWN0aW9uTWF0cml4WzJdLCB2aWV3UHJvamVjdGlvbk1hdHJpeFs3XSAtIHZpZXdQcm9qZWN0aW9uTWF0cml4WzZdLCB2aWV3UHJvamVjdGlvbk1hdHJpeFsxMV0gLSB2aWV3UHJvamVjdGlvbk1hdHJpeFsxMF0sIHZpZXdQcm9qZWN0aW9uTWF0cml4WzE1XSAtIHZpZXdQcm9qZWN0aW9uTWF0cml4WzE0XSk7XG4gIHJldHVybiBwbGFuZXM7XG59XG5jb25zdCBzY3JhdGNoVmVjdG9yID0gbmV3IFZlY3RvcjMoKTtcblxuZnVuY3Rpb24gZ2V0RnJ1c3R1bVBsYW5lKGEsIGIsIGMsIGQpIHtcbiAgc2NyYXRjaFZlY3Rvci5zZXQoYSwgYiwgYyk7XG4gIGNvbnN0IEwgPSBzY3JhdGNoVmVjdG9yLmxlbigpO1xuICByZXR1cm4ge1xuICAgIGRpc3RhbmNlOiBkIC8gTCxcbiAgICBub3JtYWw6IG5ldyBWZWN0b3IzKC1hIC8gTCwgLWIgLyBMLCAtYyAvIEwpXG4gIH07XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBmcDY0TG93UGFydCh4KSB7XG4gIHJldHVybiB4IC0gTWF0aC5mcm91bmQoeCk7XG59XG5sZXQgc2NyYXRjaEFycmF5O1xuZXhwb3J0IGZ1bmN0aW9uIHRvRG91YmxlUHJlY2lzaW9uQXJyYXkodHlwZWRBcnJheSwge1xuICBzaXplID0gMSxcbiAgc3RhcnRJbmRleCA9IDAsXG4gIGVuZEluZGV4XG59KSB7XG4gIGlmICghTnVtYmVyLmlzRmluaXRlKGVuZEluZGV4KSkge1xuICAgIGVuZEluZGV4ID0gdHlwZWRBcnJheS5sZW5ndGg7XG4gIH1cblxuICBjb25zdCBjb3VudCA9IChlbmRJbmRleCAtIHN0YXJ0SW5kZXgpIC8gc2l6ZTtcbiAgc2NyYXRjaEFycmF5ID0gdHlwZWRBcnJheU1hbmFnZXIuYWxsb2NhdGUoc2NyYXRjaEFycmF5LCBjb3VudCwge1xuICAgIHR5cGU6IEZsb2F0MzJBcnJheSxcbiAgICBzaXplOiBzaXplICogMlxuICB9KTtcbiAgbGV0IHNvdXJjZUluZGV4ID0gc3RhcnRJbmRleDtcbiAgbGV0IHRhcmdldEluZGV4ID0gMDtcblxuICB3aGlsZSAoc291cmNlSW5kZXggPCBlbmRJbmRleCkge1xuICAgIGZvciAobGV0IGogPSAwOyBqIDwgc2l6ZTsgaisrKSB7XG4gICAgICBjb25zdCB2YWx1ZSA9IHR5cGVkQXJyYXlbc291cmNlSW5kZXgrK107XG4gICAgICBzY3JhdGNoQXJyYXlbdGFyZ2V0SW5kZXggKyBqXSA9IHZhbHVlO1xuICAgICAgc2NyYXRjaEFycmF5W3RhcmdldEluZGV4ICsgaiArIHNpemVdID0gZnA2NExvd1BhcnQodmFsdWUpO1xuICAgIH1cblxuICAgIHRhcmdldEluZGV4ICs9IHNpemUgKiAyO1xuICB9XG5cbiAgcmV0dXJuIHNjcmF0Y2hBcnJheS5zdWJhcnJheSgwLCBjb3VudCAqIHNpemUgKiAyKTtcbn1cbi8vIyBzb3VyY2VNYXBwaW5nVVJMPW1hdGgtdXRpbHMuanMubWFwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/utils/math-utils.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/utils/memoize.js":
/*!**************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/utils/memoize.js ***!
  \**************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return memoize; });\nfunction isEqual(a, b) {\n  if (a === b) {\n    return true;\n  }\n\n  if (Array.isArray(a)) {\n    const len = a.length;\n\n    if (!b || b.length !== len) {\n      return false;\n    }\n\n    for (let i = 0; i < len; i++) {\n      if (a[i] !== b[i]) {\n        return false;\n      }\n    }\n\n    return true;\n  }\n\n  return false;\n}\n\nfunction memoize(compute) {\n  let cachedArgs = {};\n  let cachedResult;\n  return args => {\n    for (const key in args) {\n      if (!isEqual(args[key], cachedArgs[key])) {\n        cachedResult = compute(args);\n        cachedArgs = args;\n        break;\n      }\n    }\n\n    return cachedResult;\n  };\n}\n//# sourceMappingURL=memoize.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS91dGlscy9tZW1vaXplLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0BkZWNrLmdsL2NvcmUvZGlzdC9lc20vdXRpbHMvbWVtb2l6ZS5qcz8zODg1Il0sInNvdXJjZXNDb250ZW50IjpbImZ1bmN0aW9uIGlzRXF1YWwoYSwgYikge1xuICBpZiAoYSA9PT0gYikge1xuICAgIHJldHVybiB0cnVlO1xuICB9XG5cbiAgaWYgKEFycmF5LmlzQXJyYXkoYSkpIHtcbiAgICBjb25zdCBsZW4gPSBhLmxlbmd0aDtcblxuICAgIGlmICghYiB8fCBiLmxlbmd0aCAhPT0gbGVuKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuXG4gICAgZm9yIChsZXQgaSA9IDA7IGkgPCBsZW47IGkrKykge1xuICAgICAgaWYgKGFbaV0gIT09IGJbaV0pIHtcbiAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgICAgfVxuICAgIH1cblxuICAgIHJldHVybiB0cnVlO1xuICB9XG5cbiAgcmV0dXJuIGZhbHNlO1xufVxuXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiBtZW1vaXplKGNvbXB1dGUpIHtcbiAgbGV0IGNhY2hlZEFyZ3MgPSB7fTtcbiAgbGV0IGNhY2hlZFJlc3VsdDtcbiAgcmV0dXJuIGFyZ3MgPT4ge1xuICAgIGZvciAoY29uc3Qga2V5IGluIGFyZ3MpIHtcbiAgICAgIGlmICghaXNFcXVhbChhcmdzW2tleV0sIGNhY2hlZEFyZ3Nba2V5XSkpIHtcbiAgICAgICAgY2FjaGVkUmVzdWx0ID0gY29tcHV0ZShhcmdzKTtcbiAgICAgICAgY2FjaGVkQXJncyA9IGFyZ3M7XG4gICAgICAgIGJyZWFrO1xuICAgICAgfVxuICAgIH1cblxuICAgIHJldHVybiBjYWNoZWRSZXN1bHQ7XG4gIH07XG59XG4vLyMgc291cmNlTWFwcGluZ1VSTD1tZW1vaXplLmpzLm1hcCJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/utils/memoize.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/utils/positions.js":
/*!****************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/utils/positions.js ***!
  \****************************************************************/
/*! exports provided: parsePosition, getPosition */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"parsePosition\", function() { return parsePosition; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getPosition\", function() { return getPosition; });\nconst PERCENT_OR_PIXELS_REGEX = /([0-9]+\\.?[0-9]*)(%|px)/;\nfunction parsePosition(value) {\n  switch (typeof value) {\n    case 'number':\n      return {\n        position: value,\n        relative: false\n      };\n\n    case 'string':\n      const match = value.match(PERCENT_OR_PIXELS_REGEX);\n\n      if (match && match.length >= 3) {\n        const relative = match[2] === '%';\n        const position = parseFloat(match[1]);\n        return {\n          position: relative ? position / 100 : position,\n          relative\n        };\n      }\n\n    default:\n      throw new Error(\"Could not parse position string \".concat(value));\n  }\n}\nfunction getPosition(position, extent) {\n  return position.relative ? Math.round(position.position * extent) : position.position;\n}\n//# sourceMappingURL=positions.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS91dGlscy9wb3NpdGlvbnMuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS91dGlscy9wb3NpdGlvbnMuanM/YTUzZiJdLCJzb3VyY2VzQ29udGVudCI6WyJjb25zdCBQRVJDRU5UX09SX1BJWEVMU19SRUdFWCA9IC8oWzAtOV0rXFwuP1swLTldKikoJXxweCkvO1xuZXhwb3J0IGZ1bmN0aW9uIHBhcnNlUG9zaXRpb24odmFsdWUpIHtcbiAgc3dpdGNoICh0eXBlb2YgdmFsdWUpIHtcbiAgICBjYXNlICdudW1iZXInOlxuICAgICAgcmV0dXJuIHtcbiAgICAgICAgcG9zaXRpb246IHZhbHVlLFxuICAgICAgICByZWxhdGl2ZTogZmFsc2VcbiAgICAgIH07XG5cbiAgICBjYXNlICdzdHJpbmcnOlxuICAgICAgY29uc3QgbWF0Y2ggPSB2YWx1ZS5tYXRjaChQRVJDRU5UX09SX1BJWEVMU19SRUdFWCk7XG5cbiAgICAgIGlmIChtYXRjaCAmJiBtYXRjaC5sZW5ndGggPj0gMykge1xuICAgICAgICBjb25zdCByZWxhdGl2ZSA9IG1hdGNoWzJdID09PSAnJSc7XG4gICAgICAgIGNvbnN0IHBvc2l0aW9uID0gcGFyc2VGbG9hdChtYXRjaFsxXSk7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgcG9zaXRpb246IHJlbGF0aXZlID8gcG9zaXRpb24gLyAxMDAgOiBwb3NpdGlvbixcbiAgICAgICAgICByZWxhdGl2ZVxuICAgICAgICB9O1xuICAgICAgfVxuXG4gICAgZGVmYXVsdDpcbiAgICAgIHRocm93IG5ldyBFcnJvcihcIkNvdWxkIG5vdCBwYXJzZSBwb3NpdGlvbiBzdHJpbmcgXCIuY29uY2F0KHZhbHVlKSk7XG4gIH1cbn1cbmV4cG9ydCBmdW5jdGlvbiBnZXRQb3NpdGlvbihwb3NpdGlvbiwgZXh0ZW50KSB7XG4gIHJldHVybiBwb3NpdGlvbi5yZWxhdGl2ZSA/IE1hdGgucm91bmQocG9zaXRpb24ucG9zaXRpb24gKiBleHRlbnQpIDogcG9zaXRpb24ucG9zaXRpb247XG59XG4vLyMgc291cmNlTWFwcGluZ1VSTD1wb3NpdGlvbnMuanMubWFwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/utils/positions.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/utils/range.js":
/*!************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/utils/range.js ***!
  \************************************************************/
/*! exports provided: EMPTY, FULL, add */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"EMPTY\", function() { return EMPTY; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"FULL\", function() { return FULL; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"add\", function() { return add; });\nconst EMPTY = [];\nconst FULL = [[0, Infinity]];\nfunction add(rangeList, range) {\n  if (rangeList === FULL) {\n    return rangeList;\n  }\n\n  if (range[0] < 0) {\n    range[0] = 0;\n  }\n\n  if (range[0] >= range[1]) {\n    return rangeList;\n  }\n\n  const newRangeList = [];\n  const len = rangeList.length;\n  let insertPosition = 0;\n\n  for (let i = 0; i < len; i++) {\n    const range0 = rangeList[i];\n\n    if (range0[1] < range[0]) {\n      newRangeList.push(range0);\n      insertPosition = i + 1;\n    } else if (range0[0] > range[1]) {\n      newRangeList.push(range0);\n    } else {\n      range = [Math.min(range0[0], range[0]), Math.max(range0[1], range[1])];\n    }\n  }\n\n  newRangeList.splice(insertPosition, 0, range);\n  return newRangeList;\n}\n//# sourceMappingURL=range.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS91dGlscy9yYW5nZS5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9AZGVjay5nbC9jb3JlL2Rpc3QvZXNtL3V0aWxzL3JhbmdlLmpzP2VlODAiXSwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IGNvbnN0IEVNUFRZID0gW107XG5leHBvcnQgY29uc3QgRlVMTCA9IFtbMCwgSW5maW5pdHldXTtcbmV4cG9ydCBmdW5jdGlvbiBhZGQocmFuZ2VMaXN0LCByYW5nZSkge1xuICBpZiAocmFuZ2VMaXN0ID09PSBGVUxMKSB7XG4gICAgcmV0dXJuIHJhbmdlTGlzdDtcbiAgfVxuXG4gIGlmIChyYW5nZVswXSA8IDApIHtcbiAgICByYW5nZVswXSA9IDA7XG4gIH1cblxuICBpZiAocmFuZ2VbMF0gPj0gcmFuZ2VbMV0pIHtcbiAgICByZXR1cm4gcmFuZ2VMaXN0O1xuICB9XG5cbiAgY29uc3QgbmV3UmFuZ2VMaXN0ID0gW107XG4gIGNvbnN0IGxlbiA9IHJhbmdlTGlzdC5sZW5ndGg7XG4gIGxldCBpbnNlcnRQb3NpdGlvbiA9IDA7XG5cbiAgZm9yIChsZXQgaSA9IDA7IGkgPCBsZW47IGkrKykge1xuICAgIGNvbnN0IHJhbmdlMCA9IHJhbmdlTGlzdFtpXTtcblxuICAgIGlmIChyYW5nZTBbMV0gPCByYW5nZVswXSkge1xuICAgICAgbmV3UmFuZ2VMaXN0LnB1c2gocmFuZ2UwKTtcbiAgICAgIGluc2VydFBvc2l0aW9uID0gaSArIDE7XG4gICAgfSBlbHNlIGlmIChyYW5nZTBbMF0gPiByYW5nZVsxXSkge1xuICAgICAgbmV3UmFuZ2VMaXN0LnB1c2gocmFuZ2UwKTtcbiAgICB9IGVsc2Uge1xuICAgICAgcmFuZ2UgPSBbTWF0aC5taW4ocmFuZ2UwWzBdLCByYW5nZVswXSksIE1hdGgubWF4KHJhbmdlMFsxXSwgcmFuZ2VbMV0pXTtcbiAgICB9XG4gIH1cblxuICBuZXdSYW5nZUxpc3Quc3BsaWNlKGluc2VydFBvc2l0aW9uLCAwLCByYW5nZSk7XG4gIHJldHVybiBuZXdSYW5nZUxpc3Q7XG59XG4vLyMgc291cmNlTWFwcGluZ1VSTD1yYW5nZS5qcy5tYXAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/utils/range.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/utils/shader.js":
/*!*************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/utils/shader.js ***!
  \*************************************************************/
/*! exports provided: mergeShaders */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"mergeShaders\", function() { return mergeShaders; });\nfunction mergeShaders(target, source) {\n  if (!source) {\n    return target;\n  }\n\n  const result = { ...target,\n    ...source\n  };\n\n  if ('defines' in source) {\n    result.defines = { ...target.defines,\n      ...source.defines\n    };\n  }\n\n  if ('modules' in source) {\n    result.modules = (target.modules || []).concat(source.modules);\n\n    if (source.modules.some(module => module.name === 'project64')) {\n      const index = result.modules.findIndex(module => module.name === 'project32');\n\n      if (index >= 0) {\n        result.modules.splice(index, 1);\n      }\n    }\n  }\n\n  if ('inject' in source) {\n    if (!target.inject) {\n      result.inject = source.inject;\n    } else {\n      const mergedInjection = { ...target.inject\n      };\n\n      for (const key in source.inject) {\n        mergedInjection[key] = (mergedInjection[key] || '') + source.inject[key];\n      }\n\n      result.inject = mergedInjection;\n    }\n  }\n\n  return result;\n}\n//# sourceMappingURL=shader.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS91dGlscy9zaGFkZXIuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS91dGlscy9zaGFkZXIuanM/OWQ2ZCJdLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgZnVuY3Rpb24gbWVyZ2VTaGFkZXJzKHRhcmdldCwgc291cmNlKSB7XG4gIGlmICghc291cmNlKSB7XG4gICAgcmV0dXJuIHRhcmdldDtcbiAgfVxuXG4gIGNvbnN0IHJlc3VsdCA9IHsgLi4udGFyZ2V0LFxuICAgIC4uLnNvdXJjZVxuICB9O1xuXG4gIGlmICgnZGVmaW5lcycgaW4gc291cmNlKSB7XG4gICAgcmVzdWx0LmRlZmluZXMgPSB7IC4uLnRhcmdldC5kZWZpbmVzLFxuICAgICAgLi4uc291cmNlLmRlZmluZXNcbiAgICB9O1xuICB9XG5cbiAgaWYgKCdtb2R1bGVzJyBpbiBzb3VyY2UpIHtcbiAgICByZXN1bHQubW9kdWxlcyA9ICh0YXJnZXQubW9kdWxlcyB8fCBbXSkuY29uY2F0KHNvdXJjZS5tb2R1bGVzKTtcblxuICAgIGlmIChzb3VyY2UubW9kdWxlcy5zb21lKG1vZHVsZSA9PiBtb2R1bGUubmFtZSA9PT0gJ3Byb2plY3Q2NCcpKSB7XG4gICAgICBjb25zdCBpbmRleCA9IHJlc3VsdC5tb2R1bGVzLmZpbmRJbmRleChtb2R1bGUgPT4gbW9kdWxlLm5hbWUgPT09ICdwcm9qZWN0MzInKTtcblxuICAgICAgaWYgKGluZGV4ID49IDApIHtcbiAgICAgICAgcmVzdWx0Lm1vZHVsZXMuc3BsaWNlKGluZGV4LCAxKTtcbiAgICAgIH1cbiAgICB9XG4gIH1cblxuICBpZiAoJ2luamVjdCcgaW4gc291cmNlKSB7XG4gICAgaWYgKCF0YXJnZXQuaW5qZWN0KSB7XG4gICAgICByZXN1bHQuaW5qZWN0ID0gc291cmNlLmluamVjdDtcbiAgICB9IGVsc2Uge1xuICAgICAgY29uc3QgbWVyZ2VkSW5qZWN0aW9uID0geyAuLi50YXJnZXQuaW5qZWN0XG4gICAgICB9O1xuXG4gICAgICBmb3IgKGNvbnN0IGtleSBpbiBzb3VyY2UuaW5qZWN0KSB7XG4gICAgICAgIG1lcmdlZEluamVjdGlvbltrZXldID0gKG1lcmdlZEluamVjdGlvbltrZXldIHx8ICcnKSArIHNvdXJjZS5pbmplY3Rba2V5XTtcbiAgICAgIH1cblxuICAgICAgcmVzdWx0LmluamVjdCA9IG1lcmdlZEluamVjdGlvbjtcbiAgICB9XG4gIH1cblxuICByZXR1cm4gcmVzdWx0O1xufVxuLy8jIHNvdXJjZU1hcHBpbmdVUkw9c2hhZGVyLmpzLm1hcCJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/utils/shader.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/utils/texture.js":
/*!**************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/utils/texture.js ***!
  \**************************************************************/
/*! exports provided: createTexture, destroyTexture */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"createTexture\", function() { return createTexture; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"destroyTexture\", function() { return destroyTexture; });\n/* harmony import */ var _luma_gl_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @luma.gl/core */ \"./node_modules/@luma.gl/webgl/dist/esm/classes/texture-2d.js\");\n\nconst DEFAULT_TEXTURE_PARAMETERS = {\n  [10241]: 9987,\n  [10240]: 9729,\n  [10242]: 33071,\n  [10243]: 33071\n};\nconst internalTextures = {};\nfunction createTexture(layer, image) {\n  const gl = layer.context && layer.context.gl;\n\n  if (!gl || !image) {\n    return null;\n  }\n\n  if (image instanceof _luma_gl_core__WEBPACK_IMPORTED_MODULE_0__[\"default\"]) {\n    return image;\n  } else if (image.constructor && image.constructor.name !== 'Object') {\n    image = {\n      data: image\n    };\n  }\n\n  let specialTextureParameters = null;\n\n  if (image.compressed) {\n    specialTextureParameters = {\n      [10241]: image.data.length > 1 ? 9985 : 9729\n    };\n  }\n\n  const texture = new _luma_gl_core__WEBPACK_IMPORTED_MODULE_0__[\"default\"](gl, { ...image,\n    parameters: { ...DEFAULT_TEXTURE_PARAMETERS,\n      ...specialTextureParameters,\n      ...layer.props.textureParameters\n    }\n  });\n  internalTextures[texture.id] = true;\n  return texture;\n}\nfunction destroyTexture(texture) {\n  if (!texture || !(texture instanceof _luma_gl_core__WEBPACK_IMPORTED_MODULE_0__[\"default\"])) {\n    return;\n  }\n\n  if (internalTextures[texture.id]) {\n    texture.delete();\n    delete internalTextures[texture.id];\n  }\n}\n//# sourceMappingURL=texture.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/utils/texture.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/utils/typed-array-manager.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/utils/typed-array-manager.js ***!
  \**************************************************************************/
/*! exports provided: TypedArrayManager, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"TypedArrayManager\", function() { return TypedArrayManager; });\nclass TypedArrayManager {\n  constructor(props) {\n    this._pool = [];\n    this.props = {\n      overAlloc: 2,\n      poolSize: 100\n    };\n    this.setProps(props);\n  }\n\n  setProps(props) {\n    Object.assign(this.props, props);\n  }\n\n  allocate(typedArray, count, {\n    size = 1,\n    type,\n    padding = 0,\n    copy = false,\n    initialize = false,\n    maxCount\n  }) {\n    const Type = type || typedArray && typedArray.constructor || Float32Array;\n    const newSize = count * size + padding;\n\n    if (ArrayBuffer.isView(typedArray)) {\n      if (newSize <= typedArray.length) {\n        return typedArray;\n      }\n\n      if (newSize * typedArray.BYTES_PER_ELEMENT <= typedArray.buffer.byteLength) {\n        return new Type(typedArray.buffer, 0, newSize);\n      }\n    }\n\n    let maxSize;\n\n    if (maxCount) {\n      maxSize = maxCount * size + padding;\n    }\n\n    const newArray = this._allocate(Type, newSize, initialize, maxSize);\n\n    if (typedArray && copy) {\n      newArray.set(typedArray);\n    } else if (!initialize) {\n      newArray.fill(0, 0, 4);\n    }\n\n    this._release(typedArray);\n\n    return newArray;\n  }\n\n  release(typedArray) {\n    this._release(typedArray);\n  }\n\n  _allocate(Type, size, initialize, maxSize) {\n    let sizeToAllocate = Math.max(Math.ceil(size * this.props.overAlloc), 1);\n\n    if (sizeToAllocate > maxSize) {\n      sizeToAllocate = maxSize;\n    }\n\n    const pool = this._pool;\n    const byteLength = Type.BYTES_PER_ELEMENT * sizeToAllocate;\n    const i = pool.findIndex(b => b.byteLength >= byteLength);\n\n    if (i >= 0) {\n      const array = new Type(pool.splice(i, 1)[0], 0, sizeToAllocate);\n\n      if (initialize) {\n        array.fill(0);\n      }\n\n      return array;\n    }\n\n    return new Type(sizeToAllocate);\n  }\n\n  _release(typedArray) {\n    if (!ArrayBuffer.isView(typedArray)) {\n      return;\n    }\n\n    const pool = this._pool;\n    const {\n      buffer\n    } = typedArray;\n    const {\n      byteLength\n    } = buffer;\n    const i = pool.findIndex(b => b.byteLength >= byteLength);\n\n    if (i < 0) {\n      pool.push(buffer);\n    } else if (i > 0 || pool.length < this.props.poolSize) {\n      pool.splice(i, 0, buffer);\n    }\n\n    if (pool.length > this.props.poolSize) {\n      pool.shift();\n    }\n  }\n\n}\n/* harmony default export */ __webpack_exports__[\"default\"] = (new TypedArrayManager());\n//# sourceMappingURL=typed-array-manager.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS91dGlscy90eXBlZC1hcnJheS1tYW5hZ2VyLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0BkZWNrLmdsL2NvcmUvZGlzdC9lc20vdXRpbHMvdHlwZWQtYXJyYXktbWFuYWdlci5qcz82ZjQ4Il0sInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCBjbGFzcyBUeXBlZEFycmF5TWFuYWdlciB7XG4gIGNvbnN0cnVjdG9yKHByb3BzKSB7XG4gICAgdGhpcy5fcG9vbCA9IFtdO1xuICAgIHRoaXMucHJvcHMgPSB7XG4gICAgICBvdmVyQWxsb2M6IDIsXG4gICAgICBwb29sU2l6ZTogMTAwXG4gICAgfTtcbiAgICB0aGlzLnNldFByb3BzKHByb3BzKTtcbiAgfVxuXG4gIHNldFByb3BzKHByb3BzKSB7XG4gICAgT2JqZWN0LmFzc2lnbih0aGlzLnByb3BzLCBwcm9wcyk7XG4gIH1cblxuICBhbGxvY2F0ZSh0eXBlZEFycmF5LCBjb3VudCwge1xuICAgIHNpemUgPSAxLFxuICAgIHR5cGUsXG4gICAgcGFkZGluZyA9IDAsXG4gICAgY29weSA9IGZhbHNlLFxuICAgIGluaXRpYWxpemUgPSBmYWxzZSxcbiAgICBtYXhDb3VudFxuICB9KSB7XG4gICAgY29uc3QgVHlwZSA9IHR5cGUgfHwgdHlwZWRBcnJheSAmJiB0eXBlZEFycmF5LmNvbnN0cnVjdG9yIHx8IEZsb2F0MzJBcnJheTtcbiAgICBjb25zdCBuZXdTaXplID0gY291bnQgKiBzaXplICsgcGFkZGluZztcblxuICAgIGlmIChBcnJheUJ1ZmZlci5pc1ZpZXcodHlwZWRBcnJheSkpIHtcbiAgICAgIGlmIChuZXdTaXplIDw9IHR5cGVkQXJyYXkubGVuZ3RoKSB7XG4gICAgICAgIHJldHVybiB0eXBlZEFycmF5O1xuICAgICAgfVxuXG4gICAgICBpZiAobmV3U2l6ZSAqIHR5cGVkQXJyYXkuQllURVNfUEVSX0VMRU1FTlQgPD0gdHlwZWRBcnJheS5idWZmZXIuYnl0ZUxlbmd0aCkge1xuICAgICAgICByZXR1cm4gbmV3IFR5cGUodHlwZWRBcnJheS5idWZmZXIsIDAsIG5ld1NpemUpO1xuICAgICAgfVxuICAgIH1cblxuICAgIGxldCBtYXhTaXplO1xuXG4gICAgaWYgKG1heENvdW50KSB7XG4gICAgICBtYXhTaXplID0gbWF4Q291bnQgKiBzaXplICsgcGFkZGluZztcbiAgICB9XG5cbiAgICBjb25zdCBuZXdBcnJheSA9IHRoaXMuX2FsbG9jYXRlKFR5cGUsIG5ld1NpemUsIGluaXRpYWxpemUsIG1heFNpemUpO1xuXG4gICAgaWYgKHR5cGVkQXJyYXkgJiYgY29weSkge1xuICAgICAgbmV3QXJyYXkuc2V0KHR5cGVkQXJyYXkpO1xuICAgIH0gZWxzZSBpZiAoIWluaXRpYWxpemUpIHtcbiAgICAgIG5ld0FycmF5LmZpbGwoMCwgMCwgNCk7XG4gICAgfVxuXG4gICAgdGhpcy5fcmVsZWFzZSh0eXBlZEFycmF5KTtcblxuICAgIHJldHVybiBuZXdBcnJheTtcbiAgfVxuXG4gIHJlbGVhc2UodHlwZWRBcnJheSkge1xuICAgIHRoaXMuX3JlbGVhc2UodHlwZWRBcnJheSk7XG4gIH1cblxuICBfYWxsb2NhdGUoVHlwZSwgc2l6ZSwgaW5pdGlhbGl6ZSwgbWF4U2l6ZSkge1xuICAgIGxldCBzaXplVG9BbGxvY2F0ZSA9IE1hdGgubWF4KE1hdGguY2VpbChzaXplICogdGhpcy5wcm9wcy5vdmVyQWxsb2MpLCAxKTtcblxuICAgIGlmIChzaXplVG9BbGxvY2F0ZSA+IG1heFNpemUpIHtcbiAgICAgIHNpemVUb0FsbG9jYXRlID0gbWF4U2l6ZTtcbiAgICB9XG5cbiAgICBjb25zdCBwb29sID0gdGhpcy5fcG9vbDtcbiAgICBjb25zdCBieXRlTGVuZ3RoID0gVHlwZS5CWVRFU19QRVJfRUxFTUVOVCAqIHNpemVUb0FsbG9jYXRlO1xuICAgIGNvbnN0IGkgPSBwb29sLmZpbmRJbmRleChiID0+IGIuYnl0ZUxlbmd0aCA+PSBieXRlTGVuZ3RoKTtcblxuICAgIGlmIChpID49IDApIHtcbiAgICAgIGNvbnN0IGFycmF5ID0gbmV3IFR5cGUocG9vbC5zcGxpY2UoaSwgMSlbMF0sIDAsIHNpemVUb0FsbG9jYXRlKTtcblxuICAgICAgaWYgKGluaXRpYWxpemUpIHtcbiAgICAgICAgYXJyYXkuZmlsbCgwKTtcbiAgICAgIH1cblxuICAgICAgcmV0dXJuIGFycmF5O1xuICAgIH1cblxuICAgIHJldHVybiBuZXcgVHlwZShzaXplVG9BbGxvY2F0ZSk7XG4gIH1cblxuICBfcmVsZWFzZSh0eXBlZEFycmF5KSB7XG4gICAgaWYgKCFBcnJheUJ1ZmZlci5pc1ZpZXcodHlwZWRBcnJheSkpIHtcbiAgICAgIHJldHVybjtcbiAgICB9XG5cbiAgICBjb25zdCBwb29sID0gdGhpcy5fcG9vbDtcbiAgICBjb25zdCB7XG4gICAgICBidWZmZXJcbiAgICB9ID0gdHlwZWRBcnJheTtcbiAgICBjb25zdCB7XG4gICAgICBieXRlTGVuZ3RoXG4gICAgfSA9IGJ1ZmZlcjtcbiAgICBjb25zdCBpID0gcG9vbC5maW5kSW5kZXgoYiA9PiBiLmJ5dGVMZW5ndGggPj0gYnl0ZUxlbmd0aCk7XG5cbiAgICBpZiAoaSA8IDApIHtcbiAgICAgIHBvb2wucHVzaChidWZmZXIpO1xuICAgIH0gZWxzZSBpZiAoaSA+IDAgfHwgcG9vbC5sZW5ndGggPCB0aGlzLnByb3BzLnBvb2xTaXplKSB7XG4gICAgICBwb29sLnNwbGljZShpLCAwLCBidWZmZXIpO1xuICAgIH1cblxuICAgIGlmIChwb29sLmxlbmd0aCA+IHRoaXMucHJvcHMucG9vbFNpemUpIHtcbiAgICAgIHBvb2wuc2hpZnQoKTtcbiAgICB9XG4gIH1cblxufVxuZXhwb3J0IGRlZmF1bHQgbmV3IFR5cGVkQXJyYXlNYW5hZ2VyKCk7XG4vLyMgc291cmNlTWFwcGluZ1VSTD10eXBlZC1hcnJheS1tYW5hZ2VyLmpzLm1hcCJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/utils/typed-array-manager.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/viewports/viewport.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/viewports/viewport.js ***!
  \*******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return Viewport; });\n/* harmony import */ var _utils_log__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/log */ \"./node_modules/@deck.gl/core/dist/esm/utils/log.js\");\n/* harmony import */ var _utils_math_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/math-utils */ \"./node_modules/@deck.gl/core/dist/esm/utils/math-utils.js\");\n/* harmony import */ var math_gl__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! math.gl */ \"./node_modules/math.gl/dist/esm/index.js\");\n/* harmony import */ var gl_matrix_mat4__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! gl-matrix/mat4 */ \"./node_modules/gl-matrix/esm/mat4.js\");\n/* harmony import */ var _math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @math.gl/web-mercator */ \"./node_modules/@math.gl/web-mercator/dist/esm/index.js\");\n/* harmony import */ var _lib_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../lib/constants */ \"./node_modules/@deck.gl/core/dist/esm/lib/constants.js\");\n\n\n\n\n\n\nconst DEGREES_TO_RADIANS = Math.PI / 180;\nconst IDENTITY = Object(_utils_math_utils__WEBPACK_IMPORTED_MODULE_1__[\"createMat4\"])();\nconst ZERO_VECTOR = [0, 0, 0];\nconst DEFAULT_ZOOM = 0;\nconst DEFAULT_DISTANCE_SCALES = {\n  unitsPerMeter: [1, 1, 1],\n  metersPerUnit: [1, 1, 1]\n};\nclass Viewport {\n  constructor(opts = {}) {\n    const {\n      id = null,\n      x = 0,\n      y = 0,\n      width = 1,\n      height = 1\n    } = opts;\n    this.id = id || this.constructor.displayName || 'viewport';\n    this.x = x;\n    this.y = y;\n    this.width = width || 1;\n    this.height = height || 1;\n    this._frustumPlanes = {};\n\n    this._initViewMatrix(opts);\n\n    this._initProjectionMatrix(opts);\n\n    this._initPixelMatrices();\n\n    this.equals = this.equals.bind(this);\n    this.project = this.project.bind(this);\n    this.unproject = this.unproject.bind(this);\n    this.projectPosition = this.projectPosition.bind(this);\n    this.unprojectPosition = this.unprojectPosition.bind(this);\n    this.projectFlat = this.projectFlat.bind(this);\n    this.unprojectFlat = this.unprojectFlat.bind(this);\n  }\n\n  get metersPerPixel() {\n    return this.distanceScales.metersPerUnit[2] / this.scale;\n  }\n\n  get projectionMode() {\n    if (this.isGeospatial) {\n      return this.zoom < 12 ? _lib_constants__WEBPACK_IMPORTED_MODULE_5__[\"PROJECTION_MODE\"].WEB_MERCATOR : _lib_constants__WEBPACK_IMPORTED_MODULE_5__[\"PROJECTION_MODE\"].WEB_MERCATOR_AUTO_OFFSET;\n    }\n\n    return _lib_constants__WEBPACK_IMPORTED_MODULE_5__[\"PROJECTION_MODE\"].IDENTITY;\n  }\n\n  equals(viewport) {\n    if (!(viewport instanceof Viewport)) {\n      return false;\n    }\n\n    if (this === viewport) {\n      return true;\n    }\n\n    return viewport.width === this.width && viewport.height === this.height && viewport.scale === this.scale && Object(math_gl__WEBPACK_IMPORTED_MODULE_2__[\"equals\"])(viewport.projectionMatrix, this.projectionMatrix) && Object(math_gl__WEBPACK_IMPORTED_MODULE_2__[\"equals\"])(viewport.viewMatrix, this.viewMatrix);\n  }\n\n  project(xyz, {\n    topLeft = true\n  } = {}) {\n    const worldPosition = this.projectPosition(xyz);\n    const coord = Object(_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_4__[\"worldToPixels\"])(worldPosition, this.pixelProjectionMatrix);\n    const [x, y] = coord;\n    const y2 = topLeft ? y : this.height - y;\n    return xyz.length === 2 ? [x, y2] : [x, y2, coord[2]];\n  }\n\n  unproject(xyz, {\n    topLeft = true,\n    targetZ\n  } = {}) {\n    const [x, y, z] = xyz;\n    const y2 = topLeft ? y : this.height - y;\n    const targetZWorld = targetZ && targetZ * this.distanceScales.unitsPerMeter[2];\n    const coord = Object(_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_4__[\"pixelsToWorld\"])([x, y2, z], this.pixelUnprojectionMatrix, targetZWorld);\n    const [X, Y, Z] = this.unprojectPosition(coord);\n\n    if (Number.isFinite(z)) {\n      return [X, Y, Z];\n    }\n\n    return Number.isFinite(targetZ) ? [X, Y, targetZ] : [X, Y];\n  }\n\n  projectPosition(xyz) {\n    const [X, Y] = this.projectFlat(xyz);\n    const Z = (xyz[2] || 0) * this.distanceScales.unitsPerMeter[2];\n    return [X, Y, Z];\n  }\n\n  unprojectPosition(xyz) {\n    const [X, Y] = this.unprojectFlat(xyz);\n    const Z = (xyz[2] || 0) * this.distanceScales.metersPerUnit[2];\n    return [X, Y, Z];\n  }\n\n  projectFlat(xyz) {\n    if (this.isGeospatial) {\n      return Object(_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_4__[\"lngLatToWorld\"])(xyz);\n    }\n\n    return xyz;\n  }\n\n  unprojectFlat(xyz) {\n    if (this.isGeospatial) {\n      return Object(_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_4__[\"worldToLngLat\"])(xyz);\n    }\n\n    return xyz;\n  }\n\n  getBounds(options = {}) {\n    const unprojectOption = {\n      targetZ: options.z || 0\n    };\n    const topLeft = this.unproject([0, 0], unprojectOption);\n    const topRight = this.unproject([this.width, 0], unprojectOption);\n    const bottomLeft = this.unproject([0, this.height], unprojectOption);\n    const bottomRight = this.unproject([this.width, this.height], unprojectOption);\n    return [Math.min(topLeft[0], topRight[0], bottomLeft[0], bottomRight[0]), Math.min(topLeft[1], topRight[1], bottomLeft[1], bottomRight[1]), Math.max(topLeft[0], topRight[0], bottomLeft[0], bottomRight[0]), Math.max(topLeft[1], topRight[1], bottomLeft[1], bottomRight[1])];\n  }\n\n  getDistanceScales(coordinateOrigin = null) {\n    if (coordinateOrigin) {\n      return Object(_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_4__[\"getDistanceScales\"])({\n        longitude: coordinateOrigin[0],\n        latitude: coordinateOrigin[1],\n        highPrecision: true\n      });\n    }\n\n    return this.distanceScales;\n  }\n\n  containsPixel({\n    x,\n    y,\n    width = 1,\n    height = 1\n  }) {\n    return x < this.x + this.width && this.x < x + width && y < this.y + this.height && this.y < y + height;\n  }\n\n  getFrustumPlanes() {\n    if (this._frustumPlanes.near) {\n      return this._frustumPlanes;\n    }\n\n    Object.assign(this._frustumPlanes, Object(_utils_math_utils__WEBPACK_IMPORTED_MODULE_1__[\"getFrustumPlanes\"])(this.viewProjectionMatrix));\n    return this._frustumPlanes;\n  }\n\n  panByPosition(coords, pixel) {\n    return null;\n  }\n\n  getCameraPosition() {\n    return this.cameraPosition;\n  }\n\n  getCameraDirection() {\n    return this.cameraDirection;\n  }\n\n  getCameraUp() {\n    return this.cameraUp;\n  }\n\n  _createProjectionMatrix({\n    orthographic,\n    fovyRadians,\n    aspect,\n    focalDistance,\n    near,\n    far\n  }) {\n    return orthographic ? new math_gl__WEBPACK_IMPORTED_MODULE_2__[\"Matrix4\"]().orthographic({\n      fovy: fovyRadians,\n      aspect,\n      focalDistance,\n      near,\n      far\n    }) : new math_gl__WEBPACK_IMPORTED_MODULE_2__[\"Matrix4\"]().perspective({\n      fovy: fovyRadians,\n      aspect,\n      near,\n      far\n    });\n  }\n\n  _initViewMatrix(opts) {\n    const {\n      viewMatrix = IDENTITY,\n      longitude = null,\n      latitude = null,\n      zoom = null,\n      position = null,\n      modelMatrix = null,\n      focalDistance = 1,\n      distanceScales = null\n    } = opts;\n    this.isGeospatial = Number.isFinite(latitude) && Number.isFinite(longitude);\n    this.zoom = zoom;\n\n    if (!Number.isFinite(this.zoom)) {\n      this.zoom = this.isGeospatial ? Object(_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_4__[\"getMeterZoom\"])({\n        latitude\n      }) + Math.log2(focalDistance) : DEFAULT_ZOOM;\n    }\n\n    const scale = Math.pow(2, this.zoom);\n    this.scale = scale;\n    this.distanceScales = this.isGeospatial ? Object(_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_4__[\"getDistanceScales\"])({\n      latitude,\n      longitude\n    }) : distanceScales || DEFAULT_DISTANCE_SCALES;\n    this.focalDistance = focalDistance;\n    this.distanceScales.metersPerUnit = new math_gl__WEBPACK_IMPORTED_MODULE_2__[\"Vector3\"](this.distanceScales.metersPerUnit);\n    this.distanceScales.unitsPerMeter = new math_gl__WEBPACK_IMPORTED_MODULE_2__[\"Vector3\"](this.distanceScales.unitsPerMeter);\n    this.position = ZERO_VECTOR;\n    this.meterOffset = ZERO_VECTOR;\n\n    if (position) {\n      this.position = position;\n      this.modelMatrix = modelMatrix;\n      this.meterOffset = modelMatrix ? modelMatrix.transformVector(position) : position;\n    }\n\n    if (this.isGeospatial) {\n      this.longitude = longitude;\n      this.latitude = latitude;\n      this.center = this._getCenterInWorld({\n        longitude,\n        latitude\n      });\n    } else {\n      this.center = position ? this.projectPosition(position) : [0, 0, 0];\n    }\n\n    this.viewMatrixUncentered = viewMatrix;\n    this.viewMatrix = new math_gl__WEBPACK_IMPORTED_MODULE_2__[\"Matrix4\"]().multiplyRight(this.viewMatrixUncentered).translate(new math_gl__WEBPACK_IMPORTED_MODULE_2__[\"Vector3\"](this.center || ZERO_VECTOR).negate());\n  }\n\n  _getCenterInWorld({\n    longitude,\n    latitude\n  }) {\n    const {\n      meterOffset,\n      distanceScales\n    } = this;\n    const center = new math_gl__WEBPACK_IMPORTED_MODULE_2__[\"Vector3\"](this.projectPosition([longitude, latitude, 0]));\n\n    if (meterOffset) {\n      const commonPosition = new math_gl__WEBPACK_IMPORTED_MODULE_2__[\"Vector3\"](meterOffset).scale(distanceScales.unitsPerMeter);\n      center.add(commonPosition);\n    }\n\n    return center;\n  }\n\n  _initProjectionMatrix(opts) {\n    const {\n      projectionMatrix = null,\n      orthographic = false,\n      fovyRadians,\n      fovy = 75,\n      near = 0.1,\n      far = 1000,\n      focalDistance = 1\n    } = opts;\n    this.projectionMatrix = projectionMatrix || this._createProjectionMatrix({\n      orthographic,\n      fovyRadians: fovyRadians || fovy * DEGREES_TO_RADIANS,\n      aspect: this.width / this.height,\n      focalDistance,\n      near,\n      far\n    });\n  }\n\n  _initPixelMatrices() {\n    const vpm = Object(_utils_math_utils__WEBPACK_IMPORTED_MODULE_1__[\"createMat4\"])();\n    gl_matrix_mat4__WEBPACK_IMPORTED_MODULE_3__[\"multiply\"](vpm, vpm, this.projectionMatrix);\n    gl_matrix_mat4__WEBPACK_IMPORTED_MODULE_3__[\"multiply\"](vpm, vpm, this.viewMatrix);\n    this.viewProjectionMatrix = vpm;\n    this.viewMatrixInverse = gl_matrix_mat4__WEBPACK_IMPORTED_MODULE_3__[\"invert\"]([], this.viewMatrix) || this.viewMatrix;\n    this.cameraPosition = Object(_utils_math_utils__WEBPACK_IMPORTED_MODULE_1__[\"getCameraPosition\"])(this.viewMatrixInverse);\n    const viewportMatrix = Object(_utils_math_utils__WEBPACK_IMPORTED_MODULE_1__[\"createMat4\"])();\n    const pixelProjectionMatrix = Object(_utils_math_utils__WEBPACK_IMPORTED_MODULE_1__[\"createMat4\"])();\n    gl_matrix_mat4__WEBPACK_IMPORTED_MODULE_3__[\"scale\"](viewportMatrix, viewportMatrix, [this.width / 2, -this.height / 2, 1]);\n    gl_matrix_mat4__WEBPACK_IMPORTED_MODULE_3__[\"translate\"](viewportMatrix, viewportMatrix, [1, -1, 0]);\n    gl_matrix_mat4__WEBPACK_IMPORTED_MODULE_3__[\"multiply\"](pixelProjectionMatrix, viewportMatrix, this.viewProjectionMatrix);\n    this.pixelProjectionMatrix = pixelProjectionMatrix;\n    this.viewportMatrix = viewportMatrix;\n    this.pixelUnprojectionMatrix = gl_matrix_mat4__WEBPACK_IMPORTED_MODULE_3__[\"invert\"](Object(_utils_math_utils__WEBPACK_IMPORTED_MODULE_1__[\"createMat4\"])(), this.pixelProjectionMatrix);\n\n    if (!this.pixelUnprojectionMatrix) {\n      _utils_log__WEBPACK_IMPORTED_MODULE_0__[\"default\"].warn('Pixel project matrix not invertible')();\n    }\n  }\n\n}\nViewport.displayName = 'Viewport';\n//# sourceMappingURL=viewport.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/viewports/viewport.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/viewports/web-mercator-viewport.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/viewports/web-mercator-viewport.js ***!
  \********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return WebMercatorViewport; });\n/* harmony import */ var _viewport__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./viewport */ \"./node_modules/@deck.gl/core/dist/esm/viewports/viewport.js\");\n/* harmony import */ var _math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @math.gl/web-mercator */ \"./node_modules/@math.gl/web-mercator/dist/esm/index.js\");\n/* harmony import */ var gl_matrix_vec2__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! gl-matrix/vec2 */ \"./node_modules/gl-matrix/esm/vec2.js\");\n/* harmony import */ var math_gl__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! math.gl */ \"./node_modules/math.gl/dist/esm/index.js\");\n\n\n\n\nclass WebMercatorViewport extends _viewport__WEBPACK_IMPORTED_MODULE_0__[\"default\"] {\n  constructor(opts = {}) {\n    const {\n      latitude = 0,\n      longitude = 0,\n      zoom = 11,\n      pitch = 0,\n      bearing = 0,\n      nearZMultiplier = 0.1,\n      farZMultiplier = 1.01,\n      orthographic = false,\n      repeat = false,\n      worldOffset = 0\n    } = opts;\n    let {\n      width,\n      height,\n      altitude = 1.5\n    } = opts;\n    const scale = Math.pow(2, zoom);\n    width = width || 1;\n    height = height || 1;\n    altitude = Math.max(0.75, altitude);\n    const {\n      fov,\n      aspect,\n      focalDistance,\n      near,\n      far\n    } = Object(_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_1__[\"getProjectionParameters\"])({\n      width,\n      height,\n      pitch,\n      altitude,\n      nearZMultiplier,\n      farZMultiplier\n    });\n    let viewMatrixUncentered = Object(_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_1__[\"getViewMatrix\"])({\n      height,\n      pitch,\n      bearing,\n      scale,\n      altitude\n    });\n\n    if (worldOffset) {\n      const viewOffset = new math_gl__WEBPACK_IMPORTED_MODULE_3__[\"Matrix4\"]().translate([512 * worldOffset, 0, 0]);\n      viewMatrixUncentered = viewOffset.multiplyLeft(viewMatrixUncentered);\n    }\n\n    super({ ...opts,\n      width,\n      height,\n      viewMatrix: viewMatrixUncentered,\n      longitude,\n      latitude,\n      zoom,\n      orthographic,\n      fovyRadians: fov,\n      aspect,\n      focalDistance,\n      near,\n      far\n    });\n    this.latitude = latitude;\n    this.longitude = longitude;\n    this.zoom = zoom;\n    this.pitch = pitch;\n    this.bearing = bearing;\n    this.altitude = altitude;\n    this.orthographic = orthographic;\n    this._subViewports = repeat ? [] : null;\n    Object.freeze(this);\n  }\n\n  get subViewports() {\n    if (this._subViewports && !this._subViewports.length) {\n      const bounds = this.getBounds();\n      const minOffset = Math.floor((bounds[0] + 180) / 360);\n      const maxOffset = Math.ceil((bounds[2] - 180) / 360);\n\n      for (let x = minOffset; x <= maxOffset; x++) {\n        const offsetViewport = x ? new WebMercatorViewport({ ...this,\n          worldOffset: x\n        }) : this;\n\n        this._subViewports.push(offsetViewport);\n      }\n    }\n\n    return this._subViewports;\n  }\n\n  addMetersToLngLat(lngLatZ, xyz) {\n    return Object(_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_1__[\"addMetersToLngLat\"])(lngLatZ, xyz);\n  }\n\n  panByPosition(coords, pixel) {\n    const fromLocation = Object(_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_1__[\"pixelsToWorld\"])(pixel, this.pixelUnprojectionMatrix);\n    const toLocation = this.projectFlat(coords);\n    const translate = gl_matrix_vec2__WEBPACK_IMPORTED_MODULE_2__[\"add\"]([], toLocation, gl_matrix_vec2__WEBPACK_IMPORTED_MODULE_2__[\"negate\"]([], fromLocation));\n    const newCenter = gl_matrix_vec2__WEBPACK_IMPORTED_MODULE_2__[\"add\"]([], this.center, translate);\n    const [longitude, latitude] = this.unprojectFlat(newCenter);\n    return {\n      longitude,\n      latitude\n    };\n  }\n\n  getBounds(options = {}) {\n    const corners = Object(_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_1__[\"getBounds\"])(this, options.z || 0);\n    return [Math.min(corners[0][0], corners[1][0], corners[2][0], corners[3][0]), Math.min(corners[0][1], corners[1][1], corners[2][1], corners[3][1]), Math.max(corners[0][0], corners[1][0], corners[2][0], corners[3][0]), Math.max(corners[0][1], corners[1][1], corners[2][1], corners[3][1])];\n  }\n\n  fitBounds(bounds, options = {}) {\n    const {\n      width,\n      height\n    } = this;\n    const {\n      longitude,\n      latitude,\n      zoom\n    } = Object(_math_gl_web_mercator__WEBPACK_IMPORTED_MODULE_1__[\"fitBounds\"])({\n      width,\n      height,\n      bounds,\n      ...options\n    });\n    return new WebMercatorViewport({\n      width,\n      height,\n      longitude,\n      latitude,\n      zoom\n    });\n  }\n\n}\nWebMercatorViewport.displayName = 'WebMercatorViewport';\n//# sourceMappingURL=web-mercator-viewport.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/viewports/web-mercator-viewport.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/views/map-view.js":
/*!***************************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/views/map-view.js ***!
  \***************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return MapView; });\n/* harmony import */ var _view__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./view */ \"./node_modules/@deck.gl/core/dist/esm/views/view.js\");\n/* harmony import */ var _viewports_web_mercator_viewport__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../viewports/web-mercator-viewport */ \"./node_modules/@deck.gl/core/dist/esm/viewports/web-mercator-viewport.js\");\n/* harmony import */ var _controllers_map_controller__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../controllers/map-controller */ \"./node_modules/@deck.gl/core/dist/esm/controllers/map-controller.js\");\n\n\n\nclass MapView extends _view__WEBPACK_IMPORTED_MODULE_0__[\"default\"] {\n  constructor(props) {\n    super({ ...props,\n      type: _viewports_web_mercator_viewport__WEBPACK_IMPORTED_MODULE_1__[\"default\"]\n    });\n  }\n\n  get controller() {\n    return this._getControllerProps({\n      type: _controllers_map_controller__WEBPACK_IMPORTED_MODULE_2__[\"default\"]\n    });\n  }\n\n}\nMapView.displayName = 'MapView';\n//# sourceMappingURL=map-view.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS92aWV3cy9tYXAtdmlldy5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9AZGVjay5nbC9jb3JlL2Rpc3QvZXNtL3ZpZXdzL21hcC12aWV3LmpzP2QzYzMiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFZpZXcgZnJvbSAnLi92aWV3JztcbmltcG9ydCBXZWJNZXJjYXRvclZpZXdwb3J0IGZyb20gJy4uL3ZpZXdwb3J0cy93ZWItbWVyY2F0b3Itdmlld3BvcnQnO1xuaW1wb3J0IE1hcENvbnRyb2xsZXIgZnJvbSAnLi4vY29udHJvbGxlcnMvbWFwLWNvbnRyb2xsZXInO1xuZXhwb3J0IGRlZmF1bHQgY2xhc3MgTWFwVmlldyBleHRlbmRzIFZpZXcge1xuICBjb25zdHJ1Y3Rvcihwcm9wcykge1xuICAgIHN1cGVyKHsgLi4ucHJvcHMsXG4gICAgICB0eXBlOiBXZWJNZXJjYXRvclZpZXdwb3J0XG4gICAgfSk7XG4gIH1cblxuICBnZXQgY29udHJvbGxlcigpIHtcbiAgICByZXR1cm4gdGhpcy5fZ2V0Q29udHJvbGxlclByb3BzKHtcbiAgICAgIHR5cGU6IE1hcENvbnRyb2xsZXJcbiAgICB9KTtcbiAgfVxuXG59XG5NYXBWaWV3LmRpc3BsYXlOYW1lID0gJ01hcFZpZXcnO1xuLy8jIHNvdXJjZU1hcHBpbmdVUkw9bWFwLXZpZXcuanMubWFwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/views/map-view.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/core/dist/esm/views/view.js":
/*!***********************************************************!*\
  !*** ./node_modules/@deck.gl/core/dist/esm/views/view.js ***!
  \***********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return View; });\n/* harmony import */ var _viewports_viewport__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../viewports/viewport */ \"./node_modules/@deck.gl/core/dist/esm/viewports/viewport.js\");\n/* harmony import */ var _utils_positions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/positions */ \"./node_modules/@deck.gl/core/dist/esm/utils/positions.js\");\n/* harmony import */ var _utils_deep_equal__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/deep-equal */ \"./node_modules/@deck.gl/core/dist/esm/utils/deep-equal.js\");\n/* harmony import */ var _utils_assert__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/assert */ \"./node_modules/@deck.gl/core/dist/esm/utils/assert.js\");\n\n\n\n\nclass View {\n  constructor(props = {}) {\n    const {\n      id = null,\n      x = 0,\n      y = 0,\n      width = '100%',\n      height = '100%',\n      projectionMatrix = null,\n      fovy = 50,\n      near = 0.1,\n      far = 1000,\n      modelMatrix = null,\n      viewportInstance = null,\n      type = _viewports_viewport__WEBPACK_IMPORTED_MODULE_0__[\"default\"]\n    } = props;\n    Object(_utils_assert__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(!viewportInstance || viewportInstance instanceof _viewports_viewport__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n    this.viewportInstance = viewportInstance;\n    this.id = id || this.constructor.displayName || 'view';\n    this.type = type;\n    this.props = { ...props,\n      id: this.id,\n      projectionMatrix,\n      fovy,\n      near,\n      far,\n      modelMatrix\n    };\n\n    this._parseDimensions({\n      x,\n      y,\n      width,\n      height\n    });\n\n    this.equals = this.equals.bind(this);\n    Object.seal(this);\n  }\n\n  equals(view) {\n    if (this === view) {\n      return true;\n    }\n\n    if (this.viewportInstance) {\n      return view.viewportInstance && this.viewportInstance.equals(view.viewportInstance);\n    }\n\n    const viewChanged = Object(_utils_deep_equal__WEBPACK_IMPORTED_MODULE_2__[\"deepEqual\"])(this.props, view.props);\n    return viewChanged;\n  }\n\n  makeViewport({\n    width,\n    height,\n    viewState\n  }) {\n    if (this.viewportInstance) {\n      return this.viewportInstance;\n    }\n\n    viewState = this.filterViewState(viewState);\n    const viewportDimensions = this.getDimensions({\n      width,\n      height\n    });\n    return this._getViewport(viewState, viewportDimensions);\n  }\n\n  getViewStateId() {\n    switch (typeof this.props.viewState) {\n      case 'string':\n        return this.props.viewState;\n\n      case 'object':\n        return this.props.viewState && this.props.viewState.id;\n\n      default:\n        return this.id;\n    }\n  }\n\n  filterViewState(viewState) {\n    if (this.props.viewState && typeof this.props.viewState === 'object') {\n      if (!this.props.viewState.id) {\n        return this.props.viewState;\n      }\n\n      const newViewState = { ...viewState\n      };\n\n      for (const key in this.props.viewState) {\n        if (key !== 'id') {\n          newViewState[key] = this.props.viewState[key];\n        }\n      }\n\n      return newViewState;\n    }\n\n    return viewState;\n  }\n\n  getDimensions({\n    width,\n    height\n  }) {\n    return {\n      x: Object(_utils_positions__WEBPACK_IMPORTED_MODULE_1__[\"getPosition\"])(this._x, width),\n      y: Object(_utils_positions__WEBPACK_IMPORTED_MODULE_1__[\"getPosition\"])(this._y, height),\n      width: Object(_utils_positions__WEBPACK_IMPORTED_MODULE_1__[\"getPosition\"])(this._width, width),\n      height: Object(_utils_positions__WEBPACK_IMPORTED_MODULE_1__[\"getPosition\"])(this._height, height)\n    };\n  }\n\n  _getControllerProps(defaultOpts) {\n    let opts = this.props.controller;\n\n    if (!opts) {\n      return null;\n    }\n\n    if (opts === true) {\n      return defaultOpts;\n    }\n\n    if (typeof opts === 'function') {\n      opts = {\n        type: opts\n      };\n    }\n\n    return { ...defaultOpts,\n      ...opts\n    };\n  }\n\n  _getViewport(viewState, viewportDimensions) {\n    const {\n      type: ViewportType\n    } = this;\n    return new ViewportType({ ...viewState,\n      ...this.props,\n      ...viewportDimensions\n    });\n  }\n\n  _parseDimensions({\n    x,\n    y,\n    width,\n    height\n  }) {\n    this._x = Object(_utils_positions__WEBPACK_IMPORTED_MODULE_1__[\"parsePosition\"])(x);\n    this._y = Object(_utils_positions__WEBPACK_IMPORTED_MODULE_1__[\"parsePosition\"])(y);\n    this._width = Object(_utils_positions__WEBPACK_IMPORTED_MODULE_1__[\"parsePosition\"])(width);\n    this._height = Object(_utils_positions__WEBPACK_IMPORTED_MODULE_1__[\"parsePosition\"])(height);\n  }\n\n}\n//# sourceMappingURL=view.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvY29yZS9kaXN0L2VzbS92aWV3cy92aWV3LmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0BkZWNrLmdsL2NvcmUvZGlzdC9lc20vdmlld3Mvdmlldy5qcz85YzgwIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBWaWV3cG9ydCBmcm9tICcuLi92aWV3cG9ydHMvdmlld3BvcnQnO1xuaW1wb3J0IHsgcGFyc2VQb3NpdGlvbiwgZ2V0UG9zaXRpb24gfSBmcm9tICcuLi91dGlscy9wb3NpdGlvbnMnO1xuaW1wb3J0IHsgZGVlcEVxdWFsIH0gZnJvbSAnLi4vdXRpbHMvZGVlcC1lcXVhbCc7XG5pbXBvcnQgYXNzZXJ0IGZyb20gJy4uL3V0aWxzL2Fzc2VydCc7XG5leHBvcnQgZGVmYXVsdCBjbGFzcyBWaWV3IHtcbiAgY29uc3RydWN0b3IocHJvcHMgPSB7fSkge1xuICAgIGNvbnN0IHtcbiAgICAgIGlkID0gbnVsbCxcbiAgICAgIHggPSAwLFxuICAgICAgeSA9IDAsXG4gICAgICB3aWR0aCA9ICcxMDAlJyxcbiAgICAgIGhlaWdodCA9ICcxMDAlJyxcbiAgICAgIHByb2plY3Rpb25NYXRyaXggPSBudWxsLFxuICAgICAgZm92eSA9IDUwLFxuICAgICAgbmVhciA9IDAuMSxcbiAgICAgIGZhciA9IDEwMDAsXG4gICAgICBtb2RlbE1hdHJpeCA9IG51bGwsXG4gICAgICB2aWV3cG9ydEluc3RhbmNlID0gbnVsbCxcbiAgICAgIHR5cGUgPSBWaWV3cG9ydFxuICAgIH0gPSBwcm9wcztcbiAgICBhc3NlcnQoIXZpZXdwb3J0SW5zdGFuY2UgfHwgdmlld3BvcnRJbnN0YW5jZSBpbnN0YW5jZW9mIFZpZXdwb3J0KTtcbiAgICB0aGlzLnZpZXdwb3J0SW5zdGFuY2UgPSB2aWV3cG9ydEluc3RhbmNlO1xuICAgIHRoaXMuaWQgPSBpZCB8fCB0aGlzLmNvbnN0cnVjdG9yLmRpc3BsYXlOYW1lIHx8ICd2aWV3JztcbiAgICB0aGlzLnR5cGUgPSB0eXBlO1xuICAgIHRoaXMucHJvcHMgPSB7IC4uLnByb3BzLFxuICAgICAgaWQ6IHRoaXMuaWQsXG4gICAgICBwcm9qZWN0aW9uTWF0cml4LFxuICAgICAgZm92eSxcbiAgICAgIG5lYXIsXG4gICAgICBmYXIsXG4gICAgICBtb2RlbE1hdHJpeFxuICAgIH07XG5cbiAgICB0aGlzLl9wYXJzZURpbWVuc2lvbnMoe1xuICAgICAgeCxcbiAgICAgIHksXG4gICAgICB3aWR0aCxcbiAgICAgIGhlaWdodFxuICAgIH0pO1xuXG4gICAgdGhpcy5lcXVhbHMgPSB0aGlzLmVxdWFscy5iaW5kKHRoaXMpO1xuICAgIE9iamVjdC5zZWFsKHRoaXMpO1xuICB9XG5cbiAgZXF1YWxzKHZpZXcpIHtcbiAgICBpZiAodGhpcyA9PT0gdmlldykge1xuICAgICAgcmV0dXJuIHRydWU7XG4gICAgfVxuXG4gICAgaWYgKHRoaXMudmlld3BvcnRJbnN0YW5jZSkge1xuICAgICAgcmV0dXJuIHZpZXcudmlld3BvcnRJbnN0YW5jZSAmJiB0aGlzLnZpZXdwb3J0SW5zdGFuY2UuZXF1YWxzKHZpZXcudmlld3BvcnRJbnN0YW5jZSk7XG4gICAgfVxuXG4gICAgY29uc3Qgdmlld0NoYW5nZWQgPSBkZWVwRXF1YWwodGhpcy5wcm9wcywgdmlldy5wcm9wcyk7XG4gICAgcmV0dXJuIHZpZXdDaGFuZ2VkO1xuICB9XG5cbiAgbWFrZVZpZXdwb3J0KHtcbiAgICB3aWR0aCxcbiAgICBoZWlnaHQsXG4gICAgdmlld1N0YXRlXG4gIH0pIHtcbiAgICBpZiAodGhpcy52aWV3cG9ydEluc3RhbmNlKSB7XG4gICAgICByZXR1cm4gdGhpcy52aWV3cG9ydEluc3RhbmNlO1xuICAgIH1cblxuICAgIHZpZXdTdGF0ZSA9IHRoaXMuZmlsdGVyVmlld1N0YXRlKHZpZXdTdGF0ZSk7XG4gICAgY29uc3Qgdmlld3BvcnREaW1lbnNpb25zID0gdGhpcy5nZXREaW1lbnNpb25zKHtcbiAgICAgIHdpZHRoLFxuICAgICAgaGVpZ2h0XG4gICAgfSk7XG4gICAgcmV0dXJuIHRoaXMuX2dldFZpZXdwb3J0KHZpZXdTdGF0ZSwgdmlld3BvcnREaW1lbnNpb25zKTtcbiAgfVxuXG4gIGdldFZpZXdTdGF0ZUlkKCkge1xuICAgIHN3aXRjaCAodHlwZW9mIHRoaXMucHJvcHMudmlld1N0YXRlKSB7XG4gICAgICBjYXNlICdzdHJpbmcnOlxuICAgICAgICByZXR1cm4gdGhpcy5wcm9wcy52aWV3U3RhdGU7XG5cbiAgICAgIGNhc2UgJ29iamVjdCc6XG4gICAgICAgIHJldHVybiB0aGlzLnByb3BzLnZpZXdTdGF0ZSAmJiB0aGlzLnByb3BzLnZpZXdTdGF0ZS5pZDtcblxuICAgICAgZGVmYXVsdDpcbiAgICAgICAgcmV0dXJuIHRoaXMuaWQ7XG4gICAgfVxuICB9XG5cbiAgZmlsdGVyVmlld1N0YXRlKHZpZXdTdGF0ZSkge1xuICAgIGlmICh0aGlzLnByb3BzLnZpZXdTdGF0ZSAmJiB0eXBlb2YgdGhpcy5wcm9wcy52aWV3U3RhdGUgPT09ICdvYmplY3QnKSB7XG4gICAgICBpZiAoIXRoaXMucHJvcHMudmlld1N0YXRlLmlkKSB7XG4gICAgICAgIHJldHVybiB0aGlzLnByb3BzLnZpZXdTdGF0ZTtcbiAgICAgIH1cblxuICAgICAgY29uc3QgbmV3Vmlld1N0YXRlID0geyAuLi52aWV3U3RhdGVcbiAgICAgIH07XG5cbiAgICAgIGZvciAoY29uc3Qga2V5IGluIHRoaXMucHJvcHMudmlld1N0YXRlKSB7XG4gICAgICAgIGlmIChrZXkgIT09ICdpZCcpIHtcbiAgICAgICAgICBuZXdWaWV3U3RhdGVba2V5XSA9IHRoaXMucHJvcHMudmlld1N0YXRlW2tleV07XG4gICAgICAgIH1cbiAgICAgIH1cblxuICAgICAgcmV0dXJuIG5ld1ZpZXdTdGF0ZTtcbiAgICB9XG5cbiAgICByZXR1cm4gdmlld1N0YXRlO1xuICB9XG5cbiAgZ2V0RGltZW5zaW9ucyh7XG4gICAgd2lkdGgsXG4gICAgaGVpZ2h0XG4gIH0pIHtcbiAgICByZXR1cm4ge1xuICAgICAgeDogZ2V0UG9zaXRpb24odGhpcy5feCwgd2lkdGgpLFxuICAgICAgeTogZ2V0UG9zaXRpb24odGhpcy5feSwgaGVpZ2h0KSxcbiAgICAgIHdpZHRoOiBnZXRQb3NpdGlvbih0aGlzLl93aWR0aCwgd2lkdGgpLFxuICAgICAgaGVpZ2h0OiBnZXRQb3NpdGlvbih0aGlzLl9oZWlnaHQsIGhlaWdodClcbiAgICB9O1xuICB9XG5cbiAgX2dldENvbnRyb2xsZXJQcm9wcyhkZWZhdWx0T3B0cykge1xuICAgIGxldCBvcHRzID0gdGhpcy5wcm9wcy5jb250cm9sbGVyO1xuXG4gICAgaWYgKCFvcHRzKSB7XG4gICAgICByZXR1cm4gbnVsbDtcbiAgICB9XG5cbiAgICBpZiAob3B0cyA9PT0gdHJ1ZSkge1xuICAgICAgcmV0dXJuIGRlZmF1bHRPcHRzO1xuICAgIH1cblxuICAgIGlmICh0eXBlb2Ygb3B0cyA9PT0gJ2Z1bmN0aW9uJykge1xuICAgICAgb3B0cyA9IHtcbiAgICAgICAgdHlwZTogb3B0c1xuICAgICAgfTtcbiAgICB9XG5cbiAgICByZXR1cm4geyAuLi5kZWZhdWx0T3B0cyxcbiAgICAgIC4uLm9wdHNcbiAgICB9O1xuICB9XG5cbiAgX2dldFZpZXdwb3J0KHZpZXdTdGF0ZSwgdmlld3BvcnREaW1lbnNpb25zKSB7XG4gICAgY29uc3Qge1xuICAgICAgdHlwZTogVmlld3BvcnRUeXBlXG4gICAgfSA9IHRoaXM7XG4gICAgcmV0dXJuIG5ldyBWaWV3cG9ydFR5cGUoeyAuLi52aWV3U3RhdGUsXG4gICAgICAuLi50aGlzLnByb3BzLFxuICAgICAgLi4udmlld3BvcnREaW1lbnNpb25zXG4gICAgfSk7XG4gIH1cblxuICBfcGFyc2VEaW1lbnNpb25zKHtcbiAgICB4LFxuICAgIHksXG4gICAgd2lkdGgsXG4gICAgaGVpZ2h0XG4gIH0pIHtcbiAgICB0aGlzLl94ID0gcGFyc2VQb3NpdGlvbih4KTtcbiAgICB0aGlzLl95ID0gcGFyc2VQb3NpdGlvbih5KTtcbiAgICB0aGlzLl93aWR0aCA9IHBhcnNlUG9zaXRpb24od2lkdGgpO1xuICAgIHRoaXMuX2hlaWdodCA9IHBhcnNlUG9zaXRpb24oaGVpZ2h0KTtcbiAgfVxuXG59XG4vLyMgc291cmNlTWFwcGluZ1VSTD12aWV3LmpzLm1hcCJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/core/dist/esm/views/view.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/react/dist/esm/deckgl.js":
/*!********************************************************!*\
  !*** ./node_modules/@deck.gl/react/dist/esm/deckgl.js ***!
  \********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"./node_modules/react/index.js\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ \"./node_modules/prop-types/index.js\");\n/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _deck_gl_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @deck.gl/core */ \"./node_modules/@deck.gl/core/dist/esm/lib/deck.js\");\n/* harmony import */ var _utils_use_isomorphic_layout_effect__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./utils/use-isomorphic-layout-effect */ \"./node_modules/@deck.gl/react/dist/esm/utils/use-isomorphic-layout-effect.js\");\n/* harmony import */ var _utils_extract_jsx_layers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./utils/extract-jsx-layers */ \"./node_modules/@deck.gl/react/dist/esm/utils/extract-jsx-layers.js\");\n/* harmony import */ var _utils_position_children_under_views__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./utils/position-children-under-views */ \"./node_modules/@deck.gl/react/dist/esm/utils/position-children-under-views.js\");\n/* harmony import */ var _utils_extract_styles__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./utils/extract-styles */ \"./node_modules/@deck.gl/react/dist/esm/utils/extract-styles.js\");\n\n\n\n\n\n\n\n\nfunction getRefHandles(thisRef) {\n  const handles = {\n    pickObject: opts => thisRef.deck.pickObject(opts),\n    pickMultipleObjects: opts => thisRef.deck.pickMultipleObjects(opts),\n    pickObjects: opts => thisRef.deck.pickObjects(opts)\n  };\n  Object.defineProperty(handles, 'deck', {\n    get: () => thisRef.deck\n  });\n  return handles;\n}\n\nfunction redrawDeck(thisRef) {\n  if (thisRef.redrawReason) {\n    thisRef.deck._drawLayers(thisRef.redrawReason);\n\n    thisRef.redrawReason = null;\n  }\n}\n\nfunction createDeckInstance(thisRef, props) {\n  const DeckClass = props.Deck || _deck_gl_core__WEBPACK_IMPORTED_MODULE_2__[\"default\"];\n  const deck = new DeckClass({ ...props,\n    style: null,\n    width: '100%',\n    height: '100%',\n    _customRender: redrawReason => {\n      thisRef.redrawReason = redrawReason;\n      const viewports = deck.viewManager.getViewports();\n\n      if (thisRef.lastRenderedViewports !== viewports) {\n        thisRef.forceUpdate(v => v + 1);\n      } else {\n        redrawDeck(thisRef);\n      }\n    }\n  });\n  return deck;\n}\n\nconst DeckGL = Object(react__WEBPACK_IMPORTED_MODULE_0__[\"forwardRef\"])((props, ref) => {\n  const _thisRef = Object(react__WEBPACK_IMPORTED_MODULE_0__[\"useRef\"])({});\n\n  const thisRef = _thisRef.current;\n  const [version, setVersion] = Object(react__WEBPACK_IMPORTED_MODULE_0__[\"useState\"])(0);\n  thisRef.forceUpdate = setVersion;\n  const containerRef = Object(react__WEBPACK_IMPORTED_MODULE_0__[\"useRef\"])(null);\n  const canvasRef = Object(react__WEBPACK_IMPORTED_MODULE_0__[\"useRef\"])(null);\n  const jsxProps = Object(react__WEBPACK_IMPORTED_MODULE_0__[\"useMemo\"])(() => Object(_utils_extract_jsx_layers__WEBPACK_IMPORTED_MODULE_4__[\"default\"])(props), [props.layers, props.views, props.children]);\n  let inRender = true;\n\n  const handleViewStateChange = params => {\n    if (inRender && props.viewState) {\n      thisRef.viewStateUpdateRequested = params;\n      return null;\n    }\n\n    thisRef.viewStateUpdateRequested = null;\n    return props.onViewStateChange(params);\n  };\n\n  const handleInteractionStateChange = params => {\n    if (inRender) {\n      thisRef.interactionStateUpdateRequested = params;\n    } else {\n      thisRef.interactionStateUpdateRequested = null;\n      props.onInteractionStateChange(params);\n    }\n  };\n\n  const deckProps = Object(react__WEBPACK_IMPORTED_MODULE_0__[\"useMemo\"])(() => {\n    const forwardProps = { ...props,\n      style: null,\n      width: '100%',\n      height: '100%',\n      layers: jsxProps.layers,\n      views: jsxProps.views,\n      onViewStateChange: handleViewStateChange,\n      onInteractionStateChange: handleInteractionStateChange\n    };\n\n    if (thisRef.deck) {\n      thisRef.deck.setProps(forwardProps);\n    }\n\n    return forwardProps;\n  }, [props]);\n  Object(react__WEBPACK_IMPORTED_MODULE_0__[\"useEffect\"])(() => {\n    thisRef.deck = createDeckInstance(thisRef, { ...deckProps,\n      parent: containerRef.current,\n      canvas: canvasRef.current\n    });\n    return () => thisRef.deck.finalize();\n  }, []);\n  Object(_utils_use_isomorphic_layout_effect__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(() => {\n    redrawDeck(thisRef);\n    const {\n      viewStateUpdateRequested,\n      interactionStateUpdateRequested\n    } = thisRef;\n\n    if (viewStateUpdateRequested) {\n      handleViewStateChange(viewStateUpdateRequested);\n    }\n\n    if (interactionStateUpdateRequested) {\n      handleInteractionStateChange(interactionStateUpdateRequested);\n    }\n  });\n  Object(react__WEBPACK_IMPORTED_MODULE_0__[\"useImperativeHandle\"])(ref, () => getRefHandles(thisRef), []);\n  const {\n    viewManager\n  } = thisRef.deck || {};\n  const currentViewports = viewManager && viewManager.getViewports();\n  const {\n    ContextProvider,\n    width,\n    height,\n    id,\n    style\n  } = props;\n  const {\n    containerStyle,\n    canvasStyle\n  } = Object(react__WEBPACK_IMPORTED_MODULE_0__[\"useMemo\"])(() => Object(_utils_extract_styles__WEBPACK_IMPORTED_MODULE_6__[\"default\"])({\n    width,\n    height,\n    style\n  }), [width, height, style]);\n\n  if (!thisRef.viewStateUpdateRequested && thisRef.lastRenderedViewports === currentViewports || thisRef.version !== version) {\n      thisRef.lastRenderedViewports = currentViewports;\n      thisRef.version = version;\n      const childrenUnderViews = Object(_utils_position_children_under_views__WEBPACK_IMPORTED_MODULE_5__[\"default\"])({\n        children: jsxProps.children,\n        deck: thisRef.deck,\n        ContextProvider\n      });\n      const canvas = Object(react__WEBPACK_IMPORTED_MODULE_0__[\"createElement\"])('canvas', {\n        key: 'canvas',\n        id: id || 'deckgl-overlay',\n        ref: canvasRef,\n        style: canvasStyle\n      });\n      thisRef.control = Object(react__WEBPACK_IMPORTED_MODULE_0__[\"createElement\"])('div', {\n        id: \"\".concat(id || 'deckgl', \"-wrapper\"),\n        ref: containerRef,\n        style: containerStyle\n      }, [canvas, childrenUnderViews]);\n    }\n\n  inRender = false;\n  return thisRef.control;\n});\nDeckGL.propTypes = _deck_gl_core__WEBPACK_IMPORTED_MODULE_2__[\"default\"].getPropTypes(prop_types__WEBPACK_IMPORTED_MODULE_1___default.a);\nDeckGL.defaultProps = _deck_gl_core__WEBPACK_IMPORTED_MODULE_2__[\"default\"].defaultProps;\n/* harmony default export */ __webpack_exports__[\"default\"] = (DeckGL);\n//# sourceMappingURL=deckgl.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/react/dist/esm/deckgl.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/react/dist/esm/utils/evaluate-children.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@deck.gl/react/dist/esm/utils/evaluate-children.js ***!
  \*************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return evaluateChildren; });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"./node_modules/react/index.js\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n\nconst MAP_STYLE = {\n  position: 'absolute',\n  zIndex: -1\n};\nfunction evaluateChildren(children, childProps) {\n  if (!children) {\n    return children;\n  }\n\n  if (typeof children === 'function') {\n    return children(childProps);\n  }\n\n  if (Array.isArray(children)) {\n    return children.map(child => evaluateChildren(child, childProps));\n  }\n\n  if (isReactMap(children)) {\n    childProps.style = MAP_STYLE;\n    return Object(react__WEBPACK_IMPORTED_MODULE_0__[\"cloneElement\"])(children, childProps);\n  }\n\n  if (needsDeckGLViewProps(children)) {\n    return Object(react__WEBPACK_IMPORTED_MODULE_0__[\"cloneElement\"])(children, childProps);\n  }\n\n  return children;\n}\n\nfunction isReactMap(child) {\n  const componentClass = child && child.type;\n  const componentProps = componentClass && componentClass.defaultProps;\n  return componentProps && componentProps.mapStyle;\n}\n\nfunction needsDeckGLViewProps(child) {\n  const componentClass = child && child.type;\n  return componentClass && componentClass.deckGLViewProps;\n}\n//# sourceMappingURL=evaluate-children.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/react/dist/esm/utils/evaluate-children.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/react/dist/esm/utils/extract-jsx-layers.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@deck.gl/react/dist/esm/utils/extract-jsx-layers.js ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return extractJSXLayers; });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"./node_modules/react/index.js\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _inherits_from__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./inherits-from */ \"./node_modules/@deck.gl/react/dist/esm/utils/inherits-from.js\");\n/* harmony import */ var _deck_gl_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @deck.gl/core */ \"./node_modules/@deck.gl/core/dist/esm/views/view.js\");\n/* harmony import */ var _deck_gl_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @deck.gl/core */ \"./node_modules/@deck.gl/core/dist/esm/lib/layer.js\");\n\n\n\n\nfunction wrapInView(node) {\n  if (!node) {\n    return node;\n  }\n\n  if (typeof node === 'function') {\n    return Object(react__WEBPACK_IMPORTED_MODULE_0__[\"createElement\"])(_deck_gl_core__WEBPACK_IMPORTED_MODULE_2__[\"default\"], {}, node);\n  }\n\n  if (Array.isArray(node)) {\n    return node.map(wrapInView);\n  }\n\n  if (node.type === react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment) {\n    return wrapInView(node.props.children);\n  }\n\n  if (Object(_inherits_from__WEBPACK_IMPORTED_MODULE_1__[\"inheritsFrom\"])(node.type, _deck_gl_core__WEBPACK_IMPORTED_MODULE_2__[\"default\"])) {\n    return node;\n  }\n\n  return node;\n}\n\nfunction extractJSXLayers({\n  children,\n  layers,\n  views\n}) {\n  const reactChildren = [];\n  const jsxLayers = [];\n  const jsxViews = {};\n  react__WEBPACK_IMPORTED_MODULE_0___default.a.Children.forEach(wrapInView(children), reactElement => {\n    if (reactElement) {\n      const ElementType = reactElement.type;\n\n      if (Object(_inherits_from__WEBPACK_IMPORTED_MODULE_1__[\"inheritsFrom\"])(ElementType, _deck_gl_core__WEBPACK_IMPORTED_MODULE_3__[\"default\"])) {\n        const layer = createLayer(ElementType, reactElement.props);\n        jsxLayers.push(layer);\n      } else {\n        reactChildren.push(reactElement);\n      }\n\n      if (ElementType !== _deck_gl_core__WEBPACK_IMPORTED_MODULE_2__[\"default\"] && Object(_inherits_from__WEBPACK_IMPORTED_MODULE_1__[\"inheritsFrom\"])(ElementType, _deck_gl_core__WEBPACK_IMPORTED_MODULE_2__[\"default\"]) && reactElement.props.id) {\n        const view = new ElementType(reactElement.props);\n        jsxViews[view.id] = view;\n      }\n    }\n  });\n\n  if (Object.keys(jsxViews).length > 0) {\n    if (Array.isArray(views)) {\n      views.forEach(view => {\n        jsxViews[view.id] = view;\n      });\n    } else if (views) {\n      jsxViews[views.id] = views;\n    }\n\n    views = Object.values(jsxViews);\n  }\n\n  layers = jsxLayers.length > 0 ? [...jsxLayers, ...layers] : layers;\n  return {\n    layers,\n    children: reactChildren,\n    views\n  };\n}\n\nfunction createLayer(LayerType, reactProps) {\n  const props = {};\n  const defaultProps = LayerType.defaultProps || {};\n\n  for (const key in reactProps) {\n    if (defaultProps[key] !== reactProps[key]) {\n      props[key] = reactProps[key];\n    }\n  }\n\n  return new LayerType(props);\n}\n//# sourceMappingURL=extract-jsx-layers.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/react/dist/esm/utils/extract-jsx-layers.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/react/dist/esm/utils/extract-styles.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@deck.gl/react/dist/esm/utils/extract-styles.js ***!
  \**********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return extractStyles; });\nconst CANVAS_ONLY_STYLES = {\n  mixBlendMode: null\n};\nfunction extractStyles({\n  width,\n  height,\n  style\n}) {\n  const containerStyle = {\n    position: 'absolute',\n    zIndex: 0,\n    left: 0,\n    top: 0,\n    width,\n    height\n  };\n  const canvasStyle = {\n    left: 0,\n    top: 0\n  };\n\n  if (style) {\n    for (const key in style) {\n      if (key in CANVAS_ONLY_STYLES) {\n        canvasStyle[key] = style[key];\n      } else {\n        containerStyle[key] = style[key];\n      }\n    }\n  }\n\n  return {\n    containerStyle,\n    canvasStyle\n  };\n}\n//# sourceMappingURL=extract-styles.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvcmVhY3QvZGlzdC9lc20vdXRpbHMvZXh0cmFjdC1zdHlsZXMuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvcmVhY3QvZGlzdC9lc20vdXRpbHMvZXh0cmFjdC1zdHlsZXMuanM/ODJkNSJdLCJzb3VyY2VzQ29udGVudCI6WyJjb25zdCBDQU5WQVNfT05MWV9TVFlMRVMgPSB7XG4gIG1peEJsZW5kTW9kZTogbnVsbFxufTtcbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIGV4dHJhY3RTdHlsZXMoe1xuICB3aWR0aCxcbiAgaGVpZ2h0LFxuICBzdHlsZVxufSkge1xuICBjb25zdCBjb250YWluZXJTdHlsZSA9IHtcbiAgICBwb3NpdGlvbjogJ2Fic29sdXRlJyxcbiAgICB6SW5kZXg6IDAsXG4gICAgbGVmdDogMCxcbiAgICB0b3A6IDAsXG4gICAgd2lkdGgsXG4gICAgaGVpZ2h0XG4gIH07XG4gIGNvbnN0IGNhbnZhc1N0eWxlID0ge1xuICAgIGxlZnQ6IDAsXG4gICAgdG9wOiAwXG4gIH07XG5cbiAgaWYgKHN0eWxlKSB7XG4gICAgZm9yIChjb25zdCBrZXkgaW4gc3R5bGUpIHtcbiAgICAgIGlmIChrZXkgaW4gQ0FOVkFTX09OTFlfU1RZTEVTKSB7XG4gICAgICAgIGNhbnZhc1N0eWxlW2tleV0gPSBzdHlsZVtrZXldO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgY29udGFpbmVyU3R5bGVba2V5XSA9IHN0eWxlW2tleV07XG4gICAgICB9XG4gICAgfVxuICB9XG5cbiAgcmV0dXJuIHtcbiAgICBjb250YWluZXJTdHlsZSxcbiAgICBjYW52YXNTdHlsZVxuICB9O1xufVxuLy8jIHNvdXJjZU1hcHBpbmdVUkw9ZXh0cmFjdC1zdHlsZXMuanMubWFwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/react/dist/esm/utils/extract-styles.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/react/dist/esm/utils/inherits-from.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@deck.gl/react/dist/esm/utils/inherits-from.js ***!
  \*********************************************************************/
/*! exports provided: inheritsFrom */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"inheritsFrom\", function() { return inheritsFrom; });\nfunction inheritsFrom(Type, ParentType) {\n  while (Type) {\n    if (Type === ParentType) {\n      return true;\n    }\n\n    Type = Object.getPrototypeOf(Type);\n  }\n\n  return false;\n}\n//# sourceMappingURL=inherits-from.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvcmVhY3QvZGlzdC9lc20vdXRpbHMvaW5oZXJpdHMtZnJvbS5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9AZGVjay5nbC9yZWFjdC9kaXN0L2VzbS91dGlscy9pbmhlcml0cy1mcm9tLmpzPzEwOGIiXSwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IGZ1bmN0aW9uIGluaGVyaXRzRnJvbShUeXBlLCBQYXJlbnRUeXBlKSB7XG4gIHdoaWxlIChUeXBlKSB7XG4gICAgaWYgKFR5cGUgPT09IFBhcmVudFR5cGUpIHtcbiAgICAgIHJldHVybiB0cnVlO1xuICAgIH1cblxuICAgIFR5cGUgPSBPYmplY3QuZ2V0UHJvdG90eXBlT2YoVHlwZSk7XG4gIH1cblxuICByZXR1cm4gZmFsc2U7XG59XG4vLyMgc291cmNlTWFwcGluZ1VSTD1pbmhlcml0cy1mcm9tLmpzLm1hcCJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/react/dist/esm/utils/inherits-from.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/react/dist/esm/utils/position-children-under-views.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@deck.gl/react/dist/esm/utils/position-children-under-views.js ***!
  \*************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return positionChildrenUnderViews; });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"./node_modules/react/index.js\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _deck_gl_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @deck.gl/core */ \"./node_modules/@deck.gl/core/dist/esm/views/view.js\");\n/* harmony import */ var _inherits_from__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./inherits-from */ \"./node_modules/@deck.gl/react/dist/esm/utils/inherits-from.js\");\n/* harmony import */ var _evaluate_children__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./evaluate-children */ \"./node_modules/@deck.gl/react/dist/esm/utils/evaluate-children.js\");\n\n\n\n\nfunction positionChildrenUnderViews({\n  children,\n  deck,\n  ContextProvider\n}) {\n  const {\n    viewManager\n  } = deck || {};\n\n  if (!viewManager || !viewManager.views.length) {\n    return [];\n  }\n\n  const views = {};\n  const defaultViewId = viewManager.views[0].id;\n\n  for (const child of children) {\n    let viewId = defaultViewId;\n    let viewChildren = child;\n\n    if (Object(_inherits_from__WEBPACK_IMPORTED_MODULE_2__[\"inheritsFrom\"])(child.type, _deck_gl_core__WEBPACK_IMPORTED_MODULE_1__[\"default\"])) {\n      viewId = child.props.id || defaultViewId;\n      viewChildren = child.props.children;\n    }\n\n    const viewport = viewManager.getViewport(viewId);\n    const viewState = viewManager.getViewState(viewId);\n\n    if (viewport) {\n      const {\n        x,\n        y,\n        width,\n        height\n      } = viewport;\n      viewChildren = Object(_evaluate_children__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(viewChildren, {\n        x,\n        y,\n        width,\n        height,\n        viewport,\n        viewState\n      });\n\n      if (!views[viewId]) {\n        views[viewId] = {\n          viewport,\n          children: []\n        };\n      }\n\n      views[viewId].children.push(viewChildren);\n    }\n  }\n\n  return Object.keys(views).map(viewId => {\n    const {\n      viewport,\n      children: viewChildren\n    } = views[viewId];\n    const {\n      x,\n      y,\n      width,\n      height\n    } = viewport;\n    const style = {\n      position: 'absolute',\n      left: x,\n      top: y,\n      width,\n      height\n    };\n    const key = \"view-\".concat(viewId);\n    const viewElement = Object(react__WEBPACK_IMPORTED_MODULE_0__[\"createElement\"])('div', {\n      key,\n      id: key,\n      style\n    }, ...viewChildren);\n\n    if (ContextProvider) {\n      const contextValue = {\n        viewport,\n        container: deck.canvas.offsetParent,\n        eventManager: deck.eventManager,\n        onViewStateChange: params => {\n          params.viewId = viewId;\n\n          deck._onViewStateChange(params);\n        }\n      };\n      return Object(react__WEBPACK_IMPORTED_MODULE_0__[\"createElement\"])(ContextProvider, {\n        key,\n        value: contextValue\n      }, viewElement);\n    }\n\n    return viewElement;\n  });\n}\n//# sourceMappingURL=position-children-under-views.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvcmVhY3QvZGlzdC9lc20vdXRpbHMvcG9zaXRpb24tY2hpbGRyZW4tdW5kZXItdmlld3MuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvcmVhY3QvZGlzdC9lc20vdXRpbHMvcG9zaXRpb24tY2hpbGRyZW4tdW5kZXItdmlld3MuanM/MjVlNyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBjcmVhdGVFbGVtZW50IH0gZnJvbSAncmVhY3QnO1xuaW1wb3J0IHsgVmlldyB9IGZyb20gJ0BkZWNrLmdsL2NvcmUnO1xuaW1wb3J0IHsgaW5oZXJpdHNGcm9tIH0gZnJvbSAnLi9pbmhlcml0cy1mcm9tJztcbmltcG9ydCBldmFsdWF0ZUNoaWxkcmVuIGZyb20gJy4vZXZhbHVhdGUtY2hpbGRyZW4nO1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gcG9zaXRpb25DaGlsZHJlblVuZGVyVmlld3Moe1xuICBjaGlsZHJlbixcbiAgZGVjayxcbiAgQ29udGV4dFByb3ZpZGVyXG59KSB7XG4gIGNvbnN0IHtcbiAgICB2aWV3TWFuYWdlclxuICB9ID0gZGVjayB8fCB7fTtcblxuICBpZiAoIXZpZXdNYW5hZ2VyIHx8ICF2aWV3TWFuYWdlci52aWV3cy5sZW5ndGgpIHtcbiAgICByZXR1cm4gW107XG4gIH1cblxuICBjb25zdCB2aWV3cyA9IHt9O1xuICBjb25zdCBkZWZhdWx0Vmlld0lkID0gdmlld01hbmFnZXIudmlld3NbMF0uaWQ7XG5cbiAgZm9yIChjb25zdCBjaGlsZCBvZiBjaGlsZHJlbikge1xuICAgIGxldCB2aWV3SWQgPSBkZWZhdWx0Vmlld0lkO1xuICAgIGxldCB2aWV3Q2hpbGRyZW4gPSBjaGlsZDtcblxuICAgIGlmIChpbmhlcml0c0Zyb20oY2hpbGQudHlwZSwgVmlldykpIHtcbiAgICAgIHZpZXdJZCA9IGNoaWxkLnByb3BzLmlkIHx8IGRlZmF1bHRWaWV3SWQ7XG4gICAgICB2aWV3Q2hpbGRyZW4gPSBjaGlsZC5wcm9wcy5jaGlsZHJlbjtcbiAgICB9XG5cbiAgICBjb25zdCB2aWV3cG9ydCA9IHZpZXdNYW5hZ2VyLmdldFZpZXdwb3J0KHZpZXdJZCk7XG4gICAgY29uc3Qgdmlld1N0YXRlID0gdmlld01hbmFnZXIuZ2V0Vmlld1N0YXRlKHZpZXdJZCk7XG5cbiAgICBpZiAodmlld3BvcnQpIHtcbiAgICAgIGNvbnN0IHtcbiAgICAgICAgeCxcbiAgICAgICAgeSxcbiAgICAgICAgd2lkdGgsXG4gICAgICAgIGhlaWdodFxuICAgICAgfSA9IHZpZXdwb3J0O1xuICAgICAgdmlld0NoaWxkcmVuID0gZXZhbHVhdGVDaGlsZHJlbih2aWV3Q2hpbGRyZW4sIHtcbiAgICAgICAgeCxcbiAgICAgICAgeSxcbiAgICAgICAgd2lkdGgsXG4gICAgICAgIGhlaWdodCxcbiAgICAgICAgdmlld3BvcnQsXG4gICAgICAgIHZpZXdTdGF0ZVxuICAgICAgfSk7XG5cbiAgICAgIGlmICghdmlld3Nbdmlld0lkXSkge1xuICAgICAgICB2aWV3c1t2aWV3SWRdID0ge1xuICAgICAgICAgIHZpZXdwb3J0LFxuICAgICAgICAgIGNoaWxkcmVuOiBbXVxuICAgICAgICB9O1xuICAgICAgfVxuXG4gICAgICB2aWV3c1t2aWV3SWRdLmNoaWxkcmVuLnB1c2godmlld0NoaWxkcmVuKTtcbiAgICB9XG4gIH1cblxuICByZXR1cm4gT2JqZWN0LmtleXModmlld3MpLm1hcCh2aWV3SWQgPT4ge1xuICAgIGNvbnN0IHtcbiAgICAgIHZpZXdwb3J0LFxuICAgICAgY2hpbGRyZW46IHZpZXdDaGlsZHJlblxuICAgIH0gPSB2aWV3c1t2aWV3SWRdO1xuICAgIGNvbnN0IHtcbiAgICAgIHgsXG4gICAgICB5LFxuICAgICAgd2lkdGgsXG4gICAgICBoZWlnaHRcbiAgICB9ID0gdmlld3BvcnQ7XG4gICAgY29uc3Qgc3R5bGUgPSB7XG4gICAgICBwb3NpdGlvbjogJ2Fic29sdXRlJyxcbiAgICAgIGxlZnQ6IHgsXG4gICAgICB0b3A6IHksXG4gICAgICB3aWR0aCxcbiAgICAgIGhlaWdodFxuICAgIH07XG4gICAgY29uc3Qga2V5ID0gXCJ2aWV3LVwiLmNvbmNhdCh2aWV3SWQpO1xuICAgIGNvbnN0IHZpZXdFbGVtZW50ID0gY3JlYXRlRWxlbWVudCgnZGl2Jywge1xuICAgICAga2V5LFxuICAgICAgaWQ6IGtleSxcbiAgICAgIHN0eWxlXG4gICAgfSwgLi4udmlld0NoaWxkcmVuKTtcblxuICAgIGlmIChDb250ZXh0UHJvdmlkZXIpIHtcbiAgICAgIGNvbnN0IGNvbnRleHRWYWx1ZSA9IHtcbiAgICAgICAgdmlld3BvcnQsXG4gICAgICAgIGNvbnRhaW5lcjogZGVjay5jYW52YXMub2Zmc2V0UGFyZW50LFxuICAgICAgICBldmVudE1hbmFnZXI6IGRlY2suZXZlbnRNYW5hZ2VyLFxuICAgICAgICBvblZpZXdTdGF0ZUNoYW5nZTogcGFyYW1zID0+IHtcbiAgICAgICAgICBwYXJhbXMudmlld0lkID0gdmlld0lkO1xuXG4gICAgICAgICAgZGVjay5fb25WaWV3U3RhdGVDaGFuZ2UocGFyYW1zKTtcbiAgICAgICAgfVxuICAgICAgfTtcbiAgICAgIHJldHVybiBjcmVhdGVFbGVtZW50KENvbnRleHRQcm92aWRlciwge1xuICAgICAgICBrZXksXG4gICAgICAgIHZhbHVlOiBjb250ZXh0VmFsdWVcbiAgICAgIH0sIHZpZXdFbGVtZW50KTtcbiAgICB9XG5cbiAgICByZXR1cm4gdmlld0VsZW1lbnQ7XG4gIH0pO1xufVxuLy8jIHNvdXJjZU1hcHBpbmdVUkw9cG9zaXRpb24tY2hpbGRyZW4tdW5kZXItdmlld3MuanMubWFwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/react/dist/esm/utils/position-children-under-views.js\n");

/***/ }),

/***/ "./node_modules/@deck.gl/react/dist/esm/utils/use-isomorphic-layout-effect.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@deck.gl/react/dist/esm/utils/use-isomorphic-layout-effect.js ***!
  \************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"./node_modules/react/index.js\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n\nconst useIsomorphicLayoutEffect = typeof window !== 'undefined' ? react__WEBPACK_IMPORTED_MODULE_0__[\"useLayoutEffect\"] : react__WEBPACK_IMPORTED_MODULE_0__[\"useEffect\"];\n/* harmony default export */ __webpack_exports__[\"default\"] = (useIsomorphicLayoutEffect);\n//# sourceMappingURL=use-isomorphic-layout-effect.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGRlY2suZ2wvcmVhY3QvZGlzdC9lc20vdXRpbHMvdXNlLWlzb21vcnBoaWMtbGF5b3V0LWVmZmVjdC5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9AZGVjay5nbC9yZWFjdC9kaXN0L2VzbS91dGlscy91c2UtaXNvbW9ycGhpYy1sYXlvdXQtZWZmZWN0LmpzPzNkMWMiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgdXNlRWZmZWN0LCB1c2VMYXlvdXRFZmZlY3QgfSBmcm9tICdyZWFjdCc7XG5jb25zdCB1c2VJc29tb3JwaGljTGF5b3V0RWZmZWN0ID0gdHlwZW9mIHdpbmRvdyAhPT0gJ3VuZGVmaW5lZCcgPyB1c2VMYXlvdXRFZmZlY3QgOiB1c2VFZmZlY3Q7XG5leHBvcnQgZGVmYXVsdCB1c2VJc29tb3JwaGljTGF5b3V0RWZmZWN0O1xuLy8jIHNvdXJjZU1hcHBpbmdVUkw9dXNlLWlzb21vcnBoaWMtbGF5b3V0LWVmZmVjdC5qcy5tYXAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/@deck.gl/react/dist/esm/utils/use-isomorphic-layout-effect.js\n");

/***/ }),

/***/ "./node_modules/@loaders.gl/core/dist/esm/iterators/make-iterator/make-array-buffer-iterator.js":
/*!******************************************************************************************************!*\
  !*** ./node_modules/@loaders.gl/core/dist/esm/iterators/make-iterator/make-array-buffer-iterator.js ***!
  \******************************************************************************************************/
/*! exports provided: makeArrayBufferIterator */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"makeArrayBufferIterator\", function() { return makeArrayBufferIterator; });\nconst DEFAULT_CHUNK_SIZE = 256 * 1024;\nfunction* makeArrayBufferIterator(arrayBuffer, options = {}) {\n  const {\n    chunkSize = DEFAULT_CHUNK_SIZE\n  } = options;\n  let byteOffset = 0;\n\n  while (byteOffset < arrayBuffer.byteLength) {\n    const chunkByteLength = Math.min(arrayBuffer.byteLength - byteOffset, chunkSize);\n    const chunk = new ArrayBuffer(chunkByteLength);\n    const sourceArray = new Uint8Array(arrayBuffer, byteOffset, chunkByteLength);\n    const chunkArray = new Uint8Array(chunk);\n    chunkArray.set(sourceArray);\n    byteOffset += chunkByteLength;\n    yield chunk;\n  }\n}\n//# sourceMappingURL=make-array-buffer-iterator.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGxvYWRlcnMuZ2wvY29yZS9kaXN0L2VzbS9pdGVyYXRvcnMvbWFrZS1pdGVyYXRvci9tYWtlLWFycmF5LWJ1ZmZlci1pdGVyYXRvci5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9AbG9hZGVycy5nbC9jb3JlL2Rpc3QvZXNtL2l0ZXJhdG9ycy9tYWtlLWl0ZXJhdG9yL21ha2UtYXJyYXktYnVmZmVyLWl0ZXJhdG9yLmpzPzNkODEiXSwic291cmNlc0NvbnRlbnQiOlsiY29uc3QgREVGQVVMVF9DSFVOS19TSVpFID0gMjU2ICogMTAyNDtcbmV4cG9ydCBmdW5jdGlvbiogbWFrZUFycmF5QnVmZmVySXRlcmF0b3IoYXJyYXlCdWZmZXIsIG9wdGlvbnMgPSB7fSkge1xuICBjb25zdCB7XG4gICAgY2h1bmtTaXplID0gREVGQVVMVF9DSFVOS19TSVpFXG4gIH0gPSBvcHRpb25zO1xuICBsZXQgYnl0ZU9mZnNldCA9IDA7XG5cbiAgd2hpbGUgKGJ5dGVPZmZzZXQgPCBhcnJheUJ1ZmZlci5ieXRlTGVuZ3RoKSB7XG4gICAgY29uc3QgY2h1bmtCeXRlTGVuZ3RoID0gTWF0aC5taW4oYXJyYXlCdWZmZXIuYnl0ZUxlbmd0aCAtIGJ5dGVPZmZzZXQsIGNodW5rU2l6ZSk7XG4gICAgY29uc3QgY2h1bmsgPSBuZXcgQXJyYXlCdWZmZXIoY2h1bmtCeXRlTGVuZ3RoKTtcbiAgICBjb25zdCBzb3VyY2VBcnJheSA9IG5ldyBVaW50OEFycmF5KGFycmF5QnVmZmVyLCBieXRlT2Zmc2V0LCBjaHVua0J5dGVMZW5ndGgpO1xuICAgIGNvbnN0IGNodW5rQXJyYXkgPSBuZXcgVWludDhBcnJheShjaHVuayk7XG4gICAgY2h1bmtBcnJheS5zZXQoc291cmNlQXJyYXkpO1xuICAgIGJ5dGVPZmZzZXQgKz0gY2h1bmtCeXRlTGVuZ3RoO1xuICAgIHlpZWxkIGNodW5rO1xuICB9XG59XG4vLyMgc291cmNlTWFwcGluZ1VSTD1tYWtlLWFycmF5LWJ1ZmZlci1pdGVyYXRvci5qcy5tYXAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/@loaders.gl/core/dist/esm/iterators/make-iterator/make-array-buffer-iterator.js\n");

/***/ }),

/***/ "./node_modules/@loaders.gl/core/dist/esm/iterators/make-iterator/make-blob-iterator.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@loaders.gl/core/dist/esm/iterators/make-iterator/make-blob-iterator.js ***!
  \**********************************************************************************************/
/*! exports provided: makeBlobIterator */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"makeBlobIterator\", function() { return makeBlobIterator; });\nconst DEFAULT_CHUNK_SIZE = 1024 * 1024;\nasync function* makeBlobIterator(blob, options) {\n  const chunkSize = (options === null || options === void 0 ? void 0 : options.chunkSize) || DEFAULT_CHUNK_SIZE;\n  let offset = 0;\n\n  while (offset < blob.size) {\n    const end = offset + chunkSize;\n    const chunk = await blob.slice(offset, end).arrayBuffer();\n    offset = end;\n    yield chunk;\n  }\n}\n//# sourceMappingURL=make-blob-iterator.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGxvYWRlcnMuZ2wvY29yZS9kaXN0L2VzbS9pdGVyYXRvcnMvbWFrZS1pdGVyYXRvci9tYWtlLWJsb2ItaXRlcmF0b3IuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvQGxvYWRlcnMuZ2wvY29yZS9kaXN0L2VzbS9pdGVyYXRvcnMvbWFrZS1pdGVyYXRvci9tYWtlLWJsb2ItaXRlcmF0b3IuanM/NmQzZiJdLCJzb3VyY2VzQ29udGVudCI6WyJjb25zdCBERUZBVUxUX0NIVU5LX1NJWkUgPSAxMDI0ICogMTAyNDtcbmV4cG9ydCBhc3luYyBmdW5jdGlvbiogbWFrZUJsb2JJdGVyYXRvcihibG9iLCBvcHRpb25zKSB7XG4gIGNvbnN0IGNodW5rU2l6ZSA9IChvcHRpb25zID09PSBudWxsIHx8IG9wdGlvbnMgPT09IHZvaWQgMCA/IHZvaWQgMCA6IG9wdGlvbnMuY2h1bmtTaXplKSB8fCBERUZBVUxUX0NIVU5LX1NJWkU7XG4gIGxldCBvZmZzZXQgPSAwO1xuXG4gIHdoaWxlIChvZmZzZXQgPCBibG9iLnNpemUpIHtcbiAgICBjb25zdCBlbmQgPSBvZmZzZXQgKyBjaHVua1NpemU7XG4gICAgY29uc3QgY2h1bmsgPSBhd2FpdCBibG9iLnNsaWNlKG9mZnNldCwgZW5kKS5hcnJheUJ1ZmZlcigpO1xuICAgIG9mZnNldCA9IGVuZDtcbiAgICB5aWVsZCBjaHVuaztcbiAgfVxufVxuLy8jIHNvdXJjZU1hcHBpbmdVUkw9bWFrZS1ibG9iLWl0ZXJhdG9yLmpzLm1hcCJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/@loaders.gl/core/dist/esm/iterators/make-iterator/make-blob-iterator.js\n");

/***/ }),

/***/ "./node_modules/@loaders.gl/core/dist/esm/iterators/make-iterator/make-iterator.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@loaders.gl/core/dist/esm/iterators/make-iterator/make-iterator.js ***!
  \*****************************************************************************************/
/*! exports provided: makeIterator */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"makeIterator\", function() { return makeIterator; });\n/* harmony import */ var _make_string_iterator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./make-string-iterator */ \"./node_modules/@loaders.gl/core/dist/esm/iterators/make-iterator/make-string-iterator.js\");\n/* harmony import */ var _make_array_buffer_iterator__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./make-array-buffer-iterator */ \"./node_modules/@loaders.gl/core/dist/esm/iterators/make-iterator/make-array-buffer-iterator.js\");\n/* harmony import */ var _make_blob_iterator__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./make-blob-iterator */ \"./node_modules/@loaders.gl/core/dist/esm/iterators/make-iterator/make-blob-iterator.js\");\n/* harmony import */ var _make_stream_iterator__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./make-stream-iterator */ \"./node_modules/@loaders.gl/core/dist/esm/iterators/make-iterator/make-stream-iterator.js\");\n/* harmony import */ var _javascript_utils_is_type__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../javascript-utils/is-type */ \"./node_modules/@loaders.gl/core/dist/esm/javascript-utils/is-type.js\");\n\n\n\n\n\nfunction makeIterator(data, options) {\n  if (typeof data === 'string') {\n    return Object(_make_string_iterator__WEBPACK_IMPORTED_MODULE_0__[\"makeStringIterator\"])(data, options);\n  }\n\n  if (data instanceof ArrayBuffer) {\n    return Object(_make_array_buffer_iterator__WEBPACK_IMPORTED_MODULE_1__[\"makeArrayBufferIterator\"])(data, options);\n  }\n\n  if (Object(_javascript_utils_is_type__WEBPACK_IMPORTED_MODULE_4__[\"isBlob\"])(data)) {\n    return Object(_make_blob_iterator__WEBPACK_IMPORTED_MODULE_2__[\"makeBlobIterator\"])(data, options);\n  }\n\n  if (Object(_javascript_utils_is_type__WEBPACK_IMPORTED_MODULE_4__[\"isReadableStream\"])(data)) {\n    return Object(_make_stream_iterator__WEBPACK_IMPORTED_MODULE_3__[\"makeStreamIterator\"])(data, options);\n  }\n\n  if (Object(_javascript_utils_is_type__WEBPACK_IMPORTED_MODULE_4__[\"isResponse\"])(data)) {\n    const response = data;\n    return Object(_make_stream_iterator__WEBPACK_IMPORTED_MODULE_3__[\"makeStreamIterator\"])(response.body, options);\n  }\n\n  throw new Error('makeIterator');\n}\n//# sourceMappingURL=make-iterator.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGxvYWRlcnMuZ2wvY29yZS9kaXN0L2VzbS9pdGVyYXRvcnMvbWFrZS1pdGVyYXRvci9tYWtlLWl0ZXJhdG9yLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0Bsb2FkZXJzLmdsL2NvcmUvZGlzdC9lc20vaXRlcmF0b3JzL21ha2UtaXRlcmF0b3IvbWFrZS1pdGVyYXRvci5qcz8zNTM2Il0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IG1ha2VTdHJpbmdJdGVyYXRvciB9IGZyb20gJy4vbWFrZS1zdHJpbmctaXRlcmF0b3InO1xuaW1wb3J0IHsgbWFrZUFycmF5QnVmZmVySXRlcmF0b3IgfSBmcm9tICcuL21ha2UtYXJyYXktYnVmZmVyLWl0ZXJhdG9yJztcbmltcG9ydCB7IG1ha2VCbG9iSXRlcmF0b3IgfSBmcm9tICcuL21ha2UtYmxvYi1pdGVyYXRvcic7XG5pbXBvcnQgeyBtYWtlU3RyZWFtSXRlcmF0b3IgfSBmcm9tICcuL21ha2Utc3RyZWFtLWl0ZXJhdG9yJztcbmltcG9ydCB7IGlzQmxvYiwgaXNSZWFkYWJsZVN0cmVhbSwgaXNSZXNwb25zZSB9IGZyb20gJy4uLy4uL2phdmFzY3JpcHQtdXRpbHMvaXMtdHlwZSc7XG5leHBvcnQgZnVuY3Rpb24gbWFrZUl0ZXJhdG9yKGRhdGEsIG9wdGlvbnMpIHtcbiAgaWYgKHR5cGVvZiBkYXRhID09PSAnc3RyaW5nJykge1xuICAgIHJldHVybiBtYWtlU3RyaW5nSXRlcmF0b3IoZGF0YSwgb3B0aW9ucyk7XG4gIH1cblxuICBpZiAoZGF0YSBpbnN0YW5jZW9mIEFycmF5QnVmZmVyKSB7XG4gICAgcmV0dXJuIG1ha2VBcnJheUJ1ZmZlckl0ZXJhdG9yKGRhdGEsIG9wdGlvbnMpO1xuICB9XG5cbiAgaWYgKGlzQmxvYihkYXRhKSkge1xuICAgIHJldHVybiBtYWtlQmxvYkl0ZXJhdG9yKGRhdGEsIG9wdGlvbnMpO1xuICB9XG5cbiAgaWYgKGlzUmVhZGFibGVTdHJlYW0oZGF0YSkpIHtcbiAgICByZXR1cm4gbWFrZVN0cmVhbUl0ZXJhdG9yKGRhdGEsIG9wdGlvbnMpO1xuICB9XG5cbiAgaWYgKGlzUmVzcG9uc2UoZGF0YSkpIHtcbiAgICBjb25zdCByZXNwb25zZSA9IGRhdGE7XG4gICAgcmV0dXJuIG1ha2VTdHJlYW1JdGVyYXRvcihyZXNwb25zZS5ib2R5LCBvcHRpb25zKTtcbiAgfVxuXG4gIHRocm93IG5ldyBFcnJvcignbWFrZUl0ZXJhdG9yJyk7XG59XG4vLyMgc291cmNlTWFwcGluZ1VSTD1tYWtlLWl0ZXJhdG9yLmpzLm1hcCJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/@loaders.gl/core/dist/esm/iterators/make-iterator/make-iterator.js\n");

/***/ }),

/***/ "./node_modules/@loaders.gl/core/dist/esm/iterators/make-iterator/make-stream-iterator.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@loaders.gl/core/dist/esm/iterators/make-iterator/make-stream-iterator.js ***!
  \************************************************************************************************/
/*! exports provided: makeStreamIterator */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"makeStreamIterator\", function() { return makeStreamIterator; });\n/* harmony import */ var _loaders_gl_loader_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @loaders.gl/loader-utils */ \"./node_modules/@loaders.gl/loader-utils/dist/esm/lib/env-utils/globals.js\");\n/* harmony import */ var _loaders_gl_loader_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @loaders.gl/loader-utils */ \"./node_modules/@loaders.gl/loader-utils/dist/esm/lib/binary-utils/array-buffer-utils.js\");\n\nfunction makeStreamIterator(stream, options) {\n  return _loaders_gl_loader_utils__WEBPACK_IMPORTED_MODULE_0__[\"isBrowser\"] ? makeBrowserStreamIterator(stream, options) : makeNodeStreamIterator(stream, options);\n}\n\nasync function* makeBrowserStreamIterator(stream, options) {\n  const reader = stream.getReader();\n  let nextBatchPromise;\n\n  try {\n    while (true) {\n      const currentBatchPromise = nextBatchPromise || reader.read();\n\n      if (options !== null && options !== void 0 && options._streamReadAhead) {\n        nextBatchPromise = reader.read();\n      }\n\n      const {\n        done,\n        value\n      } = await currentBatchPromise;\n\n      if (done) {\n        return;\n      }\n\n      yield Object(_loaders_gl_loader_utils__WEBPACK_IMPORTED_MODULE_1__[\"toArrayBuffer\"])(value);\n    }\n  } catch (error) {\n    reader.releaseLock();\n  }\n}\n\nasync function* makeNodeStreamIterator(stream, options) {\n  for await (const chunk of stream) {\n    yield Object(_loaders_gl_loader_utils__WEBPACK_IMPORTED_MODULE_1__[\"toArrayBuffer\"])(chunk);\n  }\n}\n//# sourceMappingURL=make-stream-iterator.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@loaders.gl/core/dist/esm/iterators/make-iterator/make-stream-iterator.js\n");

/***/ }),

/***/ "./node_modules/@loaders.gl/core/dist/esm/iterators/make-iterator/make-string-iterator.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@loaders.gl/core/dist/esm/iterators/make-iterator/make-string-iterator.js ***!
  \************************************************************************************************/
/*! exports provided: makeStringIterator */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"makeStringIterator\", function() { return makeStringIterator; });\nconst DEFAULT_CHUNK_SIZE = 256 * 1024;\nfunction* makeStringIterator(string, options) {\n  const chunkSize = (options === null || options === void 0 ? void 0 : options.chunkSize) || DEFAULT_CHUNK_SIZE;\n  let offset = 0;\n  const textEncoder = new TextEncoder();\n\n  while (offset < string.length) {\n    const chunkLength = Math.min(string.length - offset, chunkSize);\n    const chunk = string.slice(offset, offset + chunkLength);\n    offset += chunkLength;\n    yield textEncoder.encode(chunk);\n  }\n}\n//# sourceMappingURL=make-string-iterator.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGxvYWRlcnMuZ2wvY29yZS9kaXN0L2VzbS9pdGVyYXRvcnMvbWFrZS1pdGVyYXRvci9tYWtlLXN0cmluZy1pdGVyYXRvci5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9AbG9hZGVycy5nbC9jb3JlL2Rpc3QvZXNtL2l0ZXJhdG9ycy9tYWtlLWl0ZXJhdG9yL21ha2Utc3RyaW5nLWl0ZXJhdG9yLmpzP2NjMjMiXSwic291cmNlc0NvbnRlbnQiOlsiY29uc3QgREVGQVVMVF9DSFVOS19TSVpFID0gMjU2ICogMTAyNDtcbmV4cG9ydCBmdW5jdGlvbiogbWFrZVN0cmluZ0l0ZXJhdG9yKHN0cmluZywgb3B0aW9ucykge1xuICBjb25zdCBjaHVua1NpemUgPSAob3B0aW9ucyA9PT0gbnVsbCB8fCBvcHRpb25zID09PSB2b2lkIDAgPyB2b2lkIDAgOiBvcHRpb25zLmNodW5rU2l6ZSkgfHwgREVGQVVMVF9DSFVOS19TSVpFO1xuICBsZXQgb2Zmc2V0ID0gMDtcbiAgY29uc3QgdGV4dEVuY29kZXIgPSBuZXcgVGV4dEVuY29kZXIoKTtcblxuICB3aGlsZSAob2Zmc2V0IDwgc3RyaW5nLmxlbmd0aCkge1xuICAgIGNvbnN0IGNodW5rTGVuZ3RoID0gTWF0aC5taW4oc3RyaW5nLmxlbmd0aCAtIG9mZnNldCwgY2h1bmtTaXplKTtcbiAgICBjb25zdCBjaHVuayA9IHN0cmluZy5zbGljZShvZmZzZXQsIG9mZnNldCArIGNodW5rTGVuZ3RoKTtcbiAgICBvZmZzZXQgKz0gY2h1bmtMZW5ndGg7XG4gICAgeWllbGQgdGV4dEVuY29kZXIuZW5jb2RlKGNodW5rKTtcbiAgfVxufVxuLy8jIHNvdXJjZU1hcHBpbmdVUkw9bWFrZS1zdHJpbmctaXRlcmF0b3IuanMubWFwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/@loaders.gl/core/dist/esm/iterators/make-iterator/make-string-iterator.js\n");

/***/ }),

/***/ "./node_modules/@loaders.gl/core/dist/esm/javascript-utils/is-type.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@loaders.gl/core/dist/esm/javascript-utils/is-type.js ***!
  \****************************************************************************/
/*! exports provided: isObject, isPureObject, isPromise, isIterable, isAsyncIterable, isIterator, isResponse, isFile, isBlob, isWritableDOMStream, isReadableDOMStream, isBuffer, isWritableNodeStream, isReadableNodeStream, isReadableStream, isWritableStream */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isObject\", function() { return isObject; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isPureObject\", function() { return isPureObject; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isPromise\", function() { return isPromise; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isIterable\", function() { return isIterable; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isAsyncIterable\", function() { return isAsyncIterable; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isIterator\", function() { return isIterator; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isResponse\", function() { return isResponse; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isFile\", function() { return isFile; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isBlob\", function() { return isBlob; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isWritableDOMStream\", function() { return isWritableDOMStream; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isReadableDOMStream\", function() { return isReadableDOMStream; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isBuffer\", function() { return isBuffer; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isWritableNodeStream\", function() { return isWritableNodeStream; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isReadableNodeStream\", function() { return isReadableNodeStream; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isReadableStream\", function() { return isReadableStream; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isWritableStream\", function() { return isWritableStream; });\nconst isBoolean = x => typeof x === 'boolean';\n\nconst isFunction = x => typeof x === 'function';\n\nconst isObject = x => x !== null && typeof x === 'object';\nconst isPureObject = x => isObject(x) && x.constructor === {}.constructor;\nconst isPromise = x => isObject(x) && isFunction(x.then);\nconst isIterable = x => x && typeof x[Symbol.iterator] === 'function';\nconst isAsyncIterable = x => x && typeof x[Symbol.asyncIterator] === 'function';\nconst isIterator = x => x && isFunction(x.next);\nconst isResponse = x => typeof Response !== 'undefined' && x instanceof Response || x && x.arrayBuffer && x.text && x.json;\nconst isFile = x => typeof File !== 'undefined' && x instanceof File;\nconst isBlob = x => typeof Blob !== 'undefined' && x instanceof Blob;\nconst isWritableDOMStream = x => isObject(x) && isFunction(x.abort) && isFunction(x.getWriter);\nconst isReadableDOMStream = x => typeof ReadableStream !== 'undefined' && x instanceof ReadableStream || isObject(x) && isFunction(x.tee) && isFunction(x.cancel) && isFunction(x.getReader);\nconst isBuffer = x => x && typeof x === 'object' && x.isBuffer;\nconst isWritableNodeStream = x => isObject(x) && isFunction(x.end) && isFunction(x.write) && isBoolean(x.writable);\nconst isReadableNodeStream = x => isObject(x) && isFunction(x.read) && isFunction(x.pipe) && isBoolean(x.readable);\nconst isReadableStream = x => isReadableDOMStream(x) || isReadableNodeStream(x);\nconst isWritableStream = x => isWritableDOMStream(x) || isWritableNodeStream(x);\n//# sourceMappingURL=is-type.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@loaders.gl/core/dist/esm/javascript-utils/is-type.js\n");

/***/ }),

/***/ "./node_modules/@loaders.gl/core/dist/esm/lib/api/load.js":
/*!****************************************************************!*\
  !*** ./node_modules/@loaders.gl/core/dist/esm/lib/api/load.js ***!
  \****************************************************************/
/*! exports provided: load */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"load\", function() { return load; });\n/* harmony import */ var _javascript_utils_is_type__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../javascript-utils/is-type */ \"./node_modules/@loaders.gl/core/dist/esm/javascript-utils/is-type.js\");\n/* harmony import */ var _loader_utils_normalize_loader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../loader-utils/normalize-loader */ \"./node_modules/@loaders.gl/core/dist/esm/lib/loader-utils/normalize-loader.js\");\n/* harmony import */ var _loader_utils_option_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../loader-utils/option-utils */ \"./node_modules/@loaders.gl/core/dist/esm/lib/loader-utils/option-utils.js\");\n/* harmony import */ var _parse__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./parse */ \"./node_modules/@loaders.gl/core/dist/esm/lib/api/parse.js\");\n\n\n\n\nasync function load(url, loaders, options, context) {\n  if (!Array.isArray(loaders) && !Object(_loader_utils_normalize_loader__WEBPACK_IMPORTED_MODULE_1__[\"isLoaderObject\"])(loaders)) {\n    context = undefined;\n    options = loaders;\n    loaders = undefined;\n  }\n\n  const fetch = Object(_loader_utils_option_utils__WEBPACK_IMPORTED_MODULE_2__[\"getFetchFunction\"])(options);\n  let data = url;\n\n  if (typeof url === 'string') {\n    data = await fetch(url);\n  }\n\n  if (Object(_javascript_utils_is_type__WEBPACK_IMPORTED_MODULE_0__[\"isBlob\"])(url)) {\n    data = await fetch(url);\n  }\n\n  return await Object(_parse__WEBPACK_IMPORTED_MODULE_3__[\"parse\"])(data, loaders, options);\n}\n//# sourceMappingURL=load.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGxvYWRlcnMuZ2wvY29yZS9kaXN0L2VzbS9saWIvYXBpL2xvYWQuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvQGxvYWRlcnMuZ2wvY29yZS9kaXN0L2VzbS9saWIvYXBpL2xvYWQuanM/MjQxOCJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBpc0Jsb2IgfSBmcm9tICcuLi8uLi9qYXZhc2NyaXB0LXV0aWxzL2lzLXR5cGUnO1xuaW1wb3J0IHsgaXNMb2FkZXJPYmplY3QgfSBmcm9tICcuLi9sb2FkZXItdXRpbHMvbm9ybWFsaXplLWxvYWRlcic7XG5pbXBvcnQgeyBnZXRGZXRjaEZ1bmN0aW9uIH0gZnJvbSAnLi4vbG9hZGVyLXV0aWxzL29wdGlvbi11dGlscyc7XG5pbXBvcnQgeyBwYXJzZSB9IGZyb20gJy4vcGFyc2UnO1xuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIGxvYWQodXJsLCBsb2FkZXJzLCBvcHRpb25zLCBjb250ZXh0KSB7XG4gIGlmICghQXJyYXkuaXNBcnJheShsb2FkZXJzKSAmJiAhaXNMb2FkZXJPYmplY3QobG9hZGVycykpIHtcbiAgICBjb250ZXh0ID0gdW5kZWZpbmVkO1xuICAgIG9wdGlvbnMgPSBsb2FkZXJzO1xuICAgIGxvYWRlcnMgPSB1bmRlZmluZWQ7XG4gIH1cblxuICBjb25zdCBmZXRjaCA9IGdldEZldGNoRnVuY3Rpb24ob3B0aW9ucyk7XG4gIGxldCBkYXRhID0gdXJsO1xuXG4gIGlmICh0eXBlb2YgdXJsID09PSAnc3RyaW5nJykge1xuICAgIGRhdGEgPSBhd2FpdCBmZXRjaCh1cmwpO1xuICB9XG5cbiAgaWYgKGlzQmxvYih1cmwpKSB7XG4gICAgZGF0YSA9IGF3YWl0IGZldGNoKHVybCk7XG4gIH1cblxuICByZXR1cm4gYXdhaXQgcGFyc2UoZGF0YSwgbG9hZGVycywgb3B0aW9ucyk7XG59XG4vLyMgc291cmNlTWFwcGluZ1VSTD1sb2FkLmpzLm1hcCJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/@loaders.gl/core/dist/esm/lib/api/load.js\n");

/***/ }),

/***/ "./node_modules/@loaders.gl/core/dist/esm/lib/api/parse.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@loaders.gl/core/dist/esm/lib/api/parse.js ***!
  \*****************************************************************/
/*! exports provided: parse */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"parse\", function() { return parse; });\n/* harmony import */ var _loaders_gl_worker_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @loaders.gl/worker-utils */ \"./node_modules/@loaders.gl/worker-utils/dist/esm/lib/env-utils/assert.js\");\n/* harmony import */ var _loaders_gl_worker_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @loaders.gl/worker-utils */ \"./node_modules/@loaders.gl/worker-utils/dist/esm/lib/worker-api/validate-worker-version.js\");\n/* harmony import */ var _loaders_gl_loader_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @loaders.gl/loader-utils */ \"./node_modules/@loaders.gl/loader-utils/dist/esm/lib/worker-loader-utils/parse-with-worker.js\");\n/* harmony import */ var _loader_utils_normalize_loader__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../loader-utils/normalize-loader */ \"./node_modules/@loaders.gl/core/dist/esm/lib/loader-utils/normalize-loader.js\");\n/* harmony import */ var _loader_utils_option_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../loader-utils/option-utils */ \"./node_modules/@loaders.gl/core/dist/esm/lib/loader-utils/option-utils.js\");\n/* harmony import */ var _loader_utils_get_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../loader-utils/get-data */ \"./node_modules/@loaders.gl/core/dist/esm/lib/loader-utils/get-data.js\");\n/* harmony import */ var _loader_utils_loader_context__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../loader-utils/loader-context */ \"./node_modules/@loaders.gl/core/dist/esm/lib/loader-utils/loader-context.js\");\n/* harmony import */ var _utils_resource_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/resource-utils */ \"./node_modules/@loaders.gl/core/dist/esm/lib/utils/resource-utils.js\");\n/* harmony import */ var _select_loader__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./select-loader */ \"./node_modules/@loaders.gl/core/dist/esm/lib/api/select-loader.js\");\n\n\n\n\n\n\n\n\nasync function parse(data, loaders, options, context) {\n  Object(_loaders_gl_worker_utils__WEBPACK_IMPORTED_MODULE_0__[\"assert\"])(!context || typeof context === 'object');\n\n  if (loaders && !Array.isArray(loaders) && !Object(_loader_utils_normalize_loader__WEBPACK_IMPORTED_MODULE_3__[\"isLoaderObject\"])(loaders)) {\n    context = undefined;\n    options = loaders;\n    loaders = undefined;\n  }\n\n  data = await data;\n  options = options || {};\n  const {\n    url\n  } = Object(_utils_resource_utils__WEBPACK_IMPORTED_MODULE_7__[\"getResourceUrlAndType\"])(data);\n  const typedLoaders = loaders;\n  const candidateLoaders = Object(_loader_utils_loader_context__WEBPACK_IMPORTED_MODULE_6__[\"getLoadersFromContext\"])(typedLoaders, context);\n  const loader = await Object(_select_loader__WEBPACK_IMPORTED_MODULE_8__[\"selectLoader\"])(data, candidateLoaders, options);\n\n  if (!loader) {\n    return null;\n  }\n\n  options = Object(_loader_utils_option_utils__WEBPACK_IMPORTED_MODULE_4__[\"normalizeOptions\"])(options, loader, candidateLoaders, url);\n  context = Object(_loader_utils_loader_context__WEBPACK_IMPORTED_MODULE_6__[\"getLoaderContext\"])({\n    url,\n    parse,\n    loaders: candidateLoaders\n  }, options, context);\n  return await parseWithLoader(loader, data, options, context);\n}\n\nasync function parseWithLoader(loader, data, options, context) {\n  Object(_loaders_gl_worker_utils__WEBPACK_IMPORTED_MODULE_1__[\"validateWorkerVersion\"])(loader);\n  data = await Object(_loader_utils_get_data__WEBPACK_IMPORTED_MODULE_5__[\"getArrayBufferOrStringFromData\"])(data, loader, options);\n\n  if (loader.parseTextSync && typeof data === 'string') {\n    options.dataType = 'text';\n    return loader.parseTextSync(data, options, context, loader);\n  }\n\n  if (Object(_loaders_gl_loader_utils__WEBPACK_IMPORTED_MODULE_2__[\"canParseWithWorker\"])(loader, options)) {\n    return await Object(_loaders_gl_loader_utils__WEBPACK_IMPORTED_MODULE_2__[\"parseWithWorker\"])(loader, data, options, context, parse);\n  }\n\n  if (loader.parseText && typeof data === 'string') {\n    return await loader.parseText(data, options, context, loader);\n  }\n\n  if (loader.parse) {\n    return await loader.parse(data, options, context, loader);\n  }\n\n  Object(_loaders_gl_worker_utils__WEBPACK_IMPORTED_MODULE_0__[\"assert\"])(!loader.parseSync);\n  throw new Error(`${loader.id} loader - no parser found and worker is disabled`);\n}\n//# sourceMappingURL=parse.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGxvYWRlcnMuZ2wvY29yZS9kaXN0L2VzbS9saWIvYXBpL3BhcnNlLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0Bsb2FkZXJzLmdsL2NvcmUvZGlzdC9lc20vbGliL2FwaS9wYXJzZS5qcz85MzQ3Il0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGFzc2VydCwgdmFsaWRhdGVXb3JrZXJWZXJzaW9uIH0gZnJvbSAnQGxvYWRlcnMuZ2wvd29ya2VyLXV0aWxzJztcbmltcG9ydCB7IHBhcnNlV2l0aFdvcmtlciwgY2FuUGFyc2VXaXRoV29ya2VyIH0gZnJvbSAnQGxvYWRlcnMuZ2wvbG9hZGVyLXV0aWxzJztcbmltcG9ydCB7IGlzTG9hZGVyT2JqZWN0IH0gZnJvbSAnLi4vbG9hZGVyLXV0aWxzL25vcm1hbGl6ZS1sb2FkZXInO1xuaW1wb3J0IHsgbm9ybWFsaXplT3B0aW9ucyB9IGZyb20gJy4uL2xvYWRlci11dGlscy9vcHRpb24tdXRpbHMnO1xuaW1wb3J0IHsgZ2V0QXJyYXlCdWZmZXJPclN0cmluZ0Zyb21EYXRhIH0gZnJvbSAnLi4vbG9hZGVyLXV0aWxzL2dldC1kYXRhJztcbmltcG9ydCB7IGdldExvYWRlckNvbnRleHQsIGdldExvYWRlcnNGcm9tQ29udGV4dCB9IGZyb20gJy4uL2xvYWRlci11dGlscy9sb2FkZXItY29udGV4dCc7XG5pbXBvcnQgeyBnZXRSZXNvdXJjZVVybEFuZFR5cGUgfSBmcm9tICcuLi91dGlscy9yZXNvdXJjZS11dGlscyc7XG5pbXBvcnQgeyBzZWxlY3RMb2FkZXIgfSBmcm9tICcuL3NlbGVjdC1sb2FkZXInO1xuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIHBhcnNlKGRhdGEsIGxvYWRlcnMsIG9wdGlvbnMsIGNvbnRleHQpIHtcbiAgYXNzZXJ0KCFjb250ZXh0IHx8IHR5cGVvZiBjb250ZXh0ID09PSAnb2JqZWN0Jyk7XG5cbiAgaWYgKGxvYWRlcnMgJiYgIUFycmF5LmlzQXJyYXkobG9hZGVycykgJiYgIWlzTG9hZGVyT2JqZWN0KGxvYWRlcnMpKSB7XG4gICAgY29udGV4dCA9IHVuZGVmaW5lZDtcbiAgICBvcHRpb25zID0gbG9hZGVycztcbiAgICBsb2FkZXJzID0gdW5kZWZpbmVkO1xuICB9XG5cbiAgZGF0YSA9IGF3YWl0IGRhdGE7XG4gIG9wdGlvbnMgPSBvcHRpb25zIHx8IHt9O1xuICBjb25zdCB7XG4gICAgdXJsXG4gIH0gPSBnZXRSZXNvdXJjZVVybEFuZFR5cGUoZGF0YSk7XG4gIGNvbnN0IHR5cGVkTG9hZGVycyA9IGxvYWRlcnM7XG4gIGNvbnN0IGNhbmRpZGF0ZUxvYWRlcnMgPSBnZXRMb2FkZXJzRnJvbUNvbnRleHQodHlwZWRMb2FkZXJzLCBjb250ZXh0KTtcbiAgY29uc3QgbG9hZGVyID0gYXdhaXQgc2VsZWN0TG9hZGVyKGRhdGEsIGNhbmRpZGF0ZUxvYWRlcnMsIG9wdGlvbnMpO1xuXG4gIGlmICghbG9hZGVyKSB7XG4gICAgcmV0dXJuIG51bGw7XG4gIH1cblxuICBvcHRpb25zID0gbm9ybWFsaXplT3B0aW9ucyhvcHRpb25zLCBsb2FkZXIsIGNhbmRpZGF0ZUxvYWRlcnMsIHVybCk7XG4gIGNvbnRleHQgPSBnZXRMb2FkZXJDb250ZXh0KHtcbiAgICB1cmwsXG4gICAgcGFyc2UsXG4gICAgbG9hZGVyczogY2FuZGlkYXRlTG9hZGVyc1xuICB9LCBvcHRpb25zLCBjb250ZXh0KTtcbiAgcmV0dXJuIGF3YWl0IHBhcnNlV2l0aExvYWRlcihsb2FkZXIsIGRhdGEsIG9wdGlvbnMsIGNvbnRleHQpO1xufVxuXG5hc3luYyBmdW5jdGlvbiBwYXJzZVdpdGhMb2FkZXIobG9hZGVyLCBkYXRhLCBvcHRpb25zLCBjb250ZXh0KSB7XG4gIHZhbGlkYXRlV29ya2VyVmVyc2lvbihsb2FkZXIpO1xuICBkYXRhID0gYXdhaXQgZ2V0QXJyYXlCdWZmZXJPclN0cmluZ0Zyb21EYXRhKGRhdGEsIGxvYWRlciwgb3B0aW9ucyk7XG5cbiAgaWYgKGxvYWRlci5wYXJzZVRleHRTeW5jICYmIHR5cGVvZiBkYXRhID09PSAnc3RyaW5nJykge1xuICAgIG9wdGlvbnMuZGF0YVR5cGUgPSAndGV4dCc7XG4gICAgcmV0dXJuIGxvYWRlci5wYXJzZVRleHRTeW5jKGRhdGEsIG9wdGlvbnMsIGNvbnRleHQsIGxvYWRlcik7XG4gIH1cblxuICBpZiAoY2FuUGFyc2VXaXRoV29ya2VyKGxvYWRlciwgb3B0aW9ucykpIHtcbiAgICByZXR1cm4gYXdhaXQgcGFyc2VXaXRoV29ya2VyKGxvYWRlciwgZGF0YSwgb3B0aW9ucywgY29udGV4dCwgcGFyc2UpO1xuICB9XG5cbiAgaWYgKGxvYWRlci5wYXJzZVRleHQgJiYgdHlwZW9mIGRhdGEgPT09ICdzdHJpbmcnKSB7XG4gICAgcmV0dXJuIGF3YWl0IGxvYWRlci5wYXJzZVRleHQoZGF0YSwgb3B0aW9ucywgY29udGV4dCwgbG9hZGVyKTtcbiAgfVxuXG4gIGlmIChsb2FkZXIucGFyc2UpIHtcbiAgICByZXR1cm4gYXdhaXQgbG9hZGVyLnBhcnNlKGRhdGEsIG9wdGlvbnMsIGNvbnRleHQsIGxvYWRlcik7XG4gIH1cblxuICBhc3NlcnQoIWxvYWRlci5wYXJzZVN5bmMpO1xuICB0aHJvdyBuZXcgRXJyb3IoYCR7bG9hZGVyLmlkfSBsb2FkZXIgLSBubyBwYXJzZXIgZm91bmQgYW5kIHdvcmtlciBpcyBkaXNhYmxlZGApO1xufVxuLy8jIHNvdXJjZU1hcHBpbmdVUkw9cGFyc2UuanMubWFwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/@loaders.gl/core/dist/esm/lib/api/parse.js\n");

/***/ }),

/***/ "./node_modules/@loaders.gl/core/dist/esm/lib/api/register-loaders.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@loaders.gl/core/dist/esm/lib/api/register-loaders.js ***!
  \****************************************************************************/
/*! exports provided: registerLoaders, getRegisteredLoaders, _unregisterLoaders */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"registerLoaders\", function() { return registerLoaders; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getRegisteredLoaders\", function() { return getRegisteredLoaders; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"_unregisterLoaders\", function() { return _unregisterLoaders; });\n/* harmony import */ var _loader_utils_normalize_loader__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../loader-utils/normalize-loader */ \"./node_modules/@loaders.gl/core/dist/esm/lib/loader-utils/normalize-loader.js\");\n/* harmony import */ var _loader_utils_option_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../loader-utils/option-utils */ \"./node_modules/@loaders.gl/core/dist/esm/lib/loader-utils/option-utils.js\");\n\n\n\nconst getGlobalLoaderRegistry = () => {\n  const state = Object(_loader_utils_option_utils__WEBPACK_IMPORTED_MODULE_1__[\"getGlobalLoaderState\"])();\n  state.loaderRegistry = state.loaderRegistry || [];\n  return state.loaderRegistry;\n};\n\nfunction registerLoaders(loaders) {\n  const loaderRegistry = getGlobalLoaderRegistry();\n  loaders = Array.isArray(loaders) ? loaders : [loaders];\n\n  for (const loader of loaders) {\n    const normalizedLoader = Object(_loader_utils_normalize_loader__WEBPACK_IMPORTED_MODULE_0__[\"normalizeLoader\"])(loader);\n\n    if (!loaderRegistry.find(registeredLoader => normalizedLoader === registeredLoader)) {\n      loaderRegistry.unshift(normalizedLoader);\n    }\n  }\n}\nfunction getRegisteredLoaders() {\n  return getGlobalLoaderRegistry();\n}\nfunction _unregisterLoaders() {\n  const state = Object(_loader_utils_option_utils__WEBPACK_IMPORTED_MODULE_1__[\"getGlobalLoaderState\"])();\n  state.loaderRegistry = [];\n}\n//# sourceMappingURL=register-loaders.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGxvYWRlcnMuZ2wvY29yZS9kaXN0L2VzbS9saWIvYXBpL3JlZ2lzdGVyLWxvYWRlcnMuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvQGxvYWRlcnMuZ2wvY29yZS9kaXN0L2VzbS9saWIvYXBpL3JlZ2lzdGVyLWxvYWRlcnMuanM/MWY3ZSJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBub3JtYWxpemVMb2FkZXIgfSBmcm9tICcuLi9sb2FkZXItdXRpbHMvbm9ybWFsaXplLWxvYWRlcic7XG5pbXBvcnQgeyBnZXRHbG9iYWxMb2FkZXJTdGF0ZSB9IGZyb20gJy4uL2xvYWRlci11dGlscy9vcHRpb24tdXRpbHMnO1xuXG5jb25zdCBnZXRHbG9iYWxMb2FkZXJSZWdpc3RyeSA9ICgpID0+IHtcbiAgY29uc3Qgc3RhdGUgPSBnZXRHbG9iYWxMb2FkZXJTdGF0ZSgpO1xuICBzdGF0ZS5sb2FkZXJSZWdpc3RyeSA9IHN0YXRlLmxvYWRlclJlZ2lzdHJ5IHx8IFtdO1xuICByZXR1cm4gc3RhdGUubG9hZGVyUmVnaXN0cnk7XG59O1xuXG5leHBvcnQgZnVuY3Rpb24gcmVnaXN0ZXJMb2FkZXJzKGxvYWRlcnMpIHtcbiAgY29uc3QgbG9hZGVyUmVnaXN0cnkgPSBnZXRHbG9iYWxMb2FkZXJSZWdpc3RyeSgpO1xuICBsb2FkZXJzID0gQXJyYXkuaXNBcnJheShsb2FkZXJzKSA/IGxvYWRlcnMgOiBbbG9hZGVyc107XG5cbiAgZm9yIChjb25zdCBsb2FkZXIgb2YgbG9hZGVycykge1xuICAgIGNvbnN0IG5vcm1hbGl6ZWRMb2FkZXIgPSBub3JtYWxpemVMb2FkZXIobG9hZGVyKTtcblxuICAgIGlmICghbG9hZGVyUmVnaXN0cnkuZmluZChyZWdpc3RlcmVkTG9hZGVyID0+IG5vcm1hbGl6ZWRMb2FkZXIgPT09IHJlZ2lzdGVyZWRMb2FkZXIpKSB7XG4gICAgICBsb2FkZXJSZWdpc3RyeS51bnNoaWZ0KG5vcm1hbGl6ZWRMb2FkZXIpO1xuICAgIH1cbiAgfVxufVxuZXhwb3J0IGZ1bmN0aW9uIGdldFJlZ2lzdGVyZWRMb2FkZXJzKCkge1xuICByZXR1cm4gZ2V0R2xvYmFsTG9hZGVyUmVnaXN0cnkoKTtcbn1cbmV4cG9ydCBmdW5jdGlvbiBfdW5yZWdpc3RlckxvYWRlcnMoKSB7XG4gIGNvbnN0IHN0YXRlID0gZ2V0R2xvYmFsTG9hZGVyU3RhdGUoKTtcbiAgc3RhdGUubG9hZGVyUmVnaXN0cnkgPSBbXTtcbn1cbi8vIyBzb3VyY2VNYXBwaW5nVVJMPXJlZ2lzdGVyLWxvYWRlcnMuanMubWFwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/@loaders.gl/core/dist/esm/lib/api/register-loaders.js\n");

/***/ }),

/***/ "./node_modules/@loaders.gl/core/dist/esm/lib/api/select-loader.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@loaders.gl/core/dist/esm/lib/api/select-loader.js ***!
  \*************************************************************************/
/*! exports provided: selectLoader, selectLoaderSync */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"selectLoader\", function() { return selectLoader; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"selectLoaderSync\", function() { return selectLoaderSync; });\n/* harmony import */ var _loaders_gl_loader_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @loaders.gl/loader-utils */ \"./node_modules/@loaders.gl/loader-utils/dist/esm/lib/binary-utils/array-buffer-utils.js\");\n/* harmony import */ var _loader_utils_normalize_loader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../loader-utils/normalize-loader */ \"./node_modules/@loaders.gl/core/dist/esm/lib/loader-utils/normalize-loader.js\");\n/* harmony import */ var _utils_resource_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/resource-utils */ \"./node_modules/@loaders.gl/core/dist/esm/lib/utils/resource-utils.js\");\n/* harmony import */ var _register_loaders__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./register-loaders */ \"./node_modules/@loaders.gl/core/dist/esm/lib/api/register-loaders.js\");\n/* harmony import */ var _javascript_utils_is_type__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../javascript-utils/is-type */ \"./node_modules/@loaders.gl/core/dist/esm/javascript-utils/is-type.js\");\n\n\n\n\n\nconst EXT_PATTERN = /\\.([^.]+)$/;\nasync function selectLoader(data, loaders = [], options, context) {\n  if (!validHTTPResponse(data)) {\n    return null;\n  }\n\n  let loader = selectLoaderSync(data, loaders, { ...options,\n    nothrow: true\n  }, context);\n\n  if (loader) {\n    return loader;\n  }\n\n  if (Object(_javascript_utils_is_type__WEBPACK_IMPORTED_MODULE_4__[\"isBlob\"])(data)) {\n    data = await data.slice(0, 10).arrayBuffer();\n    loader = selectLoaderSync(data, loaders, options, context);\n  }\n\n  if (!loader && !(options !== null && options !== void 0 && options.nothrow)) {\n    throw new Error(getNoValidLoaderMessage(data));\n  }\n\n  return loader;\n}\nfunction selectLoaderSync(data, loaders = [], options, context) {\n  if (!validHTTPResponse(data)) {\n    return null;\n  }\n\n  if (loaders && !Array.isArray(loaders)) {\n    return Object(_loader_utils_normalize_loader__WEBPACK_IMPORTED_MODULE_1__[\"normalizeLoader\"])(loaders);\n  }\n\n  let candidateLoaders = [];\n\n  if (loaders) {\n    candidateLoaders = candidateLoaders.concat(loaders);\n  }\n\n  if (!(options !== null && options !== void 0 && options.ignoreRegisteredLoaders)) {\n    candidateLoaders.push(...Object(_register_loaders__WEBPACK_IMPORTED_MODULE_3__[\"getRegisteredLoaders\"])());\n  }\n\n  normalizeLoaders(candidateLoaders);\n  const loader = selectLoaderInternal(data, candidateLoaders, options, context);\n\n  if (!loader && !(options !== null && options !== void 0 && options.nothrow)) {\n    throw new Error(getNoValidLoaderMessage(data));\n  }\n\n  return loader;\n}\n\nfunction selectLoaderInternal(data, loaders, options, context) {\n  const {\n    url,\n    type\n  } = Object(_utils_resource_utils__WEBPACK_IMPORTED_MODULE_2__[\"getResourceUrlAndType\"])(data);\n  const testUrl = url || (context === null || context === void 0 ? void 0 : context.url);\n  let loader = null;\n\n  if (options !== null && options !== void 0 && options.mimeType) {\n    loader = findLoaderByMIMEType(loaders, options === null || options === void 0 ? void 0 : options.mimeType);\n  }\n\n  loader = loader || findLoaderByUrl(loaders, testUrl);\n  loader = loader || findLoaderByMIMEType(loaders, type);\n  loader = loader || findLoaderByInitialBytes(loaders, data);\n  loader = loader || findLoaderByMIMEType(loaders, options === null || options === void 0 ? void 0 : options.fallbackMimeType);\n  return loader;\n}\n\nfunction validHTTPResponse(data) {\n  if (data instanceof Response) {\n    if (data.status === 204) {\n      return false;\n    }\n  }\n\n  return true;\n}\n\nfunction getNoValidLoaderMessage(data) {\n  const {\n    url,\n    type\n  } = Object(_utils_resource_utils__WEBPACK_IMPORTED_MODULE_2__[\"getResourceUrlAndType\"])(data);\n  let message = 'No valid loader found';\n\n  if (data) {\n    message += ` data: \"${getFirstCharacters(data)}\", contentType: \"${type}\"`;\n  }\n\n  if (url) {\n    message += ` url: ${url}`;\n  }\n\n  return message;\n}\n\nfunction normalizeLoaders(loaders) {\n  for (const loader of loaders) {\n    Object(_loader_utils_normalize_loader__WEBPACK_IMPORTED_MODULE_1__[\"normalizeLoader\"])(loader);\n  }\n}\n\nfunction findLoaderByUrl(loaders, url) {\n  const match = url && EXT_PATTERN.exec(url);\n  const extension = match && match[1];\n  return extension ? findLoaderByExtension(loaders, extension) : null;\n}\n\nfunction findLoaderByExtension(loaders, extension) {\n  extension = extension.toLowerCase();\n\n  for (const loader of loaders) {\n    for (const loaderExtension of loader.extensions) {\n      if (loaderExtension.toLowerCase() === extension) {\n        return loader;\n      }\n    }\n  }\n\n  return null;\n}\n\nfunction findLoaderByMIMEType(loaders, mimeType) {\n  for (const loader of loaders) {\n    if (loader.mimeTypes && loader.mimeTypes.includes(mimeType)) {\n      return loader;\n    }\n\n    if (mimeType === `application/x.${loader.id}`) {\n      return loader;\n    }\n  }\n\n  return null;\n}\n\nfunction findLoaderByInitialBytes(loaders, data) {\n  if (!data) {\n    return null;\n  }\n\n  for (const loader of loaders) {\n    if (typeof data === 'string') {\n      if (testDataAgainstText(data, loader)) {\n        return loader;\n      }\n    } else if (ArrayBuffer.isView(data)) {\n      if (testDataAgainstBinary(data.buffer, data.byteOffset, loader)) {\n        return loader;\n      }\n    } else if (data instanceof ArrayBuffer) {\n      const byteOffset = 0;\n\n      if (testDataAgainstBinary(data, byteOffset, loader)) {\n        return loader;\n      }\n    }\n  }\n\n  return null;\n}\n\nfunction testDataAgainstText(data, loader) {\n  if (loader.testText) {\n    return loader.testText(data);\n  }\n\n  const tests = Array.isArray(loader.tests) ? loader.tests : [loader.tests];\n  return tests.some(test => data.startsWith(test));\n}\n\nfunction testDataAgainstBinary(data, byteOffset, loader) {\n  const tests = Array.isArray(loader.tests) ? loader.tests : [loader.tests];\n  return tests.some(test => testBinary(data, byteOffset, loader, test));\n}\n\nfunction testBinary(data, byteOffset, loader, test) {\n  if (test instanceof ArrayBuffer) {\n    return Object(_loaders_gl_loader_utils__WEBPACK_IMPORTED_MODULE_0__[\"compareArrayBuffers\"])(test, data, test.byteLength);\n  }\n\n  switch (typeof test) {\n    case 'function':\n      return test(data, loader);\n\n    case 'string':\n      const magic = getMagicString(data, byteOffset, test.length);\n      return test === magic;\n\n    default:\n      return false;\n  }\n}\n\nfunction getFirstCharacters(data, length = 5) {\n  if (typeof data === 'string') {\n    return data.slice(0, length);\n  } else if (ArrayBuffer.isView(data)) {\n    return getMagicString(data.buffer, data.byteOffset, length);\n  } else if (data instanceof ArrayBuffer) {\n    const byteOffset = 0;\n    return getMagicString(data, byteOffset, length);\n  }\n\n  return '';\n}\n\nfunction getMagicString(arrayBuffer, byteOffset, length) {\n  if (arrayBuffer.byteLength < byteOffset + length) {\n    return '';\n  }\n\n  const dataView = new DataView(arrayBuffer);\n  let magic = '';\n\n  for (let i = 0; i < length; i++) {\n    magic += String.fromCharCode(dataView.getUint8(byteOffset + i));\n  }\n\n  return magic;\n}\n//# sourceMappingURL=select-loader.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@loaders.gl/core/dist/esm/lib/api/select-loader.js\n");

/***/ }),

/***/ "./node_modules/@loaders.gl/core/dist/esm/lib/fetch/fetch-file.js":
/*!************************************************************************!*\
  !*** ./node_modules/@loaders.gl/core/dist/esm/lib/fetch/fetch-file.js ***!
  \************************************************************************/
/*! exports provided: fetchFile */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"fetchFile\", function() { return fetchFile; });\n/* harmony import */ var _loaders_gl_loader_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @loaders.gl/loader-utils */ \"./node_modules/@loaders.gl/loader-utils/dist/esm/lib/path-utils/file-aliases.js\");\n/* harmony import */ var _utils_response_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/response-utils */ \"./node_modules/@loaders.gl/core/dist/esm/lib/utils/response-utils.js\");\n\n\nasync function fetchFile(url, options) {\n  if (typeof url === 'string') {\n    url = Object(_loaders_gl_loader_utils__WEBPACK_IMPORTED_MODULE_0__[\"resolvePath\"])(url);\n    let fetchOptions = options;\n\n    if (options !== null && options !== void 0 && options.fetch && typeof (options === null || options === void 0 ? void 0 : options.fetch) !== 'function') {\n      fetchOptions = options.fetch;\n    }\n\n    return await fetch(url, fetchOptions);\n  }\n\n  return await Object(_utils_response_utils__WEBPACK_IMPORTED_MODULE_1__[\"makeResponse\"])(url);\n}\n//# sourceMappingURL=fetch-file.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGxvYWRlcnMuZ2wvY29yZS9kaXN0L2VzbS9saWIvZmV0Y2gvZmV0Y2gtZmlsZS5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9AbG9hZGVycy5nbC9jb3JlL2Rpc3QvZXNtL2xpYi9mZXRjaC9mZXRjaC1maWxlLmpzPzhiZTEiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgcmVzb2x2ZVBhdGggfSBmcm9tICdAbG9hZGVycy5nbC9sb2FkZXItdXRpbHMnO1xuaW1wb3J0IHsgbWFrZVJlc3BvbnNlIH0gZnJvbSAnLi4vdXRpbHMvcmVzcG9uc2UtdXRpbHMnO1xuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIGZldGNoRmlsZSh1cmwsIG9wdGlvbnMpIHtcbiAgaWYgKHR5cGVvZiB1cmwgPT09ICdzdHJpbmcnKSB7XG4gICAgdXJsID0gcmVzb2x2ZVBhdGgodXJsKTtcbiAgICBsZXQgZmV0Y2hPcHRpb25zID0gb3B0aW9ucztcblxuICAgIGlmIChvcHRpb25zICE9PSBudWxsICYmIG9wdGlvbnMgIT09IHZvaWQgMCAmJiBvcHRpb25zLmZldGNoICYmIHR5cGVvZiAob3B0aW9ucyA9PT0gbnVsbCB8fCBvcHRpb25zID09PSB2b2lkIDAgPyB2b2lkIDAgOiBvcHRpb25zLmZldGNoKSAhPT0gJ2Z1bmN0aW9uJykge1xuICAgICAgZmV0Y2hPcHRpb25zID0gb3B0aW9ucy5mZXRjaDtcbiAgICB9XG5cbiAgICByZXR1cm4gYXdhaXQgZmV0Y2godXJsLCBmZXRjaE9wdGlvbnMpO1xuICB9XG5cbiAgcmV0dXJuIGF3YWl0IG1ha2VSZXNwb25zZSh1cmwpO1xufVxuLy8jIHNvdXJjZU1hcHBpbmdVUkw9ZmV0Y2gtZmlsZS5qcy5tYXAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/@loaders.gl/core/dist/esm/lib/fetch/fetch-file.js\n");

/***/ }),

/***/ "./node_modules/@loaders.gl/core/dist/esm/lib/loader-utils/get-data.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@loaders.gl/core/dist/esm/lib/loader-utils/get-data.js ***!
  \*****************************************************************************/
/*! exports provided: getArrayBufferOrStringFromDataSync, getArrayBufferOrStringFromData, getAsyncIterableFromData, getReadableStream */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getArrayBufferOrStringFromDataSync\", function() { return getArrayBufferOrStringFromDataSync; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getArrayBufferOrStringFromData\", function() { return getArrayBufferOrStringFromData; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getAsyncIterableFromData\", function() { return getAsyncIterableFromData; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getReadableStream\", function() { return getReadableStream; });\n/* harmony import */ var _loaders_gl_loader_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @loaders.gl/loader-utils */ \"./node_modules/@loaders.gl/loader-utils/dist/esm/lib/iterators/async-iteration.js\");\n/* harmony import */ var _javascript_utils_is_type__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../javascript-utils/is-type */ \"./node_modules/@loaders.gl/core/dist/esm/javascript-utils/is-type.js\");\n/* harmony import */ var _iterators_make_iterator_make_iterator__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../iterators/make-iterator/make-iterator */ \"./node_modules/@loaders.gl/core/dist/esm/iterators/make-iterator/make-iterator.js\");\n/* harmony import */ var _utils_response_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/response-utils */ \"./node_modules/@loaders.gl/core/dist/esm/lib/utils/response-utils.js\");\n\n\n\n\nconst ERR_DATA = 'Cannot convert supplied data type';\nfunction getArrayBufferOrStringFromDataSync(data, loader, options) {\n  if (loader.text && typeof data === 'string') {\n    return data;\n  }\n\n  if (Object(_javascript_utils_is_type__WEBPACK_IMPORTED_MODULE_1__[\"isBuffer\"])(data)) {\n    data = data.buffer;\n  }\n\n  if (data instanceof ArrayBuffer) {\n    const arrayBuffer = data;\n\n    if (loader.text && !loader.binary) {\n      const textDecoder = new TextDecoder('utf8');\n      return textDecoder.decode(arrayBuffer);\n    }\n\n    return arrayBuffer;\n  }\n\n  if (ArrayBuffer.isView(data)) {\n    if (loader.text && 