# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['FunctionArgs', 'Function']

@pulumi.input_type
class FunctionArgs:
    def __init__(__self__, *,
                 handler: pulumi.Input[str],
                 namespace_id: pulumi.Input[str],
                 privacy: pulumi.Input[str],
                 runtime: pulumi.Input[str],
                 deploy: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_scale: Optional[pulumi.Input[int]] = None,
                 memory_limit: Optional[pulumi.Input[int]] = None,
                 min_scale: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[str]] = None,
                 zip_file: Optional[pulumi.Input[str]] = None,
                 zip_hash: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Function resource.
        :param pulumi.Input[str] handler: Handler of the function. Depends on the runtime ([function guide](https://developers.scaleway.com/en/products/functions/api/#create-a-function))
        :param pulumi.Input[str] namespace_id: The namespace ID associated with this function
        :param pulumi.Input[str] privacy: Privacy of the function. Can be either `private` or `public`. Read more on [authentication](https://developers.scaleway.com/en/products/functions/api/#authentication)
        :param pulumi.Input[str] runtime: Runtime of the function. Runtimes can be fetched using [specific route](https://developers.scaleway.com/en/products/functions/api/#get-f7de6a)
        :param pulumi.Input[bool] deploy: Define if the function should be deployed, terraform will wait for function to be deployed
        :param pulumi.Input[str] description: The description of the function.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: The environment variables of the function.
        :param pulumi.Input[int] max_scale: Maximum replicas for your function (defaults to 20), our system will scale your functions automatically based on incoming workload, but will never scale the number of replicas above the configured max_scale.
        :param pulumi.Input[int] memory_limit: Memory limit in MB for your function, defaults to 128MB
        :param pulumi.Input[int] min_scale: Minimum replicas for your function, defaults to 0, Note that a function is billed when it gets executed, and using a min_scale greater than 0 will cause your function container to run constantly.
        :param pulumi.Input[str] name: The unique name of the function.
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the namespace is associated with.
        :param pulumi.Input[str] region: `region`). The region in which the namespace should be created.
        :param pulumi.Input[str] timeout: Holds the max duration (in seconds) the function is allowed for responding to a request
        :param pulumi.Input[str] zip_file: Location of the zip file to upload containing your function sources
        :param pulumi.Input[str] zip_hash: The hash of your source zip file, changing it will re-apply function. Can be any string
        """
        pulumi.set(__self__, "handler", handler)
        pulumi.set(__self__, "namespace_id", namespace_id)
        pulumi.set(__self__, "privacy", privacy)
        pulumi.set(__self__, "runtime", runtime)
        if deploy is not None:
            pulumi.set(__self__, "deploy", deploy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if max_scale is not None:
            pulumi.set(__self__, "max_scale", max_scale)
        if memory_limit is not None:
            pulumi.set(__self__, "memory_limit", memory_limit)
        if min_scale is not None:
            pulumi.set(__self__, "min_scale", min_scale)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if zip_file is not None:
            pulumi.set(__self__, "zip_file", zip_file)
        if zip_hash is not None:
            pulumi.set(__self__, "zip_hash", zip_hash)

    @property
    @pulumi.getter
    def handler(self) -> pulumi.Input[str]:
        """
        Handler of the function. Depends on the runtime ([function guide](https://developers.scaleway.com/en/products/functions/api/#create-a-function))
        """
        return pulumi.get(self, "handler")

    @handler.setter
    def handler(self, value: pulumi.Input[str]):
        pulumi.set(self, "handler", value)

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> pulumi.Input[str]:
        """
        The namespace ID associated with this function
        """
        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace_id", value)

    @property
    @pulumi.getter
    def privacy(self) -> pulumi.Input[str]:
        """
        Privacy of the function. Can be either `private` or `public`. Read more on [authentication](https://developers.scaleway.com/en/products/functions/api/#authentication)
        """
        return pulumi.get(self, "privacy")

    @privacy.setter
    def privacy(self, value: pulumi.Input[str]):
        pulumi.set(self, "privacy", value)

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Input[str]:
        """
        Runtime of the function. Runtimes can be fetched using [specific route](https://developers.scaleway.com/en/products/functions/api/#get-f7de6a)
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: pulumi.Input[str]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter
    def deploy(self) -> Optional[pulumi.Input[bool]]:
        """
        Define if the function should be deployed, terraform will wait for function to be deployed
        """
        return pulumi.get(self, "deploy")

    @deploy.setter
    def deploy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deploy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the function.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The environment variables of the function.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="maxScale")
    def max_scale(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum replicas for your function (defaults to 20), our system will scale your functions automatically based on incoming workload, but will never scale the number of replicas above the configured max_scale.
        """
        return pulumi.get(self, "max_scale")

    @max_scale.setter
    def max_scale(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_scale", value)

    @property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Memory limit in MB for your function, defaults to 128MB
        """
        return pulumi.get(self, "memory_limit")

    @memory_limit.setter
    def memory_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_limit", value)

    @property
    @pulumi.getter(name="minScale")
    def min_scale(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum replicas for your function, defaults to 0, Note that a function is billed when it gets executed, and using a min_scale greater than 0 will cause your function container to run constantly.
        """
        return pulumi.get(self, "min_scale")

    @min_scale.setter
    def min_scale(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_scale", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique name of the function.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        `project_id`) The ID of the project the namespace is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        `region`). The region in which the namespace should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Holds the max duration (in seconds) the function is allowed for responding to a request
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="zipFile")
    def zip_file(self) -> Optional[pulumi.Input[str]]:
        """
        Location of the zip file to upload containing your function sources
        """
        return pulumi.get(self, "zip_file")

    @zip_file.setter
    def zip_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zip_file", value)

    @property
    @pulumi.getter(name="zipHash")
    def zip_hash(self) -> Optional[pulumi.Input[str]]:
        """
        The hash of your source zip file, changing it will re-apply function. Can be any string
        """
        return pulumi.get(self, "zip_hash")

    @zip_hash.setter
    def zip_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zip_hash", value)


@pulumi.input_type
class _FunctionState:
    def __init__(__self__, *,
                 cpu_limit: Optional[pulumi.Input[int]] = None,
                 deploy: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 handler: Optional[pulumi.Input[str]] = None,
                 max_scale: Optional[pulumi.Input[int]] = None,
                 memory_limit: Optional[pulumi.Input[int]] = None,
                 min_scale: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace_id: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 privacy: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[str]] = None,
                 zip_file: Optional[pulumi.Input[str]] = None,
                 zip_hash: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Function resources.
        :param pulumi.Input[int] cpu_limit: The CPU limit in mCPU for your function. More infos on resources [here](https://developers.scaleway.com/en/products/functions/api/#functions)
        :param pulumi.Input[bool] deploy: Define if the function should be deployed, terraform will wait for function to be deployed
        :param pulumi.Input[str] description: The description of the function.
        :param pulumi.Input[str] domain_name: The native domain name of the function
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: The environment variables of the function.
        :param pulumi.Input[str] handler: Handler of the function. Depends on the runtime ([function guide](https://developers.scaleway.com/en/products/functions/api/#create-a-function))
        :param pulumi.Input[int] max_scale: Maximum replicas for your function (defaults to 20), our system will scale your functions automatically based on incoming workload, but will never scale the number of replicas above the configured max_scale.
        :param pulumi.Input[int] memory_limit: Memory limit in MB for your function, defaults to 128MB
        :param pulumi.Input[int] min_scale: Minimum replicas for your function, defaults to 0, Note that a function is billed when it gets executed, and using a min_scale greater than 0 will cause your function container to run constantly.
        :param pulumi.Input[str] name: The unique name of the function.
        :param pulumi.Input[str] namespace_id: The namespace ID associated with this function
        :param pulumi.Input[str] organization_id: The organization ID the function is associated with.
        :param pulumi.Input[str] privacy: Privacy of the function. Can be either `private` or `public`. Read more on [authentication](https://developers.scaleway.com/en/products/functions/api/#authentication)
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the namespace is associated with.
        :param pulumi.Input[str] region: `region`). The region in which the namespace should be created.
        :param pulumi.Input[str] runtime: Runtime of the function. Runtimes can be fetched using [specific route](https://developers.scaleway.com/en/products/functions/api/#get-f7de6a)
        :param pulumi.Input[str] timeout: Holds the max duration (in seconds) the function is allowed for responding to a request
        :param pulumi.Input[str] zip_file: Location of the zip file to upload containing your function sources
        :param pulumi.Input[str] zip_hash: The hash of your source zip file, changing it will re-apply function. Can be any string
        """
        if cpu_limit is not None:
            pulumi.set(__self__, "cpu_limit", cpu_limit)
        if deploy is not None:
            pulumi.set(__self__, "deploy", deploy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if handler is not None:
            pulumi.set(__self__, "handler", handler)
        if max_scale is not None:
            pulumi.set(__self__, "max_scale", max_scale)
        if memory_limit is not None:
            pulumi.set(__self__, "memory_limit", memory_limit)
        if min_scale is not None:
            pulumi.set(__self__, "min_scale", min_scale)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace_id is not None:
            pulumi.set(__self__, "namespace_id", namespace_id)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if privacy is not None:
            pulumi.set(__self__, "privacy", privacy)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if zip_file is not None:
            pulumi.set(__self__, "zip_file", zip_file)
        if zip_hash is not None:
            pulumi.set(__self__, "zip_hash", zip_hash)

    @property
    @pulumi.getter(name="cpuLimit")
    def cpu_limit(self) -> Optional[pulumi.Input[int]]:
        """
        The CPU limit in mCPU for your function. More infos on resources [here](https://developers.scaleway.com/en/products/functions/api/#functions)
        """
        return pulumi.get(self, "cpu_limit")

    @cpu_limit.setter
    def cpu_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_limit", value)

    @property
    @pulumi.getter
    def deploy(self) -> Optional[pulumi.Input[bool]]:
        """
        Define if the function should be deployed, terraform will wait for function to be deployed
        """
        return pulumi.get(self, "deploy")

    @deploy.setter
    def deploy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deploy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the function.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The native domain name of the function
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The environment variables of the function.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter
    def handler(self) -> Optional[pulumi.Input[str]]:
        """
        Handler of the function. Depends on the runtime ([function guide](https://developers.scaleway.com/en/products/functions/api/#create-a-function))
        """
        return pulumi.get(self, "handler")

    @handler.setter
    def handler(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "handler", value)

    @property
    @pulumi.getter(name="maxScale")
    def max_scale(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum replicas for your function (defaults to 20), our system will scale your functions automatically based on incoming workload, but will never scale the number of replicas above the configured max_scale.
        """
        return pulumi.get(self, "max_scale")

    @max_scale.setter
    def max_scale(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_scale", value)

    @property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Memory limit in MB for your function, defaults to 128MB
        """
        return pulumi.get(self, "memory_limit")

    @memory_limit.setter
    def memory_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_limit", value)

    @property
    @pulumi.getter(name="minScale")
    def min_scale(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum replicas for your function, defaults to 0, Note that a function is billed when it gets executed, and using a min_scale greater than 0 will cause your function container to run constantly.
        """
        return pulumi.get(self, "min_scale")

    @min_scale.setter
    def min_scale(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_scale", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique name of the function.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace ID associated with this function
        """
        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace_id", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[str]]:
        """
        The organization ID the function is associated with.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter
    def privacy(self) -> Optional[pulumi.Input[str]]:
        """
        Privacy of the function. Can be either `private` or `public`. Read more on [authentication](https://developers.scaleway.com/en/products/functions/api/#authentication)
        """
        return pulumi.get(self, "privacy")

    @privacy.setter
    def privacy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "privacy", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        `project_id`) The ID of the project the namespace is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        `region`). The region in which the namespace should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[str]]:
        """
        Runtime of the function. Runtimes can be fetched using [specific route](https://developers.scaleway.com/en/products/functions/api/#get-f7de6a)
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Holds the max duration (in seconds) the function is allowed for responding to a request
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="zipFile")
    def zip_file(self) -> Optional[pulumi.Input[str]]:
        """
        Location of the zip file to upload containing your function sources
        """
        return pulumi.get(self, "zip_file")

    @zip_file.setter
    def zip_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zip_file", value)

    @property
    @pulumi.getter(name="zipHash")
    def zip_hash(self) -> Optional[pulumi.Input[str]]:
        """
        The hash of your source zip file, changing it will re-apply function. Can be any string
        """
        return pulumi.get(self, "zip_hash")

    @zip_hash.setter
    def zip_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zip_hash", value)


class Function(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deploy: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 handler: Optional[pulumi.Input[str]] = None,
                 max_scale: Optional[pulumi.Input[int]] = None,
                 memory_limit: Optional[pulumi.Input[int]] = None,
                 min_scale: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace_id: Optional[pulumi.Input[str]] = None,
                 privacy: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[str]] = None,
                 zip_file: Optional[pulumi.Input[str]] = None,
                 zip_hash: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Functions.
        For more information see [the documentation](https://developers.scaleway.com/en/products/functions/api/).

        ## Examples

        ### Basic

        ```python
        import pulumi
        import lbrlabs_scaleway as scaleway

        main_function_namespace = scaleway.FunctionNamespace("mainFunctionNamespace", description="Main function namespace")
        main_function = scaleway.Function("mainFunction",
            namespace_id=main_function_namespace.id,
            runtime="go118",
            handler="Handle",
            privacy="private")
        ```

        ## Import

        Functions can be imported using the `{region}/{id}`, e.g. bash

        ```sh
         $ pulumi import scaleway:index/function:Function main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] deploy: Define if the function should be deployed, terraform will wait for function to be deployed
        :param pulumi.Input[str] description: The description of the function.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: The environment variables of the function.
        :param pulumi.Input[str] handler: Handler of the function. Depends on the runtime ([function guide](https://developers.scaleway.com/en/products/functions/api/#create-a-function))
        :param pulumi.Input[int] max_scale: Maximum replicas for your function (defaults to 20), our system will scale your functions automatically based on incoming workload, but will never scale the number of replicas above the configured max_scale.
        :param pulumi.Input[int] memory_limit: Memory limit in MB for your function, defaults to 128MB
        :param pulumi.Input[int] min_scale: Minimum replicas for your function, defaults to 0, Note that a function is billed when it gets executed, and using a min_scale greater than 0 will cause your function container to run constantly.
        :param pulumi.Input[str] name: The unique name of the function.
        :param pulumi.Input[str] namespace_id: The namespace ID associated with this function
        :param pulumi.Input[str] privacy: Privacy of the function. Can be either `private` or `public`. Read more on [authentication](https://developers.scaleway.com/en/products/functions/api/#authentication)
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the namespace is associated with.
        :param pulumi.Input[str] region: `region`). The region in which the namespace should be created.
        :param pulumi.Input[str] runtime: Runtime of the function. Runtimes can be fetched using [specific route](https://developers.scaleway.com/en/products/functions/api/#get-f7de6a)
        :param pulumi.Input[str] timeout: Holds the max duration (in seconds) the function is allowed for responding to a request
        :param pulumi.Input[str] zip_file: Location of the zip file to upload containing your function sources
        :param pulumi.Input[str] zip_hash: The hash of your source zip file, changing it will re-apply function. Can be any string
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FunctionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Functions.
        For more information see [the documentation](https://developers.scaleway.com/en/products/functions/api/).

        ## Examples

        ### Basic

        ```python
        import pulumi
        import lbrlabs_scaleway as scaleway

        main_function_namespace = scaleway.FunctionNamespace("mainFunctionNamespace", description="Main function namespace")
        main_function = scaleway.Function("mainFunction",
            namespace_id=main_function_namespace.id,
            runtime="go118",
            handler="Handle",
            privacy="private")
        ```

        ## Import

        Functions can be imported using the `{region}/{id}`, e.g. bash

        ```sh
         $ pulumi import scaleway:index/function:Function main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param FunctionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FunctionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deploy: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 handler: Optional[pulumi.Input[str]] = None,
                 max_scale: Optional[pulumi.Input[int]] = None,
                 memory_limit: Optional[pulumi.Input[int]] = None,
                 min_scale: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace_id: Optional[pulumi.Input[str]] = None,
                 privacy: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[str]] = None,
                 zip_file: Optional[pulumi.Input[str]] = None,
                 zip_hash: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FunctionArgs.__new__(FunctionArgs)

            __props__.__dict__["deploy"] = deploy
            __props__.__dict__["description"] = description
            __props__.__dict__["environment_variables"] = environment_variables
            if handler is None and not opts.urn:
                raise TypeError("Missing required property 'handler'")
            __props__.__dict__["handler"] = handler
            __props__.__dict__["max_scale"] = max_scale
            __props__.__dict__["memory_limit"] = memory_limit
            __props__.__dict__["min_scale"] = min_scale
            __props__.__dict__["name"] = name
            if namespace_id is None and not opts.urn:
                raise TypeError("Missing required property 'namespace_id'")
            __props__.__dict__["namespace_id"] = namespace_id
            if privacy is None and not opts.urn:
                raise TypeError("Missing required property 'privacy'")
            __props__.__dict__["privacy"] = privacy
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            if runtime is None and not opts.urn:
                raise TypeError("Missing required property 'runtime'")
            __props__.__dict__["runtime"] = runtime
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["zip_file"] = zip_file
            __props__.__dict__["zip_hash"] = zip_hash
            __props__.__dict__["cpu_limit"] = None
            __props__.__dict__["domain_name"] = None
            __props__.__dict__["organization_id"] = None
        super(Function, __self__).__init__(
            'scaleway:index/function:Function',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cpu_limit: Optional[pulumi.Input[int]] = None,
            deploy: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            domain_name: Optional[pulumi.Input[str]] = None,
            environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            handler: Optional[pulumi.Input[str]] = None,
            max_scale: Optional[pulumi.Input[int]] = None,
            memory_limit: Optional[pulumi.Input[int]] = None,
            min_scale: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            namespace_id: Optional[pulumi.Input[str]] = None,
            organization_id: Optional[pulumi.Input[str]] = None,
            privacy: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            runtime: Optional[pulumi.Input[str]] = None,
            timeout: Optional[pulumi.Input[str]] = None,
            zip_file: Optional[pulumi.Input[str]] = None,
            zip_hash: Optional[pulumi.Input[str]] = None) -> 'Function':
        """
        Get an existing Function resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] cpu_limit: The CPU limit in mCPU for your function. More infos on resources [here](https://developers.scaleway.com/en/products/functions/api/#functions)
        :param pulumi.Input[bool] deploy: Define if the function should be deployed, terraform will wait for function to be deployed
        :param pulumi.Input[str] description: The description of the function.
        :param pulumi.Input[str] domain_name: The native domain name of the function
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: The environment variables of the function.
        :param pulumi.Input[str] handler: Handler of the function. Depends on the runtime ([function guide](https://developers.scaleway.com/en/products/functions/api/#create-a-function))
        :param pulumi.Input[int] max_scale: Maximum replicas for your function (defaults to 20), our system will scale your functions automatically based on incoming workload, but will never scale the number of replicas above the configured max_scale.
        :param pulumi.Input[int] memory_limit: Memory limit in MB for your function, defaults to 128MB
        :param pulumi.Input[int] min_scale: Minimum replicas for your function, defaults to 0, Note that a function is billed when it gets executed, and using a min_scale greater than 0 will cause your function container to run constantly.
        :param pulumi.Input[str] name: The unique name of the function.
        :param pulumi.Input[str] namespace_id: The namespace ID associated with this function
        :param pulumi.Input[str] organization_id: The organization ID the function is associated with.
        :param pulumi.Input[str] privacy: Privacy of the function. Can be either `private` or `public`. Read more on [authentication](https://developers.scaleway.com/en/products/functions/api/#authentication)
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the namespace is associated with.
        :param pulumi.Input[str] region: `region`). The region in which the namespace should be created.
        :param pulumi.Input[str] runtime: Runtime of the function. Runtimes can be fetched using [specific route](https://developers.scaleway.com/en/products/functions/api/#get-f7de6a)
        :param pulumi.Input[str] timeout: Holds the max duration (in seconds) the function is allowed for responding to a request
        :param pulumi.Input[str] zip_file: Location of the zip file to upload containing your function sources
        :param pulumi.Input[str] zip_hash: The hash of your source zip file, changing it will re-apply function. Can be any string
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FunctionState.__new__(_FunctionState)

        __props__.__dict__["cpu_limit"] = cpu_limit
        __props__.__dict__["deploy"] = deploy
        __props__.__dict__["description"] = description
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["environment_variables"] = environment_variables
        __props__.__dict__["handler"] = handler
        __props__.__dict__["max_scale"] = max_scale
        __props__.__dict__["memory_limit"] = memory_limit
        __props__.__dict__["min_scale"] = min_scale
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace_id"] = namespace_id
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["privacy"] = privacy
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["zip_file"] = zip_file
        __props__.__dict__["zip_hash"] = zip_hash
        return Function(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cpuLimit")
    def cpu_limit(self) -> pulumi.Output[int]:
        """
        The CPU limit in mCPU for your function. More infos on resources [here](https://developers.scaleway.com/en/products/functions/api/#functions)
        """
        return pulumi.get(self, "cpu_limit")

    @property
    @pulumi.getter
    def deploy(self) -> pulumi.Output[Optional[bool]]:
        """
        Define if the function should be deployed, terraform will wait for function to be deployed
        """
        return pulumi.get(self, "deploy")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the function.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        """
        The native domain name of the function
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The environment variables of the function.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter
    def handler(self) -> pulumi.Output[str]:
        """
        Handler of the function. Depends on the runtime ([function guide](https://developers.scaleway.com/en/products/functions/api/#create-a-function))
        """
        return pulumi.get(self, "handler")

    @property
    @pulumi.getter(name="maxScale")
    def max_scale(self) -> pulumi.Output[Optional[int]]:
        """
        Maximum replicas for your function (defaults to 20), our system will scale your functions automatically based on incoming workload, but will never scale the number of replicas above the configured max_scale.
        """
        return pulumi.get(self, "max_scale")

    @property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> pulumi.Output[Optional[int]]:
        """
        Memory limit in MB for your function, defaults to 128MB
        """
        return pulumi.get(self, "memory_limit")

    @property
    @pulumi.getter(name="minScale")
    def min_scale(self) -> pulumi.Output[Optional[int]]:
        """
        Minimum replicas for your function, defaults to 0, Note that a function is billed when it gets executed, and using a min_scale greater than 0 will cause your function container to run constantly.
        """
        return pulumi.get(self, "min_scale")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The unique name of the function.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> pulumi.Output[str]:
        """
        The namespace ID associated with this function
        """
        return pulumi.get(self, "namespace_id")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[str]:
        """
        The organization ID the function is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter
    def privacy(self) -> pulumi.Output[str]:
        """
        Privacy of the function. Can be either `private` or `public`. Read more on [authentication](https://developers.scaleway.com/en/products/functions/api/#authentication)
        """
        return pulumi.get(self, "privacy")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        `project_id`) The ID of the project the namespace is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        `region`). The region in which the namespace should be created.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[str]:
        """
        Runtime of the function. Runtimes can be fetched using [specific route](https://developers.scaleway.com/en/products/functions/api/#get-f7de6a)
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[str]:
        """
        Holds the max duration (in seconds) the function is allowed for responding to a request
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="zipFile")
    def zip_file(self) -> pulumi.Output[Optional[str]]:
        """
        Location of the zip file to upload containing your function sources
        """
        return pulumi.get(self, "zip_file")

    @property
    @pulumi.getter(name="zipHash")
    def zip_hash(self) -> pulumi.Output[Optional[str]]:
        """
        The hash of your source zip file, changing it will re-apply function. Can be any string
        """
        return pulumi.get(self, "zip_hash")

