# -*- coding: utf-8 -*-
# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from google.cloud.compute import gapic_version as package_version

__version__ = package_version.__version__


from google.cloud.compute_v1.services.accelerator_types.client import (
    AcceleratorTypesClient,
)
from google.cloud.compute_v1.services.addresses.client import AddressesClient
from google.cloud.compute_v1.services.autoscalers.client import AutoscalersClient
from google.cloud.compute_v1.services.backend_buckets.client import BackendBucketsClient
from google.cloud.compute_v1.services.backend_services.client import (
    BackendServicesClient,
)
from google.cloud.compute_v1.services.disk_types.client import DiskTypesClient
from google.cloud.compute_v1.services.disks.client import DisksClient
from google.cloud.compute_v1.services.external_vpn_gateways.client import (
    ExternalVpnGatewaysClient,
)
from google.cloud.compute_v1.services.firewall_policies.client import (
    FirewallPoliciesClient,
)
from google.cloud.compute_v1.services.firewalls.client import FirewallsClient
from google.cloud.compute_v1.services.forwarding_rules.client import (
    ForwardingRulesClient,
)
from google.cloud.compute_v1.services.global_addresses.client import (
    GlobalAddressesClient,
)
from google.cloud.compute_v1.services.global_forwarding_rules.client import (
    GlobalForwardingRulesClient,
)
from google.cloud.compute_v1.services.global_network_endpoint_groups.client import (
    GlobalNetworkEndpointGroupsClient,
)
from google.cloud.compute_v1.services.global_operations.client import (
    GlobalOperationsClient,
)
from google.cloud.compute_v1.services.global_organization_operations.client import (
    GlobalOrganizationOperationsClient,
)
from google.cloud.compute_v1.services.global_public_delegated_prefixes.client import (
    GlobalPublicDelegatedPrefixesClient,
)
from google.cloud.compute_v1.services.health_checks.client import HealthChecksClient
from google.cloud.compute_v1.services.image_family_views.client import (
    ImageFamilyViewsClient,
)
from google.cloud.compute_v1.services.images.client import ImagesClient
from google.cloud.compute_v1.services.instance_group_managers.client import (
    InstanceGroupManagersClient,
)
from google.cloud.compute_v1.services.instance_groups.client import InstanceGroupsClient
from google.cloud.compute_v1.services.instance_templates.client import (
    InstanceTemplatesClient,
)
from google.cloud.compute_v1.services.instances.client import InstancesClient
from google.cloud.compute_v1.services.interconnect_attachments.client import (
    InterconnectAttachmentsClient,
)
from google.cloud.compute_v1.services.interconnect_locations.client import (
    InterconnectLocationsClient,
)
from google.cloud.compute_v1.services.interconnects.client import InterconnectsClient
from google.cloud.compute_v1.services.license_codes.client import LicenseCodesClient
from google.cloud.compute_v1.services.licenses.client import LicensesClient
from google.cloud.compute_v1.services.machine_images.client import MachineImagesClient
from google.cloud.compute_v1.services.machine_types.client import MachineTypesClient
from google.cloud.compute_v1.services.network_attachments.client import (
    NetworkAttachmentsClient,
)
from google.cloud.compute_v1.services.network_edge_security_services.client import (
    NetworkEdgeSecurityServicesClient,
)
from google.cloud.compute_v1.services.network_endpoint_groups.client import (
    NetworkEndpointGroupsClient,
)
from google.cloud.compute_v1.services.network_firewall_policies.client import (
    NetworkFirewallPoliciesClient,
)
from google.cloud.compute_v1.services.networks.client import NetworksClient
from google.cloud.compute_v1.services.node_groups.client import NodeGroupsClient
from google.cloud.compute_v1.services.node_templates.client import NodeTemplatesClient
from google.cloud.compute_v1.services.node_types.client import NodeTypesClient
from google.cloud.compute_v1.services.packet_mirrorings.client import (
    PacketMirroringsClient,
)
from google.cloud.compute_v1.services.projects.client import ProjectsClient
from google.cloud.compute_v1.services.public_advertised_prefixes.client import (
    PublicAdvertisedPrefixesClient,
)
from google.cloud.compute_v1.services.public_delegated_prefixes.client import (
    PublicDelegatedPrefixesClient,
)
from google.cloud.compute_v1.services.region_autoscalers.client import (
    RegionAutoscalersClient,
)
from google.cloud.compute_v1.services.region_backend_services.client import (
    RegionBackendServicesClient,
)
from google.cloud.compute_v1.services.region_commitments.client import (
    RegionCommitmentsClient,
)
from google.cloud.compute_v1.services.region_disk_types.client import (
    RegionDiskTypesClient,
)
from google.cloud.compute_v1.services.region_disks.client import RegionDisksClient
from google.cloud.compute_v1.services.region_health_check_services.client import (
    RegionHealthCheckServicesClient,
)
from google.cloud.compute_v1.services.region_health_checks.client import (
    RegionHealthChecksClient,
)
from google.cloud.compute_v1.services.region_instance_group_managers.client import (
    RegionInstanceGroupManagersClient,
)
from google.cloud.compute_v1.services.region_instance_groups.client import (
    RegionInstanceGroupsClient,
)
from google.cloud.compute_v1.services.region_instances.client import (
    RegionInstancesClient,
)
from google.cloud.compute_v1.services.region_network_endpoint_groups.client import (
    RegionNetworkEndpointGroupsClient,
)
from google.cloud.compute_v1.services.region_network_firewall_policies.client import (
    RegionNetworkFirewallPoliciesClient,
)
from google.cloud.compute_v1.services.region_notification_endpoints.client import (
    RegionNotificationEndpointsClient,
)
from google.cloud.compute_v1.services.region_operations.client import (
    RegionOperationsClient,
)
from google.cloud.compute_v1.services.region_security_policies.client import (
    RegionSecurityPoliciesClient,
)
from google.cloud.compute_v1.services.region_ssl_certificates.client import (
    RegionSslCertificatesClient,
)
from google.cloud.compute_v1.services.region_ssl_policies.client import (
    RegionSslPoliciesClient,
)
from google.cloud.compute_v1.services.region_target_http_proxies.client import (
    RegionTargetHttpProxiesClient,
)
from google.cloud.compute_v1.services.region_target_https_proxies.client import (
    RegionTargetHttpsProxiesClient,
)
from google.cloud.compute_v1.services.region_target_tcp_proxies.client import (
    RegionTargetTcpProxiesClient,
)
from google.cloud.compute_v1.services.region_url_maps.client import RegionUrlMapsClient
from google.cloud.compute_v1.services.regions.client import RegionsClient
from google.cloud.compute_v1.services.reservations.client import ReservationsClient
from google.cloud.compute_v1.services.resource_policies.client import (
    ResourcePoliciesClient,
)
from google.cloud.compute_v1.services.routers.client import RoutersClient
from google.cloud.compute_v1.services.routes.client import RoutesClient
from google.cloud.compute_v1.services.security_policies.client import (
    SecurityPoliciesClient,
)
from google.cloud.compute_v1.services.service_attachments.client import (
    ServiceAttachmentsClient,
)
from google.cloud.compute_v1.services.snapshots.client import SnapshotsClient
from google.cloud.compute_v1.services.ssl_certificates.client import (
    SslCertificatesClient,
)
from google.cloud.compute_v1.services.ssl_policies.client import SslPoliciesClient
from google.cloud.compute_v1.services.subnetworks.client import SubnetworksClient
from google.cloud.compute_v1.services.target_grpc_proxies.client import (
    TargetGrpcProxiesClient,
)
from google.cloud.compute_v1.services.target_http_proxies.client import (
    TargetHttpProxiesClient,
)
from google.cloud.compute_v1.services.target_https_proxies.client import (
    TargetHttpsProxiesClient,
)
from google.cloud.compute_v1.services.target_instances.client import (
    TargetInstancesClient,
)
from google.cloud.compute_v1.services.target_pools.client import TargetPoolsClient
from google.cloud.compute_v1.services.target_ssl_proxies.client import (
    TargetSslProxiesClient,
)
from google.cloud.compute_v1.services.target_tcp_proxies.client import (
    TargetTcpProxiesClient,
)
from google.cloud.compute_v1.services.target_vpn_gateways.client import (
    TargetVpnGatewaysClient,
)
from google.cloud.compute_v1.services.url_maps.client import UrlMapsClient
from google.cloud.compute_v1.services.vpn_gateways.client import VpnGatewaysClient
from google.cloud.compute_v1.services.vpn_tunnels.client import VpnTunnelsClient
from google.cloud.compute_v1.services.zone_operations.client import ZoneOperationsClient
from google.cloud.compute_v1.services.zones.client import ZonesClient
from google.cloud.compute_v1.types.compute import (
    AbandonInstancesInstanceGroupManagerRequest,
    AbandonInstancesRegionInstanceGroupManagerRequest,
    AcceleratorConfig,
    Accelerators,
    AcceleratorType,
    AcceleratorTypeAggregatedList,
    AcceleratorTypeList,
    AcceleratorTypesScopedList,
    AccessConfig,
    AddAccessConfigInstanceRequest,
    AddAssociationFirewallPolicyRequest,
    AddAssociationNetworkFirewallPolicyRequest,
    AddAssociationRegionNetworkFirewallPolicyRequest,
    AddHealthCheckTargetPoolRequest,
    AddInstancesInstanceGroupRequest,
    AddInstanceTargetPoolRequest,
    AddNodesNodeGroupRequest,
    AddPeeringNetworkRequest,
    AddResourcePoliciesDiskRequest,
    AddResourcePoliciesInstanceRequest,
    AddResourcePoliciesRegionDiskRequest,
    Address,
    AddressAggregatedList,
    AddressesScopedList,
    AddressList,
    AddRuleFirewallPolicyRequest,
    AddRuleNetworkFirewallPolicyRequest,
    AddRuleRegionNetworkFirewallPolicyRequest,
    AddRuleSecurityPolicyRequest,
    AddSignedUrlKeyBackendBucketRequest,
    AddSignedUrlKeyBackendServiceRequest,
    AdvancedMachineFeatures,
    AggregatedListAcceleratorTypesRequest,
    AggregatedListAddressesRequest,
    AggregatedListAutoscalersRequest,
    AggregatedListBackendServicesRequest,
    AggregatedListDisksRequest,
    AggregatedListDiskTypesRequest,
    AggregatedListForwardingRulesRequest,
    AggregatedListGlobalOperationsRequest,
    AggregatedListHealthChecksRequest,
    AggregatedListInstanceGroupManagersRequest,
    AggregatedListInstanceGroupsRequest,
    AggregatedListInstancesRequest,
    AggregatedListInterconnectAttachmentsRequest,
    AggregatedListMachineTypesRequest,
    AggregatedListNetworkAttachmentsRequest,
    AggregatedListNetworkEdgeSecurityServicesRequest,
    AggregatedListNetworkEndpointGroupsRequest,
    AggregatedListNodeGroupsRequest,
    AggregatedListNodeTemplatesRequest,
    AggregatedListNodeTypesRequest,
    AggregatedListPacketMirroringsRequest,
    AggregatedListPublicDelegatedPrefixesRequest,
    AggregatedListRegionCommitmentsRequest,
    AggregatedListReservationsRequest,
    AggregatedListResourcePoliciesRequest,
    AggregatedListRoutersRequest,
    AggregatedListSecurityPoliciesRequest,
    AggregatedListServiceAttachmentsRequest,
    AggregatedListSslCertificatesRequest,
    AggregatedListSslPoliciesRequest,
    AggregatedListSubnetworksRequest,
    AggregatedListTargetHttpProxiesRequest,
    AggregatedListTargetHttpsProxiesRequest,
    AggregatedListTargetInstancesRequest,
    AggregatedListTargetPoolsRequest,
    AggregatedListTargetTcpProxiesRequest,
    AggregatedListTargetVpnGatewaysRequest,
    AggregatedListUrlMapsRequest,
    AggregatedListVpnGatewaysRequest,
    AggregatedListVpnTunnelsRequest,
    AliasIpRange,
    AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk,
    AllocationSpecificSKUAllocationReservedInstanceProperties,
    AllocationSpecificSKUReservation,
    Allowed,
    ApplyUpdatesToInstancesInstanceGroupManagerRequest,
    ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest,
    AttachDiskInstanceRequest,
    AttachedDisk,
    AttachedDiskInitializeParams,
    AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest,
    AttachNetworkEndpointsNetworkEndpointGroupRequest,
    AuditConfig,
    AuditLogConfig,
    AuthorizationLoggingOptions,
    Autoscaler,
    AutoscalerAggregatedList,
    AutoscalerList,
    AutoscalersScopedList,
    AutoscalerStatusDetails,
    AutoscalingPolicy,
    AutoscalingPolicyCpuUtilization,
    AutoscalingPolicyCustomMetricUtilization,
    AutoscalingPolicyLoadBalancingUtilization,
    AutoscalingPolicyScaleInControl,
    AutoscalingPolicyScalingSchedule,
    Backend,
    BackendBucket,
    BackendBucketCdnPolicy,
    BackendBucketCdnPolicyBypassCacheOnRequestHeader,
    BackendBucketCdnPolicyCacheKeyPolicy,
    BackendBucketCdnPolicyNegativeCachingPolicy,
    BackendBucketList,
    BackendService,
    BackendServiceAggregatedList,
    BackendServiceCdnPolicy,
    BackendServiceCdnPolicyBypassCacheOnRequestHeader,
    BackendServiceCdnPolicyNegativeCachingPolicy,
    BackendServiceConnectionTrackingPolicy,
    BackendServiceFailoverPolicy,
    BackendServiceGroupHealth,
    BackendServiceIAP,
    BackendServiceList,
    BackendServiceLocalityLoadBalancingPolicyConfig,
    BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy,
    BackendServiceLocalityLoadBalancingPolicyConfigPolicy,
    BackendServiceLogConfig,
    BackendServiceReference,
    BackendServicesScopedList,
    BfdPacket,
    BfdStatus,
    BfdStatusPacketCounts,
    Binding,
    BulkInsertInstanceRequest,
    BulkInsertInstanceResource,
    BulkInsertInstanceResourcePerInstanceProperties,
    BulkInsertRegionInstanceRequest,
    CacheInvalidationRule,
    CacheKeyPolicy,
    CircuitBreakers,
    CloneRulesFirewallPolicyRequest,
    CloneRulesNetworkFirewallPolicyRequest,
    CloneRulesRegionNetworkFirewallPolicyRequest,
    Commitment,
    CommitmentAggregatedList,
    CommitmentList,
    CommitmentsScopedList,
    Condition,
    ConfidentialInstanceConfig,
    ConnectionDraining,
    ConsistentHashLoadBalancerSettings,
    ConsistentHashLoadBalancerSettingsHttpCookie,
    CorsPolicy,
    CreateInstancesInstanceGroupManagerRequest,
    CreateInstancesRegionInstanceGroupManagerRequest,
    CreateSnapshotDiskRequest,
    CreateSnapshotRegionDiskRequest,
    CustomerEncryptionKey,
    CustomerEncryptionKeyProtectedDisk,
    Data,
    DeleteAccessConfigInstanceRequest,
    DeleteAddressRequest,
    DeleteAutoscalerRequest,
    DeleteBackendBucketRequest,
    DeleteBackendServiceRequest,
    DeleteDiskRequest,
    DeleteExternalVpnGatewayRequest,
    DeleteFirewallPolicyRequest,
    DeleteFirewallRequest,
    DeleteForwardingRuleRequest,
    DeleteGlobalAddressRequest,
    DeleteGlobalForwardingRuleRequest,
    DeleteGlobalNetworkEndpointGroupRequest,
    DeleteGlobalOperationRequest,
    DeleteGlobalOperationResponse,
    DeleteGlobalOrganizationOperationRequest,
    DeleteGlobalOrganizationOperationResponse,
    DeleteGlobalPublicDelegatedPrefixeRequest,
    DeleteHealthCheckRequest,
    DeleteImageRequest,
    DeleteInstanceGroupManagerRequest,
    DeleteInstanceGroupRequest,
    DeleteInstanceRequest,
    DeleteInstancesInstanceGroupManagerRequest,
    DeleteInstancesRegionInstanceGroupManagerRequest,
    DeleteInstanceTemplateRequest,
    DeleteInterconnectAttachmentRequest,
    DeleteInterconnectRequest,
    DeleteLicenseRequest,
    DeleteMachineImageRequest,
    DeleteNetworkAttachmentRequest,
    DeleteNetworkEdgeSecurityServiceRequest,
    DeleteNetworkEndpointGroupRequest,
    DeleteNetworkFirewallPolicyRequest,
    DeleteNetworkRequest,
    DeleteNodeGroupRequest,
    DeleteNodesNodeGroupRequest,
    DeleteNodeTemplateRequest,
    DeletePacketMirroringRequest,
    DeletePerInstanceConfigsInstanceGroupManagerRequest,
    DeletePerInstanceConfigsRegionInstanceGroupManagerRequest,
    DeletePublicAdvertisedPrefixeRequest,
    DeletePublicDelegatedPrefixeRequest,
    DeleteRegionAutoscalerRequest,
    DeleteRegionBackendServiceRequest,
    DeleteRegionDiskRequest,
    DeleteRegionHealthCheckRequest,
    DeleteRegionHealthCheckServiceRequest,
    DeleteRegionInstanceGroupManagerRequest,
    DeleteRegionNetworkEndpointGroupRequest,
    DeleteRegionNetworkFirewallPolicyRequest,
    DeleteRegionNotificationEndpointRequest,
    DeleteRegionOperationRequest,
    DeleteRegionOperationResponse,
    DeleteRegionSecurityPolicyRequest,
    DeleteRegionSslCertificateRequest,
    DeleteRegionSslPolicyRequest,
    DeleteRegionTargetHttpProxyRequest,
    DeleteRegionTargetHttpsProxyRequest,
    DeleteRegionTargetTcpProxyRequest,
    DeleteRegionUrlMapRequest,
    DeleteReservationRequest,
    DeleteResourcePolicyRequest,
    DeleteRouteRequest,
    DeleteRouterRequest,
    DeleteSecurityPolicyRequest,
    DeleteServiceAttachmentRequest,
    DeleteSignedUrlKeyBackendBucketRequest,
    DeleteSignedUrlKeyBackendServiceRequest,
    DeleteSnapshotRequest,
    DeleteSslCertificateRequest,
    DeleteSslPolicyRequest,
    DeleteSubnetworkRequest,
    DeleteTargetGrpcProxyRequest,
    DeleteTargetHttpProxyRequest,
    DeleteTargetHttpsProxyRequest,
    DeleteTargetInstanceRequest,
    DeleteTargetPoolRequest,
    DeleteTargetSslProxyRequest,
    DeleteTargetTcpProxyRequest,
    DeleteTargetVpnGatewayRequest,
    DeleteUrlMapRequest,
    DeleteVpnGatewayRequest,
    DeleteVpnTunnelRequest,
    DeleteZoneOperationRequest,
    DeleteZoneOperationResponse,
    Denied,
    DeprecateImageRequest,
    DeprecationStatus,
    DetachDiskInstanceRequest,
    DetachNetworkEndpointsGlobalNetworkEndpointGroupRequest,
    DetachNetworkEndpointsNetworkEndpointGroupRequest,
    DisableXpnHostProjectRequest,
    DisableXpnResourceProjectRequest,
    Disk,
    DiskAggregatedList,
    DiskInstantiationConfig,
    DiskList,
    DiskMoveRequest,
    DiskParams,
    DisksAddResourcePoliciesRequest,
    DisksRemoveResourcePoliciesRequest,
    DisksResizeRequest,
    DisksScopedList,
    DiskType,
    DiskTypeAggregatedList,
    DiskTypeList,
    DiskTypesScopedList,
    DisplayDevice,
    DistributionPolicy,
    DistributionPolicyZoneConfiguration,
    Duration,
    EnableXpnHostProjectRequest,
    EnableXpnResourceProjectRequest,
    Error,
    ErrorDetails,
    ErrorInfo,
    Errors,
    ExchangedPeeringRoute,
    ExchangedPeeringRoutesList,
    ExpandIpCidrRangeSubnetworkRequest,
    Expr,
    ExternalVpnGateway,
    ExternalVpnGatewayInterface,
    ExternalVpnGatewayList,
    FileContentBuffer,
    Firewall,
    FirewallList,
    FirewallLogConfig,
    FirewallPoliciesListAssociationsResponse,
    FirewallPolicy,
    FirewallPolicyAssociation,
    FirewallPolicyList,
    FirewallPolicyRule,
    FirewallPolicyRuleMatcher,
    FirewallPolicyRuleMatcherLayer4Config,
    FirewallPolicyRuleSecureTag,
    FixedOrPercent,
    ForwardingRule,
    ForwardingRuleAggregatedList,
    ForwardingRuleList,
    ForwardingRuleReference,
    ForwardingRuleServiceDirectoryRegistration,
    ForwardingRulesScopedList,
    GetAcceleratorTypeRequest,
    GetAddressRequest,
    GetAssociationFirewallPolicyRequest,
    GetAssociationNetworkFirewallPolicyRequest,
    GetAssociationRegionNetworkFirewallPolicyRequest,
    GetAutoscalerRequest,
    GetBackendBucketRequest,
    GetBackendServiceRequest,
    GetDiagnosticsInterconnectRequest,
    GetDiskRequest,
    GetDiskTypeRequest,
    GetEffectiveFirewallsInstanceRequest,
    GetEffectiveFirewallsNetworkRequest,
    GetEffectiveFirewallsRegionNetworkFirewallPolicyRequest,
    GetExternalVpnGatewayRequest,
    GetFirewallPolicyRequest,
    GetFirewallRequest,
    GetForwardingRuleRequest,
    GetFromFamilyImageRequest,
    GetGlobalAddressRequest,
    GetGlobalForwardingRuleRequest,
    GetGlobalNetworkEndpointGroupRequest,
    GetGlobalOperationRequest,
    GetGlobalOrganizationOperationRequest,
    GetGlobalPublicDelegatedPrefixeRequest,
    GetGuestAttributesInstanceRequest,
    GetHealthBackendServiceRequest,
    GetHealthCheckRequest,
    GetHealthRegionBackendServiceRequest,
    GetHealthTargetPoolRequest,
    GetIamPolicyBackendServiceRequest,
    GetIamPolicyDiskRequest,
    GetIamPolicyFirewallPolicyRequest,
    GetIamPolicyImageRequest,
    GetIamPolicyInstanceRequest,
    GetIamPolicyInstanceTemplateRequest,
    GetIamPolicyLicenseRequest,
    GetIamPolicyMachineImageRequest,
    GetIamPolicyNetworkAttachmentRequest,
    GetIamPolicyNetworkFirewallPolicyRequest,
    GetIamPolicyNodeGroupRequest,
    GetIamPolicyNodeTemplateRequest,
    GetIamPolicyRegionBackendServiceRequest,
    GetIamPolicyRegionDiskRequest,
    GetIamPolicyRegionNetworkFirewallPolicyRequest,
    GetIamPolicyReservationRequest,
    GetIamPolicyResourcePolicyRequest,
    GetIamPolicyServiceAttachmentRequest,
    GetIamPolicySnapshotRequest,
    GetIamPolicySubnetworkRequest,
    GetImageFamilyViewRequest,
    GetImageRequest,
    GetInstanceGroupManagerRequest,
    GetInstanceGroupRequest,
    GetInstanceRequest,
    GetInstanceTemplateRequest,
    GetInterconnectAttachmentRequest,
    GetInterconnectLocationRequest,
    GetInterconnectRequest,
    GetLicenseCodeRequest,
    GetLicenseRequest,
    GetMachineImageRequest,
    GetMachineTypeRequest,
    GetNatMappingInfoRoutersRequest,
    GetNetworkAttachmentRequest,
    GetNetworkEdgeSecurityServiceRequest,
    GetNetworkEndpointGroupRequest,
    GetNetworkFirewallPolicyRequest,
    GetNetworkRequest,
    GetNodeGroupRequest,
    GetNodeTemplateRequest,
    GetNodeTypeRequest,
    GetPacketMirroringRequest,
    GetProjectRequest,
    GetPublicAdvertisedPrefixeRequest,
    GetPublicDelegatedPrefixeRequest,
    GetRegionAutoscalerRequest,
    GetRegionBackendServiceRequest,
    GetRegionCommitmentRequest,
    GetRegionDiskRequest,
    GetRegionDiskTypeRequest,
    GetRegionHealthCheckRequest,
    GetRegionHealthCheckServiceRequest,
    GetRegionInstanceGroupManagerRequest,
    GetRegionInstanceGroupRequest,
    GetRegionNetworkEndpointGroupRequest,
    GetRegionNetworkFirewallPolicyRequest,
    GetRegionNotificationEndpointRequest,
    GetRegionOperationRequest,
    GetRegionRequest,
    GetRegionSecurityPolicyRequest,
    GetRegionSslCertificateRequest,
    GetRegionSslPolicyRequest,
    GetRegionTargetHttpProxyRequest,
    GetRegionTargetHttpsProxyRequest,
    GetRegionTargetTcpProxyRequest,
    GetRegionUrlMapRequest,
    GetReservationRequest,
    GetResourcePolicyRequest,
    GetRouteRequest,
    GetRouterRequest,
    GetRouterStatusRouterRequest,
    GetRuleFirewallPolicyRequest,
    GetRuleNetworkFirewallPolicyRequest,
    GetRuleRegionNetworkFirewallPolicyRequest,
    GetRuleSecurityPolicyRequest,
    GetScreenshotInstanceRequest,
    GetSecurityPolicyRequest,
    GetSerialPortOutputInstanceRequest,
    GetServiceAttachmentRequest,
    GetShieldedInstanceIdentityInstanceRequest,
    GetSnapshotRequest,
    GetSslCertificateRequest,
    GetSslPolicyRequest,
    GetStatusVpnGatewayRequest,
    GetSubnetworkRequest,
    GetTargetGrpcProxyRequest,
    GetTargetHttpProxyRequest,
    GetTargetHttpsProxyRequest,
    GetTargetInstanceRequest,
    GetTargetPoolRequest,
    GetTargetSslProxyRequest,
    GetTargetTcpProxyRequest,
    GetTargetVpnGatewayRequest,
    GetUrlMapRequest,
    GetVpnGatewayRequest,
    GetVpnTunnelRequest,
    GetXpnHostProjectRequest,
    GetXpnResourcesProjectsRequest,
    GetZoneOperationRequest,
    GetZoneRequest,
    GlobalNetworkEndpointGroupsAttachEndpointsRequest,
    GlobalNetworkEndpointGroupsDetachEndpointsRequest,
    GlobalOrganizationSetPolicyRequest,
    GlobalSetLabelsRequest,
    GlobalSetPolicyRequest,
    GRPCHealthCheck,
    GuestAttributes,
    GuestAttributesEntry,
    GuestAttributesValue,
    GuestOsFeature,
    HealthCheck,
    HealthCheckList,
    HealthCheckLogConfig,
    HealthCheckReference,
    HealthChecksAggregatedList,
    HealthCheckService,
    HealthCheckServiceReference,
    HealthCheckServicesList,
    HealthChecksScopedList,
    HealthStatus,
    HealthStatusForNetworkEndpoint,
    Help,
    HelpLink,
    HostRule,
    HTTP2HealthCheck,
    HttpFaultAbort,
    HttpFaultDelay,
    HttpFaultInjection,
    HttpHeaderAction,
    HttpHeaderMatch,
    HttpHeaderOption,
    HTTPHealthCheck,
    HttpQueryParameterMatch,
    HttpRedirectAction,
    HttpRetryPolicy,
    HttpRouteAction,
    HttpRouteRule,
    HttpRouteRuleMatch,
    HTTPSHealthCheck,
    Image,
    ImageFamilyView,
    ImageList,
    InitialStateConfig,
    InsertAddressRequest,
    InsertAutoscalerRequest,
    InsertBackendBucketRequest,
    InsertBackendServiceRequest,
    InsertDiskRequest,
    InsertExternalVpnGatewayRequest,
    InsertFirewallPolicyRequest,
    InsertFirewallRequest,
    InsertForwardingRuleRequest,
    InsertGlobalAddressRequest,
    InsertGlobalForwardingRuleRequest,
    InsertGlobalNetworkEndpointGroupRequest,
    InsertGlobalPublicDelegatedPrefixeRequest,
    InsertHealthCheckRequest,
    InsertImageRequest,
    InsertInstanceGroupManagerRequest,
    InsertInstanceGroupRequest,
    InsertInstanceRequest,
    InsertInstanceTemplateRequest,
    InsertInterconnectAttachmentRequest,
    InsertInterconnectRequest,
    InsertLicenseRequest,
    InsertMachineImageRequest,
    InsertNetworkAttachmentRequest,
    InsertNetworkEdgeSecurityServiceRequest,
    InsertNetworkEndpointGroupRequest,
    InsertNetworkFirewallPolicyRequest,
    InsertNetworkRequest,
    InsertNodeGroupRequest,
    InsertNodeTemplateRequest,
    InsertPacketMirroringRequest,
    InsertPublicAdvertisedPrefixeRequest,
    InsertPublicDelegatedPrefixeRequest,
    InsertRegionAutoscalerRequest,
    InsertRegionBackendServiceRequest,
    InsertRegionCommitmentRequest,
    InsertRegionDiskRequest,
    InsertRegionHealthCheckRequest,
    InsertRegionHealthCheckServiceRequest,
    InsertRegionInstanceGroupManagerRequest,
    InsertRegionNetworkEndpointGroupRequest,
    InsertRegionNetworkFirewallPolicyRequest,
    InsertRegionNotificationEndpointRequest,
    InsertRegionSecurityPolicyRequest,
    InsertRegionSslCertificateRequest,
    InsertRegionSslPolicyRequest,
    InsertRegionTargetHttpProxyRequest,
    InsertRegionTargetHttpsProxyRequest,
    InsertRegionTargetTcpProxyRequest,
    InsertRegionUrlMapRequest,
    InsertReservationRequest,
    InsertResourcePolicyRequest,
    InsertRouteRequest,
    InsertRouterRequest,
    InsertSecurityPolicyRequest,
    InsertServiceAttachmentRequest,
    InsertSnapshotRequest,
    InsertSslCertificateRequest,
    InsertSslPolicyRequest,
    InsertSubnetworkRequest,
    InsertTargetGrpcProxyRequest,
    InsertTargetHttpProxyRequest,
    InsertTargetHttpsProxyRequest,
    InsertTargetInstanceRequest,
    InsertTargetPoolRequest,
    InsertTargetSslProxyRequest,
    InsertTargetTcpProxyRequest,
    InsertTargetVpnGatewayRequest,
    InsertUrlMapRequest,
    InsertVpnGatewayRequest,
    InsertVpnTunnelRequest,
    Instance,
    InstanceAggregatedList,
    InstanceConsumptionData,
    InstanceConsumptionInfo,
    InstanceGroup,
    InstanceGroupAggregatedList,
    InstanceGroupList,
    InstanceGroupManager,
    InstanceGroupManagerActionsSummary,
    InstanceGroupManagerAggregatedList,
    InstanceGroupManagerAutoHealingPolicy,
    InstanceGroupManagerList,
    InstanceGroupManagersAbandonInstancesRequest,
    InstanceGroupManagersApplyUpdatesRequest,
    InstanceGroupManagersCreateInstancesRequest,
    InstanceGroupManagersDeleteInstancesRequest,
    InstanceGroupManagersDeletePerInstanceConfigsReq,
    InstanceGroupManagersListErrorsResponse,
    InstanceGroupManagersListManagedInstancesResponse,
    InstanceGroupManagersListPerInstanceConfigsResp,
    InstanceGroupManagersPatchPerInstanceConfigsReq,
    InstanceGroupManagersRecreateInstancesRequest,
    InstanceGroupManagersScopedList,
    InstanceGroupManagersSetInstanceTemplateRequest,
    InstanceGroupManagersSetTargetPoolsRequest,
    InstanceGroupManagerStatus,
    InstanceGroupManagerStatusStateful,
    InstanceGroupManagerStatusStatefulPerInstanceConfigs,
    InstanceGroupManagerStatusVersionTarget,
    InstanceGroupManagersUpdatePerInstanceConfigsReq,
    InstanceGroupManagerUpdatePolicy,
    InstanceGroupManagerVersion,
    InstanceGroupsAddInstancesRequest,
    InstanceGroupsListInstances,
    InstanceGroupsListInstancesRequest,
    InstanceGroupsRemoveInstancesRequest,
    InstanceGroupsScopedList,
    InstanceGroupsSetNamedPortsRequest,
    InstanceList,
    InstanceListReferrers,
    InstanceManagedByIgmError,
    InstanceManagedByIgmErrorInstanceActionDetails,
    InstanceManagedByIgmErrorManagedInstanceError,
    InstanceMoveRequest,
    InstanceParams,
    InstanceProperties,
    InstanceReference,
    InstancesAddResourcePoliciesRequest,
    InstancesGetEffectiveFirewallsResponse,
    InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy,
    InstancesRemoveResourcePoliciesRequest,
    InstancesScopedList,
    InstancesSetLabelsRequest,
    InstancesSetMachineResourcesRequest,
    InstancesSetMachineTypeRequest,
    InstancesSetMinCpuPlatformRequest,
    InstancesSetServiceAccountRequest,
    InstancesStartWithEncryptionKeyRequest,
    InstanceTemplate,
    InstanceTemplateList,
    InstanceWithNamedPorts,
    Int64RangeMatch,
    Interconnect,
    InterconnectAttachment,
    InterconnectAttachmentAggregatedList,
    InterconnectAttachmentList,
    InterconnectAttachmentPartnerMetadata,
    InterconnectAttachmentPrivateInfo,
    InterconnectAttachmentsScopedList,
    InterconnectCircuitInfo,
    InterconnectDiagnostics,
    InterconnectDiagnosticsARPEntry,
    InterconnectDiagnosticsLinkLACPStatus,
    InterconnectDiagnosticsLinkOpticalPower,
    InterconnectDiagnosticsLinkStatus,
    InterconnectList,
    InterconnectLocation,
    InterconnectLocationList,
    InterconnectLocationRegionInfo,
    InterconnectOutageNotification,
    InterconnectsGetDiagnosticsResponse,
    InvalidateCacheUrlMapRequest,
    Items,
    License,
    LicenseCode,
    LicenseCodeLicenseAlias,
    LicenseResourceCommitment,
    LicenseResourceRequirements,
    LicensesListResponse,
    ListAcceleratorTypesRequest,
    ListAddressesRequest,
    ListAssociationsFirewallPolicyRequest,
    ListAutoscalersRequest,
    ListAvailableFeaturesRegionSslPoliciesRequest,
    ListAvailableFeaturesSslPoliciesRequest,
    ListBackendBucketsRequest,
    ListBackendServicesRequest,
    ListDisksRequest,
    ListDiskTypesRequest,
    ListErrorsInstanceGroupManagersRequest,
    ListErrorsRegionInstanceGroupManagersRequest,
    ListExternalVpnGatewaysRequest,
    ListFirewallPoliciesRequest,
    ListFirewallsRequest,
    ListForwardingRulesRequest,
    ListGlobalAddressesRequest,
    ListGlobalForwardingRulesRequest,
    ListGlobalNetworkEndpointGroupsRequest,
    ListGlobalOperationsRequest,
    ListGlobalOrganizationOperationsRequest,
    ListGlobalPublicDelegatedPrefixesRequest,
    ListHealthChecksRequest,
    ListImagesRequest,
    ListInstanceGroupManagersRequest,
    ListInstanceGroupsRequest,
    ListInstancesInstanceGroupsRequest,
    ListInstancesRegionInstanceGroupsRequest,
    ListInstancesRequest,
    ListInstanceTemplatesRequest,
    ListInterconnectAttachmentsRequest,
    ListInterconnectLocationsRequest,
    ListInterconnectsRequest,
    ListLicensesRequest,
    ListMachineImagesRequest,
    ListMachineTypesRequest,
    ListManagedInstancesInstanceGroupManagersRequest,
    ListManagedInstancesRegionInstanceGroupManagersRequest,
    ListNetworkAttachmentsRequest,
    ListNetworkEndpointGroupsRequest,
    ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest,
    ListNetworkEndpointsNetworkEndpointGroupsRequest,
    ListNetworkFirewallPoliciesRequest,
    ListNetworksRequest,
    ListNodeGroupsRequest,
    ListNodesNodeGroupsRequest,
    ListNodeTemplatesRequest,
    ListNodeTypesRequest,
    ListPacketMirroringsRequest,
    ListPeeringRoutesNetworksRequest,
    ListPerInstanceConfigsInstanceGroupManagersRequest,
    ListPerInstanceConfigsRegionInstanceGroupManagersRequest,
    ListPreconfiguredExpressionSetsSecurityPoliciesRequest,
    ListPublicAdvertisedPrefixesRequest,
    ListPublicDelegatedPrefixesRequest,
    ListReferrersInstancesRequest,
    ListRegionAutoscalersRequest,
    ListRegionBackendServicesRequest,
    ListRegionCommitmentsRequest,
    ListRegionDisksRequest,
    ListRegionDiskTypesRequest,
    ListRegionHealthCheckServicesRequest,
    ListRegionHealthChecksRequest,
    ListRegionInstanceGroupManagersRequest,
    ListRegionInstanceGroupsRequest,
    ListRegionNetworkEndpointGroupsRequest,
    ListRegionNetworkFirewallPoliciesRequest,
    ListRegionNotificationEndpointsRequest,
    ListRegionOperationsRequest,
    ListRegionSecurityPoliciesRequest,
    ListRegionsRequest,
    ListRegionSslCertificatesRequest,
    ListRegionSslPoliciesRequest,
    ListRegionTargetHttpProxiesRequest,
    ListRegionTargetHttpsProxiesRequest,
    ListRegionTargetTcpProxiesRequest,
    ListRegionUrlMapsRequest,
    ListReservationsRequest,
    ListResourcePoliciesRequest,
    ListRoutersRequest,
    ListRoutesRequest,
    ListSecurityPoliciesRequest,
    ListServiceAttachmentsRequest,
    ListSnapshotsRequest,
    ListSslCertificatesRequest,
    ListSslPoliciesRequest,
    ListSubnetworksRequest,
    ListTargetGrpcProxiesRequest,
    ListTargetHttpProxiesRequest,
    ListTargetHttpsProxiesRequest,
    ListTargetInstancesRequest,
    ListTargetPoolsRequest,
    ListTargetSslProxiesRequest,
    ListTargetTcpProxiesRequest,
    ListTargetVpnGatewaysRequest,
    ListUrlMapsRequest,
    ListUsableSubnetworksRequest,
    ListVpnGatewaysRequest,
    ListVpnTunnelsRequest,
    ListXpnHostsProjectsRequest,
    ListZoneOperationsRequest,
    ListZonesRequest,
    LocalDisk,
    LocalizedMessage,
    LocationPolicy,
    LocationPolicyLocation,
    LocationPolicyLocationConstraints,
    LogConfig,
    LogConfigCloudAuditOptions,
    LogConfigCounterOptions,
    LogConfigCounterOptionsCustomField,
    LogConfigDataAccessOptions,
    MachineImage,
    MachineImageList,
    MachineType,
    MachineTypeAggregatedList,
    MachineTypeList,
    MachineTypesScopedList,
    ManagedInstance,
    ManagedInstanceInstanceHealth,
    ManagedInstanceLastAttempt,
    ManagedInstanceVersion,
    Metadata,
    MetadataFilter,
    MetadataFilterLabelMatch,
    MoveDiskProjectRequest,
    MoveFirewallPolicyRequest,
    MoveInstanceProjectRequest,
    NamedPort,
    Network,
    NetworkAttachment,
    NetworkAttachmentAggregatedList,
    NetworkAttachmentConnectedEndpoint,
    NetworkAttachmentList,
    NetworkAttachmentsScopedList,
    NetworkEdgeSecurityService,
    NetworkEdgeSecurityServiceAggregatedList,
    NetworkEdgeSecurityServicesScopedList,
    NetworkEndpoint,
    NetworkEndpointGroup,
    NetworkEndpointGroupAggregatedList,
    NetworkEndpointGroupAppEngine,
    NetworkEndpointGroupCloudFunction,
    NetworkEndpointGroupCloudRun,
    NetworkEndpointGroupList,
    NetworkEndpointGroupPscData,
    NetworkEndpointGroupsAttachEndpointsRequest,
    NetworkEndpointGroupsDetachEndpointsRequest,
    NetworkEndpointGroupsListEndpointsRequest,
    NetworkEndpointGroupsListNetworkEndpoints,
    NetworkEndpointGroupsScopedList,
    NetworkEndpointWithHealthStatus,
    NetworkInterface,
    NetworkList,
    NetworkPeering,
    NetworkPerformanceConfig,
    NetworkRoutingConfig,
    NetworksAddPeeringRequest,
    NetworksGetEffectiveFirewallsResponse,
    NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy,
    NetworksRemovePeeringRequest,
    NetworksUpdatePeeringRequest,
    NodeGroup,
    NodeGroupAggregatedList,
    NodeGroupAutoscalingPolicy,
    NodeGroupList,
    NodeGroupMaintenanceWindow,
    NodeGroupNode,
    NodeGroupsAddNodesRequest,
    NodeGroupsDeleteNodesRequest,
    NodeGroupsListNodes,
    NodeGroupsScopedList,
    NodeGroupsSetNodeTemplateRequest,
    NodeTemplate,
    NodeTemplateAggregatedList,
    NodeTemplateList,
    NodeTemplateNodeTypeFlexibility,
    NodeTemplatesScopedList,
    NodeType,
    NodeTypeAggregatedList,
    NodeTypeList,
    NodeTypesScopedList,
    NotificationEndpoint,
    NotificationEndpointGrpcSettings,
    NotificationEndpointList,
    Operation,
    OperationAggregatedList,
    OperationList,
    OperationsScopedList,
    OutlierDetection,
    PacketIntervals,
    PacketMirroring,
    PacketMirroringAggregatedList,
    PacketMirroringFilter,
    PacketMirroringForwardingRuleInfo,
    PacketMirroringList,
    PacketMirroringMirroredResourceInfo,
    PacketMirroringMirroredResourceInfoInstanceInfo,
    PacketMirroringMirroredResourceInfoSubnetInfo,
    PacketMirroringNetworkInfo,
    PacketMirroringsScopedList,
    PatchAutoscalerRequest,
    PatchBackendBucketRequest,
    PatchBackendServiceRequest,
    PatchFirewallPolicyRequest,
    PatchFirewallRequest,
    PatchForwardingRuleRequest,
    PatchGlobalForwardingRuleRequest,
    PatchGlobalPublicDelegatedPrefixeRequest,
    PatchHealthCheckRequest,
    PatchImageRequest,
    PatchInstanceGroupManagerRequest,
    PatchInterconnectAttachmentRequest,
    PatchInterconnectRequest,
    PatchNetworkEdgeSecurityServiceRequest,
    PatchNetworkFirewallPolicyRequest,
    PatchNetworkRequest,
    PatchNodeGroupRequest,
    PatchPacketMirroringRequest,
    PatchPerInstanceConfigsInstanceGroupManagerRequest,
    PatchPerInstanceConfigsRegionInstanceGroupManagerRequest,
    PatchPublicAdvertisedPrefixeRequest,
    PatchPublicDelegatedPrefixeRequest,
    PatchRegionAutoscalerRequest,
    PatchRegionBackendServiceRequest,
    PatchRegionHealthCheckRequest,
    PatchRegionHealthCheckServiceRequest,
    PatchRegionInstanceGroupManagerRequest,
    PatchRegionNetworkFirewallPolicyRequest,
    PatchRegionSecurityPolicyRequest,
    PatchRegionSslPolicyRequest,
    PatchRegionTargetHttpsProxyRequest,
    PatchRegionUrlMapRequest,
    PatchRouterRequest,
    PatchRuleFirewallPolicyRequest,
    PatchRuleNetworkFirewallPolicyRequest,
    PatchRuleRegionNetworkFirewallPolicyRequest,
    PatchRuleSecurityPolicyRequest,
    PatchSecurityPolicyRequest,
    PatchServiceAttachmentRequest,
    PatchSslPolicyRequest,
    PatchSubnetworkRequest,
    PatchTargetGrpcProxyRequest,
    PatchTargetHttpProxyRequest,
    PatchTargetHttpsProxyRequest,
    PatchUrlMapRequest,
    PathMatcher,
    PathRule,
    PerInstanceConfig,
    Policy,
    PreconfiguredWafSet,
    PreservedState,
    PreservedStatePreservedDisk,
    PreviewRouterRequest,
    Project,
    ProjectsDisableXpnResourceRequest,
    ProjectsEnableXpnResourceRequest,
    ProjectsGetXpnResources,
    ProjectsListXpnHostsRequest,
    ProjectsSetDefaultNetworkTierRequest,
    PublicAdvertisedPrefix,
    PublicAdvertisedPrefixList,
    PublicAdvertisedPrefixPublicDelegatedPrefix,
    PublicDelegatedPrefix,
    PublicDelegatedPrefixAggregatedList,
    PublicDelegatedPrefixesScopedList,
    PublicDelegatedPrefixList,
    PublicDelegatedPrefixPublicDelegatedSubPrefix,
    Quota,
    QuotaExceededInfo,
    RawDisk,
    RecreateInstancesInstanceGroupManagerRequest,
    RecreateInstancesRegionInstanceGroupManagerRequest,
    Reference,
    Region,
    RegionAutoscalerList,
    RegionDisksAddResourcePoliciesRequest,
    RegionDisksRemoveResourcePoliciesRequest,
    RegionDisksResizeRequest,
    RegionDiskTypeList,
    RegionInstanceGroupList,
    RegionInstanceGroupManagerDeleteInstanceConfigReq,
    RegionInstanceGroupManagerList,
    RegionInstanceGroupManagerPatchInstanceConfigReq,
    RegionInstanceGroupManagersAbandonInstancesRequest,
    RegionInstanceGroupManagersApplyUpdatesRequest,
    RegionInstanceGroupManagersCreateInstancesRequest,
    RegionInstanceGroupManagersDeleteInstancesRequest,
    RegionInstanceGroupManagersListErrorsResponse,
    RegionInstanceGroupManagersListInstanceConfigsResp,
    RegionInstanceGroupManagersListInstancesResponse,
    RegionInstanceGroupManagersRecreateRequest,
    RegionInstanceGroupManagersSetTargetPoolsRequest,
    RegionInstanceGroupManagersSetTemplateRequest,
    RegionInstanceGroupManagerUpdateInstanceConfigReq,
    RegionInstanceGroupsListInstances,
    RegionInstanceGroupsListInstancesRequest,
    RegionInstanceGroupsSetNamedPortsRequest,
    RegionList,
    RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse,
    RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy,
    RegionSetLabelsRequest,
    RegionSetPolicyRequest,
    RegionTargetHttpsProxiesSetSslCertificatesRequest,
    RegionUrlMapsValidateRequest,
    RemoveAssociationFirewallPolicyRequest,
    RemoveAssociationNetworkFirewallPolicyRequest,
    RemoveAssociationRegionNetworkFirewallPolicyRequest,
    RemoveHealthCheckTargetPoolRequest,
    RemoveInstancesInstanceGroupRequest,
    RemoveInstanceTargetPoolRequest,
    RemovePeeringNetworkRequest,
    RemoveResourcePoliciesDiskRequest,
    RemoveResourcePoliciesInstanceRequest,
    RemoveResourcePoliciesRegionDiskRequest,
    RemoveRuleFirewallPolicyRequest,
    RemoveRuleNetworkFirewallPolicyRequest,
    RemoveRuleRegionNetworkFirewallPolicyRequest,
    RemoveRuleSecurityPolicyRequest,
    RequestMirrorPolicy,
    Reservation,
    ReservationAffinity,
    ReservationAggregatedList,
    ReservationList,
    ReservationsResizeRequest,
    ReservationsScopedList,
    ResetInstanceRequest,
    ResizeDiskRequest,
    ResizeInstanceGroupManagerRequest,
    ResizeRegionDiskRequest,
    ResizeRegionInstanceGroupManagerRequest,
    ResizeReservationRequest,
    ResourceCommitment,
    ResourceGroupReference,
    ResourcePoliciesScopedList,
    ResourcePolicy,
    ResourcePolicyAggregatedList,
    ResourcePolicyDailyCycle,
    ResourcePolicyGroupPlacementPolicy,
    ResourcePolicyHourlyCycle,
    ResourcePolicyInstanceSchedulePolicy,
    ResourcePolicyInstanceSchedulePolicySchedule,
    ResourcePolicyList,
    ResourcePolicyResourceStatus,
    ResourcePolicyResourceStatusInstanceSchedulePolicyStatus,
    ResourcePolicySnapshotSchedulePolicy,
    ResourcePolicySnapshotSchedulePolicyRetentionPolicy,
    ResourcePolicySnapshotSchedulePolicySchedule,
    ResourcePolicySnapshotSchedulePolicySnapshotProperties,
    ResourcePolicyWeeklyCycle,
    ResourcePolicyWeeklyCycleDayOfWeek,
    ResourceStatus,
    ResumeInstanceRequest,
    Route,
    RouteAsPath,
    RouteList,
    Router,
    RouterAdvertisedIpRange,
    RouterAggregatedList,
    RouterBgp,
    RouterBgpPeer,
    RouterBgpPeerBfd,
    RouterInterface,
    RouterList,
    RouterMd5AuthenticationKey,
    RouterNat,
    RouterNatLogConfig,
    RouterNatRule,
    RouterNatRuleAction,
    RouterNatSubnetworkToNat,
    RoutersPreviewResponse,
    RoutersScopedList,
    RouterStatus,
    RouterStatusBgpPeerStatus,
    RouterStatusNatStatus,
    RouterStatusNatStatusNatRuleStatus,
    RouterStatusResponse,
    Rule,
    SavedAttachedDisk,
    SavedDisk,
    ScalingScheduleStatus,
    Scheduling,
    SchedulingNodeAffinity,
    ScratchDisks,
    Screenshot,
    SecurityPoliciesAggregatedList,
    SecurityPoliciesListPreconfiguredExpressionSetsResponse,
    SecurityPoliciesScopedList,
    SecurityPoliciesWafConfig,
    SecurityPolicy,
    SecurityPolicyAdaptiveProtectionConfig,
    SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig,
    SecurityPolicyAdvancedOptionsConfig,
    SecurityPolicyAdvancedOptionsConfigJsonCustomConfig,
    SecurityPolicyDdosProtectionConfig,
    SecurityPolicyList,
    SecurityPolicyRecaptchaOptionsConfig,
    SecurityPolicyReference,
    SecurityPolicyRule,
    SecurityPolicyRuleHttpHeaderAction,
    SecurityPolicyRuleHttpHeaderActionHttpHeaderOption,
    SecurityPolicyRuleMatcher,
    SecurityPolicyRuleMatcherConfig,
    SecurityPolicyRuleRateLimitOptions,
    SecurityPolicyRuleRateLimitOptionsThreshold,
    SecurityPolicyRuleRedirectOptions,
    SecuritySettings,
    SendDiagnosticInterruptInstanceRequest,
    SendDiagnosticInterruptInstanceResponse,
    SerialPortOutput,
    ServerBinding,
    ServiceAccount,
    ServiceAttachment,
    ServiceAttachmentAggregatedList,
    ServiceAttachmentConnectedEndpoint,
    ServiceAttachmentConsumerProjectLimit,
    ServiceAttachmentList,
    ServiceAttachmentsScopedList,
    SetBackendServiceTargetSslProxyRequest,
    SetBackendServiceTargetTcpProxyRequest,
    SetBackupTargetPoolRequest,
    SetCertificateMapTargetHttpsProxyRequest,
    SetCertificateMapTargetSslProxyRequest,
    SetCommonInstanceMetadataProjectRequest,
    SetDefaultNetworkTierProjectRequest,
    SetDeletionProtectionInstanceRequest,
    SetDiskAutoDeleteInstanceRequest,
    SetEdgeSecurityPolicyBackendBucketRequest,
    SetEdgeSecurityPolicyBackendServiceRequest,
    SetIamPolicyBackendServiceRequest,
    SetIamPolicyDiskRequest,
    SetIamPolicyFirewallPolicyRequest,
    SetIamPolicyImageRequest,
    SetIamPolicyInstanceRequest,
    SetIamPolicyInstanceTemplateRequest,
    SetIamPolicyLicenseRequest,
    SetIamPolicyMachineImageRequest,
    SetIamPolicyNetworkAttachmentRequest,
    SetIamPolicyNetworkFirewallPolicyRequest,
    SetIamPolicyNodeGroupRequest,
    SetIamPolicyNodeTemplateRequest,
    SetIamPolicyRegionBackendServiceRequest,
    SetIamPolicyRegionDiskRequest,
    SetIamPolicyRegionNetworkFirewallPolicyRequest,
    SetIamPolicyReservationRequest,
    SetIamPolicyResourcePolicyRequest,
    SetIamPolicyServiceAttachmentRequest,
    SetIamPolicySnapshotRequest,
    SetIamPolicySubnetworkRequest,
    SetInstanceTemplateInstanceGroupManagerRequest,
    SetInstanceTemplateRegionInstanceGroupManagerRequest,
    SetLabelsAddressRequest,
    SetLabelsDiskRequest,
    SetLabelsExternalVpnGatewayRequest,
    SetLabelsForwardingRuleRequest,
    SetLabelsGlobalAddressRequest,
    SetLabelsGlobalForwardingRuleRequest,
    SetLabelsImageRequest,
    SetLabelsInstanceRequest,
    SetLabelsInterconnectAttachmentRequest,
    SetLabelsInterconnectRequest,
    SetLabelsRegionDiskRequest,
    SetLabelsSecurityPolicyRequest,
    SetLabelsSnapshotRequest,
    SetLabelsTargetVpnGatewayRequest,
    SetLabelsVpnGatewayRequest,
    SetLabelsVpnTunnelRequest,
    SetMachineResourcesInstanceRequest,
    SetMachineTypeInstanceRequest,
    SetMetadataInstanceRequest,
    SetMinCpuPlatformInstanceRequest,
    SetNamedPortsInstanceGroupRequest,
    SetNamedPortsRegionInstanceGroupRequest,
    SetNodeTemplateNodeGroupRequest,
    SetPrivateIpGoogleAccessSubnetworkRequest,
    SetProxyHeaderTargetSslProxyRequest,
    SetProxyHeaderTargetTcpProxyRequest,
    SetQuicOverrideTargetHttpsProxyRequest,
    SetSchedulingInstanceRequest,
    SetSecurityPolicyBackendServiceRequest,
    SetServiceAccountInstanceRequest,
    SetShieldedInstanceIntegrityPolicyInstanceRequest,
    SetSslCertificatesRegionTargetHttpsProxyRequest,
    SetSslCertificatesTargetHttpsProxyRequest,
    SetSslCertificatesTargetSslProxyRequest,
    SetSslPolicyTargetHttpsProxyRequest,
    SetSslPolicyTargetSslProxyRequest,
    SetTagsInstanceRequest,
    SetTargetForwardingRuleRequest,
    SetTargetGlobalForwardingRuleRequest,
    SetTargetPoolsInstanceGroupManagerRequest,
    SetTargetPoolsRegionInstanceGroupManagerRequest,
    SetUrlMapRegionTargetHttpProxyRequest,
    SetUrlMapRegionTargetHttpsProxyRequest,
    SetUrlMapTargetHttpProxyRequest,
    SetUrlMapTargetHttpsProxyRequest,
    SetUsageExportBucketProjectRequest,
    ShareSettings,
    ShareSettingsProjectConfig,
    ShieldedInstanceConfig,
    ShieldedInstanceIdentity,
    ShieldedInstanceIdentityEntry,
    ShieldedInstanceIntegrityPolicy,
    SignedUrlKey,
    SimulateMaintenanceEventInstanceRequest,
    Snapshot,
    SnapshotList,
    SourceDiskEncryptionKey,
    SourceInstanceParams,
    SourceInstanceProperties,
    SslCertificate,
    SslCertificateAggregatedList,
    SslCertificateList,
    SslCertificateManagedSslCertificate,
    SslCertificateSelfManagedSslCertificate,
    SslCertificatesScopedList,
    SSLHealthCheck,
    SslPoliciesAggregatedList,
    SslPoliciesList,
    SslPoliciesListAvailableFeaturesResponse,
    SslPoliciesScopedList,
    SslPolicy,
    SslPolicyReference,
    StartInstanceRequest,
    StartWithEncryptionKeyInstanceRequest,
    StatefulPolicy,
    StatefulPolicyPreservedState,
    StatefulPolicyPreservedStateDiskDevice,
    StopInstanceRequest,
    Subnetwork,
    SubnetworkAggregatedList,
    SubnetworkList,
    SubnetworkLogConfig,
    SubnetworkSecondaryRange,
    SubnetworksExpandIpCidrRangeRequest,
    SubnetworksScopedList,
    SubnetworksSetPrivateIpGoogleAccessRequest,
    Subsetting,
    SuspendInstanceRequest,
    SwitchToCustomModeNetworkRequest,
    Tags,
    TargetGrpcProxy,
    TargetGrpcProxyList,
    TargetHttpProxiesScopedList,
    TargetHttpProxy,
    TargetHttpProxyAggregatedList,
    TargetHttpProxyList,
    TargetHttpsProxiesScopedList,
    TargetHttpsProxiesSetCertificateMapRequest,
    TargetHttpsProxiesSetQuicOverrideRequest,
    TargetHttpsProxiesSetSslCertificatesRequest,
    TargetHttpsProxy,
    TargetHttpsProxyAggregatedList,
    TargetHttpsProxyList,
    TargetInstance,
    TargetInstanceAggregatedList,
    TargetInstanceList,
    TargetInstancesScopedList,
    TargetPool,
    TargetPoolAggregatedList,
    TargetPoolInstanceHealth,
    TargetPoolList,
    TargetPoolsAddHealthCheckRequest,
    TargetPoolsAddInstanceRequest,
    TargetPoolsRemoveHealthCheckRequest,
    TargetPoolsRemoveInstanceRequest,
    TargetPoolsScopedList,
    TargetReference,
    TargetSslProxiesSetBackendServiceRequest,
    TargetSslProxiesSetCertificateMapRequest,
    TargetSslProxiesSetProxyHeaderRequest,
    TargetSslProxiesSetSslCertificatesRequest,
    TargetSslProxy,
    TargetSslProxyList,
    TargetTcpProxiesScopedList,
    TargetTcpProxiesSetBackendServiceRequest,
    TargetTcpProxiesSetProxyHeaderRequest,
    TargetTcpProxy,
    TargetTcpProxyAggregatedList,
    TargetTcpProxyList,
    TargetVpnGateway,
    TargetVpnGatewayAggregatedList,
    TargetVpnGatewayList,
    TargetVpnGatewaysScopedList,
    TCPHealthCheck,
    TestFailure,
    TestIamPermissionsDiskRequest,
    TestIamPermissionsExternalVpnGatewayRequest,
    TestIamPermissionsFirewallPolicyRequest,
    TestIamPermissionsImageRequest,
    TestIamPermissionsInstanceRequest,
    TestIamPermissionsInstanceTemplateRequest,
    TestIamPermissionsLicenseCodeRequest,
    TestIamPermissionsLicenseRequest,
    TestIamPermissionsMachineImageRequest,
    TestIamPermissionsNetworkAttachmentRequest,
    TestIamPermissionsNetworkEndpointGroupRequest,
    TestIamPermissionsNetworkFirewallPolicyRequest,
    TestIamPermissionsNodeGroupRequest,
    TestIamPermissionsNodeTemplateRequest,
    TestIamPermissionsPacketMirroringRequest,
    TestIamPermissionsRegionDiskRequest,
    TestIamPermissionsRegionNetworkFirewallPolicyRequest,
    TestIamPermissionsReservationRequest,
    TestIamPermissionsResourcePolicyRequest,
    TestIamPermissionsServiceAttachmentRequest,
    TestIamPermissionsSnapshotRequest,
    TestIamPermissionsSubnetworkRequest,
    TestIamPermissionsVpnGatewayRequest,
    TestPermissionsRequest,
    TestPermissionsResponse,
    Uint128,
    UpdateAccessConfigInstanceRequest,
    UpdateAutoscalerRequest,
    UpdateBackendBucketRequest,
    UpdateBackendServiceRequest,
    UpdateDisplayDeviceInstanceRequest,
    UpdateFirewallRequest,
    UpdateHealthCheckRequest,
    UpdateInstanceRequest,
    UpdateNetworkInterfaceInstanceRequest,
    UpdatePeeringNetworkRequest,
    UpdatePerInstanceConfigsInstanceGroupManagerRequest,
    UpdatePerInstanceConfigsRegionInstanceGroupManagerRequest,
    UpdateRegionAutoscalerRequest,
    UpdateRegionBackendServiceRequest,
    UpdateRegionCommitmentRequest,
    UpdateRegionHealthCheckRequest,
    UpdateRegionUrlMapRequest,
    UpdateReservationRequest,
    UpdateRouterRequest,
    UpdateShieldedInstanceConfigInstanceRequest,
    UpdateUrlMapRequest,
    UrlMap,
    UrlMapList,
    UrlMapReference,
    UrlMapsAggregatedList,
    UrlMapsScopedList,
    UrlMapsValidateRequest,
    UrlMapsValidateResponse,
    UrlMapTest,
    UrlMapTestHeader,
    UrlMapValidationResult,
    UrlRewrite,
    UsableSubnetwork,
    UsableSubnetworksAggregatedList,
    UsableSubnetworkSecondaryRange,
    UsageExportLocation,
    ValidateRegionUrlMapRequest,
    ValidateUrlMapRequest,
    VmEndpointNatMappings,
    VmEndpointNatMappingsInterfaceNatMappings,
    VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings,
    VmEndpointNatMappingsList,
    VpnGateway,
    VpnGatewayAggregatedList,
    VpnGatewayList,
    VpnGatewaysGetStatusResponse,
    VpnGatewaysScopedList,
    VpnGatewayStatus,
    VpnGatewayStatusHighAvailabilityRequirementState,
    VpnGatewayStatusTunnel,
    VpnGatewayStatusVpnConnection,
    VpnGatewayVpnGatewayInterface,
    VpnTunnel,
    VpnTunnelAggregatedList,
    VpnTunnelList,
    VpnTunnelsScopedList,
    WafExpressionSet,
    WafExpressionSetExpression,
    WaitGlobalOperationRequest,
    WaitRegionOperationRequest,
    WaitZoneOperationRequest,
    Warning,
    Warnings,
    WeightedBackendService,
    XpnHostList,
    XpnResourceId,
    Zone,
    ZoneList,
    ZoneSetLabelsRequest,
    ZoneSetPolicyRequest,
)

__all__ = (
    "AcceleratorTypesClient",
    "AddressesClient",
    "AutoscalersClient",
    "BackendBucketsClient",
    "BackendServicesClient",
    "DisksClient",
    "DiskTypesClient",
    "ExternalVpnGatewaysClient",
    "FirewallPoliciesClient",
    "FirewallsClient",
    "ForwardingRulesClient",
    "GlobalAddressesClient",
    "GlobalForwardingRulesClient",
    "GlobalNetworkEndpointGroupsClient",
    "GlobalOperationsClient",
    "GlobalOrganizationOperationsClient",
    "GlobalPublicDelegatedPrefixesClient",
    "HealthChecksClient",
    "ImageFamilyViewsClient",
    "ImagesClient",
    "InstanceGroupManagersClient",
    "InstanceGroupsClient",
    "InstancesClient",
    "InstanceTemplatesClient",
    "InterconnectAttachmentsClient",
    "InterconnectLocationsClient",
    "InterconnectsClient",
    "LicenseCodesClient",
    "LicensesClient",
    "MachineImagesClient",
    "MachineTypesClient",
    "NetworkAttachmentsClient",
    "NetworkEdgeSecurityServicesClient",
    "NetworkEndpointGroupsClient",
    "NetworkFirewallPoliciesClient",
    "NetworksClient",
    "NodeGroupsClient",
    "NodeTemplatesClient",
    "NodeTypesClient",
    "PacketMirroringsClient",
    "ProjectsClient",
    "PublicAdvertisedPrefixesClient",
    "PublicDelegatedPrefixesClient",
    "RegionAutoscalersClient",
    "RegionBackendServicesClient",
    "RegionCommitmentsClient",
    "RegionDisksClient",
    "RegionDiskTypesClient",
    "RegionHealthChecksClient",
    "RegionHealthCheckServicesClient",
    "RegionInstanceGroupManagersClient",
    "RegionInstanceGroupsClient",
    "RegionInstancesClient",
    "RegionNetworkEndpointGroupsClient",
    "RegionNetworkFirewallPoliciesClient",
    "RegionNotificationEndpointsClient",
    "RegionOperationsClient",
    "RegionsClient",
    "RegionSecurityPoliciesClient",
    "RegionSslCertificatesClient",
    "RegionSslPoliciesClient",
    "RegionTargetHttpProxiesClient",
    "RegionTargetHttpsProxiesClient",
    "RegionTargetTcpProxiesClient",
    "RegionUrlMapsClient",
    "ReservationsClient",
    "ResourcePoliciesClient",
    "RoutersClient",
    "RoutesClient",
    "SecurityPoliciesClient",
    "ServiceAttachmentsClient",
    "SnapshotsClient",
    "SslCertificatesClient",
    "SslPoliciesClient",
    "SubnetworksClient",
    "TargetGrpcProxiesClient",
    "TargetHttpProxiesClient",
    "TargetHttpsProxiesClient",
    "TargetInstancesClient",
    "TargetPoolsClient",
    "TargetSslProxiesClient",
    "TargetTcpProxiesClient",
    "TargetVpnGatewaysClient",
    "UrlMapsClient",
    "VpnGatewaysClient",
    "VpnTunnelsClient",
    "ZoneOperationsClient",
    "ZonesClient",
    "AbandonInstancesInstanceGroupManagerRequest",
    "AbandonInstancesRegionInstanceGroupManagerRequest",
    "AcceleratorConfig",
    "Accelerators",
    "AcceleratorType",
    "AcceleratorTypeAggregatedList",
    "AcceleratorTypeList",
    "AcceleratorTypesScopedList",
    "AccessConfig",
    "AddAccessConfigInstanceRequest",
    "AddAssociationFirewallPolicyRequest",
    "AddAssociationNetworkFirewallPolicyRequest",
    "AddAssociationRegionNetworkFirewallPolicyRequest",
    "AddHealthCheckTargetPoolRequest",
    "AddInstancesInstanceGroupRequest",
    "AddInstanceTargetPoolRequest",
    "AddNodesNodeGroupRequest",
    "AddPeeringNetworkRequest",
    "AddResourcePoliciesDiskRequest",
    "AddResourcePoliciesInstanceRequest",
    "AddResourcePoliciesRegionDiskRequest",
    "Address",
    "AddressAggregatedList",
    "AddressesScopedList",
    "AddressList",
    "AddRuleFirewallPolicyRequest",
    "AddRuleNetworkFirewallPolicyRequest",
    "AddRuleRegionNetworkFirewallPolicyRequest",
    "AddRuleSecurityPolicyRequest",
    "AddSignedUrlKeyBackendBucketRequest",
    "AddSignedUrlKeyBackendServiceRequest",
    "AdvancedMachineFeatures",
    "AggregatedListAcceleratorTypesRequest",
    "AggregatedListAddressesRequest",
    "AggregatedListAutoscalersRequest",
    "AggregatedListBackendServicesRequest",
    "AggregatedListDisksRequest",
    "AggregatedListDiskTypesRequest",
    "AggregatedListForwardingRulesRequest",
    "AggregatedListGlobalOperationsRequest",
    "AggregatedListHealthChecksRequest",
    "AggregatedListInstanceGroupManagersRequest",
    "AggregatedListInstanceGroupsRequest",
    "AggregatedListInstancesRequest",
    "AggregatedListInterconnectAttachmentsRequest",
    "AggregatedListMachineTypesRequest",
    "AggregatedListNetworkAttachmentsRequest",
    "AggregatedListNetworkEdgeSecurityServicesRequest",
    "AggregatedListNetworkEndpointGroupsRequest",
    "AggregatedListNodeGroupsRequest",
    "AggregatedListNodeTemplatesRequest",
    "AggregatedListNodeTypesRequest",
    "AggregatedListPacketMirroringsRequest",
    "AggregatedListPublicDelegatedPrefixesRequest",
    "AggregatedListRegionCommitmentsRequest",
    "AggregatedListReservationsRequest",
    "AggregatedListResourcePoliciesRequest",
    "AggregatedListRoutersRequest",
    "AggregatedListSecurityPoliciesRequest",
    "AggregatedListServiceAttachmentsRequest",
    "AggregatedListSslCertificatesRequest",
    "AggregatedListSslPoliciesRequest",
    "AggregatedListSubnetworksRequest",
    "AggregatedListTargetHttpProxiesRequest",
    "AggregatedListTargetHttpsProxiesRequest",
    "AggregatedListTargetInstancesRequest",
    "AggregatedListTargetPoolsRequest",
    "AggregatedListTargetTcpProxiesRequest",
    "AggregatedListTargetVpnGatewaysRequest",
    "AggregatedListUrlMapsRequest",
    "AggregatedListVpnGatewaysRequest",
    "AggregatedListVpnTunnelsRequest",
    "AliasIpRange",
    "AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk",
    "AllocationSpecificSKUAllocationReservedInstanceProperties",
    "AllocationSpecificSKUReservation",
    "Allowed",
    "ApplyUpdatesToInstancesInstanceGroupManagerRequest",
    "ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest",
    "AttachDiskInstanceRequest",
    "AttachedDisk",
    "AttachedDiskInitializeParams",
    "AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest",
    "AttachNetworkEndpointsNetworkEndpointGroupRequest",
    "AuditConfig",
    "AuditLogConfig",
    "AuthorizationLoggingOptions",
    "Autoscaler",
    "AutoscalerAggregatedList",
    "AutoscalerList",
    "AutoscalersScopedList",
    "AutoscalerStatusDetails",
    "AutoscalingPolicy",
    "AutoscalingPolicyCpuUtilization",
    "AutoscalingPolicyCustomMetricUtilization",
    "AutoscalingPolicyLoadBalancingUtilization",
    "AutoscalingPolicyScaleInControl",
    "AutoscalingPolicyScalingSchedule",
    "Backend",
    "BackendBucket",
    "BackendBucketCdnPolicy",
    "BackendBucketCdnPolicyBypassCacheOnRequestHeader",
    "BackendBucketCdnPolicyCacheKeyPolicy",
    "BackendBucketCdnPolicyNegativeCachingPolicy",
    "BackendBucketList",
    "BackendService",
    "BackendServiceAggregatedList",
    "BackendServiceCdnPolicy",
    "BackendServiceCdnPolicyBypassCacheOnRequestHeader",
    "BackendServiceCdnPolicyNegativeCachingPolicy",
    "BackendServiceConnectionTrackingPolicy",
    "BackendServiceFailoverPolicy",
    "BackendServiceGroupHealth",
    "BackendServiceIAP",
    "BackendServiceList",
    "BackendServiceLocalityLoadBalancingPolicyConfig",
    "BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy",
    "BackendServiceLocalityLoadBalancingPolicyConfigPolicy",
    "BackendServiceLogConfig",
    "BackendServiceReference",
    "BackendServicesScopedList",
    "BfdPacket",
    "BfdStatus",
    "BfdStatusPacketCounts",
    "Binding",
    "BulkInsertInstanceRequest",
    "BulkInsertInstanceResource",
    "BulkInsertInstanceResourcePerInstanceProperties",
    "BulkInsertRegionInstanceRequest",
    "CacheInvalidationRule",
    "CacheKeyPolicy",
    "CircuitBreakers",
    "CloneRulesFirewallPolicyRequest",
    "CloneRulesNetworkFirewallPolicyRequest",
    "CloneRulesRegionNetworkFirewallPolicyRequest",
    "Commitment",
    "CommitmentAggregatedList",
    "CommitmentList",
    "CommitmentsScopedList",
    "Condition",
    "ConfidentialInstanceConfig",
    "ConnectionDraining",
    "ConsistentHashLoadBalancerSettings",
    "ConsistentHashLoadBalancerSettingsHttpCookie",
    "CorsPolicy",
    "CreateInstancesInstanceGroupManagerRequest",
    "CreateInstancesRegionInstanceGroupManagerRequest",
    "CreateSnapshotDiskRequest",
    "CreateSnapshotRegionDiskRequest",
    "CustomerEncryptionKey",
    "CustomerEncryptionKeyProtectedDisk",
    "Data",
    "DeleteAccessConfigInstanceRequest",
    "DeleteAddressRequest",
    "DeleteAutoscalerRequest",
    "DeleteBackendBucketRequest",
    "DeleteBackendServiceRequest",
    "DeleteDiskRequest",
    "DeleteExternalVpnGatewayRequest",
    "DeleteFirewallPolicyRequest",
    "DeleteFirewallRequest",
    "DeleteForwardingRuleRequest",
    "DeleteGlobalAddressRequest",
    "DeleteGlobalForwardingRuleRequest",
    "DeleteGlobalNetworkEndpointGroupRequest",
    "DeleteGlobalOperationRequest",
    "DeleteGlobalOperationResponse",
    "DeleteGlobalOrganizationOperationRequest",
    "DeleteGlobalOrganizationOperationResponse",
    "DeleteGlobalPublicDelegatedPrefixeRequest",
    "DeleteHealthCheckRequest",
    "DeleteImageRequest",
    "DeleteInstanceGroupManagerRequest",
    "DeleteInstanceGroupRequest",
    "DeleteInstanceRequest",
    "DeleteInstancesInstanceGroupManagerRequest",
    "DeleteInstancesRegionInstanceGroupManagerRequest",
    "DeleteInstanceTemplateRequest",
    "DeleteInterconnectAttachmentRequest",
    "DeleteInterconnectRequest",
    "DeleteLicenseRequest",
    "DeleteMachineImageRequest",
    "DeleteNetworkAttachmentRequest",
    "DeleteNetworkEdgeSecurityServiceRequest",
    "DeleteNetworkEndpointGroupRequest",
    "DeleteNetworkFirewallPolicyRequest",
    "DeleteNetworkRequest",
    "DeleteNodeGroupRequest",
    "DeleteNodesNodeGroupRequest",
    "DeleteNodeTemplateRequest",
    "DeletePacketMirroringRequest",
    "DeletePerInstanceConfigsInstanceGroupManagerRequest",
    "DeletePerInstanceConfigsRegionInstanceGroupManagerRequest",
    "DeletePublicAdvertisedPrefixeRequest",
    "DeletePublicDelegatedPrefixeRequest",
    "DeleteRegionAutoscalerRequest",
    "DeleteRegionBackendServiceRequest",
    "DeleteRegionDiskRequest",
    "DeleteRegionHealthCheckRequest",
    "DeleteRegionHealthCheckServiceRequest",
    "DeleteRegionInstanceGroupManagerRequest",
    "DeleteRegionNetworkEndpointGroupRequest",
    "DeleteRegionNetworkFirewallPolicyRequest",
    "DeleteRegionNotificationEndpointRequest",
    "DeleteRegionOperationRequest",
    "DeleteRegionOperationResponse",
    "DeleteRegionSecurityPolicyRequest",
    "DeleteRegionSslCertificateRequest",
    "DeleteRegionSslPolicyRequest",
    "DeleteRegionTargetHttpProxyRequest",
    "DeleteRegionTargetHttpsProxyRequest",
    "DeleteRegionTargetTcpProxyRequest",
    "DeleteRegionUrlMapRequest",
    "DeleteReservationRequest",
    "DeleteResourcePolicyRequest",
    "DeleteRouteRequest",
    "DeleteRouterRequest",
    "DeleteSecurityPolicyRequest",
    "DeleteServiceAttachmentRequest",
    "DeleteSignedUrlKeyBackendBucketRequest",
    "DeleteSignedUrlKeyBackendServiceRequest",
    "DeleteSnapshotRequest",
    "DeleteSslCertificateRequest",
    "DeleteSslPolicyRequest",
    "DeleteSubnetworkRequest",
    "DeleteTargetGrpcProxyRequest",
    "DeleteTargetHttpProxyRequest",
    "DeleteTargetHttpsProxyRequest",
    "DeleteTargetInstanceRequest",
    "DeleteTargetPoolRequest",
    "DeleteTargetSslProxyRequest",
    "DeleteTargetTcpProxyRequest",
    "DeleteTargetVpnGatewayRequest",
    "DeleteUrlMapRequest",
    "DeleteVpnGatewayRequest",
    "DeleteVpnTunnelRequest",
    "DeleteZoneOperationRequest",
    "DeleteZoneOperationResponse",
    "Denied",
    "DeprecateImageRequest",
    "DeprecationStatus",
    "DetachDiskInstanceRequest",
    "DetachNetworkEndpointsGlobalNetworkEndpointGroupRequest",
    "DetachNetworkEndpointsNetworkEndpointGroupRequest",
    "DisableXpnHostProjectRequest",
    "DisableXpnResourceProjectRequest",
    "Disk",
    "DiskAggregatedList",
    "DiskInstantiationConfig",
    "DiskList",
    "DiskMoveRequest",
    "DiskParams",
    "DisksAddResourcePoliciesRequest",
    "DisksRemoveResourcePoliciesRequest",
    "DisksResizeRequest",
    "DisksScopedList",
    "DiskType",
    "DiskTypeAggregatedList",
    "DiskTypeList",
    "DiskTypesScopedList",
    "DisplayDevice",
    "DistributionPolicy",
    "DistributionPolicyZoneConfiguration",
    "Duration",
    "EnableXpnHostProjectRequest",
    "EnableXpnResourceProjectRequest",
    "Error",
    "ErrorDetails",
    "ErrorInfo",
    "Errors",
    "ExchangedPeeringRoute",
    "ExchangedPeeringRoutesList",
    "ExpandIpCidrRangeSubnetworkRequest",
    "Expr",
    "ExternalVpnGateway",
    "ExternalVpnGatewayInterface",
    "ExternalVpnGatewayList",
    "FileContentBuffer",
    "Firewall",
    "FirewallList",
    "FirewallLogConfig",
    "FirewallPoliciesListAssociationsResponse",
    "FirewallPolicy",
    "FirewallPolicyAssociation",
    "FirewallPolicyList",
    "FirewallPolicyRule",
    "FirewallPolicyRuleMatcher",
    "FirewallPolicyRuleMatcherLayer4Config",
    "FirewallPolicyRuleSecureTag",
    "FixedOrPercent",
    "ForwardingRule",
    "ForwardingRuleAggregatedList",
    "ForwardingRuleList",
    "ForwardingRuleReference",
    "ForwardingRuleServiceDirectoryRegistration",
    "ForwardingRulesScopedList",
    "GetAcceleratorTypeRequest",
    "GetAddressRequest",
    "GetAssociationFirewallPolicyRequest",
    "GetAssociationNetworkFirewallPolicyRequest",
    "GetAssociationRegionNetworkFirewallPolicyRequest",
    "GetAutoscalerRequest",
    "GetBackendBucketRequest",
    "GetBackendServiceRequest",
    "GetDiagnosticsInterconnectRequest",
    "GetDiskRequest",
    "GetDiskTypeRequest",
    "GetEffectiveFirewallsInstanceRequest",
    "GetEffectiveFirewallsNetworkRequest",
    "GetEffectiveFirewallsRegionNetworkFirewallPolicyRequest",
    "GetExternalVpnGatewayRequest",
    "GetFirewallPolicyRequest",
    "GetFirewallRequest",
    "GetForwardingRuleRequest",
    "GetFromFamilyImageRequest",
    "GetGlobalAddressRequest",
    "GetGlobalForwardingRuleRequest",
    "GetGlobalNetworkEndpointGroupRequest",
    "GetGlobalOperationRequest",
    "GetGlobalOrganizationOperationRequest",
    "GetGlobalPublicDelegatedPrefixeRequest",
    "GetGuestAttributesInstanceRequest",
    "GetHealthBackendServiceRequest",
    "GetHealthCheckRequest",
    "GetHealthRegionBackendServiceRequest",
    "GetHealthTargetPoolRequest",
    "GetIamPolicyBackendServiceRequest",
    "GetIamPolicyDiskRequest",
    "GetIamPolicyFirewallPolicyRequest",
    "GetIamPolicyImageRequest",
    "GetIamPolicyInstanceRequest",
    "GetIamPolicyInstanceTemplateRequest",
    "GetIamPolicyLicenseRequest",
    "GetIamPolicyMachineImageRequest",
    "GetIamPolicyNetworkAttachmentRequest",
    "GetIamPolicyNetworkFirewallPolicyRequest",
    "GetIamPolicyNodeGroupRequest",
    "GetIamPolicyNodeTemplateRequest",
    "GetIamPolicyRegionBackendServiceRequest",
    "GetIamPolicyRegionDiskRequest",
    "GetIamPolicyRegionNetworkFirewallPolicyRequest",
    "GetIamPolicyReservationRequest",
    "GetIamPolicyResourcePolicyRequest",
    "GetIamPolicyServiceAttachmentRequest",
    "GetIamPolicySnapshotRequest",
    "GetIamPolicySubnetworkRequest",
    "GetImageFamilyViewRequest",
    "GetImageRequest",
    "GetInstanceGroupManagerRequest",
    "GetInstanceGroupRequest",
    "GetInstanceRequest",
    "GetInstanceTemplateRequest",
    "GetInterconnectAttachmentRequest",
    "GetInterconnectLocationRequest",
    "GetInterconnectRequest",
    "GetLicenseCodeRequest",
    "GetLicenseRequest",
    "GetMachineImageRequest",
    "GetMachineTypeRequest",
    "GetNatMappingInfoRoutersRequest",
    "GetNetworkAttachmentRequest",
    "GetNetworkEdgeSecurityServiceRequest",
    "GetNetworkEndpointGroupRequest",
    "GetNetworkFirewallPolicyRequest",
    "GetNetworkRequest",
    "GetNodeGroupRequest",
    "GetNodeTemplateRequest",
    "GetNodeTypeRequest",
    "GetPacketMirroringRequest",
    "GetProjectRequest",
    "GetPublicAdvertisedPrefixeRequest",
    "GetPublicDelegatedPrefixeRequest",
    "GetRegionAutoscalerRequest",
    "GetRegionBackendServiceRequest",
    "GetRegionCommitmentRequest",
    "GetRegionDiskRequest",
    "GetRegionDiskTypeRequest",
    "GetRegionHealthCheckRequest",
    "GetRegionHealthCheckServiceRequest",
    "GetRegionInstanceGroupManagerRequest",
    "GetRegionInstanceGroupRequest",
    "GetRegionNetworkEndpointGroupRequest",
    "GetRegionNetworkFirewallPolicyRequest",
    "GetRegionNotificationEndpointRequest",
    "GetRegionOperationRequest",
    "GetRegionRequest",
    "GetRegionSecurityPolicyRequest",
    "GetRegionSslCertificateRequest",
    "GetRegionSslPolicyRequest",
    "GetRegionTargetHttpProxyRequest",
    "GetRegionTargetHttpsProxyRequest",
    "GetRegionTargetTcpProxyRequest",
    "GetRegionUrlMapRequest",
    "GetReservationRequest",
    "GetResourcePolicyRequest",
    "GetRouteRequest",
    "GetRouterRequest",
    "GetRouterStatusRouterRequest",
    "GetRuleFirewallPolicyRequest",
    "GetRuleNetworkFirewallPolicyRequest",
    "GetRuleRegionNetworkFirewallPolicyRequest",
    "GetRuleSecurityPolicyRequest",
    "GetScreenshotInstanceRequest",
    "GetSecurityPolicyRequest",
    "GetSerialPortOutputInstanceRequest",
    "GetServiceAttachmentRequest",
    "GetShieldedInstanceIdentityInstanceRequest",
    "GetSnapshotRequest",
    "GetSslCertificateRequest",
    "GetSslPolicyRequest",
    "GetStatusVpnGatewayRequest",
    "GetSubnetworkRequest",
    "GetTargetGrpcProxyRequest",
    "GetTargetHttpProxyRequest",
    "GetTargetHttpsProxyRequest",
    "GetTargetInstanceRequest",
    "GetTargetPoolRequest",
    "GetTargetSslProxyRequest",
    "GetTargetTcpProxyRequest",
    "GetTargetVpnGatewayRequest",
    "GetUrlMapRequest",
    "GetVpnGatewayRequest",
    "GetVpnTunnelRequest",
    "GetXpnHostProjectRequest",
    "GetXpnResourcesProjectsRequest",
    "GetZoneOperationRequest",
    "GetZoneRequest",
    "GlobalNetworkEndpointGroupsAttachEndpointsRequest",
    "GlobalNetworkEndpointGroupsDetachEndpointsRequest",
    "GlobalOrganizationSetPolicyRequest",
    "GlobalSetLabelsRequest",
    "GlobalSetPolicyRequest",
    "GRPCHealthCheck",
    "GuestAttributes",
    "GuestAttributesEntry",
    "GuestAttributesValue",
    "GuestOsFeature",
    "HealthCheck",
    "HealthCheckList",
    "HealthCheckLogConfig",
    "HealthCheckReference",
    "HealthChecksAggregatedList",
    "HealthCheckService",
    "HealthCheckServiceReference",
    "HealthCheckServicesList",
    "HealthChecksScopedList",
    "HealthStatus",
    "HealthStatusForNetworkEndpoint",
    "Help",
    "HelpLink",
    "HostRule",
    "HTTP2HealthCheck",
    "HttpFaultAbort",
    "HttpFaultDelay",
    "HttpFaultInjection",
    "HttpHeaderAction",
    "HttpHeaderMatch",
    "HttpHeaderOption",
    "HTTPHealthCheck",
    "HttpQueryParameterMatch",
    "HttpRedirectAction",
    "HttpRetryPolicy",
    "HttpRouteAction",
    "HttpRouteRule",
    "HttpRouteRuleMatch",
    "HTTPSHealthCheck",
    "Image",
    "ImageFamilyView",
    "ImageList",
    "InitialStateConfig",
    "InsertAddressRequest",
    "InsertAutoscalerRequest",
    "InsertBackendBucketRequest",
    "InsertBackendServiceRequest",
    "InsertDiskRequest",
    "InsertExternalVpnGatewayRequest",
    "InsertFirewallPolicyRequest",
    "InsertFirewallRequest",
    "InsertForwardingRuleRequest",
    "InsertGlobalAddressRequest",
    "InsertGlobalForwardingRuleRequest",
    "InsertGlobalNetworkEndpointGroupRequest",
    "InsertGlobalPublicDelegatedPrefixeRequest",
    "InsertHealthCheckRequest",
    "InsertImageRequest",
    "InsertInstanceGroupManagerRequest",
    "InsertInstanceGroupRequest",
    "InsertInstanceRequest",
    "InsertInstanceTemplateRequest",
    "InsertInterconnectAttachmentRequest",
    "InsertInterconnectRequest",
    "InsertLicenseRequest",
    "InsertMachineImageRequest",
    "InsertNetworkAttachmentRequest",
    "InsertNetworkEdgeSecurityServiceRequest",
    "InsertNetworkEndpointGroupRequest",
    "InsertNetworkFirewallPolicyRequest",
    "InsertNetworkRequest",
    "InsertNodeGroupRequest",
    "InsertNodeTemplateRequest",
    "InsertPacketMirroringRequest",
    "InsertPublicAdvertisedPrefixeRequest",
    "InsertPublicDelegatedPrefixeRequest",
    "InsertRegionAutoscalerRequest",
    "InsertRegionBackendServiceRequest",
    "InsertRegionCommitmentRequest",
    "InsertRegionDiskRequest",
    "InsertRegionHealthCheckRequest",
    "InsertRegionHealthCheckServiceRequest",
    "InsertRegionInstanceGroupManagerRequest",
    "InsertRegionNetworkEndpointGroupRequest",
    "InsertRegionNetworkFirewallPolicyRequest",
    "InsertRegionNotificationEndpointRequest",
    "InsertRegionSecurityPolicyRequest",
    "InsertRegionSslCertificateRequest",
    "InsertRegionSslPolicyRequest",
    "InsertRegionTargetHttpProxyRequest",
    "InsertRegionTargetHttpsProxyRequest",
    "InsertRegionTargetTcpProxyRequest",
    "InsertRegionUrlMapRequest",
    "InsertReservationRequest",
    "InsertResourcePolicyRequest",
    "InsertRouteRequest",
    "InsertRouterRequest",
    "InsertSecurityPolicyRequest",
    "InsertServiceAttachmentRequest",
    "InsertSnapshotRequest",
    "InsertSslCertificateRequest",
    "InsertSslPolicyRequest",
    "InsertSubnetworkRequest",
    "InsertTargetGrpcProxyRequest",
    "InsertTargetHttpProxyRequest",
    "InsertTargetHttpsProxyRequest",
    "InsertTargetInstanceRequest",
    "InsertTargetPoolRequest",
    "InsertTargetSslProxyRequest",
    "InsertTargetTcpProxyRequest",
    "InsertTargetVpnGatewayRequest",
    "InsertUrlMapRequest",
    "InsertVpnGatewayRequest",
    "InsertVpnTunnelRequest",
    "Instance",
    "InstanceAggregatedList",
    "InstanceConsumptionData",
    "InstanceConsumptionInfo",
    "InstanceGroup",
    "InstanceGroupAggregatedList",
    "InstanceGroupList",
    "InstanceGroupManager",
    "InstanceGroupManagerActionsSummary",
    "InstanceGroupManagerAggregatedList",
    "InstanceGroupManagerAutoHealingPolicy",
    "InstanceGroupManagerList",
    "InstanceGroupManagersAbandonInstancesRequest",
    "InstanceGroupManagersApplyUpdatesRequest",
    "InstanceGroupManagersCreateInstancesRequest",
    "InstanceGroupManagersDeleteInstancesRequest",
    "InstanceGroupManagersDeletePerInstanceConfigsReq",
    "InstanceGroupManagersListErrorsResponse",
    "InstanceGroupManagersListManagedInstancesResponse",
    "InstanceGroupManagersListPerInstanceConfigsResp",
    "InstanceGroupManagersPatchPerInstanceConfigsReq",
    "InstanceGroupManagersRecreateInstancesRequest",
    "InstanceGroupManagersScopedList",
    "InstanceGroupManagersSetInstanceTemplateRequest",
    "InstanceGroupManagersSetTargetPoolsRequest",
    "InstanceGroupManagerStatus",
    "InstanceGroupManagerStatusStateful",
    "InstanceGroupManagerStatusStatefulPerInstanceConfigs",
    "InstanceGroupManagerStatusVersionTarget",
    "InstanceGroupManagersUpdatePerInstanceConfigsReq",
    "InstanceGroupManagerUpdatePolicy",
    "InstanceGroupManagerVersion",
    "InstanceGroupsAddInstancesRequest",
    "InstanceGroupsListInstances",
    "InstanceGroupsListInstancesRequest",
    "InstanceGroupsRemoveInstancesRequest",
    "InstanceGroupsScopedList",
    "InstanceGroupsSetNamedPortsRequest",
    "InstanceList",
    "InstanceListReferrers",
    "InstanceManagedByIgmError",
    "InstanceManagedByIgmErrorInstanceActionDetails",
    "InstanceManagedByIgmErrorManagedInstanceError",
    "InstanceMoveRequest",
    "InstanceParams",
    "InstanceProperties",
    "InstanceReference",
    "InstancesAddResourcePoliciesRequest",
    "InstancesGetEffectiveFirewallsResponse",
    "InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy",
    "InstancesRemoveResourcePoliciesRequest",
    "InstancesScopedList",
    "InstancesSetLabelsRequest",
    "InstancesSetMachineResourcesRequest",
    "InstancesSetMachineTypeRequest",
    "InstancesSetMinCpuPlatformRequest",
    "InstancesSetServiceAccountRequest",
    "InstancesStartWithEncryptionKeyRequest",
    "InstanceTemplate",
    "InstanceTemplateList",
    "InstanceWithNamedPorts",
    "Int64RangeMatch",
    "Interconnect",
    "InterconnectAttachment",
    "InterconnectAttachmentAggregatedList",
    "InterconnectAttachmentList",
    "InterconnectAttachmentPartnerMetadata",
    "InterconnectAttachmentPrivateInfo",
    "InterconnectAttachmentsScopedList",
    "InterconnectCircuitInfo",
    "InterconnectDiagnostics",
    "InterconnectDiagnosticsARPEntry",
    "InterconnectDiagnosticsLinkLACPStatus",
    "InterconnectDiagnosticsLinkOpticalPower",
    "InterconnectDiagnosticsLinkStatus",
    "InterconnectList",
    "InterconnectLocation",
    "InterconnectLocationList",
    "InterconnectLocationRegionInfo",
    "InterconnectOutageNotification",
    "InterconnectsGetDiagnosticsResponse",
    "InvalidateCacheUrlMapRequest",
    "Items",
    "License",
    "LicenseCode",
    "LicenseCodeLicenseAlias",
    "LicenseResourceCommitment",
    "LicenseResourceRequirements",
    "LicensesListResponse",
    "ListAcceleratorTypesRequest",
    "ListAddressesRequest",
    "ListAssociationsFirewallPolicyRequest",
    "ListAutoscalersRequest",
    "ListAvailableFeaturesRegionSslPoliciesRequest",
    "ListAvailableFeaturesSslPoliciesRequest",
    "ListBackendBucketsRequest",
    "ListBackendServicesRequest",
    "ListDisksRequest",
    "ListDiskTypesRequest",
    "ListErrorsInstanceGroupManagersRequest",
    "ListErrorsRegionInstanceGroupManagersRequest",
    "ListExternalVpnGatewaysRequest",
    "ListFirewallPoliciesRequest",
    "ListFirewallsRequest",
    "ListForwardingRulesRequest",
    "ListGlobalAddressesRequest",
    "ListGlobalForwardingRulesRequest",
    "ListGlobalNetworkEndpointGroupsRequest",
    "ListGlobalOperationsRequest",
    "ListGlobalOrganizationOperationsRequest",
    "ListGlobalPublicDelegatedPrefixesRequest",
    "ListHealthChecksRequest",
    "ListImagesRequest",
    "ListInstanceGroupManagersRequest",
    "ListInstanceGroupsRequest",
    "ListInstancesInstanceGroupsRequest",
    "ListInstancesRegionInstanceGroupsRequest",
    "ListInstancesRequest",
    "ListInstanceTemplatesRequest",
    "ListInterconnectAttachmentsRequest",
    "ListInterconnectLocationsRequest",
    "ListInterconnectsRequest",
    "ListLicensesRequest",
    "ListMachineImagesRequest",
    "ListMachineTypesRequest",
    "ListManagedInstancesInstanceGroupManagersRequest",
    "ListManagedInstancesRegionInstanceGroupManagersRequest",
    "ListNetworkAttachmentsRequest",
    "ListNetworkEndpointGroupsRequest",
    "ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest",
    "ListNetworkEndpointsNetworkEndpointGroupsRequest",
    "ListNetworkFirewallPoliciesRequest",
    "ListNetworksRequest",
    "ListNodeGroupsRequest",
    "ListNodesNodeGroupsRequest",
    "ListNodeTemplatesRequest",
    "ListNodeTypesRequest",
    "ListPacketMirroringsRequest",
    "ListPeeringRoutesNetworksRequest",
    "ListPerInstanceConfigsInstanceGroupManagersRequest",
    "ListPerInstanceConfigsRegionInstanceGroupManagersRequest",
    "ListPreconfiguredExpressionSetsSecurityPoliciesRequest",
    "ListPublicAdvertisedPrefixesRequest",
    "ListPublicDelegatedPrefixesRequest",
    "ListReferrersInstancesRequest",
    "ListRegionAutoscalersRequest",
    "ListRegionBackendServicesRequest",
    "ListRegionCommitmentsRequest",
    "ListRegionDisksRequest",
    "ListRegionDiskTypesRequest",
    "ListRegionHealthCheckServicesRequest",
    "ListRegionHealthChecksRequest",
    "ListRegionInstanceGroupManagersRequest",
    "ListRegionInstanceGroupsRequest",
    "ListRegionNetworkEndpointGroupsRequest",
    "ListRegionNetworkFirewallPoliciesRequest",
    "ListRegionNotificationEndpointsRequest",
    "ListRegionOperationsRequest",
    "ListRegionSecurityPoliciesRequest",
    "ListRegionsRequest",
    "ListRegionSslCertificatesRequest",
    "ListRegionSslPoliciesRequest",
    "ListRegionTargetHttpProxiesRequest",
    "ListRegionTargetHttpsProxiesRequest",
    "ListRegionTargetTcpProxiesRequest",
    "ListRegionUrlMapsRequest",
    "ListReservationsRequest",
    "ListResourcePoliciesRequest",
    "ListRoutersRequest",
    "ListRoutesRequest",
    "ListSecurityPoliciesRequest",
    "ListServiceAttachmentsRequest",
    "ListSnapshotsRequest",
    "ListSslCertificatesRequest",
    "ListSslPoliciesRequest",
    "ListSubnetworksRequest",
    "ListTargetGrpcProxiesRequest",
    "ListTargetHttpProxiesRequest",
    "ListTargetHttpsProxiesRequest",
    "ListTargetInstancesRequest",
    "ListTargetPoolsRequest",
    "ListTargetSslProxiesRequest",
    "ListTargetTcpProxiesRequest",
    "ListTargetVpnGatewaysRequest",
    "ListUrlMapsRequest",
    "ListUsableSubnetworksRequest",
    "ListVpnGatewaysRequest",
    "ListVpnTunnelsRequest",
    "ListXpnHostsProjectsRequest",
    "ListZoneOperationsRequest",
    "ListZonesRequest",
    "LocalDisk",
    "LocalizedMessage",
    "LocationPolicy",
    "LocationPolicyLocation",
    "LocationPolicyLocationConstraints",
    "LogConfig",
    "LogConfigCloudAuditOptions",
    "LogConfigCounterOptions",
    "LogConfigCounterOptionsCustomField",
    "LogConfigDataAccessOptions",
    "MachineImage",
    "MachineImageList",
    "MachineType",
    "MachineTypeAggregatedList",
    "MachineTypeList",
    "MachineTypesScopedList",
    "ManagedInstance",
    "ManagedInstanceInstanceHealth",
    "ManagedInstanceLastAttempt",
    "ManagedInstanceVersion",
    "Metadata",
    "MetadataFilter",
    "MetadataFilterLabelMatch",
    "MoveDiskProjectRequest",
    "MoveFirewallPolicyRequest",
    "MoveInstanceProjectRequest",
    "NamedPort",
    "Network",
    "NetworkAttachment",
    "NetworkAttachmentAggregatedList",
    "NetworkAttachmentConnectedEndpoint",
    "NetworkAttachmentList",
    "NetworkAttachmentsScopedList",
    "NetworkEdgeSecurityService",
    "NetworkEdgeSecurityServiceAggregatedList",
    "NetworkEdgeSecurityServicesScopedList",
    "NetworkEndpoint",
    "NetworkEndpointGroup",
    "NetworkEndpointGroupAggregatedList",
    "NetworkEndpointGroupAppEngine",
    "NetworkEndpointGroupCloudFunction",
    "NetworkEndpointGroupCloudRun",
    "NetworkEndpointGroupList",
    "NetworkEndpointGroupPscData",
    "NetworkEndpointGroupsAttachEndpointsRequest",
    "NetworkEndpointGroupsDetachEndpointsRequest",
    "NetworkEndpointGroupsListEndpointsRequest",
    "NetworkEndpointGroupsListNetworkEndpoints",
    "NetworkEndpointGroupsScopedList",
    "NetworkEndpointWithHealthStatus",
    "NetworkInterface",
    "NetworkList",
    "NetworkPeering",
    "NetworkPerformanceConfig",
    "NetworkRoutingConfig",
    "NetworksAddPeeringRequest",
    "NetworksGetEffectiveFirewallsResponse",
    "NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy",
    "NetworksRemovePeeringRequest",
    "NetworksUpdatePeeringRequest",
    "NodeGroup",
    "NodeGroupAggregatedList",
    "NodeGroupAutoscalingPolicy",
    "NodeGroupList",
    "NodeGroupMaintenanceWindow",
    "NodeGroupNode",
    "NodeGroupsAddNodesRequest",
    "NodeGroupsDeleteNodesRequest",
    "NodeGroupsListNodes",
    "NodeGroupsScopedList",
    "NodeGroupsSetNodeTemplateRequest",
    "NodeTemplate",
    "NodeTemplateAggregatedList",
    "NodeTemplateList",
    "NodeTemplateNodeTypeFlexibility",
    "NodeTemplatesScopedList",
    "NodeType",
    "NodeTypeAggregatedList",
    "NodeTypeList",
    "NodeTypesScopedList",
    "NotificationEndpoint",
    "NotificationEndpointGrpcSettings",
    "NotificationEndpointList",
    "Operation",
    "OperationAggregatedList",
    "OperationList",
    "OperationsScopedList",
    "OutlierDetection",
    "PacketIntervals",
    "PacketMirroring",
    "PacketMirroringAggregatedList",
    "PacketMirroringFilter",
    "PacketMirroringForwardingRuleInfo",
    "PacketMirroringList",
    "PacketMirroringMirroredResourceInfo",
    "PacketMirroringMirroredResourceInfoInstanceInfo",
    "PacketMirroringMirroredResourceInfoSubnetInfo",
    "PacketMirroringNetworkInfo",
    "PacketMirroringsScopedList",
    "PatchAutoscalerRequest",
    "PatchBackendBucketRequest",
    "PatchBackendServiceRequest",
    "PatchFirewallPolicyRequest",
    "PatchFirewallRequest",
    "PatchForwardingRuleRequest",
    "PatchGlobalForwardingRuleRequest",
    "PatchGlobalPublicDelegatedPrefixeRequest",
    "PatchHealthCheckRequest",
    "PatchImageRequest",
    "PatchInstanceGroupManagerRequest",
    "PatchInterconnectAttachmentRequest",
    "PatchInterconnectRequest",
    "PatchNetworkEdgeSecurityServiceRequest",
    "PatchNetworkFirewallPolicyRequest",
    "PatchNetworkRequest",
    "PatchNodeGroupRequest",
    "PatchPacketMirroringRequest",
    "PatchPerInstanceConfigsInstanceGroupManagerRequest",
    "PatchPerInstanceConfigsRegionInstanceGroupManagerRequest",
    "PatchPublicAdvertisedPrefixeRequest",
    "PatchPublicDelegatedPrefixeRequest",
    "PatchRegionAutoscalerRequest",
    "PatchRegionBackendServiceRequest",
    "PatchRegionHealthCheckRequest",
    "PatchRegionHealthCheckServiceRequest",
    "PatchRegionInstanceGroupManagerRequest",
    "PatchRegionNetworkFirewallPolicyRequest",
    "PatchRegionSecurityPolicyRequest",
    "PatchRegionSslPolicyRequest",
    "PatchRegionTargetHttpsProxyRequest",
    "PatchRegionUrlMapRequest",
    "PatchRouterRequest",
    "PatchRuleFirewallPolicyRequest",
    "PatchRuleNetworkFirewallPolicyRequest",
    "PatchRuleRegionNetworkFirewallPolicyRequest",
    "PatchRuleSecurityPolicyRequest",
    "PatchSecurityPolicyRequest",
    "PatchServiceAttachmentRequest",
    "PatchSslPolicyRequest",
    "PatchSubnetworkRequest",
    "PatchTargetGrpcProxyRequest",
    "PatchTargetHttpProxyRequest",
    "PatchTargetHttpsProxyRequest",
    "PatchUrlMapRequest",
    "PathMatcher",
    "PathRule",
    "PerInstanceConfig",
    "Policy",
    "PreconfiguredWafSet",
    "PreservedState",
    "PreservedStatePreservedDisk",
    "PreviewRouterRequest",
    "Project",
    "ProjectsDisableXpnResourceRequest",
    "ProjectsEnableXpnResourceRequest",
    "ProjectsGetXpnResources",
    "ProjectsListXpnHostsRequest",
    "ProjectsSetDefaultNetworkTierRequest",
    "PublicAdvertisedPrefix",
    "PublicAdvertisedPrefixList",
    "PublicAdvertisedPrefixPublicDelegatedPrefix",
    "PublicDelegatedPrefix",
    "PublicDelegatedPrefixAggregatedList",
    "PublicDelegatedPrefixesScopedList",
    "PublicDelegatedPrefixList",
    "PublicDelegatedPrefixPublicDelegatedSubPrefix",
    "Quota",
    "QuotaExceededInfo",
    "RawDisk",
    "RecreateInstancesInstanceGroupManagerRequest",
    "RecreateInstancesRegionInstanceGroupManagerRequest",
    "Reference",
    "Region",
    "RegionAutoscalerList",
    "RegionDisksAddResourcePoliciesRequest",
    "RegionDisksRemoveResourcePoliciesRequest",
    "RegionDisksResizeRequest",
    "RegionDiskTypeList",
    "RegionInstanceGroupList",
    "RegionInstanceGroupManagerDeleteInstanceConfigReq",
    "RegionInstanceGroupManagerList",
    "RegionInstanceGroupManagerPatchInstanceConfigReq",
    "RegionInstanceGroupManagersAbandonInstancesRequest",
    "RegionInstanceGroupManagersApplyUpdatesRequest",
    "RegionInstanceGroupManagersCreateInstancesRequest",
    "RegionInstanceGroupManagersDeleteInstancesRequest",
    "RegionInstanceGroupManagersListErrorsResponse",
    "RegionInstanceGroupManagersListInstanceConfigsResp",
    "RegionInstanceGroupManagersListInstancesResponse",
    "RegionInstanceGroupManagersRecreateRequest",
    "RegionInstanceGroupManagersSetTargetPoolsRequest",
    "RegionInstanceGroupManagersSetTemplateRequest",
    "RegionInstanceGroupManagerUpdateInstanceConfigReq",
    "RegionInstanceGroupsListInstances",
    "RegionInstanceGroupsListInstancesRequest",
    "RegionInstanceGroupsSetNamedPortsRequest",
    "RegionList",
    "RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse",
    "RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy",
    "RegionSetLabelsRequest",
    "RegionSetPolicyRequest",
    "RegionTargetHttpsProxiesSetSslCertificatesRequest",
    "RegionUrlMapsValidateRequest",
    "RemoveAssociationFirewallPolicyRequest",
    "RemoveAssociationNetworkFirewallPolicyRequest",
    "RemoveAssociationRegionNetworkFirewallPolicyRequest",
    "RemoveHealthCheckTargetPoolRequest",
    "RemoveInstancesInstanceGroupRequest",
    "RemoveInstanceTargetPoolRequest",
    "RemovePeeringNetworkRequest",
    "RemoveResourcePoliciesDiskRequest",
    "RemoveResourcePoliciesInstanceRequest",
    "RemoveResourcePoliciesRegionDiskRequest",
    "RemoveRuleFirewallPolicyRequest",
    "RemoveRuleNetworkFirewallPolicyRequest",
    "RemoveRuleRegionNetworkFirewallPolicyRequest",
    "RemoveRuleSecurityPolicyRequest",
    "RequestMirrorPolicy",
    "Reservation",
    "ReservationAffinity",
    "ReservationAggregatedList",
    "ReservationList",
    "ReservationsResizeRequest",
    "ReservationsScopedList",
    "ResetInstanceRequest",
    "ResizeDiskRequest",
    "ResizeInstanceGroupManagerRequest",
    "ResizeRegionDiskRequest",
    "ResizeRegionInstanceGroupManagerRequest",
    "ResizeReservationRequest",
    "ResourceCommitment",
    "ResourceGroupReference",
    "ResourcePoliciesScopedList",
    "ResourcePolicy",
    "ResourcePolicyAggregatedList",
    "ResourcePolicyDailyCycle",
    "ResourcePolicyGroupPlacementPolicy",
    "ResourcePolicyHourlyCycle",
    "ResourcePolicyInstanceSchedulePolicy",
    "ResourcePolicyInstanceSchedulePolicySchedule",
    "ResourcePolicyList",
    "ResourcePolicyResourceStatus",
    "ResourcePolicyResourceStatusInstanceSchedulePolicyStatus",
    "ResourcePolicySnapshotSchedulePolicy",
    "ResourcePolicySnapshotSchedulePolicyRetentionPolicy",
    "ResourcePolicySnapshotSchedulePolicySchedule",
    "ResourcePolicySnapshotSchedulePolicySnapshotProperties",
    "ResourcePolicyWeeklyCycle",
    "ResourcePolicyWeeklyCycleDayOfWeek",
    "ResourceStatus",
    "ResumeInstanceRequest",
    "Route",
    "RouteAsPath",
    "RouteList",
    "Router",
    "RouterAdvertisedIpRange",
    "RouterAggregatedList",
    "RouterBgp",
    "RouterBgpPeer",
    "RouterBgpPeerBfd",
    "RouterInterface",
    "RouterList",
    "RouterMd5AuthenticationKey",
    "RouterNat",
    "RouterNatLogConfig",
    "RouterNatRule",
    "RouterNatRuleAction",
    "RouterNatSubnetworkToNat",
    "RoutersPreviewResponse",
    "RoutersScopedList",
    "RouterStatus",
    "RouterStatusBgpPeerStatus",
    "RouterStatusNatStatus",
    "RouterStatusNatStatusNatRuleStatus",
    "RouterStatusResponse",
    "Rule",
    "SavedAttachedDisk",
    "SavedDisk",
    "ScalingScheduleStatus",
    "Scheduling",
    "SchedulingNodeAffinity",
    "ScratchDisks",
    "Screenshot",
    "SecurityPoliciesAggregatedList",
    "SecurityPoliciesListPreconfiguredExpressionSetsResponse",
    "SecurityPoliciesScopedList",
    "SecurityPoliciesWafConfig",
    "SecurityPolicy",
    "SecurityPolicyAdaptiveProtectionConfig",
    "SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig",
    "SecurityPolicyAdvancedOptionsConfig",
    "SecurityPolicyAdvancedOptionsConfigJsonCustomConfig",
    "SecurityPolicyDdosProtectionConfig",
    "SecurityPolicyList",
    "SecurityPolicyRecaptchaOptionsConfig",
    "SecurityPolicyReference",
    "SecurityPolicyRule",
    "SecurityPolicyRuleHttpHeaderAction",
    "SecurityPolicyRuleHttpHeaderActionHttpHeaderOption",
    "SecurityPolicyRuleMatcher",
    "SecurityPolicyRuleMatcherConfig",
    "SecurityPolicyRuleRateLimitOptions",
    "SecurityPolicyRuleRateLimitOptionsThreshold",
    "SecurityPolicyRuleRedirectOptions",
    "SecuritySettings",
    "SendDiagnosticInterruptInstanceRequest",
    "SendDiagnosticInterruptInstanceResponse",
    "SerialPortOutput",
    "ServerBinding",
    "ServiceAccount",
    "ServiceAttachment",
    "ServiceAttachmentAggregatedList",
    "ServiceAttachmentConnectedEndpoint",
    "ServiceAttachmentConsumerProjectLimit",
    "ServiceAttachmentList",
    "ServiceAttachmentsScopedList",
    "SetBackendServiceTargetSslProxyRequest",
    "SetBackendServiceTargetTcpProxyRequest",
    "SetBackupTargetPoolRequest",
    "SetCertificateMapTargetHttpsProxyRequest",
    "SetCertificateMapTargetSslProxyRequest",
    "SetCommonInstanceMetadataProjectRequest",
    "SetDefaultNetworkTierProjectRequest",
    "SetDeletionProtectionInstanceRequest",
    "SetDiskAutoDeleteInstanceRequest",
    "SetEdgeSecurityPolicyBackendBucketRequest",
    "SetEdgeSecurityPolicyBackendServiceRequest",
    "SetIamPolicyBackendServiceRequest",
    "SetIamPolicyDiskRequest",
    "SetIamPolicyFirewallPolicyRequest",
    "SetIamPolicyImageRequest",
    "SetIamPolicyInstanceRequest",
    "SetIamPolicyInstanceTemplateRequest",
    "SetIamPolicyLicenseRequest",
    "SetIamPolicyMachineImageRequest",
    "SetIamPolicyNetworkAttachmentRequest",
    "SetIamPolicyNetworkFirewallPolicyRequest",
    "SetIamPolicyNodeGroupRequest",
    "SetIamPolicyNodeTemplateRequest",
    "SetIamPolicyRegionBackendServiceRequest",
    "SetIamPolicyRegionDiskRequest",
    "SetIamPolicyRegionNetworkFirewallPolicyRequest",
    "SetIamPolicyReservationRequest",
    "SetIamPolicyResourcePolicyRequest",
    "SetIamPolicyServiceAttachmentRequest",
    "SetIamPolicySnapshotRequest",
    "SetIamPolicySubnetworkRequest",
    "SetInstanceTemplateInstanceGroupManagerRequest",
    "SetInstanceTemplateRegionInstanceGroupManagerRequest",
    "SetLabelsAddressRequest",
    "SetLabelsDiskRequest",
    "SetLabelsExternalVpnGatewayRequest",
    "SetLabelsForwardingRuleRequest",
    "SetLabelsGlobalAddressRequest",
    "SetLabelsGlobalForwardingRuleRequest",
    "SetLabelsImageRequest",
    "SetLabelsInstanceRequest",
    "SetLabelsInterconnectAttachmentRequest",
    "SetLabelsInterconnectRequest",
    "SetLabelsRegionDiskRequest",
    "SetLabelsSecurityPolicyRequest",
    "SetLabelsSnapshotRequest",
    "SetLabelsTargetVpnGatewayRequest",
    "SetLabelsVpnGatewayRequest",
    "SetLabelsVpnTunnelRequest",
    "SetMachineResourcesInstanceRequest",
    "SetMachineTypeInstanceRequest",
    "SetMetadataInstanceRequest",
    "SetMinCpuPlatformInstanceRequest",
    "SetNamedPortsInstanceGroupRequest",
    "SetNamedPortsRegionInstanceGroupRequest",
    "SetNodeTemplateNodeGroupRequest",
    "SetPrivateIpGoogleAccessSubnetworkRequest",
    "SetProxyHeaderTargetSslProxyRequest",
    "SetProxyHeaderTargetTcpProxyRequest",
    "SetQuicOverrideTargetHttpsProxyRequest",
    "SetSchedulingInstanceRequest",
    "SetSecurityPolicyBackendServiceRequest",
    "SetServiceAccountInstanceRequest",
    "SetShieldedInstanceIntegrityPolicyInstanceRequest",
    "SetSslCertificatesRegionTargetHttpsProxyRequest",
    "SetSslCertificatesTargetHttpsProxyRequest",
    "SetSslCertificatesTargetSslProxyRequest",
    "SetSslPolicyTargetHttpsProxyRequest",
    "SetSslPolicyTargetSslProxyRequest",
    "SetTagsInstanceRequest",
    "SetTargetForwardingRuleRequest",
    "SetTargetGlobalForwardingRuleRequest",
    "SetTargetPoolsInstanceGroupManagerRequest",
    "SetTargetPoolsRegionInstanceGroupManagerRequest",
    "SetUrlMapRegionTargetHttpProxyRequest",
    "SetUrlMapRegionTargetHttpsProxyRequest",
    "SetUrlMapTargetHttpProxyRequest",
    "SetUrlMapTargetHttpsProxyRequest",
    "SetUsageExportBucketProjectRequest",
    "ShareSettings",
    "ShareSettingsProjectConfig",
    "ShieldedInstanceConfig",
    "ShieldedInstanceIdentity",
    "ShieldedInstanceIdentityEntry",
    "ShieldedInstanceIntegrityPolicy",
    "SignedUrlKey",
    "SimulateMaintenanceEventInstanceRequest",
    "Snapshot",
    "SnapshotList",
    "SourceDiskEncryptionKey",
    "SourceInstanceParams",
    "SourceInstanceProperties",
    "SslCertificate",
    "SslCertificateAggregatedList",
    "SslCertificateList",
    "SslCertificateManagedSslCertificate",
    "SslCertificateSelfManagedSslCertificate",
    "SslCertificatesScopedList",
    "SSLHealthCheck",
    "SslPoliciesAggregatedList",
    "SslPoliciesList",
    "SslPoliciesListAvailableFeaturesResponse",
    "SslPoliciesScopedList",
    "SslPolicy",
    "SslPolicyReference",
    "StartInstanceRequest",
    "StartWithEncryptionKeyInstanceRequest",
    "StatefulPolicy",
    "StatefulPolicyPreservedState",
    "StatefulPolicyPreservedStateDiskDevice",
    "StopInstanceRequest",
    "Subnetwork",
    "SubnetworkAggregatedList",
    "SubnetworkList",
    "SubnetworkLogConfig",
    "SubnetworkSecondaryRange",
    "SubnetworksExpandIpCidrRangeRequest",
    "SubnetworksScopedList",
    "SubnetworksSetPrivateIpGoogleAccessRequest",
    "Subsetting",
    "SuspendInstanceRequest",
    "SwitchToCustomModeNetworkRequest",
    "Tags",
    "TargetGrpcProxy",
    "TargetGrpcProxyList",
    "TargetHttpProxiesScopedList",
    "TargetHttpProxy",
    "TargetHttpProxyAggregatedList",
    "TargetHttpProxyList",
    "TargetHttpsProxiesScopedList",
    "TargetHttpsProxiesSetCertificateMapRequest",
    "TargetHttpsProxiesSetQuicOverrideRequest",
    "TargetHttpsProxiesSetSslCertificatesRequest",
    "TargetHttpsProxy",
    "TargetHttpsProxyAggregatedList",
    "TargetHttpsProxyList",
    "TargetInstance",
    "TargetInstanceAggregatedList",
    "TargetInstanceList",
    "TargetInstancesScopedList",
    "TargetPool",
    "TargetPoolAggregatedList",
    "TargetPoolInstanceHealth",
    "TargetPoolList",
    "TargetPoolsAddHealthCheckRequest",
    "TargetPoolsAddInstanceRequest",
    "TargetPoolsRemoveHealthCheckRequest",
    "TargetPoolsRemoveInstanceRequest",
    "TargetPoolsScopedList",
    "TargetReference",
    "TargetSslProxiesSetBackendServiceRequest",
    "TargetSslProxiesSetCertificateMapRequest",
    "TargetSslProxiesSetProxyHeaderRequest",
    "TargetSslProxiesSetSslCertificatesRequest",
    "TargetSslProxy",
    "TargetSslProxyList",
    "TargetTcpProxiesScopedList",
    "TargetTcpProxiesSetBackendServiceRequest",
    "TargetTcpProxiesSetProxyHeaderRequest",
    "TargetTcpProxy",
    "TargetTcpProxyAggregatedList",
    "TargetTcpProxyList",
    "TargetVpnGateway",
    "TargetVpnGatewayAggregatedList",
    "TargetVpnGatewayList",
    "TargetVpnGatewaysScopedList",
    "TCPHealthCheck",
    "TestFailure",
    "TestIamPermissionsDiskRequest",
    "TestIamPermissionsExternalVpnGatewayRequest",
    "TestIamPermissionsFirewallPolicyRequest",
    "TestIamPermissionsImageRequest",
    "TestIamPermissionsInstanceRequest",
    "TestIamPermissionsInstanceTemplateRequest",
    "TestIamPermissionsLicenseCodeRequest",
    "TestIamPermissionsLicenseRequest",
    "TestIamPermissionsMachineImageRequest",
    "TestIamPermissionsNetworkAttachmentRequest",
    "TestIamPermissionsNetworkEndpointGroupRequest",
    "TestIamPermissionsNetworkFirewallPolicyRequest",
    "TestIamPermissionsNodeGroupRequest",
    "TestIamPermissionsNodeTemplateRequest",
    "TestIamPermissionsPacketMirroringRequest",
    "TestIamPermissionsRegionDiskRequest",
    "TestIamPermissionsRegionNetworkFirewallPolicyRequest",
    "TestIamPermissionsReservationRequest",
    "TestIamPermissionsResourcePolicyRequest",
    "TestIamPermissionsServiceAttachmentRequest",
    "TestIamPermissionsSnapshotRequest",
    "TestIamPermissionsSubnetworkRequest",
    "TestIamPermissionsVpnGatewayRequest",
    "TestPermissionsRequest",
    "TestPermissionsResponse",
    "Uint128",
    "UpdateAccessConfigInstanceRequest",
    "UpdateAutoscalerRequest",
    "UpdateBackendBucketRequest",
    "UpdateBackendServiceRequest",
    "UpdateDisplayDeviceInstanceRequest",
    "UpdateFirewallRequest",
    "UpdateHealthCheckRequest",
    "UpdateInstanceRequest",
    "UpdateNetworkInterfaceInstanceRequest",
    "UpdatePeeringNetworkRequest",
    "UpdatePerInstanceConfigsInstanceGroupManagerRequest",
    "UpdatePerInstanceConfigsRegionInstanceGroupManagerRequest",
    "UpdateRegionAutoscalerRequest",
    "UpdateRegionBackendServiceRequest",
    "UpdateRegionCommitmentRequest",
    "UpdateRegionHealthCheckRequest",
    "UpdateRegionUrlMapRequest",
    "UpdateReservationRequest",
    "UpdateRouterRequest",
    "UpdateShieldedInstanceConfigInstanceRequest",
    "UpdateUrlMapRequest",
    "UrlMap",
    "UrlMapList",
    "UrlMapReference",
    "UrlMapsAggregatedList",
    "UrlMapsScopedList",
    "UrlMapsValidateRequest",
    "UrlMapsValidateResponse",
    "UrlMapTest",
    "UrlMapTestHeader",
    "UrlMapValidationResult",
    "UrlRewrite",
    "UsableSubnetwork",
    "UsableSubnetworksAggregatedList",
    "UsableSubnetworkSecondaryRange",
    "UsageExportLocation",
    "ValidateRegionUrlMapRequest",
    "ValidateUrlMapRequest",
    "VmEndpointNatMappings",
    "VmEndpointNatMappingsInterfaceNatMappings",
    "VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings",
    "VmEndpointNatMappingsList",
    "VpnGateway",
    "VpnGatewayAggregatedList",
    "VpnGatewayList",
    "VpnGatewaysGetStatusResponse",
    "VpnGatewaysScopedList",
    "VpnGatewayStatus",
    "VpnGatewayStatusHighAvailabilityRequirementState",
    "VpnGatewayStatusTunnel",
    "VpnGatewayStatusVpnConnection",
    "VpnGatewayVpnGatewayInterface",
    "VpnTunnel",
    "VpnTunnelAggregatedList",
    "VpnTunnelList",
    "VpnTunnelsScopedList",
    "WafExpressionSet",
    "WafExpressionSetExpression",
    "WaitGlobalOperationRequest",
    "WaitRegionOperationRequest",
    "WaitZoneOperationRequest",
    "Warning",
    "Warnings",
    "WeightedBackendService",
    "XpnHostList",
    "XpnResourceId",
    "Zone",
    "ZoneList",
    "ZoneSetLabelsRequest",
    "ZoneSetPolicyRequest",
)
