"use strict";
// Copyright 2012-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
exports.LexMetrics = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class LexMetrics {
    static runtimeRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/Lex',
            metricName: 'RuntimeRequestCount',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static runtimeSucessfulRequestLatencyAverage(dimensions) {
        return {
            namespace: 'AWS/Lex',
            metricName: 'RuntimeSucessfulRequestLatency',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static runtimeInvalidLambdaResponsesSum(dimensions) {
        return {
            namespace: 'AWS/Lex',
            metricName: 'RuntimeInvalidLambdaResponses',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static runtimeLambdaErrorsSum(dimensions) {
        return {
            namespace: 'AWS/Lex',
            metricName: 'RuntimeLambdaErrors',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static missedUtteranceCountSum(dimensions) {
        return {
            namespace: 'AWS/Lex',
            metricName: 'MissedUtteranceCount',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static runtimePollyErrorsSum(dimensions) {
        return {
            namespace: 'AWS/Lex',
            metricName: 'RuntimePollyErrors',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static runtimeSystemErrorsSum(dimensions) {
        return {
            namespace: 'AWS/Lex',
            metricName: 'RuntimeSystemErrors',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static runtimeThrottledEventsSum(dimensions) {
        return {
            namespace: 'AWS/Lex',
            metricName: 'RuntimeThrottledEvents',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static runtimeUserErrorsSum(dimensions) {
        return {
            namespace: 'AWS/Lex',
            metricName: 'RuntimeUserErrors',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
}
exports.LexMetrics = LexMetrics;
//# sourceMappingURL=data:application/json;base64,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