"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NamedQuery = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const lambda_1 = require("./lambda");
const resourceType = 'Custom::Athena-NamedQuery';
/**
 * An Athena NamedQuery.
 *
 * @stability stable
 */
class NamedQuery extends cdk.Construct {
    /**
     * Defines a new Athena NamedQuery.
     *
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * Name of the query.
         *
         * @stability stable
         */
        this.name = '';
        /**
         * The unique ID of the query.
         *
         * @stability stable
         */
        this.id = '';
        this.lambda = lambda_1.ensureLambda(this);
        this.name = props.name;
        const queryProps = {
            serviceToken: this.lambda.functionArn,
            resourceType: resourceType,
            properties: {
                Name: this.name,
                Description: props.desc || '',
                Database: props.database,
                QueryString: props.queryString,
                WorkGroup: '',
            },
        };
        if (typeof props.workGroup === 'string') {
            queryProps.properties.WorkGroup = props.workGroup;
        }
        else if (typeof props.workGroup !== 'undefined') {
            queryProps.properties.WorkGroup = props.workGroup.name;
        }
        const namedQuery = new cdk.CustomResource(this, `Athena-NamedQuery-${props.name
            .replace(/\s+/g, '-')
            .replace(/[a-z0-9_-]+/gi, '')}`, queryProps);
        if (['undefined', 'string'].indexOf(typeof props.workGroup) < 0) {
            namedQuery.node.addDependency(props.workGroup);
        }
        this.id = namedQuery.getAttString('id');
    }
}
exports.NamedQuery = NamedQuery;
_a = JSII_RTTI_SYMBOL_1;
NamedQuery[_a] = { fqn: "cdk-athena.NamedQuery", version: "2.0.2" };
//# sourceMappingURL=data:application/json;base64,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