import lambda = require('@aws-cdk/aws-lambda');
import cdk = require('@aws-cdk/core');
import { WorkGroup } from './workGroup';
/**
 * Definition of the Athena NamedQuery.
 *
 * @stability stable
 */
export interface NamedQueryProps extends cdk.StackProps {
    /**
     * The query name.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The query description.
     *
     * @stability stable
     */
    readonly desc?: string;
    /**
     * The database to which the query belongs.
     *
     * @stability stable
     */
    readonly database: string;
    /**
     * The workgroup in which the named query is being created.
     *
     * @stability stable
     */
    readonly workGroup?: WorkGroup | string;
    /**
     * The contents of the query with all query statements.
     *
     * @stability stable
     */
    readonly queryString: string;
}
/**
 * An Athena NamedQuery.
 *
 * @stability stable
 */
export declare class NamedQuery extends cdk.Construct {
    /**
     * The lambda function that is created.
     *
     * @stability stable
     */
    readonly lambda: lambda.IFunction;
    /**
     * Name of the query.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The unique ID of the query.
     *
     * @stability stable
     */
    readonly id: string;
    /**
     * Defines a new Athena NamedQuery.
     *
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: NamedQueryProps);
}
