# -*- coding: utf-8 -*-
import os

import hao

from . import dates

LOGGER = hao.logs.get_logger(__name__)

_NON_TEXT = [
    '︰',
    '︳',
    '︴',
    '︵',
    '︶',
    '︷',
    '︸',
    '︹',
    '︺',
    '︻',
    '︼',
    '︽',
    '︾',
    '︿',
    '﹀',
    '﹁',
    '﹂',
    '﹃',
    '﹄',
    '﹉',
    '﹊',
    '﹋',
    '﹌',
    '﹍',
    '﹎',
    '﹏',
    '﹐',
    '﹑',
    '﹔',
    '﹕',
    '﹖',
    '﹝',
    '﹞',
    '﹟',
    '﹠',
    '﹡',
    '﹢',
    '﹤',
    '﹦',
    '﹨',
    '﹩',
    '﹪',
    '﹫',
    '！',
    '！ ',
    '＂',
    '＃',
    '＄',
    '％',
    '＆',
    '＇',
    '（',
    '）',
    '）÷（１－',
    '）、',
    '＊',
    '＋',
    '＋ξ',
    '＋＋',
    '，',
    '， ',
    '，也',
    '，也 ',
    '－',
    '－β',
    '－－',
    '－－ ',
    '－［＊］－',
    '．',
    '／',
    '０',
    '０：２',
    '０：２ ',
    '１',
    '１．',
    '１． ',
    '１２％',
    '２',
    '２．３％',
    '３',
    '４',
    '５',
    '５：０',
    '５：０  ',
    '６',
    '７',
    '８',
    '９',
    '：',
    '： ',
    '；',
    '； ',
    '＜',
    '＜±',
    '＜Δ',
    '＜λ',
    '＜φ',
    '＜＜',
    '＝',
    '＝″',
    '＝☆',
    '＝（',
    '＝－',
    '＝［',
    '＝｛',
    '＞',
    '＞λ',
    '？',
    '？ ',
    '＠',
    'Ａ',
    'ＬＩ',
    'Ｒ．Ｌ．',
    'ＺＸＦＩＴＬ',
    '［',
    '［①①］',
    '［①②］',
    '［①③］',
    '［①④］',
    '［①⑤］',
    '［①⑥］',
    '［①⑦］',
    '［①⑧］',
    '［①⑨］',
    '［①Ａ］',
    '［①Ｂ］',
    '［①Ｃ］',
    '［①Ｄ］',
    '［①Ｅ］',
    '［①］',
    '［①ａ］',
    '［①ｃ］',
    '［①ｄ］',
    '［①ｅ］',
    '［①ｆ］',
    '［①ｇ］',
    '［①ｈ］',
    '［①ｉ］',
    '［①ｏ］',
    '［②',
    '［②①］',
    '［②②］',
    '［②③］',
    '［②④',
    '［②⑤］',
    '［②⑥］',
    '［②⑦］',
    '［②⑧］',
    '［②⑩］',
    '［②Ｂ］',
    '［②Ｂ］ ',
    '［②Ｇ］',
    '［②］',
    '［②ａ］',
    '［②ｂ］',
    '［②ｃ］',
    '［②ｃ］ ',
    '［②ｄ］',
    '［②ｅ］',
    '［②ｆ］',
    '［②ｇ］',
    '［②ｈ］',
    '［②ｉ］',
    '［②ｊ］',
    '［③①］',
    '［③⑩］',
    '［③Ｆ］',
    '［③］',
    '［③ａ］',
    '［③ｂ］',
    '［③ｃ］',
    '［③ｄ］',
    '［③ｅ］',
    '［③ｇ］',
    '［③ｈ］',
    '［④］',
    '［④ａ］',
    '［④ｂ］',
    '［④ｃ］',
    '［④ｄ］',
    '［④ｅ］',
    '［⑤］',
    '［⑤］］',
    '［⑤ａ］',
    '［⑤ｂ］',
    '［⑤ｄ］',
    '［⑤ｅ］',
    '［⑤ｆ］',
    '［⑥］',
    '［⑦］',
    '［⑧］',
    '［⑨］',
    '［⑨］ ',
    '［⑩］',
    '［＊］',
    '［－',
    '［］',
    '＼',
    '］',
    '］∧′＝［',
    '］∧′＝［ ',
    '］［',
    '＾',
    '＿',
    '｀',
    'ａ］',
    'ｂ］',
    'ｃ］',
    'ｅ］',
    'ｆ］',
    'ｎｇ昉',
    '｛',
    '｛－',
    '｜',
    '｝',
    '｝＞',
    '～',
    '～±',
    '～＋',
    '｟',
    '｠',
    '｡',
    '｢',
    '｣',
    '､',
    '￣',
    '￥',
    '!',
    '"',
    '#',
    '$',
    '%',
    '&',
    '&ldquo;',
    '&quot;',
    '&nbsp;',
    '&rdquo;',
    '&lt;',
    '&lte;',
    '&gt;',
    '&gte;',
    '\'',
    '(',
    ')',
    '*',
    '*LRB*',
    '*RRB*',
    '+',
    ',',
    '-',
    '--',
    '-- ',
    '-LRB-',
    '-RRB-',
    '.',
    '. ',
    '..',
    '...',
    '......',
    '...................',
    './',
    '.一',
    '.数',
    '.日',
    '.日 ',
    '/',
    '//',
    '0',
    '1',
    '2',
    '3',
    '4',
    '5',
    '6',
    '7',
    '8',
    '9',
    ':',
    '://',
    '::',
    ';',
    '<',
    '<dquote>',
    '<hr/>',
    '<ldquo>',
    '<lsquo>',
    '<rdquo>',
    '<rsquo>',
    '=',
    '>',
    '>>',
    '?',
    '? ',
    '@',
    'A',
    'Copyright',
    'I',
    'ICP',
    'Lex',
    'Lex ',
    '[',
    ']',
    '^',
    '_',
    '`',
    '``',
    '{',
    '|',
    '}',
    '~',
    '~~~~',
    '¡',
    '¦',
    '«',
    '­',
    '¯',
    '´',
    '·',
    '¸',
    '»',
    '¿',
    '×',
    '× ',
    '×××',
    '××× ',
    'ˇ',
    'ˉ',
    'ˊ',
    'ˋ',
    '˜',
    'Δ',
    'Ψ',
    'γ',
    'μ',
    'φ',
    'φ．',
    'В',
    '‐',
    '–',
    '—',
    '——',
    '———',
    '—　',
    '―',
    '‖',
    '‘',
    '’',
    '’‘',
    '’‘ ',
    '‛',
    '“',
    '“ ',
    '”',
    '” ',
    '”，',
    '„',
    '‟',
    '•',
    '…',
    '……',
    '…………………………………………………③',
    '‧',
    '′∈',
    '′｜',
    '‹',
    '›',
    '℃',
    '℃ ',
    'Ⅲ',
    '↑',
    '→',
    '∈［',
    '∈［ ',
    '∕',
    '∪φ∈',
    '≈',
    '≈ ',
    '①',
    '②',
    '②ｃ',
    '③',
    '③］',
    '④',
    '⑤',
    '⑥',
    '⑦',
    '⑧',
    '⑨',
    '⑩',
    '──',
    '■',
    '▲',
    '　',
    '、',
    '、 ',
    '。',
    '。 ',
    '〃',
    '〈',
    '〉',
    '《',
    '《 ',
    '》',
    '》 ',
    '》），',
    '「',
    '」',
    '『',
    '』',
    '【',
    '】',
    '〔',
    '〕',
    '〕〔',
    '〖',
    '〗',
    '〘',
    '〙',
    '〚',
    '〛',
    '〜',
    '〝',
    '〞',
    '〟',
    '〰',
    '〾',
    '〿',
    '㈧',
    '㈧ ',
    '一',
    '一 ',
    '一.',
    '一一',
]

_STOPWORDS_ENGLISH = [
    'a',
    'aboard',
    'about',
    'above',
    'according',
    'according to',
    'across',
    'afore',
    'after',
    'afterwards',
    'again',
    'against',
    'agin',
    'all',
    'almost',
    'alone',
    'along',
    'alongside',
    'already',
    'also',
    'although',
    'always',
    'am',
    'amid',
    'amidst',
    'among',
    'amongst',
    'amoungst',
    'amount',
    'an',
    'and',
    'anent',
    'another',
    'any',
    'anyhow',
    'anyone',
    'anything',
    'anyway',
    'anywhere',
    'approximately',
    'are',
    'around',
    'as',
    'asked',
    'aslant',
    'astride',
    'at',
    'athwart',
    'back',
    'bar',
    'be',
    'became',
    'because',
    'because of',
    'become',
    'becomes',
    'becoming',
    'been',
    'before',
    'beforehand',
    'behind',
    'being',
    'below',
    'beneath',
    'beside',
    'besides',
    'between',
    'betwixt',
    'beyond',
    'bill',
    'both',
    'bottom',
    'but',
    'by',
    'call',
    'called',
    'can',
    'cannot',
    'cant',
    'circa',
    'co',
    'computer',
    'con',
    'copyright',
    'could',
    'couldnt',
    'cry',
    'currently',
    'dare',
    'de',
    'describe',
    'despite',
    'detail',
    'did',
    'do',
    'does',
    'done',
    'down',
    'dr',
    'due',
    'due to',
    'during',
    'e.g.,',
    'each',
    'earlier',
    'eg',
    'eight',
    'either',
    'eleven',
    'else',
    'elsewhere',
    'empty',
    'enough',
    'ere',
    'etc',
    'even',
    'eventually',
    'ever',
    'every',
    'everyone',
    'everything',
    'everywhere',
    'except',
    'exp',
    'exp ',
    'few',
    'fifteen',
    'fify',
    'fill',
    'find',
    'fire',
    'first',
    'five',
    'for',
    'former',
    'formerly',
    'forty',
    'found',
    'four',
    'from',
    'front',
    'full',
    'further',
    'get',
    'give',
    'go',
    'had',
    'has',
    'hasnt',
    'have',
    'he',
    'hence',
    'her',
    'here',
    'hereafter',
    'hereby',
    'herein',
    'hereupon',
    'hers',
    'herself',
    'him',
    'himself',
    'his',
    'how',
    'however',
    'hundred',
    'i',
    'ie',
    'if',
    'in',
    'inc',
    'indeed',
    'inside',
    'instead',
    'interest',
    'into',
    'is',
    'it',
    'its',
    'itself',
    'just',
    'keep',
    'last',
    'latter',
    'latterly',
    'least',
    'less',
    'like',
    'ltd',
    'made',
    'major',
    'many',
    'may',
    'maybe',
    'me',
    'meanwhile',
    'mid',
    'midst',
    'might',
    'mill',
    'mine',
    'minus',
    'more',
    'moreover',
    'most',
    'mostly',
    'move',
    'mr',
    'mrs',
    'ms',
    'much',
    'must',
    'my',
    'myself',
    'name',
    'namely',
    'near',
    'need',
    'neither',
    'net',
    'never',
    'nevertheless',
    'next',
    'nigh',
    'nigher',
    'nighest',
    'nine',
    'no',
    'nobody',
    'none',
    'noone',
    'nor',
    'not',
    'nothing',
    'notwithstanding',
    'now',
    'nowhere',
    'of',
    'off',
    'often',
    'on',
    'on to',
    'once',
    'one',
    'only',
    'onto',
    'or',
    'other',
    'others',
    'otherwise',
    'ought',
    'our',
    'ours',
    'ourselves',
    'out',
    'out of',
    'outside',
    'over',
    'own',
    'part',
    'partly',
    'past',
    'pending',
    'per',
    'perhaps',
    'please',
    'plus',
    'prior',
    'put',
    'qua',
    'rather',
    're',
    'regarding',
    'round',
    'same',
    'sans',
    'save',
    'see',
    'seem',
    'seemed',
    'seeming',
    'seems',
    'separately',
    'serious',
    'seven',
    'several',
    'shall',
    'she',
    'should',
    'show',
    'side',
    'similarly',
    'since',
    'sincere',
    'six',
    'sixty',
    'so',
    'some',
    'somehow',
    'someone',
    'something',
    'sometime',
    'sometimes',
    'somewhere',
    'still',
    'sub',
    'such',
    'sup',
    'system',
    'take',
    'ten',
    'than',
    'that',
    'the',
    'their',
    'theirs',
    'them',
    'themselves',
    'then',
    'thence',
    'there',
    'thereafter',
    'thereby',
    'therefore',
    'therein',
    'thereupon',
    'these',
    'they',
    'thick',
    'thin',
    'third',
    'this',
    'those',
    'though',
    'three',
    'through',
    'throughout',
    'thru',
    'thus',
    'till',
    'to',
    'together',
    'too',
    'top',
    'toward',
    'towards',
    'twelve',
    'twenty',
    'two',
    'un',
    'under',
    'underneath',
    'unless',
    'unlike',
    'until',
    'unto',
    'up',
    'upon',
    'us',
    'versus',
    'very',
    'via',
    'vice',
    'volume',
    'was',
    'we',
    'well',
    'were',
    'what',
    'whatever',
    'whats',
    'when',
    'whence',
    'whenever',
    'where',
    'after',
    'whereas',
    'whereby',
    'wherein',
    'whereupon',
    'wherever',
    'whether',
    'which',
    'while',
    'whither',
    'who',
    'whoever',
    'whole',
    'whom',
    'whose',
    'why',
    'will',
    'with',
    'within',
    'without',
    'would',
    'yesterday',
    'yet',
    'you',
    'your',
    'yours',
    'yourself',
    'yourselves',
    'com',
    'hk',
    'end',
    '-END-',
]

_STOPWORDS_CHINESE = [
    '的',
    '是',
    '不',
    '在',
    '和',
    '年',
    '月',
    '日',
    '天',
    '了',
    '是',
    '为',
    '及',
    '等',
    '号',
    '不',
    '有',
    '中',
    '或',
    '对',
    '与',
    '本',
    '并',
    '也',
    '上',
    '都',
    '到',
    '以',
    '被',
    '一',
    '又',
    '且',
    '中国',
    '既',
    '但',
    '可',
    '应',
    '可以',
    '时',
    '分',
    '秒',
    '台',
    '包括',
    '后',
    '需',
    '能',
    '内',
    '即',
    '之',
    '以上',
    '含',
    '至',
    '于',
    '个',
    '板',
    '张',
    '件',
    '绝缘',
    '用',
    '米',
    '控制',
    '电缆',
]

_DAYS = ['{}日'.format(digit) for digit in range(1, 32)]

_MONTHS = [
    '1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月', '9月', '10月', '11月', '12月',
    '一月', '二月', '三月', '四月', '五月', '六月', '七月', '八月', '九月', '十月', '十一月', '十二月',
]

_YEARS = ['{}年'.format(year) for year in range(1950, 2050)]

_YEARS_CHINESE = dates.generate_chinese_year_ranges()

_DIGITS = [str(digit) for digit in range(0, 5000)]

_STOPWORDS_GENERAL = _DAYS + _MONTHS + _YEARS + _YEARS_CHINESE + _DIGITS

STOPWORDS = frozenset(
    _NON_TEXT +
    _STOPWORDS_ENGLISH +
    _STOPWORDS_CHINESE +
    _STOPWORDS_GENERAL
)


def get_stopwords(stopwords_path: str):
    if stopwords_path is None:
        return STOPWORDS

    file_path = hao.path.get(stopwords_path)
    if not os.path.exists(file_path):
        LOGGER.warning(f"stopwords file not found: {stopwords_path}")
        return frozenset(_STOPWORDS_GENERAL)
    return frozenset(
        [
            line.strip()
            for line in open(file_path).readlines()
            if len(line.strip()) > 0
        ] + _STOPWORDS_GENERAL
    )
