__BRYTHON__.use_VFS = true;
var scripts = {"$timestamp": 1635674873366, "array": [".js", "var $module = (function($B){\n\nvar _b_ = $B.builtins\n\nvar typecodes = {\n    'b': Int8Array,    // signed char, 1 byte\n    'B': Uint8Array,   // unsigned char, 1\n    'u': Uint32Array,  // Py_UNICODE Unicode character, 2 (deprecated)\n    'h': Int16Array,   // signed short, 2\n    'H': Uint16Array,  // unsigned short, 2\n    'i': Int16Array,   //  signed int, 2\n    'I': Uint16Array,  // unsigned int, 2\n    'l': Int32Array,   // signed long, 4\n    'L': Uint32Array,  // unsigned long, 4\n    'q': null,         // signed long, 8 (not implemented)\n    'Q': null,         // unsigned long, 8 (not implemented)\n    'f': Float32Array, // float, 4\n    'd': Float64Array  // double float, 8\n}\n\nvar array = $B.make_class(\"array\",\n    function(){\n        var missing = {},\n            $ = $B.args(\"array\", 2, {typecode: null, initializer: null},\n                [\"typecode\", \"initializer\"], arguments, {initializer: missing},\n                null, null),\n            typecode = $.typecode,\n            initializer = $.initializer\n        if(! typecodes.hasOwnProperty(typecode)){\n            throw _b_.ValueError.$factory(\"bad typecode (must be b, \" +\n                \"B, u, h, H, i, I, l, L, q, Q, f or d)\")\n        }\n        if(typecodes[typecode] === null){\n            console.log(\"array factory, $\", $, typecode)\n            throw _b_.NotImplementedError.$factory(\"type code \" +\n                typecode + \" is not implemented\")\n        }\n        var res = {\n            __class__: array,\n            typecode: typecode,\n            obj: null\n        }\n        if(initializer !== missing){\n            if(Array.isArray(initializer)){\n                array.fromlist(res, initializer)\n            }else if(_b_.isinstance(initializer, _b_.bytes)){\n                array.frombytes(res, initializer)\n            }else{\n                array.extend(res, initializer)\n            }\n        }\n        return res\n    }\n)\n\narray.$buffer_protocol = true\narray.$match_sequence_pattern = true // for Pattern Matching (PEP 634)\n\narray.__getitem__ = function(self, key){\n    if(self.obj && self.obj[key] !== undefined){\n        return self.obj[key]\n    }\n    throw _b_.IndexError(\"array index out of range\")\n}\n\nvar array_iterator = $B.make_iterator_class(\"array_iterator\")\narray.__iter__ = function(self){\n    return array_iterator.$factory(self.obj === null ? [] : self.obj)\n}\n\narray.__len__ = function(self){\n    return self.obj === null ? 0 : self.obj.length\n}\n\narray.__str__ = function(self){\n    $B.args(\"__str__\", 1, {self: null},\n        [\"self\"], arguments, {}, null, null)\n    var res = \"array('\" + self.typecode + \"'\"\n    if(self.obj !== null){\n        res += \", [\" + self.obj + \"]\"\n    }\n    return res + \")\"\n}\n\nfunction normalize_index(self, i){\n    // return an index i between 0 and self.obj.length - 1\n    if(i < 0){\n        i = self.obj.length + i\n    }\n    if(i < 0){i = 0}\n    else if(i > self.obj.length - 1){\n        i = self.obj.length\n    }\n    return i\n}\n\narray.append = function(self, value){\n    $B.args(\"append\", 2, {self: null, value: null},\n        [\"self\", \"value\"], arguments, {}, null, null)\n    var pos = self.obj === null ? 0 : self.obj.length\n    return array.insert(self, pos, value)\n}\n\narray.count = function(self, x){\n    $B.args(\"count\", 2, {self: null, x: null},\n        [\"self\", \"x\"], arguments, {}, null, null)\n    if(self.obj === null){return 0}\n    return self.obj.filter(function(item){return item == x}).length\n}\n\narray.extend = function(self, iterable){\n    $B.args(\"extend\", 2, {self: null, iterable: null},\n        [\"self\", \"iterable\"], arguments, {}, null, null)\n    if(iterable.__class__ === array){\n        if(iterable.typecode !== self.typecode){\n            throw _b_.TypeError.$factory(\"can only extend with array \" +\n                \"of same kind\")\n        }\n        if(iterable.obj === null){return _b_.None}\n        // create new object with length = sum of lengths\n        var newobj = new typecodes[self.typecode](self.obj.length +\n            iterable.obj.length)\n        // copy self.obj\n        newobj.set(self.obj)\n        // copy iterable.obj\n        newobj.set(iterable.obj, self.obj.length)\n        self.obj = newobj\n    }else{\n        var it = _b_.iter(iterable)\n        while(true){\n            try{\n                var item = _b_.next(it)\n                array.append(self, item)\n            }catch(err){\n                if(err.__class__ !== _b_.StopIteration){\n                    throw err\n                }\n                break\n            }\n        }\n    }\n    return _b_.None\n}\n\narray.frombytes = function(self, s){\n    $B.args(\"frombytes\", 2, {self: null, s: null},\n        [\"self\", \"s\"], arguments, {}, null, null)\n    if(! _b_.isinstance(s, _b_.bytes)){\n        throw _b_.TypeError.$factory(\"a bytes-like object is required, \" +\n            \"not '\" + $B.class_name(s) + \"'\")\n    }\n    self.obj = new typecodes[self.typecode](s.source)\n    return _b_.None\n}\n\narray.fromlist = function(self, list){\n    $B.args(\"fromlist\", 2, {self: null, list: null},\n        [\"self\", \"list\"], arguments, {}, null, null)\n    var it = _b_.iter(list)\n    while(true){\n        try{\n            var item = _b_.next(it)\n            try{\n                array.append(self, item)\n            }catch(err){\n                console.log(err)\n                return _b_.None\n            }\n        }catch(err){\n            if(err.__class__ === _b_.StopIteration){\n                return _b_.None\n            }\n            throw err\n        }\n    }\n}\n\narray.fromstring = array.frombytes\n\narray.index = function(self, x){\n    $B.args(\"index\", 2, {self: null, x: null},\n        [\"self\", \"x\"], arguments, {}, null, null)\n    var res = self.obj.findIndex(function(item){return x == item})\n    if(res == -1){\n        throw _b_.ValueError.$factory(\"array.index(x): x not in array\")\n    }\n    return res\n}\n\narray.insert = function(self, i, value){\n    $B.args(\"insert\", 3, {self: null, i: null, value: null},\n        [\"self\", \"i\", \"value\"], arguments, {}, null, null)\n    if(self.obj === null){\n        self.obj = [value]\n    }else{\n        self.obj.splice(i, 0, value)\n    }\n    return _b_.None\n}\n\narray.itemsize = function(self){\n    return typecodes[self.typecode].BYTES_PER_ELEMENT\n}\n\narray.pop = function(self, i){\n    var $ = $B.args(\"count\", 2, {self: null, i: null},\n        [\"self\", \"i\"], arguments, {i: -1}, null, null)\n    i = $.i\n    if(self.obj === null){\n        throw _b_.IndexError.$factory(\"pop from empty array\")\n    }else if(self.obj.length == 1){\n        var res = self.obj[0]\n        self.obj = null\n        return res\n    }\n    i = normalize_index(self, i)\n    // store value to return\n    var res = self.obj[i]\n    // create new array, size = previous size - 1\n    var newobj = new typecodes[self.typecode](self.obj.length - 1)\n    // fill new array with values until i excluded\n    newobj.set(self.obj.slice(0, i))\n    // fill with values after i\n    newobj.set(self.obj.slice(i + 1), i)\n    // set self.obj to new array\n    self.obj = newobj\n    // return stored value\n    return res\n}\n\narray.remove = function(self, x){\n    $B.args(\"remove\", 2, {self: null, x: null},\n        [\"self\", \"x\"], arguments, {}, null, null)\n    var res = self.obj.findIndex(function(item){return x == item})\n    if(res == -1){\n        throw _b_.ValueError.$factory(\"array.remove(x): x not in array\")\n    }\n    array.pop(self, res)\n    return _b_.None\n}\n\narray.reverse = function(self){\n    $B.args(\"reverse\", 1, {self: null},\n        [\"self\"], arguments, {}, null, null)\n    if(self.obj === null){return _b_.None}\n    self.obj.reverse()\n    return _b_.None\n}\n\narray.tobytes = function(self){\n    $B.args(\"tobytes\", 1, {self: null},\n        [\"self\"], arguments, {}, null, null)\n    var items = Array.prototype.slice.call(self.obj),\n        res = []\n    items.forEach(function(item){\n        while(item > 256){\n            res.push(item % 256)\n            item = Math.floor(item / 256)\n        }\n        res.push(item)\n    })\n    return _b_.bytes.$factory(res)\n}\n\narray.tolist = function(self){\n    $B.args(\"tolist\", 1, {self: null},\n        [\"self\"], arguments, {}, null, null)\n    if(self.obj === null){\n        return $B.$list([])\n    }\n    return Array.prototype.slice.call(self.obj)\n}\n\narray.tostring = array.tobytes\n\narray.typecode = function(self){\n    return self.typecode\n}\n\n$B.set_func_names(array, \"array\")\n\nreturn {\n    array: array,\n    typecodes: Object.keys(typecodes).join('')\n}\n\n})(__BRYTHON__)\n"], "bry_re": [".js", "var $module = (function($B){\n\n_b_ = $B.builtins\n\nfunction translate(py_pattern){\n    // Translate Python RE syntax to Javascript's\n    return py_pattern.replace(/\\(\\?P</g, '(?<')\n}\n\nfunction str_or_bytes(string, pattern){\n    if(typeof string == \"string\" || _b_.isinstance(string, _b_.str)){\n        string = string + '' // for string subclasses\n        if(typeof pattern == \"string\" || _b_.isinstance(pattern, _b_.str)){\n            pattern = pattern + ''\n        }else{\n            throw _b_.TypeError.$factory(`cannot use a `+\n                `${$B.class_name(pattern)} pattern on a string-like object`)\n        }\n        return {type: _b_.str, string, pattern}\n    }else if(_b_.isinstance(string, [_b_.bytes, _b_.bytearray, _b_.memoryview])){\n        if(! _b_.isinstance(pattern, [_b_.bytes, _b_.bytearray, _b_.memoryview])){\n            throw _b_.TypeError(`cannot use a ${$B.class_name(pattern)}` +\n                ' pattern on a bytes-like object')\n        }\n        return {\n            type: _b_.bytes,\n            string: _b_.bytes.decode(_b_.bytes.$factory(string), 'latin1'),\n            pattern: _b_.bytes.decode(_b_.bytes.$factory(pattern), 'latin1')\n        }\n    }else{\n        throw _b_.TypeError.$factory(\"invalid string type: \" +\n            $B.class_name(string))\n    }\n}\n\nvar MatchObject = $B.make_class(\"MatchObject\",\n    function(res){\n        return {\n            __class__: MatchObject,\n            res: res\n        }\n    }\n)\n\nMatchObject.__getitem__ = function(){\n    var $ = $B.args(\"__getitem__\", 2, {self: null, group: null},\n                ['self', 'group'], arguments, {group: 0}, null, null)\n    return group($.self.res, $.group)\n}\n\nMatchObject.__iter__ = function(self){\n    return _b_.iter(_b_.list.$factory(MatchObject.groupdict(self)))\n}\n\nMatchObject.__setitem__ = function(){\n    throw _b_.TypeError.$factory(\"MatchObject is readonly\")\n}\n\nMatchObject.__str__ = function(self){\n    var match = self.string.substring(self.start, self.end)\n    return `<re.Match object; span=${_b_.str.$factory(self.span)}, match='${match}'>`\n}\n\nfunction group(res, rank){\n    if(typeof rank == \"number\"){\n        if(rank < 0 || rank >= res.length){\n            throw _b_.IndexError.$factory(\"no such group\")\n        }else if(res[rank] === undefined){\n            return _b_.None\n        }\n        return res[rank]\n    }else if(_b_.isinstance(rank, _b_.int)){\n        if($B.rich_comp('__lt__', rank, 0) ||\n                $B.rich_comp('__ge__', rank, res.length)){\n            throw _b_.IndexError.$factory(\"no such group\")\n        }else if(res[rank] === undefined){\n            return _b_.None\n        }\n        return res[rank]\n    }else if(typeof rank == \"string\"){\n        if(res.groups && Object.keys(res.groups).indexOf(rank) > -1){\n            if(res.groups[rank] === undefined){\n                return _b_.None\n            }else{\n                return res.groups[rank]\n            }\n        }else{\n            throw _b_.IndexError.$factory(\"no such group\")\n        }\n    }else{\n        try{\n            var rank = $B.$GetInt(rank)\n        }catch(err){\n            throw _b_.IndexError.$factory(\"no such group\")\n        }\n        return group(res, rank)\n    }\n}\n\nfunction to_bytes(mo){\n    // Transform strings in a MatchObject to bytes\n    mo.string = _b_.str.encode(mo.string, 'latin1')\n    mo.res.forEach(function(item, rank){\n        if(item !== undefined){\n            mo.res[rank] = _b_.str.encode(item, 'latin1')\n        }\n    })\n}\n\nMatchObject.group = function(){\n    var $ = $B.args(\"group\", 2, {self: null, rank: null}, ['self', 'rank'],\n                    arguments, {rank: 0}, 'ranks', null),\n            self = $.self,\n            rank = $.rank,\n            ranks = $.ranks\n    var first = group(self.res, rank)\n    if(ranks.length == 0){\n        return first\n    }else{\n        var result = [first]\n        for(var rank of ranks){\n            result.push(group(self.res, rank))\n        }\n        return $B.fast_tuple(result)\n    }\n}\n\nMatchObject.groupdict = function(){\n    var $ = $B.args(\"group\", 2, {self: null, default: null}, ['self', 'default'],\n                    arguments, {default: _b_.None}, null, null),\n            self = $.self,\n            _default = $.default\n    var d = $B.empty_dict()\n    if(self.res.groups){\n        for(var key in self.res.groups){\n            if(self.res.groups[key] === undefined){\n                _b_.dict.$setitem(d, key, _default)\n            }else{\n                _b_.dict.$setitem(d, key, self.res.groups[key])\n            }\n        }\n    }\n    return d\n}\n\nMatchObject.groups = function(self, _default){\n    var groups = self.res.slice(1)\n    groups.forEach(function(item, rank){\n        if(item === undefined){\n            groups[rank] = _default === undefined ? _b_.None : _default\n        }\n    })\n    return $B.fast_tuple(groups)\n}\n\nMatchObject.span = function(){\n    var $ = $B.args(\"span\", 2, {self: null, group: null}, ['self', 'group'],\n                    arguments, {group: 0}, null, null),\n            self = $.self,\n            group = $.group\n    if(group == 0){\n        return $B.fast_tuple([self.start, self.end])\n    }\n}\n$B.set_func_names(MatchObject, \"re\")\n\nvar Pattern = $B.make_class(\"Pattern\",\n    function(pattern, flags){\n        return {\n            __class__: Pattern,\n            pattern: pattern,\n            flags: flags\n        }\n    }\n)\n\nPattern.__str__ = function(self){\n    return `<re.Pattern object>`\n}\n\nPattern.match = function(){\n    var $ = $B.args(\"match\", 3,\n                {self: null, string: null, pos: null, endpos: null},\n                ['self', 'string', 'pos', 'endpos'], arguments,\n                {pos: 0, endpos: _b_.None}, null, null),\n        self = $.self,\n        string = $.string,\n        pos = $.pos,\n        endpos = $.endpos\n    return $match(self.pattern, string)\n}\n\n$B.set_func_names(Pattern, \"re\")\n\n\nfunction compile(){\n    var $ = $B.args(\"compile\", 2, {pattern: null, flags: null},\n                    [\"pattern\", \"flags\"], arguments, {flags: 0},\n                    null, null),\n            pattern = $.pattern,\n            flags = $.flags\n    return Pattern.$factory(pattern, flags)\n}\n\nfunction findall(){\n    var $ = $B.args(\"findall\", 3, {pattern: null, string: null, flags: null},\n                    [\"pattern\", \"string\", \"flags\"], arguments, {flags: 0},\n                    null, null),\n            pattern = $.pattern,\n            string = $.string,\n            flags = $.flags\n    var data = str_or_bytes(string, pattern)\n    if(data.type === _b_.str){\n        return $findall(data.pattern, data.string, flags)\n    }else{\n        var res1 = $findall(data.pattern, data.string, flags),\n            res = []\n        for(const item of res1){\n            if(typeof item == \"string\"){\n                res.push(_b_.str.encode(item, \"latin1\"))\n            }else{\n                res.push($B.fast_tuple(item.map(\n                    function(x){return _b_.str.encode(x, 'latin1')})\n                ))\n            }\n        }\n        return res\n    }\n}\n\nfunction $findall(pattern, string, flags){\n    var res = []\n    try{\n        string.matchAll(translate(pattern))\n    }catch(err){\n        console.log(\"error for\", string)\n        throw err\n    }\n    for(const item of string.matchAll(translate(pattern))){\n        /*\n        If one or more groups are present in the pattern, return a list of\n        groups; this will be a list of tuples if the pattern has more than one\n        group\n        */\n        if(item.length == 1){\n            res.push(item[0])\n        }else if(item.length == 2){\n            res.push(item[1])\n        }else{\n            res.push($B.fast_tuple(item.slice(1)))\n        }\n    }\n    return res\n}\n\nfunction match(){\n    var $ = $B.args(\"match\", 3, {pattern: null, string: null, flags: null},\n                    [\"pattern\", \"string\", \"flags\"], arguments, {flags: 0},\n                    null, null),\n            pattern = $.pattern,\n            string = $.string,\n            flags = $.flags\n    var data = str_or_bytes(string, pattern)\n    if(! data.pattern.startsWith('^')){\n        data.pattern = '^' + data.pattern\n    }\n    if(data.type === _b_.str){\n        return $match(data.pattern, data.string, flags)\n    }else{\n        var mo = $match(data.pattern, data.string, flags)\n        if(mo === _b_.None){\n            return mo\n        }\n        to_bytes(mo)\n        return mo\n    }\n}\n\nfunction $match(pattern, string, flags){\n    var js_pattern = translate(pattern),\n        res = string.match(new RegExp(js_pattern))\n    if(res){\n        var mo = MatchObject.$factory(res)\n        mo.string = string\n        mo.start = 0\n        mo.end = res[0].length\n        return mo\n    }else{\n        return _b_.None\n    }\n}\n\nfunction search(){\n    var $ = $B.args(\"search\", 3, {pattern: null, string: null, flags: null},\n                    [\"pattern\", \"string\", \"flags\"], arguments, {flags: 0},\n                    null, null),\n            pattern = $.pattern,\n            string = $.string,\n            flags = $.flags\n    var data = str_or_bytes(string, pattern)\n    if(data.type === _b_.str){\n        return $search(data.pattern, data.string, flags)\n    }else{\n        var mo = $search(data.pattern, data.string, flags)\n        mo.type = _b_.bytes\n        if(mo === _b_.None){\n            return mo\n        }\n        to_bytes(mo)\n        return mo\n    }\n}\n\nfunction $search(pattern, string, flags){\n    var js_pattern = translate(pattern),\n        pos = string.search(new RegExp(js_pattern))\n    if(pos == -1){\n        return _b_.None\n    }else{\n        var mo = $match(pattern, string.substr(pos), flags)\n        mo.string = string\n        mo.start = pos\n        mo.end = pos + mo.res[0].length\n        return mo\n    }\n}\nreturn  {\n    compile: compile,\n    findall: findall,\n    match: match,\n    search: search\n}\n\n})(__BRYTHON__)\n"], "builtins": [".js", "var $module = (function(){\n    var obj = {\n        __class__: __BRYTHON__.module,\n        __name__: 'builtins'\n    },\n        builtin_names = ['ArithmeticError', 'AssertionError', 'AttributeError',\n    'BaseException', 'BlockingIOError', 'BrokenPipeError', 'BufferError',\n    'BytesWarning', 'ChildProcessError', 'ConnectionAbortedError',\n    'ConnectionError', 'ConnectionRefusedError', 'ConnectionResetError',\n    'DeprecationWarning', 'EncodingWarning', 'EOFError', 'Ellipsis', 'EnvironmentError', 'Exception',\n    'False', 'FileExistsError', 'FileNotFoundError', 'FloatingPointError',\n    'FutureWarning', 'GeneratorExit', 'IOError', 'ImportError', 'ImportWarning',\n    'IndentationError', 'IndexError', 'InterruptedError', 'IsADirectoryError',\n    'KeyError', 'KeyboardInterrupt', 'LookupError', 'MemoryError', 'ModuleNotFoundError', 'NameError',\n    'None', 'NotADirectoryError', 'NotImplemented', 'NotImplementedError',\n    'OSError', 'OverflowError', 'PendingDeprecationWarning', 'PermissionError',\n    'ProcessLookupError', 'RecursionError', 'ReferenceError', 'ResourceWarning', 'RuntimeError',\n    'RuntimeWarning', 'StopIteration', 'StopAsyncIteration', 'SyntaxError', 'SyntaxWarning',\n    'SystemError', 'SystemExit', 'TabError', 'TimeoutError', 'True', 'TypeError',\n    'UnboundLocalError', 'UnicodeDecodeError', 'UnicodeEncodeError',\n    'UnicodeError', 'UnicodeTranslateError', 'UnicodeWarning', 'UserWarning',\n    'ValueError', 'Warning', 'WindowsError', 'ZeroDivisionError', '_',\n    '__build_class__', '__debug__', '__doc__', '__import__', '__name__',\n    'abs', 'aiter', 'all', 'anext', 'any', 'ascii', 'bin', 'bool', 'breakpoint', 'bytearray',\n    'bytes','callable', 'chr', 'classmethod', 'compile', 'complex', 'copyright',\n    'credits','delattr', 'dict', 'dir', 'divmod', 'enumerate', 'eval', 'exec',\n    'exit', 'filter', 'float', 'format', 'frozenset', 'getattr', 'globals',\n    'hasattr', 'hash', 'help', 'hex', 'id', 'input', 'int', 'isinstance',\n    'issubclass', 'iter', 'len', 'license', 'list', 'locals', 'map', 'max',\n    'memoryview', 'min', 'next', 'object', 'oct', 'open', 'ord', 'pow', 'print',\n    'property', 'quit', 'range', 'repr', 'reversed', 'round', 'set', 'setattr',\n    'slice', 'sorted', 'staticmethod', 'str', 'sum', 'super', 'tuple', 'type',\n    'vars', 'zip',\n    '__newobj__' // defined in py_objects.js ; required for pickle\n    ]\n    for(var i = 0, len = builtin_names.length; i < len; i++){\n        try{eval(\"obj['\" + builtin_names[i] + \"'] = __BRYTHON__.builtins.\" +\n            builtin_names[i])}\n        catch(err){if (__BRYTHON__.$debug) {console.log(err)}}\n    }\n    obj.__doc__ = 'builtins module'\n    obj.copyright = 'CPython copyright'\n    obj.credits = 'CPython builtins credits'\n    obj.license = 'CPython license'\n    return obj\n})()\n"], "dis": [".js", "var $module=(function($B){\n\nvar dict = $B.builtins.dict\nvar mod = {\n    dis:function(src){\n        $B.$py_module_path['__main__'] = $B.brython_path\n        return __BRYTHON__.py2js(src,'__main__','__main__',\n            $B.builtins_scope).to_js()\n    },\n    OPTIMIZED: 1,\n    NEWLOCALS: 2,\n    VARARGS: 4,\n    VARKEYWORDS: 8,\n    NESTED: 16,\n    GENERATOR: 32,\n    NOFREE: 64,\n    COROUTINE: 128,\n    ITERABLE_COROUTINE: 256,\n    ASYNC_GENERATOR: 512,\n    COMPILER_FLAG_NAMES: $B.builtins.dict.$factory()\n}\nmod.COMPILER_FLAG_NAMES = dict.$factory([\n     [1, \"OPTIMIZED\"],\n     [2, \"NEWLOCALS\"],\n     [4, \"VARARGS\"],\n     [8, \"VARKEYWORDS\"],\n    [16, \"NESTED\"],\n    [32, \"GENERATOR\"],\n    [64, \"NOFREE\"],\n   [128, \"COROUTINE\"],\n   [256, \"ITERABLE_COROUTINE\"],\n   [512, \"ASYNC_GENERATOR\"]\n])\n\nreturn mod\n\n})(__BRYTHON__)"], "encoding_cp932": [".js", "var _table = [0x00, 0x0000,0x01, 0x0001,0x02, 0x0002,0x03, 0x0003,0x04, 0x0004,0x05, 0x0005,0x06, 0x0006,0x07, 0x0007,0x08, 0x0008,0x09, 0x0009,0x0A, 0x000A,0x0B, 0x000B,0x0C, 0x000C,0x0D, 0x000D,0x0E, 0x000E,0x0F, 0x000F,0x10, 0x0010,0x11, 0x0011,0x12, 0x0012,0x13, 0x0013,0x14, 0x0014,0x15, 0x0015,0x16, 0x0016,0x17, 0x0017,0x18, 0x0018,0x19, 0x0019,0x1A, 0x001A,0x1B, 0x001B,0x1C, 0x001C,0x1D, 0x001D,0x1E, 0x001E,0x1F, 0x001F,0x20, 0x0020,0x21, 0x0021,0x22, 0x0022,0x23, 0x0023,0x24, 0x0024,0x25, 0x0025,0x26, 0x0026,0x27, 0x0027,0x28, 0x0028,0x29, 0x0029,0x2A, 0x002A,0x2B, 0x002B,0x2C, 0x002C,0x2D, 0x002D,0x2E, 0x002E,0x2F, 0x002F,0x30, 0x0030,0x31, 0x0031,0x32, 0x0032,0x33, 0x0033,0x34, 0x0034,0x35, 0x0035,0x36, 0x0036,0x37, 0x0037,0x38, 0x0038,0x39, 0x0039,0x3A, 0x003A,0x3B, 0x003B,0x3C, 0x003C,0x3D, 0x003D,0x3E, 0x003E,0x3F, 0x003F,0x40, 0x0040,0x41, 0x0041,0x42, 0x0042,0x43, 0x0043,0x44, 0x0044,0x45, 0x0045,0x46, 0x0046,0x47, 0x0047,0x48, 0x0048,0x49, 0x0049,0x4A, 0x004A,0x4B, 0x004B,0x4C, 0x004C,0x4D, 0x004D,0x4E, 0x004E,0x4F, 0x004F,0x50, 0x0050,0x51, 0x0051,0x52, 0x0052,0x53, 0x0053,0x54, 0x0054,0x55, 0x0055,0x56, 0x0056,0x57, 0x0057,0x58, 0x0058,0x59, 0x0059,0x5A, 0x005A,0x5B, 0x005B,0x5C, 0x005C,0x5D, 0x005D,0x5E, 0x005E,0x5F, 0x005F,0x60, 0x0060,0x61, 0x0061,0x62, 0x0062,0x63, 0x0063,0x64, 0x0064,0x65, 0x0065,0x66, 0x0066,0x67, 0x0067,0x68, 0x0068,0x69, 0x0069,0x6A, 0x006A,0x6B, 0x006B,0x6C, 0x006C,0x6D, 0x006D,0x6E, 0x006E,0x6F, 0x006F,0x70, 0x0070,0x71, 0x0071,0x72, 0x0072,0x73, 0x0073,0x74, 0x0074,0x75, 0x0075,0x76, 0x0076,0x77, 0x0077,0x78, 0x0078,0x79, 0x0079,0x7A, 0x007A,0x7B, 0x007B,0x7C, 0x007C,0x7D, 0x007D,0x7E, 0x007E,0x7F, 0x007F,0x80, -1,0x81, -1,0x82, -1,0x83, -1,0x84, -1,0x85, -1,0x86, -1,0x87, -1,0x88, -1,0x89, -1,0x8A, -1,0x8B, -1,0x8C, -1,0x8D, -1,0x8E, -1,0x8F, -1,0x90, -1,0x91, -1,0x92, -1,0x93, -1,0x94, -1,0x95, -1,0x96, -1,0x97, -1,0x98, -1,0x99, -1,0x9A, -1,0x9B, -1,0x9C, -1,0x9D, -1,0x9E, -1,0x9F, -1,0xA0, -1,0xA1, 0xFF61,0xA2, 0xFF62,0xA3, 0xFF63,0xA4, 0xFF64,0xA5, 0xFF65,0xA6, 0xFF66,0xA7, 0xFF67,0xA8, 0xFF68,0xA9, 0xFF69,0xAA, 0xFF6A,0xAB, 0xFF6B,0xAC, 0xFF6C,0xAD, 0xFF6D,0xAE, 0xFF6E,0xAF, 0xFF6F,0xB0, 0xFF70,0xB1, 0xFF71,0xB2, 0xFF72,0xB3, 0xFF73,0xB4, 0xFF74,0xB5, 0xFF75,0xB6, 0xFF76,0xB7, 0xFF77,0xB8, 0xFF78,0xB9, 0xFF79,0xBA, 0xFF7A,0xBB, 0xFF7B,0xBC, 0xFF7C,0xBD, 0xFF7D,0xBE, 0xFF7E,0xBF, 0xFF7F,0xC0, 0xFF80,0xC1, 0xFF81,0xC2, 0xFF82,0xC3, 0xFF83,0xC4, 0xFF84,0xC5, 0xFF85,0xC6, 0xFF86,0xC7, 0xFF87,0xC8, 0xFF88,0xC9, 0xFF89,0xCA, 0xFF8A,0xCB, 0xFF8B,0xCC, 0xFF8C,0xCD, 0xFF8D,0xCE, 0xFF8E,0xCF, 0xFF8F,0xD0, 0xFF90,0xD1, 0xFF91,0xD2, 0xFF92,0xD3, 0xFF93,0xD4, 0xFF94,0xD5, 0xFF95,0xD6, 0xFF96,0xD7, 0xFF97,0xD8, 0xFF98,0xD9, 0xFF99,0xDA, 0xFF9A,0xDB, 0xFF9B,0xDC, 0xFF9C,0xDD, 0xFF9D,0xDE, 0xFF9E,0xDF, 0xFF9F,0xE0, -1,0xE1, -1,0xE2, -1,0xE3, -1,0xE4, -1,0xE5, -1,0xE6, -1,0xE7, -1,0xE8, -1,0xE9, -1,0xEA, -1,0xEB, -1,0xEC, -1,0xED, -1,0xEE, -1,0xEF, -1,0xF0, -1,0xF1, -1,0xF2, -1,0xF3, -1,0xF4, -1,0xF5, -1,0xF6, -1,0xF7, -1,0xF8, -1,0xF9, -1,0xFA, -1,0xFB, -1,0xFC, -1,0xFD, -1,0xFE, -1,0xFF, -1,0x8140, 0x3000,0x8141, 0x3001,0x8142, 0x3002,0x8143, 0xFF0C,0x8144, 0xFF0E,0x8145, 0x30FB,0x8146, 0xFF1A,0x8147, 0xFF1B,0x8148, 0xFF1F,0x8149, 0xFF01,0x814A, 0x309B,0x814B, 0x309C,0x814C, 0x00B4,0x814D, 0xFF40,0x814E, 0x00A8,0x814F, 0xFF3E,0x8150, 0xFFE3,0x8151, 0xFF3F,0x8152, 0x30FD,0x8153, 0x30FE,0x8154, 0x309D,0x8155, 0x309E,0x8156, 0x3003,0x8157, 0x4EDD,0x8158, 0x3005,0x8159, 0x3006,0x815A, 0x3007,0x815B, 0x30FC,0x815C, 0x2015,0x815D, 0x2010,0x815E, 0xFF0F,0x815F, 0xFF3C,0x8160, 0xFF5E,0x8161, 0x2225,0x8162, 0xFF5C,0x8163, 0x2026,0x8164, 0x2025,0x8165, 0x2018,0x8166, 0x2019,0x8167, 0x201C,0x8168, 0x201D,0x8169, 0xFF08,0x816A, 0xFF09,0x816B, 0x3014,0x816C, 0x3015,0x816D, 0xFF3B,0x816E, 0xFF3D,0x816F, 0xFF5B,0x8170, 0xFF5D,0x8171, 0x3008,0x8172, 0x3009,0x8173, 0x300A,0x8174, 0x300B,0x8175, 0x300C,0x8176, 0x300D,0x8177, 0x300E,0x8178, 0x300F,0x8179, 0x3010,0x817A, 0x3011,0x817B, 0xFF0B,0x817C, 0xFF0D,0x817D, 0x00B1,0x817E, 0x00D7,0x8180, 0x00F7,0x8181, 0xFF1D,0x8182, 0x2260,0x8183, 0xFF1C,0x8184, 0xFF1E,0x8185, 0x2266,0x8186, 0x2267,0x8187, 0x221E,0x8188, 0x2234,0x8189, 0x2642,0x818A, 0x2640,0x818B, 0x00B0,0x818C, 0x2032,0x818D, 0x2033,0x818E, 0x2103,0x818F, 0xFFE5,0x8190, 0xFF04,0x8191, 0xFFE0,0x8192, 0xFFE1,0x8193, 0xFF05,0x8194, 0xFF03,0x8195, 0xFF06,0x8196, 0xFF0A,0x8197, 0xFF20,0x8198, 0x00A7,0x8199, 0x2606,0x819A, 0x2605,0x819B, 0x25CB,0x819C, 0x25CF,0x819D, 0x25CE,0x819E, 0x25C7,0x819F, 0x25C6,0x81A0, 0x25A1,0x81A1, 0x25A0,0x81A2, 0x25B3,0x81A3, 0x25B2,0x81A4, 0x25BD,0x81A5, 0x25BC,0x81A6, 0x203B,0x81A7, 0x3012,0x81A8, 0x2192,0x81A9, 0x2190,0x81AA, 0x2191,0x81AB, 0x2193,0x81AC, 0x3013,0x81B8, 0x2208,0x81B9, 0x220B,0x81BA, 0x2286,0x81BB, 0x2287,0x81BC, 0x2282,0x81BD, 0x2283,0x81BE, 0x222A,0x81BF, 0x2229,0x81C8, 0x2227,0x81C9, 0x2228,0x81CA, 0xFFE2,0x81CB, 0x21D2,0x81CC, 0x21D4,0x81CD, 0x2200,0x81CE, 0x2203,0x81DA, 0x2220,0x81DB, 0x22A5,0x81DC, 0x2312,0x81DD, 0x2202,0x81DE, 0x2207,0x81DF, 0x2261,0x81E0, 0x2252,0x81E1, 0x226A,0x81E2, 0x226B,0x81E3, 0x221A,0x81E4, 0x223D,0x81E5, 0x221D,0x81E6, 0x2235,0x81E7, 0x222B,0x81E8, 0x222C,0x81F0, 0x212B,0x81F1, 0x2030,0x81F2, 0x266F,0x81F3, 0x266D,0x81F4, 0x266A,0x81F5, 0x2020,0x81F6, 0x2021,0x81F7, 0x00B6,0x81FC, 0x25EF,0x824F, 0xFF10,0x8250, 0xFF11,0x8251, 0xFF12,0x8252, 0xFF13,0x8253, 0xFF14,0x8254, 0xFF15,0x8255, 0xFF16,0x8256, 0xFF17,0x8257, 0xFF18,0x8258, 0xFF19,0x8260, 0xFF21,0x8261, 0xFF22,0x8262, 0xFF23,0x8263, 0xFF24,0x8264, 0xFF25,0x8265, 0xFF26,0x8266, 0xFF27,0x8267, 0xFF28,0x8268, 0xFF29,0x8269, 0xFF2A,0x826A, 0xFF2B,0x826B, 0xFF2C,0x826C, 0xFF2D,0x826D, 0xFF2E,0x826E, 0xFF2F,0x826F, 0xFF30,0x8270, 0xFF31,0x8271, 0xFF32,0x8272, 0xFF33,0x8273, 0xFF34,0x8274, 0xFF35,0x8275, 0xFF36,0x8276, 0xFF37,0x8277, 0xFF38,0x8278, 0xFF39,0x8279, 0xFF3A,0x8281, 0xFF41,0x8282, 0xFF42,0x8283, 0xFF43,0x8284, 0xFF44,0x8285, 0xFF45,0x8286, 0xFF46,0x8287, 0xFF47,0x8288, 0xFF48,0x8289, 0xFF49,0x828A, 0xFF4A,0x828B, 0xFF4B,0x828C, 0xFF4C,0x828D, 0xFF4D,0x828E, 0xFF4E,0x828F, 0xFF4F,0x8290, 0xFF50,0x8291, 0xFF51,0x8292, 0xFF52,0x8293, 0xFF53,0x8294, 0xFF54,0x8295, 0xFF55,0x8296, 0xFF56,0x8297, 0xFF57,0x8298, 0xFF58,0x8299, 0xFF59,0x829A, 0xFF5A,0x829F, 0x3041,0x82A0, 0x3042,0x82A1, 0x3043,0x82A2, 0x3044,0x82A3, 0x3045,0x82A4, 0x3046,0x82A5, 0x3047,0x82A6, 0x3048,0x82A7, 0x3049,0x82A8, 0x304A,0x82A9, 0x304B,0x82AA, 0x304C,0x82AB, 0x304D,0x82AC, 0x304E,0x82AD, 0x304F,0x82AE, 0x3050,0x82AF, 0x3051,0x82B0, 0x3052,0x82B1, 0x3053,0x82B2, 0x3054,0x82B3, 0x3055,0x82B4, 0x3056,0x82B5, 0x3057,0x82B6, 0x3058,0x82B7, 0x3059,0x82B8, 0x305A,0x82B9, 0x305B,0x82BA, 0x305C,0x82BB, 0x305D,0x82BC, 0x305E,0x82BD, 0x305F,0x82BE, 0x3060,0x82BF, 0x3061,0x82C0, 0x3062,0x82C1, 0x3063,0x82C2, 0x3064,0x82C3, 0x3065,0x82C4, 0x3066,0x82C5, 0x3067,0x82C6, 0x3068,0x82C7, 0x3069,0x82C8, 0x306A,0x82C9, 0x306B,0x82CA, 0x306C,0x82CB, 0x306D,0x82CC, 0x306E,0x82CD, 0x306F,0x82CE, 0x3070,0x82CF, 0x3071,0x82D0, 0x3072,0x82D1, 0x3073,0x82D2, 0x3074,0x82D3, 0x3075,0x82D4, 0x3076,0x82D5, 0x3077,0x82D6, 0x3078,0x82D7, 0x3079,0x82D8, 0x307A,0x82D9, 0x307B,0x82DA, 0x307C,0x82DB, 0x307D,0x82DC, 0x307E,0x82DD, 0x307F,0x82DE, 0x3080,0x82DF, 0x3081,0x82E0, 0x3082,0x82E1, 0x3083,0x82E2, 0x3084,0x82E3, 0x3085,0x82E4, 0x3086,0x82E5, 0x3087,0x82E6, 0x3088,0x82E7, 0x3089,0x82E8, 0x308A,0x82E9, 0x308B,0x82EA, 0x308C,0x82EB, 0x308D,0x82EC, 0x308E,0x82ED, 0x308F,0x82EE, 0x3090,0x82EF, 0x3091,0x82F0, 0x3092,0x82F1, 0x3093,0x8340, 0x30A1,0x8341, 0x30A2,0x8342, 0x30A3,0x8343, 0x30A4,0x8344, 0x30A5,0x8345, 0x30A6,0x8346, 0x30A7,0x8347, 0x30A8,0x8348, 0x30A9,0x8349, 0x30AA,0x834A, 0x30AB,0x834B, 0x30AC,0x834C, 0x30AD,0x834D, 0x30AE,0x834E, 0x30AF,0x834F, 0x30B0,0x8350, 0x30B1,0x8351, 0x30B2,0x8352, 0x30B3,0x8353, 0x30B4,0x8354, 0x30B5,0x8355, 0x30B6,0x8356, 0x30B7,0x8357, 0x30B8,0x8358, 0x30B9,0x8359, 0x30BA,0x835A, 0x30BB,0x835B, 0x30BC,0x835C, 0x30BD,0x835D, 0x30BE,0x835E, 0x30BF,0x835F, 0x30C0,0x8360, 0x30C1,0x8361, 0x30C2,0x8362, 0x30C3,0x8363, 0x30C4,0x8364, 0x30C5,0x8365, 0x30C6,0x8366, 0x30C7,0x8367, 0x30C8,0x8368, 0x30C9,0x8369, 0x30CA,0x836A, 0x30CB,0x836B, 0x30CC,0x836C, 0x30CD,0x836D, 0x30CE,0x836E, 0x30CF,0x836F, 0x30D0,0x8370, 0x30D1,0x8371, 0x30D2,0x8372, 0x30D3,0x8373, 0x30D4,0x8374, 0x30D5,0x8375, 0x30D6,0x8376, 0x30D7,0x8377, 0x30D8,0x8378, 0x30D9,0x8379, 0x30DA,0x837A, 0x30DB,0x837B, 0x30DC,0x837C, 0x30DD,0x837D, 0x30DE,0x837E, 0x30DF,0x8380, 0x30E0,0x8381, 0x30E1,0x8382, 0x30E2,0x8383, 0x30E3,0x8384, 0x30E4,0x8385, 0x30E5,0x8386, 0x30E6,0x8387, 0x30E7,0x8388, 0x30E8,0x8389, 0x30E9,0x838A, 0x30EA,0x838B, 0x30EB,0x838C, 0x30EC,0x838D, 0x30ED,0x838E, 0x30EE,0x838F, 0x30EF,0x8390, 0x30F0,0x8391, 0x30F1,0x8392, 0x30F2,0x8393, 0x30F3,0x8394, 0x30F4,0x8395, 0x30F5,0x8396, 0x30F6,0x839F, 0x0391,0x83A0, 0x0392,0x83A1, 0x0393,0x83A2, 0x0394,0x83A3, 0x0395,0x83A4, 0x0396,0x83A5, 0x0397,0x83A6, 0x0398,0x83A7, 0x0399,0x83A8, 0x039A,0x83A9, 0x039B,0x83AA, 0x039C,0x83AB, 0x039D,0x83AC, 0x039E,0x83AD, 0x039F,0x83AE, 0x03A0,0x83AF, 0x03A1,0x83B0, 0x03A3,0x83B1, 0x03A4,0x83B2, 0x03A5,0x83B3, 0x03A6,0x83B4, 0x03A7,0x83B5, 0x03A8,0x83B6, 0x03A9,0x83BF, 0x03B1,0x83C0, 0x03B2,0x83C1, 0x03B3,0x83C2, 0x03B4,0x83C3, 0x03B5,0x83C4, 0x03B6,0x83C5, 0x03B7,0x83C6, 0x03B8,0x83C7, 0x03B9,0x83C8, 0x03BA,0x83C9, 0x03BB,0x83CA, 0x03BC,0x83CB, 0x03BD,0x83CC, 0x03BE,0x83CD, 0x03BF,0x83CE, 0x03C0,0x83CF, 0x03C1,0x83D0, 0x03C3,0x83D1, 0x03C4,0x83D2, 0x03C5,0x83D3, 0x03C6,0x83D4, 0x03C7,0x83D5, 0x03C8,0x83D6, 0x03C9,0x8440, 0x0410,0x8441, 0x0411,0x8442, 0x0412,0x8443, 0x0413,0x8444, 0x0414,0x8445, 0x0415,0x8446, 0x0401,0x8447, 0x0416,0x8448, 0x0417,0x8449, 0x0418,0x844A, 0x0419,0x844B, 0x041A,0x844C, 0x041B,0x844D, 0x041C,0x844E, 0x041D,0x844F, 0x041E,0x8450, 0x041F,0x8451, 0x0420,0x8452, 0x0421,0x8453, 0x0422,0x8454, 0x0423,0x8455, 0x0424,0x8456, 0x0425,0x8457, 0x0426,0x8458, 0x0427,0x8459, 0x0428,0x845A, 0x0429,0x845B, 0x042A,0x845C, 0x042B,0x845D, 0x042C,0x845E, 0x042D,0x845F, 0x042E,0x8460, 0x042F,0x8470, 0x0430,0x8471, 0x0431,0x8472, 0x0432,0x8473, 0x0433,0x8474, 0x0434,0x8475, 0x0435,0x8476, 0x0451,0x8477, 0x0436,0x8478, 0x0437,0x8479, 0x0438,0x847A, 0x0439,0x847B, 0x043A,0x847C, 0x043B,0x847D, 0x043C,0x847E, 0x043D,0x8480, 0x043E,0x8481, 0x043F,0x8482, 0x0440,0x8483, 0x0441,0x8484, 0x0442,0x8485, 0x0443,0x8486, 0x0444,0x8487, 0x0445,0x8488, 0x0446,0x8489, 0x0447,0x848A, 0x0448,0x848B, 0x0449,0x848C, 0x044A,0x848D, 0x044B,0x848E, 0x044C,0x848F, 0x044D,0x8490, 0x044E,0x8491, 0x044F,0x849F, 0x2500,0x84A0, 0x2502,0x84A1, 0x250C,0x84A2, 0x2510,0x84A3, 0x2518,0x84A4, 0x2514,0x84A5, 0x251C,0x84A6, 0x252C,0x84A7, 0x2524,0x84A8, 0x2534,0x84A9, 0x253C,0x84AA, 0x2501,0x84AB, 0x2503,0x84AC, 0x250F,0x84AD, 0x2513,0x84AE, 0x251B,0x84AF, 0x2517,0x84B0, 0x2523,0x84B1, 0x2533,0x84B2, 0x252B,0x84B3, 0x253B,0x84B4, 0x254B,0x84B5, 0x2520,0x84B6, 0x252F,0x84B7, 0x2528,0x84B8, 0x2537,0x84B9, 0x253F,0x84BA, 0x251D,0x84BB, 0x2530,0x84BC, 0x2525,0x84BD, 0x2538,0x84BE, 0x2542,0x8740, 0x2460,0x8741, 0x2461,0x8742, 0x2462,0x8743, 0x2463,0x8744, 0x2464,0x8745, 0x2465,0x8746, 0x2466,0x8747, 0x2467,0x8748, 0x2468,0x8749, 0x2469,0x874A, 0x246A,0x874B, 0x246B,0x874C, 0x246C,0x874D, 0x246D,0x874E, 0x246E,0x874F, 0x246F,0x8750, 0x2470,0x8751, 0x2471,0x8752, 0x2472,0x8753, 0x2473,0x8754, 0x2160,0x8755, 0x2161,0x8756, 0x2162,0x8757, 0x2163,0x8758, 0x2164,0x8759, 0x2165,0x875A, 0x2166,0x875B, 0x2167,0x875C, 0x2168,0x875D, 0x2169,0x875F, 0x3349,0x8760, 0x3314,0x8761, 0x3322,0x8762, 0x334D,0x8763, 0x3318,0x8764, 0x3327,0x8765, 0x3303,0x8766, 0x3336,0x8767, 0x3351,0x8768, 0x3357,0x8769, 0x330D,0x876A, 0x3326,0x876B, 0x3323,0x876C, 0x332B,0x876D, 0x334A,0x876E, 0x333B,0x876F, 0x339C,0x8770, 0x339D,0x8771, 0x339E,0x8772, 0x338E,0x8773, 0x338F,0x8774, 0x33C4,0x8775, 0x33A1,0x877E, 0x337B,0x8780, 0x301D,0x8781, 0x301F,0x8782, 0x2116,0x8783, 0x33CD,0x8784, 0x2121,0x8785, 0x32A4,0x8786, 0x32A5,0x8787, 0x32A6,0x8788, 0x32A7,0x8789, 0x32A8,0x878A, 0x3231,0x878B, 0x3232,0x878C, 0x3239,0x878D, 0x337E,0x878E, 0x337D,0x878F, 0x337C,0x8790, 0x2252,0x8791, 0x2261,0x8792, 0x222B,0x8793, 0x222E,0x8794, 0x2211,0x8795, 0x221A,0x8796, 0x22A5,0x8797, 0x2220,0x8798, 0x221F,0x8799, 0x22BF,0x879A, 0x2235,0x879B, 0x2229,0x879C, 0x222A,0x889F, 0x4E9C,0x88A0, 0x5516,0x88A1, 0x5A03,0x88A2, 0x963F,0x88A3, 0x54C0,0x88A4, 0x611B,0x88A5, 0x6328,0x88A6, 0x59F6,0x88A7, 0x9022,0x88A8, 0x8475,0x88A9, 0x831C,0x88AA, 0x7A50,0x88AB, 0x60AA,0x88AC, 0x63E1,0x88AD, 0x6E25,0x88AE, 0x65ED,0x88AF, 0x8466,0x88B0, 0x82A6,0x88B1, 0x9BF5,0x88B2, 0x6893,0x88B3, 0x5727,0x88B4, 0x65A1,0x88B5, 0x6271,0x88B6, 0x5B9B,0x88B7, 0x59D0,0x88B8, 0x867B,0x88B9, 0x98F4,0x88BA, 0x7D62,0x88BB, 0x7DBE,0x88BC, 0x9B8E,0x88BD, 0x6216,0x88BE, 0x7C9F,0x88BF, 0x88B7,0x88C0, 0x5B89,0x88C1, 0x5EB5,0x88C2, 0x6309,0x88C3, 0x6697,0x88C4, 0x6848,0x88C5, 0x95C7,0x88C6, 0x978D,0x88C7, 0x674F,0x88C8, 0x4EE5,0x88C9, 0x4F0A,0x88CA, 0x4F4D,0x88CB, 0x4F9D,0x88CC, 0x5049,0x88CD, 0x56F2,0x88CE, 0x5937,0x88CF, 0x59D4,0x88D0, 0x5A01,0x88D1, 0x5C09,0x88D2, 0x60DF,0x88D3, 0x610F,0x88D4, 0x6170,0x88D5, 0x6613,0x88D6, 0x6905,0x88D7, 0x70BA,0x88D8, 0x754F,0x88D9, 0x7570,0x88DA, 0x79FB,0x88DB, 0x7DAD,0x88DC, 0x7DEF,0x88DD, 0x80C3,0x88DE, 0x840E,0x88DF, 0x8863,0x88E0, 0x8B02,0x88E1, 0x9055,0x88E2, 0x907A,0x88E3, 0x533B,0x88E4, 0x4E95,0x88E5, 0x4EA5,0x88E6, 0x57DF,0x88E7, 0x80B2,0x88E8, 0x90C1,0x88E9, 0x78EF,0x88EA, 0x4E00,0x88EB, 0x58F1,0x88EC, 0x6EA2,0x88ED, 0x9038,0x88EE, 0x7A32,0x88EF, 0x8328,0x88F0, 0x828B,0x88F1, 0x9C2F,0x88F2, 0x5141,0x88F3, 0x5370,0x88F4, 0x54BD,0x88F5, 0x54E1,0x88F6, 0x56E0,0x88F7, 0x59FB,0x88F8, 0x5F15,0x88F9, 0x98F2,0x88FA, 0x6DEB,0x88FB, 0x80E4,0x88FC, 0x852D,0x8940, 0x9662,0x8941, 0x9670,0x8942, 0x96A0,0x8943, 0x97FB,0x8944, 0x540B,0x8945, 0x53F3,0x8946, 0x5B87,0x8947, 0x70CF,0x8948, 0x7FBD,0x8949, 0x8FC2,0x894A, 0x96E8,0x894B, 0x536F,0x894C, 0x9D5C,0x894D, 0x7ABA,0x894E, 0x4E11,0x894F, 0x7893,0x8950, 0x81FC,0x8951, 0x6E26,0x8952, 0x5618,0x8953, 0x5504,0x8954, 0x6B1D,0x8955, 0x851A,0x8956, 0x9C3B,0x8957, 0x59E5,0x8958, 0x53A9,0x8959, 0x6D66,0x895A, 0x74DC,0x895B, 0x958F,0x895C, 0x5642,0x895D, 0x4E91,0x895E, 0x904B,0x895F, 0x96F2,0x8960, 0x834F,0x8961, 0x990C,0x8962, 0x53E1,0x8963, 0x55B6,0x8964, 0x5B30,0x8965, 0x5F71,0x8966, 0x6620,0x8967, 0x66F3,0x8968, 0x6804,0x8969, 0x6C38,0x896A, 0x6CF3,0x896B, 0x6D29,0x896C, 0x745B,0x896D, 0x76C8,0x896E, 0x7A4E,0x896F, 0x9834,0x8970, 0x82F1,0x8971, 0x885B,0x8972, 0x8A60,0x8973, 0x92ED,0x8974, 0x6DB2,0x8975, 0x75AB,0x8976, 0x76CA,0x8977, 0x99C5,0x8978, 0x60A6,0x8979, 0x8B01,0x897A, 0x8D8A,0x897B, 0x95B2,0x897C, 0x698E,0x897D, 0x53AD,0x897E, 0x5186,0x8980, 0x5712,0x8981, 0x5830,0x8982, 0x5944,0x8983, 0x5BB4,0x8984, 0x5EF6,0x8985, 0x6028,0x8986, 0x63A9,0x8987, 0x63F4,0x8988, 0x6CBF,0x8989, 0x6F14,0x898A, 0x708E,0x898B, 0x7114,0x898C, 0x7159,0x898D, 0x71D5,0x898E, 0x733F,0x898F, 0x7E01,0x8990, 0x8276,0x8991, 0x82D1,0x8992, 0x8597,0x8993, 0x9060,0x8994, 0x925B,0x8995, 0x9D1B,0x8996, 0x5869,0x8997, 0x65BC,0x8998, 0x6C5A,0x8999, 0x7525,0x899A, 0x51F9,0x899B, 0x592E,0x899C, 0x5965,0x899D, 0x5F80,0x899E, 0x5FDC,0x899F, 0x62BC,0x89A0, 0x65FA,0x89A1, 0x6A2A,0x89A2, 0x6B27,0x89A3, 0x6BB4,0x89A4, 0x738B,0x89A5, 0x7FC1,0x89A6, 0x8956,0x89A7, 0x9D2C,0x89A8, 0x9D0E,0x89A9, 0x9EC4,0x89AA, 0x5CA1,0x89AB, 0x6C96,0x89AC, 0x837B,0x89AD, 0x5104,0x89AE, 0x5C4B,0x89AF, 0x61B6,0x89B0, 0x81C6,0x89B1, 0x6876,0x89B2, 0x7261,0x89B3, 0x4E59,0x89B4, 0x4FFA,0x89B5, 0x5378,0x89B6, 0x6069,0x89B7, 0x6E29,0x89B8, 0x7A4F,0x89B9, 0x97F3,0x89BA, 0x4E0B,0x89BB, 0x5316,0x89BC, 0x4EEE,0x89BD, 0x4F55,0x89BE, 0x4F3D,0x89BF, 0x4FA1,0x89C0, 0x4F73,0x89C1, 0x52A0,0x89C2, 0x53EF,0x89C3, 0x5609,0x89C4, 0x590F,0x89C5, 0x5AC1,0x89C6, 0x5BB6,0x89C7, 0x5BE1,0x89C8, 0x79D1,0x89C9, 0x6687,0x89CA, 0x679C,0x89CB, 0x67B6,0x89CC, 0x6B4C,0x89CD, 0x6CB3,0x89CE, 0x706B,0x89CF, 0x73C2,0x89D0, 0x798D,0x89D1, 0x79BE,0x89D2, 0x7A3C,0x89D3, 0x7B87,0x89D4, 0x82B1,0x89D5, 0x82DB,0x89D6, 0x8304,0x89D7, 0x8377,0x89D8, 0x83EF,0x89D9, 0x83D3,0x89DA, 0x8766,0x89DB, 0x8AB2,0x89DC, 0x5629,0x89DD, 0x8CA8,0x89DE, 0x8FE6,0x89DF, 0x904E,0x89E0, 0x971E,0x89E1, 0x868A,0x89E2, 0x4FC4,0x89E3, 0x5CE8,0x89E4, 0x6211,0x89E5, 0x7259,0x89E6, 0x753B,0x89E7, 0x81E5,0x89E8, 0x82BD,0x89E9, 0x86FE,0x89EA, 0x8CC0,0x89EB, 0x96C5,0x89EC, 0x9913,0x89ED, 0x99D5,0x89EE, 0x4ECB,0x89EF, 0x4F1A,0x89F0, 0x89E3,0x89F1, 0x56DE,0x89F2, 0x584A,0x89F3, 0x58CA,0x89F4, 0x5EFB,0x89F5, 0x5FEB,0x89F6, 0x602A,0x89F7, 0x6094,0x89F8, 0x6062,0x89F9, 0x61D0,0x89FA, 0x6212,0x89FB, 0x62D0,0x89FC, 0x6539,0x8A40, 0x9B41,0x8A41, 0x6666,0x8A42, 0x68B0,0x8A43, 0x6D77,0x8A44, 0x7070,0x8A45, 0x754C,0x8A46, 0x7686,0x8A47, 0x7D75,0x8A48, 0x82A5,0x8A49, 0x87F9,0x8A4A, 0x958B,0x8A4B, 0x968E,0x8A4C, 0x8C9D,0x8A4D, 0x51F1,0x8A4E, 0x52BE,0x8A4F, 0x5916,0x8A50, 0x54B3,0x8A51, 0x5BB3,0x8A52, 0x5D16,0x8A53, 0x6168,0x8A54, 0x6982,0x8A55, 0x6DAF,0x8A56, 0x788D,0x8A57, 0x84CB,0x8A58, 0x8857,0x8A59, 0x8A72,0x8A5A, 0x93A7,0x8A5B, 0x9AB8,0x8A5C, 0x6D6C,0x8A5D, 0x99A8,0x8A5E, 0x86D9,0x8A5F, 0x57A3,0x8A60, 0x67FF,0x8A61, 0x86CE,0x8A62, 0x920E,0x8A63, 0x5283,0x8A64, 0x5687,0x8A65, 0x5404,0x8A66, 0x5ED3,0x8A67, 0x62E1,0x8A68, 0x64B9,0x8A69, 0x683C,0x8A6A, 0x6838,0x8A6B, 0x6BBB,0x8A6C, 0x7372,0x8A6D, 0x78BA,0x8A6E, 0x7A6B,0x8A6F, 0x899A,0x8A70, 0x89D2,0x8A71, 0x8D6B,0x8A72, 0x8F03,0x8A73, 0x90ED,0x8A74, 0x95A3,0x8A75, 0x9694,0x8A76, 0x9769,0x8A77, 0x5B66,0x8A78, 0x5CB3,0x8A79, 0x697D,0x8A7A, 0x984D,0x8A7B, 0x984E,0x8A7C, 0x639B,0x8A7D, 0x7B20,0x8A7E, 0x6A2B,0x8A80, 0x6A7F,0x8A81, 0x68B6,0x8A82, 0x9C0D,0x8A83, 0x6F5F,0x8A84, 0x5272,0x8A85, 0x559D,0x8A86, 0x6070,0x8A87, 0x62EC,0x8A88, 0x6D3B,0x8A89, 0x6E07,0x8A8A, 0x6ED1,0x8A8B, 0x845B,0x8A8C, 0x8910,0x8A8D, 0x8F44,0x8A8E, 0x4E14,0x8A8F, 0x9C39,0x8A90, 0x53F6,0x8A91, 0x691B,0x8A92, 0x6A3A,0x8A93, 0x9784,0x8A94, 0x682A,0x8A95, 0x515C,0x8A96, 0x7AC3,0x8A97, 0x84B2,0x8A98, 0x91DC,0x8A99, 0x938C,0x8A9A, 0x565B,0x8A9B, 0x9D28,0x8A9C, 0x6822,0x8A9D, 0x8305,0x8A9E, 0x8431,0x8A9F, 0x7CA5,0x8AA0, 0x5208,0x8AA1, 0x82C5,0x8AA2, 0x74E6,0x8AA3, 0x4E7E,0x8AA4, 0x4F83,0x8AA5, 0x51A0,0x8AA6, 0x5BD2,0x8AA7, 0x520A,0x8AA8, 0x52D8,0x8AA9, 0x52E7,0x8AAA, 0x5DFB,0x8AAB, 0x559A,0x8AAC, 0x582A,0x8AAD, 0x59E6,0x8AAE, 0x5B8C,0x8AAF, 0x5B98,0x8AB0, 0x5BDB,0x8AB1, 0x5E72,0x8AB2, 0x5E79,0x8AB3, 0x60A3,0x8AB4, 0x611F,0x8AB5, 0x6163,0x8AB6, 0x61BE,0x8AB7, 0x63DB,0x8AB8, 0x6562,0x8AB9, 0x67D1,0x8ABA, 0x6853,0x8ABB, 0x68FA,0x8ABC, 0x6B3E,0x8ABD, 0x6B53,0x8ABE, 0x6C57,0x8ABF, 0x6F22,0x8AC0, 0x6F97,0x8AC1, 0x6F45,0x8AC2, 0x74B0,0x8AC3, 0x7518,0x8AC4, 0x76E3,0x8AC5, 0x770B,0x8AC6, 0x7AFF,0x8AC7, 0x7BA1,0x8AC8, 0x7C21,0x8AC9, 0x7DE9,0x8ACA, 0x7F36,0x8ACB, 0x7FF0,0x8ACC, 0x809D,0x8ACD, 0x8266,0x8ACE, 0x839E,0x8ACF, 0x89B3,0x8AD0, 0x8ACC,0x8AD1, 0x8CAB,0x8AD2, 0x9084,0x8AD3, 0x9451,0x8AD4, 0x9593,0x8AD5, 0x9591,0x8AD6, 0x95A2,0x8AD7, 0x9665,0x8AD8, 0x97D3,0x8AD9, 0x9928,0x8ADA, 0x8218,0x8ADB, 0x4E38,0x8ADC, 0x542B,0x8ADD, 0x5CB8,0x8ADE, 0x5DCC,0x8ADF, 0x73A9,0x8AE0, 0x764C,0x8AE1, 0x773C,0x8AE2, 0x5CA9,0x8AE3, 0x7FEB,0x8AE4, 0x8D0B,0x8AE5, 0x96C1,0x8AE6, 0x9811,0x8AE7, 0x9854,0x8AE8, 0x9858,0x8AE9, 0x4F01,0x8AEA, 0x4F0E,0x8AEB, 0x5371,0x8AEC, 0x559C,0x8AED, 0x5668,0x8AEE, 0x57FA,0x8AEF, 0x5947,0x8AF0, 0x5B09,0x8AF1, 0x5BC4,0x8AF2, 0x5C90,0x8AF3, 0x5E0C,0x8AF4, 0x5E7E,0x8AF5, 0x5FCC,0x8AF6, 0x63EE,0x8AF7, 0x673A,0x8AF8, 0x65D7,0x8AF9, 0x65E2,0x8AFA, 0x671F,0x8AFB, 0x68CB,0x8AFC, 0x68C4,0x8B40, 0x6A5F,0x8B41, 0x5E30,0x8B42, 0x6BC5,0x8B43, 0x6C17,0x8B44, 0x6C7D,0x8B45, 0x757F,0x8B46, 0x7948,0x8B47, 0x5B63,0x8B48, 0x7A00,0x8B49, 0x7D00,0x8B4A, 0x5FBD,0x8B4B, 0x898F,0x8B4C, 0x8A18,0x8B4D, 0x8CB4,0x8B4E, 0x8D77,0x8B4F, 0x8ECC,0x8B50, 0x8F1D,0x8B51, 0x98E2,0x8B52, 0x9A0E,0x8B53, 0x9B3C,0x8B54, 0x4E80,0x8B55, 0x507D,0x8B56, 0x5100,0x8B57, 0x5993,0x8B58, 0x5B9C,0x8B59, 0x622F,0x8B5A, 0x6280,0x8B5B, 0x64EC,0x8B5C, 0x6B3A,0x8B5D, 0x72A0,0x8B5E, 0x7591,0x8B5F, 0x7947,0x8B60, 0x7FA9,0x8B61, 0x87FB,0x8B62, 0x8ABC,0x8B63, 0x8B70,0x8B64, 0x63AC,0x8B65, 0x83CA,0x8B66, 0x97A0,0x8B67, 0x5409,0x8B68, 0x5403,0x8B69, 0x55AB,0x8B6A, 0x6854,0x8B6B, 0x6A58,0x8B6C, 0x8A70,0x8B6D, 0x7827,0x8B6E, 0x6775,0x8B6F, 0x9ECD,0x8B70, 0x5374,0x8B71, 0x5BA2,0x8B72, 0x811A,0x8B73, 0x8650,0x8B74, 0x9006,0x8B75, 0x4E18,0x8B76, 0x4E45,0x8B77, 0x4EC7,0x8B78, 0x4F11,0x8B79, 0x53CA,0x8B7A, 0x5438,0x8B7B, 0x5BAE,0x8B7C, 0x5F13,0x8B7D, 0x6025,0x8B7E, 0x6551,0x8B80, 0x673D,0x8B81, 0x6C42,0x8B82, 0x6C72,0x8B83, 0x6CE3,0x8B84, 0x7078,0x8B85, 0x7403,0x8B86, 0x7A76,0x8B87, 0x7AAE,0x8B88, 0x7B08,0x8B89, 0x7D1A,0x8B8A, 0x7CFE,0x8B8B, 0x7D66,0x8B8C, 0x65E7,0x8B8D, 0x725B,0x8B8E, 0x53BB,0x8B8F, 0x5C45,0x8B90, 0x5DE8,0x8B91, 0x62D2,0x8B92, 0x62E0,0x8B93, 0x6319,0x8B94, 0x6E20,0x8B95, 0x865A,0x8B96, 0x8A31,0x8B97, 0x8DDD,0x8B98, 0x92F8,0x8B99, 0x6F01,0x8B9A, 0x79A6,0x8B9B, 0x9B5A,0x8B9C, 0x4EA8,0x8B9D, 0x4EAB,0x8B9E, 0x4EAC,0x8B9F, 0x4F9B,0x8BA0, 0x4FA0,0x8BA1, 0x50D1,0x8BA2, 0x5147,0x8BA3, 0x7AF6,0x8BA4, 0x5171,0x8BA5, 0x51F6,0x8BA6, 0x5354,0x8BA7, 0x5321,0x8BA8, 0x537F,0x8BA9, 0x53EB,0x8BAA, 0x55AC,0x8BAB, 0x5883,0x8BAC, 0x5CE1,0x8BAD, 0x5F37,0x8BAE, 0x5F4A,0x8BAF, 0x602F,0x8BB0, 0x6050,0x8BB1, 0x606D,0x8BB2, 0x631F,0x8BB3, 0x6559,0x8BB4, 0x6A4B,0x8BB5, 0x6CC1,0x8BB6, 0x72C2,0x8BB7, 0x72ED,0x8BB8, 0x77EF,0x8BB9, 0x80F8,0x8BBA, 0x8105,0x8BBB, 0x8208,0x8BBC, 0x854E,0x8BBD, 0x90F7,0x8BBE, 0x93E1,0x8BBF, 0x97FF,0x8BC0, 0x9957,0x8BC1, 0x9A5A,0x8BC2, 0x4EF0,0x8BC3, 0x51DD,0x8BC4, 0x5C2D,0x8BC5, 0x6681,0x8BC6, 0x696D,0x8BC7, 0x5C40,0x8BC8, 0x66F2,0x8BC9, 0x6975,0x8BCA, 0x7389,0x8BCB, 0x6850,0x8BCC, 0x7C81,0x8BCD, 0x50C5,0x8BCE, 0x52E4,0x8BCF, 0x5747,0x8BD0, 0x5DFE,0x8BD1, 0x9326,0x8BD2, 0x65A4,0x8BD3, 0x6B23,0x8BD4, 0x6B3D,0x8BD5, 0x7434,0x8BD6, 0x7981,0x8BD7, 0x79BD,0x8BD8, 0x7B4B,0x8BD9, 0x7DCA,0x8BDA, 0x82B9,0x8BDB, 0x83CC,0x8BDC, 0x887F,0x8BDD, 0x895F,0x8BDE, 0x8B39,0x8BDF, 0x8FD1,0x8BE0, 0x91D1,0x8BE1, 0x541F,0x8BE2, 0x9280,0x8BE3, 0x4E5D,0x8BE4, 0x5036,0x8BE5, 0x53E5,0x8BE6, 0x533A,0x8BE7, 0x72D7,0x8BE8, 0x7396,0x8BE9, 0x77E9,0x8BEA, 0x82E6,0x8BEB, 0x8EAF,0x8BEC, 0x99C6,0x8BED, 0x99C8,0x8BEE, 0x99D2,0x8BEF, 0x5177,0x8BF0, 0x611A,0x8BF1, 0x865E,0x8BF2, 0x55B0,0x8BF3, 0x7A7A,0x8BF4, 0x5076,0x8BF5, 0x5BD3,0x8BF6, 0x9047,0x8BF7, 0x9685,0x8BF8, 0x4E32,0x8BF9, 0x6ADB,0x8BFA, 0x91E7,0x8BFB, 0x5C51,0x8BFC, 0x5C48,0x8C40, 0x6398,0x8C41, 0x7A9F,0x8C42, 0x6C93,0x8C43, 0x9774,0x8C44, 0x8F61,0x8C45, 0x7AAA,0x8C46, 0x718A,0x8C47, 0x9688,0x8C48, 0x7C82,0x8C49, 0x6817,0x8C4A, 0x7E70,0x8C4B, 0x6851,0x8C4C, 0x936C,0x8C4D, 0x52F2,0x8C4E, 0x541B,0x8C4F, 0x85AB,0x8C50, 0x8A13,0x8C51, 0x7FA4,0x8C52, 0x8ECD,0x8C53, 0x90E1,0x8C54, 0x5366,0x8C55, 0x8888,0x8C56, 0x7941,0x8C57, 0x4FC2,0x8C58, 0x50BE,0x8C59, 0x5211,0x8C5A, 0x5144,0x8C5B, 0x5553,0x8C5C, 0x572D,0x8C5D, 0x73EA,0x8C5E, 0x578B,0x8C5F, 0x5951,0x8C60, 0x5F62,0x8C61, 0x5F84,0x8C62, 0x6075,0x8C63, 0x6176,0x8C64, 0x6167,0x8C65, 0x61A9,0x8C66, 0x63B2,0x8C67, 0x643A,0x8C68, 0x656C,0x8C69, 0x666F,0x8C6A, 0x6842,0x8C6B, 0x6E13,0x8C6C, 0x7566,0x8C6D, 0x7A3D,0x8C6E, 0x7CFB,0x8C6F, 0x7D4C,0x8C70, 0x7D99,0x8C71, 0x7E4B,0x8C72, 0x7F6B,0x8C73, 0x830E,0x8C74, 0x834A,0x8C75, 0x86CD,0x8C76, 0x8A08,0x8C77, 0x8A63,0x8C78, 0x8B66,0x8C79, 0x8EFD,0x8C7A, 0x981A,0x8C7B, 0x9D8F,0x8C7C, 0x82B8,0x8C7D, 0x8FCE,0x8C7E, 0x9BE8,0x8C80, 0x5287,0x8C81, 0x621F,0x8C82, 0x6483,0x8C83, 0x6FC0,0x8C84, 0x9699,0x8C85, 0x6841,0x8C86, 0x5091,0x8C87, 0x6B20,0x8C88, 0x6C7A,0x8C89, 0x6F54,0x8C8A, 0x7A74,0x8C8B, 0x7D50,0x8C8C, 0x8840,0x8C8D, 0x8A23,0x8C8E, 0x6708,0x8C8F, 0x4EF6,0x8C90, 0x5039,0x8C91, 0x5026,0x8C92, 0x5065,0x8C93, 0x517C,0x8C94, 0x5238,0x8C95, 0x5263,0x8C96, 0x55A7,0x8C97, 0x570F,0x8C98, 0x5805,0x8C99, 0x5ACC,0x8C9A, 0x5EFA,0x8C9B, 0x61B2,0x8C9C, 0x61F8,0x8C9D, 0x62F3,0x8C9E, 0x6372,0x8C9F, 0x691C,0x8CA0, 0x6A29,0x8CA1, 0x727D,0x8CA2, 0x72AC,0x8CA3, 0x732E,0x8CA4, 0x7814,0x8CA5, 0x786F,0x8CA6, 0x7D79,0x8CA7, 0x770C,0x8CA8, 0x80A9,0x8CA9, 0x898B,0x8CAA, 0x8B19,0x8CAB, 0x8CE2,0x8CAC, 0x8ED2,0x8CAD, 0x9063,0x8CAE, 0x9375,0x8CAF, 0x967A,0x8CB0, 0x9855,0x8CB1, 0x9A13,0x8CB2, 0x9E78,0x8CB3, 0x5143,0x8CB4, 0x539F,0x8CB5, 0x53B3,0x8CB6, 0x5E7B,0x8CB7, 0x5F26,0x8CB8, 0x6E1B,0x8CB9, 0x6E90,0x8CBA, 0x7384,0x8CBB, 0x73FE,0x8CBC, 0x7D43,0x8CBD, 0x8237,0x8CBE, 0x8A00,0x8CBF, 0x8AFA,0x8CC0, 0x9650,0x8CC1, 0x4E4E,0x8CC2, 0x500B,0x8CC3, 0x53E4,0x8CC4, 0x547C,0x8CC5, 0x56FA,0x8CC6, 0x59D1,0x8CC7, 0x5B64,0x8CC8, 0x5DF1,0x8CC9, 0x5EAB,0x8CCA, 0x5F27,0x8CCB, 0x6238,0x8CCC, 0x6545,0x8CCD, 0x67AF,0x8CCE, 0x6E56,0x8CCF, 0x72D0,0x8CD0, 0x7CCA,0x8CD1, 0x88B4,0x8CD2, 0x80A1,0x8CD3, 0x80E1,0x8CD4, 0x83F0,0x8CD5, 0x864E,0x8CD6, 0x8A87,0x8CD7, 0x8DE8,0x8CD8, 0x9237,0x8CD9, 0x96C7,0x8CDA, 0x9867,0x8CDB, 0x9F13,0x8CDC, 0x4E94,0x8CDD, 0x4E92,0x8CDE, 0x4F0D,0x8CDF, 0x5348,0x8CE0, 0x5449,0x8CE1, 0x543E,0x8CE2, 0x5A2F,0x8CE3, 0x5F8C,0x8CE4, 0x5FA1,0x8CE5, 0x609F,0x8CE6, 0x68A7,0x8CE7, 0x6A8E,0x8CE8, 0x745A,0x8CE9, 0x7881,0x8CEA, 0x8A9E,0x8CEB, 0x8AA4,0x8CEC, 0x8B77,0x8CED, 0x9190,0x8CEE, 0x4E5E,0x8CEF, 0x9BC9,0x8CF0, 0x4EA4,0x8CF1, 0x4F7C,0x8CF2, 0x4FAF,0x8CF3, 0x5019,0x8CF4, 0x5016,0x8CF5, 0x5149,0x8CF6, 0x516C,0x8CF7, 0x529F,0x8CF8, 0x52B9,0x8CF9, 0x52FE,0x8CFA, 0x539A,0x8CFB, 0x53E3,0x8CFC, 0x5411,0x8D40, 0x540E,0x8D41, 0x5589,0x8D42, 0x5751,0x8D43, 0x57A2,0x8D44, 0x597D,0x8D45, 0x5B54,0x8D46, 0x5B5D,0x8D47, 0x5B8F,0x8D48, 0x5DE5,0x8D49, 0x5DE7,0x8D4A, 0x5DF7,0x8D4B, 0x5E78,0x8D4C, 0x5E83,0x8D4D, 0x5E9A,0x8D4E, 0x5EB7,0x8D4F, 0x5F18,0x8D50, 0x6052,0x8D51, 0x614C,0x8D52, 0x6297,0x8D53, 0x62D8,0x8D54, 0x63A7,0x8D55, 0x653B,0x8D56, 0x6602,0x8D57, 0x6643,0x8D58, 0x66F4,0x8D59, 0x676D,0x8D5A, 0x6821,0x8D5B, 0x6897,0x8D5C, 0x69CB,0x8D5D, 0x6C5F,0x8D5E, 0x6D2A,0x8D5F, 0x6D69,0x8D60, 0x6E2F,0x8D61, 0x6E9D,0x8D62, 0x7532,0x8D63, 0x7687,0x8D64, 0x786C,0x8D65, 0x7A3F,0x8D66, 0x7CE0,0x8D67, 0x7D05,0x8D68, 0x7D18,0x8D69, 0x7D5E,0x8D6A, 0x7DB1,0x8D6B, 0x8015,0x8D6C, 0x8003,0x8D6D, 0x80AF,0x8D6E, 0x80B1,0x8D6F, 0x8154,0x8D70, 0x818F,0x8D71, 0x822A,0x8D72, 0x8352,0x8D73, 0x884C,0x8D74, 0x8861,0x8D75, 0x8B1B,0x8D76, 0x8CA2,0x8D77, 0x8CFC,0x8D78, 0x90CA,0x8D79, 0x9175,0x8D7A, 0x9271,0x8D7B, 0x783F,0x8D7C, 0x92FC,0x8D7D, 0x95A4,0x8D7E, 0x964D,0x8D80, 0x9805,0x8D81, 0x9999,0x8D82, 0x9AD8,0x8D83, 0x9D3B,0x8D84, 0x525B,0x8D85, 0x52AB,0x8D86, 0x53F7,0x8D87, 0x5408,0x8D88, 0x58D5,0x8D89, 0x62F7,0x8D8A, 0x6FE0,0x8D8B, 0x8C6A,0x8D8C, 0x8F5F,0x8D8D, 0x9EB9,0x8D8E, 0x514B,0x8D8F, 0x523B,0x8D90, 0x544A,0x8D91, 0x56FD,0x8D92, 0x7A40,0x8D93, 0x9177,0x8D94, 0x9D60,0x8D95, 0x9ED2,0x8D96, 0x7344,0x8D97, 0x6F09,0x8D98, 0x8170,0x8D99, 0x7511,0x8D9A, 0x5FFD,0x8D9B, 0x60DA,0x8D9C, 0x9AA8,0x8D9D, 0x72DB,0x8D9E, 0x8FBC,0x8D9F, 0x6B64,0x8DA0, 0x9803,0x8DA1, 0x4ECA,0x8DA2, 0x56F0,0x8DA3, 0x5764,0x8DA4, 0x58BE,0x8DA5, 0x5A5A,0x8DA6, 0x6068,0x8DA7, 0x61C7,0x8DA8, 0x660F,0x8DA9, 0x6606,0x8DAA, 0x6839,0x8DAB, 0x68B1,0x8DAC, 0x6DF7,0x8DAD, 0x75D5,0x8DAE, 0x7D3A,0x8DAF, 0x826E,0x8DB0, 0x9B42,0x8DB1, 0x4E9B,0x8DB2, 0x4F50,0x8DB3, 0x53C9,0x8DB4, 0x5506,0x8DB5, 0x5D6F,0x8DB6, 0x5DE6,0x8DB7, 0x5DEE,0x8DB8, 0x67FB,0x8DB9, 0x6C99,0x8DBA, 0x7473,0x8DBB, 0x7802,0x8DBC, 0x8A50,0x8DBD, 0x9396,0x8DBE, 0x88DF,0x8DBF, 0x5750,0x8DC0, 0x5EA7,0x8DC1, 0x632B,0x8DC2, 0x50B5,0x8DC3, 0x50AC,0x8DC4, 0x518D,0x8DC5, 0x6700,0x8DC6, 0x54C9,0x8DC7, 0x585E,0x8DC8, 0x59BB,0x8DC9, 0x5BB0,0x8DCA, 0x5F69,0x8DCB, 0x624D,0x8DCC, 0x63A1,0x8DCD, 0x683D,0x8DCE, 0x6B73,0x8DCF, 0x6E08,0x8DD0, 0x707D,0x8DD1, 0x91C7,0x8DD2, 0x7280,0x8DD3, 0x7815,0x8DD4, 0x7826,0x8DD5, 0x796D,0x8DD6, 0x658E,0x8DD7, 0x7D30,0x8DD8, 0x83DC,0x8DD9, 0x88C1,0x8DDA, 0x8F09,0x8DDB, 0x969B,0x8DDC, 0x5264,0x8DDD, 0x5728,0x8DDE, 0x6750,0x8DDF, 0x7F6A,0x8DE0, 0x8CA1,0x8DE1, 0x51B4,0x8DE2, 0x5742,0x8DE3, 0x962A,0x8DE4, 0x583A,0x8DE5, 0x698A,0x8DE6, 0x80B4,0x8DE7, 0x54B2,0x8DE8, 0x5D0E,0x8DE9, 0x57FC,0x8DEA, 0x7895,0x8DEB, 0x9DFA,0x8DEC, 0x4F5C,0x8DED, 0x524A,0x8DEE, 0x548B,0x8DEF, 0x643E,0x8DF0, 0x6628,0x8DF1, 0x6714,0x8DF2, 0x67F5,0x8DF3, 0x7A84,0x8DF4, 0x7B56,0x8DF5, 0x7D22,0x8DF6, 0x932F,0x8DF7, 0x685C,0x8DF8, 0x9BAD,0x8DF9, 0x7B39,0x8DFA, 0x5319,0x8DFB, 0x518A,0x8DFC, 0x5237,0x8E40, 0x5BDF,0x8E41, 0x62F6,0x8E42, 0x64AE,0x8E43, 0x64E6,0x8E44, 0x672D,0x8E45, 0x6BBA,0x8E46, 0x85A9,0x8E47, 0x96D1,0x8E48, 0x7690,0x8E49, 0x9BD6,0x8E4A, 0x634C,0x8E4B, 0x9306,0x8E4C, 0x9BAB,0x8E4D, 0x76BF,0x8E4E, 0x6652,0x8E4F, 0x4E09,0x8E50, 0x5098,0x8E51, 0x53C2,0x8E52, 0x5C71,0x8E53, 0x60E8,0x8E54, 0x6492,0x8E55, 0x6563,0x8E56, 0x685F,0x8E57, 0x71E6,0x8E58, 0x73CA,0x8E59, 0x7523,0x8E5A, 0x7B97,0x8E5B, 0x7E82,0x8E5C, 0x8695,0x8E5D, 0x8B83,0x8E5E, 0x8CDB,0x8E5F, 0x9178,0x8E60, 0x9910,0x8E61, 0x65AC,0x8E62, 0x66AB,0x8E63, 0x6B8B,0x8E64, 0x4ED5,0x8E65, 0x4ED4,0x8E66, 0x4F3A,0x8E67, 0x4F7F,0x8E68, 0x523A,0x8E69, 0x53F8,0x8E6A, 0x53F2,0x8E6B, 0x55E3,0x8E6C, 0x56DB,0x8E6D, 0x58EB,0x8E6E, 0x59CB,0x8E6F, 0x59C9,0x8E70, 0x59FF,0x8E71, 0x5B50,0x8E72, 0x5C4D,0x8E73, 0x5E02,0x8E74, 0x5E2B,0x8E75, 0x5FD7,0x8E76, 0x601D,0x8E77, 0x6307,0x8E78, 0x652F,0x8E79, 0x5B5C,0x8E7A, 0x65AF,0x8E7B, 0x65BD,0x8E7C, 0x65E8,0x8E7D, 0x679D,0x8E7E, 0x6B62,0x8E80, 0x6B7B,0x8E81, 0x6C0F,0x8E82, 0x7345,0x8E83, 0x7949,0x8E84, 0x79C1,0x8E85, 0x7CF8,0x8E86, 0x7D19,0x8E87, 0x7D2B,0x8E88, 0x80A2,0x8E89, 0x8102,0x8E8A, 0x81F3,0x8E8B, 0x8996,0x8E8C, 0x8A5E,0x8E8D, 0x8A69,0x8E8E, 0x8A66,0x8E8F, 0x8A8C,0x8E90, 0x8AEE,0x8E91, 0x8CC7,0x8E92, 0x8CDC,0x8E93, 0x96CC,0x8E94, 0x98FC,0x8E95, 0x6B6F,0x8E96, 0x4E8B,0x8E97, 0x4F3C,0x8E98, 0x4F8D,0x8E99, 0x5150,0x8E9A, 0x5B57,0x8E9B, 0x5BFA,0x8E9C, 0x6148,0x8E9D, 0x6301,0x8E9E, 0x6642,0x8E9F, 0x6B21,0x8EA0, 0x6ECB,0x8EA1, 0x6CBB,0x8EA2, 0x723E,0x8EA3, 0x74BD,0x8EA4, 0x75D4,0x8EA5, 0x78C1,0x8EA6, 0x793A,0x8EA7, 0x800C,0x8EA8, 0x8033,0x8EA9, 0x81EA,0x8EAA, 0x8494,0x8EAB, 0x8F9E,0x8EAC, 0x6C50,0x8EAD, 0x9E7F,0x8EAE, 0x5F0F,0x8EAF, 0x8B58,0x8EB0, 0x9D2B,0x8EB1, 0x7AFA,0x8EB2, 0x8EF8,0x8EB3, 0x5B8D,0x8EB4, 0x96EB,0x8EB5, 0x4E03,0x8EB6, 0x53F1,0x8EB7, 0x57F7,0x8EB8, 0x5931,0x8EB9, 0x5AC9,0x8EBA, 0x5BA4,0x8EBB, 0x6089,0x8EBC, 0x6E7F,0x8EBD, 0x6F06,0x8EBE, 0x75BE,0x8EBF, 0x8CEA,0x8EC0, 0x5B9F,0x8EC1, 0x8500,0x8EC2, 0x7BE0,0x8EC3, 0x5072,0x8EC4, 0x67F4,0x8EC5, 0x829D,0x8EC6, 0x5C61,0x8EC7, 0x854A,0x8EC8, 0x7E1E,0x8EC9, 0x820E,0x8ECA, 0x5199,0x8ECB, 0x5C04,0x8ECC, 0x6368,0x8ECD, 0x8D66,0x8ECE, 0x659C,0x8ECF, 0x716E,0x8ED0, 0x793E,0x8ED1, 0x7D17,0x8ED2, 0x8005,0x8ED3, 0x8B1D,0x8ED4, 0x8ECA,0x8ED5, 0x906E,0x8ED6, 0x86C7,0x8ED7, 0x90AA,0x8ED8, 0x501F,0x8ED9, 0x52FA,0x8EDA, 0x5C3A,0x8EDB, 0x6753,0x8EDC, 0x707C,0x8EDD, 0x7235,0x8EDE, 0x914C,0x8EDF, 0x91C8,0x8EE0, 0x932B,0x8EE1, 0x82E5,0x8EE2, 0x5BC2,0x8EE3, 0x5F31,0x8EE4, 0x60F9,0x8EE5, 0x4E3B,0x8EE6, 0x53D6,0x8EE7, 0x5B88,0x8EE8, 0x624B,0x8EE9, 0x6731,0x8EEA, 0x6B8A,0x8EEB, 0x72E9,0x8EEC, 0x73E0,0x8EED, 0x7A2E,0x8EEE, 0x816B,0x8EEF, 0x8DA3,0x8EF0, 0x9152,0x8EF1, 0x9996,0x8EF2, 0x5112,0x8EF3, 0x53D7,0x8EF4, 0x546A,0x8EF5, 0x5BFF,0x8EF6, 0x6388,0x8EF7, 0x6A39,0x8EF8, 0x7DAC,0x8EF9, 0x9700,0x8EFA, 0x56DA,0x8EFB, 0x53CE,0x8EFC, 0x5468,0x8F40, 0x5B97,0x8F41, 0x5C31,0x8F42, 0x5DDE,0x8F43, 0x4FEE,0x8F44, 0x6101,0x8F45, 0x62FE,0x8F46, 0x6D32,0x8F47, 0x79C0,0x8F48, 0x79CB,0x8F49, 0x7D42,0x8F4A, 0x7E4D,0x8F4B, 0x7FD2,0x8F4C, 0x81ED,0x8F4D, 0x821F,0x8F4E, 0x8490,0x8F4F, 0x8846,0x8F50, 0x8972,0x8F51, 0x8B90,0x8F52, 0x8E74,0x8F53, 0x8F2F,0x8F54, 0x9031,0x8F55, 0x914B,0x8F56, 0x916C,0x8F57, 0x96C6,0x8F58, 0x919C,0x8F59, 0x4EC0,0x8F5A, 0x4F4F,0x8F5B, 0x5145,0x8F5C, 0x5341,0x8F5D, 0x5F93,0x8F5E, 0x620E,0x8F5F, 0x67D4,0x8F60, 0x6C41,0x8F61, 0x6E0B,0x8F62, 0x7363,0x8F63, 0x7E26,0x8F64, 0x91CD,0x8F65, 0x9283,0x8F66, 0x53D4,0x8F67, 0x5919,0x8F68, 0x5BBF,0x8F69, 0x6DD1,0x8F6A, 0x795D,0x8F6B, 0x7E2E,0x8F6C, 0x7C9B,0x8F6D, 0x587E,0x8F6E, 0x719F,0x8F6F, 0x51FA,0x8F70, 0x8853,0x8F71, 0x8FF0,0x8F72, 0x4FCA,0x8F73, 0x5CFB,0x8F74, 0x6625,0x8F75, 0x77AC,0x8F76, 0x7AE3,0x8F77, 0x821C,0x8F78, 0x99FF,0x8F79, 0x51C6,0x8F7A, 0x5FAA,0x8F7B, 0x65EC,0x8F7C, 0x696F,0x8F7D, 0x6B89,0x8F7E, 0x6DF3,0x8F80, 0x6E96,0x8F81, 0x6F64,0x8F82, 0x76FE,0x8F83, 0x7D14,0x8F84, 0x5DE1,0x8F85, 0x9075,0x8F86, 0x9187,0x8F87, 0x9806,0x8F88, 0x51E6,0x8F89, 0x521D,0x8F8A, 0x6240,0x8F8B, 0x6691,0x8F8C, 0x66D9,0x8F8D, 0x6E1A,0x8F8E, 0x5EB6,0x8F8F, 0x7DD2,0x8F90, 0x7F72,0x8F91, 0x66F8,0x8F92, 0x85AF,0x8F93, 0x85F7,0x8F94, 0x8AF8,0x8F95, 0x52A9,0x8F96, 0x53D9,0x8F97, 0x5973,0x8F98, 0x5E8F,0x8F99, 0x5F90,0x8F9A, 0x6055,0x8F9B, 0x92E4,0x8F9C, 0x9664,0x8F9D, 0x50B7,0x8F9E, 0x511F,0x8F9F, 0x52DD,0x8FA0, 0x5320,0x8FA1, 0x5347,0x8FA2, 0x53EC,0x8FA3, 0x54E8,0x8FA4, 0x5546,0x8FA5, 0x5531,0x8FA6, 0x5617,0x8FA7, 0x5968,0x8FA8, 0x59BE,0x8FA9, 0x5A3C,0x8FAA, 0x5BB5,0x8FAB, 0x5C06,0x8FAC, 0x5C0F,0x8FAD, 0x5C11,0x8FAE, 0x5C1A,0x8FAF, 0x5E84,0x8FB0, 0x5E8A,0x8FB1, 0x5EE0,0x8FB2, 0x5F70,0x8FB3, 0x627F,0x8FB4, 0x6284,0x8FB5, 0x62DB,0x8FB6, 0x638C,0x8FB7, 0x6377,0x8FB8, 0x6607,0x8FB9, 0x660C,0x8FBA, 0x662D,0x8FBB, 0x6676,0x8FBC, 0x677E,0x8FBD, 0x68A2,0x8FBE, 0x6A1F,0x8FBF, 0x6A35,0x8FC0, 0x6CBC,0x8FC1, 0x6D88,0x8FC2, 0x6E09,0x8FC3, 0x6E58,0x8FC4, 0x713C,0x8FC5, 0x7126,0x8FC6, 0x7167,0x8FC7, 0x75C7,0x8FC8, 0x7701,0x8FC9, 0x785D,0x8FCA, 0x7901,0x8FCB, 0x7965,0x8FCC, 0x79F0,0x8FCD, 0x7AE0,0x8FCE, 0x7B11,0x8FCF, 0x7CA7,0x8FD0, 0x7D39,0x8FD1, 0x8096,0x8FD2, 0x83D6,0x8FD3, 0x848B,0x8FD4, 0x8549,0x8FD5, 0x885D,0x8FD6, 0x88F3,0x8FD7, 0x8A1F,0x8FD8, 0x8A3C,0x8FD9, 0x8A54,0x8FDA, 0x8A73,0x8FDB, 0x8C61,0x8FDC, 0x8CDE,0x8FDD, 0x91A4,0x8FDE, 0x9266,0x8FDF, 0x937E,0x8FE0, 0x9418,0x8FE1, 0x969C,0x8FE2, 0x9798,0x8FE3, 0x4E0A,0x8FE4, 0x4E08,0x8FE5, 0x4E1E,0x8FE6, 0x4E57,0x8FE7, 0x5197,0x8FE8, 0x5270,0x8FE9, 0x57CE,0x8FEA, 0x5834,0x8FEB, 0x58CC,0x8FEC, 0x5B22,0x8FED, 0x5E38,0x8FEE, 0x60C5,0x8FEF, 0x64FE,0x8FF0, 0x6761,0x8FF1, 0x6756,0x8FF2, 0x6D44,0x8FF3, 0x72B6,0x8FF4, 0x7573,0x8FF5, 0x7A63,0x8FF6, 0x84B8,0x8FF7, 0x8B72,0x8FF8, 0x91B8,0x8FF9, 0x9320,0x8FFA, 0x5631,0x8FFB, 0x57F4,0x8FFC, 0x98FE,0x9040, 0x62ED,0x9041, 0x690D,0x9042, 0x6B96,0x9043, 0x71ED,0x9044, 0x7E54,0x9045, 0x8077,0x9046, 0x8272,0x9047, 0x89E6,0x9048, 0x98DF,0x9049, 0x8755,0x904A, 0x8FB1,0x904B, 0x5C3B,0x904C, 0x4F38,0x904D, 0x4FE1,0x904E, 0x4FB5,0x904F, 0x5507,0x9050, 0x5A20,0x9051, 0x5BDD,0x9052, 0x5BE9,0x9053, 0x5FC3,0x9054, 0x614E,0x9055, 0x632F,0x9056, 0x65B0,0x9057, 0x664B,0x9058, 0x68EE,0x9059, 0x699B,0x905A, 0x6D78,0x905B, 0x6DF1,0x905C, 0x7533,0x905D, 0x75B9,0x905E, 0x771F,0x905F, 0x795E,0x9060, 0x79E6,0x9061, 0x7D33,0x9062, 0x81E3,0x9063, 0x82AF,0x9064, 0x85AA,0x9065, 0x89AA,0x9066, 0x8A3A,0x9067, 0x8EAB,0x9068, 0x8F9B,0x9069, 0x9032,0x906A, 0x91DD,0x906B, 0x9707,0x906C, 0x4EBA,0x906D, 0x4EC1,0x906E, 0x5203,0x906F, 0x5875,0x9070, 0x58EC,0x9071, 0x5C0B,0x9072, 0x751A,0x9073, 0x5C3D,0x9074, 0x814E,0x9075, 0x8A0A,0x9076, 0x8FC5,0x9077, 0x9663,0x9078, 0x976D,0x9079, 0x7B25,0x907A, 0x8ACF,0x907B, 0x9808,0x907C, 0x9162,0x907D, 0x56F3,0x907E, 0x53A8,0x9080, 0x9017,0x9081, 0x5439,0x9082, 0x5782,0x9083, 0x5E25,0x9084, 0x63A8,0x9085, 0x6C34,0x9086, 0x708A,0x9087, 0x7761,0x9088, 0x7C8B,0x9089, 0x7FE0,0x908A, 0x8870,0x908B, 0x9042,0x908C, 0x9154,0x908D, 0x9310,0x908E, 0x9318,0x908F, 0x968F,0x9090, 0x745E,0x9091, 0x9AC4,0x9092, 0x5D07,0x9093, 0x5D69,0x9094, 0x6570,0x9095, 0x67A2,0x9096, 0x8DA8,0x9097, 0x96DB,0x9098, 0x636E,0x9099, 0x6749,0x909A, 0x6919,0x909B, 0x83C5,0x909C, 0x9817,0x909D, 0x96C0,0x909E, 0x88FE,0x909F, 0x6F84,0x90A0, 0x647A,0x90A1, 0x5BF8,0x90A2, 0x4E16,0x90A3, 0x702C,0x90A4, 0x755D,0x90A5, 0x662F,0x90A6, 0x51C4,0x90A7, 0x5236,0x90A8, 0x52E2,0x90A9, 0x59D3,0x90AA, 0x5F81,0x90AB, 0x6027,0x90AC, 0x6210,0x90AD, 0x653F,0x90AE, 0x6574,0x90AF, 0x661F,0x90B0, 0x6674,0x90B1, 0x68F2,0x90B2, 0x6816,0x90B3, 0x6B63,0x90B4, 0x6E05,0x90B5, 0x7272,0x90B6, 0x751F,0x90B7, 0x76DB,0x90B8, 0x7CBE,0x90B9, 0x8056,0x90BA, 0x58F0,0x90BB, 0x88FD,0x90BC, 0x897F,0x90BD, 0x8AA0,0x90BE, 0x8A93,0x90BF, 0x8ACB,0x90C0, 0x901D,0x90C1, 0x9192,0x90C2, 0x9752,0x90C3, 0x9759,0x90C4, 0x6589,0x90C5, 0x7A0E,0x90C6, 0x8106,0x90C7, 0x96BB,0x90C8, 0x5E2D,0x90C9, 0x60DC,0x90CA, 0x621A,0x90CB, 0x65A5,0x90CC, 0x6614,0x90CD, 0x6790,0x90CE, 0x77F3,0x90CF, 0x7A4D,0x90D0, 0x7C4D,0x90D1, 0x7E3E,0x90D2, 0x810A,0x90D3, 0x8CAC,0x90D4, 0x8D64,0x90D5, 0x8DE1,0x90D6, 0x8E5F,0x90D7, 0x78A9,0x90D8, 0x5207,0x90D9, 0x62D9,0x90DA, 0x63A5,0x90DB, 0x6442,0x90DC, 0x6298,0x90DD, 0x8A2D,0x90DE, 0x7A83,0x90DF, 0x7BC0,0x90E0, 0x8AAC,0x90E1, 0x96EA,0x90E2, 0x7D76,0x90E3, 0x820C,0x90E4, 0x8749,0x90E5, 0x4ED9,0x90E6, 0x5148,0x90E7, 0x5343,0x90E8, 0x5360,0x90E9, 0x5BA3,0x90EA, 0x5C02,0x90EB, 0x5C16,0x90EC, 0x5DDD,0x90ED, 0x6226,0x90EE, 0x6247,0x90EF, 0x64B0,0x90F0, 0x6813,0x90F1, 0x6834,0x90F2, 0x6CC9,0x90F3, 0x6D45,0x90F4, 0x6D17,0x90F5, 0x67D3,0x90F6, 0x6F5C,0x90F7, 0x714E,0x90F8, 0x717D,0x90F9, 0x65CB,0x90FA, 0x7A7F,0x90FB, 0x7BAD,0x90FC, 0x7DDA,0x9140, 0x7E4A,0x9141, 0x7FA8,0x9142, 0x817A,0x9143, 0x821B,0x9144, 0x8239,0x9145, 0x85A6,0x9146, 0x8A6E,0x9147, 0x8CCE,0x9148, 0x8DF5,0x9149, 0x9078,0x914A, 0x9077,0x914B, 0x92AD,0x914C, 0x9291,0x914D, 0x9583,0x914E, 0x9BAE,0x914F, 0x524D,0x9150, 0x5584,0x9151, 0x6F38,0x9152, 0x7136,0x9153, 0x5168,0x9154, 0x7985,0x9155, 0x7E55,0x9156, 0x81B3,0x9157, 0x7CCE,0x9158, 0x564C,0x9159, 0x5851,0x915A, 0x5CA8,0x915B, 0x63AA,0x915C, 0x66FE,0x915D, 0x66FD,0x915E, 0x695A,0x915F, 0x72D9,0x9160, 0x758F,0x9161, 0x758E,0x9162, 0x790E,0x9163, 0x7956,0x9164, 0x79DF,0x9165, 0x7C97,0x9166, 0x7D20,0x9167, 0x7D44,0x9168, 0x8607,0x9169, 0x8A34,0x916A, 0x963B,0x916B, 0x9061,0x916C, 0x9F20,0x916D, 0x50E7,0x916E, 0x5275,0x916F, 0x53CC,0x9170, 0x53E2,0x9171, 0x5009,0x9172, 0x55AA,0x9173, 0x58EE,0x9174, 0x594F,0x9175, 0x723D,0x9176, 0x5B8B,0x9177, 0x5C64,0x9178, 0x531D,0x9179, 0x60E3,0x917A, 0x60F3,0x917B, 0x635C,0x917C, 0x6383,0x917D, 0x633F,0x917E, 0x63BB,0x9180, 0x64CD,0x9181, 0x65E9,0x9182, 0x66F9,0x9183, 0x5DE3,0x9184, 0x69CD,0x9185, 0x69FD,0x9186, 0x6F15,0x9187, 0x71E5,0x9188, 0x4E89,0x9189, 0x75E9,0x918A, 0x76F8,0x918B, 0x7A93,0x918C, 0x7CDF,0x918D, 0x7DCF,0x918E, 0x7D9C,0x918F, 0x8061,0x9190, 0x8349,0x9191, 0x8358,0x9192, 0x846C,0x9193, 0x84BC,0x9194, 0x85FB,0x9195, 0x88C5,0x9196, 0x8D70,0x9197, 0x9001,0x9198, 0x906D,0x9199, 0x9397,0x919A, 0x971C,0x919B, 0x9A12,0x919C, 0x50CF,0x919D, 0x5897,0x919E, 0x618E,0x919F, 0x81D3,0x91A0, 0x8535,0x91A1, 0x8D08,0x91A2, 0x9020,0x91A3, 0x4FC3,0x91A4, 0x5074,0x91A5, 0x5247,0x91A6, 0x5373,0x91A7, 0x606F,0x91A8, 0x6349,0x91A9, 0x675F,0x91AA, 0x6E2C,0x91AB, 0x8DB3,0x91AC, 0x901F,0x91AD, 0x4FD7,0x91AE, 0x5C5E,0x91AF, 0x8CCA,0x91B0, 0x65CF,0x91B1, 0x7D9A,0x91B2, 0x5352,0x91B3, 0x8896,0x91B4, 0x5176,0x91B5, 0x63C3,0x91B6, 0x5B58,0x91B7, 0x5B6B,0x91B8, 0x5C0A,0x91B9, 0x640D,0x91BA, 0x6751,0x91BB, 0x905C,0x91BC, 0x4ED6,0x91BD, 0x591A,0x91BE, 0x592A,0x91BF, 0x6C70,0x91C0, 0x8A51,0x91C1, 0x553E,0x91C2, 0x5815,0x91C3, 0x59A5,0x91C4, 0x60F0,0x91C5, 0x6253,0x91C6, 0x67C1,0x91C7, 0x8235,0x91C8, 0x6955,0x91C9, 0x9640,0x91CA, 0x99C4,0x91CB, 0x9A28,0x91CC, 0x4F53,0x91CD, 0x5806,0x91CE, 0x5BFE,0x91CF, 0x8010,0x91D0, 0x5CB1,0x91D1, 0x5E2F,0x91D2, 0x5F85,0x91D3, 0x6020,0x91D4, 0x614B,0x91D5, 0x6234,0x91D6, 0x66FF,0x91D7, 0x6CF0,0x91D8, 0x6EDE,0x91D9, 0x80CE,0x91DA, 0x817F,0x91DB, 0x82D4,0x91DC, 0x888B,0x91DD, 0x8CB8,0x91DE, 0x9000,0x91DF, 0x902E,0x91E0, 0x968A,0x91E1, 0x9EDB,0x91E2, 0x9BDB,0x91E3, 0x4EE3,0x91E4, 0x53F0,0x91E5, 0x5927,0x91E6, 0x7B2C,0x91E7, 0x918D,0x91E8, 0x984C,0x91E9, 0x9DF9,0x91EA, 0x6EDD,0x91EB, 0x7027,0x91EC, 0x5353,0x91ED, 0x5544,0x91EE, 0x5B85,0x91EF, 0x6258,0x91F0, 0x629E,0x91F1, 0x62D3,0x91F2, 0x6CA2,0x91F3, 0x6FEF,0x91F4, 0x7422,0x91F5, 0x8A17,0x91F6, 0x9438,0x91F7, 0x6FC1,0x91F8, 0x8AFE,0x91F9, 0x8338,0x91FA, 0x51E7,0x91FB, 0x86F8,0x91FC, 0x53EA,0x9240, 0x53E9,0x9241, 0x4F46,0x9242, 0x9054,0x9243, 0x8FB0,0x9244, 0x596A,0x9245, 0x8131,0x9246, 0x5DFD,0x9247, 0x7AEA,0x9248, 0x8FBF,0x9249, 0x68DA,0x924A, 0x8C37,0x924B, 0x72F8,0x924C, 0x9C48,0x924D, 0x6A3D,0x924E, 0x8AB0,0x924F, 0x4E39,0x9250, 0x5358,0x9251, 0x5606,0x9252, 0x5766,0x9253, 0x62C5,0x9254, 0x63A2,0x9255, 0x65E6,0x9256, 0x6B4E,0x9257, 0x6DE1,0x9258, 0x6E5B,0x9259, 0x70AD,0x925A, 0x77ED,0x925B, 0x7AEF,0x925C, 0x7BAA,0x925D, 0x7DBB,0x925E, 0x803D,0x925F, 0x80C6,0x9260, 0x86CB,0x9261, 0x8A95,0x9262, 0x935B,0x9263, 0x56E3,0x9264, 0x58C7,0x9265, 0x5F3E,0x9266, 0x65AD,0x9267, 0x6696,0x9268, 0x6A80,0x9269, 0x6BB5,0x926A, 0x7537,0x926B, 0x8AC7,0x926C, 0x5024,0x926D, 0x77E5,0x926E, 0x5730,0x926F, 0x5F1B,0x9270, 0x6065,0x9271, 0x667A,0x9272, 0x6C60,0x9273, 0x75F4,0x9274, 0x7A1A,0x9275, 0x7F6E,0x9276, 0x81F4,0x9277, 0x8718,0x9278, 0x9045,0x9279, 0x99B3,0x927A, 0x7BC9,0x927B, 0x755C,0x927C, 0x7AF9,0x927D, 0x7B51,0x927E, 0x84C4,0x9280, 0x9010,0x9281, 0x79E9,0x9282, 0x7A92,0x9283, 0x8336,0x9284, 0x5AE1,0x9285, 0x7740,0x9286, 0x4E2D,0x9287, 0x4EF2,0x9288, 0x5B99,0x9289, 0x5FE0,0x928A, 0x62BD,0x928B, 0x663C,0x928C, 0x67F1,0x928D, 0x6CE8,0x928E, 0x866B,0x928F, 0x8877,0x9290, 0x8A3B,0x9291, 0x914E,0x9292, 0x92F3,0x9293, 0x99D0,0x9294, 0x6A17,0x9295, 0x7026,0x9296, 0x732A,0x9297, 0x82E7,0x9298, 0x8457,0x9299, 0x8CAF,0x929A, 0x4E01,0x929B, 0x5146,0x929C, 0x51CB,0x929D, 0x558B,0x929E, 0x5BF5,0x929F, 0x5E16,0x92A0, 0x5E33,0x92A1, 0x5E81,0x92A2, 0x5F14,0x92A3, 0x5F35,0x92A4, 0x5F6B,0x92A5, 0x5FB4,0x92A6, 0x61F2,0x92A7, 0x6311,0x92A8, 0x66A2,0x92A9, 0x671D,0x92AA, 0x6F6E,0x92AB, 0x7252,0x92AC, 0x753A,0x92AD, 0x773A,0x92AE, 0x8074,0x92AF, 0x8139,0x92B0, 0x8178,0x92B1, 0x8776,0x92B2, 0x8ABF,0x92B3, 0x8ADC,0x92B4, 0x8D85,0x92B5, 0x8DF3,0x92B6, 0x929A,0x92B7, 0x9577,0x92B8, 0x9802,0x92B9, 0x9CE5,0x92BA, 0x52C5,0x92BB, 0x6357,0x92BC, 0x76F4,0x92BD, 0x6715,0x92BE, 0x6C88,0x92BF, 0x73CD,0x92C0, 0x8CC3,0x92C1, 0x93AE,0x92C2, 0x9673,0x92C3, 0x6D25,0x92C4, 0x589C,0x92C5, 0x690E,0x92C6, 0x69CC,0x92C7, 0x8FFD,0x92C8, 0x939A,0x92C9, 0x75DB,0x92CA, 0x901A,0x92CB, 0x585A,0x92CC, 0x6802,0x92CD, 0x63B4,0x92CE, 0x69FB,0x92CF, 0x4F43,0x92D0, 0x6F2C,0x92D1, 0x67D8,0x92D2, 0x8FBB,0x92D3, 0x8526,0x92D4, 0x7DB4,0x92D5, 0x9354,0x92D6, 0x693F,0x92D7, 0x6F70,0x92D8, 0x576A,0x92D9, 0x58F7,0x92DA, 0x5B2C,0x92DB, 0x7D2C,0x92DC, 0x722A,0x92DD, 0x540A,0x92DE, 0x91E3,0x92DF, 0x9DB4,0x92E0, 0x4EAD,0x92E1, 0x4F4E,0x92E2, 0x505C,0x92E3, 0x5075,0x92E4, 0x5243,0x92E5, 0x8C9E,0x92E6, 0x5448,0x92E7, 0x5824,0x92E8, 0x5B9A,0x92E9, 0x5E1D,0x92EA, 0x5E95,0x92EB, 0x5EAD,0x92EC, 0x5EF7,0x92ED, 0x5F1F,0x92EE, 0x608C,0x92EF, 0x62B5,0x92F0, 0x633A,0x92F1, 0x63D0,0x92F2, 0x68AF,0x92F3, 0x6C40,0x92F4, 0x7887,0x92F5, 0x798E,0x92F6, 0x7A0B,0x92F7, 0x7DE0,0x92F8, 0x8247,0x92F9, 0x8A02,0x92FA, 0x8AE6,0x92FB, 0x8E44,0x92FC, 0x9013,0x9340, 0x90B8,0x9341, 0x912D,0x9342, 0x91D8,0x9343, 0x9F0E,0x9344, 0x6CE5,0x9345, 0x6458,0x9346, 0x64E2,0x9347, 0x6575,0x9348, 0x6EF4,0x9349, 0x7684,0x934A, 0x7B1B,0x934B, 0x9069,0x934C, 0x93D1,0x934D, 0x6EBA,0x934E, 0x54F2,0x934F, 0x5FB9,0x9350, 0x64A4,0x9351, 0x8F4D,0x9352, 0x8FED,0x9353, 0x9244,0x9354, 0x5178,0x9355, 0x586B,0x9356, 0x5929,0x9357, 0x5C55,0x9358, 0x5E97,0x9359, 0x6DFB,0x935A, 0x7E8F,0x935B, 0x751C,0x935C, 0x8CBC,0x935D, 0x8EE2,0x935E, 0x985B,0x935F, 0x70B9,0x9360, 0x4F1D,0x9361, 0x6BBF,0x9362, 0x6FB1,0x9363, 0x7530,0x9364, 0x96FB,0x9365, 0x514E,0x9366, 0x5410,0x9367, 0x5835,0x9368, 0x5857,0x9369, 0x59AC,0x936A, 0x5C60,0x936B, 0x5F92,0x936C, 0x6597,0x936D, 0x675C,0x936E, 0x6E21,0x936F, 0x767B,0x9370, 0x83DF,0x9371, 0x8CED,0x9372, 0x9014,0x9373, 0x90FD,0x9374, 0x934D,0x9375, 0x7825,0x9376, 0x783A,0x9377, 0x52AA,0x9378, 0x5EA6,0x9379, 0x571F,0x937A, 0x5974,0x937B, 0x6012,0x937C, 0x5012,0x937D, 0x515A,0x937E, 0x51AC,0x9380, 0x51CD,0x9381, 0x5200,0x9382, 0x5510,0x9383, 0x5854,0x9384, 0x5858,0x9385, 0x5957,0x9386, 0x5B95,0x9387, 0x5CF6,0x9388, 0x5D8B,0x9389, 0x60BC,0x938A, 0x6295,0x938B, 0x642D,0x938C, 0x6771,0x938D, 0x6843,0x938E, 0x68BC,0x938F, 0x68DF,0x9390, 0x76D7,0x9391, 0x6DD8,0x9392, 0x6E6F,0x9393, 0x6D9B,0x9394, 0x706F,0x9395, 0x71C8,0x9396, 0x5F53,0x9397, 0x75D8,0x9398, 0x7977,0x9399, 0x7B49,0x939A, 0x7B54,0x939B, 0x7B52,0x939C, 0x7CD6,0x939D, 0x7D71,0x939E, 0x5230,0x939F, 0x8463,0x93A0, 0x8569,0x93A1, 0x85E4,0x93A2, 0x8A0E,0x93A3, 0x8B04,0x93A4, 0x8C46,0x93A5, 0x8E0F,0x93A6, 0x9003,0x93A7, 0x900F,0x93A8, 0x9419,0x93A9, 0x9676,0x93AA, 0x982D,0x93AB, 0x9A30,0x93AC, 0x95D8,0x93AD, 0x50CD,0x93AE, 0x52D5,0x93AF, 0x540C,0x93B0, 0x5802,0x93B1, 0x5C0E,0x93B2, 0x61A7,0x93B3, 0x649E,0x93B4, 0x6D1E,0x93B5, 0x77B3,0x93B6, 0x7AE5,0x93B7, 0x80F4,0x93B8, 0x8404,0x93B9, 0x9053,0x93BA, 0x9285,0x93BB, 0x5CE0,0x93BC, 0x9D07,0x93BD, 0x533F,0x93BE, 0x5F97,0x93BF, 0x5FB3,0x93C0, 0x6D9C,0x93C1, 0x7279,0x93C2, 0x7763,0x93C3, 0x79BF,0x93C4, 0x7BE4,0x93C5, 0x6BD2,0x93C6, 0x72EC,0x93C7, 0x8AAD,0x93C8, 0x6803,0x93C9, 0x6A61,0x93CA, 0x51F8,0x93CB, 0x7A81,0x93CC, 0x6934,0x93CD, 0x5C4A,0x93CE, 0x9CF6,0x93CF, 0x82EB,0x93D0, 0x5BC5,0x93D1, 0x9149,0x93D2, 0x701E,0x93D3, 0x5678,0x93D4, 0x5C6F,0x93D5, 0x60C7,0x93D6, 0x6566,0x93D7, 0x6C8C,0x93D8, 0x8C5A,0x93D9, 0x9041,0x93DA, 0x9813,0x93DB, 0x5451,0x93DC, 0x66C7,0x93DD, 0x920D,0x93DE, 0x5948,0x93DF, 0x90A3,0x93E0, 0x5185,0x93E1, 0x4E4D,0x93E2, 0x51EA,0x93E3, 0x8599,0x93E4, 0x8B0E,0x93E5, 0x7058,0x93E6, 0x637A,0x93E7, 0x934B,0x93E8, 0x6962,0x93E9, 0x99B4,0x93EA, 0x7E04,0x93EB, 0x7577,0x93EC, 0x5357,0x93ED, 0x6960,0x93EE, 0x8EDF,0x93EF, 0x96E3,0x93F0, 0x6C5D,0x93F1, 0x4E8C,0x93F2, 0x5C3C,0x93F3, 0x5F10,0x93F4, 0x8FE9,0x93F5, 0x5302,0x93F6, 0x8CD1,0x93F7, 0x8089,0x93F8, 0x8679,0x93F9, 0x5EFF,0x93FA, 0x65E5,0x93FB, 0x4E73,0x93FC, 0x5165,0x9440, 0x5982,0x9441, 0x5C3F,0x9442, 0x97EE,0x9443, 0x4EFB,0x9444, 0x598A,0x9445, 0x5FCD,0x9446, 0x8A8D,0x9447, 0x6FE1,0x9448, 0x79B0,0x9449, 0x7962,0x944A, 0x5BE7,0x944B, 0x8471,0x944C, 0x732B,0x944D, 0x71B1,0x944E, 0x5E74,0x944F, 0x5FF5,0x9450, 0x637B,0x9451, 0x649A,0x9452, 0x71C3,0x9453, 0x7C98,0x9454, 0x4E43,0x9455, 0x5EFC,0x9456, 0x4E4B,0x9457, 0x57DC,0x9458, 0x56A2,0x9459, 0x60A9,0x945A, 0x6FC3,0x945B, 0x7D0D,0x945C, 0x80FD,0x945D, 0x8133,0x945E, 0x81BF,0x945F, 0x8FB2,0x9460, 0x8997,0x9461, 0x86A4,0x9462, 0x5DF4,0x9463, 0x628A,0x9464, 0x64AD,0x9465, 0x8987,0x9466, 0x6777,0x9467, 0x6CE2,0x9468, 0x6D3E,0x9469, 0x7436,0x946A, 0x7834,0x946B, 0x5A46,0x946C, 0x7F75,0x946D, 0x82AD,0x946E, 0x99AC,0x946F, 0x4FF3,0x9470, 0x5EC3,0x9471, 0x62DD,0x9472, 0x6392,0x9473, 0x6557,0x9474, 0x676F,0x9475, 0x76C3,0x9476, 0x724C,0x9477, 0x80CC,0x9478, 0x80BA,0x9479, 0x8F29,0x947A, 0x914D,0x947B, 0x500D,0x947C, 0x57F9,0x947D, 0x5A92,0x947E, 0x6885,0x9480, 0x6973,0x9481, 0x7164,0x9482, 0x72FD,0x9483, 0x8CB7,0x9484, 0x58F2,0x9485, 0x8CE0,0x9486, 0x966A,0x9487, 0x9019,0x9488, 0x877F,0x9489, 0x79E4,0x948A, 0x77E7,0x948B, 0x8429,0x948C, 0x4F2F,0x948D, 0x5265,0x948E, 0x535A,0x948F, 0x62CD,0x9490, 0x67CF,0x9491, 0x6CCA,0x9492, 0x767D,0x9493, 0x7B94,0x9494, 0x7C95,0x9495, 0x8236,0x9496, 0x8584,0x9497, 0x8FEB,0x9498, 0x66DD,0x9499, 0x6F20,0x949A, 0x7206,0x949B, 0x7E1B,0x949C, 0x83AB,0x949D, 0x99C1,0x949E, 0x9EA6,0x949F, 0x51FD,0x94A0, 0x7BB1,0x94A1, 0x7872,0x94A2, 0x7BB8,0x94A3, 0x8087,0x94A4, 0x7B48,0x94A5, 0x6AE8,0x94A6, 0x5E61,0x94A7, 0x808C,0x94A8, 0x7551,0x94A9, 0x7560,0x94AA, 0x516B,0x94AB, 0x9262,0x94AC, 0x6E8C,0x94AD, 0x767A,0x94AE, 0x9197,0x94AF, 0x9AEA,0x94B0, 0x4F10,0x94B1, 0x7F70,0x94B2, 0x629C,0x94B3, 0x7B4F,0x94B4, 0x95A5,0x94B5, 0x9CE9,0x94B6, 0x567A,0x94B7, 0x5859,0x94B8, 0x86E4,0x94B9, 0x96BC,0x94BA, 0x4F34,0x94BB, 0x5224,0x94BC, 0x534A,0x94BD, 0x53CD,0x94BE, 0x53DB,0x94BF, 0x5E06,0x94C0, 0x642C,0x94C1, 0x6591,0x94C2, 0x677F,0x94C3, 0x6C3E,0x94C4, 0x6C4E,0x94C5, 0x7248,0x94C6, 0x72AF,0x94C7, 0x73ED,0x94C8, 0x7554,0x94C9, 0x7E41,0x94CA, 0x822C,0x94CB, 0x85E9,0x94CC, 0x8CA9,0x94CD, 0x7BC4,0x94CE, 0x91C6,0x94CF, 0x7169,0x94D0, 0x9812,0x94D1, 0x98EF,0x94D2, 0x633D,0x94D3, 0x6669,0x94D4, 0x756A,0x94D5, 0x76E4,0x94D6, 0x78D0,0x94D7, 0x8543,0x94D8, 0x86EE,0x94D9, 0x532A,0x94DA, 0x5351,0x94DB, 0x5426,0x94DC, 0x5983,0x94DD, 0x5E87,0x94DE, 0x5F7C,0x94DF, 0x60B2,0x94E0, 0x6249,0x94E1, 0x6279,0x94E2, 0x62AB,0x94E3, 0x6590,0x94E4, 0x6BD4,0x94E5, 0x6CCC,0x94E6, 0x75B2,0x94E7, 0x76AE,0x94E8, 0x7891,0x94E9, 0x79D8,0x94EA, 0x7DCB,0x94EB, 0x7F77,0x94EC, 0x80A5,0x94ED, 0x88AB,0x94EE, 0x8AB9,0x94EF, 0x8CBB,0x94F0, 0x907F,0x94F1, 0x975E,0x94F2, 0x98DB,0x94F3, 0x6A0B,0x94F4, 0x7C38,0x94F5, 0x5099,0x94F6, 0x5C3E,0x94F7, 0x5FAE,0x94F8, 0x6787,0x94F9, 0x6BD8,0x94FA, 0x7435,0x94FB, 0x7709,0x94FC, 0x7F8E,0x9540, 0x9F3B,0x9541, 0x67CA,0x9542, 0x7A17,0x9543, 0x5339,0x9544, 0x758B,0x9545, 0x9AED,0x9546, 0x5F66,0x9547, 0x819D,0x9548, 0x83F1,0x9549, 0x8098,0x954A, 0x5F3C,0x954B, 0x5FC5,0x954C, 0x7562,0x954D, 0x7B46,0x954E, 0x903C,0x954F, 0x6867,0x9550, 0x59EB,0x9551, 0x5A9B,0x9552, 0x7D10,0x9553, 0x767E,0x9554, 0x8B2C,0x9555, 0x4FF5,0x9556, 0x5F6A,0x9557, 0x6A19,0x9558, 0x6C37,0x9559, 0x6F02,0x955A, 0x74E2,0x955B, 0x7968,0x955C, 0x8868,0x955D, 0x8A55,0x955E, 0x8C79,0x955F, 0x5EDF,0x9560, 0x63CF,0x9561, 0x75C5,0x9562, 0x79D2,0x9563, 0x82D7,0x9564, 0x9328,0x9565, 0x92F2,0x9566, 0x849C,0x9567, 0x86ED,0x9568, 0x9C2D,0x9569, 0x54C1,0x956A, 0x5F6C,0x956B, 0x658C,0x956C, 0x6D5C,0x956D, 0x7015,0x956E, 0x8CA7,0x956F, 0x8CD3,0x9570, 0x983B,0x9571, 0x654F,0x9572, 0x74F6,0x9573, 0x4E0D,0x9574, 0x4ED8,0x9575, 0x57E0,0x9576, 0x592B,0x9577, 0x5A66,0x9578, 0x5BCC,0x9579, 0x51A8,0x957A, 0x5E03,0x957B, 0x5E9C,0x957C, 0x6016,0x957D, 0x6276,0x957E, 0x6577,0x9580, 0x65A7,0x9581, 0x666E,0x9582, 0x6D6E,0x9583, 0x7236,0x9584, 0x7B26,0x9585, 0x8150,0x9586, 0x819A,0x9587, 0x8299,0x9588, 0x8B5C,0x9589, 0x8CA0,0x958A, 0x8CE6,0x958B, 0x8D74,0x958C, 0x961C,0x958D, 0x9644,0x958E, 0x4FAE,0x958F, 0x64AB,0x9590, 0x6B66,0x9591, 0x821E,0x9592, 0x8461,0x9593, 0x856A,0x9594, 0x90E8,0x9595, 0x5C01,0x9596, 0x6953,0x9597, 0x98A8,0x9598, 0x847A,0x9599, 0x8557,0x959A, 0x4F0F,0x959B, 0x526F,0x959C, 0x5FA9,0x959D, 0x5E45,0x959E, 0x670D,0x959F, 0x798F,0x95A0, 0x8179,0x95A1, 0x8907,0x95A2, 0x8986,0x95A3, 0x6DF5,0x95A4, 0x5F17,0x95A5, 0x6255,0x95A6, 0x6CB8,0x95A7, 0x4ECF,0x95A8, 0x7269,0x95A9, 0x9B92,0x95AA, 0x5206,0x95AB, 0x543B,0x95AC, 0x5674,0x95AD, 0x58B3,0x95AE, 0x61A4,0x95AF, 0x626E,0x95B0, 0x711A,0x95B1, 0x596E,0x95B2, 0x7C89,0x95B3, 0x7CDE,0x95B4, 0x7D1B,0x95B5, 0x96F0,0x95B6, 0x6587,0x95B7, 0x805E,0x95B8, 0x4E19,0x95B9, 0x4F75,0x95BA, 0x5175,0x95BB, 0x5840,0x95BC, 0x5E63,0x95BD, 0x5E73,0x95BE, 0x5F0A,0x95BF, 0x67C4,0x95C0, 0x4E26,0x95C1, 0x853D,0x95C2, 0x9589,0x95C3, 0x965B,0x95C4, 0x7C73,0x95C5, 0x9801,0x95C6, 0x50FB,0x95C7, 0x58C1,0x95C8, 0x7656,0x95C9, 0x78A7,0x95CA, 0x5225,0x95CB, 0x77A5,0x95CC, 0x8511,0x95CD, 0x7B86,0x95CE, 0x504F,0x95CF, 0x5909,0x95D0, 0x7247,0x95D1, 0x7BC7,0x95D2, 0x7DE8,0x95D3, 0x8FBA,0x95D4, 0x8FD4,0x95D5, 0x904D,0x95D6, 0x4FBF,0x95D7, 0x52C9,0x95D8, 0x5A29,0x95D9, 0x5F01,0x95DA, 0x97AD,0x95DB, 0x4FDD,0x95DC, 0x8217,0x95DD, 0x92EA,0x95DE, 0x5703,0x95DF, 0x6355,0x95E0, 0x6B69,0x95E1, 0x752B,0x95E2, 0x88DC,0x95E3, 0x8F14,0x95E4, 0x7A42,0x95E5, 0x52DF,0x95E6, 0x5893,0x95E7, 0x6155,0x95E8, 0x620A,0x95E9, 0x66AE,0x95EA, 0x6BCD,0x95EB, 0x7C3F,0x95EC, 0x83E9,0x95ED, 0x5023,0x95EE, 0x4FF8,0x95EF, 0x5305,0x95F0, 0x5446,0x95F1, 0x5831,0x95F2, 0x5949,0x95F3, 0x5B9D,0x95F4, 0x5CF0,0x95F5, 0x5CEF,0x95F6, 0x5D29,0x95F7, 0x5E96,0x95F8, 0x62B1,0x95F9, 0x6367,0x95FA, 0x653E,0x95FB, 0x65B9,0x95FC, 0x670B,0x9640, 0x6CD5,0x9641, 0x6CE1,0x9642, 0x70F9,0x9643, 0x7832,0x9644, 0x7E2B,0x9645, 0x80DE,0x9646, 0x82B3,0x9647, 0x840C,0x9648, 0x84EC,0x9649, 0x8702,0x964A, 0x8912,0x964B, 0x8A2A,0x964C, 0x8C4A,0x964D, 0x90A6,0x964E, 0x92D2,0x964F, 0x98FD,0x9650, 0x9CF3,0x9651, 0x9D6C,0x9652, 0x4E4F,0x9653, 0x4EA1,0x9654, 0x508D,0x9655, 0x5256,0x9656, 0x574A,0x9657, 0x59A8,0x9658, 0x5E3D,0x9659, 0x5FD8,0x965A, 0x5FD9,0x965B, 0x623F,0x965C, 0x66B4,0x965D, 0x671B,0x965E, 0x67D0,0x965F, 0x68D2,0x9660, 0x5192,0x9661, 0x7D21,0x9662, 0x80AA,0x9663, 0x81A8,0x9664, 0x8B00,0x9665, 0x8C8C,0x9666, 0x8CBF,0x9667, 0x927E,0x9668, 0x9632,0x9669, 0x5420,0x966A, 0x982C,0x966B, 0x5317,0x966C, 0x50D5,0x966D, 0x535C,0x966E, 0x58A8,0x966F, 0x64B2,0x9670, 0x6734,0x9671, 0x7267,0x9672, 0x7766,0x9673, 0x7A46,0x9674, 0x91E6,0x9675, 0x52C3,0x9676, 0x6CA1,0x9677, 0x6B86,0x9678, 0x5800,0x9679, 0x5E4C,0x967A, 0x5954,0x967B, 0x672C,0x967C, 0x7FFB,0x967D, 0x51E1,0x967E, 0x76C6,0x9680, 0x6469,0x9681, 0x78E8,0x9682, 0x9B54,0x9683, 0x9EBB,0x9684, 0x57CB,0x9685, 0x59B9,0x9686, 0x6627,0x9687, 0x679A,0x9688, 0x6BCE,0x9689, 0x54E9,0x968A, 0x69D9,0x968B, 0x5E55,0x968C, 0x819C,0x968D, 0x6795,0x968E, 0x9BAA,0x968F, 0x67FE,0x9690, 0x9C52,0x9691, 0x685D,0x9692, 0x4EA6,0x9693, 0x4FE3,0x9694, 0x53C8,0x9695, 0x62B9,0x9696, 0x672B,0x9697, 0x6CAB,0x9698, 0x8FC4,0x9699, 0x4FAD,0x969A, 0x7E6D,0x969B, 0x9EBF,0x969C, 0x4E07,0x969D, 0x6162,0x969E, 0x6E80,0x969F, 0x6F2B,0x96A0, 0x8513,0x96A1, 0x5473,0x96A2, 0x672A,0x96A3, 0x9B45,0x96A4, 0x5DF3,0x96A5, 0x7B95,0x96A6, 0x5CAC,0x96A7, 0x5BC6,0x96A8, 0x871C,0x96A9, 0x6E4A,0x96AA, 0x84D1,0x96AB, 0x7A14,0x96AC, 0x8108,0x96AD, 0x5999,0x96AE, 0x7C8D,0x96AF, 0x6C11,0x96B0, 0x7720,0x96B1, 0x52D9,0x96B2, 0x5922,0x96B3, 0x7121,0x96B4, 0x725F,0x96B5, 0x77DB,0x96B6, 0x9727,0x96B7, 0x9D61,0x96B8, 0x690B,0x96B9, 0x5A7F,0x96BA, 0x5A18,0x96BB, 0x51A5,0x96BC, 0x540D,0x96BD, 0x547D,0x96BE, 0x660E,0x96BF, 0x76DF,0x96C0, 0x8FF7,0x96C1, 0x9298,0x96C2, 0x9CF4,0x96C3, 0x59EA,0x96C4, 0x725D,0x96C5, 0x6EC5,0x96C6, 0x514D,0x96C7, 0x68C9,0x96C8, 0x7DBF,0x96C9, 0x7DEC,0x96CA, 0x9762,0x96CB, 0x9EBA,0x96CC, 0x6478,0x96CD, 0x6A21,0x96CE, 0x8302,0x96CF, 0x5984,0x96D0, 0x5B5F,0x96D1, 0x6BDB,0x96D2, 0x731B,0x96D3, 0x76F2,0x96D4, 0x7DB2,0x96D5, 0x8017,0x96D6, 0x8499,0x96D7, 0x5132,0x96D8, 0x6728,0x96D9, 0x9ED9,0x96DA, 0x76EE,0x96DB, 0x6762,0x96DC, 0x52FF,0x96DD, 0x9905,0x96DE, 0x5C24,0x96DF, 0x623B,0x96E0, 0x7C7E,0x96E1, 0x8CB0,0x96E2, 0x554F,0x96E3, 0x60B6,0x96E4, 0x7D0B,0x96E5, 0x9580,0x96E6, 0x5301,0x96E7, 0x4E5F,0x96E8, 0x51B6,0x96E9, 0x591C,0x96EA, 0x723A,0x96EB, 0x8036,0x96EC, 0x91CE,0x96ED, 0x5F25,0x96EE, 0x77E2,0x96EF, 0x5384,0x96F0, 0x5F79,0x96F1, 0x7D04,0x96F2, 0x85AC,0x96F3, 0x8A33,0x96F4, 0x8E8D,0x96F5, 0x9756,0x96F6, 0x67F3,0x96F7, 0x85AE,0x96F8, 0x9453,0x96F9, 0x6109,0x96FA, 0x6108,0x96FB, 0x6CB9,0x96FC, 0x7652,0x9740, 0x8AED,0x9741, 0x8F38,0x9742, 0x552F,0x9743, 0x4F51,0x9744, 0x512A,0x9745, 0x52C7,0x9746, 0x53CB,0x9747, 0x5BA5,0x9748, 0x5E7D,0x9749, 0x60A0,0x974A, 0x6182,0x974B, 0x63D6,0x974C, 0x6709,0x974D, 0x67DA,0x974E, 0x6E67,0x974F, 0x6D8C,0x9750, 0x7336,0x9751, 0x7337,0x9752, 0x7531,0x9753, 0x7950,0x9754, 0x88D5,0x9755, 0x8A98,0x9756, 0x904A,0x9757, 0x9091,0x9758, 0x90F5,0x9759, 0x96C4,0x975A, 0x878D,0x975B, 0x5915,0x975C, 0x4E88,0x975D, 0x4F59,0x975E, 0x4E0E,0x975F, 0x8A89,0x9760, 0x8F3F,0x9761, 0x9810,0x9762, 0x50AD,0x9763, 0x5E7C,0x9764, 0x5996,0x9765, 0x5BB9,0x9766, 0x5EB8,0x9767, 0x63DA,0x9768, 0x63FA,0x9769, 0x64C1,0x976A, 0x66DC,0x976B, 0x694A,0x976C, 0x69D8,0x976D, 0x6D0B,0x976E, 0x6EB6,0x976F, 0x7194,0x9770, 0x7528,0x9771, 0x7AAF,0x9772, 0x7F8A,0x9773, 0x8000,0x9774, 0x8449,0x9775, 0x84C9,0x9776, 0x8981,0x9777, 0x8B21,0x9778, 0x8E0A,0x9779, 0x9065,0x977A, 0x967D,0x977B, 0x990A,0x977C, 0x617E,0x977D, 0x6291,0x977E, 0x6B32,0x9780, 0x6C83,0x9781, 0x6D74,0x9782, 0x7FCC,0x9783, 0x7FFC,0x9784, 0x6DC0,0x9785, 0x7F85,0x9786, 0x87BA,0x9787, 0x88F8,0x9788, 0x6765,0x9789, 0x83B1,0x978A, 0x983C,0x978B, 0x96F7,0x978C, 0x6D1B,0x978D, 0x7D61,0x978E, 0x843D,0x978F, 0x916A,0x9790, 0x4E71,0x9791, 0x5375,0x9792, 0x5D50,0x9793, 0x6B04,0x9794, 0x6FEB,0x9795, 0x85CD,0x9796, 0x862D,0x9797, 0x89A7,0x9798, 0x5229,0x9799, 0x540F,0x979A, 0x5C65,0x979B, 0x674E,0x979C, 0x68A8,0x979D, 0x7406,0x979E, 0x7483,0x979F, 0x75E2,0x97A0, 0x88CF,0x97A1, 0x88E1,0x97A2, 0x91CC,0x97A3, 0x96E2,0x97A4, 0x9678,0x97A5, 0x5F8B,0x97A6, 0x7387,0x97A7, 0x7ACB,0x97A8, 0x844E,0x97A9, 0x63A0,0x97AA, 0x7565,0x97AB, 0x5289,0x97AC, 0x6D41,0x97AD, 0x6E9C,0x97AE, 0x7409,0x97AF, 0x7559,0x97B0, 0x786B,0x97B1, 0x7C92,0x97B2, 0x9686,0x97B3, 0x7ADC,0x97B4, 0x9F8D,0x97B5, 0x4FB6,0x97B6, 0x616E,0x97B7, 0x65C5,0x97B8, 0x865C,0x97B9, 0x4E86,0x97BA, 0x4EAE,0x97BB, 0x50DA,0x97BC, 0x4E21,0x97BD, 0x51CC,0x97BE, 0x5BEE,0x97BF, 0x6599,0x97C0, 0x6881,0x97C1, 0x6DBC,0x97C2, 0x731F,0x97C3, 0x7642,0x97C4, 0x77AD,0x97C5, 0x7A1C,0x97C6, 0x7CE7,0x97C7, 0x826F,0x97C8, 0x8AD2,0x97C9, 0x907C,0x97CA, 0x91CF,0x97CB, 0x9675,0x97CC, 0x9818,0x97CD, 0x529B,0x97CE, 0x7DD1,0x97CF, 0x502B,0x97D0, 0x5398,0x97D1, 0x6797,0x97D2, 0x6DCB,0x97D3, 0x71D0,0x97D4, 0x7433,0x97D5, 0x81E8,0x97D6, 0x8F2A,0x97D7, 0x96A3,0x97D8, 0x9C57,0x97D9, 0x9E9F,0x97DA, 0x7460,0x97DB, 0x5841,0x97DC, 0x6D99,0x97DD, 0x7D2F,0x97DE, 0x985E,0x97DF, 0x4EE4,0x97E0, 0x4F36,0x97E1, 0x4F8B,0x97E2, 0x51B7,0x97E3, 0x52B1,0x97E4, 0x5DBA,0x97E5, 0x601C,0x97E6, 0x73B2,0x97E7, 0x793C,0x97E8, 0x82D3,0x97E9, 0x9234,0x97EA, 0x96B7,0x97EB, 0x96F6,0x97EC, 0x970A,0x97ED, 0x9E97,0x97EE, 0x9F62,0x97EF, 0x66A6,0x97F0, 0x6B74,0x97F1, 0x5217,0x97F2, 0x52A3,0x97F3, 0x70C8,0x97F4, 0x88C2,0x97F5, 0x5EC9,0x97F6, 0x604B,0x97F7, 0x6190,0x97F8, 0x6F23,0x97F9, 0x7149,0x97FA, 0x7C3E,0x97FB, 0x7DF4,0x97FC, 0x806F,0x9840, 0x84EE,0x9841, 0x9023,0x9842, 0x932C,0x9843, 0x5442,0x9844, 0x9B6F,0x9845, 0x6AD3,0x9846, 0x7089,0x9847, 0x8CC2,0x9848, 0x8DEF,0x9849, 0x9732,0x984A, 0x52B4,0x984B, 0x5A41,0x984C, 0x5ECA,0x984D, 0x5F04,0x984E, 0x6717,0x984F, 0x697C,0x9850, 0x6994,0x9851, 0x6D6A,0x9852, 0x6F0F,0x9853, 0x7262,0x9854, 0x72FC,0x9855, 0x7BED,0x9856, 0x8001,0x9857, 0x807E,0x9858, 0x874B,0x9859, 0x90CE,0x985A, 0x516D,0x985B, 0x9E93,0x985C, 0x7984,0x985D, 0x808B,0x985E, 0x9332,0x985F, 0x8AD6,0x9860, 0x502D,0x9861, 0x548C,0x9862, 0x8A71,0x9863, 0x6B6A,0x9864, 0x8CC4,0x9865, 0x8107,0x9866, 0x60D1,0x9867, 0x67A0,0x9868, 0x9DF2,0x9869, 0x4E99,0x986A, 0x4E98,0x986B, 0x9C10,0x986C, 0x8A6B,0x986D, 0x85C1,0x986E, 0x8568,0x986F, 0x6900,0x9870, 0x6E7E,0x9871, 0x7897,0x9872, 0x8155,0x989F, 0x5F0C,0x98A0, 0x4E10,0x98A1, 0x4E15,0x98A2, 0x4E2A,0x98A3, 0x4E31,0x98A4, 0x4E36,0x98A5, 0x4E3C,0x98A6, 0x4E3F,0x98A7, 0x4E42,0x98A8, 0x4E56,0x98A9, 0x4E58,0x98AA, 0x4E82,0x98AB, 0x4E85,0x98AC, 0x8C6B,0x98AD, 0x4E8A,0x98AE, 0x8212,0x98AF, 0x5F0D,0x98B0, 0x4E8E,0x98B1, 0x4E9E,0x98B2, 0x4E9F,0x98B3, 0x4EA0,0x98B4, 0x4EA2,0x98B5, 0x4EB0,0x98B6, 0x4EB3,0x98B7, 0x4EB6,0x98B8, 0x4ECE,0x98B9, 0x4ECD,0x98BA, 0x4EC4,0x98BB, 0x4EC6,0x98BC, 0x4EC2,0x98BD, 0x4ED7,0x98BE, 0x4EDE,0x98BF, 0x4EED,0x98C0, 0x4EDF,0x98C1, 0x4EF7,0x98C2, 0x4F09,0x98C3, 0x4F5A,0x98C4, 0x4F30,0x98C5, 0x4F5B,0x98C6, 0x4F5D,0x98C7, 0x4F57,0x98C8, 0x4F47,0x98C9, 0x4F76,0x98CA, 0x4F88,0x98CB, 0x4F8F,0x98CC, 0x4F98,0x98CD, 0x4F7B,0x98CE, 0x4F69,0x98CF, 0x4F70,0x98D0, 0x4F91,0x98D1, 0x4F6F,0x98D2, 0x4F86,0x98D3, 0x4F96,0x98D4, 0x5118,0x98D5, 0x4FD4,0x98D6, 0x4FDF,0x98D7, 0x4FCE,0x98D8, 0x4FD8,0x98D9, 0x4FDB,0x98DA, 0x4FD1,0x98DB, 0x4FDA,0x98DC, 0x4FD0,0x98DD, 0x4FE4,0x98DE, 0x4FE5,0x98DF, 0x501A,0x98E0, 0x5028,0x98E1, 0x5014,0x98E2, 0x502A,0x98E3, 0x5025,0x98E4, 0x5005,0x98E5, 0x4F1C,0x98E6, 0x4FF6,0x98E7, 0x5021,0x98E8, 0x5029,0x98E9, 0x502C,0x98EA, 0x4FFE,0x98EB, 0x4FEF,0x98EC, 0x5011,0x98ED, 0x5006,0x98EE, 0x5043,0x98EF, 0x5047,0x98F0, 0x6703,0x98F1, 0x5055,0x98F2, 0x5050,0x98F3, 0x5048,0x98F4, 0x505A,0x98F5, 0x5056,0x98F6, 0x506C,0x98F7, 0x5078,0x98F8, 0x5080,0x98F9, 0x509A,0x98FA, 0x5085,0x98FB, 0x50B4,0x98FC, 0x50B2,0x9940, 0x50C9,0x9941, 0x50CA,0x9942, 0x50B3,0x9943, 0x50C2,0x9944, 0x50D6,0x9945, 0x50DE,0x9946, 0x50E5,0x9947, 0x50ED,0x9948, 0x50E3,0x9949, 0x50EE,0x994A, 0x50F9,0x994B, 0x50F5,0x994C, 0x5109,0x994D, 0x5101,0x994E, 0x5102,0x994F, 0x5116,0x9950, 0x5115,0x9951, 0x5114,0x9952, 0x511A,0x9953, 0x5121,0x9954, 0x513A,0x9955, 0x5137,0x9956, 0x513C,0x9957, 0x513B,0x9958, 0x513F,0x9959, 0x5140,0x995A, 0x5152,0x995B, 0x514C,0x995C, 0x5154,0x995D, 0x5162,0x995E, 0x7AF8,0x995F, 0x5169,0x9960, 0x516A,0x9961, 0x516E,0x9962, 0x5180,0x9963, 0x5182,0x9964, 0x56D8,0x9965, 0x518C,0x9966, 0x5189,0x9967, 0x518F,0x9968, 0x5191,0x9969, 0x5193,0x996A, 0x5195,0x996B, 0x5196,0x996C, 0x51A4,0x996D, 0x51A6,0x996E, 0x51A2,0x996F, 0x51A9,0x9970, 0x51AA,0x9971, 0x51AB,0x9972, 0x51B3,0x9973, 0x51B1,0x9974, 0x51B2,0x9975, 0x51B0,0x9976, 0x51B5,0x9977, 0x51BD,0x9978, 0x51C5,0x9979, 0x51C9,0x997A, 0x51DB,0x997B, 0x51E0,0x997C, 0x8655,0x997D, 0x51E9,0x997E, 0x51ED,0x9980, 0x51F0,0x9981, 0x51F5,0x9982, 0x51FE,0x9983, 0x5204,0x9984, 0x520B,0x9985, 0x5214,0x9986, 0x520E,0x9987, 0x5227,0x9988, 0x522A,0x9989, 0x522E,0x998A, 0x5233,0x998B, 0x5239,0x998C, 0x524F,0x998D, 0x5244,0x998E, 0x524B,0x998F, 0x524C,0x9990, 0x525E,0x9991, 0x5254,0x9992, 0x526A,0x9993, 0x5274,0x9994, 0x5269,0x9995, 0x5273,0x9996, 0x527F,0x9997, 0x527D,0x9998, 0x528D,0x9999, 0x5294,0x999A, 0x5292,0x999B, 0x5271,0x999C, 0x5288,0x999D, 0x5291,0x999E, 0x8FA8,0x999F, 0x8FA7,0x99A0, 0x52AC,0x99A1, 0x52AD,0x99A2, 0x52BC,0x99A3, 0x52B5,0x99A4, 0x52C1,0x99A5, 0x52CD,0x99A6, 0x52D7,0x99A7, 0x52DE,0x99A8, 0x52E3,0x99A9, 0x52E6,0x99AA, 0x98ED,0x99AB, 0x52E0,0x99AC, 0x52F3,0x99AD, 0x52F5,0x99AE, 0x52F8,0x99AF, 0x52F9,0x99B0, 0x5306,0x99B1, 0x5308,0x99B2, 0x7538,0x99B3, 0x530D,0x99B4, 0x5310,0x99B5, 0x530F,0x99B6, 0x5315,0x99B7, 0x531A,0x99B8, 0x5323,0x99B9, 0x532F,0x99BA, 0x5331,0x99BB, 0x5333,0x99BC, 0x5338,0x99BD, 0x5340,0x99BE, 0x5346,0x99BF, 0x5345,0x99C0, 0x4E17,0x99C1, 0x5349,0x99C2, 0x534D,0x99C3, 0x51D6,0x99C4, 0x535E,0x99C5, 0x5369,0x99C6, 0x536E,0x99C7, 0x5918,0x99C8, 0x537B,0x99C9, 0x5377,0x99CA, 0x5382,0x99CB, 0x5396,0x99CC, 0x53A0,0x99CD, 0x53A6,0x99CE, 0x53A5,0x99CF, 0x53AE,0x99D0, 0x53B0,0x99D1, 0x53B6,0x99D2, 0x53C3,0x99D3, 0x7C12,0x99D4, 0x96D9,0x99D5, 0x53DF,0x99D6, 0x66FC,0x99D7, 0x71EE,0x99D8, 0x53EE,0x99D9, 0x53E8,0x99DA, 0x53ED,0x99DB, 0x53FA,0x99DC, 0x5401,0x99DD, 0x543D,0x99DE, 0x5440,0x99DF, 0x542C,0x99E0, 0x542D,0x99E1, 0x543C,0x99E2, 0x542E,0x99E3, 0x5436,0x99E4, 0x5429,0x99E5, 0x541D,0x99E6, 0x544E,0x99E7, 0x548F,0x99E8, 0x5475,0x99E9, 0x548E,0x99EA, 0x545F,0x99EB, 0x5471,0x99EC, 0x5477,0x99ED, 0x5470,0x99EE, 0x5492,0x99EF, 0x547B,0x99F0, 0x5480,0x99F1, 0x5476,0x99F2, 0x5484,0x99F3, 0x5490,0x99F4, 0x5486,0x99F5, 0x54C7,0x99F6, 0x54A2,0x99F7, 0x54B8,0x99F8, 0x54A5,0x99F9, 0x54AC,0x99FA, 0x54C4,0x99FB, 0x54C8,0x99FC, 0x54A8,0x9A40, 0x54AB,0x9A41, 0x54C2,0x9A42, 0x54A4,0x9A43, 0x54BE,0x9A44, 0x54BC,0x9A45, 0x54D8,0x9A46, 0x54E5,0x9A47, 0x54E6,0x9A48, 0x550F,0x9A49, 0x5514,0x9A4A, 0x54FD,0x9A4B, 0x54EE,0x9A4C, 0x54ED,0x9A4D, 0x54FA,0x9A4E, 0x54E2,0x9A4F, 0x5539,0x9A50, 0x5540,0x9A51, 0x5563,0x9A52, 0x554C,0x9A53, 0x552E,0x9A54, 0x555C,0x9A55, 0x5545,0x9A56, 0x5556,0x9A57, 0x5557,0x9A58, 0x5538,0x9A59, 0x5533,0x9A5A, 0x555D,0x9A5B, 0x5599,0x9A5C, 0x5580,0x9A5D, 0x54AF,0x9A5E, 0x558A,0x9A5F, 0x559F,0x9A60, 0x557B,0x9A61, 0x557E,0x9A62, 0x5598,0x9A63, 0x559E,0x9A64, 0x55AE,0x9A65, 0x557C,0x9A66, 0x5583,0x9A67, 0x55A9,0x9A68, 0x5587,0x9A69, 0x55A8,0x9A6A, 0x55DA,0x9A6B, 0x55C5,0x9A6C, 0x55DF,0x9A6D, 0x55C4,0x9A6E, 0x55DC,0x9A6F, 0x55E4,0x9A70, 0x55D4,0x9A71, 0x5614,0x9A72, 0x55F7,0x9A73, 0x5616,0x9A74, 0x55FE,0x9A75, 0x55FD,0x9A76, 0x561B,0x9A77, 0x55F9,0x9A78, 0x564E,0x9A79, 0x5650,0x9A7A, 0x71DF,0x9A7B, 0x5634,0x9A7C, 0x5636,0x9A7D, 0x5632,0x9A7E, 0x5638,0x9A80, 0x566B,0x9A81, 0x5664,0x9A82, 0x562F,0x9A83, 0x566C,0x9A84, 0x566A,0x9A85, 0x5686,0x9A86, 0x5680,0x9A87, 0x568A,0x9A88, 0x56A0,0x9A89, 0x5694,0x9A8A, 0x568F,0x9A8B, 0x56A5,0x9A8C, 0x56AE,0x9A8D, 0x56B6,0x9A8E, 0x56B4,0x9A8F, 0x56C2,0x9A90, 0x56BC,0x9A91, 0x56C1,0x9A92, 0x56C3,0x9A93, 0x56C0,0x9A94, 0x56C8,0x9A95, 0x56CE,0x9A96, 0x56D1,0x9A97, 0x56D3,0x9A98, 0x56D7,0x9A99, 0x56EE,0x9A9A, 0x56F9,0x9A9B, 0x5700,0x9A9C, 0x56FF,0x9A9D, 0x5704,0x9A9E, 0x5709,0x9A9F, 0x5708,0x9AA0, 0x570B,0x9AA1, 0x570D,0x9AA2, 0x5713,0x9AA3, 0x5718,0x9AA4, 0x5716,0x9AA5, 0x55C7,0x9AA6, 0x571C,0x9AA7, 0x5726,0x9AA8, 0x5737,0x9AA9, 0x5738,0x9AAA, 0x574E,0x9AAB, 0x573B,0x9AAC, 0x5740,0x9AAD, 0x574F,0x9AAE, 0x5769,0x9AAF, 0x57C0,0x9AB0, 0x5788,0x9AB1, 0x5761,0x9AB2, 0x577F,0x9AB3, 0x5789,0x9AB4, 0x5793,0x9AB5, 0x57A0,0x9AB6, 0x57B3,0x9AB7, 0x57A4,0x9AB8, 0x57AA,0x9AB9, 0x57B0,0x9ABA, 0x57C3,0x9ABB, 0x57C6,0x9ABC, 0x57D4,0x9ABD, 0x57D2,0x9ABE, 0x57D3,0x9ABF, 0x580A,0x9AC0, 0x57D6,0x9AC1, 0x57E3,0x9AC2, 0x580B,0x9AC3, 0x5819,0x9AC4, 0x581D,0x9AC5, 0x5872,0x9AC6, 0x5821,0x9AC7, 0x5862,0x9AC8, 0x584B,0x9AC9, 0x5870,0x9ACA, 0x6BC0,0x9ACB, 0x5852,0x9ACC, 0x583D,0x9ACD, 0x5879,0x9ACE, 0x5885,0x9ACF, 0x58B9,0x9AD0, 0x589F,0x9AD1, 0x58AB,0x9AD2, 0x58BA,0x9AD3, 0x58DE,0x9AD4, 0x58BB,0x9AD5, 0x58B8,0x9AD6, 0x58AE,0x9AD7, 0x58C5,0x9AD8, 0x58D3,0x9AD9, 0x58D1,0x9ADA, 0x58D7,0x9ADB, 0x58D9,0x9ADC, 0x58D8,0x9ADD, 0x58E5,0x9ADE, 0x58DC,0x9ADF, 0x58E4,0x9AE0, 0x58DF,0x9AE1, 0x58EF,0x9AE2, 0x58FA,0x9AE3, 0x58F9,0x9AE4, 0x58FB,0x9AE5, 0x58FC,0x9AE6, 0x58FD,0x9AE7, 0x5902,0x9AE8, 0x590A,0x9AE9, 0x5910,0x9AEA, 0x591B,0x9AEB, 0x68A6,0x9AEC, 0x5925,0x9AED, 0x592C,0x9AEE, 0x592D,0x9AEF, 0x5932,0x9AF0, 0x5938,0x9AF1, 0x593E,0x9AF2, 0x7AD2,0x9AF3, 0x5955,0x9AF4, 0x5950,0x9AF5, 0x594E,0x9AF6, 0x595A,0x9AF7, 0x5958,0x9AF8, 0x5962,0x9AF9, 0x5960,0x9AFA, 0x5967,0x9AFB, 0x596C,0x9AFC, 0x5969,0x9B40, 0x5978,0x9B41, 0x5981,0x9B42, 0x599D,0x9B43, 0x4F5E,0x9B44, 0x4FAB,0x9B45, 0x59A3,0x9B46, 0x59B2,0x9B47, 0x59C6,0x9B48, 0x59E8,0x9B49, 0x59DC,0x9B4A, 0x598D,0x9B4B, 0x59D9,0x9B4C, 0x59DA,0x9B4D, 0x5A25,0x9B4E, 0x5A1F,0x9B4F, 0x5A11,0x9B50, 0x5A1C,0x9B51, 0x5A09,0x9B52, 0x5A1A,0x9B53, 0x5A40,0x9B54, 0x5A6C,0x9B55, 0x5A49,0x9B56, 0x5A35,0x9B57, 0x5A36,0x9B58, 0x5A62,0x9B59, 0x5A6A,0x9B5A, 0x5A9A,0x9B5B, 0x5ABC,0x9B5C, 0x5ABE,0x9B5D, 0x5ACB,0x9B5E, 0x5AC2,0x9B5F, 0x5ABD,0x9B60, 0x5AE3,0x9B61, 0x5AD7,0x9B62, 0x5AE6,0x9B63, 0x5AE9,0x9B64, 0x5AD6,0x9B65, 0x5AFA,0x9B66, 0x5AFB,0x9B67, 0x5B0C,0x9B68, 0x5B0B,0x9B69, 0x5B16,0x9B6A, 0x5B32,0x9B6B, 0x5AD0,0x9B6C, 0x5B2A,0x9B6D, 0x5B36,0x9B6E, 0x5B3E,0x9B6F, 0x5B43,0x9B70, 0x5B45,0x9B71, 0x5B40,0x9B72, 0x5B51,0x9B73, 0x5B55,0x9B74, 0x5B5A,0x9B75, 0x5B5B,0x9B76, 0x5B65,0x9B77, 0x5B69,0x9B78, 0x5B70,0x9B79, 0x5B73,0x9B7A, 0x5B75,0x9B7B, 0x5B78,0x9B7C, 0x6588,0x9B7D, 0x5B7A,0x9B7E, 0x5B80,0x9B80, 0x5B83,0x9B81, 0x5BA6,0x9B82, 0x5BB8,0x9B83, 0x5BC3,0x9B84, 0x5BC7,0x9B85, 0x5BC9,0x9B86, 0x5BD4,0x9B87, 0x5BD0,0x9B88, 0x5BE4,0x9B89, 0x5BE6,0x9B8A, 0x5BE2,0x9B8B, 0x5BDE,0x9B8C, 0x5BE5,0x9B8D, 0x5BEB,0x9B8E, 0x5BF0,0x9B8F, 0x5BF6,0x9B90, 0x5BF3,0x9B91, 0x5C05,0x9B92, 0x5C07,0x9B93, 0x5C08,0x9B94, 0x5C0D,0x9B95, 0x5C13,0x9B96, 0x5C20,0x9B97, 0x5C22,0x9B98, 0x5C28,0x9B99, 0x5C38,0x9B9A, 0x5C39,0x9B9B, 0x5C41,0x9B9C, 0x5C46,0x9B9D, 0x5C4E,0x9B9E, 0x5C53,0x9B9F, 0x5C50,0x9BA0, 0x5C4F,0x9BA1, 0x5B71,0x9BA2, 0x5C6C,0x9BA3, 0x5C6E,0x9BA4, 0x4E62,0x9BA5, 0x5C76,0x9BA6, 0x5C79,0x9BA7, 0x5C8C,0x9BA8, 0x5C91,0x9BA9, 0x5C94,0x9BAA, 0x599B,0x9BAB, 0x5CAB,0x9BAC, 0x5CBB,0x9BAD, 0x5CB6,0x9BAE, 0x5CBC,0x9BAF, 0x5CB7,0x9BB0, 0x5CC5,0x9BB1, 0x5CBE,0x9BB2, 0x5CC7,0x9BB3, 0x5CD9,0x9BB4, 0x5CE9,0x9BB5, 0x5CFD,0x9BB6, 0x5CFA,0x9BB7, 0x5CED,0x9BB8, 0x5D8C,0x9BB9, 0x5CEA,0x9BBA, 0x5D0B,0x9BBB, 0x5D15,0x9BBC, 0x5D17,0x9BBD, 0x5D5C,0x9BBE, 0x5D1F,0x9BBF, 0x5D1B,0x9BC0, 0x5D11,0x9BC1, 0x5D14,0x9BC2, 0x5D22,0x9BC3, 0x5D1A,0x9BC4, 0x5D19,0x9BC5, 0x5D18,0x9BC6, 0x5D4C,0x9BC7, 0x5D52,0x9BC8, 0x5D4E,0x9BC9, 0x5D4B,0x9BCA, 0x5D6C,0x9BCB, 0x5D73,0x9BCC, 0x5D76,0x9BCD, 0x5D87,0x9BCE, 0x5D84,0x9BCF, 0x5D82,0x9BD0, 0x5DA2,0x9BD1, 0x5D9D,0x9BD2, 0x5DAC,0x9BD3, 0x5DAE,0x9BD4, 0x5DBD,0x9BD5, 0x5D90,0x9BD6, 0x5DB7,0x9BD7, 0x5DBC,0x9BD8, 0x5DC9,0x9BD9, 0x5DCD,0x9BDA, 0x5DD3,0x9BDB, 0x5DD2,0x9BDC, 0x5DD6,0x9BDD, 0x5DDB,0x9BDE, 0x5DEB,0x9BDF, 0x5DF2,0x9BE0, 0x5DF5,0x9BE1, 0x5E0B,0x9BE2, 0x5E1A,0x9BE3, 0x5E19,0x9BE4, 0x5E11,0x9BE5, 0x5E1B,0x9BE6, 0x5E36,0x9BE7, 0x5E37,0x9BE8, 0x5E44,0x9BE9, 0x5E43,0x9BEA, 0x5E40,0x9BEB, 0x5E4E,0x9BEC, 0x5E57,0x9BED, 0x5E54,0x9BEE, 0x5E5F,0x9BEF, 0x5E62,0x9BF0, 0x5E64,0x9BF1, 0x5E47,0x9BF2, 0x5E75,0x9BF3, 0x5E76,0x9BF4, 0x5E7A,0x9BF5, 0x9EBC,0x9BF6, 0x5E7F,0x9BF7, 0x5EA0,0x9BF8, 0x5EC1,0x9BF9, 0x5EC2,0x9BFA, 0x5EC8,0x9BFB, 0x5ED0,0x9BFC, 0x5ECF,0x9C40, 0x5ED6,0x9C41, 0x5EE3,0x9C42, 0x5EDD,0x9C43, 0x5EDA,0x9C44, 0x5EDB,0x9C45, 0x5EE2,0x9C46, 0x5EE1,0x9C47, 0x5EE8,0x9C48, 0x5EE9,0x9C49, 0x5EEC,0x9C4A, 0x5EF1,0x9C4B, 0x5EF3,0x9C4C, 0x5EF0,0x9C4D, 0x5EF4,0x9C4E, 0x5EF8,0x9C4F, 0x5EFE,0x9C50, 0x5F03,0x9C51, 0x5F09,0x9C52, 0x5F5D,0x9C53, 0x5F5C,0x9C54, 0x5F0B,0x9C55, 0x5F11,0x9C56, 0x5F16,0x9C57, 0x5F29,0x9C58, 0x5F2D,0x9C59, 0x5F38,0x9C5A, 0x5F41,0x9C5B, 0x5F48,0x9C5C, 0x5F4C,0x9C5D, 0x5F4E,0x9C5E, 0x5F2F,0x9C5F, 0x5F51,0x9C60, 0x5F56,0x9C61, 0x5F57,0x9C62, 0x5F59,0x9C63, 0x5F61,0x9C64, 0x5F6D,0x9C65, 0x5F73,0x9C66, 0x5F77,0x9C67, 0x5F83,0x9C68, 0x5F82,0x9C69, 0x5F7F,0x9C6A, 0x5F8A,0x9C6B, 0x5F88,0x9C6C, 0x5F91,0x9C6D, 0x5F87,0x9C6E, 0x5F9E,0x9C6F, 0x5F99,0x9C70, 0x5F98,0x9C71, 0x5FA0,0x9C72, 0x5FA8,0x9C73, 0x5FAD,0x9C74, 0x5FBC,0x9C75, 0x5FD6,0x9C76, 0x5FFB,0x9C77, 0x5FE4,0x9C78, 0x5FF8,0x9C79, 0x5FF1,0x9C7A, 0x5FDD,0x9C7B, 0x60B3,0x9C7C, 0x5FFF,0x9C7D, 0x6021,0x9C7E, 0x6060,0x9C80, 0x6019,0x9C81, 0x6010,0x9C82, 0x6029,0x9C83, 0x600E,0x9C84, 0x6031,0x9C85, 0x601B,0x9C86, 0x6015,0x9C87, 0x602B,0x9C88, 0x6026,0x9C89, 0x600F,0x9C8A, 0x603A,0x9C8B, 0x605A,0x9C8C, 0x6041,0x9C8D, 0x606A,0x9C8E, 0x6077,0x9C8F, 0x605F,0x9C90, 0x604A,0x9C91, 0x6046,0x9C92, 0x604D,0x9C93, 0x6063,0x9C94, 0x6043,0x9C95, 0x6064,0x9C96, 0x6042,0x9C97, 0x606C,0x9C98, 0x606B,0x9C99, 0x6059,0x9C9A, 0x6081,0x9C9B, 0x608D,0x9C9C, 0x60E7,0x9C9D, 0x6083,0x9C9E, 0x609A,0x9C9F, 0x6084,0x9CA0, 0x609B,0x9CA1, 0x6096,0x9CA2, 0x6097,0x9CA3, 0x6092,0x9CA4, 0x60A7,0x9CA5, 0x608B,0x9CA6, 0x60E1,0x9CA7, 0x60B8,0x9CA8, 0x60E0,0x9CA9, 0x60D3,0x9CAA, 0x60B4,0x9CAB, 0x5FF0,0x9CAC, 0x60BD,0x9CAD, 0x60C6,0x9CAE, 0x60B5,0x9CAF, 0x60D8,0x9CB0, 0x614D,0x9CB1, 0x6115,0x9CB2, 0x6106,0x9CB3, 0x60F6,0x9CB4, 0x60F7,0x9CB5, 0x6100,0x9CB6, 0x60F4,0x9CB7, 0x60FA,0x9CB8, 0x6103,0x9CB9, 0x6121,0x9CBA, 0x60FB,0x9CBB, 0x60F1,0x9CBC, 0x610D,0x9CBD, 0x610E,0x9CBE, 0x6147,0x9CBF, 0x613E,0x9CC0, 0x6128,0x9CC1, 0x6127,0x9CC2, 0x614A,0x9CC3, 0x613F,0x9CC4, 0x613C,0x9CC5, 0x612C,0x9CC6, 0x6134,0x9CC7, 0x613D,0x9CC8, 0x6142,0x9CC9, 0x6144,0x9CCA, 0x6173,0x9CCB, 0x6177,0x9CCC, 0x6158,0x9CCD, 0x6159,0x9CCE, 0x615A,0x9CCF, 0x616B,0x9CD0, 0x6174,0x9CD1, 0x616F,0x9CD2, 0x6165,0x9CD3, 0x6171,0x9CD4, 0x615F,0x9CD5, 0x615D,0x9CD6, 0x6153,0x9CD7, 0x6175,0x9CD8, 0x6199,0x9CD9, 0x6196,0x9CDA, 0x6187,0x9CDB, 0x61AC,0x9CDC, 0x6194,0x9CDD, 0x619A,0x9CDE, 0x618A,0x9CDF, 0x6191,0x9CE0, 0x61AB,0x9CE1, 0x61AE,0x9CE2, 0x61CC,0x9CE3, 0x61CA,0x9CE4, 0x61C9,0x9CE5, 0x61F7,0x9CE6, 0x61C8,0x9CE7, 0x61C3,0x9CE8, 0x61C6,0x9CE9, 0x61BA,0x9CEA, 0x61CB,0x9CEB, 0x7F79,0x9CEC, 0x61CD,0x9CED, 0x61E6,0x9CEE, 0x61E3,0x9CEF, 0x61F6,0x9CF0, 0x61FA,0x9CF1, 0x61F4,0x9CF2, 0x61FF,0x9CF3, 0x61FD,0x9CF4, 0x61FC,0x9CF5, 0x61FE,0x9CF6, 0x6200,0x9CF7, 0x6208,0x9CF8, 0x6209,0x9CF9, 0x620D,0x9CFA, 0x620C,0x9CFB, 0x6214,0x9CFC, 0x621B,0x9D40, 0x621E,0x9D41, 0x6221,0x9D42, 0x622A,0x9D43, 0x622E,0x9D44, 0x6230,0x9D45, 0x6232,0x9D46, 0x6233,0x9D47, 0x6241,0x9D48, 0x624E,0x9D49, 0x625E,0x9D4A, 0x6263,0x9D4B, 0x625B,0x9D4C, 0x6260,0x9D4D, 0x6268,0x9D4E, 0x627C,0x9D4F, 0x6282,0x9D50, 0x6289,0x9D51, 0x627E,0x9D52, 0x6292,0x9D53, 0x6293,0x9D54, 0x6296,0x9D55, 0x62D4,0x9D56, 0x6283,0x9D57, 0x6294,0x9D58, 0x62D7,0x9D59, 0x62D1,0x9D5A, 0x62BB,0x9D5B, 0x62CF,0x9D5C, 0x62FF,0x9D5D, 0x62C6,0x9D5E, 0x64D4,0x9D5F, 0x62C8,0x9D60, 0x62DC,0x9D61, 0x62CC,0x9D62, 0x62CA,0x9D63, 0x62C2,0x9D64, 0x62C7,0x9D65, 0x629B,0x9D66, 0x62C9,0x9D67, 0x630C,0x9D68, 0x62EE,0x9D69, 0x62F1,0x9D6A, 0x6327,0x9D6B, 0x6302,0x9D6C, 0x6308,0x9D6D, 0x62EF,0x9D6E, 0x62F5,0x9D6F, 0x6350,0x9D70, 0x633E,0x9D71, 0x634D,0x9D72, 0x641C,0x9D73, 0x634F,0x9D74, 0x6396,0x9D75, 0x638E,0x9D76, 0x6380,0x9D77, 0x63AB,0x9D78, 0x6376,0x9D79, 0x63A3,0x9D7A, 0x638F,0x9D7B, 0x6389,0x9D7C, 0x639F,0x9D7D, 0x63B5,0x9D7E, 0x636B,0x9D80, 0x6369,0x9D81, 0x63BE,0x9D82, 0x63E9,0x9D83, 0x63C0,0x9D84, 0x63C6,0x9D85, 0x63E3,0x9D86, 0x63C9,0x9D87, 0x63D2,0x9D88, 0x63F6,0x9D89, 0x63C4,0x9D8A, 0x6416,0x9D8B, 0x6434,0x9D8C, 0x6406,0x9D8D, 0x6413,0x9D8E, 0x6426,0x9D8F, 0x6436,0x9D90, 0x651D,0x9D91, 0x6417,0x9D92, 0x6428,0x9D93, 0x640F,0x9D94, 0x6467,0x9D95, 0x646F,0x9D96, 0x6476,0x9D97, 0x644E,0x9D98, 0x652A,0x9D99, 0x6495,0x9D9A, 0x6493,0x9D9B, 0x64A5,0x9D9C, 0x64A9,0x9D9D, 0x6488,0x9D9E, 0x64BC,0x9D9F, 0x64DA,0x9DA0, 0x64D2,0x9DA1, 0x64C5,0x9DA2, 0x64C7,0x9DA3, 0x64BB,0x9DA4, 0x64D8,0x9DA5, 0x64C2,0x9DA6, 0x64F1,0x9DA7, 0x64E7,0x9DA8, 0x8209,0x9DA9, 0x64E0,0x9DAA, 0x64E1,0x9DAB, 0x62AC,0x9DAC, 0x64E3,0x9DAD, 0x64EF,0x9DAE, 0x652C,0x9DAF, 0x64F6,0x9DB0, 0x64F4,0x9DB1, 0x64F2,0x9DB2, 0x64FA,0x9DB3, 0x6500,0x9DB4, 0x64FD,0x9DB5, 0x6518,0x9DB6, 0x651C,0x9DB7, 0x6505,0x9DB8, 0x6524,0x9DB9, 0x6523,0x9DBA, 0x652B,0x9DBB, 0x6534,0x9DBC, 0x6535,0x9DBD, 0x6537,0x9DBE, 0x6536,0x9DBF, 0x6538,0x9DC0, 0x754B,0x9DC1, 0x6548,0x9DC2, 0x6556,0x9DC3, 0x6555,0x9DC4, 0x654D,0x9DC5, 0x6558,0x9DC6, 0x655E,0x9DC7, 0x655D,0x9DC8, 0x6572,0x9DC9, 0x6578,0x9DCA, 0x6582,0x9DCB, 0x6583,0x9DCC, 0x8B8A,0x9DCD, 0x659B,0x9DCE, 0x659F,0x9DCF, 0x65AB,0x9DD0, 0x65B7,0x9DD1, 0x65C3,0x9DD2, 0x65C6,0x9DD3, 0x65C1,0x9DD4, 0x65C4,0x9DD5, 0x65CC,0x9DD6, 0x65D2,0x9DD7, 0x65DB,0x9DD8, 0x65D9,0x9DD9, 0x65E0,0x9DDA, 0x65E1,0x9DDB, 0x65F1,0x9DDC, 0x6772,0x9DDD, 0x660A,0x9DDE, 0x6603,0x9DDF, 0x65FB,0x9DE0, 0x6773,0x9DE1, 0x6635,0x9DE2, 0x6636,0x9DE3, 0x6634,0x9DE4, 0x661C,0x9DE5, 0x664F,0x9DE6, 0x6644,0x9DE7, 0x6649,0x9DE8, 0x6641,0x9DE9, 0x665E,0x9DEA, 0x665D,0x9DEB, 0x6664,0x9DEC, 0x6667,0x9DED, 0x6668,0x9DEE, 0x665F,0x9DEF, 0x6662,0x9DF0, 0x6670,0x9DF1, 0x6683,0x9DF2, 0x6688,0x9DF3, 0x668E,0x9DF4, 0x6689,0x9DF5, 0x6684,0x9DF6, 0x6698,0x9DF7, 0x669D,0x9DF8, 0x66C1,0x9DF9, 0x66B9,0x9DFA, 0x66C9,0x9DFB, 0x66BE,0x9DFC, 0x66BC,0x9E40, 0x66C4,0x9E41, 0x66B8,0x9E42, 0x66D6,0x9E43, 0x66DA,0x9E44, 0x66E0,0x9E45, 0x663F,0x9E46, 0x66E6,0x9E47, 0x66E9,0x9E48, 0x66F0,0x9E49, 0x66F5,0x9E4A, 0x66F7,0x9E4B, 0x670F,0x9E4C, 0x6716,0x9E4D, 0x671E,0x9E4E, 0x6726,0x9E4F, 0x6727,0x9E50, 0x9738,0x9E51, 0x672E,0x9E52, 0x673F,0x9E53, 0x6736,0x9E54, 0x6741,0x9E55, 0x6738,0x9E56, 0x6737,0x9E57, 0x6746,0x9E58, 0x675E,0x9E59, 0x6760,0x9E5A, 0x6759,0x9E5B, 0x6763,0x9E5C, 0x6764,0x9E5D, 0x6789,0x9E5E, 0x6770,0x9E5F, 0x67A9,0x9E60, 0x677C,0x9E61, 0x676A,0x9E62, 0x678C,0x9E63, 0x678B,0x9E64, 0x67A6,0x9E65, 0x67A1,0x9E66, 0x6785,0x9E67, 0x67B7,0x9E68, 0x67EF,0x9E69, 0x67B4,0x9E6A, 0x67EC,0x9E6B, 0x67B3,0x9E6C, 0x67E9,0x9E6D, 0x67B8,0x9E6E, 0x67E4,0x9E6F, 0x67DE,0x9E70, 0x67DD,0x9E71, 0x67E2,0x9E72, 0x67EE,0x9E73, 0x67B9,0x9E74, 0x67CE,0x9E75, 0x67C6,0x9E76, 0x67E7,0x9E77, 0x6A9C,0x9E78, 0x681E,0x9E79, 0x6846,0x9E7A, 0x6829,0x9E7B, 0x6840,0x9E7C, 0x684D,0x9E7D, 0x6832,0x9E7E, 0x684E,0x9E80, 0x68B3,0x9E81, 0x682B,0x9E82, 0x6859,0x9E83, 0x6863,0x9E84, 0x6877,0x9E85, 0x687F,0x9E86, 0x689F,0x9E87, 0x688F,0x9E88, 0x68AD,0x9E89, 0x6894,0x9E8A, 0x689D,0x9E8B, 0x689B,0x9E8C, 0x6883,0x9E8D, 0x6AAE,0x9E8E, 0x68B9,0x9E8F, 0x6874,0x9E90, 0x68B5,0x9E91, 0x68A0,0x9E92, 0x68BA,0x9E93, 0x690F,0x9E94, 0x688D,0x9E95, 0x687E,0x9E96, 0x6901,0x9E97, 0x68CA,0x9E98, 0x6908,0x9E99, 0x68D8,0x9E9A, 0x6922,0x9E9B, 0x6926,0x9E9C, 0x68E1,0x9E9D, 0x690C,0x9E9E, 0x68CD,0x9E9F, 0x68D4,0x9EA0, 0x68E7,0x9EA1, 0x68D5,0x9EA2, 0x6936,0x9EA3, 0x6912,0x9EA4, 0x6904,0x9EA5, 0x68D7,0x9EA6, 0x68E3,0x9EA7, 0x6925,0x9EA8, 0x68F9,0x9EA9, 0x68E0,0x9EAA, 0x68EF,0x9EAB, 0x6928,0x9EAC, 0x692A,0x9EAD, 0x691A,0x9EAE, 0x6923,0x9EAF, 0x6921,0x9EB0, 0x68C6,0x9EB1, 0x6979,0x9EB2, 0x6977,0x9EB3, 0x695C,0x9EB4, 0x6978,0x9EB5, 0x696B,0x9EB6, 0x6954,0x9EB7, 0x697E,0x9EB8, 0x696E,0x9EB9, 0x6939,0x9EBA, 0x6974,0x9EBB, 0x693D,0x9EBC, 0x6959,0x9EBD, 0x6930,0x9EBE, 0x6961,0x9EBF, 0x695E,0x9EC0, 0x695D,0x9EC1, 0x6981,0x9EC2, 0x696A,0x9EC3, 0x69B2,0x9EC4, 0x69AE,0x9EC5, 0x69D0,0x9EC6, 0x69BF,0x9EC7, 0x69C1,0x9EC8, 0x69D3,0x9EC9, 0x69BE,0x9ECA, 0x69CE,0x9ECB, 0x5BE8,0x9ECC, 0x69CA,0x9ECD, 0x69DD,0x9ECE, 0x69BB,0x9ECF, 0x69C3,0x9ED0, 0x69A7,0x9ED1, 0x6A2E,0x9ED2, 0x6991,0x9ED3, 0x69A0,0x9ED4, 0x699C,0x9ED5, 0x6995,0x9ED6, 0x69B4,0x9ED7, 0x69DE,0x9ED8, 0x69E8,0x9ED9, 0x6A02,0x9EDA, 0x6A1B,0x9EDB, 0x69FF,0x9EDC, 0x6B0A,0x9EDD, 0x69F9,0x9EDE, 0x69F2,0x9EDF, 0x69E7,0x9EE0, 0x6A05,0x9EE1, 0x69B1,0x9EE2, 0x6A1E,0x9EE3, 0x69ED,0x9EE4, 0x6A14,0x9EE5, 0x69EB,0x9EE6, 0x6A0A,0x9EE7, 0x6A12,0x9EE8, 0x6AC1,0x9EE9, 0x6A23,0x9EEA, 0x6A13,0x9EEB, 0x6A44,0x9EEC, 0x6A0C,0x9EED, 0x6A72,0x9EEE, 0x6A36,0x9EEF, 0x6A78,0x9EF0, 0x6A47,0x9EF1, 0x6A62,0x9EF2, 0x6A59,0x9EF3, 0x6A66,0x9EF4, 0x6A48,0x9EF5, 0x6A38,0x9EF6, 0x6A22,0x9EF7, 0x6A90,0x9EF8, 0x6A8D,0x9EF9, 0x6AA0,0x9EFA, 0x6A84,0x9EFB, 0x6AA2,0x9EFC, 0x6AA3,0x9F40, 0x6A97,0x9F41, 0x8617,0x9F42, 0x6ABB,0x9F43, 0x6AC3,0x9F44, 0x6AC2,0x9F45, 0x6AB8,0x9F46, 0x6AB3,0x9F47, 0x6AAC,0x9F48, 0x6ADE,0x9F49, 0x6AD1,0x9F4A, 0x6ADF,0x9F4B, 0x6AAA,0x9F4C, 0x6ADA,0x9F4D, 0x6AEA,0x9F4E, 0x6AFB,0x9F4F, 0x6B05,0x9F50, 0x8616,0x9F51, 0x6AFA,0x9F52, 0x6B12,0x9F53, 0x6B16,0x9F54, 0x9B31,0x9F55, 0x6B1F,0x9F56, 0x6B38,0x9F57, 0x6B37,0x9F58, 0x76DC,0x9F59, 0x6B39,0x9F5A, 0x98EE,0x9F5B, 0x6B47,0x9F5C, 0x6B43,0x9F5D, 0x6B49,0x9F5E, 0x6B50,0x9F5F, 0x6B59,0x9F60, 0x6B54,0x9F61, 0x6B5B,0x9F62, 0x6B5F,0x9F63, 0x6B61,0x9F64, 0x6B78,0x9F65, 0x6B79,0x9F66, 0x6B7F,0x9F67, 0x6B80,0x9F68, 0x6B84,0x9F69, 0x6B83,0x9F6A, 0x6B8D,0x9F6B, 0x6B98,0x9F6C, 0x6B95,0x9F6D, 0x6B9E,0x9F6E, 0x6BA4,0x9F6F, 0x6BAA,0x9F70, 0x6BAB,0x9F71, 0x6BAF,0x9F72, 0x6BB2,0x9F73, 0x6BB1,0x9F74, 0x6BB3,0x9F75, 0x6BB7,0x9F76, 0x6BBC,0x9F77, 0x6BC6,0x9F78, 0x6BCB,0x9F79, 0x6BD3,0x9F7A, 0x6BDF,0x9F7B, 0x6BEC,0x9F7C, 0x6BEB,0x9F7D, 0x6BF3,0x9F7E, 0x6BEF,0x9F80, 0x9EBE,0x9F81, 0x6C08,0x9F82, 0x6C13,0x9F83, 0x6C14,0x9F84, 0x6C1B,0x9F85, 0x6C24,0x9F86, 0x6C23,0x9F87, 0x6C5E,0x9F88, 0x6C55,0x9F89, 0x6C62,0x9F8A, 0x6C6A,0x9F8B, 0x6C82,0x9F8C, 0x6C8D,0x9F8D, 0x6C9A,0x9F8E, 0x6C81,0x9F8F, 0x6C9B,0x9F90, 0x6C7E,0x9F91, 0x6C68,0x9F92, 0x6C73,0x9F93, 0x6C92,0x9F94, 0x6C90,0x9F95, 0x6CC4,0x9F96, 0x6CF1,0x9F97, 0x6CD3,0x9F98, 0x6CBD,0x9F99, 0x6CD7,0x9F9A, 0x6CC5,0x9F9B, 0x6CDD,0x9F9C, 0x6CAE,0x9F9D, 0x6CB1,0x9F9E, 0x6CBE,0x9F9F, 0x6CBA,0x9FA0, 0x6CDB,0x9FA1, 0x6CEF,0x9FA2, 0x6CD9,0x9FA3, 0x6CEA,0x9FA4, 0x6D1F,0x9FA5, 0x884D,0x9FA6, 0x6D36,0x9FA7, 0x6D2B,0x9FA8, 0x6D3D,0x9FA9, 0x6D38,0x9FAA, 0x6D19,0x9FAB, 0x6D35,0x9FAC, 0x6D33,0x9FAD, 0x6D12,0x9FAE, 0x6D0C,0x9FAF, 0x6D63,0x9FB0, 0x6D93,0x9FB1, 0x6D64,0x9FB2, 0x6D5A,0x9FB3, 0x6D79,0x9FB4, 0x6D59,0x9FB5, 0x6D8E,0x9FB6, 0x6D95,0x9FB7, 0x6FE4,0x9FB8, 0x6D85,0x9FB9, 0x6DF9,0x9FBA, 0x6E15,0x9FBB, 0x6E0A,0x9FBC, 0x6DB5,0x9FBD, 0x6DC7,0x9FBE, 0x6DE6,0x9FBF, 0x6DB8,0x9FC0, 0x6DC6,0x9FC1, 0x6DEC,0x9FC2, 0x6DDE,0x9FC3, 0x6DCC,0x9FC4, 0x6DE8,0x9FC5, 0x6DD2,0x9FC6, 0x6DC5,0x9FC7, 0x6DFA,0x9FC8, 0x6DD9,0x9FC9, 0x6DE4,0x9FCA, 0x6DD5,0x9FCB, 0x6DEA,0x9FCC, 0x6DEE,0x9FCD, 0x6E2D,0x9FCE, 0x6E6E,0x9FCF, 0x6E2E,0x9FD0, 0x6E19,0x9FD1, 0x6E72,0x9FD2, 0x6E5F,0x9FD3, 0x6E3E,0x9FD4, 0x6E23,0x9FD5, 0x6E6B,0x9FD6, 0x6E2B,0x9FD7, 0x6E76,0x9FD8, 0x6E4D,0x9FD9, 0x6E1F,0x9FDA, 0x6E43,0x9FDB, 0x6E3A,0x9FDC, 0x6E4E,0x9FDD, 0x6E24,0x9FDE, 0x6EFF,0x9FDF, 0x6E1D,0x9FE0, 0x6E38,0x9FE1, 0x6E82,0x9FE2, 0x6EAA,0x9FE3, 0x6E98,0x9FE4, 0x6EC9,0x9FE5, 0x6EB7,0x9FE6, 0x6ED3,0x9FE7, 0x6EBD,0x9FE8, 0x6EAF,0x9FE9, 0x6EC4,0x9FEA, 0x6EB2,0x9FEB, 0x6ED4,0x9FEC, 0x6ED5,0x9FED, 0x6E8F,0x9FEE, 0x6EA5,0x9FEF, 0x6EC2,0x9FF0, 0x6E9F,0x9FF1, 0x6F41,0x9FF2, 0x6F11,0x9FF3, 0x704C,0x9FF4, 0x6EEC,0x9FF5, 0x6EF8,0x9FF6, 0x6EFE,0x9FF7, 0x6F3F,0x9FF8, 0x6EF2,0x9FF9, 0x6F31,0x9FFA, 0x6EEF,0x9FFB, 0x6F32,0x9FFC, 0x6ECC,0xE040, 0x6F3E,0xE041, 0x6F13,0xE042, 0x6EF7,0xE043, 0x6F86,0xE044, 0x6F7A,0xE045, 0x6F78,0xE046, 0x6F81,0xE047, 0x6F80,0xE048, 0x6F6F,0xE049, 0x6F5B,0xE04A, 0x6FF3,0xE04B, 0x6F6D,0xE04C, 0x6F82,0xE04D, 0x6F7C,0xE04E, 0x6F58,0xE04F, 0x6F8E,0xE050, 0x6F91,0xE051, 0x6FC2,0xE052, 0x6F66,0xE053, 0x6FB3,0xE054, 0x6FA3,0xE055, 0x6FA1,0xE056, 0x6FA4,0xE057, 0x6FB9,0xE058, 0x6FC6,0xE059, 0x6FAA,0xE05A, 0x6FDF,0xE05B, 0x6FD5,0xE05C, 0x6FEC,0xE05D, 0x6FD4,0xE05E, 0x6FD8,0xE05F, 0x6FF1,0xE060, 0x6FEE,0xE061, 0x6FDB,0xE062, 0x7009,0xE063, 0x700B,0xE064, 0x6FFA,0xE065, 0x7011,0xE066, 0x7001,0xE067, 0x700F,0xE068, 0x6FFE,0xE069, 0x701B,0xE06A, 0x701A,0xE06B, 0x6F74,0xE06C, 0x701D,0xE06D, 0x7018,0xE06E, 0x701F,0xE06F, 0x7030,0xE070, 0x703E,0xE071, 0x7032,0xE072, 0x7051,0xE073, 0x7063,0xE074, 0x7099,0xE075, 0x7092,0xE076, 0x70AF,0xE077, 0x70F1,0xE078, 0x70AC,0xE079, 0x70B8,0xE07A, 0x70B3,0xE07B, 0x70AE,0xE07C, 0x70DF,0xE07D, 0x70CB,0xE07E, 0x70DD,0xE080, 0x70D9,0xE081, 0x7109,0xE082, 0x70FD,0xE083, 0x711C,0xE084, 0x7119,0xE085, 0x7165,0xE086, 0x7155,0xE087, 0x7188,0xE088, 0x7166,0xE089, 0x7162,0xE08A, 0x714C,0xE08B, 0x7156,0xE08C, 0x716C,0xE08D, 0x718F,0xE08E, 0x71FB,0xE08F, 0x7184,0xE090, 0x7195,0xE091, 0x71A8,0xE092, 0x71AC,0xE093, 0x71D7,0xE094, 0x71B9,0xE095, 0x71BE,0xE096, 0x71D2,0xE097, 0x71C9,0xE098, 0x71D4,0xE099, 0x71CE,0xE09A, 0x71E0,0xE09B, 0x71EC,0xE09C, 0x71E7,0xE09D, 0x71F5,0xE09E, 0x71FC,0xE09F, 0x71F9,0xE0A0, 0x71FF,0xE0A1, 0x720D,0xE0A2, 0x7210,0xE0A3, 0x721B,0xE0A4, 0x7228,0xE0A5, 0x722D,0xE0A6, 0x722C,0xE0A7, 0x7230,0xE0A8, 0x7232,0xE0A9, 0x723B,0xE0AA, 0x723C,0xE0AB, 0x723F,0xE0AC, 0x7240,0xE0AD, 0x7246,0xE0AE, 0x724B,0xE0AF, 0x7258,0xE0B0, 0x7274,0xE0B1, 0x727E,0xE0B2, 0x7282,0xE0B3, 0x7281,0xE0B4, 0x7287,0xE0B5, 0x7292,0xE0B6, 0x7296,0xE0B7, 0x72A2,0xE0B8, 0x72A7,0xE0B9, 0x72B9,0xE0BA, 0x72B2,0xE0BB, 0x72C3,0xE0BC, 0x72C6,0xE0BD, 0x72C4,0xE0BE, 0x72CE,0xE0BF, 0x72D2,0xE0C0, 0x72E2,0xE0C1, 0x72E0,0xE0C2, 0x72E1,0xE0C3, 0x72F9,0xE0C4, 0x72F7,0xE0C5, 0x500F,0xE0C6, 0x7317,0xE0C7, 0x730A,0xE0C8, 0x731C,0xE0C9, 0x7316,0xE0CA, 0x731D,0xE0CB, 0x7334,0xE0CC, 0x732F,0xE0CD, 0x7329,0xE0CE, 0x7325,0xE0CF, 0x733E,0xE0D0, 0x734E,0xE0D1, 0x734F,0xE0D2, 0x9ED8,0xE0D3, 0x7357,0xE0D4, 0x736A,0xE0D5, 0x7368,0xE0D6, 0x7370,0xE0D7, 0x7378,0xE0D8, 0x7375,0xE0D9, 0x737B,0xE0DA, 0x737A,0xE0DB, 0x73C8,0xE0DC, 0x73B3,0xE0DD, 0x73CE,0xE0DE, 0x73BB,0xE0DF, 0x73C0,0xE0E0, 0x73E5,0xE0E1, 0x73EE,0xE0E2, 0x73DE,0xE0E3, 0x74A2,0xE0E4, 0x7405,0xE0E5, 0x746F,0xE0E6, 0x7425,0xE0E7, 0x73F8,0xE0E8, 0x7432,0xE0E9, 0x743A,0xE0EA, 0x7455,0xE0EB, 0x743F,0xE0EC, 0x745F,0xE0ED, 0x7459,0xE0EE, 0x7441,0xE0EF, 0x745C,0xE0F0, 0x7469,0xE0F1, 0x7470,0xE0F2, 0x7463,0xE0F3, 0x746A,0xE0F4, 0x7476,0xE0F5, 0x747E,0xE0F6, 0x748B,0xE0F7, 0x749E,0xE0F8, 0x74A7,0xE0F9, 0x74CA,0xE0FA, 0x74CF,0xE0FB, 0x74D4,0xE0FC, 0x73F1,0xE140, 0x74E0,0xE141, 0x74E3,0xE142, 0x74E7,0xE143, 0x74E9,0xE144, 0x74EE,0xE145, 0x74F2,0xE146, 0x74F0,0xE147, 0x74F1,0xE148, 0x74F8,0xE149, 0x74F7,0xE14A, 0x7504,0xE14B, 0x7503,0xE14C, 0x7505,0xE14D, 0x750C,0xE14E, 0x750E,0xE14F, 0x750D,0xE150, 0x7515,0xE151, 0x7513,0xE152, 0x751E,0xE153, 0x7526,0xE154, 0x752C,0xE155, 0x753C,0xE156, 0x7544,0xE157, 0x754D,0xE158, 0x754A,0xE159, 0x7549,0xE15A, 0x755B,0xE15B, 0x7546,0xE15C, 0x755A,0xE15D, 0x7569,0xE15E, 0x7564,0xE15F, 0x7567,0xE160, 0x756B,0xE161, 0x756D,0xE162, 0x7578,0xE163, 0x7576,0xE164, 0x7586,0xE165, 0x7587,0xE166, 0x7574,0xE167, 0x758A,0xE168, 0x7589,0xE169, 0x7582,0xE16A, 0x7594,0xE16B, 0x759A,0xE16C, 0x759D,0xE16D, 0x75A5,0xE16E, 0x75A3,0xE16F, 0x75C2,0xE170, 0x75B3,0xE171, 0x75C3,0xE172, 0x75B5,0xE173, 0x75BD,0xE174, 0x75B8,0xE175, 0x75BC,0xE176, 0x75B1,0xE177, 0x75CD,0xE178, 0x75CA,0xE179, 0x75D2,0xE17A, 0x75D9,0xE17B, 0x75E3,0xE17C, 0x75DE,0xE17D, 0x75FE,0xE17E, 0x75FF,0xE180, 0x75FC,0xE181, 0x7601,0xE182, 0x75F0,0xE183, 0x75FA,0xE184, 0x75F2,0xE185, 0x75F3,0xE186, 0x760B,0xE187, 0x760D,0xE188, 0x7609,0xE189, 0x761F,0xE18A, 0x7627,0xE18B, 0x7620,0xE18C, 0x7621,0xE18D, 0x7622,0xE18E, 0x7624,0xE18F, 0x7634,0xE190, 0x7630,0xE191, 0x763B,0xE192, 0x7647,0xE193, 0x7648,0xE194, 0x7646,0xE195, 0x765C,0xE196, 0x7658,0xE197, 0x7661,0xE198, 0x7662,0xE199, 0x7668,0xE19A, 0x7669,0xE19B, 0x766A,0xE19C, 0x7667,0xE19D, 0x766C,0xE19E, 0x7670,0xE19F, 0x7672,0xE1A0, 0x7676,0xE1A1, 0x7678,0xE1A2, 0x767C,0xE1A3, 0x7680,0xE1A4, 0x7683,0xE1A5, 0x7688,0xE1A6, 0x768B,0xE1A7, 0x768E,0xE1A8, 0x7696,0xE1A9, 0x7693,0xE1AA, 0x7699,0xE1AB, 0x769A,0xE1AC, 0x76B0,0xE1AD, 0x76B4,0xE1AE, 0x76B8,0xE1AF, 0x76B9,0xE1B0, 0x76BA,0xE1B1, 0x76C2,0xE1B2, 0x76CD,0xE1B3, 0x76D6,0xE1B4, 0x76D2,0xE1B5, 0x76DE,0xE1B6, 0x76E1,0xE1B7, 0x76E5,0xE1B8, 0x76E7,0xE1B9, 0x76EA,0xE1BA, 0x862F,0xE1BB, 0x76FB,0xE1BC, 0x7708,0xE1BD, 0x7707,0xE1BE, 0x7704,0xE1BF, 0x7729,0xE1C0, 0x7724,0xE1C1, 0x771E,0xE1C2, 0x7725,0xE1C3, 0x7726,0xE1C4, 0x771B,0xE1C5, 0x7737,0xE1C6, 0x7738,0xE1C7, 0x7747,0xE1C8, 0x775A,0xE1C9, 0x7768,0xE1CA, 0x776B,0xE1CB, 0x775B,0xE1CC, 0x7765,0xE1CD, 0x777F,0xE1CE, 0x777E,0xE1CF, 0x7779,0xE1D0, 0x778E,0xE1D1, 0x778B,0xE1D2, 0x7791,0xE1D3, 0x77A0,0xE1D4, 0x779E,0xE1D5, 0x77B0,0xE1D6, 0x77B6,0xE1D7, 0x77B9,0xE1D8, 0x77BF,0xE1D9, 0x77BC,0xE1DA, 0x77BD,0xE1DB, 0x77BB,0xE1DC, 0x77C7,0xE1DD, 0x77CD,0xE1DE, 0x77D7,0xE1DF, 0x77DA,0xE1E0, 0x77DC,0xE1E1, 0x77E3,0xE1E2, 0x77EE,0xE1E3, 0x77FC,0xE1E4, 0x780C,0xE1E5, 0x7812,0xE1E6, 0x7926,0xE1E7, 0x7820,0xE1E8, 0x792A,0xE1E9, 0x7845,0xE1EA, 0x788E,0xE1EB, 0x7874,0xE1EC, 0x7886,0xE1ED, 0x787C,0xE1EE, 0x789A,0xE1EF, 0x788C,0xE1F0, 0x78A3,0xE1F1, 0x78B5,0xE1F2, 0x78AA,0xE1F3, 0x78AF,0xE1F4, 0x78D1,0xE1F5, 0x78C6,0xE1F6, 0x78CB,0xE1F7, 0x78D4,0xE1F8, 0x78BE,0xE1F9, 0x78BC,0xE1FA, 0x78C5,0xE1FB, 0x78CA,0xE1FC, 0x78EC,0xE240, 0x78E7,0xE241, 0x78DA,0xE242, 0x78FD,0xE243, 0x78F4,0xE244, 0x7907,0xE245, 0x7912,0xE246, 0x7911,0xE247, 0x7919,0xE248, 0x792C,0xE249, 0x792B,0xE24A, 0x7940,0xE24B, 0x7960,0xE24C, 0x7957,0xE24D, 0x795F,0xE24E, 0x795A,0xE24F, 0x7955,0xE250, 0x7953,0xE251, 0x797A,0xE252, 0x797F,0xE253, 0x798A,0xE254, 0x799D,0xE255, 0x79A7,0xE256, 0x9F4B,0xE257, 0x79AA,0xE258, 0x79AE,0xE259, 0x79B3,0xE25A, 0x79B9,0xE25B, 0x79BA,0xE25C, 0x79C9,0xE25D, 0x79D5,0xE25E, 0x79E7,0xE25F, 0x79EC,0xE260, 0x79E1,0xE261, 0x79E3,0xE262, 0x7A08,0xE263, 0x7A0D,0xE264, 0x7A18,0xE265, 0x7A19,0xE266, 0x7A20,0xE267, 0x7A1F,0xE268, 0x7980,0xE269, 0x7A31,0xE26A, 0x7A3B,0xE26B, 0x7A3E,0xE26C, 0x7A37,0xE26D, 0x7A43,0xE26E, 0x7A57,0xE26F, 0x7A49,0xE270, 0x7A61,0xE271, 0x7A62,0xE272, 0x7A69,0xE273, 0x9F9D,0xE274, 0x7A70,0xE275, 0x7A79,0xE276, 0x7A7D,0xE277, 0x7A88,0xE278, 0x7A97,0xE279, 0x7A95,0xE27A, 0x7A98,0xE27B, 0x7A96,0xE27C, 0x7AA9,0xE27D, 0x7AC8,0xE27E, 0x7AB0,0xE280, 0x7AB6,0xE281, 0x7AC5,0xE282, 0x7AC4,0xE283, 0x7ABF,0xE284, 0x9083,0xE285, 0x7AC7,0xE286, 0x7ACA,0xE287, 0x7ACD,0xE288, 0x7ACF,0xE289, 0x7AD5,0xE28A, 0x7AD3,0xE28B, 0x7AD9,0xE28C, 0x7ADA,0xE28D, 0x7ADD,0xE28E, 0x7AE1,0xE28F, 0x7AE2,0xE290, 0x7AE6,0xE291, 0x7AED,0xE292, 0x7AF0,0xE293, 0x7B02,0xE294, 0x7B0F,0xE295, 0x7B0A,0xE296, 0x7B06,0xE297, 0x7B33,0xE298, 0x7B18,0xE299, 0x7B19,0xE29A, 0x7B1E,0xE29B, 0x7B35,0xE29C, 0x7B28,0xE29D, 0x7B36,0xE29E, 0x7B50,0xE29F, 0x7B7A,0xE2A0, 0x7B04,0xE2A1, 0x7B4D,0xE2A2, 0x7B0B,0xE2A3, 0x7B4C,0xE2A4, 0x7B45,0xE2A5, 0x7B75,0xE2A6, 0x7B65,0xE2A7, 0x7B74,0xE2A8, 0x7B67,0xE2A9, 0x7B70,0xE2AA, 0x7B71,0xE2AB, 0x7B6C,0xE2AC, 0x7B6E,0xE2AD, 0x7B9D,0xE2AE, 0x7B98,0xE2AF, 0x7B9F,0xE2B0, 0x7B8D,0xE2B1, 0x7B9C,0xE2B2, 0x7B9A,0xE2B3, 0x7B8B,0xE2B4, 0x7B92,0xE2B5, 0x7B8F,0xE2B6, 0x7B5D,0xE2B7, 0x7B99,0xE2B8, 0x7BCB,0xE2B9, 0x7BC1,0xE2BA, 0x7BCC,0xE2BB, 0x7BCF,0xE2BC, 0x7BB4,0xE2BD, 0x7BC6,0xE2BE, 0x7BDD,0xE2BF, 0x7BE9,0xE2C0, 0x7C11,0xE2C1, 0x7C14,0xE2C2, 0x7BE6,0xE2C3, 0x7BE5,0xE2C4, 0x7C60,0xE2C5, 0x7C00,0xE2C6, 0x7C07,0xE2C7, 0x7C13,0xE2C8, 0x7BF3,0xE2C9, 0x7BF7,0xE2CA, 0x7C17,0xE2CB, 0x7C0D,0xE2CC, 0x7BF6,0xE2CD, 0x7C23,0xE2CE, 0x7C27,0xE2CF, 0x7C2A,0xE2D0, 0x7C1F,0xE2D1, 0x7C37,0xE2D2, 0x7C2B,0xE2D3, 0x7C3D,0xE2D4, 0x7C4C,0xE2D5, 0x7C43,0xE2D6, 0x7C54,0xE2D7, 0x7C4F,0xE2D8, 0x7C40,0xE2D9, 0x7C50,0xE2DA, 0x7C58,0xE2DB, 0x7C5F,0xE2DC, 0x7C64,0xE2DD, 0x7C56,0xE2DE, 0x7C65,0xE2DF, 0x7C6C,0xE2E0, 0x7C75,0xE2E1, 0x7C83,0xE2E2, 0x7C90,0xE2E3, 0x7CA4,0xE2E4, 0x7CAD,0xE2E5, 0x7CA2,0xE2E6, 0x7CAB,0xE2E7, 0x7CA1,0xE2E8, 0x7CA8,0xE2E9, 0x7CB3,0xE2EA, 0x7CB2,0xE2EB, 0x7CB1,0xE2EC, 0x7CAE,0xE2ED, 0x7CB9,0xE2EE, 0x7CBD,0xE2EF, 0x7CC0,0xE2F0, 0x7CC5,0xE2F1, 0x7CC2,0xE2F2, 0x7CD8,0xE2F3, 0x7CD2,0xE2F4, 0x7CDC,0xE2F5, 0x7CE2,0xE2F6, 0x9B3B,0xE2F7, 0x7CEF,0xE2F8, 0x7CF2,0xE2F9, 0x7CF4,0xE2FA, 0x7CF6,0xE2FB, 0x7CFA,0xE2FC, 0x7D06,0xE340, 0x7D02,0xE341, 0x7D1C,0xE342, 0x7D15,0xE343, 0x7D0A,0xE344, 0x7D45,0xE345, 0x7D4B,0xE346, 0x7D2E,0xE347, 0x7D32,0xE348, 0x7D3F,0xE349, 0x7D35,0xE34A, 0x7D46,0xE34B, 0x7D73,0xE34C, 0x7D56,0xE34D, 0x7D4E,0xE34E, 0x7D72,0xE34F, 0x7D68,0xE350, 0x7D6E,0xE351, 0x7D4F,0xE352, 0x7D63,0xE353, 0x7D93,0xE354, 0x7D89,0xE355, 0x7D5B,0xE356, 0x7D8F,0xE357, 0x7D7D,0xE358, 0x7D9B,0xE359, 0x7DBA,0xE35A, 0x7DAE,0xE35B, 0x7DA3,0xE35C, 0x7DB5,0xE35D, 0x7DC7,0xE35E, 0x7DBD,0xE35F, 0x7DAB,0xE360, 0x7E3D,0xE361, 0x7DA2,0xE362, 0x7DAF,0xE363, 0x7DDC,0xE364, 0x7DB8,0xE365, 0x7D9F,0xE366, 0x7DB0,0xE367, 0x7DD8,0xE368, 0x7DDD,0xE369, 0x7DE4,0xE36A, 0x7DDE,0xE36B, 0x7DFB,0xE36C, 0x7DF2,0xE36D, 0x7DE1,0xE36E, 0x7E05,0xE36F, 0x7E0A,0xE370, 0x7E23,0xE371, 0x7E21,0xE372, 0x7E12,0xE373, 0x7E31,0xE374, 0x7E1F,0xE375, 0x7E09,0xE376, 0x7E0B,0xE377, 0x7E22,0xE378, 0x7E46,0xE379, 0x7E66,0xE37A, 0x7E3B,0xE37B, 0x7E35,0xE37C, 0x7E39,0xE37D, 0x7E43,0xE37E, 0x7E37,0xE380, 0x7E32,0xE381, 0x7E3A,0xE382, 0x7E67,0xE383, 0x7E5D,0xE384, 0x7E56,0xE385, 0x7E5E,0xE386, 0x7E59,0xE387, 0x7E5A,0xE388, 0x7E79,0xE389, 0x7E6A,0xE38A, 0x7E69,0xE38B, 0x7E7C,0xE38C, 0x7E7B,0xE38D, 0x7E83,0xE38E, 0x7DD5,0xE38F, 0x7E7D,0xE390, 0x8FAE,0xE391, 0x7E7F,0xE392, 0x7E88,0xE393, 0x7E89,0xE394, 0x7E8C,0xE395, 0x7E92,0xE396, 0x7E90,0xE397, 0x7E93,0xE398, 0x7E94,0xE399, 0x7E96,0xE39A, 0x7E8E,0xE39B, 0x7E9B,0xE39C, 0x7E9C,0xE39D, 0x7F38,0xE39E, 0x7F3A,0xE39F, 0x7F45,0xE3A0, 0x7F4C,0xE3A1, 0x7F4D,0xE3A2, 0x7F4E,0xE3A3, 0x7F50,0xE3A4, 0x7F51,0xE3A5, 0x7F55,0xE3A6, 0x7F54,0xE3A7, 0x7F58,0xE3A8, 0x7F5F,0xE3A9, 0x7F60,0xE3AA, 0x7F68,0xE3AB, 0x7F69,0xE3AC, 0x7F67,0xE3AD, 0x7F78,0xE3AE, 0x7F82,0xE3AF, 0x7F86,0xE3B0, 0x7F83,0xE3B1, 0x7F88,0xE3B2, 0x7F87,0xE3B3, 0x7F8C,0xE3B4, 0x7F94,0xE3B5, 0x7F9E,0xE3B6, 0x7F9D,0xE3B7, 0x7F9A,0xE3B8, 0x7FA3,0xE3B9, 0x7FAF,0xE3BA, 0x7FB2,0xE3BB, 0x7FB9,0xE3BC, 0x7FAE,0xE3BD, 0x7FB6,0xE3BE, 0x7FB8,0xE3BF, 0x8B71,0xE3C0, 0x7FC5,0xE3C1, 0x7FC6,0xE3C2, 0x7FCA,0xE3C3, 0x7FD5,0xE3C4, 0x7FD4,0xE3C5, 0x7FE1,0xE3C6, 0x7FE6,0xE3C7, 0x7FE9,0xE3C8, 0x7FF3,0xE3C9, 0x7FF9,0xE3CA, 0x98DC,0xE3CB, 0x8006,0xE3CC, 0x8004,0xE3CD, 0x800B,0xE3CE, 0x8012,0xE3CF, 0x8018,0xE3D0, 0x8019,0xE3D1, 0x801C,0xE3D2, 0x8021,0xE3D3, 0x8028,0xE3D4, 0x803F,0xE3D5, 0x803B,0xE3D6, 0x804A,0xE3D7, 0x8046,0xE3D8, 0x8052,0xE3D9, 0x8058,0xE3DA, 0x805A,0xE3DB, 0x805F,0xE3DC, 0x8062,0xE3DD, 0x8068,0xE3DE, 0x8073,0xE3DF, 0x8072,0xE3E0, 0x8070,0xE3E1, 0x8076,0xE3E2, 0x8079,0xE3E3, 0x807D,0xE3E4, 0x807F,0xE3E5, 0x8084,0xE3E6, 0x8086,0xE3E7, 0x8085,0xE3E8, 0x809B,0xE3E9, 0x8093,0xE3EA, 0x809A,0xE3EB, 0x80AD,0xE3EC, 0x5190,0xE3ED, 0x80AC,0xE3EE, 0x80DB,0xE3EF, 0x80E5,0xE3F0, 0x80D9,0xE3F1, 0x80DD,0xE3F2, 0x80C4,0xE3F3, 0x80DA,0xE3F4, 0x80D6,0xE3F5, 0x8109,0xE3F6, 0x80EF,0xE3F7, 0x80F1,0xE3F8, 0x811B,0xE3F9, 0x8129,0xE3FA, 0x8123,0xE3FB, 0x812F,0xE3FC, 0x814B,0xE440, 0x968B,0xE441, 0x8146,0xE442, 0x813E,0xE443, 0x8153,0xE444, 0x8151,0xE445, 0x80FC,0xE446, 0x8171,0xE447, 0x816E,0xE448, 0x8165,0xE449, 0x8166,0xE44A, 0x8174,0xE44B, 0x8183,0xE44C, 0x8188,0xE44D, 0x818A,0xE44E, 0x8180,0xE44F, 0x8182,0xE450, 0x81A0,0xE451, 0x8195,0xE452, 0x81A4,0xE453, 0x81A3,0xE454, 0x815F,0xE455, 0x8193,0xE456, 0x81A9,0xE457, 0x81B0,0xE458, 0x81B5,0xE459, 0x81BE,0xE45A, 0x81B8,0xE45B, 0x81BD,0xE45C, 0x81C0,0xE45D, 0x81C2,0xE45E, 0x81BA,0xE45F, 0x81C9,0xE460, 0x81CD,0xE461, 0x81D1,0xE462, 0x81D9,0xE463, 0x81D8,0xE464, 0x81C8,0xE465, 0x81DA,0xE466, 0x81DF,0xE467, 0x81E0,0xE468, 0x81E7,0xE469, 0x81FA,0xE46A, 0x81FB,0xE46B, 0x81FE,0xE46C, 0x8201,0xE46D, 0x8202,0xE46E, 0x8205,0xE46F, 0x8207,0xE470, 0x820A,0xE471, 0x820D,0xE472, 0x8210,0xE473, 0x8216,0xE474, 0x8229,0xE475, 0x822B,0xE476, 0x8238,0xE477, 0x8233,0xE478, 0x8240,0xE479, 0x8259,0xE47A, 0x8258,0xE47B, 0x825D,0xE47C, 0x825A,0xE47D, 0x825F,0xE47E, 0x8264,0xE480, 0x8262,0xE481, 0x8268,0xE482, 0x826A,0xE483, 0x826B,0xE484, 0x822E,0xE485, 0x8271,0xE486, 0x8277,0xE487, 0x8278,0xE488, 0x827E,0xE489, 0x828D,0xE48A, 0x8292,0xE48B, 0x82AB,0xE48C, 0x829F,0xE48D, 0x82BB,0xE48E, 0x82AC,0xE48F, 0x82E1,0xE490, 0x82E3,0xE491, 0x82DF,0xE492, 0x82D2,0xE493, 0x82F4,0xE494, 0x82F3,0xE495, 0x82FA,0xE496, 0x8393,0xE497, 0x8303,0xE498, 0x82FB,0xE499, 0x82F9,0xE49A, 0x82DE,0xE49B, 0x8306,0xE49C, 0x82DC,0xE49D, 0x8309,0xE49E, 0x82D9,0xE49F, 0x8335,0xE4A0, 0x8334,0xE4A1, 0x8316,0xE4A2, 0x8332,0xE4A3, 0x8331,0xE4A4, 0x8340,0xE4A5, 0x8339,0xE4A6, 0x8350,0xE4A7, 0x8345,0xE4A8, 0x832F,0xE4A9, 0x832B,0xE4AA, 0x8317,0xE4AB, 0x8318,0xE4AC, 0x8385,0xE4AD, 0x839A,0xE4AE, 0x83AA,0xE4AF, 0x839F,0xE4B0, 0x83A2,0xE4B1, 0x8396,0xE4B2, 0x8323,0xE4B3, 0x838E,0xE4B4, 0x8387,0xE4B5, 0x838A,0xE4B6, 0x837C,0xE4B7, 0x83B5,0xE4B8, 0x8373,0xE4B9, 0x8375,0xE4BA, 0x83A0,0xE4BB, 0x8389,0xE4BC, 0x83A8,0xE4BD, 0x83F4,0xE4BE, 0x8413,0xE4BF, 0x83EB,0xE4C0, 0x83CE,0xE4C1, 0x83FD,0xE4C2, 0x8403,0xE4C3, 0x83D8,0xE4C4, 0x840B,0xE4C5, 0x83C1,0xE4C6, 0x83F7,0xE4C7, 0x8407,0xE4C8, 0x83E0,0xE4C9, 0x83F2,0xE4CA, 0x840D,0xE4CB, 0x8422,0xE4CC, 0x8420,0xE4CD, 0x83BD,0xE4CE, 0x8438,0xE4CF, 0x8506,0xE4D0, 0x83FB,0xE4D1, 0x846D,0xE4D2, 0x842A,0xE4D3, 0x843C,0xE4D4, 0x855A,0xE4D5, 0x8484,0xE4D6, 0x8477,0xE4D7, 0x846B,0xE4D8, 0x84AD,0xE4D9, 0x846E,0xE4DA, 0x8482,0xE4DB, 0x8469,0xE4DC, 0x8446,0xE4DD, 0x842C,0xE4DE, 0x846F,0xE4DF, 0x8479,0xE4E0, 0x8435,0xE4E1, 0x84CA,0xE4E2, 0x8462,0xE4E3, 0x84B9,0xE4E4, 0x84BF,0xE4E5, 0x849F,0xE4E6, 0x84D9,0xE4E7, 0x84CD,0xE4E8, 0x84BB,0xE4E9, 0x84DA,0xE4EA, 0x84D0,0xE4EB, 0x84C1,0xE4EC, 0x84C6,0xE4ED, 0x84D6,0xE4EE, 0x84A1,0xE4EF, 0x8521,0xE4F0, 0x84FF,0xE4F1, 0x84F4,0xE4F2, 0x8517,0xE4F3, 0x8518,0xE4F4, 0x852C,0xE4F5, 0x851F,0xE4F6, 0x8515,0xE4F7, 0x8514,0xE4F8, 0x84FC,0xE4F9, 0x8540,0xE4FA, 0x8563,0xE4FB, 0x8558,0xE4FC, 0x8548,0xE540, 0x8541,0xE541, 0x8602,0xE542, 0x854B,0xE543, 0x8555,0xE544, 0x8580,0xE545, 0x85A4,0xE546, 0x8588,0xE547, 0x8591,0xE548, 0x858A,0xE549, 0x85A8,0xE54A, 0x856D,0xE54B, 0x8594,0xE54C, 0x859B,0xE54D, 0x85EA,0xE54E, 0x8587,0xE54F, 0x859C,0xE550, 0x8577,0xE551, 0x857E,0xE552, 0x8590,0xE553, 0x85C9,0xE554, 0x85BA,0xE555, 0x85CF,0xE556, 0x85B9,0xE557, 0x85D0,0xE558, 0x85D5,0xE559, 0x85DD,0xE55A, 0x85E5,0xE55B, 0x85DC,0xE55C, 0x85F9,0xE55D, 0x860A,0xE55E, 0x8613,0xE55F, 0x860B,0xE560, 0x85FE,0xE561, 0x85FA,0xE562, 0x8606,0xE563, 0x8622,0xE564, 0x861A,0xE565, 0x8630,0xE566, 0x863F,0xE567, 0x864D,0xE568, 0x4E55,0xE569, 0x8654,0xE56A, 0x865F,0xE56B, 0x8667,0xE56C, 0x8671,0xE56D, 0x8693,0xE56E, 0x86A3,0xE56F, 0x86A9,0xE570, 0x86AA,0xE571, 0x868B,0xE572, 0x868C,0xE573, 0x86B6,0xE574, 0x86AF,0xE575, 0x86C4,0xE576, 0x86C6,0xE577, 0x86B0,0xE578, 0x86C9,0xE579, 0x8823,0xE57A, 0x86AB,0xE57B, 0x86D4,0xE57C, 0x86DE,0xE57D, 0x86E9,0xE57E, 0x86EC,0xE580, 0x86DF,0xE581, 0x86DB,0xE582, 0x86EF,0xE583, 0x8712,0xE584, 0x8706,0xE585, 0x8708,0xE586, 0x8700,0xE587, 0x8703,0xE588, 0x86FB,0xE589, 0x8711,0xE58A, 0x8709,0xE58B, 0x870D,0xE58C, 0x86F9,0xE58D, 0x870A,0xE58E, 0x8734,0xE58F, 0x873F,0xE590, 0x8737,0xE591, 0x873B,0xE592, 0x8725,0xE593, 0x8729,0xE594, 0x871A,0xE595, 0x8760,0xE596, 0x875F,0xE597, 0x8778,0xE598, 0x874C,0xE599, 0x874E,0xE59A, 0x8774,0xE59B, 0x8757,0xE59C, 0x8768,0xE59D, 0x876E,0xE59E, 0x8759,0xE59F, 0x8753,0xE5A0, 0x8763,0xE5A1, 0x876A,0xE5A2, 0x8805,0xE5A3, 0x87A2,0xE5A4, 0x879F,0xE5A5, 0x8782,0xE5A6, 0x87AF,0xE5A7, 0x87CB,0xE5A8, 0x87BD,0xE5A9, 0x87C0,0xE5AA, 0x87D0,0xE5AB, 0x96D6,0xE5AC, 0x87AB,0xE5AD, 0x87C4,0xE5AE, 0x87B3,0xE5AF, 0x87C7,0xE5B0, 0x87C6,0xE5B1, 0x87BB,0xE5B2, 0x87EF,0xE5B3, 0x87F2,0xE5B4, 0x87E0,0xE5B5, 0x880F,0xE5B6, 0x880D,0xE5B7, 0x87FE,0xE5B8, 0x87F6,0xE5B9, 0x87F7,0xE5BA, 0x880E,0xE5BB, 0x87D2,0xE5BC, 0x8811,0xE5BD, 0x8816,0xE5BE, 0x8815,0xE5BF, 0x8822,0xE5C0, 0x8821,0xE5C1, 0x8831,0xE5C2, 0x8836,0xE5C3, 0x8839,0xE5C4, 0x8827,0xE5C5, 0x883B,0xE5C6, 0x8844,0xE5C7, 0x8842,0xE5C8, 0x8852,0xE5C9, 0x8859,0xE5CA, 0x885E,0xE5CB, 0x8862,0xE5CC, 0x886B,0xE5CD, 0x8881,0xE5CE, 0x887E,0xE5CF, 0x889E,0xE5D0, 0x8875,0xE5D1, 0x887D,0xE5D2, 0x88B5,0xE5D3, 0x8872,0xE5D4, 0x8882,0xE5D5, 0x8897,0xE5D6, 0x8892,0xE5D7, 0x88AE,0xE5D8, 0x8899,0xE5D9, 0x88A2,0xE5DA, 0x888D,0xE5DB, 0x88A4,0xE5DC, 0x88B0,0xE5DD, 0x88BF,0xE5DE, 0x88B1,0xE5DF, 0x88C3,0xE5E0, 0x88C4,0xE5E1, 0x88D4,0xE5E2, 0x88D8,0xE5E3, 0x88D9,0xE5E4, 0x88DD,0xE5E5, 0x88F9,0xE5E6, 0x8902,0xE5E7, 0x88FC,0xE5E8, 0x88F4,0xE5E9, 0x88E8,0xE5EA, 0x88F2,0xE5EB, 0x8904,0xE5EC, 0x890C,0xE5ED, 0x890A,0xE5EE, 0x8913,0xE5EF, 0x8943,0xE5F0, 0x891E,0xE5F1, 0x8925,0xE5F2, 0x892A,0xE5F3, 0x892B,0xE5F4, 0x8941,0xE5F5, 0x8944,0xE5F6, 0x893B,0xE5F7, 0x8936,0xE5F8, 0x8938,0xE5F9, 0x894C,0xE5FA, 0x891D,0xE5FB, 0x8960,0xE5FC, 0x895E,0xE640, 0x8966,0xE641, 0x8964,0xE642, 0x896D,0xE643, 0x896A,0xE644, 0x896F,0xE645, 0x8974,0xE646, 0x8977,0xE647, 0x897E,0xE648, 0x8983,0xE649, 0x8988,0xE64A, 0x898A,0xE64B, 0x8993,0xE64C, 0x8998,0xE64D, 0x89A1,0xE64E, 0x89A9,0xE64F, 0x89A6,0xE650, 0x89AC,0xE651, 0x89AF,0xE652, 0x89B2,0xE653, 0x89BA,0xE654, 0x89BD,0xE655, 0x89BF,0xE656, 0x89C0,0xE657, 0x89DA,0xE658, 0x89DC,0xE659, 0x89DD,0xE65A, 0x89E7,0xE65B, 0x89F4,0xE65C, 0x89F8,0xE65D, 0x8A03,0xE65E, 0x8A16,0xE65F, 0x8A10,0xE660, 0x8A0C,0xE661, 0x8A1B,0xE662, 0x8A1D,0xE663, 0x8A25,0xE664, 0x8A36,0xE665, 0x8A41,0xE666, 0x8A5B,0xE667, 0x8A52,0xE668, 0x8A46,0xE669, 0x8A48,0xE66A, 0x8A7C,0xE66B, 0x8A6D,0xE66C, 0x8A6C,0xE66D, 0x8A62,0xE66E, 0x8A85,0xE66F, 0x8A82,0xE670, 0x8A84,0xE671, 0x8AA8,0xE672, 0x8AA1,0xE673, 0x8A91,0xE674, 0x8AA5,0xE675, 0x8AA6,0xE676, 0x8A9A,0xE677, 0x8AA3,0xE678, 0x8AC4,0xE679, 0x8ACD,0xE67A, 0x8AC2,0xE67B, 0x8ADA,0xE67C, 0x8AEB,0xE67D, 0x8AF3,0xE67E, 0x8AE7,0xE680, 0x8AE4,0xE681, 0x8AF1,0xE682, 0x8B14,0xE683, 0x8AE0,0xE684, 0x8AE2,0xE685, 0x8AF7,0xE686, 0x8ADE,0xE687, 0x8ADB,0xE688, 0x8B0C,0xE689, 0x8B07,0xE68A, 0x8B1A,0xE68B, 0x8AE1,0xE68C, 0x8B16,0xE68D, 0x8B10,0xE68E, 0x8B17,0xE68F, 0x8B20,0xE690, 0x8B33,0xE691, 0x97AB,0xE692, 0x8B26,0xE693, 0x8B2B,0xE694, 0x8B3E,0xE695, 0x8B28,0xE696, 0x8B41,0xE697, 0x8B4C,0xE698, 0x8B4F,0xE699, 0x8B4E,0xE69A, 0x8B49,0xE69B, 0x8B56,0xE69C, 0x8B5B,0xE69D, 0x8B5A,0xE69E, 0x8B6B,0xE69F, 0x8B5F,0xE6A0, 0x8B6C,0xE6A1, 0x8B6F,0xE6A2, 0x8B74,0xE6A3, 0x8B7D,0xE6A4, 0x8B80,0xE6A5, 0x8B8C,0xE6A6, 0x8B8E,0xE6A7, 0x8B92,0xE6A8, 0x8B93,0xE6A9, 0x8B96,0xE6AA, 0x8B99,0xE6AB, 0x8B9A,0xE6AC, 0x8C3A,0xE6AD, 0x8C41,0xE6AE, 0x8C3F,0xE6AF, 0x8C48,0xE6B0, 0x8C4C,0xE6B1, 0x8C4E,0xE6B2, 0x8C50,0xE6B3, 0x8C55,0xE6B4, 0x8C62,0xE6B5, 0x8C6C,0xE6B6, 0x8C78,0xE6B7, 0x8C7A,0xE6B8, 0x8C82,0xE6B9, 0x8C89,0xE6BA, 0x8C85,0xE6BB, 0x8C8A,0xE6BC, 0x8C8D,0xE6BD, 0x8C8E,0xE6BE, 0x8C94,0xE6BF, 0x8C7C,0xE6C0, 0x8C98,0xE6C1, 0x621D,0xE6C2, 0x8CAD,0xE6C3, 0x8CAA,0xE6C4, 0x8CBD,0xE6C5, 0x8CB2,0xE6C6, 0x8CB3,0xE6C7, 0x8CAE,0xE6C8, 0x8CB6,0xE6C9, 0x8CC8,0xE6CA, 0x8CC1,0xE6CB, 0x8CE4,0xE6CC, 0x8CE3,0xE6CD, 0x8CDA,0xE6CE, 0x8CFD,0xE6CF, 0x8CFA,0xE6D0, 0x8CFB,0xE6D1, 0x8D04,0xE6D2, 0x8D05,0xE6D3, 0x8D0A,0xE6D4, 0x8D07,0xE6D5, 0x8D0F,0xE6D6, 0x8D0D,0xE6D7, 0x8D10,0xE6D8, 0x9F4E,0xE6D9, 0x8D13,0xE6DA, 0x8CCD,0xE6DB, 0x8D14,0xE6DC, 0x8D16,0xE6DD, 0x8D67,0xE6DE, 0x8D6D,0xE6DF, 0x8D71,0xE6E0, 0x8D73,0xE6E1, 0x8D81,0xE6E2, 0x8D99,0xE6E3, 0x8DC2,0xE6E4, 0x8DBE,0xE6E5, 0x8DBA,0xE6E6, 0x8DCF,0xE6E7, 0x8DDA,0xE6E8, 0x8DD6,0xE6E9, 0x8DCC,0xE6EA, 0x8DDB,0xE6EB, 0x8DCB,0xE6EC, 0x8DEA,0xE6ED, 0x8DEB,0xE6EE, 0x8DDF,0xE6EF, 0x8DE3,0xE6F0, 0x8DFC,0xE6F1, 0x8E08,0xE6F2, 0x8E09,0xE6F3, 0x8DFF,0xE6F4, 0x8E1D,0xE6F5, 0x8E1E,0xE6F6, 0x8E10,0xE6F7, 0x8E1F,0xE6F8, 0x8E42,0xE6F9, 0x8E35,0xE6FA, 0x8E30,0xE6FB, 0x8E34,0xE6FC, 0x8E4A,0xE740, 0x8E47,0xE741, 0x8E49,0xE742, 0x8E4C,0xE743, 0x8E50,0xE744, 0x8E48,0xE745, 0x8E59,0xE746, 0x8E64,0xE747, 0x8E60,0xE748, 0x8E2A,0xE749, 0x8E63,0xE74A, 0x8E55,0xE74B, 0x8E76,0xE74C, 0x8E72,0xE74D, 0x8E7C,0xE74E, 0x8E81,0xE74F, 0x8E87,0xE750, 0x8E85,0xE751, 0x8E84,0xE752, 0x8E8B,0xE753, 0x8E8A,0xE754, 0x8E93,0xE755, 0x8E91,0xE756, 0x8E94,0xE757, 0x8E99,0xE758, 0x8EAA,0xE759, 0x8EA1,0xE75A, 0x8EAC,0xE75B, 0x8EB0,0xE75C, 0x8EC6,0xE75D, 0x8EB1,0xE75E, 0x8EBE,0xE75F, 0x8EC5,0xE760, 0x8EC8,0xE761, 0x8ECB,0xE762, 0x8EDB,0xE763, 0x8EE3,0xE764, 0x8EFC,0xE765, 0x8EFB,0xE766, 0x8EEB,0xE767, 0x8EFE,0xE768, 0x8F0A,0xE769, 0x8F05,0xE76A, 0x8F15,0xE76B, 0x8F12,0xE76C, 0x8F19,0xE76D, 0x8F13,0xE76E, 0x8F1C,0xE76F, 0x8F1F,0xE770, 0x8F1B,0xE771, 0x8F0C,0xE772, 0x8F26,0xE773, 0x8F33,0xE774, 0x8F3B,0xE775, 0x8F39,0xE776, 0x8F45,0xE777, 0x8F42,0xE778, 0x8F3E,0xE779, 0x8F4C,0xE77A, 0x8F49,0xE77B, 0x8F46,0xE77C, 0x8F4E,0xE77D, 0x8F57,0xE77E, 0x8F5C,0xE780, 0x8F62,0xE781, 0x8F63,0xE782, 0x8F64,0xE783, 0x8F9C,0xE784, 0x8F9F,0xE785, 0x8FA3,0xE786, 0x8FAD,0xE787, 0x8FAF,0xE788, 0x8FB7,0xE789, 0x8FDA,0xE78A, 0x8FE5,0xE78B, 0x8FE2,0xE78C, 0x8FEA,0xE78D, 0x8FEF,0xE78E, 0x9087,0xE78F, 0x8FF4,0xE790, 0x9005,0xE791, 0x8FF9,0xE792, 0x8FFA,0xE793, 0x9011,0xE794, 0x9015,0xE795, 0x9021,0xE796, 0x900D,0xE797, 0x901E,0xE798, 0x9016,0xE799, 0x900B,0xE79A, 0x9027,0xE79B, 0x9036,0xE79C, 0x9035,0xE79D, 0x9039,0xE79E, 0x8FF8,0xE79F, 0x904F,0xE7A0, 0x9050,0xE7A1, 0x9051,0xE7A2, 0x9052,0xE7A3, 0x900E,0xE7A4, 0x9049,0xE7A5, 0x903E,0xE7A6, 0x9056,0xE7A7, 0x9058,0xE7A8, 0x905E,0xE7A9, 0x9068,0xE7AA, 0x906F,0xE7AB, 0x9076,0xE7AC, 0x96A8,0xE7AD, 0x9072,0xE7AE, 0x9082,0xE7AF, 0x907D,0xE7B0, 0x9081,0xE7B1, 0x9080,0xE7B2, 0x908A,0xE7B3, 0x9089,0xE7B4, 0x908F,0xE7B5, 0x90A8,0xE7B6, 0x90AF,0xE7B7, 0x90B1,0xE7B8, 0x90B5,0xE7B9, 0x90E2,0xE7BA, 0x90E4,0xE7BB, 0x6248,0xE7BC, 0x90DB,0xE7BD, 0x9102,0xE7BE, 0x9112,0xE7BF, 0x9119,0xE7C0, 0x9132,0xE7C1, 0x9130,0xE7C2, 0x914A,0xE7C3, 0x9156,0xE7C4, 0x9158,0xE7C5, 0x9163,0xE7C6, 0x9165,0xE7C7, 0x9169,0xE7C8, 0x9173,0xE7C9, 0x9172,0xE7CA, 0x918B,0xE7CB, 0x9189,0xE7CC, 0x9182,0xE7CD, 0x91A2,0xE7CE, 0x91AB,0xE7CF, 0x91AF,0xE7D0, 0x91AA,0xE7D1, 0x91B5,0xE7D2, 0x91B4,0xE7D3, 0x91BA,0xE7D4, 0x91C0,0xE7D5, 0x91C1,0xE7D6, 0x91C9,0xE7D7, 0x91CB,0xE7D8, 0x91D0,0xE7D9, 0x91D6,0xE7DA, 0x91DF,0xE7DB, 0x91E1,0xE7DC, 0x91DB,0xE7DD, 0x91FC,0xE7DE, 0x91F5,0xE7DF, 0x91F6,0xE7E0, 0x921E,0xE7E1, 0x91FF,0xE7E2, 0x9214,0xE7E3, 0x922C,0xE7E4, 0x9215,0xE7E5, 0x9211,0xE7E6, 0x925E,0xE7E7, 0x9257,0xE7E8, 0x9245,0xE7E9, 0x9249,0xE7EA, 0x9264,0xE7EB, 0x9248,0xE7EC, 0x9295,0xE7ED, 0x923F,0xE7EE, 0x924B,0xE7EF, 0x9250,0xE7F0, 0x929C,0xE7F1, 0x9296,0xE7F2, 0x9293,0xE7F3, 0x929B,0xE7F4, 0x925A,0xE7F5, 0x92CF,0xE7F6, 0x92B9,0xE7F7, 0x92B7,0xE7F8, 0x92E9,0xE7F9, 0x930F,0xE7FA, 0x92FA,0xE7FB, 0x9344,0xE7FC, 0x932E,0xE840, 0x9319,0xE841, 0x9322,0xE842, 0x931A,0xE843, 0x9323,0xE844, 0x933A,0xE845, 0x9335,0xE846, 0x933B,0xE847, 0x935C,0xE848, 0x9360,0xE849, 0x937C,0xE84A, 0x936E,0xE84B, 0x9356,0xE84C, 0x93B0,0xE84D, 0x93AC,0xE84E, 0x93AD,0xE84F, 0x9394,0xE850, 0x93B9,0xE851, 0x93D6,0xE852, 0x93D7,0xE853, 0x93E8,0xE854, 0x93E5,0xE855, 0x93D8,0xE856, 0x93C3,0xE857, 0x93DD,0xE858, 0x93D0,0xE859, 0x93C8,0xE85A, 0x93E4,0xE85B, 0x941A,0xE85C, 0x9414,0xE85D, 0x9413,0xE85E, 0x9403,0xE85F, 0x9407,0xE860, 0x9410,0xE861, 0x9436,0xE862, 0x942B,0xE863, 0x9435,0xE864, 0x9421,0xE865, 0x943A,0xE866, 0x9441,0xE867, 0x9452,0xE868, 0x9444,0xE869, 0x945B,0xE86A, 0x9460,0xE86B, 0x9462,0xE86C, 0x945E,0xE86D, 0x946A,0xE86E, 0x9229,0xE86F, 0x9470,0xE870, 0x9475,0xE871, 0x9477,0xE872, 0x947D,0xE873, 0x945A,0xE874, 0x947C,0xE875, 0x947E,0xE876, 0x9481,0xE877, 0x947F,0xE878, 0x9582,0xE879, 0x9587,0xE87A, 0x958A,0xE87B, 0x9594,0xE87C, 0x9596,0xE87D, 0x9598,0xE87E, 0x9599,0xE880, 0x95A0,0xE881, 0x95A8,0xE882, 0x95A7,0xE883, 0x95AD,0xE884, 0x95BC,0xE885, 0x95BB,0xE886, 0x95B9,0xE887, 0x95BE,0xE888, 0x95CA,0xE889, 0x6FF6,0xE88A, 0x95C3,0xE88B, 0x95CD,0xE88C, 0x95CC,0xE88D, 0x95D5,0xE88E, 0x95D4,0xE88F, 0x95D6,0xE890, 0x95DC,0xE891, 0x95E1,0xE892, 0x95E5,0xE893, 0x95E2,0xE894, 0x9621,0xE895, 0x9628,0xE896, 0x962E,0xE897, 0x962F,0xE898, 0x9642,0xE899, 0x964C,0xE89A, 0x964F,0xE89B, 0x964B,0xE89C, 0x9677,0xE89D, 0x965C,0xE89E, 0x965E,0xE89F, 0x965D,0xE8A0, 0x965F,0xE8A1, 0x9666,0xE8A2, 0x9672,0xE8A3, 0x966C,0xE8A4, 0x968D,0xE8A5, 0x9698,0xE8A6, 0x9695,0xE8A7, 0x9697,0xE8A8, 0x96AA,0xE8A9, 0x96A7,0xE8AA, 0x96B1,0xE8AB, 0x96B2,0xE8AC, 0x96B0,0xE8AD, 0x96B4,0xE8AE, 0x96B6,0xE8AF, 0x96B8,0xE8B0, 0x96B9,0xE8B1, 0x96CE,0xE8B2, 0x96CB,0xE8B3, 0x96C9,0xE8B4, 0x96CD,0xE8B5, 0x894D,0xE8B6, 0x96DC,0xE8B7, 0x970D,0xE8B8, 0x96D5,0xE8B9, 0x96F9,0xE8BA, 0x9704,0xE8BB, 0x9706,0xE8BC, 0x9708,0xE8BD, 0x9713,0xE8BE, 0x970E,0xE8BF, 0x9711,0xE8C0, 0x970F,0xE8C1, 0x9716,0xE8C2, 0x9719,0xE8C3, 0x9724,0xE8C4, 0x972A,0xE8C5, 0x9730,0xE8C6, 0x9739,0xE8C7, 0x973D,0xE8C8, 0x973E,0xE8C9, 0x9744,0xE8CA, 0x9746,0xE8CB, 0x9748,0xE8CC, 0x9742,0xE8CD, 0x9749,0xE8CE, 0x975C,0xE8CF, 0x9760,0xE8D0, 0x9764,0xE8D1, 0x9766,0xE8D2, 0x9768,0xE8D3, 0x52D2,0xE8D4, 0x976B,0xE8D5, 0x9771,0xE8D6, 0x9779,0xE8D7, 0x9785,0xE8D8, 0x977C,0xE8D9, 0x9781,0xE8DA, 0x977A,0xE8DB, 0x9786,0xE8DC, 0x978B,0xE8DD, 0x978F,0xE8DE, 0x9790,0xE8DF, 0x979C,0xE8E0, 0x97A8,0xE8E1, 0x97A6,0xE8E2, 0x97A3,0xE8E3, 0x97B3,0xE8E4, 0x97B4,0xE8E5, 0x97C3,0xE8E6, 0x97C6,0xE8E7, 0x97C8,0xE8E8, 0x97CB,0xE8E9, 0x97DC,0xE8EA, 0x97ED,0xE8EB, 0x9F4F,0xE8EC, 0x97F2,0xE8ED, 0x7ADF,0xE8EE, 0x97F6,0xE8EF, 0x97F5,0xE8F0, 0x980F,0xE8F1, 0x980C,0xE8F2, 0x9838,0xE8F3, 0x9824,0xE8F4, 0x9821,0xE8F5, 0x9837,0xE8F6, 0x983D,0xE8F7, 0x9846,0xE8F8, 0x984F,0xE8F9, 0x984B,0xE8FA, 0x986B,0xE8FB, 0x986F,0xE8FC, 0x9870,0xE940, 0x9871,0xE941, 0x9874,0xE942, 0x9873,0xE943, 0x98AA,0xE944, 0x98AF,0xE945, 0x98B1,0xE946, 0x98B6,0xE947, 0x98C4,0xE948, 0x98C3,0xE949, 0x98C6,0xE94A, 0x98E9,0xE94B, 0x98EB,0xE94C, 0x9903,0xE94D, 0x9909,0xE94E, 0x9912,0xE94F, 0x9914,0xE950, 0x9918,0xE951, 0x9921,0xE952, 0x991D,0xE953, 0x991E,0xE954, 0x9924,0xE955, 0x9920,0xE956, 0x992C,0xE957, 0x992E,0xE958, 0x993D,0xE959, 0x993E,0xE95A, 0x9942,0xE95B, 0x9949,0xE95C, 0x9945,0xE95D, 0x9950,0xE95E, 0x994B,0xE95F, 0x9951,0xE960, 0x9952,0xE961, 0x994C,0xE962, 0x9955,0xE963, 0x9997,0xE964, 0x9998,0xE965, 0x99A5,0xE966, 0x99AD,0xE967, 0x99AE,0xE968, 0x99BC,0xE969, 0x99DF,0xE96A, 0x99DB,0xE96B, 0x99DD,0xE96C, 0x99D8,0xE96D, 0x99D1,0xE96E, 0x99ED,0xE96F, 0x99EE,0xE970, 0x99F1,0xE971, 0x99F2,0xE972, 0x99FB,0xE973, 0x99F8,0xE974, 0x9A01,0xE975, 0x9A0F,0xE976, 0x9A05,0xE977, 0x99E2,0xE978, 0x9A19,0xE979, 0x9A2B,0xE97A, 0x9A37,0xE97B, 0x9A45,0xE97C, 0x9A42,0xE97D, 0x9A40,0xE97E, 0x9A43,0xE980, 0x9A3E,0xE981, 0x9A55,0xE982, 0x9A4D,0xE983, 0x9A5B,0xE984, 0x9A57,0xE985, 0x9A5F,0xE986, 0x9A62,0xE987, 0x9A65,0xE988, 0x9A64,0xE989, 0x9A69,0xE98A, 0x9A6B,0xE98B, 0x9A6A,0xE98C, 0x9AAD,0xE98D, 0x9AB0,0xE98E, 0x9ABC,0xE98F, 0x9AC0,0xE990, 0x9ACF,0xE991, 0x9AD1,0xE992, 0x9AD3,0xE993, 0x9AD4,0xE994, 0x9ADE,0xE995, 0x9ADF,0xE996, 0x9AE2,0xE997, 0x9AE3,0xE998, 0x9AE6,0xE999, 0x9AEF,0xE99A, 0x9AEB,0xE99B, 0x9AEE,0xE99C, 0x9AF4,0xE99D, 0x9AF1,0xE99E, 0x9AF7,0xE99F, 0x9AFB,0xE9A0, 0x9B06,0xE9A1, 0x9B18,0xE9A2, 0x9B1A,0xE9A3, 0x9B1F,0xE9A4, 0x9B22,0xE9A5, 0x9B23,0xE9A6, 0x9B25,0xE9A7, 0x9B27,0xE9A8, 0x9B28,0xE9A9, 0x9B29,0xE9AA, 0x9B2A,0xE9AB, 0x9B2E,0xE9AC, 0x9B2F,0xE9AD, 0x9B32,0xE9AE, 0x9B44,0xE9AF, 0x9B43,0xE9B0, 0x9B4F,0xE9B1, 0x9B4D,0xE9B2, 0x9B4E,0xE9B3, 0x9B51,0xE9B4, 0x9B58,0xE9B5, 0x9B74,0xE9B6, 0x9B93,0xE9B7, 0x9B83,0xE9B8, 0x9B91,0xE9B9, 0x9B96,0xE9BA, 0x9B97,0xE9BB, 0x9B9F,0xE9BC, 0x9BA0,0xE9BD, 0x9BA8,0xE9BE, 0x9BB4,0xE9BF, 0x9BC0,0xE9C0, 0x9BCA,0xE9C1, 0x9BB9,0xE9C2, 0x9BC6,0xE9C3, 0x9BCF,0xE9C4, 0x9BD1,0xE9C5, 0x9BD2,0xE9C6, 0x9BE3,0xE9C7, 0x9BE2,0xE9C8, 0x9BE4,0xE9C9, 0x9BD4,0xE9CA, 0x9BE1,0xE9CB, 0x9C3A,0xE9CC, 0x9BF2,0xE9CD, 0x9BF1,0xE9CE, 0x9BF0,0xE9CF, 0x9C15,0xE9D0, 0x9C14,0xE9D1, 0x9C09,0xE9D2, 0x9C13,0xE9D3, 0x9C0C,0xE9D4, 0x9C06,0xE9D5, 0x9C08,0xE9D6, 0x9C12,0xE9D7, 0x9C0A,0xE9D8, 0x9C04,0xE9D9, 0x9C2E,0xE9DA, 0x9C1B,0xE9DB, 0x9C25,0xE9DC, 0x9C24,0xE9DD, 0x9C21,0xE9DE, 0x9C30,0xE9DF, 0x9C47,0xE9E0, 0x9C32,0xE9E1, 0x9C46,0xE9E2, 0x9C3E,0xE9E3, 0x9C5A,0xE9E4, 0x9C60,0xE9E5, 0x9C67,0xE9E6, 0x9C76,0xE9E7, 0x9C78,0xE9E8, 0x9CE7,0xE9E9, 0x9CEC,0xE9EA, 0x9CF0,0xE9EB, 0x9D09,0xE9EC, 0x9D08,0xE9ED, 0x9CEB,0xE9EE, 0x9D03,0xE9EF, 0x9D06,0xE9F0, 0x9D2A,0xE9F1, 0x9D26,0xE9F2, 0x9DAF,0xE9F3, 0x9D23,0xE9F4, 0x9D1F,0xE9F5, 0x9D44,0xE9F6, 0x9D15,0xE9F7, 0x9D12,0xE9F8, 0x9D41,0xE9F9, 0x9D3F,0xE9FA, 0x9D3E,0xE9FB, 0x9D46,0xE9FC, 0x9D48,0xEA40, 0x9D5D,0xEA41, 0x9D5E,0xEA42, 0x9D64,0xEA43, 0x9D51,0xEA44, 0x9D50,0xEA45, 0x9D59,0xEA46, 0x9D72,0xEA47, 0x9D89,0xEA48, 0x9D87,0xEA49, 0x9DAB,0xEA4A, 0x9D6F,0xEA4B, 0x9D7A,0xEA4C, 0x9D9A,0xEA4D, 0x9DA4,0xEA4E, 0x9DA9,0xEA4F, 0x9DB2,0xEA50, 0x9DC4,0xEA51, 0x9DC1,0xEA52, 0x9DBB,0xEA53, 0x9DB8,0xEA54, 0x9DBA,0xEA55, 0x9DC6,0xEA56, 0x9DCF,0xEA57, 0x9DC2,0xEA58, 0x9DD9,0xEA59, 0x9DD3,0xEA5A, 0x9DF8,0xEA5B, 0x9DE6,0xEA5C, 0x9DED,0xEA5D, 0x9DEF,0xEA5E, 0x9DFD,0xEA5F, 0x9E1A,0xEA60, 0x9E1B,0xEA61, 0x9E1E,0xEA62, 0x9E75,0xEA63, 0x9E79,0xEA64, 0x9E7D,0xEA65, 0x9E81,0xEA66, 0x9E88,0xEA67, 0x9E8B,0xEA68, 0x9E8C,0xEA69, 0x9E92,0xEA6A, 0x9E95,0xEA6B, 0x9E91,0xEA6C, 0x9E9D,0xEA6D, 0x9EA5,0xEA6E, 0x9EA9,0xEA6F, 0x9EB8,0xEA70, 0x9EAA,0xEA71, 0x9EAD,0xEA72, 0x9761,0xEA73, 0x9ECC,0xEA74, 0x9ECE,0xEA75, 0x9ECF,0xEA76, 0x9ED0,0xEA77, 0x9ED4,0xEA78, 0x9EDC,0xEA79, 0x9EDE,0xEA7A, 0x9EDD,0xEA7B, 0x9EE0,0xEA7C, 0x9EE5,0xEA7D, 0x9EE8,0xEA7E, 0x9EEF,0xEA80, 0x9EF4,0xEA81, 0x9EF6,0xEA82, 0x9EF7,0xEA83, 0x9EF9,0xEA84, 0x9EFB,0xEA85, 0x9EFC,0xEA86, 0x9EFD,0xEA87, 0x9F07,0xEA88, 0x9F08,0xEA89, 0x76B7,0xEA8A, 0x9F15,0xEA8B, 0x9F21,0xEA8C, 0x9F2C,0xEA8D, 0x9F3E,0xEA8E, 0x9F4A,0xEA8F, 0x9F52,0xEA90, 0x9F54,0xEA91, 0x9F63,0xEA92, 0x9F5F,0xEA93, 0x9F60,0xEA94, 0x9F61,0xEA95, 0x9F66,0xEA96, 0x9F67,0xEA97, 0x9F6C,0xEA98, 0x9F6A,0xEA99, 0x9F77,0xEA9A, 0x9F72,0xEA9B, 0x9F76,0xEA9C, 0x9F95,0xEA9D, 0x9F9C,0xEA9E, 0x9FA0,0xEA9F, 0x582F,0xEAA0, 0x69C7,0xEAA1, 0x9059,0xEAA2, 0x7464,0xEAA3, 0x51DC,0xEAA4, 0x7199,0xED40, 0x7E8A,0xED41, 0x891C,0xED42, 0x9348,0xED43, 0x9288,0xED44, 0x84DC,0xED45, 0x4FC9,0xED46, 0x70BB,0xED47, 0x6631,0xED48, 0x68C8,0xED49, 0x92F9,0xED4A, 0x66FB,0xED4B, 0x5F45,0xED4C, 0x4E28,0xED4D, 0x4EE1,0xED4E, 0x4EFC,0xED4F, 0x4F00,0xED50, 0x4F03,0xED51, 0x4F39,0xED52, 0x4F56,0xED53, 0x4F92,0xED54, 0x4F8A,0xED55, 0x4F9A,0xED56, 0x4F94,0xED57, 0x4FCD,0xED58, 0x5040,0xED59, 0x5022,0xED5A, 0x4FFF,0xED5B, 0x501E,0xED5C, 0x5046,0xED5D, 0x5070,0xED5E, 0x5042,0xED5F, 0x5094,0xED60, 0x50F4,0xED61, 0x50D8,0xED62, 0x514A,0xED63, 0x5164,0xED64, 0x519D,0xED65, 0x51BE,0xED66, 0x51EC,0xED67, 0x5215,0xED68, 0x529C,0xED69, 0x52A6,0xED6A, 0x52C0,0xED6B, 0x52DB,0xED6C, 0x5300,0xED6D, 0x5307,0xED6E, 0x5324,0xED6F, 0x5372,0xED70, 0x5393,0xED71, 0x53B2,0xED72, 0x53DD,0xED73, 0xFA0E,0xED74, 0x549C,0xED75, 0x548A,0xED76, 0x54A9,0xED77, 0x54FF,0xED78, 0x5586,0xED79, 0x5759,0xED7A, 0x5765,0xED7B, 0x57AC,0xED7C, 0x57C8,0xED7D, 0x57C7,0xED7E, 0xFA0F,0xED80, 0xFA10,0xED81, 0x589E,0xED82, 0x58B2,0xED83, 0x590B,0xED84, 0x5953,0xED85, 0x595B,0xED86, 0x595D,0xED87, 0x5963,0xED88, 0x59A4,0xED89, 0x59BA,0xED8A, 0x5B56,0xED8B, 0x5BC0,0xED8C, 0x752F,0xED8D, 0x5BD8,0xED8E, 0x5BEC,0xED8F, 0x5C1E,0xED90, 0x5CA6,0xED91, 0x5CBA,0xED92, 0x5CF5,0xED93, 0x5D27,0xED94, 0x5D53,0xED95, 0xFA11,0xED96, 0x5D42,0xED97, 0x5D6D,0xED98, 0x5DB8,0xED99, 0x5DB9,0xED9A, 0x5DD0,0xED9B, 0x5F21,0xED9C, 0x5F34,0xED9D, 0x5F67,0xED9E, 0x5FB7,0xED9F, 0x5FDE,0xEDA0, 0x605D,0xEDA1, 0x6085,0xEDA2, 0x608A,0xEDA3, 0x60DE,0xEDA4, 0x60D5,0xEDA5, 0x6120,0xEDA6, 0x60F2,0xEDA7, 0x6111,0xEDA8, 0x6137,0xEDA9, 0x6130,0xEDAA, 0x6198,0xEDAB, 0x6213,0xEDAC, 0x62A6,0xEDAD, 0x63F5,0xEDAE, 0x6460,0xEDAF, 0x649D,0xEDB0, 0x64CE,0xEDB1, 0x654E,0xEDB2, 0x6600,0xEDB3, 0x6615,0xEDB4, 0x663B,0xEDB5, 0x6609,0xEDB6, 0x662E,0xEDB7, 0x661E,0xEDB8, 0x6624,0xEDB9, 0x6665,0xEDBA, 0x6657,0xEDBB, 0x6659,0xEDBC, 0xFA12,0xEDBD, 0x6673,0xEDBE, 0x6699,0xEDBF, 0x66A0,0xEDC0, 0x66B2,0xEDC1, 0x66BF,0xEDC2, 0x66FA,0xEDC3, 0x670E,0xEDC4, 0xF929,0xEDC5, 0x6766,0xEDC6, 0x67BB,0xEDC7, 0x6852,0xEDC8, 0x67C0,0xEDC9, 0x6801,0xEDCA, 0x6844,0xEDCB, 0x68CF,0xEDCC, 0xFA13,0xEDCD, 0x6968,0xEDCE, 0xFA14,0xEDCF, 0x6998,0xEDD0, 0x69E2,0xEDD1, 0x6A30,0xEDD2, 0x6A6B,0xEDD3, 0x6A46,0xEDD4, 0x6A73,0xEDD5, 0x6A7E,0xEDD6, 0x6AE2,0xEDD7, 0x6AE4,0xEDD8, 0x6BD6,0xEDD9, 0x6C3F,0xEDDA, 0x6C5C,0xEDDB, 0x6C86,0xEDDC, 0x6C6F,0xEDDD, 0x6CDA,0xEDDE, 0x6D04,0xEDDF, 0x6D87,0xEDE0, 0x6D6F,0xEDE1, 0x6D96,0xEDE2, 0x6DAC,0xEDE3, 0x6DCF,0xEDE4, 0x6DF8,0xEDE5, 0x6DF2,0xEDE6, 0x6DFC,0xEDE7, 0x6E39,0xEDE8, 0x6E5C,0xEDE9, 0x6E27,0xEDEA, 0x6E3C,0xEDEB, 0x6EBF,0xEDEC, 0x6F88,0xEDED, 0x6FB5,0xEDEE, 0x6FF5,0xEDEF, 0x7005,0xEDF0, 0x7007,0xEDF1, 0x7028,0xEDF2, 0x7085,0xEDF3, 0x70AB,0xEDF4, 0x710F,0xEDF5, 0x7104,0xEDF6, 0x715C,0xEDF7, 0x7146,0xEDF8, 0x7147,0xEDF9, 0xFA15,0xEDFA, 0x71C1,0xEDFB, 0x71FE,0xEDFC, 0x72B1,0xEE40, 0x72BE,0xEE41, 0x7324,0xEE42, 0xFA16,0xEE43, 0x7377,0xEE44, 0x73BD,0xEE45, 0x73C9,0xEE46, 0x73D6,0xEE47, 0x73E3,0xEE48, 0x73D2,0xEE49, 0x7407,0xEE4A, 0x73F5,0xEE4B, 0x7426,0xEE4C, 0x742A,0xEE4D, 0x7429,0xEE4E, 0x742E,0xEE4F, 0x7462,0xEE50, 0x7489,0xEE51, 0x749F,0xEE52, 0x7501,0xEE53, 0x756F,0xEE54, 0x7682,0xEE55, 0x769C,0xEE56, 0x769E,0xEE57, 0x769B,0xEE58, 0x76A6,0xEE59, 0xFA17,0xEE5A, 0x7746,0xEE5B, 0x52AF,0xEE5C, 0x7821,0xEE5D, 0x784E,0xEE5E, 0x7864,0xEE5F, 0x787A,0xEE60, 0x7930,0xEE61, 0xFA18,0xEE62, 0xFA19,0xEE63, 0xFA1A,0xEE64, 0x7994,0xEE65, 0xFA1B,0xEE66, 0x799B,0xEE67, 0x7AD1,0xEE68, 0x7AE7,0xEE69, 0xFA1C,0xEE6A, 0x7AEB,0xEE6B, 0x7B9E,0xEE6C, 0xFA1D,0xEE6D, 0x7D48,0xEE6E, 0x7D5C,0xEE6F, 0x7DB7,0xEE70, 0x7DA0,0xEE71, 0x7DD6,0xEE72, 0x7E52,0xEE73, 0x7F47,0xEE74, 0x7FA1,0xEE75, 0xFA1E,0xEE76, 0x8301,0xEE77, 0x8362,0xEE78, 0x837F,0xEE79, 0x83C7,0xEE7A, 0x83F6,0xEE7B, 0x8448,0xEE7C, 0x84B4,0xEE7D, 0x8553,0xEE7E, 0x8559,0xEE80, 0x856B,0xEE81, 0xFA1F,0xEE82, 0x85B0,0xEE83, 0xFA20,0xEE84, 0xFA21,0xEE85, 0x8807,0xEE86, 0x88F5,0xEE87, 0x8A12,0xEE88, 0x8A37,0xEE89, 0x8A79,0xEE8A, 0x8AA7,0xEE8B, 0x8ABE,0xEE8C, 0x8ADF,0xEE8D, 0xFA22,0xEE8E, 0x8AF6,0xEE8F, 0x8B53,0xEE90, 0x8B7F,0xEE91, 0x8CF0,0xEE92, 0x8CF4,0xEE93, 0x8D12,0xEE94, 0x8D76,0xEE95, 0xFA23,0xEE96, 0x8ECF,0xEE97, 0xFA24,0xEE98, 0xFA25,0xEE99, 0x9067,0xEE9A, 0x90DE,0xEE9B, 0xFA26,0xEE9C, 0x9115,0xEE9D, 0x9127,0xEE9E, 0x91DA,0xEE9F, 0x91D7,0xEEA0, 0x91DE,0xEEA1, 0x91ED,0xEEA2, 0x91EE,0xEEA3, 0x91E4,0xEEA4, 0x91E5,0xEEA5, 0x9206,0xEEA6, 0x9210,0xEEA7, 0x920A,0xEEA8, 0x923A,0xEEA9, 0x9240,0xEEAA, 0x923C,0xEEAB, 0x924E,0xEEAC, 0x9259,0xEEAD, 0x9251,0xEEAE, 0x9239,0xEEAF, 0x9267,0xEEB0, 0x92A7,0xEEB1, 0x9277,0xEEB2, 0x9278,0xEEB3, 0x92E7,0xEEB4, 0x92D7,0xEEB5, 0x92D9,0xEEB6, 0x92D0,0xEEB7, 0xFA27,0xEEB8, 0x92D5,0xEEB9, 0x92E0,0xEEBA, 0x92D3,0xEEBB, 0x9325,0xEEBC, 0x9321,0xEEBD, 0x92FB,0xEEBE, 0xFA28,0xEEBF, 0x931E,0xEEC0, 0x92FF,0xEEC1, 0x931D,0xEEC2, 0x9302,0xEEC3, 0x9370,0xEEC4, 0x9357,0xEEC5, 0x93A4,0xEEC6, 0x93C6,0xEEC7, 0x93DE,0xEEC8, 0x93F8,0xEEC9, 0x9431,0xEECA, 0x9445,0xEECB, 0x9448,0xEECC, 0x9592,0xEECD, 0xF9DC,0xEECE, 0xFA29,0xEECF, 0x969D,0xEED0, 0x96AF,0xEED1, 0x9733,0xEED2, 0x973B,0xEED3, 0x9743,0xEED4, 0x974D,0xEED5, 0x974F,0xEED6, 0x9751,0xEED7, 0x9755,0xEED8, 0x9857,0xEED9, 0x9865,0xEEDA, 0xFA2A,0xEEDB, 0xFA2B,0xEEDC, 0x9927,0xEEDD, 0xFA2C,0xEEDE, 0x999E,0xEEDF, 0x9A4E,0xEEE0, 0x9AD9,0xEEE1, 0x9ADC,0xEEE2, 0x9B75,0xEEE3, 0x9B72,0xEEE4, 0x9B8F,0xEEE5, 0x9BB1,0xEEE6, 0x9BBB,0xEEE7, 0x9C00,0xEEE8, 0x9D70,0xEEE9, 0x9D6B,0xEEEA, 0xFA2D,0xEEEB, 0x9E19,0xEEEC, 0x9ED1,0xEEEF, 0x2170,0xEEF0, 0x2171,0xEEF1, 0x2172,0xEEF2, 0x2173,0xEEF3, 0x2174,0xEEF4, 0x2175,0xEEF5, 0x2176,0xEEF6, 0x2177,0xEEF7, 0x2178,0xEEF8, 0x2179,0xEEF9, 0xFFE2,0xEEFA, 0xFFE4,0xEEFB, 0xFF07,0xEEFC, 0xFF02,0xFA40, 0x2170,0xFA41, 0x2171,0xFA42, 0x2172,0xFA43, 0x2173,0xFA44, 0x2174,0xFA45, 0x2175,0xFA46, 0x2176,0xFA47, 0x2177,0xFA48, 0x2178,0xFA49, 0x2179,0xFA4A, 0x2160,0xFA4B, 0x2161,0xFA4C, 0x2162,0xFA4D, 0x2163,0xFA4E, 0x2164,0xFA4F, 0x2165,0xFA50, 0x2166,0xFA51, 0x2167,0xFA52, 0x2168,0xFA53, 0x2169,0xFA54, 0xFFE2,0xFA55, 0xFFE4,0xFA56, 0xFF07,0xFA57, 0xFF02,0xFA58, 0x3231,0xFA59, 0x2116,0xFA5A, 0x2121,0xFA5B, 0x2235,0xFA5C, 0x7E8A,0xFA5D, 0x891C,0xFA5E, 0x9348,0xFA5F, 0x9288,0xFA60, 0x84DC,0xFA61, 0x4FC9,0xFA62, 0x70BB,0xFA63, 0x6631,0xFA64, 0x68C8,0xFA65, 0x92F9,0xFA66, 0x66FB,0xFA67, 0x5F45,0xFA68, 0x4E28,0xFA69, 0x4EE1,0xFA6A, 0x4EFC,0xFA6B, 0x4F00,0xFA6C, 0x4F03,0xFA6D, 0x4F39,0xFA6E, 0x4F56,0xFA6F, 0x4F92,0xFA70, 0x4F8A,0xFA71, 0x4F9A,0xFA72, 0x4F94,0xFA73, 0x4FCD,0xFA74, 0x5040,0xFA75, 0x5022,0xFA76, 0x4FFF,0xFA77, 0x501E,0xFA78, 0x5046,0xFA79, 0x5070,0xFA7A, 0x5042,0xFA7B, 0x5094,0xFA7C, 0x50F4,0xFA7D, 0x50D8,0xFA7E, 0x514A,0xFA80, 0x5164,0xFA81, 0x519D,0xFA82, 0x51BE,0xFA83, 0x51EC,0xFA84, 0x5215,0xFA85, 0x529C,0xFA86, 0x52A6,0xFA87, 0x52C0,0xFA88, 0x52DB,0xFA89, 0x5300,0xFA8A, 0x5307,0xFA8B, 0x5324,0xFA8C, 0x5372,0xFA8D, 0x5393,0xFA8E, 0x53B2,0xFA8F, 0x53DD,0xFA90, 0xFA0E,0xFA91, 0x549C,0xFA92, 0x548A,0xFA93, 0x54A9,0xFA94, 0x54FF,0xFA95, 0x5586,0xFA96, 0x5759,0xFA97, 0x5765,0xFA98, 0x57AC,0xFA99, 0x57C8,0xFA9A, 0x57C7,0xFA9B, 0xFA0F,0xFA9C, 0xFA10,0xFA9D, 0x589E,0xFA9E, 0x58B2,0xFA9F, 0x590B,0xFAA0, 0x5953,0xFAA1, 0x595B,0xFAA2, 0x595D,0xFAA3, 0x5963,0xFAA4, 0x59A4,0xFAA5, 0x59BA,0xFAA6, 0x5B56,0xFAA7, 0x5BC0,0xFAA8, 0x752F,0xFAA9, 0x5BD8,0xFAAA, 0x5BEC,0xFAAB, 0x5C1E,0xFAAC, 0x5CA6,0xFAAD, 0x5CBA,0xFAAE, 0x5CF5,0xFAAF, 0x5D27,0xFAB0, 0x5D53,0xFAB1, 0xFA11,0xFAB2, 0x5D42,0xFAB3, 0x5D6D,0xFAB4, 0x5DB8,0xFAB5, 0x5DB9,0xFAB6, 0x5DD0,0xFAB7, 0x5F21,0xFAB8, 0x5F34,0xFAB9, 0x5F67,0xFABA, 0x5FB7,0xFABB, 0x5FDE,0xFABC, 0x605D,0xFABD, 0x6085,0xFABE, 0x608A,0xFABF, 0x60DE,0xFAC0, 0x60D5,0xFAC1, 0x6120,0xFAC2, 0x60F2,0xFAC3, 0x6111,0xFAC4, 0x6137,0xFAC5, 0x6130,0xFAC6, 0x6198,0xFAC7, 0x6213,0xFAC8, 0x62A6,0xFAC9, 0x63F5,0xFACA, 0x6460,0xFACB, 0x649D,0xFACC, 0x64CE,0xFACD, 0x654E,0xFACE, 0x6600,0xFACF, 0x6615,0xFAD0, 0x663B,0xFAD1, 0x6609,0xFAD2, 0x662E,0xFAD3, 0x661E,0xFAD4, 0x6624,0xFAD5, 0x6665,0xFAD6, 0x6657,0xFAD7, 0x6659,0xFAD8, 0xFA12,0xFAD9, 0x6673,0xFADA, 0x6699,0xFADB, 0x66A0,0xFADC, 0x66B2,0xFADD, 0x66BF,0xFADE, 0x66FA,0xFADF, 0x670E,0xFAE0, 0xF929,0xFAE1, 0x6766,0xFAE2, 0x67BB,0xFAE3, 0x6852,0xFAE4, 0x67C0,0xFAE5, 0x6801,0xFAE6, 0x6844,0xFAE7, 0x68CF,0xFAE8, 0xFA13,0xFAE9, 0x6968,0xFAEA, 0xFA14,0xFAEB, 0x6998,0xFAEC, 0x69E2,0xFAED, 0x6A30,0xFAEE, 0x6A6B,0xFAEF, 0x6A46,0xFAF0, 0x6A73,0xFAF1, 0x6A7E,0xFAF2, 0x6AE2,0xFAF3, 0x6AE4,0xFAF4, 0x6BD6,0xFAF5, 0x6C3F,0xFAF6, 0x6C5C,0xFAF7, 0x6C86,0xFAF8, 0x6C6F,0xFAF9, 0x6CDA,0xFAFA, 0x6D04,0xFAFB, 0x6D87,0xFAFC, 0x6D6F,0xFB40, 0x6D96,0xFB41, 0x6DAC,0xFB42, 0x6DCF,0xFB43, 0x6DF8,0xFB44, 0x6DF2,0xFB45, 0x6DFC,0xFB46, 0x6E39,0xFB47, 0x6E5C,0xFB48, 0x6E27,0xFB49, 0x6E3C,0xFB4A, 0x6EBF,0xFB4B, 0x6F88,0xFB4C, 0x6FB5,0xFB4D, 0x6FF5,0xFB4E, 0x7005,0xFB4F, 0x7007,0xFB50, 0x7028,0xFB51, 0x7085,0xFB52, 0x70AB,0xFB53, 0x710F,0xFB54, 0x7104,0xFB55, 0x715C,0xFB56, 0x7146,0xFB57, 0x7147,0xFB58, 0xFA15,0xFB59, 0x71C1,0xFB5A, 0x71FE,0xFB5B, 0x72B1,0xFB5C, 0x72BE,0xFB5D, 0x7324,0xFB5E, 0xFA16,0xFB5F, 0x7377,0xFB60, 0x73BD,0xFB61, 0x73C9,0xFB62, 0x73D6,0xFB63, 0x73E3,0xFB64, 0x73D2,0xFB65, 0x7407,0xFB66, 0x73F5,0xFB67, 0x7426,0xFB68, 0x742A,0xFB69, 0x7429,0xFB6A, 0x742E,0xFB6B, 0x7462,0xFB6C, 0x7489,0xFB6D, 0x749F,0xFB6E, 0x7501,0xFB6F, 0x756F,0xFB70, 0x7682,0xFB71, 0x769C,0xFB72, 0x769E,0xFB73, 0x769B,0xFB74, 0x76A6,0xFB75, 0xFA17,0xFB76, 0x7746,0xFB77, 0x52AF,0xFB78, 0x7821,0xFB79, 0x784E,0xFB7A, 0x7864,0xFB7B, 0x787A,0xFB7C, 0x7930,0xFB7D, 0xFA18,0xFB7E, 0xFA19,0xFB80, 0xFA1A,0xFB81, 0x7994,0xFB82, 0xFA1B,0xFB83, 0x799B,0xFB84, 0x7AD1,0xFB85, 0x7AE7,0xFB86, 0xFA1C,0xFB87, 0x7AEB,0xFB88, 0x7B9E,0xFB89, 0xFA1D,0xFB8A, 0x7D48,0xFB8B, 0x7D5C,0xFB8C, 0x7DB7,0xFB8D, 0x7DA0,0xFB8E, 0x7DD6,0xFB8F, 0x7E52,0xFB90, 0x7F47,0xFB91, 0x7FA1,0xFB92, 0xFA1E,0xFB93, 0x8301,0xFB94, 0x8362,0xFB95, 0x837F,0xFB96, 0x83C7,0xFB97, 0x83F6,0xFB98, 0x8448,0xFB99, 0x84B4,0xFB9A, 0x8553,0xFB9B, 0x8559,0xFB9C, 0x856B,0xFB9D, 0xFA1F,0xFB9E, 0x85B0,0xFB9F, 0xFA20,0xFBA0, 0xFA21,0xFBA1, 0x8807,0xFBA2, 0x88F5,0xFBA3, 0x8A12,0xFBA4, 0x8A37,0xFBA5, 0x8A79,0xFBA6, 0x8AA7,0xFBA7, 0x8ABE,0xFBA8, 0x8ADF,0xFBA9, 0xFA22,0xFBAA, 0x8AF6,0xFBAB, 0x8B53,0xFBAC, 0x8B7F,0xFBAD, 0x8CF0,0xFBAE, 0x8CF4,0xFBAF, 0x8D12,0xFBB0, 0x8D76,0xFBB1, 0xFA23,0xFBB2, 0x8ECF,0xFBB3, 0xFA24,0xFBB4, 0xFA25,0xFBB5, 0x9067,0xFBB6, 0x90DE,0xFBB7, 0xFA26,0xFBB8, 0x9115,0xFBB9, 0x9127,0xFBBA, 0x91DA,0xFBBB, 0x91D7,0xFBBC, 0x91DE,0xFBBD, 0x91ED,0xFBBE, 0x91EE,0xFBBF, 0x91E4,0xFBC0, 0x91E5,0xFBC1, 0x9206,0xFBC2, 0x9210,0xFBC3, 0x920A,0xFBC4, 0x923A,0xFBC5, 0x9240,0xFBC6, 0x923C,0xFBC7, 0x924E,0xFBC8, 0x9259,0xFBC9, 0x9251,0xFBCA, 0x9239,0xFBCB, 0x9267,0xFBCC, 0x92A7,0xFBCD, 0x9277,0xFBCE, 0x9278,0xFBCF, 0x92E7,0xFBD0, 0x92D7,0xFBD1, 0x92D9,0xFBD2, 0x92D0,0xFBD3, 0xFA27,0xFBD4, 0x92D5,0xFBD5, 0x92E0,0xFBD6, 0x92D3,0xFBD7, 0x9325,0xFBD8, 0x9321,0xFBD9, 0x92FB,0xFBDA, 0xFA28,0xFBDB, 0x931E,0xFBDC, 0x92FF,0xFBDD, 0x931D,0xFBDE, 0x9302,0xFBDF, 0x9370,0xFBE0, 0x9357,0xFBE1, 0x93A4,0xFBE2, 0x93C6,0xFBE3, 0x93DE,0xFBE4, 0x93F8,0xFBE5, 0x9431,0xFBE6, 0x9445,0xFBE7, 0x9448,0xFBE8, 0x9592,0xFBE9, 0xF9DC,0xFBEA, 0xFA29,0xFBEB, 0x969D,0xFBEC, 0x96AF,0xFBED, 0x9733,0xFBEE, 0x973B,0xFBEF, 0x9743,0xFBF0, 0x974D,0xFBF1, 0x974F,0xFBF2, 0x9751,0xFBF3, 0x9755,0xFBF4, 0x9857,0xFBF5, 0x9865,0xFBF6, 0xFA2A,0xFBF7, 0xFA2B,0xFBF8, 0x9927,0xFBF9, 0xFA2C,0xFBFA, 0x999E,0xFBFB, 0x9A4E,0xFBFC, 0x9AD9,0xFC40, 0x9ADC,0xFC41, 0x9B75,0xFC42, 0x9B72,0xFC43, 0x9B8F,0xFC44, 0x9BB1,0xFC45, 0x9BBB,0xFC46, 0x9C00,0xFC47, 0x9D70,0xFC48, 0x9D6B,0xFC49, 0xFA2D,0xFC4A, 0x9E19,0xFC4B, 0x9ED1,]\nvar decoding_table = [],\n    encoding_table = []\nfor(var i = 0, len = _table.length; i < len; i += 2){\nvar value = _table[i + 1]\nif(value !== null){\n    encoding_table[value] = _table[i]\n}\ndecoding_table[_table[i]] = _table[i + 1]\n}\n$module = {encoding_table, decoding_table}\n"], "hashlib": [".js", "var $module=(function($B){\n\nvar _b_ = $B.builtins\n\nvar $mod = {\n\n    __getattr__ : function(attr){\n        if(attr == 'new'){return hash.$factory}\n        return this[attr]\n    },\n    md5: function(obj){return hash.$factory('md5', obj)},\n    sha1: function(obj){return hash.$factory('sha1', obj)},\n    sha224: function(obj){return hash.$factory('sha224', obj)},\n    sha256: function(obj){return hash.$factory('sha256', obj)},\n    sha384: function(obj){return hash.$factory('sha384', obj)},\n    sha512: function(obj){return hash.$factory('sha512', obj)},\n\n    algorithms_guaranteed: ['md5', 'sha1', 'sha224', 'sha256', 'sha384', 'sha512'],\n    algorithms_available:  ['md5', 'sha1', 'sha224', 'sha256', 'sha384', 'sha512']\n}\n\n//todo: eventually move this function to a \"utility\" file or use ajax module?\nfunction $get_CryptoJS_lib(alg){\n    if($B.VFS !== undefined && $B.VFS.hashlib){\n        // use file in brython_stdlib.js\n        var lib = $B.VFS[\"crypto_js.rollups.\" + alg]\n        if (lib === undefined){\n            throw _b_.ImportError.$factory(\"can't import hashlib.\" + alg)\n        }\n        var res = lib[1]\n        try{\n            eval(res + \"; $B.CryptoJS = CryptoJS;\")\n            return\n        }catch(err){\n            throw Error(\"JS Eval Error\",\n                \"Cannot eval CryptoJS algorithm '\" + alg + \"' : error:\" + err)\n        }\n    }\n\n    var module = {__name__: 'CryptoJS', $is_package: false}\n    var res = $B.$download_module(module, $B.brython_path + 'libs/crypto_js/rollups/' + alg + '.js');\n\n    try{\n        eval(res + \"; $B.CryptoJS = CryptoJS;\")\n    }catch(err){\n        throw Error(\"JS Eval Error\",\n            \"Cannot eval CryptoJS algorithm '\" + alg + \"' : error:\" + err)\n    }\n}\n\nfunction bytes2WordArray(obj){\n    // Transform a bytes object into an instance of class WordArray\n    // defined in CryptoJS\n    if(!_b_.isinstance(obj, _b_.bytes)){\n        throw _b_.TypeError(\"expected bytes, got \" + $B.class_name(obj))\n    }\n\n    var words = []\n    for(var i = 0; i < obj.source.length; i += 4){\n        var word = obj.source.slice(i, i + 4)\n        while(word.length < 4){word.push(0)}\n        var w = word[3] + (word[2] << 8) + (word[1] << 16) + (word[0] << 24)\n        words.push(w)\n    }\n    return {words: words, sigBytes: obj.source.length}\n}\n\nvar hash = {\n    __class__: _b_.type,\n    __mro__: [_b_.object],\n    $infos:{\n        __name__: 'hash'\n    }\n}\n\nhash.update = function(self, msg){\n    self.hash.update(bytes2WordArray(msg))\n}\n\nhash.copy = function(self){\n    return self.hash.clone()\n}\n\nhash.digest = function(self){\n    var obj = self.hash.clone().finalize().toString(),\n        res = []\n    for(var i = 0; i < obj.length; i += 2){\n        res.push(parseInt(obj.substr(i, 2), 16))\n    }\n    return _b_.bytes.$factory(res)\n}\n\nhash.hexdigest = function(self) {\n    return self.hash.clone().finalize().toString()\n}\n\nhash.$factory = function(alg, obj) {\n    var res = {\n        __class__: hash\n    }\n\n    switch(alg) {\n      case 'md5':\n      case 'sha1':\n      case 'sha224':\n      case 'sha256':\n      case 'sha384':\n      case 'sha512':\n        var ALG = alg.toUpperCase()\n        if($B.Crypto === undefined ||\n            $B.CryptoJS.algo[ALG] === undefined){$get_CryptoJS_lib(alg)}\n\n        res.hash = $B.CryptoJS.algo[ALG].create()\n        if(obj !== undefined){\n            res.hash.update(bytes2WordArray(obj))\n        }\n        break\n      default:\n        throw $B.builtins.AttributeError.$factory('Invalid hash algorithm: ' + alg)\n    }\n\n    return res\n}\n\nreturn $mod\n\n})(__BRYTHON__)\n"], "html_parser": [".js", "var $module = (function($B){\n\n_b_ = $B.builtins\n\nvar ELEMENT_NODE = 1,\n    TEXT_NODE = 3,\n    COMMENT_NODE =\t8,\n    DOCUMENT_TYPE_NODE =\t10\n\nvar HTMLNode = $B.make_class(\"HTMLNode\",\n    function(){\n        return {\n            __class__: HTMLNode,\n            nodeType: TEXT_NODE,\n            text: \"\"\n        }\n    }\n)\n\nHTMLNode.__str__ = function(self){\n    return self.text\n}\n\n$B.set_func_names(HTMLNode, \"_html_parser\")\n\nfunction* tokenize(src){\n    var node = HTMLNode.$factory(),\n        pos = 0,\n        tag = \"\",\n        type = \"text\"\n    while(pos < src.length){\n        var char = src[pos]\n        switch(type){\n            case \"text\":\n                if(char == \"<\"){\n                    // starts a tag if immediately followed by a letter or by /\n                    var tag_mo = /^(\\/?)[a-zA-Z]+/.exec(src.substr(pos + 1))\n                    if(tag_mo){\n                        yield node\n                        node = HTMLNode.$factory()\n                        type = \"tag\"\n                        node.tagName = \"\"\n                        node.nodeType = ELEMENT_NODE\n                        node.closing = tag_mo[1] != \"\"\n                        node.attrs = []\n                    }else{\n                        // doctype declaration\n                        var decl_mo = /^<!doctype\\s+(.*?)>/i.exec(src.substr(pos))\n                        if(decl_mo){\n                            yield node\n                            node = HTMLNode.$factory()\n                            node.text = decl_mo[0]\n                            node.doctype = decl_mo[1]\n                            node.nodeType = DOCUMENT_TYPE_NODE\n                            yield node\n                            node = HTMLNode.$factory()\n                            type = \"text\"\n                            pos += decl_mo[0].length\n                            break\n                        }else{\n                            // comment\n                            var comment_mo = /^\\<!(.*?)>/.exec(src.substr(pos))\n                            if(comment_mo){\n                                yield node\n                                node = HTMLNode.$factory()\n                                node.text = comment_mo[0]\n                                node.comment = comment_mo[1]\n                                node.nodeType = COMMENT_NODE\n                                yield node\n                                node = HTMLNode.$factory()\n                                type = \"text\"\n                                pos += comment_mo[0].length\n                                break\n                            }\n                        }\n                    }\n                }\n                pos++\n                node.text += char\n                break\n            case \"tag\":\n                if(char.search(/[_a-zA-Z]/) > -1){\n                    var mo = /\\w+/.exec(src.substr(pos))\n                    if(mo !== null){\n                        pos += mo[0].length\n                        if(node.tagName == \"\"){\n                            node.tagName = mo[0].toUpperCase()\n                        }\n                        node.text += mo[0]\n                    }else{\n                        pos++\n                    }\n                }else if(char == \">\"){\n                    node.text += char\n                    yield node\n                    node = HTMLNode.$factory()\n                    type = \"text\"\n                    pos++\n                }else if(char == \"=\"){\n                    node.text += char\n                    pos++\n                }else if(char == \"'\" || char == '\"'){\n                    var i = pos + 1\n                    while(i < src.length){\n                        if(src[i] == char){\n                            var nb_escape = 0\n                            while(src[i - 1 - nb_escape] == '/'){\n                                nb_escape++\n                            }\n                            if(nb_escape % 2 == 0){\n                                node.text += src.substr(pos, i + 1 - pos)\n                                pos = i + 1\n                                break\n                            }else{\n                                i++\n                            }\n                        }else{\n                            i++\n                        }\n                    }\n                }else{\n                    node.text += char\n                    pos++\n                }\n                break\n            default:\n                pos++\n        }\n    }\n    yield node\n}\nreturn  {\n    ELEMENT_NODE: 1,\n    TEXT_NODE: 3,\n    COMMENT_NODE:\t8,\n    DOCUMENT_TYPE_NODE:\t10,\n    tokenize: tokenize\n}\n\n})(__BRYTHON__)\n"], "long_int": [".js", "/*\nModule to manipulate long integers\n*/\n\nvar $module=(function($B){\n\neval($B.InjectBuiltins())\n\nvar $LongIntDict = {__class__:$B.$type,__name__:'LongInt'}\n\nfunction add_pos(v1, v2){\n    // Add two positive numbers\n    // v1, v2 : strings\n    // Return an instance of LongInt\n\n    var res = '', carry = 0, iself=v1.length, sv=0\n    for(var i=v2.length-1;i>=0;i--){\n        iself--\n        if(iself<0){sv=0}else{sv=parseInt(v1.charAt(iself))}\n        x = (carry+sv+parseInt(v2.charAt(i))).toString()\n        if(x.length==2){res=x.charAt(1)+res;carry=parseInt(x.charAt(0))}\n        else{res=x+res;carry=0}\n    }\n    while(iself>0){\n        iself--\n        x = (carry+parseInt(v1.charAt(iself))).toString()\n        if(x.length==2){res=x.charAt(1)+res;carry=parseInt(x.charAt(0))}\n        else{res=x+res;carry=0}\n    }\n    if(carry){res=carry+res}        \n    return {__class__:$LongIntDict, value:res, pos:true}\n}\n\nfunction check_shift(shift){\n    // Check the argument of >> and <<\n    if(!isinstance(shift, LongInt)){\n        throw TypeError(\"shift must be LongInt, not '\"+\n            $B.get_class(shift).__name__+\"'\")\n    }\n    if(!shift.pos){throw ValueError(\"negative shift count\")}\n}\n\nfunction clone(obj){\n    // Used for traces\n    var obj1 = {}\n    for(var attr in obj){obj1[attr]=obj[attr]}\n    return obj1\n}\n\nfunction comp_pos(v1, v2){\n    // Compare two positive numbers\n    if(v1.length>v2.length){return 1}\n    else if(v1.length<v2.length){return -1}\n    else{\n        if(v1>v2){return 1}\n        else if(v1<v2){return -1}\n    }\n    return 0\n}\n\nfunction divmod_pos(v1, v2){\n    // v1, v2 : strings, represent 2 positive integers A and B\n    // Return [a, b] where a and b are instances of LongInt\n    // a = A // B, b = A % B\n    var v1_init = v1, quotient, mod\n    if(comp_pos(v1, v2)==-1){ // a < b\n        quotient='0'\n        mod = LongInt(v1)\n    }else if(v2==v1){ // a = b\n        quotient = '1';\n        mod = LongInt('0')\n    }else{\n        var quotient = '', v1_init = v1\n        var left = v1.substr(0, v2.length)\n        if(v1<v2){left = v1.substr(0, v2.length+1)}\n        var right = v1.substr(left.length)\n        // mv2 maps integers i from 2 to 9 to i*v2, used as a cache to avoid\n        // having to compute i*v2 each time\n        var mv2 = {}\n        // Javascript \"safe integer\" with the 15 first digits in v2,\n        // used in the algorithm to test candidate values\n        var jsv2 = parseInt(v2.substr(0,15))\n\n        // Division algorithm\n        // At each step in the division, v1 is split into substrings\n        // \"left\" is the left part, with the same length as v2\n        // \"rest\" is the rest of v1 after \"left\"\n        // The algorithm finds the one-digit integer \"candidate\" such\n        // that 0 <= left - candidate*v2 < v2\n        // It stops when right is empty\n        while(true){\n            // Uses JS division to test an approximate result\n            var jsleft = parseInt(left.substr(0,15))\n            var candidate = Math.floor(jsleft/jsv2).toString()\n\n            // Check that candidate is the correct result\n            // Start by computing candidate*v2 : for this, use the table\n            // mv2, which stores the multiples of v2 already calculated\n            if(mv2[candidate]===undefined){\n                mv2[candidate] = mul_pos(v2, candidate).value\n            }\n            if(comp_pos(left, mv2[candidate])==-1){\n                // If left < candidate * v2, use candidate-1\n                candidate--\n                if(mv2[candidate]===undefined){\n                    mv2[candidate] = mul_pos(v2, candidate).value\n                }\n            }\n\n            // Add candidate to the quotient\n            quotient += candidate\n\n            // New value for left : left - v2*candidate\n            left = sub_pos(left, mv2[candidate]).value\n\n            // Stop if all digits in v1 have been used\n            if(right.length==0){break}\n\n            // Else, add next digit to left and remove it from right\n            left += right.charAt(0)\n            right = right.substr(1)\n        }\n        // Modulo is A - (A//B)*B\n        mod = sub_pos(v1, mul_pos(quotient, v2).value)\n    }\n    return [LongInt(quotient), mod]\n}\n\nfunction mul_pos(v1, v2){\n    // Multiply positive numbers v1 by v2\n    // Make v2 smaller than v1\n    if(v1.length<v2.length){var a=v1; v1=v2 ; v2=a}\n    if(v2=='0'){return LongInt('0')}\n    var cols = {}, i=v2.length, j\n    \n    // Built the object \"cols\", indexed by integers from 1 to nb1+nb2-2\n    // where nb1 and nb2 are the number of digits in v1 and v2.\n    // cols[n] is the sum of v1[i]*v2[j] for i+j = n\n    \n    while(i--){\n        var car = v2.charAt(i)\n        if(car==\"0\"){\n            j = v1.length\n            while(j--){\n                if(cols[i+j]===undefined){cols[i+j]=0}\n            }        \n        }else if(car==\"1\"){\n            j = v1.length\n            while(j--){\n                var z = parseInt(v1.charAt(j))\n                if(cols[i+j]===undefined){cols[i+j]=z}\n                else{cols[i+j] += z}\n            }\n        }else{\n            var x = parseInt(car), j = v1.length, y, z\n            while(j--){\n                y = x * parseInt(v1.charAt(j))\n                if(cols[i+j]===undefined){cols[i+j]=y}\n                else{cols[i+j] += y}\n            }\n        }\n    }\n\n    // Transform cols so that cols[x] is a one-digit integers\n    i = v1.length+v2.length-1\n    while(i--){\n        var col = cols[i].toString()\n        if(col.length>1){\n            // If the value in cols[i] has more than one digit, only keep the\n            // last one and report the others at the right index\n            // For instance if cols[i] = 123, keep 3 in cols[i], add 2 to\n            // cols[i-1] and 1 to cols[i-2]\n            cols[i] = parseInt(col.charAt(col.length-1))\n            j = col.length\n            while(j-->1){\n                var report = parseInt(col.charAt(j-1))\n                var pos = i-col.length+j\n                if(cols[pos]===undefined){cols[pos]=report}\n                else{cols[pos] += report}\n            }\n        }\n    }\n\n    // Find minimum index in cols\n    // The previous loop may have introduced negative indices\n    var imin\n    for(var attr in cols){\n        i = parseInt(attr)\n        if(imin===undefined){imin=i}\n        else if(i<imin){imin=i}\n    }\n\n    // Result is the concatenation of digits in cols\n    var res = ''\n    for(var i=imin;i<=v1.length+v2.length-2;i++){res+=cols[i].toString()}\n    return LongInt(res)\n}\n\nfunction sub_pos(v1, v2){\n    // Substraction of positive numbers with v1>=v2\n\n    var res = '', carry = 0, i1=v1.length, sv=0\n    \n    // For all digits in v2, starting by the rightmost, substract it from\n    // the matching digit in v1\n    // This is the equivalent of the manual operation :\n    //    12345678\n    //   -   98765\n    //\n    // We begin by the rightmost operation : 8-5 (3, no carry),\n    // then 7-6 (1, no carry)\n    // then 6-7 (9, carry 1) and so on\n    for(var i=v2.length-1;i>=0;i--){\n        i1--\n        sv = parseInt(v1.charAt(i1))\n        x = (sv-carry-parseInt(v2.charAt(i)))\n        if(x<0){res=(10+x)+res;carry=1}\n        else{res=x+res;carry=0}\n    }\n    \n    // If there are remaining digits in v1, substract the carry, if any\n    while(i1>0){\n        i1--\n        x = (parseInt(v1.charAt(i1))-carry)\n        if(x<0){res=(10+x)+res;carry=1}\n        else{res=x+res;carry=0}\n    }\n\n    // Remove leading zeros and return the result\n    while(res.charAt(0)=='0' && res.length>1){res=res.substr(1)}\n    return {__class__:$LongIntDict, value:res, pos:true}\n}\n\n// Special methods to implement operations on instances of LongInt\n\n$LongIntDict.__abs__ = function(self){\n    return {__class__:$LongIntDict, value: self.value, pos:true}\n}\n\n$LongIntDict.__add__ = function(self, other){\n    if (typeof other == 'number') other=LongInt(_b_.str.$factory(other))\n    // Addition of \"self\" and \"other\"\n    // If both have the same sign (+ or -) we add their absolute values\n    // If they have different sign we use the substraction of their\n    // absolute values\n    var res\n    if(self.pos&&other.pos){  // self > 0, other > 0\n        return add_pos(self.value, other.value)\n    }else if(!self.pos&&!other.pos){ // self < 0, other < 0\n        res = add_pos(self.value, other.value)\n        res.pos = false\n        return res\n    }else if(self.pos && !other.pos){ // self > 0, other < 0\n        switch (comp_pos(self.value, other.value)){\n            case 1:\n                res = sub_pos(self.value, other.value)\n                break\n            case 0:\n                res = {__class__:$LongIntDict, value:0, pos:true}\n                break\n            case -1:\n                res = sub_pos(other.value, self.value)\n                res.pos = false\n                break\n        }\n        return res\n    }else{ // self < 0, other > 0\n        switch(comp_pos(self.value, other.value)){\n            case 1:\n                res = sub_pos(self.value, other.value)\n                res.pos = false\n                break\n            case 0:\n                res = {__class__:$LongIntDict, value:0, pos:true}\n                break\n            case -1:\n                res = sub_pos(other.value, self.value)\n                break\n        }\n        return res\n    }\n}\n\n$LongIntDict.__and__ = function(self, other){\n    if (typeof other == 'number') other=LongInt(_b_.str.$factory(other))\n    // Bitwise \"and\" : build the binary representation of self and other\n    var v1 = $LongIntDict.__index__(self)\n    var v2 = $LongIntDict.__index__(other)\n    // apply \"and\" on zeros and ones\n    if(v1.length<v2.length){var temp=v2;v2=v1;v1=temp}\n    var start = v1.length-v2.length\n    var res = ''\n    for(var i=0;i<v2.length;i++){\n        if(v1.charAt(start+i)=='1' && v2.charAt(i)=='1'){res += '1'}\n        else{res += '0'}\n    }\n    // Return the LongInt instance represented by res in base 2\n    return LongInt(res, 2)\n}\n\n$LongIntDict.__divmod__ = function(self, other){\n    if (typeof other == 'number') other=LongInt(_b_.str.$factory(other))\n\n    var dm = divmod_pos(self.value, other.value)\n    if(self.pos!==other.pos){\n        if(dm[0].value!='0'){dm[0].pos = false}\n        if(dm[1].value!='0'){\n            // If self and other have different signs and self is not a multiple\n            // of other, round to the previous integer\n            dm[0] = $LongIntDict.__sub__(dm[0], LongInt('1'))\n            dm[1] = $LongIntDict.__add__(dm[1], LongInt('1'))\n        }\n    }\n    return dm    \n}\n\n$LongIntDict.__eq__ = function(self, other){\n    if (typeof other == 'number') other=LongInt(_b_.str.$factory(other))\n    return self.value==other.value && self.pos==other.pos\n}\n\n$LongIntDict.__floordiv__ = function(self, other){\n    if (typeof other == 'number') other=LongInt(_b_.str.$factory(other))\n    return $LongIntDict.__divmod__(self, other)[0]\n}\n\n$LongIntDict.__ge__ = function(self, other){\n    if (typeof other == 'number') other=LongInt(_b_.str.$factory(other))\n    if(self.value.length>other.value.length){return true}\n    else if(self.value.length<other.value.length){return false}\n    else{return self.value >= other.value}\n}\n\n$LongIntDict.__gt__ = function(self, other){\n    return !$LongIntDict.__le__(self, other)\n}\n\n$LongIntDict.__index__ = function(self){\n    // Used by bin()\n    // returns a string with the binary value of self\n    // The algorithm computes the result of the floor division of self by 2\n    \n    // XXX to do : negative integers\n    \n    var res = '', pos=self.value.length,\n        temp = self.value, d\n    while(true){\n        d = divmod_pos(temp, '2')\n        res = d[1].value + res\n        temp = d[0].value\n        if(temp=='0'){break}\n    }\n    return res\n}\n\n$LongIntDict.__invert__ = function(self){\n    var bin = $LongIntDict.__index__(self)\n    var res = ''\n    for(var i=0;i<bin.length;i++){\n        res += bin.charAt(i)=='0' ? '1' : '0'\n    }\n    return LongInt(res, 2)\n}\n\n$LongIntDict.__le__ = function(self, other){\n    if (typeof other == 'number') other=LongInt(_b_.str.$factory(other))\n    if(self.value.length>other.value.length){return false}\n    else if(self.value.length<other.value.length){return true}\n    else{return self.value <= other.value}\n}\n\n$LongIntDict.__lt__ = function(self, other){\n    return !$LongIntDict.__ge__(self, other)\n}\n\n$LongIntDict.__lshift__ = function(self, shift){\n    check_shift(shift)\n    var res = self.value\n    while(true){\n        var x, carry=0, res1=''\n        for(var i=res.length-1;i>=0;i--){\n            x = (carry+parseInt(res.charAt(i))*2).toString()\n            if(x.length==2){res1=x.charAt(1)+res1;carry=parseInt(x.charAt(0))}\n            else{res1=x+res1;carry=0}\n        }\n        if(carry){res1=carry+res1}\n        res=res1\n        shift = sub_pos(shift.value, '1')\n        if(shift.value=='0'){break}\n    }\n    return {__class__:$LongIntDict, value:res, pos:self.pos}\n}\n\n$LongIntDict.__mod__ = function(self, other){\n    return $LongIntDict.__divmod__(self, other)[1]\n}\n\n$LongIntDict.__mro__ = [_b_.object]\n\n$LongIntDict.__mul__ = function(self, other){\n    if (typeof other == 'number') other=LongInt(_b_.str.$factory(other))\n    var res = mul_pos(self.value, other.value)\n    if(self.pos==other.pos){return res}\n    res.pos = false\n    return res\n}\n\n$LongIntDict.__neg__ = function(obj){\n    return {__class__:$LongIntDict, value:obj.value, pos:!obj.pos}\n}\n\n$LongIntDict.__or__ = function(self, other){\n    var v1 = $LongIntDict.__index__(self)\n    var v2 = $LongIntDict.__index__(other)\n    if(v1.length<v2.length){var temp=v2;v2=v1;v1=temp}\n    var start = v1.length-v2.length\n    var res = v1.substr(0, start)\n    for(var i=0;i<v2.length;i++){\n        if(v1.charAt(start+i)=='1' || v2.charAt(i)=='1'){res += '1'}\n        else{res += '0'}\n    }\n    return LongInt(res, 2)\n}\n\n\n$LongIntDict.__pow__ = function(self, power){\n    if (typeof power == \"number\") {\n        power=LongInt(_b_.str.$factory(power))\n    }else if(!isinstance(power, LongInt)){\n        var msg = \"power must be a LongDict, not '\"\n        throw TypeError(msg+$B.get_class(power).__name__+\"'\")\n    }\n    if(!power.pos){\n        if(self.value=='1'){return self}\n        // For all other integers, x**-n is 0\n        return LongInt('0')\n    }else if(power.value=='0'){\n        return LongInt('1')\n    }\n    var res = {__class__:$LongIntDict, value:self.value, pos:self.pos}\n    var pow = power.value\n    while(true){\n        pow = sub_pos(pow, '1').value\n        if(pow == '0'){break}\n        res = $LongIntDict.__mul__(res, self)\n    }\n    return res    \n}\n\n$LongIntDict.__rshift__ = function(self, shift){\n    check_shift(shift)\n    var res = self.value\n    while(true){\n        res = divmod_pos(res, '2')[0].value\n        if(res.value=='0'){break}\n        shift = sub_pos(shift.value, '1')\n        if(shift.value=='0'){break}\n    }\n    return {__class__:$LongIntDict, value:res, pos:self.pos}\n}\n\n$LongIntDict.__str__ = $LongIntDict.__repr__ = function(self){\n    var res = \"LongInt('\"\n    if(!self.pos){res += '-'}\n    return res+self.value+\"')\"\n}\n\n$LongIntDict.__sub__ = function(self, other){\n    if (typeof other == 'number') other=LongInt(_b_.str.$factory(other))\n    var res\n    if(self.pos && other.pos){\n        switch(comp_pos(self.value, other.value)){\n            case 1:\n                res = sub_pos(self.value, other.value)\n                break\n            case 0:\n                res = {__class__:$LongIntDict, value:'0', pos:true}\n                break\n            case -1:\n                res = sub_pos(other.value, self.value)\n                res.pos = false\n                break\n        }\n        return res\n    }else if(!self.pos && !other.pos){\n        switch(comp_pos(self.value, other.value)){\n            case 1:\n                res = sub_pos(self.value, other.value)\n                res.pos = false\n                break\n            case 0:\n                res = {__class__:$LongIntDict, value:'0', pos:true}\n                break\n            case -1:\n                res = sub_pos(other.value, self.value)\n                break\n        }\n        return res\n    }else if(self.pos && !other.pos){\n        return add_pos(self.value, other.value)\n    }else{\n        res = add_pos(self.value, other.value)\n        res.pos = false\n        return res\n    }\n}\n\n$LongIntDict.__xor__ = function(self, other){\n    var v1 = $LongIntDict.__index__(self)\n    var v2 = $LongIntDict.__index__(other)\n    if(v1.length<v2.length){var temp=v2;v2=v1;v1=temp}\n    var start = v1.length-v2.length\n    var res = v1.substr(0, start)\n    for(var i=0;i<v2.length;i++){\n        if(v1.charAt(start+i)=='1' && v2.charAt(i)=='0'){res += '1'}\n        else if(v1.charAt(start+i)=='0' && v2.charAt(i)=='1'){res += '1'}\n        else{res += '0'}\n    }\n    return LongInt(res, 2)\n}\n\n$LongIntDict.to_base = function(self, base){\n    // Returns the string representation of self in specified base\n    var res='', v=self.value\n    while(v>0){\n        var dm = divmod_pos(v, base.toString())\n        res = parseInt(dm[1].value).toString(base)+res\n        v = dm[0].value\n        if(v==0){break}\n    }\n    return res\n}\n\nfunction digits(base){\n    // Return an object where keys are all the digits valid in specified base\n    // and value is \"true\"\n    // Used to test if the string passed as first argument to LongInt is valid\n    var is_digits = {}\n    // Number from 0 to base, or from 0 to 9 if base > 10\n    for(var i=0;i<base;i++){\n        if(i==10){break}\n        is_digits[i]=true\n    }\n    if(base>10){\n        // Additional letters\n        // For instance in base 16, add \"abcdefABCDEF\" as keys\n        for(var i=0;i<base-10;i++){\n            is_digits[String.fromCharCode(65+i)]=true\n            is_digits[String.fromCharCode(97+i)]=true\n        }\n    }\n    return is_digits\n}\n\nvar MAX_SAFE_INTEGER = Math.pow(2, 53)-1;\nvar MIN_SAFE_INTEGER = -Number.MAX_SAFE_INTEGER;\n\nfunction isSafeInteger(n) {\n    return (typeof n === 'number' &&\n        Math.round(n) === n &&\n        Number.MIN_SAFE_INTEGER <= n &&\n        n <= Number.MAX_SAFE_INTEGER);\n}\n\nfunction LongInt(value, base){\n    if(arguments.length>2){\n        throw _b_.TypeError(\"LongInt takes at most 2 arguments (\"+\n            arguments.length+\" given)\")\n    }\n    // base defaults to 10\n    if(base===undefined){base = 10}\n    else if(!isinstance(base, int)){\n        throw TypeError(\"'\"+$B.get_class(base).__name__+\"' object cannot be interpreted as an integer\")\n    }\n    if(base<0 || base==1 || base>36){\n        throw ValueError(\"LongInt() base must be >= 2 and <= 36\")\n    }\n    if(isinstance(value, float)){\n        if(value>=0){value=Math.round(value.value)}\n        else{value=Math.ceil(value.value)}\n    }\n    if(typeof value=='number'){\n        if(isSafeInteger(value)){value = value.toString()}\n        else{throw ValueError(\"argument of long_int is not a safe integer\")}\n    }else if(typeof value!='string'){\n        throw ValueError(\"argument of long_int must be a string, not \"+\n            $B.get_class(value).__name__)\n    }\n    var has_prefix = false, pos = true, start = 0\n    // Strip leading and trailing whitespaces\n    while(value.charAt(0)==' ' && value.length){value = value.substr(1)}\n    while(value.charAt(value.length-1)==' ' && value.length){\n        value = value.substr(0, value.length-1)\n    }\n    // Check if string starts with + or -\n    if(value.charAt(0)=='+'){has_prefix=true}\n    else if(value.charAt(0)=='-'){has_prefix=true;pos=false}\n    if(has_prefix){\n        // Remove prefix\n        if(value.length==1){\n            // \"+\" or \"-\" alone are not valid arguments\n            throw ValueError('LongInt argument is not a valid number: \"'+value+'\"')\n        }else{value=value.substr(1)}\n    }\n    // Ignore leading zeros\n    while(start<value.length-1 && value.charAt(start)=='0'){start++}\n    value = value.substr(start)\n\n    // Check if all characters in value are valid in the base\n    var is_digits = digits(base), point = -1\n    for(var i=0;i<value.length;i++){\n        if(value.charAt(i)=='.' && point==-1){point=i}\n        else if(!is_digits[value.charAt(i)]){\n            throw ValueError('LongInt argument is not a valid number: \"'+value+'\"')\n        }\n    }\n    if(point!=-1){value=value.substr(0,point)}\n    if(base!=10){\n        // Conversion to base 10\n        var coef = '1', v10 = LongInt(0),\n            pos = value.length, digit_base10\n        while(pos--){\n            digit_base10 = parseInt(value.charAt(pos), base).toString()\n            digit_by_coef = mul_pos(coef, digit_base10).value\n            v10 = add_pos(v10.value, digit_by_coef)\n            coef = mul_pos(coef, base.toString()).value\n        }\n        return v10\n    }\n    return {__class__:$LongIntDict, value:value, pos:pos}\n}\n\nLongInt.__class__ = $B.$factory\nLongInt.$dict = $LongIntDict\n$LongIntDict.$factory = LongInt\n\nreturn {LongInt:LongInt}\n\n})(__BRYTHON__)\n"], "marshal": [".js", "var $module = (function($B){\n\nvar _b_ = $B.builtins\n\nreturn {\n    loads: function(){\n        var $ = $B.args('loads', 1, {obj:null}, ['obj'], arguments, {},\n            null, null)\n        return $B.structuredclone2pyobj(JSON.parse($.obj))\n    },\n    load: function(){\n        var $ = $B.args('load', 1, {file:null}, ['file'], arguments, {},\n            null, null)\n        var content = $B.$call($B.$getattr($.file, \"read\"))()\n        return $module.loads(_b_.bytes.decode(content, \"latin-1\"));\n    },\n    dump: function(){\n        var $ = $B.args('dump', 2, {value:null, file: null},\n            ['value', 'file'], arguments, {}, null, null)\n        var s = JSON.stringify($B.pyobj2structuredclone($.value))\n        $B.$getattr($.file, \"write\")(_b_.str.encode(s, 'latin-1'))\n        var flush = $B.$getattr($.file, \"flush\", null)\n        if(flush !== null){\n            $B.$call(flush)()\n        }\n        return _b_.None\n    },\n    dumps: function(){\n        var $ = $B.args('dumps', 1, {obj:null}, ['obj'], arguments, {},\n            null, null)\n        return JSON.stringify($B.pyobj2structuredclone($.obj))\n    }\n}\n\n})(__BRYTHON__)\n"], "math": [".js", "var $module = (function($B){\n\nvar _b_ = $B.builtins\n\n\nvar float_check = function(x) {\n    if(x.__class__ === $B.long_int){\n        return parseInt(x.value)\n    }\n    return _b_.float.$factory(x)\n}\n\nfunction check_int(x){\n    if(! _b_.isinstance(x, _b_.int)){\n        throw _b_.TypeError.$factory(\"'\" + $B.class_name(x) +\n            \"' object cannot be interpreted as an integer\")\n    }\n}\n\nfunction check_int_or_round_float(x){\n    return (x instanceof Number && x == Math.floor(x)) ||\n            _b_.isinstance(x, _b_.int)\n}\n\nvar isWholeNumber = function(x){return (x * 10) % 10 == 0}\n\nvar isOdd = function(x) {return isWholeNumber(x) && 2 * Math.floor(x / 2) != x}\n\nvar isNegZero = function(x) {return x === 0 && Math.atan2(x,x) < 0}\n\nvar EPSILON = Math.pow(2, -52),\n    MAX_VALUE = (2 - EPSILON) * Math.pow(2, 1023),\n    MIN_VALUE = Math.pow(2, -1022);\n\nfunction nextUp(x){\n    if(x !== x){\n        return x\n    }\n    if(_b_.$isinf(x)){\n        if(_b_.$isninf(x)){\n            return -MAX_VALUE\n        }\n        return _mod.inf\n    }\n\n    if(x == +MAX_VALUE){\n        return +1 / 0\n    }\n    if(typeof x == \"number\" || x instanceof Number){\n        var y = x * (x < 0 ? 1 - EPSILON / 2 : 1 + EPSILON)\n        if(y == x){\n            y = MIN_VALUE * EPSILON > 0 ? x + MIN_VALUE * EPSILON : x + MIN_VALUE\n        }\n        if(y === +1 / 0){\n            y = +MAX_VALUE\n        }\n        var b = x + (y - x) / 2\n        if(x < b && b < y){\n            y = b;\n        }\n        var c = (y + x) / 2\n        if(x < c && c < y){\n            y = c;\n        }\n        return y === 0 ? -0 : y\n    }else{\n        var factor = $B.rich_comp('__lt__', x, 0) ? 1 - EPSILON / 2 :\n                                                   1 + EPSILON\n        var y = $B.rich_op(\"mul\", x , factor)\n        if(y == x){\n            y = MIN_VALUE * EPSILON > 0 ?\n                    $B.rich_op('add', x, MIN_VALUE * EPSILON) :\n                    $B.rich_op('add', x, MIN_VALUE)\n        }\n        if(y === +1 / 0){\n            y = +MAX_VALUE\n        }\n        var y_minus_x = $B.rich_op('sub', y, x)\n        var z = $B.rich_op('truediv', y_minus_x, 2) // (y - x) / 2\n\n        var b = $B.rich_op('add', x, z)\n        if($B.rich_comp('__lt__', x, b) && $B.rich_comp('__lt__', b, y)){\n            y = b;\n        }\n        var c = $B.rich_op('truediv', $B.rich_op('add', y, x), 2)\n        if($B.rich_comp('__lt__', x, c) && $B.rich_comp('__lt__', c, y)){\n            y = c;\n        }\n        return y === 0 ? -0 : y\n    }\n}\n\nfunction gcd2(a, b){\n    // GCD of 2 factors\n    if($B.rich_comp(\"__gt__\", b, a)){\n        var temp = a\n        a = b\n        b = temp\n    }\n    while(true){\n        if(b == 0){\n            return a\n        }\n        a = $B.rich_op(\"mod\", a, b)\n        if(a == 0){\n            return b\n        }\n        b = $B.rich_op(\"mod\", b, a)\n    }\n}\n\nvar _mod = {\n    __getattr__: function(attr){\n        $B.check_nb_args('__getattr__ ', 1, arguments)\n        $B.check_no_kw('__getattr__ ', attr)\n\n        var res = this[attr]\n        if(res === undefined){\n            throw _b_.AttributeError.$factory(\n                'module math has no attribute ' + attr)\n        }\n        return res\n    },\n    acos: function(x){\n        $B.check_nb_args('acos', 1, arguments)\n        $B.check_no_kw('acos', x)\n        if(_mod.isinf(x)){\n            throw _b_.ValueError.$factory(\"math domain error\")\n        }else if(_mod.isnan(x)){\n            return _mod.nan\n        }else{\n            x = float_check(x)\n            if(x > 1 || x < -1){\n                throw _b_.ValueError.$factory(\"math domain error\")\n            }\n            return _b_.float.$factory(Math.acos(x))\n        }\n    },\n    acosh: function(x){\n        $B.check_nb_args('acosh', 1, arguments)\n        $B.check_no_kw('acosh', x)\n\n        if(_b_.$isinf(x)){\n            if(_b_.$isninf(x)){\n                throw _b_.ValueError.$factory(\"math domain error\")\n            }\n            return _mod.inf\n        }else if(_mod.isnan(x)){\n            return _mod.nan\n        }\n        var y = float_check(x)\n        if(y <= 0){\n            throw _b_.ValueError.$factory(\"math domain error\")\n        }\n        if(y > Math.pow(2, 28)){ // issue 1590\n            return _b_.float.$factory(_mod.log(y) + _mod.log(2))\n        }\n        return _b_.float.$factory(Math.log(y + Math.sqrt(y * y - 1)))\n    },\n    asin: function(x){\n        $B.check_nb_args('asin', 1, arguments)\n        $B.check_no_kw('asin', x)\n        if(_mod.isinf(x)){\n            throw _b_.ValueError.$factory(\"math domain error\")\n        }else if(_mod.isnan(x)){\n            return _mod.nan\n        }else{\n            x = float_check(x)\n            if(x > 1 || x < -1){\n                throw _b_.ValueError.$factory(\"math domain error\")\n            }\n            return _b_.float.$factory(Math.asin(x))\n        }\n    },\n    asinh: function(x){\n        $B.check_nb_args('asinh', 1, arguments)\n        $B.check_no_kw('asinh', x)\n\n        if(_b_.$isninf(x)){return _b_.float.$factory('-inf')}\n        if(_b_.$isinf(x)){return _b_.float.$factory('inf')}\n        var y = float_check(x)\n        if(y == 0 && 1 / y === -Infinity){\n            return new Number(-0.0)\n        }\n        return _b_.float.$factory(Math.asinh(y))\n    },\n    atan: function(x){\n        $B.check_nb_args('atan', 1, arguments)\n        $B.check_no_kw('atan', x)\n\n        if(_b_.$isninf(x)){return _b_.float.$factory(-Math.PI / 2)}\n        if(_b_.$isinf(x)){return _b_.float.$factory(Math.PI / 2)}\n        return _b_.float.$factory(Math.atan(float_check(x)))\n    },\n    atan2: function(y, x){\n        $B.check_nb_args('atan2', 2, arguments)\n        $B.check_no_kw('atan2', y, x)\n\n        return _b_.float.$factory(Math.atan2(float_check(y), float_check(x)))\n    },\n    atanh: function(x){\n        $B.check_nb_args('atanh', 1, arguments)\n        $B.check_no_kw('atanh', x)\n        if(_b_.$isinf(x)){\n            throw _b_.ValueError.$factory(\"math domain error\")\n        }\n        var y = float_check(x)\n        if(y == 0){\n            return 0\n        }else if(y <= -1 || y >= 1){\n            throw _b_.ValueError.$factory(\"math domain error\")\n        }\n        return _b_.float.$factory(0.5 * Math.log((1 / y + 1)/(1 / y - 1)));\n    },\n    ceil: function(x){\n        $B.check_nb_args('ceil', 1, arguments)\n        $B.check_no_kw('ceil', x)\n\n        var res\n\n        if(x instanceof Number){\n            x = _b_.float.numerator(x)\n            if(_b_.$isinf(x) || _mod.isnan(x)){\n                return x\n            }\n            return _b_.int.$factory(Math.ceil(x))\n        }\n\n        var klass = x.__class__ || $B.get_class(x)\n\n        try{\n            // Use attribute of the object's class, not of the object\n            // itself (special method)\n            return $B.$call($B.$getattr(klass, '__ceil__'))(x)\n        }catch(err){\n            if(! $B.is_exc(err, [_b_.AttributeError])){\n                throw err\n            }\n        }\n\n        try{\n            x = $B.$call($B.$getattr(klass, '__float__'))(x)\n        }catch(err){\n            if(! $B.is_exc(err, [_b_.AttributeError])){\n                throw err\n            }else{\n                throw _b_.TypeError.$factory(\"must be real number, not \" +\n                   $B.class_name(x))\n            }\n        }\n        return _mod.ceil(x)\n    },\n    comb: function(n, k){\n        $B.check_nb_args('comb', 2, arguments)\n        $B.check_no_kw('comb', n, k)\n\n        // raise TypeError if n or k is not an integer\n        check_int(n)\n        check_int(k)\n\n        if(k < 0){\n            throw _b_.ValueError.$factory(\"k must be a non-negative integer\")\n        }\n        if(n < 0){\n            throw _b_.ValueError.$factory(\"n must be a non-negative integer\")\n        }\n\n        if(k > n){\n            return 0\n        }\n        // Evaluates to n! / (k! * (n - k)!)\n        var fn = _mod.factorial(n),\n            fk = _mod.factorial(k),\n            fn_k = _mod.factorial(n - k)\n        return $B.floordiv(fn, $B.mul(fk, fn_k))\n    },\n    copysign: function(x, y){\n        $B.check_nb_args('copysign', 2, arguments)\n        $B.check_no_kw('copysign', x,y)\n\n        var x1 = Math.abs(float_check(x))\n        var y1 = float_check(y)\n        var sign = Math.sign(y1)\n        sign = (sign == 1 || Object.is(sign, +0)) ? 1 : - 1\n        return _b_.float.$factory(x1 * sign)\n    },\n    cos : function(x){\n        $B.check_nb_args('cos ', 1, arguments)\n        $B.check_no_kw('cos ', x)\n        return _b_.float.$factory(Math.cos(float_check(x)))\n    },\n    cosh: function(x){\n        $B.check_nb_args('cosh', 1, arguments)\n        $B.check_no_kw('cosh', x)\n\n        if(_b_.$isinf(x)){return _b_.float.$factory('inf')}\n        var y = float_check(x)\n        if(Math.cosh !== undefined){return _b_.float.$factory(Math.cosh(y))}\n        return _b_.float.$factory((Math.pow(Math.E, y) +\n            Math.pow(Math.E, -y)) / 2)\n    },\n    degrees: function(x){\n        $B.check_nb_args('degrees', 1, arguments)\n        $B.check_no_kw('degrees', x)\n        return _b_.float.$factory(float_check(x) * 180 / Math.PI)\n    },\n    dist: function(p, q){\n        $B.check_nb_args('dist', 2, arguments)\n        $B.check_no_kw('dist', p, q)\n\n        function test(x){\n            if(typeof x === \"number\" || x instanceof Number){\n                return x\n            }\n            var y = $B.$getattr(x, '__float__', null)\n            if(y === null){\n                throw _b_.TypeError.$factory('not a float')\n            }\n            return $B.$call(y)()\n        }\n\n        // build list of differences (as floats) between coordinates of p and q\n        var diffs = [],\n            diff\n\n        if(Array.isArray(p) && Array.isArray(q)){\n            // simple case : p and q are lists of tuples\n            if(p.length != q.length){\n                throw _b_.ValueError.$factory(\"both points must have \" +\n                    \"the same number of dimensions\")\n            }\n            for(var i = 0, len = p.length; i < len; i++){\n                var next_p = test(p[i]),\n                    next_q = test(q[i]),\n                    diff = Math.abs(next_p - next_q)\n                if(_b_.$isinf(diff)){\n                    return _mod.inf\n                }\n                diffs.push(diff)\n            }\n        }else{\n            var itp = _b_.iter(p),\n                itq = _b_.iter(q),\n                res = 0\n\n            while(true){\n                try{\n                    var next_p = _b_.next(itp)\n                }catch(err){\n                    if(err.__class__ === _b_.StopIteration){\n                        // check that the other iterator is also exhausted\n                        try{\n                            var next_q = _b_.next(itq)\n                            throw _b_.ValueError.$factory(\"both points must have \" +\n                                \"the same number of dimensions\")\n                        }catch(err){\n                            if(err.__class__ === _b_.StopIteration){\n                                break\n                            }\n                            throw err\n                        }\n                    }\n                    throw err\n                }\n                next_p = test(next_p)\n                try{\n                    var next_q = _b_.next(itq)\n                }catch(err){\n                    if(err.__class__ === _b_.StopIteration){\n                        throw _b_.ValueError.$factory(\"both points must have \" +\n                            \"the same number of dimensions\")\n                    }\n                    throw err\n                }\n                next_q = test(next_q)\n                diff = Math.abs(next_p - next_q)\n                if(_b_.$isinf(diff)){\n                    return _mod.inf\n                }\n                diffs.push(diff)\n            }\n        }\n\n        var res = 0,\n            scale = 1,\n            max_diff = Math.max(...diffs),\n            min_diff = Math.min(...diffs)\n            max_value = Math.sqrt(Number.MAX_VALUE) / p.length,\n            min_value = Math.sqrt(Number.MIN_VALUE) * p.length\n        if(max_diff > max_value){\n            while(max_diff > max_value){\n                scale *= 2\n                max_diff /= 2\n            }\n            for(var diff of diffs){\n                diff = diff / scale\n                res += diff * diff\n            }\n            return scale * _mod.sqrt(res)\n        }else if(min_diff !== 0 && min_diff < min_value){\n            while(min_diff < min_value){\n                scale *= 2\n                min_diff *= 2\n            }\n            for(var diff of diffs){\n                diff = diff * scale\n                res += diff * diff\n            }\n            return _mod.sqrt(res) / scale\n        }else{\n            for(var diff of diffs){\n                res += Math.pow(diff, 2)\n            }\n            return _mod.sqrt(res)\n        }\n    },\n    e: _b_.float.$factory(Math.E),\n    erf: function(x){\n        $B.check_nb_args('erf', 1, arguments)\n        $B.check_no_kw('erf', x)\n\n        // inspired from\n        // http://stackoverflow.com/questions/457408/is-there-an-easily-available-implementation-of-erf-for-python\n        var y = float_check(x)\n        var t = 1.0 / (1.0 + 0.5 * Math.abs(y))\n        var ans = 1 - t * Math.exp( -y * y - 1.26551223 +\n                     t * ( 1.00002368 +\n                     t * ( 0.37409196 +\n                     t * ( 0.09678418 +\n                     t * (-0.18628806 +\n                     t * ( 0.27886807 +\n                     t * (-1.13520398 +\n                     t * ( 1.48851587 +\n                     t * (-0.82215223 +\n                     t * 0.17087277)))))))))\n        if(y >= 0.0){return ans}\n        return -ans\n    },\n    erfc: function(x){\n\n        $B.check_nb_args('erfc', 1, arguments)\n        $B.check_no_kw('erfc', x)\n\n        // inspired from\n        // http://stackoverflow.com/questions/457408/is-there-an-easily-available-implementation-of-erf-for-python\n        var y = float_check(x)\n        var t = 1.0 / (1.0 + 0.5 * Math.abs(y))\n        var ans = 1 - t * Math.exp( -y * y - 1.26551223 +\n                     t * ( 1.00002368 +\n                     t * ( 0.37409196 +\n                     t * ( 0.09678418 +\n                     t * (-0.18628806 +\n                     t * ( 0.27886807 +\n                     t * (-1.13520398 +\n                     t * ( 1.48851587 +\n                     t * (-0.82215223 +\n                     t * 0.17087277)))))))))\n        if(y >= 0.0){return 1 - ans}\n        return 1 + ans\n    },\n    exp: function(x){\n        $B.check_nb_args('exp', 1, arguments)\n        $B.check_no_kw('exp', x)\n\n         if(_b_.$isninf(x)){return _b_.float.$factory(0)}\n         if(_b_.$isinf(x)){return _b_.float.$factory('inf')}\n         var _r = Math.exp(float_check(x))\n         if(_b_.$isinf(_r)){throw _b_.OverflowError.$factory(\"math range error\")}\n         return _b_.float.$factory(_r)\n    },\n    expm1: function(x){\n        $B.check_nb_args('expm1', 1, arguments)\n        $B.check_no_kw('expm1', x)\n\n         if(_b_.$isninf(x)){return _b_.float.$factory(0)}\n         if(_b_.$isinf(x)){return _b_.float.$factory('inf')}\n         var _r = Math.expm1(float_check(x))\n         if(_b_.$isinf(_r)){throw _b_.OverflowError.$factory(\"math range error\")}\n         return _b_.float.$factory(_r)\n    },\n    //fabs: function(x){ return x>0?float.$factory(x):float.$factory(-x)},\n    fabs: function(x){\n        $B.check_nb_args('fabs', 1, arguments)\n        $B.check_no_kw('fabs', x)\n        return _b_.$fabs(x) // located in py_float.js\n    },\n    factorial: function(x){\n        $B.check_nb_args('factorial', 1, arguments)\n        $B.check_no_kw('factorial', x)\n\n        if(x instanceof Number || _b_.isinstance(x, _b_.float)){\n            var warning = _b_.DeprecationWarning.$factory(\n                \"Using factorial() with floats is deprecated\")\n            // module _warning is in builtin_modules.js\n            $B.imported._warnings.warn(warning)\n         }\n\n        if(! _b_.isinstance(x, [_b_.float, _b_.int])){\n            throw _b_.TypeError.$factory(`'${$B.class_name(x)}' object ` +\n                \"cannot be interpreted as an integer\")\n        }\n\n        //using code from http://stackoverflow.com/questions/3959211/fast-factorial-function-in-javascript\n        if(! check_int_or_round_float(x)){\n            throw _b_.ValueError.$factory(\"factorial() only accepts integral values\")\n        }else if($B.rich_comp(\"__lt__\", x, 0)){\n            throw _b_.ValueError.$factory(\"factorial() not defined for negative values\")\n        }\n        var r = 1\n        for(var i = 2; i <= x; i++){\n            r = $B.mul(r, i)\n        }\n        return r\n    },\n    floor: function(x){\n        $B.check_nb_args('floor', 1, arguments)\n        $B.check_no_kw('floor', x)\n        if(typeof x == \"number\" ||\n                x instanceof Number){\n            return Math.floor(float_check(x))\n        }\n        try{\n            return $B.$call($B.$getattr(x, \"__floor__\"))()\n        }catch(err){\n            if($B.is_exc(err, [_b_.AttributeError])){\n                try{\n                    var f = $B.$call($B.$getattr(x, \"__float__\"))()\n                    return _mod.floor(f)\n                }catch(err){\n                    if($B.is_exc(err, [_b_.AttributeError])){\n                        throw _b_.TypeError.$factory(\"no __float__\")\n                    }\n                    throw err\n                }\n            }\n        }\n    },\n    fmod: function(x,y){\n        $B.check_nb_args('fmod', 2, arguments)\n        $B.check_no_kw('fmod', x,y)\n        return _b_.float.$factory(float_check(x) % float_check(y))\n    },\n    frexp: function(x){\n        $B.check_nb_args('frexp', 1, arguments)\n        $B.check_no_kw('frexp', x)\n\n        var _l = _b_.$frexp(x)\n        return _b_.tuple.$factory([_b_.float.$factory(_l[0]), _l[1]])\n    },\n    fsum: function(x){\n        $B.check_nb_args('fsum', 1, arguments)\n        $B.check_no_kw('fsum', x)\n\n        /* Translation into Javascript of the function msum in an Active\n           State Cookbook recipe : https://code.activestate.com/recipes/393090/\n           by Raymond Hettinger\n        */\n        var partials = [],\n            res = new Number(),\n            _it = _b_.iter(x)\n        while(true){\n            try{\n                var x = _b_.next(_it),\n                    i = 0\n                for(var j = 0, len = partials.length; j < len; j++){\n                    var y = partials[j]\n                    if(Math.abs(x) < Math.abs(y)){\n                        var z = x\n                        x = y\n                        y = z\n                    }\n                    var hi = x + y,\n                        lo = y - (hi - x)\n                    if(lo){\n                        partials[i] = lo\n                        i++\n                    }\n                    x = hi\n                }\n                partials = partials.slice(0, i).concat([x])\n            }catch(err){\n                if(_b_.isinstance(err, _b_.StopIteration)){break}\n                throw err\n            }\n        }\n        var res = new Number(0)\n        for(var i = 0; i < partials.length; i++){\n            res += new Number(partials[i])\n        }\n        return new Number(res)\n    },\n    gamma: function(x){\n        $B.check_nb_args('gamma', 1, arguments)\n        $B.check_no_kw('gamma', x)\n\n        if(x === Number.POSITIVE_INFINITY){\n            return _mod.inf\n        }else if(x === Number.NEGATIVE_INFINITY){\n            throw _b_.ValueError.$factory(\"math domain error\")\n        }\n        if(_b_.isinstance(x, _b_.int) ||\n                (_b_.isinstance(x, _b_.float) && x == _b_.int.$factory(x))){\n            if(x < 1){\n                throw _b_.ValueError.$factory(\"math domain error\")\n            }\n            var res = 1\n            for(var i = 1; i < x; i++){res *= i}\n            return new Number(res)\n        }\n        // Adapted from https://en.wikipedia.org/wiki/Lanczos_approximation\n        var p = [676.5203681218851,\n            -1259.1392167224028,\n            771.32342877765313,\n            -176.61502916214059,\n            12.507343278686905,\n            -0.13857109526572012,\n            9.9843695780195716e-6,\n            1.5056327351493116e-7\n            ]\n\n        var EPSILON = 1e-07\n        function drop_imag(z){\n            if(Math.abs(z.imag) <= EPSILON){\n                z = z.real\n            }\n            return z\n        }\n        var z = x\n        if(z < 0){\n            // Use formula \u0393(z) = \u0393(z + n + 1) / z (z + 1) ... (z + n)\n            // with n such that z + n + 1 > 0\n            var n = Math.ceil(-z - 1),\n                g = _mod.gamma(new Number(z + n + 1))\n            for(var i = 0; i <= n; i++){\n                g = g / (z + i)\n            }\n            return g\n        }else if(z < 0.5){\n            var y = Math.PI / (Math.sin(Math.PI * z) * _mod.gamma(1-z)) // Reflection formula\n        }else{\n            z -= 1\n            var x = 0.99999999999980993,\n                i = 0\n            for(var i = 0, len = p.length; i < len; i++){\n                var pval = p[i]\n                x += pval / (z + i + 1)\n            }\n            var t = z + p.length - 0.5,\n                sq = Math.sqrt(2 * Math.PI),\n                y = sq * Math.pow(t, (z + 0.5)) * Math.exp(-t) * x\n        }\n        return drop_imag(y)\n    },\n    gcd: function(){\n        var $ = $B.args(\"gcd\", 0, {}, [], arguments, {}, 'args', null)\n        var args = $.args.map($B.PyNumber_Index)\n\n        if(args.length == 0){\n            return 0\n        }else if(args.length == 1){\n            return _b_.abs(args[0])\n        }\n        // https://stackoverflow.com/questions/17445231/js-how-to-find-the-greatest-common-divisor\n        var a = _b_.abs(args[0]),\n            b\n        for(var i = 1, len = args.length; i < len; i++){\n            a = gcd2(a, _b_.abs(args[i]))\n        }\n        return a\n    },\n    hypot: function(x, y){\n        var $ = $B.args(\"hypot\", 2, {x: null, y:null}, ['x', 'y'],\n                    arguments, {}, \"args\", null),\n            args = [x, y].concat($.args),\n            res = 0\n        return _b_.float.$factory(Math.hypot(...args))\n    },\n    inf: _b_.float.$factory('inf'),\n    isclose: function(){\n        var $ = $B.args(\"isclose\",\n                          4,\n                          {a: null, b: null, rel_tol: null, abs_tol: null},\n                          ['a', 'b', 'rel_tol', 'abs_tol'],\n                          arguments,\n                          {rel_tol: 1e-09, abs_tol: 0.0},\n                          '*',\n                          null)\n        var a = $.a,\n            b = $.b,\n            rel_tol = $.rel_tol,\n            abs_tol = $.abs_tol\n        if(rel_tol < 0.0 || abs_tol < 0.0){\n            throw _b_.ValueError.$factory('tolerances must be non-negative')\n        }\n\n        if(a == b){\n            return _b_.True\n        }\n        if(_b_.$isinf(a) || _b_.$isinf(b)){\n            return a === b\n        }\n        // isclose(a, b, rel_tol, abs_tol) is the same as\n        // abs_diff = abs(a - b)\n        // max_ab = max(abs(a), abs(b))\n        // abs_diff <= abs_tol or abs_diff / max_ab <= rel_tol\n        // This is more correct than in Python docs:\n        // \"abs(a-b) <= max(rel_tol * max(abs(a), abs(b)), abs_tol)\"\n        // because this fails for Decimal instances, which do not support\n        // multiplication by floats\n\n        var diff = $B.$call($B.$getattr(b, '__sub__'))(a),\n            abs_diff = $B.$call($B.$getattr(diff, \"__abs__\"))()\n        if($B.rich_comp(\"__le__\", abs_diff, abs_tol)){\n            return true\n        }\n        var abs_a = $B.$call($B.$getattr(a, '__abs__'))(),\n            abs_b = $B.$call($B.$getattr(b, '__abs__'))(),\n            max_ab = abs_a\n        if($B.rich_comp(\"__gt__\", abs_b, abs_a)){\n            max_ab = abs_b\n        }\n        return $B.rich_comp(\"__le__\",\n            $B.$call($B.$getattr(abs_diff, \"__truediv__\"))(max_ab),\n            rel_tol)\n    },\n    isfinite: function(x){\n        $B.check_nb_args('isfinite', 1, arguments)\n        $B.check_no_kw('isfinite', x)\n        return isFinite(float_check(x))\n    },\n    isinf: function(x){\n        $B.check_nb_args('isinf', 1, arguments)\n        $B.check_no_kw('isinf', x)\n        return _b_.$isinf(float_check(x))\n    },\n    isnan: function(x){\n        $B.check_nb_args('isnan', 1, arguments)\n        $B.check_no_kw('isnan', x)\n        return isNaN(float_check(x))\n    },\n    isqrt: function(x){\n        $B.check_nb_args('isqrt', 1, arguments)\n        $B.check_no_kw('isqrt', x)\n\n        x = $B.PyNumber_Index(x)\n        if($B.rich_comp(\"__lt__\", x, 0)){\n            throw _b_.ValueError.$factory(\n                \"isqrt() argument must be nonnegative\")\n        }\n        if(typeof x == \"number\"){\n            return Math.floor(Math.sqrt(x))\n        }else{ // big integer\n            var v = parseInt(x.value),\n                candidate = Math.floor(Math.sqrt(v)),\n                c1\n            // Use successive approximations : sqr = (sqr + (x / sqr)) / 2\n            // Limit to 100 iterations\n            for(var i = 0; i < 100; i++){\n                c1 = $B.floordiv($B.add(candidate,\n                    $B.floordiv(x, candidate)), 2)\n                if(c1 === candidate || c1.value === candidate.value){\n                    break\n                }\n                candidate = c1\n            }\n            if($B.rich_comp(\"__gt__\", $B.mul(candidate, candidate), x)){\n                // Result might be greater by 1\n                candidate = $B.sub(candidate, 1)\n            }\n            return candidate\n        }\n    },\n    lcm: function(){\n        var $ = $B.args(\"lcm\", 0, {}, [], arguments, {}, 'args', null),\n            product = 1\n\n        var args = $.args.map($B.PyNumber_Index)\n        if(args.length == 0){\n            return 1\n        }else if(args.length == 1){\n            return _b_.abs(args[0])\n        }\n        var a = _b_.abs(args[0]),\n            b,\n            product, gcd\n        for(var i = 0, len = args.length; i < len; i++){\n            b = _b_.abs(args[i])\n            if(b == 0){\n                return 0\n            }\n            gcd = gcd2(a, b)\n            product = $B.mul(a, b)\n            a = $B.$getattr(product, \"__floordiv__\")(gcd)\n        }\n        return a\n    },\n    ldexp: function(x, i){\n        $B.check_nb_args('ldexp', 2, arguments)\n        $B.check_no_kw('ldexp', x, i)\n        return _b_.$ldexp(x, i)   //located in py_float.js\n    },\n    lgamma: function(x){\n        $B.check_nb_args('lgamma', 1, arguments)\n        $B.check_no_kw('lgamma', x)\n\n        // copied from\n        // https://github.com/czurnieden/ieee745gamma/blob/master/ieee745gamma.js\n        // by Christoph Zurnieden\n        // see \"LICENCE math lgamma.txt\"\n        var double_int = new DataView(new ArrayBuffer(8))\n        var half = 5.00000000000000000000e-01 /* 0x3FE00000, 0x00000000 */\n        var one = 1.00000000000000000000e+00 /* 0x3FF00000, 0x00000000 */\n        var pi = 3.14159265358979311600e+00 /* 0x400921FB, 0x54442D18 */\n        var a0 = 7.72156649015328655494e-02 /* 0x3FB3C467, 0xE37DB0C8 */\n        var a1 = 3.22467033424113591611e-01 /* 0x3FD4A34C, 0xC4A60FAD */\n        var a2 = 6.73523010531292681824e-02 /* 0x3FB13E00, 0x1A5562A7 */\n        var a3 = 2.05808084325167332806e-02 /* 0x3F951322, 0xAC92547B */\n        var a4 = 7.38555086081402883957e-03 /* 0x3F7E404F, 0xB68FEFE8 */\n        var a5 = 2.89051383673415629091e-03 /* 0x3F67ADD8, 0xCCB7926B */\n        var a6 = 1.19270763183362067845e-03 /* 0x3F538A94, 0x116F3F5D */\n        var a7 = 5.10069792153511336608e-04 /* 0x3F40B6C6, 0x89B99C00 */\n        var a8 = 2.20862790713908385557e-04 /* 0x3F2CF2EC, 0xED10E54D */\n        var a9 = 1.08011567247583939954e-04 /* 0x3F1C5088, 0x987DFB07 */\n        var a10 = 2.52144565451257326939e-05 /* 0x3EFA7074, 0x428CFA52 */\n        var a11 = 4.48640949618915160150e-05 /* 0x3F07858E, 0x90A45837 */\n        var tc = 1.46163214496836224576e+00 /* 0x3FF762D8, 0x6356BE3F */\n        var tf = -1.21486290535849611461e-01 /* 0xBFBF19B9, 0xBCC38A42 */\n        /* tt = -(tail of tf) */\n        var tt = -3.63867699703950536541e-18 /* 0xBC50C7CA, 0xA48A971F */\n        var t0 = 4.83836122723810047042e-01 /* 0x3FDEF72B, 0xC8EE38A2 */\n        var t1 = -1.47587722994593911752e-01 /* 0xBFC2E427, 0x8DC6C509 */\n        var t2 = 6.46249402391333854778e-02 /* 0x3FB08B42, 0x94D5419B */\n        var t3 = -3.27885410759859649565e-02 /* 0xBFA0C9A8, 0xDF35B713 */\n        var t4 = 1.79706750811820387126e-02 /* 0x3F9266E7, 0x970AF9EC */\n        var t5 = -1.03142241298341437450e-02 /* 0xBF851F9F, 0xBA91EC6A */\n        var t6 = 6.10053870246291332635e-03 /* 0x3F78FCE0, 0xE370E344 */\n        var t7 = -3.68452016781138256760e-03 /* 0xBF6E2EFF, 0xB3E914D7 */\n        var t8 = 2.25964780900612472250e-03 /* 0x3F6282D3, 0x2E15C915 */\n        var t9 = -1.40346469989232843813e-03 /* 0xBF56FE8E, 0xBF2D1AF1 */\n        var t10 = 8.81081882437654011382e-04 /* 0x3F4CDF0C, 0xEF61A8E9 */\n        var t11 = -5.38595305356740546715e-04 /* 0xBF41A610, 0x9C73E0EC */\n        var t12 = 3.15632070903625950361e-04 /* 0x3F34AF6D, 0x6C0EBBF7 */\n        var t13 = -3.12754168375120860518e-04 /* 0xBF347F24, 0xECC38C38 */\n        var t14 = 3.35529192635519073543e-04 /* 0x3F35FD3E, 0xE8C2D3F4 */\n        var u0 = -7.72156649015328655494e-02 /* 0xBFB3C467, 0xE37DB0C8 */\n        var u1 = 6.32827064025093366517e-01 /* 0x3FE4401E, 0x8B005DFF */\n        var u2 = 1.45492250137234768737e+00 /* 0x3FF7475C, 0xD119BD6F */\n        var u3 = 9.77717527963372745603e-01 /* 0x3FEF4976, 0x44EA8450 */\n        var u4 = 2.28963728064692451092e-01 /* 0x3FCD4EAE, 0xF6010924 */\n        var u5 = 1.33810918536787660377e-02 /* 0x3F8B678B, 0xBF2BAB09 */\n        var v1 = 2.45597793713041134822e+00 /* 0x4003A5D7, 0xC2BD619C */\n        var v2 = 2.12848976379893395361e+00 /* 0x40010725, 0xA42B18F5 */\n        var v3 = 7.69285150456672783825e-01 /* 0x3FE89DFB, 0xE45050AF */\n        var v4 = 1.04222645593369134254e-01 /* 0x3FBAAE55, 0xD6537C88 */\n        var v5 = 3.21709242282423911810e-03 /* 0x3F6A5ABB, 0x57D0CF61 */\n        var s0 = -7.72156649015328655494e-02 /* 0xBFB3C467, 0xE37DB0C8 */\n        var s1 = 2.14982415960608852501e-01 /* 0x3FCB848B, 0x36E20878 */\n        var s2 = 3.25778796408930981787e-01 /* 0x3FD4D98F, 0x4F139F59 */\n        var s3 = 1.46350472652464452805e-01 /* 0x3FC2BB9C, 0xBEE5F2F7 */\n        var s4 = 2.66422703033638609560e-02 /* 0x3F9B481C, 0x7E939961 */\n        var s5 = 1.84028451407337715652e-03 /* 0x3F5E26B6, 0x7368F239 */\n        var s6 = 3.19475326584100867617e-05 /* 0x3F00BFEC, 0xDD17E945 */\n        var r1 = 1.39200533467621045958e+00 /* 0x3FF645A7, 0x62C4AB74 */\n        var r2 = 7.21935547567138069525e-01 /* 0x3FE71A18, 0x93D3DCDC */\n        var r3 = 1.71933865632803078993e-01 /* 0x3FC601ED, 0xCCFBDF27 */\n        var r4 = 1.86459191715652901344e-02 /* 0x3F9317EA, 0x742ED475 */\n        var r5 = 7.77942496381893596434e-04 /* 0x3F497DDA, 0xCA41A95B */\n        var r6 = 7.32668430744625636189e-06 /* 0x3EDEBAF7, 0xA5B38140 */\n        var w0 = 4.18938533204672725052e-01 /* 0x3FDACFE3, 0x90C97D69 */\n        var w1 = 8.33333333333329678849e-02 /* 0x3FB55555, 0x5555553B */\n        var w2 = -2.77777777728775536470e-03 /* 0xBF66C16C, 0x16B02E5C */\n        var w3 = 7.93650558643019558500e-04 /* 0x3F4A019F, 0x98CF38B6 */\n        var w4 = -5.95187557450339963135e-04 /* 0xBF4380CB, 0x8C0FE741 */\n        var w5 = 8.36339918996282139126e-04 /* 0x3F4B67BA, 0x4CDAD5D1 */\n        var w6 = -1.63092934096575273989e-03 /* 0xBF5AB89D, 0x0B9E43E4 */\n        var zero = 0.00000000000000000000e+00\n\n        var t, y, z, nadj = 0,\n          p, p1, p2, p3, q, r, w\n\n        var i = 0 | 0,\n          hx = 0 | 0,\n          lx = 0 | 0,\n          ix = 0 | 0\n\n        double_int.setFloat64(0, x)\n\n        hx = double_int.getInt32(0) /* high word */\n        lx = double_int.getInt32(4) /* low word */\n\n        /* purge off +-inf, NaN, +-0, and negative arguments */\n        lgamma_sign = 1\n        ix = hx & 0x7fffffff\n        if(ix >= 0x7ff00000){\n          return new Number(x * x)\n        }\n        if((ix | lx) == 0){\n          if(hx & 0x80000000){\n            lgamma_sign = -1\n          }\n          return new Number(one / zero)\n        }\n        if(ix < 0x3b900000){ /* |x|<2**-70, return -log(|x|) */\n          if(hx < 0){\n            lgamma_sign = -1\n            return new Number(-Math.log(-x))\n          } else {\n            return new Number(-Math.log(x))\n          }\n        }\n        if(hx < 0){\n          if(ix >= 0x43300000){ /* |x|>=2**52, must be -integer */\n            return new Number(one / zero)\n          }\n          t = sin_pi(x)\n          if(t == zero){\n            return new Number(one / zero)\n          } /* -integer */\n          nadj = Math.log(pi / Math.abs(t * x))\n          if(t < zero){\n            lgamma_sign = -1\n          }\n          x = -x\n        }\n        /* purge off 1 and 2 */\n        if((((ix - 0x3ff00000) | lx) == 0) || (((ix - 0x40000000) | lx) == 0)){\n          r = 0\n        }\n        /* for x < 2.0 */\n        else if(ix < 0x40000000){\n          if(ix <= 0x3feccccc){ /* lgamma(x) = lgamma(x+1)-log(x) */\n            r = -Math.log(x)\n            if(ix >= 0x3FE76944){\n              y = one - x\n              i = 0\n            }else if(ix >= 0x3FCDA661){\n              y = x - (tc - one)\n              i = 1\n            }else{\n              y = x\n              i = 2\n            }\n          }else{\n            r = zero\n            if(ix >= 0x3FFBB4C3){\n              y = 2.0 - x\n              i = 0\n            } /* [1.7316,2] */\n            else if(ix >= 0x3FF3B4C4){\n              y = x - tc\n              i = 1\n            } /* [1.23,1.73] */\n            else{\n              y = x - one\n              i = 2\n            }\n          }\n          switch(i){\n            case 0:\n              z = y * y\n              p1 = a0 + z * (a2 + z * (a4 + z * (a6 + z * (a8 + z * a10))))\n              p2 = z * (a1 + z * (a3 + z * (a5 + z * (a7 + z * (a9 + z * a11)))))\n              p = y * p1 + p2\n              r += (p - 0.5 * y)\n              break\n            case 1:\n              z = y * y\n              w = z * y\n              p1 = t0 + w * (t3 + w * (t6 + w * (t9 + w * t12))) /* parallel comp */\n              p2 = t1 + w * (t4 + w * (t7 + w * (t10 + w * t13)))\n              p3 = t2 + w * (t5 + w * (t8 + w * (t11 + w * t14)))\n              p = z * p1 - (tt - w * (p2 + y * p3))\n              r += (tf + p)\n              break\n            case 2:\n              p1 = y * (u0 + y * (u1 + y * (u2 + y * (u3 + y * (u4 + y * u5)))))\n              p2 = one + y * (v1 + y * (v2 + y * (v3 + y * (v4 + y * v5))))\n              r += (-0.5 * y + p1 / p2)\n          }\n        }else if(ix < 0x40200000){ /* x < 8.0 */\n          i = x | 0\n          t = zero\n          y = x - i\n          p = y * (s0 + y * (s1 + y * (s2 + y * (s3 + y * (s4 + y * (s5 + y *\n            s6))))))\n          q = one + y * (r1 + y * (r2 + y * (r3 + y * (r4 + y * (r5 + y * r6)))))\n          r = half * y + p / q\n          z = one /* lgamma(1+s) = log(s) + lgamma(s) */\n          switch(i){\n            case 7:\n              z *= (y + 6.0) /* FALLTHRU */\n            case 6:\n              z *= (y + 5.0) /* FALLTHRU */\n            case 5:\n              z *= (y + 4.0) /* FALLTHRU */\n            case 4:\n              z *= (y + 3.0) /* FALLTHRU */\n            case 3:\n              z *= (y + 2.0) /* FALLTHRU */\n              r += Math.log(z)\n              break\n          }\n          /* 8.0 <= x < 2**58 */\n        }else if(ix < 0x43900000){\n          t = Math.log(x)\n          z = one / x\n          y = z * z\n          w = w0 + z * (w1 + y * (w2 + y * (w3 + y * (w4 + y * (w5 + y * w6)))))\n          r = (x - half) * (t - one) + w\n        }else{\n          /* 2**58 <= x <= inf */\n          r = x * (Math.log(x) - one)\n        }\n        if(hx < 0){\n          r = nadj - r\n        }\n        return new Number(r)\n    },\n    log: function(x, base){\n        var $ = $B.args(\"log\", 2, {x: null, base: null}, ['x', 'base'],\n            arguments, {base: _b_.None}, null, null),\n            x = $.x,\n            base = $.base\n\n         var x1 = float_check(x)\n         if(base === _b_.None){return _b_.float.$factory(Math.log(x1))}\n         return _b_.float.$factory(Math.log(x1) / Math.log(float_check(base)))\n    },\n    log1p: function(x){\n        $B.check_nb_args('log1p', 1, arguments)\n        $B.check_no_kw('log1p', x)\n        return _b_.float.$factory(Math.log1p(float_check(x)))\n    },\n    log2: function(x){\n        $B.check_nb_args('log2', 1, arguments)\n        $B.check_no_kw('log2', x)\n\n        if(isNaN(x)){return _b_.float.$factory('nan')}\n        if(_b_.$isninf(x)) {throw _b_.ValueError.$factory('')}\n        var x1 = float_check(x)\n        if(x1 < 0.0){throw _b_.ValueError.$factory('')}\n        return _b_.float.$factory(Math.log(x1) / Math.LN2)\n    },\n    log10: function(x){\n        $B.check_nb_args('log10', 1, arguments)\n        $B.check_no_kw('log10', x)\n\n        return _b_.float.$factory(Math.log10(float_check(x)))\n    },\n    modf: function(x){\n        $B.check_nb_args('modf', 1, arguments)\n        $B.check_no_kw('modf', x)\n\n       if(_b_.$isninf(x)){\n           return _b_.tuple.$factory([0.0, _b_.float.$factory('-inf')])\n       }\n       if(_b_.$isinf(x)){\n           return _b_.tuple.$factory([0.0, _b_.float.$factory('inf')])\n       }\n       if(isNaN(x)){\n           return _b_.tuple.$factory([_b_.float.$factory('nan'),\n               _b_.float.$factory('nan')])\n       }\n\n       var x1 = float_check(x)\n       if(x1 > 0){\n          var i = _b_.float.$factory(x1 - Math.floor(x1))\n          return _b_.tuple.$factory([i, _b_.float.$factory(x1 - i)])\n       }\n\n       var x2 = Math.ceil(x1)\n       var i = _b_.float.$factory(x1 - x2)\n       return _b_.tuple.$factory([i, _b_.float.$factory(x2)])\n    },\n    nan: _b_.float.$factory('nan'),\n    nextafter: function(){\n        var $ = $B.args(\"nextafter\", 2, {x: null, y: null}, ['x', 'y'],\n                    arguments, {}, null, null),\n            x = $.x,\n            y = $.y\n        return y < x ? -nextUp(-x) : (y > x ? nextUp(x) : (x !== x ? x : y))\n    },\n    perm: function(n, k){\n        var $ = $B.args(\"perm\", 2, {n: null, k: null}, ['n', 'k'],\n                        arguments, {k: _b_.None}, null, null),\n            n = $.n,\n            k = $.k\n\n        if(k === _b_.None){\n            check_int(n)\n            return _mod.factorial(n)\n        }\n        // raise TypeError if n or k is not an integer\n        check_int(n)\n        check_int(k)\n\n        if(k < 0){\n            throw _b_.ValueError.$factory(\"k must be a non-negative integer\")\n        }\n        if(n < 0){\n            throw _b_.ValueError.$factory(\"n must be a non-negative integer\")\n        }\n\n        if(k > n){\n            return 0\n        }\n        // Evaluates to n! / (n - k)!\n        var fn = _mod.factorial(n),\n            fn_k = _mod.factorial(n - k)\n        return $B.floordiv(fn, fn_k)\n    },\n    pi : _b_.float.$factory(Math.PI),\n    pow: function(){\n        var $ = $B.args(\"pow\", 2, {base: null, exp: null}, ['base', 'exp'],\n                    arguments, {}, null, null),\n            x = $.base,\n            y = $.exp\n\n        var x1 = float_check(x)\n        var y1 = float_check(y)\n        if(y1 == 0){return _b_.float.$factory(1)}\n        if(x1 == 0 && y1 < 0){throw _b_.ValueError.$factory('')}\n\n        if(isNaN(y1)){\n            if(x1 == 1){return _b_.float.$factory(1)}\n            return _b_.float.$factory('nan')\n        }\n        if(x1 == 0){return _b_.float.$factory(0)}\n\n        if(_b_.$isninf(y)){\n            if(x1 == 1 || x1 == -1){return _b_.float.$factory(1)}\n            if(x1 < 1 && x1 > -1){return _b_.float.$factory('inf')}\n            return _b_.float.$factory(0)\n        }\n        if(_b_.$isinf(y)){\n            if(x1 == 1 || x1 == -1){return _b_.float.$factory(1)}\n            if(x1 < 1 && x1 > -1){return _b_.float.$factory(0)}\n            return _b_.float.$factory('inf')\n        }\n\n        if(isNaN(x1)){return _b_.float.$factory('nan')}\n        if(_b_.$isninf(x)){\n            if(y1 > 0 && isOdd(y1)){return _b_.float.$factory('-inf')}\n            if(y1 > 0){return _b_.float.$factory('inf')}  // this is even or a float\n            if(y1 < 0){return _b_.float.$factory(0)}\n            return _b_.float.$factory(1)\n        }\n\n        if(_b_.$isinf(x)){\n            if(y1 > 0){return _b_.float.$factory('inf')}\n            if(y1 < 0){return _b_.float.$factory(0)}\n            return _b_.float.$factory(1)\n        }\n\n        var r = Math.pow(x1, y1)\n        if(isNaN(r)){return _b_.float.$factory('nan')}\n        if(_b_.$isninf(r)){return _b_.float.$factory('-inf')}\n        if(_b_.$isinf(r)){return _b_.float.$factory('inf')}\n\n        return _b_.float.$factory(r)\n    },\n    prod: function(){\n        var $ = $B.args(\"prod\", 1, {iterable:null, start:null},\n                        [\"iterable\", \"start\"], arguments, {start: 1}, \"*\",\n                        null),\n            iterable = $.iterable,\n            start = $.start\n        var res = start,\n            it = _b_.iter(iterable),\n            x\n        while(true){\n            try{\n                x = _b_.next(it)\n                if(x == 0){\n                    return 0\n                }\n                res = $B.mul(res, x)\n            }catch(err){\n                if(err.__class__ === _b_.StopIteration){\n                    return res\n                }\n                throw err\n            }\n        }\n    },\n    radians: function(x){\n        $B.check_nb_args('radians', 1, arguments)\n        $B.check_no_kw('radians', x)\n\n        return _b_.float.$factory(float_check(x) * Math.PI / 180)\n    },\n    remainder: function(x, y){\n        $B.check_nb_args('remainder', 2, arguments)\n        $B.check_no_kw('remainder', x, y)\n        if(_mod.isnan(x) || _mod.isnan(y)){\n            return _mod.nan\n        }\n        if(_b_.$isinf(x) || y == 0){\n            throw _b_.ValueError.$factory(\"math domain error\")\n        }\n        x = float_check(x)\n        y = float_check(y)\n        var quotient = x / y,\n            rounded = _b_.round(quotient)\n        if(rounded == 0){\n            return _b_.float.$factory(x)\n        }\n        var res = _b_.float.$factory(x - rounded * y)\n        if(_b_.$isinf(res)){\n            // happens if rounded * y is infinite\n            res = _b_.float.$factory(rounded * (x / rounded - y))\n        }\n        return res\n    },\n    sin : function(x){\n        $B.check_nb_args('sin ', 1, arguments)\n        $B.check_no_kw('sin ', x)\n        return _b_.float.$factory(Math.sin(float_check(x)))},\n    sinh: function(x) {\n        $B.check_nb_args('sinh', 1, arguments)\n        $B.check_no_kw('sinh', x)\n\n        var y = float_check(x)\n        if(Math.sinh !== undefined){return _b_.float.$factory(Math.sinh(y))}\n        return _b_.float.$factory(\n            (Math.pow(Math.E, y) - Math.pow(Math.E, -y)) / 2)\n    },\n    sqrt: function(x){\n        $B.check_nb_args('sqrt ', 1, arguments)\n        $B.check_no_kw('sqrt ', x)\n\n      var y = float_check(x)\n      if(y < 0){throw _b_.ValueError.$factory(\"math range error\")}\n      if(_b_.$isinf(y)){return _b_.float.$factory('inf')}\n      var _r = Math.sqrt(y)\n      if(_b_.$isinf(_r)){throw _b_.OverflowError.$factory(\"math range error\")}\n      return _b_.float.$factory(_r)\n    },\n    tan: function(x) {\n        $B.check_nb_args('tan', 1, arguments)\n        $B.check_no_kw('tan', x)\n\n        var y = float_check(x)\n        return _b_.float.$factory(Math.tan(y))\n    },\n    tanh: function(x) {\n        $B.check_nb_args('tanh', 1, arguments)\n        $B.check_no_kw('tanh', x)\n\n        var y = float_check(x)\n        if(Math.tanh !== undefined){return _b_.float.$factory(Math.tanh(y))}\n        return _b_.float.$factory((Math.pow(Math.E, y) - Math.pow(Math.E, -y))/\n             (Math.pow(Math.E, y) + Math.pow(Math.E, -y)))\n    },\n    tau: 6.283185307179586,\n    trunc: function(x) {\n        $B.check_nb_args('trunc', 1, arguments)\n        $B.check_no_kw('trunc', x)\n\n       try{return $B.$getattr(x, '__trunc__')()}catch(err){}\n       var x1 = float_check(x)\n       if(!isNaN(parseFloat(x1)) && isFinite(x1)){\n          if(Math.trunc !== undefined){return _b_.int.$factory(Math.trunc(x1))}\n          if(x1 > 0){return _b_.int.$factory(Math.floor(x1))}\n          return _b_.int.$factory(Math.ceil(x1))  // x1 < 0\n       }\n       throw _b_.ValueError.$factory(\n           'object is not a number and does not contain __trunc__')\n    },\n    ulp: function(){\n        var $ = $B.args(\"ulp\", 1, {x: null}, ['x'], arguments, {}, null, null),\n            x = $.x\n        if(x == MAX_VALUE){\n            return MAX_VALUE - _mod.nextafter(MAX_VALUE, 0)\n        }else if(_b_.$isinf(x)){\n            return _mod.inf\n        }\n        if(typeof x == \"number\" || x instanceof Number){\n            return x > 0 ? nextUp(x) - x : x - (-nextUp(-x))\n        }else{\n            if($B.rich_comp('__gt__', x, 0)){\n                return $B.rich_op('sub', nextUp(x), x)\n            }else{\n                var neg_x = $B.$call($B.$getattr(x, \"__neg__\"))()\n                return $B.rich_op('sub', x,\n                    $B.$call($B.$getattr(nextUp(neg_x), '__neg__'))())\n            }\n        }\n    }\n}\n\nfor(var $attr in _mod){\n    if(typeof _mod[$attr] === 'function'){\n        _mod[$attr].__class__ = $B.builtin_function\n    }\n}\n\nreturn _mod\n\n})(__BRYTHON__)\n"], "modulefinder": [".js", "var $module=(function($B){\n\nvar _b_=$B.builtins\nvar _mod = {}\n\n$ModuleFinderDict = {__class__:_b_.type,__name__:'ModuleFinder'}\n$ModuleFinderDict.__mro__ = [_b_.object]\n\n$ModuleFinderDict.run_script = function(self, pathname){\n    // pathname is the url of a Python script\n    var py_src = _b_.$open(pathname).read()\n    // transform into internal Brython tree structure\n    var root = $B.py2js(py_src)\n    // walk the tree to find occurences of imports\n    function walk(node){\n        var modules = []\n        var ctx = node.context\n        if(ctx && ctx.type=='node'){ctx = ctx.tree[0]}\n\n        if(ctx && ctx.type==\"import\"){\n            for(var i=0, _len_i = ctx.tree.length; i < _len_i;i++){\n                if(modules.indexOf(ctx.tree[i].name)==-1){\n                    modules.push(ctx.tree[i].name)\n                }\n            }\n        }else if(ctx && ctx.type==\"from\"){\n            if(modules.indexOf(ctx.module)==-1){\n                modules.push(ctx.module)\n            }\n        }\n        \n        for(var i=0, _len_i = node.children.length; i < _len_i;i++){\n            mods = walk(node.children[i])\n            for(var j=0, _len_j = mods.length; j < _len_j;j++){\n                if(modules.indexOf(mods[j])==-1){modules.push(mods[j])}\n            }\n        }\n        return modules\n    }\n    self.modules = walk(root)\n}\n\n_mod.ModuleFinder = function(){return {__class__:$ModuleFinderDict}\n}\n_mod.ModuleFinder.$dict = $ModuleFinderDict\n_mod.ModuleFinder.__class__ = $B.$factory\n$ModuleFinderDict.$factory = _mod.ModuleFinder\n\nreturn _mod\n})(__BRYTHON__)\n"], "posix": [".js", "/*\nThis module provides access to operating system functionality that is\nstandardized by the C Standard and the POSIX standard (a thinly\ndisguised Unix interface).  Refer to the library manual and\ncorresponding Unix manual entries for more information on calls.\n*/\n\nvar $B = __BRYTHON__,\n    _b_ = $B.builtins\n\nfunction _randint(a, b){\n    return parseInt(Math.random() * (b - a + 1) + a)\n}\n\nvar stat_result = $B.make_class(\"stat_result\",\n    function(filename){\n        // Use $B.files, created by \"python -m brython --make_file_system\"\n        if($B.files && $B.files.hasOwnProperty(filename)){\n            var f = $B.files[filename],\n                res = {\n                    __class__: stat_result,\n                    st_atime: new Date().getTime(),\n                    st_ctime: f.ctime,\n                    st_mtime: f.mtime,\n                    st_uid: -1,\n                    st_gid: -1,\n                    st_ino: -1,\n                    st_mode: 0,\n                    st_size: 1\n                };\n            [\"atime\", \"mtime\", \"ctime\"].\n                forEach(function(item){\n                    res[\"st_\" + item + \"_ns\"] = res[\"st_\" + item] *\n                        1000000\n                });\n        }else{\n            var res = {\n                __class__: stat_result,\n                st_atime: new Date(),\n                st_uid: -1,\n                st_gid: -1,\n                st_ino: -1,\n                st_mode: 0,\n                st_size: 1\n            };\n            [\"mtime\", \"ctime\", \"atime_ns\", \"mtime_ns\", \"ctime_ns\"].\n                forEach(function(item){\n                    res[\"st_\" + item] = res.st_atime\n                });\n        }\n        return res\n    }\n)\n$B.set_func_names(stat_result, \"posix\")\n\nvar $module = {\n    F_OK: 0,\n    O_APPEND: 8,\n    O_BINARY: 32768,\n    O_CREAT: 256,\n    O_EXCL: 1024,\n    O_NOINHERIT: 128,\n    O_RANDOM: 16,\n    O_RDONLY: 0,\n    O_RDWR: 2,\n    O_SEQUENTIAL: 32,\n    O_SHORT_LIVED: 4096,\n    O_TEMPORARY: 64,\n    O_TEXT: 16384,\n    O_TRUNC: 512,\n    O_WRONLY: 1,\n    P_DETACH: 4,\n    P_NOWAIT: 1,\n    P_NOWAITO: 3,\n    P_OVERLAY: 2,\n    P_WAIT: 0,\n    R_OK: 4,\n    TMP_MAX: 32767,\n    W_OK: 2,\n    X_OK: 1,\n    _have_functions: ['MS_WINDOWS'],\n    environ: _b_.dict.$factory(\n        [['PYTHONPATH', $B.brython_path],\n         ['PYTHONUSERBASE', ' ']]),\n    error: _b_.OSError,\n    fspath: function(path){\n        return path\n    },\n    getcwd: function(){return $B.brython_path},\n    getpid: function(){return 0},\n    lstat: function(){return stat_result.$factory()},\n    open: function(path, flags){return _b_.open(path, flags)},\n    stat: function(filename){return stat_result.$factory(filename)},\n    stat_result: function(filename){return stat_result.$factory(filename)},\n    urandom: function(n){\n        var randbytes = []\n        for(var i = 0; i < n; i++){\n            randbytes.push(_randint(0, 255))\n        }\n        return _b_.bytes.$factory(randbytes)\n    },\n    WTERMSIG: function(){return 0},\n    WNOHANG: function(){return _b_.tuple.$factory([0, 0])}\n};\n\n[\"WCOREDUMP\", \"WIFCONTINUED\", \"WIFSTOPPED\", \"WIFSIGNALED\", \"WIFEXITED\"].forEach(function(funcname){\n        $module[funcname] = function(){return false}\n    });\n\n[\"WEXITSTATUS\", \"WSTOPSIG\", \"WTERMSIG\"].\n    forEach(function(funcname){\n        $module[funcname] = function(){return _b_.None}\n    });\n\n[\"_exit\", \"_getdiskusage\", \"_getfileinformation\", \"_getfinalpathname\",\n    \"_getfullpathname\", \"_isdir\", \"abort\", \"access\", \"chdir\", \"chmod\",\n    \"close\", \"closerange\", \"device_encoding\", \"dup\", \"dup2\",\n    \"execv\", \"execve\", \"fsat\", \"fsync\", \"get_terminal_size\", \"getcwdb\",\n    \"getlogin\", \"getppid\", \"isatty\", \"kill\", \"link\", \"listdir\", \"lseek\",\n    \"mkdir\", \"pipe\", \"putenv\", \"read\", \"readlink\", \"remove\", \"rename\",\n    \"replace\", \"rmdir\", \"spawnv\", \"spawnve\", \"startfile\", \"stat_float_times\",\n    \"statvfs_result\", \"strerror\", \"symlink\", \"system\", \"terminal_size\",\n    \"times\", \"times_result\", \"umask\", \"uname_result\", \"unlink\", \"utime\",\n    \"waitpid\", \"write\"].forEach(function(funcname){\n        $module[funcname] = function(){\n            throw _b_.NotImplementedError.$factory(\"posix.\" + funcname +\n                \" is not implemented\")\n        }\n    });\n"], "python_re": [".js", "// Regular expression\n\nvar $B = __BRYTHON__,\n    _b_ = $B.builtins\n\nvar MAXGROUPS = 2147483647,\n    MAXREPEAT = 2147483648\n\nvar is_word = {}\nvar word_gcs = ['Ll', 'Lu', 'Lm', 'Lt', 'Lo',\n                'Nd',\n                'Mc', 'Me', 'Mn',\n                'Pc']\nfor(var word_gc of word_gcs){\n    for(var cp in $B.unicode_tables[word_gc]){\n        is_word[cp] = true\n    }\n}\n\nvar is_ascii_word = {}\n\nfor(var cp = 0; cp <= 127; cp++){\n    if(is_word[cp]){\n        is_ascii_word[cp] = true\n    }\n}\n\nvar is_digit = {}\n\nfor(var cp in $B.unicode_tables['Nd']){\n    is_digit[cp] = true\n}\n\nvar is_ascii_digit = {}\n\nfor(var cp = 0; cp <= 127; cp++){\n    if(is_digit[cp]){\n        is_ascii_digit[cp] = true\n    }\n}\n\nvar $error_2 = {\n    $name: \"error\",\n    $qualname: \"error\",\n    $is_class: true,\n    __module__: \"re\"\n}\n\nvar error = $B.$class_constructor(\"error\", $error_2,\n    _b_.tuple.$factory([_b_.Exception]),[\"_b_.Exception\"],[])\nerror.__doc__ = _b_.None\nerror.$factory = $B.$instance_creator(error)\nerror.__str__ = function(self){\n    var s = self.msg + ' at position ' + self.pos\n    if(self.lineno > 1){\n        s += ` (line ${self.lineno}, column ${self.colno})`\n    }\n    return s\n}\n\n$B.set_func_names(error, \"re\")\n\nfunction $last(t){\n    return t[t.length - 1]\n}\n\nfunction fail(message, pos, pattern){\n    var err = error.$factory(message)\n    err.msg = message\n    err.pos = pos\n    if(pattern){\n        err.pattern = pattern.py_obj // Python object passed to compile()\n        err.lineno = 1\n        var linestart = 0\n        for(var i = 0, len = pattern.string.length; i < pos; i++){\n            if(pattern.string[i] == '\\n'){\n                err.lineno++\n                linestart = i + 1\n            }\n        }\n        err.colno = pos - linestart + 1\n    }\n    throw err\n}\n\nfunction warn(klass, message, pos){\n    var warning = klass.$factory(message)\n    warning.pos = pos\n    // module _warning is in builtin_modules.js\n    $B.imported._warnings.warn(warning)\n}\n\nvar Flag = $B.make_class(\"Flag\",\n    function(value){\n        return {\n            __class__: Flag,\n            value\n        }\n    }\n)\n\nFlag.__index__ = function(self){\n    return self.value\n}\n\nFlag.__invert__ = function(self){\n    return Flag.$factory(~self.value)\n}\n\nFlag.__eq__ = function(self, other){\n    return self.value == other.value\n}\n\nFlag.__or__ = function(self, other){\n    if(other.__class__ === Flag){\n        return Flag.$factory(self.value | other.value)\n    }else if(typeof other == \"number\"){\n        return Flag.$factory(self.value | other)\n    }\n    return _b_.NotImplemented\n}\n\nFlag.__ror__ = function(self, other){\n    if(typeof other == \"number\" || _b_.isinstance(other, _b_.int)){\n        if(other == 0){\n            return Flag.$factory(self.value)\n        }\n        return Flag.$factory(self.value | other)\n    }\n    return _b_.NotImplemented\n}\n\nFlag.__repr__ = Flag.__str__ = function(self){\n    if(self.value == 0){\n        return \"re.none\"\n    }\n    var inverted = self.value < 0\n\n    var t = [],\n        value = inverted ? ~self.value : self.value\n    for(var flag in inline_flags){\n        if(value & inline_flags[flag].value){\n            t.push('re.' + flag_names[flag])\n            value &= ~inline_flags[flag].value\n        }\n    }\n    if(value > 0){\n        t.push('0x' + value.toString(16))\n    }\n    var res = t.join('|')\n    if(inverted){\n        if(t.length > 1){\n            return '~(' + res + ')'\n        }else{\n            return '~' + res\n        }\n    }\n    return res\n}\n\nFlag.__xor__ = function(self, other){\n    return Flag.$factory(self.value ^ other.value)\n}\n\n$B.set_func_names(Flag, \"re\")\n\nvar no_flag = {}\n\nvar Scanner = $B.make_class(\"Scanner\",\n    function(pattern, string){\n        return {\n            __class__: Scanner,\n            $string: string,\n            pattern\n        }\n    }\n)\n\nScanner.match = function(self){\n    return BPattern.match(self.pattern, self.$string)\n}\n\nScanner.search = function(self){\n    if(! self.$iterator){\n        self.$iterator = $module.finditer(self.pattern, self.$string)\n    }\n    try{\n        var nxt = _b_.next(self.$iterator)\n    }catch(err){\n        if($B.is_exc(err, [_b_.StopIteration])){\n            return _b_.None\n        }\n        throw err\n    }\n    return nxt\n}\n\nvar BPattern = $B.make_class(\"Pattern\",\n    function(pattern){\n        var nb_groups = 0\n        for(var key in pattern.groups){\n            if(isFinite(key)){\n                nb_groups++\n            }\n        }\n        return {\n            __class__: BPattern,\n            pattern: pattern.text,\n            groups: nb_groups,\n            flags: pattern.flags,\n            $groups: pattern.groups,\n            $pattern: pattern\n        }\n    }\n)\n\nBPattern.__eq__ = function(self, other){\n    if(other.$pattern && self.$pattern.type != other.$pattern.$type){\n        // warn(_b_.BytesWarning, \"cannot compare str and bytes pattern\", 1)\n    }\n    return self.pattern == other.pattern &&\n        self.flags.value == other.flags.value\n}\n\nBPattern.__hash__ = function(self){\n    // best effort ;-)\n    return _b_.hash(self.pattern) + self.flags.value\n}\n\nBPattern.__repr__ = BPattern.__str__ = function(self){\n    var text = self.$pattern.text,\n        s = text\n    if(self.$pattern.type == \"bytes\"){\n        s = _b_.str.$factory(_b_.str.encode(s, 'latin-1'))\n    }else{\n        s = _b_.repr(s)\n    }\n    s = s.substr(0, 200)\n    var res = `re.compile(${s}`,\n        flags = self.$pattern.flags\n    if(flags === no_flag){\n        return res + ')'\n    }\n    // mask UNICODE flag\n    if(flags.__class__ === Flag){\n        // copy flag, otherwise U.value would become 0\n        flags = Flag.$factory(flags.value)\n        flags.value &= ~U.value\n    }else if(typeof flags == \"number\"){\n        flags &= ~U.value\n    }\n    if(flags != 0 && flags.value != 0){\n        res += `, ${_b_.str.$factory(flags)}`\n    }\n    return res + ')'\n}\n\nBPattern.findall = function(self){\n    var iter = BPattern.finditer.apply(null, arguments).js_gen,\n        res = []\n\n    while(true){\n        var next = iter.next()\n        if(next.done){\n            return res\n        }\n        var bmo = next.value,\n            mo = bmo.mo,\n            groups = BMO.groups(bmo)\n\n        // replace None by the empty string\n        for(var i = 0, len = groups.length; i < len; i++){\n            groups[i] = groups[i] === _b_.None ? \"\" : groups[i]\n        }\n        if(groups.length > 0){\n            if(groups.length == 1){\n                res.push(groups[0])\n            }else{\n                res.push($B.fast_tuple(groups))\n            }\n        }else{\n            res.push(mo.string.substring(mo.start, mo.end))\n        }\n    }\n}\n\nBPattern.finditer = function(self){\n    var $ = $B.args(\"finditer\", 4,\n            {self: null, string: null, pos: null, endpos: null},\n            'self string pos endpos'.split(' '), arguments,\n            {pos: 0, endpos: _b_.None}, null, null)\n    var original_string = $.string,\n        data = prepare({string: $.string})\n    var endpos = $.endpos === _b_.None ? data.string.length : $.endpos\n    return $B.generator.$factory(iterator)(self.$pattern, data.string,\n            no_flag, $.string, $.pos, endpos)\n}\n\nBPattern.fullmatch = function(self, string){\n    var $ = $B.args(\"match\", 4,\n                    {self: null, string: null, pos: null, endpos: null},\n                    [\"self\", \"string\", \"pos\", \"endpos\"], arguments,\n                    {pos: 0, endpos: _b_.None}, null, null)\n    if($.endpos === _b_.None){\n        $.endpos = $.string.length\n    }\n    var data = prepare({string: $.string})\n    if(self.$pattern.type != data.string.type){\n        throw _b_.TypeError.$factory(\"not the same type for pattern \" +\n            \"and string\")\n    }\n    var mo = match($.self.$pattern, data.string, $.pos, $.endpos)\n    if(mo && mo.end - mo.start == $.endpos - $.pos){\n        return BMO.$factory(mo)\n    }else{\n        return _b_.None\n    }\n}\nvar GroupIndex = $B.make_class(\"GroupIndex\",\n    function(self, _default){\n        var res = $B.empty_dict()\n        res.__class__ = GroupIndex\n        for(var key in self.$groups){\n            if(isNaN(parseInt(key))){\n                res.$string_dict[key] = [self.$groups[key].num,\n                    res.$version++]\n            }\n        }\n        return res\n    }\n)\nGroupIndex.__mro__ = [_b_.dict, _b_.object]\nGroupIndex.__setitem__ = function(){\n    throw _b_.TypeError.$factory(\"read only\")\n}\n\n$B.set_func_names(GroupIndex, \"re\")\n\nBPattern.groupindex = {\n    __get__: function(self){\n        return GroupIndex.$factory(self)\n    }\n}\n\nBPattern.match = function(self, string){\n    var $ = $B.args(\"match\", 4,\n                    {self: null, string: null, pos: null, endpos: null},\n                    [\"self\", \"string\", \"pos\", \"endpos\"], arguments,\n                    {pos: 0, endpos: _b_.None}, null, null)\n    if($.endpos === _b_.None){\n        $.endpos = $.string.length\n    }\n    var data = prepare({string: $.string})\n    if(self.$pattern.type != data.string.type){\n        throw _b_.TypeError.$factory(\"not the same type for pattern \" +\n            \"and string\")\n    }\n    var mo = match($.self.$pattern, data.string, $.pos,\n        $.endpos)\n    return mo ? BMO.$factory(mo) : _b_.None\n}\n\nBPattern.scanner = function(self, string){\n    return Scanner.$factory(self, string)\n}\n\nBPattern.search = function(self, string){\n    var $ = $B.args(\"match\", 4,\n                    {self: null, string: null, pos: null, endpos: null},\n                    [\"self\", \"string\", \"pos\", \"endpos\"], arguments,\n                    {pos: 0, endpos: _b_.None}, null, null)\n    if($.endpos === _b_.None){\n        $.endpos = $.string.length\n    }\n    var data = prepare({string: $.string})\n    if(self.$pattern.type != data.string.type){\n        throw _b_.TypeError.$factory(\"not the same type for pattern \" +\n            \"and string\")\n    }\n    var pos = $.pos\n    while(pos < $.endpos){\n        var mo = match(self.$pattern, data.string, pos)\n        if(mo){\n            return BMO.$factory(mo)\n        }else{\n            pos++\n        }\n    }\n    return _b_.None\n}\n\nBPattern.split = function(){\n    return $module.split.apply(null, arguments)\n}\n\nBPattern.sub = function(){\n    var $ = $B.args(\"match\", 4,\n                    {self: null, repl: null, string: null, count: null},\n                    \"self repl string count\".split(' '), arguments,\n                    {count: 0}, null, null)\n    var data = prepare({string: $.string})\n    if($.self.$pattern.type != data.string.type){\n        throw _b_.TypeError.$factory(\"not the same type for pattern \" +\n            \"and string\")\n    }\n\n    return $module.sub($.self, $.repl, $.string, $.count)\n}\n\n$B.set_func_names(BPattern, \"re\")\n\nfunction Node(parent){\n    this.parent = parent\n    this.items = []\n}\n\nNode.prototype.add = function(item){\n    this.items.push(item)\n    item.parent = this\n}\n\nNode.prototype.fixed_length = function(){\n    // Return the sum of items lengths if fixed, else undefined\n    if(this.repeat){\n        return false\n    }\n    var len = 0\n    for(var item of this.items){\n        if(item.fixed_length === undefined){\n            console.log(\"pas de fixed length\", item)\n            alert()\n        }\n        var sublen = item.fixed_length()\n        if(sublen === false){\n            return false\n        }\n        len += sublen\n    }\n    return len\n}\n\nfunction get_top(node){\n    var top = node.parent\n    while(top.parent){\n        top = top.parent\n    }\n    return top\n}\n\nvar BackReference = function(pos, type, value){\n    // for \"\\number\"\n    this.name = \"BackReference\"\n    this.pos = pos\n    this.type = type // \"name\" or \"num\"\n    this.value = value\n    this.groups = []\n}\n\nBackReference.prototype.fixed_length = function(){\n    // Return length of referenced group if it is fixed, else undefined\n    if(this.repeat){\n        return undefined\n    }\n    var group = this.get_group()\n    if(group.fixed_length === undefined){\n        console.log(\"group\", group, \"no fixed length\")\n        alert()\n    }\n    return group === undefined ? false : group.fixed_length()\n}\n\nBackReference.prototype.get_group = function(){\n    var top = get_top(this)\n    return top.$groups[this.value]\n}\n\nBackReference.prototype.match = function(string, pos, groups){\n    this.repeat = this.repeat || {min: 1, max: 1}\n\n    var group = groups[this.value]\n    if(group === undefined){\n        if(this.repeat.min == 0){\n            return {\n                nb_min: 0,\n                nb_max: 0\n            }\n        }\n        return false\n    }\n\n    // Get the codepoints matched by the referenced group\n    group_cps = string.codepoints.slice(group.start, group.end)\n\n    // search (repetitions of) the matched group codepoints\n    var _pos = pos,\n        nb = 0,\n        len = string.codepoints.length,\n        group_len = group_cps.length,\n        flag\n    while(_pos < len && nb < this.repeat.max){\n        flag = true\n        for(var i = 0; i < group_len; i++){\n            if(string.codepoints[_pos + i] != group_cps[i]){\n                flag = false\n                break\n            }\n        }\n        if(flag){\n            nb++\n            _pos += group_len\n        }else{\n            break\n        }\n    }\n    if(nb >= this.repeat.min){\n        // Returns the accepted minimum and maximum number of repeats\n        // and the length of each repeat\n        return {\n            nb_min: this.repeat.min,\n            nb_max: nb,\n            group_len\n        }\n    }\n    return false\n}\n\nBackReference.prototype.toString = function(){\n    return \"BackRef to group\" + this.value\n}\n\nvar Case = function(){\n    this.name = \"Case\"\n    this.items = []\n    this.groups = []\n    this.text = 'Case '\n}\n\nCase.prototype.add = function(item){\n    this.items.push(item)\n    item.parent = this\n    this.text += item.toString()\n}\n\nCase.prototype.fixed_length = function(){\n    var len\n    for(var item of this.items){\n        var fl = item.fixed_length()\n        if(fl === false){\n            return false\n        }else if(len === undefined){\n            len = fl\n        }else{\n            len += fl\n        }\n    }\n    return len\n}\n\nCase.prototype.toString = function(){\n    return 'Case ' + this.text\n}\n\nvar Choice = function(){\n    this.type = \"choice\"\n    this.items = []\n    this.groups = []\n}\n\nChoice.prototype.add = Node.prototype.add\n\nChoice.prototype.fixed_length = function(){\n    var len\n    for(var item of this.items){\n        var fl = item.fixed_length()\n        if(fl === false){\n            return false\n        }else if(len === undefined){\n            len = fl\n        }else if(len != fl){\n            return false\n        }\n     }\n     return len\n}\n\nfunction subgroups(item){\n    // Return all the subgroups below item\n    var groups = []\n    if(item.items){\n        for(var subitem of item.items){\n            if(subitem instanceof Group && subitem.num){\n                groups.push(subitem.num)\n                if(subitem.name){\n                    groups.push(subitem.name)\n                }\n            }\n            groups = groups.concat(subgroups(subitem))\n        }\n    }\n    return item.$subgroups = groups\n}\n\nChoice.prototype.toString = function(){\n    return 'Choice'\n}\n\nvar EmptyString = {\n        toString: function(){\n            return ''\n        },\n        match: function(string, pos){\n            return {nb_min: 0, nb_max: 0}\n        },\n        fixed_length: function(){\n            return 1\n        },\n        length: 0\n    },\n    Flags = function(flags){\n        this.flags = flags\n    },\n    GroupEnd = function(pos){\n        this.name = \"GroupEnd\"\n        this.pos = pos\n        this.text = ')'\n        this.toString = function(){\n            return '[end of group #' + this.group.num + ']'\n        }\n    },\n    Or = function(pos){\n        this.name = \"Or\"\n        this.pos = pos\n        this.text = '|'\n        this.toString = function(){\n            return '|'\n        }\n    },\n    Repeater = function(pos, op){\n        this.name = \"Repeater\"\n        this.pos = pos\n        this.op = op\n    }\n\nfunction cased_cps(cp, ignore_case, ascii){\n    // If cp is the codepoint of a cased Unicode character, return the list\n    // of the codepoints that match the character in a case-insensitive way\n\n    // ignore_case = this.flags && this.flags.value & IGNORECASE.value\n    // ascii = this.flags.value & ASCII.value\n    var cps,\n        char = $B.codepoint2jsstring(cp)\n    if(! ignore_case){\n        return [cp]\n    }\n    if(ascii){\n        // only test ASCII letters\n        ignore_case = ignore_case && (\n            (char >= 'a' && char <= 'z') ||\n            (char >= 'A' && char <= 'Z'))\n    }\n    if(ignore_case){\n        var char_up = char.toUpperCase(),\n            char_low = char.toLowerCase(),\n            cps = new Set([cp, $B.jsstring2codepoint(char_low),\n                $B.jsstring2codepoint(char_up)])\n        // special cases\n        if(char.toLowerCase() == \"k\"){\n            cps.add(0x212a) // Kelvin sign\n        }\n        if(cp == 0x212a){\n            cps.add(ord('k'))\n            cps.add(ord('K'))\n        }\n        if(char.toLowerCase() == \"s\"){\n            cps.add(0x017f) //  (Latin small letter long s)\n        }\n        if(cp == 0x017f){\n            cps.add(ord('s'))\n            cps.add(ord('S'))\n        }\n        if(char.toLowerCase() == 'i'){\n            cps.add(0x0130) //  (Latin capital letter I with dot above)\n            cps.add(0x0131) //  (Latin small letter dotless i)\n        }\n        if(cp == 0x0130 || cp == 0x0131){\n            cps.add(ord('i'))\n            cps.add(ord('I'))\n        }\n        return Array.from(cps)\n    }else{\n        cps = [cp]\n    }\n    return cps\n}\n\nvar Char = function(pos, cp, groups){\n    // character in a regular expression or in a character set\n    // pos : position of the character in the pattern string\n    // cp : the character's codepoint\n    // groups (optional) : the groups that contain the character\n    this.pos = pos\n    this.cp = cp\n    this.char = chr(this.cp)\n    this.text = this.char\n}\n\nChar.prototype.fixed_length = function(){\n    if(this.repeat){\n        return this.repeat.min\n    }\n    return this.char === EmptyString ? 0 : 1\n}\n\nChar.prototype.match = function(string, pos){\n    // Returns {pos1, pos2} such that \"this\" matches all the substrings\n    // string[pos:i] with pos1 <= i < pos2, or false if no match\n    this.repeat = this.repeat || {min: 1, max: 1}\n\n    var len = string.codepoints.length,\n        i = 0\n\n    // browse string codepoints until they don't match, or the number of\n    // matches is above the maximum allowed\n    if(this.flags){\n        if(this.flags.value & ASCII.value){\n            if(this.cp > 127){\n                return false\n            }\n        }\n        if(this.flags.value & IGNORECASE.value &&\n                (! this.is_bytes || this.cp <= 127)){\n            // Flag IGNORECASE set\n            // For bytes pattern, case insensitive matching only works\n            // for ASCII characters\n            var char_upper = this.char.toUpperCase(),\n                char_lower = this.char.toLowerCase()\n            while(i < this.repeat.max && pos + i < len){\n                var char = chr(string.codepoints[pos + i])\n                if(char.toUpperCase() != char_upper &&\n                        char.toLowerCase() != char_lower){\n                   break\n                }\n                i++\n            }\n        }else{\n            while(string.codepoints[pos + i] == this.cp &&\n                    i < this.repeat.max){\n                i++\n            }\n        }\n    }else{\n        while(string.codepoints[pos + i] == this.cp && i < this.repeat.max){\n            i++\n        }\n    }\n    var nb = i\n    if(nb >= this.repeat.min){\n        // Number of repeats ok\n        return {\n            nb_min: this.repeat.min,\n            nb_max: nb\n        }\n    }else{\n        return false\n    }\n}\n\nChar.prototype.toString = function(){\n    var res = 'Char ' + this.text\n    if(this.repeat !== undefined){\n        res += ' repeat {' + this.repeat.min + ',' + this.repeat.max + '}'\n        if(this.non_greedy){\n            res += '?'\n        }\n    }\n    return res\n}\n\nfunction CharSeq(chars){\n    // sequence of consecutive characters\n    this.chars = chars\n}\n\nCharSeq.prototype.fixed_length = function(){\n    var len = 0\n    for(var char of this.chars){\n        len += char.fixed_length()\n    }\n    return len\n}\n\nCharSeq.prototype.match = function(string, pos){\n    var mos = [],\n        i = 0,\n        backtrack,\n        nb\n    for(var i = 0, len = this.chars.length; i < len; i++){\n        var char =  this.chars[i],\n            mo = char.match(string, pos) // form {nb_min, nb_max}\n        if(mo){\n            nb = char.non_greedy ? mo.nb_min : mo.nb_max\n            mos.push({nb,\n                      nb_min: mo.nb_min,\n                      nb_max: mo.nb_max,\n                      non_greedy: !!char.non_greedy\n                     })\n            pos += nb\n        }else{\n            // backtrack\n            backtrack = false\n            while(mos.length > 0){\n                i--\n                mo = mos.pop()\n                pos -= mo.nb\n                if(mo.non_greedy && nb + 1 < mo.nb_max){\n                    nb += 1\n                    backtrack = true\n                }else if(! mo.non_greedy && nb - 1 >= mo.nb_min){\n                    nb -= 1\n                    backtrack = true\n                }\n                if(backtrack){\n                    pos += nb\n                    mo.nb = nb\n                    mos.push(mo)\n                    i++\n                    break\n                }\n            }\n            if(mos.length == 0){\n                return false\n            }\n        }\n    }\n    var match_len = 0\n    for(var mo of mos){\n        match_len += mo.nb\n    }\n    return {\n        nb_min: match_len,\n        nb_max: match_len\n    }\n}\n\n\n\n\nCharSeq.prototype.toString = function(){\n    var res = ''\n    for(var char of this.chars){\n        res += char.text\n    }\n    return 'CharSeq ' + res\n}\n\nfunction CharacterClass(pos, cp, length, groups){\n    this.cp = cp\n    this.value = chr(cp)\n    this.length = length\n    this.pos = pos\n\n    var flags = this.flags\n\n    // Test function : test(string, pos) returns:\n    // - true if \"this\" matches 1 character string[pos]\n    // - [true, 0] if \"this\" matches the empty string at pos\n    // - false or undefined if \"this\" doesn't match\n    switch(this.value){\n        case 'A':\n            this.test_func = function(string, pos){\n                if(pos == 0){\n                    return [true, 0]\n                }\n            }\n            break\n        case 's':\n            this.test_func = function(string, pos){\n                var cp = string.codepoints[pos]\n                return $B.unicode_tables.Zs[cp] !== undefined ||\n                    $B.unicode_bidi_whitespace.indexOf(cp) > -1\n            }\n            break\n        case 'S':\n            this.test_func = function(string, pos){\n                var cp = string.codepoints[pos]\n                return cp !== undefined &&\n                    $B.unicode_tables.Zs[cp] === undefined &&\n                    $B.unicode_bidi_whitespace.indexOf(cp) == -1\n            }\n            break\n        case '.':\n            this.test_func = function(string, pos){\n                if(string.codepoints[pos] === undefined){\n                    return false\n                }\n                if(this.flags.value & DOTALL.value){\n                    return true\n                }else{\n                    return string.codepoints[pos] != 10\n                }\n            }\n            break\n        case 'd':\n            this.test_func = function(string, pos){\n                if(this.flags === undefined){\n                    console.log(\"\\\\d, no flags\", this)\n                }\n                var cp = string.codepoints[pos],\n                    table = (this.flags.value & ASCII.value) ?\n                        is_ascii_digit : is_digit\n                return table[cp]\n            }\n            break\n        case 'D':\n            this.test_func = function(string, pos){\n                var cp = string.codepoints[pos],\n                    table = (this.flags.value & ASCII.value) ?\n                        is_ascii_digit : is_digit\n                return ! table[cp]\n            }\n            break\n        case 'b':\n            this.test_func = function(string, pos){\n                var table = is_word\n                if(this.is_bytes || (this.flags.value & ASCII.value)){\n                    table = is_ascii_word\n                }\n                var cp = string.codepoints[pos],\n                    len = string.codepoints.length,\n                    ok = {nb_min: 0, nb_max: 0}\n\n                // return true if char at pos is at the beginning or start\n                // of a word\n                if(pos == 0 && table[cp]){\n                    return ok\n                }\n                if(pos == len && table[string.codepoints[pos - 1]]){\n                    return ok\n                }\n                if(pos > 0 && pos < len){\n                    if((table[string.codepoints[pos - 1]]) !==\n                            table[cp]){\n                        return ok\n                    }\n                }\n                return false\n            }\n            break\n        case 'B':\n            this.test_func = function(string, pos){\n                var table = is_word\n                if(this.is_bytes || (this.flags.value & ASCII.value)){\n                    table = is_ascii_word\n                }\n\n                var cp = string.codepoints[pos],\n                    len = string.codepoints.length,\n                    ok = {nb_min: 0, nb_max: 0}\n                // test is true if char at pos is not at the beginning or\n                // start of a word\n                if(pos == 0 && table[cp]){\n                    return false\n                }\n                if(pos == len && table[string.codepoints[pos - 1]]){\n                    return false\n                }\n                if(pos > 0 && pos < len){\n                    if((table[string.codepoints[pos - 1]]) !==\n                            table[cp]){\n                        return false\n                    }\n                }\n                return ok\n            }\n            break\n        case 'w':\n            this.test_func = function(string, pos){\n                var table = is_word\n                if(this.is_bytes || (this.flags.value & ASCII.value)){\n                    table = is_ascii_word\n                }\n                return table[string.codepoints[pos]]\n            }\n            break\n        case 'W':\n            this.test_func = function(string, pos){\n                var table = is_word\n                if(this.is_bytes || (this.flags.value & ASCII.value)){\n                    table = is_ascii_word\n                }\n                return ! table[string.codepoints[pos]]\n            }\n            break\n        case 'Z':\n            this.test_func = function(string, pos){\n                if(pos >= string.codepoints.length){\n                    return {nb_min: 0, nb_max: 0}\n                }\n            }\n            break\n    }\n}\n\nCharacterClass.prototype.fixed_length = function(){\n    return 1\n}\n\nCharacterClass.prototype.match = function(string, pos){\n    // Returns {pos1, pos2} such that \"this\" matches all the substrings\n    // string[pos:i] with pos1 <= i < pos2, or false if no match\n    this.repeat = this.repeat || {min: 1, max: 1}\n    var len = string.codepoints.length,\n        i = 0\n\n    // browse string codepoints until they don't match, or the number of\n    // matches is above the maximum allowed\n    while(pos + i <= len &&\n            this.test_func(string, pos + i, this.flags) &&\n            i < this.repeat.max){\n        i++\n    }\n    var nb = i\n    if(nb >= this.repeat.min){\n        // Number of repeats ok\n        if('bBAZ'.indexOf(this.value) > -1 ){\n            return {nb_min: 0, nb_max: 0}\n        }\n        return {\n            nb_min: this.repeat.min,\n            nb_max: nb\n        }\n    }else{\n        return false\n    }\n}\n\nCharacterClass.prototype.nb_repeats = Char.prototype.nb_repeats\n\nCharacterClass.prototype.toString = function(){\n    return '\\\\' + this.value\n}\n\nvar CharacterSet = function(pos, set, groups){\n    // character set\n    this.pos = pos\n    this.set = set\n    this.neg = set.neg\n}\n\nCharacterSet.prototype.fixed_length = function(){\n    return 1\n}\n\nCharacterSet.prototype.match = function(string, pos){\n    var ignore_case = this.flags && (this.flags.value & IGNORECASE.value),\n        test,\n        match = false,\n        len = string.codepoints.length,\n        i = 0,\n        cp\n\n    this.repeat = this.repeat || {min: 1, max: 1}\n\n    while(i < this.repeat.max && pos + i < len){\n        test = false\n        cp = string.codepoints[pos + i]\n\n        if(pos >= len){\n            cp = EmptyString\n        }\n        try{\n            $B.codepoint2jsstring(cp)\n        }catch(err){\n            console.log(err.message)\n            throw _b_.Exception.$factory('mauvais codepoint')\n        }\n        var char = $B.codepoint2jsstring(cp),\n            cps = cased_cps(cp, ignore_case, this.flags.value & ASCII.value),\n            char_is_cased = cps.length > 1\n\n        for(var cp1 of cps){\n            for(var item of this.set.items){\n                if(Array.isArray(item.ord)){\n                    if(cp1 >= item.ord[0] &&\n                            cp1 <= item.ord[1]){\n                        test = true\n                        break\n                    }else if(ignore_case && char_is_cased){\n                        var start1 = chr(item.ord[0]).toUpperCase(),\n                            end1 = chr(item.ord[1]).toUpperCase(),\n                            char1 = char.toUpperCase()\n                        if(char1 >= start1 && char1 <= end1){\n                            test = true\n                        }\n                        var start1 = chr(item.ord[0]).toLowerCase(),\n                            end1 = chr(item.ord[1]).toLowerCase(),\n                            char1 = char.toLowerCase()\n                        if(char1 >= start1 && char1 <= end1){\n                            test = true\n                        }\n                    }\n                }else if(item instanceof CharacterClass){\n                    test = !! item.match(string, pos) // boolean\n                }else{\n                    if(item.ord == cp1){\n                        test = true\n                        break\n                    }\n                    if(ignore_case && char_is_cased &&\n                            (char.toUpperCase() == chr(item.ord).toUpperCase() ||\n                            char.toLowerCase() == chr(item.ord).toLowerCase())){\n                        test = true\n                        break\n                    }\n                }\n            }\n        }\n        if(this.neg){\n            test = ! test\n        }\n        if(test){\n            i++\n        }else{\n            break\n        }\n    }\n    var nb = i\n    if(nb >= this.repeat.min){\n        // Number of repeats ok\n        return {\n            nb_min: this.repeat.min,\n            nb_max: nb\n        }\n    }else{\n        return false\n    }\n\n}\n\nCharacterSet.prototype.nb_repeats = Char.prototype.nb_repeats\n\nCharacterSet.prototype.toString = function(){\n    return 'CharSet'\n}\n\nvar ConditionalBackref = function(pos, group_ref){\n    this.type = \"conditional backref\"\n    this.pos = pos\n    this.group_ref = group_ref\n    this.chars = []\n    this.match_codepoints = []\n    this.nb_success = 0\n    this.re_if_exists = new Group(pos)\n    this.re_if_not_exists = new Group(pos)\n    this.nb_options = 1\n}\n\nConditionalBackref.prototype.add = function(item){\n    if(this.nb_options == 1){\n        this.re_if_exists.add(item)\n    }else if(this.nb_options == 2){\n        this.re_if_not_exists.add(item)\n    }\n    item.parent = this\n}\n\nConditionalBackref.prototype.fixed_length = function(){\n    var len = this.re_if_exists.fixed_length()\n    if(len !== false && len == this.re_if_not_exists.fixed_length()){\n        return len\n    }\n    return false\n}\n\nConditionalBackref.prototype.match = function(string, pos, groups){\n    var re = groups[this.group_ref] ? this.re_if_exists :\n            this.re_if_not_exists,\n        pattern = {node: re, text: re + ''},\n        mo = match(pattern, string, pos, undefined,\n            false, groups)\n    if(mo){\n        return {nb_min: mo.end - mo.start, nb_max: mo.end - mo.start}\n    }\n    return false\n}\n\nConditionalBackref.prototype.toString = function(){\n    return 'ConditionalBackref'\n}\n\nvar Group = function(pos, extension){\n    this.type = \"group\"\n    this.pos = pos\n    this.items = []\n    this.chars = []\n    this.groups = []\n    for(key in extension){\n        this[key] = extension[key]\n    }\n    if(extension && extension.type){\n        if(extension.type.indexOf('lookahead') > -1){\n            this.is_lookahead = true\n        }else if(extension.type.indexOf('lookbehind') > -1){\n            this.is_lookbehind = true\n        }\n    }\n}\n\nGroup.prototype.add = Node.prototype.add\n\nGroup.prototype.toString = function(){\n    var res = 'Group #' + this.num + ' ' + this.pattern\n    if(this.repeat !== undefined){\n        res += ' repeat {' + this.repeat.min + ',' + this.repeat.max + '}'\n        if(this.non_greedy){\n            res += '?'\n        }\n    }\n    return res\n}\n\nBackReference.prototype.nb_repeats = Group.prototype.nb_repeats\n\nGroup.prototype.fixed_length = Node.prototype.fixed_length\n\nfunction GroupRef(group_num, item){\n    this.num = group_num\n    this.item = item\n}\n\nGroupRef.prototype.fixed_length = function(){\n    return this.item.fixed_length()\n}\n\nfunction Lookbehind(item){\n    this.re = item\n    this.neg = this.re.type == \"negative_lookbehind\"\n}\n\nLookbehind.prototype.match = function(string, pos, groups){\n    var ok = {nb_min: 0, nb_max: 0},\n        pattern = {node: this.re, text: this.re + ''},\n        length = this.re.length,\n        mo\n    if(pos - length < 0){\n        mo = false\n    }else{\n        mo = match(pattern, string, pos - length, undefined,\n            false, groups)\n    }\n    if(mo){\n        return this.neg ? false : ok\n    }else{\n        return this.neg ? ok : false\n    }\n}\n\nLookbehind.prototype.fixed_length = function(){\n    return this.re.fixed_length()\n}\n\nLookbehind.prototype.toString = function(){\n    return \"Lookbehind\"\n}\n\nfunction SetFlags(pos, flags){\n    this.pos = pos\n    this.on_flags = flags.on_flags\n    this.off_flags = flags.off_flags\n    this.items = []\n}\n\nSetFlags.prototype.add = Node.prototype.add\n\nfunction StringStart(pos){\n    this.pos = pos\n}\n\nStringStart.prototype.match = function(string, pos){\n    var ok = {nb_min:0, nb_max: 0}\n    if(this.flags.value & MULTILINE.value){\n        return (pos == 0 || string.codepoints[pos - 1] == 10) ? ok : false\n    }\n    return pos == 0 ? ok : false\n}\n\nStringStart.prototype.fixed_length = function(){\n    return 0\n}\n\nStringStart.prototype.toString = function(){\n    return '^'\n}\n\nfunction StringEnd(pos){\n    this.pos = pos\n}\n\nStringEnd.prototype.match = function(string, pos){\n    var ok = {nb_min:0, nb_max: 0}\n    if(this.flags.value & MULTILINE.value){\n        return (pos > string.codepoints.length - 1 ||\n            string.codepoints[pos] == 10) ? ok : false\n    }\n    return pos > string.codepoints.length - 1 ? ok :\n           (pos == string.codepoints.length - 1 &&\n               string.codepoints[pos] == 10) ? ok : false\n}\n\nStringEnd.prototype.fixed_length = function(){\n    return 0\n}\n\nStringEnd.prototype.toString = function(){\n    return '$<end>'\n}\n\nfunction validate(name, pos){\n    // name is a StringObj\n    sname = name.string\n    name = name.codepoints\n    if(name.length == 0){\n        fail(\"missing group name\", pos)\n    }else if(chr(name[0]).match(/\\d/) || name.indexOf(ord('.')) > - 1){\n        fail(`bad character in group name '${sname}'`, pos)\n    }\n\n    var $B = window.__BRYTHON__,\n        cp = name[0]\n    if($B.unicode_tables.XID_Start[cp]){\n        var pos = 1\n        while(pos < name.length){\n            cp = name[pos]\n            if($B.unicode_tables.XID_Continue[cp]){\n                pos++\n            }else{\n                break\n            }\n        }\n        if(pos != name.length){\n            console.log(\"bad character\", pos, name)\n            fail(`bad character in group name '${sname}'`, pos)\n        }\n    }else{\n        fail(`bad character in group name '${sname}'`, pos)\n    }\n}\n\nfunction chr(i){\n    if(i < 0 || i > 1114111){\n        throw _b_.ValueError.$factory('Outside valid range')\n    }else if(i >= 0x10000 && i <= 0x10FFFF){\n        var code = (i - 0x10000)\n        return String.fromCodePoint(0xD800 | (code >> 10)) +\n            String.fromCodePoint(0xDC00 | (code & 0x3FF))\n    }else{\n        return String.fromCodePoint(i)\n    }\n}\n\nvar character_classes = {\n    in_charset: to_codepoint_list('bdDsSwW'),\n    in_re: to_codepoint_list('AbBdDsSwWZ')\n}\n\nfunction escaped_char(args){\n    var cps = args.codepoints,\n        pos = args.pos,\n        in_charset = args.in_charset,\n        is_bytes = args.is_bytes // if pattern is bytes\n    var special = cps[pos + 1]\n    if(special === undefined){\n        fail('bad escape (end of pattern)', pos)\n    }\n    var key = in_charset ? 'in_charset' : 'in_re'\n    if(character_classes[key].indexOf(special) > -1){\n        return new CharacterClass(pos, special, 2)\n    }else if(special == ord('N') && ! is_bytes){\n        if(cps[pos + 2] != ord('{')){\n            fail('missing {', pos)\n        }\n        var i = pos + 3,\n            description = []\n        while(i < cps.length){\n            if(cps[i] == ord('}')){\n                break\n            }\n            description.push(cps[i])\n            i++\n        }\n        if(description.length == 0){\n            fail(\"missing character name\", pos)\n        }\n        if(i == cps.length){\n            fail(\"missing }, unterminated name\", pos)\n        }\n        var cp = validate_named_char(from_codepoint_list(description), pos)\n        return {\n            type: 'N',\n            ord: cp,\n            char: chr(cp),\n            length: i - pos + 1\n        }\n    }else if(special == ord('x')){\n        // \\xhh = character with hex value hh\n        var rest = from_codepoint_list(cps.slice(pos + 2)),\n            mo = /^[0-9a-fA-F]{0,2}/.exec(rest),\n            hh = mo ? mo[0] : ''\n        if(mo && mo[0].length == 2){\n            var cp = eval(\"0x\" + mo[0])\n            return {\n                type: 'x',\n                ord: cp,\n                char: chr(cp),\n                length: 2 + mo[0].length\n            }\n        }\n        fail('incomplete escape \\\\x' + hh, pos)\n    }else if(special == ord('u')){\n        // \\uxxxx = character with 16-bit hex value xxxx\n        var rest = from_codepoint_list(cps.slice(pos + 2)),\n            mo = /^[0-9a-fA-F]{0,4}/.exec(rest),\n            xx = mo ? mo[0] : ''\n        if(mo && mo[0].length == 4){\n            var cp = eval(\"0x\" + mo[0])\n            return {\n                type: 'u',\n                ord: cp,\n                char: chr(cp),\n                length: 2 + mo[0].length\n            }\n        }\n        fail('incomplete escape \\\\u' + xx, pos)\n    }else if(special == ord('U')){\n        // \\Uxxxxxxxx = character with 32-bit hex value xxxxxxxx\n        var rest = from_codepoint_list(cps.slice(pos + 2)),\n            mo = /^[0-9a-fA-F]{0,8}/.exec(rest),\n            xx = mo ? mo[0] : ''\n        if(mo && mo[0].length == 8){\n            var cp = eval(\"0x\" + mo[0])\n            if(cp > 0x10FFFF){\n                fail(`bad escape \\\\U${mo[0]}`, pos)\n            }\n            return {\n                type: 'U',\n                ord: cp,\n                char: chr(cp),\n                length: 2 + mo[0].length\n            }\n        }\n        fail('incomplete escape \\\\U' + xx, pos)\n    }else{\n        // octal ?\n        // If the first digit of number is 0, or number is 3 octal digits\n        // long, it will not be interpreted as a group match, but as the\n        // character with octal value number\n        var rest = from_codepoint_list(cps.slice(pos + 1)),\n            mo = /^[0-7]{3}/.exec(rest)\n        if(mo == null){\n            mo = /^0[0-7]*/.exec(rest)\n        }\n        if(mo){\n            var octal_value = eval('0o' + mo[0])\n            if(octal_value > 0o377){\n                fail(`octal escape value \\\\` +\n                    `${mo[0]} outside of range 0-0o377`, pos)\n            }\n            return {\n                type: 'o',\n                ord: octal_value,\n                char: chr(octal_value),\n                length: 1 + mo[0].length\n            }\n        }\n        var mo = /^\\d+/.exec(rest)\n        if(mo){\n            return {\n                type: 'backref',\n                value: parseInt(mo[0]),\n                length: 1 + mo[0].length\n            }\n        }\n        var trans = {f: '\\f', n: '\\n', r: '\\r', t: '\\t', v: '\\v'},\n            res = trans[chr(special)]\n        if(res){\n            return ord(res)\n        }\n        if(chr(special).match(/[a-zA-Z]/)){\n            fail(\"bad escape \\\\\" + chr(special), pos)\n        }else{\n            return special\n        }\n    }\n}\n\nfunction check_character_range(t, positions){\n    // Check if last 2 items in t are a valid character range\n    var start = t[t.length - 2],\n        end = t[t.length - 1]\n    if(start instanceof CharacterClass || end instanceof CharacterClass){\n        fail(`bad character range ${start}-${end}`,\n            positions[positions.length - 2])\n    }else if(end < start){\n        fail(`bad character range ${start}-${end}`,\n            positions[positions.length - 2])\n    }\n    t.splice(t.length - 2, 2, {\n        type: 'character_range',\n        start: start,\n        end: end,\n        ord: [start.ord, end.ord]\n    })\n}\n\nfunction parse_character_set(text, pos, is_bytes){\n    // Parse character set starting at position \"pos\" in \"text\"\n    // pos is the position of the leading \"[\"\n    var start = pos,\n        result = {items: []},\n        positions = []\n    pos++\n    if(text[pos] == ord('^')){\n        result.neg = true\n        pos++\n    }else if(text[pos] == ord(']')){\n        // a leading ] is the character \"]\", not the set end\n        result.items.push(']')\n        positions.push(pos)\n        pos++\n    }else if(text[pos] == ord('[')){\n        // send FutureWarning\n        warn(_b_.FutureWarning, \"Possible nested set\", pos)\n    }\n    var range = false\n    while(pos < text.length){\n        var cp = text[pos],\n            char = chr(cp)\n        if(char == ']'){\n            if(pos == start + 2 && result.neg){\n                // in \"[^]]\", the first ] is the character \"]\"\n                result.items.push(']')\n            }else{\n                return [result, pos]\n            }\n        }\n        if(char == '\\\\'){\n            var escape = escaped_char({\n                    codepoints: text,\n                    pos,\n                    in_charset: true,\n                    is_bytes\n                })\n            if(typeof escape == \"number\"){\n                var s = chr(escape)\n                escape = {\n                    ord: escape,\n                    length: 2,\n                    toString: function(){\n                        return s\n                    }\n                }\n            }\n            if(escape.type == \"num\"){\n                // [\\9] is invalid\n                fail(\"bad escape 1 \\\\\" +\n                    escape.value.toString()[0], pos)\n            }\n            result.items.push(escape)\n            positions.push(pos)\n            if(range){\n                check_character_range(result.items, positions)\n            }\n            range = false\n            pos += escape.length\n        }else if(char == '-'){\n            // Character range, or character \"-\"\n            if(pos == start + 1 ||\n                    (result.neg && pos == start + 2) ||\n                    pos == text.length - 1 ||\n                    range ||\n                    (result.items.length > 0 &&\n                    result.items[result.items.length - 1].type ==\n                        \"character_range\")){\n                result.items.push({\n                    ord: cp,\n                    char,\n                    toString: function(){\n                        return this.char\n                    }\n                })\n                if(text[pos + 1] == cp){\n                    warn(_b_.FutureWarning, \"Possible set difference\", pos)\n                }\n                pos++\n                if(range){\n                    check_character_range(result.items, positions)\n                }\n                range = false\n            }else{\n                range = true\n                if(text[pos + 1] == cp){\n                    warn(_b_.FutureWarning, \"Possible set difference\", pos)\n                }\n                pos++\n            }\n        }else{\n            positions.push(pos)\n            result.items.push({\n                ord: cp,\n                char,\n                toString: function(){\n                    return this.char\n                }\n            })\n            if(range){\n                check_character_range(result.items, positions)\n            }\n            range = false\n            // FutureWarning for consecutive \"&\", \"|\" or \"~\"\n            if(char == \"&\" && text[pos + 1] == cp){\n                warn(_b_.FutureWarning, \"Possible set intersection\", pos)\n            }else if(char == \"|\" && text[pos + 1] == cp){\n                warn(_b_.FutureWarning, \"Possible set union\", pos)\n            }else if(char == \"~\" && text[pos + 1] == cp){\n                warn(_b_.FutureWarning, \"Possible set symmetric difference\",\n                    pos)\n            }\n            pos++\n        }\n    }\n    fail(\"unterminated character set\", start)\n}\n\nfunction open_unicode_db(){\n    if($B.unicodedb === undefined){\n        var xhr = new XMLHttpRequest\n        xhr.open(\"GET\",\n            $B.brython_path + \"unicode.txt?\" + (new Date()).getTime(), false)\n        xhr.onreadystatechange = function(){\n            if(this.readyState == 4){\n                if(this.status == 200){\n                    $B.unicodedb = this.responseText\n                }else{\n                    console.log(\n                        \"Warning - could not load unicode.txt\")\n                }\n            }\n        }\n        xhr.send()\n    }\n}\n\nfunction validate_named_char(description, pos){\n    // validate that \\N{<description>} is in the Unicode db\n    // Load unicode table if not already loaded\n    if(description.length == 0){\n        fail(\"missing character name\", pos)\n    }\n    open_unicode_db()\n    if($B.unicodedb !== undefined){\n        var re = new RegExp(\"^([0-9A-F]+);\" +\n            description.toUpperCase() + \";.*$\", \"m\")\n        search = re.exec($B.unicodedb)\n        if(search === null){\n            fail(`undefined character name '${description}'`, pos)\n        }\n        return eval(\"0x\" + search[1])\n    }else{\n        fail(\"could not load unicode.txt\", pos)\n    }\n}\n\nvar cache = new Map()\n\nfunction compile(pattern, flags){\n    // data has attributes \"pattern\" (instance of StringObj)\n    // and \"type\" (\"str\" or \"bytes\")\n    if(pattern.__class__ === BPattern){\n        if(flags !== no_flag){\n            throw _b_.ValueError.$factory(\"no flags\")\n        }\n        return pattern\n    }\n    if(cache.has(pattern.py_obj)){\n        if(cache.get(pattern.py_obj).has(flags.value || 0)){\n            return cache.get(pattern.py_obj).get(flags.value || 0)\n        }\n    }\n    var original_pattern = pattern,\n        original_flags = flags,\n        type = pattern.type,\n        choices\n    pattern = pattern.codepoints\n    var is_bytes = type !== \"str\"\n    if(is_bytes && flags && (flags.value & U.value)){\n        throw _b_.ValueError.$factory(\"cannot use UNICODE flag with \" +\n            \"a bytes pattern\")\n    }\n    if(flags && (flags.value & U.value) &&\n            (flags.value & ASCII.value)){\n        throw _b_.ValueError.$factory(\"ASCII and UNICODE flags \" +\n            \"are incompatible\")\n    }\n    if(is_bytes){\n        // bytes patterns ignore re.ASCII flag\n        flags = Flag.$factory(flags.value || 0)\n        //flags.value &= ~ASCII.value\n    }\n    var group_num = 0,\n        group_stack = [],\n        groups = {},\n        pos,\n        lookbehind,\n        node = new Node(),\n        accept_inline_flag = true,\n        verbose = (flags.value || 0) & VERBOSE.value\n    node.$groups = groups\n    for(var item of tokenize(pattern, type, verbose)){\n        item.flags = flags\n        item.is_bytes = is_bytes\n        if(lookbehind){\n            item.lookbehind = lookbehind\n            lookbehind.parent = item\n            lookbehind = false\n        }\n        if(item instanceof Group){\n            group_stack.push(item)\n            node.add(item)\n            item.state = \"open\"\n            group_num++\n            item.num = group_num\n            node = item // next items will be stored as group's items\n            pos = item.pos\n            if(item.non_capturing){\n                delete item.num\n                group_num--\n            }else if(item.type == \"name_def\"){\n                var value = item.value\n                validate(value, pos)\n                if(groups[value.string] !== undefined){\n                    fail(`redefinition of group name` +\n                        ` '${value.string}' as group ${group_num}; was group` +\n                        ` ${groups[value.string].num}`, pos)\n                }\n                item.name = value.string\n                groups[value.string] = groups[group_num] =\n                    new GroupRef(group_num, item)\n            }else if(item.is_lookahead){\n                // a lookahead assertion is relative to the previous regexp\n                group_num--\n                while(node.items.length > 0){\n                    item.add(node.items.shift())\n                }\n                node = item\n            }else if(item.is_lookbehind){\n                // a lookbehind assertion is relative to the next regexp\n                node.parent.items.pop() // remove from node items\n                // temporarily create a group\n                groups[group_num] = new GroupRef(group_num, item)\n            }else if(item.type == \"flags\"){\n                // save flags before a group with inline flags, eg \"(?i:a)\"\n                item.flags_before = Flag.$factory(flags.value | 0)\n            }else{\n                groups[group_num] = new GroupRef(group_num, item)\n            }\n        }else if(item instanceof GroupEnd){\n            end_pos = item.pos\n            if(group_stack.length == 0){\n                fail(\"unbalanced parenthesis\", end_pos, original_pattern)\n            }\n            var item = group_stack.pop()\n            item.end_pos = end_pos\n            try{\n                item.pattern = from_codepoint_list(\n                    pattern.slice(item.pos, end_pos + 1))\n            }catch(err){\n                console.log(\"err avec pattern substring\", pattern)\n                throw err\n            }\n            if(item.is_lookbehind){\n                delete groups[group_num]\n                group_num--\n                // check that all elements have a fixed length\n                item.length = item.fixed_length()\n                if(item.length === false){\n                    fail(\"look-behind requires fixed-width pattern\", pos)\n                }\n                item.parent.add(new Lookbehind(item))\n                item.non_capturing = true\n                // store in variable \"lookbehind\", will be applied to next item\n                lookbehind = item\n            }else if(item.is_lookahead){\n                delete item.num\n            }\n            if(item instanceof Group && item.items.length == 0){\n                item.add(new Char(pos, EmptyString, group_stack.concat([item])))\n            }else if(item instanceof ConditionalBackref){\n                if(item.re_if_exists.items.length == 0){\n                    item.re_if_exists.add(EmptyString)\n                }else if(item.re_if_not_exists.items.length == 0){\n                    item.re_if_not_exists.pos = pos\n                    item.re_if_not_exists.add(EmptyString)\n                }\n            }else if(item.type == \"flags\"){\n                // restore flags when entering the group\n                flags = Flag.$factory(item.flags_before.value)\n            }\n            item.state = 'closed'\n            node = item.parent\n        }else if(item instanceof ConditionalBackref){\n            var pos = item.pos,\n                group_ref = item.group_ref\n            if(typeof group_ref == \"number\"){\n                if(group_ref == 0){\n                    fail(`bad group number`, pos + 3)\n                }else if(group_ref >= MAXGROUPS){\n                    fail(`invalid group reference ${group_ref}`, pos + 1)\n                }else if(groups[group_ref] &&\n                        groups[group_ref].item.state == \"open\"){\n                    fail(\"cannot refer to an open group\", pos)\n                }\n            }else if(groups[group_ref] !== undefined){\n                if(groups[group_ref].item.state == \"open\"){\n                    fail(\"cannot refer to an open group\", pos)\n                }\n            }else{\n                fail(`unknown group name '${group_ref}'`, pos)\n            }\n            group_stack.push(item)\n            node.add(item)\n            item.state = \"open\"\n            node = item // next items will be stored as group's items\n        }else if(item instanceof BackReference){\n            pos = item.pos\n            if(item.type == \"num\" && item.value > 99){\n                var head = item.value.toString().substr(0, 2)\n                fail(`invalid group reference ${head}`, pos + 1)\n            }\n            if(groups[item.value] !== undefined){\n                if(groups[item.value].item.state == \"open\"){\n                    fail(\"cannot refer to an open group\", pos)\n                }\n                var ref_item = groups[item.value].item.parent\n                while(ref_item){\n                    if(ref_item.is_lookbehind){\n                        fail(\"cannot refer to group defined in the same lookbehind subpattern\", pos)\n                    }\n                    ref_item = ref_item.parent\n                }\n            }else if(item.type == \"name\"){\n                fail(`unknown group name '${item.value}'`, pos)\n            }else if(item.type == \"num\"){\n                fail(`invalid group reference ${item.value}`, pos)\n            }\n            node.add(item)\n        }else if(item instanceof Char ||\n                item instanceof CharacterClass ||\n                item instanceof CharacterSet){\n            if(item instanceof CharacterSet){\n                for(var elt of item.set.items){\n                    elt.flags = flags\n                }\n            }\n            var added_to_charseq = false\n            if(item instanceof Char){\n                if(node.items && node.items.length > 0){\n                    var previous = $last(node.items)\n                    if(previous instanceof CharSeq){\n                        previous.chars.push(item)\n                        added_to_charseq = true\n                    }else if(previous instanceof Char){\n                        node.items.pop()\n                        node.items.push(new CharSeq([previous, item]))\n                        added_to_charseq = true\n                    }\n                }\n            }\n            if(! added_to_charseq){\n                node.add(item)\n            }\n        }else if(item instanceof Repeater){\n            // check that item is not in a lookbehind group\n            var pnode = node\n            while(pnode){\n                if(pnode.extension && pnode.extension.type &&\n                        pnode.extension.type.indexOf(\"lookbehind\") > -1){\n                    fail(\"look-behind requires fixed-width pattern\", pos)\n                }\n                pnode = pnode.parent\n            }\n            pos = item.pos\n            if(node.items.length == 0){\n                fail(\"nothing to repeat\", pos)\n            }\n            previous = $last(node.items)\n            if(previous instanceof Char ||\n                    previous instanceof CharSeq ||\n                    previous instanceof CharacterClass ||\n                    previous instanceof CharacterSet ||\n                    previous instanceof Group ||\n                    previous instanceof BackReference){\n                if(previous instanceof GroupEnd){\n                    // associate repeat with Group\n                    previous = previous.group\n                }else if(previous instanceof CharSeq){\n                    previous = $last(previous.chars)\n                }\n                if(previous.repeater){\n                    if(item.op == '?' && ! previous.non_greedy){\n                        previous.non_greedy = true\n                        if(previous instanceof CharacterClass &&\n                                previous.value == '.'){\n                            previous.min_repeat_one = true\n                        }\n                    }else{\n                        fail(\"multiple repeat\", pos)\n                    }\n                }else{\n                    // convert to minimum and maximum number of repeats\n                    var min = 1,\n                        max = 1\n                    if(Array.isArray(item.op)){\n                        min = item.op[0]\n                        if(min >= MAXREPEAT){\n                            throw _b_.OverflowError.$factory(\n                                \"the repetition number is too large\")\n                        }\n                        max = item.op[1] === undefined ? min : item.op[1]\n                        if(isFinite(max) && max >= MAXREPEAT){\n                            throw _b_.OverflowError.$factory(\n                                \"the repetition number is too large\")\n                        }\n                        if(max < min){\n                            fail('min repeat greater than max repeat', pos)\n                        }\n                    }else if(item.op == \"?\"){\n                        min = 0\n                        max = 1\n                    }else if(item.op == \"*\"){\n                        min = 0\n                        max = Number.POSITIVE_INFINITY\n                    }else if(item.op == \"+\"){\n                        min = 1\n                        max = Number.POSITIVE_INFINITY\n                    }\n                    previous.repeater = item\n                    previous.repeat = {min, max}\n                    // mark all parents of item as no fixed length\n                    var parent = item\n                    while(parent){\n                        parent.fixed_length = false\n                        parent = parent.parent\n                    }\n                }\n            }else{\n                fail(\"nothing to repeat\", pos)\n            }\n        }else if(item instanceof Or){\n            if(group_stack.length > 0){\n                item.group = group_stack[group_stack.length - 1]\n            }else{\n                item.group = false\n            }\n            pos = item.pos\n            if(node instanceof ConditionalBackref){\n                // case '(?(num)a|'\n                if(node.nb_options == 1){\n                    node.nb_options++\n                }else{\n                    fail('conditional backref with more than ' +\n                       'two branches', pos)\n                }\n            }else if(node.items.length == 0){\n                // token \"|\" in  \"(|...)\" : first option is the empty string\n                var choice = new Choice(),\n                    case1 = new Case()\n                case1.add(new Char(pos, EmptyString))\n                choice.add(case1)\n                node.add(choice)\n                var case2 = new Case()\n                choice.add(case2)\n                node = case2\n            }else if(node instanceof Case){\n                // node.parent is already a Choice\n                var new_case = new Case()\n                node.parent.add(new_case)\n                node = new_case\n            }else{\n                // token \"|\" in \"(ab|...)\"\n                var previous = node.items[node.items.length - 1]\n                if(previous instanceof Case){\n                    var new_case = new Case()\n                    previous.add(new_case)\n                    node = new_case\n                }else{\n                    var choice = new Choice(),\n                        case1 = new Case(),\n                        first_rank = node.items[0].rank\n                    while(node.items.length > 0){\n                        case1.add(node.items.shift())\n                    }\n                    case1.groups = node.$groups\n                    for(var group of group_stack){\n                        choice.groups.push(group)\n                    }\n                    choice.add(case1)\n                    node.add(choice)\n                    var case2 = new Case()\n                    choice.add(case2)\n                    node = case2\n                }\n            }\n        }else if(item instanceof StringStart ||\n                 item instanceof StringEnd){\n            node.add(item)\n        }else if(item instanceof SetFlags){\n            // copy flags, otherwise re.ASCII etc might be modified\n            flags = Flag.$factory(flags.value || U.value)\n            if(item.on_flags.indexOf('u') > -1){\n                if(is_bytes){\n                    fail(\"re.error: bad inline flags: cannot use 'u' flag \" +\n                        \"with a bytes pattern\", pos)\n                }\n                if(flags && flags.value & ASCII.value){\n                    // switch to Unicode\n                    flags.value ^= ASCII.value\n                }\n                if(group_stack.length == 0 &&\n                        original_flags && original_flags.value & ASCII.value){\n                    throw _b_.ValueError.$factory(\"ASCII and UNICODE flags \" +\n                        \"are incompatible\")\n                }\n                if(item.on_flags.indexOf('a') > -1){\n                    throw _b_.ValueError.$factory(\"ASCII and UNICODE flags \" +\n                        \"are incompatible\")\n                }\n            }else if(item.on_flags.indexOf('a') > -1){\n                if(group_stack.length == 0 &&\n                        original_flags && original_flags.value & U.value){\n                    throw _b_.ValueError.$factory(\"ASCII and UNICODE flags \" +\n                        \"are incompatible\")\n                }\n                if(flags && flags.value & U.value){\n                    // switch to ASCII\n                    flags.value ^= U.value\n                }\n                if(item.on_flags.indexOf('u') > -1){\n                    throw _b_.ValueError.$factory(\"ASCII and UNICODE flags \" +\n                        \"are incompatible\")\n                }\n            }\n            if(flags.value === undefined){\n                flags.value = 32\n            }\n            if(item.items.length == 0){\n                if(! accept_inline_flag && group_stack.length == 0){\n                    var s = from_codepoint_list(pattern)\n                    warn(_b_.DeprecationWarning,\n                        `Flags not at the start of the expression '${s}'`,\n                        pos)\n                }\n                for(var on_flag of item.on_flags){\n                    if(! is_bytes || on_flag !== 'a'){\n                        flags.value |= inline_flags[on_flag].value\n                    }\n                }\n                for(var off_flag of item.off_flags){\n                    if(! is_bytes || off_flag !== 'a'){\n                        flags.value ^= inline_flags[off_flag].value\n                    }\n                }\n            }else{\n                node.add(item)\n            }\n        }else{\n            fail(\"unknown item type \" + item, pos)\n        }\n        if(! (item instanceof SetFlags) &&\n                ! (item instanceof Group && item.type == \"flags\")){\n            accept_inline_flag = false\n        }\n    }\n    if(group_stack.length > 0){\n        var last = group_stack[group_stack.length - 1]\n        fail(\"missing ), unterminated subpattern\", last.pos)\n    }\n    while(node.parent){\n        node = node.parent\n    }\n    node.pattern = from_codepoint_list(pattern)\n    node.groups = group_num\n    flags = flags === no_flag ? 32 : flags\n    node.flags = flags\n    var res = {\n        node,\n        groups,\n        flags,\n        original_flags,\n        text: from_codepoint_list(pattern),\n        type, // \"str\" or \"bytes\"\n        fixed_length: node.fixed_length()\n    }\n    if(! cache.has(original_pattern.py_obj)){\n        cache.set(original_pattern.py_obj, new Map())\n    }\n    cache.get(original_pattern.py_obj).set(original_flags.value || 0, res)\n    show(node)\n    return res\n}\n\nfunction show(node, indent){\n    indent = indent === undefined ? 0 : indent\n    if(indent == 0){\n        log('root', node)\n    }\n    log(' '.repeat(indent) + node)\n    if(node.items !== undefined){\n        for(var item of node.items){\n            show(item, indent + 1)\n        }\n    }\n}\n\nfunction ord(char){\n    return char.charCodeAt(0)\n}\n\nfunction* tokenize(pattern, type, _verbose){\n    // pattern is a list of codepoints\n    var is_bytes = type == \"bytes\"\n    // verbose_stack is the stack of verbose state for each group in the regex\n    var verbose_stack = [_verbose],\n        verbose = _verbose\n    var pos = 0\n    while(pos < pattern.length){\n        var cp = pattern[pos],\n            char = String.fromCharCode(cp)\n        if(verbose){\n            // current group is in verbose mode\n            if(char == \"#\"){\n                // skip until next line feed\n                while(pos < pattern.length && pattern[pos] != 10){\n                    pos++\n                }\n                pos++\n                continue\n            }else{\n                while(pos < pattern.length &&\n                        [9, 10, 11, 12, 13, 32].indexOf(pattern[pos]) > -1){\n                    pos++\n                }\n            }\n            cp = pattern[pos]\n            if(cp === undefined){\n                break\n            }\n            char = String.fromCharCode(cp)\n            if(char == '#'){\n                continue\n            }\n        }\n        if(char == '('){\n            if(pattern[pos + 1] == ord('?')){\n                if(pattern[pos + 2] == ord('P')){\n                    if(pattern[pos + 3] == ord('<')){\n                        var name = [],\n                            i = pos + 4\n                        while(i < pattern.length){\n                            if(pattern[i] == ord('>')){\n                                break\n                            }else if(pattern[i] == ord(')')){\n                                fail(\"missing >, unterminated name\", pos)\n                            }\n                            name.push(pattern[i])\n                            i++\n                        }\n                        name = StringObj.from_codepoints(name)\n                        validate(name, pos)\n                        if(i == pattern.length){\n                            fail(\"missing >, unterminated name\", pos)\n                        }\n                        yield new Group(pos, {type: 'name_def', value: name})\n                        verbose_stack.push(verbose)\n                        pos = i + 1\n                        continue\n                    }else if(pattern[pos + 3] == ord('=')){\n                        var name = [],\n                            i = pos + 4\n                        while(i < pattern.length){\n                            if(pattern[i] == ord(')')){\n                                break\n                            }\n                            name.push(pattern[i])\n                            i++\n                        }\n                        name = StringObj.from_codepoints(name)\n                        validate(name, pos)\n                        if(i == pattern.length){\n                            fail(\"missing ), unterminated name\", pos)\n                        }\n                        yield new BackReference(pos, 'name', name.string)\n                        pos = i + 1\n                        continue\n                    }else if(pattern[pos + 3] === undefined){\n                        fail(\"unexpected end of pattern\", pos)\n                    }else{\n                        fail(\"unknown extension ?P\" + chr(pattern[pos + 3]), pos)\n                    }\n                }else if(pattern[pos + 2] == ord('(')){\n                    var ref = [],\n                        i = pos + 3\n                    while(i < pattern.length){\n                        if(pattern[i] == ord(')')){\n                            break\n                        }\n                        ref.push(pattern[i])\n                        i++\n                    }\n                    var sref = StringObj.from_codepoints(ref)\n                    if(sref.string.match(/^\\d+$/)){\n                        ref = parseInt(sref.string)\n                    }else{\n                        validate(sref, pos)\n                        ref = sref.string\n                    }\n                    if(i == pattern.length){\n                        fail(\"missing ), unterminated name\", pos)\n                    }\n                    yield new ConditionalBackref(pos, ref)\n                    pos = i + 1\n                    continue\n                }else if(pattern[pos + 2] == ord('=')){\n                    // (?=...) : lookahead assertion\n                    yield new Group(pos, {type: 'lookahead_assertion'})\n                    verbose_stack.push(verbose)\n                    pos += 3\n                    continue\n                }else if(pattern[pos + 2] == ord('!')){\n                    // (?!...) : negative lookahead assertion\n                    yield new Group(pos, {type: 'negative_lookahead_assertion'})\n                    verbose_stack.push(verbose)\n                    pos += 3\n                    continue\n                }else if(from_codepoint_list(pattern.slice(pos + 2, pos + 4)) == '<!'){\n                    // (?<!...) : negative lookbehind\n                    yield new Group(pos, {type: 'negative_lookbehind'})\n                    verbose_stack.push(verbose)\n                    pos += 4\n                    continue\n                }else if(from_codepoint_list(pattern.slice(pos + 2, pos + 4)) == '<='){\n                    // (?<=...) : positive lookbehind\n                    yield new Group(pos, {type: 'positive_lookbehind'})\n                    verbose_stack.push(verbose)\n                    pos += 4\n                    continue\n                }else if(pattern[pos + 2] == ord('<')){\n                    pos += 3\n                    if(pos == pattern.length){\n                        fail(\"unexpected end of pattern\", pos)\n                    }\n                    fail(\"unknown extension ?<\" + _b_.chr(pattern[pos]), pos)\n                }else if(pattern[pos + 2] == ord(':')){\n                    yield new Group(pos, {non_capturing: true})\n                    verbose_stack.push(verbose)\n                    pos += 3\n                    continue\n                }else if(pattern[pos + 2] === undefined){\n                    fail(\"unexpected end of pattern\", pos)\n                }\n\n                var flags = to_codepoint_list('aiLmsux'),\n                    auL_flags = to_codepoint_list('auL'),\n                    flags_start = pos\n                if(pattern[pos + 2] == ord('-') ||\n                        flags.indexOf(pattern[pos + 2]) > -1){\n                    if(pattern[pos + 2] == ord('-')){\n                        var on_flags = [],\n                            has_off = true,\n                            off_flags = []\n                        pos += 3\n                    }else{\n                        var on_flags = [chr(pattern[pos + 2])],\n                            has_off = false,\n                            off_flags = [],\n                            auL = auL_flags.indexOf(pattern[pos + 2]) > -1 ?\n                                1 : 0,\n                            closed = false\n                        pos += 3\n                        while(pos < pattern.length){\n                            if(flags.indexOf(pattern[pos]) > -1){\n                                if(auL_flags.indexOf(pattern[pos]) > -1){\n                                    auL++\n                                    if(auL > 1){\n                                        fail(\"bad inline flags: flags 'a', 'u'\" +\n                                            \" and 'L' are incompatible\", pos)\n                                    }\n                                }\n                                on_flags.push(chr(pattern[pos]))\n                                pos++\n                            }else if(pattern[pos] == ord('-')){\n                                has_off = true\n                                closed = true\n                                pos++\n                                break\n                            }else if(String.fromCharCode(pattern[pos]).\n                                    match(/[a-zA-Z]/)){\n                                fail(\"unknown flag\", pos)\n                            }else if(pattern[pos] == ord(')')){\n                                closed = true\n                                break\n                            }else if(pattern[pos] == ord(':')){\n                                yield new Group(pos, {name: \"Group\", type: \"flags\"})\n                                verbose_stack.push(verbose)\n                                closed = true\n                                break\n                            }else{\n                                fail(\"missing -, : or )\", pos)\n                            }\n                        }\n                        if(! closed){\n                            fail(\"missing -, : or )\", pos)\n                        }\n                    }\n                    if(has_off){\n                        while(pos < pattern.length){\n                            if(flags.indexOf(pattern[pos]) > -1){\n                                if(auL_flags.indexOf(pattern[pos]) > -1){\n                                    fail(\"bad inline flags: cannot turn off \" +\n                                        \"flags 'a', 'u' and 'L'\", pos)\n                                }\n                                if(on_flags.indexOf(chr(pattern[pos])) > -1){\n                                    fail(\"bad inline flags: flag turned on and off\", pos)\n                                }\n                                off_flags.push(chr(pattern[pos]))\n                                pos++\n                            }else if(pattern[pos] == ord(':')){\n                                yield new Group(pos, {name: \"Group\", type: \"flags\"})\n                                verbose_stack.push(verbose)\n                                break\n                            }else if(String.fromCharCode(pattern[pos]).\n                                    match(/[a-zA-Z]/)){\n                                fail(\"unknown flag\", pos)\n                            }else if(off_flags.length == 0){\n                                fail(\"missing flag\", pos)\n                            }else{\n                                fail(\"missing :\", pos)\n                            }\n                        }\n                        if(off_flags.length == 0){\n                            fail(\"missing flag\", pos)\n                        }\n                    }\n                    if(has_off && pattern[pos] != ord(':')){\n                        fail(\"missing :\", pos)\n                    }\n                    if(on_flags.length == 0 && off_flags.length == 0){\n                        fail(\"missing flag\", pos)\n                    }\n                    var set_flags = new SetFlags(flags_start,\n                        {on_flags, off_flags})\n                    yield set_flags\n                    // reset verbose\n                    if(on_flags.indexOf('x') > -1){\n                        verbose = true\n                    }\n                    if(off_flags.indexOf('x') > -1){\n                        verbose = false\n                    }\n                    if(! closed){\n                        node = set_flags\n                    }\n                    pos++\n                }else if(pattern[pos + 2] == ord('#')){\n                    pos += 3\n                    while(pos < pattern.length){\n                        if(pattern[pos] == ord(')')){\n                            break\n                        }\n                        pos++\n                    }\n                    if(pos == pattern.length){\n                        fail(\"missing ), unterminated comment\", pos)\n                    }\n                    pos++\n                    continue\n                }else{\n                    fail(\"unknown extension ?\" + _b_.chr(pattern[pos + 2]),\n                        pos)\n                }\n            }else{\n                yield new Group(pos)\n                verbose_stack.push(verbose)\n                pos++\n            }\n        }else if(cp == ord(')')){\n            yield new GroupEnd(pos)\n            verbose_stack.pop()\n            verbose = $last(verbose_stack)\n            pos++\n        }else if(cp == ord('\\\\')){\n            var escape = escaped_char({codepoints: pattern, pos, is_bytes})\n            if(escape instanceof CharacterClass){\n                yield escape\n                pos += escape.length\n            }else if(escape.char !== undefined){\n                yield new Char(pos, escape.ord)\n                pos += escape.length\n            }else if(escape.type == \"backref\"){\n                yield new BackReference(pos, \"num\", escape.value)\n                pos += escape.length\n            }else if(typeof escape == \"number\"){\n                // eg \"\\.\"\n                var esc = new Char(pos, escape)\n                esc.escaped = true\n                yield esc\n                pos += 2\n            }else{\n                yield new Char(pos, escape)\n                pos += escape.length\n            }\n        }else if(cp == ord('[')){\n            // Set of characters\n            var set,\n                end_pos\n            [set, end_pos] = parse_character_set(pattern, pos, is_bytes)\n            yield new CharacterSet(pos, set)\n            pos = end_pos + 1\n        }else if('+?*'.indexOf(char) > -1){\n            yield new Repeater(pos, char)\n            pos++\n        }else if(cp == ord('{')){\n            var reps = /\\{(\\d*)((,)(\\d*))?\\}/.exec(\n                    from_codepoint_list(pattern.slice(pos)))\n            if(reps && reps[0] != '{}'){\n                if(reps[1] == \"\"){\n                    var limits = [0]\n                }else{\n                    var limits = [parseInt(reps[1])]\n                }\n                if(reps[4] !== undefined){\n                    if(reps[4] == \"\"){\n                        var max = Number.POSITIVE_INFINITY\n                    }else{\n                        var max = parseInt(reps[4])\n                    }\n                    limits.push(max)\n                }\n                yield new Repeater(pos, limits)\n                pos += reps[0].length\n            }else if(pattern[pos + 1] == ord('}')){\n                // {} is the characters \"{\" and \"}\"\n                yield new Char(pos, ord('{'))\n                pos++\n            }else{\n                yield new Char(pos, ord('{'))\n                pos++\n            }\n        }else if(cp == ord('|')){\n            yield new Or(pos)\n            pos++\n        }else if(cp == ord('.')){\n            yield new CharacterClass(pos, cp, 1)\n            pos++\n        }else if(cp == ord('^')){\n            yield new StringStart(pos)\n            pos++\n        }else if(cp == ord('$')){\n            yield new StringEnd(pos)\n            pos++\n        }else{\n            yield new Char(pos, cp)\n            pos++\n        }\n    }\n}\n\nfunction to_codepoint_list(s){\n    var items = []\n    if(typeof s == \"string\" || _b_.isinstance(s, _b_.str)){\n        if(typeof s != \"string\"){\n            s = s.valueOf()\n        }\n        for(const char of s){\n            items.push(char.codePointAt(0))\n        }\n        items.type = \"unicode\"\n    }else if(_b_.isinstance(s, bytes_like)){\n        if(_b_.isinstance(s, _b_.memoryview)){\n            items = s.obj.source\n        }else{\n            items = s.source\n        }\n        items.type = \"bytes\"\n    }else{\n        throw Error('invalid type ' + $B.class_name(s))\n    }\n    return items\n}\n\nfunction from_codepoint_list(codepoints, type){\n    // Return a string\n    if(type == \"bytes\"){\n        return _b_.bytes.$factory(codepoints)\n    }\n    var s = ''\n    for(const cp of codepoints){\n        s += _b_.chr(cp)\n    }\n    return $B.String(s)\n}\n\nvar GroupDict = $B.make_class(\"GroupDict\")\nGroupDict.__mro__ = [_b_.dict, _b_.object]\nGroupDict.__setitem__ = function(){\n    throw _b_.TypeError.$factory(\"read only\")\n}\n\n\nvar bytes_like = [_b_.bytes, _b_.bytearray, _b_.memoryview]\n\nfunction string2bytes(s){\n    var t = []\n    for(var i = 0, len = s.length; i < len; i++){\n        t.push(s.charCodeAt(i))\n    }\n    return _b_.bytes.$factory(t)\n}\n\nfunction check_pattern_flags(pattern, flags){\n    if(pattern.__class__ === BPattern){\n        if(flags !== no_flag){\n            throw _b_.ValueError.$factory(\n                \"cannot process flags argument with a compiled pattern\")\n        }\n    }\n    return pattern\n}\n\nfunction transform_repl(data, pattern){\n    // data.repl is a StringObj instance\n    var repl = data.repl.string\n    repl = repl.replace(/\\\\n/g, '\\n')\n    repl = repl.replace(/\\\\r/g, '\\r')\n    repl = repl.replace(/\\\\t/g, '\\t')\n    repl = repl.replace(/\\\\b/g, '\\b')\n    repl = repl.replace(/\\\\v/g, '\\v')\n    repl = repl.replace(/\\\\f/g, '\\f')\n    repl = repl.replace(/\\\\a/g, '\\a')\n    // detect backreferences\n    var pos = 0,\n        escaped = false,\n        br = false,\n        repl1 = \"\",\n        has_backref = false\n    while(pos < repl.length){\n        br = false\n        if(repl[pos] == \"\\\\\"){\n            escaped = ! escaped\n            if(escaped){\n                pos++\n                continue\n            }\n        }else if(escaped){\n            escaped = false\n            var mo = /^\\d+/.exec(repl.substr(pos))\n            if(mo){\n                var cps = to_codepoint_list(repl)\n                var escape = escaped_char({\n                        codepoints: cps,\n                        pos: pos - 1,\n                        is_bytes: cps.type == \"bytes\"\n                     })\n                if(escape.type == \"o\"){\n                    if(escape.ord > 0o377){\n                        fail(`octal escape value \\\\${mo[0]} ` +\n                            \" outside of range 0-0o377\", pos)\n                    }\n                    repl1 += escape.char\n                    pos += escape.length - 1\n                    continue\n                }else if(escape.type != \"backref\"){\n                    var group_num = mo[0].substr(0,\n                        Math.min(2, mo[0].length))\n                    fail(`invalid group reference ${group_num}`, pos)\n                }else{\n                    // only keep first 2 digits\n                    var group_num = mo[0].substr(0,\n                        Math.min(2, mo[0].length))\n                    // check that pattern has the specified group num\n                    if(pattern.groups === undefined){\n                        console.log(\"pattern\", pattern)\n                        throw _b_.AttributeError.$factory(\"$groups\")\n                    }\n                    if(pattern.groups[group_num] === undefined){\n                        fail(`invalid group reference ${group_num}`,\n                            pos)\n                    }else{\n                        mo[0] = group_num\n                    }\n                }\n                if(! has_backref){\n                    var parts = [repl.substr(0, pos - 1),\n                            parseInt(mo[0])]\n                }else{\n                    parts.push(repl.substring(next_pos, pos - 1))\n                    parts.push(parseInt(mo[0]))\n                }\n                has_backref = true\n                var next_pos = pos + mo[0].length\n                br = true\n                pos += mo[0].length\n            }else if(repl[pos] == \"g\"){\n                pos++\n                if(repl[pos] != '<'){\n                    fail(\"missing <\", pos)\n                }\n                pos++\n                mo = /(.*?)>/.exec(repl.substr(pos))\n                if(mo){\n                    if(mo[1] == \"\"){\n                        pos += mo[0].length\n                        fail(\"missing group name\", pos - 1)\n                    }\n                    var group_name = mo[1]\n                    if(/^\\d+$/.exec(group_name)){\n                        if(pattern.groups[group_name] === undefined){\n                            fail(`invalid group reference ${group_name}`,\n                                pos)\n                        }\n                    }else{\n                        if(! _b_.str.isidentifier(group_name)){\n                            var cps = to_codepoint_list(group_name)\n                            if($B.unicode_tables.XID_Start[cps[0]] === undefined){\n                                fail(\"bad character in group name '\" +\n                                    group_name + \"'\", pos)\n                            }else{\n                                for(cp of cps.slice(1)){\n                                    if($B.unicode_tables.XID_Continue[cp] === undefined){\n                                        fail(\"bad character in group name '\" +\n                                            group_name + \"'\", pos)\n                                    }\n                                }\n                            }\n                        }\n                        if(pattern.groups[group_name] === undefined){\n                            throw _b_.IndexError.$factory(\n                                `unknown group name '${group_name}'`,\n                                pos)\n                        }\n                    }\n                    if(! has_backref){\n                        var parts = [repl.substr(0, pos - 3),\n                                mo[1]]\n                    }else{\n                        parts.push(repl.substring(next_pos, pos - 3))\n                        parts.push(mo[1])\n                    }\n                    has_backref = true\n                    var next_pos = pos + mo[0].length\n                    br = true\n                    pos = next_pos\n                }else{\n                    if(repl.substr(pos).length > 0){\n                        fail(\"missing >, unterminated name\", pos)\n                    }else{\n                        fail(\"missing group name\", pos)\n                    }\n                }\n            }else{\n                if(/[a-zA-Z]/.exec(repl[pos])){\n                    fail(\"unknown escape\", pos)\n                }\n                pos += repl[pos]\n            }\n        }\n        if(! br){\n            repl1 += repl[pos]\n            pos ++\n        }\n    }\n    data.repl1 = repl1\n    if(has_backref){\n        parts.push(repl.substr(next_pos))\n        data.repl = function(bmo){\n            var mo = bmo.mo,\n                res = parts[0],\n                groups = mo.$groups,\n                s = mo.string,\n                group\n            for(var i = 1, len = parts.length; i < len; i += 2){\n                if(groups[parts[i]] === undefined){\n                    if(mo.node.$groups[parts[i]] !== undefined){\n                        // group is defined in the RE, but didn't contribute\n                        // to the match\n                        // groups[parts[i]] = ''\n                    }else{\n                        // group is not defined in the RE\n                        pos++\n                        group_num = parts[i].toString().substr(0, 2)\n                        fail(`invalid group reference ${group_num}`, pos)\n                    }\n                }else{\n                    group = groups[parts[i]]\n                    res += s.substring(group.start, group.end)\n                }\n                res += parts[i + 1]\n            }\n            return res\n        }\n    }else{\n        data.repl = new StringObj(repl)\n    }\n    return data\n}\n\nfunction StringObj(obj){\n    // A StringObj object is a bridge between a Python string or bytes-like\n    // object and Javascript\n    // obj is the Python object\n    // this.string is a Javascript string\n    this.py_obj = obj\n    this.codepoints = []\n    this.type = \"str\"\n    if(typeof obj == \"string\" ||\n            (obj instanceof String && ! obj.codepoints)){\n        // Python object represented as a Javascript string\n        this.string = obj\n        // Maps a position in codepoints to position in string\n        this.index_map = {}\n        for(var i = 0, len = obj.length; i < len; i++){\n            this.index_map[this.codepoints.length] = i\n            var cp = obj.codePointAt(i)\n            this.codepoints.push(cp)\n            if(cp >= 0x10000){\n                i++\n            }\n        }\n        if(obj instanceof String){\n            // store for next use\n            obj.codepoints = this.codepoints\n            obj.index_map = this.index_map\n        }\n    }else if(obj instanceof String){\n        // string with surrogate pairs\n        this.string = obj.string\n        this.codepoints = obj.codepoints\n        this.index_map = obj.index_map\n    }else if(_b_.isinstance(obj, _b_.str)){ // str subclass\n        var so = new StringObj(obj.valueOf())\n        this.string = so.string\n        this.codepoints = so.codepoints\n    }else if(_b_.isinstance(obj, [_b_.bytes, _b_.bytearray])){\n        this.string = _b_.bytes.decode(obj, 'latin1')\n        this.codepoints = obj.source\n        this.type = \"bytes\"\n    }else if(_b_.isinstance(obj, _b_.memoryview)){\n        this.string = _b_.bytes.decode(obj.obj, 'latin1')\n        this.codepoints = obj.obj.source\n        this.type = \"bytes\"\n    }else if(obj.__class__ && obj.__class__.$buffer_protocol){\n        // eg array.array\n        this.codepoints = _b_.list.$factory(obj)\n        this.string = from_codepoint_list(this.codepoints, \"bytes\")\n        this.type = \"bytes\"\n    }else if(Array.isArray(obj)){\n        // list of codepoints\n        this.codepoints = obj\n    }else{\n        throw _b_.TypeError.$factory(\n            'expected string or bytes-like object')\n    }\n    this.length = this.codepoints.length\n}\n\nStringObj.prototype.substring = function(start, end){\n    // Returns a string\n    var s\n    if(this.string && this.index_map){\n        if(this.index_map[start] === undefined){\n            return ''\n        }\n        if(end === undefined){\n            return this.string.substr(this.index_map[start])\n        }\n        return this.string.substring(this.index_map[start],\n            this.index_map[end])\n    }\n    var codepoints,\n        res = ''\n    if(end === undefined){\n        codepoints = this.codepoints.slice(start)\n    }else{\n        codepoints = this.codepoints.slice(start, end)\n    }\n    return from_codepoint_list(codepoints, this.type)\n}\n\nStringObj.prototype.to_str = function(){\n    return from_codepoint_list(this.codepoints, this.type)\n}\n\nStringObj.from_codepoints = function(cps){\n    var res = new StringObj('')\n    res.codepoints = cps\n    for(var cp of cps){\n        res.string += _b_.chr(cp)\n    }\n    return res\n}\n\nfunction prepare(args){\n    // Check that all arguments are of the same type (string of bytes-like)\n    // Return an object with all attributes transformed into CodePoints\n    // instances\n    var res = {},\n        keys = Object.keys(args),\n        first = keys[0]\n    res[first] = new StringObj(args[first])\n    res.type = res[first].type\n    for(var key of keys.slice(1)){\n        res[key] = new StringObj(args[key])\n        if(res[key].type != res.type){\n            throw _b_.TypeError.$factory(`not the same type for ${first} and ${key}`)\n        }\n    }\n    return res\n}\n\nfunction subn(pattern, repl, string, count, flags){\n    // string is a StringObj instance\n    // pattern is either a Pattern instance or a StringObj instance\n    var res = '',\n        pos = 0,\n        nb_sub = 0\n\n    if(pattern instanceof StringObj){\n        pattern = compile(pattern, flags)\n    }\n    if(typeof repl != \"function\"){\n        var data1 = transform_repl({repl}, pattern)\n        repl1 = data1.repl1\n    }\n    pos = 0\n    for(var bmo of $module.finditer(BPattern.$factory(pattern), string.to_str()).js_gen){\n        // finditer yields instances of BMatchObject\n        var mo = bmo.mo // instance of MatchObject\n        res += from_codepoint_list(string.codepoints.slice(pos, mo.start),\n            string.type)\n        if(typeof repl == \"function\"){\n            res += $B.$call(repl)(bmo)\n        }else{\n            res += repl1\n        }\n        nb_sub++\n        pos = mo.end\n        if(pos >= string.length){\n            break\n        }\n        if(count != 0 && nb_sub >= count){\n            break\n        }\n    }\n    res += from_codepoint_list(string.codepoints.slice(pos),\n        string.type)\n    if(pattern.type === \"bytes\"){\n        res = _b_.str.encode(res, \"latin-1\")\n    }\n    return [res, nb_sub]\n}\n\n// escaped chars : '\\t\\n\\x0b\\x0c\\r #$&()*+-.?[\\\\]^{|}~'\nvar escaped = [9, 10, 11, 12, 13, 32, 35, 36, 38, 40, 41, 42, 43, 45, 46, 63,\n               91, 92, 93, 94, 123, 124, 125, 126]\n\nfunction* iterator(pattern, string, flags, original_string, pos, endpos){\n    var result = [],\n        pos = pos | 0\n    while(pos <= string.length){\n        var mo = match(pattern, string, pos, endpos)\n        if(mo){\n            yield BMO.$factory(mo)\n            if(mo.end == mo.start){\n                // If match has zero with, retry at the same position but\n                // with the flag no_zero_width set, to avoid infinite loops\n                mo = match(pattern, string, pos, endpos, true)\n                if(mo){\n                    yield BMO.$factory(mo)\n                    pos = mo.end\n                }else{\n                    pos++ // at least 1, else infinite loop\n                }\n            }else{\n                pos = mo.end\n            }\n        }else{\n            pos++\n        }\n    }\n    // does the pattern match the empty string ?\n    /*\n    var mo = match(pattern, new StringObj(''), 0, 0)\n    if(mo){\n        mo.start = mo.end = string.length\n        yield BMO.$factory(mo)\n    }\n    */\n    delete original_string.in_iteration\n}\n\nvar _debug = {value: false}\n\nfunction MO(node, pos, mo, len){\n    this.node = node\n    this.start = pos\n    this.mo = mo\n    this.nb_min = mo.nb_min\n    this.nb_max = mo.nb_max\n    this.len = len\n    this.nb = this.node.non_greedy ? mo.nb_min : mo.nb_max\n    this.end = pos + len * this.nb\n}\n\nMO.prototype.backtrack = function(string, groups){\n    if(this.node.non_greedy && this.nb < this.nb_max){\n        this.nb++\n        this.end = this.start + this.len * this.nb\n        return true\n    }else if(! this.node.non_greedy && this.nb > this.nb_min){\n        this.nb--\n        this.end = this.start + this.len * this.nb\n        return true\n    }else{\n        return false\n    }\n}\n\nfunction del_groups(groups, node){\n    if(node.num !== undefined){\n        delete groups[node.num]\n        groups.$last.splice(groups.$last.indexOf(node.num), 1)\n        if(node.name !== undefined){\n            delete groups[node.name]\n        }\n    }\n    for(var child of node.items){\n        if(child instanceof Group){\n            del_groups(groups, child)\n        }\n    }\n}\n\nfunction GroupMO(node, start, matches, string, groups, endpos){\n    this.node = node\n    this.start = start\n    this.matches = matches\n    this.string = string\n    this.end = matches.length > 0 ? $last(matches).end : start\n    this.endpos = endpos === undefined ? this.end : endpos\n    this.$groups = groups\n}\n\nGroupMO.prototype.backtrack = function(string, groups){\n    // Try backtracking in the last match\n    if(this.matches.length > 0){\n        var match = $last(this.matches),\n            mos = match.mos,\n            nb0 = mos.length\n        while(mos.length > 0){\n            var mo = mos.pop()\n            if(mo.backtrack()){\n                mos.push(mo)\n                if(this.node.num !== undefined){\n                    groups[this.node.num].end = mo.end\n                }\n                this.end = mo.end\n                return true\n            }\n        }\n    }\n    // Else, remove last match if possible\n    if(this.matches.length > this.node.repeat.min &&\n            this.matches.length >= 1){\n        this.matches.pop()\n        if(this.matches.length > 0){\n            this.end = $last(this.matches).end\n        }else{\n            // remove this group and its children from groups\n            del_groups(groups, this.node)\n            this.end = this.start\n        }\n        return true\n    }\n    return false\n}\n\nGroupMO.prototype.toString = function(){\n    var repr = _b_.repr(this.string.substring(this.start, this.end))\n    repr = repr.substring(0, 50)\n    return '<re.Match object; span=(' + this.start + ', ' + this.end +\n        '), match=' + repr + '>'\n}\n\nGroupMO.prototype.groups = function(_default){\n    var res = [],\n        groupobj = this.$groups\n\n    for(var key in this.node.$groups){\n        if(isFinite(key)){\n            res[key] = groupobj[key] === undefined ? _default :\n                this.string.substring(groupobj[key].start, groupobj[key].end)\n        }\n    }\n    res.shift()\n    return $B.fast_tuple(res)\n}\n\nvar BMO = $B.make_class(\"Match\",\n    function(mo){\n        return {\n            __class__: BMO,\n            mo\n        }\n    }\n)\n\nBMO.__getitem__ = function(){\n    var $ = $B.args(\"__getitem__\", 2, {self: null, key: null},\n                ['self', 'key'], arguments, {}, null, null),\n        self = $.self,\n        key = $.key\n    if(Array.isArray(key)){\n        throw _b_.IndexError.$factory(\"no such group\")\n    }\n    if(key == 0){\n        return self.mo.string.substring(self.mo.start, self.mo.end)\n    }\n    var match = self.mo.$groups[key]\n    if(match !== undefined){\n        return self.mo.string.substring(match.start, match.end)\n    }else if(self.mo.node.$groups[key] !== undefined){\n        return _b_.None\n    }\n    throw _b_.IndexError.$factory(\"no such group\")\n}\n\nBMO.__repr__ = BMO.__str__ =  function(self){\n    return self.mo.toString()\n}\n\nBMO.end = function(self){\n    var $ = $B.args('end', 2, {self: null, group: null}, ['self', 'group'],\n                arguments, {group: 0}, null, null)\n    var group = BMO.group(self, $.group)\n    if(group === _b_.None){\n        return -1\n    }else if($.group == 0){\n        return self.mo.end\n    }else{\n        return self.mo.$groups[$.group].end\n    }\n}\n\nBMO.endpos = {\n    __get__: function(self){\n        return self.mo.endpos\n    }\n}\n\nBMO.expand = function(){\n    var $ = $B.args(\"expand\", 2, {self: null, template: null},\n                ['self', 'template'], arguments, {}, null, null)\n    var data = {\n        repl: new StringObj($.template),\n    }\n    data = transform_repl(data, {groups: $.self.mo.node.$groups})\n    if(typeof data.repl == \"function\"){\n        return $B.$call(data.repl)(BMO.$factory($.self.mo))\n    }else{\n        return data.repl1\n    }\n}\n\nBMO.group = function(self){\n    var $ = $B.args(\"group\", 1, {self: null}, ['self'], arguments,\n                {}, 'args', null),\n            self = $.self,\n            args = $.args\n    if(args.length == 0){\n        args[0] = 0\n    }\n    var groupobj = self.mo.$groups,\n        result = []\n    for(var group_id of args){\n        if($B.rich_comp('__eq__', group_id, 0)){\n            result.push(self.mo.string.substring(self.mo.start, self.mo.end))\n            continue\n        }\n        try{\n            // Convert group_id to int if possible\n            group_id = $B.PyNumber_Index(group_id) // in py_utils.js\n        }catch(err){\n            // group_id can be an identifier\n        }\n        if(self.mo.node.$groups[group_id] === undefined){\n            throw _b_.IndexError.$factory(\"no such group\")\n        }\n        var group = groupobj[group_id] // found in match\n        result.push(group === undefined ?\n            _b_.None :\n            self.mo.string.substring(group.start, group.end))\n    }\n    if(args.length == 1){\n        return result[0]\n    }\n    return $B.fast_tuple(result)\n}\n\nBMO.groupdict = function(){\n    /*\n    Return a dictionary containing all the named subgroups of the match, keyed\n    by the subgroup name. The default argument is used for groups that did not\n    participate in the match; it defaults to None.\n    */\n    var $ = $B.args(\"groupdict\", 2, {self: null, default: null},\n                ['self', 'default'], arguments, {default: _b_.None},\n                null, null),\n        self = $.self,\n        groupobj = $.self.mo.$groups,\n        d = $B.empty_dict()\n    for(var key in $.self.mo.node.$groups){\n        if(! isFinite(key)){\n            var value = groupobj[key] === undefined ? $.default :\n                    groupobj[key]\n            if(value !== $.default){\n                value = self.mo.string.substring(value.start, value.end)\n            }\n            _b_.dict.$setitem(d, key, value)\n        }\n    }\n    d.__class__ = GroupDict\n    return d\n}\n\nBMO.groups = function(self){\n    var $ = $B.args(\"group\", 2, {self: null, default: null},\n                ['self', 'default'], arguments,\n                {default: _b_.None}, null, null),\n            self = $.self,\n            _default = $.default\n    return self.mo.groups(_default)\n}\n\nBMO.lastindex = {\n    /* The integer index of the last matched capturing group, or None if no\n       group was matched at all.\n    */\n    __get__: function(self){\n        var last = self.mo.$groups.$last\n        if(last.length == 0){\n            return _b_.None\n        }\n        return parseInt($last(last))\n    }\n}\n\nBMO.lastgroup = {\n    /* The name of the last matched capturing group, or None if the group\n       didn't have a name, or if no group was matched at all.\n    */\n    __get__: function(self){\n        var lastindex = BMO.lastindex.__get__(self)\n        if(lastindex === _b_.None){\n            return _b_.None\n        }\n        var group = self.mo.node.$groups[lastindex],\n            name = group.item.name\n        return name === undefined ? _b_.None : name\n    }\n}\n\nBMO.pos = {\n    __get__: function(self){\n        return self.mo.start\n    }\n}\n\nBMO.re = {\n    __get__: function(self){\n        return self.mo.node.pattern\n    }\n}\n\nBMO.regs = {\n    __get__: function(self){\n        var res = [$B.fast_tuple([self.mo.start, self.mo.end])]\n        for(var group_num in self.mo.node.$groups){\n            if(isFinite(group_num)){\n                var group = self.mo.node.$groups[group_num].item\n                // group.pattern includes the opening and closing brackets\n                res.push($B.fast_tuple([group.pos,\n                    group.pos + group.pattern.length - 2]))\n            }\n        }\n        return $B.fast_tuple(res)\n    }\n}\n\nBMO.span = function(){\n    /*\n    Match.span([group])\n\n    For a match m, return the 2-tuple (m.start(group), m.end(group)). Note\n    that if group did not contribute to the match, this is (-1, -1). group\n    defaults to zero, the entire match.\n    */\n    var $ = $B.args(\"span\", 2, {self: null, group: null},\n                ['self', 'group'], arguments,\n                {group: 0}, null, null),\n            self = $.self,\n            group = $.group\n    if(group == 0){\n        return $B.fast_tuple([self.mo.start, self.mo.end])\n    }\n    var span = self.mo.$groups[group]\n    if(span === undefined){\n        return $B.fast_tuple([-1, -1])\n    }\n    return $B.fast_tuple([span.start, span.end])\n}\n\nBMO.start = function(self){\n    var $ = $B.args('end', 2, {self: null, group: null}, ['self', 'group'],\n                arguments, {group: 0}, null, null)\n    var group = BMO.group(self, $.group)\n    if(group === _b_.None){\n        return -1\n    }else if($.group == 0){\n        return self.mo.start\n    }else{\n        return self.mo.$groups[$.group].start\n    }\n}\n\nBMO.string = {\n    __get__: function(self){\n        return self.mo.string.to_str()\n    }\n}\n\n$B.set_func_names(BMO, 're')\n\nfunction test_after_min_repeat_one(items, pattern, string, pos,\n                            endpos, no_zero_width, groups){\n\n}\n\nfunction log(){\n    if(_debug.value){\n        console.log.apply(null, arguments)\n    }\n}\n\nfunction match(pattern, string, pos, endpos, no_zero_width, groups){\n    // Follow the pattern tree structure\n    log('match pattern', pattern.text, 'pos', pos, string.substring(pos))\n    var string1 = string\n    if(endpos !== undefined){\n        if(endpos < pos){\n            return false\n        }else if(endpos < string.length){\n            string1 = new StringObj('')\n            string1.codepoints = string.codepoints.slice(0, endpos)\n            string1.length = endpos\n        }\n    }\n    if(pattern.node instanceof Node){\n        show(pattern.node)\n    }\n    if(groups === undefined){\n        groups = {$last:[]}\n    }\n    if(pattern.text === undefined){\n        console.log('pas de texte', pattern)\n    }\n    var node = pattern.node,\n        mo\n    if(node.items){\n        // node is either a Choice between several items, or a sequence of\n        // items\n        if(node instanceof Choice){\n            for(var subgroup of subgroups(node)){\n                //delete groups[subgroup]\n            }\n            mo = false\n            for(var _case of node.items){\n                mo = match({node: _case, text: _case.text}, string, pos,\n                    endpos, no_zero_width, groups)\n                if(mo){\n                    return mo\n                }\n            }\n            return false\n        }else{\n            // sequence of items\n            node.repeat = node.repeat === undefined ? {min: 1, max: 1} :\n                node.repeat\n            var start = pos,\n                nb_repeat = 0,\n                nb_zerolength_repeat = 0,\n                matches = [],\n                mos,\n                match_start,\n                empty_matches = {}\n            // loop until we get enough repetitions\n            while(true){\n                if(empty_matches[pos]){\n                    // no use trying again\n                    return matches.length == 0 ? false :\n                       new GroupMO(node, start, matches, string, groups,\n                           endpos)\n                }\n                var initial_groups = Object.keys(groups)\n                mos = []\n                match_start = pos\n                log(\"pattern\", pattern.text, \"loop in group match, match start\", match_start)\n                var i = 0\n                while(i < node.items.length){\n                    var item = node.items[i]\n                    log('item', i, '/', node.items.length - 1,\n                        'of pattern', pattern.text)\n                    var mo = match({node: item, text: item + ''}, string, pos,\n                        endpos, no_zero_width, groups)\n                    if(mo){\n                        if(item instanceof Group &&\n                                item.type == \"lookahead_assertion\"){\n                            log(\"lookahead assertion\", item, \"succeeds\")\n                        }else{\n                            mos.push(mo)\n                            log('item ' + item, 'succeeds, mo', mo, mos, 'groups', groups)\n                            pos = mo.end\n                        }\n                        i++\n                    }else if(false && item instanceof Group &&\n                            item.type == \"negative_lookahead_assertion\"){\n                        log(\"negative lookahead assertion\", item, \"fails : ok !\")\n                        i++\n                    }else{\n                        log('item ' + item, 'of group fails, nb_repeat',\n                            nb_repeat, 'node repeat', node.repeat)\n                        var backtrack = false\n                        while(mos.length > 0){\n                            var mo = mos.pop()\n                            if(mo.backtrack === undefined){\n                                log('pas de backtrack pour', mo)\n                            }\n                            log('try backtrack on mo', mo)\n                            if(mo.backtrack(string, groups)){\n                                log('can backtrack, mo', mo)\n                                mos.push(mo)\n                                i = mos.length\n                                log('mos', mos, 'restart at item', i)\n                                pos = mo.end\n                                backtrack = true\n                                break\n                            }\n                        }\n                        if(backtrack){\n                            log('backtrack ok')\n                            continue\n                        }else{\n                            if(node.type == \"negative_lookahead_assertion\"){\n                                // If a negative lookahead assertion fails,\n                                // return a match\n                                return new GroupMO(node, start, matches,\n                                    string, groups, endpos)\n                            }\n                            if(nb_repeat == 0){\n                                // remove the groups introduced before\n                                // reaching this point\n                                for(var key in groups){\n                                    if(initial_groups.indexOf(key) == -1){\n                                        delete groups[key]\n                                    }\n                                }\n                            }\n                            if(nb_repeat >= node.repeat.min){\n                                log(\"enough repetitions for node\", node)\n                                if(node.type == \"negative_lookahead_assertion\"){\n                                    return false\n                                }\n                                return new GroupMO(node, start, matches, string,\n                                    groups, endpos)\n                            }\n                            return false\n                        }\n                    }\n                }\n                if(node.type == \"negative_lookahead_assertion\"){\n                    // If a negative lookahead succeeds, return false\n                    return false\n                }\n                nb_repeat++\n                if(pos > match_start){\n                    nb_zerolength_repeat = 0\n                }else{\n                    nb_zerolength_repeat++\n                    empty_matches[pos] = true\n                }\n                matches.push({start: match_start, end: pos, mos})\n                if(node.num !== undefined){\n                    groups[node.num] = $last(matches)\n                    if(node.name !== undefined){\n                        groups[node.name] = groups[node.num]\n                    }\n                    if(node.num != $last(groups.$last)){\n                        var ix = groups.$last.indexOf(node.num)\n                        if(ix > -1){\n                            groups.$last.splice(ix, 1)\n                        }\n                        groups.$last.push(node.num)\n                    }\n                }\n                if(nb_repeat >= node.repeat.max){\n                    var res = new GroupMO(node, start, matches, string,\n                        groups, endpos)\n                    if(res.start == res.end && no_zero_width){\n                        // no_zero_width is set when previous match in\n                        // iterator() had length 0; avoids infinite loops\n                        return false\n                    }\n                    return res\n                }\n                log('loop on group', pattern.text, 'nb repeats', nb_repeat,\n                    'nb zero length', nb_zerolength_repeat)\n                if(nb_zerolength_repeat == 65535){\n                    return matches.length == 0 ? false :\n                       new GroupMO(node, start, matches, string, groups,\n                           endpos)\n                }\n            }\n        }\n    }else{\n        if(node.match === undefined){\n            console.log('pas de match', node)\n        }\n        var mo = node.match(string1, pos, groups)\n        log(node, \"mo\", mo)\n        if(mo){\n            var len = mo.group_len === undefined ? 1 : mo.group_len,\n                ix = node.non_greedy ? mo.nb_min : mo.nb_max,\n                end = pos + len * ix\n            return new MO(node, pos, mo, len)\n        }else{\n            return false\n        }\n    }\n}\n\nvar $module = {\n    cache: cache,\n    compile: function(){\n        var $ = $B.args(\"compile\", 2, {pattern: null, flags: null},\n                    ['pattern', 'flags'], arguments, {flags: no_flag},\n                    null, null)\n        if($.pattern && $.pattern.__class__ === BPattern){\n            if($.flags !== no_flag){\n                throw _b_.ValueError.$factory(\n                    \"cannot process flags argument with a compiled pattern\")\n            }\n            return $.pattern\n        }\n        $.pattern = check_pattern_flags($.pattern, $.flags)\n        var data = prepare({pattern: $.pattern})\n        if(typeof $.flags == \"number\"){\n            $.flags = Flag.$factory($.flags)\n        }\n        var jspat = compile(data.pattern, $.flags)\n        return BPattern.$factory(jspat)\n    },\n    error: error,\n    escape: function(){\n        var $ = $B.args(\"escape\", 1, {pattern: null}, ['pattern'], arguments,\n                    {}, null, null),\n            data = prepare({pattern: $.pattern}),\n            pattern = data.pattern,\n            res = []\n        for(var cp of pattern.codepoints){\n            if(escaped.indexOf(cp) > -1){\n                res.push(ord('\\\\'))\n            }\n            res.push(cp)\n        }\n        res = from_codepoint_list(res, data.type)\n        if(data.type == \"bytes\"){\n            res = _b_.str.encode(res, 'latin1')\n        }\n        return res\n    },\n    findall: function(){\n        /* Return all non-overlapping matches of pattern in string, as a list\n           of strings. The string is scanned left-to-right, and matches are\n           returned in the order found. If one or more groups are present in\n           the pattern, return a list of groups; this will be a list of tuples\n           if the pattern has more than one group. Empty matches are included\n           in the result.\n        */\n        var $ = $B.args(\"findall\", 3,\n                    {pattern: null, string: null, flags: null},\n                    ['pattern', 'string', 'flags'], arguments,\n                    {flags: no_flag}, null, null),\n                pattern = $.pattern,\n                string = $.string,\n                flags = $.flags,\n                data\n        pattern = check_pattern_flags(pattern, flags)\n        if(pattern.__class__ === BPattern){\n            data = prepare({string})\n        }else{\n            data = prepare({string, pattern})\n            pattern = BPattern.$factory(compile(data.pattern, flags))\n        }\n        if(data.type === \"str\"){\n            function conv(s){\n                return s === EmptyString ? '' : s\n            }\n        }else{\n            function conv(s){\n                return string2bytes(s)\n            }\n        }\n\n        var iter = $module.finditer.apply(null, arguments).js_gen,\n            res = []\n        while(true){\n            var next = iter.next()\n            if(next.done){\n                return res\n            }\n            var bmo = next.value,\n                mo = bmo.mo,\n                groups = BMO.groups(bmo)\n\n            // replace None by the empty string\n            for(var i = 0, len = groups.length; i < len; i++){\n                groups[i] = groups[i] === _b_.None ? \"\" : groups[i]\n            }\n            if(groups.length > 0){\n                if(groups.length == 1){\n                    res.push(groups[0])\n                }else{\n                    res.push($B.fast_tuple(groups))\n                }\n            }else{\n                res.push(mo.string.substring(mo.start, mo.end))\n            }\n        }\n        console.log(\"end findall\")\n    },\n    finditer: function(){\n        var $ = $B.args(\"finditer\", 3,\n                    {pattern: null, string: null, flags: null},\n                    ['pattern', 'string', 'flags'], arguments,\n                    {flags: no_flag}, null, null),\n                pattern = $.pattern,\n                string = $.string,\n                flags = $.flags\n        if(_b_.isinstance(string, [_b_.bytearray, _b_.memoryview])){\n            string.in_iteration = true\n        }\n        var original_string = string,\n            data\n        pattern = check_pattern_flags(pattern, flags)\n        if(pattern.__class__ === BPattern){\n            data = prepare({string})\n            flags = pattern.flags\n        }else{\n            data = prepare({string, pattern})\n            pattern = BPattern.$factory(compile(data.pattern, flags))\n        }\n        if(pattern.__class__ !== BPattern){\n            throw Error(\"pattern not a Python object\")\n        }\n        return $B.generator.$factory(iterator)(pattern.$pattern, data.string,\n            flags, original_string)\n    },\n    fullmatch: function(){\n        var bmo = $module.match.apply(null, arguments)\n        if(bmo !== _b_.None){\n            if(bmo.mo.string.codepoints.length != bmo.mo.end - bmo.mo.start){\n                return _b_.None\n            }else{\n                return bmo\n            }\n        }\n        return _b_.None\n    },\n    Match: BMO,\n    match: function(){\n        var $ = $B.args(\"match\", 3, {pattern: null, string: null, flags: null},\n                    ['pattern', 'string', 'flags'], arguments,\n                    {flags: no_flag}, null, null),\n                pattern = $.pattern,\n                string = $.string,\n                flags = $.flags\n        pattern = check_pattern_flags(pattern, flags)\n        var data\n        if(pattern.__class__ === BPattern){\n            data = prepare({string})\n            pattern = pattern.$pattern\n        }else{\n            data = prepare({pattern, string})\n            pattern = compile(data.pattern, flags)\n        }\n        var res = match(pattern, data.string, 0)\n        return res === false ? _b_.None : BMO.$factory(res)\n    },\n    Pattern: BPattern,\n    purge: function(){\n        var $ = $B.args(\"purge\", 0, {}, [], arguments, {}, null, null)\n        cache.clear()\n        return _b_.None\n    },\n    search: function(){\n        var $ = $B.args(\"search\", 3, {pattern: null, string: null, flags: null},\n                    ['pattern', 'string', 'flags'], arguments,\n                    {flags: no_flag}, null, null),\n                pattern = $.pattern,\n                string = $.string,\n                flags = $.flags,\n                data\n        pattern = check_pattern_flags(pattern, flags)\n        if(pattern.__class__ === BPattern){\n            data = prepare({string})\n        }else{\n            data = prepare({string, pattern})\n            pattern = BPattern.$factory(compile(data.pattern, flags))\n        }\n        data.pattern = pattern\n        // optimization\n        if(pattern.$pattern.fixed_length !== false &&\n                isFinite(pattern.$pattern.fixed_length) &&\n                pattern.pattern.endsWith('$') &&\n                ! (pattern.flags.value & MULTILINE.value)){\n            var mo = match(data.pattern.$pattern, data.string,\n                data.string.length - pattern.$pattern.fixed_length)\n            if(mo){\n                return BMO.$factory(mo)\n            }\n            return _b_.None\n        }\n        var pos = 0\n        while(pos < data.string.codepoints.length){\n            var mo = match(data.pattern.$pattern, data.string, pos)\n            if(mo){\n                return BMO.$factory(mo)\n            }else{\n                pos++\n            }\n        }\n        return _b_.None\n    },\n    set_debug: function(){\n        _debug.value = true\n    },\n    split: function(){\n        var $ = $B.args(\"split\", 4,\n                    {pattern: null, string: null, maxsplit: null, flags: null},\n                    ['pattern', 'string', 'maxsplit', 'flags'],\n                    arguments, {maxsplit: 0, flags: no_flag}, null, null)\n        var res = [],\n            pattern = $.pattern,\n            string = $.string,\n            flags = $.flags,\n            pos = 0,\n            nb_split = 0,\n            data\n        if(pattern.__class__ !== BPattern){\n            data = prepare({pattern, string})\n            pattern = BPattern.$factory(compile(data.pattern, flags))\n        }else{\n            data = {pattern, string}\n        }\n        for(var bmo of $module.finditer(pattern, $.string).js_gen){\n            var mo = bmo.mo, // finditer returns instances of BMO\n                groupobj = mo.$groups\n            res.push(data.string.substring(pos, mo.start))\n            for(var key in mo.node.$groups){\n                if(isFinite(key)){\n                    if(groupobj[key] !== undefined){\n                        res.push(data.string.substring(groupobj[key].start,\n                            groupobj[key].end))\n                    }else{\n                        res.push(_b_.None)\n                    }\n                }\n            }\n            nb_split++\n            pos = mo.end\n            if(pos >= $.string.length){\n                break\n            }\n            if($.maxsplit != 0 && nb_split >= $.maxsplit){\n                break\n            }\n        }\n        res.push(data.string.substring(pos))\n        if(data.type === \"bytes\"){\n            res = res.map(function(x){return _b_.str.encode(x, \"latin-1\")})\n        }\n        return res\n    },\n    sub: function(){\n        var $ = $B.args(\"sub\", 5,\n                {pattern: null, repl: null, string: null, count: null, flags: null},\n                ['pattern', 'repl', 'string', 'count', 'flags'],\n                arguments, {count: 0, flags: no_flag}, null, null),\n            pattern = $.pattern,\n            repl = $.repl,\n            string = $.string,\n            count = $.count,\n            flags = $.flags,\n            data\n        check_pattern_flags(pattern, flags)\n        if(typeof repl != \"function\"){\n            if(pattern.__class__ != BPattern){\n                data = prepare({pattern, string, repl})\n                pattern = compile(data.pattern, flags)\n            }else{\n                data = prepare({string, repl})\n                flags = pattern.flags\n                pattern = pattern.$pattern\n            }\n            data = transform_repl(data, pattern)\n        }else{\n            if(pattern.__class__ != BPattern){\n                data = prepare({pattern, string})\n                pattern = compile(data.pattern, flags)\n            }else{\n                data = prepare({string})\n                flags = pattern.flags\n                pattern = pattern.$pattern\n            }\n            data.repl = repl\n        }\n        return subn(pattern, data.repl, data.string, count, flags)[0]\n    },\n    subn: function(){\n        var $ = $B.args(\"sub\", 5,\n                {pattern: null, repl: null, string: null, count: null, flags: null},\n                ['pattern', 'repl', 'string', 'count', 'flags'],\n                arguments, {count: 0, flags: no_flag}, null, null),\n            pattern = $.pattern,\n            repl = $.repl,\n            string = $.string,\n            count = $.count,\n            flags = $.flags,\n            data\n        if(pattern.__class__ != BPattern){\n            data = prepare({pattern, repl, string})\n        }else{\n            data = prepare({repl, string})\n            data.pattern = pattern.$pattern\n        }\n        return $B.fast_tuple(subn(data.pattern, data.repl, data.string, count,\n            flags))\n    }\n\n}\n\nvar ASCII = $module.A = $module.ASCII = Flag.$factory(256)\nvar IGNORECASE = $module.I = $module.IGNORECASE = Flag.$factory(2)\nvar LOCALE = $module.L = $module.LOCALE = Flag.$factory(4)\nvar MULTILINE = $module.M = $module.MULTILINE = Flag.$factory(8)\nvar DOTALL = $module.S = $module.DOTALL = Flag.$factory(16)\nvar U = $module.U = $module.UNICODE = Flag.$factory(32)\nvar VERBOSE = $module.X = $module.VERBOSE = Flag.$factory(64)\n$module.cache = cache\n\nvar inline_flags = {\n    i: IGNORECASE,\n    L: LOCALE,\n    m: MULTILINE,\n    s: DOTALL,\n    u: U,\n    x: VERBOSE,\n    a: ASCII\n}\n\nvar flag_names = {\n    i: 'IGNORECASE',\n    L: 'LOCALE',\n    m: 'MULTILINE',\n    s: 'DOTALL',\n    u: 'U',\n    x: 'VERBOSE',\n    a: 'ASCII'\n}\n"], "random": [".js", "// Javascript implementation of the random module\n// Based on Ian Bicking's implementation of the Mersenne twister\n\nvar $module = (function($B){\n\nvar _b_ = $B.builtins,\n    i\n\nvar VERSION = 3\n\n// Code copied from https://github.com/ianb/whrandom/blob/master/mersenne.js\n// by Ian Bicking\n\n// this program is a JavaScript version of Mersenne Twister,\n// a straight conversion from the original program, mt19937ar.c,\n// translated by y. okada on july 17, 2006.\n// and modified a little at july 20, 2006, but there are not any substantial differences.\n// modularized by Ian Bicking, March 25, 2013 (found original version at http://www.math.sci.hiroshima-u.ac.jp/~m-mat/MT/VERSIONS/JAVASCRIPT/java-script.html)\n// in this program, procedure descriptions and comments of original source code were not removed.\n// lines commented with //c// were originally descriptions of c procedure. and a few following lines are appropriate JavaScript descriptions.\n// lines commented with /* and */ are original comments.\n// lines commented with // are additional comments in this JavaScript version.\n/*\n   A C-program for MT19937, with initialization improved 2002/1/26.\n   Coded by Takuji Nishimura and Makoto Matsumoto.\n\n   Before using, initialize the state by using init_genrand(seed)\n   or init_by_array(init_key, key_length).\n\n   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,\n   All rights reserved.\n\n   Redistribution and use in source and binary forms, with or without\n   modification, are permitted provided that the following conditions\n   are met:\n\n     1. Redistributions of source code must retain the above copyright\n        notice, this list of conditions and the following disclaimer.\n\n     2. Redistributions in binary form must reproduce the above copyright\n        notice, this list of conditions and the following disclaimer in the\n        documentation and/or other materials provided with the distribution.\n\n     3. The names of its contributors may not be used to endorse or promote\n        products derived from this software without specific prior written\n        permission.\n\n   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n   \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR\n   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,\n   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,\n   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR\n   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF\n   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING\n   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS\n   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n\n\n   Any feedback is very welcome.\n   http://www.math.sci.hiroshima-u.ac.jp/~m-mat/MT/emt.html\n   email: m-mat @ math.sci.hiroshima-u.ac.jp (remove space)\n*/\n\nfunction RandomStream(seed) {\n    /*jshint bitwise:false */\n    /* Period parameters */\n    //c//#define N 624\n    //c//#define M 397\n    //c//#define MATRIX_A 0x9908b0dfUL   /* constant vector a */\n    //c//#define UPPER_MASK 0x80000000UL /* most significant w-r bits */\n    //c//#define LOWER_MASK 0x7fffffffUL /* least significant r bits */\n    var N = 624\n    var M = 397\n    var MATRIX_A = 0x9908b0df   /* constant vector a */\n    var UPPER_MASK = 0x80000000 /* most significant w-r bits */\n    var LOWER_MASK = 0x7fffffff /* least significant r bits */\n    //c//static unsigned long mt[N]; /* the array for the state vector  */\n    //c//static int mti=N+1; /* mti==N+1 means mt[N] is not initialized */\n    var mt = new Array(N)   /* the array for the state vector  */\n    var mti = N + 1           /* mti==N+1 means mt[N] is not initialized */\n\n    function unsigned32(n1){\n        // returns a 32-bits unsiged integer from an operand to which applied a\n        // bit operator.\n        return n1 < 0 ? (n1 ^ UPPER_MASK) + UPPER_MASK : n1\n    }\n\n    function subtraction32(n1, n2){\n    // emulates lowerflow of a c 32-bits unsiged integer variable, instead of\n    // the operator -. these both arguments must be non-negative integers\n    // expressible using unsigned 32 bits.\n        return n1 < n2 ? unsigned32((0x100000000 - (n2 - n1)) & 0xffffffff) :\n          n1 - n2\n    }\n\n    function addition32(n1, n2){\n        // emulates overflow of a c 32-bits unsiged integer variable, instead of\n        // the operator +. these both arguments must be non-negative integers\n        // expressible using unsigned 32 bits.\n        return unsigned32((n1 + n2) & 0xffffffff)\n    }\n\n    function multiplication32(n1, n2){\n        // emulates overflow of a c 32-bits unsiged integer variable, instead of the\n        // operator *. these both arguments must be non-negative integers\n        // expressible using unsigned 32 bits.\n        var sum = 0\n        for (var i = 0; i < 32; ++i){\n            if((n1 >>> i) & 0x1){\n                sum = addition32(sum, unsigned32(n2 << i))\n            }\n        }\n        return sum\n    }\n\n    /* initializes mt[N] with a seed */\n    //c//void init_genrand(unsigned long s)\n    function init_genrand(s) {\n        //c//mt[0]= s & 0xffffffff;\n        mt[0] = unsigned32(s & 0xffffffff)\n        for(mti = 1; mti < N; mti++){\n            mt[mti] =\n                //c//(1812433253 * (mt[mti-1] ^ (mt[mti-1] >> 30)) + mti);\n                addition32(multiplication32(1812433253,\n                    unsigned32(mt[mti - 1] ^ (mt[mti - 1] >>> 30))), mti)\n            /* See Knuth TAOCP Vol2. 3rd Ed. P.106 for multiplier. */\n            /* In the previous versions, MSBs of the seed affect   */\n            /* only MSBs of the array mt[].                        */\n            /* 2002/01/09 modified by Makoto Matsumoto             */\n            //c//mt[mti] &= 0xffffffff;\n            mt[mti] = unsigned32(mt[mti] & 0xffffffff);\n            /* for >32 bit machines */\n        }\n    }\n\n    /* initialize by an array with array-length */\n    /* init_key is the array for initializing keys */\n    /* key_length is its length */\n    /* slight change for C++, 2004/2/26 */\n    //c//void init_by_array(unsigned long init_key[], int key_length)\n    function init_by_array(init_key, key_length) {\n        //c//int i, j, k;\n        var i, j, k\n        init_genrand(19650218)\n        i = 1\n        j = 0\n        k = (N > key_length ? N : key_length)\n        for(; k; k--){\n          //c//mt[i] = (mt[i] ^ ((mt[i-1] ^ (mt[i-1] >> 30)) * 1664525))\n          //c// + init_key[j] + j; /* non linear */\n          mt[i] = addition32(\n              addition32(unsigned32(mt[i] ^\n                  multiplication32(unsigned32(mt[i - 1] ^ (mt[i - 1] >>> 30)),\n                  1664525)),\n              init_key[j]), j)\n          mt[i] =\n              //c//mt[i] &= 0xffffffff; /* for WORDSIZE > 32 machines */\n              unsigned32(mt[i] & 0xffffffff)\n          i++\n          j++\n          if(i >= N){mt[0] = mt[N - 1]; i = 1}\n          if(j >= key_length){j = 0}\n        }\n        for(k = N - 1; k; k--){\n            //c//mt[i] = (mt[i] ^ ((mt[i-1] ^ (mt[i-1] >> 30)) * 1566083941))\n            //c//- i; /* non linear */\n            mt[i] = subtraction32(\n                unsigned32(\n                    (mt[i]) ^\n                        multiplication32(\n                            unsigned32(mt[i - 1] ^ (mt[i - 1] >>> 30)),\n                    1566083941)),\n                i\n            )\n            //c//mt[i] &= 0xffffffff; /* for WORDSIZE > 32 machines */\n            mt[i] = unsigned32(mt[i] & 0xffffffff)\n            i++\n            if(i >= N){mt[0] = mt[N - 1]; i = 1}\n        }\n        mt[0] = 0x80000000; /* MSB is 1; assuring non-zero initial array */\n    }\n\n    /* generates a random number on [0,0xffffffff]-interval */\n    //c//unsigned long genrand_int32(void)\n    function genrand_int32() {\n        //c//unsigned long y;\n        //c//static unsigned long mag01[2]={0x0UL, MATRIX_A};\n        var y;\n        var mag01 = [0x0, MATRIX_A];\n        /* mag01[x] = x * MATRIX_A  for x=0,1 */\n\n        if(mti >= N){ /* generate N words at one time */\n            //c//int kk;\n            var kk\n\n            if(mti == N + 1){   /* if init_genrand() has not been called, */\n              init_genrand(Date.now()) /* a default initial seed is used */\n            }\n\n            for(kk = 0; kk < N - M; kk++){\n              //c//y = (mt[kk]&UPPER_MASK)|(mt[kk+1]&LOWER_MASK);\n              //c//mt[kk] = mt[kk+M] ^ (y >> 1) ^ mag01[y & 0x1];\n              y = unsigned32((mt[kk]&UPPER_MASK) | (mt[kk + 1]&LOWER_MASK))\n              mt[kk] = unsigned32(mt[kk + M] ^ (y >>> 1) ^ mag01[y & 0x1])\n            }\n            for(;kk < N - 1; kk++){\n              //c//y = (mt[kk]&UPPER_MASK)|(mt[kk+1]&LOWER_MASK);\n              //c//mt[kk] = mt[kk+(M-N)] ^ (y >> 1) ^ mag01[y & 0x1];\n              y = unsigned32((mt[kk]&UPPER_MASK) | (mt[kk + 1]&LOWER_MASK))\n              mt[kk] = unsigned32(mt[kk + (M - N)] ^ (y >>> 1) ^ mag01[y & 0x1])\n            }\n            //c//y = (mt[N-1]&UPPER_MASK)|(mt[0]&LOWER_MASK);\n            //c//mt[N-1] = mt[M-1] ^ (y >> 1) ^ mag01[y & 0x1];\n            y = unsigned32((mt[N - 1] & UPPER_MASK) | (mt[0] & LOWER_MASK))\n            mt[N - 1] = unsigned32(mt[M - 1] ^ (y >>> 1) ^ mag01[y & 0x1])\n            mti = 0\n        }\n\n        y = mt[mti++]\n\n        /* Tempering */\n        //c//y ^= (y >> 11);\n        //c//y ^= (y << 7) & 0x9d2c5680;\n        //c//y ^= (y << 15) & 0xefc60000;\n        //c//y ^= (y >> 18);\n        y = unsigned32(y ^ (y >>> 11))\n        y = unsigned32(y ^ ((y << 7) & 0x9d2c5680))\n        y = unsigned32(y ^ ((y << 15) & 0xefc60000))\n        y = unsigned32(y ^ (y >>> 18))\n\n        return y\n    }\n\n    /* generates a random number on [0,0x7fffffff]-interval */\n    //c//long genrand_int31(void)\n    function genrand_int31(){\n        //c//return (genrand_int32()>>1);\n        return (genrand_int32()>>>1)\n    }\n\n    /* generates a random number on [0,1]-real-interval */\n    //c//double genrand_real1(void)\n    function genrand_real1(){\n        return genrand_int32()*(1.0/4294967295.0)\n        /* divided by 2^32-1 */\n    }\n\n    /* generates a random number on [0,1)-real-interval */\n    //c//double genrand_real2(void)\n    function genrand_real2(){\n        return genrand_int32() * (1.0 / 4294967296.0)\n        /* divided by 2^32 */\n    }\n\n    /* generates a random number on (0,1)-real-interval */\n    //c//double genrand_real3(void)\n    function genrand_real3() {\n        return ((genrand_int32()) + 0.5) * (1.0 / 4294967296.0)\n        /* divided by 2^32 */\n    }\n\n    /* generates a random number on [0,1) with 53-bit resolution*/\n    //c//double genrand_res53(void)\n    function genrand_res53() {\n        //c//unsigned long a=genrand_int32()>>5, b=genrand_int32()>>6;\n        var a = genrand_int32() >>> 5,\n            b = genrand_int32() >>> 6\n        return (a * 67108864.0 + b) * (1.0 / 9007199254740992.0)\n    }\n    /* These real versions are due to Isaku Wada, 2002/01/09 added */\n\n    var random = genrand_res53\n\n    random.seed = function(seed){\n        if(seed === undefined){\n            seed = Date.now()\n        }\n        /*\n        if(Array.isArray(seed)){ // Brython-specific, for debugging\n            init_by_array(seed, seed.length)\n            return\n        }\n        */\n        var keys = []\n        if(typeof seed == \"number\" || _b_.isinstance(seed, _b_.int)){\n            var int32 = Math.pow(2, 32),\n                int32_1 = int32 - 1\n            // Transform to long integer\n            seed = $B.long_int.$factory(seed)\n            // Take abs(seed)\n            seed = $B.long_int.__abs__(seed)\n            // decomposition in factors of 2 ** 32\n            while($B.long_int.__ge__(seed, int32_1)){\n                var dm = _b_.divmod(seed, int32)\n                // Rest is a JS number (< 2 ** 32)\n                keys.push(dm[1])\n                // Quotient is either a JS number or a instance of long_int\n                // but seed must be long_int\n                seed = dm[0].value === undefined ?\n                    $B.long_int.$factory(dm[0]) : dm[0]\n            }\n            keys.push(parseInt(seed.value))\n        }else if(typeof seed != \"number\"){\n            seed = parseInt(seed, 10)\n            if((seed !== 0 && ! seed) || isNaN(seed)){\n                throw _b_.ValueError.$factory(\"Bad seed: \" +\n                    _b_.str.$factory(seed))\n            }\n        }\n        init_by_array(keys, keys.length)\n    }\n\n    random.seed(seed)\n\n    random.int31 = genrand_int31\n    random.real1 = genrand_real1\n    random.real2 = genrand_real2\n    random.real3 = genrand_real3\n    random.res53 = genrand_res53\n\n    // Added for compatibility with Python\n    random.getstate = function(){\n        return $B.fast_tuple([VERSION,\n            $B.fast_tuple(mt.concat([mti]))\n            , _b_.None])\n    }\n\n    random.setstate = function(state){\n        mt = state[1].slice(0, state[1].length - 1)\n        mti = state[1][state[1].length - 1]\n    }\n\n    return random\n\n}\n\n// magic constants\n\nvar NV_MAGICCONST = 4 * Math.exp(-0.5)/Math.sqrt(2),\n    gauss_next = null,\n    NV_MAGICCONST = 1.71552776992141,\n    TWOPI = 6.28318530718,\n    LOG4 = 1.38629436111989,\n    SG_MAGICCONST = 2.50407739677627,\n    VERSION = VERSION\n\nvar Random = $B.make_class(\"Random\",\n    function(){\n        return {\n            __class__: Random,\n            _random: RandomStream(Date.now())\n        }\n    }\n)\n\nRandom._randbelow = function(self, x){\n    return Math.floor(x * self._random())\n}\n\nRandom._urandom = function(self, n){\n    /*\n    urandom(n) -> str\n    Return n random bytes suitable for cryptographic use.\n    */\n\n    var randbytes = []\n    for(i = 0; i < n; i++){randbytes.push(parseInt(self._random() * 256))}\n    return _b_.bytes.$factory(randbytes)\n}\n\nRandom.betavariate = function(){\n    /* Beta distribution.\n\n    Conditions on the parameters are alpha > 0 and beta > 0.\n    Returned values range between 0 and 1.\n\n\n    # This version due to Janne Sinkkonen, and matches all the std\n    # texts (e.g., Knuth Vol 2 Ed 3 pg 134 \"the beta distribution\").\n    */\n\n    var $ = $B.args('betavariate', 3, {self: null, alpha:null, beta:null},\n            ['self', 'alpha', 'beta'], arguments, {}, null, null),\n        self = $.self,\n        alpha = $.alpha,\n        beta = $.beta\n\n    var y = Random.gammavariate(self, alpha, 1)\n    if(y == 0){return _b_.float.$factory(0)}\n    else{return y / (y + Random.gammavariate(self, beta, 1))}\n}\n\nRandom.choice = function(){\n    var $ = $B.args(\"choice\", 2,\n        {self: null, seq:null},[\"self\", \"seq\"],arguments, {}, null, null),\n        self = $.self,\n        seq = $.seq\n    var len, rank\n    if(Array.isArray(seq)){len = seq.length}\n    else{len = _b_.getattr(seq,\"__len__\")()}\n    if(len == 0){\n        throw _b_.IndexError.$factory(\"Cannot choose from an empty sequence\")\n    }\n    rank = parseInt(self._random() * len)\n    if(Array.isArray(seq)){return seq[rank]}\n    else{return _b_.getattr(seq, \"__getitem__\")(rank)}\n}\n\nRandom.choices = function(){\n    var $ = $B.args(\"choices\", 3,\n            {self: null,population:null, weights:null, cum_weights:null, k:null},\n            [\"self\", \"population\", \"weights\", \"cum_weights\", \"k\"], arguments,\n            {weights: _b_.None, cum_weights: _b_.None, k: 1}, \"*\", null),\n            self = $.self,\n            population = $.population,\n            weights = $.weights,\n            cum_weights = $.cum_weights,\n            k = $.k\n\n    if(population.length == 0){\n        throw _b_.ValueError.$factory(\"population is empty\")\n    }\n    population = _b_.list.$factory(population) // issue #1268\n    if(weights === _b_.None){\n        weights = []\n        population.forEach(function(){\n            weights.push(1)\n        })\n    }else if(cum_weights !== _b_.None){\n        throw _b_.TypeError.$factory(\"Cannot specify both weights and \" +\n            \"cumulative weights\")\n    }else{\n        if(weights.length != population.length){\n            throw _b_.ValueError.$factory('The number of weights does not ' +\n                'match the population')\n        }\n    }\n    if(cum_weights === _b_.None){\n        var cum_weights = [weights[0]]\n        weights.forEach(function(weight, rank){\n            if(rank > 0){\n                cum_weights.push(cum_weights[rank - 1] + weight)\n            }\n        })\n    }else if(cum_weights.length != population.length){\n        throw _b_.ValueError.$factory('The number of weights does not ' +\n            'match the population')\n    }\n\n    var result = []\n    for(var i = 0; i < k; i++){\n        var rand = self._random() * cum_weights[cum_weights.length - 1]\n        for(var rank = 0, len = population.length; rank < len; rank++){\n            if(cum_weights[rank] > rand){\n                result.push(population[rank])\n                break\n            }\n        }\n    }\n    return result\n}\n\nRandom.expovariate = function(self, lambd){\n    /*\n    Exponential distribution.\n\n    lambd is 1.0 divided by the desired mean.  It should be\n    nonzero.  (The parameter would be called \"lambda\", but that is\n    a reserved word in Python.)  Returned values range from 0 to\n    positive infinity if lambd is positive, and from negative\n    infinity to 0 if lambd is negative.\n\n    */\n    // lambd: rate lambd = 1/mean\n    // ('lambda' is a Python reserved word)\n\n    // we use 1-random() instead of random() to preclude the\n    // possibility of taking the log of zero.\n    return -Math.log(1.0 - self._random()) / lambd\n}\n\nRandom.gammavariate = function(self, alpha, beta){\n    /* Gamma distribution.  Not the gamma function!\n\n    Conditions on the parameters are alpha > 0 and beta > 0.\n\n    The probability distribution function is:\n\n                x ** (alpha - 1) * math.exp(-x / beta)\n      pdf(x) =  --------------------------------------\n                  math.gamma(alpha) * beta ** alpha\n\n    */\n\n    // alpha > 0, beta > 0, mean is alpha*beta, variance is alpha*beta**2\n\n    // Warning: a few older sources define the gamma distribution in terms\n    // of alpha > -1.0\n\n    var $ = $B.args('gammavariate', 3,\n            {self: null, alpha:null, beta:null},\n            ['self', 'alpha', 'beta'],\n            arguments, {}, null, null),\n        self = $.self,\n        alpha = $.alpha,\n        beta = $.beta,\n        LOG4 = Math.log(4),\n        SG_MAGICCONST = 1.0 + Math.log(4.5)\n\n    if(alpha <= 0.0 || beta <= 0.0){\n        throw _b_.ValueError.$factory('gammavariate: alpha and beta must be > 0.0')\n    }\n\n    if(alpha > 1.0){\n\n        // Uses R.C.H. Cheng, \"The generation of Gamma\n        // variables with non-integral shape parameters\",\n        // Applied Statistics, (1977), 26, No. 1, p71-74\n\n        var ainv = Math.sqrt(2.0 * alpha - 1.0),\n            bbb = alpha - LOG4,\n            ccc = alpha + ainv\n\n        while(true){\n            var u1 = self._random()\n            if(!((1e-7 < u1) && (u1 < .9999999))){\n                continue\n            }\n            var u2 = 1.0 - self._random(),\n                v = Math.log(u1 / (1.0 - u1)) / ainv,\n                x = alpha * Math.exp(v),\n                z = u1 * u1 * u2,\n                r = bbb + ccc * v - x\n            if((r + SG_MAGICCONST - 4.5 * z >= 0.0) || r >= Math.log(z)){\n                return x * beta\n            }\n        }\n    }else if(alpha == 1.0){\n        // expovariate(1)\n        var u = self._random()\n        while(u <= 1e-7){u = self._random()}\n        return -Math.log(u) * beta\n    }else{\n        // alpha is between 0 and 1 (exclusive)\n\n        // Uses ALGORITHM GS of Statistical Computing - Kennedy & Gentle\n\n        while(true){\n            var u = self._random(),\n                b = (Math.E + alpha)/Math.E,\n                p = b*u,\n                x\n            if(p <= 1.0){x = Math.pow(p, (1.0/alpha))}\n            else{x = -Math.log((b-p)/alpha)}\n            var u1 = self._random()\n            if(p > 1.0){\n                if(u1 <= Math.pow(x, alpha - 1.0)){\n                    break\n                }\n            }else if(u1 <= Math.exp(-x)){\n                break\n            }\n        }\n        return x * beta\n    }\n}\n\nRandom.gauss = function(){\n\n    /* Gaussian distribution.\n\n    mu is the mean, and sigma is the standard deviation.  This is\n    slightly faster than the normalvariate() function.\n\n    Not thread-safe without a lock around calls.\n\n    # When x and y are two variables from [0, 1), uniformly\n    # distributed, then\n    #\n    #    cos(2*pi*x)*sqrt(-2*log(1-y))\n    #    sin(2*pi*x)*sqrt(-2*log(1-y))\n    #\n    # are two *independent* variables with normal distribution\n    # (mu = 0, sigma = 1).\n    # (Lambert Meertens)\n    # (corrected version; bug discovered by Mike Miller, fixed by LM)\n\n    # Multithreading note: When two threads call this function\n    # simultaneously, it is possible that they will receive the\n    # same return value.  The window is very small though.  To\n    # avoid this, you have to use a lock around all calls.  (I\n    # didn't want to slow this down in the serial case by using a\n    # lock here.)\n    */\n\n    var $ = $B.args('gauss', 3, {self: null, mu:null, sigma:null},\n            ['self', 'mu', 'sigma'], arguments, {}, null, null),\n        self = $.self,\n        mu = $.mu,\n        sigma = $.sigma\n\n    var z = gauss_next\n    gauss_next = null\n    if(z === null){\n        var x2pi = self._random() * Math.PI * 2,\n            g2rad = Math.sqrt(-2.0 * Math.log(1.0 - self._random())),\n            z = Math.cos(x2pi) * g2rad\n        gauss_next = Math.sin(x2pi) * g2rad\n    }\n    return mu + z*sigma\n}\n\nRandom.getrandbits = function(){\n    var $ = $B.args(\"getrandbits\", 2,\n        {self: null, k:null},[\"self\", \"k\"],arguments, {}, null, null),\n        self = $.self,\n        k = $B.$GetInt($.k)\n    // getrandbits(k) -> x.  Generates a long int with k random bits.\n    if(k <= 0){\n        throw _b_.ValueError.$factory('number of bits must be greater than zero')\n    }\n    if(k != _b_.int.$factory(k)){\n        throw _b_.TypeError.$factory('number of bits should be an integer')\n    }\n    var numbytes = (k + 7), // bits / 8 and rounded up\n        x = _b_.int.from_bytes(Random._urandom(self, numbytes), 'big')\n    return _b_.getattr(x, '__rshift__')(\n        _b_.getattr(numbytes*8,'__sub__')(k))\n}\n\nRandom.getstate = function(){\n    // Return internal state; can be passed to setstate() later.\n    var $ = $B.args('getstate', 1, {self: null},\n        [\"self\"], arguments, {}, null, null)\n    return $.self._random.getstate()\n}\n\nRandom.lognormvariate = function(){\n    /*\n    Log normal distribution.\n\n    If you take the natural logarithm of this distribution, you'll get a\n    normal distribution with mean mu and standard deviation sigma.\n    mu can have any value, and sigma must be greater than zero.\n\n    */\n    return Math.exp(Random.normalvariate.apply(null, arguments))\n}\n\nRandom.normalvariate = function(){\n    /*\n    Normal distribution.\n\n    mu is the mean, and sigma is the standard deviation.\n\n    */\n\n    // mu = mean, sigma = standard deviation\n\n    // Uses Kinderman and Monahan method. Reference: Kinderman,\n    // A.J. and Monahan, J.F., \"Computer generation of random\n    // variables using the ratio of uniform deviates\", ACM Trans\n    // Math Software, 3, (1977), pp257-260.\n\n    var $ = $B.args(\"normalvariate\", 3,\n        {self: null, mu:null, sigma:null}, [\"self\", \"mu\", \"sigma\"],\n        arguments, {}, null, null),\n        self = $.self,\n        mu = $.mu,\n        sigma = $.sigma\n\n    while(true){\n        var u1 = self._random(),\n            u2 = 1.0 - self._random(),\n            z = NV_MAGICCONST * (u1 - 0.5) / u2,\n            zz = z * z / 4.0\n        if(zz <= -Math.log(u2)){break}\n    }\n    return mu + z * sigma\n}\n\nRandom.paretovariate = function(){\n    /* Pareto distribution.  alpha is the shape parameter.*/\n    // Jain, pg. 495\n\n    var $ = $B.args(\"paretovariate\", 2, {self: null, alpha:null},\n        [\"self\", \"alpha\"], arguments, {}, null, null)\n\n    var u = 1 - $.self._random()\n    return 1 / Math.pow(u, 1 / $.alpha)\n}\n\nfunction is_integer(x){\n    return _b_.isinstance(x, _b_.int) || (\n        _b_.isinstance(x, _b_.float) &&\n            x.valueOf() == Math.floor(x.valueOf()))\n}\n\nRandom.randint = function(self, a, b){\n    var $ = $B.args('randint', 3,\n        {self: null, a:null, b:null},\n        ['self', 'a', 'b'],\n        arguments, {}, null, null)\n    if(! is_integer($.a)){\n        throw _b_.ValueError.$factory(\"non-integer value for start\")\n    }\n    if(! is_integer($.b)){\n        throw _b_.ValueError.$factory(\"non-integer value for stop\")\n    }\n    return Random.randrange($.self, $.a, $B.add($.b, 1))\n}\n\nRandom.random = function(self){\n    var res = self._random()\n    if(! Number.isInteger(res)){return new Number(res)}\n    return res\n}\n\nRandom.randrange = function(){\n    var $ = $B.args('randrange', 4,\n        {self: null, x:null, stop:null, step:null},\n        ['self', 'x', 'stop', 'step'],\n        arguments, {stop:null, step:null}, null, null),\n        self = $.self,\n        _random = self._random\n\n    if(! is_integer($.x)){\n        throw _b_.ValueError.$factory(\"non-integer arg 1 for randrange()\")\n    }\n    if($.stop !== null && ! is_integer($.stop)){\n        throw _b_.ValueError.$factory(\"non-integer arg 2 for randrange()\")\n    }\n    if($.step !== null && ! is_integer($.step)){\n        throw _b_.ValueError.$factory(\"non-integer arg 3 for randrange()\")\n    }\n\n    if($.stop === null){\n        var start = 0, stop = $.x.valueOf(), step = 1\n    }else{\n        var start = $.x.valueOf(),\n            stop = $.stop.valueOf(),\n            step = $.step === null ? 1 : $.step.valueOf()\n        if(step == 0){throw _b_.ValueError.$factory('step cannot be 0')}\n    }\n\n    if(($B.rich_comp(\"__gt__\", step, 0) &&\n            $B.rich_comp(\"__ge__\", start, stop)) ||\n            ($B.rich_comp(\"__lt__\", step, 0) &&\n             $B.rich_comp(\"__le__\", start, stop))){\n        throw _b_.ValueError.$factory(\"empty range for randrange() (\" +\n            start + \", \" + stop + \", \" + step + \")\")\n    }\n    if(typeof start == 'number' && typeof stop == 'number' &&\n            typeof step == 'number'){\n        return start + step * Math.floor(_random() *\n            Math.ceil((stop - start) / step))\n    }else{\n        var d = _b_.getattr(stop, '__sub__')(start)\n        d = _b_.getattr(d, '__floordiv__')(step)\n        // Force d to be a LongInt\n        d = $B.long_int.$factory(d)\n        // d is a long integer with n digits ; to choose a random number\n        // between 0 and d the most simple is to take a random digit\n        // at each position, except the first one\n        var s = d.value,\n            _len = s.length,\n            res = Math.floor(_random() * (parseInt(s.charAt(0)) +\n                (_len == 1 ? 0 : 1))) + ''\n        var same_start = res.charAt(0) == s.charAt(0)\n        for(var i = 1; i < _len; i++){\n            if(same_start){\n                // If it's the last digit, don't allow stop as valid\n                if(i == _len - 1){\n                    res += Math.floor(_random() * parseInt(s.charAt(i))) + ''\n                }else{\n                    res += Math.floor(_random() *\n                        (parseInt(s.charAt(i)) + 1)) + ''\n                    same_start = res.charAt(i) == s.charAt(i)\n                }\n            }else{\n                res += Math.floor(_random() * 10) + ''\n            }\n        }\n        var offset = {__class__: $B.long_int, value: res,\n            pos: true}\n        d = _b_.getattr(step, '__mul__')(offset)\n        d = _b_.getattr(start, '__add__')(d)\n        return _b_.int.$factory(d)\n    }\n}\n\nRandom.sample = function(){\n    /*\n    Chooses k unique random elements from a population sequence or set.\n\n    Returns a new list containing elements from the population while\n    leaving the original population unchanged.  The resulting list is\n    in selection order so that all sub-slices will also be valid random\n    samples.  This allows raffle winners (the sample) to be partitioned\n    into grand prize and second place winners (the subslices).\n\n    Members of the population need not be hashable or unique.  If the\n    population contains repeats, then each occurrence is a possible\n    selection in the sample.\n\n    To choose a sample in a range of integers, use range as an argument.\n    This is especially fast and space efficient for sampling from a\n    large population:   sample(range(10000000), 60)\n\n    # Sampling without replacement entails tracking either potential\n    # selections (the pool) in a list or previous selections in a set.\n\n    # When the number of selections is small compared to the\n    # population, then tracking selections is efficient, requiring\n    # only a small set and an occasional reselection.  For\n    # a larger number of selections, the pool tracking method is\n    # preferred since the list takes less space than the\n    # set and it doesn't suffer from frequent reselections.'\n\n    */\n    var $ = $B.args('sample', 3, {self: null, population: null,k: null},\n        ['self', 'population','k'], arguments, {}, null, null),\n        self = $.self,\n        population = $.population,\n        k = $.k\n\n    if(!_b_.hasattr(population, '__len__')){\n        throw _b_.TypeError.$factory(\"Population must be a sequence or set. \" +\n            \"For dicts, use list(d).\")\n    }\n    var n = _b_.getattr(population, '__len__')()\n\n    if(k < 0 || k > n){\n        throw _b_.ValueError.$factory(\"Sample larger than population\")\n    }\n    var result = [],\n        setsize = 21        // size of a small set minus size of an empty list\n    if(k > 5){\n        setsize += Math.pow(4, Math.ceil(Math.log(k * 3, 4))) // table size for big sets\n    }\n    if(n <= setsize){\n        // An n-length list is smaller than a k-length set\n        if(Array.isArray(population)){\n            var pool = population.slice()\n        }else{var pool = _b_.list.$factory(population)}\n        for(var i = 0; i < k; i++){ //invariant:  non-selected at [0,n-i)\n            var j = Random._randbelow(self, n - i)\n            result[i] = pool[j]\n            pool[j] = pool[n - i - 1]   // move non-selected item into vacancy\n        }\n    }else{\n        selected = {}\n        for(var i = 0; i < k; i++){\n            var j = Random._randbelow(self, n)\n            while(selected[j] !== undefined){\n                j = Random._randbelow(self, n)\n            }\n            selected[j] = true\n            result[i] = Array.isArray(population) ? population[j] :\n                            _b_.getattr(population, '__getitem__')(j)\n        }\n    }\n    return $B.$list(result) // not \"return result\", cf. issue #1622\n}\n\nRandom.seed = function(){\n    /*\n    Initialize internal state from hashable object.\n\n    None or no argument seeds from current time or from an operating\n    system specific randomness source if available.\n\n    If *a* is an int, all bits are used.\n    */\n    var $ = $B.args('seed', 3, {self: null, a: null, version: null},\n        ['self', 'a', 'version'],\n        arguments, {a: new Date(), version: 2}, null, null),\n        self = $.self,\n        a = $.a,\n        version = $.version\n\n    if(version == 1){a = _b_.hash(a)}\n    else if(version == 2){\n        if(_b_.isinstance(a, _b_.str)){\n            a = _b_.int.from_bytes(_b_.bytes.$factory(a, 'utf-8'), 'big')\n        }else if(_b_.isinstance(a, [_b_.str, _b_.bytes, _b_.bytearray])){\n            $B.$import(\"hashlib\",[\"sha512\"], {}, {}, true);\n            var sha512 = $B.$getattr($B.imported[\"hashlib\"], \"sha512\");\n            if(_b_.isinstance(a, _b_.str)){\n                a = _b_.str.encode(a)\n            }\n            a = $B.add(a, $B.$getattr(sha512(a), 'digest')())\n            a = _b_.int.from_bytes(a, 'big')\n        }else if(false && Array.isArray(a)){\n            // for debugging\n        }else if(!_b_.isinstance(a, _b_.int)){\n            throw _b_.TypeError.$factory('wrong argument')\n        }\n    }else{\n        throw _b_.ValueError.$factory('version can only be 1 or 2')\n    }\n    self._random.seed(a)\n    gauss_next = null\n}\n\nRandom.setstate = function(state){\n    // Restore internal state from object returned by getstate().\n    var $ = $B.args('setstate', 2, {self: null, state:null}, ['self', 'state'],\n        arguments, {}, null, null),\n        self = $.self\n    var state = self._random.getstate()\n    if(! Array.isArray($.state)){\n        throw _b_.TypeError.$factory('state must be a list, not ' +\n            $B.class_name($.state))\n    }\n    if($.state.length < state.length){\n        throw _b_.ValueError.$factory(\"need more than \" + $.state.length +\n            \" values to unpack\")\n    }else if($.state.length > state.length){\n        throw _b_.ValueError.$factory(\"too many values to unpack (expected \" +\n            state.length + \")\")\n    }\n    if($.state[0] != 3){\n        throw _b_.ValueError.$factory(\"state with version \" +\n            $.state[0] + \" passed to Random.setstate() of version 3\")\n    }\n    var second = _b_.list.$factory($.state[1])\n    if(second.length !== state[1].length){\n        throw _b_.ValueError.$factory('state vector is the wrong size')\n    }\n    for(var i = 0; i < second.length; i++){\n        if(typeof second[i] != 'number'){\n            throw _b_.ValueError.$factory('state vector items must be integers')\n        }\n    }\n    self._random.setstate($.state)\n}\n\nRandom.shuffle = function(x, random){\n    /*\n    x, random = random.random -> shuffle list x in place; return None.\n\n    Optional arg random is a 0-argument function returning a random\n    float in [0.0, 1.0); by default, the standard random.random.\n    */\n\n    var $ = $B.args('shuffle', 3, {self: null, x: null, random: null},\n        ['self', 'x','random'],\n        arguments, {random: null}, null, null),\n        self = $.self,\n        x = $.x,\n        random = $.random\n\n    if(random === null){random = self._random}\n\n    if(Array.isArray(x)){\n        for(var i = x.length - 1; i >= 0;i--){\n            var j = Math.floor(random() * (i + 1)),\n                temp = x[j]\n            x[j] = x[i]\n            x[i] = temp\n        }\n    }else{\n        var len = _b_.getattr(x, '__len__')(), temp,\n            x_get = _b_.getattr(x, '__getitem__'),\n            x_set = _b_.getattr(x, '__setitem__')\n\n        for(i = len - 1; i >= 0; i--){\n            var j = Math.floor(random() * (i + 1)),\n                temp = x_get(j)\n            x_set(j, x_get(i))\n            x_set(i, temp)\n        }\n    }\n    return _b_.None\n}\n\nRandom.triangular = function(){\n    /*\n    Triangular distribution.\n\n    Continuous distribution bounded by given lower and upper limits,\n    and having a given mode value in-between.\n\n    http://en.wikipedia.org/wiki/Triangular_distribution\n    */\n    var $ = $B.args('triangular', 4,\n        {self: null, low: null, high: null, mode: null},\n        ['self', 'low', 'high', 'mode'],\n        arguments, {low: 0, high: 1, mode: null}, null, null),\n        low = $.low,\n        high = $.high,\n        mode = $.mode\n\n    var u = $.self._random(),\n        c = mode === null ? 0.5 : (mode - low) / (high - low)\n    if(u > c){\n        u = 1 - u\n        c = 1 - c\n        var temp = low\n        low = high\n        high = temp\n    }\n    return low + (high - low) * Math.pow(u * c, 0.5)\n}\n\nRandom.uniform = function(){\n    var $ = $B.args('uniform', 3, {self: null, a: null, b: null},\n        ['self', 'a', 'b'], arguments, {}, null, null),\n        a = $B.$GetInt($.a),\n        b = $B.$GetInt($.b)\n\n    return a + (b - a) * $.self._random()\n}\n\nRandom.vonmisesvariate = function(){\n    /* Circular data distribution.\n\n    mu is the mean angle, expressed in radians between 0 and 2*pi, and\n    kappa is the concentration parameter, which must be greater than or\n    equal to zero.  If kappa is equal to zero, this distribution reduces\n    to a uniform random angle over the range 0 to 2*pi.\n\n    */\n    // mu:    mean angle (in radians between 0 and 2*pi)\n    // kappa: concentration parameter kappa (>= 0)\n    // if kappa = 0 generate uniform random angle\n\n    // Based upon an algorithm published in: Fisher, N.I.,\n    // \"Statistical Analysis of Circular Data\", Cambridge\n    // University Press, 1993.\n\n    // Thanks to Magnus Kessler for a correction to the\n    // implementation of step 4.\n\n    var $ = $B.args('vonmisesvariate', 3,\n            {self: null, mu: null, kappa:null}, ['self', 'mu', 'kappa'],\n            arguments, {}, null, null),\n        self = $.self,\n        mu = $.mu,\n        kappa = $.kappa,\n        TWOPI = 2*Math.PI\n\n    if(kappa <= 1e-6){return TWOPI * self._random()}\n\n    var s = 0.5 / kappa,\n        r = s + Math.sqrt(1.0 + s * s)\n\n    while(true){\n        var u1 = self._random(),\n            z = Math.cos(Math.PI * u1),\n            d = z / (r + z),\n            u2 = self._random()\n        if((u2 < 1.0 - d * d) ||\n            (u2 <= (1.0 - d) * Math.exp(d))){\n                break\n        }\n    }\n    var q = 1.0 / r,\n        f = (q + z) / (1.0 + q * z),\n        u3 = self._random()\n    if(u3 > 0.5){var theta = (mu + Math.acos(f)) % TWOPI}\n    else{var theta = (mu - Math.acos(f)) % TWOPI}\n    return theta\n}\n\nRandom.weibullvariate = function(){\n    /*Weibull distribution.\n\n    alpha is the scale parameter and beta is the shape parameter.\n\n    */\n    // Jain, pg. 499; bug fix courtesy Bill Arms\n    var $ = $B.args(\"weibullvariate\", 3,\n        {self: null, alpha: null, beta: null},\n        [\"self\", \"alpha\", \"beta\"], arguments, {}, null, null)\n\n    var u = 1 - $.self._random()\n    return $.alpha * Math.pow(-Math.log(u), 1 / $.beta)\n}\n\n$B.set_func_names(Random, \"random\")\n\nvar $module = Random.$factory()\nfor(var attr in Random){\n    $module[attr] = (function(x){\n        return function(){return Random[x]($module, ...arguments)}\n    })(attr)\n    $module[attr].$infos = Random[attr].$infos\n}\n\n$module.Random = Random\n\nvar SystemRandom = $B.make_class(\"SystemRandom\",\n    function(){\n        return {__class__: SystemRandom}\n    }\n)\nSystemRandom.__getattribute__ = function(){\n    throw $B.builtins.NotImplementedError.$factory()\n}\n\n$module.SystemRandom = SystemRandom\n\nreturn $module\n\n})(__BRYTHON__)\n\n"], "unicodedata": [".js", "// Implementation of unicodedata\n\nvar $module = (function($B){\n\n    var _b_ = $B.builtins\n\n    // Load unicode table if not already loaded\n    if($B.unicodedb === undefined){\n        var xhr = new XMLHttpRequest\n        xhr.open(\"GET\",\n            $B.brython_path + \"unicode.txt\", false)\n        xhr.onreadystatechange = function(){\n            if(this.readyState == 4){\n                if(this.status == 200){\n                    $B.unicodedb = this.responseText\n                }else{\n                    console.log(\"Warning - could not \" +\n                        \"load unicode.txt\")\n                }\n            }\n        }\n        xhr.send()\n    }\n\n    function _info(chr){\n        var ord = _b_.ord(chr),\n            hex = ord.toString(16).toUpperCase()\n        while(hex.length < 4){hex = \"0\" + hex}\n        var re = new RegExp(\"^\" + hex +\";(.+?);(.*?);(.*?);(.*?);(.*?);(.*);(.*);(.*)$\",\n                \"m\"),\n            search = re.exec($B.unicodedb)\n        if(search === null){\n            return null\n        }else{\n            return {\n                name: search[1],\n                category: search[2],\n                combining: search[3],\n                bidirectional: search[4],\n                decomposition: search[5],\n                decimal: search[6],\n                digit: search[7],\n                numeric: search[8]\n            }\n        }\n    }\n\n    function bidirectional(chr){\n        var search = _info(chr)\n        if(search === null){\n            console.log(\"error\", chr, hex)\n            throw _b_.KeyError.$factory(chr)\n        }\n        return search.bidirectional\n    }\n\n    function category(chr){\n        // Returns the general category assigned to the character chr as\n        // string.\n        if($B.is_unicode_cn(chr.codePointAt(0))){ // in unicode_data.js\n            return \"Cn\"\n        }\n        var search = _info(chr)\n        if(search === null){\n            console.log(\"error\", chr)\n            throw _b_.KeyError.$factory(chr)\n        }\n        return search.category\n    }\n\n    function combining(chr){\n        // Returns the general category assigned to the character chr as\n        // string.\n        var search = _info(chr)\n        if(search === null){\n            console.log(\"error\", chr)\n            throw _b_.KeyError.$factory(chr)\n        }\n        return parseInt(search.combining)\n    }\n\n    function decimal(chr, _default){\n        // Returns the decimal value assigned to the character chr as integer.\n        // If no such value is defined, default is returned, or, if not given,\n        // ValueError is raised.\n        var search = _info(chr)\n        if(search === null){\n            console.log(\"error\", chr)\n            throw _b_.KeyError.$factory(chr)\n        }\n        return parseInt(search.decimal)\n    }\n\n    function decomposition(chr, _default){\n        // Returns the decimal value assigned to the character chr as integer.\n        // If no such value is defined, default is returned, or, if not given,\n        // ValueError is raised.\n        var search = _info(chr)\n        if(search === null){\n            console.log(\"error\", chr)\n            throw _b_.KeyError.$factory(chr)\n        }\n        return search.decomposition\n    }\n\n    function digit(chr, _default){\n        // Returns the decimal value assigned to the character chr as integer.\n        // If no such value is defined, default is returned, or, if not given,\n        // ValueError is raised.\n        var search = _info(chr)\n        if(search === null){\n            console.log(\"error\", chr)\n            throw _b_.KeyError.$factory(chr)\n        }\n        return parseInt(search.digit)\n    }\n\n    function lookup(name){\n        // Look up character by name. If a character with the given name is\n        // found, return the corresponding character. If not found, KeyError\n        // is raised.\n        var re = new RegExp(\"^([0-9A-F]+);\" +\n            name + \";(.*)$\", \"m\")\n        search = re.exec($B.unicodedb)\n        if(search === null){\n            throw _b_.KeyError.$factory(\"undefined character name '\" +\n                name + \"'\")\n        }\n        var res = parseInt(search[1], 16)\n        return _b_.chr(res)\n    }\n\n    function name(chr, _default){\n        // Returns the name assigned to the character chr as a string. If no\n        // name is defined, default is returned, or, if not given, ValueError\n        // is raised.\n        var search = _info(chr)\n        if(search === null){\n            if(_default){return _default}\n            throw _b_.KeyError.$factory(\"undefined character name '\" +\n                chr + \"'\")\n        }\n        return search.name\n    }\n\n    function _norm(form, chr){\n        var search = _info(chr)\n        if(search === null){\n            throw _b_.KeyError.$factory(chr)\n        }\n        switch(form){\n            case \"NFC\":\n                return chr\n            case \"NFD\":\n                var decomp = decomposition(chr),\n                    parts = decomp.split(\" \"),\n                    res = \"\"\n                if(parts[0].startsWith(\"<\")){\n                    return chr\n                }\n                parts.forEach(function(part){\n                    if(! part.startsWith(\"<\")){\n                        res += _b_.chr(parseInt(part, 16))\n                    }\n                })\n                return res\n            case \"NFKC\":\n                var decomp = decomposition(chr),\n                    parts = decomp.split(\" \")\n                if(parts[0] == \"<compat>\"){\n                    var res = \"\"\n                    parts.slice(1).forEach(function(part){\n                        res += _b_.chr(parseInt(part, 16))\n                    })\n                    return res\n                }\n                return chr\n            case \"NFKD\":\n                var decomp = decomposition(chr),\n                    parts = decomp.split(\" \")\n                if(parts[0] == \"<compat>\"){\n                    var res = \"\"\n                    parts.slice(1).forEach(function(part){\n                        res += _b_.chr(parseInt(part, 16))\n                    })\n                    return res\n                }\n                return chr\n\n            default:\n                throw _b_.ValueError.$factory(\"invalid normalization form\")\n        }\n    }\n\n    function normalize(form, unistr){\n        var res = \"\"\n        for(var i = 0, len = unistr.length; i < len; i++){\n            res += _norm(form, unistr.charAt(i))\n        }\n        return res\n    }\n\n    function numeric(chr, _default){\n        // Returns the decimal value assigned to the character chr as integer.\n        // If no such value is defined, default is returned, or, if not given,\n        // ValueError is raised.\n        var search = _info(chr)\n        if(search === null){\n            if(_default){return _default}\n            throw _b_.KeyError.$factory(chr)\n        }\n        return new Number(eval(search.numeric))\n    }\n\n    var module = {\n        bidirectional: bidirectional,\n        category: category,\n        combining: combining,\n        decimal: decimal,\n        decomposition: decomposition,\n        digit: digit,\n        lookup: lookup,\n        name: name,\n        normalize: normalize,\n        numeric: numeric,\n        unidata_version: \"11.0.0\"\n    }\n    module.ucd_3_2_0 = {}\n    for(var key in module){\n        if(key == \"unidata_version\"){\n            module.ucd_3_2_0[key] = '3.2.0'\n        }else{\n            module.ucd_3_2_0[key] = module[key] // approximation...\n        }\n    }\n    return module\n\n})(__BRYTHON__)"], "_aio": [".js", "// Replacement for asyncio.\n//\n// CPython asyncio can't be implemented for Brython because it relies on\n// blocking function (eg run(), run_until_complete()), and such functions\n// can't be defined in Javascript. It also manages an event loop, and a\n// browser only has its own built-in event loop.\n//\n// This module exposes functions whose result can be \"await\"-ed inside\n// asynchrounous functions defined by \"async def\".\n\nvar $module = (function($B){\n\nvar _b_ = $B.builtins\n\nvar responseType = {\n    \"text\": \"text\",\n    \"binary\": \"arraybuffer\",\n    \"dataURL\": \"arraybuffer\"\n}\n\nfunction handle_kwargs(kw, method){\n    var data,\n        cache = false,\n        format = \"text\",\n        headers = {},\n        timeout = {}\n    for(var key in kw.$string_dict){\n        if(key == \"data\"){\n            var params = kw.$string_dict[key][0]\n            if(typeof params == \"string\"){\n                data = params\n            }else if(_b_.isinstance(params, _b_.bytes)){\n                data = new ArrayBuffer(params.source.length)\n                var array = new Int8Array(data)\n                for(var i = 0, len = params.source.length; i < len; i++){\n                    array[i] = params.source[i]\n                }\n            }else{\n                if(params.__class__ !== _b_.dict){\n                    throw _b_.TypeError.$factory(\"wrong type for data, \" +\n                        \"expected dict, bytes or str, got \" +\n                        $B.class_name(params))\n                }\n                params = params.$string_dict\n                var items = []\n                for(var key in params){\n                    items.push(encodeURIComponent(key) + \"=\" +\n                               encodeURIComponent(params[key][0]))\n                }\n                data = items.join(\"&\")\n            }\n        }else if(key == \"headers\"){\n            headers = _b_.dict.$to_obj(kw.$string_dict[key][0])\n        }else if(key.startsWith(\"on\")){\n            var event = key.substr(2)\n            if(event == \"timeout\"){\n                timeout.func = kw.$string_dict[key][0]\n            }else{\n                ajax.bind(self, event, kw.$string_dict[key][0])\n            }\n        }else if(key == \"timeout\"){\n            timeout.seconds = kw.$string_dict[key][0]\n        }else if(key == \"cache\"){\n            cache = kw.$string_dict[key][0]\n        }else if(key == \"format\"){\n            format = kw.$string_dict[key][0]\n        }\n    }\n    if(method == \"post\"){\n        // For POST requests, set default header\n        if(! headers.hasOwnProperty(\"Content-type\")){\n            headers[\"Content-Type\"] = \"application/x-www-form-urlencoded\"\n        }\n    }\n    return {\n        body: data,\n        cache: cache,\n        format: format,\n        timeout: timeout,\n        headers: headers\n    }\n}\n\nfunction ajax(){\n    var $ = $B.args(\"ajax\", 2, {method: null, url: null},\n            [\"method\", \"url\"], arguments, {},\n            null, \"kw\"),\n        method = $.method.toUpperCase(),\n        url = $.url,\n        kw = $.kw\n    var args = handle_kwargs(kw, \"get\")\n    if(method == \"GET\" && ! args.cache){\n        url = url + \"?ts\" + (new Date()).getTime() + \"=0\"\n    }\n    if(args.body && method == \"GET\"){\n        url = url + (args.cache ? \"?\" : \"&\") + args.body\n    }\n    var func = function(){\n        return new Promise(function(resolve, reject){\n            var xhr = new XMLHttpRequest()\n            xhr.open(method, url, true)\n            for(key in args.headers){\n                xhr.setRequestHeader(key, args.headers[key])\n            }\n            xhr.format = args.format\n            xhr.responseType = responseType[args.format]\n            xhr.onreadystatechange = function(){\n                if(this.readyState == 4){\n                    this.__class__ = HTTPRequest\n                    resolve(this)\n                }\n            }\n            if(args.body &&\n                    ['POST', 'PUT', 'DELETE', 'PATCH'].indexOf(method) > -1){\n                xhr.send(args.body)\n            }else{\n                xhr.send()\n            }\n        })\n    }\n    func.$infos = {\n        __name__: \"ajax_\" + method\n    }\n    return {\n        __class__: $B.coroutine,\n        $args: [url, args],\n        $func: func\n    }\n}\n\nfunction event(){\n    // event(element, *names) is a Promise on the events \"names\" happening on\n    // the element. This promise always resolves (never rejects) with the\n    // first triggered DOM event.\n    var $ = $B.args(\"event\", 1, {element: null},\n            [\"element\"], arguments, {}, \"names\", null),\n        element = $.element,\n        names = $.names\n    return new Promise(function(resolve){\n        var callbacks = []\n        names.forEach(function(name){\n            var callback = function(evt){\n                // When one of the handled events is triggered, all bindings\n                // are removed\n                callbacks.forEach(function(items){\n                    $B.DOMNode.unbind(element, items[0], items[1])\n                })\n                resolve($B.$DOMEvent(evt))\n            }\n            callbacks.push([name, callback])\n            $B.DOMNode.bind(element, name, callback)\n        })\n    })\n}\n\nvar HTTPRequest = $B.make_class(\"Request\")\n\nHTTPRequest.data = _b_.property.$factory(function(self){\n    if(self.format == \"binary\"){\n        var view = new Uint8Array(self.response)\n        return _b_.bytes.$factory(Array.from(view))\n    }else if(self.format == \"text\"){\n        return self.responseText\n    }else if(self.format == \"dataURL\"){\n        var base64String = btoa(String.fromCharCode.apply(null,\n            new Uint8Array(self.response)))\n        return \"data:\" + self.getResponseHeader(\"Content-Type\") +\n            \";base64,\" + base64String\n    }\n})\n\nHTTPRequest.response_headers = _b_.property.$factory(function(self){\n    var headers = self.getAllResponseHeaders()\n    if(headers === null){return _b_.None}\n    var res = $B.empty_dict()\n    if(headers.length > 0){\n        // Convert the header string into an array\n        // of individual headers\n        var lines = headers.trim().split(/[\\r\\n]+/)\n        // Create a map of header names to values\n        lines.forEach(function(line){\n          var parts = line.split(': ')\n          var header = parts.shift()\n          var value = parts.join(': ')\n          _b_.dict.$setitem(res, header, value)\n        })\n    }\n    return res\n})\n\nfunction get(){\n    return ajax.bind(null, \"GET\").apply(null, arguments)\n}\n\nfunction iscoroutine(f){\n    return f.__class__ === $B.coroutine\n}\n\nfunction iscoroutinefunction(f){\n    return (f.$infos.__code__.co_flags & 128) != 0\n}\n\nfunction post(){\n    return ajax.bind(null, \"POST\").apply(null, arguments)\n}\n\nfunction run(coro){\n    var handle_success = function(){\n            $B.leave_frame()\n        },\n        handle_error = function(err){\n            // coro.$stack is a snapshot of the frames stack when the async\n            // function was called. Restore it to get the correct call tree\n            err.$stack = coro.$stack.concat([$B.last(err.$stack)])\n            $B.handle_error(err)\n        }\n\n    var $ = $B.args(\"run\", 3, {coro: null, onsuccess: null, onerror: null},\n            [\"coro\", \"onsuccess\", \"onerror\"], arguments,\n            {onsuccess: handle_success, onerror: handle_error},\n            null, null),\n        coro = $.coro,\n        onsuccess = $.onsuccess,\n        onerror = $.onerror\n\n    if(onerror !== handle_error){\n        function error_func(exc){\n            try{\n                onerror(exc)\n            }catch(err){\n                handle_error(err)\n            }\n        }\n    }else{\n        error_func = handle_error\n    }\n    var save_stack = $B.frames_stack.slice()\n    $B.coroutine.send(coro).then(onsuccess).catch(error_func)\n    $B.frames_stack = save_stack\n    return _b_.None\n}\n\nfunction sleep(seconds){\n    var func = function(){\n        return new Promise(resolve => setTimeout(\n            function(){resolve(_b_.None)}, 1000 * seconds))\n    }\n    func.$infos = {\n        __name__: \"sleep\"\n    }\n    return {\n        __class__: $B.coroutine,\n        $args: [seconds],\n        $func: func\n    }\n}\n\nreturn {\n    ajax: ajax,\n    event: event,\n    get: get,\n    iscoroutine: iscoroutine,\n    iscoroutinefunction: iscoroutinefunction,\n    post: post,\n    run: run,\n    sleep: sleep\n}\n\n})(__BRYTHON__)\n"], "_ajax": [".js", "// ajax\nvar $module = (function($B){\n\n\nvar $N = $B.builtins.None,\n    _b_ = $B.builtins\n\nvar add_to_res = function(res, key, val) {\n    if(_b_.isinstance(val, _b_.list)){\n        for (j = 0; j < val.length; j++) {\n            add_to_res(res, key, val[j])\n        }\n    }else if (val instanceof File || val instanceof Blob){\n        res.append(key, val)\n    }else{res.append(key, _b_.str.$factory(val))}\n}\n\nfunction set_timeout(self, timeout){\n    if(timeout.seconds !== undefined){\n        self.js.$requestTimer = setTimeout(\n            function() {\n                self.js.abort()\n                if(timeout.func){\n                    timeout.func()\n                }\n            },\n            timeout.seconds * 1000)\n    }\n}\n\nfunction _read(req){\n    var xhr = req.js\n    if(xhr.responseType == \"json\"){\n        return $B.structuredclone2pyobj(xhr.response)\n    }\n    if(typeof xhr.response == \"string\"){\n        // on blocking mode, xhr.response is a string\n        var bytes = []\n        for(var i = 0, len = xhr.response.length; i < len; i++){\n            var cp = xhr.response.codePointAt(i)\n            if(cp > 0xf700){\n                bytes.push(cp - 0xf700)\n            }else{\n                bytes.push(cp)\n            }\n        }\n    }else{\n        // else it's an ArrayBuffer\n        var buf = new Uint8Array(xhr.response),\n            bytes = Array.from(buf.values())\n    }\n    var b = _b_.bytes.$factory(bytes)\n    if(req.mode == \"binary\"){\n        return b\n    }else if(req.mode == \"document\"){\n        return $B.JSObj.$factory(xhr.response)\n    }else{\n        var encoding = req.encoding || \"utf-8\"\n        return _b_.bytes.decode(b, encoding)\n    }\n}\n\nfunction handle_kwargs(self, kw, method){\n    var data,\n        encoding,\n        headers={},\n        cache,\n        mode = \"text\",\n        timeout = {}\n    for(var key in kw.$string_dict){\n        if(key == \"data\"){\n            var params = kw.$string_dict[key][0]\n            if(typeof params == \"string\"){\n                data = params\n            }else if(params.__class__ === _b_.dict){\n                for(var key in params.$numeric_dict){\n                    throw _b_.ValueError.$factory(\n                        'data only supports string keys, got ' + key)\n                }\n                params = params.$string_dict\n                var items = []\n                for(var key in params){\n                    items.push(encodeURIComponent(key) + \"=\" +\n                               encodeURIComponent(params[key][0]))\n                }\n                data = items.join(\"&\")\n            }else{\n                throw _b_.TypeError.$factory(\"wrong type for data: \" +\n                    $B.class_name(params))\n            }\n        }else if(key == \"encoding\"){\n            encoding = kw.$string_dict[key][0]\n        }else if(key == \"headers\"){\n            var value = kw.$string_dict[key][0]\n            if(! _b_.isinstance(value, _b_.dict)){\n                throw _b_.ValueError.$factory(\n                    \"headers must be a dict, not \" + $B.class_name(value))\n            }\n            for(key in value.$string_dict){\n                headers[key.toLowerCase()] = [key, value.$string_dict[key][0]]\n            }\n        }else if(key.startsWith(\"on\")){\n            var event = key.substr(2)\n            if(event == \"timeout\"){\n                timeout.func = kw.$string_dict[key][0]\n            }else{\n                var f = kw.$string_dict[key][0]\n                ajax.bind(self, event, f)\n            }\n        }else if(key == \"mode\"){\n            var mode = kw.$string_dict[key][0]\n        }else if(key == \"timeout\"){\n            timeout.seconds = kw.$string_dict[key][0]\n        }else if(key == \"cache\"){\n            cache = kw.$string_dict[key][0]\n        }\n    }\n    if(encoding && mode != \"text\"){\n        throw _b_.ValueError.$factory(\"encoding not supported for mode \" +\n            mode)\n    }\n    if((method == \"post\" || method == \"put\") && ! headers){\n        // For POST requests, set default header\n        self.js.setRequestHeader(\"Content-type\",\n                                 \"application/x-www-form-urlencoded\")\n    }\n    return {cache, data, encoding, headers, mode, timeout}\n}\n\nvar ajax = {\n    __class__: _b_.type,\n    __mro__: [_b_.object],\n\n    __repr__ : function(self){return '<object Ajax>'},\n    __str__ : function(self){return '<object Ajax>'},\n\n    $infos: {\n        __module__: \"builtins\",\n        __name__: \"ajax\"\n    },\n\n    __getattribute__: function(self, attr){\n        if(ajax[attr] !== undefined){\n            return function(){\n                return ajax[attr].call(null, self, ...arguments)\n            }\n        }else if(attr == \"text\"){\n            return _read(self)\n        }else if(attr == \"json\"){\n            if(self.js.responseType == \"json\"){\n                return _read(self)\n            }else{\n                var resp = _read(self)\n                try{\n                    return $B.structuredclone2pyobj(JSON.parse(resp))\n                }catch(err){\n                    console.log('attr json, invalid resp', resp)\n                    throw err\n                }\n            }\n        }else if(self.js[attr] !== undefined){\n            if(typeof self.js[attr] == \"function\"){\n                return function(){\n                    if(attr == \"setRequestHeader\"){\n                        ajax.set_header.call(null, self, ...arguments)\n                    }else{\n                        if(attr == 'overrideMimeType'){\n                            console.log('override mime type')\n                            self.hasMimeType = true\n                        }\n                        return self.js[attr](...arguments)\n                    }\n                }\n            }else{\n                return self.js[attr]\n            }\n        }else if(attr == \"xml\"){\n            return $B.JSObj.$factory(self.js.responseXML)\n        }\n    },\n\n    bind: function(self, evt, func){\n        // req.bind(evt,func) is the same as req.onevt = func\n        self.js['on' + evt] = function(){\n            try{\n                return func.apply(null, arguments)\n            }catch(err){\n                $B.handle_error(err)\n            }\n        }\n        return _b_.None\n    },\n\n    open: function(){\n        var $ = $B.args('open', 4,\n                {self: null, method: null, url: null, async: null},\n                ['self', 'method', 'url', 'async'], arguments,\n                {async: true}, null, null),\n            self = $.self,\n            method = $.method,\n            url = $.url,\n            async = $.async\n        if(typeof method !== \"string\"){\n            throw _b_.TypeError.$factory(\n                'open() argument method should be string, got ' +\n                $B.class_name(method))\n        }\n        if(typeof url !== \"string\"){\n            throw _b_.TypeError.$factory(\n                'open() argument url should be string, got ' +\n                $B.class_name(url))\n        }\n        self.$method = method\n        self.blocking = ! self.async\n        self.js.open(method, url, async)\n    },\n\n    read: function(self){\n        return _read(self)\n    },\n\n    send: function(self, params){\n        // params can be Python dictionary or string\n        var content_type\n        for(var key in self.headers){\n            var header = self.headers[key]\n            self.js.setRequestHeader(header[0], header[1])\n            if(key == 'content-type'){\n                content_type = header[1]\n            }\n        }\n        if((self.encoding || self.blocking) && ! self.hasMimeType){\n            // On blocking mode, or if an encoding has been specified,\n            // override Mime type so that bytes are not processed\n            // (unless the Mime type has been explicitely set)\n            self.js.overrideMimeType('text/plain;charset=x-user-defined')\n        }\n        var res = ''\n        if(! params){\n            self.js.send()\n            return _b_.None\n        }\n        if(_b_.isinstance(params, _b_.str)){\n            res = params\n        }else if(_b_.isinstance(params, _b_.dict)){\n            if(content_type == 'multipart/form-data'){\n                // The FormData object serializes the data in the 'multipart/form-data'\n                // content-type so we may as well override that header if it was set\n                // by the user.\n                res = new FormData()\n                var items = _b_.list.$factory(_b_.dict.items(params))\n                for(var i = 0, len = items.length; i < len; i++){\n                    add_to_res(res, _b_.str.$factory(items[i][0]), items[i][1])\n                }\n            }else{\n                if(self.$method && self.$method.toUpperCase() == \"POST\" &&\n                        ! content_type){\n                    // Set default Content-Type for POST requests\n                    self.js.setRequestHeader(\"Content-Type\",\n                        \"application/x-www-form-urlencoded\")\n                }\n                var items = _b_.list.$factory(_b_.dict.items(params))\n                for(var i = 0, len = items.length; i < len; i++){\n                    var key = encodeURIComponent(_b_.str.$factory(items[i][0]));\n                    if(_b_.isinstance(items[i][1], _b_.list)){\n                        for (j = 0; j < items[i][1].length; j++) {\n                            res += key +'=' +\n                                encodeURIComponent(_b_.str.$factory(items[i][1][j])) + '&'\n                        }\n                    }else{\n                        res += key + '=' +\n                            encodeURIComponent(_b_.str.$factory(items[i][1])) + '&'\n                    }\n                }\n                res = res.substr(0, res.length - 1)\n            }\n        }else{\n            throw _b_.TypeError.$factory(\n                \"send() argument must be string or dictionary, not '\" +\n                _b_.str.$factory(params.__class__) + \"'\")\n        }\n        self.js.send(res)\n        return _b_.None\n    },\n\n    set_header: function(self, key, value){\n        self.headers[key.toLowerCase()] = [key, value]\n    },\n\n    set_timeout: function(self, seconds, func){\n        self.js.$requestTimer = setTimeout(\n            function() {\n                self.js.abort()\n                func()\n            },\n            seconds * 1000)\n    }\n\n}\n\najax.$factory = function(){\n\n    if(window.XMLHttpRequest){// code for IE7+, Firefox, Chrome, Opera, Safari\n        var xmlhttp = new XMLHttpRequest()\n    }else{// code for IE6, IE5\n        var xmlhttp = new ActiveXObject(\"Microsoft.XMLHTTP\")\n    }\n    xmlhttp.onreadystatechange = function(){\n        // here, \"this\" refers to xmlhttp\n        var state = this.readyState\n        if(this.responseType == \"\" || this.responseType == \"text\"){\n            res.js.text = this.responseText\n        }\n        var timer = this.$requestTimer\n        if(state == 0 && this.onuninitialized){\n            this.onuninitialized(res)\n        }else if(state == 1 && this.onloading){\n            this.onloading(res)\n        }else if(state == 2 && this.onloaded){\n            this.onloaded(res)\n        }else if(state == 3 && this.oninteractive){\n            this.oninteractive(res)\n        }else if(state == 4 && this.oncomplete){\n            if(timer !== null){\n                window.clearTimeout(timer)\n            }\n            this.oncomplete(res)\n        }\n    }\n    var res = {\n        __class__: ajax,\n        js: xmlhttp,\n        headers: {}\n    }\n    return res\n}\n\nfunction _request_without_body(method){\n    var $ = $B.args(method, 3, {method: null, url: null, blocking: null},\n        [\"method\", \"url\", \"blocking\"], arguments, {blocking: false},\n        null, \"kw\"),\n    method = $.method,\n    url = $.url,\n    async = !$.blocking,\n    kw = $.kw\n    var self = ajax.$factory()\n    self.blocking = $.blocking\n    var items = handle_kwargs(self, kw, method),\n        mode = self.mode = items.mode,\n        encoding = self.encoding = items.encoding\n        qs = items.data,\n        timeout = items.timeout\n    set_timeout(self, timeout)\n    if(qs){\n        url += \"?\" + qs\n    }\n    if(! (items.cache === true)){\n        url += (qs ? \"&\" : \"?\") + (new Date()).getTime()\n    }\n    self.js.open(method.toUpperCase(), url, async)\n\n    if(async){\n        if(mode == \"json\" || mode == \"document\"){\n            self.js.responseType = mode\n        }else{\n            self.js.responseType = \"arraybuffer\"\n            if(mode != \"text\" && mode != \"binary\"){\n                throw _b_.ValueError.$factory(\"invalid mode: \" + mode)\n            }\n        }\n    }else{\n        self.js.overrideMimeType('text/plain;charset=x-user-defined')\n    }\n    for(var key in items.headers){\n        var header = items.headers[key]\n        self.js.setRequestHeader(header[0], header[1])\n    }\n    // Add function read() to return str or bytes according to mode\n    self.js.send()\n}\n\nfunction _request_with_body(method){\n    var $ = $B.args(method, 3, {method: null, url: null, blocking: null},\n        [\"method\", \"url\", \"blocking\"], arguments, {blocking: false},\n        null, \"kw\"),\n        method = $.method,\n        url = $.url,\n        async = !$.blocking,\n        kw = $.kw,\n        content_type\n\n    var self = ajax.$factory()\n    self.js.open(method.toUpperCase(), url, async)\n    var items = handle_kwargs(self, kw, method),\n        data = items.data,\n        timeout = items.timeout\n    set_timeout(self, timeout)\n    for(var key in items.headers){\n        var header = items.headers[key]\n        self.js.setRequestHeader(header[0], header[1])\n        if(key == 'content-type'){\n            content_type = header[1]\n        }\n    }\n    if(method.toUpperCase() == 'POST' && !content_type){\n        // set default Content-Type for POST requests\n        self.js.setRequestHeader('Content-Type',\n            'application/x-www-form-urlencoded')\n    }\n\n    // Add function read() to return str or bytes according to mode\n    self.js.read = function(){\n        return _read(self)\n    }\n    self.js.send(data)\n}\n\nfunction connect(){\n    _request_without_body.call(null, \"connect\", ...arguments)\n}\n\nfunction _delete(){\n    _request_without_body.call(null, \"delete\", ...arguments)\n}\n\nfunction get(){\n    _request_without_body.call(null, \"get\", ...arguments)\n}\n\nfunction head(){\n    _request_without_body.call(null, \"head\", ...arguments)\n}\n\nfunction options(){\n    _request_without_body.call(null, \"options\", ...arguments)\n}\n\nfunction patch(){\n    _request_with_body.call(null, \"put\", ...arguments)\n}\n\nfunction post(){\n    _request_with_body.call(null, \"post\", ...arguments)\n}\n\nfunction put(){\n    _request_with_body.call(null, \"put\", ...arguments)\n}\n\nfunction trace(){\n    _request_without_body.call(null, \"trace\", ...arguments)\n}\n\nfunction file_upload(){\n    // ajax.file_upload(url, file, method=\"POST\", **callbacks)\n    var $ = $B.args(\"file_upload\", 2, {url: null, \"file\": file},\n            [\"url\", \"file\"], arguments, {}, null, \"kw\"),\n        url = $.url,\n        file = $.file,\n        kw = $.kw\n\n    var self = ajax.$factory(),\n        method = 'POST',\n        field_name = 'filetosave'\n\n    if(kw.$string_dict.method !== undefined){\n        method = kw.$string_dict.method[0]\n    }\n\n    if(kw.$string_dict.field_name !== undefined){\n        field_name = kw.$string_dict.field_name[0]\n    }\n\n    var formdata = new FormData()\n    formdata.append(field_name, file, file.name)\n\n    self.js.open(method, url, _b_.True)\n    self.js.send(formdata)\n\n    for(key in kw.$string_dict){\n        if(key.startsWith(\"on\")){\n            ajax.bind(self, key.substr(2), kw.$string_dict[key][0])\n        }\n    }\n}\n\n$B.set_func_names(ajax)\n\nreturn {\n    ajax: ajax,\n    Ajax: ajax,\n    delete: _delete,\n    file_upload: file_upload,\n    connect,\n    get,\n    head,\n    options,\n    patch,\n    post,\n    put,\n    trace\n}\n\n})(__BRYTHON__)\n"], "_base64": [".js", "var $module=(function($B){\n\nvar _b_ = $B.builtins,\n    _keyStr = \"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\"\n\nfunction make_alphabet(altchars){\n    var alphabet = _keyStr\n    if(altchars !== undefined && altchars !== _b_.None){\n        // altchars is an instance of Python bytes\n        var source = altchars.source\n        alphabet = alphabet.substr(0,alphabet.length-3) +\n            _b_.chr(source[0]) + _b_.chr(source[1]) + '='\n    }\n    return alphabet\n}\n\nvar Base64 = {\n    error: function(){return 'binascii_error'},\n\n    encode: function(bytes, altchars){\n\n        var input = bytes.source,\n            output = \"\",\n            chr1, chr2, chr3, enc1, enc2, enc3, enc4\n        var i = 0\n\n        var alphabet = make_alphabet(altchars)\n\n        while(i < input.length){\n\n            chr1 = input[i++]\n            chr2 = input[i++]\n            chr3 = input[i++]\n\n            enc1 = chr1 >> 2\n            enc2 = ((chr1 & 3) << 4) | (chr2 >> 4)\n            enc3 = ((chr2 & 15) << 2) | (chr3 >> 6)\n            enc4 = chr3 & 63\n\n            if(isNaN(chr2)){\n                enc3 = enc4 = 64\n            }else if(isNaN(chr3)){\n                enc4 = 64\n            }\n\n            output = output + alphabet.charAt(enc1) +\n                alphabet.charAt(enc2) +\n                alphabet.charAt(enc3) +\n                alphabet.charAt(enc4)\n\n        }\n        return _b_.bytes.$factory(output, 'utf-8', 'strict')\n    },\n\n\n    decode: function(bytes, altchars, validate){\n        var output = [],\n            chr1, chr2, chr3,\n            enc1, enc2, enc3, enc4\n\n        var alphabet = make_alphabet(altchars)\n\n        var input = bytes.source\n\n        // If validate is set, check that all characters in input\n        // are in the alphabet\n        var _input = ''\n        var padding = 0\n        for(var i = 0, len = input.length; i < len; i++){\n            var car = String.fromCharCode(input[i])\n            var char_num = alphabet.indexOf(car)\n            if(char_num == -1){\n                if(validate){throw Base64.error(\"Non-base64 digit found: \" +\n                    car)}\n            }else if(char_num == 64 && i < input.length - 2){\n                if(validate){throw Base64.error(\"Non-base64 digit found: \" +\n                    car)}\n            }else if(char_num == 64 && i >= input.length - 2){\n                padding++\n                _input += car\n            }else{\n                _input += car\n            }\n        }\n        input = _input\n        if(_input.length == padding){return _b_.bytes.$factory([])}\n        if( _input.length % 4 > 0){throw Base64.error(\"Incorrect padding\")}\n\n        var i = 0\n        while(i < input.length){\n\n            enc1 = alphabet.indexOf(input.charAt(i++))\n            enc2 = alphabet.indexOf(input.charAt(i++))\n            enc3 = alphabet.indexOf(input.charAt(i++))\n            enc4 = alphabet.indexOf(input.charAt(i++))\n\n            chr1 = (enc1 << 2) | (enc2 >> 4)\n            chr2 = ((enc2 & 15) << 4) | (enc3 >> 2)\n            chr3 = ((enc3 & 3) << 6) | enc4\n\n            output.push(chr1)\n\n            if(enc3 != 64){output.push(chr2)}\n            if(enc4 != 64){output.push(chr3)}\n\n        }\n        // return Python bytes\n        return _b_.bytes.$factory(output, 'utf-8', 'strict')\n\n    },\n\n    _utf8_encode: function(string) {\n        string = string.replace(/\\r\\n/g, \"\\n\")\n        var utftext = \"\";\n\n        for(var n = 0; n < string.length; n++){\n\n            var c = string.charCodeAt(n)\n\n            if(c < 128){\n                utftext += String.fromCharCode(c)\n            }else if((c > 127) && (c < 2048)){\n                utftext += String.fromCharCode((c >> 6) | 192)\n                utftext += String.fromCharCode((c & 63) | 128)\n            }else{\n                utftext += String.fromCharCode((c >> 12) | 224)\n                utftext += String.fromCharCode(((c >> 6) & 63) | 128)\n                utftext += String.fromCharCode((c & 63) | 128)\n            }\n\n        }\n\n        return utftext\n    },\n\n    _utf8_decode: function(utftext) {\n        var string = \"\",\n            i = 0,\n            c = c1 = c2 = 0\n\n        while(i < utftext.length){\n\n            c = utftext.charCodeAt(i)\n\n            if(c < 128){\n                string += String.fromCharCode(c)\n                i++\n            }else if((c > 191) && (c < 224)){\n                c2 = utftext.charCodeAt(i + 1)\n                string += String.fromCharCode(((c & 31) << 6) | (c2 & 63))\n                i += 2\n            }else{\n                c2 = utftext.charCodeAt(i + 1)\n                c3 = utftext.charCodeAt(i + 2)\n                string += String.fromCharCode(\n                    ((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63))\n                i += 3\n            }\n\n        }\n\n        return string\n    }\n\n}\n\nreturn {Base64:Base64}\n}\n\n)(__BRYTHON__)"], "_binascii": [".js", "var $module=(function($B){\n\nvar _b_ = $B.builtins,\n    _keyStr = \"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\"\n\nvar error = $B.make_class(\"error\", _b_.Exception.$factory)\nerror.__bases__ = [_b_.Exception]\n$B.set_func_names(error, \"binascii\")\n\nfunction decode(bytes, altchars, validate){\n    var output = [],\n        chr1, chr2, chr3,\n        enc1, enc2, enc3, enc4\n\n    var alphabet = make_alphabet(altchars)\n\n    var input = bytes.source\n\n    // If validate is set, check that all characters in input\n    // are in the alphabet\n    var _input = ''\n    var padding = 0\n    for(var i = 0, len = input.length; i < len; i++){\n        var car = String.fromCharCode(input[i])\n        var char_num = alphabet.indexOf(car)\n        if(char_num == -1){\n            if(validate){throw error.$factory(\"Non-base64 digit found: \" +\n                car)}\n        }else if(char_num == 64 && i < input.length - 2){\n            if(validate){throw error.$factory(\"Non-base64 digit found: \" +\n                car)}\n        }else if(char_num == 64 && i >= input.length - 2){\n            padding++\n            _input += car\n        }else{\n            _input += car\n        }\n    }\n    input = _input\n    if(_input.length == padding){return _b_.bytes.$factory([])}\n    if( _input.length % 4 > 0){throw error.$factory(\"Incorrect padding\")}\n\n    var i = 0\n    while(i < input.length){\n\n        enc1 = alphabet.indexOf(input.charAt(i++))\n        enc2 = alphabet.indexOf(input.charAt(i++))\n        enc3 = alphabet.indexOf(input.charAt(i++))\n        enc4 = alphabet.indexOf(input.charAt(i++))\n\n        chr1 = (enc1 << 2) | (enc2 >> 4)\n        chr2 = ((enc2 & 15) << 4) | (enc3 >> 2)\n        chr3 = ((enc3 & 3) << 6) | enc4\n\n        output.push(chr1)\n\n        if(enc3 != 64){output.push(chr2)}\n        if(enc4 != 64){output.push(chr3)}\n\n    }\n    // return Python bytes\n    return _b_.bytes.$factory(output, 'utf-8', 'strict')\n}\n\n\nvar hex2int = {},\n    hex = '0123456789abcdef'\nfor(var i = 0; i < hex.length; i++){\n    hex2int[hex[i]] = i\n    hex2int[hex[i].toUpperCase()] = i\n}\n\nfunction make_alphabet(altchars){\n    var alphabet = _keyStr\n    if(altchars !== undefined && altchars !== _b_.None){\n        // altchars is an instance of Python bytes\n        var source = altchars.source\n        alphabet = alphabet.substr(0,alphabet.length-3) +\n            _b_.chr(source[0]) + _b_.chr(source[1]) + '='\n    }\n    return alphabet\n}\n\nvar module = {\n    a2b_base64: function(){\n        var $ = $B.args(\"a2b_base64\", 1, {s: null}, ['s'],\n                arguments, {}, null, null)\n        return decode(_b_.str.encode($.s, 'ascii'))\n    },\n    a2b_hex: function(){\n        var $ = $B.args(\"a2b_hex\", 1, {s: null}, ['s'],\n                arguments, {}, null, null),\n            s = $.s\n        if(_b_.isinstance(s, _b_.bytes)){\n            s = _b_.bytes.decode(s, 'ascii')\n        }\n        if(typeof s !== \"string\"){\n            throw _b_.TypeError.$factory(\"argument should be bytes, \" +\n                \"buffer or ASCII string, not '\" + $B.class_name(s) + \"'\")\n        }\n    \n        var len = s.length\n        if(len % 2 == 1){\n            throw _b_.TypeError.$factory('Odd-length string')\n        }\n    \n        var res = []\n        for(var i = 0; i < len; i += 2){\n            res.push((hex2int[s.charAt(i)] << 4) + hex2int[s.charAt(i + 1)])\n        }\n        return _b_.bytes.$factory(res)\n    },\n    b2a_base64: function(){\n        var $ = $B.args(\"b2a_base64\", 1, {data: null}, ['data'],\n                arguments, {}, null, \"kw\")\n        var newline = false\n        if($.kw && $.kw.$string_dict.newline){\n            newline = $.kw.$string_dict.newline[0]\n        }\n\n        var string = $B.to_bytes($.data),\n            res = btoa(String.fromCharCode.apply(null, string))\n        if(newline){res += \"\\n\"}\n        return _b_.bytes.$factory(res, \"ascii\")\n    },\n    b2a_hex: function(obj){\n        var string = $B.to_bytes(obj),\n            res = []\n        function conv(c){\n            if(c > 9){\n                c = c + 'a'.charCodeAt(0) - 10\n            }else{\n                c = c + '0'.charCodeAt(0)\n            }\n            return c\n        }\n        string.forEach(function(char){\n            res.push(conv((char >> 4) & 0xf))\n            res.push(conv(char & 0xf))\n        })\n        return _b_.bytes.$factory(res, \"ascii\")\n    },\n    b2a_uu: function(obj){\n        var string = $B.to_bytes(obj)\n        var len = string.length,\n            res = String.fromCharCode((0x20 + len) & 0x3F)\n        while(string.length > 0){\n            var s = string.slice(0, 3)\n            while(s.length < 3){s.push(String.fromCharCode(0))}\n            var A = s[0],\n                B = s[1],\n                C = s[2]\n            var a = (A >> 2) & 0x3F,\n                b = ((A << 4) | ((B >> 4) & 0xF)) & 0x3F,\n                c = (((B << 2) | ((C >> 6) & 0x3)) & 0x3F),\n                d = C & 0x3F\n            res += String.fromCharCode(0x20 + a, 0x20 + b, 0x20 + c, 0x20 + d)\n            string = string.slice(3)\n        }\n        return _b_.bytes.$factory(res + \"\\n\", \"ascii\")\n    },\n    error: error\n}\n\nmodule.hexlify = module.b2a_hex\nmodule.unhexlify = module.a2b_hex\n\nreturn module\n}\n)(__BRYTHON__)"], "_io_classes": [".js", "var _b_ = __BRYTHON__.builtins\n\nfunction get_self(name, args){\n    return $B.args(name, 1, {self: null}, [\"self\"], args, {}, null, null).self\n}\n\nvar _IOBase = $B.make_class(\"_IOBase\")\n_IOBase.__mro__ = [_b_.object]\n\n_IOBase.close = function(){\n    get_self(\"close\", arguments).__closed = true\n}\n\n_IOBase.flush = function(){\n    get_self(\"flush\", arguments)\n    return _b_.None\n}\n\n// Base class for binary streams that support some kind of buffering.\nvar _BufferedIOBase = $B.make_class(\"_BufferedIOBase\")\n_BufferedIOBase.__mro__ = [_IOBase, _b_.object]\n\n// Base class for raw binary I/O.\nvar _RawIOBase = $B.make_class(\"_RawIOBase\")\n\n_RawIOBase.__mro__ = [_IOBase, _b_.object]\n\n_RawIOBase.read = function(){\n    var $ = $B.args(\"read\", 2, {self: null, size: null}, [\"self\", \"size\"],\n                    arguments, {size: -1}, null, null),\n        self = $.self,\n        size = $.size,\n        res\n    self.$pos = self.$pos || 0\n    if(size == -1){\n        if(self.$pos == 0){\n            res = self.$content\n        }else{\n            res = _b_.bytes.$factory(self.$content.source.slice(self.$pos))\n        }\n        self.$pos = self.$content.source.length - 1\n    }else{\n        res = _b_.bytes.$factory(self.$content.source.slice(self.$pos, size))\n        self.$pos += size\n    }\n    return res\n}\n\n_RawIOBase.readall = function(){\n    return _RawIOBase.read(get_self(\"readall\", arguments))\n}\n\n// Base class for text streams.\n_TextIOBase = $B.make_class(\"_TextIOBase\")\n_TextIOBase.__mro__ = [_IOBase, _b_.object]\n\nvar StringIO = $B.make_class(\"StringIO\",\n    function(){\n        var $ = $B.args(\"StringIO\", 2, {value: null, newline: null},\n                [\"value\", \"newline\"], arguments, {value: '', newline: \"\\n\"},\n                null, null)\n        return {\n            __class__: StringIO,\n            $counter: 0,\n            $content: $.value\n        }\n    }\n)\nStringIO.__mro__ = [$B.Reader, _b_.object]\n\nStringIO.getvalue = function(){\n    var $ = $B.args(\"getvalue\", 1, {self: null},\n            [\"self\"], arguments, {}, null, null)\n    return $.self.$content\n}\n\nStringIO.write = function(){\n    var $ = $B.args(\"write\", 2, {self: null, data: null},\n            [\"self\", \"data\"], arguments, {}, null, null)\n    if(! _b_.isinstance($.data, _b_.str)){\n        throw _b_.TypeError.$factory('string argument expected, got ' +\n            `'${$B.class_name($.data)}'`)\n    }\n    var text = $.self.$content,\n        position = $.self.$counter\n    text = text.substr(0, position) + $.data +\n        text.substr(position + $.data.length)\n    $.self.$content = text\n    $.self.$counter += $.data.length\n    return $.data.length\n}\n$B.set_func_names(StringIO, \"_io\")\n\nvar BytesIO = $B.make_class(\"BytesIO\",\n    function(){\n        var $ = $B.args(\"BytesIO\", 1, {value: null},\n                [\"value\"], arguments, {value: _b_.bytes.$factory()},\n                null, null)\n        return {\n            __class__: BytesIO,\n            $binary: true,\n            $content: $.value,\n            $counter: 0\n        }\n    }\n)\nBytesIO.__mro__ = [$B.Reader, _b_.object]\n\nBytesIO.getbuffer = function(){\n    var self = get_self(\"getbuffer\", arguments)\n    return self.$content\n}\n\nBytesIO.getvalue = function(){\n    var self = get_self(\"getvalue\", arguments)\n    return self.$content\n}\n\nBytesIO.write = function(){\n    var $ = $B.args(\"write\", 2, {self: null, data: null},\n            [\"self\", \"data\"], arguments, {}, null, null)\n    $.self.$content.source = $.self.$content.source.concat(\n        $.data.source)\n    $.self.$counter += $.data.source.length\n    return _b_.None\n}\n$B.set_func_names(BytesIO, \"_io\")\n\nvar $module = (function($B){\n    return {\n        _BufferedIOBase: _BufferedIOBase,\n        _IOBase: _IOBase,\n        _RawIOBase: _RawIOBase,\n        _TextIOBase: $B.make_class(\"_TextIOBase\",\n            function(){\n                return \"fileio\"\n            }\n        ),\n        BytesIO: BytesIO,\n        FileIO: $B.make_class(\"_TextIOBase\",\n            function(){\n                return \"fileio\"\n            }\n        ),\n        StringIO: StringIO,\n        BufferedReader: $B.BufferedReader,\n        BufferedWriter: $B.make_class(\"_TextIOBase\",\n            function(){\n                return \"fileio\"\n            }\n        ),\n        BufferedRWPair: $B.make_class(\"_TextIOBase\",\n            function(){\n                return \"fileio\"\n            }\n        ),\n        BufferedRandom: $B.make_class(\"_TextIOBase\",\n            function(){\n                return \"fileio\"\n            }\n        ),\n        IncrementalNewlineDecoder: $B.make_class(\"_TextIOBase\",\n            function(){\n                return \"fileio\"\n            }\n        ),\n        TextIOWrapper: $B.TextIOWrapper\n    }\n})(__BRYTHON__)\n$module._IOBase.__doc__ = \"_IOBase\""], "_json": [".js", "var $module=(function($B){\n\nvar _b_ = $B.builtins\n\nfunction simple(obj){\n    switch(typeof obj){\n        case 'string':\n        case 'number':\n        case 'boolean':\n            return true\n    }\n    if(obj instanceof Number ||\n            Array.isArray(obj) ||\n            _b_.isinstance(obj, [_b_.list, _b_.tuple, _b_.dict])){\n        return true\n    }\n    return false\n}\n\nfunction to_json(obj, level){\n    var $defaults = {skipkeys:_b_.False, ensure_ascii:_b_.True,\n            check_circular:_b_.True, allow_nan:_b_.True, cls:_b_.None,\n            indent:_b_.None, separators:_b_.None, \"default\":_b_.None,\n            sort_keys:_b_.False},\n        $ = $B.args(\"to_json\", 2, {obj: null, level: null}, ['obj', 'level'],\n                    arguments, {level: 1}, null, \"kw\"),\n        kw = $.kw.$string_dict\n\n    for(key in $defaults){\n        if(kw[key] === undefined){\n            kw[key] = $defaults[key]\n        }else{\n            kw[key] = kw[key][0]\n        }\n    }\n\n    var indent = kw.indent,\n        ensure_ascii = kw.ensure_ascii,\n        separators = kw.separators === _b_.None ?\n             kw.indent === _b_.None ? [', ', ': '] : [',', ': '] :\n            kw.separators,\n        skipkeys = kw.skipkeys,\n        _default = kw.default,\n        sort_keys = kw.sort_keys,\n        allow_nan = kw.allow_nan,\n        check_circular = kw.check_circular\n    var item_separator = separators[0],\n        key_separator = separators[1]\n    if(indent !== _b_.None){\n        var indent_str\n        if(typeof indent == \"string\"){\n            indent_str = indent\n        }else if(typeof indent == \"number\" && indent >= 1){\n            indent_str = \" \".repeat(indent)\n        }else{\n            throw _b_.ValueError.$factory(\"invalid indent: \" +\n                _b_.str.$factory(indent))\n        }\n    }\n    var kwarg = {$nat: \"kw\", kw: {}}\n    for(var key in kw){\n        kwarg.kw[key] = kw[key]\n    }\n    switch(typeof obj){\n        case 'string':\n            var res = JSON.stringify(obj)\n            if(ensure_ascii){\n                var escaped = ''\n                for(var i = 0, len = res.length; i < len; i++){\n                    var u = res.codePointAt(i)\n                    if(u > 127){\n                        u = u.toString(16)\n                        while(u.length < 4){\n                            u = \"0\" + u\n                        }\n                        escaped += '\\\\u' + u\n                    }else{\n                        escaped += res.charAt(i)\n                    }\n                }\n                return escaped\n            }\n            return res\n        case 'boolean':\n            return obj.toString()\n        case 'number':\n            if([Infinity, -Infinity].indexOf(obj) > -1 ||\n                    isNaN(obj)){\n                if(! allow_nan){\n                    throw _b_.ValueError.$factory(\n                        'Out of range float values are not JSON compliant')\n                }\n            }\n            return obj.toString()\n    }\n    if(_b_.isinstance(obj, _b_.list)){\n        var res = []\n        var sep = item_separator,\n            first = '[',\n            last = ']'\n        if(indent !== _b_.None){\n            sep += \"\\n\" + indent_str.repeat(level)\n            first = '[' + '\\n' + indent_str.repeat(level)\n            last = '\\n' + indent_str.repeat(level - 1) + ']'\n            level++\n        }\n        for(var i = 0, len = obj.length; i < len; i++){\n            res.push(to_json(obj[i], level, kwarg))\n        }\n        return first + res.join(sep) + last\n    }else if(obj instanceof Number){\n        return obj.valueOf()\n    }else if(obj === _b_.None){\n        return \"null\"\n    }else if(_b_.isinstance(obj, _b_.dict)){\n        var res = [],\n            items = $B.dict_to_list(obj)\n        if(sort_keys){\n            // Sort keys by alphabetical order\n            items.sort()\n        }\n        var sep = item_separator,\n            first = '{',\n            last = '}'\n        if(indent !== _b_.None){\n            sep += \"\\n\" + indent_str.repeat(level)\n            first = '{' + '\\n' + indent_str.repeat(level)\n            last = '\\n' + indent_str.repeat(level - 1) + '}'\n            level++\n        }\n        for(var i = 0, len = items.length; i < len; i++){\n            var item = items[i]\n            if(! simple(item[0])){\n                if(! skipkeys){\n                    throw _b_.TypeError.$factory(\"keys must be str, int, \" +\n                        \"float, bool or None, not \" + $B.class_name(obj))\n                }\n            }else{\n                // In the result, key must be a string\n                var key = _b_.str.$factory(item[0])\n                // Check circular reference\n                if(check_circular && $B.repr.enter(item[1])){\n                    throw _b_.ValueError.$factory(\"Circular reference detected\")\n                }\n                res.push(\n                    [to_json(key, level, kwarg), to_json(item[1], level, kwarg)].\n                    join(key_separator))\n                if(check_circular){\n                    $B.repr.leave(item[1])\n                }\n            }\n        }\n        return first + res.join(sep) + last\n    }\n    // For other types, use function default if provided\n    if(_default == _b_.None){\n        throw _b_.TypeError.$factory(\"Object of type \" + $B.class_name(obj) +\n            \" is not JSON serializable\")\n    }else{\n        return to_json($B.$call(_default)(obj), level, kwarg)\n    }\n}\n\nfunction from_json(s){\n    var $defaults = {cls: _b_.None, object_hook: _b_.None,\n            parse_float: _b_.None, parse_int: _b_.None,\n            parse_constant: _b_.None, object_pairs_hook: _b_.None},\n        $ = $B.args(\"from_json\", 1, {s: null}, ['s'], arguments, {},\n            null, \"kw\"),\n        kw = $.kw.$string_dict\n    if(Object.keys(kw).length == 0){\n        // default\n        return $B.structuredclone2pyobj(JSON.parse(s))\n    }\n    for(key in $defaults){\n        if(kw[key] === undefined){\n            kw[key] = $defaults[key]\n        }else{\n            kw[key] = kw[key][0]\n        }\n    }\n\n    function reviver(key, value){\n        if(typeof value == \"number\"){\n            if(Number.isInteger(value) && kw.parse_int !== _b_.None){\n                return $B.$call(kw.parse_int)(value.toString())\n            }else if(! Number.isInteger(value) && kw.parse_float !== _b_.None){\n                return $B.$call(kw.parse_float)(value.toString())\n            }else if((value === Infinity || value === -Infinity) &&\n                    kw.parse_constant !== _b_.None){\n                return $B.$call(kw.parse_constant)(value)\n            }else{\n                return value\n            }\n        }else if(isNaN(value) && kw.parse_constant !== _b_.None){\n            return $B.$call(kw.parse_constant)(value)\n        }else if(typeof value == \"object\" && !Array.isArray(value) &&\n                (kw.object_hook !== _b_.None ||\n                    kw.object_pairs_hook !== _b_.None)){\n            // Apply Python function object_hook to the Python dictionary\n            // built from the Javascript object \"value\"\n            var py_dict = $B.structuredclone2pyobj(value)\n            if(kw.object_pairs_hook === _b_.None){\n                var res = $B.$call(kw.object_hook)(py_dict)\n            }else{\n                var items = $B.dict_to_list(py_dict),\n                    res = $B.$call(kw.object_pairs_hook)(items)\n            }\n            // Transform the result of the Python function to a Javascript\n            // object\n            return $B.pyobj2structuredclone(res)\n        }else{\n            return value\n        }\n    }\n\n    return $B.structuredclone2pyobj(JSON.parse(s, reviver))\n}\n\nreturn {\n    dumps: function(){\n        return _b_.str.$factory(to_json.apply(null, arguments))\n    },\n    loads: from_json\n}\n\n})(__BRYTHON__)"], "_jsre": [".js", "var $module = (function($B){\n\n    var _b_ = $B.builtins\n\n    var MatchObject = $B.make_class(\"Match\",\n        function(jsmatch, string, pattern){\n            return {\n                __class__: MatchObject,\n                jsmatch: jsmatch,\n                string: string\n            }\n        }\n    )\n    MatchObject.item = function(self, rank){\n        return self.jsmatch[rank]\n    }\n    MatchObject.group = function(self){\n        var res = []\n        for(var i = 0, _len_i = arguments.length; i < _len_i; i++){\n            if(self.jsmatch[arguments[i]] === undefined){res.push(_b_.None)}\n            else{res.push(self.jsmatch[arguments[i]])}\n        }\n        if(arguments.length == 1){return res[0]}\n        return _b_.tuple.$factory(res)\n    }\n    MatchObject.groups = function(self, _default){\n        if(_default === undefined){_default = _b_.None}\n        var res = []\n        for(var i = 1, _len_i = self.length; i < _len_i; i++){\n            if(self.jsmatch[i] === undefined){res.push(_default)}\n            else{res.push(self.jsmatch[i])}\n        }\n        return _b_.tuple.$factory(res)\n    }\n    MatchObject.start = function(self){\n        return self.index\n    }\n    MatchObject.end = function(self){\n        return self.length - self.index\n    }\n\n    $B.set_func_names(MatchObject, '_jsre')\n\n    var obj = {__class__: $module,\n        __str__: function(){return \"<module 're'>\"}\n    }\n    obj.A = obj.ASCII = 256\n    obj.I = obj.IGNORECASE = 2 // 'i'\n    obj.L = obj.LOCALE = 4\n    obj.M = obj.MULTILINE = 8 // 'm'\n    obj.S = obj.DOTALL = 16\n    obj.U = obj.UNICODE = 32\n    obj.X = obj.VERBOSE = 64\n    obj._is_valid = function(pattern) {\n        if ($B.$options.re == 'pyre'){return false}  //force use of python's re module\n        if ($B.$options.re == 'jsre'){return true}   //force use of brythons re module\n        // FIXME: Improve\n\n        if(! _b_.isinstance(pattern, _b_.str)){\n           // this is probably a SRE_PATTERN, so return false, and let\n           // python's re module handle this.\n           return false\n        }\n        var is_valid = false\n        try{\n            new RegExp(pattern)\n            is_valid = true\n        }\n        catch(e){}\n        if(! is_valid){return false}  //if js won't parse the pattern return false\n\n        // using reference http://www.regular-expressions.info/\n        // to compare python re and javascript regex libraries\n\n        // look for things javascript does not support\n        // check for name capturing group\n        var mylist = ['?P=', '?P<', '(?#', '(?<=', '(?<!', '(?(']\n        for(var i = 0, _len_i = mylist.length; i < _len_i; i++) {\n           if (pattern.indexOf(mylist[i]) > -1) return false\n        }\n\n        var re_list=['\\{,\\d+\\}']\n        for(var i=0, _len_i = re_list.length; i < _len_i; i++) {\n           var _re = new RegExp(re_list[i])\n           if (_re.test(pattern)){return false}\n        }\n\n        // it looks like the pattern has passed all our tests so lets assume\n        // javascript can handle this pattern.\n        return true\n    }\n    var $SRE_PatternDict = {\n        __class__:_b_.type,\n        $infos:{\n            __name__:'SRE_Pattern'\n        }\n    }\n    $SRE_PatternDict.__mro__ = [_b_.object]\n    $SRE_PatternDict.findall = function(self, string){\n        return obj.findall(self.pattern, string, self.flags)\n    }\n    $SRE_PatternDict.finditer = function(self, string){\n        return obj.finditer(self.pattern, string, self.flags)\n    }\n    $SRE_PatternDict.match = function(self, string){\n        return obj.match(self.pattern, string, self.flags)\n    }\n    $SRE_PatternDict.search = function(self, string){\n        return obj.search(self.pattern, string, self.flags)\n    }\n    $SRE_PatternDict.sub = function(self,repl,string){\n        return obj.sub(self.pattern,repl,string,self.flags)\n    }\n    $B.set_func_names($SRE_PatternDict, \"_jsre\")\n    // TODO: groups\n    // TODO: groupindex\n    function normflags(flags){\n        return ((flags & obj.I)? 'i' : '') + ((flags & obj.M)? 'm' : '');\n    }\n    // TODO: fullmatch()\n    // TODO: split()\n    // TODO: subn()\n    obj.compile = function(pattern, flags){\n        return {\n            __class__: $SRE_PatternDict,\n            pattern: pattern,\n            flags: normflags(flags)\n        }\n    }\n    obj.escape = function(string){\n        // Escape all the characters in pattern except ASCII letters, numbers\n        // and '_'. This is useful if you want to match an arbitrary literal\n        // string that may have regular expression metacharacters in it.\n        var res = ''\n        var ok = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_'\n        for(var i = 0, _len_i = string.length; i < _len_i; i++){\n            if(ok.search(string.charAt(i))>-1){res += string.charAt(i)}\n        }\n        return res\n    }\n    obj.findall = function(pattern, string, flags){\n        var $ns=$B.args('re.findall', 2,\n            {pattern:null, string:null}, ['pattern', 'string'],\n            arguments,{}, 'args', 'kw') ,\n            args = $ns['args'] ,\n            _flags = 0;\n        if(args.length>0){var flags = args[0]}\n        else{var _flags = $B.$getattr($ns['kw'], 'get')('flags', 0)}\n\n        var flags = normflags()\n        flags += 'gm'\n        var jsp = new RegExp(pattern,flags),\n            jsmatch = string.match(jsp)\n        if(jsmatch === null){return []}\n        return jsmatch\n    }\n    obj.finditer = function(pattern, string, flags){\n        var $ns=$B.args('re.finditer', 2,\n            {pattern:null, string:null}, ['pattern', 'string'],\n            arguments,{},'args','kw'),\n            args = $ns['args'],\n            _flags = 0;\n        if(args.length>0){var flags=args[0]}\n        else{var _flags = $B.$getattr($ns['kw'], 'get')('flags', 0)}\n\n        var flags = normflags()\n        flags += 'gm'\n        var jsp = new RegExp(pattern, flags),\n            jsmatch = string.match(jsp);\n        if(jsmatch === null){return []}\n\n        var _list = []\n        for(var j = 0, _len_j = jsmatch.length; j < _len_j; j++) {\n            var mo = {}\n            mo._match=jsmatch[j]\n            mo.group = function(){\n               var res = []\n               for(var i=0, _len_i = arguments.length; i < _len_i;i++){\n                   if(jsmatch[arguments[i]] === undefined){res.push(_b_.None)}\n                   else{res.push(jsmatch[arguments[i]])}\n               }\n               if(arguments.length == 1){return res[0]}\n               return _b_.tuple.$factory(res)\n            }\n            mo.groups = function(_default){\n               if(_default === undefined){_default = _b_.None}\n               var res = []\n               for(var i = 1, _len_i = jsmatch.length; i < _len_i; i++){\n                  if(jsmatch[i] === undefined){res.push(_default)}\n                  else{res.push(jsmatch[i])}\n               }\n               return _b_.tuple.$factory(res)\n            }\n            mo.start = function(){return mo._match.index}\n            mo.end = function(){return mo._match.length - mo._match.index}\n            mo.string = string\n            _list.push(mo)\n        }\n        return _list\n    }\n    obj.search = function(pattern, string){\n        var $ns = $B.args('re.search', 2,\n            {pattern:null, string:null},['pattern', 'string'],\n            arguments, {}, 'args', 'kw')\n        var args = $ns['args']\n        if(args.length>0){var flags = args[0]}\n        else{var flags = $B.$getattr($ns['kw'], 'get')('flags', '')}\n        flags = normflags(flags)\n        var jsp = new RegExp(pattern, flags)\n        var jsmatch = string.match(jsp)\n        if(jsmatch === null){return _b_.None}\n        return MatchObject.$factory(jsmatch, string, pattern)\n    }\n    obj.sub = function(pattern, repl, string){\n        var $ns=$B.args('re.search', 3,\n            {pattern: null, repl: null, string: null},\n            ['pattern', 'repl', 'string'],\n            arguments,{}, 'args', 'kw')\n        for($var in $ns){eval(\"var \" + $var + \"=$ns[$var]\")}\n        var args = $ns['args']\n        var count = _b_.dict.get($ns['kw'], 'count', 0)\n        var flags = _b_.dict.get($ns['kw'], 'flags', '')\n        if(args.length > 0){var count = args[0]}\n        if(args.length > 1){var flags = args[1]}\n        flags = normflags(flags)\n        if(typeof repl == \"string\"){\n            // backreferences are \\1, \\2... in Python but $1,$2... in Javascript\n            repl = repl.replace(/\\\\(\\d+)/g, '$$$1')\n        }else if(typeof repl == \"function\"){\n            // the argument passed to the Python function is the match object\n            // the arguments passed to the Javascript function are :\n            // - the matched substring\n            // - the matched groups\n            // - the offset of the matched substring inside the string\n            // - the string being examined\n            var $repl1 = function(){\n                var mo = Object()\n                mo.string = arguments[arguments.length - 1]\n                var matched = arguments[0];\n                var start = arguments[arguments.length - 2]\n                var end = start + matched.length\n                mo.start = function(){return start}\n                mo.end = function(){return end}\n                groups = []\n                for(var i = 1, _len_i = arguments.length-2; i < _len_i; i++){\n                    groups.push(arguments[i])\n                }\n                mo.groups = function(_default){\n                    if(_default === undefined){_default = _b_.None}\n                    var res = []\n                    for(var i = 0, _len_i = groups.length; i < _len_i; i++){\n                        if(groups[i] === undefined){res.push(_default)}\n                        else{res.push(groups[i])}\n                    }\n                    return res\n                }\n                mo.group = function(i){\n                    if(i==0){return matched}\n                    return groups[i-1]\n                }\n                return repl(mo)\n            }\n        }\n        if(count == 0){flags += 'g'}\n        var jsp = new RegExp(pattern, flags)\n        if(typeof repl == 'function'){return string.replace(jsp, $repl1)}\n        else{return string.replace(jsp, repl)}\n    }\n    obj.match = (function(search_func){\n        return function(){\n            // match is like search but pattern must start with ^\n            var pattern = arguments[0]\n            if(pattern.charAt(0) != '^'){pattern = '^'+pattern}\n            var args = [pattern]\n            for(var i = 1, _len_i = arguments.length; i < _len_i; i++){\n                args.push(arguments[i])\n            }\n            return search_func.apply(null, args)\n        }\n    })(obj.search)\n\n    return obj\n}\n)(__BRYTHON__)\n"], "_locale": [".js", "var am = {\n    \"C\": \"AM\",\n    \"aa\": \"saaku\",\n    \"ab\": \"AM\",\n    \"ae\": \"AM\",\n    \"af\": \"vm.\",\n    \"ak\": \"AN\",\n    \"am\": \"\\u1325\\u12cb\\u1275\",\n    \"an\": \"AM\",\n    \"ar\": \"\\u0635\",\n    \"as\": \"\\u09f0\\u09be\\u09a4\\u09bf\\u09aa\\u09c1\",\n    \"av\": \"AM\",\n    \"ay\": \"AM\",\n    \"az\": \"AM\",\n    \"ba\": \"\",\n    \"be\": \"\",\n    \"bg\": \"\",\n    \"bh\": \"AM\",\n    \"bi\": \"AM\",\n    \"bm\": \"AM\",\n    \"bn\": \"AM\",\n    \"bo\": \"\\u0f66\\u0f94\\u0f0b\\u0f51\\u0fb2\\u0f7c\",\n    \"br\": \"A.M.\",\n    \"bs\": \"prijepodne\",\n    \"ca\": \"a. m.\",\n    \"ce\": \"AM\",\n    \"ch\": \"AM\",\n    \"co\": \"\",\n    \"cr\": \"AM\",\n    \"cs\": \"dop.\",\n    \"cu\": \"\\u0414\\u041f\",\n    \"cv\": \"AM\",\n    \"cy\": \"yb\",\n    \"da\": \"\",\n    \"de\": \"\",\n    \"dv\": \"\\u0789\\u0786\",\n    \"dz\": \"\\u0f66\\u0f94\\u0f0b\\u0f46\\u0f0b\",\n    \"ee\": \"\\u014bdi\",\n    \"el\": \"\\u03c0\\u03bc\",\n    \"en\": \"AM\",\n    \"eo\": \"atm\",\n    \"es\": \"\",\n    \"et\": \"AM\",\n    \"eu\": \"AM\",\n    \"fa\": \"\\u0642.\\u0638\",\n    \"ff\": \"\",\n    \"fi\": \"ap.\",\n    \"fj\": \"AM\",\n    \"fo\": \"um fyr.\",\n    \"fr\": \"\",\n    \"fy\": \"AM\",\n    \"ga\": \"r.n.\",\n    \"gd\": \"m\",\n    \"gl\": \"a.m.\",\n    \"gn\": \"a.m.\",\n    \"gu\": \"\\u0aaa\\u0ac2\\u0ab0\\u0acd\\u0ab5\\u00a0\\u0aae\\u0aa7\\u0acd\\u0aaf\\u0abe\\u0ab9\\u0acd\\u0aa8\",\n    \"gv\": \"a.m.\",\n    \"ha\": \"AM\",\n    \"he\": \"AM\",\n    \"hi\": \"\\u092a\\u0942\\u0930\\u094d\\u0935\\u093e\\u0939\\u094d\\u0928\",\n    \"ho\": \"AM\",\n    \"hr\": \"\",\n    \"ht\": \"AM\",\n    \"hu\": \"de.\",\n    \"hy\": \"\",\n    \"hz\": \"AM\",\n    \"ia\": \"a.m.\",\n    \"id\": \"AM\",\n    \"ie\": \"AM\",\n    \"ig\": \"A.M.\",\n    \"ii\": \"\\ua0b5\\ua1aa\\ua20c\\ua210\",\n    \"ik\": \"AM\",\n    \"io\": \"AM\",\n    \"is\": \"f.h.\",\n    \"it\": \"\",\n    \"iu\": \"AM\",\n    \"ja\": \"\\u5348\\u524d\",\n    \"jv\": \"\",\n    \"ka\": \"AM\",\n    \"kg\": \"AM\",\n    \"ki\": \"Kiroko\",\n    \"kj\": \"AM\",\n    \"kk\": \"AM\",\n    \"kl\": \"\",\n    \"km\": \"\\u1796\\u17d2\\u179a\\u17b9\\u1780\",\n    \"kn\": \"\\u0caa\\u0cc2\\u0cb0\\u0ccd\\u0cb5\\u0cbe\\u0cb9\\u0ccd\\u0ca8\",\n    \"ko\": \"\\uc624\\uc804\",\n    \"kr\": \"AM\",\n    \"ks\": \"AM\",\n    \"ku\": \"\\u067e.\\u0646\",\n    \"kv\": \"AM\",\n    \"kw\": \"a.m.\",\n    \"ky\": \"\",\n    \"la\": \"\",\n    \"lb\": \"\",\n    \"lg\": \"AM\",\n    \"li\": \"AM\",\n    \"ln\": \"nt\\u0254\\u0301ng\\u0254\\u0301\",\n    \"lo\": \"\\u0e81\\u0ec8\\u0ead\\u0e99\\u0e97\\u0ec8\\u0ebd\\u0e87\",\n    \"lt\": \"prie\\u0161piet\",\n    \"lu\": \"Dinda\",\n    \"lv\": \"priek\\u0161p.\",\n    \"mg\": \"AM\",\n    \"mh\": \"AM\",\n    \"mi\": \"a.m.\",\n    \"mk\": \"\\u043f\\u0440\\u0435\\u0442\\u043f\\u043b.\",\n    \"ml\": \"AM\",\n    \"mn\": \"??\",\n    \"mo\": \"AM\",\n    \"mr\": \"\\u092e.\\u092a\\u0942.\",\n    \"ms\": \"PG\",\n    \"mt\": \"AM\",\n    \"my\": \"\\u1014\\u1036\\u1014\\u1000\\u103a\",\n    \"na\": \"AM\",\n    \"nb\": \"a.m.\",\n    \"nd\": \"AM\",\n    \"ne\": \"\\u092a\\u0942\\u0930\\u094d\\u0935\\u093e\\u0939\\u094d\\u0928\",\n    \"ng\": \"AM\",\n    \"nl\": \"\",\n    \"nn\": \"f.m.\",\n    \"no\": \"a.m.\",\n    \"nr\": \"AM\",\n    \"nv\": \"AM\",\n    \"ny\": \"AM\",\n    \"oc\": \"AM\",\n    \"oj\": \"AM\",\n    \"om\": \"WD\",\n    \"or\": \"AM\",\n    \"os\": \"AM\",\n    \"pa\": \"\\u0a38\\u0a35\\u0a47\\u0a30\",\n    \"pi\": \"AM\",\n    \"pl\": \"AM\",\n    \"ps\": \"\\u063a.\\u0645.\",\n    \"pt\": \"\",\n    \"qu\": \"a.m.\",\n    \"rc\": \"AM\",\n    \"rm\": \"AM\",\n    \"rn\": \"Z.MU.\",\n    \"ro\": \"a.m.\",\n    \"ru\": \"\",\n    \"rw\": \"AM\",\n    \"sa\": \"\\u092e\\u0927\\u094d\\u092f\\u093e\\u0928\\u092a\\u0942\\u0930\\u094d\\u0935\",\n    \"sc\": \"AM\",\n    \"sd\": \"AM\",\n    \"se\": \"i.b.\",\n    \"sg\": \"ND\",\n    \"sh\": \"AM\",\n    \"si\": \"\\u0db4\\u0dd9.\\u0dc0.\",\n    \"sk\": \"AM\",\n    \"sl\": \"dop.\",\n    \"sm\": \"AM\",\n    \"sn\": \"AM\",\n    \"so\": \"sn.\",\n    \"sq\": \"e paradites\",\n    \"sr\": \"pre podne\",\n    \"ss\": \"AM\",\n    \"st\": \"AM\",\n    \"su\": \"AM\",\n    \"sv\": \"\",\n    \"sw\": \"AM\",\n    \"ta\": \"\\u0b95\\u0bbe\\u0bb2\\u0bc8\",\n    \"te\": \"\\u0c2a\\u0c42\\u0c30\\u0c4d\\u0c35\\u0c3e\\u0c39\\u0c4d\\u0c28\",\n    \"tg\": \"\",\n    \"th\": \"AM\",\n    \"ti\": \"\\u1295\\u1309\\u1206 \\u1230\\u12d3\\u1270\",\n    \"tk\": \"\",\n    \"tl\": \"AM\",\n    \"tn\": \"AM\",\n    \"to\": \"AM\",\n    \"tr\": \"\\u00d6\\u00d6\",\n    \"ts\": \"AM\",\n    \"tt\": \"\",\n    \"tw\": \"AM\",\n    \"ty\": \"AM\",\n    \"ug\": \"\\u0686?\\u0634\\u062a\\u0649\\u0646 \\u0628?\\u0631?\\u0646\",\n    \"uk\": \"AM\",\n    \"ur\": \"AM\",\n    \"uz\": \"TO\",\n    \"ve\": \"AM\",\n    \"vi\": \"SA\",\n    \"vo\": \"AM\",\n    \"wa\": \"AM\",\n    \"wo\": \"\",\n    \"xh\": \"AM\",\n    \"yi\": \"\\ua0b5\\ua1aa\\ua20c\\ua210\",\n    \"yo\": \"\\u00c0\\u00e1r?`\",\n    \"za\": \"AM\",\n    \"zh\": \"\\u4e0a\\u5348\",\n    \"zu\": \"AM\"\n}\nvar pm = {\n    \"C\": \"PM\",\n    \"aa\": \"carra\",\n    \"ab\": \"PM\",\n    \"ae\": \"PM\",\n    \"af\": \"nm.\",\n    \"ak\": \"EW\",\n    \"am\": \"\\u12a8\\u1230\\u12d3\\u1275\",\n    \"an\": \"PM\",\n    \"ar\": \"\\u0645\",\n    \"as\": \"\\u0986\\u09ac\\u09c7\\u09b2\\u09bf\",\n    \"av\": \"PM\",\n    \"ay\": \"PM\",\n    \"az\": \"PM\",\n    \"ba\": \"\",\n    \"be\": \"\",\n    \"bg\": \"\",\n    \"bh\": \"PM\",\n    \"bi\": \"PM\",\n    \"bm\": \"PM\",\n    \"bn\": \"PM\",\n    \"bo\": \"\\u0f55\\u0fb1\\u0f72\\u0f0b\\u0f51\\u0fb2\\u0f7c\",\n    \"br\": \"G.M.\",\n    \"bs\": \"popodne\",\n    \"ca\": \"p. m.\",\n    \"ce\": \"PM\",\n    \"ch\": \"PM\",\n    \"co\": \"\",\n    \"cr\": \"PM\",\n    \"cs\": \"odp.\",\n    \"cu\": \"\\u041f\\u041f\",\n    \"cv\": \"PM\",\n    \"cy\": \"yh\",\n    \"da\": \"\",\n    \"de\": \"\",\n    \"dv\": \"\\u0789\\u078a\",\n    \"dz\": \"\\u0f55\\u0fb1\\u0f72\\u0f0b\\u0f46\\u0f0b\",\n    \"ee\": \"\\u0263etr\\u0254\",\n    \"el\": \"\\u03bc\\u03bc\",\n    \"en\": \"PM\",\n    \"eo\": \"ptm\",\n    \"es\": \"\",\n    \"et\": \"PM\",\n    \"eu\": \"PM\",\n    \"fa\": \"\\u0628.\\u0638\",\n    \"ff\": \"\",\n    \"fi\": \"ip.\",\n    \"fj\": \"PM\",\n    \"fo\": \"um sein.\",\n    \"fr\": \"\",\n    \"fy\": \"PM\",\n    \"ga\": \"i.n.\",\n    \"gd\": \"f\",\n    \"gl\": \"p.m.\",\n    \"gn\": \"p.m.\",\n    \"gu\": \"\\u0a89\\u0aa4\\u0acd\\u0aa4\\u0ab0\\u00a0\\u0aae\\u0aa7\\u0acd\\u0aaf\\u0abe\\u0ab9\\u0acd\\u0aa8\",\n    \"gv\": \"p.m.\",\n    \"ha\": \"PM\",\n    \"he\": \"PM\",\n    \"hi\": \"\\u0905\\u092a\\u0930\\u093e\\u0939\\u094d\\u0928\",\n    \"ho\": \"PM\",\n    \"hr\": \"\",\n    \"ht\": \"PM\",\n    \"hu\": \"du.\",\n    \"hy\": \"\",\n    \"hz\": \"PM\",\n    \"ia\": \"p.m.\",\n    \"id\": \"PM\",\n    \"ie\": \"PM\",\n    \"ig\": \"P.M.\",\n    \"ii\": \"\\ua0b5\\ua1aa\\ua20c\\ua248\",\n    \"ik\": \"PM\",\n    \"io\": \"PM\",\n    \"is\": \"e.h.\",\n    \"it\": \"\",\n    \"iu\": \"PM\",\n    \"ja\": \"\\u5348\\u5f8c\",\n    \"jv\": \"\",\n    \"ka\": \"PM\",\n    \"kg\": \"PM\",\n    \"ki\": \"Hwa\\u0129-in\\u0129\",\n    \"kj\": \"PM\",\n    \"kk\": \"PM\",\n    \"kl\": \"\",\n    \"km\": \"\\u179b\\u17d2\\u1784\\u17b6\\u1785\",\n    \"kn\": \"\\u0c85\\u0caa\\u0cb0\\u0cbe\\u0cb9\\u0ccd\\u0ca8\",\n    \"ko\": \"\\uc624\\ud6c4\",\n    \"kr\": \"PM\",\n    \"ks\": \"PM\",\n    \"ku\": \"\\u062f.\\u0646\",\n    \"kv\": \"PM\",\n    \"kw\": \"p.m.\",\n    \"ky\": \"\",\n    \"la\": \"\",\n    \"lb\": \"\",\n    \"lg\": \"PM\",\n    \"li\": \"PM\",\n    \"ln\": \"mp\\u00f3kwa\",\n    \"lo\": \"\\u0eab\\u0ebc\\u0eb1\\u0e87\\u0e97\\u0ec8\\u0ebd\\u0e87\",\n    \"lt\": \"popiet\",\n    \"lu\": \"Dilolo\",\n    \"lv\": \"p\\u0113cp.\",\n    \"mg\": \"PM\",\n    \"mh\": \"PM\",\n    \"mi\": \"p.m.\",\n    \"mk\": \"\\u043f\\u043e\\u043f\\u043b.\",\n    \"ml\": \"PM\",\n    \"mn\": \"?\\u0425\",\n    \"mo\": \"PM\",\n    \"mr\": \"\\u092e.\\u0928\\u0902.\",\n    \"ms\": \"PTG\",\n    \"mt\": \"PM\",\n    \"my\": \"\\u100a\\u1014\\u1031\",\n    \"na\": \"PM\",\n    \"nb\": \"p.m.\",\n    \"nd\": \"PM\",\n    \"ne\": \"\\u0905\\u092a\\u0930\\u093e\\u0939\\u094d\\u0928\",\n    \"ng\": \"PM\",\n    \"nl\": \"\",\n    \"nn\": \"e.m.\",\n    \"no\": \"p.m.\",\n    \"nr\": \"PM\",\n    \"nv\": \"PM\",\n    \"ny\": \"PM\",\n    \"oc\": \"PM\",\n    \"oj\": \"PM\",\n    \"om\": \"WB\",\n    \"or\": \"PM\",\n    \"os\": \"PM\",\n    \"pa\": \"\\u0a36\\u0a3e\\u0a2e\",\n    \"pi\": \"PM\",\n    \"pl\": \"PM\",\n    \"ps\": \"\\u063a.\\u0648.\",\n    \"pt\": \"\",\n    \"qu\": \"p.m.\",\n    \"rc\": \"PM\",\n    \"rm\": \"PM\",\n    \"rn\": \"Z.MW.\",\n    \"ro\": \"p.m.\",\n    \"ru\": \"\",\n    \"rw\": \"PM\",\n    \"sa\": \"\\u092e\\u0927\\u094d\\u092f\\u093e\\u0928\\u092a\\u091a\\u094d\\u092f\\u093e\\u0924\",\n    \"sc\": \"PM\",\n    \"sd\": \"PM\",\n    \"se\": \"e.b.\",\n    \"sg\": \"LK\",\n    \"sh\": \"PM\",\n    \"si\": \"\\u0db4.\\u0dc0.\",\n    \"sk\": \"PM\",\n    \"sl\": \"pop.\",\n    \"sm\": \"PM\",\n    \"sn\": \"PM\",\n    \"so\": \"gn.\",\n    \"sq\": \"e pasdites\",\n    \"sr\": \"po podne\",\n    \"ss\": \"PM\",\n    \"st\": \"PM\",\n    \"su\": \"PM\",\n    \"sv\": \"\",\n    \"sw\": \"PM\",\n    \"ta\": \"\\u0bae\\u0bbe\\u0bb2\\u0bc8\",\n    \"te\": \"\\u0c05\\u0c2a\\u0c30\\u0c3e\\u0c39\\u0c4d\\u0c28\",\n    \"tg\": \"\",\n    \"th\": \"PM\",\n    \"ti\": \"\\u12f5\\u1215\\u122d \\u1230\\u12d3\\u1275\",\n    \"tk\": \"\",\n    \"tl\": \"PM\",\n    \"tn\": \"PM\",\n    \"to\": \"PM\",\n    \"tr\": \"\\u00d6S\",\n    \"ts\": \"PM\",\n    \"tt\": \"\",\n    \"tw\": \"PM\",\n    \"ty\": \"PM\",\n    \"ug\": \"\\u0686?\\u0634\\u062a\\u0649\\u0646 \\u0643?\\u064a\\u0649\\u0646\",\n    \"uk\": \"PM\",\n    \"ur\": \"PM\",\n    \"uz\": \"TK\",\n    \"ve\": \"PM\",\n    \"vi\": \"CH\",\n    \"vo\": \"PM\",\n    \"wa\": \"PM\",\n    \"wo\": \"\",\n    \"xh\": \"PM\",\n    \"yi\": \"\\ua0b5\\ua1aa\\ua20c\\ua248\",\n    \"yo\": \"?`s\\u00e1n\",\n    \"za\": \"PM\",\n    \"zh\": \"\\u4e0b\\u5348\",\n    \"zu\": \"PM\"\n}\n\nvar X_format = {\n    \"%H:%M:%S\": [\n        \"C\",\n        \"ab\",\n        \"ae\",\n        \"af\",\n        \"an\",\n        \"av\",\n        \"ay\",\n        \"az\",\n        \"ba\",\n        \"be\",\n        \"bg\",\n        \"bh\",\n        \"bi\",\n        \"bm\",\n        \"bo\",\n        \"br\",\n        \"bs\",\n        \"ca\",\n        \"ce\",\n        \"ch\",\n        \"co\",\n        \"cr\",\n        \"cs\",\n        \"cu\",\n        \"cv\",\n        \"cy\",\n        \"da\",\n        \"de\",\n        \"dv\",\n        \"eo\",\n        \"es\",\n        \"et\",\n        \"eu\",\n        \"ff\",\n        \"fj\",\n        \"fo\",\n        \"fr\",\n        \"fy\",\n        \"ga\",\n        \"gd\",\n        \"gl\",\n        \"gn\",\n        \"gu\",\n        \"gv\",\n        \"ha\",\n        \"he\",\n        \"hi\",\n        \"ho\",\n        \"hr\",\n        \"ht\",\n        \"hu\",\n        \"hy\",\n        \"hz\",\n        \"ia\",\n        \"ie\",\n        \"ig\",\n        \"ik\",\n        \"io\",\n        \"is\",\n        \"it\",\n        \"ja\",\n        \"ka\",\n        \"kg\",\n        \"ki\",\n        \"kj\",\n        \"kk\",\n        \"kl\",\n        \"km\",\n        \"kn\",\n        \"kv\",\n        \"kw\",\n        \"ky\",\n        \"la\",\n        \"lb\",\n        \"lg\",\n        \"li\",\n        \"ln\",\n        \"lo\",\n        \"lt\",\n        \"lu\",\n        \"lv\",\n        \"mg\",\n        \"mh\",\n        \"mk\",\n        \"mn\",\n        \"mo\",\n        \"mr\",\n        \"mt\",\n        \"my\",\n        \"na\",\n        \"nb\",\n        \"nd\",\n        \"ng\",\n        \"nl\",\n        \"nn\",\n        \"no\",\n        \"nr\",\n        \"nv\",\n        \"ny\",\n        \"oj\",\n        \"or\",\n        \"os\",\n        \"pi\",\n        \"pl\",\n        \"ps\",\n        \"pt\",\n        \"rc\",\n        \"rm\",\n        \"rn\",\n        \"ro\",\n        \"ru\",\n        \"rw\",\n        \"sa\",\n        \"sc\",\n        \"se\",\n        \"sg\",\n        \"sh\",\n        \"sk\",\n        \"sl\",\n        \"sm\",\n        \"sn\",\n        \"sr\",\n        \"ss\",\n        \"st\",\n        \"su\",\n        \"sv\",\n        \"sw\",\n        \"ta\",\n        \"te\",\n        \"tg\",\n        \"th\",\n        \"tk\",\n        \"tl\",\n        \"tn\",\n        \"tr\",\n        \"ts\",\n        \"tt\",\n        \"tw\",\n        \"ty\",\n        \"ug\",\n        \"uk\",\n        \"uz\",\n        \"ve\",\n        \"vo\",\n        \"wa\",\n        \"wo\",\n        \"xh\",\n        \"yo\",\n        \"za\",\n        \"zh\",\n        \"zu\"\n    ],\n    \"%i:%M:%S %p\": [\n        \"aa\",\n        \"ak\",\n        \"am\",\n        \"bn\",\n        \"el\",\n        \"en\",\n        \"iu\",\n        \"kr\",\n        \"ks\",\n        \"mi\",\n        \"ml\",\n        \"ms\",\n        \"ne\",\n        \"om\",\n        \"sd\",\n        \"so\",\n        \"sq\",\n        \"ti\",\n        \"to\",\n        \"ur\",\n        \"vi\"\n    ],\n    \"%I:%M:%S %p\": [\n        \"ar\",\n        \"fa\",\n        \"ku\",\n        \"qu\"\n    ],\n    \"%p %i:%M:%S\": [\n        \"as\",\n        \"ii\",\n        \"ko\",\n        \"yi\"\n    ],\n    \"\\u0f46\\u0f74\\u0f0b\\u0f5a\\u0f7c\\u0f51\\u0f0b%i:%M:%S %p\": [\n        \"dz\"\n    ],\n    \"%p ga %i:%M:%S\": [\n        \"ee\"\n    ],\n    \"%H.%M.%S\": [\n        \"fi\",\n        \"id\",\n        \"jv\",\n        \"oc\",\n        \"si\"\n    ],\n    \"%p %I:%M:%S\": [\n        \"pa\"\n    ]\n}\nvar x_format = {\n    \"%m/%d/%y\": [\n        \"C\"\n    ],\n    \"%d/%m/%Y\": [\n        \"aa\",\n        \"am\",\n        \"bm\",\n        \"bn\",\n        \"ca\",\n        \"co\",\n        \"cy\",\n        \"el\",\n        \"es\",\n        \"ff\",\n        \"fr\",\n        \"ga\",\n        \"gd\",\n        \"gl\",\n        \"gn\",\n        \"gv\",\n        \"ha\",\n        \"he\",\n        \"id\",\n        \"ig\",\n        \"it\",\n        \"iu\",\n        \"jv\",\n        \"ki\",\n        \"kr\",\n        \"kw\",\n        \"la\",\n        \"lg\",\n        \"ln\",\n        \"lo\",\n        \"lu\",\n        \"mi\",\n        \"ml\",\n        \"ms\",\n        \"mt\",\n        \"nd\",\n        \"oc\",\n        \"om\",\n        \"pt\",\n        \"qu\",\n        \"rn\",\n        \"sd\",\n        \"sg\",\n        \"so\",\n        \"sw\",\n        \"ti\",\n        \"to\",\n        \"uk\",\n        \"ur\",\n        \"uz\",\n        \"vi\",\n        \"wo\",\n        \"yo\"\n    ],\n    \"%m/%d/%Y\": [\n        \"ab\",\n        \"ae\",\n        \"an\",\n        \"av\",\n        \"ay\",\n        \"bh\",\n        \"bi\",\n        \"ch\",\n        \"cr\",\n        \"cv\",\n        \"ee\",\n        \"en\",\n        \"fj\",\n        \"ho\",\n        \"ht\",\n        \"hz\",\n        \"ie\",\n        \"ik\",\n        \"io\",\n        \"kg\",\n        \"kj\",\n        \"ks\",\n        \"kv\",\n        \"li\",\n        \"mh\",\n        \"mo\",\n        \"na\",\n        \"ne\",\n        \"ng\",\n        \"nv\",\n        \"ny\",\n        \"oj\",\n        \"pi\",\n        \"rc\",\n        \"sc\",\n        \"sh\",\n        \"sm\",\n        \"su\",\n        \"tl\",\n        \"tw\",\n        \"ty\",\n        \"wa\",\n        \"za\",\n        \"zu\"\n    ],\n    \"%Y-%m-%d\": [\n        \"af\",\n        \"br\",\n        \"ce\",\n        \"dz\",\n        \"eo\",\n        \"ko\",\n        \"lt\",\n        \"mg\",\n        \"nr\",\n        \"rw\",\n        \"se\",\n        \"si\",\n        \"sn\",\n        \"ss\",\n        \"st\",\n        \"sv\",\n        \"tn\",\n        \"ts\",\n        \"ug\",\n        \"ve\",\n        \"vo\",\n        \"xh\"\n    ],\n    \"%Y/%m/%d\": [\n        \"ak\",\n        \"bo\",\n        \"eu\",\n        \"ia\",\n        \"ii\",\n        \"ja\",\n        \"ku\",\n        \"yi\",\n        \"zh\"\n    ],\n    \"null\": [\n        \"ar\",\n        \"fa\",\n        \"ps\",\n        \"th\"\n    ],\n    \"%d-%m-%Y\": [\n        \"as\",\n        \"da\",\n        \"fy\",\n        \"hi\",\n        \"kl\",\n        \"mr\",\n        \"my\",\n        \"nl\",\n        \"rm\",\n        \"sa\",\n        \"ta\"\n    ],\n    \"%d.%m.%Y\": [\n        \"az\",\n        \"cs\",\n        \"de\",\n        \"et\",\n        \"fi\",\n        \"fo\",\n        \"hy\",\n        \"is\",\n        \"ka\",\n        \"kk\",\n        \"lv\",\n        \"mk\",\n        \"nb\",\n        \"nn\",\n        \"no\",\n        \"os\",\n        \"pl\",\n        \"ro\",\n        \"ru\",\n        \"sq\",\n        \"tg\",\n        \"tr\",\n        \"tt\"\n    ],\n    \"%d.%m.%y\": [\n        \"ba\",\n        \"be\",\n        \"lb\"\n    ],\n    \"%d.%m.%Y \\u0433.\": [\n        \"bg\"\n    ],\n    \"%d.%m.%Y.\": [\n        \"bs\",\n        \"hr\",\n        \"sr\"\n    ],\n    \"%Y.%m.%d\": [\n        \"cu\",\n        \"mn\"\n    ],\n    \"%d/%m/%y\": [\n        \"dv\",\n        \"km\"\n    ],\n    \"%d-%m-%y\": [\n        \"gu\",\n        \"kn\",\n        \"or\",\n        \"pa\",\n        \"te\"\n    ],\n    \"%Y. %m. %d.\": [\n        \"hu\"\n    ],\n    \"%d-%b %y\": [\n        \"ky\"\n    ],\n    \"%d. %m. %Y\": [\n        \"sk\",\n        \"sl\"\n    ],\n    \"%d.%m.%y \\u00fd.\": [\n        \"tk\"\n    ]\n}\n\n\nvar $module=(function($B){\n    var _b_ = $B.builtins\n    return {\n        CHAR_MAX: 127,\n        LC_ALL: 6,\n        LC_COLLATE: 3,\n        LC_CTYPE: 0,\n        LC_MESSAGES: 5,\n        LC_MONETARY: 4,\n        LC_NUMERIC: 1,\n        LC_TIME: 2,\n        Error: _b_.ValueError,\n\n        _date_format: function(spec, hour){\n            var t,\n                locale = __BRYTHON__.locale.substr(0, 2)\n\n            if(spec == \"p\"){\n                var res = hours < 12 ? am[locale] : pm[locale]\n                if(res === undefined){\n                    throw _b_.ValueError.$factory(\"no format \" + spec + \" for locale \" +\n                        locale)\n                }\n                return res\n            }\n            else if(spec == \"x\"){\n                t = x_format\n            }else if(spec == \"X\"){\n                t = X_format\n            }else{\n                throw _b_.ValueError.$factory(\"invalid format\", spec)\n            }\n            for(var key in t){\n                if(t[key].indexOf(locale) > -1){\n                    return key\n                }\n            }\n            throw _b_.ValueError.$factory(\"no format \" + spec + \" for locale \" +\n                locale)\n        },\n\n        localeconv: function(){\n            var conv = {'grouping': [127],\n                    'currency_symbol': '',\n                    'n_sign_posn': 127,\n                    'p_cs_precedes': 127,\n                    'n_cs_precedes': 127,\n                    'mon_grouping': [],\n                    'n_sep_by_space': 127,\n                    'decimal_point': '.',\n                    'negative_sign': '',\n                    'positive_sign': '',\n                    'p_sep_by_space': 127,\n                    'int_curr_symbol': '',\n                    'p_sign_posn': 127,\n                    'thousands_sep': '',\n                    'mon_thousands_sep': '',\n                    'frac_digits': 127,\n                    'mon_decimal_point': '',\n                    'int_frac_digits': 127\n             }\n             var res = $B.empty_dict()\n             for(var key in conv){\n                 res.$string_dict[key] = [conv, res.$order++]\n             }\n             return res\n         },\n\n        setlocale : function(){\n            var $ = $B.args(\"setlocale\", 2, {category: null, locale: null},\n                [\"category\", \"locale\"], arguments, {locale: _b_.None},\n                null, null)\n            /// XXX category is currently ignored\n            if($.locale == \"\"){\n                // use browser language setting, if it is set\n                var LANG = ($B.language || \"\").substr(0, 2)\n                if(am.hasOwnProperty(LANG)){\n                    $B.locale = LANG\n                    return LANG\n                }else{\n                    console.log(\"Unknown locale: \" + LANG)\n                }\n            }else if($.locale === _b_.None){\n                // return current locale\n                return $B.locale\n            }else{\n                // Only use 2 first characters\n                try{$.locale.substr(0, 2)}\n                catch(err){\n                    throw $module.Error.$factory(\"Invalid locale: \" + $.locale)\n                }\n                if(am.hasOwnProperty($.locale.substr(0, 2))){\n                    $B.locale = $.locale\n                    return $.locale\n                }else{\n                    throw $module.Error.$factory(\"Unknown locale: \" + $.locale)\n                }\n            }\n        }\n    }\n})(__BRYTHON__)\n"], "_multiprocessing": [".js", "// multiprocessing\nvar $module = (function($B){\n\nvar _b_ = $B.builtins\n\nvar Process = {\n    __class__:_b_.type,\n    __mro__: [_b_.object],\n    $infos:{\n        __name__:'Process'\n    },\n    $is_class: true\n}\n\nvar $convert_args=function(args) {\n    var _list=[]\n    for(var i=0, _len_i = args.length; i < _len_i; i++) {\n      var _a=args[i]\n      if(_b_.isinstance(_a, _b_.str)){_list.push(\"'\"+_a+\"'\")} else {_list.push(_a)}\n    }\n\n    return _list.join(',')\n}\n\nProcess.is_alive = function(self){return self.$alive}\n\nProcess.join = function(self, timeout){\n   // need to block until process is complete\n   // could probably use a addEventListener to execute all existing code\n   // after this join statement\n\n   self.$worker.addEventListener('message', function (e) {\n        var data=e.data\n        if (data.stdout != '') { // output stdout from process\n           $B.stdout.write(data.stdout)\n        }\n   }, false);\n}\n\nProcess.run = function(self){\n   //fix me\n}\n\nProcess.start = function(self){\n   self.$worker.postMessage({target: self.$target,\n                             args: $convert_args(self.$args),\n                          //   kwargs: self.$kwargs\n                           })\n   self.$worker.addEventListener('error', function(e) { throw e})\n   self.$alive=true\n}\n\nProcess.terminate = function(self){\n   self.$worker.terminate()\n   self.$alive=false\n}\n\n// variables\n//name\n//daemon\n//pid\n//exitcode\n\nProcess. $factory = function(){\n    //arguments group=None, target=None, name=None, args=(), kwargs=()\n\n    var $ns=$B.args('Process',0,{},[],arguments,{},null,'kw')\n    var kw=$ns['kw']\n\n    var target=_b_.dict.get($ns['kw'],'target', _b_.None)\n    var args=_b_.dict.get($ns['kw'],'args', _b_.tuple.$factory())\n\n    var worker = new Worker('/src/web_workers/multiprocessing.js')\n\n    var res = {\n        __class__:Process,\n        $worker: worker,\n        name: $ns['name'] || _b_.None,\n        $target: target+'',\n        $args: args,\n        //$kwargs: $ns['kw'],\n        $alive: false\n    }\n    return res\n}\n\n$B.set_func_names(Process, \"multiprocessing\")\n\nvar Pool = $B.make_class(\"Pool\")\n\nPool.__enter__ = function(self){}\nPool.__exit__ = function(self){}\n\nPool.__str__ = Pool.toString = Pool.__repr__=function(self){\n   return '<object Pool>'\n}\n\nPool.map = function(){\n\n   var $ns=$B.args('Pool.map', 3,\n       {self:null, func:null, fargs:null}, ['self', 'func', 'fargs'],\n       arguments,{},'args','kw')\n   var func = $ns['func']\n   var fargs = $ns['fargs']\n\n   var _results = []\n\n   fargs = _b_.iter(fargs)\n\n   var _pos = 0\n   console.log(self.$processes)\n   _workers =[]\n   for(var i=0; i < self.$processes; i++) {\n       _workers[i] = new Worker('/src/web_workers/multiprocessing.js')\n       var arg\n\n       try{arg = $B.$getattr(fargs, '__next__')()}\n       catch(err) {\n          if (err.__class__ !== _b_.StopIteration) throw err\n       }\n       console.log(arg)\n       _workers[i].finished=false\n       _workers[i].postMessage({target: func+'', pos: _pos,\n                             args: $convert_args([arg])})\n       _pos++\n\n       _workers[i].addEventListener('message', function(e) {\n           _results[e.data.pos]=e.data.result\n           if (_results.length == args.length) return _results\n\n           try {\n               arg = $B.$getattr(fargs, '__next__')()\n               e.currentTarget.postMessage({target: func+'', pos: _pos,\n                                            args: $convert_args([arg])})\n               _pos++\n           } catch(err) {\n               if (err.__class__ !== _b_.StopIteration) throw err\n               this.finished=true\n           }\n       }, false);\n   }\n}\n\nPool.apply_async = function(){\n\n   var $ns=$B.$MakeArgs('apply_async', 3,\n       {self:null, func:null, fargs:null}, ['self', 'func', 'fargs'],\n       arguments,{},'args','kw')\n   var func = $ns['func']\n   var fargs = $ns['fargs']\n\n   fargs = _b_.iter(fargs)\n\n   async_result = {}\n   async_result.get = function(timeout){\n                      console.log(results)\n                      console.log(fargs)\n                      return this.results}\n   async_result.results=[]\n\n   var _pos=0\n\n   _workers=[]\n   for(var i=0; i < self.$processes; i++) {\n       _workers[i] = new Worker('/src/web_workers/multiprocessing.js')\n       var arg\n\n       try{arg = $B.$getattr(fargs, '__next__')()}\n       catch(err) {\n          if (err.__class__ !== _b_.StopIteration) throw err\n       }\n       //console.log(arg)\n       //_workers[i].finished=false\n       _workers[i].postMessage({target: func+'', pos: _pos,\n                             args: $convert_args([arg])})\n       _pos++\n\n       _workers[i].addEventListener('message', function(e) {\n           async_result.results[e.data.pos]=e.data.result\n           //if (_results.length == args.length) return _results\n\n           try {\n               arg = $B.$getattr(fargs, '__next__')()\n               e.currentTarget.postMessage({target: func+'', pos: _pos,\n                                            args: $convert_args([arg])})\n               _pos++\n           } catch(err) {\n               if (err.__class__ !== _b_.StopIteration) throw err\n               this.finished=true\n           }\n       }, false);\n   }\n\n   console.log(\"return\", async_result)\n   return async_result\n}\n\nPool.$factory = function(){\n    console.log(\"pool\")\n    console.log(arguments)\n    var $ns=$B.args('Pool',1,\n        {processes:null},['processes'],arguments,{},'args','kw')\n\n    var processes = $ns['processes']\n\n    if (processes === _b_.None) {\n       // look to see if we have stored cpu_count in local storage\n       // maybe we should create a brython config file with settings,etc..??\n\n       // if not there use a tool such as Core Estimator to calculate number of cpu's\n       // http://eligrey.com/blog/post/cpu-core-estimation-with-javascript\n    }\n\n    console.log(processes)\n    var res = {\n        __class__:Pool,\n        $processes:processes\n    }\n    return res\n}\n\n$B.set_func_names(Pool, \"multiprocessing\")\n\nreturn {Process:Process, Pool:Pool}\n\n})(__BRYTHON__)\n"], "_posixsubprocess": [".js", "var $module=(function($B){\n\n    return {\n       cloexec_pipe: function() {}   // fixme\n    }\n})(__BRYTHON__)\n"], "_profile": [".js", "// Private interface to the profiling instrumentation implemented in py_utils.js.\n// Uses local a copy of the eval function from py_builtin_functions.js\n\nvar $module=(function($B) {\n    eval($B.InjectBuiltins());\n    return {\n        brython:$B,\n        data:$B.$profile_data,\n        start:$B.$profile.start,\n        stop:$B.$profile.stop,\n        pause:$B.$profile.pause,\n        status:$B.$profile.status,\n        clear:$B.$profile.clear,\n        elapsed:$B.$profile.elapsed,\n        run:function(src,_globals,_locals,nruns) {\n            var current_frame = $B.frames_stack[$B.frames_stack.length-1]\n            if(current_frame!==undefined){\n                var current_locals_id = current_frame[0].replace(/\\./,'_'),\n             current_globals_id = current_frame[2].replace(/\\./,'_')\n            }\n\n            var is_exec = true,\n                leave = false\n\n            // code will be run in a specific block\n            var globals_id = '$profile_'+$B.UUID(),\n             locals_id\n\n             if(_locals===_globals){\n                 locals_id = globals_id\n             }else{\n                 locals_id = '$profile_'+$B.UUID()\n             }\n             // Initialise the object for block namespaces\n             eval('var $locals_'+globals_id+' = {}\\nvar $locals_'+locals_id+' = {}')\n\n             // Initialise block globals\n\n            // A _globals dictionary is provided, set or reuse its attribute\n            // globals_id\n            _globals.globals_id = _globals.globals_id || globals_id\n            globals_id = _globals.globals_id\n\n            if(_locals === _globals || _locals === undefined){\n                locals_id = globals_id\n                parent_scope = $B.builtins_scope\n            }else{\n                // The parent block of locals must be set to globals\n                parent_scope = {\n                    id: globals_id,\n                    parent_block: $B.builtins_scope,\n                    binding: {}\n                }\n                for(var attr in _globals.$string_dict){\n                    parent_scope.binding[attr] = true\n                }\n            }\n\n            // Initialise block globals\n            if(_globals.$jsobj){var items = _globals.$jsobj}\n            else{var items = _globals.$string_dict}\n            for(var item in items){\n                item1 = to_alias(item)\n                try{\n                    eval('$locals_' + globals_id + '[\"' + item1 +\n                        '\"] = items[item]')\n                }catch(err){\n                    console.log(err)\n                    console.log('error setting', item)\n                    break\n                }\n            }\n\n             // Initialise block locals\n            var items = _b_.dict.items(_locals), item\n            if(_locals.$jsobj){var items = _locals.$jsobj}\n            else{var items = _locals.$string_dict}\n            for(var item in items){\n                item1 = to_alias(item)\n                try{\n                    eval('$locals_' + locals_id + '[\"' + item[0] + '\"] = item[1]')\n                }catch(err){\n                    console.log(err)\n                    console.log('error setting', item)\n                    break\n                }\n            }\n             //var nb_modules = Object.keys(__BRYTHON__.modules).length\n             //console.log('before exec', nb_modules)\n\n            console.log(\"call py2js\", src, globals_id, locals_id, parent_scope)\n            var root = $B.py2js(src, globals_id, locals_id, parent_scope),\n                js, gns, lns\n\n             try{\n\n                 var js = root.to_js()\n\n                     var i,res,gns;\n                     for(i=0;i<nruns;i++) {\n                         res = eval(js)\n                         gns = eval('$locals_'+globals_id)\n                     }\n\n                     // Update _locals with the namespace after execution\n                     if(_locals!==undefined){\n                         var lns = eval('$locals_'+locals_id)\n                         var setitem = getattr(_locals,'__setitem__')\n                         for(var attr in lns){\n                             if(attr.charAt(0)=='$'){continue}\n                             setitem(attr, lns[attr])\n                         }\n                     }else{\n                         for(var attr in lns){current_frame[1][attr] = lns[attr]}\n                     }\n\n                     if(_globals!==undefined){\n                         // Update _globals with the namespace after execution\n                         var setitem = getattr(_globals,'__setitem__')\n                         for(var attr in gns){\n                             if(attr.charAt(0)=='$'){continue}\n                             setitem(attr, gns[attr])\n                         }\n                     }else{\n                         for(var attr in gns){\n                             current_frame[3][attr] = gns[attr]\n                         }\n                     }\n\n                     // fixme: some extra variables are bleeding into locals...\n                     /*  This also causes issues for unittests */\n                     if(res===undefined) return _b_.None\n                         return res\n             }catch(err){\n                 if(err.$py_error===undefined){throw $B.exception(err)}\n                 throw err\n             }finally{\n\n                 delete __BRYTHON__.modules[globals_id]\n                 delete __BRYTHON__.modules[locals_id]\n                 $B.clear_ns(globals_id)\n                 $B.clear_ns(locals_id)\n\n                 if(!is_exec && leave_frame){\n                     // For eval(), the finally clause with \"leave_frame\" was removed\n                     // so we must execute it here\n                     $B.frames_stack.pop()\n                 }\n             }\n        }\n    }\n})(__BRYTHON__)\n"], "_sre_utils": [".js", "var $module=(function($B){\n\n    function unicode_iscased(cp){\n        // cp : Unicode code point\n        var letter = String.fromCodePoint(cp)\n        return (letter != letter.toLowerCase() ||\n            letter != letter.toUpperCase())\n    }\n\n    function ascii_iscased(cp){\n        if(cp > 255){return false}\n        return unicode_iscased(cp)\n    }\n\n    function unicode_tolower(cp){\n        var letter = String.fromCodePoint(cp),\n            lower = letter.toLowerCase()\n        return lower.charCodeAt(0)\n    }\n\n    function ascii_tolower(cp){\n        return unicode_tolower(cp)\n    }\n\nreturn {\n    unicode_iscased: unicode_iscased,\n    ascii_iscased: ascii_iscased,\n    unicode_tolower: unicode_tolower,\n    ascii_tolower: ascii_tolower\n}\n\n}\n\n)(__BRYTHON__)"], "_string": [".js", "var $module=(function($B){\n\nvar _b_ = $B.builtins\n\nfunction parts(format_string){\n    var result = [],\n        _parts = $B.split_format(format_string) // defined in py_string.js\n    for(var i = 0; i < _parts.length; i+= 2){\n        result.push({pre: _parts[i], fmt: _parts[i + 1]})\n    }\n    return result\n}\n\nfunction Tuple(){\n    var args = []\n    for(var i=0, len=arguments.length; i < len; i++){\n        args.push(arguments[i])\n    }\n    return _b_.tuple.$factory(args)\n}\n\nreturn{\n\n    formatter_field_name_split: function(fieldname){\n        // Split the argument as a field name\n        var parsed = $B.parse_format(fieldname),\n            first = parsed.name,\n            rest = []\n        if(first.match(/\\d+/)){first = parseInt(first)}\n        parsed.name_ext.forEach(function(ext){\n            if(ext.startsWith(\"[\")){\n                var item = ext.substr(1, ext.length - 2)\n                if(item.match(/\\d+/)){\n                    rest.push(Tuple(false, parseInt(item)))\n                }else{\n                    rest.push(Tuple(false, item))\n                }\n            }else{\n                rest.push(Tuple(true, ext.substr(1)))\n            }\n        })\n        return Tuple(first, _b_.iter(rest))\n    },\n    formatter_parser: function(format_string){\n        // Parse the argument as a format string\n\n        if(! _b_.isinstance(format_string, _b_.str)){\n            throw _b_.ValueError.$factory(\"Invalid format string type: \" +\n                $B.class_name(format_string))\n        }\n\n        var result  = []\n        parts(format_string).forEach(function(item){\n            var pre = item.pre === undefined ? \"\" : item.pre,\n                fmt = item.fmt\n            if(fmt === undefined){\n               result.push(Tuple(pre, _b_.None, _b_.None, _b_.None))\n            }else if(fmt.string == ''){\n               result.push(Tuple(pre, '', '', _b_.None))\n            }else{\n               result.push(Tuple(pre,\n                   fmt.raw_name + fmt.name_ext.join(\"\"),\n                   fmt.raw_spec,\n                   fmt.conv || _b_.None))\n           }\n        })\n        return result\n    }\n}\n})(__BRYTHON__)"], "_strptime": [".js", "var _b_ = __BRYTHON__.builtins\n\nvar $module = (function($B){\n    return {\n        _strptime_datetime: function(cls, s, fmt){\n            var pos_s = 0,\n                pos_fmt = 0,\n                dt = {}\n            function error(){\n                throw Error(\"no match \" + pos_s + \" \" + s.charAt(pos_s) + \" \"+\n                    pos_fmt + \" \" + fmt.charAt(pos_fmt))\n            }\n\n            var locale = __BRYTHON__.locale,\n                shortdays = [],\n                longdays = [],\n                conv_func = locale == \"C\" ?\n                    function(d, options){\n                        return d.toLocaleDateString('en-EN', options)\n                    } :\n                    function(d, options){\n                        return d.toLocaleDateString(locale, options)\n                    }\n\n            for(var day = 16; day < 23; day++){\n                var d = new Date(Date.UTC(2012, 11, day, 3, 0, 0))\n                shortdays.push(conv_func(d, {weekday: 'short'}))\n                longdays.push(conv_func(d, {weekday: 'long'}))\n            }\n\n            var shortmonths = [],\n                longmonths = []\n\n            for(var month = 0; month < 12; month++){\n                var d = new Date(Date.UTC(2012, month, 1, 3, 0, 0))\n                shortmonths.push(conv_func(d, {month: 'short'}))\n                longmonths.push(conv_func(d, {month: 'long'}))\n            }\n\n            var shortdays_re = new RegExp(shortdays.join(\"|\").replace(\".\", \"\\\\.\")),\n                longdays_re = new RegExp(longdays.join(\"|\")),\n                shortmonths_re = new RegExp(shortmonths.join(\"|\").replace(\".\", \"\\\\.\")),\n                longmonths_re = new RegExp(longmonths.join(\"|\"))\n\n            var regexps = {\n                d: [\"day\", new RegExp(\"0[1-9]|[123][0-9]\")],\n                f: [\"microsecond\", new RegExp(\"(\\\\d{1,6})\")],\n                H: [\"hour\", new RegExp(\"[01][0-9]|2[0-3]|\\\\d\")],\n                I: [\"hour\", new RegExp(\"0[0-9]|1[0-2]\")],\n                m: [\"month\", new RegExp(\"0[1-9]|1[012]\")],\n                M: [\"minute\", new RegExp(\"[0-5][0-9]\")],\n                S: [\"second\", new RegExp(\"([1-5]\\\\d)|(0?\\\\d)\")],\n                y: [\"year\", new RegExp(\"0{0,2}\\\\d{2}\")],\n                Y: [\"year\", new RegExp(\"\\\\d{4}\")],\n                z: [\"tzinfo\", new RegExp(\"Z\")]\n            }\n\n            while(pos_fmt < fmt.length){\n                var car = fmt.charAt(pos_fmt)\n                if(car == \"%\"){\n                    var spec = fmt.charAt(pos_fmt + 1),\n                        regexp = regexps[spec]\n                    if(regexp !== undefined){\n                        var re = regexp[1],\n                            attr = regexp[0],\n                            res = re.exec(s.substr(pos_s))\n                        if(res === null){\n                            error()\n                        }else{\n                            if(dt[attr] !== undefined){\n                                throw Error(attr + \" is defined more than once\")\n                            }else{\n                                dt[attr] = parseInt(res[0])\n                                if(attr == \"microsecond\"){\n                                    while(dt[attr] < 100000){\n                                        dt[attr] *= 10\n                                    }\n                                }else if(attr == \"tzinfo\"){\n                                    // Only value supported for the moment : Z\n                                    // (UTC)\n                                    var dt_module = $B.imported[cls.__module__]\n                                    dt.tzinfo = dt_module.timezone.utc\n                                }\n                                pos_fmt += 2\n                                pos_s += res[0].length\n                            }\n                        }\n                    }else if(spec == \"a\" || spec == \"A\"){\n                        // Locale's abbreviated (a) or full (A) weekday name\n                        var attr = \"weekday\",\n                            re = spec == \"a\" ? shortdays_re : longdays_re,\n                            t = spec == \"a\" ? shortdays : longdays\n                            res = re.exec(s.substr(pos_s))\n                        if(res === null){\n                            console.log('error', re, 'string', s.substr(pos_s), 'fmt', fmt)\n                            error()\n                        }else{\n                            var match = res[0],\n                                ix = t.indexOf(match)\n                        }\n                        if(dt.weekday !== undefined){\n                            throw Error(attr + \" is defined more than once\")\n                        }else{\n                            dt.weekday = ix\n                        }\n                        pos_fmt += 2\n                        pos_s += match.length\n                    }else if(spec == \"b\" || spec == \"B\"){\n                        // Locales's abbreviated (b) or full (B) month\n                        var attr = \"month\",\n                            re = spec == \"b\" ? shortmonths_re : longmonths_re,\n                            t = spec == \"b\" ? shortmonths : longmonths,\n                            res = re.exec(s.substr(pos_s))\n                        if(res === null){\n                            error()\n                        }else{\n                            var match = res[0],\n                                ix = t.indexOf(match)\n                        }\n                        if(dt.month !== undefined){\n                            throw Error(attr + \" is defined more than once\")\n                        }else{\n                            dt.month = ix + 1\n                        }\n                        pos_fmt += 2\n                        pos_s += match.length\n                    }else if(spec == \"c\"){\n                        // Locale's appropriate date and time representation\n                        var fmt1 = fmt.substr(0, pos_fmt - 1) + _locale_c_format() +\n                            fmt.substr(pos_fmt + 2)\n                        fmt = fmt1\n                    }else if(spec == \"%\"){\n                        if(s.charAt(pos_s) == \"%\"){\n                            pos_fmt++\n                            pos_s++\n                        }else{\n                            error()\n                        }\n                    }else{\n                        pos_fmt++\n                    }\n                }else{\n                    if(car == s.charAt(pos_s)){\n                        pos_fmt++\n                        pos_s++\n                    }else{\n                        error()\n                    }\n                }\n            }\n            return $B.$call(cls)(dt.year, dt.month, dt.day,\n                dt.hour || 0, dt.minute || 0, dt.second || 0,\n                dt.microsecond || 0, dt.tzinfo || _b_.None)\n        }\n    }\n})(__BRYTHON__)\n"], "_svg": [".js", "// creation of an HTML element\nvar $module = (function($B){\n\nvar _b_ = $B.builtins\nvar TagSum = $B.TagSum // defined in py_dom.js\n\nvar $svgNS = \"http://www.w3.org/2000/svg\"\nvar $xlinkNS = \"http://www.w3.org/1999/xlink\"\n\nfunction makeTagDict(tagName){\n    // return the dictionary for the class associated with tagName\n    var dict = $B.make_class(tagName)\n\n    dict.__init__ = function(){\n        var $ns = $B.args('__init__', 1, {self: null}, ['self'],\n            arguments, {}, 'args', 'kw'),\n            self = $ns['self'],\n            args = $ns['args']\n        if(args.length == 1){\n            var first = args[0]\n            if(_b_.isinstance(first, [_b_.str, _b_.int, _b_.float])){\n                self.appendChild(document.createTextNode(_b_.str.$factory(first)))\n            }else if(first.__class__ === TagSum){\n                for(var i = 0, len = first.children.length; i < len; i++){\n                    self.appendChild(first.children[i].elt)\n                }\n            }else{ // argument is another DOMNode instance\n                try{self.appendChild(first.elt)}\n                catch(err){throw _b_.ValueError.$factory('wrong element ' + first)}\n            }\n        }\n\n        // attributes\n        var items = _b_.list.$factory(_b_.dict.items($ns['kw']))\n        for(var i = 0, len = items.length; i < len; i++){\n            // keyword arguments\n            var arg = items[i][0],\n                value = items[i][1]\n            if(arg.toLowerCase().substr(0,2) == \"on\"){\n                // Event binding passed as argument \"onclick\", \"onfocus\"...\n                // Better use method bind of DOMNode objects\n                var js = '$B.DOMNode.bind(self,\"' +\n                    arg.toLowerCase().substr(2)\n                eval(js+'\",function(){'+value+'})')\n            }else if(arg.toLowerCase() == \"style\"){\n                $B.DOMNode.set_style(self,value)\n            }else if(arg.toLowerCase().indexOf(\"href\") !== -1){ // xlink:href\n                self.setAttributeNS( \"http://www.w3.org/1999/xlink\",\n                    \"href\",value)\n            }else{\n                if(value !== false){\n                    // option.selected=false sets it to true :-)\n                    try{\n                        arg = arg.replace('_', '-')\n                        self.setAttributeNS(null, arg, value)\n                    }catch(err){\n                        throw _b_.ValueError.$factory(\"can't set attribute \" + arg)\n                    }\n                }\n            }\n        }\n    }\n\n    dict.__mro__ = [$B.DOMNode, $B.builtins.object]\n\n    dict.__new__ = function(cls){\n        var res = $B.DOMNode.$factory(document.createElementNS($svgNS, tagName))\n        res.__class__ = cls\n        return res\n    }\n\n    dict.$factory = function(){\n        var res = $B.DOMNode.$factory(\n            document.createElementNS($svgNS, tagName))\n        res.__class__ = dict\n        // apply __init__\n        dict.__init__(res, ...arguments)\n        return res\n    }\n\n    $B.set_func_names(dict, \"browser.svg\")\n\n    return dict\n}\n\n\n// SVG\nvar $svg_tags = ['a',\n'altGlyph',\n'altGlyphDef',\n'altGlyphItem',\n'animate',\n'animateColor',\n'animateMotion',\n'animateTransform',\n'circle',\n'clipPath',\n'color_profile', // instead of color-profile\n'cursor',\n'defs',\n'desc',\n'ellipse',\n'feBlend',\n'foreignObject', //patch to enable foreign objects\n'g',\n'image',\n'line',\n'linearGradient',\n'marker',\n'mask',\n'path',\n'pattern',\n'polygon',\n'polyline',\n'radialGradient',\n'rect',\n'set',\n'stop',\n'svg',\n'text',\n'tref',\n'tspan',\n'use']\n\n// create classes\nvar obj = new Object()\nvar dicts = {}\nfor(var i = 0, len = $svg_tags.length; i < len; i++){\n    var tag = $svg_tags[i]\n    obj[tag] = makeTagDict(tag)\n}\n\nreturn obj\n})(__BRYTHON__)\n"], "_webcomponent": [".js", "// module for Web Components\nvar $module = (function($B){\n\nvar _b_ = $B.builtins\n\nfunction define(tag_name, cls){\n    var $ = $B.args(\"define\", 2, {tag_name: null, cls: null},\n            [\"tag_name\", \"cls\"], arguments, {}, null, null),\n        tag_name = $.tag_name,\n        cls = $.cls\n    if(typeof tag_name != \"string\"){\n        throw _b_.TypeError.$factory(\"first argument of define() \" +\n            \"must be a string, not '\" + $B.class_name(tag_name) + \"'\")\n    }else if(tag_name.indexOf(\"-\") == -1){\n        throw _b_.ValueError.$factory(\"custom tag name must \" +\n            \"contain a hyphen (-)\")\n    }\n    if(!_b_.isinstance(cls, _b_.type)){\n        throw _b_.TypeError.$factory(\"second argument of define() \" +\n            \"must be a class, not '\" + $B.class_name(tag_name) + \"'\")\n    }\n\n    // Create the Javascript class used for the component. It must have\n    // the same name as the Python class\n    var src = String.raw`var WebComponent = class extends HTMLElement {\n      constructor(){\n        // Always call super first in constructor\n        super()\n        var init = $B.$getattr(cls, \"__init__\", _b_.None)\n        if(init !== _b_.None){\n            try{\n                var _self = $B.DOMNode.$factory(this),\n                    attrs_before_init = []\n                for(var i = 0, len = _self.attributes.length; i < len; i++){\n                    attrs_before_init.push(_self.attributes.item(i))\n                }\n                _self.__class__ = cls\n                $B.$call(init)(_self)\n                if(WebComponent.initialized){\n                    // Check that init() did not introduce new attributes,\n                    // which is illegal\n                    // cf. https://html.spec.whatwg.org/multipage/custom-elements.html#custom-element-conformance\n                    for(var i = 0, len = _self.attributes.length; i < len; i++){\n                        var item = _self.attributes.item(i)\n                        if(attrs_before_init.indexOf(item) == -1){\n                            throw _b_.TypeError.$factory(\"Custom element \" +\n                                \"must not create attributes, found: \" +\n                                item.name + '=\"' + item.value + '\"')\n                        }\n                    }\n                }\n            }catch(err){\n                $B.handle_error(err)\n            }\n        }\n      }\n        static get observedAttributes(){\n            var obs_attr = $B.$getattr(cls, \"observedAttributes\", null)\n            if(obs_attr === null){\n                return []\n            }else if(typeof obs_attr == \"function\"){\n                var warning = _b_.DeprecationWarning.$factory(\n                    \"Setting observedAttributes as a method \" +\n                    \"is deprecated. Set it as a class attribute.\")\n                // module _warning is in builtin_modules.js\n                $B.imported._warnings.warn(warning)\n                return $B.$call(obs_attr)(this)\n            }else if(Array.isArray(obs_attr)){\n                return obs_attr\n            }else{\n                throw _b_.TypeError.$factory(\n                    \"wrong type for observedAttributes: \" +\n                    $B.class_name(obs_attr))\n            }\n        }\n    }\n    `\n    var name = cls.$infos.__name__\n    eval(src.replace(/WebComponent/g, name))\n    var webcomp = eval(name) // JS class for component\n    webcomp.$cls = cls\n\n    // Override __getattribute__ to handle DOMNode attributes such as\n    // attachShadow\n    cls.__getattribute__ = function(self, attr){\n        try{\n            return $B.DOMNode.__getattribute__(self, attr)\n        }catch(err){\n            if(err.__class__ === _b_.AttributeError){\n                var ga = $B.$getattr(cls, \"__getattribute__\")\n                return ga(self, attr)\n            }else{\n                throw err\n            }\n        }\n    }\n\n    var mro = [cls].concat(cls.__mro__)\n    for(var i = 0, len = mro.length - 1; i < len; i++){\n        var pcls = mro[i]\n        for(var key in pcls){\n            if(webcomp.prototype[key] === undefined &&\n                    typeof pcls[key] == \"function\"){\n                webcomp.prototype[key] = (function(attr, klass){\n                    return function(){\n                        return $B.pyobj2jsobj(klass[attr]).call(null,\n                            $B.DOMNode.$factory(this), ...arguments)\n                    }\n                })(key, pcls)\n            }\n        }\n    }\n\n    // define WebComp as the class to use for the specified tag name\n    customElements.define(tag_name, webcomp)\n    webcomp.initialized = true\n}\n\nfunction get(name){\n    var ce = customElements.get(name)\n    if(ce && ce.$cls){return ce.$cls}\n    return _b_.None\n}\n\nreturn {\n    define: define,\n    get: get\n}\n\n})(__BRYTHON__)"], "_webworker": [".js", "// Web Worker implementation\n\nvar $module = (function($B){\n\nvar _b_ = $B.builtins\n\nvar brython_scripts = ['brython', 'brython_stdlib']\n\nvar wclass = $B.make_class(\"Worker\",\n    function(worker){\n        var res = worker\n        res.send = res.postMessage\n        return res\n    }\n)\nwclass.__mro__ = [$B.JSObj, _b_.object]\n\n$B.set_func_names(wclass, \"browser.worker\")\n\nvar _Worker = $B.make_class(\"Worker\", function(id, onmessage, onerror){\n    var $ = $B.args(\"__init__\", 3, {id: null, onmessage: null, onerror: null},\n            ['id', 'onmessage', 'onerror'], arguments,\n            {onmessage: _b_.None, onerror: _b_.None}, null, null),\n        id = $.id,\n        src = $B.webworkers[id]\n        if(src === undefined){\n            throw _b_.KeyError.$factory(id)\n        }\n        var script_id = \"worker\" + $B.UUID(),\n            js = __BRYTHON__.imported.javascript.py2js(src,\n                script_id),\n            header = 'var $locals_' + script_id +' = {}\\n';\n        brython_scripts.forEach(function(script){\n            var url = $B.brython_path + script + \".js?\" +\n                (new Date()).getTime()\n            header += 'importScripts(\"' + url + '\")\\n'\n        })\n        // restore brython_path\n        header += '__BRYTHON__.brython_path = \"' + $B.brython_path +\n            '\"\\n'\n        // restore path for imports (cf. issue #1305)\n        header += '__BRYTHON__.path = \"' + $B.path +'\".split(\",\")\\n'\n        // Call brython() to initialize internal Brython values\n        header += 'brython(1)\\n'\n        js = header + js\n        var blob = new Blob([js], {type: \"application/js\"}),\n            url = URL.createObjectURL(blob),\n            w = new Worker(url),\n            res = wclass.$factory(w)\n        return res\n})\n\nreturn {\n    Worker: _Worker\n}\n\n})(__BRYTHON__)\n"], "_zlib_utils": [".js", "\nfunction rfind(buf, seq){\n    var buflen = buf.length,\n        len = seq.length\n    for(var i = buflen - len; i >= 0; i--){\n        var chunk = buf.slice(i, i + len),\n            found = true\n        for(var j = 0; j < len; j++){\n            if(chunk[j] != seq[j]){\n                found = false\n                break\n            }\n        }\n        if(found){return i}\n    }\n    return -1\n}\n\n\nvar c;\nvar crcTable = [];\nfor(var n =0; n < 256; n++){\n    c = n;\n    for(var k =0; k < 8; k++){\n        c = ((c&1) ? (0xEDB88320 ^ (c >>> 1)) : (c >>> 1));\n    }\n    crcTable[n] = c;\n}\n\nvar $module = (function($B){\n\n    return {\n        crc32: function(str) {\n            var crc = 0 ^ (-1);\n        \n            for (var i = 0; i < str.length; i++ ) {\n                crc = (crc >>> 8) ^ crcTable[(crc ^ str.charCodeAt(i)) & 0xFF];\n            }\n        \n            return (crc ^ (-1)) >>> 0;\n        },\n\n        lz_generator: function(text, size, min_len){\n            /*\n            Returns a list of items based on the LZ algorithm, using the\n            specified window size and a minimum match length.\n            The items are a tuple (length, distance) if a match has been\n            found, and a byte otherwise.\n            */\n            // 'text' is an instance of Python 'bytes' class, the actual\n            // bytes are in text.source\n            text = text.source\n            if(min_len === undefined){\n                min_len = 3\n            }\n            var pos = 0, // position in text\n                items = [] // returned items\n            while(pos < text.length){\n                sequence = text.slice(pos, pos + min_len)\n                if(sequence.length < 3){\n                    for(var i = pos; i < text.length; i++){\n                        items.push(text[i])\n                    }\n                    break\n                }\n                // Search the sequence in the 'size' previous bytes\n                buf = text.slice(pos - size, pos)\n                buf_pos = rfind(buf, sequence)\n                if(buf_pos > -1){\n                    // Match of length 3 found; search a longer one\n                    var len = 1\n                    while(len < 259 &&\n                            buf_pos + len < buf.length &&\n                            pos + len < text.length &&\n                            text[pos + len] == buf[buf_pos + len]){\n                        len += 1\n                    }\n                    match = text.slice(pos, pos + len)\n                    // \"Lazy matching\": search longer match starting at next\n                    // position\n                    longer_match = false\n                    if(pos + len < text.length - 2){\n                        match2 = text.slice(pos + 1, pos + len + 2)\n                        longer_buf_pos = rfind(buf, match2)\n                        if(longer_buf_pos > -1){\n                            // found longer match : emit current byte as\n                            // literal and move 1 byte forward\n                            longer_match = true\n                            char = text[pos]\n                            items.push(char)\n                            pos += 1\n                        }\n                    }\n                    if(! longer_match){\n                        distance = buf.length - buf_pos\n                        items.push($B.fast_tuple([len, distance]))\n                        if(pos + len == text.length){\n                            break\n                        }else{\n                            pos += len\n                            items.push(text[pos])\n                            pos += 1\n                        }\n                    }\n                }else{\n                    char = text[pos]\n                    items.push(char)\n                    pos += 1\n                }\n            }\n            return items\n        }\n    }\n})(__BRYTHON__)"], "crypto_js": [".py", "", [], 1], "crypto_js.rollups": [".py", "", [], 1], "crypto_js.rollups.md5": [".js", "/*\nCryptoJS v3.1.2\ncode.google.com/p/crypto-js\n(c) 2009-2013 by Jeff Mott. All rights reserved.\ncode.google.com/p/crypto-js/wiki/License\n*/\nvar CryptoJS=CryptoJS||function(s,p){var m={},l=m.lib={},n=function(){},r=l.Base={extend:function(b){n.prototype=this;var h=new n;b&&h.mixIn(b);h.hasOwnProperty(\"init\")||(h.init=function(){h.$super.init.apply(this,arguments)});h.init.prototype=h;h.$super=this;return h},create:function(){var b=this.extend();b.init.apply(b,arguments);return b},init:function(){},mixIn:function(b){for(var h in b)b.hasOwnProperty(h)&&(this[h]=b[h]);b.hasOwnProperty(\"toString\")&&(this.toString=b.toString)},clone:function(){return this.init.prototype.extend(this)}},\nq=l.WordArray=r.extend({init:function(b,h){b=this.words=b||[];this.sigBytes=h!=p?h:4*b.length},toString:function(b){return(b||t).stringify(this)},concat:function(b){var h=this.words,a=b.words,j=this.sigBytes;b=b.sigBytes;this.clamp();if(j%4)for(var g=0;g<b;g++)h[j+g>>>2]|=(a[g>>>2]>>>24-8*(g%4)&255)<<24-8*((j+g)%4);else if(65535<a.length)for(g=0;g<b;g+=4)h[j+g>>>2]=a[g>>>2];else h.push.apply(h,a);this.sigBytes+=b;return this},clamp:function(){var b=this.words,h=this.sigBytes;b[h>>>2]&=4294967295<<\n32-8*(h%4);b.length=s.ceil(h/4)},clone:function(){var b=r.clone.call(this);b.words=this.words.slice(0);return b},random:function(b){for(var h=[],a=0;a<b;a+=4)h.push(4294967296*s.random()|0);return new q.init(h,b)}}),v=m.enc={},t=v.Hex={stringify:function(b){var a=b.words;b=b.sigBytes;for(var g=[],j=0;j<b;j++){var k=a[j>>>2]>>>24-8*(j%4)&255;g.push((k>>>4).toString(16));g.push((k&15).toString(16))}return g.join(\"\")},parse:function(b){for(var a=b.length,g=[],j=0;j<a;j+=2)g[j>>>3]|=parseInt(b.substr(j,\n2),16)<<24-4*(j%8);return new q.init(g,a/2)}},a=v.Latin1={stringify:function(b){var a=b.words;b=b.sigBytes;for(var g=[],j=0;j<b;j++)g.push(String.fromCharCode(a[j>>>2]>>>24-8*(j%4)&255));return g.join(\"\")},parse:function(b){for(var a=b.length,g=[],j=0;j<a;j++)g[j>>>2]|=(b.charCodeAt(j)&255)<<24-8*(j%4);return new q.init(g,a)}},u=v.Utf8={stringify:function(b){try{return decodeURIComponent(escape(a.stringify(b)))}catch(g){throw Error(\"Malformed UTF-8 data\");}},parse:function(b){return a.parse(unescape(encodeURIComponent(b)))}},\ng=l.BufferedBlockAlgorithm=r.extend({reset:function(){this._data=new q.init;this._nDataBytes=0},_append:function(b){\"string\"==typeof b&&(b=u.parse(b));this._data.concat(b);this._nDataBytes+=b.sigBytes},_process:function(b){var a=this._data,g=a.words,j=a.sigBytes,k=this.blockSize,m=j/(4*k),m=b?s.ceil(m):s.max((m|0)-this._minBufferSize,0);b=m*k;j=s.min(4*b,j);if(b){for(var l=0;l<b;l+=k)this._doProcessBlock(g,l);l=g.splice(0,b);a.sigBytes-=j}return new q.init(l,j)},clone:function(){var b=r.clone.call(this);\nb._data=this._data.clone();return b},_minBufferSize:0});l.Hasher=g.extend({cfg:r.extend(),init:function(b){this.cfg=this.cfg.extend(b);this.reset()},reset:function(){g.reset.call(this);this._doReset()},update:function(b){this._append(b);this._process();return this},finalize:function(b){b&&this._append(b);return this._doFinalize()},blockSize:16,_createHelper:function(b){return function(a,g){return(new b.init(g)).finalize(a)}},_createHmacHelper:function(b){return function(a,g){return(new k.HMAC.init(b,\ng)).finalize(a)}}});var k=m.algo={};return m}(Math);\n(function(s){function p(a,k,b,h,l,j,m){a=a+(k&b|~k&h)+l+m;return(a<<j|a>>>32-j)+k}function m(a,k,b,h,l,j,m){a=a+(k&h|b&~h)+l+m;return(a<<j|a>>>32-j)+k}function l(a,k,b,h,l,j,m){a=a+(k^b^h)+l+m;return(a<<j|a>>>32-j)+k}function n(a,k,b,h,l,j,m){a=a+(b^(k|~h))+l+m;return(a<<j|a>>>32-j)+k}for(var r=CryptoJS,q=r.lib,v=q.WordArray,t=q.Hasher,q=r.algo,a=[],u=0;64>u;u++)a[u]=4294967296*s.abs(s.sin(u+1))|0;q=q.MD5=t.extend({_doReset:function(){this._hash=new v.init([1732584193,4023233417,2562383102,271733878])},\n_doProcessBlock:function(g,k){for(var b=0;16>b;b++){var h=k+b,w=g[h];g[h]=(w<<8|w>>>24)&16711935|(w<<24|w>>>8)&4278255360}var b=this._hash.words,h=g[k+0],w=g[k+1],j=g[k+2],q=g[k+3],r=g[k+4],s=g[k+5],t=g[k+6],u=g[k+7],v=g[k+8],x=g[k+9],y=g[k+10],z=g[k+11],A=g[k+12],B=g[k+13],C=g[k+14],D=g[k+15],c=b[0],d=b[1],e=b[2],f=b[3],c=p(c,d,e,f,h,7,a[0]),f=p(f,c,d,e,w,12,a[1]),e=p(e,f,c,d,j,17,a[2]),d=p(d,e,f,c,q,22,a[3]),c=p(c,d,e,f,r,7,a[4]),f=p(f,c,d,e,s,12,a[5]),e=p(e,f,c,d,t,17,a[6]),d=p(d,e,f,c,u,22,a[7]),\nc=p(c,d,e,f,v,7,a[8]),f=p(f,c,d,e,x,12,a[9]),e=p(e,f,c,d,y,17,a[10]),d=p(d,e,f,c,z,22,a[11]),c=p(c,d,e,f,A,7,a[12]),f=p(f,c,d,e,B,12,a[13]),e=p(e,f,c,d,C,17,a[14]),d=p(d,e,f,c,D,22,a[15]),c=m(c,d,e,f,w,5,a[16]),f=m(f,c,d,e,t,9,a[17]),e=m(e,f,c,d,z,14,a[18]),d=m(d,e,f,c,h,20,a[19]),c=m(c,d,e,f,s,5,a[20]),f=m(f,c,d,e,y,9,a[21]),e=m(e,f,c,d,D,14,a[22]),d=m(d,e,f,c,r,20,a[23]),c=m(c,d,e,f,x,5,a[24]),f=m(f,c,d,e,C,9,a[25]),e=m(e,f,c,d,q,14,a[26]),d=m(d,e,f,c,v,20,a[27]),c=m(c,d,e,f,B,5,a[28]),f=m(f,c,\nd,e,j,9,a[29]),e=m(e,f,c,d,u,14,a[30]),d=m(d,e,f,c,A,20,a[31]),c=l(c,d,e,f,s,4,a[32]),f=l(f,c,d,e,v,11,a[33]),e=l(e,f,c,d,z,16,a[34]),d=l(d,e,f,c,C,23,a[35]),c=l(c,d,e,f,w,4,a[36]),f=l(f,c,d,e,r,11,a[37]),e=l(e,f,c,d,u,16,a[38]),d=l(d,e,f,c,y,23,a[39]),c=l(c,d,e,f,B,4,a[40]),f=l(f,c,d,e,h,11,a[41]),e=l(e,f,c,d,q,16,a[42]),d=l(d,e,f,c,t,23,a[43]),c=l(c,d,e,f,x,4,a[44]),f=l(f,c,d,e,A,11,a[45]),e=l(e,f,c,d,D,16,a[46]),d=l(d,e,f,c,j,23,a[47]),c=n(c,d,e,f,h,6,a[48]),f=n(f,c,d,e,u,10,a[49]),e=n(e,f,c,d,\nC,15,a[50]),d=n(d,e,f,c,s,21,a[51]),c=n(c,d,e,f,A,6,a[52]),f=n(f,c,d,e,q,10,a[53]),e=n(e,f,c,d,y,15,a[54]),d=n(d,e,f,c,w,21,a[55]),c=n(c,d,e,f,v,6,a[56]),f=n(f,c,d,e,D,10,a[57]),e=n(e,f,c,d,t,15,a[58]),d=n(d,e,f,c,B,21,a[59]),c=n(c,d,e,f,r,6,a[60]),f=n(f,c,d,e,z,10,a[61]),e=n(e,f,c,d,j,15,a[62]),d=n(d,e,f,c,x,21,a[63]);b[0]=b[0]+c|0;b[1]=b[1]+d|0;b[2]=b[2]+e|0;b[3]=b[3]+f|0},_doFinalize:function(){var a=this._data,k=a.words,b=8*this._nDataBytes,h=8*a.sigBytes;k[h>>>5]|=128<<24-h%32;var l=s.floor(b/\n4294967296);k[(h+64>>>9<<4)+15]=(l<<8|l>>>24)&16711935|(l<<24|l>>>8)&4278255360;k[(h+64>>>9<<4)+14]=(b<<8|b>>>24)&16711935|(b<<24|b>>>8)&4278255360;a.sigBytes=4*(k.length+1);this._process();a=this._hash;k=a.words;for(b=0;4>b;b++)h=k[b],k[b]=(h<<8|h>>>24)&16711935|(h<<24|h>>>8)&4278255360;return a},clone:function(){var a=t.clone.call(this);a._hash=this._hash.clone();return a}});r.MD5=t._createHelper(q);r.HmacMD5=t._createHmacHelper(q)})(Math);\n"], "crypto_js.rollups.sha1": [".js", "/*\nCryptoJS v3.1.2\ncode.google.com/p/crypto-js\n(c) 2009-2013 by Jeff Mott. All rights reserved.\ncode.google.com/p/crypto-js/wiki/License\n*/\nvar CryptoJS=CryptoJS||function(e,m){var p={},j=p.lib={},l=function(){},f=j.Base={extend:function(a){l.prototype=this;var c=new l;a&&c.mixIn(a);c.hasOwnProperty(\"init\")||(c.init=function(){c.$super.init.apply(this,arguments)});c.init.prototype=c;c.$super=this;return c},create:function(){var a=this.extend();a.init.apply(a,arguments);return a},init:function(){},mixIn:function(a){for(var c in a)a.hasOwnProperty(c)&&(this[c]=a[c]);a.hasOwnProperty(\"toString\")&&(this.toString=a.toString)},clone:function(){return this.init.prototype.extend(this)}},\nn=j.WordArray=f.extend({init:function(a,c){a=this.words=a||[];this.sigBytes=c!=m?c:4*a.length},toString:function(a){return(a||h).stringify(this)},concat:function(a){var c=this.words,q=a.words,d=this.sigBytes;a=a.sigBytes;this.clamp();if(d%4)for(var b=0;b<a;b++)c[d+b>>>2]|=(q[b>>>2]>>>24-8*(b%4)&255)<<24-8*((d+b)%4);else if(65535<q.length)for(b=0;b<a;b+=4)c[d+b>>>2]=q[b>>>2];else c.push.apply(c,q);this.sigBytes+=a;return this},clamp:function(){var a=this.words,c=this.sigBytes;a[c>>>2]&=4294967295<<\n32-8*(c%4);a.length=e.ceil(c/4)},clone:function(){var a=f.clone.call(this);a.words=this.words.slice(0);return a},random:function(a){for(var c=[],b=0;b<a;b+=4)c.push(4294967296*e.random()|0);return new n.init(c,a)}}),b=p.enc={},h=b.Hex={stringify:function(a){var c=a.words;a=a.sigBytes;for(var b=[],d=0;d<a;d++){var f=c[d>>>2]>>>24-8*(d%4)&255;b.push((f>>>4).toString(16));b.push((f&15).toString(16))}return b.join(\"\")},parse:function(a){for(var c=a.length,b=[],d=0;d<c;d+=2)b[d>>>3]|=parseInt(a.substr(d,\n2),16)<<24-4*(d%8);return new n.init(b,c/2)}},g=b.Latin1={stringify:function(a){var c=a.words;a=a.sigBytes;for(var b=[],d=0;d<a;d++)b.push(String.fromCharCode(c[d>>>2]>>>24-8*(d%4)&255));return b.join(\"\")},parse:function(a){for(var c=a.length,b=[],d=0;d<c;d++)b[d>>>2]|=(a.charCodeAt(d)&255)<<24-8*(d%4);return new n.init(b,c)}},r=b.Utf8={stringify:function(a){try{return decodeURIComponent(escape(g.stringify(a)))}catch(c){throw Error(\"Malformed UTF-8 data\");}},parse:function(a){return g.parse(unescape(encodeURIComponent(a)))}},\nk=j.BufferedBlockAlgorithm=f.extend({reset:function(){this._data=new n.init;this._nDataBytes=0},_append:function(a){\"string\"==typeof a&&(a=r.parse(a));this._data.concat(a);this._nDataBytes+=a.sigBytes},_process:function(a){var c=this._data,b=c.words,d=c.sigBytes,f=this.blockSize,h=d/(4*f),h=a?e.ceil(h):e.max((h|0)-this._minBufferSize,0);a=h*f;d=e.min(4*a,d);if(a){for(var g=0;g<a;g+=f)this._doProcessBlock(b,g);g=b.splice(0,a);c.sigBytes-=d}return new n.init(g,d)},clone:function(){var a=f.clone.call(this);\na._data=this._data.clone();return a},_minBufferSize:0});j.Hasher=k.extend({cfg:f.extend(),init:function(a){this.cfg=this.cfg.extend(a);this.reset()},reset:function(){k.reset.call(this);this._doReset()},update:function(a){this._append(a);this._process();return this},finalize:function(a){a&&this._append(a);return this._doFinalize()},blockSize:16,_createHelper:function(a){return function(c,b){return(new a.init(b)).finalize(c)}},_createHmacHelper:function(a){return function(b,f){return(new s.HMAC.init(a,\nf)).finalize(b)}}});var s=p.algo={};return p}(Math);\n(function(){var e=CryptoJS,m=e.lib,p=m.WordArray,j=m.Hasher,l=[],m=e.algo.SHA1=j.extend({_doReset:function(){this._hash=new p.init([1732584193,4023233417,2562383102,271733878,3285377520])},_doProcessBlock:function(f,n){for(var b=this._hash.words,h=b[0],g=b[1],e=b[2],k=b[3],j=b[4],a=0;80>a;a++){if(16>a)l[a]=f[n+a]|0;else{var c=l[a-3]^l[a-8]^l[a-14]^l[a-16];l[a]=c<<1|c>>>31}c=(h<<5|h>>>27)+j+l[a];c=20>a?c+((g&e|~g&k)+1518500249):40>a?c+((g^e^k)+1859775393):60>a?c+((g&e|g&k|e&k)-1894007588):c+((g^e^\nk)-899497514);j=k;k=e;e=g<<30|g>>>2;g=h;h=c}b[0]=b[0]+h|0;b[1]=b[1]+g|0;b[2]=b[2]+e|0;b[3]=b[3]+k|0;b[4]=b[4]+j|0},_doFinalize:function(){var f=this._data,e=f.words,b=8*this._nDataBytes,h=8*f.sigBytes;e[h>>>5]|=128<<24-h%32;e[(h+64>>>9<<4)+14]=Math.floor(b/4294967296);e[(h+64>>>9<<4)+15]=b;f.sigBytes=4*e.length;this._process();return this._hash},clone:function(){var e=j.clone.call(this);e._hash=this._hash.clone();return e}});e.SHA1=j._createHelper(m);e.HmacSHA1=j._createHmacHelper(m)})();\n"], "crypto_js.rollups.sha224": [".js", "/*\nCryptoJS v3.1.2\ncode.google.com/p/crypto-js\n(c) 2009-2013 by Jeff Mott. All rights reserved.\ncode.google.com/p/crypto-js/wiki/License\n*/\nvar CryptoJS=CryptoJS||function(g,l){var f={},k=f.lib={},h=function(){},m=k.Base={extend:function(a){h.prototype=this;var c=new h;a&&c.mixIn(a);c.hasOwnProperty(\"init\")||(c.init=function(){c.$super.init.apply(this,arguments)});c.init.prototype=c;c.$super=this;return c},create:function(){var a=this.extend();a.init.apply(a,arguments);return a},init:function(){},mixIn:function(a){for(var c in a)a.hasOwnProperty(c)&&(this[c]=a[c]);a.hasOwnProperty(\"toString\")&&(this.toString=a.toString)},clone:function(){return this.init.prototype.extend(this)}},\nq=k.WordArray=m.extend({init:function(a,c){a=this.words=a||[];this.sigBytes=c!=l?c:4*a.length},toString:function(a){return(a||s).stringify(this)},concat:function(a){var c=this.words,d=a.words,b=this.sigBytes;a=a.sigBytes;this.clamp();if(b%4)for(var e=0;e<a;e++)c[b+e>>>2]|=(d[e>>>2]>>>24-8*(e%4)&255)<<24-8*((b+e)%4);else if(65535<d.length)for(e=0;e<a;e+=4)c[b+e>>>2]=d[e>>>2];else c.push.apply(c,d);this.sigBytes+=a;return this},clamp:function(){var a=this.words,c=this.sigBytes;a[c>>>2]&=4294967295<<\n32-8*(c%4);a.length=g.ceil(c/4)},clone:function(){var a=m.clone.call(this);a.words=this.words.slice(0);return a},random:function(a){for(var c=[],d=0;d<a;d+=4)c.push(4294967296*g.random()|0);return new q.init(c,a)}}),t=f.enc={},s=t.Hex={stringify:function(a){var c=a.words;a=a.sigBytes;for(var d=[],b=0;b<a;b++){var e=c[b>>>2]>>>24-8*(b%4)&255;d.push((e>>>4).toString(16));d.push((e&15).toString(16))}return d.join(\"\")},parse:function(a){for(var c=a.length,d=[],b=0;b<c;b+=2)d[b>>>3]|=parseInt(a.substr(b,\n2),16)<<24-4*(b%8);return new q.init(d,c/2)}},n=t.Latin1={stringify:function(a){var c=a.words;a=a.sigBytes;for(var d=[],b=0;b<a;b++)d.push(String.fromCharCode(c[b>>>2]>>>24-8*(b%4)&255));return d.join(\"\")},parse:function(a){for(var c=a.length,d=[],b=0;b<c;b++)d[b>>>2]|=(a.charCodeAt(b)&255)<<24-8*(b%4);return new q.init(d,c)}},j=t.Utf8={stringify:function(a){try{return decodeURIComponent(escape(n.stringify(a)))}catch(c){throw Error(\"Malformed UTF-8 data\");}},parse:function(a){return n.parse(unescape(encodeURIComponent(a)))}},\nw=k.BufferedBlockAlgorithm=m.extend({reset:function(){this._data=new q.init;this._nDataBytes=0},_append:function(a){\"string\"==typeof a&&(a=j.parse(a));this._data.concat(a);this._nDataBytes+=a.sigBytes},_process:function(a){var c=this._data,d=c.words,b=c.sigBytes,e=this.blockSize,f=b/(4*e),f=a?g.ceil(f):g.max((f|0)-this._minBufferSize,0);a=f*e;b=g.min(4*a,b);if(a){for(var u=0;u<a;u+=e)this._doProcessBlock(d,u);u=d.splice(0,a);c.sigBytes-=b}return new q.init(u,b)},clone:function(){var a=m.clone.call(this);\na._data=this._data.clone();return a},_minBufferSize:0});k.Hasher=w.extend({cfg:m.extend(),init:function(a){this.cfg=this.cfg.extend(a);this.reset()},reset:function(){w.reset.call(this);this._doReset()},update:function(a){this._append(a);this._process();return this},finalize:function(a){a&&this._append(a);return this._doFinalize()},blockSize:16,_createHelper:function(a){return function(c,d){return(new a.init(d)).finalize(c)}},_createHmacHelper:function(a){return function(c,d){return(new v.HMAC.init(a,\nd)).finalize(c)}}});var v=f.algo={};return f}(Math);\n(function(g){for(var l=CryptoJS,f=l.lib,k=f.WordArray,h=f.Hasher,f=l.algo,m=[],q=[],t=function(a){return 4294967296*(a-(a|0))|0},s=2,n=0;64>n;){var j;a:{j=s;for(var w=g.sqrt(j),v=2;v<=w;v++)if(!(j%v)){j=!1;break a}j=!0}j&&(8>n&&(m[n]=t(g.pow(s,0.5))),q[n]=t(g.pow(s,1/3)),n++);s++}var a=[],f=f.SHA256=h.extend({_doReset:function(){this._hash=new k.init(m.slice(0))},_doProcessBlock:function(c,d){for(var b=this._hash.words,e=b[0],f=b[1],g=b[2],k=b[3],h=b[4],l=b[5],m=b[6],n=b[7],p=0;64>p;p++){if(16>p)a[p]=\nc[d+p]|0;else{var j=a[p-15],r=a[p-2];a[p]=((j<<25|j>>>7)^(j<<14|j>>>18)^j>>>3)+a[p-7]+((r<<15|r>>>17)^(r<<13|r>>>19)^r>>>10)+a[p-16]}j=n+((h<<26|h>>>6)^(h<<21|h>>>11)^(h<<7|h>>>25))+(h&l^~h&m)+q[p]+a[p];r=((e<<30|e>>>2)^(e<<19|e>>>13)^(e<<10|e>>>22))+(e&f^e&g^f&g);n=m;m=l;l=h;h=k+j|0;k=g;g=f;f=e;e=j+r|0}b[0]=b[0]+e|0;b[1]=b[1]+f|0;b[2]=b[2]+g|0;b[3]=b[3]+k|0;b[4]=b[4]+h|0;b[5]=b[5]+l|0;b[6]=b[6]+m|0;b[7]=b[7]+n|0},_doFinalize:function(){var a=this._data,d=a.words,b=8*this._nDataBytes,e=8*a.sigBytes;\nd[e>>>5]|=128<<24-e%32;d[(e+64>>>9<<4)+14]=g.floor(b/4294967296);d[(e+64>>>9<<4)+15]=b;a.sigBytes=4*d.length;this._process();return this._hash},clone:function(){var a=h.clone.call(this);a._hash=this._hash.clone();return a}});l.SHA256=h._createHelper(f);l.HmacSHA256=h._createHmacHelper(f)})(Math);\n(function(){var g=CryptoJS,l=g.lib.WordArray,f=g.algo,k=f.SHA256,f=f.SHA224=k.extend({_doReset:function(){this._hash=new l.init([3238371032,914150663,812702999,4144912697,4290775857,1750603025,1694076839,3204075428])},_doFinalize:function(){var f=k._doFinalize.call(this);f.sigBytes-=4;return f}});g.SHA224=k._createHelper(f);g.HmacSHA224=k._createHmacHelper(f)})();\n"], "crypto_js.rollups.sha256": [".js", "/*\nCryptoJS v3.1.2\ncode.google.com/p/crypto-js\n(c) 2009-2013 by Jeff Mott. All rights reserved.\ncode.google.com/p/crypto-js/wiki/License\n*/\nvar CryptoJS=CryptoJS||function(h,s){var f={},t=f.lib={},g=function(){},j=t.Base={extend:function(a){g.prototype=this;var c=new g;a&&c.mixIn(a);c.hasOwnProperty(\"init\")||(c.init=function(){c.$super.init.apply(this,arguments)});c.init.prototype=c;c.$super=this;return c},create:function(){var a=this.extend();a.init.apply(a,arguments);return a},init:function(){},mixIn:function(a){for(var c in a)a.hasOwnProperty(c)&&(this[c]=a[c]);a.hasOwnProperty(\"toString\")&&(this.toString=a.toString)},clone:function(){return this.init.prototype.extend(this)}},\nq=t.WordArray=j.extend({init:function(a,c){a=this.words=a||[];this.sigBytes=c!=s?c:4*a.length},toString:function(a){return(a||u).stringify(this)},concat:function(a){var c=this.words,d=a.words,b=this.sigBytes;a=a.sigBytes;this.clamp();if(b%4)for(var e=0;e<a;e++)c[b+e>>>2]|=(d[e>>>2]>>>24-8*(e%4)&255)<<24-8*((b+e)%4);else if(65535<d.length)for(e=0;e<a;e+=4)c[b+e>>>2]=d[e>>>2];else c.push.apply(c,d);this.sigBytes+=a;return this},clamp:function(){var a=this.words,c=this.sigBytes;a[c>>>2]&=4294967295<<\n32-8*(c%4);a.length=h.ceil(c/4)},clone:function(){var a=j.clone.call(this);a.words=this.words.slice(0);return a},random:function(a){for(var c=[],d=0;d<a;d+=4)c.push(4294967296*h.random()|0);return new q.init(c,a)}}),v=f.enc={},u=v.Hex={stringify:function(a){var c=a.words;a=a.sigBytes;for(var d=[],b=0;b<a;b++){var e=c[b>>>2]>>>24-8*(b%4)&255;d.push((e>>>4).toString(16));d.push((e&15).toString(16))}return d.join(\"\")},parse:function(a){for(var c=a.length,d=[],b=0;b<c;b+=2)d[b>>>3]|=parseInt(a.substr(b,\n2),16)<<24-4*(b%8);return new q.init(d,c/2)}},k=v.Latin1={stringify:function(a){var c=a.words;a=a.sigBytes;for(var d=[],b=0;b<a;b++)d.push(String.fromCharCode(c[b>>>2]>>>24-8*(b%4)&255));return d.join(\"\")},parse:function(a){for(var c=a.length,d=[],b=0;b<c;b++)d[b>>>2]|=(a.charCodeAt(b)&255)<<24-8*(b%4);return new q.init(d,c)}},l=v.Utf8={stringify:function(a){try{return decodeURIComponent(escape(k.stringify(a)))}catch(c){throw Error(\"Malformed UTF-8 data\");}},parse:function(a){return k.parse(unescape(encodeURIComponent(a)))}},\nx=t.BufferedBlockAlgorithm=j.extend({reset:function(){this._data=new q.init;this._nDataBytes=0},_append:function(a){\"string\"==typeof a&&(a=l.parse(a));this._data.concat(a);this._nDataBytes+=a.sigBytes},_process:function(a){var c=this._data,d=c.words,b=c.sigBytes,e=this.blockSize,f=b/(4*e),f=a?h.ceil(f):h.max((f|0)-this._minBufferSize,0);a=f*e;b=h.min(4*a,b);if(a){for(var m=0;m<a;m+=e)this._doProcessBlock(d,m);m=d.splice(0,a);c.sigBytes-=b}return new q.init(m,b)},clone:function(){var a=j.clone.call(this);\na._data=this._data.clone();return a},_minBufferSize:0});t.Hasher=x.extend({cfg:j.extend(),init:function(a){this.cfg=this.cfg.extend(a);this.reset()},reset:function(){x.reset.call(this);this._doReset()},update:function(a){this._append(a);this._process();return this},finalize:function(a){a&&this._append(a);return this._doFinalize()},blockSize:16,_createHelper:function(a){return function(c,d){return(new a.init(d)).finalize(c)}},_createHmacHelper:function(a){return function(c,d){return(new w.HMAC.init(a,\nd)).finalize(c)}}});var w=f.algo={};return f}(Math);\n(function(h){for(var s=CryptoJS,f=s.lib,t=f.WordArray,g=f.Hasher,f=s.algo,j=[],q=[],v=function(a){return 4294967296*(a-(a|0))|0},u=2,k=0;64>k;){var l;a:{l=u;for(var x=h.sqrt(l),w=2;w<=x;w++)if(!(l%w)){l=!1;break a}l=!0}l&&(8>k&&(j[k]=v(h.pow(u,0.5))),q[k]=v(h.pow(u,1/3)),k++);u++}var a=[],f=f.SHA256=g.extend({_doReset:function(){this._hash=new t.init(j.slice(0))},_doProcessBlock:function(c,d){for(var b=this._hash.words,e=b[0],f=b[1],m=b[2],h=b[3],p=b[4],j=b[5],k=b[6],l=b[7],n=0;64>n;n++){if(16>n)a[n]=\nc[d+n]|0;else{var r=a[n-15],g=a[n-2];a[n]=((r<<25|r>>>7)^(r<<14|r>>>18)^r>>>3)+a[n-7]+((g<<15|g>>>17)^(g<<13|g>>>19)^g>>>10)+a[n-16]}r=l+((p<<26|p>>>6)^(p<<21|p>>>11)^(p<<7|p>>>25))+(p&j^~p&k)+q[n]+a[n];g=((e<<30|e>>>2)^(e<<19|e>>>13)^(e<<10|e>>>22))+(e&f^e&m^f&m);l=k;k=j;j=p;p=h+r|0;h=m;m=f;f=e;e=r+g|0}b[0]=b[0]+e|0;b[1]=b[1]+f|0;b[2]=b[2]+m|0;b[3]=b[3]+h|0;b[4]=b[4]+p|0;b[5]=b[5]+j|0;b[6]=b[6]+k|0;b[7]=b[7]+l|0},_doFinalize:function(){var a=this._data,d=a.words,b=8*this._nDataBytes,e=8*a.sigBytes;\nd[e>>>5]|=128<<24-e%32;d[(e+64>>>9<<4)+14]=h.floor(b/4294967296);d[(e+64>>>9<<4)+15]=b;a.sigBytes=4*d.length;this._process();return this._hash},clone:function(){var a=g.clone.call(this);a._hash=this._hash.clone();return a}});s.SHA256=g._createHelper(f);s.HmacSHA256=g._createHmacHelper(f)})(Math);\n"], "crypto_js.rollups.sha3": [".js", "/*\nCryptoJS v3.1.2\ncode.google.com/p/crypto-js\n(c) 2009-2013 by Jeff Mott. All rights reserved.\ncode.google.com/p/crypto-js/wiki/License\n*/\nvar CryptoJS=CryptoJS||function(v,p){var d={},u=d.lib={},r=function(){},f=u.Base={extend:function(a){r.prototype=this;var b=new r;a&&b.mixIn(a);b.hasOwnProperty(\"init\")||(b.init=function(){b.$super.init.apply(this,arguments)});b.init.prototype=b;b.$super=this;return b},create:function(){var a=this.extend();a.init.apply(a,arguments);return a},init:function(){},mixIn:function(a){for(var b in a)a.hasOwnProperty(b)&&(this[b]=a[b]);a.hasOwnProperty(\"toString\")&&(this.toString=a.toString)},clone:function(){return this.init.prototype.extend(this)}},\ns=u.WordArray=f.extend({init:function(a,b){a=this.words=a||[];this.sigBytes=b!=p?b:4*a.length},toString:function(a){return(a||y).stringify(this)},concat:function(a){var b=this.words,c=a.words,j=this.sigBytes;a=a.sigBytes;this.clamp();if(j%4)for(var n=0;n<a;n++)b[j+n>>>2]|=(c[n>>>2]>>>24-8*(n%4)&255)<<24-8*((j+n)%4);else if(65535<c.length)for(n=0;n<a;n+=4)b[j+n>>>2]=c[n>>>2];else b.push.apply(b,c);this.sigBytes+=a;return this},clamp:function(){var a=this.words,b=this.sigBytes;a[b>>>2]&=4294967295<<\n32-8*(b%4);a.length=v.ceil(b/4)},clone:function(){var a=f.clone.call(this);a.words=this.words.slice(0);return a},random:function(a){for(var b=[],c=0;c<a;c+=4)b.push(4294967296*v.random()|0);return new s.init(b,a)}}),x=d.enc={},y=x.Hex={stringify:function(a){var b=a.words;a=a.sigBytes;for(var c=[],j=0;j<a;j++){var n=b[j>>>2]>>>24-8*(j%4)&255;c.push((n>>>4).toString(16));c.push((n&15).toString(16))}return c.join(\"\")},parse:function(a){for(var b=a.length,c=[],j=0;j<b;j+=2)c[j>>>3]|=parseInt(a.substr(j,\n2),16)<<24-4*(j%8);return new s.init(c,b/2)}},e=x.Latin1={stringify:function(a){var b=a.words;a=a.sigBytes;for(var c=[],j=0;j<a;j++)c.push(String.fromCharCode(b[j>>>2]>>>24-8*(j%4)&255));return c.join(\"\")},parse:function(a){for(var b=a.length,c=[],j=0;j<b;j++)c[j>>>2]|=(a.charCodeAt(j)&255)<<24-8*(j%4);return new s.init(c,b)}},q=x.Utf8={stringify:function(a){try{return decodeURIComponent(escape(e.stringify(a)))}catch(b){throw Error(\"Malformed UTF-8 data\");}},parse:function(a){return e.parse(unescape(encodeURIComponent(a)))}},\nt=u.BufferedBlockAlgorithm=f.extend({reset:function(){this._data=new s.init;this._nDataBytes=0},_append:function(a){\"string\"==typeof a&&(a=q.parse(a));this._data.concat(a);this._nDataBytes+=a.sigBytes},_process:function(a){var b=this._data,c=b.words,j=b.sigBytes,n=this.blockSize,e=j/(4*n),e=a?v.ceil(e):v.max((e|0)-this._minBufferSize,0);a=e*n;j=v.min(4*a,j);if(a){for(var f=0;f<a;f+=n)this._doProcessBlock(c,f);f=c.splice(0,a);b.sigBytes-=j}return new s.init(f,j)},clone:function(){var a=f.clone.call(this);\na._data=this._data.clone();return a},_minBufferSize:0});u.Hasher=t.extend({cfg:f.extend(),init:function(a){this.cfg=this.cfg.extend(a);this.reset()},reset:function(){t.reset.call(this);this._doReset()},update:function(a){this._append(a);this._process();return this},finalize:function(a){a&&this._append(a);return this._doFinalize()},blockSize:16,_createHelper:function(a){return function(b,c){return(new a.init(c)).finalize(b)}},_createHmacHelper:function(a){return function(b,c){return(new w.HMAC.init(a,\nc)).finalize(b)}}});var w=d.algo={};return d}(Math);\n(function(v){var p=CryptoJS,d=p.lib,u=d.Base,r=d.WordArray,p=p.x64={};p.Word=u.extend({init:function(f,s){this.high=f;this.low=s}});p.WordArray=u.extend({init:function(f,s){f=this.words=f||[];this.sigBytes=s!=v?s:8*f.length},toX32:function(){for(var f=this.words,s=f.length,d=[],p=0;p<s;p++){var e=f[p];d.push(e.high);d.push(e.low)}return r.create(d,this.sigBytes)},clone:function(){for(var f=u.clone.call(this),d=f.words=this.words.slice(0),p=d.length,r=0;r<p;r++)d[r]=d[r].clone();return f}})})();\n(function(v){for(var p=CryptoJS,d=p.lib,u=d.WordArray,r=d.Hasher,f=p.x64.Word,d=p.algo,s=[],x=[],y=[],e=1,q=0,t=0;24>t;t++){s[e+5*q]=(t+1)*(t+2)/2%64;var w=(2*e+3*q)%5,e=q%5,q=w}for(e=0;5>e;e++)for(q=0;5>q;q++)x[e+5*q]=q+5*((2*e+3*q)%5);e=1;for(q=0;24>q;q++){for(var a=w=t=0;7>a;a++){if(e&1){var b=(1<<a)-1;32>b?w^=1<<b:t^=1<<b-32}e=e&128?e<<1^113:e<<1}y[q]=f.create(t,w)}for(var c=[],e=0;25>e;e++)c[e]=f.create();d=d.SHA3=r.extend({cfg:r.cfg.extend({outputLength:512}),_doReset:function(){for(var a=this._state=\n[],b=0;25>b;b++)a[b]=new f.init;this.blockSize=(1600-2*this.cfg.outputLength)/32},_doProcessBlock:function(a,b){for(var e=this._state,f=this.blockSize/2,h=0;h<f;h++){var l=a[b+2*h],m=a[b+2*h+1],l=(l<<8|l>>>24)&16711935|(l<<24|l>>>8)&4278255360,m=(m<<8|m>>>24)&16711935|(m<<24|m>>>8)&4278255360,g=e[h];g.high^=m;g.low^=l}for(f=0;24>f;f++){for(h=0;5>h;h++){for(var d=l=0,k=0;5>k;k++)g=e[h+5*k],l^=g.high,d^=g.low;g=c[h];g.high=l;g.low=d}for(h=0;5>h;h++){g=c[(h+4)%5];l=c[(h+1)%5];m=l.high;k=l.low;l=g.high^\n(m<<1|k>>>31);d=g.low^(k<<1|m>>>31);for(k=0;5>k;k++)g=e[h+5*k],g.high^=l,g.low^=d}for(m=1;25>m;m++)g=e[m],h=g.high,g=g.low,k=s[m],32>k?(l=h<<k|g>>>32-k,d=g<<k|h>>>32-k):(l=g<<k-32|h>>>64-k,d=h<<k-32|g>>>64-k),g=c[x[m]],g.high=l,g.low=d;g=c[0];h=e[0];g.high=h.high;g.low=h.low;for(h=0;5>h;h++)for(k=0;5>k;k++)m=h+5*k,g=e[m],l=c[m],m=c[(h+1)%5+5*k],d=c[(h+2)%5+5*k],g.high=l.high^~m.high&d.high,g.low=l.low^~m.low&d.low;g=e[0];h=y[f];g.high^=h.high;g.low^=h.low}},_doFinalize:function(){var a=this._data,\nb=a.words,c=8*a.sigBytes,e=32*this.blockSize;b[c>>>5]|=1<<24-c%32;b[(v.ceil((c+1)/e)*e>>>5)-1]|=128;a.sigBytes=4*b.length;this._process();for(var a=this._state,b=this.cfg.outputLength/8,c=b/8,e=[],h=0;h<c;h++){var d=a[h],f=d.high,d=d.low,f=(f<<8|f>>>24)&16711935|(f<<24|f>>>8)&4278255360,d=(d<<8|d>>>24)&16711935|(d<<24|d>>>8)&4278255360;e.push(d);e.push(f)}return new u.init(e,b)},clone:function(){for(var a=r.clone.call(this),b=a._state=this._state.slice(0),c=0;25>c;c++)b[c]=b[c].clone();return a}});\np.SHA3=r._createHelper(d);p.HmacSHA3=r._createHmacHelper(d)})(Math);\n"], "crypto_js.rollups.sha384": [".js", "/*\nCryptoJS v3.1.2\ncode.google.com/p/crypto-js\n(c) 2009-2013 by Jeff Mott. All rights reserved.\ncode.google.com/p/crypto-js/wiki/License\n*/\nvar CryptoJS=CryptoJS||function(a,c){var d={},j=d.lib={},f=function(){},m=j.Base={extend:function(a){f.prototype=this;var b=new f;a&&b.mixIn(a);b.hasOwnProperty(\"init\")||(b.init=function(){b.$super.init.apply(this,arguments)});b.init.prototype=b;b.$super=this;return b},create:function(){var a=this.extend();a.init.apply(a,arguments);return a},init:function(){},mixIn:function(a){for(var b in a)a.hasOwnProperty(b)&&(this[b]=a[b]);a.hasOwnProperty(\"toString\")&&(this.toString=a.toString)},clone:function(){return this.init.prototype.extend(this)}},\nB=j.WordArray=m.extend({init:function(a,b){a=this.words=a||[];this.sigBytes=b!=c?b:4*a.length},toString:function(a){return(a||y).stringify(this)},concat:function(a){var b=this.words,g=a.words,e=this.sigBytes;a=a.sigBytes;this.clamp();if(e%4)for(var k=0;k<a;k++)b[e+k>>>2]|=(g[k>>>2]>>>24-8*(k%4)&255)<<24-8*((e+k)%4);else if(65535<g.length)for(k=0;k<a;k+=4)b[e+k>>>2]=g[k>>>2];else b.push.apply(b,g);this.sigBytes+=a;return this},clamp:function(){var n=this.words,b=this.sigBytes;n[b>>>2]&=4294967295<<\n32-8*(b%4);n.length=a.ceil(b/4)},clone:function(){var a=m.clone.call(this);a.words=this.words.slice(0);return a},random:function(n){for(var b=[],g=0;g<n;g+=4)b.push(4294967296*a.random()|0);return new B.init(b,n)}}),v=d.enc={},y=v.Hex={stringify:function(a){var b=a.words;a=a.sigBytes;for(var g=[],e=0;e<a;e++){var k=b[e>>>2]>>>24-8*(e%4)&255;g.push((k>>>4).toString(16));g.push((k&15).toString(16))}return g.join(\"\")},parse:function(a){for(var b=a.length,g=[],e=0;e<b;e+=2)g[e>>>3]|=parseInt(a.substr(e,\n2),16)<<24-4*(e%8);return new B.init(g,b/2)}},F=v.Latin1={stringify:function(a){var b=a.words;a=a.sigBytes;for(var g=[],e=0;e<a;e++)g.push(String.fromCharCode(b[e>>>2]>>>24-8*(e%4)&255));return g.join(\"\")},parse:function(a){for(var b=a.length,g=[],e=0;e<b;e++)g[e>>>2]|=(a.charCodeAt(e)&255)<<24-8*(e%4);return new B.init(g,b)}},ha=v.Utf8={stringify:function(a){try{return decodeURIComponent(escape(F.stringify(a)))}catch(b){throw Error(\"Malformed UTF-8 data\");}},parse:function(a){return F.parse(unescape(encodeURIComponent(a)))}},\nZ=j.BufferedBlockAlgorithm=m.extend({reset:function(){this._data=new B.init;this._nDataBytes=0},_append:function(a){\"string\"==typeof a&&(a=ha.parse(a));this._data.concat(a);this._nDataBytes+=a.sigBytes},_process:function(n){var b=this._data,g=b.words,e=b.sigBytes,k=this.blockSize,m=e/(4*k),m=n?a.ceil(m):a.max((m|0)-this._minBufferSize,0);n=m*k;e=a.min(4*n,e);if(n){for(var c=0;c<n;c+=k)this._doProcessBlock(g,c);c=g.splice(0,n);b.sigBytes-=e}return new B.init(c,e)},clone:function(){var a=m.clone.call(this);\na._data=this._data.clone();return a},_minBufferSize:0});j.Hasher=Z.extend({cfg:m.extend(),init:function(a){this.cfg=this.cfg.extend(a);this.reset()},reset:function(){Z.reset.call(this);this._doReset()},update:function(a){this._append(a);this._process();return this},finalize:function(a){a&&this._append(a);return this._doFinalize()},blockSize:16,_createHelper:function(a){return function(b,g){return(new a.init(g)).finalize(b)}},_createHmacHelper:function(a){return function(b,g){return(new ia.HMAC.init(a,\ng)).finalize(b)}}});var ia=d.algo={};return d}(Math);\n(function(a){var c=CryptoJS,d=c.lib,j=d.Base,f=d.WordArray,c=c.x64={};c.Word=j.extend({init:function(a,c){this.high=a;this.low=c}});c.WordArray=j.extend({init:function(c,d){c=this.words=c||[];this.sigBytes=d!=a?d:8*c.length},toX32:function(){for(var a=this.words,c=a.length,d=[],j=0;j<c;j++){var F=a[j];d.push(F.high);d.push(F.low)}return f.create(d,this.sigBytes)},clone:function(){for(var a=j.clone.call(this),c=a.words=this.words.slice(0),d=c.length,f=0;f<d;f++)c[f]=c[f].clone();return a}})})();\n(function(){function a(){return f.create.apply(f,arguments)}for(var c=CryptoJS,d=c.lib.Hasher,j=c.x64,f=j.Word,m=j.WordArray,j=c.algo,B=[a(1116352408,3609767458),a(1899447441,602891725),a(3049323471,3964484399),a(3921009573,2173295548),a(961987163,4081628472),a(1508970993,3053834265),a(2453635748,2937671579),a(2870763221,3664609560),a(3624381080,2734883394),a(310598401,1164996542),a(607225278,1323610764),a(1426881987,3590304994),a(1925078388,4068182383),a(2162078206,991336113),a(2614888103,633803317),\na(3248222580,3479774868),a(3835390401,2666613458),a(4022224774,944711139),a(264347078,2341262773),a(604807628,2007800933),a(770255983,1495990901),a(1249150122,1856431235),a(1555081692,3175218132),a(1996064986,2198950837),a(2554220882,3999719339),a(2821834349,766784016),a(2952996808,2566594879),a(3210313671,3203337956),a(3336571891,1034457026),a(3584528711,2466948901),a(113926993,3758326383),a(338241895,168717936),a(666307205,1188179964),a(773529912,1546045734),a(1294757372,1522805485),a(1396182291,\n2643833823),a(1695183700,2343527390),a(1986661051,1014477480),a(2177026350,1206759142),a(2456956037,344077627),a(2730485921,1290863460),a(2820302411,3158454273),a(3259730800,3505952657),a(3345764771,106217008),a(3516065817,3606008344),a(3600352804,1432725776),a(4094571909,1467031594),a(275423344,851169720),a(430227734,3100823752),a(506948616,1363258195),a(659060556,3750685593),a(883997877,3785050280),a(958139571,3318307427),a(1322822218,3812723403),a(1537002063,2003034995),a(1747873779,3602036899),\na(1955562222,1575990012),a(2024104815,1125592928),a(2227730452,2716904306),a(2361852424,442776044),a(2428436474,593698344),a(2756734187,3733110249),a(3204031479,2999351573),a(3329325298,3815920427),a(3391569614,3928383900),a(3515267271,566280711),a(3940187606,3454069534),a(4118630271,4000239992),a(116418474,1914138554),a(174292421,2731055270),a(289380356,3203993006),a(460393269,320620315),a(685471733,587496836),a(852142971,1086792851),a(1017036298,365543100),a(1126000580,2618297676),a(1288033470,\n3409855158),a(1501505948,4234509866),a(1607167915,987167468),a(1816402316,1246189591)],v=[],y=0;80>y;y++)v[y]=a();j=j.SHA512=d.extend({_doReset:function(){this._hash=new m.init([new f.init(1779033703,4089235720),new f.init(3144134277,2227873595),new f.init(1013904242,4271175723),new f.init(2773480762,1595750129),new f.init(1359893119,2917565137),new f.init(2600822924,725511199),new f.init(528734635,4215389547),new f.init(1541459225,327033209)])},_doProcessBlock:function(a,c){for(var d=this._hash.words,\nf=d[0],j=d[1],b=d[2],g=d[3],e=d[4],k=d[5],m=d[6],d=d[7],y=f.high,M=f.low,$=j.high,N=j.low,aa=b.high,O=b.low,ba=g.high,P=g.low,ca=e.high,Q=e.low,da=k.high,R=k.low,ea=m.high,S=m.low,fa=d.high,T=d.low,s=y,p=M,G=$,D=N,H=aa,E=O,W=ba,I=P,t=ca,q=Q,U=da,J=R,V=ea,K=S,X=fa,L=T,u=0;80>u;u++){var z=v[u];if(16>u)var r=z.high=a[c+2*u]|0,h=z.low=a[c+2*u+1]|0;else{var r=v[u-15],h=r.high,w=r.low,r=(h>>>1|w<<31)^(h>>>8|w<<24)^h>>>7,w=(w>>>1|h<<31)^(w>>>8|h<<24)^(w>>>7|h<<25),C=v[u-2],h=C.high,l=C.low,C=(h>>>19|l<<\n13)^(h<<3|l>>>29)^h>>>6,l=(l>>>19|h<<13)^(l<<3|h>>>29)^(l>>>6|h<<26),h=v[u-7],Y=h.high,A=v[u-16],x=A.high,A=A.low,h=w+h.low,r=r+Y+(h>>>0<w>>>0?1:0),h=h+l,r=r+C+(h>>>0<l>>>0?1:0),h=h+A,r=r+x+(h>>>0<A>>>0?1:0);z.high=r;z.low=h}var Y=t&U^~t&V,A=q&J^~q&K,z=s&G^s&H^G&H,ja=p&D^p&E^D&E,w=(s>>>28|p<<4)^(s<<30|p>>>2)^(s<<25|p>>>7),C=(p>>>28|s<<4)^(p<<30|s>>>2)^(p<<25|s>>>7),l=B[u],ka=l.high,ga=l.low,l=L+((q>>>14|t<<18)^(q>>>18|t<<14)^(q<<23|t>>>9)),x=X+((t>>>14|q<<18)^(t>>>18|q<<14)^(t<<23|q>>>9))+(l>>>0<\nL>>>0?1:0),l=l+A,x=x+Y+(l>>>0<A>>>0?1:0),l=l+ga,x=x+ka+(l>>>0<ga>>>0?1:0),l=l+h,x=x+r+(l>>>0<h>>>0?1:0),h=C+ja,z=w+z+(h>>>0<C>>>0?1:0),X=V,L=K,V=U,K=J,U=t,J=q,q=I+l|0,t=W+x+(q>>>0<I>>>0?1:0)|0,W=H,I=E,H=G,E=D,G=s,D=p,p=l+h|0,s=x+z+(p>>>0<l>>>0?1:0)|0}M=f.low=M+p;f.high=y+s+(M>>>0<p>>>0?1:0);N=j.low=N+D;j.high=$+G+(N>>>0<D>>>0?1:0);O=b.low=O+E;b.high=aa+H+(O>>>0<E>>>0?1:0);P=g.low=P+I;g.high=ba+W+(P>>>0<I>>>0?1:0);Q=e.low=Q+q;e.high=ca+t+(Q>>>0<q>>>0?1:0);R=k.low=R+J;k.high=da+U+(R>>>0<J>>>0?1:0);\nS=m.low=S+K;m.high=ea+V+(S>>>0<K>>>0?1:0);T=d.low=T+L;d.high=fa+X+(T>>>0<L>>>0?1:0)},_doFinalize:function(){var a=this._data,c=a.words,d=8*this._nDataBytes,f=8*a.sigBytes;c[f>>>5]|=128<<24-f%32;c[(f+128>>>10<<5)+30]=Math.floor(d/4294967296);c[(f+128>>>10<<5)+31]=d;a.sigBytes=4*c.length;this._process();return this._hash.toX32()},clone:function(){var a=d.clone.call(this);a._hash=this._hash.clone();return a},blockSize:32});c.SHA512=d._createHelper(j);c.HmacSHA512=d._createHmacHelper(j)})();\n(function(){var a=CryptoJS,c=a.x64,d=c.Word,j=c.WordArray,c=a.algo,f=c.SHA512,c=c.SHA384=f.extend({_doReset:function(){this._hash=new j.init([new d.init(3418070365,3238371032),new d.init(1654270250,914150663),new d.init(2438529370,812702999),new d.init(355462360,4144912697),new d.init(1731405415,4290775857),new d.init(2394180231,1750603025),new d.init(3675008525,1694076839),new d.init(1203062813,3204075428)])},_doFinalize:function(){var a=f._doFinalize.call(this);a.sigBytes-=16;return a}});a.SHA384=\nf._createHelper(c);a.HmacSHA384=f._createHmacHelper(c)})();\n"], "crypto_js.rollups.sha512": [".js", "/*\nCryptoJS v3.1.2\ncode.google.com/p/crypto-js\n(c) 2009-2013 by Jeff Mott. All rights reserved.\ncode.google.com/p/crypto-js/wiki/License\n*/\nvar CryptoJS=CryptoJS||function(a,m){var r={},f=r.lib={},g=function(){},l=f.Base={extend:function(a){g.prototype=this;var b=new g;a&&b.mixIn(a);b.hasOwnProperty(\"init\")||(b.init=function(){b.$super.init.apply(this,arguments)});b.init.prototype=b;b.$super=this;return b},create:function(){var a=this.extend();a.init.apply(a,arguments);return a},init:function(){},mixIn:function(a){for(var b in a)a.hasOwnProperty(b)&&(this[b]=a[b]);a.hasOwnProperty(\"toString\")&&(this.toString=a.toString)},clone:function(){return this.init.prototype.extend(this)}},\np=f.WordArray=l.extend({init:function(a,b){a=this.words=a||[];this.sigBytes=b!=m?b:4*a.length},toString:function(a){return(a||q).stringify(this)},concat:function(a){var b=this.words,d=a.words,c=this.sigBytes;a=a.sigBytes;this.clamp();if(c%4)for(var j=0;j<a;j++)b[c+j>>>2]|=(d[j>>>2]>>>24-8*(j%4)&255)<<24-8*((c+j)%4);else if(65535<d.length)for(j=0;j<a;j+=4)b[c+j>>>2]=d[j>>>2];else b.push.apply(b,d);this.sigBytes+=a;return this},clamp:function(){var n=this.words,b=this.sigBytes;n[b>>>2]&=4294967295<<\n32-8*(b%4);n.length=a.ceil(b/4)},clone:function(){var a=l.clone.call(this);a.words=this.words.slice(0);return a},random:function(n){for(var b=[],d=0;d<n;d+=4)b.push(4294967296*a.random()|0);return new p.init(b,n)}}),y=r.enc={},q=y.Hex={stringify:function(a){var b=a.words;a=a.sigBytes;for(var d=[],c=0;c<a;c++){var j=b[c>>>2]>>>24-8*(c%4)&255;d.push((j>>>4).toString(16));d.push((j&15).toString(16))}return d.join(\"\")},parse:function(a){for(var b=a.length,d=[],c=0;c<b;c+=2)d[c>>>3]|=parseInt(a.substr(c,\n2),16)<<24-4*(c%8);return new p.init(d,b/2)}},G=y.Latin1={stringify:function(a){var b=a.words;a=a.sigBytes;for(var d=[],c=0;c<a;c++)d.push(String.fromCharCode(b[c>>>2]>>>24-8*(c%4)&255));return d.join(\"\")},parse:function(a){for(var b=a.length,d=[],c=0;c<b;c++)d[c>>>2]|=(a.charCodeAt(c)&255)<<24-8*(c%4);return new p.init(d,b)}},fa=y.Utf8={stringify:function(a){try{return decodeURIComponent(escape(G.stringify(a)))}catch(b){throw Error(\"Malformed UTF-8 data\");}},parse:function(a){return G.parse(unescape(encodeURIComponent(a)))}},\nh=f.BufferedBlockAlgorithm=l.extend({reset:function(){this._data=new p.init;this._nDataBytes=0},_append:function(a){\"string\"==typeof a&&(a=fa.parse(a));this._data.concat(a);this._nDataBytes+=a.sigBytes},_process:function(n){var b=this._data,d=b.words,c=b.sigBytes,j=this.blockSize,l=c/(4*j),l=n?a.ceil(l):a.max((l|0)-this._minBufferSize,0);n=l*j;c=a.min(4*n,c);if(n){for(var h=0;h<n;h+=j)this._doProcessBlock(d,h);h=d.splice(0,n);b.sigBytes-=c}return new p.init(h,c)},clone:function(){var a=l.clone.call(this);\na._data=this._data.clone();return a},_minBufferSize:0});f.Hasher=h.extend({cfg:l.extend(),init:function(a){this.cfg=this.cfg.extend(a);this.reset()},reset:function(){h.reset.call(this);this._doReset()},update:function(a){this._append(a);this._process();return this},finalize:function(a){a&&this._append(a);return this._doFinalize()},blockSize:16,_createHelper:function(a){return function(b,d){return(new a.init(d)).finalize(b)}},_createHmacHelper:function(a){return function(b,d){return(new ga.HMAC.init(a,\nd)).finalize(b)}}});var ga=r.algo={};return r}(Math);\n(function(a){var m=CryptoJS,r=m.lib,f=r.Base,g=r.WordArray,m=m.x64={};m.Word=f.extend({init:function(a,p){this.high=a;this.low=p}});m.WordArray=f.extend({init:function(l,p){l=this.words=l||[];this.sigBytes=p!=a?p:8*l.length},toX32:function(){for(var a=this.words,p=a.length,f=[],q=0;q<p;q++){var G=a[q];f.push(G.high);f.push(G.low)}return g.create(f,this.sigBytes)},clone:function(){for(var a=f.clone.call(this),p=a.words=this.words.slice(0),g=p.length,q=0;q<g;q++)p[q]=p[q].clone();return a}})})();\n(function(){function a(){return g.create.apply(g,arguments)}for(var m=CryptoJS,r=m.lib.Hasher,f=m.x64,g=f.Word,l=f.WordArray,f=m.algo,p=[a(1116352408,3609767458),a(1899447441,602891725),a(3049323471,3964484399),a(3921009573,2173295548),a(961987163,4081628472),a(1508970993,3053834265),a(2453635748,2937671579),a(2870763221,3664609560),a(3624381080,2734883394),a(310598401,1164996542),a(607225278,1323610764),a(1426881987,3590304994),a(1925078388,4068182383),a(2162078206,991336113),a(2614888103,633803317),\na(3248222580,3479774868),a(3835390401,2666613458),a(4022224774,944711139),a(264347078,2341262773),a(604807628,2007800933),a(770255983,1495990901),a(1249150122,1856431235),a(1555081692,3175218132),a(1996064986,2198950837),a(2554220882,3999719339),a(2821834349,766784016),a(2952996808,2566594879),a(3210313671,3203337956),a(3336571891,1034457026),a(3584528711,2466948901),a(113926993,3758326383),a(338241895,168717936),a(666307205,1188179964),a(773529912,1546045734),a(1294757372,1522805485),a(1396182291,\n2643833823),a(1695183700,2343527390),a(1986661051,1014477480),a(2177026350,1206759142),a(2456956037,344077627),a(2730485921,1290863460),a(2820302411,3158454273),a(3259730800,3505952657),a(3345764771,106217008),a(3516065817,3606008344),a(3600352804,1432725776),a(4094571909,1467031594),a(275423344,851169720),a(430227734,3100823752),a(506948616,1363258195),a(659060556,3750685593),a(883997877,3785050280),a(958139571,3318307427),a(1322822218,3812723403),a(1537002063,2003034995),a(1747873779,3602036899),\na(1955562222,1575990012),a(2024104815,1125592928),a(2227730452,2716904306),a(2361852424,442776044),a(2428436474,593698344),a(2756734187,3733110249),a(3204031479,2999351573),a(3329325298,3815920427),a(3391569614,3928383900),a(3515267271,566280711),a(3940187606,3454069534),a(4118630271,4000239992),a(116418474,1914138554),a(174292421,2731055270),a(289380356,3203993006),a(460393269,320620315),a(685471733,587496836),a(852142971,1086792851),a(1017036298,365543100),a(1126000580,2618297676),a(1288033470,\n3409855158),a(1501505948,4234509866),a(1607167915,987167468),a(1816402316,1246189591)],y=[],q=0;80>q;q++)y[q]=a();f=f.SHA512=r.extend({_doReset:function(){this._hash=new l.init([new g.init(1779033703,4089235720),new g.init(3144134277,2227873595),new g.init(1013904242,4271175723),new g.init(2773480762,1595750129),new g.init(1359893119,2917565137),new g.init(2600822924,725511199),new g.init(528734635,4215389547),new g.init(1541459225,327033209)])},_doProcessBlock:function(a,f){for(var h=this._hash.words,\ng=h[0],n=h[1],b=h[2],d=h[3],c=h[4],j=h[5],l=h[6],h=h[7],q=g.high,m=g.low,r=n.high,N=n.low,Z=b.high,O=b.low,$=d.high,P=d.low,aa=c.high,Q=c.low,ba=j.high,R=j.low,ca=l.high,S=l.low,da=h.high,T=h.low,v=q,s=m,H=r,E=N,I=Z,F=O,W=$,J=P,w=aa,t=Q,U=ba,K=R,V=ca,L=S,X=da,M=T,x=0;80>x;x++){var B=y[x];if(16>x)var u=B.high=a[f+2*x]|0,e=B.low=a[f+2*x+1]|0;else{var u=y[x-15],e=u.high,z=u.low,u=(e>>>1|z<<31)^(e>>>8|z<<24)^e>>>7,z=(z>>>1|e<<31)^(z>>>8|e<<24)^(z>>>7|e<<25),D=y[x-2],e=D.high,k=D.low,D=(e>>>19|k<<13)^\n(e<<3|k>>>29)^e>>>6,k=(k>>>19|e<<13)^(k<<3|e>>>29)^(k>>>6|e<<26),e=y[x-7],Y=e.high,C=y[x-16],A=C.high,C=C.low,e=z+e.low,u=u+Y+(e>>>0<z>>>0?1:0),e=e+k,u=u+D+(e>>>0<k>>>0?1:0),e=e+C,u=u+A+(e>>>0<C>>>0?1:0);B.high=u;B.low=e}var Y=w&U^~w&V,C=t&K^~t&L,B=v&H^v&I^H&I,ha=s&E^s&F^E&F,z=(v>>>28|s<<4)^(v<<30|s>>>2)^(v<<25|s>>>7),D=(s>>>28|v<<4)^(s<<30|v>>>2)^(s<<25|v>>>7),k=p[x],ia=k.high,ea=k.low,k=M+((t>>>14|w<<18)^(t>>>18|w<<14)^(t<<23|w>>>9)),A=X+((w>>>14|t<<18)^(w>>>18|t<<14)^(w<<23|t>>>9))+(k>>>0<M>>>\n0?1:0),k=k+C,A=A+Y+(k>>>0<C>>>0?1:0),k=k+ea,A=A+ia+(k>>>0<ea>>>0?1:0),k=k+e,A=A+u+(k>>>0<e>>>0?1:0),e=D+ha,B=z+B+(e>>>0<D>>>0?1:0),X=V,M=L,V=U,L=K,U=w,K=t,t=J+k|0,w=W+A+(t>>>0<J>>>0?1:0)|0,W=I,J=F,I=H,F=E,H=v,E=s,s=k+e|0,v=A+B+(s>>>0<k>>>0?1:0)|0}m=g.low=m+s;g.high=q+v+(m>>>0<s>>>0?1:0);N=n.low=N+E;n.high=r+H+(N>>>0<E>>>0?1:0);O=b.low=O+F;b.high=Z+I+(O>>>0<F>>>0?1:0);P=d.low=P+J;d.high=$+W+(P>>>0<J>>>0?1:0);Q=c.low=Q+t;c.high=aa+w+(Q>>>0<t>>>0?1:0);R=j.low=R+K;j.high=ba+U+(R>>>0<K>>>0?1:0);S=l.low=\nS+L;l.high=ca+V+(S>>>0<L>>>0?1:0);T=h.low=T+M;h.high=da+X+(T>>>0<M>>>0?1:0)},_doFinalize:function(){var a=this._data,f=a.words,h=8*this._nDataBytes,g=8*a.sigBytes;f[g>>>5]|=128<<24-g%32;f[(g+128>>>10<<5)+30]=Math.floor(h/4294967296);f[(g+128>>>10<<5)+31]=h;a.sigBytes=4*f.length;this._process();return this._hash.toX32()},clone:function(){var a=r.clone.call(this);a._hash=this._hash.clone();return a},blockSize:32});m.SHA512=r._createHelper(f);m.HmacSHA512=r._createHmacHelper(f)})();\n"], "abc": [".py", "\n\n\n\"\"\"Abstract Base Classes (ABCs) according to PEP 3119.\"\"\"\n\n\ndef abstractmethod(funcobj):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n funcobj.__isabstractmethod__=True\n return funcobj\n \n \nclass abstractclassmethod(classmethod):\n ''\n\n\n\n\n\n\n\n\n\n \n \n __isabstractmethod__=True\n \n def __init__(self,callable):\n  callable.__isabstractmethod__=True\n  super().__init__(callable)\n  \n  \nclass abstractstaticmethod(staticmethod):\n ''\n\n\n\n\n\n\n\n\n\n \n \n __isabstractmethod__=True\n \n def __init__(self,callable):\n  callable.__isabstractmethod__=True\n  super().__init__(callable)\n  \n  \nclass abstractproperty(property):\n ''\n\n\n\n\n\n\n\n\n\n \n \n __isabstractmethod__=True\n \n \ntry :\n from _abc import (get_cache_token,_abc_init,_abc_register,\n _abc_instancecheck,_abc_subclasscheck,_get_dump,\n _reset_registry,_reset_caches)\nexcept ImportError:\n from _py_abc import ABCMeta,get_cache_token\n ABCMeta.__module__='abc'\nelse :\n class ABCMeta(type):\n  ''\n\n\n\n\n\n\n\n\n\n\n  \n  def __new__(mcls,name,bases,namespace,**kwargs):\n   cls=super().__new__(mcls,name,bases,namespace,**kwargs)\n   _abc_init(cls)\n   return cls\n   \n  def register(cls,subclass):\n   ''\n\n\n   \n   return _abc_register(cls,subclass)\n   \n  def __instancecheck__(cls,instance):\n   ''\n   return _abc_instancecheck(cls,instance)\n   \n  def __subclasscheck__(cls,subclass):\n   ''\n   return _abc_subclasscheck(cls,subclass)\n   \n  def _dump_registry(cls,file=None ):\n   ''\n   print(f\"Class: {cls.__module__}.{cls.__qualname__}\",file=file)\n   print(f\"Inv. counter: {get_cache_token()}\",file=file)\n   (_abc_registry,_abc_cache,_abc_negative_cache,\n   _abc_negative_cache_version)=_get_dump(cls)\n   print(f\"_abc_registry: {_abc_registry!r}\",file=file)\n   print(f\"_abc_cache: {_abc_cache!r}\",file=file)\n   print(f\"_abc_negative_cache: {_abc_negative_cache!r}\",file=file)\n   print(f\"_abc_negative_cache_version: {_abc_negative_cache_version!r}\",\n   file=file)\n   \n  def _abc_registry_clear(cls):\n   ''\n   _reset_registry(cls)\n   \n  def _abc_caches_clear(cls):\n   ''\n   _reset_caches(cls)\n   \n   \ndef update_abstractmethods(cls):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n if not hasattr(cls,'__abstractmethods__'):\n \n \n \n  return cls\n  \n abstracts=set()\n \n \n for scls in cls.__bases__:\n  for name in getattr(scls,'__abstractmethods__',()):\n   value=getattr(cls,name,None )\n   if getattr(value,\"__isabstractmethod__\",False ):\n    abstracts.add(name)\n    \n for name,value in cls.__dict__.items():\n  if getattr(value,\"__isabstractmethod__\",False ):\n   abstracts.add(name)\n cls.__abstractmethods__=frozenset(abstracts)\n return cls\n \n \nclass ABC(metaclass=ABCMeta):\n ''\n\n \n __slots__=()\n", ["_abc", "_py_abc"]], "antigravity": [".py", "\nimport webbrowser\nimport hashlib\n\nwebbrowser.open(\"https://xkcd.com/353/\")\n\ndef geohash(latitude,longitude,datedow):\n ''\n\n\n\n\n \n \n h=hashlib.md5(datedow,usedforsecurity=False ).hexdigest()\n p,q=[('%f'%float.fromhex('0.'+x))for x in (h[:16],h[16:32])]\n print('%d%s %d%s'%(latitude,p[1:],longitude,q[1:]))\n", ["hashlib", "webbrowser"]], "argparse": [".py", "\n\n\n\"\"\"Command-line parsing library\n\nThis module is an optparse-inspired command-line parsing library that:\n\n    - handles both optional and positional arguments\n    - produces highly informative usage messages\n    - supports parsers that dispatch to sub-parsers\n\nThe following is a simple usage example that sums integers from the\ncommand-line and writes the result to a file::\n\n    parser = argparse.ArgumentParser(\n        description='sum the integers at the command line')\n    parser.add_argument(\n        'integers', metavar='int', nargs='+', type=int,\n        help='an integer to be summed')\n    parser.add_argument(\n        '--log', default=sys.stdout, type=argparse.FileType('w'),\n        help='the file where the sum should be written')\n    args = parser.parse_args()\n    args.log.write('%s' % sum(args.integers))\n    args.log.close()\n\nThe module contains the following public classes:\n\n    - ArgumentParser -- The main entry point for command-line parsing. As the\n        example above shows, the add_argument() method is used to populate\n        the parser with actions for optional and positional arguments. Then\n        the parse_args() method is invoked to convert the args at the\n        command-line into an object with attributes.\n\n    - ArgumentError -- The exception raised by ArgumentParser objects when\n        there are errors with the parser's actions. Errors raised while\n        parsing the command-line are caught by ArgumentParser and emitted\n        as command-line messages.\n\n    - FileType -- A factory for defining types of files to be created. As the\n        example above shows, instances of FileType are typically passed as\n        the type= argument of add_argument() calls.\n\n    - Action -- The base class for parser actions. Typically actions are\n        selected by passing strings like 'store_true' or 'append_const' to\n        the action= argument of add_argument(). However, for greater\n        customization of ArgumentParser actions, subclasses of Action may\n        be defined and passed as the action= argument.\n\n    - HelpFormatter, RawDescriptionHelpFormatter, RawTextHelpFormatter,\n        ArgumentDefaultsHelpFormatter -- Formatter classes which\n        may be passed as the formatter_class= argument to the\n        ArgumentParser constructor. HelpFormatter is the default,\n        RawDescriptionHelpFormatter and RawTextHelpFormatter tell the parser\n        not to change the formatting for help text, and\n        ArgumentDefaultsHelpFormatter adds information about argument defaults\n        to the help.\n\nAll other classes in this module are considered implementation details.\n(Also note that HelpFormatter and RawDescriptionHelpFormatter are only\nconsidered public as object names -- the API of the formatter objects is\nstill considered an implementation detail.)\n\"\"\"\n\n__version__='1.1'\n__all__=[\n'ArgumentParser',\n'ArgumentError',\n'ArgumentTypeError',\n'BooleanOptionalAction',\n'FileType',\n'HelpFormatter',\n'ArgumentDefaultsHelpFormatter',\n'RawDescriptionHelpFormatter',\n'RawTextHelpFormatter',\n'MetavarTypeHelpFormatter',\n'Namespace',\n'Action',\n'ONE_OR_MORE',\n'OPTIONAL',\n'PARSER',\n'REMAINDER',\n'SUPPRESS',\n'ZERO_OR_MORE',\n]\n\n\nimport os as _os\nimport re as _re\nimport sys as _sys\n\nfrom gettext import gettext as _,ngettext\n\nSUPPRESS='==SUPPRESS=='\n\nOPTIONAL='?'\nZERO_OR_MORE='*'\nONE_OR_MORE='+'\nPARSER='A...'\nREMAINDER='...'\n_UNRECOGNIZED_ARGS_ATTR='_unrecognized_args'\n\n\n\n\n\nclass _AttributeHolder(object):\n ''\n\n\n\n\n\n \n \n def __repr__(self):\n  type_name=type(self).__name__\n  arg_strings=[]\n  star_args={}\n  for arg in self._get_args():\n   arg_strings.append(repr(arg))\n  for name,value in self._get_kwargs():\n   if name.isidentifier():\n    arg_strings.append('%s=%r'%(name,value))\n   else :\n    star_args[name]=value\n  if star_args:\n   arg_strings.append('**%s'%repr(star_args))\n  return '%s(%s)'%(type_name,', '.join(arg_strings))\n  \n def _get_kwargs(self):\n  return list(self.__dict__.items())\n  \n def _get_args(self):\n  return []\n  \n  \ndef _copy_items(items):\n if items is None :\n  return []\n  \n  \n  \n if type(items)is list:\n  return items[:]\n import copy\n return copy.copy(items)\n \n \n \n \n \n \nclass HelpFormatter(object):\n ''\n\n\n\n \n \n def __init__(self,\n prog,\n indent_increment=2,\n max_help_position=24,\n width=None ):\n \n \n  if width is None :\n   import shutil\n   width=shutil.get_terminal_size().columns\n   width -=2\n   \n  self._prog=prog\n  self._indent_increment=indent_increment\n  self._max_help_position=min(max_help_position,\n  max(width -20,indent_increment *2))\n  self._width=width\n  \n  self._current_indent=0\n  self._level=0\n  self._action_max_length=0\n  \n  self._root_section=self._Section(self,None )\n  self._current_section=self._root_section\n  \n  self._whitespace_matcher=_re.compile(r'\\s+',_re.ASCII)\n  self._long_break_matcher=_re.compile(r'\\n\\n\\n+')\n  \n  \n  \n  \n def _indent(self):\n  self._current_indent +=self._indent_increment\n  self._level +=1\n  \n def _dedent(self):\n  self._current_indent -=self._indent_increment\n  assert self._current_indent >=0,'Indent decreased below 0.'\n  self._level -=1\n  \n class _Section(object):\n \n  def __init__(self,formatter,parent,heading=None ):\n   self.formatter=formatter\n   self.parent=parent\n   self.heading=heading\n   self.items=[]\n   \n  def format_help(self):\n  \n   if self.parent is not None :\n    self.formatter._indent()\n   join=self.formatter._join_parts\n   item_help=join([func(*args)for func,args in self.items])\n   if self.parent is not None :\n    self.formatter._dedent()\n    \n    \n   if not item_help:\n    return ''\n    \n    \n   if self.heading is not SUPPRESS and self.heading is not None :\n    current_indent=self.formatter._current_indent\n    heading='%*s%s:\\n'%(current_indent,'',self.heading)\n   else :\n    heading=''\n    \n    \n   return join(['\\n',heading,item_help,'\\n'])\n   \n def _add_item(self,func,args):\n  self._current_section.items.append((func,args))\n  \n  \n  \n  \n def start_section(self,heading):\n  self._indent()\n  section=self._Section(self,self._current_section,heading)\n  self._add_item(section.format_help,[])\n  self._current_section=section\n  \n def end_section(self):\n  self._current_section=self._current_section.parent\n  self._dedent()\n  \n def add_text(self,text):\n  if text is not SUPPRESS and text is not None :\n   self._add_item(self._format_text,[text])\n   \n def add_usage(self,usage,actions,groups,prefix=None ):\n  if usage is not SUPPRESS:\n   args=usage,actions,groups,prefix\n   self._add_item(self._format_usage,args)\n   \n def add_argument(self,action):\n  if action.help is not SUPPRESS:\n  \n  \n   get_invocation=self._format_action_invocation\n   invocations=[get_invocation(action)]\n   for subaction in self._iter_indented_subactions(action):\n    invocations.append(get_invocation(subaction))\n    \n    \n   invocation_length=max(map(len,invocations))\n   action_length=invocation_length+self._current_indent\n   self._action_max_length=max(self._action_max_length,\n   action_length)\n   \n   \n   self._add_item(self._format_action,[action])\n   \n def add_arguments(self,actions):\n  for action in actions:\n   self.add_argument(action)\n   \n   \n   \n   \n def format_help(self):\n  help=self._root_section.format_help()\n  if help:\n   help=self._long_break_matcher.sub('\\n\\n',help)\n   help=help.strip('\\n')+'\\n'\n  return help\n  \n def _join_parts(self,part_strings):\n  return ''.join([part\n  for part in part_strings\n  if part and part is not SUPPRESS])\n  \n def _format_usage(self,usage,actions,groups,prefix):\n  if prefix is None :\n   prefix=_('usage: ')\n   \n   \n  if usage is not None :\n   usage=usage %dict(prog=self._prog)\n   \n   \n  elif usage is None and not actions:\n   usage='%(prog)s'%dict(prog=self._prog)\n   \n   \n  elif usage is None :\n   prog='%(prog)s'%dict(prog=self._prog)\n   \n   \n   optionals=[]\n   positionals=[]\n   for action in actions:\n    if action.option_strings:\n     optionals.append(action)\n    else :\n     positionals.append(action)\n     \n     \n   format=self._format_actions_usage\n   action_usage=format(optionals+positionals,groups)\n   usage=' '.join([s for s in [prog,action_usage]if s])\n   \n   \n   text_width=self._width -self._current_indent\n   if len(prefix)+len(usage)>text_width:\n   \n   \n    part_regexp=(\n    r'\\(.*?\\)+(?=\\s|$)|'\n    r'\\[.*?\\]+(?=\\s|$)|'\n    r'\\S+'\n    )\n    opt_usage=format(optionals,groups)\n    pos_usage=format(positionals,groups)\n    opt_parts=_re.findall(part_regexp,opt_usage)\n    pos_parts=_re.findall(part_regexp,pos_usage)\n    assert ' '.join(opt_parts)==opt_usage\n    assert ' '.join(pos_parts)==pos_usage\n    \n    \n    def get_lines(parts,indent,prefix=None ):\n     lines=[]\n     line=[]\n     if prefix is not None :\n      line_len=len(prefix)-1\n     else :\n      line_len=len(indent)-1\n     for part in parts:\n      if line_len+1+len(part)>text_width and line:\n       lines.append(indent+' '.join(line))\n       line=[]\n       line_len=len(indent)-1\n      line.append(part)\n      line_len +=len(part)+1\n     if line:\n      lines.append(indent+' '.join(line))\n     if prefix is not None :\n      lines[0]=lines[0][len(indent):]\n     return lines\n     \n     \n    if len(prefix)+len(prog)<=0.75 *text_width:\n     indent=' '*(len(prefix)+len(prog)+1)\n     if opt_parts:\n      lines=get_lines([prog]+opt_parts,indent,prefix)\n      lines.extend(get_lines(pos_parts,indent))\n     elif pos_parts:\n      lines=get_lines([prog]+pos_parts,indent,prefix)\n     else :\n      lines=[prog]\n      \n      \n    else :\n     indent=' '*len(prefix)\n     parts=opt_parts+pos_parts\n     lines=get_lines(parts,indent)\n     if len(lines)>1:\n      lines=[]\n      lines.extend(get_lines(opt_parts,indent))\n      lines.extend(get_lines(pos_parts,indent))\n     lines=[prog]+lines\n     \n     \n    usage='\\n'.join(lines)\n    \n    \n  return '%s%s\\n\\n'%(prefix,usage)\n  \n def _format_actions_usage(self,actions,groups):\n \n  group_actions=set()\n  inserts={}\n  for group in groups:\n   try :\n    start=actions.index(group._group_actions[0])\n   except ValueError:\n    continue\n   else :\n    end=start+len(group._group_actions)\n    if actions[start:end]==group._group_actions:\n     for action in group._group_actions:\n      group_actions.add(action)\n     if not group.required:\n      if start in inserts:\n       inserts[start]+=' ['\n      else :\n       inserts[start]='['\n      if end in inserts:\n       inserts[end]+=']'\n      else :\n       inserts[end]=']'\n     else :\n      if start in inserts:\n       inserts[start]+=' ('\n      else :\n       inserts[start]='('\n      if end in inserts:\n       inserts[end]+=')'\n      else :\n       inserts[end]=')'\n     for i in range(start+1,end):\n      inserts[i]='|'\n      \n      \n  parts=[]\n  for i,action in enumerate(actions):\n  \n  \n  \n   if action.help is SUPPRESS:\n    parts.append(None )\n    if inserts.get(i)=='|':\n     inserts.pop(i)\n    elif inserts.get(i+1)=='|':\n     inserts.pop(i+1)\n     \n     \n   elif not action.option_strings:\n    default=self._get_default_metavar_for_positional(action)\n    part=self._format_args(action,default)\n    \n    \n    if action in group_actions:\n     if part[0]=='['and part[-1]==']':\n      part=part[1:-1]\n      \n      \n    parts.append(part)\n    \n    \n   else :\n    option_string=action.option_strings[0]\n    \n    \n    \n    if action.nargs ==0:\n     part=action.format_usage()\n     \n     \n     \n    else :\n     default=self._get_default_metavar_for_optional(action)\n     args_string=self._format_args(action,default)\n     part='%s %s'%(option_string,args_string)\n     \n     \n    if not action.required and action not in group_actions:\n     part='[%s]'%part\n     \n     \n    parts.append(part)\n    \n    \n  for i in sorted(inserts,reverse=True ):\n   parts[i:i]=[inserts[i]]\n   \n   \n  text=' '.join([item for item in parts if item is not None ])\n  \n  \n  open=r'[\\[(]'\n  close=r'[\\])]'\n  text=_re.sub(r'(%s) '%open,r'\\1',text)\n  text=_re.sub(r' (%s)'%close,r'\\1',text)\n  text=_re.sub(r'%s *%s'%(open,close),r'',text)\n  text=_re.sub(r'\\(([^|]*)\\)',r'\\1',text)\n  text=text.strip()\n  \n  \n  return text\n  \n def _format_text(self,text):\n  if '%(prog)'in text:\n   text=text %dict(prog=self._prog)\n  text_width=max(self._width -self._current_indent,11)\n  indent=' '*self._current_indent\n  return self._fill_text(text,text_width,indent)+'\\n\\n'\n  \n def _format_action(self,action):\n \n  help_position=min(self._action_max_length+2,\n  self._max_help_position)\n  help_width=max(self._width -help_position,11)\n  action_width=help_position -self._current_indent -2\n  action_header=self._format_action_invocation(action)\n  \n  \n  if not action.help:\n   tup=self._current_indent,'',action_header\n   action_header='%*s%s\\n'%tup\n   \n   \n  elif len(action_header)<=action_width:\n   tup=self._current_indent,'',action_width,action_header\n   action_header='%*s%-*s  '%tup\n   indent_first=0\n   \n   \n  else :\n   tup=self._current_indent,'',action_header\n   action_header='%*s%s\\n'%tup\n   indent_first=help_position\n   \n   \n  parts=[action_header]\n  \n  \n  if action.help:\n   help_text=self._expand_help(action)\n   help_lines=self._split_lines(help_text,help_width)\n   parts.append('%*s%s\\n'%(indent_first,'',help_lines[0]))\n   for line in help_lines[1:]:\n    parts.append('%*s%s\\n'%(help_position,'',line))\n    \n    \n  elif not action_header.endswith('\\n'):\n   parts.append('\\n')\n   \n   \n  for subaction in self._iter_indented_subactions(action):\n   parts.append(self._format_action(subaction))\n   \n   \n  return self._join_parts(parts)\n  \n def _format_action_invocation(self,action):\n  if not action.option_strings:\n   default=self._get_default_metavar_for_positional(action)\n   metavar,=self._metavar_formatter(action,default)(1)\n   return metavar\n   \n  else :\n   parts=[]\n   \n   \n   \n   if action.nargs ==0:\n    parts.extend(action.option_strings)\n    \n    \n    \n   else :\n    default=self._get_default_metavar_for_optional(action)\n    args_string=self._format_args(action,default)\n    for option_string in action.option_strings:\n     parts.append('%s %s'%(option_string,args_string))\n     \n   return ', '.join(parts)\n   \n def _metavar_formatter(self,action,default_metavar):\n  if action.metavar is not None :\n   result=action.metavar\n  elif action.choices is not None :\n   choice_strs=[str(choice)for choice in action.choices]\n   result='{%s}'%','.join(choice_strs)\n  else :\n   result=default_metavar\n   \n  def format(tuple_size):\n   if isinstance(result,tuple):\n    return result\n   else :\n    return (result,)*tuple_size\n  return format\n  \n def _format_args(self,action,default_metavar):\n  get_metavar=self._metavar_formatter(action,default_metavar)\n  if action.nargs is None :\n   result='%s'%get_metavar(1)\n  elif action.nargs ==OPTIONAL:\n   result='[%s]'%get_metavar(1)\n  elif action.nargs ==ZERO_OR_MORE:\n   metavar=get_metavar(1)\n   if len(metavar)==2:\n    result='[%s [%s ...]]'%metavar\n   else :\n    result='[%s ...]'%metavar\n  elif action.nargs ==ONE_OR_MORE:\n   result='%s [%s ...]'%get_metavar(2)\n  elif action.nargs ==REMAINDER:\n   result='...'\n  elif action.nargs ==PARSER:\n   result='%s ...'%get_metavar(1)\n  elif action.nargs ==SUPPRESS:\n   result=''\n  else :\n   try :\n    formats=['%s'for _ in range(action.nargs)]\n   except TypeError:\n    raise ValueError(\"invalid nargs value\")from None\n   result=' '.join(formats)%get_metavar(action.nargs)\n  return result\n  \n def _expand_help(self,action):\n  params=dict(vars(action),prog=self._prog)\n  for name in list(params):\n   if params[name]is SUPPRESS:\n    del params[name]\n  for name in list(params):\n   if hasattr(params[name],'__name__'):\n    params[name]=params[name].__name__\n  if params.get('choices')is not None :\n   choices_str=', '.join([str(c)for c in params['choices']])\n   params['choices']=choices_str\n  return self._get_help_string(action)%params\n  \n def _iter_indented_subactions(self,action):\n  try :\n   get_subactions=action._get_subactions\n  except AttributeError:\n   pass\n  else :\n   self._indent()\n   yield from get_subactions()\n   self._dedent()\n   \n def _split_lines(self,text,width):\n  text=self._whitespace_matcher.sub(' ',text).strip()\n  \n  \n  import textwrap\n  return textwrap.wrap(text,width)\n  \n def _fill_text(self,text,width,indent):\n  text=self._whitespace_matcher.sub(' ',text).strip()\n  import textwrap\n  return textwrap.fill(text,width,\n  initial_indent=indent,\n  subsequent_indent=indent)\n  \n def _get_help_string(self,action):\n  return action.help\n  \n def _get_default_metavar_for_optional(self,action):\n  return action.dest.upper()\n  \n def _get_default_metavar_for_positional(self,action):\n  return action.dest\n  \n  \nclass RawDescriptionHelpFormatter(HelpFormatter):\n ''\n\n\n\n \n \n def _fill_text(self,text,width,indent):\n  return ''.join(indent+line for line in text.splitlines(keepends=True ))\n  \n  \nclass RawTextHelpFormatter(RawDescriptionHelpFormatter):\n ''\n\n\n\n \n \n def _split_lines(self,text,width):\n  return text.splitlines()\n  \n  \nclass ArgumentDefaultsHelpFormatter(HelpFormatter):\n ''\n\n\n\n \n \n def _get_help_string(self,action):\n  help=action.help\n  if '%(default)'not in action.help:\n   if action.default is not SUPPRESS:\n    defaulting_nargs=[OPTIONAL,ZERO_OR_MORE]\n    if action.option_strings or action.nargs in defaulting_nargs:\n     help +=' (default: %(default)s)'\n  return help\n  \n  \nclass MetavarTypeHelpFormatter(HelpFormatter):\n ''\n\n\n\n\n \n \n def _get_default_metavar_for_optional(self,action):\n  return action.type.__name__\n  \n def _get_default_metavar_for_positional(self,action):\n  return action.type.__name__\n  \n  \n  \n  \n  \n  \n  \ndef _get_action_name(argument):\n if argument is None :\n  return None\n elif argument.option_strings:\n  return '/'.join(argument.option_strings)\n elif argument.metavar not in (None ,SUPPRESS):\n  return argument.metavar\n elif argument.dest not in (None ,SUPPRESS):\n  return argument.dest\n elif argument.choices:\n  return '{'+','.join(argument.choices)+'}'\n else :\n  return None\n  \n  \nclass ArgumentError(Exception):\n ''\n\n\n\n \n \n def __init__(self,argument,message):\n  self.argument_name=_get_action_name(argument)\n  self.message=message\n  \n def __str__(self):\n  if self.argument_name is None :\n   format='%(message)s'\n  else :\n   format='argument %(argument_name)s: %(message)s'\n  return format %dict(message=self.message,\n  argument_name=self.argument_name)\n  \n  \nclass ArgumentTypeError(Exception):\n ''\n pass\n \n \n \n \n \n \nclass Action(_AttributeHolder):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n def __init__(self,\n option_strings,\n dest,\n nargs=None ,\n const=None ,\n default=None ,\n type=None ,\n choices=None ,\n required=False ,\n help=None ,\n metavar=None ):\n  self.option_strings=option_strings\n  self.dest=dest\n  self.nargs=nargs\n  self.const=const\n  self.default=default\n  self.type=type\n  self.choices=choices\n  self.required=required\n  self.help=help\n  self.metavar=metavar\n  \n def _get_kwargs(self):\n  names=[\n  'option_strings',\n  'dest',\n  'nargs',\n  'const',\n  'default',\n  'type',\n  'choices',\n  'help',\n  'metavar',\n  ]\n  return [(name,getattr(self,name))for name in names]\n  \n def format_usage(self):\n  return self.option_strings[0]\n  \n def __call__(self,parser,namespace,values,option_string=None ):\n  raise NotImplementedError(_('.__call__() not defined'))\n  \nclass BooleanOptionalAction(Action):\n def __init__(self,\n option_strings,\n dest,\n default=None ,\n type=None ,\n choices=None ,\n required=False ,\n help=None ,\n metavar=None ):\n \n  _option_strings=[]\n  for option_string in option_strings:\n   _option_strings.append(option_string)\n   \n   if option_string.startswith('--'):\n    option_string='--no-'+option_string[2:]\n    _option_strings.append(option_string)\n    \n  if help is not None and default is not None :\n   help +=f\" (default: {default})\"\n   \n  super().__init__(\n  option_strings=_option_strings,\n  dest=dest,\n  nargs=0,\n  default=default,\n  type=type,\n  choices=choices,\n  required=required,\n  help=help,\n  metavar=metavar)\n  \n def __call__(self,parser,namespace,values,option_string=None ):\n  if option_string in self.option_strings:\n   setattr(namespace,self.dest,not option_string.startswith('--no-'))\n   \n def format_usage(self):\n  return ' | '.join(self.option_strings)\n  \n  \nclass _StoreAction(Action):\n\n def __init__(self,\n option_strings,\n dest,\n nargs=None ,\n const=None ,\n default=None ,\n type=None ,\n choices=None ,\n required=False ,\n help=None ,\n metavar=None ):\n  if nargs ==0:\n   raise ValueError('nargs for store actions must be != 0; if you '\n   'have nothing to store, actions such as store '\n   'true or store const may be more appropriate')\n  if const is not None and nargs !=OPTIONAL:\n   raise ValueError('nargs must be %r to supply const'%OPTIONAL)\n  super(_StoreAction,self).__init__(\n  option_strings=option_strings,\n  dest=dest,\n  nargs=nargs,\n  const=const,\n  default=default,\n  type=type,\n  choices=choices,\n  required=required,\n  help=help,\n  metavar=metavar)\n  \n def __call__(self,parser,namespace,values,option_string=None ):\n  setattr(namespace,self.dest,values)\n  \n  \nclass _StoreConstAction(Action):\n\n def __init__(self,\n option_strings,\n dest,\n const,\n default=None ,\n required=False ,\n help=None ,\n metavar=None ):\n  super(_StoreConstAction,self).__init__(\n  option_strings=option_strings,\n  dest=dest,\n  nargs=0,\n  const=const,\n  default=default,\n  required=required,\n  help=help)\n  \n def __call__(self,parser,namespace,values,option_string=None ):\n  setattr(namespace,self.dest,self.const)\n  \n  \nclass _StoreTrueAction(_StoreConstAction):\n\n def __init__(self,\n option_strings,\n dest,\n default=False ,\n required=False ,\n help=None ):\n  super(_StoreTrueAction,self).__init__(\n  option_strings=option_strings,\n  dest=dest,\n  const=True ,\n  default=default,\n  required=required,\n  help=help)\n  \n  \nclass _StoreFalseAction(_StoreConstAction):\n\n def __init__(self,\n option_strings,\n dest,\n default=True ,\n required=False ,\n help=None ):\n  super(_StoreFalseAction,self).__init__(\n  option_strings=option_strings,\n  dest=dest,\n  const=False ,\n  default=default,\n  required=required,\n  help=help)\n  \n  \nclass _AppendAction(Action):\n\n def __init__(self,\n option_strings,\n dest,\n nargs=None ,\n const=None ,\n default=None ,\n type=None ,\n choices=None ,\n required=False ,\n help=None ,\n metavar=None ):\n  if nargs ==0:\n   raise ValueError('nargs for append actions must be != 0; if arg '\n   'strings are not supplying the value to append, '\n   'the append const action may be more appropriate')\n  if const is not None and nargs !=OPTIONAL:\n   raise ValueError('nargs must be %r to supply const'%OPTIONAL)\n  super(_AppendAction,self).__init__(\n  option_strings=option_strings,\n  dest=dest,\n  nargs=nargs,\n  const=const,\n  default=default,\n  type=type,\n  choices=choices,\n  required=required,\n  help=help,\n  metavar=metavar)\n  \n def __call__(self,parser,namespace,values,option_string=None ):\n  items=getattr(namespace,self.dest,None )\n  items=_copy_items(items)\n  items.append(values)\n  setattr(namespace,self.dest,items)\n  \n  \nclass _AppendConstAction(Action):\n\n def __init__(self,\n option_strings,\n dest,\n const,\n default=None ,\n required=False ,\n help=None ,\n metavar=None ):\n  super(_AppendConstAction,self).__init__(\n  option_strings=option_strings,\n  dest=dest,\n  nargs=0,\n  const=const,\n  default=default,\n  required=required,\n  help=help,\n  metavar=metavar)\n  \n def __call__(self,parser,namespace,values,option_string=None ):\n  items=getattr(namespace,self.dest,None )\n  items=_copy_items(items)\n  items.append(self.const)\n  setattr(namespace,self.dest,items)\n  \n  \nclass _CountAction(Action):\n\n def __init__(self,\n option_strings,\n dest,\n default=None ,\n required=False ,\n help=None ):\n  super(_CountAction,self).__init__(\n  option_strings=option_strings,\n  dest=dest,\n  nargs=0,\n  default=default,\n  required=required,\n  help=help)\n  \n def __call__(self,parser,namespace,values,option_string=None ):\n  count=getattr(namespace,self.dest,None )\n  if count is None :\n   count=0\n  setattr(namespace,self.dest,count+1)\n  \n  \nclass _HelpAction(Action):\n\n def __init__(self,\n option_strings,\n dest=SUPPRESS,\n default=SUPPRESS,\n help=None ):\n  super(_HelpAction,self).__init__(\n  option_strings=option_strings,\n  dest=dest,\n  default=default,\n  nargs=0,\n  help=help)\n  \n def __call__(self,parser,namespace,values,option_string=None ):\n  parser.print_help()\n  parser.exit()\n  \n  \nclass _VersionAction(Action):\n\n def __init__(self,\n option_strings,\n version=None ,\n dest=SUPPRESS,\n default=SUPPRESS,\n help=\"show program's version number and exit\"):\n  super(_VersionAction,self).__init__(\n  option_strings=option_strings,\n  dest=dest,\n  default=default,\n  nargs=0,\n  help=help)\n  self.version=version\n  \n def __call__(self,parser,namespace,values,option_string=None ):\n  version=self.version\n  if version is None :\n   version=parser.version\n  formatter=parser._get_formatter()\n  formatter.add_text(version)\n  parser._print_message(formatter.format_help(),_sys.stdout)\n  parser.exit()\n  \n  \nclass _SubParsersAction(Action):\n\n class _ChoicesPseudoAction(Action):\n \n  def __init__(self,name,aliases,help):\n   metavar=dest=name\n   if aliases:\n    metavar +=' (%s)'%', '.join(aliases)\n   sup=super(_SubParsersAction._ChoicesPseudoAction,self)\n   sup.__init__(option_strings=[],dest=dest,help=help,\n   metavar=metavar)\n   \n def __init__(self,\n option_strings,\n prog,\n parser_class,\n dest=SUPPRESS,\n required=False ,\n help=None ,\n metavar=None ):\n \n  self._prog_prefix=prog\n  self._parser_class=parser_class\n  self._name_parser_map={}\n  self._choices_actions=[]\n  \n  super(_SubParsersAction,self).__init__(\n  option_strings=option_strings,\n  dest=dest,\n  nargs=PARSER,\n  choices=self._name_parser_map,\n  required=required,\n  help=help,\n  metavar=metavar)\n  \n def add_parser(self,name,**kwargs):\n \n  if kwargs.get('prog')is None :\n   kwargs['prog']='%s %s'%(self._prog_prefix,name)\n   \n  aliases=kwargs.pop('aliases',())\n  \n  \n  if 'help'in kwargs:\n   help=kwargs.pop('help')\n   choice_action=self._ChoicesPseudoAction(name,aliases,help)\n   self._choices_actions.append(choice_action)\n   \n   \n  parser=self._parser_class(**kwargs)\n  self._name_parser_map[name]=parser\n  \n  \n  for alias in aliases:\n   self._name_parser_map[alias]=parser\n   \n  return parser\n  \n def _get_subactions(self):\n  return self._choices_actions\n  \n def __call__(self,parser,namespace,values,option_string=None ):\n  parser_name=values[0]\n  arg_strings=values[1:]\n  \n  \n  if self.dest is not SUPPRESS:\n   setattr(namespace,self.dest,parser_name)\n   \n   \n  try :\n   parser=self._name_parser_map[parser_name]\n  except KeyError:\n   args={'parser_name':parser_name,\n   'choices':', '.join(self._name_parser_map)}\n   msg=_('unknown parser %(parser_name)r (choices: %(choices)s)')%args\n   raise ArgumentError(self,msg)\n   \n   \n   \n   \n   \n   \n   \n   \n  subnamespace,arg_strings=parser.parse_known_args(arg_strings,None )\n  for key,value in vars(subnamespace).items():\n   setattr(namespace,key,value)\n   \n  if arg_strings:\n   vars(namespace).setdefault(_UNRECOGNIZED_ARGS_ATTR,[])\n   getattr(namespace,_UNRECOGNIZED_ARGS_ATTR).extend(arg_strings)\n   \nclass _ExtendAction(_AppendAction):\n def __call__(self,parser,namespace,values,option_string=None ):\n  items=getattr(namespace,self.dest,None )\n  items=_copy_items(items)\n  items.extend(values)\n  setattr(namespace,self.dest,items)\n  \n  \n  \n  \n  \nclass FileType(object):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n def __init__(self,mode='r',bufsize=-1,encoding=None ,errors=None ):\n  self._mode=mode\n  self._bufsize=bufsize\n  self._encoding=encoding\n  self._errors=errors\n  \n def __call__(self,string):\n \n  if string =='-':\n   if 'r'in self._mode:\n    return _sys.stdin\n   elif 'w'in self._mode:\n    return _sys.stdout\n   else :\n    msg=_('argument \"-\" with mode %r')%self._mode\n    raise ValueError(msg)\n    \n    \n  try :\n   return open(string,self._mode,self._bufsize,self._encoding,\n   self._errors)\n  except OSError as e:\n   args={'filename':string,'error':e}\n   message=_(\"can't open '%(filename)s': %(error)s\")\n   raise ArgumentTypeError(message %args)\n   \n def __repr__(self):\n  args=self._mode,self._bufsize\n  kwargs=[('encoding',self._encoding),('errors',self._errors)]\n  args_str=', '.join([repr(arg)for arg in args if arg !=-1]+\n  ['%s=%r'%(kw,arg)for kw,arg in kwargs\n  if arg is not None ])\n  return '%s(%s)'%(type(self).__name__,args_str)\n  \n  \n  \n  \n  \nclass Namespace(_AttributeHolder):\n ''\n\n\n\n \n \n def __init__(self,**kwargs):\n  for name in kwargs:\n   setattr(self,name,kwargs[name])\n   \n def __eq__(self,other):\n  if not isinstance(other,Namespace):\n   return NotImplemented\n  return vars(self)==vars(other)\n  \n def __contains__(self,key):\n  return key in self.__dict__\n  \n  \nclass _ActionsContainer(object):\n\n def __init__(self,\n description,\n prefix_chars,\n argument_default,\n conflict_handler):\n  super(_ActionsContainer,self).__init__()\n  \n  self.description=description\n  self.argument_default=argument_default\n  self.prefix_chars=prefix_chars\n  self.conflict_handler=conflict_handler\n  \n  \n  self._registries={}\n  \n  \n  self.register('action',None ,_StoreAction)\n  self.register('action','store',_StoreAction)\n  self.register('action','store_const',_StoreConstAction)\n  self.register('action','store_true',_StoreTrueAction)\n  self.register('action','store_false',_StoreFalseAction)\n  self.register('action','append',_AppendAction)\n  self.register('action','append_const',_AppendConstAction)\n  self.register('action','count',_CountAction)\n  self.register('action','help',_HelpAction)\n  self.register('action','version',_VersionAction)\n  self.register('action','parsers',_SubParsersAction)\n  self.register('action','extend',_ExtendAction)\n  \n  \n  self._get_handler()\n  \n  \n  self._actions=[]\n  self._option_string_actions={}\n  \n  \n  self._action_groups=[]\n  self._mutually_exclusive_groups=[]\n  \n  \n  self._defaults={}\n  \n  \n  self._negative_number_matcher=_re.compile(r'^-\\d+$|^-\\d*\\.\\d+$')\n  \n  \n  \n  self._has_negative_number_optionals=[]\n  \n  \n  \n  \n def register(self,registry_name,value,object):\n  registry=self._registries.setdefault(registry_name,{})\n  registry[value]=object\n  \n def _registry_get(self,registry_name,value,default=None ):\n  return self._registries[registry_name].get(value,default)\n  \n  \n  \n  \n def set_defaults(self,**kwargs):\n  self._defaults.update(kwargs)\n  \n  \n  \n  for action in self._actions:\n   if action.dest in kwargs:\n    action.default=kwargs[action.dest]\n    \n def get_default(self,dest):\n  for action in self._actions:\n   if action.dest ==dest and action.default is not None :\n    return action.default\n  return self._defaults.get(dest,None )\n  \n  \n  \n  \n  \n def add_argument(self,*args,**kwargs):\n  ''\n\n\n  \n  \n  \n  \n  \n  chars=self.prefix_chars\n  if not args or len(args)==1 and args[0][0]not in chars:\n   if args and 'dest'in kwargs:\n    raise ValueError('dest supplied twice for positional argument')\n   kwargs=self._get_positional_kwargs(*args,**kwargs)\n   \n   \n  else :\n   kwargs=self._get_optional_kwargs(*args,**kwargs)\n   \n   \n  if 'default'not in kwargs:\n   dest=kwargs['dest']\n   if dest in self._defaults:\n    kwargs['default']=self._defaults[dest]\n   elif self.argument_default is not None :\n    kwargs['default']=self.argument_default\n    \n    \n  action_class=self._pop_action_class(kwargs)\n  if not callable(action_class):\n   raise ValueError('unknown action \"%s\"'%(action_class,))\n  action=action_class(**kwargs)\n  \n  \n  type_func=self._registry_get('type',action.type,action.type)\n  if not callable(type_func):\n   raise ValueError('%r is not callable'%(type_func,))\n   \n  if type_func is FileType:\n   raise ValueError('%r is a FileType class object, instance of it'\n   ' must be passed'%(type_func,))\n   \n   \n  if hasattr(self,\"_get_formatter\"):\n   try :\n    self._get_formatter()._format_args(action,None )\n   except TypeError:\n    raise ValueError(\"length of metavar tuple does not match nargs\")\n    \n  return self._add_action(action)\n  \n def add_argument_group(self,*args,**kwargs):\n  group=_ArgumentGroup(self,*args,**kwargs)\n  self._action_groups.append(group)\n  return group\n  \n def add_mutually_exclusive_group(self,**kwargs):\n  group=_MutuallyExclusiveGroup(self,**kwargs)\n  self._mutually_exclusive_groups.append(group)\n  return group\n  \n def _add_action(self,action):\n \n  self._check_conflict(action)\n  \n  \n  self._actions.append(action)\n  action.container=self\n  \n  \n  for option_string in action.option_strings:\n   self._option_string_actions[option_string]=action\n   \n   \n  for option_string in action.option_strings:\n   if self._negative_number_matcher.match(option_string):\n    if not self._has_negative_number_optionals:\n     self._has_negative_number_optionals.append(True )\n     \n     \n  return action\n  \n def _remove_action(self,action):\n  self._actions.remove(action)\n  \n def _add_container_actions(self,container):\n \n  title_group_map={}\n  for group in self._action_groups:\n   if group.title in title_group_map:\n    msg=_('cannot merge actions - two groups are named %r')\n    raise ValueError(msg %(group.title))\n   title_group_map[group.title]=group\n   \n   \n  group_map={}\n  for group in container._action_groups:\n  \n  \n  \n   if group.title not in title_group_map:\n    title_group_map[group.title]=self.add_argument_group(\n    title=group.title,\n    description=group.description,\n    conflict_handler=group.conflict_handler)\n    \n    \n   for action in group._group_actions:\n    group_map[action]=title_group_map[group.title]\n    \n    \n    \n    \n  for group in container._mutually_exclusive_groups:\n   mutex_group=self.add_mutually_exclusive_group(\n   required=group.required)\n   \n   \n   for action in group._group_actions:\n    group_map[action]=mutex_group\n    \n    \n  for action in container._actions:\n   group_map.get(action,self)._add_action(action)\n   \n def _get_positional_kwargs(self,dest,**kwargs):\n \n  if 'required'in kwargs:\n   msg=_(\"'required' is an invalid argument for positionals\")\n   raise TypeError(msg)\n   \n   \n   \n  if kwargs.get('nargs')not in [OPTIONAL,ZERO_OR_MORE]:\n   kwargs['required']=True\n  if kwargs.get('nargs')==ZERO_OR_MORE and 'default'not in kwargs:\n   kwargs['required']=True\n   \n   \n  return dict(kwargs,dest=dest,option_strings=[])\n  \n def _get_optional_kwargs(self,*args,**kwargs):\n \n  option_strings=[]\n  long_option_strings=[]\n  for option_string in args:\n  \n   if not option_string[0]in self.prefix_chars:\n    args={'option':option_string,\n    'prefix_chars':self.prefix_chars}\n    msg=_('invalid option string %(option)r: '\n    'must start with a character %(prefix_chars)r')\n    raise ValueError(msg %args)\n    \n    \n   option_strings.append(option_string)\n   if len(option_string)>1 and option_string[1]in self.prefix_chars:\n    long_option_strings.append(option_string)\n    \n    \n  dest=kwargs.pop('dest',None )\n  if dest is None :\n   if long_option_strings:\n    dest_option_string=long_option_strings[0]\n   else :\n    dest_option_string=option_strings[0]\n   dest=dest_option_string.lstrip(self.prefix_chars)\n   if not dest:\n    msg=_('dest= is required for options like %r')\n    raise ValueError(msg %option_string)\n   dest=dest.replace('-','_')\n   \n   \n  return dict(kwargs,dest=dest,option_strings=option_strings)\n  \n def _pop_action_class(self,kwargs,default=None ):\n  action=kwargs.pop('action',default)\n  return self._registry_get('action',action,action)\n  \n def _get_handler(self):\n \n  handler_func_name='_handle_conflict_%s'%self.conflict_handler\n  try :\n   return getattr(self,handler_func_name)\n  except AttributeError:\n   msg=_('invalid conflict_resolution value: %r')\n   raise ValueError(msg %self.conflict_handler)\n   \n def _check_conflict(self,action):\n \n \n  confl_optionals=[]\n  for option_string in action.option_strings:\n   if option_string in self._option_string_actions:\n    confl_optional=self._option_string_actions[option_string]\n    confl_optionals.append((option_string,confl_optional))\n    \n    \n  if confl_optionals:\n   conflict_handler=self._get_handler()\n   conflict_handler(action,confl_optionals)\n   \n def _handle_conflict_error(self,action,conflicting_actions):\n  message=ngettext('conflicting option string: %s',\n  'conflicting option strings: %s',\n  len(conflicting_actions))\n  conflict_string=', '.join([option_string\n  for option_string,action\n  in conflicting_actions])\n  raise ArgumentError(action,message %conflict_string)\n  \n def _handle_conflict_resolve(self,action,conflicting_actions):\n \n \n  for option_string,action in conflicting_actions:\n  \n  \n   action.option_strings.remove(option_string)\n   self._option_string_actions.pop(option_string,None )\n   \n   \n   \n   if not action.option_strings:\n    action.container._remove_action(action)\n    \n    \nclass _ArgumentGroup(_ActionsContainer):\n\n def __init__(self,container,title=None ,description=None ,**kwargs):\n \n  update=kwargs.setdefault\n  update('conflict_handler',container.conflict_handler)\n  update('prefix_chars',container.prefix_chars)\n  update('argument_default',container.argument_default)\n  super_init=super(_ArgumentGroup,self).__init__\n  super_init(description=description,**kwargs)\n  \n  \n  self.title=title\n  self._group_actions=[]\n  \n  \n  self._registries=container._registries\n  self._actions=container._actions\n  self._option_string_actions=container._option_string_actions\n  self._defaults=container._defaults\n  self._has_negative_number_optionals=\\\n  container._has_negative_number_optionals\n  self._mutually_exclusive_groups=container._mutually_exclusive_groups\n  \n def _add_action(self,action):\n  action=super(_ArgumentGroup,self)._add_action(action)\n  self._group_actions.append(action)\n  return action\n  \n def _remove_action(self,action):\n  super(_ArgumentGroup,self)._remove_action(action)\n  self._group_actions.remove(action)\n  \n  \nclass _MutuallyExclusiveGroup(_ArgumentGroup):\n\n def __init__(self,container,required=False ):\n  super(_MutuallyExclusiveGroup,self).__init__(container)\n  self.required=required\n  self._container=container\n  \n def _add_action(self,action):\n  if action.required:\n   msg=_('mutually exclusive arguments must be optional')\n   raise ValueError(msg)\n  action=self._container._add_action(action)\n  self._group_actions.append(action)\n  return action\n  \n def _remove_action(self,action):\n  self._container._remove_action(action)\n  self._group_actions.remove(action)\n  \n  \nclass ArgumentParser(_AttributeHolder,_ActionsContainer):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n def __init__(self,\n prog=None ,\n usage=None ,\n description=None ,\n epilog=None ,\n parents=[],\n formatter_class=HelpFormatter,\n prefix_chars='-',\n fromfile_prefix_chars=None ,\n argument_default=None ,\n conflict_handler='error',\n add_help=True ,\n allow_abbrev=True ,\n exit_on_error=True ):\n \n  superinit=super(ArgumentParser,self).__init__\n  superinit(description=description,\n  prefix_chars=prefix_chars,\n  argument_default=argument_default,\n  conflict_handler=conflict_handler)\n  \n  \n  if prog is None :\n   prog=_os.path.basename(_sys.argv[0])\n   \n  self.prog=prog\n  self.usage=usage\n  self.epilog=epilog\n  self.formatter_class=formatter_class\n  self.fromfile_prefix_chars=fromfile_prefix_chars\n  self.add_help=add_help\n  self.allow_abbrev=allow_abbrev\n  self.exit_on_error=exit_on_error\n  \n  add_group=self.add_argument_group\n  self._positionals=add_group(_('positional arguments'))\n  self._optionals=add_group(_('options'))\n  self._subparsers=None\n  \n  \n  def identity(string):\n   return string\n  self.register('type',None ,identity)\n  \n  \n  \n  default_prefix='-'if '-'in prefix_chars else prefix_chars[0]\n  if self.add_help:\n   self.add_argument(\n   default_prefix+'h',default_prefix *2+'help',\n   action='help',default=SUPPRESS,\n   help=_('show this help message and exit'))\n   \n   \n  for parent in parents:\n   self._add_container_actions(parent)\n   try :\n    defaults=parent._defaults\n   except AttributeError:\n    pass\n   else :\n    self._defaults.update(defaults)\n    \n    \n    \n    \n def _get_kwargs(self):\n  names=[\n  'prog',\n  'usage',\n  'description',\n  'formatter_class',\n  'conflict_handler',\n  'add_help',\n  ]\n  return [(name,getattr(self,name))for name in names]\n  \n  \n  \n  \n def add_subparsers(self,**kwargs):\n  if self._subparsers is not None :\n   self.error(_('cannot have multiple subparser arguments'))\n   \n   \n  kwargs.setdefault('parser_class',type(self))\n  \n  if 'title'in kwargs or 'description'in kwargs:\n   title=_(kwargs.pop('title','subcommands'))\n   description=_(kwargs.pop('description',None ))\n   self._subparsers=self.add_argument_group(title,description)\n  else :\n   self._subparsers=self._positionals\n   \n   \n   \n  if kwargs.get('prog')is None :\n   formatter=self._get_formatter()\n   positionals=self._get_positional_actions()\n   groups=self._mutually_exclusive_groups\n   formatter.add_usage(self.usage,positionals,groups,'')\n   kwargs['prog']=formatter.format_help().strip()\n   \n   \n  parsers_class=self._pop_action_class(kwargs,'parsers')\n  action=parsers_class(option_strings=[],**kwargs)\n  self._subparsers._add_action(action)\n  \n  \n  return action\n  \n def _add_action(self,action):\n  if action.option_strings:\n   self._optionals._add_action(action)\n  else :\n   self._positionals._add_action(action)\n  return action\n  \n def _get_optional_actions(self):\n  return [action\n  for action in self._actions\n  if action.option_strings]\n  \n def _get_positional_actions(self):\n  return [action\n  for action in self._actions\n  if not action.option_strings]\n  \n  \n  \n  \n def parse_args(self,args=None ,namespace=None ):\n  args,argv=self.parse_known_args(args,namespace)\n  if argv:\n   msg=_('unrecognized arguments: %s')\n   self.error(msg %' '.join(argv))\n  return args\n  \n def parse_known_args(self,args=None ,namespace=None ):\n  if args is None :\n  \n   args=_sys.argv[1:]\n  else :\n  \n   args=list(args)\n   \n   \n  if namespace is None :\n   namespace=Namespace()\n   \n   \n  for action in self._actions:\n   if action.dest is not SUPPRESS:\n    if not hasattr(namespace,action.dest):\n     if action.default is not SUPPRESS:\n      setattr(namespace,action.dest,action.default)\n      \n      \n  for dest in self._defaults:\n   if not hasattr(namespace,dest):\n    setattr(namespace,dest,self._defaults[dest])\n    \n    \n  if self.exit_on_error:\n   try :\n    namespace,args=self._parse_known_args(args,namespace)\n   except ArgumentError:\n    err=_sys.exc_info()[1]\n    self.error(str(err))\n  else :\n   namespace,args=self._parse_known_args(args,namespace)\n   \n  if hasattr(namespace,_UNRECOGNIZED_ARGS_ATTR):\n   args.extend(getattr(namespace,_UNRECOGNIZED_ARGS_ATTR))\n   delattr(namespace,_UNRECOGNIZED_ARGS_ATTR)\n  return namespace,args\n  \n def _parse_known_args(self,arg_strings,namespace):\n \n  if self.fromfile_prefix_chars is not None :\n   arg_strings=self._read_args_from_files(arg_strings)\n   \n   \n   \n  action_conflicts={}\n  for mutex_group in self._mutually_exclusive_groups:\n   group_actions=mutex_group._group_actions\n   for i,mutex_action in enumerate(mutex_group._group_actions):\n    conflicts=action_conflicts.setdefault(mutex_action,[])\n    conflicts.extend(group_actions[:i])\n    conflicts.extend(group_actions[i+1:])\n    \n    \n    \n    \n  option_string_indices={}\n  arg_string_pattern_parts=[]\n  arg_strings_iter=iter(arg_strings)\n  for i,arg_string in enumerate(arg_strings_iter):\n  \n  \n   if arg_string =='--':\n    arg_string_pattern_parts.append('-')\n    for arg_string in arg_strings_iter:\n     arg_string_pattern_parts.append('A')\n     \n     \n     \n   else :\n    option_tuple=self._parse_optional(arg_string)\n    if option_tuple is None :\n     pattern='A'\n    else :\n     option_string_indices[i]=option_tuple\n     pattern='O'\n    arg_string_pattern_parts.append(pattern)\n    \n    \n  arg_strings_pattern=''.join(arg_string_pattern_parts)\n  \n  \n  seen_actions=set()\n  seen_non_default_actions=set()\n  \n  def take_action(action,argument_strings,option_string=None ):\n   seen_actions.add(action)\n   argument_values=self._get_values(action,argument_strings)\n   \n   \n   \n   \n   if argument_values is not action.default:\n    seen_non_default_actions.add(action)\n    for conflict_action in action_conflicts.get(action,[]):\n     if conflict_action in seen_non_default_actions:\n      msg=_('not allowed with argument %s')\n      action_name=_get_action_name(conflict_action)\n      raise ArgumentError(action,msg %action_name)\n      \n      \n      \n   if argument_values is not SUPPRESS:\n    action(self,namespace,argument_values,option_string)\n    \n    \n  def consume_optional(start_index):\n  \n  \n   option_tuple=option_string_indices[start_index]\n   action,option_string,explicit_arg=option_tuple\n   \n   \n   \n   match_argument=self._match_argument\n   action_tuples=[]\n   while True :\n   \n   \n    if action is None :\n     extras.append(arg_strings[start_index])\n     return start_index+1\n     \n     \n     \n    if explicit_arg is not None :\n     arg_count=match_argument(action,'A')\n     \n     \n     \n     \n     chars=self.prefix_chars\n     if arg_count ==0 and option_string[1]not in chars:\n      action_tuples.append((action,[],option_string))\n      char=option_string[0]\n      option_string=char+explicit_arg[0]\n      new_explicit_arg=explicit_arg[1:]or None\n      optionals_map=self._option_string_actions\n      if option_string in optionals_map:\n       action=optionals_map[option_string]\n       explicit_arg=new_explicit_arg\n      else :\n       msg=_('ignored explicit argument %r')\n       raise ArgumentError(action,msg %explicit_arg)\n       \n       \n       \n     elif arg_count ==1:\n      stop=start_index+1\n      args=[explicit_arg]\n      action_tuples.append((action,args,option_string))\n      break\n      \n      \n      \n     else :\n      msg=_('ignored explicit argument %r')\n      raise ArgumentError(action,msg %explicit_arg)\n      \n      \n      \n      \n    else :\n     start=start_index+1\n     selected_patterns=arg_strings_pattern[start:]\n     arg_count=match_argument(action,selected_patterns)\n     stop=start+arg_count\n     args=arg_strings[start:stop]\n     action_tuples.append((action,args,option_string))\n     break\n     \n     \n     \n   assert action_tuples\n   for action,args,option_string in action_tuples:\n    take_action(action,args,option_string)\n   return stop\n   \n   \n   \n  positionals=self._get_positional_actions()\n  \n  \n  def consume_positionals(start_index):\n  \n   match_partial=self._match_arguments_partial\n   selected_pattern=arg_strings_pattern[start_index:]\n   arg_counts=match_partial(positionals,selected_pattern)\n   \n   \n   \n   for action,arg_count in zip(positionals,arg_counts):\n    args=arg_strings[start_index:start_index+arg_count]\n    start_index +=arg_count\n    take_action(action,args)\n    \n    \n    \n   positionals[:]=positionals[len(arg_counts):]\n   return start_index\n   \n   \n   \n  extras=[]\n  start_index=0\n  if option_string_indices:\n   max_option_string_index=max(option_string_indices)\n  else :\n   max_option_string_index=-1\n  while start_index <=max_option_string_index:\n  \n  \n   next_option_string_index=min([\n   index\n   for index in option_string_indices\n   if index >=start_index])\n   if start_index !=next_option_string_index:\n    positionals_end_index=consume_positionals(start_index)\n    \n    \n    \n    if positionals_end_index >start_index:\n     start_index=positionals_end_index\n     continue\n    else :\n     start_index=positionals_end_index\n     \n     \n     \n   if start_index not in option_string_indices:\n    strings=arg_strings[start_index:next_option_string_index]\n    extras.extend(strings)\n    start_index=next_option_string_index\n    \n    \n   start_index=consume_optional(start_index)\n   \n   \n  stop_index=consume_positionals(start_index)\n  \n  \n  extras.extend(arg_strings[stop_index:])\n  \n  \n  \n  required_actions=[]\n  for action in self._actions:\n   if action not in seen_actions:\n    if action.required:\n     required_actions.append(_get_action_name(action))\n    else :\n    \n    \n    \n    \n     if (action.default is not None and\n     isinstance(action.default,str)and\n     hasattr(namespace,action.dest)and\n     action.default is getattr(namespace,action.dest)):\n      setattr(namespace,action.dest,\n      self._get_value(action,action.default))\n      \n  if required_actions:\n   self.error(_('the following arguments are required: %s')%\n   ', '.join(required_actions))\n   \n   \n  for group in self._mutually_exclusive_groups:\n   if group.required:\n    for action in group._group_actions:\n     if action in seen_non_default_actions:\n      break\n      \n      \n    else :\n     names=[_get_action_name(action)\n     for action in group._group_actions\n     if action.help is not SUPPRESS]\n     msg=_('one of the arguments %s is required')\n     self.error(msg %' '.join(names))\n     \n     \n  return namespace,extras\n  \n def _read_args_from_files(self,arg_strings):\n \n  new_arg_strings=[]\n  for arg_string in arg_strings:\n  \n  \n   if not arg_string or arg_string[0]not in self.fromfile_prefix_chars:\n    new_arg_strings.append(arg_string)\n    \n    \n   else :\n    try :\n     with open(arg_string[1:])as args_file:\n      arg_strings=[]\n      for arg_line in args_file.read().splitlines():\n       for arg in self.convert_arg_line_to_args(arg_line):\n        arg_strings.append(arg)\n      arg_strings=self._read_args_from_files(arg_strings)\n      new_arg_strings.extend(arg_strings)\n    except OSError:\n     err=_sys.exc_info()[1]\n     self.error(str(err))\n     \n     \n  return new_arg_strings\n  \n def convert_arg_line_to_args(self,arg_line):\n  return [arg_line]\n  \n def _match_argument(self,action,arg_strings_pattern):\n \n  nargs_pattern=self._get_nargs_pattern(action)\n  match=_re.match(nargs_pattern,arg_strings_pattern)\n  \n  \n  if match is None :\n   nargs_errors={\n   None :_('expected one argument'),\n   OPTIONAL:_('expected at most one argument'),\n   ONE_OR_MORE:_('expected at least one argument'),\n   }\n   msg=nargs_errors.get(action.nargs)\n   if msg is None :\n    msg=ngettext('expected %s argument',\n    'expected %s arguments',\n    action.nargs)%action.nargs\n   raise ArgumentError(action,msg)\n   \n   \n  return len(match.group(1))\n  \n def _match_arguments_partial(self,actions,arg_strings_pattern):\n \n \n  result=[]\n  for i in range(len(actions),0,-1):\n   actions_slice=actions[:i]\n   pattern=''.join([self._get_nargs_pattern(action)\n   for action in actions_slice])\n   match=_re.match(pattern,arg_strings_pattern)\n   if match is not None :\n    result.extend([len(string)for string in match.groups()])\n    break\n    \n    \n  return result\n  \n def _parse_optional(self,arg_string):\n \n  if not arg_string:\n   return None\n   \n   \n  if not arg_string[0]in self.prefix_chars:\n   return None\n   \n   \n  if arg_string in self._option_string_actions:\n   action=self._option_string_actions[arg_string]\n   return action,arg_string,None\n   \n   \n  if len(arg_string)==1:\n   return None\n   \n   \n  if '='in arg_string:\n   option_string,explicit_arg=arg_string.split('=',1)\n   if option_string in self._option_string_actions:\n    action=self._option_string_actions[option_string]\n    return action,option_string,explicit_arg\n    \n    \n    \n  option_tuples=self._get_option_tuples(arg_string)\n  \n  \n  if len(option_tuples)>1:\n   options=', '.join([option_string\n   for action,option_string,explicit_arg in option_tuples])\n   args={'option':arg_string,'matches':options}\n   msg=_('ambiguous option: %(option)s could match %(matches)s')\n   self.error(msg %args)\n   \n   \n   \n  elif len(option_tuples)==1:\n   option_tuple,=option_tuples\n   return option_tuple\n   \n   \n   \n   \n  if self._negative_number_matcher.match(arg_string):\n   if not self._has_negative_number_optionals:\n    return None\n    \n    \n  if ' 'in arg_string:\n   return None\n   \n   \n   \n  return None ,arg_string,None\n  \n def _get_option_tuples(self,option_string):\n  result=[]\n  \n  \n  \n  chars=self.prefix_chars\n  if option_string[0]in chars and option_string[1]in chars:\n   if self.allow_abbrev:\n    if '='in option_string:\n     option_prefix,explicit_arg=option_string.split('=',1)\n    else :\n     option_prefix=option_string\n     explicit_arg=None\n    for option_string in self._option_string_actions:\n     if option_string.startswith(option_prefix):\n      action=self._option_string_actions[option_string]\n      tup=action,option_string,explicit_arg\n      result.append(tup)\n      \n      \n      \n      \n  elif option_string[0]in chars and option_string[1]not in chars:\n   option_prefix=option_string\n   explicit_arg=None\n   short_option_prefix=option_string[:2]\n   short_explicit_arg=option_string[2:]\n   \n   for option_string in self._option_string_actions:\n    if option_string ==short_option_prefix:\n     action=self._option_string_actions[option_string]\n     tup=action,option_string,short_explicit_arg\n     result.append(tup)\n    elif option_string.startswith(option_prefix):\n     action=self._option_string_actions[option_string]\n     tup=action,option_string,explicit_arg\n     result.append(tup)\n     \n     \n  else :\n   self.error(_('unexpected option string: %s')%option_string)\n   \n   \n  return result\n  \n def _get_nargs_pattern(self,action):\n \n \n  nargs=action.nargs\n  \n  \n  if nargs is None :\n   nargs_pattern='(-*A-*)'\n   \n   \n  elif nargs ==OPTIONAL:\n   nargs_pattern='(-*A?-*)'\n   \n   \n  elif nargs ==ZERO_OR_MORE:\n   nargs_pattern='(-*[A-]*)'\n   \n   \n  elif nargs ==ONE_OR_MORE:\n   nargs_pattern='(-*A[A-]*)'\n   \n   \n  elif nargs ==REMAINDER:\n   nargs_pattern='([-AO]*)'\n   \n   \n  elif nargs ==PARSER:\n   nargs_pattern='(-*A[-AO]*)'\n   \n   \n  elif nargs ==SUPPRESS:\n   nargs_pattern='(-*-*)'\n   \n   \n  else :\n   nargs_pattern='(-*%s-*)'%'-*'.join('A'*nargs)\n   \n   \n  if action.option_strings:\n   nargs_pattern=nargs_pattern.replace('-*','')\n   nargs_pattern=nargs_pattern.replace('-','')\n   \n   \n  return nargs_pattern\n  \n  \n  \n  \n  \n def parse_intermixed_args(self,args=None ,namespace=None ):\n  args,argv=self.parse_known_intermixed_args(args,namespace)\n  if argv:\n   msg=_('unrecognized arguments: %s')\n   self.error(msg %' '.join(argv))\n  return args\n  \n def parse_known_intermixed_args(self,args=None ,namespace=None ):\n \n \n \n \n \n \n \n \n \n \n \n \n  positionals=self._get_positional_actions()\n  a=[action for action in positionals\n  if action.nargs in [PARSER,REMAINDER]]\n  if a:\n   raise TypeError('parse_intermixed_args: positional arg'\n   ' with nargs=%s'%a[0].nargs)\n   \n  if [action.dest for group in self._mutually_exclusive_groups\n  for action in group._group_actions if action in positionals]:\n   raise TypeError('parse_intermixed_args: positional in'\n   ' mutuallyExclusiveGroup')\n   \n  try :\n   save_usage=self.usage\n   try :\n    if self.usage is None :\n    \n     self.usage=self.format_usage()[7:]\n    for action in positionals:\n    \n     action.save_nargs=action.nargs\n     \n     action.nargs=SUPPRESS\n     action.save_default=action.default\n     action.default=SUPPRESS\n    namespace,remaining_args=self.parse_known_args(args,\n    namespace)\n    for action in positionals:\n    \n     if (hasattr(namespace,action.dest)\n     and getattr(namespace,action.dest)==[]):\n      from warnings import warn\n      warn('Do not expect %s in %s'%(action.dest,namespace))\n      delattr(namespace,action.dest)\n   finally :\n   \n    for action in positionals:\n     action.nargs=action.save_nargs\n     action.default=action.save_default\n   optionals=self._get_optional_actions()\n   try :\n   \n   \n    for action in optionals:\n     action.save_required=action.required\n     action.required=False\n    for group in self._mutually_exclusive_groups:\n     group.save_required=group.required\n     group.required=False\n    namespace,extras=self.parse_known_args(remaining_args,\n    namespace)\n   finally :\n   \n    for action in optionals:\n     action.required=action.save_required\n    for group in self._mutually_exclusive_groups:\n     group.required=group.save_required\n  finally :\n   self.usage=save_usage\n  return namespace,extras\n  \n  \n  \n  \n def _get_values(self,action,arg_strings):\n \n  if action.nargs not in [PARSER,REMAINDER]:\n   try :\n    arg_strings.remove('--')\n   except ValueError:\n    pass\n    \n    \n  if not arg_strings and action.nargs ==OPTIONAL:\n   if action.option_strings:\n    value=action.const\n   else :\n    value=action.default\n   if isinstance(value,str):\n    value=self._get_value(action,value)\n    self._check_value(action,value)\n    \n    \n    \n  elif (not arg_strings and action.nargs ==ZERO_OR_MORE and\n  not action.option_strings):\n   if action.default is not None :\n    value=action.default\n   else :\n    value=arg_strings\n   self._check_value(action,value)\n   \n   \n  elif len(arg_strings)==1 and action.nargs in [None ,OPTIONAL]:\n   arg_string,=arg_strings\n   value=self._get_value(action,arg_string)\n   self._check_value(action,value)\n   \n   \n  elif action.nargs ==REMAINDER:\n   value=[self._get_value(action,v)for v in arg_strings]\n   \n   \n  elif action.nargs ==PARSER:\n   value=[self._get_value(action,v)for v in arg_strings]\n   self._check_value(action,value[0])\n   \n   \n  elif action.nargs ==SUPPRESS:\n   value=SUPPRESS\n   \n   \n  else :\n   value=[self._get_value(action,v)for v in arg_strings]\n   for v in value:\n    self._check_value(action,v)\n    \n    \n  return value\n  \n def _get_value(self,action,arg_string):\n  type_func=self._registry_get('type',action.type,action.type)\n  if not callable(type_func):\n   msg=_('%r is not callable')\n   raise ArgumentError(action,msg %type_func)\n   \n   \n  try :\n   result=type_func(arg_string)\n   \n   \n  except ArgumentTypeError:\n   name=getattr(action.type,'__name__',repr(action.type))\n   msg=str(_sys.exc_info()[1])\n   raise ArgumentError(action,msg)\n   \n   \n  except (TypeError,ValueError):\n   name=getattr(action.type,'__name__',repr(action.type))\n   args={'type':name,'value':arg_string}\n   msg=_('invalid %(type)s value: %(value)r')\n   raise ArgumentError(action,msg %args)\n   \n   \n  return result\n  \n def _check_value(self,action,value):\n \n  if action.choices is not None and value not in action.choices:\n   args={'value':value,\n   'choices':', '.join(map(repr,action.choices))}\n   msg=_('invalid choice: %(value)r (choose from %(choices)s)')\n   raise ArgumentError(action,msg %args)\n   \n   \n   \n   \n def format_usage(self):\n  formatter=self._get_formatter()\n  formatter.add_usage(self.usage,self._actions,\n  self._mutually_exclusive_groups)\n  return formatter.format_help()\n  \n def format_help(self):\n  formatter=self._get_formatter()\n  \n  \n  formatter.add_usage(self.usage,self._actions,\n  self._mutually_exclusive_groups)\n  \n  \n  formatter.add_text(self.description)\n  \n  \n  for action_group in self._action_groups:\n   formatter.start_section(action_group.title)\n   formatter.add_text(action_group.description)\n   formatter.add_arguments(action_group._group_actions)\n   formatter.end_section()\n   \n   \n  formatter.add_text(self.epilog)\n  \n  \n  return formatter.format_help()\n  \n def _get_formatter(self):\n  return self.formatter_class(prog=self.prog)\n  \n  \n  \n  \n def print_usage(self,file=None ):\n  if file is None :\n   file=_sys.stdout\n  self._print_message(self.format_usage(),file)\n  \n def print_help(self,file=None ):\n  if file is None :\n   file=_sys.stdout\n  self._print_message(self.format_help(),file)\n  \n def _print_message(self,message,file=None ):\n  if message:\n   if file is None :\n    file=_sys.stderr\n   file.write(message)\n   \n   \n   \n   \n def exit(self,status=0,message=None ):\n  if message:\n   self._print_message(message,_sys.stderr)\n  _sys.exit(status)\n  \n def error(self,message):\n  ''\n\n\n\n\n\n\n  \n  self.print_usage(_sys.stderr)\n  args={'prog':self.prog,'message':message}\n  self.exit(2,_('%(prog)s: error: %(message)s\\n')%args)\n", ["copy", "gettext", "os", "re", "shutil", "sys", "textwrap", "warnings"]], "ast": [".py", "''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nimport enum\nfrom contextlib import nullcontext\n\nclass AST(object):\n\n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass alias(AST):\n ''\n \n \n __match_args__=\"('name', 'asname')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('name', 'asname')\"\n \n asname=None\n \n end_col_offset=None\n \n end_lineno=None\n \nclass arg(AST):\n ''\n \n \n __match_args__=\"('arg', 'annotation', 'type_comment')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('arg', 'annotation', 'type_comment')\"\n \n annotation=None\n \n end_col_offset=None\n \n end_lineno=None\n \n type_comment=None\n \nclass arguments(AST):\n ''\n \n \n __match_args__=\"('posonlyargs', 'args', 'vararg', 'kwonlyargs', 'kw_defaults', 'kwarg', 'defaults')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"('posonlyargs', 'args', 'vararg', 'kwonlyargs', 'kw_defaults', 'kwarg', 'defaults')\"\n \n kwarg=None\n \n vararg=None\n \n \nclass operator(AST):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass boolop(AST):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass cmpop(AST):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass comprehension(AST):\n ''\n \n \n __match_args__=\"('target', 'iter', 'ifs', 'is_async')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"('target', 'iter', 'ifs', 'is_async')\"\n \nclass match_case(AST):\n ''\n \n \n __match_args__=\"('pattern', 'guard', 'body')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"('pattern', 'guard', 'body')\"\n \n guard=None\n \nclass mod(AST):\n ''\n\n\n \n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \n \nclass keyword(AST):\n ''\n \n \n __match_args__=\"('arg', 'value')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('arg', 'value')\"\n \n arg=None\n \n end_col_offset=None\n \n end_lineno=None\n \nclass pattern(AST):\n ''\n\n\n\n\n\n\n \n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"()\"\n \nclass slice(AST):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass stmt(AST):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"()\"\n \n end_col_offset=None\n \n end_lineno=None\nsys=\"<module 'sys' (built-in)>\"\n\n\nclass type_ignore(AST):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass unaryop(AST):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \n \nclass withitem(AST):\n ''\n \n \n __match_args__=\"('context_expr', 'optional_vars')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"('context_expr', 'optional_vars')\"\n \n optional_vars=None\n \nclass excepthandler(AST):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"()\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass expr(AST):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"()\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass expr_context(AST):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \n \nclass NodeVisitor(object):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n \n __module__=\"\"\"ast\"\"\"\n \n def generic_visit(*args,**kw):\n  ''\n  pass\n  \n def visit(*args,**kw):\n  ''\n  pass\n  \n def visit_Constant(*args,**kw):\n  pass\n  \nclass Add(operator):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass And(boolop):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass AnnAssign(stmt):\n ''\n \n \n __match_args__=\"('target', 'annotation', 'value', 'simple')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('target', 'annotation', 'value', 'simple')\"\n \n end_col_offset=None\n \n end_lineno=None\n \n value=None\n \nclass Assert(stmt):\n ''\n \n \n __match_args__=\"('test', 'msg')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('test', 'msg')\"\n \n end_col_offset=None\n \n end_lineno=None\n \n msg=None\n \nclass Assign(stmt):\n ''\n \n \n __match_args__=\"('targets', 'value', 'type_comment')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('targets', 'value', 'type_comment')\"\n \n end_col_offset=None\n \n end_lineno=None\n \n type_comment=None\n \nclass AsyncFor(stmt):\n ''\n \n \n __match_args__=\"('target', 'iter', 'body', 'orelse', 'type_comment')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('target', 'iter', 'body', 'orelse', 'type_comment')\"\n \n end_col_offset=None\n \n end_lineno=None\n \n type_comment=None\n \nclass AsyncFunctionDef(stmt):\n ''\n \n \n __match_args__=\"('name', 'args', 'body', 'decorator_list', 'returns', 'type_comment')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('name', 'args', 'body', 'decorator_list', 'returns', 'type_comment')\"\n \n end_col_offset=None\n \n end_lineno=None\n \n returns=None\n \n type_comment=None\n \nclass AsyncWith(stmt):\n ''\n \n \n __match_args__=\"('items', 'body', 'type_comment')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('items', 'body', 'type_comment')\"\n \n end_col_offset=None\n \n end_lineno=None\n \n type_comment=None\n \nclass Attribute(expr):\n ''\n \n \n __match_args__=\"('value', 'attr', 'ctx')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('value', 'attr', 'ctx')\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass AugAssign(stmt):\n ''\n \n \n __match_args__=\"('target', 'op', 'value')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('target', 'op', 'value')\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass AugLoad(expr_context):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass AugStore(expr_context):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass Await(expr):\n ''\n \n \n __match_args__=\"('value',)\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('value',)\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass BinOp(expr):\n ''\n \n \n __match_args__=\"('left', 'op', 'right')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('left', 'op', 'right')\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass BitAnd(operator):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass BitOr(operator):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass BitXor(operator):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass BoolOp(expr):\n ''\n \n \n __match_args__=\"('op', 'values')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('op', 'values')\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass Break(stmt):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"()\"\n \n end_col_offset=None\n \n end_lineno=None\n \n \nclass Constant(expr):\n ''\n \n \n __match_args__=\"('value', 'kind')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('value', 'kind')\"\n \n end_col_offset=None\n \n end_lineno=None\n \n kind=None\n \n n=\"<property object at 0x000001303F3F2D40>\"\n \n s=\"<property object at 0x000001303F7F6AC0>\"\n \nclass Bytes(Constant):\n ''\n \n \n __match_args__=\"('value', 'kind')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('s',)\"\n \n end_col_offset=None\n \n end_lineno=None\n \n kind=None\n \n n=\"<property object at 0x000001303F3F2D40>\"\n \n s=\"<property object at 0x000001303F7F6AC0>\"\n \nclass Call(expr):\n ''\n \n \n __match_args__=\"('func', 'args', 'keywords')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('func', 'args', 'keywords')\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass ClassDef(stmt):\n ''\n \n \n __match_args__=\"('name', 'bases', 'keywords', 'body', 'decorator_list')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('name', 'bases', 'keywords', 'body', 'decorator_list')\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass Compare(expr):\n ''\n \n \n __match_args__=\"('left', 'ops', 'comparators')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('left', 'ops', 'comparators')\"\n \n end_col_offset=None\n \n end_lineno=None\n \n \nclass Continue(stmt):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"()\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass Del(expr_context):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass Delete(stmt):\n ''\n \n \n __match_args__=\"('targets',)\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('targets',)\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass Dict(expr):\n ''\n \n \n __match_args__=\"('keys', 'values')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('keys', 'values')\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass DictComp(expr):\n ''\n \n \n __match_args__=\"('key', 'value', 'generators')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('key', 'value', 'generators')\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass Div(operator):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass Ellipsis(Constant):\n ''\n \n \n __match_args__=\"('value', 'kind')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"()\"\n \n end_col_offset=None\n \n end_lineno=None\n \n kind=None\n \n n=\"<property object at 0x000001303F3F2D40>\"\n \n s=\"<property object at 0x000001303F7F6AC0>\"\n \nclass Eq(cmpop):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass ExceptHandler(excepthandler):\n ''\n \n \n __match_args__=\"('type', 'name', 'body')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('type', 'name', 'body')\"\n \n end_col_offset=None\n \n end_lineno=None\n \n name=None\n \n type=None\n \nclass Expr(stmt):\n ''\n \n \n __match_args__=\"('value',)\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('value',)\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass Expression(mod):\n ''\n \n \n __match_args__=\"('body',)\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"('body',)\"\n \nclass ExtSlice(slice):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass FloorDiv(operator):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass For(stmt):\n ''\n \n \n __match_args__=\"('target', 'iter', 'body', 'orelse', 'type_comment')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('target', 'iter', 'body', 'orelse', 'type_comment')\"\n \n end_col_offset=None\n \n end_lineno=None\n \n type_comment=None\n \nclass FormattedValue(expr):\n ''\n \n \n __match_args__=\"('value', 'conversion', 'format_spec')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('value', 'conversion', 'format_spec')\"\n \n conversion=None\n \n end_col_offset=None\n \n end_lineno=None\n \n format_spec=None\n \nclass FunctionDef(stmt):\n ''\n \n \n __match_args__=\"('name', 'args', 'body', 'decorator_list', 'returns', 'type_comment')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('name', 'args', 'body', 'decorator_list', 'returns', 'type_comment')\"\n \n end_col_offset=None\n \n end_lineno=None\n \n returns=None\n \n type_comment=None\n \nclass FunctionType(mod):\n ''\n \n \n __match_args__=\"('argtypes', 'returns')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"('argtypes', 'returns')\"\n \nclass GeneratorExp(expr):\n ''\n \n \n __match_args__=\"('elt', 'generators')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('elt', 'generators')\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass Global(stmt):\n ''\n \n \n __match_args__=\"('names',)\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('names',)\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass Gt(cmpop):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass GtE(cmpop):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass If(stmt):\n ''\n \n \n __match_args__=\"('test', 'body', 'orelse')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('test', 'body', 'orelse')\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass IfExp(expr):\n ''\n \n \n __match_args__=\"('test', 'body', 'orelse')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('test', 'body', 'orelse')\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass Import(stmt):\n ''\n \n \n __match_args__=\"('names',)\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('names',)\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass ImportFrom(stmt):\n ''\n \n \n __match_args__=\"('module', 'names', 'level')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('module', 'names', 'level')\"\n \n end_col_offset=None\n \n end_lineno=None\n \n level=None\n \n module=None\n \nclass In(cmpop):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass Index(slice):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass IntEnum(int,enum.Enum):\n ''\n \n \n __module__=\"\"\"enum\"\"\"\n \nclass Interactive(mod):\n ''\n \n \n __match_args__=\"('body',)\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"('body',)\"\n \nclass Invert(unaryop):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass Is(cmpop):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass IsNot(cmpop):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass JoinedStr(expr):\n ''\n \n \n __match_args__=\"('values',)\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('values',)\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass LShift(operator):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass Lambda(expr):\n ''\n \n \n __match_args__=\"('args', 'body')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('args', 'body')\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass List(expr):\n ''\n \n \n __match_args__=\"('elts', 'ctx')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('elts', 'ctx')\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass ListComp(expr):\n ''\n \n \n __match_args__=\"('elt', 'generators')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('elt', 'generators')\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass Load(expr_context):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass Lt(cmpop):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass LtE(cmpop):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass MatMult(operator):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass Match(stmt):\n ''\n \n \n __match_args__=\"('subject', 'cases')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('subject', 'cases')\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass MatchAs(pattern):\n ''\n \n \n __match_args__=\"('pattern', 'name')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('pattern', 'name')\"\n \n name=None\n \n pattern=None\n \nclass MatchClass(pattern):\n ''\n \n \n __match_args__=\"('cls', 'patterns', 'kwd_attrs', 'kwd_patterns')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('cls', 'patterns', 'kwd_attrs', 'kwd_patterns')\"\n \nclass MatchMapping(pattern):\n ''\n \n \n __match_args__=\"('keys', 'patterns', 'rest')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('keys', 'patterns', 'rest')\"\n \n rest=None\n \nclass MatchOr(pattern):\n ''\n \n \n __match_args__=\"('patterns',)\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('patterns',)\"\n \nclass MatchSequence(pattern):\n ''\n \n \n __match_args__=\"('patterns',)\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('patterns',)\"\n \nclass MatchSingleton(pattern):\n ''\n \n \n __match_args__=\"('value',)\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('value',)\"\n \nclass MatchStar(pattern):\n ''\n \n \n __match_args__=\"('name',)\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('name',)\"\n \n name=None\n \nclass MatchValue(pattern):\n ''\n \n \n __match_args__=\"('value',)\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('value',)\"\n \nclass Mod(operator):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass Module(mod):\n ''\n \n \n __match_args__=\"('body', 'type_ignores')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"('body', 'type_ignores')\"\n \nclass Mult(operator):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass Name(expr):\n ''\n \n \n __match_args__=\"('id', 'ctx')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('id', 'ctx')\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass NameConstant(Constant):\n ''\n \n \n __match_args__=\"('value', 'kind')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('value', 'kind')\"\n \n end_col_offset=None\n \n end_lineno=None\n \n kind=None\n \n n=\"<property object at 0x000001303F3F2D40>\"\n \n s=\"<property object at 0x000001303F7F6AC0>\"\n \nclass NamedExpr(expr):\n ''\n \n \n __match_args__=\"('target', 'value')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('target', 'value')\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass NodeTransformer(NodeVisitor):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n \n __module__=\"\"\"ast\"\"\"\n \n def generic_visit(*args,**kw):\n  pass\n  \n def visit(*args,**kw):\n  ''\n  pass\n  \n def visit_Constant(*args,**kw):\n  pass\n  \n  \nclass Nonlocal(stmt):\n ''\n \n \n __match_args__=\"('names',)\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('names',)\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass Not(unaryop):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass NotEq(cmpop):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass NotIn(cmpop):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass Num(Constant):\n ''\n \n \n __match_args__=\"('value', 'kind')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('n',)\"\n \n end_col_offset=None\n \n end_lineno=None\n \n kind=None\n \n n=\"<property object at 0x000001303F3F2D40>\"\n \n s=\"<property object at 0x000001303F7F6AC0>\"\n \nclass Or(boolop):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass Param(expr_context):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass Pass(stmt):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"()\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass Pow(operator):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\nPyCF_ALLOW_TOP_LEVEL_AWAIT=8192\n\nPyCF_ONLY_AST=1024\n\nPyCF_TYPE_COMMENTS=4096\n\n\nclass RShift(operator):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass Raise(stmt):\n ''\n \n \n __match_args__=\"('exc', 'cause')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('exc', 'cause')\"\n \n cause=None\n \n end_col_offset=None\n \n end_lineno=None\n \n exc=None\n \nclass Return(stmt):\n ''\n \n \n __match_args__=\"('value',)\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('value',)\"\n \n end_col_offset=None\n \n end_lineno=None\n \n value=None\n \nclass Set(expr):\n ''\n \n \n __match_args__=\"('elts',)\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('elts',)\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass SetComp(expr):\n ''\n \n \n __match_args__=\"('elt', 'generators')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('elt', 'generators')\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass Slice(expr):\n ''\n \n \n __match_args__=\"('lower', 'upper', 'step')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('lower', 'upper', 'step')\"\n \n end_col_offset=None\n \n end_lineno=None\n \n lower=None\n \n step=None\n \n upper=None\n \nclass Starred(expr):\n ''\n \n \n __match_args__=\"('value', 'ctx')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('value', 'ctx')\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass Store(expr_context):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass Str(Constant):\n ''\n \n \n __match_args__=\"('value', 'kind')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('s',)\"\n \n end_col_offset=None\n \n end_lineno=None\n \n kind=None\n \n n=\"<property object at 0x000001303F3F2D40>\"\n \n s=\"<property object at 0x000001303F7F6AC0>\"\n \nclass Sub(operator):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass Subscript(expr):\n ''\n \n \n __match_args__=\"('value', 'slice', 'ctx')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('value', 'slice', 'ctx')\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass Suite(mod):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass Try(stmt):\n ''\n \n \n __match_args__=\"('body', 'handlers', 'orelse', 'finalbody')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('body', 'handlers', 'orelse', 'finalbody')\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass Tuple(expr):\n ''\n \n \n __match_args__=\"('elts', 'ctx')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('elts', 'ctx')\"\n \n dims=\"<property object at 0x000001303F7F7D80>\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass TypeIgnore(type_ignore):\n ''\n \n \n __match_args__=\"('lineno', 'tag')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"('lineno', 'tag')\"\n \nclass UAdd(unaryop):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass USub(unaryop):\n ''\n \n \n __match_args__=\"()\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"()\"\n \n _fields=\"()\"\n \nclass UnaryOp(expr):\n ''\n \n \n __match_args__=\"('op', 'operand')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('op', 'operand')\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass While(stmt):\n ''\n \n \n __match_args__=\"('test', 'body', 'orelse')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('test', 'body', 'orelse')\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass With(stmt):\n ''\n \n \n __match_args__=\"('items', 'body', 'type_comment')\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('items', 'body', 'type_comment')\"\n \n end_col_offset=None\n \n end_lineno=None\n \n type_comment=None\n \nclass Yield(expr):\n ''\n \n \n __match_args__=\"('value',)\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('value',)\"\n \n end_col_offset=None\n \n end_lineno=None\n \n value=None\n \nclass YieldFrom(expr):\n ''\n \n \n __match_args__=\"('value',)\"\n \n __module__=\"\"\"ast\"\"\"\n \n _attributes=\"('lineno', 'col_offset', 'end_lineno', 'end_col_offset')\"\n \n _fields=\"('value',)\"\n \n end_col_offset=None\n \n end_lineno=None\n \nclass _ABC(type):\n\n __module__=\"\"\"ast\"\"\"\n \n mro=\"<method 'mro' of 'type' objects>\"\n_ALL_QUOTES=\"(\\\"'\\\", '\\\"', '\\\"\\\"\\\"', \\\"'''\\\")\"\n\n_INFSTR=\"\"\"1e309\"\"\"\n\n_MULTI_QUOTES=\"('\\\"\\\"\\\"', \\\"'''\\\")\"\n\n\nclass _Precedence(IntEnum):\n ''\n \n \n AND=5\n \n ARITH=12\n \n ATOM=17\n \n AWAIT=16\n \n BAND=10\n \n BXOR=9\n \n CMP=7\n \n EXPR=8\n \n FACTOR=14\n \n NOT=6\n \n OR=4\n \n POWER=15\n \n SHIFT=11\n \n TERM=13\n \n TEST=3\n \n TUPLE=1\n \n YIELD=2\n \n __module__=\"\"\"ast\"\"\"\n_SINGLE_QUOTES=\"(\\\"'\\\", '\\\"')\"\n\n\nclass _Unparser(NodeVisitor):\n ''\n\n \n \n \n __module__=\"\"\"ast\"\"\"\n \n def _for_helper(*args,**kw):\n  pass\n  \n def _fstring_Constant(*args,**kw):\n  pass\n  \n def _fstring_FormattedValue(*args,**kw):\n  pass\n  \n def _fstring_JoinedStr(*args,**kw):\n  pass\n  \n def _function_helper(*args,**kw):\n  pass\n  \n def _str_literal_helper(*args,**kw):\n  ''\n  \n  pass\n  \n def _write_constant(*args,**kw):\n  pass\n  \n def _write_docstring(*args,**kw):\n  pass\n  \n def _write_docstring_and_traverse_body(*args,**kw):\n  pass\n  \n def _write_str_avoiding_backslashes(*args,**kw):\n  ''\n  pass\n  \n binop={'Add':'+','Sub':'-','Mult':'*','MatMult':'@','Div':'/','Mod':'%','LShift':'<<','RShift':'>>','BitOr':'|','BitXor':'^','BitAnd':'&','FloorDiv':'//','Pow':'**'}\n \n binop_precedence={'+':12,'-':12,'*':13,'@':13,'/':13,'%':13,'<<':11,'>>':11,'|':8,'^':9,'&':10,'//':13,'**':15}\n \n binop_rassoc=\"frozenset({'**'})\"\n \n def block(*args,**kw):\n  ''\n\n\n  \n  pass\n  \n boolop_precedence={'and':5,'or':4}\n \n boolops={'And':'and','Or':'or'}\n \n buffer=\"<property object at 0x000001303F818090>\"\n \n def buffer_writer(*args,**kw):\n  pass\n  \n cmpops={'Eq':'==','NotEq':'!=','Lt':'<','LtE':'<=','Gt':'>','GtE':'>=','Is':'is','IsNot':'is not','In':'in','NotIn':'not in'}\n \n def delimit(*args,**kw):\n  ''\n  pass\n  \n def delimit_if(*args,**kw):\n  pass\n  \n def fill(*args,**kw):\n  ''\n  pass\n  \n def generic_visit(*args,**kw):\n  ''\n  pass\n  \n def get_precedence(*args,**kw):\n  pass\n  \n def get_raw_docstring(*args,**kw):\n  ''\n\n  \n  pass\n  \n def get_type_comment(*args,**kw):\n  pass\n  \n def interleave(*args,**kw):\n  ''\n  pass\n  \n def items_view(*args,**kw):\n  ''\n  \n  pass\n  \n def maybe_newline(*args,**kw):\n  ''\n  pass\n  \n def require_parens(*args,**kw):\n  ''\n  pass\n  \n def set_precedence(*args,**kw):\n  pass\n  \n def traverse(*args,**kw):\n  pass\n  \n unop={'Invert':'~','Not':'not','UAdd':'+','USub':'-'}\n \n unop_precedence={'not':6,'~':14,'+':14,'-':14}\n \n def visit(*args,**kw):\n  ''\n  pass\n  \n def visit_AnnAssign(*args,**kw):\n  pass\n  \n def visit_Assert(*args,**kw):\n  pass\n  \n def visit_Assign(*args,**kw):\n  pass\n  \n def visit_AsyncFor(*args,**kw):\n  pass\n  \n def visit_AsyncFunctionDef(*args,**kw):\n  pass\n  \n def visit_AsyncWith(*args,**kw):\n  pass\n  \n def visit_Attribute(*args,**kw):\n  pass\n  \n def visit_AugAssign(*args,**kw):\n  pass\n  \n def visit_Await(*args,**kw):\n  pass\n  \n def visit_BinOp(*args,**kw):\n  pass\n  \n def visit_BoolOp(*args,**kw):\n  pass\n  \n def visit_Break(*args,**kw):\n  pass\n  \n def visit_Call(*args,**kw):\n  pass\n  \n def visit_ClassDef(*args,**kw):\n  pass\n  \n def visit_Compare(*args,**kw):\n  pass\n  \n def visit_Constant(*args,**kw):\n  pass\n  \n def visit_Continue(*args,**kw):\n  pass\n  \n def visit_Delete(*args,**kw):\n  pass\n  \n def visit_Dict(*args,**kw):\n  pass\n  \n def visit_DictComp(*args,**kw):\n  pass\n  \n def visit_Ellipsis(*args,**kw):\n  pass\n  \n def visit_ExceptHandler(*args,**kw):\n  pass\n  \n def visit_Expr(*args,**kw):\n  pass\n  \n def visit_For(*args,**kw):\n  pass\n  \n def visit_FormattedValue(*args,**kw):\n  pass\n  \n def visit_FunctionDef(*args,**kw):\n  pass\n  \n def visit_FunctionType(*args,**kw):\n  pass\n  \n def visit_GeneratorExp(*args,**kw):\n  pass\n  \n def visit_Global(*args,**kw):\n  pass\n  \n def visit_If(*args,**kw):\n  pass\n  \n def visit_IfExp(*args,**kw):\n  pass\n  \n def visit_Import(*args,**kw):\n  pass\n  \n def visit_ImportFrom(*args,**kw):\n  pass\n  \n def visit_JoinedStr(*args,**kw):\n  pass\n  \n def visit_Lambda(*args,**kw):\n  pass\n  \n def visit_List(*args,**kw):\n  pass\n  \n def visit_ListComp(*args,**kw):\n  pass\n  \n def visit_Match(*args,**kw):\n  pass\n  \n def visit_MatchAs(*args,**kw):\n  pass\n  \n def visit_MatchClass(*args,**kw):\n  pass\n  \n def visit_MatchMapping(*args,**kw):\n  pass\n  \n def visit_MatchOr(*args,**kw):\n  pass\n  \n def visit_MatchSequence(*args,**kw):\n  pass\n  \n def visit_MatchSingleton(*args,**kw):\n  pass\n  \n def visit_MatchStar(*args,**kw):\n  pass\n  \n def visit_MatchValue(*args,**kw):\n  pass\n  \n def visit_Module(*args,**kw):\n  pass\n  \n def visit_Name(*args,**kw):\n  pass\n  \n def visit_NamedExpr(*args,**kw):\n  pass\n  \n def visit_Nonlocal(*args,**kw):\n  pass\n  \n def visit_Pass(*args,**kw):\n  pass\n  \n def visit_Raise(*args,**kw):\n  pass\n  \n def visit_Return(*args,**kw):\n  pass\n  \n def visit_Set(*args,**kw):\n  pass\n  \n def visit_SetComp(*args,**kw):\n  pass\n  \n def visit_Slice(*args,**kw):\n  pass\n  \n def visit_Starred(*args,**kw):\n  pass\n  \n def visit_Subscript(*args,**kw):\n  pass\n  \n def visit_Try(*args,**kw):\n  pass\n  \n def visit_Tuple(*args,**kw):\n  pass\n  \n def visit_UnaryOp(*args,**kw):\n  pass\n  \n def visit_While(*args,**kw):\n  pass\n  \n def visit_With(*args,**kw):\n  pass\n  \n def visit_Yield(*args,**kw):\n  pass\n  \n def visit_YieldFrom(*args,**kw):\n  pass\n  \n def visit_alias(*args,**kw):\n  pass\n  \n def visit_arg(*args,**kw):\n  pass\n  \n def visit_arguments(*args,**kw):\n  pass\n  \n def visit_comprehension(*args,**kw):\n  pass\n  \n def visit_keyword(*args,**kw):\n  pass\n  \n def visit_match_case(*args,**kw):\n  pass\n  \n def visit_withitem(*args,**kw):\n  pass\n  \n def write(*args,**kw):\n  ''\n  pass\n  \nNoneType=type(None )\nellipsis=type(...)\n\n_const_node_type_names={bool:'NameConstant',type(None ):'NameConstant',int:'Num',float:'Num',complex:'Num',str:'Str',bytes:'Bytes',type('...'):'Ellipsis'}\n\n_const_types={Num:(int,float,complex),Str:(str,),Bytes:(bytes,),NameConstant:(NoneType,bool),Ellipsis:(ellipsis,)}\n\n_const_types_not={Num:(bool,)}\n\ndef _dims_getter(*args,**kw):\n ''\n pass\n \ndef _dims_setter(*args,**kw):\n pass\n \ndef _getter(*args,**kw):\n ''\n pass\n \ndef _new(*args,**kw):\n pass\n \ndef _pad_whitespace(*args,**kw):\n ''\n pass\n \ndef _setter(*args,**kw):\n pass\n \ndef _splitlines_no_ff(*args,**kw):\n ''\n\n \n pass\n \n \nclass auto(object):\n ''\n\n \n \n \n __module__=\"\"\"enum\"\"\"\n \n value=\"<object object at 0x000001303EEB46F0>\"\n \n \ndef contextmanager(*args,**kw):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n pass\n \ndef copy_location(*args,**kw):\n ''\n\n \n pass\n \ndef dump(*args,**kw):\n ''\n\n\n\n\n\n\n\n\n \n pass\n \n \ndef fix_missing_locations(*args,**kw):\n ''\n\n\n\n\n \n pass\n \ndef get_docstring(*args,**kw):\n ''\n\n\n\n\n\n \n pass\n \ndef get_source_segment(*args,**kw):\n ''\n\n\n\n\n\n \n pass\n \ndef increment_lineno(*args,**kw):\n ''\n\n\n \n pass\n \ndef iter_child_nodes(*args,**kw):\n ''\n\n \n pass\n \ndef iter_fields(*args,**kw):\n ''\n\n \n pass\n \n \ndef literal_eval(*args,**kw):\n ''\n\n\n\n \n pass\n \ndef main(*args,**kw):\n pass\n \n \ndef parse(*args,**kw):\n ''\n\n\n \n pass\n \n \ndef unparse(*args,**kw):\n pass\n \ndef walk(*args,**kw):\n ''\n\n\n \n pass\n \n", ["contextlib", "enum"]], "atexit": [".py", "''\n\n\n\n\n\nclass __loader__(object):\n pass\n \ndef _clear(*args,**kw):\n ''\n \n pass\n \ndef _run_exitfuncs(*args,**kw):\n ''\n \n pass\n \ndef register(*args,**kw):\n ''\n\n\n\n\n\n\n \n pass\n \ndef unregister(*args,**kw):\n ''\n\n\n\n \n pass\n", []], "base64": [".py", "#! /usr/bin/env python3\n\n\"\"\"Base16, Base32, Base64 (RFC 3548), Base85 and Ascii85 data encodings\"\"\"\n\n\n\n\n\nimport re\nimport struct\nimport binascii\n\n\n__all__=[\n\n'encode','decode','encodebytes','decodebytes',\n\n'b64encode','b64decode','b32encode','b32decode',\n'b32hexencode','b32hexdecode','b16encode','b16decode',\n\n'b85encode','b85decode','a85encode','a85decode',\n\n'standard_b64encode','standard_b64decode',\n\n\n\n\n'urlsafe_b64encode','urlsafe_b64decode',\n]\n\n\nbytes_types=(bytes,bytearray)\n\ndef _bytes_from_decode_data(s):\n if isinstance(s,str):\n  try :\n   return s.encode('ascii')\n  except UnicodeEncodeError:\n   raise ValueError('string argument should contain only ASCII characters')\n if isinstance(s,bytes_types):\n  return s\n try :\n  return memoryview(s).tobytes()\n except TypeError:\n  raise TypeError(\"argument should be a bytes-like object or ASCII \"\n  \"string, not %r\"%s.__class__.__name__)from None\n  \n  \n  \n  \ndef b64encode(s,altchars=None ):\n ''\n\n\n\n\n \n encoded=binascii.b2a_base64(s,newline=False )\n if altchars is not None :\n  assert len(altchars)==2,repr(altchars)\n  return encoded.translate(bytes.maketrans(b'+/',altchars))\n return encoded\n \n \ndef b64decode(s,altchars=None ,validate=False ):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n \n s=_bytes_from_decode_data(s)\n if altchars is not None :\n  altchars=_bytes_from_decode_data(altchars)\n  assert len(altchars)==2,repr(altchars)\n  s=s.translate(bytes.maketrans(altchars,b'+/'))\n if validate and not re.fullmatch(b'[A-Za-z0-9+/]*={0,2}',s):\n  raise binascii.Error('Non-base64 digit found')\n return binascii.a2b_base64(s)\n \n \ndef standard_b64encode(s):\n ''\n\n\n \n return b64encode(s)\n \ndef standard_b64decode(s):\n ''\n\n\n\n\n\n \n return b64decode(s)\n \n \n_urlsafe_encode_translation=bytes.maketrans(b'+/',b'-_')\n_urlsafe_decode_translation=bytes.maketrans(b'-_',b'+/')\n\ndef urlsafe_b64encode(s):\n ''\n\n\n\n\n \n return b64encode(s).translate(_urlsafe_encode_translation)\n \ndef urlsafe_b64decode(s):\n ''\n\n\n\n\n\n\n\n\n \n s=_bytes_from_decode_data(s)\n s=s.translate(_urlsafe_decode_translation)\n return b64decode(s)\n \n \n \n \n_B32_ENCODE_DOCSTRING='''\nEncode the bytes-like objects using {encoding} and return a bytes object.\n'''\n_B32_DECODE_DOCSTRING='''\nDecode the {encoding} encoded bytes-like object or ASCII string s.\n\nOptional casefold is a flag specifying whether a lowercase alphabet is\nacceptable as input.  For security purposes, the default is False.\n{extra_args}\nThe result is returned as a bytes object.  A binascii.Error is raised if\nthe input is incorrectly padded or if there are non-alphabet\ncharacters present in the input.\n'''\n_B32_DECODE_MAP01_DOCSTRING='''\nRFC 3548 allows for optional mapping of the digit 0 (zero) to the\nletter O (oh), and for optional mapping of the digit 1 (one) to\neither the letter I (eye) or letter L (el).  The optional argument\nmap01 when not None, specifies which letter the digit 1 should be\nmapped to (when map01 is not None, the digit 0 is always mapped to\nthe letter O).  For security purposes the default is None, so that\n0 and 1 are not allowed in the input.\n'''\n_b32alphabet=b'ABCDEFGHIJKLMNOPQRSTUVWXYZ234567'\n_b32hexalphabet=b'0123456789ABCDEFGHIJKLMNOPQRSTUV'\n_b32tab2={}\n_b32rev={}\n\ndef _b32encode(alphabet,s):\n global _b32tab2\n \n \n if alphabet not in _b32tab2:\n  b32tab=[bytes((i,))for i in alphabet]\n  _b32tab2[alphabet]=[a+b for a in b32tab for b in b32tab]\n  b32tab=None\n  \n if not isinstance(s,bytes_types):\n  s=memoryview(s).tobytes()\n leftover=len(s)%5\n \n if leftover:\n  s=s+b'\\0'*(5 -leftover)\n encoded=bytearray()\n from_bytes=int.from_bytes\n b32tab2=_b32tab2[alphabet]\n for i in range(0,len(s),5):\n  c=from_bytes(s[i:i+5],'big')\n  encoded +=(b32tab2[c >>30]+\n  b32tab2[(c >>20)&0x3ff]+\n  b32tab2[(c >>10)&0x3ff]+\n  b32tab2[c&0x3ff]\n  )\n  \n if leftover ==1:\n  encoded[-6:]=b'======'\n elif leftover ==2:\n  encoded[-4:]=b'===='\n elif leftover ==3:\n  encoded[-3:]=b'==='\n elif leftover ==4:\n  encoded[-1:]=b'='\n return bytes(encoded)\n \ndef _b32decode(alphabet,s,casefold=False ,map01=None ):\n global _b32rev\n \n \n if alphabet not in _b32rev:\n  _b32rev[alphabet]={v:k for k,v in enumerate(alphabet)}\n s=_bytes_from_decode_data(s)\n if len(s)%8:\n  raise binascii.Error('Incorrect padding')\n  \n  \n  \n if map01 is not None :\n  map01=_bytes_from_decode_data(map01)\n  assert len(map01)==1,repr(map01)\n  s=s.translate(bytes.maketrans(b'01',b'O'+map01))\n if casefold:\n  s=s.upper()\n  \n  \n  \n l=len(s)\n s=s.rstrip(b'=')\n padchars=l -len(s)\n \n decoded=bytearray()\n b32rev=_b32rev[alphabet]\n for i in range(0,len(s),8):\n  quanta=s[i:i+8]\n  acc=0\n  try :\n   for c in quanta:\n    acc=(acc <<5)+b32rev[c]\n  except KeyError:\n   raise binascii.Error('Non-base32 digit found')from None\n  decoded +=acc.to_bytes(5,'big')\n  \n if l %8 or padchars not in {0,1,3,4,6}:\n  raise binascii.Error('Incorrect padding')\n if padchars and decoded:\n  acc <<=5 *padchars\n  last=acc.to_bytes(5,'big')\n  leftover=(43 -5 *padchars)//8\n  decoded[-5:]=last[:leftover]\n return bytes(decoded)\n \n \ndef b32encode(s):\n return _b32encode(_b32alphabet,s)\nb32encode.__doc__=_B32_ENCODE_DOCSTRING.format(encoding='base32')\n\ndef b32decode(s,casefold=False ,map01=None ):\n return _b32decode(_b32alphabet,s,casefold,map01)\nb32decode.__doc__=_B32_DECODE_DOCSTRING.format(encoding='base32',\nextra_args=_B32_DECODE_MAP01_DOCSTRING)\n\ndef b32hexencode(s):\n return _b32encode(_b32hexalphabet,s)\nb32hexencode.__doc__=_B32_ENCODE_DOCSTRING.format(encoding='base32hex')\n\ndef b32hexdecode(s,casefold=False ):\n\n return _b32decode(_b32hexalphabet,s,casefold)\nb32hexdecode.__doc__=_B32_DECODE_DOCSTRING.format(encoding='base32hex',\nextra_args='')\n\n\n\n\n\ndef b16encode(s):\n ''\n \n return binascii.hexlify(s).upper()\n \n \ndef b16decode(s,casefold=False ):\n ''\n\n\n\n\n\n\n\n \n s=_bytes_from_decode_data(s)\n if casefold:\n  s=s.upper()\n if re.search(b'[^0-9A-F]',s):\n  raise binascii.Error('Non-base16 digit found')\n return binascii.unhexlify(s)\n \n \n \n \n \n_a85chars=None\n_a85chars2=None\n_A85START=b\"<~\"\n_A85END=b\"~>\"\n\ndef _85encode(b,chars,chars2,pad=False ,foldnuls=False ,foldspaces=False ):\n\n if not isinstance(b,bytes_types):\n  b=memoryview(b).tobytes()\n  \n padding=(-len(b))%4\n if padding:\n  b=b+b'\\0'*padding\n words=struct.Struct('!%dI'%(len(b)//4)).unpack(b)\n \n chunks=[b'z'if foldnuls and not word else\n b'y'if foldspaces and word ==0x20202020 else\n (chars2[word //614125]+\n chars2[word //85 %7225]+\n chars[word %85])\n for word in words]\n \n if padding and not pad:\n  if chunks[-1]==b'z':\n   chunks[-1]=chars[0]*5\n  chunks[-1]=chunks[-1][:-padding]\n  \n return b''.join(chunks)\n \ndef a85encode(b,*,foldspaces=False ,wrapcol=0,pad=False ,adobe=False ):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n global _a85chars,_a85chars2\n \n \n if _a85chars2 is None :\n  _a85chars=[bytes((i,))for i in range(33,118)]\n  _a85chars2=[(a+b)for a in _a85chars for b in _a85chars]\n  \n result=_85encode(b,_a85chars,_a85chars2,pad,True ,foldspaces)\n \n if adobe:\n  result=_A85START+result\n if wrapcol:\n  wrapcol=max(2 if adobe else 1,wrapcol)\n  chunks=[result[i:i+wrapcol]\n  for i in range(0,len(result),wrapcol)]\n  if adobe:\n   if len(chunks[-1])+2 >wrapcol:\n    chunks.append(b'')\n  result=b'\\n'.join(chunks)\n if adobe:\n  result +=_A85END\n  \n return result\n \ndef a85decode(b,*,foldspaces=False ,adobe=False ,ignorechars=b' \\t\\n\\r\\v'):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n b=_bytes_from_decode_data(b)\n if adobe:\n  if not b.endswith(_A85END):\n   raise ValueError(\n   \"Ascii85 encoded byte sequences must end \"\n   \"with {!r}\".format(_A85END)\n   )\n  if b.startswith(_A85START):\n   b=b[2:-2]\n  else :\n   b=b[:-2]\n   \n   \n   \n   \n packI=struct.Struct('!I').pack\n decoded=[]\n decoded_append=decoded.append\n curr=[]\n curr_append=curr.append\n curr_clear=curr.clear\n for x in b+b'u'*4:\n  if b'!'[0]<=x <=b'u'[0]:\n   curr_append(x)\n   if len(curr)==5:\n    acc=0\n    for x in curr:\n     acc=85 *acc+(x -33)\n    try :\n     decoded_append(packI(acc))\n    except struct.error:\n     raise ValueError('Ascii85 overflow')from None\n    curr_clear()\n  elif x ==b'z'[0]:\n   if curr:\n    raise ValueError('z inside Ascii85 5-tuple')\n   decoded_append(b'\\0\\0\\0\\0')\n  elif foldspaces and x ==b'y'[0]:\n   if curr:\n    raise ValueError('y inside Ascii85 5-tuple')\n   decoded_append(b'\\x20\\x20\\x20\\x20')\n  elif x in ignorechars:\n  \n   continue\n  else :\n   raise ValueError('Non-Ascii85 digit found: %c'%x)\n   \n result=b''.join(decoded)\n padding=4 -len(curr)\n if padding:\n \n  result=result[:-padding]\n return result\n \n \n \n_b85alphabet=(b\"0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ\"\nb\"abcdefghijklmnopqrstuvwxyz!#$%&()*+-;<=>?@^_`{|}~\")\n_b85chars=None\n_b85chars2=None\n_b85dec=None\n\ndef b85encode(b,pad=False ):\n ''\n\n\n\n \n global _b85chars,_b85chars2\n \n \n if _b85chars2 is None :\n  _b85chars=[bytes((i,))for i in _b85alphabet]\n  _b85chars2=[(a+b)for a in _b85chars for b in _b85chars]\n return _85encode(b,_b85chars,_b85chars2,pad)\n \ndef b85decode(b):\n ''\n\n\n \n global _b85dec\n \n \n if _b85dec is None :\n  _b85dec=[None ]*256\n  for i,c in enumerate(_b85alphabet):\n   _b85dec[c]=i\n   \n b=_bytes_from_decode_data(b)\n padding=(-len(b))%5\n b=b+b'~'*padding\n out=[]\n packI=struct.Struct('!I').pack\n for i in range(0,len(b),5):\n  chunk=b[i:i+5]\n  acc=0\n  try :\n   for c in chunk:\n    acc=acc *85+_b85dec[c]\n  except TypeError:\n   for j,c in enumerate(chunk):\n    if _b85dec[c]is None :\n     raise ValueError('bad base85 character at position %d'\n     %(i+j))from None\n   raise\n  try :\n   out.append(packI(acc))\n  except struct.error:\n   raise ValueError('base85 overflow in hunk starting at byte %d'\n   %i)from None\n   \n result=b''.join(out)\n if padding:\n  result=result[:-padding]\n return result\n \n \n \n \n \nMAXLINESIZE=76\nMAXBINSIZE=(MAXLINESIZE //4)*3\n\ndef encode(input,output):\n ''\n while True :\n  s=input.read(MAXBINSIZE)\n  if not s:\n   break\n  while len(s)<MAXBINSIZE:\n   ns=input.read(MAXBINSIZE -len(s))\n   if not ns:\n    break\n   s +=ns\n  line=binascii.b2a_base64(s)\n  output.write(line)\n  \n  \ndef decode(input,output):\n ''\n while True :\n  line=input.readline()\n  if not line:\n   break\n  s=binascii.a2b_base64(line)\n  output.write(s)\n  \ndef _input_type_check(s):\n try :\n  m=memoryview(s)\n except TypeError as err:\n  msg=\"expected bytes-like object, not %s\"%s.__class__.__name__\n  raise TypeError(msg)from err\n if m.format not in ('c','b','B'):\n  msg=(\"expected single byte elements, not %r from %s\"%\n  (m.format,s.__class__.__name__))\n  raise TypeError(msg)\n if m.ndim !=1:\n  msg=(\"expected 1-D data, not %d-D data from %s\"%\n  (m.ndim,s.__class__.__name__))\n  raise TypeError(msg)\n  \n  \ndef encodebytes(s):\n ''\n \n _input_type_check(s)\n pieces=[]\n for i in range(0,len(s),MAXBINSIZE):\n  chunk=s[i:i+MAXBINSIZE]\n  pieces.append(binascii.b2a_base64(chunk))\n return b\"\".join(pieces)\n \n \ndef decodebytes(s):\n ''\n _input_type_check(s)\n return binascii.a2b_base64(s)\n \n \n \ndef main():\n ''\n import sys,getopt\n try :\n  opts,args=getopt.getopt(sys.argv[1:],'deut')\n except getopt.error as msg:\n  sys.stdout=sys.stderr\n  print(msg)\n  print(\"\"\"usage: %s [-d|-e|-u|-t] [file|-]\n        -d, -u: decode\n        -e: encode (default)\n        -t: encode and decode string 'Aladdin:open sesame'\"\"\"%sys.argv[0])\n  sys.exit(2)\n func=encode\n for o,a in opts:\n  if o =='-e':func=encode\n  if o =='-d':func=decode\n  if o =='-u':func=decode\n  if o =='-t':test();return\n if args and args[0]!='-':\n  with open(args[0],'rb')as f:\n   func(f,sys.stdout.buffer)\n else :\n  func(sys.stdin.buffer,sys.stdout.buffer)\n  \n  \ndef test():\n s0=b\"Aladdin:open sesame\"\n print(repr(s0))\n s1=encodebytes(s0)\n print(repr(s1))\n s2=decodebytes(s1)\n print(repr(s2))\n assert s0 ==s2\n \n \nif __name__ =='__main__':\n main()\n", ["binascii", "getopt", "re", "struct", "sys"]], "bdb": [".py", "''\n\nimport fnmatch\nimport sys\nimport os\nfrom inspect import CO_GENERATOR,CO_COROUTINE,CO_ASYNC_GENERATOR\n\n__all__=[\"BdbQuit\",\"Bdb\",\"Breakpoint\"]\n\nGENERATOR_AND_COROUTINE_FLAGS=CO_GENERATOR |CO_COROUTINE |CO_ASYNC_GENERATOR\n\n\nclass BdbQuit(Exception):\n ''\n \n \nclass Bdb:\n ''\n\n\n\n\n\n\n\n\n\n\n \n \n def __init__(self,skip=None ):\n  self.skip=set(skip)if skip else None\n  self.breaks={}\n  self.fncache={}\n  self.frame_returning=None\n  \n  self._load_breaks()\n  \n def canonic(self,filename):\n  ''\n\n\n\n\n\n  \n  if filename ==\"<\"+filename[1:-1]+\">\":\n   return filename\n  canonic=self.fncache.get(filename)\n  if not canonic:\n   canonic=os.path.abspath(filename)\n   canonic=os.path.normcase(canonic)\n   self.fncache[filename]=canonic\n  return canonic\n  \n def reset(self):\n  ''\n  import linecache\n  linecache.checkcache()\n  self.botframe=None\n  self._set_stopinfo(None ,None )\n  \n def trace_dispatch(self,frame,event,arg):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  if self.quitting:\n   return\n  if event =='line':\n   return self.dispatch_line(frame)\n  if event =='call':\n   return self.dispatch_call(frame,arg)\n  if event =='return':\n   return self.dispatch_return(frame,arg)\n  if event =='exception':\n   return self.dispatch_exception(frame,arg)\n  if event =='c_call':\n   return self.trace_dispatch\n  if event =='c_exception':\n   return self.trace_dispatch\n  if event =='c_return':\n   return self.trace_dispatch\n  print('bdb.Bdb.dispatch: unknown debugging event:',repr(event))\n  return self.trace_dispatch\n  \n def dispatch_line(self,frame):\n  ''\n\n\n\n\n  \n  if self.stop_here(frame)or self.break_here(frame):\n   self.user_line(frame)\n   if self.quitting:raise BdbQuit\n  return self.trace_dispatch\n  \n def dispatch_call(self,frame,arg):\n  ''\n\n\n\n\n  \n  \n  if self.botframe is None :\n  \n   self.botframe=frame.f_back\n   return self.trace_dispatch\n  if not (self.stop_here(frame)or self.break_anywhere(frame)):\n  \n   return\n   \n  if self.stopframe and frame.f_code.co_flags&GENERATOR_AND_COROUTINE_FLAGS:\n   return self.trace_dispatch\n  self.user_call(frame,arg)\n  if self.quitting:raise BdbQuit\n  return self.trace_dispatch\n  \n def dispatch_return(self,frame,arg):\n  ''\n\n\n\n\n  \n  if self.stop_here(frame)or frame ==self.returnframe:\n  \n   if self.stopframe and frame.f_code.co_flags&GENERATOR_AND_COROUTINE_FLAGS:\n    return self.trace_dispatch\n   try :\n    self.frame_returning=frame\n    self.user_return(frame,arg)\n   finally :\n    self.frame_returning=None\n   if self.quitting:raise BdbQuit\n   \n   if self.stopframe is frame and self.stoplineno !=-1:\n    self._set_stopinfo(None ,None )\n  return self.trace_dispatch\n  \n def dispatch_exception(self,frame,arg):\n  ''\n\n\n\n\n  \n  if self.stop_here(frame):\n  \n  \n  \n   if not (frame.f_code.co_flags&GENERATOR_AND_COROUTINE_FLAGS\n   and arg[0]is StopIteration and arg[2]is None ):\n    self.user_exception(frame,arg)\n    if self.quitting:raise BdbQuit\n    \n    \n    \n    \n  elif (self.stopframe and frame is not self.stopframe\n  and self.stopframe.f_code.co_flags&GENERATOR_AND_COROUTINE_FLAGS\n  and arg[0]in (StopIteration,GeneratorExit)):\n   self.user_exception(frame,arg)\n   if self.quitting:raise BdbQuit\n   \n  return self.trace_dispatch\n  \n  \n  \n  \n  \n def is_skipped_module(self,module_name):\n  ''\n  if module_name is None :\n   return False\n  for pattern in self.skip:\n   if fnmatch.fnmatch(module_name,pattern):\n    return True\n  return False\n  \n def stop_here(self,frame):\n  ''\n  \n  \n  if self.skip and\\\n  self.is_skipped_module(frame.f_globals.get('__name__')):\n   return False\n  if frame is self.stopframe:\n   if self.stoplineno ==-1:\n    return False\n   return frame.f_lineno >=self.stoplineno\n  if not self.stopframe:\n   return True\n  return False\n  \n def break_here(self,frame):\n  ''\n\n\n\n  \n  filename=self.canonic(frame.f_code.co_filename)\n  if filename not in self.breaks:\n   return False\n  lineno=frame.f_lineno\n  if lineno not in self.breaks[filename]:\n  \n  \n   lineno=frame.f_code.co_firstlineno\n   if lineno not in self.breaks[filename]:\n    return False\n    \n    \n  (bp,flag)=effective(filename,lineno,frame)\n  if bp:\n   self.currentbp=bp.number\n   if (flag and bp.temporary):\n    self.do_clear(str(bp.number))\n   return True\n  else :\n   return False\n   \n def do_clear(self,arg):\n  ''\n\n\n  \n  raise NotImplementedError(\"subclass of bdb must implement do_clear()\")\n  \n def break_anywhere(self,frame):\n  ''\n  \n  return self.canonic(frame.f_code.co_filename)in self.breaks\n  \n  \n  \n  \n def user_call(self,frame,argument_list):\n  ''\n  pass\n  \n def user_line(self,frame):\n  ''\n  pass\n  \n def user_return(self,frame,return_value):\n  ''\n  pass\n  \n def user_exception(self,frame,exc_info):\n  ''\n  pass\n  \n def _set_stopinfo(self,stopframe,returnframe,stoplineno=0):\n  ''\n\n\n\n\n  \n  self.stopframe=stopframe\n  self.returnframe=returnframe\n  self.quitting=False\n  \n  \n  self.stoplineno=stoplineno\n  \n  \n  \n  \n def set_until(self,frame,lineno=None ):\n  ''\n  \n  \n  if lineno is None :\n   lineno=frame.f_lineno+1\n  self._set_stopinfo(frame,frame,lineno)\n  \n def set_step(self):\n  ''\n  \n  \n  \n  \n  if self.frame_returning:\n   caller_frame=self.frame_returning.f_back\n   if caller_frame and not caller_frame.f_trace:\n    caller_frame.f_trace=self.trace_dispatch\n  self._set_stopinfo(None ,None )\n  \n def set_next(self,frame):\n  ''\n  self._set_stopinfo(frame,None )\n  \n def set_return(self,frame):\n  ''\n  if frame.f_code.co_flags&GENERATOR_AND_COROUTINE_FLAGS:\n   self._set_stopinfo(frame,None ,-1)\n  else :\n   self._set_stopinfo(frame.f_back,frame)\n   \n def set_trace(self,frame=None ):\n  ''\n\n\n  \n  if frame is None :\n   frame=sys._getframe().f_back\n  self.reset()\n  while frame:\n   frame.f_trace=self.trace_dispatch\n   self.botframe=frame\n   frame=frame.f_back\n  self.set_step()\n  sys.settrace(self.trace_dispatch)\n  \n def set_continue(self):\n  ''\n\n\n  \n  \n  self._set_stopinfo(self.botframe,None ,-1)\n  if not self.breaks:\n  \n   sys.settrace(None )\n   frame=sys._getframe().f_back\n   while frame and frame is not self.botframe:\n    del frame.f_trace\n    frame=frame.f_back\n    \n def set_quit(self):\n  ''\n\n\n  \n  self.stopframe=self.botframe\n  self.returnframe=None\n  self.quitting=True\n  sys.settrace(None )\n  \n  \n  \n  \n  \n  \n  \n  \n def _add_to_breaks(self,filename,lineno):\n  ''\n  bp_linenos=self.breaks.setdefault(filename,[])\n  if lineno not in bp_linenos:\n   bp_linenos.append(lineno)\n   \n def set_break(self,filename,lineno,temporary=False ,cond=None ,\n funcname=None ):\n  ''\n\n\n\n  \n  filename=self.canonic(filename)\n  import linecache\n  line=linecache.getline(filename,lineno)\n  if not line:\n   return 'Line %s:%d does not exist'%(filename,lineno)\n  self._add_to_breaks(filename,lineno)\n  bp=Breakpoint(filename,lineno,temporary,cond,funcname)\n  return None\n  \n def _load_breaks(self):\n  ''\n\n\n\n\n\n  \n  for (filename,lineno)in Breakpoint.bplist.keys():\n   self._add_to_breaks(filename,lineno)\n   \n def _prune_breaks(self,filename,lineno):\n  ''\n\n\n\n\n\n  \n  if (filename,lineno)not in Breakpoint.bplist:\n   self.breaks[filename].remove(lineno)\n  if not self.breaks[filename]:\n   del self.breaks[filename]\n   \n def clear_break(self,filename,lineno):\n  ''\n\n\n  \n  filename=self.canonic(filename)\n  if filename not in self.breaks:\n   return 'There are no breakpoints in %s'%filename\n  if lineno not in self.breaks[filename]:\n   return 'There is no breakpoint at %s:%d'%(filename,lineno)\n   \n   \n  for bp in Breakpoint.bplist[filename,lineno][:]:\n   bp.deleteMe()\n  self._prune_breaks(filename,lineno)\n  return None\n  \n def clear_bpbynumber(self,arg):\n  ''\n\n\n  \n  try :\n   bp=self.get_bpbynumber(arg)\n  except ValueError as err:\n   return str(err)\n  bp.deleteMe()\n  self._prune_breaks(bp.file,bp.line)\n  return None\n  \n def clear_all_file_breaks(self,filename):\n  ''\n\n\n  \n  filename=self.canonic(filename)\n  if filename not in self.breaks:\n   return 'There are no breakpoints in %s'%filename\n  for line in self.breaks[filename]:\n   blist=Breakpoint.bplist[filename,line]\n   for bp in blist:\n    bp.deleteMe()\n  del self.breaks[filename]\n  return None\n  \n def clear_all_breaks(self):\n  ''\n\n\n  \n  if not self.breaks:\n   return 'There are no breakpoints'\n  for bp in Breakpoint.bpbynumber:\n   if bp:\n    bp.deleteMe()\n  self.breaks={}\n  return None\n  \n def get_bpbynumber(self,arg):\n  ''\n\n\n\n  \n  if not arg:\n   raise ValueError('Breakpoint number expected')\n  try :\n   number=int(arg)\n  except ValueError:\n   raise ValueError('Non-numeric breakpoint number %s'%arg)from None\n  try :\n   bp=Breakpoint.bpbynumber[number]\n  except IndexError:\n   raise ValueError('Breakpoint number %d out of range'%number)from None\n  if bp is None :\n   raise ValueError('Breakpoint %d already deleted'%number)\n  return bp\n  \n def get_break(self,filename,lineno):\n  ''\n  filename=self.canonic(filename)\n  return filename in self.breaks and\\\n  lineno in self.breaks[filename]\n  \n def get_breaks(self,filename,lineno):\n  ''\n\n\n  \n  filename=self.canonic(filename)\n  return filename in self.breaks and\\\n  lineno in self.breaks[filename]and\\\n  Breakpoint.bplist[filename,lineno]or []\n  \n def get_file_breaks(self,filename):\n  ''\n\n\n  \n  filename=self.canonic(filename)\n  if filename in self.breaks:\n   return self.breaks[filename]\n  else :\n   return []\n   \n def get_all_breaks(self):\n  ''\n  return self.breaks\n  \n  \n  \n  \n def get_stack(self,f,t):\n  ''\n\n\n\n  \n  stack=[]\n  if t and t.tb_frame is f:\n   t=t.tb_next\n  while f is not None :\n   stack.append((f,f.f_lineno))\n   if f is self.botframe:\n    break\n   f=f.f_back\n  stack.reverse()\n  i=max(0,len(stack)-1)\n  while t is not None :\n   stack.append((t.tb_frame,t.tb_lineno))\n   t=t.tb_next\n  if f is None :\n   i=max(0,len(stack)-1)\n  return stack,i\n  \n def format_stack_entry(self,frame_lineno,lprefix=': '):\n  ''\n\n\n\n\n\n\n  \n  import linecache,reprlib\n  frame,lineno=frame_lineno\n  filename=self.canonic(frame.f_code.co_filename)\n  s='%s(%r)'%(filename,lineno)\n  if frame.f_code.co_name:\n   s +=frame.f_code.co_name\n  else :\n   s +=\"<lambda>\"\n  s +='()'\n  if '__return__'in frame.f_locals:\n   rv=frame.f_locals['__return__']\n   s +='->'\n   s +=reprlib.repr(rv)\n  line=linecache.getline(filename,lineno,frame.f_globals)\n  if line:\n   s +=lprefix+line.strip()\n  return s\n  \n  \n  \n  \n  \n def run(self,cmd,globals=None ,locals=None ):\n  ''\n\n\n  \n  if globals is None :\n   import __main__\n   globals=__main__.__dict__\n  if locals is None :\n   locals=globals\n  self.reset()\n  if isinstance(cmd,str):\n   cmd=compile(cmd,\"<string>\",\"exec\")\n  sys.settrace(self.trace_dispatch)\n  try :\n   exec(cmd,globals,locals)\n  except BdbQuit:\n   pass\n  finally :\n   self.quitting=True\n   sys.settrace(None )\n   \n def runeval(self,expr,globals=None ,locals=None ):\n  ''\n\n\n  \n  if globals is None :\n   import __main__\n   globals=__main__.__dict__\n  if locals is None :\n   locals=globals\n  self.reset()\n  sys.settrace(self.trace_dispatch)\n  try :\n   return eval(expr,globals,locals)\n  except BdbQuit:\n   pass\n  finally :\n   self.quitting=True\n   sys.settrace(None )\n   \n def runctx(self,cmd,globals,locals):\n  ''\n  \n  self.run(cmd,globals,locals)\n  \n  \n  \n def runcall(self,func,/,*args,**kwds):\n  ''\n\n\n  \n  self.reset()\n  sys.settrace(self.trace_dispatch)\n  res=None\n  try :\n   res=func(*args,**kwds)\n  except BdbQuit:\n   pass\n  finally :\n   self.quitting=True\n   sys.settrace(None )\n  return res\n  \n  \ndef set_trace():\n ''\n Bdb().set_trace()\n \n \nclass Breakpoint:\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n \n \n \n next=1\n bplist={}\n bpbynumber=[None ]\n \n \n \n def __init__(self,file,line,temporary=False ,cond=None ,funcname=None ):\n  self.funcname=funcname\n  \n  self.func_first_executable_line=None\n  self.file=file\n  self.line=line\n  self.temporary=temporary\n  self.cond=cond\n  self.enabled=True\n  self.ignore=0\n  self.hits=0\n  self.number=Breakpoint.next\n  Breakpoint.next +=1\n  \n  self.bpbynumber.append(self)\n  if (file,line)in self.bplist:\n   self.bplist[file,line].append(self)\n  else :\n   self.bplist[file,line]=[self]\n   \n @staticmethod\n def clearBreakpoints():\n  Breakpoint.next=1\n  Breakpoint.bplist={}\n  Breakpoint.bpbynumber=[None ]\n  \n def deleteMe(self):\n  ''\n\n\n\n  \n  \n  index=(self.file,self.line)\n  self.bpbynumber[self.number]=None\n  self.bplist[index].remove(self)\n  if not self.bplist[index]:\n  \n   del self.bplist[index]\n   \n def enable(self):\n  ''\n  self.enabled=True\n  \n def disable(self):\n  ''\n  self.enabled=False\n  \n def bpprint(self,out=None ):\n  ''\n\n\n\n  \n  if out is None :\n   out=sys.stdout\n  print(self.bpformat(),file=out)\n  \n def bpformat(self):\n  ''\n\n\n\n\n\n  \n  if self.temporary:\n   disp='del  '\n  else :\n   disp='keep '\n  if self.enabled:\n   disp=disp+'yes  '\n  else :\n   disp=disp+'no   '\n  ret='%-4dbreakpoint   %s at %s:%d'%(self.number,disp,\n  self.file,self.line)\n  if self.cond:\n   ret +='\\n\\tstop only if %s'%(self.cond,)\n  if self.ignore:\n   ret +='\\n\\tignore next %d hits'%(self.ignore,)\n  if self.hits:\n   if self.hits >1:\n    ss='s'\n   else :\n    ss=''\n   ret +='\\n\\tbreakpoint already hit %d time%s'%(self.hits,ss)\n  return ret\n  \n def __str__(self):\n  ''\n  return 'breakpoint %s at %s:%s'%(self.number,self.file,self.line)\n  \n  \n  \n  \ndef checkfuncname(b,frame):\n ''\n\n\n\n\n\n \n if not b.funcname:\n \n  if b.line !=frame.f_lineno:\n  \n  \n   return False\n  return True\n  \n  \n if frame.f_code.co_name !=b.funcname:\n \n  return False\n  \n  \n if not b.func_first_executable_line:\n \n  b.func_first_executable_line=frame.f_lineno\n  \n if b.func_first_executable_line !=frame.f_lineno:\n \n  return False\n return True\n \n \n \n \ndef effective(file,line,frame):\n ''\n\n\n\n\n\n \n possibles=Breakpoint.bplist[file,line]\n for b in possibles:\n  if not b.enabled:\n   continue\n  if not checkfuncname(b,frame):\n   continue\n   \n  b.hits +=1\n  if not b.cond:\n  \n   if b.ignore >0:\n    b.ignore -=1\n    continue\n   else :\n   \n    return (b,True )\n  else :\n  \n  \n  \n   try :\n    val=eval(b.cond,frame.f_globals,frame.f_locals)\n    if val:\n     if b.ignore >0:\n      b.ignore -=1\n      \n     else :\n      return (b,True )\n      \n      \n   except :\n   \n   \n   \n    return (b,False )\n return (None ,None )\n \n \n \n \nclass Tdb(Bdb):\n def user_call(self,frame,args):\n  name=frame.f_code.co_name\n  if not name:name='???'\n  print('+++ call',name,args)\n def user_line(self,frame):\n  import linecache\n  name=frame.f_code.co_name\n  if not name:name='???'\n  fn=self.canonic(frame.f_code.co_filename)\n  line=linecache.getline(fn,frame.f_lineno,frame.f_globals)\n  print('+++',fn,frame.f_lineno,name,':',line.strip())\n def user_return(self,frame,retval):\n  print('+++ return',retval)\n def user_exception(self,frame,exc_stuff):\n  print('+++ exception',exc_stuff)\n  self.set_continue()\n  \ndef foo(n):\n print('foo(',n,')')\n x=bar(n *10)\n print('bar returned',x)\n \ndef bar(a):\n print('bar(',a,')')\n return a /2\n \ndef test():\n t=Tdb()\n t.run('import bdb; bdb.foo(10)')\n", ["__main__", "fnmatch", "inspect", "linecache", "os", "reprlib", "sys"]], "binascii": [".py", "''\n\n\n\n\n\n\n\nimport _base64\n\nfrom _binascii import *\n\nclass Error(ValueError):\n def __init__(self,msg=''):\n  self._msg=msg\n  \n def __str__(self):\n  return \" binascii.Error: \"+self._msg\n  \n  \nclass Done(Exception):\n pass\n \nclass Incomplete(Error):\n pass\n \ndef a2b_uu(s):\n if not s:\n  return ''\n  \n length=(ord(s[0])-0x20)%64\n \n def quadruplets_gen(s):\n  while s:\n   try :\n    yield ord(s[0]),ord(s[1]),ord(s[2]),ord(s[3])\n   except IndexError:\n    s +='   '\n    yield ord(s[0]),ord(s[1]),ord(s[2]),ord(s[3])\n    return\n   s=s[4:]\n   \n try :\n  result=[''.join(\n  [chr((A -0x20)<<2 |(((B -0x20)>>4)&0x3)),\n  chr(((B -0x20)&0xf)<<4 |(((C -0x20)>>2)&0xf)),\n  chr(((C -0x20)&0x3)<<6 |((D -0x20)&0x3f))\n  ])for A,B,C,D in quadruplets_gen(s[1:].rstrip())]\n except ValueError:\n  raise Error('Illegal char')\n result=''.join(result)\n trailingdata=result[length:]\n if trailingdata.strip('\\x00'):\n  raise Error('Trailing garbage')\n result=result[:length]\n if len(result)<length:\n  result +=((length -len(result))*'\\x00')\n return bytes(result,__BRYTHON__.charset)\n \n \ntable_a2b_base64={\n'A':0,\n'B':1,\n'C':2,\n'D':3,\n'E':4,\n'F':5,\n'G':6,\n'H':7,\n'I':8,\n'J':9,\n'K':10,\n'L':11,\n'M':12,\n'N':13,\n'O':14,\n'P':15,\n'Q':16,\n'R':17,\n'S':18,\n'T':19,\n'U':20,\n'V':21,\n'W':22,\n'X':23,\n'Y':24,\n'Z':25,\n'a':26,\n'b':27,\n'c':28,\n'd':29,\n'e':30,\n'f':31,\n'g':32,\n'h':33,\n'i':34,\n'j':35,\n'k':36,\n'l':37,\n'm':38,\n'n':39,\n'o':40,\n'p':41,\n'q':42,\n'r':43,\n's':44,\n't':45,\n'u':46,\n'v':47,\n'w':48,\n'x':49,\n'y':50,\n'z':51,\n'0':52,\n'1':53,\n'2':54,\n'3':55,\n'4':56,\n'5':57,\n'6':58,\n'7':59,\n'8':60,\n'9':61,\n'+':62,\n'/':63,\n'=':0,\n}\n\n\ndef XXXa2b_base64(s):\n return _base64.Base64.decode(s)\n \ntable_b2a_base64=\"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz\"\\\n\"0123456789+/\"\n\ndef XXXb2a_base64(s,newline=True ):\n length=len(s)\n final_length=length %3\n \n def triples_gen(s):\n  while s:\n   try :\n    yield s[0],s[1],s[2]\n   except IndexError:\n    s +=b'\\0\\0'\n    yield s[0],s[1],s[2]\n    return\n   s=s[3:]\n   \n a=triples_gen(s[:length -final_length])\n \n result=[''.join(\n [table_b2a_base64[(A >>2)&0x3F],\n table_b2a_base64[((A <<4)|((B >>4)&0xF))&0x3F],\n table_b2a_base64[((B <<2)|((C >>6)&0x3))&0x3F],\n table_b2a_base64[(C)&0x3F]])\n for A,B,C in a]\n \n final=s[length -final_length:]\n if final_length ==0:\n  snippet=''\n elif final_length ==1:\n  a=final[0]\n  snippet=table_b2a_base64[(a >>2)&0x3F]+\\\n  table_b2a_base64[(a <<4)&0x3F]+'=='\n else :\n  a=final[0]\n  b=final[1]\n  snippet=table_b2a_base64[(a >>2)&0x3F]+\\\n  table_b2a_base64[((a <<4)|(b >>4)&0xF)&0x3F]+\\\n  table_b2a_base64[(b <<2)&0x3F]+'='\n  \n result=''.join(result)+snippet\n if newline:\n  result +='\\n'\n return bytes(result,__BRYTHON__.charset)\n \ndef a2b_qp(s,header=False ):\n inp=0\n odata=[]\n while inp <len(s):\n  if s[inp]=='=':\n   inp +=1\n   if inp >=len(s):\n    break\n    \n   if (s[inp]=='\\n')or (s[inp]=='\\r'):\n    if s[inp]!='\\n':\n     while inp <len(s)and s[inp]!='\\n':\n      inp +=1\n    if inp <len(s):\n     inp +=1\n   elif s[inp]=='=':\n   \n    odata.append('=')\n    inp +=1\n   elif s[inp]in hex_numbers and s[inp+1]in hex_numbers:\n    ch=chr(int(s[inp:inp+2],16))\n    inp +=2\n    odata.append(ch)\n   else :\n    odata.append('=')\n  elif header and s[inp]=='_':\n   odata.append(' ')\n   inp +=1\n  else :\n   odata.append(s[inp])\n   inp +=1\n return bytes(''.join(odata),__BRYTHON__.charset)\n \ndef b2a_qp(data,quotetabs=False ,istext=True ,header=False ):\n ''\n\n\n\n\n \n MAXLINESIZE=76\n \n \n lf=data.find('\\n')\n crlf=lf >0 and data[lf -1]=='\\r'\n \n inp=0\n linelen=0\n odata=[]\n while inp <len(data):\n  c=data[inp]\n  if (c >'~'or\n  c =='='or\n  (header and c =='_')or\n  (c =='.'and linelen ==0 and (inp+1 ==len(data)or\n  data[inp+1]=='\\n'or\n  data[inp+1]=='\\r'))or\n  (not istext and (c =='\\r'or c =='\\n'))or\n  ((c =='\\t'or c ==' ')and (inp+1 ==len(data)))or\n  (c <=' 'and c !='\\r'and c !='\\n'and\n  (quotetabs or (not quotetabs and (c !='\\t'and c !=' '))))):\n   linelen +=3\n   if linelen >=MAXLINESIZE:\n    odata.append('=')\n    if crlf:odata.append('\\r')\n    odata.append('\\n')\n    linelen=3\n   odata.append('='+two_hex_digits(ord(c)))\n   inp +=1\n  else :\n   if (istext and\n   (c =='\\n'or (inp+1 <len(data)and c =='\\r'and\n   data[inp+1]=='\\n'))):\n    linelen=0\n    \n    if (len(odata)>0 and\n    (odata[-1]==' 'or odata[-1]=='\\t')):\n     ch=ord(odata[-1])\n     odata[-1]='='\n     odata.append(two_hex_digits(ch))\n     \n    if crlf:odata.append('\\r')\n    odata.append('\\n')\n    if c =='\\r':\n     inp +=2\n    else :\n     inp +=1\n   else :\n    if (inp+1 <len(data)and\n    data[inp+1]!='\\n'and\n    (linelen+1)>=MAXLINESIZE):\n     odata.append('=')\n     if crlf:odata.append('\\r')\n     odata.append('\\n')\n     linelen=0\n     \n    linelen +=1\n    if header and c ==' ':\n     c='_'\n    odata.append(c)\n    inp +=1\n return ''.join(odata)\n \nhex_numbers='0123456789ABCDEF'\ndef hex(n):\n if n ==0:\n  return '0'\n  \n if n <0:\n  n=-n\n  sign='-'\n else :\n  sign=''\n arr=[]\n \n def hex_gen(n):\n  ''\n  while n:\n   yield n %0x10\n   n=n /0x10\n   \n for nibble in hex_gen(n):\n  arr=[hex_numbers[nibble]]+arr\n return sign+''.join(arr)\n \ndef two_hex_digits(n):\n return hex_numbers[n /0x10]+hex_numbers[n %0x10]\n \n \ndef strhex_to_int(s):\n i=0\n for c in s:\n  i=i *0x10+hex_numbers.index(c)\n return i\n \nhqx_encoding='!\"#$%&\\'()*+,-012345689@ABCDEFGHIJKLMNPQRSTUVXYZ[`abcdefhijklmpqr'\n\nDONE=0x7f\nSKIP=0x7e\nFAIL=0x7d\n\ntable_a2b_hqx=[\n\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\n\nFAIL,FAIL,SKIP,FAIL,FAIL,SKIP,FAIL,FAIL,\n\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\n\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\n\nFAIL,0x00,0x01,0x02,0x03,0x04,0x05,0x06,\n\n0x07,0x08,0x09,0x0A,0x0B,0x0C,FAIL,FAIL,\n\n0x0D,0x0E,0x0F,0x10,0x11,0x12,0x13,FAIL,\n\n0x14,0x15,DONE,FAIL,FAIL,FAIL,FAIL,FAIL,\n\n0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,\n\n0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,FAIL,\n\n0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,FAIL,\n\n0x2C,0x2D,0x2E,0x2F,FAIL,FAIL,FAIL,FAIL,\n\n0x30,0x31,0x32,0x33,0x34,0x35,0x36,FAIL,\n\n0x37,0x38,0x39,0x3A,0x3B,0x3C,FAIL,FAIL,\n\n0x3D,0x3E,0x3F,FAIL,FAIL,FAIL,FAIL,FAIL,\n\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\n]\n\ndef a2b_hqx(s):\n result=[]\n \n def quadruples_gen(s):\n  t=[]\n  for c in s:\n   res=table_a2b_hqx[ord(c)]\n   if res ==SKIP:\n    continue\n   elif res ==FAIL:\n    raise Error('Illegal character')\n   elif res ==DONE:\n    yield t\n    raise Done\n   else :\n    t.append(res)\n   if len(t)==4:\n    yield t\n    t=[]\n  yield t\n  \n done=0\n try :\n  for snippet in quadruples_gen(s):\n   length=len(snippet)\n   if length ==4:\n    result.append(chr(((snippet[0]&0x3f)<<2)|(snippet[1]>>4)))\n    result.append(chr(((snippet[1]&0x0f)<<4)|(snippet[2]>>2)))\n    result.append(chr(((snippet[2]&0x03)<<6)|(snippet[3])))\n   elif length ==3:\n    result.append(chr(((snippet[0]&0x3f)<<2)|(snippet[1]>>4)))\n    result.append(chr(((snippet[1]&0x0f)<<4)|(snippet[2]>>2)))\n   elif length ==2:\n    result.append(chr(((snippet[0]&0x3f)<<2)|(snippet[1]>>4)))\n except Done:\n  done=1\n except Error:\n  raise\n return (''.join(result),done)\n \n \n \ndef b2a_hqx(s):\n result=[]\n \n def triples_gen(s):\n  while s:\n   try :\n    yield ord(s[0]),ord(s[1]),ord(s[2])\n   except IndexError:\n    yield tuple([ord(c)for c in s])\n   s=s[3:]\n   \n for snippet in triples_gen(s):\n  length=len(snippet)\n  if length ==3:\n   result.append(\n   hqx_encoding[(snippet[0]&0xfc)>>2])\n   result.append(hqx_encoding[\n   ((snippet[0]&0x03)<<4)|((snippet[1]&0xf0)>>4)])\n   result.append(hqx_encoding[\n   (snippet[1]&0x0f)<<2 |((snippet[2]&0xc0)>>6)])\n   result.append(hqx_encoding[snippet[2]&0x3f])\n  elif length ==2:\n   result.append(\n   hqx_encoding[(snippet[0]&0xfc)>>2])\n   result.append(hqx_encoding[\n   ((snippet[0]&0x03)<<4)|((snippet[1]&0xf0)>>4)])\n   result.append(hqx_encoding[\n   (snippet[1]&0x0f)<<2])\n  elif length ==1:\n   result.append(\n   hqx_encoding[(snippet[0]&0xfc)>>2])\n   result.append(hqx_encoding[\n   ((snippet[0]&0x03)<<4)])\n return ''.join(result)\n \ncrctab_hqx=[\n0x0000,0x1021,0x2042,0x3063,0x4084,0x50a5,0x60c6,0x70e7,\n0x8108,0x9129,0xa14a,0xb16b,0xc18c,0xd1ad,0xe1ce,0xf1ef,\n0x1231,0x0210,0x3273,0x2252,0x52b5,0x4294,0x72f7,0x62d6,\n0x9339,0x8318,0xb37b,0xa35a,0xd3bd,0xc39c,0xf3ff,0xe3de,\n0x2462,0x3443,0x0420,0x1401,0x64e6,0x74c7,0x44a4,0x5485,\n0xa56a,0xb54b,0x8528,0x9509,0xe5ee,0xf5cf,0xc5ac,0xd58d,\n0x3653,0x2672,0x1611,0x0630,0x76d7,0x66f6,0x5695,0x46b4,\n0xb75b,0xa77a,0x9719,0x8738,0xf7df,0xe7fe,0xd79d,0xc7bc,\n0x48c4,0x58e5,0x6886,0x78a7,0x0840,0x1861,0x2802,0x3823,\n0xc9cc,0xd9ed,0xe98e,0xf9af,0x8948,0x9969,0xa90a,0xb92b,\n0x5af5,0x4ad4,0x7ab7,0x6a96,0x1a71,0x0a50,0x3a33,0x2a12,\n0xdbfd,0xcbdc,0xfbbf,0xeb9e,0x9b79,0x8b58,0xbb3b,0xab1a,\n0x6ca6,0x7c87,0x4ce4,0x5cc5,0x2c22,0x3c03,0x0c60,0x1c41,\n0xedae,0xfd8f,0xcdec,0xddcd,0xad2a,0xbd0b,0x8d68,0x9d49,\n0x7e97,0x6eb6,0x5ed5,0x4ef4,0x3e13,0x2e32,0x1e51,0x0e70,\n0xff9f,0xefbe,0xdfdd,0xcffc,0xbf1b,0xaf3a,0x9f59,0x8f78,\n0x9188,0x81a9,0xb1ca,0xa1eb,0xd10c,0xc12d,0xf14e,0xe16f,\n0x1080,0x00a1,0x30c2,0x20e3,0x5004,0x4025,0x7046,0x6067,\n0x83b9,0x9398,0xa3fb,0xb3da,0xc33d,0xd31c,0xe37f,0xf35e,\n0x02b1,0x1290,0x22f3,0x32d2,0x4235,0x5214,0x6277,0x7256,\n0xb5ea,0xa5cb,0x95a8,0x8589,0xf56e,0xe54f,0xd52c,0xc50d,\n0x34e2,0x24c3,0x14a0,0x0481,0x7466,0x6447,0x5424,0x4405,\n0xa7db,0xb7fa,0x8799,0x97b8,0xe75f,0xf77e,0xc71d,0xd73c,\n0x26d3,0x36f2,0x0691,0x16b0,0x6657,0x7676,0x4615,0x5634,\n0xd94c,0xc96d,0xf90e,0xe92f,0x99c8,0x89e9,0xb98a,0xa9ab,\n0x5844,0x4865,0x7806,0x6827,0x18c0,0x08e1,0x3882,0x28a3,\n0xcb7d,0xdb5c,0xeb3f,0xfb1e,0x8bf9,0x9bd8,0xabbb,0xbb9a,\n0x4a75,0x5a54,0x6a37,0x7a16,0x0af1,0x1ad0,0x2ab3,0x3a92,\n0xfd2e,0xed0f,0xdd6c,0xcd4d,0xbdaa,0xad8b,0x9de8,0x8dc9,\n0x7c26,0x6c07,0x5c64,0x4c45,0x3ca2,0x2c83,0x1ce0,0x0cc1,\n0xef1f,0xff3e,0xcf5d,0xdf7c,0xaf9b,0xbfba,0x8fd9,0x9ff8,\n0x6e17,0x7e36,0x4e55,0x5e74,0x2e93,0x3eb2,0x0ed1,0x1ef0,\n]\n\ndef crc_hqx(s,crc):\n for c in s:\n  crc=((crc <<8)&0xff00)^crctab_hqx[((crc >>8)&0xff)^ord(c)]\n  \n return crc\n \ndef rlecode_hqx(s):\n ''\n\n\n\n \n if not s:\n  return ''\n result=[]\n prev=s[0]\n count=1\n \n \n \n \n if s[-1]=='!':\n  s=s[1:]+'?'\n else :\n  s=s[1:]+'!'\n  \n for c in s:\n  if c ==prev and count <255:\n   count +=1\n  else :\n   if count ==1:\n    if prev !='\\x90':\n     result.append(prev)\n    else :\n     result.extend(['\\x90','\\x00'])\n   elif count <4:\n    if prev !='\\x90':\n     result.extend([prev]*count)\n    else :\n     result.extend(['\\x90','\\x00']*count)\n   else :\n    if prev !='\\x90':\n     result.extend([prev,'\\x90',chr(count)])\n    else :\n     result.extend(['\\x90','\\x00','\\x90',chr(count)])\n   count=1\n   prev=c\n   \n return ''.join(result)\n \ndef rledecode_hqx(s):\n s=s.split('\\x90')\n result=[s[0]]\n prev=s[0]\n for snippet in s[1:]:\n  count=ord(snippet[0])\n  if count >0:\n   result.append(prev[-1]*(count -1))\n   prev=snippet\n  else :\n   result.append('\\x90')\n   prev='\\x90'\n  result.append(snippet[1:])\n  \n return ''.join(result)\n \ncrc_32_tab=[\n0x00000000,0x77073096,0xee0e612c,0x990951ba,0x076dc419,\n0x706af48f,0xe963a535,0x9e6495a3,0x0edb8832,0x79dcb8a4,\n0xe0d5e91e,0x97d2d988,0x09b64c2b,0x7eb17cbd,0xe7b82d07,\n0x90bf1d91,0x1db71064,0x6ab020f2,0xf3b97148,0x84be41de,\n0x1adad47d,0x6ddde4eb,0xf4d4b551,0x83d385c7,0x136c9856,\n0x646ba8c0,0xfd62f97a,0x8a65c9ec,0x14015c4f,0x63066cd9,\n0xfa0f3d63,0x8d080df5,0x3b6e20c8,0x4c69105e,0xd56041e4,\n0xa2677172,0x3c03e4d1,0x4b04d447,0xd20d85fd,0xa50ab56b,\n0x35b5a8fa,0x42b2986c,0xdbbbc9d6,0xacbcf940,0x32d86ce3,\n0x45df5c75,0xdcd60dcf,0xabd13d59,0x26d930ac,0x51de003a,\n0xc8d75180,0xbfd06116,0x21b4f4b5,0x56b3c423,0xcfba9599,\n0xb8bda50f,0x2802b89e,0x5f058808,0xc60cd9b2,0xb10be924,\n0x2f6f7c87,0x58684c11,0xc1611dab,0xb6662d3d,0x76dc4190,\n0x01db7106,0x98d220bc,0xefd5102a,0x71b18589,0x06b6b51f,\n0x9fbfe4a5,0xe8b8d433,0x7807c9a2,0x0f00f934,0x9609a88e,\n0xe10e9818,0x7f6a0dbb,0x086d3d2d,0x91646c97,0xe6635c01,\n0x6b6b51f4,0x1c6c6162,0x856530d8,0xf262004e,0x6c0695ed,\n0x1b01a57b,0x8208f4c1,0xf50fc457,0x65b0d9c6,0x12b7e950,\n0x8bbeb8ea,0xfcb9887c,0x62dd1ddf,0x15da2d49,0x8cd37cf3,\n0xfbd44c65,0x4db26158,0x3ab551ce,0xa3bc0074,0xd4bb30e2,\n0x4adfa541,0x3dd895d7,0xa4d1c46d,0xd3d6f4fb,0x4369e96a,\n0x346ed9fc,0xad678846,0xda60b8d0,0x44042d73,0x33031de5,\n0xaa0a4c5f,0xdd0d7cc9,0x5005713c,0x270241aa,0xbe0b1010,\n0xc90c2086,0x5768b525,0x206f85b3,0xb966d409,0xce61e49f,\n0x5edef90e,0x29d9c998,0xb0d09822,0xc7d7a8b4,0x59b33d17,\n0x2eb40d81,0xb7bd5c3b,0xc0ba6cad,0xedb88320,0x9abfb3b6,\n0x03b6e20c,0x74b1d29a,0xead54739,0x9dd277af,0x04db2615,\n0x73dc1683,0xe3630b12,0x94643b84,0x0d6d6a3e,0x7a6a5aa8,\n0xe40ecf0b,0x9309ff9d,0x0a00ae27,0x7d079eb1,0xf00f9344,\n0x8708a3d2,0x1e01f268,0x6906c2fe,0xf762575d,0x806567cb,\n0x196c3671,0x6e6b06e7,0xfed41b76,0x89d32be0,0x10da7a5a,\n0x67dd4acc,0xf9b9df6f,0x8ebeeff9,0x17b7be43,0x60b08ed5,\n0xd6d6a3e8,0xa1d1937e,0x38d8c2c4,0x4fdff252,0xd1bb67f1,\n0xa6bc5767,0x3fb506dd,0x48b2364b,0xd80d2bda,0xaf0a1b4c,\n0x36034af6,0x41047a60,0xdf60efc3,0xa867df55,0x316e8eef,\n0x4669be79,0xcb61b38c,0xbc66831a,0x256fd2a0,0x5268e236,\n0xcc0c7795,0xbb0b4703,0x220216b9,0x5505262f,0xc5ba3bbe,\n0xb2bd0b28,0x2bb45a92,0x5cb36a04,0xc2d7ffa7,0xb5d0cf31,\n0x2cd99e8b,0x5bdeae1d,0x9b64c2b0,0xec63f226,0x756aa39c,\n0x026d930a,0x9c0906a9,0xeb0e363f,0x72076785,0x05005713,\n0x95bf4a82,0xe2b87a14,0x7bb12bae,0x0cb61b38,0x92d28e9b,\n0xe5d5be0d,0x7cdcefb7,0x0bdbdf21,0x86d3d2d4,0xf1d4e242,\n0x68ddb3f8,0x1fda836e,0x81be16cd,0xf6b9265b,0x6fb077e1,\n0x18b74777,0x88085ae6,0xff0f6a70,0x66063bca,0x11010b5c,\n0x8f659eff,0xf862ae69,0x616bffd3,0x166ccf45,0xa00ae278,\n0xd70dd2ee,0x4e048354,0x3903b3c2,0xa7672661,0xd06016f7,\n0x4969474d,0x3e6e77db,0xaed16a4a,0xd9d65adc,0x40df0b66,\n0x37d83bf0,0xa9bcae53,0xdebb9ec5,0x47b2cf7f,0x30b5ffe9,\n0xbdbdf21c,0xcabac28a,0x53b39330,0x24b4a3a6,0xbad03605,\n0xcdd70693,0x54de5729,0x23d967bf,0xb3667a2e,0xc4614ab8,\n0x5d681b02,0x2a6f2b94,0xb40bbe37,0xc30c8ea1,0x5a05df1b,\n0x2d02ef8d\n]\n\ndef crc32(s,crc=0):\n result=0\n crc=~int(crc)&0xffffffff\n \n for c in s:\n  crc=crc_32_tab[(crc ^int(ord(c)))&0xff]^(crc >>8)\n  \n  \n  \n result=crc ^0xffffffff\n \n if result >2 **31:\n  result=((result+2 **31)%2 **32)-2 **31\n  \n return result\n", ["_base64", "_binascii"]], "bisect": [".py", "''\n\n\ndef insort_right(a,x,lo=0,hi=None ,*,key=None ):\n ''\n\n\n\n\n\n \n if key is None :\n  lo=bisect_right(a,x,lo,hi)\n else :\n  lo=bisect_right(a,key(x),lo,hi,key=key)\n a.insert(lo,x)\n \n \ndef bisect_right(a,x,lo=0,hi=None ,*,key=None ):\n ''\n\n\n\n\n\n\n\n \n \n if lo <0:\n  raise ValueError('lo must be non-negative')\n if hi is None :\n  hi=len(a)\n  \n  \n if key is None :\n  while lo <hi:\n   mid=(lo+hi)//2\n   if x <a[mid]:\n    hi=mid\n   else :\n    lo=mid+1\n else :\n  while lo <hi:\n   mid=(lo+hi)//2\n   if x <key(a[mid]):\n    hi=mid\n   else :\n    lo=mid+1\n return lo\n \n \ndef insort_left(a,x,lo=0,hi=None ,*,key=None ):\n ''\n\n\n\n\n\n \n \n if key is None :\n  lo=bisect_left(a,x,lo,hi)\n else :\n  lo=bisect_left(a,key(x),lo,hi,key=key)\n a.insert(lo,x)\n \ndef bisect_left(a,x,lo=0,hi=None ,*,key=None ):\n ''\n\n\n\n\n\n\n\n \n \n if lo <0:\n  raise ValueError('lo must be non-negative')\n if hi is None :\n  hi=len(a)\n  \n  \n if key is None :\n  while lo <hi:\n   mid=(lo+hi)//2\n   if a[mid]<x:\n    lo=mid+1\n   else :\n    hi=mid\n else :\n  while lo <hi:\n   mid=(lo+hi)//2\n   if key(a[mid])<x:\n    lo=mid+1\n   else :\n    hi=mid\n return lo\n \n \n \ntry :\n from _bisect import *\nexcept ImportError:\n pass\n \n \nbisect=bisect_right\ninsort=insort_right\n", ["_bisect"]], "calendar": [".py", "''\n\n\n\n\n\n\nimport sys\nimport datetime\nimport locale as _locale\nfrom itertools import repeat\n\n__all__=[\"IllegalMonthError\",\"IllegalWeekdayError\",\"setfirstweekday\",\n\"firstweekday\",\"isleap\",\"leapdays\",\"weekday\",\"monthrange\",\n\"monthcalendar\",\"prmonth\",\"month\",\"prcal\",\"calendar\",\n\"timegm\",\"month_name\",\"month_abbr\",\"day_name\",\"day_abbr\",\n\"Calendar\",\"TextCalendar\",\"HTMLCalendar\",\"LocaleTextCalendar\",\n\"LocaleHTMLCalendar\",\"weekheader\"]\n\n\nerror=ValueError\n\n\nclass IllegalMonthError(ValueError):\n def __init__(self,month):\n  self.month=month\n def __str__(self):\n  return \"bad month number %r; must be 1-12\"%self.month\n  \n  \nclass IllegalWeekdayError(ValueError):\n def __init__(self,weekday):\n  self.weekday=weekday\n def __str__(self):\n  return \"bad weekday number %r; must be 0 (Monday) to 6 (Sunday)\"%self.weekday\n  \n  \n  \nJanuary=1\nFebruary=2\n\n\nmdays=[0,31,28,31,30,31,30,31,31,30,31,30,31]\n\n\n\n\n\n\nclass _localized_month:\n\n _months=[datetime.date(2001,i+1,1).strftime for i in range(12)]\n _months.insert(0,lambda x:\"\")\n \n def __init__(self,format):\n  self.format=format\n  \n def __getitem__(self,i):\n  funcs=self._months[i]\n  if isinstance(i,slice):\n   return [f(self.format)for f in funcs]\n  else :\n   return funcs(self.format)\n   \n def __len__(self):\n  return 13\n  \n  \nclass _localized_day:\n\n\n _days=[datetime.date(2001,1,i+1).strftime for i in range(7)]\n \n def __init__(self,format):\n  self.format=format\n  \n def __getitem__(self,i):\n  funcs=self._days[i]\n  if isinstance(i,slice):\n   return [f(self.format)for f in funcs]\n  else :\n   return funcs(self.format)\n   \n def __len__(self):\n  return 7\n  \n  \n  \nday_name=_localized_day('%A')\nday_abbr=_localized_day('%a')\n\n\nmonth_name=_localized_month('%B')\nmonth_abbr=_localized_month('%b')\n\n\n(MONDAY,TUESDAY,WEDNESDAY,THURSDAY,FRIDAY,SATURDAY,SUNDAY)=range(7)\n\n\ndef isleap(year):\n ''\n return year %4 ==0 and (year %100 !=0 or year %400 ==0)\n \n \ndef leapdays(y1,y2):\n ''\n \n y1 -=1\n y2 -=1\n return (y2 //4 -y1 //4)-(y2 //100 -y1 //100)+(y2 //400 -y1 //400)\n \n \ndef weekday(year,month,day):\n ''\n if not datetime.MINYEAR <=year <=datetime.MAXYEAR:\n  year=2000+year %400\n return datetime.date(year,month,day).weekday()\n \n \ndef monthrange(year,month):\n ''\n \n if not 1 <=month <=12:\n  raise IllegalMonthError(month)\n day1=weekday(year,month,1)\n ndays=mdays[month]+(month ==February and isleap(year))\n return day1,ndays\n \n \ndef _monthlen(year,month):\n return mdays[month]+(month ==February and isleap(year))\n \n \ndef _prevmonth(year,month):\n if month ==1:\n  return year -1,12\n else :\n  return year,month -1\n  \n  \ndef _nextmonth(year,month):\n if month ==12:\n  return year+1,1\n else :\n  return year,month+1\n  \n  \nclass Calendar(object):\n ''\n\n\n \n \n def __init__(self,firstweekday=0):\n  self.firstweekday=firstweekday\n  \n def getfirstweekday(self):\n  return self._firstweekday %7\n  \n def setfirstweekday(self,firstweekday):\n  self._firstweekday=firstweekday\n  \n firstweekday=property(getfirstweekday,setfirstweekday)\n \n def iterweekdays(self):\n  ''\n\n\n  \n  for i in range(self.firstweekday,self.firstweekday+7):\n   yield i %7\n   \n def itermonthdates(self,year,month):\n  ''\n\n\n\n  \n  for y,m,d in self.itermonthdays3(year,month):\n   yield datetime.date(y,m,d)\n   \n def itermonthdays(self,year,month):\n  ''\n\n\n  \n  day1,ndays=monthrange(year,month)\n  days_before=(day1 -self.firstweekday)%7\n  yield from repeat(0,days_before)\n  yield from range(1,ndays+1)\n  days_after=(self.firstweekday -day1 -ndays)%7\n  yield from repeat(0,days_after)\n  \n def itermonthdays2(self,year,month):\n  ''\n\n\n  \n  for i,d in enumerate(self.itermonthdays(year,month),self.firstweekday):\n   yield d,i %7\n   \n def itermonthdays3(self,year,month):\n  ''\n\n\n  \n  day1,ndays=monthrange(year,month)\n  days_before=(day1 -self.firstweekday)%7\n  days_after=(self.firstweekday -day1 -ndays)%7\n  y,m=_prevmonth(year,month)\n  end=_monthlen(y,m)+1\n  for d in range(end -days_before,end):\n   yield y,m,d\n  for d in range(1,ndays+1):\n   yield year,month,d\n  y,m=_nextmonth(year,month)\n  for d in range(1,days_after+1):\n   yield y,m,d\n   \n def itermonthdays4(self,year,month):\n  ''\n\n\n  \n  for i,(y,m,d)in enumerate(self.itermonthdays3(year,month)):\n   yield y,m,d,(self.firstweekday+i)%7\n   \n def monthdatescalendar(self,year,month):\n  ''\n\n\n  \n  dates=list(self.itermonthdates(year,month))\n  return [dates[i:i+7]for i in range(0,len(dates),7)]\n  \n def monthdays2calendar(self,year,month):\n  ''\n\n\n\n\n  \n  days=list(self.itermonthdays2(year,month))\n  return [days[i:i+7]for i in range(0,len(days),7)]\n  \n def monthdayscalendar(self,year,month):\n  ''\n\n\n  \n  days=list(self.itermonthdays(year,month))\n  return [days[i:i+7]for i in range(0,len(days),7)]\n  \n def yeardatescalendar(self,year,width=3):\n  ''\n\n\n\n\n  \n  months=[\n  self.monthdatescalendar(year,i)\n  for i in range(January,January+12)\n  ]\n  return [months[i:i+width]for i in range(0,len(months),width)]\n  \n def yeardays2calendar(self,year,width=3):\n  ''\n\n\n\n\n  \n  months=[\n  self.monthdays2calendar(year,i)\n  for i in range(January,January+12)\n  ]\n  return [months[i:i+width]for i in range(0,len(months),width)]\n  \n def yeardayscalendar(self,year,width=3):\n  ''\n\n\n\n  \n  months=[\n  self.monthdayscalendar(year,i)\n  for i in range(January,January+12)\n  ]\n  return [months[i:i+width]for i in range(0,len(months),width)]\n  \n  \nclass TextCalendar(Calendar):\n ''\n\n\n \n \n def prweek(self,theweek,width):\n  ''\n\n  \n  print(self.formatweek(theweek,width),end='')\n  \n def formatday(self,day,weekday,width):\n  ''\n\n  \n  if day ==0:\n   s=''\n  else :\n   s='%2i'%day\n  return s.center(width)\n  \n def formatweek(self,theweek,width):\n  ''\n\n  \n  return ' '.join(self.formatday(d,wd,width)for (d,wd)in theweek)\n  \n def formatweekday(self,day,width):\n  ''\n\n  \n  if width >=9:\n   names=day_name\n  else :\n   names=day_abbr\n  return names[day][:width].center(width)\n  \n def formatweekheader(self,width):\n  ''\n\n  \n  return ' '.join(self.formatweekday(i,width)for i in self.iterweekdays())\n  \n def formatmonthname(self,theyear,themonth,width,withyear=True ):\n  ''\n\n  \n  s=month_name[themonth]\n  if withyear:\n   s=\"%s %r\"%(s,theyear)\n  return s.center(width)\n  \n def prmonth(self,theyear,themonth,w=0,l=0):\n  ''\n\n  \n  print(self.formatmonth(theyear,themonth,w,l),end='')\n  \n def formatmonth(self,theyear,themonth,w=0,l=0):\n  ''\n\n  \n  w=max(2,w)\n  l=max(1,l)\n  s=self.formatmonthname(theyear,themonth,7 *(w+1)-1)\n  s=s.rstrip()\n  s +='\\n'*l\n  s +=self.formatweekheader(w).rstrip()\n  s +='\\n'*l\n  for week in self.monthdays2calendar(theyear,themonth):\n   s +=self.formatweek(week,w).rstrip()\n   s +='\\n'*l\n  return s\n  \n def formatyear(self,theyear,w=2,l=1,c=6,m=3):\n  ''\n\n  \n  w=max(2,w)\n  l=max(1,l)\n  c=max(2,c)\n  colwidth=(w+1)*7 -1\n  v=[]\n  a=v.append\n  a(repr(theyear).center(colwidth *m+c *(m -1)).rstrip())\n  a('\\n'*l)\n  header=self.formatweekheader(w)\n  for (i,row)in enumerate(self.yeardays2calendar(theyear,m)):\n  \n   months=range(m *i+1,min(m *(i+1)+1,13))\n   a('\\n'*l)\n   names=(self.formatmonthname(theyear,k,colwidth,False )\n   for k in months)\n   a(formatstring(names,colwidth,c).rstrip())\n   a('\\n'*l)\n   headers=(header for k in months)\n   a(formatstring(headers,colwidth,c).rstrip())\n   a('\\n'*l)\n   \n   height=max(len(cal)for cal in row)\n   for j in range(height):\n    weeks=[]\n    for cal in row:\n     if j >=len(cal):\n      weeks.append('')\n     else :\n      weeks.append(self.formatweek(cal[j],w))\n    a(formatstring(weeks,colwidth,c).rstrip())\n    a('\\n'*l)\n  return ''.join(v)\n  \n def pryear(self,theyear,w=0,l=0,c=6,m=3):\n  ''\n  print(self.formatyear(theyear,w,l,c,m),end='')\n  \n  \nclass HTMLCalendar(Calendar):\n ''\n\n \n \n \n cssclasses=[\"mon\",\"tue\",\"wed\",\"thu\",\"fri\",\"sat\",\"sun\"]\n \n \n cssclasses_weekday_head=cssclasses\n \n \n cssclass_noday=\"noday\"\n \n \n cssclass_month_head=\"month\"\n \n \n cssclass_month=\"month\"\n \n \n cssclass_year_head=\"year\"\n \n \n cssclass_year=\"year\"\n \n def formatday(self,day,weekday):\n  ''\n\n  \n  if day ==0:\n  \n   return '<td class=\"%s\">&nbsp;</td>'%self.cssclass_noday\n  else :\n   return '<td class=\"%s\">%d</td>'%(self.cssclasses[weekday],day)\n   \n def formatweek(self,theweek):\n  ''\n\n  \n  s=''.join(self.formatday(d,wd)for (d,wd)in theweek)\n  return '<tr>%s</tr>'%s\n  \n def formatweekday(self,day):\n  ''\n\n  \n  return '<th class=\"%s\">%s</th>'%(\n  self.cssclasses_weekday_head[day],day_abbr[day])\n  \n def formatweekheader(self):\n  ''\n\n  \n  s=''.join(self.formatweekday(i)for i in self.iterweekdays())\n  return '<tr>%s</tr>'%s\n  \n def formatmonthname(self,theyear,themonth,withyear=True ):\n  ''\n\n  \n  if withyear:\n   s='%s %s'%(month_name[themonth],theyear)\n  else :\n   s='%s'%month_name[themonth]\n  return '<tr><th colspan=\"7\" class=\"%s\">%s</th></tr>'%(\n  self.cssclass_month_head,s)\n  \n def formatmonth(self,theyear,themonth,withyear=True ):\n  ''\n\n  \n  v=[]\n  a=v.append\n  a('<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"%s\">'%(\n  self.cssclass_month))\n  a('\\n')\n  a(self.formatmonthname(theyear,themonth,withyear=withyear))\n  a('\\n')\n  a(self.formatweekheader())\n  a('\\n')\n  for week in self.monthdays2calendar(theyear,themonth):\n   a(self.formatweek(week))\n   a('\\n')\n  a('</table>')\n  a('\\n')\n  return ''.join(v)\n  \n def formatyear(self,theyear,width=3):\n  ''\n\n  \n  v=[]\n  a=v.append\n  width=max(width,1)\n  a('<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"%s\">'%\n  self.cssclass_year)\n  a('\\n')\n  a('<tr><th colspan=\"%d\" class=\"%s\">%s</th></tr>'%(\n  width,self.cssclass_year_head,theyear))\n  for i in range(January,January+12,width):\n  \n   months=range(i,min(i+width,13))\n   a('<tr>')\n   for m in months:\n    a('<td>')\n    a(self.formatmonth(theyear,m,withyear=False ))\n    a('</td>')\n   a('</tr>')\n  a('</table>')\n  return ''.join(v)\n  \n def formatyearpage(self,theyear,width=3,css='calendar.css',encoding=None ):\n  ''\n\n  \n  if encoding is None :\n   encoding=sys.getdefaultencoding()\n  v=[]\n  a=v.append\n  a('<?xml version=\"1.0\" encoding=\"%s\"?>\\n'%encoding)\n  a('<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\\n')\n  a('<html>\\n')\n  a('<head>\\n')\n  a('<meta http-equiv=\"Content-Type\" content=\"text/html; charset=%s\" />\\n'%encoding)\n  if css is not None :\n   a('<link rel=\"stylesheet\" type=\"text/css\" href=\"%s\" />\\n'%css)\n  a('<title>Calendar for %d</title>\\n'%theyear)\n  a('</head>\\n')\n  a('<body>\\n')\n  a(self.formatyear(theyear,width))\n  a('</body>\\n')\n  a('</html>\\n')\n  return ''.join(v).encode(encoding,\"xmlcharrefreplace\")\n  \n  \nclass different_locale:\n def __init__(self,locale):\n  self.locale=locale\n  \n def __enter__(self):\n  self.oldlocale=_locale.getlocale(_locale.LC_TIME)\n  _locale.setlocale(_locale.LC_TIME,self.locale)\n  \n def __exit__(self,*args):\n  _locale.setlocale(_locale.LC_TIME,self.oldlocale)\n  \n  \nclass LocaleTextCalendar(TextCalendar):\n ''\n\n\n\n\n \n \n def __init__(self,firstweekday=0,locale=None ):\n  TextCalendar.__init__(self,firstweekday)\n  if locale is None :\n   locale=_locale.getdefaultlocale()\n  self.locale=locale\n  \n def formatweekday(self,day,width):\n  with different_locale(self.locale):\n   return super().formatweekday(day,width)\n   \n def formatmonthname(self,theyear,themonth,width,withyear=True ):\n  with different_locale(self.locale):\n   return super().formatmonthname(theyear,themonth,width,withyear)\n   \n   \nclass LocaleHTMLCalendar(HTMLCalendar):\n ''\n\n\n\n\n \n def __init__(self,firstweekday=0,locale=None ):\n  HTMLCalendar.__init__(self,firstweekday)\n  if locale is None :\n   locale=_locale.getdefaultlocale()\n  self.locale=locale\n  \n def formatweekday(self,day):\n  with different_locale(self.locale):\n   return super().formatweekday(day)\n   \n def formatmonthname(self,theyear,themonth,withyear=True ):\n  with different_locale(self.locale):\n   return super().formatmonthname(theyear,themonth,withyear)\n   \n   \nc=TextCalendar()\n\nfirstweekday=c.getfirstweekday\n\ndef setfirstweekday(firstweekday):\n if not MONDAY <=firstweekday <=SUNDAY:\n  raise IllegalWeekdayError(firstweekday)\n c.firstweekday=firstweekday\n \nmonthcalendar=c.monthdayscalendar\nprweek=c.prweek\nweek=c.formatweek\nweekheader=c.formatweekheader\nprmonth=c.prmonth\nmonth=c.formatmonth\ncalendar=c.formatyear\nprcal=c.pryear\n\n\n\n_colwidth=7 *3 -1\n_spacing=6\n\n\ndef format(cols,colwidth=_colwidth,spacing=_spacing):\n ''\n print(formatstring(cols,colwidth,spacing))\n \n \ndef formatstring(cols,colwidth=_colwidth,spacing=_spacing):\n ''\n spacing *=' '\n return spacing.join(c.center(colwidth)for c in cols)\n \n \nEPOCH=1970\n_EPOCH_ORD=datetime.date(EPOCH,1,1).toordinal()\n\n\ndef timegm(tuple):\n ''\n year,month,day,hour,minute,second=tuple[:6]\n days=datetime.date(year,month,1).toordinal()-_EPOCH_ORD+day -1\n hours=days *24+hour\n minutes=hours *60+minute\n seconds=minutes *60+second\n return seconds\n \n \ndef main(args):\n import argparse\n parser=argparse.ArgumentParser()\n textgroup=parser.add_argument_group('text only arguments')\n htmlgroup=parser.add_argument_group('html only arguments')\n textgroup.add_argument(\n \"-w\",\"--width\",\n type=int,default=2,\n help=\"width of date column (default 2)\"\n )\n textgroup.add_argument(\n \"-l\",\"--lines\",\n type=int,default=1,\n help=\"number of lines for each week (default 1)\"\n )\n textgroup.add_argument(\n \"-s\",\"--spacing\",\n type=int,default=6,\n help=\"spacing between months (default 6)\"\n )\n textgroup.add_argument(\n \"-m\",\"--months\",\n type=int,default=3,\n help=\"months per row (default 3)\"\n )\n htmlgroup.add_argument(\n \"-c\",\"--css\",\n default=\"calendar.css\",\n help=\"CSS to use for page\"\n )\n parser.add_argument(\n \"-L\",\"--locale\",\n default=None ,\n help=\"locale to be used from month and weekday names\"\n )\n parser.add_argument(\n \"-e\",\"--encoding\",\n default=None ,\n help=\"encoding to use for output\"\n )\n parser.add_argument(\n \"-t\",\"--type\",\n default=\"text\",\n choices=(\"text\",\"html\"),\n help=\"output type (text or html)\"\n )\n parser.add_argument(\n \"year\",\n nargs='?',type=int,\n help=\"year number (1-9999)\"\n )\n parser.add_argument(\n \"month\",\n nargs='?',type=int,\n help=\"month number (1-12, text only)\"\n )\n \n options=parser.parse_args(args[1:])\n \n if options.locale and not options.encoding:\n  parser.error(\"if --locale is specified --encoding is required\")\n  sys.exit(1)\n  \n locale=options.locale,options.encoding\n \n if options.type ==\"html\":\n  if options.locale:\n   cal=LocaleHTMLCalendar(locale=locale)\n  else :\n   cal=HTMLCalendar()\n  encoding=options.encoding\n  if encoding is None :\n   encoding=sys.getdefaultencoding()\n  optdict=dict(encoding=encoding,css=options.css)\n  write=sys.stdout.buffer.write\n  if options.year is None :\n   write(cal.formatyearpage(datetime.date.today().year,**optdict))\n  elif options.month is None :\n   write(cal.formatyearpage(options.year,**optdict))\n  else :\n   parser.error(\"incorrect number of arguments\")\n   sys.exit(1)\n else :\n  if options.locale:\n   cal=LocaleTextCalendar(locale=locale)\n  else :\n   cal=TextCalendar()\n  optdict=dict(w=options.width,l=options.lines)\n  if options.month is None :\n   optdict[\"c\"]=options.spacing\n   optdict[\"m\"]=options.months\n  if options.year is None :\n   result=cal.formatyear(datetime.date.today().year,**optdict)\n  elif options.month is None :\n   result=cal.formatyear(options.year,**optdict)\n  else :\n   result=cal.formatmonth(options.year,options.month,**optdict)\n  write=sys.stdout.write\n  if options.encoding:\n   result=result.encode(options.encoding)\n   write=sys.stdout.buffer.write\n  write(result)\n  \n  \nif __name__ ==\"__main__\":\n main(sys.argv)\n", ["argparse", "datetime", "itertools", "locale", "sys"]], "cmath": [".py", "\n\n\n\n\n\n\n\n\n\nimport math\nimport sys\n\ndef _takes_complex(func):\n def decorated(x):\n  if isinstance(x,complex):\n   return func(x)\n  elif type(x)in [int,float]:\n   return func(complex(x))\n  elif hasattr(x,'__complex__'):\n   c=x.__complex__()\n   if not isinstance(c,complex):\n    raise TypeError(\"A complex number is required\")\n   else :\n    return func(c)\n  elif hasattr(x,'__float__'):\n   try :\n    c=complex(x.__float__(),0)\n   except :\n    raise TypeError(\"A complex number is required\")\n   return func(c)\n  elif hasattr(x,'__index__'):\n   try :\n    c=complex(x.__index__(),0)\n   except :\n    raise TypeError(\"A complex number is required\")\n   return func(c)\n  else :\n   raise TypeError(\"A complex number is required\")\n if hasattr(func,'__doc__'):\n  decorated.__doc__=func.__doc__\n if hasattr(func,'__name__'):\n  decorated.__name__=func.__name__\n return decorated\n \n@_takes_complex\ndef isfinite(x):\n return math.isfinite(x.imag)and math.isfinite(x.real)\n \n@_takes_complex\ndef phase(x):\n ''\n return math.atan2(x.imag,x.real)\n \n@_takes_complex\ndef polar(x):\n ''\n\n\n\n\n \n phi=math.atan2(x.imag,x.real)\n if math.isnan(x.imag):\n  if math.isinf(x.real):\n   return abs(x.real),nan\n  return nan,nan\n elif math.isinf(x.imag):\n  r=inf\n elif math.isinf(x.real):\n  r=inf\n else :\n  r=math.sqrt(x.real **2+x.imag **2)\n  if math.isinf(r):\n   raise OverflowError(\"math range error\")\n return r,phi\n \ndef rect(r,phi):\n ''\n\n \n if math.isnan(r):\n  if not math.isnan(phi)and not phi:\n   return complex(nan,0)\n  return complex(nan,nan)\n elif math.isnan(phi):\n  if not r:\n   return complex(0,0)\n  elif math.isinf(r):\n   return complex(inf,nan)\n  return complex(nan,nan)\n if math.isinf(r)or math.isinf(phi):\n \n \n  if math.isinf(phi)and r !=.0 and not math.isnan(r):\n   raise ValueError(\"math domain error\")\n   \n   \n   \n   \n  if -inf <phi <inf and phi !=.0:\n   if r >0:\n    _real=math.copysign(inf,math.cos(phi))\n    _imag=math.copysign(inf,math.sin(phi))\n   else :\n    _real=-math.copysign(inf,math.cos(phi));\n    _imag=-math.copysign(inf,math.sin(phi));\n   return complex(_real,_imag)\n  return _SPECIAL_VALUE(complex(r,phi),_rect_special_values)\n  \n else :\n  if phi ==.0:\n  \n  \n  \n   return complex(r,phi *r)\n  else :\n   return complex(r *math.cos(phi),r *math.sin(phi))\n   \n@_takes_complex\ndef sqrt(x):\n ''\n\n\n\n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n s,d,ax,ay=.0,.0,math.fabs(x.real),math.fabs(x.imag)\n \n ret=_SPECIAL_VALUE(x,_sqrt_special_values)\n if ret is not None :\n  return ret\n  \n if math.isinf(x.imag):\n  return complex(inf,x.imag)\n  \n if x.real ==.0 and x.imag ==.0:\n  _real=.0\n  _imag=x.imag\n  return complex(_real,_imag)\n  \n if ay ==0:\n  s=math.sqrt(ax)\n  d=0\n elif ax <sys.float_info.min and ay <sys.float_info.min and (ax >0. or ay >0.):\n \n  AX=math.ldexp(ax,_CM_SCALE_UP)\n  AY=math.ldexp(ay,_CM_SCALE_UP)\n  S=math.sqrt((AX+math.hypot(AX,AY))/2.0)\n  D=AY /(2 *S)\n  s=math.ldexp(S,_CM_SCALE_DOWN)\n  d=math.ldexp(D,_CM_SCALE_DOWN)\n else :\n  ax /=8.0 ;\n  s=2.0 *math.sqrt(ax+math.hypot(ax,ay /8.0));\n  d=ay /(2.0 *s)\n  \n if x.real >=.0:\n  _real=s ;\n  _imag=math.copysign(d,x.imag)\n else :\n  _real=d ;\n  _imag=math.copysign(s,x.imag)\n  \n return complex(_real,_imag)\n \n@_takes_complex\ndef acos(x):\n ''\n\n\n\n\n \n \n ret=_SPECIAL_VALUE(x,_acos_special_values)\n if ret is not None :\n  if isinstance(ret,Exception):\n   raise ret\n  return ret\n  \n if math.fabs(x.real)>_CM_LARGE_DOUBLE or math.fabs(x.imag)>_CM_LARGE_DOUBLE:\n \n  _real=math.atan2(math.fabs(x.imag),x.real)\n  \n  \n  \n  if x.real <0:\n   _imag=-math.copysign(math.log(math.hypot(x.real /2.,x.imag /2.))+_M_LN2 *2.,x.imag);\n  else :\n   _imag=math.copysign(math.log(math.hypot(x.real /2.,x.imag /2.))+_M_LN2 *2.,-x.imag);\n elif math.isnan(x.real):\n  return complex(nan,nan)\n elif math.isnan(x.imag):\n  if x.real ==0:\n   return complex(pi /2,nan)\n  return complex(nan,nan)\n else :\n  s1=complex(float(1 -x.real),-x.imag)\n  s1=sqrt(s1)\n  s2=complex(1.0+x.real,x.imag)\n  s2=sqrt(s2)\n  _real=2.0 *math.atan2(s1.real,s2.real)\n  _imag=math.asinh(s2.real *s1.imag -s2.imag *s1.real)\n  if not x.imag:\n   if x.real >1:\n    _real=0\n   elif x.real <-1:\n    _real=math.pi\n    \n return complex(_real,_imag)\n \n@_takes_complex\ndef acosh(x):\n ''\n\n\n\n \n ret=_SPECIAL_VALUE(x,_acosh_special_values)\n if ret is not None :\n  return ret\n  \n if math.fabs(x.real)>_CM_LARGE_DOUBLE or math.fabs(x.imag)>_CM_LARGE_DOUBLE:\n \n  _real=math.log(math.hypot(x.real /2.0,x.imag /2.0))+_M_LN2 *2.0\n  _imag=math.atan2(x.imag,x.real);\n else :\n  s1=sqrt(complex(x.real -1.0,x.imag))\n  s2=sqrt(complex(x.real+1.0,x.imag))\n  _real=math.asinh(s1.real *s2.real+s1.imag *s2.imag)\n  _imag=2. *math.atan2(s1.imag,s2.real)\n  \n return complex(_real,_imag)\n \n@_takes_complex\ndef asin(x):\n ''\n\n\n\n \n \n s=complex(-x.imag,x.real)\n s=asinh(s)\n return complex(s.imag,-s.real)\n \n@_takes_complex\ndef asinh(x):\n ''\n\n\n\n\n \n ret=_SPECIAL_VALUE(x,_asinh_special_values)\n if ret is not None :\n  return ret\n  \n if math.fabs(x.real)>_CM_LARGE_DOUBLE or math.fabs(x.imag)>_CM_LARGE_DOUBLE:\n  if x.imag >=.0:\n   _real=math.copysign(math.log(math.hypot(x.real /2.,x.imag /2.))+_M_LN2 *2.,x.real)\n  else :\n   _real=-math.copysign(math.log(math.hypot(x.real /2.,x.imag /2.))+_M_LN2 *2.,-x.real)\n  _imag=math.atan2(x.imag,math.fabs(x.real))\n else :\n  s1=sqrt(complex(1.0+x.imag,-x.real))\n  s2=sqrt(complex(1.0 -x.imag,x.real))\n  _real=math.asinh(s1.real *s2.imag -s2.real *s1.imag)\n  _imag=math.atan2(x.imag,s1.real *s2.real -s1.imag *s2.imag)\n return complex(_real,_imag)\n \n@_takes_complex\ndef atan(x):\n ''\n\n\n\n\n \n ret=_SPECIAL_VALUE(x,_atan_special_values)\n if ret is not None :\n  return ret\n  \n if isinf(x):\n  return complex(math.copysign(1,x.real)*pi /2,\n  math.copysign(0,x.imag))\n s=atanh(complex(-x.imag,x.real))\n return complex(s.imag,-s.real)\n \n@_takes_complex\ndef atanh(x):\n ''\n\n\n\n\n \n \n ret=_SPECIAL_VALUE(x,_atanh_special_values)\n if ret is not None :\n  return ret\n  \n if isinf(x):\n  return complex(math.copysign(0,x.real),\n  math.copysign(1,x.imag)*pi /2)\n  \n  \n if x.real <.0:\n  return -(atanh(-x))\n  \n ay=math.fabs(x.imag)\n \n if x.real >_CM_SQRT_LARGE_DOUBLE or ay >_CM_SQRT_LARGE_DOUBLE:\n \n \n \n \n \n  h=math.hypot(x.real /2.,x.imag /2.)\n  _real=x.real /4. /h /h\n  \n  \n  \n  \n  \n  \n  _imag=-math.copysign(math.pi /2.,-x.imag)\n  \n elif x.real ==1.0 and ay <_CM_SQRT_DBL_MIN:\n \n \n  if (ay ==.0):\n   raise ValueError(\"math domain error\")\n  else :\n   _real=-math.log(math.sqrt(ay)/math.sqrt(math.hypot(ay,2.)))\n   _imag=math.copysign(math.atan2(2.0,-ay)/2,x.imag)\n   \n else :\n \n  _real=math.log1p(4. *x.real /((1 -x.real)*(1 -x.real)+ay *ay))/4.\n  _imag=-math.atan2(-2. *x.imag,(1 -x.real)*(1+x.real)-ay *ay)/2.\n  errno=0\n  \n return complex(_real,_imag)\n \n@_takes_complex\ndef cos(x):\n ''\n return cosh(complex(-x.imag,x.real))\n \n@_takes_complex\ndef cosh(x):\n ''\n \n ret=_SPECIAL_VALUE(x,_cosh_special_values)\n if ret is not None :\n  if isinstance(ret,Exception):\n   raise ret\n  return ret\n  \n if not math.isinf(x.real)and math.fabs(x.real)>_CM_LOG_LARGE_DOUBLE:\n \n \n  x_minus_one=x.real -math.copysign(1.0,x.real)\n  _real=cos(x.imag)*math.cosh(x_minus_one)*math.e\n  _imag=sin(x.imag)*math.sinh(x_minus_one)*math.e\n elif math.isinf(x.real)and x.imag ==0:\n  if x.real >0:\n   return x\n  else :\n   return complex(inf,-x.imag)\n elif math.isinf(x.imag):\n  raise ValueError(\"math domain error\")\n else :\n  _real=math.cos(x.imag)*math.cosh(x.real)\n  _imag=math.sin(x.imag)*math.sinh(x.real)\n  \n ret=complex(_real,_imag)\n return ret\n \n@_takes_complex\ndef exp(x):\n ''\n if math.isinf(x.real)or math.isinf(x.imag):\n \n  if math.isinf(x.imag)and (-inf <x.real <inf or math.isinf(x.real)and x.real >0):\n   raise ValueError(\"math domain error\")\n   \n  if math.isinf(x.real)and -inf <x.imag <inf and x.imag !=.0:\n   if x.real >0:\n    _real=math.copysign(inf,math.cos(x.imag))\n    _imag=math.copysign(inf,math.sin(x.imag))\n   else :\n    _real=math.copysign(.0,math.cos(x.imag))\n    _imag=math.copysign(.0,math.sin(x.imag))\n   return complex(_real,_imag)\n   \n  return _SPECIAL_VALUE(x,_exp_special_values)\n  \n if math.isnan(x.real)and x.imag ==0:\n  return x\n  \n if x.real >_CM_LOG_LARGE_DOUBLE:\n  l=math.exp(x.real -1.);\n  _real=l *math.cos(x.imag)*math.e\n  _imag=l *math.sin(x.imag)*math.e\n else :\n  l=math.exp(x.real);\n  _real=l *math.cos(x.imag)\n  _imag=l *math.sin(x.imag)\n  \n if math.isinf(_real)or math.isinf(_imag):\n  raise OverflowError()\n  \n return complex(_real,_imag)\n \ndef isclose(x,y,*,rel_tol=1e-09,abs_tol=0.0):\n try :\n  complex(x)\n except ValueError:\n  raise TypeError(f\"must be a number, not {x.__class__.__name__}\")\n try :\n  complex(y)\n except ValueError:\n  raise TypeError(f\"must be a number, not {y.__class__.__name__}\")\n rel_tol=float(rel_tol)\n abs_tol=float(abs_tol)\n if rel_tol <0.0 or abs_tol <0.0:\n  raise ValueError('tolerances must be non-negative')\n if x is inf or x is _NINF or y is inf or y is _NINF:\n  return y is x\n if x is nan or y is nan:\n  return False\n return abs(x -y)<=max(rel_tol *float(max(abs(x),abs(y))),abs_tol)\n \n@_takes_complex\ndef isinf(x):\n ''\n return math.isinf(x.real)or math.isinf(x.imag)\n \n@_takes_complex\ndef isnan(x):\n ''\n return math.isnan(x.real)or math.isnan(x.imag)\n \n \n@_takes_complex\ndef _to_complex(x):\n return x\n \ndef log(x,base=None ):\n ''\n\n\n\n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n x=_to_complex(x)\n \n \n \n \n \n \n denom=1 if base is None else log(base)\n ''\n\n\n\n \n \n ret=_SPECIAL_VALUE(x,_log_special_values)\n if ret is not None :\n  return ret\n  \n if math.isnan(x.real):\n  return complex(inf if math.isinf(x.imag)else nan,nan)\n elif math.isnan(x.imag):\n  return complex(inf if math.isinf(x.real)else nan,nan)\n  \n ax=math.fabs(x.real)\n ay=math.fabs(x.imag)\n \n if ax >_CM_LARGE_DOUBLE or ay >_CM_LARGE_DOUBLE:\n  _real=math.log(math.hypot(ax /2.0,ay /2.0))+_M_LN2\n elif ax <sys.float_info.min and ay <sys.float_info.min:\n  if ax >.0 or ay >.0:\n  \n   _real=math.log(math.hypot(math.ldexp(ax,sys.float_info.mant_dig),math.ldexp(ay,sys.float_info.mant_dig)))-sys.float_info.mant_dig *_M_LN2\n  else :\n  \n   raise ValueError(\"math domain error\")\n   _real=-inf\n   _imag=math.atan2(x.imag,x.real)\n else :\n  h=math.hypot(ax,ay)\n  _real=math.log(h)/denom\n if not ay:\n  if type(_real)==complex:\n   return _real\n  if x.real <0:\n   return complex(_real,math.copysign(math.pi,x.imag))\n  return complex(_real,x.imag)\n _imag=math.atan2(x.imag,x.real)\n return complex(_real,_imag)\n \n@_takes_complex\ndef log10(x):\n ''\n\n\n\n \n ret=log(x)\n _real=ret.real /_M_LN10\n _imag=ret.imag /_M_LN10\n return complex(_real,_imag)\n \n@_takes_complex\ndef sin(x):\n ''\n \n s=complex(-x.imag,x.real)\n s=sinh(s)\n return complex(s.imag,-s.real)\n \n@_takes_complex\ndef sinh(x):\n ''\n \n ret=_SPECIAL_VALUE(x,_sinh_special_values)\n if ret is not None :\n  if isinstance(ret,Exception):\n   raise ret\n  return ret\n  \n if math.isinf(x.real)or math.isinf(x.imag):\n \n \n  if math.isinf(x.imag)and not math.isnan(x.real):\n   raise ValueError(\"math domain error\")\n   \n  if math.isinf(x.real)and -inf <x.imag <inf and x.imag !=.0:\n   if x.real >0:\n    _real=math.copysign(inf,math.cos(x.imag))\n    _imag=math.copysign(inf,math.sin(x.imag))\n   else :\n    _real=-math.copysign(inf,math.cos(x.imag))\n    _imag=math.copysign(inf,math.sin(x.imag))\n   return complex(_real,_imag)\n   \n  return _SPECIAL_VALUE(x,_sinh_special_values)\n  \n if math.fabs(x.real)>_CM_LOG_LARGE_DOUBLE:\n  x_minus_one=x.real -math.copysign(1.0,x.real)\n  z=complex(x_minus_one,x.imag)\n  _real=math.cos(z.imag)*math.sinh(z.real)*math.e\n  _imag=math.sin(z.imag)*math.cosh(z.real)*math.e\n else :\n  _real=math.cos(x.imag)*math.sinh(x.real)\n  _imag=math.sin(x.imag)*math.cosh(x.real)\n  \n if math.isinf(_real)or math.isinf(_imag):\n  raise OverflowError()\n  \n return complex(_real,_imag)\n \n@_takes_complex\ndef tan(x):\n ''\n if math.isnan(x.real):\n  if math.isinf(x.imag):\n   return complex(0,math.copysign(1,x.imag))\n  return complex(nan,nan)\n elif math.isnan(x.imag):\n  if not x.real:\n   return complex(math.copysign(0,x.real),nan)\n  return complex(nan,nan)\n s=tanh(complex(-x.imag,x.real))\n return complex(s.imag,-s.real)\n \n@_takes_complex\ndef tanh(x):\n ''\n ''\n\n\n \n \n \n \n \n \n \n \n \n \n if math.isnan(x.real):\n  if x.imag ==0:\n   return complex(nan,math.copysign(0,x.imag))\n  return complex(nan,nan)\n elif math.isnan(x.imag):\n  if math.isinf(x.real):\n   return complex(math.copysign(1,x.real),0)\n  return complex(nan,nan)\n  \n if isinf(x):\n  if math.isinf(x.imag)and -inf <x.real <inf:\n   raise ValueError(\"math domain error\")\n   \n   \n  if math.isinf(x.real)and -inf <x.imag <inf and x.imag !=.0:\n   if x.real >0:\n    _real=1.0\n    _imag=math.copysign(.0,2.0 *math.sin(x.imag)*math.cos(x.imag))\n   else :\n    _real=-1.0\n    _imag=math.copysign(.0,2. *math.sin(x.imag)*math.cos(x.imag))\n   return complex(_real,_imag)\n  return _SPECIAL_VALUE(x,_tanh_special_values)\n  \n  \n if math.fabs(x.real)>_CM_LOG_LARGE_DOUBLE:\n  _real=math.copysign(1.,x.real)\n  _imag=4. *math.sin(x.imag)*math.cos(x.imag)*math.exp(-2. *math.fabs(x.real))\n else :\n  tx=math.tanh(x.real)\n  ty=math.tan(x.imag)\n  cx=1.0 /math.cosh(x.real)\n  txty=tx *ty\n  denom=1.+txty *txty\n  _real=tx *(1.+ty *ty)/denom\n  _imag=((ty /denom)*cx)*cx\n return complex(_real,_imag)\n \n \nFunctionType=type(_takes_complex)\nlocs=locals()\nkeys=list(locs.keys())\nfor f in keys:\n if type(locs[f])is FunctionType and not f.startswith(\"_\"):\n  locals()[f]=type(abs)(locals()[f])\n  \npi=math.pi\ne=math.e\ntau=math.tau\n\n_CM_LARGE_DOUBLE=sys.float_info.max /4\n_CM_SQRT_LARGE_DOUBLE=math.sqrt(_CM_LARGE_DOUBLE)\n_CM_LOG_LARGE_DOUBLE=math.log(_CM_LARGE_DOUBLE)\n_CM_SQRT_DBL_MIN=math.sqrt(sys.float_info.min)\n_M_LN2=0.6931471805599453094\n_M_LN10=2.302585092994045684\n\nif sys.float_info.radix ==2:\n _CM_SCALE_UP=int((2 *(sys.float_info.mant_dig /2)+1))\nelif sys.float_info.radix ==16:\n _CM_SCALE_UP=int((4 *sys.float_info.mant_dig+1))\nelse :\n raise (\"cmath implementation expects the float base to be either 2 or 16, got \"+str(sys.float_info.radix)+\" instead.\")\n_CM_SCALE_DOWN=int((-(_CM_SCALE_UP+1)/2))\n\ninf=float('inf')\ninfj=complex(0.0,inf)\n_NINF=float('-inf')\nnan=float('nan')\nnanj=complex(0.0,float('nan'))\n\n_P14=0.25 *pi\n_P12=0.5 *pi\n_P34=0.75 *pi\n_U=-9.5426319407711027e33\n\n\n_ST_NINF=0\n_ST_NEG=1\n_ST_NZERO=2\n_ST_PZERO=3\n_ST_POS=4\n_ST_PINF=5\n_ST_NAN=6\n\n\ndef _SPECIAL_VALUE(z,table):\n if not math.isfinite(z.real)or not math.isfinite(z.imag):\n  return table[_special_type(z.real)][_special_type(z.imag)]\n else :\n  return None\n  \ndef _special_type(x):\n if -inf <x <inf:\n  if x !=0:\n   if math.copysign(1.0,x)==1.0:\n    return _ST_POS\n   else :\n    return _ST_NEG\n  else :\n   if math.copysign(1.0,x)==1.0:\n    return _ST_PZERO\n   else :\n    return _ST_NZERO\n if math.isnan(x):\n  return _ST_NAN\n if math.copysign(1.0,x)==1.0:\n  return _ST_PINF\n else :\n  return _ST_NINF\n  \n_acos_special_values=[\n[complex(2.356194490192345,inf),None ,complex(3.141592653589793,inf),complex(3.141592653589793,-inf),None ,complex(2.356194490192345,-inf),complex(nan,inf)],\n[None ,None ,None ,None ,None ,None ,None ],\n[complex(1.5707963267948966,inf),None ,complex(1.5707963267948966,0.0),complex(1.5707963267948966,-0.0),None ,complex(1.5707963267948966,-inf),complex(1.5707963267948966,nan)],\n[complex(1.5707963267948966,inf),None ,complex(1.5707963267948966,0.0),complex(1.5707963267948966,-0.0),None ,complex(1.5707963267948966,-inf),complex(1.5707963267948966,nan)],\n[None ,None ,None ,None ,None ,None ,None ],\n[complex(0.7853981633974483,inf),None ,complex(0.0,inf),complex(0.0,-inf),None ,complex(0.7853981633974483,-inf),complex(nan,inf)],\n[complex(nan,inf),None ,complex(nan,nan),complex(nan,nan),None ,complex(nan,-inf),complex(nan,nan)],\n]\n\n_acosh_special_values=[\n[complex(inf,-2.356194490192345),None ,complex(inf,-3.141592653589793),complex(inf,3.141592653589793),None ,complex(inf,2.356194490192345),complex(inf,nan)],\n[None ,None ,None ,None ,None ,None ,None ],\n[complex(inf,-1.5707963267948966),None ,complex(0.0,-1.5707963267948966),complex(0.0,1.5707963267948966),None ,complex(inf,1.5707963267948966),complex(nan,nan)],\n[complex(inf,-1.5707963267948966),None ,complex(0.0,-1.5707963267948966),complex(0.0,1.5707963267948966),None ,complex(inf,1.5707963267948966),complex(nan,nan)],\n[None ,None ,None ,None ,None ,None ,None ],\n[complex(inf,-0.7853981633974483),None ,complex(inf,-0.0),complex(inf,0.0),None ,complex(inf,0.7853981633974483),complex(inf,nan)],\n[complex(inf,nan),None ,complex(nan,nan),complex(nan,nan),None ,complex(inf,nan),complex(nan,nan)],\n]\n\n_asinh_special_values=[\n[complex(-inf,-0.7853981633974483),None ,complex(-inf,-0.0),complex(-inf,0.0),None ,complex(-inf,0.7853981633974483),complex(-inf,nan)],\n[None ,None ,None ,None ,None ,None ,None ],\n[complex(-inf,-1.5707963267948966),None ,complex(-0.0,-0.0),complex(-0.0,0.0),None ,complex(-inf,1.5707963267948966),complex(nan,nan)],\n[complex(inf,-1.5707963267948966),None ,complex(0.0,-0.0),complex(0.0,0.0),None ,complex(inf,1.5707963267948966),complex(nan,nan)],\n[None ,None ,None ,None ,None ,None ,None ],\n[complex(inf,-0.7853981633974483),None ,complex(inf,-0.0),complex(inf,0.0),None ,complex(inf,0.7853981633974483),complex(inf,nan)],\n[complex(inf,nan),None ,complex(nan,-0.0),complex(nan,0.0),None ,complex(inf,nan),complex(nan,nan)],\n]\n\n_atan_special_values=[\n[complex(-1.5707963267948966,-0.0),None ,complex(-1.5707963267948966,-0.0),complex(-1.5707963267948966,0.0),None ,complex(-1.5707963267948966,0.0),complex(-1.5707963267948966,-0.0)],\n[None ,None ,None ,None ,None ,None ,None ],\n[complex(-1.5707963267948966,-0.0),None ,complex(-0.0,-0.0),complex(-0.0,0.0),None ,complex(-1.5707963267948966,0.0),complex(nan,nan)],\n[complex(1.5707963267948966,-0.0),None ,complex(0.0,-0.0),complex(0.0,0.0),None ,complex(1.5707963267948966,0.0),complex(nan,nan)],\n[None ,None ,None ,None ,None ,None ,None ],\n[complex(1.5707963267948966,-0.0),None ,complex(1.5707963267948966,-0.0),complex(1.5707963267948966,0.0),None ,complex(1.5707963267948966,0.0),complex(1.5707963267948966,-0.0)],\n[complex(nan,-0.0),None ,complex(nan,-0.0),complex(nan,0.0),None ,complex(nan,0.0),complex(nan,nan)],\n]\n\n_atanh_special_values=[\n[complex(-0.0,-1.5707963267948966),None ,complex(-0.0,-1.5707963267948966),complex(-0.0,1.5707963267948966),None ,complex(-0.0,1.5707963267948966),complex(-0.0,nan)],\n[None ,None ,None ,None ,None ,None ,None ],\n[complex(-0.0,-1.5707963267948966),None ,complex(-0.0,-0.0),complex(-0.0,0.0),None ,complex(-0.0,1.5707963267948966),complex(-0.0,nan)],\n[complex(0.0,-1.5707963267948966),None ,complex(0.0,-0.0),complex(0.0,0.0),None ,complex(0.0,1.5707963267948966),complex(0.0,nan)],\n[None ,None ,None ,None ,None ,None ,None ],\n[complex(0.0,-1.5707963267948966),None ,complex(0.0,-1.5707963267948966),complex(0.0,1.5707963267948966),None ,complex(0.0,1.5707963267948966),complex(0.0,nan)],\n[complex(0.0,-1.5707963267948966),None ,complex(nan,nan),complex(nan,nan),None ,complex(0.0,1.5707963267948966),complex(nan,nan)],\n]\n\n_cosh_special_values=[\n[ValueError('math domain error'),None ,complex(inf,0.0),complex(inf,-0.0),None ,ValueError('math domain error'),complex(inf,nan)],\n[None ,None ,None ,None ,None ,None ,None ],\n[ValueError('math domain error'),None ,complex(1.0,0.0),complex(1.0,-0.0),None ,ValueError('math domain error'),complex(nan,0.0)],\n[ValueError('math domain error'),None ,complex(1.0,-0.0),complex(1.0,0.0),None ,ValueError('math domain error'),complex(nan,0.0)],\n[None ,None ,None ,None ,None ,None ,None ],\n[ValueError('math domain error'),None ,complex(inf,-0.0),complex(inf,0.0),None ,ValueError('math domain error'),complex(inf,nan)],\n[complex(nan,nan),None ,complex(nan,0.0),complex(nan,0.0),None ,complex(nan,nan),complex(nan,nan)],\n]\n\n_exp_special_values=[\n[complex(0.0,0.0),None ,complex(0.0,-0.0),complex(0.0,0.0),None ,complex(0.0,0.0),complex(0.0,0.0)],\n[None ,None ,None ,None ,None ,None ,None ],\n[ValueError('math domain error'),None ,complex(1.0,-0.0),complex(1.0,0.0),None ,ValueError('math domain error'),complex(nan,nan)],\n[ValueError('math domain error'),None ,complex(1.0,-0.0),complex(1.0,0.0),None ,ValueError('math domain error'),complex(nan,nan)],\n[None ,None ,None ,None ,None ,None ,None ],\n[ValueError('math domain error'),None ,complex(inf,-0.0),complex(inf,0.0),None ,ValueError('math domain error'),complex(inf,nan)],\n[complex(nan,nan),None ,complex(nan,-0.0),complex(nan,0.0),None ,complex(nan,nan),complex(nan,nan)],\n]\n\n_log_special_values=[\n[complex(inf,-2.356194490192345),None ,complex(inf,-3.141592653589793),complex(inf,3.141592653589793),None ,complex(inf,2.356194490192345),complex(inf,nan)],\n[None ,None ,None ,None ,None ,None ,None ],\n[complex(inf,-1.5707963267948966),None ,ValueError('math domain error'),ValueError('math domain error'),None ,complex(inf,1.5707963267948966),complex(nan,nan)],\n[complex(inf,-1.5707963267948966),None ,ValueError('math domain error'),ValueError('math domain error'),None ,complex(inf,1.5707963267948966),complex(nan,nan)],\n[None ,None ,None ,None ,None ,None ,None ],\n[complex(inf,-0.7853981633974483),None ,complex(inf,-0.0),complex(inf,0.0),None ,complex(inf,0.7853981633974483),complex(inf,nan)],\n[complex(inf,nan),None ,complex(nan,nan),complex(nan,nan),None ,complex(inf,nan),complex(nan,nan)],\n]\n\n_sinh_special_values=[\n[ValueError('math domain error'),None ,complex(-inf,-0.0),complex(-inf,0.0),None ,ValueError('math domain error'),complex(inf,nan)],\n[None ,None ,None ,None ,None ,None ,None ],\n[ValueError('math domain error'),None ,complex(-0.0,-0.0),complex(-0.0,0.0),None ,ValueError('math domain error'),complex(0.0,nan)],\n[ValueError('math domain error'),None ,complex(0.0,-0.0),complex(0.0,0.0),None ,ValueError('math domain error'),complex(0.0,nan)],\n[None ,None ,None ,None ,None ,None ,None ],\n[ValueError('math domain error'),None ,complex(inf,-0.0),complex(inf,0.0),None ,ValueError('math domain error'),complex(inf,nan)],\n[complex(nan,nan),None ,complex(nan,-0.0),complex(nan,0.0),None ,complex(nan,nan),complex(nan,nan)],\n]\n\n_sqrt_special_values=[\n[complex(inf,-inf),None ,complex(0.0,-inf),complex(0.0,inf),None ,complex(inf,inf),complex(nan,inf)],\n[None ,None ,None ,None ,None ,None ,None ],\n[complex(inf,-inf),None ,complex(0.0,-0.0),complex(0.0,0.0),None ,complex(inf,inf),complex(nan,nan)],\n[complex(inf,-inf),None ,complex(0.0,-0.0),complex(0.0,0.0),None ,complex(inf,inf),complex(nan,nan)],\n[None ,None ,None ,None ,None ,None ,None ],\n[complex(inf,-inf),None ,complex(inf,-0.0),complex(inf,0.0),None ,complex(inf,inf),complex(inf,nan)],\n[complex(inf,-inf),None ,complex(nan,nan),complex(nan,nan),None ,complex(inf,inf),complex(nan,nan)],\n]\n\n_tanh_special_values=[\n[complex(-1.0,0.0),None ,complex(-1.0,-0.0),complex(-1.0,0.0),None ,complex(-1.0,0.0),complex(-1.0,0.0)],\n[None ,None ,None ,None ,None ,None ,None ],\n[ValueError('math domain error'),None ,complex(-0.0,-0.0),complex(-0.0,0.0),None ,ValueError('math domain error'),complex(nan,nan)],\n[ValueError('math domain error'),None ,complex(0.0,-0.0),complex(0.0,0.0),None ,ValueError('math domain error'),complex(nan,nan)],\n[None ,None ,None ,None ,None ,None ,None ],\n[complex(1.0,0.0),None ,complex(1.0,-0.0),complex(1.0,0.0),None ,complex(1.0,0.0),complex(1.0,0.0)],\n[complex(nan,nan),None ,complex(nan,-0.0),complex(nan,0.0),None ,complex(nan,nan),complex(nan,nan)],\n]\n\n_rect_special_values=[\n[ValueError('math domain error'),complex(inf,inf),complex(-inf,0.0),complex(-inf,-0.0),complex(inf,-inf),ValueError('math domain error'),complex(inf,nan)],\n[ValueError('math domain error'),complex(0.8322936730942848,1.8185948536513634),complex(-2.0,0.0),complex(-2.0,-0.0),complex(0.8322936730942848,-1.8185948536513634),ValueError('math domain error'),complex(nan,nan)],\n[complex(0.0,0.0),complex(0.0,0.0),complex(-0.0,0.0),complex(-0.0,-0.0),complex(0.0,-0.0),complex(0.0,0.0),complex(0.0,0.0)],\n[complex(0.0,0.0),complex(-0.0,-0.0),complex(0.0,-0.0),complex(0.0,0.0),complex(-0.0,0.0),complex(0.0,0.0),complex(0.0,0.0)],\n[ValueError('math domain error'),complex(-0.8322936730942848,-1.8185948536513634),complex(2.0,-0.0),complex(2.0,0.0),complex(-0.8322936730942848,1.8185948536513634),ValueError('math domain error'),complex(nan,nan)],\n[ValueError('math domain error'),complex(-inf,-inf),complex(inf,-0.0),complex(inf,0.0),complex(-inf,inf),ValueError('math domain error'),complex(inf,nan)],\n[complex(nan,nan),complex(nan,nan),complex(nan,0.0),complex(nan,0.0),complex(nan,nan),complex(nan,nan),complex(nan,nan)],\n]\n\n\n\n", ["math", "sys"]], "cmd": [".py", "''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nimport string,sys\n\n__all__=[\"Cmd\"]\n\nPROMPT='(Cmd) '\nIDENTCHARS=string.ascii_letters+string.digits+'_'\n\nclass Cmd:\n ''\n\n\n\n\n\n\n\n\n\n \n prompt=PROMPT\n identchars=IDENTCHARS\n ruler='='\n lastcmd=''\n intro=None\n doc_leader=\"\"\n doc_header=\"Documented commands (type help <topic>):\"\n misc_header=\"Miscellaneous help topics:\"\n undoc_header=\"Undocumented commands:\"\n nohelp=\"*** No help on %s\"\n use_rawinput=1\n \n def __init__(self,completekey='tab',stdin=None ,stdout=None ):\n  ''\n\n\n\n\n\n\n\n\n  \n  if stdin is not None :\n   self.stdin=stdin\n  else :\n   self.stdin=sys.stdin\n  if stdout is not None :\n   self.stdout=stdout\n  else :\n   self.stdout=sys.stdout\n  self.cmdqueue=[]\n  self.completekey=completekey\n  \n def cmdloop(self,intro=None ):\n  ''\n\n\n\n  \n  \n  self.preloop()\n  if self.use_rawinput and self.completekey:\n   try :\n    import readline\n    self.old_completer=readline.get_completer()\n    readline.set_completer(self.complete)\n    readline.parse_and_bind(self.completekey+\": complete\")\n   except ImportError:\n    pass\n  try :\n   if intro is not None :\n    self.intro=intro\n   if self.intro:\n    self.stdout.write(str(self.intro)+\"\\n\")\n   stop=None\n   while not stop:\n    if self.cmdqueue:\n     line=self.cmdqueue.pop(0)\n    else :\n     if self.use_rawinput:\n      try :\n       line=input(self.prompt)\n      except EOFError:\n       line='EOF'\n     else :\n      self.stdout.write(self.prompt)\n      self.stdout.flush()\n      line=self.stdin.readline()\n      if not len(line):\n       line='EOF'\n      else :\n       line=line.rstrip('\\r\\n')\n    line=self.precmd(line)\n    stop=self.onecmd(line)\n    stop=self.postcmd(stop,line)\n   self.postloop()\n  finally :\n   if self.use_rawinput and self.completekey:\n    try :\n     import readline\n     readline.set_completer(self.old_completer)\n    except ImportError:\n     pass\n     \n     \n def precmd(self,line):\n  ''\n\n\n  \n  return line\n  \n def postcmd(self,stop,line):\n  ''\n  return stop\n  \n def preloop(self):\n  ''\n  pass\n  \n def postloop(self):\n  ''\n\n\n  \n  pass\n  \n def parseline(self,line):\n  ''\n\n\n  \n  line=line.strip()\n  if not line:\n   return None ,None ,line\n  elif line[0]=='?':\n   line='help '+line[1:]\n  elif line[0]=='!':\n   if hasattr(self,'do_shell'):\n    line='shell '+line[1:]\n   else :\n    return None ,None ,line\n  i,n=0,len(line)\n  while i <n and line[i]in self.identchars:i=i+1\n  cmd,arg=line[:i],line[i:].strip()\n  return cmd,arg,line\n  \n def onecmd(self,line):\n  ''\n\n\n\n\n\n\n\n  \n  cmd,arg,line=self.parseline(line)\n  if not line:\n   return self.emptyline()\n  if cmd is None :\n   return self.default(line)\n  self.lastcmd=line\n  if line =='EOF':\n   self.lastcmd=''\n  if cmd =='':\n   return self.default(line)\n  else :\n   try :\n    func=getattr(self,'do_'+cmd)\n   except AttributeError:\n    return self.default(line)\n   return func(arg)\n   \n def emptyline(self):\n  ''\n\n\n\n\n  \n  if self.lastcmd:\n   return self.onecmd(self.lastcmd)\n   \n def default(self,line):\n  ''\n\n\n\n\n  \n  self.stdout.write('*** Unknown syntax: %s\\n'%line)\n  \n def completedefault(self,*ignored):\n  ''\n\n\n\n\n  \n  return []\n  \n def completenames(self,text,*ignored):\n  dotext='do_'+text\n  return [a[3:]for a in self.get_names()if a.startswith(dotext)]\n  \n def complete(self,text,state):\n  ''\n\n\n\n  \n  if state ==0:\n   import readline\n   origline=readline.get_line_buffer()\n   line=origline.lstrip()\n   stripped=len(origline)-len(line)\n   begidx=readline.get_begidx()-stripped\n   endidx=readline.get_endidx()-stripped\n   if begidx >0:\n    cmd,args,foo=self.parseline(line)\n    if cmd =='':\n     compfunc=self.completedefault\n    else :\n     try :\n      compfunc=getattr(self,'complete_'+cmd)\n     except AttributeError:\n      compfunc=self.completedefault\n   else :\n    compfunc=self.completenames\n   self.completion_matches=compfunc(text,line,begidx,endidx)\n  try :\n   return self.completion_matches[state]\n  except IndexError:\n   return None\n   \n def get_names(self):\n \n \n  return dir(self.__class__)\n  \n def complete_help(self,*args):\n  commands=set(self.completenames(*args))\n  topics=set(a[5:]for a in self.get_names()\n  if a.startswith('help_'+args[0]))\n  return list(commands |topics)\n  \n def do_help(self,arg):\n  ''\n  if arg:\n  \n   try :\n    func=getattr(self,'help_'+arg)\n   except AttributeError:\n    try :\n     doc=getattr(self,'do_'+arg).__doc__\n     if doc:\n      self.stdout.write(\"%s\\n\"%str(doc))\n      return\n    except AttributeError:\n     pass\n    self.stdout.write(\"%s\\n\"%str(self.nohelp %(arg,)))\n    return\n   func()\n  else :\n   names=self.get_names()\n   cmds_doc=[]\n   cmds_undoc=[]\n   help={}\n   for name in names:\n    if name[:5]=='help_':\n     help[name[5:]]=1\n   names.sort()\n   \n   prevname=''\n   for name in names:\n    if name[:3]=='do_':\n     if name ==prevname:\n      continue\n     prevname=name\n     cmd=name[3:]\n     if cmd in help:\n      cmds_doc.append(cmd)\n      del help[cmd]\n     elif getattr(self,name).__doc__:\n      cmds_doc.append(cmd)\n     else :\n      cmds_undoc.append(cmd)\n   self.stdout.write(\"%s\\n\"%str(self.doc_leader))\n   self.print_topics(self.doc_header,cmds_doc,15,80)\n   self.print_topics(self.misc_header,list(help.keys()),15,80)\n   self.print_topics(self.undoc_header,cmds_undoc,15,80)\n   \n def print_topics(self,header,cmds,cmdlen,maxcol):\n  if cmds:\n   self.stdout.write(\"%s\\n\"%str(header))\n   if self.ruler:\n    self.stdout.write(\"%s\\n\"%str(self.ruler *len(header)))\n   self.columnize(cmds,maxcol -1)\n   self.stdout.write(\"\\n\")\n   \n def columnize(self,list,displaywidth=80):\n  ''\n\n\n\n  \n  if not list:\n   self.stdout.write(\"<empty>\\n\")\n   return\n   \n  nonstrings=[i for i in range(len(list))\n  if not isinstance(list[i],str)]\n  if nonstrings:\n   raise TypeError(\"list[i] not a string for i in %s\"\n   %\", \".join(map(str,nonstrings)))\n  size=len(list)\n  if size ==1:\n   self.stdout.write('%s\\n'%str(list[0]))\n   return\n   \n  for nrows in range(1,len(list)):\n   ncols=(size+nrows -1)//nrows\n   colwidths=[]\n   totwidth=-2\n   for col in range(ncols):\n    colwidth=0\n    for row in range(nrows):\n     i=row+nrows *col\n     if i >=size:\n      break\n     x=list[i]\n     colwidth=max(colwidth,len(x))\n    colwidths.append(colwidth)\n    totwidth +=colwidth+2\n    if totwidth >displaywidth:\n     break\n   if totwidth <=displaywidth:\n    break\n  else :\n   nrows=len(list)\n   ncols=1\n   colwidths=[0]\n  for row in range(nrows):\n   texts=[]\n   for col in range(ncols):\n    i=row+nrows *col\n    if i >=size:\n     x=\"\"\n    else :\n     x=list[i]\n    texts.append(x)\n   while texts and not texts[-1]:\n    del texts[-1]\n   for col in range(len(texts)):\n    texts[col]=texts[col].ljust(colwidths[col])\n   self.stdout.write(\"%s\\n\"%str(\"  \".join(texts)))\n", ["readline", "string", "sys"]], "code": [".py", "''\n\n\n\n\n\n\nimport sys\nimport traceback\nfrom codeop import CommandCompiler,compile_command\n\n__all__=[\"InteractiveInterpreter\",\"InteractiveConsole\",\"interact\",\n\"compile_command\"]\n\nclass InteractiveInterpreter:\n ''\n\n\n\n\n\n \n \n def __init__(self,locals=None ):\n  ''\n\n\n\n\n\n\n  \n  if locals is None :\n   locals={\"__name__\":\"__console__\",\"__doc__\":None }\n  self.locals=locals\n  self.compile=CommandCompiler()\n  \n def runsource(self,source,filename=\"<input>\",symbol=\"single\"):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  try :\n   code=self.compile(source,filename,symbol)\n  except (OverflowError,SyntaxError,ValueError):\n  \n   self.showsyntaxerror(filename)\n   return False\n   \n  if code is None :\n  \n   return True\n   \n   \n  self.runcode(code)\n  return False\n  \n def runcode(self,code):\n  ''\n\n\n\n\n\n\n\n\n\n  \n  try :\n   exec(code,self.locals)\n  except SystemExit:\n   raise\n  except :\n   self.showtraceback()\n   \n def showsyntaxerror(self,filename=None ):\n  ''\n\n\n\n\n\n\n\n\n\n  \n  type,value,tb=sys.exc_info()\n  sys.last_type=type\n  sys.last_value=value\n  sys.last_traceback=tb\n  if filename and type is SyntaxError:\n  \n   try :\n    msg,(dummy_filename,lineno,offset,line)=value.args\n   except ValueError:\n   \n    pass\n   else :\n   \n    value=SyntaxError(msg,(filename,lineno,offset,line))\n    sys.last_value=value\n  if sys.excepthook is sys.__excepthook__:\n   lines=traceback.format_exception_only(type,value)\n   self.write(''.join(lines))\n  else :\n  \n  \n   sys.excepthook(type,value,tb)\n   \n def showtraceback(self):\n  ''\n\n\n\n\n\n  \n  sys.last_type,sys.last_value,last_tb=ei=sys.exc_info()\n  sys.last_traceback=last_tb\n  try :\n   lines=traceback.format_exception(ei[0],ei[1],last_tb.tb_next)\n   if sys.excepthook is sys.__excepthook__:\n    self.write(''.join(lines))\n   else :\n   \n   \n    sys.excepthook(ei[0],ei[1],last_tb)\n  finally :\n   last_tb=ei=None\n   \n def write(self,data):\n  ''\n\n\n\n\n  \n  sys.stderr.write(data)\n  \n  \nclass InteractiveConsole(InteractiveInterpreter):\n ''\n\n\n\n\n \n \n def __init__(self,locals=None ,filename=\"<console>\"):\n  ''\n\n\n\n\n\n\n\n  \n  InteractiveInterpreter.__init__(self,locals)\n  self.filename=filename\n  self.resetbuffer()\n  \n def resetbuffer(self):\n  ''\n  self.buffer=[]\n  \n def interact(self,banner=None ,exitmsg=None ):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  try :\n   sys.ps1\n  except AttributeError:\n   sys.ps1=\">>> \"\n  try :\n   sys.ps2\n  except AttributeError:\n   sys.ps2=\"... \"\n  cprt='Type \"help\", \"copyright\", \"credits\" or \"license\" for more information.'\n  if banner is None :\n   self.write(\"Python %s on %s\\n%s\\n(%s)\\n\"%\n   (sys.version,sys.platform,cprt,\n   self.__class__.__name__))\n  elif banner:\n   self.write(\"%s\\n\"%str(banner))\n  more=0\n  while 1:\n   try :\n    if more:\n     prompt=sys.ps2\n    else :\n     prompt=sys.ps1\n    try :\n     line=self.raw_input(prompt)\n    except EOFError:\n     self.write(\"\\n\")\n     break\n    else :\n     more=self.push(line)\n   except KeyboardInterrupt:\n    self.write(\"\\nKeyboardInterrupt\\n\")\n    self.resetbuffer()\n    more=0\n  if exitmsg is None :\n   self.write('now exiting %s...\\n'%self.__class__.__name__)\n  elif exitmsg !='':\n   self.write('%s\\n'%exitmsg)\n   \n def push(self,line):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n  \n  self.buffer.append(line)\n  source=\"\\n\".join(self.buffer)\n  more=self.runsource(source,self.filename)\n  if not more:\n   self.resetbuffer()\n  return more\n  \n def raw_input(self,prompt=\"\"):\n  ''\n\n\n\n\n\n\n\n\n  \n  return input(prompt)\n  \n  \n  \ndef interact(banner=None ,readfunc=None ,local=None ,exitmsg=None ):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n \n console=InteractiveConsole(local)\n if readfunc is not None :\n  console.raw_input=readfunc\n else :\n  try :\n   import readline\n  except ImportError:\n   pass\n console.interact(banner,exitmsg)\n \n \nif __name__ ==\"__main__\":\n import argparse\n \n parser=argparse.ArgumentParser()\n parser.add_argument('-q',action='store_true',\n help=\"don't print version and copyright messages\")\n args=parser.parse_args()\n if args.q or sys.flags.quiet:\n  banner=''\n else :\n  banner=None\n interact(banner)\n", ["argparse", "codeop", "readline", "sys", "traceback"]], "codecs": [".py", "''\n\n\n\n\n\n\n\n\nimport builtins\nimport sys\n\n\n\ntry :\n from _codecs import *\nexcept ImportError as why:\n raise SystemError('Failed to load the builtin codecs: %s'%why)\n \n__all__=[\"register\",\"lookup\",\"open\",\"EncodedFile\",\"BOM\",\"BOM_BE\",\n\"BOM_LE\",\"BOM32_BE\",\"BOM32_LE\",\"BOM64_BE\",\"BOM64_LE\",\n\"BOM_UTF8\",\"BOM_UTF16\",\"BOM_UTF16_LE\",\"BOM_UTF16_BE\",\n\"BOM_UTF32\",\"BOM_UTF32_LE\",\"BOM_UTF32_BE\",\n\"CodecInfo\",\"Codec\",\"IncrementalEncoder\",\"IncrementalDecoder\",\n\"StreamReader\",\"StreamWriter\",\n\"StreamReaderWriter\",\"StreamRecoder\",\n\"getencoder\",\"getdecoder\",\"getincrementalencoder\",\n\"getincrementaldecoder\",\"getreader\",\"getwriter\",\n\"encode\",\"decode\",\"iterencode\",\"iterdecode\",\n\"strict_errors\",\"ignore_errors\",\"replace_errors\",\n\"xmlcharrefreplace_errors\",\n\"backslashreplace_errors\",\"namereplace_errors\",\n\"register_error\",\"lookup_error\"]\n\n\n\n\n\n\n\n\n\n\nBOM_UTF8=b'\\xef\\xbb\\xbf'\n\n\nBOM_LE=BOM_UTF16_LE=b'\\xff\\xfe'\n\n\nBOM_BE=BOM_UTF16_BE=b'\\xfe\\xff'\n\n\nBOM_UTF32_LE=b'\\xff\\xfe\\x00\\x00'\n\n\nBOM_UTF32_BE=b'\\x00\\x00\\xfe\\xff'\n\nif sys.byteorder =='little':\n\n\n BOM=BOM_UTF16=BOM_UTF16_LE\n \n \n BOM_UTF32=BOM_UTF32_LE\n \nelse :\n\n\n BOM=BOM_UTF16=BOM_UTF16_BE\n \n \n BOM_UTF32=BOM_UTF32_BE\n \n \nBOM32_LE=BOM_UTF16_LE\nBOM32_BE=BOM_UTF16_BE\nBOM64_LE=BOM_UTF32_LE\nBOM64_BE=BOM_UTF32_BE\n\n\n\n\nclass CodecInfo(tuple):\n ''\n \n \n \n \n \n \n \n _is_text_encoding=True\n \n def __new__(cls,encode,decode,streamreader=None ,streamwriter=None ,\n incrementalencoder=None ,incrementaldecoder=None ,name=None ,\n *,_is_text_encoding=None ):\n  self=tuple.__new__(cls,(encode,decode,streamreader,streamwriter))\n  self.name=name\n  self.encode=encode\n  self.decode=decode\n  self.incrementalencoder=incrementalencoder\n  self.incrementaldecoder=incrementaldecoder\n  self.streamwriter=streamwriter\n  self.streamreader=streamreader\n  if _is_text_encoding is not None :\n   self._is_text_encoding=_is_text_encoding\n  return self\n  \n def __repr__(self):\n  return \"<%s.%s object for encoding %s at %#x>\"%\\\n  (self.__class__.__module__,self.__class__.__qualname__,\n  self.name,id(self))\n  \nclass Codec:\n\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n def encode(self,input,errors='strict'):\n \n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  raise NotImplementedError\n  \n def decode(self,input,errors='strict'):\n \n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  raise NotImplementedError\n  \nclass IncrementalEncoder(object):\n ''\n\n\n\n \n def __init__(self,errors='strict'):\n  ''\n\n\n\n\n\n  \n  self.errors=errors\n  self.buffer=\"\"\n  \n def encode(self,input,final=False ):\n  ''\n\n  \n  raise NotImplementedError\n  \n def reset(self):\n  ''\n\n  \n  \n def getstate(self):\n  ''\n\n  \n  return 0\n  \n def setstate(self,state):\n  ''\n\n\n  \n  \nclass BufferedIncrementalEncoder(IncrementalEncoder):\n ''\n\n\n\n \n def __init__(self,errors='strict'):\n  IncrementalEncoder.__init__(self,errors)\n  \n  self.buffer=\"\"\n  \n def _buffer_encode(self,input,errors,final):\n \n \n  raise NotImplementedError\n  \n def encode(self,input,final=False ):\n \n  data=self.buffer+input\n  (result,consumed)=self._buffer_encode(data,self.errors,final)\n  \n  self.buffer=data[consumed:]\n  return result\n  \n def reset(self):\n  IncrementalEncoder.reset(self)\n  self.buffer=\"\"\n  \n def getstate(self):\n  return self.buffer or 0\n  \n def setstate(self,state):\n  self.buffer=state or \"\"\n  \nclass IncrementalDecoder(object):\n ''\n\n\n\n \n def __init__(self,errors='strict'):\n  ''\n\n\n\n\n\n  \n  self.errors=errors\n  \n def decode(self,input,final=False ):\n  ''\n\n  \n  raise NotImplementedError\n  \n def reset(self):\n  ''\n\n  \n  \n def getstate(self):\n  ''\n\n\n\n\n\n\n\n\n\n  \n  return (b\"\",0)\n  \n def setstate(self,state):\n  ''\n\n\n\n\n  \n  \nclass BufferedIncrementalDecoder(IncrementalDecoder):\n ''\n\n\n\n \n def __init__(self,errors='strict'):\n  IncrementalDecoder.__init__(self,errors)\n  \n  self.buffer=b\"\"\n  \n def _buffer_decode(self,input,errors,final):\n \n \n  raise NotImplementedError\n  \n def decode(self,input,final=False ):\n \n  data=self.buffer+input\n  (result,consumed)=self._buffer_decode(data,self.errors,final)\n  \n  self.buffer=data[consumed:]\n  return result\n  \n def reset(self):\n  IncrementalDecoder.reset(self)\n  self.buffer=b\"\"\n  \n def getstate(self):\n \n  return (self.buffer,0)\n  \n def setstate(self,state):\n \n  self.buffer=state[0]\n  \n  \n  \n  \n  \n  \n  \n  \nclass StreamWriter(Codec):\n\n def __init__(self,stream,errors='strict'):\n \n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  self.stream=stream\n  self.errors=errors\n  \n def write(self,object):\n \n  ''\n  \n  data,consumed=self.encode(object,self.errors)\n  self.stream.write(data)\n  \n def writelines(self,list):\n \n  ''\n\n  \n  self.write(''.join(list))\n  \n def reset(self):\n \n  ''\n\n\n\n\n\n\n  \n  pass\n  \n def seek(self,offset,whence=0):\n  self.stream.seek(offset,whence)\n  if whence ==0 and offset ==0:\n   self.reset()\n   \n def __getattr__(self,name,\n getattr=getattr):\n \n  ''\n  \n  return getattr(self.stream,name)\n  \n def __enter__(self):\n  return self\n  \n def __exit__(self,type,value,tb):\n  self.stream.close()\n  \n  \n  \nclass StreamReader(Codec):\n\n charbuffertype=str\n \n def __init__(self,stream,errors='strict'):\n \n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  self.stream=stream\n  self.errors=errors\n  self.bytebuffer=b\"\"\n  self._empty_charbuffer=self.charbuffertype()\n  self.charbuffer=self._empty_charbuffer\n  self.linebuffer=None\n  \n def decode(self,input,errors='strict'):\n  raise NotImplementedError\n  \n def read(self,size=-1,chars=-1,firstline=False ):\n \n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  if self.linebuffer:\n   self.charbuffer=self._empty_charbuffer.join(self.linebuffer)\n   self.linebuffer=None\n   \n  if chars <0:\n  \n  \n   chars=size\n   \n   \n  while True :\n  \n   if chars >=0:\n    if len(self.charbuffer)>=chars:\n     break\n     \n   if size <0:\n    newdata=self.stream.read()\n   else :\n    newdata=self.stream.read(size)\n    \n   data=self.bytebuffer+newdata\n   if not data:\n    break\n   try :\n    newchars,decodedbytes=self.decode(data,self.errors)\n   except UnicodeDecodeError as exc:\n    if firstline:\n     newchars,decodedbytes=\\\n     self.decode(data[:exc.start],self.errors)\n     lines=newchars.splitlines(keepends=True )\n     if len(lines)<=1:\n      raise\n    else :\n     raise\n     \n   self.bytebuffer=data[decodedbytes:]\n   \n   self.charbuffer +=newchars\n   \n   if not newdata:\n    break\n  if chars <0:\n  \n   result=self.charbuffer\n   self.charbuffer=self._empty_charbuffer\n  else :\n  \n   result=self.charbuffer[:chars]\n   self.charbuffer=self.charbuffer[chars:]\n  return result\n  \n def readline(self,size=None ,keepends=True ):\n \n  ''\n\n\n\n\n\n  \n  \n  \n  if self.linebuffer:\n   line=self.linebuffer[0]\n   del self.linebuffer[0]\n   if len(self.linebuffer)==1:\n   \n   \n    self.charbuffer=self.linebuffer[0]\n    self.linebuffer=None\n   if not keepends:\n    line=line.splitlines(keepends=False )[0]\n   return line\n   \n  readsize=size or 72\n  line=self._empty_charbuffer\n  \n  while True :\n   data=self.read(readsize,firstline=True )\n   if data:\n   \n   \n   \n    if (isinstance(data,str)and data.endswith(\"\\r\"))or\\\n    (isinstance(data,bytes)and data.endswith(b\"\\r\")):\n     data +=self.read(size=1,chars=1)\n     \n   line +=data\n   lines=line.splitlines(keepends=True )\n   if lines:\n    if len(lines)>1:\n    \n    \n     line=lines[0]\n     del lines[0]\n     if len(lines)>1:\n     \n      lines[-1]+=self.charbuffer\n      self.linebuffer=lines\n      self.charbuffer=None\n     else :\n     \n      self.charbuffer=lines[0]+self.charbuffer\n     if not keepends:\n      line=line.splitlines(keepends=False )[0]\n     break\n    line0withend=lines[0]\n    line0withoutend=lines[0].splitlines(keepends=False )[0]\n    if line0withend !=line0withoutend:\n    \n     self.charbuffer=self._empty_charbuffer.join(lines[1:])+\\\n     self.charbuffer\n     if keepends:\n      line=line0withend\n     else :\n      line=line0withoutend\n     break\n     \n   if not data or size is not None :\n    if line and not keepends:\n     line=line.splitlines(keepends=False )[0]\n    break\n   if readsize <8000:\n    readsize *=2\n  return line\n  \n def readlines(self,sizehint=None ,keepends=True ):\n \n  ''\n\n\n\n\n\n\n\n\n  \n  data=self.read()\n  return data.splitlines(keepends)\n  \n def reset(self):\n \n  ''\n\n\n\n\n\n  \n  self.bytebuffer=b\"\"\n  self.charbuffer=self._empty_charbuffer\n  self.linebuffer=None\n  \n def seek(self,offset,whence=0):\n  ''\n\n\n  \n  self.stream.seek(offset,whence)\n  self.reset()\n  \n def __next__(self):\n \n  ''\n  line=self.readline()\n  if line:\n   return line\n  raise StopIteration\n  \n def __iter__(self):\n  return self\n  \n def __getattr__(self,name,\n getattr=getattr):\n \n  ''\n  \n  return getattr(self.stream,name)\n  \n def __enter__(self):\n  return self\n  \n def __exit__(self,type,value,tb):\n  self.stream.close()\n  \n  \n  \nclass StreamReaderWriter:\n\n ''\n\n\n\n\n\n\n \n \n encoding='unknown'\n \n def __init__(self,stream,Reader,Writer,errors='strict'):\n \n  ''\n\n\n\n\n\n\n\n\n\n  \n  self.stream=stream\n  self.reader=Reader(stream,errors)\n  self.writer=Writer(stream,errors)\n  self.errors=errors\n  \n def read(self,size=-1):\n \n  return self.reader.read(size)\n  \n def readline(self,size=None ):\n \n  return self.reader.readline(size)\n  \n def readlines(self,sizehint=None ):\n \n  return self.reader.readlines(sizehint)\n  \n def __next__(self):\n \n  ''\n  return next(self.reader)\n  \n def __iter__(self):\n  return self\n  \n def write(self,data):\n \n  return self.writer.write(data)\n  \n def writelines(self,list):\n \n  return self.writer.writelines(list)\n  \n def reset(self):\n \n  self.reader.reset()\n  self.writer.reset()\n  \n def seek(self,offset,whence=0):\n  self.stream.seek(offset,whence)\n  self.reader.reset()\n  if whence ==0 and offset ==0:\n   self.writer.reset()\n   \n def __getattr__(self,name,\n getattr=getattr):\n \n  ''\n  \n  return getattr(self.stream,name)\n  \n  \n  \n def __enter__(self):\n  return self\n  \n def __exit__(self,type,value,tb):\n  self.stream.close()\n  \n  \n  \nclass StreamRecoder:\n\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n data_encoding='unknown'\n file_encoding='unknown'\n \n def __init__(self,stream,encode,decode,Reader,Writer,\n errors='strict'):\n \n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  self.stream=stream\n  self.encode=encode\n  self.decode=decode\n  self.reader=Reader(stream,errors)\n  self.writer=Writer(stream,errors)\n  self.errors=errors\n  \n def read(self,size=-1):\n \n  data=self.reader.read(size)\n  data,bytesencoded=self.encode(data,self.errors)\n  return data\n  \n def readline(self,size=None ):\n \n  if size is None :\n   data=self.reader.readline()\n  else :\n   data=self.reader.readline(size)\n  data,bytesencoded=self.encode(data,self.errors)\n  return data\n  \n def readlines(self,sizehint=None ):\n \n  data=self.reader.read()\n  data,bytesencoded=self.encode(data,self.errors)\n  return data.splitlines(keepends=True )\n  \n def __next__(self):\n \n  ''\n  data=next(self.reader)\n  data,bytesencoded=self.encode(data,self.errors)\n  return data\n  \n def __iter__(self):\n  return self\n  \n def write(self,data):\n \n  data,bytesdecoded=self.decode(data,self.errors)\n  return self.writer.write(data)\n  \n def writelines(self,list):\n \n  data=b''.join(list)\n  data,bytesdecoded=self.decode(data,self.errors)\n  return self.writer.write(data)\n  \n def reset(self):\n \n  self.reader.reset()\n  self.writer.reset()\n  \n def seek(self,offset,whence=0):\n \n \n  self.reader.seek(offset,whence)\n  self.writer.seek(offset,whence)\n  \n def __getattr__(self,name,\n getattr=getattr):\n \n  ''\n  \n  return getattr(self.stream,name)\n  \n def __enter__(self):\n  return self\n  \n def __exit__(self,type,value,tb):\n  self.stream.close()\n  \n  \n  \ndef open(filename,mode='r',encoding=None ,errors='strict',buffering=-1):\n\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n if encoding is not None and\\\n 'b'not in mode:\n \n  mode=mode+'b'\n file=builtins.open(filename,mode,buffering)\n if encoding is None :\n  return file\n  \n try :\n  info=lookup(encoding)\n  srw=StreamReaderWriter(file,info.streamreader,info.streamwriter,errors)\n  \n  srw.encoding=encoding\n  return srw\n except :\n  file.close()\n  raise\n  \ndef EncodedFile(file,data_encoding,file_encoding=None ,errors='strict'):\n\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n if file_encoding is None :\n  file_encoding=data_encoding\n data_info=lookup(data_encoding)\n file_info=lookup(file_encoding)\n sr=StreamRecoder(file,data_info.encode,data_info.decode,\n file_info.streamreader,file_info.streamwriter,errors)\n \n sr.data_encoding=data_encoding\n sr.file_encoding=file_encoding\n return sr\n \n \n \ndef getencoder(encoding):\n\n ''\n\n\n\n\n \n return lookup(encoding).encode\n \ndef getdecoder(encoding):\n\n ''\n\n\n\n\n \n return lookup(encoding).decode\n \ndef getincrementalencoder(encoding):\n\n ''\n\n\n\n\n\n \n encoder=lookup(encoding).incrementalencoder\n if encoder is None :\n  raise LookupError(encoding)\n return encoder\n \ndef getincrementaldecoder(encoding):\n\n ''\n\n\n\n\n\n \n decoder=lookup(encoding).incrementaldecoder\n if decoder is None :\n  raise LookupError(encoding)\n return decoder\n \ndef getreader(encoding):\n\n ''\n\n\n\n\n \n return lookup(encoding).streamreader\n \ndef getwriter(encoding):\n\n ''\n\n\n\n\n \n return lookup(encoding).streamwriter\n \ndef iterencode(iterator,encoding,errors='strict',**kwargs):\n ''\n\n\n\n\n\n\n \n encoder=getincrementalencoder(encoding)(errors,**kwargs)\n for input in iterator:\n  output=encoder.encode(input)\n  if output:\n   yield output\n output=encoder.encode(\"\",True )\n if output:\n  yield output\n  \ndef iterdecode(iterator,encoding,errors='strict',**kwargs):\n ''\n\n\n\n\n\n\n \n decoder=getincrementaldecoder(encoding)(errors,**kwargs)\n for input in iterator:\n  output=decoder.decode(input)\n  if output:\n   yield output\n output=decoder.decode(b\"\",True )\n if output:\n  yield output\n  \n  \n  \ndef make_identity_dict(rng):\n\n ''\n\n\n\n\n \n return {i:i for i in rng}\n \ndef make_encoding_map(decoding_map):\n\n ''\n\n\n\n\n\n\n\n\n\n \n m={}\n for k,v in decoding_map.items():\n  if not v in m:\n   m[v]=k\n  else :\n   m[v]=None\n return m\n \n \n \ntry :\n strict_errors=lookup_error(\"strict\")\n ignore_errors=lookup_error(\"ignore\")\n replace_errors=lookup_error(\"replace\")\n xmlcharrefreplace_errors=lookup_error(\"xmlcharrefreplace\")\n backslashreplace_errors=lookup_error(\"backslashreplace\")\n namereplace_errors=lookup_error(\"namereplace\")\nexcept LookupError:\n\n strict_errors=None\n ignore_errors=None\n replace_errors=None\n xmlcharrefreplace_errors=None\n backslashreplace_errors=None\n namereplace_errors=None\n \n \n \n_false=0\nif _false:\n import encodings\n \n \n \nif __name__ =='__main__':\n\n\n sys.stdout=EncodedFile(sys.stdout,'latin-1','utf-8')\n \n \n sys.stdin=EncodedFile(sys.stdin,'utf-8','latin-1')\n", ["_codecs", "builtins", "encodings", "sys"]], "codeop": [".py", "''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nimport __future__\nimport warnings\n\n_features=[getattr(__future__,fname)\nfor fname in __future__.all_feature_names]\n\n__all__=[\"compile_command\",\"Compile\",\"CommandCompiler\"]\n\nPyCF_DONT_IMPLY_DEDENT=0x200\n\ndef _maybe_compile(compiler,source,filename,symbol):\n\n for line in source.split(\"\\n\"):\n  line=line.strip()\n  if line and line[0]!='#':\n   break\n else :\n  if symbol !=\"eval\":\n   source=\"pass\"\n   \n try :\n  return compiler(source,filename,symbol)\n except SyntaxError:\n  pass\n  \n  \n  \n with warnings.catch_warnings():\n  warnings.simplefilter(\"error\")\n  \n  code1=err1=err2=None\n  try :\n   code1=compiler(source+\"\\n\",filename,symbol)\n  except SyntaxError as e:\n   err1=e\n   \n  try :\n   code2=compiler(source+\"\\n\\n\",filename,symbol)\n  except SyntaxError as e:\n   err2=e\n   \n try :\n  if not code1 and _is_syntax_error(err1,err2):\n   raise err1\n  else :\n   return None\n finally :\n  err1=err2=None\n  \ndef _is_syntax_error(err1,err2):\n rep1=repr(err1)\n rep2=repr(err2)\n if \"was never closed\"in rep1 and \"was never closed\"in rep2:\n  return False\n if rep1 ==rep2:\n  return True\n return False\n \ndef _compile(source,filename,symbol):\n return compile(source,filename,symbol,PyCF_DONT_IMPLY_DEDENT)\n \ndef compile_command(source,filename=\"<input>\",symbol=\"single\"):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n return _maybe_compile(_compile,source,filename,symbol)\n \nclass Compile:\n ''\n\n\n \n def __init__(self):\n  self.flags=PyCF_DONT_IMPLY_DEDENT\n  \n def __call__(self,source,filename,symbol):\n  codeob=compile(source,filename,symbol,self.flags,True )\n  for feature in _features:\n   if codeob.co_flags&feature.compiler_flag:\n    self.flags |=feature.compiler_flag\n  return codeob\n  \nclass CommandCompiler:\n ''\n\n\n\n \n \n def __init__(self,):\n  self.compiler=Compile()\n  \n def __call__(self,source,filename=\"<input>\",symbol=\"single\"):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  return _maybe_compile(self.compiler,source,filename,symbol)\n", ["__future__", "warnings"]], "colorsys": [".py", "''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n__all__=[\"rgb_to_yiq\",\"yiq_to_rgb\",\"rgb_to_hls\",\"hls_to_rgb\",\n\"rgb_to_hsv\",\"hsv_to_rgb\"]\n\n\n\nONE_THIRD=1.0 /3.0\nONE_SIXTH=1.0 /6.0\nTWO_THIRD=2.0 /3.0\n\n\n\n\n\n\n\n\ndef rgb_to_yiq(r,g,b):\n y=0.30 *r+0.59 *g+0.11 *b\n i=0.74 *(r -y)-0.27 *(b -y)\n q=0.48 *(r -y)+0.41 *(b -y)\n return (y,i,q)\n \ndef yiq_to_rgb(y,i,q):\n\n\n\n\n r=y+0.9468822170900693 *i+0.6235565819861433 *q\n g=y -0.27478764629897834 *i -0.6356910791873801 *q\n b=y -1.1085450346420322 *i+1.7090069284064666 *q\n \n if r <0.0:\n  r=0.0\n if g <0.0:\n  g=0.0\n if b <0.0:\n  b=0.0\n if r >1.0:\n  r=1.0\n if g >1.0:\n  g=1.0\n if b >1.0:\n  b=1.0\n return (r,g,b)\n \n \n \n \n \n \n \ndef rgb_to_hls(r,g,b):\n maxc=max(r,g,b)\n minc=min(r,g,b)\n sumc=(maxc+minc)\n rangec=(maxc -minc)\n l=sumc /2.0\n if minc ==maxc:\n  return 0.0,l,0.0\n if l <=0.5:\n  s=rangec /sumc\n else :\n  s=rangec /(2.0 -sumc)\n rc=(maxc -r)/rangec\n gc=(maxc -g)/rangec\n bc=(maxc -b)/rangec\n if r ==maxc:\n  h=bc -gc\n elif g ==maxc:\n  h=2.0+rc -bc\n else :\n  h=4.0+gc -rc\n h=(h /6.0)%1.0\n return h,l,s\n \ndef hls_to_rgb(h,l,s):\n if s ==0.0:\n  return l,l,l\n if l <=0.5:\n  m2=l *(1.0+s)\n else :\n  m2=l+s -(l *s)\n m1=2.0 *l -m2\n return (_v(m1,m2,h+ONE_THIRD),_v(m1,m2,h),_v(m1,m2,h -ONE_THIRD))\n \ndef _v(m1,m2,hue):\n hue=hue %1.0\n if hue <ONE_SIXTH:\n  return m1+(m2 -m1)*hue *6.0\n if hue <0.5:\n  return m2\n if hue <TWO_THIRD:\n  return m1+(m2 -m1)*(TWO_THIRD -hue)*6.0\n return m1\n \n \n \n \n \n \n \ndef rgb_to_hsv(r,g,b):\n maxc=max(r,g,b)\n minc=min(r,g,b)\n v=maxc\n if minc ==maxc:\n  return 0.0,0.0,v\n s=(maxc -minc)/maxc\n rc=(maxc -r)/(maxc -minc)\n gc=(maxc -g)/(maxc -minc)\n bc=(maxc -b)/(maxc -minc)\n if r ==maxc:\n  h=bc -gc\n elif g ==maxc:\n  h=2.0+rc -bc\n else :\n  h=4.0+gc -rc\n h=(h /6.0)%1.0\n return h,s,v\n \ndef hsv_to_rgb(h,s,v):\n if s ==0.0:\n  return v,v,v\n i=int(h *6.0)\n f=(h *6.0)-i\n p=v *(1.0 -s)\n q=v *(1.0 -s *f)\n t=v *(1.0 -s *(1.0 -f))\n i=i %6\n if i ==0:\n  return v,t,p\n if i ==1:\n  return q,v,p\n if i ==2:\n  return p,v,t\n if i ==3:\n  return p,q,v\n if i ==4:\n  return t,p,v\n if i ==5:\n  return v,p,q\n  \n", []], "configparser": [".py", "''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nfrom collections.abc import MutableMapping\nfrom collections import ChainMap as _ChainMap\nimport functools\nimport io\nimport itertools\nimport os\nimport re\nimport sys\nimport warnings\n\n__all__=[\"NoSectionError\",\"DuplicateOptionError\",\"DuplicateSectionError\",\n\"NoOptionError\",\"InterpolationError\",\"InterpolationDepthError\",\n\"InterpolationMissingOptionError\",\"InterpolationSyntaxError\",\n\"ParsingError\",\"MissingSectionHeaderError\",\n\"ConfigParser\",\"SafeConfigParser\",\"RawConfigParser\",\n\"Interpolation\",\"BasicInterpolation\",\"ExtendedInterpolation\",\n\"LegacyInterpolation\",\"SectionProxy\",\"ConverterMapping\",\n\"DEFAULTSECT\",\"MAX_INTERPOLATION_DEPTH\"]\n\n_default_dict=dict\nDEFAULTSECT=\"DEFAULT\"\n\nMAX_INTERPOLATION_DEPTH=10\n\n\n\n\nclass Error(Exception):\n ''\n \n def __init__(self,msg=''):\n  self.message=msg\n  Exception.__init__(self,msg)\n  \n def __repr__(self):\n  return self.message\n  \n __str__=__repr__\n \n \nclass NoSectionError(Error):\n ''\n \n def __init__(self,section):\n  Error.__init__(self,'No section: %r'%(section,))\n  self.section=section\n  self.args=(section,)\n  \n  \nclass DuplicateSectionError(Error):\n ''\n\n\n\n\n \n \n def __init__(self,section,source=None ,lineno=None ):\n  msg=[repr(section),\" already exists\"]\n  if source is not None :\n   message=[\"While reading from \",repr(source)]\n   if lineno is not None :\n    message.append(\" [line {0:2d}]\".format(lineno))\n   message.append(\": section \")\n   message.extend(msg)\n   msg=message\n  else :\n   msg.insert(0,\"Section \")\n  Error.__init__(self,\"\".join(msg))\n  self.section=section\n  self.source=source\n  self.lineno=lineno\n  self.args=(section,source,lineno)\n  \n  \nclass DuplicateOptionError(Error):\n ''\n\n\n\n \n \n def __init__(self,section,option,source=None ,lineno=None ):\n  msg=[repr(option),\" in section \",repr(section),\n  \" already exists\"]\n  if source is not None :\n   message=[\"While reading from \",repr(source)]\n   if lineno is not None :\n    message.append(\" [line {0:2d}]\".format(lineno))\n   message.append(\": option \")\n   message.extend(msg)\n   msg=message\n  else :\n   msg.insert(0,\"Option \")\n  Error.__init__(self,\"\".join(msg))\n  self.section=section\n  self.option=option\n  self.source=source\n  self.lineno=lineno\n  self.args=(section,option,source,lineno)\n  \n  \nclass NoOptionError(Error):\n ''\n \n def __init__(self,option,section):\n  Error.__init__(self,\"No option %r in section: %r\"%\n  (option,section))\n  self.option=option\n  self.section=section\n  self.args=(option,section)\n  \n  \nclass InterpolationError(Error):\n ''\n \n def __init__(self,option,section,msg):\n  Error.__init__(self,msg)\n  self.option=option\n  self.section=section\n  self.args=(option,section,msg)\n  \n  \nclass InterpolationMissingOptionError(InterpolationError):\n ''\n \n def __init__(self,option,section,rawval,reference):\n  msg=(\"Bad value substitution: option {!r} in section {!r} contains \"\n  \"an interpolation key {!r} which is not a valid option name. \"\n  \"Raw value: {!r}\".format(option,section,reference,rawval))\n  InterpolationError.__init__(self,option,section,msg)\n  self.reference=reference\n  self.args=(option,section,rawval,reference)\n  \n  \nclass InterpolationSyntaxError(InterpolationError):\n ''\n\n\n\n \n \n \nclass InterpolationDepthError(InterpolationError):\n ''\n \n def __init__(self,option,section,rawval):\n  msg=(\"Recursion limit exceeded in value substitution: option {!r} \"\n  \"in section {!r} contains an interpolation key which \"\n  \"cannot be substituted in {} steps. Raw value: {!r}\"\n  \"\".format(option,section,MAX_INTERPOLATION_DEPTH,\n  rawval))\n  InterpolationError.__init__(self,option,section,msg)\n  self.args=(option,section,rawval)\n  \n  \nclass ParsingError(Error):\n ''\n \n def __init__(self,source=None ,filename=None ):\n \n \n  if filename and source:\n   raise ValueError(\"Cannot specify both `filename' and `source'. \"\n   \"Use `source'.\")\n  elif not filename and not source:\n   raise ValueError(\"Required argument `source' not given.\")\n  elif filename:\n   source=filename\n  Error.__init__(self,'Source contains parsing errors: %r'%source)\n  self.source=source\n  self.errors=[]\n  self.args=(source,)\n  \n @property\n def filename(self):\n  ''\n  warnings.warn(\n  \"The 'filename' attribute will be removed in future versions.  \"\n  \"Use 'source' instead.\",\n  DeprecationWarning,stacklevel=2\n  )\n  return self.source\n  \n @filename.setter\n def filename(self,value):\n  ''\n  warnings.warn(\n  \"The 'filename' attribute will be removed in future versions.  \"\n  \"Use 'source' instead.\",\n  DeprecationWarning,stacklevel=2\n  )\n  self.source=value\n  \n def append(self,lineno,line):\n  self.errors.append((lineno,line))\n  self.message +='\\n\\t[line %2d]: %s'%(lineno,line)\n  \n  \nclass MissingSectionHeaderError(ParsingError):\n ''\n \n def __init__(self,filename,lineno,line):\n  Error.__init__(\n  self,\n  'File contains no section headers.\\nfile: %r, line: %d\\n%r'%\n  (filename,lineno,line))\n  self.source=filename\n  self.lineno=lineno\n  self.line=line\n  self.args=(filename,lineno,line)\n  \n  \n  \n  \n  \n_UNSET=object()\n\n\nclass Interpolation:\n ''\n \n def before_get(self,parser,section,option,value,defaults):\n  return value\n  \n def before_set(self,parser,section,option,value):\n  return value\n  \n def before_read(self,parser,section,option,value):\n  return value\n  \n def before_write(self,parser,section,option,value):\n  return value\n  \n  \nclass BasicInterpolation(Interpolation):\n ''\n\n\n\n\n\n\n\n\n\n\n\n \n \n _KEYCRE=re.compile(r\"%\\(([^)]+)\\)s\")\n \n def before_get(self,parser,section,option,value,defaults):\n  L=[]\n  self._interpolate_some(parser,option,L,value,section,defaults,1)\n  return ''.join(L)\n  \n def before_set(self,parser,section,option,value):\n  tmp_value=value.replace('%%','')\n  tmp_value=self._KEYCRE.sub('',tmp_value)\n  if '%'in tmp_value:\n   raise ValueError(\"invalid interpolation syntax in %r at \"\n   \"position %d\"%(value,tmp_value.find('%')))\n  return value\n  \n def _interpolate_some(self,parser,option,accum,rest,section,map,\n depth):\n  rawval=parser.get(section,option,raw=True ,fallback=rest)\n  if depth >MAX_INTERPOLATION_DEPTH:\n   raise InterpolationDepthError(option,section,rawval)\n  while rest:\n   p=rest.find(\"%\")\n   if p <0:\n    accum.append(rest)\n    return\n   if p >0:\n    accum.append(rest[:p])\n    rest=rest[p:]\n    \n   c=rest[1:2]\n   if c ==\"%\":\n    accum.append(\"%\")\n    rest=rest[2:]\n   elif c ==\"(\":\n    m=self._KEYCRE.match(rest)\n    if m is None :\n     raise InterpolationSyntaxError(option,section,\n     \"bad interpolation variable reference %r\"%rest)\n    var=parser.optionxform(m.group(1))\n    rest=rest[m.end():]\n    try :\n     v=map[var]\n    except KeyError:\n     raise InterpolationMissingOptionError(\n     option,section,rawval,var)from None\n    if \"%\"in v:\n     self._interpolate_some(parser,option,accum,v,\n     section,map,depth+1)\n    else :\n     accum.append(v)\n   else :\n    raise InterpolationSyntaxError(\n    option,section,\n    \"'%%' must be followed by '%%' or '(', \"\n    \"found: %r\"%(rest,))\n    \n    \nclass ExtendedInterpolation(Interpolation):\n ''\n \n \n _KEYCRE=re.compile(r\"\\$\\{([^}]+)\\}\")\n \n def before_get(self,parser,section,option,value,defaults):\n  L=[]\n  self._interpolate_some(parser,option,L,value,section,defaults,1)\n  return ''.join(L)\n  \n def before_set(self,parser,section,option,value):\n  tmp_value=value.replace('$$','')\n  tmp_value=self._KEYCRE.sub('',tmp_value)\n  if '$'in tmp_value:\n   raise ValueError(\"invalid interpolation syntax in %r at \"\n   \"position %d\"%(value,tmp_value.find('$')))\n  return value\n  \n def _interpolate_some(self,parser,option,accum,rest,section,map,\n depth):\n  rawval=parser.get(section,option,raw=True ,fallback=rest)\n  if depth >MAX_INTERPOLATION_DEPTH:\n   raise InterpolationDepthError(option,section,rawval)\n  while rest:\n   p=rest.find(\"$\")\n   if p <0:\n    accum.append(rest)\n    return\n   if p >0:\n    accum.append(rest[:p])\n    rest=rest[p:]\n    \n   c=rest[1:2]\n   if c ==\"$\":\n    accum.append(\"$\")\n    rest=rest[2:]\n   elif c ==\"{\":\n    m=self._KEYCRE.match(rest)\n    if m is None :\n     raise InterpolationSyntaxError(option,section,\n     \"bad interpolation variable reference %r\"%rest)\n    path=m.group(1).split(':')\n    rest=rest[m.end():]\n    sect=section\n    opt=option\n    try :\n     if len(path)==1:\n      opt=parser.optionxform(path[0])\n      v=map[opt]\n     elif len(path)==2:\n      sect=path[0]\n      opt=parser.optionxform(path[1])\n      v=parser.get(sect,opt,raw=True )\n     else :\n      raise InterpolationSyntaxError(\n      option,section,\n      \"More than one ':' found: %r\"%(rest,))\n    except (KeyError,NoSectionError,NoOptionError):\n     raise InterpolationMissingOptionError(\n     option,section,rawval,\":\".join(path))from None\n    if \"$\"in v:\n     self._interpolate_some(parser,opt,accum,v,sect,\n     dict(parser.items(sect,raw=True )),\n     depth+1)\n    else :\n     accum.append(v)\n   else :\n    raise InterpolationSyntaxError(\n    option,section,\n    \"'$' must be followed by '$' or '{', \"\n    \"found: %r\"%(rest,))\n    \n    \nclass LegacyInterpolation(Interpolation):\n ''\n \n \n _KEYCRE=re.compile(r\"%\\(([^)]*)\\)s|.\")\n \n def before_get(self,parser,section,option,value,vars):\n  rawval=value\n  depth=MAX_INTERPOLATION_DEPTH\n  while depth:\n   depth -=1\n   if value and \"%(\"in value:\n    replace=functools.partial(self._interpolation_replace,\n    parser=parser)\n    value=self._KEYCRE.sub(replace,value)\n    try :\n     value=value %vars\n    except KeyError as e:\n     raise InterpolationMissingOptionError(\n     option,section,rawval,e.args[0])from None\n   else :\n    break\n  if value and \"%(\"in value:\n   raise InterpolationDepthError(option,section,rawval)\n  return value\n  \n def before_set(self,parser,section,option,value):\n  return value\n  \n @staticmethod\n def _interpolation_replace(match,parser):\n  s=match.group(1)\n  if s is None :\n   return match.group()\n  else :\n   return \"%%(%s)s\"%parser.optionxform(s)\n   \n   \nclass RawConfigParser(MutableMapping):\n ''\n \n \n _SECT_TMPL=r\"\"\"\n        \\[                                 # [\n        (?P<header>.+)                     # very permissive!\n        \\]                                 # ]\n        \"\"\"\n _OPT_TMPL=r\"\"\"\n        (?P<option>.*?)                    # very permissive!\n        \\s*(?P<vi>{delim})\\s*              # any number of space/tab,\n                                           # followed by any of the\n                                           # allowed delimiters,\n                                           # followed by any space/tab\n        (?P<value>.*)$                     # everything up to eol\n        \"\"\"\n _OPT_NV_TMPL=r\"\"\"\n        (?P<option>.*?)                    # very permissive!\n        \\s*(?:                             # any number of space/tab,\n        (?P<vi>{delim})\\s*                 # optionally followed by\n                                           # any of the allowed\n                                           # delimiters, followed by any\n                                           # space/tab\n        (?P<value>.*))?$                   # everything up to eol\n        \"\"\"\n \n _DEFAULT_INTERPOLATION=Interpolation()\n \n SECTCRE=re.compile(_SECT_TMPL,re.VERBOSE)\n \n OPTCRE=re.compile(_OPT_TMPL.format(delim=\"=|:\"),re.VERBOSE)\n \n \n OPTCRE_NV=re.compile(_OPT_NV_TMPL.format(delim=\"=|:\"),re.VERBOSE)\n \n NONSPACECRE=re.compile(r\"\\S\")\n \n BOOLEAN_STATES={'1':True ,'yes':True ,'true':True ,'on':True ,\n '0':False ,'no':False ,'false':False ,'off':False }\n \n def __init__(self,defaults=None ,dict_type=_default_dict,\n allow_no_value=False ,*,delimiters=('=',':'),\n comment_prefixes=('#',';'),inline_comment_prefixes=None ,\n strict=True ,empty_lines_in_values=True ,\n default_section=DEFAULTSECT,\n interpolation=_UNSET,converters=_UNSET):\n \n  self._dict=dict_type\n  self._sections=self._dict()\n  self._defaults=self._dict()\n  self._converters=ConverterMapping(self)\n  self._proxies=self._dict()\n  self._proxies[default_section]=SectionProxy(self,default_section)\n  self._delimiters=tuple(delimiters)\n  if delimiters ==('=',':'):\n   self._optcre=self.OPTCRE_NV if allow_no_value else self.OPTCRE\n  else :\n   d=\"|\".join(re.escape(d)for d in delimiters)\n   if allow_no_value:\n    self._optcre=re.compile(self._OPT_NV_TMPL.format(delim=d),\n    re.VERBOSE)\n   else :\n    self._optcre=re.compile(self._OPT_TMPL.format(delim=d),\n    re.VERBOSE)\n  self._comment_prefixes=tuple(comment_prefixes or ())\n  self._inline_comment_prefixes=tuple(inline_comment_prefixes or ())\n  self._strict=strict\n  self._allow_no_value=allow_no_value\n  self._empty_lines_in_values=empty_lines_in_values\n  self.default_section=default_section\n  self._interpolation=interpolation\n  if self._interpolation is _UNSET:\n   self._interpolation=self._DEFAULT_INTERPOLATION\n  if self._interpolation is None :\n   self._interpolation=Interpolation()\n  if converters is not _UNSET:\n   self._converters.update(converters)\n  if defaults:\n   self._read_defaults(defaults)\n   \n def defaults(self):\n  return self._defaults\n  \n def sections(self):\n  ''\n  \n  return list(self._sections.keys())\n  \n def add_section(self,section):\n  ''\n\n\n\n  \n  if section ==self.default_section:\n   raise ValueError('Invalid section name: %r'%section)\n   \n  if section in self._sections:\n   raise DuplicateSectionError(section)\n  self._sections[section]=self._dict()\n  self._proxies[section]=SectionProxy(self,section)\n  \n def has_section(self,section):\n  ''\n\n\n  \n  return section in self._sections\n  \n def options(self,section):\n  ''\n  try :\n   opts=self._sections[section].copy()\n  except KeyError:\n   raise NoSectionError(section)from None\n  opts.update(self._defaults)\n  return list(opts.keys())\n  \n def read(self,filenames,encoding=None ):\n  ''\n\n\n\n\n\n\n\n\n\n  \n  if isinstance(filenames,(str,bytes,os.PathLike)):\n   filenames=[filenames]\n  encoding=io.text_encoding(encoding)\n  read_ok=[]\n  for filename in filenames:\n   try :\n    with open(filename,encoding=encoding)as fp:\n     self._read(fp,filename)\n   except OSError:\n    continue\n   if isinstance(filename,os.PathLike):\n    filename=os.fspath(filename)\n   read_ok.append(filename)\n  return read_ok\n  \n def read_file(self,f,source=None ):\n  ''\n\n\n\n\n\n  \n  if source is None :\n   try :\n    source=f.name\n   except AttributeError:\n    source='<???>'\n  self._read(f,source)\n  \n def read_string(self,string,source='<string>'):\n  ''\n  sfile=io.StringIO(string)\n  self.read_file(sfile,source)\n  \n def read_dict(self,dictionary,source='<dict>'):\n  ''\n\n\n\n\n\n\n\n\n\n\n  \n  elements_added=set()\n  for section,keys in dictionary.items():\n   section=str(section)\n   try :\n    self.add_section(section)\n   except (DuplicateSectionError,ValueError):\n    if self._strict and section in elements_added:\n     raise\n   elements_added.add(section)\n   for key,value in keys.items():\n    key=self.optionxform(str(key))\n    if value is not None :\n     value=str(value)\n    if self._strict and (section,key)in elements_added:\n     raise DuplicateOptionError(section,key,source)\n    elements_added.add((section,key))\n    self.set(section,key,value)\n    \n def readfp(self,fp,filename=None ):\n  ''\n  warnings.warn(\n  \"This method will be removed in future versions.  \"\n  \"Use 'parser.read_file()' instead.\",\n  DeprecationWarning,stacklevel=2\n  )\n  self.read_file(fp,source=filename)\n  \n def get(self,section,option,*,raw=False ,vars=None ,fallback=_UNSET):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  try :\n   d=self._unify_values(section,vars)\n  except NoSectionError:\n   if fallback is _UNSET:\n    raise\n   else :\n    return fallback\n  option=self.optionxform(option)\n  try :\n   value=d[option]\n  except KeyError:\n   if fallback is _UNSET:\n    raise NoOptionError(option,section)\n   else :\n    return fallback\n    \n  if raw or value is None :\n   return value\n  else :\n   return self._interpolation.before_get(self,section,option,value,\n   d)\n   \n def _get(self,section,conv,option,**kwargs):\n  return conv(self.get(section,option,**kwargs))\n  \n def _get_conv(self,section,option,conv,*,raw=False ,vars=None ,\n fallback=_UNSET,**kwargs):\n  try :\n   return self._get(section,conv,option,raw=raw,vars=vars,\n   **kwargs)\n  except (NoSectionError,NoOptionError):\n   if fallback is _UNSET:\n    raise\n   return fallback\n   \n   \n def getint(self,section,option,*,raw=False ,vars=None ,\n fallback=_UNSET,**kwargs):\n  return self._get_conv(section,option,int,raw=raw,vars=vars,\n  fallback=fallback,**kwargs)\n  \n def getfloat(self,section,option,*,raw=False ,vars=None ,\n fallback=_UNSET,**kwargs):\n  return self._get_conv(section,option,float,raw=raw,vars=vars,\n  fallback=fallback,**kwargs)\n  \n def getboolean(self,section,option,*,raw=False ,vars=None ,\n fallback=_UNSET,**kwargs):\n  return self._get_conv(section,option,self._convert_to_boolean,\n  raw=raw,vars=vars,fallback=fallback,**kwargs)\n  \n def items(self,section=_UNSET,raw=False ,vars=None ):\n  ''\n\n\n\n\n\n\n\n\n  \n  if section is _UNSET:\n   return super().items()\n  d=self._defaults.copy()\n  try :\n   d.update(self._sections[section])\n  except KeyError:\n   if section !=self.default_section:\n    raise NoSectionError(section)\n  orig_keys=list(d.keys())\n  \n  if vars:\n   for key,value in vars.items():\n    d[self.optionxform(key)]=value\n  value_getter=lambda option:self._interpolation.before_get(self,\n  section,option,d[option],d)\n  if raw:\n   value_getter=lambda option:d[option]\n  return [(option,value_getter(option))for option in orig_keys]\n  \n def popitem(self):\n  ''\n\n\n\n\n  \n  for key in self.sections():\n   value=self[key]\n   del self[key]\n   return key,value\n  raise KeyError\n  \n def optionxform(self,optionstr):\n  return optionstr.lower()\n  \n def has_option(self,section,option):\n  ''\n\n  \n  if not section or section ==self.default_section:\n   option=self.optionxform(option)\n   return option in self._defaults\n  elif section not in self._sections:\n   return False\n  else :\n   option=self.optionxform(option)\n   return (option in self._sections[section]\n   or option in self._defaults)\n   \n def set(self,section,option,value=None ):\n  ''\n  if value:\n   value=self._interpolation.before_set(self,section,option,\n   value)\n  if not section or section ==self.default_section:\n   sectdict=self._defaults\n  else :\n   try :\n    sectdict=self._sections[section]\n   except KeyError:\n    raise NoSectionError(section)from None\n  sectdict[self.optionxform(option)]=value\n  \n def write(self,fp,space_around_delimiters=True ):\n  ''\n\n\n\n\n\n\n  \n  if space_around_delimiters:\n   d=\" {} \".format(self._delimiters[0])\n  else :\n   d=self._delimiters[0]\n  if self._defaults:\n   self._write_section(fp,self.default_section,\n   self._defaults.items(),d)\n  for section in self._sections:\n   self._write_section(fp,section,\n   self._sections[section].items(),d)\n   \n def _write_section(self,fp,section_name,section_items,delimiter):\n  ''\n  fp.write(\"[{}]\\n\".format(section_name))\n  for key,value in section_items:\n   value=self._interpolation.before_write(self,section_name,key,\n   value)\n   if value is not None or not self._allow_no_value:\n    value=delimiter+str(value).replace('\\n','\\n\\t')\n   else :\n    value=\"\"\n   fp.write(\"{}{}\\n\".format(key,value))\n  fp.write(\"\\n\")\n  \n def remove_option(self,section,option):\n  ''\n  if not section or section ==self.default_section:\n   sectdict=self._defaults\n  else :\n   try :\n    sectdict=self._sections[section]\n   except KeyError:\n    raise NoSectionError(section)from None\n  option=self.optionxform(option)\n  existed=option in sectdict\n  if existed:\n   del sectdict[option]\n  return existed\n  \n def remove_section(self,section):\n  ''\n  existed=section in self._sections\n  if existed:\n   del self._sections[section]\n   del self._proxies[section]\n  return existed\n  \n def __getitem__(self,key):\n  if key !=self.default_section and not self.has_section(key):\n   raise KeyError(key)\n  return self._proxies[key]\n  \n def __setitem__(self,key,value):\n \n \n  if key in self and self[key]is value:\n   return\n   \n   \n  if key ==self.default_section:\n   self._defaults.clear()\n  elif key in self._sections:\n   self._sections[key].clear()\n  self.read_dict({key:value})\n  \n def __delitem__(self,key):\n  if key ==self.default_section:\n   raise ValueError(\"Cannot remove the default section.\")\n  if not self.has_section(key):\n   raise KeyError(key)\n  self.remove_section(key)\n  \n def __contains__(self,key):\n  return key ==self.default_section or self.has_section(key)\n  \n def __len__(self):\n  return len(self._sections)+1\n  \n def __iter__(self):\n \n  return itertools.chain((self.default_section,),self._sections.keys())\n  \n def _read(self,fp,fpname):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  elements_added=set()\n  cursect=None\n  sectname=None\n  optname=None\n  lineno=0\n  indent_level=0\n  e=None\n  for lineno,line in enumerate(fp,start=1):\n   comment_start=sys.maxsize\n   \n   inline_prefixes={p:-1 for p in self._inline_comment_prefixes}\n   while comment_start ==sys.maxsize and inline_prefixes:\n    next_prefixes={}\n    for prefix,index in inline_prefixes.items():\n     index=line.find(prefix,index+1)\n     if index ==-1:\n      continue\n     next_prefixes[prefix]=index\n     if index ==0 or (index >0 and line[index -1].isspace()):\n      comment_start=min(comment_start,index)\n    inline_prefixes=next_prefixes\n    \n   for prefix in self._comment_prefixes:\n    if line.strip().startswith(prefix):\n     comment_start=0\n     break\n   if comment_start ==sys.maxsize:\n    comment_start=None\n   value=line[:comment_start].strip()\n   if not value:\n    if self._empty_lines_in_values:\n    \n    \n     if (comment_start is None and\n     cursect is not None and\n     optname and\n     cursect[optname]is not None ):\n      cursect[optname].append('')\n    else :\n    \n     indent_level=sys.maxsize\n    continue\n    \n   first_nonspace=self.NONSPACECRE.search(line)\n   cur_indent_level=first_nonspace.start()if first_nonspace else 0\n   if (cursect is not None and optname and\n   cur_indent_level >indent_level):\n    cursect[optname].append(value)\n    \n   else :\n    indent_level=cur_indent_level\n    \n    mo=self.SECTCRE.match(value)\n    if mo:\n     sectname=mo.group('header')\n     if sectname in self._sections:\n      if self._strict and sectname in elements_added:\n       raise DuplicateSectionError(sectname,fpname,\n       lineno)\n      cursect=self._sections[sectname]\n      elements_added.add(sectname)\n     elif sectname ==self.default_section:\n      cursect=self._defaults\n     else :\n      cursect=self._dict()\n      self._sections[sectname]=cursect\n      self._proxies[sectname]=SectionProxy(self,sectname)\n      elements_added.add(sectname)\n      \n     optname=None\n     \n    elif cursect is None :\n     raise MissingSectionHeaderError(fpname,lineno,line)\n     \n    else :\n     mo=self._optcre.match(value)\n     if mo:\n      optname,vi,optval=mo.group('option','vi','value')\n      if not optname:\n       e=self._handle_error(e,fpname,lineno,line)\n      optname=self.optionxform(optname.rstrip())\n      if (self._strict and\n      (sectname,optname)in elements_added):\n       raise DuplicateOptionError(sectname,optname,\n       fpname,lineno)\n      elements_added.add((sectname,optname))\n      \n      \n      if optval is not None :\n       optval=optval.strip()\n       cursect[optname]=[optval]\n      else :\n      \n       cursect[optname]=None\n     else :\n     \n     \n     \n     \n      e=self._handle_error(e,fpname,lineno,line)\n  self._join_multiline_values()\n  \n  if e:\n   raise e\n   \n def _join_multiline_values(self):\n  defaults=self.default_section,self._defaults\n  all_sections=itertools.chain((defaults,),\n  self._sections.items())\n  for section,options in all_sections:\n   for name,val in options.items():\n    if isinstance(val,list):\n     val='\\n'.join(val).rstrip()\n    options[name]=self._interpolation.before_read(self,\n    section,\n    name,val)\n    \n def _read_defaults(self,defaults):\n  ''\n  \n  for key,value in defaults.items():\n   self._defaults[self.optionxform(key)]=value\n   \n def _handle_error(self,exc,fpname,lineno,line):\n  if not exc:\n   exc=ParsingError(fpname)\n  exc.append(lineno,repr(line))\n  return exc\n  \n def _unify_values(self,section,vars):\n  ''\n\n\n  \n  sectiondict={}\n  try :\n   sectiondict=self._sections[section]\n  except KeyError:\n   if section !=self.default_section:\n    raise NoSectionError(section)from None\n    \n  vardict={}\n  if vars:\n   for key,value in vars.items():\n    if value is not None :\n     value=str(value)\n    vardict[self.optionxform(key)]=value\n  return _ChainMap(vardict,sectiondict,self._defaults)\n  \n def _convert_to_boolean(self,value):\n  ''\n  \n  if value.lower()not in self.BOOLEAN_STATES:\n   raise ValueError('Not a boolean: %s'%value)\n  return self.BOOLEAN_STATES[value.lower()]\n  \n def _validate_value_types(self,*,section=\"\",option=\"\",value=\"\"):\n  ''\n\n\n\n\n\n\n\n\n\n\n  \n  if not isinstance(section,str):\n   raise TypeError(\"section names must be strings\")\n  if not isinstance(option,str):\n   raise TypeError(\"option keys must be strings\")\n  if not self._allow_no_value or value:\n   if not isinstance(value,str):\n    raise TypeError(\"option values must be strings\")\n    \n @property\n def converters(self):\n  return self._converters\n  \n  \nclass ConfigParser(RawConfigParser):\n ''\n \n _DEFAULT_INTERPOLATION=BasicInterpolation()\n \n def set(self,section,option,value=None ):\n  ''\n  \n  self._validate_value_types(option=option,value=value)\n  super().set(section,option,value)\n  \n def add_section(self,section):\n  ''\n\n  \n  self._validate_value_types(section=section)\n  super().add_section(section)\n  \n def _read_defaults(self,defaults):\n  ''\n\n\n\n  \n  try :\n   hold_interpolation=self._interpolation\n   self._interpolation=Interpolation()\n   self.read_dict({self.default_section:defaults})\n  finally :\n   self._interpolation=hold_interpolation\n   \n   \nclass SafeConfigParser(ConfigParser):\n ''\n \n def __init__(self,*args,**kwargs):\n  super().__init__(*args,**kwargs)\n  warnings.warn(\n  \"The SafeConfigParser class has been renamed to ConfigParser \"\n  \"in Python 3.2. This alias will be removed in future versions.\"\n  \" Use ConfigParser directly instead.\",\n  DeprecationWarning,stacklevel=2\n  )\n  \n  \nclass SectionProxy(MutableMapping):\n ''\n \n def __init__(self,parser,name):\n  ''\n  self._parser=parser\n  self._name=name\n  for conv in parser.converters:\n   key='get'+conv\n   getter=functools.partial(self.get,_impl=getattr(parser,key))\n   setattr(self,key,getter)\n   \n def __repr__(self):\n  return '<Section: {}>'.format(self._name)\n  \n def __getitem__(self,key):\n  if not self._parser.has_option(self._name,key):\n   raise KeyError(key)\n  return self._parser.get(self._name,key)\n  \n def __setitem__(self,key,value):\n  self._parser._validate_value_types(option=key,value=value)\n  return self._parser.set(self._name,key,value)\n  \n def __delitem__(self,key):\n  if not (self._parser.has_option(self._name,key)and\n  self._parser.remove_option(self._name,key)):\n   raise KeyError(key)\n   \n def __contains__(self,key):\n  return self._parser.has_option(self._name,key)\n  \n def __len__(self):\n  return len(self._options())\n  \n def __iter__(self):\n  return self._options().__iter__()\n  \n def _options(self):\n  if self._name !=self._parser.default_section:\n   return self._parser.options(self._name)\n  else :\n   return self._parser.defaults()\n   \n @property\n def parser(self):\n \n  return self._parser\n  \n @property\n def name(self):\n \n  return self._name\n  \n def get(self,option,fallback=None ,*,raw=False ,vars=None ,\n _impl=None ,**kwargs):\n  ''\n\n\n\n\n  \n  \n  \n  if not _impl:\n   _impl=self._parser.get\n  return _impl(self._name,option,raw=raw,vars=vars,\n  fallback=fallback,**kwargs)\n  \n  \nclass ConverterMapping(MutableMapping):\n ''\n\n\n\n\n \n \n GETTERCRE=re.compile(r\"^get(?P<name>.+)$\")\n \n def __init__(self,parser):\n  self._parser=parser\n  self._data={}\n  for getter in dir(self._parser):\n   m=self.GETTERCRE.match(getter)\n   if not m or not callable(getattr(self._parser,getter)):\n    continue\n   self._data[m.group('name')]=None\n   \n def __getitem__(self,key):\n  return self._data[key]\n  \n def __setitem__(self,key,value):\n  try :\n   k='get'+key\n  except TypeError:\n   raise ValueError('Incompatible key: {} (type: {})'\n   ''.format(key,type(key)))\n  if k =='get':\n   raise ValueError('Incompatible key: cannot use \"\" as a name')\n  self._data[key]=value\n  func=functools.partial(self._parser._get_conv,conv=value)\n  func.converter=value\n  setattr(self._parser,k,func)\n  for proxy in self._parser.values():\n   getter=functools.partial(proxy.get,_impl=func)\n   setattr(proxy,k,getter)\n   \n def __delitem__(self,key):\n  try :\n   k='get'+(key or None )\n  except TypeError:\n   raise KeyError(key)\n  del self._data[key]\n  for inst in itertools.chain((self._parser,),self._parser.values()):\n   try :\n    delattr(inst,k)\n   except AttributeError:\n   \n   \n    continue\n    \n def __iter__(self):\n  return iter(self._data)\n  \n def __len__(self):\n  return len(self._data)\n", ["collections", "collections.abc", "functools", "io", "itertools", "os", "re", "sys", "warnings"]], "contextlib": [".py", "''\nimport abc\nimport sys\nimport _collections_abc\nfrom collections import deque\nfrom functools import wraps\nfrom types import MethodType,GenericAlias\n\n__all__=[\"asynccontextmanager\",\"contextmanager\",\"closing\",\"nullcontext\",\n\"AbstractContextManager\",\"AbstractAsyncContextManager\",\n\"AsyncExitStack\",\"ContextDecorator\",\"ExitStack\",\n\"redirect_stdout\",\"redirect_stderr\",\"suppress\",\"aclosing\"]\n\n\nclass AbstractContextManager(abc.ABC):\n\n ''\n \n __class_getitem__=classmethod(GenericAlias)\n \n def __enter__(self):\n  ''\n  return self\n  \n @abc.abstractmethod\n def __exit__(self,exc_type,exc_value,traceback):\n  ''\n  return None\n  \n @classmethod\n def __subclasshook__(cls,C):\n  if cls is AbstractContextManager:\n   return _collections_abc._check_methods(C,\"__enter__\",\"__exit__\")\n  return NotImplemented\n  \n  \nclass AbstractAsyncContextManager(abc.ABC):\n\n ''\n \n __class_getitem__=classmethod(GenericAlias)\n \n async def __aenter__(self):\n  ''\n  return self\n  \n @abc.abstractmethod\n async def __aexit__(self,exc_type,exc_value,traceback):\n  ''\n  return None\n  \n @classmethod\n def __subclasshook__(cls,C):\n  if cls is AbstractAsyncContextManager:\n   return _collections_abc._check_methods(C,\"__aenter__\",\n   \"__aexit__\")\n  return NotImplemented\n  \n  \nclass ContextDecorator(object):\n ''\n \n def _recreate_cm(self):\n  ''\n\n\n\n\n\n\n\n  \n  return self\n  \n def __call__(self,func):\n  @wraps(func)\n  def inner(*args,**kwds):\n   with self._recreate_cm():\n    return func(*args,**kwds)\n  return inner\n  \n  \nclass AsyncContextDecorator(object):\n ''\n \n def _recreate_cm(self):\n  ''\n  \n  return self\n  \n def __call__(self,func):\n  @wraps(func)\n  async def inner(*args,**kwds):\n   async with self._recreate_cm():\n    return await func(*args,**kwds)\n  return inner\n  \n  \nclass _GeneratorContextManagerBase:\n ''\n \n def __init__(self,func,args,kwds):\n  self.gen=func(*args,**kwds)\n  self.func,self.args,self.kwds=func,args,kwds\n  \n  doc=getattr(func,\"__doc__\",None )\n  if doc is None :\n   doc=type(self).__doc__\n  self.__doc__=doc\n  \n  \n  \n  \n  \n  \n def _recreate_cm(self):\n \n \n \n  return self.__class__(self.func,self.args,self.kwds)\n  \n  \nclass _GeneratorContextManager(\n_GeneratorContextManagerBase,\nAbstractContextManager,\nContextDecorator,\n):\n ''\n \n def __enter__(self):\n \n \n  del self.args,self.kwds,self.func\n  try :\n   return next(self.gen)\n  except StopIteration:\n   raise RuntimeError(\"generator didn't yield\")from None\n   \n def __exit__(self,typ,value,traceback):\n  if typ is None :\n   try :\n    next(self.gen)\n   except StopIteration:\n    return False\n   else :\n    raise RuntimeError(\"generator didn't stop\")\n  else :\n   if value is None :\n   \n   \n    value=typ()\n   try :\n    self.gen.throw(typ,value,traceback)\n   except StopIteration as exc:\n   \n   \n   \n    return exc is not value\n   except RuntimeError as exc:\n   \n    if exc is value:\n     return False\n     \n     \n     \n     \n     \n     \n    if (\n    isinstance(value,StopIteration)\n    and exc.__cause__ is value\n    ):\n     return False\n    raise\n   except BaseException as exc:\n   \n   \n   \n   \n   \n   \n    if exc is not value:\n     raise\n    return False\n   raise RuntimeError(\"generator didn't stop after throw()\")\n   \nclass _AsyncGeneratorContextManager(\n_GeneratorContextManagerBase,\nAbstractAsyncContextManager,\nAsyncContextDecorator,\n):\n ''\n \n async def __aenter__(self):\n \n \n  del self.args,self.kwds,self.func\n  try :\n   return await anext(self.gen)\n  except StopAsyncIteration:\n   raise RuntimeError(\"generator didn't yield\")from None\n   \n async def __aexit__(self,typ,value,traceback):\n  if typ is None :\n   try :\n    await anext(self.gen)\n   except StopAsyncIteration:\n    return False\n   else :\n    raise RuntimeError(\"generator didn't stop\")\n  else :\n   if value is None :\n   \n   \n    value=typ()\n   try :\n    await self.gen.athrow(typ,value,traceback)\n   except StopAsyncIteration as exc:\n   \n   \n   \n    return exc is not value\n   except RuntimeError as exc:\n   \n    if exc is value:\n     return False\n     \n     \n     \n     \n     \n     \n    if (\n    isinstance(value,(StopIteration,StopAsyncIteration))\n    and exc.__cause__ is value\n    ):\n     return False\n    raise\n   except BaseException as exc:\n   \n   \n   \n   \n   \n   \n    if exc is not value:\n     raise\n    return False\n   raise RuntimeError(\"generator didn't stop after athrow()\")\n   \n   \ndef contextmanager(func):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n @wraps(func)\n def helper(*args,**kwds):\n  return _GeneratorContextManager(func,args,kwds)\n return helper\n \n \ndef asynccontextmanager(func):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n @wraps(func)\n def helper(*args,**kwds):\n  return _AsyncGeneratorContextManager(func,args,kwds)\n return helper\n \n \nclass closing(AbstractContextManager):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n def __init__(self,thing):\n  self.thing=thing\n def __enter__(self):\n  return self.thing\n def __exit__(self,*exc_info):\n  self.thing.close()\n  \n  \nclass aclosing(AbstractAsyncContextManager):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n def __init__(self,thing):\n  self.thing=thing\n async def __aenter__(self):\n  return self.thing\n async def __aexit__(self,*exc_info):\n  await self.thing.aclose()\n  \n  \nclass _RedirectStream(AbstractContextManager):\n\n _stream=None\n \n def __init__(self,new_target):\n  self._new_target=new_target\n  \n  self._old_targets=[]\n  \n def __enter__(self):\n  self._old_targets.append(getattr(sys,self._stream))\n  setattr(sys,self._stream,self._new_target)\n  return self._new_target\n  \n def __exit__(self,exctype,excinst,exctb):\n  setattr(sys,self._stream,self._old_targets.pop())\n  \n  \nclass redirect_stdout(_RedirectStream):\n ''\n\n\n\n\n\n\n\n\n\n \n \n _stream=\"stdout\"\n \n \nclass redirect_stderr(_RedirectStream):\n ''\n \n _stream=\"stderr\"\n \n \nclass suppress(AbstractContextManager):\n ''\n\n\n\n\n\n\n\n \n \n def __init__(self,*exceptions):\n  self._exceptions=exceptions\n  \n def __enter__(self):\n  pass\n  \n def __exit__(self,exctype,excinst,exctb):\n \n \n \n \n \n \n \n \n \n  return exctype is not None and issubclass(exctype,self._exceptions)\n  \n  \nclass _BaseExitStack:\n ''\n \n @staticmethod\n def _create_exit_wrapper(cm,cm_exit):\n  return MethodType(cm_exit,cm)\n  \n @staticmethod\n def _create_cb_wrapper(callback,/,*args,**kwds):\n  def _exit_wrapper(exc_type,exc,tb):\n   callback(*args,**kwds)\n  return _exit_wrapper\n  \n def __init__(self):\n  self._exit_callbacks=deque()\n  \n def pop_all(self):\n  ''\n  new_stack=type(self)()\n  new_stack._exit_callbacks=self._exit_callbacks\n  self._exit_callbacks=deque()\n  return new_stack\n  \n def push(self,exit):\n  ''\n\n\n\n\n  \n  \n  \n  _cb_type=type(exit)\n  \n  try :\n   exit_method=_cb_type.__exit__\n  except AttributeError:\n  \n   self._push_exit_callback(exit)\n  else :\n   self._push_cm_exit(exit,exit_method)\n  return exit\n  \n def enter_context(self,cm):\n  ''\n\n\n\n  \n  \n  \n  _cm_type=type(cm)\n  _exit=_cm_type.__exit__\n  result=_cm_type.__enter__(cm)\n  self._push_cm_exit(cm,_exit)\n  return result\n  \n def callback(self,callback,/,*args,**kwds):\n  ''\n\n\n  \n  _exit_wrapper=self._create_cb_wrapper(callback,*args,**kwds)\n  \n  \n  \n  _exit_wrapper.__wrapped__=callback\n  self._push_exit_callback(_exit_wrapper)\n  return callback\n  \n def _push_cm_exit(self,cm,cm_exit):\n  ''\n  _exit_wrapper=self._create_exit_wrapper(cm,cm_exit)\n  self._push_exit_callback(_exit_wrapper,True )\n  \n def _push_exit_callback(self,callback,is_sync=True ):\n  self._exit_callbacks.append((is_sync,callback))\n  \n  \n  \nclass ExitStack(_BaseExitStack,AbstractContextManager):\n ''\n\n\n\n\n\n\n\n \n \n def __enter__(self):\n  return self\n  \n def __exit__(self,*exc_details):\n  received_exc=exc_details[0]is not None\n  \n  \n  \n  frame_exc=sys.exc_info()[1]\n  def _fix_exception_context(new_exc,old_exc):\n  \n   while 1:\n    exc_context=new_exc.__context__\n    if exc_context is old_exc:\n    \n     return\n    if exc_context is None or exc_context is frame_exc:\n     break\n    new_exc=exc_context\n    \n    \n   new_exc.__context__=old_exc\n   \n   \n   \n  suppressed_exc=False\n  pending_raise=False\n  while self._exit_callbacks:\n   is_sync,cb=self._exit_callbacks.pop()\n   assert is_sync\n   try :\n    if cb(*exc_details):\n     suppressed_exc=True\n     pending_raise=False\n     exc_details=(None ,None ,None )\n   except :\n    new_exc_details=sys.exc_info()\n    \n    _fix_exception_context(new_exc_details[1],exc_details[1])\n    pending_raise=True\n    exc_details=new_exc_details\n  if pending_raise:\n   try :\n   \n   \n    fixed_ctx=exc_details[1].__context__\n    raise exc_details[1]\n   except BaseException:\n    exc_details[1].__context__=fixed_ctx\n    raise\n  return received_exc and suppressed_exc\n  \n def close(self):\n  ''\n  self.__exit__(None ,None ,None )\n  \n  \n  \nclass AsyncExitStack(_BaseExitStack,AbstractAsyncContextManager):\n ''\n\n\n\n\n\n\n\n\n\n \n \n @staticmethod\n def _create_async_exit_wrapper(cm,cm_exit):\n  return MethodType(cm_exit,cm)\n  \n @staticmethod\n def _create_async_cb_wrapper(callback,/,*args,**kwds):\n  async def _exit_wrapper(exc_type,exc,tb):\n   await callback(*args,**kwds)\n  return _exit_wrapper\n  \n async def enter_async_context(self,cm):\n  ''\n\n\n\n  \n  _cm_type=type(cm)\n  _exit=_cm_type.__aexit__\n  result=await _cm_type.__aenter__(cm)\n  self._push_async_cm_exit(cm,_exit)\n  return result\n  \n def push_async_exit(self,exit):\n  ''\n\n\n\n\n\n  \n  _cb_type=type(exit)\n  try :\n   exit_method=_cb_type.__aexit__\n  except AttributeError:\n  \n   self._push_exit_callback(exit,False )\n  else :\n   self._push_async_cm_exit(exit,exit_method)\n  return exit\n  \n def push_async_callback(self,callback,/,*args,**kwds):\n  ''\n\n\n  \n  _exit_wrapper=self._create_async_cb_wrapper(callback,*args,**kwds)\n  \n  \n  \n  _exit_wrapper.__wrapped__=callback\n  self._push_exit_callback(_exit_wrapper,False )\n  return callback\n  \n async def aclose(self):\n  ''\n  await self.__aexit__(None ,None ,None )\n  \n def _push_async_cm_exit(self,cm,cm_exit):\n  ''\n  \n  _exit_wrapper=self._create_async_exit_wrapper(cm,cm_exit)\n  self._push_exit_callback(_exit_wrapper,False )\n  \n async def __aenter__(self):\n  return self\n  \n async def __aexit__(self,*exc_details):\n  received_exc=exc_details[0]is not None\n  \n  \n  \n  frame_exc=sys.exc_info()[1]\n  def _fix_exception_context(new_exc,old_exc):\n  \n   while 1:\n    exc_context=new_exc.__context__\n    if exc_context is old_exc:\n    \n     return\n    if exc_context is None or exc_context is frame_exc:\n     break\n    new_exc=exc_context\n    \n    \n   new_exc.__context__=old_exc\n   \n   \n   \n  suppressed_exc=False\n  pending_raise=False\n  while self._exit_callbacks:\n   is_sync,cb=self._exit_callbacks.pop()\n   try :\n    if is_sync:\n     cb_suppress=cb(*exc_details)\n    else :\n     cb_suppress=await cb(*exc_details)\n     \n    if cb_suppress:\n     suppressed_exc=True\n     pending_raise=False\n     exc_details=(None ,None ,None )\n   except :\n    new_exc_details=sys.exc_info()\n    \n    _fix_exception_context(new_exc_details[1],exc_details[1])\n    pending_raise=True\n    exc_details=new_exc_details\n  if pending_raise:\n   try :\n   \n   \n    fixed_ctx=exc_details[1].__context__\n    raise exc_details[1]\n   except BaseException:\n    exc_details[1].__context__=fixed_ctx\n    raise\n  return received_exc and suppressed_exc\n  \n  \nclass nullcontext(AbstractContextManager,AbstractAsyncContextManager):\n ''\n\n\n\n\n\n\n\n \n \n def __init__(self,enter_result=None ):\n  self.enter_result=enter_result\n  \n def __enter__(self):\n  return self.enter_result\n  \n def __exit__(self,*excinfo):\n  pass\n  \n async def __aenter__(self):\n  return self.enter_result\n  \n async def __aexit__(self,*excinfo):\n  pass\n", ["_collections_abc", "abc", "collections", "functools", "sys", "types"]], "contextvars": [".py", "from _contextvars import Context,ContextVar,Token,copy_context\n\n\n__all__=('Context','ContextVar','Token','copy_context')\n", ["_contextvars"]], "copy": [".py", "''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nimport types\nimport weakref\nfrom copyreg import dispatch_table\n\nclass Error(Exception):\n pass\nerror=Error\n\ntry :\n from org.python.core import PyStringMap\nexcept ImportError:\n PyStringMap=None\n \n__all__=[\"Error\",\"copy\",\"deepcopy\"]\n\ndef copy(x):\n ''\n\n\n \n \n cls=type(x)\n \n copier=_copy_dispatch.get(cls)\n if copier:\n  return copier(x)\n  \n if issubclass(cls,type):\n \n  return _copy_immutable(x)\n  \n copier=getattr(cls,\"__copy__\",None )\n if copier is not None :\n  return copier(x)\n  \n reductor=dispatch_table.get(cls)\n if reductor is not None :\n  rv=reductor(x)\n else :\n  reductor=getattr(x,\"__reduce_ex__\",None )\n  if reductor is not None :\n   rv=reductor(4)\n  else :\n   reductor=getattr(x,\"__reduce__\",None )\n   if reductor:\n    rv=reductor()\n   else :\n    raise Error(\"un(shallow)copyable object of type %s\"%cls)\n    \n if isinstance(rv,str):\n  return x\n return _reconstruct(x,None ,*rv)\n \n \n_copy_dispatch=d={}\n\ndef _copy_immutable(x):\n return x\nfor t in (type(None ),int,float,bool,complex,str,tuple,\nbytes,frozenset,type,range,slice,property,\ntypes.BuiltinFunctionType,type(Ellipsis),type(NotImplemented),\ntypes.FunctionType,weakref.ref):\n d[t]=_copy_immutable\nt=getattr(types,\"CodeType\",None )\nif t is not None :\n d[t]=_copy_immutable\n \nd[list]=list.copy\nd[dict]=dict.copy\nd[set]=set.copy\nd[bytearray]=bytearray.copy\n\nif PyStringMap is not None :\n d[PyStringMap]=PyStringMap.copy\n \ndel d,t\n\ndef deepcopy(x,memo=None ,_nil=[]):\n ''\n\n\n \n \n if memo is None :\n  memo={}\n  \n d=id(x)\n y=memo.get(d,_nil)\n if y is not _nil:\n  return y\n  \n cls=type(x)\n \n copier=_deepcopy_dispatch.get(cls)\n if copier is not None :\n  y=copier(x,memo)\n else :\n  if issubclass(cls,type):\n   y=_deepcopy_atomic(x,memo)\n  else :\n   copier=getattr(x,\"__deepcopy__\",None )\n   if copier is not None :\n    y=copier(memo)\n   else :\n    reductor=dispatch_table.get(cls)\n    if reductor:\n     rv=reductor(x)\n    else :\n     reductor=getattr(x,\"__reduce_ex__\",None )\n     if reductor is not None :\n      rv=reductor(4)\n     else :\n      reductor=getattr(x,\"__reduce__\",None )\n      if reductor:\n       rv=reductor()\n      else :\n       raise Error(\n       \"un(deep)copyable object of type %s\"%cls)\n    if isinstance(rv,str):\n     y=x\n    else :\n     y=_reconstruct(x,memo,*rv)\n     \n     \n if y is not x:\n  memo[d]=y\n  _keep_alive(x,memo)\n return y\n \n_deepcopy_dispatch=d={}\n\ndef _deepcopy_atomic(x,memo):\n return x\nd[type(None )]=_deepcopy_atomic\nd[type(Ellipsis)]=_deepcopy_atomic\nd[type(NotImplemented)]=_deepcopy_atomic\nd[int]=_deepcopy_atomic\nd[float]=_deepcopy_atomic\nd[bool]=_deepcopy_atomic\nd[complex]=_deepcopy_atomic\nd[bytes]=_deepcopy_atomic\nd[str]=_deepcopy_atomic\nd[types.CodeType]=_deepcopy_atomic\nd[type]=_deepcopy_atomic\nd[range]=_deepcopy_atomic\nd[types.BuiltinFunctionType]=_deepcopy_atomic\nd[types.FunctionType]=_deepcopy_atomic\nd[weakref.ref]=_deepcopy_atomic\nd[property]=_deepcopy_atomic\n\ndef _deepcopy_list(x,memo,deepcopy=deepcopy):\n y=[]\n memo[id(x)]=y\n append=y.append\n for a in x:\n  append(deepcopy(a,memo))\n return y\nd[list]=_deepcopy_list\n\ndef _deepcopy_tuple(x,memo,deepcopy=deepcopy):\n y=[deepcopy(a,memo)for a in x]\n \n \n try :\n  return memo[id(x)]\n except KeyError:\n  pass\n for k,j in zip(x,y):\n  if k is not j:\n   y=tuple(y)\n   break\n else :\n  y=x\n return y\nd[tuple]=_deepcopy_tuple\n\ndef _deepcopy_dict(x,memo,deepcopy=deepcopy):\n y={}\n memo[id(x)]=y\n for key,value in x.items():\n  y[deepcopy(key,memo)]=deepcopy(value,memo)\n return y\nd[dict]=_deepcopy_dict\nif PyStringMap is not None :\n d[PyStringMap]=_deepcopy_dict\n \ndef _deepcopy_method(x,memo):\n return type(x)(x.__func__,deepcopy(x.__self__,memo))\nd[types.MethodType]=_deepcopy_method\n\ndel d\n\ndef _keep_alive(x,memo):\n ''\n\n\n\n\n\n\n\n \n try :\n  memo[id(memo)].append(x)\n except KeyError:\n \n  memo[id(memo)]=[x]\n  \ndef _reconstruct(x,memo,func,args,\nstate=None ,listiter=None ,dictiter=None ,\ndeepcopy=deepcopy):\n deep=memo is not None\n if deep and args:\n  args=(deepcopy(arg,memo)for arg in args)\n y=func(*args)\n if deep:\n  memo[id(x)]=y\n  \n if state is not None :\n  if deep:\n   state=deepcopy(state,memo)\n  if hasattr(y,'__setstate__'):\n   y.__setstate__(state)\n  else :\n   if isinstance(state,tuple)and len(state)==2:\n    state,slotstate=state\n   else :\n    slotstate=None\n   if state is not None :\n    y.__dict__.update(state)\n   if slotstate is not None :\n    for key,value in slotstate.items():\n     setattr(y,key,value)\n     \n if listiter is not None :\n  if deep:\n   for item in listiter:\n    item=deepcopy(item,memo)\n    y.append(item)\n  else :\n   for item in listiter:\n    y.append(item)\n if dictiter is not None :\n  if deep:\n   for key,value in dictiter:\n    key=deepcopy(key,memo)\n    value=deepcopy(value,memo)\n    y[key]=value\n  else :\n   for key,value in dictiter:\n    y[key]=value\n return y\n \ndel types,weakref,PyStringMap\n", ["copyreg", "org.python.core", "types", "weakref"]], "copyreg": [".py", "''\n\n\n\n\n\n__all__=[\"pickle\",\"constructor\",\n\"add_extension\",\"remove_extension\",\"clear_extension_cache\"]\n\ndispatch_table={}\n\ndef pickle(ob_type,pickle_function,constructor_ob=None ):\n if not callable(pickle_function):\n  raise TypeError(\"reduction functions must be callable\")\n dispatch_table[ob_type]=pickle_function\n \n \n \n if constructor_ob is not None :\n  constructor(constructor_ob)\n  \ndef constructor(object):\n if not callable(object):\n  raise TypeError(\"constructors must be callable\")\n  \n  \n  \ntry :\n complex\nexcept NameError:\n pass\nelse :\n\n def pickle_complex(c):\n  return complex,(c.real,c.imag)\n  \n pickle(complex,pickle_complex,complex)\n \ndef pickle_union(obj):\n import functools,operator\n return functools.reduce,(operator.or_,obj.__args__)\n \npickle(type(int |str),pickle_union)\n\n\n\ndef _reconstructor(cls,base,state):\n if base is object:\n  obj=object.__new__(cls)\n else :\n  obj=base.__new__(cls,state)\n  if base.__init__ !=object.__init__:\n   base.__init__(obj,state)\n return obj\n \n_HEAPTYPE=1 <<9\n_new_type=type(int.__new__)\n\n\n\ndef _reduce_ex(self,proto):\n assert proto <2\n cls=self.__class__\n for base in cls.__mro__:\n  if hasattr(base,'__flags__')and not base.__flags__&_HEAPTYPE:\n   break\n  new=base.__new__\n  if isinstance(new,_new_type)and new.__self__ is base:\n   break\n else :\n  base=object\n if base is object:\n  state=None\n else :\n  if base is cls:\n   raise TypeError(f\"cannot pickle {cls.__name__!r} object\")\n  state=base(self)\n args=(cls,base,state)\n try :\n  getstate=self.__getstate__\n except AttributeError:\n  if getattr(self,\"__slots__\",None ):\n   raise TypeError(f\"cannot pickle {cls.__name__!r} object: \"\n   f\"a class that defines __slots__ without \"\n   f\"defining __getstate__ cannot be pickled \"\n   f\"with protocol {proto}\")from None\n  try :\n   dict=self.__dict__\n  except AttributeError:\n   dict=None\n else :\n  dict=getstate()\n if dict:\n  return _reconstructor,args,dict\n else :\n  return _reconstructor,args\n  \n  \n  \ndef __newobj__(cls,*args):\n return cls.__new__(cls,*args)\n \ndef __newobj_ex__(cls,args,kwargs):\n ''\n\n \n return cls.__new__(cls,*args,**kwargs)\n \ndef _slotnames(cls):\n ''\n\n\n\n\n\n\n\n \n \n \n names=cls.__dict__.get(\"__slotnames__\")\n if names is not None :\n  return names\n  \n  \n names=[]\n if not hasattr(cls,\"__slots__\"):\n \n  pass\n else :\n \n  for c in cls.__mro__:\n   if \"__slots__\"in c.__dict__:\n    slots=c.__dict__['__slots__']\n    \n    if isinstance(slots,str):\n     slots=(slots,)\n    for name in slots:\n    \n     if name in (\"__dict__\",\"__weakref__\"):\n      continue\n      \n     elif name.startswith('__')and not name.endswith('__'):\n      stripped=c.__name__.lstrip('_')\n      if stripped:\n       names.append('_%s%s'%(stripped,name))\n      else :\n       names.append(name)\n     else :\n      names.append(name)\n      \n      \n try :\n  cls.__slotnames__=names\n except :\n  pass\n  \n return names\n \n \n \n \n \n \n \n \n \n \n_extension_registry={}\n_inverted_registry={}\n_extension_cache={}\n\n\n\ndef add_extension(module,name,code):\n ''\n code=int(code)\n if not 1 <=code <=0x7fffffff:\n  raise ValueError(\"code out of range\")\n key=(module,name)\n if (_extension_registry.get(key)==code and\n _inverted_registry.get(code)==key):\n  return\n if key in _extension_registry:\n  raise ValueError(\"key %s is already registered with code %s\"%\n  (key,_extension_registry[key]))\n if code in _inverted_registry:\n  raise ValueError(\"code %s is already in use for key %s\"%\n  (code,_inverted_registry[code]))\n _extension_registry[key]=code\n _inverted_registry[code]=key\n \ndef remove_extension(module,name,code):\n ''\n key=(module,name)\n if (_extension_registry.get(key)!=code or\n _inverted_registry.get(code)!=key):\n  raise ValueError(\"key %s is not registered with code %s\"%\n  (key,code))\n del _extension_registry[key]\n del _inverted_registry[code]\n if code in _extension_cache:\n  del _extension_cache[code]\n  \ndef clear_extension_cache():\n _extension_cache.clear()\n \n \n \n \n \n \n \n \n \n \n \n \n \n", ["functools", "operator"]], "csv": [".py", "\n\"\"\"\ncsv.py - read/write/investigate CSV files\n\"\"\"\n\nimport re\nfrom _csv import Error,__version__,writer,reader,register_dialect,\\\nunregister_dialect,get_dialect,list_dialects,\\\nfield_size_limit,\\\nQUOTE_MINIMAL,QUOTE_ALL,QUOTE_NONNUMERIC,QUOTE_NONE,\\\n__doc__\nfrom _csv import Dialect as _Dialect\n\nfrom io import StringIO\n\n__all__=[\"QUOTE_MINIMAL\",\"QUOTE_ALL\",\"QUOTE_NONNUMERIC\",\"QUOTE_NONE\",\n\"Error\",\"Dialect\",\"__doc__\",\"excel\",\"excel_tab\",\n\"field_size_limit\",\"reader\",\"writer\",\n\"register_dialect\",\"get_dialect\",\"list_dialects\",\"Sniffer\",\n\"unregister_dialect\",\"__version__\",\"DictReader\",\"DictWriter\",\n\"unix_dialect\"]\n\nclass Dialect:\n ''\n\n\n\n\n\n \n _name=\"\"\n _valid=False\n \n delimiter=None\n quotechar=None\n escapechar=None\n doublequote=None\n skipinitialspace=None\n lineterminator=None\n quoting=None\n \n def __init__(self):\n  if self.__class__ !=Dialect:\n   self._valid=True\n  self._validate()\n  \n def _validate(self):\n  try :\n   _Dialect(self)\n  except TypeError as e:\n  \n   raise Error(str(e))\n   \nclass excel(Dialect):\n ''\n delimiter=','\n quotechar='\"'\n doublequote=True\n skipinitialspace=False\n lineterminator='\\r\\n'\n quoting=QUOTE_MINIMAL\nregister_dialect(\"excel\",excel)\n\nclass excel_tab(excel):\n ''\n delimiter='\\t'\nregister_dialect(\"excel-tab\",excel_tab)\n\nclass unix_dialect(Dialect):\n ''\n delimiter=','\n quotechar='\"'\n doublequote=True\n skipinitialspace=False\n lineterminator='\\n'\n quoting=QUOTE_ALL\nregister_dialect(\"unix\",unix_dialect)\n\n\nclass DictReader:\n def __init__(self,f,fieldnames=None ,restkey=None ,restval=None ,\n dialect=\"excel\",*args,**kwds):\n  self._fieldnames=fieldnames\n  self.restkey=restkey\n  self.restval=restval\n  self.reader=reader(f,dialect,*args,**kwds)\n  self.dialect=dialect\n  self.line_num=0\n  \n def __iter__(self):\n  return self\n  \n @property\n def fieldnames(self):\n  if self._fieldnames is None :\n   try :\n    self._fieldnames=next(self.reader)\n   except StopIteration:\n    pass\n  self.line_num=self.reader.line_num\n  return self._fieldnames\n  \n @fieldnames.setter\n def fieldnames(self,value):\n  self._fieldnames=value\n  \n def __next__(self):\n  if self.line_num ==0:\n  \n   self.fieldnames\n  row=next(self.reader)\n  self.line_num=self.reader.line_num\n  \n  \n  \n  \n  while row ==[]:\n   row=next(self.reader)\n  d=dict(zip(self.fieldnames,row))\n  lf=len(self.fieldnames)\n  lr=len(row)\n  if lf <lr:\n   d[self.restkey]=row[lf:]\n  elif lf >lr:\n   for key in self.fieldnames[lr:]:\n    d[key]=self.restval\n  return d\n  \n  \nclass DictWriter:\n def __init__(self,f,fieldnames,restval=\"\",extrasaction=\"raise\",\n dialect=\"excel\",*args,**kwds):\n  self.fieldnames=fieldnames\n  self.restval=restval\n  if extrasaction.lower()not in (\"raise\",\"ignore\"):\n   raise ValueError(\"extrasaction (%s) must be 'raise' or 'ignore'\"\n   %extrasaction)\n  self.extrasaction=extrasaction\n  self.writer=writer(f,dialect,*args,**kwds)\n  \n def writeheader(self):\n  header=dict(zip(self.fieldnames,self.fieldnames))\n  return self.writerow(header)\n  \n def _dict_to_list(self,rowdict):\n  if self.extrasaction ==\"raise\":\n   wrong_fields=rowdict.keys()-self.fieldnames\n   if wrong_fields:\n    raise ValueError(\"dict contains fields not in fieldnames: \"\n    +\", \".join([repr(x)for x in wrong_fields]))\n  return (rowdict.get(key,self.restval)for key in self.fieldnames)\n  \n def writerow(self,rowdict):\n  return self.writer.writerow(self._dict_to_list(rowdict))\n  \n def writerows(self,rowdicts):\n  return self.writer.writerows(map(self._dict_to_list,rowdicts))\n  \n  \ntry :\n complex\nexcept NameError:\n complex=float\n \nclass Sniffer:\n ''\n\n\n \n def __init__(self):\n \n  self.preferred=[',','\\t',';',' ',':']\n  \n  \n def sniff(self,sample,delimiters=None ):\n  ''\n\n  \n  \n  quotechar,doublequote,delimiter,skipinitialspace=\\\n  self._guess_quote_and_delimiter(sample,delimiters)\n  if not delimiter:\n   delimiter,skipinitialspace=self._guess_delimiter(sample,\n   delimiters)\n   \n  if not delimiter:\n   raise Error(\"Could not determine delimiter\")\n   \n  class dialect(Dialect):\n   _name=\"sniffed\"\n   lineterminator='\\r\\n'\n   quoting=QUOTE_MINIMAL\n   \n   \n  dialect.doublequote=doublequote\n  dialect.delimiter=delimiter\n  \n  dialect.quotechar=quotechar or '\"'\n  dialect.skipinitialspace=skipinitialspace\n  \n  return dialect\n  \n  \n def _guess_quote_and_delimiter(self,data,delimiters):\n  ''\n\n\n\n\n\n\n\n\n  \n  \n  matches=[]\n  for restr in (r'(?P<delim>[^\\w\\n\"\\'])(?P<space> ?)(?P<quote>[\"\\']).*?(?P=quote)(?P=delim)',\n  r'(?:^|\\n)(?P<quote>[\"\\']).*?(?P=quote)(?P<delim>[^\\w\\n\"\\'])(?P<space> ?)',\n  r'(?P<delim>[^\\w\\n\"\\'])(?P<space> ?)(?P<quote>[\"\\']).*?(?P=quote)(?:$|\\n)',\n  r'(?:^|\\n)(?P<quote>[\"\\']).*?(?P=quote)(?:$|\\n)'):\n   regexp=re.compile(restr,re.DOTALL |re.MULTILINE)\n   matches=regexp.findall(data)\n   if matches:\n    break\n    \n  if not matches:\n  \n   return ('',False ,None ,0)\n  quotes={}\n  delims={}\n  spaces=0\n  groupindex=regexp.groupindex\n  for m in matches:\n   n=groupindex['quote']-1\n   key=m[n]\n   if key:\n    quotes[key]=quotes.get(key,0)+1\n   try :\n    n=groupindex['delim']-1\n    key=m[n]\n   except KeyError:\n    continue\n   if key and (delimiters is None or key in delimiters):\n    delims[key]=delims.get(key,0)+1\n   try :\n    n=groupindex['space']-1\n   except KeyError:\n    continue\n   if m[n]:\n    spaces +=1\n    \n  quotechar=max(quotes,key=quotes.get)\n  \n  if delims:\n   delim=max(delims,key=delims.get)\n   skipinitialspace=delims[delim]==spaces\n   if delim =='\\n':\n    delim=''\n  else :\n  \n   delim=''\n   skipinitialspace=0\n   \n   \n   \n  dq_regexp=re.compile(\n  r\"((%(delim)s)|^)\\W*%(quote)s[^%(delim)s\\n]*%(quote)s[^%(delim)s\\n]*%(quote)s\\W*((%(delim)s)|$)\"%\\\n  {'delim':re.escape(delim),'quote':quotechar},re.MULTILINE)\n  \n  \n  \n  if dq_regexp.search(data):\n   doublequote=True\n  else :\n   doublequote=False\n   \n  return (quotechar,doublequote,delim,skipinitialspace)\n  \n  \n def _guess_delimiter(self,data,delimiters):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  data=list(filter(None ,data.split('\\n')))\n  \n  ascii=[chr(c)for c in range(127)]\n  \n  \n  chunkLength=min(10,len(data))\n  iteration=0\n  charFrequency={}\n  modes={}\n  delims={}\n  start,end=0,chunkLength\n  while start <len(data):\n   iteration +=1\n   for line in data[start:end]:\n    for char in ascii:\n     metaFrequency=charFrequency.get(char,{})\n     \n     freq=line.count(char)\n     \n     metaFrequency[freq]=metaFrequency.get(freq,0)+1\n     charFrequency[char]=metaFrequency\n     \n   for char in charFrequency.keys():\n    items=list(charFrequency[char].items())\n    if len(items)==1 and items[0][0]==0:\n     continue\n     \n    if len(items)>1:\n     modes[char]=max(items,key=lambda x:x[1])\n     \n     \n     items.remove(modes[char])\n     modes[char]=(modes[char][0],modes[char][1]\n     -sum(item[1]for item in items))\n    else :\n     modes[char]=items[0]\n     \n     \n   modeList=modes.items()\n   total=float(min(chunkLength *iteration,len(data)))\n   \n   consistency=1.0\n   \n   threshold=0.9\n   while len(delims)==0 and consistency >=threshold:\n    for k,v in modeList:\n     if v[0]>0 and v[1]>0:\n      if ((v[1]/total)>=consistency and\n      (delimiters is None or k in delimiters)):\n       delims[k]=v\n    consistency -=0.01\n    \n   if len(delims)==1:\n    delim=list(delims.keys())[0]\n    skipinitialspace=(data[0].count(delim)==\n    data[0].count(\"%c \"%delim))\n    return (delim,skipinitialspace)\n    \n    \n   start=end\n   end +=chunkLength\n   \n  if not delims:\n   return ('',0)\n   \n   \n  if len(delims)>1:\n   for d in self.preferred:\n    if d in delims.keys():\n     skipinitialspace=(data[0].count(d)==\n     data[0].count(\"%c \"%d))\n     return (d,skipinitialspace)\n     \n     \n     \n  items=[(v,k)for (k,v)in delims.items()]\n  items.sort()\n  delim=items[-1][1]\n  \n  skipinitialspace=(data[0].count(delim)==\n  data[0].count(\"%c \"%delim))\n  return (delim,skipinitialspace)\n  \n  \n def has_header(self,sample):\n \n \n \n \n \n \n \n \n \n  rdr=reader(StringIO(sample),self.sniff(sample))\n  \n  header=next(rdr)\n  \n  columns=len(header)\n  columnTypes={}\n  for i in range(columns):columnTypes[i]=None\n  \n  checked=0\n  for row in rdr:\n  \n   if checked >20:\n    break\n   checked +=1\n   \n   if len(row)!=columns:\n    continue\n    \n   for col in list(columnTypes.keys()):\n    thisType=complex\n    try :\n     thisType(row[col])\n    except (ValueError,OverflowError):\n    \n     thisType=len(row[col])\n     \n    if thisType !=columnTypes[col]:\n     if columnTypes[col]is None :\n      columnTypes[col]=thisType\n     else :\n     \n     \n      del columnTypes[col]\n      \n      \n      \n  hasHeader=0\n  for col,colType in columnTypes.items():\n   if type(colType)==type(0):\n    if len(header[col])!=colType:\n     hasHeader +=1\n    else :\n     hasHeader -=1\n   else :\n    try :\n     colType(header[col])\n    except (ValueError,TypeError):\n     hasHeader +=1\n    else :\n     hasHeader -=1\n     \n  return hasHeader >0\n", ["_csv", "io", "re"]], "dataclasses": [".py", "import re\nimport sys\nimport copy\nimport types\nimport inspect\nimport keyword\nimport builtins\nimport functools\nimport abc\nimport _thread\nfrom types import FunctionType,GenericAlias\n\n\n__all__=['dataclass',\n'field',\n'Field',\n'FrozenInstanceError',\n'InitVar',\n'KW_ONLY',\n'MISSING',\n\n\n'fields',\n'asdict',\n'astuple',\n'make_dataclass',\n'replace',\n'is_dataclass',\n]\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nclass FrozenInstanceError(AttributeError):pass\n\n\n\n\nclass _HAS_DEFAULT_FACTORY_CLASS:\n def __repr__(self):\n  return '<factory>'\n_HAS_DEFAULT_FACTORY=_HAS_DEFAULT_FACTORY_CLASS()\n\n\n\nclass _MISSING_TYPE:\n pass\nMISSING=_MISSING_TYPE()\n\n\n\nclass _KW_ONLY_TYPE:\n pass\nKW_ONLY=_KW_ONLY_TYPE()\n\n\n\n_EMPTY_METADATA=types.MappingProxyType({})\n\n\nclass _FIELD_BASE:\n def __init__(self,name):\n  self.name=name\n def __repr__(self):\n  return self.name\n_FIELD=_FIELD_BASE('_FIELD')\n_FIELD_CLASSVAR=_FIELD_BASE('_FIELD_CLASSVAR')\n_FIELD_INITVAR=_FIELD_BASE('_FIELD_INITVAR')\n\n\n\n_FIELDS='__dataclass_fields__'\n\n\n\n_PARAMS='__dataclass_params__'\n\n\n\n_POST_INIT_NAME='__post_init__'\n\n\n\n\n_MODULE_IDENTIFIER_RE=re.compile(r'^(?:\\s*(\\w+)\\s*\\.)?\\s*(\\w+)')\n\nclass InitVar:\n __slots__=('type',)\n \n def __init__(self,type):\n  self.type=type\n  \n def __repr__(self):\n  if isinstance(self.type,type):\n   type_name=self.type.__name__\n  else :\n  \n   type_name=repr(self.type)\n  return f'dataclasses.InitVar[{type_name}]'\n  \n def __class_getitem__(cls,type):\n  return InitVar(type)\n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \nclass Field:\n __slots__=('name',\n 'type',\n 'default',\n 'default_factory',\n 'repr',\n 'hash',\n 'init',\n 'compare',\n 'metadata',\n 'kw_only',\n '_field_type',\n )\n \n def __init__(self,default,default_factory,init,repr,hash,compare,\n metadata,kw_only):\n  self.name=None\n  self.type=None\n  self.default=default\n  self.default_factory=default_factory\n  self.init=init\n  self.repr=repr\n  self.hash=hash\n  self.compare=compare\n  self.metadata=(_EMPTY_METADATA\n  if metadata is None else\n  types.MappingProxyType(metadata))\n  self.kw_only=kw_only\n  self._field_type=None\n  \n def __repr__(self):\n  return ('Field('\n  f'name={self.name!r},'\n  f'type={self.type!r},'\n  f'default={self.default!r},'\n  f'default_factory={self.default_factory!r},'\n  f'init={self.init!r},'\n  f'repr={self.repr!r},'\n  f'hash={self.hash!r},'\n  f'compare={self.compare!r},'\n  f'metadata={self.metadata!r},'\n  f'kw_only={self.kw_only!r},'\n  f'_field_type={self._field_type}'\n  ')')\n  \n  \n  \n  \n  \n  \n  \n  \n  \n def __set_name__(self,owner,name):\n  func=getattr(type(self.default),'__set_name__',None )\n  if func:\n  \n  \n   func(self.default,owner,name)\n   \n __class_getitem__=classmethod(GenericAlias)\n \n \nclass _DataclassParams:\n __slots__=('init',\n 'repr',\n 'eq',\n 'order',\n 'unsafe_hash',\n 'frozen',\n )\n \n def __init__(self,init,repr,eq,order,unsafe_hash,frozen):\n  self.init=init\n  self.repr=repr\n  self.eq=eq\n  self.order=order\n  self.unsafe_hash=unsafe_hash\n  self.frozen=frozen\n  \n def __repr__(self):\n  return ('_DataclassParams('\n  f'init={self.init!r},'\n  f'repr={self.repr!r},'\n  f'eq={self.eq!r},'\n  f'order={self.order!r},'\n  f'unsafe_hash={self.unsafe_hash!r},'\n  f'frozen={self.frozen!r}'\n  ')')\n  \n  \n  \n  \n  \ndef field(*,default=MISSING,default_factory=MISSING,init=True ,repr=True ,\nhash=None ,compare=True ,metadata=None ,kw_only=MISSING):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n if default is not MISSING and default_factory is not MISSING:\n  raise ValueError('cannot specify both default and default_factory')\n return Field(default,default_factory,init,repr,hash,compare,\n metadata,kw_only)\n \n \ndef _fields_in_init_order(fields):\n\n\n\n return (tuple(f for f in fields if f.init and not f.kw_only),\n tuple(f for f in fields if f.init and f.kw_only)\n )\n \n \ndef _tuple_str(obj_name,fields):\n\n\n\n\n\n if not fields:\n  return '()'\n  \n return f'({\",\".join([f\"{obj_name}.{f.name}\" for f in fields])},)'\n \n \n \n \ndef _recursive_repr(user_function):\n\n\n repr_running=set()\n \n @functools.wraps(user_function)\n def wrapper(self):\n  key=id(self),_thread.get_ident()\n  if key in repr_running:\n   return '...'\n  repr_running.add(key)\n  try :\n   result=user_function(self)\n  finally :\n   repr_running.discard(key)\n  return result\n return wrapper\n \n \ndef _create_fn(name,args,body,*,globals=None ,locals=None ,\nreturn_type=MISSING):\n\n\n\n if locals is None :\n  locals={}\n if 'BUILTINS'not in locals:\n  locals['BUILTINS']=builtins\n return_annotation=''\n if return_type is not MISSING:\n  locals['_return_type']=return_type\n  return_annotation='->_return_type'\n args=','.join(args)\n body='\\n'.join(f'  {b}'for b in body)\n \n \n txt=f' def {name}({args}){return_annotation}:\\n{body}'\n \n local_vars=', '.join(locals.keys())\n txt=f\"def __create_fn__({local_vars}):\\n{txt}\\n return {name}\"\n ns={}\n exec(txt,globals,ns)\n return ns['__create_fn__'](**locals)\n \n \ndef _field_assign(frozen,name,value,self_name):\n\n\n\n\n\n\n if frozen:\n  return f'BUILTINS.object.__setattr__({self_name},{name!r},{value})'\n return f'{self_name}.{name}={value}'\n \n \ndef _field_init(f,frozen,globals,self_name):\n\n\n\n default_name=f'_dflt_{f.name}'\n if f.default_factory is not MISSING:\n  if f.init:\n  \n  \n   globals[default_name]=f.default_factory\n   value=(f'{default_name}() '\n   f'if {f.name} is _HAS_DEFAULT_FACTORY '\n   f'else {f.name}')\n  else :\n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n   globals[default_name]=f.default_factory\n   value=f'{default_name}()'\n else :\n \n  if f.init:\n   if f.default is MISSING:\n   \n    value=f.name\n   elif f.default is not MISSING:\n    globals[default_name]=f.default\n    value=f.name\n  else :\n  \n  \n   return None\n   \n   \n   \n   \n if f._field_type is _FIELD_INITVAR:\n  return None\n  \n  \n return _field_assign(frozen,f.name,value,self_name)\n \n \ndef _init_param(f):\n\n\n\n\n if f.default is MISSING and f.default_factory is MISSING:\n \n \n  default=''\n elif f.default is not MISSING:\n \n \n  default=f'=_dflt_{f.name}'\n elif f.default_factory is not MISSING:\n \n  default='=_HAS_DEFAULT_FACTORY'\n return f'{f.name}:_type_{f.name}{default}'\n \n \ndef _init_fn(fields,std_fields,kw_only_fields,frozen,has_post_init,\nself_name,globals):\n\n\n\n\n\n\n\n\n seen_default=False\n for f in std_fields:\n \n  if f.init:\n   if not (f.default is MISSING and f.default_factory is MISSING):\n    seen_default=True\n   elif seen_default:\n    raise TypeError(f'non-default argument {f.name!r} '\n    'follows default argument')\n    \n locals={f'_type_{f.name}':f.type for f in fields}\n locals.update({\n 'MISSING':MISSING,\n '_HAS_DEFAULT_FACTORY':_HAS_DEFAULT_FACTORY,\n })\n \n body_lines=[]\n for f in fields:\n  line=_field_init(f,frozen,locals,self_name)\n  \n  \n  if line:\n   body_lines.append(line)\n   \n   \n if has_post_init:\n  params_str=','.join(f.name for f in fields\n  if f._field_type is _FIELD_INITVAR)\n  body_lines.append(f'{self_name}.{_POST_INIT_NAME}({params_str})')\n  \n  \n if not body_lines:\n  body_lines=['pass']\n  \n _init_params=[_init_param(f)for f in std_fields]\n if kw_only_fields:\n \n \n \n  _init_params +=['*']\n  _init_params +=[_init_param(f)for f in kw_only_fields]\n return _create_fn('__init__',\n [self_name]+_init_params,\n body_lines,\n locals=locals,\n globals=globals,\n return_type=None )\n \n \ndef _repr_fn(fields,globals):\n fn=_create_fn('__repr__',\n ('self',),\n ['return self.__class__.__qualname__ + f\"('+\n ', '.join([f\"{f.name}={{self.{f.name}!r}}\"\n for f in fields])+\n ')\"'],\n globals=globals)\n return _recursive_repr(fn)\n \n \ndef _frozen_get_del_attr(cls,fields,globals):\n locals={'cls':cls,\n 'FrozenInstanceError':FrozenInstanceError}\n if fields:\n  fields_str='('+','.join(repr(f.name)for f in fields)+',)'\n else :\n \n  fields_str='()'\n return (_create_fn('__setattr__',\n ('self','name','value'),\n (f'if type(self) is cls or name in {fields_str}:',\n ' raise FrozenInstanceError(f\"cannot assign to field {name!r}\")',\n f'super(cls, self).__setattr__(name, value)'),\n locals=locals,\n globals=globals),\n _create_fn('__delattr__',\n ('self','name'),\n (f'if type(self) is cls or name in {fields_str}:',\n ' raise FrozenInstanceError(f\"cannot delete field {name!r}\")',\n f'super(cls, self).__delattr__(name)'),\n locals=locals,\n globals=globals),\n )\n \n \ndef _cmp_fn(name,op,self_tuple,other_tuple,globals):\n\n\n\n\n\n return _create_fn(name,\n ('self','other'),\n ['if other.__class__ is self.__class__:',\n f' return {self_tuple}{op}{other_tuple}',\n 'return NotImplemented'],\n globals=globals)\n \n \ndef _hash_fn(fields,globals):\n self_tuple=_tuple_str('self',fields)\n return _create_fn('__hash__',\n ('self',),\n [f'return hash({self_tuple})'],\n globals=globals)\n \n \ndef _is_classvar(a_type,typing):\n\n\n return (a_type is typing.ClassVar\n or (type(a_type)is typing._GenericAlias\n and a_type.__origin__ is typing.ClassVar))\n \n \ndef _is_initvar(a_type,dataclasses):\n\n\n return (a_type is dataclasses.InitVar\n or type(a_type)is dataclasses.InitVar)\n \ndef _is_kw_only(a_type,dataclasses):\n return a_type is dataclasses.KW_ONLY\n \n \ndef _is_type(annotation,cls,a_module,a_type,is_type_predicate):\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n match=_MODULE_IDENTIFIER_RE.match(annotation)\n if match:\n  ns=None\n  module_name=match.group(1)\n  if not module_name:\n  \n  \n   ns=sys.modules.get(cls.__module__).__dict__\n  else :\n  \n   module=sys.modules.get(cls.__module__)\n   if module and module.__dict__.get(module_name)is a_module:\n    ns=sys.modules.get(a_type.__module__).__dict__\n  if ns and is_type_predicate(ns.get(match.group(2)),a_module):\n   return True\n return False\n \n \ndef _get_field(cls,a_name,a_type,default_kw_only):\n\n\n\n\n\n\n\n default=getattr(cls,a_name,MISSING)\n if isinstance(default,Field):\n  f=default\n else :\n  if isinstance(default,types.MemberDescriptorType):\n  \n   default=MISSING\n  f=field(default=default)\n  \n  \n f.name=a_name\n f.type=a_type\n \n \n \n \n f._field_type=_FIELD\n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n typing=sys.modules.get('typing')\n if typing:\n  if (_is_classvar(a_type,typing)\n  or (isinstance(f.type,str)\n  and _is_type(f.type,cls,typing,typing.ClassVar,\n  _is_classvar))):\n   f._field_type=_FIELD_CLASSVAR\n   \n   \n   \n if f._field_type is _FIELD:\n \n \n  dataclasses=sys.modules[__name__]\n  if (_is_initvar(a_type,dataclasses)\n  or (isinstance(f.type,str)\n  and _is_type(f.type,cls,dataclasses,dataclasses.InitVar,\n  _is_initvar))):\n   f._field_type=_FIELD_INITVAR\n   \n   \n   \n   \n   \n   \n if f._field_type in (_FIELD_CLASSVAR,_FIELD_INITVAR):\n  if f.default_factory is not MISSING:\n   raise TypeError(f'field {f.name} cannot have a '\n   'default factory')\n   \n   \n   \n   \n   \n   \n   \n if f._field_type in (_FIELD,_FIELD_INITVAR):\n \n \n  if f.kw_only is MISSING:\n   f.kw_only=default_kw_only\n else :\n \n  assert f._field_type is _FIELD_CLASSVAR\n  if f.kw_only is not MISSING:\n   raise TypeError(f'field {f.name} is a ClassVar but specifies '\n   'kw_only')\n   \n   \n if f._field_type is _FIELD and isinstance(f.default,(list,dict,set)):\n  raise ValueError(f'mutable default {type(f.default)} for field '\n  f'{f.name} is not allowed: use default_factory')\n  \n return f\n \ndef _set_qualname(cls,value):\n\n\n if isinstance(value,FunctionType):\n  value.__qualname__=f\"{cls.__qualname__}.{value.__name__}\"\n return value\n \ndef _set_new_attribute(cls,name,value):\n\n\n if name in cls.__dict__:\n  return True\n _set_qualname(cls,value)\n setattr(cls,name,value)\n return False\n \n \n \n \n \n \n \ndef _hash_set_none(cls,fields,globals):\n return None\n \ndef _hash_add(cls,fields,globals):\n flds=[f for f in fields if (f.compare if f.hash is None else f.hash)]\n return _set_qualname(cls,_hash_fn(flds,globals))\n \ndef _hash_exception(cls,fields,globals):\n\n raise TypeError(f'Cannot overwrite attribute __hash__ '\n f'in class {cls.__name__}')\n \n \n \n \n \n \n \n \n \n \n_hash_action={(False ,False ,False ,False ):None ,\n(False ,False ,False ,True ):None ,\n(False ,False ,True ,False ):None ,\n(False ,False ,True ,True ):None ,\n(False ,True ,False ,False ):_hash_set_none,\n(False ,True ,False ,True ):None ,\n(False ,True ,True ,False ):_hash_add,\n(False ,True ,True ,True ):None ,\n(True ,False ,False ,False ):_hash_add,\n(True ,False ,False ,True ):_hash_exception,\n(True ,False ,True ,False ):_hash_add,\n(True ,False ,True ,True ):_hash_exception,\n(True ,True ,False ,False ):_hash_add,\n(True ,True ,False ,True ):_hash_exception,\n(True ,True ,True ,False ):_hash_add,\n(True ,True ,True ,True ):_hash_exception,\n}\n\n\n\n\ndef _process_class(cls,init,repr,eq,order,unsafe_hash,frozen,\nmatch_args,kw_only,slots):\n\n\n\n\n fields={}\n \n if cls.__module__ in sys.modules:\n  globals=sys.modules[cls.__module__].__dict__\n else :\n \n \n \n \n \n  globals={}\n  \n setattr(cls,_PARAMS,_DataclassParams(init,repr,eq,order,\n unsafe_hash,frozen))\n \n \n \n \n \n any_frozen_base=False\n has_dataclass_bases=False\n for b in cls.__mro__[-1:0:-1]:\n \n \n  base_fields=getattr(b,_FIELDS,None )\n  if base_fields is not None :\n   has_dataclass_bases=True\n   for f in base_fields.values():\n    fields[f.name]=f\n   if getattr(b,_PARAMS).frozen:\n    any_frozen_base=True\n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n cls_annotations=cls.__dict__.get('__annotations__',{})\n \n \n \n \n cls_fields=[]\n \n KW_ONLY_seen=False\n dataclasses=sys.modules[__name__]\n for name,type in cls_annotations.items():\n \n  if (_is_kw_only(type,dataclasses)\n  or (isinstance(type,str)\n  and _is_type(type,cls,dataclasses,dataclasses.KW_ONLY,\n  _is_kw_only))):\n  \n  \n   if KW_ONLY_seen:\n    raise TypeError(f'{name!r} is KW_ONLY, but KW_ONLY '\n    'has already been specified')\n   KW_ONLY_seen=True\n   kw_only=True\n  else :\n  \n   cls_fields.append(_get_field(cls,name,type,kw_only))\n   \n for f in cls_fields:\n  fields[f.name]=f\n  \n  \n  \n  \n  \n  if isinstance(getattr(cls,f.name,None ),Field):\n   if f.default is MISSING:\n   \n   \n   \n   \n   \n   \n    delattr(cls,f.name)\n   else :\n    setattr(cls,f.name,f.default)\n    \n    \n for name,value in cls.__dict__.items():\n  if isinstance(value,Field)and not name in cls_annotations:\n   raise TypeError(f'{name!r} is a field but has no type annotation')\n   \n   \n if has_dataclass_bases:\n \n  if any_frozen_base and not frozen:\n   raise TypeError('cannot inherit non-frozen dataclass from a '\n   'frozen one')\n   \n   \n  if not any_frozen_base and frozen:\n   raise TypeError('cannot inherit frozen dataclass from a '\n   'non-frozen one')\n   \n   \n   \n setattr(cls,_FIELDS,fields)\n \n \n \n \n \n \n class_hash=cls.__dict__.get('__hash__',MISSING)\n has_explicit_hash=not (class_hash is MISSING or\n (class_hash is None and '__eq__'in cls.__dict__))\n \n \n \n if order and not eq:\n  raise ValueError('eq must be true if order is true')\n  \n  \n  \n  \n all_init_fields=[f for f in fields.values()\n if f._field_type in (_FIELD,_FIELD_INITVAR)]\n (std_init_fields,\n kw_only_init_fields)=_fields_in_init_order(all_init_fields)\n \n if init:\n \n  has_post_init=hasattr(cls,_POST_INIT_NAME)\n  \n  _set_new_attribute(cls,'__init__',\n  _init_fn(all_init_fields,\n  std_init_fields,\n  kw_only_init_fields,\n  frozen,\n  has_post_init,\n  \n  \n  \n  '__dataclass_self__'if 'self'in fields\n  else 'self',\n  globals,\n  ))\n  \n  \n  \n field_list=[f for f in fields.values()if f._field_type is _FIELD]\n \n if repr:\n  flds=[f for f in field_list if f.repr]\n  _set_new_attribute(cls,'__repr__',_repr_fn(flds,globals))\n  \n if eq:\n \n \n  flds=[f for f in field_list if f.compare]\n  self_tuple=_tuple_str('self',flds)\n  other_tuple=_tuple_str('other',flds)\n  _set_new_attribute(cls,'__eq__',\n  _cmp_fn('__eq__','==',\n  self_tuple,other_tuple,\n  globals=globals))\n  \n if order:\n \n  flds=[f for f in field_list if f.compare]\n  self_tuple=_tuple_str('self',flds)\n  other_tuple=_tuple_str('other',flds)\n  for name,op in [('__lt__','<'),\n  ('__le__','<='),\n  ('__gt__','>'),\n  ('__ge__','>='),\n  ]:\n   if _set_new_attribute(cls,name,\n   _cmp_fn(name,op,self_tuple,other_tuple,\n   globals=globals)):\n    raise TypeError(f'Cannot overwrite attribute {name} '\n    f'in class {cls.__name__}. Consider using '\n    'functools.total_ordering')\n    \n if frozen:\n  for fn in _frozen_get_del_attr(cls,field_list,globals):\n   if _set_new_attribute(cls,fn.__name__,fn):\n    raise TypeError(f'Cannot overwrite attribute {fn.__name__} '\n    f'in class {cls.__name__}')\n    \n    \n hash_action=_hash_action[bool(unsafe_hash),\n bool(eq),\n bool(frozen),\n has_explicit_hash]\n if hash_action:\n \n \n  cls.__hash__=hash_action(cls,field_list,globals)\n  \n if not getattr(cls,'__doc__'):\n \n  cls.__doc__=(cls.__name__+\n  str(inspect.signature(cls)).replace(' -> None',''))\n  \n if match_args:\n \n  _set_new_attribute(cls,'__match_args__',\n  tuple(f.name for f in std_init_fields))\n  \n if slots:\n  cls=_add_slots(cls,frozen)\n  \n abc.update_abstractmethods(cls)\n \n return cls\n \n \n \n \n \n \ndef _dataclass_getstate(self):\n return [getattr(self,f.name)for f in fields(self)]\n \n \ndef _dataclass_setstate(self,state):\n for field,value in zip(fields(self),state):\n \n  object.__setattr__(self,field.name,value)\n  \n  \ndef _add_slots(cls,is_frozen):\n\n\n\n\n if '__slots__'in cls.__dict__:\n  raise TypeError(f'{cls.__name__} already specifies __slots__')\n  \n  \n cls_dict=dict(cls.__dict__)\n field_names=tuple(f.name for f in fields(cls))\n cls_dict['__slots__']=field_names\n for field_name in field_names:\n \n \n  cls_dict.pop(field_name,None )\n  \n  \n cls_dict.pop('__dict__',None )\n \n \n qualname=getattr(cls,'__qualname__',None )\n cls=type(cls)(cls.__name__,cls.__bases__,cls_dict)\n if qualname is not None :\n  cls.__qualname__=qualname\n  \n if is_frozen:\n \n  cls.__getstate__=_dataclass_getstate\n  cls.__setstate__=_dataclass_setstate\n  \n return cls\n \n \ndef dataclass(cls=None ,/,*,init=True ,repr=True ,eq=True ,order=False ,\nunsafe_hash=False ,frozen=False ,match_args=True ,\nkw_only=False ,slots=False ):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n def wrap(cls):\n  return _process_class(cls,init,repr,eq,order,unsafe_hash,\n  frozen,match_args,kw_only,slots)\n  \n  \n if cls is None :\n \n  return wrap\n  \n  \n return wrap(cls)\n \n \ndef fields(class_or_instance):\n ''\n\n\n\n \n \n \n try :\n  fields=getattr(class_or_instance,_FIELDS)\n except AttributeError:\n  raise TypeError('must be called with a dataclass type or instance')\n  \n  \n  \n return tuple(f for f in fields.values()if f._field_type is _FIELD)\n \n \ndef _is_dataclass_instance(obj):\n ''\n return hasattr(type(obj),_FIELDS)\n \n \ndef is_dataclass(obj):\n ''\n \n cls=obj if isinstance(obj,type)else type(obj)\n return hasattr(cls,_FIELDS)\n \n \ndef asdict(obj,*,dict_factory=dict):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n if not _is_dataclass_instance(obj):\n  raise TypeError(\"asdict() should be called on dataclass instances\")\n return _asdict_inner(obj,dict_factory)\n \n \ndef _asdict_inner(obj,dict_factory):\n if _is_dataclass_instance(obj):\n  result=[]\n  for f in fields(obj):\n   value=_asdict_inner(getattr(obj,f.name),dict_factory)\n   result.append((f.name,value))\n  return dict_factory(result)\n elif isinstance(obj,tuple)and hasattr(obj,'_fields'):\n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n  return type(obj)(*[_asdict_inner(v,dict_factory)for v in obj])\n elif isinstance(obj,(list,tuple)):\n \n \n \n  return type(obj)(_asdict_inner(v,dict_factory)for v in obj)\n elif isinstance(obj,dict):\n  return type(obj)((_asdict_inner(k,dict_factory),\n  _asdict_inner(v,dict_factory))\n  for k,v in obj.items())\n else :\n  return copy.deepcopy(obj)\n  \n  \ndef astuple(obj,*,tuple_factory=tuple):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n if not _is_dataclass_instance(obj):\n  raise TypeError(\"astuple() should be called on dataclass instances\")\n return _astuple_inner(obj,tuple_factory)\n \n \ndef _astuple_inner(obj,tuple_factory):\n if _is_dataclass_instance(obj):\n  result=[]\n  for f in fields(obj):\n   value=_astuple_inner(getattr(obj,f.name),tuple_factory)\n   result.append(value)\n  return tuple_factory(result)\n elif isinstance(obj,tuple)and hasattr(obj,'_fields'):\n \n \n \n \n \n \n  return type(obj)(*[_astuple_inner(v,tuple_factory)for v in obj])\n elif isinstance(obj,(list,tuple)):\n \n \n \n  return type(obj)(_astuple_inner(v,tuple_factory)for v in obj)\n elif isinstance(obj,dict):\n  return type(obj)((_astuple_inner(k,tuple_factory),_astuple_inner(v,tuple_factory))\n  for k,v in obj.items())\n else :\n  return copy.deepcopy(obj)\n  \n  \ndef make_dataclass(cls_name,fields,*,bases=(),namespace=None ,init=True ,\nrepr=True ,eq=True ,order=False ,unsafe_hash=False ,\nfrozen=False ,match_args=True ,slots=False ):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n if namespace is None :\n  namespace={}\n  \n  \n  \n seen=set()\n annotations={}\n defaults={}\n for item in fields:\n  if isinstance(item,str):\n   name=item\n   tp='typing.Any'\n  elif len(item)==2:\n   name,tp,=item\n  elif len(item)==3:\n   name,tp,spec=item\n   defaults[name]=spec\n  else :\n   raise TypeError(f'Invalid field: {item!r}')\n   \n  if not isinstance(name,str)or not name.isidentifier():\n   raise TypeError(f'Field names must be valid identifiers: {name!r}')\n  if keyword.iskeyword(name):\n   raise TypeError(f'Field names must not be keywords: {name!r}')\n  if name in seen:\n   raise TypeError(f'Field name duplicated: {name!r}')\n   \n  seen.add(name)\n  annotations[name]=tp\n  \n  \n def exec_body_callback(ns):\n  ns.update(namespace)\n  ns.update(defaults)\n  ns['__annotations__']=annotations\n  \n  \n  \n cls=types.new_class(cls_name,bases,{},exec_body_callback)\n \n \n return dataclass(cls,init=init,repr=repr,eq=eq,order=order,\n unsafe_hash=unsafe_hash,frozen=frozen,\n match_args=match_args,slots=slots)\n \n \ndef replace(obj,/,**changes):\n ''\n\n\n\n\n\n\n\n\n\n\n\n \n \n \n \n \n if not _is_dataclass_instance(obj):\n  raise TypeError(\"replace() should be called on dataclass instances\")\n  \n  \n  \n  \n for f in getattr(obj,_FIELDS).values():\n \n  if f._field_type is _FIELD_CLASSVAR:\n   continue\n   \n  if not f.init:\n  \n   if f.name in changes:\n    raise ValueError(f'field {f.name} is declared with '\n    'init=False, it cannot be specified with '\n    'replace()')\n   continue\n   \n  if f.name not in changes:\n   if f._field_type is _FIELD_INITVAR and f.default is MISSING:\n    raise ValueError(f\"InitVar {f.name!r} \"\n    'must be specified with replace()')\n   changes[f.name]=getattr(obj,f.name)\n   \n   \n   \n   \n   \n   \n return obj.__class__(**changes)\n", ["_thread", "abc", "builtins", "copy", "functools", "inspect", "keyword", "re", "sys", "types"]], "datetime": [".py", "''\n\n\n\n\n\n__all__=(\"date\",\"datetime\",\"time\",\"timedelta\",\"timezone\",\"tzinfo\",\n\"MINYEAR\",\"MAXYEAR\")\n\n\nimport time as _time\nimport math as _math\nimport sys\nfrom operator import index as _index\n\ndef _cmp(x,y):\n return 0 if x ==y else 1 if x >y else -1\n \nMINYEAR=1\nMAXYEAR=9999\n_MAXORDINAL=3652059\n\n\n\n\n\n\n\n\n\n\n\n_DAYS_IN_MONTH=[-1,31,28,31,30,31,30,31,31,30,31,30,31]\n\n_DAYS_BEFORE_MONTH=[-1]\ndbm=0\nfor dim in _DAYS_IN_MONTH[1:]:\n _DAYS_BEFORE_MONTH.append(dbm)\n dbm +=dim\ndel dbm,dim\n\ndef _is_leap(year):\n ''\n return year %4 ==0 and (year %100 !=0 or year %400 ==0)\n \ndef _days_before_year(year):\n ''\n y=year -1\n return y *365+y //4 -y //100+y //400\n \ndef _days_in_month(year,month):\n ''\n assert 1 <=month <=12,month\n if month ==2 and _is_leap(year):\n  return 29\n return _DAYS_IN_MONTH[month]\n \ndef _days_before_month(year,month):\n ''\n assert 1 <=month <=12,'month must be in 1..12'\n return _DAYS_BEFORE_MONTH[month]+(month >2 and _is_leap(year))\n \ndef _ymd2ord(year,month,day):\n ''\n assert 1 <=month <=12,'month must be in 1..12'\n dim=_days_in_month(year,month)\n assert 1 <=day <=dim,('day must be in 1..%d'%dim)\n return (_days_before_year(year)+\n _days_before_month(year,month)+\n day)\n \n_DI400Y=_days_before_year(401)\n_DI100Y=_days_before_year(101)\n_DI4Y=_days_before_year(5)\n\n\n\nassert _DI4Y ==4 *365+1\n\n\n\nassert _DI400Y ==4 *_DI100Y+1\n\n\n\nassert _DI100Y ==25 *_DI4Y -1\n\ndef _ord2ymd(n):\n ''\n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n n -=1\n n400,n=divmod(n,_DI400Y)\n year=n400 *400+1\n \n \n \n \n \n \n n100,n=divmod(n,_DI100Y)\n \n \n n4,n=divmod(n,_DI4Y)\n \n \n \n n1,n=divmod(n,365)\n \n year +=n100 *100+n4 *4+n1\n if n1 ==4 or n100 ==4:\n  assert n ==0\n  return year -1,12,31\n  \n  \n  \n leapyear=n1 ==3 and (n4 !=24 or n100 ==3)\n assert leapyear ==_is_leap(year)\n month=(n+50)>>5\n preceding=_DAYS_BEFORE_MONTH[month]+(month >2 and leapyear)\n if preceding >n:\n  month -=1\n  preceding -=_DAYS_IN_MONTH[month]+(month ==2 and leapyear)\n n -=preceding\n assert 0 <=n <_days_in_month(year,month)\n \n \n \n return year,month,n+1\n \n \n_MONTHNAMES=[None ,\"Jan\",\"Feb\",\"Mar\",\"Apr\",\"May\",\"Jun\",\n\"Jul\",\"Aug\",\"Sep\",\"Oct\",\"Nov\",\"Dec\"]\n_DAYNAMES=[None ,\"Mon\",\"Tue\",\"Wed\",\"Thu\",\"Fri\",\"Sat\",\"Sun\"]\n\n\ndef _build_struct_time(y,m,d,hh,mm,ss,dstflag):\n wday=(_ymd2ord(y,m,d)+6)%7\n dnum=_days_before_month(y,m)+d\n return _time.struct_time((y,m,d,hh,mm,ss,wday,dnum,dstflag))\n \ndef _format_time(hh,mm,ss,us,timespec='auto'):\n specs={\n 'hours':'{:02d}',\n 'minutes':'{:02d}:{:02d}',\n 'seconds':'{:02d}:{:02d}:{:02d}',\n 'milliseconds':'{:02d}:{:02d}:{:02d}.{:03d}',\n 'microseconds':'{:02d}:{:02d}:{:02d}.{:06d}'\n }\n \n if timespec =='auto':\n \n  timespec='microseconds'if us else 'seconds'\n elif timespec =='milliseconds':\n  us //=1000\n try :\n  fmt=specs[timespec]\n except KeyError:\n  raise ValueError('Unknown timespec value')\n else :\n  return fmt.format(hh,mm,ss,us)\n  \ndef _format_offset(off):\n s=''\n if off is not None :\n  if off.days <0:\n   sign=\"-\"\n   off=-off\n  else :\n   sign=\"+\"\n  hh,mm=divmod(off,timedelta(hours=1))\n  mm,ss=divmod(mm,timedelta(minutes=1))\n  s +=\"%s%02d:%02d\"%(sign,hh,mm)\n  if ss or ss.microseconds:\n   s +=\":%02d\"%ss.seconds\n   \n   if ss.microseconds:\n    s +='.%06d'%ss.microseconds\n return s\n \n \ndef _wrap_strftime(object,format,timetuple):\n\n freplace=None\n zreplace=None\n Zreplace=None\n \n \n newformat=[]\n push=newformat.append\n i,n=0,len(format)\n while i <n:\n  ch=format[i]\n  i +=1\n  if ch =='%':\n   if i <n:\n    ch=format[i]\n    i +=1\n    if ch =='f':\n     if freplace is None :\n      freplace='%06d'%getattr(object,\n      'microsecond',0)\n     newformat.append(freplace)\n    elif ch =='z':\n     if zreplace is None :\n      zreplace=\"\"\n      if hasattr(object,\"utcoffset\"):\n       offset=object.utcoffset()\n       if offset is not None :\n        sign='+'\n        if offset.days <0:\n         offset=-offset\n         sign='-'\n        h,rest=divmod(offset,timedelta(hours=1))\n        m,rest=divmod(rest,timedelta(minutes=1))\n        s=rest.seconds\n        u=offset.microseconds\n        if u:\n         zreplace='%c%02d%02d%02d.%06d'%(sign,h,m,s,u)\n        elif s:\n         zreplace='%c%02d%02d%02d'%(sign,h,m,s)\n        else :\n         zreplace='%c%02d%02d'%(sign,h,m)\n     assert '%'not in zreplace\n     newformat.append(zreplace)\n    elif ch =='Z':\n     if Zreplace is None :\n      Zreplace=\"\"\n      if hasattr(object,\"tzname\"):\n       s=object.tzname()\n       if s is not None :\n       \n        Zreplace=s.replace('%','%%')\n     newformat.append(Zreplace)\n    else :\n     push('%')\n     push(ch)\n   else :\n    push('%')\n  else :\n   push(ch)\n newformat=\"\".join(newformat)\n return _time.strftime(newformat,timetuple)\n \n \ndef _parse_isoformat_date(dtstr):\n\n\n year=int(dtstr[0:4])\n if dtstr[4]!='-':\n  raise ValueError('Invalid date separator: %s'%dtstr[4])\n  \n month=int(dtstr[5:7])\n \n if dtstr[7]!='-':\n  raise ValueError('Invalid date separator')\n  \n day=int(dtstr[8:10])\n \n return [year,month,day]\n \ndef _parse_hh_mm_ss_ff(tstr):\n\n len_str=len(tstr)\n \n time_comps=[0,0,0,0]\n pos=0\n for comp in range(0,3):\n  if (len_str -pos)<2:\n   raise ValueError('Incomplete time component')\n   \n  time_comps[comp]=int(tstr[pos:pos+2])\n  \n  pos +=2\n  next_char=tstr[pos:pos+1]\n  \n  if not next_char or comp >=2:\n   break\n   \n  if next_char !=':':\n   raise ValueError('Invalid time separator: %c'%next_char)\n   \n  pos +=1\n  \n if pos <len_str:\n  if tstr[pos]!='.':\n   raise ValueError('Invalid microsecond component')\n  else :\n   pos +=1\n   \n   len_remainder=len_str -pos\n   if len_remainder not in (3,6):\n    raise ValueError('Invalid microsecond component')\n    \n   time_comps[3]=int(tstr[pos:])\n   if len_remainder ==3:\n    time_comps[3]*=1000\n    \n return time_comps\n \ndef _parse_isoformat_time(tstr):\n\n len_str=len(tstr)\n if len_str <2:\n  raise ValueError('Isoformat time too short')\n  \n  \n tz_pos=(tstr.find('-')+1 or tstr.find('+')+1)\n timestr=tstr[:tz_pos -1]if tz_pos >0 else tstr\n \n time_comps=_parse_hh_mm_ss_ff(timestr)\n \n tzi=None\n if tz_pos >0:\n  tzstr=tstr[tz_pos:]\n  \n  \n  \n  \n  \n  \n  if len(tzstr)not in (5,8,15):\n   raise ValueError('Malformed time zone string')\n   \n  tz_comps=_parse_hh_mm_ss_ff(tzstr)\n  if all(x ==0 for x in tz_comps):\n   tzi=timezone.utc\n  else :\n   tzsign=-1 if tstr[tz_pos -1]=='-'else 1\n   \n   td=timedelta(hours=tz_comps[0],minutes=tz_comps[1],\n   seconds=tz_comps[2],microseconds=tz_comps[3])\n   \n   tzi=timezone(tzsign *td)\n   \n time_comps.append(tzi)\n \n return time_comps\n \n \n \ndef _check_tzname(name):\n if name is not None and not isinstance(name,str):\n  raise TypeError(\"tzinfo.tzname() must return None or string, \"\n  \"not '%s'\"%type(name))\n  \n  \n  \n  \n  \n  \n  \ndef _check_utc_offset(name,offset):\n assert name in (\"utcoffset\",\"dst\")\n if offset is None :\n  return\n if not isinstance(offset,timedelta):\n  raise TypeError(\"tzinfo.%s() must return None \"\n  \"or timedelta, not '%s'\"%(name,type(offset)))\n if not -timedelta(1)<offset <timedelta(1):\n  raise ValueError(\"%s()=%s, must be strictly between \"\n  \"-timedelta(hours=24) and timedelta(hours=24)\"%\n  (name,offset))\n  \ndef _check_date_fields(year,month,day):\n year=_index(year)\n month=_index(month)\n day=_index(day)\n if not MINYEAR <=year <=MAXYEAR:\n  raise ValueError('year must be in %d..%d'%(MINYEAR,MAXYEAR),year)\n if not 1 <=month <=12:\n  raise ValueError('month must be in 1..12',month)\n dim=_days_in_month(year,month)\n if not 1 <=day <=dim:\n  raise ValueError('day must be in 1..%d'%dim,day)\n return year,month,day\n \ndef _check_time_fields(hour,minute,second,microsecond,fold):\n hour=_index(hour)\n minute=_index(minute)\n second=_index(second)\n microsecond=_index(microsecond)\n if not 0 <=hour <=23:\n  raise ValueError('hour must be in 0..23',hour)\n if not 0 <=minute <=59:\n  raise ValueError('minute must be in 0..59',minute)\n if not 0 <=second <=59:\n  raise ValueError('second must be in 0..59',second)\n if not 0 <=microsecond <=999999:\n  raise ValueError('microsecond must be in 0..999999',microsecond)\n if fold not in (0,1):\n  raise ValueError('fold must be either 0 or 1',fold)\n return hour,minute,second,microsecond,fold\n \ndef _check_tzinfo_arg(tz):\n if tz is not None and not isinstance(tz,tzinfo):\n  raise TypeError(\"tzinfo argument must be None or of a tzinfo subclass\")\n  \ndef _cmperror(x,y):\n raise TypeError(\"can't compare '%s' to '%s'\"%(\n type(x).__name__,type(y).__name__))\n \ndef _divide_and_round(a,b):\n ''\n\n\n\n \n \n \n q,r=divmod(a,b)\n \n \n \n r *=2\n greater_than_half=r >b if b >0 else r <b\n if greater_than_half or r ==b and q %2 ==1:\n  q +=1\n  \n return q\n \n \nclass timedelta:\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n __slots__='_days','_seconds','_microseconds','_hashcode'\n \n def __new__(cls,days=0,seconds=0,microseconds=0,\n milliseconds=0,minutes=0,hours=0,weeks=0):\n \n \n \n \n \n \n \n \n \n \n \n \n  d=s=us=0\n  \n  \n  days +=weeks *7\n  seconds +=minutes *60+hours *3600\n  microseconds +=milliseconds *1000\n  \n  \n  \n  if isinstance(days,float):\n   dayfrac,days=_math.modf(days)\n   daysecondsfrac,daysecondswhole=_math.modf(dayfrac *(24. *3600.))\n   assert daysecondswhole ==int(daysecondswhole)\n   s=int(daysecondswhole)\n   assert days ==int(days)\n   d=int(days)\n  else :\n   daysecondsfrac=0.0\n   d=days\n  assert isinstance(daysecondsfrac,float)\n  assert abs(daysecondsfrac)<=1.0\n  assert isinstance(d,int)\n  assert abs(s)<=24 *3600\n  \n  \n  if isinstance(seconds,float):\n   secondsfrac,seconds=_math.modf(seconds)\n   assert seconds ==int(seconds)\n   seconds=int(seconds)\n   secondsfrac +=daysecondsfrac\n   assert abs(secondsfrac)<=2.0\n  else :\n   secondsfrac=daysecondsfrac\n   \n  assert isinstance(secondsfrac,float)\n  assert abs(secondsfrac)<=2.0\n  \n  assert isinstance(seconds,int)\n  days,seconds=divmod(seconds,24 *3600)\n  d +=days\n  s +=int(seconds)\n  assert isinstance(s,int)\n  assert abs(s)<=2 *24 *3600\n  \n  \n  usdouble=secondsfrac *1e6\n  assert abs(usdouble)<2.1e6\n  \n  \n  if isinstance(microseconds,float):\n   microseconds=round(microseconds+usdouble)\n   seconds,microseconds=divmod(microseconds,1000000)\n   days,seconds=divmod(seconds,24 *3600)\n   d +=days\n   s +=seconds\n  else :\n   microseconds=int(microseconds)\n   seconds,microseconds=divmod(microseconds,1000000)\n   days,seconds=divmod(seconds,24 *3600)\n   d +=days\n   s +=seconds\n   microseconds=round(microseconds+usdouble)\n  assert isinstance(s,int)\n  assert isinstance(microseconds,int)\n  assert abs(s)<=3 *24 *3600\n  assert abs(microseconds)<3.1e6\n  \n  \n  seconds,us=divmod(microseconds,1000000)\n  s +=seconds\n  days,s=divmod(s,24 *3600)\n  d +=days\n  \n  assert isinstance(d,int)\n  assert isinstance(s,int)and 0 <=s <24 *3600\n  assert isinstance(us,int)and 0 <=us <1000000\n  \n  if abs(d)>999999999:\n   raise OverflowError(\"timedelta # of days is too large: %d\"%d)\n   \n  self=object.__new__(cls)\n  self._days=d\n  self._seconds=s\n  self._microseconds=us\n  self._hashcode=-1\n  return self\n  \n def __repr__(self):\n  args=[]\n  if self._days:\n   args.append(\"days=%d\"%self._days)\n  if self._seconds:\n   args.append(\"seconds=%d\"%self._seconds)\n  if self._microseconds:\n   args.append(\"microseconds=%d\"%self._microseconds)\n  if not args:\n   args.append('0')\n  return \"%s.%s(%s)\"%(self.__class__.__module__,\n  self.__class__.__qualname__,\n  ', '.join(args))\n  \n def __str__(self):\n  mm,ss=divmod(self._seconds,60)\n  hh,mm=divmod(mm,60)\n  s=\"%d:%02d:%02d\"%(hh,mm,ss)\n  if self._days:\n   def plural(n):\n    return n,abs(n)!=1 and \"s\"or \"\"\n   s=(\"%d day%s, \"%plural(self._days))+s\n  if self._microseconds:\n   s=s+\".%06d\"%self._microseconds\n  return s\n  \n def total_seconds(self):\n  ''\n  return ((self.days *86400+self.seconds)*10 **6+\n  self.microseconds)/10 **6\n  \n  \n @property\n def days(self):\n  ''\n  return self._days\n  \n @property\n def seconds(self):\n  ''\n  return self._seconds\n  \n @property\n def microseconds(self):\n  ''\n  return self._microseconds\n  \n def __add__(self,other):\n  if isinstance(other,timedelta):\n  \n  \n   return timedelta(self._days+other._days,\n   self._seconds+other._seconds,\n   self._microseconds+other._microseconds)\n  return NotImplemented\n  \n __radd__=__add__\n \n def __sub__(self,other):\n  if isinstance(other,timedelta):\n  \n  \n   return timedelta(self._days -other._days,\n   self._seconds -other._seconds,\n   self._microseconds -other._microseconds)\n  return NotImplemented\n  \n def __rsub__(self,other):\n  if isinstance(other,timedelta):\n   return -self+other\n  return NotImplemented\n  \n def __neg__(self):\n \n \n  return timedelta(-self._days,\n  -self._seconds,\n  -self._microseconds)\n  \n def __pos__(self):\n  return self\n  \n def __abs__(self):\n  if self._days <0:\n   return -self\n  else :\n   return self\n   \n def __mul__(self,other):\n  if isinstance(other,int):\n  \n  \n   return timedelta(self._days *other,\n   self._seconds *other,\n   self._microseconds *other)\n  if isinstance(other,float):\n   usec=self._to_microseconds()\n   a,b=other.as_integer_ratio()\n   return timedelta(0,0,_divide_and_round(usec *a,b))\n  return NotImplemented\n  \n __rmul__=__mul__\n \n def _to_microseconds(self):\n  return ((self._days *(24 *3600)+self._seconds)*1000000+\n  self._microseconds)\n  \n def __floordiv__(self,other):\n  if not isinstance(other,(int,timedelta)):\n   return NotImplemented\n  usec=self._to_microseconds()\n  if isinstance(other,timedelta):\n   return usec //other._to_microseconds()\n  if isinstance(other,int):\n   return timedelta(0,0,usec //other)\n   \n def __truediv__(self,other):\n  if not isinstance(other,(int,float,timedelta)):\n   return NotImplemented\n  usec=self._to_microseconds()\n  if isinstance(other,timedelta):\n   return usec /other._to_microseconds()\n  if isinstance(other,int):\n   return timedelta(0,0,_divide_and_round(usec,other))\n  if isinstance(other,float):\n   a,b=other.as_integer_ratio()\n   return timedelta(0,0,_divide_and_round(b *usec,a))\n   \n def __mod__(self,other):\n  if isinstance(other,timedelta):\n   r=self._to_microseconds()%other._to_microseconds()\n   return timedelta(0,0,r)\n  return NotImplemented\n  \n def __divmod__(self,other):\n  if isinstance(other,timedelta):\n   q,r=divmod(self._to_microseconds(),\n   other._to_microseconds())\n   return q,timedelta(0,0,r)\n  return NotImplemented\n  \n  \n  \n def __eq__(self,other):\n  if isinstance(other,timedelta):\n   return self._cmp(other)==0\n  else :\n   return NotImplemented\n   \n def __le__(self,other):\n  if isinstance(other,timedelta):\n   return self._cmp(other)<=0\n  else :\n   return NotImplemented\n   \n def __lt__(self,other):\n  if isinstance(other,timedelta):\n   return self._cmp(other)<0\n  else :\n   return NotImplemented\n   \n def __ge__(self,other):\n  if isinstance(other,timedelta):\n   return self._cmp(other)>=0\n  else :\n   return NotImplemented\n   \n def __gt__(self,other):\n  if isinstance(other,timedelta):\n   return self._cmp(other)>0\n  else :\n   return NotImplemented\n   \n def _cmp(self,other):\n  assert isinstance(other,timedelta)\n  return _cmp(self._getstate(),other._getstate())\n  \n def __hash__(self):\n  if self._hashcode ==-1:\n   self._hashcode=hash(self._getstate())\n  return self._hashcode\n  \n def __bool__(self):\n  return (self._days !=0 or\n  self._seconds !=0 or\n  self._microseconds !=0)\n  \n  \n  \n def _getstate(self):\n  return (self._days,self._seconds,self._microseconds)\n  \n def __reduce__(self):\n  return (self.__class__,self._getstate())\n  \ntimedelta.min=timedelta(-999999999)\ntimedelta.max=timedelta(days=999999999,hours=23,minutes=59,seconds=59,\nmicroseconds=999999)\ntimedelta.resolution=timedelta(microseconds=1)\n\nclass date:\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n __slots__='_year','_month','_day','_hashcode'\n \n def __new__(cls,year,month=None ,day=None ):\n  ''\n\n\n\n\n  \n  if (month is None and\n  isinstance(year,(bytes,str))and len(year)==4 and\n  1 <=ord(year[2:3])<=12):\n  \n   if isinstance(year,str):\n    try :\n     year=year.encode('latin1')\n    except UnicodeEncodeError:\n    \n     raise ValueError(\n     \"Failed to encode latin1 string when unpickling \"\n     \"a date object. \"\n     \"pickle.load(data, encoding='latin1') is assumed.\")\n   self=object.__new__(cls)\n   self.__setstate(year)\n   self._hashcode=-1\n   return self\n  year,month,day=_check_date_fields(year,month,day)\n  self=object.__new__(cls)\n  self._year=year\n  self._month=month\n  self._day=day\n  self._hashcode=-1\n  return self\n  \n  \n  \n @classmethod\n def fromtimestamp(cls,t):\n  ''\n  y,m,d,hh,mm,ss,weekday,jday,dst=_time.localtime(t)\n  return cls(y,m,d)\n  \n @classmethod\n def today(cls):\n  ''\n  t=_time.time()\n  return cls.fromtimestamp(t)\n  \n @classmethod\n def fromordinal(cls,n):\n  ''\n\n\n\n  \n  y,m,d=_ord2ymd(n)\n  return cls(y,m,d)\n  \n @classmethod\n def fromisoformat(cls,date_string):\n  ''\n  if not isinstance(date_string,str):\n   raise TypeError('fromisoformat: argument must be str')\n   \n  try :\n   assert len(date_string)==10\n   return cls(*_parse_isoformat_date(date_string))\n  except Exception:\n   raise ValueError(f'Invalid isoformat string: {date_string!r}')\n   \n @classmethod\n def fromisocalendar(cls,year,week,day):\n  ''\n\n  \n  \n  if not MINYEAR <=year <=MAXYEAR:\n   raise ValueError(f\"Year is out of range: {year}\")\n   \n  if not 0 <week <53:\n   out_of_range=True\n   \n   if week ==53:\n   \n   \n    first_weekday=_ymd2ord(year,1,1)%7\n    if (first_weekday ==4 or (first_weekday ==3 and\n    _is_leap(year))):\n     out_of_range=False\n     \n   if out_of_range:\n    raise ValueError(f\"Invalid week: {week}\")\n    \n  if not 0 <day <8:\n   raise ValueError(f\"Invalid weekday: {day} (range is [1, 7])\")\n   \n   \n  day_offset=(week -1)*7+(day -1)\n  \n  \n  day_1=_isoweek1monday(year)\n  ord_day=day_1+day_offset\n  \n  return cls(*_ord2ymd(ord_day))\n  \n  \n  \n def __repr__(self):\n  ''\n\n\n\n\n\n\n\n\n  \n  return \"%s.%s(%d, %d, %d)\"%(self.__class__.__module__,\n  self.__class__.__qualname__,\n  self._year,\n  self._month,\n  self._day)\n  \n  \n  \n  \n  \n  \n def ctime(self):\n  ''\n  weekday=self.toordinal()%7 or 7\n  return \"%s %s %2d 00:00:00 %04d\"%(\n  _DAYNAMES[weekday],\n  _MONTHNAMES[self._month],\n  self._day,self._year)\n  \n def strftime(self,fmt):\n  ''\n  return _wrap_strftime(self,fmt,self.timetuple())\n  \n def __format__(self,fmt):\n  if not isinstance(fmt,str):\n   raise TypeError(\"must be str, not %s\"%type(fmt).__name__)\n  if len(fmt)!=0:\n   return self.strftime(fmt)\n  return str(self)\n  \n def isoformat(self):\n  ''\n\n\n\n\n\n\n  \n  return \"%04d-%02d-%02d\"%(self._year,self._month,self._day)\n  \n __str__=isoformat\n \n \n @property\n def year(self):\n  ''\n  return self._year\n  \n @property\n def month(self):\n  ''\n  return self._month\n  \n @property\n def day(self):\n  ''\n  return self._day\n  \n  \n  \n  \n def timetuple(self):\n  ''\n  return _build_struct_time(self._year,self._month,self._day,\n  0,0,0,-1)\n  \n def toordinal(self):\n  ''\n\n\n\n  \n  return _ymd2ord(self._year,self._month,self._day)\n  \n def replace(self,year=None ,month=None ,day=None ):\n  ''\n  if year is None :\n   year=self._year\n  if month is None :\n   month=self._month\n  if day is None :\n   day=self._day\n  return type(self)(year,month,day)\n  \n  \n  \n def __eq__(self,other):\n  if isinstance(other,date):\n   return self._cmp(other)==0\n  return NotImplemented\n  \n def __le__(self,other):\n  if isinstance(other,date):\n   return self._cmp(other)<=0\n  return NotImplemented\n  \n def __lt__(self,other):\n  if isinstance(other,date):\n   return self._cmp(other)<0\n  return NotImplemented\n  \n def __ge__(self,other):\n  if isinstance(other,date):\n   return self._cmp(other)>=0\n  return NotImplemented\n  \n def __gt__(self,other):\n  if isinstance(other,date):\n   return self._cmp(other)>0\n  return NotImplemented\n  \n def _cmp(self,other):\n  assert isinstance(other,date)\n  y,m,d=self._year,self._month,self._day\n  y2,m2,d2=other._year,other._month,other._day\n  return _cmp((y,m,d),(y2,m2,d2))\n  \n def __hash__(self):\n  ''\n  if self._hashcode ==-1:\n   self._hashcode=hash(self._getstate())\n  return self._hashcode\n  \n  \n  \n def __add__(self,other):\n  ''\n  if isinstance(other,timedelta):\n   o=self.toordinal()+other.days\n   if 0 <o <=_MAXORDINAL:\n    return type(self).fromordinal(o)\n   raise OverflowError(\"result out of range\")\n  return NotImplemented\n  \n __radd__=__add__\n \n def __sub__(self,other):\n  ''\n  if isinstance(other,timedelta):\n   return self+timedelta(-other.days)\n  if isinstance(other,date):\n   days1=self.toordinal()\n   days2=other.toordinal()\n   return timedelta(days1 -days2)\n  return NotImplemented\n  \n def weekday(self):\n  ''\n  return (self.toordinal()+6)%7\n  \n  \n  \n def isoweekday(self):\n  ''\n  \n  return self.toordinal()%7 or 7\n  \n def isocalendar(self):\n  ''\n\n\n\n\n\n\n\n\n\n\n  \n  year=self._year\n  week1monday=_isoweek1monday(year)\n  today=_ymd2ord(self._year,self._month,self._day)\n  \n  week,day=divmod(today -week1monday,7)\n  if week <0:\n   year -=1\n   week1monday=_isoweek1monday(year)\n   week,day=divmod(today -week1monday,7)\n  elif week >=52:\n   if today >=_isoweek1monday(year+1):\n    year +=1\n    week=0\n  return _IsoCalendarDate(year,week+1,day+1)\n  \n  \n  \n def _getstate(self):\n  yhi,ylo=divmod(self._year,256)\n  return bytes([yhi,ylo,self._month,self._day]),\n  \n def __setstate(self,string):\n  yhi,ylo,self._month,self._day=string\n  self._year=yhi *256+ylo\n  \n def __reduce__(self):\n  return (self.__class__,self._getstate())\n  \n_date_class=date\n\ndate.min=date(1,1,1)\ndate.max=date(9999,12,31)\ndate.resolution=timedelta(days=1)\n\n\nclass tzinfo:\n ''\n\n\n \n __slots__=()\n \n def tzname(self,dt):\n  ''\n  raise NotImplementedError(\"tzinfo subclass must override tzname()\")\n  \n def utcoffset(self,dt):\n  ''\n  raise NotImplementedError(\"tzinfo subclass must override utcoffset()\")\n  \n def dst(self,dt):\n  ''\n\n\n\n  \n  raise NotImplementedError(\"tzinfo subclass must override dst()\")\n  \n def fromutc(self,dt):\n  ''\n  \n  if not isinstance(dt,datetime):\n   raise TypeError(\"fromutc() requires a datetime argument\")\n  if dt.tzinfo is not self:\n   raise ValueError(\"dt.tzinfo is not self\")\n   \n  dtoff=dt.utcoffset()\n  if dtoff is None :\n   raise ValueError(\"fromutc() requires a non-None utcoffset() \"\n   \"result\")\n   \n   \n   \n  dtdst=dt.dst()\n  if dtdst is None :\n   raise ValueError(\"fromutc() requires a non-None dst() result\")\n  delta=dtoff -dtdst\n  if delta:\n   dt +=delta\n   dtdst=dt.dst()\n   if dtdst is None :\n    raise ValueError(\"fromutc(): dt.dst gave inconsistent \"\n    \"results; cannot convert\")\n  return dt+dtdst\n  \n  \n  \n def __reduce__(self):\n  getinitargs=getattr(self,\"__getinitargs__\",None )\n  if getinitargs:\n   args=getinitargs()\n  else :\n   args=()\n  getstate=getattr(self,\"__getstate__\",None )\n  if getstate:\n   state=getstate()\n  else :\n   state=getattr(self,\"__dict__\",None )or None\n  if state is None :\n   return (self.__class__,args)\n  else :\n   return (self.__class__,args,state)\n   \n   \nclass IsoCalendarDate(tuple):\n\n def __new__(cls,year,week,weekday,/):\n  return super().__new__(cls,(year,week,weekday))\n  \n @property\n def year(self):\n  return self[0]\n  \n @property\n def week(self):\n  return self[1]\n  \n @property\n def weekday(self):\n  return self[2]\n  \n def __reduce__(self):\n \n \n  return (tuple,(tuple(self),))\n  \n def __repr__(self):\n  return (f'{self.__class__.__name__}'\n  f'(year={self[0]}, week={self[1]}, weekday={self[2]})')\n  \n  \n_IsoCalendarDate=IsoCalendarDate\ndel IsoCalendarDate\n_tzinfo_class=tzinfo\n\nclass time:\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n __slots__='_hour','_minute','_second','_microsecond','_tzinfo','_hashcode','_fold'\n \n def __new__(cls,hour=0,minute=0,second=0,microsecond=0,tzinfo=None ,*,fold=0):\n  ''\n\n\n\n\n\n\n\n  \n  if (isinstance(hour,(bytes,str))and len(hour)==6 and\n  ord(hour[0:1])&0x7F <24):\n  \n   if isinstance(hour,str):\n    try :\n     hour=hour.encode('latin1')\n    except UnicodeEncodeError:\n    \n     raise ValueError(\n     \"Failed to encode latin1 string when unpickling \"\n     \"a time object. \"\n     \"pickle.load(data, encoding='latin1') is assumed.\")\n   self=object.__new__(cls)\n   self.__setstate(hour,minute or None )\n   self._hashcode=-1\n   return self\n  hour,minute,second,microsecond,fold=_check_time_fields(\n  hour,minute,second,microsecond,fold)\n  _check_tzinfo_arg(tzinfo)\n  self=object.__new__(cls)\n  self._hour=hour\n  self._minute=minute\n  self._second=second\n  self._microsecond=microsecond\n  self._tzinfo=tzinfo\n  self._hashcode=-1\n  self._fold=fold\n  return self\n  \n  \n @property\n def hour(self):\n  ''\n  return self._hour\n  \n @property\n def minute(self):\n  ''\n  return self._minute\n  \n @property\n def second(self):\n  ''\n  return self._second\n  \n @property\n def microsecond(self):\n  ''\n  return self._microsecond\n  \n @property\n def tzinfo(self):\n  ''\n  return self._tzinfo\n  \n @property\n def fold(self):\n  return self._fold\n  \n  \n  \n  \n  \n def __eq__(self,other):\n  if isinstance(other,time):\n   return self._cmp(other,allow_mixed=True )==0\n  else :\n   return NotImplemented\n   \n def __le__(self,other):\n  if isinstance(other,time):\n   return self._cmp(other)<=0\n  else :\n   return NotImplemented\n   \n def __lt__(self,other):\n  if isinstance(other,time):\n   return self._cmp(other)<0\n  else :\n   return NotImplemented\n   \n def __ge__(self,other):\n  if isinstance(other,time):\n   return self._cmp(other)>=0\n  else :\n   return NotImplemented\n   \n def __gt__(self,other):\n  if isinstance(other,time):\n   return self._cmp(other)>0\n  else :\n   return NotImplemented\n   \n def _cmp(self,other,allow_mixed=False ):\n  assert isinstance(other,time)\n  mytz=self._tzinfo\n  ottz=other._tzinfo\n  myoff=otoff=None\n  \n  if mytz is ottz:\n   base_compare=True\n  else :\n   myoff=self.utcoffset()\n   otoff=other.utcoffset()\n   base_compare=myoff ==otoff\n   \n  if base_compare:\n   return _cmp((self._hour,self._minute,self._second,\n   self._microsecond),\n   (other._hour,other._minute,other._second,\n   other._microsecond))\n  if myoff is None or otoff is None :\n   if allow_mixed:\n    return 2\n   else :\n    raise TypeError(\"cannot compare naive and aware times\")\n  myhhmm=self._hour *60+self._minute -myoff //timedelta(minutes=1)\n  othhmm=other._hour *60+other._minute -otoff //timedelta(minutes=1)\n  return _cmp((myhhmm,self._second,self._microsecond),\n  (othhmm,other._second,other._microsecond))\n  \n def __hash__(self):\n  ''\n  if self._hashcode ==-1:\n   if self.fold:\n    t=self.replace(fold=0)\n   else :\n    t=self\n   tzoff=t.utcoffset()\n   if not tzoff:\n    self._hashcode=hash(t._getstate()[0])\n   else :\n    h,m=divmod(timedelta(hours=self.hour,minutes=self.minute)-tzoff,\n    timedelta(hours=1))\n    assert not m %timedelta(minutes=1),\"whole minute\"\n    m //=timedelta(minutes=1)\n    if 0 <=h <24:\n     self._hashcode=hash(time(h,m,self.second,self.microsecond))\n    else :\n     self._hashcode=hash((h,m,self.second,self.microsecond))\n  return self._hashcode\n  \n  \n  \n def _tzstr(self):\n  ''\n  off=self.utcoffset()\n  return _format_offset(off)\n  \n def __repr__(self):\n  ''\n  if self._microsecond !=0:\n   s=\", %d, %d\"%(self._second,self._microsecond)\n  elif self._second !=0:\n   s=\", %d\"%self._second\n  else :\n   s=\"\"\n  s=\"%s.%s(%d, %d%s)\"%(self.__class__.__module__,\n  self.__class__.__qualname__,\n  self._hour,self._minute,s)\n  if self._tzinfo is not None :\n   assert s[-1:]==\")\"\n   s=s[:-1]+\", tzinfo=%r\"%self._tzinfo+\")\"\n  if self._fold:\n   assert s[-1:]==\")\"\n   s=s[:-1]+\", fold=1)\"\n  return s\n  \n def isoformat(self,timespec='auto'):\n  ''\n\n\n\n\n\n\n\n  \n  s=_format_time(self._hour,self._minute,self._second,\n  self._microsecond,timespec)\n  tz=self._tzstr()\n  if tz:\n   s +=tz\n  return s\n  \n __str__=isoformat\n \n @classmethod\n def fromisoformat(cls,time_string):\n  ''\n  if not isinstance(time_string,str):\n   raise TypeError('fromisoformat: argument must be str')\n   \n  try :\n   return cls(*_parse_isoformat_time(time_string))\n  except Exception:\n   raise ValueError(f'Invalid isoformat string: {time_string!r}')\n   \n   \n def strftime(self,fmt):\n  ''\n\n  \n  \n  \n  timetuple=(1900,1,1,\n  self._hour,self._minute,self._second,\n  0,1,-1)\n  return _wrap_strftime(self,fmt,timetuple)\n  \n def __format__(self,fmt):\n  if not isinstance(fmt,str):\n   raise TypeError(\"must be str, not %s\"%type(fmt).__name__)\n  if len(fmt)!=0:\n   return self.strftime(fmt)\n  return str(self)\n  \n  \n  \n def utcoffset(self):\n  ''\n  \n  if self._tzinfo is None :\n   return None\n  offset=self._tzinfo.utcoffset(None )\n  _check_utc_offset(\"utcoffset\",offset)\n  return offset\n  \n def tzname(self):\n  ''\n\n\n\n\n  \n  if self._tzinfo is None :\n   return None\n  name=self._tzinfo.tzname(None )\n  _check_tzname(name)\n  return name\n  \n def dst(self):\n  ''\n\n\n\n\n\n\n  \n  if self._tzinfo is None :\n   return None\n  offset=self._tzinfo.dst(None )\n  _check_utc_offset(\"dst\",offset)\n  return offset\n  \n def replace(self,hour=None ,minute=None ,second=None ,microsecond=None ,\n tzinfo=True ,*,fold=None ):\n  ''\n  if hour is None :\n   hour=self.hour\n  if minute is None :\n   minute=self.minute\n  if second is None :\n   second=self.second\n  if microsecond is None :\n   microsecond=self.microsecond\n  if tzinfo is True :\n   tzinfo=self.tzinfo\n  if fold is None :\n   fold=self._fold\n  return type(self)(hour,minute,second,microsecond,tzinfo,fold=fold)\n  \n  \n  \n def _getstate(self,protocol=3):\n  us2,us3=divmod(self._microsecond,256)\n  us1,us2=divmod(us2,256)\n  h=self._hour\n  if self._fold and protocol >3:\n   h +=128\n  basestate=bytes([h,self._minute,self._second,\n  us1,us2,us3])\n  if self._tzinfo is None :\n   return (basestate,)\n  else :\n   return (basestate,self._tzinfo)\n   \n def __setstate(self,string,tzinfo):\n  if tzinfo is not None and not isinstance(tzinfo,_tzinfo_class):\n   raise TypeError(\"bad tzinfo state arg\")\n  h,self._minute,self._second,us1,us2,us3=string\n  if h >127:\n   self._fold=1\n   self._hour=h -128\n  else :\n   self._fold=0\n   self._hour=h\n  self._microsecond=(((us1 <<8)|us2)<<8)|us3\n  self._tzinfo=tzinfo\n  \n def __reduce_ex__(self,protocol):\n  return (self.__class__,self._getstate(protocol))\n  \n def __reduce__(self):\n  return self.__reduce_ex__(2)\n  \n_time_class=time\n\ntime.min=time(0,0,0)\ntime.max=time(23,59,59,999999)\ntime.resolution=timedelta(microseconds=1)\n\n\nclass datetime(date):\n ''\n\n\n\n \n __slots__=date.__slots__+time.__slots__\n \n def __new__(cls,year,month=None ,day=None ,hour=0,minute=0,second=0,\n microsecond=0,tzinfo=None ,*,fold=0):\n  if (isinstance(year,(bytes,str))and len(year)==10 and\n  1 <=ord(year[2:3])&0x7F <=12):\n  \n   if isinstance(year,str):\n    try :\n     year=bytes(year,'latin1')\n    except UnicodeEncodeError:\n    \n     raise ValueError(\n     \"Failed to encode latin1 string when unpickling \"\n     \"a datetime object. \"\n     \"pickle.load(data, encoding='latin1') is assumed.\")\n   self=object.__new__(cls)\n   self.__setstate(year,month)\n   self._hashcode=-1\n   return self\n  year,month,day=_check_date_fields(year,month,day)\n  hour,minute,second,microsecond,fold=_check_time_fields(\n  hour,minute,second,microsecond,fold)\n  _check_tzinfo_arg(tzinfo)\n  self=object.__new__(cls)\n  self._year=year\n  self._month=month\n  self._day=day\n  self._hour=hour\n  self._minute=minute\n  self._second=second\n  self._microsecond=microsecond\n  self._tzinfo=tzinfo\n  self._hashcode=-1\n  self._fold=fold\n  return self\n  \n  \n @property\n def hour(self):\n  ''\n  return self._hour\n  \n @property\n def minute(self):\n  ''\n  return self._minute\n  \n @property\n def second(self):\n  ''\n  return self._second\n  \n @property\n def microsecond(self):\n  ''\n  return self._microsecond\n  \n @property\n def tzinfo(self):\n  ''\n  return self._tzinfo\n  \n @property\n def fold(self):\n  return self._fold\n  \n @classmethod\n def _fromtimestamp(cls,t,utc,tz):\n  ''\n\n\n  \n  frac,t=_math.modf(t)\n  us=round(frac *1e6)\n  if us >=1000000:\n   t +=1\n   us -=1000000\n  elif us <0:\n   t -=1\n   us +=1000000\n   \n  converter=_time.gmtime if utc else _time.localtime\n  y,m,d,hh,mm,ss,weekday,jday,dst=converter(t)\n  ss=min(ss,59)\n  result=cls(y,m,d,hh,mm,ss,us,tz)\n  if tz is None :\n  \n  \n  \n   max_fold_seconds=24 *3600\n   \n   \n   \n   \n   \n   if t <max_fold_seconds and sys.platform.startswith(\"win\"):\n    return result\n    \n   y,m,d,hh,mm,ss=converter(t -max_fold_seconds)[:6]\n   probe1=cls(y,m,d,hh,mm,ss,us,tz)\n   trans=result -probe1 -timedelta(0,max_fold_seconds)\n   if trans.days <0:\n    y,m,d,hh,mm,ss=converter(t+trans //timedelta(0,1))[:6]\n    probe2=cls(y,m,d,hh,mm,ss,us,tz)\n    if probe2 ==result:\n     result._fold=1\n  else :\n   result=tz.fromutc(result)\n  return result\n  \n @classmethod\n def fromtimestamp(cls,t,tz=None ):\n  ''\n\n\n  \n  _check_tzinfo_arg(tz)\n  \n  return cls._fromtimestamp(t,tz is not None ,tz)\n  \n @classmethod\n def utcfromtimestamp(cls,t):\n  ''\n  return cls._fromtimestamp(t,True ,None )\n  \n @classmethod\n def now(cls,tz=None ):\n  ''\n  t=_time.time()\n  return cls.fromtimestamp(t,tz)\n  \n @classmethod\n def utcnow(cls):\n  ''\n  t=_time.time()\n  return cls.utcfromtimestamp(t)\n  \n @classmethod\n def combine(cls,date,time,tzinfo=True ):\n  ''\n  if not isinstance(date,_date_class):\n   raise TypeError(\"date argument must be a date instance\")\n  if not isinstance(time,_time_class):\n   raise TypeError(\"time argument must be a time instance\")\n  if tzinfo is True :\n   tzinfo=time.tzinfo\n  return cls(date.year,date.month,date.day,\n  time.hour,time.minute,time.second,time.microsecond,\n  tzinfo,fold=time.fold)\n  \n @classmethod\n def fromisoformat(cls,date_string):\n  ''\n  if not isinstance(date_string,str):\n   raise TypeError('fromisoformat: argument must be str')\n   \n   \n  dstr=date_string[0:10]\n  tstr=date_string[11:]\n  \n  try :\n   date_components=_parse_isoformat_date(dstr)\n  except ValueError:\n   raise ValueError(f'Invalid isoformat string: {date_string!r}')\n   \n  if tstr:\n   try :\n    time_components=_parse_isoformat_time(tstr)\n   except ValueError:\n    raise ValueError(f'Invalid isoformat string: {date_string!r}')\n  else :\n   time_components=[0,0,0,0,None ]\n   \n  return cls(*(date_components+time_components))\n  \n def timetuple(self):\n  ''\n  dst=self.dst()\n  if dst is None :\n   dst=-1\n  elif dst:\n   dst=1\n  else :\n   dst=0\n  return _build_struct_time(self.year,self.month,self.day,\n  self.hour,self.minute,self.second,\n  dst)\n  \n def _mktime(self):\n  ''\n  epoch=datetime(1970,1,1)\n  max_fold_seconds=24 *3600\n  t=(self -epoch)//timedelta(0,1)\n  def local(u):\n   y,m,d,hh,mm,ss=_time.localtime(u)[:6]\n   return (datetime(y,m,d,hh,mm,ss)-epoch)//timedelta(0,1)\n   \n   \n  a=local(t)-t\n  u1=t -a\n  t1=local(u1)\n  if t1 ==t:\n  \n  \n  \n   u2=u1+(-max_fold_seconds,max_fold_seconds)[self.fold]\n   b=local(u2)-u2\n   if a ==b:\n    return u1\n  else :\n   b=t1 -u1\n   assert a !=b\n  u2=t -b\n  t2=local(u2)\n  if t2 ==t:\n   return u2\n  if t1 ==t:\n   return u1\n   \n   \n  return (max,min)[self.fold](u1,u2)\n  \n  \n def timestamp(self):\n  ''\n  if self._tzinfo is None :\n   s=self._mktime()\n   return s+self.microsecond /1e6\n  else :\n   return (self -_EPOCH).total_seconds()\n   \n def utctimetuple(self):\n  ''\n  offset=self.utcoffset()\n  if offset:\n   self -=offset\n  y,m,d=self.year,self.month,self.day\n  hh,mm,ss=self.hour,self.minute,self.second\n  return _build_struct_time(y,m,d,hh,mm,ss,0)\n  \n def date(self):\n  ''\n  return date(self._year,self._month,self._day)\n  \n def time(self):\n  ''\n  return time(self.hour,self.minute,self.second,self.microsecond,fold=self.fold)\n  \n def timetz(self):\n  ''\n  return time(self.hour,self.minute,self.second,self.microsecond,\n  self._tzinfo,fold=self.fold)\n  \n def replace(self,year=None ,month=None ,day=None ,hour=None ,\n minute=None ,second=None ,microsecond=None ,tzinfo=True ,\n *,fold=None ):\n  ''\n  if year is None :\n   year=self.year\n  if month is None :\n   month=self.month\n  if day is None :\n   day=self.day\n  if hour is None :\n   hour=self.hour\n  if minute is None :\n   minute=self.minute\n  if second is None :\n   second=self.second\n  if microsecond is None :\n   microsecond=self.microsecond\n  if tzinfo is True :\n   tzinfo=self.tzinfo\n  if fold is None :\n   fold=self.fold\n  return type(self)(year,month,day,hour,minute,second,\n  microsecond,tzinfo,fold=fold)\n  \n def _local_timezone(self):\n  if self.tzinfo is None :\n   ts=self._mktime()\n  else :\n   ts=(self -_EPOCH)//timedelta(seconds=1)\n  localtm=_time.localtime(ts)\n  local=datetime(*localtm[:6])\n  \n  gmtoff=localtm.tm_gmtoff\n  zone=localtm.tm_zone\n  return timezone(timedelta(seconds=gmtoff),zone)\n  \n def astimezone(self,tz=None ):\n  if tz is None :\n   tz=self._local_timezone()\n  elif not isinstance(tz,tzinfo):\n   raise TypeError(\"tz argument must be an instance of tzinfo\")\n   \n  mytz=self.tzinfo\n  if mytz is None :\n   mytz=self._local_timezone()\n   myoffset=mytz.utcoffset(self)\n  else :\n   myoffset=mytz.utcoffset(self)\n   if myoffset is None :\n    mytz=self.replace(tzinfo=None )._local_timezone()\n    myoffset=mytz.utcoffset(self)\n    \n  if tz is mytz:\n   return self\n   \n   \n  utc=(self -myoffset).replace(tzinfo=tz)\n  \n  \n  return tz.fromutc(utc)\n  \n  \n  \n def ctime(self):\n  ''\n  weekday=self.toordinal()%7 or 7\n  return \"%s %s %2d %02d:%02d:%02d %04d\"%(\n  _DAYNAMES[weekday],\n  _MONTHNAMES[self._month],\n  self._day,\n  self._hour,self._minute,self._second,\n  self._year)\n  \n def isoformat(self,sep='T',timespec='auto'):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  s=(\"%04d-%02d-%02d%c\"%(self._year,self._month,self._day,sep)+\n  _format_time(self._hour,self._minute,self._second,\n  self._microsecond,timespec))\n  \n  off=self.utcoffset()\n  tz=_format_offset(off)\n  if tz:\n   s +=tz\n   \n  return s\n  \n def __repr__(self):\n  ''\n  L=[self._year,self._month,self._day,\n  self._hour,self._minute,self._second,self._microsecond]\n  if L[-1]==0:\n   del L[-1]\n  if L[-1]==0:\n   del L[-1]\n  s=\"%s.%s(%s)\"%(self.__class__.__module__,\n  self.__class__.__qualname__,\n  \", \".join(map(str,L)))\n  if self._tzinfo is not None :\n   assert s[-1:]==\")\"\n   s=s[:-1]+\", tzinfo=%r\"%self._tzinfo+\")\"\n  if self._fold:\n   assert s[-1:]==\")\"\n   s=s[:-1]+\", fold=1)\"\n  return s\n  \n def __str__(self):\n  ''\n  return self.isoformat(sep=' ')\n  \n @classmethod\n def strptime(cls,date_string,format):\n  ''\n  import _strptime\n  return _strptime._strptime_datetime(cls,date_string,format)\n  \n def utcoffset(self):\n  ''\n  \n  if self._tzinfo is None :\n   return None\n  offset=self._tzinfo.utcoffset(self)\n  _check_utc_offset(\"utcoffset\",offset)\n  return offset\n  \n def tzname(self):\n  ''\n\n\n\n\n  \n  if self._tzinfo is None :\n   return None\n  name=self._tzinfo.tzname(self)\n  _check_tzname(name)\n  return name\n  \n def dst(self):\n  ''\n\n\n\n\n\n\n  \n  if self._tzinfo is None :\n   return None\n  offset=self._tzinfo.dst(self)\n  _check_utc_offset(\"dst\",offset)\n  return offset\n  \n  \n  \n def __eq__(self,other):\n  if isinstance(other,datetime):\n   return self._cmp(other,allow_mixed=True )==0\n  elif not isinstance(other,date):\n   return NotImplemented\n  else :\n   return False\n   \n def __le__(self,other):\n  if isinstance(other,datetime):\n   return self._cmp(other)<=0\n  elif not isinstance(other,date):\n   return NotImplemented\n  else :\n   _cmperror(self,other)\n   \n def __lt__(self,other):\n  if isinstance(other,datetime):\n   return self._cmp(other)<0\n  elif not isinstance(other,date):\n   return NotImplemented\n  else :\n   _cmperror(self,other)\n   \n def __ge__(self,other):\n  if isinstance(other,datetime):\n   return self._cmp(other)>=0\n  elif not isinstance(other,date):\n   return NotImplemented\n  else :\n   _cmperror(self,other)\n   \n def __gt__(self,other):\n  if isinstance(other,datetime):\n   return self._cmp(other)>0\n  elif not isinstance(other,date):\n   return NotImplemented\n  else :\n   _cmperror(self,other)\n   \n def _cmp(self,other,allow_mixed=False ):\n  assert isinstance(other,datetime)\n  mytz=self._tzinfo\n  ottz=other._tzinfo\n  myoff=otoff=None\n  \n  if mytz is ottz:\n   base_compare=True\n  else :\n   myoff=self.utcoffset()\n   otoff=other.utcoffset()\n   \n   if allow_mixed:\n    if myoff !=self.replace(fold=not self.fold).utcoffset():\n     return 2\n    if otoff !=other.replace(fold=not other.fold).utcoffset():\n     return 2\n   base_compare=myoff ==otoff\n   \n  if base_compare:\n   return _cmp((self._year,self._month,self._day,\n   self._hour,self._minute,self._second,\n   self._microsecond),\n   (other._year,other._month,other._day,\n   other._hour,other._minute,other._second,\n   other._microsecond))\n  if myoff is None or otoff is None :\n   if allow_mixed:\n    return 2\n   else :\n    raise TypeError(\"cannot compare naive and aware datetimes\")\n    \n  diff=self -other\n  if diff.days <0:\n   return -1\n  return diff and 1 or 0\n  \n def __add__(self,other):\n  ''\n  if not isinstance(other,timedelta):\n   return NotImplemented\n  delta=timedelta(self.toordinal(),\n  hours=self._hour,\n  minutes=self._minute,\n  seconds=self._second,\n  microseconds=self._microsecond)\n  delta +=other\n  hour,rem=divmod(delta.seconds,3600)\n  minute,second=divmod(rem,60)\n  if 0 <delta.days <=_MAXORDINAL:\n   return type(self).combine(date.fromordinal(delta.days),\n   time(hour,minute,second,\n   delta.microseconds,\n   tzinfo=self._tzinfo))\n  raise OverflowError(\"result out of range\")\n  \n __radd__=__add__\n \n def __sub__(self,other):\n  ''\n  if not isinstance(other,datetime):\n   if isinstance(other,timedelta):\n    return self+-other\n   return NotImplemented\n   \n  days1=self.toordinal()\n  days2=other.toordinal()\n  secs1=self._second+self._minute *60+self._hour *3600\n  secs2=other._second+other._minute *60+other._hour *3600\n  base=timedelta(days1 -days2,\n  secs1 -secs2,\n  self._microsecond -other._microsecond)\n  if self._tzinfo is other._tzinfo:\n   return base\n  myoff=self.utcoffset()\n  otoff=other.utcoffset()\n  if myoff ==otoff:\n   return base\n  if myoff is None or otoff is None :\n   raise TypeError(\"cannot mix naive and timezone-aware time\")\n  return base+otoff -myoff\n  \n def __hash__(self):\n  if self._hashcode ==-1:\n   if self.fold:\n    t=self.replace(fold=0)\n   else :\n    t=self\n   tzoff=t.utcoffset()\n   if tzoff is None :\n    self._hashcode=hash(t._getstate()[0])\n   else :\n    days=_ymd2ord(self.year,self.month,self.day)\n    seconds=self.hour *3600+self.minute *60+self.second\n    self._hashcode=hash(timedelta(days,seconds,self.microsecond)-tzoff)\n  return self._hashcode\n  \n  \n  \n def _getstate(self,protocol=3):\n  yhi,ylo=divmod(self._year,256)\n  us2,us3=divmod(self._microsecond,256)\n  us1,us2=divmod(us2,256)\n  m=self._month\n  if self._fold and protocol >3:\n   m +=128\n  basestate=bytes([yhi,ylo,m,self._day,\n  self._hour,self._minute,self._second,\n  us1,us2,us3])\n  if self._tzinfo is None :\n   return (basestate,)\n  else :\n   return (basestate,self._tzinfo)\n   \n def __setstate(self,string,tzinfo):\n  if tzinfo is not None and not isinstance(tzinfo,_tzinfo_class):\n   raise TypeError(\"bad tzinfo state arg\")\n  (yhi,ylo,m,self._day,self._hour,\n  self._minute,self._second,us1,us2,us3)=string\n  if m >127:\n   self._fold=1\n   self._month=m -128\n  else :\n   self._fold=0\n   self._month=m\n  self._year=yhi *256+ylo\n  self._microsecond=(((us1 <<8)|us2)<<8)|us3\n  self._tzinfo=tzinfo\n  \n def __reduce_ex__(self,protocol):\n  return (self.__class__,self._getstate(protocol))\n  \n def __reduce__(self):\n  return self.__reduce_ex__(2)\n  \n  \ndatetime.min=datetime(1,1,1)\ndatetime.max=datetime(9999,12,31,23,59,59,999999)\ndatetime.resolution=timedelta(microseconds=1)\n\n\ndef _isoweek1monday(year):\n\n\n THURSDAY=3\n firstday=_ymd2ord(year,1,1)\n firstweekday=(firstday+6)%7\n week1monday=firstday -firstweekday\n if firstweekday >THURSDAY:\n  week1monday +=7\n return week1monday\n \n \nclass timezone(tzinfo):\n __slots__='_offset','_name'\n \n \n _Omitted=object()\n def __new__(cls,offset,name=_Omitted):\n  if not isinstance(offset,timedelta):\n   raise TypeError(\"offset must be a timedelta\")\n  if name is cls._Omitted:\n   if not offset:\n    return cls.utc\n   name=None\n  elif not isinstance(name,str):\n   raise TypeError(\"name must be a string\")\n  if not cls._minoffset <=offset <=cls._maxoffset:\n   raise ValueError(\"offset must be a timedelta \"\n   \"strictly between -timedelta(hours=24) and \"\n   \"timedelta(hours=24).\")\n  return cls._create(offset,name)\n  \n @classmethod\n def _create(cls,offset,name=None ):\n  self=tzinfo.__new__(cls)\n  self._offset=offset\n  self._name=name\n  return self\n  \n def __getinitargs__(self):\n  ''\n  if self._name is None :\n   return (self._offset,)\n  return (self._offset,self._name)\n  \n def __eq__(self,other):\n  if isinstance(other,timezone):\n   return self._offset ==other._offset\n  return NotImplemented\n  \n def __hash__(self):\n  return hash(self._offset)\n  \n def __repr__(self):\n  ''\n\n\n\n\n\n\n\n  \n  if self is self.utc:\n   return 'datetime.timezone.utc'\n  if self._name is None :\n   return \"%s.%s(%r)\"%(self.__class__.__module__,\n   self.__class__.__qualname__,\n   self._offset)\n  return \"%s.%s(%r, %r)\"%(self.__class__.__module__,\n  self.__class__.__qualname__,\n  self._offset,self._name)\n  \n def __str__(self):\n  return self.tzname(None )\n  \n def utcoffset(self,dt):\n  if isinstance(dt,datetime)or dt is None :\n   return self._offset\n  raise TypeError(\"utcoffset() argument must be a datetime instance\"\n  \" or None\")\n  \n def tzname(self,dt):\n  if isinstance(dt,datetime)or dt is None :\n   if self._name is None :\n    return self._name_from_offset(self._offset)\n   return self._name\n  raise TypeError(\"tzname() argument must be a datetime instance\"\n  \" or None\")\n  \n def dst(self,dt):\n  if isinstance(dt,datetime)or dt is None :\n   return None\n  raise TypeError(\"dst() argument must be a datetime instance\"\n  \" or None\")\n  \n def fromutc(self,dt):\n  if isinstance(dt,datetime):\n   if dt.tzinfo is not self:\n    raise ValueError(\"fromutc: dt.tzinfo \"\n    \"is not self\")\n   return dt+self._offset\n  raise TypeError(\"fromutc() argument must be a datetime instance\"\n  \" or None\")\n  \n _maxoffset=timedelta(hours=24,microseconds=-1)\n _minoffset=-_maxoffset\n \n @staticmethod\n def _name_from_offset(delta):\n  if not delta:\n   return 'UTC'\n  if delta <timedelta(0):\n   sign='-'\n   delta=-delta\n  else :\n   sign='+'\n  hours,rest=divmod(delta,timedelta(hours=1))\n  minutes,rest=divmod(rest,timedelta(minutes=1))\n  seconds=rest.seconds\n  microseconds=rest.microseconds\n  if microseconds:\n   return (f'UTC{sign}{hours:02d}:{minutes:02d}:{seconds:02d}'\n   f'.{microseconds:06d}')\n  if seconds:\n   return f'UTC{sign}{hours:02d}:{minutes:02d}:{seconds:02d}'\n  return f'UTC{sign}{hours:02d}:{minutes:02d}'\n  \ntimezone.utc=timezone._create(timedelta(0))\n\n\n\ntimezone.min=timezone._create(-timedelta(hours=23,minutes=59))\ntimezone.max=timezone._create(timedelta(hours=23,minutes=59))\n_EPOCH=datetime(1970,1,1,tzinfo=timezone.utc)\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\ntry :\n from _datetime import *\nexcept ImportError:\n pass\nelse :\n\n del (_DAYNAMES,_DAYS_BEFORE_MONTH,_DAYS_IN_MONTH,_DI100Y,_DI400Y,\n _DI4Y,_EPOCH,_MAXORDINAL,_MONTHNAMES,_build_struct_time,\n _check_date_fields,_check_time_fields,\n _check_tzinfo_arg,_check_tzname,_check_utc_offset,_cmp,_cmperror,\n _date_class,_days_before_month,_days_before_year,_days_in_month,\n _format_time,_format_offset,_index,_is_leap,_isoweek1monday,_math,\n _ord2ymd,_time,_time_class,_tzinfo_class,_wrap_strftime,_ymd2ord,\n _divide_and_round,_parse_isoformat_date,_parse_isoformat_time,\n _parse_hh_mm_ss_ff,_IsoCalendarDate)\n \n \n \n \n from _datetime import __doc__\n", ["_datetime", "_strptime", "math", "operator", "sys", "time"]], "decimal": [".py", "\ntry :\n from _decimal import *\n from _decimal import __doc__\n from _decimal import __version__\n from _decimal import __libmpdec_version__\nexcept ImportError:\n from _pydecimal import *\n from _pydecimal import __doc__\n from _pydecimal import __version__\n from _pydecimal import __libmpdec_version__\n", ["_decimal", "_pydecimal"]], "difflib": [".py", "''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n__all__=['get_close_matches','ndiff','restore','SequenceMatcher',\n'Differ','IS_CHARACTER_JUNK','IS_LINE_JUNK','context_diff',\n'unified_diff','diff_bytes','HtmlDiff','Match']\n\nfrom heapq import nlargest as _nlargest\nfrom collections import namedtuple as _namedtuple\nfrom types import GenericAlias\n\nMatch=_namedtuple('Match','a b size')\n\ndef _calculate_ratio(matches,length):\n if length:\n  return 2.0 *matches /length\n return 1.0\n \nclass SequenceMatcher:\n\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n def __init__(self,isjunk=None ,a='',b='',autojunk=True ):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  self.isjunk=isjunk\n  self.a=self.b=None\n  self.autojunk=autojunk\n  self.set_seqs(a,b)\n  \n def set_seqs(self,a,b):\n  ''\n\n\n\n\n\n  \n  \n  self.set_seq1(a)\n  self.set_seq2(b)\n  \n def set_seq1(self,a):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  if a is self.a:\n   return\n  self.a=a\n  self.matching_blocks=self.opcodes=None\n  \n def set_seq2(self,b):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  if b is self.b:\n   return\n  self.b=b\n  self.matching_blocks=self.opcodes=None\n  self.fullbcount=None\n  self.__chain_b()\n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n def __chain_b(self):\n \n \n \n \n \n \n \n \n \n \n  b=self.b\n  self.b2j=b2j={}\n  \n  for i,elt in enumerate(b):\n   indices=b2j.setdefault(elt,[])\n   indices.append(i)\n   \n   \n  self.bjunk=junk=set()\n  isjunk=self.isjunk\n  if isjunk:\n   for elt in b2j.keys():\n    if isjunk(elt):\n     junk.add(elt)\n   for elt in junk:\n    del b2j[elt]\n    \n    \n  self.bpopular=popular=set()\n  n=len(b)\n  if self.autojunk and n >=200:\n   ntest=n //100+1\n   for elt,idxs in b2j.items():\n    if len(idxs)>ntest:\n     popular.add(elt)\n   for elt in popular:\n    del b2j[elt]\n    \n def find_longest_match(self,alo=0,ahi=None ,blo=0,bhi=None ):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  a,b,b2j,isbjunk=self.a,self.b,self.b2j,self.bjunk.__contains__\n  if ahi is None :\n   ahi=len(a)\n  if bhi is None :\n   bhi=len(b)\n  besti,bestj,bestsize=alo,blo,0\n  \n  \n  \n  j2len={}\n  nothing=[]\n  for i in range(alo,ahi):\n  \n  \n   j2lenget=j2len.get\n   newj2len={}\n   for j in b2j.get(a[i],nothing):\n   \n    if j <blo:\n     continue\n    if j >=bhi:\n     break\n    k=newj2len[j]=j2lenget(j -1,0)+1\n    if k >bestsize:\n     besti,bestj,bestsize=i -k+1,j -k+1,k\n   j2len=newj2len\n   \n   \n   \n   \n   \n  while besti >alo and bestj >blo and\\\n  not isbjunk(b[bestj -1])and\\\n  a[besti -1]==b[bestj -1]:\n   besti,bestj,bestsize=besti -1,bestj -1,bestsize+1\n  while besti+bestsize <ahi and bestj+bestsize <bhi and\\\n  not isbjunk(b[bestj+bestsize])and\\\n  a[besti+bestsize]==b[bestj+bestsize]:\n   bestsize +=1\n   \n   \n   \n   \n   \n   \n   \n   \n  while besti >alo and bestj >blo and\\\n  isbjunk(b[bestj -1])and\\\n  a[besti -1]==b[bestj -1]:\n   besti,bestj,bestsize=besti -1,bestj -1,bestsize+1\n  while besti+bestsize <ahi and bestj+bestsize <bhi and\\\n  isbjunk(b[bestj+bestsize])and\\\n  a[besti+bestsize]==b[bestj+bestsize]:\n   bestsize=bestsize+1\n   \n  return Match(besti,bestj,bestsize)\n  \n def get_matching_blocks(self):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  if self.matching_blocks is not None :\n   return self.matching_blocks\n  la,lb=len(self.a),len(self.b)\n  \n  \n  \n  \n  \n  \n  \n  queue=[(0,la,0,lb)]\n  matching_blocks=[]\n  while queue:\n   alo,ahi,blo,bhi=queue.pop()\n   i,j,k=x=self.find_longest_match(alo,ahi,blo,bhi)\n   \n   \n   \n   if k:\n    matching_blocks.append(x)\n    if alo <i and blo <j:\n     queue.append((alo,i,blo,j))\n    if i+k <ahi and j+k <bhi:\n     queue.append((i+k,ahi,j+k,bhi))\n  matching_blocks.sort()\n  \n  \n  \n  \n  i1=j1=k1=0\n  non_adjacent=[]\n  for i2,j2,k2 in matching_blocks:\n  \n   if i1+k1 ==i2 and j1+k1 ==j2:\n   \n   \n   \n    k1 +=k2\n   else :\n   \n   \n   \n    if k1:\n     non_adjacent.append((i1,j1,k1))\n    i1,j1,k1=i2,j2,k2\n  if k1:\n   non_adjacent.append((i1,j1,k1))\n   \n  non_adjacent.append((la,lb,0))\n  self.matching_blocks=list(map(Match._make,non_adjacent))\n  return self.matching_blocks\n  \n def get_opcodes(self):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  if self.opcodes is not None :\n   return self.opcodes\n  i=j=0\n  self.opcodes=answer=[]\n  for ai,bj,size in self.get_matching_blocks():\n  \n  \n  \n  \n  \n   tag=''\n   if i <ai and j <bj:\n    tag='replace'\n   elif i <ai:\n    tag='delete'\n   elif j <bj:\n    tag='insert'\n   if tag:\n    answer.append((tag,i,ai,j,bj))\n   i,j=ai+size,bj+size\n   \n   \n   if size:\n    answer.append(('equal',ai,i,bj,j))\n  return answer\n  \n def get_grouped_opcodes(self,n=3):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  codes=self.get_opcodes()\n  if not codes:\n   codes=[(\"equal\",0,1,0,1)]\n   \n  if codes[0][0]=='equal':\n   tag,i1,i2,j1,j2=codes[0]\n   codes[0]=tag,max(i1,i2 -n),i2,max(j1,j2 -n),j2\n  if codes[-1][0]=='equal':\n   tag,i1,i2,j1,j2=codes[-1]\n   codes[-1]=tag,i1,min(i2,i1+n),j1,min(j2,j1+n)\n   \n  nn=n+n\n  group=[]\n  for tag,i1,i2,j1,j2 in codes:\n  \n  \n   if tag =='equal'and i2 -i1 >nn:\n    group.append((tag,i1,min(i2,i1+n),j1,min(j2,j1+n)))\n    yield group\n    group=[]\n    i1,j1=max(i1,i2 -n),max(j1,j2 -n)\n   group.append((tag,i1,i2,j1,j2))\n  if group and not (len(group)==1 and group[0][0]=='equal'):\n   yield group\n   \n def ratio(self):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  matches=sum(triple[-1]for triple in self.get_matching_blocks())\n  return _calculate_ratio(matches,len(self.a)+len(self.b))\n  \n def quick_ratio(self):\n  ''\n\n\n\n  \n  \n  \n  \n  \n  if self.fullbcount is None :\n   self.fullbcount=fullbcount={}\n   for elt in self.b:\n    fullbcount[elt]=fullbcount.get(elt,0)+1\n  fullbcount=self.fullbcount\n  \n  \n  avail={}\n  availhas,matches=avail.__contains__,0\n  for elt in self.a:\n   if availhas(elt):\n    numb=avail[elt]\n   else :\n    numb=fullbcount.get(elt,0)\n   avail[elt]=numb -1\n   if numb >0:\n    matches=matches+1\n  return _calculate_ratio(matches,len(self.a)+len(self.b))\n  \n def real_quick_ratio(self):\n  ''\n\n\n\n  \n  \n  la,lb=len(self.a),len(self.b)\n  \n  \n  return _calculate_ratio(min(la,lb),la+lb)\n  \n __class_getitem__=classmethod(GenericAlias)\n \n \ndef get_close_matches(word,possibilities,n=3,cutoff=0.6):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n if not n >0:\n  raise ValueError(\"n must be > 0: %r\"%(n,))\n if not 0.0 <=cutoff <=1.0:\n  raise ValueError(\"cutoff must be in [0.0, 1.0]: %r\"%(cutoff,))\n result=[]\n s=SequenceMatcher()\n s.set_seq2(word)\n for x in possibilities:\n  s.set_seq1(x)\n  if s.real_quick_ratio()>=cutoff and\\\n  s.quick_ratio()>=cutoff and\\\n  s.ratio()>=cutoff:\n   result.append((s.ratio(),x))\n   \n   \n result=_nlargest(n,result)\n \n return [x for score,x in result]\n \n \ndef _keep_original_ws(s,tag_s):\n ''\n return ''.join(\n c if tag_c ==\" \"and c.isspace()else tag_c\n for c,tag_c in zip(s,tag_s)\n )\n \n \n \nclass Differ:\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n def __init__(self,linejunk=None ,charjunk=None ):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  self.linejunk=linejunk\n  self.charjunk=charjunk\n  \n def compare(self,a,b):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  cruncher=SequenceMatcher(self.linejunk,a,b)\n  for tag,alo,ahi,blo,bhi in cruncher.get_opcodes():\n   if tag =='replace':\n    g=self._fancy_replace(a,alo,ahi,b,blo,bhi)\n   elif tag =='delete':\n    g=self._dump('-',a,alo,ahi)\n   elif tag =='insert':\n    g=self._dump('+',b,blo,bhi)\n   elif tag =='equal':\n    g=self._dump(' ',a,alo,ahi)\n   else :\n    raise ValueError('unknown tag %r'%(tag,))\n    \n   yield from g\n   \n def _dump(self,tag,x,lo,hi):\n  ''\n  for i in range(lo,hi):\n   yield '%s %s'%(tag,x[i])\n   \n def _plain_replace(self,a,alo,ahi,b,blo,bhi):\n  assert alo <ahi and blo <bhi\n  \n  \n  if bhi -blo <ahi -alo:\n   first=self._dump('+',b,blo,bhi)\n   second=self._dump('-',a,alo,ahi)\n  else :\n   first=self._dump('-',a,alo,ahi)\n   second=self._dump('+',b,blo,bhi)\n   \n  for g in first,second:\n   yield from g\n   \n def _fancy_replace(self,a,alo,ahi,b,blo,bhi):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  \n  \n  best_ratio,cutoff=0.74,0.75\n  cruncher=SequenceMatcher(self.charjunk)\n  eqi,eqj=None ,None\n  \n  \n  \n  \n  for j in range(blo,bhi):\n   bj=b[j]\n   cruncher.set_seq2(bj)\n   for i in range(alo,ahi):\n    ai=a[i]\n    if ai ==bj:\n     if eqi is None :\n      eqi,eqj=i,j\n     continue\n    cruncher.set_seq1(ai)\n    \n    \n    \n    \n    \n    \n    if cruncher.real_quick_ratio()>best_ratio and\\\n    cruncher.quick_ratio()>best_ratio and\\\n    cruncher.ratio()>best_ratio:\n     best_ratio,best_i,best_j=cruncher.ratio(),i,j\n  if best_ratio <cutoff:\n  \n   if eqi is None :\n   \n    yield from self._plain_replace(a,alo,ahi,b,blo,bhi)\n    return\n    \n   best_i,best_j,best_ratio=eqi,eqj,1.0\n  else :\n  \n   eqi=None\n   \n   \n   \n   \n   \n  yield from self._fancy_helper(a,alo,best_i,b,blo,best_j)\n  \n  \n  aelt,belt=a[best_i],b[best_j]\n  if eqi is None :\n  \n   atags=btags=\"\"\n   cruncher.set_seqs(aelt,belt)\n   for tag,ai1,ai2,bj1,bj2 in cruncher.get_opcodes():\n    la,lb=ai2 -ai1,bj2 -bj1\n    if tag =='replace':\n     atags +='^'*la\n     btags +='^'*lb\n    elif tag =='delete':\n     atags +='-'*la\n    elif tag =='insert':\n     btags +='+'*lb\n    elif tag =='equal':\n     atags +=' '*la\n     btags +=' '*lb\n    else :\n     raise ValueError('unknown tag %r'%(tag,))\n   yield from self._qformat(aelt,belt,atags,btags)\n  else :\n  \n   yield '  '+aelt\n   \n   \n  yield from self._fancy_helper(a,best_i+1,ahi,b,best_j+1,bhi)\n  \n def _fancy_helper(self,a,alo,ahi,b,blo,bhi):\n  g=[]\n  if alo <ahi:\n   if blo <bhi:\n    g=self._fancy_replace(a,alo,ahi,b,blo,bhi)\n   else :\n    g=self._dump('-',a,alo,ahi)\n  elif blo <bhi:\n   g=self._dump('+',b,blo,bhi)\n   \n  yield from g\n  \n def _qformat(self,aline,bline,atags,btags):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  atags=_keep_original_ws(aline,atags).rstrip()\n  btags=_keep_original_ws(bline,btags).rstrip()\n  \n  yield \"- \"+aline\n  if atags:\n   yield f\"? {atags}\\n\"\n   \n  yield \"+ \"+bline\n  if btags:\n   yield f\"? {btags}\\n\"\n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \nimport re\n\ndef IS_LINE_JUNK(line,pat=re.compile(r\"\\s*(?:#\\s*)?$\").match):\n ''\n\n\n\n\n\n\n\n\n\n\n \n \n return pat(line)is not None\n \ndef IS_CHARACTER_JUNK(ch,ws=\" \\t\"):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n return ch in ws\n \n \n \n \n \n \ndef _format_range_unified(start,stop):\n ''\n \n beginning=start+1\n length=stop -start\n if length ==1:\n  return '{}'.format(beginning)\n if not length:\n  beginning -=1\n return '{},{}'.format(beginning,length)\n \ndef unified_diff(a,b,fromfile='',tofile='',fromfiledate='',\ntofiledate='',n=3,lineterm='\\n'):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n _check_types(a,b,fromfile,tofile,fromfiledate,tofiledate,lineterm)\n started=False\n for group in SequenceMatcher(None ,a,b).get_grouped_opcodes(n):\n  if not started:\n   started=True\n   fromdate='\\t{}'.format(fromfiledate)if fromfiledate else ''\n   todate='\\t{}'.format(tofiledate)if tofiledate else ''\n   yield '--- {}{}{}'.format(fromfile,fromdate,lineterm)\n   yield '+++ {}{}{}'.format(tofile,todate,lineterm)\n   \n  first,last=group[0],group[-1]\n  file1_range=_format_range_unified(first[1],last[2])\n  file2_range=_format_range_unified(first[3],last[4])\n  yield '@@ -{} +{} @@{}'.format(file1_range,file2_range,lineterm)\n  \n  for tag,i1,i2,j1,j2 in group:\n   if tag =='equal':\n    for line in a[i1:i2]:\n     yield ' '+line\n    continue\n   if tag in {'replace','delete'}:\n    for line in a[i1:i2]:\n     yield '-'+line\n   if tag in {'replace','insert'}:\n    for line in b[j1:j2]:\n     yield '+'+line\n     \n     \n     \n     \n     \n     \ndef _format_range_context(start,stop):\n ''\n \n beginning=start+1\n length=stop -start\n if not length:\n  beginning -=1\n if length <=1:\n  return '{}'.format(beginning)\n return '{},{}'.format(beginning,beginning+length -1)\n \n \ndef context_diff(a,b,fromfile='',tofile='',\nfromfiledate='',tofiledate='',n=3,lineterm='\\n'):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n _check_types(a,b,fromfile,tofile,fromfiledate,tofiledate,lineterm)\n prefix=dict(insert='+ ',delete='- ',replace='! ',equal='  ')\n started=False\n for group in SequenceMatcher(None ,a,b).get_grouped_opcodes(n):\n  if not started:\n   started=True\n   fromdate='\\t{}'.format(fromfiledate)if fromfiledate else ''\n   todate='\\t{}'.format(tofiledate)if tofiledate else ''\n   yield '*** {}{}{}'.format(fromfile,fromdate,lineterm)\n   yield '--- {}{}{}'.format(tofile,todate,lineterm)\n   \n  first,last=group[0],group[-1]\n  yield '***************'+lineterm\n  \n  file1_range=_format_range_context(first[1],last[2])\n  yield '*** {} ****{}'.format(file1_range,lineterm)\n  \n  if any(tag in {'replace','delete'}for tag,_,_,_,_ in group):\n   for tag,i1,i2,_,_ in group:\n    if tag !='insert':\n     for line in a[i1:i2]:\n      yield prefix[tag]+line\n      \n  file2_range=_format_range_context(first[3],last[4])\n  yield '--- {} ----{}'.format(file2_range,lineterm)\n  \n  if any(tag in {'replace','insert'}for tag,_,_,_,_ in group):\n   for tag,_,_,j1,j2 in group:\n    if tag !='delete':\n     for line in b[j1:j2]:\n      yield prefix[tag]+line\n      \ndef _check_types(a,b,*args):\n\n\n\n\n\n\n if a and not isinstance(a[0],str):\n  raise TypeError('lines to compare must be str, not %s (%r)'%\n  (type(a[0]).__name__,a[0]))\n if b and not isinstance(b[0],str):\n  raise TypeError('lines to compare must be str, not %s (%r)'%\n  (type(b[0]).__name__,b[0]))\n for arg in args:\n  if not isinstance(arg,str):\n   raise TypeError('all arguments must be str, not: %r'%(arg,))\n   \ndef diff_bytes(dfunc,a,b,fromfile=b'',tofile=b'',\nfromfiledate=b'',tofiledate=b'',n=3,lineterm=b'\\n'):\n ''\n\n\n\n\n\n\n\n \n def decode(s):\n  try :\n   return s.decode('ascii','surrogateescape')\n  except AttributeError as err:\n   msg=('all arguments must be bytes, not %s (%r)'%\n   (type(s).__name__,s))\n   raise TypeError(msg)from err\n a=list(map(decode,a))\n b=list(map(decode,b))\n fromfile=decode(fromfile)\n tofile=decode(tofile)\n fromfiledate=decode(fromfiledate)\n tofiledate=decode(tofiledate)\n lineterm=decode(lineterm)\n \n lines=dfunc(a,b,fromfile,tofile,fromfiledate,tofiledate,n,lineterm)\n for line in lines:\n  yield line.encode('ascii','surrogateescape')\n  \ndef ndiff(a,b,linejunk=None ,charjunk=IS_CHARACTER_JUNK):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n return Differ(linejunk,charjunk).compare(a,b)\n \ndef _mdiff(fromlines,tolines,context=None ,linejunk=None ,\ncharjunk=IS_CHARACTER_JUNK):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n import re\n \n \n change_re=re.compile(r'(\\++|\\-+|\\^+)')\n \n \n diff_lines_iterator=ndiff(fromlines,tolines,linejunk,charjunk)\n \n def _make_line(lines,format_key,side,num_lines=[0,0]):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  num_lines[side]+=1\n  \n  \n  if format_key is None :\n   return (num_lines[side],lines.pop(0)[2:])\n   \n  if format_key =='?':\n   text,markers=lines.pop(0),lines.pop(0)\n   \n   sub_info=[]\n   def record_sub_info(match_object,sub_info=sub_info):\n    sub_info.append([match_object.group(1)[0],match_object.span()])\n    return match_object.group(1)\n   change_re.sub(record_sub_info,markers)\n   \n   \n   for key,(begin,end)in reversed(sub_info):\n    text=text[0:begin]+'\\0'+key+text[begin:end]+'\\1'+text[end:]\n   text=text[2:]\n   \n  else :\n   text=lines.pop(0)[2:]\n   \n   \n   if not text:\n    text=' '\n    \n   text='\\0'+format_key+text+'\\1'\n   \n   \n   \n  return (num_lines[side],text)\n  \n def _line_iterator():\n  ''\n\n\n\n\n\n\n\n\n\n\n\n  \n  lines=[]\n  num_blanks_pending,num_blanks_to_yield=0,0\n  while True :\n  \n  \n  \n   while len(lines)<4:\n    lines.append(next(diff_lines_iterator,'X'))\n   s=''.join([line[0]for line in lines])\n   if s.startswith('X'):\n   \n   \n   \n    num_blanks_to_yield=num_blanks_pending\n   elif s.startswith('-?+?'):\n   \n    yield _make_line(lines,'?',0),_make_line(lines,'?',1),True\n    continue\n   elif s.startswith('--++'):\n   \n   \n    num_blanks_pending -=1\n    yield _make_line(lines,'-',0),None ,True\n    continue\n   elif s.startswith(('--?+','--+','- ')):\n   \n   \n    from_line,to_line=_make_line(lines,'-',0),None\n    num_blanks_to_yield,num_blanks_pending=num_blanks_pending -1,0\n   elif s.startswith('-+?'):\n   \n    yield _make_line(lines,None ,0),_make_line(lines,'?',1),True\n    continue\n   elif s.startswith('-?+'):\n   \n    yield _make_line(lines,'?',0),_make_line(lines,None ,1),True\n    continue\n   elif s.startswith('-'):\n   \n    num_blanks_pending -=1\n    yield _make_line(lines,'-',0),None ,True\n    continue\n   elif s.startswith('+--'):\n   \n   \n    num_blanks_pending +=1\n    yield None ,_make_line(lines,'+',1),True\n    continue\n   elif s.startswith(('+ ','+-')):\n   \n    from_line,to_line=None ,_make_line(lines,'+',1)\n    num_blanks_to_yield,num_blanks_pending=num_blanks_pending+1,0\n   elif s.startswith('+'):\n   \n    num_blanks_pending +=1\n    yield None ,_make_line(lines,'+',1),True\n    continue\n   elif s.startswith(' '):\n   \n    yield _make_line(lines[:],None ,0),_make_line(lines,None ,1),False\n    continue\n    \n    \n   while (num_blanks_to_yield <0):\n    num_blanks_to_yield +=1\n    yield None ,('','\\n'),True\n   while (num_blanks_to_yield >0):\n    num_blanks_to_yield -=1\n    yield ('','\\n'),None ,True\n   if s.startswith('X'):\n    return\n   else :\n    yield from_line,to_line,True\n    \n def _line_pair_iterator():\n  ''\n\n\n\n\n\n\n\n\n\n\n  \n  line_iterator=_line_iterator()\n  fromlines,tolines=[],[]\n  while True :\n  \n   while (len(fromlines)==0 or len(tolines)==0):\n    try :\n     from_line,to_line,found_diff=next(line_iterator)\n    except StopIteration:\n     return\n    if from_line is not None :\n     fromlines.append((from_line,found_diff))\n    if to_line is not None :\n     tolines.append((to_line,found_diff))\n     \n   from_line,fromDiff=fromlines.pop(0)\n   to_line,to_diff=tolines.pop(0)\n   yield (from_line,to_line,fromDiff or to_diff)\n   \n   \n   \n line_pair_iterator=_line_pair_iterator()\n if context is None :\n  yield from line_pair_iterator\n  \n  \n else :\n  context +=1\n  lines_to_write=0\n  while True :\n  \n  \n  \n   index,contextLines=0,[None ]*(context)\n   found_diff=False\n   while (found_diff is False ):\n    try :\n     from_line,to_line,found_diff=next(line_pair_iterator)\n    except StopIteration:\n     return\n    i=index %context\n    contextLines[i]=(from_line,to_line,found_diff)\n    index +=1\n    \n    \n   if index >context:\n    yield None ,None ,None\n    lines_to_write=context\n   else :\n    lines_to_write=index\n    index=0\n   while (lines_to_write):\n    i=index %context\n    index +=1\n    yield contextLines[i]\n    lines_to_write -=1\n    \n   lines_to_write=context -1\n   try :\n    while (lines_to_write):\n     from_line,to_line,found_diff=next(line_pair_iterator)\n     \n     if found_diff:\n      lines_to_write=context -1\n     else :\n      lines_to_write -=1\n     yield from_line,to_line,found_diff\n   except StopIteration:\n   \n    return\n    \n    \n_file_template=\"\"\"\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"\n          \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n\n<html>\n\n<head>\n    <meta http-equiv=\"Content-Type\"\n          content=\"text/html; charset=%(charset)s\" />\n    <title></title>\n    <style type=\"text/css\">%(styles)s\n    </style>\n</head>\n\n<body>\n    %(table)s%(legend)s\n</body>\n\n</html>\"\"\"\n\n_styles=\"\"\"\n        table.diff {font-family:Courier; border:medium;}\n        .diff_header {background-color:#e0e0e0}\n        td.diff_header {text-align:right}\n        .diff_next {background-color:#c0c0c0}\n        .diff_add {background-color:#aaffaa}\n        .diff_chg {background-color:#ffff77}\n        .diff_sub {background-color:#ffaaaa}\"\"\"\n\n_table_template=\"\"\"\n    <table class=\"diff\" id=\"difflib_chg_%(prefix)s_top\"\n           cellspacing=\"0\" cellpadding=\"0\" rules=\"groups\" >\n        <colgroup></colgroup> <colgroup></colgroup> <colgroup></colgroup>\n        <colgroup></colgroup> <colgroup></colgroup> <colgroup></colgroup>\n        %(header_row)s\n        <tbody>\n%(data_rows)s        </tbody>\n    </table>\"\"\"\n\n_legend=\"\"\"\n    <table class=\"diff\" summary=\"Legends\">\n        <tr> <th colspan=\"2\"> Legends </th> </tr>\n        <tr> <td> <table border=\"\" summary=\"Colors\">\n                      <tr><th> Colors </th> </tr>\n                      <tr><td class=\"diff_add\">&nbsp;Added&nbsp;</td></tr>\n                      <tr><td class=\"diff_chg\">Changed</td> </tr>\n                      <tr><td class=\"diff_sub\">Deleted</td> </tr>\n                  </table></td>\n             <td> <table border=\"\" summary=\"Links\">\n                      <tr><th colspan=\"2\"> Links </th> </tr>\n                      <tr><td>(f)irst change</td> </tr>\n                      <tr><td>(n)ext change</td> </tr>\n                      <tr><td>(t)op</td> </tr>\n                  </table></td> </tr>\n    </table>\"\"\"\n\nclass HtmlDiff(object):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n _file_template=_file_template\n _styles=_styles\n _table_template=_table_template\n _legend=_legend\n _default_prefix=0\n \n def __init__(self,tabsize=8,wrapcolumn=None ,linejunk=None ,\n charjunk=IS_CHARACTER_JUNK):\n  ''\n\n\n\n\n\n\n\n\n  \n  self._tabsize=tabsize\n  self._wrapcolumn=wrapcolumn\n  self._linejunk=linejunk\n  self._charjunk=charjunk\n  \n def make_file(self,fromlines,tolines,fromdesc='',todesc='',\n context=False ,numlines=5,*,charset='utf-8'):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  return (self._file_template %dict(\n  styles=self._styles,\n  legend=self._legend,\n  table=self.make_table(fromlines,tolines,fromdesc,todesc,\n  context=context,numlines=numlines),\n  charset=charset\n  )).encode(charset,'xmlcharrefreplace').decode(charset)\n  \n def _tab_newline_replace(self,fromlines,tolines):\n  ''\n\n\n\n\n\n\n\n  \n  def expand_tabs(line):\n  \n   line=line.replace(' ','\\0')\n   \n   line=line.expandtabs(self._tabsize)\n   \n   \n   line=line.replace(' ','\\t')\n   return line.replace('\\0',' ').rstrip('\\n')\n  fromlines=[expand_tabs(line)for line in fromlines]\n  tolines=[expand_tabs(line)for line in tolines]\n  return fromlines,tolines\n  \n def _split_line(self,data_list,line_num,text):\n  ''\n\n\n\n\n\n\n  \n  \n  if not line_num:\n   data_list.append((line_num,text))\n   return\n   \n   \n  size=len(text)\n  max=self._wrapcolumn\n  if (size <=max)or ((size -(text.count('\\0')*3))<=max):\n   data_list.append((line_num,text))\n   return\n   \n   \n   \n  i=0\n  n=0\n  mark=''\n  while n <max and i <size:\n   if text[i]=='\\0':\n    i +=1\n    mark=text[i]\n    i +=1\n   elif text[i]=='\\1':\n    i +=1\n    mark=''\n   else :\n    i +=1\n    n +=1\n    \n    \n  line1=text[:i]\n  line2=text[i:]\n  \n  \n  \n  \n  if mark:\n   line1=line1+'\\1'\n   line2='\\0'+mark+line2\n   \n   \n  data_list.append((line_num,line1))\n  \n  \n  self._split_line(data_list,'>',line2)\n  \n def _line_wrapper(self,diffs):\n  ''\n  \n  \n  for fromdata,todata,flag in diffs:\n  \n   if flag is None :\n    yield fromdata,todata,flag\n    continue\n   (fromline,fromtext),(toline,totext)=fromdata,todata\n   \n   \n   fromlist,tolist=[],[]\n   self._split_line(fromlist,fromline,fromtext)\n   self._split_line(tolist,toline,totext)\n   \n   \n   while fromlist or tolist:\n    if fromlist:\n     fromdata=fromlist.pop(0)\n    else :\n     fromdata=('',' ')\n    if tolist:\n     todata=tolist.pop(0)\n    else :\n     todata=('',' ')\n    yield fromdata,todata,flag\n    \n def _collect_lines(self,diffs):\n  ''\n\n\n\n  \n  \n  fromlist,tolist,flaglist=[],[],[]\n  \n  for fromdata,todata,flag in diffs:\n   try :\n   \n    fromlist.append(self._format_line(0,flag,*fromdata))\n    tolist.append(self._format_line(1,flag,*todata))\n   except TypeError:\n   \n    fromlist.append(None )\n    tolist.append(None )\n   flaglist.append(flag)\n  return fromlist,tolist,flaglist\n  \n def _format_line(self,side,flag,linenum,text):\n  ''\n\n\n\n\n\n  \n  try :\n   linenum='%d'%linenum\n   id=' id=\"%s%s\"'%(self._prefix[side],linenum)\n  except TypeError:\n  \n   id=''\n   \n  text=text.replace(\"&\",\"&amp;\").replace(\">\",\"&gt;\").replace(\"<\",\"&lt;\")\n  \n  \n  text=text.replace(' ','&nbsp;').rstrip()\n  \n  return '<td class=\"diff_header\"%s>%s</td><td nowrap=\"nowrap\">%s</td>'\\\n  %(id,linenum,text)\n  \n def _make_prefix(self):\n  ''\n  \n  \n  \n  fromprefix=\"from%d_\"%HtmlDiff._default_prefix\n  toprefix=\"to%d_\"%HtmlDiff._default_prefix\n  HtmlDiff._default_prefix +=1\n  \n  self._prefix=[fromprefix,toprefix]\n  \n def _convert_flags(self,fromlist,tolist,flaglist,context,numlines):\n  ''\n  \n  \n  toprefix=self._prefix[1]\n  \n  \n  next_id=['']*len(flaglist)\n  next_href=['']*len(flaglist)\n  num_chg,in_change=0,False\n  last=0\n  for i,flag in enumerate(flaglist):\n   if flag:\n    if not in_change:\n     in_change=True\n     last=i\n     \n     \n     \n     i=max([0,i -numlines])\n     next_id[i]=' id=\"difflib_chg_%s_%d\"'%(toprefix,num_chg)\n     \n     \n     num_chg +=1\n     next_href[last]='<a href=\"#difflib_chg_%s_%d\">n</a>'%(\n     toprefix,num_chg)\n   else :\n    in_change=False\n    \n  if not flaglist:\n   flaglist=[False ]\n   next_id=['']\n   next_href=['']\n   last=0\n   if context:\n    fromlist=['<td></td><td>&nbsp;No Differences Found&nbsp;</td>']\n    tolist=fromlist\n   else :\n    fromlist=tolist=['<td></td><td>&nbsp;Empty File&nbsp;</td>']\n    \n  if not flaglist[0]:\n   next_href[0]='<a href=\"#difflib_chg_%s_0\">f</a>'%toprefix\n   \n  next_href[last]='<a href=\"#difflib_chg_%s_top\">t</a>'%(toprefix)\n  \n  return fromlist,tolist,flaglist,next_href,next_id\n  \n def make_table(self,fromlines,tolines,fromdesc='',todesc='',context=False ,\n numlines=5):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  \n  \n  self._make_prefix()\n  \n  \n  \n  fromlines,tolines=self._tab_newline_replace(fromlines,tolines)\n  \n  \n  if context:\n   context_lines=numlines\n  else :\n   context_lines=None\n  diffs=_mdiff(fromlines,tolines,context_lines,linejunk=self._linejunk,\n  charjunk=self._charjunk)\n  \n  \n  if self._wrapcolumn:\n   diffs=self._line_wrapper(diffs)\n   \n   \n  fromlist,tolist,flaglist=self._collect_lines(diffs)\n  \n  \n  fromlist,tolist,flaglist,next_href,next_id=self._convert_flags(\n  fromlist,tolist,flaglist,context,numlines)\n  \n  s=[]\n  fmt='            <tr><td class=\"diff_next\"%s>%s</td>%s'+\\\n  '<td class=\"diff_next\">%s</td>%s</tr>\\n'\n  for i in range(len(flaglist)):\n   if flaglist[i]is None :\n   \n   \n    if i >0:\n     s.append('        </tbody>        \\n        <tbody>\\n')\n   else :\n    s.append(fmt %(next_id[i],next_href[i],fromlist[i],\n    next_href[i],tolist[i]))\n  if fromdesc or todesc:\n   header_row='<thead><tr>%s%s%s%s</tr></thead>'%(\n   '<th class=\"diff_next\"><br /></th>',\n   '<th colspan=\"2\" class=\"diff_header\">%s</th>'%fromdesc,\n   '<th class=\"diff_next\"><br /></th>',\n   '<th colspan=\"2\" class=\"diff_header\">%s</th>'%todesc)\n  else :\n   header_row=''\n   \n  table=self._table_template %dict(\n  data_rows=''.join(s),\n  header_row=header_row,\n  prefix=self._prefix[1])\n  \n  return table.replace('\\0+','<span class=\"diff_add\">').\\\n  replace('\\0-','<span class=\"diff_sub\">').\\\n  replace('\\0^','<span class=\"diff_chg\">').\\\n  replace('\\1','</span>').\\\n  replace('\\t','&nbsp;')\n  \ndel re\n\ndef restore(delta,which):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n try :\n  tag={1:\"- \",2:\"+ \"}[int(which)]\n except KeyError:\n  raise ValueError('unknown delta choice (must be 1 or 2): %r'\n  %which)from None\n prefixes=(\"  \",tag)\n for line in delta:\n  if line[:2]in prefixes:\n   yield line[2:]\n   \ndef _test():\n import doctest,difflib\n return doctest.testmod(difflib)\n \nif __name__ ==\"__main__\":\n _test()\n", ["collections", "difflib", "doctest", "heapq", "re", "types"]], "doctest": [".py", "\n\n\n\n\n\n\n\nr\"\"\"Module doctest -- a framework for running examples in docstrings.\n\nIn simplest use, end each module M to be tested with:\n\ndef _test():\n    import doctest\n    doctest.testmod()\n\nif __name__ == \"__main__\":\n    _test()\n\nThen running the module as a script will cause the examples in the\ndocstrings to get executed and verified:\n\npython M.py\n\nThis won't display anything unless an example fails, in which case the\nfailing example(s) and the cause(s) of the failure(s) are printed to stdout\n(why not stderr? because stderr is a lame hack <0.2 wink>), and the final\nline of output is \"Test failed.\".\n\nRun it with the -v switch instead:\n\npython M.py -v\n\nand a detailed report of all examples tried is printed to stdout, along\nwith assorted summaries at the end.\n\nYou can force verbose mode by passing \"verbose=True\" to testmod, or prohibit\nit by passing \"verbose=False\".  In either of those cases, sys.argv is not\nexamined by testmod.\n\nThere are a variety of other ways to run doctests, including integration\nwith the unittest framework, and support for running non-Python text\nfiles containing doctests.  There are also many ways to override parts\nof doctest's default behaviors.  See the Library Reference Manual for\ndetails.\n\"\"\"\n\n__docformat__='reStructuredText en'\n\n__all__=[\n\n'register_optionflag',\n'DONT_ACCEPT_TRUE_FOR_1',\n'DONT_ACCEPT_BLANKLINE',\n'NORMALIZE_WHITESPACE',\n'ELLIPSIS',\n'SKIP',\n'IGNORE_EXCEPTION_DETAIL',\n'COMPARISON_FLAGS',\n'REPORT_UDIFF',\n'REPORT_CDIFF',\n'REPORT_NDIFF',\n'REPORT_ONLY_FIRST_FAILURE',\n'REPORTING_FLAGS',\n'FAIL_FAST',\n\n\n'Example',\n'DocTest',\n\n'DocTestParser',\n\n'DocTestFinder',\n\n'DocTestRunner',\n'OutputChecker',\n'DocTestFailure',\n'UnexpectedException',\n'DebugRunner',\n\n'testmod',\n'testfile',\n'run_docstring_examples',\n\n'DocTestSuite',\n'DocFileSuite',\n'set_unittest_reportflags',\n\n'script_from_examples',\n'testsource',\n'debug_src',\n'debug',\n]\n\nimport __future__\nimport difflib\nimport inspect\nimport linecache\nimport os\nimport pdb\nimport re\nimport sys\nimport traceback\nimport unittest\nfrom io import StringIO,IncrementalNewlineDecoder\nfrom collections import namedtuple\n\nTestResults=namedtuple('TestResults','failed attempted')\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nOPTIONFLAGS_BY_NAME={}\ndef register_optionflag(name):\n\n return OPTIONFLAGS_BY_NAME.setdefault(name,1 <<len(OPTIONFLAGS_BY_NAME))\n \nDONT_ACCEPT_TRUE_FOR_1=register_optionflag('DONT_ACCEPT_TRUE_FOR_1')\nDONT_ACCEPT_BLANKLINE=register_optionflag('DONT_ACCEPT_BLANKLINE')\nNORMALIZE_WHITESPACE=register_optionflag('NORMALIZE_WHITESPACE')\nELLIPSIS=register_optionflag('ELLIPSIS')\nSKIP=register_optionflag('SKIP')\nIGNORE_EXCEPTION_DETAIL=register_optionflag('IGNORE_EXCEPTION_DETAIL')\n\nCOMPARISON_FLAGS=(DONT_ACCEPT_TRUE_FOR_1 |\nDONT_ACCEPT_BLANKLINE |\nNORMALIZE_WHITESPACE |\nELLIPSIS |\nSKIP |\nIGNORE_EXCEPTION_DETAIL)\n\nREPORT_UDIFF=register_optionflag('REPORT_UDIFF')\nREPORT_CDIFF=register_optionflag('REPORT_CDIFF')\nREPORT_NDIFF=register_optionflag('REPORT_NDIFF')\nREPORT_ONLY_FIRST_FAILURE=register_optionflag('REPORT_ONLY_FIRST_FAILURE')\nFAIL_FAST=register_optionflag('FAIL_FAST')\n\nREPORTING_FLAGS=(REPORT_UDIFF |\nREPORT_CDIFF |\nREPORT_NDIFF |\nREPORT_ONLY_FIRST_FAILURE |\nFAIL_FAST)\n\n\nBLANKLINE_MARKER='<BLANKLINE>'\nELLIPSIS_MARKER='...'\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\ndef _extract_future_flags(globs):\n ''\n\n\n \n flags=0\n for fname in __future__.all_feature_names:\n  feature=globs.get(fname,None )\n  if feature is getattr(__future__,fname):\n   flags |=feature.compiler_flag\n return flags\n \ndef _normalize_module(module,depth=2):\n ''\n\n\n\n\n\n\n\n \n if inspect.ismodule(module):\n  return module\n elif isinstance(module,str):\n  return __import__(module,globals(),locals(),[\"*\"])\n elif module is None :\n  return sys.modules[sys._getframe(depth).f_globals['__name__']]\n else :\n  raise TypeError(\"Expected a module, string, or None\")\n  \ndef _newline_convert(data):\n\n return IncrementalNewlineDecoder(None ,True ).decode(data,True )\n \ndef _load_testfile(filename,package,module_relative,encoding):\n if module_relative:\n  package=_normalize_module(package,3)\n  filename=_module_relative_path(package,filename)\n  if (loader :=getattr(package,'__loader__',None ))is None :\n   try :\n    loader=package.__spec__.loader\n   except AttributeError:\n    pass\n  if hasattr(loader,'get_data'):\n   file_contents=loader.get_data(filename)\n   file_contents=file_contents.decode(encoding)\n   \n   \n   return _newline_convert(file_contents),filename\n with open(filename,encoding=encoding)as f:\n  return f.read(),filename\n  \ndef _indent(s,indent=4):\n ''\n\n\n \n \n return re.sub('(?m)^(?!$)',indent *' ',s)\n \ndef _exception_traceback(exc_info):\n ''\n\n\n \n \n excout=StringIO()\n exc_type,exc_val,exc_tb=exc_info\n traceback.print_exception(exc_type,exc_val,exc_tb,file=excout)\n return excout.getvalue()\n \n \nclass _SpoofOut(StringIO):\n def getvalue(self):\n  result=StringIO.getvalue(self)\n  \n  \n  \n  if result and not result.endswith(\"\\n\"):\n   result +=\"\\n\"\n  return result\n  \n def truncate(self,size=None ):\n  self.seek(size)\n  StringIO.truncate(self)\n  \n  \ndef _ellipsis_match(want,got):\n ''\n\n\n\n \n if ELLIPSIS_MARKER not in want:\n  return want ==got\n  \n  \n ws=want.split(ELLIPSIS_MARKER)\n assert len(ws)>=2\n \n \n startpos,endpos=0,len(got)\n w=ws[0]\n if w:\n  if got.startswith(w):\n   startpos=len(w)\n   del ws[0]\n  else :\n   return False\n w=ws[-1]\n if w:\n  if got.endswith(w):\n   endpos -=len(w)\n   del ws[-1]\n  else :\n   return False\n   \n if startpos >endpos:\n \n \n  return False\n  \n  \n  \n  \n for w in ws:\n \n \n \n  startpos=got.find(w,startpos,endpos)\n  if startpos <0:\n   return False\n  startpos +=len(w)\n  \n return True\n \ndef _comment_line(line):\n ''\n line=line.rstrip()\n if line:\n  return '# '+line\n else :\n  return '#'\n  \ndef _strip_exception_details(msg):\n\n\n\n\n\n\n\n\n\n\n start,end=0,len(msg)\n \n i=msg.find(\"\\n\")\n if i >=0:\n  end=i\n  \n i=msg.find(':',0,end)\n if i >=0:\n  end=i\n  \n i=msg.rfind('.',0,end)\n if i >=0:\n  start=i+1\n return msg[start:end]\n \nclass _OutputRedirectingPdb(pdb.Pdb):\n ''\n\n\n\n \n def __init__(self,out):\n  self.__out=out\n  self.__debugger_used=False\n  \n  pdb.Pdb.__init__(self,stdout=out,nosigint=True )\n  \n  self.use_rawinput=1\n  \n def set_trace(self,frame=None ):\n  self.__debugger_used=True\n  if frame is None :\n   frame=sys._getframe().f_back\n  pdb.Pdb.set_trace(self,frame)\n  \n def set_continue(self):\n \n \n  if self.__debugger_used:\n   pdb.Pdb.set_continue(self)\n   \n def trace_dispatch(self,*args):\n \n  save_stdout=sys.stdout\n  sys.stdout=self.__out\n  \n  try :\n   return pdb.Pdb.trace_dispatch(self,*args)\n  finally :\n   sys.stdout=save_stdout\n   \n   \ndef _module_relative_path(module,test_path):\n if not inspect.ismodule(module):\n  raise TypeError('Expected a module: %r'%module)\n if test_path.startswith('/'):\n  raise ValueError('Module-relative files may not have absolute paths')\n  \n  \n test_path=os.path.join(*(test_path.split('/')))\n \n \n if hasattr(module,'__file__'):\n \n  basedir=os.path.split(module.__file__)[0]\n elif module.__name__ =='__main__':\n \n  if len(sys.argv)>0 and sys.argv[0]!='':\n   basedir=os.path.split(sys.argv[0])[0]\n  else :\n   basedir=os.curdir\n else :\n  if hasattr(module,'__path__'):\n   for directory in module.__path__:\n    fullpath=os.path.join(directory,test_path)\n    if os.path.exists(fullpath):\n     return fullpath\n     \n     \n  raise ValueError(\"Can't resolve paths relative to the module \"\n  \"%r (it has no __file__)\"\n  %module.__name__)\n  \n  \n return os.path.join(basedir,test_path)\n \n \n \n \n \n \n \n \n \n \n \n \n \nclass Example:\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n def __init__(self,source,want,exc_msg=None ,lineno=0,indent=0,\n options=None ):\n \n  if not source.endswith('\\n'):\n   source +='\\n'\n  if want and not want.endswith('\\n'):\n   want +='\\n'\n  if exc_msg is not None and not exc_msg.endswith('\\n'):\n   exc_msg +='\\n'\n   \n  self.source=source\n  self.want=want\n  self.lineno=lineno\n  self.indent=indent\n  if options is None :options={}\n  self.options=options\n  self.exc_msg=exc_msg\n  \n def __eq__(self,other):\n  if type(self)is not type(other):\n   return NotImplemented\n   \n  return self.source ==other.source and\\\n  self.want ==other.want and\\\n  self.lineno ==other.lineno and\\\n  self.indent ==other.indent and\\\n  self.options ==other.options and\\\n  self.exc_msg ==other.exc_msg\n  \n def __hash__(self):\n  return hash((self.source,self.want,self.lineno,self.indent,\n  self.exc_msg))\n  \nclass DocTest:\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n def __init__(self,examples,globs,name,filename,lineno,docstring):\n  ''\n\n\n  \n  assert not isinstance(examples,str),\\\n  \"DocTest no longer accepts str; use DocTestParser instead\"\n  self.examples=examples\n  self.docstring=docstring\n  self.globs=globs.copy()\n  self.name=name\n  self.filename=filename\n  self.lineno=lineno\n  \n def __repr__(self):\n  if len(self.examples)==0:\n   examples='no examples'\n  elif len(self.examples)==1:\n   examples='1 example'\n  else :\n   examples='%d examples'%len(self.examples)\n  return ('<%s %s from %s:%s (%s)>'%\n  (self.__class__.__name__,\n  self.name,self.filename,self.lineno,examples))\n  \n def __eq__(self,other):\n  if type(self)is not type(other):\n   return NotImplemented\n   \n  return self.examples ==other.examples and\\\n  self.docstring ==other.docstring and\\\n  self.globs ==other.globs and\\\n  self.name ==other.name and\\\n  self.filename ==other.filename and\\\n  self.lineno ==other.lineno\n  \n def __hash__(self):\n  return hash((self.docstring,self.name,self.filename,self.lineno))\n  \n  \n def __lt__(self,other):\n  if not isinstance(other,DocTest):\n   return NotImplemented\n  return ((self.name,self.filename,self.lineno,id(self))\n  <\n  (other.name,other.filename,other.lineno,id(other)))\n  \n  \n  \n  \n  \nclass DocTestParser:\n ''\n\n \n \n \n \n \n \n _EXAMPLE_RE=re.compile(r'''\n        # Source consists of a PS1 line followed by zero or more PS2 lines.\n        (?P<source>\n            (?:^(?P<indent> [ ]*) >>>    .*)    # PS1 line\n            (?:\\n           [ ]*  \\.\\.\\. .*)*)  # PS2 lines\n        \\n?\n        # Want consists of any non-blank lines that do not start with PS1.\n        (?P<want> (?:(?![ ]*$)    # Not a blank line\n                     (?![ ]*>>>)  # Not a line starting with PS1\n                     .+$\\n?       # But any other line\n                  )*)\n        ''',re.MULTILINE |re.VERBOSE)\n \n \n \n \n \n \n \n \n \n \n _EXCEPTION_RE=re.compile(r\"\"\"\n        # Grab the traceback header.  Different versions of Python have\n        # said different things on the first traceback line.\n        ^(?P<hdr> Traceback\\ \\(\n            (?: most\\ recent\\ call\\ last\n            |   innermost\\ last\n            ) \\) :\n        )\n        \\s* $                # toss trailing whitespace on the header.\n        (?P<stack> .*?)      # don't blink: absorb stuff until...\n        ^ (?P<msg> \\w+ .*)   #     a line *starts* with alphanum.\n        \"\"\",re.VERBOSE |re.MULTILINE |re.DOTALL)\n \n \n \n _IS_BLANK_OR_COMMENT=re.compile(r'^[ ]*(#.*)?$').match\n \n def parse(self,string,name='<string>'):\n  ''\n\n\n\n\n\n  \n  string=string.expandtabs()\n  \n  min_indent=self._min_indent(string)\n  if min_indent >0:\n   string='\\n'.join([l[min_indent:]for l in string.split('\\n')])\n   \n  output=[]\n  charno,lineno=0,0\n  \n  for m in self._EXAMPLE_RE.finditer(string):\n  \n   output.append(string[charno:m.start()])\n   \n   lineno +=string.count('\\n',charno,m.start())\n   \n   (source,options,want,exc_msg)=\\\n   self._parse_example(m,name,lineno)\n   \n   if not self._IS_BLANK_OR_COMMENT(source):\n    output.append(Example(source,want,exc_msg,\n    lineno=lineno,\n    indent=min_indent+len(m.group('indent')),\n    options=options))\n    \n   lineno +=string.count('\\n',m.start(),m.end())\n   \n   charno=m.end()\n   \n  output.append(string[charno:])\n  return output\n  \n def get_doctest(self,string,globs,name,filename,lineno):\n  ''\n\n\n\n\n\n\n  \n  return DocTest(self.get_examples(string,name),globs,\n  name,filename,lineno,string)\n  \n def get_examples(self,string,name='<string>'):\n  ''\n\n\n\n\n\n\n\n\n  \n  return [x for x in self.parse(string,name)\n  if isinstance(x,Example)]\n  \n def _parse_example(self,m,name,lineno):\n  ''\n\n\n\n\n\n\n\n\n  \n  \n  indent=len(m.group('indent'))\n  \n  \n  \n  source_lines=m.group('source').split('\\n')\n  self._check_prompt_blank(source_lines,indent,name,lineno)\n  self._check_prefix(source_lines[1:],' '*indent+'.',name,lineno)\n  source='\\n'.join([sl[indent+4:]for sl in source_lines])\n  \n  \n  \n  \n  want=m.group('want')\n  want_lines=want.split('\\n')\n  if len(want_lines)>1 and re.match(r' *$',want_lines[-1]):\n   del want_lines[-1]\n  self._check_prefix(want_lines,' '*indent,name,\n  lineno+len(source_lines))\n  want='\\n'.join([wl[indent:]for wl in want_lines])\n  \n  \n  m=self._EXCEPTION_RE.match(want)\n  if m:\n   exc_msg=m.group('msg')\n  else :\n   exc_msg=None\n   \n   \n  options=self._find_options(source,name,lineno)\n  \n  return source,options,want,exc_msg\n  \n  \n  \n  \n  \n  \n  \n  \n _OPTION_DIRECTIVE_RE=re.compile(r'#\\s*doctest:\\s*([^\\n\\'\"]*)$',\n re.MULTILINE)\n \n def _find_options(self,source,name,lineno):\n  ''\n\n\n\n\n\n  \n  options={}\n  \n  for m in self._OPTION_DIRECTIVE_RE.finditer(source):\n   option_strings=m.group(1).replace(',',' ').split()\n   for option in option_strings:\n    if (option[0]not in '+-'or\n    option[1:]not in OPTIONFLAGS_BY_NAME):\n     raise ValueError('line %r of the doctest for %s '\n     'has an invalid option: %r'%\n     (lineno+1,name,option))\n    flag=OPTIONFLAGS_BY_NAME[option[1:]]\n    options[flag]=(option[0]=='+')\n  if options and self._IS_BLANK_OR_COMMENT(source):\n   raise ValueError('line %r of the doctest for %s has an option '\n   'directive on a line with no example: %r'%\n   (lineno,name,source))\n  return options\n  \n  \n  \n _INDENT_RE=re.compile(r'^([ ]*)(?=\\S)',re.MULTILINE)\n \n def _min_indent(self,s):\n  ''\n  indents=[len(indent)for indent in self._INDENT_RE.findall(s)]\n  if len(indents)>0:\n   return min(indents)\n  else :\n   return 0\n   \n def _check_prompt_blank(self,lines,indent,name,lineno):\n  ''\n\n\n\n\n  \n  for i,line in enumerate(lines):\n   if len(line)>=indent+4 and line[indent+3]!=' ':\n    raise ValueError('line %r of the docstring for %s '\n    'lacks blank after %s: %r'%\n    (lineno+i+1,name,\n    line[indent:indent+3],line))\n    \n def _check_prefix(self,lines,prefix,name,lineno):\n  ''\n\n\n  \n  for i,line in enumerate(lines):\n   if line and not line.startswith(prefix):\n    raise ValueError('line %r of the docstring for %s has '\n    'inconsistent leading whitespace: %r'%\n    (lineno+i+1,name,line))\n    \n    \n    \n    \n    \n    \nclass DocTestFinder:\n ''\n\n\n\n\n\n \n \n def __init__(self,verbose=False ,parser=DocTestParser(),\n recurse=True ,exclude_empty=True ):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  self._parser=parser\n  self._verbose=verbose\n  self._recurse=recurse\n  self._exclude_empty=exclude_empty\n  \n def find(self,obj,name=None ,module=None ,globs=None ,extraglobs=None ):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  if name is None :\n   name=getattr(obj,'__name__',None )\n   if name is None :\n    raise ValueError(\"DocTestFinder.find: name must be given \"\n    \"when obj.__name__ doesn't exist: %r\"%\n    (type(obj),))\n    \n    \n    \n    \n  if module is False :\n   module=None\n  elif module is None :\n   module=inspect.getmodule(obj)\n   \n   \n   \n   \n  try :\n   file=inspect.getsourcefile(obj)\n  except TypeError:\n   source_lines=None\n  else :\n   if not file:\n   \n   \n    file=inspect.getfile(obj)\n    if not file[0]+file[-2:]=='<]>':file=None\n   if file is None :\n    source_lines=None\n   else :\n    if module is not None :\n    \n    \n    \n     source_lines=linecache.getlines(file,module.__dict__)\n    else :\n    \n    \n     source_lines=linecache.getlines(file)\n    if not source_lines:\n     source_lines=None\n     \n     \n  if globs is None :\n   if module is None :\n    globs={}\n   else :\n    globs=module.__dict__.copy()\n  else :\n   globs=globs.copy()\n  if extraglobs is not None :\n   globs.update(extraglobs)\n  if '__name__'not in globs:\n   globs['__name__']='__main__'\n   \n   \n  tests=[]\n  self._find(tests,obj,name,module,source_lines,globs,{})\n  \n  \n  \n  \n  tests.sort()\n  return tests\n  \n def _from_module(self,module,object):\n  ''\n\n\n  \n  if module is None :\n   return True\n  elif inspect.getmodule(object)is not None :\n   return module is inspect.getmodule(object)\n  elif inspect.isfunction(object):\n   return module.__dict__ is object.__globals__\n  elif inspect.ismethoddescriptor(object):\n   if hasattr(object,'__objclass__'):\n    obj_mod=object.__objclass__.__module__\n   elif hasattr(object,'__module__'):\n    obj_mod=object.__module__\n   else :\n    return True\n   return module.__name__ ==obj_mod\n  elif inspect.isclass(object):\n   return module.__name__ ==object.__module__\n  elif hasattr(object,'__module__'):\n   return module.__name__ ==object.__module__\n  elif isinstance(object,property):\n   return True\n  else :\n   raise ValueError(\"object must be a class or function\")\n   \n def _is_routine(self,obj):\n  ''\n\n  \n  maybe_routine=obj\n  try :\n   maybe_routine=inspect.unwrap(maybe_routine)\n  except ValueError:\n   pass\n  return inspect.isroutine(maybe_routine)\n  \n def _find(self,tests,obj,name,module,source_lines,globs,seen):\n  ''\n\n\n  \n  if self._verbose:\n   print('Finding tests in %s'%name)\n   \n   \n  if id(obj)in seen:\n   return\n  seen[id(obj)]=1\n  \n  \n  test=self._get_test(obj,name,module,globs,source_lines)\n  if test is not None :\n   tests.append(test)\n   \n   \n  if inspect.ismodule(obj)and self._recurse:\n   for valname,val in obj.__dict__.items():\n    valname='%s.%s'%(name,valname)\n    \n    \n    if ((self._is_routine(val)or inspect.isclass(val))and\n    self._from_module(module,val)):\n     self._find(tests,val,valname,module,source_lines,\n     globs,seen)\n     \n     \n  if inspect.ismodule(obj)and self._recurse:\n   for valname,val in getattr(obj,'__test__',{}).items():\n    if not isinstance(valname,str):\n     raise ValueError(\"DocTestFinder.find: __test__ keys \"\n     \"must be strings: %r\"%\n     (type(valname),))\n    if not (inspect.isroutine(val)or inspect.isclass(val)or\n    inspect.ismodule(val)or isinstance(val,str)):\n     raise ValueError(\"DocTestFinder.find: __test__ values \"\n     \"must be strings, functions, methods, \"\n     \"classes, or modules: %r\"%\n     (type(val),))\n    valname='%s.__test__.%s'%(name,valname)\n    self._find(tests,val,valname,module,source_lines,\n    globs,seen)\n    \n    \n  if inspect.isclass(obj)and self._recurse:\n   for valname,val in obj.__dict__.items():\n   \n    if isinstance(val,staticmethod):\n     val=getattr(obj,valname)\n    if isinstance(val,classmethod):\n     val=getattr(obj,valname).__func__\n     \n     \n    if ((inspect.isroutine(val)or inspect.isclass(val)or\n    isinstance(val,property))and\n    self._from_module(module,val)):\n     valname='%s.%s'%(name,valname)\n     self._find(tests,val,valname,module,source_lines,\n     globs,seen)\n     \n def _get_test(self,obj,name,module,globs,source_lines):\n  ''\n\n\n  \n  \n  \n  if isinstance(obj,str):\n   docstring=obj\n  else :\n   try :\n    if obj.__doc__ is None :\n     docstring=''\n    else :\n     docstring=obj.__doc__\n     if not isinstance(docstring,str):\n      docstring=str(docstring)\n   except (TypeError,AttributeError):\n    docstring=''\n    \n    \n  lineno=self._find_lineno(obj,source_lines)\n  \n  \n  if self._exclude_empty and not docstring:\n   return None\n   \n   \n  if module is None :\n   filename=None\n  else :\n  \n   filename=getattr(module,'__file__',None )or module.__name__\n   if filename[-4:]==\".pyc\":\n    filename=filename[:-1]\n  return self._parser.get_doctest(docstring,globs,name,\n  filename,lineno)\n  \n def _find_lineno(self,obj,source_lines):\n  ''\n\n\n  \n  lineno=None\n  \n  \n  if inspect.ismodule(obj):\n   lineno=0\n   \n   \n   \n   \n  if inspect.isclass(obj):\n   if source_lines is None :\n    return None\n   pat=re.compile(r'^\\s*class\\s*%s\\b'%\n   getattr(obj,'__name__','-'))\n   for i,line in enumerate(source_lines):\n    if pat.match(line):\n     lineno=i\n     break\n     \n     \n  if inspect.ismethod(obj):obj=obj.__func__\n  if inspect.isfunction(obj):obj=obj.__code__\n  if inspect.istraceback(obj):obj=obj.tb_frame\n  if inspect.isframe(obj):obj=obj.f_code\n  if inspect.iscode(obj):\n   lineno=getattr(obj,'co_firstlineno',None )-1\n   \n   \n   \n   \n   \n   \n  if lineno is not None :\n   if source_lines is None :\n    return lineno+1\n   pat=re.compile(r'(^|.*:)\\s*\\w*(\"|\\')')\n   for lineno in range(lineno,len(source_lines)):\n    if pat.match(source_lines[lineno]):\n     return lineno\n     \n     \n  return None\n  \n  \n  \n  \n  \nclass DocTestRunner:\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n \n DIVIDER=\"*\"*70\n \n def __init__(self,checker=None ,verbose=None ,optionflags=0):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  self._checker=checker or OutputChecker()\n  if verbose is None :\n   verbose='-v'in sys.argv\n  self._verbose=verbose\n  self.optionflags=optionflags\n  self.original_optionflags=optionflags\n  \n  \n  self.tries=0\n  self.failures=0\n  self._name2ft={}\n  \n  \n  self._fakeout=_SpoofOut()\n  \n  \n  \n  \n  \n def report_start(self,out,test,example):\n  ''\n\n\n  \n  if self._verbose:\n   if example.want:\n    out('Trying:\\n'+_indent(example.source)+\n    'Expecting:\\n'+_indent(example.want))\n   else :\n    out('Trying:\\n'+_indent(example.source)+\n    'Expecting nothing\\n')\n    \n def report_success(self,out,test,example,got):\n  ''\n\n\n  \n  if self._verbose:\n   out(\"ok\\n\")\n   \n def report_failure(self,out,test,example,got):\n  ''\n\n  \n  out(self._failure_header(test,example)+\n  self._checker.output_difference(example,got,self.optionflags))\n  \n def report_unexpected_exception(self,out,test,example,exc_info):\n  ''\n\n  \n  out(self._failure_header(test,example)+\n  'Exception raised:\\n'+_indent(_exception_traceback(exc_info)))\n  \n def _failure_header(self,test,example):\n  out=[self.DIVIDER]\n  if test.filename:\n   if test.lineno is not None and example.lineno is not None :\n    lineno=test.lineno+example.lineno+1\n   else :\n    lineno='?'\n   out.append('File \"%s\", line %s, in %s'%\n   (test.filename,lineno,test.name))\n  else :\n   out.append('Line %s, in %s'%(example.lineno+1,test.name))\n  out.append('Failed example:')\n  source=example.source\n  out.append(_indent(source))\n  return '\\n'.join(out)\n  \n  \n  \n  \n  \n def __run(self,test,compileflags,out):\n  ''\n\n\n\n\n\n\n\n  \n  \n  failures=tries=0\n  \n  \n  \n  original_optionflags=self.optionflags\n  \n  SUCCESS,FAILURE,BOOM=range(3)\n  \n  check=self._checker.check_output\n  \n  \n  for examplenum,example in enumerate(test.examples):\n  \n  \n  \n   quiet=(self.optionflags&REPORT_ONLY_FIRST_FAILURE and\n   failures >0)\n   \n   \n   self.optionflags=original_optionflags\n   if example.options:\n    for (optionflag,val)in example.options.items():\n     if val:\n      self.optionflags |=optionflag\n     else :\n      self.optionflags &=~optionflag\n      \n      \n   if self.optionflags&SKIP:\n    continue\n    \n    \n   tries +=1\n   if not quiet:\n    self.report_start(out,test,example)\n    \n    \n    \n    \n   filename='<doctest %s[%d]>'%(test.name,examplenum)\n   \n   \n   \n   \n   try :\n   \n    exec(compile(example.source,filename,\"single\",\n    compileflags,True ),test.globs)\n    self.debugger.set_continue()\n    exception=None\n   except KeyboardInterrupt:\n    raise\n   except :\n    exception=sys.exc_info()\n    self.debugger.set_continue()\n    \n   got=self._fakeout.getvalue()\n   self._fakeout.truncate(0)\n   outcome=FAILURE\n   \n   \n   \n   if exception is None :\n    if check(example.want,got,self.optionflags):\n     outcome=SUCCESS\n     \n     \n   else :\n    exc_msg=traceback.format_exception_only(*exception[:2])[-1]\n    if not quiet:\n     got +=_exception_traceback(exception)\n     \n     \n     \n    if example.exc_msg is None :\n     outcome=BOOM\n     \n     \n    elif check(example.exc_msg,exc_msg,self.optionflags):\n     outcome=SUCCESS\n     \n     \n    elif self.optionflags&IGNORE_EXCEPTION_DETAIL:\n     if check(_strip_exception_details(example.exc_msg),\n     _strip_exception_details(exc_msg),\n     self.optionflags):\n      outcome=SUCCESS\n      \n      \n   if outcome is SUCCESS:\n    if not quiet:\n     self.report_success(out,test,example,got)\n   elif outcome is FAILURE:\n    if not quiet:\n     self.report_failure(out,test,example,got)\n    failures +=1\n   elif outcome is BOOM:\n    if not quiet:\n     self.report_unexpected_exception(out,test,example,\n     exception)\n    failures +=1\n   else :\n    assert False ,(\"unknown outcome\",outcome)\n    \n   if failures and self.optionflags&FAIL_FAST:\n    break\n    \n    \n  self.optionflags=original_optionflags\n  \n  \n  self.__record_outcome(test,failures,tries)\n  return TestResults(failures,tries)\n  \n def __record_outcome(self,test,f,t):\n  ''\n\n\n  \n  f2,t2=self._name2ft.get(test.name,(0,0))\n  self._name2ft[test.name]=(f+f2,t+t2)\n  self.failures +=f\n  self.tries +=t\n  \n __LINECACHE_FILENAME_RE=re.compile(r'<doctest '\n r'(?P<name>.+)'\n r'\\[(?P<examplenum>\\d+)\\]>$')\n def __patched_linecache_getlines(self,filename,module_globals=None ):\n  m=self.__LINECACHE_FILENAME_RE.match(filename)\n  if m and m.group('name')==self.test.name:\n   example=self.test.examples[int(m.group('examplenum'))]\n   return example.source.splitlines(keepends=True )\n  else :\n   return self.save_linecache_getlines(filename,module_globals)\n   \n def run(self,test,compileflags=None ,out=None ,clear_globs=True ):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  self.test=test\n  \n  if compileflags is None :\n   compileflags=_extract_future_flags(test.globs)\n   \n  save_stdout=sys.stdout\n  if out is None :\n   encoding=save_stdout.encoding\n   if encoding is None or encoding.lower()=='utf-8':\n    out=save_stdout.write\n   else :\n   \n    def out(s):\n     s=str(s.encode(encoding,'backslashreplace'),encoding)\n     save_stdout.write(s)\n  sys.stdout=self._fakeout\n  \n  \n  \n  \n  \n  \n  save_trace=sys.gettrace()\n  save_set_trace=pdb.set_trace\n  self.debugger=_OutputRedirectingPdb(save_stdout)\n  self.debugger.reset()\n  pdb.set_trace=self.debugger.set_trace\n  \n  \n  \n  self.save_linecache_getlines=linecache.getlines\n  linecache.getlines=self.__patched_linecache_getlines\n  \n  \n  save_displayhook=sys.displayhook\n  sys.displayhook=sys.__displayhook__\n  \n  try :\n   return self.__run(test,compileflags,out)\n  finally :\n   sys.stdout=save_stdout\n   pdb.set_trace=save_set_trace\n   sys.settrace(save_trace)\n   linecache.getlines=self.save_linecache_getlines\n   sys.displayhook=save_displayhook\n   if clear_globs:\n    test.globs.clear()\n    import builtins\n    builtins._=None\n    \n    \n    \n    \n def summarize(self,verbose=None ):\n  ''\n\n\n\n\n\n\n\n\n  \n  if verbose is None :\n   verbose=self._verbose\n  notests=[]\n  passed=[]\n  failed=[]\n  totalt=totalf=0\n  for x in self._name2ft.items():\n   name,(f,t)=x\n   assert f <=t\n   totalt +=t\n   totalf +=f\n   if t ==0:\n    notests.append(name)\n   elif f ==0:\n    passed.append((name,t))\n   else :\n    failed.append(x)\n  if verbose:\n   if notests:\n    print(len(notests),\"items had no tests:\")\n    notests.sort()\n    for thing in notests:\n     print(\"   \",thing)\n   if passed:\n    print(len(passed),\"items passed all tests:\")\n    passed.sort()\n    for thing,count in passed:\n     print(\" %3d tests in %s\"%(count,thing))\n  if failed:\n   print(self.DIVIDER)\n   print(len(failed),\"items had failures:\")\n   failed.sort()\n   for thing,(f,t)in failed:\n    print(\" %3d of %3d in %s\"%(f,t,thing))\n  if verbose:\n   print(totalt,\"tests in\",len(self._name2ft),\"items.\")\n   print(totalt -totalf,\"passed and\",totalf,\"failed.\")\n  if totalf:\n   print(\"***Test Failed***\",totalf,\"failures.\")\n  elif verbose:\n   print(\"Test passed.\")\n  return TestResults(totalf,totalt)\n  \n  \n  \n  \n def merge(self,other):\n  d=self._name2ft\n  for name,(f,t)in other._name2ft.items():\n   if name in d:\n   \n   \n   \n   \n    f2,t2=d[name]\n    f=f+f2\n    t=t+t2\n   d[name]=f,t\n   \nclass OutputChecker:\n ''\n\n\n\n\n\n \n def _toAscii(self,s):\n  ''\n\n  \n  return str(s.encode('ASCII','backslashreplace'),\"ASCII\")\n  \n def check_output(self,want,got,optionflags):\n  ''\n\n\n\n\n\n\n\n  \n  \n  \n  \n  \n  \n  \n  got=self._toAscii(got)\n  want=self._toAscii(want)\n  \n  \n  \n  if got ==want:\n   return True\n   \n   \n   \n  if not (optionflags&DONT_ACCEPT_TRUE_FOR_1):\n   if (got,want)==(\"True\\n\",\"1\\n\"):\n    return True\n   if (got,want)==(\"False\\n\",\"0\\n\"):\n    return True\n    \n    \n    \n  if not (optionflags&DONT_ACCEPT_BLANKLINE):\n  \n   want=re.sub(r'(?m)^%s\\s*?$'%re.escape(BLANKLINE_MARKER),\n   '',want)\n   \n   \n   got=re.sub(r'(?m)^[^\\S\\n]+$','',got)\n   if got ==want:\n    return True\n    \n    \n    \n    \n  if optionflags&NORMALIZE_WHITESPACE:\n   got=' '.join(got.split())\n   want=' '.join(want.split())\n   if got ==want:\n    return True\n    \n    \n    \n  if optionflags&ELLIPSIS:\n   if _ellipsis_match(want,got):\n    return True\n    \n    \n  return False\n  \n  \n def _do_a_fancy_diff(self,want,got,optionflags):\n \n  if not optionflags&(REPORT_UDIFF |\n  REPORT_CDIFF |\n  REPORT_NDIFF):\n   return False\n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n  if optionflags&REPORT_NDIFF:\n   return True\n   \n   \n  return want.count('\\n')>2 and got.count('\\n')>2\n  \n def output_difference(self,example,got,optionflags):\n  ''\n\n\n\n\n  \n  want=example.want\n  \n  \n  if not (optionflags&DONT_ACCEPT_BLANKLINE):\n   got=re.sub('(?m)^[ ]*(?=\\n)',BLANKLINE_MARKER,got)\n   \n   \n  if self._do_a_fancy_diff(want,got,optionflags):\n  \n   want_lines=want.splitlines(keepends=True )\n   got_lines=got.splitlines(keepends=True )\n   \n   if optionflags&REPORT_UDIFF:\n    diff=difflib.unified_diff(want_lines,got_lines,n=2)\n    diff=list(diff)[2:]\n    kind='unified diff with -expected +actual'\n   elif optionflags&REPORT_CDIFF:\n    diff=difflib.context_diff(want_lines,got_lines,n=2)\n    diff=list(diff)[2:]\n    kind='context diff with expected followed by actual'\n   elif optionflags&REPORT_NDIFF:\n    engine=difflib.Differ(charjunk=difflib.IS_CHARACTER_JUNK)\n    diff=list(engine.compare(want_lines,got_lines))\n    kind='ndiff with -expected +actual'\n   else :\n    assert 0,'Bad diff option'\n   return 'Differences (%s):\\n'%kind+_indent(''.join(diff))\n   \n   \n   \n  if want and got:\n   return 'Expected:\\n%sGot:\\n%s'%(_indent(want),_indent(got))\n  elif want:\n   return 'Expected:\\n%sGot nothing\\n'%_indent(want)\n  elif got:\n   return 'Expected nothing\\nGot:\\n%s'%_indent(got)\n  else :\n   return 'Expected nothing\\nGot nothing\\n'\n   \nclass DocTestFailure(Exception):\n ''\n\n\n\n\n\n\n\n\n \n def __init__(self,test,example,got):\n  self.test=test\n  self.example=example\n  self.got=got\n  \n def __str__(self):\n  return str(self.test)\n  \nclass UnexpectedException(Exception):\n ''\n\n\n\n\n\n\n\n\n \n def __init__(self,test,example,exc_info):\n  self.test=test\n  self.example=example\n  self.exc_info=exc_info\n  \n def __str__(self):\n  return str(self.test)\n  \nclass DebugRunner(DocTestRunner):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n def run(self,test,compileflags=None ,out=None ,clear_globs=True ):\n  r=DocTestRunner.run(self,test,compileflags,out,False )\n  if clear_globs:\n   test.globs.clear()\n  return r\n  \n def report_unexpected_exception(self,out,test,example,exc_info):\n  raise UnexpectedException(test,example,exc_info)\n  \n def report_failure(self,out,test,example,got):\n  raise DocTestFailure(test,example,got)\n  \n  \n  \n  \n  \n  \n  \n  \nmaster=None\n\ndef testmod(m=None ,name=None ,globs=None ,verbose=None ,\nreport=True ,optionflags=0,extraglobs=None ,\nraise_on_error=False ,exclude_empty=False ):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n global master\n \n \n if m is None :\n \n \n \n  m=sys.modules.get('__main__')\n  \n  \n if not inspect.ismodule(m):\n  raise TypeError(\"testmod: module required; %r\"%(m,))\n  \n  \n if name is None :\n  name=m.__name__\n  \n  \n finder=DocTestFinder(exclude_empty=exclude_empty)\n \n if raise_on_error:\n  runner=DebugRunner(verbose=verbose,optionflags=optionflags)\n else :\n  runner=DocTestRunner(verbose=verbose,optionflags=optionflags)\n  \n for test in finder.find(m,name,globs=globs,extraglobs=extraglobs):\n  runner.run(test)\n  \n if report:\n  runner.summarize()\n  \n if master is None :\n  master=runner\n else :\n  master.merge(runner)\n  \n return TestResults(runner.failures,runner.tries)\n \ndef testfile(filename,module_relative=True ,name=None ,package=None ,\nglobs=None ,verbose=None ,report=True ,optionflags=0,\nextraglobs=None ,raise_on_error=False ,parser=DocTestParser(),\nencoding=None ):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n global master\n \n if package and not module_relative:\n  raise ValueError(\"Package may only be specified for module-\"\n  \"relative paths.\")\n  \n  \n text,filename=_load_testfile(filename,package,module_relative,\n encoding or \"utf-8\")\n \n \n if name is None :\n  name=os.path.basename(filename)\n  \n  \n if globs is None :\n  globs={}\n else :\n  globs=globs.copy()\n if extraglobs is not None :\n  globs.update(extraglobs)\n if '__name__'not in globs:\n  globs['__name__']='__main__'\n  \n if raise_on_error:\n  runner=DebugRunner(verbose=verbose,optionflags=optionflags)\n else :\n  runner=DocTestRunner(verbose=verbose,optionflags=optionflags)\n  \n  \n test=parser.get_doctest(text,globs,name,filename,0)\n runner.run(test)\n \n if report:\n  runner.summarize()\n  \n if master is None :\n  master=runner\n else :\n  master.merge(runner)\n  \n return TestResults(runner.failures,runner.tries)\n \ndef run_docstring_examples(f,globs,verbose=False ,name=\"NoName\",\ncompileflags=None ,optionflags=0):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n finder=DocTestFinder(verbose=verbose,recurse=False )\n runner=DocTestRunner(verbose=verbose,optionflags=optionflags)\n for test in finder.find(f,name,globs=globs):\n  runner.run(test,compileflags=compileflags)\n  \n  \n  \n  \n  \n_unittest_reportflags=0\n\ndef set_unittest_reportflags(flags):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n global _unittest_reportflags\n \n if (flags&REPORTING_FLAGS)!=flags:\n  raise ValueError(\"Only reporting flags allowed\",flags)\n old=_unittest_reportflags\n _unittest_reportflags=flags\n return old\n \n \nclass DocTestCase(unittest.TestCase):\n\n def __init__(self,test,optionflags=0,setUp=None ,tearDown=None ,\n checker=None ):\n \n  unittest.TestCase.__init__(self)\n  self._dt_optionflags=optionflags\n  self._dt_checker=checker\n  self._dt_test=test\n  self._dt_setUp=setUp\n  self._dt_tearDown=tearDown\n  \n def setUp(self):\n  test=self._dt_test\n  \n  if self._dt_setUp is not None :\n   self._dt_setUp(test)\n   \n def tearDown(self):\n  test=self._dt_test\n  \n  if self._dt_tearDown is not None :\n   self._dt_tearDown(test)\n   \n  test.globs.clear()\n  \n def runTest(self):\n  test=self._dt_test\n  old=sys.stdout\n  new=StringIO()\n  optionflags=self._dt_optionflags\n  \n  if not (optionflags&REPORTING_FLAGS):\n  \n  \n   optionflags |=_unittest_reportflags\n   \n  runner=DocTestRunner(optionflags=optionflags,\n  checker=self._dt_checker,verbose=False )\n  \n  try :\n   runner.DIVIDER=\"-\"*70\n   failures,tries=runner.run(\n   test,out=new.write,clear_globs=False )\n  finally :\n   sys.stdout=old\n   \n  if failures:\n   raise self.failureException(self.format_failure(new.getvalue()))\n   \n def format_failure(self,err):\n  test=self._dt_test\n  if test.lineno is None :\n   lineno='unknown line number'\n  else :\n   lineno='%s'%test.lineno\n  lname='.'.join(test.name.split('.')[-1:])\n  return ('Failed doctest test for %s\\n'\n  '  File \"%s\", line %s, in %s\\n\\n%s'\n  %(test.name,test.filename,lineno,lname,err)\n  )\n  \n def debug(self):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  self.setUp()\n  runner=DebugRunner(optionflags=self._dt_optionflags,\n  checker=self._dt_checker,verbose=False )\n  runner.run(self._dt_test,clear_globs=False )\n  self.tearDown()\n  \n def id(self):\n  return self._dt_test.name\n  \n def __eq__(self,other):\n  if type(self)is not type(other):\n   return NotImplemented\n   \n  return self._dt_test ==other._dt_test and\\\n  self._dt_optionflags ==other._dt_optionflags and\\\n  self._dt_setUp ==other._dt_setUp and\\\n  self._dt_tearDown ==other._dt_tearDown and\\\n  self._dt_checker ==other._dt_checker\n  \n def __hash__(self):\n  return hash((self._dt_optionflags,self._dt_setUp,self._dt_tearDown,\n  self._dt_checker))\n  \n def __repr__(self):\n  name=self._dt_test.name.split('.')\n  return \"%s (%s)\"%(name[-1],'.'.join(name[:-1]))\n  \n __str__=object.__str__\n \n def shortDescription(self):\n  return \"Doctest: \"+self._dt_test.name\n  \nclass SkipDocTestCase(DocTestCase):\n def __init__(self,module):\n  self.module=module\n  DocTestCase.__init__(self,None )\n  \n def setUp(self):\n  self.skipTest(\"DocTestSuite will not work with -O2 and above\")\n  \n def test_skip(self):\n  pass\n  \n def shortDescription(self):\n  return \"Skipping tests from %s\"%self.module.__name__\n  \n __str__=shortDescription\n \n \nclass _DocTestSuite(unittest.TestSuite):\n\n def _removeTestAtIndex(self,index):\n  pass\n  \n  \ndef DocTestSuite(module=None ,globs=None ,extraglobs=None ,test_finder=None ,\n**options):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n if test_finder is None :\n  test_finder=DocTestFinder()\n  \n module=_normalize_module(module)\n tests=test_finder.find(module,globs=globs,extraglobs=extraglobs)\n \n if not tests and sys.flags.optimize >=2:\n \n  suite=_DocTestSuite()\n  suite.addTest(SkipDocTestCase(module))\n  return suite\n  \n tests.sort()\n suite=_DocTestSuite()\n \n for test in tests:\n  if len(test.examples)==0:\n   continue\n  if not test.filename:\n   filename=module.__file__\n   if filename[-4:]==\".pyc\":\n    filename=filename[:-1]\n   test.filename=filename\n  suite.addTest(DocTestCase(test,**options))\n  \n return suite\n \nclass DocFileCase(DocTestCase):\n\n def id(self):\n  return '_'.join(self._dt_test.name.split('.'))\n  \n def __repr__(self):\n  return self._dt_test.filename\n  \n def format_failure(self,err):\n  return ('Failed doctest test for %s\\n  File \"%s\", line 0\\n\\n%s'\n  %(self._dt_test.name,self._dt_test.filename,err)\n  )\n  \ndef DocFileTest(path,module_relative=True ,package=None ,\nglobs=None ,parser=DocTestParser(),\nencoding=None ,**options):\n if globs is None :\n  globs={}\n else :\n  globs=globs.copy()\n  \n if package and not module_relative:\n  raise ValueError(\"Package may only be specified for module-\"\n  \"relative paths.\")\n  \n  \n doc,path=_load_testfile(path,package,module_relative,\n encoding or \"utf-8\")\n \n if \"__file__\"not in globs:\n  globs[\"__file__\"]=path\n  \n  \n name=os.path.basename(path)\n \n \n test=parser.get_doctest(doc,globs,name,path,0)\n return DocFileCase(test,**options)\n \ndef DocFileSuite(*paths,**kw):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n suite=_DocTestSuite()\n \n \n \n \n if kw.get('module_relative',True ):\n  kw['package']=_normalize_module(kw.get('package'))\n  \n for path in paths:\n  suite.addTest(DocFileTest(path,**kw))\n  \n return suite\n \n \n \n \n \ndef script_from_examples(s):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n output=[]\n for piece in DocTestParser().parse(s):\n  if isinstance(piece,Example):\n  \n   output.append(piece.source[:-1])\n   \n   want=piece.want\n   if want:\n    output.append('# Expected:')\n    output +=['## '+l for l in want.split('\\n')[:-1]]\n  else :\n  \n   output +=[_comment_line(l)\n   for l in piece.split('\\n')[:-1]]\n   \n   \n while output and output[-1]=='#':\n  output.pop()\n while output and output[0]=='#':\n  output.pop(0)\n  \n  \n return '\\n'.join(output)+'\\n'\n \ndef testsource(module,name):\n ''\n\n\n\n\n \n module=_normalize_module(module)\n tests=DocTestFinder().find(module)\n test=[t for t in tests if t.name ==name]\n if not test:\n  raise ValueError(name,\"not found in tests\")\n test=test[0]\n testsrc=script_from_examples(test.docstring)\n return testsrc\n \ndef debug_src(src,pm=False ,globs=None ):\n ''\n testsrc=script_from_examples(src)\n debug_script(testsrc,pm,globs)\n \ndef debug_script(src,pm=False ,globs=None ):\n ''\n import pdb\n \n if globs:\n  globs=globs.copy()\n else :\n  globs={}\n  \n if pm:\n  try :\n   exec(src,globs,globs)\n  except :\n   print(sys.exc_info()[1])\n   p=pdb.Pdb(nosigint=True )\n   p.reset()\n   p.interaction(None ,sys.exc_info()[2])\n else :\n  pdb.Pdb(nosigint=True ).run(\"exec(%r)\"%src,globs,globs)\n  \ndef debug(module,name,pm=False ):\n ''\n\n\n\n\n \n module=_normalize_module(module)\n testsrc=testsource(module,name)\n debug_script(testsrc,pm,module.__dict__)\n \n \n \n \nclass _TestClass:\n ''\n\n\n\n\n\n\n\n\n\n\n \n \n def __init__(self,val):\n  ''\n\n\n\n\n  \n  \n  self.val=val\n  \n def square(self):\n  ''\n\n\n\n  \n  \n  self.val=self.val **2\n  return self\n  \n def get(self):\n  ''\n\n\n\n\n  \n  \n  return self.val\n  \n__test__={\"_TestClass\":_TestClass,\n\"string\":r\"\"\"\n                      Example of a string object, searched as-is.\n                      >>> x = 1; y = 2\n                      >>> x + y, x * y\n                      (3, 2)\n                      \"\"\",\n\n\"bool-int equivalence\":r\"\"\"\n                                    In 2.2, boolean expressions displayed\n                                    0 or 1.  By default, we still accept\n                                    them.  This can be disabled by passing\n                                    DONT_ACCEPT_TRUE_FOR_1 to the new\n                                    optionflags argument.\n                                    >>> 4 == 4\n                                    1\n                                    >>> 4 == 4\n                                    True\n                                    >>> 4 > 4\n                                    0\n                                    >>> 4 > 4\n                                    False\n                                    \"\"\",\n\n\"blank lines\":r\"\"\"\n                Blank lines can be marked with <BLANKLINE>:\n                    >>> print('foo\\n\\nbar\\n')\n                    foo\n                    <BLANKLINE>\n                    bar\n                    <BLANKLINE>\n            \"\"\",\n\n\"ellipsis\":r\"\"\"\n                If the ellipsis flag is used, then '...' can be used to\n                elide substrings in the desired output:\n                    >>> print(list(range(1000))) #doctest: +ELLIPSIS\n                    [0, 1, 2, ..., 999]\n            \"\"\",\n\n\"whitespace normalization\":r\"\"\"\n                If the whitespace normalization flag is used, then\n                differences in whitespace are ignored.\n                    >>> print(list(range(30))) #doctest: +NORMALIZE_WHITESPACE\n                    [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14,\n                     15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26,\n                     27, 28, 29]\n            \"\"\",\n}\n\n\ndef _test():\n import argparse\n \n parser=argparse.ArgumentParser(description=\"doctest runner\")\n parser.add_argument('-v','--verbose',action='store_true',default=False ,\n help='print very verbose output for all tests')\n parser.add_argument('-o','--option',action='append',\n choices=OPTIONFLAGS_BY_NAME.keys(),default=[],\n help=('specify a doctest option flag to apply'\n ' to the test run; may be specified more'\n ' than once to apply multiple options'))\n parser.add_argument('-f','--fail-fast',action='store_true',\n help=('stop running tests after first failure (this'\n ' is a shorthand for -o FAIL_FAST, and is'\n ' in addition to any other -o options)'))\n parser.add_argument('file',nargs='+',\n help='file containing the tests to run')\n args=parser.parse_args()\n testfiles=args.file\n \n \n verbose=args.verbose\n options=0\n for option in args.option:\n  options |=OPTIONFLAGS_BY_NAME[option]\n if args.fail_fast:\n  options |=FAIL_FAST\n for filename in testfiles:\n  if filename.endswith(\".py\"):\n  \n  \n  \n   dirname,filename=os.path.split(filename)\n   sys.path.insert(0,dirname)\n   m=__import__(filename[:-3])\n   del sys.path[0]\n   failures,_=testmod(m,verbose=verbose,optionflags=options)\n  else :\n   failures,_=testfile(filename,module_relative=False ,\n   verbose=verbose,optionflags=options)\n  if failures:\n   return 1\n return 0\n \n \nif __name__ ==\"__main__\":\n sys.exit(_test())\n", ["__future__", "argparse", "builtins", "collections", "difflib", "inspect", "io", "linecache", "os", "pdb", "re", "sys", "traceback", "unittest"]], "enum": [".py", "import sys\nfrom types import MappingProxyType,DynamicClassAttribute\n\n\n__all__=[\n'EnumMeta',\n'Enum','IntEnum','Flag','IntFlag',\n'auto','unique',\n]\n\n\ndef _is_descriptor(obj):\n ''\n\n \n return (\n hasattr(obj,'__get__')or\n hasattr(obj,'__set__')or\n hasattr(obj,'__delete__')\n )\n \ndef _is_dunder(name):\n ''\n\n \n return (\n len(name)>4 and\n name[:2]==name[-2:]=='__'and\n name[2]!='_'and\n name[-3]!='_'\n )\n \ndef _is_sunder(name):\n ''\n\n \n return (\n len(name)>2 and\n name[0]==name[-1]=='_'and\n name[1:2]!='_'and\n name[-2:-1]!='_'\n )\n \ndef _is_private(cls_name,name):\n\n pattern='_%s__'%(cls_name,)\n if (\n len(name)>=5\n and name.startswith(pattern)\n and name[len(pattern)]!='_'\n and (name[-1]!='_'or name[-2]!='_')\n ):\n  return True\n else :\n  return False\n  \ndef _make_class_unpicklable(cls):\n ''\n\n \n def _break_on_call_reduce(self,proto):\n  raise TypeError('%r cannot be pickled'%self)\n cls.__reduce_ex__=_break_on_call_reduce\n cls.__module__='<unknown>'\n \n_auto_null=object()\nclass auto:\n ''\n\n \n value=_auto_null\n \n \nclass _EnumDict(dict):\n ''\n\n\n\n\n \n def __init__(self):\n  super().__init__()\n  self._member_names=[]\n  self._last_values=[]\n  self._ignore=[]\n  self._auto_called=False\n  \n def __setitem__(self,key,value):\n  ''\n\n\n\n\n\n\n  \n  if _is_private(self._cls_name,key):\n   import warnings\n   warnings.warn(\n   \"private variables, such as %r, will be normal attributes in 3.11\"\n   %(key,),\n   DeprecationWarning,\n   stacklevel=2,\n   )\n  if _is_sunder(key):\n   if key not in (\n   '_order_','_create_pseudo_member_',\n   '_generate_next_value_','_missing_','_ignore_',\n   ):\n    raise ValueError('_names_ are reserved for future Enum use')\n   if key =='_generate_next_value_':\n   \n    if self._auto_called:\n     raise TypeError(\"_generate_next_value_ must be defined before members\")\n    setattr(self,'_generate_next_value',value)\n   elif key =='_ignore_':\n    if isinstance(value,str):\n     value=value.replace(',',' ').split()\n    else :\n     value=list(value)\n    self._ignore=value\n    already=set(value)&set(self._member_names)\n    if already:\n     raise ValueError(\n     '_ignore_ cannot specify already set names: %r'\n     %(already,)\n     )\n  elif _is_dunder(key):\n   if key =='__order__':\n    key='_order_'\n  elif key in self._member_names:\n  \n   raise TypeError('Attempted to reuse key: %r'%key)\n  elif key in self._ignore:\n   pass\n  elif not _is_descriptor(value):\n   if key in self:\n   \n    raise TypeError('%r already defined as: %r'%(key,self[key]))\n   if isinstance(value,auto):\n    if value.value ==_auto_null:\n     value.value=self._generate_next_value(\n     key,\n     1,\n     len(self._member_names),\n     self._last_values[:],\n     )\n     self._auto_called=True\n    value=value.value\n   self._member_names.append(key)\n   self._last_values.append(value)\n  super().__setitem__(key,value)\n  \n  \n  \n  \n  \nEnum=None\n\nclass EnumMeta(type):\n ''\n\n \n @classmethod\n def __prepare__(metacls,cls,bases,**kwds):\n \n  metacls._check_for_existing_members(cls,bases)\n  \n  enum_dict=_EnumDict()\n  enum_dict._cls_name=cls\n  \n  member_type,first_enum=metacls._get_mixins_(cls,bases)\n  if first_enum is not None :\n   enum_dict['_generate_next_value_']=getattr(\n   first_enum,'_generate_next_value_',None ,\n   )\n  return enum_dict\n  \n def __new__(metacls,cls,bases,classdict,**kwds):\n \n \n \n \n \n \n  classdict.setdefault('_ignore_',[]).append('_ignore_')\n  ignore=classdict['_ignore_']\n  for key in ignore:\n   classdict.pop(key,None )\n  member_type,first_enum=metacls._get_mixins_(cls,bases)\n  __new__,save_new,use_args=metacls._find_new_(\