# Client Class

!!! note "Get an Oanda Account"

    You need to [apply for an Oanda account](https://www.oanda.com/apply/) and get your api token and account number to run any of the code in the Client Class.

## Usage
### Import
```
from oanda.client import Client
```

### Interface

Set these properties in your code.

```
client = Client(
    account_id = DEMO_ACCOUNT_ID, 
    api_token = DEMO_API_TOKEN,
    is_paper_trading = True,
)
```

Call these methods in your code.

```
client.set_account_id(LIVE_ACCOUNT_ID)
client.set_api_token(LIVE_API_TOKEN)
client.set_is_paper_trading(False)
```

### Pass the Client to Other Classes

The Client class is the first object you need to initialize before using the rest of the sdk, and it gets passed to the other classes like so:
```
client = Client()
account = Account(client)
```
!!! danger "400 Status Code: Not Setting Account Information"

    The example above will break when the Account Class tries to call any of its methods. Be sure both account_id AND api_token are set. 

## Properties

### Defaults
```
Client(
    account_id = "", 
    api_token = "",
    is_paper_trading = True,
)
```

### REQUIRED String: account_id

This is the account number you get from Oanda API. You can find it in [Oanda Web](https://trade.oanda.com) after signing in. The primary account number is the one you want, and it looks something like:
```
Client().account_id = "000-000-0000000-000"
```
Note the account_id is a string.
```
client = Client()
client.account_id = "000-000-0000000-000"
```
You get 2 account ID's. Switch between demo and live mode in [Oanda Web](https://trade.oanda.com) to access either. Either can be used, but later on, the demo account id must be used with the demo api token. Be sure you know which goes with which.

!!! danger "400 Status Code: Mixing Live and Demo Account ID's"

    Mixing a demo account id and a live api token and vice versa will result in a 400 status code. Be sure you use the demo account id with the demo api token.

### REQUIRED String: api_token

This is the api token you get for access to the Oanda REST API. You can get it two ways:

 - Either find it in [Manage API Access | Oanda](https://www.oanda.com/account/tpa/personal_token) after signing in,
 - Or click API in [Oanda Web](https://trade.oanda.com).

Both take you to the same place, really.

```
Client().api_token = "7f544b72a6a537cbfe8fc1630d0b5be9-9773f3d9e2a2be0c89236625cb3b2f6d"
```

Note the api_token is a string just like account_id

```
client = Client()
client.api_token = "7f544b72a6a537cbfe8fc1630d0b5be9-9773f3d9e2a2be0c89236625cb3b2f6d"
```

!!! danger "400 Status Code: Mixing Live and Demo API Tokens"

    Just like the warning in the account_id section, mixing a demo account id and a live api token or vice versa will result in a 400 status code.

### String: base_url

**Don't touch this.** It is automatically generated by the is_paper_trading argument. It's one of two things depending in if you are trading with real money or fake "paper" money.

If is_paper_trading is True, then
```
Client().base_url = "https://api-fxpractice.oanda.com"
```

Otherwise is_paper_trading is False, and
```
Client().base_url = "https://api-fxtrade.oanda.com"
```

!!! danger "400 Status Code: Editing base_url"

    Editing this property may result in a malformed URL, and Oanda will return a 400 status code. There are only two correct base URLs.

### Dictionary: header

**Don't touch this either.** The header is automatically generated when the api token is set, and gets passed with the REST API call to Oanda when you call a method in the SDK that sends a request to Oanda.

The header is a dictionary like this, where API_TOKEN is the api token that you generated: 
```
{
    'Content-Type': 'application/json',
    'Authorization': 'Bearer API_TOKEN',
}
```

!!! danger "400 Status Code: Malformed Header"

    A malformed header will result in a 400 status code from Oanda.

### Boolean: is_paper_trading

This is here to make setting the base url easier.

```
Client().is_paper_trading = False
```
```
client = Client()
client.is_paper_trading = False
```

!!! danger "400 Status Code: Mixing Paper Trading with Live Account ID's and Headers"

    Setting is_paper_trading to True, and using a live account_id or api_token will result in a 400 status code.

## Methods

These are the currently supported functions that instances of Client Class can 
call.

### set_account_id()
```
Client().set_account_id(ACCOUNT_ID)
```

### set_api_token()
```
Client().set_api_token(API_TOKEN)
```

### set_is_paper_trading()
```
Client().set_is_paper_trading(False)
```

### set_header()
**Never Call this function.** This gets called automatically when set_api_token() is called.
```
Client().set_header()
```

### set_base_url()
**Never call this function.** This gets called automatically when set_api_token()
is called.
```
Client().set_base_url(ACCOUNT_ID)
```