"""Adding account/location to issues

Revision ID: add1e10105f5
Revises: 4223d2b4b66b
Create Date: 2019-01-31 10:53:27.722576

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql


# revision identifiers, used by Alembic.
revision = 'add1e10105f5'
down_revision = '4223d2b4b66b'


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('issues', sa.Column('account_id', mysql.INTEGER(unsigned=True), nullable=True))
    op.add_column('issues', sa.Column('location', sa.String(length=50), nullable=True))
    op.create_index(op.f('ix_issues_account_id'), 'issues', ['account_id'], unique=False)
    op.create_index(op.f('ix_issues_location'), 'issues', ['location'], unique=False)
    op.create_foreign_key('fk_issue_account_id', 'issues', 'accounts', ['account_id'], ['account_id'], ondelete='CASCADE')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint('fk_issue_account_id', 'issues', type_='foreignkey')
    op.drop_index(op.f('ix_issues_location'), table_name='issues')
    op.drop_index(op.f('ix_issues_account_id'), table_name='issues')
    op.drop_column('issues', 'location')
    op.drop_column('issues', 'account_id')
    # ### end Alembic commands ###
