"""Adding API Key models

Revision ID: 54438c2b1535
Revises: 8fef9c67eb44
Create Date: 2020-01-23 17:53:05.658361

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql


# revision identifiers, used by Alembic.
revision = '54438c2b1535'
down_revision = '8fef9c67eb44'


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        'api_keys',
        sa.Column('api_key_id', sa.String(length=36), nullable=False),
        sa.Column('secret_key', sa.String(length=100), nullable=False),
        sa.Column('created', mysql.DATETIME(), server_default=sa.text('now()'), nullable=False),
        sa.Column('last_used', mysql.DATETIME()),
        sa.Column('description', sa.String(200), nullable=False),
        sa.PrimaryKeyConstraint('api_key_id')
    )
    op.create_table(
        'api_key_roles',
        sa.Column('api_role_id', mysql.INTEGER(), autoincrement=True, nullable=False),
        sa.Column('api_key_id', sa.String(length=36), nullable=True),
        sa.Column('role_id', mysql.INTEGER(), nullable=True),
        sa.ForeignKeyConstraint(('api_key_id',), ['api_keys.api_key_id'], name='fk_api_key_role_user', ondelete='CASCADE'),
        sa.ForeignKeyConstraint(('role_id',), ['roles.role_id'], name='fk_api_key_role_role', ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('api_role_id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('api_key_roles')
    op.drop_table('api_keys')
    # ### end Alembic commands ###
