/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.tree;

import hex.genmodel.GenModel;
import hex.genmodel.algos.isotonic.IsotonicCalibrator;

public class CalibrationMojoHelper {
    public static boolean calibrateClassProbabilities(MojoModelWithCalibration model, double[] preds) {
        if (model.getCalibGlmBeta() != null) {
            double p2 = GenModel.GLM_logitInv(preds[1] * model.getCalibGlmBeta()[0] + model.getCalibGlmBeta()[1]);
            preds[1] = 1.0 - p2;
            preds[2] = p2;
            return true;
        }
        if (model.getIsotonicCalibrator() != null) {
            double p3 = model.getIsotonicCalibrator().calibrateP1(preds[2]);
            preds[1] = 1.0 - p3;
            preds[2] = p3;
            return true;
        }
        return false;
    }

    public static interface MojoModelWithCalibration {
        public double[] getCalibGlmBeta();

        public IsotonicCalibrator getIsotonicCalibrator();
    }
}

