/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.utils;

import ai.h2o.mojos.runtime.utils.SubParser;
import org.joda.time.DateTimeFieldType;
import org.joda.time.format.DateTimeParserBucket;

class Month3LetterParse
extends SubParser {
    private static final int TO_LOWER = 32;

    Month3LetterParse() {
    }

    @Override
    public int estimateParsedLength() {
        return 3;
    }

    @Override
    public int parseInto(DateTimeParserBucket bucket, String text, int position) {
        int n2;
        if (position < 0) {
            throw new IllegalArgumentException("position cannot be negative");
        }
        if (position > text.length() - 3) {
            return ~position;
        }
        char[] cArray = new char[3];
        int n3 = position;
        text.getChars(n3, n3 + 3, cArray, 0);
        if (cArray[0] < 'a' || cArray[0] > 'z') {
            if (cArray[0] < 'A' || cArray[0] > 'Z') {
                return ~position;
            }
            cArray[0] = (char)(cArray[0] + 32);
        }
        if (cArray[1] < 'a' || cArray[1] > 'z') {
            if (cArray[1] < 'A' || cArray[1] > 'Z') {
                return ~(position + 1);
            }
            cArray[1] = (char)(cArray[1] + 32);
        }
        if (cArray[2] < 'a' || cArray[2] > 'z') {
            if (cArray[2] < 'A' || cArray[2] > 'Z') {
                return ~(position + 2);
            }
            cArray[2] = (char)(cArray[2] + 32);
        }
        block0 : switch (cArray[0]) {
            case 'j': {
                switch (cArray[1]) {
                    case 'a': {
                        if (cArray[2] != 'n') {
                            return ~(position + 2);
                        }
                        n2 = 1;
                        break block0;
                    }
                    case 'u': {
                        switch (cArray[2]) {
                            case 'n': {
                                n2 = 6;
                                break block0;
                            }
                            case 'l': {
                                n2 = 7;
                                break block0;
                            }
                        }
                        return ~(position + 2);
                    }
                }
                return ~(position + 1);
            }
            case 'f': {
                if (cArray[1] != 'e') {
                    return ~(position + 1);
                }
                if (cArray[2] != 'b') {
                    return ~(position + 2);
                }
                n2 = 2;
                break;
            }
            case 'm': {
                if (cArray[1] != 'a') {
                    return ~(position + 1);
                }
                switch (cArray[2]) {
                    case 'r': {
                        n2 = 3;
                        break block0;
                    }
                    case 'y': {
                        n2 = 5;
                        break block0;
                    }
                }
                return ~(position + 2);
            }
            case 'a': {
                switch (cArray[1]) {
                    case 'p': {
                        if (cArray[2] != 'r') {
                            return ~(position + 2);
                        }
                        n2 = 4;
                        break block0;
                    }
                    case 'u': {
                        if (cArray[2] != 'g') {
                            return ~(position + 2);
                        }
                        n2 = 8;
                        break block0;
                    }
                }
                return ~(position + 1);
            }
            case 's': {
                if (cArray[1] != 'e') {
                    return ~(position + 1);
                }
                if (cArray[2] != 'p') {
                    return ~(position + 2);
                }
                n2 = 9;
                break;
            }
            case 'o': {
                if (cArray[1] != 'c') {
                    return ~(position + 1);
                }
                if (cArray[2] != 't') {
                    return ~(position + 2);
                }
                n2 = 10;
                break;
            }
            case 'n': {
                if (cArray[1] != 'o') {
                    return ~(position + 1);
                }
                if (cArray[2] != 'v') {
                    return ~(position + 2);
                }
                n2 = 11;
                break;
            }
            case 'd': {
                if (cArray[1] != 'e') {
                    return ~(position + 1);
                }
                if (cArray[2] != 'c') {
                    return ~(position + 2);
                }
                n2 = 12;
                break;
            }
            default: {
                return ~position;
            }
        }
        int n4 = position + 3;
        if (this.child != null) {
            n4 = this.child.parseInto(bucket, text, n4);
        } else if (this.ignoreSuffix) {
            n4 = text.length();
        }
        if (n4 >= 0) {
            bucket.saveField(DateTimeFieldType.monthOfYear(), n2);
        }
        return n4;
    }
}

