/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.utils;

import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.utils.BatchedCsvMojoProcessor;
import ai.h2o.mojos.runtime.utils.Consts;
import com.opencsv.CSVWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;

public class CsvWritingBatchHandler
implements BatchedCsvMojoProcessor.DualBatchHandler,
Closeable {
    private static final boolean QUOTED_HEADERS = Consts.propExist("parser.csv.quotedHeaders") ? Consts.getSysProp("parser.csv.quotedHeaders", false) : Consts.getSysProp("quotedHeaders", false);
    private boolean applyQuotesToAll = false;
    private final CSVWriter csvWriter;
    private String[] inputColNames = new String[0];

    public CsvWritingBatchHandler(Writer writer) {
        this(new CSVWriter(writer, BatchedCsvMojoProcessor.SEPARATOR, '\"', BatchedCsvMojoProcessor.ESCAPE_CHAR));
    }

    public CsvWritingBatchHandler(CSVWriter csvWriter) {
        this.csvWriter = csvWriter;
    }

    public void setApplyQuotesToAll(boolean applyQuotesToAll) {
        this.applyQuotesToAll = applyQuotesToAll;
    }

    @Deprecated
    public void setExposeAllInputs(boolean ignored) {
        throw new UnsupportedOperationException("Exposing ALL inputs is no longer supported");
    }

    @Deprecated
    public void setExposedInputs(String ... inputColNames) {
        this.inputColNames = inputColNames;
    }

    @Override
    public void handleBatch(int batchNo, MojoFrame iframe, MojoFrame oframe) throws IOException {
        int n2;
        String[][] stringArrayArray;
        int n3 = oframe.getNcols();
        int n4 = this.inputColNames.length;
        int n5 = n4 + n3;
        String[] stringArray = new String[n5];
        if (batchNo == 0) {
            if (n4 > 0) {
                System.arraycopy(this.inputColNames, 0, stringArray, 0, n4);
            }
            stringArrayArray = oframe.getColumnNames();
            System.arraycopy(stringArrayArray, 0, stringArray, n4, n3);
            this.csvWriter.writeNext(stringArray, QUOTED_HEADERS);
        }
        stringArrayArray = new String[n3][];
        for (int i2 = 0; i2 < n3; ++i2) {
            stringArrayArray[i2] = oframe.getColumn(i2).getDataAsStrings();
        }
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        String[] stringArray2 = iframe.getColumnNames();
        for (int i3 = 0; i3 < stringArray2.length; ++i3) {
            linkedHashMap.put(iframe.getColumnName(i3), i3);
        }
        String[][] stringArrayArray2 = new String[n4][];
        for (n2 = 0; n2 < n4; ++n2) {
            String string = this.inputColNames[n2];
            Integer n6 = (Integer)linkedHashMap.get(string);
            if (n6 == null) {
                throw new IOException("No such input column: " + string);
            }
            stringArrayArray2[n2] = iframe.getColumn(n6).getDataAsStrings();
        }
        for (n2 = 0; n2 < oframe.getNrows(); ++n2) {
            int n7;
            for (n7 = 0; n7 < n4; ++n7) {
                stringArray[n7] = stringArrayArray2[n7][n2];
            }
            for (int i4 = 0; i4 < n3; ++i4) {
                stringArray[n7] = stringArrayArray[i4][n2];
                ++n7;
            }
            this.csvWriter.writeNext(stringArray, this.applyQuotesToAll);
        }
        this.csvWriter.flush();
    }

    public static void csvWriteFrame(CSVWriter csvWriter, MojoFrame oframe, boolean withHeader) throws IOException {
        if (withHeader) {
            csvWriter.writeNext(oframe.getColumnNames(), QUOTED_HEADERS);
        }
        int n2 = oframe.getNcols();
        String[][] stringArrayArray = new String[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArrayArray[i2] = oframe.getColumn(i2).getDataAsStrings();
        }
        String[] stringArray = new String[n2];
        for (int i3 = 0; i3 < oframe.getNrows(); ++i3) {
            for (int i4 = 0; i4 < n2; ++i4) {
                stringArray[i4] = stringArrayArray[i4][i3];
            }
            csvWriter.writeNext(stringArray, false);
        }
        csvWriter.flush();
    }

    @Override
    public void close() throws IOException {
        this.csvWriter.close();
    }
}

