/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.ByteOutput;
import ai.h2o.com.google.protobuf.ByteString;
import ai.h2o.com.google.protobuf.CodedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

final class RopeByteString
extends ByteString {
    static final int[] minLengthByDepth = new int[]{1, 1, 2, 3, 5, 8, 13, 21, 34, 55, 89, 144, 233, 377, 610, 987, 1597, 2584, 4181, 6765, 10946, 17711, 28657, 46368, 75025, 121393, 196418, 317811, 514229, 832040, 1346269, 2178309, 3524578, 5702887, 0x8CCCC9, 14930352, 24157817, 39088169, 63245986, 102334155, 165580141, 267914296, 433494437, 701408733, 1134903170, 1836311903, Integer.MAX_VALUE};
    private final int totalLength;
    private final ByteString left;
    private final ByteString right;
    private final int leftLength;
    private final int treeDepth;
    private static final long serialVersionUID = 1L;

    private RopeByteString(ByteString left, ByteString right) {
        this.left = left;
        this.right = right;
        this.leftLength = left.size();
        this.totalLength = this.leftLength + right.size();
        this.treeDepth = Math.max(left.getTreeDepth(), right.getTreeDepth()) + 1;
    }

    static ByteString concatenate(ByteString left, ByteString right) {
        int n2;
        if (right.size() == 0) {
            return left;
        }
        if (left.size() == 0) {
            return right;
        }
        int n3 = left.size() + right.size();
        if (n3 < 128) {
            return RopeByteString.concatenateBytes(left, right);
        }
        if (left instanceof RopeByteString) {
            RopeByteString ropeByteString = (RopeByteString)left;
            if (ropeByteString.right.size() + right.size() < 128) {
                ByteString byteString = RopeByteString.concatenateBytes(ropeByteString.right, right);
                return new RopeByteString(ropeByteString.left, byteString);
            }
            if (ropeByteString.left.getTreeDepth() > ropeByteString.right.getTreeDepth() && ropeByteString.getTreeDepth() > right.getTreeDepth()) {
                RopeByteString ropeByteString2 = new RopeByteString(ropeByteString.right, right);
                return new RopeByteString(ropeByteString.left, ropeByteString2);
            }
        }
        if (n3 >= RopeByteString.minLength(n2 = Math.max(left.getTreeDepth(), right.getTreeDepth()) + 1)) {
            return new RopeByteString(left, right);
        }
        return new Balancer().balance(left, right);
    }

    private static ByteString concatenateBytes(ByteString left, ByteString right) {
        int n2 = left.size();
        int n3 = right.size();
        byte[] byArray = new byte[n2 + n3];
        left.copyTo(byArray, 0, 0, n2);
        right.copyTo(byArray, 0, n2, n3);
        return ByteString.wrap(byArray);
    }

    static RopeByteString newInstanceForTest(ByteString left, ByteString right) {
        return new RopeByteString(left, right);
    }

    static int minLength(int depth) {
        if (depth >= minLengthByDepth.length) {
            return Integer.MAX_VALUE;
        }
        return minLengthByDepth[depth];
    }

    @Override
    public final byte byteAt(int index) {
        RopeByteString.checkIndex(index, this.totalLength);
        return this.internalByteAt(index);
    }

    @Override
    final byte internalByteAt(int index) {
        if (index < this.leftLength) {
            return this.left.internalByteAt(index);
        }
        return this.right.internalByteAt(index - this.leftLength);
    }

    @Override
    public final int size() {
        return this.totalLength;
    }

    @Override
    public final ByteString.ByteIterator iterator() {
        return new ByteString.AbstractByteIterator(){
            final PieceIterator pieces;
            ByteString.ByteIterator current;
            {
                this.pieces = new PieceIterator(RopeByteString.this);
                this.current = this.nextPiece();
            }

            private ByteString.ByteIterator nextPiece() {
                if (this.pieces.hasNext()) {
                    return this.pieces.next().iterator();
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public byte nextByte() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                byte by = this.current.nextByte();
                if (!this.current.hasNext()) {
                    this.current = this.nextPiece();
                }
                return by;
            }
        };
    }

    @Override
    protected final int getTreeDepth() {
        return this.treeDepth;
    }

    @Override
    protected final boolean isBalanced() {
        return this.totalLength >= RopeByteString.minLength(this.treeDepth);
    }

    @Override
    public final ByteString substring(int beginIndex, int endIndex) {
        int n2 = RopeByteString.checkRange(beginIndex, endIndex, this.totalLength);
        if (n2 == 0) {
            return ByteString.EMPTY;
        }
        if (n2 == this.totalLength) {
            return this;
        }
        if (endIndex <= this.leftLength) {
            return this.left.substring(beginIndex, endIndex);
        }
        if (beginIndex >= this.leftLength) {
            return this.right.substring(beginIndex - this.leftLength, endIndex - this.leftLength);
        }
        ByteString byteString = this.left.substring(beginIndex);
        ByteString byteString2 = this.right.substring(0, endIndex - this.leftLength);
        return new RopeByteString(byteString, byteString2);
    }

    @Override
    protected final void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
        if (sourceOffset + numberToCopy <= this.leftLength) {
            this.left.copyToInternal(target, sourceOffset, targetOffset, numberToCopy);
            return;
        }
        if (sourceOffset >= this.leftLength) {
            this.right.copyToInternal(target, sourceOffset - this.leftLength, targetOffset, numberToCopy);
            return;
        }
        int n2 = this.leftLength - sourceOffset;
        this.left.copyToInternal(target, sourceOffset, targetOffset, n2);
        this.right.copyToInternal(target, 0, targetOffset + n2, numberToCopy - n2);
    }

    @Override
    public final void copyTo(ByteBuffer target) {
        this.left.copyTo(target);
        this.right.copyTo(target);
    }

    @Override
    public final ByteBuffer asReadOnlyByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.toByteArray());
        return byteBuffer.asReadOnlyBuffer();
    }

    @Override
    public final List<ByteBuffer> asReadOnlyByteBufferList() {
        ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>();
        PieceIterator pieceIterator = new PieceIterator(this);
        while (pieceIterator.hasNext()) {
            ByteString.LeafByteString leafByteString = pieceIterator.next();
            arrayList.add(leafByteString.asReadOnlyByteBuffer());
        }
        return arrayList;
    }

    @Override
    public final void writeTo(OutputStream outputStream) throws IOException {
        this.left.writeTo(outputStream);
        this.right.writeTo(outputStream);
    }

    @Override
    final void writeToInternal(OutputStream out, int sourceOffset, int numberToWrite) throws IOException {
        if (sourceOffset + numberToWrite <= this.leftLength) {
            this.left.writeToInternal(out, sourceOffset, numberToWrite);
            return;
        }
        if (sourceOffset >= this.leftLength) {
            this.right.writeToInternal(out, sourceOffset - this.leftLength, numberToWrite);
            return;
        }
        int n2 = this.leftLength - sourceOffset;
        this.left.writeToInternal(out, sourceOffset, n2);
        this.right.writeToInternal(out, 0, numberToWrite - n2);
    }

    @Override
    final void writeTo(ByteOutput output) throws IOException {
        this.left.writeTo(output);
        this.right.writeTo(output);
    }

    @Override
    final void writeToReverse(ByteOutput output) throws IOException {
        this.right.writeToReverse(output);
        this.left.writeToReverse(output);
    }

    @Override
    protected final String toStringInternal(Charset charset) {
        return new String(this.toByteArray(), charset);
    }

    @Override
    public final boolean isValidUtf8() {
        int n2 = this.left.partialIsValidUtf8(0, 0, this.leftLength);
        int n3 = this.right.partialIsValidUtf8(n2, 0, this.right.size());
        return n3 == 0;
    }

    @Override
    protected final int partialIsValidUtf8(int state, int offset, int length) {
        int n2 = offset + length;
        if (n2 <= this.leftLength) {
            return this.left.partialIsValidUtf8(state, offset, length);
        }
        if (offset >= this.leftLength) {
            return this.right.partialIsValidUtf8(state, offset - this.leftLength, length);
        }
        int n3 = this.leftLength - offset;
        int n4 = this.left.partialIsValidUtf8(state, offset, n3);
        return this.right.partialIsValidUtf8(n4, 0, length - n3);
    }

    @Override
    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ByteString)) {
            return false;
        }
        ByteString byteString = (ByteString)other;
        if (this.totalLength != byteString.size()) {
            return false;
        }
        if (this.totalLength == 0) {
            return true;
        }
        int n2 = this.peekCachedHashCode();
        int n3 = byteString.peekCachedHashCode();
        if (n2 != 0 && n3 != 0 && n2 != n3) {
            return false;
        }
        return this.equalsFragments(byteString);
    }

    private boolean equalsFragments(ByteString other) {
        int n2 = 0;
        PieceIterator pieceIterator = new PieceIterator(this);
        ByteString.LeafByteString leafByteString = (ByteString.LeafByteString)pieceIterator.next();
        int n3 = 0;
        PieceIterator pieceIterator2 = new PieceIterator(other);
        ByteString.LeafByteString leafByteString2 = (ByteString.LeafByteString)pieceIterator2.next();
        int n4 = 0;
        while (true) {
            int n5 = leafByteString.size() - n2;
            int n6 = leafByteString2.size() - n3;
            int n7 = Math.min(n5, n6);
            boolean bl = n2 == 0 ? leafByteString.equalsRange(leafByteString2, n3, n7) : leafByteString2.equalsRange(leafByteString, n2, n7);
            if (!bl) {
                return false;
            }
            if ((n4 += n7) >= this.totalLength) {
                if (n4 == this.totalLength) {
                    return true;
                }
                throw new IllegalStateException();
            }
            if (n7 == n5) {
                n2 = 0;
                leafByteString = (ByteString.LeafByteString)pieceIterator.next();
            } else {
                n2 += n7;
            }
            if (n7 == n6) {
                n3 = 0;
                leafByteString2 = (ByteString.LeafByteString)pieceIterator2.next();
                continue;
            }
            n3 += n7;
        }
    }

    @Override
    protected final int partialHash(int h2, int offset, int length) {
        int n2 = offset + length;
        if (n2 <= this.leftLength) {
            return this.left.partialHash(h2, offset, length);
        }
        if (offset >= this.leftLength) {
            return this.right.partialHash(h2, offset - this.leftLength, length);
        }
        int n3 = this.leftLength - offset;
        int n4 = this.left.partialHash(h2, offset, n3);
        return this.right.partialHash(n4, 0, length - n3);
    }

    @Override
    public final CodedInputStream newCodedInput() {
        return CodedInputStream.newInstance(this.asReadOnlyByteBufferList(), true);
    }

    @Override
    public final InputStream newInput() {
        return new RopeInputStream();
    }

    final Object writeReplace() {
        return ByteString.wrap(this.toByteArray());
    }

    private void readObject(ObjectInputStream in) throws IOException {
        throw new InvalidObjectException("RopeByteStream instances are not to be serialized directly");
    }

    private class RopeInputStream
    extends InputStream {
        private PieceIterator pieceIterator;
        private ByteString.LeafByteString currentPiece;
        private int currentPieceSize;
        private int currentPieceIndex;
        private int currentPieceOffsetInRope;
        private int mark;

        public RopeInputStream() {
            this.initialize();
        }

        @Override
        public int read(byte[] b2, int offset, int length) {
            if (b2 == null) {
                throw new NullPointerException();
            }
            if (offset < 0 || length < 0 || length > b2.length - offset) {
                throw new IndexOutOfBoundsException();
            }
            int n2 = this.readSkipInternal(b2, offset, length);
            if (n2 == 0 && (length > 0 || this.availableInternal() == 0)) {
                return -1;
            }
            return n2;
        }

        @Override
        public long skip(long length) {
            if (length < 0L) {
                throw new IndexOutOfBoundsException();
            }
            if (length > Integer.MAX_VALUE) {
                length = Integer.MAX_VALUE;
            }
            return this.readSkipInternal(null, 0, (int)length);
        }

        private int readSkipInternal(byte[] b2, int offset, int length) {
            int n2;
            int n3;
            for (n2 = length; n2 > 0; n2 -= n3) {
                this.advanceIfCurrentPieceFullyRead();
                if (this.currentPiece == null) break;
                int n4 = this.currentPieceSize - this.currentPieceIndex;
                n3 = Math.min(n4, n2);
                if (b2 != null) {
                    this.currentPiece.copyTo(b2, this.currentPieceIndex, offset, n3);
                    offset += n3;
                }
                this.currentPieceIndex += n3;
            }
            return length - n2;
        }

        @Override
        public int read() throws IOException {
            this.advanceIfCurrentPieceFullyRead();
            if (this.currentPiece == null) {
                return -1;
            }
            return this.currentPiece.byteAt(this.currentPieceIndex++) & 0xFF;
        }

        @Override
        public int available() throws IOException {
            return this.availableInternal();
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int readAheadLimit) {
            this.mark = this.currentPieceOffsetInRope + this.currentPieceIndex;
        }

        @Override
        public synchronized void reset() {
            this.initialize();
            this.readSkipInternal(null, 0, this.mark);
        }

        private void initialize() {
            this.pieceIterator = new PieceIterator(RopeByteString.this);
            this.currentPiece = this.pieceIterator.next();
            this.currentPieceSize = this.currentPiece.size();
            this.currentPieceIndex = 0;
            this.currentPieceOffsetInRope = 0;
        }

        private void advanceIfCurrentPieceFullyRead() {
            if (this.currentPiece != null && this.currentPieceIndex == this.currentPieceSize) {
                this.currentPieceOffsetInRope += this.currentPieceSize;
                this.currentPieceIndex = 0;
                if (this.pieceIterator.hasNext()) {
                    this.currentPiece = this.pieceIterator.next();
                    this.currentPieceSize = this.currentPiece.size();
                    return;
                }
                this.currentPiece = null;
                this.currentPieceSize = 0;
            }
        }

        private int availableInternal() {
            int n2 = this.currentPieceOffsetInRope + this.currentPieceIndex;
            return RopeByteString.this.size() - n2;
        }
    }

    private static final class PieceIterator
    implements Iterator<ByteString.LeafByteString> {
        private final ArrayDeque<RopeByteString> breadCrumbs;
        private ByteString.LeafByteString next;

        private PieceIterator(ByteString root) {
            if (root instanceof RopeByteString) {
                RopeByteString ropeByteString = (RopeByteString)root;
                this.breadCrumbs = new ArrayDeque(ropeByteString.getTreeDepth());
                this.breadCrumbs.push(ropeByteString);
                this.next = this.getLeafByLeft(ropeByteString.left);
                return;
            }
            this.breadCrumbs = null;
            this.next = (ByteString.LeafByteString)root;
        }

        private ByteString.LeafByteString getLeafByLeft(ByteString root) {
            ByteString byteString = root;
            while (byteString instanceof RopeByteString) {
                RopeByteString ropeByteString = (RopeByteString)byteString;
                this.breadCrumbs.push(ropeByteString);
                byteString = ropeByteString.left;
            }
            return (ByteString.LeafByteString)byteString;
        }

        private ByteString.LeafByteString getNextNonEmptyLeaf() {
            PieceIterator pieceIterator;
            ByteString.LeafByteString leafByteString;
            do {
                if (this.breadCrumbs == null || this.breadCrumbs.isEmpty()) {
                    return null;
                }
                pieceIterator = this;
            } while ((leafByteString = pieceIterator.getLeafByLeft(pieceIterator.breadCrumbs.pop().right)).isEmpty());
            return leafByteString;
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        @Override
        public final ByteString.LeafByteString next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            ByteString.LeafByteString leafByteString = this.next;
            this.next = this.getNextNonEmptyLeaf();
            return leafByteString;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Balancer {
        private final ArrayDeque<ByteString> prefixesStack = new ArrayDeque();

        private Balancer() {
        }

        private ByteString balance(ByteString left, ByteString right) {
            this.doBalance(left);
            this.doBalance(right);
            ByteString byteString = this.prefixesStack.pop();
            while (!this.prefixesStack.isEmpty()) {
                ByteString byteString2 = this.prefixesStack.pop();
                byteString = new RopeByteString(byteString2, byteString);
            }
            return byteString;
        }

        private void doBalance(ByteString root) {
            if (root.isBalanced()) {
                this.insert(root);
                return;
            }
            if (root instanceof RopeByteString) {
                RopeByteString ropeByteString = (RopeByteString)root;
                this.doBalance(ropeByteString.left);
                this.doBalance(ropeByteString.right);
                return;
            }
            throw new IllegalArgumentException("Has a new type of ByteString been created? Found " + root.getClass());
        }

        private void insert(ByteString byteString) {
            ByteString byteString2;
            int n2 = this.getDepthBinForLength(byteString.size());
            int n3 = RopeByteString.minLength(n2 + 1);
            if (this.prefixesStack.isEmpty() || this.prefixesStack.peek().size() >= n3) {
                this.prefixesStack.push(byteString);
                return;
            }
            int n4 = RopeByteString.minLength(n2);
            ByteString byteString3 = this.prefixesStack.pop();
            while (!this.prefixesStack.isEmpty() && this.prefixesStack.peek().size() < n4) {
                byteString2 = this.prefixesStack.pop();
                byteString3 = new RopeByteString(byteString2, byteString3);
            }
            byteString3 = new RopeByteString(byteString3, byteString);
            while (!this.prefixesStack.isEmpty()) {
                n2 = this.getDepthBinForLength(byteString3.size());
                n3 = RopeByteString.minLength(n2 + 1);
                if (this.prefixesStack.peek().size() >= n3) break;
                byteString2 = this.prefixesStack.pop();
                byteString3 = new RopeByteString(byteString2, byteString3);
            }
            this.prefixesStack.push(byteString3);
        }

        private int getDepthBinForLength(int length) {
            int n2 = Arrays.binarySearch(minLengthByDepth, length);
            if (n2 < 0) {
                int n3 = -(n2 + 1);
                n2 = n3 - 1;
            }
            return n2;
        }
    }
}

