/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.CheckReturnValue;
import ai.h2o.com.google.protobuf.ExtensionSchemas;
import ai.h2o.com.google.protobuf.GeneratedMessageInfoFactory;
import ai.h2o.com.google.protobuf.GeneratedMessageLite;
import ai.h2o.com.google.protobuf.Internal;
import ai.h2o.com.google.protobuf.ListFieldSchema;
import ai.h2o.com.google.protobuf.MapFieldSchemas;
import ai.h2o.com.google.protobuf.MessageInfo;
import ai.h2o.com.google.protobuf.MessageInfoFactory;
import ai.h2o.com.google.protobuf.MessageSchema;
import ai.h2o.com.google.protobuf.MessageSetSchema;
import ai.h2o.com.google.protobuf.NewInstanceSchemas;
import ai.h2o.com.google.protobuf.ProtoSyntax;
import ai.h2o.com.google.protobuf.Schema;
import ai.h2o.com.google.protobuf.SchemaFactory;
import ai.h2o.com.google.protobuf.SchemaUtil;

@CheckReturnValue
final class ManifestSchemaFactory
implements SchemaFactory {
    private final MessageInfoFactory messageInfoFactory;
    private static final MessageInfoFactory EMPTY_FACTORY = new MessageInfoFactory(){

        @Override
        public final boolean isSupported(Class<?> clazz) {
            return false;
        }

        @Override
        public final MessageInfo messageInfoFor(Class<?> clazz) {
            throw new IllegalStateException("This should never be called.");
        }
    };

    public ManifestSchemaFactory() {
        this(ManifestSchemaFactory.getDefaultMessageInfoFactory());
    }

    private ManifestSchemaFactory(MessageInfoFactory messageInfoFactory) {
        this.messageInfoFactory = Internal.checkNotNull(messageInfoFactory, "messageInfoFactory");
    }

    @Override
    public final <T> Schema<T> createSchema(Class<T> messageType) {
        SchemaUtil.requireGeneratedMessage(messageType);
        MessageInfo messageInfo = this.messageInfoFactory.messageInfoFor(messageType);
        if (messageInfo.isMessageSetWireFormat()) {
            if (GeneratedMessageLite.class.isAssignableFrom(messageType)) {
                return MessageSetSchema.newSchema(SchemaUtil.unknownFieldSetLiteSchema(), ExtensionSchemas.lite(), messageInfo.getDefaultInstance());
            }
            return MessageSetSchema.newSchema(SchemaUtil.proto2UnknownFieldSetSchema(), ExtensionSchemas.full(), messageInfo.getDefaultInstance());
        }
        return ManifestSchemaFactory.newSchema(messageType, messageInfo);
    }

    private static <T> Schema<T> newSchema(Class<T> messageType, MessageInfo messageInfo) {
        if (GeneratedMessageLite.class.isAssignableFrom(messageType)) {
            if (ManifestSchemaFactory.isProto2(messageInfo)) {
                return MessageSchema.newSchema(messageType, messageInfo, NewInstanceSchemas.lite(), ListFieldSchema.lite(), SchemaUtil.unknownFieldSetLiteSchema(), ExtensionSchemas.lite(), MapFieldSchemas.lite());
            }
            return MessageSchema.newSchema(messageType, messageInfo, NewInstanceSchemas.lite(), ListFieldSchema.lite(), SchemaUtil.unknownFieldSetLiteSchema(), null, MapFieldSchemas.lite());
        }
        if (ManifestSchemaFactory.isProto2(messageInfo)) {
            return MessageSchema.newSchema(messageType, messageInfo, NewInstanceSchemas.full(), ListFieldSchema.full(), SchemaUtil.proto2UnknownFieldSetSchema(), ExtensionSchemas.full(), MapFieldSchemas.full());
        }
        return MessageSchema.newSchema(messageType, messageInfo, NewInstanceSchemas.full(), ListFieldSchema.full(), SchemaUtil.proto3UnknownFieldSetSchema(), null, MapFieldSchemas.full());
    }

    private static boolean isProto2(MessageInfo messageInfo) {
        return messageInfo.getSyntax() == ProtoSyntax.PROTO2;
    }

    private static MessageInfoFactory getDefaultMessageInfoFactory() {
        return new CompositeMessageInfoFactory(GeneratedMessageInfoFactory.getInstance(), ManifestSchemaFactory.getDescriptorMessageInfoFactory());
    }

    private static MessageInfoFactory getDescriptorMessageInfoFactory() {
        try {
            Class<?> clazz = Class.forName("ai.h2o.com.google.protobuf.DescriptorMessageInfoFactory");
            return (MessageInfoFactory)clazz.getDeclaredMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            return EMPTY_FACTORY;
        }
    }

    private static class CompositeMessageInfoFactory
    implements MessageInfoFactory {
        private MessageInfoFactory[] factories;

        CompositeMessageInfoFactory(MessageInfoFactory ... factories) {
            this.factories = factories;
        }

        @Override
        public boolean isSupported(Class<?> clazz) {
            MessageInfoFactory[] messageInfoFactoryArray = this.factories;
            int n2 = this.factories.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                MessageInfoFactory messageInfoFactory = messageInfoFactoryArray[i2];
                if (!messageInfoFactory.isSupported(clazz)) continue;
                return true;
            }
            return false;
        }

        @Override
        public MessageInfo messageInfoFor(Class<?> clazz) {
            MessageInfoFactory[] messageInfoFactoryArray = this.factories;
            int n2 = this.factories.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                MessageInfoFactory messageInfoFactory = messageInfoFactoryArray[i2];
                if (!messageInfoFactory.isSupported(clazz)) continue;
                return messageInfoFactory.messageInfoFor(clazz);
            }
            throw new UnsupportedOperationException("No factory is available for message type: " + clazz.getName());
        }
    }
}

