/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.ByteString;
import ai.h2o.com.google.protobuf.Descriptors;
import ai.h2o.com.google.protobuf.FieldInfo;
import ai.h2o.com.google.protobuf.FieldType;
import ai.h2o.com.google.protobuf.GeneratedMessageV3;
import ai.h2o.com.google.protobuf.Internal;
import ai.h2o.com.google.protobuf.Message;
import ai.h2o.com.google.protobuf.MessageInfo;
import ai.h2o.com.google.protobuf.MessageInfoFactory;
import ai.h2o.com.google.protobuf.OneofInfo;
import ai.h2o.com.google.protobuf.ProtoSyntax;
import ai.h2o.com.google.protobuf.SchemaUtil;
import ai.h2o.com.google.protobuf.StructuralMessageInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;

final class DescriptorMessageInfoFactory
implements MessageInfoFactory {
    private static final String GET_DEFAULT_INSTANCE_METHOD_NAME = "getDefaultInstance";
    private static final DescriptorMessageInfoFactory instance = new DescriptorMessageInfoFactory();
    private static final Set<String> specialFieldNames = new HashSet<String>(Arrays.asList("Class", "DefaultInstanceForType", "ParserForType", "SerializedSize", "AllFields", "DescriptorForType", "InitializationErrorString", "UnknownFields", "CachedSize"));
    private static IsInitializedCheckAnalyzer isInitializedCheckAnalyzer = new IsInitializedCheckAnalyzer();

    private DescriptorMessageInfoFactory() {
    }

    public static DescriptorMessageInfoFactory getInstance() {
        return instance;
    }

    @Override
    public final boolean isSupported(Class<?> messageType) {
        return GeneratedMessageV3.class.isAssignableFrom(messageType);
    }

    @Override
    public final MessageInfo messageInfoFor(Class<?> messageType) {
        if (!GeneratedMessageV3.class.isAssignableFrom(messageType)) {
            throw new IllegalArgumentException("Unsupported message type: " + messageType.getName());
        }
        Class<?> clazz = messageType;
        return DescriptorMessageInfoFactory.convert(clazz, DescriptorMessageInfoFactory.descriptorForType(clazz));
    }

    private static Message getDefaultInstance(Class<?> messageType) {
        try {
            Method method = messageType.getDeclaredMethod(GET_DEFAULT_INSTANCE_METHOD_NAME, new Class[0]);
            return (Message)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unable to get default instance for message class " + messageType.getName(), exception);
        }
    }

    private static Descriptors.Descriptor descriptorForType(Class<?> messageType) {
        return DescriptorMessageInfoFactory.getDefaultInstance(messageType).getDescriptorForType();
    }

    private static MessageInfo convert(Class<?> messageType, Descriptors.Descriptor messageDescriptor) {
        switch (messageDescriptor.getFile().getSyntax()) {
            case PROTO2: {
                return DescriptorMessageInfoFactory.convertProto2(messageType, messageDescriptor);
            }
            case PROTO3: {
                return DescriptorMessageInfoFactory.convertProto3(messageType, messageDescriptor);
            }
        }
        throw new IllegalArgumentException("Unsupported syntax: " + (Object)((Object)messageDescriptor.getFile().getSyntax()));
    }

    private static boolean needsIsInitializedCheck(Descriptors.Descriptor descriptor) {
        return isInitializedCheckAnalyzer.needsIsInitializedCheck(descriptor);
    }

    private static StructuralMessageInfo convertProto2(Class<?> messageType, Descriptors.Descriptor messageDescriptor) {
        List<Descriptors.FieldDescriptor> list = messageDescriptor.getFields();
        StructuralMessageInfo.Builder builder = StructuralMessageInfo.newBuilder(list.size());
        builder.withDefaultInstance(DescriptorMessageInfoFactory.getDefaultInstance(messageType));
        builder.withSyntax(ProtoSyntax.PROTO2);
        builder.withMessageSetWireFormat(messageDescriptor.getOptions().getMessageSetWireFormat());
        OneofState oneofState = new OneofState();
        int n2 = 0;
        int n3 = 1;
        Field field = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            final Descriptors.FieldDescriptor fieldDescriptor = list.get(i2);
            boolean bl = fieldDescriptor.getFile().getOptions().getJavaStringCheckUtf8();
            Internal.EnumVerifier enumVerifier = null;
            if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM) {
                enumVerifier = new Internal.EnumVerifier(){

                    @Override
                    public final boolean isInRange(int number) {
                        return fieldDescriptor.getEnumType().findValueByNumber(number) != null;
                    }
                };
            }
            if (fieldDescriptor.getContainingOneof() != null) {
                builder.withField(DescriptorMessageInfoFactory.buildOneofMember(messageType, fieldDescriptor, oneofState, bl, enumVerifier));
            } else {
                Field field2 = DescriptorMessageInfoFactory.field(messageType, fieldDescriptor);
                int n4 = fieldDescriptor.getNumber();
                FieldType fieldType = DescriptorMessageInfoFactory.getFieldType(fieldDescriptor);
                if (fieldDescriptor.isMapField()) {
                    final Descriptors.FieldDescriptor fieldDescriptor2 = fieldDescriptor.getMessageType().findFieldByNumber(2);
                    if (fieldDescriptor2.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM) {
                        enumVerifier = new Internal.EnumVerifier(){

                            @Override
                            public final boolean isInRange(int number) {
                                return fieldDescriptor2.getEnumType().findValueByNumber(number) != null;
                            }
                        };
                    }
                    builder.withField(FieldInfo.forMapField(field2, n4, SchemaUtil.getMapDefaultEntry(messageType, fieldDescriptor.getName()), enumVerifier));
                    continue;
                }
                if (fieldDescriptor.isRepeated()) {
                    if (enumVerifier != null) {
                        if (fieldDescriptor.isPacked()) {
                            builder.withField(FieldInfo.forPackedFieldWithEnumVerifier(field2, n4, fieldType, enumVerifier, DescriptorMessageInfoFactory.cachedSizeField(messageType, fieldDescriptor)));
                            continue;
                        }
                        builder.withField(FieldInfo.forFieldWithEnumVerifier(field2, n4, fieldType, enumVerifier));
                        continue;
                    }
                    if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                        builder.withField(FieldInfo.forRepeatedMessageField(field2, n4, fieldType, DescriptorMessageInfoFactory.getTypeForRepeatedMessageField(messageType, fieldDescriptor)));
                        continue;
                    }
                    if (fieldDescriptor.isPacked()) {
                        builder.withField(FieldInfo.forPackedField(field2, n4, fieldType, DescriptorMessageInfoFactory.cachedSizeField(messageType, fieldDescriptor)));
                        continue;
                    }
                    builder.withField(FieldInfo.forField(field2, n4, fieldType, bl));
                    continue;
                }
                if (field == null) {
                    field = DescriptorMessageInfoFactory.bitField(messageType, n2);
                }
                if (fieldDescriptor.isRequired()) {
                    builder.withField(FieldInfo.forProto2RequiredField(field2, n4, fieldType, field, n3, bl, enumVerifier));
                } else {
                    builder.withField(FieldInfo.forProto2OptionalField(field2, n4, fieldType, field, n3, bl, enumVerifier));
                }
            }
            if ((n3 <<= 1) != 0) continue;
            field = null;
            n3 = 1;
            ++n2;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i3 = 0; i3 < list.size(); ++i3) {
            Descriptors.FieldDescriptor fieldDescriptor = list.get(i3);
            if (!fieldDescriptor.isRequired() && (fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE || !DescriptorMessageInfoFactory.needsIsInitializedCheck(fieldDescriptor.getMessageType()))) continue;
            arrayList.add(fieldDescriptor.getNumber());
        }
        int[] nArray = new int[arrayList.size()];
        for (int i4 = 0; i4 < arrayList.size(); ++i4) {
            nArray[i4] = (Integer)arrayList.get(i4);
        }
        builder.withCheckInitialized(nArray);
        return builder.build();
    }

    private static StructuralMessageInfo convertProto3(Class<?> messageType, Descriptors.Descriptor messageDescriptor) {
        List<Descriptors.FieldDescriptor> list = messageDescriptor.getFields();
        StructuralMessageInfo.Builder builder = StructuralMessageInfo.newBuilder(list.size());
        builder.withDefaultInstance(DescriptorMessageInfoFactory.getDefaultInstance(messageType));
        builder.withSyntax(ProtoSyntax.PROTO3);
        OneofState oneofState = new OneofState();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Descriptors.FieldDescriptor fieldDescriptor = list.get(i2);
            if (fieldDescriptor.getContainingOneof() != null && !fieldDescriptor.getContainingOneof().isSynthetic()) {
                builder.withField(DescriptorMessageInfoFactory.buildOneofMember(messageType, fieldDescriptor, oneofState, true, null));
                continue;
            }
            if (fieldDescriptor.isMapField()) {
                builder.withField(FieldInfo.forMapField(DescriptorMessageInfoFactory.field(messageType, fieldDescriptor), fieldDescriptor.getNumber(), SchemaUtil.getMapDefaultEntry(messageType, fieldDescriptor.getName()), null));
                continue;
            }
            if (fieldDescriptor.isRepeated() && fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                builder.withField(FieldInfo.forRepeatedMessageField(DescriptorMessageInfoFactory.field(messageType, fieldDescriptor), fieldDescriptor.getNumber(), DescriptorMessageInfoFactory.getFieldType(fieldDescriptor), DescriptorMessageInfoFactory.getTypeForRepeatedMessageField(messageType, fieldDescriptor)));
                continue;
            }
            if (fieldDescriptor.isPacked()) {
                builder.withField(FieldInfo.forPackedField(DescriptorMessageInfoFactory.field(messageType, fieldDescriptor), fieldDescriptor.getNumber(), DescriptorMessageInfoFactory.getFieldType(fieldDescriptor), DescriptorMessageInfoFactory.cachedSizeField(messageType, fieldDescriptor)));
                continue;
            }
            builder.withField(FieldInfo.forField(DescriptorMessageInfoFactory.field(messageType, fieldDescriptor), fieldDescriptor.getNumber(), DescriptorMessageInfoFactory.getFieldType(fieldDescriptor), true));
        }
        return builder.build();
    }

    private static FieldInfo buildOneofMember(Class<?> messageType, Descriptors.FieldDescriptor fd, OneofState oneofState, boolean enforceUtf8, Internal.EnumVerifier enumVerifier) {
        OneofInfo oneofInfo = oneofState.getOneof(messageType, fd.getContainingOneof());
        FieldType fieldType = DescriptorMessageInfoFactory.getFieldType(fd);
        Class<?> clazz = DescriptorMessageInfoFactory.getOneofStoredType(messageType, fd, fieldType);
        return FieldInfo.forOneofMemberField(fd.getNumber(), fieldType, oneofInfo, clazz, enforceUtf8, enumVerifier);
    }

    private static Class<?> getOneofStoredType(Class<?> messageType, Descriptors.FieldDescriptor fd, FieldType type) {
        switch (type.getJavaType()) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case BYTE_STRING: {
                return ByteString.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case ENUM: 
            case INT: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case STRING: {
                return String.class;
            }
            case MESSAGE: {
                return DescriptorMessageInfoFactory.getOneofStoredTypeForMessage(messageType, fd);
            }
        }
        throw new IllegalArgumentException("Invalid type for oneof: " + (Object)((Object)type));
    }

    private static FieldType getFieldType(Descriptors.FieldDescriptor fd) {
        switch (fd.getType()) {
            case BOOL: {
                if (!fd.isRepeated()) {
                    return FieldType.BOOL;
                }
                if (fd.isPacked()) {
                    return FieldType.BOOL_LIST_PACKED;
                }
                return FieldType.BOOL_LIST;
            }
            case BYTES: {
                if (fd.isRepeated()) {
                    return FieldType.BYTES_LIST;
                }
                return FieldType.BYTES;
            }
            case DOUBLE: {
                if (!fd.isRepeated()) {
                    return FieldType.DOUBLE;
                }
                if (fd.isPacked()) {
                    return FieldType.DOUBLE_LIST_PACKED;
                }
                return FieldType.DOUBLE_LIST;
            }
            case ENUM: {
                if (!fd.isRepeated()) {
                    return FieldType.ENUM;
                }
                if (fd.isPacked()) {
                    return FieldType.ENUM_LIST_PACKED;
                }
                return FieldType.ENUM_LIST;
            }
            case FIXED32: {
                if (!fd.isRepeated()) {
                    return FieldType.FIXED32;
                }
                if (fd.isPacked()) {
                    return FieldType.FIXED32_LIST_PACKED;
                }
                return FieldType.FIXED32_LIST;
            }
            case FIXED64: {
                if (!fd.isRepeated()) {
                    return FieldType.FIXED64;
                }
                if (fd.isPacked()) {
                    return FieldType.FIXED64_LIST_PACKED;
                }
                return FieldType.FIXED64_LIST;
            }
            case FLOAT: {
                if (!fd.isRepeated()) {
                    return FieldType.FLOAT;
                }
                if (fd.isPacked()) {
                    return FieldType.FLOAT_LIST_PACKED;
                }
                return FieldType.FLOAT_LIST;
            }
            case GROUP: {
                if (fd.isRepeated()) {
                    return FieldType.GROUP_LIST;
                }
                return FieldType.GROUP;
            }
            case INT32: {
                if (!fd.isRepeated()) {
                    return FieldType.INT32;
                }
                if (fd.isPacked()) {
                    return FieldType.INT32_LIST_PACKED;
                }
                return FieldType.INT32_LIST;
            }
            case INT64: {
                if (!fd.isRepeated()) {
                    return FieldType.INT64;
                }
                if (fd.isPacked()) {
                    return FieldType.INT64_LIST_PACKED;
                }
                return FieldType.INT64_LIST;
            }
            case MESSAGE: {
                if (fd.isMapField()) {
                    return FieldType.MAP;
                }
                if (fd.isRepeated()) {
                    return FieldType.MESSAGE_LIST;
                }
                return FieldType.MESSAGE;
            }
            case SFIXED32: {
                if (!fd.isRepeated()) {
                    return FieldType.SFIXED32;
                }
                if (fd.isPacked()) {
                    return FieldType.SFIXED32_LIST_PACKED;
                }
                return FieldType.SFIXED32_LIST;
            }
            case SFIXED64: {
                if (!fd.isRepeated()) {
                    return FieldType.SFIXED64;
                }
                if (fd.isPacked()) {
                    return FieldType.SFIXED64_LIST_PACKED;
                }
                return FieldType.SFIXED64_LIST;
            }
            case SINT32: {
                if (!fd.isRepeated()) {
                    return FieldType.SINT32;
                }
                if (fd.isPacked()) {
                    return FieldType.SINT32_LIST_PACKED;
                }
                return FieldType.SINT32_LIST;
            }
            case SINT64: {
                if (!fd.isRepeated()) {
                    return FieldType.SINT64;
                }
                if (fd.isPacked()) {
                    return FieldType.SINT64_LIST_PACKED;
                }
                return FieldType.SINT64_LIST;
            }
            case STRING: {
                if (fd.isRepeated()) {
                    return FieldType.STRING_LIST;
                }
                return FieldType.STRING;
            }
            case UINT32: {
                if (!fd.isRepeated()) {
                    return FieldType.UINT32;
                }
                if (fd.isPacked()) {
                    return FieldType.UINT32_LIST_PACKED;
                }
                return FieldType.UINT32_LIST;
            }
            case UINT64: {
                if (!fd.isRepeated()) {
                    return FieldType.UINT64;
                }
                if (fd.isPacked()) {
                    return FieldType.UINT64_LIST_PACKED;
                }
                return FieldType.UINT64_LIST;
            }
        }
        throw new IllegalArgumentException("Unsupported field type: " + (Object)((Object)fd.getType()));
    }

    private static Field bitField(Class<?> messageType, int index) {
        return DescriptorMessageInfoFactory.field(messageType, "bitField" + index + "_");
    }

    private static Field field(Class<?> messageType, Descriptors.FieldDescriptor fd) {
        return DescriptorMessageInfoFactory.field(messageType, DescriptorMessageInfoFactory.getFieldName(fd));
    }

    private static Field cachedSizeField(Class<?> messageType, Descriptors.FieldDescriptor fd) {
        return DescriptorMessageInfoFactory.field(messageType, DescriptorMessageInfoFactory.getCachedSizeFieldName(fd));
    }

    private static Field field(Class<?> messageType, String fieldName) {
        try {
            return messageType.getDeclaredField(fieldName);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unable to find field " + fieldName + " in message class " + messageType.getName());
        }
    }

    static String getFieldName(Descriptors.FieldDescriptor fd) {
        String string = fd.getType() == Descriptors.FieldDescriptor.Type.GROUP ? fd.getMessageType().getName() : fd.getName();
        String string2 = DescriptorMessageInfoFactory.snakeCaseToUpperCamelCase(string);
        String string3 = specialFieldNames.contains(string2) ? "__" : "_";
        return DescriptorMessageInfoFactory.snakeCaseToLowerCamelCase(string) + string3;
    }

    private static String getCachedSizeFieldName(Descriptors.FieldDescriptor fd) {
        return DescriptorMessageInfoFactory.snakeCaseToLowerCamelCase(fd.getName()) + "MemoizedSerializedSize";
    }

    private static String snakeCaseToLowerCamelCase(String snakeCase) {
        return DescriptorMessageInfoFactory.snakeCaseToCamelCase(snakeCase, false);
    }

    private static String snakeCaseToUpperCamelCase(String snakeCase) {
        return DescriptorMessageInfoFactory.snakeCaseToCamelCase(snakeCase, true);
    }

    private static String snakeCaseToCamelCase(String snakeCase, boolean capFirst) {
        StringBuilder stringBuilder = new StringBuilder(snakeCase.length() + 1);
        boolean bl = capFirst;
        for (int i2 = 0; i2 < snakeCase.length(); ++i2) {
            char c2 = snakeCase.charAt(i2);
            if (c2 == '_') {
                bl = true;
                continue;
            }
            if (Character.isDigit(c2)) {
                stringBuilder.append(c2);
                bl = true;
                continue;
            }
            if (bl) {
                stringBuilder.append(Character.toUpperCase(c2));
                bl = false;
                continue;
            }
            if (i2 == 0) {
                stringBuilder.append(Character.toLowerCase(c2));
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    private static Class<?> getOneofStoredTypeForMessage(Class<?> messageType, Descriptors.FieldDescriptor fd) {
        try {
            String string = fd.getType() == Descriptors.FieldDescriptor.Type.GROUP ? fd.getMessageType().getName() : fd.getName();
            Method method = messageType.getDeclaredMethod(DescriptorMessageInfoFactory.getterForField(string), new Class[0]);
            return method.getReturnType();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static Class<?> getTypeForRepeatedMessageField(Class<?> messageType, Descriptors.FieldDescriptor fd) {
        try {
            String string = fd.getType() == Descriptors.FieldDescriptor.Type.GROUP ? fd.getMessageType().getName() : fd.getName();
            Method method = messageType.getDeclaredMethod(DescriptorMessageInfoFactory.getterForField(string), Integer.TYPE);
            return method.getReturnType();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static String getterForField(String snakeCase) {
        String string = DescriptorMessageInfoFactory.snakeCaseToLowerCamelCase(snakeCase);
        StringBuilder stringBuilder = new StringBuilder("get");
        stringBuilder.append(Character.toUpperCase(string.charAt(0)));
        stringBuilder.append(string.substring(1, string.length()));
        return stringBuilder.toString();
    }

    private static final class OneofState {
        private OneofInfo[] oneofs = new OneofInfo[2];

        private OneofState() {
        }

        final OneofInfo getOneof(Class<?> messageType, Descriptors.OneofDescriptor desc) {
            OneofInfo oneofInfo;
            int n2 = desc.getIndex();
            if (n2 >= this.oneofs.length) {
                this.oneofs = Arrays.copyOf(this.oneofs, n2 << 1);
            }
            if ((oneofInfo = this.oneofs[n2]) == null) {
                this.oneofs[n2] = oneofInfo = OneofState.newInfo(messageType, desc);
            }
            return oneofInfo;
        }

        private static OneofInfo newInfo(Class<?> messageType, Descriptors.OneofDescriptor desc) {
            String string = DescriptorMessageInfoFactory.snakeCaseToLowerCamelCase(desc.getName());
            String string2 = string + "_";
            String string3 = string + "Case_";
            return new OneofInfo(desc.getIndex(), DescriptorMessageInfoFactory.field(messageType, string3), DescriptorMessageInfoFactory.field(messageType, string2));
        }
    }

    static class IsInitializedCheckAnalyzer {
        private final Map<Descriptors.Descriptor, Boolean> resultCache = new ConcurrentHashMap<Descriptors.Descriptor, Boolean>();
        private int index = 0;
        private final Stack<Node> stack = new Stack();
        private final Map<Descriptors.Descriptor, Node> nodeCache = new HashMap<Descriptors.Descriptor, Node>();

        IsInitializedCheckAnalyzer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean needsIsInitializedCheck(Descriptors.Descriptor descriptor) {
            Boolean bl = this.resultCache.get(descriptor);
            if (bl != null) {
                return bl;
            }
            IsInitializedCheckAnalyzer isInitializedCheckAnalyzer = this;
            synchronized (isInitializedCheckAnalyzer) {
                bl = this.resultCache.get(descriptor);
                if (bl != null) {
                    return bl;
                }
                return this.dfs((Descriptors.Descriptor)descriptor).component.needsIsInitializedCheck;
            }
        }

        private Node dfs(Descriptors.Descriptor descriptor) {
            Node node = new Node(descriptor, this.index++);
            this.stack.push(node);
            this.nodeCache.put(descriptor, node);
            for (Descriptors.FieldDescriptor object : descriptor.getFields()) {
                if (object.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
                Node node2 = this.nodeCache.get(object.getMessageType());
                if (node2 == null) {
                    node2 = this.dfs(object.getMessageType());
                    node.lowLink = Math.min(node.lowLink, node2.lowLink);
                    continue;
                }
                if (node2.component != null) continue;
                node.lowLink = Math.min(node.lowLink, node2.lowLink);
            }
            if (node.index == node.lowLink) {
                Node node3;
                StronglyConnectedComponent stronglyConnectedComponent = new StronglyConnectedComponent();
                do {
                    node3 = this.stack.pop();
                    this.stack.pop().component = stronglyConnectedComponent;
                    stronglyConnectedComponent.messages.add(node3.descriptor);
                } while (node3 != node);
                this.analyze(stronglyConnectedComponent);
            }
            return node;
        }

        private void analyze(StronglyConnectedComponent component) {
            boolean bl = false;
            block0: for (Descriptors.Descriptor descriptor : component.messages) {
                if (descriptor.isExtendable()) {
                    bl = true;
                    break;
                }
                for (Descriptors.FieldDescriptor fieldDescriptor : descriptor.getFields()) {
                    if (fieldDescriptor.isRequired()) {
                        bl = true;
                        break block0;
                    }
                    if (fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
                    Node node = this.nodeCache.get(fieldDescriptor.getMessageType());
                    if (node.component == component || !node.component.needsIsInitializedCheck) continue;
                    bl = true;
                    break block0;
                }
            }
            component.needsIsInitializedCheck = bl;
            for (Descriptors.Descriptor descriptor : component.messages) {
                this.resultCache.put(descriptor, component.needsIsInitializedCheck);
            }
        }

        private static class StronglyConnectedComponent {
            final List<Descriptors.Descriptor> messages = new ArrayList<Descriptors.Descriptor>();
            boolean needsIsInitializedCheck = false;

            private StronglyConnectedComponent() {
            }
        }

        private static class Node {
            final Descriptors.Descriptor descriptor;
            final int index;
            int lowLink;
            StronglyConnectedComponent component;

            Node(Descriptors.Descriptor descriptor, int index) {
                this.descriptor = descriptor;
                this.index = index;
                this.lowLink = index;
                this.component = null;
            }
        }
    }
}

