/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.gam;

import hex.genmodel.utils.ArrayUtils;
import java.util.ArrayList;

public class GamUtilsISplines {
    public static double[] fillKnots(double[] knots, int m2) {
        int numKnotsDup = knots.length + 2 * m2 - 2;
        double[] knotsNew = new double[numKnotsDup];
        int upperBound = m2 > 0 ? m2 - 1 : 0;
        for (int index = 0; index < upperBound; ++index) {
            knotsNew[index] = knots[0];
        }
        int knotLen = knots.length;
        for (int index = 0; index < knotLen; ++index) {
            knotsNew[index + upperBound] = knots[index];
        }
        double upperVal = knots[knots.length - 1];
        for (int index = knotLen + upperBound; index < numKnotsDup; ++index) {
            knotsNew[index] = upperVal;
        }
        return knotsNew;
    }

    public static double[] extractKnots(int index, int order, double[] knots) {
        double[] newKnots = new double[order + 1];
        int upperIndex = Math.min(index + order, knots.length - 1);
        int startIndex = 0;
        for (int counter = index; counter <= upperIndex; ++counter) {
            newKnots[startIndex++] = knots[counter];
        }
        return newKnots;
    }

    static double[] formDenominatorNSpline(int order, double[] knots) {
        double[] oneOverDenominator = new double[2];
        if (order == 1) {
            oneOverDenominator[0] = 1.0;
            oneOverDenominator[1] = 0.0;
        } else {
            double tempDenom = knots[order - 1] - knots[0];
            oneOverDenominator[0] = tempDenom == 0.0 ? 0.0 : 1.0 / tempDenom;
            tempDenom = knots[order] - knots[1];
            oneOverDenominator[1] = tempDenom == 0.0 ? 0.0 : 1.0 / tempDenom;
        }
        return oneOverDenominator;
    }

    static double[] formNumerator(int order, double[] knots) {
        double[] numerator = new double[2];
        if (order == 1) {
            numerator[0] = 1.0;
            numerator[1] = 0.0;
        } else {
            numerator[0] = knots[0];
            numerator[1] = knots[order];
        }
        return numerator;
    }

    static double[] formDenominatorMSpline(int order, double[] knots) {
        double[] oneOverDenominator = new double[2];
        if (order == 1) {
            oneOverDenominator[0] = 1.0;
            oneOverDenominator[1] = 0.0;
        } else {
            double tempDenom = knots[order] - knots[0];
            oneOverDenominator[0] = tempDenom == 0.0 ? 0.0 : 1.0 / tempDenom;
            tempDenom = knots[order] - knots[0];
            oneOverDenominator[1] = tempDenom == 0.0 ? 0.0 : 1.0 / tempDenom;
        }
        return oneOverDenominator;
    }

    public static double[] polynomialProduct(double[] coeff1, double[] coeff2) {
        int firstLen = coeff1.length;
        int secondLen = coeff2.length;
        int combinedLen = firstLen * secondLen;
        int[] firstOrder = ArrayUtils.arrayInitRange(firstLen, 0);
        int[] secondOrder = ArrayUtils.arrayInitRange(secondLen, 0);
        int highestOrder = firstLen + secondLen - 2;
        double[] combinedCoefficients = new double[highestOrder + 1];
        ArrayList<Double> combinedC = new ArrayList<Double>();
        ArrayList<Integer> combinedOrder = new ArrayList<Integer>();
        for (int firstIndex = 0; firstIndex < firstLen; ++firstIndex) {
            for (int secondIndex = 0; secondIndex < secondLen; ++secondIndex) {
                double tempValue = coeff1[firstIndex] * coeff2[secondIndex];
                combinedC.add(tempValue);
                int tempOrder = firstOrder[firstIndex] + secondOrder[secondIndex];
                combinedOrder.add(tempOrder);
            }
        }
        for (int index = 0; index < combinedLen; ++index) {
            int n2 = (Integer)combinedOrder.get(index);
            combinedCoefficients[n2] = combinedCoefficients[n2] + (Double)combinedC.get(index);
        }
        return combinedCoefficients;
    }

    public static void combineParentCoef(double[] parentCoeff, double parentConst, double[][] currCoeff) {
        int numBasis = currCoeff.length;
        double[] copyParentCoef = (double[])parentCoeff.clone();
        ArrayUtils.mult(copyParentCoef, parentConst);
        for (int index = 0; index < numBasis; ++index) {
            if (currCoeff[index] == null) continue;
            currCoeff[index] = GamUtilsISplines.polynomialProduct(copyParentCoef, currCoeff[index]);
        }
    }

    public static void sumCoeffs(double[][] leftCoeffs, double[][] riteCoeffs, double[][] currCoeffs) {
        int knotInt = leftCoeffs.length;
        for (int index = 0; index < knotInt; ++index) {
            double[] leftCoef1 = leftCoeffs[index];
            double[] riteCoef1 = riteCoeffs[index];
            if (leftCoef1 == null && riteCoef1 == null) continue;
            currCoeffs[index] = leftCoef1 != null && riteCoef1 != null ? GamUtilsISplines.addCoeffs(leftCoef1, riteCoef1) : (leftCoef1 != null ? (double[])leftCoef1.clone() : (double[])riteCoef1.clone());
        }
    }

    public static double[] addCoeffs(double[] leftCoef, double[] riteCoef) {
        int leftLen = leftCoef.length;
        int riteLen = riteCoef.length;
        int coeffLen = Math.max(leftLen, riteLen);
        double[] sumCoeffs = new double[coeffLen];
        for (int index = 0; index < coeffLen; ++index) {
            double val = 0.0;
            if (index < leftLen) {
                val += leftCoef[index];
            }
            if (index < riteLen) {
                val += riteCoef[index];
            }
            sumCoeffs[index] = val;
        }
        return sumCoeffs;
    }
}

