/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.ByteString;
import ai.h2o.com.google.protobuf.CanIgnoreReturnValue;
import ai.h2o.com.google.protobuf.CheckReturnValue;
import ai.h2o.com.google.protobuf.CodedOutputStream;
import ai.h2o.com.google.protobuf.ExtensionSchema;
import ai.h2o.com.google.protobuf.FieldInfo;
import ai.h2o.com.google.protobuf.FieldSet;
import ai.h2o.com.google.protobuf.GeneratedMessageLite;
import ai.h2o.com.google.protobuf.IntArrayList;
import ai.h2o.com.google.protobuf.Internal;
import ai.h2o.com.google.protobuf.LazyFieldLite;
import ai.h2o.com.google.protobuf.LazyStringList;
import ai.h2o.com.google.protobuf.LongArrayList;
import ai.h2o.com.google.protobuf.MapFieldSchema;
import ai.h2o.com.google.protobuf.MessageLite;
import ai.h2o.com.google.protobuf.Schema;
import ai.h2o.com.google.protobuf.UnknownFieldSchema;
import ai.h2o.com.google.protobuf.UnknownFieldSetLiteSchema;
import ai.h2o.com.google.protobuf.UnsafeUtil;
import ai.h2o.com.google.protobuf.Writer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

@CheckReturnValue
final class SchemaUtil {
    private static final Class<?> GENERATED_MESSAGE_CLASS = SchemaUtil.getGeneratedMessageClass();
    private static final UnknownFieldSchema<?, ?> PROTO2_UNKNOWN_FIELD_SET_SCHEMA = SchemaUtil.getUnknownFieldSetSchema(false);
    private static final UnknownFieldSchema<?, ?> PROTO3_UNKNOWN_FIELD_SET_SCHEMA = SchemaUtil.getUnknownFieldSetSchema(true);
    private static final UnknownFieldSchema<?, ?> UNKNOWN_FIELD_SET_LITE_SCHEMA = new UnknownFieldSetLiteSchema();
    private static final int DEFAULT_LOOK_UP_START_NUMBER = 40;

    private SchemaUtil() {
    }

    public static void requireGeneratedMessage(Class<?> messageType) {
        if (!GeneratedMessageLite.class.isAssignableFrom(messageType) && GENERATED_MESSAGE_CLASS != null && !GENERATED_MESSAGE_CLASS.isAssignableFrom(messageType)) {
            throw new IllegalArgumentException("Message classes must extend GeneratedMessageV3 or GeneratedMessageLite");
        }
    }

    public static void writeDouble(int fieldNumber, double value, Writer writer) throws IOException {
        if (Double.doubleToRawLongBits(value) != 0L) {
            writer.writeDouble(fieldNumber, value);
        }
    }

    public static void writeFloat(int fieldNumber, float value, Writer writer) throws IOException {
        if (Float.floatToRawIntBits(value) != 0) {
            writer.writeFloat(fieldNumber, value);
        }
    }

    public static void writeInt64(int fieldNumber, long value, Writer writer) throws IOException {
        if (value != 0L) {
            writer.writeInt64(fieldNumber, value);
        }
    }

    public static void writeUInt64(int fieldNumber, long value, Writer writer) throws IOException {
        if (value != 0L) {
            writer.writeUInt64(fieldNumber, value);
        }
    }

    public static void writeSInt64(int fieldNumber, long value, Writer writer) throws IOException {
        if (value != 0L) {
            writer.writeSInt64(fieldNumber, value);
        }
    }

    public static void writeFixed64(int fieldNumber, long value, Writer writer) throws IOException {
        if (value != 0L) {
            writer.writeFixed64(fieldNumber, value);
        }
    }

    public static void writeSFixed64(int fieldNumber, long value, Writer writer) throws IOException {
        if (value != 0L) {
            writer.writeSFixed64(fieldNumber, value);
        }
    }

    public static void writeInt32(int fieldNumber, int value, Writer writer) throws IOException {
        if (value != 0) {
            writer.writeInt32(fieldNumber, value);
        }
    }

    public static void writeUInt32(int fieldNumber, int value, Writer writer) throws IOException {
        if (value != 0) {
            writer.writeUInt32(fieldNumber, value);
        }
    }

    public static void writeSInt32(int fieldNumber, int value, Writer writer) throws IOException {
        if (value != 0) {
            writer.writeSInt32(fieldNumber, value);
        }
    }

    public static void writeFixed32(int fieldNumber, int value, Writer writer) throws IOException {
        if (value != 0) {
            writer.writeFixed32(fieldNumber, value);
        }
    }

    public static void writeSFixed32(int fieldNumber, int value, Writer writer) throws IOException {
        if (value != 0) {
            writer.writeSFixed32(fieldNumber, value);
        }
    }

    public static void writeEnum(int fieldNumber, int value, Writer writer) throws IOException {
        if (value != 0) {
            writer.writeEnum(fieldNumber, value);
        }
    }

    public static void writeBool(int fieldNumber, boolean value, Writer writer) throws IOException {
        if (value) {
            writer.writeBool(fieldNumber, true);
        }
    }

    public static void writeString(int fieldNumber, Object value, Writer writer) throws IOException {
        if (value instanceof String) {
            SchemaUtil.writeStringInternal(fieldNumber, (String)value, writer);
            return;
        }
        SchemaUtil.writeBytes(fieldNumber, (ByteString)value, writer);
    }

    private static void writeStringInternal(int fieldNumber, String value, Writer writer) throws IOException {
        if (value != null && !value.isEmpty()) {
            writer.writeString(fieldNumber, value);
        }
    }

    public static void writeBytes(int fieldNumber, ByteString value, Writer writer) throws IOException {
        if (value != null && !value.isEmpty()) {
            writer.writeBytes(fieldNumber, value);
        }
    }

    public static void writeMessage(int fieldNumber, Object value, Writer writer) throws IOException {
        if (value != null) {
            writer.writeMessage(fieldNumber, value);
        }
    }

    public static void writeDoubleList(int fieldNumber, List<Double> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            writer.writeDoubleList(fieldNumber, value, packed);
        }
    }

    public static void writeFloatList(int fieldNumber, List<Float> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            writer.writeFloatList(fieldNumber, value, packed);
        }
    }

    public static void writeInt64List(int fieldNumber, List<Long> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            writer.writeInt64List(fieldNumber, value, packed);
        }
    }

    public static void writeUInt64List(int fieldNumber, List<Long> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            writer.writeUInt64List(fieldNumber, value, packed);
        }
    }

    public static void writeSInt64List(int fieldNumber, List<Long> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            writer.writeSInt64List(fieldNumber, value, packed);
        }
    }

    public static void writeFixed64List(int fieldNumber, List<Long> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            writer.writeFixed64List(fieldNumber, value, packed);
        }
    }

    public static void writeSFixed64List(int fieldNumber, List<Long> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            writer.writeSFixed64List(fieldNumber, value, packed);
        }
    }

    public static void writeInt32List(int fieldNumber, List<Integer> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            writer.writeInt32List(fieldNumber, value, packed);
        }
    }

    public static void writeUInt32List(int fieldNumber, List<Integer> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            writer.writeUInt32List(fieldNumber, value, packed);
        }
    }

    public static void writeSInt32List(int fieldNumber, List<Integer> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            writer.writeSInt32List(fieldNumber, value, packed);
        }
    }

    public static void writeFixed32List(int fieldNumber, List<Integer> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            writer.writeFixed32List(fieldNumber, value, packed);
        }
    }

    public static void writeSFixed32List(int fieldNumber, List<Integer> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            writer.writeSFixed32List(fieldNumber, value, packed);
        }
    }

    public static void writeEnumList(int fieldNumber, List<Integer> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            writer.writeEnumList(fieldNumber, value, packed);
        }
    }

    public static void writeBoolList(int fieldNumber, List<Boolean> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            writer.writeBoolList(fieldNumber, value, packed);
        }
    }

    public static void writeStringList(int fieldNumber, List<String> value, Writer writer) throws IOException {
        if (value != null && !value.isEmpty()) {
            writer.writeStringList(fieldNumber, value);
        }
    }

    public static void writeBytesList(int fieldNumber, List<ByteString> value, Writer writer) throws IOException {
        if (value != null && !value.isEmpty()) {
            writer.writeBytesList(fieldNumber, value);
        }
    }

    public static void writeMessageList(int fieldNumber, List<?> value, Writer writer) throws IOException {
        if (value != null && !value.isEmpty()) {
            writer.writeMessageList(fieldNumber, value);
        }
    }

    public static void writeMessageList(int fieldNumber, List<?> value, Writer writer, Schema schema) throws IOException {
        if (value != null && !value.isEmpty()) {
            writer.writeMessageList(fieldNumber, value, schema);
        }
    }

    public static void writeLazyFieldList(int fieldNumber, List<?> value, Writer writer) throws IOException {
        if (value != null && !value.isEmpty()) {
            for (Object obj : value) {
                ((LazyFieldLite)obj).writeTo(writer, fieldNumber);
            }
        }
    }

    public static void writeGroupList(int fieldNumber, List<?> value, Writer writer) throws IOException {
        if (value != null && !value.isEmpty()) {
            writer.writeGroupList(fieldNumber, value);
        }
    }

    public static void writeGroupList(int fieldNumber, List<?> value, Writer writer, Schema schema) throws IOException {
        if (value != null && !value.isEmpty()) {
            writer.writeGroupList(fieldNumber, value, schema);
        }
    }

    static int computeSizeInt64ListNoTag(List<Long> list) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        if (list instanceof LongArrayList) {
            LongArrayList longArrayList = (LongArrayList)list;
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 += CodedOutputStream.computeInt64SizeNoTag(longArrayList.getLong(i2));
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                n3 += CodedOutputStream.computeInt64SizeNoTag(list.get(i3));
            }
        }
        return n3;
    }

    static int computeSizeInt64List(int fieldNumber, List<Long> list, boolean packed) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = SchemaUtil.computeSizeInt64ListNoTag(list);
        if (packed) {
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(n3);
        }
        return n3 + list.size() * CodedOutputStream.computeTagSize(fieldNumber);
    }

    static int computeSizeUInt64ListNoTag(List<Long> list) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        if (list instanceof LongArrayList) {
            LongArrayList longArrayList = (LongArrayList)list;
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 += CodedOutputStream.computeUInt64SizeNoTag(longArrayList.getLong(i2));
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                n3 += CodedOutputStream.computeUInt64SizeNoTag(list.get(i3));
            }
        }
        return n3;
    }

    static int computeSizeUInt64List(int fieldNumber, List<Long> list, boolean packed) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = SchemaUtil.computeSizeUInt64ListNoTag(list);
        if (packed) {
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(n3);
        }
        return n3 + n2 * CodedOutputStream.computeTagSize(fieldNumber);
    }

    static int computeSizeSInt64ListNoTag(List<Long> list) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        if (list instanceof LongArrayList) {
            LongArrayList longArrayList = (LongArrayList)list;
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 += CodedOutputStream.computeSInt64SizeNoTag(longArrayList.getLong(i2));
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                n3 += CodedOutputStream.computeSInt64SizeNoTag(list.get(i3));
            }
        }
        return n3;
    }

    static int computeSizeSInt64List(int fieldNumber, List<Long> list, boolean packed) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = SchemaUtil.computeSizeSInt64ListNoTag(list);
        if (packed) {
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(n3);
        }
        return n3 + n2 * CodedOutputStream.computeTagSize(fieldNumber);
    }

    static int computeSizeEnumListNoTag(List<Integer> list) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        if (list instanceof IntArrayList) {
            IntArrayList intArrayList = (IntArrayList)list;
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 += CodedOutputStream.computeEnumSizeNoTag(intArrayList.getInt(i2));
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                n3 += CodedOutputStream.computeEnumSizeNoTag(list.get(i3));
            }
        }
        return n3;
    }

    static int computeSizeEnumList(int fieldNumber, List<Integer> list, boolean packed) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = SchemaUtil.computeSizeEnumListNoTag(list);
        if (packed) {
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(n3);
        }
        return n3 + n2 * CodedOutputStream.computeTagSize(fieldNumber);
    }

    static int computeSizeInt32ListNoTag(List<Integer> list) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        if (list instanceof IntArrayList) {
            IntArrayList intArrayList = (IntArrayList)list;
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 += CodedOutputStream.computeInt32SizeNoTag(intArrayList.getInt(i2));
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                n3 += CodedOutputStream.computeInt32SizeNoTag(list.get(i3));
            }
        }
        return n3;
    }

    static int computeSizeInt32List(int fieldNumber, List<Integer> list, boolean packed) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = SchemaUtil.computeSizeInt32ListNoTag(list);
        if (packed) {
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(n3);
        }
        return n3 + n2 * CodedOutputStream.computeTagSize(fieldNumber);
    }

    static int computeSizeUInt32ListNoTag(List<Integer> list) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        if (list instanceof IntArrayList) {
            IntArrayList intArrayList = (IntArrayList)list;
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 += CodedOutputStream.computeUInt32SizeNoTag(intArrayList.getInt(i2));
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                n3 += CodedOutputStream.computeUInt32SizeNoTag(list.get(i3));
            }
        }
        return n3;
    }

    static int computeSizeUInt32List(int fieldNumber, List<Integer> list, boolean packed) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = SchemaUtil.computeSizeUInt32ListNoTag(list);
        if (packed) {
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(n3);
        }
        return n3 + n2 * CodedOutputStream.computeTagSize(fieldNumber);
    }

    static int computeSizeSInt32ListNoTag(List<Integer> list) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        if (list instanceof IntArrayList) {
            IntArrayList intArrayList = (IntArrayList)list;
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 += CodedOutputStream.computeSInt32SizeNoTag(intArrayList.getInt(i2));
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                n3 += CodedOutputStream.computeSInt32SizeNoTag(list.get(i3));
            }
        }
        return n3;
    }

    static int computeSizeSInt32List(int fieldNumber, List<Integer> list, boolean packed) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = SchemaUtil.computeSizeSInt32ListNoTag(list);
        if (packed) {
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(n3);
        }
        return n3 + n2 * CodedOutputStream.computeTagSize(fieldNumber);
    }

    static int computeSizeFixed32ListNoTag(List<?> list) {
        return list.size() << 2;
    }

    static int computeSizeFixed32List(int fieldNumber, List<?> list, boolean packed) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        if (packed) {
            int n3 = n2 << 2;
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(n3);
        }
        return n2 * CodedOutputStream.computeFixed32Size(fieldNumber, 0);
    }

    static int computeSizeFixed64ListNoTag(List<?> list) {
        return list.size() << 3;
    }

    static int computeSizeFixed64List(int fieldNumber, List<?> list, boolean packed) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        if (packed) {
            int n3 = n2 << 3;
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(n3);
        }
        return n2 * CodedOutputStream.computeFixed64Size(fieldNumber, 0L);
    }

    static int computeSizeBoolListNoTag(List<?> list) {
        return list.size();
    }

    static int computeSizeBoolList(int fieldNumber, List<?> list, boolean packed) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        if (packed) {
            return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(n2);
        }
        return n2 * CodedOutputStream.computeBoolSize(fieldNumber, true);
    }

    static int computeSizeStringList(int fieldNumber, List<?> list) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = n2 * CodedOutputStream.computeTagSize(fieldNumber);
        if (list instanceof LazyStringList) {
            LazyStringList lazyStringList = (LazyStringList)list;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = lazyStringList.getRaw(i2);
                if (object instanceof ByteString) {
                    n3 += CodedOutputStream.computeBytesSizeNoTag((ByteString)object);
                    continue;
                }
                n3 += CodedOutputStream.computeStringSizeNoTag((String)object);
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                Object obj = list.get(i3);
                if (obj instanceof ByteString) {
                    n3 += CodedOutputStream.computeBytesSizeNoTag((ByteString)obj);
                    continue;
                }
                n3 += CodedOutputStream.computeStringSizeNoTag((String)obj);
            }
        }
        return n3;
    }

    static int computeSizeMessage(int fieldNumber, Object value, Schema schema) {
        if (value instanceof LazyFieldLite) {
            return CodedOutputStream.computeLazyFieldSize(fieldNumber, (LazyFieldLite)value);
        }
        return CodedOutputStream.computeMessageSize(fieldNumber, (MessageLite)value, schema);
    }

    static int computeSizeMessageList(int fieldNumber, List<?> list) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = n2 * CodedOutputStream.computeTagSize(fieldNumber);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object obj = list.get(i2);
            if (obj instanceof LazyFieldLite) {
                n3 += CodedOutputStream.computeLazyFieldSizeNoTag((LazyFieldLite)obj);
                continue;
            }
            n3 += CodedOutputStream.computeMessageSizeNoTag((MessageLite)obj);
        }
        return n3;
    }

    static int computeSizeMessageList(int fieldNumber, List<?> list, Schema schema) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = n2 * CodedOutputStream.computeTagSize(fieldNumber);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object obj = list.get(i2);
            if (obj instanceof LazyFieldLite) {
                n3 += CodedOutputStream.computeLazyFieldSizeNoTag((LazyFieldLite)obj);
                continue;
            }
            n3 += CodedOutputStream.computeMessageSizeNoTag((MessageLite)obj, schema);
        }
        return n3;
    }

    static int computeSizeByteStringList(int fieldNumber, List<ByteString> list) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = n2 * CodedOutputStream.computeTagSize(fieldNumber);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            n3 += CodedOutputStream.computeBytesSizeNoTag(list.get(i2));
        }
        return n3;
    }

    static int computeSizeGroupList(int fieldNumber, List<MessageLite> list) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 += CodedOutputStream.computeGroupSize(fieldNumber, list.get(i2));
        }
        return n3;
    }

    static int computeSizeGroupList(int fieldNumber, List<MessageLite> list, Schema schema) {
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 += CodedOutputStream.computeGroupSize(fieldNumber, list.get(i2), schema);
        }
        return n3;
    }

    public static boolean shouldUseTableSwitch(FieldInfo[] fields) {
        if (fields.length == 0) {
            return false;
        }
        int n2 = fields[0].getFieldNumber();
        int n3 = fields[fields.length - 1].getFieldNumber();
        return SchemaUtil.shouldUseTableSwitch(n2, n3, fields.length);
    }

    public static boolean shouldUseTableSwitch(int lo, int hi, int numFields) {
        if (hi < 40) {
            return true;
        }
        long l2 = (long)hi - (long)lo + 1L;
        long l3 = 3L + 2L * (long)numFields;
        long l4 = 3L + (long)numFields;
        return l2 + 9L <= l3 + 3L * l4;
    }

    public static UnknownFieldSchema<?, ?> proto2UnknownFieldSetSchema() {
        return PROTO2_UNKNOWN_FIELD_SET_SCHEMA;
    }

    public static UnknownFieldSchema<?, ?> proto3UnknownFieldSetSchema() {
        return PROTO3_UNKNOWN_FIELD_SET_SCHEMA;
    }

    public static UnknownFieldSchema<?, ?> unknownFieldSetLiteSchema() {
        return UNKNOWN_FIELD_SET_LITE_SCHEMA;
    }

    private static UnknownFieldSchema<?, ?> getUnknownFieldSetSchema(boolean proto3) {
        try {
            Class<?> clazz = SchemaUtil.getUnknownFieldSetSchemaClass();
            if (clazz == null) {
                return null;
            }
            return (UnknownFieldSchema)clazz.getConstructor(Boolean.TYPE).newInstance(proto3);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Class<?> getGeneratedMessageClass() {
        try {
            return Class.forName("ai.h2o.com.google.protobuf.GeneratedMessageV3");
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Class<?> getUnknownFieldSetSchemaClass() {
        try {
            return Class.forName("ai.h2o.com.google.protobuf.UnknownFieldSetSchema");
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    static Object getMapDefaultEntry(Class<?> clazz, String name) {
        try {
            Class<?> clazz2 = Class.forName(clazz.getName() + "$" + SchemaUtil.toCamelCase(name, true) + "DefaultEntryHolder");
            Field[] fieldArray = clazz2.getDeclaredFields();
            if (fieldArray.length != 1) {
                throw new IllegalStateException("Unable to look up map field default entry holder class for " + name + " in " + clazz.getName());
            }
            return UnsafeUtil.getStaticObject(fieldArray[0]);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    static String toCamelCase(String name, boolean capNext) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < name.length(); ++i2) {
            char c2 = name.charAt(i2);
            if ('a' <= c2 && c2 <= 'z') {
                if (capNext) {
                    stringBuilder.append((char)(c2 + -32));
                } else {
                    stringBuilder.append(c2);
                }
                capNext = false;
                continue;
            }
            if ('A' <= c2 && c2 <= 'Z') {
                if (i2 == 0 && !capNext) {
                    stringBuilder.append((char)(c2 - -32));
                } else {
                    stringBuilder.append(c2);
                }
                capNext = false;
                continue;
            }
            if ('0' <= c2 && c2 <= '9') {
                stringBuilder.append(c2);
            }
            capNext = true;
        }
        return stringBuilder.toString();
    }

    static boolean safeEquals(Object a2, Object b2) {
        return a2 == b2 || a2 != null && a2.equals(b2);
    }

    static <T> void mergeMap(MapFieldSchema mapFieldSchema, T message, T o2, long offset) {
        Object object = mapFieldSchema.mergeFrom(UnsafeUtil.getObject(message, offset), UnsafeUtil.getObject(o2, offset));
        UnsafeUtil.putObject(message, offset, object);
    }

    static <T, FT extends FieldSet.FieldDescriptorLite<FT>> void mergeExtensions(ExtensionSchema<FT> schema, T message, T other) {
        FieldSet<FT> fieldSet = schema.getExtensions(other);
        if (!fieldSet.isEmpty()) {
            FieldSet<FT> fieldSet2 = schema.getMutableExtensions(message);
            fieldSet2.mergeFrom(fieldSet);
        }
    }

    static <T, UT, UB> void mergeUnknownFields(UnknownFieldSchema<UT, UB> schema, T message, T other) {
        UT UT = schema.getFromMessage(message);
        UT UT2 = schema.getFromMessage(other);
        UT UT3 = schema.merge(UT, UT2);
        schema.setToMessage(message, UT3);
    }

    @CanIgnoreReturnValue
    static <UT, UB> UB filterUnknownEnumList(Object containerMessage, int number, List<Integer> enumList, Internal.EnumLiteMap<?> enumMap, UB unknownFields, UnknownFieldSchema<UT, UB> unknownFieldSchema) {
        if (enumMap == null) {
            return unknownFields;
        }
        if (enumList instanceof RandomAccess) {
            int n2 = 0;
            int n3 = enumList.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = enumList.get(i2);
                if (enumMap.findValueByNumber(n4) != null) {
                    if (i2 != n2) {
                        enumList.set(n2, n4);
                    }
                    ++n2;
                    continue;
                }
                unknownFields = SchemaUtil.storeUnknownEnum(containerMessage, number, n4, unknownFields, unknownFieldSchema);
            }
            if (n2 != n3) {
                enumList.subList(n2, n3).clear();
            }
        } else {
            Iterator<Integer> iterator = enumList.iterator();
            while (iterator.hasNext()) {
                int n5 = iterator.next();
                if (enumMap.findValueByNumber(n5) != null) continue;
                unknownFields = SchemaUtil.storeUnknownEnum(containerMessage, number, n5, unknownFields, unknownFieldSchema);
                iterator.remove();
            }
        }
        return unknownFields;
    }

    @CanIgnoreReturnValue
    static <UT, UB> UB filterUnknownEnumList(Object containerMessage, int number, List<Integer> enumList, Internal.EnumVerifier enumVerifier, UB unknownFields, UnknownFieldSchema<UT, UB> unknownFieldSchema) {
        if (enumVerifier == null) {
            return unknownFields;
        }
        if (enumList instanceof RandomAccess) {
            int n2 = 0;
            int n3 = enumList.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = enumList.get(i2);
                if (enumVerifier.isInRange(n4)) {
                    if (i2 != n2) {
                        enumList.set(n2, n4);
                    }
                    ++n2;
                    continue;
                }
                unknownFields = SchemaUtil.storeUnknownEnum(containerMessage, number, n4, unknownFields, unknownFieldSchema);
            }
            if (n2 != n3) {
                enumList.subList(n2, n3).clear();
            }
        } else {
            Iterator<Integer> iterator = enumList.iterator();
            while (iterator.hasNext()) {
                int n5 = iterator.next();
                if (enumVerifier.isInRange(n5)) continue;
                unknownFields = SchemaUtil.storeUnknownEnum(containerMessage, number, n5, unknownFields, unknownFieldSchema);
                iterator.remove();
            }
        }
        return unknownFields;
    }

    @CanIgnoreReturnValue
    static <UT, UB> UB storeUnknownEnum(Object containerMessage, int number, int enumValue, UB unknownFields, UnknownFieldSchema<UT, UB> unknownFieldSchema) {
        if (unknownFields == null) {
            unknownFields = unknownFieldSchema.getBuilderFromMessage(containerMessage);
        }
        unknownFieldSchema.addVarint(unknownFields, number, enumValue);
        return unknownFields;
    }
}

