"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTest = exports.IntegTestCaseStack = exports.IntegTestCase = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloud_assembly_schema_1 = require("@aws-cdk/cloud-assembly-schema");
const core_1 = require("@aws-cdk/core");
const deploy_assert_1 = require("./assertions/private/deploy-assert");
const manifest_synthesizer_1 = require("./manifest-synthesizer");
const TEST_CASE_STACK_SYMBOL = Symbol.for('@aws-cdk/integ-tests.IntegTestCaseStack');
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_2 = require("@aws-cdk/core");
/**
 * An integration test case. Allows the definition of test properties that
 * apply to all stacks under this case.
 *
 * It is recommended that you use the IntegTest construct since that will create
 * a default IntegTestCase
 */
class IntegTestCase extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_IntegTestCaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this._assert = new deploy_assert_1.DeployAssert(this);
        this.assertions = this._assert;
    }
    /**
     * The integration test manifest for this test case. Manifests are used
     * by the integration test runner.
     */
    get manifest() {
        return {
            version: cloud_assembly_schema_1.Manifest.version(),
            testCases: { [this.node.path]: this.toTestCase(this.props) },
        };
    }
    toTestCase(props) {
        return {
            ...props,
            assertionStack: this._assert.scope.artifactId,
            stacks: props.stacks.map(s => s.artifactId),
        };
    }
}
exports.IntegTestCase = IntegTestCase;
_a = JSII_RTTI_SYMBOL_1;
IntegTestCase[_a] = { fqn: "@aws-cdk/integ-tests.IntegTestCase", version: "1.159.0" };
/**
 * An integration test case stack. Allows the definition of test properties
 * that should apply to this stack.
 *
 * This should be used if there are multiple stacks in the integration test
 * and it is necessary to specify different test case option for each. Otherwise
 * normal stacks should be added to IntegTest
 */
class IntegTestCaseStack extends core_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_IntegTestCaseStackProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        Object.defineProperty(this, TEST_CASE_STACK_SYMBOL, { value: true });
        // TODO: should we only have a single DeployAssert per test?
        this.assertions = new deploy_assert_1.DeployAssert(this);
        this._testCase = new IntegTestCase(this, `${id}TestCase`, {
            ...props,
            stacks: [this],
        });
    }
    /**
     * Returns whether the construct is a IntegTestCaseStack
     */
    static isIntegTestCaseStack(x) {
        return x !== null && typeof (x) === 'object' && TEST_CASE_STACK_SYMBOL in x;
    }
}
exports.IntegTestCaseStack = IntegTestCaseStack;
_b = JSII_RTTI_SYMBOL_1;
IntegTestCaseStack[_b] = { fqn: "@aws-cdk/integ-tests.IntegTestCaseStack", version: "1.159.0" };
/**
 * A collection of test cases. Each test case file should contain exactly one
 * instance of this class.
 */
class IntegTest extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_IntegTestProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const defaultTestCase = new IntegTestCase(this, 'DefaultTest', {
            stacks: props.testCases.filter(stack => !IntegTestCaseStack.isIntegTestCaseStack(stack)),
            hooks: props.hooks,
            regions: props.regions,
            diffAssets: props.diffAssets,
            allowDestroy: props.allowDestroy,
            cdkCommandOptions: props.cdkCommandOptions,
            stackUpdateWorkflow: props.stackUpdateWorkflow,
        });
        this.assertions = defaultTestCase.assertions;
        this.testCases = [
            defaultTestCase,
            ...props.testCases
                .filter(stack => IntegTestCaseStack.isIntegTestCaseStack(stack))
                .map(stack => stack._testCase),
        ];
    }
    onPrepare() {
        core_1.attachCustomSynthesis(this, {
            onSynthesize: (session) => {
                const synthesizer = new manifest_synthesizer_1.IntegManifestSynthesizer(this.testCases);
                synthesizer.synthesize(session);
            },
        });
    }
}
exports.IntegTest = IntegTest;
_c = JSII_RTTI_SYMBOL_1;
IntegTest[_c] = { fqn: "@aws-cdk/integ-tests.IntegTest", version: "1.159.0" };
//# sourceMappingURL=data:application/json;base64,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