"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EqualsAssertion = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const providers_1 = require("./providers");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_2 = require("@aws-cdk/core");
/**
 * Construct that creates a CustomResource to assert that two
 * values are equal
 */
class EqualsAssertion extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_EqualsAssertionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const assertionProvider = new providers_1.AssertionsProvider(this, 'AssertionProvider');
        const properties = {
            actual: props.actual.result,
            expected: props.expected.result,
            failDeployment: props.failDeployment,
        };
        const resource = new core_1.CustomResource(this, 'Default', {
            serviceToken: assertionProvider.serviceToken,
            properties: {
                ...properties,
                salt: Date.now().toString(),
            },
            resourceType: providers_1.ASSERT_RESOURCE_TYPE,
        });
        this.result = resource.getAttString('data');
        new core_1.CfnOutput(this, 'AssertionResults', {
            value: this.result,
        }).overrideLogicalId(`AssertionResults${id}`);
    }
}
exports.EqualsAssertion = EqualsAssertion;
_a = JSII_RTTI_SYMBOL_1;
EqualsAssertion[_a] = { fqn: "@aws-cdk/integ-tests.EqualsAssertion", version: "1.159.0" };
//# sourceMappingURL=data:application/json;base64,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