"""Декораторы"""

import sys
sys.path.append('../')
import logging
import logs.config_server_log
import logs.config_client_log

# Метод определения модуля, источника запуска.
# Метод find () возвращает индекс первого вхождения искомой подстроки,
# если он найден в данной строке.
# Если его не найдено, - возвращает -1.


def log(func_to_log):
    """Функция-декоратор
    для логирования запущенных функций
    """
    def log_saver(*args, **kwargs):
        logger_name = 'server' if 'server_start.py' in sys.argv[0] else 'client'
        LOGGER = logging.getLogger(logger_name)

        LOGGER.debug(f'Была вызвана функция {func_to_log.__name__} c параметрами {args}, {kwargs}. '
                     f'Вызов из модуля {func_to_log.__module__}')
        ret = func_to_log(*args, **kwargs)
        return ret
    return log_saver
