#
# PySNMP MIB module RMON-MIB (http://snmplabs.com/pysmi)
# ASN.1 source file://data/mibs/RMON-MIB
# Produced by pysmi-0.3.4 at Tue Jan 28 12:32:04 2020
# On host nerk platform Linux version 5.3.15-300.fc31.x86_64 by user spider
# Using Python version 3.7.5 (default, Oct 17 2019, 12:16:48) 
#
Integer, ObjectIdentifier, OctetString = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
NamedValues, = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
ValueSizeConstraint, SingleValueConstraint, ConstraintsUnion, ValueRangeConstraint, ConstraintsIntersection = mibBuilder.importSymbols("ASN1-REFINEMENT", "ValueSizeConstraint", "SingleValueConstraint", "ConstraintsUnion", "ValueRangeConstraint", "ConstraintsIntersection")
ObjectGroup, ModuleCompliance, NotificationGroup = mibBuilder.importSymbols("SNMPv2-CONF", "ObjectGroup", "ModuleCompliance", "NotificationGroup")
Bits, ModuleIdentity, MibScalar, MibTable, MibTableRow, MibTableColumn, Gauge32, ObjectIdentity, iso, TimeTicks, Counter64, NotificationType, Integer32, Counter32, Unsigned32, IpAddress, mib_2, MibIdentifier = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "ModuleIdentity", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "Gauge32", "ObjectIdentity", "iso", "TimeTicks", "Counter64", "NotificationType", "Integer32", "Counter32", "Unsigned32", "IpAddress", "mib-2", "MibIdentifier")
TextualConvention, DisplayString = mibBuilder.importSymbols("SNMPv2-TC", "TextualConvention", "DisplayString")
rmonMibModule = ModuleIdentity((1, 3, 6, 1, 2, 1, 16, 20, 8))
rmonMibModule.setRevisions(('2000-05-11 00:00', '1995-02-01 00:00', '1991-11-01 00:00',))

if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    if mibBuilder.loadTexts: rmonMibModule.setRevisionsDescriptions(('Reformatted into SMIv2 format. This version published as RFC 2819.', "Bug fixes, clarifications and minor changes based on implementation experience, published as RFC1757 [18]. Two changes were made to object definitions: 1) A new status bit has been defined for the captureBufferPacketStatus object, indicating that the packet order within the capture buffer may not be identical to the packet order as received off the wire. This bit may only be used for packets transmitted by the probe. Older NMS applications can safely ignore this status bit, which might be used by newer agents. 2) The packetMatch trap has been removed. This trap was never actually 'approved' and was not added to this document along with the risingAlarm and fallingAlarm traps. The packetMatch trap could not be throttled, which could cause disruption of normal network traffic under some circumstances. An NMS should configure a risingAlarm threshold on the appropriate channelMatches instance if a trap is desired for a packetMatch event. Note that logging of packetMatch events is still supported--only trap generation for such events has been removed. In addition, several clarifications to individual object definitions have been added to assist agent and NMS implementors: - global definition of 'good packets' and 'bad packets' - more detailed text governing conceptual row creation and modification - instructions for probes relating to interface changes and disruptions - clarification of some ethernet counter definitions - recommended formula for calculating network utilization - clarification of channel and captureBuffer behavior for some unusual conditions - examples of proper instance naming for each table", 'The original version of this MIB, published as RFC1271.',))
if mibBuilder.loadTexts: rmonMibModule.setLastUpdated('200005110000Z')
if mibBuilder.loadTexts: rmonMibModule.setOrganization('IETF RMON MIB Working Group')
if mibBuilder.loadTexts: rmonMibModule.setContactInfo('Steve Waldbusser Phone: +1-650-948-6500 Fax: +1-650-745-0671 Email: waldbusser@nextbeacon.com')
if mibBuilder.loadTexts: rmonMibModule.setDescription('Remote network monitoring devices, often called monitors or probes, are instruments that exist for the purpose of managing a network. This MIB defines objects for managing remote network monitoring devices.')
rmon = MibIdentifier((1, 3, 6, 1, 2, 1, 16))
class OwnerString(TextualConvention, OctetString):
    description = "This data type is used to model an administratively assigned name of the owner of a resource. Implementations must accept values composed of well-formed NVT ASCII sequences. In addition, implementations should accept values composed of well-formed UTF-8 sequences. It is suggested that this name contain one or more of the following: IP address, management station name, network manager's name, location, or phone number. In some cases the agent itself will be the owner of an entry. In these cases, this string shall be set to a string starting with 'monitor'. SNMP access control is articulated entirely in terms of the contents of MIB views; access to a particular SNMP object instance depends only upon its presence or absence in a particular MIB view and never upon its value or the value of related object instances. Thus, objects of this type afford resolution of resource contention only among cooperating managers; they realize no access control function with respect to uncooperative parties."
    status = 'current'
    subtypeSpec = OctetString.subtypeSpec + ValueSizeConstraint(0, 127)

class EntryStatus(TextualConvention, Integer32):
    description = 'The status of a table entry. Setting this object to the value invalid(4) has the effect of invalidating the corresponding entry. That is, it effectively disassociates the mapping identified with said entry. It is an implementation-specific matter as to whether the agent removes an invalidated entry from the table. Accordingly, management stations must be prepared to receive tabular information from agents that corresponds to entries currently not in use. Proper interpretation of such entries requires examination of the relevant EntryStatus object. An existing instance of this object cannot be set to createRequest(2). This object may only be set to createRequest(2) when this instance is created. When this object is created, the agent may wish to create supplemental object instances with default values to complete a conceptual row in this table. Because the creation of these default objects is entirely at the option of the agent, the manager must not assume that any will be created, but may make use of any that are created. Immediately after completing the create operation, the agent must set this object to underCreation(3). When in the underCreation(3) state, an entry is allowed to exist in a possibly incomplete, possibly inconsistent state, usually to allow it to be modified in multiple PDUs. When in this state, an entry is not fully active. Entries shall exist in the underCreation(3) state until the management station is finished configuring the entry and sets this object to valid(1) or aborts, setting this object to invalid(4). If the agent determines that an entry has been in the underCreation(3) state for an abnormally long time, it may decide that the management station has crashed. If the agent makes this decision, it may set this object to invalid(4) to reclaim the entry. A prudent agent will understand that the management station may need to wait for human input and will allow for that possibility in its determination of this abnormally long period. An entry in the valid(1) state is fully configured and consistent and fully represents the configuration or operation such a row is intended to represent. For example, it could be a statistical function that is configured and active, or a filter that is available in the list of filters processed by the packet capture process. A manager is restricted to changing the state of an entry in the following ways: To: valid createRequest underCreation invalid From: valid OK NO OK OK createRequest N/A N/A N/A N/A underCreation OK NO OK OK invalid NO NO NO OK nonExistent NO OK NO OK In the table above, it is not applicable to move the state from the createRequest state to any other state because the manager will never find the variable in that state. The nonExistent state is not a value of the enumeration, rather it means that the entryStatus variable does not exist at all. An agent may allow an entryStatus variable to change state in additional ways, so long as the semantics of the states are followed. This allowance is made to ease the implementation of the agent and is made despite the fact that managers should never exercise these additional state transitions.'
    status = 'current'
    subtypeSpec = Integer32.subtypeSpec + ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4))
    namedValues = NamedValues(("valid", 1), ("createRequest", 2), ("underCreation", 3), ("invalid", 4))

statistics = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 1))
history = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 2))
alarm = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 3))
hosts = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 4))
hostTopN = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 5))
matrix = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 6))
filter = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 7))
capture = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 8))
event = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 9))
rmonConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 20))
etherStatsTable = MibTable((1, 3, 6, 1, 2, 1, 16, 1, 1), )
if mibBuilder.loadTexts: etherStatsTable.setStatus('current')
if mibBuilder.loadTexts: etherStatsTable.setDescription('A list of Ethernet statistics entries.')
etherStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 1, 1, 1), ).setIndexNames((0, "RMON-MIB", "etherStatsIndex"))
if mibBuilder.loadTexts: etherStatsEntry.setStatus('current')
if mibBuilder.loadTexts: etherStatsEntry.setDescription('A collection of statistics kept for a particular Ethernet interface. As an example, an instance of the etherStatsPkts object might be named etherStatsPkts.1')
etherStatsIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsIndex.setStatus('current')
if mibBuilder.loadTexts: etherStatsIndex.setDescription('The value of this object uniquely identifies this etherStats entry.')
etherStatsDataSource = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 2), ObjectIdentifier()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: etherStatsDataSource.setStatus('current')
if mibBuilder.loadTexts: etherStatsDataSource.setDescription('This object identifies the source of the data that this etherStats entry is configured to analyze. This source can be any ethernet interface on this device. In order to identify a particular interface, this object shall identify the instance of the ifIndex object, defined in RFC 2233 [17], for the desired interface. For example, if an entry were to receive data from interface #1, this object would be set to ifIndex.1. The statistics in this group reflect all packets on the local network segment attached to the identified interface. An agent may or may not be able to tell if fundamental changes to the media of the interface have occurred and necessitate an invalidation of this entry. For example, a hot-pluggable ethernet card could be pulled out and replaced by a token-ring card. In such a case, if the agent has such knowledge of the change, it is recommended that it invalidate this entry. This object may not be modified if the associated etherStatsStatus object is equal to valid(1).')
etherStatsDropEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsDropEvents.setStatus('current')
if mibBuilder.loadTexts: etherStatsDropEvents.setDescription('The total number of events in which packets were dropped by the probe due to lack of resources. Note that this number is not necessarily the number of packets dropped; it is just the number of times this condition has been detected.')
etherStatsOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 4), Counter32()).setUnits('Octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsOctets.setStatus('current')
if mibBuilder.loadTexts: etherStatsOctets.setDescription('The total number of octets of data (including those in bad packets) received on the network (excluding framing bits but including FCS octets). This object can be used as a reasonable estimate of 10-Megabit ethernet utilization. If greater precision is desired, the etherStatsPkts and etherStatsOctets objects should be sampled before and after a common interval. The differences in the sampled values are Pkts and Octets, respectively, and the number of seconds in the interval is Interval. These values are used to calculate the Utilization as follows: Pkts * (9.6 + 6.4) + (Octets * .8) Utilization = ------------------------------------- Interval * 10,000 The result of this equation is the value Utilization which is the percent utilization of the ethernet segment on a scale of 0 to 100 percent.')
etherStatsPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 5), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsPkts.setStatus('current')
if mibBuilder.loadTexts: etherStatsPkts.setDescription('The total number of packets (including bad packets, broadcast packets, and multicast packets) received.')
etherStatsBroadcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 6), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsBroadcastPkts.setStatus('current')
if mibBuilder.loadTexts: etherStatsBroadcastPkts.setDescription('The total number of good packets received that were directed to the broadcast address. Note that this does not include multicast packets.')
etherStatsMulticastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 7), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsMulticastPkts.setStatus('current')
if mibBuilder.loadTexts: etherStatsMulticastPkts.setDescription('The total number of good packets received that were directed to a multicast address. Note that this number does not include packets directed to the broadcast address.')
etherStatsCRCAlignErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 8), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsCRCAlignErrors.setStatus('current')
if mibBuilder.loadTexts: etherStatsCRCAlignErrors.setDescription('The total number of packets received that had a length (excluding framing bits, but including FCS octets) of between 64 and 1518 octets, inclusive, but had either a bad Frame Check Sequence (FCS) with an integral number of octets (FCS Error) or a bad FCS with a non-integral number of octets (Alignment Error).')
etherStatsUndersizePkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 9), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsUndersizePkts.setStatus('current')
if mibBuilder.loadTexts: etherStatsUndersizePkts.setDescription('The total number of packets received that were less than 64 octets long (excluding framing bits, but including FCS octets) and were otherwise well formed.')
etherStatsOversizePkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 10), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsOversizePkts.setStatus('current')
if mibBuilder.loadTexts: etherStatsOversizePkts.setDescription('The total number of packets received that were longer than 1518 octets (excluding framing bits, but including FCS octets) and were otherwise well formed.')
etherStatsFragments = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 11), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsFragments.setStatus('current')
if mibBuilder.loadTexts: etherStatsFragments.setDescription('The total number of packets received that were less than 64 octets in length (excluding framing bits but including FCS octets) and had either a bad Frame Check Sequence (FCS) with an integral number of octets (FCS Error) or a bad FCS with a non-integral number of octets (Alignment Error). Note that it is entirely normal for etherStatsFragments to increment. This is because it counts both runts (which are normal occurrences due to collisions) and noise hits.')
etherStatsJabbers = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 12), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsJabbers.setStatus('current')
if mibBuilder.loadTexts: etherStatsJabbers.setDescription('The total number of packets received that were longer than 1518 octets (excluding framing bits, but including FCS octets), and had either a bad Frame Check Sequence (FCS) with an integral number of octets (FCS Error) or a bad FCS with a non-integral number of octets (Alignment Error). Note that this definition of jabber is different than the definition in IEEE-802.3 section 8.2.1.5 (10BASE5) and section 10.3.1.4 (10BASE2). These documents define jabber as the condition where any packet exceeds 20 ms. The allowed range to detect jabber is between 20 ms and 150 ms.')
etherStatsCollisions = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 13), Counter32()).setUnits('Collisions').setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsCollisions.setStatus('current')
if mibBuilder.loadTexts: etherStatsCollisions.setDescription('The best estimate of the total number of collisions on this Ethernet segment. The value returned will depend on the location of the RMON probe. Section 8.2.1.3 (10BASE-5) and section 10.3.1.3 (10BASE-2) of IEEE standard 802.3 states that a station must detect a collision, in the receive mode, if three or more stations are transmitting simultaneously. A repeater port must detect a collision when two or more stations are transmitting simultaneously. Thus a probe placed on a repeater port could record more collisions than a probe connected to a station on the same segment would. Probe location plays a much smaller role when considering 10BASE-T. 14.2.1.4 (10BASE-T) of IEEE standard 802.3 defines a collision as the simultaneous presence of signals on the DO and RD circuits (transmitting and receiving at the same time). A 10BASE-T station can only detect collisions when it is transmitting. Thus probes placed on a station and a repeater, should report the same number of collisions. Note also that an RMON probe inside a repeater should ideally report collisions between the repeater and one or more other hosts (transmit collisions as defined by IEEE 802.3k) plus receiver collisions observed on any coax segments to which the repeater is connected.')
etherStatsPkts64Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 14), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsPkts64Octets.setStatus('current')
if mibBuilder.loadTexts: etherStatsPkts64Octets.setDescription('The total number of packets (including bad packets) received that were 64 octets in length (excluding framing bits but including FCS octets).')
etherStatsPkts65to127Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 15), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsPkts65to127Octets.setStatus('current')
if mibBuilder.loadTexts: etherStatsPkts65to127Octets.setDescription('The total number of packets (including bad packets) received that were between 65 and 127 octets in length inclusive (excluding framing bits but including FCS octets).')
etherStatsPkts128to255Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 16), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsPkts128to255Octets.setStatus('current')
if mibBuilder.loadTexts: etherStatsPkts128to255Octets.setDescription('The total number of packets (including bad packets) received that were between 128 and 255 octets in length inclusive (excluding framing bits but including FCS octets).')
etherStatsPkts256to511Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 17), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsPkts256to511Octets.setStatus('current')
if mibBuilder.loadTexts: etherStatsPkts256to511Octets.setDescription('The total number of packets (including bad packets) received that were between 256 and 511 octets in length inclusive (excluding framing bits but including FCS octets).')
etherStatsPkts512to1023Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 18), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsPkts512to1023Octets.setStatus('current')
if mibBuilder.loadTexts: etherStatsPkts512to1023Octets.setDescription('The total number of packets (including bad packets) received that were between 512 and 1023 octets in length inclusive (excluding framing bits but including FCS octets).')
etherStatsPkts1024to1518Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 19), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsPkts1024to1518Octets.setStatus('current')
if mibBuilder.loadTexts: etherStatsPkts1024to1518Octets.setDescription('The total number of packets (including bad packets) received that were between 1024 and 1518 octets in length inclusive (excluding framing bits but including FCS octets).')
etherStatsOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 20), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: etherStatsOwner.setStatus('current')
if mibBuilder.loadTexts: etherStatsOwner.setDescription('The entity that configured this entry and is therefore using the resources assigned to it.')
etherStatsStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 21), EntryStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: etherStatsStatus.setStatus('current')
if mibBuilder.loadTexts: etherStatsStatus.setDescription('The status of this etherStats entry.')
historyControlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 2, 1), )
if mibBuilder.loadTexts: historyControlTable.setStatus('current')
if mibBuilder.loadTexts: historyControlTable.setDescription('A list of history control entries.')
historyControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 2, 1, 1), ).setIndexNames((0, "RMON-MIB", "historyControlIndex"))
if mibBuilder.loadTexts: historyControlEntry.setStatus('current')
if mibBuilder.loadTexts: historyControlEntry.setDescription('A list of parameters that set up a periodic sampling of statistics. As an example, an instance of the historyControlInterval object might be named historyControlInterval.2')
historyControlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: historyControlIndex.setStatus('current')
if mibBuilder.loadTexts: historyControlIndex.setDescription('An index that uniquely identifies an entry in the historyControl table. Each such entry defines a set of samples at a particular interval for an interface on the device.')
historyControlDataSource = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 1, 1, 2), ObjectIdentifier()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: historyControlDataSource.setStatus('current')
if mibBuilder.loadTexts: historyControlDataSource.setDescription('This object identifies the source of the data for which historical data was collected and placed in a media-specific table on behalf of this historyControlEntry. This source can be any interface on this device. In order to identify a particular interface, this object shall identify the instance of the ifIndex object, defined in RFC 2233 [17], for the desired interface. For example, if an entry were to receive data from interface #1, this object would be set to ifIndex.1. The statistics in this group reflect all packets on the local network segment attached to the identified interface. An agent may or may not be able to tell if fundamental changes to the media of the interface have occurred and necessitate an invalidation of this entry. For example, a hot-pluggable ethernet card could be pulled out and replaced by a token-ring card. In such a case, if the agent has such knowledge of the change, it is recommended that it invalidate this entry. This object may not be modified if the associated historyControlStatus object is equal to valid(1).')
historyControlBucketsRequested = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 1, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535)).clone(50)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: historyControlBucketsRequested.setStatus('current')
if mibBuilder.loadTexts: historyControlBucketsRequested.setDescription('The requested number of discrete time intervals over which data is to be saved in the part of the media-specific table associated with this historyControlEntry. When this object is created or modified, the probe should set historyControlBucketsGranted as closely to this object as is possible for the particular probe implementation and available resources.')
historyControlBucketsGranted = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 1, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: historyControlBucketsGranted.setStatus('current')
if mibBuilder.loadTexts: historyControlBucketsGranted.setDescription('The number of discrete sampling intervals over which data shall be saved in the part of the media-specific table associated with this historyControlEntry. When the associated historyControlBucketsRequested object is created or modified, the probe should set this object as closely to the requested value as is possible for the particular probe implementation and available resources. The probe must not lower this value except as a result of a modification to the associated historyControlBucketsRequested object. There will be times when the actual number of buckets associated with this entry is less than the value of this object. In this case, at the end of each sampling interval, a new bucket will be added to the media-specific table. When the number of buckets reaches the value of this object and a new bucket is to be added to the media-specific table, the oldest bucket associated with this historyControlEntry shall be deleted by the agent so that the new bucket can be added. When the value of this object changes to a value less than the current value, entries are deleted from the media-specific table associated with this historyControlEntry. Enough of the oldest of these entries shall be deleted by the agent so that their number remains less than or equal to the new value of this object. When the value of this object changes to a value greater than the current value, the number of associated media- specific entries may be allowed to grow.')
historyControlInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 1, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 3600)).clone(1800)).setUnits('Seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: historyControlInterval.setStatus('current')
if mibBuilder.loadTexts: historyControlInterval.setDescription("The interval in seconds over which the data is sampled for each bucket in the part of the media-specific table associated with this historyControlEntry. This interval can be set to any number of seconds between 1 and 3600 (1 hour). Because the counters in a bucket may overflow at their maximum value with no indication, a prudent manager will take into account the possibility of overflow in any of the associated counters. It is important to consider the minimum time in which any counter could overflow on a particular media type and set the historyControlInterval object to a value less than this interval. This is typically most important for the 'octets' counter in any media-specific table. For example, on an Ethernet network, the etherHistoryOctets counter could overflow in about one hour at the Ethernet's maximum utilization. This object may not be modified if the associated historyControlStatus object is equal to valid(1).")
historyControlOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 1, 1, 6), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: historyControlOwner.setStatus('current')
if mibBuilder.loadTexts: historyControlOwner.setDescription('The entity that configured this entry and is therefore using the resources assigned to it.')
historyControlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 1, 1, 7), EntryStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: historyControlStatus.setStatus('current')
if mibBuilder.loadTexts: historyControlStatus.setDescription('The status of this historyControl entry. Each instance of the media-specific table associated with this historyControlEntry will be deleted by the agent if this historyControlEntry is not equal to valid(1).')
etherHistoryTable = MibTable((1, 3, 6, 1, 2, 1, 16, 2, 2), )
if mibBuilder.loadTexts: etherHistoryTable.setStatus('current')
if mibBuilder.loadTexts: etherHistoryTable.setDescription('A list of Ethernet history entries.')
etherHistoryEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 2, 2, 1), ).setIndexNames((0, "RMON-MIB", "etherHistoryIndex"), (0, "RMON-MIB", "etherHistorySampleIndex"))
if mibBuilder.loadTexts: etherHistoryEntry.setStatus('current')
if mibBuilder.loadTexts: etherHistoryEntry.setDescription('An historical sample of Ethernet statistics on a particular Ethernet interface. This sample is associated with the historyControlEntry which set up the parameters for a regular collection of these samples. As an example, an instance of the etherHistoryPkts object might be named etherHistoryPkts.2.89')
etherHistoryIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryIndex.setStatus('current')
if mibBuilder.loadTexts: etherHistoryIndex.setDescription('The history of which this entry is a part. The history identified by a particular value of this index is the same history as identified by the same value of historyControlIndex.')
etherHistorySampleIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistorySampleIndex.setStatus('current')
if mibBuilder.loadTexts: etherHistorySampleIndex.setDescription('An index that uniquely identifies the particular sample this entry represents among all samples associated with the same historyControlEntry. This index starts at 1 and increases by one as each new sample is taken.')
etherHistoryIntervalStart = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 3), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryIntervalStart.setStatus('current')
if mibBuilder.loadTexts: etherHistoryIntervalStart.setDescription('The value of sysUpTime at the start of the interval over which this sample was measured. If the probe keeps track of the time of day, it should start the first sample of the history at a time such that when the next hour of the day begins, a sample is started at that instant. Note that following this rule may require the probe to delay collecting the first sample of the history, as each sample must be of the same interval. Also note that the sample which is currently being collected is not accessible in this table until the end of its interval.')
etherHistoryDropEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryDropEvents.setStatus('current')
if mibBuilder.loadTexts: etherHistoryDropEvents.setDescription('The total number of events in which packets were dropped by the probe due to lack of resources during this sampling interval. Note that this number is not necessarily the number of packets dropped, it is just the number of times this condition has been detected.')
etherHistoryOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 5), Counter32()).setUnits('Octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryOctets.setStatus('current')
if mibBuilder.loadTexts: etherHistoryOctets.setDescription('The total number of octets of data (including those in bad packets) received on the network (excluding framing bits but including FCS octets).')
etherHistoryPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 6), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryPkts.setStatus('current')
if mibBuilder.loadTexts: etherHistoryPkts.setDescription('The number of packets (including bad packets) received during this sampling interval.')
etherHistoryBroadcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 7), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryBroadcastPkts.setStatus('current')
if mibBuilder.loadTexts: etherHistoryBroadcastPkts.setDescription('The number of good packets received during this sampling interval that were directed to the broadcast address.')
etherHistoryMulticastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 8), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryMulticastPkts.setStatus('current')
if mibBuilder.loadTexts: etherHistoryMulticastPkts.setDescription('The number of good packets received during this sampling interval that were directed to a multicast address. Note that this number does not include packets addressed to the broadcast address.')
etherHistoryCRCAlignErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 9), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryCRCAlignErrors.setStatus('current')
if mibBuilder.loadTexts: etherHistoryCRCAlignErrors.setDescription('The number of packets received during this sampling interval that had a length (excluding framing bits but including FCS octets) between 64 and 1518 octets, inclusive, but had either a bad Frame Check Sequence (FCS) with an integral number of octets (FCS Error) or a bad FCS with a non-integral number of octets (Alignment Error).')
etherHistoryUndersizePkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 10), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryUndersizePkts.setStatus('current')
if mibBuilder.loadTexts: etherHistoryUndersizePkts.setDescription('The number of packets received during this sampling interval that were less than 64 octets long (excluding framing bits but including FCS octets) and were otherwise well formed.')
etherHistoryOversizePkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 11), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryOversizePkts.setStatus('current')
if mibBuilder.loadTexts: etherHistoryOversizePkts.setDescription('The number of packets received during this sampling interval that were longer than 1518 octets (excluding framing bits but including FCS octets) but were otherwise well formed.')
etherHistoryFragments = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 12), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryFragments.setStatus('current')
if mibBuilder.loadTexts: etherHistoryFragments.setDescription('The total number of packets received during this sampling interval that were less than 64 octets in length (excluding framing bits but including FCS octets) had either a bad Frame Check Sequence (FCS) with an integral number of octets (FCS Error) or a bad FCS with a non-integral number of octets (Alignment Error). Note that it is entirely normal for etherHistoryFragments to increment. This is because it counts both runts (which are normal occurrences due to collisions) and noise hits.')
etherHistoryJabbers = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 13), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryJabbers.setStatus('current')
if mibBuilder.loadTexts: etherHistoryJabbers.setDescription('The number of packets received during this sampling interval that were longer than 1518 octets (excluding framing bits but including FCS octets), and had either a bad Frame Check Sequence (FCS) with an integral number of octets (FCS Error) or a bad FCS with a non-integral number of octets (Alignment Error). Note that this definition of jabber is different than the definition in IEEE-802.3 section 8.2.1.5 (10BASE5) and section 10.3.1.4 (10BASE2). These documents define jabber as the condition where any packet exceeds 20 ms. The allowed range to detect jabber is between 20 ms and 150 ms.')
etherHistoryCollisions = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 14), Counter32()).setUnits('Collisions').setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryCollisions.setStatus('current')
if mibBuilder.loadTexts: etherHistoryCollisions.setDescription('The best estimate of the total number of collisions on this Ethernet segment during this sampling interval. The value returned will depend on the location of the RMON probe. Section 8.2.1.3 (10BASE-5) and section 10.3.1.3 (10BASE-2) of IEEE standard 802.3 states that a station must detect a collision, in the receive mode, if three or more stations are transmitting simultaneously. A repeater port must detect a collision when two or more stations are transmitting simultaneously. Thus a probe placed on a repeater port could record more collisions than a probe connected to a station on the same segment would. Probe location plays a much smaller role when considering 10BASE-T. 14.2.1.4 (10BASE-T) of IEEE standard 802.3 defines a collision as the simultaneous presence of signals on the DO and RD circuits (transmitting and receiving at the same time). A 10BASE-T station can only detect collisions when it is transmitting. Thus probes placed on a station and a repeater, should report the same number of collisions. Note also that an RMON probe inside a repeater should ideally report collisions between the repeater and one or more other hosts (transmit collisions as defined by IEEE 802.3k) plus receiver collisions observed on any coax segments to which the repeater is connected.')
etherHistoryUtilization = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 15), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 10000))).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryUtilization.setStatus('current')
if mibBuilder.loadTexts: etherHistoryUtilization.setDescription('The best estimate of the mean physical layer network utilization on this interface during this sampling interval, in hundredths of a percent.')
alarmTable = MibTable((1, 3, 6, 1, 2, 1, 16, 3, 1), )
if mibBuilder.loadTexts: alarmTable.setStatus('current')
if mibBuilder.loadTexts: alarmTable.setDescription('A list of alarm entries.')
alarmEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 3, 1, 1), ).setIndexNames((0, "RMON-MIB", "alarmIndex"))
if mibBuilder.loadTexts: alarmEntry.setStatus('current')
if mibBuilder.loadTexts: alarmEntry.setDescription('A list of parameters that set up a periodic checking for alarm conditions. For example, an instance of the alarmValue object might be named alarmValue.8')
alarmIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: alarmIndex.setStatus('current')
if mibBuilder.loadTexts: alarmIndex.setDescription('An index that uniquely identifies an entry in the alarm table. Each such entry defines a diagnostic sample at a particular interval for an object on the device.')
alarmInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 2), Integer32()).setUnits('Seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: alarmInterval.setStatus('current')
if mibBuilder.loadTexts: alarmInterval.setDescription('The interval in seconds over which the data is sampled and compared with the rising and falling thresholds. When setting this variable, care should be taken in the case of deltaValue sampling - the interval should be set short enough that the sampled variable is very unlikely to increase or decrease by more than 2^31 - 1 during a single sampling interval. This object may not be modified if the associated alarmStatus object is equal to valid(1).')
alarmVariable = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 3), ObjectIdentifier()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: alarmVariable.setStatus('current')
if mibBuilder.loadTexts: alarmVariable.setDescription('The object identifier of the particular variable to be sampled. Only variables that resolve to an ASN.1 primitive type of INTEGER (INTEGER, Integer32, Counter32, Counter64, Gauge, or TimeTicks) may be sampled. Because SNMP access control is articulated entirely in terms of the contents of MIB views, no access control mechanism exists that can restrict the value of this object to identify only those objects that exist in a particular MIB view. Because there is thus no acceptable means of restricting the read access that could be obtained through the alarm mechanism, the probe must only grant write access to this object in those views that have read access to all objects on the probe. During a set operation, if the supplied variable name is not available in the selected MIB view, a badValue error must be returned. If at any time the variable name of an established alarmEntry is no longer available in the selected MIB view, the probe must change the status of this alarmEntry to invalid(4). This object may not be modified if the associated alarmStatus object is equal to valid(1).')
alarmSampleType = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2))).clone(namedValues=NamedValues(("absoluteValue", 1), ("deltaValue", 2)))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: alarmSampleType.setStatus('current')
if mibBuilder.loadTexts: alarmSampleType.setDescription('The method of sampling the selected variable and calculating the value to be compared against the thresholds. If the value of this object is absoluteValue(1), the value of the selected variable will be compared directly with the thresholds at the end of the sampling interval. If the value of this object is deltaValue(2), the value of the selected variable at the last sample will be subtracted from the current value, and the difference compared with the thresholds. This object may not be modified if the associated alarmStatus object is equal to valid(1).')
alarmValue = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 5), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: alarmValue.setStatus('current')
if mibBuilder.loadTexts: alarmValue.setDescription('The value of the statistic during the last sampling period. For example, if the sample type is deltaValue, this value will be the difference between the samples at the beginning and end of the period. If the sample type is absoluteValue, this value will be the sampled value at the end of the period. This is the value that is compared with the rising and falling thresholds. The value during the current sampling period is not made available until the period is completed and will remain available until the next period completes.')
alarmStartupAlarm = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3))).clone(namedValues=NamedValues(("risingAlarm", 1), ("fallingAlarm", 2), ("risingOrFallingAlarm", 3)))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: alarmStartupAlarm.setStatus('current')
if mibBuilder.loadTexts: alarmStartupAlarm.setDescription('The alarm that may be sent when this entry is first set to valid. If the first sample after this entry becomes valid is greater than or equal to the risingThreshold and alarmStartupAlarm is equal to risingAlarm(1) or risingOrFallingAlarm(3), then a single rising alarm will be generated. If the first sample after this entry becomes valid is less than or equal to the fallingThreshold and alarmStartupAlarm is equal to fallingAlarm(2) or risingOrFallingAlarm(3), then a single falling alarm will be generated. This object may not be modified if the associated alarmStatus object is equal to valid(1).')
alarmRisingThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 7), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: alarmRisingThreshold.setStatus('current')
if mibBuilder.loadTexts: alarmRisingThreshold.setDescription('A threshold for the sampled statistic. When the current sampled value is greater than or equal to this threshold, and the value at the last sampling interval was less than this threshold, a single event will be generated. A single event will also be generated if the first sample after this entry becomes valid is greater than or equal to this threshold and the associated alarmStartupAlarm is equal to risingAlarm(1) or risingOrFallingAlarm(3). After a rising event is generated, another such event will not be generated until the sampled value falls below this threshold and reaches the alarmFallingThreshold. This object may not be modified if the associated alarmStatus object is equal to valid(1).')
alarmFallingThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 8), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: alarmFallingThreshold.setStatus('current')
if mibBuilder.loadTexts: alarmFallingThreshold.setDescription('A threshold for the sampled statistic. When the current sampled value is less than or equal to this threshold, and the value at the last sampling interval was greater than this threshold, a single event will be generated. A single event will also be generated if the first sample after this entry becomes valid is less than or equal to this threshold and the associated alarmStartupAlarm is equal to fallingAlarm(2) or risingOrFallingAlarm(3). After a falling event is generated, another such event will not be generated until the sampled value rises above this threshold and reaches the alarmRisingThreshold. This object may not be modified if the associated alarmStatus object is equal to valid(1).')
alarmRisingEventIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: alarmRisingEventIndex.setStatus('current')
if mibBuilder.loadTexts: alarmRisingEventIndex.setDescription('The index of the eventEntry that is used when a rising threshold is crossed. The eventEntry identified by a particular value of this index is the same as identified by the same value of the eventIndex object. If there is no corresponding entry in the eventTable, then no association exists. In particular, if this value is zero, no associated event will be generated, as zero is not a valid event index. This object may not be modified if the associated alarmStatus object is equal to valid(1).')
alarmFallingEventIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 10), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: alarmFallingEventIndex.setStatus('current')
if mibBuilder.loadTexts: alarmFallingEventIndex.setDescription('The index of the eventEntry that is used when a falling threshold is crossed. The eventEntry identified by a particular value of this index is the same as identified by the same value of the eventIndex object. If there is no corresponding entry in the eventTable, then no association exists. In particular, if this value is zero, no associated event will be generated, as zero is not a valid event index. This object may not be modified if the associated alarmStatus object is equal to valid(1).')
alarmOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 11), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: alarmOwner.setStatus('current')
if mibBuilder.loadTexts: alarmOwner.setDescription('The entity that configured this entry and is therefore using the resources assigned to it.')
alarmStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 12), EntryStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: alarmStatus.setStatus('current')
if mibBuilder.loadTexts: alarmStatus.setDescription('The status of this alarm entry.')
hostControlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 4, 1), )
if mibBuilder.loadTexts: hostControlTable.setStatus('current')
if mibBuilder.loadTexts: hostControlTable.setDescription('A list of host table control entries.')
hostControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 4, 1, 1), ).setIndexNames((0, "RMON-MIB", "hostControlIndex"))
if mibBuilder.loadTexts: hostControlEntry.setStatus('current')
if mibBuilder.loadTexts: hostControlEntry.setDescription('A list of parameters that set up the discovery of hosts on a particular interface and the collection of statistics about these hosts. For example, an instance of the hostControlTableSize object might be named hostControlTableSize.1')
hostControlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostControlIndex.setStatus('current')
if mibBuilder.loadTexts: hostControlIndex.setDescription('An index that uniquely identifies an entry in the hostControl table. Each such entry defines a function that discovers hosts on a particular interface and places statistics about them in the hostTable and the hostTimeTable on behalf of this hostControlEntry.')
hostControlDataSource = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 1, 1, 2), ObjectIdentifier()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hostControlDataSource.setStatus('current')
if mibBuilder.loadTexts: hostControlDataSource.setDescription('This object identifies the source of the data for this instance of the host function. This source can be any interface on this device. In order to identify a particular interface, this object shall identify the instance of the ifIndex object, defined in RFC 2233 [17], for the desired interface. For example, if an entry were to receive data from interface #1, this object would be set to ifIndex.1. The statistics in this group reflect all packets on the local network segment attached to the identified interface. An agent may or may not be able to tell if fundamental changes to the media of the interface have occurred and necessitate an invalidation of this entry. For example, a hot-pluggable ethernet card could be pulled out and replaced by a token-ring card. In such a case, if the agent has such knowledge of the change, it is recommended that it invalidate this entry. This object may not be modified if the associated hostControlStatus object is equal to valid(1).')
hostControlTableSize = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 1, 1, 3), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostControlTableSize.setStatus('current')
if mibBuilder.loadTexts: hostControlTableSize.setDescription('The number of hostEntries in the hostTable and the hostTimeTable associated with this hostControlEntry.')
hostControlLastDeleteTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 1, 1, 4), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostControlLastDeleteTime.setStatus('current')
if mibBuilder.loadTexts: hostControlLastDeleteTime.setDescription('The value of sysUpTime when the last entry was deleted from the portion of the hostTable associated with this hostControlEntry. If no deletions have occurred, this value shall be zero.')
hostControlOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 1, 1, 5), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hostControlOwner.setStatus('current')
if mibBuilder.loadTexts: hostControlOwner.setDescription('The entity that configured this entry and is therefore using the resources assigned to it.')
hostControlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 1, 1, 6), EntryStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hostControlStatus.setStatus('current')
if mibBuilder.loadTexts: hostControlStatus.setDescription('The status of this hostControl entry. If this object is not equal to valid(1), all associated entries in the hostTable, hostTimeTable, and the hostTopNTable shall be deleted by the agent.')
hostTable = MibTable((1, 3, 6, 1, 2, 1, 16, 4, 2), )
if mibBuilder.loadTexts: hostTable.setStatus('current')
if mibBuilder.loadTexts: hostTable.setDescription('A list of host entries.')
hostEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 4, 2, 1), ).setIndexNames((0, "RMON-MIB", "hostIndex"), (0, "RMON-MIB", "hostAddress"))
if mibBuilder.loadTexts: hostEntry.setStatus('current')
if mibBuilder.loadTexts: hostEntry.setDescription('A collection of statistics for a particular host that has been discovered on an interface of this device. For example, an instance of the hostOutBroadcastPkts object might be named hostOutBroadcastPkts.1.6.8.0.32.27.3.176')
hostAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 1), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostAddress.setStatus('current')
if mibBuilder.loadTexts: hostAddress.setDescription('The physical address of this host.')
hostCreationOrder = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostCreationOrder.setStatus('current')
if mibBuilder.loadTexts: hostCreationOrder.setDescription("An index that defines the relative ordering of the creation time of hosts captured for a particular hostControlEntry. This index shall be between 1 and N, where N is the value of the associated hostControlTableSize. The ordering of the indexes is based on the order of each entry's insertion into the table, in which entries added earlier have a lower index value than entries added later. It is important to note that the order for a particular entry may change as an (earlier) entry is deleted from the table. Because this order may change, management stations should make use of the hostControlLastDeleteTime variable in the hostControlEntry associated with the relevant portion of the hostTable. By observing this variable, the management station may detect the circumstances where a previous association between a value of hostCreationOrder and a hostEntry may no longer hold.")
hostIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostIndex.setStatus('current')
if mibBuilder.loadTexts: hostIndex.setDescription('The set of collected host statistics of which this entry is a part. The set of hosts identified by a particular value of this index is associated with the hostControlEntry as identified by the same value of hostControlIndex.')
hostInPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 4), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: hostInPkts.setStatus('current')
if mibBuilder.loadTexts: hostInPkts.setDescription('The number of good packets transmitted to this address since it was added to the hostTable.')
hostOutPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 5), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: hostOutPkts.setStatus('current')
if mibBuilder.loadTexts: hostOutPkts.setDescription('The number of packets, including bad packets, transmitted by this address since it was added to the hostTable.')
hostInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 6), Counter32()).setUnits('Octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: hostInOctets.setStatus('current')
if mibBuilder.loadTexts: hostInOctets.setDescription('The number of octets transmitted to this address since it was added to the hostTable (excluding framing bits but including FCS octets), except for those octets in bad packets.')
hostOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 7), Counter32()).setUnits('Octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: hostOutOctets.setStatus('current')
if mibBuilder.loadTexts: hostOutOctets.setDescription('The number of octets transmitted by this address since it was added to the hostTable (excluding framing bits but including FCS octets), including those octets in bad packets.')
hostOutErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 8), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: hostOutErrors.setStatus('current')
if mibBuilder.loadTexts: hostOutErrors.setDescription('The number of bad packets transmitted by this address since this host was added to the hostTable.')
hostOutBroadcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 9), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: hostOutBroadcastPkts.setStatus('current')
if mibBuilder.loadTexts: hostOutBroadcastPkts.setDescription('The number of good packets transmitted by this address that were directed to the broadcast address since this host was added to the hostTable.')
hostOutMulticastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 10), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: hostOutMulticastPkts.setStatus('current')
if mibBuilder.loadTexts: hostOutMulticastPkts.setDescription('The number of good packets transmitted by this address that were directed to a multicast address since this host was added to the hostTable. Note that this number does not include packets directed to the broadcast address.')
hostTimeTable = MibTable((1, 3, 6, 1, 2, 1, 16, 4, 3), )
if mibBuilder.loadTexts: hostTimeTable.setStatus('current')
if mibBuilder.loadTexts: hostTimeTable.setDescription('A list of time-ordered host table entries.')
hostTimeEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 4, 3, 1), ).setIndexNames((0, "RMON-MIB", "hostTimeIndex"), (0, "RMON-MIB", "hostTimeCreationOrder"))
if mibBuilder.loadTexts: hostTimeEntry.setStatus('current')
if mibBuilder.loadTexts: hostTimeEntry.setDescription('A collection of statistics for a particular host that has been discovered on an interface of this device. This collection includes the relative ordering of the creation time of this object. For example, an instance of the hostTimeOutBroadcastPkts object might be named hostTimeOutBroadcastPkts.1.687')
hostTimeAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 1), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeAddress.setStatus('current')
if mibBuilder.loadTexts: hostTimeAddress.setDescription('The physical address of this host.')
hostTimeCreationOrder = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeCreationOrder.setStatus('current')
if mibBuilder.loadTexts: hostTimeCreationOrder.setDescription("An index that uniquely identifies an entry in the hostTime table among those entries associated with the same hostControlEntry. This index shall be between 1 and N, where N is the value of the associated hostControlTableSize. The ordering of the indexes is based on the order of each entry's insertion into the table, in which entries added earlier have a lower index value than entries added later. Thus the management station has the ability to learn of new entries added to this table without downloading the entire table. It is important to note that the index for a particular entry may change as an (earlier) entry is deleted from the table. Because this order may change, management stations should make use of the hostControlLastDeleteTime variable in the hostControlEntry associated with the relevant portion of the hostTimeTable. By observing this variable, the management station may detect the circumstances where a download of the table may have missed entries, and where a previous association between a value of hostTimeCreationOrder and a hostTimeEntry may no longer hold.")
hostTimeIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeIndex.setStatus('current')
if mibBuilder.loadTexts: hostTimeIndex.setDescription('The set of collected host statistics of which this entry is a part. The set of hosts identified by a particular value of this index is associated with the hostControlEntry as identified by the same value of hostControlIndex.')
hostTimeInPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 4), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeInPkts.setStatus('current')
if mibBuilder.loadTexts: hostTimeInPkts.setDescription('The number of good packets transmitted to this address since it was added to the hostTimeTable.')
hostTimeOutPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 5), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeOutPkts.setStatus('current')
if mibBuilder.loadTexts: hostTimeOutPkts.setDescription('The number of packets, including bad packets, transmitted by this address since it was added to the hostTimeTable.')
hostTimeInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 6), Counter32()).setUnits('Octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeInOctets.setStatus('current')
if mibBuilder.loadTexts: hostTimeInOctets.setDescription('The number of octets transmitted to this address since it was added to the hostTimeTable (excluding framing bits but including FCS octets), except for those octets in bad packets.')
hostTimeOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 7), Counter32()).setUnits('Octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeOutOctets.setStatus('current')
if mibBuilder.loadTexts: hostTimeOutOctets.setDescription('The number of octets transmitted by this address since it was added to the hostTimeTable (excluding framing bits but including FCS octets), including those octets in bad packets.')
hostTimeOutErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 8), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeOutErrors.setStatus('current')
if mibBuilder.loadTexts: hostTimeOutErrors.setDescription('The number of bad packets transmitted by this address since this host was added to the hostTimeTable.')
hostTimeOutBroadcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 9), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeOutBroadcastPkts.setStatus('current')
if mibBuilder.loadTexts: hostTimeOutBroadcastPkts.setDescription('The number of good packets transmitted by this address that were directed to the broadcast address since this host was added to the hostTimeTable.')
hostTimeOutMulticastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 10), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeOutMulticastPkts.setStatus('current')
if mibBuilder.loadTexts: hostTimeOutMulticastPkts.setDescription('The number of good packets transmitted by this address that were directed to a multicast address since this host was added to the hostTimeTable. Note that this number does not include packets directed to the broadcast address.')
hostTopNControlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 5, 1), )
if mibBuilder.loadTexts: hostTopNControlTable.setStatus('current')
if mibBuilder.loadTexts: hostTopNControlTable.setDescription('A list of top N host control entries.')
hostTopNControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 5, 1, 1), ).setIndexNames((0, "RMON-MIB", "hostTopNControlIndex"))
if mibBuilder.loadTexts: hostTopNControlEntry.setStatus('current')
if mibBuilder.loadTexts: hostTopNControlEntry.setDescription('A set of parameters that control the creation of a report of the top N hosts according to several metrics. For example, an instance of the hostTopNDuration object might be named hostTopNDuration.3')
hostTopNControlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTopNControlIndex.setStatus('current')
if mibBuilder.loadTexts: hostTopNControlIndex.setDescription('An index that uniquely identifies an entry in the hostTopNControl table. Each such entry defines one top N report prepared for one interface.')
hostTopNHostIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hostTopNHostIndex.setStatus('current')
if mibBuilder.loadTexts: hostTopNHostIndex.setDescription('The host table for which a top N report will be prepared on behalf of this entry. The host table identified by a particular value of this index is associated with the same host table as identified by the same value of hostIndex. This object may not be modified if the associated hostTopNStatus object is equal to valid(1).')
hostTopNRateBase = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7))).clone(namedValues=NamedValues(("hostTopNInPkts", 1), ("hostTopNOutPkts", 2), ("hostTopNInOctets", 3), ("hostTopNOutOctets", 4), ("hostTopNOutErrors", 5), ("hostTopNOutBroadcastPkts", 6), ("hostTopNOutMulticastPkts", 7)))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hostTopNRateBase.setStatus('current')
if mibBuilder.loadTexts: hostTopNRateBase.setDescription('The variable for each host that the hostTopNRate variable is based upon. This object may not be modified if the associated hostTopNStatus object is equal to valid(1).')
hostTopNTimeRemaining = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 4), Integer32()).setUnits('Seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: hostTopNTimeRemaining.setStatus('current')
if mibBuilder.loadTexts: hostTopNTimeRemaining.setDescription('The number of seconds left in the report currently being collected. When this object is modified by the management station, a new collection is started, possibly aborting a currently running report. The new value is used as the requested duration of this report, which is loaded into the associated hostTopNDuration object. When this object is set to a non-zero value, any associated hostTopNEntries shall be made inaccessible by the monitor. While the value of this object is non-zero, it decrements by one per second until it reaches zero. During this time, all associated hostTopNEntries shall remain inaccessible. At the time that this object decrements to zero, the report is made accessible in the hostTopNTable. Thus, the hostTopN table needs to be created only at the end of the collection interval.')
hostTopNDuration = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 5), Integer32()).setUnits('Seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTopNDuration.setStatus('current')
if mibBuilder.loadTexts: hostTopNDuration.setDescription('The number of seconds that this report has collected during the last sampling interval, or if this report is currently being collected, the number of seconds that this report is being collected during this sampling interval. When the associated hostTopNTimeRemaining object is set, this object shall be set by the probe to the same value and shall not be modified until the next time the hostTopNTimeRemaining is set. This value shall be zero if no reports have been requested for this hostTopNControlEntry.')
hostTopNRequestedSize = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 6), Integer32().clone(10)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hostTopNRequestedSize.setStatus('current')
if mibBuilder.loadTexts: hostTopNRequestedSize.setDescription('The maximum number of hosts requested for the top N table. When this object is created or modified, the probe should set hostTopNGrantedSize as closely to this object as is possible for the particular probe implementation and available resources.')
hostTopNGrantedSize = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTopNGrantedSize.setStatus('current')
if mibBuilder.loadTexts: hostTopNGrantedSize.setDescription('The maximum number of hosts in the top N table. When the associated hostTopNRequestedSize object is created or modified, the probe should set this object as closely to the requested value as is possible for the particular implementation and available resources. The probe must not lower this value except as a result of a set to the associated hostTopNRequestedSize object. Hosts with the highest value of hostTopNRate shall be placed in this table in decreasing order of this rate until there is no more room or until there are no more hosts.')
hostTopNStartTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 8), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTopNStartTime.setStatus('current')
if mibBuilder.loadTexts: hostTopNStartTime.setDescription('The value of sysUpTime when this top N report was last started. In other words, this is the time that the associated hostTopNTimeRemaining object was modified to start the requested report.')
hostTopNOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 9), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hostTopNOwner.setStatus('current')
if mibBuilder.loadTexts: hostTopNOwner.setDescription('The entity that configured this entry and is therefore using the resources assigned to it.')
hostTopNStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 10), EntryStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: hostTopNStatus.setStatus('current')
if mibBuilder.loadTexts: hostTopNStatus.setDescription('The status of this hostTopNControl entry. If this object is not equal to valid(1), all associated hostTopNEntries shall be deleted by the agent.')
hostTopNTable = MibTable((1, 3, 6, 1, 2, 1, 16, 5, 2), )
if mibBuilder.loadTexts: hostTopNTable.setStatus('current')
if mibBuilder.loadTexts: hostTopNTable.setDescription('A list of top N host entries.')
hostTopNEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 5, 2, 1), ).setIndexNames((0, "RMON-MIB", "hostTopNReport"), (0, "RMON-MIB", "hostTopNIndex"))
if mibBuilder.loadTexts: hostTopNEntry.setStatus('current')
if mibBuilder.loadTexts: hostTopNEntry.setDescription('A set of statistics for a host that is part of a top N report. For example, an instance of the hostTopNRate object might be named hostTopNRate.3.10')
hostTopNReport = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTopNReport.setStatus('current')
if mibBuilder.loadTexts: hostTopNReport.setDescription('This object identifies the top N report of which this entry is a part. The set of hosts identified by a particular value of this object is part of the same report as identified by the same value of the hostTopNControlIndex object.')
hostTopNIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 2, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTopNIndex.setStatus('current')
if mibBuilder.loadTexts: hostTopNIndex.setDescription('An index that uniquely identifies an entry in the hostTopN table among those in the same report. This index is between 1 and N, where N is the number of entries in this table. Increasing values of hostTopNIndex shall be assigned to entries with decreasing values of hostTopNRate until index N is assigned to the entry with the lowest value of hostTopNRate or there are no more hostTopNEntries.')
hostTopNAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 2, 1, 3), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTopNAddress.setStatus('current')
if mibBuilder.loadTexts: hostTopNAddress.setDescription('The physical address of this host.')
hostTopNRate = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 2, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTopNRate.setStatus('current')
if mibBuilder.loadTexts: hostTopNRate.setDescription("The amount of change in the selected variable during this sampling interval. The selected variable is this host's instance of the object selected by hostTopNRateBase.")
matrixControlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 6, 1), )
if mibBuilder.loadTexts: matrixControlTable.setStatus('current')
if mibBuilder.loadTexts: matrixControlTable.setDescription('A list of information entries for the traffic matrix on each interface.')
matrixControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 6, 1, 1), ).setIndexNames((0, "RMON-MIB", "matrixControlIndex"))
if mibBuilder.loadTexts: matrixControlEntry.setStatus('current')
if mibBuilder.loadTexts: matrixControlEntry.setDescription('Information about a traffic matrix on a particular interface. For example, an instance of the matrixControlLastDeleteTime object might be named matrixControlLastDeleteTime.1')
matrixControlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixControlIndex.setStatus('current')
if mibBuilder.loadTexts: matrixControlIndex.setDescription('An index that uniquely identifies an entry in the matrixControl table. Each such entry defines a function that discovers conversations on a particular interface and places statistics about them in the matrixSDTable and the matrixDSTable on behalf of this matrixControlEntry.')
matrixControlDataSource = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 1, 1, 2), ObjectIdentifier()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: matrixControlDataSource.setStatus('current')
if mibBuilder.loadTexts: matrixControlDataSource.setDescription('This object identifies the source of the data from which this entry creates a traffic matrix. This source can be any interface on this device. In order to identify a particular interface, this object shall identify the instance of the ifIndex object, defined in RFC 2233 [17], for the desired interface. For example, if an entry were to receive data from interface #1, this object would be set to ifIndex.1. The statistics in this group reflect all packets on the local network segment attached to the identified interface. An agent may or may not be able to tell if fundamental changes to the media of the interface have occurred and necessitate an invalidation of this entry. For example, a hot-pluggable ethernet card could be pulled out and replaced by a token-ring card. In such a case, if the agent has such knowledge of the change, it is recommended that it invalidate this entry. This object may not be modified if the associated matrixControlStatus object is equal to valid(1).')
matrixControlTableSize = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 1, 1, 3), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixControlTableSize.setStatus('current')
if mibBuilder.loadTexts: matrixControlTableSize.setDescription('The number of matrixSDEntries in the matrixSDTable for this interface. This must also be the value of the number of entries in the matrixDSTable for this interface.')
matrixControlLastDeleteTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 1, 1, 4), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixControlLastDeleteTime.setStatus('current')
if mibBuilder.loadTexts: matrixControlLastDeleteTime.setDescription('The value of sysUpTime when the last entry was deleted from the portion of the matrixSDTable or matrixDSTable associated with this matrixControlEntry. If no deletions have occurred, this value shall be zero.')
matrixControlOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 1, 1, 5), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: matrixControlOwner.setStatus('current')
if mibBuilder.loadTexts: matrixControlOwner.setDescription('The entity that configured this entry and is therefore using the resources assigned to it.')
matrixControlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 1, 1, 6), EntryStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: matrixControlStatus.setStatus('current')
if mibBuilder.loadTexts: matrixControlStatus.setDescription('The status of this matrixControl entry. If this object is not equal to valid(1), all associated entries in the matrixSDTable and the matrixDSTable shall be deleted by the agent.')
matrixSDTable = MibTable((1, 3, 6, 1, 2, 1, 16, 6, 2), )
if mibBuilder.loadTexts: matrixSDTable.setStatus('current')
if mibBuilder.loadTexts: matrixSDTable.setDescription('A list of traffic matrix entries indexed by source and destination MAC address.')
matrixSDEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 6, 2, 1), ).setIndexNames((0, "RMON-MIB", "matrixSDIndex"), (0, "RMON-MIB", "matrixSDSourceAddress"), (0, "RMON-MIB", "matrixSDDestAddress"))
if mibBuilder.loadTexts: matrixSDEntry.setStatus('current')
if mibBuilder.loadTexts: matrixSDEntry.setDescription('A collection of statistics for communications between two addresses on a particular interface. For example, an instance of the matrixSDPkts object might be named matrixSDPkts.1.6.8.0.32.27.3.176.6.8.0.32.10.8.113')
matrixSDSourceAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 2, 1, 1), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixSDSourceAddress.setStatus('current')
if mibBuilder.loadTexts: matrixSDSourceAddress.setDescription('The source physical address.')
matrixSDDestAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 2, 1, 2), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixSDDestAddress.setStatus('current')
if mibBuilder.loadTexts: matrixSDDestAddress.setDescription('The destination physical address.')
matrixSDIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 2, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixSDIndex.setStatus('current')
if mibBuilder.loadTexts: matrixSDIndex.setDescription('The set of collected matrix statistics of which this entry is a part. The set of matrix statistics identified by a particular value of this index is associated with the same matrixControlEntry as identified by the same value of matrixControlIndex.')
matrixSDPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 2, 1, 4), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixSDPkts.setStatus('current')
if mibBuilder.loadTexts: matrixSDPkts.setDescription('The number of packets transmitted from the source address to the destination address (this number includes bad packets).')
matrixSDOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 2, 1, 5), Counter32()).setUnits('Octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixSDOctets.setStatus('current')
if mibBuilder.loadTexts: matrixSDOctets.setDescription('The number of octets (excluding framing bits but including FCS octets) contained in all packets transmitted from the source address to the destination address.')
matrixSDErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 2, 1, 6), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixSDErrors.setStatus('current')
if mibBuilder.loadTexts: matrixSDErrors.setDescription('The number of bad packets transmitted from the source address to the destination address.')
matrixDSTable = MibTable((1, 3, 6, 1, 2, 1, 16, 6, 3), )
if mibBuilder.loadTexts: matrixDSTable.setStatus('current')
if mibBuilder.loadTexts: matrixDSTable.setDescription('A list of traffic matrix entries indexed by destination and source MAC address.')
matrixDSEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 6, 3, 1), ).setIndexNames((0, "RMON-MIB", "matrixDSIndex"), (0, "RMON-MIB", "matrixDSDestAddress"), (0, "RMON-MIB", "matrixDSSourceAddress"))
if mibBuilder.loadTexts: matrixDSEntry.setStatus('current')
if mibBuilder.loadTexts: matrixDSEntry.setDescription('A collection of statistics for communications between two addresses on a particular interface. For example, an instance of the matrixSDPkts object might be named matrixSDPkts.1.6.8.0.32.10.8.113.6.8.0.32.27.3.176')
matrixDSSourceAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 3, 1, 1), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixDSSourceAddress.setStatus('current')
if mibBuilder.loadTexts: matrixDSSourceAddress.setDescription('The source physical address.')
matrixDSDestAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 3, 1, 2), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixDSDestAddress.setStatus('current')
if mibBuilder.loadTexts: matrixDSDestAddress.setDescription('The destination physical address.')
matrixDSIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 3, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixDSIndex.setStatus('current')
if mibBuilder.loadTexts: matrixDSIndex.setDescription('The set of collected matrix statistics of which this entry is a part. The set of matrix statistics identified by a particular value of this index is associated with the same matrixControlEntry as identified by the same value of matrixControlIndex.')
matrixDSPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 3, 1, 4), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixDSPkts.setStatus('current')
if mibBuilder.loadTexts: matrixDSPkts.setDescription('The number of packets transmitted from the source address to the destination address (this number includes bad packets).')
matrixDSOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 3, 1, 5), Counter32()).setUnits('Octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixDSOctets.setStatus('current')
if mibBuilder.loadTexts: matrixDSOctets.setDescription('The number of octets (excluding framing bits but including FCS octets) contained in all packets transmitted from the source address to the destination address.')
matrixDSErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 3, 1, 6), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixDSErrors.setStatus('current')
if mibBuilder.loadTexts: matrixDSErrors.setDescription('The number of bad packets transmitted from the source address to the destination address.')
filterTable = MibTable((1, 3, 6, 1, 2, 1, 16, 7, 1), )
if mibBuilder.loadTexts: filterTable.setStatus('current')
if mibBuilder.loadTexts: filterTable.setDescription('A list of packet filter entries.')
filterEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 7, 1, 1), ).setIndexNames((0, "RMON-MIB", "filterIndex"))
if mibBuilder.loadTexts: filterEntry.setStatus('current')
if mibBuilder.loadTexts: filterEntry.setDescription('A set of parameters for a packet filter applied on a particular interface. As an example, an instance of the filterPktData object might be named filterPktData.12')
filterIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: filterIndex.setStatus('current')
if mibBuilder.loadTexts: filterIndex.setDescription('An index that uniquely identifies an entry in the filter table. Each such entry defines one filter that is to be applied to every packet received on an interface.')
filterChannelIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: filterChannelIndex.setStatus('current')
if mibBuilder.loadTexts: filterChannelIndex.setDescription('This object identifies the channel of which this filter is a part. The filters identified by a particular value of this object are associated with the same channel as identified by the same value of the channelIndex object.')
filterPktDataOffset = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 3), Integer32()).setUnits('Octets').setMaxAccess("readcreate")
if mibBuilder.loadTexts: filterPktDataOffset.setStatus('current')
if mibBuilder.loadTexts: filterPktDataOffset.setDescription('The offset from the beginning of each packet where a match of packet data will be attempted. This offset is measured from the point in the physical layer packet after the framing bits, if any. For example, in an Ethernet frame, this point is at the beginning of the destination MAC address. This object may not be modified if the associated filterStatus object is equal to valid(1).')
filterPktData = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 4), OctetString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: filterPktData.setStatus('current')
if mibBuilder.loadTexts: filterPktData.setDescription('The data that is to be matched with the input packet. For each packet received, this filter and the accompanying filterPktDataMask and filterPktDataNotMask will be adjusted for the offset. The only bits relevant to this match algorithm are those that have the corresponding filterPktDataMask bit equal to one. The following three rules are then applied to every packet: (1) If the packet is too short and does not have data corresponding to part of the filterPktData, the packet will fail this data match. (2) For each relevant bit from the packet with the corresponding filterPktDataNotMask bit set to zero, if the bit from the packet is not equal to the corresponding bit from the filterPktData, then the packet will fail this data match. (3) If for every relevant bit from the packet with the corresponding filterPktDataNotMask bit set to one, the bit from the packet is equal to the corresponding bit from the filterPktData, then the packet will fail this data match. Any packets that have not failed any of the three matches above have passed this data match. In particular, a zero length filter will match any packet. This object may not be modified if the associated filterStatus object is equal to valid(1).')
filterPktDataMask = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 5), OctetString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: filterPktDataMask.setStatus('current')
if mibBuilder.loadTexts: filterPktDataMask.setDescription("The mask that is applied to the match process. After adjusting this mask for the offset, only those bits in the received packet that correspond to bits set in this mask are relevant for further processing by the match algorithm. The offset is applied to filterPktDataMask in the same way it is applied to the filter. For the purposes of the matching algorithm, if the associated filterPktData object is longer than this mask, this mask is conceptually extended with '1' bits until it reaches the length of the filterPktData object. This object may not be modified if the associated filterStatus object is equal to valid(1).")
filterPktDataNotMask = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 6), OctetString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: filterPktDataNotMask.setStatus('current')
if mibBuilder.loadTexts: filterPktDataNotMask.setDescription("The inversion mask that is applied to the match process. After adjusting this mask for the offset, those relevant bits in the received packet that correspond to bits cleared in this mask must all be equal to their corresponding bits in the filterPktData object for the packet to be accepted. In addition, at least one of those relevant bits in the received packet that correspond to bits set in this mask must be different to its corresponding bit in the filterPktData object. For the purposes of the matching algorithm, if the associated filterPktData object is longer than this mask, this mask is conceptually extended with '0' bits until it reaches the length of the filterPktData object. This object may not be modified if the associated filterStatus object is equal to valid(1).")
filterPktStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 7), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: filterPktStatus.setStatus('current')
if mibBuilder.loadTexts: filterPktStatus.setDescription("The status that is to be matched with the input packet. The only bits relevant to this match algorithm are those that have the corresponding filterPktStatusMask bit equal to one. The following two rules are then applied to every packet: (1) For each relevant bit from the packet status with the corresponding filterPktStatusNotMask bit set to zero, if the bit from the packet status is not equal to the corresponding bit from the filterPktStatus, then the packet will fail this status match. (2) If for every relevant bit from the packet status with the corresponding filterPktStatusNotMask bit set to one, the bit from the packet status is equal to the corresponding bit from the filterPktStatus, then the packet will fail this status match. Any packets that have not failed either of the two matches above have passed this status match. In particular, a zero length status filter will match any packet's status. The value of the packet status is a sum. This sum initially takes the value zero. Then, for each error, E, that has been discovered in this packet, 2 raised to a value representing E is added to the sum. The errors and the bits that represent them are dependent on the media type of the interface that this channel is receiving packets from. The errors defined for a packet captured off of an Ethernet interface are as follows: bit # Error 0 Packet is longer than 1518 octets 1 Packet is shorter than 64 octets 2 Packet experienced a CRC or Alignment error For example, an Ethernet fragment would have a value of 6 (2^1 + 2^2). As this MIB is expanded to new media types, this object will have other media-specific errors defined. For the purposes of this status matching algorithm, if the packet status is longer than this filterPktStatus object, this object is conceptually extended with '0' bits until it reaches the size of the packet status. This object may not be modified if the associated filterStatus object is equal to valid(1).")
filterPktStatusMask = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 8), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: filterPktStatusMask.setStatus('current')
if mibBuilder.loadTexts: filterPktStatusMask.setDescription("The mask that is applied to the status match process. Only those bits in the received packet that correspond to bits set in this mask are relevant for further processing by the status match algorithm. For the purposes of the matching algorithm, if the associated filterPktStatus object is longer than this mask, this mask is conceptually extended with '1' bits until it reaches the size of the filterPktStatus. In addition, if a packet status is longer than this mask, this mask is conceptually extended with '0' bits until it reaches the size of the packet status. This object may not be modified if the associated filterStatus object is equal to valid(1).")
filterPktStatusNotMask = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 9), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: filterPktStatusNotMask.setStatus('current')
if mibBuilder.loadTexts: filterPktStatusNotMask.setDescription("The inversion mask that is applied to the status match process. Those relevant bits in the received packet status that correspond to bits cleared in this mask must all be equal to their corresponding bits in the filterPktStatus object for the packet to be accepted. In addition, at least one of those relevant bits in the received packet status that correspond to bits set in this mask must be different to its corresponding bit in the filterPktStatus object for the packet to be accepted. For the purposes of the matching algorithm, if the associated filterPktStatus object or a packet status is longer than this mask, this mask is conceptually extended with '0' bits until it reaches the longer of the lengths of the filterPktStatus object and the packet status. This object may not be modified if the associated filterStatus object is equal to valid(1).")
filterOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 10), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: filterOwner.setStatus('current')
if mibBuilder.loadTexts: filterOwner.setDescription('The entity that configured this entry and is therefore using the resources assigned to it.')
filterStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 11), EntryStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: filterStatus.setStatus('current')
if mibBuilder.loadTexts: filterStatus.setDescription('The status of this filter entry.')
channelTable = MibTable((1, 3, 6, 1, 2, 1, 16, 7, 2), )
if mibBuilder.loadTexts: channelTable.setStatus('current')
if mibBuilder.loadTexts: channelTable.setDescription('A list of packet channel entries.')
channelEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 7, 2, 1), ).setIndexNames((0, "RMON-MIB", "channelIndex"))
if mibBuilder.loadTexts: channelEntry.setStatus('current')
if mibBuilder.loadTexts: channelEntry.setDescription('A set of parameters for a packet channel applied on a particular interface. As an example, an instance of the channelMatches object might be named channelMatches.3')
channelIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: channelIndex.setStatus('current')
if mibBuilder.loadTexts: channelIndex.setDescription('An index that uniquely identifies an entry in the channel table. Each such entry defines one channel, a logical data and event stream. It is suggested that before creating a channel, an application should scan all instances of the filterChannelIndex object to make sure that there are no pre-existing filters that would be inadvertently be linked to the channel.')
channelIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: channelIfIndex.setStatus('current')
if mibBuilder.loadTexts: channelIfIndex.setDescription('The value of this object uniquely identifies the interface on this remote network monitoring device to which the associated filters are applied to allow data into this channel. The interface identified by a particular value of this object is the same interface as identified by the same value of the ifIndex object, defined in RFC 2233 [17]. The filters in this group are applied to all packets on the local network segment attached to the identified interface. An agent may or may not be able to tell if fundamental changes to the media of the interface have occurred and necessitate an invalidation of this entry. For example, a hot-pluggable ethernet card could be pulled out and replaced by a token-ring card. In such a case, if the agent has such knowledge of the change, it is recommended that it invalidate this entry. This object may not be modified if the associated channelStatus object is equal to valid(1).')
channelAcceptType = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2))).clone(namedValues=NamedValues(("acceptMatched", 1), ("acceptFailed", 2)))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: channelAcceptType.setStatus('current')
if mibBuilder.loadTexts: channelAcceptType.setDescription('This object controls the action of the filters associated with this channel. If this object is equal to acceptMatched(1), packets will be accepted to this channel if they are accepted by both the packet data and packet status matches of an associated filter. If this object is equal to acceptFailed(2), packets will be accepted to this channel only if they fail either the packet data match or the packet status match of each of the associated filters. In particular, a channel with no associated filters will match no packets if set to acceptMatched(1) case and will match all packets in the acceptFailed(2) case. This object may not be modified if the associated channelStatus object is equal to valid(1).')
channelDataControl = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2))).clone(namedValues=NamedValues(("on", 1), ("off", 2))).clone('off')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: channelDataControl.setStatus('current')
if mibBuilder.loadTexts: channelDataControl.setDescription('This object controls the flow of data through this channel. If this object is on(1), data, status and events flow through this channel. If this object is off(2), data, status and events will not flow through this channel.')
channelTurnOnEventIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: channelTurnOnEventIndex.setStatus('current')
if mibBuilder.loadTexts: channelTurnOnEventIndex.setDescription('The value of this object identifies the event that is configured to turn the associated channelDataControl from off to on when the event is generated. The event identified by a particular value of this object is the same event as identified by the same value of the eventIndex object. If there is no corresponding entry in the eventTable, then no association exists. In fact, if no event is intended for this channel, channelTurnOnEventIndex must be set to zero, a non-existent event index. This object may not be modified if the associated channelStatus object is equal to valid(1).')
channelTurnOffEventIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: channelTurnOffEventIndex.setStatus('current')
if mibBuilder.loadTexts: channelTurnOffEventIndex.setDescription('The value of this object identifies the event that is configured to turn the associated channelDataControl from on to off when the event is generated. The event identified by a particular value of this object is the same event as identified by the same value of the eventIndex object. If there is no corresponding entry in the eventTable, then no association exists. In fact, if no event is intended for this channel, channelTurnOffEventIndex must be set to zero, a non-existent event index. This object may not be modified if the associated channelStatus object is equal to valid(1).')
channelEventIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: channelEventIndex.setStatus('current')
if mibBuilder.loadTexts: channelEventIndex.setDescription('The value of this object identifies the event that is configured to be generated when the associated channelDataControl is on and a packet is matched. The event identified by a particular value of this object is the same event as identified by the same value of the eventIndex object. If there is no corresponding entry in the eventTable, then no association exists. In fact, if no event is intended for this channel, channelEventIndex must be set to zero, a non-existent event index. This object may not be modified if the associated channelStatus object is equal to valid(1).')
channelEventStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 8), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3))).clone(namedValues=NamedValues(("eventReady", 1), ("eventFired", 2), ("eventAlwaysReady", 3))).clone('eventReady')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: channelEventStatus.setStatus('current')
if mibBuilder.loadTexts: channelEventStatus.setDescription('The event status of this channel. If this channel is configured to generate events when packets are matched, a means of controlling the flow of those events is often needed. When this object is equal to eventReady(1), a single event may be generated, after which this object will be set by the probe to eventFired(2). While in the eventFired(2) state, no events will be generated until the object is modified to eventReady(1) (or eventAlwaysReady(3)). The management station can thus easily respond to a notification of an event by re-enabling this object. If the management station wishes to disable this flow control and allow events to be generated at will, this object may be set to eventAlwaysReady(3). Disabling the flow control is discouraged as it can result in high network traffic or other performance problems.')
channelMatches = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 9), Counter32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: channelMatches.setStatus('current')
if mibBuilder.loadTexts: channelMatches.setDescription('The number of times this channel has matched a packet. Note that this object is updated even when channelDataControl is set to off.')
channelDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 10), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 127))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: channelDescription.setStatus('current')
if mibBuilder.loadTexts: channelDescription.setDescription('A comment describing this channel.')
channelOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 11), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: channelOwner.setStatus('current')
if mibBuilder.loadTexts: channelOwner.setDescription('The entity that configured this entry and is therefore using the resources assigned to it.')
channelStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 12), EntryStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: channelStatus.setStatus('current')
if mibBuilder.loadTexts: channelStatus.setDescription('The status of this channel entry.')
bufferControlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 8, 1), )
if mibBuilder.loadTexts: bufferControlTable.setStatus('current')
if mibBuilder.loadTexts: bufferControlTable.setDescription('A list of buffers control entries.')
bufferControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 8, 1, 1), ).setIndexNames((0, "RMON-MIB", "bufferControlIndex"))
if mibBuilder.loadTexts: bufferControlEntry.setStatus('current')
if mibBuilder.loadTexts: bufferControlEntry.setDescription('A set of parameters that control the collection of a stream of packets that have matched filters. As an example, an instance of the bufferControlCaptureSliceSize object might be named bufferControlCaptureSliceSize.3')
bufferControlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: bufferControlIndex.setStatus('current')
if mibBuilder.loadTexts: bufferControlIndex.setDescription('An index that uniquely identifies an entry in the bufferControl table. The value of this index shall never be zero. Each such entry defines one set of packets that is captured and controlled by one or more filters.')
bufferControlChannelIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: bufferControlChannelIndex.setStatus('current')
if mibBuilder.loadTexts: bufferControlChannelIndex.setDescription('An index that identifies the channel that is the source of packets for this bufferControl table. The channel identified by a particular value of this index is the same as identified by the same value of the channelIndex object. This object may not be modified if the associated bufferControlStatus object is equal to valid(1).')
bufferControlFullStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2))).clone(namedValues=NamedValues(("spaceAvailable", 1), ("full", 2)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: bufferControlFullStatus.setStatus('current')
if mibBuilder.loadTexts: bufferControlFullStatus.setDescription('This object shows whether the buffer has room to accept new packets or if it is full. If the status is spaceAvailable(1), the buffer is accepting new packets normally. If the status is full(2) and the associated bufferControlFullAction object is wrapWhenFull, the buffer is accepting new packets by deleting enough of the oldest packets to make room for new ones as they arrive. Otherwise, if the status is full(2) and the bufferControlFullAction object is lockWhenFull, then the buffer has stopped collecting packets. When this object is set to full(2) the probe must not later set it to spaceAvailable(1) except in the case of a significant gain in resources such as an increase of bufferControlOctetsGranted. In particular, the wrap-mode action of deleting old packets to make room for newly arrived packets must not affect the value of this object.')
bufferControlFullAction = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2))).clone(namedValues=NamedValues(("lockWhenFull", 1), ("wrapWhenFull", 2)))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: bufferControlFullAction.setStatus('current')
if mibBuilder.loadTexts: bufferControlFullAction.setDescription('Controls the action of the buffer when it reaches the full status. When in the lockWhenFull(1) state and a packet is added to the buffer that fills the buffer, the bufferControlFullStatus will be set to full(2) and this buffer will stop capturing packets.')
bufferControlCaptureSliceSize = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 5), Integer32().clone(100)).setUnits('Octets').setMaxAccess("readcreate")
if mibBuilder.loadTexts: bufferControlCaptureSliceSize.setStatus('current')
if mibBuilder.loadTexts: bufferControlCaptureSliceSize.setDescription('The maximum number of octets of each packet that will be saved in this capture buffer. For example, if a 1500 octet packet is received by the probe and this object is set to 500, then only 500 octets of the packet will be stored in the associated capture buffer. If this variable is set to 0, the capture buffer will save as many octets as is possible. This object may not be modified if the associated bufferControlStatus object is equal to valid(1).')
bufferControlDownloadSliceSize = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 6), Integer32().clone(100)).setUnits('Octets').setMaxAccess("readcreate")
if mibBuilder.loadTexts: bufferControlDownloadSliceSize.setStatus('current')
if mibBuilder.loadTexts: bufferControlDownloadSliceSize.setDescription('The maximum number of octets of each packet in this capture buffer that will be returned in an SNMP retrieval of that packet. For example, if 500 octets of a packet have been stored in the associated capture buffer, the associated bufferControlDownloadOffset is 0, and this object is set to 100, then the captureBufferPacket object that contains the packet will contain only the first 100 octets of the packet. A prudent manager will take into account possible interoperability or fragmentation problems that may occur if the download slice size is set too large. In particular, conformant SNMP implementations are not required to accept messages whose length exceeds 484 octets, although they are encouraged to support larger datagrams whenever feasible.')
bufferControlDownloadOffset = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 7), Integer32()).setUnits('Octets').setMaxAccess("readcreate")
if mibBuilder.loadTexts: bufferControlDownloadOffset.setStatus('current')
if mibBuilder.loadTexts: bufferControlDownloadOffset.setDescription('The offset of the first octet of each packet in this capture buffer that will be returned in an SNMP retrieval of that packet. For example, if 500 octets of a packet have been stored in the associated capture buffer and this object is set to 100, then the captureBufferPacket object that contains the packet will contain bytes starting 100 octets into the packet.')
bufferControlMaxOctetsRequested = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 8), Integer32().clone(-1)).setUnits('Octets').setMaxAccess("readcreate")
if mibBuilder.loadTexts: bufferControlMaxOctetsRequested.setStatus('current')
if mibBuilder.loadTexts: bufferControlMaxOctetsRequested.setDescription('The requested maximum number of octets to be saved in this captureBuffer, including any implementation-specific overhead. If this variable is set to -1, the capture buffer will save as many octets as is possible. When this object is created or modified, the probe should set bufferControlMaxOctetsGranted as closely to this object as is possible for the particular probe implementation and available resources. However, if the object has the special value of -1, the probe must set bufferControlMaxOctetsGranted to -1.')
bufferControlMaxOctetsGranted = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 9), Integer32()).setUnits('Octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: bufferControlMaxOctetsGranted.setStatus('current')
if mibBuilder.loadTexts: bufferControlMaxOctetsGranted.setDescription('The maximum number of octets that can be saved in this captureBuffer, including overhead. If this variable is -1, the capture buffer will save as many octets as possible. When the bufferControlMaxOctetsRequested object is created or modified, the probe should set this object as closely to the requested value as is possible for the particular probe implementation and available resources. However, if the request object has the special value of -1, the probe must set this object to -1. The probe must not lower this value except as a result of a modification to the associated bufferControlMaxOctetsRequested object. When this maximum number of octets is reached and a new packet is to be added to this capture buffer and the corresponding bufferControlFullAction is set to wrapWhenFull(2), enough of the oldest packets associated with this capture buffer shall be deleted by the agent so that the new packet can be added. If the corresponding bufferControlFullAction is set to lockWhenFull(1), the new packet shall be discarded. In either case, the probe must set bufferControlFullStatus to full(2). When the value of this object changes to a value less than the current value, entries are deleted from the captureBufferTable associated with this bufferControlEntry. Enough of the oldest of these captureBufferEntries shall be deleted by the agent so that the number of octets used remains less than or equal to the new value of this object. When the value of this object changes to a value greater than the current value, the number of associated captureBufferEntries may be allowed to grow.')
bufferControlCapturedPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 10), Integer32()).setUnits('Packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: bufferControlCapturedPackets.setStatus('current')
if mibBuilder.loadTexts: bufferControlCapturedPackets.setDescription('The number of packets currently in this captureBuffer.')
bufferControlTurnOnTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 11), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bufferControlTurnOnTime.setStatus('current')
if mibBuilder.loadTexts: bufferControlTurnOnTime.setDescription('The value of sysUpTime when this capture buffer was first turned on.')
bufferControlOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 12), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: bufferControlOwner.setStatus('current')
if mibBuilder.loadTexts: bufferControlOwner.setDescription('The entity that configured this entry and is therefore using the resources assigned to it.')
bufferControlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 13), EntryStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: bufferControlStatus.setStatus('current')
if mibBuilder.loadTexts: bufferControlStatus.setDescription('The status of this buffer Control Entry.')
captureBufferTable = MibTable((1, 3, 6, 1, 2, 1, 16, 8, 2), )
if mibBuilder.loadTexts: captureBufferTable.setStatus('current')
if mibBuilder.loadTexts: captureBufferTable.setDescription('A list of packets captured off of a channel.')
captureBufferEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 8, 2, 1), ).setIndexNames((0, "RMON-MIB", "captureBufferControlIndex"), (0, "RMON-MIB", "captureBufferIndex"))
if mibBuilder.loadTexts: captureBufferEntry.setStatus('current')
if mibBuilder.loadTexts: captureBufferEntry.setDescription('A packet captured off of an attached network. As an example, an instance of the captureBufferPacketData object might be named captureBufferPacketData.3.1783')
captureBufferControlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: captureBufferControlIndex.setStatus('current')
if mibBuilder.loadTexts: captureBufferControlIndex.setDescription('The index of the bufferControlEntry with which this packet is associated.')
captureBufferIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 2, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: captureBufferIndex.setStatus('current')
if mibBuilder.loadTexts: captureBufferIndex.setDescription('An index that uniquely identifies an entry in the captureBuffer table associated with a particular bufferControlEntry. This index will start at 1 and increase by one for each new packet added with the same captureBufferControlIndex. Should this value reach 2147483647, the next packet added with the same captureBufferControlIndex shall cause this value to wrap around to 1.')
captureBufferPacketID = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 2, 1, 3), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: captureBufferPacketID.setStatus('current')
if mibBuilder.loadTexts: captureBufferPacketID.setDescription("An index that describes the order of packets that are received on a particular interface. The packetID of a packet captured on an interface is defined to be greater than the packetID's of all packets captured previously on the same interface. As the captureBufferPacketID object has a maximum positive value of 2^31 - 1, any captureBufferPacketID object shall have the value of the associated packet's packetID mod 2^31.")
captureBufferPacketData = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 2, 1, 4), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: captureBufferPacketData.setStatus('current')
if mibBuilder.loadTexts: captureBufferPacketData.setDescription('The data inside the packet, starting at the beginning of the packet plus any offset specified in the associated bufferControlDownloadOffset, including any link level headers. The length of the data in this object is the minimum of the length of the captured packet minus the offset, the length of the associated bufferControlCaptureSliceSize minus the offset, and the associated bufferControlDownloadSliceSize. If this minimum is less than zero, this object shall have a length of zero.')
captureBufferPacketLength = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 2, 1, 5), Integer32()).setUnits('Octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: captureBufferPacketLength.setStatus('current')
if mibBuilder.loadTexts: captureBufferPacketLength.setDescription('The actual length (off the wire) of the packet stored in this entry, including FCS octets.')
captureBufferPacketTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 2, 1, 6), Integer32()).setUnits('Milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: captureBufferPacketTime.setStatus('current')
if mibBuilder.loadTexts: captureBufferPacketTime.setDescription('The number of milliseconds that had passed since this capture buffer was first turned on when this packet was captured.')
captureBufferPacketStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 2, 1, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: captureBufferPacketStatus.setStatus('current')
if mibBuilder.loadTexts: captureBufferPacketStatus.setDescription("A value which indicates the error status of this packet. The value of this object is defined in the same way as filterPktStatus. The value is a sum. This sum initially takes the value zero. Then, for each error, E, that has been discovered in this packet, 2 raised to a value representing E is added to the sum. The errors defined for a packet captured off of an Ethernet interface are as follows: bit # Error 0 Packet is longer than 1518 octets 1 Packet is shorter than 64 octets 2 Packet experienced a CRC or Alignment error 3 First packet in this capture buffer after it was detected that some packets were not processed correctly. 4 Packet's order in buffer is only approximate (May only be set for packets sent from the probe) For example, an Ethernet fragment would have a value of 6 (2^1 + 2^2). As this MIB is expanded to new media types, this object will have other media-specific errors defined.")
eventTable = MibTable((1, 3, 6, 1, 2, 1, 16, 9, 1), )
if mibBuilder.loadTexts: eventTable.setStatus('current')
if mibBuilder.loadTexts: eventTable.setDescription('A list of events to be generated.')
eventEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 9, 1, 1), ).setIndexNames((0, "RMON-MIB", "eventIndex"))
if mibBuilder.loadTexts: eventEntry.setStatus('current')
if mibBuilder.loadTexts: eventEntry.setDescription('A set of parameters that describe an event to be generated when certain conditions are met. As an example, an instance of the eventLastTimeSent object might be named eventLastTimeSent.6')
eventIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: eventIndex.setStatus('current')
if mibBuilder.loadTexts: eventIndex.setDescription('An index that uniquely identifies an entry in the event table. Each such entry defines one event that is to be generated when the appropriate conditions occur.')
eventDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 1, 1, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 127))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: eventDescription.setStatus('current')
if mibBuilder.loadTexts: eventDescription.setDescription('A comment describing this event entry.')
eventType = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 1, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4))).clone(namedValues=NamedValues(("none", 1), ("log", 2), ("snmptrap", 3), ("logandtrap", 4)))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: eventType.setStatus('current')
if mibBuilder.loadTexts: eventType.setDescription('The type of notification that the probe will make about this event. In the case of log, an entry is made in the log table for each event. In the case of snmp-trap, an SNMP trap is sent to one or more management stations.')
eventCommunity = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 1, 1, 4), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 127))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: eventCommunity.setStatus('current')
if mibBuilder.loadTexts: eventCommunity.setDescription('If an SNMP trap is to be sent, it will be sent to the SNMP community specified by this octet string.')
eventLastTimeSent = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 1, 1, 5), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: eventLastTimeSent.setStatus('current')
if mibBuilder.loadTexts: eventLastTimeSent.setDescription('The value of sysUpTime at the time this event entry last generated an event. If this entry has not generated any events, this value will be zero.')
eventOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 1, 1, 6), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: eventOwner.setStatus('current')
if mibBuilder.loadTexts: eventOwner.setDescription("The entity that configured this entry and is therefore using the resources assigned to it. If this object contains a string starting with 'monitor' and has associated entries in the log table, all connected management stations should retrieve those log entries, as they may have significance to all management stations connected to this device")
eventStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 1, 1, 7), EntryStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: eventStatus.setStatus('current')
if mibBuilder.loadTexts: eventStatus.setDescription('The status of this event entry. If this object is not equal to valid(1), all associated log entries shall be deleted by the agent.')
logTable = MibTable((1, 3, 6, 1, 2, 1, 16, 9, 2), )
if mibBuilder.loadTexts: logTable.setStatus('current')
if mibBuilder.loadTexts: logTable.setDescription('A list of events that have been logged.')
logEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 9, 2, 1), ).setIndexNames((0, "RMON-MIB", "logEventIndex"), (0, "RMON-MIB", "logIndex"))
if mibBuilder.loadTexts: logEntry.setStatus('current')
if mibBuilder.loadTexts: logEntry.setDescription('A set of data describing an event that has been logged. For example, an instance of the logDescription object might be named logDescription.6.47')
logEventIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: logEventIndex.setStatus('current')
if mibBuilder.loadTexts: logEventIndex.setDescription('The event entry that generated this log entry. The log identified by a particular value of this index is associated with the same eventEntry as identified by the same value of eventIndex.')
logIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 2, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: logIndex.setStatus('current')
if mibBuilder.loadTexts: logIndex.setDescription('An index that uniquely identifies an entry in the log table amongst those generated by the same eventEntries. These indexes are assigned beginning with 1 and increase by one with each new log entry. The association between values of logIndex and logEntries is fixed for the lifetime of each logEntry. The agent may choose to delete the oldest instances of logEntry as required because of lack of memory. It is an implementation-specific matter as to when this deletion may occur.')
logTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 2, 1, 3), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: logTime.setStatus('current')
if mibBuilder.loadTexts: logTime.setDescription('The value of sysUpTime when this log entry was created.')
logDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 2, 1, 4), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: logDescription.setStatus('current')
if mibBuilder.loadTexts: logDescription.setDescription('An implementation dependent description of the event that activated this log entry.')
rmonEventsV2 = ObjectIdentity((1, 3, 6, 1, 2, 1, 16, 0))
if mibBuilder.loadTexts: rmonEventsV2.setStatus('current')
if mibBuilder.loadTexts: rmonEventsV2.setDescription('Definition point for RMON notifications.')
risingAlarm = NotificationType((1, 3, 6, 1, 2, 1, 16, 0, 1)).setObjects(("RMON-MIB", "alarmIndex"), ("RMON-MIB", "alarmVariable"), ("RMON-MIB", "alarmSampleType"), ("RMON-MIB", "alarmValue"), ("RMON-MIB", "alarmRisingThreshold"))
if mibBuilder.loadTexts: risingAlarm.setStatus('current')
if mibBuilder.loadTexts: risingAlarm.setDescription('The SNMP trap that is generated when an alarm entry crosses its rising threshold and generates an event that is configured for sending SNMP traps.')
fallingAlarm = NotificationType((1, 3, 6, 1, 2, 1, 16, 0, 2)).setObjects(("RMON-MIB", "alarmIndex"), ("RMON-MIB", "alarmVariable"), ("RMON-MIB", "alarmSampleType"), ("RMON-MIB", "alarmValue"), ("RMON-MIB", "alarmFallingThreshold"))
if mibBuilder.loadTexts: fallingAlarm.setStatus('current')
if mibBuilder.loadTexts: fallingAlarm.setDescription('The SNMP trap that is generated when an alarm entry crosses its falling threshold and generates an event that is configured for sending SNMP traps.')
rmonCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 20, 9))
rmonGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 20, 10))
rmonCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 16, 20, 9, 1)).setObjects(("RMON-MIB", "rmonEtherStatsGroup"), ("RMON-MIB", "rmonHistoryControlGroup"), ("RMON-MIB", "rmonEthernetHistoryGroup"), ("RMON-MIB", "rmonAlarmGroup"), ("RMON-MIB", "rmonHostGroup"), ("RMON-MIB", "rmonHostTopNGroup"), ("RMON-MIB", "rmonMatrixGroup"), ("RMON-MIB", "rmonFilterGroup"), ("RMON-MIB", "rmonPacketCaptureGroup"), ("RMON-MIB", "rmonEventGroup"))

if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    rmonCompliance = rmonCompliance.setStatus('current')
if mibBuilder.loadTexts: rmonCompliance.setDescription('The requirements for conformance to the RMON MIB. At least one of the groups in this module must be implemented to conform to the RMON MIB. Implementations of this MIB must also implement the system group of MIB-II [16] and the IF-MIB [17].')
rmonEtherStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 10, 1)).setObjects(("RMON-MIB", "etherStatsIndex"), ("RMON-MIB", "etherStatsDataSource"), ("RMON-MIB", "etherStatsDropEvents"), ("RMON-MIB", "etherStatsOctets"), ("RMON-MIB", "etherStatsPkts"), ("RMON-MIB", "etherStatsBroadcastPkts"), ("RMON-MIB", "etherStatsMulticastPkts"), ("RMON-MIB", "etherStatsCRCAlignErrors"), ("RMON-MIB", "etherStatsUndersizePkts"), ("RMON-MIB", "etherStatsOversizePkts"), ("RMON-MIB", "etherStatsFragments"), ("RMON-MIB", "etherStatsJabbers"), ("RMON-MIB", "etherStatsCollisions"), ("RMON-MIB", "etherStatsPkts64Octets"), ("RMON-MIB", "etherStatsPkts65to127Octets"), ("RMON-MIB", "etherStatsPkts128to255Octets"), ("RMON-MIB", "etherStatsPkts256to511Octets"), ("RMON-MIB", "etherStatsPkts512to1023Octets"), ("RMON-MIB", "etherStatsPkts1024to1518Octets"), ("RMON-MIB", "etherStatsOwner"), ("RMON-MIB", "etherStatsStatus"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    rmonEtherStatsGroup = rmonEtherStatsGroup.setStatus('current')
if mibBuilder.loadTexts: rmonEtherStatsGroup.setDescription('The RMON Ethernet Statistics Group.')
rmonHistoryControlGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 10, 2)).setObjects(("RMON-MIB", "historyControlIndex"), ("RMON-MIB", "historyControlDataSource"), ("RMON-MIB", "historyControlBucketsRequested"), ("RMON-MIB", "historyControlBucketsGranted"), ("RMON-MIB", "historyControlInterval"), ("RMON-MIB", "historyControlOwner"), ("RMON-MIB", "historyControlStatus"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    rmonHistoryControlGroup = rmonHistoryControlGroup.setStatus('current')
if mibBuilder.loadTexts: rmonHistoryControlGroup.setDescription('The RMON History Control Group.')
rmonEthernetHistoryGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 10, 3)).setObjects(("RMON-MIB", "etherHistoryIndex"), ("RMON-MIB", "etherHistorySampleIndex"), ("RMON-MIB", "etherHistoryIntervalStart"), ("RMON-MIB", "etherHistoryDropEvents"), ("RMON-MIB", "etherHistoryOctets"), ("RMON-MIB", "etherHistoryPkts"), ("RMON-MIB", "etherHistoryBroadcastPkts"), ("RMON-MIB", "etherHistoryMulticastPkts"), ("RMON-MIB", "etherHistoryCRCAlignErrors"), ("RMON-MIB", "etherHistoryUndersizePkts"), ("RMON-MIB", "etherHistoryOversizePkts"), ("RMON-MIB", "etherHistoryFragments"), ("RMON-MIB", "etherHistoryJabbers"), ("RMON-MIB", "etherHistoryCollisions"), ("RMON-MIB", "etherHistoryUtilization"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    rmonEthernetHistoryGroup = rmonEthernetHistoryGroup.setStatus('current')
if mibBuilder.loadTexts: rmonEthernetHistoryGroup.setDescription('The RMON Ethernet History Group.')
rmonAlarmGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 10, 4)).setObjects(("RMON-MIB", "alarmIndex"), ("RMON-MIB", "alarmInterval"), ("RMON-MIB", "alarmVariable"), ("RMON-MIB", "alarmSampleType"), ("RMON-MIB", "alarmValue"), ("RMON-MIB", "alarmStartupAlarm"), ("RMON-MIB", "alarmRisingThreshold"), ("RMON-MIB", "alarmFallingThreshold"), ("RMON-MIB", "alarmRisingEventIndex"), ("RMON-MIB", "alarmFallingEventIndex"), ("RMON-MIB", "alarmOwner"), ("RMON-MIB", "alarmStatus"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    rmonAlarmGroup = rmonAlarmGroup.setStatus('current')
if mibBuilder.loadTexts: rmonAlarmGroup.setDescription('The RMON Alarm Group.')
rmonHostGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 10, 5)).setObjects(("RMON-MIB", "hostControlIndex"), ("RMON-MIB", "hostControlDataSource"), ("RMON-MIB", "hostControlTableSize"), ("RMON-MIB", "hostControlLastDeleteTime"), ("RMON-MIB", "hostControlOwner"), ("RMON-MIB", "hostControlStatus"), ("RMON-MIB", "hostAddress"), ("RMON-MIB", "hostCreationOrder"), ("RMON-MIB", "hostIndex"), ("RMON-MIB", "hostInPkts"), ("RMON-MIB", "hostOutPkts"), ("RMON-MIB", "hostInOctets"), ("RMON-MIB", "hostOutOctets"), ("RMON-MIB", "hostOutErrors"), ("RMON-MIB", "hostOutBroadcastPkts"), ("RMON-MIB", "hostOutMulticastPkts"), ("RMON-MIB", "hostTimeAddress"), ("RMON-MIB", "hostTimeCreationOrder"), ("RMON-MIB", "hostTimeIndex"), ("RMON-MIB", "hostTimeInPkts"), ("RMON-MIB", "hostTimeOutPkts"), ("RMON-MIB", "hostTimeInOctets"), ("RMON-MIB", "hostTimeOutOctets"), ("RMON-MIB", "hostTimeOutErrors"), ("RMON-MIB", "hostTimeOutBroadcastPkts"), ("RMON-MIB", "hostTimeOutMulticastPkts"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    rmonHostGroup = rmonHostGroup.setStatus('current')
if mibBuilder.loadTexts: rmonHostGroup.setDescription('The RMON Host Group.')
rmonHostTopNGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 10, 6)).setObjects(("RMON-MIB", "hostTopNControlIndex"), ("RMON-MIB", "hostTopNHostIndex"), ("RMON-MIB", "hostTopNRateBase"), ("RMON-MIB", "hostTopNTimeRemaining"), ("RMON-MIB", "hostTopNDuration"), ("RMON-MIB", "hostTopNRequestedSize"), ("RMON-MIB", "hostTopNGrantedSize"), ("RMON-MIB", "hostTopNStartTime"), ("RMON-MIB", "hostTopNOwner"), ("RMON-MIB", "hostTopNStatus"), ("RMON-MIB", "hostTopNReport"), ("RMON-MIB", "hostTopNIndex"), ("RMON-MIB", "hostTopNAddress"), ("RMON-MIB", "hostTopNRate"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    rmonHostTopNGroup = rmonHostTopNGroup.setStatus('current')
if mibBuilder.loadTexts: rmonHostTopNGroup.setDescription("The RMON Host Top 'N' Group.")
rmonMatrixGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 10, 7)).setObjects(("RMON-MIB", "matrixControlIndex"), ("RMON-MIB", "matrixControlDataSource"), ("RMON-MIB", "matrixControlTableSize"), ("RMON-MIB", "matrixControlLastDeleteTime"), ("RMON-MIB", "matrixControlOwner"), ("RMON-MIB", "matrixControlStatus"), ("RMON-MIB", "matrixSDSourceAddress"), ("RMON-MIB", "matrixSDDestAddress"), ("RMON-MIB", "matrixSDIndex"), ("RMON-MIB", "matrixSDPkts"), ("RMON-MIB", "matrixSDOctets"), ("RMON-MIB", "matrixSDErrors"), ("RMON-MIB", "matrixDSSourceAddress"), ("RMON-MIB", "matrixDSDestAddress"), ("RMON-MIB", "matrixDSIndex"), ("RMON-MIB", "matrixDSPkts"), ("RMON-MIB", "matrixDSOctets"), ("RMON-MIB", "matrixDSErrors"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    rmonMatrixGroup = rmonMatrixGroup.setStatus('current')
if mibBuilder.loadTexts: rmonMatrixGroup.setDescription('The RMON Matrix Group.')
rmonFilterGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 10, 8)).setObjects(("RMON-MIB", "filterIndex"), ("RMON-MIB", "filterChannelIndex"), ("RMON-MIB", "filterPktDataOffset"), ("RMON-MIB", "filterPktData"), ("RMON-MIB", "filterPktDataMask"), ("RMON-MIB", "filterPktDataNotMask"), ("RMON-MIB", "filterPktStatus"), ("RMON-MIB", "filterPktStatusMask"), ("RMON-MIB", "filterPktStatusNotMask"), ("RMON-MIB", "filterOwner"), ("RMON-MIB", "filterStatus"), ("RMON-MIB", "channelIndex"), ("RMON-MIB", "channelIfIndex"), ("RMON-MIB", "channelAcceptType"), ("RMON-MIB", "channelDataControl"), ("RMON-MIB", "channelTurnOnEventIndex"), ("RMON-MIB", "channelTurnOffEventIndex"), ("RMON-MIB", "channelEventIndex"), ("RMON-MIB", "channelEventStatus"), ("RMON-MIB", "channelMatches"), ("RMON-MIB", "channelDescription"), ("RMON-MIB", "channelOwner"), ("RMON-MIB", "channelStatus"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    rmonFilterGroup = rmonFilterGroup.setStatus('current')
if mibBuilder.loadTexts: rmonFilterGroup.setDescription('The RMON Filter Group.')
rmonPacketCaptureGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 10, 9)).setObjects(("RMON-MIB", "bufferControlIndex"), ("RMON-MIB", "bufferControlChannelIndex"), ("RMON-MIB", "bufferControlFullStatus"), ("RMON-MIB", "bufferControlFullAction"), ("RMON-MIB", "bufferControlCaptureSliceSize"), ("RMON-MIB", "bufferControlDownloadSliceSize"), ("RMON-MIB", "bufferControlDownloadOffset"), ("RMON-MIB", "bufferControlMaxOctetsRequested"), ("RMON-MIB", "bufferControlMaxOctetsGranted"), ("RMON-MIB", "bufferControlCapturedPackets"), ("RMON-MIB", "bufferControlTurnOnTime"), ("RMON-MIB", "bufferControlOwner"), ("RMON-MIB", "bufferControlStatus"), ("RMON-MIB", "captureBufferControlIndex"), ("RMON-MIB", "captureBufferIndex"), ("RMON-MIB", "captureBufferPacketID"), ("RMON-MIB", "captureBufferPacketData"), ("RMON-MIB", "captureBufferPacketLength"), ("RMON-MIB", "captureBufferPacketTime"), ("RMON-MIB", "captureBufferPacketStatus"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    rmonPacketCaptureGroup = rmonPacketCaptureGroup.setStatus('current')
if mibBuilder.loadTexts: rmonPacketCaptureGroup.setDescription('The RMON Packet Capture Group.')
rmonEventGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 20, 10, 10)).setObjects(("RMON-MIB", "eventIndex"), ("RMON-MIB", "eventDescription"), ("RMON-MIB", "eventType"), ("RMON-MIB", "eventCommunity"), ("RMON-MIB", "eventLastTimeSent"), ("RMON-MIB", "eventOwner"), ("RMON-MIB", "eventStatus"), ("RMON-MIB", "logEventIndex"), ("RMON-MIB", "logIndex"), ("RMON-MIB", "logTime"), ("RMON-MIB", "logDescription"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    rmonEventGroup = rmonEventGroup.setStatus('current')
if mibBuilder.loadTexts: rmonEventGroup.setDescription('The RMON Event Group.')
rmonNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 16, 20, 10, 11)).setObjects(("RMON-MIB", "risingAlarm"), ("RMON-MIB", "fallingAlarm"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    rmonNotificationGroup = rmonNotificationGroup.setStatus('current')
if mibBuilder.loadTexts: rmonNotificationGroup.setDescription('The RMON Notification Group.')
mibBuilder.exportSymbols("RMON-MIB", captureBufferPacketStatus=captureBufferPacketStatus, hostTopNTimeRemaining=hostTopNTimeRemaining, matrixSDTable=matrixSDTable, hostInOctets=hostInOctets, hostTimeInOctets=hostTimeInOctets, eventIndex=eventIndex, hostTimeCreationOrder=hostTimeCreationOrder, PYSNMP_MODULE_ID=rmonMibModule, hostTimeIndex=hostTimeIndex, etherStatsPkts128to255Octets=etherStatsPkts128to255Octets, channelIndex=channelIndex, history=history, etherStatsCRCAlignErrors=etherStatsCRCAlignErrors, etherHistoryJabbers=etherHistoryJabbers, etherHistoryUtilization=etherHistoryUtilization, alarmRisingEventIndex=alarmRisingEventIndex, alarmStatus=alarmStatus, hostTimeOutBroadcastPkts=hostTimeOutBroadcastPkts, hostOutMulticastPkts=hostOutMulticastPkts, hostTopNTable=hostTopNTable, bufferControlMaxOctetsGranted=bufferControlMaxOctetsGranted, eventDescription=eventDescription, hostControlTableSize=hostControlTableSize, hostTable=hostTable, hostTimeOutPkts=hostTimeOutPkts, captureBufferControlIndex=captureBufferControlIndex, alarmVariable=alarmVariable, captureBufferPacketData=captureBufferPacketData, alarmEntry=alarmEntry, matrixDSSourceAddress=matrixDSSourceAddress, etherStatsUndersizePkts=etherStatsUndersizePkts, filterStatus=filterStatus, captureBufferPacketLength=captureBufferPacketLength, hostTopNControlTable=hostTopNControlTable, hostControlStatus=hostControlStatus, matrixDSErrors=matrixDSErrors, bufferControlTurnOnTime=bufferControlTurnOnTime, hostTopNEntry=hostTopNEntry, channelIfIndex=channelIfIndex, hostAddress=hostAddress, matrixControlDataSource=matrixControlDataSource, channelStatus=channelStatus, historyControlInterval=historyControlInterval, rmonCompliance=rmonCompliance, hostOutErrors=hostOutErrors, etherStatsOversizePkts=etherStatsOversizePkts, matrixSDPkts=matrixSDPkts, filterPktDataNotMask=filterPktDataNotMask, matrixControlOwner=matrixControlOwner, hostControlDataSource=hostControlDataSource, hostCreationOrder=hostCreationOrder, hostTopNReport=hostTopNReport, etherHistoryFragments=etherHistoryFragments, matrixDSIndex=matrixDSIndex, EntryStatus=EntryStatus, etherHistoryDropEvents=etherHistoryDropEvents, captureBufferPacketTime=captureBufferPacketTime, logEntry=logEntry, rmonPacketCaptureGroup=rmonPacketCaptureGroup, alarmValue=alarmValue, statistics=statistics, matrixDSDestAddress=matrixDSDestAddress, etherStatsPkts64Octets=etherStatsPkts64Octets, hostTopNDuration=hostTopNDuration, alarmFallingEventIndex=alarmFallingEventIndex, eventStatus=eventStatus, hostTopNAddress=hostTopNAddress, hostTopNRateBase=hostTopNRateBase, eventOwner=eventOwner, etherHistoryIntervalStart=etherHistoryIntervalStart, historyControlBucketsRequested=historyControlBucketsRequested, hostControlEntry=hostControlEntry, hostTimeOutOctets=hostTimeOutOctets, etherStatsMulticastPkts=etherStatsMulticastPkts, filterPktDataOffset=filterPktDataOffset, matrixDSOctets=matrixDSOctets, hostTopNStartTime=hostTopNStartTime, channelOwner=channelOwner, channelEventStatus=channelEventStatus, filterPktStatusNotMask=filterPktStatusNotMask, filterPktStatus=filterPktStatus, etherHistoryPkts=etherHistoryPkts, rmonMatrixGroup=rmonMatrixGroup, hostControlTable=hostControlTable, hostTopNRequestedSize=hostTopNRequestedSize, etherHistoryMulticastPkts=etherHistoryMulticastPkts, etherStatsPkts256to511Octets=etherStatsPkts256to511Octets, hostControlLastDeleteTime=hostControlLastDeleteTime, etherStatsEntry=etherStatsEntry, etherStatsPkts65to127Octets=etherStatsPkts65to127Octets, filterOwner=filterOwner, fallingAlarm=fallingAlarm, alarmRisingThreshold=alarmRisingThreshold, etherHistoryCollisions=etherHistoryCollisions, filterTable=filterTable, rmon=rmon, hostTimeEntry=hostTimeEntry, hostTopNGrantedSize=hostTopNGrantedSize, captureBufferPacketID=captureBufferPacketID, rmonHistoryControlGroup=rmonHistoryControlGroup, bufferControlIndex=bufferControlIndex, alarmInterval=alarmInterval, eventTable=eventTable, eventLastTimeSent=eventLastTimeSent, hostControlIndex=hostControlIndex, etherStatsTable=etherStatsTable, bufferControlTable=bufferControlTable, logTable=logTable, etherHistoryCRCAlignErrors=etherHistoryCRCAlignErrors, hostTopNOwner=hostTopNOwner, alarm=alarm, etherHistoryTable=etherHistoryTable, etherStatsDataSource=etherStatsDataSource, hostTopNRate=hostTopNRate, hostIndex=hostIndex, filter=filter, channelTable=channelTable, logEventIndex=logEventIndex, matrixSDDestAddress=matrixSDDestAddress, etherStatsOwner=etherStatsOwner, historyControlIndex=historyControlIndex, hostTimeOutMulticastPkts=hostTimeOutMulticastPkts, hostTimeInPkts=hostTimeInPkts, matrixControlIndex=matrixControlIndex, captureBufferEntry=captureBufferEntry, eventCommunity=eventCommunity, eventEntry=eventEntry, rmonCompliances=rmonCompliances, rmonEventGroup=rmonEventGroup, hostTimeOutErrors=hostTimeOutErrors, historyControlStatus=historyControlStatus, etherHistoryUndersizePkts=etherHistoryUndersizePkts, hosts=hosts, historyControlDataSource=historyControlDataSource, matrixControlStatus=matrixControlStatus, bufferControlFullStatus=bufferControlFullStatus, etherStatsPkts512to1023Octets=etherStatsPkts512to1023Octets, matrixControlLastDeleteTime=matrixControlLastDeleteTime, filterChannelIndex=filterChannelIndex, filterIndex=filterIndex, bufferControlDownloadSliceSize=bufferControlDownloadSliceSize, hostEntry=hostEntry, channelEntry=channelEntry, hostTopNControlIndex=hostTopNControlIndex, rmonEtherStatsGroup=rmonEtherStatsGroup, rmonMibModule=rmonMibModule, matrixSDSourceAddress=matrixSDSourceAddress, channelTurnOffEventIndex=channelTurnOffEventIndex, bufferControlMaxOctetsRequested=bufferControlMaxOctetsRequested, rmonFilterGroup=rmonFilterGroup, rmonConformance=rmonConformance, etherStatsDropEvents=etherStatsDropEvents, captureBufferIndex=captureBufferIndex, hostTopNControlEntry=hostTopNControlEntry, hostTopNIndex=hostTopNIndex, alarmTable=alarmTable, etherHistoryEntry=etherHistoryEntry, channelTurnOnEventIndex=channelTurnOnEventIndex, hostInPkts=hostInPkts, channelMatches=channelMatches, bufferControlCapturedPackets=bufferControlCapturedPackets, etherHistorySampleIndex=etherHistorySampleIndex, matrixDSEntry=matrixDSEntry, rmonAlarmGroup=rmonAlarmGroup, etherStatsFragments=etherStatsFragments, bufferControlDownloadOffset=bufferControlDownloadOffset, hostOutPkts=hostOutPkts, bufferControlChannelIndex=bufferControlChannelIndex, alarmStartupAlarm=alarmStartupAlarm, logTime=logTime, matrixSDEntry=matrixSDEntry, etherStatsPkts=etherStatsPkts, alarmFallingThreshold=alarmFallingThreshold, event=event, bufferControlStatus=bufferControlStatus, rmonEventsV2=rmonEventsV2, etherStatsOctets=etherStatsOctets, channelEventIndex=channelEventIndex, channelDescription=channelDescription, hostTopN=hostTopN, capture=capture, bufferControlCaptureSliceSize=bufferControlCaptureSliceSize, etherStatsStatus=etherStatsStatus, filterEntry=filterEntry, etherStatsPkts1024to1518Octets=etherStatsPkts1024to1518Octets, eventType=eventType, rmonNotificationGroup=rmonNotificationGroup, matrixSDIndex=matrixSDIndex, matrixDSPkts=matrixDSPkts, historyControlBucketsGranted=historyControlBucketsGranted, hostControlOwner=hostControlOwner, filterPktData=filterPktData, matrixDSTable=matrixDSTable, bufferControlFullAction=bufferControlFullAction, hostTimeTable=hostTimeTable, rmonHostGroup=rmonHostGroup, matrixSDOctets=matrixSDOctets, alarmIndex=alarmIndex, alarmOwner=alarmOwner, risingAlarm=risingAlarm, etherStatsBroadcastPkts=etherStatsBroadcastPkts, channelAcceptType=channelAcceptType, logIndex=logIndex, captureBufferTable=captureBufferTable, etherStatsIndex=etherStatsIndex, hostTopNHostIndex=hostTopNHostIndex, alarmSampleType=alarmSampleType, historyControlOwner=historyControlOwner, matrixControlTableSize=matrixControlTableSize, filterPktStatusMask=filterPktStatusMask, logDescription=logDescription, hostTopNStatus=hostTopNStatus, etherHistoryOversizePkts=etherHistoryOversizePkts, filterPktDataMask=filterPktDataMask, bufferControlEntry=bufferControlEntry, etherHistoryBroadcastPkts=etherHistoryBroadcastPkts, hostOutBroadcastPkts=hostOutBroadcastPkts, etherHistoryOctets=etherHistoryOctets, etherStatsJabbers=etherStatsJabbers, etherStatsCollisions=etherStatsCollisions, channelDataControl=channelDataControl, bufferControlOwner=bufferControlOwner, historyControlTable=historyControlTable, rmonGroups=rmonGroups, matrixSDErrors=matrixSDErrors, rmonHostTopNGroup=rmonHostTopNGroup, matrixControlTable=matrixControlTable, hostOutOctets=hostOutOctets, matrix=matrix, rmonEthernetHistoryGroup=rmonEthernetHistoryGroup, hostTimeAddress=hostTimeAddress, OwnerString=OwnerString, historyControlEntry=historyControlEntry, etherHistoryIndex=etherHistoryIndex, matrixControlEntry=matrixControlEntry)
