#
# PySNMP MIB module Q-BRIDGE-MIB (http://snmplabs.com/pysmi)
# ASN.1 source file://data/mibs/Q-BRIDGE-MIB
# Produced by pysmi-0.3.4 at Wed Jan 29 17:31:16 2020
# On host nerk platform Linux version 5.3.15-300.fc31.x86_64 by user spider
# Using Python version 3.7.5 (default, Oct 17 2019, 12:16:48) 
#
OctetString, Integer, ObjectIdentifier = mibBuilder.importSymbols("ASN1", "OctetString", "Integer", "ObjectIdentifier")
NamedValues, = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
ConstraintsUnion, ConstraintsIntersection, ValueSizeConstraint, ValueRangeConstraint, SingleValueConstraint = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsUnion", "ConstraintsIntersection", "ValueSizeConstraint", "ValueRangeConstraint", "SingleValueConstraint")
dot1dBridge, dot1dBasePort, dot1dBasePortEntry = mibBuilder.importSymbols("BRIDGE-MIB", "dot1dBridge", "dot1dBasePort", "dot1dBasePortEntry")
EnabledStatus, = mibBuilder.importSymbols("P-BRIDGE-MIB", "EnabledStatus")
ObjectGroup, ModuleCompliance, NotificationGroup = mibBuilder.importSymbols("SNMPv2-CONF", "ObjectGroup", "ModuleCompliance", "NotificationGroup")
ObjectIdentity, Counter32, NotificationType, Gauge32, TimeTicks, Unsigned32, Counter64, Integer32, Bits, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, IpAddress, ModuleIdentity, iso = mibBuilder.importSymbols("SNMPv2-SMI", "ObjectIdentity", "Counter32", "NotificationType", "Gauge32", "TimeTicks", "Unsigned32", "Counter64", "Integer32", "Bits", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "IpAddress", "ModuleIdentity", "iso")
TextualConvention, DisplayString, MacAddress, TruthValue, RowStatus = mibBuilder.importSymbols("SNMPv2-TC", "TextualConvention", "DisplayString", "MacAddress", "TruthValue", "RowStatus")
qBridgeMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 17, 7))
qBridgeMIB.setRevisions(('1999-08-25 00:00',))

if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    if mibBuilder.loadTexts: qBridgeMIB.setRevisionsDescriptions(('Initial version, published as RFC 2674.',))
if mibBuilder.loadTexts: qBridgeMIB.setLastUpdated('9908250000Z')
if mibBuilder.loadTexts: qBridgeMIB.setOrganization('IETF Bridge MIB Working Group')
if mibBuilder.loadTexts: qBridgeMIB.setContactInfo(' Les Bell Postal: 3Com Europe Ltd. 3Com Centre, Boundary Way Hemel Hempstead, Herts. HP2 7YU UK Phone: +44 1442 438025 Email: Les_Bell@3Com.com Andrew Smith Postal: Extreme Networks 3585 Monroe St. Santa Clara CA 95051 USA Phone: +1 408 579 2821 Email: andrew@extremenetworks.com Paul Langille Postal: Newbridge Networks 5 Corporate Drive Andover, MA 01810 USA Phone: +1 978 691 4665 Email: langille@newbridge.com Anil Rijhsinghani Postal: Cabletron Systems 50 Minuteman Road Andover, MA 01810 USA Phone: +1 978 684 1295 Email: anil@cabletron.com Keith McCloghrie Postal: cisco Systems, Inc. 170 West Tasman Drive San Jose, CA 95134-1706 USA Phone: +1 408 526 5260 Email: kzm@cisco.com')
if mibBuilder.loadTexts: qBridgeMIB.setDescription('The VLAN Bridge MIB module for managing Virtual Bridged Local Area Networks, as defined by IEEE 802.1Q-1998.')
qBridgeMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 7, 1))
class SnmpAdminString(TextualConvention, OctetString):
    description = 'An octet string containing administrative information, preferably in human-readable form. To facilitate internationalization, this information is represented using the ISO/IEC IS 10646-1 character set, encoded as an octet string using the UTF-8 transformation format described in [RFC2044]. Since additional code points are added by amendments to the 10646 standard from time to time, implementations must be prepared to encounter any code point from 0x00000000 to 0x7fffffff. The use of control codes should be avoided. When it is necessary to represent a newline, the control code sequence CR LF should be used. The use of leading or trailing white space should be avoided. For code points not directly supported by user interface hardware or software, an alternative means of entry and display, such as hexadecimal, may be provided. For information encoded in 7-bit US-ASCII, the UTF-8 encoding is identical to the US-ASCII encoding. Note that when this TC is used for an object that is used or envisioned to be used as an index, then a SIZE restriction must be specified so that the number sub-identifiers for any object instance do not exceed the limit of 128, as defined by [RFC1905].'
    status = 'current'
    displayHint = '255a'
    subtypeSpec = OctetString.subtypeSpec + ValueSizeConstraint(0, 255)

class TimeFilter(TextualConvention, TimeTicks):
    description = "To be used for the index to a table. Allows an application to download only those rows changed since a particular time. A row is considered changed if the value of any object in the row changes or if the row is created or deleted. When sysUpTime is equal to zero, this table shall be empty. One entry exists for each past value of sysUpTime, except that the whole table is purged should sysUpTime wrap. As this basic row is updated new conceptual rows are created (which still share the now updated object values with all other instances). The number of instances which are created is determined by the value of sysUpTime at which the basic row was last updated. One instance will exist for each value of sysUpTime at the last update time for the row. A new timeMark instance is created for each new sysUpTime value. Each new conceptual row will be associated with the timeMark instance which was created at the value of sysUpTime with which the conceptual row is to be associated. By definition all conceptual rows were updated at or after time zero and so at least one conceptual row (associated with timeMark.0) must exist for each underlying (basic) row. See the appendix for further discussion of this variable. Consider the following fooTable: fooTable ... INDEX { fooTimeMark, fooIndex } FooEntry { fooTimeMark TimeFilter fooIndex INTEGER, fooCounts Counter } Should there be two basic rows in this table (fooIndex == 1, fooIndex == 2) and row 1 was updated most recently at time 6, while row 2 was updated most recently at time 8, and both rows had been updated on several earlier occasions such that the current values were 5 and 9 respectively then the following fooCounts instances would exist. fooCounts.0.1 5 fooCounts.0.2 9 fooCounts.1.1 5 fooCounts.1.2 9 fooCounts.2.1 5 fooCounts.2.2 9 fooCounts.3.1 5 fooCounts.3.2 9 fooCounts.4.1 5 fooCounts.4.2 9 fooCounts.5.1 5 fooCounts.5.2 9 fooCounts.6.1 5 fooCounts.6.2 9 fooCounts.7.2 9 -- note that row 1 doesn't exist for fooCounts.8.2 9 -- times 7 and 8"
    status = 'current'

class PortList(TextualConvention, OctetString):
    description = "Each octet within this value specifies a set of eight ports, with the first octet specifying ports 1 through 8, the second octet specifying ports 9 through 16, etc. Within each octet, the most significant bit represents the lowest numbered port, and the least significant bit represents the highest numbered port. Thus, each port of the bridge is represented by a single bit within the value of this object. If that bit has a value of '1' then that port is included in the set of ports; the port is not included if its bit has a value of '0'."
    status = 'current'

class VlanIndex(TextualConvention, Unsigned32):
    description = 'A value used to index per-VLAN tables: values of 0 and 4095 are not permitted; if the value is between 1 and 4094 inclusive, it represents an IEEE 802.1Q VLAN-ID with global scope within a given bridged domain (see VlanId textual convention). If the value is greater than 4095 then it represents a VLAN with scope local to the particular agent, i.e. one without a global VLAN-ID assigned to it. Such VLANs are outside the scope of IEEE 802.1Q but it is convenient to be able to manage them in the same way using this MIB.'
    status = 'current'

class VlanId(TextualConvention, Integer32):
    description = 'A 12-bit VLAN ID used in the VLAN Tag header.'
    status = 'current'
    subtypeSpec = Integer32.subtypeSpec + ValueRangeConstraint(1, 4094)

class VlanIdOrNone(TextualConvention, Integer32):
    description = "The VLAN-ID that uniquely identifies a specific VLAN, or no VLAN. The special value of zero is used to indicate that no VLAN-ID is present or used. This can be used in any situation where an object or a table entry must refer either to a specific VLAN, or to no VLAN. Note that a MIB object that is defined using this TEXTUAL-CONVENTION should clarify the meaning of 'no VLAN' (i.e., the special value 0)."
    status = 'current'
    displayHint = 'd'
    subtypeSpec = Integer32.subtypeSpec + ConstraintsUnion(ValueRangeConstraint(0, 0), ValueRangeConstraint(1, 4094), )
dot1qBase = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 7, 1, 1))
dot1qTp = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 7, 1, 2))
dot1qStatic = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 7, 1, 3))
dot1qVlan = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 7, 1, 4))
dot1qVlanVersionNumber = MibScalar((1, 3, 6, 1, 2, 1, 17, 7, 1, 1, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1))).clone(namedValues=NamedValues(("version1", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qVlanVersionNumber.setReference('IEEE 802.1Q/D11 Section 12.10.1.1')
if mibBuilder.loadTexts: dot1qVlanVersionNumber.setStatus('current')
if mibBuilder.loadTexts: dot1qVlanVersionNumber.setDescription('The version number of IEEE 802.1Q that this device supports.')
dot1qMaxVlanId = MibScalar((1, 3, 6, 1, 2, 1, 17, 7, 1, 1, 2), VlanId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qMaxVlanId.setReference('IEEE 802.1Q/D11 Section 9.3.2.3')
if mibBuilder.loadTexts: dot1qMaxVlanId.setStatus('current')
if mibBuilder.loadTexts: dot1qMaxVlanId.setDescription('The maximum IEEE 802.1Q VLAN ID that this device supports.')
dot1qMaxSupportedVlans = MibScalar((1, 3, 6, 1, 2, 1, 17, 7, 1, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qMaxSupportedVlans.setReference('IEEE 802.1Q/D11 Section 12.10.1.1')
if mibBuilder.loadTexts: dot1qMaxSupportedVlans.setStatus('current')
if mibBuilder.loadTexts: dot1qMaxSupportedVlans.setDescription('The maximum number of IEEE 802.1Q VLANs that this device supports.')
dot1qNumVlans = MibScalar((1, 3, 6, 1, 2, 1, 17, 7, 1, 1, 4), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qNumVlans.setReference('IEEE 802.1Q/D11 Section 12.7.1.1')
if mibBuilder.loadTexts: dot1qNumVlans.setStatus('current')
if mibBuilder.loadTexts: dot1qNumVlans.setDescription('The current number of IEEE 802.1Q VLANs that are configured in this device.')
dot1qGvrpStatus = MibScalar((1, 3, 6, 1, 2, 1, 17, 7, 1, 1, 5), EnabledStatus().clone('disabled')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qGvrpStatus.setStatus('current')
if mibBuilder.loadTexts: dot1qGvrpStatus.setDescription('The administrative status requested by management for GVRP. The value enabled(1) indicates that GVRP should be enabled on this device, on all ports for which it has not been specifically disabled. When disabled(2), GVRP is disabled on all ports and all GVRP packets will be forwarded transparently. This object affects all GVRP Applicant and Registrar state machines. A transition from disabled(2) to enabled(1) will cause a reset of all GVRP state machines on all ports.')
dot1qFdbTable = MibTable((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 1), )
if mibBuilder.loadTexts: dot1qFdbTable.setStatus('current')
if mibBuilder.loadTexts: dot1qFdbTable.setDescription('A table that contains configuration and control information for each Filtering Database currently operating on this device. Entries in this table appear automatically when VLANs are assigned FDB IDs in the dot1qVlanCurrentTable.')
dot1qFdbEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 1, 1), ).setIndexNames((0, "Q-BRIDGE-MIB", "dot1qFdbId"))
if mibBuilder.loadTexts: dot1qFdbEntry.setStatus('current')
if mibBuilder.loadTexts: dot1qFdbEntry.setDescription('Information about a specific Filtering Database.')
dot1qFdbId = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 1, 1, 1), Unsigned32())
if mibBuilder.loadTexts: dot1qFdbId.setStatus('current')
if mibBuilder.loadTexts: dot1qFdbId.setDescription('The identity of this Filtering Database.')
dot1qFdbDynamicCount = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 1, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qFdbDynamicCount.setReference('IEEE 802.1Q/D11 Section 12.7.1.1.3')
if mibBuilder.loadTexts: dot1qFdbDynamicCount.setStatus('current')
if mibBuilder.loadTexts: dot1qFdbDynamicCount.setDescription('The current number of dynamic entries in this Filtering Database.')
dot1qTpFdbTable = MibTable((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 2), )
if mibBuilder.loadTexts: dot1qTpFdbTable.setReference('IEEE 802.1Q/D11 Section 12.7.7')
if mibBuilder.loadTexts: dot1qTpFdbTable.setStatus('current')
if mibBuilder.loadTexts: dot1qTpFdbTable.setDescription('A table that contains information about unicast entries for which the device has forwarding and/or filtering information. This information is used by the transparent bridging function in determining how to propagate a received frame.')
dot1qTpFdbEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 2, 1), ).setIndexNames((0, "Q-BRIDGE-MIB", "dot1qFdbId"), (0, "Q-BRIDGE-MIB", "dot1qTpFdbAddress"))
if mibBuilder.loadTexts: dot1qTpFdbEntry.setStatus('current')
if mibBuilder.loadTexts: dot1qTpFdbEntry.setDescription('Information about a specific unicast MAC address for which the device has some forwarding and/or filtering information.')
dot1qTpFdbAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 2, 1, 1), MacAddress())
if mibBuilder.loadTexts: dot1qTpFdbAddress.setStatus('current')
if mibBuilder.loadTexts: dot1qTpFdbAddress.setDescription('A unicast MAC address for which the device has forwarding and/or filtering information.')
dot1qTpFdbPort = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 2, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qTpFdbPort.setStatus('current')
if mibBuilder.loadTexts: dot1qTpFdbPort.setDescription("Either the value '0', or the port number of the port on which a frame having a source address equal to the value of the corresponding instance of dot1qTpFdbAddress has been seen. A value of '0' indicates that the port number has not been learned but that the device does have some forwarding/filtering information about this address (e.g. in the dot1qStaticUnicastTable). Implementors are encouraged to assign the port value to this object whenever it is learned even for addresses for which the corresponding value of dot1qTpFdbStatus is not learned(3).")
dot1qTpFdbStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 2, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5))).clone(namedValues=NamedValues(("other", 1), ("invalid", 2), ("learned", 3), ("self", 4), ("mgmt", 5)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qTpFdbStatus.setStatus('current')
if mibBuilder.loadTexts: dot1qTpFdbStatus.setDescription("The status of this entry. The meanings of the values are: other(1) - none of the following. This may include the case where some other MIB object (not the corresponding instance of dot1qTpFdbPort, nor an entry in the dot1qStaticUnicastTable) is being used to determine if and how frames addressed to the value of the corresponding instance of dot1qTpFdbAddress are being forwarded. invalid(2) - this entry is no longer valid (e.g., it was learned but has since aged out), but has not yet been flushed from the table. learned(3) - the value of the corresponding instance of dot1qTpFdbPort was learned and is being used. self(4) - the value of the corresponding instance of dot1qTpFdbAddress represents one of the device's addresses. The corresponding instance of dot1qTpFdbPort indicates which of the device's ports has this address. mgmt(5) - the value of the corresponding instance of dot1qTpFdbAddress is also the value of an existing instance of dot1qStaticAddress.")
dot1qTpGroupTable = MibTable((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 3), )
if mibBuilder.loadTexts: dot1qTpGroupTable.setStatus('current')
if mibBuilder.loadTexts: dot1qTpGroupTable.setDescription('A table containing filtering information for VLANs configured into the bridge by (local or network) management, or learnt dynamically, specifying the set of ports to which frames received on a VLAN for this FDB and containing a specific Group destination address are allowed to be forwarded.')
dot1qTpGroupEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 3, 1), ).setIndexNames((0, "Q-BRIDGE-MIB", "dot1qVlanIndex"), (0, "Q-BRIDGE-MIB", "dot1qTpGroupAddress"))
if mibBuilder.loadTexts: dot1qTpGroupEntry.setStatus('current')
if mibBuilder.loadTexts: dot1qTpGroupEntry.setDescription('Filtering information configured into the bridge by management, or learnt dynamically, specifying the set of ports to which frames received on a VLAN and containing a specific Group destination address, are allowed to be forwarded. The subset of these ports learnt dynamically is also provided.')
dot1qTpGroupAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 3, 1, 1), MacAddress())
if mibBuilder.loadTexts: dot1qTpGroupAddress.setStatus('current')
if mibBuilder.loadTexts: dot1qTpGroupAddress.setDescription("The destination Group MAC address in a frame to which this entry's filtering information applies.")
dot1qTpGroupEgressPorts = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 3, 1, 2), PortList()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qTpGroupEgressPorts.setStatus('current')
if mibBuilder.loadTexts: dot1qTpGroupEgressPorts.setDescription('The complete set of ports, in this VLAN, to which frames destined for this Group MAC address are currently being explicitly forwarded. This does not include ports for which this address is only implicitly forwarded, in the dot1qForwardAllPorts list.')
dot1qTpGroupLearnt = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 3, 1, 3), PortList()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qTpGroupLearnt.setStatus('current')
if mibBuilder.loadTexts: dot1qTpGroupLearnt.setDescription('The subset of ports in dot1qTpGroupEgressPorts which were learnt by GMRP or some other dynamic mechanism, in this Filtering database.')
dot1qForwardAllTable = MibTable((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 4), )
if mibBuilder.loadTexts: dot1qForwardAllTable.setReference('IEEE 802.1Q/D11 Section 12.7.2, 12.7.7')
if mibBuilder.loadTexts: dot1qForwardAllTable.setStatus('current')
if mibBuilder.loadTexts: dot1qForwardAllTable.setDescription('A table containing forwarding information for each VLAN, specifying the set of ports to which forwarding of all multicasts applies, configured statically by management or dynamically by GMRP. An entry appears in this table for all VLANs that are currently instantiated.')
dot1qForwardAllEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 4, 1), ).setIndexNames((0, "Q-BRIDGE-MIB", "dot1qVlanIndex"))
if mibBuilder.loadTexts: dot1qForwardAllEntry.setStatus('current')
if mibBuilder.loadTexts: dot1qForwardAllEntry.setDescription('Forwarding information for a VLAN, specifying the set of ports to which all multicasts should be forwarded, configured statically by management or dynamically by GMRP.')
dot1qForwardAllPorts = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 4, 1, 1), PortList()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qForwardAllPorts.setStatus('current')
if mibBuilder.loadTexts: dot1qForwardAllPorts.setDescription('The complete set of ports in this VLAN to which all multicast group-addressed frames are to be forwarded. This includes ports for which this need has been determined dynamically by GMRP, or configured statically by management.')
dot1qForwardAllStaticPorts = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 4, 1, 2), PortList()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qForwardAllStaticPorts.setStatus('current')
if mibBuilder.loadTexts: dot1qForwardAllStaticPorts.setDescription('The set of ports configured by management in this VLAN to which all multicast group-addressed frames are to be forwarded. Ports entered in this list will also appear in the complete set shown by dot1qForwardAllPorts. This value will be restored after the device is reset. This only applies to ports that are members of the VLAN, defined by dot1qVlanCurrentEgressPorts. A port may not be added in this set if it is already a member of the set of ports in dot1qForwardAllForbiddenPorts. The default value is a string of ones of appropriate length, to indicate standard non-EFS behaviour, i.e. forward all multicasts to all ports.')
dot1qForwardAllForbiddenPorts = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 4, 1, 3), PortList()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qForwardAllForbiddenPorts.setStatus('current')
if mibBuilder.loadTexts: dot1qForwardAllForbiddenPorts.setDescription('The set of ports configured by management in this VLAN for which the Service Requirement attribute Forward All Multicast Groups may not be dynamically registered by GMRP. This value will be restored after the device is reset. A port may not be added in this set if it is already a member of the set of ports in dot1qForwardAllStaticPorts. The default value is a string of zeros of appropriate length.')
dot1qForwardUnregisteredTable = MibTable((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 5), )
if mibBuilder.loadTexts: dot1qForwardUnregisteredTable.setReference('IEEE 802.1Q/D11 Section 12.7.2, 12.7.7')
if mibBuilder.loadTexts: dot1qForwardUnregisteredTable.setStatus('current')
if mibBuilder.loadTexts: dot1qForwardUnregisteredTable.setDescription('A table containing forwarding information for each VLAN, specifying the set of ports to which forwarding of multicast group-addressed frames for which there is no more specific forwarding information applies. This is configured statically by management and determined dynamically by GMRP. An entry appears in this table for all VLANs that are currently instantiated.')
dot1qForwardUnregisteredEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 5, 1), ).setIndexNames((0, "Q-BRIDGE-MIB", "dot1qVlanIndex"))
if mibBuilder.loadTexts: dot1qForwardUnregisteredEntry.setStatus('current')
if mibBuilder.loadTexts: dot1qForwardUnregisteredEntry.setDescription('Forwarding information for a VLAN, specifying the set of ports to which all multicasts for which there is no more specific forwarding information shall be forwarded. This is configured statically by management or dynamically by GMRP.')
dot1qForwardUnregisteredPorts = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 5, 1, 1), PortList()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qForwardUnregisteredPorts.setStatus('current')
if mibBuilder.loadTexts: dot1qForwardUnregisteredPorts.setDescription('The complete set of ports in this VLAN to which multicast group-addressed frames for which there is no more specific forwarding information will be forwarded. This includes ports for which this need has been determined dynamically by GMRP, or configured statically by management.')
dot1qForwardUnregisteredStaticPorts = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 5, 1, 2), PortList()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qForwardUnregisteredStaticPorts.setStatus('current')
if mibBuilder.loadTexts: dot1qForwardUnregisteredStaticPorts.setDescription('The set of ports configured by management, in this VLAN, to which multicast group-addressed frames for which there is no more specific forwarding information are to be forwarded. Ports entered in this list will also appear in the complete set shown by dot1qForwardUnregisteredPorts. This value will be restored after the device is reset. A port may not be added in this set if it is already a member of the set of ports in dot1qForwardUnregisteredForbiddenPorts. The default value is a string of zeros of appropriate length, although this has no effect with the default value of dot1qForwardAllStaticPorts.')
dot1qForwardUnregisteredForbiddenPorts = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 5, 1, 3), PortList()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qForwardUnregisteredForbiddenPorts.setStatus('current')
if mibBuilder.loadTexts: dot1qForwardUnregisteredForbiddenPorts.setDescription('The set of ports configured by management in this VLAN for which the Service Requirement attribute Forward Unregistered Multicast Groups may not be dynamically registered by GMRP. This value will be restored after the device is reset. A port may not be added in this set if it is already a member of the set of ports in dot1qForwardUnregisteredStaticPorts. The default value is a string of zeros of appropriate length.')
dot1qStaticUnicastTable = MibTable((1, 3, 6, 1, 2, 1, 17, 7, 1, 3, 1), )
if mibBuilder.loadTexts: dot1qStaticUnicastTable.setReference('IEEE 802.1Q/D11 Section 12.7.7, ISO/IEC 15802-3 Section 7.9.1')
if mibBuilder.loadTexts: dot1qStaticUnicastTable.setStatus('current')
if mibBuilder.loadTexts: dot1qStaticUnicastTable.setDescription('A table containing filtering information for Unicast MAC addresses for each Filtering Database, configured into the device by (local or network) management specifying the set of ports to which frames received from specific ports and containing specific unicast destination addresses are allowed to be forwarded. A value of zero in this table as the port number from which frames with a specific destination address are received, is used to specify all ports for which there is no specific entry in this table for that particular destination address. Entries are valid for unicast addresses only.')
dot1qStaticUnicastEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 7, 1, 3, 1, 1), ).setIndexNames((0, "Q-BRIDGE-MIB", "dot1qFdbId"), (0, "Q-BRIDGE-MIB", "dot1qStaticUnicastAddress"), (0, "Q-BRIDGE-MIB", "dot1qStaticUnicastReceivePort"))
if mibBuilder.loadTexts: dot1qStaticUnicastEntry.setStatus('current')
if mibBuilder.loadTexts: dot1qStaticUnicastEntry.setDescription('Filtering information configured into the device by (local or network) management specifying the set of ports to which frames received from a specific port and containing a specific unicast destination address are allowed to be forwarded.')
dot1qStaticUnicastAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 3, 1, 1, 1), MacAddress())
if mibBuilder.loadTexts: dot1qStaticUnicastAddress.setStatus('current')
if mibBuilder.loadTexts: dot1qStaticUnicastAddress.setDescription("The destination MAC address in a frame to which this entry's filtering information applies. This object must take the value of a unicast address.")
dot1qStaticUnicastReceivePort = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 3, 1, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535)))
if mibBuilder.loadTexts: dot1qStaticUnicastReceivePort.setStatus('current')
if mibBuilder.loadTexts: dot1qStaticUnicastReceivePort.setDescription("Either the value '0', or the port number of the port from which a frame must be received in order for this entry's filtering information to apply. A value of zero indicates that this entry applies on all ports of the device for which there is no other applicable entry.")
dot1qStaticUnicastAllowedToGoTo = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 3, 1, 1, 3), PortList()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qStaticUnicastAllowedToGoTo.setReference('IEEE 802.1Q/D11 Table 8-5, ISO/IEC 15802-3 Table 7-5')
if mibBuilder.loadTexts: dot1qStaticUnicastAllowedToGoTo.setStatus('current')
if mibBuilder.loadTexts: dot1qStaticUnicastAllowedToGoTo.setDescription("The set of ports for which a frame with a specific unicast address will be flooded in the event that it has not been learned. It also specifies the set of ports a specific unicast address may be dynamically learnt on. The dot1qTpFdbTable will have an equivalent entry with a dot1qTpFdbPort value of '0' until this address has been learnt, when it will be updated with the port the address has been seen on. This only applies to ports that are members of the VLAN, defined by dot1qVlanCurrentEgressPorts. The default value of this object is a string of ones of appropriate length.")
dot1qStaticUnicastStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 3, 1, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5))).clone(namedValues=NamedValues(("other", 1), ("invalid", 2), ("permanent", 3), ("deleteOnReset", 4), ("deleteOnTimeout", 5))).clone('permanent')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qStaticUnicastStatus.setStatus('current')
if mibBuilder.loadTexts: dot1qStaticUnicastStatus.setDescription('This object indicates the status of this entry. other(1) - this entry is currently in use but the conditions under which it will remain so differ from the following values. invalid(2) - writing this value to the object removes the corresponding entry. permanent(3) - this entry is currently in use and will remain so after the next reset of the bridge. deleteOnReset(4) - this entry is currently in use and will remain so until the next reset of the bridge. deleteOnTimeout(5) - this entry is currently in use and will remain so until it is aged out.')
dot1qStaticMulticastTable = MibTable((1, 3, 6, 1, 2, 1, 17, 7, 1, 3, 2), )
if mibBuilder.loadTexts: dot1qStaticMulticastTable.setReference('IEEE 802.1Q/D11 Section 12.7.7, ISO/IEC 15802-3 Section 7.9.1')
if mibBuilder.loadTexts: dot1qStaticMulticastTable.setStatus('current')
if mibBuilder.loadTexts: dot1qStaticMulticastTable.setDescription('A table containing filtering information for Multicast and Broadcast MAC addresses for each VLAN, configured into the device by (local or network) management specifying the set of ports to which frames received from specific ports and containing specific Multicast and Broadcast destination addresses are allowed to be forwarded. A value of zero in this table as the port number from which frames with a specific destination address are received, is used to specify all ports for which there is no specific entry in this table for that particular destination address. Entries are valid for Multicast and Broadcast addresses only.')
dot1qStaticMulticastEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 7, 1, 3, 2, 1), ).setIndexNames((0, "Q-BRIDGE-MIB", "dot1qVlanIndex"), (0, "Q-BRIDGE-MIB", "dot1qStaticMulticastAddress"), (0, "Q-BRIDGE-MIB", "dot1qStaticMulticastReceivePort"))
if mibBuilder.loadTexts: dot1qStaticMulticastEntry.setStatus('current')
if mibBuilder.loadTexts: dot1qStaticMulticastEntry.setDescription('Filtering information configured into the device by (local or network) management specifying the set of ports to which frames received from this specific port for this VLAN and containing this Multicast or Broadcast destination address are allowed to be forwarded.')
dot1qStaticMulticastAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 3, 2, 1, 1), MacAddress())
if mibBuilder.loadTexts: dot1qStaticMulticastAddress.setStatus('current')
if mibBuilder.loadTexts: dot1qStaticMulticastAddress.setDescription("The destination MAC address in a frame to which this entry's filtering information applies. This object must take the value of a Multicast or Broadcast address.")
dot1qStaticMulticastReceivePort = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 3, 2, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535)))
if mibBuilder.loadTexts: dot1qStaticMulticastReceivePort.setStatus('current')
if mibBuilder.loadTexts: dot1qStaticMulticastReceivePort.setDescription("Either the value '0', or the port number of the port from which a frame must be received in order for this entry's filtering information to apply. A value of zero indicates that this entry applies on all ports of the device for which there is no other applicable entry.")
dot1qStaticMulticastStaticEgressPorts = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 3, 2, 1, 3), PortList()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qStaticMulticastStaticEgressPorts.setStatus('current')
if mibBuilder.loadTexts: dot1qStaticMulticastStaticEgressPorts.setDescription('The set of ports to which frames received from a specific port and destined for a specific Multicast or Broadcast MAC address must be forwarded, regardless of any dynamic information e.g. from GMRP. A port may not be added in this set if it is already a member of the set of ports in dot1qStaticMulticastForbiddenEgressPorts. The default value of this object is a string of ones of appropriate length.')
dot1qStaticMulticastForbiddenEgressPorts = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 3, 2, 1, 4), PortList()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qStaticMulticastForbiddenEgressPorts.setStatus('current')
if mibBuilder.loadTexts: dot1qStaticMulticastForbiddenEgressPorts.setDescription('The set of ports to which frames received from a specific port and destined for a specific Multicast or Broadcast MAC address must not be forwarded, regardless of any dynamic information e.g. from GMRP. A port may not be added in this set if it is already a member of the set of ports in dot1qStaticMulticastStaticEgressPorts. The default value of this object is a string of zeros of appropriate length.')
dot1qStaticMulticastStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 3, 2, 1, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5))).clone(namedValues=NamedValues(("other", 1), ("invalid", 2), ("permanent", 3), ("deleteOnReset", 4), ("deleteOnTimeout", 5))).clone('permanent')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qStaticMulticastStatus.setStatus('current')
if mibBuilder.loadTexts: dot1qStaticMulticastStatus.setDescription('This object indicates the status of this entry. other(1) - this entry is currently in use but the conditions under which it will remain so differ from the following values. invalid(2) - writing this value to the object removes the corresponding entry. permanent(3) - this entry is currently in use and will remain so after the next reset of the bridge. deleteOnReset(4) - this entry is currently in use and will remain so until the next reset of the bridge. deleteOnTimeout(5) - this entry is currently in use and will remain so until it is aged out.')
dot1qVlanNumDeletes = MibScalar((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qVlanNumDeletes.setStatus('current')
if mibBuilder.loadTexts: dot1qVlanNumDeletes.setDescription('The number of times a VLAN entry has been deleted from the dot1qVlanCurrentTable (for any reason). If an entry is deleted, then inserted, and then deleted, this counter will be incremented by 2.')
dot1qVlanCurrentTable = MibTable((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 2), )
if mibBuilder.loadTexts: dot1qVlanCurrentTable.setStatus('current')
if mibBuilder.loadTexts: dot1qVlanCurrentTable.setDescription('A table containing current configuration information for each VLAN currently configured into the device by (local or network) management, or dynamically created as a result of GVRP requests received.')
dot1qVlanCurrentEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 2, 1), ).setIndexNames((0, "Q-BRIDGE-MIB", "dot1qVlanTimeMark"), (0, "Q-BRIDGE-MIB", "dot1qVlanIndex"))
if mibBuilder.loadTexts: dot1qVlanCurrentEntry.setStatus('current')
if mibBuilder.loadTexts: dot1qVlanCurrentEntry.setDescription('Information for a VLAN configured into the device by (local or network) management, or dynamically created as a result of GVRP requests received.')
dot1qVlanTimeMark = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 2, 1, 1), TimeFilter())
if mibBuilder.loadTexts: dot1qVlanTimeMark.setStatus('current')
if mibBuilder.loadTexts: dot1qVlanTimeMark.setDescription('A TimeFilter for this entry. See the TimeFilter textual convention to see how this works.')
dot1qVlanIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 2, 1, 2), VlanIndex())
if mibBuilder.loadTexts: dot1qVlanIndex.setStatus('current')
if mibBuilder.loadTexts: dot1qVlanIndex.setDescription('The VLAN-ID or other identifier refering to this VLAN.')
dot1qVlanFdbId = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 2, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qVlanFdbId.setStatus('current')
if mibBuilder.loadTexts: dot1qVlanFdbId.setDescription('The Filtering Database used by this VLAN. This is one of the dot1qFdbId values in the dot1qFdbTable. This value is allocated automatically by the device whenever the VLAN is created: either dynamically by GVRP, or by management, in dot1qVlanStaticTable. Allocation of this value follows the learning constraints defined for this VLAN in dot1qLearningConstraintsTable.')
dot1qVlanCurrentEgressPorts = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 2, 1, 4), PortList()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qVlanCurrentEgressPorts.setReference('IEEE 802.1Q/D11 Section 12.10.2.1')
if mibBuilder.loadTexts: dot1qVlanCurrentEgressPorts.setStatus('current')
if mibBuilder.loadTexts: dot1qVlanCurrentEgressPorts.setDescription('The set of ports which are transmitting traffic for this VLAN as either tagged or untagged frames.')
dot1qVlanCurrentUntaggedPorts = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 2, 1, 5), PortList()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qVlanCurrentUntaggedPorts.setReference('IEEE 802.1Q/D11 Section 12.10.2.1')
if mibBuilder.loadTexts: dot1qVlanCurrentUntaggedPorts.setStatus('current')
if mibBuilder.loadTexts: dot1qVlanCurrentUntaggedPorts.setDescription('The set of ports which are transmitting traffic for this VLAN as untagged frames.')
dot1qVlanStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 2, 1, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3))).clone(namedValues=NamedValues(("other", 1), ("permanent", 2), ("dynamicGvrp", 3)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qVlanStatus.setStatus('current')
if mibBuilder.loadTexts: dot1qVlanStatus.setDescription('This object indicates the status of this entry. other(1) - this entry is currently in use but the conditions under which it will remain so differ from the following values. permanent(2) - this entry, corresponding to an entry in dot1qVlanStaticTable, is currently in use and will remain so after the next reset of the device. The port lists for this entry include ports from the equivalent dot1qVlanStaticTable entry and ports learnt dynamically. dynamicGvrp(3) - this entry is currently in use and will remain so until removed by GVRP. There is no static entry for this VLAN and it will be removed when the last port leaves the VLAN.')
dot1qVlanCreationTime = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 2, 1, 7), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qVlanCreationTime.setStatus('current')
if mibBuilder.loadTexts: dot1qVlanCreationTime.setDescription('The value of sysUpTime when this VLAN was created.')
dot1qVlanStaticTable = MibTable((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 3), )
if mibBuilder.loadTexts: dot1qVlanStaticTable.setStatus('current')
if mibBuilder.loadTexts: dot1qVlanStaticTable.setDescription('A table containing static configuration information for each VLAN configured into the device by (local or network) management. All entries are permanent and will be restored after the device is reset.')
dot1qVlanStaticEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 3, 1), ).setIndexNames((0, "Q-BRIDGE-MIB", "dot1qVlanIndex"))
if mibBuilder.loadTexts: dot1qVlanStaticEntry.setStatus('current')
if mibBuilder.loadTexts: dot1qVlanStaticEntry.setDescription('Static information for a VLAN configured into the device by (local or network) management.')
dot1qVlanStaticName = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 3, 1, 1), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 32))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dot1qVlanStaticName.setReference('IEEE 802.1Q/D11 Section 12.10.2.1')
if mibBuilder.loadTexts: dot1qVlanStaticName.setStatus('current')
if mibBuilder.loadTexts: dot1qVlanStaticName.setDescription('An administratively assigned string, which may be used to identify the VLAN.')
dot1qVlanStaticEgressPorts = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 3, 1, 2), PortList()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dot1qVlanStaticEgressPorts.setReference('IEEE 802.1Q/D11 Section 12.7.7.3, 11.2.3.2.3')
if mibBuilder.loadTexts: dot1qVlanStaticEgressPorts.setStatus('current')
if mibBuilder.loadTexts: dot1qVlanStaticEgressPorts.setDescription('The set of ports which are permanently assigned to the egress list for this VLAN by management. Changes to a bit in this object affect the per-port per-VLAN Registrar control for Registration Fixed for the relevant GVRP state machine on each port. A port may not be added in this set if it is already a member of the set of ports in dot1qVlanForbiddenEgressPorts. The default value of this object is a string of zeros of appropriate length, indicating not fixed.')
dot1qVlanForbiddenEgressPorts = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 3, 1, 3), PortList()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dot1qVlanForbiddenEgressPorts.setReference('IEEE 802.1Q/D11 Section 12.7.7.3, 11.2.3.2.3')
if mibBuilder.loadTexts: dot1qVlanForbiddenEgressPorts.setStatus('current')
if mibBuilder.loadTexts: dot1qVlanForbiddenEgressPorts.setDescription('The set of ports which are prohibited by management from being included in the egress list for this VLAN. Changes to this object that cause a port to be included or excluded affect the per-port per-VLAN Registrar control for Registration Forbidden for the relevant GVRP state machine on each port. A port may not be added in this set if it is already a member of the set of ports in dot1qVlanStaticEgressPorts. The default value of this object is a string of zeros of appropriate length, excluding all ports from the forbidden set.')
dot1qVlanStaticUntaggedPorts = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 3, 1, 4), PortList()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dot1qVlanStaticUntaggedPorts.setReference('IEEE 802.1Q/D11 Section 12.10.2.1')
if mibBuilder.loadTexts: dot1qVlanStaticUntaggedPorts.setStatus('current')
if mibBuilder.loadTexts: dot1qVlanStaticUntaggedPorts.setDescription('The set of ports which should transmit egress packets for this VLAN as untagged. The default value of this object for the default VLAN (dot1qVlanIndex = 1) is a string of appropriate length including all ports. There is no specified default for other VLANs. If a device agent cannot support the set of ports being set then it will reject the set operation with an error. An example might be if a manager attempts to set more than one VLAN to be untagged on egress where the device does not support this IEEE 802.1Q option.')
dot1qVlanStaticRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 3, 1, 5), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dot1qVlanStaticRowStatus.setStatus('current')
if mibBuilder.loadTexts: dot1qVlanStaticRowStatus.setDescription("This object indicates the status of this entry. All RowStatus operations are permitted except notInService. Other columns in this row may be modified when the status is 'active'.")
dot1qNextFreeLocalVlanIndex = MibScalar((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(0, 0), ValueRangeConstraint(4096, 2147483647), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qNextFreeLocalVlanIndex.setStatus('current')
if mibBuilder.loadTexts: dot1qNextFreeLocalVlanIndex.setDescription('The next available value for dot1qVlanIndex of a local VLAN entry in dot1qVlanStaticTable. This will report values >=4096 if a new Local VLAN may be created or else the value 0 if this is not possible. A row creation operation in this table for an entry with a local VlanIndex value may fail if the current value of this object is not used as the index. Even if the value read is used, there is no guarantee that it will still be the valid index when the create operation is attempted - another manager may have already got in during the intervening time interval. In this case, dot1qNextFreeLocalVlanIndex should be re-read and the creation re-tried with the new value. This value will automatically change when the current value is used to create a new row.')
dot1qPortVlanTable = MibTable((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 5), )
if mibBuilder.loadTexts: dot1qPortVlanTable.setStatus('current')
if mibBuilder.loadTexts: dot1qPortVlanTable.setDescription('A table containing per port control and status information for VLAN configuration in the device.')
dot1qPortVlanEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 5, 1), )
dot1dBasePortEntry.registerAugmentions(("Q-BRIDGE-MIB", "dot1qPortVlanEntry"))
dot1qPortVlanEntry.setIndexNames(*dot1dBasePortEntry.getIndexNames())
if mibBuilder.loadTexts: dot1qPortVlanEntry.setStatus('current')
if mibBuilder.loadTexts: dot1qPortVlanEntry.setDescription('Information controlling VLAN configuration for a port on the device. This is indexed by dot1dBasePort.')
dot1qPvid = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 5, 1, 1), VlanIndex().clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qPvid.setReference('IEEE 802.1Q/D11 Section 12.10.1.1')
if mibBuilder.loadTexts: dot1qPvid.setStatus('current')
if mibBuilder.loadTexts: dot1qPvid.setDescription('The PVID, the VLAN ID assigned to untagged frames or Priority-Tagged frames received on this port.')
dot1qPortAcceptableFrameTypes = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 5, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2))).clone(namedValues=NamedValues(("admitAll", 1), ("admitOnlyVlanTagged", 2))).clone('admitAll')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qPortAcceptableFrameTypes.setReference('IEEE 802.1Q/D11 Section 12.10.1.3')
if mibBuilder.loadTexts: dot1qPortAcceptableFrameTypes.setStatus('current')
if mibBuilder.loadTexts: dot1qPortAcceptableFrameTypes.setDescription('When this is admitOnlyVlanTagged(2) the device will discard untagged frames or Priority-Tagged frames received on this port. When admitAll(1), untagged frames or Priority-Tagged frames received on this port will be accepted and assigned to the PVID for this port. This control does not affect VLAN independent BPDU frames, such as GVRP and STP. It does affect VLAN dependent BPDU frames, such as GMRP.')
dot1qPortIngressFiltering = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 5, 1, 3), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qPortIngressFiltering.setReference('IEEE 802.1Q/D11 Section 12.10.1.4')
if mibBuilder.loadTexts: dot1qPortIngressFiltering.setStatus('current')
if mibBuilder.loadTexts: dot1qPortIngressFiltering.setDescription('When this is true(1) the device will discard incoming frames for VLANs which do not include this Port in its Member set. When false(2), the port will accept all incoming frames. This control does not affect VLAN independent BPDU frames, such as GVRP and STP. It does affect VLAN dependent BPDU frames, such as GMRP.')
dot1qPortGvrpStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 5, 1, 4), EnabledStatus().clone('enabled')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qPortGvrpStatus.setStatus('current')
if mibBuilder.loadTexts: dot1qPortGvrpStatus.setDescription('The state of GVRP operation on this port. The value enabled(1) indicates that GVRP is enabled on this port, as long as dot1qGvrpStatus is also enabled for this device. When disabled(2) but dot1qGvrpStatus is still enabled for the device, GVRP is disabled on this port: any GVRP packets received will be silently discarded and no GVRP registrations will be propagated from other ports. This object affects all GVRP Applicant and Registrar state machines on this port. A transition from disabled(2) to enabled(1) will cause a reset of all GVRP state machines on this port.')
dot1qPortGvrpFailedRegistrations = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 5, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qPortGvrpFailedRegistrations.setStatus('current')
if mibBuilder.loadTexts: dot1qPortGvrpFailedRegistrations.setDescription('The total number of failed GVRP registrations, for any reason, on this port.')
dot1qPortGvrpLastPduOrigin = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 5, 1, 6), MacAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qPortGvrpLastPduOrigin.setStatus('current')
if mibBuilder.loadTexts: dot1qPortGvrpLastPduOrigin.setDescription('The Source MAC Address of the last GVRP message received on this port.')
dot1qPortVlanStatisticsTable = MibTable((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 6), )
if mibBuilder.loadTexts: dot1qPortVlanStatisticsTable.setStatus('current')
if mibBuilder.loadTexts: dot1qPortVlanStatisticsTable.setDescription('A table containing per-port, per-VLAN statistics for traffic received. Separate objects are provided for both the most-significant and least-significant bits of statistics counters for ports that are associated with this transparent bridge. The most-significant bit objects are only required on high capacity interfaces, as defined in the conformance clauses for these objects. This mechanism is provided as a way to read 64-bit counters for agents which support only SNMPv1. Note that the reporting of most-significant and least- significant counter bits separately runs the risk of missing an overflow of the lower bits in the interval between sampling. The manager must be aware of this possibility, even within the same varbindlist, when interpreting the results of a request or asynchronous notification.')
dot1qPortVlanStatisticsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 6, 1), ).setIndexNames((0, "BRIDGE-MIB", "dot1dBasePort"), (0, "Q-BRIDGE-MIB", "dot1qVlanIndex"))
if mibBuilder.loadTexts: dot1qPortVlanStatisticsEntry.setStatus('current')
if mibBuilder.loadTexts: dot1qPortVlanStatisticsEntry.setDescription('Traffic statistics for a VLAN on an interface.')
dot1qTpVlanPortInFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 6, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qTpVlanPortInFrames.setReference('IEEE 802.1Q/D11 Section 12.6.1.1.3(a)')
if mibBuilder.loadTexts: dot1qTpVlanPortInFrames.setStatus('current')
if mibBuilder.loadTexts: dot1qTpVlanPortInFrames.setDescription('The number of valid frames received by this port from its segment which were classified as belonging to this VLAN. Note that a frame received on this port is counted by this object if and only if it is for a protocol being processed by the local forwarding process for this VLAN. This object includes received bridge management frames classified as belonging to this VLAN (e.g. GMRP, but not GVRP or STP).')
dot1qTpVlanPortOutFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 6, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qTpVlanPortOutFrames.setReference('IEEE 802.1Q/D11 Section 12.6.1.1.3(d)')
if mibBuilder.loadTexts: dot1qTpVlanPortOutFrames.setStatus('current')
if mibBuilder.loadTexts: dot1qTpVlanPortOutFrames.setDescription('The number of valid frames transmitted by this port to its segment from the local forwarding process for this VLAN. This includes bridge management frames originated by this device which are classified as belonging to this VLAN (e.g. GMRP, but not GVRP or STP).')
dot1qTpVlanPortInDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 6, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qTpVlanPortInDiscards.setReference('IEEE 802.1Q/D11 Section 12.6.1.1.3')
if mibBuilder.loadTexts: dot1qTpVlanPortInDiscards.setStatus('current')
if mibBuilder.loadTexts: dot1qTpVlanPortInDiscards.setDescription('The number of valid frames received by this port from its segment which were classified as belonging to this VLAN which were discarded due to VLAN related reasons. Specifically, the IEEE 802.1Q counters for Discard Inbound and Discard on Ingress Filtering.')
dot1qTpVlanPortInOverflowFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 6, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qTpVlanPortInOverflowFrames.setReference('ISO/IEC 15802-3 Section 14.6.1.1.3')
if mibBuilder.loadTexts: dot1qTpVlanPortInOverflowFrames.setStatus('current')
if mibBuilder.loadTexts: dot1qTpVlanPortInOverflowFrames.setDescription('The number of times the associated dot1qTpVlanPortInFrames counter has overflowed.')
dot1qTpVlanPortOutOverflowFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 6, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qTpVlanPortOutOverflowFrames.setReference('ISO/IEC 15802-3 Section 14.6.1.1.3')
if mibBuilder.loadTexts: dot1qTpVlanPortOutOverflowFrames.setStatus('current')
if mibBuilder.loadTexts: dot1qTpVlanPortOutOverflowFrames.setDescription('The number of times the associated dot1qTpVlanPortOutFrames counter has overflowed.')
dot1qTpVlanPortInOverflowDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 6, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qTpVlanPortInOverflowDiscards.setReference('ISO/IEC 15802-3 Section 14.6.1.1.3')
if mibBuilder.loadTexts: dot1qTpVlanPortInOverflowDiscards.setStatus('current')
if mibBuilder.loadTexts: dot1qTpVlanPortInOverflowDiscards.setDescription('The number of times the associated dot1qTpVlanPortInDiscards counter has overflowed.')
dot1qPortVlanHCStatisticsTable = MibTable((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 7), )
if mibBuilder.loadTexts: dot1qPortVlanHCStatisticsTable.setStatus('current')
if mibBuilder.loadTexts: dot1qPortVlanHCStatisticsTable.setDescription('A table containing per port, per VLAN statistics for traffic on high capacity interfaces.')
dot1qPortVlanHCStatisticsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 7, 1), ).setIndexNames((0, "BRIDGE-MIB", "dot1dBasePort"), (0, "Q-BRIDGE-MIB", "dot1qVlanIndex"))
if mibBuilder.loadTexts: dot1qPortVlanHCStatisticsEntry.setStatus('current')
if mibBuilder.loadTexts: dot1qPortVlanHCStatisticsEntry.setDescription('Traffic statistics for a VLAN on a high capacity interface.')
dot1qTpVlanPortHCInFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 7, 1, 1), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qTpVlanPortHCInFrames.setReference('IEEE 802.1Q/D11 Section 12.6.1.1.3(a)')
if mibBuilder.loadTexts: dot1qTpVlanPortHCInFrames.setStatus('current')
if mibBuilder.loadTexts: dot1qTpVlanPortHCInFrames.setDescription('The number of valid frames received by this port from its segment which were classified as belonging to this VLAN. Note that a frame received on this port is counted by this object if and only if it is for a protocol being processed by the local forwarding process for this VLAN. This object includes received bridge management frames classified as belonging to this VLAN (e.g. GMRP, but not GVRP or STP).')
dot1qTpVlanPortHCOutFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 7, 1, 2), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qTpVlanPortHCOutFrames.setReference('IEEE 802.1Q/D11 Section 12.6.1.1.3(d)')
if mibBuilder.loadTexts: dot1qTpVlanPortHCOutFrames.setStatus('current')
if mibBuilder.loadTexts: dot1qTpVlanPortHCOutFrames.setDescription('The number of valid frames transmitted by this port to its segment from the local forwarding process for this VLAN. This includes bridge management frames originated by this device which are classified as belonging to this VLAN (e.g. GMRP, but not GVRP or STP).')
dot1qTpVlanPortHCInDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 7, 1, 3), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qTpVlanPortHCInDiscards.setReference('IEEE 802.1Q/D11 Section 12.6.1.1.3')
if mibBuilder.loadTexts: dot1qTpVlanPortHCInDiscards.setStatus('current')
if mibBuilder.loadTexts: dot1qTpVlanPortHCInDiscards.setDescription('The number of valid frames received by this port from its segment which were classified as belonging to this VLAN which were discarded due to VLAN related reasons. Specifically, the IEEE 802.1Q counters for Discard Inbound and Discard on Ingress Filtering.')
dot1qLearningConstraintsTable = MibTable((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 8), )
if mibBuilder.loadTexts: dot1qLearningConstraintsTable.setReference('IEEE 802.1Q/D11 Section 12.10.3.1')
if mibBuilder.loadTexts: dot1qLearningConstraintsTable.setStatus('current')
if mibBuilder.loadTexts: dot1qLearningConstraintsTable.setDescription('A table containing learning constraints for sets of Shared and Independendent VLANs.')
dot1qLearningConstraintsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 8, 1), ).setIndexNames((0, "Q-BRIDGE-MIB", "dot1qConstraintVlan"), (0, "Q-BRIDGE-MIB", "dot1qConstraintSet"))
if mibBuilder.loadTexts: dot1qLearningConstraintsEntry.setStatus('current')
if mibBuilder.loadTexts: dot1qLearningConstraintsEntry.setDescription('A learning constraint defined for a VLAN.')
dot1qConstraintVlan = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 8, 1, 1), VlanIndex())
if mibBuilder.loadTexts: dot1qConstraintVlan.setStatus('current')
if mibBuilder.loadTexts: dot1qConstraintVlan.setDescription('The index of the row in dot1qVlanCurrentTable for the VLAN constrained by this entry.')
dot1qConstraintSet = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 8, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535)))
if mibBuilder.loadTexts: dot1qConstraintSet.setStatus('current')
if mibBuilder.loadTexts: dot1qConstraintSet.setDescription('The identity of the constraint set to which dot1qConstraintVlan belongs. These values may be chosen by the management station.')
dot1qConstraintType = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 8, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2))).clone(namedValues=NamedValues(("independent", 1), ("shared", 2)))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dot1qConstraintType.setStatus('current')
if mibBuilder.loadTexts: dot1qConstraintType.setDescription('The type of constraint this entry defines. independent(1) - the VLAN, dot1qConstraintVlan, uses an independent filtering database from all other VLANs in the same set, defined by dot1qConstraintSet. shared(2) - the VLAN, dot1qConstraintVlan, shares the same filtering database as all other VLANs in the same set, defined by dot1qConstraintSet.')
dot1qConstraintStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 8, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dot1qConstraintStatus.setStatus('current')
if mibBuilder.loadTexts: dot1qConstraintStatus.setDescription('The status of this entry.')
dot1qConstraintSetDefault = MibScalar((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qConstraintSetDefault.setStatus('current')
if mibBuilder.loadTexts: dot1qConstraintSetDefault.setDescription('The identity of the constraint set to which a VLAN belongs, if there is not an explicit entry for that VLAN in dot1qLearningConstraintsTable.')
dot1qConstraintTypeDefault = MibScalar((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 10), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2))).clone(namedValues=NamedValues(("independent", 1), ("shared", 2)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qConstraintTypeDefault.setStatus('current')
if mibBuilder.loadTexts: dot1qConstraintTypeDefault.setDescription('The type of constraint set to which a VLAN belongs, if there is not an explicit entry for that VLAN in dot1qLearningConstraintsTable. The types are as defined for dot1qConstraintType.')
qBridgeConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 7, 2))
qBridgeGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 7, 2, 1))
qBridgeCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 7, 2, 2))
qBridgeBaseGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 7, 2, 1, 1)).setObjects(("Q-BRIDGE-MIB", "dot1qVlanVersionNumber"), ("Q-BRIDGE-MIB", "dot1qMaxVlanId"), ("Q-BRIDGE-MIB", "dot1qMaxSupportedVlans"), ("Q-BRIDGE-MIB", "dot1qNumVlans"), ("Q-BRIDGE-MIB", "dot1qGvrpStatus"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    qBridgeBaseGroup = qBridgeBaseGroup.setStatus('current')
if mibBuilder.loadTexts: qBridgeBaseGroup.setDescription('A collection of objects providing device level control and status information for the Virtual LAN bridge services.')
qBridgeFdbUnicastGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 7, 2, 1, 2)).setObjects(("Q-BRIDGE-MIB", "dot1qFdbDynamicCount"), ("Q-BRIDGE-MIB", "dot1qTpFdbPort"), ("Q-BRIDGE-MIB", "dot1qTpFdbStatus"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    qBridgeFdbUnicastGroup = qBridgeFdbUnicastGroup.setStatus('current')
if mibBuilder.loadTexts: qBridgeFdbUnicastGroup.setDescription('A collection of objects providing information about all unicast addresses, learnt dynamically or statically configured by management, in each Filtering Database.')
qBridgeFdbMulticastGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 7, 2, 1, 3)).setObjects(("Q-BRIDGE-MIB", "dot1qTpGroupEgressPorts"), ("Q-BRIDGE-MIB", "dot1qTpGroupLearnt"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    qBridgeFdbMulticastGroup = qBridgeFdbMulticastGroup.setStatus('current')
if mibBuilder.loadTexts: qBridgeFdbMulticastGroup.setDescription('A collection of objects providing information about all multicast addresses, learnt dynamically or statically configured by management, in each Filtering Database.')
qBridgeServiceRequirementsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 7, 2, 1, 4)).setObjects(("Q-BRIDGE-MIB", "dot1qForwardAllPorts"), ("Q-BRIDGE-MIB", "dot1qForwardAllStaticPorts"), ("Q-BRIDGE-MIB", "dot1qForwardAllForbiddenPorts"), ("Q-BRIDGE-MIB", "dot1qForwardUnregisteredPorts"), ("Q-BRIDGE-MIB", "dot1qForwardUnregisteredStaticPorts"), ("Q-BRIDGE-MIB", "dot1qForwardUnregisteredForbiddenPorts"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    qBridgeServiceRequirementsGroup = qBridgeServiceRequirementsGroup.setStatus('current')
if mibBuilder.loadTexts: qBridgeServiceRequirementsGroup.setDescription('A collection of objects providing information about service requirements, learnt dynamically or statically configured by management, in each Filtering Database.')
qBridgeFdbStaticGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 7, 2, 1, 5)).setObjects(("Q-BRIDGE-MIB", "dot1qStaticUnicastAllowedToGoTo"), ("Q-BRIDGE-MIB", "dot1qStaticUnicastStatus"), ("Q-BRIDGE-MIB", "dot1qStaticMulticastStaticEgressPorts"), ("Q-BRIDGE-MIB", "dot1qStaticMulticastForbiddenEgressPorts"), ("Q-BRIDGE-MIB", "dot1qStaticMulticastStatus"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    qBridgeFdbStaticGroup = qBridgeFdbStaticGroup.setStatus('current')
if mibBuilder.loadTexts: qBridgeFdbStaticGroup.setDescription('A collection of objects providing information about unicast and multicast addresses statically configured by management, in each Filtering Database or VLAN.')
qBridgeVlanGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 7, 2, 1, 6)).setObjects(("Q-BRIDGE-MIB", "dot1qVlanNumDeletes"), ("Q-BRIDGE-MIB", "dot1qVlanFdbId"), ("Q-BRIDGE-MIB", "dot1qVlanCurrentEgressPorts"), ("Q-BRIDGE-MIB", "dot1qVlanCurrentUntaggedPorts"), ("Q-BRIDGE-MIB", "dot1qVlanStatus"), ("Q-BRIDGE-MIB", "dot1qVlanCreationTime"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    qBridgeVlanGroup = qBridgeVlanGroup.setStatus('current')
if mibBuilder.loadTexts: qBridgeVlanGroup.setDescription('A collection of objects providing information about all VLANs currently configured on this device.')
qBridgeVlanStaticGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 7, 2, 1, 7)).setObjects(("Q-BRIDGE-MIB", "dot1qVlanStaticName"), ("Q-BRIDGE-MIB", "dot1qVlanStaticEgressPorts"), ("Q-BRIDGE-MIB", "dot1qVlanForbiddenEgressPorts"), ("Q-BRIDGE-MIB", "dot1qVlanStaticUntaggedPorts"), ("Q-BRIDGE-MIB", "dot1qVlanStaticRowStatus"), ("Q-BRIDGE-MIB", "dot1qNextFreeLocalVlanIndex"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    qBridgeVlanStaticGroup = qBridgeVlanStaticGroup.setStatus('current')
if mibBuilder.loadTexts: qBridgeVlanStaticGroup.setDescription('A collection of objects providing information about VLANs statically configured by management.')
qBridgePortGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 7, 2, 1, 8)).setObjects(("Q-BRIDGE-MIB", "dot1qPvid"), ("Q-BRIDGE-MIB", "dot1qPortAcceptableFrameTypes"), ("Q-BRIDGE-MIB", "dot1qPortIngressFiltering"), ("Q-BRIDGE-MIB", "dot1qPortGvrpStatus"), ("Q-BRIDGE-MIB", "dot1qPortGvrpFailedRegistrations"), ("Q-BRIDGE-MIB", "dot1qPortGvrpLastPduOrigin"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    qBridgePortGroup = qBridgePortGroup.setStatus('current')
if mibBuilder.loadTexts: qBridgePortGroup.setDescription('A collection of objects providing port level VLAN control and status information for all ports.')
qBridgeVlanStatisticsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 7, 2, 1, 9)).setObjects(("Q-BRIDGE-MIB", "dot1qTpVlanPortInFrames"), ("Q-BRIDGE-MIB", "dot1qTpVlanPortOutFrames"), ("Q-BRIDGE-MIB", "dot1qTpVlanPortInDiscards"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    qBridgeVlanStatisticsGroup = qBridgeVlanStatisticsGroup.setStatus('current')
if mibBuilder.loadTexts: qBridgeVlanStatisticsGroup.setDescription('A collection of objects providing per-port packet statistics for all VLANs currently configured on this device.')
qBridgeVlanStatisticsOverflowGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 7, 2, 1, 10)).setObjects(("Q-BRIDGE-MIB", "dot1qTpVlanPortInOverflowFrames"), ("Q-BRIDGE-MIB", "dot1qTpVlanPortOutOverflowFrames"), ("Q-BRIDGE-MIB", "dot1qTpVlanPortInOverflowDiscards"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    qBridgeVlanStatisticsOverflowGroup = qBridgeVlanStatisticsOverflowGroup.setStatus('current')
if mibBuilder.loadTexts: qBridgeVlanStatisticsOverflowGroup.setDescription('A collection of objects providing overflow counters for per-port packet statistics for all VLANs currently configured on this device for high capacity interfaces, defined as those that have the value of the corresponding instance of ifSpeed greater than 650,000,000 bits/second.')
qBridgeVlanHCStatisticsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 7, 2, 1, 11)).setObjects(("Q-BRIDGE-MIB", "dot1qTpVlanPortHCInFrames"), ("Q-BRIDGE-MIB", "dot1qTpVlanPortHCOutFrames"), ("Q-BRIDGE-MIB", "dot1qTpVlanPortHCInDiscards"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    qBridgeVlanHCStatisticsGroup = qBridgeVlanHCStatisticsGroup.setStatus('current')
if mibBuilder.loadTexts: qBridgeVlanHCStatisticsGroup.setDescription('A collection of objects providing per-port packet statistics for all VLANs currently configured on this device for high capacity interfaces, defined as those that have the value of the corresponding instance of ifSpeed greater than 650,000,000 bits/second.')
qBridgeLearningConstraintsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 7, 2, 1, 12)).setObjects(("Q-BRIDGE-MIB", "dot1qConstraintType"), ("Q-BRIDGE-MIB", "dot1qConstraintStatus"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    qBridgeLearningConstraintsGroup = qBridgeLearningConstraintsGroup.setStatus('current')
if mibBuilder.loadTexts: qBridgeLearningConstraintsGroup.setDescription('A collection of objects defining the Filtering Database constraints all VLANs have with each other.')
qBridgeLearningConstraintDefaultGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 7, 2, 1, 13)).setObjects(("Q-BRIDGE-MIB", "dot1qConstraintSetDefault"), ("Q-BRIDGE-MIB", "dot1qConstraintTypeDefault"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    qBridgeLearningConstraintDefaultGroup = qBridgeLearningConstraintDefaultGroup.setStatus('current')
if mibBuilder.loadTexts: qBridgeLearningConstraintDefaultGroup.setDescription('A collection of objects defining the default Filtering Database constraints for VLANs which have no specific constraints defined.')
qBridgeCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 17, 7, 2, 2, 1)).setObjects(("Q-BRIDGE-MIB", "qBridgeBaseGroup"), ("Q-BRIDGE-MIB", "qBridgeVlanGroup"), ("Q-BRIDGE-MIB", "qBridgeVlanStaticGroup"), ("Q-BRIDGE-MIB", "qBridgePortGroup"), ("Q-BRIDGE-MIB", "qBridgeFdbUnicastGroup"), ("Q-BRIDGE-MIB", "qBridgeFdbMulticastGroup"), ("Q-BRIDGE-MIB", "qBridgeServiceRequirementsGroup"), ("Q-BRIDGE-MIB", "qBridgeFdbStaticGroup"), ("Q-BRIDGE-MIB", "qBridgeVlanStatisticsGroup"), ("Q-BRIDGE-MIB", "qBridgeVlanStatisticsOverflowGroup"), ("Q-BRIDGE-MIB", "qBridgeVlanHCStatisticsGroup"), ("Q-BRIDGE-MIB", "qBridgeLearningConstraintsGroup"), ("Q-BRIDGE-MIB", "qBridgeLearningConstraintDefaultGroup"))

if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    qBridgeCompliance = qBridgeCompliance.setStatus('current')
if mibBuilder.loadTexts: qBridgeCompliance.setDescription('The compliance statement for device support of Virtual LAN Bridge services.')
mibBuilder.exportSymbols("Q-BRIDGE-MIB", dot1qTpGroupAddress=dot1qTpGroupAddress, dot1qPvid=dot1qPvid, dot1qStaticUnicastStatus=dot1qStaticUnicastStatus, dot1qVlanNumDeletes=dot1qVlanNumDeletes, dot1qStaticMulticastAddress=dot1qStaticMulticastAddress, dot1qGvrpStatus=dot1qGvrpStatus, qBridgeFdbMulticastGroup=qBridgeFdbMulticastGroup, qBridgeLearningConstraintDefaultGroup=qBridgeLearningConstraintDefaultGroup, dot1qPortVlanStatisticsEntry=dot1qPortVlanStatisticsEntry, dot1qConstraintSetDefault=dot1qConstraintSetDefault, dot1qForwardAllTable=dot1qForwardAllTable, dot1qVlanStaticName=dot1qVlanStaticName, qBridgeVlanHCStatisticsGroup=qBridgeVlanHCStatisticsGroup, dot1qBase=dot1qBase, dot1qForwardUnregisteredForbiddenPorts=dot1qForwardUnregisteredForbiddenPorts, VlanId=VlanId, dot1qVlanStatus=dot1qVlanStatus, dot1qPortVlanStatisticsTable=dot1qPortVlanStatisticsTable, dot1qTpVlanPortHCInFrames=dot1qTpVlanPortHCInFrames, dot1qForwardAllStaticPorts=dot1qForwardAllStaticPorts, qBridgePortGroup=qBridgePortGroup, qBridgeLearningConstraintsGroup=qBridgeLearningConstraintsGroup, qBridgeVlanStaticGroup=qBridgeVlanStaticGroup, dot1qStaticMulticastReceivePort=dot1qStaticMulticastReceivePort, dot1qPortVlanEntry=dot1qPortVlanEntry, qBridgeBaseGroup=qBridgeBaseGroup, qBridgeServiceRequirementsGroup=qBridgeServiceRequirementsGroup, dot1qVlanStaticEntry=dot1qVlanStaticEntry, dot1qForwardUnregisteredStaticPorts=dot1qForwardUnregisteredStaticPorts, dot1qLearningConstraintsEntry=dot1qLearningConstraintsEntry, dot1qConstraintType=dot1qConstraintType, dot1qForwardAllEntry=dot1qForwardAllEntry, dot1qVlan=dot1qVlan, PYSNMP_MODULE_ID=qBridgeMIB, dot1qPortGvrpFailedRegistrations=dot1qPortGvrpFailedRegistrations, dot1qConstraintSet=dot1qConstraintSet, dot1qStaticMulticastEntry=dot1qStaticMulticastEntry, dot1qVlanCurrentUntaggedPorts=dot1qVlanCurrentUntaggedPorts, dot1qMaxVlanId=dot1qMaxVlanId, dot1qPortGvrpLastPduOrigin=dot1qPortGvrpLastPduOrigin, dot1qPortIngressFiltering=dot1qPortIngressFiltering, dot1qFdbEntry=dot1qFdbEntry, dot1qVlanStaticTable=dot1qVlanStaticTable, dot1qTpVlanPortInDiscards=dot1qTpVlanPortInDiscards, dot1qStaticUnicastAddress=dot1qStaticUnicastAddress, dot1qFdbId=dot1qFdbId, dot1qVlanCurrentEntry=dot1qVlanCurrentEntry, dot1qTpVlanPortOutFrames=dot1qTpVlanPortOutFrames, dot1qTpVlanPortOutOverflowFrames=dot1qTpVlanPortOutOverflowFrames, dot1qForwardAllPorts=dot1qForwardAllPorts, dot1qForwardUnregisteredPorts=dot1qForwardUnregisteredPorts, VlanIndex=VlanIndex, dot1qTpGroupEntry=dot1qTpGroupEntry, dot1qVlanCurrentEgressPorts=dot1qVlanCurrentEgressPorts, qBridgeGroups=qBridgeGroups, dot1qStatic=dot1qStatic, dot1qNumVlans=dot1qNumVlans, dot1qStaticUnicastEntry=dot1qStaticUnicastEntry, dot1qPortVlanHCStatisticsEntry=dot1qPortVlanHCStatisticsEntry, dot1qLearningConstraintsTable=dot1qLearningConstraintsTable, qBridgeFdbUnicastGroup=qBridgeFdbUnicastGroup, PortList=PortList, qBridgeConformance=qBridgeConformance, dot1qStaticMulticastTable=dot1qStaticMulticastTable, dot1qConstraintStatus=dot1qConstraintStatus, dot1qTpFdbStatus=dot1qTpFdbStatus, qBridgeVlanStatisticsGroup=qBridgeVlanStatisticsGroup, dot1qVlanForbiddenEgressPorts=dot1qVlanForbiddenEgressPorts, dot1qPortGvrpStatus=dot1qPortGvrpStatus, qBridgeVlanStatisticsOverflowGroup=qBridgeVlanStatisticsOverflowGroup, dot1qForwardAllForbiddenPorts=dot1qForwardAllForbiddenPorts, dot1qTpGroupLearnt=dot1qTpGroupLearnt, dot1qConstraintTypeDefault=dot1qConstraintTypeDefault, qBridgeMIB=qBridgeMIB, dot1qStaticMulticastForbiddenEgressPorts=dot1qStaticMulticastForbiddenEgressPorts, dot1qVlanCurrentTable=dot1qVlanCurrentTable, dot1qVlanIndex=dot1qVlanIndex, dot1qTpVlanPortInOverflowFrames=dot1qTpVlanPortInOverflowFrames, dot1qTpFdbAddress=dot1qTpFdbAddress, dot1qForwardUnregisteredTable=dot1qForwardUnregisteredTable, qBridgeMIBObjects=qBridgeMIBObjects, dot1qTpVlanPortHCOutFrames=dot1qTpVlanPortHCOutFrames, qBridgeVlanGroup=qBridgeVlanGroup, dot1qStaticUnicastTable=dot1qStaticUnicastTable, dot1qTpFdbEntry=dot1qTpFdbEntry, dot1qConstraintVlan=dot1qConstraintVlan, dot1qStaticUnicastAllowedToGoTo=dot1qStaticUnicastAllowedToGoTo, dot1qVlanStaticEgressPorts=dot1qVlanStaticEgressPorts, dot1qTpVlanPortInOverflowDiscards=dot1qTpVlanPortInOverflowDiscards, dot1qPortAcceptableFrameTypes=dot1qPortAcceptableFrameTypes, dot1qFdbDynamicCount=dot1qFdbDynamicCount, dot1qVlanStaticUntaggedPorts=dot1qVlanStaticUntaggedPorts, dot1qTpGroupTable=dot1qTpGroupTable, dot1qVlanTimeMark=dot1qVlanTimeMark, qBridgeFdbStaticGroup=qBridgeFdbStaticGroup, dot1qStaticMulticastStatus=dot1qStaticMulticastStatus, dot1qVlanVersionNumber=dot1qVlanVersionNumber, dot1qTpFdbPort=dot1qTpFdbPort, dot1qFdbTable=dot1qFdbTable, dot1qPortVlanTable=dot1qPortVlanTable, dot1qForwardUnregisteredEntry=dot1qForwardUnregisteredEntry, dot1qStaticMulticastStaticEgressPorts=dot1qStaticMulticastStaticEgressPorts, dot1qTp=dot1qTp, qBridgeCompliance=qBridgeCompliance, SnmpAdminString=SnmpAdminString, qBridgeCompliances=qBridgeCompliances, dot1qVlanFdbId=dot1qVlanFdbId, dot1qTpFdbTable=dot1qTpFdbTable, TimeFilter=TimeFilter, dot1qMaxSupportedVlans=dot1qMaxSupportedVlans, VlanIdOrNone=VlanIdOrNone, dot1qPortVlanHCStatisticsTable=dot1qPortVlanHCStatisticsTable, dot1qVlanCreationTime=dot1qVlanCreationTime, dot1qVlanStaticRowStatus=dot1qVlanStaticRowStatus, dot1qTpVlanPortHCInDiscards=dot1qTpVlanPortHCInDiscards, dot1qTpVlanPortInFrames=dot1qTpVlanPortInFrames, dot1qStaticUnicastReceivePort=dot1qStaticUnicastReceivePort, dot1qTpGroupEgressPorts=dot1qTpGroupEgressPorts, dot1qNextFreeLocalVlanIndex=dot1qNextFreeLocalVlanIndex)
