#
# PySNMP MIB module Printer-MIB (http://snmplabs.com/pysmi)
# ASN.1 source file://data/mibs/Printer-MIB
# Produced by pysmi-0.3.4 at Wed Jan 29 17:31:16 2020
# On host nerk platform Linux version 5.3.15-300.fc31.x86_64 by user spider
# Using Python version 3.7.5 (default, Oct 17 2019, 12:16:48) 
#
OctetString, Integer, ObjectIdentifier = mibBuilder.importSymbols("ASN1", "OctetString", "Integer", "ObjectIdentifier")
NamedValues, = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
ConstraintsUnion, ConstraintsIntersection, ValueSizeConstraint, ValueRangeConstraint, SingleValueConstraint = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsUnion", "ConstraintsIntersection", "ValueSizeConstraint", "ValueRangeConstraint", "SingleValueConstraint")
hrDeviceIndex, hrStorageIndex = mibBuilder.importSymbols("HOST-RESOURCES-MIB", "hrDeviceIndex", "hrStorageIndex")
IANACharset, = mibBuilder.importSymbols("IANA-CHARSET-MIB", "IANACharset")
PrtConsoleColorTC, PrtCoverStatusTC, PrtMediaPathTypeTC, PrtOutputTypeTC, PrtAlertTrainingLevelTC, PrtChannelTypeTC, PrtMarkerMarkTechTC, PrtAlertGroupTC, PrtInputTypeTC, PrtInterpreterLangFamilyTC, PrtMarkerSuppliesTypeTC, PrtGeneralResetTC, PrtConsoleDisableTC, PrtAlertCodeTC = mibBuilder.importSymbols("IANA-PRINTER-MIB", "PrtConsoleColorTC", "PrtCoverStatusTC", "PrtMediaPathTypeTC", "PrtOutputTypeTC", "PrtAlertTrainingLevelTC", "PrtChannelTypeTC", "PrtMarkerMarkTechTC", "PrtAlertGroupTC", "PrtInputTypeTC", "PrtInterpreterLangFamilyTC", "PrtMarkerSuppliesTypeTC", "PrtGeneralResetTC", "PrtConsoleDisableTC", "PrtAlertCodeTC")
InterfaceIndexOrZero, = mibBuilder.importSymbols("IF-MIB", "InterfaceIndexOrZero")
ObjectGroup, ModuleCompliance, NotificationGroup = mibBuilder.importSymbols("SNMPv2-CONF", "ObjectGroup", "ModuleCompliance", "NotificationGroup")
ObjectIdentity, mib_2, Counter32, NotificationType, Gauge32, TimeTicks, Unsigned32, Counter64, Integer32, Bits, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, IpAddress, ModuleIdentity, iso = mibBuilder.importSymbols("SNMPv2-SMI", "ObjectIdentity", "mib-2", "Counter32", "NotificationType", "Gauge32", "TimeTicks", "Unsigned32", "Counter64", "Integer32", "Bits", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "IpAddress", "ModuleIdentity", "iso")
TextualConvention, DisplayString = mibBuilder.importSymbols("SNMPv2-TC", "TextualConvention", "DisplayString")
printmib = ModuleIdentity((1, 3, 6, 1, 2, 1, 43))
printmib.setRevisions(('2004-06-02 00:00', '1994-11-25 00:00',))

if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    if mibBuilder.loadTexts: printmib.setRevisionsDescriptions(('Printer MIB v2. Moved all enum groups to be maintained by IANA into new TCs within the ianaPrinterMIB, which is contained in this document. New TCs created from enums defined within RFC 1759 Objects: PrtPrintOrientationTC, PrtLocalizedDescriptionStringTC, PrtConsoleDescriptionStringTC, PrtChannelStateTC, PrtOutputStackingOrderTC, PrtOutputPageDeliveryOrientationTC, PrtMarkerCounterUnitTC, PrtMarkerSuppliesSupplyUnitTC, PrtMarkerSuppliesClassTC, PrtMarkerAddressabilityUnitTC, PrtMarkerColorantRoleTC, PrtMediaPathMaxSpeedPrintUnitTC, PrtInterpreterTwoWayTC, and PrtAlertSeverityLevelTC. The following four TCs have been deprecated: MediaUnit (replaced by PrtMediaUnitTC), CapacityUnit (replaced by PrtCapacityUnitTC), SubUnitStatus (replaced by PrtSubUnitStatusTC), CodedCharSet (replaced by IANACharset in IANA Charset MIB) Five new OBJECT-GROUPs: prtAuxilliarySheetGroup, prtInputSwitchingGroup, prtGeneralV2Group, prtAlertTableV2Group, prtChannelV2Group. Nine new objects added to those groups: prtAuxiliarySheetStartupPage, prtAuxiliarySheetBannerPage, prtGeneralPrinterName, prtGeneralSerialNumber, prtAlertCriticalEvents, prtAlertAllEvents, prtInputMediaLoadTimeout, prtInputNextIndex, prtChannelInformation. SYNTAX range changed from (0..65535) to (1..65535) for the index objects prtStorageRefSeqNumber, prtDeviceRefSeqNumber, and prtConsoleLightIndex. SYNTAX range changed from (0..65535) to (0..2147483647) for the objects prtStorageRefIndex and prtDeviceRefIndex to agree with the Host Resources MIB. Defined a range for the objects with a SYNTAX of Integer32: prtOutputDefaultIndex, prtInputMediaDimFeedDirDeclared, prtInputMediaDimXFeedDirDeclared, prtInputMaxCapacity, prtInputCurrentLevel, prtInputMediaDimFeedDirChosen, prtInputMediaDimXFeedDirChosen, prtInputMediaWeight, prtInputMediaFormParts, prtOutputIndex, prtOutputMaxCapacity, prtOutputRemainingCapacity, prtOutputMaxDimFeedDir, prtOutputMaxDimXFeedDir, prtOutputMinDimFeedDir, prtOutputMinDimXFeedDir, prtMarkerAddressibilityFeedDir, prtMarkerAddressibilityXFeedDir, prtMarkerNorthMargin, prtMarkerSouthMargin, prtMarkerWestMargin, prtMarkerEastMargin, prtMarkerSuppliesMaxCapacity, prtMarkerSuppliesLevel, prtMarkerColorantTonality, prtMediaPathMaxSpeed, prtMediaPathMaxMediaFeedDir, prtMediaPathMaxMediaXFeedDir, prtMediaPathMinMediaFeedDir, prtMediaPathMinMediaXFeedDir, prtChannelIndex, prtChannelCurrentJobCntlLangIndex, prtInterpreterIndex, prtChannelDefaultPageDescLangIndex, prtConsoleOnTime, prtInterpreterFeedAddressibility, prtConsoleOffTime, prtInterpreterXFeedAddressibility, prtAlertIndex, prtAlertGroupIndex, prtAlertLocation. Changed SYNTAX from Integer32 to InterfaceIndexOrZero for prtChannelIfIndex. Changed MAX-ACCESS of prtAlertIndex from not-accessible to Read-only and added a compliance statement to allow a MIN-ACCESS of accessible-for-notify. One new NOTIFICATION-GROUP: prtAlertTrapGroup which contains printerV2Alert. In MODULE-COMPLIANCE prtMIBCompliance, new OBJECT-GROUPs and the NOTIFICATION_GROUP, all in GROUP (not MANDATORY-GROUP) clauses. The nine new objects are optional, i.e., this document is backward compatible with RFC 1759.', 'The original version of this MIB, published as RFC1759.',))
if mibBuilder.loadTexts: printmib.setLastUpdated('200406020000Z')
if mibBuilder.loadTexts: printmib.setOrganization('PWG IEEE/ISTO Printer Working Group')
if mibBuilder.loadTexts: printmib.setContactInfo("Harry Lewis IBM Phone (303) 924-5337 Email: harryl@us.ibm.com http://www.pwg.org/index.html Send comments to the printmib WG using the Printer MIB Project (PMP) Mailing List: pmp@pwg.org For further information, access the PWG web page under 'Printer MIB': http://www.pwg.org/ Implementers of this specification are encouraged to join the pmp mailing list in order to participate in discussions on any clarifications needed and registration proposals being reviewed in order to achieve consensus.")
if mibBuilder.loadTexts: printmib.setDescription('The MIB module for management of printers. Copyright (C) The Internet Society (2004). This version of this MIB module was published in RFC 3805. For full legal notices see the RFC itself.')
class PrtMediaUnitTC(TextualConvention, Integer32):
    description = 'Units of measure for media dimensions.'
    status = 'current'
    subtypeSpec = Integer32.subtypeSpec + ConstraintsUnion(SingleValueConstraint(3, 4))
    namedValues = NamedValues(("tenThousandthsOfInches", 3), ("micrometers", 4))

class MediaUnit(TextualConvention, Integer32):
    description = 'Units of measure for media dimensions.'
    status = 'deprecated'
    subtypeSpec = Integer32.subtypeSpec + ConstraintsUnion(SingleValueConstraint(3, 4))
    namedValues = NamedValues(("tenThousandthsOfInches", 3), ("micrometers", 4))

class PrtCapacityUnitTC(TextualConvention, Integer32):
    description = 'Units of measure for media capacity.'
    status = 'current'
    subtypeSpec = Integer32.subtypeSpec + ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 8, 16, 17, 18, 19))
    namedValues = NamedValues(("other", 1), ("unknown", 2), ("tenThousandthsOfInches", 3), ("micrometers", 4), ("sheets", 8), ("feet", 16), ("meters", 17), ("items", 18), ("percent", 19))

class CapacityUnit(TextualConvention, Integer32):
    description = 'Units of measure for media capacity.'
    status = 'deprecated'
    subtypeSpec = Integer32.subtypeSpec + ConstraintsUnion(SingleValueConstraint(3, 4, 8, 16, 17))
    namedValues = NamedValues(("tenThousandthsOfInches", 3), ("micrometers", 4), ("sheets", 8), ("feet", 16), ("meters", 17))

class PrtPrintOrientationTC(TextualConvention, Integer32):
    description = "A generic representation for printing orientation on a 'page'."
    status = 'current'
    subtypeSpec = Integer32.subtypeSpec + ConstraintsUnion(SingleValueConstraint(1, 3, 4))
    namedValues = NamedValues(("other", 1), ("portrait", 3), ("landscape", 4))

class PrtSubUnitStatusTC(TextualConvention, Integer32):
    description = "Status of a printer sub-unit. The SubUnitStatus is an integer that is the sum of 5 distinct values, Availability, Non-Critical, Critical, On-line, and Transitioning. These values are: Availability Value Available and Idle 0 0000'b Available and Standby 2 0010'b Available and Active 4 0100'b Available and Busy 6 0110'b Unavailable and OnRequest 1 0001'b Unavailable because Broken 3 0011'b Unknown 5 0101'b Non-Critical No Non-Critical Alerts 0 0000'b Non-Critical Alerts 8 1000'b Critical No Critical Alerts 0 0000'b Critical Alerts 16 1 0000'b On-Line State is On-Line 0 0000'b State is Off-Line 32 10 0000'b Transitioning At intended state 0 0000'b Transitioning to intended state 64 100 0000'b"
    status = 'current'
    subtypeSpec = Integer32.subtypeSpec + ValueRangeConstraint(0, 126)

class SubUnitStatus(TextualConvention, Integer32):
    description = "Status of a printer sub-unit. The SubUnitStatus is an integer that is the sum of 5 distinct values, Availability, Non-Critical, Critical, On-line, and Transitioning. These values are: Availability Value Available and Idle 0 0000'b Available and Standby 2 0010'b Available and Active 4 0100'b Available and Busy 6 0110'b Unavailable and OnRequest 1 0001'b Unavailable because Broken 3 0011'b Unknown 5 0101'b Non-Critical No Non-Critical Alerts 0 0000'b Non-Critical Alerts 8 1000'b Critical No Critical Alerts 0 0000'b Critical Alerts 16 1 0000'b On-Line State is On-Line 0 0000'b State is Off-Line 32 10 0000'b Transitioning At intended state 0 0000'b Transitioning to intended state 64 100 0000'b"
    status = 'deprecated'
    subtypeSpec = Integer32.subtypeSpec + ValueRangeConstraint(0, 126)

class PresentOnOff(TextualConvention, Integer32):
    description = 'Presence and configuration of a device or feature.'
    status = 'current'
    subtypeSpec = Integer32.subtypeSpec + ConstraintsUnion(SingleValueConstraint(1, 3, 4, 5))
    namedValues = NamedValues(("other", 1), ("on", 3), ("off", 4), ("notPresent", 5))

class PrtLocalizedDescriptionStringTC(TextualConvention, OctetString):
    description = "An object MUST use this TEXTUAL-CONVENTION when its 'charset' is controlled by the value of prtGeneralCurrentLocalization."
    status = 'current'
    subtypeSpec = OctetString.subtypeSpec + ValueSizeConstraint(0, 255)

class PrtConsoleDescriptionStringTC(TextualConvention, OctetString):
    description = "An object MUST use this TEXTUAL-CONVENTION when its 'charset' is controlled by the value of prtConsoleLocalization."
    status = 'current'
    subtypeSpec = OctetString.subtypeSpec + ValueSizeConstraint(0, 255)

class CodedCharSet(TextualConvention, Integer32):
    description = 'The original description clause from RFC 1759 [RFC1759] was technically inaccurate and therefore has been deleted.'
    status = 'deprecated'
    subtypeSpec = Integer32.subtypeSpec + ConstraintsUnion(SingleValueConstraint(1))
    namedValues = NamedValues(("other", 1))

class PrtChannelStateTC(TextualConvention, Integer32):
    description = 'The state of this print job delivery channel. The value determines whether print data is allowed through this channel.'
    status = 'current'
    subtypeSpec = Integer32.subtypeSpec + ConstraintsUnion(SingleValueConstraint(1, 3, 4))
    namedValues = NamedValues(("other", 1), ("printDataAccepted", 3), ("noDataAccepted", 4))

class PrtOutputStackingOrderTC(TextualConvention, Integer32):
    description = "The current state of the stacking order for the associated output sub-unit. 'firstToLast' means that as pages are output, the front of the next page is placed against the back of the previous page. 'lastToFirst' means that as pages are output, the back of the next page is placed against the front of the previous page."
    status = 'current'
    subtypeSpec = Integer32.subtypeSpec + ConstraintsUnion(SingleValueConstraint(2, 3, 4))
    namedValues = NamedValues(("unknown", 2), ("firstToLast", 3), ("lastToFirst", 4))

class PrtOutputPageDeliveryOrientationTC(TextualConvention, Integer32):
    description = "The reading surface that will be 'up' when pages are delivered to the associated output sub-unit. Values are Face-Up and Face Down (Note: interpretation of these values is, in general, context-dependent based on locale; presentation of these values to an end-user should be normalized to the expectations of the user."
    status = 'current'
    subtypeSpec = Integer32.subtypeSpec + ConstraintsUnion(SingleValueConstraint(3, 4))
    namedValues = NamedValues(("faceUp", 3), ("faceDown", 4))

class PrtMarkerCounterUnitTC(TextualConvention, Integer32):
    description = 'The unit that will be used by the printer when reporting counter values for this marking sub-unit. The time units of measure are provided for a device like a strip recorder that does not or cannot track the physical dimensions of the media and does not use characters, lines or sheets.'
    status = 'current'
    subtypeSpec = Integer32.subtypeSpec + ConstraintsUnion(SingleValueConstraint(3, 4, 5, 6, 7, 8, 9, 11, 16, 17))
    namedValues = NamedValues(("tenThousandthsOfInches", 3), ("micrometers", 4), ("characters", 5), ("lines", 6), ("impressions", 7), ("sheets", 8), ("dotRow", 9), ("hours", 11), ("feet", 16), ("meters", 17))

class PrtMarkerSuppliesSupplyUnitTC(TextualConvention, Integer32):
    description = 'Unit of this marker supply container/receptacle.'
    status = 'current'
    subtypeSpec = Integer32.subtypeSpec + ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 7, 8, 11, 12, 13, 14, 15, 16, 17, 18, 19))
    namedValues = NamedValues(("other", 1), ("unknown", 2), ("tenThousandthsOfInches", 3), ("micrometers", 4), ("impressions", 7), ("sheets", 8), ("hours", 11), ("thousandthsOfOunces", 12), ("tenthsOfGrams", 13), ("hundrethsOfFluidOunces", 14), ("tenthsOfMilliliters", 15), ("feet", 16), ("meters", 17), ("items", 18), ("percent", 19))

class PrtMarkerSuppliesClassTC(TextualConvention, Integer32):
    description = 'Indicates whether this supply entity represents a supply that is consumed or a receptacle that is filled.'
    status = 'current'
    subtypeSpec = Integer32.subtypeSpec + ConstraintsUnion(SingleValueConstraint(1, 3, 4))
    namedValues = NamedValues(("other", 1), ("supplyThatIsConsumed", 3), ("receptacleThatIsFilled", 4))

class PrtMarkerColorantRoleTC(TextualConvention, Integer32):
    description = 'The role played by this colorant.'
    status = 'current'
    subtypeSpec = Integer32.subtypeSpec + ConstraintsUnion(SingleValueConstraint(1, 3, 4))
    namedValues = NamedValues(("other", 1), ("process", 3), ("spot", 4))

class PrtMarkerAddressabilityUnitTC(TextualConvention, Integer32):
    description = "The unit of measure of distances, as applied to the marker's resolution."
    status = 'current'
    subtypeSpec = Integer32.subtypeSpec + ConstraintsUnion(SingleValueConstraint(3, 4))
    namedValues = NamedValues(("tenThousandthsOfInches", 3), ("micrometers", 4))

class PrtMediaPathMaxSpeedPrintUnitTC(TextualConvention, Integer32):
    description = 'The unit of measure used in specifying the speed of all media paths in the printer.'
    status = 'current'
    subtypeSpec = Integer32.subtypeSpec + ConstraintsUnion(SingleValueConstraint(3, 4, 5, 6, 7, 8, 9, 16, 17))
    namedValues = NamedValues(("tenThousandthsOfInchesPerHour", 3), ("micrometersPerHour", 4), ("charactersPerHour", 5), ("linesPerHour", 6), ("impressionsPerHour", 7), ("sheetsPerHour", 8), ("dotRowPerHour", 9), ("feetPerHour", 16), ("metersPerHour", 17))

class PrtInterpreterTwoWayTC(TextualConvention, Integer32):
    description = 'Indicates whether or not this interpreter returns information back to the host.'
    status = 'current'
    subtypeSpec = Integer32.subtypeSpec + ConstraintsUnion(SingleValueConstraint(3, 4))
    namedValues = NamedValues(("yes", 3), ("no", 4))

class PrtAlertSeverityLevelTC(TextualConvention, Integer32):
    description = 'The level of severity of this alert table entry. The printer determines the severity level assigned to each entry in the table. A critical alert is binary by nature and definition. A warning is defined to be a non-critical alert. The original and most common warning is unary. The binary warning was added later and given a more distinguished name.'
    status = 'current'
    subtypeSpec = Integer32.subtypeSpec + ConstraintsUnion(SingleValueConstraint(1, 3, 4, 5))
    namedValues = NamedValues(("other", 1), ("critical", 3), ("warning", 4), ("warningBinaryChangeEvent", 5))

prtGeneral = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 5))
prtGeneralTable = MibTable((1, 3, 6, 1, 2, 1, 43, 5, 1), )
if mibBuilder.loadTexts: prtGeneralTable.setStatus('current')
if mibBuilder.loadTexts: prtGeneralTable.setDescription('A table of general information per printer. Objects in this table are defined in various places in the MIB, nearby the groups to which they apply. They are all defined here to minimize the number of tables that would otherwise need to exist.')
prtGeneralEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 5, 1, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"))
if mibBuilder.loadTexts: prtGeneralEntry.setStatus('current')
if mibBuilder.loadTexts: prtGeneralEntry.setDescription("An entry exists in this table for each device entry in the host resources MIB device table with a device type of 'printer'. NOTE: The above description has been modified from RFC 1759 for clarification.")
prtGeneralConfigChanges = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtGeneralConfigChanges.setStatus('current')
if mibBuilder.loadTexts: prtGeneralConfigChanges.setDescription("Counts configuration changes within the printer. A configuration change is defined to be an action that results in a change to any MIB object other than those that reflect status or level, or those that act as counters or gauges. In addition, any action that results in a row being added or deleted from any table in the Printer MIB is considered a configuration change. Such changes will often affect the capability of the printer to service certain types of print jobs. Management applications may cache infrequently changed configuration information about sub units within the printer. This object should be incremented whenever the agent wishes to notify management applications that any cached configuration information for this device is to be considered 'stale'. At this point, the management application should flush any configuration information cached about this device and fetch new configuration information. The following are examples of actions that would cause the prtGeneralConfigChanges object to be incremented: - Adding an output bin - Changing the media in a sensing input tray - Changing the value of prtInputMediaType Note that the prtGeneralConfigChanges counter would not be incremented when an input tray is temporarily removed to load additional paper or when the level of an input device changes. NOTE: The above description has been modified from RFC 1759 for clarification.")
prtGeneralCurrentLocalization = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtGeneralCurrentLocalization.setStatus('current')
if mibBuilder.loadTexts: prtGeneralCurrentLocalization.setDescription("The value of the prtLocalizationIndex corresponding to the current language, country, and character set to be used for localized string values that are identified as being dependent on the value of this object. Note that this object does not apply to localized strings in the prtConsole group or to any object that is not explicitly identified as being localized according to prtGeneralCurrentLocalization. When an object's 'charset' is controlled by the value of prtGeneralCurrentLocalization, it MUST specify PrtLocalizedDescriptionStringTC as its syntax. NOTE: The above description has been modified from RFC 1759 for clarification.")
prtGeneralReset = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 3), PrtGeneralResetTC()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtGeneralReset.setStatus('current')
if mibBuilder.loadTexts: prtGeneralReset.setDescription("Setting this value to 'powerCycleReset', 'resetToNVRAM', or 'resetToFactoryDefaults' will result in the resetting of the printer. When read, this object will always have the value 'notResetting(3)', and a SET of the value 'notResetting' shall have no effect on the printer. Some of the defined values are optional. However, every implementation must support at least the values 'notResetting' and 'resetToNVRAM'.")
prtGeneralCurrentOperator = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 4), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 127))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtGeneralCurrentOperator.setStatus('current')
if mibBuilder.loadTexts: prtGeneralCurrentOperator.setDescription("The name of the person who is responsible for operating this printer. It is suggested that this string include information that would enable other humans to reach the operator, such as a phone number. As a convention to facilitate automatic notification of the operator by the agent or network management station, the phone number, fax number or email address should be indicated by the URL schemes 'tel:', 'fax:' and 'mailto:', respectively. If either the phone, fax, or email information is not available, then a line should not be included for this information. NOTE: For interoperability purposes, it is advisable to use email addresses formatted according to [RFC2822] requirements. NOTE: The above description has been modified from RFC 1759 for clarification.")
prtGeneralServicePerson = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 5), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 127))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtGeneralServicePerson.setStatus('current')
if mibBuilder.loadTexts: prtGeneralServicePerson.setDescription("The name of the person responsible for servicing this printer. It is suggested that this string include information that would enable other humans to reach the service person, such as a phone number. As a convention to facilitate automatic notification of the operator by the agent or network management station, the phone number, fax number or email address should be indicated by the URL schemes 'tel:', 'fax:' and 'mailto:', respectively. If either the phone, fax, or email information is not available, then a line should not be included for this information. NOTE: For interoperability purposes, it is advisable to use email addresses formatted per [RFC2822] requirements. NOTE: The above description has been modified from RFC 1759 for clarification.")
prtInputDefaultIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInputDefaultIndex.setStatus('current')
if mibBuilder.loadTexts: prtInputDefaultIndex.setDescription('The value of prtInputIndex corresponding to the default input sub-unit: that is, this object selects the default source of input media.')
prtOutputDefaultIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputDefaultIndex.setStatus('current')
if mibBuilder.loadTexts: prtOutputDefaultIndex.setDescription('The value of prtOutputIndex corresponding to the default output sub-unit; that is, this object selects the default output destination.')
prtMarkerDefaultIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtMarkerDefaultIndex.setStatus('current')
if mibBuilder.loadTexts: prtMarkerDefaultIndex.setDescription('The value of prtMarkerIndex corresponding to the default marker sub-unit; that is, this object selects the default marker.')
prtMediaPathDefaultIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtMediaPathDefaultIndex.setStatus('current')
if mibBuilder.loadTexts: prtMediaPathDefaultIndex.setDescription('The value of prtMediaPathIndex corresponding to the default media path; that is, the selection of the default media path.')
prtConsoleLocalization = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 10), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtConsoleLocalization.setStatus('current')
if mibBuilder.loadTexts: prtConsoleLocalization.setDescription("The value of the prtLocalizationIndex corresponding to the language, country, and character set to be used for the console. This localization applies both to the actual display on the console as well as the encoding of these console objects in management operations. When an object's 'charset' is controlled by the value of prtConsoleLocalization, it MUST specify PrtConsoleDescriptionStringTC as its syntax. NOTE: The above description has been modified from RFC 1759 for clarification.")
prtConsoleNumberOfDisplayLines = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 11), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtConsoleNumberOfDisplayLines.setStatus('current')
if mibBuilder.loadTexts: prtConsoleNumberOfDisplayLines.setDescription("The number of lines on the printer's physical display. This value is 0 if there are no lines on the physical display or if there is no physical display")
prtConsoleNumberOfDisplayChars = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 12), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtConsoleNumberOfDisplayChars.setStatus('current')
if mibBuilder.loadTexts: prtConsoleNumberOfDisplayChars.setDescription('The number of characters per line displayed on the physical display. This value is 0 if there are no lines on the physical display or if there is no physical display')
prtConsoleDisable = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 13), PrtConsoleDisableTC()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtConsoleDisable.setStatus('current')
if mibBuilder.loadTexts: prtConsoleDisable.setDescription('This value indicates how input is (or is not) accepted from the operator console. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtAuxiliarySheetStartupPage = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 14), PresentOnOff()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtAuxiliarySheetStartupPage.setStatus('current')
if mibBuilder.loadTexts: prtAuxiliarySheetStartupPage.setDescription('Used to enable or disable printing a startup page. If enabled, a startup page will be printed shortly after power-up, when the device is ready. Typical startup pages include test patterns and/or printer configuration information.')
prtAuxiliarySheetBannerPage = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 15), PresentOnOff()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtAuxiliarySheetBannerPage.setStatus('current')
if mibBuilder.loadTexts: prtAuxiliarySheetBannerPage.setDescription('Used to enable or disable printing banner pages at the beginning of jobs. This is a master switch which applies to all jobs, regardless of interpreter.')
prtGeneralPrinterName = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 16), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 127))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtGeneralPrinterName.setStatus('current')
if mibBuilder.loadTexts: prtGeneralPrinterName.setDescription("An administrator-specified name for this printer. Depending upon implementation of this printer, the value of this object may or may not be same as the value for the MIB-II 'SysName' object.")
prtGeneralSerialNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 17), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtGeneralSerialNumber.setStatus('current')
if mibBuilder.loadTexts: prtGeneralSerialNumber.setDescription('A recorded serial number for this device that indexes some type device catalog or inventory. This value is usually set by the device manufacturer but the MIB supports the option of writing for this object for site-specific administration of device inventory or tracking.')
prtAlertCriticalEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtAlertCriticalEvents.setStatus('current')
if mibBuilder.loadTexts: prtAlertCriticalEvents.setDescription('A running counter of the number of critical alert events that have been recorded in the alert table. The value of this object is RESET in the event of a power cycle operation (i.e., the value is not persistent.')
prtAlertAllEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtAlertAllEvents.setStatus('current')
if mibBuilder.loadTexts: prtAlertAllEvents.setDescription('A running counter of the total number of alert event entries (critical and non-critical) that have been recorded in the alert table')
prtCover = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 6))
prtCoverTable = MibTable((1, 3, 6, 1, 2, 1, 43, 6, 1), )
if mibBuilder.loadTexts: prtCoverTable.setStatus('current')
if mibBuilder.loadTexts: prtCoverTable.setDescription('A table of the covers and interlocks of the printer.')
prtCoverEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 6, 1, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Printer-MIB", "prtCoverIndex"))
if mibBuilder.loadTexts: prtCoverEntry.setStatus('current')
if mibBuilder.loadTexts: prtCoverEntry.setDescription("Information about a cover or interlock. Entries may exist in the table for each device index with a device type of 'printer'. NOTE: The above description has been modified from RFC 1759 for clarification.")
prtCoverIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 6, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535)))
if mibBuilder.loadTexts: prtCoverIndex.setStatus('current')
if mibBuilder.loadTexts: prtCoverIndex.setDescription('A unique value used by the printer to identify this Cover sub unit. Although these values may change due to a major reconfiguration of the device (e.g., the addition of new cover sub-units to the printer), values SHOULD remain stable across successive printer power cycles. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtCoverDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 6, 1, 1, 2), PrtLocalizedDescriptionStringTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtCoverDescription.setStatus('current')
if mibBuilder.loadTexts: prtCoverDescription.setDescription('The manufacturer provided cover sub-mechanism name in the localization specified by prtGeneralCurrentLocalization.')
prtCoverStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 6, 1, 1, 3), PrtCoverStatusTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtCoverStatus.setStatus('current')
if mibBuilder.loadTexts: prtCoverStatus.setDescription('The status of this cover sub-unit.')
prtLocalization = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 7))
prtLocalizationTable = MibTable((1, 3, 6, 1, 2, 1, 43, 7, 1), )
if mibBuilder.loadTexts: prtLocalizationTable.setStatus('current')
if mibBuilder.loadTexts: prtLocalizationTable.setDescription('The available localizations in this printer.')
prtLocalizationEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 7, 1, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Printer-MIB", "prtLocalizationIndex"))
if mibBuilder.loadTexts: prtLocalizationEntry.setStatus('current')
if mibBuilder.loadTexts: prtLocalizationEntry.setDescription("A description of a localization. Entries may exist in the table for each device index with a device type of 'printer'. NOTE: The above description has been modified from RFC 1759 for clarification.")
prtLocalizationIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 7, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535)))
if mibBuilder.loadTexts: prtLocalizationIndex.setStatus('current')
if mibBuilder.loadTexts: prtLocalizationIndex.setDescription('A unique value used by the printer to identify this localization entry. Although these values may change due to a major reconfiguration of the device (e.g., the addition of new localization data to the printer), values SHOULD remain stable across successive printer power cycles. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtLocalizationLanguage = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 7, 1, 1, 2), OctetString().subtype(subtypeSpec=ValueSizeConstraint(2, 2)).setFixedLength(2)).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtLocalizationLanguage.setStatus('current')
if mibBuilder.loadTexts: prtLocalizationLanguage.setDescription('A two character language code from ISO 639. Examples en, es, fr, de. NOTE: These examples were shown as upper case in RFC 1759 and are now shown as lower case to agree with ISO 639.')
prtLocalizationCountry = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 7, 1, 1, 3), OctetString().subtype(subtypeSpec=ValueSizeConstraint(2, 2)).setFixedLength(2)).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtLocalizationCountry.setStatus('current')
if mibBuilder.loadTexts: prtLocalizationCountry.setDescription('A two character country code from ISO 3166, a blank string (two space characters) shall indicate that the country is not defined. Examples: US, GB, FR, DE, ...')
prtLocalizationCharacterSet = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 7, 1, 1, 4), IANACharset()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtLocalizationCharacterSet.setStatus('current')
if mibBuilder.loadTexts: prtLocalizationCharacterSet.setDescription('The coded character set used for this localization.')
prtStorageRefTable = MibTable((1, 3, 6, 1, 2, 1, 43, 5, 2), )
if mibBuilder.loadTexts: prtStorageRefTable.setStatus('current')
if mibBuilder.loadTexts: prtStorageRefTable.setDescription('This table defines which printer, amongst multiple printers serviced by one agent, owns which storage units. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtStorageRefEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 5, 2, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrStorageIndex"), (0, "Printer-MIB", "prtStorageRefSeqNumber"))
if mibBuilder.loadTexts: prtStorageRefEntry.setStatus('current')
if mibBuilder.loadTexts: prtStorageRefEntry.setDescription('This table will have an entry for each entry in the Host Resources MIB storage table that represents storage associated with a printer managed by this agent. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtStorageRefSeqNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535)))
if mibBuilder.loadTexts: prtStorageRefSeqNumber.setStatus('current')
if mibBuilder.loadTexts: prtStorageRefSeqNumber.setDescription('This value will be unique amongst all entries with a common value of hrStorageIndex. This object allows a storage entry to point to the multiple printer devices with which it is associated.')
prtStorageRefIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 2, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtStorageRefIndex.setStatus('current')
if mibBuilder.loadTexts: prtStorageRefIndex.setDescription('The value of the hrDeviceIndex of the printer device that this storageEntry is associated with.')
prtDeviceRefTable = MibTable((1, 3, 6, 1, 2, 1, 43, 5, 3), )
if mibBuilder.loadTexts: prtDeviceRefTable.setStatus('current')
if mibBuilder.loadTexts: prtDeviceRefTable.setDescription('This table defines which printer, amongst multiple printers serviced by one agent, is associated with which devices. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtDeviceRefEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 5, 3, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Printer-MIB", "prtDeviceRefSeqNumber"))
if mibBuilder.loadTexts: prtDeviceRefEntry.setStatus('current')
if mibBuilder.loadTexts: prtDeviceRefEntry.setDescription('This table will have an entry for each entry in the Host Resources MIB device table that represents a device associated with a printer managed by this agent. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtDeviceRefSeqNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 3, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535)))
if mibBuilder.loadTexts: prtDeviceRefSeqNumber.setStatus('current')
if mibBuilder.loadTexts: prtDeviceRefSeqNumber.setDescription('This value will be unique amongst all entries with a common value of hrDeviceIndex. This object allows a device entry to point to the multiple printer devices with which it is associated.')
prtDeviceRefIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 3, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtDeviceRefIndex.setStatus('current')
if mibBuilder.loadTexts: prtDeviceRefIndex.setDescription('The value of the hrDeviceIndex of the printer device that this deviceEntry is associated with.')
prtInput = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 8))
prtInputTable = MibTable((1, 3, 6, 1, 2, 1, 43, 8, 2), )
if mibBuilder.loadTexts: prtInputTable.setStatus('current')
if mibBuilder.loadTexts: prtInputTable.setDescription('A table of the devices capable of providing media for input to the printing process.')
prtInputEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 8, 2, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Printer-MIB", "prtInputIndex"))
if mibBuilder.loadTexts: prtInputEntry.setStatus('current')
if mibBuilder.loadTexts: prtInputEntry.setDescription("Attributes of a device capable of providing media for input to the printing process. Entries may exist in the table for each device index with a device type of 'printer'. NOTE: The above description has been modified from RFC 1759 for clarification.")
prtInputIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535)))
if mibBuilder.loadTexts: prtInputIndex.setStatus('current')
if mibBuilder.loadTexts: prtInputIndex.setDescription('A unique value used by the printer to identify this input sub-unit. Although these values may change due to a major reconfiguration of the device (e.g., the addition of new input sub-units to the printer), values SHOULD remain stable across successive printer power cycles. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtInputType = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 2), PrtInputTypeTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInputType.setStatus('current')
if mibBuilder.loadTexts: prtInputType.setDescription('The type of technology (discriminated primarily according to feeder mechanism type) employed by the input sub-unit. Note, the Input Class provides for a descriptor field to further qualify the other choice.')
prtInputDimUnit = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 3), PrtMediaUnitTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInputDimUnit.setStatus('current')
if mibBuilder.loadTexts: prtInputDimUnit.setDescription('The unit of measurement for use calculating and relaying dimensional values for this input sub-unit.')
prtInputMediaDimFeedDirDeclared = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInputMediaDimFeedDirDeclared.setStatus('current')
if mibBuilder.loadTexts: prtInputMediaDimFeedDirDeclared.setDescription('This object provides the value of the declared dimension, in the feed direction, of the media that is (or, if empty, was or will be) in this input sub-unit. The feed direction is the direction in which the media is fed on this sub-unit. This dimension is measured in input sub-unit dimensional units (controlled by prtInputDimUnit, which uses PrtMediaUnitTC). If this input sub-unit can reliably sense this value, the value is sensed by the printer and may not be changed by management requests. Otherwise, the value may be changed. The value (-1) means other and specifically means that this sub-unit places no restriction on this parameter. The value (-2) indicates unknown.')
prtInputMediaDimXFeedDirDeclared = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInputMediaDimXFeedDirDeclared.setStatus('current')
if mibBuilder.loadTexts: prtInputMediaDimXFeedDirDeclared.setDescription('This object provides the value of the declared dimension, in the cross feed direction, of the media that is (or, if empty, was or will be) in this input sub-unit. The cross feed direction is ninety degrees relative to the feed direction associated with this sub-unit. This dimension is measured in input sub-unit dimensional units (controlled by prtInputDimUnit,which uses PrtMediaUnitTC). If this input sub- unit can reliably sense this value, the value is sensed by the printer and may not be changed by management requests. Otherwise, the value may be changed. The value (-1) means other and specifically means that this sub-unit places no restriction on this parameter. The value (-2) indicates unknown.')
prtInputMediaDimFeedDirChosen = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInputMediaDimFeedDirChosen.setStatus('current')
if mibBuilder.loadTexts: prtInputMediaDimFeedDirChosen.setDescription('The printer will act as if media of the chosen dimension (in the feed direction) is present in this input source. Note that this value will be used even if the input tray is empty. Feed dimension measurements are taken relative to the feed direction associated with that sub-unit and are in input sub-unit dimensional units (controlled by prtInputDimUnit, which uses PrtMediaUnitTC). If the printer supports the declared dimension,the granted dimension is the same as the declared dimension. If not, the granted dimension is set to the closest dimension that the printer supports when the declared dimension is set. The value (-1) means other and specifically indicates that this sub-unit places no restriction on this parameter. The value (-2)indicates unknown.')
prtInputMediaDimXFeedDirChosen = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInputMediaDimXFeedDirChosen.setStatus('current')
if mibBuilder.loadTexts: prtInputMediaDimXFeedDirChosen.setDescription('The printer will act as if media of the chosen dimension (in the cross feed direction) is present in this input source. Note that this value will be used even if the input tray is empty. The cross feed direction is ninety degrees relative to the feed direction associated with this sub-unit. This dimension is measured in input sub-unit dimensional units (controlled by prtInputDimUnit, which uses PrtMediaUnitTC). If the printer supports the declare dimension, the granted dimension is the same as the declared dimension. If not, the granted dimension is set to the closest dimension that the printer supports when the declared dimension is set. The value (-1) means other and specifically indicates that this sub-unit places no restriction on this parameter. The value (-2) indicates unknown.')
prtInputCapacityUnit = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 8), PrtCapacityUnitTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInputCapacityUnit.setStatus('current')
if mibBuilder.loadTexts: prtInputCapacityUnit.setDescription('The unit of measurement for use in calculating and relaying capacity values for this input sub-unit.')
prtInputMaxCapacity = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInputMaxCapacity.setStatus('current')
if mibBuilder.loadTexts: prtInputMaxCapacity.setDescription('The maximum capacity of the input sub-unit in input sub-unit capacity units (PrtCapacityUnitTC). There is no convention associated with the media itself so this value reflects claimed capacity. If this input sub-unit can reliably sense this value, the value is sensed by the printer and may not be changed by management requests; otherwise, the value may be written (by a Remote Control Panel or a Management Application). The value (-1) means other and specifically indicates that the sub-unit places no restrictions on this parameter. The value (-2) means unknown.')
prtInputCurrentLevel = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 10), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-3, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInputCurrentLevel.setStatus('current')
if mibBuilder.loadTexts: prtInputCurrentLevel.setDescription('The current capacity of the input sub-unit in input sub-unit capacity units (PrtCapacityUnitTC). If this input sub-unit can reliably sense this value, the value is sensed by the printer and may not be changed by management requests; otherwise, the value may be written (by a Remote Control Panel or a Management Application). The value (-1) means other and specifically indicates that the sub-unit places no restrictions on this parameter. The value (-2) means unknown. The value (-3) means that the printer knows that at least one unit remains.')
prtInputStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 11), PrtSubUnitStatusTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInputStatus.setStatus('current')
if mibBuilder.loadTexts: prtInputStatus.setDescription('The current status of this input sub-unit.')
prtInputMediaName = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 12), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInputMediaName.setReference("The PWG Standardized Media Names specification [PWGMEDIA] contains the recommended values for this object. See also RFC 3805 Appendix C,'Media Names', which lists the values Of standardized media names defined in ISO/IEC 10175.")
if mibBuilder.loadTexts: prtInputMediaName.setStatus('current')
if mibBuilder.loadTexts: prtInputMediaName.setDescription('A description of the media contained in this input sub-unit; This description is to be used by a client to format and Localize a string for display to a human operator. This description is not processed by the printer. It is used to provide information not expressible in terms of the other media attributes (e.g., prtInputMediaDimFeedDirChosen, prtInputMediaDimXFeedDirChosen, prtInputMediaWeight, prtInputMediaType).')
prtInputName = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 13), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInputName.setStatus('current')
if mibBuilder.loadTexts: prtInputName.setDescription('The name assigned to this input sub-unit.')
prtInputVendorName = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 14), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInputVendorName.setStatus('current')
if mibBuilder.loadTexts: prtInputVendorName.setDescription('The vendor name of this input sub-unit.')
prtInputModel = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 15), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInputModel.setStatus('current')
if mibBuilder.loadTexts: prtInputModel.setDescription('The model name of this input sub-unit.')
prtInputVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 16), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInputVersion.setStatus('current')
if mibBuilder.loadTexts: prtInputVersion.setDescription('The version of this input sub-unit.')
prtInputSerialNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 17), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 32))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInputSerialNumber.setStatus('current')
if mibBuilder.loadTexts: prtInputSerialNumber.setDescription('The serial number assigned to this input sub-unit.')
prtInputDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 18), PrtLocalizedDescriptionStringTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInputDescription.setStatus('current')
if mibBuilder.loadTexts: prtInputDescription.setDescription('A free-form text description of this input sub-unit in the localization specified by prtGeneralCurrentLocalization.')
prtInputSecurity = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 19), PresentOnOff()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInputSecurity.setStatus('current')
if mibBuilder.loadTexts: prtInputSecurity.setDescription('Indicates if this input sub-unit has some security associated with it.')
prtInputMediaWeight = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 20), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInputMediaWeight.setStatus('current')
if mibBuilder.loadTexts: prtInputMediaWeight.setDescription('The weight of the medium associated with this input sub-unit in grams / per meter squared. The value (-2) means unknown.')
prtInputMediaType = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 21), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInputMediaType.setReference('The PWG Standardized Media Names specification [PWGMEDIA], section 3 Media Type Names, contains the recommended values for this object. Implementers may add additional string values. The naming conventions in ISO 9070 are recommended in order to avoid potential name clashes.')
if mibBuilder.loadTexts: prtInputMediaType.setStatus('current')
if mibBuilder.loadTexts: prtInputMediaType.setDescription('The name of the type of medium associated with this input sub unit. This name need not be processed by the printer; it might simply be displayed to an operator. NOTE: The above description has been modified from RFC 1759.')
prtInputMediaColor = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 22), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInputMediaColor.setReference('The PWG Standardized Media Names specification [PWGMEDIA], section 4 Media Color Names, contains the recommended values for this object. Implementers may add additional string values. The naming conventions in ISO 9070 are recommended in order to avoid potential name clashes.')
if mibBuilder.loadTexts: prtInputMediaColor.setStatus('current')
if mibBuilder.loadTexts: prtInputMediaColor.setDescription('The name of the color of the medium associated with this input sub-unit using standardized string values. NOTE: The above description has been modified from RFC 1759.')
prtInputMediaFormParts = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 23), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInputMediaFormParts.setStatus('current')
if mibBuilder.loadTexts: prtInputMediaFormParts.setDescription('The number of parts associated with the medium associated with this input sub-unit if the medium is a multi-part form. The value (-1) means other and specifically indicates that the device places no restrictions on this parameter. The value (-2) means unknown.')
prtInputMediaLoadTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 24), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInputMediaLoadTimeout.setStatus('current')
if mibBuilder.loadTexts: prtInputMediaLoadTimeout.setDescription("When the printer is not able to print due to a subunit being empty or the requested media must be manually loaded, the printer will wait for the duration (in seconds) specified by this object. Upon expiration of the time-out, the printer will take the action specified by prtInputNextIndex. The event which causes the printer to enter the waiting state is product specific. If the printer is not waiting for manually fed media, it may switch from an empty subunit to a different subunit without waiting for the time-out to expire. A value of (-1) implies 'other' or 'infinite' which translates to 'wait forever'. The action which causes printing to continue is product specific. A value of (-2) implies 'unknown'.")
prtInputNextIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 25), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-3, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInputNextIndex.setStatus('current')
if mibBuilder.loadTexts: prtInputNextIndex.setDescription("The value of prtInputIndex corresponding to the input subunit which will be used when this input subunit is emptied and the time-out specified by prtInputMediaLoadTimeout expires. A value of zero(0) indicates that auto input switching will not occur when this input subunit is emptied. If the time-out specified by prtInputLoadMediaTimeout expires and this value is zero(0), the job will be aborted. A value of (-1) means other. The value (-2)means 'unknown' and specifically indicates that an implementation specific method will determine the next input subunit to use at the time this subunit is emptied and the time out expires. The value(-3) means input switching is not supported for this subunit.")
prtOutput = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 9))
prtOutputTable = MibTable((1, 3, 6, 1, 2, 1, 43, 9, 2), )
if mibBuilder.loadTexts: prtOutputTable.setStatus('current')
if mibBuilder.loadTexts: prtOutputTable.setDescription('A table of the devices capable of receiving media delivered from the printing process.')
prtOutputEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 9, 2, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Printer-MIB", "prtOutputIndex"))
if mibBuilder.loadTexts: prtOutputEntry.setStatus('current')
if mibBuilder.loadTexts: prtOutputEntry.setDescription("Attributes of a device capable of receiving media delivered from the printing process. Entries may exist in the table for each device index with a device type of 'printer'. NOTE: The above description has been modified from RFC 1759 for clarification.")
prtOutputIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535)))
if mibBuilder.loadTexts: prtOutputIndex.setStatus('current')
if mibBuilder.loadTexts: prtOutputIndex.setDescription('A unique value used by this printer to identify this output sub-unit. Although these values may change due to a major reconfiguration of the sub-unit (e.g., the addition of new output devices to the printer), values SHOULD remain stable across successive printer power cycles. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtOutputType = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 2), PrtOutputTypeTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtOutputType.setStatus('current')
if mibBuilder.loadTexts: prtOutputType.setDescription('The type of technology supported by this output sub-unit.')
prtOutputCapacityUnit = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 3), PrtCapacityUnitTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtOutputCapacityUnit.setStatus('current')
if mibBuilder.loadTexts: prtOutputCapacityUnit.setDescription('The unit of measurement for use in calculating and relaying capacity values for this output sub-unit.')
prtOutputMaxCapacity = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputMaxCapacity.setStatus('current')
if mibBuilder.loadTexts: prtOutputMaxCapacity.setDescription('The maximum capacity of this output sub-unit in output sub- unit capacity units (PrtCapacityUnitTC). There is no convention associated with the media itself so this value essentially reflects claimed capacity. If this output sub-unit can reliably sense this value, the value is sensed by the printer and may not be changed by management requests; otherwise, the value may be written (by a Remote Control Panel or a Management Application). The value (-1) means other and specifically indicates that the sub-unit places no restrictions on this parameter. The value (-2) means unknown.')
prtOutputRemainingCapacity = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-3, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputRemainingCapacity.setStatus('current')
if mibBuilder.loadTexts: prtOutputRemainingCapacity.setDescription('The remaining capacity of the possible output sub-unit capacity in output sub-unit capacity units (PrtCapacityUnitTC)of this output sub-unit. If this output sub- unit can reliably sense this value, the value is sensed by the printer and may not be modified by management requests; otherwise, the value may be written (by a Remote Control Panel or a Management Application). The value (-1) means other and specifically indicates that the sub-unit places no restrictions on this parameter. The value (-2) means unknown. The value (-3) means that the printer knows that there remains capacity for at least one unit.')
prtOutputStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 6), PrtSubUnitStatusTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtOutputStatus.setStatus('current')
if mibBuilder.loadTexts: prtOutputStatus.setDescription('The current status of this output sub-unit.')
prtOutputName = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 7), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputName.setStatus('current')
if mibBuilder.loadTexts: prtOutputName.setDescription('The name assigned to this output sub-unit.')
prtOutputVendorName = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 8), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtOutputVendorName.setStatus('current')
if mibBuilder.loadTexts: prtOutputVendorName.setDescription('The vendor name of this output sub-unit.')
prtOutputModel = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 9), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtOutputModel.setStatus('current')
if mibBuilder.loadTexts: prtOutputModel.setDescription('The model name assigned to this output sub-unit. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtOutputVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 10), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtOutputVersion.setStatus('current')
if mibBuilder.loadTexts: prtOutputVersion.setDescription('The version of this output sub-unit.')
prtOutputSerialNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 11), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtOutputSerialNumber.setStatus('current')
if mibBuilder.loadTexts: prtOutputSerialNumber.setDescription('The serial number assigned to this output sub-unit.')
prtOutputDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 12), PrtLocalizedDescriptionStringTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtOutputDescription.setStatus('current')
if mibBuilder.loadTexts: prtOutputDescription.setDescription('A free-form text description of this output sub-unit in the localization specified by prtGeneralCurrentLocalization.')
prtOutputSecurity = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 13), PresentOnOff()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputSecurity.setStatus('current')
if mibBuilder.loadTexts: prtOutputSecurity.setDescription('Indicates if this output sub-unit has some security associated with it and if that security is enabled or not.')
prtOutputDimUnit = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 14), PrtMediaUnitTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtOutputDimUnit.setStatus('current')
if mibBuilder.loadTexts: prtOutputDimUnit.setDescription('The unit of measurement for use in calculating and relaying dimensional values for this output sub-unit.')
prtOutputMaxDimFeedDir = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 15), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputMaxDimFeedDir.setStatus('current')
if mibBuilder.loadTexts: prtOutputMaxDimFeedDir.setDescription('The maximum dimensions supported by this output sub-unit for measurements taken parallel relative to the feed direction associated with that sub-unit in output sub-unit dimensional units (controlled by prtOutputDimUnit, which uses PrtMediaUnitTC). If this output sub-unit can reliably sense this value, the value is sensed by the printer and may not be changed with management protocol operations. The value (-1) means other and specifically indicates that the sub-unit places no restrictions on this parameter. The value (-2) means unknown. NOTE: The above description has been modified from RFC 1759 for clarification and to explain the purpose of (-1) and (-2).')
prtOutputMaxDimXFeedDir = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 16), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputMaxDimXFeedDir.setStatus('current')
if mibBuilder.loadTexts: prtOutputMaxDimXFeedDir.setDescription('The maximum dimensions supported by this output sub-unit for measurements taken ninety degrees relative to the feed direction associated with that sub-unit in output sub-unit dimensional units (controlled by prtOutputDimUnit, which uses PrtMediaUnitTC). If this output sub-unit can reliably sense this value, the value is sensed by the printer and may not be changed with management protocol operations. The value (-1) means other and specifically indicates that the sub-unit places no restrictions on this parameter. The value (-2) means unknown. NOTE: The above description has been modified from RFC 1759 for clarification and to explain the purpose of (-1) and (-2).')
prtOutputMinDimFeedDir = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 17), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputMinDimFeedDir.setStatus('current')
if mibBuilder.loadTexts: prtOutputMinDimFeedDir.setDescription('The minimum dimensions supported by this output sub-unit for measurements taken parallel relative to the feed direction associated with that sub-unit in output sub-unit dimensional units (controlled by prtOutputDimUnit, which uses PrtMediaUnitTC). If this output sub-unit can reliably sense this value, the value is sensed by the printer and may not be changed with management protocol operations. The value (-1) means other and specifically indicates that the sub-unit places no restrictions on this parameter. The value (-2) means unknown. NOTE: The above description has been modified from RFC 1759 for clarification and to explain the purpose of (-1) and (-2).')
prtOutputMinDimXFeedDir = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 18), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputMinDimXFeedDir.setStatus('current')
if mibBuilder.loadTexts: prtOutputMinDimXFeedDir.setDescription('The minimum dimensions supported by this output sub-unit for measurements taken ninety degrees relative to the feed direction associated with that sub-unit in output sub-unit dimensional units (controlled by prtOutputDimUnit, which uses PrtMediaUnitTC). If this output sub-unit can reliably sense this value, the value is sensed by the printer and may not be changed with management protocol operations. The value (-1) means other and specifically indicates that the sub-unit places no restrictions on this parameter. The value (-2) means unknown. NOTE: The above description has been modified from RFC 1759 for clarification and to explain the purpose of (-1) and (-2).')
prtOutputStackingOrder = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 19), PrtOutputStackingOrderTC()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputStackingOrder.setStatus('current')
if mibBuilder.loadTexts: prtOutputStackingOrder.setDescription("The current state of the stacking order for the associated output sub-unit. 'FirstToLast' means that as pages are output the front of the next page is placed against the back of the previous page. 'LasttoFirst' means that as pages are output the back of the next page is placed against the front of the previous page.")
prtOutputPageDeliveryOrientation = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 20), PrtOutputPageDeliveryOrientationTC()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputPageDeliveryOrientation.setStatus('current')
if mibBuilder.loadTexts: prtOutputPageDeliveryOrientation.setDescription("The reading surface that will be 'up' when pages are delivered to the associated output sub-unit. Values are faceUp and faceDown. (Note: interpretation of these values is in general context-dependent based on locale; presentation of these values to an end-user should be normalized to the expectations of the user).")
prtOutputBursting = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 21), PresentOnOff()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputBursting.setStatus('current')
if mibBuilder.loadTexts: prtOutputBursting.setDescription('This object indicates that the outputting sub-unit supports bursting, and if so, whether the feature is enabled. Bursting is the process by which continuous media is separated into individual sheets, typically by bursting along pre-formed perforations.')
prtOutputDecollating = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 22), PresentOnOff()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputDecollating.setStatus('current')
if mibBuilder.loadTexts: prtOutputDecollating.setDescription('This object indicates that the output supports decollating, and if so, whether the feature is enabled. Decollating is the process by which the individual parts within a multi-part form are separated and sorted into separate stacks for each part.')
prtOutputPageCollated = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 23), PresentOnOff()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputPageCollated.setStatus('current')
if mibBuilder.loadTexts: prtOutputPageCollated.setDescription('This object indicates that the output sub-unit supports page collation, and if so, whether the feature is enabled. See RFC 3805 Appendix A, Glossary Of Terms, for definition of how this document defines collation. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtOutputOffsetStacking = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 24), PresentOnOff()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputOffsetStacking.setStatus('current')
if mibBuilder.loadTexts: prtOutputOffsetStacking.setDescription('This object indicates that the output supports offset stacking,and if so, whether the feature is enabled. See RFC 3805 Appendix A, Glossary Of Terms, for how Offset Stacking is defined by this document. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtMarker = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 10))
prtMarkerTable = MibTable((1, 3, 6, 1, 2, 1, 43, 10, 2), )
if mibBuilder.loadTexts: prtMarkerTable.setStatus('current')
if mibBuilder.loadTexts: prtMarkerTable.setDescription('The marker table provides a description of each marker sub-unit contained within the printer. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtMarkerEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 10, 2, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Printer-MIB", "prtMarkerIndex"))
if mibBuilder.loadTexts: prtMarkerEntry.setStatus('current')
if mibBuilder.loadTexts: prtMarkerEntry.setDescription('Entries in this table define the characteristics and status of each marker sub-unit in the printer. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtMarkerIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535)))
if mibBuilder.loadTexts: prtMarkerIndex.setStatus('current')
if mibBuilder.loadTexts: prtMarkerIndex.setDescription('A unique value used by the printer to identify this marking SubUnit. Although these values may change due to a major reconfiguration of the device (e.g., the addition of new marking sub-units to the printer), values SHOULD remain stable across successive printer power cycles. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtMarkerMarkTech = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 2), PrtMarkerMarkTechTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerMarkTech.setStatus('current')
if mibBuilder.loadTexts: prtMarkerMarkTech.setDescription('The type of marking technology used for this marking sub-unit.')
prtMarkerCounterUnit = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 3), PrtMarkerCounterUnitTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerCounterUnit.setStatus('current')
if mibBuilder.loadTexts: prtMarkerCounterUnit.setDescription('The unit that will be used by the printer when reporting counter values for this marking sub-unit. The time units of measure are provided for a device like a strip recorder that does not or cannot track the physical dimensions of the media and does not use characters, lines or sheets.')
prtMarkerLifeCount = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerLifeCount.setStatus('current')
if mibBuilder.loadTexts: prtMarkerLifeCount.setDescription('The count of the number of units of measure counted during the life of printer using units of measure as specified by prtMarkerCounterUnit. Note: This object should be implemented as a persistent object with a reliable value throughout the lifetime of the printer.')
prtMarkerPowerOnCount = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerPowerOnCount.setStatus('current')
if mibBuilder.loadTexts: prtMarkerPowerOnCount.setDescription('The count of the number of units of measure counted since the equipment was most recently powered on using units of measure as specified by prtMarkerCounterUnit.')
prtMarkerProcessColorants = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerProcessColorants.setStatus('current')
if mibBuilder.loadTexts: prtMarkerProcessColorants.setDescription('The number of process colors supported by this marker. A process color of 1 implies monochrome. The value of this object and prtMarkerSpotColorants cannot both be 0. The value of prtMarkerProcessColorants must be 0 or greater. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtMarkerSpotColorants = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerSpotColorants.setStatus('current')
if mibBuilder.loadTexts: prtMarkerSpotColorants.setDescription('The number of spot colors supported by this marker. The value of this object and prtMarkerProcessColorants cannot both be 0. Must be 0 or greater. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtMarkerAddressabilityUnit = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 8), PrtMarkerAddressabilityUnitTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerAddressabilityUnit.setStatus('current')
if mibBuilder.loadTexts: prtMarkerAddressabilityUnit.setDescription("The unit of measure of distances, as applied to the marker's resolution. NOTE: The above description has been modified from RFC 1759 for clarification.")
prtMarkerAddressabilityFeedDir = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerAddressabilityFeedDir.setStatus('current')
if mibBuilder.loadTexts: prtMarkerAddressabilityFeedDir.setDescription("The maximum number of addressable marking positions in the feed direction per 10000 units of measure specified by prtMarkerAddressabilityUnit. A value of (-1) implies 'other' or 'infinite' while a value of (-2) implies 'unknown'. NOTE: The above description has been modified from RFC 1759 for clarification.")
prtMarkerAddressabilityXFeedDir = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 10), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerAddressabilityXFeedDir.setStatus('current')
if mibBuilder.loadTexts: prtMarkerAddressabilityXFeedDir.setDescription("The maximum number of addressable marking positions in the cross feed direction in 10000 units of measure specified by prtMarkerAddressabilityUnit. A value of (-1) implies 'other' or 'infinite' while a value of (-2) implies 'unknown'. NOTE: The above description has been modified from RFC 1759 for clarification.")
prtMarkerNorthMargin = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 11), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerNorthMargin.setStatus('current')
if mibBuilder.loadTexts: prtMarkerNorthMargin.setDescription('The margin, in units identified by prtMarkerAddressabilityUnit, from the leading edge of the medium as the medium flows through the marking engine with the side to be imaged facing the observer. The leading edge is the North edge and the other edges are defined by the normal compass layout of directions with the compass facing the observer. Printing within the area bounded by all four margins is guaranteed for all interpreters. The value (-2) means unknown.')
prtMarkerSouthMargin = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 12), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerSouthMargin.setStatus('current')
if mibBuilder.loadTexts: prtMarkerSouthMargin.setDescription('The margin from the South edge (see prtMarkerNorthMargin) of the medium in units identified by prtMarkerAddressabilityUnit. Printing within the area bounded by all four margins is guaranteed for all interpreters. The value (-2) means unknown.')
prtMarkerWestMargin = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 13), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerWestMargin.setStatus('current')
if mibBuilder.loadTexts: prtMarkerWestMargin.setDescription('The margin from the West edge (see prtMarkerNorthMargin) of the medium in units identified by prtMarkerAddressabilityUnit. Printing within the area bounded by all four margins is guaranteed for all interpreters. The value (-2) means unknown.')
prtMarkerEastMargin = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 14), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerEastMargin.setStatus('current')
if mibBuilder.loadTexts: prtMarkerEastMargin.setDescription('The margin from the East edge (see prtMarkerNorthMargin) of the medium in units identified by prtMarkerAddressabilityUnit. Printing within the area bounded by all four margins is guaranteed for all interpreters. The value (-2) means unknown.')
prtMarkerStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 15), PrtSubUnitStatusTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerStatus.setStatus('current')
if mibBuilder.loadTexts: prtMarkerStatus.setDescription('The current status of this marker sub-unit.')
prtMarkerSupplies = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 11))
prtMarkerSuppliesTable = MibTable((1, 3, 6, 1, 2, 1, 43, 11, 1), )
if mibBuilder.loadTexts: prtMarkerSuppliesTable.setStatus('current')
if mibBuilder.loadTexts: prtMarkerSuppliesTable.setDescription('A table of the marker supplies available on this printer.')
prtMarkerSuppliesEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 11, 1, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Printer-MIB", "prtMarkerSuppliesIndex"))
if mibBuilder.loadTexts: prtMarkerSuppliesEntry.setStatus('current')
if mibBuilder.loadTexts: prtMarkerSuppliesEntry.setDescription("Attributes of a marker supply. Entries may exist in the table for each device index with a device type of 'printer'. NOTE: The above description has been modified from RFC 1759 for clarification.")
prtMarkerSuppliesIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 11, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535)))
if mibBuilder.loadTexts: prtMarkerSuppliesIndex.setStatus('current')
if mibBuilder.loadTexts: prtMarkerSuppliesIndex.setDescription('A unique value used by the printer to identify this marker supply. Although these values may change due to a major reconfiguration of the device (e.g., the addition of new marker supplies to the printer), values SHOULD remain stable across successive printer power cycles. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtMarkerSuppliesMarkerIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 11, 1, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerSuppliesMarkerIndex.setStatus('current')
if mibBuilder.loadTexts: prtMarkerSuppliesMarkerIndex.setDescription('The value of prtMarkerIndex corresponding to the marking sub unit with which this marker supply sub-unit is associated.')
prtMarkerSuppliesColorantIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 11, 1, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerSuppliesColorantIndex.setStatus('current')
if mibBuilder.loadTexts: prtMarkerSuppliesColorantIndex.setDescription('The value of prtMarkerColorantIndex corresponding to the colorant with which this marker supply sub-unit is associated. This value shall be 0 if there is no colorant table or if this supply does not depend on a single specified colorant. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtMarkerSuppliesClass = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 11, 1, 1, 4), PrtMarkerSuppliesClassTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerSuppliesClass.setStatus('current')
if mibBuilder.loadTexts: prtMarkerSuppliesClass.setDescription('Indicates whether this supply entity represents a supply that is consumed or a receptacle that is filled. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtMarkerSuppliesType = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 11, 1, 1, 5), PrtMarkerSuppliesTypeTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerSuppliesType.setStatus('current')
if mibBuilder.loadTexts: prtMarkerSuppliesType.setDescription('The type of this supply.')
prtMarkerSuppliesDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 11, 1, 1, 6), PrtLocalizedDescriptionStringTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerSuppliesDescription.setStatus('current')
if mibBuilder.loadTexts: prtMarkerSuppliesDescription.setDescription('The description of this supply container/receptacle in the localization specified by prtGeneralCurrentLocalization.')
prtMarkerSuppliesSupplyUnit = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 11, 1, 1, 7), PrtMarkerSuppliesSupplyUnitTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerSuppliesSupplyUnit.setStatus('current')
if mibBuilder.loadTexts: prtMarkerSuppliesSupplyUnit.setDescription('Unit of measure of this marker supply container/receptacle. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtMarkerSuppliesMaxCapacity = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 11, 1, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtMarkerSuppliesMaxCapacity.setStatus('current')
if mibBuilder.loadTexts: prtMarkerSuppliesMaxCapacity.setDescription('The maximum capacity of this supply container/receptacle expressed in prtMarkerSuppliesSupplyUnit. If this supply container/receptacle can reliably sense this value, the value is reported by the printer and is read-only; otherwise, the value may be written (by a Remote Control Panel or a Management Application). The value (-1) means other and specifically indicates that the sub-unit places no restrictions on this parameter. The value (-2) means unknown.')
prtMarkerSuppliesLevel = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 11, 1, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-3, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtMarkerSuppliesLevel.setStatus('current')
if mibBuilder.loadTexts: prtMarkerSuppliesLevel.setDescription('The current level if this supply is a container; the remaining space if this supply is a receptacle. If this supply container/receptacle can reliably sense this value, the value is reported by the printer and is read-only; otherwise, the value may be written (by a Remote Control Panel or a Management Application). The value (-1) means other and specifically indicates that the sub-unit places no restrictions on this parameter. The value (-2) means unknown. A value of (-3) means that the printer knows that there is some supply/remaining space, respectively.')
prtMarkerColorant = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 12))
prtMarkerColorantTable = MibTable((1, 3, 6, 1, 2, 1, 43, 12, 1), )
if mibBuilder.loadTexts: prtMarkerColorantTable.setStatus('current')
if mibBuilder.loadTexts: prtMarkerColorantTable.setDescription('A table of all of the colorants available on the printer.')
prtMarkerColorantEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 12, 1, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Printer-MIB", "prtMarkerColorantIndex"))
if mibBuilder.loadTexts: prtMarkerColorantEntry.setStatus('current')
if mibBuilder.loadTexts: prtMarkerColorantEntry.setDescription("Attributes of a colorant available on the printer. Entries may exist in the table for each device index with a device type of 'printer'. NOTE: The above description has been modified from RFC 1759 for clarification.")
prtMarkerColorantIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 12, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535)))
if mibBuilder.loadTexts: prtMarkerColorantIndex.setStatus('current')
if mibBuilder.loadTexts: prtMarkerColorantIndex.setDescription('A unique value used by the printer to identify this colorant. Although these values may change due to a major reconfiguration of the device (e.g., the addition of new colorants to the printer) , values SHOULD remain stable across successive printer power cycles. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtMarkerColorantMarkerIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 12, 1, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerColorantMarkerIndex.setStatus('current')
if mibBuilder.loadTexts: prtMarkerColorantMarkerIndex.setDescription('The value of prtMarkerIndex corresponding to the marker sub unit with which this colorant entry is associated.')
prtMarkerColorantRole = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 12, 1, 1, 3), PrtMarkerColorantRoleTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerColorantRole.setStatus('current')
if mibBuilder.loadTexts: prtMarkerColorantRole.setDescription('The role played by this colorant.')
prtMarkerColorantValue = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 12, 1, 1, 4), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerColorantValue.setStatus('current')
if mibBuilder.loadTexts: prtMarkerColorantValue.setDescription('The name of the color of this colorant using standardized string names from ISO 10175 (DPA) and ISO 10180 (SPDL) such as: other unknown white red green blue cyan magenta yellow black Implementers may add additional string values. The naming conventions in ISO 9070 are recommended in order to avoid potential name clashes')
prtMarkerColorantTonality = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 12, 1, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerColorantTonality.setStatus('current')
if mibBuilder.loadTexts: prtMarkerColorantTonality.setDescription('The distinct levels of tonality realizable by a marking sub unit when using this colorant. This value does not include the number of levels of tonal difference that an interpreter can obtain by techniques such as half toning. This value must be at least 2.')
prtMediaPath = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 13))
prtMediaPathTable = MibTable((1, 3, 6, 1, 2, 1, 43, 13, 4), )
if mibBuilder.loadTexts: prtMediaPathTable.setStatus('current')
if mibBuilder.loadTexts: prtMediaPathTable.setDescription('The media path table includes both physical and logical paths within the printer. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtMediaPathEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 13, 4, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Printer-MIB", "prtMediaPathIndex"))
if mibBuilder.loadTexts: prtMediaPathEntry.setStatus('current')
if mibBuilder.loadTexts: prtMediaPathEntry.setDescription("Entries may exist in the table for each device index with a device type of 'printer' Each entry defines the physical characteristics of and the status of the media path. The data provided indicates the maximum throughput and the media size limitations of these subunits. NOTE: The above description has been modified from RFC 1759 for clarification.")
prtMediaPathIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 13, 4, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535)))
if mibBuilder.loadTexts: prtMediaPathIndex.setStatus('current')
if mibBuilder.loadTexts: prtMediaPathIndex.setDescription('A unique value used by the printer to identify this media path. Although these values may change due to a major reconfiguration of the device (e.g., the addition of new media paths to the printer), values SHOULD remain stable across successive printer power cycles. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtMediaPathMaxSpeedPrintUnit = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 13, 4, 1, 2), PrtMediaPathMaxSpeedPrintUnitTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMediaPathMaxSpeedPrintUnit.setStatus('current')
if mibBuilder.loadTexts: prtMediaPathMaxSpeedPrintUnit.setDescription('The unit of measure used in specifying the speed of all media paths in the printer.')
prtMediaPathMediaSizeUnit = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 13, 4, 1, 3), PrtMediaUnitTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMediaPathMediaSizeUnit.setStatus('current')
if mibBuilder.loadTexts: prtMediaPathMediaSizeUnit.setDescription('The units of measure of media size for use in calculating and relaying dimensional values for all media paths in the printer.')
prtMediaPathMaxSpeed = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 13, 4, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMediaPathMaxSpeed.setStatus('current')
if mibBuilder.loadTexts: prtMediaPathMaxSpeed.setDescription("The maximum printing speed of this media path expressed in prtMediaPathMaxSpeedUnit's. A value of (-1) implies 'other'.")
prtMediaPathMaxMediaFeedDir = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 13, 4, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMediaPathMaxMediaFeedDir.setStatus('current')
if mibBuilder.loadTexts: prtMediaPathMaxMediaFeedDir.setDescription("The maximum physical media size in the feed direction of this media path expressed in units of measure specified by PrtMediaPathMediaSizeUnit. A value of (-1) implies 'unlimited' a value of (-2) implies 'unknown'. NOTE: The above description has been modified from RFC 1759 for clarification.")
prtMediaPathMaxMediaXFeedDir = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 13, 4, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMediaPathMaxMediaXFeedDir.setStatus('current')
if mibBuilder.loadTexts: prtMediaPathMaxMediaXFeedDir.setDescription("The maximum physical media size across the feed direction of this media path expressed in units of measure specified by prtMediaPathMediaSizeUnit. A value of (-2) implies 'unknown'. NOTE: The above description has been modified from RFC 1759 for clarification.")
prtMediaPathMinMediaFeedDir = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 13, 4, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMediaPathMinMediaFeedDir.setStatus('current')
if mibBuilder.loadTexts: prtMediaPathMinMediaFeedDir.setDescription("The minimum physical media size in the feed direction of this media path expressed in units of measure specified by prtMediaPathMediaSizeUnit. A value of (-2) implies 'unknown'. NOTE: The above description has been modified from RFC 1759 for clarification.")
prtMediaPathMinMediaXFeedDir = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 13, 4, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMediaPathMinMediaXFeedDir.setStatus('current')
if mibBuilder.loadTexts: prtMediaPathMinMediaXFeedDir.setDescription("The minimum physical media size across the feed direction of this media path expressed in units of measure specified by prtMediaPathMediaSizeUnit. A value of (-2) implies 'unknown'. NOTE: The above description has been modified from RFC 1759 for clarification.")
prtMediaPathType = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 13, 4, 1, 9), PrtMediaPathTypeTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMediaPathType.setStatus('current')
if mibBuilder.loadTexts: prtMediaPathType.setDescription('The type of the media path for this media path.')
prtMediaPathDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 13, 4, 1, 10), PrtLocalizedDescriptionStringTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMediaPathDescription.setStatus('current')
if mibBuilder.loadTexts: prtMediaPathDescription.setDescription('The manufacturer-provided description of this media path in the localization specified by prtGeneralCurrentLocalization.')
prtMediaPathStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 13, 4, 1, 11), PrtSubUnitStatusTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMediaPathStatus.setStatus('current')
if mibBuilder.loadTexts: prtMediaPathStatus.setDescription('The current status of this media path.')
prtChannel = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 14))
prtChannelTable = MibTable((1, 3, 6, 1, 2, 1, 43, 14, 1), )
if mibBuilder.loadTexts: prtChannelTable.setStatus('current')
if mibBuilder.loadTexts: prtChannelTable.setDescription('The channel table represents the set of input data sources which can provide print data to one or more of the interpreters available on a printer. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtChannelEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 14, 1, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Printer-MIB", "prtChannelIndex"))
if mibBuilder.loadTexts: prtChannelEntry.setStatus('current')
if mibBuilder.loadTexts: prtChannelEntry.setDescription("Entries may exist in the table for each device index with a device type of 'printer'. Each channel table entry is characterized by a unique protocol stack and/or addressing. The channel may also have printer dependent features that are associated with a printing language. NOTE: The above description has been modified from RFC 1759 for clarification.")
prtChannelIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 14, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535)))
if mibBuilder.loadTexts: prtChannelIndex.setStatus('current')
if mibBuilder.loadTexts: prtChannelIndex.setDescription('A unique value used by the printer to identify this data channel. Although these values may change due to a major reconfiguration of the device (e.g., the addition of new data channels to the printer), values SHOULD remain stable across successive printer power cycles. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtChannelType = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 14, 1, 1, 2), PrtChannelTypeTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtChannelType.setStatus('current')
if mibBuilder.loadTexts: prtChannelType.setDescription('The type of this print data channel. This object provides the linkage to ChannelType-specific groups that may (conceptually) extend the prtChannelTable with additional details about that channel.')
prtChannelProtocolVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 14, 1, 1, 3), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtChannelProtocolVersion.setStatus('current')
if mibBuilder.loadTexts: prtChannelProtocolVersion.setDescription('The version of the protocol used on this channel. The format used for version numbering depends on prtChannelType.')
prtChannelCurrentJobCntlLangIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 14, 1, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtChannelCurrentJobCntlLangIndex.setStatus('current')
if mibBuilder.loadTexts: prtChannelCurrentJobCntlLangIndex.setDescription('The value of prtInterpreterIndex corresponding to the Control Language Interpreter for this channel. This interpreter defines the syntax used for control functions, such as querying or changing environment variables and identifying job boundaries (e.g., PJL, PostScript, NPAP). A value of zero indicates that there is no current Job Control Language Interpreter for this channel. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtChannelDefaultPageDescLangIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 14, 1, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtChannelDefaultPageDescLangIndex.setStatus('current')
if mibBuilder.loadTexts: prtChannelDefaultPageDescLangIndex.setDescription('The value of prtInterpreterIndex corresponding to the Page Description Language Interpreter for this channel. This interpreter defines the default Page Description Language interpreter to be used for the print data unless the Control Language is used to select a specific interpreter (e.g., PCL, PostScript Language, auto-sense). A value of zero indicates that there is no default page description language interpreter for this channel. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtChannelState = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 14, 1, 1, 6), PrtChannelStateTC()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtChannelState.setStatus('current')
if mibBuilder.loadTexts: prtChannelState.setDescription('The state of this print data channel. The value determines whether control information and print data is allowed through this channel or not.')
prtChannelIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 14, 1, 1, 7), InterfaceIndexOrZero()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtChannelIfIndex.setStatus('current')
if mibBuilder.loadTexts: prtChannelIfIndex.setDescription('The value of ifIndex in the ifTable; see the Interfaces Group MIB [RFC2863] which corresponds to this channel. When more than one row of the ifTable is relevant, this is the index of the row representing the topmost layer in the interface hierarchy. A value of zero indicates that no interface is associated with this channel. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtChannelStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 14, 1, 1, 8), PrtSubUnitStatusTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtChannelStatus.setStatus('current')
if mibBuilder.loadTexts: prtChannelStatus.setDescription('The current status of the channel.')
prtChannelInformation = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 14, 1, 1, 9), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtChannelInformation.setStatus('current')
if mibBuilder.loadTexts: prtChannelInformation.setDescription("Auxiliary information to allow a printing application to use the channel for data submission to the printer. An application capable of using a specific PrtChannelType should be able to use the combined information from the prtChannelInformation and other channel and interface group objects to 'bootstrap' its use of the channel. prtChannelInformation is not intended to provide a general channel description, nor to provide information that is available once the channel is in use. The encoding and interpretation of the prtChannelInformation object is specific to channel type. The description of each PrtChannelType enum value for which prtChannelInformation is defined specifies the appropriate encoding and interpretation, including interaction with other objects. For channel types that do not specify a prtChannelInformation value, its value shall be null (0 length). When a new PrtChannelType enumeration value is registered, its accompanying description must specify the encoding and interpretation of the prtChannelInformation value for the channel type. prtChannelInformation semantics for an existing PrtChannelType may be added or amended in the same manner as described in section 2.4.1 for type 2 enumeration values. The prtChannelInformation specifies values for a collection of channel attributes, represented as text according to the following rules: 1. The prtChannelInformation is not affected by localization. 2. The prtChannelInformation is a list of entries representing the attribute values. Each entry consists of the following items, in order: a. A keyword, composed of alphabetic characters (A-Z, a-z) represented by their NVT ASCII [RFC854] codes, that identifies a channel attribute, b. The NVT ASCII code for an Equals Sign (=) (code 61) to delimit the keyword, c. A data value encoded using rules specific to the PrtChannelType to with the prtChannelInformation applies which must in no case allow an octet with value 10 (the NVT ASCII Line Feed code), d. the NVT ASCII code for a Line Feed character (code 10) to delimit the data value. No other octets shall be present. Keywords are case-sensitive. Conventionally, keywords are capitalized (including each word of a multi-word keyword) and since they occupy space in the prtChannelInformation, they are kept short. 3. If a channel attribute has multiple values, it is represented by multiple entries with the same keyword, each specifying one value. Otherwise, there shall be at most one entry for each attribute. 4. By default, entries may appear in any order. If there are ordering constraints for particular entries, these must be specified in their definitions. 5. The prtChannelInformation value by default consists of text represented by NVT ASCII graphics character codes. However, other representations may be specified: a. In cases where the prtChannelInformation value contains information not normally coded in textual form, whatever symbolic representation is conventionally used for the information should be used for encoding the prtChannelInformation value. (For instance, a binary port value might be represented as a decimal number using NVT ASCII codes.) Such encoding must be specified in the definition of the value. b. The value may contain textual information in a character set other than NVT ASCII graphics characters. (For instance, an identifier might consist of ISO 10646 text encoded using the UTF-8 encoding scheme.) Such a character set and its encoding must be specified in the definition of the value. 6. For each PrtChannelType for which prtChannelInformation entries are defined, the descriptive text associated with the PrtChannelType enumeration value shall specify the following information for each entry: Title: Brief description phrase, e.g.: 'Port name', 'Service Name', etc. Keyword: The keyword value, e.g.: 'Port' or 'Service' Syntax: The encoding of the entry value if it cannot be directly represented by NVT ASCII. Status: 'Mandatory', 'Optional', or 'Conditionally Mandatory' Multiplicity: 'Single' or 'Multiple' to indicate whether the entry may be present multiple times. Description: Description of the use of the entry, other information required to complete the definition (e.g.: ordering constraints, interactions between entries). Applications that interpret prtChannelInformation should ignore unrecognized entries, so they are not affected if new entry types are added.")
prtInterpreter = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 15))
prtInterpreterTable = MibTable((1, 3, 6, 1, 2, 1, 43, 15, 1), )
if mibBuilder.loadTexts: prtInterpreterTable.setStatus('current')
if mibBuilder.loadTexts: prtInterpreterTable.setDescription('The interpreter table is a table representing the interpreters in the printer. An entry shall be placed in the interpreter table for each interpreter on the printer. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtInterpreterEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 15, 1, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Printer-MIB", "prtInterpreterIndex"))
if mibBuilder.loadTexts: prtInterpreterEntry.setStatus('current')
if mibBuilder.loadTexts: prtInterpreterEntry.setDescription("Entries may exist in the table for each device index with a device type of 'printer'. Each table entry provides a complete description of the interpreter, including version information, rendering resolutions, default character sets, output orientation, and communication capabilities. NOTE: The above description has been modified from RFC 1759 for clarification.")
prtInterpreterIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 15, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535)))
if mibBuilder.loadTexts: prtInterpreterIndex.setStatus('current')
if mibBuilder.loadTexts: prtInterpreterIndex.setDescription('A unique value for each PDL or control language for which there exists an interpreter or emulator in the printer. The value is used to identify this interpreter. Although these values may change due to a major reconfiguration of the device (e.g., the addition of new interpreters to the printer), values SHOULD remain stable across successive printer power cycles. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtInterpreterLangFamily = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 15, 1, 1, 2), PrtInterpreterLangFamilyTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInterpreterLangFamily.setStatus('current')
if mibBuilder.loadTexts: prtInterpreterLangFamily.setDescription('The family name of a Page Description Language (PDL) or control language which this interpreter in the printer can interpret or emulate. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtInterpreterLangLevel = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 15, 1, 1, 3), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 31))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInterpreterLangLevel.setStatus('current')
if mibBuilder.loadTexts: prtInterpreterLangLevel.setDescription("The level of the language which this interpreter is interpreting or emulating. This might contain a value like '5e'for an interpreter which is emulating level 5e of the PCL language. It might contain '2' for an interpreter which is emulating level 2 of the PostScript language. Similarly it might contain '2' for an interpreter which is emulating level 2 of the HPGL language.")
prtInterpreterLangVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 15, 1, 1, 4), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 31))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInterpreterLangVersion.setStatus('current')
if mibBuilder.loadTexts: prtInterpreterLangVersion.setDescription('The date code or version of the language which this interpreter is interpreting or emulating.')
prtInterpreterDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 15, 1, 1, 5), PrtLocalizedDescriptionStringTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInterpreterDescription.setStatus('current')
if mibBuilder.loadTexts: prtInterpreterDescription.setDescription('A string to identify this interpreter in the localization specified by prtGeneralCurrentLocalization as opposed to the language which is being interpreted. It is anticipated that this string will allow manufacturers to unambiguously identify their interpreters.')
prtInterpreterVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 15, 1, 1, 6), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 31))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInterpreterVersion.setStatus('current')
if mibBuilder.loadTexts: prtInterpreterVersion.setDescription('The date code, version number, or other product specific information tied to this interpreter. This value is associated with the interpreter, rather than with the version of the language which is being interpreted or emulated.')
prtInterpreterDefaultOrientation = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 15, 1, 1, 7), PrtPrintOrientationTC()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInterpreterDefaultOrientation.setStatus('current')
if mibBuilder.loadTexts: prtInterpreterDefaultOrientation.setDescription('The current orientation default for this interpreter. This value may be overridden for a particular job (e.g., by a command in the input data stream).')
prtInterpreterFeedAddressability = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 15, 1, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInterpreterFeedAddressability.setStatus('current')
if mibBuilder.loadTexts: prtInterpreterFeedAddressability.setDescription('The maximum interpreter addressability in the feed direction in 10000 prtMarkerAddressabilityUnits (as specified by prtMarkerDefaultIndex) for this interpreter. The value (-1) means other and specifically indicates that the sub-unit places no restrictions on this parameter. The value (-2) means unknown. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtInterpreterXFeedAddressability = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 15, 1, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInterpreterXFeedAddressability.setStatus('current')
if mibBuilder.loadTexts: prtInterpreterXFeedAddressability.setDescription('The maximum interpreter addressability in the cross feed direction in 10000 prtMarkerAddressabilityUnits (as specified by prtMarkerDefaultIndex) for this interpreter. The value (-1) means other and specifically indicates that the sub-unit places no restrictions on this parameter. The value (-2) means unknown. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtInterpreterDefaultCharSetIn = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 15, 1, 1, 10), IANACharset()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInterpreterDefaultCharSetIn.setStatus('current')
if mibBuilder.loadTexts: prtInterpreterDefaultCharSetIn.setDescription('The default coded character set for input octets encountered outside a context in which the Page Description Language established the interpretation of the octets. (Input octets are presented to the interpreter through a path defined in the channel group.)')
prtInterpreterDefaultCharSetOut = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 15, 1, 1, 11), IANACharset()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInterpreterDefaultCharSetOut.setStatus('current')
if mibBuilder.loadTexts: prtInterpreterDefaultCharSetOut.setDescription("The default character set for data coming from this interpreter through the printer's output channel (i.e. the 'backchannel').")
prtInterpreterTwoWay = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 15, 1, 1, 12), PrtInterpreterTwoWayTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInterpreterTwoWay.setStatus('current')
if mibBuilder.loadTexts: prtInterpreterTwoWay.setDescription('Indicates whether or not this interpreter returns information back to the host.')
prtConsoleDisplayBuffer = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 16))
prtConsoleDisplayBufferTable = MibTable((1, 3, 6, 1, 2, 1, 43, 16, 5), )
if mibBuilder.loadTexts: prtConsoleDisplayBufferTable.setStatus('current')
if mibBuilder.loadTexts: prtConsoleDisplayBufferTable.setDescription('Physical display buffer for printer console display or operator panel NOTE: The above description has been modified from RFC 1759 for clarification.')
prtConsoleDisplayBufferEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 16, 5, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Printer-MIB", "prtConsoleDisplayBufferIndex"))
if mibBuilder.loadTexts: prtConsoleDisplayBufferEntry.setStatus('current')
if mibBuilder.loadTexts: prtConsoleDisplayBufferEntry.setDescription("This table contains one entry for each physical line on the display. Lines cannot be added or deleted. Entries may exist in the table for each device index with a device type of 'printer'. NOTE: The above description has been modified from RFC 1759 for clarification.")
prtConsoleDisplayBufferIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 16, 5, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535)))
if mibBuilder.loadTexts: prtConsoleDisplayBufferIndex.setStatus('current')
if mibBuilder.loadTexts: prtConsoleDisplayBufferIndex.setDescription('A unique value for each console line in the printer. The value is used to identify this console line. Although these values may change due to a major reconfiguration of the device (e.g., the addition of new console lines to the printer). Values SHOULD remain stable across successive printer power cycles. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtConsoleDisplayBufferText = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 16, 5, 1, 2), PrtConsoleDescriptionStringTC()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtConsoleDisplayBufferText.setStatus('current')
if mibBuilder.loadTexts: prtConsoleDisplayBufferText.setDescription("The content of a line in the logical display buffer of the operator's console of the printer. When a write operation occurs, normally a critical message, to one of the LineText strings, the agent should make that line displayable if a physical display is present. Writing a zero length string clears the line. It is an implementation- specific matter as to whether the agent allows a line to be overwritten before it has been cleared. Printer generated strings shall be in the localization specified by prtConsoleLocalization.Management Application generated strings should be localized by the Management Application.")
prtConsoleLights = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 17))
prtConsoleLightTable = MibTable((1, 3, 6, 1, 2, 1, 43, 17, 6), )
if mibBuilder.loadTexts: prtConsoleLightTable.setStatus('current')
if mibBuilder.loadTexts: prtConsoleLightTable.setDescription('The console light table provides a description and state information for each light present on the printer console. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtConsoleLightEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 17, 6, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Printer-MIB", "prtConsoleLightIndex"))
if mibBuilder.loadTexts: prtConsoleLightEntry.setStatus('current')
if mibBuilder.loadTexts: prtConsoleLightEntry.setDescription("Entries may exist in the table for each device index with a device type of 'printer'. NOTE: The above description has been modified from RFC 1759 for clarification.")
prtConsoleLightIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 17, 6, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535)))
if mibBuilder.loadTexts: prtConsoleLightIndex.setStatus('current')
if mibBuilder.loadTexts: prtConsoleLightIndex.setDescription('A unique value used by the printer to identify this light. Although these values may change due to a major reconfiguration of the device (e.g., the addition of new lights to the printer). Values SHOULD remain stable across successive printer power cycles. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtConsoleOnTime = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 17, 6, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtConsoleOnTime.setStatus('current')
if mibBuilder.loadTexts: prtConsoleOnTime.setDescription('This object, in conjunction with prtConsoleOffTime, defines the current status of the light. If both prtConsoleOnTime and prtConsoleOffTime are non-zero, the lamp is blinking and the values presented define the on time and off time, respectively, in milliseconds. If prtConsoleOnTime is zero and prtConsoleOffTime is non-zero, the lamp is off. If prtConsoleOffTime is zero and prtConsoleOnTime is non-zero, the lamp is on. If both values are zero the lamp is off. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtConsoleOffTime = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 17, 6, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtConsoleOffTime.setStatus('current')
if mibBuilder.loadTexts: prtConsoleOffTime.setDescription('This object, in conjunction with prtConsoleOnTime, defines the current status of the light. If both prtConsoleOnTime and prtConsoleOffTime are non-zero, the lamp is blinking and the values presented define the on time and off time, respectively, in milliseconds. If prtConsoleOnTime is zero and prtConsoleOffTime is non-zero, the lamp is off. If prtConsoleOffTime is zero and prtConsoleOnTime is non-zero, the lamp is on. If both values are zero the lamp is off. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtConsoleColor = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 17, 6, 1, 4), PrtConsoleColorTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtConsoleColor.setStatus('current')
if mibBuilder.loadTexts: prtConsoleColor.setDescription('The color of this light.')
prtConsoleDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 17, 6, 1, 5), PrtConsoleDescriptionStringTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtConsoleDescription.setStatus('current')
if mibBuilder.loadTexts: prtConsoleDescription.setDescription('The vendor description or label of this light in the localization specified by prtConsoleLocalization.')
prtAlert = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 18))
prtAlertTable = MibTable((1, 3, 6, 1, 2, 1, 43, 18, 1), )
if mibBuilder.loadTexts: prtAlertTable.setStatus('current')
if mibBuilder.loadTexts: prtAlertTable.setDescription('The prtAlertTable lists all the critical and non-critical alerts currently active in the printer. A critical alert is one that stops the printer from printing immediately and printing can not continue until the critical alert condition is eliminated. Non-critical alerts are those items that do not stop printing but may at some future time. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtAlertEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 18, 1, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Printer-MIB", "prtAlertIndex"))
if mibBuilder.loadTexts: prtAlertEntry.setStatus('current')
if mibBuilder.loadTexts: prtAlertEntry.setDescription("Entries may exist in the table for each device index with a device type of 'printer'. NOTE: The above description has been modified from RFC 1759 for clarification.")
prtAlertIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 18, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtAlertIndex.setStatus('current')
if mibBuilder.loadTexts: prtAlertIndex.setDescription("The index value used to determine which alerts have been added or removed from the alert table. This is an incrementing integer initialized to 1 when the printer is reset. (i.e., The first event placed in the alert table after a reset of the printer shall have an index value of 1.) When the printer adds an alert to the table, that alert is assigned the next higher integer value from the last item entered into the table. If the index value reaches its maximum value, the next index value used must be 1. NOTE: The management application will read the alert table when a trap or event notification occurs or at a periodic rate and then parse the table to determine if any new entries were added by comparing the last known index value with the current highest index value. The management application will then update its copy of the alert table. When the printer discovers that an alert is no longer active, the printer shall remove the row for that alert from the table and shall reduce the number of rows in the table. The printer may add or delete any number of rows from the table at any time. The management station can detect when binary change alerts have been deleted by requesting an attribute of each alert, and noting alerts as deleted when that retrieval is not possible. The objects 'prtAlertCriticalEvents'and 'prtAlertAllEvents' in the 'prtGeneralTable' reduce the need for management applications to scan the 'prtAlertTable'. NOTE: The above description has been modified from RFC 1759 for clarification.")
prtAlertSeverityLevel = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 18, 1, 1, 2), PrtAlertSeverityLevelTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtAlertSeverityLevel.setStatus('current')
if mibBuilder.loadTexts: prtAlertSeverityLevel.setDescription('The level of severity of this alert table entry. The printer determines the severity level assigned to each entry into the table.')
prtAlertTrainingLevel = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 18, 1, 1, 3), PrtAlertTrainingLevelTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtAlertTrainingLevel.setStatus('current')
if mibBuilder.loadTexts: prtAlertTrainingLevel.setDescription('See TEXTUAL-CONVENTION PrtAlertTrainingLevelTC. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtAlertGroup = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 18, 1, 1, 4), PrtAlertGroupTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtAlertGroup.setStatus('current')
if mibBuilder.loadTexts: prtAlertGroup.setDescription('The type of sub-unit within the printer model that this alert is related. Input, output, and markers are examples of printer model groups, i.e., examples of types of sub-units. Wherever possible, these enumerations match the sub-identifier that identifies the relevant table in the printmib.')
prtAlertGroupIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 18, 1, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtAlertGroupIndex.setStatus('current')
if mibBuilder.loadTexts: prtAlertGroupIndex.setDescription('The low-order index of the row within the table identified by prtAlertGroup that represents the sub-unit of the printer that caused this alert, or -1 if not applicable. The combination of the prtAlertGroup and the prtAlertGroupIndex defines exactly which printer sub-unit caused the alert; for example, Input #3, Output#2, and Marker #1. Every object in this MIB is indexed with hrDeviceIndex and optionally, another index variable. If this other index variable is present in the table that generated the alert, it will be used as the value for this object. Otherwise, this value shall be -1. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtAlertLocation = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 18, 1, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtAlertLocation.setStatus('current')
if mibBuilder.loadTexts: prtAlertLocation.setDescription('The sub-unit location that is defined by the printer manufacturer to further refine the location of this alert within the designated sub-unit. The location is used in conjunction with the Group and GroupIndex values; for example, there is an alert in Input #2 at location number 7. The value (-2) indicates unknown. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtAlertCode = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 18, 1, 1, 7), PrtAlertCodeTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtAlertCode.setStatus('current')
if mibBuilder.loadTexts: prtAlertCode.setDescription('See associated TEXTUAL-CONVENTION PrtAlertCodeTC. NOTE: The above description has been modified from RFC 1759 for clarification.')
prtAlertDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 18, 1, 1, 8), PrtLocalizedDescriptionStringTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtAlertDescription.setStatus('current')
if mibBuilder.loadTexts: prtAlertDescription.setDescription("A description of this alert entry in the localization specified by prtGeneralCurrentLocalization. The description is provided by the printer to further elaborate on the enumerated alert or provide information in the case where the code is classified as 'other' or 'unknown'. The printer is required to return a description string but the string may be a null string.")
prtAlertTime = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 18, 1, 1, 9), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtAlertTime.setStatus('current')
if mibBuilder.loadTexts: prtAlertTime.setDescription('The value of sysUpTime at the time that this alert was generated.')
printerV1Alert = ObjectIdentity((1, 3, 6, 1, 2, 1, 43, 18, 2))
if mibBuilder.loadTexts: printerV1Alert.setStatus('current')
if mibBuilder.loadTexts: printerV1Alert.setDescription('The value of the enterprise-specific OID in an SNMPv1 trap sent signaling a critical event in the prtAlertTable.')
printerV2AlertPrefix = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 18, 2, 0))
printerV2Alert = NotificationType((1, 3, 6, 1, 2, 1, 43, 18, 2, 0, 1)).setObjects(("Printer-MIB", "prtAlertIndex"), ("Printer-MIB", "prtAlertSeverityLevel"), ("Printer-MIB", "prtAlertGroup"), ("Printer-MIB", "prtAlertGroupIndex"), ("Printer-MIB", "prtAlertLocation"), ("Printer-MIB", "prtAlertCode"))
if mibBuilder.loadTexts: printerV2Alert.setStatus('current')
if mibBuilder.loadTexts: printerV2Alert.setDescription("This trap is sent whenever a critical event is added to the prtAlertTable. NOTE: The prtAlertIndex object was redundantly included in the bindings of the 'printerV2Alert' notification in RFC 1759, even though the value exists in the instance qualifier of all the other bindings. This object has been retained to provide compatiblity with existing RFC 1759 implementaions.")
prtMIBConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 2))
prtMIBCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 43, 2, 1)).setObjects(("Printer-MIB", "prtGeneralGroup"), ("Printer-MIB", "prtInputGroup"), ("Printer-MIB", "prtOutputGroup"), ("Printer-MIB", "prtMarkerGroup"), ("Printer-MIB", "prtMediaPathGroup"), ("Printer-MIB", "prtChannelGroup"), ("Printer-MIB", "prtInterpreterGroup"), ("Printer-MIB", "prtConsoleGroup"), ("Printer-MIB", "prtAlertTableGroup"))

if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    prtMIBCompliance = prtMIBCompliance.setStatus('current')
if mibBuilder.loadTexts: prtMIBCompliance.setDescription('The compliance statement for agents that implement the printer MIB as defined by RFC 1759.')
prtMIB2Compliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 43, 2, 3)).setObjects(("Printer-MIB", "prtGeneralGroup"), ("Printer-MIB", "prtInputGroup"), ("Printer-MIB", "prtOutputGroup"), ("Printer-MIB", "prtMarkerGroup"), ("Printer-MIB", "prtMediaPathGroup"), ("Printer-MIB", "prtChannelGroup"), ("Printer-MIB", "prtInterpreterGroup"), ("Printer-MIB", "prtConsoleGroup"), ("Printer-MIB", "prtAlertTableGroup"))

if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    prtMIB2Compliance = prtMIB2Compliance.setStatus('current')
if mibBuilder.loadTexts: prtMIB2Compliance.setDescription('The compliance statement for agents that implement the printer MIB V2.')
prtMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 2, 2))
prtGeneralGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 1)).setObjects(("Printer-MIB", "prtGeneralConfigChanges"), ("Printer-MIB", "prtGeneralCurrentLocalization"), ("Printer-MIB", "prtGeneralReset"), ("Printer-MIB", "prtCoverDescription"), ("Printer-MIB", "prtCoverStatus"), ("Printer-MIB", "prtLocalizationLanguage"), ("Printer-MIB", "prtLocalizationCountry"), ("Printer-MIB", "prtLocalizationCharacterSet"), ("Printer-MIB", "prtStorageRefIndex"), ("Printer-MIB", "prtDeviceRefIndex"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    prtGeneralGroup = prtGeneralGroup.setStatus('current')
if mibBuilder.loadTexts: prtGeneralGroup.setDescription('The general printer group.')
prtResponsiblePartyGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 2)).setObjects(("Printer-MIB", "prtGeneralCurrentOperator"), ("Printer-MIB", "prtGeneralServicePerson"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    prtResponsiblePartyGroup = prtResponsiblePartyGroup.setStatus('current')
if mibBuilder.loadTexts: prtResponsiblePartyGroup.setDescription('The responsible party group contains contact information for humans responsible for the printer.')
prtInputGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 3)).setObjects(("Printer-MIB", "prtInputDefaultIndex"), ("Printer-MIB", "prtInputType"), ("Printer-MIB", "prtInputDimUnit"), ("Printer-MIB", "prtInputMediaDimFeedDirDeclared"), ("Printer-MIB", "prtInputMediaDimXFeedDirDeclared"), ("Printer-MIB", "prtInputMediaDimFeedDirChosen"), ("Printer-MIB", "prtInputMediaDimXFeedDirChosen"), ("Printer-MIB", "prtInputCapacityUnit"), ("Printer-MIB", "prtInputMaxCapacity"), ("Printer-MIB", "prtInputCurrentLevel"), ("Printer-MIB", "prtInputStatus"), ("Printer-MIB", "prtInputMediaName"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    prtInputGroup = prtInputGroup.setStatus('current')
if mibBuilder.loadTexts: prtInputGroup.setDescription('The input group.')
prtExtendedInputGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 4)).setObjects(("Printer-MIB", "prtInputName"), ("Printer-MIB", "prtInputVendorName"), ("Printer-MIB", "prtInputModel"), ("Printer-MIB", "prtInputVersion"), ("Printer-MIB", "prtInputSerialNumber"), ("Printer-MIB", "prtInputDescription"), ("Printer-MIB", "prtInputSecurity"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    prtExtendedInputGroup = prtExtendedInputGroup.setStatus('current')
if mibBuilder.loadTexts: prtExtendedInputGroup.setDescription('The extended input group.')
prtInputMediaGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 5)).setObjects(("Printer-MIB", "prtInputMediaWeight"), ("Printer-MIB", "prtInputMediaType"), ("Printer-MIB", "prtInputMediaColor"), ("Printer-MIB", "prtInputMediaFormParts"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    prtInputMediaGroup = prtInputMediaGroup.setStatus('current')
if mibBuilder.loadTexts: prtInputMediaGroup.setDescription('The input media group.')
prtOutputGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 6)).setObjects(("Printer-MIB", "prtOutputDefaultIndex"), ("Printer-MIB", "prtOutputType"), ("Printer-MIB", "prtOutputCapacityUnit"), ("Printer-MIB", "prtOutputMaxCapacity"), ("Printer-MIB", "prtOutputRemainingCapacity"), ("Printer-MIB", "prtOutputStatus"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    prtOutputGroup = prtOutputGroup.setStatus('current')
if mibBuilder.loadTexts: prtOutputGroup.setDescription('The output group.')
prtExtendedOutputGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 7)).setObjects(("Printer-MIB", "prtOutputName"), ("Printer-MIB", "prtOutputVendorName"), ("Printer-MIB", "prtOutputModel"), ("Printer-MIB", "prtOutputVersion"), ("Printer-MIB", "prtOutputSerialNumber"), ("Printer-MIB", "prtOutputDescription"), ("Printer-MIB", "prtOutputSecurity"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    prtExtendedOutputGroup = prtExtendedOutputGroup.setStatus('current')
if mibBuilder.loadTexts: prtExtendedOutputGroup.setDescription('The extended output group.')
prtOutputDimensionsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 8)).setObjects(("Printer-MIB", "prtOutputDimUnit"), ("Printer-MIB", "prtOutputMaxDimFeedDir"), ("Printer-MIB", "prtOutputMaxDimXFeedDir"), ("Printer-MIB", "prtOutputMinDimFeedDir"), ("Printer-MIB", "prtOutputMinDimXFeedDir"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    prtOutputDimensionsGroup = prtOutputDimensionsGroup.setStatus('current')
if mibBuilder.loadTexts: prtOutputDimensionsGroup.setDescription('The output dimensions group')
prtOutputFeaturesGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 9)).setObjects(("Printer-MIB", "prtOutputStackingOrder"), ("Printer-MIB", "prtOutputPageDeliveryOrientation"), ("Printer-MIB", "prtOutputBursting"), ("Printer-MIB", "prtOutputDecollating"), ("Printer-MIB", "prtOutputPageCollated"), ("Printer-MIB", "prtOutputOffsetStacking"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    prtOutputFeaturesGroup = prtOutputFeaturesGroup.setStatus('current')
if mibBuilder.loadTexts: prtOutputFeaturesGroup.setDescription('The output features group.')
prtMarkerGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 10)).setObjects(("Printer-MIB", "prtMarkerDefaultIndex"), ("Printer-MIB", "prtMarkerMarkTech"), ("Printer-MIB", "prtMarkerCounterUnit"), ("Printer-MIB", "prtMarkerLifeCount"), ("Printer-MIB", "prtMarkerPowerOnCount"), ("Printer-MIB", "prtMarkerProcessColorants"), ("Printer-MIB", "prtMarkerSpotColorants"), ("Printer-MIB", "prtMarkerAddressabilityUnit"), ("Printer-MIB", "prtMarkerAddressabilityFeedDir"), ("Printer-MIB", "prtMarkerAddressabilityXFeedDir"), ("Printer-MIB", "prtMarkerNorthMargin"), ("Printer-MIB", "prtMarkerSouthMargin"), ("Printer-MIB", "prtMarkerWestMargin"), ("Printer-MIB", "prtMarkerEastMargin"), ("Printer-MIB", "prtMarkerStatus"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    prtMarkerGroup = prtMarkerGroup.setStatus('current')
if mibBuilder.loadTexts: prtMarkerGroup.setDescription('The marker group.')
prtMarkerSuppliesGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 11)).setObjects(("Printer-MIB", "prtMarkerSuppliesMarkerIndex"), ("Printer-MIB", "prtMarkerSuppliesColorantIndex"), ("Printer-MIB", "prtMarkerSuppliesClass"), ("Printer-MIB", "prtMarkerSuppliesType"), ("Printer-MIB", "prtMarkerSuppliesDescription"), ("Printer-MIB", "prtMarkerSuppliesSupplyUnit"), ("Printer-MIB", "prtMarkerSuppliesMaxCapacity"), ("Printer-MIB", "prtMarkerSuppliesLevel"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    prtMarkerSuppliesGroup = prtMarkerSuppliesGroup.setStatus('current')
if mibBuilder.loadTexts: prtMarkerSuppliesGroup.setDescription('The marker supplies group.')
prtMarkerColorantGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 12)).setObjects(("Printer-MIB", "prtMarkerColorantMarkerIndex"), ("Printer-MIB", "prtMarkerColorantRole"), ("Printer-MIB", "prtMarkerColorantValue"), ("Printer-MIB", "prtMarkerColorantTonality"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    prtMarkerColorantGroup = prtMarkerColorantGroup.setStatus('current')
if mibBuilder.loadTexts: prtMarkerColorantGroup.setDescription('The marker colorant group.')
prtMediaPathGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 13)).setObjects(("Printer-MIB", "prtMediaPathDefaultIndex"), ("Printer-MIB", "prtMediaPathMaxSpeedPrintUnit"), ("Printer-MIB", "prtMediaPathMediaSizeUnit"), ("Printer-MIB", "prtMediaPathMaxSpeed"), ("Printer-MIB", "prtMediaPathMaxMediaFeedDir"), ("Printer-MIB", "prtMediaPathMaxMediaXFeedDir"), ("Printer-MIB", "prtMediaPathMinMediaFeedDir"), ("Printer-MIB", "prtMediaPathMinMediaXFeedDir"), ("Printer-MIB", "prtMediaPathType"), ("Printer-MIB", "prtMediaPathDescription"), ("Printer-MIB", "prtMediaPathStatus"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    prtMediaPathGroup = prtMediaPathGroup.setStatus('current')
if mibBuilder.loadTexts: prtMediaPathGroup.setDescription('The media path group.')
prtChannelGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 14)).setObjects(("Printer-MIB", "prtChannelType"), ("Printer-MIB", "prtChannelProtocolVersion"), ("Printer-MIB", "prtChannelCurrentJobCntlLangIndex"), ("Printer-MIB", "prtChannelDefaultPageDescLangIndex"), ("Printer-MIB", "prtChannelState"), ("Printer-MIB", "prtChannelIfIndex"), ("Printer-MIB", "prtChannelStatus"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    prtChannelGroup = prtChannelGroup.setStatus('current')
if mibBuilder.loadTexts: prtChannelGroup.setDescription('The channel group.')
prtInterpreterGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 15)).setObjects(("Printer-MIB", "prtInterpreterLangFamily"), ("Printer-MIB", "prtInterpreterLangLevel"), ("Printer-MIB", "prtInterpreterLangVersion"), ("Printer-MIB", "prtInterpreterDescription"), ("Printer-MIB", "prtInterpreterVersion"), ("Printer-MIB", "prtInterpreterDefaultOrientation"), ("Printer-MIB", "prtInterpreterFeedAddressability"), ("Printer-MIB", "prtInterpreterXFeedAddressability"), ("Printer-MIB", "prtInterpreterDefaultCharSetIn"), ("Printer-MIB", "prtInterpreterDefaultCharSetOut"), ("Printer-MIB", "prtInterpreterTwoWay"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    prtInterpreterGroup = prtInterpreterGroup.setStatus('current')
if mibBuilder.loadTexts: prtInterpreterGroup.setDescription('The interpreter group.')
prtConsoleGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 16)).setObjects(("Printer-MIB", "prtConsoleLocalization"), ("Printer-MIB", "prtConsoleNumberOfDisplayLines"), ("Printer-MIB", "prtConsoleNumberOfDisplayChars"), ("Printer-MIB", "prtConsoleDisable"), ("Printer-MIB", "prtConsoleDisplayBufferText"), ("Printer-MIB", "prtConsoleOnTime"), ("Printer-MIB", "prtConsoleOffTime"), ("Printer-MIB", "prtConsoleColor"), ("Printer-MIB", "prtConsoleDescription"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    prtConsoleGroup = prtConsoleGroup.setStatus('current')
if mibBuilder.loadTexts: prtConsoleGroup.setDescription('The console group.')
prtAlertTableGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 17)).setObjects(("Printer-MIB", "prtAlertSeverityLevel"), ("Printer-MIB", "prtAlertTrainingLevel"), ("Printer-MIB", "prtAlertGroup"), ("Printer-MIB", "prtAlertGroupIndex"), ("Printer-MIB", "prtAlertLocation"), ("Printer-MIB", "prtAlertCode"), ("Printer-MIB", "prtAlertDescription"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    prtAlertTableGroup = prtAlertTableGroup.setStatus('current')
if mibBuilder.loadTexts: prtAlertTableGroup.setDescription('The alert table group.')
prtAlertTimeGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 18)).setObjects(("Printer-MIB", "prtAlertTime"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    prtAlertTimeGroup = prtAlertTimeGroup.setStatus('current')
if mibBuilder.loadTexts: prtAlertTimeGroup.setDescription('The alert time group. Implementation of prtAlertTime is strongly RECOMMENDED.')
prtMIB2Groups = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 2, 4))
prtAuxiliarySheetGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 19)).setObjects(("Printer-MIB", "prtAuxiliarySheetStartupPage"), ("Printer-MIB", "prtAuxiliarySheetBannerPage"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    prtAuxiliarySheetGroup = prtAuxiliarySheetGroup.setStatus('current')
if mibBuilder.loadTexts: prtAuxiliarySheetGroup.setDescription('The auxiliary sheet group.')
prtInputSwitchingGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 20)).setObjects(("Printer-MIB", "prtInputMediaLoadTimeout"), ("Printer-MIB", "prtInputNextIndex"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    prtInputSwitchingGroup = prtInputSwitchingGroup.setStatus('current')
if mibBuilder.loadTexts: prtInputSwitchingGroup.setDescription('The input switching group.')
prtGeneralV2Group = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 21)).setObjects(("Printer-MIB", "prtGeneralPrinterName"), ("Printer-MIB", "prtGeneralSerialNumber"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    prtGeneralV2Group = prtGeneralV2Group.setStatus('current')
if mibBuilder.loadTexts: prtGeneralV2Group.setDescription('The general printer group with new v2 objects.')
prtAlertTableV2Group = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 22)).setObjects(("Printer-MIB", "prtAlertIndex"), ("Printer-MIB", "prtAlertCriticalEvents"), ("Printer-MIB", "prtAlertAllEvents"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    prtAlertTableV2Group = prtAlertTableV2Group.setStatus('current')
if mibBuilder.loadTexts: prtAlertTableV2Group.setDescription("The alert table group with new v2 objects and prtAlertIndex changed to MAX-ACCESS of 'read-only' for inclusion in the trap bindings (as originally defined in RFC 1759).")
prtChannelV2Group = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 23)).setObjects(("Printer-MIB", "prtChannelInformation"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    prtChannelV2Group = prtChannelV2Group.setStatus('current')
if mibBuilder.loadTexts: prtChannelV2Group.setDescription('The channel group with a new v2 object.')
prtAlertTrapGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 24)).setObjects(("Printer-MIB", "printerV2Alert"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    prtAlertTrapGroup = prtAlertTrapGroup.setStatus('current')
if mibBuilder.loadTexts: prtAlertTrapGroup.setDescription('The alert trap group.')
mibBuilder.exportSymbols("Printer-MIB", prtGeneralV2Group=prtGeneralV2Group, prtOutputEntry=prtOutputEntry, PrtMediaPathMaxSpeedPrintUnitTC=PrtMediaPathMaxSpeedPrintUnitTC, prtConsoleOnTime=prtConsoleOnTime, prtAlertCriticalEvents=prtAlertCriticalEvents, prtResponsiblePartyGroup=prtResponsiblePartyGroup, prtConsoleLights=prtConsoleLights, prtGeneralGroup=prtGeneralGroup, prtInterpreter=prtInterpreter, prtOutputVersion=prtOutputVersion, prtMarkerColorantValue=prtMarkerColorantValue, prtConsoleColor=prtConsoleColor, CapacityUnit=CapacityUnit, prtOutputPageDeliveryOrientation=prtOutputPageDeliveryOrientation, prtInputName=prtInputName, prtAlertGroup=prtAlertGroup, prtOutputMaxDimFeedDir=prtOutputMaxDimFeedDir, prtLocalization=prtLocalization, prtInput=prtInput, prtConsoleDescription=prtConsoleDescription, PrtOutputPageDeliveryOrientationTC=PrtOutputPageDeliveryOrientationTC, prtChannelCurrentJobCntlLangIndex=prtChannelCurrentJobCntlLangIndex, prtLocalizationTable=prtLocalizationTable, prtMediaPathMaxSpeed=prtMediaPathMaxSpeed, prtInterpreterFeedAddressability=prtInterpreterFeedAddressability, prtMarkerSuppliesSupplyUnit=prtMarkerSuppliesSupplyUnit, prtOutputFeaturesGroup=prtOutputFeaturesGroup, prtOutputStatus=prtOutputStatus, prtAlertTable=prtAlertTable, SubUnitStatus=SubUnitStatus, prtAlertTrainingLevel=prtAlertTrainingLevel, prtInputDefaultIndex=prtInputDefaultIndex, prtMediaPathMaxSpeedPrintUnit=prtMediaPathMaxSpeedPrintUnit, prtChannelTable=prtChannelTable, prtChannelProtocolVersion=prtChannelProtocolVersion, prtConsoleNumberOfDisplayChars=prtConsoleNumberOfDisplayChars, prtInputMediaName=prtInputMediaName, prtMarkerSouthMargin=prtMarkerSouthMargin, printerV2AlertPrefix=printerV2AlertPrefix, prtMarkerColorantRole=prtMarkerColorantRole, prtInputDescription=prtInputDescription, prtMarkerProcessColorants=prtMarkerProcessColorants, prtMediaPathMinMediaXFeedDir=prtMediaPathMinMediaXFeedDir, prtAlertTimeGroup=prtAlertTimeGroup, prtDeviceRefEntry=prtDeviceRefEntry, prtGeneralServicePerson=prtGeneralServicePerson, prtMediaPathMaxMediaFeedDir=prtMediaPathMaxMediaFeedDir, prtOutputDimUnit=prtOutputDimUnit, prtInputMediaColor=prtInputMediaColor, prtMarkerWestMargin=prtMarkerWestMargin, prtMarkerSuppliesLevel=prtMarkerSuppliesLevel, prtConsoleLightEntry=prtConsoleLightEntry, prtOutputDecollating=prtOutputDecollating, prtOutputVendorName=prtOutputVendorName, prtAlertTableV2Group=prtAlertTableV2Group, prtInterpreterLangFamily=prtInterpreterLangFamily, printerV2Alert=printerV2Alert, prtInterpreterXFeedAddressability=prtInterpreterXFeedAddressability, PrtSubUnitStatusTC=PrtSubUnitStatusTC, prtInterpreterVersion=prtInterpreterVersion, prtMediaPathStatus=prtMediaPathStatus, prtInputIndex=prtInputIndex, PrtMarkerColorantRoleTC=PrtMarkerColorantRoleTC, prtOutputRemainingCapacity=prtOutputRemainingCapacity, prtChannelGroup=prtChannelGroup, prtInputMediaLoadTimeout=prtInputMediaLoadTimeout, PrtMarkerSuppliesClassTC=PrtMarkerSuppliesClassTC, prtChannelStatus=prtChannelStatus, prtMediaPathMinMediaFeedDir=prtMediaPathMinMediaFeedDir, prtCoverTable=prtCoverTable, prtAuxiliarySheetGroup=prtAuxiliarySheetGroup, prtMarkerSuppliesIndex=prtMarkerSuppliesIndex, prtMediaPathType=prtMediaPathType, prtMediaPathDefaultIndex=prtMediaPathDefaultIndex, prtOutputType=prtOutputType, prtInputVersion=prtInputVersion, prtInterpreterGroup=prtInterpreterGroup, PrtMarkerCounterUnitTC=PrtMarkerCounterUnitTC, prtMIB2Groups=prtMIB2Groups, prtCoverDescription=prtCoverDescription, prtMarkerSuppliesType=prtMarkerSuppliesType, prtAlertDescription=prtAlertDescription, prtOutputSerialNumber=prtOutputSerialNumber, prtMarkerMarkTech=prtMarkerMarkTech, prtInputMediaGroup=prtInputMediaGroup, prtLocalizationIndex=prtLocalizationIndex, prtAlertAllEvents=prtAlertAllEvents, prtMarkerColorant=prtMarkerColorant, prtInputVendorName=prtInputVendorName, prtMarkerDefaultIndex=prtMarkerDefaultIndex, prtOutputBursting=prtOutputBursting, prtChannelIndex=prtChannelIndex, prtConsoleDisplayBufferTable=prtConsoleDisplayBufferTable, prtAuxiliarySheetStartupPage=prtAuxiliarySheetStartupPage, prtMarkerLifeCount=prtMarkerLifeCount, prtOutputDescription=prtOutputDescription, prtMarkerSupplies=prtMarkerSupplies, prtInterpreterTwoWay=prtInterpreterTwoWay, prtMarkerSuppliesEntry=prtMarkerSuppliesEntry, prtAlertIndex=prtAlertIndex, prtMarkerAddressabilityXFeedDir=prtMarkerAddressabilityXFeedDir, prtMediaPathDescription=prtMediaPathDescription, prtMarkerGroup=prtMarkerGroup, prtOutput=prtOutput, prtOutputDimensionsGroup=prtOutputDimensionsGroup, prtChannelDefaultPageDescLangIndex=prtChannelDefaultPageDescLangIndex, PrtCapacityUnitTC=PrtCapacityUnitTC, prtConsoleDisable=prtConsoleDisable, prtMarker=prtMarker, prtConsoleNumberOfDisplayLines=prtConsoleNumberOfDisplayLines, prtInputType=prtInputType, prtInputMediaDimFeedDirDeclared=prtInputMediaDimFeedDirDeclared, prtInterpreterTable=prtInterpreterTable, prtExtendedOutputGroup=prtExtendedOutputGroup, prtInputSwitchingGroup=prtInputSwitchingGroup, PresentOnOff=PresentOnOff, prtMarkerColorantMarkerIndex=prtMarkerColorantMarkerIndex, PrtMediaUnitTC=PrtMediaUnitTC, prtCoverIndex=prtCoverIndex, prtOutputCapacityUnit=prtOutputCapacityUnit, prtInterpreterEntry=prtInterpreterEntry, prtMarkerSpotColorants=prtMarkerSpotColorants, prtInputMediaDimXFeedDirChosen=prtInputMediaDimXFeedDirChosen, PrtConsoleDescriptionStringTC=PrtConsoleDescriptionStringTC, prtChannelIfIndex=prtChannelIfIndex, prtChannelState=prtChannelState, prtGeneralSerialNumber=prtGeneralSerialNumber, prtChannelV2Group=prtChannelV2Group, prtOutputModel=prtOutputModel, prtConsoleDisplayBufferIndex=prtConsoleDisplayBufferIndex, prtAlertTime=prtAlertTime, prtMarkerIndex=prtMarkerIndex, prtOutputStackingOrder=prtOutputStackingOrder, prtLocalizationEntry=prtLocalizationEntry, prtAlertCode=prtAlertCode, prtOutputMaxDimXFeedDir=prtOutputMaxDimXFeedDir, prtCover=prtCover, prtInputModel=prtInputModel, prtMarkerPowerOnCount=prtMarkerPowerOnCount, PrtOutputStackingOrderTC=PrtOutputStackingOrderTC, prtInterpreterIndex=prtInterpreterIndex, PrtLocalizedDescriptionStringTC=PrtLocalizedDescriptionStringTC, prtMIBCompliance=prtMIBCompliance, prtLocalizationCountry=prtLocalizationCountry, prtInputMediaFormParts=prtInputMediaFormParts, prtAlert=prtAlert, prtDeviceRefSeqNumber=prtDeviceRefSeqNumber, prtInputNextIndex=prtInputNextIndex, prtOutputMinDimXFeedDir=prtOutputMinDimXFeedDir, prtMarkerNorthMargin=prtMarkerNorthMargin, prtOutputOffsetStacking=prtOutputOffsetStacking, prtMarkerEntry=prtMarkerEntry, prtMediaPathTable=prtMediaPathTable, prtMediaPathGroup=prtMediaPathGroup, prtMarkerCounterUnit=prtMarkerCounterUnit, prtOutputDefaultIndex=prtOutputDefaultIndex, prtMarkerStatus=prtMarkerStatus, prtAlertSeverityLevel=prtAlertSeverityLevel, prtAlertLocation=prtAlertLocation, prtMarkerSuppliesClass=prtMarkerSuppliesClass, prtMediaPathEntry=prtMediaPathEntry, prtStorageRefTable=prtStorageRefTable, prtExtendedInputGroup=prtExtendedInputGroup, prtMediaPathMediaSizeUnit=prtMediaPathMediaSizeUnit, PrtInterpreterTwoWayTC=PrtInterpreterTwoWayTC, prtInputEntry=prtInputEntry, prtCoverStatus=prtCoverStatus, prtInputMediaDimXFeedDirDeclared=prtInputMediaDimXFeedDirDeclared, prtConsoleLightIndex=prtConsoleLightIndex, prtMarkerSuppliesMarkerIndex=prtMarkerSuppliesMarkerIndex, prtAlertEntry=prtAlertEntry, prtInputMediaDimFeedDirChosen=prtInputMediaDimFeedDirChosen, prtGeneralCurrentOperator=prtGeneralCurrentOperator, prtMarkerSuppliesGroup=prtMarkerSuppliesGroup, prtInputMediaWeight=prtInputMediaWeight, prtStorageRefEntry=prtStorageRefEntry, prtOutputTable=prtOutputTable, prtConsoleDisplayBuffer=prtConsoleDisplayBuffer, prtGeneralEntry=prtGeneralEntry, PYSNMP_MODULE_ID=printmib, prtMarkerTable=prtMarkerTable, prtMarkerColorantEntry=prtMarkerColorantEntry, prtInputTable=prtInputTable, prtConsoleDisplayBufferText=prtConsoleDisplayBufferText, prtGeneralCurrentLocalization=prtGeneralCurrentLocalization, prtMarkerSuppliesDescription=prtMarkerSuppliesDescription, prtInputMediaType=prtInputMediaType, PrtChannelStateTC=PrtChannelStateTC, prtMarkerSuppliesColorantIndex=prtMarkerSuppliesColorantIndex, prtMarkerColorantTable=prtMarkerColorantTable, prtOutputGroup=prtOutputGroup, prtStorageRefSeqNumber=prtStorageRefSeqNumber, MediaUnit=MediaUnit, PrtPrintOrientationTC=PrtPrintOrientationTC, prtAlertTableGroup=prtAlertTableGroup, prtConsoleLightTable=prtConsoleLightTable, PrtMarkerAddressabilityUnitTC=PrtMarkerAddressabilityUnitTC, printmib=printmib, prtInputCapacityUnit=prtInputCapacityUnit, PrtAlertSeverityLevelTC=PrtAlertSeverityLevelTC, prtMarkerSuppliesTable=prtMarkerSuppliesTable, prtConsoleGroup=prtConsoleGroup, prtDeviceRefTable=prtDeviceRefTable, prtChannel=prtChannel, prtConsoleOffTime=prtConsoleOffTime, prtGeneralPrinterName=prtGeneralPrinterName, prtInputSecurity=prtInputSecurity, prtMediaPathIndex=prtMediaPathIndex, prtInterpreterLangVersion=prtInterpreterLangVersion, prtConsoleLocalization=prtConsoleLocalization, prtDeviceRefIndex=prtDeviceRefIndex, prtLocalizationCharacterSet=prtLocalizationCharacterSet, prtMarkerColorantTonality=prtMarkerColorantTonality, prtChannelType=prtChannelType, prtGeneralTable=prtGeneralTable, prtInputDimUnit=prtInputDimUnit, prtMIBGroups=prtMIBGroups, prtMarkerEastMargin=prtMarkerEastMargin, prtAlertTrapGroup=prtAlertTrapGroup, CodedCharSet=CodedCharSet, prtChannelEntry=prtChannelEntry, prtMarkerColorantIndex=prtMarkerColorantIndex, prtInterpreterLangLevel=prtInterpreterLangLevel, prtInterpreterDefaultCharSetOut=prtInterpreterDefaultCharSetOut, prtMarkerAddressabilityUnit=prtMarkerAddressabilityUnit, prtInterpreterDefaultCharSetIn=prtInterpreterDefaultCharSetIn, prtGeneralConfigChanges=prtGeneralConfigChanges, prtOutputIndex=prtOutputIndex, prtInputCurrentLevel=prtInputCurrentLevel, prtLocalizationLanguage=prtLocalizationLanguage, prtInputSerialNumber=prtInputSerialNumber, prtOutputPageCollated=prtOutputPageCollated, prtMarkerSuppliesMaxCapacity=prtMarkerSuppliesMaxCapacity, prtInputMaxCapacity=prtInputMaxCapacity, prtOutputMinDimFeedDir=prtOutputMinDimFeedDir, prtMIBConformance=prtMIBConformance, prtGeneralReset=prtGeneralReset, prtCoverEntry=prtCoverEntry, prtAlertGroupIndex=prtAlertGroupIndex, prtGeneral=prtGeneral, prtConsoleDisplayBufferEntry=prtConsoleDisplayBufferEntry, prtOutputMaxCapacity=prtOutputMaxCapacity, prtInputGroup=prtInputGroup, prtMarkerColorantGroup=prtMarkerColorantGroup, prtAuxiliarySheetBannerPage=prtAuxiliarySheetBannerPage, prtStorageRefIndex=prtStorageRefIndex, prtInputStatus=prtInputStatus, prtChannelInformation=prtChannelInformation, prtInterpreterDefaultOrientation=prtInterpreterDefaultOrientation, prtMIB2Compliance=prtMIB2Compliance, prtInterpreterDescription=prtInterpreterDescription, printerV1Alert=printerV1Alert, PrtMarkerSuppliesSupplyUnitTC=PrtMarkerSuppliesSupplyUnitTC, prtMediaPath=prtMediaPath)
mibBuilder.exportSymbols("Printer-MIB", prtOutputName=prtOutputName, prtOutputSecurity=prtOutputSecurity, prtMarkerAddressabilityFeedDir=prtMarkerAddressabilityFeedDir, prtMediaPathMaxMediaXFeedDir=prtMediaPathMaxMediaXFeedDir)
