#
# PySNMP MIB module IP-MIB (http://snmplabs.com/pysmi)
# ASN.1 source file://data/mibs/IP-MIB
# Produced by pysmi-0.3.4 at Tue Jan 28 12:32:04 2020
# On host nerk platform Linux version 5.3.15-300.fc31.x86_64 by user spider
# Using Python version 3.7.5 (default, Oct 17 2019, 12:16:48) 
#
Integer, ObjectIdentifier, OctetString = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
NamedValues, = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
ValueSizeConstraint, SingleValueConstraint, ConstraintsUnion, ValueRangeConstraint, ConstraintsIntersection = mibBuilder.importSymbols("ASN1-REFINEMENT", "ValueSizeConstraint", "SingleValueConstraint", "ConstraintsUnion", "ValueRangeConstraint", "ConstraintsIntersection")
InterfaceIndex, = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex")
InetZoneIndex, InetAddressPrefixLength, InetAddress, InetAddressType, InetVersion = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetZoneIndex", "InetAddressPrefixLength", "InetAddress", "InetAddressType", "InetVersion")
ObjectGroup, ModuleCompliance, NotificationGroup = mibBuilder.importSymbols("SNMPv2-CONF", "ObjectGroup", "ModuleCompliance", "NotificationGroup")
Bits, ModuleIdentity, MibScalar, MibTable, MibTableRow, MibTableColumn, Gauge32, zeroDotZero, ObjectIdentity, iso, TimeTicks, Counter64, Integer32, NotificationType, Counter32, Unsigned32, IpAddress, mib_2, MibIdentifier = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "ModuleIdentity", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "Gauge32", "zeroDotZero", "ObjectIdentity", "iso", "TimeTicks", "Counter64", "Integer32", "NotificationType", "Counter32", "Unsigned32", "IpAddress", "mib-2", "MibIdentifier")
TimeStamp, RowPointer, RowStatus, StorageType, TestAndIncr, PhysAddress, TextualConvention, DisplayString, TruthValue = mibBuilder.importSymbols("SNMPv2-TC", "TimeStamp", "RowPointer", "RowStatus", "StorageType", "TestAndIncr", "PhysAddress", "TextualConvention", "DisplayString", "TruthValue")
ipMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 48))
ipMIB.setRevisions(('2006-02-02 00:00', '1994-11-01 00:00', '1991-03-31 00:00',))

if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    if mibBuilder.loadTexts: ipMIB.setRevisionsDescriptions(('The IP version neutral revision with added IPv6 objects for ND, default routers, and router advertisements. As well as being the successor to RFC 2011, this MIB is also the successor to RFCs 2465 and 2466. Published as RFC 4293.', 'A separate MIB module (IP-MIB) for IP and ICMP management objects. Published as RFC 2011.', 'The initial revision of this MIB module was part of MIB-II, which was published as RFC 1213.',))
if mibBuilder.loadTexts: ipMIB.setLastUpdated('200602020000Z')
if mibBuilder.loadTexts: ipMIB.setOrganization('IETF IPv6 MIB Revision Team')
if mibBuilder.loadTexts: ipMIB.setContactInfo('Editor: Shawn A. Routhier Interworking Labs 108 Whispering Pines Dr. Suite 235 Scotts Valley, CA 95066 USA EMail: <sar@iwl.com>')
if mibBuilder.loadTexts: ipMIB.setDescription('The MIB module for managing IP and ICMP implementations, but excluding their management of IP routes. Copyright (C) The Internet Society (2006). This version of this MIB module is part of RFC 4293; see the RFC itself for full legal notices.')
class IpAddressOriginTC(TextualConvention, Integer32):
    description = 'The origin of the address. manual(2) indicates that the address was manually configured to a specified address, e.g., by user configuration. dhcp(4) indicates an address that was assigned to this system by a DHCP server. linklayer(5) indicates an address created by IPv6 stateless auto-configuration. random(6) indicates an address chosen by the system at random, e.g., an IPv4 address within 169.254/16, or an RFC 3041 privacy address.'
    status = 'current'
    subtypeSpec = Integer32.subtypeSpec + ConstraintsUnion(SingleValueConstraint(1, 2, 4, 5, 6))
    namedValues = NamedValues(("other", 1), ("manual", 2), ("dhcp", 4), ("linklayer", 5), ("random", 6))

class IpAddressStatusTC(TextualConvention, Integer32):
    reference = 'RFC 2462'
    description = "The status of an address. Most of the states correspond to states from the IPv6 Stateless Address Autoconfiguration protocol. The preferred(1) state indicates that this is a valid address that can appear as the destination or source address of a packet. The deprecated(2) state indicates that this is a valid but deprecated address that should no longer be used as a source address in new communications, but packets addressed to such an address are processed as expected. The invalid(3) state indicates that this isn't a valid address and it shouldn't appear as the destination or source address of a packet. The inaccessible(4) state indicates that the address is not accessible because the interface to which this address is assigned is not operational. The unknown(5) state indicates that the status cannot be determined for some reason. The tentative(6) state indicates that the uniqueness of the address on the link is being verified. Addresses in this state should not be used for general communication and should only be used to determine the uniqueness of the address. The duplicate(7) state indicates the address has been determined to be non-unique on the link and so must not be used. The optimistic(8) state indicates the address is available for use, subject to restrictions, while its uniqueness on a link is being verified. In the absence of other information, an IPv4 address is always preferred(1)."
    status = 'current'
    subtypeSpec = Integer32.subtypeSpec + ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8))
    namedValues = NamedValues(("preferred", 1), ("deprecated", 2), ("invalid", 3), ("inaccessible", 4), ("unknown", 5), ("tentative", 6), ("duplicate", 7), ("optimistic", 8))

class IpAddressPrefixOriginTC(TextualConvention, Integer32):
    description = 'The origin of this prefix. manual(2) indicates a prefix that was manually configured. wellknown(3) indicates a well-known prefix, e.g., 169.254/16 for IPv4 auto-configuration or fe80::/10 for IPv6 link-local addresses. Well known prefixes may be assigned by IANA, the address registries, or by specification in a standards track RFC. dhcp(4) indicates a prefix that was assigned by a DHCP server. routeradv(5) indicates a prefix learned from a router advertisement. Note: while IpAddressOriginTC and IpAddressPrefixOriginTC are similar, they are not identical. The first defines how an address was created, while the second defines how a prefix was found.'
    status = 'current'
    subtypeSpec = Integer32.subtypeSpec + ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5))
    namedValues = NamedValues(("other", 1), ("manual", 2), ("wellknown", 3), ("dhcp", 4), ("routeradv", 5))

class Ipv6AddressIfIdentifierTC(TextualConvention, OctetString):
    description = 'This data type is used to model IPv6 address interface identifiers. This is a binary string of up to 8 octets in network byte-order.'
    status = 'current'
    displayHint = '2x:'
    subtypeSpec = OctetString.subtypeSpec + ValueSizeConstraint(0, 8)

ip = MibIdentifier((1, 3, 6, 1, 2, 1, 4))
ipForwarding = MibScalar((1, 3, 6, 1, 2, 1, 4, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2))).clone(namedValues=NamedValues(("forwarding", 1), ("notForwarding", 2)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipForwarding.setStatus('current')
if mibBuilder.loadTexts: ipForwarding.setDescription('The indication of whether this entity is acting as an IPv4 router in respect to the forwarding of datagrams received by, but not addressed to, this entity. IPv4 routers forward datagrams. IPv4 hosts do not (except those source-routed via the host). When this object is written, the entity should save the change to non-volatile storage and restore the object from non-volatile storage upon re-initialization of the system. Note: a stronger requirement is not used because this object was previously defined.')
ipDefaultTTL = MibScalar((1, 3, 6, 1, 2, 1, 4, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipDefaultTTL.setStatus('current')
if mibBuilder.loadTexts: ipDefaultTTL.setDescription('The default value inserted into the Time-To-Live field of the IPv4 header of datagrams originated at this entity, whenever a TTL value is not supplied by the transport layer protocol. When this object is written, the entity should save the change to non-volatile storage and restore the object from non-volatile storage upon re-initialization of the system. Note: a stronger requirement is not used because this object was previously defined.')
ipReasmTimeout = MibScalar((1, 3, 6, 1, 2, 1, 4, 13), Integer32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: ipReasmTimeout.setStatus('current')
if mibBuilder.loadTexts: ipReasmTimeout.setDescription('The maximum number of seconds that received fragments are held while they are awaiting reassembly at this entity.')
ipv6IpForwarding = MibScalar((1, 3, 6, 1, 2, 1, 4, 25), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2))).clone(namedValues=NamedValues(("forwarding", 1), ("notForwarding", 2)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipv6IpForwarding.setStatus('current')
if mibBuilder.loadTexts: ipv6IpForwarding.setDescription('The indication of whether this entity is acting as an IPv6 router on any interface in respect to the forwarding of datagrams received by, but not addressed to, this entity. IPv6 routers forward datagrams. IPv6 hosts do not (except those source-routed via the host). When this object is written, the entity SHOULD save the change to non-volatile storage and restore the object from non-volatile storage upon re-initialization of the system.')
ipv6IpDefaultHopLimit = MibScalar((1, 3, 6, 1, 2, 1, 4, 26), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipv6IpDefaultHopLimit.setReference('RFC 2461 Section 6.3.2')
if mibBuilder.loadTexts: ipv6IpDefaultHopLimit.setStatus('current')
if mibBuilder.loadTexts: ipv6IpDefaultHopLimit.setDescription('The default value inserted into the Hop Limit field of the IPv6 header of datagrams originated at this entity whenever a Hop Limit value is not supplied by the transport layer protocol. When this object is written, the entity SHOULD save the change to non-volatile storage and restore the object from non-volatile storage upon re-initialization of the system.')
ipv4InterfaceTableLastChange = MibScalar((1, 3, 6, 1, 2, 1, 4, 27), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv4InterfaceTableLastChange.setStatus('current')
if mibBuilder.loadTexts: ipv4InterfaceTableLastChange.setDescription('The value of sysUpTime on the most recent occasion at which a row in the ipv4InterfaceTable was added or deleted, or when an ipv4InterfaceReasmMaxSize or an ipv4InterfaceEnableStatus object was modified. If new objects are added to the ipv4InterfaceTable that require the ipv4InterfaceTableLastChange to be updated when they are modified, they must specify that requirement in their description clause.')
ipv4InterfaceTable = MibTable((1, 3, 6, 1, 2, 1, 4, 28), )
if mibBuilder.loadTexts: ipv4InterfaceTable.setStatus('current')
if mibBuilder.loadTexts: ipv4InterfaceTable.setDescription('The table containing per-interface IPv4-specific information.')
ipv4InterfaceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 28, 1), ).setIndexNames((0, "IP-MIB", "ipv4InterfaceIfIndex"))
if mibBuilder.loadTexts: ipv4InterfaceEntry.setStatus('current')
if mibBuilder.loadTexts: ipv4InterfaceEntry.setDescription('An entry containing IPv4-specific information for a specific interface.')
ipv4InterfaceIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 28, 1, 1), InterfaceIndex())
if mibBuilder.loadTexts: ipv4InterfaceIfIndex.setStatus('current')
if mibBuilder.loadTexts: ipv4InterfaceIfIndex.setDescription("The index value that uniquely identifies the interface to which this entry is applicable. The interface identified by a particular value of this index is the same interface as identified by the same value of the IF-MIB's ifIndex.")
ipv4InterfaceReasmMaxSize = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 28, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv4InterfaceReasmMaxSize.setStatus('current')
if mibBuilder.loadTexts: ipv4InterfaceReasmMaxSize.setDescription('The size of the largest IPv4 datagram that this entity can re-assemble from incoming IPv4 fragmented datagrams received on this interface.')
ipv4InterfaceEnableStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 28, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2))).clone(namedValues=NamedValues(("up", 1), ("down", 2)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipv4InterfaceEnableStatus.setStatus('current')
if mibBuilder.loadTexts: ipv4InterfaceEnableStatus.setDescription('The indication of whether IPv4 is enabled (up) or disabled (down) on this interface. This object does not affect the state of the interface itself, only its connection to an IPv4 stack. The IF-MIB should be used to control the state of the interface.')
ipv4InterfaceRetransmitTime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 28, 1, 4), Unsigned32().clone(1000)).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv4InterfaceRetransmitTime.setReference('RFC 1122')
if mibBuilder.loadTexts: ipv4InterfaceRetransmitTime.setStatus('current')
if mibBuilder.loadTexts: ipv4InterfaceRetransmitTime.setDescription('The time between retransmissions of ARP requests to a neighbor when resolving the address or when probing the reachability of a neighbor.')
ipv6InterfaceTableLastChange = MibScalar((1, 3, 6, 1, 2, 1, 4, 29), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6InterfaceTableLastChange.setStatus('current')
if mibBuilder.loadTexts: ipv6InterfaceTableLastChange.setDescription('The value of sysUpTime on the most recent occasion at which a row in the ipv6InterfaceTable was added or deleted or when an ipv6InterfaceReasmMaxSize, ipv6InterfaceIdentifier, ipv6InterfaceEnableStatus, ipv6InterfaceReachableTime, ipv6InterfaceRetransmitTime, or ipv6InterfaceForwarding object was modified. If new objects are added to the ipv6InterfaceTable that require the ipv6InterfaceTableLastChange to be updated when they are modified, they must specify that requirement in their description clause.')
ipv6InterfaceTable = MibTable((1, 3, 6, 1, 2, 1, 4, 30), )
if mibBuilder.loadTexts: ipv6InterfaceTable.setStatus('current')
if mibBuilder.loadTexts: ipv6InterfaceTable.setDescription('The table containing per-interface IPv6-specific information.')
ipv6InterfaceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 30, 1), ).setIndexNames((0, "IP-MIB", "ipv6InterfaceIfIndex"))
if mibBuilder.loadTexts: ipv6InterfaceEntry.setStatus('current')
if mibBuilder.loadTexts: ipv6InterfaceEntry.setDescription('An entry containing IPv6-specific information for a given interface.')
ipv6InterfaceIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 30, 1, 1), InterfaceIndex())
if mibBuilder.loadTexts: ipv6InterfaceIfIndex.setStatus('current')
if mibBuilder.loadTexts: ipv6InterfaceIfIndex.setDescription("The index value that uniquely identifies the interface to which this entry is applicable. The interface identified by a particular value of this index is the same interface as identified by the same value of the IF-MIB's ifIndex.")
ipv6InterfaceReasmMaxSize = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 30, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1500, 65535))).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6InterfaceReasmMaxSize.setStatus('current')
if mibBuilder.loadTexts: ipv6InterfaceReasmMaxSize.setDescription('The size of the largest IPv6 datagram that this entity can re-assemble from incoming IPv6 fragmented datagrams received on this interface.')
ipv6InterfaceIdentifier = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 30, 1, 3), Ipv6AddressIfIdentifierTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6InterfaceIdentifier.setStatus('current')
if mibBuilder.loadTexts: ipv6InterfaceIdentifier.setDescription('The Interface Identifier for this interface. The Interface Identifier is combined with an address prefix to form an interface address. By default, the Interface Identifier is auto-configured according to the rules of the link type to which this interface is attached. A zero length identifier may be used where appropriate. One possible example is a loopback interface.')
ipv6InterfaceEnableStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 30, 1, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2))).clone(namedValues=NamedValues(("up", 1), ("down", 2)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipv6InterfaceEnableStatus.setStatus('current')
if mibBuilder.loadTexts: ipv6InterfaceEnableStatus.setDescription('The indication of whether IPv6 is enabled (up) or disabled (down) on this interface. This object does not affect the state of the interface itself, only its connection to an IPv6 stack. The IF-MIB should be used to control the state of the interface. When this object is written, the entity SHOULD save the change to non-volatile storage and restore the object from non-volatile storage upon re-initialization of the system.')
ipv6InterfaceReachableTime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 30, 1, 6), Unsigned32()).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6InterfaceReachableTime.setReference('RFC 2461, Section 6.3.2')
if mibBuilder.loadTexts: ipv6InterfaceReachableTime.setStatus('current')
if mibBuilder.loadTexts: ipv6InterfaceReachableTime.setDescription('The time a neighbor is considered reachable after receiving a reachability confirmation.')
ipv6InterfaceRetransmitTime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 30, 1, 7), Unsigned32()).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6InterfaceRetransmitTime.setReference('RFC 2461, Section 6.3.2')
if mibBuilder.loadTexts: ipv6InterfaceRetransmitTime.setStatus('current')
if mibBuilder.loadTexts: ipv6InterfaceRetransmitTime.setDescription('The time between retransmissions of Neighbor Solicitation messages to a neighbor when resolving the address or when probing the reachability of a neighbor.')
ipv6InterfaceForwarding = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 30, 1, 8), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2))).clone(namedValues=NamedValues(("forwarding", 1), ("notForwarding", 2)))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipv6InterfaceForwarding.setStatus('current')
if mibBuilder.loadTexts: ipv6InterfaceForwarding.setDescription('The indication of whether this entity is acting as an IPv6 router on this interface with respect to the forwarding of datagrams received by, but not addressed to, this entity. IPv6 routers forward datagrams. IPv6 hosts do not (except those source-routed via the host). This object is constrained by ipv6IpForwarding and is ignored if ipv6IpForwarding is set to notForwarding. Those systems that do not provide per-interface control of the forwarding function should set this object to forwarding for all interfaces and allow the ipv6IpForwarding object to control the forwarding capability. When this object is written, the entity SHOULD save the change to non-volatile storage and restore the object from non-volatile storage upon re-initialization of the system.')
ipTrafficStats = MibIdentifier((1, 3, 6, 1, 2, 1, 4, 31))
ipSystemStatsTable = MibTable((1, 3, 6, 1, 2, 1, 4, 31, 1), )
if mibBuilder.loadTexts: ipSystemStatsTable.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsTable.setDescription('The table containing system wide, IP version specific traffic statistics. This table and the ipIfStatsTable contain similar objects whose difference is in their granularity. Where this table contains system wide traffic statistics, the ipIfStatsTable contains the same statistics but counted on a per-interface basis.')
ipSystemStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 31, 1, 1), ).setIndexNames((0, "IP-MIB", "ipSystemStatsIPVersion"))
if mibBuilder.loadTexts: ipSystemStatsEntry.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsEntry.setDescription('A statistics entry containing system-wide objects for a particular IP version.')
ipSystemStatsIPVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 1), InetVersion())
if mibBuilder.loadTexts: ipSystemStatsIPVersion.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsIPVersion.setDescription('The IP version of this row.')
ipSystemStatsInReceives = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInReceives.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsInReceives.setDescription('The total number of input IP datagrams received, including those received in error. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsHCInReceives = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 4), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCInReceives.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsHCInReceives.setDescription('The total number of input IP datagrams received, including those received in error. This object counts the same datagrams as ipSystemStatsInReceives, but allows for larger values. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInOctets.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsInOctets.setDescription('The total number of octets received in input IP datagrams, including those received in error. Octets from datagrams counted in ipSystemStatsInReceives MUST be counted here. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsHCInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 6), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCInOctets.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsHCInOctets.setDescription('The total number of octets received in input IP datagrams, including those received in error. This object counts the same octets as ipSystemStatsInOctets, but allows for larger values. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsInHdrErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInHdrErrors.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsInHdrErrors.setDescription('The number of input IP datagrams discarded due to errors in their IP headers, including version number mismatch, other format errors, hop count exceeded, errors discovered in processing their IP options, etc. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsInNoRoutes = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInNoRoutes.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsInNoRoutes.setDescription('The number of input IP datagrams discarded because no route could be found to transmit them to their destination. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsInAddrErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInAddrErrors.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsInAddrErrors.setDescription("The number of input IP datagrams discarded because the IP address in their IP header's destination field was not a valid address to be received at this entity. This count includes invalid addresses (e.g., ::0). For entities that are not IP routers and therefore do not forward datagrams, this counter includes datagrams discarded because the destination address was not a local address. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.")
ipSystemStatsInUnknownProtos = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInUnknownProtos.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsInUnknownProtos.setDescription('The number of locally-addressed IP datagrams received successfully but discarded because of an unknown or unsupported protocol. When tracking interface statistics, the counter of the interface to which these datagrams were addressed is incremented. This interface might not be the same as the input interface for some of the datagrams. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsInTruncatedPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInTruncatedPkts.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsInTruncatedPkts.setDescription("The number of input IP datagrams discarded because the datagram frame didn't carry enough data. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.")
ipSystemStatsInForwDatagrams = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInForwDatagrams.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsInForwDatagrams.setDescription('The number of input datagrams for which this entity was not their final IP destination and for which this entity attempted to find a route to forward them to that final destination. In entities that do not act as IP routers, this counter will include only those datagrams that were Source-Routed via this entity, and the Source-Route processing was successful. When tracking interface statistics, the counter of the incoming interface is incremented for each datagram. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsHCInForwDatagrams = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 13), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCInForwDatagrams.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsHCInForwDatagrams.setDescription('The number of input datagrams for which this entity was not their final IP destination and for which this entity attempted to find a route to forward them to that final destination. This object counts the same packets as ipSystemStatsInForwDatagrams, but allows for larger values. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsReasmReqds = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsReasmReqds.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsReasmReqds.setDescription('The number of IP fragments received that needed to be reassembled at this interface. When tracking interface statistics, the counter of the interface to which these fragments were addressed is incremented. This interface might not be the same as the input interface for some of the fragments. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsReasmOKs = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsReasmOKs.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsReasmOKs.setDescription('The number of IP datagrams successfully reassembled. When tracking interface statistics, the counter of the interface to which these datagrams were addressed is incremented. This interface might not be the same as the input interface for some of the datagrams. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsReasmFails = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsReasmFails.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsReasmFails.setDescription('The number of failures detected by the IP re-assembly algorithm (for whatever reason: timed out, errors, etc.). Note that this is not necessarily a count of discarded IP fragments since some algorithms (notably the algorithm in RFC 815) can lose track of the number of fragments by combining them as they are received. When tracking interface statistics, the counter of the interface to which these fragments were addressed is incremented. This interface might not be the same as the input interface for some of the fragments. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsInDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInDiscards.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsInDiscards.setDescription('The number of input IP datagrams for which no problems were encountered to prevent their continued processing, but were discarded (e.g., for lack of buffer space). Note that this counter does not include any datagrams discarded while awaiting re-assembly. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsInDelivers = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInDelivers.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsInDelivers.setDescription('The total number of datagrams successfully delivered to IP user-protocols (including ICMP). When tracking interface statistics, the counter of the interface to which these datagrams were addressed is incremented. This interface might not be the same as the input interface for some of the datagrams. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsHCInDelivers = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 19), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCInDelivers.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsHCInDelivers.setDescription('The total number of datagrams successfully delivered to IP user-protocols (including ICMP). This object counts the same packets as ipSystemStatsInDelivers, but allows for larger values. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsOutRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutRequests.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsOutRequests.setDescription('The total number of IP datagrams that local IP user- protocols (including ICMP) supplied to IP in requests for transmission. Note that this counter does not include any datagrams counted in ipSystemStatsOutForwDatagrams. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsHCOutRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 21), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCOutRequests.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsHCOutRequests.setDescription('The total number of IP datagrams that local IP user- protocols (including ICMP) supplied to IP in requests for transmission. This object counts the same packets as ipSystemStatsOutRequests, but allows for larger values. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsOutNoRoutes = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 22), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutNoRoutes.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsOutNoRoutes.setDescription('The number of locally generated IP datagrams discarded because no route could be found to transmit them to their destination. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsOutForwDatagrams = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutForwDatagrams.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsOutForwDatagrams.setDescription('The number of datagrams for which this entity was not their final IP destination and for which it was successful in finding a path to their final destination. In entities that do not act as IP routers, this counter will include only those datagrams that were Source-Routed via this entity, and the Source-Route processing was successful. When tracking interface statistics, the counter of the outgoing interface is incremented for a successfully forwarded datagram. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsHCOutForwDatagrams = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 24), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCOutForwDatagrams.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsHCOutForwDatagrams.setDescription('The number of datagrams for which this entity was not their final IP destination and for which it was successful in finding a path to their final destination. This object counts the same packets as ipSystemStatsOutForwDatagrams, but allows for larger values. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsOutDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 25), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutDiscards.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsOutDiscards.setDescription('The number of output IP datagrams for which no problem was encountered to prevent their transmission to their destination, but were discarded (e.g., for lack of buffer space). Note that this counter would include datagrams counted in ipSystemStatsOutForwDatagrams if any such datagrams met this (discretionary) discard criterion. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsOutFragReqds = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 26), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutFragReqds.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsOutFragReqds.setDescription('The number of IP datagrams that would require fragmentation in order to be transmitted. When tracking interface statistics, the counter of the outgoing interface is incremented for a successfully fragmented datagram. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsOutFragOKs = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 27), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutFragOKs.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsOutFragOKs.setDescription('The number of IP datagrams that have been successfully fragmented. When tracking interface statistics, the counter of the outgoing interface is incremented for a successfully fragmented datagram. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsOutFragFails = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 28), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutFragFails.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsOutFragFails.setDescription('The number of IP datagrams that have been discarded because they needed to be fragmented but could not be. This includes IPv4 packets that have the DF bit set and IPv6 packets that are being forwarded and exceed the outgoing link MTU. When tracking interface statistics, the counter of the outgoing interface is incremented for an unsuccessfully fragmented datagram. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsOutFragCreates = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 29), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutFragCreates.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsOutFragCreates.setDescription('The number of output datagram fragments that have been generated as a result of IP fragmentation. When tracking interface statistics, the counter of the outgoing interface is incremented for a successfully fragmented datagram. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsOutTransmits = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 30), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutTransmits.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsOutTransmits.setDescription('The total number of IP datagrams that this entity supplied to the lower layers for transmission. This includes datagrams generated locally and those forwarded by this entity. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsHCOutTransmits = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 31), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCOutTransmits.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsHCOutTransmits.setDescription('The total number of IP datagrams that this entity supplied to the lower layers for transmission. This object counts the same datagrams as ipSystemStatsOutTransmits, but allows for larger values. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 32), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutOctets.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsOutOctets.setDescription('The total number of octets in IP datagrams delivered to the lower layers for transmission. Octets from datagrams counted in ipSystemStatsOutTransmits MUST be counted here. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsHCOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 33), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCOutOctets.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsHCOutOctets.setDescription('The total number of octets in IP datagrams delivered to the lower layers for transmission. This objects counts the same octets as ipSystemStatsOutOctets, but allows for larger values. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsInMcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 34), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInMcastPkts.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsInMcastPkts.setDescription('The number of IP multicast datagrams received. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsHCInMcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 35), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCInMcastPkts.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsHCInMcastPkts.setDescription('The number of IP multicast datagrams received. This object counts the same datagrams as ipSystemStatsInMcastPkts but allows for larger values. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsInMcastOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 36), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInMcastOctets.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsInMcastOctets.setDescription('The total number of octets received in IP multicast datagrams. Octets from datagrams counted in ipSystemStatsInMcastPkts MUST be counted here. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsHCInMcastOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 37), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCInMcastOctets.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsHCInMcastOctets.setDescription('The total number of octets received in IP multicast datagrams. This object counts the same octets as ipSystemStatsInMcastOctets, but allows for larger values. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsOutMcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 38), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutMcastPkts.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsOutMcastPkts.setDescription('The number of IP multicast datagrams transmitted. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsHCOutMcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 39), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCOutMcastPkts.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsHCOutMcastPkts.setDescription('The number of IP multicast datagrams transmitted. This object counts the same datagrams as ipSystemStatsOutMcastPkts, but allows for larger values. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsOutMcastOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 40), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutMcastOctets.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsOutMcastOctets.setDescription('The total number of octets transmitted in IP multicast datagrams. Octets from datagrams counted in ipSystemStatsOutMcastPkts MUST be counted here. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsHCOutMcastOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 41), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCOutMcastOctets.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsHCOutMcastOctets.setDescription('The total number of octets transmitted in IP multicast datagrams. This object counts the same octets as ipSystemStatsOutMcastOctets, but allows for larger values. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsInBcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 42), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInBcastPkts.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsInBcastPkts.setDescription('The number of IP broadcast datagrams received. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsHCInBcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 43), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCInBcastPkts.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsHCInBcastPkts.setDescription('The number of IP broadcast datagrams received. This object counts the same datagrams as ipSystemStatsInBcastPkts but allows for larger values. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsOutBcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 44), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutBcastPkts.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsOutBcastPkts.setDescription('The number of IP broadcast datagrams transmitted. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsHCOutBcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 45), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCOutBcastPkts.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsHCOutBcastPkts.setDescription('The number of IP broadcast datagrams transmitted. This object counts the same datagrams as ipSystemStatsOutBcastPkts, but allows for larger values. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipSystemStatsDiscontinuityTime.')
ipSystemStatsDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 46), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsDiscontinuityTime.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion at which any one or more of this entry's counters suffered a discontinuity. If no such discontinuities have occurred since the last re- initialization of the local management subsystem, then this object contains a zero value.")
ipSystemStatsRefreshRate = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 47), Unsigned32()).setUnits('milli-seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsRefreshRate.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsRefreshRate.setDescription('The minimum reasonable polling interval for this entry. This object provides an indication of the minimum amount of time required to update the counters in this entry.')
ipIfStatsTableLastChange = MibScalar((1, 3, 6, 1, 2, 1, 4, 31, 2), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsTableLastChange.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsTableLastChange.setDescription('The value of sysUpTime on the most recent occasion at which a row in the ipIfStatsTable was added or deleted. If new objects are added to the ipIfStatsTable that require the ipIfStatsTableLastChange to be updated when they are modified, they must specify that requirement in their description clause.')
ipIfStatsTable = MibTable((1, 3, 6, 1, 2, 1, 4, 31, 3), )
if mibBuilder.loadTexts: ipIfStatsTable.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsTable.setDescription('The table containing per-interface traffic statistics. This table and the ipSystemStatsTable contain similar objects whose difference is in their granularity. Where this table contains per-interface statistics, the ipSystemStatsTable contains the same statistics, but counted on a system wide basis.')
ipIfStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 31, 3, 1), ).setIndexNames((0, "IP-MIB", "ipIfStatsIPVersion"), (0, "IP-MIB", "ipIfStatsIfIndex"))
if mibBuilder.loadTexts: ipIfStatsEntry.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsEntry.setDescription('An interface statistics entry containing objects for a particular interface and version of IP.')
ipIfStatsIPVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 1), InetVersion())
if mibBuilder.loadTexts: ipIfStatsIPVersion.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsIPVersion.setDescription('The IP version of this row.')
ipIfStatsIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 2), InterfaceIndex())
if mibBuilder.loadTexts: ipIfStatsIfIndex.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsIfIndex.setDescription("The index value that uniquely identifies the interface to which this entry is applicable. The interface identified by a particular value of this index is the same interface as identified by the same value of the IF-MIB's ifIndex.")
ipIfStatsInReceives = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInReceives.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsInReceives.setDescription('The total number of input IP datagrams received, including those received in error. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsHCInReceives = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 4), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCInReceives.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsHCInReceives.setDescription('The total number of input IP datagrams received, including those received in error. This object counts the same datagrams as ipIfStatsInReceives, but allows for larger values. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInOctets.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsInOctets.setDescription('The total number of octets received in input IP datagrams, including those received in error. Octets from datagrams counted in ipIfStatsInReceives MUST be counted here. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsHCInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 6), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCInOctets.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsHCInOctets.setDescription('The total number of octets received in input IP datagrams, including those received in error. This object counts the same octets as ipIfStatsInOctets, but allows for larger values. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsInHdrErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInHdrErrors.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsInHdrErrors.setDescription('The number of input IP datagrams discarded due to errors in their IP headers, including version number mismatch, other format errors, hop count exceeded, errors discovered in processing their IP options, etc. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsInNoRoutes = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInNoRoutes.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsInNoRoutes.setDescription('The number of input IP datagrams discarded because no route could be found to transmit them to their destination. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsInAddrErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInAddrErrors.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsInAddrErrors.setDescription("The number of input IP datagrams discarded because the IP address in their IP header's destination field was not a valid address to be received at this entity. This count includes invalid addresses (e.g., ::0). For entities that are not IP routers and therefore do not forward datagrams, this counter includes datagrams discarded because the destination address was not a local address. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.")
ipIfStatsInUnknownProtos = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInUnknownProtos.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsInUnknownProtos.setDescription('The number of locally-addressed IP datagrams received successfully but discarded because of an unknown or unsupported protocol. When tracking interface statistics, the counter of the interface to which these datagrams were addressed is incremented. This interface might not be the same as the input interface for some of the datagrams. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsInTruncatedPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInTruncatedPkts.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsInTruncatedPkts.setDescription("The number of input IP datagrams discarded because the datagram frame didn't carry enough data. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.")
ipIfStatsInForwDatagrams = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInForwDatagrams.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsInForwDatagrams.setDescription('The number of input datagrams for which this entity was not their final IP destination and for which this entity attempted to find a route to forward them to that final destination. In entities that do not act as IP routers, this counter will include only those datagrams that were Source-Routed via this entity, and the Source-Route processing was successful. When tracking interface statistics, the counter of the incoming interface is incremented for each datagram. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsHCInForwDatagrams = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 13), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCInForwDatagrams.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsHCInForwDatagrams.setDescription('The number of input datagrams for which this entity was not their final IP destination and for which this entity attempted to find a route to forward them to that final destination. This object counts the same packets as ipIfStatsInForwDatagrams, but allows for larger values. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsReasmReqds = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsReasmReqds.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsReasmReqds.setDescription('The number of IP fragments received that needed to be reassembled at this interface. When tracking interface statistics, the counter of the interface to which these fragments were addressed is incremented. This interface might not be the same as the input interface for some of the fragments. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsReasmOKs = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsReasmOKs.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsReasmOKs.setDescription('The number of IP datagrams successfully reassembled. When tracking interface statistics, the counter of the interface to which these datagrams were addressed is incremented. This interface might not be the same as the input interface for some of the datagrams. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsReasmFails = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsReasmFails.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsReasmFails.setDescription('The number of failures detected by the IP re-assembly algorithm (for whatever reason: timed out, errors, etc.). Note that this is not necessarily a count of discarded IP fragments since some algorithms (notably the algorithm in RFC 815) can lose track of the number of fragments by combining them as they are received. When tracking interface statistics, the counter of the interface to which these fragments were addressed is incremented. This interface might not be the same as the input interface for some of the fragments. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsInDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInDiscards.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsInDiscards.setDescription('The number of input IP datagrams for which no problems were encountered to prevent their continued processing, but were discarded (e.g., for lack of buffer space). Note that this counter does not include any datagrams discarded while awaiting re-assembly. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsInDelivers = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInDelivers.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsInDelivers.setDescription('The total number of datagrams successfully delivered to IP user-protocols (including ICMP). When tracking interface statistics, the counter of the interface to which these datagrams were addressed is incremented. This interface might not be the same as the input interface for some of the datagrams. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsHCInDelivers = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 19), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCInDelivers.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsHCInDelivers.setDescription('The total number of datagrams successfully delivered to IP user-protocols (including ICMP). This object counts the same packets as ipIfStatsInDelivers, but allows for larger values. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsOutRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutRequests.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsOutRequests.setDescription('The total number of IP datagrams that local IP user- protocols (including ICMP) supplied to IP in requests for transmission. Note that this counter does not include any datagrams counted in ipIfStatsOutForwDatagrams. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsHCOutRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 21), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCOutRequests.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsHCOutRequests.setDescription('The total number of IP datagrams that local IP user- protocols (including ICMP) supplied to IP in requests for transmission. This object counts the same packets as ipIfStatsOutRequests, but allows for larger values. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsOutForwDatagrams = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutForwDatagrams.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsOutForwDatagrams.setDescription('The number of datagrams for which this entity was not their final IP destination and for which it was successful in finding a path to their final destination. In entities that do not act as IP routers, this counter will include only those datagrams that were Source-Routed via this entity, and the Source-Route processing was successful. When tracking interface statistics, the counter of the outgoing interface is incremented for a successfully forwarded datagram. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsHCOutForwDatagrams = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 24), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCOutForwDatagrams.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsHCOutForwDatagrams.setDescription('The number of datagrams for which this entity was not their final IP destination and for which it was successful in finding a path to their final destination. This object counts the same packets as ipIfStatsOutForwDatagrams, but allows for larger values. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsOutDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 25), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutDiscards.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsOutDiscards.setDescription('The number of output IP datagrams for which no problem was encountered to prevent their transmission to their destination, but were discarded (e.g., for lack of buffer space). Note that this counter would include datagrams counted in ipIfStatsOutForwDatagrams if any such datagrams met this (discretionary) discard criterion. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsOutFragReqds = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 26), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutFragReqds.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsOutFragReqds.setDescription('The number of IP datagrams that would require fragmentation in order to be transmitted. When tracking interface statistics, the counter of the outgoing interface is incremented for a successfully fragmented datagram. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsOutFragOKs = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 27), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutFragOKs.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsOutFragOKs.setDescription('The number of IP datagrams that have been successfully fragmented. When tracking interface statistics, the counter of the outgoing interface is incremented for a successfully fragmented datagram. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsOutFragFails = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 28), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutFragFails.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsOutFragFails.setDescription('The number of IP datagrams that have been discarded because they needed to be fragmented but could not be. This includes IPv4 packets that have the DF bit set and IPv6 packets that are being forwarded and exceed the outgoing link MTU. When tracking interface statistics, the counter of the outgoing interface is incremented for an unsuccessfully fragmented datagram. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsOutFragCreates = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 29), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutFragCreates.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsOutFragCreates.setDescription('The number of output datagram fragments that have been generated as a result of IP fragmentation. When tracking interface statistics, the counter of the outgoing interface is incremented for a successfully fragmented datagram. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsOutTransmits = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 30), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutTransmits.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsOutTransmits.setDescription('The total number of IP datagrams that this entity supplied to the lower layers for transmission. This includes datagrams generated locally and those forwarded by this entity. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsHCOutTransmits = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 31), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCOutTransmits.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsHCOutTransmits.setDescription('The total number of IP datagrams that this entity supplied to the lower layers for transmission. This object counts the same datagrams as ipIfStatsOutTransmits, but allows for larger values. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 32), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutOctets.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsOutOctets.setDescription('The total number of octets in IP datagrams delivered to the lower layers for transmission. Octets from datagrams counted in ipIfStatsOutTransmits MUST be counted here. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsHCOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 33), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCOutOctets.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsHCOutOctets.setDescription('The total number of octets in IP datagrams delivered to the lower layers for transmission. This objects counts the same octets as ipIfStatsOutOctets, but allows for larger values. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsInMcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 34), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInMcastPkts.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsInMcastPkts.setDescription('The number of IP multicast datagrams received. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsHCInMcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 35), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCInMcastPkts.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsHCInMcastPkts.setDescription('The number of IP multicast datagrams received. This object counts the same datagrams as ipIfStatsInMcastPkts, but allows for larger values. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsInMcastOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 36), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInMcastOctets.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsInMcastOctets.setDescription('The total number of octets received in IP multicast datagrams. Octets from datagrams counted in ipIfStatsInMcastPkts MUST be counted here. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsHCInMcastOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 37), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCInMcastOctets.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsHCInMcastOctets.setDescription('The total number of octets received in IP multicast datagrams. This object counts the same octets as ipIfStatsInMcastOctets, but allows for larger values. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsOutMcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 38), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutMcastPkts.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsOutMcastPkts.setDescription('The number of IP multicast datagrams transmitted. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsHCOutMcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 39), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCOutMcastPkts.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsHCOutMcastPkts.setDescription('The number of IP multicast datagrams transmitted. This object counts the same datagrams as ipIfStatsOutMcastPkts, but allows for larger values. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsOutMcastOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 40), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutMcastOctets.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsOutMcastOctets.setDescription('The total number of octets transmitted in IP multicast datagrams. Octets from datagrams counted in ipIfStatsOutMcastPkts MUST be counted here. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsHCOutMcastOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 41), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCOutMcastOctets.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsHCOutMcastOctets.setDescription('The total number of octets transmitted in IP multicast datagrams. This object counts the same octets as ipIfStatsOutMcastOctets, but allows for larger values. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsInBcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 42), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInBcastPkts.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsInBcastPkts.setDescription('The number of IP broadcast datagrams received. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsHCInBcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 43), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCInBcastPkts.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsHCInBcastPkts.setDescription('The number of IP broadcast datagrams received. This object counts the same datagrams as ipIfStatsInBcastPkts, but allows for larger values. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsOutBcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 44), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutBcastPkts.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsOutBcastPkts.setDescription('The number of IP broadcast datagrams transmitted. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsHCOutBcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 45), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCOutBcastPkts.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsHCOutBcastPkts.setDescription('The number of IP broadcast datagrams transmitted. This object counts the same datagrams as ipIfStatsOutBcastPkts, but allows for larger values. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ipIfStatsDiscontinuityTime.')
ipIfStatsDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 46), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsDiscontinuityTime.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion at which any one or more of this entry's counters suffered a discontinuity. If no such discontinuities have occurred since the last re- initialization of the local management subsystem, then this object contains a zero value.")
ipIfStatsRefreshRate = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 47), Unsigned32()).setUnits('milli-seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsRefreshRate.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsRefreshRate.setDescription('The minimum reasonable polling interval for this entry. This object provides an indication of the minimum amount of time required to update the counters in this entry.')
ipAddressPrefixTable = MibTable((1, 3, 6, 1, 2, 1, 4, 32), )
if mibBuilder.loadTexts: ipAddressPrefixTable.setStatus('current')
if mibBuilder.loadTexts: ipAddressPrefixTable.setDescription("This table allows the user to determine the source of an IP address or set of IP addresses, and allows other tables to share the information via pointer rather than by copying. For example, when the node configures both a unicast and anycast address for a prefix, the ipAddressPrefix objects for those addresses will point to a single row in this table. This table primarily provides support for IPv6 prefixes, and several of the objects are less meaningful for IPv4. The table continues to allow IPv4 addresses to allow future flexibility. In order to promote a common configuration, this document includes suggestions for default values for IPv4 prefixes. Each of these values may be overridden if an object is meaningful to the node. All prefixes used by this entity should be included in this table independent of how the entity learned the prefix. (This table isn't limited to prefixes learned from router advertisements.)")
ipAddressPrefixEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 32, 1), ).setIndexNames((0, "IP-MIB", "ipAddressPrefixIfIndex"), (0, "IP-MIB", "ipAddressPrefixType"), (0, "IP-MIB", "ipAddressPrefixPrefix"), (0, "IP-MIB", "ipAddressPrefixLength"))
if mibBuilder.loadTexts: ipAddressPrefixEntry.setStatus('current')
if mibBuilder.loadTexts: ipAddressPrefixEntry.setDescription('An entry in the ipAddressPrefixTable.')
ipAddressPrefixIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 32, 1, 1), InterfaceIndex())
if mibBuilder.loadTexts: ipAddressPrefixIfIndex.setStatus('current')
if mibBuilder.loadTexts: ipAddressPrefixIfIndex.setDescription("The index value that uniquely identifies the interface on which this prefix is configured. The interface identified by a particular value of this index is the same interface as identified by the same value of the IF-MIB's ifIndex.")
ipAddressPrefixType = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 32, 1, 2), InetAddressType())
if mibBuilder.loadTexts: ipAddressPrefixType.setStatus('current')
if mibBuilder.loadTexts: ipAddressPrefixType.setDescription('The address type of ipAddressPrefix.')
ipAddressPrefixPrefix = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 32, 1, 3), InetAddress())
if mibBuilder.loadTexts: ipAddressPrefixPrefix.setStatus('current')
if mibBuilder.loadTexts: ipAddressPrefixPrefix.setDescription('The address prefix. The address type of this object is specified in ipAddressPrefixType. The length of this object is the standard length for objects of that type (4 or 16 bytes). Any bits after ipAddressPrefixLength must be zero. Implementors need to be aware that, if the size of ipAddressPrefixPrefix exceeds 114 octets, then OIDS of instances of columns in this row will have more than 128 sub-identifiers and cannot be accessed using SNMPv1, SNMPv2c, or SNMPv3.')
ipAddressPrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 32, 1, 4), InetAddressPrefixLength())
if mibBuilder.loadTexts: ipAddressPrefixLength.setStatus('current')
if mibBuilder.loadTexts: ipAddressPrefixLength.setDescription("The prefix length associated with this prefix. The value 0 has no special meaning for this object. It simply refers to address '::/0'.")
ipAddressPrefixOrigin = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 32, 1, 5), IpAddressPrefixOriginTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAddressPrefixOrigin.setStatus('current')
if mibBuilder.loadTexts: ipAddressPrefixOrigin.setDescription('The origin of this prefix.')
ipAddressPrefixOnLinkFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 32, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAddressPrefixOnLinkFlag.setReference('For IPv6 RFC 2461, especially sections 2 and 4.6.2 and RFC 2462')
if mibBuilder.loadTexts: ipAddressPrefixOnLinkFlag.setStatus('current')
if mibBuilder.loadTexts: ipAddressPrefixOnLinkFlag.setDescription("This object has the value 'true(1)', if this prefix can be used for on-link determination; otherwise, the value is 'false(2)'. The default for IPv4 prefixes is 'true(1)'.")
ipAddressPrefixAutonomousFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 32, 1, 7), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAddressPrefixAutonomousFlag.setReference('For IPv6 RFC 2461, especially sections 2 and 4.6.2 and RFC 2462')
if mibBuilder.loadTexts: ipAddressPrefixAutonomousFlag.setStatus('current')
if mibBuilder.loadTexts: ipAddressPrefixAutonomousFlag.setDescription("Autonomous address configuration flag. When true(1), indicates that this prefix can be used for autonomous address configuration (i.e., can be used to form a local interface address). If false(2), it is not used to auto- configure a local interface address. The default for IPv4 prefixes is 'false(2)'.")
ipAddressPrefixAdvPreferredLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 32, 1, 8), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAddressPrefixAdvPreferredLifetime.setReference('For IPv6 RFC 2461, especially sections 2 and 4.6.2 and RFC 2462')
if mibBuilder.loadTexts: ipAddressPrefixAdvPreferredLifetime.setStatus('current')
if mibBuilder.loadTexts: ipAddressPrefixAdvPreferredLifetime.setDescription('The remaining length of time, in seconds, that this prefix will continue to be preferred, i.e., time until deprecation. A value of 4,294,967,295 represents infinity. The address generated from a deprecated prefix should no longer be used as a source address in new communications, but packets received on such an interface are processed as expected. The default for IPv4 prefixes is 4,294,967,295 (infinity).')
ipAddressPrefixAdvValidLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 32, 1, 9), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAddressPrefixAdvValidLifetime.setReference('For IPv6 RFC 2461, especially sections 2 and 4.6.2 and RFC 2462')
if mibBuilder.loadTexts: ipAddressPrefixAdvValidLifetime.setStatus('current')
if mibBuilder.loadTexts: ipAddressPrefixAdvValidLifetime.setDescription('The remaining length of time, in seconds, that this prefix will continue to be valid, i.e., time until invalidation. A value of 4,294,967,295 represents infinity. The address generated from an invalidated prefix should not appear as the destination or source address of a packet. The default for IPv4 prefixes is 4,294,967,295 (infinity).')
ipAddressSpinLock = MibScalar((1, 3, 6, 1, 2, 1, 4, 33), TestAndIncr()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipAddressSpinLock.setStatus('current')
if mibBuilder.loadTexts: ipAddressSpinLock.setDescription("An advisory lock used to allow cooperating SNMP managers to coordinate their use of the set operation in creating or modifying rows within this table. In order to use this lock to coordinate the use of set operations, managers should first retrieve ipAddressTableSpinLock. They should then determine the appropriate row to create or modify. Finally, they should issue the appropriate set command, including the retrieved value of ipAddressSpinLock. If another manager has altered the table in the meantime, then the value of ipAddressSpinLock will have changed, and the creation will fail as it will be specifying an incorrect value for ipAddressSpinLock. It is suggested, but not required, that the ipAddressSpinLock be the first var bind for each set of objects representing a 'row' in a PDU.")
ipAddressTable = MibTable((1, 3, 6, 1, 2, 1, 4, 34), )
if mibBuilder.loadTexts: ipAddressTable.setStatus('current')
if mibBuilder.loadTexts: ipAddressTable.setDescription("This table contains addressing information relevant to the entity's interfaces. This table does not contain multicast address information. Tables for such information should be contained in multicast specific MIBs, such as RFC 3019. While this table is writable, the user will note that several objects, such as ipAddressOrigin, are not. The intention in allowing a user to write to this table is to allow them to add or remove any entry that isn't permanent. The user should be allowed to modify objects and entries when that would not cause inconsistencies within the table. Allowing write access to objects, such as ipAddressOrigin, could allow a user to insert an entry and then label it incorrectly. Note well: When including IPv6 link-local addresses in this table, the entry must use an InetAddressType of 'ipv6z' in order to differentiate between the possible interfaces.")
ipAddressEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 34, 1), ).setIndexNames((0, "IP-MIB", "ipAddressAddrType"), (0, "IP-MIB", "ipAddressAddr"))
if mibBuilder.loadTexts: ipAddressEntry.setStatus('current')
if mibBuilder.loadTexts: ipAddressEntry.setDescription('An address mapping for a particular interface.')
ipAddressAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 1), InetAddressType())
if mibBuilder.loadTexts: ipAddressAddrType.setStatus('current')
if mibBuilder.loadTexts: ipAddressAddrType.setDescription('The address type of ipAddressAddr.')
ipAddressAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 2), InetAddress())
if mibBuilder.loadTexts: ipAddressAddr.setStatus('current')
if mibBuilder.loadTexts: ipAddressAddr.setDescription("The IP address to which this entry's addressing information pertains. The address type of this object is specified in ipAddressAddrType. Implementors need to be aware that if the size of ipAddressAddr exceeds 116 octets, then OIDS of instances of columns in this row will have more than 128 sub-identifiers and cannot be accessed using SNMPv1, SNMPv2c, or SNMPv3.")
ipAddressIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 3), InterfaceIndex()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipAddressIfIndex.setStatus('current')
if mibBuilder.loadTexts: ipAddressIfIndex.setDescription("The index value that uniquely identifies the interface to which this entry is applicable. The interface identified by a particular value of this index is the same interface as identified by the same value of the IF-MIB's ifIndex.")
ipAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3))).clone(namedValues=NamedValues(("unicast", 1), ("anycast", 2), ("broadcast", 3))).clone('unicast')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipAddressType.setStatus('current')
if mibBuilder.loadTexts: ipAddressType.setDescription('The type of address. broadcast(3) is not a valid value for IPv6 addresses (RFC 3513).')
ipAddressPrefix = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 5), RowPointer().clone((0, 0))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAddressPrefix.setStatus('current')
if mibBuilder.loadTexts: ipAddressPrefix.setDescription('A pointer to the row in the prefix table to which this address belongs. May be { 0 0 } if there is no such row.')
ipAddressOrigin = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 6), IpAddressOriginTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAddressOrigin.setStatus('current')
if mibBuilder.loadTexts: ipAddressOrigin.setDescription('The origin of the address.')
ipAddressStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 7), IpAddressStatusTC().clone('preferred')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipAddressStatus.setStatus('current')
if mibBuilder.loadTexts: ipAddressStatus.setDescription('The status of the address, describing if the address can be used for communication. In the absence of other information, an IPv4 address is always preferred(1).')
ipAddressCreated = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 8), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAddressCreated.setStatus('current')
if mibBuilder.loadTexts: ipAddressCreated.setDescription('The value of sysUpTime at the time this entry was created. If this entry was created prior to the last re- initialization of the local network management subsystem, then this object contains a zero value.')
ipAddressLastChanged = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 9), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAddressLastChanged.setStatus('current')
if mibBuilder.loadTexts: ipAddressLastChanged.setDescription('The value of sysUpTime at the time this entry was last updated. If this entry was updated prior to the last re- initialization of the local network management subsystem, then this object contains a zero value.')
ipAddressRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 10), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipAddressRowStatus.setStatus('current')
if mibBuilder.loadTexts: ipAddressRowStatus.setDescription('The status of this conceptual row. The RowStatus TC requires that this DESCRIPTION clause states under which circumstances other objects in this row can be modified. The value of this object has no effect on whether other objects in this conceptual row can be modified. A conceptual row can not be made active until the ipAddressIfIndex has been set to a valid index.')
ipAddressStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 11), StorageType().clone('volatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipAddressStorageType.setStatus('current')
if mibBuilder.loadTexts: ipAddressStorageType.setDescription("The storage type for this conceptual row. If this object has a value of 'permanent', then no other objects are required to be able to be modified.")
ipNetToPhysicalTable = MibTable((1, 3, 6, 1, 2, 1, 4, 35), )
if mibBuilder.loadTexts: ipNetToPhysicalTable.setReference('RFC 826 and RFC 2461')
if mibBuilder.loadTexts: ipNetToPhysicalTable.setStatus('current')
if mibBuilder.loadTexts: ipNetToPhysicalTable.setDescription("The IP Address Translation table used for mapping from IP addresses to physical addresses. The Address Translation tables contain the IP address to 'physical' address equivalences. Some interfaces do not use translation tables for determining address equivalences (e.g., DDN-X.25 has an algorithmic method); if all interfaces are of this type, then the Address Translation table is empty, i.e., has zero entries. While many protocols may be used to populate this table, ARP and Neighbor Discovery are the most likely options.")
ipNetToPhysicalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 35, 1), ).setIndexNames((0, "IP-MIB", "ipNetToPhysicalIfIndex"), (0, "IP-MIB", "ipNetToPhysicalNetAddressType"), (0, "IP-MIB", "ipNetToPhysicalNetAddress"))
if mibBuilder.loadTexts: ipNetToPhysicalEntry.setStatus('current')
if mibBuilder.loadTexts: ipNetToPhysicalEntry.setDescription("Each entry contains one IP address to `physical' address equivalence.")
ipNetToPhysicalIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 35, 1, 1), InterfaceIndex())
if mibBuilder.loadTexts: ipNetToPhysicalIfIndex.setStatus('current')
if mibBuilder.loadTexts: ipNetToPhysicalIfIndex.setDescription("The index value that uniquely identifies the interface to which this entry is applicable. The interface identified by a particular value of this index is the same interface as identified by the same value of the IF-MIB's ifIndex.")
ipNetToPhysicalNetAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 35, 1, 2), InetAddressType())
if mibBuilder.loadTexts: ipNetToPhysicalNetAddressType.setStatus('current')
if mibBuilder.loadTexts: ipNetToPhysicalNetAddressType.setDescription('The type of ipNetToPhysicalNetAddress.')
ipNetToPhysicalNetAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 35, 1, 3), InetAddress())
if mibBuilder.loadTexts: ipNetToPhysicalNetAddress.setStatus('current')
if mibBuilder.loadTexts: ipNetToPhysicalNetAddress.setDescription("The IP Address corresponding to the media-dependent `physical' address. The address type of this object is specified in ipNetToPhysicalAddressType. Implementors need to be aware that if the size of ipNetToPhysicalNetAddress exceeds 115 octets, then OIDS of instances of columns in this row will have more than 128 sub-identifiers and cannot be accessed using SNMPv1, SNMPv2c, or SNMPv3.")
ipNetToPhysicalPhysAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 35, 1, 4), PhysAddress().subtype(subtypeSpec=ValueSizeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipNetToPhysicalPhysAddress.setStatus('current')
if mibBuilder.loadTexts: ipNetToPhysicalPhysAddress.setDescription("The media-dependent `physical' address. As the entries in this table are typically not persistent when this object is written the entity SHOULD NOT save the change to non-volatile storage.")
ipNetToPhysicalLastUpdated = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 35, 1, 5), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipNetToPhysicalLastUpdated.setStatus('current')
if mibBuilder.loadTexts: ipNetToPhysicalLastUpdated.setDescription('The value of sysUpTime at the time this entry was last updated. If this entry was updated prior to the last re- initialization of the local network management subsystem, then this object contains a zero value.')
ipNetToPhysicalType = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 35, 1, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5))).clone(namedValues=NamedValues(("other", 1), ("invalid", 2), ("dynamic", 3), ("static", 4), ("local", 5))).clone('static')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipNetToPhysicalType.setStatus('current')
if mibBuilder.loadTexts: ipNetToPhysicalType.setDescription("The type of mapping. Setting this object to the value invalid(2) has the effect of invalidating the corresponding entry in the ipNetToPhysicalTable. That is, it effectively dis- associates the interface identified with said entry from the mapping identified with said entry. It is an implementation-specific matter as to whether the agent removes an invalidated entry from the table. Accordingly, management stations must be prepared to receive tabular information from agents that corresponds to entries not currently in use. Proper interpretation of such entries requires examination of the relevant ipNetToPhysicalType object. The 'dynamic(3)' type indicates that the IP address to physical addresses mapping has been dynamically resolved using e.g., IPv4 ARP or the IPv6 Neighbor Discovery protocol. The 'static(4)' type indicates that the mapping has been statically configured. Both of these refer to entries that provide mappings for other entities addresses. The 'local(5)' type indicates that the mapping is provided for an entity's own interface address. As the entries in this table are typically not persistent when this object is written the entity SHOULD NOT save the change to non-volatile storage.")
ipNetToPhysicalState = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 35, 1, 7), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7))).clone(namedValues=NamedValues(("reachable", 1), ("stale", 2), ("delay", 3), ("probe", 4), ("invalid", 5), ("unknown", 6), ("incomplete", 7)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipNetToPhysicalState.setReference('RFC 2461')
if mibBuilder.loadTexts: ipNetToPhysicalState.setStatus('current')
if mibBuilder.loadTexts: ipNetToPhysicalState.setDescription('The Neighbor Unreachability Detection state for the interface when the address mapping in this entry is used. If Neighbor Unreachability Detection is not in use (e.g. for IPv4), this object is always unknown(6).')
ipNetToPhysicalRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 35, 1, 8), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipNetToPhysicalRowStatus.setStatus('current')
if mibBuilder.loadTexts: ipNetToPhysicalRowStatus.setDescription("The status of this conceptual row. The RowStatus TC requires that this DESCRIPTION clause states under which circumstances other objects in this row can be modified. The value of this object has no effect on whether other objects in this conceptual row can be modified. A conceptual row can not be made active until the ipNetToPhysicalPhysAddress object has been set. Note that if the ipNetToPhysicalType is set to 'invalid', the managed node may delete the entry independent of the state of this object.")
ipv6ScopeZoneIndexTable = MibTable((1, 3, 6, 1, 2, 1, 4, 36), )
if mibBuilder.loadTexts: ipv6ScopeZoneIndexTable.setReference('Section 2.7 of RFC 4291')
if mibBuilder.loadTexts: ipv6ScopeZoneIndexTable.setStatus('current')
if mibBuilder.loadTexts: ipv6ScopeZoneIndexTable.setDescription('The table used to describe IPv6 unicast and multicast scope zones. For those objects that have names rather than numbers, the names were chosen to coincide with the names used in the IPv6 address architecture document. ')
ipv6ScopeZoneIndexEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 36, 1), ).setIndexNames((0, "IP-MIB", "ipv6ScopeZoneIndexIfIndex"))
if mibBuilder.loadTexts: ipv6ScopeZoneIndexEntry.setStatus('current')
if mibBuilder.loadTexts: ipv6ScopeZoneIndexEntry.setDescription('Each entry contains the list of scope identifiers on a given interface.')
ipv6ScopeZoneIndexIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 1), InterfaceIndex())
if mibBuilder.loadTexts: ipv6ScopeZoneIndexIfIndex.setStatus('current')
if mibBuilder.loadTexts: ipv6ScopeZoneIndexIfIndex.setDescription("The index value that uniquely identifies the interface to which these scopes belong. The interface identified by a particular value of this index is the same interface as identified by the same value of the IF-MIB's ifIndex.")
ipv6ScopeZoneIndexLinkLocal = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 2), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndexLinkLocal.setStatus('current')
if mibBuilder.loadTexts: ipv6ScopeZoneIndexLinkLocal.setDescription('The zone index for the link-local scope on this interface.')
ipv6ScopeZoneIndex3 = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 3), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndex3.setStatus('current')
if mibBuilder.loadTexts: ipv6ScopeZoneIndex3.setDescription('The zone index for scope 3 on this interface.')
ipv6ScopeZoneIndexAdminLocal = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 4), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndexAdminLocal.setStatus('current')
if mibBuilder.loadTexts: ipv6ScopeZoneIndexAdminLocal.setDescription('The zone index for the admin-local scope on this interface.')
ipv6ScopeZoneIndexSiteLocal = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 5), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndexSiteLocal.setStatus('current')
if mibBuilder.loadTexts: ipv6ScopeZoneIndexSiteLocal.setDescription('The zone index for the site-local scope on this interface.')
ipv6ScopeZoneIndex6 = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 6), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndex6.setStatus('current')
if mibBuilder.loadTexts: ipv6ScopeZoneIndex6.setDescription('The zone index for scope 6 on this interface.')
ipv6ScopeZoneIndex7 = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 7), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndex7.setStatus('current')
if mibBuilder.loadTexts: ipv6ScopeZoneIndex7.setDescription('The zone index for scope 7 on this interface.')
ipv6ScopeZoneIndexOrganizationLocal = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 8), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndexOrganizationLocal.setStatus('current')
if mibBuilder.loadTexts: ipv6ScopeZoneIndexOrganizationLocal.setDescription('The zone index for the organization-local scope on this interface.')
ipv6ScopeZoneIndex9 = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 9), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndex9.setStatus('current')
if mibBuilder.loadTexts: ipv6ScopeZoneIndex9.setDescription('The zone index for scope 9 on this interface.')
ipv6ScopeZoneIndexA = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 10), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndexA.setStatus('current')
if mibBuilder.loadTexts: ipv6ScopeZoneIndexA.setDescription('The zone index for scope A on this interface.')
ipv6ScopeZoneIndexB = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 11), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndexB.setStatus('current')
if mibBuilder.loadTexts: ipv6ScopeZoneIndexB.setDescription('The zone index for scope B on this interface.')
ipv6ScopeZoneIndexC = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 12), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndexC.setStatus('current')
if mibBuilder.loadTexts: ipv6ScopeZoneIndexC.setDescription('The zone index for scope C on this interface.')
ipv6ScopeZoneIndexD = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 13), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndexD.setStatus('current')
if mibBuilder.loadTexts: ipv6ScopeZoneIndexD.setDescription('The zone index for scope D on this interface.')
ipDefaultRouterTable = MibTable((1, 3, 6, 1, 2, 1, 4, 37), )
if mibBuilder.loadTexts: ipDefaultRouterTable.setStatus('current')
if mibBuilder.loadTexts: ipDefaultRouterTable.setDescription('The table used to describe the default routers known to this entity.')
ipDefaultRouterEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 37, 1), ).setIndexNames((0, "IP-MIB", "ipDefaultRouterAddressType"), (0, "IP-MIB", "ipDefaultRouterAddress"), (0, "IP-MIB", "ipDefaultRouterIfIndex"))
if mibBuilder.loadTexts: ipDefaultRouterEntry.setStatus('current')
if mibBuilder.loadTexts: ipDefaultRouterEntry.setDescription('Each entry contains information about a default router known to this entity.')
ipDefaultRouterAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 37, 1, 1), InetAddressType())
if mibBuilder.loadTexts: ipDefaultRouterAddressType.setStatus('current')
if mibBuilder.loadTexts: ipDefaultRouterAddressType.setDescription('The address type for this row.')
ipDefaultRouterAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 37, 1, 2), InetAddress())
if mibBuilder.loadTexts: ipDefaultRouterAddress.setStatus('current')
if mibBuilder.loadTexts: ipDefaultRouterAddress.setDescription('The IP address of the default router represented by this row. The address type of this object is specified in ipDefaultRouterAddressType. Implementers need to be aware that if the size of ipDefaultRouterAddress exceeds 115 octets, then OIDS of instances of columns in this row will have more than 128 sub-identifiers and cannot be accessed using SNMPv1, SNMPv2c, or SNMPv3.')
ipDefaultRouterIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 37, 1, 3), InterfaceIndex())
if mibBuilder.loadTexts: ipDefaultRouterIfIndex.setStatus('current')
if mibBuilder.loadTexts: ipDefaultRouterIfIndex.setDescription("The index value that uniquely identifies the interface by which the router can be reached. The interface identified by a particular value of this index is the same interface as identified by the same value of the IF-MIB's ifIndex.")
ipDefaultRouterLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 37, 1, 4), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: ipDefaultRouterLifetime.setReference('For IPv6 RFC 2462 sections 4.2 and 6.3.4')
if mibBuilder.loadTexts: ipDefaultRouterLifetime.setStatus('current')
if mibBuilder.loadTexts: ipDefaultRouterLifetime.setDescription('The remaining length of time, in seconds, that this router will continue to be useful as a default router. A value of zero indicates that it is no longer useful as a default router. It is left to the implementer of the MIB as to whether a router with a lifetime of zero is removed from the list. For IPv6, this value should be extracted from the router advertisement messages.')
ipDefaultRouterPreference = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 37, 1, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(-2, -1, 0, 1))).clone(namedValues=NamedValues(("reserved", -2), ("low", -1), ("medium", 0), ("high", 1)))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipDefaultRouterPreference.setReference('RFC 4291, section 2.1')
if mibBuilder.loadTexts: ipDefaultRouterPreference.setStatus('current')
if mibBuilder.loadTexts: ipDefaultRouterPreference.setDescription('An indication of preference given to this router as a default router as described in he Default Router Preferences document. Treating the value as a 2 bit signed integer allows for simple arithmetic comparisons. For IPv4 routers or IPv6 routers that are not using the updated router advertisement format, this object is set to medium (0).')
ipv6RouterAdvertSpinLock = MibScalar((1, 3, 6, 1, 2, 1, 4, 38), TestAndIncr()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipv6RouterAdvertSpinLock.setStatus('current')
if mibBuilder.loadTexts: ipv6RouterAdvertSpinLock.setDescription("An advisory lock used to allow cooperating SNMP managers to coordinate their use of the set operation in creating or modifying rows within this table. In order to use this lock to coordinate the use of set operations, managers should first retrieve ipv6RouterAdvertSpinLock. They should then determine the appropriate row to create or modify. Finally, they should issue the appropriate set command including the retrieved value of ipv6RouterAdvertSpinLock. If another manager has altered the table in the meantime, then the value of ipv6RouterAdvertSpinLock will have changed and the creation will fail as it will be specifying an incorrect value for ipv6RouterAdvertSpinLock. It is suggested, but not required, that the ipv6RouterAdvertSpinLock be the first var bind for each set of objects representing a 'row' in a PDU.")
ipv6RouterAdvertTable = MibTable((1, 3, 6, 1, 2, 1, 4, 39), )
if mibBuilder.loadTexts: ipv6RouterAdvertTable.setStatus('current')
if mibBuilder.loadTexts: ipv6RouterAdvertTable.setDescription('The table containing information used to construct router advertisements.')
ipv6RouterAdvertEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 39, 1), ).setIndexNames((0, "IP-MIB", "ipv6RouterAdvertIfIndex"))
if mibBuilder.loadTexts: ipv6RouterAdvertEntry.setStatus('current')
if mibBuilder.loadTexts: ipv6RouterAdvertEntry.setDescription('An entry containing information used to construct router advertisements. Information in this table is persistent, and when this object is written, the entity SHOULD save the change to non-volatile storage.')
ipv6RouterAdvertIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 1), InterfaceIndex())
if mibBuilder.loadTexts: ipv6RouterAdvertIfIndex.setStatus('current')
if mibBuilder.loadTexts: ipv6RouterAdvertIfIndex.setDescription("The index value that uniquely identifies the interface on which router advertisements constructed with this information will be transmitted. The interface identified by a particular value of this index is the same interface as identified by the same value of the IF-MIB's ifIndex.")
ipv6RouterAdvertSendAdverts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 2), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertSendAdverts.setReference('RFC 2461 Section 6.2.1')
if mibBuilder.loadTexts: ipv6RouterAdvertSendAdverts.setStatus('current')
if mibBuilder.loadTexts: ipv6RouterAdvertSendAdverts.setDescription('A flag indicating whether the router sends periodic router advertisements and responds to router solicitations on this interface.')
ipv6RouterAdvertMaxInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 3), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(4, 1800)).clone(600)).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertMaxInterval.setReference('RFC 2461 Section 6.2.1')
if mibBuilder.loadTexts: ipv6RouterAdvertMaxInterval.setStatus('current')
if mibBuilder.loadTexts: ipv6RouterAdvertMaxInterval.setDescription('The maximum time allowed between sending unsolicited router advertisements from this interface.')
ipv6RouterAdvertMinInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 4), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(3, 1350))).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertMinInterval.setReference('RFC 2461 Section 6.2.1')
if mibBuilder.loadTexts: ipv6RouterAdvertMinInterval.setStatus('current')
if mibBuilder.loadTexts: ipv6RouterAdvertMinInterval.setDescription('The minimum time allowed between sending unsolicited router advertisements from this interface. The default is 0.33 * ipv6RouterAdvertMaxInterval, however, in the case of a low value for ipv6RouterAdvertMaxInterval, the minimum value for this object is restricted to 3.')
ipv6RouterAdvertManagedFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 5), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertManagedFlag.setReference('RFC 2461 Section 6.2.1')
if mibBuilder.loadTexts: ipv6RouterAdvertManagedFlag.setStatus('current')
if mibBuilder.loadTexts: ipv6RouterAdvertManagedFlag.setDescription("The true/false value to be placed into the 'managed address configuration' flag field in router advertisements sent from this interface.")
ipv6RouterAdvertOtherConfigFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 6), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertOtherConfigFlag.setReference('RFC 2461 Section 6.2.1')
if mibBuilder.loadTexts: ipv6RouterAdvertOtherConfigFlag.setStatus('current')
if mibBuilder.loadTexts: ipv6RouterAdvertOtherConfigFlag.setDescription("The true/false value to be placed into the 'other stateful configuration' flag field in router advertisements sent from this interface.")
ipv6RouterAdvertLinkMTU = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 7), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertLinkMTU.setReference('RFC 2461 Section 6.2.1')
if mibBuilder.loadTexts: ipv6RouterAdvertLinkMTU.setStatus('current')
if mibBuilder.loadTexts: ipv6RouterAdvertLinkMTU.setDescription('The value to be placed in MTU options sent by the router on this interface. A value of zero indicates that no MTU options are sent.')
ipv6RouterAdvertReachableTime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 8), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 3600000))).setUnits('milliseconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertReachableTime.setReference('RFC 2461 Section 6.2.1')
if mibBuilder.loadTexts: ipv6RouterAdvertReachableTime.setStatus('current')
if mibBuilder.loadTexts: ipv6RouterAdvertReachableTime.setDescription("The value to be placed in the reachable time field in router advertisement messages sent from this interface. A value of zero in the router advertisement indicates that the advertisement isn't specifying a value for reachable time.")
ipv6RouterAdvertRetransmitTime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 9), Unsigned32()).setUnits('milliseconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertRetransmitTime.setReference('RFC 2461 Section 6.2.1')
if mibBuilder.loadTexts: ipv6RouterAdvertRetransmitTime.setStatus('current')
if mibBuilder.loadTexts: ipv6RouterAdvertRetransmitTime.setDescription("The value to be placed in the retransmit timer field in router advertisements sent from this interface. A value of zero in the router advertisement indicates that the advertisement isn't specifying a value for retrans time.")
ipv6RouterAdvertCurHopLimit = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 10), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertCurHopLimit.setReference('RFC 2461 Section 6.2.1')
if mibBuilder.loadTexts: ipv6RouterAdvertCurHopLimit.setStatus('current')
if mibBuilder.loadTexts: ipv6RouterAdvertCurHopLimit.setDescription("The default value to be placed in the current hop limit field in router advertisements sent from this interface. The value should be set to the current diameter of the Internet. A value of zero in the router advertisement indicates that the advertisement isn't specifying a value for curHopLimit. The default should be set to the value specified in the IANA web pages (www.iana.org) at the time of implementation.")
ipv6RouterAdvertDefaultLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 11), Unsigned32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(0, 0), ValueRangeConstraint(4, 9000), ))).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertDefaultLifetime.setReference('RFC 2461 Section 6.2.1')
if mibBuilder.loadTexts: ipv6RouterAdvertDefaultLifetime.setStatus('current')
if mibBuilder.loadTexts: ipv6RouterAdvertDefaultLifetime.setDescription('The value to be placed in the router lifetime field of router advertisements sent from this interface. This value MUST be either 0 or between ipv6RouterAdvertMaxInterval and 9000 seconds. A value of zero indicates that the router is not to be used as a default router. The default is 3 * ipv6RouterAdvertMaxInterval.')
ipv6RouterAdvertRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 12), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertRowStatus.setStatus('current')
if mibBuilder.loadTexts: ipv6RouterAdvertRowStatus.setDescription('The status of this conceptual row. As all objects in this conceptual row have default values, a row can be created and made active by setting this object appropriately. The RowStatus TC requires that this DESCRIPTION clause states under which circumstances other objects in this row can be modified. The value of this object has no effect on whether other objects in this conceptual row can be modified.')
icmp = MibIdentifier((1, 3, 6, 1, 2, 1, 5))
icmpStatsTable = MibTable((1, 3, 6, 1, 2, 1, 5, 29), )
if mibBuilder.loadTexts: icmpStatsTable.setStatus('current')
if mibBuilder.loadTexts: icmpStatsTable.setDescription('The table of generic system-wide ICMP counters.')
icmpStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 5, 29, 1), ).setIndexNames((0, "IP-MIB", "icmpStatsIPVersion"))
if mibBuilder.loadTexts: icmpStatsEntry.setStatus('current')
if mibBuilder.loadTexts: icmpStatsEntry.setDescription('A conceptual row in the icmpStatsTable.')
icmpStatsIPVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 5, 29, 1, 1), InetVersion())
if mibBuilder.loadTexts: icmpStatsIPVersion.setStatus('current')
if mibBuilder.loadTexts: icmpStatsIPVersion.setDescription('The IP version of the statistics.')
icmpStatsInMsgs = MibTableColumn((1, 3, 6, 1, 2, 1, 5, 29, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpStatsInMsgs.setStatus('current')
if mibBuilder.loadTexts: icmpStatsInMsgs.setDescription('The total number of ICMP messages that the entity received. Note that this counter includes all those counted by icmpStatsInErrors.')
icmpStatsInErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 5, 29, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpStatsInErrors.setStatus('current')
if mibBuilder.loadTexts: icmpStatsInErrors.setDescription('The number of ICMP messages that the entity received but determined as having ICMP-specific errors (bad ICMP checksums, bad length, etc.).')
icmpStatsOutMsgs = MibTableColumn((1, 3, 6, 1, 2, 1, 5, 29, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpStatsOutMsgs.setStatus('current')
if mibBuilder.loadTexts: icmpStatsOutMsgs.setDescription('The total number of ICMP messages that the entity attempted to send. Note that this counter includes all those counted by icmpStatsOutErrors.')
icmpStatsOutErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 5, 29, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpStatsOutErrors.setStatus('current')
if mibBuilder.loadTexts: icmpStatsOutErrors.setDescription("The number of ICMP messages that this entity did not send due to problems discovered within ICMP, such as a lack of buffers. This value should not include errors discovered outside the ICMP layer, such as the inability of IP to route the resultant datagram. In some implementations, there may be no types of error that contribute to this counter's value.")
icmpMsgStatsTable = MibTable((1, 3, 6, 1, 2, 1, 5, 30), )
if mibBuilder.loadTexts: icmpMsgStatsTable.setStatus('current')
if mibBuilder.loadTexts: icmpMsgStatsTable.setDescription('The table of system-wide per-version, per-message type ICMP counters.')
icmpMsgStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 5, 30, 1), ).setIndexNames((0, "IP-MIB", "icmpMsgStatsIPVersion"), (0, "IP-MIB", "icmpMsgStatsType"))
if mibBuilder.loadTexts: icmpMsgStatsEntry.setStatus('current')
if mibBuilder.loadTexts: icmpMsgStatsEntry.setDescription('A conceptual row in the icmpMsgStatsTable. The system should track each ICMP type value, even if that ICMP type is not supported by the system. However, a given row need not be instantiated unless a message of that type has been processed, i.e., the row for icmpMsgStatsType=X MAY be instantiated before but MUST be instantiated after the first message with Type=X is received or transmitted. After receiving or transmitting any succeeding messages with Type=X, the relevant counter must be incremented.')
icmpMsgStatsIPVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 5, 30, 1, 1), InetVersion())
if mibBuilder.loadTexts: icmpMsgStatsIPVersion.setStatus('current')
if mibBuilder.loadTexts: icmpMsgStatsIPVersion.setDescription('The IP version of the statistics.')
icmpMsgStatsType = MibTableColumn((1, 3, 6, 1, 2, 1, 5, 30, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255)))
if mibBuilder.loadTexts: icmpMsgStatsType.setReference('http://www.iana.org/assignments/icmp-parameters and http://www.iana.org/assignments/icmpv6-parameters')
if mibBuilder.loadTexts: icmpMsgStatsType.setStatus('current')
if mibBuilder.loadTexts: icmpMsgStatsType.setDescription('The ICMP type field of the message type being counted by this row. Note that ICMP message types are scoped by the address type in use.')
icmpMsgStatsInPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 5, 30, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpMsgStatsInPkts.setStatus('current')
if mibBuilder.loadTexts: icmpMsgStatsInPkts.setDescription('The number of input packets for this AF and type.')
icmpMsgStatsOutPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 5, 30, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpMsgStatsOutPkts.setStatus('current')
if mibBuilder.loadTexts: icmpMsgStatsOutPkts.setDescription('The number of output packets for this AF and type.')
ipMIBConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 48, 2))
ipMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 48, 2, 1))
ipMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 48, 2, 2))
ipMIBCompliance2 = ModuleCompliance((1, 3, 6, 1, 2, 1, 48, 2, 1, 2)).setObjects(("IP-MIB", "ipSystemStatsGroup"), ("IP-MIB", "ipAddressGroup"), ("IP-MIB", "ipNetToPhysicalGroup"), ("IP-MIB", "ipDefaultRouterGroup"), ("IP-MIB", "icmpStatsGroup"), ("IP-MIB", "ipSystemStatsHCOctetGroup"), ("IP-MIB", "ipSystemStatsHCPacketGroup"), ("IP-MIB", "ipIfStatsGroup"), ("IP-MIB", "ipIfStatsHCOctetGroup"), ("IP-MIB", "ipIfStatsHCPacketGroup"), ("IP-MIB", "ipv4GeneralGroup"), ("IP-MIB", "ipv4IfGroup"), ("IP-MIB", "ipv4SystemStatsGroup"), ("IP-MIB", "ipv4SystemStatsHCPacketGroup"), ("IP-MIB", "ipv4IfStatsGroup"), ("IP-MIB", "ipv4IfStatsHCPacketGroup"), ("IP-MIB", "ipv6GeneralGroup2"), ("IP-MIB", "ipv6IfGroup"), ("IP-MIB", "ipAddressPrefixGroup"), ("IP-MIB", "ipv6ScopeGroup"), ("IP-MIB", "ipv6RouterAdvertGroup"), ("IP-MIB", "ipLastChangeGroup"))

if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    ipMIBCompliance2 = ipMIBCompliance2.setStatus('current')
if mibBuilder.loadTexts: ipMIBCompliance2.setDescription('The compliance statement for systems that implement IP - either IPv4 or IPv6. There are a number of INDEX objects that cannot be represented in the form of OBJECT clauses in SMIv2, but for which we have the following compliance requirements, expressed in OBJECT clause form in this description clause: -- OBJECT ipSystemStatsIPVersion -- SYNTAX InetVersion {ipv4(1), ipv6(2)} -- DESCRIPTION -- This MIB requires support for only IPv4 and IPv6 -- versions. -- -- OBJECT ipIfStatsIPVersion -- SYNTAX InetVersion {ipv4(1), ipv6(2)} -- DESCRIPTION -- This MIB requires support for only IPv4 and IPv6 -- versions. -- -- OBJECT icmpStatsIPVersion -- SYNTAX InetVersion {ipv4(1), ipv6(2)} -- DESCRIPTION -- This MIB requires support for only IPv4 and IPv6 -- versions. -- -- OBJECT icmpMsgStatsIPVersion -- SYNTAX InetVersion {ipv4(1), ipv6(2)} -- DESCRIPTION -- This MIB requires support for only IPv4 and IPv6 -- versions. -- -- OBJECT ipAddressPrefixType -- SYNTAX InetAddressType {ipv4(1), ipv6(2)} -- DESCRIPTION -- This MIB requires support for only global IPv4 and -- IPv6 address types. -- -- OBJECT ipAddressPrefixPrefix -- SYNTAX InetAddress (Size(4 | 16)) -- DESCRIPTION -- This MIB requires support for only global IPv4 and -- IPv6 addresses and so the size can be either 4 or -- 16 bytes. -- -- OBJECT ipAddressAddrType -- SYNTAX InetAddressType {ipv4(1), ipv6(2), -- ipv4z(3), ipv6z(4)} -- DESCRIPTION -- This MIB requires support for only global and -- non-global IPv4 and IPv6 address types. -- -- OBJECT ipAddressAddr -- SYNTAX InetAddress (Size(4 | 8 | 16 | 20)) -- DESCRIPTION -- This MIB requires support for only global and -- non-global IPv4 and IPv6 addresses and so the size -- can be 4, 8, 16, or 20 bytes. -- -- OBJECT ipNetToPhysicalNetAddressType -- SYNTAX InetAddressType {ipv4(1), ipv6(2), -- ipv4z(3), ipv6z(4)} -- DESCRIPTION -- This MIB requires support for only global and -- non-global IPv4 and IPv6 address types. -- -- OBJECT ipNetToPhysicalNetAddress -- SYNTAX InetAddress (Size(4 | 8 | 16 | 20)) -- DESCRIPTION -- This MIB requires support for only global and -- non-global IPv4 and IPv6 addresses and so the size -- can be 4, 8, 16, or 20 bytes. -- -- OBJECT ipDefaultRouterAddressType -- SYNTAX InetAddressType {ipv4(1), ipv6(2), -- ipv4z(3), ipv6z(4)} -- DESCRIPTION -- This MIB requires support for only global and -- non-global IPv4 and IPv6 address types. -- -- OBJECT ipDefaultRouterAddress -- SYNTAX InetAddress (Size(4 | 8 | 16 | 20)) -- DESCRIPTION -- This MIB requires support for only global and -- non-global IPv4 and IPv6 addresses and so the size -- can be 4, 8, 16, or 20 bytes.')
ipv4GeneralGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 3)).setObjects(("IP-MIB", "ipForwarding"), ("IP-MIB", "ipDefaultTTL"), ("IP-MIB", "ipReasmTimeout"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    ipv4GeneralGroup = ipv4GeneralGroup.setStatus('current')
if mibBuilder.loadTexts: ipv4GeneralGroup.setDescription('The group of IPv4-specific objects for basic management of IPv4 entities.')
ipv4IfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 4)).setObjects(("IP-MIB", "ipv4InterfaceReasmMaxSize"), ("IP-MIB", "ipv4InterfaceEnableStatus"), ("IP-MIB", "ipv4InterfaceRetransmitTime"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    ipv4IfGroup = ipv4IfGroup.setStatus('current')
if mibBuilder.loadTexts: ipv4IfGroup.setDescription('The group of IPv4-specific objects for basic management of IPv4 interfaces.')
ipv6GeneralGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 5)).setObjects(("IP-MIB", "ipv6IpForwarding"), ("IP-MIB", "ipv6IpDefaultHopLimit"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    ipv6GeneralGroup2 = ipv6GeneralGroup2.setStatus('current')
if mibBuilder.loadTexts: ipv6GeneralGroup2.setDescription('The IPv6 group of objects providing for basic management of IPv6 entities.')
ipv6IfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 6)).setObjects(("IP-MIB", "ipv6InterfaceReasmMaxSize"), ("IP-MIB", "ipv6InterfaceIdentifier"), ("IP-MIB", "ipv6InterfaceEnableStatus"), ("IP-MIB", "ipv6InterfaceReachableTime"), ("IP-MIB", "ipv6InterfaceRetransmitTime"), ("IP-MIB", "ipv6InterfaceForwarding"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    ipv6IfGroup = ipv6IfGroup.setStatus('current')
if mibBuilder.loadTexts: ipv6IfGroup.setDescription('The group of IPv6-specific objects for basic management of IPv6 interfaces.')
ipLastChangeGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 7)).setObjects(("IP-MIB", "ipv4InterfaceTableLastChange"), ("IP-MIB", "ipv6InterfaceTableLastChange"), ("IP-MIB", "ipIfStatsTableLastChange"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    ipLastChangeGroup = ipLastChangeGroup.setStatus('current')
if mibBuilder.loadTexts: ipLastChangeGroup.setDescription('The last change objects associated with this MIB. These objects are optional for all agents. They SHOULD be implemented on agents where it is possible to determine the proper values. Where it is not possible to determine the proper values, for example when the tables are split amongst several sub-agents using AgentX, the agent MUST NOT implement these objects to return an incorrect or static value.')
ipSystemStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 8)).setObjects(("IP-MIB", "ipSystemStatsInReceives"), ("IP-MIB", "ipSystemStatsInOctets"), ("IP-MIB", "ipSystemStatsInHdrErrors"), ("IP-MIB", "ipSystemStatsInNoRoutes"), ("IP-MIB", "ipSystemStatsInAddrErrors"), ("IP-MIB", "ipSystemStatsInUnknownProtos"), ("IP-MIB", "ipSystemStatsInTruncatedPkts"), ("IP-MIB", "ipSystemStatsInForwDatagrams"), ("IP-MIB", "ipSystemStatsReasmReqds"), ("IP-MIB", "ipSystemStatsReasmOKs"), ("IP-MIB", "ipSystemStatsReasmFails"), ("IP-MIB", "ipSystemStatsInDiscards"), ("IP-MIB", "ipSystemStatsInDelivers"), ("IP-MIB", "ipSystemStatsOutRequests"), ("IP-MIB", "ipSystemStatsOutNoRoutes"), ("IP-MIB", "ipSystemStatsOutForwDatagrams"), ("IP-MIB", "ipSystemStatsOutDiscards"), ("IP-MIB", "ipSystemStatsOutFragReqds"), ("IP-MIB", "ipSystemStatsOutFragOKs"), ("IP-MIB", "ipSystemStatsOutFragFails"), ("IP-MIB", "ipSystemStatsOutFragCreates"), ("IP-MIB", "ipSystemStatsOutTransmits"), ("IP-MIB", "ipSystemStatsOutOctets"), ("IP-MIB", "ipSystemStatsInMcastPkts"), ("IP-MIB", "ipSystemStatsInMcastOctets"), ("IP-MIB", "ipSystemStatsOutMcastPkts"), ("IP-MIB", "ipSystemStatsOutMcastOctets"), ("IP-MIB", "ipSystemStatsDiscontinuityTime"), ("IP-MIB", "ipSystemStatsRefreshRate"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    ipSystemStatsGroup = ipSystemStatsGroup.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsGroup.setDescription('IP system wide statistics.')
ipv4SystemStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 9)).setObjects(("IP-MIB", "ipSystemStatsInBcastPkts"), ("IP-MIB", "ipSystemStatsOutBcastPkts"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    ipv4SystemStatsGroup = ipv4SystemStatsGroup.setStatus('current')
if mibBuilder.loadTexts: ipv4SystemStatsGroup.setDescription('IPv4 only system wide statistics.')
ipSystemStatsHCOctetGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 10)).setObjects(("IP-MIB", "ipSystemStatsHCInOctets"), ("IP-MIB", "ipSystemStatsHCOutOctets"), ("IP-MIB", "ipSystemStatsHCInMcastOctets"), ("IP-MIB", "ipSystemStatsHCOutMcastOctets"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    ipSystemStatsHCOctetGroup = ipSystemStatsHCOctetGroup.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsHCOctetGroup.setDescription('IP system wide statistics for systems that may overflow the standard octet counters within 1 hour.')
ipSystemStatsHCPacketGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 11)).setObjects(("IP-MIB", "ipSystemStatsHCInReceives"), ("IP-MIB", "ipSystemStatsHCInForwDatagrams"), ("IP-MIB", "ipSystemStatsHCInDelivers"), ("IP-MIB", "ipSystemStatsHCOutRequests"), ("IP-MIB", "ipSystemStatsHCOutForwDatagrams"), ("IP-MIB", "ipSystemStatsHCOutTransmits"), ("IP-MIB", "ipSystemStatsHCInMcastPkts"), ("IP-MIB", "ipSystemStatsHCOutMcastPkts"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    ipSystemStatsHCPacketGroup = ipSystemStatsHCPacketGroup.setStatus('current')
if mibBuilder.loadTexts: ipSystemStatsHCPacketGroup.setDescription('IP system wide statistics for systems that may overflow the standard packet counters within 1 hour.')
ipv4SystemStatsHCPacketGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 12)).setObjects(("IP-MIB", "ipSystemStatsHCInBcastPkts"), ("IP-MIB", "ipSystemStatsHCOutBcastPkts"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    ipv4SystemStatsHCPacketGroup = ipv4SystemStatsHCPacketGroup.setStatus('current')
if mibBuilder.loadTexts: ipv4SystemStatsHCPacketGroup.setDescription('IPv4 only system wide statistics for systems that may overflow the standard packet counters within 1 hour.')
ipIfStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 13)).setObjects(("IP-MIB", "ipIfStatsInReceives"), ("IP-MIB", "ipIfStatsInOctets"), ("IP-MIB", "ipIfStatsInHdrErrors"), ("IP-MIB", "ipIfStatsInNoRoutes"), ("IP-MIB", "ipIfStatsInAddrErrors"), ("IP-MIB", "ipIfStatsInUnknownProtos"), ("IP-MIB", "ipIfStatsInTruncatedPkts"), ("IP-MIB", "ipIfStatsInForwDatagrams"), ("IP-MIB", "ipIfStatsReasmReqds"), ("IP-MIB", "ipIfStatsReasmOKs"), ("IP-MIB", "ipIfStatsReasmFails"), ("IP-MIB", "ipIfStatsInDiscards"), ("IP-MIB", "ipIfStatsInDelivers"), ("IP-MIB", "ipIfStatsOutRequests"), ("IP-MIB", "ipIfStatsOutForwDatagrams"), ("IP-MIB", "ipIfStatsOutDiscards"), ("IP-MIB", "ipIfStatsOutFragReqds"), ("IP-MIB", "ipIfStatsOutFragOKs"), ("IP-MIB", "ipIfStatsOutFragFails"), ("IP-MIB", "ipIfStatsOutFragCreates"), ("IP-MIB", "ipIfStatsOutTransmits"), ("IP-MIB", "ipIfStatsOutOctets"), ("IP-MIB", "ipIfStatsInMcastPkts"), ("IP-MIB", "ipIfStatsInMcastOctets"), ("IP-MIB", "ipIfStatsOutMcastPkts"), ("IP-MIB", "ipIfStatsOutMcastOctets"), ("IP-MIB", "ipIfStatsDiscontinuityTime"), ("IP-MIB", "ipIfStatsRefreshRate"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    ipIfStatsGroup = ipIfStatsGroup.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsGroup.setDescription('IP per-interface statistics.')
ipv4IfStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 14)).setObjects(("IP-MIB", "ipIfStatsInBcastPkts"), ("IP-MIB", "ipIfStatsOutBcastPkts"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    ipv4IfStatsGroup = ipv4IfStatsGroup.setStatus('current')
if mibBuilder.loadTexts: ipv4IfStatsGroup.setDescription('IPv4 only per-interface statistics.')
ipIfStatsHCOctetGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 15)).setObjects(("IP-MIB", "ipIfStatsHCInOctets"), ("IP-MIB", "ipIfStatsHCOutOctets"), ("IP-MIB", "ipIfStatsHCInMcastOctets"), ("IP-MIB", "ipIfStatsHCOutMcastOctets"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    ipIfStatsHCOctetGroup = ipIfStatsHCOctetGroup.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsHCOctetGroup.setDescription('IP per-interfaces statistics for systems that include interfaces that may overflow the standard octet counters within 1 hour.')
ipIfStatsHCPacketGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 16)).setObjects(("IP-MIB", "ipIfStatsHCInReceives"), ("IP-MIB", "ipIfStatsHCInForwDatagrams"), ("IP-MIB", "ipIfStatsHCInDelivers"), ("IP-MIB", "ipIfStatsHCOutRequests"), ("IP-MIB", "ipIfStatsHCOutForwDatagrams"), ("IP-MIB", "ipIfStatsHCOutTransmits"), ("IP-MIB", "ipIfStatsHCInMcastPkts"), ("IP-MIB", "ipIfStatsHCOutMcastPkts"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    ipIfStatsHCPacketGroup = ipIfStatsHCPacketGroup.setStatus('current')
if mibBuilder.loadTexts: ipIfStatsHCPacketGroup.setDescription('IP per-interfaces statistics for systems that include interfaces that may overflow the standard packet counters within 1 hour.')
ipv4IfStatsHCPacketGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 17)).setObjects(("IP-MIB", "ipIfStatsHCInBcastPkts"), ("IP-MIB", "ipIfStatsHCOutBcastPkts"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    ipv4IfStatsHCPacketGroup = ipv4IfStatsHCPacketGroup.setStatus('current')
if mibBuilder.loadTexts: ipv4IfStatsHCPacketGroup.setDescription('IPv4 only per-interface statistics for systems that include interfaces that may overflow the standard packet counters within 1 hour.')
ipAddressPrefixGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 18)).setObjects(("IP-MIB", "ipAddressPrefixOrigin"), ("IP-MIB", "ipAddressPrefixOnLinkFlag"), ("IP-MIB", "ipAddressPrefixAutonomousFlag"), ("IP-MIB", "ipAddressPrefixAdvPreferredLifetime"), ("IP-MIB", "ipAddressPrefixAdvValidLifetime"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    ipAddressPrefixGroup = ipAddressPrefixGroup.setStatus('current')
if mibBuilder.loadTexts: ipAddressPrefixGroup.setDescription('The group of objects for providing information about address prefixes used by this node.')
ipAddressGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 19)).setObjects(("IP-MIB", "ipAddressSpinLock"), ("IP-MIB", "ipAddressIfIndex"), ("IP-MIB", "ipAddressType"), ("IP-MIB", "ipAddressPrefix"), ("IP-MIB", "ipAddressOrigin"), ("IP-MIB", "ipAddressStatus"), ("IP-MIB", "ipAddressCreated"), ("IP-MIB", "ipAddressLastChanged"), ("IP-MIB", "ipAddressRowStatus"), ("IP-MIB", "ipAddressStorageType"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    ipAddressGroup = ipAddressGroup.setStatus('current')
if mibBuilder.loadTexts: ipAddressGroup.setDescription("The group of objects for providing information about the addresses relevant to this entity's interfaces.")
ipNetToPhysicalGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 20)).setObjects(("IP-MIB", "ipNetToPhysicalPhysAddress"), ("IP-MIB", "ipNetToPhysicalLastUpdated"), ("IP-MIB", "ipNetToPhysicalType"), ("IP-MIB", "ipNetToPhysicalState"), ("IP-MIB", "ipNetToPhysicalRowStatus"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    ipNetToPhysicalGroup = ipNetToPhysicalGroup.setStatus('current')
if mibBuilder.loadTexts: ipNetToPhysicalGroup.setDescription('The group of objects for providing information about the mappings of network address to physical address known to this node.')
ipv6ScopeGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 21)).setObjects(("IP-MIB", "ipv6ScopeZoneIndexLinkLocal"), ("IP-MIB", "ipv6ScopeZoneIndex3"), ("IP-MIB", "ipv6ScopeZoneIndexAdminLocal"), ("IP-MIB", "ipv6ScopeZoneIndexSiteLocal"), ("IP-MIB", "ipv6ScopeZoneIndex6"), ("IP-MIB", "ipv6ScopeZoneIndex7"), ("IP-MIB", "ipv6ScopeZoneIndexOrganizationLocal"), ("IP-MIB", "ipv6ScopeZoneIndex9"), ("IP-MIB", "ipv6ScopeZoneIndexA"), ("IP-MIB", "ipv6ScopeZoneIndexB"), ("IP-MIB", "ipv6ScopeZoneIndexC"), ("IP-MIB", "ipv6ScopeZoneIndexD"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    ipv6ScopeGroup = ipv6ScopeGroup.setStatus('current')
if mibBuilder.loadTexts: ipv6ScopeGroup.setDescription('The group of objects for managing IPv6 scope zones.')
ipDefaultRouterGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 22)).setObjects(("IP-MIB", "ipDefaultRouterLifetime"), ("IP-MIB", "ipDefaultRouterPreference"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    ipDefaultRouterGroup = ipDefaultRouterGroup.setStatus('current')
if mibBuilder.loadTexts: ipDefaultRouterGroup.setDescription('The group of objects for providing information about default routers known to this node.')
ipv6RouterAdvertGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 23)).setObjects(("IP-MIB", "ipv6RouterAdvertSpinLock"), ("IP-MIB", "ipv6RouterAdvertSendAdverts"), ("IP-MIB", "ipv6RouterAdvertMaxInterval"), ("IP-MIB", "ipv6RouterAdvertMinInterval"), ("IP-MIB", "ipv6RouterAdvertManagedFlag"), ("IP-MIB", "ipv6RouterAdvertOtherConfigFlag"), ("IP-MIB", "ipv6RouterAdvertLinkMTU"), ("IP-MIB", "ipv6RouterAdvertReachableTime"), ("IP-MIB", "ipv6RouterAdvertRetransmitTime"), ("IP-MIB", "ipv6RouterAdvertCurHopLimit"), ("IP-MIB", "ipv6RouterAdvertDefaultLifetime"), ("IP-MIB", "ipv6RouterAdvertRowStatus"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    ipv6RouterAdvertGroup = ipv6RouterAdvertGroup.setStatus('current')
if mibBuilder.loadTexts: ipv6RouterAdvertGroup.setDescription('The group of objects for controlling information advertised by IPv6 routers.')
icmpStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 24)).setObjects(("IP-MIB", "icmpStatsInMsgs"), ("IP-MIB", "icmpStatsInErrors"), ("IP-MIB", "icmpStatsOutMsgs"), ("IP-MIB", "icmpStatsOutErrors"), ("IP-MIB", "icmpMsgStatsInPkts"), ("IP-MIB", "icmpMsgStatsOutPkts"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    icmpStatsGroup = icmpStatsGroup.setStatus('current')
if mibBuilder.loadTexts: icmpStatsGroup.setDescription('The group of objects providing ICMP statistics.')
ipInReceives = MibScalar((1, 3, 6, 1, 2, 1, 4, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipInReceives.setStatus('deprecated')
if mibBuilder.loadTexts: ipInReceives.setDescription('The total number of input datagrams received from interfaces, including those received in error. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by ipSystemStatsInRecieves.')
ipInHdrErrors = MibScalar((1, 3, 6, 1, 2, 1, 4, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipInHdrErrors.setStatus('deprecated')
if mibBuilder.loadTexts: ipInHdrErrors.setDescription('The number of input datagrams discarded due to errors in their IPv4 headers, including bad checksums, version number mismatch, other format errors, time-to-live exceeded, errors discovered in processing their IPv4 options, etc. This object has been deprecated as a new IP version-neutral table has been added. It is loosely replaced by ipSystemStatsInHdrErrors.')
ipInAddrErrors = MibScalar((1, 3, 6, 1, 2, 1, 4, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipInAddrErrors.setStatus('deprecated')
if mibBuilder.loadTexts: ipInAddrErrors.setDescription("The number of input datagrams discarded because the IPv4 address in their IPv4 header's destination field was not a valid address to be received at this entity. This count includes invalid addresses (e.g., 0.0.0.0) and addresses of unsupported Classes (e.g., Class E). For entities which are not IPv4 routers, and therefore do not forward datagrams, this counter includes datagrams discarded because the destination address was not a local address. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by ipSystemStatsInAddrErrors.")
ipForwDatagrams = MibScalar((1, 3, 6, 1, 2, 1, 4, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipForwDatagrams.setStatus('deprecated')
if mibBuilder.loadTexts: ipForwDatagrams.setDescription('The number of input datagrams for which this entity was not their final IPv4 destination, as a result of which an attempt was made to find a route to forward them to that final destination. In entities which do not act as IPv4 routers, this counter will include only those packets which were Source-Routed via this entity, and the Source-Route option processing was successful. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by ipSystemStatsInForwDatagrams.')
ipInUnknownProtos = MibScalar((1, 3, 6, 1, 2, 1, 4, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipInUnknownProtos.setStatus('deprecated')
if mibBuilder.loadTexts: ipInUnknownProtos.setDescription('The number of locally-addressed datagrams received successfully but discarded because of an unknown or unsupported protocol. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by ipSystemStatsInUnknownProtos.')
ipInDiscards = MibScalar((1, 3, 6, 1, 2, 1, 4, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipInDiscards.setStatus('deprecated')
if mibBuilder.loadTexts: ipInDiscards.setDescription('The number of input IPv4 datagrams for which no problems were encountered to prevent their continued processing, but which were discarded (e.g., for lack of buffer space). Note that this counter does not include any datagrams discarded while awaiting re-assembly. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by ipSystemStatsInDiscards.')
ipInDelivers = MibScalar((1, 3, 6, 1, 2, 1, 4, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipInDelivers.setStatus('deprecated')
if mibBuilder.loadTexts: ipInDelivers.setDescription('The total number of input datagrams successfully delivered to IPv4 user-protocols (including ICMP). This object has been deprecated as a new IP version neutral table has been added. It is loosely replaced by ipSystemStatsIndelivers.')
ipOutRequests = MibScalar((1, 3, 6, 1, 2, 1, 4, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipOutRequests.setStatus('deprecated')
if mibBuilder.loadTexts: ipOutRequests.setDescription('The total number of IPv4 datagrams which local IPv4 user protocols (including ICMP) supplied to IPv4 in requests for transmission. Note that this counter does not include any datagrams counted in ipForwDatagrams. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by ipSystemStatsOutRequests.')
ipOutDiscards = MibScalar((1, 3, 6, 1, 2, 1, 4, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipOutDiscards.setStatus('deprecated')
if mibBuilder.loadTexts: ipOutDiscards.setDescription('The number of output IPv4 datagrams for which no problem was encountered to prevent their transmission to their destination, but which were discarded (e.g., for lack of buffer space). Note that this counter would include datagrams counted in ipForwDatagrams if any such packets met this (discretionary) discard criterion. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by ipSystemStatsOutDiscards.')
ipOutNoRoutes = MibScalar((1, 3, 6, 1, 2, 1, 4, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipOutNoRoutes.setStatus('deprecated')
if mibBuilder.loadTexts: ipOutNoRoutes.setDescription("The number of IPv4 datagrams discarded because no route could be found to transmit them to their destination. Note that this counter includes any packets counted in ipForwDatagrams which meet this `no-route' criterion. Note that this includes any datagrams which a host cannot route because all of its default routers are down. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by ipSystemStatsOutNoRoutes.")
ipReasmReqds = MibScalar((1, 3, 6, 1, 2, 1, 4, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipReasmReqds.setStatus('deprecated')
if mibBuilder.loadTexts: ipReasmReqds.setDescription('The number of IPv4 fragments received which needed to be reassembled at this entity. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by ipSystemStatsReasmReqds.')
ipReasmOKs = MibScalar((1, 3, 6, 1, 2, 1, 4, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipReasmOKs.setStatus('deprecated')
if mibBuilder.loadTexts: ipReasmOKs.setDescription('The number of IPv4 datagrams successfully re-assembled. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by ipSystemStatsReasmOKs.')
ipReasmFails = MibScalar((1, 3, 6, 1, 2, 1, 4, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipReasmFails.setStatus('deprecated')
if mibBuilder.loadTexts: ipReasmFails.setDescription('The number of failures detected by the IPv4 re-assembly algorithm (for whatever reason: timed out, errors, etc). Note that this is not necessarily a count of discarded IPv4 fragments since some algorithms (notably the algorithm in RFC 815) can lose track of the number of fragments by combining them as they are received. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by ipSystemStatsReasmFails.')
ipFragOKs = MibScalar((1, 3, 6, 1, 2, 1, 4, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipFragOKs.setStatus('deprecated')
if mibBuilder.loadTexts: ipFragOKs.setDescription('The number of IPv4 datagrams that have been successfully fragmented at this entity. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by ipSystemStatsOutFragOKs.')
ipFragFails = MibScalar((1, 3, 6, 1, 2, 1, 4, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipFragFails.setStatus('deprecated')
if mibBuilder.loadTexts: ipFragFails.setDescription("The number of IPv4 datagrams that have been discarded because they needed to be fragmented at this entity but could not be, e.g., because their Don't Fragment flag was set. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by ipSystemStatsOutFragFails.")
ipFragCreates = MibScalar((1, 3, 6, 1, 2, 1, 4, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipFragCreates.setStatus('deprecated')
if mibBuilder.loadTexts: ipFragCreates.setDescription('The number of IPv4 datagram fragments that have been generated as a result of fragmentation at this entity. This object has been deprecated as a new IP version neutral table has been added. It is loosely replaced by ipSystemStatsOutFragCreates.')
ipRoutingDiscards = MibScalar((1, 3, 6, 1, 2, 1, 4, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipRoutingDiscards.setStatus('deprecated')
if mibBuilder.loadTexts: ipRoutingDiscards.setDescription('The number of routing entries which were chosen to be discarded even though they are valid. One possible reason for discarding such an entry could be to free-up buffer space for other routing entries. This object was defined in pre-IPv6 versions of the IP MIB. It was implicitly IPv4 only, but the original specifications did not indicate this protocol restriction. In order to clarify the specifications, this object has been deprecated and a similar, but more thoroughly clarified, object has been added to the IP-FORWARD-MIB.')
ipAddrTable = MibTable((1, 3, 6, 1, 2, 1, 4, 20), )
if mibBuilder.loadTexts: ipAddrTable.setStatus('deprecated')
if mibBuilder.loadTexts: ipAddrTable.setDescription("The table of addressing information relevant to this entity's IPv4 addresses. This table has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by the ipAddressTable although several objects that weren't deemed useful weren't carried forward while another (ipAdEntReasmMaxSize) was moved to the ipv4InterfaceTable.")
ipAddrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 20, 1), ).setIndexNames((0, "IP-MIB", "ipAdEntAddr"))
if mibBuilder.loadTexts: ipAddrEntry.setStatus('deprecated')
if mibBuilder.loadTexts: ipAddrEntry.setDescription("The addressing information for one of this entity's IPv4 addresses.")
ipAdEntAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 20, 1, 1), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAdEntAddr.setStatus('deprecated')
if mibBuilder.loadTexts: ipAdEntAddr.setDescription("The IPv4 address to which this entry's addressing information pertains.")
ipAdEntIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 20, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAdEntIfIndex.setStatus('deprecated')
if mibBuilder.loadTexts: ipAdEntIfIndex.setDescription("The index value which uniquely identifies the interface to which this entry is applicable. The interface identified by a particular value of this index is the same interface as identified by the same value of the IF-MIB's ifIndex.")
ipAdEntNetMask = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 20, 1, 3), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAdEntNetMask.setStatus('deprecated')
if mibBuilder.loadTexts: ipAdEntNetMask.setDescription('The subnet mask associated with the IPv4 address of this entry. The value of the mask is an IPv4 address with all the network bits set to 1 and all the hosts bits set to 0.')
ipAdEntBcastAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 20, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 1))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAdEntBcastAddr.setStatus('deprecated')
if mibBuilder.loadTexts: ipAdEntBcastAddr.setDescription('The value of the least-significant bit in the IPv4 broadcast address used for sending datagrams on the (logical) interface associated with the IPv4 address of this entry. For example, when the Internet standard all-ones broadcast address is used, the value will be 1. This value applies to both the subnet and network broadcast addresses used by the entity on this (logical) interface.')
ipAdEntReasmMaxSize = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 20, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAdEntReasmMaxSize.setStatus('deprecated')
if mibBuilder.loadTexts: ipAdEntReasmMaxSize.setDescription('The size of the largest IPv4 datagram which this entity can re-assemble from incoming IPv4 fragmented datagrams received on this interface.')
ipNetToMediaTable = MibTable((1, 3, 6, 1, 2, 1, 4, 22), )
if mibBuilder.loadTexts: ipNetToMediaTable.setStatus('deprecated')
if mibBuilder.loadTexts: ipNetToMediaTable.setDescription('The IPv4 Address Translation table used for mapping from IPv4 addresses to physical addresses. This table has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by the ipNetToPhysicalTable.')
ipNetToMediaEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 22, 1), ).setIndexNames((0, "IP-MIB", "ipNetToMediaIfIndex"), (0, "IP-MIB", "ipNetToMediaNetAddress"))
if mibBuilder.loadTexts: ipNetToMediaEntry.setStatus('deprecated')
if mibBuilder.loadTexts: ipNetToMediaEntry.setDescription("Each entry contains one IpAddress to `physical' address equivalence.")
ipNetToMediaIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 22, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipNetToMediaIfIndex.setStatus('deprecated')
if mibBuilder.loadTexts: ipNetToMediaIfIndex.setDescription("The interface on which this entry's equivalence is effective. The interface identified by a particular value of this index is the same interface as identified by the same value of the IF-MIB's ifIndex. This object predates the rule limiting index objects to a max access value of 'not-accessible' and so continues to use a value of 'read-create'.")
ipNetToMediaPhysAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 22, 1, 2), PhysAddress().subtype(subtypeSpec=ValueSizeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipNetToMediaPhysAddress.setStatus('deprecated')
if mibBuilder.loadTexts: ipNetToMediaPhysAddress.setDescription("The media-dependent `physical' address. This object should return 0 when this entry is in the 'incomplete' state. As the entries in this table are typically not persistent when this object is written the entity should not save the change to non-volatile storage. Note: a stronger requirement is not used because this object was previously defined.")
ipNetToMediaNetAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 22, 1, 3), IpAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipNetToMediaNetAddress.setStatus('deprecated')
if mibBuilder.loadTexts: ipNetToMediaNetAddress.setDescription("The IpAddress corresponding to the media-dependent `physical' address. This object predates the rule limiting index objects to a max access value of 'not-accessible' and so continues to use a value of 'read-create'.")
ipNetToMediaType = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 22, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4))).clone(namedValues=NamedValues(("other", 1), ("invalid", 2), ("dynamic", 3), ("static", 4)))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipNetToMediaType.setStatus('deprecated')
if mibBuilder.loadTexts: ipNetToMediaType.setDescription('The type of mapping. Setting this object to the value invalid(2) has the effect of invalidating the corresponding entry in the ipNetToMediaTable. That is, it effectively dis-associates the interface identified with said entry from the mapping identified with said entry. It is an implementation- specific matter as to whether the agent removes an invalidated entry from the table. Accordingly, management stations must be prepared to receive tabular information from agents that corresponds to entries not currently in use. Proper interpretation of such entries requires examination of the relevant ipNetToMediaType object. As the entries in this table are typically not persistent when this object is written the entity should not save the change to non-volatile storage. Note: a stronger requirement is not used because this object was previously defined.')
icmpInMsgs = MibScalar((1, 3, 6, 1, 2, 1, 5, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInMsgs.setStatus('deprecated')
if mibBuilder.loadTexts: icmpInMsgs.setDescription('The total number of ICMP messages which the entity received. Note that this counter includes all those counted by icmpInErrors. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by icmpStatsInMsgs.')
icmpInErrors = MibScalar((1, 3, 6, 1, 2, 1, 5, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInErrors.setStatus('deprecated')
if mibBuilder.loadTexts: icmpInErrors.setDescription('The number of ICMP messages which the entity received but determined as having ICMP-specific errors (bad ICMP checksums, bad length, etc.). This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by icmpStatsInErrors.')
icmpInDestUnreachs = MibScalar((1, 3, 6, 1, 2, 1, 5, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInDestUnreachs.setStatus('deprecated')
if mibBuilder.loadTexts: icmpInDestUnreachs.setDescription('The number of ICMP Destination Unreachable messages received. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by a column in the icmpMsgStatsTable.')
icmpInTimeExcds = MibScalar((1, 3, 6, 1, 2, 1, 5, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInTimeExcds.setStatus('deprecated')
if mibBuilder.loadTexts: icmpInTimeExcds.setDescription('The number of ICMP Time Exceeded messages received. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by a column in the icmpMsgStatsTable.')
icmpInParmProbs = MibScalar((1, 3, 6, 1, 2, 1, 5, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInParmProbs.setStatus('deprecated')
if mibBuilder.loadTexts: icmpInParmProbs.setDescription('The number of ICMP Parameter Problem messages received. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by a column in the icmpMsgStatsTable.')
icmpInSrcQuenchs = MibScalar((1, 3, 6, 1, 2, 1, 5, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInSrcQuenchs.setStatus('deprecated')
if mibBuilder.loadTexts: icmpInSrcQuenchs.setDescription('The number of ICMP Source Quench messages received. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by a column in the icmpMsgStatsTable.')
icmpInRedirects = MibScalar((1, 3, 6, 1, 2, 1, 5, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInRedirects.setStatus('deprecated')
if mibBuilder.loadTexts: icmpInRedirects.setDescription('The number of ICMP Redirect messages received. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by a column in the icmpMsgStatsTable.')
icmpInEchos = MibScalar((1, 3, 6, 1, 2, 1, 5, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInEchos.setStatus('deprecated')
if mibBuilder.loadTexts: icmpInEchos.setDescription('The number of ICMP Echo (request) messages received. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by a column in the icmpMsgStatsTable.')
icmpInEchoReps = MibScalar((1, 3, 6, 1, 2, 1, 5, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInEchoReps.setStatus('deprecated')
if mibBuilder.loadTexts: icmpInEchoReps.setDescription('The number of ICMP Echo Reply messages received. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by a column in the icmpMsgStatsTable.')
icmpInTimestamps = MibScalar((1, 3, 6, 1, 2, 1, 5, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInTimestamps.setStatus('deprecated')
if mibBuilder.loadTexts: icmpInTimestamps.setDescription('The number of ICMP Timestamp (request) messages received. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by a column in the icmpMsgStatsTable.')
icmpInTimestampReps = MibScalar((1, 3, 6, 1, 2, 1, 5, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInTimestampReps.setStatus('deprecated')
if mibBuilder.loadTexts: icmpInTimestampReps.setDescription('The number of ICMP Timestamp Reply messages received. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by a column in the icmpMsgStatsTable.')
icmpInAddrMasks = MibScalar((1, 3, 6, 1, 2, 1, 5, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInAddrMasks.setStatus('deprecated')
if mibBuilder.loadTexts: icmpInAddrMasks.setDescription('The number of ICMP Address Mask Request messages received. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by a column in the icmpMsgStatsTable.')
icmpInAddrMaskReps = MibScalar((1, 3, 6, 1, 2, 1, 5, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInAddrMaskReps.setStatus('deprecated')
if mibBuilder.loadTexts: icmpInAddrMaskReps.setDescription('The number of ICMP Address Mask Reply messages received. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by a column in the icmpMsgStatsTable.')
icmpOutMsgs = MibScalar((1, 3, 6, 1, 2, 1, 5, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutMsgs.setStatus('deprecated')
if mibBuilder.loadTexts: icmpOutMsgs.setDescription('The total number of ICMP messages which this entity attempted to send. Note that this counter includes all those counted by icmpOutErrors. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by icmpStatsOutMsgs.')
icmpOutErrors = MibScalar((1, 3, 6, 1, 2, 1, 5, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutErrors.setStatus('deprecated')
if mibBuilder.loadTexts: icmpOutErrors.setDescription("The number of ICMP messages which this entity did not send due to problems discovered within ICMP, such as a lack of buffers. This value should not include errors discovered outside the ICMP layer, such as the inability of IP to route the resultant datagram. In some implementations, there may be no types of error which contribute to this counter's value. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by icmpStatsOutErrors.")
icmpOutDestUnreachs = MibScalar((1, 3, 6, 1, 2, 1, 5, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutDestUnreachs.setStatus('deprecated')
if mibBuilder.loadTexts: icmpOutDestUnreachs.setDescription('The number of ICMP Destination Unreachable messages sent. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by a column in the icmpMsgStatsTable.')
icmpOutTimeExcds = MibScalar((1, 3, 6, 1, 2, 1, 5, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutTimeExcds.setStatus('deprecated')
if mibBuilder.loadTexts: icmpOutTimeExcds.setDescription('The number of ICMP Time Exceeded messages sent. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by a column in the icmpMsgStatsTable.')
icmpOutParmProbs = MibScalar((1, 3, 6, 1, 2, 1, 5, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutParmProbs.setStatus('deprecated')
if mibBuilder.loadTexts: icmpOutParmProbs.setDescription('The number of ICMP Parameter Problem messages sent. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by a column in the icmpMsgStatsTable.')
icmpOutSrcQuenchs = MibScalar((1, 3, 6, 1, 2, 1, 5, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutSrcQuenchs.setStatus('deprecated')
if mibBuilder.loadTexts: icmpOutSrcQuenchs.setDescription('The number of ICMP Source Quench messages sent. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by a column in the icmpMsgStatsTable.')
icmpOutRedirects = MibScalar((1, 3, 6, 1, 2, 1, 5, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutRedirects.setStatus('deprecated')
if mibBuilder.loadTexts: icmpOutRedirects.setDescription('The number of ICMP Redirect messages sent. For a host, this object will always be zero, since hosts do not send redirects. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by a column in the icmpMsgStatsTable.')
icmpOutEchos = MibScalar((1, 3, 6, 1, 2, 1, 5, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutEchos.setStatus('deprecated')
if mibBuilder.loadTexts: icmpOutEchos.setDescription('The number of ICMP Echo (request) messages sent. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by a column in the icmpMsgStatsTable.')
icmpOutEchoReps = MibScalar((1, 3, 6, 1, 2, 1, 5, 22), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutEchoReps.setStatus('deprecated')
if mibBuilder.loadTexts: icmpOutEchoReps.setDescription('The number of ICMP Echo Reply messages sent. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by a column in the icmpMsgStatsTable.')
icmpOutTimestamps = MibScalar((1, 3, 6, 1, 2, 1, 5, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutTimestamps.setStatus('deprecated')
if mibBuilder.loadTexts: icmpOutTimestamps.setDescription('The number of ICMP Timestamp (request) messages sent. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by a column in the icmpMsgStatsTable.')
icmpOutTimestampReps = MibScalar((1, 3, 6, 1, 2, 1, 5, 24), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutTimestampReps.setStatus('deprecated')
if mibBuilder.loadTexts: icmpOutTimestampReps.setDescription('The number of ICMP Timestamp Reply messages sent. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by a column in the icmpMsgStatsTable.')
icmpOutAddrMasks = MibScalar((1, 3, 6, 1, 2, 1, 5, 25), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutAddrMasks.setStatus('deprecated')
if mibBuilder.loadTexts: icmpOutAddrMasks.setDescription('The number of ICMP Address Mask Request messages sent. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by a column in the icmpMsgStatsTable.')
icmpOutAddrMaskReps = MibScalar((1, 3, 6, 1, 2, 1, 5, 26), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutAddrMaskReps.setStatus('deprecated')
if mibBuilder.loadTexts: icmpOutAddrMaskReps.setDescription('The number of ICMP Address Mask Reply messages sent. This object has been deprecated, as a new IP version-neutral table has been added. It is loosely replaced by a column in the icmpMsgStatsTable.')
ipMIBCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 48, 2, 1, 1)).setObjects(("IP-MIB", "ipGroup"), ("IP-MIB", "icmpGroup"))

if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    ipMIBCompliance = ipMIBCompliance.setStatus('deprecated')
if mibBuilder.loadTexts: ipMIBCompliance.setDescription('The compliance statement for systems that implement only IPv4. For version-independence, this compliance statement is deprecated in favor of ipMIBCompliance2.')
ipGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 1)).setObjects(("IP-MIB", "ipForwarding"), ("IP-MIB", "ipDefaultTTL"), ("IP-MIB", "ipInReceives"), ("IP-MIB", "ipInHdrErrors"), ("IP-MIB", "ipInAddrErrors"), ("IP-MIB", "ipForwDatagrams"), ("IP-MIB", "ipInUnknownProtos"), ("IP-MIB", "ipInDiscards"), ("IP-MIB", "ipInDelivers"), ("IP-MIB", "ipOutRequests"), ("IP-MIB", "ipOutDiscards"), ("IP-MIB", "ipOutNoRoutes"), ("IP-MIB", "ipReasmTimeout"), ("IP-MIB", "ipReasmReqds"), ("IP-MIB", "ipReasmOKs"), ("IP-MIB", "ipReasmFails"), ("IP-MIB", "ipFragOKs"), ("IP-MIB", "ipFragFails"), ("IP-MIB", "ipFragCreates"), ("IP-MIB", "ipAdEntAddr"), ("IP-MIB", "ipAdEntIfIndex"), ("IP-MIB", "ipAdEntNetMask"), ("IP-MIB", "ipAdEntBcastAddr"), ("IP-MIB", "ipAdEntReasmMaxSize"), ("IP-MIB", "ipNetToMediaIfIndex"), ("IP-MIB", "ipNetToMediaPhysAddress"), ("IP-MIB", "ipNetToMediaNetAddress"), ("IP-MIB", "ipNetToMediaType"), ("IP-MIB", "ipRoutingDiscards"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    ipGroup = ipGroup.setStatus('deprecated')
if mibBuilder.loadTexts: ipGroup.setDescription('The ip group of objects providing for basic management of IP entities, exclusive of the management of IP routes. As part of the version independence, this group has been deprecated. ')
icmpGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 2)).setObjects(("IP-MIB", "icmpInMsgs"), ("IP-MIB", "icmpInErrors"), ("IP-MIB", "icmpInDestUnreachs"), ("IP-MIB", "icmpInTimeExcds"), ("IP-MIB", "icmpInParmProbs"), ("IP-MIB", "icmpInSrcQuenchs"), ("IP-MIB", "icmpInRedirects"), ("IP-MIB", "icmpInEchos"), ("IP-MIB", "icmpInEchoReps"), ("IP-MIB", "icmpInTimestamps"), ("IP-MIB", "icmpInTimestampReps"), ("IP-MIB", "icmpInAddrMasks"), ("IP-MIB", "icmpInAddrMaskReps"), ("IP-MIB", "icmpOutMsgs"), ("IP-MIB", "icmpOutErrors"), ("IP-MIB", "icmpOutDestUnreachs"), ("IP-MIB", "icmpOutTimeExcds"), ("IP-MIB", "icmpOutParmProbs"), ("IP-MIB", "icmpOutSrcQuenchs"), ("IP-MIB", "icmpOutRedirects"), ("IP-MIB", "icmpOutEchos"), ("IP-MIB", "icmpOutEchoReps"), ("IP-MIB", "icmpOutTimestamps"), ("IP-MIB", "icmpOutTimestampReps"), ("IP-MIB", "icmpOutAddrMasks"), ("IP-MIB", "icmpOutAddrMaskReps"))
if getattr(mibBuilder, 'version', (0, 0, 0)) > (4, 4, 0):
    icmpGroup = icmpGroup.setStatus('deprecated')
if mibBuilder.loadTexts: icmpGroup.setDescription('The icmp group of objects providing ICMP statistics. As part of the version independence, this group has been deprecated. ')
mibBuilder.exportSymbols("IP-MIB", ipAddressPrefixGroup=ipAddressPrefixGroup, ipSystemStatsHCOctetGroup=ipSystemStatsHCOctetGroup, ipGroup=ipGroup, ipIfStatsHCPacketGroup=ipIfStatsHCPacketGroup, ipv4InterfaceReasmMaxSize=ipv4InterfaceReasmMaxSize, ipRoutingDiscards=ipRoutingDiscards, icmpOutTimeExcds=icmpOutTimeExcds, ipOutNoRoutes=ipOutNoRoutes, ipIfStatsOutDiscards=ipIfStatsOutDiscards, ipAdEntIfIndex=ipAdEntIfIndex, icmpInEchoReps=icmpInEchoReps, ipSystemStatsHCInMcastPkts=ipSystemStatsHCInMcastPkts, ipSystemStatsGroup=ipSystemStatsGroup, ipv4SystemStatsHCPacketGroup=ipv4SystemStatsHCPacketGroup, ipv6RouterAdvertIfIndex=ipv6RouterAdvertIfIndex, ipSystemStatsEntry=ipSystemStatsEntry, icmpOutRedirects=icmpOutRedirects, ipIfStatsHCInReceives=ipIfStatsHCInReceives, ipNetToMediaTable=ipNetToMediaTable, ipSystemStatsOutFragFails=ipSystemStatsOutFragFails, ipNetToPhysicalEntry=ipNetToPhysicalEntry, ipIfStatsHCInForwDatagrams=ipIfStatsHCInForwDatagrams, ipIfStatsDiscontinuityTime=ipIfStatsDiscontinuityTime, ipAddrEntry=ipAddrEntry, ipv6RouterAdvertSendAdverts=ipv6RouterAdvertSendAdverts, ipv6ScopeZoneIndexB=ipv6ScopeZoneIndexB, icmpInEchos=icmpInEchos, ipIfStatsHCOutForwDatagrams=ipIfStatsHCOutForwDatagrams, ipIfStatsHCOutRequests=ipIfStatsHCOutRequests, ipSystemStatsOutMcastPkts=ipSystemStatsOutMcastPkts, ipIfStatsInAddrErrors=ipIfStatsInAddrErrors, ipv6ScopeZoneIndex6=ipv6ScopeZoneIndex6, ipDefaultRouterIfIndex=ipDefaultRouterIfIndex, ipv4IfStatsHCPacketGroup=ipv4IfStatsHCPacketGroup, ipIfStatsInMcastOctets=ipIfStatsInMcastOctets, ipSystemStatsOutDiscards=ipSystemStatsOutDiscards, ipv6InterfaceRetransmitTime=ipv6InterfaceRetransmitTime, ipSystemStatsHCOutOctets=ipSystemStatsHCOutOctets, icmpInDestUnreachs=icmpInDestUnreachs, ipv6RouterAdvertRowStatus=ipv6RouterAdvertRowStatus, ipSystemStatsInNoRoutes=ipSystemStatsInNoRoutes, ipAddressPrefixIfIndex=ipAddressPrefixIfIndex, ipNetToMediaNetAddress=ipNetToMediaNetAddress, ipIfStatsEntry=ipIfStatsEntry, ipAddressPrefixAdvPreferredLifetime=ipAddressPrefixAdvPreferredLifetime, ipv6RouterAdvertCurHopLimit=ipv6RouterAdvertCurHopLimit, ipv6RouterAdvertSpinLock=ipv6RouterAdvertSpinLock, ipOutRequests=ipOutRequests, icmpOutTimestampReps=icmpOutTimestampReps, ipv6IfGroup=ipv6IfGroup, ipMIBCompliance=ipMIBCompliance, ipAddressType=ipAddressType, ipForwarding=ipForwarding, ipSystemStatsHCInMcastOctets=ipSystemStatsHCInMcastOctets, ipSystemStatsHCOutMcastPkts=ipSystemStatsHCOutMcastPkts, ipNetToPhysicalType=ipNetToPhysicalType, ipv6ScopeZoneIndexC=ipv6ScopeZoneIndexC, ipDefaultRouterAddressType=ipDefaultRouterAddressType, ipSystemStatsHCInReceives=ipSystemStatsHCInReceives, ipNetToPhysicalTable=ipNetToPhysicalTable, ipIfStatsInTruncatedPkts=ipIfStatsInTruncatedPkts, ipIfStatsOutRequests=ipIfStatsOutRequests, ipv6RouterAdvertOtherConfigFlag=ipv6RouterAdvertOtherConfigFlag, ipMIBConformance=ipMIBConformance, ipInReceives=ipInReceives, ipReasmReqds=ipReasmReqds, ipIfStatsOutFragCreates=ipIfStatsOutFragCreates, ipIfStatsOutBcastPkts=ipIfStatsOutBcastPkts, ipv6InterfaceEnableStatus=ipv6InterfaceEnableStatus, ipSystemStatsInMcastPkts=ipSystemStatsInMcastPkts, ipAdEntAddr=ipAdEntAddr, ipIfStatsGroup=ipIfStatsGroup, ipIfStatsTableLastChange=ipIfStatsTableLastChange, ipSystemStatsOutNoRoutes=ipSystemStatsOutNoRoutes, ipLastChangeGroup=ipLastChangeGroup, icmpInErrors=icmpInErrors, ipInHdrErrors=ipInHdrErrors, ipIfStatsHCOutMcastPkts=ipIfStatsHCOutMcastPkts, icmpStatsOutMsgs=icmpStatsOutMsgs, ipAddrTable=ipAddrTable, ipv4InterfaceTable=ipv4InterfaceTable, ipNetToPhysicalGroup=ipNetToPhysicalGroup, icmpOutErrors=icmpOutErrors, ipSystemStatsInMcastOctets=ipSystemStatsInMcastOctets, ipIfStatsInHdrErrors=ipIfStatsInHdrErrors, ipIfStatsInMcastPkts=ipIfStatsInMcastPkts, ipAddressPrefixOrigin=ipAddressPrefixOrigin, IpAddressPrefixOriginTC=IpAddressPrefixOriginTC, ipOutDiscards=ipOutDiscards, ipNetToMediaIfIndex=ipNetToMediaIfIndex, icmpInTimeExcds=icmpInTimeExcds, icmpOutSrcQuenchs=icmpOutSrcQuenchs, ipIfStatsHCInOctets=ipIfStatsHCInOctets, ipIfStatsHCOutOctets=ipIfStatsHCOutOctets, ipIfStatsOutMcastOctets=ipIfStatsOutMcastOctets, ipSystemStatsInDelivers=ipSystemStatsInDelivers, ipSystemStatsHCOutMcastOctets=ipSystemStatsHCOutMcastOctets, ipAddressPrefixEntry=ipAddressPrefixEntry, ipAddressOrigin=ipAddressOrigin, ipv6RouterAdvertTable=ipv6RouterAdvertTable, ipSystemStatsHCOutTransmits=ipSystemStatsHCOutTransmits, icmpOutTimestamps=icmpOutTimestamps, ipSystemStatsHCOutForwDatagrams=ipSystemStatsHCOutForwDatagrams, ipv4InterfaceIfIndex=ipv4InterfaceIfIndex, ipv6ScopeZoneIndexD=ipv6ScopeZoneIndexD, icmpGroup=icmpGroup, ipSystemStatsInOctets=ipSystemStatsInOctets, ipv6RouterAdvertManagedFlag=ipv6RouterAdvertManagedFlag, icmp=icmp, ipv6InterfaceForwarding=ipv6InterfaceForwarding, ipIfStatsInForwDatagrams=ipIfStatsInForwDatagrams, ipAddressPrefixAdvValidLifetime=ipAddressPrefixAdvValidLifetime, ipv6RouterAdvertMaxInterval=ipv6RouterAdvertMaxInterval, ipSystemStatsOutFragOKs=ipSystemStatsOutFragOKs, ipSystemStatsHCInForwDatagrams=ipSystemStatsHCInForwDatagrams, ipIfStatsIfIndex=ipIfStatsIfIndex, ipAddressRowStatus=ipAddressRowStatus, icmpInParmProbs=icmpInParmProbs, ipv4InterfaceEnableStatus=ipv4InterfaceEnableStatus, ipTrafficStats=ipTrafficStats, ipv6ScopeZoneIndexA=ipv6ScopeZoneIndexA, ipDefaultRouterGroup=ipDefaultRouterGroup, ipForwDatagrams=ipForwDatagrams, ipAddressPrefixTable=ipAddressPrefixTable, ipIfStatsInUnknownProtos=ipIfStatsInUnknownProtos, ipAdEntReasmMaxSize=ipAdEntReasmMaxSize, ipSystemStatsOutBcastPkts=ipSystemStatsOutBcastPkts, ipIfStatsReasmReqds=ipIfStatsReasmReqds, icmpMsgStatsIPVersion=icmpMsgStatsIPVersion, ipSystemStatsHCOutRequests=ipSystemStatsHCOutRequests, ipIfStatsOutOctets=ipIfStatsOutOctets, ipNetToPhysicalNetAddress=ipNetToPhysicalNetAddress, ipv6InterfaceReachableTime=ipv6InterfaceReachableTime, icmpStatsGroup=icmpStatsGroup, ipv6InterfaceTableLastChange=ipv6InterfaceTableLastChange, ipv6RouterAdvertEntry=ipv6RouterAdvertEntry, ipSystemStatsHCPacketGroup=ipSystemStatsHCPacketGroup, ipIfStatsHCInMcastPkts=ipIfStatsHCInMcastPkts, icmpMsgStatsInPkts=icmpMsgStatsInPkts, ipSystemStatsInAddrErrors=ipSystemStatsInAddrErrors, ipSystemStatsIPVersion=ipSystemStatsIPVersion, ipNetToPhysicalNetAddressType=ipNetToPhysicalNetAddressType, ipInDelivers=ipInDelivers, ipSystemStatsHCInOctets=ipSystemStatsHCInOctets, icmpInMsgs=icmpInMsgs, ipSystemStatsInUnknownProtos=ipSystemStatsInUnknownProtos, ipReasmTimeout=ipReasmTimeout, icmpInSrcQuenchs=icmpInSrcQuenchs, icmpStatsIPVersion=icmpStatsIPVersion, icmpStatsInMsgs=icmpStatsInMsgs, ipIfStatsInNoRoutes=ipIfStatsInNoRoutes, ipIfStatsHCInMcastOctets=ipIfStatsHCInMcastOctets, ipIfStatsHCInDelivers=ipIfStatsHCInDelivers, ipAddressPrefixAutonomousFlag=ipAddressPrefixAutonomousFlag, ipAdEntBcastAddr=ipAdEntBcastAddr, ipSystemStatsInTruncatedPkts=ipSystemStatsInTruncatedPkts, icmpOutAddrMasks=icmpOutAddrMasks, ipIfStatsOutMcastPkts=ipIfStatsOutMcastPkts, ipIfStatsOutFragReqds=ipIfStatsOutFragReqds, ipNetToPhysicalRowStatus=ipNetToPhysicalRowStatus, ipIfStatsHCOctetGroup=ipIfStatsHCOctetGroup, ipMIBCompliances=ipMIBCompliances, icmpOutDestUnreachs=icmpOutDestUnreachs, ipv6ScopeZoneIndex9=ipv6ScopeZoneIndex9, icmpInTimestamps=icmpInTimestamps, ipv6IpDefaultHopLimit=ipv6IpDefaultHopLimit, ipv6ScopeZoneIndex3=ipv6ScopeZoneIndex3, ipv4InterfaceEntry=ipv4InterfaceEntry, ipv6InterfaceIfIndex=ipv6InterfaceIfIndex, ipIfStatsInDiscards=ipIfStatsInDiscards, ipNetToPhysicalState=ipNetToPhysicalState, ipDefaultRouterEntry=ipDefaultRouterEntry, ipIfStatsIPVersion=ipIfStatsIPVersion, icmpStatsInErrors=icmpStatsInErrors, ipv4InterfaceRetransmitTime=ipv4InterfaceRetransmitTime, ipv6InterfaceEntry=ipv6InterfaceEntry, ipSystemStatsOutRequests=ipSystemStatsOutRequests, ipSystemStatsOutMcastOctets=ipSystemStatsOutMcastOctets, ipAddressStatus=ipAddressStatus, ipIfStatsInReceives=ipIfStatsInReceives, ipAddressStorageType=ipAddressStorageType, icmpStatsTable=icmpStatsTable, ipv6RouterAdvertGroup=ipv6RouterAdvertGroup, ipIfStatsInBcastPkts=ipIfStatsInBcastPkts, ipv6GeneralGroup2=ipv6GeneralGroup2, ipAddressPrefixLength=ipAddressPrefixLength, ipAddressCreated=ipAddressCreated, ipDefaultRouterPreference=ipDefaultRouterPreference, ipNetToMediaEntry=ipNetToMediaEntry, ipAddressIfIndex=ipAddressIfIndex, ipSystemStatsTable=ipSystemStatsTable, ipSystemStatsOutFragReqds=ipSystemStatsOutFragReqds, ipSystemStatsHCInDelivers=ipSystemStatsHCInDelivers, ipSystemStatsInForwDatagrams=ipSystemStatsInForwDatagrams, ipSystemStatsOutTransmits=ipSystemStatsOutTransmits, icmpOutEchos=icmpOutEchos, ipFragCreates=ipFragCreates, ipIfStatsInOctets=ipIfStatsInOctets, icmpStatsEntry=icmpStatsEntry, ipv6RouterAdvertLinkMTU=ipv6RouterAdvertLinkMTU, ipv6InterfaceTable=ipv6InterfaceTable, ipMIBCompliance2=ipMIBCompliance2, ipSystemStatsInDiscards=ipSystemStatsInDiscards, ipDefaultRouterLifetime=ipDefaultRouterLifetime, ipMIBGroups=ipMIBGroups, ipSystemStatsInHdrErrors=ipSystemStatsInHdrErrors, ipv4IfStatsGroup=ipv4IfStatsGroup, ipv6RouterAdvertMinInterval=ipv6RouterAdvertMinInterval, ipv6ScopeGroup=ipv6ScopeGroup, ipIfStatsRefreshRate=ipIfStatsRefreshRate, ipv6InterfaceReasmMaxSize=ipv6InterfaceReasmMaxSize, icmpOutMsgs=icmpOutMsgs, icmpOutAddrMaskReps=icmpOutAddrMaskReps, ipAddressAddr=ipAddressAddr, ipv6ScopeZoneIndexSiteLocal=ipv6ScopeZoneIndexSiteLocal, ipAdEntNetMask=ipAdEntNetMask, ip=ip, ipIfStatsReasmFails=ipIfStatsReasmFails, ipv6IpForwarding=ipv6IpForwarding, ipSystemStatsHCOutBcastPkts=ipSystemStatsHCOutBcastPkts, ipSystemStatsReasmReqds=ipSystemStatsReasmReqds, ipIfStatsOutFragFails=ipIfStatsOutFragFails, ipv4SystemStatsGroup=ipv4SystemStatsGroup, ipAddressGroup=ipAddressGroup, ipReasmOKs=ipReasmOKs, ipMIB=ipMIB, icmpInRedirects=icmpInRedirects, ipv6ScopeZoneIndex7=ipv6ScopeZoneIndex7, icmpMsgStatsEntry=icmpMsgStatsEntry, ipv4GeneralGroup=ipv4GeneralGroup, ipAddressPrefixType=ipAddressPrefixType, ipv6ScopeZoneIndexAdminLocal=ipv6ScopeZoneIndexAdminLocal, ipv6InterfaceIdentifier=ipv6InterfaceIdentifier, ipAddressSpinLock=ipAddressSpinLock, Ipv6AddressIfIdentifierTC=Ipv6AddressIfIdentifierTC, ipAddressPrefixOnLinkFlag=ipAddressPrefixOnLinkFlag, PYSNMP_MODULE_ID=ipMIB, ipIfStatsHCOutMcastOctets=ipIfStatsHCOutMcastOctets, ipAddressPrefix=ipAddressPrefix, ipv6ScopeZoneIndexTable=ipv6ScopeZoneIndexTable, ipv6ScopeZoneIndexLinkLocal=ipv6ScopeZoneIndexLinkLocal, ipv6ScopeZoneIndexOrganizationLocal=ipv6ScopeZoneIndexOrganizationLocal, icmpInAddrMaskReps=icmpInAddrMaskReps, icmpOutParmProbs=icmpOutParmProbs, ipv6ScopeZoneIndexEntry=ipv6ScopeZoneIndexEntry, ipSystemStatsRefreshRate=ipSystemStatsRefreshRate, ipSystemStatsDiscontinuityTime=ipSystemStatsDiscontinuityTime, ipSystemStatsOutForwDatagrams=ipSystemStatsOutForwDatagrams, ipv6RouterAdvertReachableTime=ipv6RouterAdvertReachableTime, icmpInTimestampReps=icmpInTimestampReps, ipInAddrErrors=ipInAddrErrors, icmpInAddrMasks=icmpInAddrMasks, ipSystemStatsInReceives=ipSystemStatsInReceives, ipIfStatsOutForwDatagrams=ipIfStatsOutForwDatagrams)
mibBuilder.exportSymbols("IP-MIB", icmpMsgStatsTable=icmpMsgStatsTable, ipv4InterfaceTableLastChange=ipv4InterfaceTableLastChange, ipReasmFails=ipReasmFails, ipDefaultTTL=ipDefaultTTL, ipSystemStatsReasmFails=ipSystemStatsReasmFails, ipv6RouterAdvertRetransmitTime=ipv6RouterAdvertRetransmitTime, ipIfStatsHCOutTransmits=ipIfStatsHCOutTransmits, icmpStatsOutErrors=icmpStatsOutErrors, ipAddressPrefixPrefix=ipAddressPrefixPrefix, ipIfStatsInDelivers=ipIfStatsInDelivers, ipAddressAddrType=ipAddressAddrType, icmpMsgStatsOutPkts=icmpMsgStatsOutPkts, ipv6ScopeZoneIndexIfIndex=ipv6ScopeZoneIndexIfIndex, ipSystemStatsOutFragCreates=ipSystemStatsOutFragCreates, ipSystemStatsOutOctets=ipSystemStatsOutOctets, ipIfStatsTable=ipIfStatsTable, icmpMsgStatsType=icmpMsgStatsType, ipAddressLastChanged=ipAddressLastChanged, ipDefaultRouterTable=ipDefaultRouterTable, IpAddressStatusTC=IpAddressStatusTC, ipAddressTable=ipAddressTable, ipInDiscards=ipInDiscards, ipFragOKs=ipFragOKs, ipDefaultRouterAddress=ipDefaultRouterAddress, ipFragFails=ipFragFails, ipv4IfGroup=ipv4IfGroup, ipAddressEntry=ipAddressEntry, ipNetToPhysicalIfIndex=ipNetToPhysicalIfIndex, ipIfStatsOutFragOKs=ipIfStatsOutFragOKs, ipv6RouterAdvertDefaultLifetime=ipv6RouterAdvertDefaultLifetime, ipNetToMediaType=ipNetToMediaType, ipNetToMediaPhysAddress=ipNetToMediaPhysAddress, IpAddressOriginTC=IpAddressOriginTC, icmpOutEchoReps=icmpOutEchoReps, ipIfStatsReasmOKs=ipIfStatsReasmOKs, ipSystemStatsHCInBcastPkts=ipSystemStatsHCInBcastPkts, ipIfStatsHCInBcastPkts=ipIfStatsHCInBcastPkts, ipIfStatsHCOutBcastPkts=ipIfStatsHCOutBcastPkts, ipIfStatsOutTransmits=ipIfStatsOutTransmits, ipInUnknownProtos=ipInUnknownProtos, ipNetToPhysicalPhysAddress=ipNetToPhysicalPhysAddress, ipSystemStatsReasmOKs=ipSystemStatsReasmOKs, ipSystemStatsInBcastPkts=ipSystemStatsInBcastPkts, ipNetToPhysicalLastUpdated=ipNetToPhysicalLastUpdated)
