"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnUser = exports.toJson_CfnUserProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnUserProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnUserProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'Password': obj.password,
        'LoginName': obj.loginName,
        'DisplayName': obj.displayName,
        'FirstName': obj.firstName,
        'MiddleName': obj.middleName,
        'LastName': obj.lastName,
        'Email': obj.email,
        'MustChangePassword': obj.mustChangePassword,
        'Disabled': obj.disabled,
        'DaysToExpiry': obj.daysToExpiry,
        'MinsToUnlock': obj.minsToUnlock,
        'DefaultWarehouse': obj.defaultWarehouse,
        'DefaultRole': obj.defaultRole,
        'MinsToBypassMfa': obj.minsToBypassMfa,
        'RsaPublicKey': obj.rsaPublicKey,
        'RsaPublicKey2': obj.rsaPublicKey2,
        'Comment': obj.comment,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnUserProps = toJson_CfnUserProps;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `Snowflake::User::User`
 *
 * @cloudformationResource Snowflake::User::User
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-snowflake-resource-providers.git
 */
class CfnUser extends cdk.CfnResource {
    /**
     * Create a new `Snowflake::User::User`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnUser.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnUserProps(props) });
        this.props = props;
    }
}
exports.CfnUser = CfnUser;
_a = JSII_RTTI_SYMBOL_1;
CfnUser[_a] = { fqn: "@cdk-cloudformation/snowflake-user-user.CfnUser", version: "1.0.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnUser.CFN_RESOURCE_TYPE_NAME = "Snowflake::User::User";
//# sourceMappingURL=data:application/json;base64,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