"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cloud9Env = void 0;
const codecommit = require("@aws-cdk/aws-codecommit");
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const cloud9 = require("../lib");
class Cloud9Env extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const vpc = new ec2.Vpc(this, 'VPC', {
            maxAzs: 2,
            natGateways: 1,
        });
        // create a codecommit repository to clone into the cloud9 environment
        const repo = new codecommit.Repository(this, 'Repo', {
            repositoryName: 'foo',
        });
        // create a cloud9 ec2 environment in a new VPC
        const c9env = new cloud9.Ec2Environment(this, 'C9Env', {
            vpc,
            // clone repositories into the environment
            clonedRepositories: [
                cloud9.CloneRepository.fromCodeCommit(repo, '/foo'),
            ],
        });
        new cdk.CfnOutput(this, 'URL', { value: c9env.ideUrl });
        new cdk.CfnOutput(this, 'ARN', { value: c9env.ec2EnvironmentArn });
    }
}
exports.Cloud9Env = Cloud9Env;
const app = new cdk.App();
new Cloud9Env(app, 'C9Stack');
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuY2xvdWQ5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcuY2xvdWQ5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHNEQUFzRDtBQUN0RCx3Q0FBd0M7QUFDeEMscUNBQXFDO0FBQ3JDLGlDQUFpQztBQUVqQyxNQUFhLFNBQVUsU0FBUSxHQUFHLENBQUMsS0FBSztJQUN0QyxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQXNCO1FBQ2xFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBRXhCLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsQ0FBQyxJQUFJLEVBQUUsS0FBSyxFQUFFO1lBQ25DLE1BQU0sRUFBRSxDQUFDO1lBQ1QsV0FBVyxFQUFFLENBQUM7U0FDZixDQUFDLENBQUM7UUFFSCxzRUFBc0U7UUFDdEUsTUFBTSxJQUFJLEdBQUcsSUFBSSxVQUFVLENBQUMsVUFBVSxDQUFDLElBQUksRUFBRSxNQUFNLEVBQUU7WUFDbkQsY0FBYyxFQUFFLEtBQUs7U0FDdEIsQ0FBQyxDQUFDO1FBRUgsK0NBQStDO1FBQy9DLE1BQU0sS0FBSyxHQUFHLElBQUksTUFBTSxDQUFDLGNBQWMsQ0FBQyxJQUFJLEVBQUUsT0FBTyxFQUFFO1lBQ3JELEdBQUc7WUFDSCwwQ0FBMEM7WUFDMUMsa0JBQWtCLEVBQUU7Z0JBQ2xCLE1BQU0sQ0FBQyxlQUFlLENBQUMsY0FBYyxDQUFDLElBQUksRUFBRSxNQUFNLENBQUM7YUFDcEQ7U0FDRixDQUFDLENBQUM7UUFDSCxJQUFJLEdBQUcsQ0FBQyxTQUFTLENBQUMsSUFBSSxFQUFFLEtBQUssRUFBRSxFQUFFLEtBQUssRUFBRSxLQUFLLENBQUMsTUFBTSxFQUFFLENBQUMsQ0FBQztRQUN4RCxJQUFJLEdBQUcsQ0FBQyxTQUFTLENBQUMsSUFBSSxFQUFFLEtBQUssRUFBRSxFQUFFLEtBQUssRUFBRSxLQUFLLENBQUMsaUJBQWlCLEVBQUUsQ0FBQyxDQUFDO0lBQ3JFLENBQUM7Q0FDRjtBQXpCRCw4QkF5QkM7QUFFRCxNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQztBQUUxQixJQUFJLFNBQVMsQ0FBQyxHQUFHLEVBQUUsU0FBUyxDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjb2RlY29tbWl0IGZyb20gJ0Bhd3MtY2RrL2F3cy1jb2RlY29tbWl0JztcbmltcG9ydCAqIGFzIGVjMiBmcm9tICdAYXdzLWNkay9hd3MtZWMyJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCAqIGFzIGNsb3VkOSBmcm9tICcuLi9saWInO1xuXG5leHBvcnQgY2xhc3MgQ2xvdWQ5RW52IGV4dGVuZHMgY2RrLlN0YWNrIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzPzogY2RrLlN0YWNrUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHByb3BzKTtcblxuICAgIGNvbnN0IHZwYyA9IG5ldyBlYzIuVnBjKHRoaXMsICdWUEMnLCB7XG4gICAgICBtYXhBenM6IDIsXG4gICAgICBuYXRHYXRld2F5czogMSxcbiAgICB9KTtcblxuICAgIC8vIGNyZWF0ZSBhIGNvZGVjb21taXQgcmVwb3NpdG9yeSB0byBjbG9uZSBpbnRvIHRoZSBjbG91ZDkgZW52aXJvbm1lbnRcbiAgICBjb25zdCByZXBvID0gbmV3IGNvZGVjb21taXQuUmVwb3NpdG9yeSh0aGlzLCAnUmVwbycsIHtcbiAgICAgIHJlcG9zaXRvcnlOYW1lOiAnZm9vJyxcbiAgICB9KTtcblxuICAgIC8vIGNyZWF0ZSBhIGNsb3VkOSBlYzIgZW52aXJvbm1lbnQgaW4gYSBuZXcgVlBDXG4gICAgY29uc3QgYzllbnYgPSBuZXcgY2xvdWQ5LkVjMkVudmlyb25tZW50KHRoaXMsICdDOUVudicsIHtcbiAgICAgIHZwYyxcbiAgICAgIC8vIGNsb25lIHJlcG9zaXRvcmllcyBpbnRvIHRoZSBlbnZpcm9ubWVudFxuICAgICAgY2xvbmVkUmVwb3NpdG9yaWVzOiBbXG4gICAgICAgIGNsb3VkOS5DbG9uZVJlcG9zaXRvcnkuZnJvbUNvZGVDb21taXQocmVwbywgJy9mb28nKSxcbiAgICAgIF0sXG4gICAgfSk7XG4gICAgbmV3IGNkay5DZm5PdXRwdXQodGhpcywgJ1VSTCcsIHsgdmFsdWU6IGM5ZW52LmlkZVVybCB9KTtcbiAgICBuZXcgY2RrLkNmbk91dHB1dCh0aGlzLCAnQVJOJywgeyB2YWx1ZTogYzllbnYuZWMyRW52aXJvbm1lbnRBcm4gfSk7XG4gIH1cbn1cblxuY29uc3QgYXBwID0gbmV3IGNkay5BcHAoKTtcblxubmV3IENsb3VkOUVudihhcHAsICdDOVN0YWNrJyk7XG4iXX0=