wirenames = { 0: "A0", 1: "B0", 2: "C0", 3: "D0", 4: "A1", 5: "B1", 6: "C1", 7: "D1", 8: "A2", 9: "B2", 10: "C2", 11: "D2", 12: "A3", 13: "B3", 14: "C3",
15: "D3", 16: "A4", 17: "B4", 18: "C4", 19: "D4", 20: "A5", 21: "B5", 22: "C5", 23: "D5", 24: "A6", 25: "B6", 26: "C6", 27: "D6", 28: "A7", 29: "B7",
30: "C7", 31: "D7", 32: "F0", 33: "F1", 34: "F2", 35: "F3", 36: "F4", 37: "F5", 38: "F6", 39: "F7", 40: "Q0", 41: "Q1", 42: "Q2", 43: "Q3", 44: "Q4",
45: "Q5", 46: "Q6", 47: "Q7", 48: "OF0", 49: "OF1", 50: "OF2", 51: "OF3", 52: "OF4", 53: "OF5", 54: "OF6", 55: "OF7", 56: "X01", 57: "X02", 58: "X03",
59: "X04", 60: "X05", 61: "X06", 62: "X07", 63: "X08", 64: "N100", 65: "SN10", 66: "SN20", 67: "N130", 68: "S100", 69: "S130", 70: "E100", 71: "EW10",
72: "EW20", 73: "E130", 74: "W100", 75: "W130", 76: "N200", 77: "N210", 78: "N220", 79: "N230", 80: "N240", 81: "N250", 82: "N260", 83: "N270", 84: "S200",
85: "S210", 86: "S220", 87: "S230", 88: "S240", 89: "S250", 90: "S260", 91: "S270", 92: "E200", 93: "E210", 94: "E220", 95: "E230", 96: "E240", 97: "E250",
98: "E260", 99: "E270", 100: "W200", 101: "W210", 102: "W220", 103: "W230", 104: "W240", 105: "W250", 106: "W260", 107: "W270", 108: "N800", 109: "N810",
110: "N820", 111: "N830", 112: "S800", 113: "S810", 114: "S820", 115: "S830", 116: "E800", 117: "E810", 118: "E820", 119: "E830", 120: "W800", 121: "W810",
122: "W820", 123: "W830", 124: "CLK0", 125: "CLK1", 126: "CLK2", 127: "LSR0", 128: "LSR1", 129: "LSR2", 130: "CE0", 131: "CE1", 132: "CE2", 133: "SEL0",
134: "SEL1", 135: "SEL2", 136: "SEL3", 137: "SEL4", 138: "SEL5", 139: "SEL6", 140: "SEL7", 141: "N101", 142: "N131", 143: "S101", 144: "S131", 145: "E101", 146: "E131",
147: "W101", 148: "W131", 149: "N201", 150: "N211", 151: "N221", 152: "N231", 153: "N241", 154: "N251", 155: "N261", 156: "N271", 157: "S201", 158: "S211",
159: "S221", 160: "S231", 161: "S241", 162: "S251", 163: "S261", 164: "S271", 165: "E201", 166: "E211", 167: "E221", 168: "E231", 169: "E241", 170: "E251",
171: "E261", 172: "E271", 173: "W201", 174: "W211", 175: "W221", 176: "W231", 177: "W241", 178: "W251", 179: "W261", 180: "W271", 181: "N202", 182: "N212",
183: "N222", 184: "N232", 185: "N242", 186: "N252", 187: "N262", 188: "N272", 189: "S202", 190: "S212", 191: "S222", 192: "S232", 193: "S242", 194: "S252",
195: "S262", 196: "S272", 197: "E202", 198: "E212", 199: "E222", 200: "E232", 201: "E242", 202: "E252", 203: "E262", 204: "E272", 205: "W202", 206: "W212",
207: "W222", 208: "W232", 209: "W242", 210: "W252", 211: "W262", 212: "W272", 213: "N804", 214: "N814", 215: "N824", 216: "N834", 217: "S804", 218: "S814",
219: "S824", 220: "S834", 221: "E804", 222: "E814", 223: "E824", 224: "E834", 225: "W804", 226: "W814", 227: "W824", 228: "W834", 229: "N808", 230: "N818",
231: "N828", 232: "N838", 233: "S808", 234: "S818", 235: "S828", 236: "S838", 237: "E808", 238: "E818", 239: "E828", 240: "E838", 241: "W808", 242: "W818",
243: "W828", 244: "W838", 245: "E110", 246: "W110", 247: "E120", 248: "W120", 249: "S110", 250: "N110", 251: "S120", 252: "N120", 253: "E111", 254: "W111",
255: "E121", 256: "W121", 257: "S111", 258: "N111", 259: "S121", 260: "N121", 261: "LB01", 262: "LB11", 263: "LB21", 264: "LB31", 265: "LB41", 266: "LB51",
267: "LB61", 268: "LB71", 269: "GB00", 270: "GB10", 271: "GB20", 272: "GB30", 273: "GB40", 274: "GB50", 275: "GB60", 276: "GB70", 277: "VCC", 278: "VSS",
279: "LT00", 280: "LT10", 281: "LT20", 282: "LT30", 283: "LT02", 284: "LT13", 285: "LT01", 286: "LT04", 287: "LBO0", 288: "LBO1", 289: "SS00", 290: "SS40",
291: "GT00", 292: "GT10", 293: "GBO0", 294: "GBO1", 295: "DI0", 296: "DI1", 297: "DI2", 298: "DI3", 299: "DI4", 300: "DI5", 301: "DI6", 302: "DI7",
303: "CIN0", 304: "CIN1", 305: "CIN2", 306: "CIN3", 307: "CIN4", 308: "CIN5", 309: "COUT0", 310: "COUT1", 311: "COUT2", 312: "COUT3", 313: "COUT4", 314: "COUT5"}
wirenames.update({n: f"LWSPINETL{n - 1001}" for n in range(1001, 1009)})
wirenames.update({n: f"LWSPINETR{n - 1009}" for n in range(1009, 1017)})
wirenames.update({n: f"LWSPINEBL{n - 1033}" for n in range(1033, 1041)})
wirenames.update({n: f"LWSPINEBR{n - 1041}" for n in range(1041, 1049)})

wirenumbers = {v: k for k, v in wirenames.items()}

clknames = wirenames.copy()
clknames.update({n: f"SPINE{n}" for n in range(32)})
clknames.update({n: f"LWT{n - 32}" for n in range(32, 40)})
clknames.update({n: f"LWB{n - 40}" for n in range(40, 48)})
# Apparently the names of the 8 primary clock wires comprise the quadrant
# number and the number of the actual clock wire: P34 stands for primary clock
# #4, 3rd quadrant. The quadrants are numbered counterclockwise:
# 2        1
#   center
# 3        4
# in addition, chips with two quadrants have quadrant numbers 3 and 4, not 1
# and 2 as you might expect.
# Wires 6 and 7 are the outputs of the dynamic 4-input MUX, the assumed
# numbers of these inputs are listed below:
clknames.update({
     48: 'P16A', 49: 'P16B', 50: 'P16C', 51: 'P16D',
     52: 'P17A', 53: 'P17B', 54: 'P17C', 55: 'P17D',
     56: 'P26A', 57: 'P26B', 58: 'P26C', 59: 'P26D',
     60: 'P27A', 61: 'P27B', 62: 'P27C', 63: 'P27D',
     64: 'P36A', 65: 'P36B', 66: 'P36C', 67: 'P36D',
     68: 'P37A', 69: 'P37B', 70: 'P37C', 71: 'P37D',
     72: 'P46A', 73: 'P46B', 74: 'P46C', 75: 'P46D',
     76: 'P47A', 77: 'P47B', 78: 'P47C', 79: 'P47D'
})
clknames[80] = 'VSS'
# each PLL has 4 delay-critical outputs (clkout, clkoutp, clkoutd, clkoutd3),
# their numbers are listed here, the names indicate the possible location of
# the PLL (Top Left etc):
clknames.update({
    81: 'TLPLL0CLK0', 82: 'TLPLL0CLK1', 83: 'TLPLL0CLK2', 84: 'TLPLL0CLK3',
    85: 'TLPLL1CLK0', 86: 'TLPLL1CLK1', 87: 'TLPLL1CLK2', 88: 'TLPLL1CLK3',
    89: 'BLPLL0CLK0', 90: 'BLPLL0CLK1', 91: 'BLPLL0CLK2', 92: 'BLPLL0CLK3',
    93: 'TRPLL0CLK0', 94: 'TRPLL0CLK1', 95: 'TRPLL0CLK2', 96: 'TRPLL0CLK3',
    97: 'TRPLL1CLK0', 98: 'TRPLL1CLK1', 99: 'TRPLL1CLK2', 100: 'TRPLL1CLK3',
    101: 'BRPLL0CLK0', 102: 'BRPLL0CLK1', 103: 'BRPLL0CLK2', 104: 'BRPLL0CLK3',
})
clknames.update({n: f"UNK{n}" for n in range(105, 121)})
# These are the external clock pins, one on each side
clknames.update({
    121: 'PCLKT0', 122: 'PCLKT1', 123: 'PCLKB0', 124: 'PCLKB1',
    125: 'PCLKL0', 126: 'PCLKL1', 127: 'PCLKR0', 128: 'PCLKR1',
})
clknames.update({n: f"UNK{n}" for n in range(129, 153)})
clknames[153] = 'VCC'
clknames.update({n: f"UNK{n}" for n in range(154, 186)})
# These wires are a mystery, they are a copy of P10-P15 etc, there is no reason
# to have another number for the output, but it is these numbers that are
# listed in tables 38, although the internal routes are routed to the
# originals.
# In general they are needed and the letter A is added to make the names
# different.
clknames.update({
     186: 'P10A', 187: 'P11A', 188: 'P12A', 189: 'P13A', 190: 'P14A', 191: 'P15A',
     192: 'P20A', 193: 'P21A', 194: 'P22A', 195: 'P23A', 196: 'P24A', 197: 'P25A',
     198: 'P30A', 199: 'P31A', 200: 'P32A', 201: 'P33A', 202: 'P34A', 203: 'P35A',
     204: 'P40A', 205: 'P41A', 206: 'P42A', 207: 'P43A', 208: 'P44A', 209: 'P45A',
})

clknames.update({n: f"UNK{n}" for n in range(210, 261)})

clknumbers = {v: k for k, v in clknames.items()}
