# Generated by Django 2.2.22 on 2021-06-02 10:40

import django.db.models.deletion
import django.utils.timezone
import simpl.utils.models
from django.conf import settings
from django.db import migrations, models

try:
    from django.db.models import JSONField
except ImportError:
    from django.contrib.postgres.fields import JSONField


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        migrations.swappable_dependency(settings.SIMPL_INSTANCE),
        migrations.swappable_dependency(settings.SIMPL_CHARACTER),
        migrations.swappable_dependency(settings.SIMPL_GAME_EXPERIENCE),
        migrations.swappable_dependency(settings.SIMPL_RUN),
        migrations.swappable_dependency(settings.SIMPL_PLAYER),
    ]

    operations = [
        migrations.CreateModel(
            name="Character",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=200, verbose_name="In-game name")),
                (
                    "data",
                    JSONField(blank=True, default=dict, editable=False),
                ),
            ],
            options={"swappable": "SIMPL_CHARACTER"},
            bases=(simpl.utils.models.DataMixin, models.Model),
        ),
        migrations.CreateModel(
            name="GameExperience",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "date_created",
                    models.DateTimeField(
                        default=django.utils.timezone.now, editable=False
                    ),
                ),
                ("version", models.CharField(blank=True, max_length=20)),
                (
                    "marketplace_key",
                    models.CharField(db_index=True, max_length=36, null=True),
                ),
            ],
            options={"swappable": "SIMPL_GAME_EXPERIENCE"},
        ),
        migrations.CreateModel(
            name="Lobby",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255)),
                (
                    "date_created",
                    models.DateTimeField(
                        default=django.utils.timezone.now, editable=False
                    ),
                ),
                ("ready", models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name="Run",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Name of the run, for administration use.",
                        max_length=100,
                    ),
                ),
                (
                    "public_name",
                    models.CharField(
                        help_text="Publically visible name of the game.", max_length=100
                    ),
                ),
                (
                    "date_created",
                    models.DateTimeField(
                        default=django.utils.timezone.now, editable=False
                    ),
                ),
                ("multiplayer", models.BooleanField(default=True)),
                (
                    "status",
                    models.PositiveSmallIntegerField(
                        choices=[
                            (0, "Setup"),
                            (1, "Players Prepare"),
                            (2, "Play"),
                            (3, "Debrief"),
                            (4, "Complete"),
                        ],
                        default=0,
                    ),
                ),
                (
                    "marketplace_key",
                    models.CharField(blank=True, db_index=True, max_length=36),
                ),
                ("marketplace_open", models.BooleanField(blank=True, null=True)),
                ("marketplace_closed", models.DateTimeField(blank=True, null=True)),
                (
                    "game",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.SIMPL_GAME_EXPERIENCE,
                    ),
                ),
            ],
            options={"ordering": ("-date_created",), "swappable": "SIMPL_RUN"},
        ),
        migrations.CreateModel(
            name="Player",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "player_key",
                    models.CharField(blank=True, db_index=True, max_length=36),
                ),
                ("ready", models.BooleanField(default=True)),
                ("completed", models.DateTimeField(blank=True, null=True)),
                (
                    "character",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.SIMPL_CHARACTER,
                    ),
                ),
                (
                    "lobby",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="simpl.Lobby",
                    ),
                ),
                (
                    "run",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.SIMPL_RUN,
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={"swappable": "SIMPL_PLAYER"},
        ),
        migrations.AddField(
            model_name="lobby",
            name="run",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to=settings.SIMPL_RUN
            ),
        ),
        migrations.CreateModel(
            name="Instance",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "date_created",
                    models.DateTimeField(
                        default=django.utils.timezone.now, editable=False
                    ),
                ),
                ("date_start", models.DateTimeField(blank=True, null=True)),
                ("date_end", models.DateTimeField(blank=True, null=True)),
                ("name", models.CharField(blank=True, max_length=100)),
                (
                    "data",
                    JSONField(blank=True, default=dict, editable=False),
                ),
                (
                    "game",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.SIMPL_GAME_EXPERIENCE,
                    ),
                ),
                (
                    "run",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.SIMPL_RUN,
                    ),
                ),
            ],
            options={"swappable": "SIMPL_INSTANCE"},
            bases=(simpl.utils.models.DataMixin, models.Model),
        ),
        migrations.AddField(
            model_name="character",
            name="instance",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to=settings.SIMPL_INSTANCE
            ),
        ),
        migrations.AddField(
            model_name="character",
            name="user",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to=settings.AUTH_USER_MODEL,
            ),
        ),
    ]
